/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.OETLProcessorConfigurator;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.http.OServerCommandETL;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;

public class OETLPlugin
extends OServerPluginAbstract {
    private OServer server;

    public void executeJob(String jsonConfig, String outDBConfigPath, OPluginMessageHandler messageHandler) {
        System.out.println("OrientDB etl v." + OConstants.getVersion() + " " + "https://www.orientdb.com");
        if (jsonConfig == null) {
            System.out.println("Syntax error, missing configuration file.");
        } else {
            String[] args = new String[]{outDBConfigPath};
            OETLProcessor processor = new OETLProcessorConfigurator().parseConfigAndParameters(args);
            if (messageHandler.getOutputManagerLevel() != OETLContextWrapper.getInstance().getMessageHandler().getOutputManagerLevel()) {
                OETLContextWrapper.getInstance().setMessageHandler(messageHandler);
            }
            processor.execute();
        }
    }

    public String getName() {
        return "etl";
    }

    public void startup() {
        OServerNetworkListener listener = this.server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
        if (listener == null) {
            throw new OConfigurationException("HTTP listener not found");
        }
        listener.registerStatelessCommand((OServerCommand)new OServerCommandETL());
    }

    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.server = oServer;
    }

    public void shutdown() {
        super.shutdown();
    }
}

