/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.block;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.etl.block.OETLAbstractBlock;

public class OETLLetBlock
extends OETLAbstractBlock {
    protected String name;
    protected OSQLFilter expression;
    protected Object value;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[{name:{optional:false,description:'Variable name'}},{value:{optional:true,description:'Variable value'}}{expression:{optional:true,description:'Expression to evaluate'}}]}");
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
        this.name = (String)iConfiguration.field("name");
        if (iConfiguration.containsField("value")) {
            this.value = iConfiguration.field("value");
        } else {
            this.expression = new OSQLFilter((String)iConfiguration.field("expression"), iContext, null);
        }
        if (this.value == null && this.expression == null) {
            throw new IllegalArgumentException("'value' or 'expression' parameter are mandatory in Let Transformer");
        }
    }

    @Override
    public String getName() {
        return "let";
    }

    @Override
    public Object executeBlock() {
        Object v = this.expression != null ? this.expression.evaluate(null, null, this.context) : this.resolve(this.value);
        this.context.setVariable(this.name, v);
        return v;
    }
}

