/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.extractor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLExtractedItem;
import com.orientechnologies.orient.etl.extractor.OETLAbstractSourceExtractor;
import com.orientechnologies.orient.etl.extractor.OETLExtractorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;

public class OETLRowExtractor
extends OETLAbstractSourceExtractor {
    protected BufferedReader bReader;
    protected OETLExtractedItem next;
    protected boolean multiLine = true;
    protected String lineFeed = "\r\n";

    @Override
    public String getName() {
        return "row";
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
        if (iConfiguration.containsField("multiLine")) {
            this.multiLine = (Boolean)iConfiguration.field("multiLine");
        }
        if (iConfiguration.containsField("lineFeed")) {
            this.lineFeed = (String)iConfiguration.field("lineFeed");
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.bReader == null) {
            return false;
        }
        try {
            this.next = this.fetchNext();
            return this.next != null;
        }
        catch (IOException e) {
            throw new OETLExtractorException(e);
        }
    }

    @Override
    public OETLExtractedItem next() {
        if (this.next != null) {
            OETLExtractedItem ret = this.next;
            this.next = null;
            return ret;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("EOF");
        }
        try {
            return this.fetchNext();
        }
        catch (IOException e) {
            throw new OETLExtractorException(e);
        }
    }

    @Override
    public void extract(Reader iReader) {
        super.extract(iReader);
        this.bReader = new BufferedReader(this.reader);
    }

    @Override
    public void end() {
        if (this.bReader != null) {
            try {
                this.bReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.end();
    }

    @Override
    public String getUnit() {
        return "rows";
    }

    protected OETLExtractedItem fetchNext() throws IOException {
        if (!this.bReader.ready()) {
            return null;
        }
        String line = this.readLine();
        if (line == null || line.isEmpty()) {
            return null;
        }
        return new OETLExtractedItem(this.current++, line);
    }

    protected String readLine() throws IOException {
        if (this.multiLine) {
            StringBuilder sbLine = new StringBuilder();
            boolean isOpenQuote = false;
            do {
                String l;
                if (isOpenQuote) {
                    sbLine.append(this.lineFeed);
                }
                if ((l = this.bReader.readLine()) == null) break;
                sbLine.append(l);
                for (char c : l.toCharArray()) {
                    if ('\"' != c) continue;
                    isOpenQuote = !isOpenQuote;
                }
            } while (isOpenQuote);
            return sbLine.toString();
        }
        return this.bReader.readLine();
    }
}

