/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.extractor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLExtractedItem;
import com.orientechnologies.orient.etl.extractor.OETLAbstractSourceExtractor;
import com.orientechnologies.orient.etl.extractor.OETLExtractorException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OETLXmlExtractor
extends OETLAbstractSourceExtractor {
    protected List items = new ArrayList();
    private Collection<String> tagsAsAttribute = new HashSet<String>();
    private String rootNode;

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
        if (iConfiguration.containsField("rootNode")) {
            this.rootNode = (String)iConfiguration.field("rootNode");
        }
        if (iConfiguration.containsField("tagsAsAttribute")) {
            this.tagsAsAttribute = (Collection)iConfiguration.field("tagsAsAttribute");
        }
    }

    @Override
    public boolean hasNext() {
        return this.current < (long)this.items.size();
    }

    @Override
    public OETLExtractedItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("EOF");
        }
        return new OETLExtractedItem(this.current, this.items.get((int)this.current++));
    }

    @Override
    public void extract(Reader iReader) {
        super.extract(iReader);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            InputSource is = new InputSource(iReader);
            Document xmlDocument = dBuilder.parse(is);
            xmlDocument.getDocumentElement().normalize();
            Object res = this.xml2doc(xmlDocument);
            if (res instanceof Collection) {
                this.items.addAll((Collection)res);
            } else {
                this.items.add(res);
            }
        }
        catch (ParserConfigurationException e) {
            throw new OETLExtractorException("[XML extractor] error on creating XML parser", e);
        }
        catch (Exception e) {
            throw new OETLExtractorException("[XML extractor] error on parsing XML", e);
        }
    }

    private Object xml2doc(Node xmlDocument) {
        return this.xml2doc(xmlDocument, "", 0);
    }

    private Object xml2doc(Node xmlDocument, String iPath, int iLevel) {
        NodeList children;
        ODocument doc;
        Object result = doc = new ODocument();
        NamedNodeMap attrs = xmlDocument.getAttributes();
        if (attrs != null) {
            block6: for (int i = 0; i < attrs.getLength(); ++i) {
                Node item = attrs.item(i);
                switch (item.getNodeType()) {
                    case 2: {
                        Attr attr = (Attr)item;
                        doc.field(attr.getName(), (Object)attr.getValue());
                        continue block6;
                    }
                }
            }
        }
        if ((children = xmlDocument.getChildNodes()) != null) {
            block7: for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                switch (child.getNodeType()) {
                    case 1: {
                        String path;
                        Element element = (Element)child;
                        String string = path = iPath.isEmpty() ? element.getNodeName() : iPath + "." + element.getNodeName();
                        if (this.tagsAsAttribute.contains(iPath)) {
                            NodeList subChildren = element.getChildNodes();
                            if (subChildren.getLength() <= 0) continue block7;
                            Node fieldContent = subChildren.item(0);
                            doc.field(element.getNodeName(), (Object)fieldContent.getTextContent());
                            continue block7;
                        }
                        Object sub = this.xml2doc(element, path, iLevel + 1);
                        Object previous = doc.field(element.getNodeName());
                        if (previous != null) {
                            ArrayList<Object> list;
                            if (previous instanceof List) {
                                list = (ArrayList<Object>)previous;
                            } else {
                                list = new ArrayList<Object>();
                                list.add(previous);
                                doc.field(element.getNodeName(), list, new OType[]{OType.EMBEDDEDLIST});
                            }
                            list.add(sub);
                        } else {
                            doc.field(element.getNodeName(), sub, new OType[]{OType.EMBEDDED});
                        }
                        if (this.rootNode == null || !this.rootNode.startsWith(path)) continue block7;
                        result = doc.field(element.getNodeName());
                        continue block7;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[],output:'ODocument'}");
    }

    @Override
    public String getUnit() {
        return "entries";
    }

    @Override
    public String getName() {
        return "xml";
    }
}

