/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLComponentFactory;
import com.orientechnologies.orient.etl.block.OETLBlock;
import com.orientechnologies.orient.etl.transformer.OETLAbstractTransformer;

public class OETLBlockTransformer
extends OETLAbstractTransformer {
    private OETLBlock block;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{block:{optional:false,description:'Block to execute'}}]}");
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
    }

    @Override
    public void begin(ODatabaseDocument db) {
        super.begin(db);
        String[] fieldNames = this.configuration.fieldNames();
        try {
            String fieldName = fieldNames[0];
            this.block = new OETLComponentFactory().getBlock(fieldName);
            this.block.configure((ODocument)this.configuration.field(fieldName), this.context);
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OConfigurationException("[Block transformer] Error on configuring inner block"), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "block";
    }

    @Override
    public void setContext(OCommandContext context) {
        this.block.setContext(context);
    }

    @Override
    protected Object executeTransform(ODatabaseDocument db, Object input) {
        this.context.setVariable("input", input);
        this.block.execute();
        return input;
    }
}

