/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.transformer.OETLAbstractTransformer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class OETLCodeTransformer
extends OETLAbstractTransformer {
    private final Map<Object, Object> params = new HashMap<Object, Object>();
    private String language = "javascript";
    private OCommandExecutorScript cmd;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{language:{optional:true,description:'Code language, default is Javascript'}},{code:{optional:false,description:'Code to execute'}}]}");
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
        if (iConfiguration.containsField("language")) {
            this.language = (String)iConfiguration.field("language");
        }
        if (!iConfiguration.containsField("code")) {
            throw new IllegalArgumentException("'code' parameter is mandatory in Code Transformer");
        }
        String code = (String)iConfiguration.field("code");
        this.cmd = new OCommandExecutorScript().parse((OCommandRequest)new OCommandScript(this.language, code));
    }

    @Override
    public String getName() {
        return "code";
    }

    @Override
    public Object executeTransform(ODatabaseDocument db, Object input) {
        if (input == null) {
            return null;
        }
        this.params.put("input", input);
        if (input instanceof OIdentifiable) {
            this.params.put("record", ((OIdentifiable)input).getRecord());
        }
        try {
            Object result = this.cmd.executeInContext(this.context, this.params);
            this.log(Level.FINE, "executed code=%s, result=%s", this.cmd, result);
            return result;
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "exception=%s - input=%s - command=%s ", e.getMessage(), input, this.cmd);
            throw e;
        }
    }
}

