/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.etl.transformer.OETLAbstractTransformer;
import java.util.List;
import java.util.logging.Level;

public class OETLFieldTransformer
extends OETLAbstractTransformer {
    private String fieldName;
    private List<String> fieldNames;
    private String expression;
    private Object value;
    private boolean setOperation = true;
    private OSQLFilter sqlFilter;
    private boolean save = false;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{fieldName:{optional:true,description:'field name to apply the result'}},{fieldNames:{optional:true,description:'field names to apply the result'}},{expression:{optional:true,description:'expression to evaluate. Mandatory with operation=set (default)'}}{value:{optional:true,description:'value to set'}}{operation:{optional:false,description:'operation to execute against the field: set, remove. Default is set'}}{save:{optional:true,description:'save the vertex/edge/document right after the setting of the field'}}],input:['ODocument'],output:'ODocument'}");
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
        this.fieldName = (String)this.resolve(iConfiguration.field("fieldName"));
        this.fieldNames = (List)this.resolve(iConfiguration.field("fieldNames"));
        if (this.fieldNames == null && this.fieldName == null) {
            throw new IllegalArgumentException("Field transformer must specify 'fieldName' or 'fieldNames'");
        }
        this.expression = (String)iConfiguration.field("expression");
        this.value = iConfiguration.field("value");
        if (this.expression != null && this.value != null) {
            throw new IllegalArgumentException("Field transformer cannot specify both 'expression' and 'value'");
        }
        if (iConfiguration.containsField("save")) {
            this.save = (Boolean)iConfiguration.field("save");
        }
        if (iConfiguration.containsField("operation")) {
            this.setOperation = "set".equalsIgnoreCase((String)iConfiguration.field("operation"));
        }
    }

    @Override
    public String getName() {
        return "field";
    }

    @Override
    public Object executeTransform(ODatabaseDocument db, Object input) {
        ORecord rec;
        if (input instanceof OIdentifiable && (rec = ((OIdentifiable)input).getRecord()) instanceof ODocument) {
            ODocument doc = (ODocument)rec;
            if (this.setOperation) {
                Object newValue;
                if (this.expression != null) {
                    if (this.sqlFilter == null) {
                        this.sqlFilter = new OSQLFilter(this.expression, this.context, null);
                    }
                    newValue = this.sqlFilter.evaluate((OIdentifiable)doc, null, this.context);
                } else {
                    newValue = this.value;
                }
                doc.field(this.fieldName, newValue);
                this.log(Level.FINE, "set %s=%s in document=%s", this.fieldName, newValue, doc);
            } else if (this.fieldName != null) {
                Object prev = doc.removeField(this.fieldName);
                this.log(Level.FINE, "removed %s (value=%s) from document=%s", this.fieldName, prev, doc);
            } else {
                for (String f : this.fieldNames) {
                    Object prev = doc.removeField(f);
                    this.log(Level.FINE, "removed %s (value=%s) from document=%s", f, prev, doc);
                }
            }
            if (this.save) {
                this.log(Level.FINE, "saving record %s", doc.toJSON());
                db.save((Object)doc);
                this.log(Level.FINE, "saved record %s", doc.toJSON());
            }
        }
        return input;
    }
}

