/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.transformer.OETLAbstractLookupTransformer;
import java.util.logging.Level;

public class OETLLoadTransformer
extends OETLAbstractLookupTransformer {
    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{joinFieldName:{optional:false,description:'field name containing the value to join'}},{lookup:{optional:false,description:'<Class>.<property> or Query to execute'}},{unresolvedLinkAction:{optional:true,description:'action when a unresolved link is found',values:" + this.stringArray2Json((Object[])OETLAbstractLookupTransformer.ACTION.values()) + "}}],input:['ODocument'],output:'ODocument'}");
    }

    @Override
    public String getName() {
        return "load";
    }

    @Override
    public Object executeTransform(ODatabaseDocument db, Object input) {
        Object joinValue = ((ODocument)((OIdentifiable)input).getRecord()).field(this.joinFieldName);
        Object result = this.lookup(db, joinValue, false);
        this.log(Level.FINE, "%s: joinValue=%s, lookupResult=%s", this.getName(), joinValue, result);
        if (result != null) {
            return result;
        }
        switch (this.unresolvedLinkAction) {
            case NOTHING: {
                this.log(Level.FINE, "%s: DOING NOTHING for unresolved link on value %s", this.getName(), joinValue);
                break;
            }
            case ERROR: {
                this.processor.getStats().incrementErrors();
                this.log(Level.SEVERE, "%s: ERROR Cannot resolve join for value '%s'", this.getName(), joinValue);
                break;
            }
            case WARNING: {
                this.processor.getStats().incrementWarnings();
                this.log(Level.INFO, "%s: WARN Cannot resolve join for value '%s'", this.getName(), joinValue);
                break;
            }
            case SKIP: {
                this.log(Level.FINE, "%s: SKIPPING unresolved link on value %s", this.getName(), joinValue);
                return null;
            }
            case HALT: {
                throw new OETLProcessHaltedException("[Merge transformer] Cannot resolve join for value '" + joinValue + "'");
            }
        }
        return input;
    }
}

