/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.transformer.OETLAbstractTransformer;
import java.util.logging.Level;

public class OETLLogTransformer
extends OETLAbstractTransformer {
    private String prefix = "";
    private String postfix = "";

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
        if (iConfiguration.containsField("prefix")) {
            this.prefix = (String)iConfiguration.field("prefix");
        }
        if (iConfiguration.containsField("postfix")) {
            this.postfix = (String)iConfiguration.field("postfix");
        }
    }

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{prefix:{optional:true,description:'Custom prefix to prepend to the message'}},{postfix:{optional:true,description:'Custom postfix to append to the message'}}]}");
    }

    @Override
    public String getName() {
        return "log";
    }

    @Override
    public Object executeTransform(ODatabaseDocument db, Object input) {
        StringBuilder buffer = new StringBuilder();
        if (this.prefix != null && !this.prefix.isEmpty()) {
            buffer.append(this.resolve(this.prefix));
        }
        if (input != null) {
            buffer.append(input);
        }
        if (this.postfix != null && !this.postfix.isEmpty()) {
            buffer.append(this.resolve(this.postfix));
        }
        this.log(Level.INFO, buffer.toString(), new Object[0]);
        return input;
    }
}

