/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.util;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class OFileManager {
    public static void deleteResource(String resourcePath) throws IOException {
        File currentFile = new File(resourcePath);
        if (currentFile.exists()) {
            if (currentFile.isDirectory()) {
                File[] innerFiles;
                for (File file : innerFiles = currentFile.listFiles()) {
                    OFileManager.deleteResource(file.getCanonicalPath());
                }
                currentFile.delete();
            } else if (!currentFile.delete()) {
                throw new IOException();
            }
        }
    }

    public static void extractAll(String inputArchiveFilePath, String outputFolderPath) throws IOException {
        File inputArchiveFile = new File(inputArchiveFilePath);
        if (!inputArchiveFile.exists()) {
            throw new IOException(inputArchiveFile.getAbsolutePath() + " does not exist");
        }
        OFileManager.unZipAll(inputArchiveFile, outputFolderPath);
    }

    public static void unZipAll(File inputZipFile, String destinationFolderPath) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(inputZipFile));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String fileName = zipEntry.getName();
            String newFilePath = destinationFolderPath + File.separator + fileName;
            File newFile = new File(newFilePath);
            FileOutputStream fileOutputStream = null;
            if (!zipEntry.isDirectory()) {
                int len;
                fileOutputStream = new FileOutputStream(newFile);
                while ((len = zipInputStream.read(buffer)) > 0) {
                    fileOutputStream.write(buffer, 0, len);
                }
            } else {
                File dir = new File(newFilePath);
                dir.mkdir();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.closeEntry();
        zipInputStream.close();
    }

    public static String readAllTextFile(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    public static ODocument buildJsonFromFile(String filePath) throws IOException {
        if (filePath == null) {
            return null;
        }
        File jsonFile = new File(filePath);
        if (!jsonFile.exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(jsonFile);
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)is, Charset.forName("UTF-8")));
        ODocument json = new ODocument();
        String jsonText = OFileManager.readAllTextFile(rd);
        json.fromJSON(jsonText, "noMap");
        return json;
    }

    public static void writeFileFromText(String text, String outFilePath, boolean append) throws IOException {
        File outFile = new File(outFilePath);
        outFile.getParentFile().mkdirs();
        outFile.createNewFile();
        PrintWriter out = new PrintWriter(new FileWriter(outFile, append));
        out.println(text);
        out.close();
    }
}

