/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.object.db.OObjectDatabasePool;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;

public class OObjectDatabaseTxPooled
extends OObjectDatabaseTx
implements ODatabasePooled {
    private OObjectDatabasePool ownerPool;
    private final String userName;

    public OObjectDatabaseTxPooled(OObjectDatabasePool iOwnerPool, String iURL, String iUserName, String iUserPassword) {
        super(iURL);
        this.ownerPool = iOwnerPool;
        this.userName = iUserName;
        super.open(iUserName, iUserPassword);
    }

    public void reuse(Object iOwner, Object[] iAdditionalArgs) {
        this.ownerPool = (OObjectDatabasePool)((Object)iOwner);
        if (this.isClosed()) {
            this.open((String)iAdditionalArgs[0], (String)iAdditionalArgs[1]);
        }
        ODatabaseRecordThreadLocal.instance().set(this.getUnderlying());
        this.init();
        try {
            ((ODatabaseDocumentInternal)this.underlying).callOnOpenListeners();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on reusing database '%s' in pool", (Throwable)e, new Object[]{this.getName()});
        }
    }

    public OObjectDatabaseTxPooled open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a OObjectDatabaseTx instance if you want to manually open the connection");
    }

    public OObjectDatabaseTxPooled open(OToken iToken) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a OObjectDatabaseTx instance if you want to manually open the connection");
    }

    public OObjectDatabaseTxPooled create() {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a OObjectDatabaseTx instance if you want to manually open the connection");
    }

    public <THISDB extends ODatabase> THISDB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You cannot open the database in this way. Use directly a OObjectDatabaseTx instance if you want to manually open the connection");
    }

    public boolean isClosed() {
        return this.ownerPool == null || super.isClosed();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.checkOpenness();
        if (this.ownerPool.getConnectionsInCurrentThread(this.getURL(), this.userName) > 1) {
            this.ownerPool.release((ODatabaseInternal)this);
            return;
        }
        try {
            this.commit(true);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on releasing database '%s' in pool", (Throwable)e, new Object[]{this.getName()});
        }
        try {
            ((ODatabaseDocumentInternal)this.underlying).callOnCloseListeners();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on releasing database '%s' in pool", (Throwable)e, new Object[]{this.getName()});
        }
        this.getLocalCache().clear();
        if (this.ownerPool != null) {
            OObjectDatabasePool localCopy = this.ownerPool;
            this.ownerPool = null;
            localCopy.release((ODatabaseInternal)this);
        }
    }

    public void forceClose() {
        super.close();
    }

    protected void checkOpenness() {
        if (this.ownerPool == null) {
            throw new ODatabaseException("Database instance has been released to the pool. Get another database instance from the pool with the right username and password");
        }
        super.checkOpenness();
    }

    public boolean isUnderlyingOpen() {
        return !super.isClosed();
    }
}

