/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.collections.OLuceneResultSet;
import com.orientechnologies.lucene.index.OLuceneFullTextIndex;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.functions.OIndexableSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;

public abstract class OLuceneSearchFunctionTemplate
extends OSQLFunctionAbstract
implements OIndexableSQLFunction {
    public OLuceneSearchFunctionTemplate(String iName, int iMinParams, int iMaxParams) {
        super(iName, iMinParams, iMaxParams);
    }

    public boolean canExecuteInline(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        return this.allowsIndexedExecution(target, operator, rightValue, ctx, args);
    }

    public boolean allowsIndexedExecution(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        OLuceneFullTextIndex index = this.searchForIndex(target, ctx, args);
        return index != null;
    }

    public boolean shouldExecuteAfterSearch(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        return false;
    }

    public long estimate(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        Iterable a = this.searchFromTarget(target, operator, rightValue, ctx, args);
        if (a instanceof OLuceneResultSet) {
            return ((OLuceneResultSet)a).size();
        }
        long count = 0L;
        for (Object o : a) {
            ++count;
        }
        return count;
    }

    protected abstract OLuceneFullTextIndex searchForIndex(OFromClause var1, OCommandContext var2, OExpression ... var3);
}

