/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.factory;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.bbox.BBoxStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.locationtech.spatial4j.context.SpatialContext;

public class OSpatialStrategyFactory {
    private final OShapeBuilder factory;

    public OSpatialStrategyFactory(OShapeBuilder factory) {
        this.factory = factory;
    }

    public SpatialStrategy createStrategy(SpatialContext ctx, ODatabaseDocumentInternal db, OIndexDefinition indexDefinition, ODocument metadata) {
        OClass aClass = db.getMetadata().getSchema().getClass(indexDefinition.getClassName());
        OProperty property = aClass.getProperty((String)indexDefinition.getFields().get(0));
        OClass linkedClass = property.getLinkedClass();
        if ("OPoint".equalsIgnoreCase(linkedClass.getName())) {
            RecursivePrefixTreeStrategy strategy = new RecursivePrefixTreeStrategy((SpatialPrefixTree)new GeohashPrefixTree(ctx, 11), "location");
            strategy.setDistErrPct(0.0);
            return strategy;
        }
        return BBoxStrategy.newInstance((SpatialContext)ctx, (String)"location");
    }
}

