/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.operator;

import com.orientechnologies.lucene.collections.OLuceneResultSet;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.spatial.collections.OSpatialCompositeKey;
import com.orientechnologies.spatial.operator.OLuceneSpatialOperator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.spatial4j.shape.Shape;

public class OLuceneOverlapOperator
extends OLuceneSpatialOperator {
    public OLuceneOverlapOperator() {
        super("&&", 5, false);
    }

    public Collection<OIdentifiable> filterRecords(ODatabase<?> iRecord, List<String> iTargetClasses, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        return null;
    }

    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        Object key = keyParams.get(0);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("geo_filter", "&&");
        queryParams.put("shape", key);
        long start = System.currentTimeMillis();
        OLuceneResultSet indexResult = (OLuceneResultSet)index.get(queryParams);
        if (indexResult != null) {
            indexResult.sendLookupTime(iContext, start);
        }
        if (indexResult == null || indexResult instanceof OIdentifiable) {
            return new OIndexCursorSingleValue((OIdentifiable)indexResult, (Object)new OSpatialCompositeKey(keyParams));
        }
        return new OIndexCursorCollectionValue((Collection)indexResult, (Object)new OSpatialCompositeKey(keyParams));
    }

    @Override
    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext, ODocumentSerializer serializer) {
        Object shape = this.factory.fromDoc((ODocument)iLeft);
        Object filter = iRight instanceof Collection ? ((Collection)iRight).iterator().next() : iRight;
        Object shape1 = this.factory.fromObject(filter);
        return SpatialOperation.BBoxIntersects.evaluate(shape, (Shape)shape1.getBoundingBox());
    }
}

