/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OComplexShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class OPolygonShapeBuilder
extends OComplexShapeBuilder<JtsGeometry> {
    @Override
    public String getName() {
        return "OPolygon";
    }

    @Override
    public OShapeType getType() {
        return OShapeType.POLYGON;
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass polygon = schema.createAbstractClass(this.getName(), this.superClass(db));
        polygon.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
    }

    @Override
    public JtsGeometry fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        return this.toShape((Geometry)this.createPolygon(coordinates));
    }

    protected Polygon createPolygon(List<List<List<Number>>> coordinates) {
        Polygon shape;
        if (coordinates.size() == 1) {
            List<List<Number>> coords = coordinates.get(0);
            LinearRing linearRing = this.createLinearRing(coords);
            shape = GEOMETRY_FACTORY.createPolygon(linearRing);
        } else {
            int i = 0;
            LinearRing outerRing = null;
            LinearRing[] holes = new LinearRing[coordinates.size() - 1];
            for (List<List<Number>> coordinate : coordinates) {
                if (i == 0) {
                    outerRing = this.createLinearRing(coordinate);
                } else {
                    holes[i - 1] = this.createLinearRing(coordinate);
                }
                ++i;
            }
            shape = GEOMETRY_FACTORY.createPolygon(outerRing, holes);
        }
        return shape;
    }

    protected LinearRing createLinearRing(List<List<Number>> coords) {
        Coordinate[] crs = new Coordinate[coords.size()];
        int i = 0;
        for (List<Number> points : coords) {
            crs[i] = new Coordinate(points.get(0).doubleValue(), points.get(1).doubleValue());
            ++i;
        }
        return GEOMETRY_FACTORY.createLinearRing(crs);
    }

    @Override
    public ODocument toDoc(JtsGeometry shape) {
        ODocument doc = new ODocument(this.getName());
        Polygon polygon = (Polygon)shape.getGeom();
        List<List<List<Double>>> polyCoordinates = this.coordinatesFromPolygon(polygon);
        doc.field("coordinates", polyCoordinates);
        return doc;
    }

    protected List<List<List<Double>>> coordinatesFromPolygon(Polygon polygon) {
        ArrayList<List<List<Double>>> polyCoordinates = new ArrayList<List<List<Double>>>();
        LineString exteriorRing = polygon.getExteriorRing();
        polyCoordinates.add(this.coordinatesFromLineString(exteriorRing));
        int i = polygon.getNumInteriorRing();
        for (int j = 0; j < i; ++j) {
            LineString interiorRingN = polygon.getInteriorRingN(j);
            polyCoordinates.add(this.coordinatesFromLineString(interiorRingN));
        }
        return polyCoordinates;
    }
}

