/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.strategy;

import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.spatial.engine.OLuceneSpatialIndexContainer;
import com.orientechnologies.spatial.query.OSpatialQueryContext;
import com.orientechnologies.spatial.shape.OShapeBuilder;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderAbstract;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderContains;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderDWithin;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderDistanceSphere;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderIntersects;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderNear;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderOverlap;
import com.orientechnologies.spatial.strategy.SpatialQueryBuilderWithin;
import java.util.HashMap;
import java.util.Map;

public class SpatialQueryBuilder
extends SpatialQueryBuilderAbstract {
    private Map<String, SpatialQueryBuilderAbstract> operators = new HashMap<String, SpatialQueryBuilderAbstract>();

    public SpatialQueryBuilder(OLuceneSpatialIndexContainer manager, OShapeBuilder factory) {
        super(manager, factory);
        this.initOperators(manager, factory);
    }

    private void initOperators(OLuceneSpatialIndexContainer manager, OShapeBuilder factory) {
        this.addOperator(new SpatialQueryBuilderWithin(manager, factory));
        this.addOperator(new SpatialQueryBuilderContains(manager, factory));
        this.addOperator(new SpatialQueryBuilderNear(manager, factory));
        this.addOperator(new SpatialQueryBuilderDWithin(manager, factory));
        this.addOperator(new SpatialQueryBuilderIntersects(manager, factory));
        this.addOperator(new SpatialQueryBuilderDistanceSphere(manager, factory));
        this.addOperator(new SpatialQueryBuilderOverlap(manager, factory));
    }

    private void addOperator(SpatialQueryBuilderAbstract builder) {
        this.operators.put(builder.getName(), builder);
    }

    @Override
    public OSpatialQueryContext build(Map<String, Object> query) throws Exception {
        SpatialQueryBuilderAbstract operation = this.parseOperation(query);
        return operation.build(query);
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    private SpatialQueryBuilderAbstract parseOperation(Map<String, Object> query) {
        String operator = (String)query.get("geo_filter");
        SpatialQueryBuilderAbstract spatialQueryBuilder = this.operators.get(operator);
        if (spatialQueryBuilder == null) {
            throw new OIndexEngineException("Operator " + operator + " not supported.", null);
        }
        return spatialQueryBuilder;
    }
}

