/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryAsyncRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OHideRecordResponse;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public final class OHideRecordRequest
implements OBinaryAsyncRequest<OHideRecordResponse> {
    private ORecordId recordId;
    private byte mode;

    public OHideRecordRequest(ORecordId recordId) {
        this.recordId = recordId;
    }

    public OHideRecordRequest() {
    }

    @Override
    public byte getCommand() {
        return 43;
    }

    @Override
    public String getDescription() {
        return "Hide Record";
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.recordId = channel.readRID();
        this.mode = channel.readByte();
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeRID((ORID)this.recordId);
        network.writeByte(this.mode);
    }

    public ORecordId getRecordId() {
        return this.recordId;
    }

    @Override
    public void setMode(byte mode) {
        this.mode = mode;
    }

    @Override
    public byte getMode() {
        return this.mode;
    }

    @Override
    public OHideRecordResponse createResponse() {
        return new OHideRecordResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeHideRecord(this);
    }
}

