/**
 * Created by Administrator on 2016/1/4.
 */
$(document).ready(function(){
    var canvas = $("#myCanvas");
    var context = canvas.get(0).getContext("2d");

    var canvasWidth = canvas.width();
    var canvasHeight = canvas.height();

    $(window).resize(resizeCanvas);

    function resizeCanvas(){
        canvas.attr("width",$(window).get(0).innerWidth);
        canvas.attr("height",$(window).get(0).innerHeight);
        canvasWidth = canvas.width();
        canvasHeight = canvas.width();
    };

    resizeCanvas();

    var playAnimation = true;

    var startButton = $("#startAnimation");
    var stopButton = $("#stopAnimation");

    startButton.hide();
    startButton.click(function(){
        $(this).hide();
        stopButton.show();

        playAnimation = true;
        animate();
    });

    stopButton.click(function(){
        $(this).hide();
        startButton.show();

        playAnimation = false;
        animate();
    });

    //为每个图形创建对象
    var Asteroid = function(x,y,radius,vX,vY){
        this.x = x;
        this.y = y;
        this.radius = radius;//半径
        this.mass = mass;//质量

        this.vX = vX;//速度（速率和方向）
        this.vY = vY;
        this.aX = aX;//加速度
        this.aY = aY;
    };

    //创建数组存储所有图形的状态
    var asteroids = new Array();

    //生成随机形状
    for(var i = 0;i < 20;i++){
        var x = 20+(Math.random()*(canvasWidth-40));
        var y = 20+(Math.random()*(canvasHeight-40));
        var radius = 5+Math.random()*10;//半径

        var radius = 5+Math.random()*10;
        var mass = radius/2;

        var vX = Math.random()*4-2;//介于-2到2之间的位移
        var vY = Math.random()*4-2;
        var aX = Math.random()*0.2-0.1;//介于-0.1到0.1之间的加速度
        var aY = Math.random()*0.2-0.1;

        asteroids.push(new Asteroid(x,y,radius,mass,vX,vY,aX,aY));
    };

    //循环执行更新，清除，绘制
    function animate(){
        context.clearRect(0,0,canvasWidth,canvasHeight);//清除
        context.fillStyle = "rgb(255,255,255)";

        var asteroidsLength = asteroids.length;
        for(var i = 0;i < asteroidsLength;i++){//绘制
            var tmpAsteroid = asteroids[i];

            //所有小行星圆心之间的距离做比较
            for(var j = i+1;j < asteroidsLength;j++){
                var tmpAsteroidB = asteroids[j];

                var dX = tmpAsteroidB.x - tmpAsteroid.x;
                var dY = tmpAsteroidB.y - tmpAsteroid.y;
                var distance = Math.sqrt((dX*dX) + (dY*dY));

                //判断圆心间距离和半径间的大小
                if(distance < tmpAsteroid.radius + tmpAsteroidB.radius){
                    //重叠了
                    var angle = Math.atan2(dY,dX);//反正切 两个圆之间的角度
                    var sine = Math.sin(angle);//dX与斜边的比值
                    var cosine = Math.cos(angle);//dY与斜边的比值

                    //把每个圆的位置和速度进行旋转(待研究)
                    var x = 0;
                    var y = 0;

                    var xB = dX * cosine + dY * sine;
                    var yB = dY * cosine - dX * sine;

                    var vX = tmpAsteroid.vX * cosine + tmpAsteroid.vY * sine;
                    var vY = tmpAsteroid.vY * cosine - tmpAsteroid.vX * sine;

                    var vXb = tmpAsteroidB.vX * cosine + tmpAsteroidB.vY * sine;
                    var vYb = tmpAsteroidB.vY * cosine - tmpAsteroidB.vX * sine;

                    //速度反向
/*                    vX *= -1;
                    vXb *= -1;*/
                    //根据动能改变速度
                    var vTotal = vX - vXb;
                    vX = ((tmpAsteroid.mass - tmpAsteroidB.mass) * vX + 2 * tmpAsteroidB.mass * vXb)/(tmpAsteroid.mass + tmpAsteroidB.mass);
                    vXb = vTotal + vX;


                    //相互分离
                    xB = x + (tmpAsteroid.radius + tmpAsteroidB.radius);

                    //旋转到原来位置，使用新的速度
                    tmpAsteroid.x = tmpAsteroid.x + (x * cosine - y * sine);
                    tmpAsteroid.y = tmpAsteroid.y + (y * cosine + x * sine);

                    tmpAsteroidB.x = tmpAsteroid.x + (xB * cosine - yB * sine);
                    tmpAsteroidB.y = tmpAsteroid.y + (yB * cosine + xB * sine);

                    tmpAsteroid.vX = vX * cosine - vY * sine;
                    tmpAsteroid.vY = vY * cosine - vX * sine;

                    tmpAsteroidB.vX = vXb * cosine - vYb * sine;
                    tmpAsteroidB.vY = vYb * cosine - vXb * sine;

                }
            }

            tmpAsteroid.x += tmpAsteroid.vX;
            tmpAsteroid.y += tmpAsteroid.vY;

            //赋予加速度 且防止速度无限大
            if(Math.abs(tmpAsteroid.vX) < 10){
                tmpAsteroid.vX += tmpAsteroid.aX;
            };

            if(Math.abs(tmpAsteroid.vY) < 10){
                tmpAsteroid.vY += tmpAsteroid.aY;
            }

/*            //赋予摩擦力
            if(Math.abs(tmpAsteroid.vX) > 0.1){
                tmpAsteroid.vX *= 0.9;
            }else{//达到一定值，速度为0
                tmpAsteroid.vX = 0;
                tmpAsteroid.aX = 0;
            };
            if(Math.abs(tmpAsteroid.vY) > 0.1){
                tmpAsteroid.vY *= 0.9;
            }else{
                tmpAsteroid.vY = 0;
                tmpAsteroid.aY = 0;
            };*/


            context.beginPath();
            context.arc(tmpAsteroid.x,tmpAsteroid.y,tmpAsteroid.radius,0,Math.PI*2,false);

            context.closePath();
            context.fill();

            //边界检查 防止飞出边界 改变 速度 加速度
            if(tmpAsteroid.x-tmpAsteroid.radius < 0){
                tmpAsteroid.x = tmpAsteroid.radius;
                tmpAsteroid.vX *= -1;
                tmpAsteroid.aX *= -1;
            }else if(tmpAsteroid.x+tmpAsteroid.radius > canvasWidth){
                tmpAsteroid.x = canvasWidth-tmpAsteroid.radius;
                tmpAsteroid.vX *= -1;
                tmpAsteroid.aX *= -1;
            }

            if(tmpAsteroid.y-tmpAsteroid.radius < 0){
                tmpAsteroid.y = tmpAsteroid.radius;
                tmpAsteroid.vY *= -1;
                tmpAsteroid.aY *= -1;
            }else if(tmpAsteroid.y+tmpAsteroid.radius > canvasHeight){
                tmpAsteroid.y = canvasHeight-tmpAsteroid.radius;
                tmpAsteroid.vY *= -1;
                tmpAsteroid.aY *= -1;
            }

        };

        if(playAnimation){
            setTimeout(animate,33);//更新
        }
    }

    animate();

})