var BODY_WIDTH = 1024;
var BODY_HEIGHT = 768;
var CANVAS_WIDTH = 1024;
var CANVAS_HEIGHT = 768;
var MARGIN_TOP = 60;
var MARGIN_LEFT = 30;
var RADIUS = 8;

const endTime = new Date(2016, 7, 9);
var curShowTimeSeconds = 0;

var balls = [];
const colors = ["#00F", "#0F0", "#0FF", "#F00", "#F0F", "#FF0", "#08F", "#0F8", "#80F", "#8F0", "#F08", "#F80"];

window.onload = function() {

    BODY_WIDTH = document.body.clientWidth;
    BODY_HEIGHT = document.body.clientHeight;
    CANVAS_WIDTH = BODY_WIDTH;
    CANVAS_HEIGHT = BODY_HEIGHT - 50;

    MARGIN_TOP = Math.floor(CANVAS_HEIGHT / 5);
    MARGIN_LEFT = Math.floor(CANVAS_WIDTH / 10);
    RADIUS = Math.floor(CANVAS_WIDTH * 3 / 4 / 108) - 1;

    var canvas = document.getElementById("canvas");
    var context = canvas.getContext("2d");

    canvas.width = CANVAS_WIDTH;
    canvas.height = CANVAS_HEIGHT;

    curShowTimeSeconds = getCurrenShowTimeSeconds();
    setInterval(function() {
        render(context);
        update();
    },
    50);
};

function getCurrenShowTimeSeconds() {

    var curTime = new Date();
    var ret = endTime.getTime() - curTime.getTime();
    ret = Math.round(ret / 1000);

    return ret >= 0 ? ret: 0;
}

function update() {

    var nextShowTimeSeconds = getCurrenShowTimeSeconds();

    var nextHours = parseInt(nextShowTimeSeconds / 3600);
    var nextMinutes = parseInt((nextShowTimeSeconds - nextHours * 3600) / 60);
    var nextSeconds = nextShowTimeSeconds % 60;

    var curHours = parseInt(curShowTimeSeconds / 3600);
    var curMinutes = parseInt((curShowTimeSeconds - curHours * 3600) / 60);
    var curSeconds = curShowTimeSeconds % 60;

    if (nextSeconds != curSeconds) {
        if (parseInt(curHours / 10) != parseInt(nextHours / 10)) {
            addBalls(MARGIN_LEFT + 0, MARGIN_TOP, parseInt(curHours / 10));
        }
        if (parseInt(curHours % 10) != parseInt(nextHours % 10)) {
            addBalls(MARGIN_LEFT + 15 * (RADIUS + 1), MARGIN_TOP, parseInt(curHours % 10));
        }

        if (parseInt(curMinutes / 10) != parseInt(nextMinutes / 10)) {
            addBalls(MARGIN_LEFT + 39 * (RADIUS + 1), MARGIN_TOP, parseInt(curMinutes / 10));
        }
        if (parseInt(curMinutes % 10) != parseInt(nextMinutes % 10)) {
            addBalls(MARGIN_LEFT + 54 * (RADIUS + 1), MARGIN_TOP, parseInt(curMinutes % 10));
        }

        if (parseInt(curSeconds / 10) != parseInt(nextSeconds / 10)) {
            addBalls(MARGIN_LEFT + 78 * (RADIUS + 1), MARGIN_TOP, parseInt(curSeconds / 10));
        }
        if (parseInt(curSeconds % 10) != parseInt(nextSeconds % 10)) {
            addBalls(MARGIN_LEFT + 93 * (RADIUS + 1), MARGIN_TOP, parseInt(curSeconds % 10));
        }

        curShowTimeSeconds = nextShowTimeSeconds;
    }

    updateBalls();
}

function updateBalls() {

    for (var i = 0; i < balls.length; i++) {

        balls[i].x += balls[i].vx;
        balls[i].y += balls[i].vy;
        balls[i].vy += balls[i].g;

        if (balls[i].y >= CANVAS_HEIGHT - RADIUS) {
            balls[i].y = CANVAS_HEIGHT - RADIUS;
            balls[i].vy = -balls[i].vy * 0.75;
        }
    }

    var cnt = 0;
    for (var i = 0; i < balls.length; i++) {
        if (balls[i].x + RADIUS > 0 && balls[i].x - RADIUS < CANVAS_WIDTH) {
            balls[cnt++] = balls[i];
        }
    }
    while (balls.length > Math.min(300, cnt)) {
        balls.pop();
    }
}

function addBalls(x, y, num) {

    for (var i = 0; i < digit[num].length; i++) {
        for (var j = 0; j < digit[num][i].length; j++) {
            if (digit[num][i][j] == 1) {
                var aBall = {
                    x: x + j * 2 * (RADIUS + 1) + (RADIUS + 1),
                    y: y + i * 2 * (RADIUS + 1) + (RADIUS + 1),
                    g: 1.5 + Math.random(),
                    vx: Math.pow( - 1, Math.ceil(Math.random() * 1000)) * 6,
                    vy: -0.5,
                    color: colors[Math.floor(Math.random() * colors.length)]
                };

                balls.push(aBall);
            }
        }
    }
}

function render(cxt) {

    var grd = cxt.createLinearGradient(0, 0, 0, CANVAS_HEIGHT);
    grd.addColorStop(0, "purple");
    grd.addColorStop(1, "gray");
    cxt.fillStyle = grd;
    cxt.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);

    cxt.font = "40px 黑体";
    cxt.fillStyle = "#F44";
    cxt.fillText("2016年七夕情人节倒计时：", CANVAS_WIDTH / 10, CANVAS_HEIGHT / 8);

    var hours = parseInt(curShowTimeSeconds / 3600);
    var minutes = parseInt((curShowTimeSeconds - hours * 3600) / 60);
    var seconds = curShowTimeSeconds % 60;

    renderDigit(MARGIN_LEFT, MARGIN_TOP, parseInt(hours / 10), cxt);
    renderDigit(MARGIN_LEFT + 15 * (RADIUS + 1), MARGIN_TOP, parseInt(hours % 10), cxt);
    renderDigit(MARGIN_LEFT + 30 * (RADIUS + 1), MARGIN_TOP, 10, cxt);
    renderDigit(MARGIN_LEFT + 39 * (RADIUS + 1), MARGIN_TOP, parseInt(minutes / 10), cxt);
    renderDigit(MARGIN_LEFT + 54 * (RADIUS + 1), MARGIN_TOP, parseInt(minutes % 10), cxt);
    renderDigit(MARGIN_LEFT + 69 * (RADIUS + 1), MARGIN_TOP, 10, cxt);
    renderDigit(MARGIN_LEFT + 78 * (RADIUS + 1), MARGIN_TOP, parseInt(seconds / 10), cxt);
    renderDigit(MARGIN_LEFT + 93 * (RADIUS + 1), MARGIN_TOP, parseInt(seconds % 10), cxt);

    for (var i = 0; i < balls.length; i++) {
        cxt.fillStyle = balls[i].color;

        cxt.beginPath();
        cxt.arc(balls[i].x, balls[i].y, RADIUS, 0, 2 * Math.PI, true);
        cxt.closePath();

        cxt.fill();
    }
}

function renderDigit(x, y, num, cxt) {

    cxt.fillStyle = "#000";

    for (var i = 0; i < digit[num].length; i++) {
        for (var j = 0; j < digit[num][i].length; j++) {
            if (digit[num][i][j] == 1) {
                cxt.beginPath();
                cxt.arc(x + j * 2 * (RADIUS + 1) + (RADIUS + 1), y + i * 2 * (RADIUS + 1) + (RADIUS + 1), RADIUS, 0, 2 * Math.PI);
                cxt.closePath();
                cxt.fill();
            }
        }
    }
}