
// This is ammo.js, a port of Bullet Physics to JavaScript. zlib licensed.
var Ammo = (function() {
  var Module = this;

var Module;if(!Module)Module=(typeof Module!=="undefined"?Module:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function";var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){return Module["read"](filename,true)};Module["load"]=function load(f){globalEval(read(f))};Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/");Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}))}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}this["Module"]=Module}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WEB){window["Module"]=Module}else{Module["load"]=importScripts}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){throw"NO_DYNAMIC_EXECUTION was set, cannot eval"}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),getAsmConst:(function(code,numArgs){if(!Runtime.asmConstCache)Runtime.asmConstCache={};var func=Runtime.asmConstCache[code];if(func)return func;var args=[];for(var i=0;i<numArgs;i++){args.push(String.fromCharCode(36)+i)}var source=Pointer_stringify(code);if(source[0]==='"'){if(source.indexOf('"',1)===source.length-1){source=source.substr(1,source.length-2)}else{abort("invalid EM_ASM input |"+source+"|. Please use EM_ASM(..code..) (no quotes) or EM_ASM({ ..code($0).. }, input) (to input values)")}}abort("NO_DYNAMIC_EXECUTION was set, cannot eval, so EM_ASM is not functional");return Runtime.asmConstCache[code]=evalled}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),UTF8Processor:(function(){var buffer=[];var needed=0;this.processCChar=(function(code){code=code&255;if(buffer.length==0){if((code&128)==0){return String.fromCharCode(code)}buffer.push(code);if((code&224)==192){needed=1}else if((code&240)==224){needed=2}else{needed=3}return""}if(needed){buffer.push(code);needed--;if(needed>0)return""}var c1=buffer[0];var c2=buffer[1];var c3=buffer[2];var c4=buffer[3];var ret;if(buffer.length==2){ret=String.fromCharCode((c1&31)<<6|c2&63)}else if(buffer.length==3){ret=String.fromCharCode((c1&15)<<12|(c2&63)<<6|c3&63)}else{var codePoint=(c1&7)<<18|(c2&63)<<12|(c3&63)<<6|c4&63;ret=String.fromCharCode(((codePoint-65536)/1024|0)+55296,(codePoint-65536)%1024+56320)}buffer.length=0;return ret});this.processJSString=function processJSString(string){string=unescape(encodeURIComponent(string));var ret=[];for(var i=0;i<string.length;i++){ret.push(string.charCodeAt(i))}return ret}}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY)enlargeMemory();return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){abort("NO_DYNAMIC_EXECUTION was set, cannot eval - ccall/cwrap are not functional")}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var stack=0;var JSfuncs={"stackSave":(function(){stack=Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore(stack)}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args){var func=getCFunc(ident);var cArgs=[];if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0)JSfuncs["stackRestore"]();return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+=JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body+";"}funcstr+="return ret})";abort("NO_DYNAMIC_EXECUTION was set, cannot eval - ccall is not functional")}}))();Module["cwrap"]=cwrap;Module["ccall"]=ccall;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function Pointer_stringify(ptr,length){if(length===0)return"";var hasUtf=false;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];if(t>=128)hasUtf=true;else if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(!hasUtf){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}var utf8=new Runtime.UTF8Processor;for(i=0;i<length;i++){t=HEAPU8[ptr+i>>0];ret+=utf8.processCChar(t)}return ret}Module["Pointer_stringify"]=Pointer_stringify;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr){for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr+i*2>>1]=codeUnit}HEAP16[outPtr+str.length*2>>1]=0}Module["stringToUTF16"]=stringToUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr){var iChar=0;for(var iCodeUnit=0;iCodeUnit<str.length;++iCodeUnit){var codeUnit=str.charCodeAt(iCodeUnit);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++iCodeUnit);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr+iChar*4>>2]=codeUnit;++iChar}HEAP32[outPtr+iChar*4>>2]=0}Module["stringToUTF32"]=stringToUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var final=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}final=parse()}catch(e){final+="?"}if(final.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return final}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){return x+4095&-4096}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function enlargeMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value "+TOTAL_MEMORY+", (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.")}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||67108864;var FAST_MEMORY=Module["FAST_MEMORY"]||2097152;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){Module.printErr("increasing TOTAL_MEMORY to "+totalMemory+" to be compliant with the asm.js spec");TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=Module.addOnPreRun=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=Module.addOnInit=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=Module.addOnPreMain=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=Module.addOnExit=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=Module.addOnPostRun=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var ret=(new Runtime.UTF8Processor).processJSString(stringy);if(length){ret.length=length}if(!dontAddNull){ret.push(0)}return ret}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer+i>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;i++){HEAP8[buffer+i>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer+str.length>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;STATIC_BASE=8;STATICTOP=STATIC_BASE+21648;__ATINIT__.push({func:(function(){__GLOBAL__I_a()})});allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,49,55,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,49,51,98,116,84,121,112,101,100,79,98,106,101,99,116,0,184,81,0,0,136,0,0,0,64,82,0,0,112,0,0,0,0,0,0,0,1,0,0,0,152,0,0,0,2,4,0,0,0,0,0,0,24,1,0,0,4,0,0,0,5,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,49,57,98,116,71,104,111,115,116,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,50,53,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,184,81,0,0,240,0,0,0,224,81,0,0,216,0,0,0,16,1,0,0,0,0,0,0,49,56,98,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,0,0,0,184,81,0,0,40,1,0,0,0,0,0,0,192,1,0,0,6,0,0,0,7,0,0,0,1,0,0,0,1,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,52,67,108,111,115,101,115,116,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,184,81,0,0,144,1,0,0,224,81,0,0,96,1,0,0,184,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,2,0,0,8,0,0,0,9,0,0,0,1,0,0,0,2,0,0,0,50,48,98,116,68,101,102,97,117,108,116,77,111,116,105,111,110,83,116,97,116,101,0,0,49,51,98,116,77,111,116,105,111,110,83,116,97,116,101,0,184,81,0,0,128,2,0,0,224,81,0,0,104,2,0,0,144,2,0,0,0,0,0,0,0,0,0,0,48,3,0,0,10,0,0,0,11,0,0,0,2,0,0,0,2,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,55,67,108,111,115,101,115,116,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,184,81,0,0,248,2,0,0,224,81,0,0,192,2,0,0,40,3,0,0,0,0,0,0,0,0,0,0,176,3,0,0,12,0,0,0,13,0,0,0,3,0,0,0,1,0,0,0,50,57,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,184,81,0,0,120,3,0,0,224,81,0,0,88,3,0,0,168,3,0,0,0,0,0,0,123,32,118,97,114,32,115,101,108,102,32,61,32,77,111,100,117,108,101,91,39,103,101,116,67,97,99,104,101,39,93,40,77,111,100,117,108,101,91,39,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,39,93,41,91,36,48,93,59,32,105,102,32,40,33,115,101,108,102,46,104,97,115,79,119,110,80,114,111,112,101,114,116,121,40,39,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,39,41,41,32,116,104,114,111,119,32,39,97,32,74,83,73,109,112,108,101,109,101,110,116,97,116,105,111,110,32,109,117,115,116,32,105,109,112,108,101,109,101,110,116,32,97,108,108,32,102,117,110,99,116,105,111,110,115,44,32,121,111,117,32,102,111,114,103,111,116,32,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,58,58,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,46,39,59,32,114,101,116,117,114,110,32,115,101,108,102,46,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,40,36,49,44,36,50,44,36,51,44,36,52,44,36,53,44,36,54,44,36,55,41,59,32,125,0,0,0,0,0,0,0,0,56,5,0,0,14,0,0,0,15,0,0,0,16,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,50,49,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,0,224,81,0,0,32,5,0,0,160,0,0,0,0,0,0,0,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,48,8,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,5,0,0,0,3,0,0,0,21,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,6,0,0,0,22,0,0,0,7,0,0,0,1,0,0,0,3,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,23,0,0,0,13,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,4,0,0,0,5,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,24,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,1,0,0,0,2,0,0,0,25,0,0,0,20,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,26,0,0,0,21,0,0,0,6,0,0,0,0,0,0,0,100,101,98,117,103,68,114,97,119,87,111,114,108,100,0,0,115,121,110,99,104,114,111,110,105,122,101,77,111,116,105,111,110,83,116,97,116,101,115,0,115,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,105,110,116,101,114,110,97,108,83,105,110,103,108,101,83,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,0,0,117,112,100,97,116,101,65,99,116,105,111,110,115,0,0,0,117,112,100,97,116,101,65,99,116,105,118,97,116,105,111,110,83,116,97,116,101,0,0,0,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,0,0,0,0,0,0,0,0,99,97,108,99,117,108,97,116,101,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,114,101,97,116,101,80,114,101,100,105,99,116,105,118,101,67,111,110,116,97,99,116,115,0,0,0,0,0,0,0,0,114,101,108,101,97,115,101,32,112,114,101,100,105,99,116,105,118,101,32,99,111,110,116,97,99,116,32,109,97,110,105,102,111,108,100,115,0,0,0,0,112,114,101,100,105,99,116,105,118,101,32,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,0,0,0,0,0,105,110,116,101,103,114,97,116,101,84,114,97,110,115,102,111,114,109,115,0,0,0,0,0,67,67,68,32,109,111,116,105,111,110,32,99,108,97,109,112,105,110,103,0,0,0,0,0,97,112,112,108,121,32,115,112,101,99,117,108,97,116,105,118,101,32,99,111,110,116,97,99,116,32,114,101,115,116,105,116,117,116,105,111,110,0,0,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,0,0,0,0,0,0,0,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,49,53,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,224,81,0,0,8,8,0,0,184,29,0,0,0,0,0,0,224,81,0,0,232,7,0,0,32,8,0,0,0,0,0,0,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,68,97,116,97,0,0,0,0,0,0,0,83,80,72,69,82,69,0,0,0,0,0,0,168,8,0,0,27,0,0,0,28,0,0,0,6,0,0,0,4,0,0,0,51,52,98,116,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,0,0,0,224,81,0,0,128,8,0,0,48,3,0,0,0,0,0,0,0,0,0,0,40,9,0,0,29,0,0,0,30,0,0,0,1,0,0,0,0,0,0,0,50,55,73,110,112,108,97,99,101,83,111,108,118,101,114,73,115,108,97,110,100,67,97,108,108,98,97,99,107,0,0,0,78,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,49,52,73,115,108,97,110,100,67,97,108,108,98,97,99,107,69,0,0,0,184,81,0,0,240,8,0,0,224,81,0,0,208,8,0,0,32,9,0,0,0,0,0,0,0,0,0,0,144,9,0,0,31,0,0,0,32,0,0,0,33,0,0,0,1,0,0,0,22,0,0,0,23,0,0,0,1,0,0,0,2,0,0,0,5,0,0,0,7,0,0,0,4,0,0,0,34,0,0,0,50,51,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,0,224,81,0,0,112,9,0,0,160,0,0,0,0,0,0,0,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,0,0,0,16,10,0,0,35,0,0,0,36,0,0,0,37,0,0,0,1,0,0,0,24,0,0,0,25,0,0,0,1,0,0,0,3,0,0,0,6,0,0,0,8,0,0,0,5,0,0,0,0,0,0,0,49,55,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,224,81,0,0,248,9,0,0,160,0,0,0,0,0,0,0,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,56,11,0,0,38,0,0,0,39,0,0,0,1,0,0,0,26,0,0,0,27,0,0,0,2,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,3,0,0,0,9,0,0,0,40,0,0,0,10,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,48,98,116,75,105,110,101,109,97,116,105,99,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,0,0,0,0,0,0,0,0,51,48,98,116,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,73,110,116,101,114,102,97,99,101,0,0,0,0,0,0,0,0,49,55,98,116,65,99,116,105,111,110,73,110,116,101,114,102,97,99,101,0,0,0,0,0,184,81,0,0,8,11,0,0,224,81,0,0,224,10,0,0,32,11,0,0,0,0,0,0,224,81,0,0,184,10,0,0,40,11,0,0,0,0,0,0,0,0,0,0,144,11,0,0,41,0,0,0,42,0,0,0,2,0,0,0,7,0,0,0,52,51,98,116,75,105,110,101,109,97,116,105,99,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,0,0,224,81,0,0,96,11,0,0,48,3,0,0,0,0,0,0,0,0,0,0,248,11,0,0,43,0,0,0,44,0,0,0,45,0,0,0,1,0,0,0,32,0,0,0,33,0,0,0,1,0,0,0,4,0,0,0,8,0,0,0,11,0,0,0,6,0,0,0,0,0,0,0,50,51,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,0,224,81,0,0,216,11,0,0,160,0,0,0,0,0,0,0,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,14,0,0,46,0,0,0,47,0,0,0,4,0,0,0,34,0,0,0,7,0,0,0,8,0,0,0,5,0,0,0,0,0,0,0,49,54,98,116,82,97,121,99,97,115,116,86,101,104,105,99,108,101,0,0,0,0,0,0,224,81,0,0,200,14,0,0,32,11,0,0,0,0,0,0,0,0,0,0,40,15,0,0,48,0,0,0,49,0,0,0,2,0,0,0,0,0,0,0,50,53,98,116,68,101,102,97,117,108,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,0,0,0,0,224,81,0,0,8,15,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,15,0,0,7,0,0,0,50,0,0,0,51,0,0,0,35,0,0,0,12,0,0,0,7,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,116,82,105,103,105,100,66,111,100,121,70,108,111,97,116,68,97,116,97,0,0,0,0,49,49,98,116,82,105,103,105,100,66,111,100,121,0,0,0,224,81,0,0,136,15,0,0,160,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,16,0,0,52,0,0,0,53,0,0,0,4,0,0,0,1,0,0,0,5,0,0,0,54,0,0,0,13,0,0,0,6,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,83,101,116,117,112,0,0,0,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,73,116,101,114,97,116,105,111,110,115,0,0,0,0,0,0,0,115,111,108,118,101,71,114,111,117,112,0,0,0,0,0,0,51,53,98,116,83,101,113,117,101,110,116,105,97,108,73,109,112,117,108,115,101,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,49,56,98,116,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,0,184,81,0,0,112,16,0,0,224,81,0,0,72,16,0,0,136,16,0,0,0,0,0,0,0,0,0,0,240,16,0,0,55,0,0,0,56,0,0,0,3,0,0,0,1,0,0,0,37,0,0,0,38,0,0,0,1,0,0,0,5,0,0,0,9,0,0,0,14,0,0,0,8,0,0,0,0,0,0,0,49,56,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,0,0,0,0,224,81,0,0,216,16,0,0,160,0,0,0,0,0,0,0,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,20,0,0,57,0,0,0,58,0,0,0,1,0,0,0,6,0,0,0,1,0,0,0,7,0,0,0,2,0,0,0,8,0,0,0,39,0,0,0,15,0,0,0,16,0,0,0,7,0,0,0,40,0,0,0,59,0,0,0,49,50,98,116,65,120,105,115,83,119,101,101,112,51,0,0,50,48,98,116,65,120,105,115,83,119,101,101,112,51,73,110,116,101,114,110,97,108,73,116,69,0,0,0,0,0,0,0,50,49,98,116,66,114,111,97,100,112,104,97,115,101,73,110,116,101,114,102,97,99,101,0,184,81,0,0,24,20,0,0,224,81,0,0,248,19,0,0,48,20,0,0,0,0,0,0,224,81,0,0,232,19,0,0,56,20,0,0,0,0,0,0,0,0,0,0,56,20,0,0,60,0,0,0,61,0,0,0,1,0,0,0,6,0,0,0,1,0,0,0,7,0,0,0,2,0,0,0,8,0,0,0,39,0,0,0,15,0,0,0,16,0,0,0,7,0,0,0,40,0,0,0,59,0,0,0,0,0,0,0,48,21,0,0,62,0,0,0,63,0,0,0,9,0,0,0,3,0,0,0,8,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,9,0,0,0,20,0,0,0,10,0,0,0,41,0,0,0,11,0,0,0,10,0,0,0,21,0,0,0,42,0,0,0,43,0,0,0,0,0,0,0,49,53,98,116,78,117,108,108,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,50,50,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,0,224,81,0,0,0,21,0,0,16,1,0,0,0,0,0,0,224,81,0,0,232,20,0,0,32,21,0,0,0,0,0,0,0,0,0,0,216,21,0,0,64,0,0,0,65,0,0,0,9,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,44,0,0,0,22,0,0,0,1,0,0,0,23,0,0,0,45,0,0,0,9,0,0,0,2,0,0,0,24,0,0,0,11,0,0,0,46,0,0,0,13,0,0,0,14,0,0,0,2,0,0,0,10,0,0,0,11,0,0,0,25,0,0,0,15,0,0,0,8,0,0,0,26,0,0,0,27,0,0,0,12,0,0,0,16,0,0,0,28,0,0,0,13,0,0,0,1,0,0,0,17,0,0,0,49,48,98,116,66,111,120,83,104,97,112,101,0,0,0,0,224,81,0,0,200,21,0,0,128,62,0,0,0,0,0,0,66,111,120,0,0,0,0,0,0,0,0,0,136,22,0,0,66,0,0,0,67,0,0,0,14,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,47,0,0,0,29,0,0,0,2,0,0,0,30,0,0,0,45,0,0,0,10,0,0,0,3,0,0,0,31,0,0,0,12,0,0,0,46,0,0,0,15,0,0,0,18,0,0,0,19,0,0,0,48,0,0,0,49,0,0,0,0,0,0,0,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,68,97,116,97,0,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,0,0,0,0,0,224,81,0,0,104,22,0,0,112,68,0,0,0,0,0,0,66,86,72,84,82,73,65,78,71,76,69,77,69,83,72,0,0,0,0,0,80,23,0,0,68,0,0,0,69,0,0,0,20,0,0,0,0,0,0,0,90,78,75,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,50,49,98,116,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,184,81,0,0,48,23,0,0,224,81,0,0,192,22,0,0,72,23,0,0,0,0,0,0,0,0,0,0,240,23,0,0,70,0,0,0,71,0,0,0,21,0,0,0,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,55,112,101,114,102,111,114,109,67,111,110,118,101,120,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,83,52,95,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,224,81,0,0,120,23,0,0,72,23,0,0,0,0,0,0,0,0,0,0,128,24,0,0,72,0,0,0,73,0,0,0,22,0,0,0,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,52,112,101,114,102,111,114,109,82,97,121,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,224,81,0,0,24,24,0,0,72,23,0,0,0,0,0,0,0,0,0,0,224,25,0,0,74,0,0,0,75,0,0,0,16,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,50,0,0,0,22,0,0,0,3,0,0,0,32,0,0,0,51,0,0,0,11,0,0,0,2,0,0,0,33,0,0,0,13,0,0,0,46,0,0,0,23,0,0,0,24,0,0,0,2,0,0,0,17,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,8,26,0,0,76,0,0,0,77,0,0,0,16,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,50,0,0,0,22,0,0,0,3,0,0,0,35,0,0,0,51,0,0,0,11,0,0,0,2,0,0,0,33,0,0,0,13,0,0,0,46,0,0,0,23,0,0,0,24,0,0,0,2,0,0,0,17,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,48,26,0,0,78,0,0,0,79,0,0,0,16,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,50,0,0,0,22,0,0,0,3,0,0,0,36,0,0,0,51,0,0,0,11,0,0,0,2,0,0,0,33,0,0,0,13,0,0,0,46,0,0,0,23,0,0,0,24,0,0,0,2,0,0,0,17,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,0,0,0,0,49,52,98,116,67,97,112,115,117,108,101,83,104,97,112,101,0,0,0,0,0,0,0,0,224,81,0,0,200,25,0,0,104,41,0,0,0,0,0,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,88,0,0,0,0,0,0,0,224,81,0,0,240,25,0,0,224,25,0,0,0,0,0,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,90,0,0,0,0,0,0,0,224,81,0,0,24,26,0,0,224,25,0,0,0,0,0,0,67,97,112,115,117,108,101,90,0,0,0,0,0,0,0,0,67,97,112,115,117,108,101,88,0,0,0,0,0,0,0,0,98,116,67,97,112,115,117,108,101,83,104,97,112,101,68,97,116,97,0,0,0,0,0,0,67,97,112,115,117,108,101,83,104,97,112,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,26,0,0,80,0,0,0,81,0,0,0,4,0,0,0,14,0,0,0,52,0,0,0,53,0,0,0,15,0,0,0,16,0,0,0,18,0,0,0,37,0,0,0,9,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,10,0,0,0,54,0,0,0,50,49,98,116,67,111,108,108,105,115,105,111,110,68,105,115,112,97,116,99,104,101,114,0,224,81,0,0,216,26,0,0,88,50,0,0,0,0,0,0,0,0,0,0,88,27,0,0,82,0,0,0,83,0,0,0,11,0,0,0,0,0,0,0,50,51,98,116,67,111,108,108,105,115,105,111,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,49,55,98,116,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,184,81,0,0,56,27,0,0,224,81,0,0,24,27,0,0,80,27,0,0,0,0,0,0,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,0,0,0,0,184,81,0,0,136,27,0,0,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,68,97,116,97,0,0,0,0,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,0,0,0,0,0,184,81,0,0,192,27,0,0,0,0,0,0,184,29,0,0,84,0,0,0,85,0,0,0,19,0,0,0,20,0,0,0,5,0,0,0,3,0,0,0,86,0,0,0,1,0,0,0,2,0,0,0,19,0,0,0,55,0,0,0,22,0,0,0,56,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,79,118,101,114,102,108,111,119,32,105,110,32,65,65,66,66,44,32,111,98,106,101,99,116,32,114,101,109,111,118,101,100,32,102,114,111,109,32,115,105,109,117,108,97,116,105,111,110,0,0,0,0,0,0,0,0,73,102,32,121,111,117,32,99,97,110,32,114,101,112,114,111,100,117,99,101,32,116,104,105,115,44,32,112,108,101,97,115,101,32,101,109,97,105,108,32,98,117,103,115,64,99,111,110,116,105,110,117,111,117,115,112,104,121,115,105,99,115,46,99,111,109,10,0,0,0,0,0,80,108,101,97,115,101,32,105,110,99,108,117,100,101,32,97,98,111,118,101,32,105,110,102,111,114,109,97,116,105,111,110,44,32,121,111,117,114,32,80,108,97,116,102,111,114,109,44,32,118,101,114,115,105,111,110,32,111,102,32,79,83,46,10,0,0,0,0,0,0,0,0,84,104,97,110,107,115,46,10,0,0,0,0,0,0,0,0,117,112,100,97,116,101,65,97,98,98,115,0,0,0,0,0,99,97,108,99,117,108,97,116,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,0,0,0,0,0,0,0,112,101,114,102,111,114,109,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,105,111,110,0,0,0,0,0,0,0,100,105,115,112,97,116,99,104,65,108,108,67,111,108,108,105,115,105,111,110,80,97,105,114,115,0,0,0,0,0,0,0,99,111,110,118,101,120,83,119,101,101,112,67,111,109,112,111,117,110,100,0,0,0,0,0,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,0,0,0,0,0,0,184,81,0,0,160,29,0,0,0,0,0,0,8,30,0,0,87,0,0,0,88,0,0,0,20,0,0,0,21,0,0,0,252,255,255,255,8,30,0,0,89,0,0,0,90,0,0,0,22,0,0,0,0,0,0,0,49,55,68,101,98,117,103,68,114,97,119,99,97,108,108,98,97,99,107,0,0,0,0,0,64,82,0,0,240,29,0,0,0,0,0,0,2,0,0,0,88,67,0,0,2,0,0,0,136,67,0,0,2,4,0,0,0,0,0,0,104,30,0,0,91,0,0,0,92,0,0,0,26,0,0,0,27,0,0,0,3,0,0,0,0,0,0,0,50,51,98,116,66,114,105,100,103,101,100,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,0,0,0,0,0,0,224,81,0,0,72,30,0,0,240,52,0,0,0,0,0,0,50,52,98,116,66,114,111,97,100,112,104,97,115,101,65,97,98,98,67,97,108,108,98,97,99,107,0,0,0,0,0,0,184,81,0,0,120,30,0,0,0,0,0,0,0,31,0,0,93,0,0,0,94,0,0,0,12,0,0,0,0,0,0,0,50,49,98,116,83,105,110,103,108,101,83,119,101,101,112,67,97,108,108,98,97,99,107,0,50,51,98,116,66,114,111,97,100,112,104,97,115,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,224,81,0,0,208,30,0,0,152,30,0,0,0,0,0,0,224,81,0,0,184,30,0,0,240,30,0,0,0,0,0,0,0,0,0,0,64,31,0,0,95,0,0,0,96,0,0,0,13,0,0,0,0,0,0,0,49,57,98,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,224,81,0,0,40,31,0,0,240,30,0,0,0,0,0,0,0,0,0,0,8,32,0,0,97,0,0,0,98,0,0,0,14,0,0,0,10,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,49,52,76,111,99,97,108,73,110,102,111,65,100,100,101,114,95,49,0,0,224,81,0,0,104,31,0,0,40,3,0,0,0,0,0,0,0,0,0,0,232,32,0,0,99,0,0,0,100,0,0,0,23,0,0,0,1,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,0,0,0,0,0,0,0,224,81,0,0,48,32,0,0,224,63,0,0,0,0,0,0,0,0,0,0,192,33,0,0,101,0,0,0,102,0,0,0,23,0,0,0,2,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,224,81,0,0,16,33,0,0,224,63,0,0,0,0,0,0,0,0,0,0,112,34,0,0,103,0,0,0,104,0,0,0,15,0,0,0,11,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,49,53,76,111,99,97,108,73,110,102,111,65,100,100,101,114,50,0,0,0,0,224,81,0,0,232,33,0,0,184,1,0,0,0,0,0,0,0,0,0,0,72,35,0,0,105,0,0,0,106,0,0,0,28,0,0,0,57,0,0,0,5,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,57,82,97,121,84,101,115,116,101,114,95,49,0,78,54,98,116,68,98,118,116,56,73,67,111,108,108,105,100,101,69,0,0,0,0,0,0,184,81,0,0,40,35,0,0,224,81,0,0,168,34,0,0,64,35,0,0,0,0,0,0,0,0,0,0,8,36,0,0,107,0,0,0,108,0,0,0,24,0,0,0,1,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,0,0,0,224,81,0,0,112,35,0,0,176,63,0,0,0,0,0,0,0,0,0,0,200,36,0,0,109,0,0,0,110,0,0,0,24,0,0,0,2,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,0,224,81,0,0,48,36,0,0,176,63,0,0,0,0,0,0,0,0,0,0,24,37,0,0,12,0,0,0,58,0,0,0,29,0,0,0,111,0,0,0,112,0,0,0,0,0,0,0,78,49,50,98,116,67,111,110,118,101,120,67,97,115,116,49,48,67,97,115,116,82,101,115,117,108,116,69,0,0,0,0,184,81,0,0,248,36,0,0,0,0,0,0,192,37,0,0,113,0,0,0,114,0,0,0,25,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,59,0,0,0,41,0,0,0,4,0,0,0,42,0,0,0,45,0,0,0,13,0,0,0,4,0,0,0,43,0,0,0,17,0,0,0,46,0,0,0,60,0,0,0,115,0,0,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,67,104,105,108,100,68,97,116,97,0,0,0,0,0,0,0,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,68,97,116,97,0,0,0,0,0,49,53,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,0,0,0,0,0,0,0,224,81,0,0,168,37,0,0,216,27,0,0,0,0,0,0,67,111,109,112,111,117,110,100,0,0,0,0,0,0,0,0,0,0,0,0,40,39,0,0,116,0,0,0,117,0,0,0,26,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,61,0,0,0,22,0,0,0,5,0,0,0,44,0,0,0,62,0,0,0,14,0,0,0,2,0,0,0,45,0,0,0,18,0,0,0,46,0,0,0,30,0,0,0,31,0,0,0,2,0,0,0,27,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,72,39,0,0,118,0,0,0,119,0,0,0,26,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,61,0,0,0,22,0,0,0,5,0,0,0,46,0,0,0,63,0,0,0,14,0,0,0,2,0,0,0,45,0,0,0,18,0,0,0,46,0,0,0,30,0,0,0,31,0,0,0,2,0,0,0,27,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,104,39,0,0,120,0,0,0,121,0,0,0,26,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,61,0,0,0,22,0,0,0,5,0,0,0,47,0,0,0,64,0,0,0,14,0,0,0,2,0,0,0,45,0,0,0,18,0,0,0,46,0,0,0,30,0,0,0,31,0,0,0,2,0,0,0,27,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,0,0,0,0,49,49,98,116,67,111,110,101,83,104,97,112,101,0,0,0,224,81,0,0,24,39,0,0,104,41,0,0,0,0,0,0,49,50,98,116,67,111,110,101,83,104,97,112,101,90,0,0,224,81,0,0,56,39,0,0,40,39,0,0,0,0,0,0,49,50,98,116,67,111,110,101,83,104,97,112,101,88,0,0,224,81,0,0,88,39,0,0,40,39,0,0,0,0,0,0,67,111,110,101,88,0,0,0,67,111,110,101,90,0,0,0,98,116,67,111,110,101,83,104,97,112,101,68,97,116,97,0,67,111,110,101,0,0,0,0,0,0,0,0,216,39,0,0,122,0,0,0,123,0,0,0,1,0,0,0,0,0,0,0,50,55,98,116,67,111,110,116,105,110,117,111,117,115,67,111,110,118,101,120,67,111,108,108,105,115,105,111,110,0,0,0,224,81,0,0,184,39,0,0,120,40,0,0,0,0,0,0,0,0,0,0,88,40,0,0,124,0,0,0,125,0,0,0,32,0,0,0,33,0,0,0,4],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([49,54,98,116,80,111,105,110,116,67,111,108,108,101,99,116,111,114,0,0,0,0,0,0,78,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,54,82,101,115,117,108,116,69,0,184,81,0,0,32,40,0,0,224,81,0,0,8,40,0,0,80,40,0,0,0,0,0,0,49,50,98,116,67,111,110,118,101,120,67,97,115,116,0,0,184,81,0,0,104,40,0,0,0,0,0,0,56,41,0,0,126,0,0,0,127,0,0,0,28,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,65,0,0,0,22,0,0,0,6,0,0,0,48,0,0,0,45,0,0,0,14,0,0,0,2,0,0,0,49,0,0,0,19,0,0,0,46,0,0,0,34,0,0,0,35,0,0,0,2,0,0,0,29,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,8,0,0,0,50,0,0,0,51,0,0,0,30,0,0,0,36,0,0,0,52,0,0,0,31,0,0,0,2,0,0,0,1,0,0,0,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,68,97,116,97,0,0,0,49,55,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,0,0,0,0,0,224,81,0,0,32,41,0,0,184,62,0,0,0,0,0,0,67,111,110,118,101,120,0,0,50,49,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,0,224,81,0,0,80,41,0,0,136,41,0,0,0,0,0,0,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,0,224,81,0,0,120,41,0,0,216,27,0,0,0,0,0,0,0,0,0,0,64,42,0,0,128,0,0,0,129,0,0,0,28,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,66,0,0,0,53,0,0,0,6,0,0,0,54,0,0,0,45,0,0,0,14,0,0,0,2,0,0,0,24,0,0,0,11,0,0,0,46,0,0,0,37,0,0,0,38,0,0,0,2,0,0,0,32,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,8,0,0,0,55,0,0,0,56,0,0,0,33,0,0,0,39,0,0,0,57,0,0,0,34,0,0,0,3,0,0,0,0,0,0,0,50,53,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,0,0,224,81,0,0,32,42,0,0,184,62,0,0,0,0,0,0,67,111,110,118,101,120,84,114,105,109,101,115,104,0,0,0,0,0,0,0,152,42,0,0,130,0,0,0,131,0,0,0,35,0,0,0,0,0,0,0,50,54,76,111,99,97,108,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,0,0,0,224,81,0,0,120,42,0,0,136,67,0,0,0,0,0,0,0,0,0,0,248,43,0,0,132,0,0,0,133,0,0,0,36,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,67,0,0,0,22,0,0,0,7,0,0,0,58,0,0,0,68,0,0,0,15,0,0,0,2,0,0,0,59,0,0,0,20,0,0,0,46,0,0,0,40,0,0,0,41,0,0,0,2,0,0,0,37,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,5,0,0,0,0,0,0,0,32,44,0,0,134,0,0,0,135,0,0,0,36,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,67,0,0,0,22,0,0,0,7,0,0,0,60,0,0,0,68,0,0,0,15,0,0,0,2,0,0,0,59,0,0,0,20,0,0,0,46,0,0,0,40,0,0,0,42,0,0,0,2,0,0,0,38,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,6,0,0,0,0,0,0,0,72,44,0,0,136,0,0,0,137,0,0,0,36,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,67,0,0,0,22,0,0,0,7,0,0,0,61,0,0,0,68,0,0,0,15,0,0,0,2,0,0,0,59,0,0,0,20,0,0,0,46,0,0,0,40,0,0,0,43,0,0,0,2,0,0,0,39,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,7,0,0,0,49,53,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,0,0,0,0,0,0,0,224,81,0,0,224,43,0,0,104,41,0,0,0,0,0,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,88,0,0,0,0,0,0,224,81,0,0,8,44,0,0,248,43,0,0,0,0,0,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,90,0,0,0,0,0,0,224,81,0,0,48,44,0,0,248,43,0,0,0,0,0,0,67,121,108,105,110,100,101,114,90,0,0,0,0,0,0,0,67,121,108,105,110,100,101,114,88,0,0,0,0,0,0,0,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,68,97,116,97,0,0,0,0,0,67,121,108,105,110,100,101,114,89,0,0,0,0,0,0,0,0,0,0,0,248,44,0,0,138,0,0,0,139,0,0,0,2,0,0,0,44,0,0,0,3,0,0,0,40,0,0,0,3,0,0,0,41,0,0,0,69,0,0,0,62,0,0,0,63,0,0,0,45,0,0,0,70,0,0,0,140,0,0,0,49,54,98,116,68,98,118,116,66,114,111,97,100,112,104,97,115,101,0,0,0,0,0,0,224,81,0,0,224,44,0,0,48,20,0,0,0,0,0,0,0,0,0,0,72,45,0,0,141,0,0,0,142,0,0,0,28,0,0,0,71,0,0,0,5,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,50,48,66,114,111,97,100,112,104,97,115,101,65,97,98,98,84,101,115,116,101,114,0,0,224,81,0,0,48,45,0,0,64,35,0,0,0,0,0,0,0,0,0,0,152,45,0,0,143,0,0,0,144,0,0,0,28,0,0,0,72,0,0,0,5,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,49,57,66,114,111,97,100,112,104,97,115,101,82,97,121,84,101,115,116,101,114,0,0,0,224,81,0,0,128,45,0,0,64,35,0,0,0,0,0,0,0,0,0,0,232,45,0,0,145,0,0,0,146,0,0,0,46,0,0,0,73,0,0,0,5,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,49,56,98,116,68,98,118,116,84,114,101,101,67,111,108,108,105,100,101,114,0,0,0,0,224,81,0,0,208,45,0,0,64,35,0,0,0,0,0,0,0,0,0,0,104,46,0,0,147,0,0,0,148,0,0,0,64,0,0,0,65,0,0,0,21,0,0,0,66,0,0,0,51,49,98,116,68,101,102,97,117,108,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,0,50,52,98,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,184,81,0,0,64,46,0,0,224,81,0,0,24,46,0,0,96,46,0,0,0,0,0,0,0,0,0,0,240,46,0,0,149,0,0,0,150,0,0,0,5,0,0,0,0,0,0,0,78,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,51,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,67,114,101,97,116,101,70,117,110,99,0,0,0,0,0,0,0,0,184,81,0,0,192,46,0,0,224,81,0,0,144,46,0,0,232,46,0,0,0,0,0,0,0,0,0,0,72,47,0,0,151,0,0,0,152,0,0,0,6,0,0,0,0,0,0,0,78,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,224,81,0,0,24,47,0,0,232,46,0,0,0,0,0,0,0,0,0,0,168,47,0,0,153,0,0,0,154,0,0,0,7,0,0,0,0,0,0,0,78,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,224,81,0,0,112,47,0,0,232,46,0,0,0,0,0,0,0,0,0,0,8,48,0,0,155,0,0,0,156,0,0,0,8,0,0,0,0,0,0,0,78,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,224,81,0,0,208,47,0,0,232,46,0,0,0,0,0,0,0,0,0,0,88,48,0,0,157,0,0,0,158,0,0,0,9,0,0,0,0,0,0,0,78,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,224,81,0,0,48,48,0,0,232,46,0,0,0,0,0,0,0,0,0,0,184,48,0,0,159,0,0,0,160,0,0,0,10,0,0,0,0,0,0,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,224,81,0,0,128,48,0,0,232,46,0,0,0,0,0,0,0,0,0,0,24,49,0,0,161,0,0,0,162,0,0,0,11,0,0,0,0,0,0,0,78,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,224,81,0,0,224,48,0,0,232,46,0,0,0,0,0,0,0,0,0,0,112,49,0,0,163,0,0,0,164,0,0,0,12,0,0,0,0,0,0,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,224,81,0,0,64,49,0,0,232,46,0,0,0,0,0,0,0,0,0,0,216,49,0,0,165,0,0,0,166,0,0,0,13,0,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,224,81,0,0,152,49,0,0,232,46,0,0,0,0,0,0,0,0,0,0,56,50,0,0,167,0,0,0,168,0,0,0,14,0,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,224,81,0,0,0,50,0,0,232,46,0,0,0,0,0,0,49,50,98,116,68,105,115,112,97,116,99,104,101,114,0,0,184,81,0,0,72,50,0,0,0,0,0,0,184,50,0,0,169,0,0,0,170,0,0,0,4,0,0,0,1,0,0,0,74,0,0,0,0,0,0,0,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,50,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,184,81,0,0,152,50,0,0,224,81,0,0,128,50,0,0,176,50,0,0,0,0,0,0,0,0,0,0,56,51,0,0,18,0,0,0,171,0,0,0,172,0,0,0,35,0,0,0,67,0,0,0,22,0,0,0,75,0,0,0,47,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,104,51,0,0,18,0,0,0,173,0,0,0,174,0,0,0,35,0,0,0,67,0,0,0,22,0,0,0,75,0,0,0,48,0,0,0,43,0,0,0,0,0,0,0,49,51,98,116,71,104,111,115,116,79,98,106,101,99,116,0,224,81,0,0,40,51,0,0,160,27,0,0,0,0,0,0,50,52,98,116,80,97,105,114,67,97,99,104,105,110,103,71,104,111,115,116,79,98,106,101,99,116,0,0,0,0,0,0,224,81,0,0,72,51,0,0,56,51,0,0,0,0,0,0,0,0,0,0,168,51,0,0,175,0,0,0,176,0,0,0,2,0,0,0,0,0,0,0,49,53,98,116,71,106,107,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,224,81,0,0,144,51,0,0,120,40,0,0,0,0,0,0,0,0,0,0,40,52,0,0,177,0,0,0,178,0,0,0,1,0,0,0,0,0,0,0,51,48,98,116,71,106,107,69,112,97,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,51,48,98,116,67,111,110,118,101,120,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,184,81,0,0,248,51,0,0,224,81,0,0,208,51,0,0,32,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,52,0,0,179,0,0,0,180,0,0,0,5,0,0,0,0,0,0,0,49,55,98,116,71,106,107,80,97,105,114,68,101,116,101,99,116,111,114,0,0,0,0,0,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,0,0,184,81,0,0,120,52,0,0,224,81,0,0,96,52,0,0,160,52,0,0,0,0,0,0,0,0,0,0,240,52,0,0,181,0,0,0,182,0,0,0,26,0,0,0,27,0,0,0,5,0,0,0,0,0,0,0,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,0,0,0,0,0,224,81,0,0,216,52,0,0,80,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,57,0,0,183,0,0,0,184,0,0,0,2,0,0,0,0,0,0,0,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,224,81,0,0,0,57,0,0,32,52,0,0,0,0,0,0,0,0,0,0,8,58,0,0,185,0,0,0,186,0,0,0,49,0,0,0,50,0,0,0,6,0,0,0,0,0,0,0,90,78,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,49,50,99,97,108,99,80,101,110,68,101,112,116,104,69,82,50,50,98,116,86,111,114,111,110,111,105,83,105,109,112,108,101,120,83,111,108,118,101,114,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,83,52,95,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,55,95,82,57,98,116,86,101,99,116,111,114,51,83,57,95,83,57,95,80,49,50,98,116,73,68,101,98,117,103,68,114,97,119,69,50,48,98,116,73,110,116,101,114,109,101,100,105,97,116,101,82,101,115,117,108,116,0,0,0,0,0,0,224,81,0,0,88,57,0,0,80,40,0,0,0,0,0,0,0,0,0,0,88,58,0,0,187,0,0,0,188,0,0,0,15,0,0,0,68,0,0,0,23,0,0,0,76,0,0,0,77,0,0,0,16,0,0,0,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,0,0,0,0,0,0,0,0,224,81,0,0,64,58,0,0,112,63,0,0,0,0,0,0,0,0,0,0,224,58,0,0,189,0,0,0,190,0,0,0,44,0,0,0,0,0,0,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,48,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,95,48,0,0,0,0,224,81,0,0,128,58,0,0,136,67,0,0,0,0,0,0,0,0,0,0,112,59,0,0,191,0,0,0,192,0,0,0,45,0,0,0,0,0,0,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,57,81,117,97,110,116,105,122,101,100,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,224,81,0,0,8,59,0,0,136,67,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,60,0,0,193,0,0,0,194,0,0,0,24,0,0,0,17,0,0,0,51,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,52,0,0,0,72,0,0,0,53,0,0,0,78,0,0,0,54,0,0,0,25,0,0,0,73,0,0,0,79,0,0,0,80,0,0,0,0,0,0,0,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,224,81,0,0,240,59,0,0,32,21,0,0,0,0,0,0,0,0,0,0,192,60,0,0,195,0,0,0,196,0,0,0,19,0,0,0,0,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,51,55,114,101,109,111,118,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,67,111,110,116,97,105,110,105,110,103,80,114,111,120,121,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,56,82,101,109,111,118,101,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,224,81,0,0,56,60,0,0,80,27,0,0,0,0,0,0,0,0,0,0,88,61,0,0,197,0,0,0,198,0,0,0,20,0,0,0,0,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,49,57,99,108,101,97,110,80,114,111,120,121,70,114,111,109,80,97,105,114,115,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,55,67,108,101,97,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,224,81,0,0,232,60,0,0,80,27,0,0,0,0,0,0,10,215,163,60,0,0,0,0,0,0,0,0,128,62,0,0,199,0,0,0,200,0,0,0,26,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,81,0,0,0,22,0,0,0,6,0,0,0,1,0,0,0,45,0,0,0,14,0,0,0,2,0,0,0,24,0,0,0,11,0,0,0,46,0,0,0,23,0,0,0,55,0,0,0,2,0,0,0,46,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,51,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,83,104,97,112,101,0,0,0,0,0,0,0,224,81,0,0,96,62,0,0,104,41,0,0,0,0,0,0,51,52,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,65,97,98,98,67,97,99,104,105,110,103,83,104,97,112,101,0,0,0,0,224,81,0,0,144,62,0,0,128,62,0,0,0,0,0,0,0,0,0,0,112,63,0,0,201,0,0,0,202,0,0,0,15,0,0,0,68,0,0,0,23,0,0,0,76,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,116,79,112,116,105,109,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,0,98,116,66,118,104,83,117,98,116,114,101,101,73,110,102,111,68,97,116,97,0,0,0,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,70,108,111,97,116,68,97,116,97,0,49,52,98,116,81,117,97,110,116,105,122,101,100,66,118,104,0,0,0,0,0,0,0,0,184,81,0,0,88,63,0,0,0,0,0,0,224,63,0,0,203,0,0,0,204,0,0,0,23,0,0,0,1,0,0,0,50,53,98,116,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,224,81,0,0,144,63,0,0,88,67,0,0,0,0,0,0,50,56,98,116,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,224,81,0,0,192,63,0,0,88,67,0,0,0,0,0,0,0,0,0,0,144,64,0,0,205,0,0,0,206,0,0,0,47,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,81,0,0,0,22,0,0,0,8,0,0,0,74,0,0,0,45,0,0,0,14,0,0,0,2,0,0,0,24,0,0,0,11,0,0,0,46,0,0,0,23,0,0,0,56,0,0,0,2,0,0,0,48,0,0,0,11,0,0,0,75,0,0,0,57,0,0,0,8,0,0,0,76,0,0,0,77,0,0,0,49,0,0,0,58,0,0,0,78,0,0,0,50,0,0,0,4,0,0,0,51,0,0,0,49,53,98,116,84,114,105,97,110,103,108,101,83,104,97,112,101,0,0,0,0,0,0,0,224,81,0,0,120,64,0,0,128,62,0,0,0,0,0,0,84,114,105,97,110,103,108,101,0,0,0,0,0,0,0,0,0,0,0,0,24,65,0,0,207,0,0,0,208,0,0,0,59,0,0,0,82,0,0,0,105,115,108,97,110,100,85,110,105,111,110,70,105,110,100,65,110,100,81,117,105,99,107,83,111,114,116,0,0,0,0,0,112,114,111,99,101,115,115,73,115,108,97,110,100,115,0,0,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,0,0,0,0,0,184,81,0,0,248,64,0,0,0,0,0,0,152,65,0,0,209,0,0,0,210,0,0,0,52,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,81,0,0,0,22,0,0,0,9,0,0,0,79,0,0,0,45,0,0,0,16,0,0,0,8,0,0,0,24,0,0,0,11,0,0,0,46,0,0,0,60,0,0,0,61,0,0,0,2,0,0,0,53,0,0,0,11,0,0,0,34,0,0,0,25,0,0,0,0,0,0,0,49,51,98,116,83,112,104,101,114,101,83,104,97,112,101,0,224,81,0,0,136,65,0,0,104,41,0,0,0,0,0,0,0,0,0,0,240,65,0,0,211,0,0,0,212,0,0,0,6,0,0,0,2,0,0,0,83,0,0,0,0,0,0,0,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,224,81,0,0,200,65,0,0,208,69,0,0,0,0,0,0,0,0,0,0,72,66,0,0,213,0,0,0,214,0,0,0,7,0,0,0,3,0,0,0,84,0,0,0,0,0,0,0,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,224,81,0,0,32,66,0,0,208,69,0,0,0,0,0,0,0,0,0,0,192,66,0,0,215,0,0,0,216,0,0,0,54,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,85,0,0,0,80,0,0,0,10,0,0,0,81,0,0,0,45,0,0,0,10,0,0,0,3,0,0,0,82,0,0,0,26,0,0,0,46,0,0,0,55,0,0,0,0,0,0,0,49,56,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,0,0,0,0,224,81,0,0,168,66,0,0,232,71,0,0,0,0,0,0,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,68,97,116,97,0,0,83,84,65,84,73,67,80,76,65,78,69,0,0,0,0,0,0,0,0,0,48,67,0,0,217,0,0,0,218,0,0,0,3,0,0,0,0,0,0,0,50,50,98,116,83,117,98,115,105,109,112,108,101,120,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,0,224,81,0,0,16,67,0,0,120,40,0,0,0,0,0,0,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,184,81,0,0,64,67,0,0,51,49,98,116,73,110,116,101,114,110,97,108,84,114,105,97,110,103,108,101,73,110,100,101,120,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,184,81,0,0,96,67,0,0,0,0,0,0,240,67,0,0,219,0,0,0,220,0,0,0,56,0,0,0,1,0,0,0,2,0,0,0,86,0,0,0,87,0,0,0,83,0,0,0,88,0,0,0,89,0,0,0,84,0,0,0,62,0,0,0,63,0,0,0,85,0,0,0,27,0,0,0,0,0,0,0,49,52,98,116,84,114,105,97,110,103,108,101,77,101,115,104,0,0,0,0,0,0,0,0,224,81,0,0,216,67,0,0,32,78,0,0,0,0,0,0,0,0,0,0,112,68,0,0,221,0,0,0,222,0,0,0,14,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,90,0,0,0,29,0,0,0,2,0,0,0,86,0,0,0,45,0,0,0,10,0,0,0,3,0,0,0,87,0,0,0,28,0,0,0,46,0,0,0,57,0,0,0,18,0,0,0,19,0,0,0,0,0,0,0,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,224,81,0,0,88,68,0,0,232,71,0,0,0,0,0,0,84,82,73,65,78,71,76,69,77,69,83,72,0,0,0,0,0,0,0,0,192,68,0,0,223,0,0,0,224,0,0,0,58,0,0,0,0,0,0,0,50,49,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,224,81,0,0,168,68,0,0,88,67,0,0,0,0,0,0,0,0,0,0,80,69,0,0,225,0,0,0,226,0,0,0,59,0,0,0,0,0,0,0,90,78,75,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,49,54,70,105,108,116,101,114,101,100,67,97,108,108,98,97,99,107,0,0,0,224,81,0,0,232,68,0,0,136,67,0,0,0,0,0,0,0,0,0,0,152,69,0,0,227,0,0,0,228,0,0,0,8,0,0,0,0,0,0,0,50,50,83,112,104,101,114,101,84,114,105,97,110,103,108,101,68,101,116,101,99,116,111,114,0,0,0,0,0,0,0,0,224,81,0,0,120,69,0,0,160,52,0,0,0,0,0,0,51,48,98,116,65,99,116,105,118,97,116,105,110,103,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,0,224,81,0,0,168,69,0,0,176,50,0,0,0,0,0,0,0,0,0,0,32,70,0,0,229,0,0,0,230,0,0,0,9,0,0,0,4,0,0,0,91,0,0,0,0,0,0,0,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,224,81,0,0,0,70,0,0,208,69,0,0,0,0,0,0,0,0,0,0,96,70,0,0,231,0,0,0,232,0,0,0,10,0,0,0,0,0,0,0,49,54,98,116,66,111,120,66,111,120,68,101,116,101,99,116,111,114,0,0,0,0,0,0,224,81,0,0,72,70,0,0,160,52,0,0,0,0,0,0,0,0,0,0,176,70,0,0,233,0,0,0,234,0,0,0,11,0,0,0,5,0,0,0,92,0,0,0,0,0,0,0,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,224,81,0,0,144,70,0,0,208,69,0,0,0,0,0,0,0,0,0,0,8,71,0,0,235,0,0,0,236,0,0,0,28,0,0,0,93,0,0,0,5,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,50,50,98,116,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,224,81,0,0,232,70,0,0,64,35,0,0,0,0,0,0,0,0,0,0,96,71,0,0,237,0,0,0,238,0,0,0,12,0,0,0,6,0,0,0,94,0,0,0,0,0,0,0,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,224,81,0,0,56,71,0,0,208,69,0,0,0,0,0,0,0,0,0,0,192,71,0,0,239,0,0,0,240,0,0,0,64,0,0,0,95,0,0,0,5,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,51,48,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,224,81,0,0,152,71,0,0,64,35,0,0,0,0,0,0,49,52,98,116,67,111,110,99,97,118,101,83,104,97,112,101,0,0,0,0,0,0,0,0,224,81,0,0,208,71,0,0,216,27,0,0,0,0,0,0,0,0,0,0,88,72,0,0,241,0,0,0,242,0,0,0,13,0,0,0,7,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,136,72,0,0,243,0,0,0,244,0,0,0,60,0,0,0,0,0,0,0,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,224,81,0,0,48,72,0,0,208,69,0,0,0,0,0,0,50,52,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,0,224,81,0,0,104,72,0,0,88,67,0,0,0,0,0,0,0,0,0,0,80,73,0,0,245,0,0,0,246,0,0,0,61,0,0,0,0,0,0,0,90,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,0,0,224,81,0,0,176,72,0,0,88,67,0,0,0,0,0,0,0,0,0,0,240,73,0,0,247,0,0,0,248,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,184,73,0,0,249,0,0,0,250,0,0,0,14,0,0,0,8,0,0,0,97,0,0,0,0,0,0,0,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,224,81,0,0,152,73,0,0,208,69,0,0,0,0,0,0,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,224,81,0,0,200,73,0,0,232,46,0,0,0,0,0,0,0,0,0,0,64,74,0,0,251,0,0,0,252,0,0,0,26,0,0,0,27,0,0,0,7,0,0,0,0,0,0,0,50,52,98,116,80,101,114,116,117,114,98,101,100,67,111,110,116,97,99,116,82,101,115,117,108,116,0,0,0,0,0,0,224,81,0,0,32,74,0,0,240,52,0,0,0,0,0,0,0,0,0,0,0,75,0,0,253,0,0,0,254,0,0,0,65,0,0,0,66,0,0,0,8,0,0,0,0,0,0,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,50,49,98,116,87,105,116,104,111,117,116,77,97,114,103,105,110,82,101,115,117,108,116,95,48,0,0,224,81,0,0,112,74,0,0,80,40,0,0,0,0,0,0,0,0,0,0,184,75,0,0,255,0,0,0,0,1,0,0,67,0,0,0,68,0,0,0,9,0,0,0,0,0,0,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,49,51,98,116,68,117,109,109,121,82,101,115,117,108,116,0,0,0,0,224,81,0,0,48,75,0,0,80,40,0,0,0,0,0,0,0,0,0,0,16,76,0,0,1,1,0,0,2,1,0,0,15,0,0,0,9,0,0,0,98,0,0,0,0,0,0,0,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,224,81,0,0,232,75,0,0,176,50,0,0,0,0,0,0,0,0,0,0,72,76,0,0,3,1,0,0,4,1,0,0,49,56,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,0,0,0,0,184,81,0,0,48,76,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,76,0,0,5,1,0,0,6,1,0,0,29,0,0,0,30,0,0,0,88,0,0,0,0,0,0,0,50,51,98,116,72,97,115,104,101,100,83,105,109,112,108,101,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,184,81,0,0,168,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,116,73,110,116,73,110,100,101,120,68,97,116,97,0,0,98,116,83,104,111,114,116,73,110,116,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,0,0,0,0,0,98,116,67,104,97,114,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,0,98,116,86,101,99,116,111,114,51,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,98,116,86,101,99,116,111,114,51,68,111,117,98,108,101,68,97,116,97,0,0,0,0,0,98,116,77,101,115,104,80,97,114,116,68,97,116,97,0,0,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,68,97,116,97,0,0,0,0,0,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,0,0,0,0,0,0,0,184,81,0,0,144,77,0,0,0,0,0,0,32,78,0,0,7,1,0,0,8,1,0,0,56,0,0,0,1,0,0,0,2,0,0,0,86,0,0,0,87,0,0,0,83,0,0,0,99,0,0,0,100,0,0,0,84,0,0,0,62,0,0,0,63,0,0,0,85,0,0,0,27,0,0,0,0,0,0,0,50,54,98,116,84,114,105,97,110,103,108,101,73,110,100,101,120,86,101,114,116,101,120,65,114,114,97,121,0,0,0,0,224,81,0,0,0,78,0,0,176,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,111,111,116,0,0,0,0,72,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,117,110,99,97,117,103,104,116,0,0,0,0,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,0,0,0,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,0,0,116,101,114,109,105,110,97,116,105,110,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,0,0,0,0,0,0,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,0,0,0,0,0,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,0,0,0,0,0,0,0,40,80,0,0,9,1,0,0,10,1,0,0,89],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10240);allocate([115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,224,81,0,0,24,80,0,0,176,80,0,0,0,0,0,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,116,104,114,101,119,32,97,110,32,101,120,99,101,112,116,105,111,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,184,81,0,0,160,80,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,184,81,0,0,184,80,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,224,81,0,0,208,80,0,0,200,80,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,224,81,0,0,8,81,0,0,248,80,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,224,81,0,0,104,81,0,0,248,80,0,0,0,0,0,0,224,81,0,0,64,81,0,0,144,81,0,0,0,0,0,0,0,0,0,0,48,81,0,0,11,1,0,0,12,1,0,0,13,1,0,0,14,1,0,0,31,0,0,0,4,0,0,0,16,0,0,0,62,0,0,0,0,0,0,0,40,82,0,0,11,1,0,0,15,1,0,0,13,1,0,0,14,1,0,0,31,0,0,0,5,0,0,0,17,0,0,0,63,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,224,81,0,0,0,82,0,0,48,81,0,0,0,0,0,0,0,0,0,0,136,82,0,0,11,1,0,0,16,1,0,0,13,1,0,0,14,1,0,0,31,0,0,0,6,0,0,0,18,0,0,0,64,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,224,81,0,0,96,82,0,0,48,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+20480);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}var _cosf=Math_cos;Module["_i64Subtract"]=_i64Subtract;var _fabsf=Math_abs;var ___errno_state=0;function ___setErrNo(value){HEAP32[___errno_state>>2]=value;return value}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 79:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}Module["_memset"]=_memset;function _abort(){Module["abort"]()}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}var _acosf=Math_acos;Module["_strlen"]=_strlen;var _sqrtf=Math_sqrt;var FS=undefined;var SOCKFS=undefined;function _send(fd,buf,len,flags){var sock=SOCKFS.getSocket(fd);if(!sock){___setErrNo(ERRNO_CODES.EBADF);return-1}return _write(fd,buf,len)}function _pwrite(fildes,buf,nbyte,offset){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte,offset)}catch(e){FS.handleFSError(e);return-1}}function _write(fildes,buf,nbyte){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte)}catch(e){FS.handleFSError(e);return-1}}function _fileno(stream){stream=FS.getStreamFromPtr(stream);if(!stream)return-1;return stream.fd}function _fputc(c,stream){var chr=unSign(c&255);HEAP8[_fputc.ret>>0]=chr;var fd=_fileno(stream);var ret=_write(fd,_fputc.ret,1);if(ret==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return-1}else{return chr}}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}Module["_i64Add"]=_i64Add;var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}var _llvm_pow_f32=Math_pow;function _fmod(x,y){return x%y}function _fmodf(){return _fmod.apply(null,arguments)}function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}var _atan2f=Math_atan2;function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function ___cxa_guard_release(){}var _asinf=Math_asin;function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}function _emscripten_asm_const_double(code){var args=Array.prototype.slice.call(arguments,1);return+Runtime.getAsmConst(code,args.length).apply(null,args)}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}var _sinf=Math_sin;function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0)self.alloc(bytes);return ret}Module["_memmove"]=_memmove;function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function ___cxa_allocate_exception(size){return _malloc(size)}function ___errno_location(){return ___errno_state}Module["_llvm_bswap_i32"]=_llvm_bswap_i32;function _llvm_trap(){abort("trap!")}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}var _UItoF=true;function _fwrite(ptr,size,nitems,stream){var bytesToWrite=nitems*size;if(bytesToWrite==0)return 0;var fd=_fileno(stream);var bytesWritten=_write(fd,ptr,bytesToWrite);if(bytesWritten==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return 0}else{return bytesWritten/size|0}}function __reallyNegative(x){return x<0||x===0&&1/x===-Infinity}function __formatString(format,varargs){var textIndex=format;var argIndex=0;function getNextArg(type){var ret;if(type==="double"){ret=(HEAP32[tempDoublePtr>>2]=HEAP32[varargs+argIndex>>2],HEAP32[tempDoublePtr+4>>2]=HEAP32[varargs+(argIndex+4)>>2],+HEAPF64[tempDoublePtr>>3])}else if(type=="i64"){ret=[HEAP32[varargs+argIndex>>2],HEAP32[varargs+(argIndex+4)>>2]]}else{type="i32";ret=HEAP32[varargs+argIndex>>2]}argIndex+=Runtime.getNativeFieldSize(type);return ret}var ret=[];var curr,next,currArg;while(1){var startTextIndex=textIndex;curr=HEAP8[textIndex>>0];if(curr===0)break;next=HEAP8[textIndex+1>>0];if(curr==37){var flagAlwaysSigned=false;var flagLeftAlign=false;var flagAlternative=false;var flagZeroPad=false;var flagPadSign=false;flagsLoop:while(1){switch(next){case 43:flagAlwaysSigned=true;break;case 45:flagLeftAlign=true;break;case 35:flagAlternative=true;break;case 48:if(flagZeroPad){break flagsLoop}else{flagZeroPad=true;break};case 32:flagPadSign=true;break;default:break flagsLoop}textIndex++;next=HEAP8[textIndex+1>>0]}var width=0;if(next==42){width=getNextArg("i32");textIndex++;next=HEAP8[textIndex+1>>0]}else{while(next>=48&&next<=57){width=width*10+(next-48);textIndex++;next=HEAP8[textIndex+1>>0]}}var precisionSet=false,precision=-1;if(next==46){precision=0;precisionSet=true;textIndex++;next=HEAP8[textIndex+1>>0];if(next==42){precision=getNextArg("i32");textIndex++}else{while(1){var precisionChr=HEAP8[textIndex+1>>0];if(precisionChr<48||precisionChr>57)break;precision=precision*10+(precisionChr-48);textIndex++}}next=HEAP8[textIndex+1>>0]}if(precision<0){precision=6;precisionSet=false}var argSize;switch(String.fromCharCode(next)){case"h":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==104){textIndex++;argSize=1}else{argSize=2}break;case"l":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==108){textIndex++;argSize=8}else{argSize=4}break;case"L":case"q":case"j":argSize=8;break;case"z":case"t":case"I":argSize=4;break;default:argSize=null}if(argSize)textIndex++;next=HEAP8[textIndex+1>>0];switch(String.fromCharCode(next)){case"d":case"i":case"u":case"o":case"x":case"X":case"p":{var signed=next==100||next==105;argSize=argSize||4;var currArg=getNextArg("i"+argSize*8);var origArg=currArg;var argText;if(argSize==8){currArg=Runtime.makeBigInt(currArg[0],currArg[1],next==117)}if(argSize<=4){var limit=Math.pow(256,argSize)-1;currArg=(signed?reSign:unSign)(currArg&limit,argSize*8)}var currAbsArg=Math.abs(currArg);var prefix="";if(next==100||next==105){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],null);else argText=reSign(currArg,8*argSize,1).toString(10)}else if(next==117){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],true);else argText=unSign(currArg,8*argSize,1).toString(10);currArg=Math.abs(currArg)}else if(next==111){argText=(flagAlternative?"0":"")+currAbsArg.toString(8)}else if(next==120||next==88){prefix=flagAlternative&&currArg!=0?"0x":"";if(argSize==8&&i64Math){if(origArg[1]){argText=(origArg[1]>>>0).toString(16);var lower=(origArg[0]>>>0).toString(16);while(lower.length<8)lower="0"+lower;argText+=lower}else{argText=(origArg[0]>>>0).toString(16)}}else if(currArg<0){currArg=-currArg;argText=(currAbsArg-1).toString(16);var buffer=[];for(var i=0;i<argText.length;i++){buffer.push((15-parseInt(argText[i],16)).toString(16))}argText=buffer.join("");while(argText.length<argSize*2)argText="f"+argText}else{argText=currAbsArg.toString(16)}if(next==88){prefix=prefix.toUpperCase();argText=argText.toUpperCase()}}else if(next==112){if(currAbsArg===0){argText="(nil)"}else{prefix="0x";argText=currAbsArg.toString(16)}}if(precisionSet){while(argText.length<precision){argText="0"+argText}}if(currArg>=0){if(flagAlwaysSigned){prefix="+"+prefix}else if(flagPadSign){prefix=" "+prefix}}if(argText.charAt(0)=="-"){prefix="-"+prefix;argText=argText.substr(1)}while(prefix.length+argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad){argText="0"+argText}else{prefix=" "+prefix}}}argText=prefix+argText;argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"f":case"F":case"e":case"E":case"g":case"G":{var currArg=getNextArg("double");var argText;if(isNaN(currArg)){argText="nan";flagZeroPad=false}else if(!isFinite(currArg)){argText=(currArg<0?"-":"")+"inf";flagZeroPad=false}else{var isGeneral=false;var effectivePrecision=Math.min(precision,20);if(next==103||next==71){isGeneral=true;precision=precision||1;var exponent=parseInt(currArg.toExponential(effectivePrecision).split("e")[1],10);if(precision>exponent&&exponent>=-4){next=(next==103?"f":"F").charCodeAt(0);precision-=exponent+1}else{next=(next==103?"e":"E").charCodeAt(0);precision--}effectivePrecision=Math.min(precision,20)}if(next==101||next==69){argText=currArg.toExponential(effectivePrecision);if(/[eE][-+]\d$/.test(argText)){argText=argText.slice(0,-1)+"0"+argText.slice(-1)}}else if(next==102||next==70){argText=currArg.toFixed(effectivePrecision);if(currArg===0&&__reallyNegative(currArg)){argText="-"+argText}}var parts=argText.split("e");if(isGeneral&&!flagAlternative){while(parts[0].length>1&&parts[0].indexOf(".")!=-1&&(parts[0].slice(-1)=="0"||parts[0].slice(-1)==".")){parts[0]=parts[0].slice(0,-1)}}else{if(flagAlternative&&argText.indexOf(".")==-1)parts[0]+=".";while(precision>effectivePrecision++)parts[0]+="0"}argText=parts[0]+(parts.length>1?"e"+parts[1]:"");if(next==69)argText=argText.toUpperCase();if(currArg>=0){if(flagAlwaysSigned){argText="+"+argText}else if(flagPadSign){argText=" "+argText}}}while(argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad&&(argText[0]=="-"||argText[0]=="+")){argText=argText[0]+"0"+argText.slice(1)}else{argText=(flagZeroPad?"0":" ")+argText}}}if(next<97)argText=argText.toUpperCase();argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"s":{var arg=getNextArg("i8*");var argLength=arg?_strlen(arg):"(null)".length;if(precisionSet)argLength=Math.min(argLength,precision);if(!flagLeftAlign){while(argLength<width--){ret.push(32)}}if(arg){for(var i=0;i<argLength;i++){ret.push(HEAPU8[arg++>>0])}}else{ret=ret.concat(intArrayFromString("(null)".substr(0,argLength),true))}if(flagLeftAlign){while(argLength<width--){ret.push(32)}}break};case"c":{if(flagLeftAlign)ret.push(getNextArg("i8"));while(--width>0){ret.push(32)}if(!flagLeftAlign)ret.push(getNextArg("i8"));break};case"n":{var ptr=getNextArg("i32*");HEAP32[ptr>>2]=ret.length;break};case"%":{ret.push(curr);break};default:{for(var i=startTextIndex;i<textIndex+2;i++){ret.push(HEAP8[i>>0])}}}textIndex+=2}else{ret.push(curr);textIndex+=1}}return ret}function _fprintf(stream,format,varargs){var result=__formatString(format,varargs);var stack=Runtime.stackSave();var ret=_fwrite(allocate(result,"i8",ALLOC_STACK),1,result.length,stream);Runtime.stackRestore(stack);return ret}function _vfprintf(s,f,va_arg){return _fprintf(s,f,HEAP32[va_arg>>2])}var _stderr=allocate(1,"i32*",ALLOC_STATIC);___errno_state=Runtime.staticAlloc(4);HEAP32[___errno_state>>2]=0;_fputc.ret=allocate([0],"i8",ALLOC_STATIC);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var ctlz_i8=allocate([8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_DYNAMIC);var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vid(index,a1,a2){try{Module["dynCall_vid"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiidii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidi(index,a1,a2,a3,a4){try{Module["dynCall_viidi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viddiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidii(index,a1,a2,a3,a4){try{Module["dynCall_vidii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidi(index,a1,a2,a3){try{Module["dynCall_vidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_diiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiddddiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{Module["dynCall_viiiiddddiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiidii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_diiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_diiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiid(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_diiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_did(index,a1,a2){try{return Module["dynCall_did"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidddddidi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiidddddidi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diidii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiii(index,a1,a2,a3,a4){try{return Module["dynCall_diiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiid(index,a1,a2,a3,a4){try{Module["dynCall_viiid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iidid(index,a1,a2,a3,a4){try{return Module["dynCall_iidid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array};Module.asmLibraryArg={"abort":abort,"assert":assert,"min":Math_min,"invoke_viiiii":invoke_viiiii,"invoke_vid":invoke_vid,"invoke_vi":invoke_vi,"invoke_viiidii":invoke_viiidii,"invoke_vii":invoke_vii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_ii":invoke_ii,"invoke_viidi":invoke_viidi,"invoke_viddiii":invoke_viddiii,"invoke_vidii":invoke_vidii,"invoke_iiiii":invoke_iiiii,"invoke_vidi":invoke_vidi,"invoke_diiiiiiii":invoke_diiiiiiii,"invoke_viiiiddddiid":invoke_viiiiddddiid,"invoke_diiiii":invoke_diiiii,"invoke_iiii":invoke_iiii,"invoke_viiiiii":invoke_viiiiii,"invoke_iiid":invoke_iiid,"invoke_di":invoke_di,"invoke_iiiiiii":invoke_iiiiiii,"invoke_diiidii":invoke_diiidii,"invoke_viidii":invoke_viidii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"invoke_iii":invoke_iii,"invoke_diii":invoke_diii,"invoke_diiiiiiiiii":invoke_diiiiiiiiii,"invoke_viiiid":invoke_viiiid,"invoke_diiiiiiiii":invoke_diiiiiiiii,"invoke_did":invoke_did,"invoke_viiiidddddidi":invoke_viiiidddddidi,"invoke_diidii":invoke_diidii,"invoke_diiii":invoke_diiii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_viiid":invoke_viiid,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_viid":invoke_viid,"invoke_iidid":invoke_iidid,"invoke_viiii":invoke_viiii,"_emscripten_asm_const_double":_emscripten_asm_const_double,"_cosf":_cosf,"_send":_send,"_sqrtf":_sqrtf,"_fmod":_fmod,"___cxa_guard_acquire":___cxa_guard_acquire,"___setErrNo":___setErrNo,"_vfprintf":_vfprintf,"_atan2f":_atan2f,"_fmodf":_fmodf,"___cxa_guard_release":___cxa_guard_release,"_pwrite":_pwrite,"_acosf":_acosf,"_asinf":_asinf,"_fabsf":_fabsf,"_sbrk":_sbrk,"_llvm_pow_f32":_llvm_pow_f32,"___cxa_begin_catch":___cxa_begin_catch,"_sinf":_sinf,"_fileno":_fileno,"___resumeException":___resumeException,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_sysconf":_sysconf,"__reallyNegative":__reallyNegative,"_pthread_getspecific":_pthread_getspecific,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_pthread_once":_pthread_once,"_pthread_key_create":_pthread_key_create,"_write":_write,"___errno_location":___errno_location,"_pthread_setspecific":_pthread_setspecific,"_fputc":_fputc,"___cxa_throw":___cxa_throw,"_abort":_abort,"___cxa_allocate_exception":___cxa_allocate_exception,"_fwrite":_fwrite,"_time":_time,"_fprintf":_fprintf,"_gettimeofday":_gettimeofday,"__formatString":__formatString,"_llvm_trap":_llvm_trap,"___cxa_pure_virtual":___cxa_pure_virtual,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8,"ctlz_i8":ctlz_i8,"NaN":NaN,"Infinity":Infinity,"_stderr":_stderr};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.ctlz_i8|0;var o=env._stderr|0;var p=0;var q=0;var r=0;var s=0;var t=+env.NaN,u=+env.Infinity;var v=0,w=0,x=0,y=0,z=0.0,A=0,B=0,C=0,D=0.0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=0;var O=global.Math.floor;var P=global.Math.abs;var Q=global.Math.sqrt;var R=global.Math.pow;var S=global.Math.cos;var T=global.Math.sin;var U=global.Math.tan;var V=global.Math.acos;var W=global.Math.asin;var X=global.Math.atan;var Y=global.Math.atan2;var Z=global.Math.exp;var _=global.Math.log;var $=global.Math.ceil;var aa=global.Math.imul;var ba=env.abort;var ca=env.assert;var da=env.min;var ea=env.invoke_viiiii;var fa=env.invoke_vid;var ga=env.invoke_vi;var ha=env.invoke_viiidii;var ia=env.invoke_vii;var ja=env.invoke_iiiiiiiiiii;var ka=env.invoke_ii;var la=env.invoke_viidi;var ma=env.invoke_viddiii;var na=env.invoke_vidii;var oa=env.invoke_iiiii;var pa=env.invoke_vidi;var qa=env.invoke_diiiiiiii;var ra=env.invoke_viiiiddddiid;var sa=env.invoke_diiiii;var ta=env.invoke_iiii;var ua=env.invoke_viiiiii;var va=env.invoke_iiid;var wa=env.invoke_di;var xa=env.invoke_iiiiiii;var ya=env.invoke_diiidii;var za=env.invoke_viidii;var Aa=env.invoke_viiiiiii;var Ba=env.invoke_viiiiiiiii;var Ca=env.invoke_viiiiiiiiii;var Da=env.invoke_iii;var Ea=env.invoke_diii;var Fa=env.invoke_diiiiiiiiii;var Ga=env.invoke_viiiid;var Ha=env.invoke_diiiiiiiii;var Ia=env.invoke_did;var Ja=env.invoke_viiiidddddidi;var Ka=env.invoke_diidii;var La=env.invoke_diiii;var Ma=env.invoke_iiiiiiiiii;var Na=env.invoke_viiid;var Oa=env.invoke_viii;var Pa=env.invoke_v;var Qa=env.invoke_viid;var Ra=env.invoke_iidid;var Sa=env.invoke_viiii;var Ta=env._emscripten_asm_const_double;var Ua=env._cosf;var Va=env._send;var Wa=env._sqrtf;var Xa=env._fmod;var Ya=env.___cxa_guard_acquire;var Za=env.___setErrNo;var _a=env._vfprintf;var $a=env._atan2f;var ab=env._fmodf;var bb=env.___cxa_guard_release;var cb=env._pwrite;var db=env._acosf;var eb=env._asinf;var fb=env._fabsf;var gb=env._sbrk;var hb=env._llvm_pow_f32;var ib=env.___cxa_begin_catch;var jb=env._sinf;var kb=env._fileno;var lb=env.___resumeException;var mb=env.___cxa_find_matching_catch;var nb=env._sysconf;var ob=env.__reallyNegative;var pb=env._pthread_getspecific;var qb=env.__ZSt18uncaught_exceptionv;var rb=env._emscripten_memcpy_big;var sb=env._pthread_once;var tb=env._pthread_key_create;var ub=env._write;var vb=env.___errno_location;var wb=env._pthread_setspecific;var xb=env._fputc;var yb=env.___cxa_throw;var zb=env._abort;var Ab=env.___cxa_allocate_exception;var Bb=env._fwrite;var Cb=env._time;var Db=env._fprintf;var Eb=env._gettimeofday;var Fb=env.__formatString;var Gb=env._llvm_trap;var Hb=env.___cxa_pure_virtual;var Ib=0.0;
// EMSCRIPTEN_START_FUNCS
function wc(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function xc(){return i|0}function yc(a){a=a|0;i=a}function zc(a,b){a=a|0;b=b|0;if(!p){p=a;q=b}}function Ac(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function Bc(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function Cc(a){a=a|0;E=a}function Dc(){return E|0}function Ec(a){a=a|0;return 52}function Fc(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0.0,f=0.0,h=0.0;e=+S(+b);f=+S(+c);h=+S(+d);b=+T(+b);c=+T(+c);d=+T(+d);g[a>>2]=f*h;g[a+4>>2]=c*b*h-e*d;g[a+8>>2]=c*e*h+b*d;g[a+12>>2]=0.0;g[a+16>>2]=f*d;g[a+20>>2]=c*b*d+e*h;g[a+24>>2]=c*e*d-b*h;g[a+28>>2]=0.0;g[a+32>>2]=-c;g[a+36>>2]=f*b;g[a+40>>2]=f*e;g[a+44>>2]=0.0;return}function Gc(a,b){a=a|0;b=b|0;var c=0;c=i;Hc(a,b);i=c;return}function Hc(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,h=0,j=0.0,k=0,l=0;c=i;i=i+16|0;f=+g[a>>2];e=+g[a+20>>2];d=+g[a+40>>2];if(f+e+d>0.0){f=+Q(+(f+e+d+1.0));g[c+12>>2]=f*.5;j=(+g[a+36>>2]- +g[a+24>>2])*(.5/f);g[c>>2]=j;d=(+g[a+8>>2]- +g[a+32>>2])*(.5/f);g[c+4>>2]=d;e=(+g[a+16>>2]- +g[a+4>>2])*(.5/f);g[c+8>>2]=e;f=f*.5;g[b>>2]=j;h=b+4|0;g[h>>2]=d;h=b+8|0;g[h>>2]=e;h=b+12|0;g[h>>2]=f;i=c;return}if(f<e)h=e<d?2:1;else h=f<d?2:0;l=((h+1|0)>>>0)%3|0;k=((h+2|0)>>>0)%3|0;d=+Q(+(+g[a+(h<<4)+(h<<2)>>2]- +g[a+(l<<4)+(l<<2)>>2]- +g[a+(k<<4)+(k<<2)>>2]+1.0));g[c+(h<<2)>>2]=d*.5;g[c+12>>2]=(+g[a+(k<<4)+(l<<2)>>2]- +g[a+(l<<4)+(k<<2)>>2])*(.5/d);g[c+(l<<2)>>2]=(+g[a+(l<<4)+(h<<2)>>2]+ +g[a+(h<<4)+(l<<2)>>2])*(.5/d);g[c+(k<<2)>>2]=(+g[a+(k<<4)+(h<<2)>>2]+ +g[a+(h<<4)+(k<<2)>>2])*(.5/d);d=+g[c>>2];e=+g[c+4>>2];f=+g[c+8>>2];j=+g[c+12>>2];g[b>>2]=d;h=b+4|0;g[h>>2]=e;h=b+8|0;g[h>>2]=f;h=b+12|0;g[h>>2]=j;i=c;return}function Ic(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function Jc(){var a=0,d=0,e=0;a=i;d=fF(8)|0;a:do if(!d){while(1){d=c[5158]|0;c[5158]=d+0;if(!d)break;sc[d&3]();d=fF(8)|0;if(d)break a}d=Ab(4)|0;c[d>>2]=20472;yb(d|0,20520,265)}while(0);e=d;c[e>>2]=0;c[e+4>>2]=0;b[d+4>>1]=1;b[d+6>>1]=-1;c[d>>2]=840;i=a;return d|0}function Kc(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0.0,l=0;l=i;k=+Vb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,j);i=l;return+k}function Lc(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Mc(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(95)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}ft(e,a,b,1);i=d;return e|0}function Nc(a){a=a|0;ib(a|0)|0;IE()}function Oc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;c[5004]=(c[5004]|0)+1;f=fF(95)|0;if(!f)f=0;else{c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}ft(f,a,b,d);i=e;return f|0}function Pc(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Qc(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Rc(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Sc(){var a=0,b=0;a=i;b=fF(196)|0;a:do if(!b){while(1){b=c[5158]|0;c[5158]=b+0;if(!b)break;sc[b&3]();b=fF(196)|0;if(b)break a}b=Ab(4)|0;c[b>>2]=20472;yb(b|0,20520,265)}while(0);Zx(b,0);i=a;return b|0}function Tc(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Uc(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function Vc(){var b=0,d=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(215)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}c[d>>2]=4024;a[d+20>>0]=1;c[d+16>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;a[d+40>>0]=1;c[d+36>>2]=0;c[d+28>>2]=0;c[d+32>>2]=0;a[d+60>>0]=1;c[d+56>>2]=0;c[d+48>>2]=0;c[d+52>>2]=0;a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;c[d+72>>2]=0;a[d+100>>0]=1;c[d+96>>2]=0;c[d+88>>2]=0;c[d+92>>2]=0;a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;a[d+140>>0]=1;c[d+136>>2]=0;c[d+128>>2]=0;c[d+132>>2]=0;a[d+160>>0]=1;c[d+156>>2]=0;c[d+148>>2]=0;c[d+152>>2]=0;a[d+180>>0]=1;c[d+176>>2]=0;c[d+168>>2]=0;c[d+172>>2]=0;c[d+192>>2]=0;i=b;return d|0}function Wc(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Xc(a){a=a|0;return+(+g[a>>2])}function Yc(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Zc(a){a=a|0;return c[a+4>>2]|0}function _c(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function $c(a){a=a|0;return c[a+8>>2]|0}function ad(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function bd(a){a=a|0;return+(+g[a+12>>2])}function cd(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function dd(b){b=b|0;return(a[b+16>>0]&1)!=0|0}function ed(b,c){b=b|0;c=c|0;a[b+16>>0]=c&1;return}function fd(b){b=b|0;return(a[b+24>>0]&1)!=0|0}function gd(b,c){b=b|0;c=c|0;a[b+24>>0]=c&1;return}function hd(b){b=b|0;return(a[b+25>>0]&1)!=0|0}function id(b,c){b=b|0;c=c|0;a[b+25>>0]=c&1;return}function jd(b){b=b|0;return(a[b+26>>0]&1)!=0|0}function kd(b,c){b=b|0;c=c|0;a[b+26>>0]=c&1;return}function ld(a){a=a|0;return+(+g[a+28>>2])}function md(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function nd(b){b=b|0;return(a[b+32>>0]&1)!=0|0}function od(b,c){b=b|0;c=c|0;a[b+32>>0]=c&1;return}function pd(a){a=a|0;return+(+g[a+36>>2])}function qd(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function rd(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function sd(a,b){a=+a;b=+b;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(75)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e>>2]=6296;c[e+4>>2]=10;c[e+52>>2]=1;g[e+28>>2]=a;g[e+32>>2]=b*.5;g[e+36>>2]=a;g[e+40>>2]=0.0;i=d;return e|0}function td(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function ud(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function vd(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function wd(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function xd(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(135)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}_r(e,a,b,16384,0,0);i=d;return e|0}function yd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;c[5004]=(c[5004]|0)+1;f=fF(135)|0;if(!f)f=0;else{c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}_r(f,a,b,d&65535,0,0);i=e;return f|0}function zd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;c[5004]=(c[5004]|0)+1;g=fF(135)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}_r(g,a,b,d&65535,e,0);i=f;return g|0}function Ad(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;c[5004]=(c[5004]|0)+1;h=fF(135)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}_r(h,a,b,d&65535,e,f);i=g;return h|0}function Bd(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Cd(){var b=0,d=0,e=0,f=0,h=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(307)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}g[d+164>>2]=1.0;g[d+168>>2]=1.0;g[d+172>>2]=1.0;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749400.0;h=d+188|0;e=d+204|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;e=d+236|0;c[d+240>>2]=0;g[d+244>>2]=1.0;h=d+248|0;f=d+4|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;g[f>>2]=1.0;f=d+8|0;h=d+24|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;g[h>>2]=1.0;h=d+28|0;f=d+44|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;g[f>>2]=1.0;f=d+48|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;a[d+280>>0]=1;c[d+276>>2]=0;c[d+268>>2]=0;c[d+272>>2]=0;c[e>>2]=4;c[d>>2]=13056;c[5004]=(c[5004]|0)+1;e=fF(95)|0;if(!e){f=0;h=d+284|0;c[h>>2]=f;i=b;return d|0}c[(e+19&-16)+ -4>>2]=e;if(!(e+19&-16)){f=0;h=d+284|0;c[h>>2]=f;i=b;return d|0}Yz(e+19&-16);f=e+19&-16;h=d+284|0;c[h>>2]=f;i=b;return d|0}function Dd(a){a=a|0;return c[a+192>>2]|0}function Ed(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Fd(a,b){a=a|0;b=b|0;var d=0;d=i;if(((c[a+216>>2]|0)+ -4|0)>>>0<2){i=d;return}c[a+216>>2]=b;i=d;return}function Gd(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Hd(a){a=a|0;var b=0;b=i;if(c[a+204>>2]&3){i=b;return}if(((c[a+216>>2]|0)+ -4|0)>>>0>=2)c[a+216>>2]=1;g[a+220>>2]=0.0;i=b;return}function Id(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b?(c[a+204>>2]&3|0)!=0:0){i=d;return}if(((c[a+216>>2]|0)+ -4|0)>>>0>=2)c[a+216>>2]=1;g[a+220>>2]=0.0;i=d;return}function Jd(a){a=a|0;a=c[a+216>>2]|0;return((a|0)==2?0:(a|0)!=5)|0}function Kd(a){a=a|0;return(c[a+204>>2]&2|0)!=0|0}function Ld(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Md(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Nd(a){a=a|0;return a+4|0}function Od(a){a=a|0;return c[a+204>>2]|0}function Pd(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Qd(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];i=d;return}function Rd(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function Sd(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Td(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Ud(a){a=a|0;return c[a+268>>2]|0}function Vd(a,b){a=a|0;b=b|0;return c[(c[a+276>>2]|0)+(b<<2)>>2]|0}function Wd(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+8>>2]&511](a);i=b;return}function Xd(b,d,e){b=+b;d=d|0;e=e|0;var f=0,h=0,j=0,k=0;f=i;h=fF(140)|0;a:do if(!h){while(1){h=c[5158]|0;c[5158]=h+0;if(!h)break;sc[h&3]();h=fF(140)|0;if(h)break a}k=Ab(4)|0;c[k>>2]=20472;yb(k|0,20520,265)}while(0);g[h>>2]=b;c[h+4>>2]=d;d=h+8|0;j=h+56|0;k=d;do k=k+16|0;while((k|0)!=(j|0));c[h+72>>2]=e;j=h+76|0;k=h+100|0;c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;g[k>>2]=.5;g[h+104>>2]=0.0;g[h+108>>2]=0.0;g[h+112>>2]=.800000011920929;g[h+116>>2]=1.0;a[h+120>>0]=0;g[h+124>>2]=.004999999888241291;g[h+128>>2]=.009999999776482582;g[h+132>>2]=.009999999776482582;g[h+136>>2]=.009999999776482582;ln(d);i=f;return h|0}function Yd(b,d,e,f){b=+b;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0;h=i;j=fF(140)|0;a:do if(!j){while(1){j=c[5158]|0;c[5158]=j+0;if(!j)break;sc[j&3]();j=fF(140)|0;if(j)break a}l=Ab(4)|0;c[l>>2]=20472;yb(l|0,20520,265)}while(0);g[j>>2]=b;c[j+4>>2]=d;d=j+8|0;k=j+56|0;l=d;do l=l+16|0;while((l|0)!=(k|0));c[j+72>>2]=e;l=j+76|0;c[l+0>>2]=c[f+0>>2];c[l+4>>2]=c[f+4>>2];c[l+8>>2]=c[f+8>>2];c[l+12>>2]=c[f+12>>2];g[j+92>>2]=0.0;g[j+96>>2]=0.0;g[j+100>>2]=.5;g[j+104>>2]=0.0;g[j+108>>2]=0.0;g[j+112>>2]=.800000011920929;g[j+116>>2]=1.0;a[j+120>>0]=0;g[j+124>>2]=.004999999888241291;g[j+128>>2]=.009999999776482582;g[j+132>>2]=.009999999776482582;g[j+136>>2]=.009999999776482582;ln(d);i=h;return j|0}function Zd(a){a=a|0;return+(+g[a+92>>2])}function _d(a,b){a=a|0;b=+b;g[a+92>>2]=b;return}function $d(a){a=a|0;return+(+g[a+96>>2])}function ae(a,b){a=a|0;b=+b;g[a+96>>2]=b;return}function be(a){a=a|0;return+(+g[a+100>>2])}function ce(a,b){a=a|0;b=+b;g[a+100>>2]=b;return}function de(a){a=a|0;return+(+g[a+104>>2])}function ee(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function fe(a){a=a|0;return+(+g[a+108>>2])}function ge(a,b){a=a|0;b=+b;g[a+108>>2]=b;return}function he(a){a=a|0;return+(+g[a+112>>2])}function ie(a,b){a=a|0;b=+b;g[a+112>>2]=b;return}function je(a){a=a|0;return+(+g[a+116>>2])}function ke(a,b){a=a|0;b=+b;g[a+116>>2]=b;return}function le(b){b=b|0;return(a[b+120>>0]&1)!=0|0}function me(b,c){b=b|0;c=c|0;a[b+120>>0]=c&1;return}function ne(a){a=a|0;return+(+g[a+124>>2])}function oe(a,b){a=a|0;b=+b;g[a+124>>2]=b;return}function pe(a){a=a|0;return+(+g[a+128>>2])}function qe(a,b){a=a|0;b=+b;g[a+128>>2]=b;return}function re(a){a=a|0;return+(+g[a+132>>2])}function se(a,b){a=a|0;b=+b;g[a+132>>2]=b;return}function te(a){a=a|0;return+(+g[a+136>>2])}function ue(a,b){a=a|0;b=+b;g[a+136>>2]=b;return}function ve(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function we(a){a=a|0;return a+48|0}function xe(a){a=a|0;return a+32|0}function ye(a){a=a|0;return a|0}function ze(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+0>>2]=c[b+0>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];i=d;return}function Ae(a){a=a|0;return a+16|0}function Be(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+16>>2]=c[b+0>>2];c[a+20>>2]=c[b+4>>2];c[a+24>>2]=c[b+8>>2];c[a+28>>2]=c[b+12>>2];i=d;return}function Ce(a){a=a|0;return a+32|0}function De(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+32>>2]=c[b+0>>2];c[a+36>>2]=c[b+4>>2];c[a+40>>2]=c[b+8>>2];c[a+44>>2]=c[b+12>>2];i=d;return}function Ee(a){a=a|0;return a+48|0}function Fe(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+48>>2]=c[b+0>>2];c[a+52>>2]=c[b+4>>2];c[a+56>>2]=c[b+8>>2];c[a+60>>2]=c[b+12>>2];i=d;return}function Ge(a){a=a|0;return a+64|0}function He(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+64>>2]=c[b+0>>2];c[a+68>>2]=c[b+4>>2];c[a+72>>2]=c[b+8>>2];c[a+76>>2]=c[b+12>>2];i=d;return}function Ie(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function Je(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;i=i+96|0;c[5004]=(c[5004]|0)+1;h=fF(1331)|0;if(!h)k=0;else{c[(h+19&-16)+ -4>>2]=h;k=h+19&-16}if((a[5024]|0)==0?(Ya(5024)|0)!=0:0){c[f+80>>2]=0;c[f+84>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;lr(4408,0.0,0,0,f+80|0);bb(5024)}c[f+64>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;c[f+76>>2]=0;mr(4408,0.0,f+64|0);c[k+4>>2]=6;c[k+8>>2]=-1;c[k+12>>2]=-1;g[k+16>>2]=3.4028234663852886e+38;a[k+20>>0]=1;a[k+21>>0]=0;c[k+24>>2]=-1;j=k+28|0;c[j>>2]=4408;h=k+32|0;c[h>>2]=b;g[k+36>>2]=0.0;g[k+40>>2]=.30000001192092896;c[k+44>>2]=0;c[k>>2]=2368;l=k+112|0;c[l+0>>2]=c[d+0>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];o=k+128|0;c[o+0>>2]=c[d+16>>2];c[o+4>>2]=c[d+20>>2];c[o+8>>2]=c[d+24>>2];c[o+12>>2]=c[d+28>>2];o=k+144|0;c[o+0>>2]=c[d+32>>2];c[o+4>>2]=c[d+36>>2];c[o+8>>2]=c[d+40>>2];c[o+12>>2]=c[d+44>>2];o=k+160|0;c[o+0>>2]=c[d+48>>2];c[o+4>>2]=c[d+52>>2];c[o+8>>2]=c[d+56>>2];c[o+12>>2]=c[d+60>>2];o=k+48|0;p=k+740|0;m=k+756|0;d=k+680|0;n=d+48|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(n|0));c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;g[m>>2]=.20000000298023224;g[k+760>>2]=.20000000298023224;g[k+764>>2]=.20000000298023224;n=k+768|0;p=k+728|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;g[p>>2]=.699999988079071;g[k+732>>2]=1.0;g[k+736>>2]=.5;a[k+788>>0]=0;g[k+792>>2]=0.0;g[k+808>>2]=0.0;a[k+789>>0]=0;g[k+796>>2]=0.0;g[k+812>>2]=0.0;a[k+790>>0]=0;g[k+800>>2]=0.0;g[k+816>>2]=0.0;g[k+928>>2]=0.0;g[k+876>>2]=0.0;g[k+880>>2]=.10000000149011612;g[k+884>>2]=300.0;g[k+868>>2]=1.0;g[k+872>>2]=-1.0;g[k+896>>2]=0.0;g[k+900>>2]=.20000000298023224;g[k+904>>2]=0.0;g[k+908>>2]=0.0;g[k+888>>2]=1.0;g[k+892>>2]=.5;c[k+924>>2]=0;g[k+916>>2]=0.0;a[k+912>>0]=0;g[k+992>>2]=0.0;g[k+940>>2]=0.0;g[k+944>>2]=.10000000149011612;g[k+948>>2]=300.0;g[k+932>>2]=1.0;g[k+936>>2]=-1.0;g[k+960>>2]=0.0;g[k+964>>2]=.20000000298023224;g[k+968>>2]=0.0;g[k+972>>2]=0.0;g[k+952>>2]=1.0;g[k+956>>2]=.5;c[k+988>>2]=0;g[k+980>>2]=0.0;a[k+976>>0]=0;g[k+1056>>2]=0.0;g[k+1004>>2]=0.0;g[k+1008>>2]=.10000000149011612;g[k+1012>>2]=300.0;g[k+996>>2]=1.0;g[k+1e3>>2]=-1.0;g[k+1024>>2]=0.0;g[k+1028>>2]=.20000000298023224;g[k+1032>>2]=0.0;g[k+1036>>2]=0.0;g[k+1016>>2]=1.0;g[k+1020>>2]=.5;c[k+1052>>2]=0;g[k+1044>>2]=0.0;a[k+1040>>0]=0;a[k+1300>>0]=e&1;a[k+1301>>0]=1;c[k+1304>>2]=0;a[k+1308>>0]=0;no(f,b+4|0,l);c[o+0>>2]=c[f+0>>2];c[o+4>>2]=c[f+4>>2];c[o+8>>2]=c[f+8>>2];c[o+12>>2]=c[f+12>>2];p=k+64|0;c[p+0>>2]=c[f+16>>2];c[p+4>>2]=c[f+20>>2];c[p+8>>2]=c[f+24>>2];c[p+12>>2]=c[f+28>>2];p=k+80|0;c[p+0>>2]=c[f+32>>2];c[p+4>>2]=c[f+36>>2];c[p+8>>2]=c[f+40>>2];c[p+12>>2]=c[f+44>>2];p=k+96|0;c[p+0>>2]=c[f+48>>2];c[p+4>>2]=c[f+52>>2];c[p+8>>2]=c[f+56>>2];c[p+12>>2]=c[f+60>>2];Up(k,(c[j>>2]|0)+4|0,(c[h>>2]|0)+4|0);i=f;return k|0}function Ke(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0;j=i;c[5004]=(c[5004]|0)+1;k=fF(1331)|0;if(!k)l=0;else{c[(k+19&-16)+ -4>>2]=k;l=k+19&-16}c[l+4>>2]=6;c[l+8>>2]=-1;c[l+12>>2]=-1;g[l+16>>2]=3.4028234663852886e+38;a[l+20>>0]=1;a[l+21>>0]=0;c[l+24>>2]=-1;k=l+28|0;c[k>>2]=b;b=l+32|0;c[b>>2]=d;g[l+36>>2]=0.0;g[l+40>>2]=.30000001192092896;c[l+44>>2]=0;c[l>>2]=2368;m=l+48|0;c[m+0>>2]=c[e+0>>2];c[m+4>>2]=c[e+4>>2];c[m+8>>2]=c[e+8>>2];c[m+12>>2]=c[e+12>>2];m=l+64|0;c[m+0>>2]=c[e+16>>2];c[m+4>>2]=c[e+20>>2];c[m+8>>2]=c[e+24>>2];c[m+12>>2]=c[e+28>>2];m=l+80|0;c[m+0>>2]=c[e+32>>2];c[m+4>>2]=c[e+36>>2];c[m+8>>2]=c[e+40>>2];c[m+12>>2]=c[e+44>>2];m=l+96|0;c[m+0>>2]=c[e+48>>2];c[m+4>>2]=c[e+52>>2];c[m+8>>2]=c[e+56>>2];c[m+12>>2]=c[e+60>>2];e=l+112|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=l+128|0;c[e+0>>2]=c[f+16>>2];c[e+4>>2]=c[f+20>>2];c[e+8>>2]=c[f+24>>2];c[e+12>>2]=c[f+28>>2];e=l+144|0;c[e+0>>2]=c[f+32>>2];c[e+4>>2]=c[f+36>>2];c[e+8>>2]=c[f+40>>2];c[e+12>>2]=c[f+44>>2];e=l+160|0;c[e+0>>2]=c[f+48>>2];c[e+4>>2]=c[f+52>>2];c[e+8>>2]=c[f+56>>2];c[e+12>>2]=c[f+60>>2];e=l+740|0;f=l+756|0;m=l+680|0;d=m+48|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(d|0));c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;g[f>>2]=.20000000298023224;g[l+760>>2]=.20000000298023224;g[l+764>>2]=.20000000298023224;f=l+768|0;m=l+728|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;g[m>>2]=.699999988079071;g[l+732>>2]=1.0;g[l+736>>2]=.5;a[l+788>>0]=0;g[l+792>>2]=0.0;g[l+808>>2]=0.0;a[l+789>>0]=0;g[l+796>>2]=0.0;g[l+812>>2]=0.0;a[l+790>>0]=0;g[l+800>>2]=0.0;g[l+816>>2]=0.0;g[l+928>>2]=0.0;g[l+876>>2]=0.0;g[l+880>>2]=.10000000149011612;g[l+884>>2]=300.0;g[l+868>>2]=1.0;g[l+872>>2]=-1.0;g[l+896>>2]=0.0;g[l+900>>2]=.20000000298023224;g[l+904>>2]=0.0;g[l+908>>2]=0.0;g[l+888>>2]=1.0;g[l+892>>2]=.5;c[l+924>>2]=0;g[l+916>>2]=0.0;a[l+912>>0]=0;g[l+992>>2]=0.0;g[l+940>>2]=0.0;g[l+944>>2]=.10000000149011612;g[l+948>>2]=300.0;g[l+932>>2]=1.0;g[l+936>>2]=-1.0;g[l+960>>2]=0.0;g[l+964>>2]=.20000000298023224;g[l+968>>2]=0.0;g[l+972>>2]=0.0;g[l+952>>2]=1.0;g[l+956>>2]=.5;c[l+988>>2]=0;g[l+980>>2]=0.0;a[l+976>>0]=0;g[l+1056>>2]=0.0;g[l+1004>>2]=0.0;g[l+1008>>2]=.10000000149011612;g[l+1012>>2]=300.0;g[l+996>>2]=1.0;g[l+1e3>>2]=-1.0;g[l+1024>>2]=0.0;g[l+1028>>2]=.20000000298023224;g[l+1032>>2]=0.0;g[l+1036>>2]=0.0;g[l+1016>>2]=1.0;g[l+1020>>2]=.5;c[l+1052>>2]=0;g[l+1044>>2]=0.0;a[l+1040>>0]=0;a[l+1300>>0]=h&1;a[l+1301>>0]=1;c[l+1304>>2]=0;a[l+1308>>0]=0;Up(l,(c[k>>2]|0)+4|0,(c[b>>2]|0)+4|0);i=j;return l|0}function Le(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Me(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Ne(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Oe(a){a=a|0;return c[a+192>>2]|0}function Pe(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Qe(a,b){a=a|0;b=b|0;var d=0;d=i;if(((c[a+216>>2]|0)+ -4|0)>>>0<2){i=d;return}c[a+216>>2]=b;i=d;return}function Re(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Se(a){a=a|0;var b=0;b=i;if(c[a+204>>2]&3){i=b;return}if(((c[a+216>>2]|0)+ -4|0)>>>0>=2)c[a+216>>2]=1;g[a+220>>2]=0.0;i=b;return}function Te(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b?(c[a+204>>2]&3|0)!=0:0){i=d;return}if(((c[a+216>>2]|0)+ -4|0)>>>0>=2)c[a+216>>2]=1;g[a+220>>2]=0.0;i=d;return}function Ue(a){a=a|0;a=c[a+216>>2]|0;return((a|0)==2?0:(a|0)!=5)|0}function Ve(a){a=a|0;return(c[a+204>>2]&2|0)!=0|0}function We(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Xe(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Ye(a){a=a|0;return a+4|0}function Ze(a){a=a|0;return c[a+204>>2]|0}function _e(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function $e(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];i=d;return}function af(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function bf(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function cf(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function df(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+8>>2]&511](a);i=b;return}function ef(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0;f=i;c[5004]=(c[5004]|0)+1;h=fF(343)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}a[h+20>>0]=1;c[h+16>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+24>>2]=b;g[h+28>>2]=0.0;c[h+32>>2]=0;c[h+36>>2]=1;g[h+40>>2]=1.0;a[h+44>>0]=1;c[h+48>>2]=0;a[h+52>>0]=0;a[h+53>>0]=1;a[h+54>>0]=1;g[h+56>>2]=.03999999910593033;a[h+60>>0]=0;g[h+64>>2]=0.0;c[h+68>>2]=d;c[h+72>>2]=0;a[h+76>>0]=1;c[h+80>>2]=0;c[h+84>>2]=0;c[h+88>>2]=0;g[h+92>>2]=.6000000238418579;g[h+96>>2]=1.0;g[h+100>>2]=.30000001192092896;g[h+104>>2]=.01666666753590107;g[h+108>>2]=0.0;g[h+116>>2]=20.0;c[h+112>>2]=10;g[h+124>>2]=.20000000298023224;g[h+128>>2]=.800000011920929;g[h+132>>2]=0.0;g[h+120>>2]=1.0;c[h+136>>2]=1;g[h+140>>2]=-.03999999910593033;g[h+144>>2]=.10000000149011612;g[h+148>>2]=0.0;g[h+152>>2]=.8500000238418579;c[h+156>>2]=260;c[h+160>>2]=2;c[h+164>>2]=128;g[h+168>>2]=100.0;g[h+172>>2]=1.0000000150474662e+30;c[h>>2]=1392;a[h+192>>0]=1;c[h+188>>2]=0;c[h+180>>2]=0;c[h+184>>2]=0;d=h+196|0;c[d>>2]=0;j=h+200|0;c[j>>2]=e;a[h+224>>0]=1;c[h+220>>2]=0;c[h+212>>2]=0;c[h+216>>2]=0;a[h+244>>0]=1;c[h+240>>2]=0;c[h+232>>2]=0;c[h+236>>2]=0;g[h+248>>2]=0.0;g[h+252>>2]=-10.0;m=h+256|0;a[h+274>>0]=0;a[h+275>>0]=0;l=h+292|0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;a[l>>0]=1;c[h+288>>2]=0;c[h+280>>2]=0;c[h+284>>2]=0;c[h+296>>2]=0;a[h+300>>0]=1;a[h+320>>0]=1;c[h+316>>2]=0;c[h+308>>2]=0;c[h+312>>2]=0;if(!e){c[5004]=(c[5004]|0)+1;e=fF(215)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}c[e>>2]=4024;a[e+20>>0]=1;c[e+16>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;a[e+40>>0]=1;c[e+36>>2]=0;c[e+28>>2]=0;c[e+32>>2]=0;a[e+60>>0]=1;c[e+56>>2]=0;c[e+48>>2]=0;c[e+52>>2]=0;a[e+80>>0]=1;c[e+76>>2]=0;c[e+68>>2]=0;c[e+72>>2]=0;a[e+100>>0]=1;c[e+96>>2]=0;c[e+88>>2]=0;c[e+92>>2]=0;a[e+120>>0]=1;c[e+116>>2]=0;c[e+108>>2]=0;c[e+112>>2]=0;a[e+140>>0]=1;c[e+136>>2]=0;c[e+128>>2]=0;c[e+132>>2]=0;a[e+160>>0]=1;c[e+156>>2]=0;c[e+148>>2]=0;c[e+152>>2]=0;a[e+180>>0]=1;c[e+176>>2]=0;c[e+168>>2]=0;c[e+172>>2]=0;c[e+192>>2]=0;c[j>>2]=e;a[h+273>>0]=1}else a[h+273>>0]=0;c[5004]=(c[5004]|0)+1;e=fF(87)|0;if((e|0)!=0?(k=e+19&-16,c[k+ -4>>2]=e,(e+19&-16|0)!=0):0){c[(e+19&-16)>>2]=16568;a[k+20>>0]=1;c[k+16>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;a[k+40>>0]=1;c[k+36>>2]=0;c[k+28>>2]=0;c[k+32>>2]=0;a[k+60>>0]=1;c[k+56>>2]=0;c[k+48>>2]=0;c[k+52>>2]=0;a[k+64>>0]=1;k=e+19&-16}else k=0;c[h+204>>2]=k;a[h+272>>0]=1;c[5004]=(c[5004]|0)+1;k=fF(107)|0;if(!k){m=0;c[d>>2]=m;i=f;return h|0}e=k+19&-16;c[e+ -4>>2]=k;if(!(k+19&-16)){m=0;c[d>>2]=m;i=f;return h|0}m=c[j>>2]|0;c[(k+19&-16)>>2]=2240;c[e+4>>2]=0;c[e+8>>2]=m;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=b;a[e+44>>0]=1;c[e+40>>2]=0;c[e+32>>2]=0;c[e+36>>2]=0;a[e+64>>0]=1;c[e+60>>2]=0;c[e+52>>2]=0;c[e+56>>2]=0;a[e+84>>0]=1;c[e+80>>2]=0;c[e+72>>2]=0;c[e+76>>2]=0;m=k+19&-16;c[d>>2]=m;i=f;return h|0}function ff(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+72>>2]&127](a,b);i=d;return}function gf(b){b=b|0;var d=0;d=i;i=i+16|0;if((a[24]|0)==0?(Ya(24)|0)!=0:0)bb(24);Nb[c[(c[b>>2]|0)+76>>2]&127](d,b);c[2]=c[d+0>>2];c[3]=c[d+4>>2];c[4]=c[d+8>>2];c[5]=c[d+12>>2];i=d;return 8}function hf(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+84>>2]&127](a,b);i=d;return}function jf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+88>>2]&127](a,b,d,e);i=f;return}function kf(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+92>>2]&127](a,b);i=d;return}function lf(a,b){a=a|0;b=b|0;var d=0;d=i;rc[c[(c[a>>2]|0)+56>>2]&127](a,b,0);i=d;return}function mf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;rc[c[(c[a>>2]|0)+56>>2]&127](a,b,d);i=e;return}function nf(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+60>>2]&127](a,b);i=d;return}function of(a,b){a=a|0;b=+b;var d=0;d=i;a=uc[c[(c[a>>2]|0)+52>>2]&1](a,b,1,.01666666753590107)|0;i=d;return a|0}function pf(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;a=uc[c[(c[a>>2]|0)+52>>2]&1](a,b,d,.01666666753590107)|0;i=e;return a|0}function qf(a,b,d,e){a=a|0;b=+b;d=d|0;e=+e;var f=0;f=i;a=uc[c[(c[a>>2]|0)+52>>2]&1](a,b,d,e)|0;i=f;return a|0}function rf(a){a=a|0;return c[a+24>>2]|0}function sf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);i=f;return}function tf(a){a=a|0;var b=0;b=i;a=c[a+68>>2]|0;a=Pb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function uf(a){a=a|0;return a+28|0}function vf(a,b){a=a|0;b=b|0;var d=0;d=i;vc[c[(c[a>>2]|0)+36>>2]&127](a,b,2,-3);i=d;return}function wf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;vc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-3);i=e;return}function xf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);i=f;return}function yf(a){a=a|0;return c[a+68>>2]|0}function zf(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;var g=0;g=i;Ou(a,b,c,d,e,f);i=g;return}function Af(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;Qu(a,b,c,d);i=e;return}function Bf(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+64>>2]&127](a,b);i=d;return}function Cf(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Df(b){b=b|0;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(115)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+52>>2]=0;g[e+56>>2]=1.0;g[e+60>>2]=1.0;g[e+64>>2]=1.0;g[e+68>>2]=0.0;g[e+72>>2]=-1.0;g[e+76>>2]=-1.0;g[e+80>>2]=-1.0;g[e+84>>2]=0.0;a[e+88>>0]=0;c[e>>2]=10656;c[e+92>>2]=b;c[e+4>>2]=3;EA(e);i=d;return e|0}function Ef(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;c[5004]=(c[5004]|0)+1;f=fF(115)|0;if(!f)f=0;else{c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}c[f+8>>2]=0;g[f+12>>2]=1.0;g[f+16>>2]=1.0;g[f+20>>2]=1.0;g[f+24>>2]=0.0;g[f+44>>2]=.03999999910593033;c[f+52>>2]=0;g[f+56>>2]=1.0;g[f+60>>2]=1.0;g[f+64>>2]=1.0;g[f+68>>2]=0.0;g[f+72>>2]=-1.0;g[f+76>>2]=-1.0;g[f+80>>2]=-1.0;g[f+84>>2]=0.0;a[f+88>>0]=0;c[f>>2]=10656;c[f+92>>2]=b;c[f+4>>2]=3;if(!d){i=e;return f|0}EA(f);i=e;return f|0}function Ff(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Gf(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Hf(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function If(a){a=a|0;return+g[a+4>>2]<1.0|0}function Jf(a){a=a|0;return b[a+8>>1]|0}function Kf(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function Lf(a){a=a|0;return b[a+10>>1]|0}function Mf(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function Nf(a){a=a|0;return+(+g[a+4>>2])}function Of(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Pf(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Qf(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;e=i;c[5004]=(c[5004]|0)+1;f=fF(379)|0;if(!f)f=0;else{c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}Yr(f,3,b);c[f>>2]=2984;n=f+300|0;c[n+0>>2]=c[d+0>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];c[n+12>>2]=c[d+12>>2];m=+g[d>>2];l=+g[d+4>>2];k=+g[d+8>>2];j=m*+g[b+20>>2]+l*+g[b+24>>2]+k*+g[b+28>>2]+ +g[b+56>>2];h=m*+g[b+36>>2]+l*+g[b+40>>2]+k*+g[b+44>>2]+ +g[b+60>>2];g[f+316>>2]=m*+g[b+4>>2]+l*+g[b+8>>2]+k*+g[b+12>>2]+ +g[b+52>>2];g[f+320>>2]=j;g[f+324>>2]=h;g[f+328>>2]=0.0;c[f+332>>2]=0;a[f+344>>0]=0;g[f+348>>2]=.30000001192092896;g[f+352>>2]=1.0;g[f+356>>2]=0.0;i=e;return f|0}function Rf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;h=i;c[5004]=(c[5004]|0)+1;j=fF(379)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}c[j+4>>2]=3;c[j+8>>2]=-1;c[j+12>>2]=-1;g[j+16>>2]=3.4028234663852886e+38;a[j+20>>0]=1;a[j+21>>0]=0;c[j+24>>2]=-1;c[j+28>>2]=b;c[j+32>>2]=d;g[j+36>>2]=0.0;g[j+40>>2]=.30000001192092896;c[j+44>>2]=0;c[j>>2]=2984;d=j+300|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=j+316|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];c[j+332>>2]=0;a[j+344>>0]=0;g[j+348>>2]=.30000001192092896;g[j+352>>2]=1.0;g[j+356>>2]=0.0;i=h;return j|0}function Sf(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+300>>2]=c[b+0>>2];c[a+304>>2]=c[b+4>>2];c[a+308>>2]=c[b+8>>2];c[a+312>>2]=c[b+12>>2];i=d;return}function Tf(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+316>>2]=c[b+0>>2];c[a+320>>2]=c[b+4>>2];c[a+324>>2]=c[b+8>>2];c[a+328>>2]=c[b+12>>2];i=d;return}function Uf(a){a=a|0;return a+300|0}function Vf(a){a=a|0;return a+316|0}function Wf(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Xf(a){a=a|0;return a+348|0}function Yf(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+348>>2]=c[b+0>>2];c[a+352>>2]=c[b+4>>2];c[a+356>>2]=c[b+8>>2];i=d;return}function Zf(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function _f(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+8>>2]&127](a,b);i=d;return}function $f(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function ag(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function bg(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+96|0;c[5004]=(c[5004]|0)+1;h=fF(1147)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}if((a[5024]|0)==0?(Ya(5024)|0)!=0:0){c[f+80>>2]=0;c[f+84>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;lr(4408,0.0,0,0,f+80|0);bb(5024)}c[f+64>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;c[f+76>>2]=0;mr(4408,0.0,f+64|0);c[h+4>>2]=7;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3.4028234663852886e+38;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;k=h+28|0;c[k>>2]=4408;j=h+32|0;c[j>>2]=b;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=4264;a[h+48>>0]=0;l=h+116|0;c[l+0>>2]=c[d+0>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];m=h+132|0;c[m+0>>2]=c[d+16>>2];c[m+4>>2]=c[d+20>>2];c[m+8>>2]=c[d+24>>2];c[m+12>>2]=c[d+28>>2];m=h+148|0;c[m+0>>2]=c[d+32>>2];c[m+4>>2]=c[d+36>>2];c[m+8>>2]=c[d+40>>2];c[m+12>>2]=c[d+44>>2];m=h+164|0;c[m+0>>2]=c[d+48>>2];c[m+4>>2]=c[d+52>>2];c[m+8>>2]=c[d+56>>2];c[m+12>>2]=c[d+60>>2];a[h+180>>0]=e&1;d=h+52|0;no(f,b+4|0,l);c[d+0>>2]=c[f+0>>2];c[d+4>>2]=c[f+4>>2];c[d+8>>2]=c[f+8>>2];c[d+12>>2]=c[f+12>>2];d=h+68|0;c[d+0>>2]=c[f+16>>2];c[d+4>>2]=c[f+20>>2];c[d+8>>2]=c[f+24>>2];c[d+12>>2]=c[f+28>>2];d=h+84|0;c[d+0>>2]=c[f+32>>2];c[d+4>>2]=c[f+36>>2];c[d+8>>2]=c[f+40>>2];c[d+12>>2]=c[f+44>>2];d=h+100|0;c[d+0>>2]=c[f+48>>2];c[d+4>>2]=c[f+52>>2];c[d+8>>2]=c[f+56>>2];c[d+12>>2]=c[f+60>>2];g[h+184>>2]=1.0;g[h+188>>2]=-1.0;g[h+192>>2]=0.0;g[h+196>>2]=0.0;g[h+200>>2]=1.0;g[h+204>>2]=.699999988079071;g[h+208>>2]=0.0;g[h+212>>2]=0.0;g[h+216>>2]=1.0;g[h+220>>2]=.699999988079071;g[h+224>>2]=0.0;g[h+228>>2]=0.0;g[h+264>>2]=1.0;g[h+268>>2]=.699999988079071;g[h+272>>2]=1.0;g[h+276>>2]=0.0;g[h+280>>2]=1.0;g[h+284>>2]=.699999988079071;g[h+288>>2]=1.0;g[h+292>>2]=0.0;g[h+232>>2]=1.0;g[h+236>>2]=.699999988079071;g[h+240>>2]=1.0;g[h+244>>2]=0.0;g[h+248>>2]=1.0;g[h+252>>2]=.699999988079071;g[h+256>>2]=1.0;g[h+260>>2]=0.0;a[h+1096>>0]=0;d=h+1100|0;g[h+1116>>2]=0.0;g[h+1120>>2]=0.0;g[h+1124>>2]=0.0;c[h+300>>2]=0;e=h+49|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;a[d+12>>0]=0;a[e>>0]=1;Pr(h,(c[k>>2]|0)+4|0,(c[j>>2]|0)+4|0);i=f;return h|0}function cg(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0;j=i;c[5004]=(c[5004]|0)+1;k=fF(1147)|0;if(!k)k=0;else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16}c[k+4>>2]=7;c[k+8>>2]=-1;c[k+12>>2]=-1;g[k+16>>2]=3.4028234663852886e+38;a[k+20>>0]=1;a[k+21>>0]=0;c[k+24>>2]=-1;l=k+28|0;c[l>>2]=b;b=k+32|0;c[b>>2]=d;g[k+36>>2]=0.0;g[k+40>>2]=.30000001192092896;c[k+44>>2]=0;c[k>>2]=4264;a[k+48>>0]=0;d=k+52|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=k+68|0;c[d+0>>2]=c[e+16>>2];c[d+4>>2]=c[e+20>>2];c[d+8>>2]=c[e+24>>2];c[d+12>>2]=c[e+28>>2];d=k+84|0;c[d+0>>2]=c[e+32>>2];c[d+4>>2]=c[e+36>>2];c[d+8>>2]=c[e+40>>2];c[d+12>>2]=c[e+44>>2];d=k+100|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];e=k+116|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=k+132|0;c[e+0>>2]=c[f+16>>2];c[e+4>>2]=c[f+20>>2];c[e+8>>2]=c[f+24>>2];c[e+12>>2]=c[f+28>>2];e=k+148|0;c[e+0>>2]=c[f+32>>2];c[e+4>>2]=c[f+36>>2];c[e+8>>2]=c[f+40>>2];c[e+12>>2]=c[f+44>>2];e=k+164|0;c[e+0>>2]=c[f+48>>2];c[e+4>>2]=c[f+52>>2];c[e+8>>2]=c[f+56>>2];c[e+12>>2]=c[f+60>>2];a[k+180>>0]=h&1;g[k+184>>2]=1.0;g[k+188>>2]=-1.0;g[k+192>>2]=0.0;g[k+196>>2]=0.0;g[k+200>>2]=1.0;g[k+204>>2]=.699999988079071;g[k+208>>2]=0.0;g[k+212>>2]=0.0;g[k+216>>2]=1.0;g[k+220>>2]=.699999988079071;g[k+224>>2]=0.0;g[k+228>>2]=0.0;g[k+264>>2]=1.0;g[k+268>>2]=.699999988079071;g[k+272>>2]=1.0;g[k+276>>2]=0.0;g[k+280>>2]=1.0;g[k+284>>2]=.699999988079071;g[k+288>>2]=1.0;g[k+292>>2]=0.0;g[k+232>>2]=1.0;g[k+236>>2]=.699999988079071;g[k+240>>2]=1.0;g[k+244>>2]=0.0;g[k+248>>2]=1.0;g[k+252>>2]=.699999988079071;g[k+256>>2]=1.0;g[k+260>>2]=0.0;a[k+1096>>0]=0;f=k+1100|0;g[k+1116>>2]=0.0;g[k+1120>>2]=0.0;g[k+1124>>2]=0.0;c[k+300>>2]=0;h=k+49|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;a[f+12>>0]=0;a[h>>0]=1;Pr(k,(c[l>>2]|0)+4|0,(c[b>>2]|0)+4|0);i=j;return k|0}function dg(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function eg(a,b){a=a|0;b=+b;g[a+188>>2]=b;return}function fg(a,b){a=a|0;b=+b;var c=0;c=i;b=+ab(+b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+192>>2]=b;i=c;return}function gg(a,b){a=a|0;b=+b;var c=0;c=i;b=+ab(+b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+196>>2]=b;i=c;return}function hg(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function ig(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function jg(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0;e=i;c[5004]=(c[5004]|0)+1;f=fF(627)|0;if(!f)f=0;else{c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}Yr(f,5,b);c[f>>2]=1264;k=f+300|0;c[k+0>>2]=c[d+0>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];j=f+316|0;c[j+0>>2]=c[d+16>>2];c[j+4>>2]=c[d+20>>2];c[j+8>>2]=c[d+24>>2];c[j+12>>2]=c[d+28>>2];h=f+332|0;c[h+0>>2]=c[d+32>>2];c[h+4>>2]=c[d+36>>2];c[h+8>>2]=c[d+40>>2];c[h+12>>2]=c[d+44>>2];b=f+348|0;c[b+0>>2]=c[d+48>>2];c[b+4>>2]=c[d+52>>2];c[b+8>>2]=c[d+56>>2];c[b+12>>2]=c[d+60>>2];b=f+364|0;d=f+524|0;a[f+527>>0]=0;c[b+0>>2]=c[k+0>>2];c[b+4>>2]=c[k+4>>2];c[b+8>>2]=c[k+8>>2];c[b+12>>2]=c[k+12>>2];b=f+380|0;c[b+0>>2]=c[j+0>>2];c[b+4>>2]=c[j+4>>2];c[b+8>>2]=c[j+8>>2];c[b+12>>2]=c[j+12>>2];b=f+396|0;c[b+0>>2]=c[h+0>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];b=f+412|0;a[d>>0]=0;a[f+525>>0]=0;a[f+526>>0]=0;a[f+552>>0]=0;d=f+572|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[d>>2]=-1.0;g[f+444>>2]=999999984306749400.0;g[f+448>>2]=999999984306749400.0;g[f+452>>2]=999999984306749400.0;g[f+428>>2]=1.0;g[f+432>>2]=.30000001192092896;g[f+436>>2]=1.0;g[f+440>>2]=.009999999776482582;g[f+456>>2]=.05000000074505806;c[f+592>>2]=0;g[f+596>>2]=0.0;g[f+600>>2]=.699999988079071;g[f+604>>2]=0.0;i=e;return f|0}function kg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;h=i;c[5004]=(c[5004]|0)+1;j=fF(627)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}c[j+4>>2]=5;c[j+8>>2]=-1;c[j+12>>2]=-1;g[j+16>>2]=3.4028234663852886e+38;a[j+20>>0]=1;a[j+21>>0]=0;c[j+24>>2]=-1;c[j+28>>2]=b;c[j+32>>2]=d;g[j+36>>2]=0.0;g[j+40>>2]=.30000001192092896;c[j+44>>2]=0;c[j>>2]=1264;d=j+300|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=j+316|0;c[d+0>>2]=c[e+16>>2];c[d+4>>2]=c[e+20>>2];c[d+8>>2]=c[e+24>>2];c[d+12>>2]=c[e+28>>2];d=j+332|0;c[d+0>>2]=c[e+32>>2];c[d+4>>2]=c[e+36>>2];c[d+8>>2]=c[e+40>>2];c[d+12>>2]=c[e+44>>2];d=j+348|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];e=j+364|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=j+380|0;c[e+0>>2]=c[f+16>>2];c[e+4>>2]=c[f+20>>2];c[e+8>>2]=c[f+24>>2];c[e+12>>2]=c[f+28>>2];e=j+396|0;c[e+0>>2]=c[f+32>>2];c[e+4>>2]=c[f+36>>2];c[e+8>>2]=c[f+40>>2];c[e+12>>2]=c[f+44>>2];e=j+412|0;c[e+0>>2]=c[f+48>>2];c[e+4>>2]=c[f+52>>2];c[e+8>>2]=c[f+56>>2];c[e+12>>2]=c[f+60>>2];f=j+524|0;a[j+552>>0]=0;a[f>>0]=0;a[f+1>>0]=0;a[f+2>>0]=0;a[f+3>>0]=0;g[j+572>>2]=-1.0;g[j+444>>2]=999999984306749400.0;g[j+448>>2]=999999984306749400.0;g[j+452>>2]=999999984306749400.0;g[j+428>>2]=1.0;g[j+432>>2]=.30000001192092896;g[j+436>>2]=1.0;g[j+440>>2]=.009999999776482582;g[j+456>>2]=.05000000074505806;c[j+592>>2]=0;g[j+596>>2]=0.0;g[j+600>>2]=.699999988079071;g[j+604>>2]=0.0;i=h;return j|0}function lg(a,b,c){a=a|0;b=b|0;c=+c;var d=0;d=i;if((b|0)==4)g[a+448>>2]=c;else if((b|0)==3)g[a+452>>2]=c;else if((b|0)==5)g[a+444>>2]=c;i=d;return}function mg(b,c){b=b|0;c=c|0;a[b+524>>0]=c&1;return}function ng(a,b){a=a|0;b=+b;g[a+440>>2]=b;return}function og(b,c){b=b|0;c=c|0;a[b+552>>0]=c&1;return}function pg(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=0;return}function qg(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=1;return}function rg(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;c=i;i=i+48|0;Hc(a+364|0,c+16|0);h=-+g[c+16>>2];e=-+g[c+20>>2];m=-+g[c+24>>2];l=+g[c+28>>2];f=+g[b>>2];n=+g[b+12>>2];k=+g[b+8>>2];j=+g[b+4>>2];Hc(a+300|0,c);p=+g[c>>2];q=+g[c+12>>2];d=+g[c+8>>2];o=+g[c+4>>2];g[c+32>>2]=p*(l*n-f*h-j*e-k*m)+(l*f+n*h+k*e-j*m)*q+(f*m+(n*e+l*j)-k*h)*d-(n*m+l*k+j*h-f*e)*o;g[c+36>>2]=p*(n*m+l*k+j*h-f*e)+(q*(f*m+(n*e+l*j)-k*h)+(l*n-f*h-j*e-k*m)*o)-(l*f+n*h+k*e-j*m)*d;g[c+40>>2]=q*(n*m+l*k+j*h-f*e)+(l*n-f*h-j*e-k*m)*d+(l*f+n*h+k*e-j*m)*o-p*(f*m+(n*e+l*j)-k*h);g[c+44>>2]=(l*n-f*h-j*e-k*m)*q-p*(l*f+n*h+k*e-j*m)-(f*m+(n*e+l*j)-k*h)*o-(n*m+l*k+j*h-f*e)*d;Do(a,c+32|0);i=c;return}function sg(a,b){a=a|0;b=b|0;var c=0;c=i;Do(a,b);i=c;return}function tg(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function ug(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function vg(a,b){a=+a;b=+b;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(95)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e>>2]=9704;g[e+56>>2]=a;g[e+60>>2]=b;c[e+4>>2]=11;c[e+64>>2]=0;c[e+68>>2]=1;c[e+72>>2]=2;g[e+28>>2]=a;g[e+32>>2]=b;g[e+36>>2]=a;g[e+52>>2]=a/+Q(+(a*a+b*b));i=d;return e|0}function wg(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function xg(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function yg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function zg(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Ag(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Bg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Cg(){var a=0,b=0;a=i;i=i+32|0;b=fF(92)|0;a:do if(!b){while(1){b=c[5158]|0;c[5158]=b+0;if(!b)break;sc[b&3]();b=fF(92)|0;if(b)break a}b=Ab(4)|0;c[b>>2]=20472;yb(b|0,20520,265)}while(0);c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=4096;c[a+12>>2]=4096;c[a+16>>2]=0;c[a+20>>2]=1;zy(b,a);i=a;return b|0}function Dg(a){a=a|0;var b=0,d=0;b=i;d=fF(92)|0;a:do if(!d){while(1){d=c[5158]|0;c[5158]=d+0;if(!d)break;sc[d&3]();d=fF(92)|0;if(d)break a}d=Ab(4)|0;c[d>>2]=20472;yb(d|0,20520,265)}while(0);zy(d,a);i=b;return d|0}function Eg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Fg(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0.0,l=0;l=i;k=+Vb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,j);i=l;return+k}function Gg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Hg(a,b){a=+a;b=+b;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(95)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;g[e+56>>2]=a;g[e+60>>2]=b;c[e+4>>2]=11;g[e+52>>2]=a/+Q(+(a*a+b*b));c[e>>2]=9808;c[e+64>>2]=0;c[e+68>>2]=2;c[e+72>>2]=1;g[e+28>>2]=a;g[e+36>>2]=b;g[e+32>>2]=a;i=d;return e|0}function Ig(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Jg(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Kg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Lg(a,b){a=+a;b=+b;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(95)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;g[e+56>>2]=a;g[e+60>>2]=b;c[e+4>>2]=11;g[e+52>>2]=a/+Q(+(a*a+b*b));c[e>>2]=9912;c[e+64>>2]=1;c[e+68>>2]=0;c[e+72>>2]=2;g[e+32>>2]=a;g[e+28>>2]=b;g[e+36>>2]=a;i=d;return e|0}function Mg(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Ng(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Og(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Pg(){var a=0,b=0;a=i;c[5004]=(c[5004]|0)+1;b=fF(191)|0;if(!b)b=0;else{c[(b+19&-16)+ -4>>2]=b;b=b+19&-16}UB(b,1,1);i=a;return b|0}function Qg(a){a=a|0;var b=0,d=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(191)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}UB(d,a,1);i=b;return d|0}function Rg(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(191)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}UB(e,a,b);i=d;return e|0}function Sg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;g=c[a+32>>2]|0;c[g>>2]=(c[g>>2]|0)+1;VB(a,WB(a,b,0)|0);VB(a,WB(a,d,0)|0);VB(a,WB(a,e,0)|0);i=f;return}function Tg(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;h=c[a+32>>2]|0;c[h>>2]=(c[h>>2]|0)+1;VB(a,WB(a,b,f)|0);VB(a,WB(a,d,f)|0);VB(a,WB(a,e,f)|0);i=g;return}function Ug(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Vg(){var b=0,d=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(131)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+52>>2]=0;g[d+56>>2]=1.0;g[d+60>>2]=1.0;g[d+64>>2]=1.0;g[d+68>>2]=0.0;g[d+72>>2]=-1.0;g[d+76>>2]=-1.0;g[d+80>>2]=-1.0;g[d+84>>2]=0.0;a[d+88>>0]=0;c[d>>2]=10376;a[d+108>>0]=1;c[d+104>>2]=0;c[d+100>>2]=0;c[d+4>>2]=4;c[d+96>>2]=0;EA(d);i=b;return d|0}function Wg(a,b){a=a|0;b=b|0;var c=0;c=i;Gw(a,b,1);i=c;return}function Xg(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Gw(a,b,c);i=d;return}function Yg(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Zg(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function _g(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function $g(){var b=0,d=0,e=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(791)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}c[d>>2]=1025;c[d+116>>2]=0;a[d+120>>0]=0;e=d+124|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;c[d+300>>2]=0;a[d+304>>0]=0;e=d+308|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;c[d+484>>2]=0;a[d+488>>0]=0;e=d+492|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;c[d+668>>2]=0;a[d+672>>0]=0;e=d+676|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;c[d+740>>2]=0;c[d+744>>2]=0;c[d+748>>2]=0;c[d+768>>2]=0;i=b;return d|0}function ah(a){a=a|0;return c[a+740>>2]|0}function bh(a){a=a|0;return c[a+744>>2]|0}function ch(a){a=a|0;return c[a+748>>2]|0}function dh(a,b){a=a|0;b=b|0;return a+(b*184|0)+4|0}function eh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function fh(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0,r=0.0;b=i;c[5004]=(c[5004]|0)+1;d=fF(75)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}c[d+8>>2]=0;h=d+12|0;g[h>>2]=1.0;e=d+16|0;g[e>>2]=1.0;f=d+20|0;g[f>>2]=1.0;g[d+24>>2]=0.0;j=d+44|0;g[j>>2]=.03999999910593033;c[d+52>>2]=0;c[d>>2]=5448;c[d+4>>2]=0;l=+g[a>>2];m=+g[a+4>>2];k=+g[a+8>>2];if(l<m)n=l<k?0:2;else n=m<k?1:2;k=+g[a+(n<<2)>>2]*.10000000149011612;if(k<.03999999910593033){r=+Ts(d);p=+$b[c[(c[d>>2]|0)+48>>2]&15](d);m=+$b[c[(c[d>>2]|0)+48>>2]&15](d);q=d+28|0;r=r+ +g[q>>2];o=d+32|0;p=p+ +g[o>>2];n=d+36|0;m=m+ +g[n>>2];g[j>>2]=k;k=+$b[c[(c[d>>2]|0)+48>>2]&15](d);l=+$b[c[(c[d>>2]|0)+48>>2]&15](d);m=m- +$b[c[(c[d>>2]|0)+48>>2]&15](d);g[q>>2]=r-k;g[o>>2]=p-l;g[n>>2]=m;g[d+40>>2]=0.0;j=c[d>>2]|0}else j=5448|0;m=+$b[c[j+48>>2]&15](d);p=+$b[c[(c[d>>2]|0)+48>>2]&15](d);r=+$b[c[(c[d>>2]|0)+48>>2]&15](d);p=+g[a+4>>2]*+g[e>>2]-p;r=+g[a+8>>2]*+g[f>>2]-r;g[d+28>>2]=+g[a>>2]*+g[h>>2]-m;g[d+32>>2]=p;g[d+36>>2]=r;g[d+40>>2]=0.0;i=b;return d|0}function gh(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function hh(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function ih(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function jh(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;f=fF(5260)|0;a:do if(!f){while(1){e=c[5158]|0;c[5158]=e+0;if(!e)break;sc[e&3]();f=fF(5260)|0;if(f)break a}g=Ab(4)|0;c[g>>2]=20472;yb(g|0,20520,265)}while(0);c[f>>2]=6808;c[f+4>>2]=2;a[f+24>>0]=1;c[f+20>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+28>>2]=13504;e=f+5256|0;c[e>>2]=b;c[f+60>>2]=69;c[f+64>>2]=Pb[c[(c[b>>2]|0)+12>>2]&127](b)|0;c[f+68>>2]=Pb[c[(c[b>>2]|0)+8>>2]&127](b)|0;b=0;do{g=0;do{h=c[e>>2]|0;c[f+(b*144|0)+(g<<2)+72>>2]=Yb[c[(c[h>>2]|0)+16>>2]&31](h,b,g)|0;g=g+1|0}while((g|0)<36);b=b+1|0}while((b|0)<36);i=d;return f|0}function kh(a){a=a|0;var b=0;b=i;a=Pb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function lh(a,b){a=a|0;b=b|0;var d=0;d=i;a=gc[c[(c[a>>2]|0)+40>>2]&31](a,b)|0;i=d;return a|0}function mh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function nh(){var a=0,b=0;a=i;b=fF(24)|0;a:do if(!b){while(1){b=c[5158]|0;c[5158]=b+0;if(!b)break;sc[b&3]();b=fF(24)|0;if(b)break a}b=Ab(4)|0;c[b>>2]=20472;yb(b|0,20520,265)}while(0);g[b>>2]=5.880000114440918;g[b+4>>2]=.8299999833106995;g[b+8>>2]=.8799999952316284;g[b+12>>2]=500.0;g[b+16>>2]=10.5;g[b+20>>2]=6.0e3;i=a;return b|0}function oh(a){a=a|0;return+(+g[a>>2])}function ph(a,b){a=a|0;b=+b;g[a>>2]=b;return}function qh(a){a=a|0;return+(+g[a+4>>2])}function rh(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function sh(a){a=a|0;return+(+g[a+8>>2])}function th(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function uh(a){a=a|0;return+(+g[a+12>>2])}function vh(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function wh(a){a=a|0;return+(+g[a+16>>2])}function xh(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function yh(a){a=a|0;return+(+g[a+20>>2])}function zh(a,b){a=a|0;b=+b;g[a+20>>2]=b;return}function Ah(){var a=0,b=0;a=i;c[5004]=(c[5004]|0)+1;b=fF(111)|0;if(!b)b=0;else{c[(b+19&-16)+ -4>>2]=b;b=b+19&-16}Ov(b,1);i=a;return b|0}function Bh(a){a=a|0;var b=0,d=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(111)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}Ov(d,a);i=b;return d|0}function Ch(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0,r=0,s=0;j=i;i=i+128|0;c[b+68>>2]=(c[b+68>>2]|0)+1;c[j+0>>2]=c[d+0>>2];c[j+4>>2]=c[d+4>>2];c[j+8>>2]=c[d+8>>2];c[j+12>>2]=c[d+12>>2];c[j+16>>2]=c[d+16>>2];c[j+20>>2]=c[d+20>>2];c[j+24>>2]=c[d+24>>2];c[j+28>>2]=c[d+28>>2];c[j+32>>2]=c[d+32>>2];c[j+36>>2]=c[d+36>>2];c[j+40>>2]=c[d+40>>2];c[j+44>>2]=c[d+44>>2];c[j+48>>2]=c[d+48>>2];c[j+52>>2]=c[d+52>>2];c[j+56>>2]=c[d+56>>2];c[j+60>>2]=c[d+60>>2];f=c[e+4>>2]|0;h=+$b[c[(c[e>>2]|0)+48>>2]&15](e);vc[c[(c[e>>2]|0)+8>>2]&127](e,d,j+112|0,j+96|0);p=+g[j+112>>2];if(+g[b+32>>2]>p)g[b+32>>2]=p;p=+g[j+96>>2];if(+g[b+48>>2]<p)g[b+48>>2]=p;p=+g[j+116>>2];if(+g[b+36>>2]>p)g[b+36>>2]=p;p=+g[j+100>>2];if(+g[b+52>>2]<p)g[b+52>>2]=p;p=+g[j+120>>2];if(+g[b+40>>2]>p)g[b+40>>2]=p;p=+g[j+104>>2];if(+g[b+56>>2]<p)g[b+56>>2]=p;d=c[b+64>>2]|0;if(!d){d=b+16|0;l=0}else{c[j+64>>2]=c[j+112>>2];c[j+68>>2]=c[j+116>>2];c[j+72>>2]=c[j+120>>2];c[j+76>>2]=c[j+124>>2];c[j+80>>2]=c[j+96>>2];c[j+84>>2]=c[j+100>>2];c[j+88>>2]=c[j+104>>2];c[j+92>>2]=c[j+108>>2];m=c[b+16>>2]|0;l=c[d+4>>2]|0;if(!l){c[5004]=(c[5004]|0)+1;o=fF(63)|0;if((o|0)!=0?(c[(o+19&-16)+ -4>>2]=o,(o+19&-16|0)!=0):0){l=(o+19&-16)+0|0;n=l+44|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(n|0));l=o+19&-16}else l=0}else c[d+4>>2]=0;c[l+32>>2]=0;c[l+36>>2]=m;c[l+40>>2]=0;c[l+0>>2]=c[j+64>>2];c[l+4>>2]=c[j+68>>2];c[l+8>>2]=c[j+72>>2];c[l+12>>2]=c[j+76>>2];c[l+16>>2]=c[j+80>>2];c[l+20>>2]=c[j+84>>2];c[l+24>>2]=c[j+88>>2];c[l+28>>2]=c[j+92>>2];Xx(d,c[d>>2]|0,l);c[d+12>>2]=(c[d+12>>2]|0)+1;d=b+16|0}o=c[d>>2]|0;if((o|0)==(c[b+20>>2]|0)?(k=(o|0)==0?1:o<<1,(o|0)<(k|0)):0){if(!k)m=0;else{c[5004]=(c[5004]|0)+1;m=fF((k*80|3)+16|0)|0;if(!m)m=0;else{c[(m+19&-16)+ -4>>2]=m;m=m+19&-16}o=c[d>>2]|0}if((o|0)>0){n=0;do{q=m+(n*80|0)|0;r=c[b+24>>2]|0;s=r+(n*80|0)|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=m+(n*80|0)+16|0;s=r+(n*80|0)+16|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=m+(n*80|0)+32|0;s=r+(n*80|0)+32|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=m+(n*80|0)+48|0;s=r+(n*80|0)+48|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=m+(n*80|0)+64|0;r=r+(n*80|0)+64|0;c[q+0>>2]=c[r+0>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];n=n+1|0}while((n|0)!=(o|0))}n=c[b+24>>2]|0;if(n){if(a[b+28>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[n+ -4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=m;c[b+20>>2]=k;o=c[d>>2]|0}s=c[b+24>>2]|0;r=s+(o*80|0)|0;c[r+0>>2]=c[j+0>>2];c[r+4>>2]=c[j+4>>2];c[r+8>>2]=c[j+8>>2];c[r+12>>2]=c[j+12>>2];r=s+(o*80|0)+16|0;c[r+0>>2]=c[j+16>>2];c[r+4>>2]=c[j+20>>2];c[r+8>>2]=c[j+24>>2];c[r+12>>2]=c[j+28>>2];r=s+(o*80|0)+32|0;c[r+0>>2]=c[j+32>>2];c[r+4>>2]=c[j+36>>2];c[r+8>>2]=c[j+40>>2];c[r+12>>2]=c[j+44>>2];r=s+(o*80|0)+48|0;c[r+0>>2]=c[j+48>>2];c[r+4>>2]=c[j+52>>2];c[r+8>>2]=c[j+56>>2];c[r+12>>2]=c[j+60>>2];s=s+(o*80|0)+64|0;c[s>>2]=e;c[s+4>>2]=f;g[s+8>>2]=h;c[s+12>>2]=l;c[d>>2]=(c[d>>2]|0)+1;i=j;return}function Dh(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Eh(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Fh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Gh(a,d){a=a|0;d=d|0;var e=0,f=0,h=0;e=i;f=fF(80)|0;a:do if(!f){while(1){f=c[5158]|0;c[5158]=f+0;if(!f)break;sc[f&3]();f=fF(80)|0;if(f)break a}f=Ab(4)|0;c[f>>2]=20472;yb(f|0,20520,265)}while(0);g[f+4>>2]=1.0;b[f+8>>1]=1;b[f+10>>1]=-1;c[f>>2]=688;h=f+12|0;c[h+0>>2]=c[a+0>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];a=f+28|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];c[f+76>>2]=0;i=e;return f|0}function Hh(a){a=a|0;return+g[a+4>>2]<1.0|0}function Ih(a){a=a|0;return a+12|0}function Jh(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+12>>2]=c[b+0>>2];c[a+16>>2]=c[b+4>>2];c[a+20>>2]=c[b+8>>2];c[a+24>>2]=c[b+12>>2];i=d;return}function Kh(a){a=a|0;return a+28|0}function Lh(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+28>>2]=c[b+0>>2];c[a+32>>2]=c[b+4>>2];c[a+36>>2]=c[b+8>>2];c[a+40>>2]=c[b+12>>2];i=d;return}function Mh(a){a=a|0;return a+44|0}function Nh(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+44>>2]=c[b+0>>2];c[a+48>>2]=c[b+4>>2];c[a+52>>2]=c[b+8>>2];c[a+56>>2]=c[b+12>>2];i=d;return}function Oh(a){a=a|0;return a+60|0}function Ph(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+60>>2]=c[b+0>>2];c[a+64>>2]=c[b+4>>2];c[a+68>>2]=c[b+8>>2];c[a+72>>2]=c[b+12>>2];i=d;return}function Qh(a){a=a|0;return b[a+8>>1]|0}function Rh(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function Sh(a){a=a|0;return b[a+10>>1]|0}function Th(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function Uh(a){a=a|0;return+(+g[a+4>>2])}function Vh(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Wh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Xh(){var a=0,b=0;a=i;c[5004]=(c[5004]|0)+1;b=fF(219)|0;if(!b)b=0;else{c[(b+19&-16)+ -4>>2]=b;b=b+19&-16}Zh();Zh();Yh(b,464,464);i=a;return b|0}function Yh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;c[a>>2]=600;f=a+4|0;do f=f+16|0;while((f|0)!=(a+52|0));c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];f=a+68|0;do f=f+16|0;while((f|0)!=(a+116|0));c[a+68>>2]=c[d+0>>2];c[a+72>>2]=c[d+4>>2];c[a+76>>2]=c[d+8>>2];c[a+80>>2]=c[d+12>>2];c[a+84>>2]=c[d+16>>2];c[a+88>>2]=c[d+20>>2];c[a+92>>2]=c[d+24>>2];c[a+96>>2]=c[d+28>>2];c[a+100>>2]=c[d+32>>2];c[a+104>>2]=c[d+36>>2];c[a+108>>2]=c[d+40>>2];c[a+112>>2]=c[d+44>>2];c[a+116>>2]=c[d+48>>2];c[a+120>>2]=c[d+52>>2];c[a+124>>2]=c[d+56>>2];c[a+128>>2]=c[d+60>>2];d=a+132|0;do d=d+16|0;while((d|0)!=(a+180|0));c[a+132>>2]=c[b+0>>2];c[a+136>>2]=c[b+4>>2];c[a+140>>2]=c[b+8>>2];c[a+144>>2]=c[b+12>>2];c[a+148>>2]=c[b+16>>2];c[a+152>>2]=c[b+20>>2];c[a+156>>2]=c[b+24>>2];c[a+160>>2]=c[b+28>>2];c[a+164>>2]=c[b+32>>2];c[a+168>>2]=c[b+36>>2];c[a+172>>2]=c[b+40>>2];c[a+176>>2]=c[b+44>>2];c[a+180>>2]=c[b+48>>2];c[a+184>>2]=c[b+52>>2];c[a+188>>2]=c[b+56>>2];c[a+192>>2]=c[b+60>>2];c[a+196>>2]=0;i=e;return}function Zh(){var b=0,d=0;b=i;i=i+48|0;if(a[528]|0){i=b;return}if(!(Ya(528)|0)){i=b;return}if((a[584]|0)==0?(Ya(584)|0)!=0:0){g[b+32>>2]=1.0;g[b+28>>2]=0.0;g[b+24>>2]=0.0;g[b+20>>2]=0.0;g[b+16>>2]=1.0;g[b+12>>2]=0.0;g[b+8>>2]=0.0;g[b+4>>2]=0.0;g[b>>2]=1.0;io(536,b+32|0,b+28|0,b+24|0,b+20|0,b+16|0,b+12|0,b+8|0,b+4|0,b);bb(584);d=464}else d=464;do d=d+16|0;while((d|0)!=512);c[116]=c[134];c[117]=c[135];c[118]=c[136];c[119]=c[137];c[120]=c[138];c[121]=c[139];c[122]=c[140];c[123]=c[141];c[124]=c[142];c[125]=c[143];c[126]=c[144];c[127]=c[145];c[128]=0;c[129]=0;c[130]=0;c[131]=0;bb(528);i=b;return}function _h(a){a=a|0;var b=0,d=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(219)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}Zh();Yh(d,a,464);i=b;return d|0}function $h(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(219)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}Yh(e,a,b);i=d;return e|0}function ai(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+8>>2]&127](a,b);i=d;return}function bi(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function ci(a){a=a|0;return a+4|0}function di(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];i=d;return}function ei(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function fi(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function gi(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function hi(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function ii(a){a=a|0;var b=0;b=i;a=Pb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function ji(a,b){a=a|0;b=b|0;var d=0;d=i;a=gc[c[(c[a>>2]|0)+40>>2]&31](a,b)|0;i=d;return a|0}function ki(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function li(a,d){a=a|0;d=d|0;var e=0,f=0,h=0;e=i;f=fF(84)|0;a:do if(!f){while(1){f=c[5158]|0;c[5158]=f+0;if(!f)break;sc[f&3]();f=fF(84)|0;if(f)break a}f=Ab(4)|0;c[f>>2]=20472;yb(f|0,20520,265)}while(0);g[f+4>>2]=1.0;c[f+8>>2]=0;b[f+12>>1]=1;b[f+14>>1]=-1;c[f+16>>2]=0;c[f>>2]=336;h=f+20|0;c[h+0>>2]=c[a+0>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];a=f+36|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];i=e;return f|0}function mi(a){a=a|0;return(c[a+8>>2]|0)!=0|0}function ni(a){a=a|0;return a+20|0}function oi(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+20>>2]=c[b+0>>2];c[a+24>>2]=c[b+4>>2];c[a+28>>2]=c[b+8>>2];c[a+32>>2]=c[b+12>>2];i=d;return}function pi(a){a=a|0;return a+36|0}function qi(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+36>>2]=c[b+0>>2];c[a+40>>2]=c[b+4>>2];c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];i=d;return}function ri(a){a=a|0;return a+52|0}function si(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+52>>2]=c[b+0>>2];c[a+56>>2]=c[b+4>>2];c[a+60>>2]=c[b+8>>2];c[a+64>>2]=c[b+12>>2];i=d;return}function ti(a){a=a|0;return a+68|0}function ui(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+68>>2]=c[b+0>>2];c[a+72>>2]=c[b+4>>2];c[a+76>>2]=c[b+8>>2];c[a+80>>2]=c[b+12>>2];i=d;return}function vi(a){a=a|0;return b[a+12>>1]|0}function wi(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function xi(a){a=a|0;return b[a+14>>1]|0}function yi(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function zi(a){a=a|0;return c[a+8>>2]|0}function Ai(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Bi(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Ci(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+64>>2]&127](a,b);i=d;return}function Di(a){a=a|0;return c[a+24>>2]|0}function Ei(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);i=f;return}function Fi(a){a=a|0;var b=0;b=i;a=c[a+68>>2]|0;a=Pb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function Gi(a){a=a|0;return a+28|0}function Hi(a,b){a=a|0;b=b|0;var d=0;d=i;vc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);i=d;return}function Ii(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;vc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);i=e;return}function Ji(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);i=f;return}function Ki(a){a=a|0;return c[a+68>>2]|0}function Li(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;var g=0;g=i;Ou(a,b,c,d,e,f);i=g;return}function Mi(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;Qu(a,b,c,d);i=e;return}function Ni(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Oi(a,b){a=+a;b=+b;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(75)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+4>>2]=10;c[e>>2]=6400;c[e+52>>2]=0;g[e+28>>2]=b*.5;g[e+32>>2]=a;g[e+36>>2]=a;g[e+40>>2]=0.0;i=d;return e|0}function Pi(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Qi(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Ri(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Si(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0,h=0;f=i;h=fF(16)|0;a:do if(!h){while(1){h=c[5158]|0;c[5158]=h+0;if(!h)break;sc[h&3]();h=fF(16)|0;if(h)break a}h=Ab(4)|0;c[h>>2]=20472;yb(h|0,20520,265)}while(0);g[h>>2]=a;g[h+4>>2]=b;g[h+8>>2]=d;g[h+12>>2]=e;i=f;return h|0}function Ti(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function Ui(a){a=a|0;return+(+g[a>>2])}function Vi(a){a=a|0;return+(+g[a+4>>2])}function Wi(a){a=a|0;return+(+g[a+8>>2])}function Xi(a){a=a|0;return+(+g[a+12>>2])}function Yi(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Zi(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function _i(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function $i(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function aj(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function bj(a,b){a=+a;b=+b;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(75)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+4>>2]=10;c[e>>2]=6504;c[e+52>>2]=2;g[e+28>>2]=a;g[e+32>>2]=a;g[e+36>>2]=b*.5;g[e+40>>2]=0.0;i=d;return e|0}function cj(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function dj(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function ej(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function fj(a){a=a|0;var b=0,d=0;b=i;d=fF(8)|0;a:do if(!d){while(1){d=c[5158]|0;c[5158]=d+0;if(!d)break;sc[d&3]();d=fF(8)|0;if(d)break a}d=Ab(4)|0;c[d>>2]=20472;yb(d|0,20520,265)}while(0);c[d>>2]=3832;c[d+4>>2]=a;i=b;return d|0}function gj(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function hj(a){a=a|0;return(c[a+8>>2]|0)!=0|0}function ij(a){a=a|0;return b[a+12>>1]|0}function jj(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function kj(a){a=a|0;return b[a+14>>1]|0}function lj(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function mj(a){a=a|0;return c[a+8>>2]|0}function nj(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function oj(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function pj(a){a=a|0;return+(+g[a+216>>2])}function qj(a,b){a=a|0;b=+b;g[a+216>>2]=b;return}function rj(a){a=a|0;return+(+g[a+228>>2])}function sj(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function tj(a){a=a|0;return+(+g[a+244>>2])}function uj(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function vj(a){a=a|0;return+(+g[a+204>>2])}function wj(a,b){a=a|0;b=+b;g[a+204>>2]=b;return}function xj(a){a=a|0;return+(+g[a+212>>2])}function yj(a,b){a=a|0;b=+b;g[a+212>>2]=b;return}function zj(a){a=a|0;return+(+g[a+220>>2])}function Aj(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function Bj(a){a=a|0;return+(+g[a+224>>2])}function Cj(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function Dj(a){a=a|0;return+(+g[a+232>>2])}function Ej(a,b){a=a|0;b=+b;g[a+232>>2]=b;return}function Fj(a){a=a|0;return+(+g[a+248>>2])}function Gj(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Hj(a){a=a|0;return+(+g[a+208>>2])}function Ij(a,b){a=a|0;b=+b;g[a+208>>2]=b;return}function Jj(b){b=b|0;return(a[b+260>>0]&1)!=0|0}function Kj(b,c){b=b|0;c=c|0;a[b+260>>0]=c&1;return}function Lj(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function Mj(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Nj(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Oj(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Pj(){var a=0,b=0;a=i;c[5004]=(c[5004]|0)+1;b=fF(35)|0;if(!b){b=0;i=a;return b|0}c[(b+19&-16)+ -4>>2]=b;b=b+19&-16;i=a;return b|0}function Qj(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0,h=0;f=i;c[5004]=(c[5004]|0)+1;h=fF(35)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}g[h>>2]=a;g[h+4>>2]=b;g[h+8>>2]=d;g[h+12>>2]=e;i=f;return h|0}function Rj(a){a=a|0;return+(+g[a+12>>2])}function Sj(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function Tj(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];b=+Q(+(d*d+c*c+b*b));return+b}function Uj(a){a=a|0;return+(+g[a>>2])}function Vj(a){a=a|0;return+(+g[a+4>>2])}function Wj(a){a=a|0;return+(+g[a+8>>2])}function Xj(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Yj(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Zj(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function _j(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function $j(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function ak(b,d,e){b=b|0;d=d|0;e=+e;var f=0,h=0,j=0,k=0;f=i;c[5004]=(c[5004]|0)+1;h=fF(203)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}c[h>>2]=2632;a[h+144>>0]=1;c[h+140>>2]=0;c[h+132>>2]=0;c[h+136>>2]=0;c[h+176>>2]=1;g[h+56>>2]=.019999999552965164;k=h+60|0;j=h+170|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;a[j>>0]=1;c[h+8>>2]=b;g[h+52>>2]=e;g[h+48>>2]=0.0;c[h+12>>2]=d;a[h+171>>0]=1;g[h+172>>2]=0.0;g[h+16>>2]=0.0;g[h+20>>2]=0.0;g[h+44>>2]=29.399999618530273;g[h+24>>2]=55.0;g[h+28>>2]=10.0;a[h+168>>0]=0;a[h+169>>0]=0;a[h+180>>0]=1;g[h+36>>2]=.7853981852531433;g[h+40>>2]=.7071067690849304;g[h+108>>2]=0.0;a[h+181>>0]=0;a[h+182>>0]=0;i=f;return h|0}function bk(b,d,e,f){b=b|0;d=d|0;e=+e;f=f|0;var h=0,j=0,k=0;h=i;c[5004]=(c[5004]|0)+1;j=fF(203)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}c[j>>2]=2632;a[j+144>>0]=1;c[j+140>>2]=0;c[j+132>>2]=0;c[j+136>>2]=0;c[j+176>>2]=f;g[j+56>>2]=.019999999552965164;k=j+60|0;f=j+170|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;a[f>>0]=1;c[j+8>>2]=b;g[j+52>>2]=e;g[j+48>>2]=0.0;c[j+12>>2]=d;a[j+171>>0]=1;g[j+172>>2]=0.0;g[j+16>>2]=0.0;g[j+20>>2]=0.0;g[j+44>>2]=29.399999618530273;g[j+24>>2]=55.0;g[j+28>>2]=10.0;a[j+168>>0]=0;a[j+169>>0]=0;a[j+180>>0]=1;g[j+36>>2]=.7853981852531433;g[j+40>>2]=.7071067690849304;g[j+108>>2]=0.0;a[j+181>>0]=0;a[j+182>>0]=0;i=h;return j|0}function ck(a,b){a=a|0;b=b|0;if((b|0)<0)b=0;else b=(b|0)>2?2:b;c[a+176>>2]=b;return}function dk(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+16>>2]&127](a,b);i=d;return}function ek(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;tc[c[(c[a>>2]|0)+20>>2]&7](a,b,d);i=e;return}function fk(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+28>>2]&127](a,b);i=d;return}function gk(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+32>>2]&127](a,b);i=d;return}function hk(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;tc[c[(c[a>>2]|0)+36>>2]&7](a,b,d);i=e;return}function ik(a,b){a=a|0;b=+b;g[a+24>>2]=b;return}function jk(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function kk(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function lk(a){a=a|0;var b=0;b=i;a=Pb[c[(c[a>>2]|0)+40>>2]&127](a)|0;i=b;return a|0}function mk(a){a=a|0;var b=0;b=i;Lb[c[(c[a>>2]|0)+44>>2]&511](a);i=b;return}function nk(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function ok(a){a=a|0;return+(+g[a+44>>2])}function pk(a,b){a=a|0;b=+b;g[a+36>>2]=b;g[a+40>>2]=+S(+b);return}function qk(a){a=a|0;return+(+g[a+36>>2])}function rk(a){a=a|0;return c[a+8>>2]|0}function sk(b,c){b=b|0;c=c|0;a[b+170>>0]=c&1;return}function tk(a){a=a|0;var b=0;b=i;a=Pb[c[(c[a>>2]|0)+48>>2]&127](a)|0;i=b;return a|0}function uk(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function vk(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;d=i;c[5004]=(c[5004]|0)+1;e=fF(103)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}f=e+4|0;c[f>>2]=35;c[e+8>>2]=0;g[e+12>>2]=0.0;c[e>>2]=16992;m=+g[a>>2];l=+g[a+4>>2];k=+g[a+8>>2];h=+g[a+12>>2];j=1.0/+Q(+(m*m+l*l+k*k));g[e+48>>2]=m*j;g[e+52>>2]=l*j;g[e+56>>2]=k*j;g[e+60>>2]=h;g[e+64>>2]=b;a=e+68|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[f>>2]=28;i=d;return e|0}function wk(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function xk(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function yk(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function zk(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Ak(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+60>>2]&127](a,b);i=d;return}function Bk(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Ck(){var a=0,b=0;a=i;c[5004]=(c[5004]|0)+1;b=fF(35)|0;if(!b){b=0;i=a;return b|0}c[(b+19&-16)+ -4>>2]=b;b=b+19&-16;i=a;return b|0}function Dk(a,b,d){a=+a;b=+b;d=+d;var e=0,f=0;e=i;c[5004]=(c[5004]|0)+1;f=fF(35)|0;if(!f)f=0;else{c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=0.0;i=e;return f|0}function Ek(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];b=+Q(+(d*d+c*c+b*b));return+b}function Fk(a){a=a|0;return+(+g[a>>2])}function Gk(a){a=a|0;return+(+g[a+4>>2])}function Hk(a){a=a|0;return+(+g[a+8>>2])}function Ik(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Jk(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Kk(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Lk(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function Mk(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function Nk(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Ok(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Pk(a){a=+a;var b=0,d=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(71)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;c[d>>2]=16680;c[d+4>>2]=8;g[d+28>>2]=a;g[d+44>>2]=a;i=b;return d|0}function Qk(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Rk(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Sk(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Tk(){var a=0,b=0;a=i;b=fF(24)|0;a:do if(!b){while(1){b=c[5158]|0;c[5158]=b+0;if(!b)break;sc[b&3]();b=fF(24)|0;if(b)break a}b=Ab(4)|0;c[b>>2]=20472;yb(b|0,20520,265)}while(0);c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=4096;c[b+12>>2]=4096;c[b+16>>2]=0;c[b+20>>2]=1;i=a;return b|0}function Uk(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function Vk(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(783)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}lq(e,a,b,0);i=d;return e|0}function Wk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;c[5004]=(c[5004]|0)+1;f=fF(783)|0;if(!f)f=0;else{c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}lq(f,a,b,d);i=e;return f|0}function Xk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;h=i;c[5004]=(c[5004]|0)+1;j=fF(783)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}c[j+4>>2]=4;c[j+8>>2]=-1;c[j+12>>2]=-1;g[j+16>>2]=3.4028234663852886e+38;a[j+20>>0]=1;a[j+21>>0]=0;c[j+24>>2]=-1;c[j+28>>2]=b;c[j+32>>2]=d;g[j+36>>2]=0.0;g[j+40>>2]=.30000001192092896;c[j+44>>2]=0;c[j>>2]=2504;d=j+552|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=j+568|0;c[d+0>>2]=c[e+16>>2];c[d+4>>2]=c[e+20>>2];c[d+8>>2]=c[e+24>>2];c[d+12>>2]=c[e+28>>2];d=j+584|0;c[d+0>>2]=c[e+32>>2];c[d+4>>2]=c[e+36>>2];c[d+8>>2]=c[e+40>>2];c[d+12>>2]=c[e+44>>2];d=j+600|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];e=j+616|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=j+632|0;c[e+0>>2]=c[f+16>>2];c[e+4>>2]=c[f+20>>2];c[e+8>>2]=c[f+24>>2];c[e+12>>2]=c[f+28>>2];e=j+648|0;c[e+0>>2]=c[f+32>>2];c[e+4>>2]=c[f+36>>2];c[e+8>>2]=c[f+40>>2];c[e+12>>2]=c[f+44>>2];e=j+664|0;c[e+0>>2]=c[f+48>>2];c[e+4>>2]=c[f+52>>2];c[e+8>>2]=c[f+56>>2];c[e+12>>2]=c[f+60>>2];g[j+688>>2]=0.0;g[j+692>>2]=-1.0;g[j+696>>2]=.8999999761581421;g[j+700>>2]=.30000001192092896;g[j+704>>2]=1.0;g[j+708>>2]=0.0;g[j+712>>2]=0.0;a[j+716>>0]=0;a[j+736>>0]=0;a[j+737>>0]=0;a[j+738>>0]=0;a[j+739>>0]=1;a[j+740>>0]=0;c[j+748>>2]=0;g[j+732>>2]=1.0;i=h;return j|0}function Yk(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0;j=i;c[5004]=(c[5004]|0)+1;k=fF(783)|0;if(!k)k=0;else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16}c[k+4>>2]=4;c[k+8>>2]=-1;c[k+12>>2]=-1;g[k+16>>2]=3.4028234663852886e+38;a[k+20>>0]=1;a[k+21>>0]=0;c[k+24>>2]=-1;c[k+28>>2]=b;c[k+32>>2]=d;g[k+36>>2]=0.0;g[k+40>>2]=.30000001192092896;c[k+44>>2]=0;c[k>>2]=2504;d=k+552|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=k+568|0;c[d+0>>2]=c[e+16>>2];c[d+4>>2]=c[e+20>>2];c[d+8>>2]=c[e+24>>2];c[d+12>>2]=c[e+28>>2];d=k+584|0;c[d+0>>2]=c[e+32>>2];c[d+4>>2]=c[e+36>>2];c[d+8>>2]=c[e+40>>2];c[d+12>>2]=c[e+44>>2];d=k+600|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];e=k+616|0;c[e+0>>2]=c[f+0>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=k+632|0;c[e+0>>2]=c[f+16>>2];c[e+4>>2]=c[f+20>>2];c[e+8>>2]=c[f+24>>2];c[e+12>>2]=c[f+28>>2];e=k+648|0;c[e+0>>2]=c[f+32>>2];c[e+4>>2]=c[f+36>>2];c[e+8>>2]=c[f+40>>2];c[e+12>>2]=c[f+44>>2];e=k+664|0;c[e+0>>2]=c[f+48>>2];c[e+4>>2]=c[f+52>>2];c[e+8>>2]=c[f+56>>2];c[e+12>>2]=c[f+60>>2];g[k+688>>2]=0.0;g[k+692>>2]=-1.0;g[k+696>>2]=.8999999761581421;g[k+700>>2]=.30000001192092896;g[k+704>>2]=1.0;g[k+708>>2]=0.0;g[k+712>>2]=0.0;a[k+716>>0]=0;a[k+736>>0]=0;a[k+737>>0]=0;a[k+738>>0]=0;a[k+739>>0]=1;a[k+740>>0]=h&1;c[k+748>>2]=0;g[k+732>>2]=h?-1.0:1.0;i=j;return k|0}function Zk(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;c[5004]=(c[5004]|0)+1;j=fF(783)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}kq(j,a,b,d,e,f,g,0);i=h;return j|0}function _k(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;j=i;c[5004]=(c[5004]|0)+1;k=fF(783)|0;if(!k)k=0;else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16}kq(k,a,b,d,e,f,g,h);i=j;return k|0}function $k(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;var f=0;f=i;g[a+692>>2]=(c-b)*.5;b=+ab(+((c-b)*.5+b),6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=1.0;i=f;return}function al(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;var h=0;h=i;g[a+692>>2]=(c-b)*.5;b=+ab(+((c-b)*.5+b),6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=f;i=h;return}function bl(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function cl(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function dl(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function el(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function fl(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function gl(){var a=0,b=0;a=i;b=fF(12)|0;a:do if(!b){while(1){b=c[5158]|0;c[5158]=b+0;if(!b)break;sc[b&3]();b=fF(12)|0;if(b)break a}b=Ab(4)|0;c[b>>2]=20472;yb(b|0,20520,265)}while(0);g[b>>2]=.30000001192092896;g[b+4>>2]=1.0;g[b+8>>2]=0.0;i=a;return b|0}function hl(a){a=a|0;return+(+g[a>>2])}function il(a,b){a=a|0;b=+b;g[a>>2]=b;return}function jl(a){a=a|0;return+(+g[a+4>>2])}function kl(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function ll(a){a=a|0;return+(+g[a+8>>2])}function ml(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function nl(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function ol(){var b=0,d=0,e=0,f=0,h=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(303)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}g[d+164>>2]=1.0;g[d+168>>2]=1.0;g[d+172>>2]=1.0;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749400.0;h=d+188|0;e=d+204|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;e=d+236|0;c[d+240>>2]=0;g[d+244>>2]=1.0;h=d+248|0;f=d+4|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;g[f>>2]=1.0;f=d+8|0;h=d+24|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;g[h>>2]=1.0;h=d+28|0;f=d+44|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;g[f>>2]=1.0;f=d+48|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[d>>2]=13008;a[d+280>>0]=1;c[d+276>>2]=0;c[d+268>>2]=0;c[d+272>>2]=0;c[e>>2]=4;i=b;return d|0}function pl(a){a=a|0;return c[a+268>>2]|0}function ql(a,b){a=a|0;b=b|0;return c[(c[a+276>>2]|0)+(b<<2)>>2]|0}function rl(a){a=a|0;return c[a+192>>2]|0}function sl(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function tl(a,b){a=a|0;b=b|0;var d=0;d=i;if(((c[a+216>>2]|0)+ -4|0)>>>0<2){i=d;return}c[a+216>>2]=b;i=d;return}function ul(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function vl(a){a=a|0;var b=0;b=i;if(c[a+204>>2]&3){i=b;return}if(((c[a+216>>2]|0)+ -4|0)>>>0>=2)c[a+216>>2]=1;g[a+220>>2]=0.0;i=b;return}function wl(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b?(c[a+204>>2]&3|0)!=0:0){i=d;return}if(((c[a+216>>2]|0)+ -4|0)>>>0>=2)c[a+216>>2]=1;g[a+220>>2]=0.0;i=d;return}function xl(a){a=a|0;a=c[a+216>>2]|0;return((a|0)==2?0:(a|0)!=5)|0}function yl(a){a=a|0;return(c[a+204>>2]&2|0)!=0|0}function zl(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Al(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Bl(a){a=a|0;return a+4|0}function Cl(a){a=a|0;return c[a+204>>2]|0}function Dl(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function El(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];i=d;return}function Fl(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function Gl(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Hl(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Il(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+8>>2]&511](a);i=b;return}function Jl(a){a=a|0;return c[a>>2]|0}function Kl(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Ll(a){a=a|0;return c[a+4>>2]|0}function Ml(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Nl(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function Ol(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Pl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;b=i;f=fF(152)|0;a:do if(!f){while(1){f=c[5158]|0;c[5158]=f+0;if(!f)break;sc[f&3]();f=fF(152)|0;if(f)break a}f=Ab(4)|0;c[f>>2]=20472;yb(f|0,20520,265)}while(0);c[f>>2]=3752;a[f+20>>0]=1;c[f+16>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[f+40>>0]=1;c[f+36>>2]=0;c[f+28>>2]=0;c[f+32>>2]=0;a[f+60>>0]=1;c[f+56>>2]=0;c[f+48>>2]=0;c[f+52>>2]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;c[f+100>>2]=e;g[f+104>>2]=0.0;a[f+148>>0]=1;c[f+144>>2]=0;c[f+136>>2]=0;c[f+140>>2]=0;c[f+116>>2]=d;c[f+120>>2]=0;c[f+124>>2]=2;c[f+128>>2]=1;g[f+112>>2]=0.0;g[f+108>>2]=0.0;i=b;return f|0}function Ql(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+252>>2]=b;return}function Rl(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+232>>2]=b;return}function Sl(a,b){a=a|0;b=b|0;return(c[a+144>>2]|0)+(b*284|0)+92|0}function Tl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;$q(c[a+116>>2]|0,c[a+144>>2]|0,b,d);i=e;return}function Ul(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;l=l|0;var m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0,v=0,w=0;m=i;i=i+288|0;c[m+144>>2]=c[d+0>>2];c[m+148>>2]=c[d+4>>2];c[m+152>>2]=c[d+8>>2];c[m+156>>2]=c[d+12>>2];w=m+160|0;c[w+0>>2]=c[e+0>>2];c[w+4>>2]=c[e+4>>2];c[w+8>>2]=c[e+8>>2];c[w+12>>2]=c[e+12>>2];v=m+176|0;c[v+0>>2]=c[f+0>>2];c[v+4>>2]=c[f+4>>2];c[v+8>>2]=c[f+8>>2];c[v+12>>2]=c[f+12>>2];o=+g[k>>2];p=+g[k+4>>2];q=+g[k+8>>2];r=+g[k+16>>2];n=+g[k+12>>2];t=+g[k+20>>2];c[m+0>>2]=c[m+144>>2];c[m+4>>2]=c[m+148>>2];c[m+8>>2]=c[m+152>>2];c[m+12>>2]=c[m+156>>2];c[m+16>>2]=c[w+0>>2];c[m+20>>2]=c[w+4>>2];c[m+24>>2]=c[w+8>>2];c[m+28>>2]=c[w+12>>2];c[m+32>>2]=c[v+0>>2];c[m+36>>2]=c[v+4>>2];c[m+40>>2]=c[v+8>>2];c[m+44>>2]=c[v+12>>2];v=c[b+136>>2]|0;if((v|0)==(c[b+140>>2]|0)?(s=(v|0)==0?1:v<<1,(v|0)<(s|0)):0){if(!s)d=0;else{c[5004]=(c[5004]|0)+1;k=fF((s*284|3)+16|0)|0;if(!k)d=0;else{c[(k+19&-16)+ -4>>2]=k;d=k+19&-16}v=c[b+136>>2]|0}if((v|0)>0){w=0;do{k=d+(w*284|0)|0;if(k){u=c[b+144>>2]|0;e=k+0|0;k=u+(w*284|0)+0|0;f=e+92|0;do{c[e>>2]=c[k>>2];e=e+4|0;k=k+4|0}while((e|0)<(f|0));e=d+(w*284|0)+92|0;k=u+(w*284|0)+92|0;c[e+0>>2]=c[k+0>>2];c[e+4>>2]=c[k+4>>2];c[e+8>>2]=c[k+8>>2];c[e+12>>2]=c[k+12>>2];e=d+(w*284|0)+108|0;k=u+(w*284|0)+108|0;c[e+0>>2]=c[k+0>>2];c[e+4>>2]=c[k+4>>2];c[e+8>>2]=c[k+8>>2];c[e+12>>2]=c[k+12>>2];e=d+(w*284|0)+124|0;k=u+(w*284|0)+124|0;c[e+0>>2]=c[k+0>>2];c[e+4>>2]=c[k+4>>2];c[e+8>>2]=c[k+8>>2];c[e+12>>2]=c[k+12>>2];e=d+(w*284|0)+140|0;k=u+(w*284|0)+140|0;c[e+0>>2]=c[k+0>>2];c[e+4>>2]=c[k+4>>2];c[e+8>>2]=c[k+8>>2];c[e+12>>2]=c[k+12>>2];e=d+(w*284|0)+156|0;k=u+(w*284|0)+156|0;f=e+128|0;do{c[e>>2]=c[k>>2];e=e+4|0;k=k+4|0}while((e|0)<(f|0))}w=w+1|0}while((w|0)!=(v|0))}k=c[b+144>>2]|0;if(k){if(a[b+148>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=d;c[b+140>>2]=s;v=c[b+136>>2]|0}s=c[b+144>>2]|0;k=s+(v*284|0)|0;if(!k){w=v;d=s;v=w+1|0;c[b+136>>2]=v;w=d+(w*284|0)|0;d=b+116|0;v=c[d>>2]|0;_q(v,w,0);v=c[b+136>>2]|0;v=v+ -1|0;d=c[d>>2]|0;u=c[b+144>>2]|0;$q(d,u,v,0);i=m;return w|0}e=k+0|0;k=m+48|0;f=e+92|0;do{c[e>>2]=c[k>>2];e=e+4|0;k=k+4|0}while((e|0)<(f|0));e=s+(v*284|0)+92|0;c[e+0>>2]=c[m+240>>2];c[e+4>>2]=c[m+244>>2];c[e+8>>2]=c[m+248>>2];c[e+12>>2]=c[m+252>>2];e=s+(v*284|0)+108|0;c[e+0>>2]=c[m+224>>2];c[e+4>>2]=c[m+228>>2];c[e+8>>2]=c[m+232>>2];c[e+12>>2]=c[m+236>>2];e=s+(v*284|0)+124|0;c[e+0>>2]=c[m+208>>2];c[e+4>>2]=c[m+212>>2];c[e+8>>2]=c[m+216>>2];c[e+12>>2]=c[m+220>>2];e=s+(v*284|0)+140|0;c[e+0>>2]=c[m+192>>2];c[e+4>>2]=c[m+196>>2];c[e+8>>2]=c[m+200>>2];c[e+12>>2]=c[m+204>>2];s=s+(v*284|0)+156|0;e=s+0|0;k=m+0|0;f=e+48|0;do{c[e>>2]=c[k>>2];e=e+4|0;k=k+4|0}while((e|0)<(f|0));g[s+48>>2]=h;g[s+52>>2]=n;g[s+56>>2]=j;g[s+60>>2]=o;g[s+64>>2]=p;g[s+68>>2]=q;g[s+72>>2]=r;g[s+76>>2]=0.0;g[s+80>>2]=0.0;g[s+84>>2]=0.0;g[s+88>>2]=.10000000149011612;g[s+92>>2]=t;g[s+96>>2]=0.0;g[s+100>>2]=0.0;a[s+104>>0]=l&1;e=s+105|0;k=m+256|0;f=e+23|0;do{a[e>>0]=a[k>>0]|0;e=e+1|0;k=k+1|0}while((e|0)<(f|0));w=c[b+136>>2]|0;d=c[b+144>>2]|0;v=w+1|0;c[b+136>>2]=v;w=d+(w*284|0)|0;d=b+116|0;v=c[d>>2]|0;_q(v,w,0);v=c[b+136>>2]|0;v=v+ -1|0;d=c[d>>2]|0;u=c[b+144>>2]|0;$q(d,u,v,0);i=m;return w|0}function Vl(a){a=a|0;return c[a+136>>2]|0}function Wl(a){a=a|0;return c[a+116>>2]|0}function Xl(a,b){a=a|0;b=b|0;return(c[a+144>>2]|0)+(b*284|0)|0}function Yl(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+256>>2]=b;return}function Zl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);i=f;return}function _l(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function $l(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0;h=i;j=fF(44)|0;a:do if(!j){while(1){j=c[5158]|0;c[5158]=j+0;if(!j)break;sc[j&3]();j=fF(44)|0;if(j)break a}j=Ab(4)|0;c[j>>2]=20472;yb(j|0,20520,265)}while(0);c[j>>2]=a;c[j+4>>2]=b;b=j+8|0;c[b+0>>2]=c[d+0>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];d=j+24|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];g[j+40>>2]=f;i=h;return j|0}function am(a){a=a|0;return c[a>>2]|0}function bm(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function cm(a){a=a|0;return c[a+4>>2]|0}function dm(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function em(a){a=a|0;return a+8|0}function fm(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+8>>2]=c[b+0>>2];c[a+12>>2]=c[b+4>>2];c[a+16>>2]=c[b+8>>2];c[a+20>>2]=c[b+12>>2];i=d;return}function gm(a){a=a|0;return a+24|0}function hm(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+24>>2]=c[b+0>>2];c[a+28>>2]=c[b+4>>2];c[a+32>>2]=c[b+8>>2];c[a+36>>2]=c[b+12>>2];i=d;return}function im(a){a=a|0;return+(+g[a+40>>2])}function jm(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function km(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function lm(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function mm(b){b=b|0;var d=0,e=0,f=0,h=0;d=i;c[5004]=(c[5004]|0)+1;e=fF(635)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}g[e+164>>2]=1.0;g[e+168>>2]=1.0;g[e+172>>2]=1.0;g[e+176>>2]=0.0;c[e+180>>2]=0;g[e+184>>2]=999999984306749400.0;f=e+188|0;h=e+204|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[h>>2]=1;c[e+208>>2]=-1;c[e+212>>2]=-1;c[e+216>>2]=1;g[e+220>>2]=0.0;g[e+224>>2]=.5;g[e+228>>2]=0.0;g[e+232>>2]=0.0;c[e+236>>2]=1;c[e+240>>2]=0;g[e+244>>2]=1.0;h=e+248|0;f=e+4|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;g[f>>2]=1.0;f=e+8|0;h=e+24|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;g[h>>2]=1.0;h=e+28|0;f=e+44|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;g[f>>2]=1.0;f=e+48|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[e>>2]=3912;a[e+500>>0]=1;c[e+496>>2]=0;c[e+488>>2]=0;c[e+492>>2]=0;kr(e,b);i=d;return e|0}function nm(a){a=a|0;return a+4|0}function om(a,b){a=a|0;b=b|0;var c=0;c=i;nr(a,b);i=c;return}function pm(a,b,c){a=a|0;b=+b;c=+c;g[a+472>>2]=b;g[a+476>>2]=c;return}function qm(a,b,c){a=a|0;b=+b;c=+c;if(b<0.0)b=0.0;else b=b>1.0?1.0:b;g[a+444>>2]=b;if(c<0.0)c=0.0;else c=c>1.0?1.0:c;g[a+448>>2]=c;return}function rm(a,b,c){a=a|0;b=+b;c=c|0;var d=0;d=i;mr(a,b,c);i=d;return}function sm(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0;d=i;c[a+348>>2]=c[b+0>>2];c[a+352>>2]=c[b+4>>2];c[a+356>>2]=c[b+8>>2];c[a+360>>2]=c[b+12>>2];h=+g[a+344>>2];f=+g[a+352>>2]*h;e=+g[a+356>>2]*h;g[a+560>>2]=+g[a+348>>2]*h;g[a+564>>2]=f;g[a+568>>2]=e;g[a+572>>2]=0.0;i=d;return}function tm(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+548>>2];c=+g[b+8>>2]*+g[a+552>>2];g[a+428>>2]=+g[a+428>>2]+ +g[b>>2]*+g[a+544>>2];g[a+432>>2]=+g[a+432>>2]+d;g[a+436>>2]=+g[a+436>>2]+c;return}function um(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;d=+g[a+348>>2];f=+g[a+352>>2];h=+g[b+4>>2]*f;i=+g[a+356>>2];j=+g[b+8>>2]*i;g[a+412>>2]=+g[a+412>>2]+ +g[b>>2]*d;g[a+416>>2]=+g[a+416>>2]+h;g[a+420>>2]=+g[a+420>>2]+j;d=+g[b>>2]*d;f=+g[b+4>>2]*f;i=+g[b+8>>2]*i;j=+g[c+4>>2];h=+g[c+8>>2];k=+g[c>>2];e=(h*d-k*i)*+g[a+548>>2];d=(k*f-j*d)*+g[a+552>>2];g[a+428>>2]=+g[a+428>>2]+(j*i-h*f)*+g[a+544>>2];g[a+432>>2]=+g[a+432>>2]+e;g[a+436>>2]=+g[a+436>>2]+d;return}function vm(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+352>>2];c=+g[b+8>>2]*+g[a+356>>2];g[a+412>>2]=+g[a+412>>2]+ +g[b>>2]*+g[a+348>>2];g[a+416>>2]=+g[a+416>>2]+d;g[a+420>>2]=+g[a+420>>2]+c;return}function wm(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0;h=+g[b>>2];f=+g[b+4>>2];e=+g[b+8>>2];d=(+g[a+280>>2]*h+ +g[a+284>>2]*f+ +g[a+288>>2]*e)*+g[a+548>>2];c=(+g[a+296>>2]*h+ +g[a+300>>2]*f+ +g[a+304>>2]*e)*+g[a+552>>2];g[a+328>>2]=+g[a+328>>2]+(+g[a+264>>2]*h+ +g[a+268>>2]*f+ +g[a+272>>2]*e)*+g[a+544>>2];g[a+332>>2]=+g[a+332>>2]+d;g[a+336>>2]=+g[a+336>>2]+c;return}function xm(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;ym(a,b,c);i=d;return}function ym(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;d=i;if(!(+g[a+344>>2]!=0.0)){i=d;return}Am(a,b);h=+g[b>>2]*+g[a+348>>2];k=+g[b+4>>2]*+g[a+352>>2];m=+g[b+8>>2]*+g[a+356>>2];j=+g[c+4>>2];n=+g[c+8>>2];l=+g[c>>2];f=(+g[a+280>>2]*(j*m-n*k)+ +g[a+284>>2]*(n*h-l*m)+ +g[a+288>>2]*(l*k-j*h))*+g[a+548>>2];e=(+g[a+296>>2]*(j*m-n*k)+ +g[a+300>>2]*(n*h-l*m)+ +g[a+304>>2]*(l*k-j*h))*+g[a+552>>2];g[a+328>>2]=+g[a+328>>2]+(+g[a+264>>2]*(j*m-n*k)+ +g[a+268>>2]*(n*h-l*m)+ +g[a+272>>2]*(l*k-j*h))*+g[a+544>>2];g[a+332>>2]=+g[a+332>>2]+f;g[a+336>>2]=+g[a+336>>2]+e;i=d;return}function zm(a,b){a=a|0;b=b|0;var c=0;c=i;Am(a,b);i=c;return}function Am(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+g[a+344>>2];d=+g[b+4>>2]*+g[a+352>>2]*e;c=+g[b+8>>2]*+g[a+356>>2]*e;g[a+312>>2]=+g[a+312>>2]+ +g[b>>2]*+g[a+348>>2]*e;g[a+316>>2]=+g[a+316>>2]+d;g[a+320>>2]=+g[a+320>>2]+c;return}function Bm(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;n=+g[a+4>>2];h=+g[a+396>>2];m=+g[a+8>>2];e=+g[a+400>>2];l=+g[a+12>>2];c=+g[a+404>>2];k=+g[a+20>>2];j=+g[a+24>>2];i=+g[a+28>>2];f=+g[a+36>>2];d=+g[a+40>>2];b=+g[a+44>>2];g[a+264>>2]=n*n*h+m*m*e+l*l*c;g[a+268>>2]=n*h*k+m*e*j+l*c*i;g[a+272>>2]=n*h*f+m*e*d+l*c*b;g[a+276>>2]=0.0;g[a+280>>2]=n*h*k+m*e*j+l*c*i;g[a+284>>2]=k*h*k+j*e*j+i*c*i;g[a+288>>2]=h*k*f+e*j*d+c*i*b;g[a+292>>2]=0.0;g[a+296>>2]=n*h*f+m*e*d+l*c*b;g[a+300>>2]=k*h*f+j*e*d+i*c*b;g[a+304>>2]=f*h*f+d*e*d+b*c*b;g[a+308>>2]=0.0;return}function Cm(a){a=a|0;return a+312|0}function Dm(a){a=a|0;return a+328|0}function Em(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+312>>2]=c[b+0>>2];c[a+316>>2]=c[b+4>>2];c[a+320>>2]=c[b+8>>2];c[a+324>>2]=c[b+12>>2];i=d;return}function Fm(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+328>>2]=c[b+0>>2];c[a+332>>2]=c[b+4>>2];c[a+336>>2]=c[b+8>>2];c[a+340>>2]=c[b+12>>2];i=d;return}function Gm(a){a=a|0;return c[a+480>>2]|0}function Hm(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+544>>2]=c[b+0>>2];c[a+548>>2]=c[b+4>>2];c[a+552>>2]=c[b+8>>2];c[a+556>>2]=c[b+12>>2];i=d;return}function Im(a,b){a=a|0;b=b|0;if(!(c[b+236>>2]&2))b=0;return b|0}function Jm(a){a=a|0;return c[a+192>>2]|0}function Km(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Lm(a,b){a=a|0;b=b|0;var d=0;d=i;if(((c[a+216>>2]|0)+ -4|0)>>>0<2){i=d;return}c[a+216>>2]=b;i=d;return}function Mm(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Nm(a){a=a|0;var b=0;b=i;if(c[a+204>>2]&3){i=b;return}if(((c[a+216>>2]|0)+ -4|0)>>>0>=2)c[a+216>>2]=1;g[a+220>>2]=0.0;i=b;return}function Om(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b?(c[a+204>>2]&3|0)!=0:0){i=d;return}if(((c[a+216>>2]|0)+ -4|0)>>>0>=2)c[a+216>>2]=1;g[a+220>>2]=0.0;i=d;return}function Pm(a){a=a|0;a=c[a+216>>2]|0;return((a|0)==2?0:(a|0)!=5)|0}function Qm(a){a=a|0;return(c[a+204>>2]&2|0)!=0|0}function Rm(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Sm(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Tm(a){a=a|0;return a+4|0}function Um(a){a=a|0;return c[a+204>>2]|0}function Vm(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Wm(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];i=d;return}function Xm(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function Ym(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Zm(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function _m(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+8>>2]&511](a);i=b;return}function $m(a){a=a|0;var b=0,d=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(75)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}tx(d,a);c[d>>2]=11032;c[d+52>>2]=0;i=b;return d|0}function an(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function bn(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function cn(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function dn(a){a=a|0;var b=0,d=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(75)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}tx(d,a);c[d>>2]=11136;c[d+52>>2]=2;i=b;return d|0}function en(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function fn(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function gn(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function hn(){var a=0,b=0,d=0,e=0;a=i;e=fF(64)|0;a:do if(!e){while(1){b=c[5158]|0;c[5158]=b+0;if(!b)break;sc[b&3]();e=fF(64)|0;if(e)break a}e=Ab(4)|0;c[e>>2]=20472;yb(e|0,20520,265)}while(0);b=e+48|0;d=e;do d=d+16|0;while((d|0)!=(b|0));i=a;return e|0}function jn(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;e=fF(64)|0;a:do if(!e){while(1){e=c[5158]|0;c[5158]=e+0;if(!e)break;sc[e&3]();e=fF(64)|0;if(e)break a}g=Ab(4)|0;c[g>>2]=20472;yb(g|0,20520,265)}while(0);f=e+48|0;g=e;do g=g+16|0;while((g|0)!=(f|0));co(e,a);c[f+0>>2]=c[b+0>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];i=d;return e|0}function kn(a){a=a|0;var b=0;b=i;ln(a);i=b;return}function ln(a){a=a|0;var b=0;b=i;g[a>>2]=1.0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;g[a+20>>2]=1.0;c[a+24>>2]=0;c[a+28>>2]=0;c[a+32>>2]=0;c[a+36>>2]=0;g[a+40>>2]=1.0;g[a+44>>2]=0.0;c[a+48>>2]=0;c[a+52>>2]=0;c[a+56>>2]=0;c[a+60>>2]=0;i=b;return}function mn(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+48>>2]=c[b+0>>2];c[a+52>>2]=c[b+4>>2];c[a+56>>2]=c[b+8>>2];c[a+60>>2]=c[b+12>>2];i=d;return}function nn(a,b){a=a|0;b=b|0;var c=0;c=i;co(a,b);i=c;return}function on(a){a=a|0;return a+48|0}function pn(b){b=b|0;var d=0;d=i;i=i+16|0;if((a[48]|0)==0?(Ya(48)|0)!=0:0)bb(48);Hc(b,d);c[8]=c[d+0>>2];c[9]=c[d+4>>2];c[10]=c[d+8>>2];c[11]=c[d+12>>2];i=d;return 32}function qn(a){a=a|0;return a|0}function rn(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function sn(a){a=a|0;return c[a+24>>2]|0}function tn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);i=f;return}function un(a){a=a|0;var b=0;b=i;a=c[a+68>>2]|0;a=Pb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function vn(a){a=a|0;return a+28|0}function wn(a,b){a=a|0;b=b|0;var d=0;d=i;vc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);i=d;return}function xn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;vc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);i=e;return}function yn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);i=f;return}function zn(a){a=a|0;return c[a+68>>2]|0}function An(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;var g=0;g=i;Ou(a,b,c,d,e,f);i=g;return}function Bn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;Qu(a,b,c,d);i=e;return}function Cn(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Dn(a){a=a|0;return+(+g[a>>2])}function En(a){a=a|0;return+(+g[a+4>>2])}function Fn(a){a=a|0;return+(+g[a+8>>2])}function Gn(a){a=a|0;return+(+g[a+12>>2])}function Hn(a,b){a=a|0;b=+b;g[a>>2]=b;return}function In(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Jn(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Kn(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function Ln(a){a=a|0;var b=0;b=i;if(a)gF(a);i=b;return}function Mn(a){a=a|0;var b=0,d=0;b=i;c[5004]=(c[5004]|0)+1;d=fF(75)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}tx(d,a);i=b;return d|0}function Nn(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function On(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Ub[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Pn(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Qn(){var a=0,b=0,d=0;a=i;b=fF(4)|0;if(b){d=b;c[d>>2]=192;i=a;return d|0}while(1){b=c[5158]|0;c[5158]=b+0;if(!b){b=4;break}sc[b&3]();d=fF(4)|0;if(d){b=5;break}}if((b|0)==4){d=Ab(4)|0;c[d>>2]=20472;yb(d|0,20520,265)}else if((b|0)==5){c[d>>2]=192;i=a;return d|0}return 0}function Rn(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Sn(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Tn(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Lb[c[(c[a>>2]|0)+4>>2]&511](a);i=b;return}function Un(a){a=a|0;return}function Vn(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Wn(a){a=a|0;return}function Xn(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return}function Yn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function Zn(a){a=a|0;return}function _n(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function $n(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;a=i;f=c[b>>2]|0;e=c[d>>2]|0;if((c[f+236>>2]|0)!=4)f=0;if((c[e+236>>2]|0)!=4)e=0;if(f)rc[c[(c[f>>2]|0)+28>>2]&127](f,d,b);if(!e){i=a;return 0}rc[c[(c[e>>2]|0)+28>>2]&127](e,b,d);i=a;return 0}function ao(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;a=i;g=c[b>>2]|0;f=c[d>>2]|0;if((c[g+236>>2]|0)!=4)g=0;if((c[f+236>>2]|0)!=4)f=0;if(g)vc[c[(c[g>>2]|0)+32>>2]&127](g,d,e,b);if(!f){i=a;return 0}vc[c[(c[f>>2]|0)+32>>2]&127](f,b,e,d);i=a;return 0}function bo(a,b,c){a=a|0;b=b|0;c=c|0;return}function co(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;f=+g[b>>2];d=+g[b+4>>2];j=+g[b+8>>2];h=+g[b+12>>2];e=f*(2.0/(f*f+d*d+j*j+h*h));c=d*(2.0/(f*f+d*d+j*j+h*h));i=j*(2.0/(f*f+d*d+j*j+h*h));g[a>>2]=1.0-(d*c+j*i);g[a+4>>2]=f*c-h*i;g[a+8>>2]=f*i+h*c;g[a+12>>2]=0.0;g[a+16>>2]=f*c+h*i;g[a+20>>2]=1.0-(f*e+j*i);g[a+24>>2]=d*i-h*e;g[a+28>>2]=0.0;g[a+32>>2]=f*i-h*c;g[a+36>>2]=d*i+h*e;g[a+40>>2]=1.0-(f*e+d*c);g[a+44>>2]=0.0;return}function eo(a){a=a|0;return}function fo(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function go(a,c){a=a|0;c=c|0;var d=0;d=i;if(!((b[c+4>>1]&b[a+14>>1])<<16>>16)){c=0;i=d;return c|0}c=(b[a+12>>1]&b[c+6>>1])<<16>>16!=0;i=d;return c|0}function ho(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;g[a+4>>2]=+g[b+24>>2];e=c[b>>2]|0;c[a+8>>2]=e;if(d){c[a+52>>2]=c[b+8>>2];c[a+56>>2]=c[b+12>>2];c[a+60>>2]=c[b+16>>2];c[a+64>>2]=c[b+20>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=+g[e+20>>2]*k+ +g[e+24>>2]*j+ +g[e+28>>2]*i;f=+g[e+36>>2]*k+ +g[e+40>>2]*j+ +g[e+44>>2]*i;g[a+52>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+56>>2]=h;g[a+60>>2]=f;g[a+64>>2]=0.0}k=+g[b+24>>2];g[a+68>>2]=(1.0-k)*+g[a+20>>2]+ +g[a+36>>2]*k;g[a+72>>2]=(1.0-k)*+g[a+24>>2]+k*+g[a+40>>2];g[a+76>>2]=(1.0-k)*+g[a+28>>2]+k*+g[a+44>>2];return+(+g[b+24>>2])}function io(a,b,c,d,e,f,h,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0;n=i;m=a;do m=m+16|0;while((m|0)!=(a+48|0));g[a>>2]=+g[b>>2];g[a+4>>2]=+g[c>>2];g[a+8>>2]=+g[d>>2];g[a+12>>2]=0.0;g[a+16>>2]=+g[e>>2];g[a+20>>2]=+g[f>>2];g[a+24>>2]=+g[h>>2];g[a+28>>2]=0.0;g[a+32>>2]=+g[j>>2];g[a+36>>2]=+g[k>>2];g[a+40>>2]=+g[l>>2];g[a+44>>2]=0.0;i=n;return}function jo(a){a=a|0;return}function ko(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function lo(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0;d=i;i=i+176|0;io(d+128|0,a+68|0,a+84|0,a+100|0,a+72|0,a+88|0,a+104|0,a+76|0,a+92|0,a+108|0);l=-+g[a+116>>2];k=-+g[a+120>>2];h=-+g[a+124>>2];e=+g[d+128>>2]*l+ +g[d+132>>2]*k+ +g[d+136>>2]*h;f=+g[d+144>>2]*l+ +g[d+148>>2]*k+ +g[d+152>>2]*h;h=+g[d+160>>2]*l+ +g[d+164>>2]*k+ +g[d+168>>2]*h;j=d;do j=j+16|0;while((j|0)!=(d+48|0));c[d+0>>2]=c[d+128>>2];c[d+4>>2]=c[d+132>>2];c[d+8>>2]=c[d+136>>2];c[d+12>>2]=c[d+140>>2];c[d+16>>2]=c[d+144>>2];c[d+20>>2]=c[d+148>>2];c[d+24>>2]=c[d+152>>2];c[d+28>>2]=c[d+156>>2];c[d+32>>2]=c[d+160>>2];c[d+36>>2]=c[d+164>>2];c[d+40>>2]=c[d+168>>2];c[d+44>>2]=c[d+172>>2];g[d+48>>2]=e;g[d+52>>2]=f;g[d+56>>2]=h;g[d+60>>2]=0.0;no(d+64|0,d,a+4|0);c[b+0>>2]=c[d+64>>2];c[b+4>>2]=c[d+68>>2];c[b+8>>2]=c[d+72>>2];c[b+12>>2]=c[d+76>>2];c[b+16>>2]=c[d+80>>2];c[b+20>>2]=c[d+84>>2];c[b+24>>2]=c[d+88>>2];c[b+28>>2]=c[d+92>>2];c[b+32>>2]=c[d+96>>2];c[b+36>>2]=c[d+100>>2];c[b+40>>2]=c[d+104>>2];c[b+44>>2]=c[d+108>>2];c[b+48>>2]=c[d+112>>2];c[b+52>>2]=c[d+116>>2];c[b+56>>2]=c[d+120>>2];c[b+60>>2]=c[d+124>>2];i=d;return}function mo(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+64|0;no(d,b,a+68|0);c[a+4>>2]=c[d+0>>2];c[a+8>>2]=c[d+4>>2];c[a+12>>2]=c[d+8>>2];c[a+16>>2]=c[d+12>>2];c[a+20>>2]=c[d+16>>2];c[a+24>>2]=c[d+20>>2];c[a+28>>2]=c[d+24>>2];c[a+32>>2]=c[d+28>>2];c[a+36>>2]=c[d+32>>2];c[a+40>>2]=c[d+36>>2];c[a+44>>2]=c[d+40>>2];c[a+48>>2]=c[d+44>>2];c[a+52>>2]=c[d+48>>2];c[a+56>>2]=c[d+52>>2];c[a+60>>2]=c[d+56>>2];c[a+64>>2]=c[d+60>>2];i=d;return}function no(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;e=i;i=i+96|0;s=+g[d>>2];h=+g[b>>2];r=+g[d+16>>2];j=+g[b+4>>2];q=+g[d+32>>2];l=+g[b+8>>2];g[e+80>>2]=s*h+r*j+q*l;p=+g[d+4>>2];o=+g[d+20>>2];n=+g[d+36>>2];g[e+76>>2]=p*h+o*j+n*l;m=+g[d+8>>2];f=+g[d+24>>2];k=+g[d+40>>2];g[e+72>>2]=m*h+f*j+k*l;l=+g[b+16>>2];j=+g[b+20>>2];h=+g[b+24>>2];g[e+68>>2]=s*l+r*j+q*h;g[e+64>>2]=p*l+o*j+n*h;g[e+60>>2]=m*l+f*j+k*h;h=+g[b+32>>2];j=+g[b+36>>2];l=+g[b+40>>2];g[e+56>>2]=s*h+r*j+q*l;g[e+52>>2]=p*h+o*j+n*l;g[e+48>>2]=m*h+f*j+k*l;io(e,e+80|0,e+76|0,e+72|0,e+68|0,e+64|0,e+60|0,e+56|0,e+52|0,e+48|0);l=+g[d+48>>2];k=+g[d+52>>2];j=+g[d+56>>2];f=l*+g[b>>2]+k*+g[b+4>>2]+j*+g[b+8>>2]+ +g[b+48>>2];h=l*+g[b+16>>2]+k*+g[b+20>>2]+j*+g[b+24>>2]+ +g[b+52>>2];j=l*+g[b+32>>2]+k*+g[b+36>>2]+j*+g[b+40>>2]+ +g[b+56>>2];b=a;do b=b+16|0;while((b|0)!=(a+48|0));c[a+0>>2]=c[e+0>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[a+16>>2]=c[e+16>>2];c[a+20>>2]=c[e+20>>2];c[a+24>>2]=c[e+24>>2];c[a+28>>2]=c[e+28>>2];c[a+32>>2]=c[e+32>>2];c[a+36>>2]=c[e+36>>2];c[a+40>>2]=c[e+40>>2];c[a+44>>2]=c[e+44>>2];g[a+48>>2]=f;g[a+52>>2]=h;g[a+56>>2]=j;g[a+60>>2]=0.0;i=e;return}function oo(a){a=a|0;return}function po(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function qo(a,c){a=a|0;c=c|0;var d=0;d=i;if(!((b[c+4>>1]&b[a+10>>1])<<16>>16)){c=0;i=d;return c|0}c=(b[a+8>>1]&b[c+6>>1])<<16>>16!=0;i=d;return c|0}function ro(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;e=i;g[a+4>>2]=+g[b+40>>2];f=c[b>>2]|0;c[a+76>>2]=f;if(d){c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];c[a+52>>2]=c[b+16>>2];c[a+56>>2]=c[b+20>>2];d=a+60|0;a=b+24|0;c[d+0>>2]=c[a+0>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];h=+g[b+40>>2];i=e;return+h}else{m=+g[b+8>>2];l=+g[b+12>>2];k=+g[b+16>>2];j=+g[f+20>>2]*m+ +g[f+24>>2]*l+ +g[f+28>>2]*k;h=+g[f+36>>2]*m+ +g[f+40>>2]*l+ +g[f+44>>2]*k;g[a+44>>2]=+g[f+4>>2]*m+ +g[f+8>>2]*l+ +g[f+12>>2]*k;g[a+48>>2]=j;g[a+52>>2]=h;g[a+56>>2]=0.0;d=a+60|0;a=b+24|0;c[d+0>>2]=c[a+0>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];h=+g[b+40>>2];i=e;return+h}return 0.0}function so(a){a=a|0;return}function to(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function uo(a,c){a=a|0;c=c|0;var d=0;d=i;if(!((b[c+4>>1]&b[a+6>>1])<<16>>16)){c=0;i=d;return c|0}c=(b[a+4>>1]&b[c+6>>1])<<16>>16!=0;i=d;return c|0}function vo(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0.0,k=0;k=i;j=+Ta(960,a|0,b|0,c|0,d|0,e|0,f|0,g|0,h|0);i=k;return+j}function wo(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0,l=0;e=i;if(a[b+527>>0]|0){c[d>>2]=0;c[d+4>>2]=0;i=e;return}c[d>>2]=3;c[d+4>>2]=3;l=c[b+28>>2]|0;k=c[b+32>>2]|0;xo(b,l+4|0,k+4|0,l+264|0,k+264|0);if(((a[b+526>>0]|0)!=0?(f=c[d>>2]|0,c[d>>2]=f+1,h=c[d+4>>2]|0,c[d+4>>2]=h+ -1,j=+g[b+456>>2],+g[b+444>>2]<j):0)?+g[b+448>>2]<j:0){c[d>>2]=f+2;c[d+4>>2]=h+ -2}if(!(a[b+525>>0]|0)){i=e;return}c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+ -1;i=e;return}function xo(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,R=0.0,U=0.0,W=0.0,X=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0;j=i;i=i+272|0;g[b+504>>2]=0.0;g[b+500>>2]=0.0;a[b+525>>0]=0;a[b+526>>0]=0;if((a[b+552>>0]|0)!=0?(a[b+527>>0]|0)==0:0){ia=+g[b+556>>2];ba=+g[b+560>>2];ja=+g[b+564>>2];ca=+g[b+568>>2];ea=ia*(2.0/(ia*ia+ba*ba+ja*ja+ca*ca));la=ba*(2.0/(ia*ia+ba*ba+ja*ja+ca*ca));fa=ja*(2.0/(ia*ia+ba*ba+ja*ja+ca*ca));no(j+208|0,d,b+300|0);no(j+144|0,e,b+364|0);H=+g[j+144>>2];J=+g[j+148>>2];m=+g[j+152>>2];W=(1.0-(ba*la+ja*fa))*H+(ia*la+ca*fa)*J+(ia*fa-ca*la)*m;X=(ia*la-ca*fa)*H+(1.0-(ia*ea+ja*fa))*J+(ba*fa+ca*ea)*m;Z=(ia*fa+ca*la)*H+(ba*fa-ca*ea)*J+(1.0-(ia*ea+ba*la))*m;K=+g[j+160>>2];L=+g[j+164>>2];l=+g[j+168>>2];_=(1.0-(ba*la+ja*fa))*K+(ia*la+ca*fa)*L+(ia*fa-ca*la)*l;$=(ia*la-ca*fa)*K+(1.0-(ia*ea+ja*fa))*L+(ba*fa+ca*ea)*l;aa=(ia*fa+ca*la)*K+(ba*fa-ca*ea)*L+(1.0-(ia*ea+ba*la))*l;M=+g[j+176>>2];N=+g[j+180>>2];O=+g[j+184>>2];ha=(1.0-(ba*la+ja*fa))*M+(ia*la+ca*fa)*N+(ia*fa-ca*la)*O;ja=(ia*la-ca*fa)*M+(1.0-(ia*ea+ja*fa))*N+(ba*fa+ca*ea)*O;la=(ia*fa+ca*la)*M+(ba*fa-ca*ea)*N+(1.0-(ia*ea+ba*la))*O;ba=+g[j+208>>2];ea=+g[j+224>>2];ia=+g[j+240>>2];ca=+g[j+212>>2];fa=+g[j+228>>2];ka=+g[j+244>>2];da=+g[j+216>>2];ga=+g[j+232>>2];ma=+g[j+248>>2];R=-+g[j+256>>2];U=-+g[j+260>>2];k=-+g[j+264>>2];m=H*0.0+J*0.0+m*0.0+ +g[j+192>>2]+(Z*(da*R+ga*U+ma*k)+(W*(ba*R+ea*U+ia*k)+X*(ca*R+fa*U+ka*k)));l=K*0.0+L*0.0+l*0.0+ +g[j+196>>2]+(aa*(da*R+ga*U+ma*k)+(_*(ba*R+ea*U+ia*k)+$*(ca*R+fa*U+ka*k)));k=M*0.0+N*0.0+O*0.0+ +g[j+200>>2]+(la*(da*R+ga*U+ma*k)+(ha*(ba*R+ea*U+ia*k)+ja*(ca*R+fa*U+ka*k)));g[j+80>>2]=W*ba+X*ca+Z*da;g[j+84>>2]=W*ea+X*fa+Z*ga;g[j+88>>2]=W*ia+X*ka+Z*ma;g[j+92>>2]=0.0;g[j+96>>2]=_*ba+$*ca+aa*da;g[j+100>>2]=_*ea+$*fa+aa*ga;g[j+104>>2]=_*ia+$*ka+aa*ma;g[j+108>>2]=0.0;g[j+112>>2]=ha*ba+ja*ca+la*da;g[j+116>>2]=ha*ea+ja*fa+la*ga;g[j+120>>2]=ha*ia+ja*ka+la*ma;g[j+124>>2]=0.0;g[j+128>>2]=m;g[j+132>>2]=l;g[j+136>>2]=k;g[j+140>>2]=0.0;Hc(j+80|0,j+64|0);k=+g[j+64>>2];l=+g[j+68>>2];m=+g[j+72>>2];if(+P(+(k*k+l*l+m*m))<1.1920928955078125e-7){i=j;return}g[b+472>>2]=0.0;ma=1.0/+Q(+(k*k+l*l+m*m));g[b+460>>2]=k*ma;g[b+464>>2]=l*ma;g[b+468>>2]=m*ma;ma=+g[j+76>>2];ma=ma<-1.0?-1.0:ma;ma=+V(+(ma>1.0?1.0:ma))*2.0;g[b+504>>2]=ma;if(+P(+ma)<1.1920928955078125e-7){i=j;return}a[b+526>>0]=1;i=j;return}Hc(d,j+48|0);Hc(b+300|0,j+32|0);B=+g[j+60>>2];x=+g[j+32>>2];D=+g[j+48>>2];z=+g[j+44>>2];A=+g[j+52>>2];v=+g[j+40>>2];y=+g[j+56>>2];C=+g[j+36>>2];Hc(e,j+16|0);Hc(b+364|0,j);p=+g[j+28>>2];l=+g[j>>2];r=+g[j+16>>2];n=+g[j+12>>2];o=+g[j+20>>2];s=+g[j+8>>2];m=+g[j+24>>2];q=+g[j+4>>2];k=-(p*l+r*n+o*s-m*q);w=-(l*m+(n*o+p*q)-r*s);u=-(p*s+n*m+r*q-l*o);M=(B*x+D*z+A*v-y*C)*(p*n-l*r-o*q-s*m)+(B*z-x*D-A*C-v*y)*k+(B*v+z*y+D*C-x*A)*w-(x*y+(z*A+B*C)-D*v)*u;O=(B*x+D*z+A*v-y*C)*u+((x*y+(z*A+B*C)-D*v)*(p*n-l*r-o*q-s*m)+(B*z-x*D-A*C-v*y)*w)-(B*v+z*y+D*C-x*A)*k;H=(x*y+(z*A+B*C)-D*v)*k+((B*v+z*y+D*C-x*A)*(p*n-l*r-o*q-s*m)+(B*z-x*D-A*C-v*y)*u)-(B*x+D*z+A*v-y*C)*w;R=(B*z-x*D-A*C-v*y)*(p*n-l*r-o*q-s*m)-(B*x+D*z+A*v-y*C)*k-(x*y+(z*A+B*C)-D*v)*w-(B*v+z*y+D*C-x*A)*u;E=-M-O*0.0-H*0.0;G=(H+R*0.0-M*0.0)*-H+(R*(R+O*0.0-H*0.0)+E*-M)-(R*0.0+M*0.0-O)*-O;L=(R*0.0+M*0.0-O)*-M+(R*(H+R*0.0-M*0.0)+E*-O)-(R+O*0.0-H*0.0)*-H;E=(R+O*0.0-H*0.0)*-O+(R*(R*0.0+M*0.0-O)+E*-H)-(H+R*0.0-M*0.0)*-M;K=1.0/+Q(+(E*E+(G*G+L*L)));if(K*E*0.0+(K*L*0.0+K*G)<-.9999998807907104)if(+P(0.0)>.7071067690849304){F=0.0;E=t;N=t;G=0.0}else{F=-0.0;E=1.0;N=0.0;G=0.0}else{ma=+Q(+((K*E*0.0+(K*L*0.0+K*G)+1.0)*2.0));F=(K*E*0.0-K*L*0.0)*(1.0/ma);E=(K*G*0.0-K*E)*(1.0/ma);N=(K*L-K*G*0.0)*(1.0/ma);G=ma*.5}U=1.0/+Q(+(G*G+(N*N+(E*E+F*F))));K=F*U;L=E*U;N=N*U;U=G*U;ma=1.0/+Q(+((R*U-M*-K-O*-L-H*-N)*(R*U-M*-K-O*-L-H*-N)+((O*-K+(H*U+R*-N)-M*-L)*(O*-K+(H*U+R*-N)-M*-L)+((H*-L+(M*U+R*-K)-O*-N)*(H*-L+(M*U+R*-K)-O*-N)+(M*-N+(O*U+R*-L)-H*-K)*(M*-N+(O*U+R*-L)-H*-K)))));G=ma*(H*-L+(M*U+R*-K)-O*-N);F=ma*(M*-N+(O*U+R*-L)-H*-K);E=ma*(O*-K+(H*U+R*-N)-M*-L);H=ma*(R*U-M*-K-O*-L-H*-N);M=+g[b+444>>2];O=+g[b+456>>2];if(M>=O?(J=+g[b+448>>2],J>=O):0){O=U<-1.0?-1.0:U;O=+V(+(O>1.0?1.0:O))*2.0;if(O>1.1920928955078125e-7){U=1.0/+Q(+(N*N+(K*K+L*L)));if(+P(+(L*U))>1.1920928955078125e-7){R=+Q(+((N*U*N*U/(L*U*L*U)+1.0)/(1.0/(J*J)+N*U*N*U/(L*U*L*U)/(M*M))));L=L*U;N=N*U;K=K*U}else{R=M;L=L*U;N=N*U;K=K*U}}else{R=0.0;L=0.0;N=0.0;K=0.0}W=+g[b+428>>2];U=R*W;if(O>U){a[b+526>>0]=1;if(O<R&W<.9999998807907104)R=(O-U)/(R-U);else R=1.0;g[b+528>>2]=R;g[b+504>>2]=O-U;if(+P(+L)>1.1920928955078125e-7){J=+P(+(L*-N/L*(J/M)));if(!(N<-0.0))J=-J;N=1.0/+Q(+(L*L+K*K+J*J));K=K*N;L=L*N;N=-(J*N)}la=-K;ka=-L;ja=-N;ha=(l*m+(n*o+p*q)-r*s)*ja+(p*n-l*r-o*q-s*m)*la-(p*s+n*m+r*q-l*o)*ka;ma=(p*n-l*r-o*q-s*m)*ka+(p*s+n*m+r*q-l*o)*la-(p*l+r*n+o*s-m*q)*ja;ia=(p*n-l*r-o*q-s*m)*ja+(p*l+r*n+o*s-m*q)*ka-(l*m+(n*o+p*q)-r*s)*la;ja=-((p*l+r*n+o*s-m*q)*la)-(l*m+(n*o+p*q)-r*s)*ka-(p*s+n*m+r*q-l*o)*ja;ka=ma*u+((p*n-l*r-o*q-s*m)*ha+ja*k)-ia*w;la=ia*k+((p*n-l*r-o*q-s*m)*ma+ja*w)-ha*u;ma=ha*w+((p*n-l*r-o*q-s*m)*ia+ja*u)-ma*k;g[b+460>>2]=ka;g[b+464>>2]=la;g[b+468>>2]=ma;g[b+472>>2]=0.0;c[b+536>>2]=0;c[b+540>>2]=0;c[b+544>>2]=0;c[b+548>>2]=0;g[b+492>>2]=1.0/(ka*(+g[f>>2]*ka+ +g[f+16>>2]*la+ +g[f+32>>2]*ma)+la*(ka*+g[f+4>>2]+la*+g[f+20>>2]+ma*+g[f+36>>2])+ma*(ka*+g[f+8>>2]+la*+g[f+24>>2]+ma*+g[f+40>>2])+(ka*(ka*+g[h>>2]+la*+g[h+16>>2]+ma*+g[h+32>>2])+la*(ka*+g[h+4>>2]+la*+g[h+20>>2]+ma*+g[h+36>>2])+ma*(ka*+g[h+8>>2]+la*+g[h+24>>2]+ma*+g[h+40>>2])))}}else I=23;a:do if((I|0)==23){N=+g[b+300>>2];R=+g[b+316>>2];K=+g[b+332>>2];Z=+g[d>>2];X=+g[d+4>>2];W=+g[d+8>>2];M=+g[d+16>>2];L=+g[d+20>>2];J=+g[d+24>>2];O=+g[d+32>>2];U=+g[d+36>>2];_=+g[d+40>>2];da=+g[b+304>>2];ca=+g[b+320>>2];ba=+g[b+336>>2];ga=+g[b+308>>2];fa=+g[b+324>>2];ea=+g[b+340>>2];ja=+g[b+364>>2];la=+g[b+380>>2];ha=+g[b+396>>2];$=ja*+g[e>>2]+la*+g[e+4>>2]+ha*+g[e+8>>2];aa=ja*+g[e+16>>2]+la*+g[e+20>>2]+ha*+g[e+24>>2];ha=ja*+g[e+32>>2]+la*+g[e+36>>2]+ha*+g[e+40>>2];la=(N*Z+R*X+K*W)*$+(N*M+R*L+K*J)*aa+(N*O+R*U+K*_)*ha;ja=(Z*da+X*ca+W*ba)*$+(M*da+L*ca+J*ba)*aa+(O*da+U*ca+_*ba)*ha;ia=(Z*ga+X*fa+W*ea)*$+(M*ga+L*fa+J*ea)*aa+(O*ga+U*fa+_*ea)*ha;ka=+g[b+444>>2];ma=+g[b+456>>2];do if(ka<ma){ka=+g[b+448>>2];if(ka<ma){if(+P(+ja)<1.1920928955078125e-7?+P(+ia)<1.1920928955078125e-7:0)break a;a[b+526>>0]=1;g[b+460>>2]=-((N*O+R*U+K*_)*aa-(N*M+R*L+K*J)*ha);g[b+464>>2]=-((N*Z+R*X+K*W)*ha-(N*O+R*U+K*_)*$);g[b+468>>2]=-((N*M+R*L+K*J)*$-(N*Z+R*X+K*W)*aa);g[b+472>>2]=0.0;break a}if(+P(+la)<1.1920928955078125e-7?+P(+ia)<1.1920928955078125e-7:0)break;a[b+526>>0]=1;if(ka>=ma){ja=+Y(+ia,+la);if(ja>ka){la=+S(+ka);ja=0.0;ia=+T(+ka);break}if(ja<-ka){la=+S(+ka);ja=0.0;ia=-+T(+ka)}else ja=0.0}}else{if(+P(+la)<1.1920928955078125e-7?+P(+ja)<1.1920928955078125e-7:0)break;a[b+526>>0]=1;if(ka>=ma){ia=+Y(+ja,+la);if(ia>ka){la=+S(+ka);ja=+T(+ka);ia=0.0;break}if(ia<-ka){la=+S(+ka);ja=-+T(+ka);ia=0.0}else ia=0.0}}while(0);ka=(Z*ga+X*fa+W*ea)*ia+((Z*da+X*ca+W*ba)*ja+(N*Z+R*X+K*W)*la);Z=(M*ga+L*fa+J*ea)*ia+((M*da+L*ca+J*ba)*ja+(N*M+R*L+K*J)*la);ja=(O*ga+U*fa+_*ea)*ia+((O*da+U*ca+_*ba)*ja+(N*O+R*U+K*_)*la);la=1.0/+Q(+(ja*ja+(ka*ka+Z*Z)));g[b+472>>2]=0.0;ma=+Q(+((aa*la*ja-ha*la*Z)*(aa*la*ja-ha*la*Z)+(ha*la*ka-$*la*ja)*(ha*la*ka-$*la*ja)+($*la*Z-aa*la*ka)*($*la*Z-aa*la*ka)));g[b+504>>2]=ma;g[b+460>>2]=-((aa*la*ja-ha*la*Z)*(1.0/ma));g[b+464>>2]=-((ha*la*ka-$*la*ja)*(1.0/ma));g[b+468>>2]=-(($*la*Z-aa*la*ka)*(1.0/ma))}while(0);J=+g[b+452>>2];if(!(J>=0.0)){g[b+512>>2]=0.0;i=j;return}K=H<-1.0?-1.0:H;K=+V(+(K>1.0?1.0:K))*2.0;if(K>3.1415927410125732){H=H>1.0?-1.0:-H;H=+V(+(H>1.0?1.0:H))*2.0;G=-G;F=-F;E=-E}else H=K;g[b+512>>2]=H;if(H>1.1920928955078125e-7){ma=1.0/+Q(+(E*E+(F*F+G*G)));G=G*ma;F=F*ma;E=E*ma}L=+g[b+428>>2];if(H>J*L){a[b+525>>0]=1;K=H-J*L;if(H<J&L<.9999998807907104)H=K/(J-J*L);else H=1.0;g[b+532>>2]=H;g[b+508>>2]=K;la=-G;ka=-F;ja=-E;ha=(l*m+(n*o+p*q)-r*s)*ja+(p*n-l*r-o*q-s*m)*la-(p*s+n*m+r*q-l*o)*ka;ma=(p*n-l*r-o*q-s*m)*ka+(p*s+n*m+r*q-l*o)*la-(p*l+r*n+o*s-m*q)*ja;ia=(p*n-l*r-o*q-s*m)*ja+(p*l+r*n+o*s-m*q)*ka-(l*m+(n*o+p*q)-r*s)*la;ja=-((p*l+r*n+o*s-m*q)*la)-(l*m+(n*o+p*q)-r*s)*ka-(p*s+n*m+r*q-l*o)*ja;ka=ma*u+((p*n-l*r-o*q-s*m)*ha+ja*k)-ia*w;la=ia*k+((p*n-l*r-o*q-s*m)*ma+ja*w)-ha*u;ma=ha*w+((p*n-l*r-o*q-s*m)*ia+ja*u)-ma*k;g[b+476>>2]=ka;g[b+480>>2]=la;g[b+484>>2]=ma;g[b+488>>2]=0.0;g[b+496>>2]=1.0/(ka*(+g[f>>2]*ka+ +g[f+16>>2]*la+ +g[f+32>>2]*ma)+la*(ka*+g[f+4>>2]+la*+g[f+20>>2]+ma*+g[f+36>>2])+ma*(ka*+g[f+8>>2]+la*+g[f+24>>2]+ma*+g[f+40>>2])+(ka*(ka*+g[h>>2]+la*+g[h+16>>2]+ma*+g[h+32>>2])+la*(ka*+g[h+4>>2]+la*+g[h+20>>2]+ma*+g[h+36>>2])+ma*(ka*+g[h+8>>2]+la*+g[h+24>>2]+ma*+g[h+40>>2])))}if(!(a[b+526>>0]|0)){i=j;return}ha=-G;ma=-F;ja=-E;ga=(x*y+(z*A+B*C)-D*v)*ja+(B*z-x*D-A*C-v*y)*ha-(B*v+z*y+D*C-x*A)*ma;la=(B*z-x*D-A*C-v*y)*ma+(B*v+z*y+D*C-x*A)*ha-(B*x+D*z+A*v-y*C)*ja;ia=(B*z-x*D-A*C-v*y)*ja+(B*x+D*z+A*v-y*C)*ma-(x*y+(z*A+B*C)-D*v)*ha;ja=-((B*x+D*z+A*v-y*C)*ha)-(x*y+(z*A+B*C)-D*v)*ma-(B*v+z*y+D*C-x*A)*ja;ma=-(B*x+D*z+A*v-y*C);ha=-(x*y+(z*A+B*C)-D*v);ka=-(B*v+z*y+D*C-x*A);g[b+536>>2]=la*ka+((B*z-x*D-A*C-v*y)*ga+ja*ma)-ia*ha;g[b+540>>2]=ia*ma+((B*z-x*D-A*C-v*y)*la+ja*ha)-ga*ka;g[b+544>>2]=ga*ha+((B*z-x*D-A*C-v*y)*ia+ja*ka)-la*ma;g[b+548>>2]=0.0;i=j;return}function yo(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0;e=i;i=i+64|0;k=c[b+28>>2]|0;o=c[b+32>>2]|0;xo(b,k+4|0,o+4|0,k+264|0,o+264|0);l=c[d+8>>2]|0;g[l>>2]=1.0;m=c[d+24>>2]|0;g[l+(m+1<<2)>>2]=1.0;g[l+((m<<1)+2<<2)>>2]=1.0;q=+g[b+348>>2];w=+g[b+352>>2];t=+g[b+356>>2];u=+g[k+4>>2]*q+ +g[k+8>>2]*w+ +g[k+12>>2]*t;r=q*+g[k+20>>2]+w*+g[k+24>>2]+t*+g[k+28>>2];t=q*+g[k+36>>2]+w*+g[k+40>>2]+t*+g[k+44>>2];l=c[d+12>>2]|0;g[l>>2]=0.0;g[l+4>>2]=t;g[l+8>>2]=-r;g[l+12>>2]=0.0;g[l+(m<<2)>>2]=-t;g[l+(m+1<<2)>>2]=0.0;g[l+(m+2<<2)>>2]=u;g[l+(m+3<<2)>>2]=0.0;g[l+(m<<1<<2)>>2]=r;g[l+((m<<1|1)<<2)>>2]=-u;g[l+((m<<1)+2<<2)>>2]=0.0;g[l+((m<<1)+3<<2)>>2]=0.0;l=c[d+16>>2]|0;g[l>>2]=-1.0;g[l+(m+1<<2)>>2]=-1.0;g[l+((m<<1)+2<<2)>>2]=-1.0;w=+g[b+412>>2];q=+g[b+416>>2];p=+g[b+420>>2];v=+g[o+4>>2]*w+ +g[o+8>>2]*q+ +g[o+12>>2]*p;s=w*+g[o+20>>2]+q*+g[o+24>>2]+p*+g[o+28>>2];p=w*+g[o+36>>2]+q*+g[o+40>>2]+p*+g[o+44>>2];l=c[d+20>>2]|0;g[l>>2]=0.0;g[l+4>>2]=-p;g[l+8>>2]=s;g[l+12>>2]=0.0;g[l+(m<<2)>>2]=p;g[l+(m+1<<2)>>2]=0.0;g[l+(m+2<<2)>>2]=-v;g[l+(m+3<<2)>>2]=0.0;g[l+(m<<1<<2)>>2]=-s;g[l+((m<<1|1)<<2)>>2]=v;g[l+((m<<1)+2<<2)>>2]=0.0;g[l+((m<<1)+3<<2)>>2]=0.0;m=c[b+592>>2]|0;q=+g[((m&2|0)==0?d+4|0:b+600|0)>>2]*+g[d>>2];f=c[d+24>>2]|0;n=c[d+28>>2]|0;j=c[d+36>>2]|0;h=c[d+40>>2]|0;g[n>>2]=q*(v+ +g[o+52>>2]-u- +g[k+52>>2]);g[j>>2]=-3.4028234663852886e+38;g[h>>2]=3.4028234663852886e+38;if(!(m&1)){g[n+(f<<2)>>2]=q*(s+ +g[o+56>>2]-r- +g[k+56>>2]);g[j+(f<<2)>>2]=-3.4028234663852886e+38;g[h+(f<<2)>>2]=3.4028234663852886e+38;g[n+(f<<1<<2)>>2]=q*(p+ +g[o+60>>2]-t- +g[k+60>>2]);g[j+(f<<1<<2)>>2]=-3.4028234663852886e+38;g[h+(f<<1<<2)>>2]=3.4028234663852886e+38}else{x=c[d+32>>2]|0;g[x>>2]=+g[b+596>>2];g[n+(f<<2)>>2]=q*(s+ +g[o+56>>2]-r- +g[k+56>>2]);g[j+(f<<2)>>2]=-3.4028234663852886e+38;g[h+(f<<2)>>2]=3.4028234663852886e+38;g[x+(f<<2)>>2]=+g[b+596>>2];g[n+(f<<1<<2)>>2]=q*(p+ +g[o+60>>2]-t- +g[k+60>>2]);g[j+(f<<1<<2)>>2]=-3.4028234663852886e+38;g[h+(f<<1<<2)>>2]=3.4028234663852886e+38;g[x+(f<<1<<2)>>2]=+g[b+596>>2]}do if(!(a[b+526>>0]|0))f=f*3|0;else{o=c[d+12>>2]|0;w=+g[b+456>>2];if(+g[b+444>>2]<w?+g[b+448>>2]<w:0){no(e,k+4|0,b+300|0);q=+g[e+4>>2];r=+g[e+20>>2];s=+g[e+36>>2];u=+g[e+8>>2];v=+g[e+24>>2];w=+g[e+40>>2];m=c[d+24>>2]|0;x=m+(f*3|0)|0;g[o+(f*3<<2)>>2]=q;g[o+((f*3|0)+1<<2)>>2]=r;g[o+((f*3|0)+2<<2)>>2]=s;g[o+(x<<2)>>2]=u;g[o+(x+1<<2)>>2]=v;g[o+(x+2<<2)>>2]=w;g[l+(f*3<<2)>>2]=-q;g[l+((f*3|0)+1<<2)>>2]=-r;g[l+((f*3|0)+2<<2)>>2]=-s;g[l+(x<<2)>>2]=-u;g[l+(x+1<<2)>>2]=-v;g[l+(x+2<<2)>>2]=-w;t=+g[d>>2]*+g[b+436>>2];n=c[d+28>>2]|0;g[n+(f*3<<2)>>2]=t*(q*+g[b+460>>2]+r*+g[b+464>>2]+s*+g[b+468>>2]);g[n+(x<<2)>>2]=t*(u*+g[b+460>>2]+v*+g[b+464>>2]+w*+g[b+468>>2]);j=c[d+36>>2]|0;g[j+(f*3<<2)>>2]=-3.4028234663852886e+38;h=c[d+40>>2]|0;g[h+(f*3<<2)>>2]=3.4028234663852886e+38;g[j+(x<<2)>>2]=-3.4028234663852886e+38;g[h+(x<<2)>>2]=3.4028234663852886e+38;f=m+x|0;break}w=+g[b+436>>2];u=w*+g[b+460>>2]*w;v=w*w*+g[b+464>>2];w=w*w*+g[b+468>>2];g[o+(f*3<<2)>>2]=u;g[o+((f*3|0)+1<<2)>>2]=v;g[o+((f*3|0)+2<<2)>>2]=w;g[l+(f*3<<2)>>2]=-u;g[l+((f*3|0)+1<<2)>>2]=-v;g[l+((f*3|0)+2<<2)>>2]=-w;g[n+(f*3<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+504>>2];if(m&4)g[(c[d+32>>2]|0)+(f*3<<2)>>2]=+g[b+604>>2];g[j+(f*3<<2)>>2]=0.0;g[h+(f*3<<2)>>2]=3.4028234663852886e+38;f=f+(f*3|0)|0}while(0);if(!(a[b+525>>0]|0)){i=e;return}w=+g[b+436>>2];u=w*+g[b+476>>2]*w;v=w*w*+g[b+480>>2];w=w*w*+g[b+484>>2];l=c[d+12>>2]|0;o=c[d+20>>2]|0;g[l+(f<<2)>>2]=u;m=f+1|0;g[l+(m<<2)>>2]=v;x=f+2|0;g[l+(x<<2)>>2]=w;g[o+(f<<2)>>2]=-u;g[o+(m<<2)>>2]=-v;g[o+(x<<2)>>2]=-w;g[n+(f<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+508>>2];if(c[b+592>>2]&4)g[(c[d+32>>2]|0)+(f<<2)>>2]=+g[b+604>>2];if(!(+g[b+452>>2]>0.0)){g[j+(f<<2)>>2]=-3.4028234663852886e+38;g[h+(f<<2)>>2]=3.4028234663852886e+38;i=e;return}d=j+(f<<2)|0;if(+g[b+508>>2]>0.0){g[d>>2]=0.0;g[h+(f<<2)>>2]=3.4028234663852886e+38;i=e;return}else{g[d>>2]=-3.4028234663852886e+38;g[h+(f<<2)>>2]=0.0;i=e;return}}function zo(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0;d=i;i=i+176|0;if(!(a[b+527>>0]|0)){i=d;return}g[b+36>>2]=0.0;g[b+520>>2]=0.0;g[b+516>>2]=0.0;c[b+576>>2]=0;c[b+580>>2]=0;c[b+584>>2]=0;c[b+588>>2]=0;a:do if(!(a[b+524>>0]|0)){L=c[b+28>>2]|0;A=+g[b+348>>2];z=+g[b+352>>2];f=+g[b+356>>2];e=A*+g[L+20>>2]+z*+g[L+24>>2]+f*+g[L+28>>2]+ +g[L+56>>2];y=c[b+32>>2]|0;j=+g[b+412>>2];k=+g[y+4>>2];l=+g[b+416>>2];m=+g[y+8>>2];n=+g[b+420>>2];x=+g[y+12>>2];q=+g[y+20>>2];r=+g[y+24>>2];s=+g[y+28>>2];u=+g[y+36>>2];v=+g[y+40>>2];w=+g[y+44>>2];p=+g[y+52>>2];t=+g[y+56>>2];o=+g[y+60>>2];B=j*q+l*r+n*s+t-e;h=A*+g[L+4>>2]+z*+g[L+8>>2]+f*+g[L+12>>2]+ +g[L+52>>2];f=A*+g[L+36>>2]+z*+g[L+40>>2]+f*+g[L+44>>2]+ +g[L+60>>2];z=j*k+l*m+n*x+p-h;A=j*u+l*v+n*w+o-f;if(z*z+B*B+A*A>1.1920928955078125e-7){K=1.0/+Q(+(z*z+B*B+A*A));g[d+128>>2]=z*K;g[d+132>>2]=B*K;g[d+136>>2]=A*K;g[d+140>>2]=0.0;A=A*K;B=B*K;z=z*K}else{g[d+128>>2]=1.0;g[d+132>>2]=0.0;g[d+136>>2]=0.0;g[d+140>>2]=0.0;A=0.0;B=0.0;z=1.0}if(+P(+A)>.7071067690849304){H=A*A+B*B;I=1.0/+Q(+H);g[d+144>>2]=0.0;K=-(I*A);g[d+148>>2]=K;J=I*B;g[d+152>>2]=J;g[d+160>>2]=H*I;g[d+164>>2]=-(z*J);g[d+168>>2]=z*K}else{J=z*z+B*B;K=1.0/+Q(+J);I=-(B*K);g[d+144>>2]=I;H=K*z;g[d+148>>2]=H;g[d+152>>2]=0.0;g[d+160>>2]=-(A*H);g[d+164>>2]=A*I;g[d+168>>2]=J*K}F=k;B=q;C=u;D=m;E=r;I=v;A=x;K=s;J=w;z=p;H=t;G=o;L=0;while(1){M=c[b+28>>2]|0;g[d+80>>2]=+g[M+4>>2];g[d+84>>2]=+g[M+20>>2];g[d+88>>2]=+g[M+36>>2];g[d+92>>2]=0.0;g[d+96>>2]=+g[M+8>>2];g[d+100>>2]=+g[M+24>>2];g[d+104>>2]=+g[M+40>>2];g[d+108>>2]=0.0;g[d+112>>2]=+g[M+12>>2];g[d+116>>2]=+g[M+28>>2];g[d+120>>2]=+g[M+44>>2];g[d+124>>2]=0.0;g[d+32>>2]=F;g[d+36>>2]=B;g[d+40>>2]=C;g[d+44>>2]=0.0;g[d+48>>2]=D;g[d+52>>2]=E;g[d+56>>2]=I;g[d+60>>2]=0.0;g[d+64>>2]=A;g[d+68>>2]=K;g[d+72>>2]=J;g[d+76>>2]=0.0;J=e- +g[M+56>>2];K=f- +g[M+60>>2];g[d+16>>2]=h- +g[M+52>>2];g[d+20>>2]=J;g[d+24>>2]=K;g[d+28>>2]=0.0;g[d>>2]=j*k+l*m+n*x+p-z;g[d+4>>2]=j*q+l*r+n*s+t-H;g[d+8>>2]=j*u+l*v+n*w+o-G;g[d+12>>2]=0.0;Mo(b+(L*84|0)+48|0,d+80|0,d+32|0,d+16|0,d,d+128+(L<<4)|0,M+396|0,+g[M+344>>2],y+396|0,+g[y+344>>2]);L=L+1|0;if((L|0)==3){y=b+32|0;break a}y=c[b+32>>2]|0;F=+g[y+4>>2];B=+g[y+20>>2];C=+g[y+36>>2];D=+g[y+8>>2];E=+g[y+24>>2];I=+g[y+40>>2];A=+g[y+12>>2];K=+g[y+28>>2];J=+g[y+44>>2];z=+g[y+52>>2];H=+g[y+56>>2];G=+g[y+60>>2]}}else y=b+32|0;while(0);L=c[b+28>>2]|0;M=c[y>>2]|0;xo(b,L+4|0,M+4|0,L+264|0,M+264|0);i=d;return}function Ao(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0,M=0,N=0,O=0,P=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0;h=i;i=i+448|0;if(!(a[b+527>>0]|0)){i=h;return}O=c[b+28>>2]|0;I=+g[b+348>>2];E=+g[b+352>>2];F=+g[b+356>>2];C=+g[O+52>>2];D=I*+g[O+4>>2]+E*+g[O+8>>2]+F*+g[O+12>>2]+C;z=+g[O+56>>2];B=I*+g[O+20>>2]+E*+g[O+24>>2]+F*+g[O+28>>2]+z;p=+g[O+60>>2];F=I*+g[O+36>>2]+E*+g[O+40>>2]+F*+g[O+44>>2]+p;O=c[b+32>>2]|0;E=+g[b+412>>2];I=+g[b+416>>2];y=+g[b+420>>2];w=+g[O+52>>2];v=E*+g[O+4>>2]+I*+g[O+8>>2]+y*+g[O+12>>2]+w;G=+g[O+56>>2];H=E*+g[O+20>>2]+I*+g[O+24>>2]+y*+g[O+28>>2]+G;u=+g[O+60>>2];y=E*+g[O+36>>2]+I*+g[O+40>>2]+y*+g[O+44>>2]+u;if(!(a[b+524>>0]|0)){s=+g[d+192>>2]+ +g[d+80>>2];t=+g[d+196>>2]+ +g[d+84>>2];r=+g[d+200>>2]+ +g[d+88>>2];I=+g[e+192>>2]+ +g[e+80>>2];E=+g[e+196>>2]+ +g[e+84>>2];A=+g[e+200>>2]+ +g[e+88>>2];x=+g[d+176>>2]+ +g[d+64>>2]+((F-p)*t-(B-z)*r)-(+g[e+176>>2]+ +g[e+64>>2]+((y-u)*E-(H-G)*A));A=+g[d+180>>2]+ +g[d+68>>2]+((D-C)*r-(F-p)*s)-(+g[e+180>>2]+ +g[e+68>>2]+((v-w)*A-(y-u)*I));E=+g[d+184>>2]+ +g[d+72>>2]+((B-z)*s-(D-C)*t)-(+g[e+184>>2]+ +g[e+72>>2]+((H-G)*I-(v-w)*E));n=c[d+240>>2]|0;j=0;do{q=1.0/+g[b+(j*84|0)+128>>2];m=b+(j*84|0)+48|0;s=+g[m>>2];k=b+(j*84|0)+52|0;r=+g[k>>2];l=b+(j*84|0)+56|0;t=+g[l>>2];t=q*(((D-v)*s+(B-H)*r+(F-y)*t)*-.30000001192092896/f)-q*(x*s+A*r+E*t);g[b+36>>2]=+g[b+36>>2]+t;r=+g[l>>2];s=+g[k>>2];q=+g[m>>2];o=c[b+28>>2]|0;I=+g[o+344>>2];if(n){S=((F-p)*q-(D-C)*r)*+g[o+300>>2]+((B-z)*r-(F-p)*s)*+g[o+296>>2]+((D-C)*s-(B-z)*q)*+g[o+304>>2];P=((F-p)*q-(D-C)*r)*+g[o+284>>2]+((B-z)*r-(F-p)*s)*+g[o+280>>2]+((D-C)*s-(B-z)*q)*+g[o+288>>2];R=((F-p)*q-(D-C)*r)*+g[o+268>>2]+((B-z)*r-(F-p)*s)*+g[o+264>>2]+((D-C)*s-(B-z)*q)*+g[o+272>>2];U=t*s*I*+g[d+116>>2];T=t*r*I*+g[d+120>>2];g[d+64>>2]=t*q*I*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];P=P*t*+g[d+100>>2];I=S*t*+g[d+104>>2];g[d+80>>2]=R*t*+g[d+96>>2]+ +g[d+80>>2];g[d+84>>2]=P+ +g[d+84>>2];g[d+88>>2]=I+ +g[d+88>>2]}o=c[b+32>>2]|0;I=+g[o+344>>2];if(c[e+240>>2]|0){U=((y-u)*q-(v-w)*r)*+g[o+300>>2]+((H-G)*r-(y-u)*s)*+g[o+296>>2]+((v-w)*s-(H-G)*q)*+g[o+304>>2];T=((y-u)*q-(v-w)*r)*+g[o+284>>2]+((H-G)*r-(y-u)*s)*+g[o+280>>2]+((v-w)*s-(H-G)*q)*+g[o+288>>2];S=((y-u)*q-(v-w)*r)*+g[o+268>>2]+((H-G)*r-(y-u)*s)*+g[o+264>>2]+((v-w)*s-(H-G)*q)*+g[o+272>>2];P=I*+g[k>>2]*-t*+g[e+116>>2];R=I*+g[l>>2]*-t*+g[e+120>>2];g[e+64>>2]=+g[e+112>>2]*I*+g[m>>2]*-t+ +g[e+64>>2];g[e+68>>2]=P+ +g[e+68>>2];g[e+72>>2]=R+ +g[e+72>>2];T=T*+g[e+100>>2]*-t;U=U*+g[e+104>>2]*-t;g[e+80>>2]=S*+g[e+96>>2]*-t+ +g[e+80>>2];g[e+84>>2]=T+ +g[e+84>>2];g[e+88>>2]=U+ +g[e+88>>2]}j=j+1|0}while((j|0)!=3)}do if(!(a[b+552>>0]|0)){q=+g[b+440>>2];if(!(q>1.1920928955078125e-7)){n=d+80|0;N=d+196|0;m=d+84|0;M=d+200|0;o=d+88|0;L=e+192|0;k=e+80|0;K=e+196|0;l=e+84|0;J=e+200|0;j=e+88|0;O=d+192|0;break}z=+g[e+192>>2]+ +g[e+80>>2]-(+g[d+192>>2]+ +g[d+80>>2]);B=+g[e+196>>2]+ +g[e+84>>2]-(+g[d+196>>2]+ +g[d+84>>2]);A=+g[e+200>>2]+ +g[e+88>>2]-(+g[d+200>>2]+ +g[d+88>>2]);if(z*z+B*B+A*A>1.1920928955078125e-7){U=1.0/+Q(+(z*z+B*B+A*A));j=c[b+28>>2]|0;p=+g[j+264>>2];x=+g[j+280>>2];u=+g[j+296>>2];s=+g[j+268>>2];y=+g[j+284>>2];v=+g[j+300>>2];r=+g[j+272>>2];w=+g[j+288>>2];t=+g[j+304>>2];j=c[b+32>>2]|0;U=q*(1.0/(z*U*(z*U*p+B*U*x+A*U*u)+B*U*(z*U*s+B*U*y+A*U*v)+A*U*(z*U*r+B*U*w+A*U*t)+(z*U*(z*U*+g[j+264>>2]+B*U*+g[j+280>>2]+A*U*+g[j+296>>2])+B*U*(z*U*+g[j+268>>2]+B*U*+g[j+284>>2]+A*U*+g[j+300>>2])+A*U*(z*U*+g[j+272>>2]+B*U*+g[j+288>>2]+A*U*+g[j+304>>2]))));q=+Q(+(A*U*A*U+(z*U*z*U+B*U*B*U)));z=1.0/q*z*U;B=1.0/q*B*U;A=1.0/q*A*U;if(c[d+240>>2]|0){U=q*0.0*+g[d+116>>2];T=q*0.0*+g[d+120>>2];g[d+64>>2]=q*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];T=(B*y+z*x+A*w)*q*+g[d+100>>2];U=(B*v+z*u+A*t)*q*+g[d+104>>2];g[d+80>>2]=(B*s+z*p+A*r)*q*+g[d+96>>2]+ +g[d+80>>2];g[d+84>>2]=T+ +g[d+84>>2];g[d+88>>2]=U+ +g[d+88>>2];j=c[b+32>>2]|0}if(c[e+240>>2]|0){U=B*+g[j+300>>2]+z*+g[j+296>>2]+A*+g[j+304>>2];T=B*+g[j+284>>2]+z*+g[j+280>>2]+A*+g[j+288>>2];S=B*+g[j+268>>2]+z*+g[j+264>>2]+A*+g[j+272>>2];P=q*-0.0*+g[e+116>>2];R=q*-0.0*+g[e+120>>2];g[e+64>>2]=q*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=P+ +g[e+68>>2];g[e+72>>2]=R+ +g[e+72>>2];T=T*+g[e+100>>2]*-q;U=U*+g[e+104>>2]*-q;g[e+80>>2]=S*+g[e+96>>2]*-q+ +g[e+80>>2];g[e+84>>2]=T+ +g[e+84>>2];g[e+88>>2]=U+ +g[e+88>>2];n=d+80|0;N=d+196|0;m=d+84|0;M=d+200|0;o=d+88|0;L=e+192|0;k=e+80|0;K=e+196|0;l=e+84|0;J=e+200|0;j=e+88|0;O=d+192|0}else{n=d+80|0;N=d+196|0;m=d+84|0;M=d+200|0;o=d+88|0;L=e+192|0;k=e+80|0;K=e+196|0;l=e+84|0;J=e+200|0;j=e+88|0;O=d+192|0}}else{n=d+80|0;N=d+196|0;m=d+84|0;M=d+200|0;o=d+88|0;L=e+192|0;k=e+80|0;K=e+196|0;l=e+84|0;J=e+200|0;j=e+88|0;O=d+192|0}}else{N=c[b+28>>2]|0;c[h+352>>2]=c[N+4>>2];c[h+356>>2]=c[N+8>>2];c[h+360>>2]=c[N+12>>2];c[h+364>>2]=c[N+16>>2];c[h+368>>2]=c[N+20>>2];c[h+372>>2]=c[N+24>>2];c[h+376>>2]=c[N+28>>2];c[h+380>>2]=c[N+32>>2];c[h+384>>2]=c[N+36>>2];c[h+388>>2]=c[N+40>>2];c[h+392>>2]=c[N+44>>2];c[h+396>>2]=c[N+48>>2];c[h+400>>2]=c[N+52>>2];c[h+404>>2]=c[N+56>>2];c[h+408>>2]=c[N+60>>2];c[h+412>>2]=c[N+64>>2];N=c[b+32>>2]|0;c[h+288>>2]=c[N+4>>2];c[h+292>>2]=c[N+8>>2];c[h+296>>2]=c[N+12>>2];c[h+300>>2]=c[N+16>>2];c[h+304>>2]=c[N+20>>2];c[h+308>>2]=c[N+24>>2];c[h+312>>2]=c[N+28>>2];c[h+316>>2]=c[N+32>>2];c[h+320>>2]=c[N+36>>2];c[h+324>>2]=c[N+40>>2];c[h+328>>2]=c[N+44>>2];c[h+332>>2]=c[N+48>>2];c[h+336>>2]=c[N+52>>2];c[h+340>>2]=c[N+56>>2];c[h+344>>2]=c[N+60>>2];c[h+348>>2]=c[N+64>>2];S=+g[d+196>>2]+ +g[d+84>>2];C=+g[d+200>>2]+ +g[d+88>>2];g[h+272>>2]=+g[d+192>>2]+ +g[d+80>>2];g[h+276>>2]=S;g[h+280>>2]=C;g[h+284>>2]=0.0;C=+g[e+196>>2]+ +g[e+84>>2];S=+g[e+200>>2]+ +g[e+88>>2];g[h+256>>2]=+g[e+192>>2]+ +g[e+80>>2];g[h+260>>2]=C;g[h+264>>2]=S;g[h+268>>2]=0.0;g[h+192>>2]=1.0;N=h+196|0;c[N+0>>2]=0;c[N+4>>2]=0;c[N+8>>2]=0;c[N+12>>2]=0;g[h+212>>2]=1.0;O=h+216|0;c[O+0>>2]=0;c[O+4>>2]=0;c[O+8>>2]=0;c[O+12>>2]=0;g[h+232>>2]=1.0;L=h+236|0;c[L+0>>2]=0;c[L+4>>2]=0;c[L+8>>2]=0;c[L+12>>2]=0;c[L+16>>2]=0;Bo(h+352|0,0.0,0.0,0.0,h+272|0,f,h+192|0);g[h+128>>2]=1.0;L=h+132|0;c[L+0>>2]=0;c[L+4>>2]=0;c[L+8>>2]=0;c[L+12>>2]=0;g[h+148>>2]=1.0;M=h+152|0;c[M+0>>2]=0;c[M+4>>2]=0;c[M+8>>2]=0;c[M+12>>2]=0;g[h+168>>2]=1.0;K=h+172|0;c[K+0>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[K+16>>2]=0;Bo(h+288|0,0.0,0.0,0.0,h+256|0,f,h+128|0);S=+g[b+556>>2];C=+g[b+560>>2];T=+g[b+564>>2];D=+g[b+568>>2];G=S*(2.0/(S*S+C*C+T*T+D*D));r=C*(2.0/(S*S+C*C+T*T+D*D));H=T*(2.0/(S*S+C*C+T*T+D*D));W=+g[b+364>>2];V=+g[b+368>>2];Z=+g[b+372>>2];w=(S*H-D*r)*Z+(V*(S*r+D*H)+W*(1.0-(C*r+T*H)));x=Z*(C*H+D*G)+(W*(S*r-D*H)+V*(1.0-(S*G+T*H)));y=W*(S*H+D*r)+V*(C*H-D*G)+Z*(1.0-(S*G+C*r));v=+g[b+380>>2];F=+g[b+384>>2];p=+g[b+388>>2];z=(1.0-(C*r+T*H))*v+(S*r+D*H)*F+(S*H-D*r)*p;A=(S*r-D*H)*v+(1.0-(S*G+T*H))*F+(C*H+D*G)*p;B=(S*H+D*r)*v+(C*H-D*G)*F+(1.0-(S*G+C*r))*p;P=+g[b+396>>2];q=+g[b+400>>2];s=+g[b+404>>2];R=(1.0-(C*r+T*H))*P+(S*r+D*H)*q+(S*H-D*r)*s;T=(S*r-D*H)*P+(1.0-(S*G+T*H))*q+(C*H+D*G)*s;r=(S*H+D*r)*P+(C*H-D*G)*q+(1.0-(S*G+C*r))*s;C=+g[b+300>>2];G=+g[b+316>>2];S=+g[b+332>>2];D=+g[b+304>>2];H=+g[b+320>>2];U=+g[b+336>>2];E=+g[b+308>>2];I=+g[b+324>>2];t=+g[b+340>>2];u=-+g[b+348>>2];aa=-+g[b+352>>2];Y=-+g[b+356>>2];Z=W*0.0+V*0.0+Z*0.0+ +g[b+412>>2]+(y*(E*u+I*aa+t*Y)+(w*(C*u+G*aa+S*Y)+x*(D*u+H*aa+U*Y)));p=v*0.0+F*0.0+p*0.0+ +g[b+416>>2]+(B*(E*u+I*aa+t*Y)+(z*(C*u+G*aa+S*Y)+A*(D*u+H*aa+U*Y)));Y=P*0.0+q*0.0+s*0.0+ +g[b+420>>2]+(r*(E*u+I*aa+t*Y)+(R*(C*u+G*aa+S*Y)+T*(D*u+H*aa+U*Y)));aa=+g[h+128>>2];u=+g[L>>2];s=+g[h+136>>2];q=+g[h+144>>2];P=+g[h+148>>2];F=+g[M>>2];v=+g[h+160>>2];V=+g[h+164>>2];W=+g[h+168>>2];X=s*Y+(aa*Z+u*p)+ +g[h+176>>2];_=Y*F+(q*Z+P*p)+ +g[h+180>>2];$=Z*v+p*V+Y*W+ +g[h+184>>2];g[h+64>>2]=(w*C+x*D+y*E)*aa+(z*C+A*D+B*E)*u+(R*C+T*D+r*E)*s;g[h+68>>2]=(w*G+x*H+y*I)*aa+(z*G+A*H+B*I)*u+(R*G+T*H+r*I)*s;g[h+72>>2]=(w*S+x*U+y*t)*aa+(z*S+A*U+B*t)*u+(R*S+T*U+r*t)*s;g[h+76>>2]=0.0;g[h+80>>2]=(w*C+x*D+y*E)*q+(z*C+A*D+B*E)*P+(R*C+T*D+r*E)*F;g[h+84>>2]=(w*G+x*H+y*I)*q+(z*G+A*H+B*I)*P+(R*G+T*H+r*I)*F;g[h+88>>2]=(w*S+x*U+y*t)*q+(z*S+A*U+B*t)*P+(R*S+T*U+r*t)*F;g[h+92>>2]=0.0;g[h+96>>2]=(w*C+x*D+y*E)*v+(z*C+A*D+B*E)*V+(R*C+T*D+r*E)*W;g[h+100>>2]=(w*G+x*H+y*I)*v+(z*G+A*H+B*I)*V+(R*G+T*H+r*I)*W;g[h+104>>2]=(w*S+x*U+y*t)*v+(z*S+A*U+B*t)*V+(R*S+T*U+r*t)*W;g[h+108>>2]=0.0;g[h+112>>2]=X;g[h+116>>2]=_;g[h+120>>2]=$;g[h+124>>2]=0.0;$=(R*C+T*D+r*E)*-Y+((w*C+x*D+y*E)*-Z+(z*C+A*D+B*E)*-p);_=(R*G+T*H+r*I)*-Y+((w*G+x*H+y*I)*-Z+(z*G+A*H+B*I)*-p);p=(R*S+T*U+r*t)*-Y+((w*S+x*U+y*t)*-Z+(z*S+A*U+B*t)*-p);Z=+g[h+192>>2];Y=+g[N>>2];X=+g[h+200>>2];W=+g[h+208>>2];V=+g[h+212>>2];v=+g[O>>2];F=+g[h+224>>2];P=+g[h+228>>2];q=+g[h+232>>2];s=$*Z+_*Y+p*X+ +g[h+240>>2];u=$*W+_*V+p*v+ +g[h+244>>2];p=$*F+_*P+p*q+ +g[h+248>>2];g[h>>2]=(w*C+x*D+y*E)*Z+(w*G+x*H+y*I)*Y+(w*S+x*U+y*t)*X;g[h+4>>2]=(z*C+A*D+B*E)*Z+(z*G+A*H+B*I)*Y+(z*S+A*U+B*t)*X;g[h+8>>2]=(R*C+T*D+r*E)*Z+(R*G+T*H+r*I)*Y+(R*S+T*U+r*t)*X;g[h+12>>2]=0.0;g[h+16>>2]=(w*C+x*D+y*E)*W+(w*G+x*H+y*I)*V+(w*S+x*U+y*t)*v;g[h+20>>2]=(z*C+A*D+B*E)*W+(z*G+A*H+B*I)*V+(z*S+A*U+B*t)*v;g[h+24>>2]=(R*C+T*D+r*E)*W+(R*G+T*H+r*I)*V+(R*S+T*U+r*t)*v;g[h+28>>2]=0.0;g[h+32>>2]=(w*C+x*D+y*E)*F+(w*G+x*H+y*I)*P+(w*S+x*U+y*t)*q;g[h+36>>2]=(z*C+A*D+B*E)*F+(z*G+A*H+B*I)*P+(z*S+A*U+B*t)*q;g[h+40>>2]=(R*C+T*D+r*E)*F+(R*G+T*H+r*I)*P+(R*S+T*U+r*t)*q;g[h+44>>2]=0.0;g[h+48>>2]=s;g[h+52>>2]=u;g[h+56>>2]=p;g[h+60>>2]=0.0;Lo(h+352|0,h+64|0,h+424|0,h+416|0);p=+g[h+416>>2];u=1.0/f*+g[h+424>>2]*p;s=1.0/f*p*+g[h+428>>2];p=1.0/f*p*+g[h+432>>2];Lo(h+288|0,h,h+424|0,h+416|0);q=+g[h+416>>2];u=u- +g[h+272>>2];s=s- +g[h+276>>2];p=p- +g[h+280>>2];t=1.0/f*+g[h+424>>2]*q- +g[h+256>>2];r=1.0/f*q*+g[h+428>>2]- +g[h+260>>2];q=1.0/f*q*+g[h+432>>2]- +g[h+264>>2];if(u*u+s*s+p*p>1.1920928955078125e-7){x=1.0/+Q(+(u*u+s*s+p*p));O=c[b+28>>2]|0;A=u*x*(u*x*+g[O+264>>2]+s*x*+g[O+280>>2]+p*x*+g[O+296>>2])+s*x*(u*x*+g[O+268>>2]+s*x*+g[O+284>>2]+p*x*+g[O+300>>2])+p*x*(u*x*+g[O+272>>2]+s*x*+g[O+288>>2]+p*x*+g[O+304>>2]);v=u*x;y=s*x;x=p*x}else{A=0.0;v=0.0;y=0.0;x=0.0}if(t*t+r*r+q*q>1.1920928955078125e-7){w=1.0/+Q(+(t*t+r*r+q*q));O=c[b+32>>2]|0;z=t*w*(t*w*+g[O+264>>2]+r*w*+g[O+280>>2]+q*w*+g[O+296>>2])+r*w*(t*w*+g[O+268>>2]+r*w*+g[O+284>>2]+q*w*+g[O+300>>2])+q*w*(t*w*+g[O+272>>2]+r*w*+g[O+288>>2]+q*w*+g[O+304>>2]);C=t*w;B=r*w;w=q*w}else{z=0.0;C=0.0;B=0.0;w=0.0}v=v*A+C*z;y=y*A+B*z;x=x*A+w*z;if(x*x+(v*v+y*y)>1.1920928955078125e-7){aa=1.0/+Q(+(x*x+(v*v+y*y)));k=c[b+28>>2]|0;w=v*aa*(v*aa*+g[k+264>>2]+y*aa*+g[k+280>>2]+x*aa*+g[k+296>>2])+y*aa*(v*aa*+g[k+268>>2]+y*aa*+g[k+284>>2]+x*aa*+g[k+300>>2])+x*aa*(v*aa*+g[k+272>>2]+y*aa*+g[k+288>>2]+x*aa*+g[k+304>>2]);j=c[b+32>>2]|0;v=v*aa*(v*aa*+g[j+264>>2]+y*aa*+g[j+280>>2]+x*aa*+g[j+296>>2])+y*aa*(v*aa*+g[j+268>>2]+y*aa*+g[j+284>>2]+x*aa*+g[j+300>>2])+x*aa*(v*aa*+g[j+272>>2]+y*aa*+g[j+288>>2]+x*aa*+g[j+304>>2]);t=1.0/((w+v)*(w+v))*(u*w-t*v);r=1.0/((w+v)*(w+v))*(s*w-r*v);p=1.0/((w+v)*(w+v))*(p*w-q*v);v=+g[b+572>>2];if(v>=0.0){if(a[b+553>>0]|0)v=v/w;s=+g[b+576>>2];q=+g[b+580>>2];u=+g[b+584>>2];w=+Q(+((t+s)*(t+s)+(r+q)*(r+q)+(p+u)*(p+u)));if(w>v){t=v*(t+s)*(1.0/w)-s;r=v*(r+q)*(1.0/w)-q;p=v*(p+u)*(1.0/w)-u}g[b+576>>2]=t+s;g[b+580>>2]=r+q;g[b+584>>2]=p+u}q=+Q(+(p*p+(r*r+t*t)));s=t*(1.0/q);r=r*(1.0/q);p=p*(1.0/q);if(c[d+240>>2]|0){aa=r*+g[k+300>>2]+s*+g[k+296>>2]+p*+g[k+304>>2];$=r*+g[k+284>>2]+s*+g[k+280>>2]+p*+g[k+288>>2];_=r*+g[k+268>>2]+s*+g[k+264>>2]+p*+g[k+272>>2];Y=q*0.0*+g[d+116>>2];Z=q*0.0*+g[d+120>>2];g[d+64>>2]=q*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=Y+ +g[d+68>>2];g[d+72>>2]=Z+ +g[d+72>>2];$=$*q*+g[d+100>>2];aa=aa*q*+g[d+104>>2];g[d+80>>2]=_*q*+g[d+96>>2]+ +g[d+80>>2];g[d+84>>2]=$+ +g[d+84>>2];g[d+88>>2]=aa+ +g[d+88>>2];j=c[b+32>>2]|0}if(c[e+240>>2]|0){aa=r*+g[j+300>>2]+s*+g[j+296>>2]+p*+g[j+304>>2];$=r*+g[j+284>>2]+s*+g[j+280>>2]+p*+g[j+288>>2];_=r*+g[j+268>>2]+s*+g[j+264>>2]+p*+g[j+272>>2];Y=q*-0.0*+g[e+116>>2];Z=q*-0.0*+g[e+120>>2];g[e+64>>2]=q*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Y+ +g[e+68>>2];g[e+72>>2]=Z+ +g[e+72>>2];$=$*+g[e+100>>2]*-q;aa=aa*+g[e+104>>2]*-q;g[e+80>>2]=_*+g[e+96>>2]*-q+ +g[e+80>>2];g[e+84>>2]=$+ +g[e+84>>2];g[e+88>>2]=aa+ +g[e+88>>2];n=d+80|0;N=d+196|0;m=d+84|0;M=d+200|0;o=d+88|0;L=e+192|0;k=e+80|0;K=e+196|0;l=e+84|0;J=e+200|0;j=e+88|0;O=d+192|0}else{n=d+80|0;N=d+196|0;m=d+84|0;M=d+200|0;o=d+88|0;L=e+192|0;k=e+80|0;K=e+196|0;l=e+84|0;J=e+200|0;j=e+88|0;O=d+192|0}}else{n=d+80|0;N=d+196|0;m=d+84|0;M=d+200|0;o=d+88|0;L=e+192|0;k=e+80|0;K=e+196|0;l=e+84|0;J=e+200|0;j=e+88|0;O=d+192|0}}while(0);p=+g[O>>2]+ +g[n>>2];q=+g[N>>2]+ +g[m>>2];r=+g[M>>2]+ +g[o>>2];s=+g[L>>2]+ +g[k>>2];t=+g[K>>2]+ +g[l>>2];u=+g[J>>2]+ +g[j>>2];if(a[b+526>>0]|0){z=+g[b+528>>2];w=z*+g[b+504>>2]*+g[b+432>>2]/f;x=+g[b+460>>2];y=+g[b+464>>2];v=+g[b+468>>2];if((s-p)*x+(t-q)*y+(u-r)*v>0.0)w=w+z*((s-p)*x+(t-q)*y+(u-r)*v)*+g[b+436>>2];_=+g[b+516>>2];Z=_+w*+g[b+492>>2];Z=Z>0.0?Z:0.0;g[b+516>>2]=Z;X=+g[b+536>>2];Y=+g[b+540>>2];$=+g[b+544>>2];aa=X*x*(Z-_)+y*(Z-_)*Y+v*(Z-_)*$;w=+Q(+((v*(Z-_)-$*aa)*(v*(Z-_)-$*aa)+((x*(Z-_)-X*aa)*(x*(Z-_)-X*aa)+(y*(Z-_)-Y*aa)*(y*(Z-_)-Y*aa))));x=1.0/w*(x*(Z-_)-X*aa);y=1.0/w*(y*(Z-_)-Y*aa);v=1.0/w*(v*(Z-_)-$*aa);J=c[b+28>>2]|0;if(c[d+240>>2]|0){aa=y*+g[J+300>>2]+x*+g[J+296>>2]+v*+g[J+304>>2];$=y*+g[J+284>>2]+x*+g[J+280>>2]+v*+g[J+288>>2];_=y*+g[J+268>>2]+x*+g[J+264>>2]+v*+g[J+272>>2];Y=w*0.0*+g[d+116>>2];Z=w*0.0*+g[d+120>>2];g[d+64>>2]=w*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=Y+ +g[d+68>>2];g[d+72>>2]=Z+ +g[d+72>>2];$=$*w*+g[d+100>>2];aa=aa*w*+g[d+104>>2];g[n>>2]=_*w*+g[d+96>>2]+ +g[n>>2];g[m>>2]=$+ +g[m>>2];g[o>>2]=aa+ +g[o>>2]}J=c[b+32>>2]|0;if(c[e+240>>2]|0){aa=y*+g[J+300>>2]+x*+g[J+296>>2]+v*+g[J+304>>2];$=y*+g[J+284>>2]+x*+g[J+280>>2]+v*+g[J+288>>2];_=y*+g[J+268>>2]+x*+g[J+264>>2]+v*+g[J+272>>2];Y=w*-0.0*+g[e+116>>2];Z=w*-0.0*+g[e+120>>2];g[e+64>>2]=w*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Y+ +g[e+68>>2];g[e+72>>2]=Z+ +g[e+72>>2];$=$*+g[e+100>>2]*-w;aa=aa*+g[e+104>>2]*-w;g[k>>2]=_*+g[e+96>>2]*-w+ +g[k>>2];g[l>>2]=$+ +g[l>>2];g[j>>2]=aa+ +g[j>>2]}}if(!(a[b+525>>0]|0)){i=h;return}x=+g[b+532>>2];y=x*+g[b+508>>2]*+g[b+432>>2]/f;v=+g[b+476>>2];w=+g[b+480>>2];f=+g[b+484>>2];if((s-p)*v+(t-q)*w+(u-r)*f>0.0)y=y+x*((s-p)*v+(t-q)*w+(u-r)*f)*+g[b+436>>2];p=+g[b+520>>2];q=p+y*+g[b+496>>2];q=q>0.0?q:0.0;g[b+520>>2]=q;J=c[b+28>>2]|0;if(c[d+240>>2]|0){aa=w*+g[J+300>>2]+v*+g[J+296>>2]+f*+g[J+304>>2];$=w*+g[J+284>>2]+v*+g[J+280>>2]+f*+g[J+288>>2];f=w*+g[J+268>>2]+v*+g[J+264>>2]+f*+g[J+272>>2];w=(q-p)*0.0*+g[d+116>>2];v=(q-p)*0.0*+g[d+120>>2];g[d+64>>2]=(q-p)*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=w+ +g[d+68>>2];g[d+72>>2]=v+ +g[d+72>>2];v=$*(q-p)*+g[d+100>>2];w=aa*(q-p)*+g[d+104>>2];g[n>>2]=f*(q-p)*+g[d+96>>2]+ +g[n>>2];g[m>>2]=v+ +g[m>>2];g[o>>2]=w+ +g[o>>2];w=+g[b+480>>2];v=+g[b+476>>2];f=+g[b+484>>2]}b=c[b+32>>2]|0;if(!(c[e+240>>2]|0)){i=h;return}aa=w*+g[b+300>>2]+v*+g[b+296>>2]+f*+g[b+304>>2];$=w*+g[b+284>>2]+v*+g[b+280>>2]+f*+g[b+288>>2];_=w*+g[b+268>>2]+v*+g[b+264>>2]+f*+g[b+272>>2];Y=(q-p)*-0.0*+g[e+116>>2];Z=(q-p)*-0.0*+g[e+120>>2];g[e+64>>2]=(q-p)*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Y+ +g[e+68>>2];g[e+72>>2]=Z+ +g[e+72>>2];$=$*+g[e+100>>2]*-(q-p);aa=aa*+g[e+104>>2]*-(q-p);g[k>>2]=_*+g[e+96>>2]*-(q-p)+ +g[k>>2];g[l>>2]=$+ +g[l>>2];g[j>>2]=aa+ +g[j>>2];i=h;return}function Bo(a,b,c,d,e,f,h){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;h=h|0;var j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;j=i;i=i+16|0;c=c*f+ +g[a+52>>2];d=d*f+ +g[a+56>>2];g[h+48>>2]=b*f+ +g[a+48>>2];g[h+52>>2]=c;g[h+56>>2]=d;g[h+60>>2]=0.0;d=+g[e>>2];b=+g[e+4>>2];c=+g[e+8>>2];k=+Q(+(d*d+b*b+c*c));if(k*f>.7853981852531433)k=.7853981852531433/f;if(k<.0010000000474974513)l=f*.5-k*f*f*f*.02083333395421505*k;else l=+T(+(k*.5*f))/k;o=l*d;b=l*b;c=l*c;q=+S(+(k*f*.5));Hc(a,j);n=+g[j>>2];p=+g[j+12>>2];f=+g[j+8>>2];l=+g[j+4>>2];r=1.0/+Q(+((q*p-o*n-b*l-c*f)*(q*p-o*n-b*l-c*f)+((c*p+q*f+o*l-b*n)*(c*p+q*f+o*l-b*n)+((q*n+o*p+b*f-c*l)*(q*n+o*p+b*f-c*l)+(c*n+(b*p+q*l)-o*f)*(c*n+(b*p+q*l)-o*f)))));d=(q*n+o*p+b*f-c*l)*r;k=r*(c*n+(b*p+q*l)-o*f);m=r*(c*p+q*f+o*l-b*n);f=r*(q*p-o*n-b*l-c*f);c=d*(2.0/(f*f+(m*m+(d*d+k*k))));l=2.0/(f*f+(m*m+(d*d+k*k)))*k;b=2.0/(f*f+(m*m+(d*d+k*k)))*m;g[h>>2]=1.0-(m*b+k*l);g[h+4>>2]=d*l-f*b;g[h+8>>2]=d*b+f*l;g[h+12>>2]=0.0;g[h+16>>2]=f*b+d*l;g[h+20>>2]=1.0-(d*c+m*b);g[h+24>>2]=k*b-f*c;g[h+28>>2]=0.0;g[h+32>>2]=d*b-f*l;g[h+36>>2]=f*c+k*b;g[h+40>>2]=1.0-(d*c+k*l);g[h+44>>2]=0.0;i=j;return}function Co(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;e=+S(+c);c=+T(+c);f=+g[b+444>>2];if(+P(+e)>1.1920928955078125e-7){j=+g[b+448>>2];h=c*c;i=e*e;f=+Q(+((c*c/(e*e)+1.0)/(1.0/(j*j)+c*c/(e*e)/(f*f))))}else{h=c*c;i=e*e}k=f*.5;j=+T(+k)/+Q(+(i+0.0+h));k=+S(+k);l=k*d+e*j*0.0-c*j*-0.0;i=k*0.0-c*j*d-j*0.0*0.0;f=k*0.0+j*0.0*0.0-e*j*d;h=-(j*0.0*d)-e*j*0.0-c*j*-0.0;g[a>>2]=c*j*i+(k*l+h*-(j*0.0))-f*-(e*j);g[a+4>>2]=f*-(j*0.0)+(k*i+h*-(e*j))-c*j*l;g[a+8>>2]=l*-(e*j)+(k*f+c*j*h)-i*-(j*0.0);g[a+12>>2]=0.0;return}function Do(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,u=0.0;d=i;c[a+556>>2]=c[b+0>>2];c[a+560>>2]=c[b+4>>2];c[a+564>>2]=c[b+8>>2];c[a+568>>2]=c[b+12>>2];p=+g[a+568>>2];r=+g[a+560>>2];q=+g[a+564>>2];j=+g[a+556>>2];e=-j-r*0.0-q*0.0;h=(q+p*0.0-j*0.0)*-q+(p*(p+r*0.0-q*0.0)+e*-j)-(p*0.0+j*0.0-r)*-r;k=(p*0.0+j*0.0-r)*-j+(p*(q+p*0.0-j*0.0)+e*-r)-(p+r*0.0-q*0.0)*-q;e=(p+r*0.0-q*0.0)*-r+(p*(p*0.0+j*0.0-r)+e*-q)-(q+p*0.0-j*0.0)*-j;if(e*0.0+(k*0.0+h)<-.9999998807907104)if(+P(0.0)>.7071067690849304){f=0.0;e=t;k=t;h=0.0}else{f=-0.0;e=1.0;k=0.0;h=0.0}else{s=+Q(+((e*0.0+(k*0.0+h)+1.0)*2.0));f=(e*0.0-k*0.0)*(1.0/s);e=(h*0.0-e)*(1.0/s);k=(k-h*0.0)*(1.0/s);h=s*.5}s=1.0/+Q(+(h*h+(k*k+(e*e+f*f))));l=f*s;m=e*s;o=k*s;k=h*s;s=1.0/+Q(+((k*p-j*-l-r*-m-q*-o)*(k*p-j*-l-r*-m-q*-o)+((p*-o+k*q+r*-l-j*-m)*(p*-o+k*q+r*-l-j*-m)+((k*j+p*-l+q*-m-r*-o)*(k*j+p*-l+q*-m-r*-o)+(j*-o+(p*-m+k*r)-q*-l)*(j*-o+(p*-m+k*r)-q*-l)))));h=(k*j+p*-l+q*-m-r*-o)*s;e=s*(j*-o+(p*-m+k*r)-q*-l);f=s*(p*-o+k*q+r*-l-j*-m);j=s*(k*p-j*-l-r*-m-q*-o);s=+g[a+444>>2];if(s>=.05000000074505806?(n=+g[a+448>>2],n>=.05000000074505806):0){q=k<-1.0?-1.0:k;q=+V(+(q>1.0?1.0:q))*2.0;if(q>1.1920928955078125e-7){p=1.0/+Q(+(o*o+(l*l+m*m)));if(+P(+(m*p))>1.1920928955078125e-7){s=+Q(+((o*p*o*p/(m*p*m*p)+1.0)/(1.0/(n*n)+o*p*o*p/(m*p*m*p)/(s*s))));r=l*p;n=m*p;p=o*p}else{r=l*p;n=m*p;p=o*p}}else{s=0.0;r=0.0;n=0.0;p=0.0}if(+P(+q)>1.1920928955078125e-7){if(!(q>s)){k=-s;if(q<k)q=k}else q=s;k=q*.5;o=+T(+k)/+Q(+(p*p+(n*n+r*r)));k=+S(+k);l=r*o;m=n*o;o=p*o}}p=+g[a+452>>2];if(p>=.05000000074505806){r=j<-1.0?-1.0:j;r=+V(+(r>1.0?1.0:r))*2.0;if(r>3.1415927410125732){r=j>1.0?-1.0:-j;r=+V(+(r>1.0?1.0:r))*2.0;s=-h;n=-e;q=-f}else{s=h;n=e;q=f}if(r>1.1920928955078125e-7){u=1.0/+Q(+(q*q+(n*n+s*s)));s=s*u;n=n*u;q=q*u}if(+P(+r)>1.1920928955078125e-7){if(!(r>p))if(r<-p)p=-p;else p=r;j=p*.5;e=+T(+j)/+Q(+(q*q+(n*n+s*s)));h=s*e;j=+S(+j);f=q*e;e=n*e}}g[a+556>>2]=m*f+(l*j+k*h)-o*e;g[a+560>>2]=o*h+(m*j+k*e)-l*f;g[a+564>>2]=o*j+k*f+l*e-m*h;g[a+568>>2]=k*j-l*h-m*e-o*f;i=d;return}function Eo(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;f=i;if((b|0)==4|(b|0)==3)if(e>>>0<3){g[a+596>>2]=d;c[a+592>>2]=c[a+592>>2]|1;i=f;return}else{g[a+604>>2]=d;c[a+592>>2]=c[a+592>>2]|4;i=f;return}else if((b|0)==2|(b|0)==1)if(e>>>0<3){g[a+600>>2]=d;c[a+592>>2]=c[a+592>>2]|2;i=f;return}else{g[a+432>>2]=d;i=f;return}else{i=f;return}}function Fo(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0;d=i;do if((b|0)==2|(b|0)==1){if(c>>>0<3){e=+g[a+600>>2];break}if((c+ -3|0)>>>0<3)e=+g[a+432>>2];else e=0.0}else if((b|0)==4|(b|0)==3){if(c>>>0<3){e=+g[a+596>>2];break}if((c+ -3|0)>>>0<3)e=+g[a+604>>2];else e=0.0}else e=0.0;while(0);i=d;return+e}function Go(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[a+300>>2]=c[b+0>>2];c[a+304>>2]=c[b+4>>2];c[a+308>>2]=c[b+8>>2];c[a+312>>2]=c[b+12>>2];c[a+316>>2]=c[b+16>>2];c[a+320>>2]=c[b+20>>2];c[a+324>>2]=c[b+24>>2];c[a+328>>2]=c[b+28>>2];c[a+332>>2]=c[b+32>>2];c[a+336>>2]=c[b+36>>2];c[a+340>>2]=c[b+40>>2];c[a+344>>2]=c[b+44>>2];c[a+348>>2]=c[b+48>>2];c[a+352>>2]=c[b+52>>2];c[a+356>>2]=c[b+56>>2];c[a+360>>2]=c[b+60>>2];c[a+364>>2]=c[d+0>>2];c[a+368>>2]=c[d+4>>2];c[a+372>>2]=c[d+8>>2];c[a+376>>2]=c[d+12>>2];c[a+380>>2]=c[d+16>>2];c[a+384>>2]=c[d+20>>2];c[a+388>>2]=c[d+24>>2];c[a+392>>2]=c[d+28>>2];c[a+396>>2]=c[d+32>>2];c[a+400>>2]=c[d+36>>2];c[a+404>>2]=c[d+40>>2];c[a+408>>2]=c[d+44>>2];c[a+412>>2]=c[d+48>>2];c[a+416>>2]=c[d+52>>2];c[a+420>>2]=c[d+56>>2];c[a+424>>2]=c[d+60>>2];Lb[c[(c[a>>2]|0)+8>>2]&511](a);i=e;return}function Ho(a){a=a|0;return}function Io(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Jo(a){a=a|0;return 212}function Ko(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Zr(a,b,c)|0;g[b+52>>2]=+g[a+300>>2];g[b+56>>2]=+g[a+304>>2];g[b+60>>2]=+g[a+308>>2];g[b+64>>2]=+g[a+312>>2];g[b+68>>2]=+g[a+316>>2];g[b+72>>2]=+g[a+320>>2];g[b+76>>2]=+g[a+324>>2];g[b+80>>2]=+g[a+328>>2];g[b+84>>2]=+g[a+332>>2];g[b+88>>2]=+g[a+336>>2];g[b+92>>2]=+g[a+340>>2];g[b+96>>2]=+g[a+344>>2];g[b+100>>2]=+g[a+348>>2];g[b+104>>2]=+g[a+352>>2];g[b+108>>2]=+g[a+356>>2];g[b+112>>2]=+g[a+360>>2];g[b+116>>2]=+g[a+364>>2];g[b+120>>2]=+g[a+368>>2];g[b+124>>2]=+g[a+372>>2];g[b+128>>2]=+g[a+376>>2];g[b+132>>2]=+g[a+380>>2];g[b+136>>2]=+g[a+384>>2];g[b+140>>2]=+g[a+388>>2];g[b+144>>2]=+g[a+392>>2];g[b+148>>2]=+g[a+396>>2];g[b+152>>2]=+g[a+400>>2];g[b+156>>2]=+g[a+404>>2];g[b+160>>2]=+g[a+408>>2];g[b+164>>2]=+g[a+412>>2];g[b+168>>2]=+g[a+416>>2];g[b+172>>2]=+g[a+420>>2];g[b+176>>2]=+g[a+424>>2];g[b+180>>2]=+g[a+444>>2];g[b+184>>2]=+g[a+448>>2];g[b+188>>2]=+g[a+452>>2];g[b+192>>2]=+g[a+428>>2];g[b+196>>2]=+g[a+432>>2];g[b+200>>2]=+g[a+436>>2];g[b+204>>2]=+g[a+440>>2];i=d;return 1352}function Lo(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;e=i;i=i+64|0;f=+g[a+20>>2];t=+g[a+40>>2];o=+g[a+24>>2];r=+g[a+36>>2];s=+g[a+32>>2];h=+g[a+16>>2];l=+g[a>>2];j=+g[a+4>>2];p=+g[a+8>>2];m=1.0/((f*t-o*r)*l+j*(o*s-t*h)+(r*h-f*s)*p);z=+g[b>>2];y=+g[b+4>>2];x=+g[b+8>>2];w=+g[b+16>>2];v=+g[b+20>>2];u=+g[b+24>>2];q=+g[b+32>>2];n=+g[b+36>>2];k=+g[b+40>>2];g[e+16>>2]=(f*t-o*r)*m*z+(o*s-t*h)*m*y+(r*h-f*s)*m*x;g[e+20>>2]=z*m*(r*p-t*j)+y*m*(t*l-s*p)+m*(s*j-r*l)*x;g[e+24>>2]=z*m*(o*j-f*p)+y*m*(h*p-o*l)+m*(f*l-h*j)*x;g[e+28>>2]=0.0;g[e+32>>2]=(f*t-o*r)*m*w+(o*s-t*h)*m*v+(r*h-f*s)*m*u;g[e+36>>2]=m*(r*p-t*j)*w+m*(t*l-s*p)*v+m*(s*j-r*l)*u;g[e+40>>2]=m*(o*j-f*p)*w+m*(h*p-o*l)*v+m*(f*l-h*j)*u;g[e+44>>2]=0.0;g[e+48>>2]=(f*t-o*r)*m*q+(o*s-t*h)*m*n+(r*h-f*s)*m*k;g[e+52>>2]=m*(r*p-t*j)*q+m*(t*l-s*p)*n+m*(s*j-r*l)*k;g[e+56>>2]=m*(o*j-f*p)*q+m*(h*p-o*l)*n+m*(f*l-h*j)*k;g[e+60>>2]=0.0;Hc(e+16|0,e);k=+g[e>>2];j=+g[e+4>>2];h=+g[e+8>>2];l=+g[e+12>>2];f=1.0/+Q(+(k*k+j*j+h*h+l*l));g[e>>2]=k*f;g[e+4>>2]=j*f;g[e+8>>2]=h*f;g[e+12>>2]=l*f;l=l*f<-1.0?-1.0:l*f;g[d>>2]=+V(+(l>1.0?1.0:l))*2.0;g[c>>2]=k*f;g[c+4>>2]=j*f;g[c+8>>2]=h*f;g[c+12>>2]=0.0;if(k*f*k*f+j*f*j*f+h*f*h*f<1.4210854715202004e-14){g[c>>2]=1.0;g[c+4>>2]=0.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=e;return}else{z=1.0/+Q(+(k*f*k*f+j*f*j*f+h*f*h*f));g[c>>2]=k*f*z;g[c+4>>2]=z*j*f;g[c+8>>2]=z*h*f;i=e;return}}function Mo(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;l=l|0;m=+m;var n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;n=i;c[a+0>>2]=c[h+0>>2];c[a+4>>2]=c[h+4>>2];c[a+8>>2]=c[h+8>>2];c[a+12>>2]=c[h+12>>2];u=+g[e+4>>2];t=+g[a+8>>2];r=+g[e+8>>2];x=+g[a+4>>2];o=+g[a>>2];z=+g[e>>2];y=(u*t-r*x)*+g[b>>2]+ +g[b+4>>2]*(r*o-t*z)+(x*z-u*o)*+g[b+8>>2];w=(u*t-r*x)*+g[b+16>>2]+(r*o-t*z)*+g[b+20>>2]+(x*z-u*o)*+g[b+24>>2];u=(u*t-r*x)*+g[b+32>>2]+(r*o-t*z)*+g[b+36>>2]+(x*z-u*o)*+g[b+40>>2];g[a+16>>2]=y;g[a+20>>2]=w;g[a+24>>2]=u;g[a+28>>2]=0.0;z=+g[f+4>>2];r=+g[f+8>>2];v=+g[f>>2];s=+g[d>>2]*(z*-t-r*-x)+ +g[d+4>>2]*(r*-o-v*-t)+(v*-x-z*-o)*+g[d+8>>2];q=(z*-t-r*-x)*+g[d+16>>2]+(r*-o-v*-t)*+g[d+20>>2]+(v*-x-z*-o)*+g[d+24>>2];o=(z*-t-r*-x)*+g[d+32>>2]+(r*-o-v*-t)*+g[d+36>>2]+(v*-x-z*-o)*+g[d+40>>2];g[a+32>>2]=s;g[a+36>>2]=q;g[a+40>>2]=o;g[a+44>>2]=0.0;z=+g[j>>2]*y;x=+g[j+4>>2]*w;v=+g[j+8>>2]*u;g[a+48>>2]=z;g[a+52>>2]=x;g[a+56>>2]=v;g[a+60>>2]=0.0;t=+g[l>>2]*s;r=+g[l+4>>2]*q;p=+g[l+8>>2]*o;g[a+64>>2]=t;g[a+68>>2]=r;g[a+72>>2]=p;g[a+76>>2]=0.0;g[a+80>>2]=z*y+x*w+v*u+k+m+(t*s+r*q+p*o);i=n;return}function No(a){a=a|0;var b=0;b=i;Oo(a);if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Oo(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;c[b>>2]=1392;if((a[b+272>>0]|0)!=0?(g=c[b+204>>2]|0,Lb[c[c[g>>2]>>2]&511](g),g=c[b+204>>2]|0,(g|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[g+ -4>>2]|0)}g=c[b+196>>2]|0;if((g|0)!=0?(Lb[c[c[g>>2]>>2]&511](g),f=c[b+196>>2]|0,(f|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}if((a[b+273>>0]|0)!=0?(e=c[b+200>>2]|0,Lb[c[c[e>>2]>>2]&511](e),e=c[b+200>>2]|0,(e|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+316>>2]|0;if(e){if(a[b+320>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+316>>2]=0}a[b+320>>0]=1;c[b+316>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;e=c[b+288>>2]|0;if(e){if(a[b+292>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;e=c[b+240>>2]|0;if(e){if(a[b+244>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=0;c[b+232>>2]=0;c[b+236>>2]=0;e=c[b+220>>2]|0;if(e){if(a[b+224>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=0;c[b+212>>2]=0;c[b+216>>2]=0;e=c[b+188>>2]|0;if(!e){a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;g=b+184|0;c[g>>2]=0;Bu(b);i=d;return}if(a[b+192>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+188>>2]=0;a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;g=b+184|0;c[g>>2]=0;Bu(b);i=d;return}function Po(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0;d=i;i=i+32|0;h=c[a+8>>2]|0;if((h|0)<=0){i=d;return}e=0;do{f=c[(c[a+16>>2]|0)+(e<<2)>>2]|0;if((!((f|0)==0?1:(c[f+236>>2]&2|0)==0)?(c[f+216>>2]|0)!=2:0)?!((c[f+204>>2]&2|0)==0|b!=0.0^1):0){h=c[f+480>>2]|0;if(!h)h=f+4|0;else{Nb[c[(c[h>>2]|0)+8>>2]&127](h,f+4|0);h=f+4|0}k=(+g[f+56>>2]- +g[f+120>>2])*(1.0/b);l=1.0/b*(+g[f+60>>2]- +g[f+124>>2]);g[f+312>>2]=(+g[f+52>>2]- +g[f+116>>2])*(1.0/b);g[f+316>>2]=k;g[f+320>>2]=l;g[f+324>>2]=0.0;Lo(f+68|0,h,d+8|0,d);l=+g[d>>2];k=1.0/b*l*+g[d+12>>2];j=1.0/b*l*+g[d+16>>2];g[f+328>>2]=1.0/b*+g[d+8>>2]*l;g[f+332>>2]=k;g[f+336>>2]=j;g[f+340>>2]=0.0;c[f+132>>2]=c[f+312>>2];c[f+136>>2]=c[f+316>>2];c[f+140>>2]=c[f+320>>2];c[f+144>>2]=c[f+324>>2];c[f+148>>2]=c[f+328>>2];c[f+152>>2]=c[f+332>>2];c[f+156>>2]=c[f+336>>2];c[f+160>>2]=c[f+340>>2];c[f+68>>2]=c[h+0>>2];c[f+72>>2]=c[h+4>>2];c[f+76>>2]=c[h+8>>2];c[f+80>>2]=c[h+12>>2];c[f+84>>2]=c[f+20>>2];c[f+88>>2]=c[f+24>>2];c[f+92>>2]=c[f+28>>2];c[f+96>>2]=c[f+32>>2];c[f+100>>2]=c[f+36>>2];c[f+104>>2]=c[f+40>>2];c[f+108>>2]=c[f+44>>2];c[f+112>>2]=c[f+48>>2];c[f+116>>2]=c[f+52>>2];c[f+120>>2]=c[f+56>>2];c[f+124>>2]=c[f+60>>2];c[f+128>>2]=c[f+64>>2];h=c[a+8>>2]|0}e=e+1|0}while((e|0)<(h|0));i=d;return}function Qo(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0.0,H=0.0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0,P=0.0,Q=0.0,R=0.0,U=0.0,V=0.0,W=0.0;d=i;i=i+1024|0;yE(1576);Uu(b);a:do if((Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Pb[c[(c[I>>2]|0)+48>>2]&127](I)|0)&6144|0)!=0):0){e=d+988|0;o=d+896|0;n=d+832|0;q=d+912|0;p=d+848|0;s=d+928|0;r=d+864|0;u=d+720|0;t=d+656|0;w=d+736|0;v=d+672|0;y=d+752|0;x=d+688|0;f=d+336|0;h=d+352|0;j=d+368|0;k=d+112|0;l=d+128|0;m=d+144|0;B=Pb[c[(c[b>>2]|0)+104>>2]&127](b)|0;b:while(1){z=B+ -1|0;if((B|0)<=0)break a;B=gc[c[(c[b>>2]|0)+108>>2]&31](b,z)|0;I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=(Pb[c[(c[I>>2]|0)+48>>2]&127](I)|0)>>>11;C=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;C=(Pb[c[(c[C>>2]|0)+48>>2]&127](C)|0)>>>12;A=+g[B+40>>2];if(A<=0.0){B=z;continue}switch(c[B+4>>2]|0){case 3:{g[d+944>>2]=1.0;c[d+948>>2]=0;c[d+952>>2]=0;c[d+956>>2]=0;c[d+960>>2]=0;g[d+964>>2]=1.0;c[d+968>>2]=0;c[d+972>>2]=0;c[d+976>>2]=0;c[d+980>>2]=0;g[d+984>>2]=1.0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;H=+g[B+300>>2];G=+g[B+304>>2];J=+g[B+308>>2];F=c[B+28>>2]|0;K=H*+g[F+20>>2]+G*+g[F+24>>2]+J*+g[F+28>>2]+ +g[F+56>>2];L=H*+g[F+36>>2]+G*+g[F+40>>2]+J*+g[F+44>>2]+ +g[F+60>>2];g[d+992>>2]=H*+g[F+4>>2]+G*+g[F+8>>2]+J*+g[F+12>>2]+ +g[F+52>>2];g[d+996>>2]=K;g[d+1e3>>2]=L;g[d+1004>>2]=0.0;F=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[F>>2]|0)+56>>2]&7](F,d+944|0,A);L=+g[B+316>>2];K=+g[B+320>>2];J=+g[B+324>>2];F=c[B+32>>2]|0;G=L*+g[F+20>>2]+K*+g[F+24>>2]+J*+g[F+28>>2]+ +g[F+56>>2];H=L*+g[F+36>>2]+K*+g[F+40>>2]+J*+g[F+44>>2]+ +g[F+60>>2];g[d+992>>2]=L*+g[F+4>>2]+K*+g[F+8>>2]+J*+g[F+12>>2]+ +g[F+52>>2];g[d+996>>2]=G;g[d+1e3>>2]=H;g[d+1004>>2]=0.0;if(!(I&1)){B=z;continue b}B=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[B>>2]|0)+56>>2]&7](B,d+944|0,A);B=z;continue b};case 4:{no(d+880|0,(c[B+28>>2]|0)+4|0,B+552|0);if(!(I&1)){no(d+816|0,(c[B+32>>2]|0)+4|0,B+616|0);c[d+880>>2]=c[d+816>>2];c[d+884>>2]=c[d+820>>2];c[d+888>>2]=c[d+824>>2];c[d+892>>2]=c[d+828>>2];c[o+0>>2]=c[n+0>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2];c[q+0>>2]=c[p+0>>2];c[q+4>>2]=c[p+4>>2];c[q+8>>2]=c[p+8>>2];c[q+12>>2]=c[p+12>>2];c[s+0>>2]=c[r+0>>2];c[s+4>>2]=c[r+4>>2];c[s+8>>2]=c[r+8>>2];c[s+12>>2]=c[r+12>>2]}else{I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[I>>2]|0)+56>>2]&7](I,d+880|0,A);no(d+816|0,(c[B+32>>2]|0)+4|0,B+616|0);c[d+880>>2]=c[d+816>>2];c[d+884>>2]=c[d+820>>2];c[d+888>>2]=c[d+824>>2];c[d+892>>2]=c[d+828>>2];c[o+0>>2]=c[n+0>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2];c[q+0>>2]=c[p+0>>2];c[q+4>>2]=c[p+4>>2];c[q+8>>2]=c[p+8>>2];c[q+12>>2]=c[p+12>>2];c[s+0>>2]=c[r+0>>2];c[s+4>>2]=c[r+4>>2];c[s+8>>2]=c[r+8>>2];c[s+12>>2]=c[r+12>>2];I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[I>>2]|0)+56>>2]&7](I,d+880|0,A)}G=+ab(+(+g[B+688>>2]- +g[B+692>>2]),6.2831854820251465);if(!(G<-3.1415927410125732)){if(G>3.1415927410125732)G=G+-6.2831854820251465}else G=G+6.2831854820251465;H=+ab(+(+g[B+688>>2]+ +g[B+692>>2]),6.2831854820251465);if(!(H<-3.1415927410125732)){if(H>3.1415927410125732)H=H+-6.2831854820251465}else H=H+6.2831854820251465;if(G==H){B=z;continue b}B=G>H;if(!(C&1)){B=z;continue b}g[d+800>>2]=+g[d+888>>2];g[d+804>>2]=+g[d+904>>2];g[d+808>>2]=+g[d+920>>2];g[d+812>>2]=0.0;g[d+784>>2]=+g[d+880>>2];g[d+788>>2]=+g[d+896>>2];g[d+792>>2]=+g[d+912>>2];g[d+796>>2]=0.0;I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;F=c[(c[I>>2]|0)+60>>2]|0;c[d+768>>2]=0;c[d+772>>2]=0;c[d+776>>2]=0;c[d+780>>2]=0;Wb[F&0](I,s,d+800|0,d+784|0,A,A,B?0.0:G,B?6.2831854820251465:H,d+768|0,B^1,10.0);B=z;continue b};case 5:{no(d+704|0,(c[B+28>>2]|0)+4|0,B+300|0);if(!(I&1)){no(d+640|0,(c[B+32>>2]|0)+4|0,B+364|0);c[d+704>>2]=c[d+640>>2];c[d+708>>2]=c[d+644>>2];c[d+712>>2]=c[d+648>>2];c[d+716>>2]=c[d+652>>2];c[u+0>>2]=c[t+0>>2];c[u+4>>2]=c[t+4>>2];c[u+8>>2]=c[t+8>>2];c[u+12>>2]=c[t+12>>2];c[w+0>>2]=c[v+0>>2];c[w+4>>2]=c[v+4>>2];c[w+8>>2]=c[v+8>>2];c[w+12>>2]=c[v+12>>2];c[y+0>>2]=c[x+0>>2];c[y+4>>2]=c[x+4>>2];c[y+8>>2]=c[x+8>>2];c[y+12>>2]=c[x+12>>2]}else{I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[I>>2]|0)+56>>2]&7](I,d+704|0,A);no(d+640|0,(c[B+32>>2]|0)+4|0,B+364|0);c[d+704>>2]=c[d+640>>2];c[d+708>>2]=c[d+644>>2];c[d+712>>2]=c[d+648>>2];c[d+716>>2]=c[d+652>>2];c[u+0>>2]=c[t+0>>2];c[u+4>>2]=c[t+4>>2];c[u+8>>2]=c[t+8>>2];c[u+12>>2]=c[t+12>>2];c[w+0>>2]=c[v+0>>2];c[w+4>>2]=c[v+4>>2];c[w+8>>2]=c[v+8>>2];c[w+12>>2]=c[v+12>>2];c[y+0>>2]=c[x+0>>2];c[y+4>>2]=c[x+4>>2];c[y+8>>2]=c[x+8>>2];c[y+12>>2]=c[x+12>>2];I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[I>>2]|0)+56>>2]&7](I,d+704|0,A)}if(!(C&1)){B=z;continue b}Co(d+624|0,B,6.0868353843688965,A);G=+g[d+624>>2];H=+g[d+628>>2];J=+g[d+632>>2];K=G*+g[d+720>>2]+H*+g[d+724>>2]+J*+g[d+728>>2]+ +g[d+756>>2];L=G*+g[d+736>>2]+H*+g[d+740>>2]+J*+g[d+744>>2]+ +g[d+760>>2];g[d+624>>2]=G*+g[d+704>>2]+H*+g[d+708>>2]+J*+g[d+712>>2]+ +g[d+752>>2];g[d+628>>2]=K;g[d+632>>2]=L;g[d+636>>2]=0.0;C=0;do{Co(d+608|0,B,+(C|0)*6.283185005187988*.03125,A);G=+g[d+608>>2];H=+g[d+612>>2];J=+g[d+616>>2];K=G*+g[d+720>>2]+H*+g[d+724>>2]+J*+g[d+728>>2]+ +g[d+756>>2];L=G*+g[d+736>>2]+H*+g[d+740>>2]+J*+g[d+744>>2]+ +g[d+760>>2];g[d+608>>2]=G*+g[d+704>>2]+H*+g[d+708>>2]+J*+g[d+712>>2]+ +g[d+752>>2];g[d+612>>2]=K;g[d+616>>2]=L;g[d+620>>2]=0.0;I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;F=c[(c[I>>2]|0)+8>>2]|0;c[d+592>>2]=0;c[d+596>>2]=0;c[d+600>>2]=0;c[d+604>>2]=0;vc[F&127](I,d+624|0,d+608|0,d+592|0);if(!(C&3)){I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;F=c[(c[I>>2]|0)+8>>2]|0;c[d+576>>2]=0;c[d+580>>2]=0;c[d+584>>2]=0;c[d+588>>2]=0;vc[F&127](I,y,d+608|0,d+576|0)}c[d+624>>2]=c[d+608>>2];c[d+628>>2]=c[d+612>>2];c[d+632>>2]=c[d+616>>2];c[d+636>>2]=c[d+620>>2];C=C+1|0}while((C|0)!=32);H=+g[B+452>>2];G=+g[B+512>>2];C=c[B+32>>2]|0;if(+g[C+344>>2]>0.0){no(d+512|0,C+4|0,B+364|0);c[d+704>>2]=c[d+512>>2];c[d+708>>2]=c[d+516>>2];c[d+712>>2]=c[d+520>>2];c[d+716>>2]=c[d+524>>2];c[u+0>>2]=c[d+528>>2];c[u+4>>2]=c[d+532>>2];c[u+8>>2]=c[d+536>>2];c[u+12>>2]=c[d+540>>2];c[w+0>>2]=c[d+544>>2];c[w+4>>2]=c[d+548>>2];c[w+8>>2]=c[d+552>>2];c[w+12>>2]=c[d+556>>2];c[y+0>>2]=c[d+560>>2];c[y+4>>2]=c[d+564>>2];c[y+8>>2]=c[d+568>>2];c[y+12>>2]=c[d+572>>2]}else{no(d+448|0,(c[B+28>>2]|0)+4|0,B+300|0);c[d+704>>2]=c[d+448>>2];c[d+708>>2]=c[d+452>>2];c[d+712>>2]=c[d+456>>2];c[d+716>>2]=c[d+460>>2];c[u+0>>2]=c[d+464>>2];c[u+4>>2]=c[d+468>>2];c[u+8>>2]=c[d+472>>2];c[u+12>>2]=c[d+476>>2];c[w+0>>2]=c[d+480>>2];c[w+4>>2]=c[d+484>>2];c[w+8>>2]=c[d+488>>2];c[w+12>>2]=c[d+492>>2];c[y+0>>2]=c[d+496>>2];c[y+4>>2]=c[d+500>>2];c[y+8>>2]=c[d+504>>2];c[y+12>>2]=c[d+508>>2]}c[d+432>>2]=c[y+0>>2];c[d+436>>2]=c[y+4>>2];c[d+440>>2]=c[y+8>>2];c[d+444>>2]=c[y+12>>2];g[d+416>>2]=+g[d+704>>2];g[d+420>>2]=+g[d+720>>2];g[d+424>>2]=+g[d+736>>2];g[d+428>>2]=0.0;g[d+400>>2]=+g[d+708>>2];g[d+404>>2]=+g[d+724>>2];g[d+408>>2]=+g[d+740>>2];g[d+412>>2]=0.0;B=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[B>>2]|0)+60>>2]|0;c[d+384>>2]=0;c[d+388>>2]=0;c[d+392>>2]=0;c[d+396>>2]=0;Wb[I&0](B,d+432|0,d+416|0,d+400|0,A,A,-G-H,H-G,d+384|0,1,10.0);B=z;continue b};case 6:case 9:{c[d+320>>2]=c[B+1064>>2];c[d+324>>2]=c[B+1068>>2];c[d+328>>2]=c[B+1072>>2];c[d+332>>2]=c[B+1076>>2];E=B+1080|0;c[f+0>>2]=c[E+0>>2];c[f+4>>2]=c[E+4>>2];c[f+8>>2]=c[E+8>>2];c[f+12>>2]=c[E+12>>2];F=B+1096|0;c[h+0>>2]=c[F+0>>2];c[h+4>>2]=c[F+4>>2];c[h+8>>2]=c[F+8>>2];c[h+12>>2]=c[F+12>>2];D=B+1112|0;c[j+0>>2]=c[D+0>>2];c[j+4>>2]=c[D+4>>2];c[j+8>>2]=c[D+8>>2];c[j+12>>2]=c[D+12>>2];if(!(I&1)){c[d+320>>2]=c[B+1128>>2];c[d+324>>2]=c[B+1132>>2];c[d+328>>2]=c[B+1136>>2];c[d+332>>2]=c[B+1140>>2];c[f+0>>2]=c[B+1144>>2];c[f+4>>2]=c[B+1148>>2];c[f+8>>2]=c[B+1152>>2];c[f+12>>2]=c[B+1156>>2];c[h+0>>2]=c[B+1160>>2];c[h+4>>2]=c[B+1164>>2];c[h+8>>2]=c[B+1168>>2];c[h+12>>2]=c[B+1172>>2];c[j+0>>2]=c[B+1176>>2];c[j+4>>2]=c[B+1180>>2];c[j+8>>2]=c[B+1184>>2];c[j+12>>2]=c[B+1188>>2]}else{I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[I>>2]|0)+56>>2]&7](I,d+320|0,A);c[d+320>>2]=c[B+1128>>2];c[d+324>>2]=c[B+1132>>2];c[d+328>>2]=c[B+1136>>2];c[d+332>>2]=c[B+1140>>2];c[f+0>>2]=c[B+1144>>2];c[f+4>>2]=c[B+1148>>2];c[f+8>>2]=c[B+1152>>2];c[f+12>>2]=c[B+1156>>2];c[h+0>>2]=c[B+1160>>2];c[h+4>>2]=c[B+1164>>2];c[h+8>>2]=c[B+1168>>2];c[h+12>>2]=c[B+1172>>2];c[j+0>>2]=c[B+1176>>2];c[j+4>>2]=c[B+1180>>2];c[j+8>>2]=c[B+1184>>2];c[j+12>>2]=c[B+1188>>2];I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[I>>2]|0)+56>>2]&7](I,d+320|0,A)}if(!(C&1)){B=z;continue b}c[d+320>>2]=c[B+1064>>2];c[d+324>>2]=c[B+1068>>2];c[d+328>>2]=c[B+1072>>2];c[d+332>>2]=c[B+1076>>2];c[f+0>>2]=c[E+0>>2];c[f+4>>2]=c[E+4>>2];c[f+8>>2]=c[E+8>>2];c[f+12>>2]=c[E+12>>2];c[h+0>>2]=c[F+0>>2];c[h+4>>2]=c[F+4>>2];c[h+8>>2]=c[F+8>>2];c[h+12>>2]=c[F+12>>2];c[j+0>>2]=c[D+0>>2];c[j+4>>2]=c[D+4>>2];c[j+8>>2]=c[D+8>>2];c[j+12>>2]=c[D+12>>2];C=B+1176|0;g[d+304>>2]=+g[d+328>>2];g[d+308>>2]=+g[d+344>>2];g[d+312>>2]=+g[d+360>>2];g[d+316>>2]=0.0;g[d+288>>2]=+g[d+320>>2];g[d+292>>2]=+g[d+336>>2];g[d+296>>2]=+g[d+352>>2];g[d+300>>2]=0.0;J=+g[B+932>>2];H=+g[B+936>>2];L=+g[B+996>>2];M=+g[B+1e3>>2];I=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;O=c[(c[I>>2]|0)+64>>2]|0;c[d+272>>2]=0;c[d+276>>2]=0;c[d+280>>2]=0;c[d+284>>2]=0;mc[O&0](I,C,d+304|0,d+288|0,A*.8999999761581421,J,H,L,M,d+272|0,10.0,1);M=+g[d+324>>2];L=+g[d+340>>2];H=+g[d+356>>2];g[d+288>>2]=M;g[d+292>>2]=L;g[d+296>>2]=H;g[d+300>>2]=0.0;J=+g[B+1196>>2];K=+g[B+1200>>2];G=+S(+J);J=+T(+J);N=+S(+K);K=+T(+K);g[d+256>>2]=G*N*M+G*K*L-J*H;g[d+260>>2]=N*L-K*M;g[d+264>>2]=J*N*M+J*K*L+G*H;c[d+320>>2]=c[B+1128>>2];c[d+324>>2]=c[B+1132>>2];c[d+328>>2]=c[B+1136>>2];c[d+332>>2]=c[B+1140>>2];c[f+0>>2]=c[B+1144>>2];c[f+4>>2]=c[B+1148>>2];c[f+8>>2]=c[B+1152>>2];c[f+12>>2]=c[B+1156>>2];c[h+0>>2]=c[B+1160>>2];c[h+4>>2]=c[B+1164>>2];c[h+8>>2]=c[B+1168>>2];c[h+12>>2]=c[B+1172>>2];c[j+0>>2]=c[C+0>>2];c[j+4>>2]=c[C+4>>2];c[j+8>>2]=c[C+8>>2];c[j+12>>2]=c[C+12>>2];H=-+g[d+336>>2];G=-+g[d+352>>2];g[d+240>>2]=-+g[d+320>>2];g[d+244>>2]=H;g[d+248>>2]=G;g[d+252>>2]=0.0;G=+g[B+868>>2];H=+g[B+872>>2];if(!(G>H)){if(G<H){O=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[O>>2]|0)+60>>2]|0;c[d+208>>2]=0;c[d+212>>2]=0;c[d+216>>2]=0;c[d+220>>2]=0;Wb[I&0](O,C,d+240|0,d+256|0,A,A,G,H,d+208|0,1,10.0)}}else{O=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[O>>2]|0)+60>>2]|0;c[d+224>>2]=0;c[d+228>>2]=0;c[d+232>>2]=0;c[d+236>>2]=0;Wb[I&0](O,C,d+240|0,d+256|0,A,A,-3.1415927410125732,3.1415927410125732,d+224|0,0,10.0)}c[d+320>>2]=c[B+1064>>2];c[d+324>>2]=c[B+1068>>2];c[d+328>>2]=c[B+1072>>2];c[d+332>>2]=c[B+1076>>2];c[f+0>>2]=c[E+0>>2];c[f+4>>2]=c[E+4>>2];c[f+8>>2]=c[E+8>>2];c[f+12>>2]=c[E+12>>2];c[h+0>>2]=c[F+0>>2];c[h+4>>2]=c[F+4>>2];c[h+8>>2]=c[F+8>>2];c[h+12>>2]=c[F+12>>2];c[j+0>>2]=c[D+0>>2];c[j+4>>2]=c[D+4>>2];c[j+8>>2]=c[D+8>>2];c[j+12>>2]=c[D+12>>2];c[d+192>>2]=c[B+680>>2];c[d+196>>2]=c[B+684>>2];c[d+200>>2]=c[B+688>>2];c[d+204>>2]=c[B+692>>2];c[d+176>>2]=c[B+696>>2];c[d+180>>2]=c[B+700>>2];c[d+184>>2]=c[B+704>>2];c[d+188>>2]=c[B+708>>2];B=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;O=c[(c[B>>2]|0)+72>>2]|0;c[d+160>>2]=0;c[d+164>>2]=0;c[d+168>>2]=0;c[d+172>>2]=0;Jb[O&31](B,d+192|0,d+176|0,d+320|0,d+160|0);B=z;continue b};case 7:{c[d+96>>2]=c[B+824>>2];c[d+100>>2]=c[B+828>>2];c[d+104>>2]=c[B+832>>2];c[d+108>>2]=c[B+836>>2];c[k+0>>2]=c[B+840>>2];c[k+4>>2]=c[B+844>>2];c[k+8>>2]=c[B+848>>2];c[k+12>>2]=c[B+852>>2];c[l+0>>2]=c[B+856>>2];c[l+4>>2]=c[B+860>>2];c[l+8>>2]=c[B+864>>2];c[l+12>>2]=c[B+868>>2];c[m+0>>2]=c[B+872>>2];c[m+4>>2]=c[B+876>>2];c[m+8>>2]=c[B+880>>2];c[m+12>>2]=c[B+884>>2];if(!(I&1)){c[d+96>>2]=c[B+888>>2];c[d+100>>2]=c[B+892>>2];c[d+104>>2]=c[B+896>>2];c[d+108>>2]=c[B+900>>2];c[k+0>>2]=c[B+904>>2];c[k+4>>2]=c[B+908>>2];c[k+8>>2]=c[B+912>>2];c[k+12>>2]=c[B+916>>2];c[l+0>>2]=c[B+920>>2];c[l+4>>2]=c[B+924>>2];c[l+8>>2]=c[B+928>>2];c[l+12>>2]=c[B+932>>2];c[m+0>>2]=c[B+936>>2];c[m+4>>2]=c[B+940>>2];c[m+8>>2]=c[B+944>>2];c[m+12>>2]=c[B+948>>2]}else{O=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[O>>2]|0)+56>>2]&7](O,d+96|0,A);c[d+96>>2]=c[B+888>>2];c[d+100>>2]=c[B+892>>2];c[d+104>>2]=c[B+896>>2];c[d+108>>2]=c[B+900>>2];c[k+0>>2]=c[B+904>>2];c[k+4>>2]=c[B+908>>2];c[k+8>>2]=c[B+912>>2];c[k+12>>2]=c[B+916>>2];c[l+0>>2]=c[B+920>>2];c[l+4>>2]=c[B+924>>2];c[l+8>>2]=c[B+928>>2];c[l+12>>2]=c[B+932>>2];c[m+0>>2]=c[B+936>>2];c[m+4>>2]=c[B+940>>2];c[m+8>>2]=c[B+944>>2];c[m+12>>2]=c[B+948>>2];O=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;tc[c[(c[O>>2]|0)+56>>2]&7](O,d+96|0,A)}if(!(C&1)){B=z;continue b}O=(a[B+180>>0]|0)!=0?B+824|0:B+888|0;H=+g[O>>2];L=+g[O+4>>2];J=+g[O+16>>2];N=+g[O+20>>2];K=+g[O+32>>2];M=+g[O+36>>2];W=+g[O+48>>2];U=+g[O+52>>2];Q=+g[O+56>>2];G=+g[B+184>>2];V=+g[O+8>>2]*0.0;R=+g[O+24>>2]*0.0;P=+g[O+40>>2]*0.0;g[d+80>>2]=W+(V+(L*0.0+H*G));g[d+84>>2]=U+(R+(N*0.0+J*G));g[d+88>>2]=Q+(P+(M*0.0+K*G));g[d+92>>2]=0.0;G=+g[B+188>>2];g[d+64>>2]=W+(V+(L*0.0+H*G));g[d+68>>2]=U+(R+(N*0.0+J*G));g[d+72>>2]=Q+(P+(M*0.0+K*G));g[d+76>>2]=0.0;O=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[O>>2]|0)+8>>2]|0;c[d+48>>2]=0;c[d+52>>2]=0;c[d+56>>2]=0;c[d+60>>2]=0;vc[I&127](O,d+80|0,d+64|0,d+48|0);g[d+32>>2]=H;g[d+36>>2]=J;g[d+40>>2]=K;g[d+44>>2]=0.0;g[d+16>>2]=L;g[d+20>>2]=N;g[d+24>>2]=M;g[d+28>>2]=0.0;M=+g[B+192>>2];N=+g[B+196>>2];O=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;I=c[(c[O>>2]|0)+60>>2]|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;Wb[I&0](O,B+936|0,d+32|0,d+16|0,A,A,M,N,d,1,10.0);B=z;continue b};default:{B=z;continue b}}}}while(0);if(((((Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(O=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Pb[c[(c[O>>2]|0)+48>>2]&127](O)|0)&16387|0)!=0):0)?(Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0:0)?(O=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0,(Pb[c[(c[O>>2]|0)+48>>2]&127](O)|0)!=0):0)?(c[b+280>>2]|0)>0:0){e=0;do{O=c[(c[b+288>>2]|0)+(e<<2)>>2]|0;Nb[c[(c[O>>2]|0)+12>>2]&127](O,c[b+72>>2]|0);e=e+1|0}while((e|0)<(c[b+280>>2]|0))}b=c[5022]|0;O=(c[b+16>>2]|0)+ -1|0;c[b+16>>2]=O;if(O){i=d;return}do if(c[b+4>>2]|0){Eb(d+1008|0,0)|0;O=c[5008]|0;g[b+8>>2]=+(((c[d+1012>>2]|0)-(c[O+4>>2]|0)+(((c[d+1008>>2]|0)-(c[O>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5022]|0;break}else{i=d;return}}while(0);c[5022]=c[b+20>>2];i=d;return}function Ro(a){a=a|0;var b=0,d=0,e=0;b=i;if((c[a+232>>2]|0)<=0){i=b;return}d=0;do{e=(c[(c[a+240>>2]|0)+(d<<2)>>2]|0)+412|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;d=d+1|0}while((d|0)<(c[a+232>>2]|0));i=b;return}function So(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0.0,k=0.0;b=i;d=c[a+232>>2]|0;if((d|0)<=0){i=b;return}a=c[a+240>>2]|0;e=0;do{f=c[a+(e<<2)>>2]|0;h=c[f+216>>2]|0;if(!((h|0)==2|(h|0)==5)?(c[f+204>>2]&3|0)==0:0){k=+g[f+368>>2]*+g[f+352>>2];j=+g[f+372>>2]*+g[f+356>>2];g[f+412>>2]=+g[f+364>>2]*+g[f+348>>2]+ +g[f+412>>2];g[f+416>>2]=k+ +g[f+416>>2];g[f+420>>2]=j+ +g[f+420>>2]}e=e+1|0}while((e|0)<(d|0));i=b;return}function To(b){b=b|0;var d=0,e=0.0,f=0.0,h=0,j=0,k=0,l=0;d=i;i=i+144|0;yE(1592);if(!(a[b+274>>0]|0)){k=c[b+232>>2]|0;if((k|0)>0){h=0;do{j=c[(c[b+240>>2]|0)+(h<<2)>>2]|0;l=c[j+216>>2]|0;if((!((l|0)==2|(l|0)==5)?(c[j+480>>2]|0)!=0:0)?(c[j+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(e=+g[b+268>>2],e!=0.0):0)f=+g[b+264>>2]-e;else f=+g[b+264>>2]*+g[j+244>>2];Bo(j+68|0,+g[j+132>>2],+g[j+136>>2],+g[j+140>>2],j+148|0,f,d);k=c[j+480>>2]|0;Nb[c[(c[k>>2]|0)+12>>2]&127](k,d);k=c[b+232>>2]|0}h=h+1|0}while((h|0)<(k|0))}}else{k=c[b+8>>2]|0;if((k|0)>0){h=0;do{j=c[(c[b+16>>2]|0)+(h<<2)>>2]|0;if((!((j|0)==0?1:(c[j+236>>2]&2|0)==0)?(c[j+480>>2]|0)!=0:0)?(c[j+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(f=+g[b+268>>2],f!=0.0):0)e=+g[b+264>>2]-f;else e=+g[b+264>>2]*+g[j+244>>2];Bo(j+68|0,+g[j+132>>2],+g[j+136>>2],+g[j+140>>2],j+148|0,e,d+64|0);k=c[j+480>>2]|0;Nb[c[(c[k>>2]|0)+12>>2]&127](k,d+64|0);k=c[b+8>>2]|0}h=h+1|0}while((h|0)<(k|0))}}b=c[5022]|0;l=(c[b+16>>2]|0)+ -1|0;c[b+16>>2]=l;if(l){i=d;return}do if(c[b+4>>2]|0){Eb(d+128|0,0)|0;l=c[5008]|0;g[b+8>>2]=+(((c[d+132>>2]|0)-(c[l+4>>2]|0)+(((c[d+128>>2]|0)-(c[l>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5022]|0;break}else{i=d;return}}while(0);c[5022]=c[b+20>>2];i=d;return}function Uo(b,d,e,f){b=b|0;d=+d;e=e|0;f=+f;var h=0,j=0,k=0.0,l=0;h=i;i=i+16|0;Eb(c[5008]|0,0)|0;xE(20040);c[5011]=(c[5011]|0)+1;l=c[5014]|0;c[5014]=l+1;if(!l){Eb(h|0,0)|0;l=c[5008]|0;c[5013]=(c[h+4>>2]|0)-(c[l+4>>2]|0)+(((c[h>>2]|0)-(c[l>>2]|0)|0)*1e6|0)}c[5024]=0;Eb(h|0,0)|0;yE(1616);if(e){g[b+268>>2]=f;k=+g[b+264>>2]+d;g[b+264>>2]=k;if(!(k>=f)){d=f;j=0}else{g[b+264>>2]=k- +(~~(k/f)|0)*f;d=f;j=~~(k/f)}}else{g[b+264>>2]=(a[b+300>>0]|0)!=0?0.0:d;g[b+268>>2]=0.0;j=!(+P(+d)<1.1920928955078125e-7)&1;e=j}if(Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0){l=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;a[3896]=(Pb[c[(c[l>>2]|0)+48>>2]&127](l)|0)>>>4&1}if(j){e=(j|0)>(e|0)?e:j;Kb[c[(c[b>>2]|0)+164>>2]&31](b,d*+(e|0));Lb[c[(c[b>>2]|0)+168>>2]&511](b);if((e|0)>0){l=0;do{Kb[c[(c[b>>2]|0)+160>>2]&31](b,d);Lb[c[(c[b>>2]|0)+80>>2]&511](b);l=l+1|0}while((l|0)<(e|0))}}else Lb[c[(c[b>>2]|0)+80>>2]&511](b);Lb[c[(c[b>>2]|0)+120>>2]&511](b);c[5024]=(c[5024]|0)+1;b=c[5022]|0;l=(c[b+16>>2]|0)+ -1|0;c[b+16>>2]=l;if(l){i=h;return j|0}do if(c[b+4>>2]|0){Eb(h|0,0)|0;l=c[5008]|0;g[b+8>>2]=+(((c[h+4>>2]|0)-(c[l+4>>2]|0)+(((c[h>>2]|0)-(c[l>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5022]|0;break}else{i=h;return j|0}}while(0);c[5022]=c[b+20>>2];i=h;return j|0}function Vo(d,e){d=d|0;e=+e;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0;f=i;i=i+464|0;yE(1632);p=c[d+84>>2]|0;if(p)Kb[p&31](d,e);Kb[c[(c[d>>2]|0)+140>>2]&31](d,e);g[d+28>>2]=e;c[d+32>>2]=0;c[d+48>>2]=Pb[c[(c[d>>2]|0)+20>>2]&127](d)|0;yE(1768);yE(1800);q=c[d+316>>2]|0;if((c[d+308>>2]|0)>0){p=0;do{C=c[d+24>>2]|0;Nb[c[(c[C>>2]|0)+16>>2]&127](C,c[q+(p<<2)>>2]|0);p=p+1|0;q=c[d+316>>2]|0}while((p|0)<(c[d+308>>2]|0))}if(q){if(a[d+320>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[q+ -4>>2]|0)}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=0;c[d+308>>2]=0;c[d+312>>2]=0;p=c[5022]|0;C=(c[p+16>>2]|0)+ -1|0;c[p+16>>2]=C;do if(!C){if(c[p+4>>2]|0){Eb(f+280|0,0)|0;C=c[5008]|0;g[p+8>>2]=+(((c[f+284>>2]|0)-(c[C+4>>2]|0)+(((c[f+280>>2]|0)-(c[C>>2]|0)|0)*1e6|0)-(c[p+12>>2]|0)|0)>>>0)/1.0e3+ +g[p+8>>2];if(c[p+16>>2]|0)break;p=c[5022]|0}c[5022]=c[p+20>>2]}while(0);if((c[d+232>>2]|0)>0){p=f+264|0;s=f+164|0;r=f+400|0;q=0;do{t=c[(c[d+240>>2]|0)+(q<<2)>>2]|0;g[t+244>>2]=1.0;C=c[t+216>>2]|0;do if(((!((C|0)==2|(C|0)==5)?(c[t+204>>2]&3|0)==0:0)?(Bo(t+4|0,+g[t+312>>2],+g[t+316>>2],+g[t+320>>2],t+328|0,e,f+216|0),l=+g[p>>2],h=l- +g[t+52>>2],m=+g[f+268>>2],j=m- +g[t+56>>2],n=+g[f+272>>2],k=n- +g[t+60>>2],(a[d+44>>0]|0)!=0):0)?(y=+g[t+252>>2],y*y!=0.0?y*y<h*h+j*j+k*k:0):0){yE(1840);if((c[(c[t+192>>2]|0)+4>>2]|0)<20){c[440]=(c[440]|0)+1;B=c[d+68>>2]|0;B=Pb[c[(c[B>>2]|0)+36>>2]&127](B)|0;C=c[d+24>>2]|0;g[f+124>>2]=1.0;b[f+128>>1]=1;b[f+130>>1]=-1;c[f+120>>2]=688;c[f+132>>2]=c[t+52>>2];c[f+136>>2]=c[t+56>>2];c[f+140>>2]=c[t+60>>2];c[f+144>>2]=c[t+64>>2];c[f+148>>2]=c[p+0>>2];c[f+152>>2]=c[p+4>>2];c[f+156>>2]=c[p+8>>2];c[f+160>>2]=c[p+12>>2];c[f+196>>2]=0;c[f+120>>2]=2160;c[f+200>>2]=t;g[f+204>>2]=0.0;c[f+208>>2]=B;c[f+212>>2]=C;w=+g[t+248>>2];c[f+72>>2]=0;g[f+76>>2]=1.0;g[f+80>>2]=1.0;g[f+84>>2]=1.0;g[f+88>>2]=0.0;c[f+64>>2]=16680;c[f+68>>2]=8;g[f+92>>2]=w;g[f+108>>2]=w;g[f+204>>2]=+g[d+56>>2];C=c[t+188>>2]|0;b[f+128>>1]=b[C+4>>1]|0;b[f+130>>1]=b[C+6>>1]|0;c[f+48>>2]=c[p+0>>2];c[f+52>>2]=c[p+4>>2];c[f+56>>2]=c[p+8>>2];c[f+60>>2]=c[p+12>>2];c[f+0>>2]=c[t+4>>2];c[f+4>>2]=c[t+8>>2];c[f+8>>2]=c[t+12>>2];c[f+12>>2]=c[t+16>>2];c[f+16>>2]=c[t+20>>2];c[f+20>>2]=c[t+24>>2];c[f+24>>2]=c[t+28>>2];c[f+28>>2]=c[t+32>>2];c[f+32>>2]=c[t+36>>2];c[f+36>>2]=c[t+40>>2];c[f+40>>2]=c[t+44>>2];c[f+44>>2]=c[t+48>>2];Ou(d,f+64|0,t+4|0,f,f+120|0,0.0);w=+g[f+124>>2];if(w<1.0){v=w*(l- +g[t+52>>2]);u=w*(m- +g[t+56>>2]);w=w*(n- +g[t+60>>2]);y=-(u*+g[f+168>>2])-v*+g[s>>2]-w*+g[f+172>>2];x=c[d+24>>2]|0;x=Yb[c[(c[x>>2]|0)+12>>2]&31](x,t,c[f+196>>2]|0)|0;A=c[d+308>>2]|0;if((A|0)==(c[d+312>>2]|0)?(o=(A|0)==0?1:A<<1,(A|0)<(o|0)):0){if(!o)z=0;else{c[5004]=(c[5004]|0)+1;z=fF((o<<2|3)+16|0)|0;if(!z)z=0;else{c[(z+19&-16)+ -4>>2]=z;z=z+19&-16}A=c[d+308>>2]|0}if((A|0)>0){B=0;do{C=z+(B<<2)|0;if(C)c[C>>2]=c[(c[d+316>>2]|0)+(B<<2)>>2];B=B+1|0}while((B|0)!=(A|0))}B=c[d+316>>2]|0;if(B){if(a[d+320>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[B+ -4>>2]|0);A=c[d+308>>2]|0}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=z;c[d+312>>2]=o}z=(c[d+316>>2]|0)+(A<<2)|0;if(z)c[z>>2]=x;c[d+308>>2]=A+1;D=v+ +g[t+52>>2];v=u+ +g[t+56>>2];w=w+ +g[t+60>>2];C=c[f+196>>2]|0;O=+g[C+4>>2];N=+g[C+20>>2];M=+g[C+36>>2];L=+g[C+8>>2];K=+g[C+24>>2];J=+g[C+40>>2];I=+g[C+12>>2];G=+g[C+28>>2];E=+g[C+44>>2];H=-+g[C+52>>2];F=-+g[C+56>>2];u=-+g[C+60>>2];c[f+280>>2]=0;c[f+284>>2]=0;c[f+288>>2]=0;c[f+292>>2]=0;g[f+296>>2]=D*O+v*N+w*M+(O*H+N*F+M*u);g[f+300>>2]=D*L+v*K+w*J+(L*H+K*F+J*u);g[f+304>>2]=D*I+v*G+w*E+(I*H+G*F+E*u);g[f+308>>2]=0.0;c[f+344>>2]=c[s+0>>2];c[f+348>>2]=c[s+4>>2];c[f+352>>2]=c[s+8>>2];c[f+356>>2]=c[s+12>>2];g[f+360>>2]=y;g[f+364>>2]=0.0;g[f+368>>2]=0.0;g[f+372>>2]=0.0;c[f+392>>2]=0;a[f+396>>0]=0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;c[r+16>>2]=0;c[r+20>>2]=0;c[r+24>>2]=0;c[r+28>>2]=0;C=wA(x,f+280|0)|0;g[x+(C*184|0)+96>>2]=0.0;y=+g[t+224>>2]*+g[(c[f+196>>2]|0)+224>>2];y=y<-10.0?-10.0:y;g[x+(C*184|0)+88>>2]=y>10.0?10.0:y;c[x+(C*184|0)+52>>2]=c[t+52>>2];c[x+(C*184|0)+56>>2]=c[t+56>>2];c[x+(C*184|0)+60>>2]=c[t+60>>2];c[x+(C*184|0)+64>>2]=c[t+64>>2];g[x+(C*184|0)+36>>2]=D;g[x+(C*184|0)+40>>2]=v;g[x+(C*184|0)+44>>2]=w;g[x+(C*184|0)+48>>2]=0.0}}t=c[5022]|0;C=(c[t+16>>2]|0)+ -1|0;c[t+16>>2]=C;if(!C){if(c[t+4>>2]|0){Eb(f+280|0,0)|0;C=c[5008]|0;g[t+8>>2]=+(((c[f+284>>2]|0)-(c[C+4>>2]|0)+(((c[f+280>>2]|0)-(c[C>>2]|0)|0)*1e6|0)-(c[t+12>>2]|0)|0)>>>0)/1.0e3+ +g[t+8>>2];if(c[t+16>>2]|0)break;t=c[5022]|0}c[5022]=c[t+20>>2]}}while(0);q=q+1|0}while((q|0)<(c[d+232>>2]|0))}o=c[5022]|0;C=(c[o+16>>2]|0)+ -1|0;c[o+16>>2]=C;do if(!C){if(c[o+4>>2]|0){Eb(f+280|0,0)|0;C=c[5008]|0;g[o+8>>2]=+(((c[f+284>>2]|0)-(c[C+4>>2]|0)+(((c[f+280>>2]|0)-(c[C>>2]|0)|0)*1e6|0)-(c[o+12>>2]|0)|0)>>>0)/1.0e3+ +g[o+8>>2];if(c[o+16>>2]|0)break;o=c[5022]|0}c[5022]=c[o+20>>2]}while(0);Lb[c[(c[d>>2]|0)+44>>2]&511](d);Lb[c[(c[d>>2]|0)+148>>2]&511](d);g[d+104>>2]=e;Nb[c[(c[d>>2]|0)+152>>2]&127](d,d+92|0);Kb[c[(c[d>>2]|0)+144>>2]&31](d,e);yE(1664);if((c[d+280>>2]|0)>0){o=0;do{C=c[(c[d+288>>2]|0)+(o<<2)>>2]|0;tc[c[(c[C>>2]|0)+8>>2]&7](C,d,e);o=o+1|0}while((o|0)<(c[d+280>>2]|0))}o=c[5022]|0;C=(c[o+16>>2]|0)+ -1|0;c[o+16>>2]=C;do if(!C){if(c[o+4>>2]|0){Eb(f+280|0,0)|0;C=c[5008]|0;g[o+8>>2]=+(((c[f+284>>2]|0)-(c[C+4>>2]|0)+(((c[f+280>>2]|0)-(c[C>>2]|0)|0)*1e6|0)-(c[o+12>>2]|0)|0)>>>0)/1.0e3+ +g[o+8>>2];if(c[o+16>>2]|0)break;o=c[5022]|0}c[5022]=c[o+20>>2]}while(0);Kb[c[(c[d>>2]|0)+156>>2]&31](d,e);o=c[d+80>>2]|0;if(o)Kb[o&31](d,e);d=c[5022]|0;C=(c[d+16>>2]|0)+ -1|0;c[d+16>>2]=C;if(C){i=f;return}do if(c[d+4>>2]|0){Eb(f+280|0,0)|0;C=c[5008]|0;g[d+8>>2]=+(((c[f+284>>2]|0)-(c[C+4>>2]|0)+(((c[f+280>>2]|0)-(c[C>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5022]|0;break}else{i=f;return}}while(0);c[5022]=c[d+20>>2];i=f;return}function Wo(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0.0,k=0,l=0.0,m=0.0;d=i;c[a+248>>2]=c[b+0>>2];c[a+252>>2]=c[b+4>>2];c[a+256>>2]=c[b+8>>2];c[a+260>>2]=c[b+12>>2];h=c[a+232>>2]|0;if((h|0)<=0){i=d;return}e=0;do{f=c[(c[a+240>>2]|0)+(e<<2)>>2]|0;k=c[f+216>>2]|0;if(!((k|0)==2|(k|0)==5)?(c[f+504>>2]&1|0)==0:0){j=+g[f+344>>2];if(j!=0.0){m=1.0/j*+g[b+4>>2];l=1.0/j*+g[b+8>>2];g[f+364>>2]=1.0/j*+g[b>>2];g[f+368>>2]=m;g[f+372>>2]=l;g[f+376>>2]=0.0}c[f+380>>2]=c[b+0>>2];c[f+384>>2]=c[b+4>>2];c[f+388>>2]=c[b+8>>2];c[f+392>>2]=c[b+12>>2];h=c[a+232>>2]|0}e=e+1|0}while((e|0)<(h|0));i=d;return}function Xo(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+0>>2]=c[b+248>>2];c[a+4>>2]=c[b+252>>2];c[a+8>>2]=c[b+256>>2];c[a+12>>2]=c[b+260>>2];i=d;return}function Yo(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;Cu(a,b,c,d);i=e;return}function Zo(a,b){a=a|0;b=b|0;var d=0;d=i;if((b|0)==0?1:(c[b+236>>2]&2|0)==0){Gu(a,b);i=d;return}else{Nb[c[(c[a>>2]|0)+92>>2]&127](a,b);i=d;return}}function _o(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;e=i;d=c[a+232>>2]|0;a:do if((d|0)>0){f=c[a+240>>2]|0;g=0;while(1){h=f+(g<<2)|0;j=g+1|0;if((c[h>>2]|0)==(b|0))break;if((j|0)<(d|0))g=j;else break a}if((g|0)<(d|0)){c[h>>2]=c[f+(d+ -1<<2)>>2];c[(c[a+240>>2]|0)+(d+ -1<<2)>>2]=b;c[a+232>>2]=d+ -1}}while(0);Gu(a,b);i=e;return}function $o(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0;e=i;h=c[d+204>>2]|0;if((h&3|0)==0?(c[d+504>>2]&1|0)==0:0){m=+g[d+344>>2];if(m!=0.0){o=1.0/m*+g[b+252>>2];n=1.0/m*+g[b+256>>2];g[d+364>>2]=1.0/m*+g[b+248>>2];g[d+368>>2]=o;g[d+372>>2]=n;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+384>>2]=c[b+252>>2];c[d+388>>2]=c[b+256>>2];c[d+392>>2]=c[b+260>>2]}if(!(c[d+192>>2]|0)){i=e;return}if(h&1){if(((c[d+216>>2]|0)+ -4|0)>>>0>=2)c[d+216>>2]=2}else{j=c[b+232>>2]|0;if((j|0)==(c[b+236>>2]|0)?(f=(j|0)==0?1:j<<1,(j|0)<(f|0)):0){if(!f)h=0;else{c[5004]=(c[5004]|0)+1;h=fF((f<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}j=c[b+232>>2]|0}if((j|0)>0){k=0;do{l=h+(k<<2)|0;if(l)c[l>>2]=c[(c[b+240>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[b+240>>2]|0;if(k){if(a[b+244>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0);j=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=h;c[b+236>>2]=f}f=(c[b+240>>2]|0)+(j<<2)|0;if(f)c[f>>2]=d;c[b+232>>2]=j+1;h=c[d+204>>2]|0}if(!(h&1))f=(h&2|0)==0;else f=0;vc[c[(c[b>>2]|0)+36>>2]&127](b,d,f?1:2,f?-1:-3);i=e;return}function ap(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0;h=i;k=c[d+204>>2]|0;if((k&3|0)==0?(c[d+504>>2]&1|0)==0:0){o=+g[d+344>>2];if(o!=0.0){q=1.0/o*+g[b+252>>2];p=1.0/o*+g[b+256>>2];g[d+364>>2]=1.0/o*+g[b+248>>2];g[d+368>>2]=q;g[d+372>>2]=p;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+384>>2]=c[b+252>>2];c[d+388>>2]=c[b+256>>2];c[d+392>>2]=c[b+260>>2]}if(!(c[d+192>>2]|0)){i=h;return}if(k&1){if(((c[d+216>>2]|0)+ -4|0)>>>0>=2)c[d+216>>2]=2}else{l=c[b+232>>2]|0;if((l|0)==(c[b+236>>2]|0)?(j=(l|0)==0?1:l<<1,(l|0)<(j|0)):0){if(!j)k=0;else{c[5004]=(c[5004]|0)+1;k=fF((j<<2|3)+16|0)|0;if(!k)k=0;else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16}l=c[b+232>>2]|0}if((l|0)>0){n=0;do{m=k+(n<<2)|0;if(m)c[m>>2]=c[(c[b+240>>2]|0)+(n<<2)>>2];n=n+1|0}while((n|0)!=(l|0))}m=c[b+240>>2]|0;if(m){if(a[b+244>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0);l=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=k;c[b+236>>2]=j}j=(c[b+240>>2]|0)+(l<<2)|0;if(j)c[j>>2]=d;c[b+232>>2]=l+1}vc[c[(c[b>>2]|0)+36>>2]&127](b,d,e,f);i=h;return}function bp(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0;e=i;i=i+16|0;yE(1680);if((c[b+232>>2]|0)>0){f=(a[3896]|0)==0;h=0;do{k=c[(c[b+240>>2]|0)+(h<<2)>>2]|0;a:do if(k){l=c[k+216>>2]|0;do if(!((l|0)==4|(l|0)==2)){p=+g[k+312>>2];o=+g[k+316>>2];n=+g[k+320>>2];m=+g[k+472>>2];if(p*p+o*o+n*n<m*m?(m=+g[k+328>>2],n=+g[k+332>>2],o=+g[k+336>>2],p=+g[k+476>>2],m*m+n*n+o*o<p*p):0){g[k+220>>2]=+g[k+220>>2]+d;j=10;break}g[k+220>>2]=0.0;if((l+ -4|0)>>>0>=2){c[k+216>>2]=0;l=0}else j=10}else j=10;while(0);if((j|0)==10){j=0;if((l|0)==4)break}do if(f){if((l+ -2|0)>>>0>=2?!(+g[k+220>>2]>2.0):0)break;if(c[k+204>>2]&3){if((l+ -4|0)>>>0<2)break a;c[k+216>>2]=2;break a}if((l|0)==1){c[k+216>>2]=3;break a}if((l|0)!=2)break a;l=(c[k+260>>2]|0)+2|0;c[k+328>>2]=0;c[k+332>>2]=0;c[k+336>>2]=0;c[k+340>>2]=0;c[k+260>>2]=l;c[k+312>>2]=0;c[k+316>>2]=0;c[k+320>>2]=0;c[k+324>>2]=0;break a}while(0);if((l+ -4|0)>>>0>=2)c[k+216>>2]=1}while(0);h=h+1|0}while((h|0)<(c[b+232>>2]|0))}b=c[5022]|0;l=(c[b+16>>2]|0)+ -1|0;c[b+16>>2]=l;if(l){i=e;return}do if(c[b+4>>2]|0){Eb(e|0,0)|0;l=c[5008]|0;g[b+8>>2]=+(((c[e+4>>2]|0)-(c[l+4>>2]|0)+(((c[e>>2]|0)-(c[l>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5022]|0;break}else{i=e;return}}while(0);c[5022]=c[b+20>>2];i=e;return}function cp(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;j=c[b+212>>2]|0;if((j|0)==(c[b+216>>2]|0)?(g=(j|0)==0?1:j<<1,(j|0)<(g|0)):0){if(!g)h=0;else{c[5004]=(c[5004]|0)+1;h=fF((g<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}j=c[b+212>>2]|0}if((j|0)>0){k=0;do{l=h+(k<<2)|0;if(l)c[l>>2]=c[(c[b+220>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[b+220>>2]|0;if(k){if(a[b+224>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0);j=c[b+212>>2]|0}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=h;c[b+216>>2]=g}g=(c[b+220>>2]|0)+(j<<2)|0;if(g)c[g>>2]=d;c[b+212>>2]=j+1;if(!e){i=f;return}pr(c[d+28>>2]|0,d);pr(c[d+32>>2]|0,d);i=f;return}function dp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;k=c[a+212>>2]|0;a:do if((k|0)>0){f=c[a+220>>2]|0;g=0;while(1){h=f+(g<<2)|0;j=g+1|0;if((c[h>>2]|0)==(b|0))break;if((j|0)<(k|0))g=j;else break a}if((g|0)<(k|0)){c[h>>2]=c[f+(k+ -1<<2)>>2];c[(c[a+220>>2]|0)+(k+ -1<<2)>>2]=b;c[a+212>>2]=k+ -1}}while(0);a=c[b+28>>2]|0;g=c[a+488>>2]|0;b:do if((g|0)>0){f=c[a+496>>2]|0;h=0;while(1){j=f+(h<<2)|0;k=h+1|0;if((c[j>>2]|0)==(b|0))break;if((k|0)<(g|0))h=k;else break b}if((h|0)<(g|0)){c[j>>2]=c[f+(g+ -1<<2)>>2];c[(c[a+496>>2]|0)+(g+ -1<<2)>>2]=b;c[a+488>>2]=g+ -1;g=g+ -1|0}}while(0);c[a+256>>2]=(g|0)>0&1;a=c[b+32>>2]|0;f=c[a+488>>2]|0;if((f|0)<=0){j=f;j=(j|0)>0;j=j&1;k=a+256|0;c[k>>2]=j;i=d;return}h=c[a+496>>2]|0;j=0;while(1){k=h+(j<<2)|0;g=j+1|0;if((c[k>>2]|0)==(b|0))break;if((g|0)<(f|0))j=g;else{e=19;break}}if((e|0)==19){j=(f|0)>0;j=j&1;k=a+256|0;c[k>>2]=j;i=d;return}if((j|0)>=(f|0)){j=f;j=(j|0)>0;j=j&1;k=a+256|0;c[k>>2]=j;i=d;return}c[k>>2]=c[h+(f+ -1<<2)>>2];c[(c[a+496>>2]|0)+(f+ -1<<2)>>2]=b;c[a+488>>2]=f+ -1;j=f+ -1|0;j=(j|0)>0;j=j&1;k=a+256|0;c[k>>2]=j;i=d;return}function ep(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;h=c[b+280>>2]|0;if((h|0)==(c[b+284>>2]|0)?(f=(h|0)==0?1:h<<1,(h|0)<(f|0)):0){if(!f)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[b+280>>2]|0}if((h|0)>0){j=0;do{k=g+(j<<2)|0;if(k)c[k>>2]=c[(c[b+288>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[b+288>>2]|0;if(j){if(a[b+292>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[b+280>>2]|0}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=g;c[b+284>>2]=f}f=(c[b+288>>2]|0)+(h<<2)|0;if(!f){k=h+1|0;c[b+280>>2]=k;i=e;return}c[f>>2]=d;k=h+1|0;c[b+280>>2]=k;i=e;return}function fp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;e=i;f=c[a+280>>2]|0;if((f|0)<=0){i=e;return}g=c[a+288>>2]|0;h=0;while(1){j=g+(h<<2)|0;k=h+1|0;if((c[j>>2]|0)==(b|0))break;if((k|0)<(f|0))h=k;else{d=7;break}}if((d|0)==7){i=e;return}if((h|0)>=(f|0)){i=e;return}c[j>>2]=c[g+(f+ -1<<2)>>2];c[(c[a+288>>2]|0)+(f+ -1<<2)>>2]=b;c[a+280>>2]=f+ -1;i=e;return}function gp(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+64>>2]&127](a,b);i=d;return}function hp(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+68>>2]&127](a,b);i=d;return}function ip(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+64>>2]&127](a,b);i=d;return}function jp(a,b){a=a|0;b=b|0;var d=0;d=i;Nb[c[(c[a>>2]|0)+68>>2]&127](a,b);i=d;return}function kp(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;e=i;i=i+16|0;yE(1704);f=c[b+212>>2]|0;h=c[b+180>>2]|0;if((h|0)<(f|0)){if((c[b+184>>2]|0)<(f|0)){if(!f){k=0;n=h}else{c[5004]=(c[5004]|0)+1;k=fF((f<<2|3)+16|0)|0;if(!k)k=0;else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16}n=c[b+180>>2]|0}if((n|0)>0){l=0;do{m=k+(l<<2)|0;if(m)c[m>>2]=c[(c[b+188>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(n|0))}l=c[b+188>>2]|0;if(l){if(a[b+192>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[b+188>>2]=0}a[b+192>>0]=1;c[b+188>>2]=k;c[b+184>>2]=f;k=b+188|0}else k=b+188|0;do{l=(c[k>>2]|0)+(h<<2)|0;if(l)c[l>>2]=0;h=h+1|0}while((h|0)!=(f|0))}c[b+180>>2]=f;f=0;while(1){if((f|0)>=(Pb[c[(c[b>>2]|0)+104>>2]&127](b)|0))break;c[(c[b+188>>2]|0)+(f<<2)>>2]=c[(c[b+220>>2]|0)+(f<<2)>>2];f=f+1|0}f=c[b+180>>2]|0;if((f|0)>1)Cp(b+176|0,0,f+ -1|0);if(!(Pb[c[(c[b>>2]|0)+104>>2]&127](b)|0))h=0;else h=c[b+188>>2]|0;f=c[b+196>>2]|0;v=c[b+180>>2]|0;k=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;c[f+4>>2]=d;c[f+12>>2]=h;c[f+16>>2]=v;c[f+20>>2]=k;k=c[f+32>>2]|0;if((k|0)<0){if((c[f+36>>2]|0)<0){h=c[f+40>>2]|0;if(h){if(a[f+44>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[f+40>>2]=0}a[f+44>>0]=1;c[f+40>>2]=0;c[f+36>>2]=0;h=k}else h=k;do{k=(c[f+40>>2]|0)+(h<<2)|0;if(k)c[k>>2]=0;h=h+1|0}while((h|0)!=0)}c[f+32>>2]=0;h=c[f+52>>2]|0;if((h|0)<0){if((c[f+56>>2]|0)<0){k=c[f+60>>2]|0;if(k){if(a[f+64>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0)}c[f+60>>2]=0}a[f+64>>0]=1;c[f+60>>2]=0;c[f+56>>2]=0}do{k=(c[f+60>>2]|0)+(h<<2)|0;if(k)c[k>>2]=0;h=h+1|0}while((h|0)!=0)}c[f+52>>2]=0;k=c[f+72>>2]|0;if((k|0)<0){if((c[f+76>>2]|0)<0){h=c[f+80>>2]|0;if(h){if(a[f+84>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[f+80>>2]=0}a[f+84>>0]=1;c[f+80>>2]=0;c[f+76>>2]=0;h=k}else h=k;do{k=(c[f+80>>2]|0)+(h<<2)|0;if(k)c[k>>2]=0;h=h+1|0}while((h|0)!=0)}c[f+72>>2]=0;f=c[b+200>>2]|0;m=c[(c[f>>2]|0)+8>>2]|0;k=c[b+8>>2]|0;h=c[b+24>>2]|0;h=Pb[c[(c[h>>2]|0)+36>>2]&127](h)|0;rc[m&127](f,k,h);h=c[b+204>>2]|0;k=c[b+24>>2]|0;f=c[b+196>>2]|0;yE(16584);m=c[h+28>>2]|0;if((m|0)<0){if((c[h+32>>2]|0)<0){l=c[h+36>>2]|0;if(l){if(a[h+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[h+36>>2]=0}a[h+40>>0]=1;c[h+36>>2]=0;c[h+32>>2]=0}do{l=(c[h+36>>2]|0)+(m<<2)|0;if(l)c[l>>2]=0;m=m+1|0}while((m|0)!=0)}c[h+28>>2]=0;l=c[h+8>>2]|0;if((l|0)>0){m=c[h+16>>2]|0;n=0;do{o=m+(n<<3)|0;q=c[o>>2]|0;if((q|0)==(n|0))r=n;else{p=o;do{r=m+(q<<3)|0;c[p>>2]=c[r>>2];r=c[r>>2]|0;p=m+(r<<3)|0;q=c[p>>2]|0}while((r|0)!=(q|0))}c[o>>2]=r;n=n+1|0}while((n|0)!=(l|0));q=c[h+8>>2]|0;if((q|0)>1){tC(h+4|0,0,q+ -1|0);q=c[h+8>>2]|0}if((q|0)>0){p=c[h+16>>2]|0;r=0;while(1){o=c[p+(r<<3)>>2]|0;m=r;do{m=m+1|0;l=(m|0)<(q|0);if(!l)break}while((c[p+(m<<3)>>2]|0)==(o|0));if((r|0)<(m|0)){n=c[b+16>>2]|0;t=1;s=r;do{u=c[n+(c[p+(s<<3)+4>>2]<<2)>>2]|0;if((c[u+208>>2]|0)==(o|0)){v=c[u+216>>2]|0;t=t&(v|0)!=1&(v|0)!=4}s=s+1|0}while((s|0)!=(m|0));if(t){do{s=c[n+(c[p+(r<<3)+4>>2]<<2)>>2]|0;if((c[s+208>>2]|0)==(o|0)?((c[s+216>>2]|0)+ -4|0)>>>0>=2:0)c[s+216>>2]=2;r=r+1|0}while((r|0)<(m|0))}else do{s=c[n+(c[p+(r<<3)+4>>2]<<2)>>2]|0;if((c[s+208>>2]|0)==(o|0)?(c[s+216>>2]|0)==2:0){c[s+216>>2]=3;g[s+220>>2]=0.0}r=r+1|0}while((r|0)<(m|0))}if(l)r=m;else break}}}m=Pb[c[(c[k>>2]|0)+36>>2]&127](k)|0;if((m|0)>0){l=0;do{n=gc[c[(c[k>>2]|0)+40>>2]&31](k,l)|0;o=c[n+740>>2]|0;p=c[n+744>>2]|0;if((o|0)!=0?(c[o+216>>2]|0)!=2:0)q=101;else q=99;if(((q|0)==99?(q=0,(p|0)!=0):0)?(c[p+216>>2]|0)!=2:0)q=101;if((q|0)==101){v=c[o+204>>2]|0;if((((v&2|0)!=0?(c[o+216>>2]|0)!=2:0)?(v&4|0)==0:0)?(c[p+204>>2]&3|0)==0:0){if(((c[p+216>>2]|0)+ -4|0)>>>0>=2)c[p+216>>2]=1;g[p+220>>2]=0.0}v=c[p+204>>2]|0;if((((v&2|0)!=0?(c[p+216>>2]|0)!=2:0)?(v&4|0)==0:0)?(c[o+204>>2]&3|0)==0:0){if(((c[o+216>>2]|0)+ -4|0)>>>0>=2)c[o+216>>2]=1;g[o+220>>2]=0.0}if((a[h+64>>0]|0)!=0?Yb[c[(c[k>>2]|0)+28>>2]&31](k,o,p)|0:0){p=c[h+28>>2]|0;if((p|0)==(c[h+32>>2]|0)?(j=(p|0)==0?1:p<<1,(p|0)<(j|0)):0){if(!j)o=0;else{c[5004]=(c[5004]|0)+1;o=fF((j<<2|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+ -4>>2]=o;o=o+19&-16}p=c[h+28>>2]|0}if((p|0)>0){r=0;do{q=o+(r<<2)|0;if(q)c[q>>2]=c[(c[h+36>>2]|0)+(r<<2)>>2];r=r+1|0}while((r|0)!=(p|0))}q=c[h+36>>2]|0;if(q){if(a[h+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[q+ -4>>2]|0);p=c[h+28>>2]|0}c[h+36>>2]=0}a[h+40>>0]=1;c[h+36>>2]=o;c[h+32>>2]=j}o=(c[h+36>>2]|0)+(p<<2)|0;if(o)c[o>>2]=n;c[h+28>>2]=p+1}}l=l+1|0}while((l|0)<(m|0))}j=c[5022]|0;v=(c[j+16>>2]|0)+ -1|0;c[j+16>>2]=v;do if(!v){if(c[j+4>>2]|0){Eb(e|0,0)|0;v=c[5008]|0;g[j+8>>2]=+(((c[e+4>>2]|0)-(c[v+4>>2]|0)+(((c[e>>2]|0)-(c[v>>2]|0)|0)*1e6|0)-(c[j+12>>2]|0)|0)>>>0)/1.0e3+ +g[j+8>>2];if(c[j+16>>2]|0)break;j=c[5022]|0}c[5022]=c[j+20>>2]}while(0);j=c[h+8>>2]|0;yE(16616);if(a[h+64>>0]|0){k=c[h+28>>2]|0;if((k|0)>1)rB(h+24|0,0,k+ -1|0);if((j|0)>0){n=1;o=0;l=0;do{r=c[h+16>>2]|0;m=c[r+(o<<3)>>2]|0;a:do if((o|0)<(j|0)){q=m;p=1;while(1){if((q|0)!=(m|0))break a;q=c[(c[b+16>>2]|0)+(c[r+(o<<3)+4>>2]<<2)>>2]|0;t=c[h+48>>2]|0;do if((t|0)==(c[h+52>>2]|0)){r=(t|0)==0?1:t<<1;if((t|0)>=(r|0))break;if(!r)s=0;else{c[5004]=(c[5004]|0)+1;s=fF((r<<2|3)+16|0)|0;if(!s)s=0;else{c[(s+19&-16)+ -4>>2]=s;s=s+19&-16}t=c[h+48>>2]|0}if((t|0)>0){u=0;do{v=s+(u<<2)|0;if(v)c[v>>2]=c[(c[h+56>>2]|0)+(u<<2)>>2];u=u+1|0}while((u|0)!=(t|0))}u=c[h+56>>2]|0;if(u){if(a[h+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[u+ -4>>2]|0);t=c[h+48>>2]|0}c[h+56>>2]=0}a[h+60>>0]=1;c[h+56>>2]=s;c[h+52>>2]=r}while(0);r=(c[h+56>>2]|0)+(t<<2)|0;if(r)c[r>>2]=q;c[h+48>>2]=t+1;v=c[q+216>>2]|0;p=p&((v|0)==2|(v|0)==5);o=o+1|0;if((o|0)>=(j|0))break a;r=c[h+16>>2]|0;q=c[r+(o<<3)>>2]|0}}else p=1;while(0);if((l|0)<(k|0)){r=c[h+36>>2]|0;q=r+(l<<2)|0;s=c[q>>2]|0;t=c[(c[s+740>>2]|0)+208>>2]|0;if((t|0)<=-1)t=c[(c[s+744>>2]|0)+208>>2]|0;if((t|0)==(m|0)){s=l;do{s=s+1|0;if((s|0)>=(k|0))break;t=c[r+(s<<2)>>2]|0;n=c[(c[t+740>>2]|0)+208>>2]|0;if((n|0)<=-1)n=c[(c[t+744>>2]|0)+208>>2]|0}while((m|0)==(n|0));n=s;r=s-l|0}else{r=0;q=0}}else{r=0;q=0}if(!p)Zb[c[(c[f>>2]|0)+8>>2]&7](f,c[h+56>>2]|0,c[h+48>>2]|0,q,r,m);l=(r|0)==0?l:n;p=c[h+48>>2]|0;if((p|0)<0){if((c[h+52>>2]|0)<0){m=c[h+56>>2]|0;if(m){if(a[h+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}c[h+56>>2]=0}a[h+60>>0]=1;c[h+56>>2]=0;c[h+52>>2]=0}do{m=(c[h+56>>2]|0)+(p<<2)|0;if(m)c[m>>2]=0;p=p+1|0}while((p|0)!=0)}c[h+48>>2]=0}while((o|0)<(j|0))}}else{u=Pb[c[(c[k>>2]|0)+44>>2]&127](k)|0;v=Pb[c[(c[k>>2]|0)+36>>2]&127](k)|0;Zb[c[(c[f>>2]|0)+8>>2]&7](f,c[b+16>>2]|0,c[b+8>>2]|0,u,v,-1)}f=c[5022]|0;v=(c[f+16>>2]|0)+ -1|0;c[f+16>>2]=v;do if(!v){if(c[f+4>>2]|0){Eb(e|0,0)|0;v=c[5008]|0;g[f+8>>2]=+(((c[e+4>>2]|0)-(c[v+4>>2]|0)+(((c[e>>2]|0)-(c[v>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5022]|0}c[5022]=c[f+20>>2]}while(0);lp(c[b+196>>2]|0);v=c[b+200>>2]|0;rc[c[(c[v>>2]|0)+16>>2]&127](v,d,c[b+72>>2]|0);b=c[5022]|0;v=(c[b+16>>2]|0)+ -1|0;c[b+16>>2]=v;if(v){i=e;return}do if(c[b+4>>2]|0){Eb(e|0,0)|0;v=c[5008]|0;g[b+8>>2]=+(((c[e+4>>2]|0)-(c[v+4>>2]|0)+(((c[e>>2]|0)-(c[v>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5022]|0;break}else{i=e;return}}while(0);c[5022]=c[b+20>>2];i=e;return}function lp(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;e=c[b+32>>2]|0;if(!e)f=0;else f=c[b+40>>2]|0;g=c[b+52>>2]|0;if(!g)h=0;else h=c[b+60>>2]|0;j=c[b+72>>2]|0;if(!j)k=0;else k=c[b+80>>2]|0;l=c[b+8>>2]|0;+ic[c[(c[l>>2]|0)+12>>2]&3](l,f,e,h,g,k,j,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);e=c[b+32>>2]|0;if((e|0)<0){if((c[b+36>>2]|0)<0){f=c[b+40>>2]|0;if(f){if(a[b+44>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+36>>2]=0}do{f=(c[b+40>>2]|0)+(e<<2)|0;if(f)c[f>>2]=0;e=e+1|0}while((e|0)!=0)}c[b+32>>2]=0;e=c[b+52>>2]|0;if((e|0)<0){if((c[b+56>>2]|0)<0){f=c[b+60>>2]|0;if(f){if(a[b+64>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+56>>2]=0}do{f=(c[b+60>>2]|0)+(e<<2)|0;if(f)c[f>>2]=0;e=e+1|0}while((e|0)!=0)}c[b+52>>2]=0;e=c[b+72>>2]|0;if((e|0)>=0){c[b+72>>2]=0;i=d;return}if((c[b+76>>2]|0)<0){f=c[b+80>>2]|0;if(f){if(a[b+84>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+76>>2]=0;f=e}else f=e;do{e=(c[b+80>>2]|0)+(f<<2)|0;if(e)c[e>>2]=0;f=f+1|0}while((f|0)!=0);c[b+72>>2]=0;i=d;return}function mp(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=i;i=i+16|0;yE(1728);p=c[b+204>>2]|0;rc[c[(c[p>>2]|0)+8>>2]&127](p,b,c[b+24>>2]|0);if((c[b+308>>2]|0)>0){h=c[b+316>>2]|0;j=0;do{k=c[h+(j<<2)>>2]|0;l=c[k+740>>2]|0;k=c[k+744>>2]|0;if(((l|0)!=0?!((k|0)==0?1:(c[l+204>>2]&3|0)!=0):0)?(c[k+204>>2]&3|0)==0:0){m=c[l+208>>2]|0;l=c[k+208>>2]|0;k=c[(c[b+204>>2]|0)+16>>2]|0;n=c[k+(m<<3)>>2]|0;if((n|0)!=(m|0)){o=k+(m<<3)|0;do{m=k+(n<<3)|0;c[o>>2]=c[m>>2];m=c[m>>2]|0;o=k+(m<<3)|0;n=c[o>>2]|0}while((m|0)!=(n|0))}n=c[k+(l<<3)>>2]|0;if((n|0)!=(l|0)){o=k+(l<<3)|0;do{l=k+(n<<3)|0;c[o>>2]=c[l>>2];l=c[l>>2]|0;o=k+(l<<3)|0;n=c[o>>2]|0}while((l|0)!=(n|0))}if((m|0)!=(l|0)){c[k+(m<<3)>>2]=l;p=k+(l<<3)+4|0;c[p>>2]=(c[p>>2]|0)+(c[k+(m<<3)+4>>2]|0)}}j=j+1|0}while((j|0)<(c[b+308>>2]|0))}h=c[b+212>>2]|0;if((h|0)>0){k=c[b+220>>2]|0;j=0;do{l=c[k+(j<<2)>>2]|0;if((((a[l+20>>0]|0)!=0?(e=c[l+28>>2]|0,f=c[l+32>>2]|0,(e|0)!=0):0)?!((f|0)==0?1:(c[e+204>>2]&3|0)!=0):0)?(c[f+204>>2]&3|0)==0:0){n=c[e+208>>2]|0;m=c[f+208>>2]|0;l=c[(c[b+204>>2]|0)+16>>2]|0;o=c[l+(n<<3)>>2]|0;if((o|0)!=(n|0)){p=l+(n<<3)|0;do{n=l+(o<<3)|0;c[p>>2]=c[n>>2];n=c[n>>2]|0;p=l+(n<<3)|0;o=c[p>>2]|0}while((n|0)!=(o|0))}o=c[l+(m<<3)>>2]|0;if((o|0)!=(m|0)){p=l+(m<<3)|0;do{m=l+(o<<3)|0;c[p>>2]=c[m>>2];m=c[m>>2]|0;p=l+(m<<3)|0;o=c[p>>2]|0}while((m|0)!=(o|0))}if((n|0)!=(m|0)){c[l+(n<<3)>>2]=m;p=l+(m<<3)+4|0;c[p>>2]=(c[p>>2]|0)+(c[l+(n<<3)+4>>2]|0)}}j=j+1|0}while((j|0)!=(h|0))}p=c[b+204>>2]|0;Nb[c[(c[p>>2]|0)+12>>2]&127](p,b);b=c[5022]|0;p=(c[b+16>>2]|0)+ -1|0;c[b+16>>2]=p;if(p){i=d;return}do if(c[b+4>>2]|0){Eb(d|0,0)|0;p=c[5008]|0;g[b+8>>2]=+(((c[d+4>>2]|0)-(c[p+4>>2]|0)+(((c[d>>2]|0)-(c[p>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5022]|0;break}else{i=d;return}}while(0);c[5022]=c[b+20>>2];i=d;return}function np(a){a=a|0;return}function op(a){a=a|0;return}function pp(d,e){d=d|0;e=+e;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0;f=i;i=i+352|0;yE(1872);if((c[d+232>>2]|0)>0){q=f+232|0;n=0;do{o=c[(c[d+240>>2]|0)+(n<<2)>>2]|0;g[o+244>>2]=1.0;A=c[o+216>>2]|0;do if(!((A|0)==2|(A|0)==5)?(c[o+204>>2]&3|0)==0:0){Bo(o+4|0,+g[o+312>>2],+g[o+316>>2],+g[o+320>>2],o+328|0,e,f+184|0);D=+g[q>>2]- +g[o+52>>2];C=+g[f+236>>2]- +g[o+56>>2];B=+g[f+240>>2]- +g[o+60>>2];if((a[d+44>>0]|0)!=0?(E=+g[o+252>>2],E*E!=0.0?E*E<D*D+C*C+B*B:0):0){yE(1896);if((c[(c[o+192>>2]|0)+4>>2]|0)<20){c[440]=(c[440]|0)+1;z=c[d+68>>2]|0;z=Pb[c[(c[z>>2]|0)+36>>2]&127](z)|0;A=c[d+24>>2]|0;g[f+252>>2]=1.0;b[f+256>>1]=1;b[f+258>>1]=-1;c[f+248>>2]=688;c[f+260>>2]=c[o+52>>2];c[f+264>>2]=c[o+56>>2];c[f+268>>2]=c[o+60>>2];c[f+272>>2]=c[o+64>>2];c[f+276>>2]=c[q+0>>2];c[f+280>>2]=c[q+4>>2];c[f+284>>2]=c[q+8>>2];c[f+288>>2]=c[q+12>>2];c[f+324>>2]=0;c[f+248>>2]=2160;c[f+328>>2]=o;g[f+332>>2]=0.0;c[f+336>>2]=z;c[f+340>>2]=A;B=+g[o+248>>2];c[f+136>>2]=0;g[f+140>>2]=1.0;g[f+144>>2]=1.0;g[f+148>>2]=1.0;g[f+152>>2]=0.0;c[f+128>>2]=16680;c[f+132>>2]=8;g[f+156>>2]=B;g[f+172>>2]=B;g[f+332>>2]=+g[d+56>>2];A=c[o+188>>2]|0;b[f+256>>1]=b[A+4>>1]|0;b[f+258>>1]=b[A+6>>1]|0;c[f+112>>2]=c[q+0>>2];c[f+116>>2]=c[q+4>>2];c[f+120>>2]=c[q+8>>2];c[f+124>>2]=c[q+12>>2];c[f+64>>2]=c[o+4>>2];c[f+68>>2]=c[o+8>>2];c[f+72>>2]=c[o+12>>2];c[f+76>>2]=c[o+16>>2];c[f+80>>2]=c[o+20>>2];c[f+84>>2]=c[o+24>>2];c[f+88>>2]=c[o+28>>2];c[f+92>>2]=c[o+32>>2];c[f+96>>2]=c[o+36>>2];c[f+100>>2]=c[o+40>>2];c[f+104>>2]=c[o+44>>2];c[f+108>>2]=c[o+48>>2];Ou(d,f+128|0,o+4|0,f+64|0,f+248|0,0.0);B=+g[f+252>>2];if(B<1.0){g[o+244>>2]=B;Bo(o+4|0,+g[o+312>>2],+g[o+316>>2],+g[o+320>>2],o+328|0,B*e,f+184|0);g[o+244>>2]=0.0;nr(o,f+184|0);r=4}else r=0;if(!r)p=11}else p=11;if((p|0)==11){p=0;r=0}s=c[5022]|0;A=(c[s+16>>2]|0)+ -1|0;c[s+16>>2]=A;do if(!A){if(c[s+4>>2]|0){Eb(f+248|0,0)|0;A=c[5008]|0;g[s+8>>2]=+(((c[f+252>>2]|0)-(c[A+4>>2]|0)+(((c[f+248>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[s+12>>2]|0)|0)>>>0)/1.0e3+ +g[s+8>>2];if(c[s+16>>2]|0)break;s=c[5022]|0}c[5022]=c[s+20>>2]}while(0);if((r|0)==4)break}nr(o,f+184|0)}while(0);n=n+1|0}while((n|0)<(c[d+232>>2]|0))}do if(a[d+275>>0]|0){yE(1920);q=c[d+308>>2]|0;if((q|0)>0){n=0;do{o=c[(c[d+316>>2]|0)+(n<<2)>>2]|0;x=c[o+740>>2]|0;if(!(c[x+236>>2]&2))x=0;p=c[o+744>>2]|0;if(!(c[p+236>>2]&2))p=0;z=c[o+748>>2]|0;if((z|0)>0){s=x+52|0;r=x+56|0;q=x+60|0;v=p+52|0;t=p+56|0;u=p+60|0;w=(p|0)==0;if(!x){x=p+228|0;y=0;do{e=+g[57]*+g[x>>2];if((e>0.0?(h=+g[o+(y*184|0)+124>>2],h!=0.0):0)?(j=e*h*+g[o+(y*184|0)+68>>2],k=e*h*+g[o+(y*184|0)+72>>2],l=e*h*+g[o+(y*184|0)+76>>2],g[f+48>>2]=-j,g[f+52>>2]=-k,g[f+56>>2]=-l,g[f+60>>2]=0.0,E=+g[o+(y*184|0)+56>>2]- +g[r>>2],D=+g[o+(y*184|0)+60>>2]- +g[q>>2],g[f+32>>2]=+g[o+(y*184|0)+52>>2]- +g[s>>2],g[f+36>>2]=E,g[f+40>>2]=D,g[f+44>>2]=0.0,D=+g[o+(y*184|0)+40>>2]- +g[t>>2],E=+g[o+(y*184|0)+44>>2]- +g[u>>2],g[f+16>>2]=+g[o+(y*184|0)+36>>2]- +g[v>>2],g[f+20>>2]=D,g[f+24>>2]=E,g[f+28>>2]=0.0,!w):0){g[f>>2]=j;g[f+4>>2]=k;g[f+8>>2]=l;g[f+12>>2]=0.0;ym(p,f,f+16|0);z=c[o+748>>2]|0}y=y+1|0}while((y|0)<(z|0))}else{z=x+228|0;A=p+228|0;y=0;do{e=+g[z>>2]*+g[A>>2];if((e>0.0?(m=+g[o+(y*184|0)+124>>2],m!=0.0):0)?(D=-(e*m*+g[o+(y*184|0)+72>>2]),E=-(e*m*+g[o+(y*184|0)+76>>2]),g[f+48>>2]=-(e*m*+g[o+(y*184|0)+68>>2]),g[f+52>>2]=D,g[f+56>>2]=E,g[f+60>>2]=0.0,E=+g[o+(y*184|0)+56>>2]- +g[r>>2],D=+g[o+(y*184|0)+60>>2]- +g[q>>2],g[f+32>>2]=+g[o+(y*184|0)+52>>2]- +g[s>>2],g[f+36>>2]=E,g[f+40>>2]=D,g[f+44>>2]=0.0,D=+g[o+(y*184|0)+40>>2]- +g[t>>2],E=+g[o+(y*184|0)+44>>2]- +g[u>>2],g[f+16>>2]=+g[o+(y*184|0)+36>>2]- +g[v>>2],g[f+20>>2]=D,g[f+24>>2]=E,g[f+28>>2]=0.0,ym(x,f+48|0,f+32|0),!w):0){D=-+g[f+52>>2];E=-+g[f+56>>2];g[f>>2]=-+g[f+48>>2];g[f+4>>2]=D;g[f+8>>2]=E;g[f+12>>2]=0.0;ym(p,f,f+16|0)}y=y+1|0}while((y|0)<(c[o+748>>2]|0))}q=c[d+308>>2]|0}n=n+1|0}while((n|0)<(q|0))}d=c[5022]|0;A=(c[d+16>>2]|0)+ -1|0;c[d+16>>2]=A;if(!A){if(c[d+4>>2]|0){Eb(f+248|0,0)|0;A=c[5008]|0;g[d+8>>2]=+(((c[f+252>>2]|0)-(c[A+4>>2]|0)+(((c[f+248>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(c[d+16>>2]|0)break;d=c[5022]|0}c[5022]=c[d+20>>2]}}while(0);d=c[5022]|0;A=(c[d+16>>2]|0)+ -1|0;c[d+16>>2]=A;if(A){i=f;return}do if(c[d+4>>2]|0){Eb(f+248|0,0)|0;A=c[5008]|0;g[d+8>>2]=+(((c[f+252>>2]|0)-(c[A+4>>2]|0)+(((c[f+248>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5022]|0;break}else{i=f;return}}while(0);c[5022]=c[d+20>>2];i=f;return}function qp(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0;e=i;i=i+16|0;yE(1960);s=c[b+232>>2]|0;if((s|0)>0){f=0;do{h=c[(c[b+240>>2]|0)+(f<<2)>>2]|0;if(!(c[h+204>>2]&3)){k=+g[h+444>>2];n=+R(+(1.0-k),+d);p=n*+g[h+312>>2];g[h+312>>2]=p;m=n*+g[h+316>>2];g[h+316>>2]=m;n=n*+g[h+320>>2];g[h+320>>2]=n;j=+g[h+448>>2];q=+R(+(1.0-j),+d);l=q*+g[h+328>>2];g[h+328>>2]=l;o=q*+g[h+332>>2];g[h+332>>2]=o;q=q*+g[h+336>>2];g[h+336>>2]=q;do if(a[h+452>>0]|0){if(q*q+(l*l+o*o)<+g[h+464>>2]?p*p+m*m+n*n<+g[h+460>>2]:0){r=+g[h+456>>2];g[h+328>>2]=l*r;g[h+332>>2]=r*o;g[h+336>>2]=r*q;g[h+312>>2]=r*p;g[h+316>>2]=r*m;g[h+320>>2]=r*n;p=r*p;m=r*m;n=r*n;l=l*r;o=r*o;q=r*q}r=+Q(+(p*p+m*m+n*n));do if(r<k)if(r>.004999999888241291){p=p-p*(1.0/r)*.004999999888241291;g[h+312>>2]=p;m=m-m*(1.0/r)*.004999999888241291;g[h+316>>2]=m;n=n-n*(1.0/r)*.004999999888241291;g[h+320>>2]=n;break}else{c[h+312>>2]=0;c[h+316>>2]=0;c[h+320>>2]=0;c[h+324>>2]=0;p=0.0;m=0.0;n=0.0;break}while(0);k=+Q(+(l*l+o*o+q*q));if(k<j)if(k>.004999999888241291){g[h+328>>2]=l-l*(1.0/k)*.004999999888241291;g[h+332>>2]=o-o*(1.0/k)*.004999999888241291;g[h+336>>2]=q-q*(1.0/k)*.004999999888241291;break}else{c[h+328>>2]=0;c[h+332>>2]=0;c[h+336>>2]=0;c[h+340>>2]=0;break}}while(0);Bo(h+4|0,p,m,n,h+328|0,d,h+68|0);s=c[b+232>>2]|0}f=f+1|0}while((f|0)<(s|0))}b=c[5022]|0;s=(c[b+16>>2]|0)+ -1|0;c[b+16>>2]=s;if(s){i=e;return}do if(c[b+4>>2]|0){Eb(e|0,0)|0;s=c[5008]|0;g[b+8>>2]=+(((c[e+4>>2]|0)-(c[s+4>>2]|0)+(((c[e>>2]|0)-(c[s>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5022]|0;break}else{i=e;return}}while(0);c[5022]=c[b+20>>2];i=e;return}function rp(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;if((a[b+273>>0]|0)!=0?(f=c[b+200>>2]|0,(f|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}a[b+273>>0]=0;c[b+200>>2]=d;c[(c[b+196>>2]|0)+8>>2]=d;i=e;return}function sp(a){a=a|0;return c[a+200>>2]|0}function tp(a){a=a|0;return c[a+212>>2]|0}function up(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function vp(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function wp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0;d=i;Lb[c[(c[b>>2]|0)+32>>2]&511](b);e=Yb[c[(c[b>>2]|0)+16>>2]&31](b,104,1)|0;f=c[e+8>>2]|0;h=f+0|0;j=h+104|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(j|0));g[f+88>>2]=+g[a+248>>2];g[f+92>>2]=+g[a+252>>2];g[f+96>>2]=+g[a+256>>2];g[f+100>>2]=+g[a+260>>2];g[f>>2]=+g[a+92>>2];g[f+4>>2]=+g[a+96>>2];g[f+8>>2]=+g[a+100>>2];g[f+12>>2]=+g[a+104>>2];g[f+16>>2]=+g[a+108>>2];g[f+20>>2]=+g[a+116>>2];g[f+24>>2]=+g[a+120>>2];g[f+28>>2]=+g[a+124>>2];g[f+32>>2]=+g[a+128>>2];g[f+36>>2]=+g[a+132>>2];g[f+40>>2]=+g[a+140>>2];g[f+44>>2]=+g[a+144>>2];g[f+48>>2]=+g[a+148>>2];g[f+52>>2]=+g[a+152>>2];g[f+56>>2]=+g[a+168>>2];g[f+60>>2]=+g[a+172>>2];c[f+64>>2]=c[a+112>>2];c[f+68>>2]=c[a+156>>2];c[f+72>>2]=c[a+160>>2];c[f+76>>2]=c[a+164>>2];c[f+80>>2]=c[a+136>>2];Jb[c[(c[b>>2]|0)+20>>2]&31](b,e,1992,1145853764,f);f=c[a+8>>2]|0;if((f|0)>0){e=0;do{h=c[(c[a+16>>2]|0)+(e<<2)>>2]|0;if(c[h+236>>2]&2){j=Pb[c[(c[h>>2]|0)+16>>2]&127](h)|0;j=Yb[c[(c[b>>2]|0)+16>>2]&31](b,j,1)|0;f=Yb[c[(c[h>>2]|0)+20>>2]&31](h,c[j+8>>2]|0,b)|0;Jb[c[(c[b>>2]|0)+20>>2]&31](b,j,f,1497645650,h);f=c[a+8>>2]|0}e=e+1|0}while((e|0)<(f|0))}if((c[a+212>>2]|0)<=0){Vu(a,b);j=c[b>>2]|0;j=j+36|0;j=c[j>>2]|0;Lb[j&511](b);i=d;return}e=0;do{j=c[(c[a+220>>2]|0)+(e<<2)>>2]|0;f=Pb[c[(c[j>>2]|0)+36>>2]&127](j)|0;f=Yb[c[(c[b>>2]|0)+16>>2]&31](b,f,1)|0;h=Yb[c[(c[j>>2]|0)+40>>2]&31](j,c[f+8>>2]|0,b)|0;Jb[c[(c[b>>2]|0)+20>>2]&31](b,f,h,1397641027,j);e=e+1|0}while((e|0)<(c[a+212>>2]|0));Vu(a,b);j=c[b>>2]|0;j=j+36|0;j=c[j>>2]|0;Lb[j&511](b);i=d;return}function xp(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function yp(a){a=a|0;return c[a+72>>2]|0}function zp(a){a=a|0;return 2}function Ap(a,b){a=a|0;b=b|0;return}function Bp(a,b){a=a|0;b=+b;var d=0,e=0,f=0;d=i;i=i+16|0;yE(1664);if((c[a+280>>2]|0)>0){e=0;do{f=c[(c[a+288>>2]|0)+(e<<2)>>2]|0;tc[c[(c[f>>2]|0)+8>>2]&7](f,a,b);e=e+1|0}while((e|0)<(c[a+280>>2]|0))}a=c[5022]|0;f=(c[a+16>>2]|0)+ -1|0;c[a+16>>2]=f;if(f){i=d;return}do if(c[a+4>>2]|0){Eb(d|0,0)|0;f=c[5008]|0;g[a+8>>2]=+(((c[d+4>>2]|0)-(c[f+4>>2]|0)+(((c[d>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[a+8>>2];if(!(c[a+16>>2]|0)){a=c[5022]|0;break}else{i=d;return}}while(0);c[5022]=c[a+20>>2];i=d;return}function Cp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;while(1){f=c[a+12>>2]|0;g=c[f+(((b+d|0)/2|0)<<2)>>2]|0;l=b;k=d;while(1){h=c[(c[g+28>>2]|0)+208>>2]|0;if((h|0)>-1)while(1){j=c[f+(l<<2)>>2]|0;m=c[(c[j+28>>2]|0)+208>>2]|0;if((m|0)<=-1)m=c[(c[j+32>>2]|0)+208>>2]|0;if((m|0)<(h|0))l=l+1|0;else break}else{m=c[(c[g+32>>2]|0)+208>>2]|0;while(1){j=c[f+(l<<2)>>2]|0;n=c[(c[j+28>>2]|0)+208>>2]|0;if((n|0)<=-1)n=c[(c[j+32>>2]|0)+208>>2]|0;if((n|0)<(m|0))l=l+1|0;else break}}if((h|0)>-1)while(1){m=c[f+(k<<2)>>2]|0;n=c[(c[m+28>>2]|0)+208>>2]|0;if((n|0)<=-1)n=c[(c[m+32>>2]|0)+208>>2]|0;if((h|0)<(n|0))k=k+ -1|0;else break}else{h=c[(c[g+32>>2]|0)+208>>2]|0;while(1){m=c[f+(k<<2)>>2]|0;n=c[(c[m+28>>2]|0)+208>>2]|0;if((n|0)<=-1)n=c[(c[m+32>>2]|0)+208>>2]|0;if((h|0)<(n|0))k=k+ -1|0;else break}}if((l|0)<=(k|0)){c[f+(l<<2)>>2]=m;c[(c[a+12>>2]|0)+(k<<2)>>2]=j;l=l+1|0;k=k+ -1|0}if((l|0)>(k|0))break;f=c[a+12>>2]|0}if((k|0)>(b|0))Cp(a,b,k);if((l|0)<(d|0))b=l;else break}i=e;return}function Dp(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Ep(a){a=a|0;return a+12|0}function Fp(a){a=a|0;return 2144}function Gp(a,b){a=a|0;b=b|0;g[a>>2]=1.0;g[a+4>>2]=1.0;g[a+8>>2]=1.0;g[a+12>>2]=0.0;return}function Hp(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function Ip(a){a=a|0;return+(+g[a+28>>2]*+g[a+12>>2])}function Jp(a){a=a|0;return 52}function Kp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;e=i;f=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=gc[c[(c[d>>2]|0)+28>>2]&31](d,f)|0;c[b>>2]=h;if(h)Nb[c[(c[d>>2]|0)+48>>2]&127](d,f);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];i=e;return 2112}function Lp(a){a=a|0;return 0}function Mp(a,b,c){a=a|0;b=b|0;c=c|0;return}function Np(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Op(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;e=i;g=c[d>>2]|0;f=c[a+80>>2]|0;if((g|0)==(f|0)){d=0;i=e;return d|0}if(!((b[a+10>>1]&b[d+4>>1])<<16>>16)){d=0;i=e;return d|0}if(!((b[d+6>>1]&b[a+8>>1])<<16>>16)){d=0;i=e;return d|0}d=c[a+92>>2]|0;d=Yb[c[(c[d>>2]|0)+28>>2]&31](d,f,g)|0;i=e;return d|0}function Pp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;e=i;f=c[b>>2]|0;if((f|0)==(c[a+80>>2]|0)){h=1.0;i=e;return+h}if(c[f+204>>2]&4){h=1.0;i=e;return+h}if((+g[a+28>>2]- +g[a+12>>2])*+g[b+8>>2]+(+g[a+32>>2]- +g[a+16>>2])*+g[b+12>>2]+(+g[a+36>>2]- +g[a+20>>2])*+g[b+16>>2]>=-+g[a+84>>2]){h=1.0;i=e;return+h}g[a+4>>2]=+g[b+40>>2];c[a+76>>2]=f;if(d){c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];c[a+52>>2]=c[b+16>>2];c[a+56>>2]=c[b+20>>2]}else{m=+g[b+8>>2];l=+g[b+12>>2];k=+g[b+16>>2];j=m*+g[f+20>>2]+l*+g[f+24>>2]+k*+g[f+28>>2];h=m*+g[f+36>>2]+l*+g[f+40>>2]+k*+g[f+44>>2];g[a+44>>2]=+g[f+4>>2]*m+ +g[f+8>>2]*l+ +g[f+12>>2]*k;g[a+48>>2]=j;g[a+52>>2]=h;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+64>>2]=c[b+28>>2];c[a+68>>2]=c[b+32>>2];c[a+72>>2]=c[b+36>>2];m=+g[b+40>>2];i=e;return+m}function Qp(a){a=a|0;var b=0;b=i;Tp(a);i=b;return}function Rp(a){a=a|0;var b=0;b=i;Tp(a);gF(a);i=b;return}function Sp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;j=i;if((h|0)<0){r=c[b+8>>2]|0;+ic[c[(c[r>>2]|0)+12>>2]&3](r,d,e,f,g,c[b+12>>2]|0,c[b+16>>2]|0,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);i=j;return}m=c[b+16>>2]|0;a:do if((m|0)>0){l=c[b+12>>2]|0;o=0;while(1){k=l+(o<<2)|0;p=c[k>>2]|0;n=c[(c[p+28>>2]|0)+208>>2]|0;if((n|0)>-1)p=n;else p=c[(c[p+32>>2]|0)+208>>2]|0;n=o+1|0;if((p|0)==(h|0))break a;if((n|0)<(m|0))o=n;else{o=n;k=0;break}}}else{o=0;k=0}while(0);if((o|0)<(m|0)){n=c[b+12>>2]|0;l=0;do{q=c[n+(o<<2)>>2]|0;p=c[(c[q+28>>2]|0)+208>>2]|0;if((p|0)<=-1)p=c[(c[q+32>>2]|0)+208>>2]|0;l=((p|0)==(h|0)&1)+l|0;o=o+1|0}while((o|0)<(m|0))}else l=0;h=c[b+4>>2]|0;if((c[h+72>>2]|0)<2){r=c[b+8>>2]|0;+ic[c[(c[r>>2]|0)+12>>2]&3](r,d,e,f,g,k,l,h,c[b+20>>2]|0,c[b+24>>2]|0);i=j;return}if((e|0)>0){o=c[b+32>>2]|0;p=c[b+36>>2]|0;h=0;while(1){m=d+(h<<2)|0;if((o|0)==(p|0)){n=(p|0)==0?1:p<<1;if((p|0)<(n|0)){if(!n)o=0;else{c[5004]=(c[5004]|0)+1;o=fF((n<<2|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+ -4>>2]=o;o=o+19&-16}p=c[b+32>>2]|0}if((p|0)>0){r=0;do{q=o+(r<<2)|0;if(q)c[q>>2]=c[(c[b+40>>2]|0)+(r<<2)>>2];r=r+1|0}while((r|0)!=(p|0))}q=c[b+40>>2]|0;if(q){if(a[b+44>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[q+ -4>>2]|0);p=c[b+32>>2]|0}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=o;c[b+36>>2]=n;o=p}else{o=p;n=p}}else n=p;p=(c[b+40>>2]|0)+(o<<2)|0;if(p)c[p>>2]=c[m>>2];o=o+1|0;c[b+32>>2]=o;h=h+1|0;if((h|0)==(e|0))break;else p=n}}if((g|0)>0){m=c[b+52>>2]|0;n=c[b+56>>2]|0;d=0;while(1){e=f+(d<<2)|0;if((m|0)==(n|0)){h=(n|0)==0?1:n<<1;if((n|0)<(h|0)){if(!h)m=0;else{c[5004]=(c[5004]|0)+1;m=fF((h<<2|3)+16|0)|0;if(!m)m=0;else{c[(m+19&-16)+ -4>>2]=m;m=m+19&-16}n=c[b+52>>2]|0}if((n|0)>0){p=0;do{o=m+(p<<2)|0;if(o)c[o>>2]=c[(c[b+60>>2]|0)+(p<<2)>>2];p=p+1|0}while((p|0)!=(n|0))}o=c[b+60>>2]|0;if(o){if(a[b+64>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[o+ -4>>2]|0);n=c[b+52>>2]|0}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=m;c[b+56>>2]=h;m=n}else{m=n;h=n}}else h=n;n=(c[b+60>>2]|0)+(m<<2)|0;if(n)c[n>>2]=c[e>>2];m=m+1|0;c[b+52>>2]=m;d=d+1|0;if((d|0)==(g|0))break;else n=h}}if((l|0)>0){e=c[b+72>>2]|0;h=c[b+76>>2]|0;f=0;while(1){g=k+(f<<2)|0;if((e|0)==(h|0)){d=(h|0)==0?1:h<<1;if((h|0)<(d|0)){if(!d)e=0;else{c[5004]=(c[5004]|0)+1;e=fF((d<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}h=c[b+72>>2]|0}if((h|0)>0){m=0;do{n=e+(m<<2)|0;if(n)c[n>>2]=c[(c[b+80>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(h|0))}m=c[b+80>>2]|0;if(m){if(a[b+84>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0);h=c[b+72>>2]|0}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=e;c[b+76>>2]=d;e=h}else{e=h;d=h}}else d=h;h=(c[b+80>>2]|0)+(e<<2)|0;if(h)c[h>>2]=c[g>>2];e=e+1|0;c[b+72>>2]=e;f=f+1|0;if((f|0)==(l|0))break;else h=d}}else e=c[b+72>>2]|0;if(((c[b+52>>2]|0)+e|0)<=(c[(c[b+4>>2]|0)+72>>2]|0)){i=j;return}lp(b);i=j;return}function Tp(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=2240;e=c[b+80>>2]|0;if(e){if(a[b+84>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+72>>2]=0;c[b+76>>2]=0;e=c[b+60>>2]|0;if(e){if(a[b+64>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;e=c[b+40>>2]|0;if(!e){a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;e=b+36|0;c[e>>2]=0;i=d;return}if(a[b+44>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+40>>2]=0;a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;e=b+36|0;c[e>>2]=0;i=d;return}function Up(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0;f=i;i=i+128|0;no(f+64|0,d,b+48|0);c[b+1064>>2]=c[f+64>>2];c[b+1068>>2]=c[f+68>>2];c[b+1072>>2]=c[f+72>>2];c[b+1076>>2]=c[f+76>>2];c[b+1080>>2]=c[f+80>>2];c[b+1084>>2]=c[f+84>>2];c[b+1088>>2]=c[f+88>>2];c[b+1092>>2]=c[f+92>>2];c[b+1096>>2]=c[f+96>>2];c[b+1100>>2]=c[f+100>>2];c[b+1104>>2]=c[f+104>>2];c[b+1108>>2]=c[f+108>>2];c[b+1112>>2]=c[f+112>>2];c[b+1116>>2]=c[f+116>>2];c[b+1120>>2]=c[f+120>>2];c[b+1124>>2]=c[f+124>>2];no(f,e,b+112|0);c[b+1128>>2]=c[f+0>>2];c[b+1132>>2]=c[f+4>>2];c[b+1136>>2]=c[f+8>>2];c[b+1140>>2]=c[f+12>>2];c[b+1144>>2]=c[f+16>>2];c[b+1148>>2]=c[f+20>>2];c[b+1152>>2]=c[f+24>>2];c[b+1156>>2]=c[f+28>>2];c[b+1160>>2]=c[f+32>>2];c[b+1164>>2]=c[f+36>>2];c[b+1168>>2]=c[f+40>>2];c[b+1172>>2]=c[f+44>>2];c[b+1176>>2]=c[f+48>>2];c[b+1180>>2]=c[f+52>>2];c[b+1184>>2]=c[f+56>>2];c[b+1188>>2]=c[f+60>>2];w=+g[b+1176>>2]- +g[b+1112>>2];x=+g[b+1180>>2]- +g[b+1116>>2];t=+g[b+1184>>2]- +g[b+1120>>2];r=+g[b+1084>>2];q=+g[b+1104>>2];m=+g[b+1088>>2];h=+g[b+1100>>2];s=+g[b+1096>>2];n=+g[b+1080>>2];o=+g[b+1064>>2];l=+g[b+1068>>2];k=+g[b+1072>>2];j=1.0/((r*q-m*h)*o+l*(m*s-q*n)+(h*n-r*s)*k);p=(h*n-r*s)*j;v=(r*q-m*h)*j*w+j*(h*k-q*l)*x+j*(m*l-r*k)*t;u=w*(m*s-q*n)*j+x*j*(q*o-s*k)+j*(n*k-m*o)*t;t=w*p+j*(s*l-h*o)*x+j*(r*o-n*l)*t;g[b+1256>>2]=v;g[b+1260>>2]=u;g[b+1264>>2]=t;g[b+1268>>2]=0.0;g[b+840>>2]=v;x=+g[b+680>>2];w=+g[b+696>>2];do if(!(x>w)){if(x>v){c[b+856>>2]=2;g[b+824>>2]=v-x;break}if(w<v){c[b+856>>2]=1;g[b+824>>2]=v-w;break}else{c[b+856>>2]=0;g[b+824>>2]=0.0;break}}else{c[b+856>>2]=0;g[b+824>>2]=0.0}while(0);g[b+844>>2]=u;w=+g[b+684>>2];v=+g[b+700>>2];do if(!(w>v)){if(w>u){c[b+860>>2]=2;g[b+828>>2]=u-w;break}if(v<u){c[b+860>>2]=1;g[b+828>>2]=u-v;break}else{c[b+860>>2]=0;g[b+828>>2]=0.0;break}}else{c[b+860>>2]=0;g[b+828>>2]=0.0}while(0);g[b+848>>2]=t;v=+g[b+688>>2];u=+g[b+704>>2];do if(!(v>u)){if(v>t){c[b+864>>2]=2;g[b+832>>2]=t-v;break}if(u<t){c[b+864>>2]=1;g[b+832>>2]=t-u;break}else{c[b+864>>2]=0;g[b+832>>2]=0.0;break}}else{c[b+864>>2]=0;g[b+832>>2]=0.0}while(0);B=+g[b+1128>>2];A=+g[b+1144>>2];w=+g[b+1160>>2];u=+g[b+1132>>2];v=+g[b+1148>>2];x=+g[b+1164>>2];C=(r*q-m*h)*j*u+j*(h*k-q*l)*v+j*(m*l-r*k)*x;t=(m*s-q*n)*j*u+j*(q*o-s*k)*v+j*(n*k-m*o)*x;z=B*p+j*(s*l-h*o)*A+j*(r*o-n*l)*w;y=p*+g[b+1136>>2]+j*(s*l-h*o)*+g[b+1152>>2]+j*(r*o-n*l)*+g[b+1168>>2];do if(z<1.0)if(z>-1.0){g[b+1192>>2]=+Y(+-(p*u+j*(s*l-h*o)*v+j*(r*o-n*l)*x),+y);C=z<-1.0?-1.0:z;g[b+1196>>2]=+W(+(C>1.0?1.0:C));g[b+1200>>2]=+Y(+-(B*(m*s-q*n)*j+A*j*(q*o-s*k)+j*(n*k-m*o)*w),+(B*(r*q-m*h)*j+A*j*(h*k-q*l)+j*(m*l-r*k)*w));break}else{g[b+1192>>2]=-+Y(+C,+t);g[b+1196>>2]=-1.5707963705062866;g[b+1200>>2]=0.0;break}else{g[b+1192>>2]=+Y(+C,+t);g[b+1196>>2]=1.5707963705062866;g[b+1200>>2]=0.0}while(0);g[b+1236>>2]=0.0;t=q*(B*q-w*k)-m*(A*k-B*m);u=k*(A*k-B*m)-q*(w*m-A*q);v=m*(w*m-A*q)-k*(B*q-w*k);g[b+1220>>2]=0.0;x=A*(A*k-B*m)-w*(B*q-w*k);y=w*(w*m-A*q)-B*(A*k-B*m);z=B*(B*q-w*k)-A*(w*m-A*q);g[b+1252>>2]=0.0;C=1.0/+Q(+(t*t+u*u+v*v));g[b+1208>>2]=t*C;g[b+1212>>2]=u*C;g[b+1216>>2]=v*C;C=1.0/+Q(+((w*m-A*q)*(w*m-A*q)+(B*q-w*k)*(B*q-w*k)+(A*k-B*m)*(A*k-B*m)));g[b+1224>>2]=(w*m-A*q)*C;g[b+1228>>2]=(B*q-w*k)*C;g[b+1232>>2]=(A*k-B*m)*C;C=1.0/+Q(+(x*x+y*y+z*z));g[b+1240>>2]=x*C;g[b+1244>>2]=y*C;g[b+1248>>2]=z*C;if(!(a[b+1301>>0]|0)){i=f;return}j=+g[(c[b+28>>2]|0)+344>>2];h=+g[(c[b+32>>2]|0)+344>>2];if(j<1.1920928955078125e-7)d=1;else d=h<1.1920928955078125e-7&1;a[b+1280>>0]=d;if(j+h>0.0){g[b+1272>>2]=h/(j+h);h=h/(j+h)}else{g[b+1272>>2]=.5;h=.5}g[b+1276>>2]=1.0-h;i=f;return}function Vp(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=+e;f=+f;h=+h;j=+j;k=+k;l=+l;var m=0,n=0;m=i;i=i+128|0;if(!b){i=m;return}n=c[a+28>>2]|0;g[m+80>>2]=+g[n+4>>2];g[m+84>>2]=+g[n+20>>2];g[m+88>>2]=+g[n+36>>2];g[m+92>>2]=0.0;g[m+96>>2]=+g[n+8>>2];g[m+100>>2]=+g[n+24>>2];g[m+104>>2]=+g[n+40>>2];g[m+108>>2]=0.0;g[m+112>>2]=+g[n+12>>2];g[m+116>>2]=+g[n+28>>2];g[m+120>>2]=+g[n+44>>2];g[m+124>>2]=0.0;a=c[a+32>>2]|0;g[m+32>>2]=+g[a+4>>2];g[m+36>>2]=+g[a+20>>2];g[m+40>>2]=+g[a+36>>2];g[m+44>>2]=0.0;g[m+48>>2]=+g[a+8>>2];g[m+52>>2]=+g[a+24>>2];g[m+56>>2]=+g[a+40>>2];g[m+60>>2]=0.0;g[m+64>>2]=+g[a+12>>2];g[m+68>>2]=+g[a+28>>2];g[m+72>>2]=+g[a+44>>2];g[m+76>>2]=0.0;f=f- +g[n+56>>2];h=h- +g[n+60>>2];g[m+16>>2]=e- +g[n+52>>2];g[m+20>>2]=f;g[m+24>>2]=h;g[m+28>>2]=0.0;k=k- +g[a+56>>2];l=l- +g[a+60>>2];g[m>>2]=j- +g[a+52>>2];g[m+4>>2]=k;g[m+8>>2]=l;g[m+12>>2]=0.0;Mo(b,m+80|0,m+32|0,m+16|0,m,d,n+396|0,+g[n+344>>2],a+396|0,+g[a+344>>2]);i=m;return}function Wp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0;e=i;if(!b){i=e;return}L=c[a+28>>2]|0;u=+g[L+4>>2];t=+g[L+20>>2];s=+g[L+36>>2];q=+g[L+8>>2];p=+g[L+24>>2];o=+g[L+40>>2];m=+g[L+12>>2];k=+g[L+28>>2];h=+g[L+44>>2];a=c[a+32>>2]|0;K=+g[a+4>>2];J=+g[a+20>>2];I=+g[a+36>>2];G=+g[a+8>>2];F=+g[a+24>>2];E=+g[a+40>>2];C=+g[a+12>>2];A=+g[a+28>>2];y=+g[a+44>>2];c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;l=+g[d>>2];j=+g[d+4>>2];f=+g[d+8>>2];g[b+16>>2]=u*l+t*j+s*f;g[b+20>>2]=q*l+p*j+o*f;g[b+24>>2]=m*l+k*j+h*f;g[b+28>>2]=0.0;B=-+g[d>>2];z=-+g[d+4>>2];x=-+g[d+8>>2];g[b+32>>2]=K*B+J*z+I*x;g[b+36>>2]=G*B+F*z+E*x;g[b+40>>2]=C*B+A*z+y*x;g[b+44>>2]=0.0;v=(u*l+t*j+s*f)*+g[L+396>>2];r=(q*l+p*j+o*f)*+g[L+400>>2];n=(m*l+k*j+h*f)*+g[L+404>>2];g[b+48>>2]=v;g[b+52>>2]=r;g[b+56>>2]=n;g[b+60>>2]=0.0;H=(K*B+J*z+I*x)*+g[a+396>>2];D=(G*B+F*z+E*x)*+g[a+400>>2];w=(C*B+A*z+y*x)*+g[a+404>>2];g[b+64>>2]=H;g[b+68>>2]=D;g[b+72>>2]=w;g[b+76>>2]=0.0;g[b+80>>2]=(K*B+J*z+I*x)*H+(G*B+F*z+E*x)*D+(C*B+A*z+y*x)*w+(v*(u*l+t*j+s*f)+r*(q*l+p*j+o*f)+n*(m*l+k*j+h*f));i=e;return}function Xp(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0;f=i;h=+Yp(+g[b+(d<<2)+1192>>2],+g[b+(d<<6)+868>>2],+g[b+(d<<6)+872>>2]);g[b+(d<<6)+920>>2]=h;j=+g[b+(d<<6)+868>>2];k=+g[b+(d<<6)+872>>2];do if(!(j>k)){if(j>h){c[b+(d<<6)+924>>2]=1;g[b+(d<<6)+916>>2]=h-j;if(h-j>3.1415927410125732){g[b+(d<<6)+916>>2]=h-j+-6.2831854820251465;break}if(!(h-j<-3.1415927410125732))break;g[b+(d<<6)+916>>2]=h-j+6.2831854820251465;break}if(!(k<h)){c[b+(d<<6)+924>>2]=0;e=14;break}c[b+(d<<6)+924>>2]=2;g[b+(d<<6)+916>>2]=h-k;if(h-k>3.1415927410125732){g[b+(d<<6)+916>>2]=h-k+-6.2831854820251465;break}if(h-k<-3.1415927410125732)g[b+(d<<6)+916>>2]=h-k+6.2831854820251465}else{c[b+(d<<6)+924>>2]=0;e=14}while(0);if((e|0)==14?(a[b+(d<<6)+912>>0]|0)==0:0){d=0;i=f;return d|0}d=1;i=f;return d|0}function Yp(a,b,c){a=+a;b=+b;c=+c;var d=0;d=i;if(b>=c){b=a;i=d;return+b}if(a<b){b=+ab(+(b-a),6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;b=+P(+b);c=+ab(+(c-a),6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;if(b<+P(+c)){b=a;i=d;return+b}b=a+6.2831854820251465;i=d;return+b}if(!(a>c)){b=a;i=d;return+b}c=+ab(+(a-c),6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;c=+P(+c);b=+ab(+(a-b),6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;if(!(+P(+b)<c)){b=a;i=d;return+b}b=a+-6.2831854820251465;i=d;return+b}function Zp(b){b=b|0;var d=0.0,e=0.0,f=0.0,h=0,j=0,k=0,l=0,m=0.0,n=0.0;h=i;i=i+16|0;if(!(a[b+1308>>0]|0)){i=h;return}g[b+928>>2]=0.0;g[b+992>>2]=0.0;g[b+1056>>2]=0.0;c[b+712>>2]=0;c[b+716>>2]=0;c[b+720>>2]=0;c[b+724>>2]=0;Up(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);Lb[c[(c[b>>2]|0)+44>>2]&511](b);d=+g[b+1284>>2];e=+g[b+1288>>2];f=+g[b+1292>>2];if(+g[b+696>>2]>=+g[b+680>>2]){if(!(a[b+1300>>0]|0)){l=b+1160|0;k=b+1144|0;j=b+1128|0}else{l=b+1096|0;k=b+1080|0;j=b+1064|0}m=+g[l>>2];n=+g[k>>2];g[h>>2]=+g[j>>2];g[h+4>>2]=n;g[h+8>>2]=m;g[h+12>>2]=0.0;Vp(b,b+176|0,h,d,e,f,d,e,f)}if(+g[b+700>>2]>=+g[b+684>>2]){if(!(a[b+1300>>0]|0)){l=b+1164|0;k=b+1148|0;j=b+1132|0}else{l=b+1100|0;k=b+1084|0;j=b+1068|0}n=+g[l>>2];m=+g[k>>2];g[h>>2]=+g[j>>2];g[h+4>>2]=m;g[h+8>>2]=n;g[h+12>>2]=0.0;Vp(b,b+260|0,h,d,e,f,d,e,f)}if(+g[b+704>>2]>=+g[b+688>>2]){if(!(a[b+1300>>0]|0)){j=b+1168|0;l=b+1152|0;k=b+1136|0}else{j=b+1104|0;l=b+1088|0;k=b+1072|0}n=+g[j>>2];m=+g[l>>2];g[h>>2]=+g[k>>2];g[h+4>>2]=m;g[h+8>>2]=n;g[h+12>>2]=0.0;Vp(b,b+344|0,h,d,e,f,d,e,f)}if(Xp(b,0)|0){c[h+0>>2]=c[b+1208>>2];c[h+4>>2]=c[b+1212>>2];c[h+8>>2]=c[b+1216>>2];c[h+12>>2]=c[b+1220>>2];Wp(b,b+428|0,h)}if(Xp(b,1)|0){c[h+0>>2]=c[b+1224>>2];c[h+4>>2]=c[b+1228>>2];c[h+8>>2]=c[b+1232>>2];c[h+12>>2]=c[b+1236>>2];Wp(b,b+512|0,h)}if(!(Xp(b,2)|0)){i=h;return}c[h+0>>2]=c[b+1240>>2];c[h+4>>2]=c[b+1244>>2];c[h+8>>2]=c[b+1248>>2];c[h+12>>2]=c[b+1252>>2];Wp(b,b+596|0,h);i=h;return}function _p(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;if(a[b+1308>>0]|0){c[d>>2]=0;c[d+4>>2]=0;i=e;return}Up(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);c[d>>2]=0;c[d+4>>2]=6;if((c[b+856>>2]|0)==0?(a[b+788>>0]|0)==0:0){g=0;f=6}else{c[d>>2]=1;c[d+4>>2]=5;g=1;f=5}if(!((c[b+860>>2]|0)==0?(a[b+789>>0]|0)==0:0)){g=g+1|0;c[d>>2]=g;f=f+ -1|0;c[d+4>>2]=f}if(!((c[b+864>>2]|0)==0?(a[b+790>>0]|0)==0:0)){c[d>>2]=g+1;c[d+4>>2]=f+ -1}if(Xp(b,0)|0){c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+ -1}if(Xp(b,1)|0){c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+ -1}if(!(Xp(b,2)|0)){i=e;return}c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+ -1;i=e;return}function $p(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;g=c[b+28>>2]|0;f=c[b+32>>2]|0;if(!(a[b+1301>>0]|0)){aq(b,d,bq(b,d,0,g+4|0,f+4|0,g+312|0,f+312|0,g+328|0,f+328|0)|0,g+4|0,f+4|0,g+312|0,f+312|0,g+328|0,f+328|0)|0;i=e;return}else{bq(b,d,aq(b,d,0,g+4|0,f+4|0,g+312|0,f+312|0,g+328|0,f+328|0)|0,g+4|0,f+4|0,g+312|0,f+312|0,g+328|0,f+328|0)|0;i=e;return}}function aq(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;o=i;i=i+16|0;n=0;do{p=b+(n<<6)+868|0;if(!((c[b+(n<<6)+924>>2]|0)==0?(a[b+(n<<6)+912>>0]|0)==0:0)){q=b+(n<<4)+1208|0;c[o+0>>2]=c[q+0>>2];c[o+4>>2]=c[q+4>>2];c[o+8>>2]=c[q+8>>2];c[o+12>>2]=c[q+12>>2];q=c[b+1304>>2]>>(n*3|0)+9;if(!(q&1))g[b+(n<<6)+896>>2]=+g[c[d+32>>2]>>2];if(!(q&2))g[b+(n<<6)+904>>2]=+g[c[d+32>>2]>>2];if(!(q&4))g[b+(n<<6)+900>>2]=+g[d+4>>2];e=(cq(b,p,f,h,j,k,l,m,d,e,o,1,0)|0)+e|0}n=n+1|0}while((n|0)!=3);i=o;return e|0}function bq(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;n=i;i=i+80|0;g[n+76>>2]=0.0;g[n+24>>2]=0.0;g[n+28>>2]=.10000000149011612;g[n+32>>2]=300.0;g[n+16>>2]=1.0;g[n+20>>2]=-1.0;g[n+44>>2]=0.0;g[n+48>>2]=.20000000298023224;g[n+52>>2]=0.0;g[n+56>>2]=0.0;g[n+36>>2]=1.0;g[n+40>>2]=.5;c[n+72>>2]=0;g[n+64>>2]=0.0;a[n+60>>0]=0;o=0;do{q=c[b+(o<<2)+856>>2]|0;p=a[b+o+788>>0]|0;do if(!((q|0)==0&p<<24>>24==0)){g[n+56>>2]=0.0;c[n+72>>2]=q;g[n+68>>2]=+g[b+(o<<2)+840>>2];g[n+64>>2]=+g[b+(o<<2)+824>>2];g[n+36>>2]=+g[b+732>>2];a[n+60>>0]=p;g[n+20>>2]=+g[b+(o<<2)+696>>2];g[n+40>>2]=+g[b+728>>2];g[n+16>>2]=+g[b+(o<<2)+680>>2];g[n+32>>2]=0.0;g[n+28>>2]=+g[b+(o<<2)+808>>2];g[n+24>>2]=+g[b+(o<<2)+792>>2];g[n>>2]=+g[b+(o<<2)+1064>>2];g[n+4>>2]=+g[b+(o<<2)+1080>>2];g[n+8>>2]=+g[b+(o<<2)+1096>>2];g[n+12>>2]=0.0;p=c[b+1304>>2]>>o*3;if(!(p&1))q=c[d+32>>2]|0;else q=b+(o<<2)+740|0;g[n+44>>2]=+g[q>>2];if(!(p&2))q=c[d+32>>2]|0;else q=b+(o<<2)+772|0;g[n+52>>2]=+g[q>>2];if(!(p&4))p=d+4|0;else p=b+(o<<2)+756|0;g[n+48>>2]=+g[p>>2];if(!(a[b+1301>>0]|0)){e=(cq(b,n+16|0,f,h,j,k,l,m,d,e,n,0,0)|0)+e|0;break}q=o+1|0;if(!(c[b+(((q|0)==3?0:q)<<6)+924>>2]|0))p=1;else p=(c[b+(((o+2|0)%3|0)<<6)+924>>2]|0)==0&1;e=(cq(b,n+16|0,f,h,j,k,l,m,d,e,n,0,p)|0)+e|0}while(0);o=o+1|0}while((o|0)!=3);i=n;return e|0}function cq(b,d,e,f,h,j,k,l,m,n,o,p,q){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;var r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0;r=i;s=aa(c[m+24>>2]|0,n)|0;u=(a[d+44>>0]|0)==0;n=c[d+56>>2]|0;if(u&(n|0)==0){f=0;i=r;return f|0}E=c[((p|0)!=0?m+12|0:m+8|0)>>2]|0;D=c[((p|0)!=0?m+20|0:m+16|0)>>2]|0;g[E+(s<<2)>>2]=+g[o>>2];g[E+(s+1<<2)>>2]=+g[o+4>>2];g[E+(s+2<<2)>>2]=+g[o+8>>2];g[D+(s<<2)>>2]=-+g[o>>2];g[D+(s+1<<2)>>2]=-+g[o+4>>2];g[D+(s+2<<2)>>2]=-+g[o+8>>2];do if(!p){v=+g[b+1176>>2];if(!(a[b+1301>>0]|0)){y=v- +g[e+48>>2];B=+g[b+1180>>2]- +g[e+52>>2];C=+g[b+1184>>2]- +g[e+56>>2];A=+g[o+8>>2];x=+g[o+4>>2];z=+g[o>>2];E=c[m+12>>2]|0;g[E+(s<<2)>>2]=B*A-C*x;g[E+(s+1<<2)>>2]=C*z-y*A;g[E+(s+2<<2)>>2]=y*x-B*z;z=+g[b+1176>>2]- +g[f+48>>2];B=+g[b+1180>>2]- +g[f+52>>2];x=+g[b+1184>>2]- +g[f+56>>2];y=+g[o+8>>2];A=+g[o+4>>2];C=+g[o>>2];E=c[m+20>>2]|0;g[E+(s<<2)>>2]=-(B*y-x*A);g[E+(s+1<<2)>>2]=-(x*C-z*y);g[E+(s+2<<2)>>2]=-(z*A-B*C);break}K=v- +g[f+48>>2];I=+g[b+1180>>2]- +g[f+52>>2];G=+g[b+1184>>2]- +g[f+56>>2];J=+g[o>>2];H=+g[o+4>>2];F=+g[o+8>>2];M=+g[b+1112>>2]- +g[e+48>>2];z=+g[b+1116>>2]- +g[e+52>>2];v=+g[b+1120>>2]- +g[e+56>>2];A=+g[d+52>>2]- +g[d+48>>2];L=J*(J*M+H*z+F*v)+J*A-J*(K*J+I*H+G*F);B=H*(J*M+H*z+F*v)+H*A-H*(K*J+I*H+G*F);A=F*(J*M+H*z+F*v)+F*A-F*(K*J+I*H+G*F);w=+g[b+1272>>2];C=+g[b+1276>>2];y=F*(z-H*(J*M+H*z+F*v)+w*B)-H*(v-F*(J*M+H*z+F*v)+w*A);x=J*(v-F*(J*M+H*z+F*v)+w*A)-F*(M-J*(J*M+H*z+F*v)+w*L);v=H*(M-J*(J*M+H*z+F*v)+w*L)-J*(z-H*(J*M+H*z+F*v)+w*B);z=F*(I-H*(K*J+I*H+G*F)-C*B)-H*(G-F*(K*J+I*H+G*F)-C*A);A=J*(G-F*(K*J+I*H+G*F)-C*A)-F*(K-J*(K*J+I*H+G*F)-C*L);B=H*(K-J*(K*J+I*H+G*F)-C*L)-J*(I-H*(K*J+I*H+G*F)-C*B);if((a[b+1280>>0]|0)!=0&(q|0)==0){z=C*z;A=C*A;B=C*B;y=w*y;x=w*x;v=w*v}E=c[m+12>>2]|0;g[E+(s<<2)>>2]=y;g[E+(s+1<<2)>>2]=x;g[E+(s+2<<2)>>2]=v;E=c[m+20>>2]|0;g[E+(s<<2)>>2]=-z;g[E+(s+1<<2)>>2]=-A;g[E+(s+2<<2)>>2]=-B}while(0);if((n|0)!=0?+g[d>>2]==+g[d+4>>2]:0){u=c[m+28>>2]|0;g[u+(s<<2)>>2]=0.0}else t=11;do if((t|0)==11){t=c[m+28>>2]|0;g[t+(s<<2)>>2]=0.0;if(!u){g[(c[m+32>>2]|0)+(s<<2)>>2]=+g[d+28>>2];if(n){u=t;break}v=+g[d+8>>2];if(p)z=v;else z=-v;x=+g[d+52>>2];y=+g[d>>2];w=+g[d+4>>2];A=+g[m>>2]*+g[d+32>>2];do if(!(y>w))if(!(y==w)){z=z/A;if(z<0.0){if(x>=y?y-z>x:0){w=(y-x)/z;break}w=x<y?0.0:1.0;break}if(z>0.0){if(x<=w?w-z<x:0){w=(w-x)/z;break}w=x>w?0.0:1.0}else w=0.0}else w=0.0;else w=1.0;while(0);g[t+(s<<2)>>2]=w*v+ +g[t+(s<<2)>>2];g[(c[m+36>>2]|0)+(s<<2)>>2]=-+g[d+12>>2];g[(c[m+40>>2]|0)+(s<<2)>>2]=+g[d+12>>2]}if(n)u=t;else{E=1;i=r;return E|0}}while(0);v=+g[m>>2]*+g[d+32>>2]*+g[d+48>>2];t=u+(s<<2)|0;w=+g[t>>2];if(p)v=w-v;else v=v+w;g[t>>2]=v;g[(c[m+32>>2]|0)+(s<<2)>>2]=+g[d+36>>2];if(+g[d>>2]==+g[d+4>>2]){g[(c[m+36>>2]|0)+(s<<2)>>2]=-3.4028234663852886e+38;g[(c[m+40>>2]|0)+(s<<2)>>2]=3.4028234663852886e+38;E=1;i=r;return E|0}u=(c[m+36>>2]|0)+(s<<2)|0;if((n|0)==1){g[u>>2]=0.0;g[(c[m+40>>2]|0)+(s<<2)>>2]=3.4028234663852886e+38}else{g[u>>2]=-3.4028234663852886e+38;g[(c[m+40>>2]|0)+(s<<2)>>2]=0.0}v=+g[d+40>>2];if(!(v>0.0)){E=1;i=r;return E|0}if(p){L=+g[o>>2];M=+g[o+4>>2];w=+g[o+8>>2];w=+g[k>>2]*L+ +g[k+4>>2]*M+ +g[k+8>>2]*w-(L*+g[l>>2]+M*+g[l+4>>2]+w*+g[l+8>>2])}else{L=+g[o>>2];M=+g[o+4>>2];w=+g[o+8>>2];w=+g[h>>2]*L+ +g[h+4>>2]*M+ +g[h+8>>2]*w-(L*+g[j>>2]+M*+g[j+4>>2]+w*+g[j+8>>2])}if((n|0)==1){if(!(w<0.0)){E=1;i=r;return E|0}v=-(w*v);if(!(+g[t>>2]<v)){E=1;i=r;return E|0}g[t>>2]=v;E=1;i=r;return E|0}else{if(!(w>0.0)){E=1;i=r;return E|0}v=-(w*v);if(!(+g[t>>2]>v)){E=1;i=r;return E|0}g[t>>2]=v;E=1;i=r;return E|0}return 0}function dq(a){a=a|0;var b=0.0,d=0.0,e=0.0,f=0.0;d=+g[(c[a+28>>2]|0)+344>>2];b=+g[(c[a+32>>2]|0)+344>>2];if(b==0.0)b=1.0;else b=d/(d+b);f=1.0-b;e=b*+g[a+1116>>2]+f*+g[a+1180>>2];d=b*+g[a+1120>>2]+f*+g[a+1184>>2];g[a+1284>>2]=b*+g[a+1112>>2]+f*+g[a+1176>>2];g[a+1288>>2]=e;g[a+1292>>2]=d;g[a+1296>>2]=0.0;return}function eq(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;f=i;if(e>>>0<3)if((b|0)==4){g[a+(e<<2)+772>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;i=f;return}else if((b|0)==2){g[a+(e<<2)+756>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;i=f;return}else if((b|0)==3){g[a+(e<<2)+740>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;i=f;return}else{i=f;return}if((e+ -3|0)>>>0>=3){i=f;return}if((b|0)==4){g[a+(e+ -3<<6)+904>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;i=f;return}else if((b|0)==2){g[a+(e+ -3<<6)+900>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;i=f;return}else if((b|0)==3){g[a+(e+ -3<<6)+896>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;i=f;return}else{i=f;return}}function fq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0;d=i;do if(c>>>0<3)if((b|0)==4){e=+g[a+(c<<2)+772>>2];break}else if((b|0)==2){e=+g[a+(c<<2)+756>>2];break}else if((b|0)==3){e=+g[a+(c<<2)+740>>2];break}else{e=0.0;break}else if((c+ -3|0)>>>0<3)if((b|0)==4){e=+g[a+(c+ -3<<6)+904>>2];break}else if((b|0)==2){e=+g[a+(c+ -3<<6)+900>>2];break}else if((b|0)==3){e=+g[a+(c+ -3<<6)+896>>2];break}else{e=0.0;break}else e=0.0;while(0);i=d;return+e}function gq(a){a=a|0;return}function hq(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function iq(a){a=a|0;return 252}function jq(a,b,e){a=a|0;b=b|0;e=e|0;var f=0;f=i;Zr(a,b,e)|0;g[b+52>>2]=+g[a+48>>2];g[b+56>>2]=+g[a+52>>2];g[b+60>>2]=+g[a+56>>2];g[b+64>>2]=+g[a+60>>2];g[b+68>>2]=+g[a+64>>2];g[b+72>>2]=+g[a+68>>2];g[b+76>>2]=+g[a+72>>2];g[b+80>>2]=+g[a+76>>2];g[b+84>>2]=+g[a+80>>2];g[b+88>>2]=+g[a+84>>2];g[b+92>>2]=+g[a+88>>2];g[b+96>>2]=+g[a+92>>2];g[b+100>>2]=+g[a+96>>2];g[b+104>>2]=+g[a+100>>2];g[b+108>>2]=+g[a+104>>2];g[b+112>>2]=+g[a+108>>2];g[b+116>>2]=+g[a+112>>2];g[b+120>>2]=+g[a+116>>2];g[b+124>>2]=+g[a+120>>2];g[b+128>>2]=+g[a+124>>2];g[b+132>>2]=+g[a+128>>2];g[b+136>>2]=+g[a+132>>2];g[b+140>>2]=+g[a+136>>2];g[b+144>>2]=+g[a+140>>2];g[b+148>>2]=+g[a+144>>2];g[b+152>>2]=+g[a+148>>2];g[b+156>>2]=+g[a+152>>2];g[b+160>>2]=+g[a+156>>2];g[b+164>>2]=+g[a+160>>2];g[b+168>>2]=+g[a+164>>2];g[b+172>>2]=+g[a+168>>2];g[b+176>>2]=+g[a+172>>2];g[b+228>>2]=+g[a+868>>2];g[b+212>>2]=+g[a+872>>2];g[b+196>>2]=+g[a+680>>2];g[b+180>>2]=+g[a+696>>2];g[b+232>>2]=+g[a+932>>2];g[b+216>>2]=+g[a+936>>2];g[b+200>>2]=+g[a+684>>2];g[b+184>>2]=+g[a+700>>2];g[b+236>>2]=+g[a+996>>2];g[b+220>>2]=+g[a+1e3>>2];g[b+204>>2]=+g[a+688>>2];g[b+188>>2]=+g[a+704>>2];c[b+244>>2]=d[a+1300>>0];c[b+248>>2]=d[a+1301>>0];i=f;return 2464}function kq(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;m=i;c[b+4>>2]=4;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3.4028234663852886e+38;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;c[b+32>>2]=e;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=2504;g[b+688>>2]=0.0;g[b+692>>2]=-1.0;g[b+696>>2]=.8999999761581421;g[b+700>>2]=.30000001192092896;g[b+704>>2]=1.0;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;a[b+736>>0]=0;a[b+737>>0]=0;a[b+738>>0]=0;a[b+739>>0]=1;a[b+740>>0]=l&1;c[b+748>>2]=0;c[b+600>>2]=c[f+0>>2];c[b+604>>2]=c[f+4>>2];c[b+608>>2]=c[f+8>>2];c[b+612>>2]=c[f+12>>2];u=+g[d+4>>2];w=+g[d+20>>2];t=+g[d+36>>2];p=+g[j>>2];x=+g[j+4>>2];v=+g[j+8>>2];do if(!(u*p+w*x+t*v>=.9999998807907104))if(!(u*p+w*x+t*v<=-.9999998807907104)){s=u*v-t*p;o=x*(t*x-w*v)-p*(u*v-t*p);r=w*p-u*x;n=v*(u*v-t*p)-x*(w*p-u*x);q=t*x-w*v;p=p*(w*p-u*x)-v*(t*x-w*v);break}else{s=+g[d+24>>2];o=+g[d+44>>2];r=+g[d+40>>2];n=+g[d+12>>2];q=+g[d+8>>2];p=+g[d+28>>2];break}else{s=+g[d+24>>2];o=-+g[d+44>>2];r=+g[d+40>>2];n=-+g[d+12>>2];q=+g[d+8>>2];p=-+g[d+28>>2]}while(0);g[b+552>>2]=n;g[b+556>>2]=q;g[b+560>>2]=+g[j>>2];g[b+564>>2]=0.0;g[b+568>>2]=p;g[b+572>>2]=s;g[b+576>>2]=+g[j+4>>2];g[b+580>>2]=0.0;g[b+584>>2]=o;g[b+588>>2]=r;g[b+592>>2]=+g[j+8>>2];g[b+596>>2]=0.0;t=+g[j+4>>2];s=+g[k+8>>2];u=+g[j+8>>2];q=+g[k+4>>2];r=+g[k>>2];x=+g[j>>2];do if(s*u+(t*q+r*x)<-.9999998807907104)if(+P(+u)>.7071067690849304){x=1.0/+Q(+(t*t+u*u));w=0.0;v=-(u*x);x=t*x;t=0.0;break}else{u=1.0/+Q(+(t*t+x*x));w=0.0;v=x*u;x=0.0;t=-(t*u);break}else{y=+Q(+((s*u+(t*q+r*x)+1.0)*2.0));w=y*.5;v=(u*r-s*x)*(1.0/y);x=(q*x-t*r)*(1.0/y);t=(t*s-u*q)*(1.0/y)}while(0);B=n*w+o*v-p*x;z=p*w+n*x-o*t;A=o*w+p*t-n*v;p=-(n*t)-p*v-o*x;u=-t;t=-v;v=-x;y=z*v+(w*B+p*u)-A*t;x=A*u+(w*z+p*t)-B*v;w=B*t+(w*A+p*v)-z*u;c[b+664>>2]=c[h+0>>2];c[b+668>>2]=c[h+4>>2];c[b+672>>2]=c[h+8>>2];c[b+676>>2]=c[h+12>>2];g[b+616>>2]=y;g[b+620>>2]=q*w-s*x;g[b+624>>2]=+g[k>>2];g[b+628>>2]=0.0;g[b+632>>2]=x;g[b+636>>2]=s*y-r*w;g[b+640>>2]=+g[k+4>>2];g[b+644>>2]=0.0;g[b+648>>2]=w;g[b+652>>2]=r*x-q*y;g[b+656>>2]=+g[k+8>>2];g[b+660>>2]=0.0;g[b+732>>2]=l?-1.0:1.0;i=m;return}function lq(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;Yr(b,4,d);c[b>>2]=2504;c[b+552>>2]=c[e+0>>2];c[b+556>>2]=c[e+4>>2];c[b+560>>2]=c[e+8>>2];c[b+564>>2]=c[e+12>>2];c[b+568>>2]=c[e+16>>2];c[b+572>>2]=c[e+20>>2];c[b+576>>2]=c[e+24>>2];c[b+580>>2]=c[e+28>>2];c[b+584>>2]=c[e+32>>2];c[b+588>>2]=c[e+36>>2];c[b+592>>2]=c[e+40>>2];c[b+596>>2]=c[e+44>>2];c[b+600>>2]=c[e+48>>2];c[b+604>>2]=c[e+52>>2];c[b+608>>2]=c[e+56>>2];c[b+612>>2]=c[e+60>>2];c[b+616>>2]=c[e+0>>2];c[b+620>>2]=c[e+4>>2];c[b+624>>2]=c[e+8>>2];c[b+628>>2]=c[e+12>>2];c[b+632>>2]=c[e+16>>2];c[b+636>>2]=c[e+20>>2];c[b+640>>2]=c[e+24>>2];c[b+644>>2]=c[e+28>>2];c[b+648>>2]=c[e+32>>2];c[b+652>>2]=c[e+36>>2];c[b+656>>2]=c[e+40>>2];c[b+660>>2]=c[e+44>>2];c[b+664>>2]=c[e+48>>2];c[b+668>>2]=c[e+52>>2];c[b+672>>2]=c[e+56>>2];c[b+676>>2]=c[e+60>>2];g[b+688>>2]=0.0;g[b+692>>2]=-1.0;g[b+696>>2]=.8999999761581421;g[b+700>>2]=.30000001192092896;g[b+704>>2]=1.0;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;a[b+736>>0]=0;a[b+737>>0]=0;a[b+738>>0]=0;a[b+739>>0]=1;a[b+740>>0]=f&1;c[b+748>>2]=0;d=c[b+28>>2]|0;n=+g[b+600>>2];m=+g[b+604>>2];l=+g[b+608>>2];k=n*+g[d+20>>2]+m*+g[d+24>>2]+l*+g[d+28>>2]+ +g[d+56>>2];j=n*+g[d+36>>2]+m*+g[d+40>>2]+l*+g[d+44>>2]+ +g[d+60>>2];g[b+664>>2]=n*+g[d+4>>2]+m*+g[d+8>>2]+l*+g[d+12>>2]+ +g[d+52>>2];g[b+668>>2]=k;g[b+672>>2]=j;g[b+676>>2]=0.0;g[b+732>>2]=f?-1.0:1.0;i=h;return}function mq(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0,N=0.0,O=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0;d=i;i=i+176|0;if(!(a[b+738>>0]|0)){i=d;return}g[b+36>>2]=0.0;g[b+744>>2]=0.0;a:do if(!(a[b+736>>0]|0)){L=c[b+28>>2]|0;A=+g[b+600>>2];z=+g[b+604>>2];j=+g[b+608>>2];h=A*+g[L+20>>2]+z*+g[L+24>>2]+j*+g[L+28>>2]+ +g[L+56>>2];y=c[b+32>>2]|0;l=+g[b+664>>2];m=+g[y+4>>2];n=+g[b+668>>2];o=+g[y+8>>2];p=+g[b+672>>2];q=+g[y+12>>2];s=+g[y+20>>2];t=+g[y+24>>2];u=+g[y+28>>2];e=+g[y+36>>2];x=+g[y+40>>2];w=+g[y+44>>2];r=+g[y+52>>2];v=+g[y+56>>2];f=+g[y+60>>2];B=l*s+n*t+p*u+v-h;k=A*+g[L+4>>2]+z*+g[L+8>>2]+j*+g[L+12>>2]+ +g[L+52>>2];j=A*+g[L+36>>2]+z*+g[L+40>>2]+j*+g[L+44>>2]+ +g[L+60>>2];z=l*m+n*o+p*q+r-k;A=l*e+n*x+p*w+f-j;if(z*z+B*B+A*A>1.1920928955078125e-7){K=1.0/+Q(+(z*z+B*B+A*A));g[d+128>>2]=z*K;g[d+132>>2]=B*K;g[d+136>>2]=A*K;g[d+140>>2]=0.0;A=A*K;B=B*K;z=z*K}else{g[d+128>>2]=1.0;g[d+132>>2]=0.0;g[d+136>>2]=0.0;g[d+140>>2]=0.0;A=0.0;B=0.0;z=1.0}if(+P(+A)>.7071067690849304){H=A*A+B*B;I=1.0/+Q(+H);g[d+144>>2]=0.0;K=-(I*A);g[d+148>>2]=K;J=I*B;g[d+152>>2]=J;g[d+160>>2]=H*I;g[d+164>>2]=-(z*J);g[d+168>>2]=z*K}else{J=z*z+B*B;K=1.0/+Q(+J);I=-(B*K);g[d+144>>2]=I;H=K*z;g[d+148>>2]=H;g[d+152>>2]=0.0;g[d+160>>2]=-(A*H);g[d+164>>2]=A*I;g[d+168>>2]=J*K}C=m;z=s;A=e;B=o;D=t;E=x;F=q;K=u;G=w;J=r;I=v;H=f;L=0;while(1){M=c[b+28>>2]|0;g[d+80>>2]=+g[M+4>>2];g[d+84>>2]=+g[M+20>>2];g[d+88>>2]=+g[M+36>>2];g[d+92>>2]=0.0;g[d+96>>2]=+g[M+8>>2];g[d+100>>2]=+g[M+24>>2];g[d+104>>2]=+g[M+40>>2];g[d+108>>2]=0.0;g[d+112>>2]=+g[M+12>>2];g[d+116>>2]=+g[M+28>>2];g[d+120>>2]=+g[M+44>>2];g[d+124>>2]=0.0;g[d+32>>2]=C;g[d+36>>2]=z;g[d+40>>2]=A;g[d+44>>2]=0.0;g[d+48>>2]=B;g[d+52>>2]=D;g[d+56>>2]=E;g[d+60>>2]=0.0;g[d+64>>2]=F;g[d+68>>2]=K;g[d+72>>2]=G;g[d+76>>2]=0.0;G=h- +g[M+56>>2];K=j- +g[M+60>>2];g[d+16>>2]=k- +g[M+52>>2];g[d+20>>2]=G;g[d+24>>2]=K;g[d+28>>2]=0.0;g[d>>2]=l*m+n*o+p*q+r-J;g[d+4>>2]=l*s+n*t+p*u+v-I;g[d+8>>2]=l*e+n*x+p*w+f-H;g[d+12>>2]=0.0;Mo(b+(L*84|0)+48|0,d+80|0,d+32|0,d+16|0,d,d+128+(L<<4)|0,M+396|0,+g[M+344>>2],y+396|0,+g[y+344>>2]);L=L+1|0;if((L|0)==3)break a;y=c[b+32>>2]|0;C=+g[y+4>>2];z=+g[y+20>>2];A=+g[y+36>>2];B=+g[y+8>>2];D=+g[y+24>>2];E=+g[y+40>>2];F=+g[y+12>>2];K=+g[y+28>>2];G=+g[y+44>>2];J=+g[y+52>>2];I=+g[y+56>>2];H=+g[y+60>>2]}}while(0);h=+g[b+560>>2];f=+g[b+576>>2];e=+g[b+592>>2];if(+P(+e)>.7071067690849304){j=1.0/+Q(+(f*f+e*e));o=0.0;n=-(e*j);m=f*j;l=(f*f+e*e)*j;k=-(h*f*j);j=h*-(e*j)}else{j=1.0/+Q(+(h*h+f*f));o=-(f*j);n=h*j;m=0.0;l=-(e*h*j);k=e*-(f*j);j=(h*h+f*f)*j}L=c[b+28>>2]|0;p=+g[L+4>>2];F=+g[L+8>>2];A=+g[L+12>>2];s=o*p+n*F+m*A;x=+g[L+20>>2];t=+g[L+24>>2];C=+g[L+28>>2];u=o*x+n*t+m*C;I=+g[L+36>>2];G=+g[L+40>>2];E=+g[L+44>>2];v=o*I+n*G+m*E;J=l*p+k*F+j*A;m=l*x+k*t+j*C;k=l*I+k*G+j*E;M=c[b+32>>2]|0;B=+g[M+4>>2];D=+g[M+20>>2];N=+g[M+36>>2];S=+g[M+8>>2];T=+g[M+24>>2];V=+g[M+40>>2];X=+g[M+12>>2];j=+g[M+28>>2];H=+g[M+44>>2];c[b+300>>2]=0;c[b+304>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;g[b+316>>2]=p*s+x*u+I*v;g[b+320>>2]=F*s+t*u+G*v;g[b+324>>2]=A*s+C*u+E*v;g[b+328>>2]=0.0;g[b+332>>2]=B*-s+D*-u+N*-v;g[b+336>>2]=S*-s+T*-u+V*-v;g[b+340>>2]=X*-s+j*-u+H*-v;g[b+344>>2]=0.0;o=(p*s+x*u+I*v)*+g[L+396>>2];K=(F*s+t*u+G*v)*+g[L+400>>2];q=(A*s+C*u+E*v)*+g[L+404>>2];g[b+348>>2]=o;g[b+352>>2]=K;g[b+356>>2]=q;g[b+360>>2]=0.0;R=(B*-s+D*-u+N*-v)*+g[M+396>>2];W=(S*-s+T*-u+V*-v)*+g[M+400>>2];l=(X*-s+j*-u+H*-v)*+g[M+404>>2];g[b+364>>2]=R;g[b+368>>2]=W;g[b+372>>2]=l;g[b+376>>2]=0.0;g[b+380>>2]=(B*-s+D*-u+N*-v)*R+(S*-s+T*-u+V*-v)*W+(X*-s+j*-u+H*-v)*l+(o*(p*s+x*u+I*v)+K*(F*s+t*u+G*v)+q*(A*s+C*u+E*v));M=c[b+28>>2]|0;v=+g[M+4>>2];u=+g[M+20>>2];s=+g[M+36>>2];q=+g[M+8>>2];K=+g[M+24>>2];o=+g[M+40>>2];l=+g[M+12>>2];H=+g[M+28>>2];j=+g[M+44>>2];L=c[b+32>>2]|0;X=+g[L+4>>2];W=+g[L+20>>2];V=+g[L+36>>2];T=+g[L+8>>2];S=+g[L+24>>2];R=+g[L+40>>2];N=+g[L+12>>2];D=+g[L+28>>2];B=+g[L+44>>2];c[b+384>>2]=0;c[b+388>>2]=0;c[b+392>>2]=0;c[b+396>>2]=0;g[b+400>>2]=J*v+m*u+k*s;g[b+404>>2]=J*q+m*K+k*o;g[b+408>>2]=J*l+m*H+k*j;g[b+412>>2]=0.0;g[b+416>>2]=X*-J+W*-m+V*-k;g[b+420>>2]=T*-J+S*-m+R*-k;g[b+424>>2]=N*-J+D*-m+B*-k;g[b+428>>2]=0.0;w=(J*v+m*u+k*s)*+g[M+396>>2];r=(J*q+m*K+k*o)*+g[M+400>>2];n=(J*l+m*H+k*j)*+g[M+404>>2];g[b+432>>2]=w;g[b+436>>2]=r;g[b+440>>2]=n;g[b+444>>2]=0.0;U=(X*-J+W*-m+V*-k)*+g[L+396>>2];O=(T*-J+S*-m+R*-k)*+g[L+400>>2];z=(N*-J+D*-m+B*-k)*+g[L+404>>2];g[b+448>>2]=U;g[b+452>>2]=O;g[b+456>>2]=z;g[b+460>>2]=0.0;g[b+464>>2]=(X*-J+W*-m+V*-k)*U+(T*-J+S*-m+R*-k)*O+(N*-J+D*-m+B*-k)*z+(w*(J*v+m*u+k*s)+r*(J*q+m*K+k*o)+n*(J*l+m*H+k*j));L=c[b+28>>2]|0;j=+g[L+4>>2];k=+g[L+20>>2];H=+g[L+36>>2];l=+g[L+8>>2];m=+g[L+24>>2];J=+g[L+40>>2];n=+g[L+12>>2];o=+g[L+28>>2];K=+g[L+44>>2];M=c[b+32>>2]|0;q=+g[M+4>>2];r=+g[M+20>>2];s=+g[M+36>>2];u=+g[M+8>>2];v=+g[M+24>>2];w=+g[M+40>>2];z=+g[M+12>>2];B=+g[M+28>>2];D=+g[M+44>>2];c[b+468>>2]=0;c[b+472>>2]=0;c[b+476>>2]=0;c[b+480>>2]=0;H=(p*h+F*f+A*e)*j+(x*h+t*f+C*e)*k+(I*h+G*f+E*e)*H;J=(p*h+F*f+A*e)*l+(x*h+t*f+C*e)*m+(I*h+G*f+E*e)*J;K=(p*h+F*f+A*e)*n+(x*h+t*f+C*e)*o+(I*h+G*f+E*e)*K;g[b+484>>2]=H;g[b+488>>2]=J;g[b+492>>2]=K;g[b+496>>2]=0.0;A=-(p*h+F*f+A*e);C=-(x*h+t*f+C*e);E=-(I*h+G*f+E*e);g[b+500>>2]=q*A+r*C+s*E;g[b+504>>2]=u*A+v*C+w*E;g[b+508>>2]=z*A+B*C+D*E;g[b+512>>2]=0.0;G=H*+g[L+396>>2];I=J*+g[L+400>>2];e=K*+g[L+404>>2];g[b+516>>2]=G;g[b+520>>2]=I;g[b+524>>2]=e;g[b+528>>2]=0.0;t=(q*A+r*C+s*E)*+g[M+396>>2];x=(u*A+v*C+w*E)*+g[M+400>>2];F=(z*A+B*C+D*E)*+g[M+404>>2];g[b+532>>2]=t;g[b+536>>2]=x;g[b+540>>2]=F;g[b+544>>2]=0.0;g[b+548>>2]=(q*A+r*C+s*E)*t+(u*A+v*C+w*E)*x+(z*A+B*C+D*E)*F+(G*H+I*J+e*K);g[b+724>>2]=0.0;e=+pq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);g[b+728>>2]=e;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;do if(+g[b+692>>2]>=0.0){e=+ab(+(e- +g[b+688>>2]),6.2831854820251465);if(!(e<-3.1415927410125732)){if(e>3.1415927410125732)e=e+-6.2831854820251465}else e=e+6.2831854820251465;f=+g[b+692>>2];if(e<-f){a[b+716>>0]=1;g[b+708>>2]=-(e+f);g[b+712>>2]=1.0;break}if(e>f){a[b+716>>0]=1;g[b+708>>2]=f-e;g[b+712>>2]=-1.0}}while(0);L=c[b+28>>2]|0;T=+g[b+560>>2];U=+g[b+576>>2];X=+g[b+592>>2];V=T*+g[L+4>>2]+U*+g[L+8>>2]+X*+g[L+12>>2];W=T*+g[L+20>>2]+U*+g[L+24>>2]+X*+g[L+28>>2];X=T*+g[L+36>>2]+U*+g[L+40>>2]+X*+g[L+44>>2];M=c[b+32>>2]|0;g[b+720>>2]=1.0/(V*(V*+g[L+264>>2]+W*+g[L+280>>2]+X*+g[L+296>>2])+W*(V*+g[L+268>>2]+W*+g[L+284>>2]+X*+g[L+300>>2])+X*(V*+g[L+272>>2]+W*+g[L+288>>2]+X*+g[L+304>>2])+(V*(V*+g[M+264>>2]+W*+g[M+280>>2]+X*+g[M+296>>2])+W*(V*+g[M+268>>2]+W*+g[M+284>>2]+X*+g[M+300>>2])+X*(V*+g[M+272>>2]+W*+g[M+288>>2]+X*+g[M+304>>2])));i=d;return}function nq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0;e=i;if(a[b+738>>0]|0){c[d>>2]=0;c[d+4>>2]=0;i=e;return}c[d>>2]=5;c[d+4>>2]=1;h=+pq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);g[b+728>>2]=h;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;do if(+g[b+692>>2]>=0.0){h=+ab(+(h- +g[b+688>>2]),6.2831854820251465);if(!(h<-3.1415927410125732)){if(h>3.1415927410125732)h=h+-6.2831854820251465}else h=h+6.2831854820251465;j=+g[b+692>>2];if(h<-j){a[b+716>>0]=1;g[b+708>>2]=-(h+j);g[b+712>>2]=1.0;break}if(!(h>j))if(!(a[b+716>>0]|0)){f=13;break}else break;else{a[b+716>>0]=1;g[b+708>>2]=j-h;g[b+712>>2]=-1.0;break}}else f=13;while(0);if((f|0)==13?(a[b+737>>0]|0)==0:0){i=e;return}c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+ -1;i=e;return}function oq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0,O=0.0,P=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0;e=i;i=i+256|0;f=c[b+28>>2]|0;h=c[b+32>>2]|0;n=c[d+24>>2]|0;if(!(a[b+739>>0]|0)){no(e+192|0,f+4|0,b+552|0);no(e+128|0,h+4|0,b+616|0);q=+g[e+240>>2];o=+g[e+244>>2];j=+g[e+248>>2];k=+g[e+176>>2];p=+g[e+180>>2];l=+g[e+184>>2];Y=(a[b+736>>0]|0)==0;if(Y){N=c[d+8>>2]|0;g[N>>2]=1.0;g[N+(n+1<<2)>>2]=1.0;g[N+((n<<1)+2<<2)>>2]=1.0;N=c[d+16>>2]|0;g[N>>2]=-1.0;g[N+(n+1<<2)>>2]=-1.0;g[N+((n<<1)+2<<2)>>2]=-1.0;N=n<<1;_=n+1|0;Z=(n<<1)+2|0}else{N=n<<1;_=n+1|0;Z=(n<<1)+2|0}m=q- +g[f+52>>2];V=o- +g[f+56>>2];U=j- +g[f+60>>2];X=c[d+12>>2]|0;g[X>>2]=0.0;g[X+4>>2]=U;g[X+8>>2]=-V;g[X+12>>2]=0.0;g[X+(n<<2)>>2]=-U;g[X+(_<<2)>>2]=0.0;g[X+(n+2<<2)>>2]=m;g[X+(n+3<<2)>>2]=0.0;g[X+(N<<2)>>2]=V;aa=N|1;g[X+(aa<<2)>>2]=-m;g[X+(Z<<2)>>2]=0.0;$=N+3|0;g[X+($<<2)>>2]=0.0;m=k- +g[h+52>>2];V=p- +g[h+56>>2];U=l- +g[h+60>>2];W=c[d+20>>2]|0;g[W>>2]=0.0;g[W+4>>2]=-U;g[W+8>>2]=V;g[W+12>>2]=0.0;g[W+(n<<2)>>2]=U;g[W+(_<<2)>>2]=0.0;g[W+(n+2<<2)>>2]=-m;g[W+(n+3<<2)>>2]=0.0;g[W+(N<<2)>>2]=-V;g[W+(aa<<2)>>2]=m;g[W+(Z<<2)>>2]=0.0;g[W+($<<2)>>2]=0.0;m=+g[d>>2]*+g[d+4>>2];N=c[d+28>>2]|0;if(Y){g[N>>2]=m*(k-q);g[N+(n<<2)>>2]=m*(p-o);g[N+(n<<1<<2)>>2]=m*(l-j)}l=+g[e+200>>2];k=+g[e+216>>2];j=+g[e+232>>2];M=+g[e+192>>2];O=+g[e+208>>2];L=+g[e+224>>2];R=+g[e+196>>2];T=+g[e+212>>2];P=+g[e+228>>2];n=c[d+24>>2]|0;g[X+(n*3<<2)>>2]=M;g[X+((n*3|0)+1<<2)>>2]=O;g[X+((n*3|0)+2<<2)>>2]=L;g[X+(n<<2<<2)>>2]=R;g[X+((n<<2|1)<<2)>>2]=T;g[X+((n<<2|2)<<2)>>2]=P;g[W+(n*3<<2)>>2]=-M;g[W+((n*3|0)+1<<2)>>2]=-O;g[W+((n*3|0)+2<<2)>>2]=-L;g[W+(n<<2<<2)>>2]=-R;g[W+((n<<2|1)<<2)>>2]=-T;g[W+((n<<2|2)<<2)>>2]=-P;U=+g[e+136>>2];S=+g[e+152>>2];V=+g[e+168>>2];g[N+(n*3<<2)>>2]=m*(L*(l*S-k*U)+(M*(k*V-j*S)+O*(j*U-l*V)));g[N+(n<<2<<2)>>2]=m*(P*(l*S-k*U)+(R*(k*V-j*S)+T*(j*U-l*V)));if(!(a[b+716>>0]|0))if(!(a[b+737>>0]|0)){i=e;return}else{Y=0;_=0;N=0;m=0.0}else{m=+g[b+708>>2]*+g[b+732>>2];Y=1;_=(a[b+737>>0]|0)==0;N=m>0.0?1:2}g[X+(n*5<<2)>>2]=l;g[X+((n*5|0)+1<<2)>>2]=k;g[X+((n*5|0)+2<<2)>>2]=j;g[W+(n*5<<2)>>2]=-l;g[W+((n*5|0)+1<<2)>>2]=-k;g[W+((n*5|0)+2<<2)>>2]=-j;p=+ab(+(+g[b+688>>2]- +g[b+692>>2]),6.2831854820251465);if(!(p<-3.1415927410125732)){if(p>3.1415927410125732)p=p+-6.2831854820251465}else p=p+6.2831854820251465;r=+ab(+(+g[b+688>>2]+ +g[b+692>>2]),6.2831854820251465);if(!(r<-3.1415927410125732)){if(r>3.1415927410125732)r=r+-6.2831854820251465}else r=r+6.2831854820251465;X=p==r;W=(c[d+28>>2]|0)+(n*5<<2)|0;g[W>>2]=0.0;Z=c[b+748>>2]|0;o=+g[((Z&2|0)==0?d+4|0:b+760|0)>>2];if(!(Y&X|_)){if(Z&4)g[(c[d+32>>2]|0)+(n*5<<2)>>2]=+g[b+752>>2];s=+g[b+728>>2];q=+g[b+680>>2];_=p>r;do if(!(_|X)){t=q/(o*+g[d>>2]);if(t<0.0){if(s>=p?p-t>s:0){p=(p-s)/t;break}p=s<p?0.0:1.0;break}if(t>0.0){if(s<=r?r-t<s:0){p=(r-s)/t;break}p=s>r?0.0:1.0}else p=0.0}else p=_?1.0:0.0;while(0);g[W>>2]=p*q*+g[b+732>>2]+ +g[W>>2];g[(c[d+36>>2]|0)+(n*5<<2)>>2]=-+g[b+684>>2];g[(c[d+40>>2]|0)+(n*5<<2)>>2]=+g[b+684>>2]}if(!Y){i=e;return}g[W>>2]=+g[W>>2]+m*o*+g[d>>2];if(Z&1)g[(c[d+32>>2]|0)+(n*5<<2)>>2]=+g[b+756>>2];do if(!X){X=(c[d+36>>2]|0)+(n*5<<2)|0;if((N|0)==1){g[X>>2]=0.0;g[(c[d+40>>2]|0)+(n*5<<2)>>2]=3.4028234663852886e+38;break}else{g[X>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(n*5<<2)>>2]=0.0;break}}else{g[(c[d+36>>2]|0)+(n*5<<2)>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(n*5<<2)>>2]=3.4028234663852886e+38}while(0);m=+g[b+704>>2];do if(m>0.0){j=l*+g[f+328>>2]+k*+g[f+332>>2]+j*+g[f+336>>2]-(l*+g[h+328>>2]+k*+g[h+332>>2]+j*+g[h+336>>2]);if((N|0)==1){if(!(j<0.0))break;if(!(+g[W>>2]<-(m*j)))break;g[W>>2]=-(m*j);break}else{if(!(j>0.0))break;if(!(+g[W>>2]>-(m*j)))break;g[W>>2]=-(m*j);break}}while(0);g[W>>2]=+g[b+700>>2]*+g[W>>2];i=e;return}no(e+64|0,f+4|0,b+552|0);no(e,h+4|0,b+616|0);D=+g[e+48>>2];B=+g[e+112>>2];E=+g[e+52>>2];C=+g[e+116>>2];F=+g[e+56>>2];A=+g[e+120>>2];k=+g[(c[b+28>>2]|0)+344>>2];j=+g[(c[b+32>>2]|0)+344>>2];if(k<1.1920928955078125e-7)N=1;else N=j<1.1920928955078125e-7;if(k+j>0.0)I=j/(k+j);else I=.5;L=1.0-I;q=+g[e+72>>2];p=+g[e+88>>2];t=+g[e+104>>2];r=+g[e+8>>2];s=+g[e+24>>2];o=+g[e+40>>2];m=I*q+L*r;k=I*p+L*s;j=I*t+L*o;l=1.0/+Q(+(m*m+k*k+j*j));x=D- +g[h+52>>2];P=E- +g[h+56>>2];T=F- +g[h+60>>2];y=m*l*(x*m*l+P*k*l+T*j*l);R=k*l*(x*m*l+P*k*l+T*j*l);U=j*l*(x*m*l+P*k*l+T*j*l);z=B- +g[f+52>>2];S=C- +g[f+56>>2];V=A- +g[f+60>>2];u=m*l*(m*l*z+k*l*S+j*l*V);v=k*l*(m*l*z+k*l*S+j*l*V);w=j*l*(m*l*z+k*l*S+j*l*V);H=z-u+I*(u-y);G=S-v+I*(v-R);J=V-w+I*(w-U);M=x-y-L*(u-y);K=P-R-L*(v-R);O=T-U-L*(w-U);u=I*(x-y)+L*(z-u);v=I*(P-R)+L*(S-v);w=I*(T-U)+L*(V-w);if(u*u+v*v+w*w>1.1920928955078125e-7){z=1.0/+Q(+(u*u+v*v+w*w));u=u*z;v=z*v;z=z*w}else{u=+g[e+68>>2];v=+g[e+84>>2];z=+g[e+100>>2]}y=k*l*z-j*l*v;x=j*l*u-z*m*l;w=v*m*l-k*l*u;aa=c[d+12>>2]|0;g[aa>>2]=G*z-J*v;g[aa+4>>2]=J*u-H*z;g[aa+8>>2]=H*v-G*u;aa=c[d+20>>2]|0;g[aa>>2]=-(K*z-O*v);g[aa+4>>2]=-(O*u-M*z);g[aa+8>>2]=-(M*v-K*u);if(N?(a[b+716>>0]|0)!=0:0){S=L*(K*w-O*x);R=L*(O*y-M*w);P=L*(M*x-K*y);T=I*(G*w-J*x);U=I*(J*y-H*w);V=I*(H*x-G*y)}else{S=K*w-O*x;R=O*y-M*w;P=M*x-K*y;T=G*w-J*x;U=J*y-H*w;V=H*x-G*y}aa=c[d+12>>2]|0;g[aa+(n<<2)>>2]=T;g[aa+(n+1<<2)>>2]=U;g[aa+(n+2<<2)>>2]=V;aa=c[d+20>>2]|0;g[aa+(n<<2)>>2]=-S;g[aa+(n+1<<2)>>2]=-R;g[aa+(n+2<<2)>>2]=-P;if(N){P=L*(K*j*l-O*k*l);O=L*(O*m*l-M*j*l);K=L*(M*k*l-K*m*l);L=I*(G*j*l-J*k*l);J=I*(J*m*l-H*j*l);G=I*(H*k*l-G*m*l)}else{P=K*j*l-O*k*l;O=O*m*l-M*j*l;K=M*k*l-K*m*l;L=G*j*l-J*k*l;J=J*m*l-H*j*l;G=H*k*l-G*m*l}N=c[d+12>>2]|0;g[N+(n<<1<<2)>>2]=L;g[N+((n<<1|1)<<2)>>2]=J;g[N+((n<<1)+2<<2)>>2]=G;N=c[d+20>>2]|0;g[N+(n<<1<<2)>>2]=-P;g[N+((n<<1|1)<<2)>>2]=-O;g[N+((n<<1)+2<<2)>>2]=-K;G=+g[d>>2]*+g[d+4>>2];if(!(a[b+736>>0]|0)){X=c[d+8>>2]|0;g[X>>2]=u;g[X+4>>2]=v;g[X+8>>2]=z;X=c[d+8>>2]|0;g[X+(n<<2)>>2]=y;g[X+(n+1<<2)>>2]=x;g[X+(n+2<<2)>>2]=w;X=c[d+8>>2]|0;g[X+(n<<1<<2)>>2]=m*l;g[X+((n<<1|1)<<2)>>2]=k*l;g[X+((n<<1)+2<<2)>>2]=j*l;X=c[d+16>>2]|0;V=-u;g[X>>2]=V;T=-v;g[X+4>>2]=T;U=-z;g[X+8>>2]=U;g[X+(n<<2)>>2]=-y;g[X+(n+1<<2)>>2]=-x;g[X+(n+2<<2)>>2]=-w;g[X+(n<<1<<2)>>2]=-(m*l);g[X+((n<<1|1)<<2)>>2]=-(k*l);g[X+((n<<1)+2<<2)>>2]=-(j*l);X=c[d+28>>2]|0;g[X>>2]=G*((D-B)*u+(E-C)*v+(F-A)*z);g[X+(n<<2)>>2]=G*((D-B)*y+(E-C)*x+(F-A)*w);g[X+(n<<1<<2)>>2]=G*((D-B)*m*l+(E-C)*k*l+(F-A)*j*l);B=-y;C=-x;D=-w;F=T;A=U;E=V;N=c[d+20>>2]|0}else{B=-y;C=-x;D=-w;F=-v;A=-z;E=-u;X=c[d+28>>2]|0}W=c[d+12>>2]|0;g[W+(n*3<<2)>>2]=u;g[W+((n*3|0)+1<<2)>>2]=v;g[W+((n*3|0)+2<<2)>>2]=z;g[W+(n<<2<<2)>>2]=y;g[W+((n<<2|1)<<2)>>2]=x;g[W+((n<<2|2)<<2)>>2]=w;g[N+(n*3<<2)>>2]=E;g[N+((n*3|0)+1<<2)>>2]=F;g[N+((n*3|0)+2<<2)>>2]=A;g[N+(n<<2<<2)>>2]=B;g[N+((n<<2|1)<<2)>>2]=C;g[N+((n<<2|2)<<2)>>2]=D;V=+g[d>>2]*+g[d+4>>2];g[X+(n*3<<2)>>2]=V*((p*o-t*s)*u+(t*r-q*o)*v+(q*s-p*r)*z);g[X+(n<<2<<2)>>2]=V*((p*o-t*s)*y+(t*r-q*o)*x+(q*s-p*r)*w);if(!(a[b+716>>0]|0))if(!(a[b+737>>0]|0)){i=e;return}else{Y=0;_=0;n=0;o=0.0}else{o=+g[b+708>>2]*+g[b+732>>2];Y=1;_=(a[b+737>>0]|0)==0;n=o>0.0?1:2}X=(c[d+24>>2]|0)*5|0;g[W+(X<<2)>>2]=m*l;g[W+(X+1<<2)>>2]=k*l;g[W+(X+2<<2)>>2]=j*l;g[N+(X<<2)>>2]=-(m*l);g[N+(X+1<<2)>>2]=-(k*l);g[N+(X+2<<2)>>2]=-(j*l);p=+ab(+(+g[b+688>>2]- +g[b+692>>2]),6.2831854820251465);if(!(p<-3.1415927410125732)){if(p>3.1415927410125732)p=p+-6.2831854820251465}else p=p+6.2831854820251465;r=+ab(+(+g[b+688>>2]+ +g[b+692>>2]),6.2831854820251465);if(!(r<-3.1415927410125732)){if(r>3.1415927410125732)r=r+-6.2831854820251465}else r=r+6.2831854820251465;W=p==r;N=(c[d+28>>2]|0)+(X<<2)|0;g[N>>2]=0.0;Z=c[b+748>>2]|0;q=+g[((Z&2|0)==0?d+4|0:b+760|0)>>2];if(!(Y&W|_)){if(Z&4)g[(c[d+32>>2]|0)+(X<<2)>>2]=+g[b+752>>2];t=+g[b+728>>2];s=+g[b+680>>2];_=p>r;do if(!(_|W)){u=s/(q*+g[d>>2]);if(u<0.0){if(t>=p?p-u>t:0){p=(p-t)/u;break}p=t<p?0.0:1.0;break}if(u>0.0){if(t<=r?r-u<t:0){p=(r-t)/u;break}p=t>r?0.0:1.0}else p=0.0}else p=_?1.0:0.0;while(0);g[N>>2]=p*s*+g[b+732>>2]+ +g[N>>2];g[(c[d+36>>2]|0)+(X<<2)>>2]=-+g[b+684>>2];g[(c[d+40>>2]|0)+(X<<2)>>2]=+g[b+684>>2]}if(!Y){i=e;return}g[N>>2]=+g[N>>2]+o*q*+g[d>>2];if(Z&1)g[(c[d+32>>2]|0)+(X<<2)>>2]=+g[b+756>>2];do if(!W){W=(c[d+36>>2]|0)+(X<<2)|0;if((n|0)==1){g[W>>2]=0.0;g[(c[d+40>>2]|0)+(X<<2)>>2]=3.4028234663852886e+38;break}else{g[W>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(X<<2)>>2]=0.0;break}}else{g[(c[d+36>>2]|0)+(X<<2)>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(X<<2)>>2]=3.4028234663852886e+38}while(0);o=+g[b+704>>2];do if(o>0.0){j=+g[f+328>>2]*m*l+ +g[f+332>>2]*k*l+ +g[f+336>>2]*j*l-(m*l*+g[h+328>>2]+k*l*+g[h+332>>2]+j*l*+g[h+336>>2]);if((n|0)==1){if(!(j<0.0))break;if(!(+g[N>>2]<-(o*j)))break;g[N>>2]=-(o*j);break}else{if(!(j>0.0))break;if(!(+g[N>>2]>-(o*j)))break;g[N>>2]=-(o*j);break}}while(0);g[N>>2]=+g[b+700>>2]*+g[N>>2];i=e;return}function pq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;v=+g[a+552>>2];u=+g[a+568>>2];t=+g[a+584>>2];s=+g[b>>2];r=+g[b+4>>2];q=+g[b+8>>2];o=+g[b+16>>2];n=+g[b+20>>2];m=+g[b+24>>2];k=+g[b+32>>2];i=+g[b+36>>2];f=+g[b+40>>2];j=+g[a+556>>2];h=+g[a+572>>2];e=+g[a+588>>2];x=+g[a+620>>2];w=+g[a+636>>2];d=+g[a+652>>2];p=x*+g[c>>2]+w*+g[c+4>>2]+d*+g[c+8>>2];l=x*+g[c+16>>2]+w*+g[c+20>>2]+d*+g[c+24>>2];d=x*+g[c+32>>2]+w*+g[c+36>>2]+d*+g[c+40>>2];d=+Y(+((v*s+u*r+t*q)*p+(v*o+u*n+t*m)*l+(v*k+u*i+t*f)*d),+((s*j+r*h+q*e)*p+(o*j+n*h+m*e)*l+(k*j+i*h+f*e)*d));return+(d*+g[a+732>>2])}function qq(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;f=i;do if((e|0)==5|(e|0)==-1)if((b|0)==2){g[a+760>>2]=d;c[a+748>>2]=c[a+748>>2]|2;break}else if((b|0)==3){g[a+752>>2]=d;c[a+748>>2]=c[a+748>>2]|4;break}else if((b|0)==4){g[a+756>>2]=d;c[a+748>>2]=c[a+748>>2]|1;break}else break;while(0);i=f;return}function rq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0;d=i;do if((c|0)==5|(c|0)==-1)if((b|0)==2){e=+g[a+760>>2];break}else if((b|0)==4){e=+g[a+756>>2];break}else if((b|0)==3){e=+g[a+752>>2];break}else{e=0.0;break}else e=0.0;while(0);i=d;return+e}function sq(a){a=a|0;return}function tq(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function uq(a){a=a|0;return 220}function vq(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,h=0.0;f=i;Zr(a,b,e)|0;g[b+52>>2]=+g[a+552>>2];g[b+56>>2]=+g[a+556>>2];g[b+60>>2]=+g[a+560>>2];g[b+64>>2]=+g[a+564>>2];g[b+68>>2]=+g[a+568>>2];g[b+72>>2]=+g[a+572>>2];g[b+76>>2]=+g[a+576>>2];g[b+80>>2]=+g[a+580>>2];g[b+84>>2]=+g[a+584>>2];g[b+88>>2]=+g[a+588>>2];g[b+92>>2]=+g[a+592>>2];g[b+96>>2]=+g[a+596>>2];g[b+100>>2]=+g[a+600>>2];g[b+104>>2]=+g[a+604>>2];g[b+108>>2]=+g[a+608>>2];g[b+112>>2]=+g[a+612>>2];g[b+116>>2]=+g[a+616>>2];g[b+120>>2]=+g[a+620>>2];g[b+124>>2]=+g[a+624>>2];g[b+128>>2]=+g[a+628>>2];g[b+132>>2]=+g[a+632>>2];g[b+136>>2]=+g[a+636>>2];g[b+140>>2]=+g[a+640>>2];g[b+144>>2]=+g[a+644>>2];g[b+148>>2]=+g[a+648>>2];g[b+152>>2]=+g[a+652>>2];g[b+156>>2]=+g[a+656>>2];g[b+160>>2]=+g[a+660>>2];g[b+164>>2]=+g[a+664>>2];g[b+168>>2]=+g[a+668>>2];g[b+172>>2]=+g[a+672>>2];g[b+176>>2]=+g[a+676>>2];c[b+184>>2]=d[a+736>>0];c[b+188>>2]=d[a+737>>0];g[b+196>>2]=+g[a+684>>2];g[b+192>>2]=+g[a+680>>2];c[b+180>>2]=d[a+740>>0];h=+ab(+(+g[a+688>>2]- +g[a+692>>2]),6.2831854820251465);if(!(h<-3.1415927410125732)){if(h>3.1415927410125732)h=h+-6.2831854820251465}else h=h+6.2831854820251465;g[b+200>>2]=h;h=+ab(+(+g[a+688>>2]+ +g[a+692>>2]),6.2831854820251465);if(h<-3.1415927410125732){h=h+6.2831854820251465;e=b+204|0;g[e>>2]=h;e=a+696|0;h=+g[e>>2];e=b+208|0;g[e>>2]=h;e=a+700|0;h=+g[e>>2];e=b+212|0;g[e>>2]=h;e=a+704|0;h=+g[e>>2];e=b+216|0;g[e>>2]=h;i=f;return 2592}if(!(h>3.1415927410125732)){e=b+204|0;g[e>>2]=h;e=a+696|0;h=+g[e>>2];e=b+208|0;g[e>>2]=h;e=a+700|0;h=+g[e>>2];e=b+212|0;g[e>>2]=h;e=a+704|0;h=+g[e>>2];e=b+216|0;g[e>>2]=h;i=f;return 2592}h=h+-6.2831854820251465;e=b+204|0;g[e>>2]=h;e=a+696|0;h=+g[e>>2];e=b+208|0;g[e>>2]=h;e=a+700|0;h=+g[e>>2];e=b+212|0;g[e>>2]=h;e=a+704|0;h=+g[e>>2];e=b+216|0;g[e>>2]=h;i=f;return 2592}function wq(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=2632;e=c[b+140>>2]|0;if(e){if(a[b+144>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;if(!b){i=d;return}}else{a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function xq(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=2632;e=c[b+140>>2]|0;if(e){if(a[b+144>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;i=d;return}function yq(a){a=a|0;return}function zq(d,e,f,h,j){d=d|0;e=e|0;f=+f;h=+h;j=+j;var k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;k=i;i=i+240|0;p=+g[d+96>>2]+h;q=+g[d+100>>2]+j;g[d+112>>2]=+g[d+92>>2]+f;g[d+116>>2]=p;g[d+120>>2]=q;g[d+124>>2]=0.0;g[k+168>>2]=1.0;c[k+172>>2]=0;c[k+176>>2]=0;c[k+180>>2]=0;c[k+184>>2]=0;g[k+188>>2]=1.0;c[k+192>>2]=0;c[k+196>>2]=0;c[k+200>>2]=0;c[k+204>>2]=0;g[k+208>>2]=1.0;l=k+212|0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;g[k+104>>2]=1.0;c[k+108>>2]=0;c[k+112>>2]=0;c[k+116>>2]=0;c[k+120>>2]=0;g[k+124>>2]=1.0;c[k+128>>2]=0;c[k+132>>2]=0;c[k+136>>2]=0;c[k+140>>2]=0;g[k+144>>2]=1.0;l=k+148|0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;f=1.0;l=10;while(1){r=l;l=l+ -1|0;if((r|0)<=0){d=12;break}c[k+216>>2]=c[d+92>>2];c[k+220>>2]=c[d+96>>2];c[k+224>>2]=c[d+100>>2];c[k+228>>2]=c[d+104>>2];c[k+152>>2]=c[d+112>>2];c[k+156>>2]=c[d+116>>2];c[k+160>>2]=c[d+120>>2];c[k+164>>2]=c[d+124>>2];p=+g[d+92>>2]- +g[d+112>>2];q=+g[d+96>>2]- +g[d+116>>2];j=+g[d+100>>2]- +g[d+120>>2];r=c[d+8>>2]|0;g[k+4>>2]=1.0;b[k+8>>1]=1;b[k+10>>1]=-1;c[k+76>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;c[k+28>>2]=0;c[k+32>>2]=0;c[k+36>>2]=0;c[k+40>>2]=0;c[k>>2]=2896;c[k+80>>2]=r;g[k+84>>2]=p;g[k+88>>2]=q;g[k+92>>2]=j;g[k+96>>2]=0.0;g[k+100>>2]=0.0;r=c[r+188>>2]|0;b[k+8>>1]=b[r+4>>1]|0;b[k+10>>1]=b[r+6>>1]|0;r=c[d+12>>2]|0;j=+$b[c[(c[r>>2]|0)+48>>2]&15](r);r=c[d+12>>2]|0;Kb[c[(c[r>>2]|0)+44>>2]&31](r,j+ +g[d+56>>2]);if(!(a[d+170>>0]|0))Ou(e,c[d+12>>2]|0,k+168|0,k+104|0,k,+g[e+56>>2]);else vz(c[d+8>>2]|0,c[d+12>>2]|0,k+168|0,k+104|0,k,+g[e+56>>2]);r=c[d+12>>2]|0;Kb[c[(c[r>>2]|0)+44>>2]&31](r,j);q=+g[k+4>>2];f=f-q;if(!(q<1.0)){c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2];if(f>.009999999776482582)continue;else{d=12;break}}p=+g[d+112>>2];m=+g[d+92>>2];o=+g[d+116>>2];h=+g[d+96>>2];n=+g[d+120>>2];j=+g[d+100>>2];q=+Q(+((p-m)*(p-m)+(o-h)*(o-h)+(n-j)*(n-j)));if(q>1.1920928955078125e-7){v=+g[k+44>>2];t=+g[k+48>>2];x=+g[k+52>>2];w=((p-m)*(1.0/q)*v+(o-h)*(1.0/q)*t+(n-j)*(1.0/q)*x)*2.0;u=(p-m)*(1.0/q)-v*w;s=(o-h)*(1.0/q)-t*w;w=(n-j)*(1.0/q)-x*w;n=1.0/+Q(+(w*w+(u*u+s*s)));c[d+112>>2]=c[d+92>>2];c[d+116>>2]=c[d+96>>2];c[d+120>>2]=c[d+100>>2];c[d+124>>2]=c[d+104>>2];p=q*(n*u-v*(x*n*w+(v*n*u+t*n*s)))+ +g[d+112>>2];g[d+112>>2]=p;o=q*(n*s-t*(x*n*w+(v*n*u+t*n*s)))+ +g[d+116>>2];g[d+116>>2]=o;n=q*(n*w-x*(x*n*w+(v*n*u+t*n*s)))+ +g[d+120>>2];g[d+120>>2]=n}m=p-m;h=o-h;j=n-j;if(!(m*m+h*h+j*j>1.1920928955078125e-7)){d=12;break}x=1.0/+Q(+(m*m+h*h+j*j));if(!(f>.009999999776482582?!(m*x*+g[d+76>>2]+h*x*+g[d+80>>2]+j*x*+g[d+84>>2]<=0.0):0)){d=12;break}}if((d|0)==12){i=k;return}}function Aq(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0;e=i;a[b+171>>0]=1;c[b+60>>2]=c[d+0>>2];c[b+64>>2]=c[d+4>>2];c[b+68>>2]=c[d+8>>2];c[b+72>>2]=c[d+12>>2];f=+g[b+60>>2];k=+g[b+64>>2];h=+g[b+68>>2];j=1.0/+Q(+(f*f+k*k+h*h));if(+Q(+(h*j*h*j+(f*j*f*j+k*j*k*j)))<1.1920928955078125e-7){f=0.0;k=0.0;j=0.0;h=0.0}else{f=f*j;k=k*j;j=h*j;h=+g[b+72>>2]}g[b+76>>2]=f;g[b+80>>2]=k;g[b+84>>2]=j;g[b+88>>2]=h;i=e;return}function Bq(b,d,e){b=b|0;d=d|0;e=+e;var f=0,h=0.0,j=0.0,k=0.0,l=0.0;f=i;a[b+171>>0]=0;c[b+60>>2]=c[d+0>>2];c[b+64>>2]=c[d+4>>2];c[b+68>>2]=c[d+8>>2];c[b+72>>2]=c[d+12>>2];h=+g[b+60>>2];l=+g[b+64>>2];j=+g[b+68>>2];k=1.0/+Q(+(h*h+l*l+j*j));if(+Q(+(j*k*j*k+(h*k*h*k+l*k*l*k)))<1.1920928955078125e-7){h=0.0;l=0.0;k=0.0;j=0.0}else{h=h*k;l=l*k;k=j*k;j=+g[b+72>>2]}g[b+76>>2]=h;g[b+80>>2]=l;g[b+84>>2]=k;g[b+88>>2]=j;g[b+172>>2]=+g[b+172>>2]+e;i=f;return}function Cq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0;e=i;g[b+16>>2]=0.0;g[b+20>>2]=0.0;a[b+168>>0]=0;a[b+169>>0]=0;g[b+172>>2]=0.0;c[b+60>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;b=c[(c[b+8>>2]|0)+284>>2]|0;if((c[(Pb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)<=0){i=e;return}do{h=c[b>>2]|0;j=c[h+12>>2]|0;h=c[c[(Pb[c[h+28>>2]&127](b)|0)+12>>2]>>2]|0;f=c[(c[(Pb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+12>>2]|0)+4>>2]|0;Tb[j&31](b,h,f,c[d+24>>2]|0)|0}while((c[(Pb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)>0);i=e;return}function Dq(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+32|0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[d+0>>2]=c[b+0>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=c[a+8>>2]|0;c[b+260>>2]=(c[b+260>>2]|0)+1;g[b+4>>2]=1.0;c[b+8>>2]=c[d+16>>2];c[b+12>>2]=c[d+20>>2];c[b+16>>2]=c[d+24>>2];c[b+20>>2]=0;g[b+24>>2]=1.0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;g[b+44>>2]=1.0;g[b+48>>2]=0.0;c[b+52>>2]=c[d+0>>2];c[b+56>>2]=c[d+4>>2];c[b+60>>2]=c[d+8>>2];c[b+64>>2]=c[d+12>>2];i=d;return}function Eq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0,r=0.0,s=0,t=0.0,u=0,v=0,w=0,x=0.0,y=0.0;h=i;i=i+96|0;a[b+148>>0]=0;e=0;while(1){w=c[b+12>>2]|0;vc[c[(c[w>>2]|0)+8>>2]&127](w,(c[b+8>>2]|0)+4|0,h+80|0,h+64|0);w=c[d+68>>2]|0;Jb[c[(c[w>>2]|0)+16>>2]&31](w,c[(c[b+8>>2]|0)+188>>2]|0,h+80|0,h+64|0,c[d+24>>2]|0);w=c[d+24>>2]|0;vc[c[(c[w>>2]|0)+32>>2]&127](w,c[(c[b+8>>2]|0)+284>>2]|0,d+28|0,w);w=c[b+8>>2]|0;c[b+92>>2]=c[w+52>>2];c[b+96>>2]=c[w+56>>2];c[b+100>>2]=c[w+60>>2];c[b+104>>2]=c[w+64>>2];w=c[w+284>>2]|0;if((Pb[c[(c[w>>2]|0)+36>>2]&127](w)|0)>0){j=0;r=0.0;o=0;do{l=c[b+132>>2]|0;if((l|0)<0){if((c[b+136>>2]|0)<0){k=c[b+140>>2]|0;if(k){if(a[b+144>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+136>>2]=0}do{k=(c[b+140>>2]|0)+(l<<2)|0;if(k)c[k>>2]=0;l=l+1|0}while((l|0)!=0)}c[b+132>>2]=0;l=c[(c[b+8>>2]|0)+284>>2]|0;l=c[(Pb[c[(c[l>>2]|0)+28>>2]&127](l)|0)+12>>2]|0;w=c[c[l+(j<<4)>>2]>>2]|0;k=c[c[l+(j<<4)+4>>2]>>2]|0;if(!((w|0)!=0?(c[w+204>>2]&4|0)!=0:0))f=15;do if((f|0)==15){f=0;if((k|0)!=0?(c[k+204>>2]&4|0)!=0:0)break;k=c[l+(j<<4)+8>>2]|0;if(k)Nb[c[(c[k>>2]|0)+16>>2]&127](k,b+128|0);n=c[b+132>>2]|0;if((n|0)>0){m=c[b+140>>2]|0;l=c[b+8>>2]|0;k=0;u=o;while(1){o=c[m+(k<<2)>>2]|0;p=(c[o+740>>2]|0)==(l|0)?-1.0:1.0;s=c[o+748>>2]|0;if((s|0)>0){q=0;do{t=+g[o+(q*184|0)+84>>2];if(t<0.0){v=o+(q*184|0)+68|0;if(t<r){w=o+(q*184|0)+72|0;x=p*+g[w>>2];u=o+(q*184|0)+76|0;r=p*+g[u>>2];g[b+152>>2]=p*+g[v>>2];g[b+156>>2]=x;g[b+160>>2]=r;g[b+164>>2]=0.0;s=c[o+748>>2]|0;r=t}else{w=o+(q*184|0)+72|0;u=o+(q*184|0)+76|0}y=t*p*+g[w>>2]*.20000000298023224;x=t*p*+g[u>>2]*.20000000298023224;g[b+92>>2]=t*p*+g[v>>2]*.20000000298023224+ +g[b+92>>2];g[b+96>>2]=y+ +g[b+96>>2];g[b+100>>2]=x+ +g[b+100>>2];u=1}q=q+1|0}while((q|0)<(s|0));o=u}else o=u;k=k+1|0;if((k|0)>=(n|0))break;else u=o}}}while(0);j=j+1|0;w=c[(c[b+8>>2]|0)+284>>2]|0}while((j|0)<(Pb[c[(c[w>>2]|0)+36>>2]&127](w)|0))}else o=0;w=c[b+8>>2]|0;c[h+0>>2]=c[w+4>>2];c[h+4>>2]=c[w+8>>2];c[h+8>>2]=c[w+12>>2];c[h+12>>2]=c[w+16>>2];c[h+16>>2]=c[w+20>>2];c[h+20>>2]=c[w+24>>2];c[h+24>>2]=c[w+28>>2];c[h+28>>2]=c[w+32>>2];c[h+32>>2]=c[w+36>>2];c[h+36>>2]=c[w+40>>2];c[h+40>>2]=c[w+44>>2];c[h+44>>2]=c[w+48>>2];c[h+48>>2]=c[b+92>>2];c[h+52>>2]=c[b+96>>2];c[h+56>>2]=c[b+100>>2];c[h+60>>2]=c[b+104>>2];c[w+260>>2]=(c[w+260>>2]|0)+1;c[w+4>>2]=c[h+0>>2];c[w+8>>2]=c[h+4>>2];c[w+12>>2]=c[h+8>>2];c[w+16>>2]=c[h+12>>2];c[w+20>>2]=c[h+16>>2];c[w+24>>2]=c[h+20>>2];c[w+28>>2]=c[h+24>>2];c[w+32>>2]=c[h+28>>2];c[w+36>>2]=c[h+32>>2];c[w+40>>2]=c[h+36>>2];c[w+44>>2]=c[h+40>>2];c[w+48>>2]=c[h+44>>2];c[w+52>>2]=c[h+48>>2];c[w+56>>2]=c[h+52>>2];c[w+60>>2]=c[h+56>>2];c[w+64>>2]=c[h+60>>2];if(!o){f=32;break}a[b+148>>0]=1;if((e|0)>3){f=32;break}else e=e+1|0}if((f|0)==32){w=(c[b+8>>2]|0)+52|0;c[b+92>>2]=c[w+0>>2];c[b+96>>2]=c[w+4>>2];c[b+100>>2]=c[w+8>>2];c[b+104>>2]=c[w+12>>2];nF(b+112|0,w|0,16)|0;i=h;return}}function Fq(d,e,f){d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0,s=0.0;h=i;i=i+528|0;if((a[d+171>>0]|0)==0?+g[d+172>>2]<=0.0:0){i=h;return}a[d+168>>0]=(Pb[c[(c[d>>2]|0)+48>>2]&127](d)|0)&1;p=+g[d+16>>2]- +g[d+44>>2]*f;g[d+16>>2]=p;if(p>0.0?(l=+g[d+28>>2],p>l):0)g[d+16>>2]=l;else l=p;if(l<0.0?(s=+P(+l),k=+P(+(+g[d+24>>2])),s>k):0){g[d+16>>2]=-k;l=-k}g[d+20>>2]=l*f;m=c[d+8>>2]|0;c[h+0>>2]=c[m+4>>2];c[h+4>>2]=c[m+8>>2];c[h+8>>2]=c[m+12>>2];c[h+12>>2]=c[m+16>>2];c[h+16>>2]=c[m+20>>2];c[h+20>>2]=c[m+24>>2];c[h+24>>2]=c[m+28>>2];c[h+28>>2]=c[m+32>>2];c[h+32>>2]=c[m+36>>2];c[h+36>>2]=c[m+40>>2];c[h+40>>2]=c[m+44>>2];c[h+44>>2]=c[m+48>>2];c[h+48>>2]=c[m+52>>2];c[h+52>>2]=c[m+56>>2];c[h+56>>2]=c[m+60>>2];c[h+60>>2]=c[m+64>>2];m=c[d+176>>2]|0;if((a[2736]|0)==0?(Ya(2736)|0)!=0:0){g[672]=1.0;c[673]=0;c[674]=0;c[675]=0;c[676]=0;g[677]=1.0;c[678]=0;c[679]=0;c[680]=0;c[681]=0;g[682]=1.0;g[683]=0.0;bb(2736)}p=+g[d+20>>2];p=+g[d+52>>2]+(p>0.0?p:0.0);q=+g[2692+(m<<4)>>2]*p+ +g[d+96>>2];s=p*+g[2696+(m<<4)>>2]+ +g[d+100>>2];g[d+112>>2]=+g[d+92>>2]+ +g[2688+(m<<4)>>2]*p;g[d+116>>2]=q;g[d+120>>2]=s;g[d+124>>2]=0.0;g[h+456>>2]=1.0;c[h+460>>2]=0;c[h+464>>2]=0;c[h+468>>2]=0;c[h+472>>2]=0;g[h+476>>2]=1.0;c[h+480>>2]=0;c[h+484>>2]=0;c[h+488>>2]=0;c[h+492>>2]=0;g[h+496>>2]=1.0;m=h+500|0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;g[h+392>>2]=1.0;c[h+396>>2]=0;c[h+400>>2]=0;c[h+404>>2]=0;c[h+408>>2]=0;g[h+412>>2]=1.0;c[h+416>>2]=0;c[h+420>>2]=0;c[h+424>>2]=0;c[h+428>>2]=0;g[h+432>>2]=1.0;m=h+436|0;c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;m=c[d+176>>2]|0;if((a[2736]|0)==0?(Ya(2736)|0)!=0:0){g[672]=1.0;c[673]=0;c[674]=0;c[675]=0;c[676]=0;g[677]=1.0;c[678]=0;c[679]=0;c[680]=0;c[681]=0;g[682]=1.0;g[683]=0.0;bb(2736)}n=c[d+12>>2]|0;p=+$b[c[(c[n>>2]|0)+48>>2]&15](n);p=p+ +g[d+56>>2];q=p*+g[2692+(m<<4)>>2]+ +g[d+96>>2];s=p*+g[2696+(m<<4)>>2]+ +g[d+100>>2];g[h+504>>2]=+g[2688+(m<<4)>>2]*p+ +g[d+92>>2];g[h+508>>2]=q;g[h+512>>2]=s;g[h+516>>2]=0.0;c[h+440>>2]=c[d+112>>2];c[h+444>>2]=c[d+116>>2];c[h+448>>2]=c[d+120>>2];c[h+452>>2]=c[d+124>>2];m=c[d+8>>2]|0;n=c[d+176>>2]|0;if((a[2736]|0)==0?(Ya(2736)|0)!=0:0){g[672]=1.0;c[673]=0;c[674]=0;c[675]=0;c[676]=0;g[677]=1.0;c[678]=0;c[679]=0;c[680]=0;c[681]=0;g[682]=1.0;g[683]=0.0;bb(2736)}p=-+g[2688+(n<<4)>>2];q=-+g[2692+(n<<4)>>2];s=-+g[2696+(n<<4)>>2];g[h+292>>2]=1.0;b[h+296>>1]=1;b[h+298>>1]=-1;r=h+300|0;c[h+364>>2]=0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;c[r+16>>2]=0;c[r+20>>2]=0;c[r+24>>2]=0;c[r+28>>2]=0;c[h+288>>2]=2896;c[h+368>>2]=m;g[h+372>>2]=p;g[h+376>>2]=q;g[h+380>>2]=s;g[h+384>>2]=0.0;g[h+388>>2]=.707099974155426;m=c[d+8>>2]|0;r=c[m+188>>2]|0;b[h+296>>1]=b[r+4>>1]|0;b[h+298>>1]=b[r+6>>1]|0;if(!(a[d+170>>0]|0))Ou(e,c[d+12>>2]|0,h+456|0,h+392|0,h+288|0,0.0);else vz(m,c[d+12>>2]|0,h+456|0,h+392|0,h+288|0,+g[e+56>>2]);if(+g[h+292>>2]<1.0){m=c[d+176>>2]|0;if((a[2736]|0)==0?(Ya(2736)|0)!=0:0){g[672]=1.0;c[673]=0;c[674]=0;c[675]=0;c[676]=0;g[677]=1.0;c[678]=0;c[679]=0;c[680]=0;c[681]=0;g[682]=1.0;g[683]=0.0;bb(2736)}do if(+g[h+332>>2]*+g[2688+(m<<4)>>2]+ +g[h+336>>2]*+g[2692+(m<<4)>>2]+ +g[h+340>>2]*+g[2696+(m<<4)>>2]>0.0){k=+g[h+292>>2];g[d+108>>2]=+g[d+52>>2]*k;if(!(a[d+180>>0]|0)){c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2];break}else{g[d+92>>2]=(1.0-k)*+g[d+92>>2]+k*+g[d+112>>2];g[d+96>>2]=(1.0-k)*+g[d+96>>2]+k*+g[d+116>>2];g[d+100>>2]=(1.0-k)*+g[d+100>>2]+k*+g[d+120>>2];break}}while(0);g[d+16>>2]=0.0;g[d+20>>2]=0.0}else{g[d+108>>2]=+g[d+52>>2];c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2]}if(!(a[d+171>>0]|0)){q=+g[d+172>>2];s=q>f?f:q;g[d+172>>2]=q-f;zq(d,e,+g[d+60>>2]*s,s*+g[d+64>>2],s*+g[d+68>>2])}else zq(d,e,+g[d+60>>2],+g[d+64>>2],+g[d+68>>2]);c[h+272>>2]=c[d+112>>2];c[h+276>>2]=c[d+116>>2];c[h+280>>2]=c[d+120>>2];c[h+284>>2]=c[d+124>>2];k=+g[d+16>>2];if(k<0.0)k=-k;else k=0.0;k=k*f;do if(k>0.0?(j=+g[d+24>>2],k>j):0){if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0){j=k;break}}else j=k;while(0);m=c[d+176>>2]|0;if((a[2736]|0)==0?(Ya(2736)|0)!=0:0){g[672]=1.0;c[673]=0;c[674]=0;c[675]=0;c[676]=0;g[677]=1.0;c[678]=0;c[679]=0;c[680]=0;c[681]=0;g[682]=1.0;g[683]=0.0;bb(2736)}l=j+ +g[d+108>>2];k=+g[2688+(m<<4)>>2]*l;j=l*+g[2692+(m<<4)>>2];l=l*+g[2696+(m<<4)>>2];g[d+112>>2]=+g[d+112>>2]-k;g[d+116>>2]=+g[d+116>>2]-j;g[d+120>>2]=+g[d+120>>2]-l;n=c[d+8>>2]|0;o=c[d+176>>2]|0;if((a[2736]|0)==0?(Ya(2736)|0)!=0:0){g[672]=1.0;c[673]=0;c[674]=0;c[675]=0;c[676]=0;g[677]=1.0;c[678]=0;c[679]=0;c[680]=0;c[681]=0;g[682]=1.0;g[683]=0.0;bb(2736)}s=+g[d+40>>2];m=h+172|0;g[m>>2]=1.0;b[h+176>>1]=1;b[h+178>>1]=-1;r=h+180|0;c[h+244>>2]=0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;c[r+16>>2]=0;c[r+20>>2]=0;c[r+24>>2]=0;c[r+28>>2]=0;c[h+168>>2]=2896;c[h+248>>2]=n;c[h+252>>2]=c[2688+(o<<4)>>2];c[h+256>>2]=c[2692+(o<<4)>>2];c[h+260>>2]=c[2696+(o<<4)>>2];c[h+264>>2]=c[2700+(o<<4)>>2];g[h+268>>2]=s;o=c[d+8>>2]|0;n=c[o+188>>2]|0;b[h+176>>1]=b[n+4>>1]|0;b[h+178>>1]=b[n+6>>1]|0;n=c[d+176>>2]|0;if((a[2736]|0)==0?(Ya(2736)|0)!=0:0){g[672]=1.0;c[673]=0;c[674]=0;c[675]=0;c[676]=0;g[677]=1.0;c[678]=0;c[679]=0;c[680]=0;c[681]=0;g[682]=1.0;g[683]=0.0;bb(2736)}s=+g[d+40>>2];g[h+68>>2]=1.0;b[h+72>>1]=1;b[h+74>>1]=-1;r=h+76|0;c[h+140>>2]=0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;c[r+16>>2]=0;c[r+20>>2]=0;c[r+24>>2]=0;c[r+28>>2]=0;c[h+64>>2]=2896;c[h+144>>2]=o;c[h+148>>2]=c[2688+(n<<4)>>2];c[h+152>>2]=c[2692+(n<<4)>>2];c[h+156>>2]=c[2696+(n<<4)>>2];c[h+160>>2]=c[2700+(n<<4)>>2];g[h+164>>2]=s;n=c[(c[d+8>>2]|0)+188>>2]|0;b[h+72>>1]=b[n+4>>1]|0;b[h+74>>1]=b[n+6>>1]|0;s=+g[d+112>>2];q=+g[d+116>>2];p=+g[d+120>>2];n=0;while(1){g[h+456>>2]=1.0;c[h+460>>2]=0;c[h+464>>2]=0;c[h+468>>2]=0;c[h+472>>2]=0;g[h+476>>2]=1.0;c[h+480>>2]=0;c[h+484>>2]=0;c[h+488>>2]=0;c[h+492>>2]=0;g[h+496>>2]=1.0;c[h+500>>2]=0;g[h+392>>2]=1.0;c[h+396>>2]=0;c[h+400>>2]=0;c[h+404>>2]=0;c[h+408>>2]=0;g[h+412>>2]=1.0;c[h+416>>2]=0;c[h+420>>2]=0;c[h+424>>2]=0;c[h+428>>2]=0;g[h+432>>2]=1.0;c[h+436>>2]=0;g[h+288>>2]=1.0;c[h+292>>2]=0;c[h+296>>2]=0;c[h+300>>2]=0;c[h+304>>2]=0;g[h+308>>2]=1.0;c[h+312>>2]=0;c[h+316>>2]=0;c[h+320>>2]=0;c[h+324>>2]=0;g[h+328>>2]=1.0;c[h+332>>2]=0;c[h+336>>2]=0;c[h+340>>2]=0;c[h+504>>2]=c[d+92>>2];c[h+508>>2]=c[d+96>>2];c[h+512>>2]=c[d+100>>2];c[h+516>>2]=c[d+104>>2];c[h+440>>2]=c[d+112>>2];c[h+444>>2]=c[d+116>>2];c[h+448>>2]=c[d+120>>2];c[h+452>>2]=c[d+124>>2];g[h+336>>2]=s-k;g[h+340>>2]=q-j;g[h+344>>2]=p-l;g[h+348>>2]=0.0;if(!(a[d+170>>0]|0)){Ou(e,c[d+12>>2]|0,h+456|0,h+392|0,h+168|0,+g[e+56>>2]);if(!(+g[m>>2]<1.0))Ou(e,c[d+12>>2]|0,h+456|0,h+288|0,h+64|0,+g[e+56>>2])}else{vz(c[d+8>>2]|0,c[d+12>>2]|0,h+456|0,h+392|0,h+168|0,+g[e+56>>2]);if(!(+g[m>>2]<1.0))vz(c[d+8>>2]|0,c[d+12>>2]|0,h+456|0,h+288|0,h+64|0,+g[e+56>>2])}p=+g[d+16>>2];if(p<0.0)q=-p;else q=0.0;s=q*f;o=(a[d+182>>0]|0)==0;if(!o?+g[m>>2]<1.0:0)r=1;else r=+g[h+68>>2]<1.0;if(!(s>0.0))break;q=+g[d+52>>2];if(!(s<q)|r^1|n)break;if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0){n=0;break}c[d+112>>2]=c[h+272>>2];c[d+116>>2]=c[h+276>>2];c[d+120>>2]=c[h+280>>2];c[d+124>>2]=c[h+284>>2];n=c[d+176>>2]|0;do if(!(a[2736]|0)){if(!(Ya(2736)|0))break;g[672]=1.0;c[673]=0;c[674]=0;c[675]=0;c[676]=0;g[677]=1.0;c[678]=0;c[679]=0;c[680]=0;c[681]=0;g[682]=1.0;g[683]=0.0;bb(2736)}while(0);s=q+ +g[d+108>>2];q=s*+g[2692+(n<<4)>>2];p=s*+g[2696+(n<<4)>>2];s=+g[d+112>>2]- +g[2688+(n<<4)>>2]*s;g[d+112>>2]=s;q=+g[d+116>>2]-q;g[d+116>>2]=q;p=+g[d+120>>2]-p;g[d+120>>2]=p;n=1}q=+g[m>>2];if(q<1.0|n){j=+g[d+96>>2];f=(j- +g[h+232>>2])*.5;do if(!o)if(!(a[d+181>>0]|0)){g[d+92>>2]=(1.0-f)*+g[d+92>>2]+f*+g[d+112>>2];g[d+96>>2]=(1.0-f)*j+f*+g[d+116>>2];g[d+100>>2]=(1.0-f)*+g[d+100>>2]+f*+g[d+120>>2];e=d+181|0;break}else{g[d+92>>2]=(1.0-q)*+g[d+92>>2]+q*+g[d+112>>2];g[d+96>>2]=(1.0-q)*j+q*+g[d+116>>2];g[d+100>>2]=(1.0-q)*+g[d+100>>2]+q*+g[d+120>>2];e=d+181|0;break}else{g[d+92>>2]=(1.0-q)*+g[d+92>>2]+q*+g[d+112>>2];g[d+96>>2]=(1.0-q)*j+q*+g[d+116>>2];g[d+100>>2]=(1.0-q)*+g[d+100>>2]+q*+g[d+120>>2];e=d+181|0}while(0);a[e>>0]=0;g[d+16>>2]=0.0;g[d+20>>2]=0.0;a[d+169>>0]=0}else{a[d+181>>0]=1;do if(!o){if(p<0.0)q=-p;else q=0.0;p=+g[d+24>>2];if(q*f>p){if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0)break;g[d+112>>2]=k+ +g[d+112>>2];g[d+116>>2]=j+ +g[d+116>>2];g[d+120>>2]=l+ +g[d+120>>2];e=c[d+176>>2]|0;do if(!(a[2736]|0)){if(!(Ya(2736)|0))break;g[672]=1.0;c[673]=0;c[674]=0;c[675]=0;c[676]=0;g[677]=1.0;c[678]=0;c[679]=0;c[680]=0;c[681]=0;g[682]=1.0;g[683]=0.0;bb(2736)}while(0);p=p+ +g[d+108>>2];q=p*+g[2692+(e<<4)>>2];s=p*+g[2696+(e<<4)>>2];g[d+112>>2]=+g[d+112>>2]- +g[2688+(e<<4)>>2]*p;g[d+116>>2]=+g[d+116>>2]-q;g[d+120>>2]=+g[d+120>>2]-s}}while(0);c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2]}c[h+48>>2]=c[d+92>>2];c[h+52>>2]=c[d+96>>2];c[h+56>>2]=c[d+100>>2];c[h+60>>2]=c[d+104>>2];r=c[d+8>>2]|0;c[r+260>>2]=(c[r+260>>2]|0)+1;c[r+4>>2]=c[h+0>>2];c[r+8>>2]=c[h+4>>2];c[r+12>>2]=c[h+8>>2];c[r+16>>2]=c[h+12>>2];c[r+20>>2]=c[h+16>>2];c[r+24>>2]=c[h+20>>2];c[r+28>>2]=c[h+24>>2];c[r+32>>2]=c[h+28>>2];c[r+36>>2]=c[h+32>>2];c[r+40>>2]=c[h+36>>2];c[r+44>>2]=c[h+40>>2];c[r+48>>2]=c[h+44>>2];c[r+52>>2]=c[h+48>>2];c[r+56>>2]=c[h+52>>2];c[r+60>>2]=c[h+56>>2];c[r+64>>2]=c[h+60>>2];i=h;return}function Gq(a){a=a|0;var b=0;b=i;a=Pb[c[(c[a>>2]|0)+48>>2]&127](a)|0;i=b;return a|0}function Hq(b){b=b|0;var d=0;d=i;if(!(Pb[c[(c[b>>2]|0)+40>>2]&127](b)|0)){i=d;return}g[b+16>>2]=+g[b+28>>2];a[b+169>>0]=1;i=d;return}function Iq(a){a=a|0;var b=0;b=i;if(!(+g[a+16>>2]==0.0)){a=0;i=b;return a|0}a=+g[a+20>>2]==0.0;i=b;return a|0}function Jq(a,b){a=a|0;b=b|0;return}function Kq(b,c){b=b|0;c=c|0;a[b+180>>0]=c&1;return}function Lq(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;Nb[c[(c[a>>2]|0)+32>>2]&127](a,b);tc[c[(c[a>>2]|0)+36>>2]&7](a,b,d);i=e;return}function Mq(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Nq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;e=i;f=c[b>>2]|0;if((f|0)==(c[a+80>>2]|0)){k=1.0;i=e;return+k}if(c[f+204>>2]&4){k=1.0;i=e;return+k}if(d){k=+g[b+8>>2];j=+g[b+12>>2];h=+g[b+16>>2]}else{m=+g[b+8>>2];l=+g[b+12>>2];h=+g[b+16>>2];k=+g[f+4>>2]*m+ +g[f+8>>2]*l+ +g[f+12>>2]*h;j=m*+g[f+20>>2]+l*+g[f+24>>2]+h*+g[f+28>>2];h=m*+g[f+36>>2]+l*+g[f+40>>2]+h*+g[f+44>>2]}if(k*+g[a+84>>2]+j*+g[a+88>>2]+h*+g[a+92>>2]<+g[a+100>>2]){m=1.0;i=e;return+m}g[a+4>>2]=+g[b+40>>2];c[a+76>>2]=f;if(d){c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];c[a+52>>2]=c[b+16>>2];c[a+56>>2]=c[b+20>>2]}else{h=+g[b+8>>2];j=+g[b+12>>2];k=+g[b+16>>2];l=h*+g[f+20>>2]+j*+g[f+24>>2]+k*+g[f+28>>2];m=h*+g[f+36>>2]+j*+g[f+40>>2]+k*+g[f+44>>2];g[a+44>>2]=+g[f+4>>2]*h+ +g[f+8>>2]*j+ +g[f+12>>2]*k;g[a+48>>2]=l;g[a+52>>2]=m;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+64>>2]=c[b+28>>2];c[a+68>>2]=c[b+32>>2];c[a+72>>2]=c[b+36>>2];m=+g[b+40>>2];i=e;return+m}function Oq(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;b=i;i=i+144|0;g[a+36>>2]=0.0;c[b+128>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;d=0;do{e=b+128+(d<<2)|0;g[e>>2]=1.0;h=c[a+28>>2]|0;G=+g[h+4>>2];g[b+80>>2]=G;C=+g[h+20>>2];g[b+84>>2]=C;j=+g[h+36>>2];g[b+88>>2]=j;g[b+92>>2]=0.0;F=+g[h+8>>2];g[b+96>>2]=F;B=+g[h+24>>2];g[b+100>>2]=B;u=+g[h+40>>2];g[b+104>>2]=u;g[b+108>>2]=0.0;E=+g[h+12>>2];g[b+112>>2]=E;A=+g[h+28>>2];g[b+116>>2]=A;n=+g[h+44>>2];g[b+120>>2]=n;g[b+124>>2]=0.0;f=c[a+32>>2]|0;x=+g[f+4>>2];g[b+32>>2]=x;t=+g[f+20>>2];g[b+36>>2]=t;o=+g[f+36>>2];g[b+40>>2]=o;g[b+44>>2]=0.0;w=+g[f+8>>2];g[b+48>>2]=w;s=+g[f+24>>2];g[b+52>>2]=s;m=+g[f+40>>2];g[b+56>>2]=m;g[b+60>>2]=0.0;v=+g[f+12>>2];g[b+64>>2]=v;r=+g[f+28>>2];g[b+68>>2]=r;k=+g[f+44>>2];g[b+72>>2]=k;g[b+76>>2]=0.0;y=+g[a+300>>2];q=+g[a+304>>2];l=+g[a+308>>2];D=+g[h+52>>2];z=+g[h+56>>2];p=+g[h+60>>2];g[b+16>>2]=y*G+q*F+l*E+D-D;g[b+20>>2]=y*C+q*B+l*A+z-z;g[b+24>>2]=y*j+q*u+l*n+p-p;g[b+28>>2]=0.0;p=+g[a+316>>2];n=+g[a+320>>2];l=+g[a+324>>2];u=+g[f+52>>2];q=+g[f+56>>2];j=+g[f+60>>2];g[b>>2]=p*x+n*w+l*v+u-u;g[b+4>>2]=p*t+n*s+l*r+q-q;g[b+8>>2]=p*o+n*m+l*k+j-j;g[b+12>>2]=0.0;h=c[a+28>>2]|0;Mo(a+(d*84|0)+48|0,b+80|0,b+32|0,b+16|0,b,b+128|0,h+396|0,+g[h+344>>2],f+396|0,+g[f+344>>2]);g[e>>2]=0.0;d=d+1|0}while((d|0)!=3);i=b;return}function Pq(b,d){b=b|0;d=d|0;var e=0;e=i;if(!(a[b+344>>0]|0)){c[d>>2]=3;c[d+4>>2]=3;i=e;return}else{c[d>>2]=0;c[d+4>>2]=0;i=e;return}}function Qq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,h=0.0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;d=i;l=c[a+28>>2]|0;m=c[a+32>>2]|0;e=c[b+8>>2]|0;g[e>>2]=1.0;j=c[b+24>>2]|0;g[e+(j+1<<2)>>2]=1.0;g[e+((j<<1)+2<<2)>>2]=1.0;n=+g[a+300>>2];s=+g[a+304>>2];h=+g[a+308>>2];q=+g[l+4>>2]*n+ +g[l+8>>2]*s+ +g[l+12>>2]*h;o=n*+g[l+20>>2]+s*+g[l+24>>2]+h*+g[l+28>>2];h=n*+g[l+36>>2]+s*+g[l+40>>2]+h*+g[l+44>>2];e=c[b+12>>2]|0;g[e>>2]=0.0;g[e+4>>2]=h;g[e+8>>2]=-o;g[e+12>>2]=0.0;g[e+(j<<2)>>2]=-h;g[e+(j+1<<2)>>2]=0.0;g[e+(j+2<<2)>>2]=q;g[e+(j+3<<2)>>2]=0.0;g[e+(j<<1<<2)>>2]=o;g[e+((j<<1|1)<<2)>>2]=-q;g[e+((j<<1)+2<<2)>>2]=0.0;g[e+((j<<1)+3<<2)>>2]=0.0;e=c[b+16>>2]|0;g[e>>2]=-1.0;g[e+(j+1<<2)>>2]=-1.0;g[e+((j<<1)+2<<2)>>2]=-1.0;s=+g[a+316>>2];n=+g[a+320>>2];f=+g[a+324>>2];r=+g[m+4>>2]*s+ +g[m+8>>2]*n+ +g[m+12>>2]*f;p=s*+g[m+20>>2]+n*+g[m+24>>2]+f*+g[m+28>>2];f=s*+g[m+36>>2]+n*+g[m+40>>2]+f*+g[m+44>>2];e=c[b+20>>2]|0;g[e>>2]=0.0;g[e+4>>2]=-f;g[e+8>>2]=p;g[e+12>>2]=0.0;g[e+(j<<2)>>2]=f;g[e+(j+1<<2)>>2]=0.0;g[e+(j+2<<2)>>2]=-r;g[e+(j+3<<2)>>2]=0.0;g[e+(j<<1<<2)>>2]=-p;g[e+((j<<1|1)<<2)>>2]=r;g[e+((j<<1)+2<<2)>>2]=0.0;g[e+((j<<1)+3<<2)>>2]=0.0;j=c[a+332>>2]|0;n=+g[((j&1|0)==0?b+4|0:a+336|0)>>2]*+g[b>>2];e=c[b+24>>2]|0;k=c[b+28>>2]|0;g[k>>2]=n*(r+ +g[m+52>>2]-q- +g[l+52>>2]);g[k+(e<<2)>>2]=n*(p+ +g[m+56>>2]-o- +g[l+56>>2]);g[k+(e<<1<<2)>>2]=n*(f+ +g[m+60>>2]-h- +g[l+60>>2]);if(j&2){m=c[b+32>>2]|0;g[m>>2]=+g[a+340>>2];g[m+(e<<2)>>2]=+g[a+340>>2];g[m+(e<<1<<2)>>2]=+g[a+340>>2]}f=+g[a+356>>2];if(f>0.0){g[c[b+36>>2]>>2]=-f;g[c[b+40>>2]>>2]=f;h=+g[a+356>>2]}else h=f;if(h>0.0){g[(c[b+36>>2]|0)+(e<<2)>>2]=-f;g[(c[b+40>>2]|0)+(e<<2)>>2]=f;h=+g[a+356>>2]}if(!(h>0.0)){m=a+352|0;s=+g[m>>2];m=b+52|0;g[m>>2]=s;i=d;return}g[(c[b+36>>2]|0)+(e<<1<<2)>>2]=-f;g[(c[b+40>>2]|0)+(e<<1<<2)>>2]=f;m=a+352|0;s=+g[m>>2];m=b+52|0;g[m>>2]=s;i=d;return}function Rq(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;f=i;do if((e|0)==-1)if((b|0)==4|(b|0)==3){g[a+340>>2]=d;c[a+332>>2]=c[a+332>>2]|2;break}else if((b|0)==2|(b|0)==1){g[a+336>>2]=d;c[a+332>>2]=c[a+332>>2]|1;break}else break;while(0);i=f;return}function Sq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0;d=i;do if((c|0)==-1)if((b|0)==4|(b|0)==3){e=+g[a+340>>2];break}else if((b|0)==2|(b|0)==1){e=+g[a+336>>2];break}else{e=3.4028234663852886e+38;break}else e=3.4028234663852886e+38;while(0);i=d;return+e}function Tq(a){a=a|0;return}function Uq(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Vq(a){a=a|0;return 84}function Wq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Zr(a,b,c)|0;g[b+52>>2]=+g[a+300>>2];g[b+56>>2]=+g[a+304>>2];g[b+60>>2]=+g[a+308>>2];g[b+64>>2]=+g[a+312>>2];g[b+68>>2]=+g[a+316>>2];g[b+72>>2]=+g[a+320>>2];g[b+76>>2]=+g[a+324>>2];g[b+80>>2]=+g[a+328>>2];i=d;return 3080}function Xq(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=3912;e=c[b+496>>2]|0;if(e){if(a[b+500>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;i=d;return}function Yq(a){a=a|0;var b=0;b=i;Zq(a);gF(a);i=b;return}function Zq(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=3752;e=c[b+144>>2]|0;if(e){if(a[b+148>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;e=c[b+76>>2]|0;if(e){if(a[b+80>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;e=c[b+56>>2]|0;if(e){if(a[b+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;e=c[b+36>>2]|0;if(e){if(a[b+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;e=c[b+16>>2]|0;if(!e){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;e=b+12|0;c[e>>2]=0;i=d;return}if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;e=b+12|0;c[e>>2]=0;i=d;return}function _q(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;f=i;i=i+64|0;a[d+84>>0]=0;c[f+0>>2]=c[b+4>>2];c[f+4>>2]=c[b+8>>2];c[f+8>>2]=c[b+12>>2];c[f+12>>2]=c[b+16>>2];c[f+16>>2]=c[b+20>>2];c[f+20>>2]=c[b+24>>2];c[f+24>>2]=c[b+28>>2];c[f+28>>2]=c[b+32>>2];c[f+32>>2]=c[b+36>>2];c[f+36>>2]=c[b+40>>2];c[f+40>>2]=c[b+44>>2];c[f+44>>2]=c[b+48>>2];c[f+48>>2]=c[b+52>>2];c[f+52>>2]=c[b+56>>2];c[f+56>>2]=c[b+60>>2];c[f+60>>2]=c[b+64>>2];if(e?(h=c[b+480>>2]|0,(h|0)!=0):0)Nb[c[(c[h>>2]|0)+8>>2]&127](h,f);w=+g[d+156>>2];u=+g[f>>2];v=+g[d+160>>2];t=+g[f+4>>2];o=+g[d+164>>2];s=+g[f+8>>2];r=+g[f+16>>2];q=+g[f+20>>2];p=+g[f+24>>2];n=+g[f+32>>2];l=+g[f+36>>2];j=+g[f+40>>2];m=w*r+v*q+o*p+ +g[f+52>>2];k=w*n+v*l+o*j+ +g[f+56>>2];g[d+36>>2]=w*u+v*t+o*s+ +g[f+48>>2];g[d+40>>2]=m;g[d+44>>2]=k;g[d+48>>2]=0.0;k=+g[d+172>>2];m=+g[d+176>>2];o=+g[d+180>>2];g[d+52>>2]=u*k+t*m+s*o;g[d+56>>2]=k*r+m*q+o*p;g[d+60>>2]=k*n+m*l+o*j;g[d+64>>2]=0.0;o=+g[d+188>>2];m=+g[d+192>>2];k=+g[d+196>>2];g[d+68>>2]=u*o+t*m+s*k;g[d+72>>2]=o*r+m*q+k*p;g[d+76>>2]=o*n+m*l+k*j;g[d+80>>2]=0.0;i=f;return}function $q(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;e=i;_q(a,b+(c*284|0)|0,d);o=+g[b+(c*284|0)+52>>2];j=+g[b+(c*284|0)+56>>2];s=+g[b+(c*284|0)+60>>2];I=+g[b+(c*284|0)+76>>2];B=+g[b+(c*284|0)+72>>2];A=+g[b+(c*284|0)+68>>2];y=1.0/+Q(+((B*-o-A*-j)*(B*-o-A*-j)+((I*-j-B*-s)*(I*-j-B*-s)+(A*-s-I*-o)*(A*-s-I*-o))));x=(I*-j-B*-s)*y;w=y*(A*-s-I*-o);y=y*(B*-o-A*-j);f=+g[b+(c*284|0)+232>>2]*.5;m=+T(+f)/+Q(+(o*o+j*j+s*s));f=+S(+f);n=2.0/(f*f+(m*-s*m*-s+(m*-o*m*-o+m*-j*m*-j)));G=1.0-(m*-j*m*-j*n+m*-s*m*-s*n);F=m*-o*m*-j*n-f*m*-s*n;H=m*-o*m*-s*n+f*m*-j*n;D=m*-o*m*-j*n+f*m*-s*n;C=1.0-(m*-o*m*-o*n+m*-s*m*-s*n);E=m*-j*m*-s*n-f*m*-o*n;l=m*-o*m*-s*n-f*m*-j*n;f=m*-j*m*-s*n+f*m*-o*n;n=1.0-(m*-o*m*-o*n+m*-j*m*-j*n);m=+g[b+(c*284|0)+236>>2]*-.5;z=+T(+m)/+Q(+(I*I+(B*B+A*A)));m=+S(+m);t=2.0/(m*m+(I*z*I*z+(A*z*A*z+B*z*B*z)));p=1.0-(B*z*B*z*t+I*z*I*z*t);k=A*z*B*z*t-m*I*z*t;v=A*z*I*z*t+m*B*z*t;q=A*z*B*z*t+m*I*z*t;h=1.0-(A*z*A*z*t+I*z*I*z*t);u=B*z*I*z*t-m*A*z*t;r=A*z*I*z*t-m*B*z*t;m=B*z*I*z*t+m*A*z*t;t=1.0-(A*z*A*z*t+B*z*B*z*t);z=+g[b+(c*284|0)+72>>2];B=+g[b+(c*284|0)+76>>2];g[b+(c*284|0)+92>>2]=B*(G*v+F*u+H*t)+(A*(H*r+(F*q+G*p))+z*(H*m+(G*k+F*h)));g[b+(c*284|0)+96>>2]=y*(G*v+F*u+H*t)+(x*(H*r+(F*q+G*p))+w*(H*m+(G*k+F*h)));g[b+(c*284|0)+100>>2]=(G*v+F*u+H*t)*-s+((H*r+(F*q+G*p))*-o+(H*m+(G*k+F*h))*-j);g[b+(c*284|0)+104>>2]=0.0;g[b+(c*284|0)+108>>2]=B*(D*v+C*u+E*t)+(A*(E*r+(C*q+D*p))+z*(E*m+(D*k+C*h)));g[b+(c*284|0)+112>>2]=y*(D*v+C*u+E*t)+(x*(E*r+(C*q+D*p))+w*(E*m+(D*k+C*h)));g[b+(c*284|0)+116>>2]=(D*v+C*u+E*t)*-s+((E*r+(C*q+D*p))*-o+(E*m+(D*k+C*h))*-j);g[b+(c*284|0)+120>>2]=0.0;g[b+(c*284|0)+124>>2]=B*(l*v+f*u+n*t)+(A*(n*r+(f*q+l*p))+z*(n*m+(l*k+f*h)));g[b+(c*284|0)+128>>2]=y*(l*v+f*u+n*t)+(x*(n*r+(f*q+l*p))+w*(n*m+(l*k+f*h)));g[b+(c*284|0)+132>>2]=(l*v+f*u+n*t)*-s+((n*r+(f*q+l*p))*-o+(n*m+(l*k+f*h))*-j);g[b+(c*284|0)+136>>2]=0.0;j=+g[b+(c*284|0)+32>>2];h=j*+g[b+(c*284|0)+56>>2]+ +g[b+(c*284|0)+40>>2];f=j*+g[b+(c*284|0)+60>>2]+ +g[b+(c*284|0)+44>>2];g[b+(c*284|0)+140>>2]=+g[b+(c*284|0)+52>>2]*j+ +g[b+(c*284|0)+36>>2];g[b+(c*284|0)+144>>2]=h;g[b+(c*284|0)+148>>2]=f;g[b+(c*284|0)+152>>2]=0.0;i=e;return}function ar(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0.0,G=0.0;e=i;i=i+112|0;h=c[b+136>>2]|0;if((h|0)>0){f=0;do{$q(c[b+116>>2]|0,c[b+144>>2]|0,f,0);f=f+1|0;h=c[b+136>>2]|0}while((f|0)<(h|0));f=b+116|0}else f=b+116|0;k=c[f>>2]|0;C=+g[k+312>>2];D=+g[k+316>>2];r=+g[k+320>>2];r=+Q(+(C*C+D*D+r*r))*3.5999999046325684;g[b+112>>2]=r;y=c[b+128>>2]|0;if(+g[k+(y<<2)+4>>2]*+g[k+312>>2]+ +g[k+(y<<2)+20>>2]*+g[k+316>>2]+ +g[k+(y<<2)+36>>2]*+g[k+320>>2]<0.0)g[b+112>>2]=r*-1.0;a:do if((h|0)>0){h=0;do{j=c[b+144>>2]|0;q=j+(h*284|0)|0;_q(k,q,0);u=j+(h*284|0)+204|0;y=j+(h*284|0)+212|0;r=+g[u>>2]+ +g[y>>2];n=j+(h*284|0)+52|0;o=j+(h*284|0)+56|0;p=j+(h*284|0)+60|0;E=j+(h*284|0)+36|0;m=j+(h*284|0)+16|0;C=r*+g[o>>2]+ +g[j+(h*284|0)+40>>2];D=r*+g[p>>2]+ +g[j+(h*284|0)+44>>2];g[j+(h*284|0)+16>>2]=+g[n>>2]*r+ +g[E>>2];l=j+(h*284|0)+20|0;g[l>>2]=C;k=j+(h*284|0)+24|0;g[k>>2]=D;g[j+(h*284|0)+28>>2]=0.0;g[e+64>>2]=-1.0;x=c[b+100>>2]|0;E=Tb[c[(c[x>>2]|0)+8>>2]&31](x,E,m,e+32|0)|0;x=j+(h*284|0)+88|0;c[x>>2]=0;do if(E){r=r*+g[e+64>>2];c[q+0>>2]=c[e+48>>2];c[q+4>>2]=c[e+52>>2];c[q+8>>2]=c[e+56>>2];c[q+12>>2]=c[e+60>>2];a[j+(h*284|0)+84>>0]=1;if((a[3736]|0)==0?(Ya(3736)|0)!=0:0){c[e+88>>2]=0;c[e+92>>2]=0;c[e+96>>2]=0;c[e+100>>2]=0;lr(3120,0.0,0,0,e+88|0);bb(3736)}c[e+72>>2]=0;c[e+76>>2]=0;c[e+80>>2]=0;c[e+84>>2]=0;mr(3120,0.0,e+72|0);c[x>>2]=3120;t=r- +g[y>>2];x=j+(h*284|0)+32|0;g[x>>2]=t;r=+g[u>>2];s=+g[j+(h*284|0)+208>>2]*.009999999776482582;if(t<r-s){g[x>>2]=r-s;t=r-s}if(t>r+s)g[x>>2]=r+s;c[m+0>>2]=c[e+32>>2];c[m+4>>2]=c[e+36>>2];c[m+8>>2]=c[e+40>>2];c[m+12>>2]=c[e+44>>2];s=+g[q>>2];r=+g[j+(h*284|0)+4>>2];t=+g[j+(h*284|0)+8>>2];v=s*+g[n>>2]+r*+g[o>>2]+t*+g[p>>2];n=c[f>>2]|0;w=+g[m>>2]- +g[n+52>>2];z=+g[l>>2]- +g[n+56>>2];C=+g[k>>2]- +g[n+60>>2];D=+g[n+332>>2];A=+g[n+336>>2];B=+g[n+328>>2];if(!(v>=-.10000000149011612)){g[j+(h*284|0)+272>>2]=-1.0/v*(r*(w*A-C*B+ +g[n+316>>2])+s*(D*C-z*A+ +g[n+312>>2])+t*(z*B-w*D+ +g[n+320>>2]));g[j+(h*284|0)+268>>2]=-1.0/v;break}else{g[j+(h*284|0)+272>>2]=0.0;g[j+(h*284|0)+268>>2]=10.0;break}}else{g[j+(h*284|0)+32>>2]=+g[u>>2];g[j+(h*284|0)+272>>2]=0.0;C=-+g[o>>2];D=-+g[p>>2];g[q>>2]=-+g[n>>2];g[j+(h*284|0)+4>>2]=C;g[j+(h*284|0)+8>>2]=D;g[j+(h*284|0)+12>>2]=0.0;g[j+(h*284|0)+268>>2]=1.0}while(0);h=h+1|0;j=c[b+136>>2]|0;k=c[f>>2]|0}while((h|0)<(j|0));r=1.0/+g[k+344>>2];if((j|0)>0){m=c[b+144>>2]|0;l=0;do{if(a[m+(l*284|0)+84>>0]|0){D=+g[m+(l*284|0)+272>>2];D=r*(+g[m+(l*284|0)+216>>2]*(+g[m+(l*284|0)+204>>2]- +g[m+(l*284|0)+32>>2])*+g[m+(l*284|0)+268>>2]-D*+g[(D<0.0?m+(l*284|0)+220|0:m+(l*284|0)+224|0)>>2]);h=m+(l*284|0)+276|0;g[h>>2]=D;if(D<0.0)g[h>>2]=0.0}else g[m+(l*284|0)+276>>2]=0.0;l=l+1|0}while((l|0)<(j|0));h=0;while(1){B=+g[m+(h*284|0)+276>>2];D=+g[m+(h*284|0)+248>>2];B=B>D?D:B;D=B*+g[m+(h*284|0)+4>>2]*d;C=B*+g[m+(h*284|0)+8>>2]*d;g[e+16>>2]=+g[m+(h*284|0)>>2]*B*d;g[e+20>>2]=D;g[e+24>>2]=C;g[e+28>>2]=0.0;C=+g[m+(h*284|0)+20>>2]- +g[k+56>>2];D=+g[m+(h*284|0)+24>>2]- +g[k+60>>2];g[e>>2]=+g[m+(h*284|0)+16>>2]- +g[k+52>>2];g[e+4>>2]=C;g[e+8>>2]=D;g[e+12>>2]=0.0;ym(k,e+16|0,e);h=h+1|0;if((h|0)>=(c[b+136>>2]|0))break a;m=c[b+144>>2]|0;k=c[f>>2]|0}}}while(0);Kb[c[(c[b>>2]|0)+20>>2]&31](b,d);h=c[b+136>>2]|0;if((h|0)<=0){i=e;return}j=c[b+144>>2]|0;f=c[f>>2]|0;k=0;do{t=+g[j+(k*284|0)+36>>2]- +g[f+52>>2];s=+g[j+(k*284|0)+40>>2]- +g[f+56>>2];w=+g[j+(k*284|0)+44>>2]- +g[f+60>>2];r=+g[f+332>>2];v=+g[f+336>>2];z=+g[f+328>>2];if(!(a[j+(k*284|0)+84>>0]|0)){r=+g[j+(k*284|0)+240>>2];E=j+(k*284|0)+236|0;g[E>>2]=r+ +g[E>>2]}else{E=c[b+128>>2]|0;G=+g[f+(E<<2)+4>>2];A=+g[f+(E<<2)+20>>2];C=+g[f+(E<<2)+36>>2];F=+g[j+(k*284|0)>>2];B=+g[j+(k*284|0)+4>>2];D=+g[j+(k*284|0)+8>>2];r=((s*z-t*r+ +g[f+320>>2])*(C-D*(G*F+A*B+C*D))+((r*w-s*v+ +g[f+312>>2])*(G-F*(G*F+A*B+C*D))+(t*v-w*z+ +g[f+316>>2])*(A-B*(G*F+A*B+C*D))))*d/+g[j+(k*284|0)+212>>2];g[j+(k*284|0)+240>>2]=r;E=j+(k*284|0)+236|0;g[E>>2]=r+ +g[E>>2]}g[j+(k*284|0)+240>>2]=r*.9900000095367432;k=k+1|0}while((k|0)<(h|0));i=e;return}function br(b,d){b=b|0;d=+d;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,R=0.0;e=i;i=i+384|0;j=c[b+136>>2]|0;if(!j){i=e;return}k=c[b+8>>2]|0;if((k|0)<(j|0)){if((c[b+12>>2]|0)<(j|0)){c[5004]=(c[5004]|0)+1;l=fF((j<<4|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}m=c[b+8>>2]|0;if((m|0)>0){n=0;do{s=l+(n<<4)|0;q=(c[b+16>>2]|0)+(n<<4)|0;c[s+0>>2]=c[q+0>>2];c[s+4>>2]=c[q+4>>2];c[s+8>>2]=c[q+8>>2];c[s+12>>2]=c[q+12>>2];n=n+1|0}while((n|0)!=(m|0))}m=c[b+16>>2]|0;if(m){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=l;c[b+12>>2]=j;l=b+16|0}else l=b+16|0;do{s=(c[l>>2]|0)+(k<<4)|0;c[s+0>>2]=c[e+144>>2];c[s+4>>2]=c[e+148>>2];c[s+8>>2]=c[e+152>>2];c[s+12>>2]=c[e+156>>2];k=k+1|0}while((k|0)!=(j|0))}c[b+8>>2]=j;k=c[b+28>>2]|0;if((k|0)<(j|0)){if((c[b+32>>2]|0)<(j|0)){c[5004]=(c[5004]|0)+1;l=fF((j<<4|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}n=c[b+28>>2]|0;if((n|0)>0){m=0;do{s=l+(m<<4)|0;q=(c[b+36>>2]|0)+(m<<4)|0;c[s+0>>2]=c[q+0>>2];c[s+4>>2]=c[q+4>>2];c[s+8>>2]=c[q+8>>2];c[s+12>>2]=c[q+12>>2];m=m+1|0}while((m|0)!=(n|0))}m=c[b+36>>2]|0;if(m){if(a[b+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=l;c[b+32>>2]=j;l=b+36|0}else l=b+36|0;do{s=(c[l>>2]|0)+(k<<4)|0;c[s+0>>2]=c[e+128>>2];c[s+4>>2]=c[e+132>>2];c[s+8>>2]=c[e+136>>2];c[s+12>>2]=c[e+140>>2];k=k+1|0}while((k|0)!=(j|0))}c[b+28>>2]=j;k=c[b+48>>2]|0;if((k|0)<(j|0)){if((c[b+52>>2]|0)<(j|0)){c[5004]=(c[5004]|0)+1;l=fF((j<<2|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}m=c[b+48>>2]|0;if((m|0)>0){n=0;do{o=l+(n<<2)|0;if(o)g[o>>2]=+g[(c[b+56>>2]|0)+(n<<2)>>2];n=n+1|0}while((n|0)!=(m|0))}m=c[b+56>>2]|0;if(m){if(a[b+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=l;c[b+52>>2]=j}else l=c[b+56>>2]|0;do{m=l+(k<<2)|0;if(m)g[m>>2]=0.0;k=k+1|0}while((k|0)!=(j|0))}c[b+48>>2]=j;k=c[b+68>>2]|0;if((k|0)<(j|0)){if((c[b+72>>2]|0)<(j|0)){c[5004]=(c[5004]|0)+1;l=fF((j<<2|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}n=c[b+68>>2]|0;if((n|0)>0){m=0;do{o=l+(m<<2)|0;if(o)g[o>>2]=+g[(c[b+76>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(n|0))}m=c[b+76>>2]|0;if(m){if(a[b+80>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=l;c[b+72>>2]=j}else l=c[b+76>>2]|0;do{m=l+(k<<2)|0;if(m)g[m>>2]=0.0;k=k+1|0}while((k|0)!=(j|0))}c[b+68>>2]=j;m=c[b+136>>2]|0;if((m|0)<=0){i=e;return}k=c[b+76>>2]|0;l=c[b+56>>2]|0;j=0;do{g[k+(j<<2)>>2]=0.0;g[l+(j<<2)>>2]=0.0;j=j+1|0}while((j|0)<(m|0));j=0;do{k=c[b+144>>2]|0;l=c[k+(j*284|0)+88>>2]|0;if(l){m=k+(j*284|0)+92|0;c[e+80>>2]=c[m+0>>2];c[e+84>>2]=c[m+4>>2];c[e+88>>2]=c[m+8>>2];c[e+92>>2]=c[m+12>>2];m=k+(j*284|0)+108|0;c[e+96>>2]=c[m+0>>2];c[e+100>>2]=c[m+4>>2];c[e+104>>2]=c[m+8>>2];c[e+108>>2]=c[m+12>>2];m=k+(j*284|0)+124|0;c[e+112>>2]=c[m+0>>2];c[e+116>>2]=c[m+4>>2];c[e+120>>2]=c[m+8>>2];c[e+124>>2]=c[m+12>>2];m=c[b+36>>2]|0;y=c[b+120>>2]|0;p=+g[e+80+(y<<2)+16>>2];z=+g[e+80+(y<<2)+32>>2];g[m+(j<<4)>>2]=+g[e+80+(y<<2)>>2];g[m+(j<<4)+4>>2]=p;g[m+(j<<4)+8>>2]=z;g[m+(j<<4)+12>>2]=0.0;m=c[b+36>>2]|0;y=m+(j<<4)|0;z=+g[y>>2];n=k+(j*284|0)|0;p=+g[n>>2];o=m+(j<<4)+4|0;x=+g[o>>2];s=k+(j*284|0)+4|0;r=+g[s>>2];m=m+(j<<4)+8|0;u=+g[m>>2];q=k+(j*284|0)+8|0;w=+g[q>>2];t=z-p*(z*p+x*r+u*w);v=x-r*(z*p+x*r+u*w);w=u-w*(z*p+x*r+u*w);u=1.0/+Q(+(t*t+v*v+w*w));g[y>>2]=t*u;g[o>>2]=v*u;g[m>>2]=w*u;m=c[b+16>>2]|0;r=+g[s>>2];x=+g[q>>2];p=+g[n>>2];g[m+(j<<4)>>2]=r*w*u-x*v*u;g[m+(j<<4)+4>>2]=x*t*u-w*u*p;g[m+(j<<4)+8>>2]=v*u*p-r*t*u;g[m+(j<<4)+12>>2]=0.0;m=c[b+16>>2]|0;n=m+(j<<4)|0;u=+g[n>>2];q=m+(j<<4)+4|0;t=+g[q>>2];m=m+(j<<4)+8|0;r=+g[m>>2];p=1.0/+Q(+(u*u+t*t+r*r));g[n>>2]=u*p;g[q>>2]=t*p;g[m>>2]=r*p;m=c[b+116>>2]|0;q=c[b+36>>2]|0;n=q+(j<<4)|0;s=(c[b+76>>2]|0)+(j<<2)|0;p=+g[n>>2];o=q+(j<<4)+4|0;r=+g[o>>2];q=q+(j<<4)+8|0;t=+g[q>>2];if(p*p+r*r+t*t>1.100000023841858)g[s>>2]=0.0;else{z=+g[k+(j*284|0)+16>>2];r=z- +g[m+52>>2];t=+g[k+(j*284|0)+20>>2];B=t- +g[m+56>>2];x=+g[k+(j*284|0)+24>>2];D=x- +g[m+60>>2];g[e+360>>2]=r;g[e+364>>2]=B;g[e+368>>2]=D;g[e+372>>2]=0.0;z=z- +g[l+52>>2];t=t- +g[l+56>>2];x=x- +g[l+60>>2];g[e+344>>2]=z;g[e+348>>2]=t;g[e+352>>2]=x;g[e+356>>2]=0.0;p=+g[m+332>>2];E=+g[m+336>>2];A=+g[m+328>>2];v=+g[l+332>>2];C=+g[l+336>>2];u=+g[l+328>>2];w=p*D-E*B+ +g[m+312>>2]-(v*x-C*t+ +g[l+312>>2]);x=+g[m+316>>2]+(E*r-D*A)-(+g[l+316>>2]+(C*z-x*u));z=B*A-p*r+ +g[m+320>>2]-(t*u-v*z+ +g[l+320>>2]);g[e+208>>2]=+g[m+4>>2];g[e+212>>2]=+g[m+20>>2];g[e+216>>2]=+g[m+36>>2];g[e+220>>2]=0.0;g[e+224>>2]=+g[m+8>>2];g[e+228>>2]=+g[m+24>>2];g[e+232>>2]=+g[m+40>>2];g[e+236>>2]=0.0;g[e+240>>2]=+g[m+12>>2];g[e+244>>2]=+g[m+28>>2];g[e+248>>2]=+g[m+44>>2];g[e+252>>2]=0.0;g[e+160>>2]=+g[l+4>>2];g[e+164>>2]=+g[l+20>>2];g[e+168>>2]=+g[l+36>>2];g[e+172>>2]=0.0;g[e+176>>2]=+g[l+8>>2];g[e+180>>2]=+g[l+24>>2];g[e+184>>2]=+g[l+40>>2];g[e+188>>2]=0.0;g[e+192>>2]=+g[l+12>>2];g[e+196>>2]=+g[l+28>>2];g[e+200>>2]=+g[l+44>>2];g[e+204>>2]=0.0;Mo(e+256|0,e+208|0,e+160|0,e+360|0,e+344|0,n,m+396|0,+g[m+344>>2],l+396|0,+g[l+344>>2]);g[s>>2]=1.0/+g[e+336>>2]*(w*+g[n>>2]+x*+g[o>>2]+z*+g[q>>2])*-.20000000298023224}m=c[b+136>>2]|0}j=j+1|0}while((j|0)<(m|0));if((m|0)<=0){i=e;return}o=c[b+144>>2]|0;k=0;j=0;while(1){l=c[o+(j*284|0)+88>>2]|0;if(l){p=+g[o+(j*284|0)+252>>2];if(p!=0.0){l=c[b+56>>2]|0;q=l+(j<<2)|0;g[q>>2]=0.0;n=o+(j*284|0)+280|0;g[n>>2]=1.0;m=o;r=p*d}else{E=+g[o+(j*284|0)+256>>2];E=E!=0.0?E:0.0;m=c[b+116>>2]|0;q=c[b+16>>2]|0;x=+g[o+(j*284|0)+16>>2];v=+g[o+(j*284|0)+20>>2];F=+g[o+(j*284|0)+24>>2];H=+g[q+(j<<4)>>2];u=+g[q+(j<<4)+4>>2];r=+g[q+(j<<4)+8>>2];O=x- +g[m+52>>2];P=v- +g[m+56>>2];M=F- +g[m+60>>2];L=+g[m+264>>2]*(P*r-M*u)+ +g[m+280>>2]*(M*H-O*r)+(O*u-P*H)*+g[m+296>>2];R=(P*r-M*u)*+g[m+268>>2]+(M*H-O*r)*+g[m+284>>2]+(O*u-P*H)*+g[m+300>>2];N=(P*r-M*u)*+g[m+272>>2]+(M*H-O*r)*+g[m+288>>2]+(O*u-P*H)*+g[m+304>>2];C=x- +g[l+52>>2];A=v- +g[l+56>>2];t=F- +g[l+60>>2];I=(u*C-H*A)*+g[l+296>>2]+(+g[l+264>>2]*(r*A-u*t)+ +g[l+280>>2]*(H*t-r*C));K=(r*A-u*t)*+g[l+268>>2]+(H*t-r*C)*+g[l+284>>2]+(u*C-H*A)*+g[l+300>>2];J=(r*A-u*t)*+g[l+272>>2]+(H*t-r*C)*+g[l+288>>2]+(u*C-H*A)*+g[l+304>>2];x=x- +g[m+52>>2];v=v- +g[m+56>>2];F=F- +g[m+60>>2];z=+g[m+332>>2];G=+g[m+336>>2];w=+g[m+328>>2];D=+g[l+332>>2];p=+g[l+336>>2];B=+g[l+328>>2];r=-(1.0/(+g[m+344>>2]+(r*(P*L-O*R)+(H*(M*R-P*N)+u*(O*N-M*L)))+(+g[l+344>>2]+(r*(A*I-C*K)+(H*(t*K-A*J)+u*(C*J-t*I)))))*((F*z-v*G+ +g[m+312>>2]-(t*D-A*p+ +g[l+312>>2]))*H+(+g[m+316>>2]+(x*G-F*w)-(+g[l+316>>2]+(C*p-t*B)))*u+(v*w-x*z+ +g[m+320>>2]-(A*B-C*D+ +g[l+320>>2]))*r));r=E<r?E:r;m=c[b+144>>2]|0;l=c[b+56>>2]|0;q=l+(j<<2)|0;g[q>>2]=0.0;n=m+(j*284|0)+280|0;g[n>>2]=1.0;r=r<-E?-E:r}g[n>>2]=1.0;p=+g[o+(j*284|0)+276>>2]*d*+g[o+(j*284|0)+228>>2];g[q>>2]=r;r=r*.5;t=+g[(c[b+76>>2]|0)+(j<<2)>>2];if(r*r+t*t>p*p){R=p/+Q(+(r*r+t*t));g[n>>2]=R*+g[n>>2];k=1}}else{l=c[b+56>>2]|0;g[l+(j<<2)>>2]=0.0;g[o+(j*284|0)+280>>2]=1.0;m=o}j=j+1|0;n=c[b+136>>2]|0;if((j|0)>=(n|0))break;else o=m}if(k){if((n|0)<=0){i=e;return}j=c[b+76>>2]|0;k=0;do{o=j+(k<<2)|0;if(+g[o>>2]!=0.0?(f=m+(k*284|0)+280|0,h=+g[f>>2],h<1.0):0){y=l+(k<<2)|0;g[y>>2]=h*+g[y>>2];g[o>>2]=+g[f>>2]*+g[o>>2]}k=k+1|0}while((k|0)<(n|0))}if((n|0)<=0){i=e;return}n=0;while(1){o=c[b+116>>2]|0;k=m+(n*284|0)+16|0;f=m+(n*284|0)+20|0;R=+g[f>>2]- +g[o+56>>2];j=m+(n*284|0)+24|0;h=+g[j>>2]- +g[o+60>>2];g[e+64>>2]=+g[k>>2]- +g[o+52>>2];g[e+68>>2]=R;g[e+72>>2]=h;g[e+76>>2]=0.0;h=+g[l+(n<<2)>>2];if(h!=0.0){y=c[b+16>>2]|0;P=h*+g[y+(n<<4)+4>>2];R=h*+g[y+(n<<4)+8>>2];g[e+48>>2]=h*+g[y+(n<<4)>>2];g[e+52>>2]=P;g[e+56>>2]=R;g[e+60>>2]=0.0;ym(o,e+48|0,e+64|0)}h=+g[(c[b+76>>2]|0)+(n<<2)>>2];if(h!=0.0){y=c[(c[b+144>>2]|0)+(n*284|0)+88>>2]|0;L=+g[f>>2]- +g[y+56>>2];N=+g[j>>2]- +g[y+60>>2];g[e+32>>2]=+g[k>>2]- +g[y+52>>2];g[e+36>>2]=L;g[e+40>>2]=N;g[e+44>>2]=0.0;s=c[b+36>>2]|0;N=h*+g[s+(n<<4)+4>>2];L=h*+g[s+(n<<4)+8>>2];g[e+16>>2]=+g[s+(n<<4)>>2]*h;g[e+20>>2]=N;g[e+24>>2]=L;g[e+28>>2]=0.0;s=c[b+116>>2]|0;q=c[b+124>>2]|0;L=+g[s+(q<<2)+4>>2];N=+g[s+(q<<2)+20>>2];R=+g[s+(q<<2)+36>>2];K=+g[e+64>>2];M=+g[e+68>>2];O=+g[e+72>>2];P=(L*K+N*M+R*O)*(1.0- +g[m+(n*284|0)+244>>2]);g[e+64>>2]=K-L*P;g[e+68>>2]=M-N*P;g[e+72>>2]=O-R*P;ym(s,e+16|0,e+64|0);P=-+g[e+20>>2];R=-+g[e+24>>2];g[e>>2]=-+g[e+16>>2];g[e+4>>2]=P;g[e+8>>2]=R;g[e+12>>2]=0.0;ym(y,e,e+32|0)}n=n+1|0;if((n|0)>=(c[b+136>>2]|0))break;m=c[b+144>>2]|0;l=c[b+56>>2]|0}i=e;return}function cr(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0,m=0;e=i;i=i+48|0;if((c[b+136>>2]|0)<=0){i=e;return}f=0;do{m=c[b+144>>2]|0;g[e+32>>2]=(a[m+(f*284|0)+84>>0]|0)==0?1.0:0.0;g[e+36>>2]=0.0;g[e+40>>2]=1.0;g[e+44>>2]=0.0;l=m+(f*284|0)+140|0;c[e+16>>2]=c[l+0>>2];c[e+20>>2]=c[l+4>>2];c[e+24>>2]=c[l+8>>2];c[e+28>>2]=c[l+12>>2];l=c[b+120>>2]|0;h=c[(c[d>>2]|0)+8>>2]|0;k=+g[m+(f*284|0)+(l<<2)+108>>2]+ +g[e+20>>2];j=+g[m+(f*284|0)+(l<<2)+124>>2]+ +g[e+24>>2];g[e>>2]=+g[m+(f*284|0)+(l<<2)+92>>2]+ +g[e+16>>2];g[e+4>>2]=k;g[e+8>>2]=j;g[e+12>>2]=0.0;vc[h&127](d,e+16|0,e,e+32|0);vc[c[(c[d>>2]|0)+8>>2]&127](d,e+16|0,(c[b+144>>2]|0)+(f*284|0)+16|0,e+32|0);f=f+1|0}while((f|0)<(c[b+136>>2]|0));i=e;return}function dr(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0;h=i;i=i+96|0;g[h+4>>2]=1.0;c[h+8>>2]=0;b[h+12>>1]=1;b[h+14>>1]=-1;c[h+16>>2]=0;c[h>>2]=336;c[h+20>>2]=c[d+0>>2];c[h+24>>2]=c[d+4>>2];c[h+28>>2]=c[d+8>>2];c[h+32>>2]=c[d+12>>2];c[h+36>>2]=c[e+0>>2];c[h+40>>2]=c[e+4>>2];c[h+44>>2]=c[e+8>>2];c[h+48>>2]=c[e+12>>2];a=c[a+4>>2]|0;vc[c[(c[a>>2]|0)+32>>2]&127](a,d,e,h);e=c[h+8>>2]|0;if(!e){a=0;i=h;return a|0}if(!(c[e+236>>2]&2)){a=0;i=h;return a|0}if(c[e+204>>2]&4){a=0;i=h;return a|0}c[f+0>>2]=c[h+68>>2];c[f+4>>2]=c[h+72>>2];c[f+8>>2]=c[h+76>>2];c[f+12>>2]=c[h+80>>2];c[f+16>>2]=c[h+52>>2];c[f+20>>2]=c[h+56>>2];c[f+24>>2]=c[h+60>>2];c[f+28>>2]=c[h+64>>2];m=+g[f+16>>2];l=+g[f+20>>2];k=+g[f+24>>2];j=1.0/+Q(+(m*m+l*l+k*k));g[f+16>>2]=m*j;g[f+20>>2]=l*j;g[f+24>>2]=k*j;g[f+32>>2]=+g[h+4>>2];a=e;i=h;return a|0}function er(a,b,d){a=a|0;b=b|0;d=+d;b=i;Kb[c[(c[a>>2]|0)+16>>2]&31](a,d);i=b;return}function fr(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+120>>2]=b;c[a+124>>2]=d;c[a+128>>2]=e;return}function gr(a){a=a|0;return}function hr(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function ir(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=3912;e=c[b+496>>2]|0;if(!e){a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0}else{if(a[b+500>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function jr(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+192>>2]=b;c[a+200>>2]=b;return}function kr(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;e=i;c[b+236>>2]=2;c[b+312>>2]=0;c[b+316>>2]=0;c[b+320>>2]=0;c[b+324>>2]=0;c[b+328>>2]=0;c[b+332>>2]=0;c[b+336>>2]=0;c[b+340>>2]=0;g[b+544>>2]=1.0;g[b+548>>2]=1.0;g[b+552>>2]=1.0;g[b+556>>2]=0.0;g[b+348>>2]=1.0;g[b+352>>2]=1.0;g[b+356>>2]=1.0;l=b+360|0;k=l+36|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(k|0));c[b+412>>2]=0;c[b+416>>2]=0;c[b+420>>2]=0;c[b+424>>2]=0;c[b+428>>2]=0;c[b+432>>2]=0;c[b+436>>2]=0;c[b+440>>2]=0;h=+g[d+92>>2];f=+g[d+96>>2];if(h<0.0)h=0.0;else h=h>1.0?1.0:h;g[b+444>>2]=h;if(f<0.0)f=0.0;else f=f>1.0?1.0:f;g[b+448>>2]=f;g[b+472>>2]=+g[d+112>>2];g[b+476>>2]=+g[d+116>>2];k=c[d+4>>2]|0;c[b+480>>2]=k;c[b+608>>2]=0;c[b+612>>2]=0;a[b+452>>0]=a[d+120>>0]|0;g[b+456>>2]=+g[d+124>>2];g[b+460>>2]=+g[d+128>>2];g[b+464>>2]=+g[d+132>>2];g[b+468>>2]=+g[d+136>>2];if(!k){c[b+4>>2]=c[d+8>>2];c[b+8>>2]=c[d+12>>2];c[b+12>>2]=c[d+16>>2];c[b+16>>2]=c[d+20>>2];c[b+20>>2]=c[d+24>>2];c[b+24>>2]=c[d+28>>2];c[b+28>>2]=c[d+32>>2];c[b+32>>2]=c[d+36>>2];c[b+36>>2]=c[d+40>>2];c[b+40>>2]=c[d+44>>2];c[b+44>>2]=c[d+48>>2];c[b+48>>2]=c[d+52>>2];c[b+52>>2]=c[d+56>>2];c[b+56>>2]=c[d+60>>2];c[b+60>>2]=c[d+64>>2];c[b+64>>2]=c[d+68>>2];n=b+52|0;m=b+20|0;k=b+36|0;l=b+4|0}else{Nb[c[(c[k>>2]|0)+8>>2]&127](k,b+4|0);n=b+52|0;m=b+20|0;k=b+36|0;l=b+4|0}c[b+68>>2]=c[l+0>>2];c[b+72>>2]=c[l+4>>2];c[b+76>>2]=c[l+8>>2];c[b+80>>2]=c[l+12>>2];c[b+84>>2]=c[m+0>>2];c[b+88>>2]=c[m+4>>2];c[b+92>>2]=c[m+8>>2];c[b+96>>2]=c[m+12>>2];c[b+100>>2]=c[k+0>>2];c[b+104>>2]=c[k+4>>2];c[b+108>>2]=c[k+8>>2];c[b+112>>2]=c[k+12>>2];c[b+116>>2]=c[n+0>>2];c[b+120>>2]=c[n+4>>2];c[b+124>>2]=c[n+8>>2];c[b+128>>2]=c[n+12>>2];c[b+132>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+144>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;c[b+156>>2]=0;c[b+160>>2]=0;g[b+224>>2]=+g[d+100>>2];g[b+232>>2]=+g[d+104>>2];g[b+228>>2]=+g[d+108>>2];Nb[c[(c[b>>2]|0)+12>>2]&127](b,c[d+72>>2]|0);k=c[986]|0;c[986]=k+1;c[b+508>>2]=k;h=+g[d>>2];k=c[b+204>>2]|0;if(h==0.0){c[b+204>>2]=k|1;g[b+344>>2]=0.0;f=0.0}else{c[b+204>>2]=k&-2;g[b+344>>2]=1.0/h;f=1.0/h}j=h*+g[b+384>>2];o=h*+g[b+388>>2];g[b+364>>2]=h*+g[b+380>>2];g[b+368>>2]=j;g[b+372>>2]=o;g[b+376>>2]=0.0;h=+g[d+76>>2];if(h!=0.0)h=1.0/h;else h=0.0;j=+g[d+80>>2];if(j!=0.0)j=1.0/j;else j=0.0;o=+g[d+84>>2];if(o!=0.0)o=1.0/o;else o=0.0;g[b+396>>2]=h;g[b+400>>2]=j;g[b+404>>2]=o;g[b+408>>2]=0.0;D=f*+g[b+352>>2];x=f*+g[b+356>>2];g[b+560>>2]=f*+g[b+348>>2];g[b+564>>2]=D;g[b+568>>2]=x;g[b+572>>2]=0.0;x=+g[b+4>>2];D=x*h;w=+g[b+8>>2];C=w*j;v=+g[b+12>>2];B=v*o;u=+g[b+20>>2];A=h*u;t=+g[b+24>>2];z=j*t;s=+g[b+28>>2];y=o*s;r=+g[b+36>>2];q=h*r;p=+g[b+40>>2];f=j*p;j=+g[b+44>>2];h=o*j;g[b+264>>2]=x*D+w*C+v*B;g[b+268>>2]=D*u+C*t+B*s;g[b+272>>2]=D*r+C*p+B*j;g[b+276>>2]=0.0;g[b+280>>2]=x*A+w*z+v*y;g[b+284>>2]=u*A+t*z+s*y;g[b+288>>2]=A*r+z*p+y*j;g[b+292>>2]=0.0;g[b+296>>2]=x*q+w*f+v*h;g[b+300>>2]=u*q+t*f+s*h;g[b+304>>2]=r*q+p*f+j*h;g[b+308>>2]=0.0;c[b+504>>2]=0;c[b+512>>2]=0;c[b+516>>2]=0;c[b+520>>2]=0;c[b+524>>2]=0;c[b+528>>2]=0;c[b+532>>2]=0;c[b+536>>2]=0;c[b+540>>2]=0;h=+g[b+344>>2];j=h*+g[b+352>>2];o=h*+g[b+356>>2];g[b+560>>2]=+g[b+348>>2]*h;g[b+564>>2]=j;g[b+568>>2]=o;l=b+572|0;k=l+36|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(k|0));i=e;return}function lr(b,d,e,f,h){b=b|0;d=+d;e=e|0;f=f|0;h=h|0;var j=0;j=i;i=i+144|0;g[b+164>>2]=1.0;g[b+168>>2]=1.0;g[b+172>>2]=1.0;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749400.0;c[b+188>>2]=0;c[b+192>>2]=0;c[b+196>>2]=0;c[b+200>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+236>>2]=1;c[b+240>>2]=0;g[b+244>>2]=1.0;c[b+248>>2]=0;c[b+252>>2]=0;c[b+256>>2]=0;c[b+260>>2]=0;g[b+4>>2]=1.0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;g[b+24>>2]=1.0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;g[b+44>>2]=1.0;c[b+48>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;c[b+64>>2]=0;c[b>>2]=3912;a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;g[j>>2]=d;c[j+4>>2]=e;c[j+72>>2]=f;c[j+76>>2]=c[h+0>>2];c[j+80>>2]=c[h+4>>2];c[j+84>>2]=c[h+8>>2];c[j+88>>2]=c[h+12>>2];g[j+92>>2]=0.0;g[j+96>>2]=0.0;g[j+100>>2]=.5;g[j+104>>2]=0.0;g[j+108>>2]=0.0;g[j+112>>2]=.800000011920929;g[j+116>>2]=1.0;a[j+120>>0]=0;g[j+124>>2]=.004999999888241291;g[j+128>>2]=.009999999776482582;g[j+132>>2]=.009999999776482582;g[j+136>>2]=.009999999776482582;g[j+8>>2]=1.0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[j+24>>2]=0;g[j+28>>2]=1.0;c[j+32>>2]=0;c[j+36>>2]=0;c[j+40>>2]=0;c[j+44>>2]=0;g[j+48>>2]=1.0;c[j+52>>2]=0;c[j+56>>2]=0;c[j+60>>2]=0;c[j+64>>2]=0;c[j+68>>2]=0;kr(b,j);i=j;return}function mr(a,b,d){a=a|0;b=+b;d=d|0;var e=0.0,f=0.0,h=0.0,i=0;i=c[a+204>>2]|0;if(b==0.0){c[a+204>>2]=i|1;g[a+344>>2]=0.0;e=0.0}else{c[a+204>>2]=i&-2;g[a+344>>2]=1.0/b;e=1.0/b}f=+g[a+384>>2]*b;h=+g[a+388>>2]*b;g[a+364>>2]=+g[a+380>>2]*b;g[a+368>>2]=f;g[a+372>>2]=h;g[a+376>>2]=0.0;b=+g[d>>2];if(b!=0.0)b=1.0/b;else b=0.0;f=+g[d+4>>2];if(f!=0.0)f=1.0/f;else f=0.0;h=+g[d+8>>2];if(h!=0.0)h=1.0/h;else h=0.0;g[a+396>>2]=b;g[a+400>>2]=f;g[a+404>>2]=h;g[a+408>>2]=0.0;f=e*+g[a+352>>2];h=e*+g[a+356>>2];g[a+560>>2]=+g[a+348>>2]*e;g[a+564>>2]=f;g[a+568>>2]=h;g[a+572>>2]=0.0;return}function nr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;j=i;if(!(c[a+204>>2]&2)){c[a+68>>2]=c[b+0>>2];c[a+72>>2]=c[b+4>>2];c[a+76>>2]=c[b+8>>2];c[a+80>>2]=c[b+12>>2];c[a+84>>2]=c[b+16>>2];c[a+88>>2]=c[b+20>>2];c[a+92>>2]=c[b+24>>2];c[a+96>>2]=c[b+28>>2];c[a+100>>2]=c[b+32>>2];c[a+104>>2]=c[b+36>>2];c[a+108>>2]=c[b+40>>2];c[a+112>>2]=c[b+44>>2];c[a+116>>2]=c[b+48>>2];c[a+120>>2]=c[b+52>>2];c[a+124>>2]=c[b+56>>2];c[a+128>>2]=c[b+60>>2];l=a+20|0;m=b+16|0;d=a+36|0;k=b+32|0;f=a+52|0;h=b+48|0;e=a+4|0}else{c[a+68>>2]=c[a+4>>2];c[a+72>>2]=c[a+8>>2];c[a+76>>2]=c[a+12>>2];c[a+80>>2]=c[a+16>>2];c[a+84>>2]=c[a+20>>2];c[a+88>>2]=c[a+24>>2];c[a+92>>2]=c[a+28>>2];c[a+96>>2]=c[a+32>>2];c[a+100>>2]=c[a+36>>2];c[a+104>>2]=c[a+40>>2];c[a+108>>2]=c[a+44>>2];c[a+112>>2]=c[a+48>>2];c[a+116>>2]=c[a+52>>2];c[a+120>>2]=c[a+56>>2];c[a+124>>2]=c[a+60>>2];c[a+128>>2]=c[a+64>>2];l=a+20|0;m=b+16|0;d=a+36|0;k=b+32|0;f=a+52|0;h=b+48|0;e=a+4|0}c[a+132>>2]=c[a+312>>2];c[a+136>>2]=c[a+316>>2];c[a+140>>2]=c[a+320>>2];c[a+144>>2]=c[a+324>>2];c[a+148>>2]=c[a+328>>2];c[a+152>>2]=c[a+332>>2];c[a+156>>2]=c[a+336>>2];c[a+160>>2]=c[a+340>>2];c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];c[l+0>>2]=c[m+0>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];c[d+0>>2]=c[k+0>>2];c[d+4>>2]=c[k+4>>2];c[d+8>>2]=c[k+8>>2];c[d+12>>2]=c[k+12>>2];c[f+0>>2]=c[h+0>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];y=+g[a+4>>2];s=+g[a+396>>2];x=+g[a+8>>2];q=+g[a+400>>2];w=+g[a+12>>2];o=+g[a+404>>2];v=+g[a+20>>2];u=+g[a+24>>2];t=+g[a+28>>2];r=+g[a+36>>2];p=+g[a+40>>2];n=+g[a+44>>2];g[a+264>>2]=y*y*s+x*x*q+w*w*o;g[a+268>>2]=y*s*v+x*q*u+w*o*t;g[a+272>>2]=y*s*r+x*q*p+w*o*n;g[a+276>>2]=0.0;g[a+280>>2]=y*s*v+x*q*u+w*o*t;g[a+284>>2]=v*s*v+u*q*u+t*o*t;g[a+288>>2]=s*v*r+q*u*p+o*t*n;g[a+292>>2]=0.0;g[a+296>>2]=y*s*r+x*q*p+w*o*n;g[a+300>>2]=v*s*r+u*q*p+t*o*n;g[a+304>>2]=r*s*r+p*q*p+n*o*n;g[a+308>>2]=0.0;i=j;return}function or(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;a:do if((c[d+236>>2]&2|0)!=0?(f=c[b+488>>2]|0,(f|0)>0):0){b=c[b+496>>2]|0;g=0;while(1){h=c[b+(g<<2)>>2]|0;if(a[h+20>>0]|0){if((c[h+28>>2]|0)==(d|0)){d=0;break a}if((c[h+32>>2]|0)==(d|0)){d=0;break a}}g=g+1|0;if((g|0)>=(f|0)){d=1;break}}}else d=1;while(0);i=e;return d|0}function pr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;h=c[b+488>>2]|0;a:do if((h|0)>0){j=c[b+496>>2]|0;g=0;while(1){k=g+1|0;if((c[j+(g<<2)>>2]|0)==(d|0))break;if((k|0)<(h|0))g=k;else break a}if((g|0)!=(h|0)){k=b+256|0;c[k>>2]=1;i=e;return}}while(0);if((h|0)==(c[b+492>>2]|0)?(f=(h|0)==0?1:h<<1,(h|0)<(f|0)):0){if(!f)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[b+488>>2]|0}if((h|0)>0){j=0;do{k=g+(j<<2)|0;if(k)c[k>>2]=c[(c[b+496>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[b+496>>2]|0;if(j){if(a[b+500>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[b+488>>2]|0}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=g;c[b+492>>2]=f}f=(c[b+496>>2]|0)+(h<<2)|0;if(f)c[f>>2]=d;c[b+488>>2]=h+1;k=b+256|0;c[k>>2]=1;i=e;return}function qr(a){a=a|0;return 488}function rr(a,b,e){a=a|0;b=b|0;e=e|0;var f=0;f=i;pu(a,b,e)|0;g[b+256>>2]=+g[a+264>>2];g[b+260>>2]=+g[a+268>>2];g[b+264>>2]=+g[a+272>>2];g[b+268>>2]=+g[a+276>>2];g[b+272>>2]=+g[a+280>>2];g[b+276>>2]=+g[a+284>>2];g[b+280>>2]=+g[a+288>>2];g[b+284>>2]=+g[a+292>>2];g[b+288>>2]=+g[a+296>>2];g[b+292>>2]=+g[a+300>>2];g[b+296>>2]=+g[a+304>>2];g[b+300>>2]=+g[a+308>>2];g[b+304>>2]=+g[a+312>>2];g[b+308>>2]=+g[a+316>>2];g[b+312>>2]=+g[a+320>>2];g[b+316>>2]=+g[a+324>>2];g[b+320>>2]=+g[a+328>>2];g[b+324>>2]=+g[a+332>>2];g[b+328>>2]=+g[a+336>>2];g[b+332>>2]=+g[a+340>>2];g[b+448>>2]=+g[a+344>>2];g[b+336>>2]=+g[a+544>>2];g[b+340>>2]=+g[a+548>>2];g[b+344>>2]=+g[a+552>>2];g[b+348>>2]=+g[a+556>>2];g[b+352>>2]=+g[a+348>>2];g[b+356>>2]=+g[a+352>>2];g[b+360>>2]=+g[a+356>>2];g[b+364>>2]=+g[a+360>>2];g[b+368>>2]=+g[a+364>>2];g[b+372>>2]=+g[a+368>>2];g[b+376>>2]=+g[a+372>>2];g[b+380>>2]=+g[a+376>>2];g[b+384>>2]=+g[a+380>>2];g[b+388>>2]=+g[a+384>>2];g[b+392>>2]=+g[a+388>>2];g[b+396>>2]=+g[a+392>>2];g[b+400>>2]=+g[a+396>>2];g[b+404>>2]=+g[a+400>>2];g[b+408>>2]=+g[a+404>>2];g[b+412>>2]=+g[a+408>>2];g[b+416>>2]=+g[a+412>>2];g[b+420>>2]=+g[a+416>>2];g[b+424>>2]=+g[a+420>>2];g[b+428>>2]=+g[a+424>>2];g[b+432>>2]=+g[a+428>>2];g[b+436>>2]=+g[a+432>>2];g[b+440>>2]=+g[a+436>>2];g[b+444>>2]=+g[a+440>>2];g[b+452>>2]=+g[a+444>>2];g[b+456>>2]=+g[a+448>>2];c[b+484>>2]=d[a+452>>0];g[b+460>>2]=+g[a+456>>2];g[b+464>>2]=+g[a+460>>2];g[b+468>>2]=+g[a+464>>2];g[b+472>>2]=+g[a+468>>2];g[b+476>>2]=+g[a+472>>2];g[b+480>>2]=+g[a+476>>2];i=f;return 3952}function sr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;e=c[(c[b>>2]|0)+16>>2]|0;f=Pb[c[(c[a>>2]|0)+16>>2]&127](a)|0;f=Yb[e&31](b,f,1)|0;e=Yb[c[(c[a>>2]|0)+20>>2]&31](a,c[f+8>>2]|0,b)|0;Jb[c[(c[b>>2]|0)+20>>2]&31](b,f,e,1497645650,a);i=d;return}function tr(a){a=a|0;var b=0;b=i;ur(a);if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function ur(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=4024;e=c[b+176>>2]|0;if(e){if(a[b+180>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;e=c[b+156>>2]|0;if(e){if(a[b+160>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;e=c[b+136>>2]|0;if(e){if(a[b+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;e=c[b+116>>2]|0;if(e){if(a[b+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;e=c[b+96>>2]|0;if(e){if(a[b+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;e=c[b+76>>2]|0;if(e){if(a[b+80>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;e=c[b+56>>2]|0;if(e){if(a[b+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;e=c[b+36>>2]|0;if(e){if(a[b+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;e=c[b+16>>2]|0;if(!e){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;e=b+12|0;c[e>>2]=0;i=d;return}if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;e=b+12|0;c[e>>2]=0;i=d;return}function vr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0.0;j=i;k=+g[d+100>>2];h=+g[d+16>>2];e=+g[d+20>>2];f=+g[d+24>>2];l=+g[d+108>>2];l=+g[d+112>>2]-k*+g[d+116>>2]-(h*+g[a+64>>2]+e*+g[a+68>>2]+f*+g[a+72>>2]+(+g[d>>2]*+g[a+80>>2]+ +g[d+4>>2]*+g[a+84>>2]+ +g[d+8>>2]*+g[a+88>>2]))*l-l*(+g[d+48>>2]*+g[b+64>>2]+ +g[d+52>>2]*+g[b+68>>2]+ +g[d+56>>2]*+g[b+72>>2]+(+g[d+32>>2]*+g[b+80>>2]+ +g[d+36>>2]*+g[b+84>>2]+ +g[d+40>>2]*+g[b+88>>2]));m=+g[d+120>>2];do if(!(k+l<m)){m=+g[d+124>>2];if(k+l>m){g[d+100>>2]=m;l=m-k;break}else{g[d+100>>2]=k+l;break}}else{g[d+100>>2]=m;l=m-k}while(0);if(c[a+240>>2]|0){m=l*+g[a+132>>2]*e*+g[a+116>>2];k=l*+g[a+136>>2]*f*+g[a+120>>2];g[a+64>>2]=+g[a+112>>2]*l*+g[a+128>>2]*h+ +g[a+64>>2];g[a+68>>2]=m+ +g[a+68>>2];g[a+72>>2]=k+ +g[a+72>>2];k=l*+g[a+100>>2]*+g[d+68>>2];m=l*+g[a+104>>2]*+g[d+72>>2];g[a+80>>2]=l*+g[a+96>>2]*+g[d+64>>2]+ +g[a+80>>2];g[a+84>>2]=k+ +g[a+84>>2];g[a+88>>2]=m+ +g[a+88>>2]}if(!(c[b+240>>2]|0)){i=j;return}m=l*+g[b+132>>2]*+g[d+52>>2]*+g[b+116>>2];k=l*+g[b+136>>2]*+g[d+56>>2]*+g[b+120>>2];g[b+64>>2]=+g[b+112>>2]*l*+g[b+128>>2]*+g[d+48>>2]+ +g[b+64>>2];g[b+68>>2]=m+ +g[b+68>>2];g[b+72>>2]=k+ +g[b+72>>2];k=l*+g[b+100>>2]*+g[d+84>>2];m=l*+g[b+104>>2]*+g[d+88>>2];g[b+80>>2]=l*+g[b+96>>2]*+g[d+80>>2]+ +g[b+80>>2];g[b+84>>2]=k+ +g[b+84>>2];g[b+88>>2]=m+ +g[b+88>>2];i=j;return}function wr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0;j=i;m=+g[d+100>>2];h=+g[d+16>>2];e=+g[d+20>>2];f=+g[d+24>>2];n=+g[d+108>>2];n=+g[d+112>>2]-m*+g[d+116>>2]-(h*+g[a+64>>2]+e*+g[a+68>>2]+f*+g[a+72>>2]+(+g[d>>2]*+g[a+80>>2]+ +g[d+4>>2]*+g[a+84>>2]+ +g[d+8>>2]*+g[a+88>>2]))*n-n*(+g[d+48>>2]*+g[b+64>>2]+ +g[d+52>>2]*+g[b+68>>2]+ +g[d+56>>2]*+g[b+72>>2]+(+g[d+32>>2]*+g[b+80>>2]+ +g[d+36>>2]*+g[b+84>>2]+ +g[d+40>>2]*+g[b+88>>2]));l=+g[d+120>>2];if(m+n<l)k=l-m;else{k=n;l=m+n}g[d+100>>2]=l;if(c[a+240>>2]|0){n=k*+g[a+132>>2]*e*+g[a+116>>2];m=k*+g[a+136>>2]*f*+g[a+120>>2];g[a+64>>2]=+g[a+112>>2]*k*+g[a+128>>2]*h+ +g[a+64>>2];g[a+68>>2]=n+ +g[a+68>>2];g[a+72>>2]=m+ +g[a+72>>2];m=k*+g[a+100>>2]*+g[d+68>>2];n=k*+g[a+104>>2]*+g[d+72>>2];g[a+80>>2]=k*+g[a+96>>2]*+g[d+64>>2]+ +g[a+80>>2];g[a+84>>2]=m+ +g[a+84>>2];g[a+88>>2]=n+ +g[a+88>>2]}if(!(c[b+240>>2]|0)){i=j;return}n=k*+g[b+132>>2]*+g[d+52>>2]*+g[b+116>>2];m=k*+g[b+136>>2]*+g[d+56>>2]*+g[b+120>>2];g[b+64>>2]=+g[b+112>>2]*k*+g[b+128>>2]*+g[d+48>>2]+ +g[b+64>>2];g[b+68>>2]=n+ +g[b+68>>2];g[b+72>>2]=m+ +g[b+72>>2];m=k*+g[b+100>>2]*+g[d+84>>2];n=k*+g[b+104>>2]*+g[d+88>>2];g[b+80>>2]=k*+g[b+96>>2]*+g[d+80>>2]+ +g[b+80>>2];g[b+84>>2]=m+ +g[b+84>>2];g[b+88>>2]=n+ +g[b+88>>2];i=j;return}function xr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0;j=i;l=+g[d+128>>2];if(!(l!=0.0)){i=j;return}c[1002]=(c[1002]|0)+1;k=+g[d+96>>2];f=+g[d+16>>2];h=+g[d+20>>2];e=+g[d+24>>2];n=+g[d+108>>2];n=l-k*+g[d+116>>2]-(f*+g[a+144>>2]+h*+g[a+148>>2]+e*+g[a+152>>2]+(+g[d>>2]*+g[a+160>>2]+ +g[d+4>>2]*+g[a+164>>2]+ +g[d+8>>2]*+g[a+168>>2]))*n-n*(+g[d+48>>2]*+g[b+144>>2]+ +g[d+52>>2]*+g[b+148>>2]+ +g[d+56>>2]*+g[b+152>>2]+(+g[d+32>>2]*+g[b+160>>2]+ +g[d+36>>2]*+g[b+164>>2]+ +g[d+40>>2]*+g[b+168>>2]));m=+g[d+120>>2];if(k+n<m)l=m-k;else{l=n;m=k+n}g[d+96>>2]=m;if(c[a+240>>2]|0){n=l*+g[a+132>>2]*h*+g[a+116>>2];m=l*+g[a+136>>2]*e*+g[a+120>>2];g[a+144>>2]=+g[a+112>>2]*l*+g[a+128>>2]*f+ +g[a+144>>2];g[a+148>>2]=n+ +g[a+148>>2];g[a+152>>2]=m+ +g[a+152>>2];m=l*+g[a+100>>2]*+g[d+68>>2];n=l*+g[a+104>>2]*+g[d+72>>2];g[a+160>>2]=l*+g[a+96>>2]*+g[d+64>>2]+ +g[a+160>>2];g[a+164>>2]=m+ +g[a+164>>2];g[a+168>>2]=n+ +g[a+168>>2]}if(!(c[b+240>>2]|0)){i=j;return}n=l*+g[b+132>>2]*+g[d+52>>2]*+g[b+116>>2];m=l*+g[b+136>>2]*+g[d+56>>2]*+g[b+120>>2];g[b+144>>2]=+g[b+112>>2]*l*+g[b+128>>2]*+g[d+48>>2]+ +g[b+144>>2];g[b+148>>2]=n+ +g[b+148>>2];g[b+152>>2]=m+ +g[b+152>>2];m=l*+g[b+100>>2]*+g[d+84>>2];n=l*+g[b+104>>2]*+g[d+88>>2];g[b+160>>2]=l*+g[b+96>>2]*+g[d+80>>2]+ +g[b+160>>2];g[b+164>>2]=m+ +g[b+164>>2];g[b+168>>2]=n+ +g[b+168>>2];i=j;return}function yr(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0;e=i;if(!((b|0)!=0?(c[b+236>>2]&2|0)!=0:0))b=0;f=(b|0)==0;c[a+64>>2]=0;c[a+68>>2]=0;c[a+72>>2]=0;c[a+76>>2]=0;c[a+80>>2]=0;c[a+84>>2]=0;c[a+88>>2]=0;c[a+92>>2]=0;c[a+144>>2]=0;c[a+148>>2]=0;c[a+152>>2]=0;c[a+156>>2]=0;c[a+160>>2]=0;c[a+164>>2]=0;c[a+168>>2]=0;c[a+172>>2]=0;if(f){g[a>>2]=1.0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;g[a+20>>2]=1.0;c[a+24>>2]=0;c[a+28>>2]=0;c[a+32>>2]=0;c[a+36>>2]=0;g[a+40>>2]=1.0;c[a+44>>2]=0;c[a+48>>2]=0;c[a+52>>2]=0;c[a+56>>2]=0;c[a+60>>2]=0;c[a+240>>2]=0;c[a+128>>2]=0;c[a+132>>2]=0;c[a+136>>2]=0;c[a+140>>2]=0;g[a+96>>2]=1.0;g[a+100>>2]=1.0;g[a+104>>2]=1.0;g[a+108>>2]=0.0;g[a+112>>2]=1.0;g[a+116>>2]=1.0;g[a+120>>2]=1.0;g[a+124>>2]=0.0;b=a+176|0;a=b+64|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(a|0));i=e;return}else{f=b+4|0;c[a+0>>2]=c[f+0>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];f=b+20|0;c[a+16>>2]=c[f+0>>2];c[a+20>>2]=c[f+4>>2];c[a+24>>2]=c[f+8>>2];c[a+28>>2]=c[f+12>>2];f=b+36|0;c[a+32>>2]=c[f+0>>2];c[a+36>>2]=c[f+4>>2];c[a+40>>2]=c[f+8>>2];c[a+44>>2]=c[f+12>>2];f=b+52|0;c[a+48>>2]=c[f+0>>2];c[a+52>>2]=c[f+4>>2];c[a+56>>2]=c[f+8>>2];c[a+60>>2]=c[f+12>>2];f=b+344|0;m=+g[f>>2];n=b+348|0;l=m*+g[b+352>>2];k=m*+g[b+356>>2];g[a+128>>2]=m*+g[n>>2];g[a+132>>2]=l;g[a+136>>2]=k;g[a+140>>2]=0.0;c[a+240>>2]=b;o=b+544|0;c[a+96>>2]=c[o+0>>2];c[a+100>>2]=c[o+4>>2];c[a+104>>2]=c[o+8>>2];c[a+108>>2]=c[o+12>>2];c[a+112>>2]=c[n+0>>2];c[a+116>>2]=c[n+4>>2];c[a+120>>2]=c[n+8>>2];c[a+124>>2]=c[n+12>>2];n=b+312|0;c[a+176>>2]=c[n+0>>2];c[a+180>>2]=c[n+4>>2];c[a+184>>2]=c[n+8>>2];c[a+188>>2]=c[n+12>>2];n=b+328|0;c[a+192>>2]=c[n+0>>2];c[a+196>>2]=c[n+4>>2];c[a+200>>2]=c[n+8>>2];c[a+204>>2]=c[n+12>>2];k=+g[f>>2];l=k*+g[b+416>>2]*d;m=k*+g[b+420>>2]*d;g[a+208>>2]=k*+g[b+412>>2]*d;g[a+212>>2]=l;g[a+216>>2]=m;g[a+220>>2]=0.0;m=+g[b+428>>2];l=+g[b+432>>2];k=+g[b+436>>2];j=(m*+g[b+268>>2]+l*+g[b+284>>2]+k*+g[b+300>>2])*d;h=(m*+g[b+272>>2]+l*+g[b+288>>2]+k*+g[b+304>>2])*d;g[a+224>>2]=(+g[b+264>>2]*m+ +g[b+280>>2]*l+ +g[b+296>>2]*k)*d;g[a+228>>2]=j;g[a+232>>2]=h;g[a+236>>2]=0.0;i=e;return}}function zr(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;d=i;if(!a){i=d;return}if(!(c[a+180>>2]&1)){i=d;return}r=+g[a+4>>2];t=+g[b>>2];o=+g[a+20>>2];s=+g[b+4>>2];l=+g[a+36>>2];e=+g[b+8>>2];q=+g[a+8>>2];n=+g[a+24>>2];j=+g[a+40>>2];p=+g[a+12>>2];m=+g[a+28>>2];f=+g[a+44>>2];k=(r*t+o*s+l*e)*+g[a+164>>2];h=(t*q+s*n+e*j)*+g[a+168>>2];e=(t*p+s*m+e*f)*+g[a+172>>2];g[b>>2]=r*k+q*h+p*e;g[b+4>>2]=o*k+n*h+m*e;g[b+8>>2]=l*k+j*h+f*e;g[b+12>>2]=0.0;i=d;return}function Ar(b,d,e,f,h,j,k,l,m,n,o){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=+m;n=+n;o=+o;var p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0.0,H=0.0,I=0.0;q=i;p=c[b+68>>2]|0;if((p|0)==(c[b+72>>2]|0)?(r=(p|0)==0?1:p<<1,(p|0)<(r|0)):0){if(!r){x=0;F=p}else{c[5004]=(c[5004]|0)+1;x=fF((r*152|3)+16|0)|0;if(!x)x=0;else{c[(x+19&-16)+ -4>>2]=x;x=x+19&-16}F=c[b+68>>2]|0}if((F|0)>0){E=0;do{mF(x+(E*152|0)|0,(c[b+76>>2]|0)+(E*152|0)|0,152)|0;E=E+1|0}while((E|0)!=(F|0))}E=c[b+76>>2]|0;if(E){if(a[b+80>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[E+ -4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=x;c[b+72>>2]=r;r=c[b+68>>2]|0}else r=p;c[b+68>>2]=r+1;r=c[b+76>>2]|0;c[r+(p*152|0)+140>>2]=h;h=c[b+16>>2]|0;x=c[h+(e*244|0)+240>>2]|0;b=c[h+(f*244|0)+240>>2]|0;c[r+(p*152|0)+144>>2]=e;c[r+(p*152|0)+148>>2]=f;v=+g[j+84>>2];g[r+(p*152|0)+104>>2]=v;c[r+(p*152|0)+132>>2]=0;g[r+(p*152|0)+100>>2]=0.0;g[r+(p*152|0)+96>>2]=0.0;if(x){c[r+(p*152|0)+16>>2]=c[d+0>>2];c[r+(p*152|0)+20>>2]=c[d+4>>2];c[r+(p*152|0)+24>>2]=c[d+8>>2];c[r+(p*152|0)+28>>2]=c[d+12>>2];B=+g[k+4>>2];C=+g[r+(p*152|0)+24>>2];D=+g[k+8>>2];w=+g[r+(p*152|0)+20>>2];y=+g[r+(p*152|0)+16>>2];u=+g[k>>2];g[r+(p*152|0)>>2]=B*C-D*w;g[r+(p*152|0)+4>>2]=D*y-C*u;g[r+(p*152|0)+8>>2]=w*u-B*y;g[r+(p*152|0)+12>>2]=0.0;z=((B*C-D*w)*+g[x+280>>2]+(D*y-C*u)*+g[x+284>>2]+(w*u-B*y)*+g[x+288>>2])*+g[x+548>>2];A=((B*C-D*w)*+g[x+296>>2]+(D*y-C*u)*+g[x+300>>2]+(w*u-B*y)*+g[x+304>>2])*+g[x+552>>2];g[r+(p*152|0)+64>>2]=((B*C-D*w)*+g[x+264>>2]+ +g[x+268>>2]*(D*y-C*u)+(w*u-B*y)*+g[x+272>>2])*+g[x+544>>2];g[r+(p*152|0)+68>>2]=z;g[r+(p*152|0)+72>>2]=A;g[r+(p*152|0)+76>>2]=0.0;w=B*C-D*w}else{c[r+(p*152|0)+64>>2]=0;c[r+(p*152|0)+68>>2]=0;c[r+(p*152|0)+72>>2]=0;c[r+(p*152|0)+76>>2]=0;c[r+(p*152|0)+0>>2]=0;c[r+(p*152|0)+4>>2]=0;c[r+(p*152|0)+8>>2]=0;c[r+(p*152|0)+12>>2]=0;c[r+(p*152|0)+16>>2]=0;c[r+(p*152|0)+20>>2]=0;c[r+(p*152|0)+24>>2]=0;c[r+(p*152|0)+28>>2]=0;w=0.0}if(b){u=-+g[d>>2];C=-+g[d+4>>2];s=-+g[d+8>>2];g[r+(p*152|0)+48>>2]=u;g[r+(p*152|0)+52>>2]=C;g[r+(p*152|0)+56>>2]=s;g[r+(p*152|0)+60>>2]=0.0;D=+g[l+4>>2];G=+g[l+8>>2];A=+g[l>>2];g[r+(p*152|0)+32>>2]=D*s-G*C;g[r+(p*152|0)+36>>2]=G*u-A*s;g[r+(p*152|0)+40>>2]=A*C-D*u;g[r+(p*152|0)+44>>2]=0.0;B=((D*s-G*C)*+g[b+264>>2]+ +g[b+268>>2]*(G*u-A*s)+(A*C-D*u)*+g[b+272>>2])*+g[b+544>>2];z=((D*s-G*C)*+g[b+280>>2]+(G*u-A*s)*+g[b+284>>2]+(A*C-D*u)*+g[b+288>>2])*+g[b+548>>2];y=((D*s-G*C)*+g[b+296>>2]+(G*u-A*s)*+g[b+300>>2]+(A*C-D*u)*+g[b+304>>2])*+g[b+552>>2];g[r+(p*152|0)+80>>2]=B;g[r+(p*152|0)+84>>2]=z;g[r+(p*152|0)+88>>2]=y;g[r+(p*152|0)+92>>2]=0.0;t=D*s-G*C;s=G*u-A*s;u=A*C-D*u}else{c[r+(p*152|0)+80>>2]=0;c[r+(p*152|0)+84>>2]=0;c[r+(p*152|0)+88>>2]=0;c[r+(p*152|0)+92>>2]=0;c[r+(p*152|0)+32>>2]=0;c[r+(p*152|0)+36>>2]=0;c[r+(p*152|0)+40>>2]=0;c[r+(p*152|0)+44>>2]=0;c[r+(p*152|0)+48>>2]=0;c[r+(p*152|0)+52>>2]=0;c[r+(p*152|0)+56>>2]=0;c[r+(p*152|0)+60>>2]=0;B=0.0;z=0.0;y=0.0;t=0.0;s=0.0;u=0.0}if(x){G=+g[r+(p*152|0)+68>>2];H=+g[k+8>>2];I=+g[r+(p*152|0)+72>>2];C=+g[k+4>>2];A=+g[k>>2];D=+g[r+(p*152|0)+64>>2];A=+g[x+344>>2]+((G*H-I*C)*+g[d>>2]+(I*A-H*D)*+g[d+4>>2]+(C*D-G*A)*+g[d+8>>2])}else A=0.0;if(b){H=-B;I=-z;C=-y;D=+g[l+8>>2];G=+g[l+4>>2];y=+g[l>>2];y=+g[b+344>>2]+((D*I-G*C)*+g[d>>2]+(y*C-D*H)*+g[d+4>>2]+(G*H-y*I)*+g[d+8>>2])}else y=0.0;m=m/(A+y);g[r+(p*152|0)+108>>2]=m;if(x){z=+g[h+(e*244|0)+176>>2]+ +g[h+(e*244|0)+208>>2];y=+g[h+(e*244|0)+180>>2]+ +g[h+(e*244|0)+212>>2];A=+g[h+(e*244|0)+184>>2]+ +g[h+(e*244|0)+216>>2]}else{z=0.0;y=0.0;A=0.0}if(x){B=+g[h+(e*244|0)+192>>2];C=+g[h+(e*244|0)+196>>2];D=+g[h+(e*244|0)+200>>2]}else{B=0.0;C=0.0;D=0.0}w=z*+g[r+(p*152|0)+16>>2]+y*+g[r+(p*152|0)+20>>2]+A*+g[r+(p*152|0)+24>>2]+(B*w+C*+g[r+(p*152|0)+4>>2]+D*+g[r+(p*152|0)+8>>2]);if(b){y=+g[h+(f*244|0)+176>>2]+ +g[h+(f*244|0)+208>>2];A=+g[h+(f*244|0)+180>>2]+ +g[h+(f*244|0)+212>>2];z=+g[h+(f*244|0)+184>>2]+ +g[h+(f*244|0)+216>>2]}else{y=0.0;A=0.0;z=0.0}y=y*+g[r+(p*152|0)+48>>2]+A*+g[r+(p*152|0)+52>>2]+z*+g[r+(p*152|0)+56>>2];if(!b){G=0.0;H=0.0;I=0.0;G=G*t;H=H*s;H=G+H;I=I*u;I=H+I;I=y+I;I=w+I;I=n-I;I=m*I;F=r+(p*152|0)+112|0;g[F>>2]=I;F=r+(p*152|0)+116|0;g[F>>2]=o;I=-v;F=r+(p*152|0)+120|0;g[F>>2]=I;F=r+(p*152|0)+124|0;g[F>>2]=v;i=q;return}G=+g[h+(f*244|0)+192>>2];H=+g[h+(f*244|0)+196>>2];I=+g[h+(f*244|0)+200>>2];G=G*t;H=H*s;H=G+H;I=I*u;I=H+I;I=y+I;I=w+I;I=n-I;I=m*I;F=r+(p*152|0)+112|0;g[F>>2]=I;F=r+(p*152|0)+116|0;g[F>>2]=o;I=-v;F=r+(p*152|0)+120|0;g[F>>2]=I;F=r+(p*152|0)+124|0;g[F>>2]=v;i=q;return}function Br(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0;l=i;k=c[b+88>>2]|0;if((k|0)==(c[b+92>>2]|0)?(m=(k|0)==0?1:k<<1,(k|0)<(m|0)):0){if(!m){u=0;B=k}else{c[5004]=(c[5004]|0)+1;u=fF((m*152|3)+16|0)|0;if(!u)u=0;else{c[(u+19&-16)+ -4>>2]=u;u=u+19&-16}B=c[b+88>>2]|0}if((B|0)>0){C=0;do{mF(u+(C*152|0)|0,(c[b+96>>2]|0)+(C*152|0)|0,152)|0;C=C+1|0}while((C|0)!=(B|0))}B=c[b+96>>2]|0;if(B){if(a[b+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[B+ -4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=u;c[b+92>>2]=m;m=c[b+88>>2]|0}else m=k;c[b+88>>2]=m+1;m=c[b+96>>2]|0;c[m+(k*152|0)+140>>2]=h;c[m+(k*152|0)+16>>2]=0;c[m+(k*152|0)+20>>2]=0;c[m+(k*152|0)+24>>2]=0;c[m+(k*152|0)+28>>2]=0;g[m+(k*152|0)+48>>2]=-0.0;g[m+(k*152|0)+52>>2]=-0.0;g[m+(k*152|0)+56>>2]=-0.0;g[m+(k*152|0)+60>>2]=0.0;b=c[b+16>>2]|0;u=c[b+(e*244|0)+240>>2]|0;h=c[b+(f*244|0)+240>>2]|0;c[m+(k*152|0)+144>>2]=e;c[m+(k*152|0)+148>>2]=f;n=+g[j+88>>2];g[m+(k*152|0)+104>>2]=n;c[m+(k*152|0)+132>>2]=0;g[m+(k*152|0)+100>>2]=0.0;g[m+(k*152|0)+96>>2]=0.0;o=-+g[d>>2];p=-+g[d+4>>2];q=-+g[d+8>>2];g[m+(k*152|0)>>2]=o;g[m+(k*152|0)+4>>2]=p;g[m+(k*152|0)+8>>2]=q;g[m+(k*152|0)+12>>2]=0.0;if(u){s=(+g[u+264>>2]*o+ +g[u+268>>2]*p+ +g[u+272>>2]*q)*+g[u+544>>2];r=(+g[u+280>>2]*o+ +g[u+284>>2]*p+ +g[u+288>>2]*q)*+g[u+548>>2];t=(+g[u+296>>2]*o+ +g[u+300>>2]*p+ +g[u+304>>2]*q)*+g[u+552>>2]}else{s=0.0;r=0.0;t=0.0}g[m+(k*152|0)+64>>2]=s;g[m+(k*152|0)+68>>2]=r;g[m+(k*152|0)+72>>2]=t;g[m+(k*152|0)+76>>2]=0.0;t=+g[d>>2];s=+g[d+4>>2];r=+g[d+8>>2];A=+g[d+12>>2];g[m+(k*152|0)+32>>2]=t;g[m+(k*152|0)+36>>2]=s;g[m+(k*152|0)+40>>2]=r;g[m+(k*152|0)+44>>2]=A;if(h){w=(t*+g[h+264>>2]+s*+g[h+268>>2]+r*+g[h+272>>2])*+g[h+544>>2];v=(t*+g[h+280>>2]+s*+g[h+284>>2]+r*+g[h+288>>2])*+g[h+548>>2];x=(t*+g[h+296>>2]+s*+g[h+300>>2]+r*+g[h+304>>2])*+g[h+552>>2]}else{w=0.0;v=0.0;x=0.0}g[m+(k*152|0)+80>>2]=w;g[m+(k*152|0)+84>>2]=v;g[m+(k*152|0)+88>>2]=x;g[m+(k*152|0)+92>>2]=0.0;if(u){A=+g[u+264>>2]*o+ +g[u+268>>2]*p+ +g[u+272>>2]*q;z=+g[u+280>>2]*o+ +g[u+284>>2]*p+ +g[u+288>>2]*q;w=+g[u+296>>2]*o+ +g[u+300>>2]*p+ +g[u+304>>2]*q}else{A=0.0;z=0.0;w=0.0}if(h){v=+g[h+264>>2]*t+ +g[h+268>>2]*s+ +g[h+272>>2]*r;y=t*+g[h+280>>2]+s*+g[h+284>>2]+r*+g[h+288>>2];x=t*+g[h+296>>2]+s*+g[h+300>>2]+r*+g[h+304>>2]}else{v=0.0;y=0.0;x=0.0}v=1.0/(A*o+z*p+w*q+0.0+(v*t+y*s+x*r));g[m+(k*152|0)+108>>2]=v;if(u){y=+g[b+(e*244|0)+192>>2];x=+g[b+(e*244|0)+196>>2];w=+g[b+(e*244|0)+200>>2];z=(+g[b+(e*244|0)+176>>2]+ +g[b+(e*244|0)+208>>2])*0.0+(+g[b+(e*244|0)+180>>2]+ +g[b+(e*244|0)+212>>2])*0.0+(+g[b+(e*244|0)+184>>2]+ +g[b+(e*244|0)+216>>2])*0.0}else{y=0.0;x=0.0;w=0.0;z=0.0}o=z+(y*o+x*p+w*q);if(!h){x=0.0;y=0.0;A=0.0;z=-0.0;x=x*t;y=y*s;y=x+y;A=A*r;A=y+A;A=z+A;A=o+A;A=0.0-A;A=v*A;C=m+(k*152|0)+112|0;g[C>>2]=A;C=m+(k*152|0)+116|0;g[C>>2]=0.0;A=-n;C=m+(k*152|0)+120|0;g[C>>2]=A;C=m+(k*152|0)+124|0;g[C>>2]=n;i=l;return}x=+g[b+(f*244|0)+192>>2];y=+g[b+(f*244|0)+196>>2];A=+g[b+(f*244|0)+200>>2];z=(+g[b+(f*244|0)+176>>2]+ +g[b+(f*244|0)+208>>2])*-0.0+(+g[b+(f*244|0)+180>>2]+ +g[b+(f*244|0)+212>>2])*-0.0+(+g[b+(f*244|0)+184>>2]+ +g[b+(f*244|0)+216>>2])*-0.0;x=x*t;y=y*s;y=x+y;A=A*r;A=y+A;A=z+A;A=o+A;A=0.0-A;A=v*A;C=m+(k*152|0)+112|0;g[C>>2]=A;C=m+(k*152|0)+116|0;g[C>>2]=0.0;A=-n;C=m+(k*152|0)+120|0;g[C>>2]=A;C=m+(k*152|0)+124|0;g[C>>2]=n;i=l;return}function Cr(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+496|0;f=c[b+212>>2]|0;if((f|0)>-1){b=f;i=e;return b|0}do if(c[b+236>>2]&2){if(!(+g[b+344>>2]!=0.0)?(c[b+204>>2]&2|0)==0:0)break;f=c[a+8>>2]|0;jF(e+244|0,0,244)|0;yr(Dr(a+4|0,e+244|0)|0,b,d);c[b+212>>2]=f;b=f;i=e;return b|0}while(0);f=c[a+188>>2]|0;if((f|0)>=0){b=f;i=e;return b|0}c[a+188>>2]=c[a+8>>2];jF(e|0,0,244)|0;yr(Dr(a+4|0,e)|0,0,d);b=c[a+188>>2]|0;i=e;return b|0}function Dr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;f=c[b+4>>2]|0;if((f|0)==(c[b+8>>2]|0)?(g=(f|0)==0?1:f<<1,(f|0)<(g|0)):0){if(!g){h=0;j=f}else{c[5004]=(c[5004]|0)+1;h=fF((g*244|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}j=c[b+4>>2]|0}if((j|0)>0){k=0;do{m=h+(k*244|0)|0;l=c[b+12>>2]|0;n=l+(k*244|0)|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=h+(k*244|0)+16|0;n=l+(k*244|0)+16|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=h+(k*244|0)+32|0;n=l+(k*244|0)+32|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=h+(k*244|0)+48|0;n=l+(k*244|0)+48|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];mF(h+(k*244|0)+64|0,l+(k*244|0)+64|0,180)|0;k=k+1|0}while((k|0)!=(j|0))}j=c[b+12>>2]|0;if(j){if(a[b+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=h;c[b+8>>2]=g;g=c[b+4>>2]|0}else g=f;c[b+4>>2]=g+1;n=c[b+12>>2]|0;c[n+(f*244|0)+0>>2]=c[d+0>>2];c[n+(f*244|0)+4>>2]=c[d+4>>2];c[n+(f*244|0)+8>>2]=c[d+8>>2];c[n+(f*244|0)+12>>2]=c[d+12>>2];c[n+(f*244|0)+16>>2]=c[d+16>>2];c[n+(f*244|0)+20>>2]=c[d+20>>2];c[n+(f*244|0)+24>>2]=c[d+24>>2];c[n+(f*244|0)+28>>2]=c[d+28>>2];c[n+(f*244|0)+32>>2]=c[d+32>>2];c[n+(f*244|0)+36>>2]=c[d+36>>2];c[n+(f*244|0)+40>>2]=c[d+40>>2];c[n+(f*244|0)+44>>2]=c[d+44>>2];c[n+(f*244|0)+48>>2]=c[d+48>>2];c[n+(f*244|0)+52>>2]=c[d+52>>2];c[n+(f*244|0)+56>>2]=c[d+56>>2];c[n+(f*244|0)+60>>2]=c[d+60>>2];mF(n+(f*244|0)+64|0,d+64|0,180)|0;i=e;return(c[b+12>>2]|0)+(f*244|0)|0}function Er(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0.0,K=0,L=0.0,M=0.0,N=0.0,O=0,R=0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0;r=i;i=i+80|0;if((e|0)<=0){i=r;return}k=0;do{l=c[d+(k<<2)>>2]|0;h=c[l+740>>2]|0;q=c[l+744>>2]|0;m=Cr(b,h,+g[f+12>>2])|0;n=Cr(b,q,+g[f+12>>2])|0;o=c[b+16>>2]|0;do if(o+(m*244|0)|0){if((+g[o+(m*244|0)+128>>2]==0.0?+g[o+(m*244|0)+132>>2]==0.0:0)?+g[o+(m*244|0)+136>>2]==0.0:0){if(!(o+(n*244|0)|0))break;if((+g[o+(n*244|0)+128>>2]==0.0?+g[o+(n*244|0)+132>>2]==0.0:0)?+g[o+(n*244|0)+136>>2]==0.0:0)break}t=c[l+748>>2]|0;if((t|0)>0){s=0;F=1;do{u=l+(s*184|0)+4|0;K=l+(s*184|0)+84|0;if(+g[K>>2]<=+g[l+756>>2]){t=c[b+28>>2]|0;if((t|0)==(c[b+32>>2]|0)?(p=(t|0)==0?1:t<<1,(t|0)<(p|0)):0){if(!p){v=0;y=t}else{c[5004]=(c[5004]|0)+1;v=fF((p*152|3)+16|0)|0;if(!v)v=0;else{c[(v+19&-16)+ -4>>2]=v;v=v+19&-16}y=c[b+28>>2]|0}if((y|0)>0){x=0;do{mF(v+(x*152|0)|0,(c[b+36>>2]|0)+(x*152|0)|0,152)|0;x=x+1|0}while((x|0)!=(y|0))}x=c[b+36>>2]|0;if(x){if(a[b+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[x+ -4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=v;c[b+32>>2]=p;v=c[b+28>>2]|0}else v=t;c[b+28>>2]=v+1;v=c[b+36>>2]|0;H=(c[h+236>>2]&2|0)==0?0:h;G=(c[q+236>>2]&2|0)==0?0:q;c[v+(t*152|0)+144>>2]=m;c[v+(t*152|0)+148>>2]=n;c[v+(t*152|0)+132>>2]=u;S=+g[l+(s*184|0)+52>>2]- +g[h+52>>2];T=+g[l+(s*184|0)+56>>2]- +g[h+56>>2];U=+g[l+(s*184|0)+60>>2]- +g[h+60>>2];g[r+64>>2]=S;g[r+68>>2]=T;g[r+72>>2]=U;g[r+76>>2]=0.0;L=+g[l+(s*184|0)+36>>2]- +g[q+52>>2];M=+g[l+(s*184|0)+40>>2]- +g[q+56>>2];N=+g[l+(s*184|0)+44>>2]- +g[q+60>>2];g[r+48>>2]=L;g[r+52>>2]=M;g[r+56>>2]=N;g[r+60>>2]=0.0;if(!(c[o+(m*244|0)+240>>2]|0)){w=0.0;D=0.0;C=0.0}else{aa=+g[o+(m*244|0)+192>>2]+ +g[o+(m*244|0)+224>>2];C=+g[o+(m*244|0)+196>>2]+ +g[o+(m*244|0)+228>>2];D=+g[o+(m*244|0)+200>>2]+ +g[o+(m*244|0)+232>>2];w=+g[o+(m*244|0)+176>>2]+ +g[o+(m*244|0)+208>>2]+(C*U-D*T);D=+g[o+(m*244|0)+180>>2]+ +g[o+(m*244|0)+212>>2]+(D*S-aa*U);C=+g[o+(m*244|0)+184>>2]+ +g[o+(m*244|0)+216>>2]+(aa*T-C*S)}if(!(c[o+(n*244|0)+240>>2]|0)){E=0.0;A=0.0;B=0.0}else{aa=+g[o+(n*244|0)+192>>2]+ +g[o+(n*244|0)+224>>2];B=+g[o+(n*244|0)+196>>2]+ +g[o+(n*244|0)+228>>2];A=+g[o+(n*244|0)+200>>2]+ +g[o+(n*244|0)+232>>2];E=+g[o+(n*244|0)+176>>2]+ +g[o+(n*244|0)+208>>2]+(B*N-A*M);A=+g[o+(n*244|0)+180>>2]+ +g[o+(n*244|0)+212>>2]+(A*L-aa*N);B=+g[o+(n*244|0)+184>>2]+ +g[o+(n*244|0)+216>>2]+(aa*M-B*L)}w=w-E;A=D-A;D=C-B;y=l+(s*184|0)+68|0;C=+g[y>>2];z=l+(s*184|0)+72|0;B=+g[z>>2];x=l+(s*184|0)+76|0;E=+g[x>>2];I=c[b+16>>2]|0;R=c[I+(m*244|0)+240>>2]|0;O=c[I+(n*244|0)+240>>2]|0;if(R){_=((T*E-U*B)*+g[R+264>>2]+(U*C-E*S)*+g[R+268>>2]+(B*S-T*C)*+g[R+272>>2])*+g[R+544>>2];aa=((T*E-U*B)*+g[R+280>>2]+(U*C-E*S)*+g[R+284>>2]+(B*S-T*C)*+g[R+288>>2])*+g[R+548>>2];$=((T*E-U*B)*+g[R+296>>2]+(U*C-E*S)*+g[R+300>>2]+(B*S-T*C)*+g[R+304>>2])*+g[R+552>>2]}else{_=0.0;aa=0.0;$=0.0}g[v+(t*152|0)+64>>2]=_;g[v+(t*152|0)+68>>2]=aa;g[v+(t*152|0)+72>>2]=$;g[v+(t*152|0)+76>>2]=0.0;W=+g[x>>2];V=+g[z>>2];J=+g[y>>2];if(O){X=(+g[O+264>>2]*-(M*W-N*V)+ +g[O+268>>2]*-(N*J-W*L)+ +g[O+272>>2]*-(V*L-M*J))*+g[O+544>>2];Y=(+g[O+280>>2]*-(M*W-N*V)+ +g[O+284>>2]*-(N*J-W*L)+ +g[O+288>>2]*-(V*L-M*J))*+g[O+548>>2];Z=(+g[O+296>>2]*-(M*W-N*V)+ +g[O+300>>2]*-(N*J-W*L)+ +g[O+304>>2]*-(V*L-M*J))*+g[O+552>>2]}else{X=0.0;Y=0.0;Z=0.0}g[v+(t*152|0)+80>>2]=X;g[v+(t*152|0)+84>>2]=Y;g[v+(t*152|0)+88>>2]=Z;g[v+(t*152|0)+92>>2]=0.0;if(R)_=+g[R+344>>2]+((aa*U-$*T)*+g[y>>2]+($*S-U*_)*+g[z>>2]+(T*_-aa*S)*+g[x>>2]);else _=0.0;if(O){aa=-X;X=-Y;$=-Z;X=+g[O+344>>2]+((N*X-M*$)*+g[y>>2]+(L*$-N*aa)*+g[z>>2]+(M*aa-L*X)*+g[x>>2])}else X=0.0;g[v+(t*152|0)+108>>2]=1.0/(_+X);if(R){c[v+(t*152|0)+16>>2]=c[y+0>>2];c[v+(t*152|0)+20>>2]=c[y+4>>2];c[v+(t*152|0)+24>>2]=c[y+8>>2];c[v+(t*152|0)+28>>2]=c[y+12>>2];g[v+(t*152|0)>>2]=T*E-U*B;g[v+(t*152|0)+4>>2]=U*C-E*S;g[v+(t*152|0)+8>>2]=B*S-T*C;g[v+(t*152|0)+12>>2]=0.0}else{c[v+(t*152|0)+0>>2]=0;c[v+(t*152|0)+4>>2]=0;c[v+(t*152|0)+8>>2]=0;c[v+(t*152|0)+12>>2]=0;c[v+(t*152|0)+16>>2]=0;c[v+(t*152|0)+20>>2]=0;c[v+(t*152|0)+24>>2]=0;c[v+(t*152|0)+28>>2]=0}if(O){$=-+g[z>>2];aa=-+g[x>>2];g[v+(t*152|0)+48>>2]=-+g[y>>2];g[v+(t*152|0)+52>>2]=$;g[v+(t*152|0)+56>>2]=aa;g[v+(t*152|0)+60>>2]=0.0;g[v+(t*152|0)+32>>2]=-(M*W-N*V);g[v+(t*152|0)+36>>2]=-(N*J-W*L);g[v+(t*152|0)+40>>2]=-(V*L-M*J);g[v+(t*152|0)+44>>2]=0.0}else{c[v+(t*152|0)+32>>2]=0;c[v+(t*152|0)+36>>2]=0;c[v+(t*152|0)+40>>2]=0;c[v+(t*152|0)+44>>2]=0;c[v+(t*152|0)+48>>2]=0;c[v+(t*152|0)+52>>2]=0;c[v+(t*152|0)+56>>2]=0;c[v+(t*152|0)+60>>2]=0}J=+g[K>>2]+ +g[f+56>>2];if(R){aa=+g[R+332>>2];_=+g[R+336>>2];$=+g[R+328>>2];V=aa*U-_*T+ +g[R+312>>2];U=+g[R+316>>2]+(_*S-U*$);T=T*$-aa*S+ +g[R+320>>2]}else{V=0.0;U=0.0;T=0.0}if(O){aa=+g[O+332>>2];_=+g[O+336>>2];$=+g[O+328>>2];S=aa*N-_*M+ +g[O+312>>2];N=+g[O+316>>2]+(_*L-N*$);L=M*$-aa*L+ +g[O+320>>2]}else{S=0.0;N=0.0;L=0.0}L=+g[y>>2]*(V-S)+(U-N)*+g[z>>2]+(T-L)*+g[x>>2];g[v+(t*152|0)+104>>2]=+g[l+(s*184|0)+88>>2];L=L*+g[l+(s*184|0)+96>>2];L=!(L>=-0.0)?-L:0.0;do if(!(c[f+64>>2]&4))g[v+(t*152|0)+100>>2]=0.0;else{M=+g[l+(s*184|0)+124>>2]*+g[f+60>>2];g[v+(t*152|0)+100>>2]=M;do if(R){if(!(c[I+(m*244|0)+240>>2]|0))break;aa=M*+g[I+(m*244|0)+132>>2]*+g[v+(t*152|0)+20>>2]*+g[R+352>>2]*+g[I+(m*244|0)+116>>2];$=M*+g[I+(m*244|0)+136>>2]*+g[v+(t*152|0)+24>>2]*+g[R+356>>2]*+g[I+(m*244|0)+120>>2];g[I+(m*244|0)+64>>2]=+g[I+(m*244|0)+112>>2]*M*+g[I+(m*244|0)+128>>2]*+g[v+(t*152|0)+16>>2]*+g[R+348>>2]+ +g[I+(m*244|0)+64>>2];g[I+(m*244|0)+68>>2]=aa+ +g[I+(m*244|0)+68>>2];g[I+(m*244|0)+72>>2]=$+ +g[I+(m*244|0)+72>>2];$=M*+g[I+(m*244|0)+100>>2]*+g[v+(t*152|0)+68>>2];aa=M*+g[I+(m*244|0)+104>>2]*+g[v+(t*152|0)+72>>2];g[I+(m*244|0)+80>>2]=M*+g[I+(m*244|0)+96>>2]*+g[v+(t*152|0)+64>>2]+ +g[I+(m*244|0)+80>>2];g[I+(m*244|0)+84>>2]=$+ +g[I+(m*244|0)+84>>2];g[I+(m*244|0)+88>>2]=aa+ +g[I+(m*244|0)+88>>2]}while(0);if(!O)break;M=+g[v+(t*152|0)+100>>2];if(!(c[I+(n*244|0)+240>>2]|0))break;aa=+g[v+(t*152|0)+88>>2];$=+g[v+(t*152|0)+84>>2];_=+g[v+(t*152|0)+80>>2];Y=M*+g[I+(n*244|0)+132>>2]*+g[v+(t*152|0)+52>>2]*+g[O+352>>2]*+g[I+(n*244|0)+116>>2];Z=M*+g[I+(n*244|0)+136>>2]*+g[v+(t*152|0)+56>>2]*+g[O+356>>2]*+g[I+(n*244|0)+120>>2];g[I+(n*244|0)+64>>2]=+g[I+(n*244|0)+112>>2]*M*+g[I+(n*244|0)+128>>2]*+g[v+(t*152|0)+48>>2]*+g[O+348>>2]+ +g[I+(n*244|0)+64>>2];g[I+(n*244|0)+68>>2]=Y+ +g[I+(n*244|0)+68>>2];g[I+(n*244|0)+72>>2]=Z+ +g[I+(n*244|0)+72>>2];$=$*+g[I+(n*244|0)+100>>2]*-M;aa=aa*+g[I+(n*244|0)+104>>2]*-M;g[I+(n*244|0)+80>>2]=+g[I+(n*244|0)+80>>2]-_*+g[I+(n*244|0)+96>>2]*-M;g[I+(n*244|0)+84>>2]=+g[I+(n*244|0)+84>>2]-$;g[I+(n*244|0)+88>>2]=+g[I+(n*244|0)+88>>2]-aa}while(0);g[v+(t*152|0)+96>>2]=0.0;if(!(c[I+(m*244|0)+240>>2]|0)){$=0.0;_=0.0;Z=0.0;M=0.0;X=0.0;W=0.0}else{$=+g[I+(m*244|0)+208>>2];_=+g[I+(m*244|0)+212>>2];Z=+g[I+(m*244|0)+216>>2];M=+g[I+(m*244|0)+224>>2];X=+g[I+(m*244|0)+228>>2];W=+g[I+(m*244|0)+232>>2]}if(!(c[I+(n*244|0)+240>>2]|0)){S=0.0;Y=0.0;N=0.0;T=0.0;U=0.0;V=0.0}else{S=+g[I+(n*244|0)+208>>2];Y=+g[I+(n*244|0)+212>>2];N=+g[I+(n*244|0)+216>>2];T=+g[I+(n*244|0)+224>>2];U=+g[I+(n*244|0)+228>>2];V=+g[I+(n*244|0)+232>>2]}L=L-(($+ +g[I+(m*244|0)+176>>2])*+g[v+(t*152|0)+16>>2]+(_+ +g[I+(m*244|0)+180>>2])*+g[v+(t*152|0)+20>>2]+(Z+ +g[I+(m*244|0)+184>>2])*+g[v+(t*152|0)+24>>2]+((M+ +g[I+(m*244|0)+192>>2])*+g[v+(t*152|0)>>2]+(X+ +g[I+(m*244|0)+196>>2])*+g[v+(t*152|0)+4>>2]+(W+ +g[I+(m*244|0)+200>>2])*+g[v+(t*152|0)+8>>2])+((S+ +g[I+(n*244|0)+176>>2])*+g[v+(t*152|0)+48>>2]+(Y+ +g[I+(n*244|0)+180>>2])*+g[v+(t*152|0)+52>>2]+(N+ +g[I+(n*244|0)+184>>2])*+g[v+(t*152|0)+56>>2]+((T+ +g[I+(n*244|0)+192>>2])*+g[v+(t*152|0)+32>>2]+(U+ +g[I+(n*244|0)+196>>2])*+g[v+(t*152|0)+36>>2]+(V+ +g[I+(n*244|0)+200>>2])*+g[v+(t*152|0)+40>>2])));I=(c[f+44>>2]|0)==0;if(!I?!(J>+g[f+48>>2]):0)K=f+36|0;else K=f+32|0;if(J>0.0){M=0.0;L=L-J/+g[f+12>>2]}else M=-(J*+g[K>>2])/+g[f+12>>2];aa=+g[v+(t*152|0)+108>>2];M=M*aa;L=L*aa;do if(I)j=69;else{if(J>+g[f+48>>2]){j=69;break}g[v+(t*152|0)+112>>2]=L;g[v+(t*152|0)+128>>2]=M}while(0);if((j|0)==69){j=0;g[v+(t*152|0)+112>>2]=M+L;g[v+(t*152|0)+128>>2]=0.0}g[v+(t*152|0)+116>>2]=0.0;g[v+(t*152|0)+120>>2]=0.0;g[v+(t*152|0)+124>>2]=1.0e10;c[v+(t*152|0)+140>>2]=c[b+68>>2];if(!H){J=0.0;M=0.0;L=0.0}else{J=+g[H+328>>2];M=+g[H+332>>2];L=+g[H+336>>2]}if(!G){T=0.0;S=0.0;N=0.0}else{T=+g[G+328>>2];S=+g[G+332>>2];N=+g[G+336>>2]}J=T-J;M=S-M;L=N-L;g[r+32>>2]=J;g[r+36>>2]=M;g[r+40>>2]=L;g[r+44>>2]=0.0;do if((F|0)>0?+g[l+(s*184|0)+92>>2]>0.0:0){F=F+ -1|0;S=+Q(+(J*J+M*M+L*L));if(S>+g[f+80>>2]){N=J*(1.0/S);g[r+32>>2]=N;J=M*(1.0/S);g[r+36>>2]=J;L=L*(1.0/S);g[r+40>>2]=L;do if(h){if(!(c[h+180>>2]&2))break;S=+g[h+4>>2];V=+g[h+20>>2];Y=+g[h+36>>2];T=+g[h+8>>2];W=+g[h+24>>2];_=+g[h+40>>2];U=+g[h+12>>2];X=+g[h+28>>2];aa=+g[h+44>>2];Z=(S*N+V*J+L*Y)*+g[h+164>>2];$=(N*T+J*W+L*_)*+g[h+168>>2];L=(N*U+J*X+L*aa)*+g[h+172>>2];g[r+32>>2]=S*Z+T*$+U*L;g[r+36>>2]=V*Z+W*$+X*L;g[r+40>>2]=Y*Z+_*$+aa*L;g[r+44>>2]=0.0;N=S*Z+T*$+U*L;J=V*Z+W*$+X*L;L=Y*Z+_*$+aa*L}while(0);do if(q){if(!(c[q+180>>2]&2))break;S=+g[q+4>>2];V=+g[q+20>>2];Y=+g[q+36>>2];T=+g[q+8>>2];W=+g[q+24>>2];_=+g[q+40>>2];U=+g[q+12>>2];X=+g[q+28>>2];aa=+g[q+44>>2];Z=(S*N+V*J+Y*L)*+g[q+164>>2];$=(N*T+J*W+L*_)*+g[q+168>>2];L=(N*U+J*X+L*aa)*+g[q+172>>2];g[r+32>>2]=S*Z+T*$+U*L;g[r+36>>2]=V*Z+W*$+X*L;g[r+40>>2]=Y*Z+_*$+aa*L;g[r+44>>2]=0.0;N=S*Z+T*$+U*L;J=V*Z+W*$+X*L;L=Y*Z+_*$+aa*L}while(0);if(!(+Q(+(N*N+J*J+L*L))>.001))break;Br(b,r+32|0,m,n,t,u);break}Br(b,y,m,n,t,u);L=+g[x>>2];if(+P(+L)>.7071067690849304){M=+g[z>>2];aa=1.0/+Q(+(L*L+M*M));g[r+16>>2]=0.0;g[r+20>>2]=-(aa*L);g[r+24>>2]=aa*M;g[r>>2]=(L*L+M*M)*aa;$=+g[y>>2];g[r+4>>2]=-($*aa*M);J=0.0;S=-(aa*L);T=aa*M;N=(L*L+M*M)*aa;M=-($*aa*M);L=$*-(aa*L)}else{_=+g[y>>2];$=+g[z>>2];aa=1.0/+Q(+(_*_+$*$));g[r+16>>2]=-($*aa);g[r+20>>2]=aa*_;g[r+24>>2]=0.0;g[r>>2]=-(L*aa*_);g[r+4>>2]=L*-($*aa);J=-($*aa);S=aa*_;T=0.0;N=-(L*aa*_);M=L*-($*aa);L=(_*_+$*$)*aa}g[r+8>>2]=L;do if(h){if(!(c[h+180>>2]&2))break;ca=+g[h+4>>2];V=+g[h+20>>2];Y=+g[h+36>>2];ba=+g[h+8>>2];W=+g[h+24>>2];_=+g[h+40>>2];U=+g[h+12>>2];X=+g[h+28>>2];aa=+g[h+44>>2];Z=(ca*J+V*S+Y*T)*+g[h+164>>2];$=(J*ba+S*W+T*_)*+g[h+168>>2];T=(J*U+S*X+T*aa)*+g[h+172>>2];g[r+16>>2]=ca*Z+ba*$+U*T;g[r+20>>2]=V*Z+W*$+X*T;g[r+24>>2]=Y*Z+_*$+aa*T;g[r+28>>2]=0.0;J=ca*Z+ba*$+U*T;S=V*Z+W*$+X*T;T=Y*Z+_*$+aa*T}while(0);do if(q){if(!(c[q+180>>2]&2))break;U=+g[q+4>>2];X=+g[q+20>>2];_=+g[q+36>>2];V=+g[q+8>>2];Y=+g[q+24>>2];aa=+g[q+40>>2];W=+g[q+12>>2];Z=+g[q+28>>2];ca=+g[q+44>>2];$=(U*J+X*S+_*T)*+g[q+164>>2];ba=(J*V+S*Y+T*aa)*+g[q+168>>2];T=(J*W+S*Z+T*ca)*+g[q+172>>2];g[r+16>>2]=U*$+V*ba+W*T;g[r+20>>2]=X*$+Y*ba+Z*T;g[r+24>>2]=_*$+aa*ba+ca*T;g[r+28>>2]=0.0;J=U*$+V*ba+W*T;S=X*$+Y*ba+Z*T;T=_*$+aa*ba+ca*T}while(0);do if(h){if(!(c[h+180>>2]&2))break;U=+g[h+4>>2];X=+g[h+20>>2];_=+g[h+36>>2];V=+g[h+8>>2];Y=+g[h+24>>2];aa=+g[h+40>>2];W=+g[h+12>>2];Z=+g[h+28>>2];ca=+g[h+44>>2];$=(U*N+X*M+_*L)*+g[h+164>>2];ba=(N*V+M*Y+L*aa)*+g[h+168>>2];L=(N*W+M*Z+L*ca)*+g[h+172>>2];g[r>>2]=U*$+V*ba+W*L;g[r+4>>2]=X*$+Y*ba+Z*L;g[r+8>>2]=_*$+aa*ba+ca*L;g[r+12>>2]=0.0;N=U*$+V*ba+W*L;M=X*$+Y*ba+Z*L;L=_*$+aa*ba+ca*L}while(0);do if(q){if(!(c[q+180>>2]&2))break;U=+g[q+4>>2];X=+g[q+20>>2];_=+g[q+36>>2];V=+g[q+8>>2];Y=+g[q+24>>2];aa=+g[q+40>>2];W=+g[q+12>>2];Z=+g[q+28>>2];ca=+g[q+44>>2];$=(U*N+X*M+_*L)*+g[q+164>>2];ba=(N*V+M*Y+L*aa)*+g[q+168>>2];L=(N*W+M*Z+L*ca)*+g[q+172>>2];g[r>>2]=U*$+V*ba+W*L;g[r+4>>2]=X*$+Y*ba+Z*L;g[r+8>>2]=_*$+aa*ba+ca*L;g[r+12>>2]=0.0;N=U*$+V*ba+W*L;M=X*$+Y*ba+Z*L;L=_*$+aa*ba+ca*L}while(0);if(+Q(+(J*J+S*S+T*T))>.001)Br(b,r+16|0,m,n,t,u);if(!(+Q(+(N*N+M*M+L*L))>.001))break;Br(b,r,m,n,t,u)}while(0);do if(!(c[f+64>>2]&32))j=106;else{if(!(a[l+(s*184|0)+120>>0]|0)){j=106;break}Ar(b,l+(s*184|0)+156|0,m,n,t,u,r+64|0,r+48|0,1.0,+g[l+(s*184|0)+136>>2],+g[l+(s*184|0)+144>>2]);if(!(c[f+64>>2]&16))break;Ar(b,l+(s*184|0)+172|0,m,n,t,u,r+64|0,r+48|0,1.0,+g[l+(s*184|0)+140>>2],+g[l+(s*184|0)+148>>2])}while(0);do if((j|0)==106){j=0;G=l+(s*184|0)+156|0;J=+g[y>>2];L=+g[z>>2];M=+g[x>>2];S=w-(C*w+A*B+D*E)*J;N=A-(C*w+A*B+D*E)*L;w=D-(C*w+A*B+D*E)*M;g[l+(s*184|0)+156>>2]=S;I=l+(s*184|0)+160|0;g[I>>2]=N;H=l+(s*184|0)+164|0;g[H>>2]=w;g[l+(s*184|0)+168>>2]=0.0;if((c[f+64>>2]&64|0)==0?S*S+N*N+w*w>1.1920928955078125e-7:0){ca=1.0/+Q(+(S*S+N*N+w*w));g[G>>2]=S*ca;g[I>>2]=ca*N;g[H>>2]=ca*w;zr(h,G);zr(q,G);Ar(b,G,m,n,t,u,r+64|0,r+48|0,1.0,0.0,0.0);if(!(c[f+64>>2]&16))break;R=l+(s*184|0)+172|0;aa=+g[I>>2];Z=+g[x>>2];Y=+g[H>>2];_=+g[z>>2];ba=+g[y>>2];$=+g[G>>2];g[l+(s*184|0)+172>>2]=aa*Z-Y*_;g[l+(s*184|0)+184>>2]=0.0;ca=1.0/+Q(+((aa*Z-Y*_)*(aa*Z-Y*_)+(Y*ba-Z*$)*(Y*ba-Z*$)+(_*$-aa*ba)*(_*$-aa*ba)));g[R>>2]=(aa*Z-Y*_)*ca;g[l+(s*184|0)+176>>2]=(Y*ba-Z*$)*ca;g[l+(s*184|0)+180>>2]=(_*$-aa*ba)*ca;zr(h,R);zr(q,R);Ar(b,R,m,n,t,u,r+64|0,r+48|0,1.0,0.0,0.0);break}x=l+(s*184|0)+172|0;if(+P(+M)>.7071067690849304){ca=1.0/+Q(+(M*M+L*L));g[G>>2]=0.0;g[I>>2]=-(ca*M);g[H>>2]=ca*L;g[x>>2]=(M*M+L*L)*ca;g[l+(s*184|0)+176>>2]=-(J*ca*L);g[l+(s*184|0)+180>>2]=J*-(ca*M)}else{ca=1.0/+Q(+(J*J+L*L));g[G>>2]=-(L*ca);g[I>>2]=ca*J;g[H>>2]=0.0;g[x>>2]=-(M*ca*J);g[l+(s*184|0)+176>>2]=M*-(L*ca);g[l+(s*184|0)+180>>2]=(J*J+L*L)*ca}zr(h,G);zr(q,G);Ar(b,G,m,n,t,u,r+64|0,r+48|0,1.0,0.0,0.0);y=c[f+64>>2]|0;if(y&16){zr(h,x);zr(q,x);Ar(b,x,m,n,t,u,r+64|0,r+48|0,1.0,0.0,0.0);y=c[f+64>>2]|0}if((y&80|0)!=80)break;a[l+(s*184|0)+120>>0]=1}while(0);u=c[b+16>>2]|0;y=c[u+(m*244|0)+240>>2]|0;x=c[u+(n*244|0)+240>>2]|0;v=c[v+(t*152|0)+140>>2]|0;t=c[b+76>>2]|0;z=c[f+64>>2]|0;do if(!(z&4))g[t+(v*152|0)+100>>2]=0.0;else{w=+g[l+(s*184|0)+128>>2]*+g[f+60>>2];g[t+(v*152|0)+100>>2]=w;if(y){aa=+g[y+344>>2];ca=w*aa*+g[t+(v*152|0)+20>>2]*+g[y+352>>2]*+g[u+(m*244|0)+116>>2];ba=w*aa*+g[t+(v*152|0)+24>>2]*+g[y+356>>2]*+g[u+(m*244|0)+120>>2];g[u+(m*244|0)+64>>2]=+g[u+(m*244|0)+112>>2]*w*aa*+g[t+(v*152|0)+16>>2]*+g[y+348>>2]+ +g[u+(m*244|0)+64>>2];g[u+(m*244|0)+68>>2]=ca+ +g[u+(m*244|0)+68>>2];g[u+(m*244|0)+72>>2]=ba+ +g[u+(m*244|0)+72>>2];ba=w*+g[u+(m*244|0)+100>>2]*+g[t+(v*152|0)+68>>2];ca=w*+g[u+(m*244|0)+104>>2]*+g[t+(v*152|0)+72>>2];g[u+(m*244|0)+80>>2]=w*+g[u+(m*244|0)+96>>2]*+g[t+(v*152|0)+64>>2]+ +g[u+(m*244|0)+80>>2];g[u+(m*244|0)+84>>2]=ba+ +g[u+(m*244|0)+84>>2];g[u+(m*244|0)+88>>2]=ca+ +g[u+(m*244|0)+88>>2]}if(!x)break;A=+g[x+344>>2];w=+g[t+(v*152|0)+100>>2];if(!(c[u+(n*244|0)+240>>2]|0))break;ca=+g[t+(v*152|0)+88>>2];ba=+g[t+(v*152|0)+84>>2];aa=+g[t+(v*152|0)+80>>2];_=w*A*+g[t+(v*152|0)+52>>2]*+g[x+352>>2]*+g[u+(n*244|0)+116>>2];$=w*A*+g[t+(v*152|0)+56>>2]*+g[x+356>>2]*+g[u+(n*244|0)+120>>2];g[u+(n*244|0)+64>>2]=+g[u+(n*244|0)+112>>2]*w*A*+g[t+(v*152|0)+48>>2]*+g[x+348>>2]+ +g[u+(n*244|0)+64>>2];g[u+(n*244|0)+68>>2]=_+ +g[u+(n*244|0)+68>>2];g[u+(n*244|0)+72>>2]=$+ +g[u+(n*244|0)+72>>2];ba=ba*+g[u+(n*244|0)+100>>2]*-w;ca=ca*+g[u+(n*244|0)+104>>2]*-w;g[u+(n*244|0)+80>>2]=+g[u+(n*244|0)+80>>2]-aa*+g[u+(n*244|0)+96>>2]*-w;g[u+(n*244|0)+84>>2]=+g[u+(n*244|0)+84>>2]-ba;g[u+(n*244|0)+88>>2]=+g[u+(n*244|0)+88>>2]-ca}while(0);do if(z&16){if(!(z&4)){g[t+((v+1|0)*152|0)+100>>2]=0.0;break}w=+g[l+(s*184|0)+132>>2]*+g[f+60>>2];g[t+((v+1|0)*152|0)+100>>2]=w;do if(y){A=+g[y+344>>2];if(!(c[u+(m*244|0)+240>>2]|0))break;ca=w*A*+g[t+((v+1|0)*152|0)+20>>2]*+g[u+(m*244|0)+116>>2];ba=w*A*+g[t+((v+1|0)*152|0)+24>>2]*+g[u+(m*244|0)+120>>2];g[u+(m*244|0)+64>>2]=+g[u+(m*244|0)+112>>2]*w*A*+g[t+((v+1|0)*152|0)+16>>2]+ +g[u+(m*244|0)+64>>2];g[u+(m*244|0)+68>>2]=ca+ +g[u+(m*244|0)+68>>2];g[u+(m*244|0)+72>>2]=ba+ +g[u+(m*244|0)+72>>2];ba=w*+g[u+(m*244|0)+100>>2]*+g[t+((v+1|0)*152|0)+68>>2];ca=w*+g[u+(m*244|0)+104>>2]*+g[t+((v+1|0)*152|0)+72>>2];g[u+(m*244|0)+80>>2]=w*+g[u+(m*244|0)+96>>2]*+g[t+((v+1|0)*152|0)+64>>2]+ +g[u+(m*244|0)+80>>2];g[u+(m*244|0)+84>>2]=ba+ +g[u+(m*244|0)+84>>2];g[u+(m*244|0)+88>>2]=ca+ +g[u+(m*244|0)+88>>2]}while(0);if(!x)break;A=+g[x+344>>2];w=+g[t+((v+1|0)*152|0)+100>>2];if(!(c[u+(n*244|0)+240>>2]|0))break;ca=+g[t+((v+1|0)*152|0)+88>>2];ba=+g[t+((v+1|0)*152|0)+84>>2];aa=+g[t+((v+1|0)*152|0)+80>>2];_=w*A*+g[t+((v+1|0)*152|0)+52>>2]*+g[u+(n*244|0)+116>>2];$=w*A*+g[t+((v+1|0)*152|0)+56>>2]*+g[u+(n*244|0)+120>>2];g[u+(n*244|0)+64>>2]=+g[u+(n*244|0)+112>>2]*w*A*+g[t+((v+1|0)*152|0)+48>>2]+ +g[u+(n*244|0)+64>>2];g[u+(n*244|0)+68>>2]=_+ +g[u+(n*244|0)+68>>2];g[u+(n*244|0)+72>>2]=$+ +g[u+(n*244|0)+72>>2];ba=ba*+g[u+(n*244|0)+100>>2]*-w;ca=ca*+g[u+(n*244|0)+104>>2]*-w;g[u+(n*244|0)+80>>2]=+g[u+(n*244|0)+80>>2]-aa*+g[u+(n*244|0)+96>>2]*-w;g[u+(n*244|0)+84>>2]=+g[u+(n*244|0)+84>>2]-ba;g[u+(n*244|0)+88>>2]=+g[u+(n*244|0)+88>>2]-ca}while(0);t=c[l+748>>2]|0}s=s+1|0}while((s|0)<(t|0))}}while(0);k=k+1|0}while((k|0)!=(e|0));i=r;return}



function Fr(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0;m=i;i=i+320|0;c[b+188>>2]=-1;yE(4080);c[b+184>>2]=0;if((e|0)>0){p=0;do{c[(c[d+(p<<2)>>2]|0)+212>>2]=-1;p=p+1|0}while((p|0)!=(e|0))}p=c[b+12>>2]|0;if((p|0)<(e+1|0)){if((e+1|0)!=0?(c[5004]=(c[5004]|0)+1,o=fF(((e+1|0)*244|3)+16|0)|0,(o|0)!=0):0){c[(o+19&-16)+ -4>>2]=o;o=o+19&-16}else o=0;p=c[b+8>>2]|0;if((p|0)>0){q=0;do{x=o+(q*244|0)|0;Y=c[b+16>>2]|0;w=Y+(q*244|0)|0;c[x+0>>2]=c[w+0>>2];c[x+4>>2]=c[w+4>>2];c[x+8>>2]=c[w+8>>2];c[x+12>>2]=c[w+12>>2];x=o+(q*244|0)+16|0;w=Y+(q*244|0)+16|0;c[x+0>>2]=c[w+0>>2];c[x+4>>2]=c[w+4>>2];c[x+8>>2]=c[w+8>>2];c[x+12>>2]=c[w+12>>2];x=o+(q*244|0)+32|0;w=Y+(q*244|0)+32|0;c[x+0>>2]=c[w+0>>2];c[x+4>>2]=c[w+4>>2];c[x+8>>2]=c[w+8>>2];c[x+12>>2]=c[w+12>>2];x=o+(q*244|0)+48|0;w=Y+(q*244|0)+48|0;c[x+0>>2]=c[w+0>>2];c[x+4>>2]=c[w+4>>2];c[x+8>>2]=c[w+8>>2];c[x+12>>2]=c[w+12>>2];mF(o+(q*244|0)+64|0,Y+(q*244|0)+64|0,180)|0;q=q+1|0}while((q|0)!=(p|0))}p=c[b+16>>2]|0;if(p){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[p+ -4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=o;c[b+12>>2]=e+1;o=b+8|0;q=e+1|0}else{o=b+8|0;q=p}jF(m+56|0,0,244)|0;p=c[o>>2]|0;if((p|0)<0){if((q|0)<0){q=c[b+16>>2]|0;if(q){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[q+ -4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0}do{Y=c[b+16>>2]|0;x=Y+(p*244|0)|0;c[x+0>>2]=c[m+56>>2];c[x+4>>2]=c[m+60>>2];c[x+8>>2]=c[m+64>>2];c[x+12>>2]=c[m+68>>2];x=Y+(p*244|0)+16|0;c[x+0>>2]=c[m+72>>2];c[x+4>>2]=c[m+76>>2];c[x+8>>2]=c[m+80>>2];c[x+12>>2]=c[m+84>>2];x=Y+(p*244|0)+32|0;c[x+0>>2]=c[m+88>>2];c[x+4>>2]=c[m+92>>2];c[x+8>>2]=c[m+96>>2];c[x+12>>2]=c[m+100>>2];x=Y+(p*244|0)+48|0;c[x+0>>2]=c[m+104>>2];c[x+4>>2]=c[m+108>>2];c[x+8>>2]=c[m+112>>2];c[x+12>>2]=c[m+116>>2];mF(Y+(p*244|0)+64|0,m+120|0,180)|0;p=p+1|0}while((p|0)!=0)}c[o>>2]=0;if((e|0)>0){o=0;do{p=d+(o<<2)|0;q=Cr(b,c[p>>2]|0,+g[l+12>>2])|0;p=c[p>>2]|0;if((!((p|0)==0?1:(c[p+236>>2]&2|0)==0)?+g[p+344>>2]!=0.0:0)?(n=c[b+16>>2]|0,(c[p+504>>2]&2|0)!=0):0){E=+g[l+76>>2];S=1.0/+g[p+396>>2];V=1.0/+g[p+400>>2];F=1.0/+g[p+404>>2];M=+g[p+4>>2];N=+g[p+8>>2];O=+g[p+12>>2];R=+g[p+20>>2];U=+g[p+24>>2];X=+g[p+28>>2];T=+g[p+36>>2];W=+g[p+40>>2];C=+g[p+44>>2];B=+g[p+328>>2];z=+g[p+332>>2];D=+g[p+336>>2];y=(M*S*M+N*V*N+O*F*O)*B+(S*M*R+V*N*U+F*O*X)*z+(S*M*T+V*N*W+F*O*C)*D;A=(M*S*R+N*V*U+O*F*X)*B+(R*S*R+U*V*U+X*F*X)*z+(S*R*T+V*U*W+F*X*C)*D;C=D*(T*S*T+W*V*W+C*F*C)+(B*(M*S*T+N*V*W+O*F*C)+z*(R*S*T+U*V*W+X*F*C));F=(z*C-D*A)*(z*C-D*A)+(D*y-B*C)*(D*y-B*C)+(B*A-z*y)*(B*A-z*y);if(F>E*E){X=1.0/+Q(+F)*E;E=(z*C-D*A)*X;C=X*(D*y-B*C);y=X*(B*A-z*y)}else{E=z*C-D*A;C=D*y-B*C;y=B*A-z*y}V=+g[l+12>>2];W=(E*+g[p+268>>2]+C*+g[p+284>>2]+y*+g[p+300>>2])*V;X=V*(E*+g[p+272>>2]+C*+g[p+288>>2]+y*+g[p+304>>2]);g[n+(q*244|0)+224>>2]=+g[n+(q*244|0)+224>>2]-(E*+g[p+264>>2]+C*+g[p+280>>2]+y*+g[p+296>>2])*V;g[n+(q*244|0)+228>>2]=+g[n+(q*244|0)+228>>2]-W;g[n+(q*244|0)+232>>2]=+g[n+(q*244|0)+232>>2]-X}o=o+1|0}while((o|0)<(e|0))}if((k|0)>0){e=0;do{Y=c[j+(e<<2)>>2]|0;Lb[c[(c[Y>>2]|0)+8>>2]&511](Y);g[Y+36>>2]=0.0;e=e+1|0}while((e|0)<(k|0))}o=c[b+168>>2]|0;if((o|0)<(k|0)?(c[b+172>>2]|0)<(k|0):0){if(!k)e=0;else{c[5004]=(c[5004]|0)+1;e=fF((k<<3|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}o=c[b+168>>2]|0}if((o|0)>0){n=0;do{d=e+(n<<3)|0;if(d){x=(c[b+176>>2]|0)+(n<<3)|0;Y=c[x+4>>2]|0;c[d>>2]=c[x>>2];c[d+4>>2]=Y}n=n+1|0}while((n|0)!=(o|0))}n=c[b+176>>2]|0;if(n){if(a[b+180>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[n+ -4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=e;c[b+172>>2]=k}c[b+168>>2]=k;if((k|0)>0){e=0;n=0;do{d=c[b+176>>2]|0;o=d+(e<<3)|0;p=j+(e<<2)|0;q=c[p>>2]|0;r=c[q+44>>2]|0;if(r){q=r+0|0;r=q+64|0;do{c[q>>2]=0;q=q+4|0}while((q|0)<(r|0));q=c[p>>2]|0}if(!(a[q+20>>0]|0)){c[o>>2]=0;c[d+(e<<3)+4>>2]=0;d=0}else{Nb[c[(c[q>>2]|0)+16>>2]&127](q,o);d=c[o>>2]|0}n=d+n|0;e=e+1|0}while((e|0)<(k|0))}else n=0;o=c[b+48>>2]|0;if((o|0)<(n|0)?(c[b+52>>2]|0)<(n|0):0){if(!n)e=0;else{c[5004]=(c[5004]|0)+1;e=fF((n*152|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}o=c[b+48>>2]|0}if((o|0)>0){d=0;do{mF(e+(d*152|0)|0,(c[b+56>>2]|0)+(d*152|0)|0,152)|0;d=d+1|0}while((d|0)!=(o|0))}d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[d+ -4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=e;c[b+52>>2]=n}c[b+48>>2]=n;if((k|0)>0){o=c[b+176>>2]|0;e=0;n=0;while(1){d=o+(n<<3)|0;if(!(c[d>>2]|0))d=0;else{v=c[b+56>>2]|0;u=j+(n<<2)|0;t=c[u>>2]|0;o=c[t+28>>2]|0;p=c[t+32>>2]|0;s=Cr(b,o,+g[l+12>>2])|0;r=Cr(b,p,+g[l+12>>2])|0;q=c[b+16>>2]|0;x=c[t+24>>2]|0;if((x|0)<=0)x=c[l+20>>2]|0;if((x|0)>(c[b+184>>2]|0))c[b+184>>2]=x;if((c[d>>2]|0)>0){w=0;do{Y=w+e|0;jF(v+(Y*152|0)|0,0,152)|0;g[v+(Y*152|0)+120>>2]=-3.4028234663852886e+38;g[v+(Y*152|0)+124>>2]=3.4028234663852886e+38;g[v+(Y*152|0)+100>>2]=0.0;g[v+(Y*152|0)+96>>2]=0.0;c[v+(Y*152|0)+144>>2]=s;c[v+(Y*152|0)+148>>2]=r;c[v+(Y*152|0)+136>>2]=x;w=w+1|0}while((w|0)<(c[d>>2]|0))}c[q+(s*244|0)+64>>2]=0;c[q+(s*244|0)+68>>2]=0;c[q+(s*244|0)+72>>2]=0;c[q+(s*244|0)+76>>2]=0;c[q+(s*244|0)+80>>2]=0;c[q+(s*244|0)+84>>2]=0;c[q+(s*244|0)+88>>2]=0;c[q+(s*244|0)+92>>2]=0;c[q+(s*244|0)+144>>2]=0;c[q+(s*244|0)+148>>2]=0;c[q+(s*244|0)+152>>2]=0;c[q+(s*244|0)+156>>2]=0;c[q+(s*244|0)+160>>2]=0;c[q+(s*244|0)+164>>2]=0;c[q+(s*244|0)+168>>2]=0;c[q+(s*244|0)+172>>2]=0;c[q+(r*244|0)+64>>2]=0;c[q+(r*244|0)+68>>2]=0;c[q+(r*244|0)+72>>2]=0;c[q+(r*244|0)+76>>2]=0;c[q+(r*244|0)+80>>2]=0;c[q+(r*244|0)+84>>2]=0;c[q+(r*244|0)+88>>2]=0;c[q+(r*244|0)+92>>2]=0;c[q+(r*244|0)+144>>2]=0;c[q+(r*244|0)+148>>2]=0;c[q+(r*244|0)+152>>2]=0;c[q+(r*244|0)+156>>2]=0;c[q+(r*244|0)+160>>2]=0;c[q+(r*244|0)+164>>2]=0;c[q+(r*244|0)+168>>2]=0;c[q+(r*244|0)+172>>2]=0;g[m>>2]=1.0/+g[l+12>>2];g[m+4>>2]=+g[l+32>>2];c[m+8>>2]=v+(e*152|0)+16;c[m+12>>2]=v+(e*152|0);c[m+16>>2]=v+(e*152|0)+48;c[m+20>>2]=v+(e*152|0)+32;c[m+24>>2]=38;c[m+28>>2]=v+(e*152|0)+112;Y=v+(e*152|0)+116|0;g[Y>>2]=+g[l+40>>2];g[m+52>>2]=+g[l+4>>2];c[m+32>>2]=Y;c[m+36>>2]=v+(e*152|0)+120;c[m+40>>2]=v+(e*152|0)+124;c[m+48>>2]=c[l+20>>2];Y=c[u>>2]|0;Nb[c[(c[Y>>2]|0)+20>>2]&127](Y,m);if((c[d>>2]|0)>0){w=0;do{x=w+e|0;Y=(c[u>>2]|0)+16|0;y=+g[Y>>2];if(+g[v+(x*152|0)+124>>2]>=y){g[v+(x*152|0)+124>>2]=y;y=+g[Y>>2]}y=-y;if(+g[v+(x*152|0)+120>>2]<=y)g[v+(x*152|0)+120>>2]=y;c[v+(x*152|0)+132>>2]=t;Y=c[t+28>>2]|0;W=+g[v+(x*152|0)>>2];I=+g[v+(x*152|0)+4>>2];J=+g[v+(x*152|0)+8>>2];y=(W*+g[Y+280>>2]+I*+g[Y+284>>2]+J*+g[Y+288>>2])*+g[Y+548>>2];H=(W*+g[Y+296>>2]+I*+g[Y+300>>2]+J*+g[Y+304>>2])*+g[Y+552>>2];g[v+(x*152|0)+64>>2]=(+g[Y+264>>2]*W+ +g[Y+268>>2]*I+ +g[Y+272>>2]*J)*+g[Y+544>>2];g[v+(x*152|0)+68>>2]=y;g[v+(x*152|0)+72>>2]=H;g[v+(x*152|0)+76>>2]=0.0;Y=c[t+32>>2]|0;H=+g[v+(x*152|0)+32>>2];y=+g[v+(x*152|0)+36>>2];J=+g[v+(x*152|0)+40>>2];I=(H*+g[Y+280>>2]+y*+g[Y+284>>2]+J*+g[Y+288>>2])*+g[Y+548>>2];W=(H*+g[Y+296>>2]+y*+g[Y+300>>2]+J*+g[Y+304>>2])*+g[Y+552>>2];g[v+(x*152|0)+80>>2]=(+g[Y+264>>2]*H+ +g[Y+268>>2]*y+ +g[Y+272>>2]*J)*+g[Y+544>>2];g[v+(x*152|0)+84>>2]=I;g[v+(x*152|0)+88>>2]=W;g[v+(x*152|0)+92>>2]=0.0;W=+g[o+344>>2];I=+g[v+(x*152|0)+16>>2];H=+g[v+(x*152|0)+20>>2];G=+g[v+(x*152|0)+24>>2];F=+g[v+(x*152|0)>>2];E=+g[v+(x*152|0)+4>>2];D=+g[v+(x*152|0)+8>>2];X=+g[p+344>>2];C=+g[v+(x*152|0)+48>>2];B=+g[v+(x*152|0)+52>>2];A=+g[v+(x*152|0)+56>>2];z=+g[v+(x*152|0)+32>>2];J=I*W*I+H*W*H+G*W*G+(F*(+g[o+264>>2]*F+ +g[o+268>>2]*E+ +g[o+272>>2]*D)+E*(F*+g[o+280>>2]+E*+g[o+284>>2]+D*+g[o+288>>2])+D*(F*+g[o+296>>2]+E*+g[o+300>>2]+D*+g[o+304>>2]))+(C*X*C+B*X*B+A*X*A)+(z*(+g[p+264>>2]*z+ +g[p+268>>2]*y+ +g[p+272>>2]*J)+y*(z*+g[p+280>>2]+y*+g[p+284>>2]+J*+g[p+288>>2])+J*(z*+g[p+296>>2]+y*+g[p+300>>2]+J*+g[p+304>>2]));if(+P(+J)>1.1920928955078125e-7)T=1.0/J;else T=0.0;g[v+(x*152|0)+108>>2]=T;if(!(c[q+(s*244|0)+240>>2]|0)){X=0.0;K=0.0;L=0.0;M=0.0;N=0.0;O=0.0}else{X=+g[q+(s*244|0)+208>>2];K=+g[q+(s*244|0)+212>>2];L=+g[q+(s*244|0)+216>>2];M=+g[q+(s*244|0)+224>>2];N=+g[q+(s*244|0)+228>>2];O=+g[q+(s*244|0)+232>>2]}if(!(c[q+(r*244|0)+240>>2]|0)){W=0.0;V=0.0;U=0.0;J=0.0;S=0.0;R=0.0}else{W=+g[q+(r*244|0)+208>>2];V=+g[q+(r*244|0)+212>>2];U=+g[q+(r*244|0)+216>>2];J=+g[q+(r*244|0)+224>>2];S=+g[q+(r*244|0)+228>>2];R=+g[q+(r*244|0)+232>>2]}g[v+(x*152|0)+112>>2]=+g[v+(x*152|0)+112>>2]*T+T*(0.0- +g[m+52>>2]*((X+ +g[o+312>>2])*I+(K+ +g[o+316>>2])*H+(L+ +g[o+320>>2])*G+((M+ +g[o+328>>2])*F+(N+ +g[o+332>>2])*E+(O+ +g[o+336>>2])*D)+((W+ +g[p+312>>2])*C+(V+ +g[p+316>>2])*B+(U+ +g[p+320>>2])*A+((J+ +g[p+328>>2])*z+(S+ +g[p+332>>2])*y+(R+ +g[p+336>>2])*+g[v+(x*152|0)+40>>2]))));g[v+(x*152|0)+100>>2]=0.0;w=w+1|0}while((w|0)<(c[d>>2]|0))}d=c[b+176>>2]|0;o=d;d=c[d+(n<<3)>>2]|0}n=n+1|0;if((n|0)>=(k|0))break;else e=d+e|0}}vc[c[(c[b>>2]|0)+28>>2]&127](b,f,h,l);f=c[b+48>>2]|0;j=c[b+28>>2]|0;k=c[b+68>>2]|0;e=c[b+128>>2]|0;if((e|0)<(f|0)?(c[b+132>>2]|0)<(f|0):0){if(!f)h=0;else{c[5004]=(c[5004]|0)+1;h=fF((f<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}e=c[b+128>>2]|0}if((e|0)>0){n=0;do{d=h+(n<<2)|0;if(d)c[d>>2]=c[(c[b+136>>2]|0)+(n<<2)>>2];n=n+1|0}while((n|0)!=(e|0))}e=c[b+136>>2]|0;if(e){if(a[b+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=h;c[b+132>>2]=f}c[b+128>>2]=f;if(!(c[l+64>>2]&16)){h=c[b+108>>2]|0;if((h|0)<(j|0)?(c[b+112>>2]|0)<(j|0):0){if(!j)l=0;else{c[5004]=(c[5004]|0)+1;l=fF((j<<2|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}h=c[b+108>>2]|0}if((h|0)>0){e=0;do{n=l+(e<<2)|0;if(n)c[n>>2]=c[(c[b+116>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(h|0))}h=c[b+116>>2]|0;if(h){if(a[b+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=l;c[b+112>>2]=j}c[b+108>>2]=j}else{n=c[b+108>>2]|0;if((n|0)<(j<<1|0)?(c[b+112>>2]|0)<(j<<1|0):0){if(!j)l=0;else{c[5004]=(c[5004]|0)+1;l=fF((j<<3|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}n=c[b+108>>2]|0}if((n|0)>0){e=0;do{h=l+(e<<2)|0;if(h)c[h>>2]=c[(c[b+116>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(n|0))}h=c[b+116>>2]|0;if(h){if(a[b+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=l;c[b+112>>2]=j<<1}c[b+108>>2]=j<<1}e=c[b+148>>2]|0;if((e|0)<(k|0)?(c[b+152>>2]|0)<(k|0):0){if(!k)l=0;else{c[5004]=(c[5004]|0)+1;l=fF((k<<2|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}e=c[b+148>>2]|0}if((e|0)>0){h=0;do{n=l+(h<<2)|0;if(n)c[n>>2]=c[(c[b+156>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}h=c[b+156>>2]|0;if(h){if(a[b+160>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=l;c[b+152>>2]=k}c[b+148>>2]=k;if((f|0)>0){h=c[b+136>>2]|0;l=0;do{c[h+(l<<2)>>2]=l;l=l+1|0}while((l|0)!=(f|0))}if((j|0)>0){l=c[b+116>>2]|0;f=0;do{c[l+(f<<2)>>2]=f;f=f+1|0}while((f|0)!=(j|0))}if((k|0)>0){b=c[b+156>>2]|0;l=0;do{c[b+(l<<2)>>2]=l;l=l+1|0}while((l|0)!=(k|0))}b=c[5022]|0;Y=(c[b+16>>2]|0)+ -1|0;c[b+16>>2]=Y;if(Y){i=m;return 0.0}do if(c[b+4>>2]|0){Eb(m+304|0,0)|0;Y=c[5008]|0;g[b+8>>2]=+(((c[m+308>>2]|0)-(c[Y+4>>2]|0)+(((c[m+304>>2]|0)-(c[Y>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5022]|0;break}else{i=m;return 0.0}}while(0);c[5022]=c[b+20>>2];i=m;return 0.0}function Gr(b,d,e,f,h,j,k,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0;j=i;n=c[b+48>>2]|0;e=c[b+28>>2]|0;h=c[b+68>>2]|0;if(c[m+64>>2]&1){if((n|0)>0){f=c[b+136>>2]|0;q=c[b+192>>2]|0;r=0;do{s=f+(r<<2)|0;t=c[s>>2]|0;r=r+1|0;q=(aa(q,1664525)|0)+1013904223|0;if(r>>>0<65537){u=q>>>16^q;if(r>>>0<257)if(r>>>0<17){u=(u>>>8^u)>>>4^(u>>>8^u);if(r>>>0<5)if(r>>>0<3)u=(u>>>2^u)>>>1^(u>>>2^u);else u=u>>>2^u}else u=u>>>8^u}else u=q;u=f+(((u>>>0)%(r>>>0)|0)<<2)|0;c[s>>2]=c[u>>2];c[u>>2]=t}while((r|0)!=(n|0));c[b+192>>2]=q}if((c[m+20>>2]|0)>(d|0)){if((e|0)>0){s=c[b+116>>2]|0;r=c[b+192>>2]|0;q=0;do{f=s+(q<<2)|0;n=c[f>>2]|0;q=q+1|0;r=(aa(r,1664525)|0)+1013904223|0;if(q>>>0<65537){t=r>>>16^r;if(q>>>0<257)if(q>>>0<17){t=(t>>>8^t)>>>4^(t>>>8^t);if(q>>>0<5)if(q>>>0<3)t=(t>>>2^t)>>>1^(t>>>2^t);else t=t>>>2^t}else t=t>>>8^t}else t=r;u=s+(((t>>>0)%(q>>>0)|0)<<2)|0;c[f>>2]=c[u>>2];c[u>>2]=n}while((q|0)!=(e|0));c[b+192>>2]=r}if((h|0)>0){r=c[b+156>>2]|0;q=c[b+192>>2]|0;f=0;do{n=r+(f<<2)|0;e=c[n>>2]|0;f=f+1|0;q=(aa(q,1664525)|0)+1013904223|0;if(f>>>0<65537){s=q>>>16^q;if(f>>>0<257)if(f>>>0<17){s=(s>>>8^s)>>>4^(s>>>8^s);if(f>>>0<5)if(f>>>0<3)s=(s>>>2^s)>>>1^(s>>>2^s);else s=s>>>2^s}else s=s>>>8^s}else s=q;u=r+(((s>>>0)%(f>>>0)|0)<<2)|0;c[n>>2]=c[u>>2];c[u>>2]=e}while((f|0)!=(h|0));c[b+192>>2]=q}}}f=c[b+48>>2]|0;if(!(c[m+64>>2]&256)){if((f|0)>0){o=0;do{h=c[(c[b+136>>2]|0)+(o<<2)>>2]|0;p=c[b+56>>2]|0;if((c[p+(h*152|0)+136>>2]|0)>(d|0)){f=c[b+16>>2]|0;vr(f+((c[p+(h*152|0)+144>>2]|0)*244|0)|0,f+((c[p+(h*152|0)+148>>2]|0)*244|0)|0,p+(h*152|0)|0);f=c[b+48>>2]|0}o=o+1|0}while((o|0)<(f|0))}if((c[m+20>>2]|0)<=(d|0)){i=j;return 0.0}if((l|0)>0){p=0;do{o=k+(p<<2)|0;d=c[o>>2]|0;if(a[d+20>>0]|0){s=Cr(b,c[d+28>>2]|0,+g[m+12>>2])|0;u=Cr(b,c[(c[o>>2]|0)+32>>2]|0,+g[m+12>>2])|0;t=c[b+16>>2]|0;r=c[o>>2]|0;qc[c[(c[r>>2]|0)+24>>2]&15](r,t+(s*244|0)|0,t+(u*244|0)|0,+g[m+12>>2])}p=p+1|0}while((p|0)!=(l|0))}m=c[b+28>>2]|0;if((m|0)>0){l=0;do{u=c[(c[b+116>>2]|0)+(l<<2)>>2]|0;t=c[b+36>>2]|0;s=c[b+16>>2]|0;wr(s+((c[t+(u*152|0)+144>>2]|0)*244|0)|0,s+((c[t+(u*152|0)+148>>2]|0)*244|0)|0,t+(u*152|0)|0);l=l+1|0}while((l|0)!=(m|0))}m=c[b+68>>2]|0;if((m|0)>0){l=0;do{k=c[(c[b+156>>2]|0)+(l<<2)>>2]|0;o=c[b+76>>2]|0;v=+g[(c[b+36>>2]|0)+((c[o+(k*152|0)+140>>2]|0)*152|0)+100>>2];if(v>0.0){v=v*+g[o+(k*152|0)+104>>2];g[o+(k*152|0)+120>>2]=-v;g[o+(k*152|0)+124>>2]=v;u=c[b+16>>2]|0;vr(u+((c[o+(k*152|0)+144>>2]|0)*244|0)|0,u+((c[o+(k*152|0)+148>>2]|0)*244|0)|0,o+(k*152|0)|0)}l=l+1|0}while((l|0)!=(m|0))}m=c[b+88>>2]|0;if((m|0)<=0){i=j;return 0.0}l=0;do{k=c[b+96>>2]|0;v=+g[(c[b+36>>2]|0)+((c[k+(l*152|0)+140>>2]|0)*152|0)+100>>2];if(v>0.0){w=+g[k+(l*152|0)+104>>2];v=v*w>w?w:v*w;g[k+(l*152|0)+120>>2]=-v;g[k+(l*152|0)+124>>2]=v;u=c[b+16>>2]|0;vr(u+((c[k+(l*152|0)+144>>2]|0)*244|0)|0,u+((c[k+(l*152|0)+148>>2]|0)*244|0)|0,k+(l*152|0)|0)}l=l+1|0}while((l|0)!=(m|0));i=j;return 0.0}if((f|0)>0){h=0;do{n=c[(c[b+136>>2]|0)+(h<<2)>>2]|0;e=c[b+56>>2]|0;if((c[e+(n*152|0)+136>>2]|0)>(d|0)){f=c[b+16>>2]|0;vr(f+((c[e+(n*152|0)+144>>2]|0)*244|0)|0,f+((c[e+(n*152|0)+148>>2]|0)*244|0)|0,e+(n*152|0)|0);f=c[b+48>>2]|0}h=h+1|0}while((h|0)<(f|0))}if((c[m+20>>2]|0)<=(d|0)){i=j;return 0.0}if((l|0)>0){d=0;do{e=k+(d<<2)|0;h=c[e>>2]|0;if(a[h+20>>0]|0){s=Cr(b,c[h+28>>2]|0,+g[m+12>>2])|0;u=Cr(b,c[(c[e>>2]|0)+32>>2]|0,+g[m+12>>2])|0;t=c[b+16>>2]|0;r=c[e>>2]|0;qc[c[(c[r>>2]|0)+24>>2]&15](r,t+(s*244|0)|0,t+(u*244|0)|0,+g[m+12>>2])}d=d+1|0}while((d|0)!=(l|0))}n=c[m+64>>2]|0;l=c[b+28>>2]|0;if(n&512){if((l|0)<=0){i=j;return 0.0}e=0;do{h=c[(c[b+116>>2]|0)+(e<<2)>>2]|0;d=c[b+36>>2]|0;k=c[b+16>>2]|0;wr(k+((c[d+(h*152|0)+144>>2]|0)*244|0)|0,k+((c[d+(h*152|0)+148>>2]|0)*244|0)|0,d+(h*152|0)|0);v=+g[d+(h*152|0)+100>>2];h=aa(e,(n>>>4&1)+1|0)|0;d=c[(c[b+156>>2]|0)+(h<<2)>>2]|0;k=c[b+76>>2]|0;if(v>0.0){w=v*+g[k+(d*152|0)+104>>2];g[k+(d*152|0)+120>>2]=-w;g[k+(d*152|0)+124>>2]=w;u=c[b+16>>2]|0;vr(u+((c[k+(d*152|0)+144>>2]|0)*244|0)|0,u+((c[k+(d*152|0)+148>>2]|0)*244|0)|0,k+(d*152|0)|0)}if((c[m+64>>2]&16|0)!=0?(o=c[(c[b+156>>2]|0)+(h+1<<2)>>2]|0,p=c[b+76>>2]|0,v>0.0):0){w=v*+g[p+(o*152|0)+104>>2];g[p+(o*152|0)+120>>2]=-w;g[p+(o*152|0)+124>>2]=w;u=c[b+16>>2]|0;vr(u+((c[p+(o*152|0)+144>>2]|0)*244|0)|0,u+((c[p+(o*152|0)+148>>2]|0)*244|0)|0,p+(o*152|0)|0)}e=e+1|0}while((e|0)!=(l|0));i=j;return 0.0}if((l|0)>0){m=0;do{u=c[(c[b+116>>2]|0)+(m<<2)>>2]|0;t=c[b+36>>2]|0;s=c[b+16>>2]|0;wr(s+((c[t+(u*152|0)+144>>2]|0)*244|0)|0,s+((c[t+(u*152|0)+148>>2]|0)*244|0)|0,t+(u*152|0)|0);m=m+1|0}while((m|0)!=(l|0))}m=c[b+68>>2]|0;if((m|0)>0){l=0;do{k=c[(c[b+156>>2]|0)+(l<<2)>>2]|0;o=c[b+76>>2]|0;v=+g[(c[b+36>>2]|0)+((c[o+(k*152|0)+140>>2]|0)*152|0)+100>>2];if(v>0.0){w=v*+g[o+(k*152|0)+104>>2];g[o+(k*152|0)+120>>2]=-w;g[o+(k*152|0)+124>>2]=w;u=c[b+16>>2]|0;vr(u+((c[o+(k*152|0)+144>>2]|0)*244|0)|0,u+((c[o+(k*152|0)+148>>2]|0)*244|0)|0,o+(k*152|0)|0)}l=l+1|0}while((l|0)!=(m|0))}k=c[b+88>>2]|0;if((k|0)<=0){i=j;return 0.0}l=0;do{m=c[b+96>>2]|0;v=+g[(c[b+36>>2]|0)+((c[m+(l*152|0)+140>>2]|0)*152|0)+100>>2];if(v>0.0){w=+g[m+(l*152|0)+104>>2];w=v*w>w?w:v*w;g[m+(l*152|0)+120>>2]=-w;g[m+(l*152|0)+124>>2]=w;u=c[b+16>>2]|0;vr(u+((c[m+(l*152|0)+144>>2]|0)*244|0)|0,u+((c[m+(l*152|0)+148>>2]|0)*244|0)|0,m+(l*152|0)|0)}l=l+1|0}while((l|0)!=(k|0));i=j;return 0.0}function Hr(a,b,d,e,f,g,h,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;d=i;if(!(c[j+44>>2]|0)){i=d;return}h=c[j+20>>2]|0;if(!(c[j+64>>2]&256)){if((h|0)<=0){i=d;return}f=1;while(1){g=c[a+28>>2]|0;if((g|0)>0){h=0;do{e=c[(c[a+116>>2]|0)+(h<<2)>>2]|0;b=c[a+36>>2]|0;k=c[a+16>>2]|0;xr(k+((c[b+(e*152|0)+144>>2]|0)*244|0)|0,k+((c[b+(e*152|0)+148>>2]|0)*244|0)|0,b+(e*152|0)|0);h=h+1|0}while((h|0)!=(g|0));h=c[j+20>>2]|0}if((f|0)>=(h|0))break;f=f+1|0}i=d;return}else{if((h|0)<=0){i=d;return}f=1;while(1){g=c[a+28>>2]|0;if((g|0)>0){h=0;do{e=c[(c[a+116>>2]|0)+(h<<2)>>2]|0;b=c[a+36>>2]|0;k=c[a+16>>2]|0;xr(k+((c[b+(e*152|0)+144>>2]|0)*244|0)|0,k+((c[b+(e*152|0)+148>>2]|0)*244|0)|0,b+(e*152|0)|0);h=h+1|0}while((h|0)!=(g|0));h=c[j+20>>2]|0}if((f|0)>=(h|0))break;f=f+1|0}i=d;return}}function Ir(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;m=i;i=i+16|0;yE(4112);ec[c[(c[a>>2]|0)+32>>2]&1](a,b,d,e,f,h,j,k,l);o=c[a+184>>2]|0;n=c[k+20>>2]|0;n=(o|0)>(n|0)?o:n;if((n|0)>0){o=0;do{+ic[c[(c[a>>2]|0)+40>>2]&3](a,o,b,d,e,f,h,j,k,l);o=o+1|0}while((o|0)<(n|0))}h=c[5022]|0;o=(c[h+16>>2]|0)+ -1|0;c[h+16>>2]=o;if(o){i=m;return 0.0}do if(c[h+4>>2]|0){Eb(m|0,0)|0;o=c[5008]|0;g[h+8>>2]=+(((c[m+4>>2]|0)-(c[o+4>>2]|0)+(((c[m>>2]|0)-(c[o>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3+ +g[h+8>>2];if(!(c[h+16>>2]|0)){h=c[5022]|0;break}else{i=m;return 0.0}}while(0);c[5022]=c[h+20>>2];i=m;return 0.0}function Jr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0;d=i;i=i+80|0;j=c[b+28>>2]|0;l=c[f+64>>2]|0;if((l&4|0)!=0&(j|0)>0){e=c[b+36>>2]|0;k=c[b+76>>2]|0;if(!(l&16)){l=0;do{q=c[e+(l*152|0)+132>>2]|0;g[q+120>>2]=+g[e+(l*152|0)+100>>2];g[q+124>>2]=+g[k+((c[e+(l*152|0)+140>>2]|0)*152|0)+100>>2];l=l+1|0}while((l|0)!=(j|0))}else{l=0;do{q=c[e+(l*152|0)+132>>2]|0;g[q+120>>2]=+g[e+(l*152|0)+100>>2];p=c[e+(l*152|0)+140>>2]|0;g[q+124>>2]=+g[k+(p*152|0)+100>>2];g[q+128>>2]=+g[k+((p+1|0)*152|0)+100>>2];l=l+1|0}while((l|0)!=(j|0))}}j=c[b+48>>2]|0;if((j|0)>0){k=0;do{e=c[b+56>>2]|0;l=c[e+(k*152|0)+132>>2]|0;q=c[l+44>>2]|0;p=e+(k*152|0)+100|0;if(q){o=+g[p>>2];s=c[l+28>>2]|0;n=1.0/+g[f+12>>2];m=o*+g[e+(k*152|0)+20>>2]*+g[s+352>>2]*n;r=o*+g[e+(k*152|0)+24>>2]*+g[s+356>>2]*n;g[q>>2]=+g[e+(k*152|0)+16>>2]*o*+g[s+348>>2]*n+ +g[q>>2];g[q+4>>2]=m+ +g[q+4>>2];g[q+8>>2]=r+ +g[q+8>>2];r=+g[p>>2];s=c[l+32>>2]|0;m=1.0/+g[f+12>>2];n=r*+g[e+(k*152|0)+52>>2]*+g[s+352>>2]*m;o=r*+g[e+(k*152|0)+56>>2]*+g[s+356>>2]*m;g[q+32>>2]=+g[e+(k*152|0)+48>>2]*r*+g[s+348>>2]*m+ +g[q+32>>2];g[q+36>>2]=n+ +g[q+36>>2];g[q+40>>2]=o+ +g[q+40>>2];s=c[l+28>>2]|0;o=+g[p>>2];n=1.0/+g[f+12>>2];m=+g[e+(k*152|0)+4>>2]*+g[s+548>>2]*o*n;r=o*+g[e+(k*152|0)+8>>2]*+g[s+552>>2]*n;g[q+16>>2]=+g[e+(k*152|0)>>2]*+g[s+544>>2]*o*n+ +g[q+16>>2];g[q+20>>2]=m+ +g[q+20>>2];g[q+24>>2]=r+ +g[q+24>>2];s=c[l+32>>2]|0;r=+g[p>>2];m=1.0/+g[f+12>>2];n=+g[e+(k*152|0)+36>>2]*+g[s+548>>2]*r*m;o=r*+g[e+(k*152|0)+40>>2]*+g[s+552>>2]*m;g[q+48>>2]=+g[e+(k*152|0)+32>>2]*+g[s+544>>2]*r*m+ +g[q+48>>2];g[q+52>>2]=n+ +g[q+52>>2];g[q+56>>2]=o+ +g[q+56>>2]}g[l+36>>2]=+g[p>>2];r=+P(+(+g[p>>2]));if(r>=+g[l+16>>2])a[l+20>>0]=0;k=k+1|0}while((k|0)!=(j|0))}p=c[b+8>>2]|0;if((p|0)>0){j=c[b+16>>2]|0;e=0;do{k=j+(e*244|0)|0;l=c[j+(e*244|0)+240>>2]|0;if(l){if(!(c[f+44>>2]|0)){s=j+(e*244|0)+176|0;o=+g[j+(e*244|0)+64>>2]+ +g[s>>2];g[s>>2]=o;s=j+(e*244|0)+180|0;n=+g[j+(e*244|0)+68>>2]+ +g[s>>2];g[s>>2]=n;s=j+(e*244|0)+184|0;m=+g[j+(e*244|0)+72>>2]+ +g[s>>2];g[s>>2]=m;s=j+(e*244|0)+192|0;g[s>>2]=+g[j+(e*244|0)+80>>2]+ +g[s>>2];s=j+(e*244|0)+196|0;g[s>>2]=+g[j+(e*244|0)+84>>2]+ +g[s>>2];s=j+(e*244|0)+200|0;g[s>>2]=+g[j+(e*244|0)+88>>2]+ +g[s>>2]}else{n=+g[f+12>>2];m=+g[f+52>>2];l=j+(e*244|0)+176|0;g[l>>2]=+g[j+(e*244|0)+64>>2]+ +g[l>>2];l=j+(e*244|0)+180|0;g[l>>2]=+g[j+(e*244|0)+68>>2]+ +g[l>>2];l=j+(e*244|0)+184|0;g[l>>2]=+g[j+(e*244|0)+72>>2]+ +g[l>>2];l=j+(e*244|0)+192|0;g[l>>2]=+g[j+(e*244|0)+80>>2]+ +g[l>>2];l=j+(e*244|0)+196|0;g[l>>2]=+g[j+(e*244|0)+84>>2]+ +g[l>>2];l=j+(e*244|0)+200|0;g[l>>2]=+g[j+(e*244|0)+88>>2]+ +g[l>>2];l=j+(e*244|0)+144|0;p=j+(e*244|0)+148|0;if(((((!(+g[l>>2]!=0.0)?!(+g[p>>2]!=0.0):0)?!(+g[j+(e*244|0)+152>>2]!=0.0):0)?!(+g[j+(e*244|0)+160>>2]!=0.0):0)?!(+g[j+(e*244|0)+164>>2]!=0.0):0)?!(+g[j+(e*244|0)+168>>2]!=0.0):0)k=j;else h=22;if((h|0)==22){h=0;o=+g[j+(e*244|0)+164>>2]*m;r=+g[j+(e*244|0)+168>>2]*m;g[d>>2]=+g[j+(e*244|0)+160>>2]*m;g[d+4>>2]=o;g[d+8>>2]=r;g[d+12>>2]=0.0;Bo(k,+g[l>>2],+g[p>>2],+g[j+(e*244|0)+152>>2],d,n,d+16|0);c[k+0>>2]=c[d+16>>2];c[k+4>>2]=c[d+20>>2];c[k+8>>2]=c[d+24>>2];c[k+12>>2]=c[d+28>>2];k=j+(e*244|0)+16|0;c[k+0>>2]=c[d+32>>2];c[k+4>>2]=c[d+36>>2];c[k+8>>2]=c[d+40>>2];c[k+12>>2]=c[d+44>>2];k=j+(e*244|0)+32|0;c[k+0>>2]=c[d+48>>2];c[k+4>>2]=c[d+52>>2];c[k+8>>2]=c[d+56>>2];c[k+12>>2]=c[d+60>>2];k=j+(e*244|0)+48|0;c[k+0>>2]=c[d+64>>2];c[k+4>>2]=c[d+68>>2];c[k+8>>2]=c[d+72>>2];c[k+12>>2]=c[d+76>>2];k=c[b+16>>2]|0}j=k;o=+g[k+(e*244|0)+176>>2];n=+g[k+(e*244|0)+180>>2];m=+g[k+(e*244|0)+184>>2];l=c[k+(e*244|0)+240>>2]|0}r=o+ +g[j+(e*244|0)+208>>2];o=n+ +g[j+(e*244|0)+212>>2];n=m+ +g[j+(e*244|0)+216>>2];q=l+260|0;c[q>>2]=(c[q>>2]|0)+1;g[l+312>>2]=r;g[l+316>>2]=o;g[l+320>>2]=n;g[l+324>>2]=0.0;q=c[b+16>>2]|0;s=c[q+(e*244|0)+240>>2]|0;n=+g[q+(e*244|0)+192>>2]+ +g[q+(e*244|0)+224>>2];o=+g[q+(e*244|0)+196>>2]+ +g[q+(e*244|0)+228>>2];r=+g[q+(e*244|0)+200>>2]+ +g[q+(e*244|0)+232>>2];c[s+260>>2]=(c[s+260>>2]|0)+1;g[s+328>>2]=n;g[s+332>>2]=o;g[s+336>>2]=r;g[s+340>>2]=0.0;if(c[f+44>>2]|0){q=c[b+16>>2]|0;s=c[q+(e*244|0)+240>>2]|0;p=q+(e*244|0)|0;c[s+260>>2]=(c[s+260>>2]|0)+1;c[s+4>>2]=c[p+0>>2];c[s+8>>2]=c[p+4>>2];c[s+12>>2]=c[p+8>>2];c[s+16>>2]=c[p+12>>2];p=q+(e*244|0)+16|0;c[s+20>>2]=c[p+0>>2];c[s+24>>2]=c[p+4>>2];c[s+28>>2]=c[p+8>>2];c[s+32>>2]=c[p+12>>2];p=q+(e*244|0)+32|0;c[s+36>>2]=c[p+0>>2];c[s+40>>2]=c[p+4>>2];c[s+44>>2]=c[p+8>>2];c[s+48>>2]=c[p+12>>2];q=q+(e*244|0)+48|0;c[s+52>>2]=c[q+0>>2];c[s+56>>2]=c[q+4>>2];c[s+60>>2]=c[q+8>>2];c[s+64>>2]=c[q+12>>2]}j=c[b+16>>2]|0;c[(c[j+(e*244|0)+240>>2]|0)+212>>2]=-1;p=c[b+8>>2]|0}e=e+1|0}while((e|0)<(p|0))}if((c[b+28>>2]|0)<0?(c[b+32>>2]|0)<0:0){f=c[b+36>>2]|0;if(f){if(a[b+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+32>>2]=0}c[b+28>>2]=0;if((c[b+48>>2]|0)<0?(c[b+52>>2]|0)<0:0){f=c[b+56>>2]|0;if(f){if(a[b+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+52>>2]=0}c[b+48>>2]=0;if((c[b+68>>2]|0)<0?(c[b+72>>2]|0)<0:0){f=c[b+76>>2]|0;if(f){if(a[b+80>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+72>>2]=0}c[b+68>>2]=0;if((c[b+88>>2]|0)<0?(c[b+92>>2]|0)<0:0){f=c[b+96>>2]|0;if(f){if(a[b+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+92>>2]=0}c[b+88>>2]=0;if((c[b+8>>2]|0)>=0){c[b+8>>2]=0;i=d;return 0.0}if((c[b+12>>2]|0)>=0){c[b+8>>2]=0;i=d;return 0.0}f=c[b+16>>2]|0;if(f){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0;c[b+8>>2]=0;i=d;return 0.0}function Kr(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;m=i;i=i+16|0;yE(4152);+kc[c[(c[a>>2]|0)+44>>2]&3](a,b,d,e,f,h,j,k,l);+kc[c[(c[a>>2]|0)+48>>2]&3](a,b,d,e,f,h,j,k,l);+oc[c[(c[a>>2]|0)+36>>2]&1](a,b,d,k);j=c[5022]|0;e=(c[j+16>>2]|0)+ -1|0;c[j+16>>2]=e;if(e){i=m;return 0.0}do if(c[j+4>>2]|0){Eb(m|0,0)|0;e=c[5008]|0;g[j+8>>2]=+(((c[m+4>>2]|0)-(c[e+4>>2]|0)+(((c[m>>2]|0)-(c[e>>2]|0)|0)*1e6|0)-(c[j+12>>2]|0)|0)>>>0)/1.0e3+ +g[j+8>>2];if(!(c[j+16>>2]|0)){j=c[5022]|0;break}else{i=m;return 0.0}}while(0);c[5022]=c[j+20>>2];i=m;return 0.0}function Lr(a){a=a|0;c[a+192>>2]=0;return}function Mr(a,b,c){a=a|0;b=b|0;c=c|0;return}function Nr(a,b,c){a=a|0;b=b|0;c=c|0;return}function Or(a){a=a|0;return 1}function Pr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0;f=i;i=i+256|0;if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)!=0:0){no(f+64|0,e,b+116|0);c[b+824>>2]=c[f+64>>2];c[b+828>>2]=c[f+68>>2];c[b+832>>2]=c[f+72>>2];c[b+836>>2]=c[f+76>>2];c[b+840>>2]=c[f+80>>2];c[b+844>>2]=c[f+84>>2];c[b+848>>2]=c[f+88>>2];c[b+852>>2]=c[f+92>>2];c[b+856>>2]=c[f+96>>2];c[b+860>>2]=c[f+100>>2];c[b+864>>2]=c[f+104>>2];c[b+868>>2]=c[f+108>>2];c[b+872>>2]=c[f+112>>2];c[b+876>>2]=c[f+116>>2];c[b+880>>2]=c[f+120>>2];c[b+884>>2]=c[f+124>>2];no(f,d,b+52|0);c[b+888>>2]=c[f+0>>2];c[b+892>>2]=c[f+4>>2];c[b+896>>2]=c[f+8>>2];c[b+900>>2]=c[f+12>>2];c[b+904>>2]=c[f+16>>2];c[b+908>>2]=c[f+20>>2];c[b+912>>2]=c[f+24>>2];c[b+916>>2]=c[f+28>>2];c[b+920>>2]=c[f+32>>2];c[b+924>>2]=c[f+36>>2];c[b+928>>2]=c[f+40>>2];c[b+932>>2]=c[f+44>>2];c[b+936>>2]=c[f+48>>2];c[b+940>>2]=c[f+52>>2];c[b+944>>2]=c[f+56>>2];c[b+948>>2]=c[f+60>>2]}else{no(f+192|0,d,b+52|0);c[b+824>>2]=c[f+192>>2];c[b+828>>2]=c[f+196>>2];c[b+832>>2]=c[f+200>>2];c[b+836>>2]=c[f+204>>2];c[b+840>>2]=c[f+208>>2];c[b+844>>2]=c[f+212>>2];c[b+848>>2]=c[f+216>>2];c[b+852>>2]=c[f+220>>2];c[b+856>>2]=c[f+224>>2];c[b+860>>2]=c[f+228>>2];c[b+864>>2]=c[f+232>>2];c[b+868>>2]=c[f+236>>2];c[b+872>>2]=c[f+240>>2];c[b+876>>2]=c[f+244>>2];c[b+880>>2]=c[f+248>>2];c[b+884>>2]=c[f+252>>2];no(f+128|0,e,b+116|0);c[b+888>>2]=c[f+128>>2];c[b+892>>2]=c[f+132>>2];c[b+896>>2]=c[f+136>>2];c[b+900>>2]=c[f+140>>2];c[b+904>>2]=c[f+144>>2];c[b+908>>2]=c[f+148>>2];c[b+912>>2]=c[f+152>>2];c[b+916>>2]=c[f+156>>2];c[b+920>>2]=c[f+160>>2];c[b+924>>2]=c[f+164>>2];c[b+928>>2]=c[f+168>>2];c[b+932>>2]=c[f+172>>2];c[b+936>>2]=c[f+176>>2];c[b+940>>2]=c[f+180>>2];c[b+944>>2]=c[f+184>>2];c[b+948>>2]=c[f+188>>2]}c[b+968>>2]=c[b+872>>2];c[b+972>>2]=c[b+876>>2];c[b+976>>2]=c[b+880>>2];c[b+980>>2]=c[b+884>>2];c[b+984>>2]=c[b+936>>2];c[b+988>>2]=c[b+940>>2];c[b+992>>2]=c[b+944>>2];c[b+996>>2]=c[b+948>>2];k=+g[b+824>>2];j=+g[b+840>>2];h=+g[b+856>>2];g[b+952>>2]=k;g[b+956>>2]=j;g[b+960>>2]=h;g[b+964>>2]=0.0;if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)==0:0){t=+g[b+968>>2];n=t- +g[b+984>>2];r=+g[b+972>>2];m=r- +g[b+988>>2];q=+g[b+976>>2];l=q- +g[b+992>>2];g[b+1016>>2]=n;g[b+1020>>2]=m;g[b+1024>>2]=l;g[b+1028>>2]=0.0;p=k*n;s=j*m;s=p+s;p=h*l;p=s+p;s=k*p;j=j*p;k=h*p;h=t+s;j=r+j;k=q+k;d=b+1e3|0;g[d>>2]=h;d=b+1004|0;g[d>>2]=j;d=b+1008|0;g[d>>2]=k;d=b+1012|0;g[d>>2]=0.0;d=b+1032|0;g[d>>2]=p;d=b+828|0;e=b+844|0;o=b+860|0;k=+g[d>>2];j=+g[e>>2];h=+g[o>>2];k=k*n;j=j*m;j=k+j;h=h*l;h=j+h;o=b+1036|0;g[o>>2]=h;o=b+832|0;e=b+848|0;d=b+864|0;h=+g[o>>2];j=+g[e>>2];k=+g[d>>2];h=h*n;j=j*m;j=h+j;k=k*l;k=j+k;d=b+1040|0;g[d>>2]=k;i=f;return}v=+g[b+968>>2];q=+g[b+984>>2]-v;u=+g[b+972>>2];s=+g[b+988>>2]-u;l=+g[b+976>>2];t=+g[b+992>>2]-l;g[b+1016>>2]=q;g[b+1020>>2]=s;g[b+1024>>2]=t;g[b+1028>>2]=0.0;r=k*q;m=j*s;m=r+m;r=h*t;r=m+r;m=k*r;n=j*r;p=h*r;m=v+m;n=u+n;p=l+p;o=b+1e3|0;g[o>>2]=m;o=b+1004|0;g[o>>2]=n;o=b+1008|0;g[o>>2]=p;o=b+1012|0;g[o>>2]=0.0;o=b+1032|0;g[o>>2]=r;o=b+828|0;d=b+844|0;e=b+860|0;r=+g[o>>2];p=+g[d>>2];n=+g[e>>2];r=r*q;p=p*s;p=r+p;n=n*t;n=p+n;e=b+1036|0;g[e>>2]=n;e=b+832|0;d=b+848|0;o=b+864|0;n=+g[e>>2];p=+g[d>>2];r=+g[o>>2];q=n*q;s=p*s;s=q+s;t=r*t;t=s+t;o=b+1040|0;g[o>>2]=t;i=f;return}function Qr(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0;e=i;if(a[b+48>>0]|0){c[d>>2]=0;c[d+4>>2]=0;i=e;return}c[d>>2]=4;c[d+4>>2]=2;Pr(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);g[b+1088>>2]=0.0;a[b+297>>0]=0;f=+g[b+192>>2];h=+g[b+196>>2];do if(f<=h){m=+g[b+892>>2];l=+g[b+908>>2];j=+g[b+924>>2];f=+Yp(+Y(+(+g[b+832>>2]*m+ +g[b+848>>2]*l+ +g[b+864>>2]*j),+(+g[b+828>>2]*m+ +g[b+844>>2]*l+ +g[b+860>>2]*j)),f,h);g[b+1084>>2]=f;h=+g[b+192>>2];if(f<h){g[b+1088>>2]=f-h;a[b+297>>0]=1;break}h=+g[b+196>>2];if(f>h){g[b+1088>>2]=f-h;a[b+297>>0]=1}}while(0);a[b+296>>0]=0;h=+g[b+1032>>2];g[b+1080>>2]=h;f=+g[b+184>>2];j=+g[b+188>>2];do if(f<=j){if(h>j){g[b+1032>>2]=h-j;a[b+296>>0]=1;k=14;break}if(h<f){g[b+1032>>2]=h-f;a[b+296>>0]=1;k=14}else k=13}else k=13;while(0);if((k|0)==13?(g[b+1032>>2]=0.0,(a[b+1096>>0]|0)!=0):0)k=14;if((k|0)==14){c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+ -1}if((a[b+297>>0]|0)==0?(a[b+1112>>0]|0)==0:0){i=e;return}c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+ -1;i=e;return}function Rr(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0;e=i;l=c[b+28>>2]|0;m=c[b+32>>2]|0;f=+g[l+344>>2];h=+g[m+344>>2];u=c[d+24>>2]|0;k=(a[b+180>>0]|0)!=0?1.0:-1.0;r=+g[b+936>>2]- +g[b+872>>2];s=+g[b+940>>2]- +g[b+876>>2];t=+g[b+944>>2]- +g[b+880>>2];if(f<1.1920928955078125e-7)o=1;else o=h<1.1920928955078125e-7;if(f+h>0.0)q=h/(f+h);else q=.5;p=1.0-q;I=+g[b+824>>2];D=+g[b+840>>2];z=+g[b+856>>2];M=+g[b+888>>2];O=+g[b+904>>2];B=+g[b+920>>2];G=(a[b+49>>0]|0)==0;do if(!G){C=q*I+p*M;L=q*D+p*O;J=q*z+p*B;E=1.0/+Q(+(C*C+L*L+J*J));if(+P(+(J*E))>.7071067690849304){T=1.0/+Q(+(J*E*J*E+L*E*L*E));f=C*E;h=L*E;j=J*E;y=0.0;A=-(J*E*T);F=L*E*T;K=(J*E*J*E+L*E*L*E)*T;S=-(C*E*L*E*T);T=C*E*-(J*E*T);break}else{T=1.0/+Q(+(C*E*C*E+L*E*L*E));f=C*E;h=L*E;j=J*E;y=-(L*E*T);A=C*E*T;F=0.0;K=-(J*E*C*E*T);S=J*E*-(L*E*T);T=(C*E*C*E+L*E*L*E)*T;break}}else{f=I;h=D;j=z;y=+g[b+828>>2];A=+g[b+844>>2];F=+g[b+860>>2];K=+g[b+832>>2];S=+g[b+848>>2];T=+g[b+864>>2]}while(0);w=c[d+12>>2]|0;g[w>>2]=y;g[w+4>>2]=A;g[w+8>>2]=F;g[w+(u<<2)>>2]=K;g[w+(u+1<<2)>>2]=S;g[w+(u+2<<2)>>2]=T;E=-y;x=c[d+20>>2]|0;g[x>>2]=E;L=-A;g[x+4>>2]=L;N=-F;g[x+8>>2]=N;C=-K;g[x+(u<<2)>>2]=C;R=-S;g[x+(u+1<<2)>>2]=R;J=-T;g[x+(u+2<<2)>>2]=J;v=c[b+300>>2]|0;U=+g[b+280>>2];if(!(v&128))U=U*+g[d+4>>2];_=U*+g[d>>2];$=c[d+28>>2]|0;g[$>>2]=_*((D*B-z*O)*y+(z*M-I*B)*A+(I*O-D*M)*F);g[$+(u<<2)>>2]=_*((D*B-z*O)*K+(z*M-I*B)*S+(I*O-D*M)*T);if(v&64){$=c[d+32>>2]|0;g[$>>2]=+g[b+292>>2];g[$+(u<<2)>>2]=+g[b+292>>2]}I=+g[l+52>>2];O=+g[l+56>>2];M=+g[l+60>>2];z=+g[m+52>>2];D=+g[m+56>>2];B=+g[m+60>>2];if(G){_=(D-O)*F-(B-M)*A;Z=(B-M)*y-(z-I)*F;Y=(z-I)*A-(D-O)*y;g[w+(u<<1<<2)>>2]=q*_;g[w+((u<<1|1)<<2)>>2]=q*Z;g[w+((u<<1)+2<<2)>>2]=q*Y;g[x+(u<<1<<2)>>2]=p*_;g[x+((u<<1|1)<<2)>>2]=p*Z;g[x+((u<<1)+2<<2)>>2]=p*Y;Y=(D-O)*T-(B-M)*S;Z=(B-M)*K-(z-I)*T;_=(z-I)*S-(D-O)*K;g[w+(u*3<<2)>>2]=q*Y;g[w+((u*3|0)+1<<2)>>2]=q*Z;g[w+((u*3|0)+2<<2)>>2]=q*_;g[x+(u*3<<2)>>2]=p*Y;g[x+((u*3|0)+1<<2)>>2]=p*Z;g[x+((u*3|0)+2<<2)>>2]=p*_;H=c[d+8>>2]|0;g[H+(u<<1<<2)>>2]=y;g[H+((u<<1|1)<<2)>>2]=A;g[H+((u<<1)+2<<2)>>2]=F;g[H+(u*3<<2)>>2]=K;g[H+((u*3|0)+1<<2)>>2]=S;g[H+((u*3|0)+2<<2)>>2]=T;G=c[d+16>>2]|0;g[G+(u<<1<<2)>>2]=E;g[G+((u<<1|1)<<2)>>2]=L;g[G+((u<<1)+2<<2)>>2]=N;g[G+(u*3<<2)>>2]=C;g[G+((u*3|0)+1<<2)>>2]=R;g[G+((u*3|0)+2<<2)>>2]=J;L=0.0;N=0.0;R=0.0;C=0.0;E=0.0;J=0.0;D=D-O;B=B-M;z=z-I}else{z=+g[b+936>>2]-z;C=+g[b+940>>2]-D;D=+g[b+944>>2]-B;E=f*z+h*C+j*D;B=f*E;J=h*E;E=j*E;Y=+g[b+872>>2]-I;Z=+g[b+876>>2]-O;_=+g[b+880>>2]-M;F=f*Y+h*Z+j*_;y=f*F;A=h*F;F=j*F;M=+g[b+1080>>2]- +g[b+1032>>2];I=y+f*M-B;O=A+h*M-J;M=F+j*M-E;R=Y-y+q*I;L=Z-A+q*O;N=_-F+q*M;y=q*(z-B)+p*(Y-y);A=q*(C-J)+p*(Z-A);F=q*(D-E)+p*(_-F);if(y*y+A*A+F*F>1.1920928955078125e-7){_=1.0/+Q(+(y*y+A*A+F*F));y=y*_;A=_*A;F=_*F}else{y=+g[b+828>>2];A=+g[b+844>>2];F=+g[b+860>>2]}K=h*F-j*A;S=j*y-f*F;T=f*A-h*y;g[w+(u<<1<<2)>>2]=L*F-N*A;g[w+((u<<1|1)<<2)>>2]=N*y-R*F;g[w+((u<<1)+2<<2)>>2]=R*A-L*y;$=c[d+20>>2]|0;g[$+(u<<1<<2)>>2]=-((C-J-p*O)*F-(D-E-p*M)*A);g[$+((u<<1|1)<<2)>>2]=-((D-E-p*M)*y-(z-B-p*I)*F);g[$+((u<<1)+2<<2)>>2]=-((z-B-p*I)*A-(C-J-p*O)*y);U=(C-J-p*O)*T-(D-E-p*M)*S;W=(D-E-p*M)*K-(z-B-p*I)*T;_=(z-B-p*I)*S-(C-J-p*O)*K;if(o?(a[b+297>>0]|0)!=0:0){U=p*U;W=p*W;_=p*_;Z=q*(L*T-N*S);X=q*(N*K-R*T);Y=q*(R*S-L*K)}else{Z=L*T-N*S;X=N*K-R*T;Y=R*S-L*K}x=c[d+12>>2]|0;g[x+(u*3<<2)>>2]=Z;g[x+((u*3|0)+1<<2)>>2]=X;g[x+((u*3|0)+2<<2)>>2]=Y;x=c[d+20>>2]|0;g[x+(u*3<<2)>>2]=-U;g[x+((u*3|0)+1<<2)>>2]=-W;g[x+((u*3|0)+2<<2)>>2]=-_;H=c[d+8>>2]|0;g[H+(u<<1<<2)>>2]=y;g[H+((u<<1|1)<<2)>>2]=A;g[H+((u<<1)+2<<2)>>2]=F;g[H+(u*3<<2)>>2]=K;g[H+((u*3|0)+1<<2)>>2]=S;g[H+((u*3|0)+2<<2)>>2]=T;G=c[d+16>>2]|0;g[G+(u<<1<<2)>>2]=-y;g[G+((u<<1|1)<<2)>>2]=-A;g[G+((u<<1)+2<<2)>>2]=-F;g[G+(u*3<<2)>>2]=-K;g[G+((u*3|0)+1<<2)>>2]=-S;g[G+((u*3|0)+2<<2)>>2]=-T;v=c[b+300>>2]|0;C=C-J-p*O;E=D-E-p*M;J=z-B-p*I;D=0.0;B=0.0;z=0.0}I=+g[b+264>>2];if(!(v&32))I=I*+g[d+4>>2];_=I*+g[d>>2];w=c[d+28>>2]|0;g[w+(u<<1<<2)>>2]=_*(r*y+s*A+t*F);g[w+(u*3<<2)>>2]=_*(r*K+s*S+t*T);if(v&16){$=c[d+32>>2]|0;g[$+(u<<1<<2)>>2]=+g[b+276>>2];g[$+(u*3<<2)>>2]=+g[b+276>>2]}if(!(a[b+296>>0]|0))if(!(a[b+1096>>0]|0))m=4;else{V=0;$=0;u=0;r=0.0;n=30}else{r=k*+g[b+1032>>2];V=1;$=(a[b+1096>>0]|0)==0;u=r>0.0?2:1;n=30}if((n|0)==30){n=c[d+24>>2]<<2;g[H+(n<<2)>>2]=f;g[H+((n|1)<<2)>>2]=h;g[H+((n|2)<<2)>>2]=j;g[G+(n<<2)>>2]=-f;g[G+((n|1)<<2)>>2]=-h;g[G+((n|2)<<2)>>2]=-j;if(a[b+49>>0]|0){if(!o){H=c[d+12>>2]|0;g[H+(n<<2)>>2]=j*L-h*N;g[H+((n|1)<<2)>>2]=f*N-j*R;g[H+((n|2)<<2)>>2]=h*R-f*L;g[x+(n<<2)>>2]=-(j*C-h*E);g[x+((n|1)<<2)>>2]=-(f*E-j*J);g[x+((n|2)<<2)>>2]=-(h*J-f*C)}}else{Y=j*D-h*B;Z=f*B-j*z;_=h*z-f*D;H=c[d+12>>2]|0;g[H+(n<<2)>>2]=q*Y;g[H+((n|1)<<2)>>2]=q*Z;g[H+((n|2)<<2)>>2]=q*_;g[x+(n<<2)>>2]=p*Y;g[x+((n|1)<<2)>>2]=p*Z;g[x+((n|2)<<2)>>2]=p*_}G=+g[b+184>>2]==+g[b+188>>2];g[w+(n<<2)>>2]=0.0;o=(c[d+36>>2]|0)+(n<<2)|0;g[o>>2]=0.0;H=(c[d+40>>2]|0)+(n<<2)|0;g[H>>2]=0.0;p=+g[((v&512|0)==0?d+4|0:b+232|0)>>2];if(!(V&G|$)){if(v&1)g[(c[d+32>>2]|0)+(n<<2)>>2]=+g[b+212>>2];q=+g[b+1100>>2];y=+g[b+1080>>2];z=+g[b+184>>2];t=+g[b+188>>2];s=p*+g[d>>2];a:do if(!(z>t))if(!(z==t)){if(q/s<0.0){do if(y>=z){if(!(z-q/s>y))break;s=(z-y)/(q/s);break a}while(0);s=y<z?0.0:1.0;break}if(q/s>0.0){do if(y<=t){if(!(t-q/s<y))break;s=(t-y)/(q/s);break a}while(0);s=y>t?0.0:1.0}else s=0.0}else s=0.0;else s=1.0;while(0);g[w+(n<<2)>>2]=+g[w+(n<<2)>>2]-k*s*q;g[o>>2]=+g[o>>2]- +g[b+1104>>2]*+g[d>>2];g[H>>2]=+g[b+1104>>2]*+g[d>>2]+ +g[H>>2]}if(V){g[w+(n<<2)>>2]=+g[w+(n<<2)>>2]+r*p*+g[d>>2];if(v&256)g[(c[d+32>>2]|0)+(n<<2)>>2]=+g[b+244>>2];do if(!G)if((u|0)==1){g[o>>2]=-3.4028234663852886e+38;g[H>>2]=0.0;break}else{g[o>>2]=0.0;g[H>>2]=3.4028234663852886e+38;break}else{g[o>>2]=-3.4028234663852886e+38;g[H>>2]=3.4028234663852886e+38}while(0);_=1.0- +g[b+240>>2];p=+P(+_);do if(!(_!=_|0.0!=0.0|_==0.0)){k=k*(f*+g[l+312>>2]+h*+g[l+316>>2]+j*+g[l+320>>2]-(f*+g[m+312>>2]+h*+g[m+316>>2]+j*+g[m+320>>2]));if((u|0)==1){if(!(k<0.0))break;if(!(+g[w+(n<<2)>>2]<-(p*k)))break;g[w+(n<<2)>>2]=-(p*k);break}else{if(!(k>0.0))break;if(!(+g[w+(n<<2)>>2]>-(p*k)))break;g[w+(n<<2)>>2]=-(p*k);break}}while(0);g[w+(n<<2)>>2]=+g[b+232>>2]*+g[w+(n<<2)>>2];m=5}else m=5}if(!(a[b+297>>0]|0))if(!(a[b+1112>>0]|0)){i=e;return}else{n=0;o=0;l=0;k=0.0}else{k=+g[b+1088>>2];n=1;o=(a[b+1112>>0]|0)==0;l=k>0.0?1:2}m=aa(c[d+24>>2]|0,m)|0;$=c[d+12>>2]|0;g[$+(m<<2)>>2]=f;g[$+(m+1<<2)>>2]=h;g[$+(m+2<<2)>>2]=j;g[x+(m<<2)>>2]=-f;g[x+(m+1<<2)>>2]=-h;g[x+(m+2<<2)>>2]=-j;p=+g[b+192>>2];q=+g[b+196>>2];r=+g[((v&2048|0)==0?d+4|0:b+248|0)>>2];if(!(n&p==q|o)){if(!(v&4)){y=q;A=p}else{g[(c[d+32>>2]|0)+(m<<2)>>2]=+g[b+228>>2];y=+g[b+196>>2];A=+g[b+192>>2]}z=+g[b+1084>>2];s=+g[b+1116>>2];t=r*+g[d>>2];b:do if(!(A>y))if(!(A==y)){if(s/t<0.0){do if(z>=A){if(!(A-s/t>z))break;t=(A-z)/(s/t);break b}while(0);t=z<A?0.0:1.0;break}if(s/t>0.0){do if(z<=y){if(!(y-s/t<z))break;t=(y-z)/(s/t);break b}while(0);t=z>y?0.0:1.0}else t=0.0}else t=0.0;else t=1.0;while(0);g[w+(m<<2)>>2]=t*s;g[(c[d+36>>2]|0)+(m<<2)>>2]=-(+g[b+1120>>2]*+g[d>>2]);g[(c[d+40>>2]|0)+(m<<2)>>2]=+g[b+1120>>2]*+g[d>>2]}if(!n){i=e;return}g[w+(m<<2)>>2]=+g[w+(m<<2)>>2]+k*r*+g[d>>2];if(v&1024)g[(c[d+32>>2]|0)+(m<<2)>>2]=+g[b+260>>2];do if(!(p==q)){n=(c[d+36>>2]|0)+(m<<2)|0;if((l|0)==1){g[n>>2]=0.0;g[(c[d+40>>2]|0)+(m<<2)>>2]=3.4028234663852886e+38;break}else{g[n>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(m<<2)>>2]=0.0;break}}else{g[(c[d+36>>2]|0)+(m<<2)>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(m<<2)>>2]=3.4028234663852886e+38}while(0);_=1.0- +g[b+256>>2];k=+P(+_);do if(!(_!=_|0.0!=0.0|_==0.0)){V=c[b+28>>2]|0;$=c[b+32>>2]|0;f=f*+g[V+328>>2]+h*+g[V+332>>2]+j*+g[V+336>>2]-(f*+g[$+328>>2]+h*+g[$+332>>2]+j*+g[$+336>>2]);if((l|0)==1){if(!(f<0.0))break;if(!(+g[w+(m<<2)>>2]<-(k*f)))break;g[w+(m<<2)>>2]=-(k*f);break}else{if(!(f>0.0))break;if(!(+g[w+(m<<2)>>2]>-(k*f)))break;g[w+(m<<2)>>2]=-(k*f);break}}while(0);g[w+(m<<2)>>2]=+g[b+248>>2]*+g[w+(m<<2)>>2];i=e;return}function Sr(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;f=i;if((b|0)==3){if((e|0)<1){g[a+212>>2]=d;c[a+300>>2]=c[a+300>>2]|1;i=f;return}if((e|0)!=3){i=f;return}g[a+228>>2]=d;c[a+300>>2]=c[a+300>>2]|4;i=f;return}else if((b|0)==4){if((e|0)<1){g[a+244>>2]=d;c[a+300>>2]=c[a+300>>2]|256;i=f;return}if((e|0)<3){g[a+276>>2]=d;c[a+300>>2]=c[a+300>>2]|16;i=f;return}if((e|0)==3){g[a+260>>2]=d;c[a+300>>2]=c[a+300>>2]|1024;i=f;return}if((e|0)>=6){i=f;return}g[a+292>>2]=d;c[a+300>>2]=c[a+300>>2]|64;i=f;return}else if((b|0)==2){if((e|0)<1){g[a+232>>2]=d;c[a+300>>2]=c[a+300>>2]|512;i=f;return}if((e|0)<3){g[a+264>>2]=d;c[a+300>>2]=c[a+300>>2]|32;i=f;return}if((e|0)==3){g[a+248>>2]=d;c[a+300>>2]=c[a+300>>2]|2048;i=f;return}if((e|0)>=6){i=f;return}g[a+280>>2]=d;c[a+300>>2]=c[a+300>>2]|128;i=f;return}else{i=f;return}}function Tr(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0;d=i;do if((b|0)==4){if((c|0)<1){e=+g[a+244>>2];break}if((c|0)<3){e=+g[a+276>>2];break}if((c|0)==3){e=+g[a+260>>2];break}if((c|0)<6)e=+g[a+292>>2];else e=3.4028234663852886e+38}else if((b|0)==3){if((c|0)<1){e=+g[a+212>>2];break}if((c|0)==3)e=+g[a+228>>2];else e=3.4028234663852886e+38}else if((b|0)==2){if((c|0)<1){e=+g[a+232>>2];break}if((c|0)<3){e=+g[a+264>>2];break}if((c|0)==3){e=+g[a+248>>2];break}if((c|0)<6)e=+g[a+280>>2];else e=3.4028234663852886e+38}else e=3.4028234663852886e+38;while(0);i=d;return+e}function Ur(a){a=a|0;return}function Vr(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Wr(a){a=a|0;return 204}function Xr(a,b,e){a=a|0;b=b|0;e=e|0;var f=0;f=i;Zr(a,b,e)|0;g[b+52>>2]=+g[a+52>>2];g[b+56>>2]=+g[a+56>>2];g[b+60>>2]=+g[a+60>>2];g[b+64>>2]=+g[a+64>>2];g[b+68>>2]=+g[a+68>>2];g[b+72>>2]=+g[a+72>>2];g[b+76>>2]=+g[a+76>>2];g[b+80>>2]=+g[a+80>>2];g[b+84>>2]=+g[a+84>>2];g[b+88>>2]=+g[a+88>>2];g[b+92>>2]=+g[a+92>>2];g[b+96>>2]=+g[a+96>>2];g[b+100>>2]=+g[a+100>>2];g[b+104>>2]=+g[a+104>>2];g[b+108>>2]=+g[a+108>>2];g[b+112>>2]=+g[a+112>>2];g[b+116>>2]=+g[a+116>>2];g[b+120>>2]=+g[a+120>>2];g[b+124>>2]=+g[a+124>>2];g[b+128>>2]=+g[a+128>>2];g[b+132>>2]=+g[a+132>>2];g[b+136>>2]=+g[a+136>>2];g[b+140>>2]=+g[a+140>>2];g[b+144>>2]=+g[a+144>>2];g[b+148>>2]=+g[a+148>>2];g[b+152>>2]=+g[a+152>>2];g[b+156>>2]=+g[a+156>>2];g[b+160>>2]=+g[a+160>>2];g[b+164>>2]=+g[a+164>>2];g[b+168>>2]=+g[a+168>>2];g[b+172>>2]=+g[a+172>>2];g[b+176>>2]=+g[a+176>>2];g[b+180>>2]=+g[a+188>>2];g[b+184>>2]=+g[a+184>>2];g[b+188>>2]=+g[a+196>>2];g[b+192>>2]=+g[a+192>>2];c[b+196>>2]=d[a+180>>0];c[b+200>>2]=d[a+49>>0];i=f;return 4352}function Yr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+32|0;c[b+4>>2]=d;c[b>>2]=64;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3.4028234663852886e+38;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=e;if((a[5024]|0)==0?(Ya(5024)|0)!=0:0){c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;lr(4408,0.0,0,0,f+16|0);bb(5024)}c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;mr(4408,0.0,f);c[b+32>>2]=4408;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;i=f;return}function Zr(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,h=0,j=0;f=i;c[b>>2]=gc[c[(c[e>>2]|0)+28>>2]&31](e,c[a+28>>2]|0)|0;c[b+4>>2]=gc[c[(c[e>>2]|0)+28>>2]&31](e,c[a+32>>2]|0)|0;h=gc[c[(c[e>>2]|0)+40>>2]&31](e,a)|0;j=gc[c[(c[e>>2]|0)+28>>2]&31](e,h)|0;c[b+8>>2]=j;if(j)Nb[c[(c[e>>2]|0)+48>>2]&127](e,h);c[b+12>>2]=c[a+4>>2];c[b+24>>2]=d[a+21>>0];c[b+40>>2]=c[a+24>>2];g[b+44>>2]=+g[a+16>>2];c[b+48>>2]=d[a+20>>0];c[b+20>>2]=c[a+12>>2];c[b+16>>2]=c[a+8>>2];g[b+28>>2]=+g[a+36>>2];g[b+32>>2]=+g[a+40>>2];c[b+36>>2]=0;h=c[a+28>>2]|0;if((c[h+488>>2]|0)>0){e=0;do{if((c[(c[h+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;h=c[a+28>>2]|0}e=e+1|0}while((e|0)<(c[h+488>>2]|0))}h=c[a+32>>2]|0;if((c[h+488>>2]|0)>0)e=0;else{i=f;return 4376}do{if((c[(c[h+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;h=c[a+32>>2]|0}e=e+1|0}while((e|0)<(c[h+488>>2]|0));i=f;return 4376}function _r(d,f,h,j,k,l){d=d|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0.0,p=0.0,q=0.0;m=i;c[d>>2]=5216;b[d+4>>1]=-2;b[d+6>>1]=-1;c[d+92>>2]=k;c[d+96>>2]=0;a[d+100>>0]=0;c[d+104>>2]=0;c[d+108>>2]=0;if(!k){c[5004]=(c[5004]|0)+1;k=fF(95)|0;if((k|0)!=0?(c[(k+19&-16)+ -4>>2]=k,(k+19&-16|0)!=0):0){Yz(k+19&-16);k=k+19&-16}else k=0;c[d+92>>2]=k;a[d+100>>0]=1}if(!l){c[5004]=(c[5004]|0)+1;l=fF(43)|0;if((l|0)!=0?(n=l+19&-16,c[n+ -4>>2]=l,(l+19&-16|0)!=0):0){c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[(l+19&-16)>>2]=5280;a[n+20>>0]=1;c[n+16>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;n=l+19&-16}else n=0;c[d+112>>2]=n;c[5004]=(c[5004]|0)+1;n=fF(215)|0;if((n|0)!=0?(c[(n+19&-16)+ -4>>2]=n,(n+19&-16|0)!=0):0){Zx(n+19&-16,c[d+112>>2]|0);n=n+19&-16}else n=0;c[d+108>>2]=n;a[n+193>>0]=1}c[d+8>>2]=c[f+0>>2];c[d+12>>2]=c[f+4>>2];c[d+16>>2]=c[f+8>>2];c[d+20>>2]=c[f+12>>2];c[d+24>>2]=c[h+0>>2];c[d+28>>2]=c[h+4>>2];c[d+32>>2]=c[h+8>>2];c[d+36>>2]=c[h+12>>2];q=+(e[d+6>>1]|0);p=q/(+g[d+28>>2]- +g[d+12>>2]);o=q/(+g[d+32>>2]- +g[d+16>>2]);g[d+40>>2]=q/(+g[d+24>>2]- +g[d+8>>2]);g[d+44>>2]=p;g[d+48>>2]=o;g[d+52>>2]=0.0;f=(j&65535)+1&65535;c[5004]=(c[5004]|0)+1;h=fF(f<<6|19)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}if(f){n=h+(f<<6)|0;l=h;do{c[l>>2]=0;c[l+8>>2]=0;l=l+64|0}while((l|0)!=(n|0))}c[d+60>>2]=h;b[d+58>>1]=(j&65535)+1;b[d+56>>1]=0;b[d+64>>1]=1;if(f>>>0>1){j=1;n=1;do{b[h+(j<<6)+48>>1]=j+1;n=n+1<<16>>16;j=n&65535}while(j>>>0<f>>>0)}b[h+(f+ -1<<6)+48>>1]=0;c[5004]=(c[5004]|0)+1;j=fF((f<<3|3)+16|0)|0;if(j){c[(j+19&-16)+ -4>>2]=j;c[d+80>>2]=j+19&-16;if(!(j+19&-16))j=0;else j=j+19&-16}else{c[d+80>>2]=0;j=0}c[d+68>>2]=j;c[5004]=(c[5004]|0)+1;j=fF((f<<3|3)+16|0)|0;if(j){c[(j+19&-16)+ -4>>2]=j;c[d+84>>2]=j+19&-16;if(!(j+19&-16))j=0;else j=j+19&-16}else{c[d+84>>2]=0;j=0}c[d+72>>2]=j;c[5004]=(c[5004]|0)+1;j=fF((f<<3|3)+16|0)|0;if(j){c[(j+19&-16)+ -4>>2]=j;c[d+88>>2]=j+19&-16;if(!(j+19&-16))j=0;else j=j+19&-16}else{c[d+88>>2]=0;j=0}c[d+76>>2]=j;c[c[d+60>>2]>>2]=0;k=c[d+60>>2]|0;b[k+48>>1]=0;b[k+54>>1]=1;l=c[d+68>>2]|0;b[l>>1]=0;b[l+2>>1]=0;b[l+4>>1]=b[d+6>>1]|0;b[l+6>>1]=0;b[k+50>>1]=0;b[k+56>>1]=1;l=c[d+72>>2]|0;b[l>>1]=0;b[l+2>>1]=0;b[l+4>>1]=b[d+6>>1]|0;b[l+6>>1]=0;b[k+52>>1]=0;b[k+58>>1]=1;k=c[d+76>>2]|0;b[k>>1]=0;b[k+2>>1]=0;b[k+4>>1]=b[d+6>>1]|0;b[k+6>>1]=0;c[d>>2]=5040;i=m;return}function $r(a){a=a|0;var b=0;b=i;ss(a);i=b;return}function as(a){a=a|0;var b=0;b=i;ss(a);if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function bs(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;o=i;i=i+16|0;ps(a,o+6|0,+g[d>>2],+g[d+4>>2],+g[d+8>>2],0);ps(a,o,+g[f>>2],+g[f+4>>2],+g[f+8>>2],1);p=b[a+64>>1]|0;q=c[a+60>>2]|0;b[a+64>>1]=b[q+((p&65535)<<6)+48>>1]|0;b[a+56>>1]=(b[a+56>>1]|0)+1<<16>>16;c[q+((p&65535)<<6)+12>>2]=p&65535;c[q+((p&65535)<<6)>>2]=j;b[q+((p&65535)<<6)+4>>1]=k;b[q+((p&65535)<<6)+6>>1]=l;c[q+((p&65535)<<6)+8>>2]=n;u=(e[a+56>>1]|0)<<1;v=(u&65534)+ -1|0;s=(c[a+60>>2]|0)+54|0;b[s>>1]=(e[s>>1]|0)+2;s=c[a+68>>2]|0;r=e[s+(v<<2)>>1]|e[s+(v<<2)+2>>1]<<16;b[s+((u&65534|1)<<2)>>1]=r;b[s+((u&65534|1)<<2)+2>>1]=r>>>16;s=c[a+68>>2]|0;b[s+(v<<2)>>1]=b[o+6>>1]|0;b[s+(v<<2)+2>>1]=p;b[s+((u&65534)<<2)>>1]=b[o>>1]|0;b[s+((u&65534)<<2)+2>>1]=p;b[q+((p&65535)<<6)+48>>1]=v;b[q+((p&65535)<<6)+54>>1]=u;s=(c[a+60>>2]|0)+56|0;b[s>>1]=(e[s>>1]|0)+2;s=c[a+72>>2]|0;r=e[s+(v<<2)>>1]|e[s+(v<<2)+2>>1]<<16;b[s+((u&65534|1)<<2)>>1]=r;b[s+((u&65534|1)<<2)+2>>1]=r>>>16;s=c[a+72>>2]|0;b[s+(v<<2)>>1]=b[o+8>>1]|0;b[s+(v<<2)+2>>1]=p;b[s+((u&65534)<<2)>>1]=b[o+2>>1]|0;b[s+((u&65534)<<2)+2>>1]=p;b[q+((p&65535)<<6)+50>>1]=v;b[q+((p&65535)<<6)+56>>1]=u;s=(c[a+60>>2]|0)+58|0;b[s>>1]=(e[s>>1]|0)+2;s=c[a+76>>2]|0;r=e[s+(v<<2)>>1]|e[s+(v<<2)+2>>1]<<16;b[s+((u&65534|1)<<2)>>1]=r;b[s+((u&65534|1)<<2)+2>>1]=r>>>16;s=c[a+76>>2]|0;b[s+(v<<2)>>1]=b[o+10>>1]|0;b[s+(v<<2)+2>>1]=p;b[s+((u&65534)<<2)>>1]=b[o+4>>1]|0;b[s+((u&65534)<<2)+2>>1]=p;b[q+((p&65535)<<6)+52>>1]=v;b[q+((p&65535)<<6)+58>>1]=u;u=c[a+68>>2]|0;v=e[q+((p&65535)<<6)+48>>1]|0;s=c[a+60>>2]|0;r=b[u+(v+ -1<<2)>>1]|0;if((e[u+(v<<2)>>1]|0)<(r&65535)){n=s+((e[u+(v<<2)+2>>1]|0)<<6)+48|0;t=u+(v<<2)|0;u=u+(v+ -1<<2)|0;while(1){v=e[u+2>>1]|0;if(!(r&1)){v=s+(v<<6)+48|0;b[v>>1]=(b[v>>1]|0)+1<<16>>16}else{v=s+(v<<6)+54|0;b[v>>1]=(b[v>>1]|0)+1<<16>>16}b[n>>1]=(b[n>>1]|0)+ -1<<16>>16;r=e[t>>1]|e[t+2>>1]<<16;v=e[u>>1]|e[u+2>>1]<<16;b[t>>1]=v;b[t+2>>1]=v>>>16;b[u>>1]=r;b[u+2>>1]=r>>>16;t=t+ -4|0;u=u+ -4|0;r=b[u>>1]|0;if((e[t>>1]|0)>=(r&65535))break;s=c[a+60>>2]|0}n=c[a+68>>2]|0}else n=u;r=e[q+((p&65535)<<6)+54>>1]|0;u=n+(r<<2)|0;t=n+(r+ -1<<2)|0;s=b[t>>1]|0;a:do if((e[u>>1]|0)<(s&65535)){v=c[a+60>>2]|0;n=v+((e[n+(r<<2)+2>>1]|0)<<6)+54|0;r=v;while(1){v=e[t+2>>1]|0;if(!(s&1)){v=r+(v<<6)+48|0;b[v>>1]=(b[v>>1]|0)+1<<16>>16}else{v=r+(v<<6)+54|0;b[v>>1]=(b[v>>1]|0)+1<<16>>16}b[n>>1]=(b[n>>1]|0)+ -1<<16>>16;s=e[u>>1]|e[u+2>>1]<<16;v=e[t>>1]|e[t+2>>1]<<16;b[u>>1]=v;b[u+2>>1]=v>>>16;b[t>>1]=s;b[t+2>>1]=s>>>16;u=u+ -4|0;t=t+ -4|0;s=b[t>>1]|0;if((e[u>>1]|0)>=(s&65535))break a;r=c[a+60>>2]|0}}while(0);v=c[a+72>>2]|0;u=e[q+((p&65535)<<6)+50>>1]|0;s=c[a+60>>2]|0;r=b[v+(u+ -1<<2)>>1]|0;if((e[v+(u<<2)>>1]|0)<(r&65535)){n=s+((e[v+(u<<2)+2>>1]|0)<<6)+50|0;t=v+(u<<2)|0;u=v+(u+ -1<<2)|0;while(1){v=e[u+2>>1]|0;if(!(r&1)){v=s+(v<<6)+50|0;b[v>>1]=(b[v>>1]|0)+1<<16>>16}else{v=s+(v<<6)+56|0;b[v>>1]=(b[v>>1]|0)+1<<16>>16}b[n>>1]=(b[n>>1]|0)+ -1<<16>>16;r=e[t>>1]|e[t+2>>1]<<16;v=e[u>>1]|e[u+2>>1]<<16;b[t>>1]=v;b[t+2>>1]=v>>>16;b[u>>1]=r;b[u+2>>1]=r>>>16;t=t+ -4|0;u=u+ -4|0;r=b[u>>1]|0;if((e[t>>1]|0)>=(r&65535))break;s=c[a+60>>2]|0}v=c[a+72>>2]|0}n=e[q+((p&65535)<<6)+56>>1]|0;u=v+(n<<2)|0;t=v+(n+ -1<<2)|0;r=b[t>>1]|0;b:do if((e[u>>1]|0)<(r&65535)){s=c[a+60>>2]|0;n=s+((e[v+(n<<2)+2>>1]|0)<<6)+56|0;while(1){v=e[t+2>>1]|0;if(!(r&1)){v=s+(v<<6)+50|0;b[v>>1]=(b[v>>1]|0)+1<<16>>16}else{v=s+(v<<6)+56|0;b[v>>1]=(b[v>>1]|0)+1<<16>>16}b[n>>1]=(b[n>>1]|0)+ -1<<16>>16;r=e[u>>1]|e[u+2>>1]<<16;v=e[t>>1]|e[t+2>>1]<<16;b[u>>1]=v;b[u+2>>1]=v>>>16;b[t>>1]=r;b[t+2>>1]=r>>>16;u=u+ -4|0;t=t+ -4|0;r=b[t>>1]|0;if((e[u>>1]|0)>=(r&65535))break b;s=c[a+60>>2]|0}}while(0);qs(a,2,b[q+((p&65535)<<6)+52>>1]|0);rs(a,2,b[q+((p&65535)<<6)+58>>1]|0,m);q=c[a+60>>2]|0;a=c[a+108>>2]|0;if(!a){v=q+((p&65535)<<6)|0;i=o;return v|0}c[q+((p&65535)<<6)+60>>2]=pc[c[(c[a>>2]|0)+8>>2]&3](a,d,f,h,j,k,l,m,0)|0;v=q+((p&65535)<<6)|0;i=o;return v|0}function cs(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;g=i;h=c[a+108>>2]|0;if(h)rc[c[(c[h>>2]|0)+12>>2]&127](h,c[d+60>>2]|0,f);h=c[d+12>>2]|0;d=c[a+60>>2]|0;r=c[a+92>>2]|0;if(!(Pb[c[(c[r>>2]|0)+56>>2]&127](r)|0)){r=c[a+92>>2]|0;rc[c[(c[r>>2]|0)+16>>2]&127](r,d+((h&65535)<<6)|0,f)}f=e[a+56>>1]|0;j=c[a+60>>2]|0;b[j+54>>1]=(e[j+54>>1]|0)+65534;b[j+56>>1]=(e[j+56>>1]|0)+65534;b[j+58>>1]=(e[j+58>>1]|0)+65534;j=0;do{l=a+(j<<2)+68|0;k=c[l>>2]|0;o=e[d+((h&65535)<<6)+(j<<1)+54>>1]|0;b[k+(o<<2)>>1]=b[a+6>>1]|0;p=b[k+(o+1<<2)+2>>1]|0;if(!(p<<16>>16))o=k;else{m=(c[a+60>>2]|0)+((e[k+(o<<2)+2>>1]|0)<<6)+(j<<1)+54|0;n=k+(o<<2)|0;o=k+(o+1<<2)|0;while(1){r=b[o>>1]|0;if((e[n>>1]|0)<(r&65535))break;q=c[a+60>>2]|0;p=p&65535;if(!(r&1)){r=q+(p<<6)+(j<<1)+48|0;b[r>>1]=(b[r>>1]|0)+ -1<<16>>16}else{r=q+(p<<6)+(j<<1)+54|0;b[r>>1]=(b[r>>1]|0)+ -1<<16>>16}b[m>>1]=(b[m>>1]|0)+1<<16>>16;p=e[n>>1]|e[n+2>>1]<<16;r=e[o>>1]|e[o+2>>1]<<16;b[n>>1]=r;b[n+2>>1]=r>>>16;b[o>>1]=p;b[o+2>>1]=p>>>16;p=b[o+6>>1]|0;if(!(p<<16>>16))break;else{n=n+4|0;o=o+4|0}}o=c[l>>2]|0}p=e[d+((h&65535)<<6)+(j<<1)+48>>1]|0;b[k+(p<<2)>>1]=b[a+6>>1]|0;n=b[o+(p+1<<2)+2>>1]|0;a:do if(n<<16>>16){l=(c[a+60>>2]|0)+((e[o+(p<<2)+2>>1]|0)<<6)+(j<<1)+48|0;m=o+(p<<2)|0;o=o+(p+1<<2)|0;while(1){p=b[o>>1]|0;if((e[m>>1]|0)<(p&65535))break a;q=c[a+60>>2]|0;n=n&65535;if(!(p&1)){r=q+(n<<6)+(j<<1)+48|0;b[r>>1]=(b[r>>1]|0)+ -1<<16>>16}else{r=q+(n<<6)+(j<<1)+54|0;b[r>>1]=(b[r>>1]|0)+ -1<<16>>16}b[l>>1]=(b[l>>1]|0)+1<<16>>16;n=e[m>>1]|e[m+2>>1]<<16;r=e[o>>1]|e[o+2>>1]<<16;b[m>>1]=r;b[m+2>>1]=r>>>16;b[o>>1]=n;b[o+2>>1]=n>>>16;n=b[o+6>>1]|0;if(!(n<<16>>16))break;else{m=m+4|0;o=o+4|0}}}while(0);b[k+((f<<1)+ -1<<2)+2>>1]=0;b[k+((f<<1)+ -1<<2)>>1]=b[a+6>>1]|0;j=j+1|0}while((j|0)!=3);b[(c[a+60>>2]|0)+((h&65535)<<6)+48>>1]=b[a+64>>1]|0;b[a+64>>1]=h;b[a+56>>1]=(b[a+56>>1]|0)+ -1<<16>>16;i=g;return}function ds(a,d,f,h,j){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;k=i;i=i+16|0;c[d+16>>2]=c[f+0>>2];c[d+20>>2]=c[f+4>>2];c[d+24>>2]=c[f+8>>2];c[d+28>>2]=c[f+12>>2];c[d+32>>2]=c[h+0>>2];c[d+36>>2]=c[h+4>>2];c[d+40>>2]=c[h+8>>2];c[d+44>>2]=c[h+12>>2];q=c[a+60>>2]|0;r=c[d+12>>2]&65535;ps(a,k+6|0,+g[f>>2],+g[f+4>>2],+g[f+8>>2],0);ps(a,k,+g[h>>2],+g[h+4>>2],+g[h+8>>2],1);y=0;do{z=b[q+(r<<6)+(y<<1)+48>>1]|0;w=b[q+(r<<6)+(y<<1)+54>>1]|0;F=b[k+6+(y<<1)>>1]|0;A=a+(y<<2)+68|0;I=c[A>>2]|0;H=(F&65535)-(e[I+((z&65535)<<2)>>1]|0)|0;G=b[k+(y<<1)>>1]|0;x=(G&65535)-(e[I+((w&65535)<<2)>>1]|0)|0;b[I+((z&65535)<<2)>>1]=F;b[I+((w&65535)<<2)>>1]=G;if((H|0)<0)qs(a,y,z);a:do if((x|0)>0?(v=c[A>>2]|0,s=c[a+60>>2]|0,t=e[v+((w&65535)<<2)+2>>1]|0,u=b[v+((w&65535)+1<<2)+2>>1]|0,u<<16>>16!=0):0){B=1<<y&3;C=s+(t<<6)+(y<<1)+54|0;I=u;D=v+((w&65535)<<2)|0;E=v+((w&65535)+1<<2)|0;while(1){F=b[E>>1]|0;if((e[D>>1]|0)<(F&65535))break a;G=c[a+60>>2]|0;I=I&65535;if(!(F&1)){if(((((e[s+(t<<6)+(B<<1)+54>>1]|0)>=(e[G+(I<<6)+(B<<1)+48>>1]|0)?(e[G+(I<<6)+(B<<1)+54>>1]|0)>=(e[s+(t<<6)+(B<<1)+48>>1]|0):0)?(e[s+(t<<6)+((1<<B&3)<<1)+54>>1]|0)>=(e[G+(I<<6)+((1<<B&3)<<1)+48>>1]|0):0)?(e[G+(I<<6)+((1<<B&3)<<1)+54>>1]|0)>=(e[s+(t<<6)+((1<<B&3)<<1)+48>>1]|0):0)?(m=c[a+92>>2]|0,n=G+((e[D+2>>1]|0)<<6)|0,Yb[c[(c[m>>2]|0)+8>>2]&31](m,n,G+(I<<6)|0)|0,m=c[a+96>>2]|0,(m|0)!=0):0)Yb[c[(c[m>>2]|0)+8>>2]&31](m,n,G+(I<<6)|0)|0;I=G+(I<<6)+(y<<1)+48|0;b[I>>1]=(b[I>>1]|0)+ -1<<16>>16}else{I=G+(I<<6)+(y<<1)+54|0;b[I>>1]=(b[I>>1]|0)+ -1<<16>>16}b[C>>1]=(b[C>>1]|0)+1<<16>>16;I=e[D>>1]|e[D+2>>1]<<16;G=e[E>>1]|e[E+2>>1]<<16;b[D>>1]=G;b[D+2>>1]=G>>>16;b[E>>1]=I;b[E+2>>1]=I>>>16;I=b[E+6>>1]|0;if(!(I<<16>>16))break;else{D=D+4|0;E=E+4|0}}}while(0);b:do if((H|0)>0?(o=c[A>>2]|0,p=b[o+((z&65535)+1<<2)+2>>1]|0,p<<16>>16!=0):0){B=(c[a+60>>2]|0)+((e[o+((z&65535)<<2)+2>>1]|0)<<6)+(y<<1)+48|0;C=1<<y&3;E=p;A=o+((z&65535)<<2)|0;z=o+((z&65535)+1<<2)|0;while(1){F=b[z>>1]|0;if((e[A>>1]|0)<(F&65535))break b;D=c[a+60>>2]|0;E=E&65535;if(!(F&1)){I=D+(E<<6)+(y<<1)+48|0;b[I>>1]=(b[I>>1]|0)+ -1<<16>>16}else{F=e[A+2>>1]|0;if(((((e[D+(F<<6)+(C<<1)+54>>1]|0)>=(e[D+(E<<6)+(C<<1)+48>>1]|0)?(e[D+(E<<6)+(C<<1)+54>>1]|0)>=(e[D+(F<<6)+(C<<1)+48>>1]|0):0)?(e[D+(F<<6)+((1<<C&3)<<1)+54>>1]|0)>=(e[D+(E<<6)+((1<<C&3)<<1)+48>>1]|0):0)?(e[D+(E<<6)+((1<<C&3)<<1)+54>>1]|0)>=(e[D+(F<<6)+((1<<C&3)<<1)+48>>1]|0):0)?(l=c[a+92>>2]|0,Tb[c[(c[l>>2]|0)+12>>2]&31](l,D+(F<<6)|0,D+(E<<6)|0,j)|0,l=c[a+96>>2]|0,(l|0)!=0):0)Tb[c[(c[l>>2]|0)+12>>2]&31](l,D+(F<<6)|0,D+(E<<6)|0,j)|0;I=D+(E<<6)+(y<<1)+54|0;b[I>>1]=(b[I>>1]|0)+ -1<<16>>16}b[B>>1]=(b[B>>1]|0)+1<<16>>16;E=e[A>>1]|e[A+2>>1]<<16;I=e[z>>1]|e[z+2>>1]<<16;b[A>>1]=I;b[A+2>>1]=I>>>16;b[z>>1]=E;b[z+2>>1]=E>>>16;E=b[z+6>>1]|0;if(!(E<<16>>16))break;else{A=A+4|0;z=z+4|0}}}while(0);if((x|0)<0)rs(a,y,w,j);y=y+1|0}while((y|0)!=3);l=c[a+108>>2]|0;if(!l){i=k;return}Jb[c[(c[l>>2]|0)+16>>2]&31](l,c[d+60>>2]|0,f,h,j);i=k;return}function es(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=i;c[d+0>>2]=c[b+16>>2];c[d+4>>2]=c[b+20>>2];c[d+8>>2]=c[b+24>>2];c[d+12>>2]=c[b+28>>2];c[e+0>>2]=c[b+32>>2];c[e+4>>2]=c[b+36>>2];c[e+8>>2]=c[b+40>>2];c[e+12>>2]=c[b+44>>2];i=a;return}function fs(a,d,f,g,h,j){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0;k=i;l=c[a+108>>2]|0;if(l){Zb[c[(c[l>>2]|0)+24>>2]&7](l,d,f,g,h,j);i=k;return}l=b[a+56>>1]|0;if((l&65535)<<1>>>0<=1){i=k;return}h=1;j=2;while(1){f=c[a+68>>2]|0;if(b[f+(h<<2)>>1]&1){gc[c[(c[g>>2]|0)+8>>2]&31](g,(c[a+60>>2]|0)+((e[f+(h<<2)+2>>1]|0)<<6)|0)|0;l=b[a+56>>1]|0}h=j&65535;if(h>>>0>=((l&65535)<<1|1)>>>0)break;j=j+1<<16>>16}i=k;return}function gs(a,d,f,h){a=a|0;d=d|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0;j=i;k=c[a+108>>2]|0;if(k){vc[c[(c[k>>2]|0)+28>>2]&127](k,d,f,h);i=j;return}m=b[a+56>>1]|0;if((m&65535)<<1>>>0<=1){i=j;return}n=1;k=2;while(1){o=c[a+68>>2]|0;if(b[o+(n<<2)>>1]&1){l=c[a+60>>2]|0;n=e[o+(n<<2)+2>>1]|0;if(!(+g[d>>2]>+g[l+(n<<6)+32>>2])?!(+g[f>>2]<+g[l+(n<<6)+16>>2]):0)o=1;else o=0;if(!(!(+g[d+8>>2]>+g[l+(n<<6)+40>>2])?!(+g[f+8>>2]<+g[l+(n<<6)+24>>2]):0))o=0;if(!(+g[d+4>>2]>+g[l+(n<<6)+36>>2])?!(+g[f+4>>2]<+g[l+(n<<6)+20>>2]|o^1):0){gc[c[(c[h>>2]|0)+8>>2]&31](h,l+(n<<6)|0)|0;m=b[a+56>>1]|0}}n=k&65535;if(n>>>0>=((m&65535)<<1|1)>>>0)break;k=k+1<<16>>16}i=j;return}function hs(a,b){a=a|0;b=b|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=i;i=i+32|0;r=c[a+92>>2]|0;if(!(Pb[c[(c[r>>2]|0)+56>>2]&127](r)|0)){i=f;return}d=c[a+92>>2]|0;d=Pb[c[(c[d>>2]|0)+28>>2]&127](d)|0;g=c[d+4>>2]|0;if((g|0)>1){os(d,0,g+ -1|0);g=c[d+4>>2]|0}o=g-(c[a+104>>2]|0)|0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;ns(d,o,f+16|0);c[a+104>>2]=0;o=c[d+4>>2]|0;if((o|0)>0){h=0;p=0;m=0;g=0;while(1){j=c[d+12>>2]|0;k=j+(g<<4)|0;n=c[k>>2]|0;j=j+(g<<4)+4|0;l=c[j>>2]|0;if((n|0)==(h|0))if((l|0)==(p|0)){l=p;n=h;h=12}else{n=h;h=8}else h=8;a:do if((h|0)==8){h=0;q=n+54|0;r=n+48|0;p=0;do{if((e[q+(p<<1)>>1]|0)<(e[l+48+(p<<1)>>1]|0)){h=12;break a}if((e[l+54+(p<<1)>>1]|0)<(e[r+(p<<1)>>1]|0)){h=12;break a}p=p+1|0}while((p|0)<3)}while(0);if((h|0)==12){m=c[a+92>>2]|0;rc[c[(c[m>>2]|0)+32>>2]&127](m,k,b);c[k>>2]=0;c[j>>2]=0;m=(c[a+104>>2]|0)+1|0;c[a+104>>2]=m;c[3808]=(c[3808]|0)+ -1;o=c[d+4>>2]|0}g=g+1|0;if((g|0)>=(o|0))break;else{h=n;p=l}}if((o|0)>1){os(d,0,o+ -1|0);m=c[a+104>>2]|0;o=c[d+4>>2]|0}}else m=0;r=o-m|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;ns(d,r,f);c[a+104>>2]=0;i=f;return}function is(a){a=a|0;return c[a+92>>2]|0}function js(a){a=a|0;return c[a+92>>2]|0}function ks(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[b+0>>2]=c[a+8>>2];c[b+4>>2]=c[a+12>>2];c[b+8>>2]=c[a+16>>2];c[b+12>>2]=c[a+20>>2];c[d+0>>2]=c[a+24>>2];c[d+4>>2]=c[a+28>>2];c[d+8>>2]=c[a+32>>2];c[d+12>>2]=c[a+36>>2];i=e;return}function ls(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;d=i;if(b[a+56>>1]|0){i=d;return}b[a+64>>1]=1;f=b[a+58>>1]|0;e=c[a+60>>2]|0;if((f&65535)>1){f=1;g=1;while(1){b[e+(f<<6)+48>>1]=f+1;g=g+1<<16>>16;f=b[a+58>>1]|0;if((g&65535)<(f&65535))f=g&65535;else break}}b[e+((f&65535)+ -1<<6)+48>>1]=0;i=d;return}function ms(a){a=a|0;return}function ns(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;g=c[b+4>>2]|0;if(!((g|0)<=(d|0)&(g|0)<(d|0))){c[b+4>>2]=d;i=f;return}if((c[b+8>>2]|0)<(d|0)){if(!d){h=0;j=g}else{c[5004]=(c[5004]|0)+1;h=fF((d<<4|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}j=c[b+4>>2]|0}if((j|0)>0){k=0;do{l=c[b+12>>2]|0;c[h+(k<<4)>>2]=c[l+(k<<4)>>2];c[h+(k<<4)+4>>2]=c[l+(k<<4)+4>>2];c[h+(k<<4)+8>>2]=c[l+(k<<4)+8>>2];c[h+(k<<4)+12>>2]=c[l+(k<<4)+12>>2];k=k+1|0}while((k|0)!=(j|0))}j=c[b+12>>2]|0;if(j){if(a[b+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=h;c[b+8>>2]=d;h=b+12|0}else h=b+12|0;do{l=c[h>>2]|0;c[l+(g<<4)>>2]=c[e>>2];c[l+(g<<4)+4>>2]=c[e+4>>2];c[l+(g<<4)+8>>2]=c[e+8>>2];c[l+(g<<4)+12>>2]=c[e+12>>2];g=g+1|0}while((g|0)!=(d|0));c[b+4>>2]=d;i=f;return}function os(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;e=i;while(1){j=(b+d|0)/2|0;g=c[a+12>>2]|0;h=c[g+(j<<4)>>2]|0;f=c[g+(j<<4)+4>>2]|0;j=c[g+(j<<4)+8>>2]|0;k=b;o=d;while(1){a:while(1){m=c[g+(k<<4)>>2]|0;if(!m)q=-1;else q=c[m+12>>2]|0;if(!h)n=-1;else n=c[h+12>>2]|0;l=c[g+(k<<4)+4>>2]|0;if(!l)r=-1;else r=c[l+12>>2]|0;if(!f)p=-1;else p=c[f+12>>2]|0;do if((q|0)<=(n|0)){n=(m|0)==(h|0)&(r|0)>(p|0);if(n|(m|0)==(h|0)^1)if(n)break;else break a;if((l|0)!=(f|0))break a;if((c[g+(k<<4)+8>>2]|0)>>>0<=j>>>0)break a}while(0);k=k+1|0}b:do if(!h)while(1){p=c[g+(o<<4)>>2]|0;if(!p)r=-1;else r=c[p+12>>2]|0;if(!f)s=-1;else s=c[f+12>>2]|0;n=c[g+(o<<4)+4>>2]|0;if(!n)q=-1;else q=c[n+12>>2]|0;do if((r|0)>=-1){q=(p|0)==0&(s|0)>(q|0);if(q|(p|0)==0^1)if(q)break;else break b;if((f|0)!=(n|0))break b;if(j>>>0<=(c[g+(o<<4)+8>>2]|0)>>>0)break b}while(0);o=o+ -1|0}else{n=c[h+12>>2]|0;q=o;while(1){p=c[g+(q<<4)>>2]|0;if(!p)t=-1;else t=c[p+12>>2]|0;if(!f)r=-1;else r=c[f+12>>2]|0;o=c[g+(q<<4)+4>>2]|0;if(!o)s=-1;else s=c[o+12>>2]|0;do if((n|0)<=(t|0)){r=(h|0)==(p|0)&(r|0)>(s|0);if(r|(h|0)==(p|0)^1)if(r)break;else{o=q;break b}if((f|0)!=(o|0)){o=q;break b}if(j>>>0<=(c[g+(q<<4)+8>>2]|0)>>>0){o=q;break b}}while(0);q=q+ -1|0}}while(0);if((k|0)<=(o|0)){t=g+(k<<4)|0;r=c[g+(k<<4)+8>>2]|0;s=c[g+(k<<4)+12>>2]|0;q=g+(o<<4)|0;c[t+0>>2]=c[q+0>>2];c[t+4>>2]=c[q+4>>2];c[t+8>>2]=c[q+8>>2];c[t+12>>2]=c[q+12>>2];t=c[a+12>>2]|0;c[t+(o<<4)>>2]=m;c[t+(o<<4)+4>>2]=l;c[t+(o<<4)+8>>2]=r;c[t+(o<<4)+12>>2]=s;k=k+1|0;o=o+ -1|0}if((k|0)>(o|0))break;g=c[a+12>>2]|0}if((o|0)>(b|0))os(a,b,o);if((k|0)<(d|0))b=k;else break}i=e;return}function ps(a,c,d,e,f,h){a=a|0;c=c|0;d=+d;e=+e;f=+f;h=h|0;var j=0,k=0;j=i;d=(d- +g[a+8>>2])*+g[a+40>>2];e=(e- +g[a+12>>2])*+g[a+44>>2];f=(f- +g[a+16>>2])*+g[a+48>>2];do if(!(d<=0.0)){k=b[a+6>>1]|0;if(!(d>=+(k&65535|0))){k=b[a+4>>1]&(~~d&65535)&65535|h;break}else{k=b[a+4>>1]&k&65535|h;break}}else k=h;while(0);b[c>>1]=k;do if(!(e<=0.0)){k=b[a+6>>1]|0;if(!(e>=+(k&65535|0))){k=b[a+4>>1]&(~~e&65535)&65535|h;break}else{k=b[a+4>>1]&k&65535|h;break}}else k=h;while(0);b[c+2>>1]=k;if(f<=0.0){h=h&65535;k=c+4|0;b[k>>1]=h;i=j;return}k=b[a+6>>1]|0;if(!(f>=+(k&65535|0))){h=b[a+4>>1]&(~~f&65535)&65535|h;h=h&65535;k=c+4|0;b[k>>1]=h;i=j;return}else{h=b[a+4>>1]&k&65535|h;h=h&65535;k=c+4|0;b[k>>1]=h;i=j;return}}function qs(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=i;p=c[a+(d<<2)+68>>2]|0;g=c[a+60>>2]|0;h=e[p+((f&65535)<<2)+2>>1]|0;n=b[p+((f&65535)+ -1<<2)>>1]|0;if((e[p+((f&65535)<<2)>>1]|0)>=(n&65535)){i=l;return}m=g;o=p+((f&65535)<<2)|0;p=p+((f&65535)+ -1<<2)|0;while(1){f=e[p+2>>1]|0;if(!(n&1)){f=m+(f<<6)+(d<<1)+48|0;b[f>>1]=(b[f>>1]|0)+1<<16>>16}else{if(((((e[g+(h<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[m+(f<<6)+((1<<d&3)<<1)+48>>1]|0)?(e[m+(f<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[g+(h<<6)+((1<<d&3)<<1)+48>>1]|0):0)?(e[g+(h<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[m+(f<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(e[m+(f<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[g+(h<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(j=c[a+92>>2]|0,k=m+(f<<6)|0,Yb[c[(c[j>>2]|0)+8>>2]&31](j,g+(h<<6)|0,k)|0,j=c[a+96>>2]|0,(j|0)!=0):0)Yb[c[(c[j>>2]|0)+8>>2]&31](j,g+(h<<6)|0,k)|0;f=m+(f<<6)+(d<<1)+54|0;b[f>>1]=(b[f>>1]|0)+1<<16>>16}b[g+(h<<6)+(d<<1)+48>>1]=(b[g+(h<<6)+(d<<1)+48>>1]|0)+ -1<<16>>16;n=e[o>>1]|e[o+2>>1]<<16;f=e[p>>1]|e[p+2>>1]<<16;b[o>>1]=f;b[o+2>>1]=f>>>16;b[p>>1]=n;b[p+2>>1]=n>>>16;o=o+ -4|0;p=p+ -4|0;n=b[p>>1]|0;if((e[o>>1]|0)>=(n&65535))break;m=c[a+60>>2]|0}i=l;return}function rs(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=i;q=c[a+(d<<2)+68>>2]|0;o=b[q+((f&65535)+ -1<<2)>>1]|0;if((e[q+((f&65535)<<2)>>1]|0)>=(o&65535)){i=j;return}n=c[a+60>>2]|0;h=n+((e[q+((f&65535)<<2)+2>>1]|0)<<6)+(d<<1)+54|0;p=q+((f&65535)<<2)|0;q=q+((f&65535)+ -1<<2)|0;while(1){f=e[q+2>>1]|0;if(!(o&1)){o=e[p+2>>1]|0;if(((((e[n+(o<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[n+(f<<6)+((1<<d&3)<<1)+48>>1]|0)?(e[n+(f<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[n+(o<<6)+((1<<d&3)<<1)+48>>1]|0):0)?(e[n+(o<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[n+(f<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(e[n+(f<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[n+(o<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(l=c[a+92>>2]|0,m=n+(o<<6)|0,k=n+(f<<6)|0,Tb[c[(c[l>>2]|0)+12>>2]&31](l,m,k,g)|0,l=c[a+96>>2]|0,(l|0)!=0):0)Tb[c[(c[l>>2]|0)+12>>2]&31](l,m,k,g)|0;f=n+(f<<6)+(d<<1)+48|0;b[f>>1]=(b[f>>1]|0)+1<<16>>16}else{f=n+(f<<6)+(d<<1)+54|0;b[f>>1]=(b[f>>1]|0)+1<<16>>16}b[h>>1]=(b[h>>1]|0)+ -1<<16>>16;o=e[p>>1]|e[p+2>>1]<<16;f=e[q>>1]|e[q+2>>1]<<16;b[p>>1]=f;b[p+2>>1]=f>>>16;b[q>>1]=o;b[q+2>>1]=o>>>16;p=p+ -4|0;q=q+ -4|0;o=b[q>>1]|0;if((e[p>>1]|0)>=(o&65535))break;n=c[a+60>>2]|0}i=j;return}function ss(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=5216;if(c[b+108>>2]|0){e=c[b+112>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+112>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+108>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+108>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}}e=c[b+88>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+84>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+80>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+60>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}if(!(a[b+100>>0]|0)){i=d;return}e=c[b+92>>2]|0;Lb[c[c[e>>2]>>2]&511](e);b=c[b+92>>2]|0;if(!b){i=d;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function ts(a){a=a|0;var b=0;b=i;ss(a);i=b;return}function us(a){a=a|0;var b=0;b=i;ss(a);if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function vs(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=5280;e=c[b+16>>2]|0;if(e){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;i=d;return}function ws(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=5280;e=c[b+16>>2]|0;if((e|0)!=0?(a[b+20>>0]|0)!=0:0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}gF(b);i=d;return}function xs(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function ys(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return 0}function zs(a,b,c){a=a|0;b=b|0;c=c|0;return}function As(a){a=a|0;return c[a+16>>2]|0}function Bs(a){a=a|0;return c[a+16>>2]|0}function Cs(a){a=a|0;return a+4|0}function Ds(a,b,c){a=a|0;b=b|0;c=c|0;return}function Es(a){a=a|0;return 0}function Fs(a,b,c){a=a|0;b=b|0;c=c|0;return}function Gs(a,b){a=a|0;b=b|0;return}function Hs(a,b,c){a=a|0;b=b|0;c=c|0;return}function Is(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function Js(a){a=a|0;return 1}function Ks(a,b){a=a|0;b=b|0;return}function Ls(a,b){a=a|0;b=b|0;return}function Ms(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;f=i;k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);o=k+ +g[a+28>>2];m=k+ +g[a+32>>2];k=k+ +g[a+36>>2];w=+P(+(+g[b>>2]));v=+P(+(+g[b+4>>2]));u=+P(+(+g[b+8>>2]));s=+P(+(+g[b+16>>2]));r=+P(+(+g[b+20>>2]));q=+P(+(+g[b+24>>2]));n=+P(+(+g[b+32>>2]));l=+P(+(+g[b+36>>2]));j=+P(+(+g[b+40>>2]));t=+g[b+48>>2];p=+g[b+52>>2];h=+g[b+56>>2];g[d>>2]=t-(o*w+m*v+k*u);g[d+4>>2]=p-(o*s+m*r+k*q);g[d+8>>2]=h-(o*n+m*l+k*j);g[d+12>>2]=0.0;g[e>>2]=o*w+m*v+k*u+t;g[e+4>>2]=o*s+m*r+k*q+p;g[e+8>>2]=o*n+m*l+k*j+h;g[e+12>>2]=0.0;i=f;return}function Ns(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;k=+g[a+28>>2];h=+g[a+32>>2];l=+g[a+36>>2];j=+$b[c[(c[a>>2]|0)+48>>2]&15](a);f=+$b[c[(c[a>>2]|0)+48>>2]&15](a);l=(l+ +$b[c[(c[a>>2]|0)+48>>2]&15](a))*2.0;g[d>>2]=b/12.0*((h+f)*2.0*(h+f)*2.0+l*l);g[d+4>>2]=b/12.0*((k+j)*2.0*(k+j)*2.0+l*l);g[d+8>>2]=b/12.0*((k+j)*2.0*(k+j)*2.0+(h+f)*2.0*(h+f)*2.0);g[d+12>>2]=0.0;i=e;return}function Os(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=15736;d=c[a+52>>2]|0;if(!d){i=b;return}Lb[c[c[d>>2]>>2]&511](d);a=c[a+52>>2]|0;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Ps(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=15736;d=c[a+52>>2]|0;if(d){Lb[c[c[d>>2]>>2]&511](d);d=c[a+52>>2]|0;if(d){c[5006]=(c[5006]|0)+1;gF(c[d+ -4>>2]|0)}if(!a){i=b;return}}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Qs(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;d=i;m=+$b[c[(c[a>>2]|0)+48>>2]&15](a);j=+$b[c[(c[a>>2]|0)+48>>2]&15](a);e=+$b[c[(c[a>>2]|0)+48>>2]&15](a);o=(m+ +g[a+28>>2])/+g[a+12>>2];l=(j+ +g[a+32>>2])/+g[a+16>>2];h=(e+ +g[a+36>>2])/+g[a+20>>2];n=+P(+(+g[b>>2]));k=+P(+(+g[b+4>>2]));f=+P(+(+g[b+8>>2]));g[a+12>>2]=n;g[a+16>>2]=k;g[a+20>>2]=f;g[a+24>>2]=0.0;g[a+28>>2]=o*n-m;g[a+32>>2]=l*k-j;g[a+36>>2]=h*f-e;g[a+40>>2]=0.0;i=d;return}function Rs(a){a=a|0;return 5608}function Ss(a,b){a=a|0;b=+b;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0;d=i;j=+$b[c[(c[a>>2]|0)+48>>2]&15](a);f=+$b[c[(c[a>>2]|0)+48>>2]&15](a);k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+28>>2];f=f+ +g[a+32>>2];k=k+ +g[a+36>>2];g[a+44>>2]=b;h=+$b[c[(c[a>>2]|0)+48>>2]&15](a);e=+$b[c[(c[a>>2]|0)+48>>2]&15](a);b=k- +$b[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=j-h;g[a+32>>2]=f-e;g[a+36>>2]=b;g[a+40>>2]=0.0;i=d;return}function Ts(a){a=a|0;return+(+g[a+44>>2])}function Us(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;k=+g[b+28>>2];l=+g[b+32>>2];f=+g[b+36>>2];j=+$b[c[(c[b>>2]|0)+48>>2]&15](b);h=+$b[c[(c[b>>2]|0)+48>>2]&15](b);f=f+ +$b[c[(c[b>>2]|0)+48>>2]&15](b);h=+g[d+4>>2]>=0.0?l+h:-(l+h);f=+g[d+8>>2]>=0.0?f:-f;g[a>>2]=+g[d>>2]>=0.0?k+j:-(k+j);g[a+4>>2]=h;g[a+8>>2]=f;g[a+12>>2]=0.0;i=e;return}function Vs(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0;f=+g[b+28>>2];e=+g[b+32>>2];e=+g[c+4>>2]>=0.0?e:-e;d=+g[b+36>>2];d=+g[c+8>>2]>=0.0?d:-d;g[a>>2]=+g[c>>2]>=0.0?f:-f;g[a+4>>2]=e;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function Ws(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0;e=i;if((d|0)<=0){i=e;return}f=0;do{k=+g[a+28>>2];j=+g[a+32>>2];j=+g[b+(f<<4)+4>>2]>=0.0?j:-j;h=+g[a+36>>2];h=+g[b+(f<<4)+8>>2]>=0.0?h:-h;g[c+(f<<4)>>2]=+g[b+(f<<4)>>2]>=0.0?k:-k;g[c+(f<<4)+4>>2]=j;g[c+(f<<4)+8>>2]=h;g[c+(f<<4)+12>>2]=0.0;f=f+1|0}while((f|0)!=(d|0));i=e;return}function Xs(a){a=a|0;return 6}function Ys(a,b,c){a=a|0;b=b|0;c=c|0;a=i;switch(b|0){case 5:{g[c>>2]=0.0;g[c+4>>2]=0.0;g[c+8>>2]=-1.0;g[c+12>>2]=0.0;i=a;return};case 3:{g[c>>2]=0.0;g[c+4>>2]=-1.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=a;return};case 2:{g[c>>2]=0.0;g[c+4>>2]=1.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=a;return};case 4:{g[c>>2]=0.0;g[c+4>>2]=0.0;g[c+8>>2]=1.0;g[c+12>>2]=0.0;i=a;return};case 0:{g[c>>2]=1.0;g[c+4>>2]=0.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=a;return};case 1:{g[c>>2]=-1.0;g[c+4>>2]=0.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=a;return};default:{i=a;return}}}function Zs(a){a=a|0;return 8}function _s(a){a=a|0;return 12}function $s(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;do switch(b|0){case 9:{g=4;b=6;break};case 3:{g=2;break};case 8:{g=4;b=5;break};case 1:{g=0;b=2;break};case 0:{g=0;b=1;break};case 11:{g=6;b=7;break};case 2:{g=1;b=3;break};case 7:{g=3;break};case 10:{g=5;b=7;break};case 6:{g=2;break};case 5:{g=1;break};case 4:{g=0;break};default:{g=0;b=0}}while(0);rc[c[(c[a>>2]|0)+108>>2]&127](a,g,d);rc[c[(c[a>>2]|0)+108>>2]&127](a,b,e);i=f;return}function at(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;l=+g[a+28>>2];j=+g[a+32>>2];f=+g[a+36>>2];k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);h=+$b[c[(c[a>>2]|0)+48>>2]&15](a);f=f+ +$b[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=+(b&1^1|0)*(l+k)- +(b&1|0)*(l+k);g[d+4>>2]=+(b>>>1&1^1|0)*(j+h)- +(b>>>1&1|0)*(j+h);g[d+8>>2]=+(b>>>2&1^1|0)*f- +(b>>>2&1|0)*f;g[d+12>>2]=0.0;i=e;return}function bt(a){a=a|0;return 6}function ct(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0;f=i;i=i+48|0;rc[c[(c[a>>2]|0)+124>>2]&127](a,f+32|0,e);k=+g[f+32>>2];j=+g[f+36>>2];h=+g[f+40>>2];g[b>>2]=k;g[b+4>>2]=j;g[b+8>>2]=h;g[b+12>>2]=0.0;e=c[(c[a>>2]|0)+64>>2]|0;g[f>>2]=-k;g[f+4>>2]=-j;g[f+8>>2]=-h;g[f+12>>2]=0.0;rc[e&127](f+16|0,a,f);c[d+0>>2]=c[f+16>>2];c[d+4>>2]=c[f+20>>2];c[d+8>>2]=c[f+24>>2];c[d+12>>2]=c[f+28>>2];i=f;return}function dt(a,b,c){a=a|0;b=b|0;c=+c;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;d=i;k=+g[a+28>>2];e=+g[a+32>>2];j=+g[a+36>>2];l=+g[b>>2];if((((l<=k+c?l>=-k-c:0)?(h=+g[b+4>>2],h<=e+c):0)?h>=-e-c:0)?(f=+g[b+8>>2],f<=j+c):0)b=f>=-j-c;else b=0;i=d;return b|0}function et(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0.0,h=0.0;d=i;e=+g[a+28>>2];f=+g[a+32>>2];h=+g[a+36>>2];switch(c|0){case 1:{g[b>>2]=-1.0;g[b+4>>2]=0.0;g[b+8>>2]=0.0;g[b+12>>2]=-e;i=d;return};case 0:{g[b>>2]=1.0;g[b+4>>2]=0.0;g[b+8>>2]=0.0;g[b+12>>2]=-e;i=d;return};case 4:{g[b>>2]=0.0;g[b+4>>2]=0.0;g[b+8>>2]=1.0;g[b+12>>2]=-h;i=d;return};case 3:{g[b>>2]=0.0;g[b+4>>2]=-1.0;g[b+8>>2]=0.0;g[b+12>>2]=-f;i=d;return};case 2:{g[b>>2]=0.0;g[b+4>>2]=1.0;g[b+8>>2]=0.0;g[b+12>>2]=-f;i=d;return};case 5:{g[b>>2]=0.0;g[b+4>>2]=0.0;g[b+8>>2]=-1.0;g[b+12>>2]=-h;i=d;return};default:{i=d;return}}}function ft(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;h=i;i=i+48|0;c[b+8>>2]=0;g[b+12>>2]=0.0;c[b>>2]=17416;c[b+48>>2]=d;c[b+4>>2]=21;if(Pb[c[(c[d>>2]|0)+40>>2]&127](d)|0)rc[c[(c[d>>2]|0)+48>>2]&127](d,b+16|0,b+32|0);else{c[h+32>>2]=0;c[h+36>>2]=0;c[h+40>>2]=0;c[h+44>>2]=0;g[h+32>>2]=1.0;rc[c[(c[b>>2]|0)+68>>2]&127](h+16|0,b,h+32|0);g[b+32>>2]=+g[h+16>>2]+ +g[b+12>>2];g[h+32>>2]=-1.0;rc[c[(c[b>>2]|0)+68>>2]&127](h,b,h+32|0);c[h+16>>2]=c[h+0>>2];c[h+20>>2]=c[h+4>>2];c[h+24>>2]=c[h+8>>2];c[h+28>>2]=c[h+12>>2];g[b+16>>2]=+g[h+16>>2]- +g[b+12>>2];c[h+32>>2]=0;c[h+36>>2]=0;c[h+40>>2]=0;c[h+44>>2]=0;g[h+36>>2]=1.0;rc[c[(c[b>>2]|0)+68>>2]&127](h+16|0,b,h+32|0);g[b+36>>2]=+g[h+20>>2]+ +g[b+12>>2];g[h+36>>2]=-1.0;rc[c[(c[b>>2]|0)+68>>2]&127](h,b,h+32|0);c[h+16>>2]=c[h+0>>2];c[h+20>>2]=c[h+4>>2];c[h+24>>2]=c[h+8>>2];c[h+28>>2]=c[h+12>>2];g[b+20>>2]=+g[h+20>>2]- +g[b+12>>2];c[h+32>>2]=0;c[h+36>>2]=0;c[h+40>>2]=0;c[h+44>>2]=0;g[h+40>>2]=1.0;rc[c[(c[b>>2]|0)+68>>2]&127](h+16|0,b,h+32|0);g[b+40>>2]=+g[h+24>>2]+ +g[b+12>>2];g[h+40>>2]=-1.0;rc[c[(c[b>>2]|0)+68>>2]&127](h,b,h+32|0);c[h+16>>2]=c[h+0>>2];c[h+20>>2]=c[h+4>>2];c[h+24>>2]=c[h+8>>2];c[h+28>>2]=c[h+12>>2];g[b+24>>2]=+g[h+24>>2]- +g[b+12>>2]}c[b>>2]=5624;c[b+52>>2]=0;c[b+56>>2]=0;a[b+60>>0]=e&1;a[b+61>>0]=0;c[b+4>>2]=21;if(!f){i=h;return}c[5004]=(c[5004]|0)+1;e=fF(191)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}c[e+52>>2]=282;a[e+60>>0]=0;a[e+80>>0]=1;c[e+76>>2]=0;c[e+68>>2]=0;c[e+72>>2]=0;a[e+100>>0]=1;c[e+96>>2]=0;c[e+88>>2]=0;c[e+92>>2]=0;a[e+120>>0]=1;c[e+116>>2]=0;c[e+108>>2]=0;c[e+112>>2]=0;a[e+140>>0]=1;c[e+136>>2]=0;c[e+128>>2]=0;c[e+132>>2]=0;c[e+144>>2]=0;a[e+164>>0]=1;c[e+160>>2]=0;c[e+152>>2]=0;c[e+156>>2]=0;c[e+168>>2]=0;g[e+4>>2]=-3.4028234663852886e+38;g[e+8>>2]=-3.4028234663852886e+38;g[e+12>>2]=-3.4028234663852886e+38;g[e+16>>2]=0.0;g[e+20>>2]=3.4028234663852886e+38;g[e+24>>2]=3.4028234663852886e+38;g[e+28>>2]=3.4028234663852886e+38;g[e+32>>2]=0.0;c[e>>2]=14880;c[b+52>>2]=e;Pz(e,c[b+48>>2]|0,(a[b+60>>0]|0)!=0,b+16|0,b+32|0);a[b+61>>0]=1;i=h;return}function gt(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=5624;if(a[b+61>>0]|0){e=c[b+52>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+52>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}if(!b){i=d;return}}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function ht(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=5624;if(!(a[b+61>>0]|0)){i=d;return}e=c[b+52>>2]|0;Lb[c[c[e>>2]>>2]&511](e);b=c[b+52>>2]|0;if(!b){i=d;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function it(d,f,h,j){d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;k=i;i=i+80|0;w=c[d+48>>2]|0;c[k>>2]=5808;c[k+4>>2]=w;c[k+8>>2]=f;f=c[d+52>>2]|0;if(!(a[f+60>>0]|0)){n=c[f+56>>2]|0;a:do if((n|0)>0){m=0;l=c[f+96>>2]|0;d=1;while(1){if(!(+g[h>>2]>+g[l+16>>2])?!(+g[j>>2]<+g[l>>2]):0)r=1;else r=0;if(!(!(+g[h+8>>2]>+g[l+24>>2])?!(+g[j+8>>2]<+g[l+8>>2]):0))r=0;if(!(+g[h+4>>2]>+g[l+20>>2])?!(+g[j+4>>2]<+g[l+4>>2]):0){q=c[l+32>>2]|0;if((q|0)==-1&r){rc[c[(c[k>>2]|0)+8>>2]&127](k,c[l+36>>2]|0,c[l+40>>2]|0);n=c[f+56>>2]|0;o=44}else{p=(q|0)==-1;o=43}}else{q=c[l+32>>2]|0;p=(q|0)==-1;r=0;o=43}if((o|0)==43){o=0;if(r|p)o=44;else{m=q+m|0;l=l+(q<<6)|0}}if((o|0)==44){m=m+1|0;l=l+64|0}if((m|0)>=(n|0))break a;d=d+1|0}}else d=0;while(0);if((c[4028]|0)>=(d|0)){i=k;return}c[4028]=d;i=k;return}z=+g[h>>2];D=+g[h+4>>2];H=+g[h+8>>2];G=+g[f+4>>2];z=z<G?G:z;C=+g[f+8>>2];D=D<C?C:D;y=+g[f+12>>2];H=H<y?y:H;I=+g[f+20>>2];E=+g[f+24>>2];A=+g[f+28>>2];F=+g[f+36>>2];B=+g[f+40>>2];x=+g[f+44>>2];h=~~(((I<z?I:z)-G)*F)&65534;b[k+66>>1]=h;l=~~(((E<D?E:D)-C)*B)&65534;b[k+68>>1]=l;d=~~(((A<H?A:H)-y)*x)&65534;b[k+70>>1]=d;H=+g[j>>2];D=+g[j+4>>2];z=+g[j+8>>2];H=H<G?G:H;D=D<C?C:D;z=z<y?y:z;m=(~~(((I<H?I:H)-G)*F+1.0)&65535|1)&65535;b[k+60>>1]=m;n=(~~(((E<D?E:D)-C)*B+1.0)&65535|1)&65535;b[k+62>>1]=n;j=(~~(((A<z?A:z)-y)*x+1.0)&65535|1)&65535;b[k+64>>1]=j;o=c[f+144>>2]|0;if(!o){o=c[f+56>>2]|0;b:do if((o|0)>0){p=0;q=c[f+136>>2]|0;f=1;while(1){t=((m&65535)>=(e[q>>1]|0)?(h&65535)<=(e[q+6>>1]|0):0)&(d&65535)<=(e[q+10>>1]|0)&(j&65535)>=(e[q+4>>1]|0)&(l&65535)<=(e[q+8>>1]|0)&(n&65535)>=(e[q+2>>1]|0);s=q+12|0;r=c[s>>2]|0;if((r|0)>-1&t)rc[c[(c[k>>2]|0)+8>>2]&127](k,r>>21,r&2097151);if(t|(r|0)>-1){p=p+1|0;q=q+16|0}else{w=c[s>>2]|0;p=p-w|0;q=q+(0-w<<4)|0}if((p|0)>=(o|0))break b;f=f+1|0}}else f=0;while(0);if((c[4028]|0)>=(f|0)){i=k;return}c[4028]=f;i=k;return}else if((o|0)==1){if((c[f+152>>2]|0)<=0){i=k;return}o=0;do{q=c[f+160>>2]|0;if(((m&65535)>=(e[q+(o<<5)>>1]|0)?(h&65535)<=(e[q+(o<<5)+6>>1]|0):0)&(d&65535)<=(e[q+(o<<5)+10>>1]|0)&(j&65535)>=(e[q+(o<<5)+4>>1]|0)&(l&65535)<=(e[q+(o<<5)+8>>1]|0)&(n&65535)>=(e[q+(o<<5)+2>>1]|0)){p=c[q+(o<<5)+12>>2]|0;q=c[q+(o<<5)+16>>2]|0;c:do if((q|0)>0){s=p;t=(c[f+136>>2]|0)+(p<<4)|0;r=1;while(1){v=((m&65535)>=(e[t>>1]|0)?(h&65535)<=(e[t+6>>1]|0):0)&(d&65535)<=(e[t+10>>1]|0)&(j&65535)>=(e[t+4>>1]|0)&(l&65535)<=(e[t+8>>1]|0)&(n&65535)>=(e[t+2>>1]|0);u=t+12|0;w=c[u>>2]|0;if((w|0)>-1&v)rc[c[(c[k>>2]|0)+8>>2]&127](k,w>>21,w&2097151);if(v|(w|0)>-1){s=s+1|0;t=t+16|0}else{w=c[u>>2]|0;s=s-w|0;t=t+(0-w<<4)|0}if((s|0)>=(q+p|0))break c;r=r+1|0}}else r=0;while(0);if((c[4028]|0)<(r|0))c[4028]=r}o=o+1|0}while((o|0)<(c[f+152>>2]|0));i=k;return}else if((o|0)==2){NA(c[f+136>>2]|0,k,k+66|0,k+60|0);i=k;return}else{i=k;return}}function jt(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0;e=i;l=Pb[c[(c[b>>2]|0)+28>>2]&127](b)|0;k=+g[l>>2]- +g[d>>2];j=+g[l+4>>2]- +g[d+4>>2];h=+g[l+8>>2]- +g[d+8>>2];if(!(k*k+j*j+h*h>1.1920928955078125e-7)){i=e;return}hC(b,d);if((a[b+61>>0]|0)!=0?(f=c[b+52>>2]|0,Lb[c[c[f>>2]>>2]&511](f),f=c[b+52>>2]|0,(f|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[5004]=(c[5004]|0)+1;f=fF(191)|0;if(!f)f=0;else{c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}c[f+52>>2]=282;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;g[f+4>>2]=-3.4028234663852886e+38;g[f+8>>2]=-3.4028234663852886e+38;g[f+12>>2]=-3.4028234663852886e+38;g[f+16>>2]=0.0;g[f+20>>2]=3.4028234663852886e+38;g[f+24>>2]=3.4028234663852886e+38;g[f+28>>2]=3.4028234663852886e+38;g[f+32>>2]=0.0;c[f>>2]=14880;c[b+52>>2]=f;Pz(f,c[b+48>>2]|0,(a[b+60>>0]|0)!=0,b+16|0,b+32|0);a[b+61>>0]=1;i=e;return}function kt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0;e=i;h=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;j=gc[c[(c[d>>2]|0)+28>>2]&31](d,h)|0;c[b>>2]=j;if(j)Nb[c[(c[d>>2]|0)+48>>2]&127](d,h);c[b+4>>2]=c[a+4>>2];j=c[a+48>>2]|0;Yb[c[(c[j>>2]|0)+56>>2]&31](j,b+12|0,d)|0;g[b+52>>2]=+g[a+12>>2];do if((c[a+52>>2]|0)!=0?((Pb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&1|0)==0:0){h=gc[c[(c[d>>2]|0)+24>>2]&31](d,c[a+52>>2]|0)|0;if(!h){c[b+40>>2]=gc[c[(c[d>>2]|0)+28>>2]&31](d,c[a+52>>2]|0)|0;c[b+44>>2]=0;h=c[a+52>>2]|0;h=Pb[c[(c[h>>2]|0)+12>>2]&127](h)|0;h=Yb[c[(c[d>>2]|0)+16>>2]&31](d,h,1)|0;j=c[a+52>>2]|0;j=Yb[c[(c[j>>2]|0)+16>>2]&31](j,c[h+8>>2]|0,d)|0;Jb[c[(c[d>>2]|0)+20>>2]&31](d,h,j,1213612625,c[a+52>>2]|0);break}else{c[b+40>>2]=h;c[b+44>>2]=0;break}}else f=8;while(0);if((f|0)==8){c[b+40>>2]=0;c[b+44>>2]=0}if((c[a+56>>2]|0)!=0?((Pb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&2|0)==0:0){f=gc[c[(c[d>>2]|0)+24>>2]&31](d,c[a+56>>2]|0)|0;if(!f){c[b+48>>2]=gc[c[(c[d>>2]|0)+28>>2]&31](d,c[a+56>>2]|0)|0;h=c[a+56>>2]|0;h=Pb[c[(c[h>>2]|0)+8>>2]&127](h)|0;h=Yb[c[(c[d>>2]|0)+16>>2]&31](d,h,1)|0;j=c[a+56>>2]|0;j=Yb[c[(c[j>>2]|0)+12>>2]&31](j,c[h+8>>2]|0,d)|0;Jb[c[(c[d>>2]|0)+20>>2]&31](d,h,j,1346456916,c[a+56>>2]|0);i=e;return 5712}else{c[b+48>>2]=f;i=e;return 5712}}c[b+48>>2]=0;i=e;return 5712}function lt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;e=c[a+52>>2]|0;if(!e){i=d;return}f=Pb[c[(c[e>>2]|0)+12>>2]&127](e)|0;f=Yb[c[(c[b>>2]|0)+16>>2]&31](b,f,1)|0;e=c[a+52>>2]|0;e=Yb[c[(c[e>>2]|0)+16>>2]&31](e,c[f+8>>2]|0,b)|0;Jb[c[(c[b>>2]|0)+20>>2]&31](b,f,e,1213612625,c[a+52>>2]|0);i=d;return}function mt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;e=c[a+56>>2]|0;if(!e){i=d;return}f=Pb[c[(c[e>>2]|0)+8>>2]&127](e)|0;f=Yb[c[(c[b>>2]|0)+16>>2]&31](b,f,1)|0;e=c[a+56>>2]|0;e=Yb[c[(c[e>>2]|0)+12>>2]&31](e,c[f+8>>2]|0,b)|0;Jb[c[(c[b>>2]|0)+20>>2]&31](b,f,e,1346456916,c[a+56>>2]|0);i=d;return}function nt(a){a=a|0;return 5784}function ot(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function pt(a){a=a|0;return+(+g[a+12>>2])}function qt(a){a=a|0;return 60}function rt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;rc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);i=e;return}function st(a){a=a|0;return}function tt(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function ut(a,b,f){a=a|0;b=b|0;f=f|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0;o=i;i=i+32|0;l=c[a+4>>2]|0;fc[c[(c[l>>2]|0)+16>>2]&3](l,o+28|0,o+24|0,o+20|0,o+16|0,o+12|0,o+8|0,o+4|0,o,b);l=c[o+12>>2]|0;m=aa(c[o+8>>2]|0,f)|0;k=c[a+4>>2]|0;n=c[o>>2]|0;j=2;while(1){if((n|0)==2)q=c[l+m+(j<<2)>>2]|0;else if((n|0)==3)q=e[l+m+(j<<1)>>1]|0;else q=d[l+(j+m)>>0]|0;p=c[o+28>>2]|0;q=aa(c[o+16>>2]|0,q)|0;if(!(c[o+20>>2]|0)){s=+g[p+(q+4)>>2]*+g[k+8>>2];r=+g[p+(q+8)>>2]*+g[k+12>>2];g[a+(j<<4)+12>>2]=+g[p+q>>2]*+g[k+4>>2];g[a+(j<<4)+16>>2]=s;g[a+(j<<4)+20>>2]=r;g[a+(j<<4)+24>>2]=0.0}else{r=+h[p+(q+8)>>3]*+g[k+8>>2];s=+h[p+(q+16)>>3]*+g[k+12>>2];g[a+(j<<4)+12>>2]=+h[p+q>>3]*+g[k+4>>2];g[a+(j<<4)+16>>2]=r;g[a+(j<<4)+20>>2]=s;g[a+(j<<4)+24>>2]=0.0}if((j|0)>0)j=j+ -1|0;else break}q=c[a+8>>2]|0;vc[c[(c[q>>2]|0)+8>>2]&127](q,a+12|0,b,f);q=c[a+4>>2]|0;Nb[c[(c[q>>2]|0)+24>>2]&127](q,b);i=o;return}function vt(a){a=a|0;return}function wt(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function xt(a,b,d){a=a|0;b=b|0;d=d|0;var f=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0;n=i;i=i+80|0;l=c[a+4>>2]|0;fc[c[(c[l>>2]|0)+16>>2]&3](l,n+28|0,n+24|0,n+20|0,n+16|0,n+12|0,n+8|0,n+4|0,n,b);l=c[n+12>>2]|0;k=aa(c[n+8>>2]|0,d)|0;f=c[a+4>>2]|0;m=(c[n+20>>2]|0)==0;j=c[n+28>>2]|0;if((c[n>>2]|0)!=3){o=c[n+16>>2]|0;p=aa(o,c[l+(k+8)>>2]|0)|0;if(m){s=+g[j+(p+4)>>2]*+g[f+8>>2];r=+g[j+(p+8)>>2]*+g[f+12>>2];g[n+64>>2]=+g[j+p>>2]*+g[f+4>>2];g[n+68>>2]=s;g[n+72>>2]=r;g[n+76>>2]=0.0;q=aa(o,c[l+(k+4)>>2]|0)|0;r=+g[j+(q+4)>>2]*+g[f+8>>2];s=+g[j+(q+8)>>2]*+g[f+12>>2];g[n+48>>2]=+g[j+q>>2]*+g[f+4>>2];g[n+52>>2]=r;g[n+56>>2]=s;g[n+60>>2]=0.0;q=aa(o,c[l+k>>2]|0)|0;s=+g[j+(q+4)>>2]*+g[f+8>>2];r=+g[j+(q+8)>>2]*+g[f+12>>2];g[n+32>>2]=+g[j+q>>2]*+g[f+4>>2];g[n+36>>2]=s;g[n+40>>2]=r;g[n+44>>2]=0.0;q=a+8|0;q=c[q>>2]|0;p=c[q>>2]|0;p=p+8|0;p=c[p>>2]|0;vc[p&127](q,n+32|0,b,d);q=c[a+4>>2]|0;p=c[q>>2]|0;p=p+24|0;p=c[p>>2]|0;Nb[p&127](q,b);i=n;return}else{r=+h[j+(p+8)>>3]*+g[f+8>>2];s=+h[j+(p+16)>>3]*+g[f+12>>2];g[n+64>>2]=+h[j+p>>3]*+g[f+4>>2];g[n+68>>2]=r;g[n+72>>2]=s;g[n+76>>2]=0.0;q=aa(o,c[l+(k+4)>>2]|0)|0;s=+h[j+(q+8)>>3]*+g[f+8>>2];r=+h[j+(q+16)>>3]*+g[f+12>>2];g[n+48>>2]=+h[j+q>>3]*+g[f+4>>2];g[n+52>>2]=s;g[n+56>>2]=r;g[n+60>>2]=0.0;q=aa(o,c[l+k>>2]|0)|0;r=+h[j+(q+8)>>3]*+g[f+8>>2];s=+h[j+(q+16)>>3]*+g[f+12>>2];g[n+32>>2]=+h[j+q>>3]*+g[f+4>>2];g[n+36>>2]=r;g[n+40>>2]=s;g[n+44>>2]=0.0;q=a+8|0;q=c[q>>2]|0;p=c[q>>2]|0;p=p+8|0;p=c[p>>2]|0;vc[p&127](q,n+32|0,b,d);q=c[a+4>>2]|0;p=c[q>>2]|0;p=p+24|0;p=c[p>>2]|0;Nb[p&127](q,b);i=n;return}}o=c[n+16>>2]|0;p=2;while(1){q=aa(o,e[l+k+(p<<1)>>1]|0)|0;if(m){r=+g[j+(q+4)>>2]*+g[f+8>>2];s=+g[j+(q+8)>>2]*+g[f+12>>2];g[n+32+(p<<4)>>2]=+g[j+q>>2]*+g[f+4>>2];g[n+32+(p<<4)+4>>2]=r;g[n+32+(p<<4)+8>>2]=s;g[n+32+(p<<4)+12>>2]=0.0}else{r=+h[j+(q+8)>>3]*+g[f+8>>2];s=+h[j+(q+16)>>3]*+g[f+12>>2];g[n+32+(p<<4)>>2]=+h[j+q>>3]*+g[f+4>>2];g[n+32+(p<<4)+4>>2]=r;g[n+32+(p<<4)+8>>2]=s;g[n+32+(p<<4)+12>>2]=0.0}if((p|0)>0)p=p+ -1|0;else break}q=a+8|0;q=c[q>>2]|0;p=c[q>>2]|0;p=p+8|0;p=c[p>>2]|0;vc[p&127](q,n+32|0,b,d);q=c[a+4>>2]|0;p=c[q>>2]|0;p=p+24|0;p=c[p>>2]|0;Nb[p&127](q,b);i=n;return}function yt(a){a=a|0;return}function zt(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function At(a,b,d){a=a|0;b=b|0;d=d|0;var f=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0;n=i;i=i+80|0;m=c[a+4>>2]|0;fc[c[(c[m>>2]|0)+16>>2]&3](m,n+28|0,n+24|0,n+20|0,n+16|0,n+12|0,n+8|0,n+4|0,n,b);m=(c[n+12>>2]|0)+(aa(c[n+8>>2]|0,d)|0)|0;k=c[a+4>>2]|0;f=(c[n>>2]|0)==3;l=(c[n+20>>2]|0)==0;j=c[n+28>>2]|0;o=2;while(1){if(f)p=e[m+(o<<1)>>1]|0;else p=c[m+(o<<2)>>2]|0;p=aa(c[n+16>>2]|0,p)|0;if(l){r=+g[j+(p+4)>>2]*+g[k+8>>2];q=+g[j+(p+8)>>2]*+g[k+12>>2];g[n+32+(o<<4)>>2]=+g[j+p>>2]*+g[k+4>>2];g[n+32+(o<<4)+4>>2]=r;g[n+32+(o<<4)+8>>2]=q;g[n+32+(o<<4)+12>>2]=0.0}else{q=+h[j+(p+8)>>3]*+g[k+8>>2];r=+h[j+(p+16)>>3]*+g[k+12>>2];g[n+32+(o<<4)>>2]=+h[j+p>>3]*+g[k+4>>2];g[n+32+(o<<4)+4>>2]=q;g[n+32+(o<<4)+8>>2]=r;g[n+32+(o<<4)+12>>2]=0.0}if((o|0)>0)o=o+ -1|0;else break}p=c[a+8>>2]|0;vc[c[(c[p>>2]|0)+8>>2]&127](p,n+32|0,b,d);p=c[a+4>>2]|0;Nb[c[(c[p>>2]|0)+24>>2]&127](p,b);i=n;return}function Bt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;e=i;i=i+32|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;f=+g[d>>2];h=+g[d+4>>2];j=+g[d+8>>2];if(f*f+h*h+j*j<9999999747378752.0e-20){f=1.0;h=0.0;j=0.0}else{q=1.0/+Q(+(f*f+h*h+j*j));f=f*q;h=h*q;j=j*q}d=c[b+52>>2]|0;m=+g[b+(((d+2|0)%3|0)<<2)+28>>2];c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;g[e+16+(d<<2)>>2]=+g[b+(d<<2)+28>>2];l=f*m;k=h*m;m=j*m;q=l+ +g[e+16>>2];n=k+ +g[e+20>>2];o=m+ +g[e+24>>2];p=+$b[c[(c[b>>2]|0)+48>>2]&15](b);q=q-f*p;n=n-h*p;p=o-j*p;o=j*p+(f*q+h*n);if(o>-999999984306749400.0){g[a>>2]=q;g[a+4>>2]=n;g[a+8>>2]=p;g[a+12>>2]=0.0}else o=-999999984306749400.0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;d=c[b+52>>2]|0;g[e+(d<<2)>>2]=-+g[b+(d<<2)+28>>2];l=l+ +g[e>>2];k=k+ +g[e+4>>2];q=m+ +g[e+8>>2];m=+$b[c[(c[b>>2]|0)+48>>2]&15](b);l=l-f*m;k=k-h*m;m=q-j*m;if(!(j*m+(f*l+h*k)>o)){i=e;return}g[a>>2]=l;g[a+4>>2]=k;g[a+8>>2]=m;g[a+12>>2]=0.0;i=e;return}function Ct(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0;f=i;i=i+32|0;k=c[a+52>>2]|0;h=+g[a+(((k+2|0)%3|0)<<2)+28>>2];if((e|0)<=0){i=f;return}j=0;while(1){m=a+(k<<2)+28|0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;g[f+16+(k<<2)>>2]=+g[m>>2];m=b+(j<<4)|0;l=b+(j<<4)+4|0;k=b+(j<<4)+8|0;u=h*+g[m>>2]+ +g[f+16>>2];s=h*+g[l>>2]+ +g[f+20>>2];q=h*+g[k>>2]+ +g[f+24>>2];w=+$b[c[(c[a>>2]|0)+48>>2]&15](a);t=+g[m>>2];r=+g[l>>2];v=+g[k>>2];if(t*(u-w*t)+r*(s-w*r)+v*(q-w*v)>-999999984306749400.0){g[d+(j<<4)>>2]=u-w*t;g[d+(j<<4)+4>>2]=s-w*r;g[d+(j<<4)+8>>2]=q-w*v;g[d+(j<<4)+12>>2]=0.0;p=+g[m>>2];o=+g[l>>2];n=+g[k>>2];q=t*(u-w*t)+r*(s-w*r)+v*(q-w*v)}else{p=t;o=r;n=v;q=-999999984306749400.0}c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;x=c[a+52>>2]|0;g[f+(x<<2)>>2]=-+g[a+(x<<2)+28>>2];p=h*p+ +g[f>>2];o=h*o+ +g[f+4>>2];r=h*n+ +g[f+8>>2];n=+$b[c[(c[a>>2]|0)+48>>2]&15](a);s=+g[m>>2];t=+g[l>>2];u=+g[k>>2];if(s*(p-n*s)+t*(o-n*t)+u*(r-n*u)>q){g[d+(j<<4)>>2]=p-n*s;g[d+(j<<4)+4>>2]=o-n*t;g[d+(j<<4)+8>>2]=r-n*u;g[d+(j<<4)+12>>2]=0.0}j=j+1|0;if((j|0)==(e|0))break;k=c[a+52>>2]|0}i=f;return}function Dt(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+16|0;k=c[a+52>>2]|0;h=+g[a+(((k+2|0)%3|0)<<2)+28>>2];g[e>>2]=h;g[e+4>>2]=h;g[e+8>>2]=h;g[e+12>>2]=0.0;g[e+(k<<2)>>2]=+g[a+(k<<2)+28>>2]+ +g[e+(k<<2)>>2];h=(+g[e>>2]+.03999999910593033)*2.0;f=(+g[e+4>>2]+.03999999910593033)*2.0;j=(+g[e+8>>2]+.03999999910593033)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);i=e;return}function Et(a){a=a|0;return}function Ft(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Gt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0;f=i;i=i+16|0;x=c[a+52>>2]|0;k=+g[a+(((x+2|0)%3|0)<<2)+28>>2];g[f>>2]=k;g[f+4>>2]=k;g[f+8>>2]=k;g[f+12>>2]=0.0;g[f+(x<<2)>>2]=k+ +g[a+(x<<2)+28>>2];k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);h=+$b[c[(c[a>>2]|0)+48>>2]&15](a);n=+$b[c[(c[a>>2]|0)+48>>2]&15](a);k=k+ +g[f>>2];g[f>>2]=k;h=h+ +g[f+4>>2];g[f+4>>2]=h;n=n+ +g[f+8>>2];u=+P(+(+g[b>>2]));t=+P(+(+g[b+4>>2]));v=+P(+(+g[b+8>>2]));q=+P(+(+g[b+16>>2]));p=+P(+(+g[b+20>>2]));r=+P(+(+g[b+24>>2]));l=+P(+(+g[b+32>>2]));j=+P(+(+g[b+36>>2]));m=+P(+(+g[b+40>>2]));w=+g[b+48>>2];s=+g[b+52>>2];o=+g[b+56>>2];g[d>>2]=w-(n*v+(u*k+t*h));g[d+4>>2]=s-(n*r+(q*k+p*h));g[d+8>>2]=o-(n*m+(l*k+j*h));g[d+12>>2]=0.0;g[e>>2]=w+(n*v+(u*k+t*h));g[e+4>>2]=s+(n*r+(q*k+p*h));g[e+8>>2]=o+(n*m+(l*k+j*h));g[e+12>>2]=0.0;i=f;return}function Ht(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;d=i;m=+$b[c[(c[a>>2]|0)+48>>2]&15](a);j=+$b[c[(c[a>>2]|0)+48>>2]&15](a);e=+$b[c[(c[a>>2]|0)+48>>2]&15](a);o=(m+ +g[a+28>>2])/+g[a+12>>2];l=(j+ +g[a+32>>2])/+g[a+16>>2];h=(e+ +g[a+36>>2])/+g[a+20>>2];n=+P(+(+g[b>>2]));k=+P(+(+g[b+4>>2]));f=+P(+(+g[b+8>>2]));g[a+12>>2]=n;g[a+16>>2]=k;g[a+20>>2]=f;g[a+24>>2]=0.0;g[a+28>>2]=o*n-m;g[a+32>>2]=l*k-j;g[a+36>>2]=h*f-e;g[a+40>>2]=0.0;i=d;return}function It(a){a=a|0;return 6776}function Jt(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+52>>2]<<2)>>2]=1.0;i=d;return}function Kt(a,b){a=a|0;b=+b;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0;d=i;j=+$b[c[(c[a>>2]|0)+48>>2]&15](a);f=+$b[c[(c[a>>2]|0)+48>>2]&15](a);k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+28>>2];f=f+ +g[a+32>>2];k=k+ +g[a+36>>2];g[a+44>>2]=b;h=+$b[c[(c[a>>2]|0)+48>>2]&15](a);e=+$b[c[(c[a>>2]|0)+48>>2]&15](a);b=k- +$b[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=j-h;g[a+32>>2]=f-e;g[a+36>>2]=b;g[a+40>>2]=0.0;i=d;return}function Lt(a){a=a|0;return 60}function Mt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;e=i;f=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=gc[c[(c[d>>2]|0)+28>>2]&31](d,f)|0;c[b>>2]=h;if(h)Nb[c[(c[d>>2]|0)+48>>2]&127](d,f);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];c[b+52>>2]=c[a+52>>2];i=e;return 6752}function Nt(a){a=a|0;return}function Ot(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Pt(a){a=a|0;return 6736}function Qt(a){a=a|0;return}function Rt(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function St(a){a=a|0;return 6720}function Tt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0.0;e=i;i=i+80|0;f=c[c[a>>2]>>2]|0;h=c[c[a+4>>2]>>2]|0;if(!(Yb[c[(c[b>>2]|0)+24>>2]&31](b,f,h)|0)){i=e;return}j=c[f+192>>2]|0;c[e+56>>2]=0;c[e+60>>2]=j;c[e+64>>2]=f;c[e+68>>2]=f+4;c[e+72>>2]=-1;c[e+76>>2]=-1;j=c[h+192>>2]|0;c[e+32>>2]=0;c[e+36>>2]=j;c[e+40>>2]=h;c[e+44>>2]=h+4;c[e+48>>2]=-1;c[e+52>>2]=-1;j=c[a+8>>2]|0;if(!j){j=Tb[c[(c[b>>2]|0)+8>>2]&31](b,e+56|0,e+32|0,0)|0;c[a+8>>2]=j;if(!j){i=e;return}}c[e>>2]=13504;c[e+4>>2]=0;c[e+8>>2]=e+56;c[e+12>>2]=e+32;if((c[d+8>>2]|0)==1){Jb[c[(c[j>>2]|0)+8>>2]&31](j,e+56|0,e+32|0,d,e);i=e;return}k=+Xb[c[(c[j>>2]|0)+12>>2]&15](j,f,h,d,e);if(!(+g[d+12>>2]>k)){i=e;return}g[d+12>>2]=k;i=e;return}function Ut(a){a=a|0;return}function Vt(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=6808;e=c[b+20>>2]|0;if(e){if(a[b+24>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;gF(b);i=d;return}function Wt(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=6808;e=c[b+20>>2]|0;if(e){if(a[b+24>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;i=d;return}function Xt(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0.0,m=0,n=0,o=0.0;f=i;i=i+16|0;c[1698]=(c[1698]|0)+1;if(!(c[b+4>>2]&2))j=15720;else{j=c[d+192>>2]|0;k=+lc[c[(c[j>>2]|0)+20>>2]&1](j,.019999999552965164);g[f+4>>2]=k;j=c[e+192>>2]|0;l=+lc[c[(c[j>>2]|0)+20>>2]&1](j,.019999999552965164);g[f>>2]=l;j=k<l?f+4|0:f}l=+g[j>>2];o=+g[d+184>>2];k=+g[e+184>>2];k=o<k?o:k;m=c[b+68>>2]|0;j=c[m+8>>2]|0;if(!j){if(c[b+4>>2]&4){n=0;i=f;return n|0}c[5004]=(c[5004]|0)+1;j=fF(791)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}}else{n=c[m+12>>2]|0;c[m+12>>2]=c[n>>2];c[m+8>>2]=j+ -1;j=n}c[j>>2]=1025;c[j+116>>2]=0;a[j+120>>0]=0;n=j+124|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[j+300>>2]=0;a[j+304>>0]=0;n=j+308|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[j+484>>2]=0;a[j+488>>0]=0;n=j+492|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[j+668>>2]=0;a[j+672>>0]=0;n=j+676|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[j+740>>2]=d;c[j+744>>2]=e;c[j+748>>2]=0;g[j+752>>2]=l;g[j+756>>2]=k;c[j+768>>2]=c[b+12>>2];e=c[b+12>>2]|0;if((e|0)==(c[b+16>>2]|0)?(h=(e|0)==0?1:e<<1,(e|0)<(h|0)):0){if(!h)d=0;else{c[5004]=(c[5004]|0)+1;d=fF((h<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}e=c[b+12>>2]|0}if((e|0)>0){n=0;do{m=d+(n<<2)|0;if(m)c[m>>2]=c[(c[b+20>>2]|0)+(n<<2)>>2];n=n+1|0}while((n|0)!=(e|0))}m=c[b+20>>2]|0;if(m){if(a[b+24>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0);e=c[b+12>>2]|0}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=d;c[b+16>>2]=h}h=(c[b+20>>2]|0)+(e<<2)|0;if(h)c[h>>2]=j;c[b+12>>2]=e+1;n=j;i=f;return n|0}function Yt(a,b){a=a|0;b=b|0;var d=0,e=0;a=i;d=c[b+748>>2]|0;if((d|0)>0){e=0;do e=e+1|0;while((e|0)<(d|0))}c[b+748>>2]=0;i=a;return}function Zt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;c[1698]=(c[1698]|0)+ -1;Nb[c[(c[a>>2]|0)+20>>2]&127](a,b);e=c[b+768>>2]|0;f=(c[a+12>>2]|0)+ -1|0;h=c[a+20>>2]|0;g=c[h+(e<<2)>>2]|0;c[h+(e<<2)>>2]=c[h+(f<<2)>>2];c[(c[a+20>>2]|0)+(f<<2)>>2]=g;c[(c[(c[a+20>>2]|0)+(e<<2)>>2]|0)+768>>2]=e;c[a+12>>2]=(c[a+12>>2]|0)+ -1;a=c[a+68>>2]|0;if(!b){i=d;return}h=c[a+16>>2]|0;if(h>>>0<=b>>>0?(h+(aa(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;i=d;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function _t(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=a;c[f+4>>2]=e;e=c[a+((c[(c[b+4>>2]|0)+4>>2]|0)*144|0)+(c[(c[d+4>>2]|0)+4>>2]<<2)+72>>2]|0;e=Tb[c[(c[e>>2]|0)+8>>2]&31](e,f,b,d)|0;i=f;return e|0}function $t(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;a=i;b=c[b+204>>2]|0;if((b&4|0)==0?(e=c[d+204>>2]|0,(e&4|0)==0):0)if(!(b&3))d=1;else d=(e&3|0)==0;else d=0;i=a;return d|0}function au(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;a=i;e=c[b+216>>2]|0;if((e|0)==2|(e|0)==5?(e=c[d+216>>2]|0,(e|0)==2|(e|0)==5):0)b=0;else if(!(c[b+256>>2]|0))b=1;else b=gc[c[c[b>>2]>>2]&31](b,d)|0;i=a;return b|0}function bu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=6920;c[f+4>>2]=d;c[f+8>>2]=a;rc[c[(c[b>>2]|0)+48>>2]&127](b,f,e);i=f;return}function cu(a){a=a|0;return}function du(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;a=c[a+64>>2]|0;e=c[a+8>>2]|0;if(e){b=c[a+12>>2]|0;c[a+12>>2]=c[b>>2];c[a+8>>2]=e+ -1;e=b;i=d;return e|0}c[5004]=(c[5004]|0)+1;b=fF(b+19|0)|0;if(!b){e=0;i=d;return e|0}c[(b+19&-16)+ -4>>2]=b;e=b+19&-16;i=d;return e|0}function eu(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;a=c[a+64>>2]|0;if(!b){i=d;return}e=c[a+16>>2]|0;if(e>>>0<=b>>>0?(e+(aa(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;i=d;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function fu(a){a=a|0;return c[a+12>>2]|0}function gu(a,b){a=a|0;b=b|0;return c[(c[a+20>>2]|0)+(b<<2)>>2]|0}function hu(a){a=a|0;if(!(c[a+12>>2]|0))a=0;else a=c[a+20>>2]|0;return a|0}function iu(a){a=a|0;return c[a+68>>2]|0}function ju(a){a=a|0;return c[a+68>>2]|0}function ku(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function lu(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[a+8>>2]|0;rc[c[e+60>>2]&127](b,e,c[a+4>>2]|0);i=d;return 0}function mu(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function nu(a,b,d){a=a|0;b=b|0;d=d|0;c[a+16>>2]=b;c[a+24>>2]=d;return}function ou(a,b,d){a=a|0;b=b|0;d=d|0;c[a+20>>2]=b;c[a+28>>2]=d;return}function pu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0;e=i;g[b+16>>2]=+g[a+4>>2];g[b+20>>2]=+g[a+8>>2];g[b+24>>2]=+g[a+12>>2];g[b+28>>2]=+g[a+16>>2];g[b+32>>2]=+g[a+20>>2];g[b+36>>2]=+g[a+24>>2];g[b+40>>2]=+g[a+28>>2];g[b+44>>2]=+g[a+32>>2];g[b+48>>2]=+g[a+36>>2];g[b+52>>2]=+g[a+40>>2];g[b+56>>2]=+g[a+44>>2];g[b+60>>2]=+g[a+48>>2];g[b+64>>2]=+g[a+52>>2];g[b+68>>2]=+g[a+56>>2];g[b+72>>2]=+g[a+60>>2];g[b+76>>2]=+g[a+64>>2];g[b+80>>2]=+g[a+68>>2];g[b+84>>2]=+g[a+72>>2];g[b+88>>2]=+g[a+76>>2];g[b+92>>2]=+g[a+80>>2];g[b+96>>2]=+g[a+84>>2];g[b+100>>2]=+g[a+88>>2];g[b+104>>2]=+g[a+92>>2];g[b+108>>2]=+g[a+96>>2];g[b+112>>2]=+g[a+100>>2];g[b+116>>2]=+g[a+104>>2];g[b+120>>2]=+g[a+108>>2];g[b+124>>2]=+g[a+112>>2];g[b+128>>2]=+g[a+116>>2];g[b+132>>2]=+g[a+120>>2];g[b+136>>2]=+g[a+124>>2];g[b+140>>2]=+g[a+128>>2];g[b+144>>2]=+g[a+132>>2];g[b+148>>2]=+g[a+136>>2];g[b+152>>2]=+g[a+140>>2];g[b+156>>2]=+g[a+144>>2];g[b+160>>2]=+g[a+148>>2];g[b+164>>2]=+g[a+152>>2];g[b+168>>2]=+g[a+156>>2];g[b+172>>2]=+g[a+160>>2];g[b+176>>2]=+g[a+164>>2];g[b+180>>2]=+g[a+168>>2];g[b+184>>2]=+g[a+172>>2];g[b+188>>2]=+g[a+176>>2];c[b+224>>2]=c[a+180>>2];g[b+192>>2]=+g[a+184>>2];c[b>>2]=0;c[b+4>>2]=gc[c[(c[d>>2]|0)+28>>2]&31](d,c[a+192>>2]|0)|0;c[b+8>>2]=0;c[b+228>>2]=c[a+204>>2];c[b+232>>2]=c[a+208>>2];c[b+236>>2]=c[a+212>>2];c[b+240>>2]=c[a+216>>2];g[b+196>>2]=+g[a+220>>2];g[b+200>>2]=+g[a+224>>2];g[b+204>>2]=+g[a+232>>2];g[b+208>>2]=+g[a+228>>2];c[b+244>>2]=c[a+236>>2];f=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=gc[c[(c[d>>2]|0)+28>>2]&31](d,f)|0;c[b+12>>2]=h;if(!h){d=a+244|0;j=+g[d>>2];d=b+212|0;g[d>>2]=j;d=a+248|0;j=+g[d>>2];d=b+216|0;g[d>>2]=j;d=a+252|0;j=+g[d>>2];d=b+220|0;g[d>>2]=j;d=a+256|0;d=c[d>>2]|0;h=b+248|0;c[h>>2]=d;i=e;return 7016}Nb[c[(c[d>>2]|0)+48>>2]&127](d,f);d=a+244|0;j=+g[d>>2];d=b+212|0;g[d>>2]=j;d=a+248|0;j=+g[d>>2];d=b+216|0;g[d>>2]=j;d=a+252|0;j=+g[d>>2];d=b+220|0;g[d>>2]=j;d=a+256|0;d=c[d>>2]|0;h=b+248|0;c[h>>2]=d;i=e;return 7016}function qu(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;f=Pb[c[(c[a>>2]|0)+16>>2]&127](a)|0;f=Yb[c[(c[b>>2]|0)+16>>2]&31](b,f,1)|0;e=Yb[c[(c[a>>2]|0)+20>>2]&31](a,c[f+8>>2]|0,b)|0;Jb[c[(c[b>>2]|0)+20>>2]&31](b,f,e,1245859651,a);i=d;return}function ru(a,b){a=a|0;b=b|0;return 1}function su(a){a=a|0;return 256}function tu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;e=i;i=i+96|0;g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;n=e+76|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;vc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);l=+g[e>>2];m=+g[e+16>>2];j=+g[e+4>>2];k=+g[e+20>>2];f=+g[e+8>>2];h=+g[e+24>>2];g[d>>2]=+Q(+((l-m)*(l-m)+(j-k)*(j-k)+(f-h)*(f-h)))*.5;g[b>>2]=(m+l)*.5;g[b+4>>2]=(k+j)*.5;g[b+8>>2]=(h+f)*.5;g[b+12>>2]=0.0;i=e;return}function uu(a,b){a=a|0;b=+b;var d=0;d=i;b=+$b[c[(c[a>>2]|0)+16>>2]&15](a)*b;i=d;return+b}function vu(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0;b=i;i=i+32|0;rc[c[(c[a>>2]|0)+12>>2]&127](a,b+8|0,b);f=+g[b+8>>2];e=+g[b+12>>2];d=+g[b+16>>2];d=+Q(+(f*f+e*e+d*d));i=b;return+(d+ +g[b>>2])}function wu(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;j=i;vc[c[(c[a>>2]|0)+8>>2]&127](a,b,f,h);r=+g[h>>2];p=+g[h+4>>2];k=+g[h+8>>2];m=+g[f>>2];q=+g[f+4>>2];l=+g[f+8>>2];s=+g[d>>2];o=+g[d+4>>2];n=+g[d+8>>2];if(s>0.0)r=r+s;else m=m+s;if(o>0.0)p=p+o;else q=q+o;if(n>0.0)k=k+n;else l=l+n;n=+g[e>>2];o=+g[e+4>>2];s=+g[e+8>>2];s=+Q(+(n*n+o*o+s*s));s=s*+$b[c[(c[a>>2]|0)+16>>2]&15](a);g[f>>2]=m;g[f+4>>2]=q;g[f+8>>2]=l;g[f+12>>2]=0.0;g[h>>2]=r;g[h+4>>2]=p;g[h+8>>2]=k;g[h+12>>2]=0.0;g[f>>2]=+g[f>>2]-s;g[f+4>>2]=+g[f+4>>2]-s;g[f+8>>2]=+g[f+8>>2]-s;g[h>>2]=s+ +g[h>>2];g[h+4>>2]=s+ +g[h+4>>2];g[h+8>>2]=s+ +g[h+8>>2];i=j;return}function xu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;f=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;g=gc[c[(c[d>>2]|0)+28>>2]&31](d,f)|0;c[b>>2]=g;if(g)Nb[c[(c[d>>2]|0)+48>>2]&127](d,f);c[b+4>>2]=c[a+4>>2];i=e;return 7080}function yu(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;f=Pb[c[(c[a>>2]|0)+52>>2]&127](a)|0;f=Yb[c[(c[b>>2]|0)+16>>2]&31](b,f,1)|0;e=Yb[c[(c[a>>2]|0)+56>>2]&31](a,c[f+8>>2]|0,b)|0;Jb[c[(c[b>>2]|0)+20>>2]&31](b,f,e,1346455635,a);i=d;return}function zu(a){a=a|0;return 12}function Au(a){a=a|0;var b=0;b=i;Bu(a);gF(a);i=b;return}function Bu(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;c[b>>2]=7144;e=c[b+8>>2]|0;g=c[b+16>>2]|0;if((e|0)>0){f=0;do{h=(c[g+(f<<2)>>2]|0)+188|0;j=c[h>>2]|0;if(j){e=c[b+68>>2]|0;e=Pb[c[(c[e>>2]|0)+36>>2]&127](e)|0;rc[c[(c[e>>2]|0)+40>>2]&127](e,j,c[b+24>>2]|0);e=c[b+68>>2]|0;rc[c[(c[e>>2]|0)+12>>2]&127](e,j,c[b+24>>2]|0);c[h>>2]=0;e=c[b+8>>2]|0;g=c[b+16>>2]|0}f=f+1|0}while((f|0)<(e|0))}if(!g){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;j=b+12|0;c[j>>2]=0;i=d;return}if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[g+ -4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;j=b+12|0;c[j>>2]=0;i=d;return}function Cu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;g=i;i=i+96|0;k=c[b+8>>2]|0;if((k|0)==(c[b+12>>2]|0)?(h=(k|0)==0?1:k<<1,(k|0)<(h|0)):0){if(!h)j=0;else{c[5004]=(c[5004]|0)+1;j=fF((h<<2|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}k=c[b+8>>2]|0}if((k|0)>0){l=0;do{m=j+(l<<2)|0;if(m)c[m>>2]=c[(c[b+16>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(k|0))}l=c[b+16>>2]|0;if(l){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0);k=c[b+8>>2]|0}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=j;c[b+12>>2]=h}h=(c[b+16>>2]|0)+(k<<2)|0;if(h)c[h>>2]=d;c[b+8>>2]=k+1;c[g+32>>2]=c[d+4>>2];c[g+36>>2]=c[d+8>>2];c[g+40>>2]=c[d+12>>2];c[g+44>>2]=c[d+16>>2];c[g+48>>2]=c[d+20>>2];c[g+52>>2]=c[d+24>>2];c[g+56>>2]=c[d+28>>2];c[g+60>>2]=c[d+32>>2];c[g+64>>2]=c[d+36>>2];c[g+68>>2]=c[d+40>>2];c[g+72>>2]=c[d+44>>2];c[g+76>>2]=c[d+48>>2];c[g+80>>2]=c[d+52>>2];c[g+84>>2]=c[d+56>>2];c[g+88>>2]=c[d+60>>2];c[g+92>>2]=c[d+64>>2];m=c[d+192>>2]|0;vc[c[(c[m>>2]|0)+8>>2]&127](m,g+32|0,g+16|0,g);m=c[b+68>>2]|0;c[d+188>>2]=pc[c[(c[m>>2]|0)+8>>2]&3](m,g+16|0,g,c[(c[d+192>>2]|0)+4>>2]|0,d,e,f,c[b+24>>2]|0,0)|0;i=g;return}function Du(b){b=b|0;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0;d=i;i=i+64|0;yE(7424);q=c[b+8>>2]|0;if((q|0)>0){f=0;do{h=c[(c[b+16>>2]|0)+(f<<2)>>2]|0;if(!((a[b+76>>0]|0)==0?(r=c[h+216>>2]|0,(r|0)==2|(r|0)==5):0)){r=c[h+192>>2]|0;vc[c[(c[r>>2]|0)+8>>2]&127](r,h+4|0,d+48|0,d+32|0);k=+g[d+48>>2]+-.019999999552965164;g[d+48>>2]=k;j=+g[d+52>>2]+-.019999999552965164;g[d+52>>2]=j;n=+g[d+56>>2]+-.019999999552965164;g[d+56>>2]=n;o=+g[d+32>>2]+.019999999552965164;g[d+32>>2]=o;m=+g[d+36>>2]+.019999999552965164;g[d+36>>2]=m;l=+g[d+40>>2]+.019999999552965164;g[d+40>>2]=l;if(((a[b+44>>0]|0)!=0?(c[h+236>>2]|0)==2:0)?(c[h+204>>2]&3|0)==0:0){r=c[h+192>>2]|0;vc[c[(c[r>>2]|0)+8>>2]&127](r,h+68|0,d+16|0,d);k=+g[d+16>>2]+-.019999999552965164;g[d+16>>2]=k;j=+g[d+20>>2]+-.019999999552965164;g[d+20>>2]=j;n=+g[d+24>>2]+-.019999999552965164;g[d+24>>2]=n;o=+g[d>>2]+.019999999552965164;g[d>>2]=o;m=+g[d+4>>2]+.019999999552965164;g[d+4>>2]=m;l=+g[d+8>>2]+.019999999552965164;g[d+8>>2]=l;p=+g[d+48>>2];if(k<p)g[d+48>>2]=k;else k=p;p=+g[d+52>>2];if(j<p)g[d+52>>2]=j;else j=p;p=+g[d+56>>2];if(n<p)g[d+56>>2]=n;else n=p;p=+g[d+28>>2];if(p<+g[d+60>>2])g[d+60>>2]=p;p=+g[d+32>>2];if(p<o)g[d+32>>2]=o;else o=p;p=+g[d+36>>2];if(p<m)g[d+36>>2]=m;else m=p;p=+g[d+40>>2];if(p<l)g[d+40>>2]=l;else l=p;p=+g[d+12>>2];if(+g[d+44>>2]<p)g[d+44>>2]=p}q=c[b+68>>2]|0;if((c[h+204>>2]&1|0)==0?(k=o-k,o=m-j,p=l-n,!(k*k+o*o+p*p<999999995904.0)):0){if(((c[h+216>>2]|0)+ -4|0)>>>0>=2)c[h+216>>2]=5;if((a[7200]|0)!=0?(e=c[b+72>>2]|0,(e|0)!=0):0){a[7200]=0;Nb[c[(c[e>>2]|0)+36>>2]&127](e,7208);r=c[b+72>>2]|0;Nb[c[(c[r>>2]|0)+36>>2]&127](r,7264);r=c[b+72>>2]|0;Nb[c[(c[r>>2]|0)+36>>2]&127](r,7336);r=c[b+72>>2]|0;Nb[c[(c[r>>2]|0)+36>>2]&127](r,7408)}}else Jb[c[(c[q>>2]|0)+16>>2]&31](q,c[h+188>>2]|0,d+48|0,d+32|0,c[b+24>>2]|0);q=c[b+8>>2]|0}f=f+1|0}while((f|0)<(q|0))}b=c[5022]|0;r=(c[b+16>>2]|0)+ -1|0;c[b+16>>2]=r;if(r){i=d;return}do if(c[b+4>>2]|0){Eb(d+48|0,0)|0;r=c[5008]|0;g[b+8>>2]=+(((c[d+52>>2]|0)-(c[r+4>>2]|0)+(((c[d+48>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[b+8>>2];if(!(c[b+16>>2]|0)){b=c[5022]|0;break}else{i=d;return}}while(0);c[5022]=c[b+20>>2];i=d;return}function Eu(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;yE(7440);d=c[a+68>>2]|0;Nb[c[(c[d>>2]|0)+32>>2]&127](d,c[a+24>>2]|0);a=c[5022]|0;d=(c[a+16>>2]|0)+ -1|0;c[a+16>>2]=d;if(d){i=b;return}do if(c[a+4>>2]|0){Eb(b|0,0)|0;d=c[5008]|0;g[a+8>>2]=+(((c[b+4>>2]|0)-(c[d+4>>2]|0)+(((c[b>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[a+8>>2];if(!(c[a+16>>2]|0)){a=c[5022]|0;break}else{i=b;return}}while(0);c[5022]=c[a+20>>2];i=b;return}function Fu(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;yE(7472);Lb[c[(c[a>>2]|0)+8>>2]&511](a);Lb[c[(c[a>>2]|0)+12>>2]&511](a);d=c[a+24>>2]|0;yE(7512);if(d){f=c[(c[d>>2]|0)+32>>2]|0;e=c[a+68>>2]|0;e=Pb[c[(c[e>>2]|0)+36>>2]&127](e)|0;vc[f&127](d,e,a+28|0,c[a+24>>2]|0)}a=c[5022]|0;f=(c[a+16>>2]|0)+ -1|0;c[a+16>>2]=f;do if(!f){if(c[a+4>>2]|0){Eb(b|0,0)|0;d=c[5008]|0;g[a+8>>2]=+(((c[b+4>>2]|0)-(c[d+4>>2]|0)+(((c[b>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[a+8>>2];d=c[5022]|0;if(!(c[a+16>>2]|0))a=d;else{a=d;break}}a=c[a+20>>2]|0;c[5022]=a}while(0);d=a+16|0;f=(c[d>>2]|0)+ -1|0;c[d>>2]=f;if(f){i=b;return}do if(c[a+4>>2]|0){Eb(b|0,0)|0;e=c[5008]|0;f=a+8|0;g[f>>2]=+(((c[b+4>>2]|0)-(c[e+4>>2]|0)+(((c[b>>2]|0)-(c[e>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[f>>2];if(!(c[d>>2]|0)){a=c[5022]|0;break}else{i=b;return}}while(0);c[5022]=c[a+20>>2];i=b;return}function Gu(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;e=i;f=c[b+188>>2]|0;if(f){k=c[a+68>>2]|0;k=Pb[c[(c[k>>2]|0)+36>>2]&127](k)|0;rc[c[(c[k>>2]|0)+40>>2]&127](k,f,c[a+24>>2]|0);k=c[a+68>>2]|0;rc[c[(c[k>>2]|0)+12>>2]&127](k,f,c[a+24>>2]|0);c[b+188>>2]=0}f=c[a+8>>2]|0;if((f|0)<=0){i=e;return}g=c[a+16>>2]|0;h=0;while(1){j=g+(h<<2)|0;k=h+1|0;if((c[j>>2]|0)==(b|0))break;if((k|0)<(f|0))h=k;else{d=9;break}}if((d|0)==9){i=e;return}if((h|0)>=(f|0)){i=e;return}c[j>>2]=c[g+(f+ -1<<2)>>2];c[(c[a+16>>2]|0)+(f+ -1<<2)>>2]=b;c[a+8>>2]=f+ -1;i=e;return}function Hu(d,e,f,h){d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0.0,L=0.0;j=i;i=i+1392|0;c[j+1192>>2]=0;g[j+1196>>2]=1.0;g[j+1200>>2]=1.0;g[j+1204>>2]=1.0;g[j+1208>>2]=0.0;c[j+1184>>2]=16680;c[j+1188>>2]=8;g[j+1212>>2]=0.0;g[j+1228>>2]=0.0;z=c[f+4>>2]|0;y=c[f+12>>2]|0;A=c[z+4>>2]|0;if((A|0)<20){c[j+1008>>2]=9440;c[j+1176>>2]=0;g[j+1180>>2]=0.0;g[j+1172>>2]=+g[h+4>>2];g[j+956>>2]=9999999747378752.0e-20;a[j+980>>0]=0;c[j+632>>2]=17152;c[j+636>>2]=j+648;c[j+640>>2]=j+1184;c[j+644>>2]=z;c[j+616>>2]=13184;c[j+620>>2]=j+648;c[j+624>>2]=j+1184;c[j+628>>2]=z;J=(c[h+16>>2]&8|0)==0?j+632|0:j+616|0;if(!(ac[c[(c[J>>2]|0)+8>>2]&3](J,d,e,y,y,j+1008|0)|0)){i=j;return}y=j+1140|0;m=+g[y>>2];k=+g[j+1144>>2];n=+g[j+1148>>2];if(!(m*m+k*k+n*n>9999999747378752.0e-20)){i=j;return}l=+g[j+1172>>2];if(!(l<+g[h+4>>2])){i=j;return}H=1.0/+Q(+(m*m+k*k+n*n));g[y>>2]=m*H;g[j+1144>>2]=k*H;g[j+1148>>2]=n*H;c[j+584>>2]=c[f+8>>2];c[j+588>>2]=0;c[j+592>>2]=c[y+0>>2];c[j+596>>2]=c[y+4>>2];c[j+600>>2]=c[y+8>>2];c[j+604>>2]=c[y+12>>2];g[j+608>>2]=l;+hc[c[(c[h>>2]|0)+12>>2]&15](h,j+584|0,1);i=j;return}if((A+ -21|0)>>>0<9){t=+g[y>>2];u=+g[y+16>>2];s=+g[y+32>>2];v=+g[y+4>>2];w=+g[y+20>>2];r=+g[y+36>>2];G=+g[y+8>>2];H=+g[y+24>>2];q=+g[y+40>>2];x=-+g[y+48>>2];E=-+g[y+52>>2];F=-+g[y+56>>2];n=+g[d+48>>2];o=+g[d+52>>2];p=+g[d+56>>2];g[j+568>>2]=t*x+u*E+s*F+(t*n+u*o+s*p);g[j+572>>2]=v*x+w*E+r*F+(v*n+w*o+r*p);g[j+576>>2]=G*x+H*E+q*F+(G*n+H*o+q*p);g[j+580>>2]=0.0;l=+g[e+48>>2];k=+g[e+52>>2];m=+g[e+56>>2];s=t*x+u*E+s*F+(t*l+u*k+s*m);r=v*x+w*E+r*F+(v*l+w*k+r*m);q=G*x+H*E+q*F+(G*l+H*k+q*m);g[j+552>>2]=s;g[j+556>>2]=r;g[j+560>>2]=q;g[j+564>>2]=0.0;e=c[z+4>>2]|0;if((e|0)==25){J=c[f+8>>2]|0;I=c[h+16>>2]|0;c[j+316>>2]=c[j+568>>2];c[j+320>>2]=c[j+572>>2];c[j+324>>2]=c[j+576>>2];c[j+328>>2]=c[j+580>>2];c[j+332>>2]=c[j+552>>2];c[j+336>>2]=c[j+556>>2];c[j+340>>2]=c[j+560>>2];c[j+344>>2]=c[j+564>>2];c[j+348>>2]=I;g[j+352>>2]=1.0;c[j+312>>2]=9248;c[j+356>>2]=h;c[j+360>>2]=J;c[j+364>>2]=z;c[j+368>>2]=c[y+0>>2];c[j+372>>2]=c[y+4>>2];c[j+376>>2]=c[y+8>>2];c[j+380>>2]=c[y+12>>2];c[j+384>>2]=c[y+16>>2];c[j+388>>2]=c[y+20>>2];c[j+392>>2]=c[y+24>>2];c[j+396>>2]=c[y+28>>2];c[j+400>>2]=c[y+32>>2];c[j+404>>2]=c[y+36>>2];c[j+408>>2]=c[y+40>>2];c[j+412>>2]=c[y+44>>2];c[j+416>>2]=c[y+48>>2];c[j+420>>2]=c[y+52>>2];c[j+424>>2]=c[y+56>>2];c[j+428>>2]=c[y+60>>2];g[j+352>>2]=+g[h+4>>2];vc[c[(c[z>>2]|0)+144>>2]&127](z,j+312|0,j+568|0,j+552|0);i=j;return}else if((e|0)==21){J=c[f+8>>2]|0;I=c[h+16>>2]|0;c[j+436>>2]=c[j+568>>2];c[j+440>>2]=c[j+572>>2];c[j+444>>2]=c[j+576>>2];c[j+448>>2]=c[j+580>>2];c[j+452>>2]=c[j+552>>2];c[j+456>>2]=c[j+556>>2];c[j+460>>2]=c[j+560>>2];c[j+464>>2]=c[j+564>>2];c[j+468>>2]=I;g[j+472>>2]=1.0;c[j+432>>2]=9248;c[j+476>>2]=h;c[j+480>>2]=J;c[j+484>>2]=z;c[j+488>>2]=c[y+0>>2];c[j+492>>2]=c[y+4>>2];c[j+496>>2]=c[y+8>>2];c[j+500>>2]=c[y+12>>2];c[j+504>>2]=c[y+16>>2];c[j+508>>2]=c[y+20>>2];c[j+512>>2]=c[y+24>>2];c[j+516>>2]=c[y+28>>2];c[j+520>>2]=c[y+32>>2];c[j+524>>2]=c[y+36>>2];c[j+528>>2]=c[y+40>>2];c[j+532>>2]=c[y+44>>2];c[j+536>>2]=c[y+48>>2];c[j+540>>2]=c[y+52>>2];c[j+544>>2]=c[y+56>>2];c[j+548>>2]=c[y+60>>2];g[j+472>>2]=+g[h+4>>2];h=c[z+48>>2]|0;c[j+1272>>2]=6152;c[j+1276>>2]=h;c[j+1280>>2]=j+432;h=c[z+52>>2]|0;c[j+1328>>2]=0;c[j+1332>>2]=0;c[j+1336>>2]=0;c[j+1340>>2]=0;c[j+1304>>2]=0;c[j+1308>>2]=0;c[j+1312>>2]=0;c[j+1316>>2]=0;if(!(a[h+60>>0]|0)){OA(h,j+1272|0,j+568|0,s,r,q,j+1328|0,j+1304|0);i=j;return}else{PA(h,j+1272|0,j+568|0,s,r,q,j+1328|0,j+1304|0,c[h+56>>2]|0);i=j;return}}else{L=+g[y>>2];K=+g[y+16>>2];s=+g[y+32>>2];t=+g[y+4>>2];u=+g[y+20>>2];v=+g[y+36>>2];F=+g[y+8>>2];G=+g[y+24>>2];H=+g[y+40>>2];w=-+g[y+48>>2];x=-+g[y+52>>2];E=-+g[y+56>>2];r=L*w+K*x+s*E+(L*n+K*o+s*p);q=t*w+u*x+v*E+(t*n+u*o+v*p);o=F*w+G*x+H*E+(F*n+G*o+H*p);p=L*w+K*x+s*E+(L*l+K*k+s*m);n=t*w+u*x+v*E+(t*l+u*k+v*m);k=F*w+G*x+H*E+(F*l+G*k+H*m);J=c[f+8>>2]|0;I=c[h+16>>2]|0;g[j+196>>2]=r;g[j+200>>2]=q;g[j+204>>2]=o;g[j+208>>2]=0.0;g[j+212>>2]=p;g[j+216>>2]=n;g[j+220>>2]=k;g[j+224>>2]=0.0;c[j+228>>2]=I;g[j+232>>2]=1.0;c[j+192>>2]=9056;c[j+236>>2]=h;c[j+240>>2]=J;c[j+244>>2]=z;c[j+248>>2]=c[y+0>>2];c[j+252>>2]=c[y+4>>2];c[j+256>>2]=c[y+8>>2];c[j+260>>2]=c[y+12>>2];c[j+264>>2]=c[y+16>>2];c[j+268>>2]=c[y+20>>2];c[j+272>>2]=c[y+24>>2];c[j+276>>2]=c[y+28>>2];c[j+280>>2]=c[y+32>>2];c[j+284>>2]=c[y+36>>2];c[j+288>>2]=c[y+40>>2];c[j+292>>2]=c[y+44>>2];c[j+296>>2]=c[y+48>>2];c[j+300>>2]=c[y+52>>2];c[j+304>>2]=c[y+56>>2];c[j+308>>2]=c[y+60>>2];g[j+232>>2]=+g[h+4>>2];g[j+176>>2]=r;g[j+180>>2]=q;g[j+184>>2]=o;g[j+188>>2]=0.0;if(p<r)g[j+176>>2]=p;if(n<q)g[j+180>>2]=n;if(k<o)g[j+184>>2]=k;g[j+160>>2]=r;g[j+164>>2]=q;g[j+168>>2]=o;g[j+172>>2]=0.0;if(r<p)g[j+160>>2]=p;if(q<n)g[j+164>>2]=n;if(o<k)g[j+168>>2]=k;vc[c[(c[z>>2]|0)+64>>2]&127](z,j+192|0,j+176|0,j+160|0);i=j;return}}if((A|0)!=31){i=j;return}A=c[z+64>>2]|0;J=c[f+8>>2]|0;c[j+128>>2]=8840;c[j+132>>2]=J;c[j+136>>2]=z;c[j+140>>2]=y;c[j+144>>2]=d;c[j+148>>2]=e;c[j+152>>2]=h;if(!A){h=c[z+16>>2]|0;if((h|0)<=0){i=j;return}f=0;while(1){J=c[z+24>>2]|0;I=c[J+(f*80|0)+64>>2]|0;no(j+1328|0,y,J+(f*80|0)|0);J=c[j+132>>2]|0;c[j+1304>>2]=0;c[j+1308>>2]=I;c[j+1312>>2]=J;c[j+1316>>2]=j+1328;c[j+1320>>2]=-1;c[j+1324>>2]=f;J=c[j+152>>2]|0;g[j+1276>>2]=1.0;c[j+1280>>2]=0;b[j+1284>>1]=1;b[j+1286>>1]=-1;c[j+1288>>2]=0;c[j+1272>>2]=8664;c[j+1292>>2]=J;c[j+1296>>2]=f;g[j+1276>>2]=+g[J+4>>2];c[j+1288>>2]=c[J+16>>2];Hu(c[j+144>>2]|0,c[j+148>>2]|0,j+1304|0,j+1272|0);f=f+1|0;if((f|0)>=(h|0))break;z=c[j+136>>2]|0;y=c[j+140>>2]|0}i=j;return}Ju(j+64|0,y,d);p=+g[j+112>>2];q=+g[j+116>>2];o=+g[j+120>>2];Ju(j,y,e);z=c[A>>2]|0;if(!z){i=j;return}r=+g[j+48>>2]-p;t=+g[j+52>>2]-q;u=+g[j+56>>2]-o;s=1.0/+Q(+(r*r+t*t+u*u));if(r*s==0.0)v=999999984306749400.0;else v=1.0/(r*s);if(t*s==0.0)w=999999984306749400.0;else w=1.0/(t*s);if(u*s==0.0)x=999999984306749400.0;else x=1.0/(u*s);h=v<0.0&1;y=w<0.0&1;f=x<0.0&1;c[5004]=(c[5004]|0)+1;e=fF(531)|0;if(!e)C=0;else{c[(e+19&-16)+ -4>>2]=e;C=e+19&-16}d=0;do{e=C+(d<<2)|0;if(e)c[e>>2]=0;d=d+1|0}while((d|0)!=128);c[C>>2]=z;A=128;D=128;z=1;B=126;do{e=z+ -1|0;d=c[C+(e<<2)>>2]|0;c[j+1240>>2]=c[d+0>>2];c[j+1244>>2]=c[d+4>>2];c[j+1248>>2]=c[d+8>>2];c[j+1252>>2]=c[d+12>>2];c[j+1256>>2]=c[d+16>>2];c[j+1260>>2]=c[d+20>>2];c[j+1264>>2]=c[d+24>>2];c[j+1268>>2]=c[d+28>>2];G=v*(+g[j+1240+(h<<4)>>2]-p);E=v*(+g[j+1240+((h^1)<<4)>>2]-p);H=w*(+g[j+1240+(y<<4)+4>>2]-q);F=w*(+g[j+1240+((y^1)<<4)+4>>2]-q);do if(((!(G>F|H>E)?(n=H>G?H:G,l=F<E?F:E,m=x*(+g[j+1240+(f<<4)+8>>2]-o),k=x*(+g[j+1240+((f^1)<<4)+8>>2]-o),!(n>k|m>l)):0)?(m>n?m:n)<r*s*r+t*s*t+u*s*u:0)?(k<l?k:l)>0.0:0){if(!(c[d+40>>2]|0)){Nb[c[(c[j+128>>2]|0)+12>>2]&127](j+128|0,d);z=e;break}if((e|0)>(B|0)){B=A<<1;if((A|0)<(B|0)){do if((D|0)<(B|0)){do if(!A)D=0;else{c[5004]=(c[5004]|0)+1;D=fF((A<<3|3)+16|0)|0;if(!D)D=0;else{c[(D+19&-16)+ -4>>2]=D;D=D+19&-16}if((A|0)>0)I=0;else break;do{J=D+(I<<2)|0;if(J)c[J>>2]=c[C+(I<<2)>>2];I=I+1|0}while((I|0)!=(A|0))}while(0);if(!C){C=D;D=B;break}c[5006]=(c[5006]|0)+1;gF(c[C+ -4>>2]|0);C=D;D=B}while(0);do{I=C+(A<<2)|0;if(I)c[I>>2]=0;A=A+1|0}while((A|0)!=(B|0))}A=B;B=B+ -2|0}c[C+(e<<2)>>2]=c[d+36>>2];c[C+(z<<2)>>2]=c[d+40>>2];z=z+1|0}else z=e;while(0)}while((z|0)!=0);if(!C){i=j;return}c[5006]=(c[5006]|0)+1;gF(c[C+ -4>>2]|0);i=j;return}function Iu(a){a=a|0;return}function Ju(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;j=+g[c+48>>2]- +g[b+48>>2];h=+g[c+52>>2]- +g[b+52>>2];e=+g[c+56>>2]- +g[b+56>>2];p=+g[b>>2];y=+g[c>>2];o=+g[b+16>>2];x=+g[c+16>>2];n=+g[b+32>>2];w=+g[c+32>>2];v=+g[c+4>>2];u=+g[c+20>>2];t=+g[c+36>>2];s=+g[c+8>>2];r=+g[c+24>>2];q=+g[c+40>>2];m=+g[b+4>>2];l=+g[b+20>>2];k=+g[b+36>>2];i=+g[b+8>>2];f=+g[b+24>>2];d=+g[b+40>>2];g[a>>2]=p*y+o*x+n*w;g[a+4>>2]=p*v+o*u+n*t;g[a+8>>2]=p*s+o*r+n*q;g[a+12>>2]=0.0;g[a+16>>2]=y*m+x*l+w*k;g[a+20>>2]=v*m+u*l+t*k;g[a+24>>2]=s*m+r*l+q*k;g[a+28>>2]=0.0;g[a+32>>2]=y*i+x*f+w*d;g[a+36>>2]=v*i+u*f+t*d;g[a+40>>2]=s*i+r*f+q*d;g[a+44>>2]=0.0;g[a+48>>2]=j*p+h*o+e*n;g[a+52>>2]=j*m+h*l+e*k;g[a+56>>2]=j*i+h*f+e*d;g[a+60>>2]=0.0;return}function Ku(d,e,f,h,j,k){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;var l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0;l=i;i=i+1664|0;m=c[h+4>>2]|0;n=c[h+12>>2]|0;D=c[m+4>>2]|0;if((D|0)<20){c[l+1424>>2]=9440;c[l+1592>>2]=0;g[l+1596>>2]=k;g[l+1588>>2]=+g[j+4>>2];g[l+1372>>2]=9999999747378752.0e-20;a[l+1396>>0]=0;c[l+1056>>2]=13248;c[l+1032>>2]=10152;c[l+1036>>2]=l+1064;c[l+1040>>2]=l+1056;c[l+1044>>2]=d;c[l+1048>>2]=m;c[l+1052>>2]=0;if(!(xw(l+1032|0,e,f,n,n,l+1424|0)|0)){i=l;return}m=l+1556|0;q=+g[m>>2];p=+g[l+1560>>2];o=+g[l+1564>>2];if(!(q*q+p*p+o*o>9999999747378752.0e-20)){i=l;return}k=+g[l+1588>>2];if(!(k<+g[j+4>>2])){i=l;return}C=1.0/+Q(+(q*q+p*p+o*o));g[m>>2]=q*C;g[l+1560>>2]=p*C;g[l+1564>>2]=o*C;c[l+984>>2]=c[h+8>>2];c[l+988>>2]=0;c[l+992>>2]=c[m+0>>2];c[l+996>>2]=c[m+4>>2];c[l+1e3>>2]=c[m+8>>2];c[l+1004>>2]=c[m+12>>2];c[l+1008>>2]=c[l+1572>>2];c[l+1012>>2]=c[l+1576>>2];c[l+1016>>2]=c[l+1580>>2];c[l+1020>>2]=c[l+1584>>2];g[l+1024>>2]=k;+hc[c[(c[j>>2]|0)+12>>2]&15](j,l+984|0,1);i=l;return}if((D+ -21|0)>>>0>=9){if((D|0)!=31){i=l;return}yE(7544);if((c[m+16>>2]|0)>0){D=0;do{F=c[m+24>>2]|0;o=+g[F+(D*80|0)>>2];r=+g[F+(D*80|0)+4>>2];u=+g[F+(D*80|0)+8>>2];p=+g[F+(D*80|0)+16>>2];s=+g[F+(D*80|0)+20>>2];w=+g[F+(D*80|0)+24>>2];q=+g[F+(D*80|0)+32>>2];t=+g[F+(D*80|0)+36>>2];y=+g[F+(D*80|0)+40>>2];N=+g[F+(D*80|0)+48>>2];M=+g[F+(D*80|0)+52>>2];C=+g[F+(D*80|0)+56>>2];F=c[F+(D*80|0)+64>>2]|0;L=+g[n>>2];K=+g[n+4>>2];J=+g[n+8>>2];I=+g[n+16>>2];H=+g[n+20>>2];G=+g[n+24>>2];v=+g[n+32>>2];x=+g[n+36>>2];z=+g[n+40>>2];A=N*L+M*K+C*J+ +g[n+48>>2];B=N*I+M*H+C*G+ +g[n+52>>2];C=N*v+M*x+C*z+ +g[n+56>>2];g[l+1600>>2]=o*L+p*K+q*J;g[l+1604>>2]=r*L+s*K+t*J;g[l+1608>>2]=u*L+w*K+y*J;g[l+1612>>2]=0.0;g[l+1616>>2]=o*I+p*H+q*G;g[l+1620>>2]=r*I+s*H+t*G;g[l+1624>>2]=u*I+w*H+y*G;g[l+1628>>2]=0.0;g[l+1632>>2]=o*v+p*x+q*z;g[l+1636>>2]=r*v+s*x+t*z;g[l+1640>>2]=u*v+w*x+y*z;g[l+1644>>2]=0.0;g[l+1648>>2]=A;g[l+1652>>2]=B;g[l+1656>>2]=C;g[l+1660>>2]=0.0;b[l+32>>1]=1;b[l+34>>1]=-1;c[l+24>>2]=8024;c[l+36>>2]=j;c[l+40>>2]=D;g[l+28>>2]=+g[j+4>>2];E=c[h+8>>2]|0;c[l>>2]=h;c[l+4>>2]=F;c[l+8>>2]=E;c[l+12>>2]=l+1600;c[l+16>>2]=-1;c[l+20>>2]=D;Ku(d,e,f,l,l+24|0,k);D=D+1|0}while((D|0)<(c[m+16>>2]|0))}h=c[5022]|0;F=(c[h+16>>2]|0)+ -1|0;c[h+16>>2]=F;if(F){i=l;return}do if(c[h+4>>2]|0){Eb(l+1600|0,0)|0;F=c[5008]|0;g[h+8>>2]=+(((c[l+1604>>2]|0)-(c[F+4>>2]|0)+(((c[l+1600>>2]|0)-(c[F>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3+ +g[h+8>>2];if(!(c[h+16>>2]|0)){h=c[5022]|0;break}else{i=l;return}}while(0);c[5022]=c[h+20>>2];i=l;return}if((D|0)==21){v=+g[n>>2];p=+g[n+16>>2];q=+g[n+32>>2];r=+g[n+4>>2];s=+g[n+20>>2];t=+g[n+36>>2];C=+g[n+8>>2];A=+g[n+24>>2];y=+g[n+40>>2];u=-+g[n+48>>2];o=-+g[n+52>>2];w=-+g[n+56>>2];x=+g[e+48>>2];z=+g[e+52>>2];B=+g[e+56>>2];g[l+968>>2]=v*u+p*o+q*w+(v*x+p*z+q*B);g[l+972>>2]=r*u+s*o+t*w+(r*x+s*z+t*B);g[l+976>>2]=C*u+A*o+y*w+(C*x+A*z+y*B);g[l+980>>2]=0.0;B=+g[f+48>>2];z=+g[f+52>>2];x=+g[f+56>>2];O=+g[f>>2];G=+g[f+16>>2];H=+g[f+32>>2];I=+g[f+4>>2];J=+g[f+20>>2];K=+g[f+36>>2];L=+g[f+8>>2];M=+g[f+24>>2];N=+g[f+40>>2];g[l+904>>2]=v*O+p*G+q*H;g[l+908>>2]=v*I+p*J+q*K;g[l+912>>2]=v*L+p*M+q*N;g[l+916>>2]=0.0;g[l+920>>2]=r*O+s*G+t*H;g[l+924>>2]=r*I+s*J+t*K;g[l+928>>2]=r*L+s*M+t*N;g[l+932>>2]=0.0;g[l+936>>2]=C*O+A*G+y*H;g[l+940>>2]=C*I+A*J+y*K;g[l+944>>2]=C*L+A*M+y*N;F=l+948|0;c[F+0>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;c[F+12>>2]=0;c[F+16>>2]=0;h=c[h+8>>2]|0;N=+$b[c[(c[m>>2]|0)+48>>2]&15](m);c[l+680>>2]=16256;c[l+684>>2]=d;c[l+688>>2]=c[e+0>>2];c[l+692>>2]=c[e+4>>2];c[l+696>>2]=c[e+8>>2];c[l+700>>2]=c[e+12>>2];c[l+704>>2]=c[e+16>>2];c[l+708>>2]=c[e+20>>2];c[l+712>>2]=c[e+24>>2];c[l+716>>2]=c[e+28>>2];c[l+720>>2]=c[e+32>>2];c[l+724>>2]=c[e+36>>2];c[l+728>>2]=c[e+40>>2];c[l+732>>2]=c[e+44>>2];c[l+736>>2]=c[e+48>>2];c[l+740>>2]=c[e+52>>2];c[l+744>>2]=c[e+56>>2];c[l+748>>2]=c[e+60>>2];c[l+752>>2]=c[f+0>>2];c[l+756>>2]=c[f+4>>2];c[l+760>>2]=c[f+8>>2];c[l+764>>2]=c[f+12>>2];c[l+768>>2]=c[f+16>>2];c[l+772>>2]=c[f+20>>2];c[l+776>>2]=c[f+24>>2];c[l+780>>2]=c[f+28>>2];c[l+784>>2]=c[f+32>>2];c[l+788>>2]=c[f+36>>2];c[l+792>>2]=c[f+40>>2];c[l+796>>2]=c[f+44>>2];c[l+800>>2]=c[f+48>>2];c[l+804>>2]=c[f+52>>2];c[l+808>>2]=c[f+56>>2];c[l+812>>2]=c[f+60>>2];c[l+816>>2]=c[n+0>>2];c[l+820>>2]=c[n+4>>2];c[l+824>>2]=c[n+8>>2];c[l+828>>2]=c[n+12>>2];c[l+832>>2]=c[n+16>>2];c[l+836>>2]=c[n+20>>2];c[l+840>>2]=c[n+24>>2];c[l+844>>2]=c[n+28>>2];c[l+848>>2]=c[n+32>>2];c[l+852>>2]=c[n+36>>2];c[l+856>>2]=c[n+40>>2];c[l+860>>2]=c[n+44>>2];c[l+864>>2]=c[n+48>>2];c[l+868>>2]=c[n+52>>2];c[l+872>>2]=c[n+56>>2];c[l+876>>2]=c[n+60>>2];g[l+884>>2]=N;c[l+680>>2]=8448;c[l+892>>2]=j;c[l+896>>2]=h;c[l+900>>2]=m;g[l+880>>2]=+g[j+4>>2];g[l+888>>2]=k;vc[c[(c[d>>2]|0)+8>>2]&127](d,l+904|0,l+664|0,l+648|0);h=c[m+48>>2]|0;c[l+1600>>2]=5992;c[l+1604>>2]=h;c[l+1608>>2]=l+680;h=c[m+52>>2]|0;if(!(a[h+60>>0]|0)){OA(h,l+1600|0,l+968|0,v*u+p*o+q*w+(v*B+p*z+q*x),r*u+s*o+t*w+(r*B+s*z+t*x),C*u+A*o+y*w+(C*B+A*z+y*x),l+664|0,l+648|0);i=l;return}else{PA(h,l+1600|0,l+968|0,v*u+p*o+q*w+(v*B+p*z+q*x),r*u+s*o+t*w+(r*B+s*z+t*x),C*u+A*o+y*w+(C*B+A*z+y*x),l+664|0,l+648|0,c[h+56>>2]|0);i=l;return}}else if((D|0)==28){c[l+472>>2]=9440;c[l+640>>2]=0;g[l+644>>2]=k;g[l+636>>2]=+g[j+4>>2];c[l+448>>2]=10152;c[l+452>>2]=0;c[l+456>>2]=0;c[l+460>>2]=d;c[l+464>>2]=0;c[l+468>>2]=m;if(!(xw(l+448|0,e,f,n,n,l+472|0)|0)){i=l;return}m=l+604|0;k=+g[m>>2];o=+g[l+608>>2];p=+g[l+612>>2];if(!(k*k+o*o+p*p>9999999747378752.0e-20)){i=l;return}q=+g[l+636>>2];if(!(q<+g[j+4>>2])){i=l;return}O=1.0/+Q(+(k*k+o*o+p*p));g[m>>2]=k*O;g[l+608>>2]=o*O;g[l+612>>2]=p*O;c[l+400>>2]=c[h+8>>2];c[l+404>>2]=0;c[l+408>>2]=c[m+0>>2];c[l+412>>2]=c[m+4>>2];c[l+416>>2]=c[m+8>>2];c[l+420>>2]=c[m+12>>2];c[l+424>>2]=c[l+620>>2];c[l+428>>2]=c[l+624>>2];c[l+432>>2]=c[l+628>>2];c[l+436>>2]=c[l+632>>2];g[l+440>>2]=q;+hc[c[(c[j>>2]|0)+12>>2]&15](j,l+400|0,1);i=l;return}else{u=+g[n>>2];v=+g[n+16>>2];w=+g[n+32>>2];x=+g[n+4>>2];y=+g[n+20>>2];z=+g[n+36>>2];J=+g[n+8>>2];L=+g[n+24>>2];N=+g[n+40>>2];H=-+g[n+48>>2];G=-+g[n+52>>2];C=-+g[n+56>>2];A=+g[e+48>>2];B=+g[e+52>>2];p=+g[e+56>>2];t=u*H+v*G+w*C+(u*A+v*B+w*p);q=x*H+y*G+z*C+(x*A+y*B+z*p);p=J*H+L*G+N*C+(J*A+L*B+N*p);B=+g[f+48>>2];A=+g[f+52>>2];o=+g[f+56>>2];s=u*H+v*G+w*C+(u*B+v*A+w*o);r=x*H+y*G+z*C+(x*B+y*A+z*o);o=J*H+L*G+N*C+(J*B+L*A+N*o);A=+g[f>>2];B=+g[f+16>>2];C=+g[f+32>>2];G=+g[f+4>>2];H=+g[f+20>>2];I=+g[f+36>>2];K=+g[f+8>>2];M=+g[f+24>>2];O=+g[f+40>>2];g[l+336>>2]=u*A+v*B+w*C;g[l+340>>2]=u*G+v*H+w*I;g[l+344>>2]=u*K+v*M+w*O;g[l+348>>2]=0.0;g[l+352>>2]=x*A+y*B+z*C;g[l+356>>2]=x*G+y*H+z*I;g[l+360>>2]=x*K+y*M+z*O;g[l+364>>2]=0.0;g[l+368>>2]=J*A+L*B+N*C;g[l+372>>2]=J*G+L*H+N*I;g[l+376>>2]=J*K+L*M+N*O;F=l+380|0;c[F+0>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;c[F+12>>2]=0;c[F+16>>2]=0;F=c[h+8>>2]|0;O=+$b[c[(c[m>>2]|0)+48>>2]&15](m);c[l+112>>2]=16256;c[l+116>>2]=d;c[l+120>>2]=c[e+0>>2];c[l+124>>2]=c[e+4>>2];c[l+128>>2]=c[e+8>>2];c[l+132>>2]=c[e+12>>2];c[l+136>>2]=c[e+16>>2];c[l+140>>2]=c[e+20>>2];c[l+144>>2]=c[e+24>>2];c[l+148>>2]=c[e+28>>2];c[l+152>>2]=c[e+32>>2];c[l+156>>2]=c[e+36>>2];c[l+160>>2]=c[e+40>>2];c[l+164>>2]=c[e+44>>2];c[l+168>>2]=c[e+48>>2];c[l+172>>2]=c[e+52>>2];c[l+176>>2]=c[e+56>>2];c[l+180>>2]=c[e+60>>2];c[l+184>>2]=c[f+0>>2];c[l+188>>2]=c[f+4>>2];c[l+192>>2]=c[f+8>>2];c[l+196>>2]=c[f+12>>2];c[l+200>>2]=c[f+16>>2];c[l+204>>2]=c[f+20>>2];c[l+208>>2]=c[f+24>>2];c[l+212>>2]=c[f+28>>2];c[l+216>>2]=c[f+32>>2];c[l+220>>2]=c[f+36>>2];c[l+224>>2]=c[f+40>>2];c[l+228>>2]=c[f+44>>2];c[l+232>>2]=c[f+48>>2];c[l+236>>2]=c[f+52>>2];c[l+240>>2]=c[f+56>>2];c[l+244>>2]=c[f+60>>2];c[l+248>>2]=c[n+0>>2];c[l+252>>2]=c[n+4>>2];c[l+256>>2]=c[n+8>>2];c[l+260>>2]=c[n+12>>2];c[l+264>>2]=c[n+16>>2];c[l+268>>2]=c[n+20>>2];c[l+272>>2]=c[n+24>>2];c[l+276>>2]=c[n+28>>2];c[l+280>>2]=c[n+32>>2];c[l+284>>2]=c[n+36>>2];c[l+288>>2]=c[n+40>>2];c[l+292>>2]=c[n+44>>2];c[l+296>>2]=c[n+48>>2];c[l+300>>2]=c[n+52>>2];c[l+304>>2]=c[n+56>>2];c[l+308>>2]=c[n+60>>2];g[l+316>>2]=O;c[l+112>>2]=8224;c[l+324>>2]=j;c[l+328>>2]=F;c[l+332>>2]=m;g[l+312>>2]=+g[j+4>>2];g[l+320>>2]=k;vc[c[(c[d>>2]|0)+8>>2]&127](d,l+336|0,l+96|0,l+80|0);g[l+64>>2]=t;g[l+68>>2]=q;g[l+72>>2]=p;g[l+76>>2]=0.0;if(s<t){g[l+64>>2]=s;v=s}else v=t;if(r<q){g[l+68>>2]=r;u=r}else u=q;if(o<p){g[l+72>>2]=o;k=o}else k=p;g[l+48>>2]=t;g[l+52>>2]=q;g[l+56>>2]=p;g[l+60>>2]=0.0;if(t<s)g[l+48>>2]=s;else s=t;if(q<r){g[l+52>>2]=r;q=r}if(p<o)g[l+56>>2]=o;else o=p;g[l+64>>2]=+g[l+96>>2]+v;g[l+68>>2]=+g[l+100>>2]+u;g[l+72>>2]=+g[l+104>>2]+k;g[l+48>>2]=+g[l+80>>2]+s;g[l+52>>2]=+g[l+84>>2]+q;g[l+56>>2]=+g[l+88>>2]+o;vc[c[(c[m>>2]|0)+64>>2]&127](m,l+112|0,l+64|0,l+48|0);i=l;return}}function Lu(a){a=a|0;return}function Mu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;j=i;i=i+256|0;c[j+32>>2]=7960;h=j+68|0;c[h+0>>2]=c[b+0>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];c[h+12>>2]=c[b+12>>2];f=j+84|0;c[f+0>>2]=c[d+0>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[j+244>>2]=a;c[j+248>>2]=e;g[j+100>>2]=1.0;c[j+104>>2]=0;c[j+108>>2]=0;c[j+112>>2]=0;c[j+116>>2]=0;g[j+120>>2]=1.0;c[j+124>>2]=0;c[j+128>>2]=0;c[j+132>>2]=0;c[j+136>>2]=0;g[j+140>>2]=1.0;c[j+144>>2]=0;c[j+148>>2]=c[h+0>>2];c[j+152>>2]=c[h+4>>2];c[j+156>>2]=c[h+8>>2];c[j+160>>2]=c[h+12>>2];g[j+164>>2]=1.0;c[j+168>>2]=0;c[j+172>>2]=0;c[j+176>>2]=0;c[j+180>>2]=0;g[j+184>>2]=1.0;c[j+188>>2]=0;c[j+192>>2]=0;c[j+196>>2]=0;c[j+200>>2]=0;g[j+204>>2]=1.0;c[j+208>>2]=0;c[j+212>>2]=c[d+0>>2];c[j+216>>2]=c[d+4>>2];c[j+220>>2]=c[d+8>>2];c[j+224>>2]=c[d+12>>2];n=+g[d>>2]- +g[b>>2];k=+g[d+4>>2]- +g[b+4>>2];q=+g[d+8>>2]- +g[b+8>>2];l=1.0/+Q(+(n*n+k*k+q*q));if(n*l==0.0)p=999999984306749400.0;else p=1.0/(n*l);g[j+36>>2]=p;if(k*l==0.0)o=999999984306749400.0;else o=1.0/(k*l);g[j+40>>2]=o;if(q*l==0.0)m=999999984306749400.0;else m=1.0/(q*l);g[j+44>>2]=m;c[j+52>>2]=p<0.0&1;c[j+56>>2]=o<0.0&1;c[j+60>>2]=m<0.0&1;g[j+64>>2]=n*l*(+g[f>>2]- +g[h>>2])+k*l*(+g[j+88>>2]- +g[j+72>>2])+q*l*(+g[j+92>>2]- +g[j+76>>2]);e=c[a+68>>2]|0;h=c[(c[e>>2]|0)+24>>2]|0;c[j+16>>2]=0;c[j+20>>2]=0;c[j+24>>2]=0;c[j+28>>2]=0;c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;Zb[h&7](e,b,d,j+32|0,j+16|0,j);i=j;return}function Nu(a){a=a|0;return}function Ou(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0.0,v=0;j=i;i=i+416|0;yE(7568);c[j+144>>2]=c[d+0>>2];c[j+148>>2]=c[d+4>>2];c[j+152>>2]=c[d+8>>2];c[j+156>>2]=c[d+12>>2];c[j+160>>2]=c[d+16>>2];c[j+164>>2]=c[d+20>>2];c[j+168>>2]=c[d+24>>2];c[j+172>>2]=c[d+28>>2];c[j+176>>2]=c[d+32>>2];c[j+180>>2]=c[d+36>>2];c[j+184>>2]=c[d+40>>2];c[j+188>>2]=c[d+44>>2];k=j+192|0;c[k+0>>2]=c[d+48>>2];c[k+4>>2]=c[d+52>>2];c[k+8>>2]=c[d+56>>2];c[k+12>>2]=c[d+60>>2];c[j+80>>2]=c[e+0>>2];c[j+84>>2]=c[e+4>>2];c[j+88>>2]=c[e+8>>2];c[j+92>>2]=c[e+12>>2];c[j+96>>2]=c[e+16>>2];c[j+100>>2]=c[e+20>>2];c[j+104>>2]=c[e+24>>2];c[j+108>>2]=c[e+28>>2];c[j+112>>2]=c[e+32>>2];c[j+116>>2]=c[e+36>>2];c[j+120>>2]=c[e+40>>2];c[j+124>>2]=c[e+44>>2];l=j+128|0;c[l+0>>2]=c[e+48>>2];c[l+4>>2]=c[e+52>>2];c[l+8>>2]=c[e+56>>2];c[l+12>>2]=c[e+60>>2];Lo(j+144|0,j+80|0,j+212|0,j+208|0);u=+g[j+208>>2];m=u*+g[j+216>>2];r=u*+g[j+220>>2];g[j+32>>2]=+g[j+212>>2]*u;g[j+36>>2]=m;g[j+40>>2]=r;g[j+44>>2]=0.0;c[j+16>>2]=0;c[j+20>>2]=0;c[j+24>>2]=0;c[j+28>>2]=0;g[j+212>>2]=1.0;v=j+216|0;c[v+0>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;c[v+12>>2]=0;g[j+232>>2]=1.0;t=j+236|0;c[t+0>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;c[t+12>>2]=0;g[j+252>>2]=1.0;s=j+256|0;c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;Hc(j+144|0,j);r=+g[j>>2];m=+g[j+4>>2];u=+g[j+8>>2];q=+g[j+12>>2];o=r*(2.0/(r*r+m*m+u*u+q*q));n=m*(2.0/(r*r+m*m+u*u+q*q));p=u*(2.0/(r*r+m*m+u*u+q*q));g[j+212>>2]=1.0-(m*n+u*p);g[v>>2]=r*n-q*p;g[j+220>>2]=r*p+q*n;g[j+224>>2]=0.0;g[j+228>>2]=r*n+q*p;g[j+232>>2]=1.0-(r*o+u*p);g[t>>2]=m*p-q*o;g[j+240>>2]=0.0;g[j+244>>2]=r*p-q*n;g[j+248>>2]=m*p+q*o;g[j+252>>2]=1.0-(r*o+m*n);g[s>>2]=0.0;wu(b,j+212|0,j+16|0,j+32|0,j+64|0,j+48|0);c[j+212>>2]=7848;c[j+248>>2]=c[d+0>>2];c[j+252>>2]=c[d+4>>2];c[j+256>>2]=c[d+8>>2];c[j+260>>2]=c[d+12>>2];c[j+264>>2]=c[d+16>>2];c[j+268>>2]=c[d+20>>2];c[j+272>>2]=c[d+24>>2];c[j+276>>2]=c[d+28>>2];c[j+280>>2]=c[d+32>>2];c[j+284>>2]=c[d+36>>2];c[j+288>>2]=c[d+40>>2];c[j+292>>2]=c[d+44>>2];s=j+296|0;c[s+0>>2]=c[d+48>>2];c[s+4>>2]=c[d+52>>2];c[s+8>>2]=c[d+56>>2];c[s+12>>2]=c[d+60>>2];c[j+312>>2]=c[e+0>>2];c[j+316>>2]=c[e+4>>2];c[j+320>>2]=c[e+8>>2];c[j+324>>2]=c[e+12>>2];c[j+328>>2]=c[e+16>>2];c[j+332>>2]=c[e+20>>2];c[j+336>>2]=c[e+24>>2];c[j+340>>2]=c[e+28>>2];c[j+344>>2]=c[e+32>>2];c[j+348>>2]=c[e+36>>2];c[j+352>>2]=c[e+40>>2];c[j+356>>2]=c[e+44>>2];d=j+360|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];c[j+392>>2]=a;c[j+396>>2]=f;g[j+400>>2]=h;c[j+404>>2]=b;n=+g[d>>2]- +g[s>>2];h=+g[j+364>>2]- +g[j+300>>2];m=+g[j+368>>2]- +g[j+304>>2];o=1.0/+Q(+(n*n+h*h+m*m));if(n*o==0.0)p=999999984306749400.0;else p=1.0/(n*o);g[j+216>>2]=p;if(h*o==0.0)q=999999984306749400.0;else q=1.0/(h*o);g[j+220>>2]=q;if(m*o==0.0)r=999999984306749400.0;else r=1.0/(m*o);g[j+224>>2]=r;c[j+232>>2]=p<0.0&1;c[j+236>>2]=q<0.0&1;c[j+240>>2]=r<0.0&1;g[j+244>>2]=m*m*o+(n*n*o+h*h*o);v=c[a+68>>2]|0;Zb[c[(c[v>>2]|0)+24>>2]&7](v,k,l,j+212|0,j+64|0,j+48|0);k=c[5022]|0;v=(c[k+16>>2]|0)+ -1|0;c[k+16>>2]=v;if(v){i=j;return}do if(c[k+4>>2]|0){Eb(j+212|0,0)|0;v=c[5008]|0;g[k+8>>2]=+(((c[j+216>>2]|0)-(c[v+4>>2]|0)+(((c[j+212>>2]|0)-(c[v>>2]|0)|0)*1e6|0)-(c[k+12>>2]|0)|0)>>>0)/1.0e3+ +g[k+8>>2];if(!(c[k+16>>2]|0)){k=c[5022]|0;break}else{i=j;return}}while(0);c[5022]=c[k+20>>2];i=j;return}function Pu(a){a=a|0;return}function Qu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+96|0;g=c[b+192>>2]|0;c[f+64>>2]=0;c[f+68>>2]=g;c[f+72>>2]=b;c[f+76>>2]=b+4;c[f+80>>2]=-1;c[f+84>>2]=-1;b=c[d+192>>2]|0;c[f+40>>2]=0;c[f+44>>2]=b;c[f+48>>2]=d;c[f+52>>2]=d+4;c[f+56>>2]=-1;c[f+60>>2]=-1;d=c[a+24>>2]|0;d=Tb[c[(c[d>>2]|0)+8>>2]&31](d,f+64|0,f+40|0,0)|0;if(!d){i=f;return}c[f+4>>2]=0;c[f+8>>2]=f+64;c[f+12>>2]=f+40;c[f>>2]=7728;c[f+32>>2]=e;Jb[c[(c[d>>2]|0)+8>>2]&31](d,f+64|0,f+40|0,a+28|0,f);Lb[c[c[d>>2]>>2]&511](d);g=c[a+24>>2]|0;Nb[c[(c[g>>2]|0)+60>>2]&127](g,d);i=f;return}function Ru(a){a=a|0;return}function Su(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0,N=0;f=i;i=i+480|0;h=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;tc[c[(c[h>>2]|0)+56>>2]&7](h,b,1.0);h=c[d+4>>2]|0;switch(h|0){case 0:{c[f+400>>2]=c[d+28>>2];c[f+404>>2]=c[d+32>>2];c[f+408>>2]=c[d+36>>2];c[f+412>>2]=c[d+40>>2];l=+$b[c[(c[d>>2]|0)+48>>2]&15](d);m=+$b[c[(c[d>>2]|0)+48>>2]&15](d);o=+$b[c[(c[d>>2]|0)+48>>2]&15](d);l=l+ +g[f+400>>2];g[f+400>>2]=l;m=m+ +g[f+404>>2];g[f+404>>2]=m;o=o+ +g[f+408>>2];g[f+408>>2]=o;r=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;q=c[(c[r>>2]|0)+72>>2]|0;g[f+384>>2]=-l;g[f+388>>2]=-m;g[f+392>>2]=-o;g[f+396>>2]=0.0;Jb[q&31](r,f+384|0,f+400|0,b,e);i=f;return};case 9:{h=c[d+92>>2]|0;if((h|0)<=0){i=f;return}do{h=h+ -1|0;r=c[d+100>>2]|0;D=+g[r+(h<<4)>>2];C=+g[r+(h<<4)+4>>2];m=+g[r+(h<<4)+8>>2];r=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;q=c[(c[r>>2]|0)+16>>2]|0;o=+g[(c[d+120>>2]|0)+(h<<2)>>2];A=+g[b>>2];z=+g[b+4>>2];B=+g[b+8>>2];x=+g[b+16>>2];w=+g[b+20>>2];y=+g[b+24>>2];u=+g[b+32>>2];t=+g[b+36>>2];v=+g[b+40>>2];s=D*A+C*z+m*B+ +g[b+48>>2];l=D*x+C*w+m*y+ +g[b+52>>2];m=D*u+C*t+m*v+ +g[b+56>>2];g[f+320>>2]=A+z*0.0+B*0.0;g[f+324>>2]=A*0.0+z+B*0.0;g[f+328>>2]=B+(A*0.0+z*0.0);g[f+332>>2]=0.0;g[f+336>>2]=x+w*0.0+y*0.0;g[f+340>>2]=x*0.0+w+y*0.0;g[f+344>>2]=y+(x*0.0+w*0.0);g[f+348>>2]=0.0;g[f+352>>2]=u+t*0.0+v*0.0;g[f+356>>2]=u*0.0+t+v*0.0;g[f+360>>2]=v+(u*0.0+t*0.0);g[f+364>>2]=0.0;g[f+368>>2]=s;g[f+372>>2]=l;g[f+376>>2]=m;g[f+380>>2]=0.0;Sb[q&0](r,o,f+320|0,e)}while((h|0)>0);i=f;return};case 11:{C=+g[d+56>>2];D=+g[d+60>>2];r=c[d+68>>2]|0;q=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Rb[c[(c[q>>2]|0)+84>>2]&0](q,C,D,r,b,e);i=f;return};case 13:{r=c[d+52>>2]|0;C=+$b[c[(c[d>>2]|0)+92>>2]&15](d);c[f+304>>2]=c[d+28>>2];c[f+308>>2]=c[d+32>>2];c[f+312>>2]=c[d+36>>2];c[f+316>>2]=c[d+40>>2];A=+$b[c[(c[d>>2]|0)+48>>2]&15](d);B=+$b[c[(c[d>>2]|0)+48>>2]&15](d);D=+$b[c[(c[d>>2]|0)+48>>2]&15](d);g[f+304>>2]=A+ +g[f+304>>2];g[f+308>>2]=B+ +g[f+308>>2];g[f+312>>2]=D+ +g[f+312>>2];D=+g[f+304+(r<<2)>>2];q=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Rb[c[(c[q>>2]|0)+80>>2]&0](q,C,D,r,b,e);i=f;return};case 31:{h=c[d+16>>2]|0;if((h|0)<=0){i=f;return}do{h=h+ -1|0;r=c[d+24>>2]|0;l=+g[r+(h*80|0)>>2];s=+g[r+(h*80|0)+4>>2];v=+g[r+(h*80|0)+8>>2];m=+g[r+(h*80|0)+16>>2];t=+g[r+(h*80|0)+20>>2];x=+g[r+(h*80|0)+24>>2];o=+g[r+(h*80|0)+32>>2];u=+g[r+(h*80|0)+36>>2];z=+g[r+(h*80|0)+40>>2];L=+g[r+(h*80|0)+48>>2];K=+g[r+(h*80|0)+52>>2];D=+g[r+(h*80|0)+56>>2];r=c[r+(h*80|0)+64>>2]|0;q=c[(c[a>>2]|0)+28>>2]|0;J=+g[b>>2];I=+g[b+4>>2];H=+g[b+8>>2];G=+g[b+16>>2];F=+g[b+20>>2];E=+g[b+24>>2];w=+g[b+32>>2];y=+g[b+36>>2];A=+g[b+40>>2];B=L*J+K*I+D*H+ +g[b+48>>2];C=L*G+K*F+D*E+ +g[b+52>>2];D=L*w+K*y+D*A+ +g[b+56>>2];g[f+416>>2]=l*J+m*I+o*H;g[f+420>>2]=s*J+t*I+u*H;g[f+424>>2]=v*J+x*I+z*H;g[f+428>>2]=0.0;g[f+432>>2]=l*G+m*F+o*E;g[f+436>>2]=s*G+t*F+u*E;g[f+440>>2]=v*G+x*F+z*E;g[f+444>>2]=0.0;g[f+448>>2]=l*w+m*y+o*A;g[f+452>>2]=s*w+t*y+u*A;g[f+456>>2]=v*w+x*y+z*A;g[f+460>>2]=0.0;g[f+464>>2]=B;g[f+468>>2]=C;g[f+472>>2]=D;g[f+476>>2]=0.0;vc[q&127](a,f+416|0,r,e)}while((h|0)>0);i=f;return};case 28:{L=+g[d+64>>2];r=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;cc[c[(c[r>>2]|0)+88>>2]&0](r,d+48|0,L,b,e);i=f;return};case 8:{L=+$b[c[(c[d>>2]|0)+48>>2]&15](d);r=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Sb[c[(c[r>>2]|0)+16>>2]&0](r,L,b,e);i=f;return};case 10:{r=c[d+52>>2]|0;K=+g[d+(((r+2|0)%3|0)<<2)+28>>2];L=+g[d+(r<<2)+28>>2];q=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Rb[c[(c[q>>2]|0)+76>>2]&0](q,K,L,r,b,e);i=f;return};default:{a:do if((h|0)<7){j=c[d+52>>2]|0;if(!j){if((Pb[c[(c[d>>2]|0)+100>>2]&127](d)|0)<=0)break;h=0;while(1){vc[c[(c[d>>2]|0)+104>>2]&127](d,h,f+208|0,f+192|0);J=+g[f+208>>2];x=+g[b>>2];H=+g[f+212>>2];y=+g[b+4>>2];F=+g[f+216>>2];z=+g[b+8>>2];B=+g[b+16>>2];C=+g[b+20>>2];D=+g[b+24>>2];G=+g[b+32>>2];I=+g[b+36>>2];K=+g[b+40>>2];A=+g[b+48>>2];E=+g[b+52>>2];L=+g[b+56>>2];g[f+176>>2]=J*x+H*y+F*z+A;g[f+180>>2]=J*B+H*C+F*D+E;g[f+184>>2]=J*G+H*I+F*K+L;g[f+188>>2]=0.0;F=+g[f+192>>2];H=+g[f+196>>2];J=+g[f+200>>2];g[f+160>>2]=F*x+H*y+J*z+A;g[f+164>>2]=F*B+H*C+J*D+E;g[f+168>>2]=F*G+H*I+J*K+L;g[f+172>>2]=0.0;r=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;vc[c[(c[r>>2]|0)+8>>2]&127](r,f+176|0,f+160|0,e);h=h+1|0;if((h|0)>=(Pb[c[(c[d>>2]|0)+100>>2]&127](d)|0))break a}}if((c[j+28>>2]|0)>0){h=0;do{n=c[j+36>>2]|0;k=c[n+(h*36|0)+4>>2]|0;b:do if((k|0)>0){p=c[n+(h*36|0)+12>>2]|0;q=p;o=0.0;m=0.0;l=0.0;p=c[p+(k+ -1<<2)>>2]|0;r=0;while(1){n=c[q+(r<<2)>>2]|0;q=c[j+16>>2]|0;o=o+ +g[q+(n<<4)>>2];m=m+ +g[q+(n<<4)+4>>2];l=l+ +g[q+(n<<4)+8>>2];q=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;M=c[(c[q>>2]|0)+8>>2]|0;N=c[j+16>>2]|0;J=+g[N+(p<<4)>>2];x=+g[b>>2];H=+g[N+(p<<4)+4>>2];y=+g[b+4>>2];F=+g[N+(p<<4)+8>>2];z=+g[b+8>>2];B=+g[b+16>>2];C=+g[b+20>>2];D=+g[b+24>>2];G=+g[b+32>>2];I=+g[b+36>>2];K=+g[b+40>>2];A=+g[b+48>>2];E=+g[b+52>>2];L=+g[b+56>>2];g[f+288>>2]=J*x+H*y+F*z+A;g[f+292>>2]=J*B+H*C+F*D+E;g[f+296>>2]=J*G+H*I+F*K+L;g[f+300>>2]=0.0;F=+g[N+(n<<4)>>2];H=+g[N+(n<<4)+4>>2];J=+g[N+(n<<4)+8>>2];g[f+272>>2]=F*x+H*y+J*z+A;g[f+276>>2]=F*B+H*C+J*D+E;g[f+280>>2]=F*G+H*I+J*K+L;g[f+284>>2]=0.0;vc[M&127](q,f+288|0,f+272|0,e);r=r+1|0;p=c[j+36>>2]|0;if((r|0)>=(c[p+(h*36|0)+4>>2]|0))break b;q=c[p+(h*36|0)+12>>2]|0;p=n}}else{o=0.0;m=0.0;l=0.0}while(0);o=o*(1.0/+(k|0));m=m*(1.0/+(k|0));l=l*(1.0/+(k|0));N=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;if((Pb[c[(c[N>>2]|0)+48>>2]&127](N)|0)&16384){g[f+256>>2]=1.0;g[f+260>>2]=1.0;g[f+264>>2]=0.0;g[f+268>>2]=0.0;N=c[j+36>>2]|0;F=+g[N+(h*36|0)+20>>2];H=+g[N+(h*36|0)+24>>2];J=+g[N+(h*36|0)+28>>2];N=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;M=c[(c[N>>2]|0)+8>>2]|0;x=+g[b>>2];y=+g[b+4>>2];z=+g[b+8>>2];B=+g[b+16>>2];C=+g[b+20>>2];D=+g[b+24>>2];G=+g[b+32>>2];I=+g[b+36>>2];K=+g[b+40>>2];A=+g[b+48>>2];E=+g[b+52>>2];L=+g[b+56>>2];g[f+240>>2]=o*x+m*y+l*z+A;g[f+244>>2]=o*B+m*C+l*D+E;g[f+248>>2]=o*G+m*I+l*K+L;g[f+252>>2]=0.0;g[f+224>>2]=(o+F)*x+(m+H)*y+(l+J)*z+A;g[f+228>>2]=(o+F)*B+(m+H)*C+(l+J)*D+E;g[f+232>>2]=(o+F)*G+(m+H)*I+(l+J)*K+L;g[f+236>>2]=0.0;vc[M&127](N,f+240|0,f+224|0,f+256|0)}h=h+1|0}while((h|0)<(c[j+28>>2]|0))}}while(0);h=c[d+4>>2]|0;if((h+ -21|0)>>>0<9){g[f+144>>2]=999999984306749400.0;g[f+148>>2]=999999984306749400.0;g[f+152>>2]=999999984306749400.0;g[f+156>>2]=0.0;g[f+128>>2]=-999999984306749400.0;g[f+132>>2]=-999999984306749400.0;g[f+136>>2]=-999999984306749400.0;g[f+140>>2]=0.0;h=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[f+32>>2]=7624;c[f+36>>2]=7648;c[f+40>>2]=h;c[f+44>>2]=c[e+0>>2];c[f+48>>2]=c[e+4>>2];c[f+52>>2]=c[e+8>>2];c[f+56>>2]=c[e+12>>2];c[f+60>>2]=c[b+0>>2];c[f+64>>2]=c[b+4>>2];c[f+68>>2]=c[b+8>>2];c[f+72>>2]=c[b+12>>2];c[f+76>>2]=c[b+16>>2];c[f+80>>2]=c[b+20>>2];c[f+84>>2]=c[b+24>>2];c[f+88>>2]=c[b+28>>2];c[f+92>>2]=c[b+32>>2];c[f+96>>2]=c[b+36>>2];c[f+100>>2]=c[b+40>>2];c[f+104>>2]=c[b+44>>2];c[f+108>>2]=c[b+48>>2];c[f+112>>2]=c[b+52>>2];c[f+116>>2]=c[b+56>>2];c[f+120>>2]=c[b+60>>2];vc[c[(c[d>>2]|0)+64>>2]&127](d,f+32|0,f+128|0,f+144|0);h=c[d+4>>2]|0}if((h|0)!=3){i=f;return}g[f+16>>2]=999999984306749400.0;g[f+20>>2]=999999984306749400.0;g[f+24>>2]=999999984306749400.0;g[f+28>>2]=0.0;g[f>>2]=-999999984306749400.0;g[f+4>>2]=-999999984306749400.0;g[f+8>>2]=-999999984306749400.0;g[f+12>>2]=0.0;N=Pb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[f+32>>2]=7624;c[f+36>>2]=7648;c[f+40>>2]=N;c[f+44>>2]=c[e+0>>2];c[f+48>>2]=c[e+4>>2];c[f+52>>2]=c[e+8>>2];c[f+56>>2]=c[e+12>>2];c[f+60>>2]=c[b+0>>2];c[f+64>>2]=c[b+4>>2];c[f+68>>2]=c[b+8>>2];c[f+72>>2]=c[b+12>>2];c[f+76>>2]=c[b+16>>2];c[f+80>>2]=c[b+20>>2];c[f+84>>2]=c[b+24>>2];c[f+88>>2]=c[b+28>>2];c[f+92>>2]=c[b+32>>2];c[f+96>>2]=c[b+36>>2];c[f+100>>2]=c[b+40>>2];c[f+104>>2]=c[b+44>>2];c[f+108>>2]=c[b+48>>2];c[f+112>>2]=c[b+52>>2];c[f+116>>2]=c[b+56>>2];c[f+120>>2]=c[b+60>>2];N=c[d+92>>2]|0;vc[c[(c[N>>2]|0)+8>>2]&127](N,f+36|0,f,f+16|0);i=f;return}}}function Tu(a){a=a|0;return}function Uu(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0;d=i;i=i+112|0;if(((Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(r=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Pb[c[(c[r>>2]|0)+48>>2]&127](r)|0)&8|0)!=0):0)?(e=c[b+24>>2]|0,e=Pb[c[(c[e>>2]|0)+36>>2]&127](e)|0,g[d+96>>2]=1.0,g[d+100>>2]=1.0,g[d+104>>2]=0.0,g[d+108>>2]=0.0,(e|0)>0):0){q=0;do{h=c[b+24>>2]|0;h=gc[c[(c[h>>2]|0)+40>>2]&31](h,q)|0;j=c[h+748>>2]|0;if((j|0)>0){f=0;do{r=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;Mb[c[(c[r>>2]|0)+32>>2]&0](r,h+(f*184|0)+36|0,h+(f*184|0)+68|0,+g[h+(f*184|0)+84>>2],c[h+(f*184|0)+152>>2]|0,d+96|0);f=f+1|0}while((f|0)!=(j|0))}q=q+1|0}while((q|0)!=(e|0))}if(!(Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0)){i=d;return}r=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0;if(!((Pb[c[(c[r>>2]|0)+48>>2]&127](r)|0)&3)){i=d;return}if((c[b+8>>2]|0)<=0){i=d;return}j=d+84|0;h=d+88|0;f=d+92|0;e=0;do{q=c[(c[b+16>>2]|0)+(e<<2)>>2]|0;if(!(c[q+204>>2]&32)){if((Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(r=Pb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Pb[c[(c[r>>2]|0)+48>>2]&127](r)|0)&1|0)!=0):0){g[d+80>>2]=1.0;g[j>>2]=1.0;g[h>>2]=1.0;g[f>>2]=0.0;switch(c[q+216>>2]|0){case 3:{g[d+80>>2]=0.0;g[j>>2]=1.0;g[h>>2]=1.0;g[f>>2]=0.0;break};case 5:{g[d+80>>2]=1.0;g[j>>2]=1.0;g[h>>2]=0.0;g[f>>2]=0.0;break};case 1:{g[d+80>>2]=1.0;g[j>>2]=1.0;g[h>>2]=1.0;g[f>>2]=0.0;break};case 2:{g[d+80>>2]=0.0;g[j>>2]=1.0;g[h>>2]=0.0;g[f>>2]=0.0;break};case 4:{g[d+80>>2]=1.0;g[j>>2]=0.0;g[h>>2]=0.0;g[f>>2]=0.0;break};default:{g[d+80>>2]=1.0;g[j>>2]=0.0;g[h>>2]=0.0;g[f>>2]=0.0}}vc[c[(c[b>>2]|0)+28>>2]&127](b,q+4|0,c[q+192>>2]|0,d+80|0)}r=c[b+72>>2]|0;if((r|0)!=0?((Pb[c[(c[r>>2]|0)+48>>2]&127](r)|0)&2|0)!=0:0){g[d+32>>2]=1.0;g[d+36>>2]=0.0;g[d+40>>2]=0.0;g[d+44>>2]=0.0;r=c[q+192>>2]|0;vc[c[(c[r>>2]|0)+8>>2]&127](r,q+4|0,d+64|0,d+48|0);g[d+64>>2]=+g[d+64>>2]+-.019999999552965164;g[d+68>>2]=+g[d+68>>2]+-.019999999552965164;g[d+72>>2]=+g[d+72>>2]+-.019999999552965164;g[d+48>>2]=+g[d+48>>2]+.019999999552965164;g[d+52>>2]=+g[d+52>>2]+.019999999552965164;g[d+56>>2]=+g[d+56>>2]+.019999999552965164;do if(((a[b+44>>0]|0)!=0?(c[q+236>>2]|0)==2:0)?(c[q+204>>2]&3|0)==0:0){r=c[q+192>>2]|0;vc[c[(c[r>>2]|0)+8>>2]&127](r,q+68|0,d+16|0,d);p=+g[d+16>>2]+-.019999999552965164;g[d+16>>2]=p;o=+g[d+20>>2]+-.019999999552965164;g[d+20>>2]=o;n=+g[d+24>>2]+-.019999999552965164;g[d+24>>2]=n;m=+g[d>>2]+.019999999552965164;g[d>>2]=m;l=+g[d+4>>2]+.019999999552965164;g[d+4>>2]=l;k=+g[d+8>>2]+.019999999552965164;g[d+8>>2]=k;if(p<+g[d+64>>2])g[d+64>>2]=p;if(o<+g[d+68>>2])g[d+68>>2]=o;if(n<+g[d+72>>2])g[d+72>>2]=n;n=+g[d+28>>2];if(n<+g[d+76>>2])g[d+76>>2]=n;if(+g[d+48>>2]<m)g[d+48>>2]=m;if(+g[d+52>>2]<l)g[d+52>>2]=l;if(+g[d+56>>2]<k)g[d+56>>2]=k;k=+g[d+12>>2];if(!(+g[d+60>>2]<k))break;g[d+60>>2]=k}while(0);r=c[b+72>>2]|0;vc[c[(c[r>>2]|0)+52>>2]&127](r,d+64|0,d+48|0,d+32|0)}}e=e+1|0}while((e|0)<(c[b+8>>2]|0));i=d;return}function Vu(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;j=i;i=i+80|0;r=c[b+8>>2]|0;if((r|0)>0){m=0;do{n=c[(c[b+16>>2]|0)+(m<<2)>>2]|0;if((c[n+236>>2]|0)==1){Nb[c[(c[n>>2]|0)+24>>2]&127](n,d);r=c[b+8>>2]|0}m=m+1|0}while((m|0)<(r|0))}a[j+16>>0]=1;c[j+12>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;a[j+36>>0]=1;c[j+32>>2]=0;c[j+24>>2]=0;c[j+28>>2]=0;a[j+56>>0]=1;c[j+52>>2]=0;c[j+44>>2]=0;c[j+48>>2]=0;a[j+76>>0]=1;c[j+72>>2]=0;c[j+64>>2]=0;c[j+68>>2]=0;if((r|0)<=0){Xu(j);i=j;return}u=-1;t=0;p=0;s=0;q=0;m=0;while(1){n=c[(c[(c[b+16>>2]|0)+(m<<2)>>2]|0)+192>>2]|0;o=(n+~(n<<15)>>10^n+~(n<<15))*9|0;o=(o>>6^o)+~((o>>6^o)<<11)>>16^(o>>6^o)+~((o>>6^o)<<11);u=o&u;a:do if(u>>>0<t>>>0?(h=c[p+(u<<2)>>2]|0,(h|0)!=-1):0){u=c[j+72>>2]|0;v=h;while(1){if((n|0)==(c[u+(v<<3)>>2]|0))break;v=c[s+(v<<2)>>2]|0;if((v|0)==-1){f=15;break a}}if(!((v|0)!=-1?((c[j+52>>2]|0)+(v<<2)|0)!=0:0))f=15}else f=15;while(0);if((f|0)==15){f=0;r=o&q+ -1;b:do if(r>>>0<t>>>0?(g=c[p+(r<<2)>>2]|0,(g|0)!=-1):0){t=c[j+72>>2]|0;u=g;while(1){if((n|0)==(c[t+(u<<3)>>2]|0))break;u=c[s+(u<<2)>>2]|0;if((u|0)==-1){f=22;break b}}if((u|0)!=-1)c[(c[j+52>>2]|0)+(u<<2)>>2]=n;else f=22}else f=22;while(0);if((f|0)==22){f=0;p=c[j+44>>2]|0;if((p|0)==(q|0)){s=(q|0)==0?1:q<<1;if((q|0)<(s|0)){if((s|0)!=0?(c[5004]=(c[5004]|0)+1,l=fF((s<<2|3)+16|0)|0,(l|0)!=0):0){c[(l+19&-16)+ -4>>2]=l;t=l+19&-16}else t=0;if((q|0)>0){u=0;do{v=t+(u<<2)|0;if(v)c[v>>2]=c[(c[j+52>>2]|0)+(u<<2)>>2];u=u+1|0}while((u|0)!=(q|0))}u=c[j+52>>2]|0;if(u){if(a[j+56>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[u+ -4>>2]|0)}c[j+52>>2]=0}a[j+56>>0]=1;c[j+52>>2]=t;c[j+48>>2]=s;s=q}else s=q}else s=p;t=(c[j+52>>2]|0)+(s<<2)|0;if(t)c[t>>2]=n;c[j+44>>2]=s+1;t=c[j+64>>2]|0;if((t|0)==(c[j+68>>2]|0)?(k=(t|0)==0?1:t<<1,(t|0)<(k|0)):0){if((k|0)!=0?(c[5004]=(c[5004]|0)+1,e=fF((k<<3|3)+16|0)|0,(e|0)!=0):0){c[(e+19&-16)+ -4>>2]=e;s=e+19&-16}else s=0;if((t|0)>0){v=0;do{u=s+(v<<3)|0;if(u){x=(c[j+72>>2]|0)+(v<<3)|0;w=c[x+4>>2]|0;c[u>>2]=c[x>>2];c[u+4>>2]=w}v=v+1|0}while((v|0)!=(t|0))}t=c[j+72>>2]|0;if(t){if(a[j+76>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[t+ -4>>2]|0)}c[j+72>>2]=0}a[j+76>>0]=1;c[j+72>>2]=s;c[j+68>>2]=k;t=c[j+64>>2]|0}s=(c[j+72>>2]|0)+(t<<3)|0;if(s){c[s>>2]=n;c[s+4>>2]=0}c[j+64>>2]=t+1;s=c[j+48>>2]|0;if((q|0)<(s|0)){q=c[j+4>>2]|0;do if((q|0)<(s|0)){if((q|0)<=(s|0)){if((c[j+8>>2]|0)<(s|0)){do if(!s)r=0;else{c[5004]=(c[5004]|0)+1;r=fF((s<<2|3)+16|0)|0;if(!r){r=0;break}c[(r+19&-16)+ -4>>2]=r;r=r+19&-16}while(0);v=c[j+12>>2]|0;if((q|0)>0){u=0;do{t=r+(u<<2)|0;if(t)c[t>>2]=c[v+(u<<2)>>2];u=u+1|0}while((u|0)!=(q|0))}if(v){if(a[j+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[v+ -4>>2]|0)}c[j+12>>2]=0}a[j+16>>0]=1;c[j+12>>2]=r;c[j+8>>2]=s}else r=c[j+12>>2]|0;t=q;do{u=r+(t<<2)|0;if(u)c[u>>2]=0;t=t+1|0}while((t|0)!=(s|0))}c[j+4>>2]=s;r=c[j+24>>2]|0;if((r|0)<(s|0)){if((c[j+28>>2]|0)<(s|0)){do if(!s)t=0;else{c[5004]=(c[5004]|0)+1;t=fF((s<<2|3)+16|0)|0;if(!t){t=0;break}c[(t+19&-16)+ -4>>2]=t;t=t+19&-16}while(0);v=c[j+32>>2]|0;if((r|0)>0){w=0;do{u=t+(w<<2)|0;if(u)c[u>>2]=c[v+(w<<2)>>2];w=w+1|0}while((w|0)!=(r|0))}if(v){if(a[j+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[v+ -4>>2]|0)}c[j+32>>2]=0}a[j+36>>0]=1;c[j+32>>2]=t;c[j+28>>2]=s}else t=c[j+32>>2]|0;do{u=t+(r<<2)|0;if(u)c[u>>2]=0;r=r+1|0}while((r|0)!=(s|0))}c[j+24>>2]=s;if((s|0)>0){jF(c[j+12>>2]|0,-1,s<<2|0)|0;jF(c[j+32>>2]|0,-1,s<<2|0)|0}if((q|0)<=0){s=c[j+48>>2]|0;break}t=c[j+72>>2]|0;r=c[j+12>>2]|0;v=c[j+32>>2]|0;s=c[j+48>>2]|0;u=0;do{x=c[t+(u<<3)>>2]|0;x=(x+~(x<<15)>>10^x+~(x<<15))*9|0;x=r+((((x>>6^x)+~((x>>6^x)<<11)>>16^(x>>6^x)+~((x>>6^x)<<11))&s+ -1)<<2)|0;c[v+(u<<2)>>2]=c[x>>2];c[x>>2]=u;u=u+1|0}while((u|0)!=(q|0))}while(0);q=s;r=o&s+ -1}else q=s;x=c[j+12>>2]|0;w=x+(r<<2)|0;s=c[j+32>>2]|0;c[s+(p<<2)>>2]=c[w>>2];c[w>>2]=p;p=x}Nb[c[(c[n>>2]|0)+60>>2]&127](n,d);r=c[b+8>>2]|0}m=m+1|0;if((m|0)>=(r|0))break;u=q+ -1|0;t=c[j+4>>2]|0}Xu(j);i=j;return}function Wu(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[b>>2]|0)+32>>2]&511](b);Vu(a,b);Lb[c[(c[b>>2]|0)+36>>2]&511](b);i=d;return}function Xu(b){b=b|0;var d=0,e=0;d=i;e=c[b+72>>2]|0;if(e){if(a[b+76>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+72>>2]=0}a[b+76>>0]=1;c[b+72>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;e=c[b+52>>2]|0;if(e){if(a[b+56>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;e=c[b+32>>2]|0;if(e){if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;e=c[b+12>>2]|0;if(!e){a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;e=b+8|0;c[e>>2]=0;i=d;return}if(a[b+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+12>>2]=0;a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;e=b+8|0;c[e>>2]=0;i=d;return}function Yu(a){a=a|0;return}function Zu(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function _u(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0;d=i;i=i+96|0;p=+g[b>>2];j=+g[a+28>>2];q=+g[b+4>>2];l=+g[a+32>>2];r=+g[b+8>>2];n=+g[a+36>>2];s=+g[a+44>>2];t=+g[a+48>>2];f=+g[a+52>>2];v=+g[a+60>>2];w=+g[a+64>>2];x=+g[a+68>>2];o=+g[a+76>>2];u=+g[a+80>>2];y=+g[a+84>>2];g[d+80>>2]=p*j+q*l+r*n+o;g[d+84>>2]=p*s+q*t+r*f+u;g[d+88>>2]=p*v+q*w+r*x+y;g[d+92>>2]=0.0;h=+g[b+16>>2];k=+g[b+20>>2];m=+g[b+24>>2];g[d+64>>2]=h*j+k*l+m*n+o;g[d+68>>2]=h*s+k*t+m*f+u;g[d+72>>2]=h*v+k*w+m*x+y;g[d+76>>2]=0.0;z=+g[b+32>>2];A=+g[b+36>>2];B=+g[b+40>>2];g[d+48>>2]=z*j+A*l+B*n+o;g[d+52>>2]=z*s+A*t+B*f+u;g[d+56>>2]=z*v+A*w+B*x+y;g[d+60>>2]=0.0;C=(p*j+q*l+r*n+o+(h*j+k*l+m*n+o)+(z*j+A*l+B*n+o))*.3333333432674408;D=(p*s+q*t+r*f+u+(h*s+k*t+m*f+u)+(z*s+A*t+B*f+u))*.3333333432674408;E=(p*v+q*w+r*x+y+(h*v+k*w+m*x+y)+(z*v+A*w+B*x+y))*.3333333432674408;g[d+32>>2]=C;g[d+36>>2]=D;g[d+40>>2]=E;g[d+44>>2]=0.0;e=c[a+8>>2]|0;if(!((Pb[c[(c[e>>2]|0)+48>>2]&127](e)|0)&16384)){b=c[a+8>>2]|0;F=c[b>>2]|0;F=F+8|0;F=c[F>>2]|0;e=a+12|0;vc[F&127](b,d+80|0,d+64|0,e);b=c[a+8>>2]|0;F=c[b>>2]|0;F=F+8|0;F=c[F>>2]|0;vc[F&127](b,d+64|0,d+48|0,e);b=c[a+8>>2]|0;a=c[b>>2]|0;a=a+8|0;a=c[a>>2]|0;vc[a&127](b,d+48|0,d+80|0,e);i=d;return}H=h*j+k*l+m*n+o-(p*j+q*l+r*n+o);G=h*s+k*t+m*f+u-(p*s+q*t+r*f+u);m=h*v+k*w+m*x+y-(p*v+q*w+r*x+y);o=z*j+A*l+B*n+o-(p*j+q*l+r*n+o);u=z*s+A*t+B*f+u-(p*s+q*t+r*f+u);A=z*v+A*w+B*x+y-(p*v+q*w+r*x+y);B=1.0/+Q(+((H*u-G*o)*(H*u-G*o)+((G*A-m*u)*(G*A-m*u)+(m*o-H*A)*(m*o-H*A))));g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+28>>2]=0.0;e=c[a+8>>2]|0;b=c[(c[e>>2]|0)+8>>2]|0;g[d>>2]=B*(G*A-m*u)+C;g[d+4>>2]=B*(m*o-H*A)+D;g[d+8>>2]=B*(H*u-G*o)+E;g[d+12>>2]=0.0;vc[b&127](e,d+32|0,d,d+16|0);e=c[a+8>>2]|0;b=c[e>>2]|0;b=b+8|0;b=c[b>>2]|0;F=a+12|0;vc[b&127](e,d+80|0,d+64|0,F);e=c[a+8>>2]|0;b=c[e>>2]|0;b=b+8|0;b=c[b>>2]|0;vc[b&127](e,d+64|0,d+48|0,F);e=c[a+8>>2]|0;b=c[e>>2]|0;b=b+8|0;b=c[b>>2]|0;vc[b&127](e,d+48|0,d+80|0,F);i=d;return}function $u(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);i=f;return}function av(a){a=a|0;var b=0;b=i;gF(a+ -4|0);i=b;return}function bv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a+ -4>>2]|0)+8>>2]&127](a+ -4|0,b,d,e);i=f;return}function cv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function dv(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0,z=0,A=0;n=i;i=i+192|0;h=c[(c[b+4>>2]|0)+740>>2]|0;j=c[(c[b+8>>2]|0)+8>>2]|0;q=+g[e>>2];k=+g[d>>2]*f+q;o=+g[e+4>>2];l=+g[d+4>>2]*f+o;p=+g[e+8>>2];m=+g[d+8>>2]*f+p;if((h|0)!=(j|0)){w=c[(c[b+12>>2]|0)+8>>2]|0;x=k- +g[w+52>>2];s=l- +g[w+56>>2];t=m- +g[w+60>>2];v=q- +g[j+52>>2];u=o- +g[j+56>>2];r=p- +g[j+60>>2];q=x*+g[w+4>>2]+s*+g[w+20>>2]+t*+g[w+36>>2];o=x*+g[w+8>>2]+s*+g[w+24>>2]+t*+g[w+40>>2];p=x*+g[w+12>>2]+s*+g[w+28>>2]+t*+g[w+44>>2];t=v*+g[j+4>>2]+u*+g[j+20>>2]+r*+g[j+36>>2];s=v*+g[j+8>>2]+u*+g[j+24>>2]+r*+g[j+40>>2];r=v*+g[j+12>>2]+u*+g[j+28>>2]+r*+g[j+44>>2]}else{u=k- +g[h+52>>2];s=l- +g[h+56>>2];t=m- +g[h+60>>2];w=c[(c[b+12>>2]|0)+8>>2]|0;v=q- +g[w+52>>2];x=o- +g[w+56>>2];r=p- +g[w+60>>2];q=u*+g[h+4>>2]+s*+g[h+20>>2]+t*+g[h+36>>2];o=u*+g[h+8>>2]+s*+g[h+24>>2]+t*+g[h+40>>2];p=u*+g[h+12>>2]+s*+g[h+28>>2]+t*+g[h+44>>2];t=v*+g[w+4>>2]+x*+g[w+20>>2]+r*+g[w+36>>2];s=v*+g[w+8>>2]+x*+g[w+24>>2]+r*+g[w+40>>2];r=v*+g[w+12>>2]+x*+g[w+28>>2]+r*+g[w+44>>2]}g[n>>2]=q;g[n+4>>2]=o;g[n+8>>2]=p;g[n+12>>2]=0.0;g[n+16>>2]=t;g[n+20>>2]=s;g[n+24>>2]=r;g[n+28>>2]=0.0;c[n+64>>2]=c[d+0>>2];c[n+68>>2]=c[d+4>>2];c[n+72>>2]=c[d+8>>2];c[n+76>>2]=c[d+12>>2];g[n+80>>2]=f;g[n+84>>2]=0.0;g[n+88>>2]=0.0;g[n+92>>2]=0.0;c[n+112>>2]=0;a[n+116>>0]=0;c[n+120>>2]=0;c[n+124>>2]=0;c[n+128>>2]=0;c[n+132>>2]=0;c[n+136>>2]=0;c[n+140>>2]=0;c[n+144>>2]=0;c[n+148>>2]=0;g[n+48>>2]=k;g[n+52>>2]=l;g[n+56>>2]=m;g[n+60>>2]=0.0;c[n+32>>2]=c[e+0>>2];c[n+36>>2]=c[e+4>>2];c[n+40>>2]=c[e+8>>2];c[n+44>>2]=c[e+12>>2];if((h|0)!=(j|0)){z=c[b+20>>2]|0;c[n+96>>2]=z;e=c[b+16>>2]|0;c[n+100>>2]=e;y=c[b+28>>2]|0;c[n+104>>2]=y;w=c[b+24>>2]|0;c[n+108>>2]=w;d=b+12|0;A=(h|0)!=(j|0)?d:b+8|0;A=c[A>>2]|0;d=(h|0)!=(j|0)?b+8|0:d;d=c[d>>2]|0;j=b+32|0;j=c[j>>2]|0;h=c[j>>2]|0;h=h+12|0;h=c[h>>2]|0;+Vb[h&1](j,n,A,z,y,d,e,w);i=n;return}else{e=c[b+16>>2]|0;c[n+96>>2]=e;z=c[b+20>>2]|0;c[n+100>>2]=z;w=c[b+24>>2]|0;c[n+104>>2]=w;A=c[b+28>>2]|0;c[n+108>>2]=A;y=b+12|0;d=(h|0)!=(j|0)?y:b+8|0;d=c[d>>2]|0;y=(h|0)!=(j|0)?b+8|0:y;y=c[y>>2]|0;j=b+32|0;j=c[j>>2]|0;h=c[j>>2]|0;h=h+12|0;h=c[h>>2]|0;+Vb[h&1](j,n,d,e,w,y,z,A);i=n;return}}function ev(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function fv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0,h=0,j=0;d=i;i=i+32|0;e=c[a+184>>2]|0;if(+g[e+4>>2]==0.0){b=0;i=d;return b|0}b=c[b>>2]|0;if(!(gc[c[(c[e>>2]|0)+8>>2]&31](e,c[b+188>>2]|0)|0)){b=1;i=d;return b|0}h=c[a+192>>2]|0;j=c[b+192>>2]|0;e=c[a+184>>2]|0;f=+g[a+188>>2];c[d>>2]=0;c[d+4>>2]=j;c[d+8>>2]=b;c[d+12>>2]=b+4;c[d+16>>2]=-1;c[d+20>>2]=-1;Ku(h,a+36|0,a+100|0,d,e,f);b=1;i=d;return b|0}function gv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function hv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+32|0;e=c[a+216>>2]|0;if(+g[e+4>>2]==0.0){b=0;i=d;return b|0}b=c[b>>2]|0;if(!(gc[c[(c[e>>2]|0)+8>>2]&31](e,c[b+188>>2]|0)|0)){b=1;i=d;return b|0}f=c[b+192>>2]|0;e=c[a+216>>2]|0;c[d>>2]=0;c[d+4>>2]=f;c[d+8>>2]=b;c[d+12>>2]=b+4;c[d+16>>2]=-1;c[d+20>>2]=-1;Hu(a+68|0,a+132|0,d,e);b=1;i=d;return b|0}function iv(a){a=a|0;return}function jv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function kv(a,b){a=a|0;b=b|0;var d=0;d=i;a=c[a+12>>2]|0;a=gc[c[(c[a>>2]|0)+8>>2]&31](a,b)|0;i=d;return a|0}function lv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0;e=i;i=i+16|0;c[e>>2]=-1;c[e+4>>2]=c[a+16>>2];if(!(c[b+4>>2]|0))c[b+4>>2]=e;h=c[a+12>>2]|0;f=+hc[c[(c[h>>2]|0)+12>>2]&15](h,b,d);g[a+4>>2]=+g[(c[a+12>>2]|0)+4>>2];i=e;return+f}function mv(a){a=a|0;return}function nv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function ov(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0;j=i;i=i+64|0;c[j+48>>2]=f;c[j+52>>2]=h;h=c[a+212>>2]|0;if(!(+g[h+4>>2]>=e)){i=j;return+e}c[j>>2]=c[a+216>>2];c[j+4>>2]=j+48;c[j+8>>2]=c[b+0>>2];c[j+12>>2]=c[b+4>>2];c[j+16>>2]=c[b+8>>2];c[j+20>>2]=c[b+12>>2];c[j+24>>2]=c[d+0>>2];c[j+28>>2]=c[d+4>>2];c[j+32>>2]=c[d+8>>2];c[j+36>>2]=c[d+12>>2];g[j+40>>2]=e;e=+hc[c[(c[h>>2]|0)+12>>2]&15](h,j,0);i=j;return+e}function pv(a){a=a|0;return}function qv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function rv(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;var j=0;j=i;i=i+64|0;c[j+48>>2]=f;c[j+52>>2]=h;h=c[a+212>>2]|0;if(!(+g[h+4>>2]>=e)){i=j;return+e}c[j>>2]=c[a+216>>2];c[j+4>>2]=j+48;c[j+8>>2]=c[b+0>>2];c[j+12>>2]=c[b+4>>2];c[j+16>>2]=c[b+8>>2];c[j+20>>2]=c[b+12>>2];c[j+24>>2]=c[d+0>>2];c[j+28>>2]=c[d+4>>2];c[j+32>>2]=c[d+8>>2];c[j+36>>2]=c[d+12>>2];g[j+40>>2]=e;e=+hc[c[(c[h>>2]|0)+12>>2]&15](h,j,1);i=j;return+e}function sv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function tv(a){a=a|0;return}function uv(a){a=a|0;return}function vv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function wv(a,b){a=a|0;b=b|0;var d=0;d=i;a=c[a+20>>2]|0;a=gc[c[(c[a>>2]|0)+8>>2]&31](a,b)|0;i=d;return a|0}function xv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0;e=i;i=i+16|0;c[e>>2]=-1;c[e+4>>2]=c[a+24>>2];if(!(c[b+4>>2]|0))c[b+4>>2]=e;h=c[a+20>>2]|0;f=+hc[c[(c[h>>2]|0)+12>>2]&15](h,b,d);g[a+4>>2]=+g[(c[a+20>>2]|0)+4>>2];i=e;return+f}function yv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function zv(a,b,c){a=a|0;b=b|0;c=c|0;return}function Av(a,d){a=a|0;d=d|0;var e=0,f=0,h=0;e=i;i=i+128|0;f=c[d+36>>2]|0;d=c[(c[a+8>>2]|0)+24>>2]|0;h=c[d+(f*80|0)+64>>2]|0;no(e+56|0,c[a+12>>2]|0,d+(f*80|0)|0);d=c[a+4>>2]|0;c[e+32>>2]=0;c[e+36>>2]=h;c[e+40>>2]=d;c[e+44>>2]=e+56;c[e+48>>2]=-1;c[e+52>>2]=f;d=c[a+24>>2]|0;g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=8664;c[e+20>>2]=d;c[e+24>>2]=f;g[e+4>>2]=+g[d+4>>2];c[e+16>>2]=c[d+16>>2];Hu(c[a+16>>2]|0,c[a+20>>2]|0,e+32|0,e);i=e;return}function Bv(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;Nb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=e;return}function Cv(a,b){a=a|0;b=b|0;return 1}function Dv(a,b){a=a|0;b=b|0;return 1}function Ev(a){a=a|0;return}function Fv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Gv(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;i=i+48|0;c[h+32>>2]=e;c[h+36>>2]=f;n=+g[b>>2];m=+g[b+4>>2];j=+g[b+8>>2];l=+g[a+56>>2]*n+ +g[a+60>>2]*m+ +g[a+64>>2]*j;k=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];c[h>>2]=c[a+48>>2];c[h+4>>2]=h+32;g[h+8>>2]=l;g[h+12>>2]=k;g[h+16>>2]=j;g[h+20>>2]=0.0;g[h+24>>2]=d;e=c[a+44>>2]|0;d=+hc[c[(c[e>>2]|0)+12>>2]&15](e,h,1);i=h;return+d}function Hv(a){a=a|0;return}function Iv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Jv(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;i=i+48|0;c[h+32>>2]=e;c[h+36>>2]=f;n=+g[b>>2];m=+g[b+4>>2];j=+g[b+8>>2];l=+g[a+56>>2]*n+ +g[a+60>>2]*m+ +g[a+64>>2]*j;k=n*+g[a+72>>2]+m*+g[a+76>>2]+j*+g[a+80>>2];j=n*+g[a+88>>2]+m*+g[a+92>>2]+j*+g[a+96>>2];c[h>>2]=c[a+48>>2];c[h+4>>2]=h+32;g[h+8>>2]=l;g[h+12>>2]=k;g[h+16>>2]=j;g[h+20>>2]=0.0;g[h+24>>2]=d;e=c[a+44>>2]|0;d=+hc[c[(c[e>>2]|0)+12>>2]&15](e,h,1);i=h;return+d}function Kv(a,b){a=a|0;b=+b;return}function Lv(a,b){a=a|0;b=b|0;return}function Mv(a,b,c){a=a|0;b=b|0;c=c|0;return}function Nv(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Ov(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;c[b+8>>2]=0;c[b>>2]=9512;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;g[b+32>>2]=999999984306749400.0;g[b+36>>2]=999999984306749400.0;g[b+40>>2]=999999984306749400.0;g[b+44>>2]=0.0;g[b+48>>2]=-999999984306749400.0;g[b+52>>2]=-999999984306749400.0;g[b+56>>2]=-999999984306749400.0;g[b+60>>2]=0.0;c[b+64>>2]=0;c[b+68>>2]=1;g[b+72>>2]=0.0;g[b+76>>2]=1.0;g[b+80>>2]=1.0;g[b+84>>2]=1.0;g[b+88>>2]=0.0;c[b+4>>2]=31;if(!d){i=e;return}c[5004]=(c[5004]|0)+1;d=fF(79)|0;if((d|0)!=0?(f=d+19&-16,c[f+ -4>>2]=d,(d+19&-16|0)!=0):0){a[f+36>>0]=1;c[f+32>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;a[f+56>>0]=1;c[f+52>>2]=0;c[f+44>>2]=0;c[f+48>>2]=0;c[(d+19&-16)>>2]=0;c[f+4>>2]=0;c[f+8>>2]=-1;c[f+12>>2]=0;c[f+16>>2]=0;f=d+19&-16}else f=0;c[b+64>>2]=f;i=e;return}function Pv(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=9512;e=c[b+64>>2]|0;if((e|0)!=0?(Ux(e),f=c[b+64>>2]|0,(f|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}e=c[b+24>>2]|0;if(e){if(a[b+28>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;if(!b){i=d;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function Qv(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=9512;e=c[b+64>>2]|0;if((e|0)!=0?(Ux(e),f=c[b+64>>2]|0,(f|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}e=c[b+24>>2]|0;if(!e){a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;f=b+20|0;c[f>>2]=0;i=d;return}if(a[b+28>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+24>>2]=0;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;f=b+20|0;c[f>>2]=0;i=d;return}function Rv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;d=i;i=i+80|0;c[a+68>>2]=(c[a+68>>2]|0)+1;e=c[a+16>>2]|0;if((e|0)<=0){h=c[a>>2]|0;h=h+68|0;h=c[h>>2]|0;Lb[h&511](a);i=d;return}h=e;do{e=e+ -1|0;g=c[a+24>>2]|0;if((c[g+(e*80|0)+64>>2]|0)==(b|0)){c[a+68>>2]=(c[a+68>>2]|0)+1;f=c[a+64>>2]|0;if(f){g=c[g+(e*80|0)+76>>2]|0;Yx(f,g)|0;h=c[f+4>>2]|0;if(h){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[f+4>>2]=g;c[f+12>>2]=(c[f+12>>2]|0)+ -1;h=c[a+16>>2]|0;g=c[a+24>>2]|0}h=h+ -1|0;m=g+(e*80|0)|0;c[d+0>>2]=c[m+0>>2];c[d+4>>2]=c[m+4>>2];c[d+8>>2]=c[m+8>>2];c[d+12>>2]=c[m+12>>2];l=g+(e*80|0)+16|0;c[d+16>>2]=c[l+0>>2];c[d+20>>2]=c[l+4>>2];c[d+24>>2]=c[l+8>>2];c[d+28>>2]=c[l+12>>2];k=g+(e*80|0)+32|0;c[d+32>>2]=c[k+0>>2];c[d+36>>2]=c[k+4>>2];c[d+40>>2]=c[k+8>>2];c[d+44>>2]=c[k+12>>2];j=g+(e*80|0)+48|0;c[d+48>>2]=c[j+0>>2];c[d+52>>2]=c[j+4>>2];c[d+56>>2]=c[j+8>>2];c[d+60>>2]=c[j+12>>2];f=g+(e*80|0)+64|0;c[d+64>>2]=c[f+0>>2];c[d+68>>2]=c[f+4>>2];c[d+72>>2]=c[f+8>>2];c[d+76>>2]=c[f+12>>2];n=g+(h*80|0)|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=g+(h*80|0)+16|0;c[l+0>>2]=c[m+0>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];l=g+(h*80|0)+32|0;c[k+0>>2]=c[l+0>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=g+(h*80|0)+48|0;c[j+0>>2]=c[k+0>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];g=g+(h*80|0)+64|0;c[f+0>>2]=c[g+0>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=c[a+24>>2]|0;c[g+(h*80|0)+0>>2]=c[d+0>>2];c[g+(h*80|0)+4>>2]=c[d+4>>2];c[g+(h*80|0)+8>>2]=c[d+8>>2];c[g+(h*80|0)+12>>2]=c[d+12>>2];c[g+(h*80|0)+16>>2]=c[d+16>>2];c[g+(h*80|0)+20>>2]=c[d+20>>2];c[g+(h*80|0)+24>>2]=c[d+24>>2];c[g+(h*80|0)+28>>2]=c[d+28>>2];c[g+(h*80|0)+32>>2]=c[d+32>>2];c[g+(h*80|0)+36>>2]=c[d+36>>2];c[g+(h*80|0)+40>>2]=c[d+40>>2];c[g+(h*80|0)+44>>2]=c[d+44>>2];c[g+(h*80|0)+48>>2]=c[d+48>>2];c[g+(h*80|0)+52>>2]=c[d+52>>2];c[g+(h*80|0)+56>>2]=c[d+56>>2];c[g+(h*80|0)+60>>2]=c[d+60>>2];c[g+(h*80|0)+64>>2]=c[d+64>>2];c[g+(h*80|0)+68>>2]=c[d+68>>2];c[g+(h*80|0)+72>>2]=c[d+72>>2];c[g+(h*80|0)+76>>2]=c[d+76>>2];if(c[a+64>>2]|0)c[(c[(c[a+24>>2]|0)+(e*80|0)+76>>2]|0)+36>>2]=e;h=(c[a+16>>2]|0)+ -1|0;c[a+16>>2]=h}}while((e|0)>0);n=c[a>>2]|0;n=n+68|0;n=c[n>>2]|0;Lb[n&511](a);i=d;return}function Sv(a){a=a|0;var b=0,d=0,e=0.0,f=0,h=0;b=i;i=i+32|0;g[a+32>>2]=999999984306749400.0;g[a+36>>2]=999999984306749400.0;g[a+40>>2]=999999984306749400.0;g[a+44>>2]=0.0;g[a+48>>2]=-999999984306749400.0;g[a+52>>2]=-999999984306749400.0;g[a+56>>2]=-999999984306749400.0;g[a+60>>2]=0.0;if((c[a+16>>2]|0)<=0){i=b;return}d=0;do{f=c[a+24>>2]|0;h=c[f+(d*80|0)+64>>2]|0;vc[c[(c[h>>2]|0)+8>>2]&127](h,f+(d*80|0)|0,b+16|0,b);e=+g[b+16>>2];if(+g[a+32>>2]>e)g[a+32>>2]=e;e=+g[b>>2];if(+g[a+48>>2]<e)g[a+48>>2]=e;e=+g[b+20>>2];if(+g[a+36>>2]>e)g[a+36>>2]=e;e=+g[b+4>>2];if(+g[a+52>>2]<e)g[a+52>>2]=e;e=+g[b+24>>2];if(+g[a+40>>2]>e)g[a+40>>2]=e;e=+g[b+8>>2];if(+g[a+56>>2]<e)g[a+56>>2]=e;d=d+1|0}while((d|0)<(c[a+16>>2]|0));i=b;return}function Tv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0;f=i;t=+g[a+48>>2];v=+g[a+32>>2];E=+g[a+52>>2];w=+g[a+36>>2];F=+g[a+56>>2];k=+g[a+40>>2];G=(c[a+16>>2]|0)==0;x=G?0.0:(F+k)*.5;z=G?0.0:(E+w)*.5;B=G?0.0:(t+v)*.5;o=+$b[c[(c[a>>2]|0)+48>>2]&15](a);m=+$b[c[(c[a>>2]|0)+48>>2]&15](a);o=(G?0.0:(t-v)*.5)+o;m=(G?0.0:(E-w)*.5)+m;k=(G?0.0:(F-k)*.5)+ +$b[c[(c[a>>2]|0)+48>>2]&15](a);F=+g[b>>2];w=+P(+F);E=+g[b+4>>2];v=+P(+E);t=+g[b+8>>2];u=+P(+t);D=+g[b+16>>2];s=+P(+D);C=+g[b+20>>2];r=+P(+C);p=+g[b+24>>2];q=+P(+p);A=+g[b+32>>2];n=+P(+A);y=+g[b+36>>2];l=+P(+y);h=+g[b+40>>2];j=+P(+h);t=B*F+z*E+x*t+ +g[b+48>>2];p=B*D+z*C+x*p+ +g[b+52>>2];h=B*A+z*y+x*h+ +g[b+56>>2];g[d>>2]=t-(o*w+m*v+k*u);g[d+4>>2]=p-(o*s+m*r+k*q);g[d+8>>2]=h-(o*n+m*l+k*j);g[d+12>>2]=0.0;g[e>>2]=o*w+m*v+k*u+t;g[e+4>>2]=o*s+m*r+k*q+p;g[e+8>>2]=o*n+m*l+k*j+h;g[e+12>>2]=0.0;i=f;return}function Uv(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;k=e+76|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;vc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(+g[e>>2]- +g[e+16>>2])*.5*2.0;f=(+g[e+4>>2]- +g[e+20>>2])*.5*2.0;j=(+g[e+8>>2]- +g[e+24>>2])*.5*2.0;g[d>>2]=b/12.0*(f*f+j*j);g[d+4>>2]=b/12.0*(h*h+j*j);g[d+8>>2]=b/12.0*(h*h+f*f);i=e;return}function Vv(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0;k=i;i=i+144|0;if((c[a+16>>2]|0)<=0){p=a+76|0;c[p+0>>2]=c[b+0>>2];c[p+4>>2]=c[b+4>>2];c[p+8>>2]=c[b+8>>2];c[p+12>>2]=c[b+12>>2];p=c[a>>2]|0;p=p+68|0;p=c[p>>2]|0;Lb[p&511](a);i=k;return}f=k+32|0;h=k+48|0;j=k+64|0;e=0;do{p=c[a+24>>2]|0;o=p+(e*80|0)|0;c[k+16>>2]=c[o+0>>2];c[k+20>>2]=c[o+4>>2];c[k+24>>2]=c[o+8>>2];c[k+28>>2]=c[o+12>>2];o=p+(e*80|0)+16|0;c[f+0>>2]=c[o+0>>2];c[f+4>>2]=c[o+4>>2];c[f+8>>2]=c[o+8>>2];c[f+12>>2]=c[o+12>>2];o=p+(e*80|0)+32|0;c[h+0>>2]=c[o+0>>2];c[h+4>>2]=c[o+4>>2];c[h+8>>2]=c[o+8>>2];c[h+12>>2]=c[o+12>>2];o=p+(e*80|0)+48|0;c[j+0>>2]=c[o+0>>2];c[j+4>>2]=c[o+4>>2];c[j+8>>2]=c[o+8>>2];c[j+12>>2]=c[o+12>>2];p=c[p+(e*80|0)+64>>2]|0;p=Pb[c[(c[p>>2]|0)+28>>2]&127](p)|0;c[k+0>>2]=c[p+0>>2];c[k+4>>2]=c[p+4>>2];c[k+8>>2]=c[p+8>>2];q=+g[k+4>>2]*+g[b+4>>2]/+g[a+80>>2];r=+g[k+8>>2]*+g[b+8>>2]/+g[a+84>>2];g[k>>2]=+g[k>>2]*+g[b>>2]/+g[a+76>>2];g[k+4>>2]=q;g[k+8>>2]=r;g[k+12>>2]=0.0;p=c[(c[a+24>>2]|0)+(e*80|0)+64>>2]|0;Nb[c[(c[p>>2]|0)+24>>2]&127](p,k);r=+g[k+68>>2]*+g[b+4>>2]/+g[a+80>>2];q=+g[k+72>>2]*+g[b+8>>2]/+g[a+84>>2];g[k+64>>2]=+g[j>>2]*+g[b>>2]/+g[a+76>>2];g[k+68>>2]=r;g[k+72>>2]=q;g[k+76>>2]=0.0;p=c[a+24>>2]|0;o=p+(e*80|0)|0;c[o+0>>2]=c[k+16>>2];c[o+4>>2]=c[k+20>>2];c[o+8>>2]=c[k+24>>2];c[o+12>>2]=c[k+28>>2];o=p+(e*80|0)+16|0;c[o+0>>2]=c[f+0>>2];c[o+4>>2]=c[f+4>>2];c[o+8>>2]=c[f+8>>2];c[o+12>>2]=c[f+12>>2];o=p+(e*80|0)+32|0;c[o+0>>2]=c[h+0>>2];c[o+4>>2]=c[h+4>>2];c[o+8>>2]=c[h+8>>2];c[o+12>>2]=c[h+12>>2];p=p+(e*80|0)+48|0;c[p+0>>2]=c[j+0>>2];c[p+4>>2]=c[j+4>>2];c[p+8>>2]=c[j+8>>2];c[p+12>>2]=c[j+12>>2];if(c[a+64>>2]|0){l=c[(c[a+24>>2]|0)+(e*80|0)+64>>2]|0;vc[c[(c[l>>2]|0)+8>>2]&127](l,k+16|0,k+128|0,k+112|0);c[k+80>>2]=c[k+128>>2];c[k+84>>2]=c[k+132>>2];c[k+88>>2]=c[k+136>>2];c[k+92>>2]=c[k+140>>2];c[k+96>>2]=c[k+112>>2];c[k+100>>2]=c[k+116>>2];c[k+104>>2]=c[k+120>>2];c[k+108>>2]=c[k+124>>2];l=c[a+64>>2]|0;d=c[(c[a+24>>2]|0)+(e*80|0)+76>>2]|0;o=Yx(l,d)|0;a:do if(o){m=c[l+8>>2]|0;if((m|0)<=-1){o=c[l>>2]|0;break}if((m|0)>0){n=0;while(1){p=c[o+32>>2]|0;n=n+1|0;if(!p)break a;if((n|0)>=(m|0)){o=p;break}else o=p}}}else o=0;while(0);c[d+0>>2]=c[k+80>>2];c[d+4>>2]=c[k+84>>2];c[d+8>>2]=c[k+88>>2];c[d+12>>2]=c[k+92>>2];c[d+16>>2]=c[k+96>>2];c[d+20>>2]=c[k+100>>2];c[d+24>>2]=c[k+104>>2];c[d+28>>2]=c[k+108>>2];Xx(l,o,d)}e=e+1|0}while((e|0)<(c[a+16>>2]|0));p=a+76|0;c[p+0>>2]=c[b+0>>2];c[p+4>>2]=c[b+4>>2];c[p+8>>2]=c[b+8>>2];c[p+12>>2]=c[b+12>>2];p=c[a>>2]|0;p=p+68|0;p=c[p>>2]|0;Lb[p&511](a);i=k;return}function Wv(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0;e=i;f=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;k=gc[c[(c[d>>2]|0)+28>>2]&31](d,f)|0;c[b>>2]=k;if(k)Nb[c[(c[d>>2]|0)+48>>2]&127](d,f);c[b+4>>2]=c[a+4>>2];g[b+20>>2]=+g[a+72>>2];f=c[a+16>>2]|0;c[b+16>>2]=f;c[b+12>>2]=0;if(!f){i=e;return 9616}f=Yb[c[(c[d>>2]|0)+16>>2]&31](d,76,f)|0;k=c[f+8>>2]|0;c[b+12>>2]=gc[c[(c[d>>2]|0)+28>>2]&31](d,k)|0;if((c[b+16>>2]|0)>0){j=c[a+24>>2]|0;h=0;while(1){g[k+72>>2]=+g[j+(h*80|0)+72>>2];c[k+64>>2]=gc[c[(c[d>>2]|0)+28>>2]&31](d,c[j+(h*80|0)+64>>2]|0)|0;if(!(gc[c[(c[d>>2]|0)+24>>2]&31](d,c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0)|0)){j=c[(c[d>>2]|0)+16>>2]|0;l=c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0;l=Pb[c[(c[l>>2]|0)+52>>2]&127](l)|0;l=Yb[j&31](d,l,1)|0;j=c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0;j=Yb[c[(c[j>>2]|0)+56>>2]&31](j,c[l+8>>2]|0,d)|0;Jb[c[(c[d>>2]|0)+20>>2]&31](d,l,j,1346455635,c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0)}j=c[a+24>>2]|0;c[k+68>>2]=c[j+(h*80|0)+68>>2];g[k>>2]=+g[j+(h*80|0)>>2];g[k+4>>2]=+g[j+(h*80|0)+4>>2];g[k+8>>2]=+g[j+(h*80|0)+8>>2];g[k+12>>2]=+g[j+(h*80|0)+12>>2];g[k+16>>2]=+g[j+(h*80|0)+16>>2];g[k+20>>2]=+g[j+(h*80|0)+20>>2];g[k+24>>2]=+g[j+(h*80|0)+24>>2];g[k+28>>2]=+g[j+(h*80|0)+28>>2];g[k+32>>2]=+g[j+(h*80|0)+32>>2];g[k+36>>2]=+g[j+(h*80|0)+36>>2];g[k+40>>2]=+g[j+(h*80|0)+40>>2];g[k+44>>2]=+g[j+(h*80|0)+44>>2];g[k+48>>2]=+g[j+(h*80|0)+48>>2];g[k+52>>2]=+g[j+(h*80|0)+52>>2];g[k+56>>2]=+g[j+(h*80|0)+56>>2];g[k+60>>2]=+g[j+(h*80|0)+60>>2];h=h+1|0;if((h|0)>=(c[b+16>>2]|0)){b=d;break}else k=k+76|0}}else b=d;Jb[c[(c[b>>2]|0)+20>>2]&31](d,f,9584,1497453121,c[f+8>>2]|0);i=e;return 9616}function Xv(a){a=a|0;return a+76|0}function Yv(a){a=a|0;return 9680}function Zv(a,b){a=a|0;b=+b;g[a+72>>2]=b;return}function _v(a){a=a|0;return+(+g[a+72>>2])}function $v(a){a=a|0;return 24}function aw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0,j=0,k=0.0,l=0,m=0.0,n=0.0;j=i;i=i+48|0;f=+g[b+60>>2]*.5;e=c[b+68>>2]|0;k=+g[d>>2];m=+g[d+4>>2];n=+g[d+8>>2];n=+Q(+(k*k+m*m+n*n));h=c[b+64>>2]|0;if(+g[d+(e<<2)>>2]>n*+g[b+52>>2]){g[j+32+(h<<2)>>2]=0.0;g[j+32+(e<<2)>>2]=f;g[j+32+(c[b+72>>2]<<2)>>2]=0.0;c[a+0>>2]=c[j+32>>2];c[a+4>>2]=c[j+36>>2];c[a+8>>2]=c[j+40>>2];c[a+12>>2]=c[j+44>>2];i=j;return}k=+g[d+(h<<2)>>2];l=c[b+72>>2]|0;m=+g[d+(l<<2)>>2];n=+Q(+(k*k+m*m));if(n>1.1920928955078125e-7){n=+g[b+56>>2]/n;g[j+16+(h<<2)>>2]=k*n;g[j+16+(e<<2)>>2]=-f;g[j+16+(l<<2)>>2]=n*m;c[a+0>>2]=c[j+16>>2];c[a+4>>2]=c[j+20>>2];c[a+8>>2]=c[j+24>>2];c[a+12>>2]=c[j+28>>2];i=j;return}else{g[j+(h<<2)>>2]=0.0;g[j+(e<<2)>>2]=-f;g[j+(l<<2)>>2]=0.0;c[a+0>>2]=c[j+0>>2];c[a+4>>2]=c[j+4>>2];c[a+8>>2]=c[j+8>>2];c[a+12>>2]=c[j+12>>2];i=j;return}}function bw(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;aw(a,b,c);i=d;return}function cw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;if((e|0)<=0){i=f;return}g=0;do{h=d+(g<<4)|0;aw(f,a,b+(g<<4)|0);c[h+0>>2]=c[f+0>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];g=g+1|0}while((g|0)!=(e|0));i=f;return}function dw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;aw(a,b,d);if(!(+$b[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+Q(+(f*f+(l*l+k*k)));j=+$b[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*h*k+ +g[a+4>>2];g[a+8>>2]=j*h*f+ +g[a+8>>2];i=e;return}function ew(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0,i=0,j=0;j=c[a+68>>2]|0;i=c[a+64>>2]|0;h=c[a+72>>2]|0;e=+g[b+(j<<2)>>2]/+g[a+(j<<2)+12>>2]*+g[a+60>>2];g[a+60>>2]=e;f=+g[a+56>>2]*(+g[b+(i<<2)>>2]/+g[a+(i<<2)+12>>2]+ +g[b+(h<<2)>>2]/+g[a+(h<<2)+12>>2])*.5;g[a+56>>2]=f;g[a+52>>2]=f/+Q(+(e*e+f*f));f=+P(+(+g[b>>2]));e=+P(+(+g[b+4>>2]));d=+P(+(+g[b+8>>2]));g[a+12>>2]=f;g[a+16>>2]=e;g[a+20>>2]=d;g[a+24>>2]=0.0;return}function fw(a){a=a|0;return}function gw(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function hw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+80>>2]&127](a,b,d,e);i=f;return}function iw(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0;e=i;i=i+96|0;g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;l=e+76|0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;vc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);j=(+g[e>>2]- +g[e+16>>2])*.5;h=(+g[e+4>>2]- +g[e+20>>2])*.5;k=(+g[e+8>>2]- +g[e+24>>2])*.5;f=+$b[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b*.0833333283662796*((h+f)*2.0*(h+f)*2.0+(k+f)*2.0*(k+f)*2.0);g[d+4>>2]=b*.0833333283662796*((j+f)*2.0*(j+f)*2.0+(k+f)*2.0*(k+f)*2.0);g[d+8>>2]=b*.0833333283662796*((j+f)*2.0*(j+f)*2.0+(h+f)*2.0*(h+f)*2.0);g[d+12>>2]=0.0;i=e;return}function jw(a){a=a|0;return 10136}function kw(a,b){a=a|0;b=b|0;g[a>>2]=0.0;g[a+4>>2]=1.0;g[a+8>>2]=0.0;g[a+12>>2]=0.0;return}function lw(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function mw(a){a=a|0;return 60}function nw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;e=i;f=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=gc[c[(c[d>>2]|0)+28>>2]&31](d,f)|0;c[b>>2]=h;if(h)Nb[c[(c[d>>2]|0)+48>>2]&127](d,f);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];c[b+52>>2]=c[a+68>>2];i=e;return 10120}function ow(a){a=a|0;return}function pw(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function qw(a){a=a|0;return 10112}function rw(a,b){a=a|0;b=b|0;g[a>>2]=0.0;g[a+4>>2]=0.0;g[a+8>>2]=1.0;g[a+12>>2]=0.0;return}function sw(a){a=a|0;return}function tw(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function uw(a){a=a|0;return 10104}function vw(a,b){a=a|0;b=b|0;g[a>>2]=1.0;g[a+4>>2]=0.0;g[a+8>>2]=0.0;g[a+12>>2]=0.0;return}function ww(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0,N=0,O=0;h=i;i=i+288|0;if(!(c[b+16>>2]|0)){K=c[b+12>>2]|0;b=c[b+20>>2]|0;n=+g[d>>2];q=+g[d+4>>2];u=+g[d+8>>2];k=+g[d+16>>2];r=+g[d+20>>2];j=+g[d+24>>2];m=+g[d+32>>2];s=+g[d+36>>2];l=+g[d+40>>2];F=+g[d+48>>2];E=+g[d+52>>2];D=+g[d+56>>2];J=+g[e>>2];I=+g[e+16>>2];y=+g[e+32>>2];H=+g[e+4>>2];G=+g[e+20>>2];w=+g[e+36>>2];v=+g[e+8>>2];z=+g[e+24>>2];x=+g[e+40>>2];C=-+g[e+48>>2];B=-+g[e+52>>2];p=-+g[e+56>>2];d=c[(c[K>>2]|0)+64>>2]|0;A=-+g[b+48>>2];t=-+g[b+52>>2];o=-+g[b+56>>2];g[h+32>>2]=(n*J+k*I+m*y)*A+(n*H+k*G+m*w)*t+(n*v+k*z+m*x)*o;g[h+36>>2]=(q*J+r*I+s*y)*A+(q*H+r*G+s*w)*t+(q*v+r*z+s*x)*o;g[h+40>>2]=(u*J+j*I+l*y)*A+(u*H+j*G+l*w)*t+(u*v+j*z+l*x)*o;g[h+44>>2]=0.0;rc[d&127](h+48|0,K,h+32|0);o=+g[h+48>>2];t=+g[h+52>>2];A=+g[h+56>>2];y=F*J+E*I+D*y+(J*C+I*B+y*p)+((n*J+k*I+m*y)*o+(q*J+r*I+s*y)*t+(u*J+j*I+l*y)*A);w=F*H+E*G+D*w+(H*C+G*B+w*p)+((n*H+k*G+m*w)*o+(q*H+r*G+s*w)*t+(u*H+j*G+l*w)*A);A=F*v+E*z+D*x+(v*C+z*B+x*p)+((n*v+k*z+m*x)*o+(q*v+r*z+s*x)*t+(u*v+j*z+l*x)*A);x=+g[b+48>>2];l=+g[b+52>>2];z=+g[b+56>>2];j=z*A+(x*y+l*w)- +g[b+64>>2];v=+g[e>>2];u=+g[e+4>>2];t=+g[e+8>>2];s=+g[e+16>>2];r=+g[e+20>>2];q=+g[e+24>>2];o=+g[e+32>>2];m=+g[e+36>>2];k=+g[e+40>>2];n=s*(y-x*j)+(w-l*j)*r+(A-z*j)*q+ +g[e+52>>2];p=(y-x*j)*o+(w-l*j)*m+(A-z*j)*k+ +g[e+56>>2];g[h+16>>2]=t*(A-z*j)+(v*(y-x*j)+u*(w-l*j))+ +g[e+48>>2];g[h+20>>2]=n;g[h+24>>2]=p;g[h+28>>2]=0.0;p=+g[b+48>>2];n=+g[b+52>>2];l=+g[b+56>>2];g[h>>2]=v*p+u*n+t*l;g[h+4>>2]=p*s+n*r+l*q;g[h+8>>2]=p*o+n*m+l*k;g[h+12>>2]=0.0;qc[c[(c[f>>2]|0)+16>>2]&15](f,h,h+16|0,j);i=h;return}else{N=c[b+4>>2]|0;a[N+312>>0]=0;c[N>>2]=0;a[N+356>>0]=1;g[N+292>>2]=999999984306749400.0;g[N+296>>2]=999999984306749400.0;g[N+300>>2]=999999984306749400.0;g[N+304>>2]=0.0;c[N+336>>2]=0;c[N+340>>2]=0;c[N+344>>2]=0;c[N+348>>2]=0;a[N+352>>0]=0;a[N+332>>0]=a[N+332>>0]&-16;N=c[b+12>>2]|0;M=c[b+16>>2]|0;L=c[N+4>>2]|0;K=c[M+4>>2]|0;I=+$b[c[(c[N>>2]|0)+48>>2]&15](N);O=c[b+16>>2]|0;J=+$b[c[(c[O>>2]|0)+48>>2]&15](O);O=c[b+4>>2]|0;b=c[b+8>>2]|0;c[h+200>>2]=13392;g[h+204>>2]=0.0;g[h+208>>2]=1.0;g[h+212>>2]=0.0;g[h+216>>2]=0.0;c[h+220>>2]=b;c[h+224>>2]=O;c[h+228>>2]=N;c[h+232>>2]=M;c[h+236>>2]=L;c[h+240>>2]=K;g[h+244>>2]=I;g[h+248>>2]=J;a[h+252>>0]=0;c[h+260>>2]=-1;c[h+272>>2]=1;c[h+276>>2]=1;g[h+192>>2]=999999984306749400.0;c[h+64>>2]=c[d+0>>2];c[h+68>>2]=c[d+4>>2];c[h+72>>2]=c[d+8>>2];c[h+76>>2]=c[d+12>>2];c[h+80>>2]=c[d+16>>2];c[h+84>>2]=c[d+20>>2];c[h+88>>2]=c[d+24>>2];c[h+92>>2]=c[d+28>>2];c[h+96>>2]=c[d+32>>2];c[h+100>>2]=c[d+36>>2];c[h+104>>2]=c[d+40>>2];c[h+108>>2]=c[d+44>>2];c[h+112>>2]=c[d+48>>2];c[h+116>>2]=c[d+52>>2];c[h+120>>2]=c[d+56>>2];c[h+124>>2]=c[d+60>>2];c[h+128>>2]=c[e+0>>2];c[h+132>>2]=c[e+4>>2];c[h+136>>2]=c[e+8>>2];c[h+140>>2]=c[e+12>>2];c[h+144>>2]=c[e+16>>2];c[h+148>>2]=c[e+20>>2];c[h+152>>2]=c[e+24>>2];c[h+156>>2]=c[e+28>>2];c[h+160>>2]=c[e+32>>2];c[h+164>>2]=c[e+36>>2];c[h+168>>2]=c[e+40>>2];c[h+172>>2]=c[e+44>>2];c[h+176>>2]=c[e+48>>2];c[h+180>>2]=c[e+52>>2];c[h+184>>2]=c[e+56>>2];c[h+188>>2]=c[e+60>>2];Az(h+200|0,h+64|0,f,0,0);i=h;return}}function xw(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;k=i;i=i+304|0;l=+g[e+48>>2]- +g[d+48>>2];n=+g[e+52>>2]- +g[d+52>>2];m=+g[e+56>>2]- +g[d+56>>2];Lo(d,e,k+256|0,k+192|0);r=+g[k+192>>2];s=+g[k+256>>2]*r;t=r*+g[k+260>>2];r=r*+g[k+264>>2];g[k+176>>2]=s;g[k+180>>2]=t;g[k+184>>2]=r;g[k+188>>2]=0.0;q=+g[h+48>>2]- +g[f+48>>2];o=+g[h+52>>2]- +g[f+52>>2];p=+g[h+56>>2]- +g[f+56>>2];Lo(f,h,k+256|0,k+192|0);v=+g[k+192>>2];x=+g[k+256>>2]*v;w=v*+g[k+260>>2];v=v*+g[k+264>>2];g[k+160>>2]=x;g[k+164>>2]=w;g[k+168>>2]=v;g[k+172>>2]=0.0;h=c[b+12>>2]|0;u=+$b[c[(c[h>>2]|0)+16>>2]&15](h);h=c[b+16>>2]|0;if(!h)y=0.0;else y=+$b[c[(c[h>>2]|0)+16>>2]&15](h);r=u*+Q(+(s*s+t*t+r*r))+y*+Q(+(x*x+w*w+v*v));if(r+ +Q(+((q-l)*(q-l)+(o-n)*(o-n)+(p-m)*(p-m)))==0.0){e=0;i=k;return e|0}c[k+256>>2]=10224;g[k+292>>2]=999999984306749400.0;a[k+296>>0]=0;ww(b,d,f,k+256|0);e=(a[k+296>>0]|0)==0;c[k+144>>2]=c[k+276>>2];c[k+148>>2]=c[k+280>>2];c[k+152>>2]=c[k+284>>2];c[k+156>>2]=c[k+288>>2];if(e){e=0;i=k;return e|0}s=+g[k+260>>2];u=+g[k+264>>2];w=+g[k+268>>2];if(r+((q-l)*s+(o-n)*u+(p-m)*w)<=1.1920928955078125e-7){e=0;i=k;return e|0}y=+g[k+272>>2];v=+g[k+292>>2]+ +g[j+172>>2];t=0.0;h=0;while(1){if(!(v>.0010000000474974513)){f=18;break}e=c[j+168>>2]|0;if(e){z=c[(c[e>>2]|0)+20>>2]|0;g[k+128>>2]=1.0;g[k+132>>2]=1.0;g[k+136>>2]=1.0;g[k+140>>2]=0.0;Qb[z&7](e,k+144|0,.20000000298023224,k+128|0)}s=r+((p-m)*w+((o-n)*u+(q-l)*s));if(s<=1.1920928955078125e-7){j=0;f=19;break}x=t+v/s;if(!(!(x<0.0)&!(x>1.0)&!(x<=t))){j=0;f=19;break}Bo(d,l,n,m,k+176|0,x,k+192|0);Bo(f,q,o,p,k+160|0,x,k+64|0);e=c[j+168>>2]|0;if(e){z=c[(c[e>>2]|0)+20>>2]|0;g[k+48>>2]=1.0;g[k+52>>2]=0.0;g[k+56>>2]=0.0;g[k+60>>2]=0.0;Qb[z&7](e,k+240|0,.20000000298023224,k+48|0)}Kb[c[c[j>>2]>>2]&31](j,x);c[k>>2]=10224;g[k+36>>2]=999999984306749400.0;a[k+40>>0]=0;ww(b,k+192|0,k+64|0,k);if(!(a[k+40>>0]|0)){f=16;break}v=+g[k+36>>2]+ +g[j+172>>2];c[k+144>>2]=c[k+20>>2];c[k+148>>2]=c[k+24>>2];c[k+152>>2]=c[k+28>>2];c[k+156>>2]=c[k+32>>2];e=h+1|0;if((h|0)>63){f=17;break}else{s=+g[k+4>>2];u=+g[k+8>>2];w=+g[k+12>>2];y=+g[k+16>>2];t=x;h=e}}if((f|0)==16){rc[c[(c[j>>2]|0)+8>>2]&127](j,-1,h);z=0;i=k;return z|0}else if((f|0)==17){rc[c[(c[j>>2]|0)+8>>2]&127](j,-2,e);z=0;i=k;return z|0}else if((f|0)==18){g[j+164>>2]=t;g[j+132>>2]=s;g[j+136>>2]=u;g[j+140>>2]=w;g[j+144>>2]=y;c[j+148>>2]=c[k+144>>2];c[j+152>>2]=c[k+148>>2];c[j+156>>2]=c[k+152>>2];c[j+160>>2]=c[k+156>>2];z=1;i=k;return z|0}else if((f|0)==19){i=k;return j|0}return 0}function yw(a){a=a|0;return}function zw(a){a=a|0;return}function Aw(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Bw(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Cw(a,b,c){a=a|0;b=b|0;c=c|0;return}function Dw(a,b,c){a=a|0;b=b|0;c=c|0;return}function Ew(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0;h=i;if(!(+g[b+36>>2]>f)){i=h;return}a[b+40>>0]=1;c[b+4>>2]=c[d+0>>2];c[b+8>>2]=c[d+4>>2];c[b+12>>2]=c[d+8>>2];c[b+16>>2]=c[d+12>>2];c[b+20>>2]=c[e+0>>2];c[b+24>>2]=c[e+4>>2];c[b+28>>2]=c[e+8>>2];c[b+32>>2]=c[e+12>>2];g[b+36>>2]=f;i=h;return}function Fw(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+12>>2]=c[b+0>>2];c[a+16>>2]=c[b+4>>2];c[a+20>>2]=c[b+8>>2];c[a+24>>2]=c[b+12>>2];EA(a);i=d;return}function Gw(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;j=c[b+96>>2]|0;if((j|0)==(c[b+100>>2]|0)?(g=(j|0)==0?1:j<<1,(j|0)<(g|0)):0){if(!g)h=0;else{c[5004]=(c[5004]|0)+1;h=fF((g<<4|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}j=c[b+96>>2]|0}if((j|0)>0){k=0;do{l=h+(k<<4)|0;m=(c[b+104>>2]|0)+(k<<4)|0;c[l+0>>2]=c[m+0>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];k=k+1|0}while((k|0)!=(j|0))}j=c[b+104>>2]|0;if(j){if(a[b+108>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=h;c[b+100>>2]=g;j=c[b+96>>2]|0}m=(c[b+104>>2]|0)+(j<<4)|0;c[m+0>>2]=c[d+0>>2];c[m+4>>2]=c[d+4>>2];c[m+8>>2]=c[d+8>>2];c[m+12>>2]=c[d+12>>2];c[b+96>>2]=(c[b+96>>2]|0)+1;if(!e){i=f;return}EA(b);i=f;return}function Hw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0;k=i;f=c[b+96>>2]|0;if((f|0)<=0){c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;i=k;return}e=+g[b+12>>2];j=+g[d>>2]*e;l=+g[b+16>>2];h=+g[d+4>>2]*l;m=+g[b+20>>2];n=+g[d+8>>2]*m;b=c[b+104>>2]|0;d=0;o=-3.4028234663852886e+38;p=-1;while(1){q=j*+g[b+(d<<4)>>2]+h*+g[b+(d<<4)+4>>2]+n*+g[b+(d<<4)+8>>2];r=q>o;p=r?d:p;d=d+1|0;if((d|0)==(f|0))break;else o=r?q:o}o=+g[b+(p<<4)+4>>2]*l;q=+g[b+(p<<4)+8>>2]*m;g[a>>2]=+g[b+(p<<4)>>2]*e;g[a+4>>2]=o;g[a+8>>2]=q;g[a+12>>2]=0.0;i=k;return}function Iw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0;f=i;if((e|0)>0)j=0;else{i=f;return}do{g[d+(j<<4)+12>>2]=-999999984306749400.0;j=j+1|0}while((j|0)!=(e|0));j=0;do{t=+g[a+12>>2];n=+g[b+(j<<4)>>2]*t;k=+g[a+16>>2];o=+g[b+(j<<4)+4>>2]*k;l=+g[a+20>>2];p=+g[b+(j<<4)+8>>2]*l;q=c[a+96>>2]|0;if((q|0)>0){r=c[a+104>>2]|0;s=0;h=-3.4028234663852886e+38;m=-1;do{u=n*+g[r+(s<<4)>>2]+o*+g[r+(s<<4)+4>>2]+p*+g[r+(s<<4)+8>>2];v=u>h;m=v?s:m;h=v?u:h;s=s+1|0}while((s|0)!=(q|0));p=+g[r+(m<<4)+4>>2]*k;u=+g[r+(m<<4)+8>>2]*l;g[d+(j<<4)>>2]=+g[r+(m<<4)>>2]*t;g[d+(j<<4)+4>>2]=p;g[d+(j<<4)+8>>2]=u;g[d+(j<<4)+12>>2]=h}else g[d+(j<<4)+12>>2]=-999999984306749400.0;j=j+1|0}while((j|0)!=(e|0));i=f;return}function Jw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;rc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+$b[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+Q(+(f*f+(l*l+k*k)));j=+$b[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*h*k+ +g[a+4>>2];g[a+8>>2]=j*h*f+ +g[a+8>>2];i=e;return}function Kw(a){a=a|0;return c[a+96>>2]|0}function Lw(a){a=a|0;return c[a+96>>2]|0}function Mw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0,j=0;i=c[a+96>>2]|0;j=c[a+104>>2]|0;f=+g[j+(((b|0)%(i|0)|0)<<4)+4>>2]*+g[a+16>>2];h=+g[j+(((b|0)%(i|0)|0)<<4)+8>>2]*+g[a+20>>2];g[d>>2]=+g[j+(((b|0)%(i|0)|0)<<4)>>2]*+g[a+12>>2];g[d+4>>2]=f;g[d+8>>2]=h;g[d+12>>2]=0.0;d=c[a+104>>2]|0;h=+g[d+(((b+1|0)%(i|0)|0)<<4)+4>>2]*+g[a+16>>2];f=+g[d+(((b+1|0)%(i|0)|0)<<4)+8>>2]*+g[a+20>>2];g[e>>2]=+g[d+(((b+1|0)%(i|0)|0)<<4)>>2]*+g[a+12>>2];g[e+4>>2]=h;g[e+8>>2]=f;g[e+12>>2]=0.0;return}function Nw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0;h=c[a+104>>2]|0;f=+g[h+(b<<4)+4>>2]*+g[a+16>>2];e=+g[h+(b<<4)+8>>2]*+g[a+20>>2];g[d>>2]=+g[h+(b<<4)>>2]*+g[a+12>>2];g[d+4>>2]=f;g[d+8>>2]=e;g[d+12>>2]=0.0;return}function Ow(a){a=a|0;return 0}function Pw(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function Qw(a,b,c){a=a|0;b=b|0;c=+c;return 0}function Rw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0;e=i;f=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;j=gc[c[(c[d>>2]|0)+28>>2]&31](d,f)|0;c[b>>2]=j;if(j)Nb[c[(c[d>>2]|0)+48>>2]&127](d,f);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];f=c[a+96>>2]|0;c[b+60>>2]=f;if(!f){c[b+52>>2]=0;c[b+56>>2]=0;i=e;return 10504}c[b+52>>2]=gc[c[(c[d>>2]|0)+28>>2]&31](d,c[a+104>>2]|0)|0;c[b+56>>2]=0;b=Yb[c[(c[d>>2]|0)+16>>2]&31](d,16,f)|0;if((f|0)>0){h=c[a+104>>2]|0;a=0;j=c[b+8>>2]|0;while(1){g[j>>2]=+g[h+(a<<4)>>2];g[j+4>>2]=+g[h+(a<<4)+4>>2];g[j+8>>2]=+g[h+(a<<4)+8>>2];g[j+12>>2]=+g[h+(a<<4)+12>>2];a=a+1|0;if((a|0)==(f|0))break;else j=j+16|0}}else h=c[a+104>>2]|0;Jb[c[(c[d>>2]|0)+20>>2]&31](d,b,19760,1497453121,h);i=e;return 10504}function Sw(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0;k=i;i=i+16|0;g[e>>2]=3.4028234663852886e+38;g[f>>2]=-3.4028234663852886e+38;m=c[a+96>>2]|0;if((m|0)>0){n=0;do{s=c[a+104>>2]|0;r=+g[s+(n<<4)>>2]*+g[a+12>>2];q=+g[s+(n<<4)+4>>2]*+g[a+16>>2];l=+g[s+(n<<4)+8>>2]*+g[a+20>>2];p=r*+g[b>>2]+q*+g[b+4>>2]+l*+g[b+8>>2]+ +g[b+48>>2];o=r*+g[b+16>>2]+q*+g[b+20>>2]+l*+g[b+24>>2]+ +g[b+52>>2];l=r*+g[b+32>>2]+q*+g[b+36>>2]+l*+g[b+40>>2]+ +g[b+56>>2];q=p*+g[d>>2]+o*+g[d+4>>2]+l*+g[d+8>>2];if(q<+g[e>>2]){g[e>>2]=q;g[h>>2]=p;g[h+4>>2]=o;g[h+8>>2]=l;g[h+12>>2]=0.0}if(q>+g[f>>2]){g[f>>2]=q;g[j>>2]=p;g[j+4>>2]=o;g[j+8>>2]=l;g[j+12>>2]=0.0}n=n+1|0}while((n|0)!=(m|0));o=+g[f>>2]}else o=-3.4028234663852886e+38;l=+g[e>>2];if(!(l>o)){i=k;return}g[e>>2]=o;g[f>>2]=l;c[k+0>>2]=c[h+0>>2];c[k+4>>2]=c[h+4>>2];c[k+8>>2]=c[h+8>>2];c[k+12>>2]=c[h+12>>2];c[h+0>>2]=c[j+0>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j+0>>2]=c[k+0>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];i=k;return}function Tw(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=10376;e=c[b+104>>2]|0;if(e){if(a[b+108>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=0;c[b+96>>2]=0;c[b+100>>2]=0;c[b>>2]=15736;e=c[b+52>>2]|0;if(!e){i=d;return}Lb[c[c[e>>2]>>2]&511](e);b=c[b+52>>2]|0;if(!b){i=d;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function Uw(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=10376;f=c[b+104>>2]|0;if(f){if(a[b+108>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=0;c[b+96>>2]=0;c[b+100>>2]=0;c[b>>2]=15736;f=c[b+52>>2]|0;if((f|0)!=0?(Lb[c[c[f>>2]>>2]&511](f),e=c[b+52>>2]|0,(e|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}if(!b){i=d;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function Vw(a){a=a|0;return 10568}function Ww(a){a=a|0;return 68}function Xw(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+P(+(+g[b>>2]));d=+P(+(+g[b+4>>2]));c=+P(+(+g[b+8>>2]));g[a+12>>2]=e;g[a+16>>2]=d;g[a+20>>2]=c;g[a+24>>2]=0.0;return}function Yw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;f=i;i=i+96|0;h=+$b[c[(c[a>>2]|0)+48>>2]&15](a);j=0;do{q=f+80+(j<<2)|0;c[f+80>>2]=0;c[f+84>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;g[q>>2]=1.0;k=c[(c[a>>2]|0)+64>>2]|0;l=+g[f+80>>2];m=+g[f+84>>2];n=+g[f+88>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[f+48>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[f+52>>2]=o;g[f+56>>2]=p;g[f+60>>2]=0.0;rc[k&127](f+64|0,a,f+48|0);p=+g[f+64>>2];o=+g[f+68>>2];n=+g[f+72>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[f+32>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[f+36>>2]=m;g[f+40>>2]=l;g[f+44>>2]=0.0;k=f+32+(j<<2)|0;g[e+(j<<2)>>2]=h+ +g[k>>2];g[q>>2]=-1.0;q=c[(c[a>>2]|0)+64>>2]|0;l=+g[f+80>>2];m=+g[f+84>>2];n=+g[f+88>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[f>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[f+4>>2]=o;g[f+8>>2]=p;g[f+12>>2]=0.0;rc[q&127](f+16|0,a,f);p=+g[f+16>>2];o=+g[f+20>>2];n=+g[f+24>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[f+32>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[f+36>>2]=m;g[f+40>>2]=l;g[f+44>>2]=0.0;g[d+(j<<2)>>2]=+g[k>>2]-h;j=j+1|0}while((j|0)!=3);i=f;return}function Zw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;rc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+$b[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+Q(+(f*f+(l*l+k*k)));j=+$b[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*h*k+ +g[a+4>>2];g[a+8>>2]=j*h*f+ +g[a+8>>2];i=e;return}function _w(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0;h=i;i=i+64|0;n=+g[d>>2];o=+g[d+4>>2];m=+g[d+8>>2];p=n*+g[b+4>>2]+o*+g[b+20>>2]+m*+g[b+36>>2];q=n*+g[b+8>>2]+o*+g[b+24>>2]+m*+g[b+40>>2];g[h+48>>2]=+g[b>>2]*n+ +g[b+16>>2]*o+ +g[b+32>>2]*m;g[h+52>>2]=p;g[h+56>>2]=q;g[h+60>>2]=0.0;rc[c[(c[a>>2]|0)+64>>2]&127](h+32|0,a,h+48|0);q=+g[h+32>>2];p=+g[h+36>>2];m=+g[h+40>>2];o=q*+g[b>>2]+p*+g[b+4>>2]+m*+g[b+8>>2]+ +g[b+48>>2];n=q*+g[b+16>>2]+p*+g[b+20>>2]+m*+g[b+24>>2]+ +g[b+52>>2];m=q*+g[b+32>>2]+p*+g[b+36>>2]+m*+g[b+40>>2]+ +g[b+56>>2];r=c[(c[a>>2]|0)+64>>2]|0;p=-+g[h+52>>2];q=-+g[h+56>>2];g[h>>2]=-+g[h+48>>2];g[h+4>>2]=p;g[h+8>>2]=q;g[h+12>>2]=0.0;rc[r&127](h+16|0,a,h);q=+g[h+16>>2];p=+g[h+20>>2];j=+g[h+24>>2];l=q*+g[b>>2]+p*+g[b+4>>2]+j*+g[b+8>>2]+ +g[b+48>>2];k=q*+g[b+16>>2]+p*+g[b+20>>2]+j*+g[b+24>>2]+ +g[b+52>>2];j=q*+g[b+32>>2]+p*+g[b+36>>2]+j*+g[b+40>>2]+ +g[b+56>>2];g[e>>2]=o*+g[d>>2]+n*+g[d+4>>2]+m*+g[d+8>>2];j=l*+g[d>>2]+k*+g[d+4>>2]+j*+g[d+8>>2];g[f>>2]=j;k=+g[e>>2];if(!(k>j)){i=h;return}g[e>>2]=j;g[f>>2]=k;i=h;return}function $w(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0,x=0;e=i;i=i+80|0;switch(c[b+4>>2]|0){case 8:{c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;i=e;return};case 1:{t=+g[d>>2];v=+g[d+4>>2];j=+g[d+8>>2];h=t*+g[b+56>>2]+v*+g[b+60>>2]+j*+g[b+64>>2];f=t*+g[b+72>>2]+v*+g[b+76>>2]+j*+g[b+80>>2];j=t*+g[b+88>>2]+v*+g[b+92>>2]+j*+g[b+96>>2];if(h<f)d=f<j?2:1;else d=h<j?2:0;t=+g[b+56+(d<<4)+4>>2];v=+g[b+56+(d<<4)+8>>2];g[a>>2]=+g[b+56+(d<<4)>>2];g[a+4>>2]=t;g[a+8>>2]=v;g[a+12>>2]=0.0;i=e;return};case 13:{c[e+64>>2]=c[b+28>>2];c[e+68>>2]=c[b+32>>2];c[e+72>>2]=c[b+36>>2];c[e+76>>2]=c[b+40>>2];g[e+48>>2]=+g[d>>2];f=+g[d+4>>2];g[e+52>>2]=f;h=+g[d+8>>2];g[e+56>>2]=h;g[e+60>>2]=0.0;w=c[b+52>>2]|0;if((w|0)==1){u=0;d=w;b=2}else if((w|0)==2){h=f;u=0;d=w;b=1}else{u=1;d=0;b=2}f=+g[e+64+(u<<2)>>2];k=+g[e+64+(w<<2)>>2];l=+g[e+48+(u<<2)>>2];j=+Q(+(l*l+h*h));if(j!=0.0){g[e+32+(u<<2)>>2]=l*(f/j);if(+g[e+48+(d<<2)>>2]<0.0)k=-k;g[e+32+(d<<2)>>2]=k;g[e+32+(b<<2)>>2]=f/j*h;g[a>>2]=+g[e+32>>2];g[a+4>>2]=+g[e+36>>2];g[a+8>>2]=+g[e+40>>2];g[a+12>>2]=0.0;i=e;return}else{g[e+32+(u<<2)>>2]=f;if(+g[e+48+(d<<2)>>2]<0.0)k=-k;g[e+32+(d<<2)>>2]=k;g[e+32+(b<<2)>>2]=0.0;g[a>>2]=+g[e+32>>2];g[a+4>>2]=+g[e+36>>2];g[a+8>>2]=+g[e+40>>2];g[a+12>>2]=0.0;i=e;return}};case 10:{h=+g[d>>2];j=+g[d+4>>2];k=+g[d+8>>2];d=c[b+52>>2]|0;f=+g[b+(d<<2)+28>>2];n=+g[b+(((d+2|0)%3|0)<<2)+28>>2];if(h*h+j*j+k*k<9999999747378752.0e-20){h=1.0;j=0.0;k=0.0}else{v=1.0/+Q(+(h*h+j*j+k*k));h=h*v;j=j*v;k=k*v}c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;g[e+16+(d<<2)>>2]=f;m=n*h;l=n*j;n=n*k;q=+g[b+44>>2];o=h*q;p=j*q;q=k*q;v=+g[e+16>>2]+m-o;t=l+ +g[e+20>>2]-p;s=n+ +g[e+24>>2]-q;r=k*s+(h*v+j*t);if(!(r>-999999984306749400.0)){s=0.0;t=0.0;v=0.0;r=-999999984306749400.0}c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;g[e+(d<<2)>>2]=-f;o=m+ +g[e>>2]-o;p=l+ +g[e+4>>2]-p;q=n+ +g[e+8>>2]-q;x=k*q+(h*o+j*p)>r;g[a>>2]=x?o:v;g[a+4>>2]=x?p:t;g[a+8>>2]=x?q:s;g[a+12>>2]=0.0;i=e;return};case 4:{u=c[b+104>>2]|0;w=c[b+96>>2]|0;h=+g[b+12>>2];f=+g[b+16>>2];j=+g[b+20>>2];k=+g[d>>2]*h;l=+g[d+4>>2]*f;n=+g[d+8>>2]*j;if((w|0)>0){d=0;m=-3.4028234663852886e+38;x=-1;while(1){o=k*+g[u+(d<<4)>>2]+l*+g[u+(d<<4)+4>>2]+n*+g[u+(d<<4)+8>>2];b=o>m;x=b?d:x;d=d+1|0;if((d|0)==(w|0))break;else m=b?o:m}}else x=-1;t=f*+g[u+(x<<4)+4>>2];v=j*+g[u+(x<<4)+8>>2];g[a>>2]=h*+g[u+(x<<4)>>2];g[a+4>>2]=t;g[a+8>>2]=v;g[a+12>>2]=0.0;i=e;return};case 5:{u=c[b+92>>2]|0;w=c[b+96>>2]|0;h=+g[b+12>>2];f=+g[b+16>>2];j=+g[b+20>>2];k=+g[d>>2]*h;l=+g[d+4>>2]*f;n=+g[d+8>>2]*j;if((w|0)>0){d=0;o=-3.4028234663852886e+38;x=-1;while(1){m=k*+g[u+(d<<4)>>2]+l*+g[u+(d<<4)+4>>2]+n*+g[u+(d<<4)+8>>2];b=m>o;x=b?d:x;d=d+1|0;if((d|0)==(w|0))break;else o=b?m:o}}else x=-1;t=f*+g[u+(x<<4)+4>>2];v=j*+g[u+(x<<4)+8>>2];g[a>>2]=h*+g[u+(x<<4)>>2];g[a+4>>2]=t;g[a+8>>2]=v;g[a+12>>2]=0.0;i=e;return};case 0:{s=+g[b+28>>2];t=+g[b+32>>2];t=+g[d+4>>2]>=0.0?t:-t;v=+g[b+36>>2];v=+g[d+8>>2]>=0.0?v:-v;g[a>>2]=+g[d>>2]>=0.0?s:-s;g[a+4>>2]=t;g[a+8>>2]=v;g[a+12>>2]=0.0;i=e;return};default:{rc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);i=e;return}}}function ax(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0;e=i;i=i+32|0;c[e+16>>2]=c[d+0>>2];c[e+20>>2]=c[d+4>>2];c[e+24>>2]=c[d+8>>2];c[e+28>>2]=c[d+12>>2];h=+g[e+16>>2];j=+g[e+20>>2];f=+g[e+24>>2];if(h*h+j*j+f*f<1.4210854715202004e-14){g[e+16>>2]=-1.0;g[e+20>>2]=-1.0;g[e+24>>2]=-1.0;g[e+28>>2]=0.0;h=-1.0;j=-1.0;f=-1.0}k=1.0/+Q(+(h*h+j*j+f*f));g[e+16>>2]=h*k;g[e+20>>2]=j*k;g[e+24>>2]=f*k;$w(e,b,e+16|0);switch(c[b+4>>2]|0){case 0:{f=+g[b+44>>2];break};case 11:{f=+g[b+44>>2];break};case 10:{f=+g[b+44>>2];break};case 8:{f=+g[b+28>>2]*+g[b+12>>2];break};case 13:{f=+g[b+44>>2];break};case 4:case 5:{f=+g[b+44>>2];break};case 1:{f=+g[b+44>>2];break};default:f=+$b[c[(c[b>>2]|0)+48>>2]&15](b)}j=f*+g[e+20>>2]+ +g[e+4>>2];k=f*+g[e+24>>2]+ +g[e+8>>2];g[a>>2]=f*+g[e+16>>2]+ +g[e>>2];g[a+4>>2]=j;g[a+8>>2]=k;g[a+12>>2]=0.0;i=e;return}function bx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0;e=i;i=i+80|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;f=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];if(f*f+j*j+h*h<9999999747378752.0e-20){f=1.0;j=0.0;h=0.0;k=0.0}else{k=1.0/+Q(+(f*f+j*j+h*h));f=f*k;j=j*k;h=h*k;k=+g[d+12>>2]}c[e+32>>2]=10856;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=-999999984306749400.0;g[e+56>>2]=f;g[e+60>>2]=j;g[e+64>>2]=h;g[e+68>>2]=k;g[e+16>>2]=999999984306749400.0;g[e+20>>2]=999999984306749400.0;g[e+24>>2]=999999984306749400.0;g[e+28>>2]=0.0;d=c[b+92>>2]|0;b=c[(c[d>>2]|0)+8>>2]|0;g[e>>2]=-999999984306749400.0;g[e+4>>2]=-999999984306749400.0;g[e+8>>2]=-999999984306749400.0;g[e+12>>2]=0.0;vc[b&127](d,e+32|0,e,e+16|0);c[a+0>>2]=c[e+36>>2];c[a+4>>2]=c[e+40>>2];c[a+8>>2]=c[e+44>>2];c[a+12>>2]=c[e+48>>2];i=e;return}function cx(a){a=a|0;return}function dx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0;f=i;i=i+80|0;if((e|0)>0)h=0;else{i=f;return}do{g[d+(h<<4)+12>>2]=-999999984306749400.0;h=h+1|0}while((h|0)!=(e|0));h=0;do{j=b+(h<<4)|0;c[f+32>>2]=10856;c[f+36>>2]=0;c[f+40>>2]=0;c[f+44>>2]=0;c[f+48>>2]=0;g[f+52>>2]=-999999984306749400.0;c[f+56>>2]=c[j+0>>2];c[f+60>>2]=c[j+4>>2];c[f+64>>2]=c[j+8>>2];c[f+68>>2]=c[j+12>>2];g[f+16>>2]=999999984306749400.0;g[f+20>>2]=999999984306749400.0;g[f+24>>2]=999999984306749400.0;g[f+28>>2]=0.0;j=c[a+92>>2]|0;k=c[(c[j>>2]|0)+8>>2]|0;g[f>>2]=-999999984306749400.0;g[f+4>>2]=-999999984306749400.0;g[f+8>>2]=-999999984306749400.0;g[f+12>>2]=0.0;vc[k&127](j,f+32|0,f,f+16|0);j=d+(h<<4)|0;c[j+0>>2]=c[f+36>>2];c[j+4>>2]=c[f+40>>2];c[j+8>>2]=c[f+44>>2];c[j+12>>2]=c[f+48>>2];h=h+1|0}while((h|0)<(e|0));i=f;return}function ex(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;rc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+$b[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+Q(+(f*f+(l*l+k*k)));j=+$b[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*h*k+ +g[a+4>>2];g[a+8>>2]=j*h*f+ +g[a+8>>2];i=e;return}function fx(a){a=a|0;return 0}function gx(a){a=a|0;return 0}function hx(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function ix(a,b,c){a=a|0;b=b|0;c=c|0;return}function jx(a){a=a|0;return 0}function kx(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function lx(a,b,c){a=a|0;b=b|0;c=+c;return 0}function mx(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=(c[a+92>>2]|0)+4|0;c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];EA(a);i=d;return}function nx(a){a=a|0;return(c[a+92>>2]|0)+4|0}function ox(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=15736;d=c[a+52>>2]|0;if(!d){i=b;return}Lb[c[c[d>>2]>>2]&511](d);a=c[a+52>>2]|0;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function px(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=15736;d=c[a+52>>2]|0;if(d){Lb[c[c[d>>2]>>2]&511](d);d=c[a+52>>2]|0;if(d){c[5006]=(c[5006]|0)+1;gF(c[d+ -4>>2]|0)}if(!a){i=b;return}}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function qx(a){a=a|0;return 10832}function rx(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function sx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;f=+g[a+24>>2];j=+g[a+28>>2];h=+g[a+32>>2];k=f*+g[b>>2]+j*+g[b+4>>2]+h*+g[b+8>>2];l=+g[a+20>>2];if(k>l){g[a+20>>2]=k;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2]}else k=l;l=f*+g[b+16>>2]+j*+g[b+20>>2]+h*+g[b+24>>2];if(l>k){g[a+20>>2]=l;c[a+4>>2]=c[b+16>>2];c[a+8>>2]=c[b+20>>2];c[a+12>>2]=c[b+24>>2];c[a+16>>2]=c[b+28>>2];k=l}f=f*+g[b+32>>2]+j*+g[b+36>>2]+h*+g[b+40>>2];if(!(f>k)){i=e;return}g[a+20>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+8>>2]=c[b+36>>2];c[a+12>>2]=c[b+40>>2];c[a+16>>2]=c[b+44>>2];i=e;return}function tx(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0;d=i;c[a+4>>2]=35;c[a+8>>2]=0;g[a+12>>2]=1.0;g[a+16>>2]=1.0;g[a+20>>2]=1.0;g[a+24>>2]=0.0;g[a+44>>2]=.03999999910593033;c[a>>2]=10928;c[a+52>>2]=1;f=+g[b>>2];h=+g[b+4>>2];e=+g[b+8>>2];if(f<h)j=f<e?0:2;else j=h<e?1:2;e=+g[b+(j<<2)>>2]*.10000000149011612;if(e<.03999999910593033){l=+Ts(a);k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);h=+$b[c[(c[a>>2]|0)+48>>2]&15](a);l=l+ +g[a+28>>2];k=k+ +g[a+32>>2];h=h+ +g[a+36>>2];g[a+44>>2]=e;e=+$b[c[(c[a>>2]|0)+48>>2]&15](a);f=+$b[c[(c[a>>2]|0)+48>>2]&15](a);h=h- +$b[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=l-e;g[a+32>>2]=k-f;g[a+36>>2]=h;g[a+40>>2]=0.0;j=c[a>>2]|0}else j=10928|0;h=+$b[c[j+48>>2]&15](a);k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);l=+$b[c[(c[a>>2]|0)+48>>2]&15](a);k=+g[b+4>>2]*+g[a+16>>2]-k;l=+g[b+8>>2]*+g[a+20>>2]-l;g[a+28>>2]=+g[b>>2]*+g[a+12>>2]-h;g[a+32>>2]=k;g[a+36>>2]=l;g[a+40>>2]=0.0;c[a+4>>2]=13;i=d;return}function ux(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;f=i;k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);o=k+ +g[a+28>>2];m=k+ +g[a+32>>2];k=k+ +g[a+36>>2];w=+P(+(+g[b>>2]));v=+P(+(+g[b+4>>2]));u=+P(+(+g[b+8>>2]));s=+P(+(+g[b+16>>2]));r=+P(+(+g[b+20>>2]));q=+P(+(+g[b+24>>2]));n=+P(+(+g[b+32>>2]));l=+P(+(+g[b+36>>2]));j=+P(+(+g[b+40>>2]));t=+g[b+48>>2];p=+g[b+52>>2];h=+g[b+56>>2];g[d>>2]=t-(o*w+m*v+k*u);g[d+4>>2]=p-(o*s+m*r+k*q);g[d+8>>2]=h-(o*n+m*l+k*j);g[d+12>>2]=0.0;g[e>>2]=o*w+m*v+k*u+t;g[e+4>>2]=o*s+m*r+k*q+p;g[e+8>>2]=o*n+m*l+k*j+h;g[e+12>>2]=0.0;i=f;return}function vx(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0,h=0.0,j=0,k=0.0,l=0.0;e=i;i=i+16|0;c[e+0>>2]=c[a+28>>2];c[e+4>>2]=c[a+32>>2];c[e+8>>2]=c[a+36>>2];c[e+12>>2]=c[a+40>>2];l=+$b[c[(c[a>>2]|0)+48>>2]&15](a);h=+$b[c[(c[a>>2]|0)+48>>2]&15](a);k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);g[e>>2]=l+ +g[e>>2];g[e+4>>2]=h+ +g[e+4>>2];g[e+8>>2]=k+ +g[e+8>>2];a=c[a+52>>2]|0;if((a|0)==2){f=2;j=0}else if(!a){f=0;j=1}else{f=1;j=0}h=+g[e+(j<<2)>>2];k=+g[e+(f<<2)>>2];k=b*.25*h*h+b/12.0*k*k*4.0;if(!a){g[d>>2]=b*.5*h*h;g[d+4>>2]=k;g[d+8>>2]=k;g[d+12>>2]=0.0;i=e;return}else if((a|0)==2){g[d>>2]=k;g[d+4>>2]=k;g[d+8>>2]=b*.5*h*h;g[d+12>>2]=0.0;i=e;return}else{g[d>>2]=k;g[d+4>>2]=b*.5*h*h;g[d+8>>2]=k;g[d+12>>2]=0.0;i=e;return}}function wx(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0;d=i;e=+g[b+32>>2];k=+g[b+28>>2];j=+g[c+4>>2];h=+g[c+8>>2];f=+Q(+(j*j+h*h));if(f!=0.0){g[a+4>>2]=j*(e/f);if(+g[c>>2]<0.0)k=-k;g[a>>2]=k;g[a+8>>2]=h*(e/f);i=d;return}else{g[a+4>>2]=e;if(+g[c>>2]<0.0)k=-k;g[a>>2]=k;g[a+8>>2]=0.0;i=d;return}}function xx(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0;d=i;e=+g[b+28>>2];k=+g[b+36>>2];j=+g[c>>2];h=+g[c+4>>2];f=+Q(+(j*j+h*h));if(f!=0.0){g[a>>2]=j*(e/f);if(+g[c+8>>2]<0.0)k=-k;g[a+8>>2]=k;g[a+4>>2]=h*(e/f);i=d;return}else{g[a>>2]=e;if(+g[c+8>>2]<0.0)k=-k;g[a+8>>2]=k;g[a+4>>2]=0.0;i=d;return}}function yx(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0;d=i;e=+g[b+28>>2];k=+g[b+32>>2];j=+g[c>>2];h=+g[c+8>>2];f=+Q(+(j*j+h*h));if(f!=0.0){g[a>>2]=j*(e/f);if(+g[c+4>>2]<0.0)k=-k;g[a+4>>2]=k;g[a+8>>2]=h*(e/f);i=d;return}else{g[a>>2]=e;if(+g[c+4>>2]<0.0)k=-k;g[a+4>>2]=k;g[a+8>>2]=0.0;i=d;return}}function zx(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;f=i;if((d|0)<=0){i=f;return}e=0;do{j=+g[a+28>>2];m=+g[a+32>>2];h=+g[b+(e<<4)>>2];k=+g[b+(e<<4)+8>>2];l=+Q(+(h*h+k*k));if(!(l!=0.0))if(+g[b+(e<<4)+4>>2]<0.0){h=j;m=-m;j=0.0}else{h=j;j=0.0}else{if(+g[b+(e<<4)+4>>2]<0.0)m=-m;h=h*(j/l);j=k*(j/l)}g[c+(e<<4)>>2]=h;g[c+(e<<4)+4>>2]=m;g[c+(e<<4)+8>>2]=j;e=e+1|0}while((e|0)!=(d|0));i=f;return}function Ax(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;f=i;if((d|0)<=0){i=f;return}e=0;do{m=+g[a+28>>2];j=+g[a+36>>2];h=+g[b+(e<<4)>>2];l=+g[b+(e<<4)+4>>2];k=+Q(+(h*h+l*l));if(!(k!=0.0))if(+g[b+(e<<4)+8>>2]<0.0){h=m;k=0.0;j=-j}else{h=m;k=0.0}else{if(+g[b+(e<<4)+8>>2]<0.0)j=-j;h=h*(m/k);k=l*(m/k)}g[c+(e<<4)>>2]=h;g[c+(e<<4)+4>>2]=k;g[c+(e<<4)+8>>2]=j;e=e+1|0}while((e|0)!=(d|0));i=f;return}function Bx(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;f=i;if((d|0)<=0){i=f;return}e=0;do{h=+g[a+32>>2];m=+g[a+28>>2];n=b+(e<<4)|0;l=+g[b+(e<<4)+4>>2];j=+g[b+(e<<4)+8>>2];k=+Q(+(l*l+j*j));if(!(k!=0.0))if(+g[n>>2]<0.0){m=-m;l=h;h=0.0}else{l=h;h=0.0}else{if(+g[n>>2]<0.0)m=-m;l=l*(h/k);h=j*(h/k)}g[c+(e<<4)>>2]=m;g[c+(e<<4)+4>>2]=l;g[c+(e<<4)+8>>2]=h;e=e+1|0}while((e|0)!=(d|0));i=f;return}function Cx(a){a=a|0;return}function Dx(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Ex(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;d=i;m=+$b[c[(c[a>>2]|0)+48>>2]&15](a);j=+$b[c[(c[a>>2]|0)+48>>2]&15](a);e=+$b[c[(c[a>>2]|0)+48>>2]&15](a);o=(m+ +g[a+28>>2])/+g[a+12>>2];l=(j+ +g[a+32>>2])/+g[a+16>>2];h=(e+ +g[a+36>>2])/+g[a+20>>2];n=+P(+(+g[b>>2]));k=+P(+(+g[b+4>>2]));f=+P(+(+g[b+8>>2]));g[a+12>>2]=n;g[a+16>>2]=k;g[a+20>>2]=f;g[a+24>>2]=0.0;g[a+28>>2]=o*n-m;g[a+32>>2]=l*k-j;g[a+36>>2]=h*f-e;g[a+40>>2]=0.0;i=d;return}function Fx(a){a=a|0;return 11408}function Gx(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+52>>2]<<2)>>2]=1.0;i=d;return}function Hx(a,b){a=a|0;b=+b;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0;d=i;j=+$b[c[(c[a>>2]|0)+48>>2]&15](a);f=+$b[c[(c[a>>2]|0)+48>>2]&15](a);k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+28>>2];f=f+ +g[a+32>>2];k=k+ +g[a+36>>2];g[a+44>>2]=b;h=+$b[c[(c[a>>2]|0)+48>>2]&15](a);e=+$b[c[(c[a>>2]|0)+48>>2]&15](a);b=k- +$b[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=j-h;g[a+32>>2]=f-e;g[a+36>>2]=b;g[a+40>>2]=0.0;i=d;return}function Ix(a){a=a|0;return 60}function Jx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;e=i;f=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=gc[c[(c[d>>2]|0)+28>>2]&31](d,f)|0;c[b>>2]=h;if(h)Nb[c[(c[d>>2]|0)+48>>2]&127](d,f);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];c[b+52>>2]=c[a+52>>2];i=e;return 11384}function Kx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;rc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+$b[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+Q(+(f*f+(l*l+k*k)));j=+$b[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*h*k+ +g[a+4>>2];g[a+8>>2]=j*h*f+ +g[a+8>>2];i=e;return}function Lx(a){a=a|0;var b=0.0,d=0.0,e=0;e=i;d=+g[a+28>>2];b=+$b[c[(c[a>>2]|0)+48>>2]&15](a);+$b[c[(c[a>>2]|0)+48>>2]&15](a);+$b[c[(c[a>>2]|0)+48>>2]&15](a);i=e;return+(d+b)}function Mx(a){a=a|0;return}function Nx(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Ox(a){a=a|0;return 11368}function Px(a){a=a|0;var b=0.0,d=0.0,e=0;e=i;d=+g[a+32>>2];+$b[c[(c[a>>2]|0)+48>>2]&15](a);b=+$b[c[(c[a>>2]|0)+48>>2]&15](a);+$b[c[(c[a>>2]|0)+48>>2]&15](a);i=e;return+(d+b)}function Qx(a){a=a|0;return}function Rx(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Sx(a){a=a|0;return 11352}function Tx(a){a=a|0;var b=0.0,d=0.0,e=0;e=i;d=+g[a+28>>2];b=+$b[c[(c[a>>2]|0)+48>>2]&15](a);+$b[c[(c[a>>2]|0)+48>>2]&15](a);+$b[c[(c[a>>2]|0)+48>>2]&15](a);i=e;return+(d+b)}function Ux(b){b=b|0;var d=0,e=0;d=i;e=c[b>>2]|0;if(e)Vx(b,e);e=c[b+4>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+4>>2]=0;c[b+8>>2]=-1;e=c[b+32>>2]|0;if(e){if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+16>>2]=0;e=c[b+52>>2]|0;if(!e){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=d;return}if(!(a[b+56>>0]|0)){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=d;return}c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0);e=c[b+32>>2]|0;a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;if(!e){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=d;return}if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=d;return}function Vx(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;if(c[b+40>>2]|0){Vx(a,c[b+36>>2]|0);Vx(a,c[b+40>>2]|0)}if((c[a>>2]|0)==(b|0))c[a>>2]=0;e=c[a+4>>2]|0;if(!e){c[a+4>>2]=b;i=d;return}c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0);c[a+4>>2]=b;i=d;return}function Wx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;d=i;i=i+32|0;if((b|0)<0)b=c[a+12>>2]|0;j=c[a>>2]|0;if(!((j|0)!=0&(b|0)>0)){i=d;return}while(1){f=j+40|0;a:do if(c[f>>2]|0){e=0;while(1){g=(c[a+16>>2]|0)>>>e&1;k=j+32|0;h=c[k>>2]|0;if(h>>>0>j>>>0){l=(c[h+40>>2]|0)==(j|0)&1;m=c[h+((l^1)<<2)+36>>2]|0;n=c[h+32>>2]|0;if(!n)c[a>>2]=j;else c[n+(((c[n+40>>2]|0)==(h|0)&1)<<2)+36>>2]=j;c[m+32>>2]=j;c[h+32>>2]=j;c[k>>2]=n;n=j+36|0;c[h+36>>2]=c[n>>2];c[h+40>>2]=c[f>>2];c[(c[n>>2]|0)+32>>2]=h;c[(c[f>>2]|0)+32>>2]=h;c[j+(l<<2)+36>>2]=h;c[j+((l^1)<<2)+36>>2]=m;c[d+0>>2]=c[h+0>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];c[d+16>>2]=c[h+16>>2];c[d+20>>2]=c[h+20>>2];c[d+24>>2]=c[h+24>>2];c[d+28>>2]=c[h+28>>2];c[h+0>>2]=c[j+0>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[h+16>>2]=c[j+16>>2];c[h+20>>2]=c[j+20>>2];c[h+24>>2]=c[j+24>>2];c[h+28>>2]=c[j+28>>2];c[j+0>>2]=c[d+0>>2];c[j+4>>2]=c[d+4>>2];c[j+8>>2]=c[d+8>>2];c[j+12>>2]=c[d+12>>2];c[j+16>>2]=c[d+16>>2];c[j+20>>2]=c[d+20>>2];c[j+24>>2]=c[d+24>>2];c[j+28>>2]=c[d+28>>2]}else h=j;j=c[h+(g<<2)+36>>2]|0;if(!(c[j+40>>2]|0))break a;f=j+40|0;e=e+1&31}}while(0);if(!(Yx(a,j)|0))e=0;else e=c[a>>2]|0;Xx(a,e,j);c[a+16>>2]=(c[a+16>>2]|0)+1;b=b+ -1|0;if(!b)break;j=c[a>>2]|0}i=d;return}function Xx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0,r=0,s=0.0;e=i;if(!(c[a>>2]|0)){c[a>>2]=d;c[d+32>>2]=0;i=e;return}f=c[b+40>>2]|0;if(f){l=+g[d>>2]+ +g[d+16>>2];j=+g[d+4>>2]+ +g[d+20>>2];h=+g[d+8>>2]+ +g[d+24>>2];do{r=c[b+36>>2]|0;p=+P(+(l-(+g[r>>2]+ +g[r+16>>2])))+ +P(+(j-(+g[r+4>>2]+ +g[r+20>>2])))+ +P(+(h-(+g[r+8>>2]+ +g[r+24>>2])));b=c[b+((!(p<+P(+(l-(+g[f>>2]+ +g[f+16>>2])))+ +P(+(j-(+g[f+4>>2]+ +g[f+20>>2])))+ +P(+(h-(+g[f+8>>2]+ +g[f+24>>2]))))&1)<<2)+36>>2]|0;f=c[b+40>>2]|0}while((f|0)!=0)}k=b+32|0;f=c[k>>2]|0;r=c[a+4>>2]|0;if(!r){c[5004]=(c[5004]|0)+1;r=fF(63)|0;if((r|0)!=0?(c[(r+19&-16)+ -4>>2]=r,(r+19&-16|0)!=0):0){o=(r+19&-16)+0|0;q=o+44|0;do{c[o>>2]=0;o=o+4|0}while((o|0)<(q|0));r=r+19&-16}else r=0}else c[a+4>>2]=0;c[r+32>>2]=f;o=r+36|0;c[o>>2]=0;q=r+40|0;c[q>>2]=0;s=+g[d>>2];p=+g[b>>2];p=s<p?s:p;g[r>>2]=p;s=+g[d+16>>2];l=+g[b+16>>2];l=s>l?s:l;g[r+16>>2]=l;s=+g[d+4>>2];n=+g[b+4>>2];n=s<n?s:n;g[r+4>>2]=n;s=+g[d+20>>2];j=+g[b+20>>2];j=s>j?s:j;g[r+20>>2]=j;s=+g[d+8>>2];m=+g[b+8>>2];m=s<m?s:m;g[r+8>>2]=m;s=+g[d+24>>2];h=+g[b+24>>2];h=s>h?s:h;g[r+24>>2]=h;if(!f){c[o>>2]=b;c[k>>2]=r;c[q>>2]=d;c[d+32>>2]=r;c[a>>2]=r;i=e;return}c[f+(((c[(c[k>>2]|0)+40>>2]|0)==(b|0)&1)<<2)+36>>2]=r;c[o>>2]=b;c[k>>2]=r;c[q>>2]=d;c[d+32>>2]=r;while(1){d=f+4|0;if(((((+g[f>>2]<=p?+g[d>>2]<=n:0)?+g[f+8>>2]<=m:0)?+g[f+16>>2]>=l:0)?+g[f+20>>2]>=j:0)?+g[f+24>>2]>=h:0){d=21;break}q=c[f+36>>2]|0;r=c[f+40>>2]|0;s=+g[q>>2];p=+g[r>>2];p=s<p?s:p;g[f>>2]=p;s=+g[q+16>>2];l=+g[r+16>>2];l=s>l?s:l;g[f+16>>2]=l;s=+g[q+4>>2];n=+g[r+4>>2];n=s<n?s:n;g[d>>2]=n;s=+g[q+20>>2];j=+g[r+20>>2];j=s>j?s:j;g[f+20>>2]=j;s=+g[q+8>>2];m=+g[r+8>>2];m=s<m?s:m;g[f+8>>2]=m;s=+g[q+24>>2];h=+g[r+24>>2];h=s>h?s:h;g[f+24>>2]=h;f=c[f+32>>2]|0;if(!f){d=21;break}}if((d|0)==21){i=e;return}}function Yx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0;d=i;if((c[a>>2]|0)==(b|0)){c[a>>2]=0;b=0;i=d;return b|0}f=c[b+32>>2]|0;h=c[f+32>>2]|0;b=c[f+(((c[f+40>>2]|0)!=(b|0)&1)<<2)+36>>2]|0;if(!h){c[a>>2]=b;c[b+32>>2]=0;e=c[a+4>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[a+4>>2]=f;b=c[a>>2]|0;i=d;return b|0}c[h+(((c[h+40>>2]|0)==(f|0)&1)<<2)+36>>2]=b;c[b+32>>2]=h;b=c[a+4>>2]|0;if(b){c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0)}c[a+4>>2]=f;do{u=+g[h>>2];z=h+4|0;s=+g[z>>2];x=h+8|0;q=+g[x>>2];A=h+16|0;o=+g[A>>2];y=h+20|0;m=+g[y>>2];b=h+24|0;k=+g[b>>2];w=c[h+36>>2]|0;f=c[h+40>>2]|0;v=+g[w>>2];t=+g[f>>2];t=v<t?v:t;g[h>>2]=t;v=+g[w+16>>2];n=+g[f+16>>2];n=v>n?v:n;g[A>>2]=n;v=+g[w+4>>2];r=+g[f+4>>2];r=v<r?v:r;g[z>>2]=r;v=+g[w+20>>2];l=+g[f+20>>2];l=v>l?v:l;g[y>>2]=l;v=+g[w+8>>2];p=+g[f+8>>2];p=v<p?v:p;g[x>>2]=p;v=+g[w+24>>2];j=+g[f+24>>2];j=v>j?v:j;g[b>>2]=j;if(!(u!=t|s!=r|q!=p|o!=n)?!(m!=l|k!=j):0){e=14;break}h=c[h+32>>2]|0}while((h|0)!=0);if((e|0)==14){i=d;return h|0}A=c[a>>2]|0;i=d;return A|0}function Zx(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;c[b>>2]=11432;f=b+4|0;do{a[f+36>>0]=1;c[f+32>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;a[f+56>>0]=1;c[f+52>>2]=0;c[f+44>>2]=0;c[f+48>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=-1;c[f+12>>2]=0;c[f+16>>2]=0;f=f+60|0}while((f|0)!=(b+124|0));a[b+193>>0]=0;a[b+194>>0]=1;a[b+192>>0]=(d|0)!=0^1;g[b+140>>2]=0.0;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+168>>2]=0;c[b+172>>2]=0;g[b+176>>2]=0.0;if(d){f=b+136|0;c[f>>2]=d;f=b+188|0;c[f>>2]=0;f=b+180|0;c[f>>2]=0;f=b+184|0;c[f>>2]=0;f=b+124|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;i=e;return}c[5004]=(c[5004]|0)+1;d=fF(95)|0;if((d|0)!=0?(c[(d+19&-16)+ -4>>2]=d,(d+19&-16|0)!=0):0){Yz(d+19&-16);d=d+19&-16}else d=0;f=b+136|0;c[f>>2]=d;f=b+188|0;c[f>>2]=0;f=b+180|0;c[f>>2]=0;f=b+184|0;c[f>>2]=0;f=b+124|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;i=e;return}function _x(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=11432;if((a[b+192>>0]|0)!=0?(e=c[b+136>>2]|0,Lb[c[c[e>>2]>>2]&511](e),e=c[b+136>>2]|0,(e|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=b+124|0;do{e=e+ -60|0;Ux(e)}while((e|0)!=(b+4|0));gF(b);i=d;return}function $x(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=11432;if((a[b+192>>0]|0)!=0?(e=c[b+136>>2]|0,Lb[c[c[e>>2]>>2]&511](e),e=c[b+136>>2]|0,(e|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=b+124|0;do{e=e+ -60|0;Ux(e)}while((e|0)!=(b+4|0));i=d;return}function ay(d,e,f,g,h,j,k,l,m){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;m=i;i=i+48|0;c[5004]=(c[5004]|0)+1;g=fF(83)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}c[g>>2]=h;b[g+4>>1]=j;b[g+6>>1]=k;h=g+16|0;c[h+0>>2]=c[e+0>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];h=g+32|0;c[h+0>>2]=c[f+0>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];c[g+8>>2]=0;h=g+56|0;c[h>>2]=0;j=g+52|0;c[j>>2]=0;c[m+16>>2]=c[e+0>>2];c[m+20>>2]=c[e+4>>2];c[m+24>>2]=c[e+8>>2];c[m+28>>2]=c[e+12>>2];c[m+32>>2]=c[f+0>>2];c[m+36>>2]=c[f+4>>2];c[m+40>>2]=c[f+8>>2];c[m+44>>2]=c[f+12>>2];c[g+60>>2]=c[d+144>>2];e=(c[d+188>>2]|0)+1|0;c[d+188>>2]=e;c[g+12>>2]=e;e=c[d+8>>2]|0;if(!e){c[5004]=(c[5004]|0)+1;e=fF(63)|0;if((e|0)!=0?(c[(e+19&-16)+ -4>>2]=e,(e+19&-16|0)!=0):0){k=(e+19&-16)+0|0;f=k+44|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(f|0));e=e+19&-16}else e=0}else c[d+8>>2]=0;c[e+32>>2]=0;c[e+36>>2]=g;c[e+40>>2]=0;c[e+0>>2]=c[m+16>>2];c[e+4>>2]=c[m+20>>2];c[e+8>>2]=c[m+24>>2];c[e+12>>2]=c[m+28>>2];c[e+16>>2]=c[m+32>>2];c[e+20>>2]=c[m+36>>2];c[e+24>>2]=c[m+40>>2];c[e+28>>2]=c[m+44>>2];Xx(d+4|0,c[d+4>>2]|0,e);c[d+16>>2]=(c[d+16>>2]|0)+1;c[g+48>>2]=e;e=d+(c[d+144>>2]<<2)+124|0;c[j>>2]=0;c[h>>2]=c[e>>2];f=c[e>>2]|0;if(f)c[f+52>>2]=g;c[e>>2]=g;if(a[d+193>>0]|0){i=m;return g|0}c[m>>2]=11696;c[m+4>>2]=d;c[m+8>>2]=g;by(c[d+4>>2]|0,m+16|0,m);by(c[d+64>>2]|0,m+16|0,m);i=m;return g|0}function by(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0,j=0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;h=i;if(!a){i=h;return}e=+g[b>>2];n=+g[b+4>>2];o=+g[b+8>>2];k=+g[b+16>>2];m=+g[b+20>>2];p=+g[b+24>>2];c[5004]=(c[5004]|0)+1;q=fF(275)|0;if(q){c[(q+19&-16)+ -4>>2]=q;b=q+19&-16;if(q+19&-16)c[b>>2]=a}else b=0;t=64;a=1;do{r=a+ -1|0;q=c[b+(r<<2)>>2]|0;do if(((((+g[q>>2]<=k?+g[q+16>>2]>=e:0)?+g[q+4>>2]<=m:0)?+g[q+20>>2]>=n:0)?+g[q+8>>2]<=p:0)?+g[q+24>>2]>=o:0){if(!(c[q+40>>2]|0)){Nb[c[(c[d>>2]|0)+12>>2]&127](d,q);a=r;break}s=c[q+36>>2]|0;if((r|0)==(t|0)?(f=(t|0)==0?1:t<<1,(a|0)<=(f|0)):0){if((f|0)!=0?(c[5004]=(c[5004]|0)+1,l=fF((f<<2|3)+16|0)|0,(l|0)!=0):0){c[(l+19&-16)+ -4>>2]=l;u=l+19&-16}else u=0;if((t|0)>0){w=0;do{v=u+(w<<2)|0;if(v)c[v>>2]=c[b+(w<<2)>>2];w=w+1|0}while((w|0)!=(t|0))}if(!b){t=f;b=u}else{c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);t=f;b=u}}r=b+(r<<2)|0;if(r)c[r>>2]=s;q=c[q+40>>2]|0;if((a|0)==(t|0)){t=(a|0)==0?1:a<<1;if((a|0)<(t|0)){if((t|0)!=0?(c[5004]=(c[5004]|0)+1,j=fF((t<<2|3)+16|0)|0,(j|0)!=0):0){c[(j+19&-16)+ -4>>2]=j;r=j+19&-16}else r=0;if((a|0)>0){s=0;do{u=r+(s<<2)|0;if(u)c[u>>2]=c[b+(s<<2)>>2];s=s+1|0}while((s|0)!=(a|0))}if(!b)b=r;else{c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);b=r}}else t=a}r=b+(a<<2)|0;if(r)c[r>>2]=q;a=a+1|0}else a=r;while(0)}while((a|0)>0);if(!b){i=h;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=h;return}function cy(a){a=a|0;return}function dy(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;if((c[d+60>>2]|0)==2){g=c[d+48>>2]|0;Yx(b+64|0,g)|0;h=c[b+68>>2]|0;if(h){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+68>>2]=g;c[b+76>>2]=(c[b+76>>2]|0)+ -1}else{g=c[d+48>>2]|0;Yx(b+4|0,g)|0;h=c[b+8>>2]|0;if(h){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+8>>2]=g;c[b+16>>2]=(c[b+16>>2]|0)+ -1}h=c[d+52>>2]|0;g=c[d+56>>2]|0;if(!h)c[b+(c[d+60>>2]<<2)+124>>2]=g;else c[h+56>>2]=g;g=c[d+56>>2]|0;if(g)c[g+52>>2]=c[d+52>>2];h=c[b+136>>2]|0;rc[c[(c[h>>2]|0)+16>>2]&127](h,d,e);if(!d){h=b+194|0;a[h>>0]=1;i=f;return}c[5006]=(c[5006]|0)+1;gF(c[d+ -4>>2]|0);h=b+194|0;a[h>>0]=1;i=f;return}function ey(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=i;c[d+0>>2]=c[b+16>>2];c[d+4>>2]=c[b+20>>2];c[d+8>>2]=c[b+24>>2];c[d+12>>2]=c[b+28>>2];c[e+0>>2]=c[b+32>>2];c[e+4>>2]=c[b+36>>2];c[e+8>>2]=c[b+40>>2];c[e+12>>2]=c[b+44>>2];i=a;return}function fy(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;d=i;i=i+16|0;c[d>>2]=11616;c[d+4>>2]=e;gy(a+4|0,c[a+4>>2]|0,b,e+4|0,e+20|0,+g[e+32>>2],f,h,d);gy(a+64|0,c[a+64>>2]|0,b,e+4|0,e+20|0,+g[e+32>>2],f,h,d);i=d;return}function gy(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=+j;k=k|0;l=l|0;m=m|0;var n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0,D=0,E=0.0;o=i;i=i+32|0;if(!d){i=o;return}s=c[b+44>>2]|0;if((s|0)<128){if((c[b+48>>2]|0)<128){c[5004]=(c[5004]|0)+1;t=fF(531)|0;if(!t)t=0;else{c[(t+19&-16)+ -4>>2]=t;t=t+19&-16}v=c[b+44>>2]|0;if((v|0)>0){u=0;do{w=t+(u<<2)|0;if(w)c[w>>2]=c[(c[b+52>>2]|0)+(u<<2)>>2];u=u+1|0}while((u|0)!=(v|0))}u=c[b+52>>2]|0;if(u){if(a[b+56>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[u+ -4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=t;c[b+48>>2]=128;t=b+52|0}else t=b+52|0;do{u=(c[t>>2]|0)+(s<<2)|0;if(u)c[u>>2]=0;s=s+1|0}while((s|0)!=128);s=b+48|0}else s=b+48|0;c[b+44>>2]=128;c[c[b+52>>2]>>2]=d;d=1;v=126;do{t=d+ -1|0;w=c[b+52>>2]|0;u=c[w+(t<<2)>>2]|0;y=+g[u+4>>2]- +g[l+4>>2];x=+g[u+8>>2]- +g[l+8>>2];g[o>>2]=+g[u>>2]- +g[l>>2];g[o+4>>2]=y;g[o+8>>2]=x;g[o+12>>2]=0.0;x=+g[u+20>>2]- +g[k+4>>2];y=+g[u+24>>2]- +g[k+8>>2];g[o+16>>2]=+g[u+16>>2]- +g[k>>2];g[o+20>>2]=x;g[o+24>>2]=y;g[o+28>>2]=0.0;D=c[h>>2]|0;y=+g[e>>2];x=+g[f>>2];z=(+g[o+(D<<4)>>2]-y)*x;y=x*(+g[o+(1-D<<4)>>2]-y);D=c[h+4>>2]|0;x=+g[e+4>>2];E=+g[f+4>>2];A=(+g[o+(D<<4)+4>>2]-x)*E;x=E*(+g[o+(1-D<<4)+4>>2]-x);do if(((!(z>x|A>y)?(p=A>z?A:z,r=x<y?x:y,D=c[h+8>>2]|0,q=+g[e+8>>2],E=+g[f+8>>2],n=(+g[o+(D<<4)+8>>2]-q)*E,q=E*(+g[o+(1-D<<4)+8>>2]-q),!(p>q|n>r)):0)?(n>p?n:p)<j:0)?(q<r?q:r)>0.0:0){if(!(c[u+40>>2]|0)){Nb[c[(c[m>>2]|0)+12>>2]&127](m,u);d=t;break}if((t|0)>(v|0)){v=c[b+44>>2]|0;if((v|0)<(v<<1|0)){if((c[s>>2]|0)<(v<<1|0)){if(v){c[5004]=(c[5004]|0)+1;w=fF((v<<3|3)+16|0)|0;if(!w)w=0;else{c[(w+19&-16)+ -4>>2]=w;w=w+19&-16}C=c[b+44>>2]|0;if((C|0)>0){B=0;do{D=w+(B<<2)|0;if(D)c[D>>2]=c[(c[b+52>>2]|0)+(B<<2)>>2];B=B+1|0}while((B|0)!=(C|0))}}else w=0;B=c[b+52>>2]|0;if(B){if(a[b+56>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[B+ -4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=w;c[s>>2]=v<<1;B=v}else B=v;do{w=w+(B<<2)|0;if(w)c[w>>2]=0;B=B+1|0;w=c[b+52>>2]|0}while((B|0)!=(v<<1|0))}c[b+44>>2]=v<<1;v=(v<<1)+ -2|0}c[w+(t<<2)>>2]=c[u+36>>2];c[(c[b+52>>2]|0)+(d<<2)>>2]=c[u+40>>2];d=d+1|0}else d=t;while(0)}while((d|0)!=0);i=o;return}function hy(a){a=a|0;return}function iy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+48|0;c[f+32>>2]=11536;c[f+36>>2]=e;c[f+0>>2]=c[b+0>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];c[f+16>>2]=c[d+0>>2];c[f+20>>2]=c[d+4>>2];c[f+24>>2]=c[d+8>>2];c[f+28>>2]=c[d+12>>2];by(c[a+4>>2]|0,f,f+32|0);by(c[a+64>>2]|0,f,f+32|0);i=f;return}function jy(a){a=a|0;return}function ky(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0,H=0.0;h=i;i=i+16|0;r=+g[e>>2];p=+g[e+4>>2];n=+g[e+8>>2];k=+g[e+12>>2];q=+g[f>>2];o=+g[f+4>>2];m=+g[f+8>>2];j=+g[f+12>>2];do if((c[d+60>>2]|0)==2){D=c[d+48>>2]|0;Yx(b+64|0,D)|0;l=c[b+68>>2]|0;if(l){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[b+68>>2]=D;c[b+76>>2]=(c[b+76>>2]|0)+ -1;l=c[b+8>>2]|0;if(!l){c[5004]=(c[5004]|0)+1;D=fF(63)|0;if((D|0)!=0?(c[(D+19&-16)+ -4>>2]=D,(D+19&-16|0)!=0):0){E=(D+19&-16)+0|0;l=E+44|0;do{c[E>>2]=0;E=E+4|0}while((E|0)<(l|0));l=D+19&-16}else l=0}else c[b+8>>2]=0;c[l+32>>2]=0;c[l+36>>2]=d;c[l+40>>2]=0;g[l>>2]=r;g[l+4>>2]=p;g[l+8>>2]=n;g[l+12>>2]=k;g[l+16>>2]=q;g[l+20>>2]=o;g[l+24>>2]=m;g[l+28>>2]=j;Xx(b+4|0,c[b+4>>2]|0,l);c[b+16>>2]=(c[b+16>>2]|0)+1;c[d+48>>2]=l;l=1}else{c[b+168>>2]=(c[b+168>>2]|0)+1;l=c[d+48>>2]|0;y=+g[l>>2];if(((((y<=q?(s=+g[l+16>>2],s>=r):0)?(t=+g[l+4>>2],t<=o):0)?(w=+g[l+20>>2],w>=p):0)?(u=+g[l+8>>2],u<=m):0)?(v=+g[l+24>>2],v>=n):0){H=+g[d+16>>2];C=+g[d+20>>2];B=+g[d+24>>2];x=+g[b+140>>2];z=(+g[d+32>>2]-H)*.5*x;A=x*(+g[d+36>>2]-C)*.5;x=x*(+g[d+40>>2]-B)*.5;if(r-H<0.0)z=-z;if(p-C<0.0)A=-A;if(n-B<0.0)x=-x;if(!(!(y<=r)|!(t<=p)|!(u<=n)|!(s>=q)|!(w>=o)|!(v>=m))){l=0;break}if(z>0.0){r=r+-.05000000074505806;q=z+(q+.05000000074505806)}else{r=z+(r+-.05000000074505806);q=q+.05000000074505806}if(A>0.0){p=p+-.05000000074505806;o=A+(o+.05000000074505806)}else{p=A+(p+-.05000000074505806);o=o+.05000000074505806}if(x>0.0){n=n+-.05000000074505806;m=x+(m+.05000000074505806)}else{n=x+(n+-.05000000074505806);m=m+.05000000074505806}F=Yx(b+4|0,l)|0;a:do if(F){D=c[b+12>>2]|0;if((D|0)<=-1){F=c[b+4>>2]|0;break}if((D|0)>0){E=0;while(1){G=c[F+32>>2]|0;E=E+1|0;if(!G)break a;if((E|0)>=(D|0)){F=G;break}else F=G}}}else F=0;while(0);g[l>>2]=r;g[l+4>>2]=p;g[l+8>>2]=n;g[l+12>>2]=k;g[l+16>>2]=q;g[l+20>>2]=o;g[l+24>>2]=m;g[l+28>>2]=j;Xx(b+4|0,F,l);c[b+172>>2]=(c[b+172>>2]|0)+1;l=1;break}F=Yx(b+4|0,l)|0;b:do if(F){D=c[b+12>>2]|0;if((D|0)<=-1){F=c[b+4>>2]|0;break}if((D|0)>0){E=0;while(1){G=c[F+32>>2]|0;E=E+1|0;if(!G)break b;if((E|0)>=(D|0)){F=G;break}else F=G}}}else F=0;while(0);g[l>>2]=r;g[l+4>>2]=p;g[l+8>>2]=n;g[l+12>>2]=k;g[l+16>>2]=q;g[l+20>>2]=o;g[l+24>>2]=m;g[l+28>>2]=j;Xx(b+4|0,F,l);c[b+172>>2]=(c[b+172>>2]|0)+1;l=1}while(0);D=c[d+52>>2]|0;E=c[d+56>>2]|0;if(!D)c[b+(c[d+60>>2]<<2)+124>>2]=E;else c[D+56>>2]=E;D=c[d+56>>2]|0;if(D)c[D+52>>2]=c[d+52>>2];c[d+16>>2]=c[e+0>>2];c[d+20>>2]=c[e+4>>2];c[d+24>>2]=c[e+8>>2];c[d+28>>2]=c[e+12>>2];c[d+32>>2]=c[f+0>>2];c[d+36>>2]=c[f+4>>2];c[d+40>>2]=c[f+8>>2];c[d+44>>2]=c[f+12>>2];c[d+60>>2]=c[b+144>>2];f=b+(c[b+144>>2]<<2)+124|0;c[d+52>>2]=0;c[d+56>>2]=c[f>>2];e=c[f>>2]|0;if(e)c[e+52>>2]=d;c[f>>2]=d;if(!l){i=h;return}a[b+194>>0]=1;if(a[b+193>>0]|0){i=h;return}c[h>>2]=11696;c[h+4>>2]=b;ly(b+64|0,c[b+64>>2]|0,c[d+48>>2]|0,h);ly(b+4|0,c[b+4>>2]|0,c[d+48>>2]|0,h);i=h;return}function ly(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;h=i;if((d|0)==0|(e|0)==0){i=h;return}if((c[b+24>>2]|0)<128?(c[b+28>>2]|0)<128:0){c[5004]=(c[5004]|0)+1;j=fF(1043)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}m=c[b+24>>2]|0;if((m|0)>0){l=0;do{k=j+(l<<3)|0;if(k){p=(c[b+32>>2]|0)+(l<<3)|0;q=c[p+4>>2]|0;c[k>>2]=c[p>>2];c[k+4>>2]=q}l=l+1|0}while((l|0)!=(m|0))}k=c[b+32>>2]|0;if(k){if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=j;c[b+28>>2]=128;j=b+28|0}else j=b+28|0;c[b+24>>2]=128;m=c[b+32>>2]|0;c[m>>2]=d;c[m+4>>2]=e;e=1;m=124;do{l=e+ -1|0;o=c[b+32>>2]|0;k=c[o+(l<<3)>>2]|0;d=c[o+(l<<3)+4>>2]|0;if((l|0)>(m|0)){m=c[b+24>>2]|0;if((m|0)<(m<<1|0)?(c[j>>2]|0)<(m<<1|0):0){if(m){c[5004]=(c[5004]|0)+1;n=fF((m<<4|3)+16|0)|0;if(!n)q=0;else{c[(n+19&-16)+ -4>>2]=n;q=n+19&-16}o=c[b+24>>2]|0;if((o|0)>0){n=0;do{p=q+(n<<3)|0;if(p){s=(c[b+32>>2]|0)+(n<<3)|0;r=c[s+4>>2]|0;c[p>>2]=c[s>>2];c[p+4>>2]=r}n=n+1|0}while((n|0)!=(o|0));o=q}else o=q}else o=0;n=c[b+32>>2]|0;if(n){if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[n+ -4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=o;c[j>>2]=m<<1}c[b+24>>2]=m<<1;m=(m<<1)+ -4|0}do if((k|0)==(d|0))if(!(c[k+40>>2]|0))e=l;else{r=c[k+36>>2]|0;s=o+(l<<3)|0;c[s>>2]=r;c[s+4>>2]=r;s=c[k+40>>2]|0;r=(c[b+32>>2]|0)+(e<<3)|0;c[r>>2]=s;c[r+4>>2]=s;r=c[k+40>>2]|0;s=(c[b+32>>2]|0)+(e+1<<3)|0;c[s>>2]=c[k+36>>2];c[s+4>>2]=r;e=e+2|0}else if(((((+g[k>>2]<=+g[d+16>>2]?+g[k+16>>2]>=+g[d>>2]:0)?+g[k+4>>2]<=+g[d+20>>2]:0)?+g[k+20>>2]>=+g[d+4>>2]:0)?+g[k+8>>2]<=+g[d+24>>2]:0)?+g[k+24>>2]>=+g[d+8>>2]:0){n=(c[d+40>>2]|0)!=0;if(!(c[k+40>>2]|0))if(n){s=c[d+36>>2]|0;r=o+(l<<3)|0;c[r>>2]=k;c[r+4>>2]=s;r=c[d+40>>2]|0;s=(c[b+32>>2]|0)+(e<<3)|0;c[s>>2]=k;c[s+4>>2]=r;e=e+1|0;break}else{rc[c[(c[f>>2]|0)+8>>2]&127](f,k,d);e=l;break}else{l=o+(l<<3)|0;o=c[k+36>>2]|0;if(n){r=c[d+36>>2]|0;c[l>>2]=o;c[l+4>>2]=r;r=c[d+36>>2]|0;s=(c[b+32>>2]|0)+(e<<3)|0;c[s>>2]=c[k+40>>2];c[s+4>>2]=r;s=c[d+40>>2]|0;r=(c[b+32>>2]|0)+(e+1<<3)|0;c[r>>2]=c[k+36>>2];c[r+4>>2]=s;r=c[d+40>>2]|0;s=(c[b+32>>2]|0)+(e+2<<3)|0;c[s>>2]=c[k+40>>2];c[s+4>>2]=r;e=e+3|0;break}else{c[l>>2]=o;c[l+4>>2]=d;s=(c[b+32>>2]|0)+(e<<3)|0;c[s>>2]=c[k+40>>2];c[s+4>>2]=d;e=e+1|0;break}}}else e=l;while(0)}while((e|0)!=0);i=h;return}function my(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;i=i+48|0;Wx(b+4|0,((aa(c[b+152>>2]|0,c[b+16>>2]|0)|0)/100|0)+1|0);if(c[b+164>>2]|0){p=((aa(c[b+148>>2]|0,c[b+76>>2]|0)|0)/100|0)+1|0;Wx(b+64|0,p);p=(c[b+164>>2]|0)-p|0;c[b+164>>2]=(p|0)<0?0:p}l=((c[b+144>>2]|0)+1|0)%2|0;c[b+144>>2]=l;l=c[b+(l<<2)+124>>2]|0;if(l){do{m=l+56|0;k=l;l=c[m>>2]|0;n=c[k+52>>2]|0;if(!n)c[b+(c[k+60>>2]<<2)+124>>2]=l;else c[n+56>>2]=l;n=c[m>>2]|0;if(n)c[n+52>>2]=c[k+52>>2];c[k+52>>2]=0;c[m>>2]=c[b+132>>2];m=c[b+132>>2]|0;if(m)c[m+52>>2]=k;c[b+132>>2]=k;n=c[k+48>>2]|0;Yx(b+4|0,n)|0;m=c[b+8>>2]|0;if(m){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}c[b+8>>2]=n;c[b+16>>2]=(c[b+16>>2]|0)+ -1;c[e+16>>2]=c[k+16>>2];c[e+20>>2]=c[k+20>>2];c[e+24>>2]=c[k+24>>2];c[e+28>>2]=c[k+28>>2];c[e+32>>2]=c[k+32>>2];c[e+36>>2]=c[k+36>>2];c[e+40>>2]=c[k+40>>2];c[e+44>>2]=c[k+44>>2];m=c[b+68>>2]|0;if(!m){c[5004]=(c[5004]|0)+1;m=fF(63)|0;if((m|0)!=0?(c[(m+19&-16)+ -4>>2]=m,(m+19&-16|0)!=0):0){o=(m+19&-16)+0|0;n=o+44|0;do{c[o>>2]=0;o=o+4|0}while((o|0)<(n|0));m=m+19&-16}else m=0}else c[b+68>>2]=0;c[m+32>>2]=0;c[m+36>>2]=k;c[m+40>>2]=0;c[m+0>>2]=c[e+16>>2];c[m+4>>2]=c[e+20>>2];c[m+8>>2]=c[e+24>>2];c[m+12>>2]=c[e+28>>2];c[m+16>>2]=c[e+32>>2];c[m+20>>2]=c[e+36>>2];c[m+24>>2]=c[e+40>>2];c[m+28>>2]=c[e+44>>2];Xx(b+64|0,c[b+64>>2]|0,m);c[b+76>>2]=(c[b+76>>2]|0)+1;c[k+48>>2]=m;c[k+60>>2]=2}while((l|0)!=0);c[b+164>>2]=c[b+76>>2];a[b+194>>0]=1}c[e>>2]=11696;c[e+4>>2]=b;if((a[b+193>>0]|0)!=0?(ly(b+4|0,c[b+4>>2]|0,c[b+64>>2]|0,e),(a[b+193>>0]|0)!=0):0){p=c[b+4>>2]|0;ly(b+4|0,p,p,e)}do if((a[b+194>>0]|0)!=0?(h=c[b+136>>2]|0,h=Pb[c[(c[h>>2]|0)+28>>2]&127](h)|0,j=c[h+4>>2]|0,(j|0)>0):0){l=(aa(c[b+156>>2]|0,j)|0)/100|0;p=c[b+160>>2]|0;l=(p|0)>(l|0)?p:l;l=(j|0)<(l|0)?j:l;if((l|0)>0){k=0;do{n=((c[b+184>>2]|0)+k|0)%(j|0)|0;o=c[h+12>>2]|0;m=c[o+(n<<4)>>2]|0;n=c[o+(n<<4)+4>>2]|0;o=c[m+48>>2]|0;p=c[n+48>>2]|0;if(!(((((+g[o>>2]<=+g[p+16>>2]?+g[o+16>>2]>=+g[p>>2]:0)?+g[o+4>>2]<=+g[p+20>>2]:0)?+g[o+20>>2]>=+g[p+4>>2]:0)?+g[o+8>>2]<=+g[p+24>>2]:0)?+g[o+24>>2]>=+g[p+8>>2]:0)){j=c[b+136>>2]|0;Tb[c[(c[j>>2]|0)+12>>2]&31](j,m,n,d)|0;j=c[h+4>>2]|0;k=k+ -1|0;l=l+ -1|0}k=k+1|0}while((k|0)<(l|0));if((j|0)<=0){c[b+184>>2]=0;break}}c[b+184>>2]=((c[b+184>>2]|0)+l|0)%(j|0)|0}while(0);c[b+180>>2]=(c[b+180>>2]|0)+1;c[b+160>>2]=1;a[b+194>>0]=0;h=c[b+168>>2]|0;if(!h){g[b+176>>2]=0.0;j=c[b+172>>2]|0}else{j=c[b+172>>2]|0;g[b+176>>2]=+(j>>>0)/+(h>>>0)}c[b+172>>2]=j>>>1;c[b+168>>2]=h>>>1;p=c[b+136>>2]|0;if(!(Pb[c[(c[p>>2]|0)+56>>2]&127](p)|0)){i=e;return}h=c[b+136>>2]|0;h=Pb[c[(c[h>>2]|0)+28>>2]&127](h)|0;m=c[h+4>>2]|0;if((m|0)>1){os(h,0,m+ -1|0);o=0;l=0;j=0;k=0;f=45}else{l=0;o=0;j=0;k=0}while(1){if((f|0)==45)m=c[h+4>>2]|0;if((j|0)>=(m|0))break;n=c[h+12>>2]|0;m=n+(j<<4)|0;f=c[m>>2]|0;n=n+(j<<4)+4|0;p=c[n>>2]|0;if((f|0)==(l|0))if((p|0)==(o|0))f=55;else f=49;else{l=f;f=49}if((f|0)==49){f=0;q=c[l+48>>2]|0;o=c[p+48>>2]|0;if(((((+g[q>>2]<=+g[o+16>>2]?+g[q+16>>2]>=+g[o>>2]:0)?+g[q+4>>2]<=+g[o+20>>2]:0)?+g[q+20>>2]>=+g[o+4>>2]:0)?+g[q+8>>2]<=+g[o+24>>2]:0)?+g[q+24>>2]>=+g[o+8>>2]:0)o=p;else{o=p;f=55}}if((f|0)==55){q=c[b+136>>2]|0;rc[c[(c[q>>2]|0)+32>>2]&127](q,m,d);c[m>>2]=0;c[n>>2]=0;k=k+1|0}j=j+1|0;f=45}if((m|0)>1){os(h,0,m+ -1|0);m=c[h+4>>2]|0}b=m-k|0;if((k|0)<0){if((c[h+8>>2]|0)<(b|0)){if((m|0)==(k|0))d=0;else{c[5004]=(c[5004]|0)+1;d=fF((b<<4|3)+16|0)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}k=c[h+4>>2]|0}if((k|0)>0){f=0;do{q=c[h+12>>2]|0;c[d+(f<<4)>>2]=c[q+(f<<4)>>2];c[d+(f<<4)+4>>2]=c[q+(f<<4)+4>>2];c[d+(f<<4)+8>>2]=c[q+(f<<4)+8>>2];c[d+(f<<4)+12>>2]=c[q+(f<<4)+12>>2];f=f+1|0}while((f|0)!=(k|0))}f=c[h+12>>2]|0;if(f){if(a[h+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[h+12>>2]=0}a[h+16>>0]=1;c[h+12>>2]=d;c[h+8>>2]=b;d=h+12|0}else d=h+12|0;do{p=(c[d>>2]|0)+(m<<4)|0;m=m+1|0;q=(m|0)==(b|0);c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0}while(!q)}c[h+4>>2]=b;i=e;return}function ny(a){a=a|0;return c[a+136>>2]|0}function oy(a){a=a|0;return c[a+136>>2]|0}function py(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;e=i;f=c[a+4>>2]|0;a=c[a+64>>2]|0;do if(!f)if(!a){h=0.0;j=0.0;o=0.0;n=0.0;m=0.0;l=0.0;k=0.0;p=0.0}else{h=+g[a>>2];j=+g[a+4>>2];o=+g[a+8>>2];n=+g[a+12>>2];m=+g[a+16>>2];l=+g[a+20>>2];k=+g[a+24>>2];p=+g[a+28>>2]}else{h=+g[f>>2];if(!a){j=+g[f+4>>2];o=+g[f+8>>2];n=+g[f+12>>2];m=+g[f+16>>2];l=+g[f+20>>2];k=+g[f+24>>2];p=+g[f+28>>2];break}else{t=+g[a>>2];r=+g[f+16>>2];m=+g[a+16>>2];s=+g[f+4>>2];j=+g[a+4>>2];q=+g[f+20>>2];l=+g[a+20>>2];n=+g[f+8>>2];o=+g[a+8>>2];p=+g[f+24>>2];k=+g[a+24>>2];h=h<t?h:t;j=s<j?s:j;o=n<o?n:o;n=0.0;m=r>m?r:m;l=q>l?q:l;k=p>k?p:k;p=0.0;break}}while(0);g[b>>2]=h;g[b+4>>2]=j;g[b+8>>2]=o;g[b+12>>2]=n;g[d>>2]=m;g[d+4>>2]=l;g[d+8>>2]=k;g[d+12>>2]=p;i=e;return}function qy(b,d){b=b|0;d=d|0;var e=0;d=i;if((c[b+16>>2]|0)!=(0-(c[b+76>>2]|0)|0)){i=d;return}e=c[b+4>>2]|0;if(e)Vx(b+4|0,e);e=c[b+8>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+8>>2]=0;c[b+12>>2]=-1;e=c[b+36>>2]|0;if(e){if(a[b+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+20>>2]=0;e=c[b+64>>2]|0;if(e)Vx(b+64|0,e);e=c[b+68>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+68>>2]=0;c[b+72>>2]=-1;e=c[b+96>>2]|0;if(e){if(a[b+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b+80>>2]=0;a[b+193>>0]=0;a[b+194>>0]=1;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+124>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;c[b+176>>2]=0;c[b+180>>2]=0;c[b+184>>2]=0;c[b+188>>2]=0;i=d;return}function ry(a){a=a|0;return}function sy(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function ty(a,b){a=a|0;b=b|0;var d=0;d=i;a=c[a+4>>2]|0;gc[c[(c[a>>2]|0)+8>>2]&31](a,c[b+36>>2]|0)|0;i=d;return}function uy(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function vy(a,b){a=a|0;b=b|0;var d=0;d=i;a=c[a+4>>2]|0;gc[c[(c[a>>2]|0)+8>>2]&31](a,c[b+36>>2]|0)|0;i=d;return}function wy(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function xy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;if((b|0)==(d|0)){i=e;return}f=c[(c[a+4>>2]|0)+136>>2]|0;Yb[c[(c[f>>2]|0)+8>>2]&31](f,c[b+36>>2]|0,c[d+36>>2]|0)|0;d=(c[a+4>>2]|0)+160|0;c[d>>2]=(c[d>>2]|0)+1;i=e;return}function yy(a,b){a=a|0;b=b|0;var d=0;d=i;rc[c[(c[a>>2]|0)+8>>2]&127](a,b,c[(c[a+8>>2]|0)+48>>2]|0);i=d;return}function zy(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;c[b>>2]=11776;c[5004]=(c[5004]|0)+1;k=fF(379)|0;if(!k)k=0;else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16}g[k+308>>2]=9999999747378752.0e-20;l=k+332|0;a[l>>0]=a[l>>0]&-16;c[b+24>>2]=k;k=(c[d+20>>2]|0)==0;c[5004]=(c[5004]|0)+1;l=fF(23)|0;if(!l)m=0;else{c[(l+19&-16)+ -4>>2]=l;m=l+19&-16}l=(m|0)==0;if(k){if(l)m=0;else c[m>>2]=14576;c[b+28>>2]=m}else{if(l)m=0;else c[m>>2]=13248;c[b+28>>2]=m}c[5004]=(c[5004]|0)+1;k=fF(43)|0;if((k|0)!=0?(j=k+19&-16,c[j+ -4>>2]=k,(k+19&-16|0)!=0):0){m=c[b+24>>2]|0;n=c[b+28>>2]|0;a[j+4>>0]=0;c[(k+19&-16)>>2]=18792;c[j+16>>2]=0;c[j+20>>2]=3;c[j+12>>2]=m;c[j+8>>2]=n;j=k+19&-16}else j=0;c[b+32>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12784;j=j+19&-16}else j=0;c[b+36>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12680;j=j+19&-16}else j=0;c[b+40>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12592;j=j+19&-16}else j=0;c[b+44>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12496;j=j+19&-16}else j=0;c[b+48>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12400;j=j+19&-16}else j=0;c[b+52>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12320;j=j+19&-16}else j=0;c[b+56>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12224;j=j+19&-16}else j=0;c[b+60>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12128;j=j+19&-16}else j=0;c[b+76>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12128;j=j+19&-16}else j=0;c[b+80>>2]=j;a[j+4>>0]=1;c[5004]=(c[5004]|0)+1;j=fF(27)|0;if((j|0)!=0?(c[(j+19&-16)+ -4>>2]=j,(j+19&-16|0)!=0):0){a[(j+19&-16)+4>>0]=0;c[(j+19&-16)>>2]=12040;j=j+19&-16}else j=0;c[b+72>>2]=j;c[5004]=(c[5004]|0)+1;j=fF(35)|0;if((j|0)!=0?(h=j+19&-16,c[h+ -4>>2]=j,(j+19&-16|0)!=0):0){a[h+4>>0]=0;c[(j+19&-16)>>2]=11904;c[h+8>>2]=1;c[h+12>>2]=0;h=j+19&-16}else h=0;c[b+88>>2]=h;c[5004]=(c[5004]|0)+1;h=fF(35)|0;if((h|0)!=0?(f=h+19&-16,c[f+ -4>>2]=h,(h+19&-16|0)!=0):0){a[f+4>>0]=0;c[(h+19&-16)>>2]=11904;c[f+8>>2]=1;c[f+12>>2]=0;f=h+19&-16}else f=0;c[b+84>>2]=f;a[f+4>>0]=1;f=c[d+16>>2]|0;f=(f|0)<36?36:f;f=(f|0)>80?f:80;f=(f|0)>44?f:44;h=c[d>>2]|0;if(!h){a[b+12>>0]=1;c[5004]=(c[5004]|0)+1;h=fF(39)|0;do if(!h)h=0;else{l=h+19&-16;c[l+ -4>>2]=h;if(!(h+19&-16)){h=0;break}j=c[d+8>>2]|0;c[(h+19&-16)>>2]=772;c[l+4>>2]=j;c[5004]=(c[5004]|0)+1;j=fF((j*772|3)+16|0)|0;if(!j)k=0;else{c[(j+19&-16)+ -4>>2]=j;k=j+19&-16}c[l+16>>2]=k;c[l+12>>2]=k;j=c[l+4>>2]|0;c[l+8>>2]=j;if(j+ -1|0){n=c[(h+19&-16)>>2]|0;m=j+ -1|0;l=k;do{o=l;l=l+n|0;c[o>>2]=l;m=m+ -1|0}while((m|0)!=0);k=k+(aa(n,j+ -1|0)|0)|0}c[k>>2]=0;h=h+19&-16}while(0);c[b+8>>2]=h}else{a[b+12>>0]=0;c[b+8>>2]=h}h=c[d+4>>2]|0;if(h){a[b+20>>0]=0;c[b+16>>2]=h;i=e;return}a[b+20>>0]=1;c[5004]=(c[5004]|0)+1;h=fF(39)|0;do if(!h)d=0;else{j=h+19&-16;c[j+ -4>>2]=h;if(!(h+19&-16)){d=0;break}d=c[d+12>>2]|0;c[(h+19&-16)>>2]=f;c[j+4>>2]=d;d=aa(d,f)|0;c[5004]=(c[5004]|0)+1;d=fF(d+19|0)|0;if(!d)f=0;else{c[(d+19&-16)+ -4>>2]=d;f=d+19&-16}c[j+16>>2]=f;c[j+12>>2]=f;d=c[j+4>>2]|0;c[j+8>>2]=d;if(d+ -1|0){k=c[(h+19&-16)>>2]|0;j=d+ -1|0;l=f;do{o=l;l=l+k|0;c[o>>2]=l;j=j+ -1|0}while((j|0)!=0);f=f+(aa(k,d+ -1|0)|0)|0}c[f>>2]=0;d=h+19&-16}while(0);c[b+16>>2]=d;i=e;return}function Ay(a){a=a|0;var b=0;b=i;By(a);gF(a);i=b;return}function By(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=11776;if(a[b+20>>0]|0){e=c[b+16>>2]|0;f=c[e+16>>2]|0;if(f){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0);e=c[b+16>>2]|0}if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}}if(a[b+12>>0]|0){e=c[b+8>>2]|0;f=c[e+16>>2]|0;if(f){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0);e=c[b+8>>2]|0}if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}}e=c[b+32>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+32>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+36>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+36>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+40>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+40>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+44>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+44>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+48>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+48>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+52>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+52>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+56>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+56>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+60>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+60>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+76>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+76>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+80>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+80>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+72>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+72>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+88>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+88>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+84>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+84>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+24>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}f=c[b+28>>2]|0;Lb[c[c[f>>2]>>2]&511](f);b=c[b+28>>2]|0;if(!b){i=d;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function Cy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;do if(!((b|0)==8&(d|0)==8)){if((b|0)==8&(d|0)==1){a=a+76|0;break}if((b|0)==1&(d|0)==8){a=a+80|0;break}if(!(d|b)){a=a+72|0;break}if((b|0)<20&(d|0)==28){a=a+88|0;break}if((d|0)<20&(b|0)==28){a=a+84|0;break}if((b|0)<20){if((d|0)<20){a=a+32|0;break}if((d+ -21|0)>>>0<9){a=a+36|0;break}}else if((d|0)<20?(b+ -21|0)>>>0<9:0){a=a+40|0;break}if((b|0)==31)if((d|0)==31){a=a+48|0;break}else{a=a+44|0;break}else if((d|0)==31){a=a+52|0;break}else{a=a+56|0;break}}else a=a+60|0;while(0);i=e;return c[a>>2]|0}function Dy(a){a=a|0;return c[a+8>>2]|0}function Ey(a){a=a|0;return c[a+16>>2]|0}function Fy(a){a=a|0;return c[a+24>>2]|0}function Gy(a){a=a|0;return}function Hy(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Iy(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;g=i;h=c[d>>2]|0;h=gc[c[(c[h>>2]|0)+56>>2]&31](h,28)|0;if(!(a[b+4>>0]|0)){if(!h){f=0;i=g;return f|0}j=c[b+8>>2]|0;b=c[b+12>>2]|0;d=c[d>>2]|0;c[h+4>>2]=d;c[h>>2]=19408;a[h+8>>0]=0;c[h+12>>2]=0;a[h+16>>0]=0;c[h+20>>2]=j;c[h+24>>2]=b;if(!(Yb[c[(c[d>>2]|0)+24>>2]&31](d,c[e+8>>2]|0,c[f+8>>2]|0)|0)){j=h;i=g;return j|0}j=c[h+4>>2]|0;c[h+12>>2]=Yb[c[(c[j>>2]|0)+12>>2]&31](j,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[h+8>>0]=1;j=h;i=g;return j|0}else{if(!h){j=0;i=g;return j|0}k=c[b+8>>2]|0;b=c[b+12>>2]|0;j=c[d>>2]|0;c[h+4>>2]=j;c[h>>2]=19408;a[h+8>>0]=0;c[h+12>>2]=0;a[h+16>>0]=1;c[h+20>>2]=k;c[h+24>>2]=b;if(!(Yb[c[(c[j>>2]|0)+24>>2]&31](j,c[f+8>>2]|0,c[e+8>>2]|0)|0)){k=h;i=g;return k|0}k=c[h+4>>2]|0;c[h+12>>2]=Yb[c[(c[k>>2]|0)+12>>2]&31](k,c[f+8>>2]|0,c[e+8>>2]|0)|0;a[h+8>>0]=1;k=h;i=g;return k|0}return 0}function Jy(a){a=a|0;return}function Ky(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Ly(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;b=i;g=c[d>>2]|0;g=gc[c[(c[g>>2]|0)+56>>2]&31](g,16)|0;if(!g){g=0;i=b;return g|0}d=c[d>>2]|0;c[g+4>>2]=d;c[g>>2]=17896;a[g+8>>0]=0;c[g+12>>2]=0;if(!(Yb[c[(c[d>>2]|0)+24>>2]&31](d,c[e+8>>2]|0,c[f+8>>2]|0)|0)){i=b;return g|0}d=c[g+4>>2]|0;c[g+12>>2]=Yb[c[(c[d>>2]|0)+12>>2]&31](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[g+8>>0]=1;i=b;return g|0}function My(a){a=a|0;return}function Ny(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Oy(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;h=c[d>>2]|0;h=gc[c[(c[h>>2]|0)+56>>2]&31](h,20)|0;if(!h){b=0;i=g;return b|0}j=c[d+4>>2]|0;b=a[b+4>>0]|0;d=c[d>>2]|0;c[h+4>>2]=d;c[h>>2]=16904;a[h+8>>0]=0;c[h+12>>2]=j;a[h+16>>0]=b;if(j){j=h;i=g;return j|0}c[h+12>>2]=Yb[c[(c[d>>2]|0)+12>>2]&31](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[h+8>>0]=1;j=h;i=g;return j|0}function Py(a){a=a|0;return}function Qy(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Ry(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;b=i;g=c[d>>2]|0;g=gc[c[(c[g>>2]|0)+56>>2]&31](g,16)|0;if(!g){g=0;i=b;return g|0}d=c[d>>2]|0;c[g+4>>2]=d;c[g>>2]=16816;a[g+8>>0]=0;c[g+12>>2]=0;c[g+12>>2]=Yb[c[(c[d>>2]|0)+12>>2]&31](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[g+8>>0]=1;i=b;return g|0}function Sy(a){a=a|0;return}function Ty(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Uy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;a=i;d=c[b>>2]|0;d=gc[c[(c[d>>2]|0)+56>>2]&31](d,8)|0;if(!d){e=0;i=a;return e|0}c[d+4>>2]=c[b>>2];c[d>>2]=12904;e=d;i=a;return e|0}function Vy(a){a=a|0;return}function Wy(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Xy(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;b=i;g=c[d>>2]|0;g=gc[c[(c[g>>2]|0)+56>>2]&31](g,44)|0;if(!g){g=0;i=b;return g|0}c[g+4>>2]=c[d>>2];c[g>>2]=18040;a[g+24>>0]=1;c[g+20>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;a[g+28>>0]=1;c[g+32>>2]=c[d+4>>2];a[g+36>>0]=0;c[g+40>>2]=c[(c[f+4>>2]|0)+68>>2];IC(g,e,f);i=b;return g|0}function Yy(a){a=a|0;return}function Zy(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function _y(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;h=i;b=c[d>>2]|0;b=gc[c[(c[b>>2]|0)+56>>2]&31](b,48)|0;if(!b){m=0;i=h;return m|0}c[b+4>>2]=c[d>>2];c[b>>2]=18208;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;c[b+32>>2]=c[d+4>>2];a[b+36>>0]=0;c[5004]=(c[5004]|0)+1;d=fF(87)|0;if((d|0)!=0?(g=d+19&-16,c[g+ -4>>2]=d,(d+19&-16|0)!=0):0){c[(d+19&-16)>>2]=19600;a[g+20>>0]=1;c[g+16>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;a[g+24>>0]=0;a[g+44>>0]=1;c[g+40>>2]=0;c[g+32>>2]=0;c[g+36>>2]=0;a[g+64>>0]=1;c[g+60>>2]=0;c[g+52>>2]=0;c[g+56>>2]=0;c[5004]=(c[5004]|0)+1;j=fF(43)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}k=c[g+8>>2]|0;if((k|0)>0){l=0;do{m=j+(l*12|0)|0;if(m){n=(c[g+16>>2]|0)+(l*12|0)|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2]}l=l+1|0}while((l|0)!=(k|0))}k=c[g+16>>2]|0;if(k){if(a[g+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0)}c[g+16>>2]=0}a[g+20>>0]=1;c[g+16>>2]=j;c[g+12>>2]=2;WD(d+19&-16);g=d+19&-16}else g=0;c[b+8>>2]=g;c[b+40>>2]=c[(c[e+4>>2]|0)+68>>2];c[b+44>>2]=c[(c[f+4>>2]|0)+68>>2];n=b;i=h;return n|0}function $y(a){a=a|0;return}function az(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function bz(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;b=i;g=c[d>>2]|0;g=gc[c[(c[g>>2]|0)+56>>2]&31](g,44)|0;if(!g){g=0;i=b;return g|0}c[g+4>>2]=c[d>>2];c[g>>2]=18040;a[g+24>>0]=1;c[g+20>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;a[g+28>>0]=0;c[g+32>>2]=c[d+4>>2];a[g+36>>0]=0;c[g+40>>2]=c[(c[e+4>>2]|0)+68>>2];IC(g,e,f);i=b;return g|0}function cz(a){a=a|0;return}function dz(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function ez(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;b=i;g=c[d>>2]|0;g=gc[c[(c[g>>2]|0)+56>>2]&31](g,80)|0;if(!g){g=0;i=b;return g|0}c[g+4>>2]=c[d>>2];c[g>>2]=18432;a[g+8>>0]=1;d=c[d>>2]|0;c[g+12>>2]=18464;c[g+60>>2]=d;c[g+64>>2]=0;c[g+16>>2]=f;c[g+20>>2]=e;e=Yb[c[(c[d>>2]|0)+12>>2]&31](d,c[f+8>>2]|0,c[e+8>>2]|0)|0;c[g+76>>2]=e;f=c[g+60>>2]|0;Nb[c[(c[f>>2]|0)+20>>2]&127](f,e);i=b;return g|0}function fz(a){a=a|0;return}function gz(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function hz(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;b=i;g=c[d>>2]|0;g=gc[c[(c[g>>2]|0)+56>>2]&31](g,80)|0;if(!g){g=0;i=b;return g|0}c[g+4>>2]=c[d>>2];c[g>>2]=18432;a[g+8>>0]=0;d=c[d>>2]|0;c[g+12>>2]=18464;c[g+60>>2]=d;c[g+64>>2]=0;c[g+16>>2]=e;c[g+20>>2]=f;f=Yb[c[(c[d>>2]|0)+12>>2]&31](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;c[g+76>>2]=f;e=c[g+60>>2]|0;Nb[c[(c[e>>2]|0)+20>>2]&127](e,f);i=b;return g|0}function iz(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return}function jz(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function kz(a){a=a|0;return}function lz(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function mz(a,b){a=a|0;b=b|0;return}function nz(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=13008;e=c[b+276>>2]|0;if(!e){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0}else{if(a[b+280>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function oz(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=13008;e=c[b+276>>2]|0;if(e){if(a[b+280>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;i=d;return}function pz(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;e=i;d=c[d>>2]|0;h=c[b+268>>2]|0;a:do if((h|0)>0){k=c[b+276>>2]|0;j=0;while(1){g=j+1|0;if((c[k+(j<<2)>>2]|0)==(d|0))break;if((g|0)<(h|0))j=g;else break a}if((j|0)!=(h|0)){i=e;return}}while(0);if((h|0)==(c[b+272>>2]|0)?(f=(h|0)==0?1:h<<1,(h|0)<(f|0)):0){if(!f)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[b+268>>2]|0}if((h|0)>0){k=0;do{j=g+(k<<2)|0;if(j)c[j>>2]=c[(c[b+276>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(h|0))}j=c[b+276>>2]|0;if(j){if(a[b+280>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=g;c[b+272>>2]=f}f=(c[b+276>>2]|0)+(h<<2)|0;if(f)c[f>>2]=d;c[b+268>>2]=h+1;i=e;return}function qz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;e=i;b=c[b>>2]|0;h=c[a+268>>2]|0;if((h|0)<=0){i=e;return}k=c[a+276>>2]|0;j=0;while(1){g=k+(j<<2)|0;d=j+1|0;if((c[g>>2]|0)==(b|0))break;if((d|0)<(h|0))j=d;else{f=7;break}}if((f|0)==7){i=e;return}if((j|0)>=(h|0)){i=e;return}c[g>>2]=c[k+(h+ -1<<2)>>2];c[a+268>>2]=h+ -1;i=e;return}function rz(a){a=a|0;var b=0;b=i;sz(a);if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function sz(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=13056;e=c[b+284>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+284>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b>>2]=13008;e=c[b+276>>2]|0;if(!e){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;e=b+272|0;c[e>>2]=0;i=d;return}if(a[b+280>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+276>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;e=b+272|0;c[e>>2]=0;i=d;return}function tz(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;if(!e)e=c[b+188>>2]|0;g=c[d>>2]|0;k=c[b+268>>2]|0;a:do if((k|0)>0){m=c[b+276>>2]|0;j=0;while(1){l=j+1|0;if((c[m+(j<<2)>>2]|0)==(g|0))break;if((l|0)<(k|0))j=l;else break a}if((j|0)!=(k|0)){i=f;return}}while(0);if((k|0)==(c[b+272>>2]|0)?(h=(k|0)==0?1:k<<1,(k|0)<(h|0)):0){if(!h)j=0;else{c[5004]=(c[5004]|0)+1;j=fF((h<<2|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}k=c[b+268>>2]|0}if((k|0)>0){m=0;do{l=j+(m<<2)|0;if(l)c[l>>2]=c[(c[b+276>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(k|0))}l=c[b+276>>2]|0;if(l){if(a[b+280>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0);k=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=j;c[b+272>>2]=h}h=(c[b+276>>2]|0)+(k<<2)|0;if(h)c[h>>2]=g;c[b+268>>2]=k+1;m=c[b+284>>2]|0;Yb[c[(c[m>>2]|0)+8>>2]&31](m,e,d)|0;i=f;return}function uz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;h=i;f=c[b>>2]|0;if(!e)e=c[a+188>>2]|0;k=c[a+268>>2]|0;if((k|0)<=0){i=h;return}l=c[a+276>>2]|0;m=0;while(1){n=l+(m<<2)|0;j=m+1|0;if((c[n>>2]|0)==(f|0))break;if((j|0)<(k|0))m=j;else{g=9;break}}if((g|0)==9){i=h;return}if((m|0)>=(k|0)){i=h;return}c[n>>2]=c[l+(k+ -1<<2)>>2];c[a+268>>2]=k+ -1;n=c[a+284>>2]|0;Tb[c[(c[n>>2]|0)+12>>2]&31](n,e,b,d)|0;i=h;return}function vz(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0,C=0,D=0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0.0,L=0.0,M=0.0;y=i;i=i+320|0;c[y+176>>2]=c[d+0>>2];c[y+180>>2]=c[d+4>>2];c[y+184>>2]=c[d+8>>2];c[y+188>>2]=c[d+12>>2];c[y+192>>2]=c[d+16>>2];c[y+196>>2]=c[d+20>>2];c[y+200>>2]=c[d+24>>2];c[y+204>>2]=c[d+28>>2];c[y+208>>2]=c[d+32>>2];c[y+212>>2]=c[d+36>>2];c[y+216>>2]=c[d+40>>2];c[y+220>>2]=c[d+44>>2];c[y+224>>2]=c[d+48>>2];c[y+228>>2]=c[d+52>>2];c[y+232>>2]=c[d+56>>2];c[y+236>>2]=c[d+60>>2];c[y+112>>2]=c[e+0>>2];c[y+116>>2]=c[e+4>>2];c[y+120>>2]=c[e+8>>2];c[y+124>>2]=c[e+12>>2];c[y+128>>2]=c[e+16>>2];c[y+132>>2]=c[e+20>>2];c[y+136>>2]=c[e+24>>2];c[y+140>>2]=c[e+28>>2];c[y+144>>2]=c[e+32>>2];c[y+148>>2]=c[e+36>>2];c[y+152>>2]=c[e+40>>2];c[y+156>>2]=c[e+44>>2];c[y+160>>2]=c[e+48>>2];c[y+164>>2]=c[e+52>>2];c[y+168>>2]=c[e+56>>2];c[y+172>>2]=c[e+60>>2];H=+g[y+164>>2]- +g[y+228>>2];M=+g[y+168>>2]- +g[y+232>>2];g[y+64>>2]=+g[y+160>>2]- +g[y+224>>2];g[y+68>>2]=H;g[y+72>>2]=M;g[y+76>>2]=0.0;Lo(y+176|0,y+112|0,y+248|0,y+240|0);M=+g[y+240>>2];H=M*+g[y+252>>2];F=M*+g[y+256>>2];g[y+48>>2]=+g[y+248>>2]*M;g[y+52>>2]=H;g[y+56>>2]=F;g[y+60>>2]=0.0;g[y+248>>2]=1.0;D=y+252|0;c[D+0>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;c[D+12>>2]=0;g[y+268>>2]=1.0;E=y+272|0;c[E+0>>2]=0;c[E+4>>2]=0;c[E+8>>2]=0;c[E+12>>2]=0;g[y+288>>2]=1.0;J=y+292|0;c[J+0>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;c[J+12>>2]=0;c[J+16>>2]=0;Hc(y+176|0,y+32|0);F=+g[y+32>>2];H=+g[y+36>>2];M=+g[y+40>>2];K=+g[y+44>>2];G=F*(2.0/(F*F+H*H+M*M+K*K));I=H*(2.0/(F*F+H*H+M*M+K*K));L=M*(2.0/(F*F+H*H+M*M+K*K));g[y+248>>2]=1.0-(H*I+M*L);g[D>>2]=F*I-K*L;g[y+256>>2]=F*L+K*I;g[y+260>>2]=0.0;g[y+264>>2]=F*I+K*L;g[y+268>>2]=1.0-(F*G+M*L);g[E>>2]=H*L-K*G;g[y+276>>2]=0.0;g[y+280>>2]=F*L-K*I;g[y+284>>2]=H*L+K*G;g[y+288>>2]=1.0-(F*G+H*I);g[J>>2]=0.0;wu(b,y+248|0,y+64|0,y+48|0,y+96|0,y+80|0);if((c[a+268>>2]|0)<=0){i=y;return}B=0;do{C=c[(c[a+276>>2]|0)+(B<<2)>>2]|0;if(gc[c[(c[f>>2]|0)+8>>2]&31](f,c[C+188>>2]|0)|0?(s=c[C+192>>2]|0,vc[c[(c[s>>2]|0)+8>>2]&127](s,C+4|0,y+16|0,y),z=+g[y+16>>2]+ +g[y+96>>2],v=+g[y+20>>2]+ +g[y+100>>2],p=+g[y+24>>2]+ +g[y+104>>2],g[y+16>>2]=z,g[y+20>>2]=v,g[y+24>>2]=p,g[y+28>>2]=0.0,j=+g[y>>2]+ +g[y+80>>2],u=+g[y+4>>2]+ +g[y+84>>2],o=+g[y+8>>2]+ +g[y+88>>2],g[y>>2]=j,g[y+4>>2]=u,g[y+8>>2]=o,g[y+12>>2]=0.0,x=+g[d+48>>2]-(j+z)*.5,t=+g[d+52>>2]-(u+v)*.5,n=+g[d+56>>2]-(o+p)*.5,A=+g[e+48>>2]-(j+z)*.5,w=+g[e+52>>2]-(u+v)*.5,q=+g[e+56>>2]-(o+p)*.5,s=x<-((j-z)*.5)|(x>(j-z)*.5?8:0)|(t>(u-v)*.5?16:0)|(t<-((u-v)*.5)?2:0)|(n>(o-p)*.5?32:0)|(n<-((o-p)*.5)?4:0),r=A<-((j-z)*.5)|(A>(j-z)*.5?8:0)|(w>(u-v)*.5?16:0)|(w<-((u-v)*.5)?2:0)|(q>(o-p)*.5?32:0)|(q<-((o-p)*.5)?4:0),(s&r|0)==0):0){G=1.0;D=1;E=0;H=0.0;F=1.0;while(1){if(!(D&s)){if((D&r|0)!=0?(m=(-x-F*(j-z)*.5)/(A-x),m<G):0)G=m}else{I=(-x-F*(j-z)*.5)/(A-x);if(H<=I)H=I}J=D<<1;if(!(J&s)){if((J&r|0)!=0?(l=(-t-F*(u-v)*.5)/(w-t),l<G):0)G=l}else{I=(-t-F*(u-v)*.5)/(w-t);if(H<=I)H=I}J=D<<2;if(!(J&s)){if((J&r|0)!=0?(k=(-n-F*(o-p)*.5)/(q-n),k<G):0)G=k}else{F=(-n-F*(o-p)*.5)/(q-n);if(H<=F)H=F}E=E+1|0;if((E|0)==2)break;else{D=D<<3;F=-1.0}}if(H<=G){J=c[C+192>>2]|0;c[y+248>>2]=0;c[y+252>>2]=J;c[y+256>>2]=C;c[y+260>>2]=C+4;c[y+264>>2]=-1;c[y+268>>2]=-1;Ku(b,y+176|0,y+112|0,y+248|0,f,h)}}B=B+1|0}while((B|0)<(c[a+268>>2]|0));i=y;return}function wz(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0.0;k=i;i=i+288|0;u=c[b+4>>2]|0;a[u+312>>0]=0;c[u>>2]=0;a[u+356>>0]=1;g[u+292>>2]=999999984306749400.0;g[u+296>>2]=999999984306749400.0;g[u+300>>2]=999999984306749400.0;g[u+304>>2]=0.0;c[u+336>>2]=0;c[u+340>>2]=0;c[u+344>>2]=0;c[u+348>>2]=0;a[u+352>>0]=0;a[u+332>>0]=a[u+332>>0]&-16;n=+g[e+48>>2]- +g[d+48>>2]-(+g[h+48>>2]- +g[f+48>>2]);m=+g[e+52>>2]- +g[d+52>>2]-(+g[h+52>>2]- +g[f+52>>2]);l=+g[e+56>>2]- +g[d+56>>2]-(+g[h+56>>2]- +g[f+56>>2]);c[k+216>>2]=10224;g[k+252>>2]=999999984306749400.0;a[k+256>>0]=0;u=c[b+8>>2]|0;t=c[b+12>>2]|0;b=c[b+4>>2]|0;c[k+136>>2]=13392;g[k+140>>2]=0.0;g[k+144>>2]=1.0;g[k+148>>2]=0.0;g[k+152>>2]=0.0;c[k+156>>2]=0;c[k+160>>2]=b;c[k+164>>2]=u;c[k+168>>2]=t;c[k+172>>2]=c[u+4>>2];c[k+176>>2]=c[t+4>>2];g[k+180>>2]=+$b[c[(c[u>>2]|0)+48>>2]&15](u);g[k+184>>2]=+$b[c[(c[t>>2]|0)+48>>2]&15](t);a[k+188>>0]=0;c[k+196>>2]=-1;c[k+208>>2]=1;c[k+212>>2]=1;g[k+128>>2]=999999984306749400.0;c[k+0>>2]=c[d+0>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];c[k+16>>2]=c[d+16>>2];c[k+20>>2]=c[d+20>>2];c[k+24>>2]=c[d+24>>2];c[k+28>>2]=c[d+28>>2];c[k+32>>2]=c[d+32>>2];c[k+36>>2]=c[d+36>>2];c[k+40>>2]=c[d+40>>2];c[k+44>>2]=c[d+44>>2];c[k+48>>2]=c[d+48>>2];c[k+52>>2]=c[d+52>>2];c[k+56>>2]=c[d+56>>2];c[k+60>>2]=c[d+60>>2];c[k+64>>2]=c[f+0>>2];c[k+68>>2]=c[f+4>>2];c[k+72>>2]=c[f+8>>2];c[k+76>>2]=c[f+12>>2];c[k+80>>2]=c[f+16>>2];c[k+84>>2]=c[f+20>>2];c[k+88>>2]=c[f+24>>2];c[k+92>>2]=c[f+28>>2];c[k+96>>2]=c[f+32>>2];c[k+100>>2]=c[f+36>>2];c[k+104>>2]=c[f+40>>2];c[k+108>>2]=c[f+44>>2];c[k+112>>2]=c[f+48>>2];c[k+116>>2]=c[f+52>>2];c[k+120>>2]=c[f+56>>2];c[k+124>>2]=c[f+60>>2];Az(k+136|0,k,k+216|0,0,0);t=(a[k+256>>0]|0)==0;b=k+236|0;c[k+264>>2]=c[b+0>>2];c[k+268>>2]=c[b+4>>2];c[k+272>>2]=c[b+8>>2];c[k+276>>2]=c[b+12>>2];if(t){u=0;i=k;return u|0}q=+g[k+252>>2];o=+g[k+220>>2];p=+g[k+224>>2];r=+g[k+228>>2];s=+g[k+232>>2];do if(q>.0010000000474974513){s=q;q=0.0;t=1;while(1){if((t|0)>32){j=0;e=13;break}v=q;q=q-s/(l*r+(m*p+n*o));if(!(!(q<0.0)&!(q>1.0)&!(q<=v))){j=0;e=13;break}Kb[c[c[j>>2]>>2]&31](j,q);v=1.0-q;g[k+48>>2]=v*+g[d+48>>2]+q*+g[e+48>>2];g[k+52>>2]=v*+g[d+52>>2]+q*+g[e+52>>2];g[k+56>>2]=v*+g[d+56>>2]+q*+g[e+56>>2];g[k+112>>2]=v*+g[f+48>>2]+q*+g[h+48>>2];g[k+116>>2]=v*+g[f+52>>2]+q*+g[h+52>>2];g[k+120>>2]=v*+g[f+56>>2]+q*+g[h+56>>2];Az(k+136|0,k,k+216|0,0,0);if(!(a[k+256>>0]|0)){j=0;e=13;break}s=+g[k+252>>2];if(s<0.0){e=8;break}c[k+264>>2]=c[b+0>>2];c[k+268>>2]=c[b+4>>2];c[k+272>>2]=c[b+8>>2];c[k+276>>2]=c[b+12>>2];o=+g[k+220>>2];p=+g[k+224>>2];r=+g[k+228>>2];if(!(s>.0010000000474974513)){e=10;break}else t=t+1|0}if((e|0)==8){g[j+164>>2]=q;r=+g[k+224>>2];s=+g[k+228>>2];v=+g[k+232>>2];g[j+132>>2]=+g[k+220>>2];g[j+136>>2]=r;g[j+140>>2]=s;g[j+144>>2]=v;c[j+148>>2]=c[b+0>>2];c[j+152>>2]=c[b+4>>2];c[j+156>>2]=c[b+8>>2];c[j+160>>2]=c[b+12>>2];u=1;i=k;return u|0}else if((e|0)==10){s=+g[k+232>>2];break}else if((e|0)==13){i=k;return j|0}}else q=0.0;while(0);if(l*r+(m*p+n*o)>=-+g[j+172>>2]){u=0;i=k;return u|0}g[j+164>>2]=q;g[j+132>>2]=o;g[j+136>>2]=p;g[j+140>>2]=r;g[j+144>>2]=s;c[j+148>>2]=c[k+264>>2];c[j+152>>2]=c[k+268>>2];c[j+156>>2]=c[k+272>>2];c[j+160>>2]=c[k+276>>2];u=1;i=k;return u|0}function xz(a){a=a|0;return}function yz(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function zz(b,e,f,h,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0,A=0,B=0.0,C=0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0;b=i;i=i+10240|0;U=+g[k+52>>2]- +g[j+52>>2];H=+g[k+56>>2]- +g[j+56>>2];g[b>>2]=+g[k+48>>2]- +g[j+48>>2];g[b+4>>2]=U;g[b+8>>2]=H;g[b+12>>2]=0.0;c[b+10088>>2]=f;c[b+10092>>2]=h;H=+g[k>>2];U=+g[j>>2];G=+g[k+16>>2];y=+g[j+16>>2];B=+g[k+32>>2];V=+g[j+32>>2];L=+g[j+4>>2];W=+g[j+20>>2];M=+g[j+36>>2];v=+g[j+8>>2];K=+g[j+24>>2];I=+g[j+40>>2];T=+g[k+4>>2];S=+g[k+20>>2];R=+g[k+36>>2];P=+g[k+8>>2];O=+g[k+24>>2];N=+g[k+40>>2];g[b+10096>>2]=H*U+G*y+B*V;g[b+10100>>2]=H*L+G*W+B*M;g[b+10104>>2]=H*v+G*K+B*I;g[b+10108>>2]=0.0;g[b+10112>>2]=U*T+y*S+V*R;g[b+10116>>2]=L*T+W*S+M*R;g[b+10120>>2]=v*T+K*S+I*R;g[b+10124>>2]=0.0;g[b+10128>>2]=U*P+y*O+V*N;g[b+10132>>2]=L*P+W*O+M*N;g[b+10136>>2]=v*P+K*O+I*N;g[b+10140>>2]=0.0;I=+g[k+48>>2]- +g[j+48>>2];K=+g[k+52>>2]- +g[j+52>>2];v=+g[k+56>>2]- +g[j+56>>2];M=+g[j>>2];W=+g[k>>2];L=+g[j+16>>2];V=+g[k+16>>2];y=+g[j+32>>2];U=+g[k+32>>2];B=+g[j+4>>2];G=+g[j+20>>2];H=+g[j+36>>2];J=+g[j+8>>2];w=+g[j+24>>2];u=+g[j+40>>2];g[b+10144>>2]=M*W+L*V+y*U;g[b+10148>>2]=M*T+L*S+y*R;g[b+10152>>2]=M*P+L*O+y*N;g[b+10156>>2]=0.0;g[b+10160>>2]=W*B+V*G+U*H;g[b+10164>>2]=T*B+S*G+R*H;g[b+10168>>2]=P*B+O*G+N*H;g[b+10172>>2]=0.0;g[b+10176>>2]=W*J+V*w+U*u;g[b+10180>>2]=T*J+S*w+R*u;g[b+10184>>2]=P*J+O*w+N*u;g[b+10188>>2]=0.0;g[b+10192>>2]=I*M+K*L+v*y;g[b+10196>>2]=I*B+K*G+v*H;g[b+10200>>2]=I*J+K*w+v*u;g[b+10204>>2]=0.0;c[b+10208>>2]=70;c[b+10212>>2]=0;c[b+10072>>2]=0;c[b+9836>>2]=0;c[b+9840>>2]=0;c[b+9844>>2]=0;c[b+9848>>2]=0;c[b+10084>>2]=2;c[b+10076>>2]=0;g[b+9852>>2]=0.0;u=+g[b>>2];v=+g[b+4>>2];w=+g[b+8>>2];g[b+9328>>2]=-u;g[b+9332>>2]=-v;g[b+9336>>2]=-w;g[b+9340>>2]=0.0;do if((OD(b+9708|0,b+10088|0,b+9328|0)|0)==1){e=b+9296|0;r=b+9304|0;q=b+9308|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[b+16>>2]=9;o=b+56|0;c[b+9292>>2]=0;c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;s=0;do{t=128-s+ -1|0;c[b+16+(t*56|0)+2152>>2]=0;x=c[r>>2]|0;c[b+16+(t*56|0)+2156>>2]=x;if(x)c[x+44>>2]=b+16+(t*56|0)+2108;c[r>>2]=b+16+(t*56|0)+2108;c[q>>2]=(c[q>>2]|0)+1;s=s+1|0}while((s|0)!=128);s=c[b+10080>>2]|0;if((c[s+32>>2]|0)>>>0>1?PD(b+9708|0)|0:0){t=c[e>>2]|0;if(t){z=c[b+9300>>2]|0;x=c[q>>2]|0;do{C=t+48|0;D=c[C>>2]|0;A=t+44|0;if(D)c[D+44>>2]=c[A>>2];D=c[A>>2]|0;if(D)c[D+48>>2]=c[C>>2];if((c[e>>2]|0)==(t|0))c[e>>2]=c[C>>2];z=z+ -1|0;c[A>>2]=0;c[C>>2]=c[r>>2];A=c[r>>2]|0;if(A)c[A+44>>2]=t;c[r>>2]=t;x=x+1|0;t=c[e>>2]|0}while((t|0)!=0);c[b+9300>>2]=z;c[q>>2]=x}c[b+16>>2]=0;c[b+9292>>2]=0;z=c[s>>2]|0;A=c[s+12>>2]|0;W=+g[A+16>>2];N=+g[z+16>>2]-W;P=+g[A+20>>2];R=+g[z+20>>2]-P;T=+g[A+24>>2];U=+g[z+24>>2]-T;A=c[s+4>>2]|0;S=+g[A+16>>2]-W;V=+g[A+20>>2]-P;O=+g[A+24>>2]-T;x=c[s+8>>2]|0;W=+g[x+16>>2]-W;P=+g[x+20>>2]-P;T=+g[x+24>>2]-T;if(N*V*T+(R*O*W+U*S*P-N*O*P-R*S*T)-U*V*W<0.0){c[s>>2]=A;c[s+4>>2]=z;W=+g[s+16>>2];g[s+16>>2]=+g[s+20>>2];g[s+20>>2]=W;t=A}else{t=z;z=A}t=QD(b+16|0,t,z,x,1)|0;x=QD(b+16|0,c[s+4>>2]|0,c[s>>2]|0,c[s+12>>2]|0,1)|0;z=QD(b+16|0,c[s+8>>2]|0,c[s+4>>2]|0,c[s+12>>2]|0,1)|0;A=QD(b+16|0,c[s>>2]|0,c[s+8>>2]|0,c[s+12>>2]|0,1)|0;if((c[b+9300>>2]|0)==4){C=c[e>>2]|0;B=+g[C+16>>2];s=c[C+48>>2]|0;if(s){u=B*B;while(1){v=+g[s+16>>2];D=v*v<u;C=D?s:C;s=c[s+48>>2]|0;if(!s)break;else u=D?v*v:u}B=+g[C+16>>2]}y=+g[C>>2];w=+g[C+4>>2];u=+g[C+8>>2];v=+g[C+12>>2];E=c[C+20>>2]|0;F=c[C+24>>2]|0;s=c[C+28>>2]|0;a[t+52>>0]=0;c[t+32>>2]=x;a[x+52>>0]=0;c[x+32>>2]=t;a[t+53>>0]=0;c[t+36>>2]=z;a[z+52>>0]=1;c[z+32>>2]=t;a[t+54>>0]=0;c[t+40>>2]=A;a[A+52>>0]=2;c[A+32>>2]=t;a[x+53>>0]=2;c[x+36>>2]=A;a[A+54>>0]=1;c[A+40>>2]=x;a[x+54>>0]=1;c[x+40>>2]=z;a[z+53>>0]=2;c[z+36>>2]=x;a[z+54>>0]=1;c[z+40>>2]=A;a[A+53>>0]=2;c[A+36>>2]=z;c[b+16>>2]=0;A=E;z=F;x=s;t=0;s=1;while(1){D=c[b+9292>>2]|0;if(D>>>0>=64){p=48;break}c[b+10216>>2]=0;c[b+10220>>2]=0;c[b+10224>>2]=0;c[b+9292>>2]=D+1;a[C+55>>0]=s;E=C+4|0;F=C+8|0;RD(b+9708|0,+g[C>>2],+g[E>>2],+g[F>>2],b+16+(D<<5)+60|0);if(+g[C>>2]*+g[b+16+(D<<5)+76>>2]+ +g[E>>2]*+g[b+16+(D<<5)+80>>2]+ +g[F>>2]*+g[b+16+(D<<5)+84>>2]- +g[C+16>>2]>9999999747378752.0e-20){E=0;F=1}else{p=47;break}do{F=F&(SD(b+16|0,s,b+16+(D<<5)+60|0,c[C+(E<<2)+32>>2]|0,d[C+E+52>>0]|0,b+10216|0)|0);E=E+1|0}while(!(E>>>0>2|F^1));if(!F){p=46;break}if((c[b+10224>>2]|0)>>>0<=2){p=46;break}A=c[b+10216>>2]|0;z=c[b+10220>>2]|0;a[A+53>>0]=2;c[A+36>>2]=z;a[z+54>>0]=1;c[z+40>>2]=A;z=C+48|0;A=c[z>>2]|0;x=C+44|0;if(A)c[A+44>>2]=c[x>>2];A=c[x>>2]|0;if(A)c[A+48>>2]=c[z>>2];if((c[e>>2]|0)==(C|0))c[e>>2]=c[z>>2];c[b+9300>>2]=(c[b+9300>>2]|0)+ -1;c[x>>2]=0;c[z>>2]=c[r>>2];x=c[r>>2]|0;if(x)c[x+44>>2]=C;c[r>>2]=C;c[q>>2]=(c[q>>2]|0)+1;C=c[e>>2]|0;B=+g[C+16>>2];x=c[C+48>>2]|0;if(x){u=B*B;while(1){v=+g[x+16>>2];z=v*v<u;C=z?x:C;x=c[x+48>>2]|0;if(!x)break;else u=z?v*v:u}B=+g[C+16>>2]}y=+g[C>>2];w=+g[C+4>>2];u=+g[C+8>>2];v=+g[C+12>>2];A=c[C+20>>2]|0;z=c[C+24>>2]|0;x=c[C+28>>2]|0;t=t+1|0;if(t>>>0>=255)break;else s=s+1|0}if((p|0)==46)c[b+16>>2]=4;else if((p|0)==47)c[b+16>>2]=7;else if((p|0)==48)c[b+16>>2]=6;S=B*y;P=B*w;U=B*u;g[o>>2]=y;g[b+60>>2]=w;g[b+64>>2]=u;g[b+68>>2]=v;g[b+72>>2]=B;c[b+52>>2]=3;c[b+20>>2]=A;c[b+24>>2]=z;c[b+28>>2]=x;D=z+16|0;T=+g[D>>2]-S;E=z+20|0;N=+g[E>>2]-P;F=z+24|0;R=+g[F>>2]-U;C=x+16|0;M=+g[C>>2]-S;z=x+20|0;O=+g[z>>2]-P;x=x+24|0;V=+g[x>>2]-U;V=+Q(+((T*O-N*M)*(T*O-N*M)+((N*V-R*O)*(N*V-R*O)+(R*M-T*V)*(R*M-T*V))));g[b+36>>2]=V;T=+g[C>>2]-S;M=+g[z>>2]-P;R=+g[x>>2]-U;x=A+16|0;O=+g[x>>2]-S;z=A+20|0;N=+g[z>>2]-P;C=A+24|0;W=+g[C>>2]-U;W=+Q(+((T*N-M*O)*(T*N-M*O)+((M*W-R*N)*(M*W-R*N)+(R*O-T*W)*(R*O-T*W))));g[b+40>>2]=W;T=+g[x>>2]-S;O=+g[z>>2]-P;R=+g[C>>2]-U;S=+g[D>>2]-S;P=+g[E>>2]-P;U=+g[F>>2]-U;U=+Q(+((T*P-O*S)*(T*P-O*S)+((O*U-R*P)*(O*U-R*P)+(R*S-T*U)*(R*S-T*U))));g[b+36>>2]=V/(U+(V+W));g[b+40>>2]=W/(U+(V+W));g[b+44>>2]=U/(U+(V+W));if((c[b+16>>2]|0)==9){o=0;u=0.0;v=0.0;w=0.0;B=0.0;H=0.0;I=0.0;J=0.0;G=0.0;y=0.0;break}if(!(c[b+52>>2]|0)){y=0.0;B=0.0;w=0.0}else{e=b+52|0;p=54}}else p=49}else p=49;if((p|0)==49){c[b+16>>2]=8;g[o>>2]=u;g[b+60>>2]=v;g[b+64>>2]=w;g[b+68>>2]=0.0;y=+Q(+(u*u+v*v+w*w));if(y>0.0){w=1.0/y*w;v=1.0/y*v;u=1.0/y*u}else{w=0.0;v=0.0;u=1.0}g[o>>2]=u;g[b+60>>2]=v;g[b+64>>2]=w;g[b+68>>2]=0.0;g[b+72>>2]=0.0;c[b+52>>2]=1;c[b+20>>2]=c[s>>2];g[b+36>>2]=1.0;e=b+52|0;p=54}if((p|0)==54){w=0.0;u=0.0;v=0.0;p=0;do{r=c[b+10208>>2]|0;F=c[b+10212>>2]|0;q=(c[b+10088>>2]|0)+(F>>1)|0;if(F&1)r=c[(c[q>>2]|0)+r>>2]|0;rc[r&127](b+9312|0,q,c[b+16+(p<<2)+4>>2]|0);W=+g[b+16+(p<<2)+20>>2];w=w+ +g[b+9312>>2]*W;u=u+W*+g[b+9316>>2];v=v+W*+g[b+9320>>2];p=p+1|0}while(p>>>0<(c[e>>2]|0)>>>0);y=v;B=u}Y=+g[j>>2];X=+g[j+4>>2];K=+g[j+8>>2];M=+g[j+16>>2];N=+g[j+20>>2];O=+g[j+24>>2];R=+g[j+32>>2];T=+g[j+36>>2];V=+g[j+40>>2];L=+g[j+48>>2];H=+g[j+52>>2];I=+g[j+56>>2];J=+g[o>>2];U=+g[b+72>>2];G=+g[b+60>>2];W=+g[b+64>>2];P=w-J*U;S=B-U*G;U=y-U*W;o=1;u=w*Y+B*X+y*K+L;v=w*M+B*N+y*O+H;w=w*R+B*T+y*V+I;B=P*Y+S*X+U*K+L;H=P*M+S*N+U*O+H;I=P*R+S*T+U*V+I;J=-J;G=-G;y=-W}else{o=0;u=0.0;v=0.0;w=0.0;B=0.0;H=0.0;I=0.0;J=0.0;G=0.0;y=0.0}while(0);if(o){g[m>>2]=u;g[m+4>>2]=v;g[m+8>>2]=w;g[m+12>>2]=0.0;g[n>>2]=B;g[n+4>>2]=H;g[n+8>>2]=I;g[n+12>>2]=0.0;g[l>>2]=J;g[l+4>>2]=G;g[l+8>>2]=y;g[l+12>>2]=0.0;F=1;i=b;return F|0}c[b+9708>>2]=f;c[b+9712>>2]=h;w=+g[k>>2];M=+g[j>>2];y=+g[k+16>>2];N=+g[j+16>>2];B=+g[k+32>>2];O=+g[j+32>>2];P=+g[j+4>>2];R=+g[j+20>>2];S=+g[j+36>>2];U=+g[j+8>>2];W=+g[j+24>>2];Y=+g[j+40>>2];G=+g[k+4>>2];H=+g[k+20>>2];I=+g[k+36>>2];J=+g[k+8>>2];K=+g[k+24>>2];L=+g[k+40>>2];g[b+9716>>2]=w*M+y*N+B*O;g[b+9720>>2]=w*P+y*R+B*S;g[b+9724>>2]=w*U+y*W+B*Y;g[b+9728>>2]=0.0;g[b+9732>>2]=M*G+N*H+O*I;g[b+9736>>2]=P*G+R*H+S*I;g[b+9740>>2]=U*G+W*H+Y*I;g[b+9744>>2]=0.0;g[b+9748>>2]=M*J+N*K+O*L;g[b+9752>>2]=P*J+R*K+S*L;g[b+9756>>2]=U*J+W*K+Y*L;g[b+9760>>2]=0.0;T=+g[k+48>>2]- +g[j+48>>2];V=+g[k+52>>2]- +g[j+52>>2];X=+g[k+56>>2]- +g[j+56>>2];g[b+9764>>2]=w*M+y*N+B*O;g[b+9768>>2]=M*G+N*H+O*I;g[b+9772>>2]=M*J+N*K+O*L;g[b+9776>>2]=0.0;g[b+9780>>2]=w*P+y*R+B*S;g[b+9784>>2]=P*G+R*H+S*I;g[b+9788>>2]=P*J+R*K+S*L;g[b+9792>>2]=0.0;g[b+9796>>2]=w*U+y*W+B*Y;g[b+9800>>2]=U*G+W*H+Y*I;g[b+9804>>2]=U*J+W*K+Y*L;g[b+9808>>2]=0.0;g[b+9812>>2]=T*M+V*N+X*O;g[b+9816>>2]=T*P+V*R+X*S;g[b+9820>>2]=T*U+V*W+X*Y;g[b+9824>>2]=0.0;c[b+9828>>2]=71;c[b+9832>>2]=0;c[b+9692>>2]=0;c[b+9456>>2]=0;c[b+9460>>2]=0;c[b+9464>>2]=0;c[b+9468>>2]=0;c[b+9704>>2]=2;c[b+9696>>2]=0;g[b+9472>>2]=0.0;if(OD(b+9328|0,b+9708|0,b)|0){F=0;i=b;return F|0}k=c[b+9700>>2]|0;if(!(c[k+32>>2]|0)){H=0.0;G=0.0;B=0.0;u=0.0;v=0.0;y=0.0}else{B=0.0;G=0.0;H=0.0;y=0.0;v=0.0;u=0.0;f=0;do{w=+g[k+(f<<2)+16>>2];o=c[b+9828>>2]|0;F=c[b+9832>>2]|0;h=(c[b+9708>>2]|0)+(F>>1)|0;if(F&1)o=c[(c[h>>2]|0)+o>>2]|0;rc[o&127](b+9312|0,h,c[k+(f<<2)>>2]|0);B=B+w*+g[b+9312>>2];G=G+w*+g[b+9316>>2];H=H+w*+g[b+9320>>2];h=c[(c[b+9700>>2]|0)+(f<<2)>>2]|0;I=-+g[h>>2];J=-+g[h+4>>2];K=-+g[h+8>>2];h=c[b+9828>>2]|0;F=c[b+9832>>2]|0;k=(c[b+9712>>2]|0)+(F>>1)|0;if(F&1)h=c[(c[k>>2]|0)+h>>2]|0;X=+g[b+9732>>2]*I+ +g[b+9736>>2]*J+ +g[b+9740>>2]*K;W=+g[b+9748>>2]*I+ +g[b+9752>>2]*J+ +g[b+9756>>2]*K;g[b+10088>>2]=+g[b+9716>>2]*I+ +g[b+9720>>2]*J+ +g[b+9724>>2]*K;g[b+10092>>2]=X;g[b+10096>>2]=W;g[b+10100>>2]=0.0;rc[h&127](b+10216|0,k,b+10088|0);W=+g[b+10216>>2];X=+g[b+10220>>2];Y=+g[b+10224>>2];y=y+w*(W*+g[b+9764>>2]+X*+g[b+9768>>2]+Y*+g[b+9772>>2]+ +g[b+9812>>2]);v=v+w*(W*+g[b+9780>>2]+X*+g[b+9784>>2]+Y*+g[b+9788>>2]+ +g[b+9816>>2]);u=u+w*(W*+g[b+9796>>2]+X*+g[b+9800>>2]+Y*+g[b+9804>>2]+ +g[b+9820>>2]);f=f+1|0;k=c[b+9700>>2]|0}while(f>>>0<(c[k+32>>2]|0)>>>0)}I=+g[j>>2];J=+g[j+4>>2];K=+g[j+8>>2];M=+g[j+16>>2];N=+g[j+20>>2];O=+g[j+24>>2];R=+g[j+32>>2];S=+g[j+36>>2];T=+g[j+40>>2];L=+g[j+48>>2];P=+g[j+52>>2];U=+g[j+56>>2];V=B-y;W=G-v;Y=H-u;X=+Q(+(V*V+W*W+Y*Y));X=1.0/(X>9999999747378752.0e-20?X:1.0);g[m>>2]=B*I+G*J+H*K+L;g[m+4>>2]=B*M+G*N+H*O+P;g[m+8>>2]=B*R+G*S+H*T+U;g[m+12>>2]=0.0;g[n>>2]=y*I+v*J+u*K+L;g[n+4>>2]=y*M+v*N+u*O+P;g[n+8>>2]=y*R+v*S+u*T+U;g[n+12>>2]=0.0;g[l>>2]=X*V;g[l+4>>2]=X*W;g[l+8>>2]=X*Y;g[l+12>>2]=0.0;F=0;i=b;return F|0}function Az(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0,O=0,P=0.0,R=0.0;h=i;i=i+288|0;g[b+56>>2]=0.0;p=h+276|0;q=h+280|0;c[h+272>>2]=0;c[h+276>>2]=0;c[h+280>>2]=0;c[h+284>>2]=0;c[h+208>>2]=c[d+0>>2];c[h+212>>2]=c[d+4>>2];c[h+216>>2]=c[d+8>>2];c[h+220>>2]=c[d+12>>2];c[h+224>>2]=c[d+16>>2];c[h+228>>2]=c[d+20>>2];c[h+232>>2]=c[d+24>>2];c[h+236>>2]=c[d+28>>2];c[h+240>>2]=c[d+32>>2];c[h+244>>2]=c[d+36>>2];c[h+248>>2]=c[d+40>>2];c[h+252>>2]=c[d+44>>2];N=h+256|0;c[N+0>>2]=c[d+48>>2];c[N+4>>2]=c[d+52>>2];c[N+8>>2]=c[d+56>>2];c[N+12>>2]=c[d+60>>2];c[h+144>>2]=c[d+64>>2];c[h+148>>2]=c[d+68>>2];c[h+152>>2]=c[d+72>>2];c[h+156>>2]=c[d+76>>2];c[h+160>>2]=c[d+80>>2];c[h+164>>2]=c[d+84>>2];c[h+168>>2]=c[d+88>>2];c[h+172>>2]=c[d+92>>2];c[h+176>>2]=c[d+96>>2];c[h+180>>2]=c[d+100>>2];c[h+184>>2]=c[d+104>>2];c[h+188>>2]=c[d+108>>2];O=h+192|0;c[O+0>>2]=c[d+112>>2];c[O+4>>2]=c[d+116>>2];c[O+8>>2]=c[d+120>>2];c[O+12>>2]=c[d+124>>2];r=+g[N>>2];s=+g[O>>2];t=+g[h+260>>2];u=+g[h+196>>2];n=+g[h+264>>2];o=+g[h+200>>2];g[N>>2]=r-(r+s)*.5;g[h+260>>2]=t-(t+u)*.5;g[h+264>>2]=n-(n+o)*.5;g[O>>2]=s-(r+s)*.5;g[h+196>>2]=u-(t+u)*.5;g[h+200>>2]=o-(n+o)*.5;if(((c[(c[b+28>>2]|0)+4>>2]|0)+ -17|0)>>>0<2)y=((c[(c[b+32>>2]|0)+4>>2]|0)+ -17|0)>>>0<2;else y=0;w=+g[b+44>>2];v=+g[b+48>>2];c[3344]=(c[3344]|0)+1;O=(a[b+52>>0]|0)==0;v=O?v:0.0;c[b+64>>2]=0;g[b+4>>2]=0.0;g[b+8>>2]=1.0;g[b+12>>2]=0.0;g[b+16>>2]=0.0;c[b+68>>2]=0;c[b+60>>2]=-1;w=(O?w:0.0)+v;O=c[b+24>>2]|0;a[O+312>>0]=0;c[O>>2]=0;a[O+356>>0]=1;g[O+292>>2]=999999984306749400.0;g[O+296>>2]=999999984306749400.0;g[O+300>>2]=999999984306749400.0;g[O+304>>2]=0.0;c[O+336>>2]=0;c[O+340>>2]=0;c[O+344>>2]=0;c[O+348>>2]=0;a[O+352>>0]=0;a[O+332>>0]=a[O+332>>0]&-16;A=+g[b+4>>2];B=+g[b+8>>2];F=+g[b+12>>2];a:do if(y){z=999999984306749400.0;while(1){K=-A;L=-B;C=-F;M=+g[d+4>>2]*K+ +g[d+20>>2]*L+ +g[d+36>>2]*C;E=+g[d+8>>2]*K+ +g[d+24>>2]*L+ +g[d+40>>2]*C;g[h+128>>2]=+g[d>>2]*K+ +g[d+16>>2]*L+ +g[d+32>>2]*C;g[h+132>>2]=M;g[h+136>>2]=E;g[h+140>>2]=0.0;E=A*+g[d+68>>2]+B*+g[d+84>>2]+F*+g[d+100>>2];M=A*+g[d+72>>2]+B*+g[d+88>>2]+F*+g[d+104>>2];g[h+112>>2]=+g[d+64>>2]*A+ +g[d+80>>2]*B+ +g[d+96>>2]*F;g[h+116>>2]=E;g[h+120>>2]=M;g[h+124>>2]=0.0;$w(h+96|0,c[b+28>>2]|0,h+128|0);$w(h+80|0,c[b+32>>2]|0,h+112|0);F=+g[h+96>>2];M=+g[h+100>>2];B=+g[h+104>>2];E=F*+g[h+208>>2]+M*+g[h+212>>2]+B*+g[h+216>>2]+ +g[h+256>>2];B=F*+g[h+224>>2]+M*+g[h+228>>2]+B*+g[h+232>>2]+ +g[h+260>>2];M=+g[h+80>>2];F=+g[h+84>>2];C=+g[h+88>>2];A=M*+g[h+144>>2]+F*+g[h+148>>2]+C*+g[h+152>>2]+ +g[h+192>>2];C=M*+g[h+160>>2]+F*+g[h+164>>2]+C*+g[h+168>>2]+ +g[h+196>>2];F=+g[b+4>>2]*(E-A)+ +g[b+8>>2]*(B-C)+ +g[b+12>>2]*0.0;if(F>0.0?F*F>z*+g[d+128>>2]:0){j=22;break a}y=c[b+24>>2]|0;D=c[y>>2]|0;if((D|0)>0){G=+g[y+308>>2];O=0;N=0;do{K=E-A- +g[y+(N<<4)+4>>2];L=B-C- +g[y+(N<<4)+8>>2];M=0.0- +g[y+(N<<4)+12>>2];O=O|K*K+L*L+M*M<=G;N=N+1|0}while((N|0)!=(D|0))}else O=0;if((+g[y+304>>2]==0.0?+g[y+300>>2]==0.0:0)?B-C==+g[y+296>>2]:0)N=E-A==+g[y+292>>2];else N=0;if(N|O){j=31;break a}H=z-F;if(H<=z*9.999999974752427e-7){j=33;break a}g[y+292>>2]=E-A;g[y+296>>2]=B-C;g[y+300>>2]=0.0;g[y+304>>2]=0.0;a[y+356>>0]=1;g[y+(D<<4)+4>>2]=E-A;g[y+(D<<4)+8>>2]=B-C;g[y+(D<<4)+12>>2]=0.0;g[y+(D<<4)+16>>2]=0.0;N=c[y>>2]|0;g[y+(N<<4)+84>>2]=E;g[y+(N<<4)+88>>2]=B;g[y+(N<<4)+92>>2]=0.0;g[y+(N<<4)+96>>2]=0.0;N=c[y>>2]|0;g[y+(N<<4)+164>>2]=A;g[y+(N<<4)+168>>2]=C;g[y+(N<<4)+172>>2]=0.0;g[y+(N<<4)+176>>2]=0.0;c[y>>2]=(c[y>>2]|0)+1;N=c[b+24>>2]|0;O=vC(N)|0;A=+g[N+276>>2];B=+g[N+280>>2];F=+g[N+284>>2];E=+g[N+288>>2];if(!O){j=35;break a}C=z;z=A*A+B*B+F*F;if(z<9.999999974752427e-7){z=C;j=37;break a}if(C-z<=C*1.1920928955078125e-7){j=39;break a}g[b+4>>2]=A;g[b+8>>2]=B;g[b+12>>2]=F;g[b+16>>2]=E;O=c[b+64>>2]|0;c[b+64>>2]=O+1;if((O|0)>1e3){z=0.0;y=0;A=0.0;B=0.0;C=0.0;break a}if((c[c[b+24>>2]>>2]|0)==4){j=42;break}}}else{z=999999984306749400.0;while(1){G=-A;E=-B;C=-F;H=+g[d+4>>2]*G+ +g[d+20>>2]*E+ +g[d+36>>2]*C;M=+g[d+8>>2]*G+ +g[d+24>>2]*E+ +g[d+40>>2]*C;g[h+128>>2]=+g[d>>2]*G+ +g[d+16>>2]*E+ +g[d+32>>2]*C;g[h+132>>2]=H;g[h+136>>2]=M;g[h+140>>2]=0.0;M=A*+g[d+68>>2]+B*+g[d+84>>2]+F*+g[d+100>>2];H=A*+g[d+72>>2]+B*+g[d+88>>2]+F*+g[d+104>>2];g[h+112>>2]=+g[d+64>>2]*A+ +g[d+80>>2]*B+ +g[d+96>>2]*F;g[h+116>>2]=M;g[h+120>>2]=H;g[h+124>>2]=0.0;$w(h+96|0,c[b+28>>2]|0,h+128|0);$w(h+80|0,c[b+32>>2]|0,h+112|0);H=+g[h+96>>2];M=+g[h+100>>2];F=+g[h+104>>2];B=H*+g[h+208>>2]+M*+g[h+212>>2]+F*+g[h+216>>2]+ +g[h+256>>2];C=H*+g[h+224>>2]+M*+g[h+228>>2]+F*+g[h+232>>2]+ +g[h+260>>2];F=H*+g[h+240>>2]+M*+g[h+244>>2]+F*+g[h+248>>2]+ +g[h+264>>2];M=+g[h+80>>2];H=+g[h+84>>2];E=+g[h+88>>2];A=M*+g[h+144>>2]+H*+g[h+148>>2]+E*+g[h+152>>2]+ +g[h+192>>2];G=M*+g[h+160>>2]+H*+g[h+164>>2]+E*+g[h+168>>2]+ +g[h+196>>2];E=M*+g[h+176>>2]+H*+g[h+180>>2]+E*+g[h+184>>2]+ +g[h+200>>2];H=+g[b+4>>2]*(B-A)+ +g[b+8>>2]*(C-G)+ +g[b+12>>2]*(F-E);if(H>0.0?H*H>z*+g[d+128>>2]:0){j=22;break a}D=c[b+24>>2]|0;y=c[D>>2]|0;if((y|0)>0){I=+g[D+308>>2];O=0;N=0;do{K=B-A- +g[D+(N<<4)+4>>2];L=C-G- +g[D+(N<<4)+8>>2];M=F-E- +g[D+(N<<4)+12>>2];O=O|K*K+L*L+M*M<=I;N=N+1|0}while((N|0)!=(y|0))}else O=0;if((+g[D+304>>2]==0.0?F-E==+g[D+300>>2]:0)?C-G==+g[D+296>>2]:0)N=B-A==+g[D+292>>2];else N=0;if(N|O){j=31;break a}H=z-H;if(H<=z*9.999999974752427e-7){j=33;break a}g[D+292>>2]=B-A;g[D+296>>2]=C-G;g[D+300>>2]=F-E;g[D+304>>2]=0.0;a[D+356>>0]=1;g[D+(y<<4)+4>>2]=B-A;g[D+(y<<4)+8>>2]=C-G;g[D+(y<<4)+12>>2]=F-E;g[D+(y<<4)+16>>2]=0.0;N=c[D>>2]|0;g[D+(N<<4)+84>>2]=B;g[D+(N<<4)+88>>2]=C;g[D+(N<<4)+92>>2]=F;g[D+(N<<4)+96>>2]=0.0;N=c[D>>2]|0;g[D+(N<<4)+164>>2]=A;g[D+(N<<4)+168>>2]=G;g[D+(N<<4)+172>>2]=E;g[D+(N<<4)+176>>2]=0.0;c[D>>2]=(c[D>>2]|0)+1;N=c[b+24>>2]|0;O=vC(N)|0;A=+g[N+276>>2];B=+g[N+280>>2];F=+g[N+284>>2];E=+g[N+288>>2];if(!O){j=35;break a}C=z;z=A*A+B*B+F*F;if(z<9.999999974752427e-7){z=C;j=37;break a}if(C-z<=C*1.1920928955078125e-7){j=39;break a}g[b+4>>2]=A;g[b+8>>2]=B;g[b+12>>2]=F;g[b+16>>2]=E;O=c[b+64>>2]|0;c[b+64>>2]=O+1;if((O|0)>1e3){z=0.0;y=0;A=0.0;B=0.0;C=0.0;break a}if((c[c[b+24>>2]>>2]|0)==4){j=42;break}}}while(0);if((j|0)==22){c[b+68>>2]=10;j=43}else if((j|0)==31){c[b+68>>2]=1;j=43}else if((j|0)==33){c[b+68>>2]=!(H<=0.0)?11:2;j=43}else if((j|0)==35){c[b+68>>2]=3;j=43}else if((j|0)==37){g[b+4>>2]=A;g[b+8>>2]=B;g[b+12>>2]=F;g[b+16>>2]=E;c[b+68>>2]=6;j=43}else if((j|0)==39){c[b+68>>2]=12;j=43}else if((j|0)==42){c[b+68>>2]=13;z=0.0;y=0;A=0.0;B=0.0;C=0.0}do if((j|0)==43){O=c[b+24>>2]|0;vC(O)|0;A=+g[O+260>>2];B=+g[O+264>>2];C=+g[O+268>>2];c[h+272>>2]=c[b+4>>2];c[h+276>>2]=c[b+8>>2];c[h+280>>2]=c[b+12>>2];c[h+284>>2]=c[b+16>>2];G=+g[b+4>>2];F=+g[b+8>>2];E=+g[b+12>>2];if(G*G+F*F+E*E<1.0e-4)c[b+68>>2]=5;if(G*G+F*F+E*E>1.4210854715202004e-14){L=1.0/+Q(+(G*G+F*F+E*E));g[h+272>>2]=L*+g[h+272>>2];g[p>>2]=L*+g[p>>2];g[q>>2]=L*+g[q>>2];M=v/+Q(+z);c[b+60>>2]=1;z=1.0/L-w;y=1;A=M*G+A;B=M*F+B;C=M*E+C;break}else{c[b+60>>2]=2;z=0.0;y=0;break}}while(0);if(((c[b+72>>2]|0)!=0?(c[b+20>>2]|0)!=0:0)?(c[b+68>>2]|0)!=0:0)N=w+z<.01;else N=0;D=y^1;do if(N|D?(x=c[b+20>>2]|0,(x|0)!=0):0){c[3342]=(c[3342]|0)+1;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;if(!(Ob[c[(c[x>>2]|0)+8>>2]&3](x,c[b+24>>2]|0,c[b+28>>2]|0,c[b+32>>2]|0,h+208|0,h+144|0,b+4|0,h+64|0,h+48|0,f)|0)){I=+g[b+4>>2];H=+g[b+8>>2];E=+g[b+12>>2];if(!(I*I+H*H+E*E>0.0)){j=66;break}J=+g[h+48>>2];K=+g[h+64>>2]-J;G=+g[h+52>>2];L=+g[h+68>>2]-G;F=+g[h+56>>2];M=+g[h+72>>2]-F;w=+Q(+(K*K+L*L+M*M))-w;if(w<z|D){c[h+272>>2]=c[b+4>>2];c[h+276>>2]=c[b+8>>2];c[h+280>>2]=c[b+12>>2];c[h+284>>2]=c[b+16>>2];C=+g[h+272>>2];B=+g[p>>2];A=+g[q>>2];z=1.0/+Q(+(C*C+B*B+A*A));g[h+272>>2]=C*z;g[p>>2]=B*z;g[q>>2]=A*z;c[b+60>>2]=6;z=w;A=v*I+J;B=v*H+G;C=v*E+F;break}c[b+60>>2]=5;if(y)break;i=h;return}E=+g[h+48>>2];L=+g[h+64>>2];w=+g[h+52>>2];K=+g[h+68>>2];v=+g[h+56>>2];J=+g[h+72>>2];if(!((E-L)*(E-L)+(w-K)*(w-K)+(v-J)*(v-J)<=1.4210854715202004e-14)){H=v-J;G=w-K;I=E-L;F=0.0;M=(E-L)*(E-L)+(w-K)*(w-K)+(v-J)*(v-J)}else{R=+g[b+4>>2];P=+g[b+8>>2];M=+g[b+12>>2];H=M;G=P;I=R;F=+g[b+16>>2];M=R*R+P*P+M*M}if(!(M>1.4210854715202004e-14)){c[b+60>>2]=9;if(y)break;i=h;return}M=1.0/+Q(+M);J=-+Q(+((L-E)*(L-E)+(K-w)*(K-w)+(J-v)*(J-v)));if(z>J|D){g[h+272>>2]=I*M;g[p>>2]=G*M;g[q>>2]=H*M;g[h+284>>2]=F;c[b+60>>2]=3;z=J;A=E;B=w;C=v;break}c[b+60>>2]=8;if(!y){i=h;return}}else j=66;while(0);if((j|0)==66)if(!y){i=h;return}if(!(z<0.0)?!(z*z<+g[d+128>>2]):0){i=h;return}if((c[b+76>>2]|0)!=0?(O=c[b+28>>2]|0,vc[c[(c[O>>2]|0)+8>>2]&127](O,h+208|0,h+32|0,h+16|0),M=(+g[h+16>>2]+ +g[h+32>>2])*.5,P=(+g[h+20>>2]+ +g[h+36>>2])*.5,R=(+g[h+24>>2]+ +g[h+40>>2])*.5,O=c[b+32>>2]|0,vc[c[(c[O>>2]|0)+8>>2]&127](O,h+144|0,h+32|0,h+16|0),k=+g[h+272>>2],l=+g[p>>2],m=+g[q>>2],(M-(+g[h+32>>2]+ +g[h+16>>2])*.5)*k+(P-(+g[h+36>>2]+ +g[h+20>>2])*.5)*l+(R-(+g[h+40>>2]+ +g[h+24>>2])*.5)*m<0.0):0){g[h+272>>2]=k*-1.0;g[p>>2]=l*-1.0;g[q>>2]=m*-1.0}c[b+4>>2]=c[h+272>>2];c[b+8>>2]=c[h+276>>2];c[b+12>>2]=c[h+280>>2];c[b+16>>2]=c[h+284>>2];g[b+56>>2]=z;O=c[(c[e>>2]|0)+16>>2]|0;g[h>>2]=(r+s)*.5+A;g[h+4>>2]=(t+u)*.5+B;g[h+8>>2]=(n+o)*.5+C;g[h+12>>2]=0.0;qc[O&15](e,h+272|0,h,z);i=h;return}function Bz(a){a=a|0;return}function Cz(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Dz(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0;l=i;i=i+192|0;h=c[b+4>>2]|0;if(+g[h+752>>2]<f){i=l;return}j=c[h+740>>2]|0;m=(c[b+8>>2]|0)+8|0;k=c[m>>2]|0;q=+g[e>>2];t=+g[d>>2]*f+q;o=+g[e+4>>2];r=+g[d+4>>2]*f+o;p=+g[e+8>>2];s=+g[d+8>>2]*f+p;if((j|0)!=(k|0)){n=c[b+12>>2]|0;y=c[n+8>>2]|0;B=t- +g[y+52>>2];v=r- +g[y+56>>2];w=s- +g[y+60>>2];A=q- +g[k+52>>2];z=o- +g[k+56>>2];u=p- +g[k+60>>2];q=B*+g[y+4>>2]+v*+g[y+20>>2]+w*+g[y+36>>2];o=B*+g[y+8>>2]+v*+g[y+24>>2]+w*+g[y+40>>2];p=B*+g[y+12>>2]+v*+g[y+28>>2]+w*+g[y+44>>2];w=A*+g[k+4>>2]+z*+g[k+20>>2]+u*+g[k+36>>2];v=A*+g[k+8>>2]+z*+g[k+24>>2]+u*+g[k+40>>2];u=A*+g[k+12>>2]+z*+g[k+28>>2]+u*+g[k+44>>2]}else{z=t- +g[j+52>>2];v=r- +g[j+56>>2];w=s- +g[j+60>>2];n=c[b+12>>2]|0;y=c[n+8>>2]|0;A=q- +g[y+52>>2];B=o- +g[y+56>>2];u=p- +g[y+60>>2];q=z*+g[j+4>>2]+v*+g[j+20>>2]+w*+g[j+36>>2];o=z*+g[j+8>>2]+v*+g[j+24>>2]+w*+g[j+40>>2];p=z*+g[j+12>>2]+v*+g[j+28>>2]+w*+g[j+44>>2];w=A*+g[y+4>>2]+B*+g[y+20>>2]+u*+g[y+36>>2];v=A*+g[y+8>>2]+B*+g[y+24>>2]+u*+g[y+40>>2];u=A*+g[y+12>>2]+B*+g[y+28>>2]+u*+g[y+44>>2]}g[l>>2]=q;g[l+4>>2]=o;g[l+8>>2]=p;g[l+12>>2]=0.0;g[l+16>>2]=w;g[l+20>>2]=v;g[l+24>>2]=u;g[l+28>>2]=0.0;c[l+64>>2]=c[d+0>>2];c[l+68>>2]=c[d+4>>2];c[l+72>>2]=c[d+8>>2];c[l+76>>2]=c[d+12>>2];g[l+80>>2]=f;g[l+84>>2]=0.0;g[l+88>>2]=0.0;g[l+92>>2]=0.0;c[l+112>>2]=0;a[l+116>>0]=0;c[l+120>>2]=0;c[l+124>>2]=0;c[l+128>>2]=0;c[l+132>>2]=0;c[l+136>>2]=0;c[l+140>>2]=0;c[l+144>>2]=0;c[l+148>>2]=0;g[l+48>>2]=t;g[l+52>>2]=r;g[l+56>>2]=s;g[l+60>>2]=0.0;c[l+32>>2]=c[e+0>>2];c[l+36>>2]=c[e+4>>2];c[l+40>>2]=c[e+8>>2];c[l+44>>2]=c[e+12>>2];r=+g[h+752>>2];d=c[h+748>>2]|0;if((d|0)>0){e=0;y=-1;f=r*r;while(1){r=+g[h+(e*184|0)+4>>2]-q;s=+g[h+(e*184|0)+8>>2]-o;t=+g[h+(e*184|0)+12>>2]-p;x=r*r+s*s+t*t<f;y=x?e:y;e=e+1|0;if((e|0)==(d|0))break;else f=x?r*r+s*s+t*t:f}}else y=-1;d=c[m>>2]|0;x=c[n+8>>2]|0;o=+g[d+224>>2]*+g[x+224>>2];o=o<-10.0?-10.0:o;g[l+84>>2]=o>10.0?10.0:o;g[l+92>>2]=+g[d+228>>2]*+g[x+228>>2];o=+g[d+232>>2]*+g[x+232>>2];o=o<-10.0?-10.0:o;g[l+88>>2]=o>10.0?10.0:o;o=+g[l+72>>2];if(+P(+o)>.7071067690849304){z=+g[l+68>>2];B=1.0/+Q(+(o*o+z*z));g[l+152>>2]=0.0;g[l+156>>2]=-(B*o);g[l+160>>2]=B*z;g[l+168>>2]=(o*o+z*z)*B;A=+g[l+64>>2];g[l+172>>2]=-(A*B*z);g[l+176>>2]=A*-(B*o)}else{z=+g[l+64>>2];A=+g[l+68>>2];B=1.0/+Q(+(z*z+A*A));g[l+152>>2]=-(A*B);g[l+156>>2]=B*z;g[l+160>>2]=0.0;g[l+168>>2]=-(o*B*z);g[l+172>>2]=o*-(A*B);g[l+176>>2]=(z*z+A*A)*B}if((j|0)!=(k|0)){c[l+96>>2]=c[b+20>>2];c[l+100>>2]=c[b+16>>2];c[l+104>>2]=c[b+28>>2];c[l+108>>2]=c[b+24>>2]}else{c[l+96>>2]=c[b+16>>2];c[l+100>>2]=c[b+20>>2];c[l+104>>2]=c[b+24>>2];c[l+108>>2]=c[b+28>>2]}if((y|0)>-1){x=h+(y*184|0)+152|0;d=c[x>>2]|0;m=h+(y*184|0)+124|0;z=+g[m>>2];n=h+(y*184|0)+128|0;A=+g[n>>2];e=h+(y*184|0)+132|0;B=+g[e>>2];k=h+(y*184|0)+116|0;j=c[k>>2]|0;mF(h+(y*184|0)+4|0,l|0,184)|0;c[k>>2]=j;g[m>>2]=z;g[n>>2]=A;g[e>>2]=B;c[x>>2]=d;i=l;return}else{wA(h,l)|0;i=l;return}}function Ez(b,d,e,f,h,j,k,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;b=i;i=i+4256|0;if(((c[e+4>>2]|0)+ -17|0)>>>0<2)r=((c[f+4>>2]|0)+ -17|0)>>>0<2;else r=0;o=0;do{Fz();v=+g[13568+(o<<4)>>2];w=+g[13572+(o<<4)>>2];x=+g[13576+(o<<4)>>2];z=+g[h+4>>2]*-v+ +g[h+20>>2]*-w+ +g[h+36>>2]*-x;y=+g[h+8>>2]*-v+ +g[h+24>>2]*-w+ +g[h+40>>2]*-x;g[b+1280+(o<<4)>>2]=+g[h>>2]*-v+ +g[h+16>>2]*-w+ +g[h+32>>2]*-x;g[b+1280+(o<<4)+4>>2]=z;g[b+1280+(o<<4)+8>>2]=y;g[b+1280+(o<<4)+12>>2]=0.0;y=v*+g[j+4>>2]+w*+g[j+20>>2]+x*+g[j+36>>2];z=v*+g[j+8>>2]+w*+g[j+24>>2]+x*+g[j+40>>2];g[b+288+(o<<4)>>2]=v*+g[j>>2]+w*+g[j+16>>2]+x*+g[j+32>>2];g[b+288+(o<<4)+4>>2]=y;g[b+288+(o<<4)+8>>2]=z;g[b+288+(o<<4)+12>>2]=0.0;o=o+1|0}while((o|0)!=42);A=Pb[c[(c[e>>2]|0)+84>>2]&127](e)|0;if((A|0)>0){B=0;o=42;while(1){rc[c[(c[e>>2]|0)+88>>2]&127](e,B,b+272|0);y=+g[b+272>>2];z=+g[b+276>>2];x=+g[b+280>>2];w=y*+g[h+16>>2]+z*+g[h+20>>2]+x*+g[h+24>>2];v=y*+g[h+32>>2]+z*+g[h+36>>2]+x*+g[h+40>>2];g[b+272>>2]=+g[h>>2]*y+ +g[h+4>>2]*z+ +g[h+8>>2]*x;g[b+276>>2]=w;g[b+280>>2]=v;g[b+284>>2]=0.0;Fz();C=13568+(o<<4)|0;c[C+0>>2]=c[b+272>>2];c[C+4>>2]=c[b+276>>2];c[C+8>>2]=c[b+280>>2];c[C+12>>2]=c[b+284>>2];v=+g[b+272>>2];w=+g[b+276>>2];x=+g[b+280>>2];z=+g[h+4>>2]*-v+ +g[h+20>>2]*-w+ +g[h+36>>2]*-x;y=+g[h+8>>2]*-v+ +g[h+24>>2]*-w+ +g[h+40>>2]*-x;g[b+1280+(o<<4)>>2]=+g[h>>2]*-v+ +g[h+16>>2]*-w+ +g[h+32>>2]*-x;g[b+1280+(o<<4)+4>>2]=z;g[b+1280+(o<<4)+8>>2]=y;g[b+1280+(o<<4)+12>>2]=0.0;y=v*+g[j+4>>2]+w*+g[j+20>>2]+x*+g[j+36>>2];z=v*+g[j+8>>2]+w*+g[j+24>>2]+x*+g[j+40>>2];g[b+288+(o<<4)>>2]=+g[j>>2]*v+ +g[j+16>>2]*w+ +g[j+32>>2]*x;g[b+288+(o<<4)+4>>2]=y;g[b+288+(o<<4)+8>>2]=z;g[b+288+(o<<4)+12>>2]=0.0;B=B+1|0;if((B|0)==(A|0))break;else o=o+1|0}o=A+42|0}else o=42;C=Pb[c[(c[f>>2]|0)+84>>2]&127](f)|0;if((C|0)>0){B=0;A=o;while(1){rc[c[(c[f>>2]|0)+88>>2]&127](f,B,b+256|0);y=+g[b+256>>2];z=+g[b+260>>2];x=+g[b+264>>2];w=y*+g[j+16>>2]+z*+g[j+20>>2]+x*+g[j+24>>2];v=y*+g[j+32>>2]+z*+g[j+36>>2]+x*+g[j+40>>2];g[b+256>>2]=+g[j>>2]*y+ +g[j+4>>2]*z+ +g[j+8>>2]*x;g[b+260>>2]=w;g[b+264>>2]=v;g[b+268>>2]=0.0;Fz();D=13568+(A<<4)|0;c[D+0>>2]=c[b+256>>2];c[D+4>>2]=c[b+260>>2];c[D+8>>2]=c[b+264>>2];c[D+12>>2]=c[b+268>>2];v=+g[b+256>>2];w=+g[b+260>>2];x=+g[b+264>>2];z=+g[h+4>>2]*-v+ +g[h+20>>2]*-w+ +g[h+36>>2]*-x;y=+g[h+8>>2]*-v+ +g[h+24>>2]*-w+ +g[h+40>>2]*-x;g[b+1280+(A<<4)>>2]=+g[h>>2]*-v+ +g[h+16>>2]*-w+ +g[h+32>>2]*-x;g[b+1280+(A<<4)+4>>2]=z;g[b+1280+(A<<4)+8>>2]=y;g[b+1280+(A<<4)+12>>2]=0.0;y=v*+g[j+4>>2]+w*+g[j+20>>2]+x*+g[j+36>>2];z=v*+g[j+8>>2]+w*+g[j+24>>2]+x*+g[j+40>>2];g[b+288+(A<<4)>>2]=+g[j>>2]*v+ +g[j+16>>2]*w+ +g[j+32>>2]*x;g[b+288+(A<<4)+4>>2]=y;g[b+288+(A<<4)+8>>2]=z;g[b+288+(A<<4)+12>>2]=0.0;B=B+1|0;if((B|0)==(C|0))break;else A=A+1|0}o=C+o|0}vc[c[(c[e>>2]|0)+76>>2]&127](e,b+1280|0,b+3264|0,o);vc[c[(c[f>>2]|0)+76>>2]&127](f,b+288|0,b+2272|0,o);if((o|0)>0)if(r){v=0.0;w=0.0;x=0.0;r=0;s=999999984306749400.0;while(1){Fz();t=+g[13568+(r<<4)>>2];u=+g[13572+(r<<4)>>2];p=+g[13580+(r<<4)>>2];if(t*t+u*u+0.0>.01?(y=+g[b+3264+(r<<4)>>2],z=+g[b+3264+(r<<4)+4>>2],q=+g[b+3264+(r<<4)+8>>2],G=+g[b+2272+(r<<4)>>2],F=+g[b+2272+(r<<4)+4>>2],E=+g[b+2272+(r<<4)+8>>2],q=t*(G*+g[j>>2]+F*+g[j+4>>2]+E*+g[j+8>>2]+ +g[j+48>>2]-(y*+g[h>>2]+z*+g[h+4>>2]+q*+g[h+8>>2]+ +g[h+48>>2]))+u*(G*+g[j+16>>2]+F*+g[j+20>>2]+E*+g[j+24>>2]+ +g[j+52>>2]-(y*+g[h+16>>2]+z*+g[h+20>>2]+q*+g[h+24>>2]+ +g[h+52>>2]))+0.0,q<s):0)s=q;else{p=x;u=w;t=v}r=r+1|0;if((r|0)==(o|0)){q=0.0;break}else{v=t;w=u;x=p}}}else{t=0.0;x=0.0;y=0.0;z=0.0;r=0;s=999999984306749400.0;while(1){Fz();v=+g[13568+(r<<4)>>2];u=+g[13572+(r<<4)>>2];q=+g[13576+(r<<4)>>2];w=+g[13580+(r<<4)>>2];if(v*v+u*u+q*q>.01?(F=+g[b+3264+(r<<4)>>2],G=+g[b+3264+(r<<4)+4>>2],p=+g[b+3264+(r<<4)+8>>2],I=+g[b+2272+(r<<4)>>2],H=+g[b+2272+(r<<4)+4>>2],E=+g[b+2272+(r<<4)+8>>2],p=v*(I*+g[j>>2]+H*+g[j+4>>2]+E*+g[j+8>>2]+ +g[j+48>>2]-(F*+g[h>>2]+G*+g[h+4>>2]+p*+g[h+8>>2]+ +g[h+48>>2]))+u*(I*+g[j+16>>2]+H*+g[j+20>>2]+E*+g[j+24>>2]+ +g[j+52>>2]-(F*+g[h+16>>2]+G*+g[h+20>>2]+p*+g[h+24>>2]+ +g[h+52>>2]))+q*(I*+g[j+32>>2]+H*+g[j+36>>2]+E*+g[j+40>>2]+ +g[j+56>>2]-(F*+g[h+32>>2]+G*+g[h+36>>2]+p*+g[h+40>>2]+ +g[h+56>>2])),p<s):0){t=v;s=p}else{w=z;q=y;u=x}r=r+1|0;if((r|0)==(o|0)){p=w;break}else{x=u;y=q;z=w}}}else{p=0.0;q=0.0;u=0.0;t=0.0;s=999999984306749400.0}switch(c[e+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+$b[c[(c[e>>2]|0)+48>>2]&15](e)}switch(c[f+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+$b[c[(c[f>>2]|0)+48>>2]&15](f)}if(s<0.0){D=0;i=b;return D|0}switch(c[e+4>>2]|0){case 11:{v=+g[e+44>>2];break};case 10:{v=+g[e+44>>2];break};case 4:case 5:{v=+g[e+44>>2];break};case 8:{v=+g[e+28>>2]*+g[e+12>>2];break};case 0:{v=+g[e+44>>2];break};case 1:{v=+g[e+44>>2];break};case 13:{v=+g[e+44>>2];break};default:v=+$b[c[(c[e>>2]|0)+48>>2]&15](e)}o=c[f+4>>2]|0;switch(o|0){case 8:{w=+g[f+28>>2]*+g[f+12>>2];o=8;break};case 0:{w=+g[f+44>>2];o=0;break};case 1:{w=+g[f+44>>2];o=1;break};case 13:{w=+g[f+44>>2];o=13;break};case 11:{w=+g[f+44>>2];o=11;break};case 10:{w=+g[f+44>>2];o=10;break};case 4:case 5:{w=+g[f+44>>2];break};default:{w=+$b[c[(c[f>>2]|0)+48>>2]&15](f);o=c[f+4>>2]|0}}s=s+(v+w+.5);c[b+176>>2]=13392;g[b+180>>2]=0.0;g[b+184>>2]=1.0;g[b+188>>2]=0.0;g[b+192>>2]=0.0;c[b+196>>2]=0;c[b+200>>2]=d;c[b+204>>2]=e;c[b+208>>2]=f;c[b+212>>2]=c[e+4>>2];c[b+216>>2]=o;g[b+220>>2]=+$b[c[(c[e>>2]|0)+48>>2]&15](e);g[b+224>>2]=+$b[c[(c[f>>2]|0)+48>>2]&15](f);a[b+228>>0]=0;c[b+236>>2]=-1;c[b+248>>2]=1;c[b+252>>2]=1;G=+g[h+48>>2]+t*s;H=u*s+ +g[h+52>>2];I=q*s+ +g[h+56>>2];c[b+44>>2]=c[h+0>>2];c[b+48>>2]=c[h+4>>2];c[b+52>>2]=c[h+8>>2];c[b+56>>2]=c[h+12>>2];c[b+60>>2]=c[h+16>>2];c[b+64>>2]=c[h+20>>2];c[b+68>>2]=c[h+24>>2];c[b+72>>2]=c[h+28>>2];c[b+76>>2]=c[h+32>>2];c[b+80>>2]=c[h+36>>2];c[b+84>>2]=c[h+40>>2];c[b+88>>2]=c[h+44>>2];g[b+92>>2]=G;g[b+96>>2]=H;g[b+100>>2]=I;g[b+104>>2]=0.0;c[b+108>>2]=c[j+0>>2];c[b+112>>2]=c[j+4>>2];c[b+116>>2]=c[j+8>>2];c[b+120>>2]=c[j+12>>2];c[b+124>>2]=c[j+16>>2];c[b+128>>2]=c[j+20>>2];c[b+132>>2]=c[j+24>>2];c[b+136>>2]=c[j+28>>2];c[b+140>>2]=c[j+32>>2];c[b+144>>2]=c[j+36>>2];c[b+148>>2]=c[j+40>>2];c[b+152>>2]=c[j+44>>2];c[b+156>>2]=c[j+48>>2];c[b+160>>2]=c[j+52>>2];c[b+164>>2]=c[j+56>>2];c[b+168>>2]=c[j+60>>2];g[b+172>>2]=999999984306749400.0;c[b>>2]=14656;a[b+40>>0]=0;g[b+180>>2]=-t;g[b+184>>2]=-u;g[b+188>>2]=-q;g[b+192>>2]=0.0;Az(b+176|0,b+44|0,b,n,0);s=s- +g[b+36>>2];f=a[b+40>>0]|0;if(f<<24>>24){H=+g[b+24>>2]-u*s;I=+g[b+28>>2]-q*s;g[l>>2]=+g[b+20>>2]-t*s;g[l+4>>2]=H;g[l+8>>2]=I;g[l+12>>2]=0.0;c[m+0>>2]=c[b+20>>2];c[m+4>>2]=c[b+24>>2];c[m+8>>2]=c[b+28>>2];c[m+12>>2]=c[b+32>>2];g[k>>2]=t;g[k+4>>2]=u;g[k+8>>2]=q;g[k+12>>2]=p}D=f<<24>>24!=0;i=b;return D|0}function Fz(){var b=0;b=i;if(a[14560]|0){i=b;return}if(!(Ya(14560)|0)){i=b;return}g[3392]=0.0;g[3393]=-0.0;g[3394]=-1.0;g[3395]=0.0;g[3396]=.7236080169677734;g[3397]=-.5257250070571899;g[3398]=-.44721901416778564;g[3399]=0.0;g[3400]=-.2763879895210266;g[3401]=-.8506489992141724;g[3402]=-.44721901416778564;g[3403]=0.0;g[3404]=-.8944259881973267;g[3405]=-0.0;g[3406]=-.4472160041332245;g[3407]=0.0;g[3408]=-.2763879895210266;g[3409]=.8506489992141724;g[3410]=-.44721999764442444;g[3411]=0.0;g[3412]=.7236080169677734;g[3413]=.5257250070571899;g[3414]=-.44721901416778564;g[3415]=0.0;g[3416]=.2763879895210266;g[3417]=-.8506489992141724;g[3418]=.44721999764442444;g[3419]=0.0;g[3420]=-.7236080169677734;g[3421]=-.5257250070571899;g[3422]=.44721901416778564;g[3423]=0.0;g[3424]=-.7236080169677734;g[3425]=.5257250070571899;g[3426]=.44721901416778564;g[3427]=0.0;g[3428]=.2763879895210266;g[3429]=.8506489992141724;g[3430]=.44721901416778564;g[3431]=0.0;g[3432]=.8944259881973267;g[3433]=0.0;g[3434]=.4472160041332245;g[3435]=0.0;g[3436]=-0.0;g[3437]=0.0;g[3438]=1.0;g[3439]=0.0;g[3440]=.4253230094909668;g[3441]=-.3090110123157501;g[3442]=-.8506540060043335;g[3443]=0.0;g[3444]=-.16245600581169128;g[3445]=-.49999499320983887;g[3446]=-.8506540060043335;g[3447]=0.0;g[3448]=.2628690004348755;g[3449]=-.8090119957923889;g[3450]=-.525738000869751;g[3451]=0.0;g[3452]=.4253230094909668;g[3453]=.3090110123157501;g[3454]=-.8506540060043335;g[3455]=0.0;g[3456]=.8506479859352112;g[3457]=-0.0;g[3458]=-.5257359743118286;g[3459]=0.0;g[3460]=-.5257300138473511;g[3461]=-0.0;g[3462]=-.8506519794464111;g[3463]=0.0;g[3464]=-.6881899833679199;g[3465]=-.49999698996543884;g[3466]=-.5257359743118286;g[3467]=0.0;g[3468]=-.16245600581169128;g[3469]=.49999499320983887;g[3470]=-.8506540060043335;g[3471]=0.0;g[3472]=-.6881899833679199;g[3473]=.49999698996543884;g[3474]=-.5257359743118286;g[3475]=0.0;g[3476]=.2628690004348755;g[3477]=.8090119957923889;g[3478]=-.525738000869751;g[3479]=0.0;g[3480]=.9510579705238342;g[3481]=.3090130090713501;g[3482]=0.0;g[3483]=0.0;g[3484]=.9510579705238342;g[3485]=-.3090130090713501;g[3486]=0.0;g[3487]=0.0;g[3488]=.5877860188484192;g[3489]=-.80901700258255;g[3490]=0.0;g[3491]=0.0;g[3492]=0.0;g[3493]=-1.0;g[3494]=0.0;g[3495]=0.0;g[3496]=-.5877860188484192;g[3497]=-.80901700258255;g[3498]=0.0;g[3499]=0.0;g[3500]=-.9510579705238342;g[3501]=-.3090130090713501;g[3502]=-0.0;g[3503]=0.0;g[3504]=-.9510579705238342;g[3505]=.3090130090713501;g[3506]=-0.0;g[3507]=0.0;g[3508]=-.5877860188484192;g[3509]=.80901700258255;g[3510]=-0.0;g[3511]=0.0;g[3512]=-0.0;g[3513]=1.0;g[3514]=-0.0;g[3515]=0.0;g[3516]=.5877860188484192;g[3517]=.80901700258255;g[3518]=-0.0;g[3519]=0.0;g[3520]=.6881899833679199;g[3521]=-.49999698996543884;g[3522]=.5257359743118286;g[3523]=0.0;g[3524]=-.2628690004348755;g[3525]=-.8090119957923889;g[3526]=.525738000869751;g[3527]=0.0;g[3528]=-.8506479859352112;g[3529]=0.0;g[3530]=.5257359743118286;g[3531]=0.0;g[3532]=-.2628690004348755;g[3533]=.8090119957923889;g[3534]=.525738000869751;g[3535]=0.0;g[3536]=.6881899833679199;g[3537]=.49999698996543884;g[3538]=.5257359743118286;g[3539]=0.0;g[3540]=.5257300138473511;g[3541]=0.0;g[3542]=.8506519794464111;g[3543]=0.0;g[3544]=.16245600581169128;g[3545]=-.49999499320983887;g[3546]=.8506540060043335;g[3547]=0.0;g[3548]=-.4253230094909668;g[3549]=-.3090110123157501;g[3550]=.8506540060043335;g[3551]=0.0;g[3552]=-.4253230094909668;g[3553]=.3090110123157501;g[3554]=.8506540060043335;g[3555]=0.0;g[3556]=.16245600581169128;g[3557]=.49999499320983887;g[3558]=.8506540060043335;g[3559]=0.0;bb(14560);i=b;return}function Gz(a){a=a|0;return}function Hz(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Iz(a){a=a|0;return}function Jz(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Kz(a,b,c){a=a|0;b=b|0;c=c|0;return}function Lz(a,b,c){a=a|0;b=b|0;c=c|0;return}function Mz(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0;h=i;c[b+4>>2]=c[d+0>>2];c[b+8>>2]=c[d+4>>2];c[b+12>>2]=c[d+8>>2];c[b+16>>2]=c[d+12>>2];c[b+20>>2]=c[e+0>>2];c[b+24>>2]=c[e+4>>2];c[b+28>>2]=c[e+8>>2];c[b+32>>2]=c[e+12>>2];g[b+36>>2]=f;a[b+40>>0]=1;i=h;return}function Nz(a){a=a|0;var b=0;b=i;MA(a);if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function Oz(a){a=a|0;var b=0;b=i;MA(a);i=b;return}function Pz(d,e,f,h,j){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0;k=i;i=i+176|0;a[d+60>>0]=f&1;if(f){t=+g[h>>2]+-1.0;q=+g[h+4>>2]+-1.0;r=+g[h+8>>2]+-1.0;g[d+4>>2]=t;g[d+8>>2]=q;g[d+12>>2]=r;g[d+16>>2]=0.0;o=+g[j>>2]+1.0;m=+g[j+4>>2]+1.0;l=+g[j+8>>2]+1.0;g[d+20>>2]=o;g[d+24>>2]=m;g[d+28>>2]=l;g[d+32>>2]=0.0;g[d+36>>2]=65533.0/(o-t);g[d+40>>2]=65533.0/(m-q);g[d+44>>2]=65533.0/(l-r);g[d+48>>2]=0.0;a[d+60>>0]=1;n=t+ +(~~((t-t)*(65533.0/(o-t)))&65534)/(65533.0/(o-t))+-1.0;p=q+ +(~~((q-q)*(65533.0/(m-q)))&65534)/(65533.0/(m-q))+-1.0;s=r+ +(~~((r-r)*(65533.0/(l-r)))&65534)/(65533.0/(l-r))+-1.0;if(n<t)g[d+4>>2]=n;else n=t;if(p<q)g[d+8>>2]=p;else p=q;if(s<r)g[d+12>>2]=s;else s=r;u=n+ +((~~((o-n)*(65533.0/(o-t))+1.0)&65535|1)&65535)/(65533.0/(o-t))+1.0;t=p+ +((~~((m-p)*(65533.0/(m-q))+1.0)&65535|1)&65535)/(65533.0/(m-q))+1.0;q=s+ +((~~((l-s)*(65533.0/(l-r))+1.0)&65535|1)&65535)/(65533.0/(l-r))+1.0;if(o<u){g[d+20>>2]=u;o=u}if(m<t){g[d+24>>2]=t;m=t}if(l<q){g[d+28>>2]=q;l=q}g[d+36>>2]=65533.0/(o-n);g[d+40>>2]=65533.0/(m-p);g[d+44>>2]=65533.0/(l-s);g[d+48>>2]=0.0;c[k+152>>2]=15096;c[k+156>>2]=d+104;c[k+160>>2]=d;vc[c[(c[e>>2]|0)+8>>2]&127](e,k+152|0,d+4|0,d+20|0);e=c[d+108>>2]|0;c[k+136>>2]=0;c[k+140>>2]=0;c[k+144>>2]=0;c[k+148>>2]=0;j=c[d+128>>2]|0;if((j|0)<(e<<1|0)){if((c[d+132>>2]|0)<(e<<1|0)){if(!e){h=0;v=j}else{c[5004]=(c[5004]|0)+1;h=fF(e<<5|19)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}v=c[d+128>>2]|0}if((v|0)>0){f=0;do{y=h+(f<<4)|0;x=(c[d+136>>2]|0)+(f<<4)|0;c[y+0>>2]=c[x+0>>2];c[y+4>>2]=c[x+4>>2];c[y+8>>2]=c[x+8>>2];c[y+12>>2]=c[x+12>>2];f=f+1|0}while((f|0)!=(v|0))}f=c[d+136>>2]|0;if(f){if(a[d+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=h;c[d+132>>2]=e<<1;h=d+136|0}else h=d+136|0;do{y=(c[h>>2]|0)+(j<<4)|0;c[y+0>>2]=c[k+136>>2];c[y+4>>2]=c[k+140>>2];c[y+8>>2]=c[k+144>>2];c[y+12>>2]=c[k+148>>2];j=j+1|0}while((j|0)!=(e<<1|0))}c[d+128>>2]=e<<1}else{c[k+128>>2]=14960;c[k+132>>2]=d+64;g[k+112>>2]=-999999984306749400.0;g[k+116>>2]=-999999984306749400.0;g[k+120>>2]=-999999984306749400.0;g[k+124>>2]=0.0;g[k+96>>2]=999999984306749400.0;g[k+100>>2]=999999984306749400.0;g[k+104>>2]=999999984306749400.0;g[k+108>>2]=0.0;vc[c[(c[e>>2]|0)+8>>2]&127](e,k+128|0,k+112|0,k+96|0);e=c[d+68>>2]|0;h=k+32|0;v=h+64|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(v|0));j=c[d+88>>2]|0;if((j|0)<(e<<1|0)){if((c[d+92>>2]|0)<(e<<1|0)){if(!e){w=0;x=j}else{c[5004]=(c[5004]|0)+1;h=fF(e<<7|19)|0;if(!h)w=0;else{c[(h+19&-16)+ -4>>2]=h;w=h+19&-16}x=c[d+88>>2]|0}if((x|0)>0){y=0;do{h=w+(y<<6)+0|0;f=(c[d+96>>2]|0)+(y<<6)+0|0;v=h+64|0;do{c[h>>2]=c[f>>2];h=h+4|0;f=f+4|0}while((h|0)<(v|0));y=y+1|0}while((y|0)!=(x|0))}h=c[d+96>>2]|0;if(h){if(a[d+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=w;c[d+92>>2]=e<<1;w=d+96|0}else w=d+96|0;do{h=(c[w>>2]|0)+(j<<6)+0|0;f=k+32|0;v=h+64|0;do{c[h>>2]=c[f>>2];h=h+4|0;f=f+4|0}while((h|0)<(v|0));j=j+1|0}while((j|0)!=(e<<1|0))}c[d+88>>2]=e<<1}c[d+56>>2]=0;KA(d,0,e);if((a[d+60>>0]|0)!=0?(c[d+152>>2]|0)==0:0){if(!(c[d+156>>2]|0)){c[5004]=(c[5004]|0)+1;e=fF(51)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}h=c[d+152>>2]|0;if((h|0)>0){j=0;do{y=e+(j<<5)|0;x=(c[d+160>>2]|0)+(j<<5)|0;c[y+0>>2]=c[x+0>>2];c[y+4>>2]=c[x+4>>2];c[y+8>>2]=c[x+8>>2];c[y+12>>2]=c[x+12>>2];c[y+16>>2]=c[x+16>>2];c[y+20>>2]=c[x+20>>2];c[y+24>>2]=c[x+24>>2];c[y+28>>2]=c[x+28>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+160>>2]|0;if(j){if(a[d+164>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=e;c[d+156>>2]=1;j=(c[d+152>>2]|0)+1|0}else{j=1;e=c[d+160>>2]|0}c[d+152>>2]=j;c[e+0>>2]=c[k+0>>2];c[e+4>>2]=c[k+4>>2];c[e+8>>2]=c[k+8>>2];c[e+12>>2]=c[k+12>>2];c[e+16>>2]=c[k+16>>2];c[e+20>>2]=c[k+20>>2];c[e+24>>2]=c[k+24>>2];c[e+28>>2]=c[k+28>>2];y=c[d+160>>2]|0;x=c[d+136>>2]|0;b[y>>1]=b[x>>1]|0;b[y+2>>1]=b[x+2>>1]|0;b[y+4>>1]=b[x+4>>1]|0;b[y+6>>1]=b[x+6>>1]|0;b[y+8>>1]=b[x+8>>1]|0;b[y+10>>1]=b[x+10>>1]|0;c[y+12>>2]=0;x=c[x+12>>2]|0;c[y+16>>2]=(x|0)>-1?1:0-x|0}c[d+168>>2]=c[d+152>>2];e=c[d+116>>2]|0;if(e){if(a[d+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[d+116>>2]=0}a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;e=c[d+76>>2]|0;if(!e){a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;y=d+72|0;c[y>>2]=0;i=k;return}if(a[d+80>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[d+76>>2]=0;a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;y=d+72|0;c[y>>2]=0;i=k;return}function Qz(a){a=a|0;return 84}function Rz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;QA(a,b,c,d)|0;i=e;return 1}function Sz(a){a=a|0;return}function Tz(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Uz(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0;l=i;i=i+32|0;m=+g[d>>2];h=m<999999984306749400.0?m:999999984306749400.0;n=+g[d+4>>2];j=n<999999984306749400.0?n:999999984306749400.0;o=+g[d+8>>2];k=o<999999984306749400.0?o:999999984306749400.0;p=+g[d+12>>2];r=p<0.0?p:0.0;m=m>-999999984306749400.0?m:-999999984306749400.0;n=n>-999999984306749400.0?n:-999999984306749400.0;o=o>-999999984306749400.0?o:-999999984306749400.0;p=p>0.0?p:0.0;x=+g[d+16>>2];h=x<h?x:h;y=+g[d+20>>2];j=y<j?y:j;z=+g[d+24>>2];k=z<k?z:k;A=+g[d+28>>2];r=A<r?A:r;m=m<x?x:m;n=n<y?y:n;o=o<z?z:o;p=p<A?A:p;A=+g[d+32>>2];h=A<h?A:h;z=+g[d+36>>2];j=z<j?z:j;y=+g[d+40>>2];k=y<k?y:k;x=+g[d+44>>2];r=x<r?x:r;m=m<A?A:m;n=n<z?z:n;o=o<y?y:o;p=p<x?x:p;b=c[b+4>>2]|0;v=c[b+4>>2]|0;if((v|0)==(c[b+8>>2]|0)?(q=(v|0)==0?1:v<<1,(v|0)<(q|0)):0){if(!q)d=0;else{c[5004]=(c[5004]|0)+1;d=fF(q<<6|19)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}v=c[b+4>>2]|0}if((v|0)>0){w=0;do{s=d+(w<<6)+0|0;t=(c[b+12>>2]|0)+(w<<6)+0|0;u=s+64|0;do{c[s>>2]=c[t>>2];s=s+4|0;t=t+4|0}while((s|0)<(u|0));w=w+1|0}while((w|0)!=(v|0))}s=c[b+12>>2]|0;if(s){if(a[b+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[s+ -4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=d;c[b+8>>2]=q;v=c[b+4>>2]|0}w=c[b+12>>2]|0;g[w+(v<<6)>>2]=h;g[w+(v<<6)+4>>2]=j;g[w+(v<<6)+8>>2]=k;g[w+(v<<6)+12>>2]=r;g[w+(v<<6)+16>>2]=m;g[w+(v<<6)+20>>2]=n;g[w+(v<<6)+24>>2]=o;g[w+(v<<6)+28>>2]=p;c[w+(v<<6)+32>>2]=-1;c[w+(v<<6)+36>>2]=e;c[w+(v<<6)+40>>2]=f;w=w+(v<<6)+44|0;c[w+0>>2]=c[l+0>>2];c[w+4>>2]=c[l+4>>2];c[w+8>>2]=c[l+8>>2];c[w+12>>2]=c[l+12>>2];c[w+16>>2]=c[l+16>>2];c[b+4>>2]=(c[b+4>>2]|0)+1;i=l;return}function Vz(a){a=a|0;return}function Wz(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function Xz(d,e,f,h){d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0;j=i;q=+g[e>>2];v=q<999999984306749400.0?q:999999984306749400.0;r=+g[e+4>>2];w=r<999999984306749400.0?r:999999984306749400.0;s=+g[e+8>>2];u=s<999999984306749400.0?s:999999984306749400.0;q=q>-999999984306749400.0?q:-999999984306749400.0;r=r>-999999984306749400.0?r:-999999984306749400.0;s=s>-999999984306749400.0?s:-999999984306749400.0;z=+g[e+16>>2];v=z<v?z:v;A=+g[e+20>>2];w=A<w?A:w;B=+g[e+24>>2];u=B<u?B:u;q=q<z?z:q;r=r<A?A:r;s=s<B?B:s;B=+g[e+32>>2];v=B<v?B:v;A=+g[e+36>>2];w=A<w?A:w;z=+g[e+40>>2];u=z<u?z:u;q=q<B?B:q;r=r<A?A:r;s=s<z?z:s;if(q-v<.0020000000949949026){q=q+.0010000000474974513;v=v+-.0010000000474974513}if(r-w<.0020000000949949026){r=r+.0010000000474974513;w=w+-.0010000000474974513}if(s-u<.0020000000949949026){s=s+.0010000000474974513;u=u+-.0010000000474974513}e=c[d+8>>2]|0;E=+g[e+4>>2];C=+g[e+8>>2];A=+g[e+12>>2];D=+g[e+36>>2];z=+g[e+40>>2];B=+g[e+44>>2];e=~~((v-E)*D)&65534;l=~~((w-C)*z)&65534;m=~~((u-A)*B)&65534;n=(~~((q-E)*D+1.0)&65535|1)&65535;o=(~~((r-C)*z+1.0)&65535|1)&65535;p=(~~((s-A)*B+1.0)&65535|1)&65535;d=c[d+4>>2]|0;y=c[d+4>>2]|0;if((y|0)==(c[d+8>>2]|0)?(k=(y|0)==0?1:y<<1,(y|0)<(k|0)):0){if(!k)t=0;else{c[5004]=(c[5004]|0)+1;t=fF((k<<4|3)+16|0)|0;if(!t)t=0;else{c[(t+19&-16)+ -4>>2]=t;t=t+19&-16}y=c[d+4>>2]|0}if((y|0)>0){x=0;do{F=t+(x<<4)|0;G=(c[d+12>>2]|0)+(x<<4)|0;c[F+0>>2]=c[G+0>>2];c[F+4>>2]=c[G+4>>2];c[F+8>>2]=c[G+8>>2];c[F+12>>2]=c[G+12>>2];x=x+1|0}while((x|0)!=(y|0))}x=c[d+12>>2]|0;if(x){if(a[d+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[x+ -4>>2]|0)}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=t;c[d+8>>2]=k;y=c[d+4>>2]|0}G=c[d+12>>2]|0;b[G+(y<<4)>>1]=e;b[G+(y<<4)+2>>1]=l;b[G+(y<<4)+4>>1]=m;b[G+(y<<4)+6>>1]=n;b[G+(y<<4)+8>>1]=o;b[G+(y<<4)+10>>1]=p;c[G+(y<<4)+12>>2]=f<<21|h;c[d+4>>2]=(c[d+4>>2]|0)+1;i=j;return}function Yz(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;c[b>>2]=15272;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+24>>2]=0;a[b+28>>0]=0;a[b+48>>0]=1;c[b+44>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;a[b+68>>0]=1;c[b+64>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;c[b+72>>2]=0;c[5004]=(c[5004]|0)+1;e=fF(51)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}f=c[b+8>>2]|0;if((f|0)>0){g=0;do{h=c[b+16>>2]|0;c[e+(g<<4)>>2]=c[h+(g<<4)>>2];c[e+(g<<4)+4>>2]=c[h+(g<<4)+4>>2];c[e+(g<<4)+8>>2]=c[h+(g<<4)+8>>2];c[e+(g<<4)+12>>2]=c[h+(g<<4)+12>>2];g=g+1|0}while((g|0)!=(f|0))}f=c[b+16>>2]|0;if(!f){a[b+20>>0]=1;c[b+16>>2]=e;c[b+12>>2]=2;Zz(b);i=d;return}if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=e;c[b+12>>2]=2;Zz(b);i=d;return}function Zz(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;f=c[b+12>>2]|0;d=c[b+36>>2]|0;if((d|0)>=(f|0)){i=e;return}if((d|0)<=(f|0)){if((c[b+40>>2]|0)<(f|0)){if(!f){g=0;j=d}else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}j=c[b+36>>2]|0}if((j|0)>0){h=0;do{k=g+(h<<2)|0;if(k)c[k>>2]=c[(c[b+44>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(j|0))}h=c[b+44>>2]|0;if(h){if(a[b+48>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+44>>2]=0}a[b+48>>0]=1;c[b+44>>2]=g;c[b+40>>2]=f}else g=c[b+44>>2]|0;h=d;do{j=g+(h<<2)|0;if(j)c[j>>2]=0;h=h+1|0}while((h|0)!=(f|0))}c[b+36>>2]=f;g=c[b+56>>2]|0;if((g|0)<(f|0)){if((c[b+60>>2]|0)<(f|0)){if(!f){h=0;j=g}else{c[5004]=(c[5004]|0)+1;h=fF((f<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}j=c[b+56>>2]|0}if((j|0)>0){k=0;do{l=h+(k<<2)|0;if(l)c[l>>2]=c[(c[b+64>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}j=c[b+64>>2]|0;if(j){if(a[b+68>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0)}c[b+64>>2]=0}a[b+68>>0]=1;c[b+64>>2]=h;c[b+60>>2]=f}else h=c[b+64>>2]|0;do{j=h+(g<<2)|0;if(j)c[j>>2]=0;g=g+1|0}while((g|0)!=(f|0))}c[b+56>>2]=f;if((f|0)>0){jF(c[b+44>>2]|0,-1,f<<2|0)|0;jF(c[b+64>>2]|0,-1,f<<2|0)|0}if((d|0)<=0){i=e;return}h=c[b+16>>2]|0;g=c[b+44>>2]|0;f=c[b+64>>2]|0;j=0;do{l=c[(c[h+(j<<4)+4>>2]|0)+12>>2]<<16|c[(c[h+(j<<4)>>2]|0)+12>>2];l=(l+~(l<<15)>>10^l+~(l<<15))*9|0;l=g+((((l>>6^l)+~((l>>6^l)<<11)>>16^(l>>6^l)+~((l>>6^l)<<11))&(c[b+12>>2]|0)+ -1)<<2)|0;c[f+(j<<2)>>2]=c[l>>2];c[l>>2]=j;j=j+1|0}while((j|0)!=(d|0));i=e;return}function _z(a){a=a|0;var b=0;b=i;$z(a);gF(a);i=b;return}function $z(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=15272;e=c[b+64>>2]|0;if(e){if(a[b+68>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+64>>2]=0}a[b+68>>0]=1;c[b+64>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;e=c[b+44>>2]|0;if(e){if(a[b+48>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+44>>2]=0}a[b+48>>0]=1;c[b+44>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;e=c[b+16>>2]|0;if(!e){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;e=b+12|0;c[e>>2]=0;i=d;return}if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;e=b+12|0;c[e>>2]=0;i=d;return}function aA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;a=i;e=c[b+8>>2]|0;if((e|0)==0|(d|0)==0){i=a;return}Lb[c[c[e>>2]>>2]&511](e);Nb[c[(c[d>>2]|0)+60>>2]&127](d,c[b+8>>2]|0);c[b+8>>2]=0;i=a;return}function bA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=15576;c[e+4>>2]=b;c[e+8>>2]=a;c[e+12>>2]=d;rc[c[(c[a>>2]|0)+48>>2]&127](a,e,d);i=e;return}function cA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=15400;c[e+4>>2]=b;rc[c[(c[a>>2]|0)+48>>2]&127](a,e,d);i=e;return}function dA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=i;c[3814]=(c[3814]|0)+1;h=(c[b+12>>2]|0)>(c[d+12>>2]|0);g=c[(h?d:b)+12>>2]|0;b=c[(h?b:d)+12>>2]|0;d=((b<<16|g)+~((b<<16|g)<<15)>>10^(b<<16|g)+~((b<<16|g)<<15))*9|0;d=((d>>6^d)+~((d>>6^d)<<11)>>16^(d>>6^d)+~((d>>6^d)<<11))&(c[a+12>>2]|0)+ -1;if((d|0)>=(c[a+36>>2]|0)){h=0;i=f;return h|0}h=c[(c[a+44>>2]|0)+(d<<2)>>2]|0;if((h|0)==-1){h=0;i=f;return h|0}d=c[a+16>>2]|0;while(1){if((c[(c[d+(h<<4)>>2]|0)+12>>2]|0)==(g|0)?(c[(c[d+(h<<4)+4>>2]|0)+12>>2]|0)==(b|0):0)break;h=c[(c[a+64>>2]|0)+(h<<2)>>2]|0;if((h|0)==-1){g=0;e=8;break}}if((e|0)==8){i=f;return g|0}h=d+(h<<4)|0;i=f;return h|0}function eA(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;f=i;d=c[b+4>>2]|0;if((d|0)!=(c[b+8>>2]|0)){j=d;j=j+1|0;c[b+4>>2]=j;j=b+12|0;j=c[j>>2]|0;j=j+(d<<4)|0;i=f;return j|0}e=(d|0)==0?1:d<<1;if((d|0)>=(e|0)){j=d;j=j+1|0;c[b+4>>2]=j;j=b+12|0;j=c[j>>2]|0;j=j+(d<<4)|0;i=f;return j|0}if(!e){g=0;h=d}else{c[5004]=(c[5004]|0)+1;g=fF((e<<4|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[b+4>>2]|0}if((h|0)>0){j=0;do{k=c[b+12>>2]|0;c[g+(j<<4)>>2]=c[k+(j<<4)>>2];c[g+(j<<4)+4>>2]=c[k+(j<<4)+4>>2];c[g+(j<<4)+8>>2]=c[k+(j<<4)+8>>2];c[g+(j<<4)+12>>2]=c[k+(j<<4)+12>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[b+12>>2]|0;if(j){if(a[b+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[b+4>>2]|0}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=g;c[b+8>>2]=e;k=h;k=k+1|0;c[b+4>>2]=k;k=b+12|0;k=c[k>>2]|0;k=k+(d<<4)|0;i=f;return k|0}function fA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;g=i;c[3810]=(c[3810]|0)+1;j=(c[b+12>>2]|0)>(c[d+12>>2]|0);h=j?d:b;j=j?b:d;l=c[h+12>>2]|0;d=c[j+12>>2]|0;k=((d<<16|l)+~((d<<16|l)<<15)>>10^(d<<16|l)+~((d<<16|l)<<15))*9|0;k=((k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11))&(c[a+12>>2]|0)+ -1;m=c[(c[a+44>>2]|0)+(k<<2)>>2]|0;if((m|0)==-1){o=0;i=g;return o|0}b=c[a+16>>2]|0;while(1){if((c[(c[b+(m<<4)>>2]|0)+12>>2]|0)==(l|0)?(c[(c[b+(m<<4)+4>>2]|0)+12>>2]|0)==(d|0):0)break;m=c[(c[a+64>>2]|0)+(m<<2)>>2]|0;if((m|0)==-1){a=0;f=24;break}}if((f|0)==24){i=g;return a|0}d=b+(m<<4)|0;if(!d){o=0;i=g;return o|0}rc[c[(c[a>>2]|0)+32>>2]&127](a,d,e);b=c[b+(m<<4)+12>>2]|0;d=d-(c[a+16>>2]|0)>>4;k=(c[a+44>>2]|0)+(k<<2)|0;l=c[k>>2]|0;m=c[a+64>>2]|0;if((l|0)!=(d|0)){while(1){n=m+(l<<2)|0;o=c[n>>2]|0;if((o|0)==(d|0))break;else l=o}m=c[m+(d<<2)>>2]|0;if((l|0)==-1)f=12;else c[n>>2]=m}else{m=c[m+(d<<2)>>2]|0;f=12}if((f|0)==12)c[k>>2]=m;k=(c[a+8>>2]|0)+ -1|0;l=c[a+72>>2]|0;if(l)Tb[c[(c[l>>2]|0)+12>>2]&31](l,h,j,e)|0;if((k|0)==(d|0)){c[a+8>>2]=(c[a+8>>2]|0)+ -1;o=b;i=g;return o|0}j=c[a+16>>2]|0;h=c[(c[j+(k<<4)+4>>2]|0)+12>>2]<<16|c[(c[j+(k<<4)>>2]|0)+12>>2];h=(h+~(h<<15)>>10^h+~(h<<15))*9|0;h=((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11))&(c[a+12>>2]|0)+ -1;e=(c[a+44>>2]|0)+(h<<2)|0;m=c[e>>2]|0;n=c[a+64>>2]|0;if((m|0)!=(k|0)){while(1){l=n+(m<<2)|0;o=c[l>>2]|0;if((o|0)==(k|0))break;else m=o}n=c[n+(k<<2)>>2]|0;if((m|0)==-1)f=22;else c[l>>2]=n}else{n=c[n+(k<<2)>>2]|0;f=22}if((f|0)==22)c[e>>2]=n;c[j+(d<<4)+0>>2]=c[j+(k<<4)+0>>2];c[j+(d<<4)+4>>2]=c[j+(k<<4)+4>>2];c[j+(d<<4)+8>>2]=c[j+(k<<4)+8>>2];c[j+(d<<4)+12>>2]=c[j+(k<<4)+12>>2];o=(c[a+44>>2]|0)+(h<<2)|0;c[(c[a+64>>2]|0)+(d<<2)>>2]=c[o>>2];c[o>>2]=d;c[a+8>>2]=(c[a+8>>2]|0)+ -1;o=b;i=g;return o|0}function gA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;if((c[a+8>>2]|0)<=0){i=e;return}f=0;a:while(1){while(1){h=c[a+16>>2]|0;g=h+(f<<4)|0;if(!(gc[c[(c[b>>2]|0)+8>>2]&31](b,g)|0))break;Tb[c[(c[a>>2]|0)+12>>2]&31](a,c[g>>2]|0,c[h+(f<<4)+4>>2]|0,d)|0;c[3808]=(c[3808]|0)+ -1;if((f|0)>=(c[a+8>>2]|0)){a=7;break a}}f=f+1|0;if((f|0)>=(c[a+8>>2]|0)){a=7;break}}if((a|0)==7){i=e;return}}function hA(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;i=i+32|0;a[e+16>>0]=1;c[e+12>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;m=c[b+8>>2]|0;if((m|0)>0){k=0;f=0;l=0;g=0;while(1){h=c[b+16>>2]|0;if((f|0)==(l|0)){j=(l|0)==0?1:l<<1;if((l|0)<(j|0)){if(j){c[5004]=(c[5004]|0)+1;k=fF((j<<4|3)+16|0)|0;if(!k){k=0;l=f}else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16;l=f}}else k=0;if((l|0)>0){m=0;do{n=c[e+12>>2]|0;c[k+(m<<4)>>2]=c[n+(m<<4)>>2];c[k+(m<<4)+4>>2]=c[n+(m<<4)+4>>2];c[k+(m<<4)+8>>2]=c[n+(m<<4)+8>>2];c[k+(m<<4)+12>>2]=c[n+(m<<4)+12>>2];m=m+1|0}while((m|0)!=(l|0))}m=c[e+12>>2]|0;if(!m)f=l;else{c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0);c[e+12>>2]=0}a[e+16>>0]=1;c[e+12>>2]=k;c[e+8>>2]=j;m=c[b+8>>2]|0;l=f}else j=l}else{j=l;l=f}c[k+(l<<4)>>2]=c[h+(g<<4)>>2];c[k+(l<<4)+4>>2]=c[h+(g<<4)+4>>2];c[k+(l<<4)+8>>2]=c[h+(g<<4)+8>>2];c[k+(l<<4)+12>>2]=c[h+(g<<4)+12>>2];f=l+1|0;g=g+1|0;if((g|0)>=(m|0))break;else l=j}c[e+4>>2]=f;if((l|0)>-1){g=0;do{Tb[c[(c[b>>2]|0)+12>>2]&31](b,c[k+(g<<4)>>2]|0,c[k+(g<<4)+4>>2]|0,d)|0;g=g+1|0}while((g|0)<(f|0))}}else f=0;if((c[b+56>>2]|0)>0){d=c[b+64>>2]|0;g=0;do{c[d+(g<<2)>>2]=-1;g=g+1|0}while((g|0)<(c[b+56>>2]|0))}if((f|0)>1){os(e,0,f+ -1|0);f=c[e+4>>2]|0}if((f|0)>0){d=c[e+12>>2]|0;g=0;do{Yb[c[(c[b>>2]|0)+8>>2]&31](b,c[d+(g<<4)>>2]|0,c[d+(g<<4)+4>>2]|0)|0;g=g+1|0}while((g|0)<(f|0))}else d=c[e+12>>2]|0;if(!d){i=e;return}if(a[e+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[d+ -4>>2]|0)}c[e+12>>2]=0;i=e;return}function iA(a,d,e){a=a|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;c[3812]=(c[3812]|0)+1;g=c[a+24>>2]|0;if(!g){if(!((b[e+6>>1]&b[d+4>>1])<<16>>16)){m=0;i=f;return m|0}if(!((b[d+6>>1]&b[e+4>>1])<<16>>16)){m=0;i=f;return m|0}}else if(!(Yb[c[(c[g>>2]|0)+8>>2]&31](g,d,e)|0)){m=0;i=f;return m|0}j=(c[d+12>>2]|0)>(c[e+12>>2]|0);g=j?e:d;e=j?d:e;j=c[g+12>>2]|0;l=c[e+12>>2]|0;d=((l<<16|j)+~((l<<16|j)<<15)>>10^(l<<16|j)+~((l<<16|j)<<15))*9|0;d=(d>>6^d)+~((d>>6^d)<<11)>>16^(d>>6^d)+~((d>>6^d)<<11);h=c[a+12>>2]|0;m=c[(c[a+44>>2]|0)+((d&h+ -1)<<2)>>2]|0;a:do if((m|0)!=-1){k=c[a+16>>2]|0;while(1){if((c[(c[k+(m<<4)>>2]|0)+12>>2]|0)==(j|0)?(c[(c[k+(m<<4)+4>>2]|0)+12>>2]|0)==(l|0):0)break;m=c[(c[a+64>>2]|0)+(m<<2)>>2]|0;if((m|0)==-1)break a}j=k+(m<<4)|0;if(j){m=j;i=f;return m|0}}while(0);k=c[a+8>>2]|0;j=eA(a+4|0)|0;l=c[a+72>>2]|0;if(l)Yb[c[(c[l>>2]|0)+8>>2]&31](l,g,e)|0;if((h|0)<(c[a+12>>2]|0)){Zz(a);d=(c[a+12>>2]|0)+ -1&d}else d=d&h+ -1;if((c[g+12>>2]|0)<(c[e+12>>2]|0)){c[j>>2]=g;c[j+4>>2]=e}else{c[j>>2]=e;c[j+4>>2]=g}c[j+8>>2]=0;c[j+12>>2]=0;m=(c[a+44>>2]|0)+(d<<2)|0;c[(c[a+64>>2]|0)+(k<<2)>>2]=c[m>>2];c[m>>2]=k;m=j;i=f;return m|0}function jA(a){a=a|0;return c[a+16>>2]|0}function kA(a){a=a|0;return c[a+16>>2]|0}function lA(a){a=a|0;return a+4|0}function mA(a){a=a|0;return c[a+8>>2]|0}function nA(a,b){a=a|0;b=b|0;c[a+24>>2]=b;return}function oA(a){a=a|0;return 0}function pA(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function qA(a){a=a|0;return}function rA(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function sA(a,b){a=a|0;b=b|0;var d=0;d=i;a=c[a+4>>2]|0;if((c[b>>2]|0)==(a|0)){a=1;i=d;return a|0}a=(c[b+4>>2]|0)==(a|0);i=d;return a|0}function tA(a){a=a|0;return}function uA(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function vA(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[a+4>>2]|0;if((c[b>>2]|0)!=(e|0)?(c[b+4>>2]|0)!=(e|0):0){i=d;return 0}e=c[a+8>>2]|0;rc[c[(c[e>>2]|0)+32>>2]&127](e,b,c[a+12>>2]|0);i=d;return 0}function wA(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0,h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;d=i;f=c[a+748>>2]|0;if((f|0)!=4){c[a+748>>2]=f+1;z=f;l=(z|0)<0;z=l?0:z;l=a+(z*184|0)+4|0;mF(l|0,b|0,184)|0;i=d;return z|0}e=+g[b+80>>2];y=+g[a+84>>2];x=y<e?y:e;w=+g[a+268>>2];v=w<x?w:x;u=+g[a+452>>2];l=+g[a+636>>2]<(u<v?u:v);z=l?3:u<v?2:w<x?1:(y<e^1)<<31>>31;e=+g[b>>2];if(z){m=+g[a+188>>2];p=+g[b+4>>2];n=+g[a+192>>2];k=+g[b+8>>2];o=+g[a+196>>2];u=+g[a+556>>2];t=+g[a+372>>2];w=+g[a+560>>2];v=+g[a+376>>2];q=+g[a+564>>2];s=+g[a+380>>2];h=((e-m)*(w-v)-(p-n)*(u-t))*((e-m)*(w-v)-(p-n)*(u-t))+(((p-n)*(q-s)-(k-o)*(w-v))*((p-n)*(q-s)-(k-o)*(w-v))+((k-o)*(u-t)-(e-m)*(q-s))*((k-o)*(u-t)-(e-m)*(q-s)));if((z|0)==1){j=+g[a+12>>2];y=q;q=0.0;r=+g[a+4>>2];x=+g[a+8>>2];f=7}else{y=q;f=6}}else{m=+g[a+188>>2];n=+g[a+192>>2];o=+g[a+196>>2];h=0.0;p=+g[b+4>>2];k=+g[b+8>>2];t=+g[a+372>>2];u=+g[a+556>>2];v=+g[a+376>>2];w=+g[a+560>>2];s=+g[a+380>>2];y=+g[a+564>>2];f=6}if((f|0)==6){r=+g[a+4>>2];x=+g[a+8>>2];D=p-x;j=+g[a+12>>2];B=k-j;A=u-t;C=w-v;q=y-s;q=((e-r)*C-D*A)*((e-r)*C-D*A)+((D*q-B*C)*(D*q-B*C)+(B*A-(e-r)*q)*(B*A-(e-r)*q));if((z|0)==2){u=x;w=0.0;f=8}else f=7}if((f|0)==7){D=e-r;E=p-x;B=k-j;C=u-m;A=w-n;w=y-o;w=(D*A-E*C)*(D*A-E*C)+((E*w-B*A)*(E*w-B*A)+(B*C-D*w)*(B*C-D*w));if(l)e=0.0;else{u=x;f=8}}if((f|0)==8){E=e-r;A=p-u;C=k-j;D=t-m;B=v-n;e=s-o;e=(E*B-A*D)*(E*B-A*D)+((A*e-C*B)*(A*e-C*B)+(C*D-E*e)*(C*D-E*e))}E=+P(+h);C=+P(+q);A=+P(+w);y=+P(+e);D=E>-999999984306749400.0?E:-999999984306749400.0;B=C>D?C:D;z=y>(A>B?A:B)?3:A>B?2:C>D?1:(E>-999999984306749400.0^1)<<31>>31;l=(z|0)<0;z=l?0:z;l=a+(z*184|0)+4|0;mF(l|0,b|0,184)|0;i=d;return z|0}function xA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;f=i;h=c[b+748>>2]|0;if((h|0)<=0){i=f;return}do{h=h+ -1|0;q=+g[b+(h*184|0)+4>>2];r=+g[b+(h*184|0)+8>>2];j=+g[b+(h*184|0)+12>>2];p=q*+g[d>>2]+r*+g[d+4>>2]+j*+g[d+8>>2]+ +g[d+48>>2];n=q*+g[d+16>>2]+r*+g[d+20>>2]+j*+g[d+24>>2]+ +g[d+52>>2];j=q*+g[d+32>>2]+r*+g[d+36>>2]+j*+g[d+40>>2]+ +g[d+56>>2];g[b+(h*184|0)+52>>2]=p;g[b+(h*184|0)+56>>2]=n;g[b+(h*184|0)+60>>2]=j;g[b+(h*184|0)+64>>2]=0.0;r=+g[b+(h*184|0)+20>>2];q=+g[b+(h*184|0)+24>>2];k=+g[b+(h*184|0)+28>>2];o=r*+g[e>>2]+q*+g[e+4>>2]+k*+g[e+8>>2]+ +g[e+48>>2];m=r*+g[e+16>>2]+q*+g[e+20>>2]+k*+g[e+24>>2]+ +g[e+52>>2];k=r*+g[e+32>>2]+q*+g[e+36>>2]+k*+g[e+40>>2]+ +g[e+56>>2];g[b+(h*184|0)+36>>2]=o;g[b+(h*184|0)+40>>2]=m;g[b+(h*184|0)+44>>2]=k;g[b+(h*184|0)+48>>2]=0.0;g[b+(h*184|0)+84>>2]=(p-o)*+g[b+(h*184|0)+68>>2]+(n-m)*+g[b+(h*184|0)+72>>2]+(j-k)*+g[b+(h*184|0)+76>>2];l=b+(h*184|0)+152|0;c[l>>2]=(c[l>>2]|0)+1}while((h|0)>0);d=c[b+748>>2]|0;if((d|0)<=0){i=f;return}e=d;do{d=d+ -1|0;h=b+(d*184|0)+4|0;k=+g[b+(d*184|0)+84>>2];j=+g[b+752>>2];if(k<=j){p=+g[b+(d*184|0)+36>>2]-(+g[b+(d*184|0)+52>>2]- +g[b+(d*184|0)+68>>2]*k);q=+g[b+(d*184|0)+40>>2]-(+g[b+(d*184|0)+56>>2]-k*+g[b+(d*184|0)+72>>2]);r=+g[b+(d*184|0)+44>>2]-(+g[b+(d*184|0)+60>>2]-k*+g[b+(d*184|0)+76>>2]);if(p*p+q*q+r*r>j*j){l=e+ -1|0;if((l|0)!=(d|0)){mF(h|0,b+(l*184|0)+4|0,184)|0;c[b+(l*184|0)+116>>2]=0;g[b+(l*184|0)+124>>2]=0.0;a[b+(l*184|0)+120>>0]=0;g[b+(l*184|0)+128>>2]=0.0;g[b+(l*184|0)+132>>2]=0.0;c[b+(l*184|0)+152>>2]=0;e=c[b+748>>2]|0}e=e+ -1|0;c[b+748>>2]=e}}else{l=e+ -1|0;if((l|0)!=(d|0)){mF(h|0,b+(l*184|0)+4|0,184)|0;c[b+(l*184|0)+116>>2]=0;g[b+(l*184|0)+124>>2]=0.0;a[b+(l*184|0)+120>>0]=0;g[b+(l*184|0)+128>>2]=0.0;g[b+(l*184|0)+132>>2]=0.0;c[b+(l*184|0)+152>>2]=0;e=c[b+748>>2]|0}e=e+ -1|0;c[b+748>>2]=e}}while((d|0)>0);i=f;return}function yA(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=15736;d=c[a+52>>2]|0;if(d){Lb[c[c[d>>2]>>2]&511](d);d=c[a+52>>2]|0;if(d){c[5006]=(c[5006]|0)+1;gF(c[d+ -4>>2]|0)}if(!a){i=b;return}}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function zA(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=15736;d=c[a+52>>2]|0;if(!d){i=b;return}Lb[c[c[d>>2]>>2]&511](d);a=c[a+52>>2]|0;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}



function AA(d,f){d=d|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0,$=0,aa=0,ba=0.0,ca=0.0,da=0,ea=0;h=i;i=i+336|0;m=c[d+52>>2]|0;if((m|0)!=0?(Lb[c[c[m>>2]>>2]&511](m),j=c[d+52>>2]|0,(j|0)!=0):0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0)}c[5004]=(c[5004]|0)+1;j=fF(151)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}c[j>>2]=19496;a[j+20>>0]=1;c[j+16>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;a[j+40>>0]=1;c[j+36>>2]=0;c[j+28>>2]=0;c[j+32>>2]=0;a[j+60>>0]=1;c[j+56>>2]=0;c[j+48>>2]=0;c[j+52>>2]=0;c[d+52>>2]=j;s=0;m=0;v=0;j=0;while(1){if((s|0)>=(Pb[c[(c[d>>2]|0)+96>>2]&127](d)|0))break;if((m|0)==(v|0)){w=(v|0)==0?1:v<<1;if((v|0)<(w|0)){if((w|0)!=0?(c[5004]=(c[5004]|0)+1,p=fF((w<<4|3)+16|0)|0,(p|0)!=0):0){c[(p+19&-16)+ -4>>2]=p;u=p+19&-16}else u=0;if((v|0)>0){t=0;do{aa=u+(t<<4)|0;$=j+(t<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];t=t+1|0}while((t|0)!=(v|0))}if(!j){t=v;v=w;j=u}else{c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);t=v;v=w;j=u}}else t=v}else t=m;aa=j+(m<<4)|0;c[aa+0>>2]=c[h+256>>2];c[aa+4>>2]=c[h+260>>2];c[aa+8>>2]=c[h+264>>2];c[aa+12>>2]=c[h+268>>2];rc[c[(c[d>>2]|0)+108>>2]&127](d,s,aa);s=s+1|0;m=t+1|0}a[h+212>>0]=1;c[h+208>>2]=0;c[h+200>>2]=0;c[h+204>>2]=0;a[h+232>>0]=1;c[h+228>>2]=0;c[h+220>>2]=0;c[h+224>>2]=0;a[h+252>>0]=1;c[h+248>>2]=0;c[h+240>>2]=0;c[h+244>>2]=0;if(f){if((m|0)>0){f=0;C=0;E=0;F=0;while(1){t=f;f=f+1|0;if((f|0)<(m|0)){s=j+(t<<4)|0;p=j+(t<<4)+4|0;t=j+(t<<4)+8|0;u=f;do{x=u;u=u+1|0;if((u|0)<(m|0)){w=j+(x<<4)|0;v=j+(x<<4)+4|0;x=j+(x<<4)+8|0;y=u;do{A=+g[s>>2];U=+g[w>>2]-A;T=+g[p>>2];R=+g[v>>2]-T;B=+g[t>>2];S=+g[x>>2]-B;A=+g[j+(y<<4)>>2]-A;T=+g[j+(y<<4)+4>>2]-T;B=+g[j+(y<<4)+8>>2]-B;X=1.0;D=0;while(1){V=(R*B-S*T)*X;W=(S*A-U*B)*X;X=(U*T-R*A)*X;a:do if(X*X+(V*V+W*W)>9999999747378752.0e-20){Y=1.0/+Q(+(X*X+(V*V+W*W)));if((C|0)>0){G=0;do{if(V*Y*+g[F+(G<<4)>>2]+W*Y*+g[F+(G<<4)+4>>2]+X*Y*+g[F+(G<<4)+8>>2]>.9990000128746033)break a;G=G+1|0}while((G|0)<(C|0))}Z=V*Y*+g[s>>2]+W*Y*+g[p>>2]+X*Y*+g[t>>2];G=0;do{if(V*Y*+g[j+(G<<4)>>2]+W*Y*+g[j+(G<<4)+4>>2]+X*Y*+g[j+(G<<4)+8>>2]-Z+-.009999999776482582>0.0)break a;G=G+1|0}while((G|0)<(m|0));do if((C|0)==(E|0)){H=(E|0)==0?1:E<<1;if((E|0)<(H|0)){do if(!H)I=0;else{c[5004]=(c[5004]|0)+1;G=fF((H<<4|3)+16|0)|0;if(!G){I=0;break}c[(G+19&-16)+ -4>>2]=G;I=G+19&-16}while(0);if((E|0)>0){G=0;do{aa=I+(G<<4)|0;$=F+(G<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];G=G+1|0}while((G|0)!=(E|0))}if(!F){G=E;E=H;F=I;break}c[5006]=(c[5006]|0)+1;gF(c[F+ -4>>2]|0);G=E;E=H;F=I}else G=E}else G=C;while(0);g[F+(G<<4)>>2]=V*Y;g[F+(G<<4)+4>>2]=W*Y;g[F+(G<<4)+8>>2]=X*Y;g[F+(G<<4)+12>>2]=-Z;C=C+1|0}while(0);D=D+1|0;if((D|0)==2)break;else X=-1.0}y=y+1|0}while((y|0)!=(m|0))}}while((u|0)!=(m|0))}if((f|0)==(m|0)){m=F;break}}if((C|0)>0){p=0;f=0;s=0;v=0;while(1){aa=m+(p<<4)|0;c[h+184>>2]=c[aa+0>>2];c[h+188>>2]=c[aa+4>>2];c[h+192>>2]=c[aa+8>>2];A=+g[m+(p<<4)+12>>2];A=A- +$b[c[(c[d>>2]|0)+48>>2]&15](d);if((f|0)==(s|0)){w=(s|0)==0?1:s<<1;if((s|0)<(w|0)){if((w|0)!=0?(c[5004]=(c[5004]|0)+1,l=fF((w<<4|3)+16|0)|0,(l|0)!=0):0){c[(l+19&-16)+ -4>>2]=l;t=l+19&-16}else t=0;if((s|0)>0){u=0;do{aa=t+(u<<4)|0;$=v+(u<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];u=u+1|0}while((u|0)!=(s|0))}if(!v){u=s;s=w}else{c[5006]=(c[5006]|0)+1;gF(c[v+ -4>>2]|0);u=s;s=w}}else{u=s;t=v}}else{u=f;t=v}aa=t+(u<<4)|0;c[aa+0>>2]=c[h+184>>2];c[aa+4>>2]=c[h+188>>2];c[aa+8>>2]=c[h+192>>2];g[t+(u<<4)+12>>2]=A;f=f+1|0;p=p+1|0;if((p|0)>=(C|0)){l=t;break}else v=t}if((f|0)>0){p=0;w=0;x=0;y=0;do{t=p;p=p+1|0;if((p|0)<(f|0)){s=p;do{u=s;s=s+1|0;if((s|0)<(f|0)){v=s;do{S=+g[l+(u<<4)+4>>2];Y=+g[l+(v<<4)+8>>2];B=+g[l+(u<<4)+8>>2];T=+g[l+(v<<4)+4>>2];W=+g[l+(v<<4)>>2];U=+g[l+(u<<4)>>2];X=+g[l+(t<<4)+8>>2];R=+g[l+(t<<4)+4>>2];V=+g[l+(t<<4)>>2];b:do if((((T*U-S*W)*(T*U-S*W)+((S*Y-B*T)*(S*Y-B*T)+(B*W-Y*U)*(B*W-Y*U))>9999999747378752.0e-20?(W*R-T*V)*(W*R-T*V)+((T*X-Y*R)*(T*X-Y*R)+(Y*V-W*X)*(Y*V-W*X))>9999999747378752.0e-20:0)?(S*V-U*R)*(S*V-U*R)+((B*R-S*X)*(B*R-S*X)+(U*X-B*V)*(U*X-B*V))>9999999747378752.0e-20:0)?(z=X*(T*U-S*W)+(R*(B*W-Y*U)+(S*Y-B*T)*V),+P(+z)>9.999999974752427e-7):0){ba=+g[l+(t<<4)+12>>2];Z=+g[l+(u<<4)+12>>2];ca=+g[l+(v<<4)+12>>2];A=-1.0/z*((B*R-S*X)*ca+((S*Y-B*T)*ba+(T*X-Y*R)*Z));B=-1.0/z*((U*X-B*V)*ca+((B*W-Y*U)*ba+(Y*V-W*X)*Z));R=-1.0/z*((S*V-U*R)*ca+((T*U-S*W)*ba+(W*R-T*V)*Z));C=0;do{if(+g[l+(C<<4)+12>>2]+(A*+g[l+(C<<4)>>2]+B*+g[l+(C<<4)+4>>2]+R*+g[l+(C<<4)+8>>2])+-.009999999776482582>0.0)break b;C=C+1|0}while((C|0)<(f|0));do if((w|0)==(x|0)){D=(x|0)==0?1:x<<1;if((x|0)>=(D|0)){C=x;break}do if(!D)E=0;else{c[5004]=(c[5004]|0)+1;C=fF((D<<4|3)+16|0)|0;if(!C){E=0;break}c[(C+19&-16)+ -4>>2]=C;E=C+19&-16}while(0);if((x|0)>0){C=0;do{aa=E+(C<<4)|0;$=y+(C<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];C=C+1|0}while((C|0)!=(x|0))}if(!y){C=x;x=D;y=E;break}c[5006]=(c[5006]|0)+1;gF(c[y+ -4>>2]|0);C=x;x=D;y=E}else C=w;while(0);g[y+(C<<4)>>2]=A;g[y+(C<<4)+4>>2]=B;g[y+(C<<4)+8>>2]=R;g[y+(C<<4)+12>>2]=0.0;w=w+1|0}while(0);v=v+1|0}while((v|0)!=(f|0))}}while((s|0)!=(f|0))}}while((p|0)!=(f|0))}else{w=0;y=0}}else{l=0;w=0;y=0}}else{m=0;l=0;w=0;y=0}uE(h+196|0,y,w);if(y){c[5006]=(c[5006]|0)+1;gF(c[y+ -4>>2]|0)}if(l){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}if(m){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}}else uE(h+196|0,j,m);s=c[h+240>>2]|0;if((s|0)>0&((s|0)<0^1)){c[5004]=(c[5004]|0)+1;l=fF((s<<4|3)+16|0)|0;if(!l)m=0;else{c[(l+19&-16)+ -4>>2]=l;m=l+19&-16}l=0;do{aa=m+(l<<4)|0;c[aa+0>>2]=c[h+168>>2];c[aa+4>>2]=c[h+172>>2];c[aa+8>>2]=c[h+176>>2];c[aa+12>>2]=c[h+180>>2];l=l+1|0}while((l|0)!=(s|0))}else m=0;a[h+164>>0]=1;f=h+160|0;c[f>>2]=0;l=h+152|0;c[l>>2]=0;c[h+156>>2]=0;p=h+112|0;t=p+36|0;do{c[p>>2]=0;p=p+4|0}while((p|0)<(t|0));a[h+128>>0]=1;c[h+124>>2]=0;c[h+116>>2]=0;c[h+120>>2]=0;if((s|0)<0)Gb();if((s|0)>0){GA(h+148|0,s);p=c[f>>2]|0;t=0;do{u=p+(t*36|0)|0;if(u){IA(u,h+112|0);c[u+20>>2]=c[h+132>>2];c[u+24>>2]=c[h+136>>2];c[u+28>>2]=c[h+140>>2];c[u+32>>2]=c[h+144>>2]}t=t+1|0}while((t|0)!=(s|0));t=c[h+124>>2]|0;c[l>>2]=s;if(t){if(a[h+128>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[t+ -4>>2]|0)}c[h+124>>2]=0}}else{c[l>>2]=s;p=0}a[h+128>>0]=1;c[h+124>>2]=0;c[h+116>>2]=0;c[h+120>>2]=0;t=c[h+200>>2]|0;u=c[d+52>>2]|0;v=c[u+8>>2]|0;if((v|0)<(t|0)){if((c[u+12>>2]|0)<(t|0)){if(!t){w=0;y=v}else{c[5004]=(c[5004]|0)+1;w=fF((t<<4|3)+16|0)|0;if(!w)w=0;else{c[(w+19&-16)+ -4>>2]=w;w=w+19&-16}y=c[u+8>>2]|0}if((y|0)>0){x=0;do{aa=w+(x<<4)|0;$=(c[u+16>>2]|0)+(x<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];x=x+1|0}while((x|0)!=(y|0))}x=c[u+16>>2]|0;if(x){if(a[u+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[x+ -4>>2]|0)}c[u+16>>2]=0}a[u+20>>0]=1;c[u+16>>2]=w;c[u+12>>2]=t;w=u+16|0}else w=u+16|0;do{aa=(c[w>>2]|0)+(v<<4)|0;c[aa+0>>2]=c[h+96>>2];c[aa+4>>2]=c[h+100>>2];c[aa+8>>2]=c[h+104>>2];c[aa+12>>2]=c[h+108>>2];v=v+1|0}while((v|0)!=(t|0))}c[u+8>>2]=t;if((t|0)>0){v=c[h+208>>2]|0;u=0;do{aa=(c[(c[d+52>>2]|0)+16>>2]|0)+(u<<4)|0;$=v+(u<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];u=u+1|0}while((u|0)!=(t|0))}if((s|0)>0){t=0;do{u=(c[h+228>>2]|0)+((c[(c[h+248>>2]|0)+(t<<2)>>2]|0)*12|0)|0;x=p+(t*36|0)+4|0;v=p+(t*36|0)+8|0;w=p+(t*36|0)+12|0;y=p+(t*36|0)+16|0;p=u;D=0;do{C=p+4|0;E=c[p+((c[C>>2]|0)*12|0)+8>>2]|0;H=c[x>>2]|0;if((H|0)==(c[v>>2]|0)?(r=(H|0)==0?1:H<<1,(H|0)<(r|0)):0){if(!r)F=0;else{c[5004]=(c[5004]|0)+1;F=fF((r<<2|3)+16|0)|0;if(!F)F=0;else{c[(F+19&-16)+ -4>>2]=F;F=F+19&-16}H=c[x>>2]|0}if((H|0)>0){G=0;do{I=F+(G<<2)|0;if(I)c[I>>2]=c[(c[w>>2]|0)+(G<<2)>>2];G=G+1|0}while((G|0)!=(H|0))}G=c[w>>2]|0;if(G){if(a[y>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[G+ -4>>2]|0)}c[w>>2]=0}a[y>>0]=1;c[w>>2]=F;c[v>>2]=r;H=c[x>>2]|0}F=(c[w>>2]|0)+(H<<2)|0;if(F){c[F>>2]=E;H=c[x>>2]|0}c[x>>2]=H+1;$=c[p+8>>2]|0;aa=c[h+208>>2]|0;z=+g[aa+($<<4)>>2]- +g[aa+(E<<4)>>2];A=+g[aa+($<<4)+4>>2]- +g[aa+(E<<4)+4>>2];R=+g[aa+($<<4)+8>>2]- +g[aa+(E<<4)+8>>2];B=1.0/+Q(+(z*z+A*A+R*R));if((D|0)<2){g[h+288+(D<<4)>>2]=z*B;g[h+288+(D<<4)+4>>2]=A*B;g[h+288+(D<<4)+8>>2]=R*B;g[h+288+(D<<4)+12>>2]=0.0;D=D+1|0}aa=c[C>>2]|0;p=p+(((c[p+(aa*12|0)>>2]|0)+aa|0)*12|0)|0}while((p|0)!=(u|0));w=m+(t<<4)|0;if((D|0)==2){X=+g[h+292>>2];Y=+g[h+312>>2];Z=+g[h+296>>2];ba=+g[h+308>>2];W=+g[h+304>>2];V=+g[h+288>>2];$=m+(t<<4)+4|0;aa=m+(t<<4)+8|0;g[m+(t<<4)+12>>2]=0.0;ca=1.0/+Q(+((X*Y-Z*ba)*(X*Y-Z*ba)+(Z*W-Y*V)*(Z*W-Y*V)+(ba*V-X*W)*(ba*V-X*W)));g[w>>2]=(X*Y-Z*ba)*ca;g[$>>2]=(Z*W-Y*V)*ca;g[aa>>2]=(ba*V-X*W)*ca;p=c[f>>2]|0;g[p+(t*36|0)+20>>2]=(X*Y-Z*ba)*ca;g[p+(t*36|0)+24>>2]=+g[$>>2];g[p+(t*36|0)+28>>2]=+g[aa>>2];g[p+(t*36|0)+32>>2]=1.0000000150474662e+30}else{c[w+0>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;c[w+12>>2]=0;p=c[f>>2]|0}u=c[p+(t*36|0)+4>>2]|0;if((u|0)>0){v=c[(c[d+52>>2]|0)+16>>2]|0;B=+g[w>>2];z=+g[m+(t<<4)+4>>2];A=+g[m+(t<<4)+8>>2];x=c[p+(t*36|0)+12>>2]|0;R=1.0000000150474662e+30;w=0;do{aa=c[x+(w<<2)>>2]|0;ca=+g[v+(aa<<4)>>2]*B+ +g[v+(aa<<4)+4>>2]*z+ +g[v+(aa<<4)+8>>2]*A;R=R>ca?ca:R;w=w+1|0}while((w|0)<(u|0))}else R=1.0000000150474662e+30;g[p+(t*36|0)+32>>2]=-R;t=t+1|0}while((t|0)<(s|0));s=c[l>>2]|0;if((s|0)>0){t=0;r=0;w=0;do{if((w|0)==(t|0)){t=(w|0)==0?1:w<<1;if((w|0)<(t|0)){if((t|0)!=0?(c[5004]=(c[5004]|0)+1,q=fF((t<<2|3)+16|0)|0,(q|0)!=0):0){c[(q+19&-16)+ -4>>2]=q;u=q+19&-16}else u=0;if((w|0)>0){x=0;do{v=u+(x<<2)|0;if(v)c[v>>2]=c[r+(x<<2)>>2];x=x+1|0}while((x|0)!=(w|0))}if(!r)r=u;else{c[5006]=(c[5006]|0)+1;gF(c[r+ -4>>2]|0);r=u}}else t=w}u=r+(w<<2)|0;if(u){c[u>>2]=w;s=c[l>>2]|0}w=w+1|0}while((w|0)<(s|0));if(!w)o=r;else{q=h+88|0;u=h+84|0;t=h+76|0;s=h+32|0;v=h+308|0;B=0.0;A=0.0;z=0.0;while(1){C=w+ -1|0;w=c[r+(C<<2)>>2]|0;c[5004]=(c[5004]|0)+1;y=fF(23)|0;if(y){c[(y+19&-16)+ -4>>2]=y;x=y+19&-16;if(y+19&-16)c[x>>2]=w}else x=0;S=+g[p+(w*36|0)+20>>2];R=+g[p+(w*36|0)+24>>2];T=+g[p+(w*36|0)+28>>2];w=C;F=1;y=1;D=C;c:while(1){C=(w|0)>0;d:while(1){do{aa=D;D=D+ -1|0;if((aa|0)<=0)break c;E=c[r+(D<<2)>>2]|0}while(!(S*+g[p+(E*36|0)+20>>2]+R*+g[p+(E*36|0)+24>>2]+T*+g[p+(E*36|0)+28>>2]>.9990000128746033));do if((y|0)==(F|0)?(o=(F|0)==0?1:F<<1,(F|0)<(o|0)):0){do if(!o)G=0;else{c[5004]=(c[5004]|0)+1;G=fF((o<<2|3)+16|0)|0;if(!G){G=0;break}c[(G+19&-16)+ -4>>2]=G;G=G+19&-16}while(0);if((F|0)>0){H=0;do{I=G+(H<<2)|0;if(I)c[I>>2]=c[x+(H<<2)>>2];H=H+1|0}while((H|0)!=(F|0))}if(!x){F=o;x=G;break}c[5006]=(c[5006]|0)+1;gF(c[x+ -4>>2]|0);F=o;x=G}while(0);G=x+(y<<2)|0;if(G)c[G>>2]=E;y=y+1|0;if(C)I=0;else continue;while(1){H=r+(I<<2)|0;G=I+1|0;if((c[H>>2]|0)==(E|0))break;if((G|0)<(w|0))I=G;else continue d}if((I|0)<(w|0))break}aa=w+ -1|0;$=r+(aa<<2)|0;c[H>>2]=c[$>>2];c[$>>2]=E;w=aa}if((y|0)>1){a[q>>0]=1;c[u>>2]=0;c[t>>2]=0;c[h+80>>2]=0;G=0;B=0.0;A=0.0;z=0.0;C=0;do{E=c[x+(C<<2)>>2]|0;B=+g[p+(E*36|0)+20>>2]+B;A=+g[p+(E*36|0)+24>>2]+A;z=+g[p+(E*36|0)+28>>2]+z;D=p+(E*36|0)+4|0;H=c[D>>2]|0;if((H|0)>0){E=p+(E*36|0)+12|0;J=G;F=0;while(1){G=c[(c[E>>2]|0)+(F<<2)>>2]|0;aa=(c[(c[d+52>>2]|0)+16>>2]|0)+(G<<4)|0;c[h+56>>2]=c[aa+0>>2];c[h+60>>2]=c[aa+4>>2];c[h+64>>2]=c[aa+8>>2];c[h+68>>2]=c[aa+12>>2];e:do if((J|0)>0){I=c[u>>2]|0;K=0;while(1){if((c[I+(K*24|0)+20>>2]|0)==(G|0)){G=J;break e}K=K+1|0;if((K|0)>=(J|0)){n=207;break}}}else n=207;while(0);if((n|0)==207){n=0;c[h+0>>2]=c[h+56>>2];c[h+4>>2]=c[h+60>>2];c[h+8>>2]=c[h+64>>2];c[h+12>>2]=c[h+68>>2];do if((J|0)==(c[h+80>>2]|0)){H=(J|0)==0?1:J<<1;if((J|0)>=(H|0))break;if(!H)I=0;else{c[5004]=(c[5004]|0)+1;I=fF((H*24|3)+16|0)|0;if(!I)I=0;else{c[(I+19&-16)+ -4>>2]=I;I=I+19&-16}J=c[t>>2]|0}K=c[u>>2]|0;if((J|0)<=0){if(K)n=216}else{n=0;do{aa=I+(n*24|0)|0;$=K+(n*24|0)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];c[aa+16>>2]=c[$+16>>2];c[aa+20>>2]=c[$+20>>2];n=n+1|0}while((n|0)!=(J|0));n=216}if((n|0)==216){n=0;if(!((a[q>>0]|0)==0|(K|0)==0)){c[5006]=(c[5006]|0)+1;gF(c[K+ -4>>2]|0);J=c[t>>2]|0}c[u>>2]=0}a[q>>0]=1;c[u>>2]=I;c[h+80>>2]=H}while(0);H=c[u>>2]|0;aa=H+(J*24|0)|0;c[aa+0>>2]=c[h+0>>2];c[aa+4>>2]=c[h+4>>2];c[aa+8>>2]=c[h+8>>2];c[aa+12>>2]=c[h+12>>2];c[aa+16>>2]=c[h+16>>2];c[H+(J*24|0)+20>>2]=G;G=(c[t>>2]|0)+1|0;c[t>>2]=G;H=c[D>>2]|0}F=F+1|0;if((F|0)>=(H|0))break;else J=G}}C=C+1|0}while((C|0)<(y|0));a[h+36>>0]=1;c[s>>2]=0;c[h+24>>2]=0;c[h+28>>2]=0;aa=p+((c[x>>2]|0)*9<<2)+20|0;c[h+40>>2]=c[aa+0>>2];c[h+44>>2]=c[aa+4>>2];c[h+48>>2]=c[aa+8>>2];c[h+52>>2]=c[aa+12>>2];ca=1.0/+Q(+(B*B+A*A+z*z));B=B*ca;A=A*ca;z=z*ca;if(+P(+z)>.7071067690849304){S=1.0/+Q(+(z*z+A*A));T=0.0;R=-(z*S);S=A*S}else{R=1.0/+Q(+(B*B+A*A));T=-(A*R);R=B*R;S=0.0}f:do if((G|0)<2)if((G|0)>0){D=0;J=0;C=0;n=1;while(1){E=c[u>>2]|0;do if((D|0)==(J|0)){F=(J|0)==0?1:J<<1;if((J|0)>=(F|0)){I=J;F=J;break}do if(!F)H=0;else{c[5004]=(c[5004]|0)+1;G=fF((F*24|3)+16|0)|0;if(!G){H=0;J=D;break}c[(G+19&-16)+ -4>>2]=G;H=G+19&-16;J=D}while(0);if((J|0)>0){G=0;do{aa=H+(G*24|0)|0;$=C+(G*24|0)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];c[aa+16>>2]=c[$+16>>2];c[aa+20>>2]=c[$+20>>2];G=G+1|0}while((G|0)!=(J|0))}if(C){c[5006]=(c[5006]|0)+1;gF(c[C+ -4>>2]|0)}I=D;G=c[t>>2]|0;C=H}else{I=D;F=J}while(0);aa=C+(I*24|0)|0;c[aa+0>>2]=c[E+0>>2];c[aa+4>>2]=c[E+4>>2];c[aa+8>>2]=c[E+8>>2];c[aa+12>>2]=c[E+12>>2];c[aa+16>>2]=c[E+16>>2];c[aa+20>>2]=c[E+20>>2];D=D+1|0;if((n|0)>=(G|0)){n=272;break f}J=F;n=n+1|0}}else{C=0;n=307}else{n=c[u>>2]|0;C=G;D=0;do{if(T*+g[n+(D*24|0)>>2]+R*+g[n+(D*24|0)+4>>2]+S*+g[n+(D*24|0)+8>>2]<T*+g[n>>2]+R*+g[n+4>>2]+S*+g[n+8>>2]){c[h+288>>2]=c[n+0>>2];c[h+292>>2]=c[n+4>>2];c[h+296>>2]=c[n+8>>2];c[h+300>>2]=c[n+12>>2];c[h+304>>2]=c[n+16>>2];c[h+308>>2]=c[n+20>>2];C=n+(D*24|0)|0;c[n+0>>2]=c[C+0>>2];c[n+4>>2]=c[C+4>>2];c[n+8>>2]=c[C+8>>2];c[n+12>>2]=c[C+12>>2];c[n+16>>2]=c[C+16>>2];c[n+20>>2]=c[C+20>>2];C=n+(D*24|0)|0;c[C+0>>2]=c[h+288>>2];c[C+4>>2]=c[h+292>>2];c[C+8>>2]=c[h+296>>2];c[C+12>>2]=c[h+300>>2];c[C+16>>2]=c[h+304>>2];c[C+20>>2]=c[h+308>>2];C=G}D=D+1|0}while((D|0)<(C|0));g[n+16>>2]=-1.0000000150474662e+30;if((C|0)>1){U=+g[n+4>>2];D=1;do{Z=+g[n+(D*24|0)>>2]- +g[n>>2];ba=+g[n+(D*24|0)+4>>2]-U;ca=+g[n+(D*24|0)+8>>2]- +g[n+8>>2];g[n+(D*24|0)+16>>2]=((T*ba-R*Z)*z+(B*(R*ca-S*ba)+A*(S*Z-T*ca)))/+Q(+(Z*Z+ba*ba+ca*ca));D=D+1|0}while((D|0)<(C|0))}c[h+272>>2]=c[n+0>>2];c[h+276>>2]=c[n+4>>2];c[h+280>>2]=c[n+8>>2];c[h+284>>2]=c[n+12>>2];JA(h+72|0,h+272|0,1,C+ -1|0);C=c[u>>2]|0;c[5004]=(c[5004]|0)+1;n=fF(43)|0;if(!n)n=0;else{c[(n+19&-16)+ -4>>2]=n;n=n+19&-16}D=c[u>>2]|0;c[n+0>>2]=c[C+0>>2];c[n+4>>2]=c[C+4>>2];c[n+8>>2]=c[C+8>>2];c[n+12>>2]=c[C+12>>2];c[n+16>>2]=c[C+16>>2];c[n+20>>2]=c[C+20>>2];c[5004]=(c[5004]|0)+1;C=fF(67)|0;if(!C)C=0;else{c[(C+19&-16)+ -4>>2]=C;C=C+19&-16}E=0;while(1){aa=C+(E*24|0)|0;$=n+(E*24|0)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];c[aa+16>>2]=c[$+16>>2];c[aa+20>>2]=c[$+20>>2];if(!E)break;else E=E+1|0}if(n){c[5006]=(c[5006]|0)+1;gF(c[n+ -4>>2]|0)}G=C+24|0;c[G+0>>2]=c[D+24>>2];c[G+4>>2]=c[D+28>>2];c[G+8>>2]=c[D+32>>2];c[G+12>>2]=c[D+36>>2];c[G+16>>2]=c[D+40>>2];c[G+20>>2]=c[D+44>>2];G=c[t>>2]|0;if((G|0)==2){D=2;n=273;break}else{H=2;D=2;F=2;n=2}while(1){g:do if((H|0)>1){aa=c[u>>2]|0;E=aa+(n*24|0)|0;R=+g[E>>2];S=+g[aa+(n*24|0)+4>>2];T=+g[aa+(n*24|0)+8>>2];while(1){aa=H+ -2|0;I=H+ -1|0;Z=+g[C+(aa*24|0)>>2];ba=Z- +g[C+(I*24|0)>>2];X=+g[C+(aa*24|0)+4>>2];W=X- +g[C+(I*24|0)+4>>2];ca=+g[C+(aa*24|0)+8>>2];Y=ca- +g[C+(I*24|0)+8>>2];if((ba*(X-S)-W*(Z-R))*z+(B*(W*(ca-T)-Y*(X-S))+A*(Y*(Z-R)-ba*(ca-T)))>0.0)break;if((I|0)>1){H=I;D=I}else{H=I;D=I;break g}}do if((H|0)==(F|0)){I=(F|0)==0?1:F<<1;if((F|0)>=(I|0)){H=F;break}do if(!I)J=0;else{c[5004]=(c[5004]|0)+1;F=fF((I*24|3)+16|0)|0;if(!F){J=0;F=D;break}c[(F+19&-16)+ -4>>2]=F;J=F+19&-16;F=D}while(0);if((F|0)>0){G=0;do{aa=J+(G*24|0)|0;$=C+(G*24|0)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];c[aa+16>>2]=c[$+16>>2];c[aa+20>>2]=c[$+20>>2];G=G+1|0}while((G|0)!=(F|0))}if(C){c[5006]=(c[5006]|0)+1;gF(c[C+ -4>>2]|0)}G=c[t>>2]|0;H=D;F=I;C=J}while(0);H=C+(H*24|0)|0;c[H+0>>2]=c[E+0>>2];c[H+4>>2]=c[E+4>>2];c[H+8>>2]=c[E+8>>2];c[H+12>>2]=c[E+12>>2];c[H+16>>2]=c[E+16>>2];c[H+20>>2]=c[E+20>>2];D=D+1|0;H=D}while(0);n=n+1|0;if((n|0)==(G|0)){n=272;break}}}while(0);if((n|0)==272)if((D|0)>0)n=273;else n=295;if((n|0)==273){H=0;G=0;F=0;n=0;do{E=C+(n*24|0)+20|0;do if((H|0)==(G|0)){I=(G|0)==0?1:G<<1;if((G|0)>=(I|0)){H=G;break}do if(!I)H=0;else{c[5004]=(c[5004]|0)+1;H=fF((I<<2|3)+16|0)|0;if(!H){H=0;break}c[(H+19&-16)+ -4>>2]=H;H=H+19&-16}while(0);if((G|0)>0){J=0;do{K=H+(J<<2)|0;if(K)c[K>>2]=c[F+(J<<2)>>2];J=J+1|0}while((J|0)!=(G|0))}if(F){c[5006]=(c[5006]|0)+1;gF(c[F+ -4>>2]|0);c[s>>2]=0}a[h+36>>0]=1;c[s>>2]=H;c[h+28>>2]=I;F=H;H=G;G=I}while(0);I=F+(H<<2)|0;if(I){c[I>>2]=c[E>>2];H=c[h+24>>2]|0}H=H+1|0;c[h+24>>2]=H;J=c[t>>2]|0;h:do if((J|0)>0){I=c[u>>2]|0;E=c[E>>2]|0;K=0;while(1){L=I+(K*24|0)+20|0;K=K+1|0;if((c[L>>2]|0)==(E|0))break;if((K|0)>=(J|0))break h}c[L>>2]=-1}while(0);n=n+1|0}while((n|0)<(D|0));G=c[t>>2]|0;n=295}i:do if((n|0)==295){n=0;if((G|0)>0){H=c[u>>2]|0;I=c[l>>2]|0;F=0;while(1){E=c[H+(F*24|0)+20>>2]|0;if(!((E|0)==-1|(I|0)<1)){D=0;do{J=0;while(1){if((c[x+(J<<2)>>2]|0)==(D|0))break;J=J+1|0;if((J|0)>=(y|0)){n=303;break}}do if((n|0)==303){n=0;J=c[p+(D*36|0)+4>>2]|0;if((J|0)<=0)break;K=c[p+(D*36|0)+12>>2]|0;L=0;do{if((c[K+(L<<2)>>2]|0)==(E|0)){D=1;break i}L=L+1|0}while((L|0)<(J|0))}while(0);D=D+1|0}while((D|0)<(I|0))}F=F+1|0;if((F|0)>=(G|0)){n=307;break}}}else n=307}while(0);if((n|0)==307){n=0;D=c[d+52>>2]|0;E=c[D+28>>2]|0;if((E|0)==(c[D+32>>2]|0)){GA(D+24|0,(E|0)==0?1:E<<1);E=c[D+28>>2]|0}F=(c[D+36>>2]|0)+(E*36|0)|0;if(F){IA(F,h+20|0);c[F+20>>2]=c[h+40>>2];c[F+24>>2]=c[h+44>>2];c[F+28>>2]=c[h+48>>2];c[F+32>>2]=c[h+52>>2];E=c[D+28>>2]|0}c[D+28>>2]=E+1;D=0}if(C){c[5006]=(c[5006]|0)+1;gF(c[C+ -4>>2]|0)}C=c[s>>2]|0;if(C){if(a[h+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[C+ -4>>2]|0)}c[s>>2]=0}C=c[u>>2]|0;if(C){if(a[q>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[C+ -4>>2]|0)}c[u>>2]=0}a[q>>0]=1;c[u>>2]=0;c[t>>2]=0;c[h+80>>2]=0;if(D&(y|0)>0)n=324}else if((y|0)>0)n=324;if((n|0)==324){n=0;C=0;do{D=c[x+(C<<2)>>2]|0;IA(h+288|0,p+(D*36|0)|0);D=p+(D*36|0)+20|0;c[v+0>>2]=c[D+0>>2];c[v+4>>2]=c[D+4>>2];c[v+8>>2]=c[D+8>>2];c[v+12>>2]=c[D+12>>2];D=c[d+52>>2]|0;E=c[D+28>>2]|0;if((E|0)==(c[D+32>>2]|0)){GA(D+24|0,(E|0)==0?1:E<<1);E=c[D+28>>2]|0}F=(c[D+36>>2]|0)+(E*36|0)|0;if(F){IA(F,h+288|0);c[F+20>>2]=c[v+0>>2];c[F+24>>2]=c[v+4>>2];c[F+28>>2]=c[v+8>>2];c[F+32>>2]=c[v+12>>2];E=c[D+28>>2]|0}c[D+28>>2]=E+1;D=c[h+300>>2]|0;if(D){if(a[h+304>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[D+ -4>>2]|0)}c[h+300>>2]=0}C=C+1|0}while((C|0)<(y|0))}if(x){c[5006]=(c[5006]|0)+1;gF(c[x+ -4>>2]|0)}if(!w){o=r;break}}}}else o=0}else o=0;d=c[d+52>>2]|0;c[d+64>>2]=0;c[d+68>>2]=0;c[d+72>>2]=0;c[d+76>>2]=0;r=c[d+28>>2]|0;if((r|0)>0){s=r;w=0;u=0;G=0;L=0;H=0;K=0;J=0;I=0;F=0;y=0;E=0;x=0;q=0;while(1){C=c[d+36>>2]|0;r=c[C+(q*36|0)+4>>2]|0;if((r|0)>0){t=q&65535;s=q|-65536;D=0;while(1){v=D+1|0;M=c[C+(q*36|0)+12>>2]|0;O=c[M+(D<<2)>>2]&65535;M=c[M+(((v|0)==(r|0)?0:v)<<2)>>2]&65535;D=O<<16>>16<M<<16>>16?O:M;C=O<<16>>16<M<<16>>16?M:O;_=O<<16>>16<M<<16>>16?O:M;O=O<<16>>16<M<<16>>16?M:O;M=G+ -1|0;j:do if((((_&65535)<<16)+(O<<16>>16)&M)>>>0<w>>>0?(k=c[F+((((_&65535)<<16)+(O<<16>>16)&M)<<2)>>2]|0,(k|0)!=-1):0){N=k;while(1){if(O<<16>>16==(b[J+(N<<2)>>1]|0)?_<<16>>16==(b[J+(N<<2)+2>>1]|0):0)break;N=c[x+(N<<2)>>2]|0;if((N|0)==-1){N=0;break j}}if((N|0)!=-1)N=L+(N<<2)|0;else N=0}else N=0;while(0);aa=c[d+16>>2]|0;A=+g[aa+(_<<16>>16<<4)>>2]- +g[aa+(O<<16>>16<<4)>>2];z=+g[aa+(_<<16>>16<<4)+4>>2]- +g[aa+(O<<16>>16<<4)+4>>2];B=+g[aa+(_<<16>>16<<4)+8>>2]- +g[aa+(O<<16>>16<<4)+8>>2];R=1.0/+Q(+(A*A+z*z+B*B));_=c[d+48>>2]|0;k:do if((_|0)>0){O=c[d+56>>2]|0;$=0;while(1){S=+g[O+($<<4)>>2];T=+g[O+($<<4)+8>>2];do if(!(+P(+(S-A*R))>1.0e-6)){if(+P(+(+g[O+($<<4)+4>>2]-z*R))>1.0e-6)break;if(!(+P(+(T-B*R))>1.0e-6))break k}while(0);do if(!(+P(+(A*R+S))>1.0e-6)){if(+P(+(z*R+ +g[O+($<<4)+4>>2]))>1.0e-6)break;if(!(+P(+(B*R+T))>1.0e-6))break k}while(0);$=$+1|0;if(($|0)>=(_|0)){n=359;break}}}else n=359;while(0);if((n|0)==359){n=0;do if((_|0)==(c[d+52>>2]|0)){O=(_|0)==0?1:_<<1;if((_|0)>=(O|0))break;if(!O)$=0;else{c[5004]=(c[5004]|0)+1;_=fF((O<<4|3)+16|0)|0;if(!_)$=0;else{c[(_+19&-16)+ -4>>2]=_;$=_+19&-16}_=c[d+48>>2]|0}if((_|0)>0){aa=0;do{da=$+(aa<<4)|0;ea=(c[d+56>>2]|0)+(aa<<4)|0;c[da+0>>2]=c[ea+0>>2];c[da+4>>2]=c[ea+4>>2];c[da+8>>2]=c[ea+8>>2];c[da+12>>2]=c[ea+12>>2];aa=aa+1|0}while((aa|0)!=(_|0))}_=c[d+56>>2]|0;if(_){if(a[d+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[_+ -4>>2]|0)}c[d+56>>2]=0}a[d+60>>0]=1;c[d+56>>2]=$;c[d+52>>2]=O;_=c[d+48>>2]|0}while(0);ea=c[d+56>>2]|0;g[ea+(_<<4)>>2]=A*R;g[ea+(_<<4)+4>>2]=z*R;g[ea+(_<<4)+8>>2]=B*R;g[ea+(_<<4)+12>>2]=0.0;c[d+48>>2]=(c[d+48>>2]|0)+1}l:do if(!N){O=((D&65535)<<16)+(C<<16>>16)&M;m:do if(O>>>0<w>>>0){M=c[F+(O<<2)>>2]|0;if((M|0)==-1)break;while(1){if(C<<16>>16==(b[J+(M<<2)>>1]|0)?D<<16>>16==(b[J+(M<<2)+2>>1]|0):0)break;M=c[x+(M<<2)>>2]|0;if((M|0)==-1)break m}if((M|0)==-1)break;ea=L+(M<<2)|0;b[ea>>1]=s;b[ea+2>>1]=s>>>16;break l}while(0);do if((u|0)==(G|0)){M=(G|0)==0?1:G<<1;if((G|0)>=(M|0)){_=G;M=G;break}do if(!M)N=0;else{c[5004]=(c[5004]|0)+1;N=fF((M<<2|3)+16|0)|0;if(!N){N=0;break}c[(N+19&-16)+ -4>>2]=N;N=N+19&-16}while(0);if((G|0)>0){_=0;do{$=N+(_<<2)|0;if($){ea=L+(_<<2)|0;ea=e[ea>>1]|e[ea+2>>1]<<16;b[$>>1]=ea;b[$+2>>1]=ea>>>16}_=_+1|0}while((_|0)!=(G|0))}if(!L){_=G;L=N;break}c[5006]=(c[5006]|0)+1;gF(c[L+ -4>>2]|0);_=G;L=N}else{_=u;M=G}while(0);N=L+(_<<2)|0;if(N){b[N>>1]=s;b[N+2>>1]=s>>>16;_=u}N=_+1|0;do if((H|0)==(K|0)){K=(H|0)==0?1:H<<1;if((H|0)>=(K|0)){K=H;break}do if(!K)_=0;else{c[5004]=(c[5004]|0)+1;_=fF((K<<2|3)+16|0)|0;if(!_){_=0;break}c[(_+19&-16)+ -4>>2]=_;_=_+19&-16}while(0);if((H|0)>0){aa=0;do{$=_+(aa<<2)|0;if($){ea=J+(aa<<2)|0;ea=e[ea>>1]|e[ea+2>>1]<<16;b[$>>1]=ea;b[$+2>>1]=ea>>>16}aa=aa+1|0}while((aa|0)!=(H|0))}if(!J){J=_;break}c[5006]=(c[5006]|0)+1;gF(c[J+ -4>>2]|0);J=_}while(0);_=J+(H<<2)|0;if(_){b[_>>1]=(D&65535)<<16|C&65535;b[_+2>>1]=((D&65535)<<16|C&65535)>>>16}H=H+1|0;if((G|0)<(M|0)){do if((w|0)<(M|0)){if((w|0)<=(M|0)){do if((I|0)<(M|0)){do if(!M)G=0;else{c[5004]=(c[5004]|0)+1;G=fF((M<<2|3)+16|0)|0;if(!G){G=0;break}c[(G+19&-16)+ -4>>2]=G;G=G+19&-16}while(0);if((w|0)>0){I=0;do{O=G+(I<<2)|0;if(O)c[O>>2]=c[F+(I<<2)>>2];I=I+1|0}while((I|0)!=(w|0))}if(!F){I=M;F=G;break}c[5006]=(c[5006]|0)+1;gF(c[F+ -4>>2]|0);I=M;F=G}while(0);O=w;do{G=F+(O<<2)|0;if(G)c[G>>2]=0;O=O+1|0}while((O|0)!=(M|0))}if((y|0)<(M|0)){do if((E|0)<(M|0)){do if(!M)G=0;else{c[5004]=(c[5004]|0)+1;E=fF((M<<2|3)+16|0)|0;if(!E){G=0;break}c[(E+19&-16)+ -4>>2]=E;G=E+19&-16}while(0);if((y|0)>0){E=0;do{O=G+(E<<2)|0;if(O)c[O>>2]=c[x+(E<<2)>>2];E=E+1|0}while((E|0)!=(y|0))}if(!x){E=M;x=G;break}c[5006]=(c[5006]|0)+1;gF(c[x+ -4>>2]|0);E=M;x=G}while(0);do{G=x+(y<<2)|0;if(G)c[G>>2]=0;y=y+1|0}while((y|0)!=(M|0))}if((M|0)>0){ea=M<<2;jF(F|0,-1,ea|0)|0;jF(x|0,-1,ea|0)|0}if((w|0)<=0){w=M;y=M;break}G=M+ -1|0;y=0;do{ea=F+(((e[J+(y<<2)+2>>1]<<16)+(b[J+(y<<2)>>1]|0)&G)<<2)|0;c[x+(y<<2)>>2]=c[ea>>2];c[ea>>2]=y;y=y+1|0}while((y|0)!=(w|0));w=M;y=M}while(0);O=((D&65535)<<16)+(C<<16>>16)&M+ -1}G=F+(O<<2)|0;c[x+(u<<2)>>2]=c[G>>2];c[G>>2]=u;u=N;G=M}else b[N+2>>1]=t;while(0);if((v|0)>=(r|0))break;C=c[d+36>>2]|0;D=v}r=c[d+28>>2]|0}else r=s;q=q+1|0;if((q|0)>=(r|0))break;else s=r}if((r|0)>0){n=c[d+36>>2]|0;q=c[d+16>>2]|0;R=0.0;k=0;do{u=c[n+(k*36|0)+4>>2]|0;t=c[n+(k*36|0)+12>>2]|0;s=c[t>>2]|0;if((u+ -2|0)>=1){B=+g[d+64>>2];A=+g[d+68>>2];z=+g[d+72>>2];v=1;do{da=c[t+(v<<2)>>2]|0;v=v+1|0;ea=c[t+(((v|0)%(u|0)|0)<<2)>>2]|0;S=+g[q+(s<<4)>>2];T=+g[q+(da<<4)>>2];V=+g[q+(s<<4)+4>>2];W=+g[q+(da<<4)+4>>2];Y=+g[q+(s<<4)+8>>2];Z=+g[q+(da<<4)+8>>2];U=+g[q+(ea<<4)>>2];X=+g[q+(ea<<4)+4>>2];ba=+g[q+(ea<<4)+8>>2];ca=+Q(+(((S-T)*(V-X)-(V-W)*(S-U))*((S-T)*(V-X)-(V-W)*(S-U))+(((V-W)*(Y-ba)-(Y-Z)*(V-X))*((V-W)*(Y-ba)-(Y-Z)*(V-X))+((Y-Z)*(S-U)-(S-T)*(Y-ba))*((Y-Z)*(S-U)-(S-T)*(Y-ba)))))*.5;B=B+(S+T+U)*.3333333432674408*ca;g[d+64>>2]=B;A=(V+W+X)*.3333333432674408*ca+A;g[d+68>>2]=A;z=ca*(Y+Z+ba)*.3333333432674408+z;g[d+72>>2]=z;R=R+ca}while((v|0)!=(u+ -1|0))}k=k+1|0}while((k|0)<(r|0))}else R=0.0}else{R=0.0;L=0;J=0;F=0;x=0}A=1.0/R;R=A*+g[d+64>>2];g[d+64>>2]=R;B=A*+g[d+68>>2];g[d+68>>2]=B;A=A*+g[d+72>>2];g[d+72>>2]=A;g[d+96>>2]=3.4028234663852886e+38;if((r|0)>0){n=c[d+36>>2]|0;S=3.4028234663852886e+38;k=0;while(1){z=+P(+(+g[n+(k*36|0)+32>>2]+(+g[n+(k*36|0)+20>>2]*R+ +g[n+(k*36|0)+24>>2]*B+ +g[n+(k*36|0)+28>>2]*A)));if(z<S)g[d+96>>2]=z;else z=S;k=k+1|0;if((k|0)>=(r|0))break;else S=z}}else z=3.4028234663852886e+38;k=c[d+8>>2]|0;if((k|0)>0){n=c[d+16>>2]|0;S=-3.4028234663852886e+38;T=-3.4028234663852886e+38;U=-3.4028234663852886e+38;R=3.4028234663852886e+38;B=3.4028234663852886e+38;A=3.4028234663852886e+38;q=0;do{ca=+g[n+(q<<4)>>2];R=ca<R?ca:R;S=ca>S?ca:S;ca=+g[n+(q<<4)+4>>2];B=ca<B?ca:B;T=ca>T?ca:T;ca=+g[n+(q<<4)+8>>2];A=ca<A?ca:A;U=ca>U?ca:U;q=q+1|0}while((q|0)<(k|0))}else{S=-3.4028234663852886e+38;T=-3.4028234663852886e+38;U=-3.4028234663852886e+38;R=3.4028234663852886e+38;B=3.4028234663852886e+38;A=3.4028234663852886e+38}g[d+100>>2]=S+R;g[d+104>>2]=T+B;g[d+108>>2]=A+U;g[d+112>>2]=0.0;R=S-R;B=T-B;A=U-A;g[d+116>>2]=R;g[d+120>>2]=B;g[d+124>>2]=A;g[d+128>>2]=0.0;z=z/1.7320507764816284;if(R<B)k=B<A?2:1;else k=R<A?2:0;n=d+(k<<2)+116|0;A=(+g[n>>2]*.5-z)*.0009765625;g[d+88>>2]=z;g[d+84>>2]=z;g[d+80>>2]=z;B=+g[n>>2]*.5;n=d+(k<<2)+80|0;g[n>>2]=B;q=0;while(1){if(MD(d)|0){n=470;break}B=B-A;g[n>>2]=B;q=q+1|0;if((q|0)>=1024){n=469;break}}n:do if((n|0)==469){g[d+88>>2]=z;g[d+84>>2]=z;g[d+80>>2]=z}else if((n|0)==470){z=(+g[d+96>>2]-z)*.0009765625;k=1<<k&3;R=+g[d+((1<<k&3)<<2)+80>>2];n=0;while(1){A=+g[d+(k<<2)+80>>2];g[d+(k<<2)+80>>2]=z+A;B=z+ +g[d+((1<<k&3)<<2)+80>>2];g[d+((1<<k&3)<<2)+80>>2]=B;n=n+1|0;if(!(MD(d)|0))break;if((n|0)>=1024)break n;else R=B}g[d+(k<<2)+80>>2]=A;g[d+((1<<k&3)<<2)+80>>2]=R}while(0);if(J){c[5006]=(c[5006]|0)+1;gF(c[J+ -4>>2]|0)}if(L){c[5006]=(c[5006]|0)+1;gF(c[L+ -4>>2]|0)}if(x){c[5006]=(c[5006]|0)+1;gF(c[x+ -4>>2]|0)}if(F){c[5006]=(c[5006]|0)+1;gF(c[F+ -4>>2]|0)}if(o){c[5006]=(c[5006]|0)+1;gF(c[o+ -4>>2]|0)}o=c[l>>2]|0;if((o|0)>0){q=0;do{k=p+(q*36|0)+4|0;n=p+(q*36|0)+12|0;r=c[n>>2]|0;d=p+(q*36|0)+16|0;if(r){if(a[d>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[r+ -4>>2]|0)}c[n>>2]=0}a[d>>0]=1;c[n>>2]=0;c[k>>2]=0;c[p+(q*36|0)+8>>2]=0;q=q+1|0}while((q|0)!=(o|0));p=c[f>>2]|0}if(p){if(a[h+164>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[p+ -4>>2]|0)}c[f>>2]=0}a[h+164>>0]=1;c[f>>2]=0;c[l>>2]=0;c[h+156>>2]=0;if(m){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}HA(h+196|0);if(!j){i=h;return 1}c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);i=h;return 1}function BA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0;e=i;i=i+2048|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;h=+g[d>>2];j=+g[d+4>>2];k=+g[d+8>>2];if(h*h+j*j+k*k<9999999747378752.0e-20){h=1.0;j=0.0;k=0.0}else{p=1.0/+Q(+(h*h+j*j+k*k));h=h*p;j=j*p;k=k*p}if((Pb[c[(c[b>>2]|0)+96>>2]&127](b)|0)<=0){i=e;return}d=0;l=-999999984306749400.0;do{if(((Pb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-d|0)<128){m=(Pb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-d|0;if((m|0)>0)f=7;else{p=-3.4028234663852886e+38;o=-1}}else{m=128;f=7}if((f|0)==7){f=0;n=0;do{rc[c[(c[b>>2]|0)+108>>2]&127](b,n,e+(n<<4)|0);n=n+1|0}while((n|0)!=(m|0));n=0;p=-3.4028234663852886e+38;o=-1;do{q=h*+g[e+(n<<4)>>2]+j*+g[e+(n<<4)+4>>2]+k*+g[e+(n<<4)+8>>2];r=q>p;o=r?n:o;p=r?q:p;n=n+1|0}while((n|0)!=(m|0))}if(p>l){r=e+(o<<4)|0;c[a+0>>2]=c[r+0>>2];c[a+4>>2]=c[r+4>>2];c[a+8>>2]=c[r+8>>2];c[a+12>>2]=c[r+12>>2];l=p}d=d+128|0}while((d|0)<(Pb[c[(c[b>>2]|0)+96>>2]&127](b)|0));i=e;return}function CA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0;h=i;i=i+2048|0;if((e|0)>0)j=0;else{i=h;return}do{g[d+(j<<4)+12>>2]=-999999984306749400.0;j=j+1|0}while((j|0)!=(e|0));k=0;do{if((Pb[c[(c[a>>2]|0)+96>>2]&127](a)|0)>0){o=b+(k<<4)|0;p=b+(k<<4)+4|0;j=b+(k<<4)+8|0;m=d+(k<<4)+12|0;l=d+(k<<4)|0;n=0;do{if(((Pb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-n|0)<128){q=(Pb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-n|0;if((q|0)>0)f=8;else{w=-3.4028234663852886e+38;s=-1}}else{q=128;f=8}if((f|0)==8){f=0;s=0;do{rc[c[(c[a>>2]|0)+108>>2]&127](a,s,h+(s<<4)|0);s=s+1|0}while((s|0)!=(q|0));t=+g[o>>2];r=+g[p>>2];v=+g[j>>2];u=0;w=-3.4028234663852886e+38;s=-1;do{x=t*+g[h+(u<<4)>>2]+r*+g[h+(u<<4)+4>>2]+v*+g[h+(u<<4)+8>>2];y=x>w;s=y?u:s;w=y?x:w;u=u+1|0}while((u|0)!=(q|0))}if(w>+g[m>>2]){y=h+(s<<4)|0;c[l+0>>2]=c[y+0>>2];c[l+4>>2]=c[y+4>>2];c[l+8>>2]=c[y+8>>2];c[l+12>>2]=c[y+12>>2];g[m>>2]=w}n=n+128|0}while((n|0)<(Pb[c[(c[a>>2]|0)+96>>2]&127](a)|0))}k=k+1|0}while((k|0)!=(e|0));i=h;return}function DA(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;j=+$b[c[(c[a>>2]|0)+48>>2]&15](a);g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;k=e+76|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;vc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(j+(+g[e>>2]- +g[e+16>>2])*.5)*2.0;f=(j+(+g[e+4>>2]- +g[e+20>>2])*.5)*2.0;j=(j+(+g[e+8>>2]- +g[e+24>>2])*.5)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);g[d+12>>2]=0.0;i=e;return}function EA(b){b=b|0;var d=0,e=0,f=0,h=0.0;d=i;i=i+96|0;a[b+88>>0]=1;if((a[15960]|0)==0?(Ya(15960)|0)!=0:0){g[3966]=1.0;c[3967]=0;c[3968]=0;c[3969]=0;c[3970]=0;g[3971]=1.0;c[3972]=0;c[3973]=0;c[3974]=0;c[3975]=0;g[3976]=1.0;g[3977]=0.0;g[3978]=-1.0;c[3979]=0;c[3980]=0;c[3981]=0;c[3982]=0;g[3983]=-1.0;c[3984]=0;c[3985]=0;c[3986]=0;c[3987]=0;g[3988]=-1.0;g[3989]=0.0;bb(15960)}f=d+0|0;e=f+96|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(e|0));vc[c[(c[b>>2]|0)+76>>2]&127](b,15864,d,6);h=+g[b+44>>2];g[b+72>>2]=+g[d>>2]+h;g[b+56>>2]=+g[d+48>>2]-h;g[b+76>>2]=+g[d+20>>2]+h;g[b+60>>2]=+g[d+68>>2]-h;g[b+80>>2]=+g[d+40>>2]+h;g[b+64>>2]=+g[d+88>>2]-h;i=d;return}function FA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;f=i;q=+$b[c[(c[a>>2]|0)+48>>2]&15](a);w=+g[a+72>>2];v=+g[a+56>>2];t=+g[a+76>>2];s=+g[a+60>>2];p=+g[a+80>>2];o=+g[a+64>>2];G=+g[b>>2];A=+P(+G);F=+g[b+4>>2];z=+P(+F);m=+g[b+8>>2];n=+P(+m);E=+g[b+16>>2];y=+P(+E);D=+g[b+20>>2];x=+P(+D);k=+g[b+24>>2];l=+P(+k);C=+g[b+32>>2];u=+P(+C);B=+g[b+36>>2];r=+P(+B);h=+g[b+40>>2];j=+P(+h);m=(w+v)*.5*G+(t+s)*.5*F+(p+o)*.5*m+ +g[b+48>>2];k=(w+v)*.5*E+(t+s)*.5*D+(p+o)*.5*k+ +g[b+52>>2];h=(w+v)*.5*C+(t+s)*.5*B+(p+o)*.5*h+ +g[b+56>>2];n=(q+(w-v)*.5)*A+(q+(t-s)*.5)*z+(q+(p-o)*.5)*n;l=(q+(w-v)*.5)*y+(q+(t-s)*.5)*x+(q+(p-o)*.5)*l;j=(q+(w-v)*.5)*u+(q+(t-s)*.5)*r+(q+(p-o)*.5)*j;g[d>>2]=m-n;g[d+4>>2]=k-l;g[d+8>>2]=h-j;g[d+12>>2]=0.0;g[e>>2]=n+m;g[e+4>>2]=l+k;g[e+8>>2]=j+h;g[e+12>>2]=0.0;i=f;return}function GA(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;if((c[b+8>>2]|0)>=(d|0)){i=e;return}if((d|0)!=0?(c[5004]=(c[5004]|0)+1,f=fF((d*36|3)+16|0)|0,(f|0)!=0):0){c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}else f=0;j=c[b+4>>2]|0;if((j|0)>0){h=0;do{g=f+(h*36|0)|0;if(g){n=c[b+12>>2]|0;IA(g,n+(h*36|0)|0);n=n+(h*36|0)+20|0;c[g+20>>2]=c[n+0>>2];c[g+24>>2]=c[n+4>>2];c[g+28>>2]=c[n+8>>2];c[g+32>>2]=c[n+12>>2]}h=h+1|0}while((h|0)!=(j|0));n=c[b+4>>2]|0;if((n|0)>0){m=0;do{l=c[b+12>>2]|0;h=l+(m*36|0)+4|0;j=l+(m*36|0)+12|0;g=c[j>>2]|0;k=l+(m*36|0)+16|0;if(g){if(a[k>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[g+ -4>>2]|0)}c[j>>2]=0}a[k>>0]=1;c[j>>2]=0;c[h>>2]=0;c[l+(m*36|0)+8>>2]=0;m=m+1|0}while((m|0)!=(n|0));g=b+12|0}else g=b+12|0}else g=b+12|0;h=c[g>>2]|0;if(h){if(a[b+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[g>>2]=0}a[b+16>>0]=1;c[g>>2]=f;c[b+8>>2]=d;i=e;return}function HA(b){b=b|0;var d=0,e=0;d=i;e=c[b+52>>2]|0;if(e){if(a[b+56>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;e=c[b+32>>2]|0;if(e){if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;e=c[b+12>>2]|0;if(!e){a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;e=b+8|0;c[e>>2]=0;i=d;return}if(a[b+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+12>>2]=0;a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;e=b+8|0;c[e>>2]=0;i=d;return}function IA(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;f=i;a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;e=c[d+4>>2]|0;if((e|0)<=0){c[b+4>>2]=e;i=f;return}c[5004]=(c[5004]|0)+1;g=fF((e<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}j=c[b+4>>2]|0;if((j|0)>0){h=0;do{k=g+(h<<2)|0;if(k)c[k>>2]=c[(c[b+12>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(j|0))}h=c[b+12>>2]|0;if(h){if(a[b+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=g;c[b+8>>2]=e;h=0;do{j=g+(h<<2)|0;if(j)c[j>>2]=0;h=h+1|0}while((h|0)!=(e|0));c[b+4>>2]=e;b=0;do{h=g+(b<<2)|0;if(h)c[h>>2]=c[(c[d+12>>2]|0)+(b<<2)>>2];b=b+1|0}while((b|0)!=(e|0));i=f;return}function JA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0;f=i;i=i+32|0;n=c[a+12>>2]|0;h=+g[n+(((e+d|0)/2|0)*24|0)>>2];j=+g[n+(((e+d|0)/2|0)*24|0)+4>>2];k=+g[n+(((e+d|0)/2|0)*24|0)+8>>2];m=+g[n+(((e+d|0)/2|0)*24|0)+16>>2];l=c[n+(((e+d|0)/2|0)*24|0)+20>>2]|0;o=d;p=e;while(1){a:while(1){q=+g[n+(o*24|0)+16>>2];do if(q!=m){if(!(q<m))break a}else{s=+g[b>>2];v=+g[n+(o*24|0)>>2]-s;r=+g[b+4>>2];u=+g[n+(o*24|0)+4>>2]-r;q=+g[b+8>>2];t=+g[n+(o*24|0)+8>>2]-q;if(v*v+u*u+t*t!=(h-s)*(h-s)+(j-r)*(j-r)+(k-q)*(k-q))if(v*v+u*u+t*t<(h-s)*(h-s)+(j-r)*(j-r)+(k-q)*(k-q))break;else break a;else if((c[n+(o*24|0)+20>>2]|0)<(l|0))break;else break a}while(0);o=o+1|0}b:while(1){q=+g[n+(p*24|0)+16>>2];do if(m!=q){if(!(m<q))break b}else{r=+g[b>>2];t=+g[b+4>>2];q=+g[b+8>>2];s=+g[n+(p*24|0)>>2]-r;u=+g[n+(p*24|0)+4>>2]-t;v=+g[n+(p*24|0)+8>>2]-q;if((h-r)*(h-r)+(j-t)*(j-t)+(k-q)*(k-q)!=s*s+u*u+v*v)if((h-r)*(h-r)+(j-t)*(j-t)+(k-q)*(k-q)<s*s+u*u+v*v)break;else break b;else if((l|0)<(c[n+(p*24|0)+20>>2]|0))break;else break b}while(0);p=p+ -1|0}if((o|0)<=(p|0)){w=n+(o*24|0)|0;c[f+0>>2]=c[w+0>>2];c[f+4>>2]=c[w+4>>2];c[f+8>>2]=c[w+8>>2];c[f+12>>2]=c[w+12>>2];c[f+16>>2]=c[w+16>>2];c[f+20>>2]=c[w+20>>2];n=n+(p*24|0)|0;c[w+0>>2]=c[n+0>>2];c[w+4>>2]=c[n+4>>2];c[w+8>>2]=c[n+8>>2];c[w+12>>2]=c[n+12>>2];c[w+16>>2]=c[n+16>>2];c[w+20>>2]=c[n+20>>2];n=(c[a+12>>2]|0)+(p*24|0)|0;c[n+0>>2]=c[f+0>>2];c[n+4>>2]=c[f+4>>2];c[n+8>>2]=c[f+8>>2];c[n+12>>2]=c[f+12>>2];c[n+16>>2]=c[f+16>>2];c[n+20>>2]=c[f+20>>2];o=o+1|0;p=p+ -1|0}if((o|0)>(p|0))break;n=c[a+12>>2]|0}if((p|0)>(d|0))JA(a,b,d,p);if((o|0)>=(e|0)){i=f;return}JA(a,b,o,e);i=f;return}function KA(d,f,h){d=d|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0.0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0,N=0.0,O=0.0;j=i;i=i+128|0;m=c[d+56>>2]|0;if((h-f|0)==1){if(!(a[d+60>>0]|0)){E=(c[d+96>>2]|0)+(m<<6)+0|0;v=(c[d+76>>2]|0)+(f<<6)+0|0;r=E+64|0;do{c[E>>2]=c[v>>2];E=E+4|0;v=v+4|0}while((E|0)<(r|0))}else{L=(c[d+136>>2]|0)+(m<<4)|0;K=(c[d+116>>2]|0)+(f<<4)|0;c[L+0>>2]=c[K+0>>2];c[L+4>>2]=c[K+4>>2];c[L+8>>2]=c[K+8>>2];c[L+12>>2]=c[K+12>>2]}c[d+56>>2]=(c[d+56>>2]|0)+1;i=j;return}if((f|0)<(h|0)){o=(a[d+60>>0]|0)==0;t=0.0;u=0.0;A=0.0;p=f;do{if(o){L=c[d+76>>2]|0;y=+g[L+(p<<6)>>2];z=+g[L+(p<<6)+16>>2];w=+g[L+(p<<6)+4>>2];x=+g[L+(p<<6)+20>>2];B=+g[L+(p<<6)+8>>2];s=+g[L+(p<<6)+24>>2]}else{L=c[d+116>>2]|0;w=+g[d+36>>2];B=+g[d+40>>2];F=+g[d+44>>2];z=+g[d+4>>2];x=+g[d+8>>2];s=+g[d+12>>2];y=+(e[L+(p<<4)>>1]|0)/w+z;z=+(e[L+(p<<4)+6>>1]|0)/w+z;w=+(e[L+(p<<4)+2>>1]|0)/B+x;x=+(e[L+(p<<4)+8>>1]|0)/B+x;B=+(e[L+(p<<4)+4>>1]|0)/F+s;s=+(e[L+(p<<4)+10>>1]|0)/F+s}A=A+(z+y)*.5;t=t+(x+w)*.5;u=u+(s+B)*.5;p=p+1|0}while((p|0)!=(h|0));F=1.0/+(h-f|0);s=A*F;t=t*F;u=u*F;if(o){o=c[d+76>>2]|0;w=0.0;z=0.0;F=0.0;p=f;do{B=(+g[o+(p<<6)+16>>2]+ +g[o+(p<<6)>>2])*.5-s;C=(+g[o+(p<<6)+20>>2]+ +g[o+(p<<6)+4>>2])*.5-t;D=(+g[o+(p<<6)+24>>2]+ +g[o+(p<<6)+8>>2])*.5-u;w=w+B*B;z=z+C*C;F=F+D*D;p=p+1|0}while((p|0)!=(h|0));s=+(h-f|0)}else{p=c[d+116>>2]|0;y=+g[d+36>>2];B=+g[d+40>>2];D=+g[d+44>>2];A=+g[d+4>>2];C=+g[d+8>>2];x=+g[d+12>>2];w=0.0;z=0.0;F=0.0;o=f;do{O=(+(e[p+(o<<4)+6>>1]|0)/y+A+(+(e[p+(o<<4)>>1]|0)/y+A))*.5-s;N=(+(e[p+(o<<4)+8>>1]|0)/B+C+(+(e[p+(o<<4)+2>>1]|0)/B+C))*.5-t;M=(+(e[p+(o<<4)+10>>1]|0)/D+x+(+(e[p+(o<<4)+4>>1]|0)/D+x))*.5-u;w=w+O*O;z=z+N*N;F=F+M*M;o=o+1|0}while((o|0)!=(h|0));s=+(h-f|0)}}else{F=0.0;z=0.0;w=0.0;s=+(h-f|0)}u=1.0/(s+-1.0);s=w*u;t=z*u;u=F*u;if(s<t)o=t<u?2:1;else o=s<u?2:0;c[j+16>>2]=0;c[j+20>>2]=0;c[j+24>>2]=0;c[j+28>>2]=0;if((f|0)<(h|0)){q=(a[d+60>>0]|0)==0;u=0.0;t=0.0;s=0.0;p=f;do{if(q){L=c[d+76>>2]|0;z=+g[L+(p<<6)>>2];y=+g[L+(p<<6)+16>>2];w=+g[L+(p<<6)+4>>2];A=+g[L+(p<<6)+20>>2];x=+g[L+(p<<6)+8>>2];B=+g[L+(p<<6)+24>>2]}else{L=c[d+116>>2]|0;w=+g[d+36>>2];x=+g[d+40>>2];O=+g[d+44>>2];y=+g[d+4>>2];A=+g[d+8>>2];B=+g[d+12>>2];z=+(e[L+(p<<4)>>1]|0)/w+y;y=+(e[L+(p<<4)+6>>1]|0)/w+y;w=+(e[L+(p<<4)+2>>1]|0)/x+A;A=+(e[L+(p<<4)+8>>1]|0)/x+A;x=+(e[L+(p<<4)+4>>1]|0)/O+B;B=+(e[L+(p<<4)+10>>1]|0)/O+B}u=u+(y+z)*.5;t=(A+w)*.5+t;s=(B+x)*.5+s;p=p+1|0}while((p|0)!=(h|0));g[j+16>>2]=u;g[j+20>>2]=t;g[j+24>>2]=s}else{u=0.0;t=0.0;s=0.0}g[j+16>>2]=1.0/+(h-f|0)*u;g[j+20>>2]=1.0/+(h-f|0)*t;g[j+24>>2]=1.0/+(h-f|0)*s;s=+g[j+16+(o<<2)>>2];if((f|0)<(h|0)){o=j+(o<<2)|0;q=f;p=f;do{r=(a[d+60>>0]|0)==0;if(r){L=c[d+76>>2]|0;x=+g[L+(q<<6)>>2];y=+g[L+(q<<6)+16>>2];u=+g[L+(q<<6)+4>>2];w=+g[L+(q<<6)+20>>2];t=+g[L+(q<<6)+8>>2];z=+g[L+(q<<6)+24>>2]}else{L=c[d+116>>2]|0;u=+g[d+36>>2];t=+g[d+40>>2];O=+g[d+44>>2];y=+g[d+4>>2];w=+g[d+8>>2];z=+g[d+12>>2];x=+(e[L+(q<<4)>>1]|0)/u+y;y=+(e[L+(q<<4)+6>>1]|0)/u+y;u=+(e[L+(q<<4)+2>>1]|0)/t+w;w=+(e[L+(q<<4)+8>>1]|0)/t+w;t=+(e[L+(q<<4)+4>>1]|0)/O+z;z=+(e[L+(q<<4)+10>>1]|0)/O+z}g[j>>2]=(y+x)*.5;g[j+4>>2]=(w+u)*.5;g[j+8>>2]=(z+t)*.5;g[j+12>>2]=0.0;if(+g[o>>2]>s){if(r){G=c[d+76>>2]|0;H=G+(q<<6)|0;E=j+32|0;v=H+0|0;r=E+64|0;do{c[E>>2]=c[v>>2];E=E+4|0;v=v+4|0}while((E|0)<(r|0));E=H+0|0;v=G+(p<<6)+0|0;r=E+64|0;do{c[E>>2]=c[v>>2];E=E+4|0;v=v+4|0}while((E|0)<(r|0));E=(c[d+76>>2]|0)+(p<<6)+0|0;v=j+32|0;r=E+64|0;do{c[E>>2]=c[v>>2];E=E+4|0;v=v+4|0}while((E|0)<(r|0))}else{K=c[d+116>>2]|0;L=K+(q<<4)|0;c[j+96>>2]=c[L+0>>2];c[j+100>>2]=c[L+4>>2];c[j+104>>2]=c[L+8>>2];c[j+108>>2]=c[L+12>>2];K=K+(p<<4)|0;c[L+0>>2]=c[K+0>>2];c[L+4>>2]=c[K+4>>2];c[L+8>>2]=c[K+8>>2];c[L+12>>2]=c[K+12>>2];L=(c[d+116>>2]|0)+(p<<4)|0;c[L+0>>2]=c[j+96>>2];c[L+4>>2]=c[j+100>>2];c[L+8>>2]=c[j+104>>2];c[L+12>>2]=c[j+108>>2]}p=p+1|0}q=q+1|0}while((q|0)!=(h|0))}else p=f;if(!((p|0)>(((h-f|0)/3|0)+f|0)?(p|0)<(h+ -1-((h-f|0)/3|0)|0):0))p=(h-f>>1)+f|0;o=c[d+56>>2]|0;do if(!(a[d+60>>0]|0)){q=(c[d+96>>2]|0)+(o<<6)|0;c[q+0>>2]=c[d+20>>2];c[q+4>>2]=c[d+24>>2];c[q+8>>2]=c[d+28>>2];c[q+12>>2]=c[d+32>>2];q=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){q=(c[d+96>>2]|0)+(q<<6)+16|0;c[q+0>>2]=c[d+4>>2];c[q+4>>2]=c[d+8>>2];c[q+8>>2]=c[d+12>>2];c[q+12>>2]=c[d+16>>2];q=c[d+56>>2]|0;break}else{r=c[d+136>>2]|0;v=d+4|0;x=+g[d+8>>2];t=+g[d+12>>2];w=+g[d+36>>2];s=+g[d+40>>2];u=+g[d+44>>2];n=46;break}}else{r=c[d+136>>2]|0;x=+g[d+8>>2];t=+g[d+12>>2];w=+g[d+36>>2];s=+g[d+40>>2];N=(+g[d+24>>2]-x)*s;u=+g[d+44>>2];O=(+g[d+28>>2]-t)*u;b[r+(o<<4)>>1]=~~((+g[d+20>>2]- +g[d+4>>2])*w)&65534;b[r+(o<<4)+2>>1]=~~N&65534;b[r+(o<<4)+4>>1]=~~O&65534;q=o;v=d+4|0;n=46}while(0);if((n|0)==46){O=+g[v>>2];b[r+(q<<4)+6>>1]=~~((O-O)*w+1.0)&65535|1;b[r+(q<<4)+8>>1]=~~((x-x)*s+1.0)&65535|1;b[r+(q<<4)+10>>1]=~~((t-t)*u+1.0)&65535|1}if((f|0)<(h|0)){n=a[d+60>>0]|0;r=f;do{if(!(n<<24>>24)){v=c[d+76>>2]|0;A=+g[v+(r<<6)>>2];z=+g[v+(r<<6)+4>>2];y=+g[v+(r<<6)+8>>2];x=+g[v+(r<<6)+12>>2];w=+g[v+(r<<6)+16>>2];u=+g[v+(r<<6)+20>>2];t=+g[v+(r<<6)+24>>2];s=+g[v+(r<<6)+28>>2];v=c[d+96>>2]|0;E=v+(q<<6)|0;if(A<+g[E>>2])g[E>>2]=A;E=v+(q<<6)+4|0;if(z<+g[E>>2])g[E>>2]=z;E=v+(q<<6)+8|0;if(y<+g[E>>2])g[E>>2]=y;E=v+(q<<6)+12|0;if(x<+g[E>>2])g[E>>2]=x;E=v+(q<<6)+16|0;if(+g[E>>2]<w)g[E>>2]=w;E=v+(q<<6)+20|0;if(+g[E>>2]<u)g[E>>2]=u;E=v+(q<<6)+24|0;if(+g[E>>2]<t)g[E>>2]=t;v=v+(q<<6)+28|0;if(+g[v>>2]<s)g[v>>2]=s}else{v=c[d+116>>2]|0;w=+g[d+36>>2];A=+g[d+40>>2];F=+g[d+44>>2];x=+g[d+4>>2];B=+g[d+8>>2];M=+g[d+12>>2];y=+g[d+4>>2];C=+g[d+8>>2];N=+g[d+12>>2];z=+g[d+36>>2];D=+g[d+40>>2];O=+g[d+44>>2];K=~~((+(e[v+(r<<4)>>1]|0)/w+x-y)*z)&65534;I=~~((+(e[v+(r<<4)+2>>1]|0)/A+B-C)*D)&65534;G=~~((+(e[v+(r<<4)+4>>1]|0)/F+M-N)*O)&65534;J=(~~((+(e[v+(r<<4)+6>>1]|0)/w+x-y)*z+1.0)&65535|1)&65535;H=(~~((+(e[v+(r<<4)+8>>1]|0)/A+B-C)*D+1.0)&65535|1)&65535;v=(~~((+(e[v+(r<<4)+10>>1]|0)/F+M-N)*O+1.0)&65535|1)&65535;E=c[d+136>>2]|0;L=E+(q<<4)|0;if((e[L>>1]|0)>(K&65535))b[L>>1]=K;K=E+(q<<4)+6|0;if((e[K>>1]|0)<(J&65535))b[K>>1]=J;J=E+(q<<4)+2|0;if((e[J>>1]|0)>(I&65535))b[J>>1]=I;I=E+(q<<4)+8|0;if((e[I>>1]|0)<(H&65535))b[I>>1]=H;H=E+(q<<4)+4|0;if((e[H>>1]|0)>(G&65535))b[H>>1]=G;E=E+(q<<4)+10|0;if((e[E>>1]|0)<(v&65535))b[E>>1]=v}r=r+1|0}while((r|0)!=(h|0))}q=q+1|0;c[d+56>>2]=q;KA(d,f,p);f=c[d+56>>2]|0;KA(d,p,h);h=(c[d+56>>2]|0)-m|0;do if(a[d+60>>0]|0){if((h<<4|0)>2048){m=c[d+136>>2]|0;p=c[m+(q<<4)+12>>2]|0;p=(p|0)>-1?1:0-p|0;n=c[m+(f<<4)+12>>2]|0;n=(n|0)>-1?1:0-n|0;if((p<<4|0)<2049){r=c[d+152>>2]|0;if((r|0)==(c[d+156>>2]|0)?(l=(r|0)==0?1:r<<1,(r|0)<(l|0)):0){if(!l){v=0;G=r}else{c[5004]=(c[5004]|0)+1;v=fF(l<<5|19)|0;if(!v)v=0;else{c[(v+19&-16)+ -4>>2]=v;v=v+19&-16}G=c[d+152>>2]|0}if((G|0)>0){E=0;do{L=v+(E<<5)|0;K=(c[d+160>>2]|0)+(E<<5)|0;c[L+0>>2]=c[K+0>>2];c[L+4>>2]=c[K+4>>2];c[L+8>>2]=c[K+8>>2];c[L+12>>2]=c[K+12>>2];c[L+16>>2]=c[K+16>>2];c[L+20>>2]=c[K+20>>2];c[L+24>>2]=c[K+24>>2];c[L+28>>2]=c[K+28>>2];E=E+1|0}while((E|0)!=(G|0))}E=c[d+160>>2]|0;if(E){if(a[d+164>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[E+ -4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=v;c[d+156>>2]=l;l=c[d+152>>2]|0}else l=r;c[d+152>>2]=l+1;l=(c[d+160>>2]|0)+(r<<5)|0;c[l+0>>2]=c[j+96>>2];c[l+4>>2]=c[j+100>>2];c[l+8>>2]=c[j+104>>2];c[l+12>>2]=c[j+108>>2];c[l+16>>2]=c[j+112>>2];c[l+20>>2]=c[j+116>>2];c[l+24>>2]=c[j+120>>2];c[l+28>>2]=c[j+124>>2];l=c[d+160>>2]|0;b[l+(r<<5)>>1]=b[m+(q<<4)>>1]|0;b[l+(r<<5)+2>>1]=b[m+(q<<4)+2>>1]|0;b[l+(r<<5)+4>>1]=b[m+(q<<4)+4>>1]|0;b[l+(r<<5)+6>>1]=b[m+(q<<4)+6>>1]|0;b[l+(r<<5)+8>>1]=b[m+(q<<4)+8>>1]|0;b[l+(r<<5)+10>>1]=b[m+(q<<4)+10>>1]|0;c[l+(r<<5)+12>>2]=q;c[l+(r<<5)+16>>2]=p;l=d+152|0}else l=d+152|0;if((n<<4|0)<2049){p=c[l>>2]|0;if((p|0)==(c[d+156>>2]|0)?(k=(p|0)==0?1:p<<1,(p|0)<(k|0)):0){if(!k){q=0;v=p}else{c[5004]=(c[5004]|0)+1;q=fF(k<<5|19)|0;if(!q)q=0;else{c[(q+19&-16)+ -4>>2]=q;q=q+19&-16}v=c[l>>2]|0}if((v|0)>0){r=0;do{L=q+(r<<5)|0;K=(c[d+160>>2]|0)+(r<<5)|0;c[L+0>>2]=c[K+0>>2];c[L+4>>2]=c[K+4>>2];c[L+8>>2]=c[K+8>>2];c[L+12>>2]=c[K+12>>2];c[L+16>>2]=c[K+16>>2];c[L+20>>2]=c[K+20>>2];c[L+24>>2]=c[K+24>>2];c[L+28>>2]=c[K+28>>2];r=r+1|0}while((r|0)!=(v|0))}r=c[d+160>>2]|0;if(r){if(a[d+164>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[r+ -4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=q;c[d+156>>2]=k;k=c[l>>2]|0}else k=p;c[l>>2]=k+1;L=(c[d+160>>2]|0)+(p<<5)|0;c[L+0>>2]=c[j+32>>2];c[L+4>>2]=c[j+36>>2];c[L+8>>2]=c[j+40>>2];c[L+12>>2]=c[j+44>>2];c[L+16>>2]=c[j+48>>2];c[L+20>>2]=c[j+52>>2];c[L+24>>2]=c[j+56>>2];c[L+28>>2]=c[j+60>>2];L=c[d+160>>2]|0;b[L+(p<<5)>>1]=b[m+(f<<4)>>1]|0;b[L+(p<<5)+2>>1]=b[m+(f<<4)+2>>1]|0;b[L+(p<<5)+4>>1]=b[m+(f<<4)+4>>1]|0;b[L+(p<<5)+6>>1]=b[m+(f<<4)+6>>1]|0;b[L+(p<<5)+8>>1]=b[m+(f<<4)+8>>1]|0;b[L+(p<<5)+10>>1]=b[m+(f<<4)+10>>1]|0;c[L+(p<<5)+12>>2]=f;c[L+(p<<5)+16>>2]=n}c[d+168>>2]=c[l>>2];if(!(a[d+60>>0]|0))break;else d=d+136|0}else d=d+136|0;c[(c[d>>2]|0)+(o<<4)+12>>2]=0-h;i=j;return}while(0);c[(c[d+96>>2]|0)+(o<<6)+32>>2]=h;i=j;return}function LA(a){a=a|0;var b=0;b=i;MA(a);if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function MA(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=16080;e=c[b+160>>2]|0;if(e){if(a[b+164>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+160>>2]=0}a[b+164>>0]=1;c[b+160>>2]=0;c[b+152>>2]=0;c[b+156>>2]=0;e=c[b+136>>2]|0;if(e){if(a[b+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;e=c[b+116>>2]|0;if(e){if(a[b+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;e=c[b+96>>2]|0;if(e){if(a[b+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;e=c[b+76>>2]|0;if(!e){a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;e=b+72|0;c[e>>2]=0;i=d;return}if(a[b+80>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+76>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;e=b+72|0;c[e>>2]=0;i=d;return}function NA(a,b,d,f){a=a|0;b=b|0;d=d|0;f=f|0;var g=0,h=0,j=0;g=i;while(1){j=c[a+12>>2]|0;if(!(((e[f>>1]|0)>=(e[a>>1]|0)?(e[d>>1]|0)<=(e[a+6>>1]|0):0)&(e[d+4>>1]|0)<=(e[a+10>>1]|0)&(e[f+4>>1]|0)>=(e[a+4>>1]|0)&(e[d+2>>1]|0)<=(e[a+8>>1]|0)&(e[f+2>>1]|0)>=(e[a+2>>1]|0))){h=8;break}if((j|0)>-1)break;NA(a+16|0,b,d,f);j=c[a+28>>2]|0;if((j|0)>-1){a=a+32|0;continue}else{a=a+(1-j<<4)|0;continue}}if((h|0)==8){i=g;return}rc[c[(c[b>>2]|0)+8>>2]&127](b,j>>21,j&2097151);i=g;return}function OA(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=+e;f=+f;h=+h;j=j|0;k=k|0;var l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0,N=0,O=0.0,P=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0,W=0,X=0,Y=0;l=i;i=i+32|0;o=+g[d>>2];p=+g[d+4>>2];I=+g[d+8>>2];U=+g[j>>2];u=(o>e?e:o)+U;O=+g[j+4>>2];q=(p>f?f:p)+O;P=+g[j+8>>2];s=(I>h?h:I)+P;R=+g[k>>2];v=(o<e?e:o)+R;S=+g[k+4>>2];r=(p<f?f:p)+S;T=+g[k+8>>2];t=(I<h?h:I)+T;n=1.0/+Q(+((e-o)*(e-o)+(f-p)*(f-p)+(h-I)*(h-I)));if((e-o)*n==0.0)B=999999984306749400.0;else B=1.0/((e-o)*n);if((f-p)*n==0.0)A=999999984306749400.0;else A=1.0/((f-p)*n);if((h-I)*n==0.0)z=999999984306749400.0;else z=1.0/((h-I)*n);x=B<0.0&1;w=A<0.0&1;y=z<0.0&1;K=c[a+56>>2]|0;a:do if((K|0)>0){N=0;M=c[a+96>>2]|0;L=1;while(1){c[l+0>>2]=c[M+0>>2];c[l+4>>2]=c[M+4>>2];c[l+8>>2]=c[M+8>>2];c[l+12>>2]=c[M+12>>2];Y=M+16|0;c[l+16>>2]=c[Y+0>>2];c[l+20>>2]=c[Y+4>>2];c[l+24>>2]=c[Y+8>>2];c[l+28>>2]=c[Y+12>>2];g[l>>2]=+g[l>>2]-R;g[l+4>>2]=+g[l+4>>2]-S;g[l+8>>2]=+g[l+8>>2]-T;g[l+16>>2]=+g[l+16>>2]-U;g[l+20>>2]=+g[l+20>>2]-O;g[l+24>>2]=+g[l+24>>2]-P;if(!(u>+g[Y>>2])?!(v<+g[M>>2]):0)V=1;else V=0;if(!(!(s>+g[M+24>>2])?!(t<+g[M+8>>2]):0))V=0;if((((!(q>+g[M+20>>2])?!(r<+g[M+4>>2]|V^1):0)?(J=+g[d>>2],H=B*(+g[l+(x<<4)>>2]-J),J=B*(+g[l+((x^1)<<4)>>2]-J),m=+g[d+4>>2],G=A*(+g[l+(w<<4)+4>>2]-m),m=A*(+g[l+((w^1)<<4)+4>>2]-m),!(H>m|G>J)):0)?(F=G>H?G:H,D=m<J?m:J,C=+g[d+8>>2],E=z*(+g[l+(y<<4)+8>>2]-C),C=z*(+g[l+((y^1)<<4)+8>>2]-C),!(F>C|E>D)):0)?(E>F?E:F)<(h-I)*(h-I)*n+((e-o)*(e-o)*n+(f-p)*(f-p)*n):0){Y=(C<D?C:D)>0.0;W=c[M+32>>2]|0;if((W|0)==-1&Y){rc[c[(c[b>>2]|0)+8>>2]&127](b,c[M+36>>2]|0,c[M+40>>2]|0);K=c[a+56>>2]|0;V=24}else{X=(W|0)==-1;V=23}}else{W=c[M+32>>2]|0;X=(W|0)==-1;Y=0;V=23}if((V|0)==23){V=0;if(Y|X)V=24;else{N=W+N|0;M=M+(W<<6)|0}}if((V|0)==24){N=N+1|0;M=M+64|0}if((N|0)>=(K|0))break a;O=+g[j+4>>2];P=+g[j+8>>2];R=+g[k>>2];S=+g[k+4>>2];T=+g[k+8>>2];U=+g[j>>2];L=L+1|0}}else L=0;while(0);if((c[4028]|0)>=(L|0)){i=l;return}c[4028]=L;i=l;return}function PA(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=+h;j=+j;k=+k;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0.0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0;o=i;i=i+32|0;r=+g[f>>2];s=+g[f+4>>2];F=+g[f+8>>2];q=1.0/+Q(+((h-r)*(h-r)+(j-s)*(j-s)+(k-F)*(k-F)));if((h-r)*q==0.0)B=999999984306749400.0;else B=1.0/((h-r)*q);if((j-s)*q==0.0)C=999999984306749400.0;else C=1.0/((j-s)*q);if((k-F)*q==0.0)D=999999984306749400.0;else D=1.0/((k-F)*q);p=B<0.0&1;G=C<0.0&1;E=D<0.0&1;la=(r>h?h:r)+ +g[l>>2];ka=(s>j?j:s)+ +g[l+4>>2];ja=(F>k?k:F)+ +g[l+8>>2];ha=(r<h?h:r)+ +g[m>>2];da=(s<j?j:s)+ +g[m+4>>2];$=(F<k?k:F)+ +g[m+8>>2];ga=+g[a+4>>2];la=la<ga?ga:la;ca=+g[a+8>>2];ka=ka<ca?ca:ka;_=+g[a+12>>2];ja=ja<_?_:ja;ia=+g[a+20>>2];ea=+g[a+24>>2];aa=+g[a+28>>2];fa=+g[a+36>>2];ba=+g[a+40>>2];Z=+g[a+44>>2];I=~~(((ia<la?ia:la)-ga)*fa)&65534;L=~~(((ea<ka?ea:ka)-ca)*ba)&65534;J=~~(((aa<ja?aa:ja)-_)*Z)&65534;ha=ha<ga?ga:ha;da=da<ca?ca:da;$=$<_?_:$;H=(~~(((ia<ha?ia:ha)-ga)*fa+1.0)&65535|1)&65535;M=(~~(((ea<da?ea:da)-ca)*ba+1.0)&65535|1)&65535;K=(~~(((aa<$?aa:$)-_)*Z+1.0)&65535|1)&65535;if((n|0)>0){N=0;P=c[a+136>>2]|0;O=0;do{O=O+1|0;T=P+6|0;X=b[P>>1]|0;Y=P+10|0;V=b[P+4>>1]|0;U=P+8|0;W=b[P+2>>1]|0;R=P+12|0;S=(c[R>>2]|0)>-1;if(((((H&65535)>=(X&65535)?(I&65535)<=(e[T>>1]|0):0)&(J&65535)<=(e[Y>>1]|0)&(K&65535)>=(V&65535)&(L&65535)<=(e[U>>1]|0)&(M&65535)>=(W&65535)?(ha=+g[a+36>>2],ja=+g[a+40>>2],la=+g[a+44>>2],ia=+g[a+4>>2],ka=+g[a+8>>2],x=+g[a+12>>2],g[o+12>>2]=0.0,z=+(e[T>>1]|0)/ha+ia,y=+(e[U>>1]|0)/ja+ka,A=+(e[Y>>1]|0)/la+x,g[o+28>>2]=0.0,g[o>>2]=+(X&65535)/ha+ia- +g[m>>2],g[o+4>>2]=+(W&65535)/ja+ka- +g[m+4>>2],g[o+8>>2]=+(V&65535)/la+x- +g[m+8>>2],g[o+16>>2]=z- +g[l>>2],g[o+20>>2]=y- +g[l+4>>2],g[o+24>>2]=A- +g[l+8>>2],A=+g[f>>2],y=B*(+g[o+(p<<4)>>2]-A),A=B*(+g[o+((p^1)<<4)>>2]-A),z=+g[f+4>>2],x=C*(+g[o+(G<<4)+4>>2]-z),z=C*(+g[o+((G^1)<<4)+4>>2]-z),!(y>z|x>A)):0)?(w=x>y?x:y,u=z<A?z:A,t=+g[f+8>>2],v=D*(+g[o+(E<<4)+8>>2]-t),t=D*(+g[o+((E^1)<<4)+8>>2]-t),!(w>t|v>u)):0)?(v>w?v:w)<(k-F)*(k-F)*q+((h-r)*(h-r)*q+(j-s)*(j-s)*q):0){U=!((t<u?t:u)>0.0);if(U|S^1)T=15;else{T=c[R>>2]|0;rc[c[(c[d>>2]|0)+8>>2]&127](d,T>>21,T&2097151);T=16}}else{U=1;T=15}if((T|0)==15){T=0;if(S|U^1)T=16;else{Y=c[R>>2]|0;N=N-Y|0;P=P+(0-Y<<4)|0}}if((T|0)==16){N=N+1|0;P=P+16|0}}while((N|0)<(n|0))}else O=0;if((c[4028]|0)>=(O|0)){i=o;return}c[4028]=O;i=o;return}function QA(d,f,h,j){d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=i;c[d+168>>2]=c[d+152>>2];c[f>>2]=16080;c[f+52>>2]=282;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;g[f+4>>2]=-3.4028234663852886e+38;g[f+8>>2]=-3.4028234663852886e+38;g[f+12>>2]=-3.4028234663852886e+38;g[f+16>>2]=0.0;g[f+20>>2]=3.4028234663852886e+38;g[f+24>>2]=3.4028234663852886e+38;g[f+28>>2]=3.4028234663852886e+38;g[f+32>>2]=0.0;k=c[d+56>>2]|0;if(j){c[f+56>>2]=oF(k|0)|0;a[f+4>>0]=a[d+7>>0]|0;a[f+5>>0]=a[d+6>>0]|0;a[f+6>>0]=a[d+5>>0]|0;a[f+7>>0]=a[d+4>>0]|0;a[f+8>>0]=a[d+11>>0]|0;a[f+9>>0]=a[d+10>>0]|0;a[f+10>>0]=a[d+9>>0]|0;a[f+11>>0]=a[d+8>>0]|0;a[f+12>>0]=a[d+15>>0]|0;a[f+13>>0]=a[d+14>>0]|0;a[f+14>>0]=a[d+13>>0]|0;a[f+15>>0]=a[d+12>>0]|0;a[f+16>>0]=a[d+19>>0]|0;a[f+17>>0]=a[d+18>>0]|0;a[f+18>>0]=a[d+17>>0]|0;a[f+19>>0]=a[d+16>>0]|0;a[f+20>>0]=a[d+23>>0]|0;a[f+21>>0]=a[d+22>>0]|0;a[f+22>>0]=a[d+21>>0]|0;a[f+23>>0]=a[d+20>>0]|0;a[f+24>>0]=a[d+27>>0]|0;a[f+25>>0]=a[d+26>>0]|0;a[f+26>>0]=a[d+25>>0]|0;a[f+27>>0]=a[d+24>>0]|0;a[f+28>>0]=a[d+31>>0]|0;a[f+29>>0]=a[d+30>>0]|0;a[f+30>>0]=a[d+29>>0]|0;a[f+31>>0]=a[d+28>>0]|0;a[f+32>>0]=a[d+35>>0]|0;a[f+33>>0]=a[d+34>>0]|0;a[f+34>>0]=a[d+33>>0]|0;a[f+35>>0]=a[d+32>>0]|0;a[f+36>>0]=a[d+39>>0]|0;a[f+37>>0]=a[d+38>>0]|0;a[f+38>>0]=a[d+37>>0]|0;a[f+39>>0]=a[d+36>>0]|0;a[f+40>>0]=a[d+43>>0]|0;a[f+41>>0]=a[d+42>>0]|0;a[f+42>>0]=a[d+41>>0]|0;a[f+43>>0]=a[d+40>>0]|0;a[f+44>>0]=a[d+47>>0]|0;a[f+45>>0]=a[d+46>>0]|0;a[f+46>>0]=a[d+45>>0]|0;a[f+47>>0]=a[d+44>>0]|0;a[f+48>>0]=a[d+51>>0]|0;a[f+49>>0]=a[d+50>>0]|0;a[f+50>>0]=a[d+49>>0]|0;a[f+51>>0]=a[d+48>>0]|0;c[f+144>>2]=oF(c[d+144>>2]|0)|0;k=oF(c[d+168>>2]|0)|0}else{c[f+56>>2]=k;c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[f+16>>2]=c[d+16>>2];c[f+20>>2]=c[d+20>>2];c[f+24>>2]=c[d+24>>2];c[f+28>>2]=c[d+28>>2];c[f+32>>2]=c[d+32>>2];c[f+36>>2]=c[d+36>>2];c[f+40>>2]=c[d+40>>2];c[f+44>>2]=c[d+44>>2];c[f+48>>2]=c[d+48>>2];c[f+144>>2]=c[d+144>>2];k=c[d+168>>2]|0}c[f+168>>2]=k;a[f+60>>0]=a[d+60>>0]|0;k=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){l=c[f+96>>2]|0;if(l){if(a[f+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[f+96>>2]=0}c[f+88>>2]=0;c[f+92>>2]=0;c[f+96>>2]=0;a[f+100>>0]=0;c[f+96>>2]=f+172;c[f+88>>2]=k;c[f+92>>2]=k;if(j)if((k|0)>0){l=c[d+96>>2]|0;n=f+172|0;m=0;do{o=l+(m<<6)|0;q=n+(m<<6)|0;a[q>>0]=a[o+3>>0]|0;a[q+1>>0]=a[o+2>>0]|0;a[q+2>>0]=a[o+1>>0]|0;a[q+3>>0]=a[o>>0]|0;q=l+(m<<6)+4|0;o=n+(m<<6)+4|0;a[o>>0]=a[q+3>>0]|0;a[o+1>>0]=a[q+2>>0]|0;a[o+2>>0]=a[q+1>>0]|0;a[o+3>>0]=a[q>>0]|0;o=l+(m<<6)+8|0;q=n+(m<<6)+8|0;a[q>>0]=a[o+3>>0]|0;a[q+1>>0]=a[o+2>>0]|0;a[q+2>>0]=a[o+1>>0]|0;a[q+3>>0]=a[o>>0]|0;q=l+(m<<6)+12|0;n=n+(m<<6)+12|0;a[n>>0]=a[q+3>>0]|0;a[n+1>>0]=a[q+2>>0]|0;a[n+2>>0]=a[q+1>>0]|0;a[n+3>>0]=a[q>>0]|0;n=c[d+96>>2]|0;q=n+(m<<6)+16|0;o=c[f+96>>2]|0;p=o+(m<<6)+16|0;a[p>>0]=a[q+3>>0]|0;a[p+1>>0]=a[q+2>>0]|0;a[p+2>>0]=a[q+1>>0]|0;a[p+3>>0]=a[q>>0]|0;p=n+(m<<6)+20|0;q=o+(m<<6)+20|0;a[q>>0]=a[p+3>>0]|0;a[q+1>>0]=a[p+2>>0]|0;a[q+2>>0]=a[p+1>>0]|0;a[q+3>>0]=a[p>>0]|0;q=n+(m<<6)+24|0;p=o+(m<<6)+24|0;a[p>>0]=a[q+3>>0]|0;a[p+1>>0]=a[q+2>>0]|0;a[p+2>>0]=a[q+1>>0]|0;a[p+3>>0]=a[q>>0]|0;n=n+(m<<6)+28|0;o=o+(m<<6)+28|0;a[o>>0]=a[n+3>>0]|0;a[o+1>>0]=a[n+2>>0]|0;a[o+2>>0]=a[n+1>>0]|0;a[o+3>>0]=a[n>>0]|0;l=c[d+96>>2]|0;o=oF(c[l+(m<<6)+32>>2]|0)|0;n=c[f+96>>2]|0;c[n+(m<<6)+32>>2]=o;c[n+(m<<6)+36>>2]=oF(c[l+(m<<6)+36>>2]|0)|0;c[n+(m<<6)+40>>2]=oF(c[l+(m<<6)+40>>2]|0)|0;m=m+1|0}while((m|0)!=(k|0))}else n=f+172|0;else if((k|0)>0){n=f+172|0;l=c[d+96>>2]|0;m=0;do{n=n+(m<<6)|0;q=l+(m<<6)|0;c[n+0>>2]=c[q+0>>2];c[n+4>>2]=c[q+4>>2];c[n+8>>2]=c[q+8>>2];c[n+12>>2]=c[q+12>>2];n=(c[f+96>>2]|0)+(m<<6)+16|0;q=(c[d+96>>2]|0)+(m<<6)+16|0;c[n+0>>2]=c[q+0>>2];c[n+4>>2]=c[q+4>>2];c[n+8>>2]=c[q+8>>2];c[n+12>>2]=c[q+12>>2];l=c[d+96>>2]|0;n=c[f+96>>2]|0;c[n+(m<<6)+32>>2]=c[l+(m<<6)+32>>2];c[n+(m<<6)+36>>2]=c[l+(m<<6)+36>>2];c[n+(m<<6)+40>>2]=c[l+(m<<6)+40>>2];m=m+1|0}while((m|0)!=(k|0))}else n=f+172|0;if(n){if(a[f+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[n+ -4>>2]|0)}c[f+96>>2]=0}c[f+88>>2]=0;c[f+92>>2]=0;c[f+96>>2]=0;a[f+100>>0]=0;k=k<<6}else{l=c[f+136>>2]|0;if(l){if(a[f+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[f+136>>2]=0}c[f+128>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;a[f+140>>0]=0;c[f+136>>2]=f+172;c[f+128>>2]=k;c[f+132>>2]=k;if(j){if((k|0)>0){l=c[d+136>>2]|0;m=0;do{q=e[l+(m<<4)>>1]|0;b[f+172+(m<<4)>>1]=q>>>8|q<<8;q=e[l+(m<<4)+2>>1]|0;b[f+172+(m<<4)+2>>1]=q>>>8|q<<8;q=e[l+(m<<4)+4>>1]|0;b[f+172+(m<<4)+4>>1]=q>>>8|q<<8;q=e[l+(m<<4)+6>>1]|0;b[f+172+(m<<4)+6>>1]=q>>>8|q<<8;q=e[l+(m<<4)+8>>1]|0;b[f+172+(m<<4)+8>>1]=q>>>8|q<<8;q=e[l+(m<<4)+10>>1]|0;b[f+172+(m<<4)+10>>1]=q>>>8|q<<8;c[f+172+(m<<4)+12>>2]=oF(c[l+(m<<4)+12>>2]|0)|0;m=m+1|0}while((m|0)!=(k|0))}}else if((k|0)>0){l=c[d+136>>2]|0;m=0;do{b[f+172+(m<<4)>>1]=b[l+(m<<4)>>1]|0;b[f+172+(m<<4)+2>>1]=b[l+(m<<4)+2>>1]|0;b[f+172+(m<<4)+4>>1]=b[l+(m<<4)+4>>1]|0;b[f+172+(m<<4)+6>>1]=b[l+(m<<4)+6>>1]|0;b[f+172+(m<<4)+8>>1]=b[l+(m<<4)+8>>1]|0;b[f+172+(m<<4)+10>>1]=b[l+(m<<4)+10>>1]|0;c[f+172+(m<<4)+12>>2]=c[l+(m<<4)+12>>2];m=m+1|0}while((m|0)!=(k|0))}c[f+128>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;a[f+140>>0]=0;k=k<<4}k=f+(k+172)|0;m=c[d+168>>2]|0;l=c[f+160>>2]|0;if(l){if(a[f+164>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[f+160>>2]=0}c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;c[f+160>>2]=k;c[f+152>>2]=m;c[f+156>>2]=m;l=(c[d+168>>2]|0)>0;if(j){if(!l){c[f>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;i=h;return 1}l=c[d+160>>2]|0;j=0;do{q=e[l+(j<<5)>>1]|0;b[k+(j<<5)>>1]=q>>>8|q<<8;q=e[l+(j<<5)+2>>1]|0;b[k+(j<<5)+2>>1]=q>>>8|q<<8;q=e[l+(j<<5)+4>>1]|0;b[k+(j<<5)+4>>1]=q>>>8|q<<8;q=e[l+(j<<5)+6>>1]|0;b[k+(j<<5)+6>>1]=q>>>8|q<<8;q=e[l+(j<<5)+8>>1]|0;b[k+(j<<5)+8>>1]=q>>>8|q<<8;q=e[l+(j<<5)+10>>1]|0;b[k+(j<<5)+10>>1]=q>>>8|q<<8;c[k+(j<<5)+12>>2]=oF(c[l+(j<<5)+12>>2]|0)|0;c[k+(j<<5)+16>>2]=oF(c[l+(j<<5)+16>>2]|0)|0;j=j+1|0}while((j|0)<(c[d+168>>2]|0));c[f>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;i=h;return 1}else{if(!l){c[f>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;i=h;return 1}j=c[d+160>>2]|0;l=0;do{b[k+(l<<5)>>1]=b[j+(l<<5)>>1]|0;b[k+(l<<5)+2>>1]=b[j+(l<<5)+2>>1]|0;b[k+(l<<5)+4>>1]=b[j+(l<<5)+4>>1]|0;b[k+(l<<5)+6>>1]=b[j+(l<<5)+6>>1]|0;b[k+(l<<5)+8>>1]=b[j+(l<<5)+8>>1]|0;b[k+(l<<5)+10>>1]=b[j+(l<<5)+10>>1]|0;c[k+(l<<5)+12>>2]=c[j+(l<<5)+12>>2];c[k+(l<<5)+16>>2]=c[j+(l<<5)+16>>2];c[k+(l<<5)+20>>2]=0;c[k+(l<<5)+24>>2]=0;c[k+(l<<5)+28>>2]=0;l=l+1|0}while((l|0)<(c[d+168>>2]|0));c[f>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;i=h;return 1}return 0}function RA(d,e){d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;i=i+112|0;g[d+20>>2]=+g[e+16>>2];g[d+24>>2]=+g[e+20>>2];g[d+28>>2]=+g[e+24>>2];g[d+32>>2]=+g[e+28>>2];g[d+4>>2]=+g[e>>2];g[d+8>>2]=+g[e+4>>2];g[d+12>>2]=+g[e+8>>2];g[d+16>>2]=+g[e+12>>2];g[d+36>>2]=+g[e+32>>2];g[d+40>>2]=+g[e+36>>2];g[d+44>>2]=+g[e+40>>2];g[d+48>>2]=+g[e+44>>2];c[d+56>>2]=c[e+48>>2];a[d+60>>0]=(c[e+52>>2]|0)!=0&1;h=c[e+56>>2]|0;l=f+48|0;m=l+64|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0));j=c[d+88>>2]|0;if((j|0)<(h|0)){if((c[d+92>>2]|0)<(h|0)){if(!h){n=0;o=j}else{c[5004]=(c[5004]|0)+1;k=fF(h<<6|19)|0;if(!k)n=0;else{c[(k+19&-16)+ -4>>2]=k;n=k+19&-16}o=c[d+88>>2]|0}if((o|0)>0){p=0;do{l=n+(p<<6)+0|0;k=(c[d+96>>2]|0)+(p<<6)+0|0;m=l+64|0;do{c[l>>2]=c[k>>2];l=l+4|0;k=k+4|0}while((l|0)<(m|0));p=p+1|0}while((p|0)!=(o|0))}k=c[d+96>>2]|0;if(k){if(a[d+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=n;c[d+92>>2]=h;n=d+96|0}else n=d+96|0;do{l=(c[n>>2]|0)+(j<<6)+0|0;k=f+48|0;m=l+64|0;do{c[l>>2]=c[k>>2];l=l+4|0;k=k+4|0}while((l|0)<(m|0));j=j+1|0}while((j|0)!=(h|0))}c[d+88>>2]=h;if((h|0)>0){l=c[d+96>>2]|0;j=0;k=c[e+64>>2]|0;while(1){g[l+(j<<6)+16>>2]=+g[k+16>>2];g[l+(j<<6)+20>>2]=+g[k+20>>2];g[l+(j<<6)+24>>2]=+g[k+24>>2];g[l+(j<<6)+28>>2]=+g[k+28>>2];g[l+(j<<6)>>2]=+g[k>>2];g[l+(j<<6)+4>>2]=+g[k+4>>2];g[l+(j<<6)+8>>2]=+g[k+8>>2];g[l+(j<<6)+12>>2]=+g[k+12>>2];c[l+(j<<6)+32>>2]=c[k+32>>2];c[l+(j<<6)+36>>2]=c[k+36>>2];c[l+(j<<6)+40>>2]=c[k+40>>2];j=j+1|0;if((j|0)==(h|0))break;else k=k+48|0}}h=c[e+60>>2]|0;c[f+32>>2]=0;c[f+36>>2]=0;c[f+40>>2]=0;c[f+44>>2]=0;j=c[d+128>>2]|0;if((j|0)<(h|0)){if((c[d+132>>2]|0)<(h|0)){if(!h){k=0;l=j}else{c[5004]=(c[5004]|0)+1;k=fF((h<<4|3)+16|0)|0;if(!k)k=0;else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16}l=c[d+128>>2]|0}if((l|0)>0){m=0;do{p=k+(m<<4)|0;o=(c[d+136>>2]|0)+(m<<4)|0;c[p+0>>2]=c[o+0>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2];m=m+1|0}while((m|0)!=(l|0))}l=c[d+136>>2]|0;if(l){if(a[d+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=k;c[d+132>>2]=h;k=d+136|0}else k=d+136|0;do{p=(c[k>>2]|0)+(j<<4)|0;c[p+0>>2]=c[f+32>>2];c[p+4>>2]=c[f+36>>2];c[p+8>>2]=c[f+40>>2];c[p+12>>2]=c[f+44>>2];j=j+1|0}while((j|0)!=(h|0))}c[d+128>>2]=h;if((h|0)>0){k=c[d+136>>2]|0;j=0;l=c[e+68>>2]|0;while(1){c[k+(j<<4)+12>>2]=c[l+12>>2];b[k+(j<<4)+6>>1]=b[l+6>>1]|0;b[k+(j<<4)+8>>1]=b[l+8>>1]|0;b[k+(j<<4)+10>>1]=b[l+10>>1]|0;b[k+(j<<4)>>1]=b[l>>1]|0;b[k+(j<<4)+2>>1]=b[l+2>>1]|0;b[k+(j<<4)+4>>1]=b[l+4>>1]|0;j=j+1|0;if((j|0)==(h|0))break;else l=l+16|0}}c[d+144>>2]=c[e+76>>2];h=c[e+80>>2]|0;j=c[d+152>>2]|0;if((j|0)<(h|0)){if((c[d+156>>2]|0)<(h|0)){if(!h){k=0;l=j}else{c[5004]=(c[5004]|0)+1;k=fF(h<<5|19)|0;if(!k)k=0;else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16}l=c[d+152>>2]|0}if((l|0)>0){m=0;do{p=k+(m<<5)|0;o=(c[d+160>>2]|0)+(m<<5)|0;c[p+0>>2]=c[o+0>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2];c[p+16>>2]=c[o+16>>2];c[p+20>>2]=c[o+20>>2];c[p+24>>2]=c[o+24>>2];c[p+28>>2]=c[o+28>>2];m=m+1|0}while((m|0)!=(l|0))}l=c[d+160>>2]|0;if(l){if(a[d+164>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=k;c[d+156>>2]=h;k=d+160|0}else k=d+160|0;do{p=(c[k>>2]|0)+(j<<5)|0;c[p+0>>2]=c[f+0>>2];c[p+4>>2]=c[f+4>>2];c[p+8>>2]=c[f+8>>2];c[p+12>>2]=c[f+12>>2];c[p+16>>2]=c[f+16>>2];c[p+20>>2]=c[f+20>>2];c[p+24>>2]=c[f+24>>2];c[p+28>>2]=c[f+28>>2];j=j+1|0}while((j|0)!=(h|0))}c[d+152>>2]=h;if((h|0)<=0){i=f;return}j=c[d+160>>2]|0;d=0;e=c[e+72>>2]|0;while(1){b[j+(d<<5)+6>>1]=b[e+14>>1]|0;b[j+(d<<5)+8>>1]=b[e+16>>1]|0;b[j+(d<<5)+10>>1]=b[e+18>>1]|0;b[j+(d<<5)>>1]=b[e+8>>1]|0;b[j+(d<<5)+2>>1]=b[e+10>>1]|0;b[j+(d<<5)+4>>1]=b[e+12>>1]|0;c[j+(d<<5)+12>>2]=c[e>>2];c[j+(d<<5)+16>>2]=c[e+4>>2];d=d+1|0;if((d|0)==(h|0))break;else e=e+20|0}i=f;return}function SA(d,e){d=d|0;e=e|0;var f=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=i;i=i+112|0;g[d+20>>2]=+h[e+32>>3];g[d+24>>2]=+h[e+40>>3];g[d+28>>2]=+h[e+48>>3];g[d+32>>2]=+h[e+56>>3];g[d+4>>2]=+h[e>>3];g[d+8>>2]=+h[e+8>>3];g[d+12>>2]=+h[e+16>>3];g[d+16>>2]=+h[e+24>>3];g[d+36>>2]=+h[e+64>>3];g[d+40>>2]=+h[e+72>>3];g[d+44>>2]=+h[e+80>>3];g[d+48>>2]=+h[e+88>>3];c[d+56>>2]=c[e+96>>2];a[d+60>>0]=(c[e+100>>2]|0)!=0&1;j=c[e+104>>2]|0;m=f+48|0;n=m+64|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(n|0));k=c[d+88>>2]|0;if((k|0)<(j|0)){if((c[d+92>>2]|0)<(j|0)){if(!j){o=0;p=k}else{c[5004]=(c[5004]|0)+1;l=fF(j<<6|19)|0;if(!l)o=0;else{c[(l+19&-16)+ -4>>2]=l;o=l+19&-16}p=c[d+88>>2]|0}if((p|0)>0){q=0;do{m=o+(q<<6)+0|0;l=(c[d+96>>2]|0)+(q<<6)+0|0;n=m+64|0;do{c[m>>2]=c[l>>2];m=m+4|0;l=l+4|0}while((m|0)<(n|0));q=q+1|0}while((q|0)!=(p|0))}l=c[d+96>>2]|0;if(l){if(a[d+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=o;c[d+92>>2]=j;o=d+96|0}else o=d+96|0;do{m=(c[o>>2]|0)+(k<<6)+0|0;l=f+48|0;n=m+64|0;do{c[m>>2]=c[l>>2];m=m+4|0;l=l+4|0}while((m|0)<(n|0));k=k+1|0}while((k|0)!=(j|0))}c[d+88>>2]=j;if((j|0)>0){m=c[d+96>>2]|0;k=0;l=c[e+112>>2]|0;while(1){g[m+(k<<6)+16>>2]=+h[l+32>>3];g[m+(k<<6)+20>>2]=+h[l+40>>3];g[m+(k<<6)+24>>2]=+h[l+48>>3];g[m+(k<<6)+28>>2]=+h[l+56>>3];g[m+(k<<6)>>2]=+h[l>>3];g[m+(k<<6)+4>>2]=+h[l+8>>3];g[m+(k<<6)+8>>2]=+h[l+16>>3];g[m+(k<<6)+12>>2]=+h[l+24>>3];c[m+(k<<6)+32>>2]=c[l+64>>2];c[m+(k<<6)+36>>2]=c[l+68>>2];c[m+(k<<6)+40>>2]=c[l+72>>2];k=k+1|0;if((k|0)==(j|0))break;else l=l+80|0}}j=c[e+108>>2]|0;c[f+32>>2]=0;c[f+36>>2]=0;c[f+40>>2]=0;c[f+44>>2]=0;k=c[d+128>>2]|0;if((k|0)<(j|0)){if((c[d+132>>2]|0)<(j|0)){if(!j){l=0;m=k}else{c[5004]=(c[5004]|0)+1;l=fF((j<<4|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}m=c[d+128>>2]|0}if((m|0)>0){n=0;do{q=l+(n<<4)|0;p=(c[d+136>>2]|0)+(n<<4)|0;c[q+0>>2]=c[p+0>>2];c[q+4>>2]=c[p+4>>2];c[q+8>>2]=c[p+8>>2];c[q+12>>2]=c[p+12>>2];n=n+1|0}while((n|0)!=(m|0))}m=c[d+136>>2]|0;if(m){if(a[d+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=l;c[d+132>>2]=j;l=d+136|0}else l=d+136|0;do{q=(c[l>>2]|0)+(k<<4)|0;c[q+0>>2]=c[f+32>>2];c[q+4>>2]=c[f+36>>2];c[q+8>>2]=c[f+40>>2];c[q+12>>2]=c[f+44>>2];k=k+1|0}while((k|0)!=(j|0))}c[d+128>>2]=j;if((j|0)>0){l=c[d+136>>2]|0;k=0;m=c[e+116>>2]|0;while(1){c[l+(k<<4)+12>>2]=c[m+12>>2];b[l+(k<<4)+6>>1]=b[m+6>>1]|0;b[l+(k<<4)+8>>1]=b[m+8>>1]|0;b[l+(k<<4)+10>>1]=b[m+10>>1]|0;b[l+(k<<4)>>1]=b[m>>1]|0;b[l+(k<<4)+2>>1]=b[m+2>>1]|0;b[l+(k<<4)+4>>1]=b[m+4>>1]|0;k=k+1|0;if((k|0)==(j|0))break;else m=m+16|0}}c[d+144>>2]=c[e+120>>2];j=c[e+124>>2]|0;k=c[d+152>>2]|0;if((k|0)<(j|0)){if((c[d+156>>2]|0)<(j|0)){if(!j){l=0;m=k}else{c[5004]=(c[5004]|0)+1;l=fF(j<<5|19)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}m=c[d+152>>2]|0}if((m|0)>0){n=0;do{q=l+(n<<5)|0;p=(c[d+160>>2]|0)+(n<<5)|0;c[q+0>>2]=c[p+0>>2];c[q+4>>2]=c[p+4>>2];c[q+8>>2]=c[p+8>>2];c[q+12>>2]=c[p+12>>2];c[q+16>>2]=c[p+16>>2];c[q+20>>2]=c[p+20>>2];c[q+24>>2]=c[p+24>>2];c[q+28>>2]=c[p+28>>2];n=n+1|0}while((n|0)!=(m|0))}m=c[d+160>>2]|0;if(m){if(a[d+164>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=l;c[d+156>>2]=j;l=d+160|0}else l=d+160|0;do{q=(c[l>>2]|0)+(k<<5)|0;c[q+0>>2]=c[f+0>>2];c[q+4>>2]=c[f+4>>2];c[q+8>>2]=c[f+8>>2];c[q+12>>2]=c[f+12>>2];c[q+16>>2]=c[f+16>>2];c[q+20>>2]=c[f+20>>2];c[q+24>>2]=c[f+24>>2];c[q+28>>2]=c[f+28>>2];k=k+1|0}while((k|0)!=(j|0))}c[d+152>>2]=j;if((j|0)<=0){i=f;return}k=c[d+160>>2]|0;d=0;e=c[e+128>>2]|0;while(1){b[k+(d<<5)+6>>1]=b[e+14>>1]|0;b[k+(d<<5)+8>>1]=b[e+16>>1]|0;b[k+(d<<5)+10>>1]=b[e+18>>1]|0;b[k+(d<<5)>>1]=b[e+8>>1]|0;b[k+(d<<5)+2>>1]=b[e+10>>1]|0;b[k+(d<<5)+4>>1]=b[e+12>>1]|0;c[k+(d<<5)+12>>2]=c[e>>2];c[k+(d<<5)+16>>2]=c[e+4>>2];d=d+1|0;if((d|0)==(j|0))break;else e=e+20|0}i=f;return}function TA(a,e,f){a=a|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0;h=i;g[e+16>>2]=+g[a+20>>2];g[e+20>>2]=+g[a+24>>2];g[e+24>>2]=+g[a+28>>2];g[e+28>>2]=+g[a+32>>2];g[e>>2]=+g[a+4>>2];g[e+4>>2]=+g[a+8>>2];g[e+8>>2]=+g[a+12>>2];g[e+12>>2]=+g[a+16>>2];g[e+32>>2]=+g[a+36>>2];g[e+36>>2]=+g[a+40>>2];g[e+40>>2]=+g[a+44>>2];g[e+44>>2]=+g[a+48>>2];c[e+48>>2]=c[a+56>>2];c[e+52>>2]=d[a+60>>0];c[e+56>>2]=c[a+88>>2];if(c[a+88>>2]|0){n=gc[c[(c[f>>2]|0)+28>>2]&31](f,c[a+96>>2]|0)|0;c[e+64>>2]=n;if(n){n=c[a+88>>2]|0;j=Yb[c[(c[f>>2]|0)+16>>2]&31](f,48,n)|0;if((n|0)>0){k=c[a+96>>2]|0;m=0;l=c[j+8>>2]|0;while(1){g[l+16>>2]=+g[k+(m<<6)+16>>2];g[l+20>>2]=+g[k+(m<<6)+20>>2];g[l+24>>2]=+g[k+(m<<6)+24>>2];g[l+28>>2]=+g[k+(m<<6)+28>>2];g[l>>2]=+g[k+(m<<6)>>2];g[l+4>>2]=+g[k+(m<<6)+4>>2];g[l+8>>2]=+g[k+(m<<6)+8>>2];g[l+12>>2]=+g[k+(m<<6)+12>>2];c[l+32>>2]=c[k+(m<<6)+32>>2];c[l+36>>2]=c[k+(m<<6)+36>>2];c[l+40>>2]=c[k+(m<<6)+40>>2];m=m+1|0;if((m|0)==(n|0))break;else l=l+48|0}}else k=c[a+96>>2]|0;Jb[c[(c[f>>2]|0)+20>>2]&31](f,j,16120,1497453121,k)}}else c[e+64>>2]=0;c[e+60>>2]=c[a+128>>2];if(c[a+128>>2]|0){n=gc[c[(c[f>>2]|0)+28>>2]&31](f,c[a+136>>2]|0)|0;c[e+68>>2]=n;if(n){k=c[a+128>>2]|0;j=Yb[c[(c[f>>2]|0)+16>>2]&31](f,16,k)|0;if((k|0)>0){l=c[a+136>>2]|0;n=0;m=c[j+8>>2]|0;while(1){c[m+12>>2]=c[l+(n<<4)+12>>2];b[m+6>>1]=b[l+(n<<4)+6>>1]|0;b[m+8>>1]=b[l+(n<<4)+8>>1]|0;b[m+10>>1]=b[l+(n<<4)+10>>1]|0;b[m>>1]=b[l+(n<<4)>>1]|0;b[m+2>>1]=b[l+(n<<4)+2>>1]|0;b[m+4>>1]=b[l+(n<<4)+4>>1]|0;n=n+1|0;if((n|0)==(k|0))break;else m=m+16|0}}else l=c[a+136>>2]|0;Jb[c[(c[f>>2]|0)+20>>2]&31](f,j,16144,1497453121,l)}}else c[e+68>>2]=0;c[e+76>>2]=c[a+144>>2];c[e+80>>2]=c[a+152>>2];if(!(c[a+152>>2]|0)){c[e+72>>2]=0;i=h;return 16192}n=gc[c[(c[f>>2]|0)+28>>2]&31](f,c[a+160>>2]|0)|0;c[e+72>>2]=n;if(!n){i=h;return 16192}j=c[a+152>>2]|0;e=Yb[c[(c[f>>2]|0)+16>>2]&31](f,20,j)|0;if((j|0)>0){a=c[a+160>>2]|0;l=0;k=c[e+8>>2]|0;while(1){b[k+14>>1]=b[a+(l<<5)+6>>1]|0;b[k+16>>1]=b[a+(l<<5)+8>>1]|0;b[k+18>>1]=b[a+(l<<5)+10>>1]|0;b[k+8>>1]=b[a+(l<<5)>>1]|0;b[k+10>>1]=b[a+(l<<5)+2>>1]|0;b[k+12>>1]=b[a+(l<<5)+4>>1]|0;c[k>>2]=c[a+(l<<5)+12>>2];c[k+4>>2]=c[a+(l<<5)+16>>2];l=l+1|0;if((l|0)==(j|0))break;else k=k+20|0}}else a=c[a+160>>2]|0;Jb[c[(c[f>>2]|0)+20>>2]&31](f,e,16168,1497453121,a);i=h;return 16192}function UA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0;f=i;i=i+32|0;C=+g[b+16>>2];s=+g[b>>2];B=+g[b+20>>2];u=+g[b+4>>2];y=+g[b+24>>2];x=+g[b+8>>2];v=+g[b+32>>2];o=+g[b+36>>2];p=+g[b+40>>2];m=(B-u)*(p-x)-(y-x)*(o-u);k=(y-x)*(v-s)-(C-s)*(p-x);l=(C-s)*(o-u)-(B-u)*(v-s);g[f+16>>2]=m;g[f+20>>2]=k;g[f+24>>2]=l;g[f+28>>2]=0.0;z=+g[a+4>>2];w=+g[a+8>>2];q=+g[a+12>>2];h=m*z+k*w+l*q-(s*m+u*k+x*l);A=+g[a+20>>2];t=+g[a+24>>2];r=+g[a+28>>2];if(h*(m*A+k*t+l*r-(s*m+u*k+x*l))>=0.0){i=f;return}b=c[a+36>>2]|0;if(!((b&1|0)==0|!(h<=0.0))){i=f;return}j=h/(h-(m*A+k*t+l*r-(s*m+u*k+x*l)));if(!(j<+g[a+40>>2])){i=f;return}n=(m*m+k*k+l*l)*-9999999747378752.0e-20;s=s-(A*j+z*(1.0-j));u=u-(t*j+w*(1.0-j));x=x-(r*j+q*(1.0-j));C=C-(A*j+z*(1.0-j));B=B-(t*j+w*(1.0-j));y=y-(r*j+q*(1.0-j));if(!(l*(s*B-u*C)+(m*(u*y-x*B)+k*(x*C-s*y))>=n)){i=f;return}v=v-(A*j+z*(1.0-j));o=o-(t*j+w*(1.0-j));p=p-(r*j+q*(1.0-j));if(!(l*(C*o-B*v)+(m*(B*p-y*o)+k*(y*v-C*p))>=n)){i=f;return}if(!(l*(u*v-s*o)+(m*(x*o-u*p)+k*(s*p-x*v))>=n)){i=f;return}n=1.0/+Q(+(m*m+k*k+l*l));g[f+16>>2]=m*n;g[f+20>>2]=k*n;g[f+24>>2]=l*n;D=c[(c[a>>2]|0)+12>>2]|0;if((b&2|0)!=0|!(h<=0.0)){g[a+40>>2]=+nc[D&3](a,f+16|0,j,d,e);i=f;return}else{g[f>>2]=-(m*n);g[f+4>>2]=-(k*n);g[f+8>>2]=-(l*n);g[f+12>>2]=0.0;g[a+40>>2]=+nc[D&3](a,f,j,d,e);i=f;return}}function VA(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;i=i+672|0;c[h+576>>2]=0;g[h+580>>2]=1.0;g[h+584>>2]=1.0;g[h+588>>2]=1.0;g[h+592>>2]=0.0;c[h+620>>2]=0;c[h+568>>2]=16376;c[h+572>>2]=1;c[h+624>>2]=c[d+0>>2];c[h+628>>2]=c[d+4>>2];c[h+632>>2]=c[d+8>>2];c[h+636>>2]=c[d+12>>2];c[h+640>>2]=c[d+16>>2];c[h+644>>2]=c[d+20>>2];c[h+648>>2]=c[d+24>>2];c[h+652>>2]=c[d+28>>2];c[h+656>>2]=c[d+32>>2];c[h+660>>2]=c[d+36>>2];c[h+664>>2]=c[d+40>>2];c[h+668>>2]=c[d+44>>2];g[h+612>>2]=+g[b+204>>2];g[h+516>>2]=9999999747378752.0e-20;a[h+540>>0]=0;c[h+200>>2]=13248;d=c[b+4>>2]|0;c[h+176>>2]=10152;c[h+180>>2]=h+208;c[h+184>>2]=h+200;c[h+188>>2]=d;c[h+192>>2]=h+568;c[h+196>>2]=0;c[h>>2]=9440;c[h+168>>2]=0;g[h+164>>2]=1.0;g[h+172>>2]=+g[b+208>>2];if((xw(h+176|0,b+8|0,b+72|0,b+136|0,b+136|0,h)|0?(j=+g[h+132>>2],l=+g[h+136>>2],m=+g[h+140>>2],j*j+l*l+m*m>9999999747378752.0e-20):0)?(k=+g[h+164>>2],k<+g[b+200>>2]):0){n=1.0/+Q(+(j*j+l*l+m*m));g[h+132>>2]=j*n;g[h+136>>2]=l*n;g[h+140>>2]=m*n;+bc[c[(c[b>>2]|0)+12>>2]&3](b,h+132|0,h+148|0,k,e,f)}c[h+568>>2]=15736;e=c[h+620>>2]|0;if(!e){i=h;return}Lb[c[c[e>>2]>>2]&511](e);e=c[h+620>>2]|0;if(!e){i=h;return}c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0);i=h;return}function WA(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=15736;d=c[a+52>>2]|0;if(!d){i=b;return}Lb[c[c[d>>2]>>2]&511](d);a=c[a+52>>2]|0;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function XA(a){a=a|0;return}function YA(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function ZA(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=15736;d=c[a+52>>2]|0;if(d){Lb[c[c[d>>2]>>2]&511](d);d=c[a+52>>2]|0;if(d){c[5006]=(c[5006]|0)+1;gF(c[d+ -4>>2]|0)}if(!a){i=b;return}}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function _A(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+80>>2]&127](a,b,d,e);i=f;return}function $A(a,b,d){a=a|0;b=+b;d=d|0;a=i;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;i=a;return}function aB(a){a=a|0;return 16544}function bB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;l=+g[d>>2];k=+g[d+4>>2];f=+g[d+8>>2];j=l*+g[b+56>>2]+k*+g[b+60>>2]+f*+g[b+64>>2];h=l*+g[b+72>>2]+k*+g[b+76>>2]+f*+g[b+80>>2];f=l*+g[b+88>>2]+k*+g[b+92>>2]+f*+g[b+96>>2];if(j<h)d=h<f?2:1;else d=j<f?2:0;d=b+(d<<4)+56|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];i=e;return}function cB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0;h=i;if((e|0)<=0){i=h;return}f=0;do{p=+g[b+(f<<4)>>2];o=+g[b+(f<<4)+4>>2];k=+g[b+(f<<4)+8>>2];m=p*+g[a+56>>2]+o*+g[a+60>>2]+k*+g[a+64>>2];l=p*+g[a+72>>2]+o*+g[a+76>>2]+k*+g[a+80>>2];k=p*+g[a+88>>2]+o*+g[a+92>>2]+k*+g[a+96>>2];j=d+(f<<4)|0;if(m<l)n=l<k?2:1;else n=m<k?2:0;n=a+(n<<4)+56|0;c[j+0>>2]=c[n+0>>2];c[j+4>>2]=c[n+4>>2];c[j+8>>2]=c[n+8>>2];c[j+12>>2]=c[n+12>>2];f=f+1|0}while((f|0)!=(e|0));i=h;return}function dB(a){a=a|0;return 2}function eB(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0,j=0.0,k=0.0,l=0.0,m=0.0;h=i;k=+g[a+56>>2];f=+g[a+72>>2]-k;j=+g[a+60>>2];e=+g[a+76>>2]-j;l=+g[a+64>>2];d=+g[a+80>>2]-l;k=+g[a+88>>2]-k;j=+g[a+92>>2]-j;l=+g[a+96>>2]-l;g[c+12>>2]=0.0;m=1.0/+Q(+((f*j-e*k)*(f*j-e*k)+((e*l-d*j)*(e*l-d*j)+(d*k-f*l)*(d*k-f*l))));g[c>>2]=m*(e*l-d*j);g[c+4>>2]=m*(d*k-f*l);g[c+8>>2]=(f*j-e*k)*m;if(!b){i=h;return}g[c>>2]=m*(e*l-d*j)*-1.0;g[c+4>>2]=m*(d*k-f*l)*-1.0;g[c+8>>2]=(f*j-e*k)*m*-1.0;i=h;return}function fB(a){a=a|0;return 3}function gB(a){a=a|0;return 3}function hB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;rc[c[(c[a>>2]|0)+108>>2]&127](a,b,d);rc[c[(c[a>>2]|0)+108>>2]&127](a,(b+1|0)%3|0,e);i=f;return}function iB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[d+0>>2]=c[a+(b<<4)+56>>2];c[d+4>>2]=c[a+(b<<4)+60>>2];c[d+8>>2]=c[a+(b<<4)+64>>2];c[d+12>>2]=c[a+(b<<4)+68>>2];i=e;return}function jB(a){a=a|0;return 1}function kB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;vc[c[(c[a>>2]|0)+124>>2]&127](a,e,b,d);i=f;return}function lB(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;e=i;i=i+32|0;n=+g[a+56>>2];r=+g[a+72>>2]-n;m=+g[a+60>>2];p=+g[a+76>>2]-m;l=+g[a+64>>2];s=+g[a+80>>2]-l;o=+g[a+88>>2]-n;q=+g[a+92>>2]-m;f=+g[a+96>>2]-l;j=1.0/+Q(+((r*q-p*o)*(r*q-p*o)+((p*f-s*q)*(p*f-s*q)+(s*o-r*f)*(s*o-r*f))));h=j*(p*f-s*q);f=j*(s*o-r*f);j=(r*q-p*o)*j;l=+g[b>>2]*h+ +g[b+4>>2]*f+j*+g[b+8>>2]-(h*n+f*m+j*l);if(!(l>=-d)|!(l<=d)){k=0;i=e;return k|0}k=0;while(1){vc[c[(c[a>>2]|0)+104>>2]&127](a,k,e+16|0,e);n=+g[e+16>>2];s=+g[e>>2]-n;p=+g[e+20>>2];o=+g[e+4>>2]-p;m=+g[e+24>>2];r=+g[e+8>>2]-m;q=1.0/+Q(+((f*s-h*o)*(f*s-h*o)+((j*o-f*r)*(j*o-f*r)+(h*r-j*s)*(h*r-j*s))));k=k+1|0;if(+g[b>>2]*q*(j*o-f*r)+ +g[b+4>>2]*q*(h*r-j*s)+(f*s-h*o)*q*+g[b+8>>2]-(m*(f*s-h*o)*q+(n*q*(j*o-f*r)+p*q*(h*r-j*s)))<-d){b=0;a=5;break}if((k|0)>=3){b=1;a=5;break}}if((a|0)==5){i=e;return b|0}return 0}function mB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;b=i;h=+g[a+56>>2];l=+g[a+72>>2]-h;k=+g[a+60>>2];j=+g[a+76>>2]-k;m=+g[a+64>>2];n=+g[a+80>>2]-m;h=+g[a+88>>2]-h;k=+g[a+92>>2]-k;m=+g[a+96>>2]-m;g[d+12>>2]=0.0;f=1.0/+Q(+((l*k-j*h)*(l*k-j*h)+((j*m-n*k)*(j*m-n*k)+(n*h-l*m)*(n*h-l*m))));g[d>>2]=f*(j*m-n*k);g[d+4>>2]=f*(n*h-l*m);g[d+8>>2]=(l*k-j*h)*f;c[e+0>>2]=c[a+56>>2];c[e+4>>2]=c[a+60>>2];c[e+8>>2]=c[a+64>>2];c[e+12>>2]=c[a+68>>2];i=b;return}function nB(a){a=a|0;var b=0;b=i;oB(a);gF(a);i=b;return}function oB(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=16568;e=c[b+56>>2]|0;if(e){if(a[b+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;e=c[b+36>>2]|0;if(e){if(a[b+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;e=c[b+16>>2]|0;if(!e){e=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[e>>2]=0;i=d;return}if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+16>>2]=0;e=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[e>>2]=0;i=d;return}function pB(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;if((c[d+8>>2]|0)>0){h=c[d+16>>2]|0;j=0;f=0;do{k=c[h+(j<<2)>>2]|0;if(!(c[k+204>>2]&3)){c[k+208>>2]=f;f=f+1|0}c[k+212>>2]=-1;g[k+244>>2]=1.0;j=j+1|0}while((j|0)<(c[d+8>>2]|0))}else f=0;h=c[b+8>>2]|0;if((h|0)<(f|0)){if((c[b+12>>2]|0)<(f|0)){if(!f){j=0;m=h}else{c[5004]=(c[5004]|0)+1;j=fF((f<<3|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}m=c[b+8>>2]|0}if((m|0)>0){l=0;do{k=j+(l<<3)|0;if(k){o=(c[b+16>>2]|0)+(l<<3)|0;n=c[o+4>>2]|0;c[k>>2]=c[o>>2];c[k+4>>2]=n}l=l+1|0}while((l|0)!=(m|0))}k=c[b+16>>2]|0;if(k){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=j;c[b+12>>2]=f;j=b+16|0}else j=b+16|0;do{k=(c[j>>2]|0)+(h<<3)|0;if(k){c[k>>2]=0;c[k+4>>2]=0}h=h+1|0}while((h|0)!=(f|0))}c[b+8>>2]=f;if((f|0)>0){j=c[b+16>>2]|0;h=0;do{c[j+(h<<3)>>2]=h;c[j+(h<<3)+4>>2]=1;h=h+1|0}while((h|0)!=(f|0))}f=c[d+68>>2]|0;f=Pb[c[(c[f>>2]|0)+36>>2]&127](f)|0;d=Pb[c[(c[f>>2]|0)+36>>2]&127](f)|0;if(!d){i=e;return}h=Pb[c[(c[f>>2]|0)+20>>2]&127](f)|0;if((d|0)<=0){i=e;return}f=0;do{k=c[c[h+(f<<4)>>2]>>2]|0;j=c[c[h+(f<<4)+4>>2]>>2]|0;if(((k|0)!=0?!((j|0)==0?1:(c[k+204>>2]&7|0)!=0):0)?(c[j+204>>2]&7|0)==0:0){l=c[k+208>>2]|0;k=c[j+208>>2]|0;j=c[b+16>>2]|0;m=c[j+(l<<3)>>2]|0;if((m|0)!=(l|0)){n=j+(l<<3)|0;do{l=j+(m<<3)|0;c[n>>2]=c[l>>2];l=c[l>>2]|0;n=j+(l<<3)|0;m=c[n>>2]|0}while((l|0)!=(m|0))}m=c[j+(k<<3)>>2]|0;if((m|0)!=(k|0)){n=j+(k<<3)|0;do{k=j+(m<<3)|0;c[n>>2]=c[k>>2];k=c[k>>2]|0;n=j+(k<<3)|0;m=c[n>>2]|0}while((k|0)!=(m|0))}if((l|0)!=(k|0)){c[j+(l<<3)>>2]=k;o=j+(k<<3)+4|0;c[o>>2]=(c[o>>2]|0)+(c[j+(l<<3)+4>>2]|0)}}f=f+1|0}while((f|0)!=(d|0));i=e;return}function qB(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;if((c[b+8>>2]|0)<=0){i=f;return}d=c[b+16>>2]|0;e=0;g=0;do{h=c[d+(e<<2)>>2]|0;if(!(c[h+204>>2]&3)){j=c[a+16>>2]|0;l=j+(g<<3)|0;k=c[l>>2]|0;if((k|0)==(g|0))m=g;else do{m=j+(k<<3)|0;c[l>>2]=c[m>>2];m=c[m>>2]|0;l=j+(m<<3)|0;k=c[l>>2]|0}while((m|0)!=(k|0));c[h+208>>2]=m;c[j+(g<<3)+4>>2]=e;c[h+212>>2]=-1;g=g+1|0}else{c[h+208>>2]=-1;c[h+212>>2]=-2}e=e+1|0}while((e|0)<(c[b+8>>2]|0));i=f;return}function rB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;while(1){f=c[a+12>>2]|0;g=c[f+(((b+d|0)/2|0)<<2)>>2]|0;l=b;k=d;while(1){h=c[(c[g+740>>2]|0)+208>>2]|0;if((h|0)>-1)while(1){j=c[f+(l<<2)>>2]|0;m=c[(c[j+740>>2]|0)+208>>2]|0;if((m|0)<=-1)m=c[(c[j+744>>2]|0)+208>>2]|0;if((m|0)<(h|0))l=l+1|0;else break}else{m=c[(c[g+744>>2]|0)+208>>2]|0;while(1){j=c[f+(l<<2)>>2]|0;n=c[(c[j+740>>2]|0)+208>>2]|0;if((n|0)<=-1)n=c[(c[j+744>>2]|0)+208>>2]|0;if((n|0)<(m|0))l=l+1|0;else break}}if((h|0)>-1)while(1){m=c[f+(k<<2)>>2]|0;n=c[(c[m+740>>2]|0)+208>>2]|0;if((n|0)<=-1)n=c[(c[m+744>>2]|0)+208>>2]|0;if((h|0)<(n|0))k=k+ -1|0;else break}else{h=c[(c[g+744>>2]|0)+208>>2]|0;while(1){m=c[f+(k<<2)>>2]|0;n=c[(c[m+740>>2]|0)+208>>2]|0;if((n|0)<=-1)n=c[(c[m+744>>2]|0)+208>>2]|0;if((h|0)<(n|0))k=k+ -1|0;else break}}if((l|0)<=(k|0)){c[f+(l<<2)>>2]=m;c[(c[a+12>>2]|0)+(k<<2)>>2]=j;l=l+1|0;k=k+ -1|0}if((l|0)>(k|0))break;f=c[a+12>>2]|0}if((k|0)>(b|0))rB(a,b,k);if((l|0)<(d|0))b=l;else break}i=e;return}function sB(a,b,d){a=a|0;b=b|0;d=d|0;d=i;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;i=d;return}function tB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;a=i;if((e|0)>0)b=0;else{i=a;return}do{g=d+(b<<4)|0;b=b+1|0;f=(b|0)==(e|0);c[g+0>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0}while(!f);i=a;return}function uB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;rc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+Q(+(f*f+(l*l+k*k)));j=+$b[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*h*k+ +g[a+4>>2];g[a+8>>2]=j*h*f+ +g[a+8>>2];i=e;return}function vB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;f=i;k=+$b[c[(c[a>>2]|0)+48>>2]&15](a);j=+$b[c[(c[a>>2]|0)+48>>2]&15](a);h=+$b[c[(c[a>>2]|0)+48>>2]&15](a);m=+g[b+52>>2]-j;l=+g[b+56>>2]-h;g[d>>2]=+g[b+48>>2]-k;g[d+4>>2]=m;g[d+8>>2]=l;g[d+12>>2]=0.0;j=j+ +g[b+52>>2];h=h+ +g[b+56>>2];g[e>>2]=k+ +g[b+48>>2];g[e+4>>2]=j;g[e+8>>2]=h;g[e+12>>2]=0.0;i=f;return}function wB(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;b=b*.4000000059604645*+$b[c[(c[a>>2]|0)+48>>2]&15](a);b=b*+$b[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b;g[d+4>>2]=b;g[d+8>>2]=b;g[d+12>>2]=0.0;i=e;return}function xB(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=16816;if((a[b+8>>0]|0)!=0?(e=c[b+12>>2]|0,(e|0)!=0):0){f=c[b+4>>2]|0;Nb[c[(c[f>>2]|0)+16>>2]&127](f,e)}gF(b);i=d;return}function yB(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=16816;if(!(a[b+8>>0]|0)){i=d;return}e=c[b+12>>2]|0;if(!e){i=d;return}b=c[b+4>>2]|0;Nb[c[(c[b>>2]|0)+16>>2]&127](b,e);i=d;return}function zB(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0.0;e=i;i=i+32|0;a=c[a+12>>2]|0;if(!a){i=e;return}c[f+4>>2]=a;o=c[b+4>>2]|0;p=c[d+4>>2]|0;b=c[b+12>>2]|0;d=c[d+12>>2]|0;m=+g[b+48>>2]- +g[d+48>>2];n=+g[b+52>>2]- +g[d+52>>2];l=+g[b+56>>2]- +g[d+56>>2];j=+Q(+(m*m+n*n+l*l));h=+g[p+28>>2]*+g[p+12>>2];k=+g[o+28>>2]*+g[o+12>>2]+h;if(j>k){if(!(c[a+748>>2]|0)){i=e;return}d=c[a+740>>2]|0;b=c[(c[f+8>>2]|0)+8>>2]|0;if((d|0)==(b|0)){xA(a,d+4|0,(c[(c[f+12>>2]|0)+8>>2]|0)+4|0);i=e;return}else{xA(a,(c[(c[f+12>>2]|0)+8>>2]|0)+4|0,b+4|0);i=e;return}}g[e+16>>2]=1.0;g[e+20>>2]=0.0;g[e+24>>2]=0.0;g[e+28>>2]=0.0;if(j>1.1920928955078125e-7){g[e+16>>2]=m*(1.0/j);g[e+20>>2]=n*(1.0/j);g[e+24>>2]=l*(1.0/j);g[e+28>>2]=0.0;m=m*(1.0/j);n=n*(1.0/j);l=l*(1.0/j)}else{m=1.0;n=0.0;l=0.0}q=h*n+ +g[d+52>>2];n=h*l+ +g[d+56>>2];g[e>>2]=h*m+ +g[d+48>>2];g[e+4>>2]=q;g[e+8>>2]=n;g[e+12>>2]=0.0;qc[c[(c[f>>2]|0)+16>>2]&15](f,e+16|0,e,j-k);a=c[f+4>>2]|0;if(!(c[a+748>>2]|0)){i=e;return}d=c[a+740>>2]|0;b=c[(c[f+8>>2]|0)+8>>2]|0;if((d|0)==(b|0)){xA(a,d+4|0,(c[(c[f+12>>2]|0)+8>>2]|0)+4|0);i=e;return}else{xA(a,(c[(c[f+12>>2]|0)+8>>2]|0)+4|0,b+4|0);i=e;return}}function AB(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function BB(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;if(!(c[b+12>>2]|0)){i=e;return}if(!(a[b+8>>0]|0)){i=e;return}h=c[d+4>>2]|0;if((h|0)==(c[d+8>>2]|0)?(f=(h|0)==0?1:h<<1,(h|0)<(f|0)):0){if(!f)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[d+4>>2]|0}if((h|0)>0){j=0;do{k=g+(j<<2)|0;if(k)c[k>>2]=c[(c[d+12>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+12>>2]|0;if(j){if(a[d+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=g;c[d+8>>2]=f}f=(c[d+12>>2]|0)+(h<<2)|0;if(f)c[f>>2]=c[b+12>>2];c[d+4>>2]=h+1;i=e;return}function CB(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=16904;if((a[b+8>>0]|0)!=0?(e=c[b+12>>2]|0,(e|0)!=0):0){f=c[b+4>>2]|0;Nb[c[(c[f>>2]|0)+16>>2]&127](f,e)}gF(b);i=d;return}function DB(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=16904;if(!(a[b+8>>0]|0)){i=d;return}e=c[b+12>>2]|0;if(!e){i=d;return}b=c[b+4>>2]|0;Nb[c[(c[b>>2]|0)+16>>2]&127](b,e);i=d;return}function EB(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0;j=i;i=i+160|0;k=c[b+12>>2]|0;if(!k){i=j;return}l=(a[b+16>>0]|0)!=0;m=l?e:d;d=l?d:e;o=c[m+4>>2]|0;e=c[d+4>>2]|0;c[h+4>>2]=k;n=+g[(c[b+12>>2]|0)+752>>2];c[j+136>>2]=17768;c[j+140>>2]=o;c[j+144>>2]=e;g[j+148>>2]=n;g[j+128>>2]=999999984306749400.0;e=c[m+12>>2]|0;c[j+0>>2]=c[e+0>>2];c[j+4>>2]=c[e+4>>2];c[j+8>>2]=c[e+8>>2];c[j+12>>2]=c[e+12>>2];c[j+16>>2]=c[e+16>>2];c[j+20>>2]=c[e+20>>2];c[j+24>>2]=c[e+24>>2];c[j+28>>2]=c[e+28>>2];c[j+32>>2]=c[e+32>>2];c[j+36>>2]=c[e+36>>2];c[j+40>>2]=c[e+40>>2];c[j+44>>2]=c[e+44>>2];c[j+48>>2]=c[e+48>>2];c[j+52>>2]=c[e+52>>2];c[j+56>>2]=c[e+56>>2];c[j+60>>2]=c[e+60>>2];d=c[d+12>>2]|0;c[j+64>>2]=c[d+0>>2];c[j+68>>2]=c[d+4>>2];c[j+72>>2]=c[d+8>>2];c[j+76>>2]=c[d+12>>2];c[j+80>>2]=c[d+16>>2];c[j+84>>2]=c[d+20>>2];c[j+88>>2]=c[d+24>>2];c[j+92>>2]=c[d+28>>2];c[j+96>>2]=c[d+32>>2];c[j+100>>2]=c[d+36>>2];c[j+104>>2]=c[d+40>>2];c[j+108>>2]=c[d+44>>2];c[j+112>>2]=c[d+48>>2];c[j+116>>2]=c[d+52>>2];c[j+120>>2]=c[d+56>>2];c[j+124>>2]=c[d+60>>2];xC(j+136|0,j,h,c[f+20>>2]|0,l);if(!(a[b+8>>0]|0)){i=j;return}b=c[h+4>>2]|0;if(!(c[b+748>>2]|0)){i=j;return}k=c[b+740>>2]|0;e=c[(c[h+8>>2]|0)+8>>2]|0;if((k|0)==(e|0)){xA(b,k+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);i=j;return}else{xA(b,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,e+4|0);i=j;return}}function FB(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function GB(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;if(!(c[b+12>>2]|0)){i=e;return}if(!(a[b+8>>0]|0)){i=e;return}h=c[d+4>>2]|0;if((h|0)==(c[d+8>>2]|0)?(f=(h|0)==0?1:h<<1,(h|0)<(f|0)):0){if(!f)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[d+4>>2]|0}if((h|0)>0){j=0;do{k=g+(j<<2)|0;if(k)c[k>>2]=c[(c[d+12>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+12>>2]|0;if(j){if(a[d+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=g;c[d+8>>2]=f}f=(c[d+12>>2]|0)+(h<<2)|0;if(f)c[f>>2]=c[b+12>>2];c[d+4>>2]=h+1;i=e;return}function HB(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function IB(a){a=a|0;return}function JB(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;g[c>>2]=-999999984306749400.0;g[c+4>>2]=-999999984306749400.0;g[c+8>>2]=-999999984306749400.0;g[c+12>>2]=0.0;g[d>>2]=999999984306749400.0;g[d+4>>2]=999999984306749400.0;g[d+8>>2]=999999984306749400.0;g[d+12>>2]=0.0;return}function KB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;f=i;i=i+48|0;k=+g[e>>2];l=+g[d>>2];h=+g[e+4>>2];j=+g[d+4>>2];m=+g[e+8>>2];o=+g[d+8>>2];t=+Q(+((k-l)*.5*(k-l)*.5+(h-j)*.5*(h-j)*.5+(m-o)*.5*(m-o)*.5));p=+g[a+56>>2];if(+P(+p)>.7071067690849304){n=+g[a+52>>2];s=1.0/+Q(+(p*p+n*n));y=+g[a+48>>2];q=y;x=n;r=0.0;w=-(p*s);v=n*s;u=(p*p+n*n)*s;n=-(y*n*s);s=y*-(p*s)}else{z=+g[a+48>>2];y=+g[a+52>>2];s=1.0/+Q(+(z*z+y*y));q=z;x=y;r=-(y*s);w=z*s;v=0.0;u=-(p*z*s);n=p*-(y*s);s=(z*z+y*y)*s}z=(k+l)*.5*q+(h+j)*.5*x+(m+o)*.5*p- +g[a+64>>2];j=(h+j)*.5-x*z;q=(k+l)*.5-q*z;r=t*r;w=t*w;y=t*v;u=t*u;v=t*n;x=t*s;g[f>>2]=u+(r+q);g[f+4>>2]=v+(w+j);g[f+8>>2]=x+(y+((m+o)*.5-p*z));g[f+12>>2]=0.0;g[f+16>>2]=r+q-u;g[f+20>>2]=w+j-v;g[f+24>>2]=y+((m+o)*.5-p*z)-x;g[f+28>>2]=0.0;g[f+32>>2]=q-r-u;g[f+36>>2]=j-w-v;g[f+40>>2]=(m+o)*.5-p*z-y-x;g[f+44>>2]=0.0;vc[c[(c[b>>2]|0)+8>>2]&127](b,f,0,0);g[f>>2]=q-r-u;g[f+4>>2]=j-w-v;g[f+8>>2]=(m+o)*.5-p*z-y-x;g[f+12>>2]=0.0;g[f+16>>2]=u+(q-r);g[f+20>>2]=v+(j-w);g[f+24>>2]=x+((m+o)*.5-p*z-y);g[f+28>>2]=0.0;g[f+32>>2]=u+(r+q);g[f+36>>2]=v+(w+j);g[f+40>>2]=x+(y+((m+o)*.5-p*z));g[f+44>>2]=0.0;vc[c[(c[b>>2]|0)+8>>2]&127](b,f,0,1);i=f;return}function LB(a,b,d){a=a|0;b=+b;d=d|0;a=i;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;i=a;return}function MB(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+68>>2]=c[b+0>>2];c[a+72>>2]=c[b+4>>2];c[a+76>>2]=c[b+8>>2];c[a+80>>2]=c[b+12>>2];i=d;return}function NB(a){a=a|0;return a+68|0}function OB(a){a=a|0;return 17128}function PB(a){a=a|0;return 52}function QB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;e=i;f=gc[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=gc[c[(c[d>>2]|0)+28>>2]&31](d,f)|0;c[b>>2]=h;if(h)Nb[c[(c[d>>2]|0)+48>>2]&127](d,f);c[b+4>>2]=c[a+4>>2];g[b+12>>2]=+g[a+68>>2];g[b+16>>2]=+g[a+72>>2];g[b+20>>2]=+g[a+76>>2];g[b+24>>2]=+g[a+80>>2];g[b+28>>2]=+g[a+48>>2];g[b+32>>2]=+g[a+52>>2];g[b+36>>2]=+g[a+56>>2];g[b+40>>2]=+g[a+60>>2];g[b+44>>2]=+g[a+64>>2];i=e;return 17104}function RB(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0,ca=0,da=0,ea=0.0,fa=0,ga=0.0;k=i;i=i+128|0;fa=c[b+4>>2]|0;a[fa+312>>0]=0;c[fa>>2]=0;a[fa+356>>0]=1;g[fa+292>>2]=999999984306749400.0;g[fa+296>>2]=999999984306749400.0;g[fa+300>>2]=999999984306749400.0;g[fa+304>>2]=0.0;c[fa+336>>2]=0;c[fa+340>>2]=0;c[fa+344>>2]=0;c[fa+348>>2]=0;a[fa+352>>0]=0;a[fa+332>>0]=a[fa+332>>0]&-16;O=+g[d+48>>2];V=+g[d+52>>2];R=+g[d+56>>2];Y=+g[f+48>>2];W=+g[f+52>>2];P=+g[f+56>>2];D=+g[d>>2];p=+g[d+4>>2];r=+g[d+8>>2];E=+g[d+16>>2];z=+g[d+20>>2];s=+g[d+24>>2];w=+g[d+32>>2];q=+g[d+36>>2];t=+g[d+40>>2];u=+g[f>>2];x=+g[f+4>>2];A=+g[f+8>>2];v=+g[f+16>>2];y=+g[f+20>>2];B=+g[f+24>>2];F=+g[f+32>>2];o=+g[f+36>>2];C=+g[f+40>>2];m=+g[e+48>>2]-O-(+g[h+48>>2]-Y);l=+g[e+52>>2]-V-(+g[h+52>>2]-W);n=+g[e+56>>2]-R-(+g[h+56>>2]-P);fa=c[b+8>>2]|0;da=c[(c[fa>>2]|0)+64>>2]|0;g[k+96>>2]=D*-m+E*-l+w*-n;g[k+100>>2]=p*-m+z*-l+q*-n;g[k+104>>2]=r*-m+s*-l+t*-n;g[k+108>>2]=0.0;rc[da&127](k+112|0,fa,k+96|0);aa=+g[k+112>>2];ea=+g[k+116>>2];X=+g[k+120>>2];Z=aa*+g[d>>2]+ea*+g[d+4>>2]+X*+g[d+8>>2]+ +g[d+48>>2];_=aa*+g[d+16>>2]+ea*+g[d+20>>2]+X*+g[d+24>>2]+ +g[d+52>>2];X=aa*+g[d+32>>2]+ea*+g[d+36>>2]+X*+g[d+40>>2]+ +g[d+56>>2];fa=c[b+12>>2]|0;da=c[(c[fa>>2]|0)+64>>2]|0;ea=m*+g[f+4>>2]+l*+g[f+20>>2]+n*+g[f+36>>2];aa=m*+g[f+8>>2]+l*+g[f+24>>2]+n*+g[f+40>>2];g[k+64>>2]=m*+g[f>>2]+l*+g[f+16>>2]+n*+g[f+32>>2];g[k+68>>2]=ea;g[k+72>>2]=aa;g[k+76>>2]=0.0;rc[da&127](k+80|0,fa,k+64|0);aa=+g[k+80>>2];ea=+g[k+84>>2];$=+g[k+88>>2];Z=Z-(aa*+g[f>>2]+ea*+g[f+4>>2]+$*+g[f+8>>2]+ +g[f+48>>2]);_=_-(aa*+g[f+16>>2]+ea*+g[f+20>>2]+$*+g[f+24>>2]+ +g[f+52>>2]);$=X-(aa*+g[f+32>>2]+ea*+g[f+36>>2]+$*+g[f+40>>2]+ +g[f+56>>2]);a:do if(Z*Z+_*_+$*$>9999999747378752.0e-20){S=0.0;U=0.0;X=0.0;T=0.0;H=0.0;G=32;aa=0.0;while(1){if(!G)break a;G=G+ -1|0;fa=c[b+8>>2]|0;da=c[(c[fa>>2]|0)+64>>2]|0;I=-Z;ga=-_;ea=-$;g[k+32>>2]=D*I+E*ga+w*ea;g[k+36>>2]=p*I+z*ga+q*ea;g[k+40>>2]=r*I+s*ga+t*ea;g[k+44>>2]=0.0;rc[da&127](k+48|0,fa,k+32|0);ea=+g[k+48>>2];ga=+g[k+52>>2];I=+g[k+56>>2];J=O+(D*ea+p*ga+r*I);L=V+(E*ea+z*ga+s*I);I=R+(w*ea+q*ga+t*I);fa=c[b+12>>2]|0;da=c[(c[fa>>2]|0)+64>>2]|0;g[k>>2]=u*Z+v*_+F*$;g[k+4>>2]=x*Z+y*_+o*$;g[k+8>>2]=A*Z+B*_+C*$;g[k+12>>2]=0.0;rc[da&127](k+16|0,fa,k);ga=+g[k+16>>2];ea=+g[k+20>>2];M=+g[k+24>>2];K=Y+(u*ga+x*ea+A*M);N=W+(v*ga+y*ea+B*M);M=P+(F*ga+o*ea+C*M);ea=Z*(J-K)+_*(L-N)+$*(I-M);if(H>1.0){j=0;h=24;break}if(ea>0.0){O=m*Z+l*_+n*$;if(O>=-1.4210854715202004e-14){j=0;h=24;break}H=H-ea/O;R=(1.0-H)*+g[d+56>>2]+H*+g[e+56>>2];V=(1.0-H)*+g[d+52>>2]+H*+g[e+52>>2];O=+g[d+48>>2]*(1.0-H)+H*+g[e+48>>2];P=(1.0-H)*+g[f+56>>2]+H*+g[h+56>>2];W=(1.0-H)*+g[f+52>>2]+H*+g[h+52>>2];Y=(1.0-H)*+g[f+48>>2]+H*+g[h+48>>2];T=aa;X=$;U=_;S=Z}ba=c[b+4>>2]|0;ca=c[ba>>2]|0;if((ca|0)>0){Z=+g[ba+308>>2];fa=0;da=0;do{aa=J-K- +g[ba+(da<<4)+4>>2];ea=L-N- +g[ba+(da<<4)+8>>2];ga=I-M- +g[ba+(da<<4)+12>>2];fa=fa|aa*aa+ea*ea+ga*ga<=Z;da=da+1|0}while((da|0)!=(ca|0))}else fa=0;if((+g[ba+304>>2]==0.0?I-M==+g[ba+300>>2]:0)?L-N==+g[ba+296>>2]:0)da=J-K==+g[ba+292>>2];else da=0;if(!(da|fa)){g[ba+292>>2]=J-K;g[ba+296>>2]=L-N;g[ba+300>>2]=I-M;g[ba+304>>2]=0.0;a[ba+356>>0]=1;g[ba+(ca<<4)+4>>2]=J-K;g[ba+(ca<<4)+8>>2]=L-N;g[ba+(ca<<4)+12>>2]=I-M;g[ba+(ca<<4)+16>>2]=0.0;fa=c[ba>>2]|0;g[ba+(fa<<4)+84>>2]=J;g[ba+(fa<<4)+88>>2]=L;g[ba+(fa<<4)+92>>2]=I;g[ba+(fa<<4)+96>>2]=0.0;fa=c[ba>>2]|0;g[ba+(fa<<4)+164>>2]=K;g[ba+(fa<<4)+168>>2]=N;g[ba+(fa<<4)+172>>2]=M;g[ba+(fa<<4)+176>>2]=0.0;c[ba>>2]=(c[ba>>2]|0)+1;ba=c[b+4>>2]|0}fa=vC(ba)|0;Z=+g[ba+276>>2];_=+g[ba+280>>2];$=+g[ba+284>>2];if(!fa)break a;if(!(Z*Z+_*_+$*$>9999999747378752.0e-20))break a;else aa=+g[ba+288>>2]}if((h|0)==24){i=k;return j|0}}else{T=0.0;X=0.0;U=0.0;S=0.0;H=0.0}while(0);g[j+164>>2]=H;o=X*X+(U*U+S*S);if(!(o>=1.4210854715202004e-14)){c[j+132>>2]=0;c[j+136>>2]=0;c[j+140>>2]=0;c[j+144>>2]=0;o=0.0;q=0.0;p=0.0}else{p=1.0/+Q(+o);o=S*p;q=U*p;p=X*p;g[j+132>>2]=o;g[j+136>>2]=q;g[j+140>>2]=p;g[j+144>>2]=T}if(m*o+l*q+n*p>=-+g[j+172>>2]){fa=0;i=k;return fa|0}fa=c[b+4>>2]|0;vC(fa)|0;nF(j+148|0,fa+260|0,16)|0;fa=1;i=k;return fa|0}function SB(a){a=a|0;return}function TB(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function UB(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0;f=i;g[b+4>>2]=1.0;g[b+8>>2]=1.0;g[b+12>>2]=1.0;g[b+16>>2]=0.0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+48>>2]=0;c[b>>2]=17304;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;a[b+164>>0]=d&1;a[b+165>>0]=e&1;g[b+168>>2]=0.0;c[5004]=(c[5004]|0)+1;e=fF(51)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}d=c[b+24>>2]|0;if((d|0)>0){h=0;do{j=e+(h<<5)|0;k=(c[b+32>>2]|0)+(h<<5)|0;c[j+0>>2]=c[k+0>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];c[j+16>>2]=c[k+16>>2];c[j+20>>2]=c[k+20>>2];c[j+24>>2]=c[k+24>>2];c[j+28>>2]=c[k+28>>2];h=h+1|0}while((h|0)!=(d|0))}d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[d+ -4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=e;c[b+28>>2]=1;k=c[b+24>>2]|0;c[e+(k<<5)>>2]=0;c[e+(k<<5)+4>>2]=0;c[e+(k<<5)+8>>2]=12;c[e+(k<<5)+12>>2]=0;c[e+(k<<5)+16>>2]=0;c[e+(k<<5)+20>>2]=16;c[e+(k<<5)+24>>2]=2;c[e+(k<<5)+28>>2]=0;c[b+24>>2]=(c[b+24>>2]|0)+1;if(!(a[b+164>>0]|0)){e=c[b+32>>2]|0;c[e>>2]=(c[b+148>>2]|0)/3|0;c[e+4>>2]=0;e=c[b+32>>2]|0;c[e+24>>2]=3;c[e+8>>2]=6}else{e=c[b+32>>2]|0;c[e>>2]=(c[b+128>>2]|0)/3|0;c[e+4>>2]=0;e=c[b+32>>2]|0;c[e+24>>2]=2;c[e+8>>2]=12}if(!(a[b+165>>0]|0)){c[e+12>>2]=(c[b+108>>2]|0)/3|0;c[e+16>>2]=0;c[(c[b+32>>2]|0)+20>>2]=12;i=f;return}else{c[e+12>>2]=c[b+88>>2];c[e+16>>2]=0;c[(c[b+32>>2]|0)+20>>2]=16;i=f;return}}function VB(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;if(!(a[d+164>>0]|0)){j=c[d+148>>2]|0;if((j|0)==(c[d+152>>2]|0)?(g=(j|0)==0?1:j<<1,(j|0)<(g|0)):0){if(!g)h=0;else{c[5004]=(c[5004]|0)+1;h=fF((g<<1)+19|0)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}j=c[d+148>>2]|0}if((j|0)>0){k=0;do{l=h+(k<<1)|0;if(l)b[l>>1]=b[(c[d+156>>2]|0)+(k<<1)>>1]|0;k=k+1|0}while((k|0)!=(j|0))}k=c[d+156>>2]|0;if(k){if(a[d+160>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0);j=c[d+148>>2]|0}c[d+156>>2]=0}a[d+160>>0]=1;c[d+156>>2]=h;c[d+152>>2]=g}g=c[d+156>>2]|0;h=g+(j<<1)|0;if(h)b[h>>1]=e;c[d+148>>2]=j+1;c[(c[d+32>>2]|0)+4>>2]=g;i=f;return}else{l=c[d+128>>2]|0;if((l|0)==(c[d+132>>2]|0)?(h=(l|0)==0?1:l<<1,(l|0)<(h|0)):0){if(!h)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((h<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}l=c[d+128>>2]|0}if((l|0)>0){j=0;do{k=g+(j<<2)|0;if(k)c[k>>2]=c[(c[d+136>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(l|0))}j=c[d+136>>2]|0;if(j){if(a[d+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=g;c[d+132>>2]=h;l=c[d+128>>2]|0}g=c[d+136>>2]|0;h=g+(l<<2)|0;if(h){c[h>>2]=e;l=c[d+128>>2]|0}c[d+128>>2]=l+1;c[(c[d+32>>2]|0)+4>>2]=g;i=f;return}}function WB(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0;f=i;if(a[b+165>>0]|0){a:do if(e?(j=c[b+88>>2]|0,(j|0)>0):0){e=c[b+96>>2]|0;o=+g[d>>2];p=+g[d+4>>2];m=+g[d+8>>2];n=+g[b+168>>2];k=0;while(1){t=+g[e+(k<<4)>>2]-o;s=+g[e+(k<<4)+4>>2]-p;r=+g[e+(k<<4)+8>>2]-m;if(t*t+s*s+r*r<=n)break;k=k+1|0;if((k|0)>=(j|0))break a}i=f;return k|0}while(0);e=(c[b+32>>2]|0)+12|0;c[e>>2]=(c[e>>2]|0)+1;e=c[b+88>>2]|0;if((e|0)==(c[b+92>>2]|0)?(h=(e|0)==0?1:e<<1,(e|0)<(h|0)):0){if(!h)j=0;else{c[5004]=(c[5004]|0)+1;j=fF((h<<4|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+ -4>>2]=j;j=j+19&-16}e=c[b+88>>2]|0}if((e|0)>0){k=0;do{q=j+(k<<4)|0;l=(c[b+96>>2]|0)+(k<<4)|0;c[q+0>>2]=c[l+0>>2];c[q+4>>2]=c[l+4>>2];c[q+8>>2]=c[l+8>>2];c[q+12>>2]=c[l+12>>2];k=k+1|0}while((k|0)!=(e|0))}e=c[b+96>>2]|0;if(e){if(a[b+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=j;c[b+92>>2]=h;e=c[b+88>>2]|0}q=(c[b+96>>2]|0)+(e<<4)|0;c[q+0>>2]=c[d+0>>2];c[q+4>>2]=c[d+4>>2];c[q+8>>2]=c[d+8>>2];c[q+12>>2]=c[d+12>>2];q=c[b+88>>2]|0;c[b+88>>2]=q+1;c[(c[b+32>>2]|0)+16>>2]=c[b+96>>2];i=f;return q|0}j=c[b+108>>2]|0;b:do if((j|0)>0&e){e=c[b+116>>2]|0;m=+g[d>>2];n=+g[d+4>>2];o=+g[d+8>>2];p=+g[b+168>>2];h=0;while(1){r=+g[e+(h<<2)>>2]-m;s=+g[e+(h+1<<2)>>2]-n;t=+g[e+(h+2<<2)>>2]-o;k=h+3|0;if(r*r+s*s+t*t<=p)break;if((k|0)<(j|0))h=k;else{h=d;break b}}q=(h|0)/3|0;i=f;return q|0}else h=d;while(0);e=c[b+112>>2]|0;if((j|0)==(e|0)){e=(j|0)==0?1:j<<1;if((j|0)<(e|0)){if(!e)k=0;else{c[5004]=(c[5004]|0)+1;j=fF((e<<2|3)+16|0)|0;if(!j)k=0;else{c[(j+19&-16)+ -4>>2]=j;k=j+19&-16}j=c[b+108>>2]|0}if((j|0)>0){l=0;do{q=k+(l<<2)|0;if(q)g[q>>2]=+g[(c[b+116>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(j|0))}l=c[b+116>>2]|0;if(l){if(a[b+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0);j=c[b+108>>2]|0}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=k;c[b+112>>2]=e;l=j}else{l=j;e=j}}else l=j;k=c[b+116>>2]|0;j=k+(l<<2)|0;if(j)g[j>>2]=+g[h>>2];j=l+1|0;c[b+108>>2]=j;if((j|0)==(e|0)){h=(e|0)==0?1:e<<1;if((e|0)<(h|0)){if(!h)k=0;else{c[5004]=(c[5004]|0)+1;j=fF((h<<2|3)+16|0)|0;if(!j)k=0;else{c[(j+19&-16)+ -4>>2]=j;k=j+19&-16}e=c[b+108>>2]|0}if((e|0)>0){j=0;do{l=k+(j<<2)|0;if(l)g[l>>2]=+g[(c[b+116>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(e|0))}j=c[b+116>>2]|0;if(j){if(a[b+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);e=c[b+108>>2]|0}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=k;c[b+112>>2]=h;j=e}else{j=e;h=e}}else h=e;e=k+(j<<2)|0;if(e)g[e>>2]=+g[d+4>>2];j=j+1|0;c[b+108>>2]=j;if((j|0)==(h|0)){j=(h|0)==0?1:h<<1;if((h|0)<(j|0)){if(!j)k=0;else{c[5004]=(c[5004]|0)+1;h=fF((j<<2|3)+16|0)|0;if(!h)k=0;else{c[(h+19&-16)+ -4>>2]=h;k=h+19&-16}h=c[b+108>>2]|0}if((h|0)>0){e=0;do{l=k+(e<<2)|0;if(l)g[l>>2]=+g[(c[b+116>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(h|0))}e=c[b+116>>2]|0;if(e){if(a[b+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0);h=c[b+108>>2]|0}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=k;c[b+112>>2]=j}}else h=j;j=k+(h<<2)|0;if(j)g[j>>2]=+g[d+8>>2];c[b+108>>2]=h+1;q=c[b+32>>2]|0;c[q+12>>2]=(c[q+12>>2]|0)+1;c[q+16>>2]=k;q=((c[b+108>>2]|0)/3|0)+ -1|0;i=f;return q|0}function XB(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0;e=i;if(a[b+165>>0]|0){if((c[b+92>>2]|0)>=(d|0)){i=e;return}if((d|0)!=0?(c[5004]=(c[5004]|0)+1,h=fF((d<<4|3)+16|0)|0,(h|0)!=0):0){c[(h+19&-16)+ -4>>2]=h;f=h+19&-16}else f=0;h=c[b+88>>2]|0;if((h|0)>0){j=0;do{k=f+(j<<4)|0;l=(c[b+96>>2]|0)+(j<<4)|0;c[k+0>>2]=c[l+0>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];j=j+1|0}while((j|0)!=(h|0))}h=c[b+96>>2]|0;if(h){if(a[b+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=f;c[b+92>>2]=d;i=e;return}if((c[b+112>>2]|0)>=(d|0)){i=e;return}if((d|0)!=0?(c[5004]=(c[5004]|0)+1,f=fF((d<<2|3)+16|0)|0,(f|0)!=0):0){c[(f+19&-16)+ -4>>2]=f;f=f+19&-16}else f=0;h=c[b+108>>2]|0;if((h|0)>0){k=0;do{j=f+(k<<2)|0;if(j)g[j>>2]=+g[(c[b+116>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(h|0))}h=c[b+116>>2]|0;if(h){if(a[b+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=f;c[b+112>>2]=d;i=e;return}function YB(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;if(!(a[d+164>>0]|0)){if((c[d+152>>2]|0)>=(e|0)){i=f;return}if((e|0)!=0?(c[5004]=(c[5004]|0)+1,h=fF((e<<1)+19|0)|0,(h|0)!=0):0){c[(h+19&-16)+ -4>>2]=h;g=h+19&-16}else g=0;h=c[d+148>>2]|0;if((h|0)>0){k=0;do{j=g+(k<<1)|0;if(j)b[j>>1]=b[(c[d+156>>2]|0)+(k<<1)>>1]|0;k=k+1|0}while((k|0)!=(h|0))}h=c[d+156>>2]|0;if(h){if(a[d+160>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[d+156>>2]=0}a[d+160>>0]=1;c[d+156>>2]=g;c[d+152>>2]=e;i=f;return}else{if((c[d+132>>2]|0)>=(e|0)){i=f;return}if((e|0)!=0?(c[5004]=(c[5004]|0)+1,g=fF((e<<2|3)+16|0)|0,(g|0)!=0):0){c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}else g=0;k=c[d+128>>2]|0;if((k|0)>0){j=0;do{h=g+(j<<2)|0;if(h)c[h>>2]=c[(c[d+136>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(k|0))}h=c[d+136>>2]|0;if(h){if(a[d+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=g;c[d+132>>2]=e;i=f;return}}function ZB(a){a=a|0;var b=0;b=i;dC(a);i=b;return}function _B(a){a=a|0;var b=0;b=i;dC(a);if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function $B(a,b){a=a|0;b=b|0;return}function aC(a,b){a=a|0;b=b|0;return}function bC(a){a=a|0;return c[a+24>>2]|0}function cC(a){a=a|0;return 28}function dC(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=17304;e=c[b+156>>2]|0;if(e){if(a[b+160>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;e=c[b+136>>2]|0;if(e){if(a[b+140>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;e=c[b+116>>2]|0;if(e){if(a[b+120>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;e=c[b+96>>2]|0;if(e){if(a[b+100>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b>>2]=19904;e=c[b+32>>2]|0;if(!e){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;e=b+28|0;c[e>>2]=0;i=d;return}if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;e=b+28|0;c[e>>2]=0;i=d;return}function eC(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function fC(a){a=a|0;return}function gC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0;f=i;q=(+g[a+32>>2]- +g[a+16>>2])*.5;n=(+g[a+36>>2]- +g[a+20>>2])*.5;k=(+g[a+40>>2]- +g[a+24>>2])*.5;p=+$b[c[(c[a>>2]|0)+48>>2]&15](a);m=+$b[c[(c[a>>2]|0)+48>>2]&15](a);k=k+ +$b[c[(c[a>>2]|0)+48>>2]&15](a);D=(+g[a+32>>2]+ +g[a+16>>2])*.5;B=(+g[a+36>>2]+ +g[a+20>>2])*.5;z=(+g[a+40>>2]+ +g[a+24>>2])*.5;H=+g[b>>2];y=+P(+H);G=+g[b+4>>2];x=+P(+G);v=+g[b+8>>2];w=+P(+v);F=+g[b+16>>2];u=+P(+F);E=+g[b+20>>2];t=+P(+E);r=+g[b+24>>2];s=+P(+r);C=+g[b+32>>2];o=+P(+C);A=+g[b+36>>2];l=+P(+A);h=+g[b+40>>2];j=+P(+h);v=D*H+B*G+z*v+ +g[b+48>>2];r=D*F+B*E+z*r+ +g[b+52>>2];h=D*C+B*A+z*h+ +g[b+56>>2];g[d>>2]=v-((q+p)*y+(n+m)*x+k*w);g[d+4>>2]=r-((q+p)*u+(n+m)*t+k*s);g[d+8>>2]=h-((q+p)*o+(n+m)*l+k*j);g[d+12>>2]=0.0;g[e>>2]=(q+p)*y+(n+m)*x+k*w+v;g[e+4>>2]=(q+p)*u+(n+m)*t+k*s+r;g[e+8>>2]=(q+p)*o+(n+m)*l+k*j+h;g[e+12>>2]=0.0;i=f;return}function hC(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+48|0;e=(c[a+48>>2]|0)+4|0;c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+32>>2]=1.0;rc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+32>>2]=+g[d+16>>2]+ +g[a+12>>2];g[d+32>>2]=-1.0;rc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+16>>2]=+g[d+16>>2]- +g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+36>>2]=1.0;rc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+36>>2]=+g[d+20>>2]+ +g[a+12>>2];g[d+36>>2]=-1.0;rc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+20>>2]=+g[d+20>>2]- +g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+40>>2]=1.0;rc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+40>>2]=+g[d+24>>2]+ +g[a+12>>2];g[d+40>>2]=-1.0;rc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+24>>2]=+g[d+24>>2]- +g[a+12>>2];i=d;return}function iC(a){a=a|0;return(c[a+48>>2]|0)+4|0}function jC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+48|0;c[f>>2]=17624;c[f+4>>2]=b;c[f+8>>2]=c[d+0>>2];c[f+12>>2]=c[d+4>>2];c[f+16>>2]=c[d+8>>2];c[f+20>>2]=c[d+12>>2];c[f+24>>2]=c[e+0>>2];c[f+28>>2]=c[e+4>>2];c[f+32>>2]=c[e+8>>2];c[f+36>>2]=c[e+12>>2];b=c[a+48>>2]|0;vc[c[(c[b>>2]|0)+8>>2]&127](b,f,d,e);i=f;return}function kC(a,b,d){a=a|0;b=+b;d=d|0;a=i;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;i=a;return}function lC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+176|0;c[e+160>>2]=0;c[e+164>>2]=0;c[e+168>>2]=0;c[e+172>>2]=0;c[e+136>>2]=0;c[e+140>>2]=0;c[e+144>>2]=0;c[e+148>>2]=0;c[e+152>>2]=0;c[e+32>>2]=17560;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=c[e+160>>2];c[e+60>>2]=c[e+164>>2];c[e+64>>2]=c[e+168>>2];c[e+68>>2]=0;g[e+72>>2]=1.0;c[e+76>>2]=0;c[e+80>>2]=0;c[e+84>>2]=0;c[e+88>>2]=0;g[e+92>>2]=1.0;g[e+96>>2]=0.0;c[e+100>>2]=c[e+140>>2];c[e+104>>2]=c[e+144>>2];c[e+108>>2]=c[e+148>>2];c[e+112>>2]=c[e+152>>2];g[e+116>>2]=-999999984306749400.0;l=+g[d>>2];k=+g[d+4>>2];j=+g[d+8>>2];h=l*+g[e+56>>2]+k+j*0.0;f=l*+g[e+60>>2]+k*0.0+j;g[e+120>>2]=l+k*0.0+j*0.0;g[e+124>>2]=h;g[e+128>>2]=f;g[e+132>>2]=0.0;g[e+16>>2]=999999984306749400.0;g[e+20>>2]=999999984306749400.0;g[e+24>>2]=999999984306749400.0;g[e+28>>2]=0.0;d=c[(c[b>>2]|0)+64>>2]|0;g[e>>2]=-999999984306749400.0;g[e+4>>2]=-999999984306749400.0;g[e+8>>2]=-999999984306749400.0;g[e+12>>2]=0.0;vc[d&127](b,e+32|0,e,e+16|0);c[a+0>>2]=c[e+36>>2];c[a+4>>2]=c[e+40>>2];c[a+8>>2]=c[e+44>>2];c[a+12>>2]=c[e+48>>2];i=e;return}function mC(a){a=a|0;return}function nC(a){a=a|0;return 17536}function oC(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function pC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;f=+g[a+88>>2];j=+g[a+92>>2];h=+g[a+96>>2];k=f*+g[b>>2]+j*+g[b+4>>2]+h*+g[b+8>>2];l=+g[a+84>>2];if(k>l){g[a+84>>2]=k;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2]}else k=l;l=f*+g[b+16>>2]+j*+g[b+20>>2]+h*+g[b+24>>2];if(l>k){g[a+84>>2]=l;c[a+4>>2]=c[b+16>>2];c[a+8>>2]=c[b+20>>2];c[a+12>>2]=c[b+24>>2];c[a+16>>2]=c[b+28>>2];k=l}f=f*+g[b+32>>2]+j*+g[b+36>>2]+h*+g[b+40>>2];if(!(f>k)){i=e;return}g[a+84>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+8>>2]=c[b+36>>2];c[a+12>>2]=c[b+40>>2];c[a+16>>2]=c[b+44>>2];i=e;return}function qC(a){a=a|0;return}function rC(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function sC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0;f=i;k=+g[b>>2];j=+g[b+16>>2];l=k<j?k:j;h=+g[b+32>>2];if((l<h?l:h)>+g[a+24>>2]){i=f;return}m=k>j?b:b+16|0;if(+g[(+g[m>>2]>h?m:b+32|0)>>2]<+g[a+8>>2]){i=f;return}h=+g[b+8>>2];j=+g[b+24>>2];l=h<j?h:j;k=+g[b+40>>2];if((l<k?l:k)>+g[a+32>>2]){i=f;return}m=h>j?b+8|0:b+24|0;if(+g[(+g[m>>2]>k?m:b+40|0)>>2]<+g[a+16>>2]){i=f;return}h=+g[b+4>>2];j=+g[b+20>>2];l=h<j?h:j;k=+g[b+36>>2];if((l<k?l:k)>+g[a+28>>2]){i=f;return}m=h>j?b+4|0:b+20|0;if(+g[(+g[m>>2]>k?m:b+36|0)>>2]<+g[a+12>>2]){i=f;return}m=c[a+4>>2]|0;vc[c[(c[m>>2]|0)+8>>2]&127](m,b,d,e);i=f;return}function tC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;while(1){f=c[a+12>>2]|0;g=c[f+(((b+d|0)/2|0)<<3)>>2]|0;k=b;h=d;while(1){while(1){l=k+1|0;if((c[f+(k<<3)>>2]|0)<(g|0))k=l;else{j=h;break}}while(1){m=f+(j<<3)|0;h=j+ -1|0;if((g|0)<(c[m>>2]|0))j=h;else break}if((k|0)>(j|0))h=j;else{k=f+(k<<3)|0;n=c[k>>2]|0;f=c[k+4>>2]|0;o=c[m+4>>2]|0;c[k>>2]=c[m>>2];c[k+4>>2]=o;k=(c[a+12>>2]|0)+(j<<3)|0;c[k>>2]=n;c[k+4>>2]=f;k=l}if((k|0)>(h|0))break;f=c[a+12>>2]|0}if((h|0)>(b|0))tC(a,b,h);if((k|0)<(d|0))b=k;else break}i=e;return}function uC(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;h=c[b>>2]|0;if((h|0)>3){g=a[d>>0]|0;if(!(g&8)){c[b>>2]=h+ -1;f=b+(h+ -1<<4)+4|0;c[b+52>>2]=c[f+0>>2];c[b+56>>2]=c[f+4>>2];c[b+60>>2]=c[f+8>>2];c[b+64>>2]=c[f+12>>2];f=b+(h+ -1<<4)+84|0;c[b+132>>2]=c[f+0>>2];c[b+136>>2]=c[f+4>>2];c[b+140>>2]=c[f+8>>2];c[b+144>>2]=c[f+12>>2];f=b+(h+ -1<<4)+164|0;c[b+212>>2]=c[f+0>>2];c[b+216>>2]=c[f+4>>2];c[b+220>>2]=c[f+8>>2];c[b+224>>2]=c[f+12>>2];h=h+ -1|0;f=4}else f=6}else f=4;if((f|0)==4)if((h|0)>2){g=a[d>>0]|0;f=6}else g=h;if((f|0)==6)if(!(g&4)){g=h+ -1|0;c[b>>2]=g;c[b+36>>2]=c[b+(g<<4)+4>>2];c[b+40>>2]=c[b+(g<<4)+8>>2];c[b+44>>2]=c[b+(g<<4)+12>>2];c[b+48>>2]=c[b+(g<<4)+16>>2];c[b+116>>2]=c[b+(g<<4)+84>>2];c[b+120>>2]=c[b+(g<<4)+88>>2];c[b+124>>2]=c[b+(g<<4)+92>>2];c[b+128>>2]=c[b+(g<<4)+96>>2];c[b+196>>2]=c[b+(g<<4)+164>>2];c[b+200>>2]=c[b+(g<<4)+168>>2];c[b+204>>2]=c[b+(g<<4)+172>>2];c[b+208>>2]=c[b+(g<<4)+176>>2]}else g=h;if((g|0)>1){h=a[d>>0]|0;if(!(h&2)){g=g+ -1|0;c[b>>2]=g;c[b+20>>2]=c[b+(g<<4)+4>>2];c[b+24>>2]=c[b+(g<<4)+8>>2];c[b+28>>2]=c[b+(g<<4)+12>>2];c[b+32>>2]=c[b+(g<<4)+16>>2];c[b+100>>2]=c[b+(g<<4)+84>>2];c[b+104>>2]=c[b+(g<<4)+88>>2];c[b+108>>2]=c[b+(g<<4)+92>>2];c[b+112>>2]=c[b+(g<<4)+96>>2];c[b+180>>2]=c[b+(g<<4)+164>>2];c[b+184>>2]=c[b+(g<<4)+168>>2];c[b+188>>2]=c[b+(g<<4)+172>>2];c[b+192>>2]=c[b+(g<<4)+176>>2];f=11}else d=h}else f=11;do if((f|0)==11)if((g|0)>0){d=a[d>>0]|0;break}else{i=e;return}while(0);if(d&1){i=e;return}h=g+ -1|0;c[b>>2]=h;c[b+4>>2]=c[b+(h<<4)+4>>2];c[b+8>>2]=c[b+(h<<4)+8>>2];c[b+12>>2]=c[b+(h<<4)+12>>2];c[b+16>>2]=c[b+(h<<4)+16>>2];c[b+84>>2]=c[b+(h<<4)+84>>2];c[b+88>>2]=c[b+(h<<4)+88>>2];c[b+92>>2]=c[b+(h<<4)+92>>2];c[b+96>>2]=c[b+(h<<4)+96>>2];c[b+164>>2]=c[b+(h<<4)+164>>2];c[b+168>>2]=c[b+(h<<4)+168>>2];c[b+172>>2]=c[b+(h<<4)+172>>2];c[b+176>>2]=c[b+(h<<4)+176>>2];i=e;return}function vC(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0.0,L=0.0,M=0,N=0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0,T=0;d=i;i=i+80|0;if(!(a[b+356>>0]|0)){T=a[b+312>>0]|0;T=T<<24>>24!=0;i=d;return T|0}c[b+336>>2]=0;c[b+340>>2]=0;c[b+344>>2]=0;c[b+348>>2]=0;a[b+352>>0]=0;J=a[b+332>>0]|0;a[b+332>>0]=J&-16;a[b+356>>0]=0;switch(c[b>>2]|0){case 1:{c[b+244>>2]=c[b+84>>2];c[b+248>>2]=c[b+88>>2];c[b+252>>2]=c[b+92>>2];c[b+256>>2]=c[b+96>>2];c[b+260>>2]=c[b+164>>2];c[b+264>>2]=c[b+168>>2];c[b+268>>2]=c[b+172>>2];c[b+272>>2]=c[b+176>>2];Q=+g[b+248>>2]- +g[b+264>>2];R=+g[b+252>>2]- +g[b+268>>2];g[b+276>>2]=+g[b+244>>2]- +g[b+260>>2];g[b+280>>2]=Q;g[b+284>>2]=R;g[b+288>>2]=0.0;c[b+336>>2]=0;c[b+340>>2]=0;c[b+344>>2]=0;c[b+348>>2]=0;a[b+352>>0]=0;a[b+332>>0]=J&-16;g[b+336>>2]=1.0;g[b+340>>2]=0.0;g[b+344>>2]=0.0;g[b+348>>2]=0.0;a[b+312>>0]=1;T=1;T=T<<24>>24!=0;i=d;return T|0};case 4:{c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;j=d+48|0;a[j>>0]=0;c[b+316>>2]=c[d+0>>2];c[b+320>>2]=c[d+4>>2];c[b+324>>2]=c[d+8>>2];c[b+328>>2]=c[d+12>>2];a[b+332>>0]=J|15;G=+g[b+20>>2];P=+g[b+4>>2];C=+g[b+24>>2];Q=+g[b+8>>2];E=+g[b+28>>2];O=+g[b+12>>2];F=+g[b+36>>2];L=+g[b+40>>2];I=+g[b+44>>2];H=+g[b+52>>2];K=+g[b+56>>2];D=+g[b+60>>2];R=(H-P)*((C-Q)*(I-O)-(E-O)*(L-Q))+(K-Q)*((E-O)*(F-P)-(G-P)*(I-O))+((G-P)*(L-Q)-(C-Q)*(F-P))*(D-O);if(R*R<9.99999905104687e-9)N=-1;else N=R*(((E-O)*(F-P)-(G-P)*(I-O))*(0.0-Q)+((C-Q)*(I-O)-(E-O)*(L-Q))*(0.0-P)+((G-P)*(L-Q)-(C-Q)*(F-P))*(0.0-O))<0.0&1;R=(G-P)*((L-Q)*(D-O)-(I-O)*(K-Q))+(C-Q)*((I-O)*(H-P)-(F-P)*(D-O))+((F-P)*(K-Q)-(L-Q)*(H-P))*(E-O);if(R*R<9.99999905104687e-9)M=-1;else M=R*(((I-O)*(H-P)-(F-P)*(D-O))*(0.0-Q)+((L-Q)*(D-O)-(I-O)*(K-Q))*(0.0-P)+((F-P)*(K-Q)-(L-Q)*(H-P))*(0.0-O))<0.0&1;R=(F-P)*((K-Q)*(E-O)-(D-O)*(C-Q))+(L-Q)*((D-O)*(G-P)-(H-P)*(E-O))+((H-P)*(C-Q)-(K-Q)*(G-P))*(I-O);if(R*R<9.99999905104687e-9)J=-1;else J=R*(((D-O)*(G-P)-(H-P)*(E-O))*(0.0-Q)+((K-Q)*(E-O)-(D-O)*(C-Q))*(0.0-P)+((H-P)*(C-Q)-(K-Q)*(G-P))*(0.0-O))<0.0&1;O=(P-G)*((K-C)*(I-E)-(D-E)*(L-C))+(Q-C)*((D-E)*(F-G)-(H-G)*(I-E))+((H-G)*(L-C)-(K-C)*(F-G))*(O-E);if(O*O<9.99999905104687e-9)S=-1;else S=O*(((D-E)*(F-G)-(H-G)*(I-E))*(0.0-C)+((K-C)*(I-E)-(D-E)*(L-C))*(0.0-G)+((H-G)*(L-C)-(K-C)*(F-G))*(0.0-E))<0.0&1;if((M|N|J|S|0)<0){a[b+352>>0]=1;a[b+312>>0]=0;T=0;T=T<<24>>24!=0;i=d;return T|0}T=(N|0)!=0;N=(M|0)==0;J=(J|0)==0;M=(S|0)==0;if(N&(T^1)&J&M){a[b+312>>0]=1;c[b+276>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;c[b+288>>2]=0;T=1;T=T<<24>>24!=0;i=d;return T|0}if(T?(wC(d,b+4|0,b+20|0,b+36|0,d+32|0),B=+g[d+32>>2],w=+g[d+36>>2],x=+g[d+40>>2],y=B- +g[d>>2],z=w- +g[d+4>>2],A=x- +g[d+8>>2],y*y+z*z+A*A<3.4028234663852886e+38):0){R=+g[d+44>>2];g[b+316>>2]=B;g[b+320>>2]=w;g[b+324>>2]=x;g[b+328>>2]=R;T=a[j>>0]|0;a[b+332>>0]=T&1|a[b+332>>0]&-16|T&2|T&4;R=+g[d+56>>2];w=+g[d+60>>2];g[b+336>>2]=+g[d+52>>2];g[b+340>>2]=R;g[b+344>>2]=w;g[b+348>>2]=0.0;w=y*y+z*z+A*A}else w=3.4028234663852886e+38;if(!N?(wC(d,b+4|0,b+36|0,b+52|0,d+32|0),r=+g[d+32>>2],u=+g[d+36>>2],q=+g[d+40>>2],v=r- +g[d>>2],s=u- +g[d+4>>2],t=q- +g[d+8>>2],v*v+s*s+t*t<w):0){R=+g[d+44>>2];g[b+316>>2]=r;g[b+320>>2]=u;g[b+324>>2]=q;g[b+328>>2]=R;T=a[j>>0]|0;a[b+332>>0]=T<<1&4|(T&1|a[b+332>>0]&-16)|T<<1&8;R=+g[d+56>>2];w=+g[d+60>>2];g[b+336>>2]=+g[d+52>>2];g[b+340>>2]=0.0;g[b+344>>2]=R;g[b+348>>2]=w;w=v*v+s*s+t*t}if(!J?(wC(d,b+4|0,b+52|0,b+20|0,d+32|0),k=+g[d+32>>2],l=+g[d+36>>2],m=+g[d+40>>2],n=k- +g[d>>2],o=l- +g[d+4>>2],p=m- +g[d+8>>2],n*n+o*o+p*p<w):0){R=+g[d+44>>2];g[b+316>>2]=k;g[b+320>>2]=l;g[b+324>>2]=m;g[b+328>>2]=R;T=a[j>>0]|0;a[b+332>>0]=(T&255)>>>1&2|(T&1|a[b+332>>0]&-16)|T<<2&8;R=+g[d+60>>2];w=+g[d+56>>2];g[b+336>>2]=+g[d+52>>2];g[b+340>>2]=R;g[b+344>>2]=0.0;g[b+348>>2]=w;w=n*n+o*o+p*p}if(!M?(wC(d,b+20|0,b+52|0,b+36|0,d+32|0),f=+g[d+32>>2],e=+g[d+36>>2],h=+g[d+40>>2],P=f- +g[d>>2],Q=e- +g[d+4>>2],R=h- +g[d+8>>2],P*P+Q*Q+R*R<w):0){P=+g[d+44>>2];g[b+316>>2]=f;g[b+320>>2]=e;g[b+324>>2]=h;g[b+328>>2]=P;T=a[j>>0]|0;a[b+332>>0]=T<<1&2|a[b+332>>0]&-16|T&4|T<<2&8;P=+g[d+52>>2];Q=+g[d+60>>2];R=+g[d+56>>2];g[b+336>>2]=0.0;g[b+340>>2]=P;g[b+344>>2]=Q;g[b+348>>2]=R}G=+g[b+336>>2];H=+g[b+340>>2];I=+g[b+344>>2];R=+g[b+348>>2];K=+g[b+84>>2]*G+ +g[b+100>>2]*H+ +g[b+116>>2]*I+ +g[b+132>>2]*R;O=G*+g[b+88>>2]+H*+g[b+104>>2]+I*+g[b+120>>2]+R*+g[b+136>>2];Q=G*+g[b+92>>2]+H*+g[b+108>>2]+I*+g[b+124>>2]+R*+g[b+140>>2];g[b+244>>2]=K;g[b+248>>2]=O;g[b+252>>2]=Q;g[b+256>>2]=0.0;L=+g[b+164>>2]*G+ +g[b+180>>2]*H+ +g[b+196>>2]*I+ +g[b+212>>2]*R;P=G*+g[b+168>>2]+H*+g[b+184>>2]+I*+g[b+200>>2]+R*+g[b+216>>2];R=G*+g[b+172>>2]+H*+g[b+188>>2]+I*+g[b+204>>2]+R*+g[b+220>>2];g[b+260>>2]=L;g[b+264>>2]=P;g[b+268>>2]=R;g[b+272>>2]=0.0;g[b+276>>2]=K-L;g[b+280>>2]=O-P;g[b+284>>2]=Q-R;g[b+288>>2]=0.0;uC(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)j=+g[b+348>>2]>=0.0&1;else j=0;a[b+312>>0]=j;T=j;T=T<<24>>24!=0;i=d;return T|0};case 2:{k=+g[b+4>>2];f=+g[b+8>>2];m=+g[b+12>>2];e=+g[b+20>>2]-k;h=+g[b+24>>2]-f;l=+g[b+28>>2]-m;do if((0.0-k)*e+(0.0-f)*h+(0.0-m)*l>0.0)if((0.0-k)*e+(0.0-f)*h+(0.0-m)*l<e*e+h*h+l*l){a[b+332>>0]=J&-16|3;e=((0.0-k)*e+(0.0-f)*h+(0.0-m)*l)/(e*e+h*h+l*l);break}else{a[b+332>>0]=J&-16|2;e=1.0;break}else{a[b+332>>0]=J&-16|1;e=0.0}while(0);g[b+336>>2]=1.0-e;g[b+340>>2]=e;g[b+344>>2]=0.0;g[b+348>>2]=0.0;K=+g[b+84>>2];O=+g[b+88>>2];Q=+g[b+92>>2];K=K+e*(+g[b+100>>2]-K);O=O+e*(+g[b+104>>2]-O);Q=Q+e*(+g[b+108>>2]-Q);g[b+244>>2]=K;g[b+248>>2]=O;g[b+252>>2]=Q;g[b+256>>2]=0.0;L=+g[b+164>>2];P=+g[b+168>>2];R=+g[b+172>>2];L=L+e*(+g[b+180>>2]-L);P=P+e*(+g[b+184>>2]-P);R=R+e*(+g[b+188>>2]-R);g[b+260>>2]=L;g[b+264>>2]=P;g[b+268>>2]=R;g[b+272>>2]=0.0;g[b+276>>2]=K-L;g[b+280>>2]=O-P;g[b+284>>2]=Q-R;g[b+288>>2]=0.0;uC(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)j=+g[b+348>>2]>=0.0&1;else j=0;a[b+312>>0]=j;T=j;T=T<<24>>24!=0;i=d;return T|0};case 0:{a[b+312>>0]=0;T=0;T=T<<24>>24!=0;i=d;return T|0};case 3:{c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;wC(d+16|0,b+4|0,b+20|0,b+36|0,b+316|0);H=+g[b+336>>2];I=+g[b+340>>2];R=+g[b+344>>2];K=+g[b+84>>2]*H+ +g[b+100>>2]*I+ +g[b+116>>2]*R;O=H*+g[b+88>>2]+I*+g[b+104>>2]+R*+g[b+120>>2];Q=H*+g[b+92>>2]+I*+g[b+108>>2]+R*+g[b+124>>2];g[b+244>>2]=K;g[b+248>>2]=O;g[b+252>>2]=Q;g[b+256>>2]=0.0;L=+g[b+164>>2]*H+ +g[b+180>>2]*I+ +g[b+196>>2]*R;P=H*+g[b+168>>2]+I*+g[b+184>>2]+R*+g[b+200>>2];R=H*+g[b+172>>2]+I*+g[b+188>>2]+R*+g[b+204>>2];g[b+260>>2]=L;g[b+264>>2]=P;g[b+268>>2]=R;g[b+272>>2]=0.0;g[b+276>>2]=K-L;g[b+280>>2]=O-P;g[b+284>>2]=Q-R;g[b+288>>2]=0.0;uC(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)j=+g[b+348>>2]>=0.0&1;else j=0;a[b+312>>0]=j;T=j;T=T<<24>>24!=0;i=d;return T|0};default:{a[b+312>>0]=0;T=0;T=T<<24>>24!=0;i=d;return T|0}}return 0}function wC(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;r=i;o=a[h+16>>0]&-16;a[h+16>>0]=o;l=+g[e>>2];k=+g[d>>2];n=+g[e+4>>2];m=+g[d+4>>2];p=+g[e+8>>2];j=+g[d+8>>2];q=+g[f>>2];s=+g[f+4>>2];t=+g[f+8>>2];u=+g[b>>2];v=+g[b+4>>2];y=+g[b+8>>2];w=(l-k)*(u-k)+(n-m)*(v-m)+(p-j)*(y-j);x=(q-k)*(u-k)+(s-m)*(v-m)+(t-j)*(y-j);if(!(!(w<=0.0)|!(x<=0.0))){c[h+0>>2]=c[d+0>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];a[h+16>>0]=o|1;g[h+20>>2]=1.0;g[h+24>>2]=0.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;i=r;return}z=(l-k)*(u-l)+(n-m)*(v-n)+(p-j)*(y-p);A=(q-k)*(u-l)+(s-m)*(v-n)+(t-j)*(y-p);if(!(!(z>=0.0)|!(A<=z))){c[h+0>>2]=c[e+0>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];a[h+16>>0]=o|2;g[h+20>>2]=0.0;g[h+24>>2]=1.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;i=r;return}if(!((w>=0.0?!(w*A-z*x<=0.0):1)|!(z<=0.0))){g[h>>2]=k+(l-k)*(w/(w-z));g[h+4>>2]=m+(n-m)*(w/(w-z));g[h+8>>2]=j+(p-j)*(w/(w-z));g[h+12>>2]=0.0;a[h+16>>0]=o|3;g[h+20>>2]=1.0-w/(w-z);g[h+24>>2]=w/(w-z);g[h+28>>2]=0.0;g[h+32>>2]=0.0;i=r;return}B=(l-k)*(u-q)+(n-m)*(v-s)+(p-j)*(y-t);u=(q-k)*(u-q)+(s-m)*(v-s)+(t-j)*(y-t);if(!(!(u>=0.0)|!(B<=u))){c[h+0>>2]=c[f+0>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];a[h+16>>0]=o|4;g[h+20>>2]=0.0;g[h+24>>2]=0.0;g[h+28>>2]=1.0;g[h+32>>2]=0.0;i=r;return}if(!((x>=0.0?!(B*x-w*u<=0.0):1)|!(u<=0.0))){g[h>>2]=k+(q-k)*(x/(x-u));g[h+4>>2]=m+(s-m)*(x/(x-u));g[h+8>>2]=j+(t-j)*(x/(x-u));g[h+12>>2]=0.0;a[h+16>>0]=o|5;g[h+20>>2]=1.0-x/(x-u);g[h+24>>2]=0.0;g[h+28>>2]=x/(x-u);g[h+32>>2]=0.0;i=r;return}if((z*u-B*A<=0.0?A-z>=0.0:0)?B-u>=0.0:0){B=(A-z)/(A-z+(B-u));g[h>>2]=l+(q-l)*B;g[h+4>>2]=n+(s-n)*B;g[h+8>>2]=p+(t-p)*B;g[h+12>>2]=0.0;a[h+16>>0]=o|6;g[h+20>>2]=0.0;g[h+24>>2]=1.0-B;g[h+28>>2]=B;g[h+32>>2]=0.0;i=r;return}v=1.0/(w*A-z*x+(z*u-B*A+(B*x-w*u)));y=(B*x-w*u)*v;B=(w*A-z*x)*v;g[h>>2]=(q-k)*B+(k+(l-k)*y);g[h+4>>2]=(s-m)*B+(m+(n-m)*y);g[h+8>>2]=(t-j)*B+((p-j)*y+j);g[h+12>>2]=0.0;a[h+16>>0]=o|7;g[h+20>>2]=1.0-y-B;g[h+24>>2]=y;g[h+28>>2]=B;g[h+32>>2]=0.0;i=r;return}function xC(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0;e=i;i=i+96|0;p=+g[b+48>>2]- +g[b+112>>2];j=+g[b+52>>2]- +g[b+116>>2];k=+g[b+56>>2]- +g[b+120>>2];n=p*+g[b+64>>2]+j*+g[b+80>>2]+k*+g[b+96>>2];m=p*+g[b+68>>2]+j*+g[b+84>>2]+k*+g[b+100>>2];k=p*+g[b+72>>2]+j*+g[b+88>>2]+k*+g[b+104>>2];q=c[a+8>>2]|0;s=c[a+4>>2]|0;j=+g[s+28>>2]*+g[s+12>>2];p=j+ +g[a+12>>2];w=+g[q+72>>2];u=+g[q+56>>2];t=+g[q+76>>2];B=+g[q+60>>2];v=+g[q+80>>2];x=+g[q+64>>2];y=+g[q+88>>2];z=+g[q+92>>2];A=+g[q+96>>2];C=(t-B)*(A-x)-(v-x)*(z-B);l=(v-x)*(y-u)-(w-u)*(A-x);h=(w-u)*(z-B)-(t-B)*(y-u);o=1.0/+Q(+(h*h+(C*C+l*l)));r=(n-u)*o*C+o*l*(m-B)+o*h*(k-x);if(r<0.0){r=r*-1.0;h=o*h*-1.0;l=o*l*-1.0;o=o*C*-1.0}else{h=o*h;l=o*l;o=o*C}if(!(r<p)){i=e;return}C=(k-x)*((w-u)*l-(t-B)*o)+((n-u)*((t-B)*h-(v-x)*l)+(m-B)*((v-x)*o-(w-u)*h));D=(k-v)*((y-w)*l-(z-t)*o)+((n-w)*((z-t)*h-(A-v)*l)+(m-t)*((A-v)*o-(y-w)*h));E=(k-A)*((u-y)*l-(B-z)*o)+((n-y)*((B-z)*h-(x-A)*l)+(m-z)*((x-A)*o-(u-y)*h));if(!(C>0.0&D>0.0&E>0.0)?!(C<=0.0)|!(D<=0.0)|!(E<=0.0):0){if((Pb[c[(c[q>>2]|0)+100>>2]&127](q)|0)<=0){i=e;return}r=0.0;t=0.0;y=0.0;s=0;q=0;do{F=c[a+8>>2]|0;vc[c[(c[F>>2]|0)+104>>2]&127](F,q,e+80|0,e+64|0);w=+g[e+80>>2];z=+g[e+84>>2];D=+g[e+88>>2];v=+g[e+64>>2]-w;x=+g[e+68>>2]-z;E=+g[e+72>>2]-D;do if((n-w)*v+(m-z)*x+(k-D)*E>0.0)if((n-w)*v+(m-z)*x+(k-D)*E<v*v+x*x+E*E){u=((n-w)*v+(m-z)*x+(k-D)*E)/(v*v+x*x+E*E);A=n-w-v*u;B=m-z-x*u;C=k-D-E*u;break}else{A=n-w-v;B=m-z-x;C=k-D-E;u=1.0;break}else{A=n-w;B=m-z;C=k-D;u=0.0}while(0);if(C*C+(B*B+A*A)<p*p){y=D+E*u;t=z+x*u;r=w+v*u;s=1}q=q+1|0;F=c[a+8>>2]|0}while((q|0)<(Pb[c[(c[F>>2]|0)+100>>2]&127](F)|0));if(!(s&1)){i=e;return}else{u=p*p;p=r}}else{u=p*p;p=n-o*r;t=m-l*r;y=k-h*r}n=n-p;m=m-t;k=k-y;if(!(n*n+m*m+k*k<u)){i=e;return}if(n*n+m*m+k*k>1.1920928955078125e-7){h=+Q(+(n*n+m*m+k*k));j=j-h;o=n*(1.0/h);l=m*(1.0/h);h=k*(1.0/h)}j=-j;if(f){z=+g[b+64>>2];A=+g[b+68>>2];B=+g[b+72>>2];C=z*o+A*l+B*h;n=+g[b+80>>2];r=+g[b+84>>2];u=+g[b+88>>2];D=o*n+l*r+h*u;v=+g[b+96>>2];w=+g[b+100>>2];x=+g[b+104>>2];E=o*v+l*w+h*x;g[e+48>>2]=-C;g[e+52>>2]=-D;g[e+56>>2]=-E;g[e+60>>2]=0.0;D=p*n+t*r+y*u+ +g[b+116>>2]+D*j;E=p*v+t*w+y*x+ +g[b+120>>2]+E*j;g[e+32>>2]=p*z+t*A+y*B+ +g[b+112>>2]+C*j;g[e+36>>2]=D;g[e+40>>2]=E;g[e+44>>2]=0.0;qc[c[(c[d>>2]|0)+16>>2]&15](d,e+48|0,e+32|0,j);i=e;return}else{F=c[(c[d>>2]|0)+16>>2]|0;A=+g[b+64>>2];B=+g[b+68>>2];C=+g[b+72>>2];v=+g[b+80>>2];w=+g[b+84>>2];D=+g[b+88>>2];x=+g[b+96>>2];z=+g[b+100>>2];E=+g[b+104>>2];g[e+16>>2]=A*o+B*l+C*h;g[e+20>>2]=o*v+l*w+h*D;g[e+24>>2]=o*x+l*z+h*E;g[e+28>>2]=0.0;D=p*v+t*w+y*D+ +g[b+116>>2];E=p*x+t*z+y*E+ +g[b+120>>2];g[e>>2]=p*A+t*B+y*C+ +g[b+112>>2];g[e+4>>2]=D;g[e+8>>2]=E;g[e+12>>2]=0.0;qc[F&15](d,e+16|0,e,j);i=e;return}}function yC(a){a=a|0;return}function zC(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function AC(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=17896;if((a[b+8>>0]|0)!=0?(e=c[b+12>>2]|0,(e|0)!=0):0){f=c[b+4>>2]|0;Nb[c[(c[f>>2]|0)+16>>2]&127](f,e)}gF(b);i=d;return}function BC(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=17896;if(!(a[b+8>>0]|0)){i=d;return}e=c[b+12>>2]|0;if(!e){i=d;return}b=c[b+4>>2]|0;Nb[c[(c[b>>2]|0)+16>>2]&127](b,e);i=d;return}function CC(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0;j=i;i=i+144|0;k=c[b+12>>2]|0;if(!k){i=j;return}m=c[d+4>>2]|0;l=c[e+4>>2]|0;c[h+4>>2]=k;g[j+140>>2]=999999984306749400.0;k=c[d+12>>2]|0;c[j+12>>2]=c[k+0>>2];c[j+16>>2]=c[k+4>>2];c[j+20>>2]=c[k+8>>2];c[j+24>>2]=c[k+12>>2];c[j+28>>2]=c[k+16>>2];c[j+32>>2]=c[k+20>>2];c[j+36>>2]=c[k+24>>2];c[j+40>>2]=c[k+28>>2];c[j+44>>2]=c[k+32>>2];c[j+48>>2]=c[k+36>>2];c[j+52>>2]=c[k+40>>2];c[j+56>>2]=c[k+44>>2];c[j+60>>2]=c[k+48>>2];c[j+64>>2]=c[k+52>>2];c[j+68>>2]=c[k+56>>2];c[j+72>>2]=c[k+60>>2];e=c[e+12>>2]|0;c[j+76>>2]=c[e+0>>2];c[j+80>>2]=c[e+4>>2];c[j+84>>2]=c[e+8>>2];c[j+88>>2]=c[e+12>>2];c[j+92>>2]=c[e+16>>2];c[j+96>>2]=c[e+20>>2];c[j+100>>2]=c[e+24>>2];c[j+104>>2]=c[e+28>>2];c[j+108>>2]=c[e+32>>2];c[j+112>>2]=c[e+36>>2];c[j+116>>2]=c[e+40>>2];c[j+120>>2]=c[e+44>>2];c[j+124>>2]=c[e+48>>2];c[j+128>>2]=c[e+52>>2];c[j+132>>2]=c[e+56>>2];c[j+136>>2]=c[e+60>>2];c[j>>2]=17976;c[j+4>>2]=m;c[j+8>>2]=l;FC(j,j+12|0,h,c[f+20>>2]|0,0);if(!(a[b+8>>0]|0)){i=j;return}d=c[h+4>>2]|0;if(!(c[d+748>>2]|0)){i=j;return}k=c[d+740>>2]|0;e=c[(c[h+8>>2]|0)+8>>2]|0;if((k|0)==(e|0)){xA(d,k+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);i=j;return}else{xA(d,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,e+4|0);i=j;return}}function DC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function EC(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;if(!(c[b+12>>2]|0)){i=e;return}if(!(a[b+8>>0]|0)){i=e;return}h=c[d+4>>2]|0;if((h|0)==(c[d+8>>2]|0)?(f=(h|0)==0?1:h<<1,(h|0)<(f|0)):0){if(!f)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[d+4>>2]|0}if((h|0)>0){j=0;do{k=g+(j<<2)|0;if(k)c[k>>2]=c[(c[d+12>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+12>>2]|0;if(j){if(a[d+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=g;c[d+8>>2]=f}f=(c[d+12>>2]|0)+(h<<2)|0;if(f)c[f>>2]=c[b+12>>2];c[d+4>>2]=h+1;i=e;return}function FC(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0.0,na=0.0,oa=0.0,pa=0,qa=0.0,ra=0.0,sa=0,ta=0,ua=0,va=0.0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0;e=i;i=i+656|0;g[e+48>>2]=+g[b>>2];g[e>>2]=+g[b+64>>2];f=e+52|0;g[f>>2]=+g[b+4>>2];g[e+4>>2]=+g[b+68>>2];g[e+56>>2]=+g[b+8>>2];g[e+8>>2]=+g[b+72>>2];g[e+64>>2]=+g[b+16>>2];g[e+16>>2]=+g[b+80>>2];g[e+68>>2]=+g[b+20>>2];g[e+20>>2]=+g[b+84>>2];g[e+72>>2]=+g[b+24>>2];g[e+24>>2]=+g[b+88>>2];g[e+80>>2]=+g[b+32>>2];g[e+32>>2]=+g[b+96>>2];g[e+84>>2]=+g[b+36>>2];g[e+36>>2]=+g[b+100>>2];g[e+88>>2]=+g[b+40>>2];g[e+40>>2]=+g[b+104>>2];Da=c[a+4>>2]|0;A=+g[Da+28>>2];B=+g[Da+32>>2];E=+g[Da+36>>2];C=+$b[c[(c[Da>>2]|0)+48>>2]&15](Da);D=+$b[c[(c[Da>>2]|0)+48>>2]&15](Da);E=(E+ +$b[c[(c[Da>>2]|0)+48>>2]&15](Da))*2.0;Da=c[a+8>>2]|0;w=+g[Da+28>>2];y=+g[Da+32>>2];q=+g[Da+36>>2];v=+$b[c[(c[Da>>2]|0)+48>>2]&15](Da);x=+$b[c[(c[Da>>2]|0)+48>>2]&15](Da);q=(q+ +$b[c[(c[Da>>2]|0)+48>>2]&15](Da))*2.0;R=+g[b+112>>2]- +g[b+48>>2];S=+g[b+116>>2]- +g[b+52>>2];O=+g[b+120>>2]- +g[b+56>>2];k=+g[e+48>>2];j=+g[e+64>>2];h=+g[e+80>>2];I=+g[f>>2];J=+g[e+68>>2];H=+g[e+84>>2];G=+g[e+56>>2];F=+g[e+72>>2];z=+g[e+88>>2];g[e+548>>2]=(A+C)*2.0*.5;g[e+552>>2]=(B+D)*2.0*.5;g[e+556>>2]=E*.5;g[e+536>>2]=(w+v)*2.0*.5;g[e+540>>2]=(y+x)*2.0*.5;g[e+544>>2]=q*.5;p=+g[e>>2];u=+g[e+16>>2];r=+g[e+32>>2];o=+g[e+4>>2];t=+g[e+20>>2];s=+g[e+36>>2];n=+g[e+8>>2];m=+g[e+24>>2];l=+g[e+40>>2];X=+P(+(k*p+j*u+h*r));T=+P(+(k*o+j*t+h*s));K=+P(+(k*n+j*m+h*l));Z=+P(+(p*I+u*J+r*H));V=+P(+(o*I+t*J+s*H));N=+P(+(n*I+m*J+l*H));L=+P(+(p*G+u*F+r*z));M=+P(+(o*G+t*F+s*z));U=+P(+(n*G+m*F+l*z));$=+P(+(R*k+S*j+O*h))-(q*.5*K+((A+C)*2.0*.5+X*(w+v)*2.0*.5+T*(y+x)*2.0*.5));if($>0.0){i=e;return}if($>-3.4028234663852886e+38){ga=1;W=R*k+S*j+O*h<0.0&1;a=e+48|0}else{ga=0;W=0;a=0;$=-3.4028234663852886e+38}_=+P(+(R*I+S*J+O*H))-((B+D)*2.0*.5+Z*(w+v)*2.0*.5+V*(y+x)*2.0*.5+N*q*.5);if(_>0.0){i=e;return}if(_>$){ga=2;W=R*I+S*J+O*H<0.0&1;a=f}else _=$;$=+P(+(R*G+S*F+O*z))-(E*.5+L*(w+v)*2.0*.5+M*(y+x)*2.0*.5+U*q*.5);if($>0.0){i=e;return}if($>_){ga=3;W=R*G+S*F+O*z<0.0&1;a=e+56|0;_=$}$=+P(+(R*p+S*u+O*r))-((w+v)*2.0*.5+(X*(A+C)*2.0*.5+Z*(B+D)*2.0*.5+L*E*.5));if($>0.0){i=e;return}if($>_){ga=4;W=R*p+S*u+O*r<0.0&1;a=e;_=$}$=+P(+(R*o+S*t+O*s))-((y+x)*2.0*.5+(T*(A+C)*2.0*.5+V*(B+D)*2.0*.5+M*E*.5));if($>0.0){i=e;return}if($>_){ga=5;W=R*o+S*t+O*s<0.0&1;a=e+4|0;_=$}qa=+P(+(R*n+S*m+O*l))-(q*.5+(K*(A+C)*2.0*.5+N*(B+D)*2.0*.5+U*E*.5));if(qa>0.0){i=e;return}if(qa>_){ga=6;W=R*n+S*m+O*l<0.0&1;a=e+8|0}else qa=_;ba=(R*G+S*F+O*z)*(p*I+u*J+r*H)-(R*I+S*J+O*H)*(p*G+u*F+r*z);$=+P(+ba)-((L+9999999747378752.0e-21)*(B+D)*2.0*.5+(Z+9999999747378752.0e-21)*E*.5+(K+9999999747378752.0e-21)*(y+x)*2.0*.5+(T+9999999747378752.0e-21)*q*.5);if($>1.1920928955078125e-7){i=e;return}da=(p*G+u*F+r*z)*(p*G+u*F+r*z)+0.0;aa=(p*I+u*J+r*H)*(p*I+u*J+r*H);_=+Q(+(aa+da));if(_>1.1920928955078125e-7?$/_*1.0499999523162842>qa:0){oa=(p*I+u*J+r*H)/_;na=-(p*G+u*F+r*z)/_;ma=0.0/_;ga=7;W=ba<0.0&1;a=0;qa=$/_}else{oa=0.0;na=0.0;ma=0.0}ca=(R*G+S*F+O*z)*(o*I+t*J+s*H)-(R*I+S*J+O*H)*(o*G+t*F+s*z);$=+P(+ca)-((M+9999999747378752.0e-21)*(B+D)*2.0*.5+(V+9999999747378752.0e-21)*E*.5+(K+9999999747378752.0e-21)*(w+v)*2.0*.5+(X+9999999747378752.0e-21)*q*.5);if($>1.1920928955078125e-7){i=e;return}ea=(o*G+t*F+s*z)*(o*G+t*F+s*z)+0.0;_=(o*I+t*J+s*H)*(o*I+t*J+s*H);ba=+Q(+(_+ea));if(ba>1.1920928955078125e-7?$/ba*1.0499999523162842>qa:0){oa=(o*I+t*J+s*H)/ba;na=-(o*G+t*F+s*z)/ba;ma=0.0/ba;ga=8;W=ca<0.0&1;a=0;qa=$/ba}va=(R*G+S*F+O*z)*(n*I+m*J+l*H)-(R*I+S*J+O*H)*(n*G+m*F+l*z);ba=+P(+va)-((U+9999999747378752.0e-21)*(B+D)*2.0*.5+(N+9999999747378752.0e-21)*E*.5+(T+9999999747378752.0e-21)*(w+v)*2.0*.5+(X+9999999747378752.0e-21)*(y+x)*2.0*.5);if(ba>1.1920928955078125e-7){i=e;return}ca=(n*G+m*F+l*z)*(n*G+m*F+l*z)+0.0;$=(n*I+m*J+l*H)*(n*I+m*J+l*H);ra=+Q(+($+ca));if(ra>1.1920928955078125e-7?ba/ra*1.0499999523162842>qa:0){oa=(n*I+m*J+l*H)/ra;na=-(n*G+m*F+l*z)/ra;ma=0.0/ra;ga=9;W=va<0.0&1;a=0;qa=ba/ra}va=(R*k+S*j+O*h)*(p*G+u*F+r*z)-(R*G+S*F+O*z)*(k*p+j*u+h*r);ra=+P(+va)-((L+9999999747378752.0e-21)*(A+C)*2.0*.5+(X+9999999747378752.0e-21)*E*.5+(N+9999999747378752.0e-21)*(y+x)*2.0*.5+(V+9999999747378752.0e-21)*q*.5);if(ra>1.1920928955078125e-7){i=e;return}ba=(k*p+j*u+h*r)*(k*p+j*u+h*r);da=+Q(+(ba+da));do if(da>1.1920928955078125e-7){if(!(ra/da*1.0499999523162842>qa))break;oa=-(k*p+j*u+h*r)/da;na=0.0/da;ma=(p*G+u*F+r*z)/da;ga=10;W=va<0.0&1;a=0;qa=ra/da}while(0);va=(R*k+S*j+O*h)*(o*G+t*F+s*z)-(R*G+S*F+O*z)*(k*o+j*t+h*s);ra=+P(+va)-((M+9999999747378752.0e-21)*(A+C)*2.0*.5+(T+9999999747378752.0e-21)*E*.5+(N+9999999747378752.0e-21)*(w+v)*2.0*.5+(Z+9999999747378752.0e-21)*q*.5);if(ra>1.1920928955078125e-7){i=e;return}da=(k*o+j*t+h*s)*(k*o+j*t+h*s);ea=+Q(+(da+ea));do if(ea>1.1920928955078125e-7){if(!(ra/ea*1.0499999523162842>qa))break;oa=-(k*o+j*t+h*s)/ea;na=0.0/ea;ma=(o*G+t*F+s*z)/ea;ga=11;W=va<0.0&1;a=0;qa=ra/ea}while(0);va=(R*k+S*j+O*h)*(n*G+m*F+l*z)-(R*G+S*F+O*z)*(k*n+j*m+h*l);ra=+P(+va)-((U+9999999747378752.0e-21)*(A+C)*2.0*.5+(K+9999999747378752.0e-21)*E*.5+(V+9999999747378752.0e-21)*(w+v)*2.0*.5+(Z+9999999747378752.0e-21)*(y+x)*2.0*.5);if(ra>1.1920928955078125e-7){i=e;return}ea=(k*n+j*m+h*l)*(k*n+j*m+h*l);ca=+Q(+(ea+ca));do if(ca>1.1920928955078125e-7){if(!(ra/ca*1.0499999523162842>qa))break;oa=-(k*n+j*m+h*l)/ca;na=0.0/ca;ma=(n*G+m*F+l*z)/ca;ga=12;W=va<0.0&1;a=0;qa=ra/ca}while(0);ca=(R*I+S*J+O*H)*(k*p+j*u+h*r)-(R*k+S*j+O*h)*(p*I+u*J+r*H);X=+P(+ca)-((Z+9999999747378752.0e-21)*(A+C)*2.0*.5+(X+9999999747378752.0e-21)*(B+D)*2.0*.5+(U+9999999747378752.0e-21)*(y+x)*2.0*.5+(M+9999999747378752.0e-21)*q*.5);if(X>1.1920928955078125e-7){i=e;return}Z=+Q(+(ba+aa+0.0));do if(Z>1.1920928955078125e-7){if(!(X/Z*1.0499999523162842>qa))break;oa=0.0/Z;na=(k*p+j*u+h*r)/Z;ma=-(p*I+u*J+r*H)/Z;ga=13;W=ca<0.0&1;a=0;qa=X/Z}while(0);X=(R*I+S*J+O*H)*(k*o+j*t+h*s)-(R*k+S*j+O*h)*(o*I+t*J+s*H);T=+P(+X)-((V+9999999747378752.0e-21)*(A+C)*2.0*.5+(T+9999999747378752.0e-21)*(B+D)*2.0*.5+(U+9999999747378752.0e-21)*(w+v)*2.0*.5+(L+9999999747378752.0e-21)*q*.5);if(T>1.1920928955078125e-7){i=e;return}U=+Q(+(da+_+0.0));do if(U>1.1920928955078125e-7){if(!(T/U*1.0499999523162842>qa)){fa=a;break}oa=0.0/U;na=(k*o+j*t+h*s)/U;ma=-(o*I+t*J+s*H)/U;ga=14;W=X<0.0&1;fa=0;qa=T/U}else fa=a;while(0);O=(R*I+S*J+O*H)*(k*n+j*m+h*l)-(R*k+S*j+O*h)*(n*I+m*J+l*H);K=+P(+O)-((N+9999999747378752.0e-21)*(A+C)*2.0*.5+(K+9999999747378752.0e-21)*(B+D)*2.0*.5+(M+9999999747378752.0e-21)*(w+v)*2.0*.5+(L+9999999747378752.0e-21)*(y+x)*2.0*.5);if(K>1.1920928955078125e-7){i=e;return}L=+Q(+(ea+$+0.0));do if(L>1.1920928955078125e-7){if(!(K/L*1.0499999523162842>qa)){a=55;break}ma=-(n*I+m*J+l*H)/L;na=(k*n+j*m+h*l)/L;oa=0.0/L;ga=15;W=O<0.0&1;qa=K/L;a=58}else a=55;while(0);do if((a|0)==55){if(!ga){i=e;return}if(!fa){a=58;break}h=+g[fa>>2];j=+g[fa+16>>2];k=+g[fa+32>>2]}while(0);if((a|0)==58){h=ma*+g[e+48>>2]+na*+g[f>>2]+oa*G;j=ma*+g[e+64>>2]+na*+g[e+68>>2]+oa*F;k=ma*+g[e+80>>2]+na*+g[e+84>>2]+oa*z}if(W){h=-h;j=-j;k=-k}if((ga|0)>6){ca=+g[e+48>>2];da=+g[e+64>>2];na=+g[e+80>>2];ma=(h*ca+j*da+k*na>0.0?1.0:-1.0)*(A+C)*2.0*.5;A=+g[f>>2];ea=+g[e+68>>2];ra=+g[e+84>>2];oa=(h*A+j*ea+k*ra>0.0?1.0:-1.0)*(B+D)*2.0*.5;va=(h*G+j*F+k*z>0.0?1.0:-1.0)*E*.5;A=+g[b+48>>2]+ma*ca+oa*A+va*G;B=+g[b+52>>2]+ma*da+oa*ea+va*F;z=+g[b+56>>2]+ma*na+oa*ra+va*z;c[e+520>>2]=c[b+112>>2];c[e+524>>2]=c[b+116>>2];c[e+528>>2]=c[b+120>>2];w=(h*p+j*u+k*r>0.0?-1.0:1.0)*(w+v)*2.0*.5;x=(h*o+j*t+k*s>0.0?-1.0:1.0)*(y+x)*2.0*.5;t=+g[e+524>>2]+w*u+x*t;r=+g[e+528>>2]+w*r+x*s;q=(h*n+j*m+k*l>0.0?-1.0:1.0)*q*.5;n=+g[e+520>>2]+w*p+x*o+q*n;g[e+520>>2]=n;g[e+524>>2]=t+q*m;g[e+528>>2]=r+q*l;Da=ga+ -7|0;u=+g[e+48+(((Da|0)/3|0)<<2)>>2];x=+g[e+48+(((Da|0)/3|0)+4<<2)>>2];w=+g[e+48+(((Da|0)/3|0)+8<<2)>>2];s=+g[e+(((Da|0)%3|0)<<2)>>2];p=+g[e+(((Da|0)%3|0)+4<<2)>>2];o=+g[e+(((Da|0)%3|0)+8<<2)>>2];v=1.0-(u*s+x*p+w*o)*(u*s+x*p+w*o);if(!(v<=9999999747378752.0e-20))u=(((n-A)*u+(t+q*m-B)*x+(r+q*l-z)*w)*(u*s+x*p+w*o)-((n-A)*s+(t+q*m-B)*p+(r+q*l-z)*o))*(1.0/v);else u=0.0;g[e+520>>2]=n+u*s;g[e+524>>2]=t+q*m+u*p;g[e+528>>2]=r+q*l+u*o;Da=c[(c[d>>2]|0)+16>>2]|0;g[e+504>>2]=-h;g[e+508>>2]=-j;g[e+512>>2]=-k;g[e+516>>2]=0.0;qc[Da&15](d,e+504|0,e+520|0,qa);i=e;return}W=(ga|0)<4;if(W){l=h;m=j;n=k;ha=e+48|0;ta=e;fa=e+548|0;pa=e+536|0;f=b+48|0;b=b+112|0}else{l=-h;m=-j;n=-k;ha=e;ta=e+48|0;fa=e+536|0;pa=e+548|0;f=b+112|0;b=b+48|0}o=l*+g[ta>>2]+m*+g[ta+16>>2]+n*+g[ta+32>>2];g[e+488>>2]=o;q=l*+g[ta+4>>2]+m*+g[ta+20>>2]+n*+g[ta+36>>2];g[e+492>>2]=q;p=l*+g[ta+8>>2]+m*+g[ta+24>>2]+n*+g[ta+40>>2];g[e+496>>2]=p;o=+P(+o);q=+P(+q);p=+P(+p);if(q>o){ja=q>p;sa=0;ia=q>p?1:2}else{ja=o>p;sa=o>p&1;ia=o>p?0:2}ua=ja?2:1;q=+g[pa+(ia<<2)>>2];p=+g[b>>2]- +g[f>>2];o=q*+g[ta+(ia<<2)>>2];if(+g[e+488+(ia<<2)>>2]<0.0){o=p+o;p=+g[b+4>>2]- +g[f+4>>2]+q*+g[ta+((ia|4)<<2)>>2];q=+g[b+8>>2]- +g[f+8>>2]+q*+g[ta+((ia|8)<<2)>>2]}else{o=p-o;p=+g[b+4>>2]- +g[f+4>>2]-q*+g[ta+((ia|4)<<2)>>2];q=+g[b+8>>2]- +g[f+8>>2]-q*+g[ta+((ia|8)<<2)>>2]}la=(W?-1:-4)+ga|0;if(!la){wa=1;xa=2}else if((la|0)==1){wa=0;xa=2}else{wa=0;xa=1}t=+g[ha+(wa<<2)>>2];u=+g[ha+((wa|4)<<2)>>2];v=+g[ha+((wa|8)<<2)>>2];r=o*t+p*u+q*v;w=+g[ha+(xa<<2)>>2];s=+g[ha+((xa|4)<<2)>>2];y=+g[ha+((xa|8)<<2)>>2];A=o*w+p*s+q*y;ka=ta+(sa<<2)|0;x=+g[ka>>2];ia=ta+((sa|4)<<2)|0;C=+g[ia>>2];b=ta+((sa|8)<<2)|0;D=+g[b>>2];ja=ta+(ua<<2)|0;z=+g[ja>>2];ha=ta+((ua|4)<<2)|0;B=+g[ha>>2];ga=ta+((ua|8)<<2)|0;E=+g[ga>>2];ra=+g[pa+(sa<<2)>>2];va=+g[pa+(ua<<2)>>2];qa=(t*z+u*B+v*E)*va;va=(w*z+s*B+y*E)*va;g[e+456>>2]=r-(t*x+u*C+v*D)*ra-qa;g[e+460>>2]=A-(w*x+s*C+y*D)*ra-va;g[e+464>>2]=r-(t*x+u*C+v*D)*ra+qa;g[e+468>>2]=A-(w*x+s*C+y*D)*ra+va;g[e+472>>2]=r+(t*x+u*C+v*D)*ra+qa;g[e+476>>2]=A+(w*x+s*C+y*D)*ra+va;g[e+480>>2]=r+(t*x+u*C+v*D)*ra-qa;g[e+484>>2]=A+(w*x+s*C+y*D)*ra-va;g[e+448>>2]=+g[fa+(wa<<2)>>2];g[e+452>>2]=+g[fa+(xa<<2)>>2];ua=0;za=4;xa=e+456|0;ta=e+384|0;a:while(1){sa=e+448+(ua<<2)|0;pa=1-ua|0;wa=-1;while(1){if((za|0)>0){F=+(wa|0);Ba=0;ya=xa;Aa=ta;while(1){Ca=ya+(ua<<2)|0;G=+g[Ca>>2];H=+g[sa>>2];if(F*G<H){g[Aa>>2]=+g[ya>>2];g[Aa+4>>2]=+g[ya+4>>2];Ba=Ba+1|0;if(Ba&8){za=Ba;break a}G=+g[Ca>>2];H=+g[sa>>2];Aa=Aa+8|0}Ca=ya;ya=ya+8|0;Da=(za|0)>1?ya:xa;I=+g[Da+(ua<<2)>>2];if(F*G<H^F*I<H){va=+g[Ca+(pa<<2)>>2];g[Aa+(pa<<2)>>2]=va+(F*H-G)*((+g[Da+(pa<<2)>>2]-va)/(I-G));g[Aa+(ua<<2)>>2]=F*+g[sa>>2];Ba=Ba+1|0;if(!(Ba&8))Aa=Aa+8|0;else{za=Ba;break a}}za=za+ -1|0;if((za|0)<=0){za=Ba;break}}}else za=0;ya=(ta|0)==(e+384|0)?e+592|0:e+384|0;if((wa|0)<0){xa=ta;ta=ya;wa=wa+2|0}else break}ua=ua+1|0;if((ua|0)<2){xa=ta;ta=ya}else break}if((ta|0)!=(e+384|0))mF(e+384|0,ta|0,za<<3|0)|0;if((za|0)<1){i=e;return}F=1.0/((t*x+u*C+v*D)*(w*z+s*B+y*E)-(w*x+s*C+y*D)*(t*z+u*B+v*E));G=+g[fa+(la<<2)>>2];H=+g[ka>>2];I=+g[ja>>2];J=+g[ia>>2];K=+g[ha>>2];L=+g[b>>2];M=+g[ga>>2];b=0;fa=0;do{Da=fa<<1;O=+g[e+384+(Da<<2)>>2];N=+g[e+384+((Da|1)<<2)>>2];oa=(w*z+s*B+y*E)*F*(O-r)-(t*z+u*B+v*E)*F*(N-A);va=(t*x+u*C+v*D)*F*(N-A)-(w*x+s*C+y*D)*F*(O-r);Da=b*3|0;qa=o+oa*H+va*I;g[e+288+(Da<<2)>>2]=qa;ra=p+oa*J+va*K;g[e+288+(Da+1<<2)>>2]=ra;va=q+oa*L+va*M;g[e+288+(Da+2<<2)>>2]=va;va=G-(l*qa+m*ra+n*va);g[e+256+(b<<2)>>2]=va;if(va>=0.0){Da=b<<1;g[e+384+(Da<<2)>>2]=O;g[e+384+((Da|1)<<2)>>2]=N;b=b+1|0}fa=fa+1|0}while((fa|0)!=(za|0));if((b|0)<1){i=e;return}fa=(b|0)<4?b:4;fa=(fa|0)<1?1:fa;if((b|0)<=(fa|0)){a=(b|0)>0;if(W){if(!a){i=e;return}a=f+4|0;W=f+8|0;h=-h;j=-j;k=-k;fa=0;do{Da=fa*3|0;g[e+240>>2]=+g[e+288+(Da<<2)>>2]+ +g[f>>2];g[e+244>>2]=+g[e+288+(Da+1<<2)>>2]+ +g[a>>2];g[e+248>>2]=+g[e+288+(Da+2<<2)>>2]+ +g[W>>2];Da=c[(c[d>>2]|0)+16>>2]|0;g[e+224>>2]=h;g[e+228>>2]=j;g[e+232>>2]=k;g[e+236>>2]=0.0;qc[Da&15](d,e+224|0,e+240|0,-+g[e+256+(fa<<2)>>2]);fa=fa+1|0}while((fa|0)!=(b|0));i=e;return}else{if(!a){i=e;return}W=f+4|0;fa=f+8|0;l=-h;n=-j;m=-k;a=0;do{Da=a*3|0;va=+g[e+256+(a<<2)>>2];g[e+208>>2]=+g[e+288+(Da<<2)>>2]+ +g[f>>2]-h*va;g[e+212>>2]=+g[e+288+(Da+1<<2)>>2]+ +g[W>>2]-j*va;g[e+216>>2]=+g[e+288+(Da+2<<2)>>2]+ +g[fa>>2]-k*va;Da=c[(c[d>>2]|0)+16>>2]|0;g[e+192>>2]=l;g[e+196>>2]=n;g[e+200>>2]=m;g[e+204>>2]=0.0;qc[Da&15](d,e+192|0,e+208|0,-va);a=a+1|0}while((a|0)!=(b|0));i=e;return}}if((b|0)>1){ha=1;ga=0;l=+g[e+256>>2];while(1){m=+g[e+256+(ha<<2)>>2];ia=m>l;ga=ia?ha:ga;ha=ha+1|0;if((ha|0)==(b|0))break;else l=ia?m:l}}else ga=0;if((b|0)==1){q=+g[e+384>>2];l=+g[e+388>>2];a=115}else if((b|0)!=2){ha=b+ -1|0;if((ha|0)>0){r=0.0;q=0.0;p=0.0;ia=0;do{Da=ia<<1;oa=+g[e+384+(Da<<2)>>2];qa=+g[e+384+(Da+3<<2)>>2];ra=+g[e+384+(Da+2<<2)>>2];va=+g[e+384+((Da|1)<<2)>>2];r=r+(oa*qa-ra*va);q=q+(oa+ra)*(oa*qa-ra*va);p=p+(qa+va)*(oa*qa-ra*va);ia=ia+1|0}while((ia|0)!=(ha|0))}else{r=0.0;q=0.0;p=0.0}Da=b<<1;o=+g[e+384+(Da+ -2<<2)>>2];n=+g[e+388>>2];m=+g[e+384>>2];l=+g[e+384+(Da+ -1<<2)>>2];r=r+(o*n-m*l);if(+P(+r)>1.1920928955078125e-7)r=1.0/(r*3.0);else r=999999984306749400.0;if((b|0)>0){q=r*(q+(o*n-m*l)*(o+m));l=r*(p+(o*n-m*l)*(l+n));a=115}else ha=0}else{q=(+g[e+384>>2]+ +g[e+392>>2])*.5;l=(+g[e+388>>2]+ +g[e+396>>2])*.5;a=115}if((a|0)==115){a=0;do{Da=a<<1;g[e+592+(a<<2)>>2]=+Y(+(+g[e+384+((Da|1)<<2)>>2]-l),+(+g[e+384+(Da<<2)>>2]-q));a=a+1|0}while((a|0)!=(b|0));a=0;do{c[e+560+(a<<2)>>2]=1;a=a+1|0}while((a|0)!=(b|0));ha=1}a=e+560+(ga<<2)|0;c[a>>2]=0;c[e+160>>2]=ga;b:do if((fa|0)>1){l=+g[e+592+(ga<<2)>>2];if(ha){ha=e+164|0;a=1}else{ha=e+164|0;b=1;while(1){c[ha>>2]=ga;c[a>>2]=0;b=b+1|0;if((b|0)==(fa|0))break b;else ha=ha+4|0}}while(1){m=+(a|0)*(6.2831854820251465/+(fa|0))+l;if(m>3.1415927410125732)m=m+-6.2831854820251465;c[ha>>2]=ga;ja=ga;ia=0;n=1.0e9;do{do if(c[e+560+(ia<<2)>>2]|0){o=+P(+(+g[e+592+(ia<<2)>>2]-m));if(o>3.1415927410125732)o=6.2831854820251465-o;if(!(o<n))break;c[ha>>2]=ia;ja=ia;n=o}while(0);ia=ia+1|0}while((ia|0)!=(b|0));c[e+560+(ja<<2)>>2]=0;a=a+1|0;if((a|0)==(fa|0))break;else ha=ha+4|0}}while(0);if((fa|0)<=0){i=e;return}a=f+4|0;b=f+8|0;m=-k;l=-j;n=-h;if(W){W=0;do{Da=c[e+160+(W<<2)>>2]|0;g[e+144>>2]=+g[e+288+(Da*3<<2)>>2]+ +g[f>>2];g[e+148>>2]=+g[e+288+((Da*3|0)+1<<2)>>2]+ +g[a>>2];g[e+152>>2]=+g[e+288+((Da*3|0)+2<<2)>>2]+ +g[b>>2];Ca=c[(c[d>>2]|0)+16>>2]|0;g[e+128>>2]=n;g[e+132>>2]=l;g[e+136>>2]=m;g[e+140>>2]=0.0;qc[Ca&15](d,e+128|0,e+144|0,-+g[e+256+(Da<<2)>>2]);W=W+1|0}while((W|0)<(fa|0));i=e;return}else{W=0;do{Ca=c[e+160+(W<<2)>>2]|0;oa=+g[e+288+(Ca*3<<2)>>2]+ +g[f>>2];g[e+144>>2]=oa;qa=+g[e+288+((Ca*3|0)+1<<2)>>2]+ +g[a>>2];g[e+148>>2]=qa;ra=+g[e+288+((Ca*3|0)+2<<2)>>2]+ +g[b>>2];g[e+152>>2]=ra;Da=c[(c[d>>2]|0)+16>>2]|0;g[e+112>>2]=n;g[e+116>>2]=l;g[e+120>>2]=m;g[e+124>>2]=0.0;va=+g[e+256+(Ca<<2)>>2];g[e+96>>2]=oa-h*va;g[e+100>>2]=qa-va*j;g[e+104>>2]=ra-va*k;g[e+108>>2]=0.0;qc[Da&15](d,e+112|0,e+96|0,-va);W=W+1|0}while((W|0)<(fa|0));i=e;return}}function GC(a){a=a|0;return}function HC(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function IC(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;i=i+32|0;h=(a[b+28>>0]|0)!=0;f=h?e:d;e=h?d:e;d=c[f+4>>2]|0;h=c[d+16>>2]|0;j=c[b+12>>2]|0;if((j|0)<(h|0)){if((c[b+16>>2]|0)<(h|0)){if(!h){k=0;m=j}else{c[5004]=(c[5004]|0)+1;k=fF((h<<2|3)+16|0)|0;if(!k)k=0;else{c[(k+19&-16)+ -4>>2]=k;k=k+19&-16}m=c[b+12>>2]|0}if((m|0)>0){l=0;do{n=k+(l<<2)|0;if(n)c[n>>2]=c[(c[b+20>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(m|0))}l=c[b+20>>2]|0;if(l){if(a[b+24>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[l+ -4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=k;c[b+16>>2]=h;k=b+20|0}else k=b+20|0;do{l=(c[k>>2]|0)+(j<<2)|0;if(l)c[l>>2]=0;j=j+1|0}while((j|0)!=(h|0))}c[b+12>>2]=h;if((h|0)<=0){i=g;return}j=0;do{if(!(c[d+64>>2]|0)){l=c[(c[d+24>>2]|0)+(j*80|0)+64>>2]|0;m=c[f+8>>2]|0;n=c[f+12>>2]|0;c[g>>2]=f;c[g+4>>2]=l;c[g+8>>2]=m;c[g+12>>2]=n;c[g+16>>2]=-1;c[g+20>>2]=j;n=c[b+4>>2]|0;n=Tb[c[(c[n>>2]|0)+8>>2]&31](n,g,e,c[b+32>>2]|0)|0;c[(c[b+20>>2]|0)+(j<<2)>>2]=n}else c[(c[b+20>>2]|0)+(j<<2)>>2]=0;j=j+1|0}while((j|0)!=(h|0));i=g;return}function JC(a){a=a|0;var b=0;b=i;KC(a);gF(a);i=b;return}function KC(b){b=b|0;var d=0,e=0,f=0,g=0;d=i;c[b>>2]=18040;e=c[b+12>>2]|0;if((e|0)>0){f=0;do{g=c[(c[b+20>>2]|0)+(f<<2)>>2]|0;if(g){Lb[c[c[g>>2]>>2]&511](g);g=c[b+4>>2]|0;Nb[c[(c[g>>2]|0)+60>>2]&127](g,c[(c[b+20>>2]|0)+(f<<2)>>2]|0)}f=f+1|0}while((f|0)!=(e|0))}e=c[b+20>>2]|0;if(!e){a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;g=b+16|0;c[g>>2]=0;i=d;return}if(a[b+24>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+20>>2]=0;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;g=b+16|0;c[g>>2]=0;i=d;return}function LC(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0;j=i;i=i+320|0;k=(a[b+28>>0]|0)!=0;m=k?e:d;k=k?d:e;l=c[m+4>>2]|0;if((c[l+68>>2]|0)!=(c[b+40>>2]|0)){p=c[b+12>>2]|0;if((p|0)>0){o=0;do{n=c[(c[b+20>>2]|0)+(o<<2)>>2]|0;if(n){Lb[c[c[n>>2]>>2]&511](n);s=c[b+4>>2]|0;Nb[c[(c[s>>2]|0)+60>>2]&127](s,c[(c[b+20>>2]|0)+(o<<2)>>2]|0)}o=o+1|0}while((o|0)!=(p|0))}IC(b,d,e)}d=c[l+64>>2]|0;n=c[b+4>>2]|0;q=c[b+20>>2]|0;o=c[b+32>>2]|0;c[j+280>>2]=18120;c[j+284>>2]=m;c[j+288>>2]=k;c[j+292>>2]=n;c[j+296>>2]=f;c[j+300>>2]=h;c[j+304>>2]=q;c[j+308>>2]=o;f=j+272|0;a[f>>0]=1;o=j+268|0;c[o>>2]=0;n=j+260|0;c[n>>2]=0;c[j+264>>2]=0;e=c[b+12>>2]|0;if((e|0)>0){p=0;while(1){q=c[q+(p<<2)>>2]|0;if(q){Nb[c[(c[q>>2]|0)+16>>2]&127](q,j+256|0);e=c[n>>2]|0;if((e|0)>0){r=e;e=0;do{q=c[(c[o>>2]|0)+(e<<2)>>2]|0;if(c[q+748>>2]|0){c[h+4>>2]=q;s=c[q+740>>2]|0;r=c[(c[h+8>>2]|0)+8>>2]|0;if((s|0)==(r|0))xA(q,s+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);else xA(q,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,r+4|0);c[h+4>>2]=0;r=c[n>>2]|0}e=e+1|0}while((e|0)<(r|0));e=r}if((e|0)<0){if((c[j+264>>2]|0)<0){r=c[o>>2]|0;if((e|0)>0){q=0;do{if(q)c[0+(q<<2)>>2]=c[r+(q<<2)>>2];q=q+1|0}while((q|0)!=(e|0))}if(r){if(a[f>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[r+ -4>>2]|0)}c[o>>2]=0}a[f>>0]=1;c[o>>2]=0;c[j+264>>2]=0}do{q=(c[o>>2]|0)+(e<<2)|0;if(q)c[q>>2]=0;e=e+1|0}while((e|0)!=0)}c[n>>2]=0;e=c[b+12>>2]|0}p=p+1|0;if((p|0)>=(e|0))break;q=c[b+20>>2]|0}h=c[o>>2]|0;if(h){if(a[f>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[o>>2]=0}}a[f>>0]=1;c[o>>2]=0;c[n>>2]=0;c[j+264>>2]=0;if(!d){h=c[b+12>>2]|0;if((h|0)>0){d=0;do{MC(j+280|0,c[(c[l+24>>2]|0)+(d*80|0)+64>>2]|0,d);d=d+1|0}while((d|0)<(h|0))}else{i=j;return}}else{s=c[m+12>>2]|0;H=+g[s>>2];G=+g[s+16>>2];F=+g[s+32>>2];E=+g[s+4>>2];D=+g[s+20>>2];C=+g[s+36>>2];y=+g[s+8>>2];w=+g[s+24>>2];u=+g[s+40>>2];B=-+g[s+48>>2];A=-+g[s+52>>2];z=-+g[s+56>>2];s=c[k+12>>2]|0;Q=+g[s>>2];P=+g[s+16>>2];O=+g[s+32>>2];N=+g[s+4>>2];M=+g[s+20>>2];L=+g[s+36>>2];K=+g[s+8>>2];J=+g[s+24>>2];I=+g[s+40>>2];x=+g[s+48>>2];v=+g[s+52>>2];t=+g[s+56>>2];g[j+160>>2]=H*Q+G*P+F*O;g[j+164>>2]=H*N+G*M+F*L;g[j+168>>2]=H*K+G*J+F*I;g[j+172>>2]=0.0;g[j+176>>2]=E*Q+D*P+C*O;g[j+180>>2]=E*N+D*M+C*L;g[j+184>>2]=E*K+D*J+C*I;g[j+188>>2]=0.0;g[j+192>>2]=y*Q+w*P+u*O;g[j+196>>2]=y*N+w*M+u*L;g[j+200>>2]=y*K+w*J+u*I;g[j+204>>2]=0.0;g[j+208>>2]=H*B+G*A+F*z+(H*x+G*v+F*t);g[j+212>>2]=E*B+D*A+C*z+(E*x+D*v+C*t);g[j+216>>2]=y*B+w*A+u*z+(y*x+w*v+u*t);g[j+220>>2]=0.0;s=c[k+4>>2]|0;vc[c[(c[s>>2]|0)+8>>2]&127](s,j+160|0,j+240|0,j+224|0);c[j+128>>2]=c[j+240>>2];c[j+132>>2]=c[j+244>>2];c[j+136>>2]=c[j+248>>2];c[j+140>>2]=c[j+252>>2];c[j+144>>2]=c[j+224>>2];c[j+148>>2]=c[j+228>>2];c[j+152>>2]=c[j+232>>2];c[j+156>>2]=c[j+236>>2];by(c[d>>2]|0,j+128|0,j+280|0)}h=c[b+12>>2]|0;if((h|0)<=0){i=j;return}d=0;do{do if(c[(c[b+20>>2]|0)+(d<<2)>>2]|0){q=c[l+24>>2]|0;s=c[q+(d*80|0)+64>>2]|0;r=c[m+12>>2]|0;w=+g[r>>2];x=+g[r+4>>2];y=+g[r+8>>2];z=+g[r+16>>2];A=+g[r+20>>2];B=+g[r+24>>2];I=+g[r+32>>2];K=+g[r+36>>2];M=+g[r+40>>2];C=+g[q+(d*80|0)>>2];D=+g[q+(d*80|0)+16>>2];E=+g[q+(d*80|0)+32>>2];F=+g[q+(d*80|0)+4>>2];G=+g[q+(d*80|0)+20>>2];H=+g[q+(d*80|0)+36>>2];J=+g[q+(d*80|0)+8>>2];L=+g[q+(d*80|0)+24>>2];N=+g[q+(d*80|0)+40>>2];u=+g[q+(d*80|0)+48>>2];v=+g[q+(d*80|0)+52>>2];Q=+g[q+(d*80|0)+56>>2];O=+g[r+48>>2]+(w*u+x*v+y*Q);P=+g[r+52>>2]+(z*u+A*v+B*Q);Q=+g[r+56>>2]+(I*u+K*v+M*Q);g[j+64>>2]=w*C+x*D+y*E;g[j+68>>2]=w*F+x*G+y*H;g[j+72>>2]=w*J+x*L+y*N;g[j+76>>2]=0.0;g[j+80>>2]=z*C+A*D+B*E;g[j+84>>2]=z*F+A*G+B*H;g[j+88>>2]=z*J+A*L+B*N;g[j+92>>2]=0.0;g[j+96>>2]=I*C+K*D+M*E;g[j+100>>2]=I*F+K*G+M*H;g[j+104>>2]=I*J+K*L+M*N;g[j+108>>2]=0.0;g[j+112>>2]=O;g[j+116>>2]=P;g[j+120>>2]=Q;g[j+124>>2]=0.0;vc[c[(c[s>>2]|0)+8>>2]&127](s,j+64|0,j+48|0,j+32|0);s=c[k+4>>2]|0;vc[c[(c[s>>2]|0)+8>>2]&127](s,c[k+12>>2]|0,j+16|0,j);if(!(+g[j+48>>2]>+g[j>>2])?!(+g[j+32>>2]<+g[j+16>>2]):0)f=1;else f=0;if(!(!(+g[j+56>>2]>+g[j+8>>2])?!(+g[j+40>>2]<+g[j+24>>2]):0))f=0;if(!(+g[j+52>>2]>+g[j+4>>2])?!(+g[j+36>>2]<+g[j+20>>2]|f^1):0)break;s=c[(c[b+20>>2]|0)+(d<<2)>>2]|0;Lb[c[c[s>>2]>>2]&511](s);s=c[b+4>>2]|0;Nb[c[(c[s>>2]|0)+60>>2]&127](s,c[(c[b+20>>2]|0)+(d<<2)>>2]|0);c[(c[b+20>>2]|0)+(d<<2)>>2]=0}while(0);d=d+1|0}while((d|0)<(h|0));i=j;return}function MC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;e=i;i=i+160|0;f=c[a+4>>2]|0;h=c[f+12>>2]|0;D=+g[h>>2];C=+g[h+4>>2];B=+g[h+8>>2];A=+g[h+16>>2];z=+g[h+20>>2];y=+g[h+24>>2];r=+g[h+32>>2];p=+g[h+36>>2];n=+g[h+40>>2];f=c[(c[f+4>>2]|0)+24>>2]|0;x=+g[f+(d*80|0)>>2];w=+g[f+(d*80|0)+16>>2];v=+g[f+(d*80|0)+32>>2];u=+g[f+(d*80|0)+4>>2];t=+g[f+(d*80|0)+20>>2];s=+g[f+(d*80|0)+36>>2];q=+g[f+(d*80|0)+8>>2];o=+g[f+(d*80|0)+24>>2];m=+g[f+(d*80|0)+40>>2];F=+g[f+(d*80|0)+48>>2];E=+g[f+(d*80|0)+52>>2];j=+g[f+(d*80|0)+56>>2];l=+g[h+48>>2]+(D*F+C*E+B*j);k=+g[h+52>>2]+(A*F+z*E+y*j);j=+g[h+56>>2]+(r*F+p*E+n*j);g[e+88>>2]=D*x+C*w+B*v;g[e+92>>2]=D*u+C*t+B*s;g[e+96>>2]=D*q+C*o+B*m;g[e+100>>2]=0.0;g[e+104>>2]=A*x+z*w+y*v;g[e+108>>2]=A*u+z*t+y*s;g[e+112>>2]=A*q+z*o+y*m;g[e+116>>2]=0.0;g[e+120>>2]=r*x+p*w+n*v;g[e+124>>2]=r*u+p*t+n*s;g[e+128>>2]=r*q+p*o+n*m;g[e+132>>2]=0.0;g[e+136>>2]=l;g[e+140>>2]=k;g[e+144>>2]=j;g[e+148>>2]=0.0;vc[c[(c[b>>2]|0)+8>>2]&127](b,e+88|0,e+72|0,e+56|0);h=c[a+8>>2]|0;f=c[h+4>>2]|0;vc[c[(c[f>>2]|0)+8>>2]&127](f,c[h+12>>2]|0,e+40|0,e+24|0);if(!(+g[e+72>>2]>+g[e+24>>2])?!(+g[e+56>>2]<+g[e+40>>2]):0)f=1;else f=0;if(!(!(+g[e+80>>2]>+g[e+32>>2])?!(+g[e+64>>2]<+g[e+48>>2]):0))f=0;if(+g[e+76>>2]>+g[e+28>>2]){i=e;return}if(+g[e+60>>2]<+g[e+44>>2]|f^1){i=e;return}f=c[a+4>>2]|0;h=c[f+8>>2]|0;c[e>>2]=f;c[e+4>>2]=b;c[e+8>>2]=h;c[e+12>>2]=e+88;c[e+16>>2]=-1;c[e+20>>2]=d;if(!(c[(c[a+24>>2]|0)+(d<<2)>>2]|0)){b=c[a+12>>2]|0;b=Tb[c[(c[b>>2]|0)+8>>2]&31](b,e,c[a+8>>2]|0,c[a+28>>2]|0)|0;c[(c[a+24>>2]|0)+(d<<2)>>2]=b;b=c[a+4>>2]|0}else b=f;h=c[a+20>>2]|0;f=c[h+8>>2]|0;if((c[f+8>>2]|0)==(c[b+8>>2]|0)){c[h+8>>2]=e;h=c[a+20>>2]|0;rc[c[(c[h>>2]|0)+8>>2]&127](h,-1,d)}else{f=c[h+12>>2]|0;c[h+12>>2]=e;h=c[a+20>>2]|0;rc[c[(c[h>>2]|0)+12>>2]&127](h,-1,d)}d=c[(c[a+24>>2]|0)+(d<<2)>>2]|0;Jb[c[(c[d>>2]|0)+8>>2]&31](d,e,c[a+8>>2]|0,c[a+16>>2]|0,c[a+20>>2]|0);d=c[a+20>>2]|0;if((c[(c[d+8>>2]|0)+8>>2]|0)==(c[(c[a+4>>2]|0)+8>>2]|0)){c[d+8>>2]=f;i=e;return}else{c[d+12>>2]=f;i=e;return}}function NC(a){a=a|0;return}function OC(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0;j=i;t=(a[b+28>>0]|0)!=0;k=t?e:d;d=t?d:e;t=c[b+12>>2]|0;if((t|0)<=0){E=1.0;i=j;return+E}n=(c[k+192>>2]|0)+24|0;o=+g[k+4>>2];p=+g[k+8>>2];q=+g[k+12>>2];A=+g[k+16>>2];r=+g[k+20>>2];s=+g[k+24>>2];l=+g[k+28>>2];B=+g[k+32>>2];u=+g[k+36>>2];v=+g[k+40>>2];w=+g[k+44>>2];C=+g[k+48>>2];x=+g[k+52>>2];y=+g[k+56>>2];z=+g[k+60>>2];D=+g[k+64>>2];e=c[k+260>>2]|0;E=1.0;m=0;do{G=c[n>>2]|0;R=+g[G+(m*80|0)>>2];Q=+g[G+(m*80|0)+16>>2];P=+g[G+(m*80|0)+32>>2];O=+g[G+(m*80|0)+4>>2];N=+g[G+(m*80|0)+20>>2];M=+g[G+(m*80|0)+36>>2];L=+g[G+(m*80|0)+8>>2];K=+g[G+(m*80|0)+24>>2];J=+g[G+(m*80|0)+40>>2];I=+g[G+(m*80|0)+48>>2];H=+g[G+(m*80|0)+52>>2];F=+g[G+(m*80|0)+56>>2];c[k+260>>2]=e+1;g[k+4>>2]=o*R+p*Q+q*P;g[k+8>>2]=o*O+p*N+q*M;g[k+12>>2]=o*L+p*K+q*J;g[k+16>>2]=0.0;g[k+20>>2]=r*R+s*Q+l*P;g[k+24>>2]=r*O+s*N+l*M;g[k+28>>2]=r*L+s*K+l*J;g[k+32>>2]=0.0;g[k+36>>2]=u*R+v*Q+w*P;g[k+40>>2]=u*O+v*N+w*M;g[k+44>>2]=u*L+v*K+w*J;g[k+48>>2]=0.0;g[k+52>>2]=x+(o*I+p*H+q*F);g[k+56>>2]=y+(r*I+s*H+l*F);g[k+60>>2]=z+(u*I+v*H+w*F);g[k+64>>2]=0.0;G=c[(c[b+20>>2]|0)+(m<<2)>>2]|0;F=+Xb[c[(c[G>>2]|0)+12>>2]&15](G,k,d,f,h);E=F<E?F:E;e=(c[k+260>>2]|0)+1|0;c[k+260>>2]=e;g[k+4>>2]=o;g[k+8>>2]=p;g[k+12>>2]=q;g[k+16>>2]=A;g[k+20>>2]=r;g[k+24>>2]=s;g[k+28>>2]=l;g[k+32>>2]=B;g[k+36>>2]=u;g[k+40>>2]=v;g[k+44>>2]=w;g[k+48>>2]=C;g[k+52>>2]=x;g[k+56>>2]=y;g[k+60>>2]=z;g[k+64>>2]=D;m=m+1|0}while((m|0)!=(t|0));i=j;return+E}function PC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;f=c[a+12>>2]|0;if((f|0)<=0){i=d;return}e=0;do{g=c[(c[a+20>>2]|0)+(e<<2)>>2]|0;if(g){Nb[c[(c[g>>2]|0)+16>>2]&127](g,b);f=c[a+12>>2]|0}e=e+1|0}while((e|0)<(f|0));i=d;return}function QC(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function RC(a,b){a=a|0;b=b|0;var d=0;d=i;b=c[b+36>>2]|0;MC(a,c[(c[(c[(c[a+4>>2]|0)+4>>2]|0)+24>>2]|0)+(b*80|0)+64>>2]|0,b);i=d;return}function SC(a){a=a|0;var b=0;b=i;TC(a);gF(a);i=b;return}function TC(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;c[b>>2]=18208;f=c[b+8>>2]|0;e=c[f+8>>2]|0;if((e|0)>0){g=0;do{h=c[(c[f+16>>2]|0)+(g*12|0)+8>>2]|0;if(h){Lb[c[c[h>>2]>>2]&511](h);j=c[b+4>>2]|0;Nb[c[(c[j>>2]|0)+60>>2]&127](j,h)}g=g+1|0}while((g|0)!=(e|0));f=c[b+8>>2]|0}ZD(f);e=c[b+8>>2]|0;Lb[c[c[e>>2]>>2]&511](e);e=c[b+8>>2]|0;if(e){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}e=c[b+24>>2]|0;if(!e){a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;j=b+20|0;c[j>>2]=0;i=d;return}if(a[b+28>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+24>>2]=0;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;j=b+20|0;c[j>>2]=0;i=d;return}function UC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;a=c[a+8>>2]|0;f=c[a+8>>2]|0;if((f|0)<=0){i=d;return}e=0;do{g=c[(c[a+16>>2]|0)+(e*12|0)+8>>2]|0;if(g){Nb[c[(c[g>>2]|0)+16>>2]&127](g,b);f=c[a+8>>2]|0}e=e+1|0}while((e|0)<(f|0));i=d;return}function VC(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0;j=i;i=i+192|0;k=c[d+4>>2]|0;m=c[e+4>>2]|0;if((c[k+68>>2]|0)==(c[b+40>>2]|0)?(c[m+68>>2]|0)==(c[b+44>>2]|0):0)n=b+8|0;else{n=c[b+8>>2]|0;Y=c[n+8>>2]|0;if((Y|0)>0){X=0;do{W=c[(c[n+16>>2]|0)+(X*12|0)+8>>2]|0;if(W){Lb[c[c[W>>2]>>2]&511](W);ca=c[b+4>>2]|0;Nb[c[(c[ca>>2]|0)+60>>2]&127](ca,W)}X=X+1|0}while((X|0)!=(Y|0));n=c[b+8>>2]|0}ZD(n);n=b+8|0}W=j+180|0;a[W>>0]=1;X=j+176|0;c[X>>2]=0;Y=j+168|0;c[Y>>2]=0;c[j+172>>2]=0;Z=c[n>>2]|0;$=c[Z+8>>2]|0;if(($|0)>0){_=0;do{aa=c[(c[Z+16>>2]|0)+(_*12|0)+8>>2]|0;if(aa){Nb[c[(c[aa>>2]|0)+16>>2]&127](aa,j+164|0);ba=c[Y>>2]|0;if((ba|0)>0){$=0;do{aa=c[(c[X>>2]|0)+($<<2)>>2]|0;if(c[aa+748>>2]|0){c[h+4>>2]=aa;ba=c[aa+740>>2]|0;ca=c[(c[h+8>>2]|0)+8>>2]|0;if((ba|0)==(ca|0))xA(aa,ba+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);else xA(aa,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,ca+4|0);c[h+4>>2]=0;ba=c[Y>>2]|0}$=$+1|0}while(($|0)<(ba|0))}if((ba|0)<0){if((c[j+172>>2]|0)<0){$=c[X>>2]|0;if((ba|0)>0){aa=0;do{if(aa)c[0+(aa<<2)>>2]=c[$+(aa<<2)>>2];aa=aa+1|0}while((aa|0)!=(ba|0))}if($){if(a[W>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[$+ -4>>2]|0)}c[X>>2]=0}a[W>>0]=1;c[X>>2]=0;c[j+172>>2]=0}do{$=(c[X>>2]|0)+(ba<<2)|0;if($)c[$>>2]=0;ba=ba+1|0}while((ba|0)!=0)}c[Y>>2]=0;$=c[Z+8>>2]|0}_=_+1|0}while((_|0)<($|0));Z=c[X>>2]|0;if(Z){if(a[W>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[Z+ -4>>2]|0)}c[X>>2]=0}}a[W>>0]=1;c[X>>2]=0;c[Y>>2]=0;c[j+172>>2]=0;ba=c[k+64>>2]|0;ca=c[m+64>>2]|0;_=c[b+4>>2]|0;$=c[n>>2]|0;aa=c[b+32>>2]|0;c[j+128>>2]=18296;c[j+132>>2]=0;c[j+136>>2]=d;c[j+140>>2]=e;c[j+144>>2]=_;c[j+148>>2]=f;c[j+152>>2]=h;c[j+156>>2]=$;c[j+160>>2]=aa;f=c[d+12>>2]|0;z=+g[f>>2];B=+g[f+16>>2];D=+g[f+32>>2];t=+g[f+4>>2];s=+g[f+20>>2];r=+g[f+36>>2];q=+g[f+8>>2];p=+g[f+24>>2];o=+g[f+40>>2];A=-+g[f+48>>2];C=-+g[f+52>>2];E=-+g[f+56>>2];f=c[e+12>>2]|0;I=+g[f>>2];J=+g[f+16>>2];K=+g[f+32>>2];L=+g[f+4>>2];y=+g[f+20>>2];x=+g[f+36>>2];w=+g[f+8>>2];v=+g[f+24>>2];u=+g[f+40>>2];F=+g[f+48>>2];G=+g[f+52>>2];H=+g[f+56>>2];f=c[ba>>2]|0;h=c[ca>>2]|0;if(!((f|0)==0|(h|0)==0)){c[5004]=(c[5004]|0)+1;_=fF(1043)|0;c[(_+19&-16)+ -4>>2]=_;c[(_+19&-16)>>2]=f;c[(_+19&-16)+4>>2]=h;V=+P(+(z*I+B*J+D*K));U=+P(+(z*L+B*y+D*x));T=+P(+(z*w+B*v+D*u));M=+P(+(t*I+s*J+r*K));S=+P(+(t*L+s*y+r*x));R=+P(+(t*w+s*v+r*u));Q=+P(+(q*I+p*J+o*K));O=+P(+(q*L+p*y+o*x));N=+P(+(q*w+p*v+o*u));_=_+19&-16;Y=128;$=128;f=1;Z=124;do{h=f+ -1|0;X=c[_+(h<<3)>>2]|0;W=c[_+(h<<3)+4>>2]|0;na=+g[W+16>>2];ma=+g[W>>2];la=+g[W+20>>2];ka=+g[W+4>>2];ja=+g[W+24>>2];da=+g[W+8>>2];ia=z*A+B*C+D*E+(z*F+B*G+D*H)+((z*I+B*J+D*K)*(na+ma)*.5+(z*L+B*y+D*x)*(la+ka)*.5+(z*w+B*v+D*u)*(ja+da)*.5);ga=t*A+s*C+r*E+(t*F+s*G+r*H)+((t*I+s*J+r*K)*(na+ma)*.5+(t*L+s*y+r*x)*(la+ka)*.5+(t*w+s*v+r*u)*(ja+da)*.5);ea=q*A+p*C+o*E+(q*F+p*G+o*H)+((q*I+p*J+o*K)*(na+ma)*.5+(q*L+p*y+o*x)*(la+ka)*.5+(q*w+p*v+o*u)*(ja+da)*.5);ha=((na-ma)*.5+0.0)*V+((la-ka)*.5+0.0)*U+((ja-da)*.5+0.0)*T;fa=((na-ma)*.5+0.0)*M+((la-ka)*.5+0.0)*S+((ja-da)*.5+0.0)*R;da=((na-ma)*.5+0.0)*Q+((la-ka)*.5+0.0)*O+((ja-da)*.5+0.0)*N;do if(((((+g[X>>2]<=ha+ia?+g[X+16>>2]>=ia-ha:0)?+g[X+4>>2]<=ga+fa:0)?+g[X+20>>2]>=ga-fa:0)?+g[X+8>>2]<=ea+da:0)?+g[X+24>>2]>=ea-da:0){if((h|0)>(Z|0)){Z=Y<<1;if((Y|0)<(Z|0)&($|0)<(Z|0)){if(Y){c[5004]=(c[5004]|0)+1;$=fF((Y<<4|3)+16|0)|0;if(!$)$=0;else{c[($+19&-16)+ -4>>2]=$;$=$+19&-16}if((Y|0)>0){aa=0;do{ba=$+(aa<<3)|0;if(ba){oa=_+(aa<<3)|0;ca=c[oa+4>>2]|0;c[ba>>2]=c[oa>>2];c[ba+4>>2]=ca}aa=aa+1|0}while((aa|0)!=(Y|0))}}else $=0;if(!_){_=$;$=Z}else{c[5006]=(c[5006]|0)+1;gF(c[_+ -4>>2]|0);_=$;$=Z}}Y=Z;Z=Z+ -4|0}aa=(c[W+40>>2]|0)!=0;if(!(c[X+40>>2]|0))if(aa){oa=c[W+36>>2]|0;ca=_+(h<<3)|0;c[ca>>2]=X;c[ca+4>>2]=oa;ca=c[W+40>>2]|0;oa=_+(f<<3)|0;c[oa>>2]=X;c[oa+4>>2]=ca;f=f+1|0;break}else{rc[c[(c[j+128>>2]|0)+8>>2]&127](j+128|0,X,W);f=h;break}else{h=_+(h<<3)|0;ba=c[X+36>>2]|0;if(aa){ca=c[W+36>>2]|0;c[h>>2]=ba;c[h+4>>2]=ca;ca=c[W+36>>2]|0;oa=_+(f<<3)|0;c[oa>>2]=c[X+40>>2];c[oa+4>>2]=ca;oa=c[W+40>>2]|0;ca=_+(f+1<<3)|0;c[ca>>2]=c[X+36>>2];c[ca+4>>2]=oa;ca=c[W+40>>2]|0;oa=_+(f+2<<3)|0;c[oa>>2]=c[X+40>>2];c[oa+4>>2]=ca;f=f+3|0;break}else{c[h>>2]=ba;c[h+4>>2]=W;oa=_+(f<<3)|0;c[oa>>2]=c[X+40>>2];c[oa+4>>2]=W;f=f+1|0;break}}}else f=h;while(0)}while((f|0)!=0);if(_){c[5006]=(c[5006]|0)+1;gF(c[_+ -4>>2]|0)}}f=c[n>>2]|0;if((c[f+8>>2]|0)>0){h=0;do{X=c[f+16>>2]|0;W=c[X+(h*12|0)+8>>2]|0;do if(W){oa=c[X+(h*12|0)>>2]|0;ca=c[k+24>>2]|0;ba=c[ca+(oa*80|0)+64>>2]|0;aa=c[d+12>>2]|0;na=+g[aa>>2];K=+g[aa+4>>2];J=+g[aa+8>>2];ka=+g[aa+16>>2];ia=+g[aa+20>>2];ga=+g[aa+24>>2];ja=+g[aa+32>>2];fa=+g[aa+36>>2];Q=+g[aa+40>>2];ea=+g[ca+(oa*80|0)>>2];da=+g[ca+(oa*80|0)+16>>2];V=+g[ca+(oa*80|0)+32>>2];U=+g[ca+(oa*80|0)+4>>2];T=+g[ca+(oa*80|0)+20>>2];S=+g[ca+(oa*80|0)+36>>2];ha=+g[ca+(oa*80|0)+8>>2];R=+g[ca+(oa*80|0)+24>>2];O=+g[ca+(oa*80|0)+40>>2];ma=+g[ca+(oa*80|0)+48>>2];la=+g[ca+(oa*80|0)+52>>2];L=+g[ca+(oa*80|0)+56>>2];N=+g[aa+48>>2]+(na*ma+K*la+J*L);M=+g[aa+52>>2]+(ka*ma+ia*la+ga*L);L=+g[aa+56>>2]+(ja*ma+fa*la+Q*L);g[j>>2]=na*ea+K*da+J*V;g[j+4>>2]=na*U+K*T+J*S;g[j+8>>2]=na*ha+K*R+J*O;g[j+12>>2]=0.0;g[j+16>>2]=ka*ea+ia*da+ga*V;g[j+20>>2]=ka*U+ia*T+ga*S;g[j+24>>2]=ka*ha+ia*R+ga*O;g[j+28>>2]=0.0;g[j+32>>2]=ja*ea+fa*da+Q*V;g[j+36>>2]=ja*U+fa*T+Q*S;g[j+40>>2]=ja*ha+fa*R+Q*O;g[j+44>>2]=0.0;g[j+48>>2]=N;g[j+52>>2]=M;g[j+56>>2]=L;g[j+60>>2]=0.0;vc[c[(c[ba>>2]|0)+8>>2]&127](ba,j,j+112|0,j+96|0);ba=c[(c[f+16>>2]|0)+(h*12|0)+4>>2]|0;aa=c[m+24>>2]|0;oa=c[aa+(ba*80|0)+64>>2]|0;ca=c[e+12>>2]|0;L=+g[ca>>2];M=+g[ca+4>>2];N=+g[ca+8>>2];O=+g[ca+16>>2];Q=+g[ca+20>>2];R=+g[ca+24>>2];fa=+g[ca+32>>2];ha=+g[ca+36>>2];ja=+g[ca+40>>2];S=+g[aa+(ba*80|0)>>2];T=+g[aa+(ba*80|0)+16>>2];U=+g[aa+(ba*80|0)+32>>2];V=+g[aa+(ba*80|0)+4>>2];da=+g[aa+(ba*80|0)+20>>2];ea=+g[aa+(ba*80|0)+36>>2];ga=+g[aa+(ba*80|0)+8>>2];ia=+g[aa+(ba*80|0)+24>>2];ka=+g[aa+(ba*80|0)+40>>2];J=+g[aa+(ba*80|0)+48>>2];K=+g[aa+(ba*80|0)+52>>2];na=+g[aa+(ba*80|0)+56>>2];la=+g[ca+48>>2]+(L*J+M*K+N*na);ma=+g[ca+52>>2]+(O*J+Q*K+R*na);na=+g[ca+56>>2]+(fa*J+ha*K+ja*na);g[j>>2]=L*S+M*T+N*U;g[j+4>>2]=L*V+M*da+N*ea;g[j+8>>2]=L*ga+M*ia+N*ka;g[j+12>>2]=0.0;g[j+16>>2]=O*S+Q*T+R*U;g[j+20>>2]=O*V+Q*da+R*ea;g[j+24>>2]=O*ga+Q*ia+R*ka;g[j+28>>2]=0.0;g[j+32>>2]=fa*S+ha*T+ja*U;g[j+36>>2]=fa*V+ha*da+ja*ea;g[j+40>>2]=fa*ga+ha*ia+ja*ka;g[j+44>>2]=0.0;g[j+48>>2]=la;g[j+52>>2]=ma;g[j+56>>2]=na;g[j+60>>2]=0.0;vc[c[(c[oa>>2]|0)+8>>2]&127](oa,j,j+80|0,j+64|0);if(!(+g[j+112>>2]>+g[j+64>>2])?!(+g[j+96>>2]<+g[j+80>>2]):0)X=1;else X=0;if(!(!(+g[j+120>>2]>+g[j+72>>2])?!(+g[j+104>>2]<+g[j+88>>2]):0))X=0;if(!(+g[j+116>>2]>+g[j+68>>2])?!(+g[j+100>>2]<+g[j+84>>2]|X^1):0)break;Lb[c[c[W>>2]>>2]&511](W);X=c[b+4>>2]|0;Nb[c[(c[X>>2]|0)+60>>2]&127](X,W);X=c[f+16>>2]|0;W=c[X+(h*12|0)>>2]|0;X=c[X+(h*12|0)+4>>2]|0;$=c[b+16>>2]|0;if(($|0)==(c[b+20>>2]|0)?(l=($|0)==0?1:$<<1,($|0)<(l|0)):0){if(!l)Y=0;else{c[5004]=(c[5004]|0)+1;Y=fF((l*12|3)+16|0)|0;if(!Y)Y=0;else{c[(Y+19&-16)+ -4>>2]=Y;Y=Y+19&-16}$=c[b+16>>2]|0}if(($|0)>0){_=0;do{Z=Y+(_*12|0)|0;if(Z){oa=(c[b+24>>2]|0)+(_*12|0)|0;c[Z+0>>2]=c[oa+0>>2];c[Z+4>>2]=c[oa+4>>2];c[Z+8>>2]=c[oa+8>>2]}_=_+1|0}while((_|0)!=($|0))}Z=c[b+24>>2]|0;if(Z){if(a[b+28>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[Z+ -4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=Y;c[b+20>>2]=l;$=c[b+16>>2]|0}Z=c[b+24>>2]|0;Y=Z+($*12|0)|0;if(Y){c[Y>>2]=W;c[Z+($*12|0)+4>>2]=X;c[Z+($*12|0)+8>>2]=0;$=c[b+16>>2]|0}c[b+16>>2]=$+1}while(0);h=h+1|0}while((h|0)<(c[f+8>>2]|0));d=b+24|0;e=b+16|0}else{d=b+24|0;e=b+16|0}if((c[e>>2]|0)>0){k=0;do{ca=c[n>>2]|0;oa=c[d>>2]|0;Yb[c[(c[ca>>2]|0)+8>>2]&31](ca,c[oa+(k*12|0)>>2]|0,c[oa+(k*12|0)+4>>2]|0)|0;k=k+1|0}while((k|0)<(c[e>>2]|0))}k=c[d>>2]|0;if(!k){a[b+28>>0]=1;c[d>>2]=0;c[e>>2]=0;oa=b+20|0;c[oa>>2]=0;i=j;return}if(a[b+28>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[k+ -4>>2]|0)}c[d>>2]=0;a[b+28>>0]=1;c[d>>2]=0;c[e>>2]=0;oa=b+20|0;c[oa>>2]=0;i=j;return}function WC(a){a=a|0;return}function XC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 0.0}function YC(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function ZC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0;f=i;i=i+240|0;c[a+4>>2]=(c[a+4>>2]|0)+1;b=c[b+36>>2]|0;d=c[d+36>>2]|0;l=c[a+8>>2]|0;K=c[(c[l+4>>2]|0)+24>>2]|0;j=c[K+(b*80|0)+64>>2]|0;J=(c[(c[a+12>>2]|0)+4>>2]|0)+24|0;k=c[(c[J>>2]|0)+(d*80|0)+64>>2]|0;l=c[l+12>>2]|0;m=+g[l>>2];H=+g[l+4>>2];I=+g[l+8>>2];p=+g[l+16>>2];r=+g[l+20>>2];t=+g[l+24>>2];q=+g[l+32>>2];u=+g[l+36>>2];C=+g[l+40>>2];v=+g[K+(b*80|0)>>2];w=+g[K+(b*80|0)+16>>2];x=+g[K+(b*80|0)+32>>2];y=+g[K+(b*80|0)+4>>2];z=+g[K+(b*80|0)+20>>2];A=+g[K+(b*80|0)+36>>2];s=+g[K+(b*80|0)+8>>2];B=+g[K+(b*80|0)+24>>2];D=+g[K+(b*80|0)+40>>2];n=+g[K+(b*80|0)+48>>2];o=+g[K+(b*80|0)+52>>2];G=+g[K+(b*80|0)+56>>2];E=+g[l+48>>2]+(m*n+H*o+I*G);F=+g[l+52>>2]+(p*n+r*o+t*G);G=+g[l+56>>2]+(q*n+u*o+C*G);g[f+176>>2]=m*v+H*w+I*x;g[f+180>>2]=m*y+H*z+I*A;g[f+184>>2]=m*s+H*B+I*D;g[f+188>>2]=0.0;g[f+192>>2]=p*v+r*w+t*x;g[f+196>>2]=p*y+r*z+t*A;g[f+200>>2]=p*s+r*B+t*D;g[f+204>>2]=0.0;g[f+208>>2]=q*v+u*w+C*x;g[f+212>>2]=q*y+u*z+C*A;g[f+216>>2]=q*s+u*B+C*D;g[f+220>>2]=0.0;g[f+224>>2]=E;g[f+228>>2]=F;g[f+232>>2]=G;g[f+236>>2]=0.0;l=c[(c[a+12>>2]|0)+12>>2]|0;G=+g[l>>2];F=+g[l+4>>2];E=+g[l+8>>2];D=+g[l+16>>2];C=+g[l+20>>2];B=+g[l+24>>2];u=+g[l+32>>2];s=+g[l+36>>2];q=+g[l+40>>2];J=c[J>>2]|0;A=+g[J+(d*80|0)>>2];z=+g[J+(d*80|0)+16>>2];y=+g[J+(d*80|0)+32>>2];x=+g[J+(d*80|0)+4>>2];w=+g[J+(d*80|0)+20>>2];v=+g[J+(d*80|0)+36>>2];t=+g[J+(d*80|0)+8>>2];r=+g[J+(d*80|0)+24>>2];p=+g[J+(d*80|0)+40>>2];I=+g[J+(d*80|0)+48>>2];H=+g[J+(d*80|0)+52>>2];m=+g[J+(d*80|0)+56>>2];o=+g[l+48>>2]+(G*I+F*H+E*m);n=+g[l+52>>2]+(D*I+C*H+B*m);m=+g[l+56>>2]+(u*I+s*H+q*m);g[f+112>>2]=G*A+F*z+E*y;g[f+116>>2]=G*x+F*w+E*v;g[f+120>>2]=G*t+F*r+E*p;g[f+124>>2]=0.0;g[f+128>>2]=D*A+C*z+B*y;g[f+132>>2]=D*x+C*w+B*v;g[f+136>>2]=D*t+C*r+B*p;g[f+140>>2]=0.0;g[f+144>>2]=u*A+s*z+q*y;g[f+148>>2]=u*x+s*w+q*v;g[f+152>>2]=u*t+s*r+q*p;g[f+156>>2]=0.0;g[f+160>>2]=o;g[f+164>>2]=n;g[f+168>>2]=m;g[f+172>>2]=0.0;vc[c[(c[j>>2]|0)+8>>2]&127](j,f+176|0,f+96|0,f+80|0);vc[c[(c[k>>2]|0)+8>>2]&127](k,f+112|0,f+64|0,f+48|0);if(!(+g[f+96>>2]>+g[f+48>>2])?!(+g[f+80>>2]<+g[f+64>>2]):0)l=1;else l=0;if(!(!(+g[f+104>>2]>+g[f+56>>2])?!(+g[f+88>>2]<+g[f+72>>2]):0))l=0;if(+g[f+100>>2]>+g[f+52>>2]){i=f;return}if(+g[f+84>>2]<+g[f+68>>2]|l^1){i=f;return}J=c[a+8>>2]|0;K=c[J+8>>2]|0;c[f+24>>2]=J;c[f+28>>2]=j;c[f+32>>2]=K;c[f+36>>2]=f+176;c[f+40>>2]=-1;c[f+44>>2]=b;K=c[a+12>>2]|0;j=c[K+8>>2]|0;c[f>>2]=K;c[f+4>>2]=k;c[f+8>>2]=j;c[f+12>>2]=f+112;c[f+16>>2]=-1;c[f+20>>2]=d;j=c[a+28>>2]|0;c[4896]=(c[4896]|0)+1;k=((d<<16|b)+~((d<<16|b)<<15)>>10^(d<<16|b)+~((d<<16|b)<<15))*9|0;k=(c[j+12>>2]|0)+ -1&((k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11));a:do if((k|0)<(c[j+32>>2]|0)?(h=c[(c[j+40>>2]|0)+(k<<2)>>2]|0,(h|0)!=-1):0){k=c[j+16>>2]|0;while(1){if((c[k+(h*12|0)>>2]|0)==(b|0)?(c[k+(h*12|0)+4>>2]|0)==(d|0):0)break;h=c[(c[j+60>>2]|0)+(h<<2)>>2]|0;if((h|0)==-1){e=17;break a}}if(k+(h*12|0)|0)h=c[k+(h*12|0)+8>>2]|0;else e=17}else e=17;while(0);if((e|0)==17){h=c[a+16>>2]|0;h=Tb[c[(c[h>>2]|0)+8>>2]&31](h,f+24|0,f,c[a+32>>2]|0)|0;K=c[a+28>>2]|0;c[(Yb[c[(c[K>>2]|0)+12>>2]&31](K,b,d)|0)+8>>2]=h}l=c[a+24>>2]|0;J=c[l+8>>2]|0;K=c[l+12>>2]|0;c[l+8>>2]=f+24;c[(c[a+24>>2]|0)+12>>2]=f;l=c[a+24>>2]|0;rc[c[(c[l>>2]|0)+8>>2]&127](l,-1,b);l=c[a+24>>2]|0;rc[c[(c[l>>2]|0)+12>>2]&127](l,-1,d);Jb[c[(c[h>>2]|0)+8>>2]&31](h,f+24|0,f,c[a+20>>2]|0,c[a+24>>2]|0);c[(c[a+24>>2]|0)+8>>2]=J;c[(c[a+24>>2]|0)+12>>2]=K;i=f;return}function _C(a,b){a=a|0;b=b|0;return}function $C(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=18432;c[a+12>>2]=18464;d=c[a+60>>2]|0;Nb[c[(c[d>>2]|0)+20>>2]&127](d,c[a+76>>2]|0);d=c[a+60>>2]|0;Nb[c[(c[d>>2]|0)+16>>2]&127](d,c[a+76>>2]|0);gF(a);i=b;return}function aD(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=18432;c[a+12>>2]=18464;d=c[a+60>>2]|0;Nb[c[(c[d>>2]|0)+20>>2]&127](d,c[a+76>>2]|0);d=c[a+60>>2]|0;Nb[c[(c[d>>2]|0)+16>>2]&127](d,c[a+76>>2]|0);i=b;return}function bD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;if(!(c[b+76>>2]|0)){i=e;return}h=c[d+4>>2]|0;if((h|0)==(c[d+8>>2]|0)?(f=(h|0)==0?1:h<<1,(h|0)<(f|0)):0){if(!f)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[d+4>>2]|0}if((h|0)>0){j=0;do{k=g+(j<<2)|0;if(k)c[k>>2]=c[(c[d+12>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+12>>2]|0;if(j){if(a[d+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=g;c[d+8>>2]=f}f=(c[d+12>>2]|0)+(h<<2)|0;if(f)c[f>>2]=c[b+76>>2];c[d+4>>2]=h+1;i=e;return}function cD(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=18464;d=c[a+48>>2]|0;Nb[c[(c[d>>2]|0)+20>>2]&127](d,c[a+64>>2]|0);d=c[a+48>>2]|0;Nb[c[(c[d>>2]|0)+16>>2]&127](d,c[a+64>>2]|0);gF(a);i=b;return}function dD(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=18464;d=c[a+48>>2]|0;Nb[c[(c[d>>2]|0)+20>>2]&127](d,c[a+64>>2]|0);d=c[a+48>>2]|0;Nb[c[(c[d>>2]|0)+16>>2]&127](d,c[a+64>>2]|0);i=b;return}function eD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0.0,p=0;f=i;i=i+128|0;l=+g[b>>2];j=+g[b+16>>2];o=l<j?l:j;k=+g[b+32>>2];if((o<k?o:k)>+g[a+28>>2]){i=f;return}n=l>j?b:b+16|0;if(+g[(+g[n>>2]>k?n:b+32|0)>>2]<+g[a+12>>2]){i=f;return}j=+g[b+8>>2];k=+g[b+24>>2];o=j<k?j:k;l=+g[b+40>>2];if((o<l?o:l)>+g[a+36>>2]){i=f;return}n=j>k?b+8|0:b+24|0;if(+g[(+g[n>>2]>l?n:b+40|0)>>2]<+g[a+20>>2]){i=f;return}l=+g[b+4>>2];j=+g[b+20>>2];o=l<j?l:j;k=+g[b+36>>2];if((o<k?o:k)>+g[a+32>>2]){i=f;return}n=l>j?b+4|0:b+20|0;if(+g[(+g[n>>2]>k?n:b+36|0)>>2]<+g[a+16>>2]){i=f;return}h=c[a+48>>2]|0;m=c[a+4>>2]|0;if((c[(c[m+4>>2]|0)+4>>2]|0)>=20){i=f;return}c[f+32>>2]=0;g[f+36>>2]=1.0;g[f+40>>2]=1.0;g[f+44>>2]=1.0;g[f+48>>2]=0.0;c[f+76>>2]=0;c[f+24>>2]=16376;c[f+28>>2]=1;c[f+80>>2]=c[b+0>>2];c[f+84>>2]=c[b+4>>2];c[f+88>>2]=c[b+8>>2];c[f+92>>2]=c[b+12>>2];c[f+96>>2]=c[b+16>>2];c[f+100>>2]=c[b+20>>2];c[f+104>>2]=c[b+24>>2];c[f+108>>2]=c[b+28>>2];c[f+112>>2]=c[b+32>>2];c[f+116>>2]=c[b+36>>2];c[f+120>>2]=c[b+40>>2];c[f+124>>2]=c[b+44>>2];g[f+68>>2]=+g[a+56>>2];p=c[a+8>>2]|0;n=c[p+8>>2]|0;b=c[p+12>>2]|0;c[f>>2]=p;c[f+4>>2]=f+24;c[f+8>>2]=n;c[f+12>>2]=b;c[f+16>>2]=d;c[f+20>>2]=e;b=Tb[c[(c[h>>2]|0)+8>>2]&31](h,m,f,c[a+64>>2]|0)|0;m=c[a+44>>2]|0;n=c[m+8>>2]|0;if((c[n+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0)){c[m+8>>2]=f;p=c[a+44>>2]|0;rc[c[(c[p>>2]|0)+8>>2]&127](p,d,e)}else{n=c[m+12>>2]|0;c[m+12>>2]=f;p=c[a+44>>2]|0;rc[c[(c[p>>2]|0)+12>>2]&127](p,d,e)}Jb[c[(c[b>>2]|0)+8>>2]&31](b,c[a+4>>2]|0,f,c[a+52>>2]|0,c[a+44>>2]|0);d=c[a+44>>2]|0;if((c[(c[d+8>>2]|0)+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0))c[d+8>>2]=n;else c[d+12>>2]=n;Lb[c[c[b>>2]>>2]&511](b);Nb[c[(c[h>>2]|0)+60>>2]&127](h,b);c[f+24>>2]=15736;a=c[f+76>>2]|0;if(!a){i=f;return}Lb[c[c[a>>2]>>2]&511](a);a=c[f+76>>2]|0;if(!a){i=f;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=f;return}function fD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;j=i;i=i+64|0;l=(a[b+8>>0]|0)!=0;k=l?e:d;e=l?d:e;d=c[e+4>>2]|0;if(((c[d+4>>2]|0)+ -21|0)>>>0>=9){i=j;return}if((c[(c[k+4>>2]|0)+4>>2]|0)>=20){i=j;return}m=+$b[c[(c[d>>2]|0)+48>>2]&15](d);c[h+4>>2]=c[b+76>>2];c[b+16>>2]=k;c[b+20>>2]=e;c[b+64>>2]=f;g[b+68>>2]=m;c[b+56>>2]=h;l=c[e+12>>2]|0;B=+g[l>>2];A=+g[l+16>>2];z=+g[l+32>>2];y=+g[l+4>>2];x=+g[l+20>>2];w=+g[l+36>>2];s=+g[l+8>>2];q=+g[l+24>>2];o=+g[l+40>>2];v=-+g[l+48>>2];u=-+g[l+52>>2];t=-+g[l+56>>2];l=c[k+12>>2]|0;K=+g[l>>2];J=+g[l+16>>2];I=+g[l+32>>2];H=+g[l+4>>2];G=+g[l+20>>2];F=+g[l+36>>2];E=+g[l+8>>2];D=+g[l+24>>2];C=+g[l+40>>2];r=+g[l+48>>2];p=+g[l+52>>2];n=+g[l+56>>2];g[j>>2]=B*K+A*J+z*I;g[j+4>>2]=B*H+A*G+z*F;g[j+8>>2]=B*E+A*D+z*C;g[j+12>>2]=0.0;g[j+16>>2]=y*K+x*J+w*I;g[j+20>>2]=y*H+x*G+w*F;g[j+24>>2]=y*E+x*D+w*C;g[j+28>>2]=0.0;g[j+32>>2]=s*K+q*J+o*I;g[j+36>>2]=s*H+q*G+o*F;g[j+40>>2]=s*E+q*D+o*C;g[j+44>>2]=0.0;g[j+48>>2]=B*v+A*u+z*t+(B*r+A*p+z*n);g[j+52>>2]=y*v+x*u+w*t+(y*r+x*p+w*n);g[j+56>>2]=s*v+q*u+o*t+(s*r+q*p+o*n);g[j+60>>2]=0.0;l=c[(c[b+16>>2]|0)+4>>2]|0;vc[c[(c[l>>2]|0)+8>>2]&127](l,j,b+24|0,b+40|0);g[b+40>>2]=+g[b+40>>2]+m;g[b+44>>2]=+g[b+44>>2]+m;g[b+48>>2]=+g[b+48>>2]+m;g[b+24>>2]=+g[b+24>>2]-m;g[b+28>>2]=+g[b+28>>2]-m;g[b+32>>2]=+g[b+32>>2]-m;l=c[b+76>>2]|0;e=c[e+8>>2]|0;c[l+740>>2]=c[k+8>>2];c[l+744>>2]=e;vc[c[(c[d>>2]|0)+64>>2]&127](d,b+12|0,b+24|0,b+40|0);k=c[h+4>>2]|0;do if(c[k+748>>2]|0){f=c[k+740>>2]|0;e=c[(c[h+8>>2]|0)+8>>2]|0;if((f|0)==(e|0)){xA(k,f+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);break}else{xA(k,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,e+4|0);break}}while(0);c[b+16>>2]=0;c[b+20>>2]=0;i=j;return}function gD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0;h=i;i=i+240|0;f=(a[b+8>>0]|0)!=0;b=f?e:d;d=f?d:e;S=+g[b+116>>2]- +g[b+52>>2];T=+g[b+120>>2]- +g[b+56>>2];U=+g[b+124>>2]- +g[b+60>>2];V=+g[b+252>>2];if(S*S+T*T+U*U<V*V){V=1.0;i=h;return+V}n=+g[d+4>>2];p=+g[d+20>>2];r=+g[d+36>>2];z=+g[d+8>>2];A=+g[d+24>>2];B=+g[d+40>>2];j=+g[d+12>>2];C=+g[d+28>>2];E=+g[d+44>>2];R=-+g[d+52>>2];S=-+g[d+56>>2];T=-+g[d+60>>2];o=+g[b+4>>2];q=+g[b+20>>2];s=+g[b+36>>2];t=+g[b+8>>2];u=+g[b+24>>2];v=+g[b+40>>2];w=+g[b+12>>2];x=+g[b+28>>2];y=+g[b+44>>2];J=+g[b+52>>2];I=+g[b+56>>2];H=+g[b+60>>2];F=n*R+p*S+r*T+(n*J+p*I+r*H);G=z*R+A*S+B*T+(z*J+A*I+B*H);H=j*R+C*S+E*T+(j*J+C*I+E*H);I=+g[b+68>>2];J=+g[b+84>>2];K=+g[b+100>>2];L=+g[b+72>>2];M=+g[b+88>>2];N=+g[b+104>>2];O=+g[b+76>>2];P=+g[b+92>>2];m=+g[b+108>>2];U=+g[b+116>>2];V=+g[b+120>>2];D=+g[b+124>>2];l=n*R+p*S+r*T+(n*U+p*V+r*D);k=z*R+A*S+B*T+(z*U+A*V+B*D);D=j*R+C*S+E*T+(j*U+C*V+E*D);d=c[d+192>>2]|0;if(((c[d+4>>2]|0)+ -21|0)>>>0>=9){V=1.0;i=h;return+V}g[h+224>>2]=F;g[h+228>>2]=G;g[h+232>>2]=H;g[h+236>>2]=0.0;if(l<F){g[h+224>>2]=l;T=l}else T=F;if(k<G){g[h+228>>2]=k;U=k}else U=G;if(D<H){g[h+232>>2]=D;V=D}else V=H;g[h+208>>2]=F;g[h+212>>2]=G;g[h+216>>2]=H;g[h+220>>2]=0.0;if(F<l){g[h+208>>2]=l;Q=l}else Q=F;if(G<k){g[h+212>>2]=k;R=k}else R=G;if(H<D){g[h+216>>2]=D;S=D}else S=H;W=+g[b+248>>2];g[h+224>>2]=T-W;g[h+228>>2]=U-W;g[h+232>>2]=V-W;g[h+208>>2]=W+Q;g[h+212>>2]=W+R;g[h+216>>2]=W+S;c[h>>2]=18592;g[h+4>>2]=n*o+p*q+r*s;g[h+8>>2]=n*t+p*u+r*v;g[h+12>>2]=n*w+p*x+r*y;g[h+16>>2]=0.0;g[h+20>>2]=z*o+A*q+B*s;g[h+24>>2]=z*t+A*u+B*v;g[h+28>>2]=z*w+A*x+B*y;g[h+32>>2]=0.0;g[h+36>>2]=j*o+C*q+E*s;g[h+40>>2]=j*t+C*u+E*v;g[h+44>>2]=j*w+C*x+E*y;g[h+48>>2]=0.0;g[h+52>>2]=F;g[h+56>>2]=G;g[h+60>>2]=H;g[h+64>>2]=0.0;g[h+68>>2]=n*I+p*J+r*K;g[h+72>>2]=n*L+p*M+r*N;g[h+76>>2]=n*O+p*P+r*m;g[h+80>>2]=0.0;g[h+84>>2]=z*I+A*J+B*K;g[h+88>>2]=z*L+A*M+B*N;g[h+92>>2]=z*O+A*P+B*m;g[h+96>>2]=0.0;g[h+100>>2]=j*I+C*J+E*K;g[h+104>>2]=j*L+C*M+E*N;g[h+108>>2]=j*O+C*P+E*m;g[h+112>>2]=0.0;g[h+116>>2]=l;g[h+120>>2]=k;g[h+124>>2]=D;g[h+128>>2]=0.0;g[h+196>>2]=W;g[h+200>>2]=+g[b+244>>2];if(!d){W=1.0;i=h;return+W}vc[c[(c[d>>2]|0)+64>>2]&127](d,h,h+224|0,h+208|0);j=+g[h+200>>2];if(!(j<+g[b+244>>2])){W=1.0;i=h;return+W}g[b+244>>2]=j;W=j;i=h;return+W}function hD(a){a=a|0;return}function iD(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function jD(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0;e=i;i=i+784|0;g[e+712>>2]=1.0;c[e+716>>2]=0;c[e+720>>2]=0;c[e+724>>2]=0;c[e+728>>2]=0;g[e+732>>2]=1.0;c[e+736>>2]=0;c[e+740>>2]=0;c[e+744>>2]=0;c[e+748>>2]=0;g[e+752>>2]=1.0;f=e+756|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[e+536>>2]=9440;c[e+704>>2]=0;g[e+708>>2]=0.0;g[e+700>>2]=+g[b+200>>2];j=+g[b+196>>2];c[e+488>>2]=0;g[e+492>>2]=1.0;g[e+496>>2]=1.0;g[e+500>>2]=1.0;g[e+504>>2]=0.0;c[e+480>>2]=16680;c[e+484>>2]=8;g[e+508>>2]=j;g[e+524>>2]=j;c[e+384>>2]=0;g[e+388>>2]=1.0;g[e+392>>2]=1.0;g[e+396>>2]=1.0;g[e+400>>2]=0.0;g[e+420>>2]=.03999999910593033;c[e+428>>2]=0;c[e+376>>2]=16376;c[e+380>>2]=1;c[e+432>>2]=c[d+0>>2];c[e+436>>2]=c[d+4>>2];c[e+440>>2]=c[d+8>>2];c[e+444>>2]=c[d+12>>2];c[e+448>>2]=c[d+16>>2];c[e+452>>2]=c[d+20>>2];c[e+456>>2]=c[d+24>>2];c[e+460>>2]=c[d+28>>2];c[e+464>>2]=c[d+32>>2];c[e+468>>2]=c[d+36>>2];c[e+472>>2]=c[d+40>>2];c[e+476>>2]=c[d+44>>2];g[e+324>>2]=9999999747378752.0e-20;a[e+348>>0]=0;c[e>>2]=17152;c[e+4>>2]=e+16;c[e+8>>2]=e+480;c[e+12>>2]=e+376;if(RB(e,b+4|0,b+68|0,e+712|0,e+712|0,e+536|0)|0?(h=+g[e+700>>2],+g[b+200>>2]>h):0)g[b+200>>2]=h;c[e+376>>2]=15736;b=c[e+428>>2]|0;if(!b){i=e;return}Lb[c[c[b>>2]>>2]&511](b);b=c[e+428>>2]|0;if(!b){i=e;return}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=e;return}function kD(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function lD(a){a=a|0;return}function mD(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=18816;if((a[b+16>>0]|0)!=0?(e=c[b+20>>2]|0,(e|0)!=0):0){f=c[b+4>>2]|0;Nb[c[(c[f>>2]|0)+16>>2]&127](f,e)}gF(b);i=d;return}function nD(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=18816;if(!(a[b+16>>0]|0)){i=d;return}e=c[b+20>>2]|0;if(!e){i=d;return}b=c[b+4>>2]|0;Nb[c[(c[b>>2]|0)+16>>2]&127](b,e);i=d;return}function oD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0.0,L=0.0,M=0.0,N=0.0,O=0,R=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0,na=0,oa=0,pa=0.0,qa=0.0,ra=0.0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0;j=i;i=i+832|0;r=c[b+20>>2]|0;if(!r){r=c[b+4>>2]|0;r=Yb[c[(c[r>>2]|0)+12>>2]&31](r,c[d+8>>2]|0,c[e+8>>2]|0)|0;c[b+20>>2]=r;a[b+16>>0]=1}c[h+4>>2]=r;l=c[d+4>>2]|0;k=c[e+4>>2]|0;u=c[l+4>>2]|0;if((u|0)==10?(c[k+4>>2]|0)==10:0){m=+g[(c[b+20>>2]|0)+752>>2];za=c[l+52>>2]|0;B=+g[l+(za<<2)+28>>2];o=+g[l+(((za+2|0)%3|0)<<2)+28>>2];Aa=c[k+52>>2]|0;C=+g[k+(Aa<<2)+28>>2];p=+g[k+(((Aa+2|0)%3|0)<<2)+28>>2];Ba=c[d+12>>2]|0;b=c[e+12>>2]|0;v=+g[Ba+(za<<2)>>2];q=+g[Ba+(za<<2)+16>>2];w=+g[Ba+(za<<2)+32>>2];D=+g[b+(Aa<<2)>>2];E=+g[b+(Aa<<2)+16>>2];A=+g[b+(Aa<<2)+32>>2];z=+g[b+48>>2]- +g[Ba+48>>2];y=+g[b+52>>2]- +g[Ba+52>>2];x=+g[b+56>>2]- +g[Ba+56>>2];F=1.0-(v*D+q*E+w*A)*(v*D+q*E+w*A);if(!(F==0.0)){G=(v*z+q*y+w*x-(v*D+q*E+w*A)*(D*z+E*y+A*x))/F;if(!(G<-B)){if(G>B)G=B}else G=-B}else G=0.0;F=(v*D+q*E+w*A)*G-(D*z+E*y+A*x);if(F<-C){F=(v*D+q*E+w*A)*-C+(v*z+q*y+w*x);if(!(F<-B))if(F>B)C=-C;else{B=F;C=-C}else{B=-B;C=-C}}else if(F>C){F=C*(v*D+q*E+w*A)+(v*z+q*y+w*x);if(!(F<-B)){if(!(F>B))B=F}else B=-B}else{B=G;C=F}D=D*C;E=E*C;A=A*C;z=D+(z-v*B);y=E+(y-q*B);B=A+(x-w*B);x=+Q(+(B*B+(z*z+y*y)));if(!(x-o-p>m)){do if(B*B+(z*z+y*y)<=1.4210854715202004e-14)if(+P(+w)>.7071067690849304){ra=1.0/+Q(+(q*q+w*w));g[j+320>>2]=0.0;g[j+324>>2]=-(w*ra);g[j+328>>2]=q*ra;z=0.0;v=-(w*ra);q=q*ra;break}else{ra=1.0/+Q(+(v*v+q*q));g[j+320>>2]=-(q*ra);g[j+324>>2]=v*ra;g[j+328>>2]=0.0;z=-(q*ra);v=v*ra;q=0.0;break}else{g[j+320>>2]=z*-(1.0/x);g[j+324>>2]=y*-(1.0/x);g[j+328>>2]=B*-(1.0/x);g[j+332>>2]=0.0;z=z*-(1.0/x);v=y*-(1.0/x);q=B*-(1.0/x)}while(0);qa=p*v+(E+ +g[b+52>>2]);ra=p*q+(A+ +g[b+56>>2]);g[j+304>>2]=p*z+(D+ +g[b+48>>2]);g[j+308>>2]=qa;g[j+312>>2]=ra;g[j+316>>2]=0.0}if(x-o-p<m){qc[c[(c[h>>2]|0)+16>>2]&15](h,j+320|0,j+304|0,x-o-p);r=c[h+4>>2]|0}if(!(c[r+748>>2]|0)){i=j;return}d=c[r+740>>2]|0;b=c[(c[h+8>>2]|0)+8>>2]|0;if((d|0)==(b|0)){xA(r,d+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);i=j;return}else{xA(r,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,b+4|0);i=j;return}}else ta=k+4|0;g[j+296>>2]=999999984306749400.0;J=c[b+8>>2]|0;O=c[b+12>>2]|0;c[j+88>>2]=13392;g[j+92>>2]=0.0;g[j+96>>2]=1.0;g[j+100>>2]=0.0;g[j+104>>2]=0.0;c[j+108>>2]=O;c[j+112>>2]=J;c[j+116>>2]=l;c[j+120>>2]=k;c[j+124>>2]=u;c[j+128>>2]=c[ta>>2];g[j+132>>2]=+$b[c[(c[l>>2]|0)+48>>2]&15](l);g[j+136>>2]=+$b[c[(c[k>>2]|0)+48>>2]&15](k);a[j+140>>0]=0;c[j+148>>2]=-1;c[j+160>>2]=1;c[j+164>>2]=1;c[j+116>>2]=l;c[j+120>>2]=k;qa=+$b[c[(c[l>>2]|0)+48>>2]&15](l);ra=+$b[c[(c[k>>2]|0)+48>>2]&15](k);ra=qa+ra+ +g[(c[b+20>>2]|0)+752>>2];g[j+296>>2]=ra*ra;J=c[d+12>>2]|0;c[j+168>>2]=c[J+0>>2];c[j+172>>2]=c[J+4>>2];c[j+176>>2]=c[J+8>>2];c[j+180>>2]=c[J+12>>2];O=j+184|0;c[O+0>>2]=c[J+16>>2];c[O+4>>2]=c[J+20>>2];c[O+8>>2]=c[J+24>>2];c[O+12>>2]=c[J+28>>2];I=j+200|0;c[I+0>>2]=c[J+32>>2];c[I+4>>2]=c[J+36>>2];c[I+8>>2]=c[J+40>>2];c[I+12>>2]=c[J+44>>2];na=j+216|0;c[na+0>>2]=c[J+48>>2];c[na+4>>2]=c[J+52>>2];c[na+8>>2]=c[J+56>>2];c[na+12>>2]=c[J+60>>2];J=j+232|0;r=c[e+12>>2]|0;c[J+0>>2]=c[r+0>>2];c[J+4>>2]=c[r+4>>2];c[J+8>>2]=c[r+8>>2];c[J+12>>2]=c[r+12>>2];ba=j+248|0;c[ba+0>>2]=c[r+16>>2];c[ba+4>>2]=c[r+20>>2];c[ba+8>>2]=c[r+24>>2];c[ba+12>>2]=c[r+28>>2];ma=j+264|0;c[ma+0>>2]=c[r+32>>2];c[ma+4>>2]=c[r+36>>2];c[ma+8>>2]=c[r+40>>2];c[ma+12>>2]=c[r+44>>2];u=j+280|0;c[u+0>>2]=c[r+48>>2];c[u+4>>2]=c[r+52>>2];c[u+8>>2]=c[r+56>>2];c[u+12>>2]=c[r+60>>2];r=c[l+4>>2]|0;do if((r|0)<7?(s=c[ta>>2]|0,(s|0)<7):0){c[j+80>>2]=19224;if(!r)q=0.0;else{q=+$b[c[(c[l>>2]|0)+48>>2]&15](l);s=c[ta>>2]|0}if(!s)x=0.0;else x=+$b[c[(c[k>>2]|0)+48>>2]&15](k);c[j+40>>2]=19032;c[j+44>>2]=h;g[j+64>>2]=q;g[j+68>>2]=x;a[j+76>>0]=0;s=c[l+52>>2]|0;if(s){r=c[k+52>>2]|0;if(!r){if((c[ta>>2]|0)!=1)break;u=j+32|0;a[u>>0]=1;r=j+28|0;c[r>>2]=0;s=j+20|0;c[s>>2]=0;n=j+24|0;c[n>>2]=0;I=c[e+12>>2]|0;qa=+g[k+56>>2];ra=+g[k+60>>2];p=+g[k+64>>2];m=qa*+g[I>>2]+ra*+g[I+4>>2]+p*+g[I+8>>2]+ +g[I+48>>2];o=qa*+g[I+16>>2]+ra*+g[I+20>>2]+p*+g[I+24>>2]+ +g[I+52>>2];p=qa*+g[I+32>>2]+ra*+g[I+36>>2]+p*+g[I+40>>2]+ +g[I+56>>2];c[5004]=(c[5004]|0)+1;I=fF(35)|0;if(!I)I=0;else{c[(I+19&-16)+ -4>>2]=I;I=I+19&-16}J=c[r>>2]|0;if(J){if(a[u>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[J+ -4>>2]|0)}c[r>>2]=0}a[u>>0]=1;c[r>>2]=I;c[n>>2]=1;J=c[s>>2]|0;g[I+(J<<4)>>2]=m;g[I+(J<<4)+4>>2]=o;g[I+(J<<4)+8>>2]=p;g[I+(J<<4)+12>>2]=0.0;J=c[s>>2]|0;c[s>>2]=J+1;I=c[e+12>>2]|0;qa=+g[k+72>>2];ra=+g[k+76>>2];o=+g[k+80>>2];m=qa*+g[I>>2]+ra*+g[I+4>>2]+o*+g[I+8>>2]+ +g[I+48>>2];p=qa*+g[I+16>>2]+ra*+g[I+20>>2]+o*+g[I+24>>2]+ +g[I+52>>2];o=qa*+g[I+32>>2]+ra*+g[I+36>>2]+o*+g[I+40>>2]+ +g[I+56>>2];I=c[n>>2]|0;if((J+1|0)==(I|0)){I=(J+1|0)==0?1:J+1<<1;if((J+1|0)<(I|0)){if((I|0)!=0?(c[5004]=(c[5004]|0)+1,sa=fF((I<<4|3)+16|0)|0,(sa|0)!=0):0){c[(sa+19&-16)+ -4>>2]=sa;O=sa+19&-16}else O=0;if((J|0)>-1){ba=0;do{Ba=O+(ba<<4)|0;Aa=(c[r>>2]|0)+(ba<<4)|0;c[Ba+0>>2]=c[Aa+0>>2];c[Ba+4>>2]=c[Aa+4>>2];c[Ba+8>>2]=c[Aa+8>>2];c[Ba+12>>2]=c[Aa+12>>2];ba=ba+1|0}while((ba|0)!=(J+1|0))}J=c[r>>2]|0;if(J){if(a[u>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[J+ -4>>2]|0)}c[r>>2]=0}a[u>>0]=1;c[r>>2]=O;c[n>>2]=I;O=c[s>>2]|0}else{O=J+1|0;I=J+1|0}}else O=J+1|0;J=c[r>>2]|0;g[J+(O<<4)>>2]=m;g[J+(O<<4)+4>>2]=p;g[J+(O<<4)+8>>2]=o;g[J+(O<<4)+12>>2]=0.0;O=O+1|0;c[s>>2]=O;Ba=c[e+12>>2]|0;qa=+g[k+88>>2];ra=+g[k+92>>2];o=+g[k+96>>2];p=qa*+g[Ba>>2]+ra*+g[Ba+4>>2]+o*+g[Ba+8>>2]+ +g[Ba+48>>2];m=qa*+g[Ba+16>>2]+ra*+g[Ba+20>>2]+o*+g[Ba+24>>2]+ +g[Ba+52>>2];o=qa*+g[Ba+32>>2]+ra*+g[Ba+36>>2]+o*+g[Ba+40>>2]+ +g[Ba+56>>2];if((O|0)==(I|0)){e=(I|0)==0?1:I<<1;if((I|0)<(e|0)){if((e|0)!=0?(c[5004]=(c[5004]|0)+1,oa=fF((e<<4|3)+16|0)|0,(oa|0)!=0):0){c[(oa+19&-16)+ -4>>2]=oa;J=oa+19&-16}else J=0;if((I|0)>0){O=0;do{Ba=J+(O<<4)|0;Aa=(c[r>>2]|0)+(O<<4)|0;c[Ba+0>>2]=c[Aa+0>>2];c[Ba+4>>2]=c[Aa+4>>2];c[Ba+8>>2]=c[Aa+8>>2];c[Ba+12>>2]=c[Aa+12>>2];O=O+1|0}while((O|0)!=(I|0))}I=c[r>>2]|0;if(I){if(a[u>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[I+ -4>>2]|0)}c[r>>2]=0}a[u>>0]=1;c[r>>2]=J;c[n>>2]=e;I=c[s>>2]|0}}else I=O;g[J+(I<<4)>>2]=p;g[J+(I<<4)+4>>2]=m;g[J+(I<<4)+8>>2]=o;g[J+(I<<4)+12>>2]=0.0;c[s>>2]=(c[s>>2]|0)+1;m=+g[(c[b+20>>2]|0)+752>>2];Az(j+88|0,j+168|0,j+80|0,c[f+20>>2]|0,0);o=+g[j+92>>2];q=+g[j+96>>2];p=+g[j+100>>2];if(o*o+q*q+p*p>1.1920928955078125e-7){qa=1.0/(o*o+q*q+p*p);g[j>>2]=o*qa;g[j+4>>2]=q*qa;g[j+8>>2]=p*qa;g[j+12>>2]=0.0;qa=+g[j+144>>2];ra=+$b[c[(c[l>>2]|0)+48>>2]&15](l);ra=qa-ra- +$b[c[(c[k>>2]|0)+48>>2]&15](k);cE(j,c[l+52>>2]|0,c[d+12>>2]|0,j+16|0,ra-m,m,h)}do if((a[b+16>>0]|0)!=0?(t=c[h+4>>2]|0,(c[t+748>>2]|0)!=0):0){d=c[t+740>>2]|0;b=c[(c[h+8>>2]|0)+8>>2]|0;if((d|0)==(b|0)){xA(t,d+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);break}else{xA(t,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,b+4|0);break}}while(0);h=c[r>>2]|0;if(h){if(a[u>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[r>>2]=0}a[u>>0]=1;c[r>>2]=0;c[s>>2]=0;c[n>>2]=0;i=j;return}m=+g[(c[b+20>>2]|0)+752>>2];if(!(a[f+24>>0]|0)){Az(j+88|0,j+168|0,j+40|0,c[f+20>>2]|0,0);o=+g[j+72>>2];if((a[j+76>>0]|0)!=0&o<0.0){L=+g[j+48>>2];M=+g[j+52>>2];H=+g[j+56>>2];K=+g[j+60>>2];n=105}}else{f=c[d+12>>2]|0;t=c[e+12>>2]|0;c[4920]=(c[4920]|0)+1;ka=+g[s+64>>2];la=+g[s+68>>2];y=+g[f+4>>2];pa=+g[s+72>>2];z=+g[f+8>>2];A=+g[f+16>>2];B=+g[f+20>>2];D=+g[f+24>>2];C=+g[f+32>>2];E=+g[f+36>>2];F=+g[f+40>>2];qa=+g[r+64>>2];ra=+g[r+68>>2];o=+g[r+72>>2];q=ka*+g[f>>2]+la*y+pa*z+ +g[f+48>>2]-(qa*+g[t>>2]+ra*+g[t+4>>2]+o*+g[t+8>>2]+ +g[t+48>>2]);p=ka*A+la*B+pa*D+ +g[f+52>>2]-(qa*+g[t+16>>2]+ra*+g[t+20>>2]+o*+g[t+24>>2]+ +g[t+52>>2]);o=ka*C+la*E+pa*F+ +g[f+56>>2]-(qa*+g[t+32>>2]+ra*+g[t+36>>2]+o*+g[t+40>>2]+ +g[t+56>>2]);u=c[s+28>>2]|0;a:do if((u|0)>0){x=0.0;R=3.4028234663852886e+38;I=0;L=0.0;M=0.0;H=0.0;K=0.0;while(1){Ba=c[s+36>>2]|0;pa=+g[Ba+(I*36|0)+20>>2];qa=+g[Ba+(I*36|0)+24>>2];ra=+g[Ba+(I*36|0)+28>>2];y=pa*+g[f>>2]+qa*y+ra*z;z=pa*A+qa*B+ra*D;A=pa*C+qa*E+ra*F;g[j+400>>2]=y;g[j+404>>2]=z;g[j+408>>2]=A;g[j+412>>2]=0.0;if(q*y+p*z+o*A<0.0){g[j+400>>2]=y*-1.0;g[j+404>>2]=z*-1.0;g[j+408>>2]=A*-1.0;y=y*-1.0;z=z*-1.0;A=A*-1.0}c[4916]=(c[4916]|0)+1;if(bE(f,t,q,p,o,y,z,A,s,r,R)|0){c[4918]=(c[4918]|0)+1;ND(s,f,j+400|0,j+808|0,j+784|0,j+464|0,j+448|0);ND(r,t,j+400|0,j+720|0,j+480|0,j+432|0,j+416|0);z=+g[j+784>>2];y=+g[j+720>>2];if(!(z<y)?(w=+g[j+480>>2],v=+g[j+808>>2],!(w<v)):0){J=1;y=z-y<w-v?z-y:w-v}else{J=0;y=x}if(!J){r=0;break a}if(y<R){x=y;R=y;L=+g[j+400>>2];M=+g[j+404>>2];H=+g[j+408>>2];K=+g[j+412>>2]}else x=y}I=I+1|0;if((I|0)>=(u|0)){n=52;break a}y=+g[f+4>>2];z=+g[f+8>>2];A=+g[f+16>>2];B=+g[f+20>>2];D=+g[f+24>>2];C=+g[f+32>>2];E=+g[f+36>>2];F=+g[f+40>>2]}}else{R=3.4028234663852886e+38;L=0.0;M=0.0;H=0.0;K=0.0;n=52}while(0);b:do if((n|0)==52){u=c[r+28>>2]|0;if((u|0)>0){v=0.0;I=0;do{Ba=c[r+36>>2]|0;qa=+g[Ba+(I*36|0)+20>>2];ra=+g[Ba+(I*36|0)+24>>2];x=+g[Ba+(I*36|0)+28>>2];w=qa*+g[t>>2]+ra*+g[t+4>>2]+x*+g[t+8>>2];y=qa*+g[t+16>>2]+ra*+g[t+20>>2]+x*+g[t+24>>2];x=qa*+g[t+32>>2]+ra*+g[t+36>>2]+x*+g[t+40>>2];g[j+384>>2]=w;g[j+388>>2]=y;g[j+392>>2]=x;g[j+396>>2]=0.0;if(q*w+p*y+o*x<0.0){g[j+384>>2]=w*-1.0;g[j+388>>2]=y*-1.0;g[j+392>>2]=x*-1.0;w=w*-1.0;y=y*-1.0;x=x*-1.0}c[4916]=(c[4916]|0)+1;do if(bE(f,t,q,p,o,w,y,x,s,r,R)|0){c[4918]=(c[4918]|0)+1;ND(s,f,j+384|0,j+808|0,j+784|0,j+464|0,j+448|0);ND(r,t,j+384|0,j+720|0,j+480|0,j+432|0,j+416|0);y=+g[j+784>>2];x=+g[j+720>>2];do if(y<x){J=0;w=v}else{w=+g[j+480>>2];z=+g[j+808>>2];if(w<z){J=0;w=v;break}J=1;w=y-x<w-z?y-x:w-z}while(0);if(!J){r=0;break b}if(!(w<R)){v=w;break}v=w;R=w;L=+g[j+384>>2];M=+g[j+388>>2];H=+g[j+392>>2];K=+g[j+396>>2]}while(0);I=I+1|0}while((I|0)<(u|0))}J=c[s+48>>2]|0;if((J|0)>0){y=0.0;z=0.0;A=0.0;B=0.0;C=0.0;D=0.0;F=0.0;E=0.0;G=0.0;N=0.0;W=0.0;Y=0.0;Z=0.0;X=0.0;V=0.0;U=0.0;_=0.0;$=0.0;aa=0.0;ba=c[r+48>>2]|0;u=0;O=-1;I=-1;while(1){Ba=c[s+56>>2]|0;qa=+g[Ba+(u<<4)>>2];ra=+g[Ba+(u<<4)+4>>2];w=+g[Ba+(u<<4)+8>>2];x=qa*+g[f>>2]+ra*+g[f+4>>2]+w*+g[f+8>>2];v=qa*+g[f+16>>2]+ra*+g[f+20>>2]+w*+g[f+24>>2];w=qa*+g[f+32>>2]+ra*+g[f+36>>2]+w*+g[f+40>>2];if((ba|0)>0){J=0;do{Ba=c[r+56>>2]|0;qa=+g[Ba+(J<<4)>>2];ra=+g[Ba+(J<<4)+4>>2];ha=+g[Ba+(J<<4)+8>>2];ea=qa*+g[t>>2]+ra*+g[t+4>>2]+ha*+g[t+8>>2];ga=qa*+g[t+16>>2]+ra*+g[t+20>>2]+ha*+g[t+24>>2];ha=qa*+g[t+32>>2]+ra*+g[t+36>>2]+ha*+g[t+40>>2];g[j+368>>2]=v*ha-w*ga;g[j+372>>2]=w*ea-x*ha;g[j+376>>2]=x*ga-v*ea;g[j+380>>2]=0.0;do if(!(+P(+(v*ha-w*ga))>1.0e-6)){if(+P(+(w*ea-x*ha))>1.0e-6){n=70;break}if(+P(+(x*ga-v*ea))>1.0e-6)n=70}else n=70;while(0);do if((n|0)==70){n=0;ca=1.0/+Q(+((v*ha-w*ga)*(v*ha-w*ga)+(w*ea-x*ha)*(w*ea-x*ha)+(x*ga-v*ea)*(x*ga-v*ea)));da=(v*ha-w*ga)*ca;g[j+368>>2]=da;fa=(w*ea-x*ha)*ca;g[j+372>>2]=fa;ca=(x*ga-v*ea)*ca;g[j+376>>2]=ca;if(q*da+p*fa+o*ca<0.0){g[j+368>>2]=da*-1.0;g[j+372>>2]=fa*-1.0;g[j+376>>2]=ca*-1.0;da=da*-1.0;fa=fa*-1.0;ca=ca*-1.0}c[4916]=(c[4916]|0)+1;if(!(bE(f,t,q,p,o,da,fa,ca,s,r,R)|0))break;c[4918]=(c[4918]|0)+1;ND(s,f,j+368|0,j+808|0,j+784|0,j+464|0,j+448|0);ND(r,t,j+368|0,j+720|0,j+480|0,j+432|0,j+416|0);ka=+g[j+784>>2];qa=+g[j+720>>2];do if(!(ka<qa)){pa=+g[j+480>>2];ra=+g[j+808>>2];if(pa<ra){ba=0;la=Z;ja=Y;ia=W;fa=F;ca=D;da=C;ka=y;break}if(ka-qa<pa-ra){ba=1;la=+g[j+456>>2];ja=+g[j+452>>2];ia=+g[j+448>>2];fa=+g[j+440>>2];ca=+g[j+436>>2];da=+g[j+432>>2];ka=ka-qa;break}else{ba=1;la=+g[j+472>>2];ja=+g[j+468>>2];ia=+g[j+464>>2];fa=+g[j+424>>2];ca=+g[j+420>>2];da=+g[j+416>>2];ka=pa-ra;break}}else{ba=0;la=Z;ja=Y;ia=W;fa=F;ca=D;da=C;ka=y}while(0);if(!ba){r=0;break b}if(!(ka<R)){Z=la;Y=ja;W=ia;F=fa;D=ca;C=da;y=ka;break}aa=w;$=v;_=x;U=ha;V=ga;X=ea;Z=la;Y=ja;W=ia;N=la;G=ja;E=ia;F=fa;D=ca;C=da;B=fa;A=ca;z=da;y=ka;R=ka;O=u;I=J;L=+g[j+368>>2];M=+g[j+372>>2];H=+g[j+376>>2];K=+g[j+380>>2]}while(0);J=J+1|0;ba=c[r+48>>2]|0}while((J|0)<(ba|0));v=aa;w=$;x=_;J=c[s+48>>2]|0}else{v=aa;w=$;x=_}u=u+1|0;if((u|0)>=(J|0))break;else{_=x;$=w;aa=v}}}else{v=0.0;w=0.0;x=0.0;U=0.0;V=0.0;X=0.0;N=0.0;G=0.0;E=0.0;B=0.0;A=0.0;z=0.0;O=-1;I=-1}if((I|O|0)>-1){C=z-E;D=A-G;y=B-N;N=x*X+w*V+v*U;F=x*C+w*D+v*y;G=X*C+V*D+U*y;do if(!(1.0-N*N==0.0))if((F-N*G)/(1.0-N*N)<-1.0000000150474662e+30)E=-1.0000000150474662e+30;else{if(!((F-N*G)/(1.0-N*N)>1.0000000150474662e+30)){E=(F-N*G)/(1.0-N*N);break}E=1.0000000150474662e+30}else E=0.0;while(0);G=N*E-G;do if(G<-1.0000000150474662e+30){if(N*-1.0000000150474662e+30+F<-1.0000000150474662e+30){E=-1.0000000150474662e+30;N=-1.0000000150474662e+30;break}if(!(N*-1.0000000150474662e+30+F>1.0000000150474662e+30)){E=N*-1.0000000150474662e+30+F;N=-1.0000000150474662e+30;break}E=1.0000000150474662e+30;N=-1.0000000150474662e+30}else{if(!(G>1.0000000150474662e+30)){N=G;break}if(N*1.0000000150474662e+30+F<-1.0000000150474662e+30){E=-1.0000000150474662e+30;N=1.0000000150474662e+30;break}if(!(N*1.0000000150474662e+30+F>1.0000000150474662e+30)){E=N*1.0000000150474662e+30+F;N=1.0000000150474662e+30;break}E=1.0000000150474662e+30;N=1.0000000150474662e+30}while(0);F=X*N;G=N*V;N=N*U;x=C-x*E+F;w=D-E*w+G;y=y-E*v+N;g[j+352>>2]=x;g[j+356>>2]=w;g[j+360>>2]=y;g[j+364>>2]=0.0;if(x*x+w*w+y*y>1.1920928955078125e-7){v=+Q(+(x*x+w*w+y*y));g[j+352>>2]=x*(1.0/v);g[j+356>>2]=1.0/v*w;g[j+360>>2]=1.0/v*y;if(x*(1.0/v)*q+1.0/v*w*p+1.0/v*y*o<0.0){g[j+352>>2]=x*(1.0/v)*-1.0;g[j+356>>2]=1.0/v*w*-1.0;g[j+360>>2]=1.0/v*y*-1.0}g[j+336>>2]=z+F;g[j+340>>2]=A+G;g[j+344>>2]=B+N;g[j+348>>2]=0.0;qc[c[(c[h>>2]|0)+16>>2]&15](h,j+352|0,j+336|0,-v)}}if(q*L+p*M+o*H<0.0){r=1;L=-L;M=-M;H=-H;K=0.0}else r=1}while(0);if(r){o=-1.0000000150474662e+30;n=105}}if((n|0)==105){l=c[l+52>>2]|0;k=c[k+52>>2]|0;d=c[d+12>>2]|0;e=c[e+12>>2]|0;o=o-m;v=1.0/+Q(+(L*L+M*M+H*H));p=L*v;q=M*v;v=H*v;g[j+808>>2]=p;g[j+812>>2]=q;g[j+816>>2]=v;g[j+820>>2]=K;f=c[k+28>>2]|0;n=c[k+36>>2]|0;if((f|0)>0){w=+g[e>>2];x=+g[e+4>>2];A=+g[e+8>>2];D=+g[e+16>>2];E=+g[e+20>>2];H=+g[e+24>>2];G=+g[e+32>>2];C=+g[e+36>>2];B=+g[e+40>>2];t=-1;K=-3.4028234663852886e+38;r=0;while(1){y=+g[n+(r*36|0)+20>>2];z=+g[n+(r*36|0)+24>>2];F=+g[n+(r*36|0)+28>>2];s=(y*w+z*x+F*A)*p+(y*D+z*E+F*H)*q+(y*G+z*C+F*B)*v>K;t=s?r:t;r=r+1|0;if((r|0)>=(f|0)){s=t;break}else K=s?(y*w+z*x+F*A)*p+(y*D+z*E+F*H)*q+(y*G+z*C+F*B)*v:K}}else s=-1;a[j+800>>0]=1;r=j+796|0;c[r>>2]=0;c[j+788>>2]=0;c[j+792>>2]=0;f=c[n+(s*36|0)+4>>2]|0;c:do if((f|0)>0){n=n+(s*36|0)+12|0;O=0;J=0;u=0;t=0;while(1){Ba=c[(c[n>>2]|0)+(t<<2)>>2]|0;Aa=c[k+16>>2]|0;qa=+g[Aa+(Ba<<4)>>2];ra=+g[Aa+(Ba<<4)+4>>2];v=+g[Aa+(Ba<<4)+8>>2];p=qa*+g[e>>2]+ra*+g[e+4>>2]+v*+g[e+8>>2]+ +g[e+48>>2];q=qa*+g[e+16>>2]+ra*+g[e+20>>2]+v*+g[e+24>>2]+ +g[e+52>>2];v=qa*+g[e+32>>2]+ra*+g[e+36>>2]+v*+g[e+40>>2]+ +g[e+56>>2];if((O|0)==(u|0)){I=(u|0)==0?1:u<<1;if((u|0)<(I|0)){do if(!I)J=0;else{c[5004]=(c[5004]|0)+1;J=fF((I<<4|3)+16|0)|0;if(!J){J=0;break}c[(J+19&-16)+ -4>>2]=J;J=J+19&-16}while(0);if((u|0)>0){O=0;do{Ba=J+(O<<4)|0;Aa=(c[r>>2]|0)+(O<<4)|0;c[Ba+0>>2]=c[Aa+0>>2];c[Ba+4>>2]=c[Aa+4>>2];c[Ba+8>>2]=c[Aa+8>>2];c[Ba+12>>2]=c[Aa+12>>2];O=O+1|0}while((O|0)!=(u|0))}u=c[r>>2]|0;if(u){if(a[j+800>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[u+ -4>>2]|0)}c[r>>2]=0}a[j+800>>0]=1;c[r>>2]=J;c[j+792>>2]=I;I=J;u=c[j+788>>2]|0}else I=J}else{I=J;u=O}g[I+(u<<4)>>2]=p;g[I+(u<<4)+4>>2]=q;g[I+(u<<4)+8>>2]=v;g[I+(u<<4)+12>>2]=0.0;O=(c[j+788>>2]|0)+1|0;c[j+788>>2]=O;t=t+1|0;if((t|0)>=(f|0))break c;J=I;u=c[j+792>>2]|0}}else I=0;while(0);if((s|0)>-1){cE(j+808|0,l,d,j+784|0,o,m,h);I=c[r>>2]|0}if(I){if(a[j+800>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[I+ -4>>2]|0)}c[r>>2]=0}}if(!(a[b+16>>0]|0)){i=j;return}e=c[h+4>>2]|0;if(!(c[e+748>>2]|0)){i=j;return}d=c[e+740>>2]|0;b=c[(c[h+8>>2]|0)+8>>2]|0;if((d|0)==(b|0)){xA(e,d+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);i=j;return}else{xA(e,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,b+4|0);i=j;return}}}while(0);Az(j+88|0,j+168|0,h,c[f+20>>2]|0,0);if(((c[b+28>>2]|0)!=0?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+32>>2]|0):0)?(p=+g[j+92>>2],m=+g[j+96>>2],o=+g[j+100>>2],p*p+m*m+o*o>1.1920928955078125e-7):0){q=1.0/(p*p+m*m+o*o);if(+P(+(o*q))>.7071067690849304){z=1.0/+Q(+(o*q*o*q+m*q*m*q));x=0.0;y=-(o*q*z);z=m*q*z}else{y=1.0/+Q(+(p*q*p*q+m*q*m*q));x=-(m*q*y);y=p*q*y;z=0.0}v=+$b[c[(c[l>>2]|0)+16>>2]&15](l);w=+$b[c[(c[k>>2]|0)+16>>2]&15](k);A=.019999999552965164/(v<w?v:w);if(v<w){c[j+720>>2]=c[j+168>>2];c[j+724>>2]=c[j+172>>2];c[j+728>>2]=c[j+176>>2];c[j+732>>2]=c[j+180>>2];c[j+736>>2]=c[O+0>>2];c[j+740>>2]=c[O+4>>2];c[j+744>>2]=c[O+8>>2];c[j+748>>2]=c[O+12>>2];c[j+752>>2]=c[I+0>>2];c[j+756>>2]=c[I+4>>2];c[j+760>>2]=c[I+8>>2];c[j+764>>2]=c[I+12>>2];c[j+768>>2]=c[na+0>>2];c[j+772>>2]=c[na+4>>2];c[j+776>>2]=c[na+8>>2];c[j+780>>2]=c[na+12>>2]}else{c[j+720>>2]=c[J+0>>2];c[j+724>>2]=c[J+4>>2];c[j+728>>2]=c[J+8>>2];c[j+732>>2]=c[J+12>>2];c[j+736>>2]=c[ba+0>>2];c[j+740>>2]=c[ba+4>>2];c[j+744>>2]=c[ba+8>>2];c[j+748>>2]=c[ba+12>>2];c[j+752>>2]=c[ma+0>>2];c[j+756>>2]=c[ma+4>>2];c[j+760>>2]=c[ma+8>>2];c[j+764>>2]=c[ma+12>>2];c[j+768>>2]=c[u+0>>2];c[j+772>>2]=c[u+4>>2];c[j+776>>2]=c[u+8>>2];c[j+780>>2]=c[u+12>>2]}Aa=c[b+28>>2]|0;if((Aa|0)>0){B=z*z+(y*y+x*x);A=A>.39269909262657166?.19634954631328583:A*.5;ya=j+516|0;va=j+532|0;xa=j+548|0;oa=j+564|0;wa=j+580|0;k=j+596|0;n=j+612|0;r=j+628|0;t=j+644|0;ta=j+660|0;l=j+736|0;s=j+676|0;ua=j+752|0;sa=j+692|0;za=j+768|0;if(B>1.1920928955078125e-7){B=+T(+A)/+Q(+B);x=x*B;y=y*B;z=z*B;B=+S(+A);A=+Q(+(o*q*o*q+(p*q*p*q+m*q*m*q)));if(v<w){Ba=0;do{aa=+(Ba|0)*(6.2831854820251465/+(Aa|0))*.5;la=+T(+aa)/A;aa=+S(+aa);ha=z*-(m*q*la)+(x*aa+B*-(p*q*la))-y*-(o*q*la);qa=x*-(o*q*la)+(y*aa+B*-(m*q*la))-z*-(p*q*la);ia=y*-(p*q*la)+(z*aa+B*-(o*q*la))-x*-(m*q*la);$=B*aa-x*-(p*q*la)-y*-(m*q*la)-z*-(o*q*la);ka=o*q*la*qa+(p*q*la*$+aa*ha)-m*q*la*ia;pa=p*q*la*ia+(aa*qa+m*q*la*$)-o*q*la*ha;_=m*q*la*ha+(o*q*la*$+aa*ia)-p*q*la*qa;ia=aa*$-p*q*la*ha-m*q*la*qa-o*q*la*ia;la=ka*(2.0/(ia*ia+(_*_+(ka*ka+pa*pa))));qa=pa*(2.0/(ia*ia+(_*_+(ka*ka+pa*pa))));ha=_*(2.0/(ia*ia+(_*_+(ka*ka+pa*pa))));Ca=c[d+12>>2]|0;$=+g[Ca>>2];aa=+g[Ca+16>>2];ca=+g[Ca+32>>2];da=+g[Ca+4>>2];ea=+g[Ca+20>>2];fa=+g[Ca+36>>2];ga=+g[Ca+8>>2];ja=+g[Ca+24>>2];ra=+g[Ca+40>>2];g[j+168>>2]=(ka*ha+ia*qa)*ca+(aa*(ka*qa-ia*ha)+$*(1.0-(pa*qa+_*ha)));g[j+172>>2]=(1.0-(pa*qa+_*ha))*da+(ka*qa-ia*ha)*ea+(ka*ha+ia*qa)*fa;g[j+176>>2]=(1.0-(pa*qa+_*ha))*ga+(ka*qa-ia*ha)*ja+(ka*ha+ia*qa)*ra;g[j+180>>2]=0.0;g[j+184>>2]=(pa*ha-ia*la)*ca+($*(ka*qa+ia*ha)+aa*(1.0-(ka*la+_*ha)));g[j+188>>2]=(ka*qa+ia*ha)*da+(1.0-(ka*la+_*ha))*ea+(pa*ha-ia*la)*fa;g[j+192>>2]=(ka*qa+ia*ha)*ga+(1.0-(ka*la+_*ha))*ja+(pa*ha-ia*la)*ra;g[j+196>>2]=0.0;g[j+200>>2]=$*(ka*ha-ia*qa)+aa*(pa*ha+ia*la)+ca*(1.0-(ka*la+pa*qa));g[j+204>>2]=(ka*ha-ia*qa)*da+(pa*ha+ia*la)*ea+(1.0-(ka*la+pa*qa))*fa;g[j+208>>2]=(ka*ha-ia*qa)*ga+(pa*ha+ia*la)*ja+(1.0-(ka*la+pa*qa))*ra;g[j+212>>2]=0.0;Ca=c[e+12>>2]|0;c[J+0>>2]=c[Ca+0>>2];c[J+4>>2]=c[Ca+4>>2];c[J+8>>2]=c[Ca+8>>2];c[J+12>>2]=c[Ca+12>>2];c[ba+0>>2]=c[Ca+16>>2];c[ba+4>>2]=c[Ca+20>>2];c[ba+8>>2]=c[Ca+24>>2];c[ba+12>>2]=c[Ca+28>>2];c[ma+0>>2]=c[Ca+32>>2];c[ma+4>>2]=c[Ca+36>>2];c[ma+8>>2]=c[Ca+40>>2];c[ma+12>>2]=c[Ca+44>>2];c[u+0>>2]=c[Ca+48>>2];c[u+4>>2]=c[Ca+52>>2];c[u+8>>2]=c[Ca+56>>2];c[u+12>>2]=c[Ca+60>>2];Ca=c[f+20>>2]|0;c[j+480>>2]=18952;c[j+512>>2]=h;c[ya+0>>2]=c[j+168>>2];c[ya+4>>2]=c[j+172>>2];c[ya+8>>2]=c[j+176>>2];c[ya+12>>2]=c[j+180>>2];c[va+0>>2]=c[O+0>>2];c[va+4>>2]=c[O+4>>2];c[va+8>>2]=c[O+8>>2];c[va+12>>2]=c[O+12>>2];c[xa+0>>2]=c[I+0>>2];c[xa+4>>2]=c[I+4>>2];c[xa+8>>2]=c[I+8>>2];c[xa+12>>2]=c[I+12>>2];c[oa+0>>2]=c[na+0>>2];c[oa+4>>2]=c[na+4>>2];c[oa+8>>2]=c[na+8>>2];c[oa+12>>2]=c[na+12>>2];c[wa+0>>2]=c[J+0>>2];c[wa+4>>2]=c[J+4>>2];c[wa+8>>2]=c[J+8>>2];c[wa+12>>2]=c[J+12>>2];c[k+0>>2]=c[ba+0>>2];c[k+4>>2]=c[ba+4>>2];c[k+8>>2]=c[ba+8>>2];c[k+12>>2]=c[ba+12>>2];c[n+0>>2]=c[ma+0>>2];c[n+4>>2]=c[ma+4>>2];c[n+8>>2]=c[ma+8>>2];c[n+12>>2]=c[ma+12>>2];c[r+0>>2]=c[u+0>>2];c[r+4>>2]=c[u+4>>2];c[r+8>>2]=c[u+8>>2];c[r+12>>2]=c[u+12>>2];c[t+0>>2]=c[j+720>>2];c[t+4>>2]=c[j+724>>2];c[t+8>>2]=c[j+728>>2];c[t+12>>2]=c[j+732>>2];c[ta+0>>2]=c[l+0>>2];c[ta+4>>2]=c[l+4>>2];c[ta+8>>2]=c[l+8>>2];c[ta+12>>2]=c[l+12>>2];c[s+0>>2]=c[ua+0>>2];c[s+4>>2]=c[ua+4>>2];c[s+8>>2]=c[ua+8>>2];c[s+12>>2]=c[ua+12>>2];c[sa+0>>2]=c[za+0>>2];c[sa+4>>2]=c[za+4>>2];c[sa+8>>2]=c[za+8>>2];c[sa+12>>2]=c[za+12>>2];a[j+708>>0]=v<w&1;c[j+712>>2]=Ca;Az(j+88|0,j+168|0,j+480|0,Ca,0);Aa=c[b+28>>2]|0;Ba=Ba+1|0}while((Ba|0)<(Aa|0))}else{Ba=0;do{aa=+(Ba|0)*(6.2831854820251465/+(Aa|0))*.5;la=+T(+aa)/A;aa=+S(+aa);Ca=c[d+12>>2]|0;c[j+168>>2]=c[Ca+0>>2];c[j+172>>2]=c[Ca+4>>2];c[j+176>>2]=c[Ca+8>>2];c[j+180>>2]=c[Ca+12>>2];c[O+0>>2]=c[Ca+16>>2];c[O+4>>2]=c[Ca+20>>2];c[O+8>>2]=c[Ca+24>>2];c[O+12>>2]=c[Ca+28>>2];c[I+0>>2]=c[Ca+32>>2];c[I+4>>2]=c[Ca+36>>2];c[I+8>>2]=c[Ca+40>>2];c[I+12>>2]=c[Ca+44>>2];c[na+0>>2]=c[Ca+48>>2];c[na+4>>2]=c[Ca+52>>2];c[na+8>>2]=c[Ca+56>>2];c[na+12>>2]=c[Ca+60>>2];ha=z*-(m*q*la)+(x*aa+B*-(p*q*la))-y*-(o*q*la);qa=x*-(o*q*la)+(y*aa+B*-(m*q*la))-z*-(p*q*la);ia=y*-(p*q*la)+(z*aa+B*-(o*q*la))-x*-(m*q*la);$=B*aa-x*-(p*q*la)-y*-(m*q*la)-z*-(o*q*la);ka=o*q*la*qa+(p*q*la*$+aa*ha)-m*q*la*ia;pa=p*q*la*ia+(aa*qa+m*q*la*$)-o*q*la*ha;_=m*q*la*ha+(o*q*la*$+aa*ia)-p*q*la*qa;ia=aa*$-p*q*la*ha-m*q*la*qa-o*q*la*ia;la=ka*(2.0/(ia*ia+(_*_+(ka*ka+pa*pa))));qa=pa*(2.0/(ia*ia+(_*_+(ka*ka+pa*pa))));ha=_*(2.0/(ia*ia+(_*_+(ka*ka+pa*pa))));Ca=c[e+12>>2]|0;$=+g[Ca>>2];aa=+g[Ca+16>>2];ca=+g[Ca+32>>2];da=+g[Ca+4>>2];ea=+g[Ca+20>>2];fa=+g[Ca+36>>2];ga=+g[Ca+8>>2];ja=+g[Ca+24>>2];ra=+g[Ca+40>>2];g[j+232>>2]=(ka*ha+ia*qa)*ca+(aa*(ka*qa-ia*ha)+$*(1.0-(pa*qa+_*ha)));g[j+236>>2]=(1.0-(pa*qa+_*ha))*da+(ka*qa-ia*ha)*ea+(ka*ha+ia*qa)*fa;g[j+240>>2]=(1.0-(pa*qa+_*ha))*ga+(ka*qa-ia*ha)*ja+(ka*ha+ia*qa)*ra;g[j+244>>2]=0.0;g[j+248>>2]=(pa*ha-ia*la)*ca+($*(ka*qa+ia*ha)+aa*(1.0-(ka*la+_*ha)));g[j+252>>2]=(ka*qa+ia*ha)*da+(1.0-(ka*la+_*ha))*ea+(pa*ha-ia*la)*fa;g[j+256>>2]=(ka*qa+ia*ha)*ga+(1.0-(ka*la+_*ha))*ja+(pa*ha-ia*la)*ra;g[j+260>>2]=0.0;g[j+264>>2]=$*(ka*ha-ia*qa)+aa*(pa*ha+ia*la)+ca*(1.0-(ka*la+pa*qa));g[j+268>>2]=(ka*ha-ia*qa)*da+(pa*ha+ia*la)*ea+(1.0-(ka*la+pa*qa))*fa;g[j+272>>2]=(ka*ha-ia*qa)*ga+(pa*ha+ia*la)*ja+(1.0-(ka*la+pa*qa))*ra;g[j+276>>2]=0.0;Ca=c[f+20>>2]|0;c[j+480>>2]=18952;c[j+512>>2]=h;c[ya+0>>2]=c[j+168>>2];c[ya+4>>2]=c[j+172>>2];c[ya+8>>2]=c[j+176>>2];c[ya+12>>2]=c[j+180>>2];c[va+0>>2]=c[O+0>>2];c[va+4>>2]=c[O+4>>2];c[va+8>>2]=c[O+8>>2];c[va+12>>2]=c[O+12>>2];c[xa+0>>2]=c[I+0>>2];c[xa+4>>2]=c[I+4>>2];c[xa+8>>2]=c[I+8>>2];c[xa+12>>2]=c[I+12>>2];c[oa+0>>2]=c[na+0>>2];c[oa+4>>2]=c[na+4>>2];c[oa+8>>2]=c[na+8>>2];c[oa+12>>2]=c[na+12>>2];c[wa+0>>2]=c[J+0>>2];c[wa+4>>2]=c[J+4>>2];c[wa+8>>2]=c[J+8>>2];c[wa+12>>2]=c[J+12>>2];c[k+0>>2]=c[ba+0>>2];c[k+4>>2]=c[ba+4>>2];c[k+8>>2]=c[ba+8>>2];c[k+12>>2]=c[ba+12>>2];c[n+0>>2]=c[ma+0>>2];c[n+4>>2]=c[ma+4>>2];c[n+8>>2]=c[ma+8>>2];c[n+12>>2]=c[ma+12>>2];c[r+0>>2]=c[u+0>>2];c[r+4>>2]=c[u+4>>2];c[r+8>>2]=c[u+8>>2];c[r+12>>2]=c[u+12>>2];c[t+0>>2]=c[j+720>>2];c[t+4>>2]=c[j+724>>2];c[t+8>>2]=c[j+728>>2];c[t+12>>2]=c[j+732>>2];c[ta+0>>2]=c[l+0>>2];c[ta+4>>2]=c[l+4>>2];c[ta+8>>2]=c[l+8>>2];c[ta+12>>2]=c[l+12>>2];c[s+0>>2]=c[ua+0>>2];c[s+4>>2]=c[ua+4>>2];c[s+8>>2]=c[ua+8>>2];c[s+12>>2]=c[ua+12>>2];c[sa+0>>2]=c[za+0>>2];c[sa+4>>2]=c[za+4>>2];c[sa+8>>2]=c[za+8>>2];c[sa+12>>2]=c[za+12>>2];a[j+708>>0]=v<w&1;c[j+712>>2]=Ca;Az(j+88|0,j+168|0,j+480|0,Ca,0);Aa=c[b+28>>2]|0;Ba=Ba+1|0}while((Ba|0)<(Aa|0))}}else if(v<w){d=0;do d=d+1|0;while((d|0)<(Aa|0))}else{d=0;do d=d+1|0;while((d|0)<(Aa|0))}}}if(!(a[b+16>>0]|0)){i=j;return}b=c[h+4>>2]|0;if(!(c[b+748>>2]|0)){i=j;return}d=c[b+740>>2]|0;e=c[(c[h+8>>2]|0)+8>>2]|0;if((d|0)==(e|0)){xA(b,d+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);i=j;return}else{xA(b,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,e+4|0);i=j;return}}function pD(a){a=a|0;return}function qD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;f=i;i=i+624|0;p=+g[d+116>>2]- +g[d+52>>2];o=+g[d+120>>2]- +g[d+56>>2];n=+g[d+124>>2]- +g[d+60>>2];l=+g[e+116>>2]- +g[e+52>>2];k=+g[e+120>>2]- +g[e+56>>2];j=+g[e+124>>2]- +g[e+60>>2];m=+g[d+252>>2];if(p*p+o*o+n*n<m*m?(p=+g[e+252>>2],l*l+k*k+j*j<p*p):0){p=1.0;i=f;return+p}b=c[d+192>>2]|0;p=+g[e+248>>2];c[f+576>>2]=0;g[f+580>>2]=1.0;g[f+584>>2]=1.0;g[f+588>>2]=1.0;g[f+592>>2]=0.0;c[f+568>>2]=16680;c[f+572>>2]=8;g[f+596>>2]=p;g[f+612>>2]=p;c[f+392>>2]=9440;g[f+556>>2]=999999984306749400.0;c[f+560>>2]=0;g[f+564>>2]=0.0;g[f+340>>2]=9999999747378752.0e-20;a[f+364>>0]=0;c[f+16>>2]=13184;c[f+20>>2]=f+32;c[f+24>>2]=b;c[f+28>>2]=f+568;if(wz(f+16|0,d+4|0,d+68|0,e+4|0,e+68|0,f+392|0)|0){k=+g[f+556>>2];if(+g[d+244>>2]>k)g[d+244>>2]=k;if(+g[e+244>>2]>k)g[e+244>>2]=k;if(!(k<1.0))k=1.0}else k=1.0;b=c[e+192>>2]|0;p=+g[d+248>>2];c[f+576>>2]=0;g[f+580>>2]=1.0;g[f+584>>2]=1.0;g[f+588>>2]=1.0;g[f+592>>2]=0.0;c[f+568>>2]=16680;c[f+572>>2]=8;g[f+596>>2]=p;g[f+612>>2]=p;c[f+392>>2]=9440;g[f+556>>2]=999999984306749400.0;c[f+560>>2]=0;g[f+564>>2]=0.0;g[f+340>>2]=9999999747378752.0e-20;a[f+364>>0]=a[f+364>>0]&-16;c[f>>2]=13184;c[f+4>>2]=f+32;c[f+8>>2]=f+568;c[f+12>>2]=b;if(!(wz(f,d+4|0,d+68|0,e+4|0,e+68|0,f+392|0)|0)){p=k;i=f;return+p}j=+g[f+556>>2];if(+g[d+244>>2]>j)g[d+244>>2]=j;if(+g[e+244>>2]>j)g[e+244>>2]=j;if(!(k>j)){p=k;i=f;return+p}p=j;i=f;return+p}function rD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;if(!(c[b+20>>2]|0)){i=e;return}if(!(a[b+16>>0]|0)){i=e;return}h=c[d+4>>2]|0;if((h|0)==(c[d+8>>2]|0)?(f=(h|0)==0?1:h<<1,(h|0)<(f|0)):0){if(!f)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[d+4>>2]|0}if((h|0)>0){j=0;do{k=g+(j<<2)|0;if(k)c[k>>2]=c[(c[d+12>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+12>>2]|0;if(j){if(a[d+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=g;c[d+8>>2]=f}f=(c[d+12>>2]|0)+(h<<2)|0;if(f)c[f>>2]=c[b+20>>2];c[d+4>>2]=h+1;i=e;return}function sD(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;e=i;f=c[d>>2]|0;f=gc[c[(c[f>>2]|0)+56>>2]&31](f,36)|0;if(!f){f=0;i=e;return f|0}h=c[d+4>>2]|0;k=c[b+12>>2]|0;j=c[b+8>>2]|0;g=c[b+16>>2]|0;b=c[b+20>>2]|0;c[f+4>>2]=c[d>>2];c[f>>2]=18816;c[f+8>>2]=k;c[f+12>>2]=j;a[f+16>>0]=0;c[f+20>>2]=h;a[f+24>>0]=0;c[f+28>>2]=g;c[f+32>>2]=b;i=e;return f|0}function tD(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function uD(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;l=i;i=i+16|0;n=+g[d>>2];h=+g[d+4>>2];j=+g[d+8>>2];m=+g[e>>2];k=+g[e+4>>2];o=+g[e+8>>2];if(!(a[b+228>>0]|0)){z=+g[b+100>>2];w=+g[b+116>>2];C=+g[b+132>>2];y=+g[b+104>>2];u=+g[b+120>>2];B=+g[b+136>>2];x=+g[b+108>>2];s=+g[b+124>>2];A=+g[b+140>>2];F=-+g[b+148>>2];E=-+g[b+152>>2];D=-+g[b+156>>2];I=+g[b+164>>2];r=+g[b+168>>2];J=+g[b+172>>2];H=+g[b+180>>2];G=+g[b+184>>2];q=+g[b+188>>2];v=+g[b+196>>2];t=+g[b+200>>2];p=+g[b+204>>2];r=o*(C*I+B*r+A*J)+(m*(z*I+y*r+x*J)+k*(w*I+u*r+s*J))+((x*F+s*E+A*D)*J+(I*(z*F+w*E+C*D)+r*(y*F+u*E+B*D))+ +g[b+212>>2]);q=o*(C*H+B*G+A*q)+(m*(z*H+y*G+x*q)+k*(w*H+u*G+s*q))+((z*F+w*E+C*D)*H+(y*F+u*E+B*D)*G+(x*F+s*E+A*D)*q+ +g[b+216>>2]);p=(z*F+w*E+C*D)*v+(y*F+u*E+B*D)*t+(x*F+s*E+A*D)*p+ +g[b+220>>2]+(o*(C*v+B*t+A*p)+(m*(z*v+y*t+x*p)+k*(w*v+u*t+s*p)));g[l>>2]=r;g[l+4>>2]=q;g[l+8>>2]=p;g[l+12>>2]=0.0;o=(n*f+m-r)*+g[d>>2]+(h*f+k-q)*+g[d+4>>2]+(j*f+o-p)*+g[d+8>>2];e=b+32|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;qc[b&15](e,d,l,o);i=l;return}else{z=+g[b+36>>2];C=+g[b+52>>2];w=+g[b+68>>2];A=+g[b+40>>2];E=+g[b+56>>2];x=+g[b+72>>2];B=+g[b+44>>2];G=+g[b+60>>2];y=+g[b+76>>2];t=-+g[b+84>>2];u=-+g[b+88>>2];v=-+g[b+92>>2];q=+g[b+164>>2];H=+g[b+168>>2];p=+g[b+172>>2];r=+g[b+180>>2];s=+g[b+184>>2];I=+g[b+188>>2];D=+g[b+196>>2];F=+g[b+200>>2];J=+g[b+204>>2];H=(j*f+o)*(w*q+x*H+y*p)+((n*f+m)*(z*q+A*H+B*p)+(h*f+k)*(C*q+E*H+G*p))+((B*t+G*u+y*v)*p+(q*(z*t+C*u+w*v)+H*(A*t+E*u+x*v))+ +g[b+212>>2]);I=(j*f+o)*(w*r+x*s+y*I)+((n*f+m)*(z*r+A*s+B*I)+(h*f+k)*(C*r+E*s+G*I))+((z*t+C*u+w*v)*r+(A*t+E*u+x*v)*s+(B*t+G*u+y*v)*I+ +g[b+216>>2]);J=(z*t+C*u+w*v)*D+(A*t+E*u+x*v)*F+(B*t+G*u+y*v)*J+ +g[b+220>>2]+((j*f+o)*(w*D+x*F+y*J)+((n*f+m)*(z*D+A*F+B*J)+(h*f+k)*(C*D+E*F+G*J)));g[l>>2]=H+n*(n*(H-m)+h*(I-k)+j*(J-o));g[l+4>>2]=I+h*(n*(H-m)+h*(I-k)+j*(J-o));g[l+8>>2]=J+j*(n*(H-m)+h*(I-k)+j*(J-o));g[l+12>>2]=0.0;J=n*(H-m)+h*(I-k)+j*(J-o);e=b+32|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;qc[b&15](e,d,l,J);i=l;return}}function vD(a){a=a|0;return}function wD(a){a=a|0;return}function xD(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function yD(a,b,c){a=a|0;b=b|0;c=c|0;return}function zD(a,b,c){a=a|0;b=b|0;c=c|0;return}function AD(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+16|0;g[b+32>>2]=f;c[b+8>>2]=c[d+0>>2];c[b+12>>2]=c[d+4>>2];c[b+16>>2]=c[d+8>>2];c[b+20>>2]=c[d+12>>2];j=+g[b+28>>2];l=+g[e+4>>2]-j*+g[d+4>>2];k=+g[e+8>>2]-j*+g[d+8>>2];g[h>>2]=+g[e>>2]- +g[d>>2]*j;g[h+4>>2]=l;g[h+8>>2]=k;g[h+12>>2]=0.0;f=+g[b+24>>2]+j+f;g[b+32>>2]=f;if(!(f<0.0)){e=b+4|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;qc[b&15](e,d,h,f);i=h;return}a[b+36>>0]=1;e=b+4|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;qc[b&15](e,d,h,f);i=h;return}function BD(a){a=a|0;var b=0;b=i;gF(a);i=b;return}function CD(a,b,c){a=a|0;b=b|0;c=c|0;return}function DD(a,b,c){a=a|0;b=b|0;c=c|0;return}function ED(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function FD(b){b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=19408;if((a[b+8>>0]|0)!=0?(e=c[b+12>>2]|0,(e|0)!=0):0){f=c[b+4>>2]|0;Nb[c[(c[f>>2]|0)+16>>2]&127](f,e)}gF(b);i=d;return}function GD(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=19408;if(!(a[b+8>>0]|0)){i=d;return}e=c[b+12>>2]|0;if(!e){i=d;return}b=c[b+4>>2]|0;Nb[c[(c[b>>2]|0)+16>>2]&127](b,e);i=d;return}function HD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0.0,M=0.0,N=0.0,O=0.0,R=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0;f=i;i=i+128|0;if(!(c[b+12>>2]|0)){i=f;return}C=(a[b+16>>0]|0)!=0;K=C?e:d;C=C?d:e;o=c[K+4>>2]|0;j=c[C+4>>2]|0;K=c[K+12>>2]|0;q=+g[K>>2];D=+g[K+16>>2];z=+g[K+32>>2];t=+g[K+4>>2];s=+g[K+20>>2];r=+g[K+36>>2];p=+g[K+8>>2];n=+g[K+24>>2];y=+g[K+40>>2];F=+g[K+48>>2];G=+g[K+52>>2];H=+g[K+56>>2];K=c[C+12>>2]|0;O=+g[K>>2];N=+g[K+16>>2];k=+g[K+32>>2];M=+g[K+4>>2];L=+g[K+20>>2];x=+g[K+36>>2];m=+g[K+8>>2];B=+g[K+24>>2];v=+g[K+40>>2];I=-+g[K+48>>2];E=-+g[K+52>>2];u=-+g[K+56>>2];K=c[(c[o>>2]|0)+64>>2]|0;A=-+g[j+48>>2];l=-+g[j+52>>2];w=-+g[j+56>>2];g[f+32>>2]=(q*O+D*N+z*k)*A+(q*M+D*L+z*x)*l+(q*m+D*B+z*v)*w;g[f+36>>2]=(t*O+s*N+r*k)*A+(t*M+s*L+r*x)*l+(t*m+s*B+r*v)*w;g[f+40>>2]=(p*O+n*N+y*k)*A+(p*M+n*L+y*x)*l+(p*m+n*B+y*v)*w;g[f+44>>2]=0.0;rc[K&127](f+48|0,o,f+32|0);w=+g[f+48>>2];l=+g[f+52>>2];A=+g[f+56>>2];k=F*O+G*N+H*k+(O*I+N*E+k*u)+((q*O+D*N+z*k)*w+(t*O+s*N+r*k)*l+(p*O+n*N+y*k)*A);x=F*M+G*L+H*x+(M*I+L*E+x*u)+((q*M+D*L+z*x)*w+(t*M+s*L+r*x)*l+(p*M+n*L+y*x)*A);A=F*m+G*B+H*v+(m*I+B*E+v*u)+((q*m+D*B+z*v)*w+(t*m+s*B+r*v)*l+(p*m+n*B+y*v)*A);v=+g[j+48>>2];y=+g[j+52>>2];B=+g[j+56>>2];n=B*A+(v*k+y*x)- +g[j+64>>2];K=c[C+12>>2]|0;m=+g[K>>2];p=+g[K+4>>2];l=+g[K+8>>2];r=+g[K+16>>2];s=+g[K+20>>2];t=+g[K+24>>2];w=+g[K+32>>2];z=+g[K+36>>2];D=+g[K+40>>2];q=+g[K+48>>2];u=+g[K+52>>2];E=+g[K+56>>2];K=c[b+12>>2]|0;J=n<+g[K+752>>2];c[h+4>>2]=K;if(J){K=c[C+12>>2]|0;N=v*+g[K+16>>2]+y*+g[K+20>>2]+B*+g[K+24>>2];O=v*+g[K+32>>2]+y*+g[K+36>>2]+B*+g[K+40>>2];g[f+16>>2]=+g[K>>2]*v+ +g[K+4>>2]*y+ +g[K+8>>2]*B;g[f+20>>2]=N;g[f+24>>2]=O;g[f+28>>2]=0.0;g[f>>2]=l*(A-B*n)+(m*(k-v*n)+p*(x-y*n))+q;g[f+4>>2]=(k-v*n)*r+(x-y*n)*s+(A-B*n)*t+u;g[f+8>>2]=(k-v*n)*w+(x-y*n)*z+(A-B*n)*D+E;g[f+12>>2]=0.0;qc[c[(c[h>>2]|0)+16>>2]&15](h,f+16|0,f,n)}if((c[o+4>>2]|0)<7?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+24>>2]|0):0){l=+g[j+56>>2];if(+P(+l)>.7071067690849304){O=+g[j+52>>2];m=1.0/+Q(+(l*l+O*O));k=0.0;l=-(l*m);m=O*m}else{m=+g[j+48>>2];k=+g[j+52>>2];l=1.0/+Q(+(m*m+k*k));k=-(k*l);l=m*l;m=0.0}O=.019999999552965164/+$b[c[(c[o>>2]|0)+16>>2]&15](o);n=+Q(+(m*m+(l*l+k*k)));O=O>.39269909262657166?.19634954631328583:O*.5;n=+T(+O)/n;k=k*n;l=l*n;n=m*n;m=+S(+O);C=c[b+20>>2]|0;if((C|0)>0){o=0;do{q=+g[j+48>>2];O=+g[j+52>>2];p=+g[j+56>>2];x=+(o|0)*(6.2831854820251465/+(C|0))*.5;N=+T(+x)/+Q(+(q*q+O*O+p*p));x=+S(+x);z=n*-(O*N)+(k*x+m*-(q*N))-l*-(p*N);s=k*-(p*N)+(l*x+m*-(O*N))-n*-(q*N);fa=l*-(q*N)+(n*x+m*-(p*N))-k*-(O*N);A=m*x-k*-(q*N)-l*-(O*N)-n*-(p*N);E=p*N*s+(q*N*A+x*z)-O*N*fa;D=q*N*fa+(x*s+O*N*A)-p*N*z;ba=O*N*z+(p*N*A+x*fa)-q*N*s;fa=x*A-q*N*z-O*N*s-p*N*fa;C=(a[b+16>>0]|0)!=0;$=C?e:d;C=C?d:e;K=c[$+4>>2]|0;J=c[C+4>>2]|0;$=c[$+12>>2]|0;N=+g[$>>2];p=+g[$+4>>2];s=+g[$+8>>2];O=+g[$+16>>2];z=+g[$+20>>2];q=+g[$+24>>2];A=+g[$+32>>2];x=+g[$+36>>2];H=+g[$+40>>2];W=+g[$+48>>2];V=+g[$+52>>2];U=+g[$+56>>2];$=c[C+12>>2]|0;_=+g[$>>2];Z=+g[$+16>>2];u=+g[$+32>>2];Y=+g[$+4>>2];X=+g[$+20>>2];w=+g[$+36>>2];r=+g[$+8>>2];F=+g[$+24>>2];G=+g[$+40>>2];R=-+g[$+48>>2];L=-+g[$+52>>2];M=-+g[$+56>>2];t=E*(2.0/(E*E+D*D+ba*ba+fa*fa));I=D*(2.0/(E*E+D*D+ba*ba+fa*fa));ga=ba*(2.0/(E*E+D*D+ba*ba+fa*fa));da=s*(E*ga-fa*I)+(p*(E*I+fa*ga)+N*(1.0-(D*I+ba*ga)));aa=s*(D*ga+fa*t)+(N*(E*I-fa*ga)+p*(1.0-(E*t+ba*ga)));y=N*(E*ga+fa*I)+p*(D*ga-fa*t)+s*(1.0-(E*t+D*I));ca=q*(E*ga-fa*I)+(z*(E*I+fa*ga)+O*(1.0-(D*I+ba*ga)));B=q*(D*ga+fa*t)+(O*(E*I-fa*ga)+z*(1.0-(E*t+ba*ga)));v=O*(E*ga+fa*I)+z*(D*ga-fa*t)+q*(1.0-(E*t+D*I));ea=H*(E*ga-fa*I)+(x*(E*I+fa*ga)+A*(1.0-(D*I+ba*ga)));ba=H*(D*ga+fa*t)+(A*(E*I-fa*ga)+x*(1.0-(E*t+ba*ga)));I=A*(E*ga+fa*I)+x*(D*ga-fa*t)+H*(1.0-(E*t+D*I));$=c[(c[K>>2]|0)+64>>2]|0;D=-+g[J+48>>2];t=-+g[J+52>>2];E=-+g[J+56>>2];g[f+96>>2]=(G*ea+(r*da+F*ca))*E+((u*ea+(_*da+Z*ca))*D+(w*ea+(Y*da+X*ca))*t);g[f+100>>2]=(G*ba+(r*aa+F*B))*E+((u*ba+(_*aa+Z*B))*D+(w*ba+(Y*aa+X*B))*t);g[f+104>>2]=(G*I+(r*y+F*v))*E+((u*I+(_*y+Z*v))*D+(w*I+(Y*y+X*v))*t);g[f+108>>2]=0.0;rc[$&127](f+112|0,K,f+96|0);t=+g[f+112>>2];v=+g[f+116>>2];y=+g[f+120>>2];I=+g[J+48>>2];D=+g[J+52>>2];E=+g[J+56>>2];B=E*(W*r+V*F+U*G+(r*R+F*L+G*M)+((N*r+O*F+A*G)*t+(p*r+z*F+x*G)*v+(s*r+q*F+H*G)*y))+(I*(W*_+V*Z+U*u+(_*R+Z*L+u*M)+((N*_+O*Z+A*u)*t+(p*_+z*Z+x*u)*v+(s*_+q*Z+H*u)*y))+D*(W*Y+V*X+U*w+(Y*R+X*L+w*M)+((N*Y+O*X+A*w)*t+(p*Y+z*X+x*w)*v+(s*Y+q*X+H*w)*y)))- +g[J+64>>2];u=W*_+V*Z+U*u+(_*R+Z*L+u*M)+((N*_+O*Z+A*u)*t+(p*_+z*Z+x*u)*v+(s*_+q*Z+H*u)*y)-I*B;w=W*Y+V*X+U*w+(Y*R+X*L+w*M)+((N*Y+O*X+A*w)*t+(p*Y+z*X+x*w)*v+(s*Y+q*X+H*w)*y)-D*B;y=W*r+V*F+U*G+(r*R+F*L+G*M)+((N*r+O*F+A*G)*t+(p*r+z*F+x*G)*v+(s*r+q*F+H*G)*y)-E*B;J=c[C+12>>2]|0;G=+g[J>>2];H=+g[J+4>>2];F=+g[J+8>>2];q=+g[J+16>>2];r=+g[J+20>>2];s=+g[J+24>>2];v=+g[J+32>>2];x=+g[J+36>>2];z=+g[J+40>>2];p=+g[J+48>>2];t=+g[J+52>>2];A=+g[J+56>>2];J=c[b+12>>2]|0;K=B<+g[J+752>>2];c[h+4>>2]=J;if(K){$=c[C+12>>2]|0;fa=I*+g[$+16>>2]+D*+g[$+20>>2]+E*+g[$+24>>2];ga=I*+g[$+32>>2]+D*+g[$+36>>2]+E*+g[$+40>>2];g[f+80>>2]=+g[$>>2]*I+ +g[$+4>>2]*D+ +g[$+8>>2]*E;g[f+84>>2]=fa;g[f+88>>2]=ga;g[f+92>>2]=0.0;g[f+64>>2]=F*y+(G*u+H*w)+p;g[f+68>>2]=u*q+w*r+y*s+t;g[f+72>>2]=u*v+w*x+y*z+A;g[f+76>>2]=0.0;qc[c[(c[h>>2]|0)+16>>2]&15](h,f+80|0,f+64|0,B)}o=o+1|0;C=c[b+20>>2]|0}while((o|0)<(C|0))}}if(!(a[b+8>>0]|0)){i=f;return}if(!(c[(c[b+12>>2]|0)+748>>2]|0)){i=f;return}b=c[h+4>>2]|0;if(!(c[b+748>>2]|0)){i=f;return}d=c[b+740>>2]|0;e=c[(c[h+8>>2]|0)+8>>2]|0;if((d|0)==(e|0)){xA(b,d+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);i=f;return}else{xA(b,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,e+4|0);i=f;return}}function ID(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function JD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;if(!(c[b+12>>2]|0)){i=e;return}if(!(a[b+8>>0]|0)){i=e;return}h=c[d+4>>2]|0;if((h|0)==(c[d+8>>2]|0)?(f=(h|0)==0?1:h<<1,(h|0)<(f|0)):0){if(!f)g=0;else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}h=c[d+4>>2]|0}if((h|0)>0){j=0;do{k=g+(j<<2)|0;if(k)c[k>>2]=c[(c[d+12>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+12>>2]|0;if(j){if(a[d+16>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0);h=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=g;c[d+8>>2]=f}f=(c[d+12>>2]|0)+(h<<2)|0;if(f)c[f>>2]=c[b+12>>2];c[d+4>>2]=h+1;i=e;return}function KD(a){a=a|0;var b=0;b=i;LD(a);if(!a){i=b;return}c[5006]=(c[5006]|0)+1;gF(c[a+ -4>>2]|0);i=b;return}function LD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;c[b>>2]=19496;e=c[b+56>>2]|0;if(e){if(a[b+60>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;f=c[b+28>>2]|0;if((f|0)>0){g=0;do{h=c[b+36>>2]|0;l=h+(g*36|0)+4|0;k=h+(g*36|0)+12|0;e=c[k>>2]|0;j=h+(g*36|0)+16|0;if(e){if(a[j>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[k>>2]=0}a[j>>0]=1;c[k>>2]=0;c[l>>2]=0;c[h+(g*36|0)+8>>2]=0;g=g+1|0}while((g|0)!=(f|0))}e=c[b+36>>2]|0;if(e){if(a[b+40>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;e=c[b+16>>2]|0;if(!e){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;l=b+12|0;c[l>>2]=0;i=d;return}if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;l=b+12|0;c[l>>2]=0;i=d;return}function MD(a){a=a|0;var b=0,d=0,e=0,f=0,h=0.0,j=0.0,k=0.0,l=0;b=i;d=c[a+28>>2]|0;if((d|0)<=0){a=0;do a=a+1|0;while((a|0)<8);d=1;i=b;return d|0}e=c[a+36>>2]|0;k=0.0;j=0.0;h=0.0;f=0;a:while(1){switch(f|0){case 1:{h=+g[a+72>>2]- +g[a+88>>2];j=+g[a+84>>2]+ +g[a+68>>2];k=+g[a+80>>2]+ +g[a+64>>2];break};case 4:{h=+g[a+88>>2]+ +g[a+72>>2];j=+g[a+84>>2]+ +g[a+68>>2];k=+g[a+64>>2]- +g[a+80>>2];break};case 2:{h=+g[a+88>>2]+ +g[a+72>>2];j=+g[a+68>>2]- +g[a+84>>2];k=+g[a+80>>2]+ +g[a+64>>2];break};case 0:{h=+g[a+88>>2]+ +g[a+72>>2];j=+g[a+84>>2]+ +g[a+68>>2];k=+g[a+80>>2]+ +g[a+64>>2];break};case 3:{h=+g[a+72>>2]- +g[a+88>>2];j=+g[a+68>>2]- +g[a+84>>2];k=+g[a+80>>2]+ +g[a+64>>2];break};case 6:{h=+g[a+88>>2]+ +g[a+72>>2];j=+g[a+68>>2]- +g[a+84>>2];k=+g[a+64>>2]- +g[a+80>>2];break};case 7:{h=+g[a+72>>2]- +g[a+88>>2];j=+g[a+68>>2]- +g[a+84>>2];k=+g[a+64>>2]- +g[a+80>>2];break};case 5:{h=+g[a+72>>2]- +g[a+88>>2];j=+g[a+84>>2]+ +g[a+68>>2];k=+g[a+64>>2]- +g[a+80>>2];break};default:{}}l=0;do{if(+g[e+(l*36|0)+32>>2]+(k*+g[e+(l*36|0)+20>>2]+j*+g[e+(l*36|0)+24>>2]+h*+g[e+(l*36|0)+28>>2])>0.0){d=0;a=17;break a}l=l+1|0}while((l|0)<(d|0));f=f+1|0;if((f|0)>=8){d=1;a=17;break}}if((a|0)==17){i=b;return d|0}return 0}function ND(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0;k=i;i=i+16|0;g[e>>2]=3.4028234663852886e+38;g[f>>2]=-3.4028234663852886e+38;m=c[a+8>>2]|0;if((m|0)>0){n=0;do{s=c[a+16>>2]|0;r=+g[s+(n<<4)>>2];q=+g[s+(n<<4)+4>>2];l=+g[s+(n<<4)+8>>2];p=r*+g[b>>2]+q*+g[b+4>>2]+l*+g[b+8>>2]+ +g[b+48>>2];o=r*+g[b+16>>2]+q*+g[b+20>>2]+l*+g[b+24>>2]+ +g[b+52>>2];l=r*+g[b+32>>2]+q*+g[b+36>>2]+l*+g[b+40>>2]+ +g[b+56>>2];q=p*+g[d>>2]+o*+g[d+4>>2]+l*+g[d+8>>2];if(q<+g[e>>2]){g[e>>2]=q;g[h>>2]=p;g[h+4>>2]=o;g[h+8>>2]=l;g[h+12>>2]=0.0}if(q>+g[f>>2]){g[f>>2]=q;g[j>>2]=p;g[j+4>>2]=o;g[j+8>>2]=l;g[j+12>>2]=0.0}n=n+1|0}while((n|0)!=(m|0));o=+g[f>>2]}else o=-3.4028234663852886e+38;l=+g[e>>2];if(!(l>o)){i=k;return}g[e>>2]=o;g[f>>2]=l;c[k+0>>2]=c[h+0>>2];c[k+4>>2]=c[h+4>>2];c[k+8>>2]=c[h+8>>2];c[k+12>>2]=c[h+12>>2];c[h+0>>2]=c[j+0>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j+0>>2]=c[k+0>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];i=k;return}function OD(b,e,f){b=b|0;e=e|0;f=f|0;var h=0,j=0.0,k=0,l=0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0;h=i;i=i+176|0;c[b+348>>2]=b+220;c[b+352>>2]=b+252;c[b+356>>2]=b+284;c[b+360>>2]=b+316;c[b+364>>2]=4;c[b+368>>2]=0;c[b+376>>2]=0;y=c[e+4>>2]|0;c[b>>2]=c[e>>2];c[b+4>>2]=y;c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];c[b+16>>2]=c[e+16>>2];c[b+20>>2]=c[e+20>>2];c[b+24>>2]=c[e+24>>2];c[b+28>>2]=c[e+28>>2];c[b+32>>2]=c[e+32>>2];c[b+36>>2]=c[e+36>>2];c[b+40>>2]=c[e+40>>2];c[b+44>>2]=c[e+44>>2];c[b+48>>2]=c[e+48>>2];c[b+52>>2]=c[e+52>>2];c[b+56>>2]=c[e+56>>2];c[b+60>>2]=c[e+60>>2];c[b+64>>2]=c[e+64>>2];c[b+68>>2]=c[e+68>>2];c[b+72>>2]=c[e+72>>2];c[b+76>>2]=c[e+76>>2];c[b+80>>2]=c[e+80>>2];c[b+84>>2]=c[e+84>>2];c[b+88>>2]=c[e+88>>2];c[b+92>>2]=c[e+92>>2];c[b+96>>2]=c[e+96>>2];c[b+100>>2]=c[e+100>>2];c[b+104>>2]=c[e+104>>2];c[b+108>>2]=c[e+108>>2];c[b+112>>2]=c[e+112>>2];c[b+116>>2]=c[e+116>>2];y=d[e+120>>0]|d[e+121>>0]<<8|d[e+122>>0]<<16|d[e+123>>0]<<24;z=d[e+124>>0]|d[e+125>>0]<<8|d[e+126>>0]<<16|d[e+127>>0]<<24;a[b+120>>0]=y;a[b+121>>0]=y>>8;a[b+122>>0]=y>>16;a[b+123>>0]=y>>24;a[b+124>>0]=z;a[b+125>>0]=z>>8;a[b+126>>0]=z>>16;a[b+127>>0]=z>>24;g[b+144>>2]=0.0;c[b+180>>2]=0;c[b+128>>2]=c[f+0>>2];c[b+132>>2]=c[f+4>>2];c[b+136>>2]=c[f+8>>2];c[b+140>>2]=c[f+12>>2];s=+g[b+128>>2];t=+g[b+132>>2];n=+g[b+136>>2];if(s*s+t*t+n*n>0.0){v=-s;m=-t;u=-n}else{v=1.0;m=0.0;u=0.0}g[b+164>>2]=0.0;c[b+364>>2]=3;c[b+148>>2]=b+316;c[b+180>>2]=1;RD(b,v,m,u,b+316|0);g[b+164>>2]=1.0;e=(c[b+148>>2]|0)+16|0;c[b+128>>2]=c[e+0>>2];c[b+132>>2]=c[e+4>>2];c[b+136>>2]=c[e+8>>2];c[b+140>>2]=c[e+12>>2];c[h+72>>2]=c[e+0>>2];c[h+76>>2]=c[e+4>>2];c[h+80>>2]=c[e+8>>2];c[h+84>>2]=c[e+12>>2];c[h+56>>2]=c[e+0>>2];c[h+60>>2]=c[e+4>>2];c[h+64>>2]=c[e+8>>2];c[h+68>>2]=c[e+12>>2];c[h+40>>2]=c[e+0>>2];c[h+44>>2]=c[e+4>>2];c[h+48>>2]=c[e+8>>2];c[h+52>>2]=c[e+12>>2];c[h+24>>2]=c[e+0>>2];c[h+28>>2]=c[e+4>>2];c[h+32>>2]=c[e+8>>2];c[h+36>>2]=c[e+12>>2];m=0.0;e=1;f=1;A=s*s+t*t+n*n;a:while(1){l=c[b+368>>2]|0;u=+g[b+128>>2];t=+g[b+132>>2];s=+g[b+136>>2];n=+Q(+(u*u+t*t+s*s));if(n<9999999747378752.0e-20){k=5;break}g[b+(l*36|0)+(c[b+(l*36|0)+180>>2]<<2)+164>>2]=0.0;o=(c[b+364>>2]|0)+ -1|0;c[b+364>>2]=o;c[b+(l*36|0)+(c[b+(l*36|0)+180>>2]<<2)+148>>2]=c[b+(o<<2)+348>>2];o=c[b+(l*36|0)+180>>2]|0;c[b+(l*36|0)+180>>2]=o+1;RD(b,-u,-t,-s,c[b+(l*36|0)+(o<<2)+148>>2]|0);o=c[b+(l*36|0)+180>>2]|0;q=c[b+(l*36|0)+(o+ -1<<2)+148>>2]|0;s=+g[q+16>>2];u=+g[q+20>>2];t=+g[q+24>>2];p=0;do{v=s- +g[h+24+(p<<4)>>2];w=u- +g[h+24+(p<<4)+4>>2];x=t- +g[h+24+(p<<4)+8>>2];p=p+1|0;if(v*v+w*w+x*x<9999999747378752.0e-20){k=9;break a}}while(p>>>0<4);z=h+24+(e<<4)|0;c[z+0>>2]=c[q+16>>2];c[z+4>>2]=c[q+20>>2];c[z+8>>2]=c[q+24>>2];c[z+12>>2]=c[q+28>>2];x=(+g[b+128>>2]*s+ +g[b+132>>2]*u+ +g[b+136>>2]*t)/n;m=x>m?x:m;if(n-m-n*9999999747378752.0e-20<=0.0){k=11;break}c[h>>2]=0;if((o|0)==4){q=c[b+(l*36|0)+148>>2]|0;r=c[b+(l*36|0)+152>>2]|0;p=c[b+(l*36|0)+156>>2]|0;o=c[b+(l*36|0)+160>>2]|0;c[h+152>>2]=q+16;c[h+156>>2]=r+16;c[h+160>>2]=p+16;c[h+164>>2]=o+16;u=+g[q+16>>2];v=+g[o+16>>2];s=+g[q+20>>2];w=+g[o+20>>2];t=+g[q+24>>2];x=+g[o+24>>2];g[h+104>>2]=u-v;g[h+108>>2]=s-w;g[h+112>>2]=t-x;g[h+116>>2]=0.0;C=+g[r+16>>2];E=+g[r+20>>2];A=+g[r+24>>2];g[h+120>>2]=C-v;g[h+124>>2]=E-w;g[h+128>>2]=A-x;g[h+132>>2]=0.0;B=+g[p+16>>2];F=+g[p+20>>2];D=+g[p+24>>2];g[h+136>>2]=B-v;g[h+140>>2]=F-w;g[h+144>>2]=D-x;g[h+148>>2]=0.0;n=(s-w)*(A-x)*(B-v)+(t-x)*(C-v)*(F-w)-(F-w)*(A-x)*(u-v)-(s-w)*(C-v)*(D-x)+(D-x)*(u-v)*(E-w)-(B-v)*(t-x)*(E-w);if(!(!(n*(t*((C-B)*(s-E)-(E-F)*(u-C))+(u*((E-F)*(t-A)-(A-D)*(s-E))+s*((A-D)*(u-C)-(C-B)*(t-A))))<=0.0)|(n!=n|0.0!=0.0|n==0.0))){c[h+92>>2]=0;c[h+96>>2]=0;c[h+100>>2]=0;c[h+88>>2]=0;s=s-w;t=t-x;u=u-v;y=0;A=-1.0;while(1){z=c[19552+(y<<2)>>2]|0;D=+g[h+104+(z<<4)+8>>2];E=+g[h+104+(z<<4)+4>>2];F=+g[h+104+(z<<4)>>2];if(n*((s*D-t*E)*v+w*(t*F-D*u)+(E*u-s*F)*x)>0.0?(j=+VD(c[h+152+(y<<2)>>2]|0,c[h+152+(z<<2)>>2]|0,o+16|0,h+92|0,h+88|0),A<0.0|j<A):0){G=c[h+88>>2]|0;c[h>>2]=((G&2|0)==0?0:1<<z)+(G<<1&8)+((G&1|0)==0?0:1<<y);g[h+8+(y<<2)>>2]=+g[h+92>>2];g[h+8+(z<<2)>>2]=+g[h+96>>2];g[h+8+(c[19552+(z<<2)>>2]<<2)>>2]=0.0;g[h+20>>2]=+g[h+100>>2];A=j}y=y+1|0;if((y|0)==3)break;s=+g[h+104+(y<<4)+4>>2];t=+g[h+104+(y<<4)+8>>2];u=+g[h+104+(y<<4)>>2];v=+g[o+16>>2];w=+g[o+20>>2];x=+g[o+24>>2]}if(A<0.0){c[h>>2]=15;A=+g[p+20>>2];s=+g[r+24>>2];E=+g[o+16>>2];w=+g[p+24>>2];t=+g[r+16>>2];v=+g[o+20>>2];B=+g[p+16>>2];C=+g[o+24>>2];u=+g[r+20>>2];g[h+8>>2]=(A*s*E+w*t*v-v*s*B-A*t*C+C*B*u-E*w*u)/n;x=+g[q+20>>2];F=+g[q+24>>2];D=+g[q+16>>2];g[h+12>>2]=(x*w*E+F*B*v-v*w*D-x*B*C+C*D*A-E*F*A)/n;g[h+16>>2]=(u*F*E+s*D*v-v*F*t-u*D*C+C*t*x-E*s*x)/n;g[h+20>>2]=1.0-((u*F*E+s*D*v-v*F*t-u*D*C+C*t*x-E*s*x)/n+((A*s*E+w*t*v-v*s*B-A*t*C+C*B*u-E*w*u)/n+(x*w*E+F*B*v-v*w*D-x*B*C+C*D*A-E*F*A)/n));A=0.0}}else A=-1.0}else if((o|0)==3)A=+VD((c[b+(l*36|0)+148>>2]|0)+16|0,(c[b+(l*36|0)+152>>2]|0)+16|0,(c[b+(l*36|0)+156>>2]|0)+16|0,h+8|0,h);else if((o|0)==2)A=+UD((c[b+(l*36|0)+148>>2]|0)+16|0,(c[b+(l*36|0)+152>>2]|0)+16|0,h+8|0,h);if(!(A>=0.0)){k=32;break}c[b+((1-l|0)*36|0)+180>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+368>>2]=1-l;y=c[b+(l*36|0)+180>>2]|0;o=c[h>>2]|0;if(y){r=0;do{q=b+(l*36|0)+(r<<2)+148|0;p=c[q>>2]|0;if(!(o&1<<r)){G=c[b+364>>2]|0;c[b+364>>2]=G+1;c[b+(G<<2)+348>>2]=p}else{c[b+((1-l|0)*36|0)+(c[b+((1-l|0)*36|0)+180>>2]<<2)+148>>2]=p;D=+g[h+8+(r<<2)>>2];G=c[b+((1-l|0)*36|0)+180>>2]|0;c[b+((1-l|0)*36|0)+180>>2]=G+1;g[b+((1-l|0)*36|0)+(G<<2)+164>>2]=D;G=c[q>>2]|0;E=D*+g[G+20>>2];F=D*+g[G+24>>2];g[b+128>>2]=+g[G+16>>2]*D+ +g[b+128>>2];g[b+132>>2]=E+ +g[b+132>>2];g[b+136>>2]=F+ +g[b+136>>2]}r=r+1|0}while((r|0)!=(y|0))}if((o|0)==15)c[b+376>>2]=1;if(f>>>0>=128){k=34;break}if(c[b+376>>2]|0)break;e=e+1&3;f=f+1|0}if((k|0)==5)c[b+376>>2]=1;else if((k|0)==9){G=c[b+368>>2]|0;z=(c[b+(G*36|0)+180>>2]|0)+ -1|0;c[b+(G*36|0)+180>>2]=z;z=c[b+(G*36|0)+(z<<2)+148>>2]|0;G=c[b+364>>2]|0;c[b+364>>2]=G+1;c[b+(G<<2)+348>>2]=z}else if((k|0)==11){G=c[b+368>>2]|0;z=(c[b+(G*36|0)+180>>2]|0)+ -1|0;c[b+(G*36|0)+180>>2]=z;z=c[b+(G*36|0)+(z<<2)+148>>2]|0;G=c[b+364>>2]|0;c[b+364>>2]=G+1;c[b+(G<<2)+348>>2]=z}else if((k|0)==32){G=c[b+368>>2]|0;z=(c[b+(G*36|0)+180>>2]|0)+ -1|0;c[b+(G*36|0)+180>>2]=z;z=c[b+(G*36|0)+(z<<2)+148>>2]|0;G=c[b+364>>2]|0;c[b+364>>2]=G+1;c[b+(G<<2)+348>>2]=z}else if((k|0)==34)c[b+376>>2]=2;c[b+372>>2]=b+((c[b+368>>2]|0)*36|0)+148;k=c[b+376>>2]|0;if((k|0)==1){g[b+144>>2]=0.0;i=h;return k|0}else if(!k){D=+g[b+128>>2];E=+g[b+132>>2];F=+g[b+136>>2];g[b+144>>2]=+Q(+(D*D+E*E+F*F));i=h;return k|0}else{i=h;return k|0}return 0}function PD(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0;b=i;i=i+32|0;d=c[a+372>>2]|0;m=c[d+32>>2]|0;a:do if((m|0)==2){n=c[d+4>>2]|0;d=c[d>>2]|0;h=+g[n+16>>2]- +g[d+16>>2];e=+g[n+20>>2]- +g[d+20>>2];f=+g[n+24>>2]- +g[d+24>>2];d=0;while(1){n=b+(d<<2)|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[n>>2]=1.0;j=+g[b+8>>2];k=+g[b+4>>2];l=+g[b>>2];if((e*j-f*k)*(e*j-f*k)+(f*l-h*j)*(f*l-h*j)+(h*k-e*l)*(h*k-e*l)>0.0){m=c[a+372>>2]|0;g[m+(c[m+32>>2]<<2)+16>>2]=0.0;n=(c[a+364>>2]|0)+ -1|0;c[a+364>>2]=n;c[m+(c[m+32>>2]<<2)>>2]=c[a+(n<<2)+348>>2];n=c[m+32>>2]|0;c[m+32>>2]=n+1;RD(a,e*j-f*k,f*l-h*j,h*k-e*l,c[m+(n<<2)>>2]|0);if(PD(a)|0){d=1;a=19;break}m=c[a+372>>2]|0;n=(c[m+32>>2]|0)+ -1|0;c[m+32>>2]=n;n=c[m+(n<<2)>>2]|0;m=c[a+364>>2]|0;c[a+364>>2]=m+1;c[a+(m<<2)+348>>2]=n;m=c[a+372>>2]|0;g[m+(c[m+32>>2]<<2)+16>>2]=0.0;n=(c[a+364>>2]|0)+ -1|0;c[a+364>>2]=n;c[m+(c[m+32>>2]<<2)>>2]=c[a+(n<<2)+348>>2];n=c[m+32>>2]|0;c[m+32>>2]=n+1;RD(a,-(e*j-f*k),-(f*l-h*j),-(h*k-e*l),c[m+(n<<2)>>2]|0);if(PD(a)|0){d=1;a=19;break}n=c[a+372>>2]|0;m=(c[n+32>>2]|0)+ -1|0;c[n+32>>2]=m;m=c[n+(m<<2)>>2]|0;n=c[a+364>>2]|0;c[a+364>>2]=n+1;c[a+(n<<2)+348>>2]=m}d=d+1|0;if(d>>>0>=3)break a}if((a|0)==19){i=b;return d|0}}else if((m|0)==1){n=1;m=0;while(1){o=b+16+(m<<2)|0;c[b+16>>2]=0;c[b+20>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;g[o>>2]=1.0;o=d+32|0;g[d+(n<<2)+16>>2]=0.0;n=(c[a+364>>2]|0)+ -1|0;c[a+364>>2]=n;c[d+(c[o>>2]<<2)>>2]=c[a+(n<<2)+348>>2];n=c[o>>2]|0;c[o>>2]=n+1;h=+g[b+16>>2];e=+g[b+20>>2];f=+g[b+24>>2];RD(a,h,e,f,c[d+(n<<2)>>2]|0);if(PD(a)|0){d=1;a=19;break}n=c[a+372>>2]|0;o=(c[n+32>>2]|0)+ -1|0;c[n+32>>2]=o;o=c[n+(o<<2)>>2]|0;n=c[a+364>>2]|0;c[a+364>>2]=n+1;c[a+(n<<2)+348>>2]=o;n=c[a+372>>2]|0;g[n+(c[n+32>>2]<<2)+16>>2]=0.0;o=(c[a+364>>2]|0)+ -1|0;c[a+364>>2]=o;c[n+(c[n+32>>2]<<2)>>2]=c[a+(o<<2)+348>>2];o=c[n+32>>2]|0;c[n+32>>2]=o+1;RD(a,-h,-e,-f,c[n+(o<<2)>>2]|0);if(PD(a)|0){d=1;a=19;break}o=c[a+372>>2]|0;n=(c[o+32>>2]|0)+ -1|0;c[o+32>>2]=n;n=c[o+(n<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+(o<<2)+348>>2]=n;m=m+1|0;if(m>>>0>=3)break a;d=c[a+372>>2]|0;n=c[d+32>>2]|0}if((a|0)==19){i=b;return d|0}}else if((m|0)==3){o=c[d+4>>2]|0;n=c[d>>2]|0;e=+g[n+16>>2];j=+g[o+16>>2]-e;f=+g[n+20>>2];l=+g[o+20>>2]-f;k=+g[n+24>>2];h=+g[o+24>>2]-k;o=c[d+8>>2]|0;e=+g[o+16>>2]-e;f=+g[o+20>>2]-f;k=+g[o+24>>2]-k;if((l*k-h*f)*(l*k-h*f)+(h*e-j*k)*(h*e-j*k)+(j*f-l*e)*(j*f-l*e)>0.0){g[d+28>>2]=0.0;o=(c[a+364>>2]|0)+ -1|0;c[a+364>>2]=o;c[d+(c[d+32>>2]<<2)>>2]=c[a+(o<<2)+348>>2];o=c[d+32>>2]|0;c[d+32>>2]=o+1;RD(a,l*k-h*f,h*e-j*k,j*f-l*e,c[d+(o<<2)>>2]|0);if(PD(a)|0){o=1;i=b;return o|0}n=c[a+372>>2]|0;o=(c[n+32>>2]|0)+ -1|0;c[n+32>>2]=o;o=c[n+(o<<2)>>2]|0;n=c[a+364>>2]|0;c[a+364>>2]=n+1;c[a+(n<<2)+348>>2]=o;n=c[a+372>>2]|0;g[n+(c[n+32>>2]<<2)+16>>2]=0.0;o=(c[a+364>>2]|0)+ -1|0;c[a+364>>2]=o;c[n+(c[n+32>>2]<<2)>>2]=c[a+(o<<2)+348>>2];o=c[n+32>>2]|0;c[n+32>>2]=o+1;RD(a,-(l*k-h*f),-(h*e-j*k),-(j*f-l*e),c[n+(o<<2)>>2]|0);if(PD(a)|0){o=1;i=b;return o|0}else{o=c[a+372>>2]|0;n=(c[o+32>>2]|0)+ -1|0;c[o+32>>2]=n;n=c[o+(n<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+(o<<2)+348>>2]=n;break}}}else if((m|0)==4?(o=c[d>>2]|0,n=c[d+12>>2]|0,l=+g[n+16>>2],r=+g[o+16>>2]-l,p=+g[n+20>>2],e=+g[o+20>>2]-p,h=+g[n+24>>2],j=+g[o+24>>2]-h,o=c[d+4>>2]|0,f=+g[o+16>>2]-l,k=+g[o+20>>2]-p,q=+g[o+24>>2]-h,o=c[d+8>>2]|0,l=+g[o+16>>2]-l,p=+g[o+20>>2]-p,h=+g[o+24>>2]-h,!((0.0!=0.0?1:r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l!=r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l)|r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l==0.0)):0){o=1;i=b;return o|0}while(0);o=0;i=b;return o|0}function QD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0;k=i;j=c[b+9288>>2]|0;if(!j){c[b>>2]=5;s=0;i=k;return s|0}s=c[j+48>>2]|0;if(s)c[s+44>>2]=c[j+44>>2];s=c[j+44>>2]|0;if(s)c[s+48>>2]=c[j+48>>2];if((c[b+9288>>2]|0)==(j|0))c[b+9288>>2]=c[j+48>>2];c[b+9292>>2]=(c[b+9292>>2]|0)+ -1;c[j+44>>2]=0;c[j+48>>2]=c[b+9280>>2];s=c[b+9280>>2]|0;if(s)c[s+44>>2]=j;c[b+9280>>2]=j;c[b+9284>>2]=(c[b+9284>>2]|0)+1;a[j+55>>0]=0;c[j+20>>2]=d;c[j+24>>2]=e;c[j+28>>2]=f;p=+g[d+16>>2];n=+g[e+16>>2]-p;r=+g[d+20>>2];q=+g[e+20>>2]-r;m=+g[d+24>>2];l=+g[e+24>>2]-m;p=+g[f+16>>2]-p;r=+g[f+20>>2]-r;m=+g[f+24>>2]-m;g[j>>2]=q*m-l*r;g[j+4>>2]=l*p-n*m;g[j+8>>2]=n*r-q*p;g[j+12>>2]=0.0;o=+Q(+((q*m-l*r)*(q*m-l*r)+(l*p-n*m)*(l*p-n*m)+(n*r-q*p)*(n*r-q*p)));do if(o>9999999747378752.0e-20){if((!(TD(q*m-l*r,l*p-n*m,n*r-q*p,+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],j+16|0)|0)?!(TD(+g[j>>2],+g[j+4>>2],+g[j+8>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],j+16|0)|0):0)?!(TD(+g[j>>2],+g[j+4>>2],+g[j+8>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],j+16|0)|0):0)g[j+16>>2]=(+g[d+16>>2]*+g[j>>2]+ +g[d+20>>2]*+g[j+4>>2]+ +g[d+24>>2]*+g[j+8>>2])/o;g[j>>2]=1.0/o*+g[j>>2];g[j+4>>2]=1.0/o*+g[j+4>>2];g[j+8>>2]=1.0/o*+g[j+8>>2];if(h){s=j;i=k;return s|0}if(!(+g[j+16>>2]>=-9999999747378752.0e-21)){c[b>>2]=3;break}else{s=j;i=k;return s|0}}else c[b>>2]=2;while(0);h=c[j+48>>2]|0;if(h)c[h+44>>2]=c[j+44>>2];h=c[j+44>>2]|0;if(h)c[h+48>>2]=c[j+48>>2];if((c[b+9280>>2]|0)==(j|0))c[b+9280>>2]=c[j+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+ -1;c[j+44>>2]=0;c[j+48>>2]=c[b+9288>>2];h=c[b+9288>>2]|0;if(h)c[h+44>>2]=j;c[b+9288>>2]=j;c[b+9292>>2]=(c[b+9292>>2]|0)+1;s=0;i=k;return s|0}function RD(a,b,e,f,h){a=a|0;b=+b;e=+e;f=+f;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0.0;j=i;i=i+48|0;n=1.0/+Q(+(b*b+e*e+f*f));g[h>>2]=n*b;g[h+4>>2]=n*e;g[h+8>>2]=n*f;g[h+12>>2]=0.0;l=d[a+120>>0]|d[a+121>>0]<<8|d[a+122>>0]<<16|d[a+123>>0]<<24;m=d[a+124>>0]|d[a+125>>0]<<8|d[a+126>>0]<<16|d[a+127>>0]<<24;k=(c[a>>2]|0)+(m>>1)|0;if(m&1)l=c[(c[k>>2]|0)+l>>2]|0;rc[l&127](j,k,h);e=-+g[h>>2];f=-+g[h+4>>2];b=-+g[h+8>>2];l=d[a+120>>0]|d[a+121>>0]<<8|d[a+122>>0]<<16|d[a+123>>0]<<24;m=d[a+124>>0]|d[a+125>>0]<<8|d[a+126>>0]<<16|d[a+127>>0]<<24;k=(c[a+4>>2]|0)+(m>>1)|0;if(m&1)l=c[(c[k>>2]|0)+l>>2]|0;n=+g[a+24>>2]*e+ +g[a+28>>2]*f+ +g[a+32>>2]*b;o=+g[a+40>>2]*e+ +g[a+44>>2]*f+ +g[a+48>>2]*b;g[j+16>>2]=+g[a+8>>2]*e+ +g[a+12>>2]*f+ +g[a+16>>2]*b;g[j+20>>2]=n;g[j+24>>2]=o;g[j+28>>2]=0.0;rc[l&127](j+32|0,k,j+16|0);o=+g[j+32>>2];e=+g[j+36>>2];f=+g[j+40>>2];b=+g[j+4>>2]-(o*+g[a+72>>2]+e*+g[a+76>>2]+f*+g[a+80>>2]+ +g[a+108>>2]);n=+g[j+8>>2]-(o*+g[a+88>>2]+e*+g[a+92>>2]+f*+g[a+96>>2]+ +g[a+112>>2]);g[h+16>>2]=+g[j>>2]-(o*+g[a+56>>2]+e*+g[a+60>>2]+f*+g[a+64>>2]+ +g[a+104>>2]);g[h+20>>2]=b;g[h+24>>2]=n;g[h+28>>2]=0.0;i=j;return}function SD(b,e,f,h,j,k){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0;l=i;if((d[h+55>>0]|0|0)==(e|0)){j=0;i=l;return j|0}m=c[19552+(j<<2)>>2]|0;if(+g[h>>2]*+g[f+16>>2]+ +g[h+4>>2]*+g[f+20>>2]+ +g[h+8>>2]*+g[f+24>>2]- +g[h+16>>2]<-9999999747378752.0e-21){b=QD(b,c[h+(m<<2)+20>>2]|0,c[h+(j<<2)+20>>2]|0,f,0)|0;if(!b){j=0;i=l;return j|0}a[b+52>>0]=j;c[b+32>>2]=h;a[h+j+52>>0]=0;c[h+(j<<2)+32>>2]=b;h=c[k>>2]|0;if(!h)c[k+4>>2]=b;else{a[h+53>>0]=2;c[h+36>>2]=b;a[b+54>>0]=1;c[b+40>>2]=h}c[k>>2]=b;c[k+8>>2]=(c[k+8>>2]|0)+1;j=1;i=l;return j|0}j=c[19536+(j<<2)>>2]|0;a[h+55>>0]=e;if(!(SD(b,e,f,c[h+(m<<2)+32>>2]|0,d[h+m+52>>0]|0,k)|0)){j=0;i=l;return j|0}if(!(SD(b,e,f,c[h+(j<<2)+32>>2]|0,d[h+j+52>>0]|0,k)|0)){j=0;i=l;return j|0}k=c[h+48>>2]|0;if(k)c[k+44>>2]=c[h+44>>2];k=c[h+44>>2]|0;if(k)c[k+48>>2]=c[h+48>>2];if((c[b+9280>>2]|0)==(h|0))c[b+9280>>2]=c[h+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+ -1;c[h+44>>2]=0;c[h+48>>2]=c[b+9288>>2];k=c[b+9288>>2]|0;if(k)c[k+44>>2]=h;c[b+9288>>2]=h;c[b+9292>>2]=(c[b+9292>>2]|0)+1;j=1;i=l;return j|0}function TD(a,b,c,d,e,f,h,j,k,l){a=+a;b=+b;c=+c;d=+d;e=+e;f=+f;h=+h;j=+j;k=+k;l=l|0;var m=0;m=i;if(!(((h-d)*b-(j-e)*a)*f+(((j-e)*c-(k-f)*b)*d+((k-f)*a-(h-d)*c)*e)<0.0)){l=0;i=m;return l|0}if((h-d)*d+(j-e)*e+(k-f)*f>0.0){g[l>>2]=+Q(+(d*d+e*e+f*f));l=1;i=m;return l|0}if((h-d)*h+(j-e)*j+(k-f)*k<0.0){g[l>>2]=+Q(+(h*h+j*j+k*k));l=1;i=m;return l|0}else{b=((h*h+j*j+k*k)*(d*d+e*e+f*f)-(h*d+j*e+k*f)*(h*d+j*e+k*f))/((h-d)*(h-d)+(j-e)*(j-e)+(k-f)*(k-f));g[l>>2]=+Q(+(b>0.0?b:0.0));l=1;i=m;return l|0}return 0}function UD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0;k=i;l=+g[a>>2];f=+g[b>>2]-l;m=+g[a+4>>2];h=+g[b+4>>2]-m;n=+g[a+8>>2];j=+g[b+8>>2]-n;if(!(f*f+h*h+j*j>0.0)){n=-1.0;i=k;return+n}l=-(l*f+m*h+n*j)/(f*f+h*h+j*j);if(l>=1.0){g[d>>2]=0.0;g[d+4>>2]=1.0;c[e>>2]=2;l=+g[b>>2];m=+g[b+4>>2];n=+g[b+8>>2];n=l*l+m*m+n*n;i=k;return+n}if(!(l<=0.0)){g[d+4>>2]=l;g[d>>2]=1.0-l;c[e>>2]=3;f=f*l+ +g[a>>2];m=h*l+ +g[a+4>>2];n=j*l+ +g[a+8>>2];n=f*f+m*m+n*n;i=k;return+n}else{g[d>>2]=1.0;g[d+4>>2]=0.0;c[e>>2]=1;l=+g[a>>2];m=+g[a+4>>2];n=+g[a+8>>2];n=l*l+m*m+n*n;i=k;return+n}return 0.0}function VD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0.0;u=i;i=i+80|0;c[u+64>>2]=a;c[u+68>>2]=b;c[u+72>>2]=d;r=+g[a>>2];l=+g[b>>2];s=+g[a+4>>2];n=+g[b+4>>2];t=+g[a+8>>2];p=+g[b+8>>2];g[u+16>>2]=r-l;g[u+20>>2]=s-n;g[u+24>>2]=t-p;g[u+28>>2]=0.0;m=+g[d>>2];o=+g[d+4>>2];q=+g[d+8>>2];g[u+32>>2]=l-m;g[u+36>>2]=n-o;g[u+40>>2]=p-q;g[u+44>>2]=0.0;g[u+48>>2]=m-r;g[u+52>>2]=o-s;g[u+56>>2]=q-t;g[u+60>>2]=0.0;j=(s-n)*(p-q)-(t-p)*(n-o);k=(t-p)*(l-m)-(p-q)*(r-l);h=(n-o)*(r-l)-(s-n)*(l-m);if(!(h*h+(j*j+k*k)>0.0)){F=-1.0;i=u;return+F}c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;B=s-n;D=t-p;C=r-l;x=r;y=s;A=t;z=a;E=0;F=-1.0;while(1){if(x*(h*B-k*D)+y*(j*D-h*C)+(k*C-j*B)*A>0.0?(v=c[19552+(E<<2)>>2]|0,w=+UD(z,c[u+64+(v<<2)>>2]|0,u,u+8|0),F<0.0|w<F):0){z=c[u+8>>2]|0;c[f>>2]=((z&1|0)==0?0:1<<E)+((z&2|0)==0?0:1<<v);g[e+(E<<2)>>2]=+g[u>>2];g[e+(v<<2)>>2]=+g[u+4>>2];g[e+(c[19552+(v<<2)>>2]<<2)>>2]=0.0;F=w}E=E+1|0;if((E|0)==3)break;z=c[u+64+(E<<2)>>2]|0;B=+g[u+16+(E<<4)+4>>2];D=+g[u+16+(E<<4)+8>>2];C=+g[u+16+(E<<4)>>2];x=+g[z>>2];y=+g[z+4>>2];A=+g[z+8>>2]}if(!(F<0.0)){i=u;return+F}C=+Q(+(h*h+(j*j+k*k)));F=(j*+g[a>>2]+k*+g[a+4>>2]+h*+g[a+8>>2])/(h*h+(j*j+k*k));c[f>>2]=7;A=+g[b>>2]-j*F;y=+g[b+4>>2]-k*F;D=+g[b+8>>2]-h*F;D=+Q(+((y*(l-m)-A*(n-o))*(y*(l-m)-A*(n-o))+(((n-o)*D-y*(p-q))*((n-o)*D-y*(p-q))+(A*(p-q)-D*(l-m))*(A*(p-q)-D*(l-m)))))/C;g[e>>2]=D;A=+g[d>>2]-j*F;y=+g[d+4>>2]-k*F;B=+g[d+8>>2]-h*F;C=+Q(+((y*(m-r)-A*(o-s))*(y*(m-r)-A*(o-s))+(((o-s)*B-y*(q-t))*((o-s)*B-y*(q-t))+(A*(q-t)-B*(m-r))*(A*(q-t)-B*(m-r)))))/C;g[e+4>>2]=C;g[e+8>>2]=1.0-(C+D);F=h*F*h*F+(j*F*j*F+k*F*k*F);i=u;return+F}function WD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;f=c[b+12>>2]|0;d=c[b+32>>2]|0;if((d|0)>=(f|0)){i=e;return}if((d|0)<=(f|0)){if((c[b+36>>2]|0)<(f|0)){if(!f){g=0;j=d}else{c[5004]=(c[5004]|0)+1;g=fF((f<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+ -4>>2]=g;g=g+19&-16}j=c[b+32>>2]|0}if((j|0)>0){h=0;do{k=g+(h<<2)|0;if(k)c[k>>2]=c[(c[b+40>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(j|0))}h=c[b+40>>2]|0;if(h){if(a[b+44>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[h+ -4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=g;c[b+36>>2]=f}else g=c[b+40>>2]|0;h=d;do{j=g+(h<<2)|0;if(j)c[j>>2]=0;h=h+1|0}while((h|0)!=(f|0))}c[b+32>>2]=f;g=c[b+52>>2]|0;if((g|0)<(f|0)){if((c[b+56>>2]|0)<(f|0)){if(!f){h=0;j=g}else{c[5004]=(c[5004]|0)+1;h=fF((f<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+ -4>>2]=h;h=h+19&-16}j=c[b+52>>2]|0}if((j|0)>0){k=0;do{l=h+(k<<2)|0;if(l)c[l>>2]=c[(c[b+60>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}j=c[b+60>>2]|0;if(j){if(a[b+64>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[j+ -4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=h;c[b+56>>2]=f}else h=c[b+60>>2]|0;do{j=h+(g<<2)|0;if(j)c[j>>2]=0;g=g+1|0}while((g|0)!=(f|0))}c[b+52>>2]=f;if((f|0)>0){jF(c[b+40>>2]|0,-1,f<<2|0)|0;jF(c[b+60>>2]|0,-1,f<<2|0)|0}if((d|0)<=0){i=e;return}h=c[b+16>>2]|0;g=c[b+40>>2]|0;f=c[b+60>>2]|0;j=0;do{l=c[h+(j*12|0)+4>>2]<<16|c[h+(j*12|0)>>2];l=(l+~(l<<15)>>10^l+~(l<<15))*9|0;l=g+((((l>>6^l)+~((l>>6^l)<<11)>>16^(l>>6^l)+~((l>>6^l)<<11))&(c[b+12>>2]|0)+ -1)<<2)|0;c[f+(j<<2)>>2]=c[l>>2];c[l>>2]=j;j=j+1|0}while((j|0)!=(d|0));i=e;return}function XD(a){a=a|0;var b=0;b=i;YD(a);gF(a);i=b;return}function YD(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=19600;e=c[b+60>>2]|0;if(e){if(a[b+64>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;e=c[b+40>>2]|0;if(e){if(a[b+44>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;e=c[b+16>>2]|0;if(!e){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;e=b+12|0;c[e>>2]=0;i=d;return}if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;e=b+12|0;c[e>>2]=0;i=d;return}function ZD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;e=c[b+16>>2]|0;if(e){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;e=c[b+40>>2]|0;if(e){if(a[b+44>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;e=c[b+60>>2]|0;if(e){if(a[b+64>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;if((c[b+12>>2]|0)>=2){WD(b);i=d;return}c[5004]=(c[5004]|0)+1;e=fF(43)|0;if(!e)e=0;else{c[(e+19&-16)+ -4>>2]=e;e=e+19&-16}f=c[b+8>>2]|0;if((f|0)>0){h=0;do{g=e+(h*12|0)|0;if(g){j=(c[b+16>>2]|0)+(h*12|0)|0;c[g+0>>2]=c[j+0>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2]}h=h+1|0}while((h|0)!=(f|0))}f=c[b+16>>2]|0;if(f){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[f+ -4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=e;c[b+12>>2]=2;WD(b);i=d;return}function _D(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;c[4892]=(c[4892]|0)+1;k=((d<<16|b)+~((d<<16|b)<<15)>>10^(d<<16|b)+~((d<<16|b)<<15))*9|0;g=c[a+40>>2]|0;k=g+(((c[a+12>>2]|0)+ -1&((k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11)))<<2)|0;l=c[k>>2]|0;if((l|0)==-1){o=0;i=e;return o|0}h=c[a+16>>2]|0;j=l;while(1){if((c[h+(j*12|0)>>2]|0)==(b|0)?(c[h+(j*12|0)+4>>2]|0)==(d|0):0)break;j=c[(c[a+60>>2]|0)+(j<<2)>>2]|0;if((j|0)==-1){a=0;f=22;break}}if((f|0)==22){i=e;return a|0}if(!(h+(j*12|0)|0)){o=0;i=e;return o|0}b=c[h+(j*12|0)+8>>2]|0;j=(j*12|0)/12|0;d=c[a+60>>2]|0;if((l|0)!=(j|0)){while(1){m=d+(l<<2)|0;n=c[m>>2]|0;if((n|0)==(j|0))break;else l=n}n=c[d+(j<<2)>>2]|0;if((l|0)==-1)f=12;else c[m>>2]=n}else{n=c[d+(l<<2)>>2]|0;f=12}if((f|0)==12)c[k>>2]=n;l=(c[a+8>>2]|0)+ -1|0;if((l|0)==(j|0)){c[a+8>>2]=j;o=b;i=e;return o|0}k=c[h+(l*12|0)+4>>2]<<16|c[h+(l*12|0)>>2];k=(k+~(k<<15)>>10^k+~(k<<15))*9|0;k=((k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11))&(c[a+12>>2]|0)+ -1;n=c[g+(k<<2)>>2]|0;if((n|0)!=(l|0)){while(1){m=d+(n<<2)|0;o=c[m>>2]|0;if((o|0)==(l|0))break;else n=o}d=c[d+(l<<2)>>2]|0;if((n|0)==-1)f=20;else c[m>>2]=d}else{d=c[d+(l<<2)>>2]|0;f=20}if((f|0)==20)c[g+(k<<2)>>2]=d;c[h+(j*12|0)+0>>2]=c[h+(l*12|0)+0>>2];c[h+(j*12|0)+4>>2]=c[h+(l*12|0)+4>>2];c[h+(j*12|0)+8>>2]=c[h+(l*12|0)+8>>2];o=(c[a+40>>2]|0)+(k<<2)|0;c[(c[a+60>>2]|0)+(j<<2)>>2]=c[o>>2];c[o>>2]=j;c[a+8>>2]=(c[a+8>>2]|0)+ -1;o=b;i=e;return o|0}function $D(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;c[4894]=(c[4894]|0)+1;h=((e<<16|d)+~((e<<16|d)<<15)>>10^(e<<16|d)+~((e<<16|d)<<15))*9|0;h=(h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11);g=c[b+12>>2]|0;k=c[(c[b+40>>2]|0)+((g+ -1&h)<<2)>>2]|0;a:do if((k|0)!=-1){j=c[b+16>>2]|0;while(1){if((c[j+(k*12|0)>>2]|0)==(d|0)?(c[j+(k*12|0)+4>>2]|0)==(e|0):0)break;k=c[(c[b+60>>2]|0)+(k<<2)>>2]|0;if((k|0)==-1)break a}j=j+(k*12|0)|0;if(j){o=j;i=f;return o|0}}while(0);j=c[b+8>>2]|0;if((j|0)==(g|0)){k=(g|0)==0?1:g<<1;if((g|0)<(k|0)){if(!k){l=0;o=g}else{c[5004]=(c[5004]|0)+1;l=fF((k*12|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+ -4>>2]=l;l=l+19&-16}o=c[b+8>>2]|0}if((o|0)>0){n=0;do{m=l+(n*12|0)|0;if(m){p=(c[b+16>>2]|0)+(n*12|0)|0;c[m+0>>2]=c[p+0>>2];c[m+4>>2]=c[p+4>>2];c[m+8>>2]=c[p+8>>2]}n=n+1|0}while((n|0)!=(o|0))}m=c[b+16>>2]|0;if(m){if(a[b+20>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[m+ -4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=l;c[b+12>>2]=k;l=c[b+8>>2]|0}else{l=g;k=g}}else{l=j;k=g}c[b+8>>2]=l+1;l=c[b+16>>2]|0;if((g|0)<(k|0)){WD(b);g=(c[b+12>>2]|0)+ -1&h}else g=g+ -1&h;if(!(l+(j*12|0)|0))d=0;else{c[l+(j*12|0)>>2]=d;c[l+(j*12|0)+4>>2]=e;c[l+(j*12|0)+8>>2]=0;d=l+(j*12|0)|0}c[d+8>>2]=0;p=(c[b+40>>2]|0)+(g<<2)|0;c[(c[b+60>>2]|0)+(j<<2)>>2]=c[p>>2];c[p>>2]=j;p=d;i=f;return p|0}function aE(a){a=a|0;return c[a+16>>2]|0}function bE(a,b,c,d,e,f,h,j,k,l,m){a=a|0;b=b|0;c=+c;d=+d;e=+e;f=+f;h=+h;j=+j;k=k|0;l=l|0;m=+m;var n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;p=i;o=+g[a>>2]*f+ +g[a+16>>2]*h+ +g[a+32>>2]*j;n=+g[a+4>>2]*f+ +g[a+20>>2]*h+ +g[a+36>>2]*j;r=+g[a+8>>2]*f+ +g[a+24>>2]*h+ +g[a+40>>2]*j;q=+g[b>>2]*f+ +g[b+16>>2]*h+ +g[b+32>>2]*j;s=+g[b+4>>2]*f+ +g[b+20>>2]*h+ +g[b+36>>2]*j;t=+g[b+8>>2]*f+ +g[b+24>>2]*h+ +g[b+40>>2]*j;u=+g[k+80>>2];if(o<0.0)u=-u;v=+g[k+84>>2];if(n<0.0)v=-v;w=+g[k+88>>2];if(r<0.0)w=-w;x=+g[l+80>>2];if(q<0.0)x=-x;y=+g[l+84>>2];if(s<0.0)y=-y;z=+g[l+88>>2];if(!(t<0.0)){A=z;z=o*u;v=n*v;v=z+v;z=r*w;z=v+z;x=q*x;y=s*y;y=x+y;x=t*A;x=y+x;a=k+96|0;y=+g[a>>2];a=z>y;y=a?z:y;a=l+96|0;z=+g[a>>2];a=x>z;z=a?x:z;z=y+z;y=c*f+d*h+e*j+z;z=z-(c*f+d*h+e*j);a=y<z;z=a?y:z;a=!(z>m);i=p;return a|0}B=-z;A=o*u;z=n*v;z=A+z;A=r*w;A=z+A;x=q*x;z=s*y;z=x+z;y=t*B;y=z+y;a=k+96|0;z=+g[a>>2];a=A>z;z=a?A:z;a=l+96|0;A=+g[a>>2];a=y>A;A=a?y:A;A=z+A;z=c*f+d*h+e*j+A;A=A-(c*f+d*h+e*j);a=z<A;A=a?z:A;a=!(A>m);i=p;return a|0}function cE(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0,I=0,J=0,K=0,L=0,M=0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0,S=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0,Y=0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0,da=0;l=i;i=i+64|0;a[l+48>>0]=1;c[l+44>>2]=0;c[l+36>>2]=0;c[l+40>>2]=0;m=c[f+4>>2]|0;if((m|0)>0){c[5004]=(c[5004]|0)+1;n=fF((m<<4|3)+16|0)|0;if(!n)u=0;else{c[(n+19&-16)+ -4>>2]=n;u=n+19&-16}a[l+48>>0]=1;c[l+44>>2]=u;c[l+40>>2]=m}else u=0;t=c[d+28>>2]|0;if((t|0)>0){n=c[d+36>>2]|0;G=+g[e>>2];N=+g[e+4>>2];O=+g[e+8>>2];E=+g[e+16>>2];D=+g[e+20>>2];C=+g[e+24>>2];B=+g[e+32>>2];A=+g[e+36>>2];z=+g[e+40>>2];V=+g[b>>2];U=+g[b+4>>2];Z=+g[b+8>>2];m=-1;T=3.4028234663852886e+38;v=0;while(1){S=+g[n+(v*36|0)+20>>2];Q=+g[n+(v*36|0)+24>>2];P=+g[n+(v*36|0)+28>>2];s=(S*G+Q*N+P*O)*V+(S*E+Q*D+P*C)*U+(S*B+Q*A+P*z)*Z<T;m=s?v:m;v=v+1|0;if((v|0)>=(t|0))break;else T=s?(S*G+Q*N+P*O)*V+(S*E+Q*D+P*C)*U+(S*B+Q*A+P*z)*Z:T}if((m|0)>=0){v=c[n+(m*36|0)+4>>2]|0;if((v|0)>0){w=n+(m*36|0)+12|0;s=n+(m*36|0)+20|0;u=n+(m*36|0)+24|0;t=n+(m*36|0)+28|0;P=E;Q=D;S=C;T=B;U=A;V=z;y=l+32|0;x=0;while(1){F=c[w>>2]|0;Y=c[F+(x<<2)>>2]|0;M=c[d+16>>2]|0;x=x+1|0;F=c[F+(((x|0)==(v|0)?0:x)<<2)>>2]|0;$=+g[M+(Y<<4)>>2];aa=$- +g[M+(F<<4)>>2];_=+g[M+(Y<<4)+4>>2];ba=_- +g[M+(F<<4)+4>>2];Z=+g[M+(Y<<4)+8>>2];C=Z- +g[M+(F<<4)+8>>2];B=aa*G+ba*N+C*O;A=aa*P+ba*Q+C*S;C=aa*T+ba*U+C*V;ba=+g[s>>2];aa=+g[u>>2];z=+g[t>>2];E=G*ba+N*aa+O*z;D=P*ba+Q*aa+S*z;z=T*ba+U*aa+V*z;G=($*G+_*N+Z*O+ +g[e+48>>2])*-(A*z-C*D)+($*P+_*Q+Z*S+ +g[e+52>>2])*-(C*E-B*z)+($*T+_*U+Z*V+ +g[e+56>>2])*-(B*D-A*E);F=f+4|0;M=c[F>>2]|0;if((M|0)>=2){L=f+12|0;W=c[L>>2]|0;aa=+g[W+(M+ -1<<4)>>2];ba=+g[W+(M+ -1<<4)+4>>2];Z=+g[W+(M+ -1<<4)+8>>2];J=y+4|0;H=y+8|0;K=y+12|0;I=y+16|0;T=aa;U=ba;V=Z;Z=aa*-(A*z-C*D)+ba*-(C*E-B*z)+Z*-(B*D-A*E)-G;R=0;while(1){O=+g[W+(R<<4)>>2];P=+g[W+(R<<4)+4>>2];Q=+g[W+(R<<4)+8>>2];S=+g[W+(R<<4)+12>>2];N=O*-(A*z-C*D)+P*-(C*E-B*z)+Q*-(B*D-A*E)-G;do if(Z<0.0)if(N<0.0){X=c[J>>2]|0;if((X|0)==(c[H>>2]|0)?(r=(X|0)==0?1:X<<1,(X|0)<(r|0)):0){if(!r)W=0;else{c[5004]=(c[5004]|0)+1;W=fF((r<<4|3)+16|0)|0;if(!W)W=0;else{c[(W+19&-16)+ -4>>2]=W;W=W+19&-16}X=c[J>>2]|0}if((X|0)>0){Y=0;do{ca=W+(Y<<4)|0;da=(c[K>>2]|0)+(Y<<4)|0;c[ca+0>>2]=c[da+0>>2];c[ca+4>>2]=c[da+4>>2];c[ca+8>>2]=c[da+8>>2];c[ca+12>>2]=c[da+12>>2];Y=Y+1|0}while((Y|0)!=(X|0))}X=c[K>>2]|0;if(X){if(a[I>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[X+ -4>>2]|0)}c[K>>2]=0}a[I>>0]=1;c[K>>2]=W;c[H>>2]=r;X=c[J>>2]|0}da=c[K>>2]|0;g[da+(X<<4)>>2]=O;g[da+(X<<4)+4>>2]=P;g[da+(X<<4)+8>>2]=Q;g[da+(X<<4)+12>>2]=S;c[J>>2]=(c[J>>2]|0)+1;break}else{ba=Z/(Z-N);S=T+(O-T)*ba;T=U+(P-U)*ba;U=V+(Q-V)*ba;Y=c[J>>2]|0;if((Y|0)==(c[H>>2]|0)?(p=(Y|0)==0?1:Y<<1,(Y|0)<(p|0)):0){if(!p)W=0;else{c[5004]=(c[5004]|0)+1;W=fF((p<<4|3)+16|0)|0;if(!W)W=0;else{c[(W+19&-16)+ -4>>2]=W;W=W+19&-16}Y=c[J>>2]|0}if((Y|0)>0){X=0;do{da=W+(X<<4)|0;ca=(c[K>>2]|0)+(X<<4)|0;c[da+0>>2]=c[ca+0>>2];c[da+4>>2]=c[ca+4>>2];c[da+8>>2]=c[ca+8>>2];c[da+12>>2]=c[ca+12>>2];X=X+1|0}while((X|0)!=(Y|0))}X=c[K>>2]|0;if(X){if(a[I>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[X+ -4>>2]|0)}c[K>>2]=0}a[I>>0]=1;c[K>>2]=W;c[H>>2]=p;Y=c[J>>2]|0}da=c[K>>2]|0;g[da+(Y<<4)>>2]=S;g[da+(Y<<4)+4>>2]=T;g[da+(Y<<4)+8>>2]=U;g[da+(Y<<4)+12>>2]=0.0;c[J>>2]=(c[J>>2]|0)+1;break}else if(N<0.0){ba=Z/(Z-N);T=T+(O-T)*ba;U=U+(P-U)*ba;V=V+(Q-V)*ba;X=c[J>>2]|0;if((X|0)==(c[H>>2]|0)?(o=(X|0)==0?1:X<<1,(X|0)<(o|0)):0){if(!o)W=0;else{c[5004]=(c[5004]|0)+1;W=fF((o<<4|3)+16|0)|0;if(!W)W=0;else{c[(W+19&-16)+ -4>>2]=W;W=W+19&-16}X=c[J>>2]|0}if((X|0)>0){Y=0;do{da=W+(Y<<4)|0;ca=(c[K>>2]|0)+(Y<<4)|0;c[da+0>>2]=c[ca+0>>2];c[da+4>>2]=c[ca+4>>2];c[da+8>>2]=c[ca+8>>2];c[da+12>>2]=c[ca+12>>2];Y=Y+1|0}while((Y|0)!=(X|0))}X=c[K>>2]|0;if(X){if(a[I>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[X+ -4>>2]|0)}c[K>>2]=0}a[I>>0]=1;c[K>>2]=W;c[H>>2]=o;X=c[J>>2]|0}da=c[K>>2]|0;g[da+(X<<4)>>2]=T;g[da+(X<<4)+4>>2]=U;g[da+(X<<4)+8>>2]=V;g[da+(X<<4)+12>>2]=0.0;X=(c[J>>2]|0)+1|0;c[J>>2]=X;if((X|0)==(c[H>>2]|0)?(q=(X|0)==0?1:X<<1,(X|0)<(q|0)):0){if(!q)W=0;else{c[5004]=(c[5004]|0)+1;W=fF((q<<4|3)+16|0)|0;if(!W)W=0;else{c[(W+19&-16)+ -4>>2]=W;W=W+19&-16}X=c[J>>2]|0}if((X|0)>0){Y=0;do{da=W+(Y<<4)|0;ca=(c[K>>2]|0)+(Y<<4)|0;c[da+0>>2]=c[ca+0>>2];c[da+4>>2]=c[ca+4>>2];c[da+8>>2]=c[ca+8>>2];c[da+12>>2]=c[ca+12>>2];Y=Y+1|0}while((Y|0)!=(X|0))}X=c[K>>2]|0;if(X){if(a[I>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[X+ -4>>2]|0)}c[K>>2]=0}a[I>>0]=1;c[K>>2]=W;c[H>>2]=q;X=c[J>>2]|0}da=c[K>>2]|0;g[da+(X<<4)>>2]=O;g[da+(X<<4)+4>>2]=P;g[da+(X<<4)+8>>2]=Q;g[da+(X<<4)+12>>2]=S;c[J>>2]=(c[J>>2]|0)+1}while(0);R=R+1|0;if((R|0)==(M|0))break;W=c[L>>2]|0;T=O;U=P;V=Q;Z=N}M=c[F>>2]|0}if((M|0)<0){K=f+8|0;H=f+12|0;if((c[K>>2]|0)<0){I=c[H>>2]|0;J=f+16|0;if(I){if(a[J>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[I+ -4>>2]|0)}c[H>>2]=0}a[J>>0]=1;c[H>>2]=0;c[K>>2]=0}do{da=(c[H>>2]|0)+(M<<4)|0;c[da+0>>2]=c[l+16>>2];c[da+4>>2]=c[l+20>>2];c[da+8>>2]=c[l+24>>2];c[da+12>>2]=c[l+28>>2];M=M+1|0}while((M|0)!=0)}c[F>>2]=0;G=+g[e>>2];N=+g[e+4>>2];O=+g[e+8>>2];E=+g[e+16>>2];D=+g[e+20>>2];C=+g[e+24>>2];B=+g[e+32>>2];A=+g[e+36>>2];z=+g[e+40>>2];if((x|0)>=(v|0)){f=y;o=e+48|0;d=e+52|0;e=e+56|0;break}else{da=y;P=E;Q=D;S=C;T=B;U=A;V=z;y=f;f=da}}}else{u=n+(m*36|0)+24|0;t=n+(m*36|0)+28|0;o=e+48|0;d=e+52|0;e=e+56|0;s=n+(m*36|0)+20|0}$=+g[s>>2];aa=+g[u>>2];ba=+g[t>>2];G=$*G+aa*N+ba*O;C=$*E+aa*D+ba*C;z=$*B+aa*A+ba*z;A=+g[n+(m*36|0)+32>>2]-(G*+g[o>>2]+C*+g[d>>2]+z*+g[e>>2]);m=f+4|0;d=c[m>>2]|0;if((d|0)>0){n=f+12|0;e=0;do{da=c[n>>2]|0;o=da+(e<<4)|0;B=A+(G*+g[o>>2]+C*+g[da+(e<<4)+4>>2]+z*+g[da+(e<<4)+8>>2]);B=!(B<=h)?B:h;if(B<=j){c[l+0>>2]=c[o+0>>2];c[l+4>>2]=c[o+4>>2];c[l+8>>2]=c[o+8>>2];c[l+12>>2]=c[o+12>>2];qc[c[(c[k>>2]|0)+16>>2]&15](k,b,l,B);d=c[m>>2]|0}e=e+1|0}while((e|0)<(d|0))}u=c[l+44>>2]|0}}if(!u){i=l;return}if(a[l+48>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[u+ -4>>2]|0)}c[l+44>>2]=0;i=l;return}function dE(a,b,f,j){a=a|0;b=b|0;f=f|0;j=j|0;var k=0.0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0,s=0,t=0,u=0,v=0;n=i;i=i+80|0;f=Pb[c[(c[a>>2]|0)+28>>2]&127](a)|0;m=+g[a+4>>2];k=+g[a+8>>2];l=+g[a+12>>2];if((f|0)<=0){i=n;return}j=0;do{fc[c[(c[a>>2]|0)+16>>2]&3](a,n+76|0,n+52|0,n+64|0,n+56|0,n+72|0,n+68|0,n+48|0,n+60|0,j);o=c[n+64>>2]|0;do if(!o){o=c[n+60>>2]|0;if((o|0)==5){if((c[n+48>>2]|0)>0)o=0;else break;do{u=c[n+72>>2]|0;t=aa(c[n+68>>2]|0,o)|0;s=c[n+76>>2]|0;r=c[n+56>>2]|0;v=aa(d[u+t>>0]|0,r)|0;q=k*+g[s+(v+4)>>2];p=l*+g[s+(v+8)>>2];g[n>>2]=m*+g[s+v>>2];g[n+4>>2]=q;g[n+8>>2]=p;g[n+12>>2]=0.0;v=aa(d[u+(t+1)>>0]|0,r)|0;p=k*+g[s+(v+4)>>2];q=l*+g[s+(v+8)>>2];g[n+16>>2]=m*+g[s+v>>2];g[n+20>>2]=p;g[n+24>>2]=q;g[n+28>>2]=0.0;r=aa(d[u+(t+2)>>0]|0,r)|0;q=k*+g[s+(r+4)>>2];p=l*+g[s+(r+8)>>2];g[n+32>>2]=m*+g[s+r>>2];g[n+36>>2]=q;g[n+40>>2]=p;g[n+44>>2]=0.0;vc[c[(c[b>>2]|0)+8>>2]&127](b,n,j,o);o=o+1|0}while((o|0)<(c[n+48>>2]|0))}else if((o|0)==2){if((c[n+48>>2]|0)>0)o=0;else break;do{t=c[n+72>>2]|0;v=aa(c[n+68>>2]|0,o)|0;u=c[n+76>>2]|0;s=c[n+56>>2]|0;r=aa(s,c[t+v>>2]|0)|0;p=k*+g[u+(r+4)>>2];q=l*+g[u+(r+8)>>2];g[n>>2]=m*+g[u+r>>2];g[n+4>>2]=p;g[n+8>>2]=q;g[n+12>>2]=0.0;r=aa(s,c[t+(v+4)>>2]|0)|0;q=k*+g[u+(r+4)>>2];p=l*+g[u+(r+8)>>2];g[n+16>>2]=m*+g[u+r>>2];g[n+20>>2]=q;g[n+24>>2]=p;g[n+28>>2]=0.0;v=aa(s,c[t+(v+8)>>2]|0)|0;p=k*+g[u+(v+4)>>2];q=l*+g[u+(v+8)>>2];g[n+32>>2]=m*+g[u+v>>2];g[n+36>>2]=p;g[n+40>>2]=q;g[n+44>>2]=0.0;vc[c[(c[b>>2]|0)+8>>2]&127](b,n,j,o);o=o+1|0}while((o|0)<(c[n+48>>2]|0))}else if((o|0)==3){if((c[n+48>>2]|0)>0)o=0;else break;do{s=c[n+72>>2]|0;t=aa(c[n+68>>2]|0,o)|0;u=c[n+76>>2]|0;v=c[n+56>>2]|0;r=aa(e[s+t>>1]|0,v)|0;p=k*+g[u+(r+4)>>2];q=l*+g[u+(r+8)>>2];g[n>>2]=m*+g[u+r>>2];g[n+4>>2]=p;g[n+8>>2]=q;g[n+12>>2]=0.0;r=aa(e[s+(t+2)>>1]|0,v)|0;q=k*+g[u+(r+4)>>2];p=l*+g[u+(r+8)>>2];g[n+16>>2]=m*+g[u+r>>2];g[n+20>>2]=q;g[n+24>>2]=p;g[n+28>>2]=0.0;v=aa(e[s+(t+4)>>1]|0,v)|0;p=k*+g[u+(v+4)>>2];q=l*+g[u+(v+8)>>2];g[n+32>>2]=m*+g[u+v>>2];g[n+36>>2]=p;g[n+40>>2]=q;g[n+44>>2]=0.0;vc[c[(c[b>>2]|0)+8>>2]&127](b,n,j,o);o=o+1|0}while((o|0)<(c[n+48>>2]|0))}else break}else if((o|0)==1){o=c[n+60>>2]|0;if((o|0)==3){if((c[n+48>>2]|0)>0)o=0;else break;do{s=c[n+72>>2]|0;t=aa(c[n+68>>2]|0,o)|0;u=c[n+76>>2]|0;v=c[n+56>>2]|0;r=aa(e[s+t>>1]|0,v)|0;p=k*+h[u+(r+8)>>3];q=l*+h[u+(r+16)>>3];g[n>>2]=m*+h[u+r>>3];g[n+4>>2]=p;g[n+8>>2]=q;g[n+12>>2]=0.0;r=aa(e[s+(t+2)>>1]|0,v)|0;q=k*+h[u+(r+8)>>3];p=l*+h[u+(r+16)>>3];g[n+16>>2]=m*+h[u+r>>3];g[n+20>>2]=q;g[n+24>>2]=p;g[n+28>>2]=0.0;v=aa(e[s+(t+4)>>1]|0,v)|0;p=k*+h[u+(v+8)>>3];q=l*+h[u+(v+16)>>3];g[n+32>>2]=m*+h[u+v>>3];g[n+36>>2]=p;g[n+40>>2]=q;g[n+44>>2]=0.0;vc[c[(c[b>>2]|0)+8>>2]&127](b,n,j,o);o=o+1|0}while((o|0)<(c[n+48>>2]|0))}else if((o|0)==2){if((c[n+48>>2]|0)>0)o=0;else break;do{t=c[n+72>>2]|0;v=aa(c[n+68>>2]|0,o)|0;u=c[n+76>>2]|0;s=c[n+56>>2]|0;r=aa(s,c[t+v>>2]|0)|0;p=k*+h[u+(r+8)>>3];q=l*+h[u+(r+16)>>3];g[n>>2]=m*+h[u+r>>3];g[n+4>>2]=p;g[n+8>>2]=q;g[n+12>>2]=0.0;r=aa(s,c[t+(v+4)>>2]|0)|0;q=k*+h[u+(r+8)>>3];p=l*+h[u+(r+16)>>3];g[n+16>>2]=m*+h[u+r>>3];g[n+20>>2]=q;g[n+24>>2]=p;g[n+28>>2]=0.0;v=aa(s,c[t+(v+8)>>2]|0)|0;p=k*+h[u+(v+8)>>3];q=l*+h[u+(v+16)>>3];g[n+32>>2]=m*+h[u+v>>3];g[n+36>>2]=p;g[n+40>>2]=q;g[n+44>>2]=0.0;vc[c[(c[b>>2]|0)+8>>2]&127](b,n,j,o);o=o+1|0}while((o|0)<(c[n+48>>2]|0))}else if((o|0)==5){if((c[n+48>>2]|0)>0)o=0;else break;do{s=c[n+72>>2]|0;t=aa(c[n+68>>2]|0,o)|0;u=c[n+76>>2]|0;v=c[n+56>>2]|0;r=aa(d[s+t>>0]|0,v)|0;p=k*+h[u+(r+8)>>3];q=l*+h[u+(r+16)>>3];g[n>>2]=m*+h[u+r>>3];g[n+4>>2]=p;g[n+8>>2]=q;g[n+12>>2]=0.0;r=aa(d[s+(t+1)>>0]|0,v)|0;q=k*+h[u+(r+8)>>3];p=l*+h[u+(r+16)>>3];g[n+16>>2]=m*+h[u+r>>3];g[n+20>>2]=q;g[n+24>>2]=p;g[n+28>>2]=0.0;v=aa(d[s+(t+2)>>0]|0,v)|0;p=k*+h[u+(v+8)>>3];q=l*+h[u+(v+16)>>3];g[n+32>>2]=m*+h[u+v>>3];g[n+36>>2]=p;g[n+40>>2]=q;g[n+44>>2]=0.0;vc[c[(c[b>>2]|0)+8>>2]&127](b,n,j,o);o=o+1|0}while((o|0)<(c[n+48>>2]|0))}else break}while(0);Nb[c[(c[a>>2]|0)+24>>2]&127](a,j);j=j+1|0}while((j|0)!=(f|0));i=n;return}function eE(d,e,f){d=d|0;e=e|0;f=f|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0;j=i;i=i+32|0;m=Pb[c[(c[d>>2]|0)+28>>2]&127](d)|0;c[e+20>>2]=m;c[e>>2]=0;if(!m){w=e+4|0;v=d+4|0;x=+g[v>>2];g[w>>2]=x;w=d+8|0;x=+g[w>>2];w=e+8|0;g[w>>2]=x;w=d+12|0;x=+g[w>>2];w=e+12|0;g[w>>2]=x;w=d+16|0;x=+g[w>>2];w=e+16|0;g[w>>2]=x;i=j;return 19824}m=Yb[c[(c[f>>2]|0)+16>>2]&31](f,32,m)|0;p=c[m+8>>2]|0;c[e>>2]=gc[c[(c[f>>2]|0)+28>>2]&31](f,p)|0;n=Pb[c[(c[d>>2]|0)+28>>2]&127](d)|0;if((n|0)>0){o=0;while(1){fc[c[(c[d>>2]|0)+16>>2]&3](d,j+28|0,j+4|0,j+16|0,j+8|0,j+24|0,j+20|0,j,j+12|0,o);c[p+24>>2]=c[j>>2];c[p+28>>2]=c[j+4>>2];s=p+8|0;t=p+12|0;r=p+16|0;q=p+4|0;c[p+0>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;c[p+16>>2]=0;c[p+20>>2]=0;u=c[j+12>>2]|0;if((u|0)==2){r=c[j>>2]|0;if(r){r=Yb[c[(c[f>>2]|0)+16>>2]&31](f,4,r*3|0)|0;t=c[r+8>>2]|0;c[s>>2]=gc[c[(c[f>>2]|0)+28>>2]&31](f,t)|0;if((c[j>>2]|0)>0){u=c[j+24>>2]|0;s=0;do{v=aa(c[j+20>>2]|0,s)|0;w=s*3|0;c[t+(w<<2)>>2]=c[u+v>>2];c[t+(w+1<<2)>>2]=c[u+(v+4)>>2];c[t+(w+2<<2)>>2]=c[u+(v+8)>>2];s=s+1|0}while((s|0)<(c[j>>2]|0))}Jb[c[(c[f>>2]|0)+20>>2]&31](f,r,19688,1497453121,c[r+8>>2]|0)}}else if((u|0)==5){s=c[j>>2]|0;if(s){t=Yb[c[(c[f>>2]|0)+16>>2]&31](f,4,s)|0;s=c[t+8>>2]|0;c[r>>2]=gc[c[(c[f>>2]|0)+28>>2]&31](f,s)|0;if((c[j>>2]|0)>0){r=0;do{v=c[j+24>>2]|0;w=aa(c[j+20>>2]|0,r)|0;a[s+(r<<2)>>0]=a[v+w>>0]|0;a[s+(r<<2)+1>>0]=a[v+(w+1)>>0]|0;a[s+(r<<2)+2>>0]=a[v+(w+2)>>0]|0;r=r+1|0}while((r|0)<(c[j>>2]|0))}Jb[c[(c[f>>2]|0)+20>>2]&31](f,t,19736,1497453121,c[t+8>>2]|0)}}else if((u|0)==3?(k=c[j>>2]|0,(k|0)!=0):0){s=Yb[c[(c[f>>2]|0)+16>>2]&31](f,8,k)|0;r=c[s+8>>2]|0;c[t>>2]=gc[c[(c[f>>2]|0)+28>>2]&31](f,r)|0;t=c[j>>2]|0;if((t|0)>0){v=c[j+24>>2]|0;u=c[j+20>>2]|0;w=0;do{y=aa(u,w)|0;b[r+(w<<3)>>1]=b[v+y>>1]|0;b[r+(w<<3)+2>>1]=b[v+(y+2)>>1]|0;b[r+(w<<3)+4>>1]=b[v+(y+4)>>1]|0;w=w+1|0}while((w|0)<(t|0))}Jb[c[(c[f>>2]|0)+20>>2]&31](f,s,19704,1497453121,c[s+8>>2]|0)}r=c[j+16>>2]|0;if(!r){q=c[j+4>>2]|0;if(q){u=Yb[c[(c[f>>2]|0)+16>>2]&31](f,16,q)|0;t=c[u+8>>2]|0;c[p>>2]=gc[c[(c[f>>2]|0)+28>>2]&31](f,t)|0;s=c[j+4>>2]|0;if((s|0)>0){q=c[j+28>>2]|0;r=c[j+8>>2]|0;v=0;do{y=aa(r,v)|0;g[t+(v<<4)>>2]=+g[q+y>>2];g[t+(v<<4)+4>>2]=+g[q+(y+4)>>2];g[t+(v<<4)+8>>2]=+g[q+(y+8)>>2];v=v+1|0}while((v|0)<(s|0))}Jb[c[(c[f>>2]|0)+20>>2]&31](f,u,19760,1497453121,c[u+8>>2]|0)}}else if((r|0)==1?(l=c[j+4>>2]|0,(l|0)!=0):0){r=Yb[c[(c[f>>2]|0)+16>>2]&31](f,32,l)|0;s=c[r+8>>2]|0;c[q>>2]=gc[c[(c[f>>2]|0)+28>>2]&31](f,s)|0;t=c[j+4>>2]|0;if((t|0)>0){q=c[j+28>>2]|0;u=c[j+8>>2]|0;v=0;do{y=aa(u,v)|0;h[s+(v<<5)>>3]=+h[q+y>>3];h[s+(v<<5)+8>>3]=+h[q+(y+8)>>3];h[s+(v<<5)+16>>3]=+h[q+(y+16)>>3];v=v+1|0}while((v|0)<(t|0))}Jb[c[(c[f>>2]|0)+20>>2]&31](f,r,19784,1497453121,c[r+8>>2]|0)}Nb[c[(c[d>>2]|0)+24>>2]&127](d,o);o=o+1|0;if((o|0)==(n|0)){k=f;break}else p=p+32|0}}else k=f;Jb[c[(c[k>>2]|0)+20>>2]&31](f,m,19808,1497453121,c[m+8>>2]|0);y=e+4|0;w=d+4|0;x=+g[w>>2];g[y>>2]=x;y=d+8|0;x=+g[y>>2];y=e+8|0;g[y>>2]=x;y=d+12|0;x=+g[y>>2];y=e+12|0;g[y>>2]=x;y=d+16|0;x=+g[y>>2];y=e+16|0;g[y>>2]=x;i=j;return 19824}function fE(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=19904;e=c[b+32>>2]|0;if(!e){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0}else{if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0}c[5006]=(c[5006]|0)+1;gF(c[b+ -4>>2]|0);i=d;return}function gE(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=19904;e=c[b+32>>2]|0;if(e){if(a[b+36>>0]|0){c[5006]=(c[5006]|0)+1;gF(c[e+ -4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=d;return}function hE(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function iE(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function jE(a){a=a|0;return(c[a+48>>2]|0)==1|0}function kE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[a+52>>2]=c[b+0>>2];c[a+56>>2]=c[b+4>>2];c[a+60>>2]=c[b+8>>2];c[a+64>>2]=c[b+12>>2];c[a+68>>2]=c[d+0>>2];c[a+72>>2]=c[d+4>>2];c[a+76>>2]=c[d+8>>2];c[a+80>>2]=c[d+12>>2];c[a+48>>2]=1;i=e;return}function lE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[b+0>>2]=c[a+52>>2];c[b+4>>2]=c[a+56>>2];c[b+8>>2]=c[a+60>>2];c[b+12>>2]=c[a+64>>2];c[d+0>>2]=c[a+68>>2];c[d+4>>2]=c[a+72>>2];c[d+8>>2]=c[a+76>>2];c[d+12>>2]=c[a+80>>2];i=e;return}function mE(a,b){a=a|0;b=b|0;return}function nE(a,b){a=a|0;b=b|0;return}function oE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;h=i;j=c[g+16>>2]|0;if((j|0)!=(f|0)){l=f-j|0;i=h;return l|0}if(!f){l=0;i=h;return l|0}l=c[g+8>>2]|0;n=c[g+12>>2]|0;k=xF(l|0,0,a|0,0)|0;j=E;p=xF(n|0,0,a|0,0)|0;m=E;l=xF(l|0,0,b|0,0)|0;a=E;n=xF(n|0,0,b|0,0)|0;o=E;b=lF(p|0,0,l|0,0)|0;l=E;o=lF(m|0,0,n|0,o|0)|0;a=lF(o|0,E|0,a|0,0)|0;l=lF(a|0,E|0,l|0,0)|0;a=E;j=lF(0,b|0,k|0,j|0)|0;k=E;b=lF(l|0,a|0,(k>>>0<b>>>0|(k|0)==(b|0)&j>>>0<0)&1|0,0)|0;a=E;l=c[g>>2]|0;o=c[g+4>>2]|0;n=xF(l|0,0,d|0,0)|0;g=E;m=xF(o|0,0,d|0,0)|0;p=E;l=xF(l|0,0,e|0,0)|0;d=E;o=xF(o|0,0,e|0,0)|0;e=E;l=lF(m|0,0,l|0,0)|0;m=E;e=lF(p|0,0,o|0,e|0)|0;e=lF(e|0,E|0,d|0,0)|0;m=lF(e|0,E|0,m|0,0)|0;e=E;g=lF(0,l|0,n|0,g|0)|0;d=E;l=lF(m|0,e|0,(d>>>0<l>>>0|(d|0)==(l|0)&g>>>0<0)&1|0,0)|0;e=E;if(!(a>>>0<e>>>0|(a|0)==(e|0)&b>>>0<l>>>0))if(!(a>>>0>e>>>0|(a|0)==(e|0)&b>>>0>l>>>0))if(k>>>0<d>>>0|(k|0)==(d|0)&j>>>0<g>>>0)a=-1;else a=(k>>>0>d>>>0|(k|0)==(d|0)&j>>>0>g>>>0)&1;else a=1;else a=-1;p=aa(a,f)|0;i=h;return p|0}function pE(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;e=c[a+8>>2]|0;if(!e){g=c[a+4>>2]|0;if(!g){c[5004]=(c[5004]|0)+1;e=fF(31)|0;if((e|0)!=0?(d=e+19&-16,c[d+ -4>>2]=e,(e+19&-16|0)!=0):0){g=c[a+12>>2]|0;c[d+4>>2]=g;c[d+8>>2]=0;c[5004]=(c[5004]|0)+1;d=fF((g*24|3)+16|0)|0;if(!d)d=0;else{c[(d+19&-16)+ -4>>2]=d;d=d+19&-16}c[(e+19&-16)>>2]=d;g=e+19&-16}else g=0;c[g+8>>2]=c[a>>2];c[a>>2]=g}else c[a+4>>2]=c[g+8>>2];f=c[g+4>>2]|0;if((f|0)>0){d=0;e=c[g>>2]|0;do{d=d+1|0;h=e;e=e+24|0;c[h>>2]=(d|0)<(f|0)?e:0}while((d|0)!=(f|0))}e=c[g>>2]|0;c[a+8>>2]=c[e>>2];if(!e){h=0;i=b;return h|0}}else c[a+8>>2]=c[e>>2];c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;h=e;i=b;return h|0}function qE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,F=0,G=0,H=0,I=0,J=0;f=i;i=i+144|0;do if((d-b|0)==1)g=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;else if((d-b|0)==2){g=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;h=c[g+88>>2]|0;d=c[g+200>>2]|0;b=c[g+92>>2]|0;k=c[g+204>>2]|0;if((h|0)==(d|0)){if((b|0)==(k|0))if((c[g+96>>2]|0)==(c[g+208>>2]|0))break;else j=b;else j=k;if((b|0)==(j|0)){J=(c[g+96>>2]|0)>(c[g+208>>2]|0);h=J?g+112|0:g;c[h>>2]=h;c[h+4>>2]=h;c[e>>2]=h;c[e+4>>2]=h;c[e+8>>2]=h;c[e+12>>2]=h;g=J?g:g+112|0}else{k=0;s=9}}else{j=k;k=(b|0)==(k|0);s=9}do if((s|0)==9){b=b-j|0;c[g>>2]=g+112;c[g+4>>2]=g+112;c[g+112>>2]=g;c[g+116>>2]=g;if((h-d|0)>=0?!((h|0)==(d|0)&(b|0)<0):0){c[e>>2]=g+112;c[e+4>>2]=g}else{c[e>>2]=g;c[e+4>>2]=g+112}if((b|0)<0|k&(h-d|0)<0){c[e+8>>2]=g;c[e+12>>2]=g+112;h=g;g=g+112|0;break}else{c[e+8>>2]=g+112;c[e+12>>2]=g;h=g;g=g+112|0;break}}while(0);b=pE(a+48|0)|0;d=pE(a+48|0)|0;c[b+8>>2]=d;c[d+8>>2]=b;c[b+20>>2]=c[a+100>>2];c[d+20>>2]=c[a+100>>2];c[b+12>>2]=g;c[d+12>>2]=h;c[b+16>>2]=0;c[d+16>>2]=0;d=c[a+116>>2]|0;c[a+116>>2]=d+1;if((d|0)>=(c[a+120>>2]|0))c[a+120>>2]=d+1;c[b>>2]=b;c[b+4>>2]=b;c[h+8>>2]=b;J=c[b+8>>2]|0;c[J>>2]=J;c[J+4>>2]=J;c[g+8>>2]=J;i=f;return}else if(!(d-b|0)){c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;i=f;return}else{r=((d-b|0)/2|0)+b|0;u=c[a+92>>2]|0;v=c[u+(r+ -1<<2)>>2]|0;y=c[v+88>>2]|0;x=c[v+92>>2]|0;v=c[v+96>>2]|0;a:do if((r|0)<(d|0)){w=r;while(1){z=c[u+(w<<2)>>2]|0;if((c[z+88>>2]|0)!=(y|0)){t=w;break a}if((c[z+92>>2]|0)!=(x|0)){t=w;break a}t=w+1|0;if((c[z+96>>2]|0)!=(v|0)){t=w;break a}if((t|0)<(d|0))w=t;else break}}else t=r;while(0);qE(a,b,r,e);c[f+96>>2]=0;c[f+100>>2]=0;c[f+104>>2]=0;c[f+108>>2]=0;qE(a,t,d,f+96|0);r=f+100|0;v=c[r>>2]|0;if(!v){i=f;return}if(!(c[e+4>>2]|0)){c[e+0>>2]=c[f+96>>2];c[e+4>>2]=c[f+100>>2];c[e+8>>2]=c[f+104>>2];c[e+12>>2]=c[f+108>>2];i=f;return}c[a+100>>2]=(c[a+100>>2]|0)+ -1;b=c[e+12>>2]|0;d=c[f+104>>2]|0;u=c[b+88>>2]|0;b:do if((u|0)==(c[d+88>>2]|0)?(c[b+92>>2]|0)==(c[d+92>>2]|0):0){t=c[d+4>>2]|0;if((t|0)==(d|0)){e=c[d+8>>2]|0;if(e){d=c[e+12>>2]|0;u=c[d+88>>2]|0}w=c[d+96>>2]|0;t=u+1|0;break}b=c[d>>2]|0;c[t>>2]=b;c[b+4>>2]=t;c:do if((d|0)==(c[f+96>>2]|0)){s=c[b+88>>2]|0;u=c[t+88>>2]|0;do if((s|0)>=(u|0)){if((s|0)==(u|0)?(c[b+92>>2]|0)<(c[t+92>>2]|0):0)break;c[f+96>>2]=t;break c}while(0);c[f+96>>2]=b}while(0);v=c[r>>2]|0;if((d|0)==(v|0)){d=c[b+88>>2]|0;s=c[t+88>>2]|0;do if((d|0)<=(s|0)){if((d|0)==(s|0)?(c[b+92>>2]|0)>(c[t+92>>2]|0):0)break;c[r>>2]=t;v=t;s=45;break b}while(0);c[r>>2]=b;v=b;s=45}else s=45}else s=45;while(0);if((s|0)==45){s=c[f+96>>2]|0;u=0;t=1;w=e+4|0;b=0;d=0;d:while(1){z=c[w>>2]|0;while(1){w=c[z+88>>2]|0;y=aa((c[v+88>>2]|0)-w|0,t)|0;e:do if((y|0)<=0){if((y|0)>=0){A=c[z+92>>2]|0;x=(u|0)!=0;f:do if(x){y=z;while(1){B=c[y>>2]|0;if((B|0)==(z|0)){z=y;break f}if((c[B+88>>2]|0)!=(w|0)){z=y;break f}J=A;A=c[B+92>>2]|0;if((A|0)>(J|0)){z=y;break}else y=B}}else{y=z;while(1){B=c[y+4>>2]|0;if((B|0)==(z|0)){z=y;break f}if((c[B+88>>2]|0)!=(w|0)){z=y;break f}J=A;A=c[B+92>>2]|0;if((A|0)>(J|0)){z=y;break}else y=B}}while(0);y=c[v+92>>2]|0;if(x){x=v;while(1){A=c[x+4>>2]|0;if((A|0)==(v|0))break e;if((c[A+88>>2]|0)!=(w|0))break e;J=y;y=c[A+92>>2]|0;if((y|0)<(J|0))break e;else x=A}}else{x=v;while(1){A=c[x>>2]|0;if((A|0)==(v|0))break e;if((c[A+88>>2]|0)!=(w|0))break e;J=y;y=c[A+92>>2]|0;if((y|0)<(J|0))break e;else x=A}}}w=c[v+92>>2]|0;C=c[z+92>>2]|0;if(!u)while(1){B=c[v>>2]|0;x=(B|0)==(v|0);A=v+88|0;while(1){G=z+88|0;D=w-C|0;if(!x?(p=c[B+88>>2]|0,n=aa(p-(c[A>>2]|0)|0,t)|0,o=c[B+92>>2]|0,j=o-w|0,(j|0)>-1):0){if(!n)break;if((n|0)<0?(aa(j,y)|0)<=(aa(n,D)|0):0)break}F=c[z>>2]|0;if((F|0)==(z|0)){x=v;break e}J=c[F+88>>2]|0;H=aa(J-(c[G>>2]|0)|0,t)|0;G=c[F+92>>2]|0;I=G-C|0;C=y;y=aa((c[A>>2]|0)-J|0,t)|0;if(!((y|0)<0&(I|0)>0)){x=v;break e}if(!H){C=G;z=F;continue}if((H|0)>=0){x=v;break e}if((aa(I,C)|0)>=(aa(H,D)|0)){x=v;break e}else{C=G;z=F}}w=o;y=aa(p-(c[G>>2]|0)|0,t)|0;v=B}else while(1){x=c[v+4>>2]|0;B=(x|0)==(v|0);A=v+88|0;while(1){G=z+88|0;D=w-C|0;if(!B?(m=c[x+88>>2]|0,q=aa(m-(c[A>>2]|0)|0,t)|0,l=c[x+92>>2]|0,k=l-w|0,(k|0)>-1):0){if(!q)break;if((q|0)<0?(aa(k,y)|0)<=(aa(q,D)|0):0)break}F=c[z+4>>2]|0;if((F|0)==(z|0)){x=v;break e}J=c[F+88>>2]|0;G=aa(J-(c[G>>2]|0)|0,t)|0;H=c[F+92>>2]|0;C=H-C|0;I=y;y=aa((c[A>>2]|0)-J|0,t)|0;if(!((y|0)<0&(C|0)>0)){x=v;break e}if(!G){C=H;z=F;continue}if((G|0)>=0){x=v;break e}if((aa(C,I)|0)>=(aa(G,D)|0)){x=v;break e}else{C=H;z=F}}w=l;y=aa(m-(c[G>>2]|0)|0,t)|0;v=x}}else{w=(u|0)!=0;x=c[v+92>>2]|0;C=z;while(1){z=v+88|0;D=C+88|0;B=c[C+92>>2]|0;G=x-B|0;A=c[(w?C:C+4|0)>>2]|0;g:do if((A|0)==(C|0)){B=D;D=G;F=y;A=C}else{F=y;while(1){J=c[A+88>>2]|0;I=aa(J-(c[D>>2]|0)|0,t)|0;H=B;B=c[A+92>>2]|0;H=B-H|0;if((H|0)>=1){B=D;D=G;A=C;break g}if(I){if((I|0)>=0){B=D;D=G;A=C;break g}if((aa(H,F)|0)>(aa(I,G)|0)){B=D;D=G;A=C;break g}}F=aa((c[z>>2]|0)-J|0,t)|0;D=A+88|0;G=x-B|0;C=c[(w?A:A+4|0)>>2]|0;if((C|0)==(A|0)){B=D;D=G;break}else{J=A;A=C;C=J}}}while(0);G=c[(w?v:v+4|0)>>2]|0;if((G|0)==(v|0)){z=A;x=v;break e}y=c[G+88>>2]|0;C=aa(y-(c[z>>2]|0)|0,t)|0;z=x;x=c[G+92>>2]|0;z=x-z|0;y=aa(y-(c[B>>2]|0)|0,t)|0;if(!((y|0)>0&(z|0)<0)){z=A;x=v;break e}if(!C){C=A;v=G;continue}if((C|0)>=0){z=A;x=v;break e}if((aa(z,F)|0)>=(aa(C,D)|0)){z=A;x=v;break}else{C=A;v=G}}}while(0);if(!u){u=1;t=-1;w=e;b=z;v=s;d=x;continue d}u=u+1|0;if((u|0)==2)break d;else v=x}}c[z+4>>2]=x;c[x>>2]=z;c[b>>2]=d;c[d+4>>2]=b;j=c[f+96>>2]|0;if((c[j+88>>2]|0)<(c[(c[e>>2]|0)+88>>2]|0))c[e>>2]=j;j=c[r>>2]|0;if((c[j+88>>2]|0)>=(c[(c[e+4>>2]|0)+88>>2]|0))c[e+4>>2]=j;c[e+12>>2]=c[f+108>>2];k=c[d+88>>2]|0;y=c[b+88>>2]|0;l=c[d+92>>2]|0;e=c[b+92>>2]|0;o=c[d+96>>2]|0;z=c[b+96>>2]|0;t=((l-e|0)<0)<<31>>31;j=0-(k-y)|0;s=iF(0,0,j|0,((j|0)<0)<<31>>31|0)|0;s=xF(o-z|0,((o-z|0)<0)<<31>>31|0,s|0,E|0)|0;r=E;q=xF(o-z|0,((o-z|0)<0)<<31>>31|0,l-e|0,t|0)|0;p=E;x=xF(k-y|0,((k-y|0)<0)<<31>>31|0,j|0,((j|0)<0)<<31>>31|0)|0;m=E;n=xF(l-e|0,t|0,l-e|0,t|0)|0;n=iF(x|0,m|0,n|0,E|0)|0;m=E;x=c[b+8>>2]|0;c[f+140>>2]=0;if(!x)A=0;else{u=iF(0,0,l-e|0,t|0)|0;w=E;A=0;v=x;do{C=c[v+12>>2]|0;F=c[C+88>>2]|0;B=c[C+92>>2]|0;C=c[C+96>>2]|0;H=xF(B-e|0,((B-e|0)<0)<<31>>31|0,j|0,((j|0)<0)<<31>>31|0)|0;J=E;I=xF(F-y|0,((F-y|0)<0)<<31>>31|0,u|0,w|0)|0;do if((H|0)==(I|0)&(J|0)==(E|0)?(I=xF(F-y|0,((F-y|0)<0)<<31>>31|0,s|0,r|0)|0,H=E,J=xF(B-e|0,((B-e|0)<0)<<31>>31|0,q|0,p|0)|0,H=lF(J|0,E|0,I|0,H|0)|0,I=E,J=xF(C-z|0,((C-z|0)<0)<<31>>31|0,n|0,m|0)|0,J=lF(H|0,I|0,J|0,E|0)|0,I=E,(I|0)>0|(I|0)==0&J>>>0>0):0){if(A){D=(c[A+4>>2]|0)==(v|0);if((c[A>>2]|0)==(v|0)){if(!D)break;H=c[A+12>>2]|0;G=c[(c[v+8>>2]|0)+12>>2]|0;J=c[G+88>>2]|0;I=c[G+92>>2]|0;G=c[G+96>>2]|0;D=(c[H+96>>2]|0)-G|0;I=(aa(C-G|0,(c[H+92>>2]|0)-I|0)|0)-(aa(D,B-I|0)|0)|0;B=(aa(D,F-J|0)|0)-(aa(C-G|0,(c[H+88>>2]|0)-J|0)|0)|0;I=xF(I|0,((I|0)<0)<<31>>31|0,l-e|0,t|0)|0;J=E;B=xF(B|0,((B|0)<0)<<31>>31|0,j|0,((j|0)<0)<<31>>31|0)|0;B=lF(I|0,J|0,B|0,E|0)|0;J=E;B=(J|0)>0|(J|0)==0&B>>>0>0?2:1}else B=D&1;if((B|0)!=1)break}c[f+140>>2]=v;A=v}while(0);v=c[v>>2]|0}while((v|0)!=(x|0))}w=c[d+8>>2]|0;c[f+136>>2]=0;if(!w)z=0;else{u=iF(0,0,l-e|0,t|0)|0;v=E;z=0;x=w;do{y=c[x+12>>2]|0;B=c[y+88>>2]|0;C=c[y+92>>2]|0;y=c[y+96>>2]|0;H=xF(C-l|0,((C-l|0)<0)<<31>>31|0,j|0,((j|0)<0)<<31>>31|0)|0;J=E;I=xF(B-k|0,((B-k|0)<0)<<31>>31|0,u|0,v|0)|0;do if((H|0)==(I|0)&(J|0)==(E|0)?(I=xF(B-k|0,((B-k|0)<0)<<31>>31|0,s|0,r|0)|0,H=E,J=xF(C-l|0,((C-l|0)<0)<<31>>31|0,q|0,p|0)|0,H=lF(J|0,E|0,I|0,H|0)|0,I=E,J=xF(y-o|0,((y-o|0)<0)<<31>>31|0,n|0,m|0)|0,J=lF(H|0,I|0,J|0,E|0)|0,I=E,(I|0)>0|(I|0)==0&J>>>0>0):0){if(z){if((c[z>>2]|0)!=(x|0))break;if((c[z+4>>2]|0)==(x|0)?(I=c[z+12>>2]|0,G=c[(c[x+8>>2]|0)+12>>2]|0,J=c[G+88>>2]|0,H=c[G+92>>2]|0,G=c[G+96>>2]|0,F=(c[I+96>>2]|0)-G|0,H=(aa(y-G|0,(c[I+92>>2]|0)-H|0)|0)-(aa(F,C-H|0)|0)|0,J=(aa(F,B-J|0)|0)-(aa(y-G|0,(c[I+88>>2]|0)-J|0)|0)|0,H=xF(H|0,((H|0)<0)<<31>>31|0,l-e|0,t|0)|0,I=E,J=xF(J|0,((J|0)<0)<<31>>31|0,j|0,((j|0)<0)<<31>>31|0)|0,J=lF(H|0,I|0,J|0,E|0)|0,I=E,!((I|0)>0|(I|0)==0&J>>>0>0)):0)break}c[f+136>>2]=x;z=x}while(0);x=c[x>>2]|0}while((x|0)!=(w|0))}if(!((A|0)==0&(z|0)==0)){sE(a,b,d,f+140|0,f+136|0);e=c[f+140>>2]|0;if(e)b=c[e+12>>2]|0;e=c[f+136>>2]|0;if(e)d=c[e+12>>2]|0}w=(c[d+96>>2]|0)+1|0;t=c[d+88>>2]|0}u=c[d+92>>2]|0;s=u;e=b;m=d;j=0;q=0;z=1;n=0;v=0;o=0;x=0;k=0;p=0;while(1){y=e+88|0;G=(c[m+88>>2]|0)-(c[y>>2]|0)|0;J=e+92|0;l=s-(c[J>>2]|0)|0;F=e+96|0;C=(c[m+96>>2]|0)-(c[F>>2]|0)|0;c[f+120>>2]=G;c[f+124>>2]=l;c[f+128>>2]=C;c[f+132>>2]=-1;y=t-(c[y>>2]|0)|0;J=u-(c[J>>2]|0)|0;F=w-(c[F>>2]|0)|0;D=(aa(C,J)|0)-(aa(l,F)|0)|0;F=(aa(G,F)|0)-(aa(C,y)|0)|0;J=(aa(l,y)|0)-(aa(G,J)|0)|0;c[f+72>>2]=D;c[f+76>>2]=((D|0)<0)<<31>>31;c[f+80>>2]=F;c[f+84>>2]=((F|0)<0)<<31>>31;c[f+88>>2]=J;c[f+92>>2]=((J|0)<0)<<31>>31;y=xF(J|0,((J|0)<0)<<31>>31|0,l|0,((l|0)<0)<<31>>31|0)|0;I=E;H=xF(C|0,((C|0)<0)<<31>>31|0,F|0,((F|0)<0)<<31>>31|0)|0;H=iF(y|0,I|0,H|0,E|0)|0;I=E;C=xF(D|0,((D|0)<0)<<31>>31|0,C|0,((C|0)<0)<<31>>31|0)|0;y=E;J=xF(G|0,((G|0)<0)<<31>>31|0,J|0,((J|0)<0)<<31>>31|0)|0;J=iF(C|0,y|0,J|0,E|0)|0;y=E;F=xF(G|0,((G|0)<0)<<31>>31|0,F|0,((F|0)<0)<<31>>31|0)|0;G=E;l=xF(D|0,((D|0)<0)<<31>>31|0,l|0,((l|0)<0)<<31>>31|0)|0;l=iF(F|0,G|0,l|0,E|0)|0;c[f+48>>2]=H;c[f+52>>2]=I;c[f+56>>2]=J;c[f+60>>2]=y;c[f+64>>2]=l;c[f+68>>2]=E;c[f+24>>2]=0;c[f+28>>2]=0;c[f+32>>2]=0;c[f+36>>2]=0;c[f+40>>2]=0;l=rE(a,0,e,f+120|0,f+72|0,f+48|0,f+24|0)|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;y=rE(a,1,m,f+120|0,f+72|0,f+48|0,f)|0;if((y|0)==0&((l|0)!=0^1)){s=138;break}if((y|0)==0|(l|0)!=0^1)r=(l|0)!=0?-1:1;else r=oE(c[f+24>>2]|0,c[f+28>>2]|0,c[f+32>>2]|0,c[f+36>>2]|0,c[f+40>>2]|0,f)|0;do if(!z){if((r|0)>-1){if((c[f+16>>2]|0)>=0){s=150;break}if((c[f+8>>2]|0)==0&(c[f+12>>2]|0)==0){s=157;break}else{s=150;break}}if((c[f+40>>2]|0)<0?(c[f+32>>2]|0)==0&(c[f+36>>2]|0)==0:0){c[f+116>>2]=l;c[f+112>>2]=y;y=l;r=v;v=x;s=179}else s=150}else s=150;while(0);if((s|0)==150){s=pE(a+48|0)|0;z=pE(a+48|0)|0;c[s+8>>2]=z;c[z+8>>2]=s;c[s+20>>2]=c[a+100>>2];c[z+20>>2]=c[a+100>>2];c[s+12>>2]=m;c[z+12>>2]=e;c[s+16>>2]=0;c[z+16>>2]=0;z=c[a+116>>2]|0;c[a+116>>2]=z+1;if((z|0)>=(c[a+120>>2]|0))c[a+120>>2]=z+1;if(!o)n=s;else c[o+4>>2]=s;c[s>>2]=o;z=c[s+8>>2]|0;if(!x)v=z;else c[x>>2]=z;c[z+4>>2]=x;o=s;x=z;s=157}do if((s|0)==157){s=0;c[f+116>>2]=l;c[f+112>>2]=y;if(r)if((r|0)>-1)z=y;else{y=l;r=v;v=x;s=179;break}else{sE(a,e,m,f+116|0,f+112|0);z=c[f+112>>2]|0}if(z){t=(p|0)!=0;if(t?(g=c[p>>2]|0,(g|0)!=(y|0)):0){B=g;do{A=B;B=c[B>>2]|0;w=c[A+8>>2]|0;if((B|0)==(A|0))c[(c[w+12>>2]|0)+8>>2]=0;else{c[B+4>>2]=c[A+4>>2];c[c[A+4>>2]>>2]=B;c[(c[w+12>>2]|0)+8>>2]=B}u=c[w>>2]|0;if((u|0)==(w|0))c[(c[A+12>>2]|0)+8>>2]=0;else{c[u+4>>2]=c[w+4>>2];c[c[w+4>>2]>>2]=u;c[(c[A+12>>2]|0)+8>>2]=u}c[A+0>>2]=0;c[A+4>>2]=0;c[A+8>>2]=0;c[A+12>>2]=0;c[A+16>>2]=0;c[A>>2]=c[a+56>>2];c[a+56>>2]=A;c[w+0>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;c[w+12>>2]=0;c[w+16>>2]=0;c[w>>2]=c[a+56>>2];c[a+56>>2]=w;c[a+116>>2]=(c[a+116>>2]|0)+ -1}while((B|0)!=(y|0))}if(!x){p=z;q=t?q:y}else{if(t){c[p>>2]=v;c[v+4>>2]=p;p=y+4|0}else{p=c[y+4>>2]|0;c[p>>2]=v;c[v+4>>2]=p;p=y+4|0;q=v}c[x>>2]=y;c[p>>2]=x;p=c[f+112>>2]|0;v=0}w=c[m+96>>2]|0;u=c[m+92>>2]|0;t=c[m+88>>2]|0;m=c[p+12>>2]|0;x=0;p=c[p+8>>2]|0}if((r|0)<1){y=c[f+116>>2]|0;r=v;v=x;s=179}else{l=v;r=x}}while(0);if((s|0)==179){s=0;if(!y){l=r;r=v}else{t=(k|0)!=0;if(t?(h=c[k+4>>2]|0,(h|0)!=(l|0)):0){x=h;do{A=x+4|0;u=x;x=c[A>>2]|0;z=c[u>>2]|0;w=c[u+8>>2]|0;if((z|0)==(u|0))c[(c[w+12>>2]|0)+8>>2]=0;else{c[z+4>>2]=x;c[c[A>>2]>>2]=z;c[(c[w+12>>2]|0)+8>>2]=z}z=c[w>>2]|0;if((z|0)==(w|0))c[(c[u+12>>2]|0)+8>>2]=0;else{c[z+4>>2]=c[w+4>>2];c[c[w+4>>2]>>2]=z;c[(c[u+12>>2]|0)+8>>2]=z}c[u+0>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;c[u+12>>2]=0;c[u+16>>2]=0;c[u>>2]=c[a+56>>2];c[a+56>>2]=u;c[w+0>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;c[w+12>>2]=0;c[w+16>>2]=0;c[w>>2]=c[a+56>>2];c[a+56>>2]=w;c[a+116>>2]=(c[a+116>>2]|0)+ -1}while((x|0)!=(l|0))}if(!o)j=t?j:l;else{if(t){c[n>>2]=k;c[k+4>>2]=n;k=l}else{k=c[l>>2]|0;c[n>>2]=k;c[k+4>>2]=n;k=l;j=n}c[k>>2]=o;c[o+4>>2]=l;y=c[f+116>>2]|0;n=0}w=c[e+96>>2]|0;u=c[e+92>>2]|0;t=c[e+88>>2]|0;e=c[y+12>>2]|0;l=r;o=0;r=v;k=c[y+8>>2]|0}}if((e|0)==(b|0)&(m|0)==(d|0))break;s=c[m+92>>2]|0;z=0;v=l;x=r}if((s|0)==138){h=pE(a+48|0)|0;g=pE(a+48|0)|0;c[h+8>>2]=g;c[g+8>>2]=h;c[h+20>>2]=c[a+100>>2];c[g+20>>2]=c[a+100>>2];c[h+12>>2]=m;c[g+12>>2]=e;c[h+16>>2]=0;c[g+16>>2]=0;g=c[a+116>>2]|0;c[a+116>>2]=g+1;if((g|0)>=(c[a+120>>2]|0))c[a+120>>2]=g+1;c[h>>2]=h;c[h+4>>2]=h;c[e+8>>2]=h;J=c[h+8>>2]|0;c[J>>2]=J;c[J+4>>2]=J;c[m+8>>2]=J;i=f;return}if(k){g=k+4|0;e=c[g>>2]|0;if((e|0)!=(j|0))do{s=e+4|0;h=e;e=c[s>>2]|0;m=c[h>>2]|0;b=c[h+8>>2]|0;if((m|0)==(h|0))c[(c[b+12>>2]|0)+8>>2]=0;else{c[m+4>>2]=e;c[c[s>>2]>>2]=m;c[(c[b+12>>2]|0)+8>>2]=m}m=c[b>>2]|0;if((m|0)==(b|0))c[(c[h+12>>2]|0)+8>>2]=0;else{c[m+4>>2]=c[b+4>>2];c[c[b+4>>2]>>2]=m;c[(c[h+12>>2]|0)+8>>2]=m}c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h>>2]=c[a+56>>2];c[a+56>>2]=h;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;c[b>>2]=c[a+56>>2];c[a+56>>2]=b;c[a+116>>2]=(c[a+116>>2]|0)+ -1}while((e|0)!=(j|0));if(o){c[n>>2]=k;c[g>>2]=n;c[j>>2]=o;c[o+4>>2]=j}}else{c[n>>2]=o;c[o+4>>2]=n;c[b+8>>2]=o}if(!p){c[r>>2]=l;c[l+4>>2]=r;c[d+8>>2]=r;i=f;r