"use strict";var THREE={REVISION:"77"};"function"==typeof define&&define.amd?define("three",THREE):"undefined"!=typeof exports&&"undefined"!=typeof module&&(module.exports=THREE),void 0===Number.EPSILON&&(Number.EPSILON=Math.pow(2,-52)),void 0===Math.sign&&(Math.sign=function(e){return 0>e?-1:e>0?1:+e}),void 0===Function.prototype.name&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*(\S*)\s*\(/)[1]}}),void 0===Object.assign&&function(){Object.assign=function(e){if(void 0===e||null===e)throw new TypeError("Cannot convert undefined or null to object");for(var t=Object(e),i=1;i<arguments.length;i++){var r=arguments[i];if(void 0!==r&&null!==r)for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(t[n]=r[n])}return t}}(),Object.assign(THREE,{MOUSE:{LEFT:0,MIDDLE:1,RIGHT:2},CullFaceNone:0,CullFaceBack:1,CullFaceFront:2,CullFaceFrontBack:3,FrontFaceDirectionCW:0,FrontFaceDirectionCCW:1,BasicShadowMap:0,PCFShadowMap:1,PCFSoftShadowMap:2,FrontSide:0,BackSide:1,DoubleSide:2,FlatShading:1,SmoothShading:2,NoColors:0,FaceColors:1,VertexColors:2,NoBlending:0,NormalBlending:1,AdditiveBlending:2,SubtractiveBlending:3,MultiplyBlending:4,CustomBlending:5,AddEquation:100,SubtractEquation:101,ReverseSubtractEquation:102,MinEquation:103,MaxEquation:104,ZeroFactor:200,OneFactor:201,SrcColorFactor:202,OneMinusSrcColorFactor:203,SrcAlphaFactor:204,OneMinusSrcAlphaFactor:205,DstAlphaFactor:206,OneMinusDstAlphaFactor:207,DstColorFactor:208,OneMinusDstColorFactor:209,SrcAlphaSaturateFactor:210,NeverDepth:0,AlwaysDepth:1,LessDepth:2,LessEqualDepth:3,EqualDepth:4,GreaterEqualDepth:5,GreaterDepth:6,NotEqualDepth:7,MultiplyOperation:0,MixOperation:1,AddOperation:2,NoToneMapping:0,LinearToneMapping:1,ReinhardToneMapping:2,Uncharted2ToneMapping:3,CineonToneMapping:4,UVMapping:300,CubeReflectionMapping:301,CubeRefractionMapping:302,EquirectangularReflectionMapping:303,EquirectangularRefractionMapping:304,SphericalReflectionMapping:305,CubeUVReflectionMapping:306,CubeUVRefractionMapping:307,RepeatWrapping:1e3,ClampToEdgeWrapping:1001,MirroredRepeatWrapping:1002,NearestFilter:1003,NearestMipMapNearestFilter:1004,NearestMipMapLinearFilter:1005,LinearFilter:1006,LinearMipMapNearestFilter:1007,LinearMipMapLinearFilter:1008,UnsignedByteType:1009,ByteType:1010,ShortType:1011,UnsignedShortType:1012,IntType:1013,UnsignedIntType:1014,FloatType:1015,HalfFloatType:1025,UnsignedShort4444Type:1016,UnsignedShort5551Type:1017,UnsignedShort565Type:1018,AlphaFormat:1019,RGBFormat:1020,RGBAFormat:1021,LuminanceFormat:1022,LuminanceAlphaFormat:1023,RGBEFormat:THREE.RGBAFormat,DepthFormat:1026,RGB_S3TC_DXT1_Format:2001,RGBA_S3TC_DXT1_Format:2002,RGBA_S3TC_DXT3_Format:2003,RGBA_S3TC_DXT5_Format:2004,RGB_PVRTC_4BPPV1_Format:2100,RGB_PVRTC_2BPPV1_Format:2101,RGBA_PVRTC_4BPPV1_Format:2102,RGBA_PVRTC_2BPPV1_Format:2103,RGB_ETC1_Format:2151,LoopOnce:2200,LoopRepeat:2201,LoopPingPong:2202,InterpolateDiscrete:2300,InterpolateLinear:2301,InterpolateSmooth:2302,ZeroCurvatureEnding:2400,ZeroSlopeEnding:2401,WrapAroundEnding:2402,TrianglesDrawMode:0,TriangleStripDrawMode:1,TriangleFanDrawMode:2,LinearEncoding:3e3,sRGBEncoding:3001,GammaEncoding:3007,RGBEEncoding:3002,LogLuvEncoding:3003,RGBM7Encoding:3004,RGBM16Encoding:3005,RGBDEncoding:3006,BasicDepthPacking:3200,RGBADepthPacking:3201}),THREE.Color=function(e,t,i){return void 0===t&&void 0===i?this.set(e):this.setRGB(e,t,i)},THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,set:function(e){return e instanceof THREE.Color?this.copy(e):"number"==typeof e?this.setHex(e):"string"==typeof e&&this.setStyle(e),this},setScalar:function(e){this.b=this.g=this.r=e},setHex:function(e){return e=Math.floor(e),this.r=(e>>16&255)/255,this.g=(e>>8&255)/255,this.b=(255&e)/255,this},setRGB:function(e,t,i){return this.r=e,this.g=t,this.b=i,this},setHSL:function(){function e(e,t,i){return 0>i&&(i+=1),i>1&&(i-=1),1/6>i?e+6*(t-e)*i:.5>i?t:2/3>i?e+6*(t-e)*(2/3-i):e}return function(t,i,r){return t=THREE.Math.euclideanModulo(t,1),i=THREE.Math.clamp(i,0,1),r=THREE.Math.clamp(r,0,1),0===i?this.r=this.g=this.b=r:(i=.5>=r?r*(1+i):r+i-r*i,r=2*r-i,this.r=e(r,i,t+1/3),this.g=e(r,i,t),this.b=e(r,i,t-1/3)),this}}(),setStyle:function(e){function t(t){void 0!==t&&1>parseFloat(t)&&console.warn("THREE.Color: Alpha component of "+e+" will be ignored.")}var i;if(i=/^((?:rgb|hsl)a?)\(\s*([^\)]*)\)/.exec(e)){var r=i[2];switch(i[1]){case"rgb":case"rgba":if(i=/^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(r))return this.r=Math.min(255,parseInt(i[1],10))/255,this.g=Math.min(255,parseInt(i[2],10))/255,this.b=Math.min(255,parseInt(i[3],10))/255,t(i[5]),this;if(i=/^(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(r))return this.r=Math.min(100,parseInt(i[1],10))/100,this.g=Math.min(100,parseInt(i[2],10))/100,this.b=Math.min(100,parseInt(i[3],10))/100,t(i[5]),this;break;case"hsl":case"hsla":if(i=/^([0-9]*\.?[0-9]+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(r)){var r=parseFloat(i[1])/360,n=parseInt(i[2],10)/100,o=parseInt(i[3],10)/100;return t(i[5]),this.setHSL(r,n,o)}}}else if(i=/^\#([A-Fa-f0-9]+)$/.exec(e)){if(i=i[1],r=i.length,3===r)return this.r=parseInt(i.charAt(0)+i.charAt(0),16)/255,this.g=parseInt(i.charAt(1)+i.charAt(1),16)/255,this.b=parseInt(i.charAt(2)+i.charAt(2),16)/255,this;if(6===r)return this.r=parseInt(i.charAt(0)+i.charAt(1),16)/255,this.g=parseInt(i.charAt(2)+i.charAt(3),16)/255,this.b=parseInt(i.charAt(4)+i.charAt(5),16)/255,this}return e&&0<e.length&&(i=THREE.ColorKeywords[e],void 0!==i?this.setHex(i):console.warn("THREE.Color: Unknown color "+e)),this},clone:function(){return new this.constructor(this.r,this.g,this.b)},copy:function(e){return this.r=e.r,this.g=e.g,this.b=e.b,this},copyGammaToLinear:function(e,t){return void 0===t&&(t=2),this.r=Math.pow(e.r,t),this.g=Math.pow(e.g,t),this.b=Math.pow(e.b,t),this},copyLinearToGamma:function(e,t){void 0===t&&(t=2);var i=t>0?1/t:1;return this.r=Math.pow(e.r,i),this.g=Math.pow(e.g,i),this.b=Math.pow(e.b,i),this},convertGammaToLinear:function(){var e=this.r,t=this.g,i=this.b;return this.r=e*e,this.g=t*t,this.b=i*i,this},convertLinearToGamma:function(){return this.r=Math.sqrt(this.r),this.g=Math.sqrt(this.g),this.b=Math.sqrt(this.b),this},getHex:function(){return 255*this.r<<16^255*this.g<<8^255*this.b<<0},getHexString:function(){return("000000"+this.getHex().toString(16)).slice(-6)},getHSL:function(e){e=e||{h:0,s:0,l:0};var t,i=this.r,r=this.g,n=this.b,o=Math.max(i,r,n),a=Math.min(i,r,n),s=(a+o)/2;if(a===o)a=t=0;else{var c=o-a,a=.5>=s?c/(o+a):c/(2-o-a);switch(o){case i:t=(r-n)/c+(n>r?6:0);break;case r:t=(n-i)/c+2;break;case n:t=(i-r)/c+4}t/=6}return e.h=t,e.s=a,e.l=s,e},getStyle:function(){return"rgb("+(255*this.r|0)+","+(255*this.g|0)+","+(255*this.b|0)+")"},offsetHSL:function(e,t,i){var r=this.getHSL();return r.h+=e,r.s+=t,r.l+=i,this.setHSL(r.h,r.s,r.l),this},add:function(e){return this.r+=e.r,this.g+=e.g,this.b+=e.b,this},addColors:function(e,t){return this.r=e.r+t.r,this.g=e.g+t.g,this.b=e.b+t.b,this},addScalar:function(e){return this.r+=e,this.g+=e,this.b+=e,this},multiply:function(e){return this.r*=e.r,this.g*=e.g,this.b*=e.b,this},multiplyScalar:function(e){return this.r*=e,this.g*=e,this.b*=e,this},lerp:function(e,t){return this.r+=(e.r-this.r)*t,this.g+=(e.g-this.g)*t,this.b+=(e.b-this.b)*t,this},equals:function(e){return e.r===this.r&&e.g===this.g&&e.b===this.b},fromArray:function(e,t){return void 0===t&&(t=0),this.r=e[t],this.g=e[t+1],this.b=e[t+2],this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this.r,e[t+1]=this.g,e[t+2]=this.b,e}},THREE.ColorKeywords={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},THREE.Quaternion=function(e,t,i,r){this._x=e||0,this._y=t||0,this._z=i||0,this._w=void 0!==r?r:1},THREE.Quaternion.prototype={constructor:THREE.Quaternion,get x(){return this._x},set x(e){this._x=e,this.onChangeCallback()},get y(){return this._y},set y(e){this._y=e,this.onChangeCallback()},get z(){return this._z},set z(e){this._z=e,this.onChangeCallback()},get w(){return this._w},set w(e){this._w=e,this.onChangeCallback()},set:function(e,t,i,r){return this._x=e,this._y=t,this._z=i,this._w=r,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._w)},copy:function(e){return this._x=e.x,this._y=e.y,this._z=e.z,this._w=e.w,this.onChangeCallback(),this},setFromEuler:function(e,t){if(!1==e instanceof THREE.Euler)throw Error("THREE.Quaternion: .setFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var i=Math.cos(e._x/2),r=Math.cos(e._y/2),n=Math.cos(e._z/2),o=Math.sin(e._x/2),a=Math.sin(e._y/2),s=Math.sin(e._z/2),c=e.order;return"XYZ"===c?(this._x=o*r*n+i*a*s,this._y=i*a*n-o*r*s,this._z=i*r*s+o*a*n,this._w=i*r*n-o*a*s):"YXZ"===c?(this._x=o*r*n+i*a*s,this._y=i*a*n-o*r*s,this._z=i*r*s-o*a*n,this._w=i*r*n+o*a*s):"ZXY"===c?(this._x=o*r*n-i*a*s,this._y=i*a*n+o*r*s,this._z=i*r*s+o*a*n,this._w=i*r*n-o*a*s):"ZYX"===c?(this._x=o*r*n-i*a*s,this._y=i*a*n+o*r*s,this._z=i*r*s-o*a*n,this._w=i*r*n+o*a*s):"YZX"===c?(this._x=o*r*n+i*a*s,this._y=i*a*n+o*r*s,this._z=i*r*s-o*a*n,this._w=i*r*n-o*a*s):"XZY"===c&&(this._x=o*r*n-i*a*s,this._y=i*a*n-o*r*s,this._z=i*r*s+o*a*n,this._w=i*r*n+o*a*s),!1!==t&&this.onChangeCallback(),this},setFromAxisAngle:function(e,t){var i=t/2,r=Math.sin(i);return this._x=e.x*r,this._y=e.y*r,this._z=e.z*r,this._w=Math.cos(i),this.onChangeCallback(),this},setFromRotationMatrix:function(e){var t=e.elements,i=t[0];e=t[4];var r=t[8],n=t[1],o=t[5],a=t[9],s=t[2],c=t[6],t=t[10],h=i+o+t;return h>0?(i=.5/Math.sqrt(h+1),this._w=.25/i,this._x=(c-a)*i,this._y=(r-s)*i,this._z=(n-e)*i):i>o&&i>t?(i=2*Math.sqrt(1+i-o-t),this._w=(c-a)/i,this._x=.25*i,this._y=(e+n)/i,this._z=(r+s)/i):o>t?(i=2*Math.sqrt(1+o-i-t),this._w=(r-s)/i,this._x=(e+n)/i,this._y=.25*i,this._z=(a+c)/i):(i=2*Math.sqrt(1+t-i-o),this._w=(n-e)/i,this._x=(r+s)/i,this._y=(a+c)/i,this._z=.25*i),this.onChangeCallback(),this},setFromUnitVectors:function(){var e,t;return function(i,r){return void 0===e&&(e=new THREE.Vector3),t=i.dot(r)+1,1e-6>t?(t=0,Math.abs(i.x)>Math.abs(i.z)?e.set(-i.y,i.x,0):e.set(0,-i.z,i.y)):e.crossVectors(i,r),this._x=e.x,this._y=e.y,this._z=e.z,this._w=t,this.normalize()}}(),inverse:function(){return this.conjugate().normalize()},conjugate:function(){return this._x*=-1,this._y*=-1,this._z*=-1,this.onChangeCallback(),this},dot:function(e){return this._x*e._x+this._y*e._y+this._z*e._z+this._w*e._w},lengthSq:function(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w},length:function(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)},normalize:function(){var e=this.length();return 0===e?(this._z=this._y=this._x=0,this._w=1):(e=1/e,this._x*=e,this._y*=e,this._z*=e,this._w*=e),this.onChangeCallback(),this},multiply:function(e,t){return void 0!==t?(console.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead."),this.multiplyQuaternions(e,t)):this.multiplyQuaternions(this,e)},premultiply:function(e){return this.multiplyQuaternions(e,this)},multiplyQuaternions:function(e,t){var i=e._x,r=e._y,n=e._z,o=e._w,a=t._x,s=t._y,c=t._z,h=t._w;return this._x=i*h+o*a+r*c-n*s,this._y=r*h+o*s+n*a-i*c,this._z=n*h+o*c+i*s-r*a,this._w=o*h-i*a-r*s-n*c,this.onChangeCallback(),this},slerp:function(e,t){if(0===t)return this;if(1===t)return this.copy(e);var i=this._x,r=this._y,n=this._z,o=this._w,a=o*e._w+i*e._x+r*e._y+n*e._z;if(0>a?(this._w=-e._w,this._x=-e._x,this._y=-e._y,this._z=-e._z,a=-a):this.copy(e),a>=1)return this._w=o,this._x=i,this._y=r,this._z=n,this;var s=Math.sqrt(1-a*a);if(.001>Math.abs(s))return this._w=.5*(o+this._w),this._x=.5*(i+this._x),this._y=.5*(r+this._y),this._z=.5*(n+this._z),this;var c=Math.atan2(s,a),a=Math.sin((1-t)*c)/s,s=Math.sin(t*c)/s;return this._w=o*a+this._w*s,this._x=i*a+this._x*s,this._y=r*a+this._y*s,this._z=n*a+this._z*s,this.onChangeCallback(),this},equals:function(e){return e._x===this._x&&e._y===this._y&&e._z===this._z&&e._w===this._w},fromArray:function(e,t){return void 0===t&&(t=0),this._x=e[t],this._y=e[t+1],this._z=e[t+2],this._w=e[t+3],this.onChangeCallback(),this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this._x,e[t+1]=this._y,e[t+2]=this._z,e[t+3]=this._w,e},onChange:function(e){return this.onChangeCallback=e,this},onChangeCallback:function(){}},Object.assign(THREE.Quaternion,{slerp:function(e,t,i,r){return i.copy(e).slerp(t,r)},slerpFlat:function(e,t,i,r,n,o,a){var s=i[r+0],c=i[r+1],h=i[r+2];i=i[r+3],r=n[o+0];var l=n[o+1],u=n[o+2];if(n=n[o+3],i!==n||s!==r||c!==l||h!==u){o=1-a;var p=s*r+c*l+h*u+i*n,d=p>=0?1:-1,f=1-p*p;f>Number.EPSILON&&(f=Math.sqrt(f),p=Math.atan2(f,p*d),o=Math.sin(o*p)/f,a=Math.sin(a*p)/f),d*=a,s=s*o+r*d,c=c*o+l*d,h=h*o+u*d,i=i*o+n*d,o===1-a&&(a=1/Math.sqrt(s*s+c*c+h*h+i*i),s*=a,c*=a,h*=a,i*=a)}e[t]=s,e[t+1]=c,e[t+2]=h,e[t+3]=i}}),THREE.Vector2=function(e,t){this.x=e||0,this.y=t||0},THREE.Vector2.prototype={constructor:THREE.Vector2,get width(){return this.x},set width(e){this.x=e},get height(){return this.y},set height(e){this.y=e},set:function(e,t){return this.x=e,this.y=t,this},setScalar:function(e){return this.y=this.x=e,this},setX:function(e){return this.x=e,this},setY:function(e){return this.y=e,this},setComponent:function(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;default:throw Error("index is out of range: "+e)}},getComponent:function(e){switch(e){case 0:return this.x;case 1:return this.y;default:throw Error("index is out of range: "+e)}},clone:function(){return new this.constructor(this.x,this.y)},copy:function(e){return this.x=e.x,this.y=e.y,this},add:function(e,t){return void 0!==t?(console.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(e,t)):(this.x+=e.x,this.y+=e.y,this)},addScalar:function(e){return this.x+=e,this.y+=e,this},addVectors:function(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this},addScaledVector:function(e,t){return this.x+=e.x*t,this.y+=e.y*t,this},sub:function(e,t){return void 0!==t?(console.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(e,t)):(this.x-=e.x,this.y-=e.y,this)},subScalar:function(e){return this.x-=e,this.y-=e,this},subVectors:function(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this},multiply:function(e){return this.x*=e.x,this.y*=e.y,this},multiplyScalar:function(e){return isFinite(e)?(this.x*=e,this.y*=e):this.y=this.x=0,this},divide:function(e){return this.x/=e.x,this.y/=e.y,this},divideScalar:function(e){return this.multiplyScalar(1/e)},min:function(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this},max:function(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this},clamp:function(e,t){return this.x=Math.max(e.x,Math.min(t.x,this.x)),this.y=Math.max(e.y,Math.min(t.y,this.y)),this},clampScalar:function(){var e,t;return function(i,r){return void 0===e&&(e=new THREE.Vector2,t=new THREE.Vector2),e.set(i,i),t.set(r,r),this.clamp(e,t)}}(),clampLength:function(e,t){var i=this.length();return this.multiplyScalar(Math.max(e,Math.min(t,i))/i)},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},roundToZero:function(){return this.x=0>this.x?Math.ceil(this.x):Math.floor(this.x),this.y=0>this.y?Math.ceil(this.y):Math.floor(this.y),this},negate:function(){return this.x=-this.x,this.y=-this.y,this},dot:function(e){return this.x*e.x+this.y*e.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)},normalize:function(){return this.divideScalar(this.length())},angle:function(){var e=Math.atan2(this.y,this.x);return 0>e&&(e+=2*Math.PI),e},distanceTo:function(e){return Math.sqrt(this.distanceToSquared(e))},distanceToSquared:function(e){var t=this.x-e.x;return e=this.y-e.y,t*t+e*e},setLength:function(e){return this.multiplyScalar(e/this.length())},lerp:function(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this},lerpVectors:function(e,t,i){return this.subVectors(t,e).multiplyScalar(i).add(e)},equals:function(e){return e.x===this.x&&e.y===this.y},fromArray:function(e,t){return void 0===t&&(t=0),this.x=e[t],this.y=e[t+1],this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this.x,e[t+1]=this.y,e},fromAttribute:function(e,t,i){return void 0===i&&(i=0),t=t*e.itemSize+i,this.x=e.array[t],this.y=e.array[t+1],this},rotateAround:function(e,t){var i=Math.cos(t),r=Math.sin(t),n=this.x-e.x,o=this.y-e.y;return this.x=n*i-o*r+e.x,this.y=n*r+o*i+e.y,this}},THREE.Vector3=function(e,t,i){this.x=e||0,this.y=t||0,this.z=i||0},THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(e,t,i){return this.x=e,this.y=t,this.z=i,this},setScalar:function(e){return this.z=this.y=this.x=e,this},setX:function(e){return this.x=e,this},setY:function(e){return this.y=e,this},setZ:function(e){return this.z=e,this},setComponent:function(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;case 2:this.z=t;break;default:throw Error("index is out of range: "+e)}},getComponent:function(e){switch(e){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw Error("index is out of range: "+e)}},clone:function(){return new this.constructor(this.x,this.y,this.z)},copy:function(e){return this.x=e.x,this.y=e.y,this.z=e.z,this},add:function(e,t){return void 0!==t?(console.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(e,t)):(this.x+=e.x,this.y+=e.y,this.z+=e.z,this)},addScalar:function(e){return this.x+=e,this.y+=e,this.z+=e,this},addVectors:function(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this.z=e.z+t.z,this},addScaledVector:function(e,t){return this.x+=e.x*t,this.y+=e.y*t,this.z+=e.z*t,this},sub:function(e,t){return void 0!==t?(console.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(e,t)):(this.x-=e.x,this.y-=e.y,this.z-=e.z,this)},subScalar:function(e){return this.x-=e,this.y-=e,this.z-=e,this},subVectors:function(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this.z=e.z-t.z,this},multiply:function(e,t){return void 0!==t?(console.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead."),this.multiplyVectors(e,t)):(this.x*=e.x,this.y*=e.y,this.z*=e.z,this)},multiplyScalar:function(e){return isFinite(e)?(this.x*=e,this.y*=e,this.z*=e):this.z=this.y=this.x=0,this},multiplyVectors:function(e,t){return this.x=e.x*t.x,this.y=e.y*t.y,this.z=e.z*t.z,this},applyEuler:function(){var e;return function(t){return!1==t instanceof THREE.Euler&&console.error("THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order."),void 0===e&&(e=new THREE.Quaternion),this.applyQuaternion(e.setFromEuler(t))}}(),applyAxisAngle:function(){var e;return function(t,i){return void 0===e&&(e=new THREE.Quaternion),this.applyQuaternion(e.setFromAxisAngle(t,i))}}(),applyMatrix3:function(e){var t=this.x,i=this.y,r=this.z;return e=e.elements,this.x=e[0]*t+e[3]*i+e[6]*r,this.y=e[1]*t+e[4]*i+e[7]*r,this.z=e[2]*t+e[5]*i+e[8]*r,this},applyMatrix4:function(e){var t=this.x,i=this.y,r=this.z;return e=e.elements,this.x=e[0]*t+e[4]*i+e[8]*r+e[12],this.y=e[1]*t+e[5]*i+e[9]*r+e[13],this.z=e[2]*t+e[6]*i+e[10]*r+e[14],this},applyProjection:function(e){var t=this.x,i=this.y,r=this.z;e=e.elements;var n=1/(e[3]*t+e[7]*i+e[11]*r+e[15]);return this.x=(e[0]*t+e[4]*i+e[8]*r+e[12])*n,this.y=(e[1]*t+e[5]*i+e[9]*r+e[13])*n,this.z=(e[2]*t+e[6]*i+e[10]*r+e[14])*n,this},applyQuaternion:function(e){var t=this.x,i=this.y,r=this.z,n=e.x,o=e.y,a=e.z;e=e.w;var s=e*t+o*r-a*i,c=e*i+a*t-n*r,h=e*r+n*i-o*t,t=-n*t-o*i-a*r;return this.x=s*e+t*-n+c*-a-h*-o,this.y=c*e+t*-o+h*-n-s*-a,this.z=h*e+t*-a+s*-o-c*-n,this},project:function(){var e;return function(t){return void 0===e&&(e=new THREE.Matrix4),e.multiplyMatrices(t.projectionMatrix,e.getInverse(t.matrixWorld)),this.applyProjection(e)}}(),unproject:function(){var e;return function(t){return void 0===e&&(e=new THREE.Matrix4),e.multiplyMatrices(t.matrixWorld,e.getInverse(t.projectionMatrix)),this.applyProjection(e)}}(),transformDirection:function(e){var t=this.x,i=this.y,r=this.z;return e=e.elements,this.x=e[0]*t+e[4]*i+e[8]*r,this.y=e[1]*t+e[5]*i+e[9]*r,this.z=e[2]*t+e[6]*i+e[10]*r,this.normalize()},divide:function(e){return this.x/=e.x,this.y/=e.y,this.z/=e.z,this},divideScalar:function(e){return this.multiplyScalar(1/e)},min:function(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this.z=Math.min(this.z,e.z),this},max:function(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this.z=Math.max(this.z,e.z),this},clamp:function(e,t){return this.x=Math.max(e.x,Math.min(t.x,this.x)),this.y=Math.max(e.y,Math.min(t.y,this.y)),this.z=Math.max(e.z,Math.min(t.z,this.z)),this},clampScalar:function(){var e,t;return function(i,r){return void 0===e&&(e=new THREE.Vector3,t=new THREE.Vector3),e.set(i,i,i),t.set(r,r,r),this.clamp(e,t)}}(),clampLength:function(e,t){var i=this.length();return this.multiplyScalar(Math.max(e,Math.min(t,i))/i)},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this},roundToZero:function(){return this.x=0>this.x?Math.ceil(this.x):Math.floor(this.x),this.y=0>this.y?Math.ceil(this.y):Math.floor(this.y),this.z=0>this.z?Math.ceil(this.z):Math.floor(this.z),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this},dot:function(e){return this.x*e.x+this.y*e.y+this.z*e.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},setLength:function(e){return this.multiplyScalar(e/this.length())},lerp:function(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this.z+=(e.z-this.z)*t,this},lerpVectors:function(e,t,i){return this.subVectors(t,e).multiplyScalar(i).add(e)},cross:function(e,t){if(void 0!==t)return console.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead."),this.crossVectors(e,t);var i=this.x,r=this.y,n=this.z;return this.x=r*e.z-n*e.y,this.y=n*e.x-i*e.z,this.z=i*e.y-r*e.x,this},crossVectors:function(e,t){var i=e.x,r=e.y,n=e.z,o=t.x,a=t.y,s=t.z;return this.x=r*s-n*a,this.y=n*o-i*s,this.z=i*a-r*o,this},projectOnVector:function(){var e,t;return function(i){return void 0===e&&(e=new THREE.Vector3),e.copy(i).normalize(),t=this.dot(e),this.copy(e).multiplyScalar(t)}}(),projectOnPlane:function(){var e;return function(t){return void 0===e&&(e=new THREE.Vector3),e.copy(this).projectOnVector(t),this.sub(e)}}(),reflect:function(){var e;return function(t){return void 0===e&&(e=new THREE.Vector3),this.sub(e.copy(t).multiplyScalar(2*this.dot(t)))}}(),angleTo:function(e){return e=this.dot(e)/Math.sqrt(this.lengthSq()*e.lengthSq()),Math.acos(THREE.Math.clamp(e,-1,1))},distanceTo:function(e){return Math.sqrt(this.distanceToSquared(e))},distanceToSquared:function(e){var t=this.x-e.x,i=this.y-e.y;return e=this.z-e.z,t*t+i*i+e*e},setFromSpherical:function(e){var t=Math.sin(e.phi)*e.radius;return this.x=t*Math.sin(e.theta),this.y=Math.cos(e.phi)*e.radius,this.z=t*Math.cos(e.theta),this},setFromMatrixPosition:function(e){return this.setFromMatrixColumn(e,3)},setFromMatrixScale:function(e){var t=this.setFromMatrixColumn(e,0).length(),i=this.setFromMatrixColumn(e,1).length();return e=this.setFromMatrixColumn(e,2).length(),this.x=t,this.y=i,this.z=e,this},setFromMatrixColumn:function(e,t){if("number"==typeof e){console.warn("THREE.Vector3: setFromMatrixColumn now expects ( matrix, index ).");var i=e;e=t,t=i}return this.fromArray(e.elements,4*t)},equals:function(e){return e.x===this.x&&e.y===this.y&&e.z===this.z},fromArray:function(e,t){return void 0===t&&(t=0),this.x=e[t],this.y=e[t+1],this.z=e[t+2],this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,e},fromAttribute:function(e,t,i){return void 0===i&&(i=0),t=t*e.itemSize+i,this.x=e.array[t],this.y=e.array[t+1],this.z=e.array[t+2],this}},THREE.Vector4=function(e,t,i,r){this.x=e||0,this.y=t||0,this.z=i||0,this.w=void 0!==r?r:1},THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(e,t,i,r){return this.x=e,this.y=t,this.z=i,this.w=r,this},setScalar:function(e){return this.w=this.z=this.y=this.x=e,this},setX:function(e){return this.x=e,this},setY:function(e){return this.y=e,this},setZ:function(e){return this.z=e,this},setW:function(e){return this.w=e,this},setComponent:function(e,t){switch(e){case 0:this.x=t;break;case 1:this.y=t;break;case 2:this.z=t;break;case 3:this.w=t;break;default:throw Error("index is out of range: "+e)}},getComponent:function(e){switch(e){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw Error("index is out of range: "+e)}},clone:function(){return new this.constructor(this.x,this.y,this.z,this.w)},copy:function(e){return this.x=e.x,this.y=e.y,this.z=e.z,this.w=void 0!==e.w?e.w:1,this},add:function(e,t){return void 0!==t?(console.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(e,t)):(this.x+=e.x,this.y+=e.y,this.z+=e.z,this.w+=e.w,this)},addScalar:function(e){return this.x+=e,this.y+=e,this.z+=e,this.w+=e,this},addVectors:function(e,t){return this.x=e.x+t.x,this.y=e.y+t.y,this.z=e.z+t.z,this.w=e.w+t.w,this},addScaledVector:function(e,t){return this.x+=e.x*t,this.y+=e.y*t,this.z+=e.z*t,this.w+=e.w*t,this},sub:function(e,t){return void 0!==t?(console.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(e,t)):(this.x-=e.x,this.y-=e.y,this.z-=e.z,this.w-=e.w,this)},subScalar:function(e){return this.x-=e,this.y-=e,this.z-=e,this.w-=e,this},subVectors:function(e,t){return this.x=e.x-t.x,this.y=e.y-t.y,this.z=e.z-t.z,this.w=e.w-t.w,this},multiplyScalar:function(e){return isFinite(e)?(this.x*=e,this.y*=e,this.z*=e,this.w*=e):this.w=this.z=this.y=this.x=0,this},applyMatrix4:function(e){var t=this.x,i=this.y,r=this.z,n=this.w;return e=e.elements,this.x=e[0]*t+e[4]*i+e[8]*r+e[12]*n,this.y=e[1]*t+e[5]*i+e[9]*r+e[13]*n,this.z=e[2]*t+e[6]*i+e[10]*r+e[14]*n,this.w=e[3]*t+e[7]*i+e[11]*r+e[15]*n,this},divideScalar:function(e){return this.multiplyScalar(1/e)},setAxisAngleFromQuaternion:function(e){this.w=2*Math.acos(e.w);var t=Math.sqrt(1-e.w*e.w);return 1e-4>t?(this.x=1,this.z=this.y=0):(this.x=e.x/t,this.y=e.y/t,this.z=e.z/t),this},setAxisAngleFromRotationMatrix:function(e){var t,i,r;e=e.elements;var n=e[0];r=e[4];var o=e[8],a=e[1],s=e[5],c=e[9];i=e[2],t=e[6];var h=e[10];return.01>Math.abs(r-a)&&.01>Math.abs(o-i)&&.01>Math.abs(c-t)?.1>Math.abs(r+a)&&.1>Math.abs(o+i)&&.1>Math.abs(c+t)&&.1>Math.abs(n+s+h-3)?(this.set(1,0,0,0),this):(e=Math.PI,n=(n+1)/2,s=(s+1)/2,h=(h+1)/2,r=(r+a)/4,o=(o+i)/4,c=(c+t)/4,n>s&&n>h?.01>n?(t=0,r=i=.707106781):(t=Math.sqrt(n),i=r/t,r=o/t):s>h?.01>s?(t=.707106781,i=0,r=.707106781):(i=Math.sqrt(s),t=r/i,r=c/i):.01>h?(i=t=.707106781,r=0):(r=Math.sqrt(h),t=o/r,i=c/r),this.set(t,i,r,e),this):(e=Math.sqrt((t-c)*(t-c)+(o-i)*(o-i)+(a-r)*(a-r)),.001>Math.abs(e)&&(e=1),this.x=(t-c)/e,this.y=(o-i)/e,this.z=(a-r)/e,this.w=Math.acos((n+s+h-1)/2),this)},min:function(e){return this.x=Math.min(this.x,e.x),this.y=Math.min(this.y,e.y),this.z=Math.min(this.z,e.z),this.w=Math.min(this.w,e.w),this},max:function(e){return this.x=Math.max(this.x,e.x),this.y=Math.max(this.y,e.y),this.z=Math.max(this.z,e.z),this.w=Math.max(this.w,e.w),this},clamp:function(e,t){return this.x=Math.max(e.x,Math.min(t.x,this.x)),this.y=Math.max(e.y,Math.min(t.y,this.y)),this.z=Math.max(e.z,Math.min(t.z,this.z)),this.w=Math.max(e.w,Math.min(t.w,this.w)),this},clampScalar:function(){var e,t;return function(i,r){return void 0===e&&(e=new THREE.Vector4,t=new THREE.Vector4),e.set(i,i,i,i),t.set(r,r,r,r),this.clamp(e,t)}}(),floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this},roundToZero:function(){return this.x=0>this.x?Math.ceil(this.x):Math.floor(this.x),this.y=0>this.y?Math.ceil(this.y):Math.floor(this.y),this.z=0>this.z?Math.ceil(this.z):Math.floor(this.z),this.w=0>this.w?Math.ceil(this.w):Math.floor(this.w),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this},
dot:function(e){return this.x*e.x+this.y*e.y+this.z*e.z+this.w*e.w},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)},normalize:function(){return this.divideScalar(this.length())},setLength:function(e){return this.multiplyScalar(e/this.length())},lerp:function(e,t){return this.x+=(e.x-this.x)*t,this.y+=(e.y-this.y)*t,this.z+=(e.z-this.z)*t,this.w+=(e.w-this.w)*t,this},lerpVectors:function(e,t,i){return this.subVectors(t,e).multiplyScalar(i).add(e)},equals:function(e){return e.x===this.x&&e.y===this.y&&e.z===this.z&&e.w===this.w},fromArray:function(e,t){return void 0===t&&(t=0),this.x=e[t],this.y=e[t+1],this.z=e[t+2],this.w=e[t+3],this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this.x,e[t+1]=this.y,e[t+2]=this.z,e[t+3]=this.w,e},fromAttribute:function(e,t,i){return void 0===i&&(i=0),t=t*e.itemSize+i,this.x=e.array[t],this.y=e.array[t+1],this.z=e.array[t+2],this.w=e.array[t+3],this}},THREE.Euler=function(e,t,i,r){this._x=e||0,this._y=t||0,this._z=i||0,this._order=r||THREE.Euler.DefaultOrder},THREE.Euler.RotationOrders="XYZ YZX ZXY XZY YXZ ZYX".split(" "),THREE.Euler.DefaultOrder="XYZ",THREE.Euler.prototype={constructor:THREE.Euler,get x(){return this._x},set x(e){this._x=e,this.onChangeCallback()},get y(){return this._y},set y(e){this._y=e,this.onChangeCallback()},get z(){return this._z},set z(e){this._z=e,this.onChangeCallback()},get order(){return this._order},set order(e){this._order=e,this.onChangeCallback()},set:function(e,t,i,r){return this._x=e,this._y=t,this._z=i,this._order=r||this._order,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._order)},copy:function(e){return this._x=e._x,this._y=e._y,this._z=e._z,this._order=e._order,this.onChangeCallback(),this},setFromRotationMatrix:function(e,t,i){var r=THREE.Math.clamp,n=e.elements;e=n[0];var o=n[4],a=n[8],s=n[1],c=n[5],h=n[9],l=n[2],u=n[6],n=n[10];return t=t||this._order,"XYZ"===t?(this._y=Math.asin(r(a,-1,1)),.99999>Math.abs(a)?(this._x=Math.atan2(-h,n),this._z=Math.atan2(-o,e)):(this._x=Math.atan2(u,c),this._z=0)):"YXZ"===t?(this._x=Math.asin(-r(h,-1,1)),.99999>Math.abs(h)?(this._y=Math.atan2(a,n),this._z=Math.atan2(s,c)):(this._y=Math.atan2(-l,e),this._z=0)):"ZXY"===t?(this._x=Math.asin(r(u,-1,1)),.99999>Math.abs(u)?(this._y=Math.atan2(-l,n),this._z=Math.atan2(-o,c)):(this._y=0,this._z=Math.atan2(s,e))):"ZYX"===t?(this._y=Math.asin(-r(l,-1,1)),.99999>Math.abs(l)?(this._x=Math.atan2(u,n),this._z=Math.atan2(s,e)):(this._x=0,this._z=Math.atan2(-o,c))):"YZX"===t?(this._z=Math.asin(r(s,-1,1)),.99999>Math.abs(s)?(this._x=Math.atan2(-h,c),this._y=Math.atan2(-l,e)):(this._x=0,this._y=Math.atan2(a,n))):"XZY"===t?(this._z=Math.asin(-r(o,-1,1)),.99999>Math.abs(o)?(this._x=Math.atan2(u,c),this._y=Math.atan2(a,e)):(this._x=Math.atan2(-h,n),this._y=0)):console.warn("THREE.Euler: .setFromRotationMatrix() given unsupported order: "+t),this._order=t,!1!==i&&this.onChangeCallback(),this},setFromQuaternion:function(){var e;return function(t,i,r){return void 0===e&&(e=new THREE.Matrix4),e.makeRotationFromQuaternion(t),this.setFromRotationMatrix(e,i,r)}}(),setFromVector3:function(e,t){return this.set(e.x,e.y,e.z,t||this._order)},reorder:function(){var e=new THREE.Quaternion;return function(t){return e.setFromEuler(this),this.setFromQuaternion(e,t)}}(),equals:function(e){return e._x===this._x&&e._y===this._y&&e._z===this._z&&e._order===this._order},fromArray:function(e){return this._x=e[0],this._y=e[1],this._z=e[2],void 0!==e[3]&&(this._order=e[3]),this.onChangeCallback(),this},toArray:function(e,t){return void 0===e&&(e=[]),void 0===t&&(t=0),e[t]=this._x,e[t+1]=this._y,e[t+2]=this._z,e[t+3]=this._order,e},toVector3:function(e){return e?e.set(this._x,this._y,this._z):new THREE.Vector3(this._x,this._y,this._z)},onChange:function(e){return this.onChangeCallback=e,this},onChangeCallback:function(){}},THREE.Line3=function(e,t){this.start=void 0!==e?e:new THREE.Vector3,this.end=void 0!==t?t:new THREE.Vector3},THREE.Line3.prototype={constructor:THREE.Line3,set:function(e,t){return this.start.copy(e),this.end.copy(t),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.start.copy(e.start),this.end.copy(e.end),this},center:function(e){return(e||new THREE.Vector3).addVectors(this.start,this.end).multiplyScalar(.5)},delta:function(e){return(e||new THREE.Vector3).subVectors(this.end,this.start)},distanceSq:function(){return this.start.distanceToSquared(this.end)},distance:function(){return this.start.distanceTo(this.end)},at:function(e,t){var i=t||new THREE.Vector3;return this.delta(i).multiplyScalar(e).add(this.start)},closestPointToPointParameter:function(){var e=new THREE.Vector3,t=new THREE.Vector3;return function(i,r){e.subVectors(i,this.start),t.subVectors(this.end,this.start);var n=t.dot(t),n=t.dot(e)/n;return r&&(n=THREE.Math.clamp(n,0,1)),n}}(),closestPointToPoint:function(e,t,i){return e=this.closestPointToPointParameter(e,t),i=i||new THREE.Vector3,this.delta(i).multiplyScalar(e).add(this.start)},applyMatrix4:function(e){return this.start.applyMatrix4(e),this.end.applyMatrix4(e),this},equals:function(e){return e.start.equals(this.start)&&e.end.equals(this.end)}},THREE.Box2=function(e,t){this.min=void 0!==e?e:new THREE.Vector2(1/0,1/0),this.max=void 0!==t?t:new THREE.Vector2(-(1/0),-(1/0))},THREE.Box2.prototype={constructor:THREE.Box2,set:function(e,t){return this.min.copy(e),this.max.copy(t),this},setFromPoints:function(e){this.makeEmpty();for(var t=0,i=e.length;i>t;t++)this.expandByPoint(e[t]);return this},setFromCenterAndSize:function(){var e=new THREE.Vector2;return function(t,i){var r=e.copy(i).multiplyScalar(.5);return this.min.copy(t).sub(r),this.max.copy(t).add(r),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.min.copy(e.min),this.max.copy(e.max),this},makeEmpty:function(){return this.min.x=this.min.y=1/0,this.max.x=this.max.y=-(1/0),this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y},center:function(e){return(e||new THREE.Vector2).addVectors(this.min,this.max).multiplyScalar(.5)},size:function(e){return(e||new THREE.Vector2).subVectors(this.max,this.min)},expandByPoint:function(e){return this.min.min(e),this.max.max(e),this},expandByVector:function(e){return this.min.sub(e),this.max.add(e),this},expandByScalar:function(e){return this.min.addScalar(-e),this.max.addScalar(e),this},containsPoint:function(e){return!(e.x<this.min.x||e.x>this.max.x||e.y<this.min.y||e.y>this.max.y)},containsBox:function(e){return this.min.x<=e.min.x&&e.max.x<=this.max.x&&this.min.y<=e.min.y&&e.max.y<=this.max.y},getParameter:function(e,t){return(t||new THREE.Vector2).set((e.x-this.min.x)/(this.max.x-this.min.x),(e.y-this.min.y)/(this.max.y-this.min.y))},intersectsBox:function(e){return!(e.max.x<this.min.x||e.min.x>this.max.x||e.max.y<this.min.y||e.min.y>this.max.y)},clampPoint:function(e,t){return(t||new THREE.Vector2).copy(e).clamp(this.min,this.max)},distanceToPoint:function(){var e=new THREE.Vector2;return function(t){return e.copy(t).clamp(this.min,this.max).sub(t).length()}}(),intersect:function(e){return this.min.max(e.min),this.max.min(e.max),this},union:function(e){return this.min.min(e.min),this.max.max(e.max),this},translate:function(e){return this.min.add(e),this.max.add(e),this},equals:function(e){return e.min.equals(this.min)&&e.max.equals(this.max)}},THREE.Box3=function(e,t){this.min=void 0!==e?e:new THREE.Vector3(1/0,1/0,1/0),this.max=void 0!==t?t:new THREE.Vector3(-(1/0),-(1/0),-(1/0))},THREE.Box3.prototype={constructor:THREE.Box3,set:function(e,t){return this.min.copy(e),this.max.copy(t),this},setFromArray:function(e){for(var t=1/0,i=1/0,r=1/0,n=-(1/0),o=-(1/0),a=-(1/0),s=0,c=e.length;c>s;s+=3){var h=e[s],l=e[s+1],u=e[s+2];t>h&&(t=h),i>l&&(i=l),r>u&&(r=u),h>n&&(n=h),l>o&&(o=l),u>a&&(a=u)}this.min.set(t,i,r),this.max.set(n,o,a)},setFromPoints:function(e){this.makeEmpty();for(var t=0,i=e.length;i>t;t++)this.expandByPoint(e[t]);return this},setFromCenterAndSize:function(){var e=new THREE.Vector3;return function(t,i){var r=e.copy(i).multiplyScalar(.5);return this.min.copy(t).sub(r),this.max.copy(t).add(r),this}}(),setFromObject:function(){var e=new THREE.Vector3;return function(t){var i=this;return t.updateMatrixWorld(!0),this.makeEmpty(),t.traverse(function(t){var r=t.geometry;if(void 0!==r)if(r instanceof THREE.Geometry)for(var n=r.vertices,r=0,o=n.length;o>r;r++)e.copy(n[r]),e.applyMatrix4(t.matrixWorld),i.expandByPoint(e);else if(r instanceof THREE.BufferGeometry&&void 0!==r.attributes.position)for(n=r.attributes.position.array,r=0,o=n.length;o>r;r+=3)e.fromArray(n,r),e.applyMatrix4(t.matrixWorld),i.expandByPoint(e)}),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.min.copy(e.min),this.max.copy(e.max),this},makeEmpty:function(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-(1/0),this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z},center:function(e){return(e||new THREE.Vector3).addVectors(this.min,this.max).multiplyScalar(.5)},size:function(e){return(e||new THREE.Vector3).subVectors(this.max,this.min)},expandByPoint:function(e){return this.min.min(e),this.max.max(e),this},expandByVector:function(e){return this.min.sub(e),this.max.add(e),this},expandByScalar:function(e){return this.min.addScalar(-e),this.max.addScalar(e),this},containsPoint:function(e){return!(e.x<this.min.x||e.x>this.max.x||e.y<this.min.y||e.y>this.max.y||e.z<this.min.z||e.z>this.max.z)},containsBox:function(e){return this.min.x<=e.min.x&&e.max.x<=this.max.x&&this.min.y<=e.min.y&&e.max.y<=this.max.y&&this.min.z<=e.min.z&&e.max.z<=this.max.z},getParameter:function(e,t){return(t||new THREE.Vector3).set((e.x-this.min.x)/(this.max.x-this.min.x),(e.y-this.min.y)/(this.max.y-this.min.y),(e.z-this.min.z)/(this.max.z-this.min.z))},intersectsBox:function(e){return!(e.max.x<this.min.x||e.min.x>this.max.x||e.max.y<this.min.y||e.min.y>this.max.y||e.max.z<this.min.z||e.min.z>this.max.z)},intersectsSphere:function(){var e;return function(t){return void 0===e&&(e=new THREE.Vector3),this.clampPoint(t.center,e),e.distanceToSquared(t.center)<=t.radius*t.radius}}(),intersectsPlane:function(e){var t,i;return 0<e.normal.x?(t=e.normal.x*this.min.x,i=e.normal.x*this.max.x):(t=e.normal.x*this.max.x,i=e.normal.x*this.min.x),0<e.normal.y?(t+=e.normal.y*this.min.y,i+=e.normal.y*this.max.y):(t+=e.normal.y*this.max.y,i+=e.normal.y*this.min.y),0<e.normal.z?(t+=e.normal.z*this.min.z,i+=e.normal.z*this.max.z):(t+=e.normal.z*this.max.z,i+=e.normal.z*this.min.z),t<=e.constant&&i>=e.constant},clampPoint:function(e,t){return(t||new THREE.Vector3).copy(e).clamp(this.min,this.max)},distanceToPoint:function(){var e=new THREE.Vector3;return function(t){return e.copy(t).clamp(this.min,this.max).sub(t).length()}}(),getBoundingSphere:function(){var e=new THREE.Vector3;return function(t){return t=t||new THREE.Sphere,t.center=this.center(),t.radius=.5*this.size(e).length(),t}}(),intersect:function(e){return this.min.max(e.min),this.max.min(e.max),this.isEmpty()&&this.makeEmpty(),this},union:function(e){return this.min.min(e.min),this.max.max(e.max),this},applyMatrix4:function(){var e=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];return function(t){return this.isEmpty()?this:(e[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(t),e[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(t),e[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(t),e[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(t),e[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(t),e[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(t),e[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(t),e[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(t),this.setFromPoints(e),this)}}(),translate:function(e){return this.min.add(e),this.max.add(e),this},equals:function(e){return e.min.equals(this.min)&&e.max.equals(this.max)}},THREE.Matrix3=function(){this.elements=new Float32Array([1,0,0,0,1,0,0,0,1]),0<arguments.length&&console.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")},THREE.Matrix3.prototype={constructor:THREE.Matrix3,set:function(e,t,i,r,n,o,a,s,c){var h=this.elements;return h[0]=e,h[1]=r,h[2]=a,h[3]=t,h[4]=n,h[5]=s,h[6]=i,h[7]=o,h[8]=c,this},identity:function(){return this.set(1,0,0,0,1,0,0,0,1),this},clone:function(){return(new this.constructor).fromArray(this.elements)},copy:function(e){return e=e.elements,this.set(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8]),this},setFromMatrix4:function(e){return e=e.elements,this.set(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10]),this},applyToVector3Array:function(){var e;return function(t,i,r){void 0===e&&(e=new THREE.Vector3),void 0===i&&(i=0),void 0===r&&(r=t.length);for(var n=0;r>n;n+=3,i+=3)e.fromArray(t,i),e.applyMatrix3(this),e.toArray(t,i);return t}}(),applyToBuffer:function(){var e;return function(t,i,r){void 0===e&&(e=new THREE.Vector3),void 0===i&&(i=0),void 0===r&&(r=t.length/t.itemSize);for(var n=0;r>n;n++,i++)e.x=t.getX(i),e.y=t.getY(i),e.z=t.getZ(i),e.applyMatrix3(this),t.setXYZ(e.x,e.y,e.z);return t}}(),multiplyScalar:function(e){var t=this.elements;return t[0]*=e,t[3]*=e,t[6]*=e,t[1]*=e,t[4]*=e,t[7]*=e,t[2]*=e,t[5]*=e,t[8]*=e,this},determinant:function(){var e=this.elements,t=e[0],i=e[1],r=e[2],n=e[3],o=e[4],a=e[5],s=e[6],c=e[7],e=e[8];return t*o*e-t*a*c-i*n*e+i*a*s+r*n*c-r*o*s},getInverse:function(e,t){e instanceof THREE.Matrix4&&console.error("THREE.Matrix3.getInverse no longer takes a Matrix4 argument.");var i=e.elements,r=this.elements,n=i[0],o=i[1],a=i[2],s=i[3],c=i[4],h=i[5],l=i[6],u=i[7],i=i[8],p=i*c-h*u,d=h*l-i*s,f=u*s-c*l,E=n*p+o*d+a*f;if(0===E){if(t)throw Error("THREE.Matrix3.getInverse(): can't invert matrix, determinant is 0");return console.warn("THREE.Matrix3.getInverse(): can't invert matrix, determinant is 0"),this.identity()}return E=1/E,r[0]=p*E,r[1]=(a*u-i*o)*E,r[2]=(h*o-a*c)*E,r[3]=d*E,r[4]=(i*n-a*l)*E,r[5]=(a*s-h*n)*E,r[6]=f*E,r[7]=(o*l-u*n)*E,r[8]=(c*n-o*s)*E,this},transpose:function(){var e,t=this.elements;return e=t[1],t[1]=t[3],t[3]=e,e=t[2],t[2]=t[6],t[6]=e,e=t[5],t[5]=t[7],t[7]=e,this},flattenToArrayOffset:function(e,t){return console.warn("THREE.Matrix3: .flattenToArrayOffset is deprecated - just use .toArray instead."),this.toArray(e,t)},getNormalMatrix:function(e){return this.setFromMatrix4(e).getInverse(this).transpose()},transposeIntoArray:function(e){var t=this.elements;return e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8],this},fromArray:function(e){return this.elements.set(e),this},toArray:function(e,t){void 0===e&&(e=[]),void 0===t&&(t=0);var i=this.elements;return e[t]=i[0],e[t+1]=i[1],e[t+2]=i[2],e[t+3]=i[3],e[t+4]=i[4],e[t+5]=i[5],e[t+6]=i[6],e[t+7]=i[7],e[t+8]=i[8],e}},THREE.Matrix4=function(){this.elements=new Float32Array([1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]),0<arguments.length&&console.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")},THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(e,t,i,r,n,o,a,s,c,h,l,u,p,d,f,E){var m=this.elements;return m[0]=e,m[4]=t,m[8]=i,m[12]=r,m[1]=n,m[5]=o,m[9]=a,m[13]=s,m[2]=c,m[6]=h,m[10]=l,m[14]=u,m[3]=p,m[7]=d,m[11]=f,m[15]=E,this},identity:function(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this},clone:function(){return(new THREE.Matrix4).fromArray(this.elements)},copy:function(e){return this.elements.set(e.elements),this},copyPosition:function(e){var t=this.elements;return e=e.elements,t[12]=e[12],t[13]=e[13],t[14]=e[14],this},extractBasis:function(e,t,i){return e.setFromMatrixColumn(this,0),t.setFromMatrixColumn(this,1),i.setFromMatrixColumn(this,2),this},makeBasis:function(e,t,i){return this.set(e.x,t.x,i.x,0,e.y,t.y,i.y,0,e.z,t.z,i.z,0,0,0,0,1),this},extractRotation:function(){var e;return function(t){void 0===e&&(e=new THREE.Vector3);var i=this.elements,r=t.elements,n=1/e.setFromMatrixColumn(t,0).length(),o=1/e.setFromMatrixColumn(t,1).length();return t=1/e.setFromMatrixColumn(t,2).length(),i[0]=r[0]*n,i[1]=r[1]*n,i[2]=r[2]*n,i[4]=r[4]*o,i[5]=r[5]*o,i[6]=r[6]*o,i[8]=r[8]*t,i[9]=r[9]*t,i[10]=r[10]*t,this}}(),makeRotationFromEuler:function(e){!1==e instanceof THREE.Euler&&console.error("THREE.Matrix: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var t=this.elements,i=e.x,r=e.y,n=e.z,o=Math.cos(i),i=Math.sin(i),a=Math.cos(r),r=Math.sin(r),s=Math.cos(n),n=Math.sin(n);if("XYZ"===e.order){e=o*s;var c=o*n,h=i*s,l=i*n;t[0]=a*s,t[4]=-a*n,t[8]=r,t[1]=c+h*r,t[5]=e-l*r,t[9]=-i*a,t[2]=l-e*r,t[6]=h+c*r,t[10]=o*a}else"YXZ"===e.order?(e=a*s,c=a*n,h=r*s,l=r*n,t[0]=e+l*i,t[4]=h*i-c,t[8]=o*r,t[1]=o*n,t[5]=o*s,t[9]=-i,t[2]=c*i-h,t[6]=l+e*i,t[10]=o*a):"ZXY"===e.order?(e=a*s,c=a*n,h=r*s,l=r*n,t[0]=e-l*i,t[4]=-o*n,t[8]=h+c*i,t[1]=c+h*i,t[5]=o*s,t[9]=l-e*i,t[2]=-o*r,t[6]=i,t[10]=o*a):"ZYX"===e.order?(e=o*s,c=o*n,h=i*s,l=i*n,t[0]=a*s,t[4]=h*r-c,t[8]=e*r+l,t[1]=a*n,t[5]=l*r+e,t[9]=c*r-h,t[2]=-r,t[6]=i*a,t[10]=o*a):"YZX"===e.order?(e=o*a,c=o*r,h=i*a,l=i*r,t[0]=a*s,t[4]=l-e*n,t[8]=h*n+c,t[1]=n,t[5]=o*s,t[9]=-i*s,t[2]=-r*s,t[6]=c*n+h,t[10]=e-l*n):"XZY"===e.order&&(e=o*a,c=o*r,h=i*a,l=i*r,t[0]=a*s,t[4]=-n,t[8]=r*s,t[1]=e*n+l,t[5]=o*s,t[9]=c*n-h,t[2]=h*n-c,t[6]=i*s,t[10]=l*n+e);return t[3]=0,t[7]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,this},makeRotationFromQuaternion:function(e){var t=this.elements,i=e.x,r=e.y,n=e.z,o=e.w,a=i+i,s=r+r,c=n+n;e=i*a;var h=i*s,i=i*c,l=r*s,r=r*c,n=n*c,a=o*a,s=o*s,o=o*c;return t[0]=1-(l+n),t[4]=h-o,t[8]=i+s,t[1]=h+o,t[5]=1-(e+n),t[9]=r-a,t[2]=i-s,t[6]=r+a,t[10]=1-(e+l),t[3]=0,t[7]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,this},lookAt:function(){var e,t,i;return function(r,n,o){void 0===e&&(e=new THREE.Vector3,t=new THREE.Vector3,i=new THREE.Vector3);var a=this.elements;return i.subVectors(r,n).normalize(),0===i.lengthSq()&&(i.z=1),e.crossVectors(o,i).normalize(),0===e.lengthSq()&&(i.z+=1e-4,e.crossVectors(o,i).normalize()),t.crossVectors(i,e),a[0]=e.x,a[4]=t.x,a[8]=i.x,a[1]=e.y,a[5]=t.y,a[9]=i.y,a[2]=e.z,a[6]=t.z,a[10]=i.z,this}}(),multiply:function(e,t){return void 0!==t?(console.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead."),this.multiplyMatrices(e,t)):this.multiplyMatrices(this,e)},premultiply:function(e){return this.multiplyMatrices(e,this)},multiplyMatrices:function(e,t){var i=e.elements,r=t.elements,n=this.elements,o=i[0],a=i[4],s=i[8],c=i[12],h=i[1],l=i[5],u=i[9],p=i[13],d=i[2],f=i[6],E=i[10],m=i[14],g=i[3],T=i[7],v=i[11],i=i[15],y=r[0],R=r[4],x=r[8],H=r[12],b=r[1],_=r[5],M=r[9],w=r[13],S=r[2],L=r[6],A=r[10],C=r[14],P=r[3],B=r[7],U=r[11],r=r[15];return n[0]=o*y+a*b+s*S+c*P,n[4]=o*R+a*_+s*L+c*B,n[8]=o*x+a*M+s*A+c*U,n[12]=o*H+a*w+s*C+c*r,n[1]=h*y+l*b+u*S+p*P,n[5]=h*R+l*_+u*L+p*B,n[9]=h*x+l*M+u*A+p*U,n[13]=h*H+l*w+u*C+p*r,n[2]=d*y+f*b+E*S+m*P,n[6]=d*R+f*_+E*L+m*B,n[10]=d*x+f*M+E*A+m*U,n[14]=d*H+f*w+E*C+m*r,n[3]=g*y+T*b+v*S+i*P,n[7]=g*R+T*_+v*L+i*B,n[11]=g*x+T*M+v*A+i*U,n[15]=g*H+T*w+v*C+i*r,this},multiplyToArray:function(e,t,i){var r=this.elements;return this.multiplyMatrices(e,t),i[0]=r[0],i[1]=r[1],i[2]=r[2],i[3]=r[3],i[4]=r[4],i[5]=r[5],i[6]=r[6],i[7]=r[7],i[8]=r[8],i[9]=r[9],i[10]=r[10],i[11]=r[11],i[12]=r[12],i[13]=r[13],i[14]=r[14],i[15]=r[15],this},multiplyScalar:function(e){var t=this.elements;return t[0]*=e,t[4]*=e,t[8]*=e,t[12]*=e,t[1]*=e,t[5]*=e,t[9]*=e,t[13]*=e,t[2]*=e,t[6]*=e,t[10]*=e,t[14]*=e,t[3]*=e,t[7]*=e,t[11]*=e,t[15]*=e,this},applyToVector3Array:function(){var e;return function(t,i,r){void 0===e&&(e=new THREE.Vector3),void 0===i&&(i=0),void 0===r&&(r=t.length);for(var n=0;r>n;n+=3,i+=3)e.fromArray(t,i),e.applyMatrix4(this),e.toArray(t,i);return t}}(),applyToBuffer:function(){var e;return function(t,i,r){void 0===e&&(e=new THREE.Vector3),void 0===i&&(i=0),void 0===r&&(r=t.length/t.itemSize);for(var n=0;r>n;n++,i++)e.x=t.getX(i),e.y=t.getY(i),e.z=t.getZ(i),e.applyMatrix4(this),t.setXYZ(e.x,e.y,e.z);return t}}(),determinant:function(){var e=this.elements,t=e[0],i=e[4],r=e[8],n=e[12],o=e[1],a=e[5],s=e[9],c=e[13],h=e[2],l=e[6],u=e[10],p=e[14];return e[3]*(+n*s*l-r*c*l-n*a*u+i*c*u+r*a*p-i*s*p)+e[7]*(+t*s*p-t*c*u+n*o*u-r*o*p+r*c*h-n*s*h)+e[11]*(+t*c*l-t*a*p-n*o*l+i*o*p+n*a*h-i*c*h)+e[15]*(-r*a*h-t*s*l+t*a*u+r*o*l-i*o*u+i*s*h)},transpose:function(){var e,t=this.elements;return e=t[1],t[1]=t[4],t[4]=e,e=t[2],t[2]=t[8],t[8]=e,e=t[6],t[6]=t[9],t[9]=e,e=t[3],t[3]=t[12],t[12]=e,e=t[7],t[7]=t[13],t[13]=e,e=t[11],t[11]=t[14],t[14]=e,this},flattenToArrayOffset:function(e,t){return console.warn("THREE.Matrix3: .flattenToArrayOffset is deprecated - just use .toArray instead."),this.toArray(e,t)},getPosition:function(){var e;return function(){return void 0===e&&(e=new THREE.Vector3),console.warn("THREE.Matrix4: .getPosition() has been removed. Use Vector3.setFromMatrixPosition( matrix ) instead."),e.setFromMatrixColumn(this,3)}}(),setPosition:function(e){var t=this.elements;return t[12]=e.x,t[13]=e.y,t[14]=e.z,this},getInverse:function(e,t){var i=this.elements,r=e.elements,n=r[0],o=r[1],a=r[2],s=r[3],c=r[4],h=r[5],l=r[6],u=r[7],p=r[8],d=r[9],f=r[10],E=r[11],m=r[12],g=r[13],T=r[14],r=r[15],v=d*T*u-g*f*u+g*l*E-h*T*E-d*l*r+h*f*r,y=m*f*u-p*T*u-m*l*E+c*T*E+p*l*r-c*f*r,R=p*g*u-m*d*u+m*h*E-c*g*E-p*h*r+c*d*r,x=m*d*l-p*g*l-m*h*f+c*g*f+p*h*T-c*d*T,H=n*v+o*y+a*R+s*x;if(0===H){if(t)throw Error("THREE.Matrix4.getInverse(): can't invert matrix, determinant is 0");return console.warn("THREE.Matrix4.getInverse(): can't invert matrix, determinant is 0"),this.identity()}return H=1/H,i[0]=v*H,i[1]=(g*f*s-d*T*s-g*a*E+o*T*E+d*a*r-o*f*r)*H,i[2]=(h*T*s-g*l*s+g*a*u-o*T*u-h*a*r+o*l*r)*H,i[3]=(d*l*s-h*f*s-d*a*u+o*f*u+h*a*E-o*l*E)*H,i[4]=y*H,i[5]=(p*T*s-m*f*s+m*a*E-n*T*E-p*a*r+n*f*r)*H,i[6]=(m*l*s-c*T*s-m*a*u+n*T*u+c*a*r-n*l*r)*H,i[7]=(c*f*s-p*l*s+p*a*u-n*f*u-c*a*E+n*l*E)*H,i[8]=R*H,i[9]=(m*d*s-p*g*s-m*o*E+n*g*E+p*o*r-n*d*r)*H,i[10]=(c*g*s-m*h*s+m*o*u-n*g*u-c*o*r+n*h*r)*H,i[11]=(p*h*s-c*d*s-p*o*u+n*d*u+c*o*E-n*h*E)*H,i[12]=x*H,i[13]=(p*g*a-m*d*a+m*o*f-n*g*f-p*o*T+n*d*T)*H,i[14]=(m*h*a-c*g*a-m*o*l+n*g*l+c*o*T-n*h*T)*H,i[15]=(c*d*a-p*h*a+p*o*l-n*d*l-c*o*f+n*h*f)*H,this},scale:function(e){var t=this.elements,i=e.x,r=e.y;return e=e.z,t[0]*=i,t[4]*=r,t[8]*=e,t[1]*=i,t[5]*=r,t[9]*=e,t[2]*=i,t[6]*=r,t[10]*=e,t[3]*=i,t[7]*=r,t[11]*=e,this},getMaxScaleOnAxis:function(){var e=this.elements;return Math.sqrt(Math.max(e[0]*e[0]+e[1]*e[1]+e[2]*e[2],e[4]*e[4]+e[5]*e[5]+e[6]*e[6],e[8]*e[8]+e[9]*e[9]+e[10]*e[10]))},makeTranslation:function(e,t,i){return this.set(1,0,0,e,0,1,0,t,0,0,1,i,0,0,0,1),this},makeRotationX:function(e){var t=Math.cos(e);return e=Math.sin(e),this.set(1,0,0,0,0,t,-e,0,0,e,t,0,0,0,0,1),this},makeRotationY:function(e){var t=Math.cos(e);return e=Math.sin(e),this.set(t,0,e,0,0,1,0,0,-e,0,t,0,0,0,0,1),this},makeRotationZ:function(e){var t=Math.cos(e);return e=Math.sin(e),this.set(t,-e,0,0,e,t,0,0,0,0,1,0,0,0,0,1),this},makeRotationAxis:function(e,t){var i=Math.cos(t),r=Math.sin(t),n=1-i,o=e.x,a=e.y,s=e.z,c=n*o,h=n*a;return this.set(c*o+i,c*a-r*s,c*s+r*a,0,c*a+r*s,h*a+i,h*s-r*o,0,c*s-r*a,h*s+r*o,n*s*s+i,0,0,0,0,1),this},makeScale:function(e,t,i){return this.set(e,0,0,0,0,t,0,0,0,0,i,0,0,0,0,1),this},compose:function(e,t,i){return this.makeRotationFromQuaternion(t),this.scale(i),this.setPosition(e),this},decompose:function(){var e,t;return function(i,r,n){void 0===e&&(e=new THREE.Vector3,t=new THREE.Matrix4);var o=this.elements,a=e.set(o[0],o[1],o[2]).length(),s=e.set(o[4],o[5],o[6]).length(),c=e.set(o[8],o[9],o[10]).length();0>this.determinant()&&(a=-a),i.x=o[12],i.y=o[13],i.z=o[14],t.elements.set(this.elements),i=1/a;var o=1/s,h=1/c;return t.elements[0]*=i,t.elements[1]*=i,t.elements[2]*=i,t.elements[4]*=o,t.elements[5]*=o,t.elements[6]*=o,t.elements[8]*=h,t.elements[9]*=h,t.elements[10]*=h,r.setFromRotationMatrix(t),n.x=a,n.y=s,n.z=c,this}}(),makeFrustum:function(e,t,i,r,n,o){var a=this.elements;return a[0]=2*n/(t-e),a[4]=0,a[8]=(t+e)/(t-e),a[12]=0,a[1]=0,a[5]=2*n/(r-i),a[9]=(r+i)/(r-i),a[13]=0,a[2]=0,a[6]=0,a[10]=-(o+n)/(o-n),a[14]=-2*o*n/(o-n),a[3]=0,a[7]=0,a[11]=-1,a[15]=0,this},makePerspective:function(e,t,i,r){e=i*Math.tan(THREE.Math.DEG2RAD*e*.5);var n=-e;return this.makeFrustum(n*t,e*t,n,e,i,r)},makeOrthographic:function(e,t,i,r,n,o){var a=this.elements,s=1/(t-e),c=1/(i-r),h=1/(o-n);return a[0]=2*s,a[4]=0,a[8]=0,a[12]=-((t+e)*s),a[1]=0,a[5]=2*c,a[9]=0,a[13]=-((i+r)*c),a[2]=0,a[6]=0,a[10]=-2*h,a[14]=-((o+n)*h),a[3]=0,a[7]=0,a[11]=0,a[15]=1,this},equals:function(e){var t=this.elements;e=e.elements;for(var i=0;16>i;i++)if(t[i]!==e[i])return!1;return!0},fromArray:function(e){return this.elements.set(e),this},toArray:function(e,t){void 0===e&&(e=[]),void 0===t&&(t=0);var i=this.elements;return e[t]=i[0],e[t+1]=i[1],e[t+2]=i[2],e[t+3]=i[3],e[t+4]=i[4],e[t+5]=i[5],e[t+6]=i[6],e[t+7]=i[7],e[t+8]=i[8],e[t+9]=i[9],e[t+10]=i[10],e[t+11]=i[11],e[t+12]=i[12],e[t+13]=i[13],e[t+14]=i[14],e[t+15]=i[15],e}},THREE.Ray=function(e,t){this.origin=void 0!==e?e:new THREE.Vector3,this.direction=void 0!==t?t:new THREE.Vector3},THREE.Ray.prototype={constructor:THREE.Ray,set:function(e,t){return this.origin.copy(e),this.direction.copy(t),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.origin.copy(e.origin),this.direction.copy(e.direction),this},at:function(e,t){return(t||new THREE.Vector3).copy(this.direction).multiplyScalar(e).add(this.origin)},lookAt:function(e){return this.direction.copy(e).sub(this.origin).normalize(),this},recast:function(){var e=new THREE.Vector3;return function(t){return this.origin.copy(this.at(t,e)),this}}(),closestPointToPoint:function(e,t){var i=t||new THREE.Vector3;i.subVectors(e,this.origin);var r=i.dot(this.direction);return 0>r?i.copy(this.origin):i.copy(this.direction).multiplyScalar(r).add(this.origin)},distanceToPoint:function(e){return Math.sqrt(this.distanceSqToPoint(e))},distanceSqToPoint:function(){var e=new THREE.Vector3;return function(t){var i=e.subVectors(t,this.origin).dot(this.direction);return 0>i?this.origin.distanceToSquared(t):(e.copy(this.direction).multiplyScalar(i).add(this.origin),e.distanceToSquared(t))}}(),distanceSqToSegment:function(){var e=new THREE.Vector3,t=new THREE.Vector3,i=new THREE.Vector3;return function(r,n,o,a){e.copy(r).add(n).multiplyScalar(.5),t.copy(n).sub(r).normalize(),i.copy(this.origin).sub(e);var s,c=.5*r.distanceTo(n),h=-this.direction.dot(t),l=i.dot(this.direction),u=-i.dot(t),p=i.lengthSq(),d=Math.abs(1-h*h);return d>0?(r=h*u-l,n=h*l-u,s=c*d,r>=0?n>=-s?s>=n?(c=1/d,r*=c,n*=c,h=r*(r+h*n+2*l)+n*(h*r+n+2*u)+p):(n=c,r=Math.max(0,-(h*n+l)),h=-r*r+n*(n+2*u)+p):(n=-c,r=Math.max(0,-(h*n+l)),h=-r*r+n*(n+2*u)+p):-s>=n?(r=Math.max(0,-(-h*c+l)),n=r>0?-c:Math.min(Math.max(-c,-u),c),h=-r*r+n*(n+2*u)+p):s>=n?(r=0,n=Math.min(Math.max(-c,-u),c),h=n*(n+2*u)+p):(r=Math.max(0,-(h*c+l)),n=r>0?c:Math.min(Math.max(-c,-u),c),h=-r*r+n*(n+2*u)+p)):(n=h>0?-c:c,r=Math.max(0,-(h*n+l)),h=-r*r+n*(n+2*u)+p),o&&o.copy(this.direction).multiplyScalar(r).add(this.origin),a&&a.copy(t).multiplyScalar(n).add(e),h}}(),intersectSphere:function(){var e=new THREE.Vector3;return function(t,i){e.subVectors(t.center,this.origin);var r=e.dot(this.direction),n=e.dot(e)-r*r,o=t.radius*t.radius;return n>o?null:(o=Math.sqrt(o-n),n=r-o,r+=o,0>n&&0>r?null:0>n?this.at(r,i):this.at(n,i))}}(),intersectsSphere:function(e){return this.distanceToPoint(e.center)<=e.radius},distanceToPlane:function(e){var t=e.normal.dot(this.direction);return 0===t?0===e.distanceToPoint(this.origin)?0:null:(e=-(this.origin.dot(e.normal)+e.constant)/t,e>=0?e:null)},intersectPlane:function(e,t){var i=this.distanceToPlane(e);return null===i?null:this.at(i,t)},intersectsPlane:function(e){var t=e.distanceToPoint(this.origin);return 0===t||0>e.normal.dot(this.direction)*t},intersectBox:function(e,t){var i,r,n,o,a;r=1/this.direction.x,o=1/this.direction.y,a=1/this.direction.z;var s=this.origin;return r>=0?(i=(e.min.x-s.x)*r,r*=e.max.x-s.x):(i=(e.max.x-s.x)*r,r*=e.min.x-s.x),o>=0?(n=(e.min.y-s.y)*o,o*=e.max.y-s.y):(n=(e.max.y-s.y)*o,o*=e.min.y-s.y),i>o||n>r?null:((n>i||i!==i)&&(i=n),(r>o||r!==r)&&(r=o),a>=0?(n=(e.min.z-s.z)*a,a*=e.max.z-s.z):(n=(e.max.z-s.z)*a,a*=e.min.z-s.z),i>a||n>r?null:((n>i||i!==i)&&(i=n),(r>a||r!==r)&&(r=a),0>r?null:this.at(i>=0?i:r,t)))},intersectsBox:function(){var e=new THREE.Vector3;return function(t){return null!==this.intersectBox(t,e)}}(),intersectTriangle:function(){var e=new THREE.Vector3,t=new THREE.Vector3,i=new THREE.Vector3,r=new THREE.Vector3;return function(n,o,a,s,c){if(t.subVectors(o,n),i.subVectors(a,n),r.crossVectors(t,i),o=this.direction.dot(r),o>0){if(s)return null;s=1}else{if(!(0>o))return null;s=-1,o=-o}return e.subVectors(this.origin,n),n=s*this.direction.dot(i.crossVectors(e,i)),0>n?null:(a=s*this.direction.dot(t.cross(e)),0>a||n+a>o?null:(n=-s*e.dot(r),0>n?null:this.at(n/o,c)))}}(),applyMatrix4:function(e){return this.direction.add(this.origin).applyMatrix4(e),this.origin.applyMatrix4(e),this.direction.sub(this.origin),this.direction.normalize(),this},equals:function(e){return e.origin.equals(this.origin)&&e.direction.equals(this.direction)}},THREE.Sphere=function(e,t){this.center=void 0!==e?e:new THREE.Vector3,this.radius=void 0!==t?t:0},THREE.Sphere.prototype={constructor:THREE.Sphere,set:function(e,t){return this.center.copy(e),this.radius=t,this},setFromPoints:function(){var e=new THREE.Box3;return function(t,i){var r=this.center;void 0!==i?r.copy(i):e.setFromPoints(t).center(r);for(var n=0,o=0,a=t.length;a>o;o++)n=Math.max(n,r.distanceToSquared(t[o]));return this.radius=Math.sqrt(n),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.center.copy(e.center),this.radius=e.radius,this},empty:function(){return 0>=this.radius},containsPoint:function(e){return e.distanceToSquared(this.center)<=this.radius*this.radius},distanceToPoint:function(e){return e.distanceTo(this.center)-this.radius},intersectsSphere:function(e){var t=this.radius+e.radius;return e.center.distanceToSquared(this.center)<=t*t},intersectsBox:function(e){return e.intersectsSphere(this)},intersectsPlane:function(e){return Math.abs(this.center.dot(e.normal)-e.constant)<=this.radius},clampPoint:function(e,t){var i=this.center.distanceToSquared(e),r=t||new THREE.Vector3;return r.copy(e),i>this.radius*this.radius&&(r.sub(this.center).normalize(),r.multiplyScalar(this.radius).add(this.center)),r},getBoundingBox:function(e){return e=e||new THREE.Box3,e.set(this.center,this.center),e.expandByScalar(this.radius),e},applyMatrix4:function(e){return this.center.applyMatrix4(e),this.radius*=e.getMaxScaleOnAxis(),this},translate:function(e){return this.center.add(e),this},equals:function(e){return e.center.equals(this.center)&&e.radius===this.radius}},THREE.Frustum=function(e,t,i,r,n,o){this.planes=[void 0!==e?e:new THREE.Plane,void 0!==t?t:new THREE.Plane,void 0!==i?i:new THREE.Plane,void 0!==r?r:new THREE.Plane,void 0!==n?n:new THREE.Plane,void 0!==o?o:new THREE.Plane]},THREE.Frustum.prototype={constructor:THREE.Frustum,set:function(e,t,i,r,n,o){var a=this.planes;return a[0].copy(e),a[1].copy(t),a[2].copy(i),a[3].copy(r),a[4].copy(n),a[5].copy(o),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){for(var t=this.planes,i=0;6>i;i++)t[i].copy(e.planes[i]);return this},setFromMatrix:function(e){var t=this.planes,i=e.elements;e=i[0];var r=i[1],n=i[2],o=i[3],a=i[4],s=i[5],c=i[6],h=i[7],l=i[8],u=i[9],p=i[10],d=i[11],f=i[12],E=i[13],m=i[14],i=i[15];return t[0].setComponents(o-e,h-a,d-l,i-f).normalize(),t[1].setComponents(o+e,h+a,d+l,i+f).normalize(),
t[2].setComponents(o+r,h+s,d+u,i+E).normalize(),t[3].setComponents(o-r,h-s,d-u,i-E).normalize(),t[4].setComponents(o-n,h-c,d-p,i-m).normalize(),t[5].setComponents(o+n,h+c,d+p,i+m).normalize(),this},intersectsObject:function(){var e=new THREE.Sphere;return function(t){var i=t.geometry;return null===i.boundingSphere&&i.computeBoundingSphere(),e.copy(i.boundingSphere).applyMatrix4(t.matrixWorld),this.intersectsSphere(e)}}(),intersectsSprite:function(){var e=new THREE.Sphere;return function(t){return e.center.set(0,0,0),e.radius=.7071067811865476,e.applyMatrix4(t.matrixWorld),this.intersectsSphere(e)}}(),intersectsSphere:function(e){var t=this.planes,i=e.center;e=-e.radius;for(var r=0;6>r;r++)if(t[r].distanceToPoint(i)<e)return!1;return!0},intersectsBox:function(){var e=new THREE.Vector3,t=new THREE.Vector3;return function(i){for(var r=this.planes,n=0;6>n;n++){var o=r[n];e.x=0<o.normal.x?i.min.x:i.max.x,t.x=0<o.normal.x?i.max.x:i.min.x,e.y=0<o.normal.y?i.min.y:i.max.y,t.y=0<o.normal.y?i.max.y:i.min.y,e.z=0<o.normal.z?i.min.z:i.max.z,t.z=0<o.normal.z?i.max.z:i.min.z;var a=o.distanceToPoint(e),o=o.distanceToPoint(t);if(0>a&&0>o)return!1}return!0}}(),containsPoint:function(e){for(var t=this.planes,i=0;6>i;i++)if(0>t[i].distanceToPoint(e))return!1;return!0}},THREE.Plane=function(e,t){this.normal=void 0!==e?e:new THREE.Vector3(1,0,0),this.constant=void 0!==t?t:0},THREE.Plane.prototype={constructor:THREE.Plane,set:function(e,t){return this.normal.copy(e),this.constant=t,this},setComponents:function(e,t,i,r){return this.normal.set(e,t,i),this.constant=r,this},setFromNormalAndCoplanarPoint:function(e,t){return this.normal.copy(e),this.constant=-t.dot(this.normal),this},setFromCoplanarPoints:function(){var e=new THREE.Vector3,t=new THREE.Vector3;return function(i,r,n){return r=e.subVectors(n,r).cross(t.subVectors(i,r)).normalize(),this.setFromNormalAndCoplanarPoint(r,i),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.normal.copy(e.normal),this.constant=e.constant,this},normalize:function(){var e=1/this.normal.length();return this.normal.multiplyScalar(e),this.constant*=e,this},negate:function(){return this.constant*=-1,this.normal.negate(),this},distanceToPoint:function(e){return this.normal.dot(e)+this.constant},distanceToSphere:function(e){return this.distanceToPoint(e.center)-e.radius},projectPoint:function(e,t){return this.orthoPoint(e,t).sub(e).negate()},orthoPoint:function(e,t){var i=this.distanceToPoint(e);return(t||new THREE.Vector3).copy(this.normal).multiplyScalar(i)},intersectLine:function(){var e=new THREE.Vector3;return function(t,i){var r=i||new THREE.Vector3,n=t.delta(e),o=this.normal.dot(n);return 0!==o?(o=-(t.start.dot(this.normal)+this.constant)/o,0>o||o>1?void 0:r.copy(n).multiplyScalar(o).add(t.start)):0===this.distanceToPoint(t.start)?r.copy(t.start):void 0}}(),intersectsLine:function(e){var t=this.distanceToPoint(e.start);return e=this.distanceToPoint(e.end),0>t&&e>0||0>e&&t>0},intersectsBox:function(e){return e.intersectsPlane(this)},intersectsSphere:function(e){return e.intersectsPlane(this)},coplanarPoint:function(e){return(e||new THREE.Vector3).copy(this.normal).multiplyScalar(-this.constant)},applyMatrix4:function(){var e=new THREE.Vector3,t=new THREE.Matrix3;return function(i,r){var n=this.coplanarPoint(e).applyMatrix4(i),o=r||t.getNormalMatrix(i),o=this.normal.applyMatrix3(o).normalize();return this.constant=-n.dot(o),this}}(),translate:function(e){return this.constant-=e.dot(this.normal),this},equals:function(e){return e.normal.equals(this.normal)&&e.constant===this.constant}},THREE.Spherical=function(e,t,i){return this.radius=void 0!==e?e:1,this.phi=void 0!==t?t:0,this.theta=void 0!==i?i:0,this},THREE.Spherical.prototype={constructor:THREE.Spherical,set:function(e,t,i){return this.radius=e,this.phi=t,this.theta=i,this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.radius.copy(e.radius),this.phi.copy(e.phi),this.theta.copy(e.theta),this},makeSafe:function(){return this.phi=Math.max(1e-6,Math.min(Math.PI-1e-6,this.phi)),this},setFromVector3:function(e){return this.radius=e.length(),0===this.radius?this.phi=this.theta=0:(this.theta=Math.atan2(e.x,e.z),this.phi=Math.acos(THREE.Math.clamp(e.y/this.radius,-1,1))),this}},THREE.Math={DEG2RAD:Math.PI/180,RAD2DEG:180/Math.PI,generateUUID:function(){var e,t="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),i=Array(36),r=0;return function(){for(var n=0;36>n;n++)8===n||13===n||18===n||23===n?i[n]="-":14===n?i[n]="4":(2>=r&&(r=33554432+16777216*Math.random()|0),e=15&r,r>>=4,i[n]=t[19===n?3&e|8:e]);return i.join("")}}(),clamp:function(e,t,i){return Math.max(t,Math.min(i,e))},euclideanModulo:function(e,t){return(e%t+t)%t},mapLinear:function(e,t,i,r,n){return r+(e-t)*(n-r)/(i-t)},smoothstep:function(e,t,i){return t>=e?0:e>=i?1:(e=(e-t)/(i-t),e*e*(3-2*e))},smootherstep:function(e,t,i){return t>=e?0:e>=i?1:(e=(e-t)/(i-t),e*e*e*(e*(6*e-15)+10))},random16:function(){return console.warn("THREE.Math.random16() has been deprecated. Use Math.random() instead."),Math.random()},randInt:function(e,t){return e+Math.floor(Math.random()*(t-e+1))},randFloat:function(e,t){return e+Math.random()*(t-e)},randFloatSpread:function(e){return e*(.5-Math.random())},degToRad:function(e){return e*THREE.Math.DEG2RAD},radToDeg:function(e){return e*THREE.Math.RAD2DEG},isPowerOfTwo:function(e){return 0===(e&e-1)&&0!==e},nearestPowerOfTwo:function(e){return Math.pow(2,Math.round(Math.log(e)/Math.LN2))},nextPowerOfTwo:function(e){return e--,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,e++,e}},THREE.Spline=function(e){function t(e,t,i,r,n,o,a){return e=.5*(i-e),r=.5*(r-t),(2*(t-i)+e+r)*a+(-3*(t-i)-2*e-r)*o+e*n+t}this.points=e;var i,r,n,o,a,s,c,h,l,u=[],p={x:0,y:0,z:0};this.initFromArray=function(e){this.points=[];for(var t=0;t<e.length;t++)this.points[t]={x:e[t][0],y:e[t][1],z:e[t][2]}},this.getPoint=function(e){return i=(this.points.length-1)*e,r=Math.floor(i),n=i-r,u[0]=0===r?r:r-1,u[1]=r,u[2]=r>this.points.length-2?this.points.length-1:r+1,u[3]=r>this.points.length-3?this.points.length-1:r+2,s=this.points[u[0]],c=this.points[u[1]],h=this.points[u[2]],l=this.points[u[3]],o=n*n,a=n*o,p.x=t(s.x,c.x,h.x,l.x,n,o,a),p.y=t(s.y,c.y,h.y,l.y,n,o,a),p.z=t(s.z,c.z,h.z,l.z,n,o,a),p},this.getControlPointsArray=function(){var e,t,i=this.points.length,r=[];for(e=0;i>e;e++)t=this.points[e],r[e]=[t.x,t.y,t.z];return r},this.getLength=function(e){var t,i,r,n=t=t=0,o=new THREE.Vector3,a=new THREE.Vector3,s=[],c=0;for(s[0]=0,e||(e=100),i=this.points.length*e,o.copy(this.points[0]),e=1;i>e;e++)t=e/i,r=this.getPoint(t),a.copy(r),c+=a.distanceTo(o),o.copy(r),t*=this.points.length-1,t=Math.floor(t),t!==n&&(s[t]=c,n=t);return s[s.length]=c,{chunks:s,total:c}},this.reparametrizeByArcLength=function(e){var t,i,r,n,o,a,s=[],c=new THREE.Vector3,h=this.getLength();for(s.push(c.copy(this.points[0]).clone()),t=1;t<this.points.length;t++){for(i=h.chunks[t]-h.chunks[t-1],a=Math.ceil(e*i/h.total),n=(t-1)/(this.points.length-1),o=t/(this.points.length-1),i=1;a-1>i;i++)r=n+1/a*i*(o-n),r=this.getPoint(r),s.push(c.copy(r).clone());s.push(c.copy(this.points[t]).clone())}this.points=s}},THREE.Triangle=function(e,t,i){this.a=void 0!==e?e:new THREE.Vector3,this.b=void 0!==t?t:new THREE.Vector3,this.c=void 0!==i?i:new THREE.Vector3},THREE.Triangle.normal=function(){var e=new THREE.Vector3;return function(t,i,r,n){return n=n||new THREE.Vector3,n.subVectors(r,i),e.subVectors(t,i),n.cross(e),t=n.lengthSq(),t>0?n.multiplyScalar(1/Math.sqrt(t)):n.set(0,0,0)}}(),THREE.Triangle.barycoordFromPoint=function(){var e=new THREE.Vector3,t=new THREE.Vector3,i=new THREE.Vector3;return function(r,n,o,a,s){e.subVectors(a,n),t.subVectors(o,n),i.subVectors(r,n),r=e.dot(e),n=e.dot(t),o=e.dot(i);var c=t.dot(t);a=t.dot(i);var h=r*c-n*n;return s=s||new THREE.Vector3,0===h?s.set(-2,-1,-1):(h=1/h,c=(c*o-n*a)*h,r=(r*a-n*o)*h,s.set(1-c-r,r,c))}}(),THREE.Triangle.containsPoint=function(){var e=new THREE.Vector3;return function(t,i,r,n){return t=THREE.Triangle.barycoordFromPoint(t,i,r,n,e),0<=t.x&&0<=t.y&&1>=t.x+t.y}}(),THREE.Triangle.prototype={constructor:THREE.Triangle,set:function(e,t,i){return this.a.copy(e),this.b.copy(t),this.c.copy(i),this},setFromPointsAndIndices:function(e,t,i,r){return this.a.copy(e[t]),this.b.copy(e[i]),this.c.copy(e[r]),this},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.a.copy(e.a),this.b.copy(e.b),this.c.copy(e.c),this},area:function(){var e=new THREE.Vector3,t=new THREE.Vector3;return function(){return e.subVectors(this.c,this.b),t.subVectors(this.a,this.b),.5*e.cross(t).length()}}(),midpoint:function(e){return(e||new THREE.Vector3).addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)},normal:function(e){return THREE.Triangle.normal(this.a,this.b,this.c,e)},plane:function(e){return(e||new THREE.Plane).setFromCoplanarPoints(this.a,this.b,this.c)},barycoordFromPoint:function(e,t){return THREE.Triangle.barycoordFromPoint(e,this.a,this.b,this.c,t)},containsPoint:function(e){return THREE.Triangle.containsPoint(e,this.a,this.b,this.c)},closestPointToPoint:function(){var e,t,i,r;return function(n,o){void 0===e&&(e=new THREE.Plane,t=[new THREE.Line3,new THREE.Line3,new THREE.Line3],i=new THREE.Vector3,r=new THREE.Vector3);var a=o||new THREE.Vector3,s=1/0;if(e.setFromCoplanarPoints(this.a,this.b,this.c),e.projectPoint(n,i),!0===this.containsPoint(i))a.copy(i);else{t[0].set(this.a,this.b),t[1].set(this.b,this.c),t[2].set(this.c,this.a);for(var c=0;c<t.length;c++){t[c].closestPointToPoint(i,!0,r);var h=i.distanceToSquared(r);s>h&&(s=h,a.copy(r))}}return a}}(),equals:function(e){return e.a.equals(this.a)&&e.b.equals(this.b)&&e.c.equals(this.c)}},THREE.Interpolant=function(e,t,i,r){this.parameterPositions=e,this._cachedIndex=0,this.resultBuffer=void 0!==r?r:new t.constructor(i),this.sampleValues=t,this.valueSize=i},THREE.Interpolant.prototype={constructor:THREE.Interpolant,evaluate:function(e){var t=this.parameterPositions,i=this._cachedIndex,r=t[i],n=t[i-1];e:{t:{i:{r:if(!(r>e)){for(var o=i+2;;){if(void 0===r){if(n>e)break r;return this._cachedIndex=i=t.length,this.afterEnd_(i-1,e,n)}if(i===o)break;if(n=r,r=t[++i],r>e)break t}r=t.length;break i}if(e>=n)break e;for(o=t[1],o>e&&(i=2,n=o),o=i-2;;){if(void 0===n)return this._cachedIndex=0,this.beforeStart_(0,e,r);if(i===o)break;if(r=n,n=t[--i-1],e>=n)break t}r=i,i=0}for(;r>i;)n=i+r>>>1,e<t[n]?r=n:i=n+1;if(r=t[i],n=t[i-1],void 0===n)return this._cachedIndex=0,this.beforeStart_(0,e,r);if(void 0===r)return this._cachedIndex=i=t.length,this.afterEnd_(i-1,n,e)}this._cachedIndex=i,this.intervalChanged_(i,n,r)}return this.interpolate_(i,n,e,r)},settings:null,DefaultSettings_:{},getSettings_:function(){return this.settings||this.DefaultSettings_},copySampleValue_:function(e){var t=this.resultBuffer,i=this.sampleValues,r=this.valueSize;e*=r;for(var n=0;n!==r;++n)t[n]=i[e+n];return t},interpolate_:function(e,t,i,r){throw Error("call to abstract method")},intervalChanged_:function(e,t,i){}},Object.assign(THREE.Interpolant.prototype,{beforeStart_:THREE.Interpolant.prototype.copySampleValue_,afterEnd_:THREE.Interpolant.prototype.copySampleValue_}),THREE.CubicInterpolant=function(e,t,i,r){THREE.Interpolant.call(this,e,t,i,r),this._offsetNext=this._weightNext=this._offsetPrev=this._weightPrev=-0},THREE.CubicInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.CubicInterpolant,DefaultSettings_:{endingStart:THREE.ZeroCurvatureEnding,endingEnd:THREE.ZeroCurvatureEnding},intervalChanged_:function(e,t,i){var r=this.parameterPositions,n=e-2,o=e+1,a=r[n],s=r[o];if(void 0===a)switch(this.getSettings_().endingStart){case THREE.ZeroSlopeEnding:n=e,a=2*t-i;break;case THREE.WrapAroundEnding:n=r.length-2,a=t+r[n]-r[n+1];break;default:n=e,a=i}if(void 0===s)switch(this.getSettings_().endingEnd){case THREE.ZeroSlopeEnding:o=e,s=2*i-t;break;case THREE.WrapAroundEnding:o=1,s=i+r[1]-r[0];break;default:o=e-1,s=t}e=.5*(i-t),r=this.valueSize,this._weightPrev=e/(t-a),this._weightNext=e/(s-i),this._offsetPrev=n*r,this._offsetNext=o*r},interpolate_:function(e,t,i,r){var n=this.resultBuffer,o=this.sampleValues,a=this.valueSize;e*=a;var s=e-a,c=this._offsetPrev,h=this._offsetNext,l=this._weightPrev,u=this._weightNext,p=(i-t)/(r-t);for(i=p*p,r=i*p,t=-l*r+2*l*i-l*p,l=(1+l)*r+(-1.5-2*l)*i+(-.5+l)*p+1,p=(-1-u)*r+(1.5+u)*i+.5*p,u=u*r-u*i,i=0;i!==a;++i)n[i]=t*o[c+i]+l*o[s+i]+p*o[e+i]+u*o[h+i];return n}}),THREE.DiscreteInterpolant=function(e,t,i,r){THREE.Interpolant.call(this,e,t,i,r)},THREE.DiscreteInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.DiscreteInterpolant,interpolate_:function(e,t,i,r){return this.copySampleValue_(e-1)}}),THREE.LinearInterpolant=function(e,t,i,r){THREE.Interpolant.call(this,e,t,i,r)},THREE.LinearInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.LinearInterpolant,interpolate_:function(e,t,i,r){var n=this.resultBuffer,o=this.sampleValues,a=this.valueSize;e*=a;var s=e-a;for(t=(i-t)/(r-t),i=1-t,r=0;r!==a;++r)n[r]=o[s+r]*i+o[e+r]*t;return n}}),THREE.QuaternionLinearInterpolant=function(e,t,i,r){THREE.Interpolant.call(this,e,t,i,r)},THREE.QuaternionLinearInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.QuaternionLinearInterpolant,interpolate_:function(e,t,i,r){var n=this.resultBuffer,o=this.sampleValues,a=this.valueSize;for(e*=a,t=(i-t)/(r-t),i=e+a;e!==i;e+=4)THREE.Quaternion.slerpFlat(n,0,o,e-a,o,e,t);return n}}),THREE.Clock=function(e){this.autoStart=void 0!==e?e:!0,this.elapsedTime=this.oldTime=this.startTime=0,this.running=!1},THREE.Clock.prototype={constructor:THREE.Clock,start:function(){this.oldTime=this.startTime=(performance||Date).now(),this.running=!0},stop:function(){this.getElapsedTime(),this.running=!1},getElapsedTime:function(){return this.getDelta(),this.elapsedTime},getDelta:function(){var e=0;if(this.autoStart&&!this.running&&this.start(),this.running){var t=(performance||Date).now(),e=(t-this.oldTime)/1e3;this.oldTime=t,this.elapsedTime+=e}return e}},THREE.EventDispatcher=function(){},Object.assign(THREE.EventDispatcher.prototype,{addEventListener:function(e,t){void 0===this._listeners&&(this._listeners={});var i=this._listeners;void 0===i[e]&&(i[e]=[]),-1===i[e].indexOf(t)&&i[e].push(t)},hasEventListener:function(e,t){if(void 0===this._listeners)return!1;var i=this._listeners;return void 0!==i[e]&&-1!==i[e].indexOf(t)},removeEventListener:function(e,t){if(void 0!==this._listeners){var i=this._listeners[e];if(void 0!==i){var r=i.indexOf(t);-1!==r&&i.splice(r,1)}}},dispatchEvent:function(e){if(void 0!==this._listeners){var t=this._listeners[e.type];if(void 0!==t){e.target=this;for(var i=[],r=0,n=t.length,r=0;n>r;r++)i[r]=t[r];for(r=0;n>r;r++)i[r].call(this,e)}}}}),THREE.Layers=function(){this.mask=1},THREE.Layers.prototype={constructor:THREE.Layers,set:function(e){this.mask=1<<e},enable:function(e){this.mask|=1<<e},toggle:function(e){this.mask^=1<<e},disable:function(e){this.mask&=~(1<<e)},test:function(e){return 0!==(this.mask&e.mask)}},function(e){function t(e,t){return e.distance-t.distance}function i(e,t,r,n){if(!1!==e.visible&&(e.raycast(t,r),!0===n)){e=e.children,n=0;for(var o=e.length;o>n;n++)i(e[n],t,r,!0)}}e.Raycaster=function(t,i,r,n){this.ray=new e.Ray(t,i),this.near=r||0,this.far=n||1/0,this.params={Mesh:{},Line:{},LOD:{},Points:{threshold:1},Sprite:{}},Object.defineProperties(this.params,{PointCloud:{get:function(){return console.warn("THREE.Raycaster: params.PointCloud has been renamed to params.Points."),this.Points}}})},e.Raycaster.prototype={constructor:e.Raycaster,linePrecision:1,set:function(e,t){this.ray.set(e,t)},setFromCamera:function(t,i){i instanceof e.PerspectiveCamera?(this.ray.origin.setFromMatrixPosition(i.matrixWorld),this.ray.direction.set(t.x,t.y,.5).unproject(i).sub(this.ray.origin).normalize()):i instanceof e.OrthographicCamera?(this.ray.origin.set(t.x,t.y,-1).unproject(i),this.ray.direction.set(0,0,-1).transformDirection(i.matrixWorld)):console.error("THREE.Raycaster: Unsupported camera type.")},intersectObject:function(e,r){var n=[];return i(e,this,n,r),n.sort(t),n},intersectObjects:function(e,r){var n=[];if(!1===Array.isArray(e))return console.warn("THREE.Raycaster.intersectObjects: objects is not an Array."),n;for(var o=0,a=e.length;a>o;o++)i(e[o],this,n,r);return n.sort(t),n}}}(THREE),THREE.Object3D=function(){Object.defineProperty(this,"id",{value:THREE.Object3DIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=THREE.Object3D.DefaultUp.clone();var e=new THREE.Vector3,t=new THREE.Euler,i=new THREE.Quaternion,r=new THREE.Vector3(1,1,1);t.onChange(function(){i.setFromEuler(t,!1)}),i.onChange(function(){t.setFromQuaternion(i,void 0,!1)}),Object.defineProperties(this,{position:{enumerable:!0,value:e},rotation:{enumerable:!0,value:t},quaternion:{enumerable:!0,value:i},scale:{enumerable:!0,value:r},modelViewMatrix:{value:new THREE.Matrix4},normalMatrix:{value:new THREE.Matrix3}}),this.matrix=new THREE.Matrix4,this.matrixWorld=new THREE.Matrix4,this.matrixAutoUpdate=THREE.Object3D.DefaultMatrixAutoUpdate,this.matrixWorldNeedsUpdate=!1,this.layers=new THREE.Layers,this.visible=!0,this.receiveShadow=this.castShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.userData={}},THREE.Object3D.DefaultUp=new THREE.Vector3(0,1,0),THREE.Object3D.DefaultMatrixAutoUpdate=!0,Object.assign(THREE.Object3D.prototype,THREE.EventDispatcher.prototype,{applyMatrix:function(e){this.matrix.multiplyMatrices(e,this.matrix),this.matrix.decompose(this.position,this.quaternion,this.scale)},setRotationFromAxisAngle:function(e,t){this.quaternion.setFromAxisAngle(e,t)},setRotationFromEuler:function(e){this.quaternion.setFromEuler(e,!0)},setRotationFromMatrix:function(e){this.quaternion.setFromRotationMatrix(e)},setRotationFromQuaternion:function(e){this.quaternion.copy(e)},rotateOnAxis:function(){var e=new THREE.Quaternion;return function(t,i){return e.setFromAxisAngle(t,i),this.quaternion.multiply(e),this}}(),rotateX:function(){var e=new THREE.Vector3(1,0,0);return function(t){return this.rotateOnAxis(e,t)}}(),rotateY:function(){var e=new THREE.Vector3(0,1,0);return function(t){return this.rotateOnAxis(e,t)}}(),rotateZ:function(){var e=new THREE.Vector3(0,0,1);return function(t){return this.rotateOnAxis(e,t)}}(),translateOnAxis:function(){var e=new THREE.Vector3;return function(t,i){return e.copy(t).applyQuaternion(this.quaternion),this.position.add(e.multiplyScalar(i)),this}}(),translateX:function(){var e=new THREE.Vector3(1,0,0);return function(t){return this.translateOnAxis(e,t)}}(),translateY:function(){var e=new THREE.Vector3(0,1,0);return function(t){return this.translateOnAxis(e,t)}}(),translateZ:function(){var e=new THREE.Vector3(0,0,1);return function(t){return this.translateOnAxis(e,t)}}(),localToWorld:function(e){return e.applyMatrix4(this.matrixWorld)},worldToLocal:function(){var e=new THREE.Matrix4;return function(t){return t.applyMatrix4(e.getInverse(this.matrixWorld))}}(),lookAt:function(){var e=new THREE.Matrix4;return function(t){e.lookAt(t,this.position,this.up),this.quaternion.setFromRotationMatrix(e)}}(),add:function(e){if(1<arguments.length){for(var t=0;t<arguments.length;t++)this.add(arguments[t]);return this}return e===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",e),this):(e instanceof THREE.Object3D?(null!==e.parent&&e.parent.remove(e),e.parent=this,e.dispatchEvent({type:"added"}),this.children.push(e)):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",e),this)},remove:function(e){if(1<arguments.length)for(var t=0;t<arguments.length;t++)this.remove(arguments[t]);t=this.children.indexOf(e),-1!==t&&(e.parent=null,e.dispatchEvent({type:"removed"}),this.children.splice(t,1))},getObjectById:function(e){return this.getObjectByProperty("id",e)},getObjectByName:function(e){return this.getObjectByProperty("name",e)},getObjectByProperty:function(e,t){if(this[e]===t)return this;for(var i=0,r=this.children.length;r>i;i++){var n=this.children[i].getObjectByProperty(e,t);if(void 0!==n)return n}},getWorldPosition:function(e){return e=e||new THREE.Vector3,this.updateMatrixWorld(!0),e.setFromMatrixPosition(this.matrixWorld)},getWorldQuaternion:function(){var e=new THREE.Vector3,t=new THREE.Vector3;return function(i){return i=i||new THREE.Quaternion,this.updateMatrixWorld(!0),this.matrixWorld.decompose(e,i,t),i}}(),getWorldRotation:function(){var e=new THREE.Quaternion;return function(t){return t=t||new THREE.Euler,this.getWorldQuaternion(e),t.setFromQuaternion(e,this.rotation.order,!1)}}(),getWorldScale:function(){var e=new THREE.Vector3,t=new THREE.Quaternion;return function(i){return i=i||new THREE.Vector3,this.updateMatrixWorld(!0),this.matrixWorld.decompose(e,t,i),i}}(),getWorldDirection:function(){var e=new THREE.Quaternion;return function(t){return t=t||new THREE.Vector3,this.getWorldQuaternion(e),t.set(0,0,1).applyQuaternion(e)}}(),raycast:function(){},traverse:function(e){e(this);for(var t=this.children,i=0,r=t.length;r>i;i++)t[i].traverse(e)},traverseVisible:function(e){if(!1!==this.visible){e(this);for(var t=this.children,i=0,r=t.length;r>i;i++)t[i].traverseVisible(e)}},traverseAncestors:function(e){var t=this.parent;null!==t&&(e(t),t.traverseAncestors(e))},updateMatrix:function(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(e){!0===this.matrixAutoUpdate&&this.updateMatrix(),!0!==this.matrixWorldNeedsUpdate&&!0!==e||(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.matrixWorldNeedsUpdate=!1,e=!0);for(var t=0,i=this.children.length;i>t;t++)this.children[t].updateMatrixWorld(e)},toJSON:function(e){function t(e){var t,i=[];for(t in e){var r=e[t];delete r.metadata,i.push(r)}return i}var i=void 0===e||""===e,r={};i&&(e={geometries:{},materials:{},textures:{},images:{}},r.metadata={version:4.4,type:"Object",generator:"Object3D.toJSON"});var n={};if(n.uuid=this.uuid,n.type=this.type,""!==this.name&&(n.name=this.name),"{}"!==JSON.stringify(this.userData)&&(n.userData=this.userData),!0===this.castShadow&&(n.castShadow=!0),!0===this.receiveShadow&&(n.receiveShadow=!0),!1===this.visible&&(n.visible=!1),n.matrix=this.matrix.toArray(),void 0!==this.geometry&&(void 0===e.geometries[this.geometry.uuid]&&(e.geometries[this.geometry.uuid]=this.geometry.toJSON(e)),n.geometry=this.geometry.uuid),void 0!==this.material&&(void 0===e.materials[this.material.uuid]&&(e.materials[this.material.uuid]=this.material.toJSON(e)),n.material=this.material.uuid),0<this.children.length){n.children=[];for(var o=0;o<this.children.length;o++)n.children.push(this.children[o].toJSON(e).object)}if(i){var i=t(e.geometries),o=t(e.materials),a=t(e.textures);e=t(e.images),0<i.length&&(r.geometries=i),0<o.length&&(r.materials=o),0<a.length&&(r.textures=a),0<e.length&&(r.images=e)}return r.object=n,r},clone:function(e){return(new this.constructor).copy(this,e)},copy:function(e,t){if(void 0===t&&(t=!0),this.name=e.name,this.up.copy(e.up),this.position.copy(e.position),this.quaternion.copy(e.quaternion),this.scale.copy(e.scale),this.matrix.copy(e.matrix),this.matrixWorld.copy(e.matrixWorld),this.matrixAutoUpdate=e.matrixAutoUpdate,this.matrixWorldNeedsUpdate=e.matrixWorldNeedsUpdate,this.visible=e.visible,this.castShadow=e.castShadow,this.receiveShadow=e.receiveShadow,this.frustumCulled=e.frustumCulled,this.renderOrder=e.renderOrder,this.userData=JSON.parse(JSON.stringify(e.userData)),!0===t)for(var i=0;i<e.children.length;i++)this.add(e.children[i].clone());return this}}),THREE.Object3DIdCount=0,THREE.Face3=function(e,t,i,r,n,o){this.a=e,this.b=t,this.c=i,this.normal=r instanceof THREE.Vector3?r:new THREE.Vector3,this.vertexNormals=Array.isArray(r)?r:[],this.color=n instanceof THREE.Color?n:new THREE.Color,this.vertexColors=Array.isArray(n)?n:[],this.materialIndex=void 0!==o?o:0},THREE.Face3.prototype={constructor:THREE.Face3,clone:function(){return(new this.constructor).copy(this)},copy:function(e){this.a=e.a,this.b=e.b,this.c=e.c,this.normal.copy(e.normal),this.color.copy(e.color),this.materialIndex=e.materialIndex;for(var t=0,i=e.vertexNormals.length;i>t;t++)this.vertexNormals[t]=e.vertexNormals[t].clone();for(t=0,i=e.vertexColors.length;i>t;t++)this.vertexColors[t]=e.vertexColors[t].clone();return this}},THREE.BufferAttribute=function(e,t,i){this.uuid=THREE.Math.generateUUID(),this.array=e,this.itemSize=t,this.dynamic=!1,this.updateRange={offset:0,count:-1},this.version=0,this.normalized=!0===i},THREE.BufferAttribute.prototype={constructor:THREE.BufferAttribute,get count(){return this.array.length/this.itemSize},set needsUpdate(e){!0===e&&this.version++},setDynamic:function(e){return this.dynamic=e,this},copy:function(e){return this.array=new e.array.constructor(e.array),this.itemSize=e.itemSize,this.dynamic=e.dynamic,this},copyAt:function(e,t,i){e*=this.itemSize,i*=t.itemSize;for(var r=0,n=this.itemSize;n>r;r++)this.array[e+r]=t.array[i+r];return this},copyArray:function(e){return this.array.set(e),this},copyColorsArray:function(e){for(var t=this.array,i=0,r=0,n=e.length;n>r;r++){var o=e[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyColorsArray(): color is undefined",r),o=new THREE.Color),t[i++]=o.r,t[i++]=o.g,t[i++]=o.b}return this},copyIndicesArray:function(e){for(var t=this.array,i=0,r=0,n=e.length;n>r;r++){var o=e[r];t[i++]=o.a,t[i++]=o.b,t[i++]=o.c}return this},copyVector2sArray:function(e){for(var t=this.array,i=0,r=0,n=e.length;n>r;r++){var o=e[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector2sArray(): vector is undefined",r),o=new THREE.Vector2),t[i++]=o.x,t[i++]=o.y}return this},copyVector3sArray:function(e){for(var t=this.array,i=0,r=0,n=e.length;n>r;r++){var o=e[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector3sArray(): vector is undefined",r),o=new THREE.Vector3),t[i++]=o.x,t[i++]=o.y,t[i++]=o.z}return this},copyVector4sArray:function(e){for(var t=this.array,i=0,r=0,n=e.length;n>r;r++){var o=e[r];void 0===o&&(console.warn("THREE.BufferAttribute.copyVector4sArray(): vector is undefined",r),o=new THREE.Vector4),t[i++]=o.x,t[i++]=o.y,t[i++]=o.z,t[i++]=o.w}return this},set:function(e,t){return void 0===t&&(t=0),this.array.set(e,t),this},getX:function(e){return this.array[e*this.itemSize]},setX:function(e,t){return this.array[e*this.itemSize]=t,this},getY:function(e){return this.array[e*this.itemSize+1]},setY:function(e,t){return this.array[e*this.itemSize+1]=t,this},getZ:function(e){return this.array[e*this.itemSize+2]},setZ:function(e,t){return this.array[e*this.itemSize+2]=t,this},getW:function(e){return this.array[e*this.itemSize+3]},setW:function(e,t){return this.array[e*this.itemSize+3]=t,this},setXY:function(e,t,i){return e*=this.itemSize,this.array[e+0]=t,this.array[e+1]=i,this},setXYZ:function(e,t,i,r){return e*=this.itemSize,this.array[e+0]=t,this.array[e+1]=i,this.array[e+2]=r,this},setXYZW:function(e,t,i,r,n){return e*=this.itemSize,this.array[e+0]=t,this.array[e+1]=i,this.array[e+2]=r,this.array[e+3]=n,this},clone:function(){return(new this.constructor).copy(this)}},THREE.Int8Attribute=function(e,t){return new THREE.BufferAttribute(new Int8Array(e),t)},THREE.Uint8Attribute=function(e,t){return new THREE.BufferAttribute(new Uint8Array(e),t)},THREE.Uint8ClampedAttribute=function(e,t){return new THREE.BufferAttribute(new Uint8ClampedArray(e),t)},THREE.Int16Attribute=function(e,t){return new THREE.BufferAttribute(new Int16Array(e),t)},THREE.Uint16Attribute=function(e,t){return new THREE.BufferAttribute(new Uint16Array(e),t)},THREE.Int32Attribute=function(e,t){return new THREE.BufferAttribute(new Int32Array(e),t)},THREE.Uint32Attribute=function(e,t){return new THREE.BufferAttribute(new Uint32Array(e),t)},THREE.Float32Attribute=function(e,t){return new THREE.BufferAttribute(new Float32Array(e),t)},THREE.Float64Attribute=function(e,t){return new THREE.BufferAttribute(new Float64Array(e),t)},THREE.DynamicBufferAttribute=function(e,t){return console.warn("THREE.DynamicBufferAttribute has been removed. Use new THREE.BufferAttribute().setDynamic( true ) instead."),new THREE.BufferAttribute(e,t).setDynamic(!0)},THREE.InstancedBufferAttribute=function(e,t,i){THREE.BufferAttribute.call(this,e,t),this.meshPerAttribute=i||1},THREE.InstancedBufferAttribute.prototype=Object.create(THREE.BufferAttribute.prototype),THREE.InstancedBufferAttribute.prototype.constructor=THREE.InstancedBufferAttribute,THREE.InstancedBufferAttribute.prototype.copy=function(e){return THREE.BufferAttribute.prototype.copy.call(this,e),this.meshPerAttribute=e.meshPerAttribute,this},THREE.InterleavedBuffer=function(e,t){this.uuid=THREE.Math.generateUUID(),this.array=e,this.stride=t,this.dynamic=!1,this.updateRange={offset:0,count:-1},this.version=0},THREE.InterleavedBuffer.prototype={constructor:THREE.InterleavedBuffer,get length(){return this.array.length},get count(){return this.array.length/this.stride},set needsUpdate(e){!0===e&&this.version++},setDynamic:function(e){return this.dynamic=e,this},copy:function(e){return this.array=new e.array.constructor(e.array),this.stride=e.stride,this.dynamic=e.dynamic,this},copyAt:function(e,t,i){e*=this.stride,i*=t.stride;for(var r=0,n=this.stride;n>r;r++)this.array[e+r]=t.array[i+r];return this},set:function(e,t){return void 0===t&&(t=0),this.array.set(e,t),this},clone:function(){return(new this.constructor).copy(this)}},THREE.InstancedInterleavedBuffer=function(e,t,i){THREE.InterleavedBuffer.call(this,e,t),this.meshPerAttribute=i||1},THREE.InstancedInterleavedBuffer.prototype=Object.create(THREE.InterleavedBuffer.prototype),THREE.InstancedInterleavedBuffer.prototype.constructor=THREE.InstancedInterleavedBuffer,THREE.InstancedInterleavedBuffer.prototype.copy=function(e){return THREE.InterleavedBuffer.prototype.copy.call(this,e),this.meshPerAttribute=e.meshPerAttribute,this},THREE.InterleavedBufferAttribute=function(e,t,i){this.uuid=THREE.Math.generateUUID(),this.data=e,this.itemSize=t,this.offset=i},THREE.InterleavedBufferAttribute.prototype={constructor:THREE.InterleavedBufferAttribute,get length(){return console.warn("THREE.BufferAttribute: .length has been deprecated. Please use .count."),this.array.length},get count(){return this.data.count},setX:function(e,t){return this.data.array[e*this.data.stride+this.offset]=t,this},setY:function(e,t){return this.data.array[e*this.data.stride+this.offset+1]=t,this},setZ:function(e,t){return this.data.array[e*this.data.stride+this.offset+2]=t,this},setW:function(e,t){return this.data.array[e*this.data.stride+this.offset+3]=t,this},getX:function(e){return this.data.array[e*this.data.stride+this.offset]},getY:function(e){return this.data.array[e*this.data.stride+this.offset+1]},getZ:function(e){return this.data.array[e*this.data.stride+this.offset+2]},getW:function(e){return this.data.array[e*this.data.stride+this.offset+3]},setXY:function(e,t,i){return e=e*this.data.stride+this.offset,this.data.array[e+0]=t,this.data.array[e+1]=i,this},setXYZ:function(e,t,i,r){return e=e*this.data.stride+this.offset,this.data.array[e+0]=t,this.data.array[e+1]=i,this.data.array[e+2]=r,this},setXYZW:function(e,t,i,r,n){return e=e*this.data.stride+this.offset,this.data.array[e+0]=t,this.data.array[e+1]=i,this.data.array[e+2]=r,this.data.array[e+3]=n,this}},THREE.Geometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="Geometry",this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingSphere=this.boundingBox=null,this.groupsNeedUpdate=this.lineDistancesNeedUpdate=this.colorsNeedUpdate=this.normalsNeedUpdate=this.uvsNeedUpdate=this.elementsNeedUpdate=this.verticesNeedUpdate=!1;
},Object.assign(THREE.Geometry.prototype,THREE.EventDispatcher.prototype,{applyMatrix:function(e){for(var t=(new THREE.Matrix3).getNormalMatrix(e),i=0,r=this.vertices.length;r>i;i++)this.vertices[i].applyMatrix4(e);for(i=0,r=this.faces.length;r>i;i++){e=this.faces[i],e.normal.applyMatrix3(t).normalize();for(var n=0,o=e.vertexNormals.length;o>n;n++)e.vertexNormals[n].applyMatrix3(t).normalize()}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this.normalsNeedUpdate=this.verticesNeedUpdate=!0,this},rotateX:function(){var e;return function(t){return void 0===e&&(e=new THREE.Matrix4),e.makeRotationX(t),this.applyMatrix(e),this}}(),rotateY:function(){var e;return function(t){return void 0===e&&(e=new THREE.Matrix4),e.makeRotationY(t),this.applyMatrix(e),this}}(),rotateZ:function(){var e;return function(t){return void 0===e&&(e=new THREE.Matrix4),e.makeRotationZ(t),this.applyMatrix(e),this}}(),translate:function(){var e;return function(t,i,r){return void 0===e&&(e=new THREE.Matrix4),e.makeTranslation(t,i,r),this.applyMatrix(e),this}}(),scale:function(){var e;return function(t,i,r){return void 0===e&&(e=new THREE.Matrix4),e.makeScale(t,i,r),this.applyMatrix(e),this}}(),lookAt:function(){var e;return function(t){void 0===e&&(e=new THREE.Object3D),e.lookAt(t),e.updateMatrix(),this.applyMatrix(e.matrix)}}(),fromBufferGeometry:function(e){function t(e,t,r,n){var o=void 0!==a?[l[e].clone(),l[t].clone(),l[r].clone()]:[],d=void 0!==s?[i.colors[e].clone(),i.colors[t].clone(),i.colors[r].clone()]:[];n=new THREE.Face3(e,t,r,o,d,n),i.faces.push(n),void 0!==c&&i.faceVertexUvs[0].push([u[e].clone(),u[t].clone(),u[r].clone()]),void 0!==h&&i.faceVertexUvs[1].push([p[e].clone(),p[t].clone(),p[r].clone()])}var i=this,r=null!==e.index?e.index.array:void 0,n=e.attributes,o=n.position.array,a=void 0!==n.normal?n.normal.array:void 0,s=void 0!==n.color?n.color.array:void 0,c=void 0!==n.uv?n.uv.array:void 0,h=void 0!==n.uv2?n.uv2.array:void 0;void 0!==h&&(this.faceVertexUvs[1]=[]);for(var l=[],u=[],p=[],d=n=0;n<o.length;n+=3,d+=2)i.vertices.push(new THREE.Vector3(o[n],o[n+1],o[n+2])),void 0!==a&&l.push(new THREE.Vector3(a[n],a[n+1],a[n+2])),void 0!==s&&i.colors.push(new THREE.Color(s[n],s[n+1],s[n+2])),void 0!==c&&u.push(new THREE.Vector2(c[d],c[d+1])),void 0!==h&&p.push(new THREE.Vector2(h[d],h[d+1]));if(void 0!==r)if(o=e.groups,0<o.length)for(n=0;n<o.length;n++)for(var f=o[n],E=f.start,m=f.count,d=E,E=E+m;E>d;d+=3)t(r[d],r[d+1],r[d+2],f.materialIndex);else for(n=0;n<r.length;n+=3)t(r[n],r[n+1],r[n+2]);else for(n=0;n<o.length/3;n+=3)t(n,n+1,n+2);return this.computeFaceNormals(),null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone()),null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),this},center:function(){this.computeBoundingBox();var e=this.boundingBox.center().negate();return this.translate(e.x,e.y,e.z),e},normalize:function(){this.computeBoundingSphere();var e=this.boundingSphere.center,t=this.boundingSphere.radius,t=0===t?1:1/t,i=new THREE.Matrix4;return i.set(t,0,0,-t*e.x,0,t,0,-t*e.y,0,0,t,-t*e.z,0,0,0,1),this.applyMatrix(i),this},computeFaceNormals:function(){for(var e=new THREE.Vector3,t=new THREE.Vector3,i=0,r=this.faces.length;r>i;i++){var n=this.faces[i],o=this.vertices[n.a],a=this.vertices[n.b];e.subVectors(this.vertices[n.c],a),t.subVectors(o,a),e.cross(t),e.normalize(),n.normal.copy(e)}},computeVertexNormals:function(e){void 0===e&&(e=!0);var t,i,r;for(r=Array(this.vertices.length),t=0,i=this.vertices.length;i>t;t++)r[t]=new THREE.Vector3;if(e){var n,o,a,s=new THREE.Vector3,c=new THREE.Vector3;for(e=0,t=this.faces.length;t>e;e++)i=this.faces[e],n=this.vertices[i.a],o=this.vertices[i.b],a=this.vertices[i.c],s.subVectors(a,o),c.subVectors(n,o),s.cross(c),r[i.a].add(s),r[i.b].add(s),r[i.c].add(s)}else for(e=0,t=this.faces.length;t>e;e++)i=this.faces[e],r[i.a].add(i.normal),r[i.b].add(i.normal),r[i.c].add(i.normal);for(t=0,i=this.vertices.length;i>t;t++)r[t].normalize();for(e=0,t=this.faces.length;t>e;e++)i=this.faces[e],n=i.vertexNormals,3===n.length?(n[0].copy(r[i.a]),n[1].copy(r[i.b]),n[2].copy(r[i.c])):(n[0]=r[i.a].clone(),n[1]=r[i.b].clone(),n[2]=r[i.c].clone());0<this.faces.length&&(this.normalsNeedUpdate=!0)},computeMorphNormals:function(){var e,t,i,r,n;for(i=0,r=this.faces.length;r>i;i++)for(n=this.faces[i],n.__originalFaceNormal?n.__originalFaceNormal.copy(n.normal):n.__originalFaceNormal=n.normal.clone(),n.__originalVertexNormals||(n.__originalVertexNormals=[]),e=0,t=n.vertexNormals.length;t>e;e++)n.__originalVertexNormals[e]?n.__originalVertexNormals[e].copy(n.vertexNormals[e]):n.__originalVertexNormals[e]=n.vertexNormals[e].clone();var o=new THREE.Geometry;for(o.faces=this.faces,e=0,t=this.morphTargets.length;t>e;e++){if(!this.morphNormals[e]){this.morphNormals[e]={},this.morphNormals[e].faceNormals=[],this.morphNormals[e].vertexNormals=[],n=this.morphNormals[e].faceNormals;var a,s,c=this.morphNormals[e].vertexNormals;for(i=0,r=this.faces.length;r>i;i++)a=new THREE.Vector3,s={a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3},n.push(a),c.push(s)}for(c=this.morphNormals[e],o.vertices=this.morphTargets[e].vertices,o.computeFaceNormals(),o.computeVertexNormals(),i=0,r=this.faces.length;r>i;i++)n=this.faces[i],a=c.faceNormals[i],s=c.vertexNormals[i],a.copy(n.normal),s.a.copy(n.vertexNormals[0]),s.b.copy(n.vertexNormals[1]),s.c.copy(n.vertexNormals[2])}for(i=0,r=this.faces.length;r>i;i++)n=this.faces[i],n.normal=n.__originalFaceNormal,n.vertexNormals=n.__originalVertexNormals},computeTangents:function(){console.warn("THREE.Geometry: .computeTangents() has been removed.")},computeLineDistances:function(){for(var e=0,t=this.vertices,i=0,r=t.length;r>i;i++)i>0&&(e+=t[i].distanceTo(t[i-1])),this.lineDistances[i]=e},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new THREE.Box3),this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new THREE.Sphere),this.boundingSphere.setFromPoints(this.vertices)},merge:function(e,t,i){if(!1==e instanceof THREE.Geometry)console.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",e);else{var r,n=this.vertices.length,o=this.vertices,a=e.vertices,s=this.faces,c=e.faces,h=this.faceVertexUvs[0];e=e.faceVertexUvs[0],void 0===i&&(i=0),void 0!==t&&(r=(new THREE.Matrix3).getNormalMatrix(t));for(var l=0,u=a.length;u>l;l++){var p=a[l].clone();void 0!==t&&p.applyMatrix4(t),o.push(p)}for(l=0,u=c.length;u>l;l++){var d,a=c[l],f=a.vertexNormals,E=a.vertexColors,p=new THREE.Face3(a.a+n,a.b+n,a.c+n);for(p.normal.copy(a.normal),void 0!==r&&p.normal.applyMatrix3(r).normalize(),t=0,o=f.length;o>t;t++)d=f[t].clone(),void 0!==r&&d.applyMatrix3(r).normalize(),p.vertexNormals.push(d);for(p.color.copy(a.color),t=0,o=E.length;o>t;t++)d=E[t],p.vertexColors.push(d.clone());p.materialIndex=a.materialIndex+i,s.push(p)}for(l=0,u=e.length;u>l;l++)if(i=e[l],r=[],void 0!==i){for(t=0,o=i.length;o>t;t++)r.push(i[t].clone());h.push(r)}}},mergeMesh:function(e){!1==e instanceof THREE.Mesh?console.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",e):(e.matrixAutoUpdate&&e.updateMatrix(),this.merge(e.geometry,e.matrix))},mergeVertices:function(){var e,t,i,r={},n=[],o=[],a=Math.pow(10,4);for(t=0,i=this.vertices.length;i>t;t++)e=this.vertices[t],e=Math.round(e.x*a)+"_"+Math.round(e.y*a)+"_"+Math.round(e.z*a),void 0===r[e]?(r[e]=t,n.push(this.vertices[t]),o[t]=n.length-1):o[t]=o[r[e]];for(r=[],t=0,i=this.faces.length;i>t;t++)for(a=this.faces[t],a.a=o[a.a],a.b=o[a.b],a.c=o[a.c],a=[a.a,a.b,a.c],e=0;3>e;e++)if(a[e]===a[(e+1)%3]){r.push(t);break}for(t=r.length-1;t>=0;t--)for(a=r[t],this.faces.splice(a,1),o=0,i=this.faceVertexUvs.length;i>o;o++)this.faceVertexUvs[o].splice(a,1);return t=this.vertices.length-n.length,this.vertices=n,t},sortFacesByMaterialIndex:function(){for(var e=this.faces,t=e.length,i=0;t>i;i++)e[i]._id=i;e.sort(function(e,t){return e.materialIndex-t.materialIndex});var r,n,o=this.faceVertexUvs[0],a=this.faceVertexUvs[1];for(o&&o.length===t&&(r=[]),a&&a.length===t&&(n=[]),i=0;t>i;i++){var s=e[i]._id;r&&r.push(o[s]),n&&n.push(a[s])}r&&(this.faceVertexUvs[0]=r),n&&(this.faceVertexUvs[1]=n)},toJSON:function(){function e(e,t,i){return i?e|1<<t:e&~(1<<t)}function t(e){var t=e.x.toString()+e.y.toString()+e.z.toString();return void 0!==h[t]?h[t]:(h[t]=c.length/3,c.push(e.x,e.y,e.z),h[t])}function i(e){var t=e.r.toString()+e.g.toString()+e.b.toString();return void 0!==u[t]?u[t]:(u[t]=l.length,l.push(e.getHex()),u[t])}function r(e){var t=e.x.toString()+e.y.toString();return void 0!==d[t]?d[t]:(d[t]=p.length/2,p.push(e.x,e.y),d[t])}var n={metadata:{version:4.4,type:"Geometry",generator:"Geometry.toJSON"}};if(n.uuid=this.uuid,n.type=this.type,""!==this.name&&(n.name=this.name),void 0!==this.parameters){var o,a=this.parameters;for(o in a)void 0!==a[o]&&(n[o]=a[o]);return n}for(a=[],o=0;o<this.vertices.length;o++){var s=this.vertices[o];a.push(s.x,s.y,s.z)}var s=[],c=[],h={},l=[],u={},p=[],d={};for(o=0;o<this.faces.length;o++){var f=this.faces[o],E=void 0!==this.faceVertexUvs[0][o],m=0<f.normal.length(),g=0<f.vertexNormals.length,T=1!==f.color.r||1!==f.color.g||1!==f.color.b,v=0<f.vertexColors.length,y=0,y=e(y,0,0),y=e(y,1,!0),y=e(y,2,!1),y=e(y,3,E),y=e(y,4,m),y=e(y,5,g),y=e(y,6,T),y=e(y,7,v);s.push(y),s.push(f.a,f.b,f.c),s.push(f.materialIndex),E&&(E=this.faceVertexUvs[0][o],s.push(r(E[0]),r(E[1]),r(E[2]))),m&&s.push(t(f.normal)),g&&(m=f.vertexNormals,s.push(t(m[0]),t(m[1]),t(m[2]))),T&&s.push(i(f.color)),v&&(f=f.vertexColors,s.push(i(f[0]),i(f[1]),i(f[2])))}return n.data={},n.data.vertices=a,n.data.normals=c,0<l.length&&(n.data.colors=l),0<p.length&&(n.data.uvs=[p]),n.data.faces=s,n},clone:function(){return(new THREE.Geometry).copy(this)},copy:function(e){this.vertices=[],this.faces=[],this.faceVertexUvs=[[]];for(var t=e.vertices,i=0,r=t.length;r>i;i++)this.vertices.push(t[i].clone());for(t=e.faces,i=0,r=t.length;r>i;i++)this.faces.push(t[i].clone());for(i=0,r=e.faceVertexUvs.length;r>i;i++){t=e.faceVertexUvs[i],void 0===this.faceVertexUvs[i]&&(this.faceVertexUvs[i]=[]);for(var n=0,o=t.length;o>n;n++){for(var a=t[n],s=[],c=0,h=a.length;h>c;c++)s.push(a[c].clone());this.faceVertexUvs[i].push(s)}}return this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),THREE.GeometryIdCount=0,THREE.DirectGeometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="DirectGeometry",this.indices=[],this.vertices=[],this.normals=[],this.colors=[],this.uvs=[],this.uvs2=[],this.groups=[],this.morphTargets={},this.skinWeights=[],this.skinIndices=[],this.boundingSphere=this.boundingBox=null,this.groupsNeedUpdate=this.uvsNeedUpdate=this.colorsNeedUpdate=this.normalsNeedUpdate=this.verticesNeedUpdate=!1},Object.assign(THREE.DirectGeometry.prototype,THREE.EventDispatcher.prototype,{computeBoundingBox:THREE.Geometry.prototype.computeBoundingBox,computeBoundingSphere:THREE.Geometry.prototype.computeBoundingSphere,computeFaceNormals:function(){console.warn("THREE.DirectGeometry: computeFaceNormals() is not a method of this type of geometry.")},computeVertexNormals:function(){console.warn("THREE.DirectGeometry: computeVertexNormals() is not a method of this type of geometry.")},computeGroups:function(e){var t,i,r=[];e=e.faces;for(var n=0;n<e.length;n++){var o=e[n];o.materialIndex!==i&&(i=o.materialIndex,void 0!==t&&(t.count=3*n-t.start,r.push(t)),t={start:3*n,materialIndex:i})}void 0!==t&&(t.count=3*n-t.start,r.push(t)),this.groups=r},fromGeometry:function(e){var t,i=e.faces,r=e.vertices,n=e.faceVertexUvs,o=n[0]&&0<n[0].length,a=n[1]&&0<n[1].length,s=e.morphTargets,c=s.length;if(c>0){t=[];for(var h=0;c>h;h++)t[h]=[];this.morphTargets.position=t}var l,u=e.morphNormals,p=u.length;if(p>0){for(l=[],h=0;p>h;h++)l[h]=[];this.morphTargets.normal=l}for(var d=e.skinIndices,f=e.skinWeights,E=d.length===r.length,m=f.length===r.length,h=0;h<i.length;h++){var g=i[h];this.vertices.push(r[g.a],r[g.b],r[g.c]);var T=g.vertexNormals;for(3===T.length?this.normals.push(T[0],T[1],T[2]):(T=g.normal,this.normals.push(T,T,T)),T=g.vertexColors,3===T.length?this.colors.push(T[0],T[1],T[2]):(T=g.color,this.colors.push(T,T,T)),!0===o&&(T=n[0][h],void 0!==T?this.uvs.push(T[0],T[1],T[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ",h),this.uvs.push(new THREE.Vector2,new THREE.Vector2,new THREE.Vector2))),!0===a&&(T=n[1][h],void 0!==T?this.uvs2.push(T[0],T[1],T[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ",h),this.uvs2.push(new THREE.Vector2,new THREE.Vector2,new THREE.Vector2))),T=0;c>T;T++){var v=s[T].vertices;t[T].push(v[g.a],v[g.b],v[g.c])}for(T=0;p>T;T++)v=u[T].vertexNormals[h],l[T].push(v.a,v.b,v.c);E&&this.skinIndices.push(d[g.a],d[g.b],d[g.c]),m&&this.skinWeights.push(f[g.a],f[g.b],f[g.c])}return this.computeGroups(e),this.verticesNeedUpdate=e.verticesNeedUpdate,this.normalsNeedUpdate=e.normalsNeedUpdate,this.colorsNeedUpdate=e.colorsNeedUpdate,this.uvsNeedUpdate=e.uvsNeedUpdate,this.groupsNeedUpdate=e.groupsNeedUpdate,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),THREE.BufferGeometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingSphere=this.boundingBox=null,this.drawRange={start:0,count:1/0}},Object.assign(THREE.BufferGeometry.prototype,THREE.EventDispatcher.prototype,{getIndex:function(){return this.index},setIndex:function(e){this.index=e},addAttribute:function(e,t,i){if(!1==t instanceof THREE.BufferAttribute&&!1==t instanceof THREE.InterleavedBufferAttribute)console.warn("THREE.BufferGeometry: .addAttribute() now expects ( name, attribute )."),this.addAttribute(e,new THREE.BufferAttribute(t,i));else{if("index"!==e)return this.attributes[e]=t,this;console.warn("THREE.BufferGeometry.addAttribute: Use .setIndex() for index attribute."),this.setIndex(t)}},getAttribute:function(e){return this.attributes[e]},removeAttribute:function(e){return delete this.attributes[e],this},addGroup:function(e,t,i){this.groups.push({start:e,count:t,materialIndex:void 0!==i?i:0})},clearGroups:function(){this.groups=[]},setDrawRange:function(e,t){this.drawRange.start=e,this.drawRange.count=t},applyMatrix:function(e){var t=this.attributes.position;return void 0!==t&&(e.applyToVector3Array(t.array),t.needsUpdate=!0),t=this.attributes.normal,void 0!==t&&((new THREE.Matrix3).getNormalMatrix(e).applyToVector3Array(t.array),t.needsUpdate=!0),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this},rotateX:function(){var e;return function(t){return void 0===e&&(e=new THREE.Matrix4),e.makeRotationX(t),this.applyMatrix(e),this}}(),rotateY:function(){var e;return function(t){return void 0===e&&(e=new THREE.Matrix4),e.makeRotationY(t),this.applyMatrix(e),this}}(),rotateZ:function(){var e;return function(t){return void 0===e&&(e=new THREE.Matrix4),e.makeRotationZ(t),this.applyMatrix(e),this}}(),translate:function(){var e;return function(t,i,r){return void 0===e&&(e=new THREE.Matrix4),e.makeTranslation(t,i,r),this.applyMatrix(e),this}}(),scale:function(){var e;return function(t,i,r){return void 0===e&&(e=new THREE.Matrix4),e.makeScale(t,i,r),this.applyMatrix(e),this}}(),lookAt:function(){var e;return function(t){void 0===e&&(e=new THREE.Object3D),e.lookAt(t),e.updateMatrix(),this.applyMatrix(e.matrix)}}(),center:function(){this.computeBoundingBox();var e=this.boundingBox.center().negate();return this.translate(e.x,e.y,e.z),e},setFromObject:function(e){var t=e.geometry;if(e instanceof THREE.Points||e instanceof THREE.Line){e=new THREE.Float32Attribute(3*t.vertices.length,3);var i=new THREE.Float32Attribute(3*t.colors.length,3);this.addAttribute("position",e.copyVector3sArray(t.vertices)),this.addAttribute("color",i.copyColorsArray(t.colors)),t.lineDistances&&t.lineDistances.length===t.vertices.length&&(e=new THREE.Float32Attribute(t.lineDistances.length,1),this.addAttribute("lineDistance",e.copyArray(t.lineDistances))),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone())}else e instanceof THREE.Mesh&&t instanceof THREE.Geometry&&this.fromGeometry(t);return this},updateFromObject:function(e){var t=e.geometry;if(e instanceof THREE.Mesh){var i=t.__directGeometry;if(void 0===i)return this.fromGeometry(t);i.verticesNeedUpdate=t.verticesNeedUpdate,i.normalsNeedUpdate=t.normalsNeedUpdate,i.colorsNeedUpdate=t.colorsNeedUpdate,i.uvsNeedUpdate=t.uvsNeedUpdate,i.groupsNeedUpdate=t.groupsNeedUpdate,t.verticesNeedUpdate=!1,t.normalsNeedUpdate=!1,t.colorsNeedUpdate=!1,t.uvsNeedUpdate=!1,t.groupsNeedUpdate=!1,t=i}return!0===t.verticesNeedUpdate&&(i=this.attributes.position,void 0!==i&&(i.copyVector3sArray(t.vertices),i.needsUpdate=!0),t.verticesNeedUpdate=!1),!0===t.normalsNeedUpdate&&(i=this.attributes.normal,void 0!==i&&(i.copyVector3sArray(t.normals),i.needsUpdate=!0),t.normalsNeedUpdate=!1),!0===t.colorsNeedUpdate&&(i=this.attributes.color,void 0!==i&&(i.copyColorsArray(t.colors),i.needsUpdate=!0),t.colorsNeedUpdate=!1),t.uvsNeedUpdate&&(i=this.attributes.uv,void 0!==i&&(i.copyVector2sArray(t.uvs),i.needsUpdate=!0),t.uvsNeedUpdate=!1),t.lineDistancesNeedUpdate&&(i=this.attributes.lineDistance,void 0!==i&&(i.copyArray(t.lineDistances),i.needsUpdate=!0),t.lineDistancesNeedUpdate=!1),t.groupsNeedUpdate&&(t.computeGroups(e.geometry),this.groups=t.groups,t.groupsNeedUpdate=!1),this},fromGeometry:function(e){return e.__directGeometry=(new THREE.DirectGeometry).fromGeometry(e),this.fromDirectGeometry(e.__directGeometry)},fromDirectGeometry:function(e){var t=new Float32Array(3*e.vertices.length);this.addAttribute("position",new THREE.BufferAttribute(t,3).copyVector3sArray(e.vertices)),0<e.normals.length&&(t=new Float32Array(3*e.normals.length),this.addAttribute("normal",new THREE.BufferAttribute(t,3).copyVector3sArray(e.normals))),0<e.colors.length&&(t=new Float32Array(3*e.colors.length),this.addAttribute("color",new THREE.BufferAttribute(t,3).copyColorsArray(e.colors))),0<e.uvs.length&&(t=new Float32Array(2*e.uvs.length),this.addAttribute("uv",new THREE.BufferAttribute(t,2).copyVector2sArray(e.uvs))),0<e.uvs2.length&&(t=new Float32Array(2*e.uvs2.length),this.addAttribute("uv2",new THREE.BufferAttribute(t,2).copyVector2sArray(e.uvs2))),0<e.indices.length&&(t=new(65535<e.vertices.length?Uint32Array:Uint16Array)(3*e.indices.length),this.setIndex(new THREE.BufferAttribute(t,1).copyIndicesArray(e.indices))),this.groups=e.groups;for(var i in e.morphTargets){for(var t=[],r=e.morphTargets[i],n=0,o=r.length;o>n;n++){var a=r[n],s=new THREE.Float32Attribute(3*a.length,3);t.push(s.copyVector3sArray(a))}this.morphAttributes[i]=t}return 0<e.skinIndices.length&&(i=new THREE.Float32Attribute(4*e.skinIndices.length,4),this.addAttribute("skinIndex",i.copyVector4sArray(e.skinIndices))),0<e.skinWeights.length&&(i=new THREE.Float32Attribute(4*e.skinWeights.length,4),this.addAttribute("skinWeight",i.copyVector4sArray(e.skinWeights))),null!==e.boundingSphere&&(this.boundingSphere=e.boundingSphere.clone()),null!==e.boundingBox&&(this.boundingBox=e.boundingBox.clone()),this},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new THREE.Box3);var e=this.attributes.position.array;void 0!==e?this.boundingBox.setFromArray(e):this.boundingBox.makeEmpty(),(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox: Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)},computeBoundingSphere:function(){var e=new THREE.Box3,t=new THREE.Vector3;return function(){null===this.boundingSphere&&(this.boundingSphere=new THREE.Sphere);var i=this.attributes.position.array;if(i){var r=this.boundingSphere.center;e.setFromArray(i),e.center(r);for(var n=0,o=0,a=i.length;a>o;o+=3)t.fromArray(i,o),n=Math.max(n,r.distanceToSquared(t));this.boundingSphere.radius=Math.sqrt(n),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}}(),computeFaceNormals:function(){},computeVertexNormals:function(){var e=this.index,t=this.attributes,i=this.groups;if(t.position){var r=t.position.array;if(void 0===t.normal)this.addAttribute("normal",new THREE.BufferAttribute(new Float32Array(r.length),3));else for(var n=t.normal.array,o=0,a=n.length;a>o;o++)n[o]=0;var s,c,h,n=t.normal.array,l=new THREE.Vector3,u=new THREE.Vector3,p=new THREE.Vector3,d=new THREE.Vector3,f=new THREE.Vector3;if(e){e=e.array,0===i.length&&this.addGroup(0,e.length);for(var E=0,m=i.length;m>E;++E)for(o=i[E],a=o.start,s=o.count,o=a,a+=s;a>o;o+=3)s=3*e[o+0],c=3*e[o+1],h=3*e[o+2],l.fromArray(r,s),u.fromArray(r,c),p.fromArray(r,h),d.subVectors(p,u),f.subVectors(l,u),d.cross(f),n[s]+=d.x,n[s+1]+=d.y,n[s+2]+=d.z,n[c]+=d.x,n[c+1]+=d.y,n[c+2]+=d.z,n[h]+=d.x,n[h+1]+=d.y,n[h+2]+=d.z}else for(o=0,a=r.length;a>o;o+=9)l.fromArray(r,o),u.fromArray(r,o+3),p.fromArray(r,o+6),d.subVectors(p,u),f.subVectors(l,u),d.cross(f),n[o]=d.x,n[o+1]=d.y,n[o+2]=d.z,n[o+3]=d.x,n[o+4]=d.y,n[o+5]=d.z,n[o+6]=d.x,n[o+7]=d.y,n[o+8]=d.z;this.normalizeNormals(),t.normal.needsUpdate=!0}},merge:function(e,t){if(!1!=e instanceof THREE.BufferGeometry){void 0===t&&(t=0);var i,r=this.attributes;for(i in r)if(void 0!==e.attributes[i])for(var n=r[i].array,o=e.attributes[i],a=o.array,s=0,o=o.itemSize*t;s<a.length;s++,o++)n[o]=a[s];return this}console.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",e)},normalizeNormals:function(){for(var e,t,i,r=this.attributes.normal.array,n=0,o=r.length;o>n;n+=3)e=r[n],t=r[n+1],i=r[n+2],e=1/Math.sqrt(e*e+t*t+i*i),r[n]*=e,r[n+1]*=e,r[n+2]*=e},toNonIndexed:function(){if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): Geometry is already non-indexed."),this;var e,t=new THREE.BufferGeometry,i=this.index.array,r=this.attributes;for(e in r){for(var n=r[e],o=n.array,n=n.itemSize,a=new o.constructor(i.length*n),s=0,c=0,h=0,l=i.length;l>h;h++)for(var s=i[h]*n,u=0;n>u;u++)a[c++]=o[s++];t.addAttribute(e,new THREE.BufferAttribute(a,n))}return t},toJSON:function(){var e={metadata:{version:4.4,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(e.uuid=this.uuid,e.type=this.type,""!==this.name&&(e.name=this.name),void 0!==this.parameters){var t,i=this.parameters;for(t in i)void 0!==i[t]&&(e[t]=i[t]);return e}e.data={attributes:{}};var r=this.index;null!==r&&(i=Array.prototype.slice.call(r.array),e.data.index={type:r.array.constructor.name,array:i}),r=this.attributes;for(t in r){var n=r[t],i=Array.prototype.slice.call(n.array);e.data.attributes[t]={itemSize:n.itemSize,type:n.array.constructor.name,array:i,normalized:n.normalized}}return t=this.groups,0<t.length&&(e.data.groups=JSON.parse(JSON.stringify(t))),t=this.boundingSphere,null!==t&&(e.data.boundingSphere={center:t.center.toArray(),radius:t.radius}),e},clone:function(){return(new THREE.BufferGeometry).copy(this)},copy:function(e){var t=e.index;null!==t&&this.setIndex(t.clone());var i,t=e.attributes;for(i in t)this.addAttribute(i,t[i].clone());for(e=e.groups,i=0,t=e.length;t>i;i++){var r=e[i];this.addGroup(r.start,r.count,r.materialIndex)}return this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),THREE.BufferGeometry.MaxIndex=65535,THREE.InstancedBufferGeometry=function(){THREE.BufferGeometry.call(this),this.type="InstancedBufferGeometry",this.maxInstancedCount=void 0},THREE.InstancedBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.InstancedBufferGeometry.prototype.constructor=THREE.InstancedBufferGeometry,THREE.InstancedBufferGeometry.prototype.addGroup=function(e,t,i){this.groups.push({start:e,count:t,instances:i})},THREE.InstancedBufferGeometry.prototype.copy=function(e){var t=e.index;null!==t&&this.setIndex(t.clone());var i,t=e.attributes;for(i in t)this.addAttribute(i,t[i].clone());for(e=e.groups,i=0,t=e.length;t>i;i++){var r=e[i];this.addGroup(r.start,r.count,r.instances)}return this},THREE.Uniform=function(e,t){"string"==typeof e&&(console.warn("THREE.Uniform: Type parameter is no longer needed."),e=t),this.value=e,this.dynamic=!1},THREE.Uniform.prototype={constructor:THREE.Uniform,onUpdate:function(e){return this.dynamic=!0,this.onUpdateCallback=e,this}},THREE.AnimationAction=function(){throw Error("THREE.AnimationAction: Use mixer.clipAction for construction.")},THREE.AnimationAction._new=function(e,t,i){this._mixer=e,this._clip=t,this._localRoot=i||null,e=t.tracks,t=e.length,i=Array(t);for(var r={endingStart:THREE.ZeroCurvatureEnding,endingEnd:THREE.ZeroCurvatureEnding},n=0;n!==t;++n){var o=e[n].createInterpolant(null);i[n]=o,o.settings=r}this._interpolantSettings=r,this._interpolants=i,this._propertyBindings=Array(t),this._weightInterpolant=this._timeScaleInterpolant=this._byClipCacheIndex=this._cacheIndex=null,this.loop=THREE.LoopRepeat,this._loopCount=-1,this._startTime=null,this.time=0,this._effectiveWeight=this.weight=this._effectiveTimeScale=this.timeScale=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtEnd=this.zeroSlopeAtStart=!0},THREE.AnimationAction._new.prototype={constructor:THREE.AnimationAction._new,play:function(){return this._mixer._activateAction(this),this},stop:function(){return this._mixer._deactivateAction(this),this.reset()},reset:function(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()},isRunning:function(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)},isScheduled:function(){return this._mixer._isActiveAction(this)},startAt:function(e){return this._startTime=e,this},setLoop:function(e,t){return this.loop=e,this.repetitions=t,this},setEffectiveWeight:function(e){return this.weight=e,this._effectiveWeight=this.enabled?e:0,this.stopFading()},getEffectiveWeight:function(){return this._effectiveWeight},fadeIn:function(e){return this._scheduleFading(e,0,1)},fadeOut:function(e){return this._scheduleFading(e,1,0)},crossFadeFrom:function(e,t,i){if(e.fadeOut(t),this.fadeIn(t),i){i=this._clip.duration;var r=e._clip.duration,n=i/r;e.warp(1,r/i,t),this.warp(n,1,t)}return this},crossFadeTo:function(e,t,i){return e.crossFadeFrom(this,t,i)},stopFading:function(){var e=this._weightInterpolant;return null!==e&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(e)),this},setEffectiveTimeScale:function(e){return this.timeScale=e,this._effectiveTimeScale=this.paused?0:e,this.stopWarping()},getEffectiveTimeScale:function(){return this._effectiveTimeScale},setDuration:function(e){return this.timeScale=this._clip.duration/e,this.stopWarping()},syncWith:function(e){return this.time=e.time,this.timeScale=e.timeScale,this.stopWarping()},halt:function(e){return this.warp(this._effectiveTimeScale,0,e)},warp:function(e,t,i){var r=this._mixer,n=r.time,o=this._timeScaleInterpolant,a=this.timeScale;return null===o&&(this._timeScaleInterpolant=o=r._lendControlInterpolant()),r=o.parameterPositions,o=o.sampleValues,r[0]=n,r[1]=n+i,o[0]=e/a,o[1]=t/a,this},stopWarping:function(){var e=this._timeScaleInterpolant;return null!==e&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(e)),this},getMixer:function(){return this._mixer},getClip:function(){return this._clip},getRoot:function(){return this._localRoot||this._mixer._root},_update:function(e,t,i,r){var n=this._startTime;if(null!==n){if(t=(e-n)*i,0>t||0===i)return;this._startTime=null,t*=i}if(t*=this._updateTimeScale(e),i=this._updateTime(t),e=this._updateWeight(e),e>0){t=this._interpolants;for(var n=this._propertyBindings,o=0,a=t.length;o!==a;++o)t[o].evaluate(i),n[o].accumulate(r,e)}},_updateWeight:function(e){var t=0;if(this.enabled){var t=this.weight,i=this._weightInterpolant;if(null!==i){var r=i.evaluate(e)[0],t=t*r;e>i.parameterPositions[1]&&(this.stopFading(),0===r&&(this.enabled=!1))}}return this._effectiveWeight=t},_updateTimeScale:function(e){var t=0;if(!this.paused){var t=this.timeScale,i=this._timeScaleInterpolant;if(null!==i){var r=i.evaluate(e)[0],t=t*r;e>i.parameterPositions[1]&&(this.stopWarping(),0===t?this.paused=!0:this.timeScale=t)}}return this._effectiveTimeScale=t},_updateTime:function(e){var t=this.time+e;if(0===e)return t;var i=this._clip.duration,r=this.loop,n=this._loopCount;if(r===THREE.LoopOnce)e:{if(-1===n&&(this.loopCount=0,this._setEndings(!0,!0,!1)),t>=i)t=i;else{if(!(0>t))break e;t=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this._mixer.dispatchEvent({type:"finished",action:this,direction:0>e?-1:1})}else{if(r=r===THREE.LoopPingPong,-1===n&&(e>=0?(n=0,this._setEndings(!0,0===this.repetitions,r)):this._setEndings(0===this.repetitions,!0,r)),t>=i||0>t){var o=Math.floor(t/i),t=t-i*o,n=n+Math.abs(o),a=this.repetitions-n;0>a?(this.clampWhenFinished?this.paused=!0:this.enabled=!1,t=e>0?i:0,this._mixer.dispatchEvent({type:"finished",action:this,direction:e>0?1:-1})):(0===a?(e=0>e,this._setEndings(e,!e,r)):this._setEndings(!1,!1,r),this._loopCount=n,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:o}))}if(r&&1===(1&n))return this.time=t,i-t}return this.time=t},_setEndings:function(e,t,i){var r=this._interpolantSettings;i?(r.endingStart=THREE.ZeroSlopeEnding,r.endingEnd=THREE.ZeroSlopeEnding):(r.endingStart=e?this.zeroSlopeAtStart?THREE.ZeroSlopeEnding:THREE.ZeroCurvatureEnding:THREE.WrapAroundEnding,r.endingEnd=t?this.zeroSlopeAtEnd?THREE.ZeroSlopeEnding:THREE.ZeroCurvatureEnding:THREE.WrapAroundEnding)},_scheduleFading:function(e,t,i){var r=this._mixer,n=r.time,o=this._weightInterpolant;return null===o&&(this._weightInterpolant=o=r._lendControlInterpolant()),r=o.parameterPositions,o=o.sampleValues,r[0]=n,o[0]=t,r[1]=n+e,o[1]=i,this}},THREE.AnimationClip=function(e,t,i){this.name=e,this.tracks=i,this.duration=void 0!==t?t:-1,this.uuid=THREE.Math.generateUUID(),0>this.duration&&this.resetDuration(),this.trim(),this.optimize()},THREE.AnimationClip.prototype={constructor:THREE.AnimationClip,resetDuration:function(){for(var e=0,t=0,i=this.tracks.length;t!==i;++t)var r=this.tracks[t],e=Math.max(e,r.times[r.times.length-1]);this.duration=e},trim:function(){for(var e=0;e<this.tracks.length;e++)this.tracks[e].trim(0,this.duration);return this},optimize:function(){for(var e=0;e<this.tracks.length;e++)this.tracks[e].optimize();return this}},Object.assign(THREE.AnimationClip,{parse:function(e){for(var t=[],i=e.tracks,r=1/(e.fps||1),n=0,o=i.length;n!==o;++n)t.push(THREE.KeyframeTrack.parse(i[n]).scale(r));return new THREE.AnimationClip(e.name,e.duration,t)},toJSON:function(e){var t=[],i=e.tracks;e={name:e.name,duration:e.duration,tracks:t};for(var r=0,n=i.length;r!==n;++r)t.push(THREE.KeyframeTrack.toJSON(i[r]));return e},CreateFromMorphTargetSequence:function(e,t,i,r){for(var n=t.length,o=[],a=0;n>a;a++){var s=[],c=[];s.push((a+n-1)%n,a,(a+1)%n),c.push(0,1,0);var h=THREE.AnimationUtils.getKeyframeOrder(s),s=THREE.AnimationUtils.sortedArray(s,1,h),c=THREE.AnimationUtils.sortedArray(c,1,h);r||0!==s[0]||(s.push(n),c.push(c[0])),o.push(new THREE.NumberKeyframeTrack(".morphTargetInfluences["+t[a].name+"]",s,c).scale(1/i))}return new THREE.AnimationClip(e,-1,o)},findByName:function(e,t){var i=e;Array.isArray(e)||(i=e.geometry&&e.geometry.animations||e.animations);for(var r=0;r<i.length;r++)if(i[r].name===t)return i[r];return null},CreateClipsFromMorphTargetSequences:function(e,t,i){for(var r={},n=/^([\w-]*?)([\d]+)$/,o=0,a=e.length;a>o;o++){var s=e[o],c=s.name.match(n);if(c&&1<c.length){var h=c[1];(c=r[h])||(r[h]=c=[]),c.push(s)}}e=[];
for(h in r)e.push(THREE.AnimationClip.CreateFromMorphTargetSequence(h,r[h],t,i));return e},parseAnimation:function(e,t,i){if(!e)return console.error("  no animation in JSONLoader data"),null;i=function(e,t,i,r,n){if(0!==i.length){var o=[],a=[];THREE.AnimationUtils.flattenJSON(i,o,a,r),0!==o.length&&n.push(new e(t,o,a))}};var r=[],n=e.name||"default",o=e.length||-1,a=e.fps||30;e=e.hierarchy||[];for(var s=0;s<e.length;s++){var c=e[s].keys;if(c&&0!==c.length)if(c[0].morphTargets){for(var o={},h=0;h<c.length;h++)if(c[h].morphTargets)for(var l=0;l<c[h].morphTargets.length;l++)o[c[h].morphTargets[l]]=-1;for(var u in o){for(var p=[],d=[],l=0;l!==c[h].morphTargets.length;++l){var f=c[h];p.push(f.time),d.push(f.morphTarget===u?1:0)}r.push(new THREE.NumberKeyframeTrack(".morphTargetInfluence["+u+"]",p,d))}o=o.length*(a||1)}else h=".bones["+t[s].name+"]",i(THREE.VectorKeyframeTrack,h+".position",c,"pos",r),i(THREE.QuaternionKeyframeTrack,h+".quaternion",c,"rot",r),i(THREE.VectorKeyframeTrack,h+".scale",c,"scl",r)}return 0===r.length?null:new THREE.AnimationClip(n,o,r)}}),THREE.AnimationMixer=function(e){this._root=e,this._initMemoryManager(),this.time=this._accuIndex=0,this.timeScale=1},Object.assign(THREE.AnimationMixer.prototype,THREE.EventDispatcher.prototype,{clipAction:function(e,t){var i=t||this._root,r=i.uuid,n="string"==typeof e?THREE.AnimationClip.findByName(i,e):e,i=null!==n?n.uuid:e,o=this._actionsByClip[i],a=null;if(void 0!==o){if(a=o.actionByRoot[r],void 0!==a)return a;a=o.knownActions[0],null===n&&(n=a._clip)}return null===n?null:(n=new THREE.AnimationMixer._Action(this,n,t),this._bindAction(n,a),this._addInactiveAction(n,i,r),n)},existingAction:function(e,t){var i=t||this._root,r=i.uuid,i="string"==typeof e?THREE.AnimationClip.findByName(i,e):e,i=this._actionsByClip[i?i.uuid:e];return void 0!==i?i.actionByRoot[r]||null:null},stopAllAction:function(){for(var e=this._actions,t=this._nActiveActions,i=this._bindings,r=this._nActiveBindings,n=this._nActiveBindings=this._nActiveActions=0;n!==t;++n)e[n].reset();for(n=0;n!==r;++n)i[n].useCount=0;return this},update:function(e){e*=this.timeScale;for(var t=this._actions,i=this._nActiveActions,r=this.time+=e,n=Math.sign(e),o=this._accuIndex^=1,a=0;a!==i;++a){var s=t[a];s.enabled&&s._update(r,e,n,o)}for(e=this._bindings,t=this._nActiveBindings,a=0;a!==t;++a)e[a].apply(o);return this},getRoot:function(){return this._root},uncacheClip:function(e){var t=this._actions;e=e.uuid;var i=this._actionsByClip,r=i[e];if(void 0!==r){for(var r=r.knownActions,n=0,o=r.length;n!==o;++n){var a=r[n];this._deactivateAction(a);var s=a._cacheIndex,c=t[t.length-1];a._cacheIndex=null,a._byClipCacheIndex=null,c._cacheIndex=s,t[s]=c,t.pop(),this._removeInactiveBindingsForAction(a)}delete i[e]}},uncacheRoot:function(e){e=e.uuid;var t,i=this._actionsByClip;for(t in i){var r=i[t].actionByRoot[e];void 0!==r&&(this._deactivateAction(r),this._removeInactiveAction(r))}if(t=this._bindingsByRootAndName[e],void 0!==t)for(var n in t)e=t[n],e.restoreOriginalState(),this._removeInactiveBinding(e)},uncacheAction:function(e,t){var i=this.existingAction(e,t);null!==i&&(this._deactivateAction(i),this._removeInactiveAction(i))}}),THREE.AnimationMixer._Action=THREE.AnimationAction._new,Object.assign(THREE.AnimationMixer.prototype,{_bindAction:function(e,t){var i=e._localRoot||this._root,r=e._clip.tracks,n=r.length,o=e._propertyBindings,a=e._interpolants,s=i.uuid,c=this._bindingsByRootAndName,h=c[s];for(void 0===h&&(h={},c[s]=h),c=0;c!==n;++c){var l=r[c],u=l.name,p=h[u];if(void 0===p){if(p=o[c],void 0!==p){null===p._cacheIndex&&(++p.referenceCount,this._addInactiveBinding(p,s,u));continue}p=new THREE.PropertyMixer(THREE.PropertyBinding.create(i,u,t&&t._propertyBindings[c].binding.parsedPath),l.ValueTypeName,l.getValueSize()),++p.referenceCount,this._addInactiveBinding(p,s,u)}o[c]=p,a[c].resultBuffer=p.buffer}},_activateAction:function(e){if(!this._isActiveAction(e)){if(null===e._cacheIndex){var t=(e._localRoot||this._root).uuid,i=e._clip.uuid,r=this._actionsByClip[i];this._bindAction(e,r&&r.knownActions[0]),this._addInactiveAction(e,i,t)}for(t=e._propertyBindings,i=0,r=t.length;i!==r;++i){var n=t[i];0===n.useCount++&&(this._lendBinding(n),n.saveOriginalState())}this._lendAction(e)}},_deactivateAction:function(e){if(this._isActiveAction(e)){for(var t=e._propertyBindings,i=0,r=t.length;i!==r;++i){var n=t[i];0===--n.useCount&&(n.restoreOriginalState(),this._takeBackBinding(n))}this._takeBackAction(e)}},_initMemoryManager:function(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;var e=this;this.stats={actions:{get total(){return e._actions.length},get inUse(){return e._nActiveActions}},bindings:{get total(){return e._bindings.length},get inUse(){return e._nActiveBindings}},controlInterpolants:{get total(){return e._controlInterpolants.length},get inUse(){return e._nActiveControlInterpolants}}}},_isActiveAction:function(e){return e=e._cacheIndex,null!==e&&e<this._nActiveActions},_addInactiveAction:function(e,t,i){var r=this._actions,n=this._actionsByClip,o=n[t];void 0===o?(o={knownActions:[e],actionByRoot:{}},e._byClipCacheIndex=0,n[t]=o):(t=o.knownActions,e._byClipCacheIndex=t.length,t.push(e)),e._cacheIndex=r.length,r.push(e),o.actionByRoot[i]=e},_removeInactiveAction:function(e){var t=this._actions,i=t[t.length-1],r=e._cacheIndex;i._cacheIndex=r,t[r]=i,t.pop(),e._cacheIndex=null;var i=e._clip.uuid,r=this._actionsByClip,n=r[i],o=n.knownActions,a=o[o.length-1],s=e._byClipCacheIndex;a._byClipCacheIndex=s,o[s]=a,o.pop(),e._byClipCacheIndex=null,delete n.actionByRoot[(t._localRoot||this._root).uuid],0===o.length&&delete r[i],this._removeInactiveBindingsForAction(e)},_removeInactiveBindingsForAction:function(e){e=e._propertyBindings;for(var t=0,i=e.length;t!==i;++t){var r=e[t];0===--r.referenceCount&&this._removeInactiveBinding(r)}},_lendAction:function(e){var t=this._actions,i=e._cacheIndex,r=this._nActiveActions++,n=t[r];e._cacheIndex=r,t[r]=e,n._cacheIndex=i,t[i]=n},_takeBackAction:function(e){var t=this._actions,i=e._cacheIndex,r=--this._nActiveActions,n=t[r];e._cacheIndex=r,t[r]=e,n._cacheIndex=i,t[i]=n},_addInactiveBinding:function(e,t,i){var r=this._bindingsByRootAndName,n=r[t],o=this._bindings;void 0===n&&(n={},r[t]=n),n[i]=e,e._cacheIndex=o.length,o.push(e)},_removeInactiveBinding:function(e){var t=this._bindings,i=e.binding,r=i.rootNode.uuid,i=i.path,n=this._bindingsByRootAndName,o=n[r],a=t[t.length-1];e=e._cacheIndex,a._cacheIndex=e,t[e]=a,t.pop(),delete o[i];e:{for(var s in o)break e;delete n[r]}},_lendBinding:function(e){var t=this._bindings,i=e._cacheIndex,r=this._nActiveBindings++,n=t[r];e._cacheIndex=r,t[r]=e,n._cacheIndex=i,t[i]=n},_takeBackBinding:function(e){var t=this._bindings,i=e._cacheIndex,r=--this._nActiveBindings,n=t[r];e._cacheIndex=r,t[r]=e,n._cacheIndex=i,t[i]=n},_lendControlInterpolant:function(){var e=this._controlInterpolants,t=this._nActiveControlInterpolants++,i=e[t];return void 0===i&&(i=new THREE.LinearInterpolant(new Float32Array(2),new Float32Array(2),1,this._controlInterpolantsResultBuffer),i.__cacheIndex=t,e[t]=i),i},_takeBackControlInterpolant:function(e){var t=this._controlInterpolants,i=e.__cacheIndex,r=--this._nActiveControlInterpolants,n=t[r];e.__cacheIndex=r,t[r]=e,n.__cacheIndex=i,t[i]=n},_controlInterpolantsResultBuffer:new Float32Array(1)}),THREE.AnimationObjectGroup=function(e){this.uuid=THREE.Math.generateUUID(),this._objects=Array.prototype.slice.call(arguments),this.nCachedObjects_=0;var t={};this._indicesByUUID=t;for(var i=0,r=arguments.length;i!==r;++i)t[arguments[i].uuid]=i;this._paths=[],this._parsedPaths=[],this._bindings=[],this._bindingsIndicesByPath={};var n=this;this.stats={objects:{get total(){return n._objects.length},get inUse(){return this.total-n.nCachedObjects_}},get bindingsPerObject(){return n._bindings.length}}},THREE.AnimationObjectGroup.prototype={constructor:THREE.AnimationObjectGroup,add:function(e){for(var t=this._objects,i=t.length,r=this.nCachedObjects_,n=this._indicesByUUID,o=this._paths,a=this._parsedPaths,s=this._bindings,c=s.length,h=0,l=arguments.length;h!==l;++h){var u=arguments[h],p=u.uuid,d=n[p];if(void 0===d){d=i++,n[p]=d,t.push(u);for(var p=0,f=c;p!==f;++p)s[p].push(new THREE.PropertyBinding(u,o[p],a[p]))}else if(r>d){var E=t[d],m=--r,f=t[m];for(n[f.uuid]=d,t[d]=f,n[p]=m,t[m]=u,p=0,f=c;p!==f;++p){var g=s[p],T=g[d];g[d]=g[m],void 0===T&&(T=new THREE.PropertyBinding(u,o[p],a[p])),g[m]=T}}else t[d]!==E&&console.error("Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes...")}this.nCachedObjects_=r},remove:function(e){for(var t=this._objects,i=this.nCachedObjects_,r=this._indicesByUUID,n=this._bindings,o=n.length,a=0,s=arguments.length;a!==s;++a){var c=arguments[a],h=c.uuid,l=r[h];if(void 0!==l&&l>=i){var u=i++,p=t[u];for(r[p.uuid]=l,t[l]=p,r[h]=u,t[u]=c,c=0,h=o;c!==h;++c){var p=n[c],d=p[l];p[l]=p[u],p[u]=d}}}this.nCachedObjects_=i},uncache:function(e){for(var t=this._objects,i=t.length,r=this.nCachedObjects_,n=this._indicesByUUID,o=this._bindings,a=o.length,s=0,c=arguments.length;s!==c;++s){var h=arguments[s].uuid,l=n[h];if(void 0!==l)if(delete n[h],r>l){var h=--r,u=t[h],p=--i,d=t[p];for(n[u.uuid]=l,t[l]=u,n[d.uuid]=h,t[h]=d,t.pop(),u=0,d=a;u!==d;++u){var f=o[u],E=f[p];f[l]=f[h],f[h]=E,f.pop()}}else for(p=--i,d=t[p],n[d.uuid]=l,t[l]=d,t.pop(),u=0,d=a;u!==d;++u)f=o[u],f[l]=f[p],f.pop()}this.nCachedObjects_=r},subscribe_:function(e,t){var i=this._bindingsIndicesByPath,r=i[e],n=this._bindings;if(void 0!==r)return n[r];var o=this._paths,a=this._parsedPaths,s=this._objects,c=this.nCachedObjects_,h=Array(s.length),r=n.length;for(i[e]=r,o.push(e),a.push(t),n.push(h),i=c,r=s.length;i!==r;++i)h[i]=new THREE.PropertyBinding(s[i],e,t);return h},unsubscribe_:function(e){var t=this._bindingsIndicesByPath,i=t[e];if(void 0!==i){var r=this._paths,n=this._parsedPaths,o=this._bindings,a=o.length-1,s=o[a];t[e[a]]=i,o[i]=s,o.pop(),n[i]=n[a],n.pop(),r[i]=r[a],r.pop()}}},THREE.AnimationUtils={arraySlice:function(e,t,i){return THREE.AnimationUtils.isTypedArray(e)?new e.constructor(e.subarray(t,i)):e.slice(t,i)},convertArray:function(e,t,i){return!e||!i&&e.constructor===t?e:"number"==typeof t.BYTES_PER_ELEMENT?new t(e):Array.prototype.slice.call(e)},isTypedArray:function(e){return ArrayBuffer.isView(e)&&!(e instanceof DataView)},getKeyframeOrder:function(e){for(var t=e.length,i=Array(t),r=0;r!==t;++r)i[r]=r;return i.sort(function(t,i){return e[t]-e[i]}),i},sortedArray:function(e,t,i){for(var r=e.length,n=new e.constructor(r),o=0,a=0;a!==r;++o)for(var s=i[o]*t,c=0;c!==t;++c)n[a++]=e[s+c];return n},flattenJSON:function(e,t,i,r){for(var n=1,o=e[0];void 0!==o&&void 0===o[r];)o=e[n++];if(void 0!==o){var a=o[r];if(void 0!==a)if(Array.isArray(a)){do a=o[r],void 0!==a&&(t.push(o.time),i.push.apply(i,a)),o=e[n++];while(void 0!==o)}else if(void 0!==a.toArray){do a=o[r],void 0!==a&&(t.push(o.time),a.toArray(i,i.length)),o=e[n++];while(void 0!==o)}else do a=o[r],void 0!==a&&(t.push(o.time),i.push(a)),o=e[n++];while(void 0!==o)}}},THREE.KeyframeTrack=function(e,t,i,r){if(void 0===e)throw Error("track name is undefined");if(void 0===t||0===t.length)throw Error("no keyframes in track named "+e);this.name=e,this.times=THREE.AnimationUtils.convertArray(t,this.TimeBufferType),this.values=THREE.AnimationUtils.convertArray(i,this.ValueBufferType),this.setInterpolation(r||this.DefaultInterpolation),this.validate(),this.optimize()},THREE.KeyframeTrack.prototype={constructor:THREE.KeyframeTrack,TimeBufferType:Float32Array,ValueBufferType:Float32Array,DefaultInterpolation:THREE.InterpolateLinear,InterpolantFactoryMethodDiscrete:function(e){return new THREE.DiscreteInterpolant(this.times,this.values,this.getValueSize(),e)},InterpolantFactoryMethodLinear:function(e){return new THREE.LinearInterpolant(this.times,this.values,this.getValueSize(),e)},InterpolantFactoryMethodSmooth:function(e){return new THREE.CubicInterpolant(this.times,this.values,this.getValueSize(),e)},setInterpolation:function(e){var t;switch(e){case THREE.InterpolateDiscrete:t=this.InterpolantFactoryMethodDiscrete;break;case THREE.InterpolateLinear:t=this.InterpolantFactoryMethodLinear;break;case THREE.InterpolateSmooth:t=this.InterpolantFactoryMethodSmooth}if(void 0===t){if(t="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name,void 0===this.createInterpolant){if(e===this.DefaultInterpolation)throw Error(t);this.setInterpolation(this.DefaultInterpolation)}console.warn(t)}else this.createInterpolant=t},getInterpolation:function(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return THREE.InterpolateDiscrete;case this.InterpolantFactoryMethodLinear:return THREE.InterpolateLinear;case this.InterpolantFactoryMethodSmooth:return THREE.InterpolateSmooth}},getValueSize:function(){return this.values.length/this.times.length},shift:function(e){if(0!==e)for(var t=this.times,i=0,r=t.length;i!==r;++i)t[i]+=e;return this},scale:function(e){if(1!==e)for(var t=this.times,i=0,r=t.length;i!==r;++i)t[i]*=e;return this},trim:function(e,t){for(var i=this.times,r=i.length,n=0,o=r-1;n!==r&&i[n]<e;)++n;for(;-1!==o&&i[o]>t;)--o;return++o,0===n&&o===r||(n>=o&&(o=Math.max(o,1),n=o-1),r=this.getValueSize(),this.times=THREE.AnimationUtils.arraySlice(i,n,o),this.values=THREE.AnimationUtils.arraySlice(this.values,n*r,o*r)),this},validate:function(){var e=!0,t=this.getValueSize();0!==t-Math.floor(t)&&(console.error("invalid value size in track",this),e=!1);var i=this.times,t=this.values,r=i.length;0===r&&(console.error("track is empty",this),e=!1);for(var n=null,o=0;o!==r;o++){var a=i[o];if("number"==typeof a&&isNaN(a)){console.error("time is not a valid number",this,o,a),e=!1;break}if(null!==n&&n>a){console.error("out of order keys",this,o,a,n),e=!1;break}n=a}if(void 0!==t&&THREE.AnimationUtils.isTypedArray(t))for(o=0,i=t.length;o!==i;++o)if(r=t[o],isNaN(r)){console.error("value is not a valid number",this,o,r),e=!1;break}return e},optimize:function(){for(var e=this.times,t=this.values,i=this.getValueSize(),r=1,n=1,o=e.length-1;o>=n;++n){var a=!1,s=e[n];if(s!==e[n+1]&&(1!==n||s!==s[0]))for(var c=n*i,h=c-i,l=c+i,s=0;s!==i;++s){var u=t[c+s];if(u!==t[h+s]||u!==t[l+s]){a=!0;break}}if(a){if(n!==r)for(e[r]=e[n],a=n*i,c=r*i,s=0;s!==i;++s)t[c+s]=t[a+s];++r}}return r!==e.length&&(this.times=THREE.AnimationUtils.arraySlice(e,0,r),this.values=THREE.AnimationUtils.arraySlice(t,0,r*i)),this}},Object.assign(THREE.KeyframeTrack,{parse:function(e){if(void 0===e.type)throw Error("track type undefined, can not parse");var t=THREE.KeyframeTrack._getTrackTypeForValueTypeName(e.type);if(void 0===e.times){var i=[],r=[];THREE.AnimationUtils.flattenJSON(e.keys,i,r,"value"),e.times=i,e.values=r}return void 0!==t.parse?t.parse(e):new t(e.name,e.times,e.values,e.interpolation)},toJSON:function(e){var t=e.constructor;if(void 0!==t.toJSON)t=t.toJSON(e);else{var t={name:e.name,times:THREE.AnimationUtils.convertArray(e.times,Array),values:THREE.AnimationUtils.convertArray(e.values,Array)},i=e.getInterpolation();i!==e.DefaultInterpolation&&(t.interpolation=i)}return t.type=e.ValueTypeName,t},_getTrackTypeForValueTypeName:function(e){switch(e.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return THREE.NumberKeyframeTrack;case"vector":case"vector2":case"vector3":case"vector4":return THREE.VectorKeyframeTrack;case"color":return THREE.ColorKeyframeTrack;case"quaternion":return THREE.QuaternionKeyframeTrack;case"bool":case"boolean":return THREE.BooleanKeyframeTrack;case"string":return THREE.StringKeyframeTrack}throw Error("Unsupported typeName: "+e)}}),THREE.PropertyBinding=function(e,t,i){this.path=t,this.parsedPath=i||THREE.PropertyBinding.parseTrackName(t),this.node=THREE.PropertyBinding.findNode(e,this.parsedPath.nodeName)||e,this.rootNode=e},THREE.PropertyBinding.prototype={constructor:THREE.PropertyBinding,getValue:function(e,t){this.bind(),this.getValue(e,t)},setValue:function(e,t){this.bind(),this.setValue(e,t)},bind:function(){var e=this.node,t=this.parsedPath,i=t.objectName,r=t.propertyName,n=t.propertyIndex;if(e||(this.node=e=THREE.PropertyBinding.findNode(this.rootNode,t.nodeName)||this.rootNode),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,e){if(i){var o=t.objectIndex;switch(i){case"materials":if(!e.material)return void console.error("  can not bind to material as node does not have a material",this);if(!e.material.materials)return void console.error("  can not bind to material.materials as node.material does not have a materials array",this);e=e.material.materials;break;case"bones":if(!e.skeleton)return void console.error("  can not bind to bones as node does not have a skeleton",this);for(e=e.skeleton.bones,i=0;i<e.length;i++)if(e[i].name===o){o=i;break}break;default:if(void 0===e[i])return void console.error("  can not bind to objectName of node, undefined",this);e=e[i]}if(void 0!==o){if(void 0===e[o])return void console.error("  trying to bind to objectIndex of objectName, but is undefined:",this,e);e=e[o]}}if(o=e[r]){if(t=this.Versioning.None,void 0!==e.needsUpdate?(t=this.Versioning.NeedsUpdate,this.targetObject=e):void 0!==e.matrixWorldNeedsUpdate&&(t=this.Versioning.MatrixWorldNeedsUpdate,this.targetObject=e),i=this.BindingType.Direct,void 0!==n){if("morphTargetInfluences"===r){if(!e.geometry)return void console.error("  can not bind to morphTargetInfluences becasuse node does not have a geometry",this);if(!e.geometry.morphTargets)return void console.error("  can not bind to morphTargetInfluences becasuse node does not have a geometry.morphTargets",this);for(i=0;i<this.node.geometry.morphTargets.length;i++)if(e.geometry.morphTargets[i].name===n){n=i;break}}i=this.BindingType.ArrayElement,this.resolvedProperty=o,this.propertyIndex=n}else void 0!==o.fromArray&&void 0!==o.toArray?(i=this.BindingType.HasFromToArray,this.resolvedProperty=o):void 0!==o.length?(i=this.BindingType.EntireArray,this.resolvedProperty=o):this.propertyName=r;this.getValue=this.GetterByBindingType[i],this.setValue=this.SetterByBindingTypeAndVersioning[i][t]}else console.error("  trying to update property for track: "+t.nodeName+"."+r+" but it wasn't found.",e)}else console.error("  trying to update node for track: "+this.path+" but it wasn't found.")},unbind:function(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}},Object.assign(THREE.PropertyBinding.prototype,{_getValue_unavailable:function(){},_setValue_unavailable:function(){},_getValue_unbound:THREE.PropertyBinding.prototype.getValue,_setValue_unbound:THREE.PropertyBinding.prototype.setValue,BindingType:{Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Versioning:{None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},GetterByBindingType:[function(e,t){e[t]=this.node[this.propertyName]},function(e,t){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)e[t++]=i[r]},function(e,t){e[t]=this.resolvedProperty[this.propertyIndex]},function(e,t){this.resolvedProperty.toArray(e,t)}],SetterByBindingTypeAndVersioning:[[function(e,t){this.node[this.propertyName]=e[t]},function(e,t){this.node[this.propertyName]=e[t],this.targetObject.needsUpdate=!0},function(e,t){this.node[this.propertyName]=e[t],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(e,t){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)i[r]=e[t++]},function(e,t){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)i[r]=e[t++];this.targetObject.needsUpdate=!0},function(e,t){for(var i=this.resolvedProperty,r=0,n=i.length;r!==n;++r)i[r]=e[t++];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(e,t){this.resolvedProperty[this.propertyIndex]=e[t]},function(e,t){this.resolvedProperty[this.propertyIndex]=e[t],this.targetObject.needsUpdate=!0},function(e,t){this.resolvedProperty[this.propertyIndex]=e[t],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(e,t){this.resolvedProperty.fromArray(e,t)},function(e,t){this.resolvedProperty.fromArray(e,t),this.targetObject.needsUpdate=!0},function(e,t){this.resolvedProperty.fromArray(e,t),this.targetObject.matrixWorldNeedsUpdate=!0}]]}),THREE.PropertyBinding.Composite=function(e,t,i){i=i||THREE.PropertyBinding.parseTrackName(t),this._targetGroup=e,this._bindings=e.subscribe_(t,i)},THREE.PropertyBinding.Composite.prototype={constructor:THREE.PropertyBinding.Composite,getValue:function(e,t){this.bind();var i=this._bindings[this._targetGroup.nCachedObjects_];void 0!==i&&i.getValue(e,t)},setValue:function(e,t){for(var i=this._bindings,r=this._targetGroup.nCachedObjects_,n=i.length;r!==n;++r)i[r].setValue(e,t)},bind:function(){for(var e=this._bindings,t=this._targetGroup.nCachedObjects_,i=e.length;t!==i;++t)e[t].bind()},unbind:function(){for(var e=this._bindings,t=this._targetGroup.nCachedObjects_,i=e.length;t!==i;++t)e[t].unbind()}},THREE.PropertyBinding.create=function(e,t,i){return e instanceof THREE.AnimationObjectGroup?new THREE.PropertyBinding.Composite(e,t,i):new THREE.PropertyBinding(e,t,i)},THREE.PropertyBinding.parseTrackName=function(e){var t=/^(([\w]+\/)*)([\w-\d]+)?(\.([\w]+)(\[([\w\d\[\]\_.:\- ]+)\])?)?(\.([\w.]+)(\[([\w\d\[\]\_. ]+)\])?)$/,i=t.exec(e);if(!i)throw Error("cannot parse trackName at all: "+e);if(i.index===t.lastIndex&&t.lastIndex++,t={nodeName:i[3],objectName:i[5],objectIndex:i[7],propertyName:i[9],propertyIndex:i[11]},null===t.propertyName||0===t.propertyName.length)throw Error("can not parse propertyName from trackName: "+e);return t},THREE.PropertyBinding.findNode=function(e,t){if(!t||""===t||"root"===t||"."===t||-1===t||t===e.name||t===e.uuid)return e;if(e.skeleton){var i=function(e){for(var i=0;i<e.bones.length;i++){var r=e.bones[i];if(r.name===t)return r}return null}(e.skeleton);if(i)return i}if(e.children){var r=function(e){for(var i=0;i<e.length;i++){var n=e[i];if(n.name===t||n.uuid===t||(n=r(n.children)))return n}return null};if(i=r(e.children))return i}return null},THREE.PropertyMixer=function(e,t,i){switch(this.binding=e,this.valueSize=i,e=Float64Array,t){case"quaternion":t=this._slerp;break;case"string":case"bool":e=Array,t=this._select;break;default:t=this._lerp}this.buffer=new e(4*i),this._mixBufferRegion=t,this.referenceCount=this.useCount=this.cumulativeWeight=0},THREE.PropertyMixer.prototype={constructor:THREE.PropertyMixer,accumulate:function(e,t){var i=this.buffer,r=this.valueSize,n=e*r+r,o=this.cumulativeWeight;if(0===o){for(o=0;o!==r;++o)i[n+o]=i[o];o=t}else o+=t,this._mixBufferRegion(i,n,0,t/o,r);this.cumulativeWeight=o},apply:function(e){var t=this.valueSize,i=this.buffer;e=e*t+t;var r=this.cumulativeWeight,n=this.binding;this.cumulativeWeight=0,1>r&&this._mixBufferRegion(i,e,3*t,1-r,t);for(var r=t,o=t+t;r!==o;++r)if(i[r]!==i[r+t]){n.setValue(i,e);break}},saveOriginalState:function(){var e=this.buffer,t=this.valueSize,i=3*t;this.binding.getValue(e,i);for(var r=t;r!==i;++r)e[r]=e[i+r%t];this.cumulativeWeight=0},restoreOriginalState:function(){this.binding.setValue(this.buffer,3*this.valueSize)},_select:function(e,t,i,r,n){if(r>=.5)for(r=0;r!==n;++r)e[t+r]=e[i+r]},_slerp:function(e,t,i,r,n){THREE.Quaternion.slerpFlat(e,t,e,t,e,i,r)},_lerp:function(e,t,i,r,n){for(var o=1-r,a=0;a!==n;++a){var s=t+a;e[s]=e[s]*o+e[i+a]*r}}},THREE.BooleanKeyframeTrack=function(e,t,i){THREE.KeyframeTrack.call(this,e,t,i)},THREE.BooleanKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.BooleanKeyframeTrack,ValueTypeName:"bool",ValueBufferType:Array,DefaultInterpolation:THREE.InterpolateDiscrete,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),THREE.ColorKeyframeTrack=function(e,t,i,r){THREE.KeyframeTrack.call(this,e,t,i,r)},THREE.ColorKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.ColorKeyframeTrack,ValueTypeName:"color"}),THREE.NumberKeyframeTrack=function(e,t,i,r){THREE.KeyframeTrack.call(this,e,t,i,r)},THREE.NumberKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.NumberKeyframeTrack,ValueTypeName:"number"}),THREE.QuaternionKeyframeTrack=function(e,t,i,r){THREE.KeyframeTrack.call(this,e,t,i,r)},THREE.QuaternionKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.QuaternionKeyframeTrack,ValueTypeName:"quaternion",DefaultInterpolation:THREE.InterpolateLinear,InterpolantFactoryMethodLinear:function(e){return new THREE.QuaternionLinearInterpolant(this.times,this.values,this.getValueSize(),e)},InterpolantFactoryMethodSmooth:void 0}),THREE.StringKeyframeTrack=function(e,t,i,r){THREE.KeyframeTrack.call(this,e,t,i,r)},THREE.StringKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.StringKeyframeTrack,ValueTypeName:"string",ValueBufferType:Array,DefaultInterpolation:THREE.InterpolateDiscrete,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),THREE.VectorKeyframeTrack=function(e,t,i,r){THREE.KeyframeTrack.call(this,e,t,i,r)},THREE.VectorKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.VectorKeyframeTrack,ValueTypeName:"vector"}),THREE.Audio=function(e){THREE.Object3D.call(this),this.type="Audio",this.context=e.context,this.source=this.context.createBufferSource(),this.source.onended=this.onEnded.bind(this),this.gain=this.context.createGain(),this.gain.connect(e.getInput()),this.autoplay=!1,this.startTime=0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.sourceType="empty",this.filters=[]},THREE.Audio.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.Audio,getOutput:function(){return this.gain},setNodeSource:function(e){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=e,this.connect(),this},setBuffer:function(e){return this.source.buffer=e,this.sourceType="buffer",this.autoplay&&this.play(),this},play:function(){if(!0===this.isPlaying)console.warn("THREE.Audio: Audio is already playing.");else{if(!1!==this.hasPlaybackControl){var e=this.context.createBufferSource();return e.buffer=this.source.buffer,e.loop=this.source.loop,e.onended=this.source.onended,e.start(0,this.startTime),e.playbackRate.value=this.playbackRate,this.isPlaying=!0,this.source=e,this.connect()}console.warn("THREE.Audio: this Audio has no playback control.")}},pause:function(){return!1!==this.hasPlaybackControl?(this.source.stop(),this.startTime=this.context.currentTime,this):void console.warn("THREE.Audio: this Audio has no playback control.")},stop:function(){return!1!==this.hasPlaybackControl?(this.source.stop(),this.startTime=0,this):void console.warn("THREE.Audio: this Audio has no playback control.")},connect:function(){if(0<this.filters.length){this.source.connect(this.filters[0]);for(var e=1,t=this.filters.length;t>e;e++)this.filters[e-1].connect(this.filters[e]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this},disconnect:function(){if(0<this.filters.length){this.source.disconnect(this.filters[0]);for(var e=1,t=this.filters.length;t>e;e++)this.filters[e-1].disconnect(this.filters[e]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this},getFilters:function(){return this.filters},setFilters:function(e){return e||(e=[]),!0===this.isPlaying?(this.disconnect(),this.filters=e,this.connect()):this.filters=e,this},getFilter:function(){return this.getFilters()[0]},setFilter:function(e){return this.setFilters(e?[e]:[])},setPlaybackRate:function(e){return!1!==this.hasPlaybackControl?(this.playbackRate=e,!0===this.isPlaying&&(this.source.playbackRate.value=this.playbackRate),this):void console.warn("THREE.Audio: this Audio has no playback control.")},getPlaybackRate:function(){return this.playbackRate},onEnded:function(){this.isPlaying=!1},getLoop:function(){return!1===this.hasPlaybackControl?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.source.loop},setLoop:function(e){!1===this.hasPlaybackControl?console.warn("THREE.Audio: this Audio has no playback control."):this.source.loop=e},getVolume:function(){return this.gain.gain.value},setVolume:function(e){return this.gain.gain.value=e,this}}),THREE.AudioAnalyser=function(e,t){this.analyser=e.context.createAnalyser(),this.analyser.fftSize=void 0!==t?t:2048,this.data=new Uint8Array(this.analyser.frequencyBinCount),e.getOutput().connect(this.analyser)},Object.assign(THREE.AudioAnalyser.prototype,{getFrequencyData:function(){return this.analyser.getByteFrequencyData(this.data),this.data},getAverageFrequency:function(){for(var e=0,t=this.getFrequencyData(),i=0;i<t.length;i++)e+=t[i];return e/t.length}}),Object.defineProperty(THREE,"AudioContext",{get:function(){var e;return function(){return void 0===e&&(e=new(window.AudioContext||window.webkitAudioContext)),e}}()}),THREE.PositionalAudio=function(e){THREE.Audio.call(this,e),this.panner=this.context.createPanner(),this.panner.connect(this.gain)},THREE.PositionalAudio.prototype=Object.assign(Object.create(THREE.Audio.prototype),{constructor:THREE.PositionalAudio,getOutput:function(){return this.panner},getRefDistance:function(){return this.panner.refDistance},setRefDistance:function(e){this.panner.refDistance=e},getRolloffFactor:function(){return this.panner.rolloffFactor},setRolloffFactor:function(e){this.panner.rolloffFactor=e},getDistanceModel:function(){return this.panner.distanceModel},setDistanceModel:function(e){this.panner.distanceModel=e},getMaxDistance:function(){return this.panner.maxDistance},setMaxDistance:function(e){this.panner.maxDistance=e},updateMatrixWorld:function(){var e=new THREE.Vector3;return function(t){THREE.Object3D.prototype.updateMatrixWorld.call(this,t),e.setFromMatrixPosition(this.matrixWorld),this.panner.setPosition(e.x,e.y,e.z)}}()}),THREE.AudioListener=function(){THREE.Object3D.call(this),this.type="AudioListener",this.context=THREE.AudioContext,this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null},THREE.AudioListener.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.AudioListener,getInput:function(){return this.gain},removeFilter:function(){null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null)},getFilter:function(){return this.filter},setFilter:function(e){null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=e,this.gain.connect(this.filter),this.filter.connect(this.context.destination)},getMasterVolume:function(){return this.gain.gain.value},setMasterVolume:function(e){this.gain.gain.value=e},updateMatrixWorld:function(){var e=new THREE.Vector3,t=new THREE.Quaternion,i=new THREE.Vector3,r=new THREE.Vector3;return function(n){THREE.Object3D.prototype.updateMatrixWorld.call(this,n),n=this.context.listener;var o=this.up;this.matrixWorld.decompose(e,t,i),r.set(0,0,-1).applyQuaternion(t),n.setPosition(e.x,e.y,e.z),n.setOrientation(r.x,r.y,r.z,o.x,o.y,o.z)}}()}),THREE.Camera=function(){THREE.Object3D.call(this),this.type="Camera",this.matrixWorldInverse=new THREE.Matrix4,this.projectionMatrix=new THREE.Matrix4},THREE.Camera.prototype=Object.create(THREE.Object3D.prototype),THREE.Camera.prototype.constructor=THREE.Camera,THREE.Camera.prototype.getWorldDirection=function(){var e=new THREE.Quaternion;return function(t){return t=t||new THREE.Vector3,this.getWorldQuaternion(e),t.set(0,0,-1).applyQuaternion(e)}}(),THREE.Camera.prototype.lookAt=function(){var e=new THREE.Matrix4;return function(t){e.lookAt(this.position,t,this.up),
this.quaternion.setFromRotationMatrix(e)}}(),THREE.Camera.prototype.clone=function(){return(new this.constructor).copy(this)},THREE.Camera.prototype.copy=function(e){return THREE.Object3D.prototype.copy.call(this,e),this.matrixWorldInverse.copy(e.matrixWorldInverse),this.projectionMatrix.copy(e.projectionMatrix),this},THREE.CubeCamera=function(e,t,i){THREE.Object3D.call(this),this.type="CubeCamera";var r=new THREE.PerspectiveCamera(90,1,e,t);r.up.set(0,-1,0),r.lookAt(new THREE.Vector3(1,0,0)),this.add(r);var n=new THREE.PerspectiveCamera(90,1,e,t);n.up.set(0,-1,0),n.lookAt(new THREE.Vector3(-1,0,0)),this.add(n);var o=new THREE.PerspectiveCamera(90,1,e,t);o.up.set(0,0,1),o.lookAt(new THREE.Vector3(0,1,0)),this.add(o);var a=new THREE.PerspectiveCamera(90,1,e,t);a.up.set(0,0,-1),a.lookAt(new THREE.Vector3(0,-1,0)),this.add(a);var s=new THREE.PerspectiveCamera(90,1,e,t);s.up.set(0,-1,0),s.lookAt(new THREE.Vector3(0,0,1)),this.add(s);var c=new THREE.PerspectiveCamera(90,1,e,t);c.up.set(0,-1,0),c.lookAt(new THREE.Vector3(0,0,-1)),this.add(c),this.renderTarget=new THREE.WebGLRenderTargetCube(i,i,{format:THREE.RGBFormat,magFilter:THREE.LinearFilter,minFilter:THREE.LinearFilter}),this.updateCubeMap=function(e,t){null===this.parent&&this.updateMatrixWorld();var i=this.renderTarget,h=i.texture.generateMipmaps;i.texture.generateMipmaps=!1,i.activeCubeFace=0,e.render(t,r,i),i.activeCubeFace=1,e.render(t,n,i),i.activeCubeFace=2,e.render(t,o,i),i.activeCubeFace=3,e.render(t,a,i),i.activeCubeFace=4,e.render(t,s,i),i.texture.generateMipmaps=h,i.activeCubeFace=5,e.render(t,c,i),e.setRenderTarget(null)}},THREE.CubeCamera.prototype=Object.create(THREE.Object3D.prototype),THREE.CubeCamera.prototype.constructor=THREE.CubeCamera,THREE.OrthographicCamera=function(e,t,i,r,n,o){THREE.Camera.call(this),this.type="OrthographicCamera",this.zoom=1,this.left=e,this.right=t,this.top=i,this.bottom=r,this.near=void 0!==n?n:.1,this.far=void 0!==o?o:2e3,this.updateProjectionMatrix()},THREE.OrthographicCamera.prototype=Object.assign(Object.create(THREE.Camera.prototype),{constructor:THREE.OrthographicCamera,copy:function(e){return THREE.Camera.prototype.copy.call(this,e),this.left=e.left,this.right=e.right,this.top=e.top,this.bottom=e.bottom,this.near=e.near,this.far=e.far,this.zoom=e.zoom,this},updateProjectionMatrix:function(){var e=(this.right-this.left)/(2*this.zoom),t=(this.top-this.bottom)/(2*this.zoom),i=(this.right+this.left)/2,r=(this.top+this.bottom)/2;this.projectionMatrix.makeOrthographic(i-e,i+e,r+t,r-t,this.near,this.far)},toJSON:function(e){return e=THREE.Object3D.prototype.toJSON.call(this,e),e.object.zoom=this.zoom,e.object.left=this.left,e.object.right=this.right,e.object.top=this.top,e.object.bottom=this.bottom,e.object.near=this.near,e.object.far=this.far,e}}),THREE.PerspectiveCamera=function(e,t,i,r){THREE.Camera.call(this),this.type="PerspectiveCamera",this.fov=void 0!==e?e:50,this.zoom=1,this.near=void 0!==i?i:.1,this.far=void 0!==r?r:2e3,this.focus=10,this.aspect=void 0!==t?t:1,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()},THREE.PerspectiveCamera.prototype=Object.assign(Object.create(THREE.Camera.prototype),{constructor:THREE.PerspectiveCamera,copy:function(e){return THREE.Camera.prototype.copy.call(this,e),this.fov=e.fov,this.zoom=e.zoom,this.near=e.near,this.far=e.far,this.focus=e.focus,this.aspect=e.aspect,this.view=null===e.view?null:Object.assign({},e.view),this.filmGauge=e.filmGauge,this.filmOffset=e.filmOffset,this},setFocalLength:function(e){e=.5*this.getFilmHeight()/e,this.fov=2*THREE.Math.RAD2DEG*Math.atan(e),this.updateProjectionMatrix()},getFocalLength:function(){var e=Math.tan(.5*THREE.Math.DEG2RAD*this.fov);return.5*this.getFilmHeight()/e},getEffectiveFOV:function(){return 2*THREE.Math.RAD2DEG*Math.atan(Math.tan(.5*THREE.Math.DEG2RAD*this.fov)/this.zoom)},getFilmWidth:function(){return this.filmGauge*Math.min(this.aspect,1)},getFilmHeight:function(){return this.filmGauge/Math.max(this.aspect,1)},setViewOffset:function(e,t,i,r,n,o){this.aspect=e/t,this.view={fullWidth:e,fullHeight:t,offsetX:i,offsetY:r,width:n,height:o},this.updateProjectionMatrix()},clearViewOffset:function(){this.view=null,this.updateProjectionMatrix()},updateProjectionMatrix:function(){var e=this.near,t=e*Math.tan(.5*THREE.Math.DEG2RAD*this.fov)/this.zoom,i=2*t,r=this.aspect*i,n=-.5*r,o=this.view;if(null!==o)var a=o.fullWidth,s=o.fullHeight,n=n+o.offsetX*r/a,t=t-o.offsetY*i/s,r=o.width/a*r,i=o.height/s*i;o=this.filmOffset,0!==o&&(n+=e*o/this.getFilmWidth()),this.projectionMatrix.makeFrustum(n,n+r,t-i,t,e,this.far)},toJSON:function(e){return e=THREE.Object3D.prototype.toJSON.call(this,e),e.object.fov=this.fov,e.object.zoom=this.zoom,e.object.near=this.near,e.object.far=this.far,e.object.focus=this.focus,e.object.aspect=this.aspect,null!==this.view&&(e.object.view=Object.assign({},this.view)),e.object.filmGauge=this.filmGauge,e.object.filmOffset=this.filmOffset,e}}),THREE.StereoCamera=function(){this.type="StereoCamera",this.aspect=1,this.cameraL=new THREE.PerspectiveCamera,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new THREE.PerspectiveCamera,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1},Object.assign(THREE.StereoCamera.prototype,{update:function(){var e,t,i,r,n,o=new THREE.Matrix4,a=new THREE.Matrix4;return function(s){if(e!==s.focus||t!==s.fov||i!==s.aspect*this.aspect||r!==s.near||n!==s.far){e=s.focus,t=s.fov,i=s.aspect*this.aspect,r=s.near,n=s.far;var c,h,l=s.projectionMatrix.clone(),u=.032*r/e,p=r*Math.tan(THREE.Math.DEG2RAD*t*.5);a.elements[12]=-.032,o.elements[12]=.032,c=-p*i+u,h=p*i+u,l.elements[0]=2*r/(h-c),l.elements[8]=(h+c)/(h-c),this.cameraL.projectionMatrix.copy(l),c=-p*i-u,h=p*i-u,l.elements[0]=2*r/(h-c),l.elements[8]=(h+c)/(h-c),this.cameraR.projectionMatrix.copy(l)}this.cameraL.matrixWorld.copy(s.matrixWorld).multiply(a),this.cameraR.matrixWorld.copy(s.matrixWorld).multiply(o)}}()}),THREE.Light=function(e,t){THREE.Object3D.call(this),this.type="Light",this.color=new THREE.Color(e),this.intensity=void 0!==t?t:1,this.receiveShadow=void 0},THREE.Light.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.Light,copy:function(e){return THREE.Object3D.prototype.copy.call(this,e),this.color.copy(e.color),this.intensity=e.intensity,this},toJSON:function(e){return e=THREE.Object3D.prototype.toJSON.call(this,e),e.object.color=this.color.getHex(),e.object.intensity=this.intensity,void 0!==this.groundColor&&(e.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(e.object.distance=this.distance),void 0!==this.angle&&(e.object.angle=this.angle),void 0!==this.decay&&(e.object.decay=this.decay),void 0!==this.penumbra&&(e.object.penumbra=this.penumbra),e}}),THREE.LightShadow=function(e){this.camera=e,this.bias=0,this.radius=1,this.mapSize=new THREE.Vector2(512,512),this.map=null,this.matrix=new THREE.Matrix4},Object.assign(THREE.LightShadow.prototype,{copy:function(e){return this.camera=e.camera.clone(),this.bias=e.bias,this.radius=e.radius,this.mapSize.copy(e.mapSize),this},clone:function(){return(new this.constructor).copy(this)}}),THREE.AmbientLight=function(e,t){THREE.Light.call(this,e,t),this.type="AmbientLight",this.castShadow=void 0},THREE.AmbientLight.prototype=Object.assign(Object.create(THREE.Light.prototype),{constructor:THREE.AmbientLight}),THREE.DirectionalLight=function(e,t){THREE.Light.call(this,e,t),this.type="DirectionalLight",this.position.set(0,1,0),this.updateMatrix(),this.target=new THREE.Object3D,this.shadow=new THREE.DirectionalLightShadow},THREE.DirectionalLight.prototype=Object.assign(Object.create(THREE.Light.prototype),{constructor:THREE.DirectionalLight,copy:function(e){return THREE.Light.prototype.copy.call(this,e),this.target=e.target.clone(),this.shadow=e.shadow.clone(),this}}),THREE.DirectionalLightShadow=function(e){THREE.LightShadow.call(this,new THREE.OrthographicCamera(-5,5,5,-5,.5,500))},THREE.DirectionalLightShadow.prototype=Object.assign(Object.create(THREE.LightShadow.prototype),{constructor:THREE.DirectionalLightShadow}),THREE.HemisphereLight=function(e,t,i){THREE.Light.call(this,e,i),this.type="HemisphereLight",this.castShadow=void 0,this.position.set(0,1,0),this.updateMatrix(),this.groundColor=new THREE.Color(t)},THREE.HemisphereLight.prototype=Object.assign(Object.create(THREE.Light.prototype),{constructor:THREE.HemisphereLight,copy:function(e){return THREE.Light.prototype.copy.call(this,e),this.groundColor.copy(e.groundColor),this}}),THREE.PointLight=function(e,t,i,r){THREE.Light.call(this,e,t),this.type="PointLight",Object.defineProperty(this,"power",{get:function(){return 4*this.intensity*Math.PI},set:function(e){this.intensity=e/(4*Math.PI)}}),this.distance=void 0!==i?i:0,this.decay=void 0!==r?r:1,this.shadow=new THREE.LightShadow(new THREE.PerspectiveCamera(90,1,.5,500))},THREE.PointLight.prototype=Object.assign(Object.create(THREE.Light.prototype),{constructor:THREE.PointLight,copy:function(e){return THREE.Light.prototype.copy.call(this,e),this.distance=e.distance,this.decay=e.decay,this.shadow=e.shadow.clone(),this}}),THREE.SpotLight=function(e,t,i,r,n,o){THREE.Light.call(this,e,t),this.type="SpotLight",this.position.set(0,1,0),this.updateMatrix(),this.target=new THREE.Object3D,Object.defineProperty(this,"power",{get:function(){return this.intensity*Math.PI},set:function(e){this.intensity=e/Math.PI}}),this.distance=void 0!==i?i:0,this.angle=void 0!==r?r:Math.PI/3,this.penumbra=void 0!==n?n:0,this.decay=void 0!==o?o:1,this.shadow=new THREE.SpotLightShadow},THREE.SpotLight.prototype=Object.assign(Object.create(THREE.Light.prototype),{constructor:THREE.SpotLight,copy:function(e){return THREE.Light.prototype.copy.call(this,e),this.distance=e.distance,this.angle=e.angle,this.penumbra=e.penumbra,this.decay=e.decay,this.target=e.target.clone(),this.shadow=e.shadow.clone(),this}}),THREE.SpotLightShadow=function(){THREE.LightShadow.call(this,new THREE.PerspectiveCamera(50,1,.5,500))},THREE.SpotLightShadow.prototype=Object.assign(Object.create(THREE.LightShadow.prototype),{constructor:THREE.SpotLightShadow,update:function(e){var t=2*THREE.Math.RAD2DEG*e.angle,i=this.mapSize.width/this.mapSize.height;e=e.distance||500;var r=this.camera;t===r.fov&&i===r.aspect&&e===r.far||(r.fov=t,r.aspect=i,r.far=e,r.updateProjectionMatrix())}}),THREE.AudioLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager},THREE.AudioLoader.prototype={constructor:THREE.AudioLoader,load:function(e,t,i,r){var n=new THREE.XHRLoader(this.manager);n.setResponseType("arraybuffer"),n.load(e,function(e){THREE.AudioContext.decodeAudioData(e,function(e){t(e)})},i,r)}},THREE.Cache={enabled:!1,files:{},add:function(e,t){!1!==this.enabled&&(this.files[e]=t)},get:function(e){return!1!==this.enabled?this.files[e]:void 0},remove:function(e){delete this.files[e]},clear:function(){this.files={}}},THREE.Loader=function(){this.onLoadStart=function(){},this.onLoadProgress=function(){},this.onLoadComplete=function(){}},THREE.Loader.prototype={constructor:THREE.Loader,crossOrigin:void 0,extractUrlBase:function(e){return e=e.split("/"),1===e.length?"./":(e.pop(),e.join("/")+"/")},initMaterials:function(e,t,i){for(var r=[],n=0;n<e.length;++n)r[n]=this.createMaterial(e[n],t,i);return r},createMaterial:function(){var e,t,i;return function(r,n,o){function a(e,i,r,a,s){e=n+e;var h=THREE.Loader.Handlers.get(e);return null!==h?e=h.load(e):(t.setCrossOrigin(o),e=t.load(e)),void 0!==i&&(e.repeat.fromArray(i),1!==i[0]&&(e.wrapS=THREE.RepeatWrapping),1!==i[1]&&(e.wrapT=THREE.RepeatWrapping)),void 0!==r&&e.offset.fromArray(r),void 0!==a&&("repeat"===a[0]&&(e.wrapS=THREE.RepeatWrapping),"mirror"===a[0]&&(e.wrapS=THREE.MirroredRepeatWrapping),"repeat"===a[1]&&(e.wrapT=THREE.RepeatWrapping),"mirror"===a[1]&&(e.wrapT=THREE.MirroredRepeatWrapping)),void 0!==s&&(e.anisotropy=s),i=THREE.Math.generateUUID(),c[i]=e,i}void 0===e&&(e=new THREE.Color),void 0===t&&(t=new THREE.TextureLoader),void 0===i&&(i=new THREE.MaterialLoader);var s,c={},h={uuid:THREE.Math.generateUUID(),type:"MeshLambertMaterial"};for(s in r){var l=r[s];switch(s){case"DbgColor":case"DbgIndex":case"opticalDensity":case"illumination":break;case"DbgName":h.name=l;break;case"blending":h.blending=THREE[l];break;case"colorAmbient":case"mapAmbient":console.warn("THREE.Loader.createMaterial:",s,"is no longer supported.");break;case"colorDiffuse":h.color=e.fromArray(l).getHex();break;case"colorSpecular":h.specular=e.fromArray(l).getHex();break;case"colorEmissive":h.emissive=e.fromArray(l).getHex();break;case"specularCoef":h.shininess=l;break;case"shading":"basic"===l.toLowerCase()&&(h.type="MeshBasicMaterial"),"phong"===l.toLowerCase()&&(h.type="MeshPhongMaterial");break;case"mapDiffuse":h.map=a(l,r.mapDiffuseRepeat,r.mapDiffuseOffset,r.mapDiffuseWrap,r.mapDiffuseAnisotropy);break;case"mapDiffuseRepeat":case"mapDiffuseOffset":case"mapDiffuseWrap":case"mapDiffuseAnisotropy":break;case"mapLight":h.lightMap=a(l,r.mapLightRepeat,r.mapLightOffset,r.mapLightWrap,r.mapLightAnisotropy);break;case"mapLightRepeat":case"mapLightOffset":case"mapLightWrap":case"mapLightAnisotropy":break;case"mapAO":h.aoMap=a(l,r.mapAORepeat,r.mapAOOffset,r.mapAOWrap,r.mapAOAnisotropy);break;case"mapAORepeat":case"mapAOOffset":case"mapAOWrap":case"mapAOAnisotropy":break;case"mapBump":h.bumpMap=a(l,r.mapBumpRepeat,r.mapBumpOffset,r.mapBumpWrap,r.mapBumpAnisotropy);break;case"mapBumpScale":h.bumpScale=l;break;case"mapBumpRepeat":case"mapBumpOffset":case"mapBumpWrap":case"mapBumpAnisotropy":break;case"mapNormal":h.normalMap=a(l,r.mapNormalRepeat,r.mapNormalOffset,r.mapNormalWrap,r.mapNormalAnisotropy);break;case"mapNormalFactor":h.normalScale=[l,l];break;case"mapNormalRepeat":case"mapNormalOffset":case"mapNormalWrap":case"mapNormalAnisotropy":break;case"mapSpecular":h.specularMap=a(l,r.mapSpecularRepeat,r.mapSpecularOffset,r.mapSpecularWrap,r.mapSpecularAnisotropy);break;case"mapSpecularRepeat":case"mapSpecularOffset":case"mapSpecularWrap":case"mapSpecularAnisotropy":break;case"mapAlpha":h.alphaMap=a(l,r.mapAlphaRepeat,r.mapAlphaOffset,r.mapAlphaWrap,r.mapAlphaAnisotropy);break;case"mapAlphaRepeat":case"mapAlphaOffset":case"mapAlphaWrap":case"mapAlphaAnisotropy":break;case"flipSided":h.side=THREE.BackSide;break;case"doubleSided":h.side=THREE.DoubleSide;break;case"transparency":console.warn("THREE.Loader.createMaterial: transparency has been renamed to opacity"),h.opacity=l;break;case"depthTest":case"depthWrite":case"colorWrite":case"opacity":case"reflectivity":case"transparent":case"visible":case"wireframe":h[s]=l;break;case"vertexColors":!0===l&&(h.vertexColors=THREE.VertexColors),"face"===l&&(h.vertexColors=THREE.FaceColors);break;default:console.error("THREE.Loader.createMaterial: Unsupported",s,l)}}return"MeshBasicMaterial"===h.type&&delete h.emissive,"MeshPhongMaterial"!==h.type&&delete h.specular,1>h.opacity&&(h.transparent=!0),i.setTextures(c),i.parse(h)}}()},THREE.Loader.Handlers={handlers:[],add:function(e,t){this.handlers.push(e,t)},get:function(e){for(var t=this.handlers,i=0,r=t.length;r>i;i+=2){var n=t[i+1];if(t[i].test(e))return n}return null}},THREE.XHRLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager},THREE.XHRLoader.prototype={constructor:THREE.XHRLoader,load:function(e,t,i,r){void 0!==this.path&&(e=this.path+e);var n=this,o=THREE.Cache.get(e);if(void 0!==o)return t&&setTimeout(function(){t(o)},0),o;var a=new XMLHttpRequest;return a.overrideMimeType("text/plain"),a.open("GET",e,!0),a.addEventListener("load",function(i){var o=i.target.response;THREE.Cache.add(e,o),200===this.status?(t&&t(o),n.manager.itemEnd(e)):0===this.status?(console.warn("THREE.XHRLoader: HTTP Status 0 received."),t&&t(o),n.manager.itemEnd(e)):(r&&r(i),n.manager.itemError(e))},!1),void 0!==i&&a.addEventListener("progress",function(e){i(e)},!1),a.addEventListener("error",function(t){r&&r(t),n.manager.itemError(e)},!1),void 0!==this.responseType&&(a.responseType=this.responseType),void 0!==this.withCredentials&&(a.withCredentials=this.withCredentials),a.send(null),n.manager.itemStart(e),a},setPath:function(e){this.path=e},setResponseType:function(e){this.responseType=e},setWithCredentials:function(e){this.withCredentials=e}},THREE.FontLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager},THREE.FontLoader.prototype={constructor:THREE.FontLoader,load:function(e,t,i,r){var n=this;new THREE.XHRLoader(this.manager).load(e,function(e){var i;try{i=JSON.parse(e)}catch(r){console.warn("THREE.FontLoader: typeface.js support is being deprecated. Use typeface.json instead."),i=JSON.parse(e.substring(65,e.length-2))}e=n.parse(i),t&&t(e)},i,r)},parse:function(e){return new THREE.Font(e)}},THREE.ImageLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager},THREE.ImageLoader.prototype={constructor:THREE.ImageLoader,load:function(e,t,i,r){void 0!==this.path&&(e=this.path+e);var n=this,o=THREE.Cache.get(e);if(void 0!==o)return n.manager.itemStart(e),t?setTimeout(function(){t(o),n.manager.itemEnd(e)},0):n.manager.itemEnd(e),o;var a=document.createElement("img");return a.addEventListener("load",function(i){THREE.Cache.add(e,this),t&&t(this),n.manager.itemEnd(e)},!1),void 0!==i&&a.addEventListener("progress",function(e){i(e)},!1),a.addEventListener("error",function(t){r&&r(t),n.manager.itemError(e)},!1),void 0!==this.crossOrigin&&(a.crossOrigin=this.crossOrigin),n.manager.itemStart(e),a.src=e,a},setCrossOrigin:function(e){this.crossOrigin=e},setPath:function(e){this.path=e}},THREE.JSONLoader=function(e){"boolean"==typeof e&&(console.warn("THREE.JSONLoader: showStatus parameter has been removed from constructor."),e=void 0),this.manager=void 0!==e?e:THREE.DefaultLoadingManager,this.withCredentials=!1},THREE.JSONLoader.prototype={constructor:THREE.JSONLoader,get statusDomElement(){return void 0===this._statusDomElement&&(this._statusDomElement=document.createElement("div")),console.warn("THREE.JSONLoader: .statusDomElement has been removed."),this._statusDomElement},load:function(e,t,i,r){var n=this,o=this.texturePath&&"string"==typeof this.texturePath?this.texturePath:THREE.Loader.prototype.extractUrlBase(e),a=new THREE.XHRLoader(this.manager);a.setWithCredentials(this.withCredentials),a.load(e,function(i){i=JSON.parse(i);var r=i.metadata;if(void 0!==r&&(r=r.type,void 0!==r)){if("object"===r.toLowerCase())return void console.error("THREE.JSONLoader: "+e+" should be loaded with THREE.ObjectLoader instead.");if("scene"===r.toLowerCase())return void console.error("THREE.JSONLoader: "+e+" should be loaded with THREE.SceneLoader instead.")}i=n.parse(i,o),t(i.geometry,i.materials)},i,r)},setTexturePath:function(e){this.texturePath=e},parse:function(e,t){var i=new THREE.Geometry,r=void 0!==e.scale?1/e.scale:1;return function(t){var r,n,o,a,s,c,h,l,u,p,d,f,E,m=e.faces;c=e.vertices;var g=e.normals,T=e.colors,v=0;if(void 0!==e.uvs){for(r=0;r<e.uvs.length;r++)e.uvs[r].length&&v++;for(r=0;v>r;r++)i.faceVertexUvs[r]=[]}for(a=0,s=c.length;s>a;)r=new THREE.Vector3,r.x=c[a++]*t,r.y=c[a++]*t,r.z=c[a++]*t,i.vertices.push(r);for(a=0,s=m.length;s>a;)if(t=m[a++],u=1&t,o=2&t,r=8&t,h=16&t,p=32&t,c=64&t,t&=128,u){if(u=new THREE.Face3,u.a=m[a],u.b=m[a+1],u.c=m[a+3],d=new THREE.Face3,d.a=m[a+1],d.b=m[a+2],d.c=m[a+3],a+=4,o&&(o=m[a++],u.materialIndex=o,d.materialIndex=o),o=i.faces.length,r)for(r=0;v>r;r++)for(f=e.uvs[r],i.faceVertexUvs[r][o]=[],i.faceVertexUvs[r][o+1]=[],n=0;4>n;n++)l=m[a++],E=f[2*l],l=f[2*l+1],E=new THREE.Vector2(E,l),2!==n&&i.faceVertexUvs[r][o].push(E),0!==n&&i.faceVertexUvs[r][o+1].push(E);if(h&&(h=3*m[a++],u.normal.set(g[h++],g[h++],g[h]),d.normal.copy(u.normal)),p)for(r=0;4>r;r++)h=3*m[a++],p=new THREE.Vector3(g[h++],g[h++],g[h]),2!==r&&u.vertexNormals.push(p),0!==r&&d.vertexNormals.push(p);if(c&&(c=m[a++],c=T[c],u.color.setHex(c),d.color.setHex(c)),t)for(r=0;4>r;r++)c=m[a++],c=T[c],2!==r&&u.vertexColors.push(new THREE.Color(c)),0!==r&&d.vertexColors.push(new THREE.Color(c));i.faces.push(u),i.faces.push(d)}else{if(u=new THREE.Face3,u.a=m[a++],u.b=m[a++],u.c=m[a++],o&&(o=m[a++],u.materialIndex=o),o=i.faces.length,r)for(r=0;v>r;r++)for(f=e.uvs[r],i.faceVertexUvs[r][o]=[],n=0;3>n;n++)l=m[a++],E=f[2*l],l=f[2*l+1],E=new THREE.Vector2(E,l),i.faceVertexUvs[r][o].push(E);if(h&&(h=3*m[a++],u.normal.set(g[h++],g[h++],g[h])),p)for(r=0;3>r;r++)h=3*m[a++],p=new THREE.Vector3(g[h++],g[h++],g[h]),u.vertexNormals.push(p);if(c&&(c=m[a++],u.color.setHex(T[c])),t)for(r=0;3>r;r++)c=m[a++],u.vertexColors.push(new THREE.Color(T[c]));i.faces.push(u)}}(r),function(){var t=void 0!==e.influencesPerVertex?e.influencesPerVertex:2;if(e.skinWeights)for(var r=0,n=e.skinWeights.length;n>r;r+=t)i.skinWeights.push(new THREE.Vector4(e.skinWeights[r],t>1?e.skinWeights[r+1]:0,t>2?e.skinWeights[r+2]:0,t>3?e.skinWeights[r+3]:0));if(e.skinIndices)for(r=0,n=e.skinIndices.length;n>r;r+=t)i.skinIndices.push(new THREE.Vector4(e.skinIndices[r],t>1?e.skinIndices[r+1]:0,t>2?e.skinIndices[r+2]:0,t>3?e.skinIndices[r+3]:0));i.bones=e.bones,i.bones&&0<i.bones.length&&(i.skinWeights.length!==i.skinIndices.length||i.skinIndices.length!==i.vertices.length)&&console.warn("When skinning, number of vertices ("+i.vertices.length+"), skinIndices ("+i.skinIndices.length+"), and skinWeights ("+i.skinWeights.length+") should match.")}(),function(t){if(void 0!==e.morphTargets)for(var r=0,n=e.morphTargets.length;n>r;r++){i.morphTargets[r]={},i.morphTargets[r].name=e.morphTargets[r].name,i.morphTargets[r].vertices=[];for(var o=i.morphTargets[r].vertices,a=e.morphTargets[r].vertices,s=0,c=a.length;c>s;s+=3){var h=new THREE.Vector3;h.x=a[s]*t,h.y=a[s+1]*t,h.z=a[s+2]*t,o.push(h)}}if(void 0!==e.morphColors&&0<e.morphColors.length)for(console.warn('THREE.JSONLoader: "morphColors" no longer supported. Using them as face colors.'),t=i.faces,o=e.morphColors[0].colors,r=0,n=t.length;n>r;r++)t[r].color.fromArray(o,3*r)}(r),function(){var t=[],r=[];void 0!==e.animation&&r.push(e.animation),void 0!==e.animations&&(e.animations.length?r=r.concat(e.animations):r.push(e.animations));for(var n=0;n<r.length;n++){var o=THREE.AnimationClip.parseAnimation(r[n],i.bones);o&&t.push(o)}i.morphTargets&&(r=THREE.AnimationClip.CreateClipsFromMorphTargetSequences(i.morphTargets,10),t=t.concat(r)),0<t.length&&(i.animations=t)}(),i.computeFaceNormals(),i.computeBoundingSphere(),void 0===e.materials||0===e.materials.length?{geometry:i}:(r=THREE.Loader.prototype.initMaterials(e.materials,t,this.crossOrigin),{geometry:i,materials:r})}},THREE.LoadingManager=function(e,t,i){var r=this,n=!1,o=0,a=0;this.onStart=void 0,this.onLoad=e,this.onProgress=t,this.onError=i,this.itemStart=function(e){a++,!1===n&&void 0!==r.onStart&&r.onStart(e,o,a),n=!0},this.itemEnd=function(e){o++,void 0!==r.onProgress&&r.onProgress(e,o,a),o===a&&(n=!1,void 0!==r.onLoad)&&r.onLoad()},this.itemError=function(e){void 0!==r.onError&&r.onError(e)}},THREE.DefaultLoadingManager=new THREE.LoadingManager,THREE.BufferGeometryLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager},THREE.BufferGeometryLoader.prototype={constructor:THREE.BufferGeometryLoader,load:function(e,t,i,r){var n=this;new THREE.XHRLoader(n.manager).load(e,function(e){t(n.parse(JSON.parse(e)))},i,r)},parse:function(e){var t=new THREE.BufferGeometry,i=e.data.index,r={Int8Array:Int8Array,Uint8Array:Uint8Array,Uint8ClampedArray:Uint8ClampedArray,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};void 0!==i&&(i=new r[i.type](i.array),t.setIndex(new THREE.BufferAttribute(i,1)));var n,o=e.data.attributes;for(n in o){var a=o[n],i=new r[a.type](a.array);t.addAttribute(n,new THREE.BufferAttribute(i,a.itemSize,a.normalized))}if(r=e.data.groups||e.data.drawcalls||e.data.offsets,void 0!==r)for(n=0,i=r.length;n!==i;++n)o=r[n],t.addGroup(o.start,o.count,o.materialIndex);return e=e.data.boundingSphere,void 0!==e&&(r=new THREE.Vector3,void 0!==e.center&&r.fromArray(e.center),t.boundingSphere=new THREE.Sphere(r,e.radius)),t}},THREE.MaterialLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager,this.textures={}},THREE.MaterialLoader.prototype={constructor:THREE.MaterialLoader,load:function(e,t,i,r){var n=this;new THREE.XHRLoader(n.manager).load(e,function(e){t(n.parse(JSON.parse(e)))},i,r)},setTextures:function(e){this.textures=e},getTexture:function(e){var t=this.textures;return void 0===t[e]&&console.warn("THREE.MaterialLoader: Undefined texture",e),t[e]},parse:function(e){var t=new THREE[e.type];if(void 0!==e.uuid&&(t.uuid=e.uuid),void 0!==e.name&&(t.name=e.name),void 0!==e.color&&t.color.setHex(e.color),void 0!==e.roughness&&(t.roughness=e.roughness),void 0!==e.metalness&&(t.metalness=e.metalness),void 0!==e.emissive&&t.emissive.setHex(e.emissive),void 0!==e.specular&&t.specular.setHex(e.specular),void 0!==e.shininess&&(t.shininess=e.shininess),void 0!==e.uniforms&&(t.uniforms=e.uniforms),void 0!==e.vertexShader&&(t.vertexShader=e.vertexShader),void 0!==e.fragmentShader&&(t.fragmentShader=e.fragmentShader),void 0!==e.vertexColors&&(t.vertexColors=e.vertexColors),void 0!==e.shading&&(t.shading=e.shading),void 0!==e.blending&&(t.blending=e.blending),void 0!==e.side&&(t.side=e.side),void 0!==e.opacity&&(t.opacity=e.opacity),void 0!==e.transparent&&(t.transparent=e.transparent),void 0!==e.alphaTest&&(t.alphaTest=e.alphaTest),void 0!==e.depthTest&&(t.depthTest=e.depthTest),void 0!==e.depthWrite&&(t.depthWrite=e.depthWrite),void 0!==e.colorWrite&&(t.colorWrite=e.colorWrite),void 0!==e.wireframe&&(t.wireframe=e.wireframe),void 0!==e.wireframeLinewidth&&(t.wireframeLinewidth=e.wireframeLinewidth),void 0!==e.size&&(t.size=e.size),void 0!==e.sizeAttenuation&&(t.sizeAttenuation=e.sizeAttenuation),void 0!==e.map&&(t.map=this.getTexture(e.map)),void 0!==e.alphaMap&&(t.alphaMap=this.getTexture(e.alphaMap),t.transparent=!0),void 0!==e.bumpMap&&(t.bumpMap=this.getTexture(e.bumpMap)),void 0!==e.bumpScale&&(t.bumpScale=e.bumpScale),void 0!==e.normalMap&&(t.normalMap=this.getTexture(e.normalMap)),void 0!==e.normalScale){var i=e.normalScale;!1===Array.isArray(i)&&(i=[i,i]),t.normalScale=(new THREE.Vector2).fromArray(i)}if(void 0!==e.displacementMap&&(t.displacementMap=this.getTexture(e.displacementMap)),void 0!==e.displacementScale&&(t.displacementScale=e.displacementScale),void 0!==e.displacementBias&&(t.displacementBias=e.displacementBias),void 0!==e.roughnessMap&&(t.roughnessMap=this.getTexture(e.roughnessMap)),void 0!==e.metalnessMap&&(t.metalnessMap=this.getTexture(e.metalnessMap)),void 0!==e.emissiveMap&&(t.emissiveMap=this.getTexture(e.emissiveMap)),void 0!==e.emissiveIntensity&&(t.emissiveIntensity=e.emissiveIntensity),void 0!==e.specularMap&&(t.specularMap=this.getTexture(e.specularMap)),void 0!==e.envMap&&(t.envMap=this.getTexture(e.envMap),t.combine=THREE.MultiplyOperation),e.reflectivity&&(t.reflectivity=e.reflectivity),void 0!==e.lightMap&&(t.lightMap=this.getTexture(e.lightMap)),void 0!==e.lightMapIntensity&&(t.lightMapIntensity=e.lightMapIntensity),void 0!==e.aoMap&&(t.aoMap=this.getTexture(e.aoMap)),void 0!==e.aoMapIntensity&&(t.aoMapIntensity=e.aoMapIntensity),void 0!==e.materials)for(var i=0,r=e.materials.length;r>i;i++)t.materials.push(this.parse(e.materials[i]));return t}},THREE.ObjectLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager,this.texturePath=""},THREE.ObjectLoader.prototype={constructor:THREE.ObjectLoader,load:function(e,t,i,r){""===this.texturePath&&(this.texturePath=e.substring(0,e.lastIndexOf("/")+1));var n=this;new THREE.XHRLoader(n.manager).load(e,function(e){n.parse(JSON.parse(e),t)},i,r)},setTexturePath:function(e){this.texturePath=e},setCrossOrigin:function(e){this.crossOrigin=e},parse:function(e,t){var i=this.parseGeometries(e.geometries),r=this.parseImages(e.images,function(){void 0!==t&&t(n)}),r=this.parseTextures(e.textures,r),r=this.parseMaterials(e.materials,r),n=this.parseObject(e.object,i,r);return e.animations&&(n.animations=this.parseAnimations(e.animations)),void 0!==e.images&&0!==e.images.length||void 0===t||t(n),n},parseGeometries:function(e){var t={};if(void 0!==e)for(var i=new THREE.JSONLoader,r=new THREE.BufferGeometryLoader,n=0,o=e.length;o>n;n++){var a,s=e[n];switch(s.type){case"PlaneGeometry":case"PlaneBufferGeometry":a=new THREE[s.type](s.width,s.height,s.widthSegments,s.heightSegments);break;case"BoxGeometry":case"BoxBufferGeometry":case"CubeGeometry":a=new THREE[s.type](s.width,s.height,s.depth,s.widthSegments,s.heightSegments,s.depthSegments);break;case"CircleGeometry":case"CircleBufferGeometry":a=new THREE[s.type](s.radius,s.segments,s.thetaStart,s.thetaLength);break;case"CylinderGeometry":case"CylinderBufferGeometry":a=new THREE[s.type](s.radiusTop,s.radiusBottom,s.height,s.radialSegments,s.heightSegments,s.openEnded,s.thetaStart,s.thetaLength);break;case"ConeGeometry":case"ConeBufferGeometry":a=new THREE[s.type](s.radius,s.height,s.radialSegments,s.heightSegments,s.openEnded,s.thetaStart,s.thetaLength);break;case"SphereGeometry":case"SphereBufferGeometry":a=new THREE[s.type](s.radius,s.widthSegments,s.heightSegments,s.phiStart,s.phiLength,s.thetaStart,s.thetaLength);break;case"DodecahedronGeometry":case"IcosahedronGeometry":case"OctahedronGeometry":case"TetrahedronGeometry":a=new THREE[s.type](s.radius,s.detail);break;case"RingGeometry":case"RingBufferGeometry":a=new THREE[s.type](s.innerRadius,s.outerRadius,s.thetaSegments,s.phiSegments,s.thetaStart,s.thetaLength);break;case"TorusGeometry":case"TorusBufferGeometry":a=new THREE[s.type](s.radius,s.tube,s.radialSegments,s.tubularSegments,s.arc);break;case"TorusKnotGeometry":case"TorusKnotBufferGeometry":a=new THREE[s.type](s.radius,s.tube,s.tubularSegments,s.radialSegments,s.p,s.q);break;case"LatheGeometry":case"LatheBufferGeometry":a=new THREE[s.type](s.points,s.segments,s.phiStart,s.phiLength);break;case"BufferGeometry":a=r.parse(s);break;case"Geometry":a=i.parse(s.data,this.texturePath).geometry;break;default:console.warn('THREE.ObjectLoader: Unsupported geometry type "'+s.type+'"');continue}a.uuid=s.uuid,void 0!==s.name&&(a.name=s.name),t[s.uuid]=a}return t},parseMaterials:function(e,t){var i={};if(void 0!==e){var r=new THREE.MaterialLoader;r.setTextures(t);for(var n=0,o=e.length;o>n;n++){var a=r.parse(e[n]);i[a.uuid]=a}}return i},parseAnimations:function(e){for(var t=[],i=0;i<e.length;i++){var r=THREE.AnimationClip.parse(e[i]);t.push(r)}return t},parseImages:function(e,t){function i(e){return r.manager.itemStart(e),a.load(e,function(){r.manager.itemEnd(e)})}var r=this,n={};if(void 0!==e&&0<e.length){var o=new THREE.LoadingManager(t),a=new THREE.ImageLoader(o);a.setCrossOrigin(this.crossOrigin);for(var o=0,s=e.length;s>o;o++){var c=e[o],h=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(c.url)?c.url:r.texturePath+c.url;n[c.uuid]=i(h)}}return n},parseTextures:function(e,t){function i(e){return"number"==typeof e?e:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",e),THREE[e])}var r={};if(void 0!==e)for(var n=0,o=e.length;o>n;n++){var a=e[n];void 0===a.image&&console.warn('THREE.ObjectLoader: No "image" specified for',a.uuid),void 0===t[a.image]&&console.warn("THREE.ObjectLoader: Undefined image",a.image);var s=new THREE.Texture(t[a.image]);s.needsUpdate=!0,s.uuid=a.uuid,void 0!==a.name&&(s.name=a.name),void 0!==a.mapping&&(s.mapping=i(a.mapping)),void 0!==a.offset&&(s.offset=new THREE.Vector2(a.offset[0],a.offset[1])),void 0!==a.repeat&&(s.repeat=new THREE.Vector2(a.repeat[0],a.repeat[1])),void 0!==a.minFilter&&(s.minFilter=i(a.minFilter)),void 0!==a.magFilter&&(s.magFilter=i(a.magFilter)),void 0!==a.anisotropy&&(s.anisotropy=a.anisotropy),Array.isArray(a.wrap)&&(s.wrapS=i(a.wrap[0]),s.wrapT=i(a.wrap[1])),r[a.uuid]=s}return r},parseObject:function(){var e=new THREE.Matrix4;return function(t,i,r){function n(e){return void 0===i[e]&&console.warn("THREE.ObjectLoader: Undefined geometry",e),i[e]}function o(e){return void 0!==e?(void 0===r[e]&&console.warn("THREE.ObjectLoader: Undefined material",e),
r[e]):void 0}var a;switch(t.type){case"Scene":a=new THREE.Scene;break;case"PerspectiveCamera":a=new THREE.PerspectiveCamera(t.fov,t.aspect,t.near,t.far),void 0!==t.focus&&(a.focus=t.focus),void 0!==t.zoom&&(a.zoom=t.zoom),void 0!==t.filmGauge&&(a.filmGauge=t.filmGauge),void 0!==t.filmOffset&&(a.filmOffset=t.filmOffset),void 0!==t.view&&(a.view=Object.assign({},t.view));break;case"OrthographicCamera":a=new THREE.OrthographicCamera(t.left,t.right,t.top,t.bottom,t.near,t.far);break;case"AmbientLight":a=new THREE.AmbientLight(t.color,t.intensity);break;case"DirectionalLight":a=new THREE.DirectionalLight(t.color,t.intensity);break;case"PointLight":a=new THREE.PointLight(t.color,t.intensity,t.distance,t.decay);break;case"SpotLight":a=new THREE.SpotLight(t.color,t.intensity,t.distance,t.angle,t.penumbra,t.decay);break;case"HemisphereLight":a=new THREE.HemisphereLight(t.color,t.groundColor,t.intensity);break;case"Mesh":a=n(t.geometry);var s=o(t.material);a=a.bones&&0<a.bones.length?new THREE.SkinnedMesh(a,s):new THREE.Mesh(a,s);break;case"LOD":a=new THREE.LOD;break;case"Line":a=new THREE.Line(n(t.geometry),o(t.material),t.mode);break;case"PointCloud":case"Points":a=new THREE.Points(n(t.geometry),o(t.material));break;case"Sprite":a=new THREE.Sprite(o(t.material));break;case"Group":a=new THREE.Group;break;default:a=new THREE.Object3D}if(a.uuid=t.uuid,void 0!==t.name&&(a.name=t.name),void 0!==t.matrix?(e.fromArray(t.matrix),e.decompose(a.position,a.quaternion,a.scale)):(void 0!==t.position&&a.position.fromArray(t.position),void 0!==t.rotation&&a.rotation.fromArray(t.rotation),void 0!==t.scale&&a.scale.fromArray(t.scale)),void 0!==t.castShadow&&(a.castShadow=t.castShadow),void 0!==t.receiveShadow&&(a.receiveShadow=t.receiveShadow),void 0!==t.visible&&(a.visible=t.visible),void 0!==t.userData&&(a.userData=t.userData),void 0!==t.children)for(var c in t.children)a.add(this.parseObject(t.children[c],i,r));if("LOD"===t.type)for(t=t.levels,s=0;s<t.length;s++){var h=t[s];c=a.getObjectByProperty("uuid",h.object),void 0!==c&&a.addLevel(c,h.distance)}return a}}()},THREE.TextureLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager},THREE.TextureLoader.prototype={constructor:THREE.TextureLoader,load:function(e,t,i,r){var n=new THREE.Texture,o=new THREE.ImageLoader(this.manager);return o.setCrossOrigin(this.crossOrigin),o.setPath(this.path),o.load(e,function(e){n.image=e,n.needsUpdate=!0,void 0!==t&&t(n)},i,r),n},setCrossOrigin:function(e){this.crossOrigin=e},setPath:function(e){this.path=e}},THREE.CubeTextureLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager},THREE.CubeTextureLoader.prototype={constructor:THREE.CubeTextureLoader,load:function(e,t,i,r){function n(i){a.load(e[i],function(e){o.images[i]=e,s++,6===s&&(o.needsUpdate=!0,t&&t(o))},void 0,r)}var o=new THREE.CubeTexture,a=new THREE.ImageLoader(this.manager);a.setCrossOrigin(this.crossOrigin),a.setPath(this.path);var s=0;for(i=0;i<e.length;++i)n(i);return o},setCrossOrigin:function(e){this.crossOrigin=e},setPath:function(e){this.path=e}},THREE.DataTextureLoader=THREE.BinaryTextureLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager,this._parser=null},THREE.BinaryTextureLoader.prototype={constructor:THREE.BinaryTextureLoader,load:function(e,t,i,r){var n=this,o=new THREE.DataTexture,a=new THREE.XHRLoader(this.manager);return a.setResponseType("arraybuffer"),a.load(e,function(e){(e=n._parser(e))&&(void 0!==e.image?o.image=e.image:void 0!==e.data&&(o.image.width=e.width,o.image.height=e.height,o.image.data=e.data),o.wrapS=void 0!==e.wrapS?e.wrapS:THREE.ClampToEdgeWrapping,o.wrapT=void 0!==e.wrapT?e.wrapT:THREE.ClampToEdgeWrapping,o.magFilter=void 0!==e.magFilter?e.magFilter:THREE.LinearFilter,o.minFilter=void 0!==e.minFilter?e.minFilter:THREE.LinearMipMapLinearFilter,o.anisotropy=void 0!==e.anisotropy?e.anisotropy:1,void 0!==e.format&&(o.format=e.format),void 0!==e.type&&(o.type=e.type),void 0!==e.mipmaps&&(o.mipmaps=e.mipmaps),1===e.mipmapCount&&(o.minFilter=THREE.LinearFilter),o.needsUpdate=!0,t&&t(o,e))},i,r),o}},THREE.CompressedTextureLoader=function(e){this.manager=void 0!==e?e:THREE.DefaultLoadingManager,this._parser=null},THREE.CompressedTextureLoader.prototype={constructor:THREE.CompressedTextureLoader,load:function(e,t,i,r){function n(n){c.load(e[n],function(e){e=o._parser(e,!0),a[n]={width:e.width,height:e.height,format:e.format,mipmaps:e.mipmaps},h+=1,6===h&&(1===e.mipmapCount&&(s.minFilter=THREE.LinearFilter),s.format=e.format,s.needsUpdate=!0,t&&t(s))},i,r)}var o=this,a=[],s=new THREE.CompressedTexture;s.image=a;var c=new THREE.XHRLoader(this.manager);if(c.setPath(this.path),c.setResponseType("arraybuffer"),Array.isArray(e))for(var h=0,l=0,u=e.length;u>l;++l)n(l);else c.load(e,function(e){if(e=o._parser(e,!0),e.isCubemap)for(var i=e.mipmaps.length/e.mipmapCount,r=0;i>r;r++){a[r]={mipmaps:[]};for(var n=0;n<e.mipmapCount;n++)a[r].mipmaps.push(e.mipmaps[r*e.mipmapCount+n]),a[r].format=e.format,a[r].width=e.width,a[r].height=e.height}else s.image.width=e.width,s.image.height=e.height,s.mipmaps=e.mipmaps;1===e.mipmapCount&&(s.minFilter=THREE.LinearFilter),s.format=e.format,s.needsUpdate=!0,t&&t(s)},i,r);return s},setPath:function(e){this.path=e}},THREE.Material=function(){Object.defineProperty(this,"id",{value:THREE.MaterialIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="Material",this.lights=this.fog=!0,this.blending=THREE.NormalBlending,this.side=THREE.FrontSide,this.shading=THREE.SmoothShading,this.vertexColors=THREE.NoColors,this.opacity=1,this.transparent=!1,this.blendSrc=THREE.SrcAlphaFactor,this.blendDst=THREE.OneMinusSrcAlphaFactor,this.blendEquation=THREE.AddEquation,this.blendEquationAlpha=this.blendDstAlpha=this.blendSrcAlpha=null,this.depthFunc=THREE.LessEqualDepth,this.depthWrite=this.depthTest=!0,this.clippingPlanes=null,this.clipShadows=!1,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.alphaTest=this.polygonOffsetUnits=this.polygonOffsetFactor=0,this.premultipliedAlpha=!1,this.overdraw=0,this._needsUpdate=this.visible=!0},THREE.Material.prototype={constructor:THREE.Material,get needsUpdate(){return this._needsUpdate},set needsUpdate(e){!0===e&&this.update(),this._needsUpdate=e},setValues:function(e){if(void 0!==e)for(var t in e){var i=e[t];if(void 0===i)console.warn("THREE.Material: '"+t+"' parameter is undefined.");else{var r=this[t];void 0===r?console.warn("THREE."+this.type+": '"+t+"' is not a property of this material."):r instanceof THREE.Color?r.set(i):r instanceof THREE.Vector3&&i instanceof THREE.Vector3?r.copy(i):this[t]="overdraw"===t?Number(i):i}}},toJSON:function(e){function t(e){var t,i=[];for(t in e){var r=e[t];delete r.metadata,i.push(r)}return i}var i=void 0===e;i&&(e={textures:{},images:{}});var r={metadata:{version:4.4,type:"Material",generator:"Material.toJSON"}};return r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),this.color instanceof THREE.Color&&(r.color=this.color.getHex()),.5!==this.roughness&&(r.roughness=this.roughness),.5!==this.metalness&&(r.metalness=this.metalness),this.emissive instanceof THREE.Color&&(r.emissive=this.emissive.getHex()),this.specular instanceof THREE.Color&&(r.specular=this.specular.getHex()),void 0!==this.shininess&&(r.shininess=this.shininess),this.map instanceof THREE.Texture&&(r.map=this.map.toJSON(e).uuid),this.alphaMap instanceof THREE.Texture&&(r.alphaMap=this.alphaMap.toJSON(e).uuid),this.lightMap instanceof THREE.Texture&&(r.lightMap=this.lightMap.toJSON(e).uuid),this.bumpMap instanceof THREE.Texture&&(r.bumpMap=this.bumpMap.toJSON(e).uuid,r.bumpScale=this.bumpScale),this.normalMap instanceof THREE.Texture&&(r.normalMap=this.normalMap.toJSON(e).uuid,r.normalScale=this.normalScale.toArray()),this.displacementMap instanceof THREE.Texture&&(r.displacementMap=this.displacementMap.toJSON(e).uuid,r.displacementScale=this.displacementScale,r.displacementBias=this.displacementBias),this.roughnessMap instanceof THREE.Texture&&(r.roughnessMap=this.roughnessMap.toJSON(e).uuid),this.metalnessMap instanceof THREE.Texture&&(r.metalnessMap=this.metalnessMap.toJSON(e).uuid),this.emissiveMap instanceof THREE.Texture&&(r.emissiveMap=this.emissiveMap.toJSON(e).uuid),this.specularMap instanceof THREE.Texture&&(r.specularMap=this.specularMap.toJSON(e).uuid),this.envMap instanceof THREE.Texture&&(r.envMap=this.envMap.toJSON(e).uuid,r.reflectivity=this.reflectivity),void 0!==this.size&&(r.size=this.size),void 0!==this.sizeAttenuation&&(r.sizeAttenuation=this.sizeAttenuation),this.blending!==THREE.NormalBlending&&(r.blending=this.blending),this.shading!==THREE.SmoothShading&&(r.shading=this.shading),this.side!==THREE.FrontSide&&(r.side=this.side),this.vertexColors!==THREE.NoColors&&(r.vertexColors=this.vertexColors),1>this.opacity&&(r.opacity=this.opacity),!0===this.transparent&&(r.transparent=this.transparent),0<this.alphaTest&&(r.alphaTest=this.alphaTest),!0===this.premultipliedAlpha&&(r.premultipliedAlpha=this.premultipliedAlpha),!0===this.wireframe&&(r.wireframe=this.wireframe),1<this.wireframeLinewidth&&(r.wireframeLinewidth=this.wireframeLinewidth),i&&(i=t(e.textures),e=t(e.images),0<i.length&&(r.textures=i),0<e.length&&(r.images=e)),r},clone:function(){return(new this.constructor).copy(this)},copy:function(e){this.name=e.name,this.fog=e.fog,this.lights=e.lights,this.blending=e.blending,this.side=e.side,this.vertexColors=e.vertexColors,this.opacity=e.opacity,this.transparent=e.transparent,this.blendSrc=e.blendSrc,this.blendDst=e.blendDst,this.blendEquation=e.blendEquation,this.blendSrcAlpha=e.blendSrcAlpha,this.blendDstAlpha=e.blendDstAlpha,this.blendEquationAlpha=e.blendEquationAlpha,this.depthFunc=e.depthFunc,this.depthTest=e.depthTest,this.depthWrite=e.depthWrite,this.colorWrite=e.colorWrite,this.precision=e.precision,this.polygonOffset=e.polygonOffset,this.polygonOffsetFactor=e.polygonOffsetFactor,this.polygonOffsetUnits=e.polygonOffsetUnits,this.alphaTest=e.alphaTest,this.premultipliedAlpha=e.premultipliedAlpha,this.overdraw=e.overdraw,this.visible=e.visible,this.clipShadows=e.clipShadows,e=e.clippingPlanes;var t=null;if(null!==e)for(var i=e.length,t=Array(i),r=0;r!==i;++r)t[r]=e[r].clone();return this.clippingPlanes=t,this},update:function(){this.dispatchEvent({type:"update"})},dispose:function(){this.dispatchEvent({type:"dispose"})}},Object.assign(THREE.Material.prototype,THREE.EventDispatcher.prototype),THREE.MaterialIdCount=0,THREE.LineBasicMaterial=function(e){THREE.Material.call(this),this.type="LineBasicMaterial",this.color=new THREE.Color(16777215),this.linewidth=1,this.linejoin=this.linecap="round",this.lights=!1,this.setValues(e)},THREE.LineBasicMaterial.prototype=Object.create(THREE.Material.prototype),THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial,THREE.LineBasicMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.color.copy(e.color),this.linewidth=e.linewidth,this.linecap=e.linecap,this.linejoin=e.linejoin,this},THREE.LineDashedMaterial=function(e){THREE.Material.call(this),this.type="LineDashedMaterial",this.color=new THREE.Color(16777215),this.scale=this.linewidth=1,this.dashSize=3,this.gapSize=1,this.lights=!1,this.setValues(e)},THREE.LineDashedMaterial.prototype=Object.create(THREE.Material.prototype),THREE.LineDashedMaterial.prototype.constructor=THREE.LineDashedMaterial,THREE.LineDashedMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.color.copy(e.color),this.linewidth=e.linewidth,this.scale=e.scale,this.dashSize=e.dashSize,this.gapSize=e.gapSize,this},THREE.MeshBasicMaterial=function(e){THREE.Material.call(this),this.type="MeshBasicMaterial",this.color=new THREE.Color(16777215),this.aoMap=this.map=null,this.aoMapIntensity=1,this.envMap=this.alphaMap=this.specularMap=null,this.combine=THREE.MultiplyOperation,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinejoin=this.wireframeLinecap="round",this.lights=this.morphTargets=this.skinning=!1,this.setValues(e)},THREE.MeshBasicMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial,THREE.MeshBasicMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.color.copy(e.color),this.map=e.map,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.specularMap=e.specularMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this},THREE.MeshDepthMaterial=function(e){THREE.Material.call(this),this.type="MeshDepthMaterial",this.depthPacking=THREE.BasicDepthPacking,this.morphTargets=this.skinning=!1,this.displacementMap=this.alphaMap=this.map=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.lights=this.fog=!1,this.setValues(e)},THREE.MeshDepthMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial,THREE.MeshDepthMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.depthPacking=e.depthPacking,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.map=e.map,this.alphaMap=e.alphaMap,this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this},THREE.MeshLambertMaterial=function(e){THREE.Material.call(this),this.type="MeshLambertMaterial",this.color=new THREE.Color(16777215),this.lightMap=this.map=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new THREE.Color(0),this.emissiveIntensity=1,this.envMap=this.alphaMap=this.specularMap=this.emissiveMap=null,this.combine=THREE.MultiplyOperation,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinejoin=this.wireframeLinecap="round",this.morphNormals=this.morphTargets=this.skinning=!1,this.setValues(e)},THREE.MeshLambertMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial,THREE.MeshLambertMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.color.copy(e.color),this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.specularMap=e.specularMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this},THREE.MeshNormalMaterial=function(e){THREE.Material.call(this,e),this.type="MeshNormalMaterial",this.wireframe=!1,this.wireframeLinewidth=1,this.morphTargets=this.lights=this.fog=!1,this.setValues(e)},THREE.MeshNormalMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial,THREE.MeshNormalMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this},THREE.MeshPhongMaterial=function(e){THREE.Material.call(this),this.type="MeshPhongMaterial",this.color=new THREE.Color(16777215),this.specular=new THREE.Color(1118481),this.shininess=30,this.lightMap=this.map=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new THREE.Color(0),this.emissiveIntensity=1,this.bumpMap=this.emissiveMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new THREE.Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.envMap=this.alphaMap=this.specularMap=null,this.combine=THREE.MultiplyOperation,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinejoin=this.wireframeLinecap="round",this.morphNormals=this.morphTargets=this.skinning=!1,this.setValues(e)},THREE.MeshPhongMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial,THREE.MeshPhongMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.color.copy(e.color),this.specular.copy(e.specular),this.shininess=e.shininess,this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.specularMap=e.specularMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.combine=e.combine,this.reflectivity=e.reflectivity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this},THREE.MeshStandardMaterial=function(e){THREE.Material.call(this),this.defines={STANDARD:""},this.type="MeshStandardMaterial",this.color=new THREE.Color(16777215),this.metalness=this.roughness=.5,this.lightMap=this.map=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new THREE.Color(0),this.emissiveIntensity=1,this.bumpMap=this.emissiveMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new THREE.Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.envMap=this.alphaMap=this.metalnessMap=this.roughnessMap=null,this.envMapIntensity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinejoin=this.wireframeLinecap="round",this.morphNormals=this.morphTargets=this.skinning=!1,this.setValues(e)},THREE.MeshStandardMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshStandardMaterial.prototype.constructor=THREE.MeshStandardMaterial,THREE.MeshStandardMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.defines={STANDARD:""},this.color.copy(e.color),this.roughness=e.roughness,this.metalness=e.metalness,this.map=e.map,this.lightMap=e.lightMap,this.lightMapIntensity=e.lightMapIntensity,this.aoMap=e.aoMap,this.aoMapIntensity=e.aoMapIntensity,this.emissive.copy(e.emissive),this.emissiveMap=e.emissiveMap,this.emissiveIntensity=e.emissiveIntensity,this.bumpMap=e.bumpMap,this.bumpScale=e.bumpScale,this.normalMap=e.normalMap,this.normalScale.copy(e.normalScale),this.displacementMap=e.displacementMap,this.displacementScale=e.displacementScale,this.displacementBias=e.displacementBias,this.roughnessMap=e.roughnessMap,this.metalnessMap=e.metalnessMap,this.alphaMap=e.alphaMap,this.envMap=e.envMap,this.envMapIntensity=e.envMapIntensity,this.refractionRatio=e.refractionRatio,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.wireframeLinecap=e.wireframeLinecap,this.wireframeLinejoin=e.wireframeLinejoin,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this},THREE.MeshPhysicalMaterial=function(e){THREE.MeshStandardMaterial.call(this),this.defines={PHYSICAL:""},this.type="MeshPhysicalMaterial",this.reflectivity=.5,this.setValues(e)},THREE.MeshPhysicalMaterial.prototype=Object.create(THREE.MeshStandardMaterial.prototype),THREE.MeshPhysicalMaterial.prototype.constructor=THREE.MeshPhysicalMaterial,THREE.MeshPhysicalMaterial.prototype.copy=function(e){return THREE.MeshStandardMaterial.prototype.copy.call(this,e),this.defines={PHYSICAL:""},this.reflectivity=e.reflectivity,this},THREE.MultiMaterial=function(e){this.uuid=THREE.Math.generateUUID(),this.type="MultiMaterial",this.materials=e instanceof Array?e:[],this.visible=!0},THREE.MultiMaterial.prototype={constructor:THREE.MultiMaterial,toJSON:function(e){for(var t={metadata:{version:4.2,type:"material",generator:"MaterialExporter"},uuid:this.uuid,type:this.type,materials:[]},i=this.materials,r=0,n=i.length;n>r;r++){var o=i[r].toJSON(e);delete o.metadata,t.materials.push(o)}return t.visible=this.visible,t},clone:function(){for(var e=new this.constructor,t=0;t<this.materials.length;t++)e.materials.push(this.materials[t].clone());return e.visible=this.visible,e}},THREE.PointsMaterial=function(e){THREE.Material.call(this),this.type="PointsMaterial",this.color=new THREE.Color(16777215),this.map=null,this.size=1,this.sizeAttenuation=!0,this.lights=!1,this.setValues(e)},THREE.PointsMaterial.prototype=Object.create(THREE.Material.prototype),THREE.PointsMaterial.prototype.constructor=THREE.PointsMaterial,THREE.PointsMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.color.copy(e.color),this.map=e.map,this.size=e.size,this.sizeAttenuation=e.sizeAttenuation,this},THREE.ShaderMaterial=function(e){THREE.Material.call(this),this.type="ShaderMaterial",this.defines={},this.uniforms={},this.vertexShader="void main() {\n	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",this.fragmentShader="void main() {\n	gl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}",this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.morphNormals=this.morphTargets=this.skinning=this.clipping=this.lights=this.fog=!1,this.extensions={derivatives:!1,fragDepth:!1,drawBuffers:!1,shaderTextureLOD:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]},this.index0AttributeName=void 0,void 0!==e&&(void 0!==e.attributes&&console.error("THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead."),this.setValues(e))},THREE.ShaderMaterial.prototype=Object.create(THREE.Material.prototype),THREE.ShaderMaterial.prototype.constructor=THREE.ShaderMaterial,THREE.ShaderMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.fragmentShader=e.fragmentShader,this.vertexShader=e.vertexShader,this.uniforms=THREE.UniformsUtils.clone(e.uniforms),this.defines=e.defines,this.wireframe=e.wireframe,this.wireframeLinewidth=e.wireframeLinewidth,this.lights=e.lights,this.clipping=e.clipping,this.skinning=e.skinning,this.morphTargets=e.morphTargets,this.morphNormals=e.morphNormals,this.extensions=e.extensions,this},THREE.ShaderMaterial.prototype.toJSON=function(e){return e=THREE.Material.prototype.toJSON.call(this,e),e.uniforms=this.uniforms,e.vertexShader=this.vertexShader,e.fragmentShader=this.fragmentShader,e},THREE.RawShaderMaterial=function(e){THREE.ShaderMaterial.call(this,e),this.type="RawShaderMaterial"},THREE.RawShaderMaterial.prototype=Object.create(THREE.ShaderMaterial.prototype),THREE.RawShaderMaterial.prototype.constructor=THREE.RawShaderMaterial,THREE.SpriteMaterial=function(e){THREE.Material.call(this),this.type="SpriteMaterial",this.color=new THREE.Color(16777215),this.map=null,this.rotation=0,this.lights=this.fog=!1,this.setValues(e)},THREE.SpriteMaterial.prototype=Object.create(THREE.Material.prototype),THREE.SpriteMaterial.prototype.constructor=THREE.SpriteMaterial,THREE.SpriteMaterial.prototype.copy=function(e){return THREE.Material.prototype.copy.call(this,e),this.color.copy(e.color),this.map=e.map,this.rotation=e.rotation,this},THREE.ShadowMaterial=function(){THREE.ShaderMaterial.call(this,{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.lights,{opacity:{value:1}}]),vertexShader:THREE.ShaderChunk.shadow_vert,fragmentShader:THREE.ShaderChunk.shadow_frag}),this.transparent=this.lights=!0,Object.defineProperties(this,{opacity:{enumerable:!0,get:function(){return this.uniforms.opacity.value},set:function(e){this.uniforms.opacity.value=e}}})},THREE.ShadowMaterial.prototype=Object.create(THREE.ShaderMaterial.prototype),THREE.ShadowMaterial.prototype.constructor=THREE.ShadowMaterial,THREE.Texture=function(e,t,i,r,n,o,a,s,c,h){Object.defineProperty(this,"id",{value:THREE.TextureIdCount++}),this.uuid=THREE.Math.generateUUID(),this.sourceFile=this.name="",this.image=void 0!==e?e:THREE.Texture.DEFAULT_IMAGE,this.mipmaps=[],this.mapping=void 0!==t?t:THREE.Texture.DEFAULT_MAPPING,this.wrapS=void 0!==i?i:THREE.ClampToEdgeWrapping,this.wrapT=void 0!==r?r:THREE.ClampToEdgeWrapping,this.magFilter=void 0!==n?n:THREE.LinearFilter,this.minFilter=void 0!==o?o:THREE.LinearMipMapLinearFilter,this.anisotropy=void 0!==c?c:1,this.format=void 0!==a?a:THREE.RGBAFormat,this.type=void 0!==s?s:THREE.UnsignedByteType,this.offset=new THREE.Vector2(0,0),this.repeat=new THREE.Vector2(1,1),this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.encoding=void 0!==h?h:THREE.LinearEncoding,this.version=0,this.onUpdate=null},THREE.Texture.DEFAULT_IMAGE=void 0,THREE.Texture.DEFAULT_MAPPING=THREE.UVMapping,THREE.Texture.prototype={constructor:THREE.Texture,set needsUpdate(e){!0===e&&this.version++},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.image=e.image,this.mipmaps=e.mipmaps.slice(0),this.mapping=e.mapping,this.wrapS=e.wrapS,this.wrapT=e.wrapT,this.magFilter=e.magFilter,this.minFilter=e.minFilter,this.anisotropy=e.anisotropy,this.format=e.format,this.type=e.type,this.offset.copy(e.offset),this.repeat.copy(e.repeat),this.generateMipmaps=e.generateMipmaps,this.premultiplyAlpha=e.premultiplyAlpha,this.flipY=e.flipY,this.unpackAlignment=e.unpackAlignment,this.encoding=e.encoding,this},toJSON:function(e){if(void 0!==e.textures[this.uuid])return e.textures[this.uuid];var t={metadata:{version:4.4,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,mapping:this.mapping,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],wrap:[this.wrapS,this.wrapT],minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy};if(void 0!==this.image){var i=this.image;if(void 0===i.uuid&&(i.uuid=THREE.Math.generateUUID()),void 0===e.images[i.uuid]){var r,n=e.images,o=i.uuid,a=i.uuid;void 0!==i.toDataURL?r=i:(r=document.createElement("canvas"),r.width=i.width,r.height=i.height,r.getContext("2d").drawImage(i,0,0,i.width,i.height)),r=2048<r.width||2048<r.height?r.toDataURL("image/jpeg",.6):r.toDataURL("image/png"),n[o]={uuid:a,url:r}}t.image=i.uuid}return e.textures[this.uuid]=t},dispose:function(){this.dispatchEvent({type:"dispose"})},transformUv:function(e){if(this.mapping===THREE.UVMapping){if(e.multiply(this.repeat),e.add(this.offset),0>e.x||1<e.x)switch(this.wrapS){case THREE.RepeatWrapping:e.x-=Math.floor(e.x);break;case THREE.ClampToEdgeWrapping:e.x=0>e.x?0:1;break;case THREE.MirroredRepeatWrapping:1===Math.abs(Math.floor(e.x)%2)?e.x=Math.ceil(e.x)-e.x:e.x-=Math.floor(e.x)}if(0>e.y||1<e.y)switch(this.wrapT){case THREE.RepeatWrapping:e.y-=Math.floor(e.y);break;case THREE.ClampToEdgeWrapping:e.y=0>e.y?0:1;break;case THREE.MirroredRepeatWrapping:1===Math.abs(Math.floor(e.y)%2)?e.y=Math.ceil(e.y)-e.y:e.y-=Math.floor(e.y)}this.flipY&&(e.y=1-e.y)}}},Object.assign(THREE.Texture.prototype,THREE.EventDispatcher.prototype),THREE.TextureIdCount=0,THREE.DepthTexture=function(e,t,i,r,n,o,a,s,c){THREE.Texture.call(this,null,r,n,o,a,s,THREE.DepthFormat,i,c),this.image={width:e,height:t},this.type=void 0!==i?i:THREE.UnsignedShortType,this.magFilter=void 0!==a?a:THREE.NearestFilter,this.minFilter=void 0!==s?s:THREE.NearestFilter,this.generateMipmaps=this.flipY=!1},THREE.DepthTexture.prototype=Object.create(THREE.Texture.prototype),THREE.DepthTexture.prototype.constructor=THREE.DepthTexture,THREE.CanvasTexture=function(e,t,i,r,n,o,a,s,c){THREE.Texture.call(this,e,t,i,r,n,o,a,s,c),this.needsUpdate=!0},THREE.CanvasTexture.prototype=Object.create(THREE.Texture.prototype),THREE.CanvasTexture.prototype.constructor=THREE.CanvasTexture,THREE.CubeTexture=function(e,t,i,r,n,o,a,s,c,h){e=void 0!==e?e:[],t=void 0!==t?t:THREE.CubeReflectionMapping,THREE.Texture.call(this,e,t,i,r,n,o,a,s,c,h),this.flipY=!1},THREE.CubeTexture.prototype=Object.create(THREE.Texture.prototype),THREE.CubeTexture.prototype.constructor=THREE.CubeTexture,Object.defineProperty(THREE.CubeTexture.prototype,"images",{get:function(){return this.image},set:function(e){this.image=e}}),THREE.CompressedTexture=function(e,t,i,r,n,o,a,s,c,h,l,u){THREE.Texture.call(this,null,o,a,s,c,h,r,n,l,u),this.image={width:t,height:i},this.mipmaps=e,this.generateMipmaps=this.flipY=!1},THREE.CompressedTexture.prototype=Object.create(THREE.Texture.prototype),THREE.CompressedTexture.prototype.constructor=THREE.CompressedTexture,THREE.DataTexture=function(e,t,i,r,n,o,a,s,c,h,l,u){THREE.Texture.call(this,null,o,a,s,c,h,r,n,l,u),this.image={data:e,width:t,height:i},this.magFilter=void 0!==c?c:THREE.NearestFilter,this.minFilter=void 0!==h?h:THREE.NearestFilter,this.generateMipmaps=this.flipY=!1},THREE.DataTexture.prototype=Object.create(THREE.Texture.prototype),THREE.DataTexture.prototype.constructor=THREE.DataTexture,THREE.VideoTexture=function(e,t,i,r,n,o,a,s,c){function h(){requestAnimationFrame(h),e.readyState>=e.HAVE_CURRENT_DATA&&(l.needsUpdate=!0)}THREE.Texture.call(this,e,t,i,r,n,o,a,s,c),this.generateMipmaps=!1;var l=this;h()},THREE.VideoTexture.prototype=Object.create(THREE.Texture.prototype),THREE.VideoTexture.prototype.constructor=THREE.VideoTexture,THREE.Group=function(){THREE.Object3D.call(this),this.type="Group"},THREE.Group.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.Group}),THREE.Points=function(e,t){THREE.Object3D.call(this),this.type="Points",this.geometry=void 0!==e?e:new THREE.BufferGeometry,this.material=void 0!==t?t:new THREE.PointsMaterial({color:16777215*Math.random()})},THREE.Points.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.Points,raycast:function(){var e=new THREE.Matrix4,t=new THREE.Ray,i=new THREE.Sphere;return function(r,n){function o(e,i){var o=t.distanceSqToPoint(e);if(l>o){var s=t.closestPointToPoint(e);s.applyMatrix4(c);var h=r.ray.origin.distanceTo(s);h<r.near||h>r.far||n.push({distance:h,distanceToRay:Math.sqrt(o),point:s.clone(),index:i,face:null,object:a})}}var a=this,s=this.geometry,c=this.matrixWorld,h=r.params.Points.threshold;if(null===s.boundingSphere&&s.computeBoundingSphere(),i.copy(s.boundingSphere),i.applyMatrix4(c),!1!==r.ray.intersectsSphere(i)){e.getInverse(c),t.copy(r.ray).applyMatrix4(e);var h=h/((this.scale.x+this.scale.y+this.scale.z)/3),l=h*h,h=new THREE.Vector3;if(s instanceof THREE.BufferGeometry){var u=s.index,s=s.attributes.position.array;if(null!==u)for(var p=u.array,u=0,d=p.length;d>u;u++){var f=p[u];h.fromArray(s,3*f),o(h,f)}else for(u=0,p=s.length/3;p>u;u++)h.fromArray(s,3*u),o(h,u)}else for(h=s.vertices,u=0,p=h.length;p>u;u++)o(h[u],u)}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),THREE.Line=function(e,t,i){return 1===i?(console.warn("THREE.Line: parameter THREE.LinePieces no longer supported. Created THREE.LineSegments instead."),new THREE.LineSegments(e,t)):(THREE.Object3D.call(this),this.type="Line",this.geometry=void 0!==e?e:new THREE.BufferGeometry,void(this.material=void 0!==t?t:new THREE.LineBasicMaterial({color:16777215*Math.random()})))},THREE.Line.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.Line,
raycast:function(){var e=new THREE.Matrix4,t=new THREE.Ray,i=new THREE.Sphere;return function(r,n){var o=r.linePrecision,o=o*o,a=this.geometry,s=this.matrixWorld;if(null===a.boundingSphere&&a.computeBoundingSphere(),i.copy(a.boundingSphere),i.applyMatrix4(s),!1!==r.ray.intersectsSphere(i)){e.getInverse(s),t.copy(r.ray).applyMatrix4(e);var c=new THREE.Vector3,h=new THREE.Vector3,s=new THREE.Vector3,l=new THREE.Vector3,u=this instanceof THREE.LineSegments?2:1;if(a instanceof THREE.BufferGeometry){var p=a.index,d=a.attributes.position.array;if(null!==p)for(var p=p.array,a=0,f=p.length-1;f>a;a+=u){var E=p[a+1];c.fromArray(d,3*p[a]),h.fromArray(d,3*E),E=t.distanceSqToSegment(c,h,l,s),E>o||(l.applyMatrix4(this.matrixWorld),E=r.ray.origin.distanceTo(l),E<r.near||E>r.far||n.push({distance:E,point:s.clone().applyMatrix4(this.matrixWorld),index:a,face:null,faceIndex:null,object:this}))}else for(a=0,f=d.length/3-1;f>a;a+=u)c.fromArray(d,3*a),h.fromArray(d,3*a+3),E=t.distanceSqToSegment(c,h,l,s),E>o||(l.applyMatrix4(this.matrixWorld),E=r.ray.origin.distanceTo(l),E<r.near||E>r.far||n.push({distance:E,point:s.clone().applyMatrix4(this.matrixWorld),index:a,face:null,faceIndex:null,object:this}))}else if(a instanceof THREE.Geometry)for(c=a.vertices,h=c.length,a=0;h-1>a;a+=u)E=t.distanceSqToSegment(c[a],c[a+1],l,s),E>o||(l.applyMatrix4(this.matrixWorld),E=r.ray.origin.distanceTo(l),E<r.near||E>r.far||n.push({distance:E,point:s.clone().applyMatrix4(this.matrixWorld),index:a,face:null,faceIndex:null,object:this}))}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),THREE.LineSegments=function(e,t){THREE.Line.call(this,e,t),this.type="LineSegments"},THREE.LineSegments.prototype=Object.assign(Object.create(THREE.Line.prototype),{constructor:THREE.LineSegments}),THREE.Mesh=function(e,t){THREE.Object3D.call(this),this.type="Mesh",this.geometry=void 0!==e?e:new THREE.BufferGeometry,this.material=void 0!==t?t:new THREE.MeshBasicMaterial({color:16777215*Math.random()}),this.drawMode=THREE.TrianglesDrawMode,this.updateMorphTargets()},THREE.Mesh.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.Mesh,setDrawMode:function(e){this.drawMode=e},updateMorphTargets:function(){if(void 0!==this.geometry.morphTargets&&0<this.geometry.morphTargets.length){this.morphTargetBase=-1,this.morphTargetInfluences=[],this.morphTargetDictionary={};for(var e=0,t=this.geometry.morphTargets.length;t>e;e++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[e].name]=e}},getMorphTargetIndexByName:function(e){return void 0!==this.morphTargetDictionary[e]?this.morphTargetDictionary[e]:(console.warn("THREE.Mesh.getMorphTargetIndexByName: morph target "+e+" does not exist. Returning 0."),0)},raycast:function(){function e(e,t,i,r,n,o,a){return THREE.Triangle.barycoordFromPoint(e,t,i,r,E),n.multiplyScalar(E.x),o.multiplyScalar(E.y),a.multiplyScalar(E.z),n.add(o).add(a),n.clone()}function t(e,t,i,r,n,o,a){var s=e.material;return null===(s.side===THREE.BackSide?i.intersectTriangle(o,n,r,!0,a):i.intersectTriangle(r,n,o,s.side!==THREE.DoubleSide,a))?null:(g.copy(a),g.applyMatrix4(e.matrixWorld),i=t.ray.origin.distanceTo(g),i<t.near||i>t.far?null:{distance:i,point:g.clone(),object:e})}function i(i,r,n,o,h,l,u,E){return a.fromArray(o,3*l),s.fromArray(o,3*u),c.fromArray(o,3*E),(i=t(i,r,n,a,s,c,m))&&(h&&(p.fromArray(h,2*l),d.fromArray(h,2*u),f.fromArray(h,2*E),i.uv=e(m,a,s,c,p,d,f)),i.face=new THREE.Face3(l,u,E,THREE.Triangle.normal(a,s,c)),i.faceIndex=l),i}var r=new THREE.Matrix4,n=new THREE.Ray,o=new THREE.Sphere,a=new THREE.Vector3,s=new THREE.Vector3,c=new THREE.Vector3,h=new THREE.Vector3,l=new THREE.Vector3,u=new THREE.Vector3,p=new THREE.Vector2,d=new THREE.Vector2,f=new THREE.Vector2,E=new THREE.Vector3,m=new THREE.Vector3,g=new THREE.Vector3;return function(E,g){var T=this.geometry,v=this.material,y=this.matrixWorld;if(void 0!==v&&(null===T.boundingSphere&&T.computeBoundingSphere(),o.copy(T.boundingSphere),o.applyMatrix4(y),!1!==E.ray.intersectsSphere(o)&&(r.getInverse(y),n.copy(E.ray).applyMatrix4(r),null===T.boundingBox||!1!==n.intersectsBox(T.boundingBox)))){var R,x;if(T instanceof THREE.BufferGeometry){var H,b,v=T.index,y=T.attributes,T=y.position.array;if(void 0!==y.uv&&(R=y.uv.array),null!==v)for(var y=v.array,_=0,M=y.length;M>_;_+=3)v=y[_],H=y[_+1],b=y[_+2],(x=i(this,E,n,T,R,v,H,b))&&(x.faceIndex=Math.floor(_/3),g.push(x));else for(_=0,M=T.length;M>_;_+=9)v=_/3,H=v+1,b=v+2,(x=i(this,E,n,T,R,v,H,b))&&(x.index=v,g.push(x))}else if(T instanceof THREE.Geometry){var w,S,y=v instanceof THREE.MultiMaterial,_=!0===y?v.materials:null,M=T.vertices;H=T.faces,b=T.faceVertexUvs[0],0<b.length&&(R=b);for(var L=0,A=H.length;A>L;L++){var C=H[L];if(x=!0===y?_[C.materialIndex]:v,void 0!==x){if(b=M[C.a],w=M[C.b],S=M[C.c],!0===x.morphTargets){x=T.morphTargets;var P=this.morphTargetInfluences;a.set(0,0,0),s.set(0,0,0),c.set(0,0,0);for(var B=0,U=x.length;U>B;B++){var D=P[B];if(0!==D){var I=x[B].vertices;a.addScaledVector(h.subVectors(I[C.a],b),D),s.addScaledVector(l.subVectors(I[C.b],w),D),c.addScaledVector(u.subVectors(I[C.c],S),D)}}a.add(b),s.add(w),c.add(S),b=a,w=s,S=c}(x=t(this,E,n,b,w,S,m))&&(R&&(P=R[L],p.copy(P[0]),d.copy(P[1]),f.copy(P[2]),x.uv=e(m,b,w,S,p,d,f)),x.face=C,x.faceIndex=L,g.push(x))}}}}}}(),clone:function(){return new this.constructor(this.geometry,this.material).copy(this)}}),THREE.Bone=function(e){THREE.Object3D.call(this),this.type="Bone",this.skin=e},THREE.Bone.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.Bone,copy:function(e){return THREE.Object3D.prototype.copy.call(this,e),this.skin=e.skin,this}}),THREE.Skeleton=function(e,t,i){if(this.useVertexTexture=void 0!==i?i:!0,this.identityMatrix=new THREE.Matrix4,e=e||[],this.bones=e.slice(0),this.useVertexTexture?(e=Math.sqrt(4*this.bones.length),e=THREE.Math.nextPowerOfTwo(Math.ceil(e)),this.boneTextureHeight=this.boneTextureWidth=e=Math.max(e,4),this.boneMatrices=new Float32Array(this.boneTextureWidth*this.boneTextureHeight*4),this.boneTexture=new THREE.DataTexture(this.boneMatrices,this.boneTextureWidth,this.boneTextureHeight,THREE.RGBAFormat,THREE.FloatType)):this.boneMatrices=new Float32Array(16*this.bones.length),void 0===t)this.calculateInverses();else if(this.bones.length===t.length)this.boneInverses=t.slice(0);else for(console.warn("THREE.Skeleton bonInverses is the wrong length."),this.boneInverses=[],t=0,e=this.bones.length;e>t;t++)this.boneInverses.push(new THREE.Matrix4)},Object.assign(THREE.Skeleton.prototype,{calculateInverses:function(){this.boneInverses=[];for(var e=0,t=this.bones.length;t>e;e++){var i=new THREE.Matrix4;this.bones[e]&&i.getInverse(this.bones[e].matrixWorld),this.boneInverses.push(i)}},pose:function(){for(var e,t=0,i=this.bones.length;i>t;t++)(e=this.bones[t])&&e.matrixWorld.getInverse(this.boneInverses[t]);for(t=0,i=this.bones.length;i>t;t++)(e=this.bones[t])&&(e.parent?(e.matrix.getInverse(e.parent.matrixWorld),e.matrix.multiply(e.matrixWorld)):e.matrix.copy(e.matrixWorld),e.matrix.decompose(e.position,e.quaternion,e.scale))},update:function(){var e=new THREE.Matrix4;return function(){for(var t=0,i=this.bones.length;i>t;t++)e.multiplyMatrices(this.bones[t]?this.bones[t].matrixWorld:this.identityMatrix,this.boneInverses[t]),e.toArray(this.boneMatrices,16*t);this.useVertexTexture&&(this.boneTexture.needsUpdate=!0)}}(),clone:function(){return new THREE.Skeleton(this.bones,this.boneInverses,this.useVertexTexture)}}),THREE.SkinnedMesh=function(e,t,i){if(THREE.Mesh.call(this,e,t),this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new THREE.Matrix4,this.bindMatrixInverse=new THREE.Matrix4,e=[],this.geometry&&void 0!==this.geometry.bones){for(var r,n=0,o=this.geometry.bones.length;o>n;++n)r=this.geometry.bones[n],t=new THREE.Bone(this),e.push(t),t.name=r.name,t.position.fromArray(r.pos),t.quaternion.fromArray(r.rotq),void 0!==r.scl&&t.scale.fromArray(r.scl);for(n=0,o=this.geometry.bones.length;o>n;++n)r=this.geometry.bones[n],-1!==r.parent&&null!==r.parent&&void 0!==e[r.parent]?e[r.parent].add(e[n]):this.add(e[n])}this.normalizeSkinWeights(),this.updateMatrixWorld(!0),this.bind(new THREE.Skeleton(e,void 0,i),this.matrixWorld)},THREE.SkinnedMesh.prototype=Object.assign(Object.create(THREE.Mesh.prototype),{constructor:THREE.SkinnedMesh,bind:function(e,t){this.skeleton=e,void 0===t&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),t=this.matrixWorld),this.bindMatrix.copy(t),this.bindMatrixInverse.getInverse(t)},pose:function(){this.skeleton.pose()},normalizeSkinWeights:function(){if(this.geometry instanceof THREE.Geometry)for(var e=0;e<this.geometry.skinWeights.length;e++){var t=this.geometry.skinWeights[e],i=1/t.lengthManhattan();1/0!==i?t.multiplyScalar(i):t.set(1,0,0,0)}else if(this.geometry instanceof THREE.BufferGeometry)for(var t=new THREE.Vector4,r=this.geometry.attributes.skinWeight,e=0;e<r.count;e++)t.x=r.getX(e),t.y=r.getY(e),t.z=r.getZ(e),t.w=r.getW(e),i=1/t.lengthManhattan(),1/0!==i?t.multiplyScalar(i):t.set(1,0,0,0),r.setXYZW(e,t.x,t.y,t.z,t.w)},updateMatrixWorld:function(e){THREE.Mesh.prototype.updateMatrixWorld.call(this,!0),"attached"===this.bindMode?this.bindMatrixInverse.getInverse(this.matrixWorld):"detached"===this.bindMode?this.bindMatrixInverse.getInverse(this.bindMatrix):console.warn("THREE.SkinnedMesh unrecognized bindMode: "+this.bindMode)},clone:function(){return new this.constructor(this.geometry,this.material,this.useVertexTexture).copy(this)}}),THREE.LOD=function(){THREE.Object3D.call(this),this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]}})},THREE.LOD.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.LOD,copy:function(e){THREE.Object3D.prototype.copy.call(this,e,!1),e=e.levels;for(var t=0,i=e.length;i>t;t++){var r=e[t];this.addLevel(r.object.clone(),r.distance)}return this},addLevel:function(e,t){void 0===t&&(t=0),t=Math.abs(t);for(var i=this.levels,r=0;r<i.length&&!(t<i[r].distance);r++);i.splice(r,0,{distance:t,object:e}),this.add(e)},getObjectForDistance:function(e){for(var t=this.levels,i=1,r=t.length;r>i&&!(e<t[i].distance);i++);return t[i-1].object},raycast:function(){var e=new THREE.Vector3;return function(t,i){e.setFromMatrixPosition(this.matrixWorld);var r=t.ray.origin.distanceTo(e);this.getObjectForDistance(r).raycast(t,i)}}(),update:function(){var e=new THREE.Vector3,t=new THREE.Vector3;return function(i){var r=this.levels;if(1<r.length){e.setFromMatrixPosition(i.matrixWorld),t.setFromMatrixPosition(this.matrixWorld),i=e.distanceTo(t),r[0].object.visible=!0;for(var n=1,o=r.length;o>n&&i>=r[n].distance;n++)r[n-1].object.visible=!1,r[n].object.visible=!0;for(;o>n;n++)r[n].object.visible=!1}}}(),toJSON:function(e){e=THREE.Object3D.prototype.toJSON.call(this,e),e.object.levels=[];for(var t=this.levels,i=0,r=t.length;r>i;i++){var n=t[i];e.object.levels.push({object:n.object.uuid,distance:n.distance})}return e}}),THREE.Sprite=function(e){THREE.Object3D.call(this),this.type="Sprite",this.material=void 0!==e?e:new THREE.SpriteMaterial},THREE.Sprite.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.Sprite,raycast:function(){var e=new THREE.Vector3;return function(t,i){e.setFromMatrixPosition(this.matrixWorld);var r=t.ray.distanceSqToPoint(e);r>this.scale.x*this.scale.y/4||i.push({distance:Math.sqrt(r),point:this.position,face:null,object:this})}}(),clone:function(){return new this.constructor(this.material).copy(this)}}),THREE.LensFlare=function(e,t,i,r,n){THREE.Object3D.call(this),this.lensFlares=[],this.positionScreen=new THREE.Vector3,this.customUpdateCallback=void 0,void 0!==e&&this.add(e,t,i,r,n)},THREE.LensFlare.prototype=Object.assign(Object.create(THREE.Object3D.prototype),{constructor:THREE.LensFlare,copy:function(e){THREE.Object3D.prototype.copy.call(this,e),this.positionScreen.copy(e.positionScreen),this.customUpdateCallback=e.customUpdateCallback;for(var t=0,i=e.lensFlares.length;i>t;t++)this.lensFlares.push(e.lensFlares[t]);return this},add:function(e,t,i,r,n,o){void 0===t&&(t=-1),void 0===i&&(i=0),void 0===o&&(o=1),void 0===n&&(n=new THREE.Color(16777215)),void 0===r&&(r=THREE.NormalBlending),i=Math.min(i,Math.max(0,i)),this.lensFlares.push({texture:e,size:t,distance:i,x:0,y:0,z:0,scale:1,rotation:0,opacity:o,color:n,blending:r})},updateLensFlares:function(){var e,t,i=this.lensFlares.length,r=2*-this.positionScreen.x,n=2*-this.positionScreen.y;for(e=0;i>e;e++)t=this.lensFlares[e],t.x=this.positionScreen.x+r*t.distance,t.y=this.positionScreen.y+n*t.distance,t.wantedRotation=t.x*Math.PI*.25,t.rotation+=.25*(t.wantedRotation-t.rotation)}}),THREE.Scene=function(){THREE.Object3D.call(this),this.type="Scene",this.overrideMaterial=this.fog=null,this.autoUpdate=!0},THREE.Scene.prototype=Object.create(THREE.Object3D.prototype),THREE.Scene.prototype.constructor=THREE.Scene,THREE.Scene.prototype.copy=function(e,t){return THREE.Object3D.prototype.copy.call(this,e,t),null!==e.fog&&(this.fog=e.fog.clone()),null!==e.overrideMaterial&&(this.overrideMaterial=e.overrideMaterial.clone()),this.autoUpdate=e.autoUpdate,this.matrixAutoUpdate=e.matrixAutoUpdate,this},THREE.Fog=function(e,t,i){this.name="",this.color=new THREE.Color(e),this.near=void 0!==t?t:1,this.far=void 0!==i?i:1e3},THREE.Fog.prototype.clone=function(){return new THREE.Fog(this.color.getHex(),this.near,this.far)},THREE.FogExp2=function(e,t){this.name="",this.color=new THREE.Color(e),this.density=void 0!==t?t:25e-5},THREE.FogExp2.prototype.clone=function(){return new THREE.FogExp2(this.color.getHex(),this.density)},THREE.ShaderChunk={},THREE.ShaderChunk.alphamap_fragment="#ifdef USE_ALPHAMAP\n	diffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif\n",THREE.ShaderChunk.alphamap_pars_fragment="#ifdef USE_ALPHAMAP\n	uniform sampler2D alphaMap;\n#endif\n",THREE.ShaderChunk.alphatest_fragment="#ifdef ALPHATEST\n	if ( diffuseColor.a < ALPHATEST ) discard;\n#endif\n",THREE.ShaderChunk.aomap_fragment="#ifdef USE_AOMAP\n	float ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n	reflectedLight.indirectDiffuse *= ambientOcclusion;\n	#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n		float dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n		reflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n	#endif\n#endif\n",THREE.ShaderChunk.aomap_pars_fragment="#ifdef USE_AOMAP\n	uniform sampler2D aoMap;\n	uniform float aoMapIntensity;\n#endif",THREE.ShaderChunk.begin_vertex="\nvec3 transformed = vec3( position );\n",THREE.ShaderChunk.beginnormal_vertex="\nvec3 objectNormal = vec3( normal );\n",THREE.ShaderChunk.bsdfs="bool testLightInRange( const in float lightDistance, const in float cutoffDistance ) {\n	return any( bvec2( cutoffDistance == 0.0, lightDistance < cutoffDistance ) );\n}\nfloat punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n		if( decayExponent > 0.0 ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n			float distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n			float maxDistanceCutoffFactor = pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n			return distanceFalloff * maxDistanceCutoffFactor;\n#else\n			return pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n#endif\n		}\n		return 1.0;\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n	return RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n	float fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n	return ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n	float a2 = pow2( alpha );\n	float gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n	float gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n	return 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n	float a2 = pow2( alpha );\n	float gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n	float gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n	return 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n	float a2 = pow2( alpha );\n	float denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n	return RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n	float alpha = pow2( roughness );\n	vec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n	float dotNL = saturate( dot( geometry.normal, incidentLight.direction ) );\n	float dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n	float dotNH = saturate( dot( geometry.normal, halfDir ) );\n	float dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n	vec3 F = F_Schlick( specularColor, dotLH );\n	float G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n	float D = D_GGX( alpha, dotNH );\n	return F * ( G * D );\n}\nvec3 BRDF_Specular_GGX_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n	float dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n	const vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n	const vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n	vec4 r = roughness * c0 + c1;\n	float a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n	vec2 AB = vec2( -1.04, 1.04 ) * a004 + r.zw;\n	return specularColor * AB.x + AB.y;\n}\nfloat G_BlinnPhong_Implicit( ) {\n	return 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n	return RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n	vec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n	float dotNH = saturate( dot( geometry.normal, halfDir ) );\n	float dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n	vec3 F = F_Schlick( specularColor, dotLH );\n	float G = G_BlinnPhong_Implicit( );\n	float D = D_BlinnPhong( shininess, dotNH );\n	return F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n	return ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n	return sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n",THREE.ShaderChunk.bumpmap_pars_fragment="#ifdef USE_BUMPMAP\n	uniform sampler2D bumpMap;\n	uniform float bumpScale;\n	vec2 dHdxy_fwd() {\n		vec2 dSTdx = dFdx( vUv );\n		vec2 dSTdy = dFdy( vUv );\n		float Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n		float dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n		float dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n		return vec2( dBx, dBy );\n	}\n	vec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n		vec3 vSigmaX = dFdx( surf_pos );\n		vec3 vSigmaY = dFdy( surf_pos );\n		vec3 vN = surf_norm;\n		vec3 R1 = cross( vSigmaY, vN );\n		vec3 R2 = cross( vN, vSigmaX );\n		float fDet = dot( vSigmaX, R1 );\n		vec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n		return normalize( abs( fDet ) * surf_norm - vGrad );\n	}\n#endif\n",THREE.ShaderChunk.clipping_planes_fragment="#if NUM_CLIPPING_PLANES > 0\n	for ( int i = 0; i < NUM_CLIPPING_PLANES; ++ i ) {\n		vec4 plane = clippingPlanes[ i ];\n		if ( dot( vViewPosition, plane.xyz ) > plane.w ) discard;\n	}\n#endif\n",THREE.ShaderChunk.clipping_planes_pars_fragment="#if NUM_CLIPPING_PLANES > 0\n	#if ! defined( PHYSICAL ) && ! defined( PHONG )\n		varying vec3 vViewPosition;\n	#endif\n	uniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif\n",THREE.ShaderChunk.clipping_planes_pars_vertex="#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n	varying vec3 vViewPosition;\n#endif\n",THREE.ShaderChunk.clipping_planes_vertex="#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n	vViewPosition = - mvPosition.xyz;\n#endif\n",THREE.ShaderChunk.color_fragment="#ifdef USE_COLOR\n	diffuseColor.rgb *= vColor;\n#endif",THREE.ShaderChunk.color_pars_fragment="#ifdef USE_COLOR\n	varying vec3 vColor;\n#endif\n",THREE.ShaderChunk.color_pars_vertex="#ifdef USE_COLOR\n	varying vec3 vColor;\n#endif",THREE.ShaderChunk.color_vertex="#ifdef USE_COLOR\n	vColor.xyz = color.xyz;\n#endif",THREE.ShaderChunk.common="#define PI 3.14159265359\n#define PI2 6.28318530718\n#define RECIPROCAL_PI 0.31830988618\n#define RECIPROCAL_PI2 0.15915494\n#define LOG2 1.442695\n#define EPSILON 1e-6\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#define whiteCompliment(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n	const highp float a = 12.9898, b = 78.233, c = 43758.5453;\n	highp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n	return fract(sin(sn) * c);\n}\nstruct IncidentLight {\n	vec3 color;\n	vec3 direction;\n	bool visible;\n};\nstruct ReflectedLight {\n	vec3 directDiffuse;\n	vec3 directSpecular;\n	vec3 indirectDiffuse;\n	vec3 indirectSpecular;\n};\nstruct GeometricContext {\n	vec3 position;\n	vec3 normal;\n	vec3 viewDir;\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n	return normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n	return normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n	float distance = dot( planeNormal, point - pointOnPlane );\n	return - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n	return sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n	return lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\n",THREE.ShaderChunk.cube_uv_reflection_fragment="#ifdef ENVMAP_TYPE_CUBE_UV\n#define cubeUV_textureSize (1024.0)\nint getFaceFromDirection(vec3 direction) {\n	vec3 absDirection = abs(direction);\n	int face = -1;\n	if( absDirection.x > absDirection.z ) {\n		if(absDirection.x > absDirection.y )\n			face = direction.x > 0.0 ? 0 : 3;\n		else\n			face = direction.y > 0.0 ? 1 : 4;\n	}\n	else {\n		if(absDirection.z > absDirection.y )\n			face = direction.z > 0.0 ? 2 : 5;\n		else\n			face = direction.y > 0.0 ? 1 : 4;\n	}\n	return face;\n}\n#define cubeUV_maxLods1  (log2(cubeUV_textureSize*0.25) - 1.0)\n#define cubeUV_rangeClamp (exp2((6.0 - 1.0) * 2.0))\nvec2 MipLevelInfo( vec3 vec, float roughnessLevel, float roughness ) {\n	float scale = exp2(cubeUV_maxLods1 - roughnessLevel);\n	float dxRoughness = dFdx(roughness);\n	float dyRoughness = dFdy(roughness);\n	vec3 dx = dFdx( vec * scale * dxRoughness );\n	vec3 dy = dFdy( vec * scale * dyRoughness );\n	float d = max( dot( dx, dx ), dot( dy, dy ) );\n	d = clamp(d, 1.0, cubeUV_rangeClamp);\n	float mipLevel = 0.5 * log2(d);\n	return vec2(floor(mipLevel), fract(mipLevel));\n}\n#define cubeUV_maxLods2 (log2(cubeUV_textureSize*0.25) - 2.0)\n#define cubeUV_rcpTextureSize (1.0 / cubeUV_textureSize)\nvec2 getCubeUV(vec3 direction, float roughnessLevel, float mipLevel) {\n	mipLevel = roughnessLevel > cubeUV_maxLods2 - 3.0 ? 0.0 : mipLevel;\n	float a = 16.0 * cubeUV_rcpTextureSize;\n	vec2 exp2_packed = exp2( vec2( roughnessLevel, mipLevel ) );\n	vec2 rcp_exp2_packed = vec2( 1.0 ) / exp2_packed;\n	float powScale = exp2_packed.x * exp2_packed.y;\n	float scale = rcp_exp2_packed.x * rcp_exp2_packed.y * 0.25;\n	float mipOffset = 0.75*(1.0 - rcp_exp2_packed.y) * rcp_exp2_packed.x;\n	bool bRes = mipLevel == 0.0;\n	scale =  bRes && (scale < a) ? a : scale;\n	vec3 r;\n	vec2 offset;\n	int face = getFaceFromDirection(direction);\n	float rcpPowScale = 1.0 / powScale;\n	if( face == 0) {\n		r = vec3(direction.x, -direction.z, direction.y);\n		offset = vec2(0.0+mipOffset,0.75 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n	}\n	else if( face == 1) {\n		r = vec3(direction.y, direction.x, direction.z);\n		offset = vec2(scale+mipOffset, 0.75 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n	}\n	else if( face == 2) {\n		r = vec3(direction.z, direction.x, direction.y);\n		offset = vec2(2.0*scale+mipOffset, 0.75 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n	}\n	else if( face == 3) {\n		r = vec3(direction.x, direction.z, direction.y);\n		offset = vec2(0.0+mipOffset,0.5 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n	}\n	else if( face == 4) {\n		r = vec3(direction.y, direction.x, -direction.z);\n		offset = vec2(scale+mipOffset, 0.5 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n	}\n	else {\n		r = vec3(direction.z, -direction.x, direction.y);\n		offset = vec2(2.0*scale+mipOffset, 0.5 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n	}\n	r = normalize(r);\n	float texelOffset = 0.5 * cubeUV_rcpTextureSize;\n	vec2 s = ( r.yz / abs( r.x ) + vec2( 1.0 ) ) * 0.5;\n	vec2 base = offset + vec2( texelOffset );\n	return base + s * ( scale - 2.0 * texelOffset );\n}\n#define cubeUV_maxLods3 (log2(cubeUV_textureSize*0.25) - 3.0)\nvec4 textureCubeUV(vec3 reflectedDirection, float roughness ) {\n	float roughnessVal = roughness* cubeUV_maxLods3;\n	float r1 = floor(roughnessVal);\n	float r2 = r1 + 1.0;\n	float t = fract(roughnessVal);\n	vec2 mipInfo = MipLevelInfo(reflectedDirection, r1, roughness);\n	float s = mipInfo.y;\n	float level0 = mipInfo.x;\n	float level1 = level0 + 1.0;\n	level1 = level1 > 5.0 ? 5.0 : level1;\n	level0 += min( floor( s + 0.5 ), 5.0 );\n	vec2 uv_10 = getCubeUV(reflectedDirection, r1, level0);\n	vec4 color10 = envMapTexelToLinear(texture2D(envMap, uv_10));\n	vec2 uv_20 = getCubeUV(reflectedDirection, r2, level0);\n	vec4 color20 = envMapTexelToLinear(texture2D(envMap, uv_20));\n	vec4 result = mix(color10, color20, t);\n	return vec4(result.rgb, 1.0);\n}\n#endif\n",THREE.ShaderChunk.defaultnormal_vertex="#ifdef FLIP_SIDED\n	objectNormal = -objectNormal;\n#endif\nvec3 transformedNormal = normalMatrix * objectNormal;\n",THREE.ShaderChunk.displacementmap_vertex="#ifdef USE_DISPLACEMENTMAP\n	transformed += normal * ( texture2D( displacementMap, uv ).x * displacementScale + displacementBias );\n#endif\n",THREE.ShaderChunk.displacementmap_pars_vertex="#ifdef USE_DISPLACEMENTMAP\n	uniform sampler2D displacementMap;\n	uniform float displacementScale;\n	uniform float displacementBias;\n#endif\n",THREE.ShaderChunk.emissivemap_fragment="#ifdef USE_EMISSIVEMAP\n	vec4 emissiveColor = texture2D( emissiveMap, vUv );\n	emissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n	totalEmissiveRadiance *= emissiveColor.rgb;\n#endif\n",THREE.ShaderChunk.emissivemap_pars_fragment="#ifdef USE_EMISSIVEMAP\n	uniform sampler2D emissiveMap;\n#endif\n",THREE.ShaderChunk.encodings_pars_fragment="\nvec4 LinearToLinear( in vec4 value ) {\n  return value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n  return vec4( pow( value.xyz, vec3( gammaFactor ) ), value.w );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n  return vec4( pow( value.xyz, vec3( 1.0 / gammaFactor ) ), value.w );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n  return vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.w );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n  return vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.w );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n  return vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n  float maxComponent = max( max( value.r, value.g ), value.b );\n  float fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n  return vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n  return vec4( value.xyz * value.w * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n  float maxRGB = max( value.x, max( value.g, value.b ) );\n  float M      = clamp( maxRGB / maxRange, 0.0, 1.0 );\n  M            = ceil( M * 255.0 ) / 255.0;\n  return vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n    return vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n    float maxRGB = max( value.x, max( value.g, value.b ) );\n    float D      = max( maxRange / maxRGB, 1.0 );\n    D            = min( floor( D ) / 255.0, 1.0 );\n    return vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value )  {\n  vec3 Xp_Y_XYZp = value.rgb * cLogLuvM;\n  Xp_Y_XYZp = max(Xp_Y_XYZp, vec3(1e-6, 1e-6, 1e-6));\n  vec4 vResult;\n  vResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n  float Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n  vResult.w = fract(Le);\n  vResult.z = (Le - (floor(vResult.w*255.0))/255.0)/255.0;\n  return vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n  float Le = value.z * 255.0 + value.w;\n  vec3 Xp_Y_XYZp;\n  Xp_Y_XYZp.y = exp2((Le - 127.0) / 2.0);\n  Xp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n  Xp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n  vec3 vRGB = Xp_Y_XYZp.rgb * cLogLuvInverseM;\n  return vec4( max(vRGB, 0.0), 1.0 );\n}\n",THREE.ShaderChunk.encodings_fragment="  gl_FragColor = linearToOutputTexel( gl_FragColor );\n",THREE.ShaderChunk.envmap_fragment="#ifdef USE_ENVMAP\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n		vec3 cameraToVertex = normalize( vWorldPosition - cameraPosition );\n		vec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n		#ifdef ENVMAP_MODE_REFLECTION\n			vec3 reflectVec = reflect( cameraToVertex, worldNormal );\n		#else\n			vec3 reflectVec = refract( cameraToVertex, worldNormal, refractionRatio );\n		#endif\n	#else\n		vec3 reflectVec = vReflect;\n	#endif\n	#ifdef DOUBLE_SIDED\n		float flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n	#else\n		float flipNormal = 1.0;\n	#endif\n	#ifdef ENVMAP_TYPE_CUBE\n		vec4 envColor = textureCube( envMap, flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n	#elif defined( ENVMAP_TYPE_EQUIREC )\n		vec2 sampleUV;\n		sampleUV.y = saturate( flipNormal * reflectVec.y * 0.5 + 0.5 );\n		sampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n		vec4 envColor = texture2D( envMap, sampleUV );\n	#elif defined( ENVMAP_TYPE_SPHERE )\n		vec3 reflectView = flipNormal * normalize((viewMatrix * vec4( reflectVec, 0.0 )).xyz + vec3(0.0,0.0,1.0));\n		vec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n	#endif\n	envColor = envMapTexelToLinear( envColor );\n	#ifdef ENVMAP_BLENDING_MULTIPLY\n		outgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n	#elif defined( ENVMAP_BLENDING_MIX )\n		outgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n	#elif defined( ENVMAP_BLENDING_ADD )\n		outgoingLight += envColor.xyz * specularStrength * reflectivity;\n	#endif\n#endif\n",
THREE.ShaderChunk.envmap_pars_fragment="#if defined( USE_ENVMAP ) || defined( PHYSICAL )\n	uniform float reflectivity;\n	uniform float envMapIntenstiy;\n#endif\n#ifdef USE_ENVMAP\n	#if ! defined( PHYSICAL ) && ( defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) )\n		varying vec3 vWorldPosition;\n	#endif\n	#ifdef ENVMAP_TYPE_CUBE\n		uniform samplerCube envMap;\n	#else\n		uniform sampler2D envMap;\n	#endif\n	uniform float flipEnvMap;\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( PHYSICAL )\n		uniform float refractionRatio;\n	#else\n		varying vec3 vReflect;\n	#endif\n#endif\n",THREE.ShaderChunk.envmap_pars_vertex="#ifdef USE_ENVMAP\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n		varying vec3 vWorldPosition;\n	#else\n		varying vec3 vReflect;\n		uniform float refractionRatio;\n	#endif\n#endif\n",THREE.ShaderChunk.envmap_vertex="#ifdef USE_ENVMAP\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n		vWorldPosition = worldPosition.xyz;\n	#else\n		vec3 cameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n		vec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n		#ifdef ENVMAP_MODE_REFLECTION\n			vReflect = reflect( cameraToVertex, worldNormal );\n		#else\n			vReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n		#endif\n	#endif\n#endif\n",THREE.ShaderChunk.fog_fragment="#ifdef USE_FOG\n	#ifdef USE_LOGDEPTHBUF_EXT\n		float depth = gl_FragDepthEXT / gl_FragCoord.w;\n	#else\n		float depth = gl_FragCoord.z / gl_FragCoord.w;\n	#endif\n	#ifdef FOG_EXP2\n		float fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );\n	#else\n		float fogFactor = smoothstep( fogNear, fogFar, depth );\n	#endif\n	gl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif\n",THREE.ShaderChunk.fog_pars_fragment="#ifdef USE_FOG\n	uniform vec3 fogColor;\n	#ifdef FOG_EXP2\n		uniform float fogDensity;\n	#else\n		uniform float fogNear;\n		uniform float fogFar;\n	#endif\n#endif",THREE.ShaderChunk.lightmap_fragment="#ifdef USE_LIGHTMAP\n	reflectedLight.indirectDiffuse += PI * texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n#endif\n",THREE.ShaderChunk.lightmap_pars_fragment="#ifdef USE_LIGHTMAP\n	uniform sampler2D lightMap;\n	uniform float lightMapIntensity;\n#endif",THREE.ShaderChunk.lights_lambert_vertex="vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n	vLightBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\n#if NUM_POINT_LIGHTS > 0\n	for ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n		getPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n		dotNL = dot( geometry.normal, directLight.direction );\n		directLightColor_Diffuse = PI * directLight.color;\n		vLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n		#ifdef DOUBLE_SIDED\n			vLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n		#endif\n	}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n	for ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n		getSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n		dotNL = dot( geometry.normal, directLight.direction );\n		directLightColor_Diffuse = PI * directLight.color;\n		vLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n		#ifdef DOUBLE_SIDED\n			vLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n		#endif\n	}\n#endif\n#if NUM_DIR_LIGHTS > 0\n	for ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n		getDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n		dotNL = dot( geometry.normal, directLight.direction );\n		directLightColor_Diffuse = PI * directLight.color;\n		vLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n		#ifdef DOUBLE_SIDED\n			vLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n		#endif\n	}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n	for ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n		vLightFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n		#ifdef DOUBLE_SIDED\n			vLightBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n		#endif\n	}\n#endif\n",THREE.ShaderChunk.lights_pars="uniform vec3 ambientLightColor;\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n	vec3 irradiance = ambientLightColor;\n	#ifndef PHYSICALLY_CORRECT_LIGHTS\n		irradiance *= PI;\n	#endif\n	return irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n	struct DirectionalLight {\n		vec3 direction;\n		vec3 color;\n		int shadow;\n		float shadowBias;\n		float shadowRadius;\n		vec2 shadowMapSize;\n	};\n	uniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n	void getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n		directLight.color = directionalLight.color;\n		directLight.direction = directionalLight.direction;\n		directLight.visible = true;\n	}\n#endif\n#if NUM_POINT_LIGHTS > 0\n	struct PointLight {\n		vec3 position;\n		vec3 color;\n		float distance;\n		float decay;\n		int shadow;\n		float shadowBias;\n		float shadowRadius;\n		vec2 shadowMapSize;\n	};\n	uniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n	void getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n		vec3 lVector = pointLight.position - geometry.position;\n		directLight.direction = normalize( lVector );\n		float lightDistance = length( lVector );\n		if ( testLightInRange( lightDistance, pointLight.distance ) ) {\n			directLight.color = pointLight.color;\n			directLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n			directLight.visible = true;\n		} else {\n			directLight.color = vec3( 0.0 );\n			directLight.visible = false;\n		}\n	}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n	struct SpotLight {\n		vec3 position;\n		vec3 direction;\n		vec3 color;\n		float distance;\n		float decay;\n		float coneCos;\n		float penumbraCos;\n		int shadow;\n		float shadowBias;\n		float shadowRadius;\n		vec2 shadowMapSize;\n	};\n	uniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n	void getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {\n		vec3 lVector = spotLight.position - geometry.position;\n		directLight.direction = normalize( lVector );\n		float lightDistance = length( lVector );\n		float angleCos = dot( directLight.direction, spotLight.direction );\n		if ( all( bvec2( angleCos > spotLight.coneCos, testLightInRange( lightDistance, spotLight.distance ) ) ) ) {\n			float spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n			directLight.color = spotLight.color;\n			directLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n			directLight.visible = true;\n		} else {\n			directLight.color = vec3( 0.0 );\n			directLight.visible = false;\n		}\n	}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n	struct HemisphereLight {\n		vec3 direction;\n		vec3 skyColor;\n		vec3 groundColor;\n	};\n	uniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n	vec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n		float dotNL = dot( geometry.normal, hemiLight.direction );\n		float hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n		vec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n		#ifndef PHYSICALLY_CORRECT_LIGHTS\n			irradiance *= PI;\n		#endif\n		return irradiance;\n	}\n#endif\n#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n	vec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n		#ifdef DOUBLE_SIDED\n			float flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n		#else\n			float flipNormal = 1.0;\n		#endif\n		vec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n		#ifdef ENVMAP_TYPE_CUBE\n			vec3 queryVec = flipNormal * vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n			#ifdef TEXTURE_LOD_EXT\n				vec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n			#else\n				vec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n			#endif\n			envMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n		#elif defined( ENVMAP_TYPE_CUBE_UV )\n			vec3 queryVec = flipNormal * vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n			vec4 envMapColor = textureCubeUV( queryVec, 1.0 );\n		#else\n			vec4 envMapColor = vec4( 0.0 );\n		#endif\n		return PI * envMapColor.rgb * envMapIntensity;\n	}\n	float getSpecularMIPLevel( const in float blinnShininessExponent, const in int maxMIPLevel ) {\n		float maxMIPLevelScalar = float( maxMIPLevel );\n		float desiredMIPLevel = maxMIPLevelScalar - 0.79248 - 0.5 * log2( pow2( blinnShininessExponent ) + 1.0 );\n		return clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n	}\n	vec3 getLightProbeIndirectRadiance( const in GeometricContext geometry, const in float blinnShininessExponent, const in int maxMIPLevel ) {\n		#ifdef ENVMAP_MODE_REFLECTION\n			vec3 reflectVec = reflect( -geometry.viewDir, geometry.normal );\n		#else\n			vec3 reflectVec = refract( -geometry.viewDir, geometry.normal, refractionRatio );\n		#endif\n		#ifdef DOUBLE_SIDED\n			float flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n		#else\n			float flipNormal = 1.0;\n		#endif\n		reflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n		float specularMIPLevel = getSpecularMIPLevel( blinnShininessExponent, maxMIPLevel );\n		#ifdef ENVMAP_TYPE_CUBE\n			vec3 queryReflectVec = flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n			#ifdef TEXTURE_LOD_EXT\n				vec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n			#else\n				vec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n			#endif\n			envMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n		#elif defined( ENVMAP_TYPE_CUBE_UV )\n			vec3 queryReflectVec = flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n			vec4 envMapColor = textureCubeUV(queryReflectVec, BlinnExponentToGGXRoughness(blinnShininessExponent));\n		#elif defined( ENVMAP_TYPE_EQUIREC )\n			vec2 sampleUV;\n			sampleUV.y = saturate( flipNormal * reflectVec.y * 0.5 + 0.5 );\n			sampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n			#ifdef TEXTURE_LOD_EXT\n				vec4 envMapColor = texture2DLodEXT( envMap, sampleUV, specularMIPLevel );\n			#else\n				vec4 envMapColor = texture2D( envMap, sampleUV, specularMIPLevel );\n			#endif\n			envMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n		#elif defined( ENVMAP_TYPE_SPHERE )\n			vec3 reflectView = flipNormal * normalize((viewMatrix * vec4( reflectVec, 0.0 )).xyz + vec3(0.0,0.0,1.0));\n			#ifdef TEXTURE_LOD_EXT\n				vec4 envMapColor = texture2DLodEXT( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n			#else\n				vec4 envMapColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n			#endif\n			envMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n		#endif\n		return envMapColor.rgb * envMapIntensity;\n	}\n#endif\n",THREE.ShaderChunk.lights_phong_fragment="BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;\n",THREE.ShaderChunk.lights_phong_pars_fragment="varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n	vec3	diffuseColor;\n	vec3	specularColor;\n	float	specularShininess;\n	float	specularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n	float dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n	vec3 irradiance = dotNL * directLight.color;\n	#ifndef PHYSICALLY_CORRECT_LIGHTS\n		irradiance *= PI;\n	#endif\n	reflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n	reflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n	reflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct				RE_Direct_BlinnPhong\n#define RE_IndirectDiffuse		RE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )	(0)\n",THREE.ShaderChunk.lights_physical_fragment="PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nmaterial.specularRoughness = clamp( roughnessFactor, 0.04, 1.0 );\n#ifdef STANDARD\n	material.specularColor = mix( vec3( 0.04 ), diffuseColor.rgb, metalnessFactor );\n#else\n	material.specularColor = mix( vec3( 0.16 * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n#endif\n",THREE.ShaderChunk.lights_physical_pars_fragment="struct PhysicalMaterial {\n	vec3	diffuseColor;\n	float	specularRoughness;\n	vec3	specularColor;\n	#ifndef STANDARD\n	#endif\n};\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n	float dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n	vec3 irradiance = dotNL * directLight.color;\n	#ifndef PHYSICALLY_CORRECT_LIGHTS\n		irradiance *= PI;\n	#endif\n	reflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n	reflectedLight.directSpecular += irradiance * BRDF_Specular_GGX( directLight, geometry, material.specularColor, material.specularRoughness );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n	reflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n	reflectedLight.indirectSpecular += radiance * BRDF_Specular_GGX_Environment( geometry, material.specularColor, material.specularRoughness );\n}\n#define RE_Direct				RE_Direct_Physical\n#define RE_IndirectDiffuse		RE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular		RE_IndirectSpecular_Physical\n#define Material_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.specularRoughness )\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n	return saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}\n",THREE.ShaderChunk.lights_template="\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = normalize( vViewPosition );\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n	PointLight pointLight;\n	for ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n		pointLight = pointLights[ i ];\n		getPointDirectLightIrradiance( pointLight, geometry, directLight );\n		#ifdef USE_SHADOWMAP\n		directLight.color *= all( bvec2( pointLight.shadow, directLight.visible ) ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n		#endif\n		RE_Direct( directLight, geometry, material, reflectedLight );\n	}\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n	SpotLight spotLight;\n	for ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n		spotLight = spotLights[ i ];\n		getSpotDirectLightIrradiance( spotLight, geometry, directLight );\n		#ifdef USE_SHADOWMAP\n		directLight.color *= all( bvec2( spotLight.shadow, directLight.visible ) ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n		#endif\n		RE_Direct( directLight, geometry, material, reflectedLight );\n	}\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n	DirectionalLight directionalLight;\n	for ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n		directionalLight = directionalLights[ i ];\n		getDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n		#ifdef USE_SHADOWMAP\n		directLight.color *= all( bvec2( directionalLight.shadow, directLight.visible ) ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n		#endif\n		RE_Direct( directLight, geometry, material, reflectedLight );\n	}\n#endif\n#if defined( RE_IndirectDiffuse )\n	vec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n	#ifdef USE_LIGHTMAP\n		vec3 lightMapIrradiance = texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n		#ifndef PHYSICALLY_CORRECT_LIGHTS\n			lightMapIrradiance *= PI;\n		#endif\n		irradiance += lightMapIrradiance;\n	#endif\n	#if ( NUM_HEMI_LIGHTS > 0 )\n		for ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n			irradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n		}\n	#endif\n	#if defined( USE_ENVMAP ) && defined( PHYSICAL ) && defined( ENVMAP_TYPE_CUBE_UV )\n	 	irradiance += getLightProbeIndirectIrradiance( geometry, 8 );\n	#endif\n	RE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n	vec3 radiance = getLightProbeIndirectRadiance( geometry, Material_BlinnShininessExponent( material ), 8 );\n	RE_IndirectSpecular( radiance, geometry, material, reflectedLight );\n#endif\n",THREE.ShaderChunk.logdepthbuf_fragment="#if defined(USE_LOGDEPTHBUF) && defined(USE_LOGDEPTHBUF_EXT)\n	gl_FragDepthEXT = log2(vFragDepth) * logDepthBufFC * 0.5;\n#endif",THREE.ShaderChunk.logdepthbuf_pars_fragment="#ifdef USE_LOGDEPTHBUF\n	uniform float logDepthBufFC;\n	#ifdef USE_LOGDEPTHBUF_EXT\n		varying float vFragDepth;\n	#endif\n#endif\n",THREE.ShaderChunk.logdepthbuf_pars_vertex="#ifdef USE_LOGDEPTHBUF\n	#ifdef USE_LOGDEPTHBUF_EXT\n		varying float vFragDepth;\n	#endif\n	uniform float logDepthBufFC;\n#endif",THREE.ShaderChunk.logdepthbuf_vertex="#ifdef USE_LOGDEPTHBUF\n	gl_Position.z = log2(max( EPSILON, gl_Position.w + 1.0 )) * logDepthBufFC;\n	#ifdef USE_LOGDEPTHBUF_EXT\n		vFragDepth = 1.0 + gl_Position.w;\n	#else\n		gl_Position.z = (gl_Position.z - 1.0) * gl_Position.w;\n	#endif\n#endif\n",THREE.ShaderChunk.map_fragment="#ifdef USE_MAP\n	vec4 texelColor = texture2D( map, vUv );\n	texelColor = mapTexelToLinear( texelColor );\n	diffuseColor *= texelColor;\n#endif\n",THREE.ShaderChunk.map_pars_fragment="#ifdef USE_MAP\n	uniform sampler2D map;\n#endif\n",THREE.ShaderChunk.map_particle_fragment="#ifdef USE_MAP\n	vec4 mapTexel = texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) * offsetRepeat.zw + offsetRepeat.xy );\n	diffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n",THREE.ShaderChunk.map_particle_pars_fragment="#ifdef USE_MAP\n	uniform vec4 offsetRepeat;\n	uniform sampler2D map;\n#endif\n",THREE.ShaderChunk.metalnessmap_fragment="float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n	vec4 texelMetalness = texture2D( metalnessMap, vUv );\n	metalnessFactor *= texelMetalness.r;\n#endif\n",THREE.ShaderChunk.metalnessmap_pars_fragment="#ifdef USE_METALNESSMAP\n	uniform sampler2D metalnessMap;\n#endif",THREE.ShaderChunk.morphnormal_vertex="#ifdef USE_MORPHNORMALS\n	objectNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n	objectNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n	objectNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n	objectNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n#endif\n",THREE.ShaderChunk.morphtarget_pars_vertex="#ifdef USE_MORPHTARGETS\n	#ifndef USE_MORPHNORMALS\n	uniform float morphTargetInfluences[ 8 ];\n	#else\n	uniform float morphTargetInfluences[ 4 ];\n	#endif\n#endif",THREE.ShaderChunk.morphtarget_vertex="#ifdef USE_MORPHTARGETS\n	transformed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n	transformed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n	transformed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n	transformed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n	#ifndef USE_MORPHNORMALS\n	transformed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n	transformed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n	transformed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n	transformed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n	#endif\n#endif\n",THREE.ShaderChunk.normal_fragment="#ifdef FLAT_SHADED\n	vec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n	vec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n	vec3 normal = normalize( cross( fdx, fdy ) );\n#else\n	vec3 normal = normalize( vNormal );\n	#ifdef DOUBLE_SIDED\n		normal = normal * ( -1.0 + 2.0 * float( gl_FrontFacing ) );\n	#endif\n#endif\n#ifdef USE_NORMALMAP\n	normal = perturbNormal2Arb( -vViewPosition, normal );\n#elif defined( USE_BUMPMAP )\n	normal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif\n",THREE.ShaderChunk.normalmap_pars_fragment="#ifdef USE_NORMALMAP\n	uniform sampler2D normalMap;\n	uniform vec2 normalScale;\n	vec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm ) {\n		vec3 q0 = dFdx( eye_pos.xyz );\n		vec3 q1 = dFdy( eye_pos.xyz );\n		vec2 st0 = dFdx( vUv.st );\n		vec2 st1 = dFdy( vUv.st );\n		vec3 S = normalize( q0 * st1.t - q1 * st0.t );\n		vec3 T = normalize( -q0 * st1.s + q1 * st0.s );\n		vec3 N = normalize( surf_norm );\n		vec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n		mapN.xy = normalScale * mapN.xy;\n		mat3 tsn = mat3( S, T, N );\n		return normalize( tsn * mapN );\n	}\n#endif\n",THREE.ShaderChunk.packing="vec3 packNormalToRGB( const in vec3 normal ) {\n  return normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n  return 1.0 - 2.0 * rgb.xyz;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256.,  256. );\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\nconst float ShiftRight8 = 1. / 256.;\nvec4 packDepthToRGBA( const in float v ) {\n	vec4 r = vec4( fract( v * PackFactors ), v );\n	r.yzw -= r.xyz * ShiftRight8;	return r * PackUpscale;\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n	return dot( v, UnpackFactors );\n}\nfloat viewZToOrthoDepth( const in float viewZ, const in float near, const in float far ) {\n  return ( viewZ + near ) / ( near - far );\n}\nfloat OrthoDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n  return linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n  return (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n  return ( near * far ) / ( ( far - near ) * invClipZ - far );\n}\n",THREE.ShaderChunk.premultiplied_alpha_fragment="#ifdef PREMULTIPLIED_ALPHA\n	gl_FragColor.rgb *= gl_FragColor.a;\n#endif\n",THREE.ShaderChunk.project_vertex="#ifdef USE_SKINNING\n	vec4 mvPosition = modelViewMatrix * skinned;\n#else\n	vec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );\n#endif\ngl_Position = projectionMatrix * mvPosition;\n",THREE.ShaderChunk.roughnessmap_fragment="float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n	vec4 texelRoughness = texture2D( roughnessMap, vUv );\n	roughnessFactor *= texelRoughness.r;\n#endif\n",THREE.ShaderChunk.roughnessmap_pars_fragment="#ifdef USE_ROUGHNESSMAP\n	uniform sampler2D roughnessMap;\n#endif",THREE.ShaderChunk.shadowmap_pars_fragment="#ifdef USE_SHADOWMAP\n	#if NUM_DIR_LIGHTS > 0\n		uniform sampler2D directionalShadowMap[ NUM_DIR_LIGHTS ];\n		varying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n	#endif\n	#if NUM_SPOT_LIGHTS > 0\n		uniform sampler2D spotShadowMap[ NUM_SPOT_LIGHTS ];\n		varying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n	#endif\n	#if NUM_POINT_LIGHTS > 0\n		uniform sampler2D pointShadowMap[ NUM_POINT_LIGHTS ];\n		varying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n	#endif\n	float texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n		return step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n	}\n	float texture2DShadowLerp( sampler2D depths, vec2 size, vec2 uv, float compare ) {\n		const vec2 offset = vec2( 0.0, 1.0 );\n		vec2 texelSize = vec2( 1.0 ) / size;\n		vec2 centroidUV = floor( uv * size + 0.5 ) / size;\n		float lb = texture2DCompare( depths, centroidUV + texelSize * offset.xx, compare );\n		float lt = texture2DCompare( depths, centroidUV + texelSize * offset.xy, compare );\n		float rb = texture2DCompare( depths, centroidUV + texelSize * offset.yx, compare );\n		float rt = texture2DCompare( depths, centroidUV + texelSize * offset.yy, compare );\n		vec2 f = fract( uv * size + 0.5 );\n		float a = mix( lb, lt, f.y );\n		float b = mix( rb, rt, f.y );\n		float c = mix( a, b, f.x );\n		return c;\n	}\n	float getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n		shadowCoord.xyz /= shadowCoord.w;\n		shadowCoord.z += shadowBias;\n		bvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n		bool inFrustum = all( inFrustumVec );\n		bvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n		bool frustumTest = all( frustumTestVec );\n		if ( frustumTest ) {\n		#if defined( SHADOWMAP_TYPE_PCF )\n			vec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n			float dx0 = - texelSize.x * shadowRadius;\n			float dy0 = - texelSize.y * shadowRadius;\n			float dx1 = + texelSize.x * shadowRadius;\n			float dy1 = + texelSize.y * shadowRadius;\n			return (\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n			) * ( 1.0 / 9.0 );\n		#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n			vec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n			float dx0 = - texelSize.x * shadowRadius;\n			float dy0 = - texelSize.y * shadowRadius;\n			float dx1 = + texelSize.x * shadowRadius;\n			float dy1 = + texelSize.y * shadowRadius;\n			return (\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy, shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n			) * ( 1.0 / 9.0 );\n		#else\n			return texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n		#endif\n		}\n		return 1.0;\n	}\n	vec2 cubeToUV( vec3 v, float texelSizeY ) {\n		vec3 absV = abs( v );\n		float scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n		absV *= scaleToCube;\n		v *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n		vec2 planar = v.xy;\n		float almostATexel = 1.5 * texelSizeY;\n		float almostOne = 1.0 - almostATexel;\n		if ( absV.z >= almostOne ) {\n			if ( v.z > 0.0 )\n				planar.x = 4.0 - v.x;\n		} else if ( absV.x >= almostOne ) {\n			float signX = sign( v.x );\n			planar.x = v.z * signX + 2.0 * signX;\n		} else if ( absV.y >= almostOne ) {\n			float signY = sign( v.y );\n			planar.x = v.x + 2.0 * signY + 2.0;\n			planar.y = v.z * signY - 2.0;\n		}\n		return vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n	}\n	float getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n		vec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n		vec3 lightToPosition = shadowCoord.xyz;\n		vec3 bd3D = normalize( lightToPosition );\n		float dp = ( length( lightToPosition ) - shadowBias ) / 1000.0;\n		#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT )\n			vec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n			return (\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n			) * ( 1.0 / 9.0 );\n		#else\n			return texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n		#endif\n	}\n#endif\n",THREE.ShaderChunk.shadowmap_pars_vertex="#ifdef USE_SHADOWMAP\n	#if NUM_DIR_LIGHTS > 0\n		uniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHTS ];\n		varying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n	#endif\n	#if NUM_SPOT_LIGHTS > 0\n		uniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHTS ];\n		varying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n	#endif\n	#if NUM_POINT_LIGHTS > 0\n		uniform mat4 pointShadowMatrix[ NUM_POINT_LIGHTS ];\n		varying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n	#endif\n#endif\n",THREE.ShaderChunk.shadowmap_vertex="#ifdef USE_SHADOWMAP\n	#if NUM_DIR_LIGHTS > 0\n	for ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n		vDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * worldPosition;\n	}\n	#endif\n	#if NUM_SPOT_LIGHTS > 0\n	for ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n		vSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * worldPosition;\n	}\n	#endif\n	#if NUM_POINT_LIGHTS > 0\n	for ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n		vPointShadowCoord[ i ] = pointShadowMatrix[ i ] * worldPosition;\n	}\n	#endif\n#endif\n",
THREE.ShaderChunk.shadowmask_pars_fragment="float getShadowMask() {\n	float shadow = 1.0;\n	#ifdef USE_SHADOWMAP\n	#if NUM_DIR_LIGHTS > 0\n	DirectionalLight directionalLight;\n	for ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n		directionalLight = directionalLights[ i ];\n		shadow *= bool( directionalLight.shadow ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n	}\n	#endif\n	#if NUM_SPOT_LIGHTS > 0\n	SpotLight spotLight;\n	for ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n		spotLight = spotLights[ i ];\n		shadow *= bool( spotLight.shadow ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n	}\n	#endif\n	#if NUM_POINT_LIGHTS > 0\n	PointLight pointLight;\n	for ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n		pointLight = pointLights[ i ];\n		shadow *= bool( pointLight.shadow ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n	}\n	#endif\n	#endif\n	return shadow;\n}\n",THREE.ShaderChunk.skinbase_vertex="#ifdef USE_SKINNING\n	mat4 boneMatX = getBoneMatrix( skinIndex.x );\n	mat4 boneMatY = getBoneMatrix( skinIndex.y );\n	mat4 boneMatZ = getBoneMatrix( skinIndex.z );\n	mat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",THREE.ShaderChunk.skinning_pars_vertex="#ifdef USE_SKINNING\n	uniform mat4 bindMatrix;\n	uniform mat4 bindMatrixInverse;\n	#ifdef BONE_TEXTURE\n		uniform sampler2D boneTexture;\n		uniform int boneTextureWidth;\n		uniform int boneTextureHeight;\n		mat4 getBoneMatrix( const in float i ) {\n			float j = i * 4.0;\n			float x = mod( j, float( boneTextureWidth ) );\n			float y = floor( j / float( boneTextureWidth ) );\n			float dx = 1.0 / float( boneTextureWidth );\n			float dy = 1.0 / float( boneTextureHeight );\n			y = dy * ( y + 0.5 );\n			vec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n			vec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n			vec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n			vec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n			mat4 bone = mat4( v1, v2, v3, v4 );\n			return bone;\n		}\n	#else\n		uniform mat4 boneMatrices[ MAX_BONES ];\n		mat4 getBoneMatrix( const in float i ) {\n			mat4 bone = boneMatrices[ int(i) ];\n			return bone;\n		}\n	#endif\n#endif\n",THREE.ShaderChunk.skinning_vertex="#ifdef USE_SKINNING\n	vec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n	vec4 skinned = vec4( 0.0 );\n	skinned += boneMatX * skinVertex * skinWeight.x;\n	skinned += boneMatY * skinVertex * skinWeight.y;\n	skinned += boneMatZ * skinVertex * skinWeight.z;\n	skinned += boneMatW * skinVertex * skinWeight.w;\n	skinned  = bindMatrixInverse * skinned;\n#endif\n",THREE.ShaderChunk.skinnormal_vertex="#ifdef USE_SKINNING\n	mat4 skinMatrix = mat4( 0.0 );\n	skinMatrix += skinWeight.x * boneMatX;\n	skinMatrix += skinWeight.y * boneMatY;\n	skinMatrix += skinWeight.z * boneMatZ;\n	skinMatrix += skinWeight.w * boneMatW;\n	skinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n	objectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n#endif\n",THREE.ShaderChunk.specularmap_fragment="float specularStrength;\n#ifdef USE_SPECULARMAP\n	vec4 texelSpecular = texture2D( specularMap, vUv );\n	specularStrength = texelSpecular.r;\n#else\n	specularStrength = 1.0;\n#endif",THREE.ShaderChunk.specularmap_pars_fragment="#ifdef USE_SPECULARMAP\n	uniform sampler2D specularMap;\n#endif",THREE.ShaderChunk.tonemapping_fragment="#if defined( TONE_MAPPING )\n  gl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif\n",THREE.ShaderChunk.tonemapping_pars_fragment="#define saturate(a) clamp( a, 0.0, 1.0 )\nuniform float toneMappingExposure;\nuniform float toneMappingWhitePoint;\nvec3 LinearToneMapping( vec3 color ) {\n  return toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  return saturate( color / ( vec3( 1.0 ) + color ) );\n}\n#define Uncharted2Helper( x ) max( ( ( x * ( 0.15 * x + 0.10 * 0.50 ) + 0.20 * 0.02 ) / ( x * ( 0.15 * x + 0.50 ) + 0.20 * 0.30 ) ) - 0.02 / 0.30, vec3( 0.0 ) )\nvec3 Uncharted2ToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  return saturate( Uncharted2Helper( color ) / Uncharted2Helper( vec3( toneMappingWhitePoint ) ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  color = max( vec3( 0.0 ), color - 0.004 );\n  return pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\n",THREE.ShaderChunk.uv2_pars_fragment="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n	varying vec2 vUv2;\n#endif",THREE.ShaderChunk.uv2_pars_vertex="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n	attribute vec2 uv2;\n	varying vec2 vUv2;\n#endif",THREE.ShaderChunk.uv2_vertex="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n	vUv2 = uv2;\n#endif",THREE.ShaderChunk.uv_pars_fragment="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n	varying vec2 vUv;\n#endif",THREE.ShaderChunk.uv_pars_vertex="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n	varying vec2 vUv;\n	uniform vec4 offsetRepeat;\n#endif\n",THREE.ShaderChunk.uv_vertex="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n	vUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",THREE.ShaderChunk.worldpos_vertex="#if defined( USE_ENVMAP ) || defined( PHONG ) || defined( PHYSICAL ) || defined( LAMBERT ) || defined ( USE_SHADOWMAP )\n	#ifdef USE_SKINNING\n		vec4 worldPosition = modelMatrix * skinned;\n	#else\n		vec4 worldPosition = modelMatrix * vec4( transformed, 1.0 );\n	#endif\n#endif\n",THREE.UniformsUtils={merge:function(e){for(var t={},i=0;i<e.length;i++){var r,n=this.clone(e[i]);for(r in n)t[r]=n[r]}return t},clone:function(e){var t,i={};for(t in e){i[t]={};for(var r in e[t]){var n=e[t][r];n instanceof THREE.Color||n instanceof THREE.Vector2||n instanceof THREE.Vector3||n instanceof THREE.Vector4||n instanceof THREE.Matrix3||n instanceof THREE.Matrix4||n instanceof THREE.Texture?i[t][r]=n.clone():Array.isArray(n)?i[t][r]=n.slice():i[t][r]=n}}return i}},THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"1f",value:1},map:{type:"t",value:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},specularMap:{type:"t",value:null},alphaMap:{type:"t",value:null},envMap:{type:"t",value:null},flipEnvMap:{type:"1f",value:-1},reflectivity:{type:"1f",value:1},refractionRatio:{type:"1f",value:.98}},aomap:{aoMap:{type:"t",value:null},aoMapIntensity:{type:"1f",value:1}},lightmap:{lightMap:{type:"t",value:null},lightMapIntensity:{type:"1f",value:1}},emissivemap:{emissiveMap:{type:"t",value:null}},bumpmap:{bumpMap:{type:"t",value:null},bumpScale:{type:"1f",value:1}},normalmap:{normalMap:{type:"t",value:null},normalScale:{type:"v2",value:new THREE.Vector2(1,1)}},displacementmap:{displacementMap:{type:"t",value:null},displacementScale:{type:"1f",value:1},displacementBias:{type:"1f",value:0}},roughnessmap:{roughnessMap:{type:"t",value:null}},metalnessmap:{metalnessMap:{type:"t",value:null}},fog:{fogDensity:{type:"1f",value:25e-5},fogNear:{type:"1f",value:1},fogFar:{type:"1f",value:2e3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{ambientLightColor:{type:"3fv",value:[]},directionalLights:{type:"sa",value:[],properties:{direction:{type:"v3"},color:{type:"c"},shadow:{type:"1i"},shadowBias:{type:"1f"},shadowRadius:{type:"1f"},shadowMapSize:{type:"v2"}}},directionalShadowMap:{type:"tv",value:[]},directionalShadowMatrix:{type:"m4v",value:[]},spotLights:{type:"sa",value:[],properties:{color:{type:"c"},position:{type:"v3"},direction:{type:"v3"},distance:{type:"1f"},coneCos:{type:"1f"},penumbraCos:{type:"1f"},decay:{type:"1f"},shadow:{type:"1i"},shadowBias:{type:"1f"},shadowRadius:{type:"1f"},shadowMapSize:{type:"v2"}}},spotShadowMap:{type:"tv",value:[]},spotShadowMatrix:{type:"m4v",value:[]},pointLights:{type:"sa",value:[],properties:{color:{type:"c"},position:{type:"v3"},decay:{type:"1f"},distance:{type:"1f"},shadow:{type:"1i"},shadowBias:{type:"1f"},shadowRadius:{type:"1f"},shadowMapSize:{type:"v2"}}},pointShadowMap:{type:"tv",value:[]},pointShadowMatrix:{type:"m4v",value:[]},hemisphereLights:{type:"sa",value:[],properties:{direction:{type:"v3"},skyColor:{type:"c"},groundColor:{type:"c"}}}},points:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"1f",value:1},size:{type:"1f",value:1},scale:{type:"1f",value:1},map:{type:"t",value:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)}}},THREE.ShaderChunk.cube_frag="uniform samplerCube tCube;\nuniform float tFlip;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	gl_FragColor = textureCube( tCube, vec3( tFlip * vWorldPosition.x, vWorldPosition.yz ) );\n	#include <logdepthbuf_fragment>\n}\n",THREE.ShaderChunk.cube_vert="varying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	vWorldPosition = transformDirection( position, modelMatrix );\n	#include <begin_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.depth_frag="#if DEPTH_PACKING == 3200\n	uniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( 1.0 );\n	#if DEPTH_PACKING == 3200\n		diffuseColor.a = opacity;\n	#endif\n	#include <map_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <logdepthbuf_fragment>\n	#if DEPTH_PACKING == 3200\n		gl_FragColor = vec4( vec3( gl_FragCoord.z ), opacity );\n	#elif DEPTH_PACKING == 3201\n		gl_FragColor = packDepthToRGBA( gl_FragCoord.z );\n	#endif\n}\n",THREE.ShaderChunk.depth_vert="#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <skinbase_vertex>\n	#include <begin_vertex>\n	#include <displacementmap_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.distanceRGBA_frag="uniform vec3 lightPos;\nvarying vec4 vWorldPosition;\n#include <common>\n#include <packing>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n	#include <clipping_planes_fragment>\n	gl_FragColor = packDepthToRGBA( length( vWorldPosition.xyz - lightPos.xyz ) / 1000.0 );\n}\n",THREE.ShaderChunk.distanceRGBA_vert="varying vec4 vWorldPosition;\n#include <common>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <skinbase_vertex>\n	#include <begin_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <worldpos_vertex>\n	#include <clipping_planes_vertex>\n	vWorldPosition = worldPosition;\n}\n",THREE.ShaderChunk.equirect_frag="uniform sampler2D tEquirect;\nuniform float tFlip;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec3 direction = normalize( vWorldPosition );\n	vec2 sampleUV;\n	sampleUV.y = saturate( tFlip * direction.y * -0.5 + 0.5 );\n	sampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;\n	gl_FragColor = texture2D( tEquirect, sampleUV );\n	#include <logdepthbuf_fragment>\n}\n",THREE.ShaderChunk.equirect_vert="varying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	vWorldPosition = transformDirection( position, modelMatrix );\n	#include <begin_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.linedashed_frag="uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	if ( mod( vLineDistance, totalSize ) > dashSize ) {\n		discard;\n	}\n	vec3 outgoingLight = vec3( 0.0 );\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	#include <logdepthbuf_fragment>\n	#include <color_fragment>\n	outgoingLight = diffuseColor.rgb;\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.linedashed_vert="uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <color_vertex>\n	vLineDistance = scale * lineDistance;\n	vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n	gl_Position = projectionMatrix * mvPosition;\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.meshbasic_frag="uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	#include <logdepthbuf_fragment>\n	#include <map_fragment>\n	#include <color_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <specularmap_fragment>\n	ReflectedLight reflectedLight;\n	reflectedLight.directDiffuse = vec3( 0.0 );\n	reflectedLight.directSpecular = vec3( 0.0 );\n	reflectedLight.indirectDiffuse = diffuseColor.rgb;\n	reflectedLight.indirectSpecular = vec3( 0.0 );\n	#include <aomap_fragment>\n	vec3 outgoingLight = reflectedLight.indirectDiffuse;\n	#include <envmap_fragment>\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.meshbasic_vert="#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <uv2_vertex>\n	#include <color_vertex>\n	#include <skinbase_vertex>\n	#ifdef USE_ENVMAP\n	#include <beginnormal_vertex>\n	#include <morphnormal_vertex>\n	#include <skinnormal_vertex>\n	#include <defaultnormal_vertex>\n	#endif\n	#include <begin_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <worldpos_vertex>\n	#include <clipping_planes_vertex>\n	#include <envmap_vertex>\n}\n",THREE.ShaderChunk.meshlambert_frag="uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n	varying vec3 vLightBack;\n#endif\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n	vec3 totalEmissiveRadiance = emissive;\n	#include <logdepthbuf_fragment>\n	#include <map_fragment>\n	#include <color_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <specularmap_fragment>\n	#include <emissivemap_fragment>\n	reflectedLight.indirectDiffuse = getAmbientLightIrradiance( ambientLightColor );\n	#include <lightmap_fragment>\n	reflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n	#ifdef DOUBLE_SIDED\n		reflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n	#else\n		reflectedLight.directDiffuse = vLightFront;\n	#endif\n	reflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n	#include <aomap_fragment>\n	vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n	#include <envmap_fragment>\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.meshlambert_vert="#define LAMBERT\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n	varying vec3 vLightBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <uv2_vertex>\n	#include <color_vertex>\n	#include <beginnormal_vertex>\n	#include <morphnormal_vertex>\n	#include <skinbase_vertex>\n	#include <skinnormal_vertex>\n	#include <defaultnormal_vertex>\n	#include <begin_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n	#include <worldpos_vertex>\n	#include <envmap_vertex>\n	#include <lights_lambert_vertex>\n	#include <shadowmap_vertex>\n}\n",THREE.ShaderChunk.meshphong_frag="#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n	vec3 totalEmissiveRadiance = emissive;\n	#include <logdepthbuf_fragment>\n	#include <map_fragment>\n	#include <color_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <specularmap_fragment>\n	#include <normal_fragment>\n	#include <emissivemap_fragment>\n	#include <lights_phong_fragment>\n	#include <lights_template>\n	#include <aomap_fragment>\n	vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n	#include <envmap_fragment>\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.meshphong_vert="#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <uv2_vertex>\n	#include <color_vertex>\n	#include <beginnormal_vertex>\n	#include <morphnormal_vertex>\n	#include <skinbase_vertex>\n	#include <skinnormal_vertex>\n	#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n	vNormal = normalize( transformedNormal );\n#endif\n	#include <begin_vertex>\n	#include <displacementmap_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n	vViewPosition = - mvPosition.xyz;\n	#include <worldpos_vertex>\n	#include <envmap_vertex>\n	#include <shadowmap_vertex>\n}\n",THREE.ShaderChunk.meshphysical_frag="#define PHYSICAL\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float envMapIntensity;\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <lights_pars>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n	vec3 totalEmissiveRadiance = emissive;\n	#include <logdepthbuf_fragment>\n	#include <map_fragment>\n	#include <color_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <specularmap_fragment>\n	#include <roughnessmap_fragment>\n	#include <metalnessmap_fragment>\n	#include <normal_fragment>\n	#include <emissivemap_fragment>\n	#include <lights_physical_fragment>\n	#include <lights_template>\n	#include <aomap_fragment>\n	vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.meshphysical_vert="#define PHYSICAL\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <uv2_vertex>\n	#include <color_vertex>\n	#include <beginnormal_vertex>\n	#include <morphnormal_vertex>\n	#include <skinbase_vertex>\n	#include <skinnormal_vertex>\n	#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n	vNormal = normalize( transformedNormal );\n#endif\n	#include <begin_vertex>\n	#include <displacementmap_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n	vViewPosition = - mvPosition.xyz;\n	#include <worldpos_vertex>\n	#include <shadowmap_vertex>\n}\n",THREE.ShaderChunk.normal_frag="uniform float opacity;\nvarying vec3 vNormal;\n#include <common>\n#include <packing>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	gl_FragColor = vec4( packNormalToRGB( vNormal ), opacity );\n	#include <logdepthbuf_fragment>\n}\n",THREE.ShaderChunk.normal_vert="varying vec3 vNormal;\n#include <common>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	vNormal = normalize( normalMatrix * normal );\n	#include <begin_vertex>\n	#include <morphtarget_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.points_frag="uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec3 outgoingLight = vec3( 0.0 );\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	#include <logdepthbuf_fragment>\n	#include <map_particle_fragment>\n	#include <color_fragment>\n	#include <alphatest_fragment>\n	outgoingLight = diffuseColor.rgb;\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.points_vert="uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <color_vertex>\n	#include <begin_vertex>\n	#include <project_vertex>\n	#ifdef USE_SIZEATTENUATION\n		gl_PointSize = size * ( scale / - mvPosition.z );\n	#else\n		gl_PointSize = size;\n	#endif\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n	#include <worldpos_vertex>\n	#include <shadowmap_vertex>\n}\n",THREE.ShaderChunk.shadow_frag="uniform float opacity;\n#include <common>\n#include <packing>\n#include <bsdfs>\n#include <lights_pars>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n	gl_FragColor = vec4( 0.0, 0.0, 0.0, opacity * ( 1.0  - getShadowMask() ) );\n}\n",THREE.ShaderChunk.shadow_vert="#include <shadowmap_pars_vertex>\nvoid main() {\n	#include <begin_vertex>\n	#include <project_vertex>\n	#include <worldpos_vertex>\n	#include <shadowmap_vertex>\n}\n",THREE.ShaderLib={basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.fog]),vertexShader:THREE.ShaderChunk.meshbasic_vert,fragmentShader:THREE.ShaderChunk.meshbasic_frag},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.lightmap,THREE.UniformsLib.emissivemap,THREE.UniformsLib.fog,THREE.UniformsLib.lights,{emissive:{type:"c",value:new THREE.Color(0)}}]),vertexShader:THREE.ShaderChunk.meshlambert_vert,fragmentShader:THREE.ShaderChunk.meshlambert_frag},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.lightmap,THREE.UniformsLib.emissivemap,THREE.UniformsLib.bumpmap,THREE.UniformsLib.normalmap,THREE.UniformsLib.displacementmap,THREE.UniformsLib.fog,THREE.UniformsLib.lights,{emissive:{type:"c",value:new THREE.Color(0)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"1f",value:30}}]),vertexShader:THREE.ShaderChunk.meshphong_vert,fragmentShader:THREE.ShaderChunk.meshphong_frag},standard:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.lightmap,THREE.UniformsLib.emissivemap,THREE.UniformsLib.bumpmap,THREE.UniformsLib.normalmap,THREE.UniformsLib.displacementmap,THREE.UniformsLib.roughnessmap,THREE.UniformsLib.metalnessmap,THREE.UniformsLib.fog,THREE.UniformsLib.lights,{emissive:{type:"c",value:new THREE.Color(0)},roughness:{type:"1f",value:.5},metalness:{type:"1f",value:0},envMapIntensity:{type:"1f",value:1}}]),vertexShader:THREE.ShaderChunk.meshphysical_vert,fragmentShader:THREE.ShaderChunk.meshphysical_frag},points:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.points,THREE.UniformsLib.fog]),vertexShader:THREE.ShaderChunk.points_vert,fragmentShader:THREE.ShaderChunk.points_frag},dashed:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,{scale:{type:"1f",value:1},dashSize:{type:"1f",value:1},totalSize:{type:"1f",value:2}}]),vertexShader:THREE.ShaderChunk.linedashed_vert,fragmentShader:THREE.ShaderChunk.linedashed_frag},depth:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.displacementmap]),vertexShader:THREE.ShaderChunk.depth_vert,fragmentShader:THREE.ShaderChunk.depth_frag},normal:{uniforms:{opacity:{type:"1f",value:1}},vertexShader:THREE.ShaderChunk.normal_vert,fragmentShader:THREE.ShaderChunk.normal_frag},cube:{uniforms:{tCube:{type:"t",value:null},tFlip:{type:"1f",value:-1}},vertexShader:THREE.ShaderChunk.cube_vert,fragmentShader:THREE.ShaderChunk.cube_frag},equirect:{uniforms:{tEquirect:{type:"t",value:null},tFlip:{type:"1f",value:-1}},vertexShader:THREE.ShaderChunk.equirect_vert,fragmentShader:THREE.ShaderChunk.equirect_frag},distanceRGBA:{uniforms:{lightPos:{type:"v3",value:new THREE.Vector3}},vertexShader:THREE.ShaderChunk.distanceRGBA_vert,fragmentShader:THREE.ShaderChunk.distanceRGBA_frag}},THREE.ShaderLib.physical={uniforms:THREE.UniformsUtils.merge([THREE.ShaderLib.standard.uniforms,{}]),vertexShader:THREE.ShaderChunk.meshphysical_vert,fragmentShader:THREE.ShaderChunk.meshphysical_frag},THREE.WebGLRenderer=function(e){function t(e,t,i,r){!0===P&&(e*=r,t*=r,i*=r),xe.clearColor(e,t,i,r)}function i(){xe.init(),xe.scissor(Z.copy(ne).multiplyScalar(re)),xe.viewport(Q.copy(ae).multiplyScalar(re)),t($.r,$.g,$.b,ee)}function r(){q=k=null,Y="",X=-1,xe.reset()}function n(e){e.preventDefault(),r(),i(),He.clear()}function o(e){e=e.target,e.removeEventListener("dispose",o);
e:{var t=He.get(e);if(e.image&&t.__image__webglTextureCube)ge.deleteTexture(t.__image__webglTextureCube);else{if(void 0===t.__webglInit)break e;ge.deleteTexture(t.__webglTexture)}He["delete"](e)}Ee.textures--}function a(e){e=e.target,e.removeEventListener("dispose",a);var t=He.get(e),i=He.get(e.texture);if(e){if(void 0!==i.__webglTexture&&ge.deleteTexture(i.__webglTexture),e.depthTexture&&e.depthTexture.dispose(),e instanceof THREE.WebGLRenderTargetCube)for(i=0;6>i;i++)ge.deleteFramebuffer(t.__webglFramebuffer[i]),t.__webglDepthbuffer&&ge.deleteRenderbuffer(t.__webglDepthbuffer[i]);else ge.deleteFramebuffer(t.__webglFramebuffer),t.__webglDepthbuffer&&ge.deleteRenderbuffer(t.__webglDepthbuffer);He["delete"](e.texture),He["delete"](e)}Ee.textures--}function s(e){e=e.target,e.removeEventListener("dispose",s),c(e),He["delete"](e)}function c(e){var t=He.get(e).program;e.program=void 0,void 0!==t&&_e.releaseProgram(t)}function h(e,t){return Math.abs(t[0])-Math.abs(e[0])}function l(e,t){return e.object.renderOrder!==t.object.renderOrder?e.object.renderOrder-t.object.renderOrder:e.material.id!==t.material.id?e.material.id-t.material.id:e.z!==t.z?e.z-t.z:e.id-t.id}function u(e,t){return e.object.renderOrder!==t.object.renderOrder?e.object.renderOrder-t.object.renderOrder:e.z!==t.z?t.z-e.z:e.id-t.id}function p(e,t,i,r,n){var o;i.transparent?(r=O,o=++F):(r=D,o=++I),o=r[o],void 0!==o?(o.id=e.id,o.object=e,o.geometry=t,o.material=i,o.z=de.z,o.group=n):(o={id:e.id,object:e,geometry:t,material:i,z:de.z,group:n},r.push(o))}function d(e){if(!se.intersectsSphere(e))return!1;var t=ce.numPlanes;if(0===t)return!0;var i=z.clippingPlanes,r=e.center;e=-e.radius;var n=0;do if(i[n].distanceToPoint(r)<e)return!1;while(++n!==t);return!0}function f(e,t){if(!1!==e.visible){if(e.layers.test(t.layers))if(e instanceof THREE.Light)U.push(e);else if(e instanceof THREE.Sprite){var i;(i=!1===e.frustumCulled)||(ue.center.set(0,0,0),ue.radius=.7071067811865476,ue.applyMatrix4(e.matrixWorld),i=!0===d(ue)),i&&V.push(e)}else if(e instanceof THREE.LensFlare)G.push(e);else if(e instanceof THREE.ImmediateRenderObject)!0===z.sortObjects&&(de.setFromMatrixPosition(e.matrixWorld),de.applyProjection(pe)),p(e,null,e.material,de.z,null);else if((e instanceof THREE.Mesh||e instanceof THREE.Line||e instanceof THREE.Points)&&(e instanceof THREE.SkinnedMesh&&e.skeleton.update(),(i=!1===e.frustumCulled)||(i=e.geometry,null===i.boundingSphere&&i.computeBoundingSphere(),ue.copy(i.boundingSphere).applyMatrix4(e.matrixWorld),i=!0===d(ue)),i)){var r=e.material;if(!0===r.visible)if(!0===z.sortObjects&&(de.setFromMatrixPosition(e.matrixWorld),de.applyProjection(pe)),i=be.update(e),r instanceof THREE.MultiMaterial)for(var n=i.groups,o=r.materials,r=0,a=n.length;a>r;r++){var s=n[r],c=o[s.materialIndex];!0===c.visible&&p(e,i,c,de.z,s)}else p(e,i,r,de.z,null)}for(i=e.children,r=0,a=i.length;a>r;r++)f(i[r],t)}}function E(e,t,i,r){for(var n=0,o=e.length;o>n;n++){var a=e[n],s=a.object,c=a.geometry,h=void 0===r?a.material:r,a=a.group;if(s.modelViewMatrix.multiplyMatrices(t.matrixWorldInverse,s.matrixWorld),s.normalMatrix.getNormalMatrix(s.modelViewMatrix),s instanceof THREE.ImmediateRenderObject){m(h);var l=g(t,i,h,s);Y="",s.render(function(e){z.renderBufferImmediate(e,l,h)})}else z.renderBufferDirect(t,i,c,h,s,a)}}function m(e){e.side!==THREE.DoubleSide?xe.enable(ge.CULL_FACE):xe.disable(ge.CULL_FACE),xe.setFlipSided(e.side===THREE.BackSide),!0===e.transparent?xe.setBlending(e.blending,e.blendEquation,e.blendSrc,e.blendDst,e.blendEquationAlpha,e.blendSrcAlpha,e.blendDstAlpha,e.premultipliedAlpha):xe.setBlending(THREE.NoBlending),xe.setDepthFunc(e.depthFunc),xe.setDepthTest(e.depthTest),xe.setDepthWrite(e.depthWrite),xe.setColorWrite(e.colorWrite),xe.setPolygonOffset(e.polygonOffset,e.polygonOffsetFactor,e.polygonOffsetUnits)}function g(e,t,i,r){J=0;var n=He.get(i);if(he&&((le||e!==q)&&ce.setState(i.clippingPlanes,i.clipShadows,e,n,e===q&&i.id===X),void 0!==n.numClippingPlanes&&n.numClippingPlanes!==ce.numPlanes&&(i.needsUpdate=!0)),void 0===n.program&&(i.needsUpdate=!0),void 0!==n.lightsHash&&n.lightsHash!==fe.hash&&(i.needsUpdate=!0),i.needsUpdate){e:{var o=He.get(i),a=_e.getParameters(i,fe,t,ce.numPlanes,r),h=_e.getProgramCode(i,a),l=o.program,u=!0;if(void 0===l)i.addEventListener("dispose",s);else if(l.code!==h)c(i);else{if(void 0!==a.shaderID)break e;u=!1}if(u&&(a.shaderID?(l=THREE.ShaderLib[a.shaderID],o.__webglShader={name:i.type,uniforms:THREE.UniformsUtils.clone(l.uniforms),vertexShader:l.vertexShader,fragmentShader:l.fragmentShader}):o.__webglShader={name:i.type,uniforms:i.uniforms,vertexShader:i.vertexShader,fragmentShader:i.fragmentShader},i.__webglShader=o.__webglShader,l=_e.acquireProgram(i,a,h),o.program=l,i.program=l),a=l.getAttributes(),i.morphTargets)for(h=i.numSupportedMorphTargets=0;h<z.maxMorphTargets;h++)0<=a["morphTarget"+h]&&i.numSupportedMorphTargets++;if(i.morphNormals)for(h=i.numSupportedMorphNormals=0;h<z.maxMorphNormals;h++)0<=a["morphNormal"+h]&&i.numSupportedMorphNormals++;a=o.__webglShader.uniforms,(i instanceof THREE.ShaderMaterial||i instanceof THREE.RawShaderMaterial)&&!0!==i.clipping||(o.numClippingPlanes=ce.numPlanes,a.clippingPlanes=ce.uniform),i.lights&&(o.lightsHash=fe.hash,a.ambientLightColor.value=fe.ambient,a.directionalLights.value=fe.directional,a.spotLights.value=fe.spot,a.pointLights.value=fe.point,a.hemisphereLights.value=fe.hemi,a.directionalShadowMap.value=fe.directionalShadowMap,a.directionalShadowMatrix.value=fe.directionalShadowMatrix,a.spotShadowMap.value=fe.spotShadowMap,a.spotShadowMatrix.value=fe.spotShadowMatrix,a.pointShadowMap.value=fe.pointShadowMap,a.pointShadowMatrix.value=fe.pointShadowMatrix),h=o.program.getUniforms(),h=THREE.WebGLUniforms.seqWithValue(h.seq,a),o.uniformsList=h,o.dynamicUniforms=THREE.WebGLUniforms.splitDynamic(h,a)}i.needsUpdate=!1}var p=!1,u=l=!1,o=n.program,h=o.getUniforms(),a=n.__webglShader.uniforms;if(o.id!==k&&(ge.useProgram(o.program),k=o.id,u=l=p=!0),i.id!==X&&(X=i.id,l=!0),(p||e!==q)&&(h.set(ge,e,"projectionMatrix"),Re.logarithmicDepthBuffer&&h.setValue(ge,"logDepthBufFC",2/(Math.log(e.far+1)/Math.LN2)),e!==q&&(q=e,u=l=!0),(i instanceof THREE.ShaderMaterial||i instanceof THREE.MeshPhongMaterial||i instanceof THREE.MeshStandardMaterial||i.envMap)&&(p=h.map.cameraPosition,void 0!==p&&p.setValue(ge,de.setFromMatrixPosition(e.matrixWorld))),(i instanceof THREE.MeshPhongMaterial||i instanceof THREE.MeshLambertMaterial||i instanceof THREE.MeshBasicMaterial||i instanceof THREE.MeshStandardMaterial||i instanceof THREE.ShaderMaterial||i.skinning)&&h.setValue(ge,"viewMatrix",e.matrixWorldInverse),h.set(ge,z,"toneMappingExposure"),h.set(ge,z,"toneMappingWhitePoint")),i.skinning&&(h.setOptional(ge,r,"bindMatrix"),h.setOptional(ge,r,"bindMatrixInverse"),p=r.skeleton)&&(Re.floatVertexTextures&&p.useVertexTexture?(h.set(ge,p,"boneTexture"),h.set(ge,p,"boneTextureWidth"),h.set(ge,p,"boneTextureHeight")):h.setOptional(ge,p,"boneMatrices")),l){if(i.lights&&(l=u,a.ambientLightColor.needsUpdate=l,a.directionalLights.needsUpdate=l,a.pointLights.needsUpdate=l,a.spotLights.needsUpdate=l,a.hemisphereLights.needsUpdate=l),t&&i.fog&&(a.fogColor.value=t.color,t instanceof THREE.Fog?(a.fogNear.value=t.near,a.fogFar.value=t.far):t instanceof THREE.FogExp2&&(a.fogDensity.value=t.density)),i instanceof THREE.MeshBasicMaterial||i instanceof THREE.MeshLambertMaterial||i instanceof THREE.MeshPhongMaterial||i instanceof THREE.MeshStandardMaterial||i instanceof THREE.MeshDepthMaterial){a.opacity.value=i.opacity,a.diffuse.value=i.color,i.emissive&&a.emissive.value.copy(i.emissive).multiplyScalar(i.emissiveIntensity),a.map.value=i.map,a.specularMap.value=i.specularMap,a.alphaMap.value=i.alphaMap,i.aoMap&&(a.aoMap.value=i.aoMap,a.aoMapIntensity.value=i.aoMapIntensity);var d;i.map?d=i.map:i.specularMap?d=i.specularMap:i.displacementMap?d=i.displacementMap:i.normalMap?d=i.normalMap:i.bumpMap?d=i.bumpMap:i.roughnessMap?d=i.roughnessMap:i.metalnessMap?d=i.metalnessMap:i.alphaMap?d=i.alphaMap:i.emissiveMap&&(d=i.emissiveMap),void 0!==d&&(d instanceof THREE.WebGLRenderTarget&&(d=d.texture),t=d.offset,d=d.repeat,a.offsetRepeat.value.set(t.x,t.y,d.x,d.y)),a.envMap.value=i.envMap,a.flipEnvMap.value=i.envMap instanceof THREE.CubeTexture?-1:1,a.reflectivity.value=i.reflectivity,a.refractionRatio.value=i.refractionRatio}i instanceof THREE.LineBasicMaterial?(a.diffuse.value=i.color,a.opacity.value=i.opacity):i instanceof THREE.LineDashedMaterial?(a.diffuse.value=i.color,a.opacity.value=i.opacity,a.dashSize.value=i.dashSize,a.totalSize.value=i.dashSize+i.gapSize,a.scale.value=i.scale):i instanceof THREE.PointsMaterial?(a.diffuse.value=i.color,a.opacity.value=i.opacity,a.size.value=i.size*re,a.scale.value=.5*M.clientHeight,a.map.value=i.map,null!==i.map&&(d=i.map.offset,i=i.map.repeat,a.offsetRepeat.value.set(d.x,d.y,i.x,i.y))):i instanceof THREE.MeshLambertMaterial?(i.lightMap&&(a.lightMap.value=i.lightMap,a.lightMapIntensity.value=i.lightMapIntensity),i.emissiveMap&&(a.emissiveMap.value=i.emissiveMap)):i instanceof THREE.MeshPhongMaterial?(a.specular.value=i.specular,a.shininess.value=Math.max(i.shininess,1e-4),i.lightMap&&(a.lightMap.value=i.lightMap,a.lightMapIntensity.value=i.lightMapIntensity),i.emissiveMap&&(a.emissiveMap.value=i.emissiveMap),i.bumpMap&&(a.bumpMap.value=i.bumpMap,a.bumpScale.value=i.bumpScale),i.normalMap&&(a.normalMap.value=i.normalMap,a.normalScale.value.copy(i.normalScale)),i.displacementMap&&(a.displacementMap.value=i.displacementMap,a.displacementScale.value=i.displacementScale,a.displacementBias.value=i.displacementBias)):i instanceof THREE.MeshPhysicalMaterial?T(a,i):i instanceof THREE.MeshStandardMaterial?T(a,i):i instanceof THREE.MeshDepthMaterial?i.displacementMap&&(a.displacementMap.value=i.displacementMap,a.displacementScale.value=i.displacementScale,a.displacementBias.value=i.displacementBias):i instanceof THREE.MeshNormalMaterial&&(a.opacity.value=i.opacity),THREE.WebGLUniforms.upload(ge,n.uniformsList,a,z)}return h.set(ge,r,"modelViewMatrix"),h.set(ge,r,"normalMatrix"),h.setValue(ge,"modelMatrix",r.matrixWorld),n=n.dynamicUniforms,null!==n&&(THREE.WebGLUniforms.evalDynamic(n,a,r,e),THREE.WebGLUniforms.upload(ge,n,a,z)),o}function T(e,t){e.roughness.value=t.roughness,e.metalness.value=t.metalness,t.roughnessMap&&(e.roughnessMap.value=t.roughnessMap),t.metalnessMap&&(e.metalnessMap.value=t.metalnessMap),t.lightMap&&(e.lightMap.value=t.lightMap,e.lightMapIntensity.value=t.lightMapIntensity),t.emissiveMap&&(e.emissiveMap.value=t.emissiveMap),t.bumpMap&&(e.bumpMap.value=t.bumpMap,e.bumpScale.value=t.bumpScale),t.normalMap&&(e.normalMap.value=t.normalMap,e.normalScale.value.copy(t.normalScale)),t.displacementMap&&(e.displacementMap.value=t.displacementMap,e.displacementScale.value=t.displacementScale,e.displacementBias.value=t.displacementBias),t.envMap&&(e.envMapIntensity.value=t.envMapIntensity)}function v(e,t,i){i?(ge.texParameteri(e,ge.TEXTURE_WRAP_S,_(t.wrapS)),ge.texParameteri(e,ge.TEXTURE_WRAP_T,_(t.wrapT)),ge.texParameteri(e,ge.TEXTURE_MAG_FILTER,_(t.magFilter)),ge.texParameteri(e,ge.TEXTURE_MIN_FILTER,_(t.minFilter))):(ge.texParameteri(e,ge.TEXTURE_WRAP_S,ge.CLAMP_TO_EDGE),ge.texParameteri(e,ge.TEXTURE_WRAP_T,ge.CLAMP_TO_EDGE),t.wrapS===THREE.ClampToEdgeWrapping&&t.wrapT===THREE.ClampToEdgeWrapping||console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping.",t),ge.texParameteri(e,ge.TEXTURE_MAG_FILTER,b(t.magFilter)),ge.texParameteri(e,ge.TEXTURE_MIN_FILTER,b(t.minFilter)),t.minFilter!==THREE.NearestFilter&&t.minFilter!==THREE.LinearFilter&&console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter.",t)),!(i=ye.get("EXT_texture_filter_anisotropic"))||t.type===THREE.FloatType&&null===ye.get("OES_texture_float_linear")||t.type===THREE.HalfFloatType&&null===ye.get("OES_texture_half_float_linear")||!(1<t.anisotropy||He.get(t).__currentAnisotropy)||(ge.texParameterf(e,i.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(t.anisotropy,z.getMaxAnisotropy())),He.get(t).__currentAnisotropy=t.anisotropy)}function y(e,t){if(e.width>t||e.height>t){var i=t/Math.max(e.width,e.height),r=document.createElement("canvas");return r.width=Math.floor(e.width*i),r.height=Math.floor(e.height*i),r.getContext("2d").drawImage(e,0,0,e.width,e.height,0,0,r.width,r.height),console.warn("THREE.WebGLRenderer: image is too big ("+e.width+"x"+e.height+"). Resized to "+r.width+"x"+r.height,e),r}return e}function R(e){return THREE.Math.isPowerOfTwo(e.width)&&THREE.Math.isPowerOfTwo(e.height)}function x(e,t,i,r){var n=_(t.texture.format),o=_(t.texture.type);xe.texImage2D(r,0,n,t.width,t.height,0,n,o,null),ge.bindFramebuffer(ge.FRAMEBUFFER,e),ge.framebufferTexture2D(ge.FRAMEBUFFER,i,r,He.get(t.texture).__webglTexture,0),ge.bindFramebuffer(ge.FRAMEBUFFER,null)}function H(e,t){ge.bindRenderbuffer(ge.RENDERBUFFER,e),t.depthBuffer&&!t.stencilBuffer?(ge.renderbufferStorage(ge.RENDERBUFFER,ge.DEPTH_COMPONENT16,t.width,t.height),ge.framebufferRenderbuffer(ge.FRAMEBUFFER,ge.DEPTH_ATTACHMENT,ge.RENDERBUFFER,e)):t.depthBuffer&&t.stencilBuffer?(ge.renderbufferStorage(ge.RENDERBUFFER,ge.DEPTH_STENCIL,t.width,t.height),ge.framebufferRenderbuffer(ge.FRAMEBUFFER,ge.DEPTH_STENCIL_ATTACHMENT,ge.RENDERBUFFER,e)):ge.renderbufferStorage(ge.RENDERBUFFER,ge.RGBA4,t.width,t.height),ge.bindRenderbuffer(ge.RENDERBUFFER,null)}function b(e){return e===THREE.NearestFilter||e===THREE.NearestMipMapNearestFilter||e===THREE.NearestMipMapLinearFilter?ge.NEAREST:ge.LINEAR}function _(e){var t;if(e===THREE.RepeatWrapping)return ge.REPEAT;if(e===THREE.ClampToEdgeWrapping)return ge.CLAMP_TO_EDGE;if(e===THREE.MirroredRepeatWrapping)return ge.MIRRORED_REPEAT;if(e===THREE.NearestFilter)return ge.NEAREST;if(e===THREE.NearestMipMapNearestFilter)return ge.NEAREST_MIPMAP_NEAREST;if(e===THREE.NearestMipMapLinearFilter)return ge.NEAREST_MIPMAP_LINEAR;if(e===THREE.LinearFilter)return ge.LINEAR;if(e===THREE.LinearMipMapNearestFilter)return ge.LINEAR_MIPMAP_NEAREST;if(e===THREE.LinearMipMapLinearFilter)return ge.LINEAR_MIPMAP_LINEAR;if(e===THREE.UnsignedByteType)return ge.UNSIGNED_BYTE;if(e===THREE.UnsignedShort4444Type)return ge.UNSIGNED_SHORT_4_4_4_4;if(e===THREE.UnsignedShort5551Type)return ge.UNSIGNED_SHORT_5_5_5_1;if(e===THREE.UnsignedShort565Type)return ge.UNSIGNED_SHORT_5_6_5;if(e===THREE.ByteType)return ge.BYTE;if(e===THREE.ShortType)return ge.SHORT;if(e===THREE.UnsignedShortType)return ge.UNSIGNED_SHORT;if(e===THREE.IntType)return ge.INT;if(e===THREE.UnsignedIntType)return ge.UNSIGNED_INT;if(e===THREE.FloatType)return ge.FLOAT;if(t=ye.get("OES_texture_half_float"),null!==t&&e===THREE.HalfFloatType)return t.HALF_FLOAT_OES;if(e===THREE.AlphaFormat)return ge.ALPHA;if(e===THREE.RGBFormat)return ge.RGB;if(e===THREE.RGBAFormat)return ge.RGBA;if(e===THREE.LuminanceFormat)return ge.LUMINANCE;if(e===THREE.LuminanceAlphaFormat)return ge.LUMINANCE_ALPHA;if(e===THREE.DepthFormat)return ge.DEPTH_COMPONENT;if(e===THREE.AddEquation)return ge.FUNC_ADD;if(e===THREE.SubtractEquation)return ge.FUNC_SUBTRACT;if(e===THREE.ReverseSubtractEquation)return ge.FUNC_REVERSE_SUBTRACT;if(e===THREE.ZeroFactor)return ge.ZERO;if(e===THREE.OneFactor)return ge.ONE;if(e===THREE.SrcColorFactor)return ge.SRC_COLOR;if(e===THREE.OneMinusSrcColorFactor)return ge.ONE_MINUS_SRC_COLOR;if(e===THREE.SrcAlphaFactor)return ge.SRC_ALPHA;if(e===THREE.OneMinusSrcAlphaFactor)return ge.ONE_MINUS_SRC_ALPHA;if(e===THREE.DstAlphaFactor)return ge.DST_ALPHA;if(e===THREE.OneMinusDstAlphaFactor)return ge.ONE_MINUS_DST_ALPHA;if(e===THREE.DstColorFactor)return ge.DST_COLOR;if(e===THREE.OneMinusDstColorFactor)return ge.ONE_MINUS_DST_COLOR;if(e===THREE.SrcAlphaSaturateFactor)return ge.SRC_ALPHA_SATURATE;if(t=ye.get("WEBGL_compressed_texture_s3tc"),null!==t){if(e===THREE.RGB_S3TC_DXT1_Format)return t.COMPRESSED_RGB_S3TC_DXT1_EXT;if(e===THREE.RGBA_S3TC_DXT1_Format)return t.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(e===THREE.RGBA_S3TC_DXT3_Format)return t.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(e===THREE.RGBA_S3TC_DXT5_Format)return t.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(t=ye.get("WEBGL_compressed_texture_pvrtc"),null!==t){if(e===THREE.RGB_PVRTC_4BPPV1_Format)return t.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(e===THREE.RGB_PVRTC_2BPPV1_Format)return t.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(e===THREE.RGBA_PVRTC_4BPPV1_Format)return t.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(e===THREE.RGBA_PVRTC_2BPPV1_Format)return t.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(t=ye.get("WEBGL_compressed_texture_etc1"),null!==t&&e===THREE.RGB_ETC1_Format)return t.COMPRESSED_RGB_ETC1_WEBGL;if(t=ye.get("EXT_blend_minmax"),null!==t){if(e===THREE.MinEquation)return t.MIN_EXT;if(e===THREE.MaxEquation)return t.MAX_EXT}return 0}console.log("THREE.WebGLRenderer",THREE.REVISION),e=e||{};var M=void 0!==e.canvas?e.canvas:document.createElement("canvas"),w=void 0!==e.context?e.context:null,S=void 0!==e.alpha?e.alpha:!1,L=void 0!==e.depth?e.depth:!0,A=void 0!==e.stencil?e.stencil:!0,C=void 0!==e.antialias?e.antialias:!1,P=void 0!==e.premultipliedAlpha?e.premultipliedAlpha:!0,B=void 0!==e.preserveDrawingBuffer?e.preserveDrawingBuffer:!1,U=[],D=[],I=-1,O=[],F=-1,N=new Float32Array(8),V=[],G=[];this.domElement=M,this.context=null,this.sortObjects=this.autoClearStencil=this.autoClearDepth=this.autoClearColor=this.autoClear=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.gammaFactor=2,this.physicallyCorrectLights=this.gammaOutput=this.gammaInput=!1,this.toneMapping=THREE.LinearToneMapping,this.toneMappingWhitePoint=this.toneMappingExposure=1,this.maxMorphTargets=8,this.maxMorphNormals=4,this.autoScaleCubemaps=!0;var z=this,k=null,j=null,W=null,X=-1,Y="",q=null,Z=new THREE.Vector4,K=null,Q=new THREE.Vector4,J=0,$=new THREE.Color(0),ee=0,te=M.width,ie=M.height,re=1,ne=new THREE.Vector4(0,0,te,ie),oe=!1,ae=new THREE.Vector4(0,0,te,ie),se=new THREE.Frustum,ce=new THREE.WebGLClipping,he=!1,le=!1,ue=new THREE.Sphere,pe=new THREE.Matrix4,de=new THREE.Vector3,fe={hash:"",ambient:[0,0,0],directional:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadowMap:[],spotShadowMatrix:[],point:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[],shadows:[]},Ee={geometries:0,textures:0},me={calls:0,vertices:0,faces:0,points:0};this.info={render:me,memory:Ee,programs:null};var ge;try{if(S={alpha:S,depth:L,stencil:A,antialias:C,premultipliedAlpha:P,preserveDrawingBuffer:B},ge=w||M.getContext("webgl",S)||M.getContext("experimental-webgl",S),null===ge){if(null!==M.getContext("webgl"))throw"Error creating WebGL context with your selected attributes.";throw"Error creating WebGL context."}void 0===ge.getShaderPrecisionFormat&&(ge.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}}),M.addEventListener("webglcontextlost",n,!1)}catch(Te){console.error("THREE.WebGLRenderer: "+Te)}var ve="undefined"!=typeof WebGL2RenderingContext&&ge instanceof WebGL2RenderingContext,ye=new THREE.WebGLExtensions(ge);ye.get("WEBGL_depth_texture"),ye.get("OES_texture_float"),ye.get("OES_texture_float_linear"),ye.get("OES_texture_half_float"),ye.get("OES_texture_half_float_linear"),ye.get("OES_standard_derivatives"),ye.get("ANGLE_instanced_arrays"),ye.get("OES_element_index_uint")&&(THREE.BufferGeometry.MaxIndex=4294967296);var Re=new THREE.WebGLCapabilities(ge,ye,e),xe=new THREE.WebGLState(ge,ye,_),He=new THREE.WebGLProperties,be=new THREE.WebGLObjects(ge,He,this.info),_e=new THREE.WebGLPrograms(this,Re),Me=new THREE.WebGLLights;this.info.programs=_e.programs;var we=new THREE.WebGLBufferRenderer(ge,ye,me),Se=new THREE.WebGLIndexedBufferRenderer(ge,ye,me);i(),this.context=ge,this.capabilities=Re,this.extensions=ye,this.properties=He,this.state=xe;var Le=new THREE.WebGLShadowMap(this,fe,be);this.shadowMap=Le;var Ae=new THREE.SpritePlugin(this,V),Ce=new THREE.LensFlarePlugin(this,G);this.getContext=function(){return ge},this.getContextAttributes=function(){return ge.getContextAttributes()},this.forceContextLoss=function(){ye.get("WEBGL_lose_context").loseContext()},this.getMaxAnisotropy=function(){var e;return function(){if(void 0!==e)return e;var t=ye.get("EXT_texture_filter_anisotropic");return e=null!==t?ge.getParameter(t.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0}}(),this.getPrecision=function(){return Re.precision},this.getPixelRatio=function(){return re},this.setPixelRatio=function(e){void 0!==e&&(re=e,this.setSize(ae.z,ae.w,!1))},this.getSize=function(){return{width:te,height:ie}},this.setSize=function(e,t,i){te=e,ie=t,M.width=e*re,M.height=t*re,!1!==i&&(M.style.width=e+"px",M.style.height=t+"px"),this.setViewport(0,0,e,t)},this.setViewport=function(e,t,i,r){xe.viewport(ae.set(e,t,i,r))},this.setScissor=function(e,t,i,r){xe.scissor(ne.set(e,t,i,r))},this.setScissorTest=function(e){xe.setScissorTest(oe=e)},this.getClearColor=function(){return $},this.setClearColor=function(e,i){$.set(e),ee=void 0!==i?i:1,t($.r,$.g,$.b,ee)},this.getClearAlpha=function(){return ee},this.setClearAlpha=function(e){ee=e,t($.r,$.g,$.b,ee)},this.clear=function(e,t,i){var r=0;(void 0===e||e)&&(r|=ge.COLOR_BUFFER_BIT),(void 0===t||t)&&(r|=ge.DEPTH_BUFFER_BIT),(void 0===i||i)&&(r|=ge.STENCIL_BUFFER_BIT),ge.clear(r)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.clearTarget=function(e,t,i,r){this.setRenderTarget(e),this.clear(t,i,r)},this.resetGLState=r,this.dispose=function(){M.removeEventListener("webglcontextlost",n,!1)},this.renderBufferImmediate=function(e,t,i){xe.initAttributes();var r=He.get(e);if(e.hasPositions&&!r.position&&(r.position=ge.createBuffer()),e.hasNormals&&!r.normal&&(r.normal=ge.createBuffer()),e.hasUvs&&!r.uv&&(r.uv=ge.createBuffer()),e.hasColors&&!r.color&&(r.color=ge.createBuffer()),t=t.getAttributes(),e.hasPositions&&(ge.bindBuffer(ge.ARRAY_BUFFER,r.position),ge.bufferData(ge.ARRAY_BUFFER,e.positionArray,ge.DYNAMIC_DRAW),xe.enableAttribute(t.position),ge.vertexAttribPointer(t.position,3,ge.FLOAT,!1,0,0)),e.hasNormals){if(ge.bindBuffer(ge.ARRAY_BUFFER,r.normal),"MeshPhongMaterial"!==i.type&&"MeshStandardMaterial"!==i.type&&"MeshPhysicalMaterial"!==i.type&&i.shading===THREE.FlatShading)for(var n=0,o=3*e.count;o>n;n+=9){var a=e.normalArray,s=(a[n+0]+a[n+3]+a[n+6])/3,c=(a[n+1]+a[n+4]+a[n+7])/3,h=(a[n+2]+a[n+5]+a[n+8])/3;a[n+0]=s,a[n+1]=c,a[n+2]=h,a[n+3]=s,a[n+4]=c,a[n+5]=h,a[n+6]=s,a[n+7]=c,a[n+8]=h}ge.bufferData(ge.ARRAY_BUFFER,e.normalArray,ge.DYNAMIC_DRAW),xe.enableAttribute(t.normal),ge.vertexAttribPointer(t.normal,3,ge.FLOAT,!1,0,0)}e.hasUvs&&i.map&&(ge.bindBuffer(ge.ARRAY_BUFFER,r.uv),ge.bufferData(ge.ARRAY_BUFFER,e.uvArray,ge.DYNAMIC_DRAW),xe.enableAttribute(t.uv),ge.vertexAttribPointer(t.uv,2,ge.FLOAT,!1,0,0)),e.hasColors&&i.vertexColors!==THREE.NoColors&&(ge.bindBuffer(ge.ARRAY_BUFFER,r.color),ge.bufferData(ge.ARRAY_BUFFER,e.colorArray,ge.DYNAMIC_DRAW),xe.enableAttribute(t.color),ge.vertexAttribPointer(t.color,3,ge.FLOAT,!1,0,0)),xe.disableUnusedAttributes(),ge.drawArrays(ge.TRIANGLES,0,e.count),e.count=0},this.renderBufferDirect=function(e,t,i,r,n,o){m(r);var a=g(e,t,r,n),s=!1;if(e=i.id+"_"+a.id+"_"+r.wireframe,e!==Y&&(Y=e,s=!0),t=n.morphTargetInfluences,void 0!==t){e=[];for(var c=0,s=t.length;s>c;c++){var l=t[c];e.push([l,c])}e.sort(h),8<e.length&&(e.length=8);for(var u=i.morphAttributes,c=0,s=e.length;s>c;c++)l=e[c],N[c]=l[0],0!==l[0]?(t=l[1],!0===r.morphTargets&&u.position&&i.addAttribute("morphTarget"+c,u.position[t]),!0===r.morphNormals&&u.normal&&i.addAttribute("morphNormal"+c,u.normal[t])):(!0===r.morphTargets&&i.removeAttribute("morphTarget"+c),!0===r.morphNormals&&i.removeAttribute("morphNormal"+c));a.getUniforms().setValue(ge,"morphTargetInfluences",N),s=!0}if(t=i.index,c=i.attributes.position,!0===r.wireframe&&(t=be.getWireframeAttribute(i)),null!==t?(e=Se,e.setIndex(t)):e=we,s){var p,s=void 0;if(i instanceof THREE.InstancedBufferGeometry&&(p=ye.get("ANGLE_instanced_arrays"),null===p))console.error("THREE.WebGLRenderer.setupVertexAttributes: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");else{void 0===s&&(s=0),xe.initAttributes();var d,l=i.attributes,a=a.getAttributes(),u=r.defaultAttributeValues;for(d in a){var f=a[d];if(f>=0){var E=l[d];if(void 0!==E){var T=ge.FLOAT,v=E.array,y=E.normalized;v instanceof Float32Array?T=ge.FLOAT:v instanceof Float64Array?console.warn("Unsupported data buffer format: Float64Array"):v instanceof Uint16Array?T=ge.UNSIGNED_SHORT:v instanceof Int16Array?T=ge.SHORT:v instanceof Uint32Array?T=ge.UNSIGNED_INT:v instanceof Int32Array?T=ge.INT:v instanceof Int8Array?T=ge.BYTE:v instanceof Uint8Array&&(T=ge.UNSIGNED_BYTE);var v=E.itemSize,R=be.getAttributeBuffer(E);if(E instanceof THREE.InterleavedBufferAttribute){var x=E.data,H=x.stride,E=E.offset;x instanceof THREE.InstancedInterleavedBuffer?(xe.enableAttributeAndDivisor(f,x.meshPerAttribute,p),void 0===i.maxInstancedCount&&(i.maxInstancedCount=x.meshPerAttribute*x.count)):xe.enableAttribute(f),ge.bindBuffer(ge.ARRAY_BUFFER,R),ge.vertexAttribPointer(f,v,T,y,H*x.array.BYTES_PER_ELEMENT,(s*H+E)*x.array.BYTES_PER_ELEMENT)}else E instanceof THREE.InstancedBufferAttribute?(xe.enableAttributeAndDivisor(f,E.meshPerAttribute,p),void 0===i.maxInstancedCount&&(i.maxInstancedCount=E.meshPerAttribute*E.count)):xe.enableAttribute(f),ge.bindBuffer(ge.ARRAY_BUFFER,R),ge.vertexAttribPointer(f,v,T,y,0,s*v*E.array.BYTES_PER_ELEMENT)}else if(void 0!==u&&(T=u[d],void 0!==T))switch(T.length){case 2:ge.vertexAttrib2fv(f,T);break;case 3:ge.vertexAttrib3fv(f,T);break;case 4:ge.vertexAttrib4fv(f,T);break;default:ge.vertexAttrib1fv(f,T)}}}xe.disableUnusedAttributes()}null!==t&&ge.bindBuffer(ge.ELEMENT_ARRAY_BUFFER,be.getAttributeBuffer(t))}if(p=1/0,null!==t?p=t.count:void 0!==c&&(p=c.count),d=i.drawRange.start,t=i.drawRange.count,c=null!==o?o.start:0,s=null!==o?o.count:1/0,o=Math.max(0,d,c),p=Math.min(0+p,d+t,c+s)-1,p=Math.max(0,p-o+1),n instanceof THREE.Mesh)if(!0===r.wireframe)xe.setLineWidth(r.wireframeLinewidth*(null===j?re:1)),e.setMode(ge.LINES);else switch(n.drawMode){case THREE.TrianglesDrawMode:e.setMode(ge.TRIANGLES);break;case THREE.TriangleStripDrawMode:e.setMode(ge.TRIANGLE_STRIP);break;case THREE.TriangleFanDrawMode:e.setMode(ge.TRIANGLE_FAN)}else n instanceof THREE.Line?(r=r.linewidth,void 0===r&&(r=1),xe.setLineWidth(r*(null===j?re:1)),n instanceof THREE.LineSegments?e.setMode(ge.LINES):e.setMode(ge.LINE_STRIP)):n instanceof THREE.Points&&e.setMode(ge.POINTS);i instanceof THREE.InstancedBufferGeometry?0<i.maxInstancedCount&&e.renderInstances(i,o,p):e.render(o,p)},this.render=function(e,t,i,r){if(!1==t instanceof THREE.Camera)console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.");else{var n=e.fog;Y="",X=-1,q=null,!0===e.autoUpdate&&e.updateMatrixWorld(),null===t.parent&&t.updateMatrixWorld(),t.matrixWorldInverse.getInverse(t.matrixWorld),pe.multiplyMatrices(t.projectionMatrix,t.matrixWorldInverse),se.setFromMatrix(pe),U.length=0,F=I=-1,V.length=0,G.length=0,le=this.localClippingEnabled,he=ce.init(this.clippingPlanes,le,t),f(e,t),D.length=I+1,O.length=F+1,!0===z.sortObjects&&(D.sort(l),O.sort(u)),he&&ce.beginShadows();for(var o=U,a=0,s=0,c=o.length;c>s;s++){var h=o[s];h.castShadow&&(fe.shadows[a++]=h)}fe.shadows.length=a,Le.render(e,t);for(var p,d,m,g,o=U,T=h=0,v=0,y=t.matrixWorldInverse,x=0,H=0,b=0,_=0,a=0,s=o.length;s>a;a++)if(c=o[a],p=c.color,d=c.intensity,m=c.distance,g=c.shadow&&c.shadow.map?c.shadow.map.texture:null,c instanceof THREE.AmbientLight)h+=p.r*d,T+=p.g*d,v+=p.b*d;else if(c instanceof THREE.DirectionalLight){var M=Me.get(c);M.color.copy(c.color).multiplyScalar(c.intensity),M.direction.setFromMatrixPosition(c.matrixWorld),de.setFromMatrixPosition(c.target.matrixWorld),M.direction.sub(de),M.direction.transformDirection(y),(M.shadow=c.castShadow)&&(M.shadowBias=c.shadow.bias,M.shadowRadius=c.shadow.radius,M.shadowMapSize=c.shadow.mapSize),fe.directionalShadowMap[x]=g,fe.directionalShadowMatrix[x]=c.shadow.matrix,fe.directional[x++]=M}else c instanceof THREE.SpotLight?(M=Me.get(c),M.position.setFromMatrixPosition(c.matrixWorld),M.position.applyMatrix4(y),M.color.copy(p).multiplyScalar(d),M.distance=m,M.direction.setFromMatrixPosition(c.matrixWorld),de.setFromMatrixPosition(c.target.matrixWorld),M.direction.sub(de),M.direction.transformDirection(y),M.coneCos=Math.cos(c.angle),M.penumbraCos=Math.cos(c.angle*(1-c.penumbra)),M.decay=0===c.distance?0:c.decay,(M.shadow=c.castShadow)&&(M.shadowBias=c.shadow.bias,M.shadowRadius=c.shadow.radius,M.shadowMapSize=c.shadow.mapSize),fe.spotShadowMap[b]=g,fe.spotShadowMatrix[b]=c.shadow.matrix,fe.spot[b++]=M):c instanceof THREE.PointLight?(M=Me.get(c),M.position.setFromMatrixPosition(c.matrixWorld),M.position.applyMatrix4(y),M.color.copy(c.color).multiplyScalar(c.intensity),M.distance=c.distance,M.decay=0===c.distance?0:c.decay,(M.shadow=c.castShadow)&&(M.shadowBias=c.shadow.bias,M.shadowRadius=c.shadow.radius,M.shadowMapSize=c.shadow.mapSize),fe.pointShadowMap[H]=g,void 0===fe.pointShadowMatrix[H]&&(fe.pointShadowMatrix[H]=new THREE.Matrix4),de.setFromMatrixPosition(c.matrixWorld).negate(),fe.pointShadowMatrix[H].identity().setPosition(de),fe.point[H++]=M):c instanceof THREE.HemisphereLight&&(M=Me.get(c),M.direction.setFromMatrixPosition(c.matrixWorld),M.direction.transformDirection(y),M.direction.normalize(),M.skyColor.copy(c.color).multiplyScalar(d),M.groundColor.copy(c.groundColor).multiplyScalar(d),fe.hemi[_++]=M);fe.ambient[0]=h,fe.ambient[1]=T,fe.ambient[2]=v,fe.directional.length=x,fe.spot.length=b,fe.point.length=H,fe.hemi.length=_,fe.hash=x+","+H+","+b+","+_+","+fe.shadows.length,he&&ce.endShadows(),me.calls=0,me.vertices=0,me.faces=0,me.points=0,void 0===i&&(i=null),this.setRenderTarget(i),(this.autoClear||r)&&this.clear(this.autoClearColor,this.autoClearDepth,this.autoClearStencil),e.overrideMaterial?(r=e.overrideMaterial,E(D,t,n,r),E(O,t,n,r)):(xe.setBlending(THREE.NoBlending),E(D,t,n),E(O,t,n)),Ae.render(e,t),Ce.render(e,t,Q),i&&(e=i.texture,e.generateMipmaps&&R(i)&&e.minFilter!==THREE.NearestFilter&&e.minFilter!==THREE.LinearFilter&&(e=i instanceof THREE.WebGLRenderTargetCube?ge.TEXTURE_CUBE_MAP:ge.TEXTURE_2D,i=He.get(i.texture).__webglTexture,xe.bindTexture(e,i),ge.generateMipmap(e),xe.bindTexture(e,null))),xe.setDepthTest(!0),xe.setDepthWrite(!0),xe.setColorWrite(!0)}},this.setFaceCulling=function(e,t){xe.setCullFace(e),xe.setFlipSided(t===THREE.FrontFaceDirectionCW)},this.allocTextureUnit=function(){var e=J;return e>=Re.maxTextures&&console.warn("WebGLRenderer: trying to use "+e+" texture units while this GPU supports only "+Re.maxTextures),J+=1,e},this.setTexture2D=function(){var e=!1;return function(t,i){t instanceof THREE.WebGLRenderTarget&&(e||(console.warn("THREE.WebGLRenderer.setTexture2D: don't use render targets as textures. Use their .texture property instead."),e=!0),t=t.texture);var r=t,n=He.get(r);if(0<r.version&&n.__version!==r.version){var a=r.image;if(void 0===a)console.warn("THREE.WebGLRenderer: Texture marked for update but image is undefined",r);else if(!1===a.complete)console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete",r);else{void 0===n.__webglInit&&(n.__webglInit=!0,r.addEventListener("dispose",o),n.__webglTexture=ge.createTexture(),Ee.textures++),xe.activeTexture(ge.TEXTURE0+i),xe.bindTexture(ge.TEXTURE_2D,n.__webglTexture),ge.pixelStorei(ge.UNPACK_FLIP_Y_WEBGL,r.flipY),ge.pixelStorei(ge.UNPACK_PREMULTIPLY_ALPHA_WEBGL,r.premultiplyAlpha),ge.pixelStorei(ge.UNPACK_ALIGNMENT,r.unpackAlignment);var s=y(r.image,Re.maxTextureSize);if((r.wrapS!==THREE.ClampToEdgeWrapping||r.wrapT!==THREE.ClampToEdgeWrapping||r.minFilter!==THREE.NearestFilter&&r.minFilter!==THREE.LinearFilter)&&!1===R(s))if(a=s,a instanceof HTMLImageElement||a instanceof HTMLCanvasElement){var c=document.createElement("canvas");c.width=THREE.Math.nearestPowerOfTwo(a.width),c.height=THREE.Math.nearestPowerOfTwo(a.height),
c.getContext("2d").drawImage(a,0,0,c.width,c.height),console.warn("THREE.WebGLRenderer: image is not power of two ("+a.width+"x"+a.height+"). Resized to "+c.width+"x"+c.height,a),s=c}else s=a;var a=R(s),c=_(r.format),h=_(r.type);v(ge.TEXTURE_2D,r,a);var l=r.mipmaps;if(r instanceof THREE.DepthTexture){if(l=ge.DEPTH_COMPONENT,r.type===THREE.FloatType){if(!ve)throw Error("Float Depth Texture only supported in WebGL2.0");l=ge.DEPTH_COMPONENT32F}else ve&&(l=ge.DEPTH_COMPONENT16);xe.texImage2D(ge.TEXTURE_2D,0,l,s.width,s.height,0,c,h,null)}else if(r instanceof THREE.DataTexture)if(0<l.length&&a){for(var u=0,p=l.length;p>u;u++)s=l[u],xe.texImage2D(ge.TEXTURE_2D,u,c,s.width,s.height,0,c,h,s.data);r.generateMipmaps=!1}else xe.texImage2D(ge.TEXTURE_2D,0,c,s.width,s.height,0,c,h,s.data);else if(r instanceof THREE.CompressedTexture)for(u=0,p=l.length;p>u;u++)s=l[u],r.format!==THREE.RGBAFormat&&r.format!==THREE.RGBFormat?-1<xe.getCompressedTextureFormats().indexOf(c)?xe.compressedTexImage2D(ge.TEXTURE_2D,u,c,s.width,s.height,0,s.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):xe.texImage2D(ge.TEXTURE_2D,u,c,s.width,s.height,0,c,h,s.data);else if(0<l.length&&a){for(u=0,p=l.length;p>u;u++)s=l[u],xe.texImage2D(ge.TEXTURE_2D,u,c,c,h,s);r.generateMipmaps=!1}else xe.texImage2D(ge.TEXTURE_2D,0,c,c,h,s);r.generateMipmaps&&a&&ge.generateMipmap(ge.TEXTURE_2D),n.__version=r.version,r.onUpdate&&r.onUpdate(r)}}else xe.activeTexture(ge.TEXTURE0+i),xe.bindTexture(ge.TEXTURE_2D,n.__webglTexture)}}(),this.setTexture=function(){var e=!1;return function(t,i){e||(console.warn("THREE.WebGLRenderer: .setTexture is deprecated, use setTexture2D instead."),e=!0),z.setTexture2D(t,i)}}(),this.setTextureCube=function(){var e=!1;return function(t,i){if(t instanceof THREE.WebGLRenderTargetCube&&(e||(console.warn("THREE.WebGLRenderer.setTextureCube: don't use cube render targets as textures. Use their .texture property instead."),e=!0),t=t.texture),t instanceof THREE.CubeTexture||Array.isArray(t.image)&&6===t.image.length){var r=t,n=He.get(r);if(6===r.image.length)if(0<r.version&&n.__version!==r.version){n.__image__webglTextureCube||(r.addEventListener("dispose",o),n.__image__webglTextureCube=ge.createTexture(),Ee.textures++),xe.activeTexture(ge.TEXTURE0+i),xe.bindTexture(ge.TEXTURE_CUBE_MAP,n.__image__webglTextureCube),ge.pixelStorei(ge.UNPACK_FLIP_Y_WEBGL,r.flipY);for(var a=r instanceof THREE.CompressedTexture,s=r.image[0]instanceof THREE.DataTexture,c=[],h=0;6>h;h++)c[h]=!z.autoScaleCubemaps||a||s?s?r.image[h].image:r.image[h]:y(r.image[h],Re.maxCubemapSize);var l=R(c[0]),u=_(r.format),p=_(r.type);for(v(ge.TEXTURE_CUBE_MAP,r,l),h=0;6>h;h++)if(a)for(var d,f=c[h].mipmaps,E=0,m=f.length;m>E;E++)d=f[E],r.format!==THREE.RGBAFormat&&r.format!==THREE.RGBFormat?-1<xe.getCompressedTextureFormats().indexOf(u)?xe.compressedTexImage2D(ge.TEXTURE_CUBE_MAP_POSITIVE_X+h,E,u,d.width,d.height,0,d.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()"):xe.texImage2D(ge.TEXTURE_CUBE_MAP_POSITIVE_X+h,E,u,d.width,d.height,0,u,p,d.data);else s?xe.texImage2D(ge.TEXTURE_CUBE_MAP_POSITIVE_X+h,0,u,c[h].width,c[h].height,0,u,p,c[h].data):xe.texImage2D(ge.TEXTURE_CUBE_MAP_POSITIVE_X+h,0,u,u,p,c[h]);r.generateMipmaps&&l&&ge.generateMipmap(ge.TEXTURE_CUBE_MAP),n.__version=r.version,r.onUpdate&&r.onUpdate(r)}else xe.activeTexture(ge.TEXTURE0+i),xe.bindTexture(ge.TEXTURE_CUBE_MAP,n.__image__webglTextureCube)}else r=t,xe.activeTexture(ge.TEXTURE0+i),xe.bindTexture(ge.TEXTURE_CUBE_MAP,He.get(r).__webglTexture)}}(),this.getCurrentRenderTarget=function(){return j},this.setRenderTarget=function(e){if((j=e)&&void 0===He.get(e).__webglFramebuffer){var t=He.get(e),i=He.get(e.texture);e.addEventListener("dispose",a),i.__webglTexture=ge.createTexture(),Ee.textures++;var r=e instanceof THREE.WebGLRenderTargetCube,n=THREE.Math.isPowerOfTwo(e.width)&&THREE.Math.isPowerOfTwo(e.height);if(r){t.__webglFramebuffer=[];for(var o=0;6>o;o++)t.__webglFramebuffer[o]=ge.createFramebuffer()}else t.__webglFramebuffer=ge.createFramebuffer();if(r){for(xe.bindTexture(ge.TEXTURE_CUBE_MAP,i.__webglTexture),v(ge.TEXTURE_CUBE_MAP,e.texture,n),o=0;6>o;o++)x(t.__webglFramebuffer[o],e,ge.COLOR_ATTACHMENT0,ge.TEXTURE_CUBE_MAP_POSITIVE_X+o);e.texture.generateMipmaps&&n&&ge.generateMipmap(ge.TEXTURE_CUBE_MAP),xe.bindTexture(ge.TEXTURE_CUBE_MAP,null)}else xe.bindTexture(ge.TEXTURE_2D,i.__webglTexture),v(ge.TEXTURE_2D,e.texture,n),x(t.__webglFramebuffer,e,ge.COLOR_ATTACHMENT0,ge.TEXTURE_2D),e.texture.generateMipmaps&&n&&ge.generateMipmap(ge.TEXTURE_2D),xe.bindTexture(ge.TEXTURE_2D,null);if(e.depthBuffer){if(t=He.get(e),i=e instanceof THREE.WebGLRenderTargetCube,e.depthTexture){if(i)throw Error("target.depthTexture not supported in Cube render targets");if(e instanceof THREE.WebGLRenderTargetCube)throw Error("Depth Texture with cube render targets is not supported!");if(ge.bindFramebuffer(ge.FRAMEBUFFER,t.__webglFramebuffer),!(e.depthTexture instanceof THREE.DepthTexture))throw Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");He.get(e.depthTexture).__webglTexture&&e.depthTexture.image.width===e.width&&e.depthTexture.image.height===e.height||(e.depthTexture.image.width=e.width,e.depthTexture.image.height=e.height,e.depthTexture.needsUpdate=!0),z.setTexture2D(e.depthTexture,0),t=He.get(e.depthTexture).__webglTexture,ge.framebufferTexture2D(ge.FRAMEBUFFER,ge.DEPTH_ATTACHMENT,ge.TEXTURE_2D,t,0)}else if(i)for(t.__webglDepthbuffer=[],i=0;6>i;i++)ge.bindFramebuffer(ge.FRAMEBUFFER,t.__webglFramebuffer[i]),t.__webglDepthbuffer[i]=ge.createRenderbuffer(),H(t.__webglDepthbuffer[i],e);else ge.bindFramebuffer(ge.FRAMEBUFFER,t.__webglFramebuffer),t.__webglDepthbuffer=ge.createRenderbuffer(),H(t.__webglDepthbuffer,e);ge.bindFramebuffer(ge.FRAMEBUFFER,null)}}t=e instanceof THREE.WebGLRenderTargetCube,e?(i=He.get(e),i=t?i.__webglFramebuffer[e.activeCubeFace]:i.__webglFramebuffer,Z.copy(e.scissor),K=e.scissorTest,Q.copy(e.viewport)):(i=null,Z.copy(ne).multiplyScalar(re),K=oe,Q.copy(ae).multiplyScalar(re)),W!==i&&(ge.bindFramebuffer(ge.FRAMEBUFFER,i),W=i),xe.scissor(Z),xe.setScissorTest(K),xe.viewport(Q),t&&(t=He.get(e.texture),ge.framebufferTexture2D(ge.FRAMEBUFFER,ge.COLOR_ATTACHMENT0,ge.TEXTURE_CUBE_MAP_POSITIVE_X+e.activeCubeFace,t.__webglTexture,e.activeMipMapLevel))},this.readRenderTargetPixels=function(e,t,i,r,n,o){if(!1==e instanceof THREE.WebGLRenderTarget)console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");else{var a=He.get(e).__webglFramebuffer;if(a){var s=!1;a!==W&&(ge.bindFramebuffer(ge.FRAMEBUFFER,a),s=!0);try{var c=e.texture;c.format!==THREE.RGBAFormat&&_(c.format)!==ge.getParameter(ge.IMPLEMENTATION_COLOR_READ_FORMAT)?console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format."):c.type===THREE.UnsignedByteType||_(c.type)===ge.getParameter(ge.IMPLEMENTATION_COLOR_READ_TYPE)||c.type===THREE.FloatType&&ye.get("WEBGL_color_buffer_float")||c.type===THREE.HalfFloatType&&ye.get("EXT_color_buffer_half_float")?ge.checkFramebufferStatus(ge.FRAMEBUFFER)===ge.FRAMEBUFFER_COMPLETE?t>=0&&t<=e.width-r&&i>=0&&i<=e.height-n&&ge.readPixels(t,i,r,n,_(c.format),_(c.type),o):console.error("THREE.WebGLRenderer.readRenderTargetPixels: readPixels from renderTarget failed. Framebuffer not complete."):console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.")}finally{s&&ge.bindFramebuffer(ge.FRAMEBUFFER,W)}}}}},THREE.WebGLRenderTarget=function(e,t,i){this.uuid=THREE.Math.generateUUID(),this.width=e,this.height=t,this.scissor=new THREE.Vector4(0,0,e,t),this.scissorTest=!1,this.viewport=new THREE.Vector4(0,0,e,t),i=i||{},void 0===i.minFilter&&(i.minFilter=THREE.LinearFilter),this.texture=new THREE.Texture(void 0,void 0,i.wrapS,i.wrapT,i.magFilter,i.minFilter,i.format,i.type,i.anisotropy,i.encoding),this.depthBuffer=void 0!==i.depthBuffer?i.depthBuffer:!0,this.stencilBuffer=void 0!==i.stencilBuffer?i.stencilBuffer:!0,this.depthTexture=null},Object.assign(THREE.WebGLRenderTarget.prototype,THREE.EventDispatcher.prototype,{setSize:function(e,t){this.width===e&&this.height===t||(this.width=e,this.height=t,this.dispose()),this.viewport.set(0,0,e,t),this.scissor.set(0,0,e,t)},clone:function(){return(new this.constructor).copy(this)},copy:function(e){return this.width=e.width,this.height=e.height,this.viewport.copy(e.viewport),this.texture=e.texture.clone(),this.depthBuffer=e.depthBuffer,this.stencilBuffer=e.stencilBuffer,this.depthTexture=e.depthTexture,this},dispose:function(){this.dispatchEvent({type:"dispose"})}}),THREE.WebGLRenderTargetCube=function(e,t,i){THREE.WebGLRenderTarget.call(this,e,t,i),this.activeMipMapLevel=this.activeCubeFace=0},THREE.WebGLRenderTargetCube.prototype=Object.create(THREE.WebGLRenderTarget.prototype),THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube,THREE.WebGLBufferRenderer=function(e,t,i){var r;this.setMode=function(e){r=e},this.render=function(t,n){e.drawArrays(r,t,n),i.calls++,i.vertices+=n,r===e.TRIANGLES&&(i.faces+=n/3)},this.renderInstances=function(n){var o=t.get("ANGLE_instanced_arrays");if(null===o)console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");else{var a=n.attributes.position,s=0,s=a instanceof THREE.InterleavedBufferAttribute?a.data.count:a.count;o.drawArraysInstancedANGLE(r,0,s,n.maxInstancedCount),i.calls++,i.vertices+=s*n.maxInstancedCount,r===e.TRIANGLES&&(i.faces+=n.maxInstancedCount*s/3)}}},THREE.WebGLClipping=function(){function e(){h.value!==r&&(h.value=r,h.needsUpdate=n>0),i.numPlanes=n}function t(e,t,r,n){var o=null!==e?e.length:0,a=null;if(0!==o){if(a=h.value,!0!==n||null===a)for(n=r+4*o,t=t.matrixWorldInverse,c.getNormalMatrix(t),(null===a||a.length<n)&&(a=new Float32Array(n)),n=0;n!==o;++n,r+=4)s.copy(e[n]).applyMatrix4(t,c),s.normal.toArray(a,r),a[r+3]=s.constant;h.value=a,h.needsUpdate=!0}return i.numPlanes=o,a}var i=this,r=null,n=0,o=!1,a=!1,s=new THREE.Plane,c=new THREE.Matrix3,h={value:null,needsUpdate:!1};this.uniform=h,this.numPlanes=0,this.init=function(e,i,a){var s=0!==e.length||i||0!==n||o;return o=i,r=t(e,a,0),n=e.length,s},this.beginShadows=function(){a=!0,t(null)},this.endShadows=function(){a=!1,e()},this.setState=function(i,s,c,l,u){if(!o||null===i||0===i.length||a&&!s)a?t(null):e();else{s=a?0:n;var p=4*s,d=l.clippingState||null;for(h.value=d,d=t(i,c,p,u),i=0;i!==p;++i)d[i]=r[i];l.clippingState=d,this.numPlanes+=s}}},THREE.WebGLIndexedBufferRenderer=function(e,t,i){var r,n,o;this.setMode=function(e){r=e},this.setIndex=function(i){i.array instanceof Uint32Array&&t.get("OES_element_index_uint")?(n=e.UNSIGNED_INT,o=4):(n=e.UNSIGNED_SHORT,o=2)},this.render=function(t,a){e.drawElements(r,a,n,t*o),i.calls++,i.vertices+=a,r===e.TRIANGLES&&(i.faces+=a/3)},this.renderInstances=function(a,s,c){var h=t.get("ANGLE_instanced_arrays");null===h?console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays."):(h.drawElementsInstancedANGLE(r,c,n,s*o,a.maxInstancedCount),i.calls++,i.vertices+=c*a.maxInstancedCount,r===e.TRIANGLES&&(i.faces+=a.maxInstancedCount*c/3))}},THREE.WebGLExtensions=function(e){var t={};this.get=function(i){if(void 0!==t[i])return t[i];var r;switch(i){case"WEBGL_depth_texture":r=e.getExtension("WEBGL_depth_texture")||e.getExtension("MOZ_WEBGL_depth_texture")||e.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":r=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":r=e.getExtension("WEBGL_compressed_texture_s3tc")||e.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||e.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":r=e.getExtension("WEBGL_compressed_texture_pvrtc")||e.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;case"WEBGL_compressed_texture_etc1":r=e.getExtension("WEBGL_compressed_texture_etc1");break;default:r=e.getExtension(i)}return null===r&&console.warn("THREE.WebGLRenderer: "+i+" extension not supported."),t[i]=r}},THREE.WebGLCapabilities=function(e,t,i){function r(t){if("highp"===t){if(0<e.getShaderPrecisionFormat(e.VERTEX_SHADER,e.HIGH_FLOAT).precision&&0<e.getShaderPrecisionFormat(e.FRAGMENT_SHADER,e.HIGH_FLOAT).precision)return"highp";t="mediump"}return"mediump"===t&&0<e.getShaderPrecisionFormat(e.VERTEX_SHADER,e.MEDIUM_FLOAT).precision&&0<e.getShaderPrecisionFormat(e.FRAGMENT_SHADER,e.MEDIUM_FLOAT).precision?"mediump":"lowp"}this.getMaxPrecision=r,this.precision=void 0!==i.precision?i.precision:"highp",this.logarithmicDepthBuffer=void 0!==i.logarithmicDepthBuffer?i.logarithmicDepthBuffer:!1,this.maxTextures=e.getParameter(e.MAX_TEXTURE_IMAGE_UNITS),this.maxVertexTextures=e.getParameter(e.MAX_VERTEX_TEXTURE_IMAGE_UNITS),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),this.maxCubemapSize=e.getParameter(e.MAX_CUBE_MAP_TEXTURE_SIZE),this.maxAttributes=e.getParameter(e.MAX_VERTEX_ATTRIBS),this.maxVertexUniforms=e.getParameter(e.MAX_VERTEX_UNIFORM_VECTORS),this.maxVaryings=e.getParameter(e.MAX_VARYING_VECTORS),this.maxFragmentUniforms=e.getParameter(e.MAX_FRAGMENT_UNIFORM_VECTORS),this.vertexTextures=0<this.maxVertexTextures,this.floatFragmentTextures=!!t.get("OES_texture_float"),this.floatVertexTextures=this.vertexTextures&&this.floatFragmentTextures,i=r(this.precision),i!==this.precision&&(console.warn("THREE.WebGLRenderer:",this.precision,"not supported, using",i,"instead."),this.precision=i),this.logarithmicDepthBuffer&&(this.logarithmicDepthBuffer=!!t.get("EXT_frag_depth"))},THREE.WebGLGeometries=function(e,t,i){function r(e){var a=e.target;e=o[a.id],null!==e.index&&n(e.index);var s,c=e.attributes;for(s in c)n(c[s]);a.removeEventListener("dispose",r),delete o[a.id],s=t.get(a),s.wireframe&&n(s.wireframe),t["delete"](a),a=t.get(e),a.wireframe&&n(a.wireframe),t["delete"](e),i.memory.geometries--}function n(i){var r;r=i instanceof THREE.InterleavedBufferAttribute?t.get(i.data).__webglBuffer:t.get(i).__webglBuffer,void 0!==r&&(e.deleteBuffer(r),i instanceof THREE.InterleavedBufferAttribute?t["delete"](i.data):t["delete"](i))}var o={};this.get=function(e){var t=e.geometry;if(void 0!==o[t.id])return o[t.id];t.addEventListener("dispose",r);var n;return t instanceof THREE.BufferGeometry?n=t:t instanceof THREE.Geometry&&(void 0===t._bufferGeometry&&(t._bufferGeometry=(new THREE.BufferGeometry).setFromObject(e)),n=t._bufferGeometry),o[t.id]=n,i.memory.geometries++,n}},THREE.WebGLLights=function(){var e={};this.get=function(t){if(void 0!==e[t.id])return e[t.id];var i;switch(t.type){case"DirectionalLight":i={direction:new THREE.Vector3,color:new THREE.Color,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new THREE.Vector2};break;case"SpotLight":i={position:new THREE.Vector3,direction:new THREE.Vector3,color:new THREE.Color,distance:0,coneCos:0,penumbraCos:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new THREE.Vector2};break;case"PointLight":i={position:new THREE.Vector3,color:new THREE.Color,distance:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new THREE.Vector2};break;case"HemisphereLight":i={direction:new THREE.Vector3,skyColor:new THREE.Color,groundColor:new THREE.Color}}return e[t.id]=i}},THREE.WebGLObjects=function(e,t,i){function r(i,r){var n=i instanceof THREE.InterleavedBufferAttribute?i.data:i,o=t.get(n);void 0===o.__webglBuffer?(o.__webglBuffer=e.createBuffer(),e.bindBuffer(r,o.__webglBuffer),e.bufferData(r,n.array,n.dynamic?e.DYNAMIC_DRAW:e.STATIC_DRAW),o.version=n.version):o.version!==n.version&&(e.bindBuffer(r,o.__webglBuffer),!1===n.dynamic||-1===n.updateRange.count?e.bufferSubData(r,0,n.array):0===n.updateRange.count?console.error("THREE.WebGLObjects.updateBuffer: dynamic THREE.BufferAttribute marked as needsUpdate but updateRange.count is 0, ensure you are using set methods or updating manually."):(e.bufferSubData(r,n.updateRange.offset*n.array.BYTES_PER_ELEMENT,n.array.subarray(n.updateRange.offset,n.updateRange.offset+n.updateRange.count)),n.updateRange.count=0),o.version=n.version)}function n(e,t,i){if(t>i){var r=t;t=i,i=r}return r=e[t],void 0===r?(e[t]=[i],!0):-1===r.indexOf(i)?(r.push(i),!0):!1}var o=new THREE.WebGLGeometries(e,t,i);this.getAttributeBuffer=function(e){return e instanceof THREE.InterleavedBufferAttribute?t.get(e.data).__webglBuffer:t.get(e).__webglBuffer},this.getWireframeAttribute=function(i){var o=t.get(i);if(void 0!==o.wireframe)return o.wireframe;var a=[],s=i.index,c=i.attributes;if(i=c.position,null!==s)for(var c={},s=s.array,h=0,l=s.length;l>h;h+=3){var u=s[h+0],p=s[h+1],d=s[h+2];n(c,u,p)&&a.push(u,p),n(c,p,d)&&a.push(p,d),n(c,d,u)&&a.push(d,u)}else for(s=c.position.array,h=0,l=s.length/3-1;l>h;h+=3)u=h+0,p=h+1,d=h+2,a.push(u,p,p,d,d,u);return a=new THREE.BufferAttribute(new(65535<i.count?Uint32Array:Uint16Array)(a),1),r(a,e.ELEMENT_ARRAY_BUFFER),o.wireframe=a},this.update=function(t){var i=o.get(t);t.geometry instanceof THREE.Geometry&&i.updateFromObject(t),t=i.index;var n=i.attributes;null!==t&&r(t,e.ELEMENT_ARRAY_BUFFER);for(var a in n)r(n[a],e.ARRAY_BUFFER);t=i.morphAttributes;for(a in t)for(var n=t[a],s=0,c=n.length;c>s;s++)r(n[s],e.ARRAY_BUFFER);return i}},THREE.WebGLProgram=function(){function e(e){switch(e){case THREE.LinearEncoding:return["Linear","( value )"];case THREE.sRGBEncoding:return["sRGB","( value )"];case THREE.RGBEEncoding:return["RGBE","( value )"];case THREE.RGBM7Encoding:return["RGBM","( value, 7.0 )"];case THREE.RGBM16Encoding:return["RGBM","( value, 16.0 )"];case THREE.RGBDEncoding:return["RGBD","( value, 256.0 )"];case THREE.GammaEncoding:return["Gamma","( value, float( GAMMA_FACTOR ) )"];default:throw Error("unsupported encoding: "+e)}}function t(t,i){var r=e(i);return"vec4 "+t+"( vec4 value ) { return "+r[0]+"ToLinear"+r[1]+"; }"}function i(t,i){var r=e(i);return"vec4 "+t+"( vec4 value ) { return LinearTo"+r[0]+r[1]+"; }"}function r(e,t){var i;switch(t){case THREE.LinearToneMapping:i="Linear";break;case THREE.ReinhardToneMapping:i="Reinhard";break;case THREE.Uncharted2ToneMapping:i="Uncharted2";break;case THREE.CineonToneMapping:i="OptimizedCineon";break;default:throw Error("unsupported toneMapping: "+t)}return"vec3 "+e+"( vec3 color ) { return "+i+"ToneMapping( color ); }"}function n(e,t,i){return e=e||{},[e.derivatives||t.envMapCubeUV||t.bumpMap||t.normalMap||t.flatShading?"#extension GL_OES_standard_derivatives : enable":"",(e.fragDepth||t.logarithmicDepthBuffer)&&i.get("EXT_frag_depth")?"#extension GL_EXT_frag_depth : enable":"",e.drawBuffers&&i.get("WEBGL_draw_buffers")?"#extension GL_EXT_draw_buffers : require":"",(e.shaderTextureLOD||t.envMap)&&i.get("EXT_shader_texture_lod")?"#extension GL_EXT_shader_texture_lod : enable":""].filter(a).join("\n")}function o(e){var t,i=[];for(t in e){var r=e[t];!1!==r&&i.push("#define "+t+" "+r)}return i.join("\n")}function a(e){return""!==e}function s(e,t){return e.replace(/NUM_DIR_LIGHTS/g,t.numDirLights).replace(/NUM_SPOT_LIGHTS/g,t.numSpotLights).replace(/NUM_POINT_LIGHTS/g,t.numPointLights).replace(/NUM_HEMI_LIGHTS/g,t.numHemiLights)}function c(e){return e.replace(/#include +<([\w\d.]+)>/g,function(e,t){var i=THREE.ShaderChunk[t];if(void 0===i)throw Error("Can not resolve #include <"+t+">");return c(i)})}function h(e){return e.replace(/for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g,function(e,t,i,r){for(e="",t=parseInt(t);t<parseInt(i);t++)e+=r.replace(/\[ i \]/g,"[ "+t+" ]");return e})}var l=0;return function(e,u,p,d){var f=e.context,E=p.extensions,m=p.defines,g=p.__webglShader.vertexShader,T=p.__webglShader.fragmentShader,v="SHADOWMAP_TYPE_BASIC";d.shadowMapType===THREE.PCFShadowMap?v="SHADOWMAP_TYPE_PCF":d.shadowMapType===THREE.PCFSoftShadowMap&&(v="SHADOWMAP_TYPE_PCF_SOFT");var y="ENVMAP_TYPE_CUBE",R="ENVMAP_MODE_REFLECTION",x="ENVMAP_BLENDING_MULTIPLY";if(d.envMap){switch(p.envMap.mapping){case THREE.CubeReflectionMapping:case THREE.CubeRefractionMapping:y="ENVMAP_TYPE_CUBE";break;case THREE.CubeUVReflectionMapping:case THREE.CubeUVRefractionMapping:y="ENVMAP_TYPE_CUBE_UV";break;case THREE.EquirectangularReflectionMapping:case THREE.EquirectangularRefractionMapping:y="ENVMAP_TYPE_EQUIREC";break;case THREE.SphericalReflectionMapping:y="ENVMAP_TYPE_SPHERE"}switch(p.envMap.mapping){case THREE.CubeRefractionMapping:case THREE.EquirectangularRefractionMapping:R="ENVMAP_MODE_REFRACTION"}switch(p.combine){case THREE.MultiplyOperation:x="ENVMAP_BLENDING_MULTIPLY";break;case THREE.MixOperation:x="ENVMAP_BLENDING_MIX";break;case THREE.AddOperation:x="ENVMAP_BLENDING_ADD"}}var H=0<e.gammaFactor?e.gammaFactor:1,E=n(E,d,e.extensions),b=o(m),_=f.createProgram();p instanceof THREE.RawShaderMaterial?v=m="":(m=["precision "+d.precision+" float;","precision "+d.precision+" int;","#define SHADER_NAME "+p.__webglShader.name,b,d.supportsVertexTextures?"#define VERTEX_TEXTURES":"","#define GAMMA_FACTOR "+H,"#define MAX_BONES "+d.maxBones,d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.envMap?"#define "+R:"",d.lightMap?"#define USE_LIGHTMAP":"",d.aoMap?"#define USE_AOMAP":"",d.emissiveMap?"#define USE_EMISSIVEMAP":"",d.bumpMap?"#define USE_BUMPMAP":"",d.normalMap?"#define USE_NORMALMAP":"",d.displacementMap&&d.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",d.specularMap?"#define USE_SPECULARMAP":"",d.roughnessMap?"#define USE_ROUGHNESSMAP":"",d.metalnessMap?"#define USE_METALNESSMAP":"",d.alphaMap?"#define USE_ALPHAMAP":"",d.vertexColors?"#define USE_COLOR":"",d.flatShading?"#define FLAT_SHADED":"",d.skinning?"#define USE_SKINNING":"",d.useVertexTexture?"#define BONE_TEXTURE":"",d.morphTargets?"#define USE_MORPHTARGETS":"",d.morphNormals&&!1===d.flatShading?"#define USE_MORPHNORMALS":"",d.doubleSided?"#define DOUBLE_SIDED":"",d.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+d.numClippingPlanes,d.shadowMapEnabled?"#define USE_SHADOWMAP":"",d.shadowMapEnabled?"#define "+v:"",d.sizeAttenuation?"#define USE_SIZEATTENUATION":"",d.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",d.logarithmicDepthBuffer&&e.extensions.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_COLOR","	attribute vec3 color;","#endif","#ifdef USE_MORPHTARGETS","	attribute vec3 morphTarget0;","	attribute vec3 morphTarget1;","	attribute vec3 morphTarget2;","	attribute vec3 morphTarget3;","	#ifdef USE_MORPHNORMALS","		attribute vec3 morphNormal0;","		attribute vec3 morphNormal1;","		attribute vec3 morphNormal2;","		attribute vec3 morphNormal3;","	#else","		attribute vec3 morphTarget4;","		attribute vec3 morphTarget5;","		attribute vec3 morphTarget6;","		attribute vec3 morphTarget7;","	#endif","#endif","#ifdef USE_SKINNING","	attribute vec4 skinIndex;","	attribute vec4 skinWeight;","#endif","\n"].filter(a).join("\n"),v=[E,"precision "+d.precision+" float;","precision "+d.precision+" int;","#define SHADER_NAME "+p.__webglShader.name,b,d.alphaTest?"#define ALPHATEST "+d.alphaTest:"","#define GAMMA_FACTOR "+H,d.useFog&&d.fog?"#define USE_FOG":"",d.useFog&&d.fogExp?"#define FOG_EXP2":"",d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.envMap?"#define "+y:"",d.envMap?"#define "+R:"",d.envMap?"#define "+x:"",d.lightMap?"#define USE_LIGHTMAP":"",d.aoMap?"#define USE_AOMAP":"",d.emissiveMap?"#define USE_EMISSIVEMAP":"",d.bumpMap?"#define USE_BUMPMAP":"",d.normalMap?"#define USE_NORMALMAP":"",d.specularMap?"#define USE_SPECULARMAP":"",d.roughnessMap?"#define USE_ROUGHNESSMAP":"",d.metalnessMap?"#define USE_METALNESSMAP":"",d.alphaMap?"#define USE_ALPHAMAP":"",d.vertexColors?"#define USE_COLOR":"",d.flatShading?"#define FLAT_SHADED":"",d.doubleSided?"#define DOUBLE_SIDED":"",d.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+d.numClippingPlanes,d.shadowMapEnabled?"#define USE_SHADOWMAP":"",d.shadowMapEnabled?"#define "+v:"",d.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",d.physicallyCorrectLights?"#define PHYSICALLY_CORRECT_LIGHTS":"",d.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",d.logarithmicDepthBuffer&&e.extensions.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"",d.envMap&&e.extensions.get("EXT_shader_texture_lod")?"#define TEXTURE_LOD_EXT":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;",d.toneMapping!==THREE.NoToneMapping?"#define TONE_MAPPING":"",d.toneMapping!==THREE.NoToneMapping?THREE.ShaderChunk.tonemapping_pars_fragment:"",d.toneMapping!==THREE.NoToneMapping?r("toneMapping",d.toneMapping):"",d.outputEncoding||d.mapEncoding||d.envMapEncoding||d.emissiveMapEncoding?THREE.ShaderChunk.encodings_pars_fragment:"",d.mapEncoding?t("mapTexelToLinear",d.mapEncoding):"",d.envMapEncoding?t("envMapTexelToLinear",d.envMapEncoding):"",d.emissiveMapEncoding?t("emissiveMapTexelToLinear",d.emissiveMapEncoding):"",d.outputEncoding?i("linearToOutputTexel",d.outputEncoding):"",d.depthPacking?"#define DEPTH_PACKING "+p.depthPacking:"","\n"].filter(a).join("\n")),g=c(g,d),g=s(g,d),T=c(T,d),T=s(T,d),!1==p instanceof THREE.ShaderMaterial&&(g=h(g),T=h(T)),T=v+T,g=THREE.WebGLShader(f,f.VERTEX_SHADER,m+g),T=THREE.WebGLShader(f,f.FRAGMENT_SHADER,T),f.attachShader(_,g),f.attachShader(_,T),void 0!==p.index0AttributeName?f.bindAttribLocation(_,0,p.index0AttributeName):!0===d.morphTargets&&f.bindAttribLocation(_,0,"position"),f.linkProgram(_),d=f.getProgramInfoLog(_),y=f.getShaderInfoLog(g),R=f.getShaderInfoLog(T),H=x=!0,!1===f.getProgramParameter(_,f.LINK_STATUS)?(x=!1,console.error("THREE.WebGLProgram: shader error: ",f.getError(),"gl.VALIDATE_STATUS",f.getProgramParameter(_,f.VALIDATE_STATUS),"gl.getProgramInfoLog",d,y,R)):""!==d?console.warn("THREE.WebGLProgram: gl.getProgramInfoLog()",d):""!==y&&""!==R||(H=!1),H&&(this.diagnostics={runnable:x,material:p,programLog:d,vertexShader:{log:y,prefix:m},fragmentShader:{log:R,prefix:v}}),f.deleteShader(g),f.deleteShader(T);var M;this.getUniforms=function(){return void 0===M&&(M=new THREE.WebGLUniforms(f,_,e)),M};var w;return this.getAttributes=function(){if(void 0===w){for(var e={},t=f.getProgramParameter(_,f.ACTIVE_ATTRIBUTES),i=0;t>i;i++){var r=f.getActiveAttrib(_,i).name;e[r]=f.getAttribLocation(_,r)}w=e}return w},this.destroy=function(){f.deleteProgram(_),this.program=void 0},Object.defineProperties(this,{uniforms:{get:function(){return console.warn("THREE.WebGLProgram: .uniforms is now .getUniforms()."),this.getUniforms()}},attributes:{get:function(){return console.warn("THREE.WebGLProgram: .attributes is now .getAttributes()."),this.getAttributes()}}}),this.id=l++,this.code=u,this.usedTimes=1,this.program=_,this.vertexShader=g,this.fragmentShader=T,this}}(),THREE.WebGLPrograms=function(e,t){function i(e,t){var i;return e?e instanceof THREE.Texture?i=e.encoding:e instanceof THREE.WebGLRenderTarget&&(console.warn("THREE.WebGLPrograms.getTextureEncodingFromMap: don't use render targets as textures. Use their .texture property instead."),i=e.texture.encoding):i=THREE.LinearEncoding,i===THREE.LinearEncoding&&t&&(i=THREE.GammaEncoding),i}var r=[],n={MeshDepthMaterial:"depth",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points"},o="precision supportsVertexTextures map mapEncoding envMap envMapMode envMapEncoding lightMap aoMap emissiveMap emissiveMapEncoding bumpMap normalMap displacementMap specularMap roughnessMap metalnessMap alphaMap combine vertexColors fog useFog fogExp flatShading sizeAttenuation logarithmicDepthBuffer skinning maxBones useVertexTexture morphTargets morphNormals maxMorphTargets maxMorphNormals premultipliedAlpha numDirLights numPointLights numSpotLights numHemiLights shadowMapEnabled shadowMapType toneMapping physicallyCorrectLights alphaTest doubleSided flipSided numClippingPlanes depthPacking".split(" ");this.getParameters=function(r,o,a,s,c){var h,l=n[r.type];t.floatVertexTextures&&c&&c.skeleton&&c.skeleton.useVertexTexture?h=1024:(h=Math.floor((t.maxVertexUniforms-20)/4),void 0!==c&&c instanceof THREE.SkinnedMesh&&(h=Math.min(c.skeleton.bones.length,h),h<c.skeleton.bones.length&&console.warn("WebGLRenderer: too many bones - "+c.skeleton.bones.length+", this GPU supports just "+h+" (try OpenGL instead of ANGLE)")));var u=e.getPrecision();null!==r.precision&&(u=t.getMaxPrecision(r.precision),u!==r.precision&&console.warn("THREE.WebGLProgram.getParameters:",r.precision,"not supported, using",u,"instead."));var p=e.getCurrentRenderTarget();return{shaderID:l,precision:u,supportsVertexTextures:t.vertexTextures,outputEncoding:i(p?p.texture:null,e.gammaOutput),map:!!r.map,mapEncoding:i(r.map,e.gammaInput),envMap:!!r.envMap,envMapMode:r.envMap&&r.envMap.mapping,envMapEncoding:i(r.envMap,e.gammaInput),envMapCubeUV:!!r.envMap&&(r.envMap.mapping===THREE.CubeUVReflectionMapping||r.envMap.mapping===THREE.CubeUVRefractionMapping),lightMap:!!r.lightMap,aoMap:!!r.aoMap,emissiveMap:!!r.emissiveMap,emissiveMapEncoding:i(r.emissiveMap,e.gammaInput),bumpMap:!!r.bumpMap,normalMap:!!r.normalMap,displacementMap:!!r.displacementMap,roughnessMap:!!r.roughnessMap,metalnessMap:!!r.metalnessMap,specularMap:!!r.specularMap,alphaMap:!!r.alphaMap,combine:r.combine,vertexColors:r.vertexColors,fog:a,useFog:r.fog,fogExp:a instanceof THREE.FogExp2,flatShading:r.shading===THREE.FlatShading,sizeAttenuation:r.sizeAttenuation,logarithmicDepthBuffer:t.logarithmicDepthBuffer,skinning:r.skinning,maxBones:h,useVertexTexture:t.floatVertexTextures&&c&&c.skeleton&&c.skeleton.useVertexTexture,morphTargets:r.morphTargets,morphNormals:r.morphNormals,maxMorphTargets:e.maxMorphTargets,maxMorphNormals:e.maxMorphNormals,numDirLights:o.directional.length,numPointLights:o.point.length,numSpotLights:o.spot.length,numHemiLights:o.hemi.length,numClippingPlanes:s,shadowMapEnabled:e.shadowMap.enabled&&c.receiveShadow&&0<o.shadows.length,shadowMapType:e.shadowMap.type,toneMapping:e.toneMapping,physicallyCorrectLights:e.physicallyCorrectLights,premultipliedAlpha:r.premultipliedAlpha,alphaTest:r.alphaTest,doubleSided:r.side===THREE.DoubleSide,flipSided:r.side===THREE.BackSide,depthPacking:void 0!==r.depthPacking?r.depthPacking:!1}},this.getProgramCode=function(e,t){var i=[];if(t.shaderID?i.push(t.shaderID):(i.push(e.fragmentShader),i.push(e.vertexShader)),void 0!==e.defines)for(var r in e.defines)i.push(r),i.push(e.defines[r]);for(r=0;r<o.length;r++)i.push(t[o[r]]);return i.join()},this.acquireProgram=function(t,i,n){for(var o,a=0,s=r.length;s>a;a++){var c=r[a];if(c.code===n){o=c,++o.usedTimes;break}}return void 0===o&&(o=new THREE.WebGLProgram(e,n,t,i),r.push(o)),o},this.releaseProgram=function(e){if(0===--e.usedTimes){var t=r.indexOf(e);r[t]=r[r.length-1],r.pop(),e.destroy()}},this.programs=r},THREE.WebGLProperties=function(){var e={};this.get=function(t){t=t.uuid;var i=e[t];return void 0===i&&(i={},e[t]=i),i},this["delete"]=function(t){delete e[t.uuid]},this.clear=function(){e={}}},THREE.WebGLShader=function(){function e(e){e=e.split("\n");for(var t=0;t<e.length;t++)e[t]=t+1+": "+e[t];return e.join("\n")}return function(t,i,r){var n=t.createShader(i);return t.shaderSource(n,r),t.compileShader(n),!1===t.getShaderParameter(n,t.COMPILE_STATUS)&&console.error("THREE.WebGLShader: Shader couldn't compile."),""!==t.getShaderInfoLog(n)&&console.warn("THREE.WebGLShader: gl.getShaderInfoLog()",i===t.VERTEX_SHADER?"vertex":"fragment",t.getShaderInfoLog(n),e(r)),
n}}(),THREE.WebGLShadowMap=function(e,t,i){function r(t,i,r,n){var o=t.geometry,a=null,a=f,s=t.customDepthMaterial;return r&&(a=E,s=t.customDistanceMaterial),s?a=s:(t=t instanceof THREE.SkinnedMesh&&i.skinning,s=0,void 0!==o.morphTargets&&0<o.morphTargets.length&&i.morphTargets&&(s|=1),t&&(s|=2),a=a[s]),e.localClippingEnabled&&!0===i.clipShadows&&0!==i.clippingPlanes.length&&(s=a.uuid,o=i.uuid,t=m[s],void 0===t&&(t={},m[s]=t),s=t[o],void 0===s&&(s=a.clone(),t[o]=s),a=s),a.visible=i.visible,a.wireframe=i.wireframe,o=i.side,M.renderSingleSided&&o==THREE.DoubleSide&&(o=THREE.FrontSide),M.renderReverseSided&&(o===THREE.FrontSide?o=THREE.BackSide:o===THREE.BackSide&&(o=THREE.FrontSide)),a.side=o,a.clipShadows=i.clipShadows,a.clippingPlanes=i.clippingPlanes,a.wireframeLinewidth=i.wireframeLinewidth,a.linewidth=i.linewidth,r&&void 0!==a.uniforms.lightPos&&a.uniforms.lightPos.value.copy(n),a}function n(e,t,i){if(!1!==e.visible){e.layers.test(t.layers)&&(e instanceof THREE.Mesh||e instanceof THREE.Line||e instanceof THREE.Points)&&e.castShadow&&(!1===e.frustumCulled||!0===s.intersectsObject(e))&&!0===e.material.visible&&(e.modelViewMatrix.multiplyMatrices(i.matrixWorldInverse,e.matrixWorld),d.push(e)),e=e.children;for(var r=0,o=e.length;o>r;r++)n(e[r],t,i)}}var o=e.context,a=e.state,s=new THREE.Frustum,c=new THREE.Matrix4,h=t.shadows,l=new THREE.Vector2,u=new THREE.Vector3,p=new THREE.Vector3,d=[],f=Array(4),E=Array(4),m={},g=[new THREE.Vector3(1,0,0),new THREE.Vector3(-1,0,0),new THREE.Vector3(0,0,1),new THREE.Vector3(0,0,-1),new THREE.Vector3(0,1,0),new THREE.Vector3(0,-1,0)],T=[new THREE.Vector3(0,1,0),new THREE.Vector3(0,1,0),new THREE.Vector3(0,1,0),new THREE.Vector3(0,1,0),new THREE.Vector3(0,0,1),new THREE.Vector3(0,0,-1)],v=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4];t=new THREE.MeshDepthMaterial,t.depthPacking=THREE.RGBADepthPacking,t.clipping=!0;for(var y=THREE.ShaderLib.distanceRGBA,R=THREE.UniformsUtils.clone(y.uniforms),x=0;4!==x;++x){var H=0!==(1&x),b=0!==(2&x),_=t.clone();_.morphTargets=H,_.skinning=b,f[x]=_,H=new THREE.ShaderMaterial({defines:{USE_SHADOWMAP:""},uniforms:R,vertexShader:y.vertexShader,fragmentShader:y.fragmentShader,morphTargets:H,skinning:b,clipping:!0}),E[x]=H}var M=this;this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=THREE.PCFShadowMap,this.renderSingleSided=this.renderReverseSided=!0,this.render=function(t,f){if(!1!==M.enabled&&(!1!==M.autoUpdate||!1!==M.needsUpdate)&&0!==h.length){a.clearColor(1,1,1,1),a.disable(o.BLEND),a.setDepthTest(!0),a.setScissorTest(!1);for(var E,m,y=0,R=h.length;R>y;y++){var x=h[y],H=x.shadow;if(void 0===H)console.warn("THREE.WebGLShadowMap:",x,"has no shadow.");else{var b=H.camera;if(l.copy(H.mapSize),x instanceof THREE.PointLight){E=6,m=!0;var _=l.x,w=l.y;v[0].set(2*_,w,_,w),v[1].set(0,w,_,w),v[2].set(3*_,w,_,w),v[3].set(_,w,_,w),v[4].set(3*_,0,_,w),v[5].set(_,0,_,w),l.x*=4,l.y*=2}else E=1,m=!1;for(null===H.map&&(H.map=new THREE.WebGLRenderTarget(l.x,l.y,{minFilter:THREE.NearestFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat}),b.updateProjectionMatrix()),H instanceof THREE.SpotLightShadow&&H.update(x),_=H.map,H=H.matrix,p.setFromMatrixPosition(x.matrixWorld),b.position.copy(p),e.setRenderTarget(_),e.clear(),_=0;E>_;_++){m?(u.copy(b.position),u.add(g[_]),b.up.copy(T[_]),b.lookAt(u),a.viewport(v[_])):(u.setFromMatrixPosition(x.target.matrixWorld),b.lookAt(u)),b.updateMatrixWorld(),b.matrixWorldInverse.getInverse(b.matrixWorld),H.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),H.multiply(b.projectionMatrix),H.multiply(b.matrixWorldInverse),c.multiplyMatrices(b.projectionMatrix,b.matrixWorldInverse),s.setFromMatrix(c),d.length=0,n(t,f,b);for(var w=0,S=d.length;S>w;w++){var L=d[w],A=i.update(L),C=L.material;if(C instanceof THREE.MultiMaterial)for(var P=A.groups,C=C.materials,B=0,U=P.length;U>B;B++){var D=P[B],I=C[D.materialIndex];!0===I.visible&&(I=r(L,I,m,p),e.renderBufferDirect(b,null,A,I,L,D))}else I=r(L,C,m,p),e.renderBufferDirect(b,null,A,I,L,null)}}}}E=e.getClearColor(),m=e.getClearAlpha(),e.setClearColor(E,m),M.needsUpdate=!1}}},THREE.WebGLState=function(e,t,i){function r(t,i,r){var n=new Uint8Array(3),o=e.createTexture();for(e.bindTexture(t,o),e.texParameteri(t,e.TEXTURE_MIN_FILTER,e.NEAREST),e.texParameteri(t,e.TEXTURE_MAG_FILTER,e.NEAREST),t=0;r>t;t++)e.texImage2D(i+t,0,e.RGB,1,1,0,e.RGB,e.UNSIGNED_BYTE,n);return o}var n=this;this.buffers={color:new THREE.WebGLColorBuffer(e,this),depth:new THREE.WebGLDepthBuffer(e,this),stencil:new THREE.WebGLStencilBuffer(e,this)};var o=e.getParameter(e.MAX_VERTEX_ATTRIBS),a=new Uint8Array(o),s=new Uint8Array(o),c=new Uint8Array(o),h={},l=null,u=null,p=null,d=null,f=null,E=null,m=null,g=null,T=!1,v=null,y=null,R=null,x=null,H=null,b=null,_=e.getParameter(e.MAX_TEXTURE_IMAGE_UNITS),M=null,w={},S=new THREE.Vector4,L=new THREE.Vector4,A={};A[e.TEXTURE_2D]=r(e.TEXTURE_2D,e.TEXTURE_2D,1),A[e.TEXTURE_CUBE_MAP]=r(e.TEXTURE_CUBE_MAP,e.TEXTURE_CUBE_MAP_POSITIVE_X,6),this.init=function(){this.clearColor(0,0,0,1),this.clearDepth(1),this.clearStencil(0),this.enable(e.DEPTH_TEST),this.setDepthFunc(THREE.LessEqualDepth),this.setFlipSided(!1),this.setCullFace(THREE.CullFaceBack),this.enable(e.CULL_FACE),this.enable(e.BLEND),this.setBlending(THREE.NormalBlending)},this.initAttributes=function(){for(var e=0,t=a.length;t>e;e++)a[e]=0},this.enableAttribute=function(i){a[i]=1,0===s[i]&&(e.enableVertexAttribArray(i),s[i]=1),0!==c[i]&&(t.get("ANGLE_instanced_arrays").vertexAttribDivisorANGLE(i,0),c[i]=0)},this.enableAttributeAndDivisor=function(t,i,r){a[t]=1,0===s[t]&&(e.enableVertexAttribArray(t),s[t]=1),c[t]!==i&&(r.vertexAttribDivisorANGLE(t,i),c[t]=i)},this.disableUnusedAttributes=function(){for(var t=0,i=s.length;t!==i;++t)s[t]!==a[t]&&(e.disableVertexAttribArray(t),s[t]=0)},this.enable=function(t){!0!==h[t]&&(e.enable(t),h[t]=!0)},this.disable=function(t){!1!==h[t]&&(e.disable(t),h[t]=!1)},this.getCompressedTextureFormats=function(){if(null===l&&(l=[],t.get("WEBGL_compressed_texture_pvrtc")||t.get("WEBGL_compressed_texture_s3tc")||t.get("WEBGL_compressed_texture_etc1")))for(var i=e.getParameter(e.COMPRESSED_TEXTURE_FORMATS),r=0;r<i.length;r++)l.push(i[r]);return l},this.setBlending=function(t,r,n,o,a,s,c,h){t!==THREE.NoBlending?(this.enable(e.BLEND),t===u&&h===T||(t===THREE.AdditiveBlending?h?(e.blendEquationSeparate(e.FUNC_ADD,e.FUNC_ADD),e.blendFuncSeparate(e.ONE,e.ONE,e.ONE,e.ONE)):(e.blendEquation(e.FUNC_ADD),e.blendFunc(e.SRC_ALPHA,e.ONE)):t===THREE.SubtractiveBlending?h?(e.blendEquationSeparate(e.FUNC_ADD,e.FUNC_ADD),e.blendFuncSeparate(e.ZERO,e.ZERO,e.ONE_MINUS_SRC_COLOR,e.ONE_MINUS_SRC_ALPHA)):(e.blendEquation(e.FUNC_ADD),e.blendFunc(e.ZERO,e.ONE_MINUS_SRC_COLOR)):t===THREE.MultiplyBlending?h?(e.blendEquationSeparate(e.FUNC_ADD,e.FUNC_ADD),e.blendFuncSeparate(e.ZERO,e.SRC_COLOR,e.ZERO,e.SRC_ALPHA)):(e.blendEquation(e.FUNC_ADD),e.blendFunc(e.ZERO,e.SRC_COLOR)):h?(e.blendEquationSeparate(e.FUNC_ADD,e.FUNC_ADD),e.blendFuncSeparate(e.ONE,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA)):(e.blendEquationSeparate(e.FUNC_ADD,e.FUNC_ADD),e.blendFuncSeparate(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA)),u=t,T=h),t===THREE.CustomBlending?(a=a||r,s=s||n,c=c||o,r===p&&a===E||(e.blendEquationSeparate(i(r),i(a)),p=r,E=a),n===d&&o===f&&s===m&&c===g||(e.blendFuncSeparate(i(n),i(o),i(s),i(c)),d=n,f=o,m=s,g=c)):g=m=E=f=d=p=null):(this.disable(e.BLEND),u=t)},this.setColorWrite=function(e){this.buffers.color.setMask(e)},this.setDepthTest=function(e){this.buffers.depth.setTest(e)},this.setDepthWrite=function(e){this.buffers.depth.setMask(e)},this.setDepthFunc=function(e){this.buffers.depth.setFunc(e)},this.setStencilTest=function(e){this.buffers.stencil.setTest(e)},this.setStencilWrite=function(e){this.buffers.stencil.setMask(e)},this.setStencilFunc=function(e,t,i){this.buffers.stencil.setFunc(e,t,i)},this.setStencilOp=function(e,t,i){this.buffers.stencil.setOp(e,t,i)},this.setFlipSided=function(t){v!==t&&(t?e.frontFace(e.CW):e.frontFace(e.CCW),v=t)},this.setCullFace=function(t){t!==THREE.CullFaceNone?(this.enable(e.CULL_FACE),t!==y&&(t===THREE.CullFaceBack?e.cullFace(e.BACK):t===THREE.CullFaceFront?e.cullFace(e.FRONT):e.cullFace(e.FRONT_AND_BACK))):this.disable(e.CULL_FACE),y=t},this.setLineWidth=function(t){t!==R&&(e.lineWidth(t),R=t)},this.setPolygonOffset=function(t,i,r){t?(this.enable(e.POLYGON_OFFSET_FILL),(x!==i||H!==r)&&(e.polygonOffset(i,r),x=i,H=r)):this.disable(e.POLYGON_OFFSET_FILL)},this.getScissorTest=function(){return b},this.setScissorTest=function(t){(b=t)?this.enable(e.SCISSOR_TEST):this.disable(e.SCISSOR_TEST)},this.activeTexture=function(t){void 0===t&&(t=e.TEXTURE0+_-1),M!==t&&(e.activeTexture(t),M=t)},this.bindTexture=function(t,i){null===M&&n.activeTexture();var r=w[M];void 0===r&&(r={type:void 0,texture:void 0},w[M]=r),r.type===t&&r.texture===i||(e.bindTexture(t,i||A[t]),r.type=t,r.texture=i)},this.compressedTexImage2D=function(){try{e.compressedTexImage2D.apply(e,arguments)}catch(t){console.error(t)}},this.texImage2D=function(){try{e.texImage2D.apply(e,arguments)}catch(t){console.error(t)}},this.clearColor=function(e,t,i,r){this.buffers.color.setClear(e,t,i,r)},this.clearDepth=function(e){this.buffers.depth.setClear(e)},this.clearStencil=function(e){this.buffers.stencil.setClear(e)},this.scissor=function(t){!1===S.equals(t)&&(e.scissor(t.x,t.y,t.z,t.w),S.copy(t))},this.viewport=function(t){!1===L.equals(t)&&(e.viewport(t.x,t.y,t.z,t.w),L.copy(t))},this.reset=function(){for(var t=0;t<s.length;t++)1===s[t]&&(e.disableVertexAttribArray(t),s[t]=0);h={},M=l=null,w={},y=v=u=null,this.buffers.color.reset(),this.buffers.depth.reset(),this.buffers.stencil.reset()}},THREE.WebGLColorBuffer=function(e,t){var i=!1,r=new THREE.Vector4,n=null,o=new THREE.Vector4;this.setMask=function(t){n===t||i||(e.colorMask(t,t,t,t),n=t)},this.setLocked=function(e){i=e},this.setClear=function(t,i,n,a){r.set(t,i,n,a),!1===o.equals(r)&&(e.clearColor(t,i,n,a),o.copy(r))},this.reset=function(){i=!1,n=null,o=new THREE.Vector4}},THREE.WebGLDepthBuffer=function(e,t){var i=!1,r=null,n=null,o=null;this.setTest=function(i){i?t.enable(e.DEPTH_TEST):t.disable(e.DEPTH_TEST)},this.setMask=function(t){r===t||i||(e.depthMask(t),r=t)},this.setFunc=function(t){if(n!==t){if(t)switch(t){case THREE.NeverDepth:e.depthFunc(e.NEVER);break;case THREE.AlwaysDepth:e.depthFunc(e.ALWAYS);break;case THREE.LessDepth:e.depthFunc(e.LESS);break;case THREE.LessEqualDepth:e.depthFunc(e.LEQUAL);break;case THREE.EqualDepth:e.depthFunc(e.EQUAL);break;case THREE.GreaterEqualDepth:e.depthFunc(e.GEQUAL);break;case THREE.GreaterDepth:e.depthFunc(e.GREATER);break;case THREE.NotEqualDepth:e.depthFunc(e.NOTEQUAL);break;default:e.depthFunc(e.LEQUAL)}else e.depthFunc(e.LEQUAL);n=t}},this.setLocked=function(e){i=e},this.setClear=function(t){o!==t&&(e.clearDepth(t),o=t)},this.reset=function(){i=!1,o=n=r=null}},THREE.WebGLStencilBuffer=function(e,t){var i=!1,r=null,n=null,o=null,a=null,s=null,c=null,h=null,l=null;this.setTest=function(i){i?t.enable(e.STENCIL_TEST):t.disable(e.STENCIL_TEST)},this.setMask=function(t){r===t||i||(e.stencilMask(t),r=t)},this.setFunc=function(t,i,r){n===t&&o===i&&a===r||(e.stencilFunc(t,i,r),n=t,o=i,a=r)},this.setOp=function(t,i,r){s===t&&c===i&&h===r||(e.stencilOp(t,i,r),s=t,c=i,h=r)},this.setLocked=function(e){i=e},this.setClear=function(t){l!==t&&(e.clearStencil(t),l=t)},this.reset=function(){i=!1,l=h=c=s=a=o=n=r=null}},THREE.WebGLUniforms=function(){var e=[],t=[],i=function(t,i,r){var n=t[0];if(0>=n||n>0)return t;var o=i*r,a=e[o];if(void 0===a&&(a=new Float32Array(o),e[o]=a),0!==i)for(n.toArray(a,0),n=1,o=0;n!==i;++n)o+=r,t[n].toArray(a,o);return a},r=function(e,i){var r=t[i];void 0===r&&(r=new Int32Array(i),t[i]=r);for(var n=0;n!==i;++n)r[n]=e.allocTextureUnit();return r},n=function(e,t){e.uniform1f(this.addr,t)},o=function(e,t){e.uniform1i(this.addr,t)},a=function(e,t){void 0===t.x?e.uniform2fv(this.addr,t):e.uniform2f(this.addr,t.x,t.y)},s=function(e,t){void 0!==t.x?e.uniform3f(this.addr,t.x,t.y,t.z):void 0!==t.r?e.uniform3f(this.addr,t.r,t.g,t.b):e.uniform3fv(this.addr,t)},c=function(e,t){void 0===t.x?e.uniform4fv(this.addr,t):e.uniform4f(this.addr,t.x,t.y,t.z,t.w)},h=function(e,t){e.uniformMatrix2fv(this.addr,!1,t.elements||t)},l=function(e,t){e.uniformMatrix3fv(this.addr,!1,t.elements||t)},u=function(e,t){e.uniformMatrix4fv(this.addr,!1,t.elements||t)},p=function(e,t,i){var r=i.allocTextureUnit();e.uniform1i(this.addr,r),t&&i.setTexture2D(t,r)},d=function(e,t,i){var r=i.allocTextureUnit();e.uniform1i(this.addr,r),t&&i.setTextureCube(t,r)},f=function(e,t){e.uniform2iv(this.addr,t)},E=function(e,t){e.uniform3iv(this.addr,t)},m=function(e,t){e.uniform4iv(this.addr,t)},g=function(e){switch(e){case 5126:return n;case 35664:return a;case 35665:return s;case 35666:return c;case 35674:return h;case 35675:return l;case 35676:return u;case 35678:return p;case 35680:return d;case 5124:case 35670:return o;case 35667:case 35671:return f;case 35668:case 35672:return E;case 35669:case 35673:return m}},T=function(e,t){e.uniform1fv(this.addr,t)},v=function(e,t){e.uniform1iv(this.addr,t)},y=function(e,t){e.uniform2fv(this.addr,i(t,this.size,2))},R=function(e,t){e.uniform3fv(this.addr,i(t,this.size,3))},x=function(e,t){e.uniform4fv(this.addr,i(t,this.size,4))},H=function(e,t){e.uniformMatrix2fv(this.addr,!1,i(t,this.size,4))},b=function(e,t){e.uniformMatrix3fv(this.addr,!1,i(t,this.size,9))},_=function(e,t){e.uniformMatrix4fv(this.addr,!1,i(t,this.size,16))},M=function(e,t,i){var n=t.length,o=r(i,n);for(e.uniform1iv(this.addr,o),e=0;e!==n;++e){var a=t[e];a&&i.setTexture2D(a,o[e])}},w=function(e,t,i){var n=t.length,o=r(i,n);for(e.uniform1iv(this.addr,o),e=0;e!==n;++e){var a=t[e];a&&i.setTextureCube(a,o[e])}},S=function(e){switch(e){case 5126:return T;case 35664:return y;case 35665:return R;case 35666:return x;case 35674:return H;case 35675:return b;case 35676:return _;case 35678:return M;case 35680:return w;case 5124:case 35670:return v;case 35667:case 35671:return f;case 35668:case 35672:return E;case 35669:case 35673:return m}},L=function(e,t,i){this.id=e,this.addr=i,this.setValue=g(t.type)},A=function(e,t,i){this.id=e,this.addr=i,this.size=t.size,this.setValue=S(t.type)},C=function(e){this.id=e,this.seq=[],this.map={}};C.prototype.setValue=function(e,t){for(var i=this.seq,r=0,n=i.length;r!==n;++r){var o=i[r];o.setValue(e,t[o.id])}};var P=/([\w\d_]+)(\])?(\[|\.)?/g,B=function(e,t,i){this.seq=[],this.map={},this.renderer=i,i=e.getProgramParameter(t,e.ACTIVE_UNIFORMS);for(var r=0;r!==i;++r){var n=e.getActiveUniform(t,r),o=e.getUniformLocation(t,n.name),a=this,s=n.name,c=s.length;for(P.lastIndex=0;;){var h=P.exec(s),l=P.lastIndex,u=h[1],p=h[3];if("]"===h[2]&&(u|=0),void 0===p||"["===p&&l+2===c){s=a,n=void 0===p?new L(u,n,o):new A(u,n,o),s.seq.push(n),s.map[n.id]=n;break}p=a.map[u],void 0===p&&(p=new C(u),u=a,a=p,u.seq.push(a),u.map[a.id]=a),a=p}}};return B.prototype.setValue=function(e,t,i){t=this.map[t],void 0!==t&&t.setValue(e,i,this.renderer)},B.prototype.set=function(e,t,i){var r=this.map[i];void 0!==r&&r.setValue(e,t[i],this.renderer)},B.prototype.setOptional=function(e,t,i){t=t[i],void 0!==t&&this.setValue(e,i,t)},B.upload=function(e,t,i,r){for(var n=0,o=t.length;n!==o;++n){var a=t[n],s=i[a.id];!1!==s.needsUpdate&&a.setValue(e,s.value,r)}},B.seqWithValue=function(e,t){for(var i=[],r=0,n=e.length;r!==n;++r){var o=e[r];o.id in t&&i.push(o)}return i},B.splitDynamic=function(e,t){for(var i=null,r=e.length,n=0,o=0;o!==r;++o){var a=e[o],s=t[a.id];s&&!0===s.dynamic?(null===i&&(i=[]),i.push(a)):(o>n&&(e[n]=a),++n)}return r>n&&(e.length=n),i},B.evalDynamic=function(e,t,i,r){for(var n=0,o=e.length;n!==o;++n){var a=t[e[n].id],s=a.onUpdateCallback;void 0!==s&&s.call(a,i,r)}},B}(),THREE.LensFlarePlugin=function(e,t){var i,r,n,o,a,s,c,h,l,u,p,d,f,E,m,g,T=e.context,v=e.state;this.render=function(y,R,x){if(0!==t.length){y=new THREE.Vector3;var H=x.w/x.z,b=.5*x.z,_=.5*x.w,M=16/x.w,w=new THREE.Vector2(M*H,M),S=new THREE.Vector3(1,1,0),L=new THREE.Vector2(1,1),A=new THREE.Box2;if(A.min.set(0,0),A.max.set(x.z-16,x.w-16),void 0===E){var M=new Float32Array([-1,-1,0,0,1,-1,1,0,1,1,1,1,-1,1,0,1]),C=new Uint16Array([0,1,2,0,2,3]);p=T.createBuffer(),d=T.createBuffer(),T.bindBuffer(T.ARRAY_BUFFER,p),T.bufferData(T.ARRAY_BUFFER,M,T.STATIC_DRAW),T.bindBuffer(T.ELEMENT_ARRAY_BUFFER,d),T.bufferData(T.ELEMENT_ARRAY_BUFFER,C,T.STATIC_DRAW),m=T.createTexture(),g=T.createTexture(),v.bindTexture(T.TEXTURE_2D,m),T.texImage2D(T.TEXTURE_2D,0,T.RGB,16,16,0,T.RGB,T.UNSIGNED_BYTE,null),T.texParameteri(T.TEXTURE_2D,T.TEXTURE_WRAP_S,T.CLAMP_TO_EDGE),T.texParameteri(T.TEXTURE_2D,T.TEXTURE_WRAP_T,T.CLAMP_TO_EDGE),T.texParameteri(T.TEXTURE_2D,T.TEXTURE_MAG_FILTER,T.NEAREST),T.texParameteri(T.TEXTURE_2D,T.TEXTURE_MIN_FILTER,T.NEAREST),v.bindTexture(T.TEXTURE_2D,g),T.texImage2D(T.TEXTURE_2D,0,T.RGBA,16,16,0,T.RGBA,T.UNSIGNED_BYTE,null),T.texParameteri(T.TEXTURE_2D,T.TEXTURE_WRAP_S,T.CLAMP_TO_EDGE),T.texParameteri(T.TEXTURE_2D,T.TEXTURE_WRAP_T,T.CLAMP_TO_EDGE),T.texParameteri(T.TEXTURE_2D,T.TEXTURE_MAG_FILTER,T.NEAREST),T.texParameteri(T.TEXTURE_2D,T.TEXTURE_MIN_FILTER,T.NEAREST);var M=f={vertexShader:"uniform lowp int renderType;\nuniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif ( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.5, 0.1 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.9, 0.1 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.9, 0.9 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.1, 0.9 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) );\nvisibility += texture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility =        visibility.r / 9.0;\nvVisibility *= 1.0 - visibility.g / 9.0;\nvVisibility *=       visibility.b / 9.0;\nvVisibility *= 1.0 - visibility.a / 9.0;\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"uniform lowp int renderType;\nuniform sampler2D map;\nuniform float opacity;\nuniform vec3 color;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif ( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if ( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * vVisibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"},C=T.createProgram(),P=T.createShader(T.FRAGMENT_SHADER),B=T.createShader(T.VERTEX_SHADER),U="precision "+e.getPrecision()+" float;\n";T.shaderSource(P,U+M.fragmentShader),T.shaderSource(B,U+M.vertexShader),T.compileShader(P),T.compileShader(B),T.attachShader(C,P),T.attachShader(C,B),T.linkProgram(C),E=C,l=T.getAttribLocation(E,"position"),u=T.getAttribLocation(E,"uv"),i=T.getUniformLocation(E,"renderType"),r=T.getUniformLocation(E,"map"),n=T.getUniformLocation(E,"occlusionMap"),o=T.getUniformLocation(E,"opacity"),a=T.getUniformLocation(E,"color"),s=T.getUniformLocation(E,"scale"),c=T.getUniformLocation(E,"rotation"),h=T.getUniformLocation(E,"screenPosition")}for(T.useProgram(E),v.initAttributes(),v.enableAttribute(l),v.enableAttribute(u),v.disableUnusedAttributes(),T.uniform1i(n,0),T.uniform1i(r,1),T.bindBuffer(T.ARRAY_BUFFER,p),T.vertexAttribPointer(l,2,T.FLOAT,!1,16,0),T.vertexAttribPointer(u,2,T.FLOAT,!1,16,8),T.bindBuffer(T.ELEMENT_ARRAY_BUFFER,d),v.disable(T.CULL_FACE),v.setDepthWrite(!1),C=0,P=t.length;P>C;C++)if(M=16/x.w,w.set(M*H,M),B=t[C],y.set(B.matrixWorld.elements[12],B.matrixWorld.elements[13],B.matrixWorld.elements[14]),y.applyMatrix4(R.matrixWorldInverse),y.applyProjection(R.projectionMatrix),S.copy(y),L.x=x.x+S.x*b+b-8,L.y=x.y+S.y*_+_-8,!0===A.containsPoint(L)){v.activeTexture(T.TEXTURE0),v.bindTexture(T.TEXTURE_2D,null),v.activeTexture(T.TEXTURE1),v.bindTexture(T.TEXTURE_2D,m),T.copyTexImage2D(T.TEXTURE_2D,0,T.RGB,L.x,L.y,16,16,0),T.uniform1i(i,0),T.uniform2f(s,w.x,w.y),T.uniform3f(h,S.x,S.y,S.z),v.disable(T.BLEND),v.enable(T.DEPTH_TEST),T.drawElements(T.TRIANGLES,6,T.UNSIGNED_SHORT,0),v.activeTexture(T.TEXTURE0),v.bindTexture(T.TEXTURE_2D,g),T.copyTexImage2D(T.TEXTURE_2D,0,T.RGBA,L.x,L.y,16,16,0),T.uniform1i(i,1),v.disable(T.DEPTH_TEST),v.activeTexture(T.TEXTURE1),v.bindTexture(T.TEXTURE_2D,m),T.drawElements(T.TRIANGLES,6,T.UNSIGNED_SHORT,0),B.positionScreen.copy(S),B.customUpdateCallback?B.customUpdateCallback(B):B.updateLensFlares(),T.uniform1i(i,2),v.enable(T.BLEND);for(var U=0,D=B.lensFlares.length;D>U;U++){var I=B.lensFlares[U];.001<I.opacity&&.001<I.scale&&(S.x=I.x,S.y=I.y,S.z=I.z,M=I.size*I.scale/x.w,w.x=M*H,w.y=M,T.uniform3f(h,S.x,S.y,S.z),T.uniform2f(s,w.x,w.y),T.uniform1f(c,I.rotation),T.uniform1f(o,I.opacity),T.uniform3f(a,I.color.r,I.color.g,I.color.b),v.setBlending(I.blending,I.blendEquation,I.blendSrc,I.blendDst),e.setTexture2D(I.texture,1),T.drawElements(T.TRIANGLES,6,T.UNSIGNED_SHORT,0))}}v.enable(T.CULL_FACE),v.enable(T.DEPTH_TEST),v.setDepthWrite(!0),e.resetGLState()}}},THREE.SpritePlugin=function(e,t){function i(e,t){return e.renderOrder!==t.renderOrder?e.renderOrder-t.renderOrder:e.z!==t.z?t.z-e.z:t.id-e.id}var r,n,o,a,s,c,h,l,u,p,d,f,E,m,g,T,v,y,R,x,H,b=e.context,_=e.state,M=new THREE.Vector3,w=new THREE.Quaternion,S=new THREE.Vector3;this.render=function(L,A){if(0!==t.length){if(void 0===x){var C=new Float32Array([-.5,-.5,0,0,.5,-.5,1,0,.5,.5,1,1,-.5,.5,0,1]),P=new Uint16Array([0,1,2,0,2,3]);y=b.createBuffer(),R=b.createBuffer(),b.bindBuffer(b.ARRAY_BUFFER,y),b.bufferData(b.ARRAY_BUFFER,C,b.STATIC_DRAW),b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,R),b.bufferData(b.ELEMENT_ARRAY_BUFFER,P,b.STATIC_DRAW);var C=b.createProgram(),P=b.createShader(b.VERTEX_SHADER),B=b.createShader(b.FRAGMENT_SHADER);b.shaderSource(P,["precision "+e.getPrecision()+" float;","uniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position * scale;\nvec2 rotatedPosition;\nrotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\nrotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\nvec4 finalPosition;\nfinalPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition;\nfinalPosition = projectionMatrix * finalPosition;\ngl_Position = finalPosition;\n}"].join("\n")),b.shaderSource(B,["precision "+e.getPrecision()+" float;","uniform vec3 color;\nuniform sampler2D map;\nuniform float opacity;\nuniform int fogType;\nuniform vec3 fogColor;\nuniform float fogDensity;\nuniform float fogNear;\nuniform float fogFar;\nuniform float alphaTest;\nvarying vec2 vUV;\nvoid main() {\nvec4 texture = texture2D( map, vUV );\nif ( texture.a < alphaTest ) discard;\ngl_FragColor = vec4( color * texture.xyz, texture.a * opacity );\nif ( fogType > 0 ) {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat fogFactor = 0.0;\nif ( fogType == 1 ) {\nfogFactor = smoothstep( fogNear, fogFar, depth );\n} else {\nconst float LOG2 = 1.442695;\nfogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n}\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n}\n}"].join("\n")),b.compileShader(P),b.compileShader(B),b.attachShader(C,P),b.attachShader(C,B),b.linkProgram(C),x=C,T=b.getAttribLocation(x,"position"),v=b.getAttribLocation(x,"uv"),r=b.getUniformLocation(x,"uvOffset"),n=b.getUniformLocation(x,"uvScale"),o=b.getUniformLocation(x,"rotation"),a=b.getUniformLocation(x,"scale"),s=b.getUniformLocation(x,"color"),c=b.getUniformLocation(x,"map"),h=b.getUniformLocation(x,"opacity"),l=b.getUniformLocation(x,"modelViewMatrix"),u=b.getUniformLocation(x,"projectionMatrix"),p=b.getUniformLocation(x,"fogType"),d=b.getUniformLocation(x,"fogDensity"),f=b.getUniformLocation(x,"fogNear"),E=b.getUniformLocation(x,"fogFar"),m=b.getUniformLocation(x,"fogColor"),g=b.getUniformLocation(x,"alphaTest"),C=document.createElement("canvas"),C.width=8,C.height=8,P=C.getContext("2d"),P.fillStyle="white",P.fillRect(0,0,8,8),H=new THREE.Texture(C),H.needsUpdate=!0}b.useProgram(x),_.initAttributes(),_.enableAttribute(T),_.enableAttribute(v),_.disableUnusedAttributes(),_.disable(b.CULL_FACE),_.enable(b.BLEND),b.bindBuffer(b.ARRAY_BUFFER,y),b.vertexAttribPointer(T,2,b.FLOAT,!1,16,0),b.vertexAttribPointer(v,2,b.FLOAT,!1,16,8),b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,R),b.uniformMatrix4fv(u,!1,A.projectionMatrix.elements),_.activeTexture(b.TEXTURE0),b.uniform1i(c,0),P=C=0,(B=L.fog)?(b.uniform3f(m,B.color.r,B.color.g,B.color.b),B instanceof THREE.Fog?(b.uniform1f(f,B.near),b.uniform1f(E,B.far),b.uniform1i(p,1),P=C=1):B instanceof THREE.FogExp2&&(b.uniform1f(d,B.density),b.uniform1i(p,2),P=C=2)):(b.uniform1i(p,0),P=C=0);for(var B=0,U=t.length;U>B;B++){var D=t[B];D.modelViewMatrix.multiplyMatrices(A.matrixWorldInverse,D.matrixWorld),D.z=-D.modelViewMatrix.elements[14]}t.sort(i);for(var I=[],B=0,U=t.length;U>B;B++){var D=t[B],O=D.material;b.uniform1f(g,O.alphaTest),b.uniformMatrix4fv(l,!1,D.modelViewMatrix.elements),D.matrixWorld.decompose(M,w,S),I[0]=S.x,I[1]=S.y,D=0,L.fog&&O.fog&&(D=P),C!==D&&(b.uniform1i(p,D),C=D),null!==O.map?(b.uniform2f(r,O.map.offset.x,O.map.offset.y),b.uniform2f(n,O.map.repeat.x,O.map.repeat.y)):(b.uniform2f(r,0,0),b.uniform2f(n,1,1)),b.uniform1f(h,O.opacity),b.uniform3f(s,O.color.r,O.color.g,O.color.b),b.uniform1f(o,O.rotation),b.uniform2fv(a,I),_.setBlending(O.blending,O.blendEquation,O.blendSrc,O.blendDst),_.setDepthTest(O.depthTest),_.setDepthWrite(O.depthWrite),O.map?e.setTexture2D(O.map,0):e.setTexture2D(H,0),b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0)}_.enable(b.CULL_FACE),e.resetGLState()}}},Object.assign(THREE,{Face4:function(e,t,i,r,n,o,a){return console.warn("THREE.Face4 has been removed. A THREE.Face3 will be created instead."),new THREE.Face3(e,t,i,n,o,a)},LineStrip:0,LinePieces:1,MeshFaceMaterial:THREE.MultiMaterial,PointCloud:function(e,t){return console.warn("THREE.PointCloud has been renamed to THREE.Points."),new THREE.Points(e,t)},Particle:THREE.Sprite,ParticleSystem:function(e,t){return console.warn("THREE.ParticleSystem has been renamed to THREE.Points."),new THREE.Points(e,t)},PointCloudMaterial:function(e){return console.warn("THREE.PointCloudMaterial has been renamed to THREE.PointsMaterial."),new THREE.PointsMaterial(e)},ParticleBasicMaterial:function(e){return console.warn("THREE.ParticleBasicMaterial has been renamed to THREE.PointsMaterial."),new THREE.PointsMaterial(e)},ParticleSystemMaterial:function(e){return console.warn("THREE.ParticleSystemMaterial has been renamed to THREE.PointsMaterial."),new THREE.PointsMaterial(e)},Vertex:function(e,t,i){return console.warn("THREE.Vertex has been removed. Use THREE.Vector3 instead."),new THREE.Vector3(e,t,i)}}),Object.assign(THREE.Box2.prototype,{empty:function(){return console.warn("THREE.Box2: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(e){return console.warn("THREE.Box2: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(e)}}),Object.assign(THREE.Box3.prototype,{empty:function(){return console.warn("THREE.Box3: .empty() has been renamed to .isEmpty()."),this.isEmpty()},isIntersectionBox:function(e){return console.warn("THREE.Box3: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(e)},isIntersectionSphere:function(e){return console.warn("THREE.Box3: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(e)}}),Object.assign(THREE.Matrix3.prototype,{multiplyVector3:function(e){return console.warn("THREE.Matrix3: .multiplyVector3() has been removed. Use vector.applyMatrix3( matrix ) instead."),e.applyMatrix3(this)},multiplyVector3Array:function(e){return console.warn("THREE.Matrix3: .multiplyVector3Array() has been renamed. Use matrix.applyToVector3Array( array ) instead."),this.applyToVector3Array(e)}}),Object.assign(THREE.Matrix4.prototype,{extractPosition:function(e){return console.warn("THREE.Matrix4: .extractPosition() has been renamed to .copyPosition()."),this.copyPosition(e)},setRotationFromQuaternion:function(e){return console.warn("THREE.Matrix4: .setRotationFromQuaternion() has been renamed to .makeRotationFromQuaternion()."),this.makeRotationFromQuaternion(e)},multiplyVector3:function(e){return console.warn("THREE.Matrix4: .multiplyVector3() has been removed. Use vector.applyMatrix4( matrix ) or vector.applyProjection( matrix ) instead."),e.applyProjection(this)},multiplyVector4:function(e){return console.warn("THREE.Matrix4: .multiplyVector4() has been removed. Use vector.applyMatrix4( matrix ) instead."),e.applyMatrix4(this)},multiplyVector3Array:function(e){return console.warn("THREE.Matrix4: .multiplyVector3Array() has been renamed. Use matrix.applyToVector3Array( array ) instead."),this.applyToVector3Array(e)},rotateAxis:function(e){console.warn("THREE.Matrix4: .rotateAxis() has been removed. Use Vector3.transformDirection( matrix ) instead."),e.transformDirection(this)},crossVector:function(e){return console.warn("THREE.Matrix4: .crossVector() has been removed. Use vector.applyMatrix4( matrix ) instead."),e.applyMatrix4(this)},translate:function(e){console.error("THREE.Matrix4: .translate() has been removed.")},rotateX:function(e){console.error("THREE.Matrix4: .rotateX() has been removed.")},rotateY:function(e){console.error("THREE.Matrix4: .rotateY() has been removed.")},rotateZ:function(e){console.error("THREE.Matrix4: .rotateZ() has been removed.")},rotateByAxis:function(e,t){console.error("THREE.Matrix4: .rotateByAxis() has been removed.")}}),Object.assign(THREE.Plane.prototype,{isIntersectionLine:function(e){return console.warn("THREE.Plane: .isIntersectionLine() has been renamed to .intersectsLine()."),this.intersectsLine(e)}}),Object.assign(THREE.Quaternion.prototype,{multiplyVector3:function(e){return console.warn("THREE.Quaternion: .multiplyVector3() has been removed. Use is now vector.applyQuaternion( quaternion ) instead."),e.applyQuaternion(this)}}),Object.assign(THREE.Ray.prototype,{isIntersectionBox:function(e){return console.warn("THREE.Ray: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(e)},isIntersectionPlane:function(e){return console.warn("THREE.Ray: .isIntersectionPlane() has been renamed to .intersectsPlane()."),this.intersectsPlane(e)},isIntersectionSphere:function(e){return console.warn("THREE.Ray: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(e)}}),Object.assign(THREE.Vector3.prototype,{setEulerFromRotationMatrix:function(){console.error("THREE.Vector3: .setEulerFromRotationMatrix() has been removed. Use Euler.setFromRotationMatrix() instead.")},setEulerFromQuaternion:function(){console.error("THREE.Vector3: .setEulerFromQuaternion() has been removed. Use Euler.setFromQuaternion() instead.")},getPositionFromMatrix:function(e){return console.warn("THREE.Vector3: .getPositionFromMatrix() has been renamed to .setFromMatrixPosition()."),this.setFromMatrixPosition(e)},getScaleFromMatrix:function(e){return console.warn("THREE.Vector3: .getScaleFromMatrix() has been renamed to .setFromMatrixScale()."),this.setFromMatrixScale(e)},getColumnFromMatrix:function(e,t){return console.warn("THREE.Vector3: .getColumnFromMatrix() has been renamed to .setFromMatrixColumn()."),
this.setFromMatrixColumn(t,e)}}),Object.assign(THREE.Object3D.prototype,{getChildByName:function(e){return console.warn("THREE.Object3D: .getChildByName() has been renamed to .getObjectByName()."),this.getObjectByName(e)},renderDepth:function(e){console.warn("THREE.Object3D: .renderDepth has been removed. Use .renderOrder, instead.")},translate:function(e,t){return console.warn("THREE.Object3D: .translate() has been removed. Use .translateOnAxis( axis, distance ) instead."),this.translateOnAxis(t,e)}}),Object.defineProperties(THREE.Object3D.prototype,{eulerOrder:{get:function(){return console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order},set:function(e){console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order=e}},useQuaternion:{get:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")},set:function(e){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")}}}),Object.defineProperties(THREE.LOD.prototype,{objects:{get:function(){return console.warn("THREE.LOD: .objects has been renamed to .levels."),this.levels}}}),THREE.PerspectiveCamera.prototype.setLens=function(e,t){console.warn("THREE.PerspectiveCamera.setLens is deprecated. Use .setFocalLength and .filmGauge for a photographic setup."),void 0!==t&&(this.filmGauge=t),this.setFocalLength(e)},Object.defineProperties(THREE.Light.prototype,{onlyShadow:{set:function(e){console.warn("THREE.Light: .onlyShadow has been removed.")}},shadowCameraFov:{set:function(e){console.warn("THREE.Light: .shadowCameraFov is now .shadow.camera.fov."),this.shadow.camera.fov=e}},shadowCameraLeft:{set:function(e){console.warn("THREE.Light: .shadowCameraLeft is now .shadow.camera.left."),this.shadow.camera.left=e}},shadowCameraRight:{set:function(e){console.warn("THREE.Light: .shadowCameraRight is now .shadow.camera.right."),this.shadow.camera.right=e}},shadowCameraTop:{set:function(e){console.warn("THREE.Light: .shadowCameraTop is now .shadow.camera.top."),this.shadow.camera.top=e}},shadowCameraBottom:{set:function(e){console.warn("THREE.Light: .shadowCameraBottom is now .shadow.camera.bottom."),this.shadow.camera.bottom=e}},shadowCameraNear:{set:function(e){console.warn("THREE.Light: .shadowCameraNear is now .shadow.camera.near."),this.shadow.camera.near=e}},shadowCameraFar:{set:function(e){console.warn("THREE.Light: .shadowCameraFar is now .shadow.camera.far."),this.shadow.camera.far=e}},shadowCameraVisible:{set:function(e){console.warn("THREE.Light: .shadowCameraVisible has been removed. Use new THREE.CameraHelper( light.shadow.camera ) instead.")}},shadowBias:{set:function(e){console.warn("THREE.Light: .shadowBias is now .shadow.bias."),this.shadow.bias=e}},shadowDarkness:{set:function(e){console.warn("THREE.Light: .shadowDarkness has been removed.")}},shadowMapWidth:{set:function(e){console.warn("THREE.Light: .shadowMapWidth is now .shadow.mapSize.width."),this.shadow.mapSize.width=e}},shadowMapHeight:{set:function(e){console.warn("THREE.Light: .shadowMapHeight is now .shadow.mapSize.height."),this.shadow.mapSize.height=e}}}),Object.defineProperties(THREE.BufferAttribute.prototype,{length:{get:function(){return console.warn("THREE.BufferAttribute: .length has been deprecated. Please use .count."),this.array.length}}}),Object.assign(THREE.BufferGeometry.prototype,{addIndex:function(e){console.warn("THREE.BufferGeometry: .addIndex() has been renamed to .setIndex()."),this.setIndex(e)},addDrawCall:function(e,t,i){void 0!==i&&console.warn("THREE.BufferGeometry: .addDrawCall() no longer supports indexOffset."),console.warn("THREE.BufferGeometry: .addDrawCall() is now .addGroup()."),this.addGroup(e,t)},clearDrawCalls:function(){console.warn("THREE.BufferGeometry: .clearDrawCalls() is now .clearGroups()."),this.clearGroups()},computeTangents:function(){console.warn("THREE.BufferGeometry: .computeTangents() has been removed.")},computeOffsets:function(){console.warn("THREE.BufferGeometry: .computeOffsets() has been removed.")}}),Object.defineProperties(THREE.BufferGeometry.prototype,{drawcalls:{get:function(){return console.error("THREE.BufferGeometry: .drawcalls has been renamed to .groups."),this.groups}},offsets:{get:function(){return console.warn("THREE.BufferGeometry: .offsets has been renamed to .groups."),this.groups}}}),Object.defineProperties(THREE.Material.prototype,{wrapAround:{get:function(){console.warn("THREE."+this.type+": .wrapAround has been removed.")},set:function(e){console.warn("THREE."+this.type+": .wrapAround has been removed.")}},wrapRGB:{get:function(){return console.warn("THREE."+this.type+": .wrapRGB has been removed."),new THREE.Color}}}),Object.defineProperties(THREE.MeshPhongMaterial.prototype,{metal:{get:function(){return console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead."),!1},set:function(e){console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead")}}}),Object.defineProperties(THREE.ShaderMaterial.prototype,{derivatives:{get:function(){return console.warn("THREE.ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives},set:function(e){console.warn("THREE. ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives=e}}}),THREE.EventDispatcher.prototype=Object.assign(Object.create({constructor:THREE.EventDispatcher,apply:function(e){console.warn("THREE.EventDispatcher: .apply is deprecated, just inherit or Object.assign the prototype to mix-in."),Object.assign(e,this)}}),THREE.EventDispatcher.prototype),Object.assign(THREE.WebGLRenderer.prototype,{supportsFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsFloatTextures() is now .extensions.get( 'OES_texture_float' )."),this.extensions.get("OES_texture_float")},supportsHalfFloatTextures:function(){return console.warn("THREE.WebGLRenderer: .supportsHalfFloatTextures() is now .extensions.get( 'OES_texture_half_float' )."),this.extensions.get("OES_texture_half_float")},supportsStandardDerivatives:function(){return console.warn("THREE.WebGLRenderer: .supportsStandardDerivatives() is now .extensions.get( 'OES_standard_derivatives' )."),this.extensions.get("OES_standard_derivatives")},supportsCompressedTextureS3TC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTextureS3TC() is now .extensions.get( 'WEBGL_compressed_texture_s3tc' )."),this.extensions.get("WEBGL_compressed_texture_s3tc")},supportsCompressedTexturePVRTC:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTexturePVRTC() is now .extensions.get( 'WEBGL_compressed_texture_pvrtc' )."),this.extensions.get("WEBGL_compressed_texture_pvrtc")},supportsBlendMinMax:function(){return console.warn("THREE.WebGLRenderer: .supportsBlendMinMax() is now .extensions.get( 'EXT_blend_minmax' )."),this.extensions.get("EXT_blend_minmax")},supportsVertexTextures:function(){return this.capabilities.vertexTextures},supportsInstancedArrays:function(){return console.warn("THREE.WebGLRenderer: .supportsInstancedArrays() is now .extensions.get( 'ANGLE_instanced_arrays' )."),this.extensions.get("ANGLE_instanced_arrays")},enableScissorTest:function(e){console.warn("THREE.WebGLRenderer: .enableScissorTest() is now .setScissorTest()."),this.setScissorTest(e)},initMaterial:function(){console.warn("THREE.WebGLRenderer: .initMaterial() has been removed.")},addPrePlugin:function(){console.warn("THREE.WebGLRenderer: .addPrePlugin() has been removed.")},addPostPlugin:function(){console.warn("THREE.WebGLRenderer: .addPostPlugin() has been removed.")},updateShadowMap:function(){console.warn("THREE.WebGLRenderer: .updateShadowMap() has been removed.")}}),Object.defineProperties(THREE.WebGLRenderer.prototype,{shadowMapEnabled:{get:function(){return this.shadowMap.enabled},set:function(e){console.warn("THREE.WebGLRenderer: .shadowMapEnabled is now .shadowMap.enabled."),this.shadowMap.enabled=e}},shadowMapType:{get:function(){return this.shadowMap.type},set:function(e){console.warn("THREE.WebGLRenderer: .shadowMapType is now .shadowMap.type."),this.shadowMap.type=e}},shadowMapCullFace:{get:function(){return this.shadowMap.cullFace},set:function(e){console.warn("THREE.WebGLRenderer: .shadowMapCullFace is now .shadowMap.cullFace."),this.shadowMap.cullFace=e}}}),Object.defineProperties(THREE.WebGLShadowMap.prototype,{cullFace:{get:function(){return this.renderReverseSided?THREE.CullFaceFront:THREE.CullFaceBack},set:function(e){e=e!==THREE.CullFaceBack,console.warn("WebGLRenderer: .shadowMap.cullFace is deprecated. Set .shadowMap.renderReverseSided to "+e+"."),this.renderReverseSided=e}}}),Object.defineProperties(THREE.WebGLRenderTarget.prototype,{wrapS:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS},set:function(e){console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS=e}},wrapT:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT},set:function(e){console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT=e}},magFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter},set:function(e){console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter=e}},minFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter},set:function(e){console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter=e}},anisotropy:{get:function(){return console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy},set:function(e){console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy=e}},offset:{get:function(){return console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset},set:function(e){console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset=e}},repeat:{get:function(){return console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat},set:function(e){console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat=e}},format:{get:function(){return console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format},set:function(e){console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format=e}},type:{get:function(){return console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type},set:function(e){console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type=e}},generateMipmaps:{get:function(){return console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps},set:function(e){console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps=e}}}),Object.assign(THREE.Audio.prototype,{load:function(e){console.warn("THREE.Audio: .load has been deprecated. Please use THREE.AudioLoader.");var t=this;return(new THREE.AudioLoader).load(e,function(e){t.setBuffer(e)}),this}}),Object.assign(THREE.AudioAnalyser.prototype,{getData:function(e){return console.warn("THREE.AudioAnalyser: .getData() is now .getFrequencyData()."),this.getFrequencyData()}}),THREE.GeometryUtils={merge:function(e,t,i){console.warn("THREE.GeometryUtils: .merge() has been moved to Geometry. Use geometry.merge( geometry2, matrix, materialIndexOffset ) instead.");var r;t instanceof THREE.Mesh&&(t.matrixAutoUpdate&&t.updateMatrix(),r=t.matrix,t=t.geometry),e.merge(t,r,i)},center:function(e){return console.warn("THREE.GeometryUtils: .center() has been moved to Geometry. Use geometry.center() instead."),e.center()}},THREE.ImageUtils={crossOrigin:void 0,loadTexture:function(e,t,i,r){console.warn("THREE.ImageUtils.loadTexture has been deprecated. Use THREE.TextureLoader() instead.");var n=new THREE.TextureLoader;return n.setCrossOrigin(this.crossOrigin),e=n.load(e,i,void 0,r),t&&(e.mapping=t),e},loadTextureCube:function(e,t,i,r){console.warn("THREE.ImageUtils.loadTextureCube has been deprecated. Use THREE.CubeTextureLoader() instead.");var n=new THREE.CubeTextureLoader;return n.setCrossOrigin(this.crossOrigin),e=n.load(e,i,void 0,r),t&&(e.mapping=t),e},loadCompressedTexture:function(){console.error("THREE.ImageUtils.loadCompressedTexture has been removed. Use THREE.DDSLoader instead.")},loadCompressedTextureCube:function(){console.error("THREE.ImageUtils.loadCompressedTextureCube has been removed. Use THREE.DDSLoader instead.")}},THREE.Projector=function(){console.error("THREE.Projector has been moved to /examples/js/renderers/Projector.js."),this.projectVector=function(e,t){console.warn("THREE.Projector: .projectVector() is now vector.project()."),e.project(t)},this.unprojectVector=function(e,t){console.warn("THREE.Projector: .unprojectVector() is now vector.unproject()."),e.unproject(t)},this.pickingRay=function(e,t){console.error("THREE.Projector: .pickingRay() is now raycaster.setFromCamera().")}},THREE.CanvasRenderer=function(){console.error("THREE.CanvasRenderer has been moved to /examples/js/renderers/CanvasRenderer.js"),this.domElement=document.createElement("canvas"),this.clear=function(){},this.render=function(){},this.setClearColor=function(){},this.setSize=function(){}},THREE.CurveUtils={tangentQuadraticBezier:function(e,t,i,r){return 2*(1-e)*(i-t)+2*e*(r-i)},tangentCubicBezier:function(e,t,i,r,n){return-3*t*(1-e)*(1-e)+3*i*(1-e)*(1-e)-6*e*i*(1-e)+6*e*r*(1-e)-3*e*e*r+3*e*e*n},tangentSpline:function(e,t,i,r,n){return 6*e*e-6*e+(3*e*e-4*e+1)+(-6*e*e+6*e)+(3*e*e-2*e)},interpolate:function(e,t,i,r,n){e=.5*(i-e),r=.5*(r-t);var o=n*n;return(2*t-2*i+e+r)*n*o+(-3*t+3*i-2*e-r)*o+e*n+t}},THREE.SceneUtils={createMultiMaterialObject:function(e,t){for(var i=new THREE.Group,r=0,n=t.length;n>r;r++)i.add(new THREE.Mesh(e,t[r]));return i},detach:function(e,t,i){e.applyMatrix(t.matrixWorld),t.remove(e),i.add(e)},attach:function(e,t,i){var r=new THREE.Matrix4;r.getInverse(i.matrixWorld),e.applyMatrix(r),t.remove(e),i.add(e)}},THREE.ShapeUtils={area:function(e){for(var t=e.length,i=0,r=t-1,n=0;t>n;r=n++)i+=e[r].x*e[n].y-e[n].x*e[r].y;return.5*i},triangulate:function(){return function(e,t){var i=e.length;if(3>i)return null;var r,n,o,a=[],s=[],c=[];if(0<THREE.ShapeUtils.area(e))for(n=0;i>n;n++)s[n]=n;else for(n=0;i>n;n++)s[n]=i-1-n;var h=2*i;for(n=i-1;i>2;){if(0>=h--){console.warn("THREE.ShapeUtils: Unable to triangulate polygon! in triangulate()");break}r=n,r>=i&&(r=0),n=r+1,n>=i&&(n=0),o=n+1,o>=i&&(o=0);var l;e:{var u=l=void 0,p=void 0,d=void 0,f=void 0,E=void 0,m=void 0,g=void 0,T=void 0,u=e[s[r]].x,p=e[s[r]].y,d=e[s[n]].x,f=e[s[n]].y,E=e[s[o]].x,m=e[s[o]].y;if(Number.EPSILON>(d-u)*(m-p)-(f-p)*(E-u))l=!1;else{var v=void 0,y=void 0,R=void 0,x=void 0,H=void 0,b=void 0,_=void 0,M=void 0,w=void 0,S=void 0,w=M=_=T=g=void 0,v=E-d,y=m-f,R=u-E,x=p-m,H=d-u,b=f-p;for(l=0;i>l;l++)if(g=e[s[l]].x,T=e[s[l]].y,!(g===u&&T===p||g===d&&T===f||g===E&&T===m)&&(_=g-u,M=T-p,w=g-d,S=T-f,g-=E,T-=m,w=v*S-y*w,_=H*M-b*_,M=R*T-x*g,w>=-Number.EPSILON&&M>=-Number.EPSILON&&_>=-Number.EPSILON)){l=!1;break e}l=!0}}if(l){for(a.push([e[s[r]],e[s[n]],e[s[o]]]),c.push([s[r],s[n],s[o]]),r=n,o=n+1;i>o;r++,o++)s[r]=s[o];i--,h=2*i}}return t?c:a}}(),triangulateShape:function(e,t){function i(e,t,i){return e.x!==t.x?e.x<t.x?e.x<=i.x&&i.x<=t.x:t.x<=i.x&&i.x<=e.x:e.y<t.y?e.y<=i.y&&i.y<=t.y:t.y<=i.y&&i.y<=e.y}function r(e,t,r,n,o){var a=t.x-e.x,s=t.y-e.y,c=n.x-r.x,h=n.y-r.y,l=e.x-r.x,u=e.y-r.y,p=s*c-a*h,d=s*l-a*u;if(Math.abs(p)>Number.EPSILON){if(p>0){if(0>d||d>p)return[];if(c=h*l-c*u,0>c||c>p)return[]}else{if(d>0||p>d)return[];if(c=h*l-c*u,c>0||p>c)return[]}return 0===c?!o||0!==d&&d!==p?[e]:[]:c===p?!o||0!==d&&d!==p?[t]:[]:0===d?[r]:d===p?[n]:(o=c/p,[{x:e.x+o*a,y:e.y+o*s}])}return 0!==d||h*l!==c*u?[]:(s=0===a&&0===s,c=0===c&&0===h,s&&c?e.x!==r.x||e.y!==r.y?[]:[e]:s?i(r,n,e)?[e]:[]:c?i(e,t,r)?[r]:[]:(0!==a?(e.x<t.x?(a=e,c=e.x,s=t,e=t.x):(a=t,c=t.x,s=e,e=e.x),r.x<n.x?(t=r,p=r.x,h=n,r=n.x):(t=n,p=n.x,h=r,r=r.x)):(e.y<t.y?(a=e,c=e.y,s=t,e=t.y):(a=t,c=t.y,s=e,e=e.y),r.y<n.y?(t=r,p=r.y,h=n,r=n.y):(t=n,p=n.y,h=r,r=r.y)),p>=c?p>e?[]:e===p?o?[]:[t]:r>=e?[t,s]:[t,h]:c>r?[]:c===r?o?[]:[a]:r>=e?[a,s]:[a,h]))}function n(e,t,i,r){var n=t.x-e.x,o=t.y-e.y;t=i.x-e.x,i=i.y-e.y;var a=r.x-e.x;return r=r.y-e.y,e=n*i-o*t,n=n*r-o*a,Math.abs(e)>Number.EPSILON?(t=a*i-r*t,e>0?n>=0&&t>=0:n>=0||t>=0):n>0}var o,a,s,c,h,l={};for(s=e.concat(),o=0,a=t.length;a>o;o++)Array.prototype.push.apply(s,t[o]);for(o=0,a=s.length;a>o;o++)h=s[o].x+":"+s[o].y,void 0!==l[h]&&console.warn("THREE.Shape: Duplicate point",h),l[h]=o;o=function(e,t){function i(e,t){var i=m.length-1,r=e-1;0>r&&(r=i);var o=e+1;return o>i&&(o=0),(i=n(m[e],m[r],m[o],s[t]))?(i=s.length-1,r=t-1,0>r&&(r=i),o=t+1,o>i&&(o=0),!!(i=n(s[t],s[r],s[o],m[e]))):!1}function o(e,t){var i,n;for(i=0;i<m.length;i++)if(n=i+1,n%=m.length,n=r(e,t,m[i],m[n],!0),0<n.length)return!0;return!1}function a(e,i){var n,o,a,s;for(n=0;n<g.length;n++)for(o=t[g[n]],a=0;a<o.length;a++)if(s=a+1,s%=o.length,s=r(e,i,o[a],o[s],!0),0<s.length)return!0;return!1}var s,c,h,l,u,p,d,f,E,m=e.concat(),g=[],T=[],v=0;for(c=t.length;c>v;v++)g.push(v);d=0;for(var y=2*g.length;0<g.length;){if(y--,0>y){console.log("Infinite Loop! Holes left:"+g.length+", Probably Hole outside Shape!");break}for(h=d;h<m.length;h++){for(l=m[h],c=-1,v=0;v<g.length;v++)if(u=g[v],p=l.x+":"+l.y+":"+u,void 0===T[p]){for(s=t[u],f=0;f<s.length;f++)if(u=s[f],i(h,f)&&!o(l,u)&&!a(l,u)){c=f,g.splice(v,1),d=m.slice(0,h+1),u=m.slice(h),f=s.slice(c),E=s.slice(0,c+1),m=d.concat(f).concat(E).concat(u),d=h;break}if(c>=0)break;T[p]=!0}if(c>=0)break}}return m}(e,t);var u=THREE.ShapeUtils.triangulate(o,!1);for(o=0,a=u.length;a>o;o++)for(c=u[o],s=0;3>s;s++)h=c[s].x+":"+c[s].y,h=l[h],void 0!==h&&(c[s]=h);return u.concat()},isClockWise:function(e){return 0>THREE.ShapeUtils.area(e)},b2:function(){return function(e,t,i,r){var n=1-e;return n*n*t+2*(1-e)*e*i+e*e*r}}(),b3:function(){return function(e,t,i,r,n){var o=1-e,a=1-e;return o*o*o*t+3*a*a*e*i+3*(1-e)*e*e*r+e*e*e*n}}()},THREE.Curve=function(){},THREE.Curve.prototype={constructor:THREE.Curve,getPoint:function(e){return console.warn("THREE.Curve: Warning, getPoint() not implemented!"),null},getPointAt:function(e){return e=this.getUtoTmapping(e),this.getPoint(e)},getPoints:function(e){e||(e=5);var t,i=[];for(t=0;e>=t;t++)i.push(this.getPoint(t/e));return i},getSpacedPoints:function(e){e||(e=5);var t,i=[];for(t=0;e>=t;t++)i.push(this.getPointAt(t/e));return i},getLength:function(){var e=this.getLengths();return e[e.length-1]},getLengths:function(e){if(e||(e=this.__arcLengthDivisions?this.__arcLengthDivisions:200),this.cacheArcLengths&&this.cacheArcLengths.length===e+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;var t,i,r=[],n=this.getPoint(0),o=0;for(r.push(0),i=1;e>=i;i++)t=this.getPoint(i/e),o+=t.distanceTo(n),r.push(o),n=t;return this.cacheArcLengths=r},updateArcLengths:function(){this.needsUpdate=!0,this.getLengths()},getUtoTmapping:function(e,t){var i,r=this.getLengths(),n=0,o=r.length;i=t?t:e*r[o-1];for(var a,s=0,c=o-1;c>=s;)if(n=Math.floor(s+(c-s)/2),a=r[n]-i,0>a)s=n+1;else{if(!(a>0)){c=n;break}c=n-1}return n=c,r[n]===i?n/(o-1):(s=r[n],r=(n+(i-s)/(r[n+1]-s))/(o-1))},getTangent:function(e){var t=e-1e-4;return e+=1e-4,0>t&&(t=0),e>1&&(e=1),t=this.getPoint(t),this.getPoint(e).clone().sub(t).normalize()},getTangentAt:function(e){return e=this.getUtoTmapping(e),this.getTangent(e)}},THREE.Curve.create=function(e,t){return e.prototype=Object.create(THREE.Curve.prototype),e.prototype.constructor=e,e.prototype.getPoint=t,e},THREE.CurvePath=function(){this.curves=[],this.autoClose=!1},THREE.CurvePath.prototype=Object.assign(Object.create(THREE.Curve.prototype),{constructor:THREE.CurvePath,add:function(e){this.curves.push(e)},closePath:function(){var e=this.curves[0].getPoint(0),t=this.curves[this.curves.length-1].getPoint(1);e.equals(t)||this.curves.push(new THREE.LineCurve(t,e))},getPoint:function(e){for(var t=e*this.getLength(),i=this.getCurveLengths(),r=0;r<i.length;){if(i[r]>=t)return e=this.curves[r],t=1-(i[r]-t)/e.getLength(),e.getPointAt(t);r++}return null},getLength:function(){var e=this.getCurveLengths();return e[e.length-1]},getCurveLengths:function(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;for(var e=[],t=0,i=0,r=this.curves.length;r>i;i++)t+=this.curves[i].getLength(),e.push(t);return this.cacheLengths=e},createPointsGeometry:function(e){return e=this.getPoints(e),this.createGeometry(e)},createSpacedPointsGeometry:function(e){return e=this.getSpacedPoints(e),this.createGeometry(e)},createGeometry:function(e){for(var t=new THREE.Geometry,i=0,r=e.length;r>i;i++){var n=e[i];t.vertices.push(new THREE.Vector3(n.x,n.y,n.z||0))}return t}}),THREE.Font=function(e){this.data=e},Object.assign(THREE.Font.prototype,{generateShapes:function(e,t,i){void 0===t&&(t=100),void 0===i&&(i=4);var r=this.data;e=String(e).split("");var n=t/r.resolution,o=0;t=[];for(var a=0;a<e.length;a++){var s;s=n;var c=o,h=r.glyphs[e[a]]||r.glyphs["?"];if(h){var l=new THREE.Path,u=[],p=THREE.ShapeUtils.b2,d=THREE.ShapeUtils.b3,f=void 0,E=void 0,m=E=f=void 0,g=void 0,T=void 0,v=void 0,y=void 0,R=void 0,g=void 0;if(h.o)for(var x=h._cachedOutline||(h._cachedOutline=h.o.split(" ")),H=0,b=x.length;b>H;)switch(x[H++]){case"m":f=x[H++]*s+c,E=x[H++]*s,l.moveTo(f,E);break;case"l":f=x[H++]*s+c,E=x[H++]*s,l.lineTo(f,E);break;case"q":if(f=x[H++]*s+c,E=x[H++]*s,T=x[H++]*s+c,v=x[H++]*s,l.quadraticCurveTo(T,v,f,E),g=u[u.length-1])for(var m=g.x,g=g.y,_=1;i>=_;_++){var M=_/i;p(M,m,T,f),p(M,g,v,E)}break;case"b":if(f=x[H++]*s+c,E=x[H++]*s,T=x[H++]*s+c,v=x[H++]*s,y=x[H++]*s+c,R=x[H++]*s,l.bezierCurveTo(T,v,y,R,f,E),g=u[u.length-1])for(m=g.x,g=g.y,_=1;i>=_;_++)M=_/i,d(M,m,T,y,f),d(M,g,v,R,E)}s={offset:h.ha*s,path:l}}else s=void 0;o+=s.offset,t.push(s.path)}for(i=[],r=0,e=t.length;e>r;r++)Array.prototype.push.apply(i,t[r].toShapes());return i}}),THREE.Path=function(e){THREE.CurvePath.call(this),this.actions=[],e&&this.fromPoints(e)},THREE.Path.prototype=Object.assign(Object.create(THREE.CurvePath.prototype),{constructor:THREE.Path,fromPoints:function(e){this.moveTo(e[0].x,e[0].y);for(var t=1,i=e.length;i>t;t++)this.lineTo(e[t].x,e[t].y)},moveTo:function(e,t){this.actions.push({action:"moveTo",args:[e,t]})},lineTo:function(e,t){var i=this.actions[this.actions.length-1].args,i=new THREE.LineCurve(new THREE.Vector2(i[i.length-2],i[i.length-1]),new THREE.Vector2(e,t));this.curves.push(i),this.actions.push({action:"lineTo",args:[e,t]})},quadraticCurveTo:function(e,t,i,r){var n=this.actions[this.actions.length-1].args,n=new THREE.QuadraticBezierCurve(new THREE.Vector2(n[n.length-2],n[n.length-1]),new THREE.Vector2(e,t),new THREE.Vector2(i,r));this.curves.push(n),this.actions.push({action:"quadraticCurveTo",args:[e,t,i,r]})},bezierCurveTo:function(e,t,i,r,n,o){var a=this.actions[this.actions.length-1].args,a=new THREE.CubicBezierCurve(new THREE.Vector2(a[a.length-2],a[a.length-1]),new THREE.Vector2(e,t),new THREE.Vector2(i,r),new THREE.Vector2(n,o));this.curves.push(a),this.actions.push({action:"bezierCurveTo",args:[e,t,i,r,n,o]})},splineThru:function(e){var t=Array.prototype.slice.call(arguments),i=this.actions[this.actions.length-1].args,i=[new THREE.Vector2(i[i.length-2],i[i.length-1])];Array.prototype.push.apply(i,e),i=new THREE.SplineCurve(i),this.curves.push(i),this.actions.push({action:"splineThru",args:t})},arc:function(e,t,i,r,n,o){var a=this.actions[this.actions.length-1].args;this.absarc(e+a[a.length-2],t+a[a.length-1],i,r,n,o)},absarc:function(e,t,i,r,n,o){this.absellipse(e,t,i,i,r,n,o)},ellipse:function(e,t,i,r,n,o,a,s){var c=this.actions[this.actions.length-1].args;this.absellipse(e+c[c.length-2],t+c[c.length-1],i,r,n,o,a,s)},absellipse:function(e,t,i,r,n,o,a,s){var c=[e,t,i,r,n,o,a,s||0];e=new THREE.EllipseCurve(e,t,i,r,n,o,a,s),this.curves.push(e),e=e.getPoint(1),c.push(e.x),c.push(e.y),this.actions.push({action:"ellipse",args:c})},getSpacedPoints:function(e){e||(e=40);for(var t=[],i=0;e>i;i++)t.push(this.getPoint(i/e));return this.autoClose&&t.push(t[0]),t},getPoints:function(e){e=e||12;for(var t,i,r,n,o,a,s,c,h,l,u=THREE.ShapeUtils.b2,p=THREE.ShapeUtils.b3,d=[],f=0,E=this.actions.length;E>f;f++){h=this.actions[f];var m=h.args;switch(h.action){case"moveTo":d.push(new THREE.Vector2(m[0],m[1]));break;case"lineTo":d.push(new THREE.Vector2(m[0],m[1]));break;case"quadraticCurveTo":for(t=m[2],i=m[3],o=m[0],a=m[1],0<d.length?(h=d[d.length-1],s=h.x,c=h.y):(h=this.actions[f-1].args,s=h[h.length-2],c=h[h.length-1]),m=1;e>=m;m++)l=m/e,h=u(l,s,o,t),l=u(l,c,a,i),d.push(new THREE.Vector2(h,l));break;case"bezierCurveTo":for(t=m[4],i=m[5],o=m[0],a=m[1],r=m[2],n=m[3],0<d.length?(h=d[d.length-1],s=h.x,c=h.y):(h=this.actions[f-1].args,s=h[h.length-2],c=h[h.length-1]),m=1;e>=m;m++)l=m/e,h=p(l,s,o,r,t),l=p(l,c,a,n,i),d.push(new THREE.Vector2(h,l));break;case"splineThru":for(h=this.actions[f-1].args,l=[new THREE.Vector2(h[h.length-2],h[h.length-1])],h=e*m[0].length,l=l.concat(m[0]),l=new THREE.SplineCurve(l),m=1;h>=m;m++)d.push(l.getPointAt(m/h));break;case"arc":for(t=m[0],i=m[1],a=m[2],r=m[3],h=m[4],o=!!m[5],s=h-r,c=2*e,m=1;c>=m;m++)l=m/c,o||(l=1-l),l=r+l*s,h=t+a*Math.cos(l),l=i+a*Math.sin(l),d.push(new THREE.Vector2(h,l));break;case"ellipse":t=m[0],i=m[1],a=m[2],n=m[3],r=m[4],h=m[5],o=!!m[6];var g=m[7];s=h-r,c=2*e;var T,v;for(0!==g&&(T=Math.cos(g),v=Math.sin(g)),m=1;c>=m;m++){if(l=m/c,o||(l=1-l),l=r+l*s,h=t+a*Math.cos(l),l=i+n*Math.sin(l),0!==g){var y=h;h=(y-t)*T-(l-i)*v+t,l=(y-t)*v+(l-i)*T+i}d.push(new THREE.Vector2(h,l))}}}return e=d[d.length-1],Math.abs(e.x-d[0].x)<Number.EPSILON&&Math.abs(e.y-d[0].y)<Number.EPSILON&&d.splice(d.length-1,1),this.autoClose&&d.push(d[0]),d},toShapes:function(e,t){function i(e){for(var t=[],i=0,r=e.length;r>i;i++){var n=e[i],o=new THREE.Shape;o.actions=n.actions,o.curves=n.curves,t.push(o)}return t}function r(e,t){for(var i=t.length,r=!1,n=i-1,o=0;i>o;n=o++){var a=t[n],s=t[o],c=s.x-a.x,h=s.y-a.y;if(Math.abs(h)>Number.EPSILON){if(0>h&&(a=t[o],c=-c,s=t[n],h=-h),!(e.y<a.y||e.y>s.y))if(e.y===a.y){if(e.x===a.x)return!0}else{if(n=h*(e.x-a.x)-c*(e.y-a.y),0===n)return!0;0>n||(r=!r)}}else if(e.y===a.y&&(s.x<=e.x&&e.x<=a.x||a.x<=e.x&&e.x<=s.x))return!0}return r}var n=THREE.ShapeUtils.isClockWise,o=function(e){for(var t=[],i=new THREE.Path,r=0,n=e.length;n>r;r++){var o=e[r],a=o.args,o=o.action;"moveTo"===o&&0!==i.actions.length&&(t.push(i),i=new THREE.Path),i[o].apply(i,a)}return 0!==i.actions.length&&t.push(i),t}(this.actions);if(0===o.length)return[];if(!0===t)return i(o);var a,s,c,h=[];if(1===o.length)return s=o[0],c=new THREE.Shape,c.actions=s.actions,c.curves=s.curves,h.push(c),h;var l=!n(o[0].getPoints()),l=e?!l:l;c=[];var u,p=[],d=[],f=0;p[f]=void 0,d[f]=[];for(var E=0,m=o.length;m>E;E++)s=o[E],u=s.getPoints(),a=n(u),(a=e?!a:a)?(!l&&p[f]&&f++,p[f]={s:new THREE.Shape,p:u},p[f].s.actions=s.actions,p[f].s.curves=s.curves,l&&f++,d[f]=[]):d[f].push({h:s,p:u[0]});if(!p[0])return i(o);if(1<p.length){for(E=!1,s=[],n=0,o=p.length;o>n;n++)c[n]=[];for(n=0,o=p.length;o>n;n++)for(a=d[n],l=0;l<a.length;l++){for(f=a[l],u=!0,m=0;m<p.length;m++)r(f.p,p[m].p)&&(n!==m&&s.push({froms:n,tos:m,hole:l}),u?(u=!1,c[m].push(f)):E=!0);u&&c[n].push(f)}0<s.length&&(E||(d=c))}for(E=0,n=p.length;n>E;E++)for(c=p[E].s,h.push(c),s=d[E],o=0,a=s.length;a>o;o++)c.holes.push(s[o].h);return h}}),THREE.Shape=function(){THREE.Path.apply(this,arguments),this.holes=[]},THREE.Shape.prototype=Object.assign(Object.create(THREE.Path.prototype),{constructor:THREE.Shape,extrude:function(e){return new THREE.ExtrudeGeometry(this,e)},makeGeometry:function(e){return new THREE.ShapeGeometry(this,e)},getPointsHoles:function(e){for(var t=[],i=0,r=this.holes.length;r>i;i++)t[i]=this.holes[i].getPoints(e);return t},extractAllPoints:function(e){return{shape:this.getPoints(e),holes:this.getPointsHoles(e)}},extractPoints:function(e){return this.extractAllPoints(e)}}),THREE.LineCurve=function(e,t){this.v1=e,this.v2=t},THREE.LineCurve.prototype=Object.create(THREE.Curve.prototype),THREE.LineCurve.prototype.constructor=THREE.LineCurve,THREE.LineCurve.prototype.getPoint=function(e){var t=this.v2.clone().sub(this.v1);return t.multiplyScalar(e).add(this.v1),t},THREE.LineCurve.prototype.getPointAt=function(e){return this.getPoint(e)},THREE.LineCurve.prototype.getTangent=function(e){return this.v2.clone().sub(this.v1).normalize()},THREE.QuadraticBezierCurve=function(e,t,i){this.v0=e,this.v1=t,this.v2=i},THREE.QuadraticBezierCurve.prototype=Object.create(THREE.Curve.prototype),THREE.QuadraticBezierCurve.prototype.constructor=THREE.QuadraticBezierCurve,THREE.QuadraticBezierCurve.prototype.getPoint=function(e){var t=THREE.ShapeUtils.b2;return new THREE.Vector2(t(e,this.v0.x,this.v1.x,this.v2.x),t(e,this.v0.y,this.v1.y,this.v2.y))},THREE.QuadraticBezierCurve.prototype.getTangent=function(e){var t=THREE.CurveUtils.tangentQuadraticBezier;return new THREE.Vector2(t(e,this.v0.x,this.v1.x,this.v2.x),t(e,this.v0.y,this.v1.y,this.v2.y)).normalize()},THREE.CubicBezierCurve=function(e,t,i,r){this.v0=e,this.v1=t,this.v2=i,this.v3=r},THREE.CubicBezierCurve.prototype=Object.create(THREE.Curve.prototype),THREE.CubicBezierCurve.prototype.constructor=THREE.CubicBezierCurve,THREE.CubicBezierCurve.prototype.getPoint=function(e){var t=THREE.ShapeUtils.b3;return new THREE.Vector2(t(e,this.v0.x,this.v1.x,this.v2.x,this.v3.x),t(e,this.v0.y,this.v1.y,this.v2.y,this.v3.y))},THREE.CubicBezierCurve.prototype.getTangent=function(e){var t=THREE.CurveUtils.tangentCubicBezier;return new THREE.Vector2(t(e,this.v0.x,this.v1.x,this.v2.x,this.v3.x),t(e,this.v0.y,this.v1.y,this.v2.y,this.v3.y)).normalize()},THREE.SplineCurve=function(e){this.points=void 0==e?[]:e},THREE.SplineCurve.prototype=Object.create(THREE.Curve.prototype),THREE.SplineCurve.prototype.constructor=THREE.SplineCurve,THREE.SplineCurve.prototype.getPoint=function(e){var t=this.points;e*=t.length-1;var i=Math.floor(e);e-=i;var r=t[0===i?i:i-1],n=t[i],o=t[i>t.length-2?t.length-1:i+1],t=t[i>t.length-3?t.length-1:i+2],i=THREE.CurveUtils.interpolate;return new THREE.Vector2(i(r.x,n.x,o.x,t.x,e),i(r.y,n.y,o.y,t.y,e))},THREE.EllipseCurve=function(e,t,i,r,n,o,a,s){this.aX=e,this.aY=t,this.xRadius=i,this.yRadius=r,this.aStartAngle=n,this.aEndAngle=o,this.aClockwise=a,this.aRotation=s||0},THREE.EllipseCurve.prototype=Object.create(THREE.Curve.prototype),THREE.EllipseCurve.prototype.constructor=THREE.EllipseCurve,THREE.EllipseCurve.prototype.getPoint=function(e){var t=this.aEndAngle-this.aStartAngle;0>t&&(t+=2*Math.PI),t>2*Math.PI&&(t-=2*Math.PI),t=!0===this.aClockwise?this.aEndAngle+(1-e)*(2*Math.PI-t):this.aStartAngle+e*t,e=this.aX+this.xRadius*Math.cos(t);var i=this.aY+this.yRadius*Math.sin(t);if(0!==this.aRotation){var t=Math.cos(this.aRotation),r=Math.sin(this.aRotation),n=e;e=(n-this.aX)*t-(i-this.aY)*r+this.aX,i=(n-this.aX)*r+(i-this.aY)*t+this.aY}return new THREE.Vector2(e,i)},THREE.ArcCurve=function(e,t,i,r,n,o){THREE.EllipseCurve.call(this,e,t,i,i,r,n,o)},THREE.ArcCurve.prototype=Object.create(THREE.EllipseCurve.prototype),THREE.ArcCurve.prototype.constructor=THREE.ArcCurve,THREE.LineCurve3=THREE.Curve.create(function(e,t){this.v1=e,this.v2=t},function(e){var t=new THREE.Vector3;return t.subVectors(this.v2,this.v1),t.multiplyScalar(e),t.add(this.v1),t}),THREE.QuadraticBezierCurve3=THREE.Curve.create(function(e,t,i){this.v0=e,this.v1=t,this.v2=i},function(e){var t=THREE.ShapeUtils.b2;return new THREE.Vector3(t(e,this.v0.x,this.v1.x,this.v2.x),t(e,this.v0.y,this.v1.y,this.v2.y),t(e,this.v0.z,this.v1.z,this.v2.z));
}),THREE.CubicBezierCurve3=THREE.Curve.create(function(e,t,i,r){this.v0=e,this.v1=t,this.v2=i,this.v3=r},function(e){var t=THREE.ShapeUtils.b3;return new THREE.Vector3(t(e,this.v0.x,this.v1.x,this.v2.x,this.v3.x),t(e,this.v0.y,this.v1.y,this.v2.y,this.v3.y),t(e,this.v0.z,this.v1.z,this.v2.z,this.v3.z))}),THREE.SplineCurve3=THREE.Curve.create(function(e){console.warn("THREE.SplineCurve3 will be deprecated. Please use THREE.CatmullRomCurve3"),this.points=void 0==e?[]:e},function(e){var t=this.points;e*=t.length-1;var i=Math.floor(e);e-=i;var r=t[0==i?i:i-1],n=t[i],o=t[i>t.length-2?t.length-1:i+1],t=t[i>t.length-3?t.length-1:i+2],i=THREE.CurveUtils.interpolate;return new THREE.Vector3(i(r.x,n.x,o.x,t.x,e),i(r.y,n.y,o.y,t.y,e),i(r.z,n.z,o.z,t.z,e))}),THREE.CatmullRomCurve3=function(){function e(){}var t=new THREE.Vector3,i=new e,r=new e,n=new e;return e.prototype.init=function(e,t,i,r){this.c0=e,this.c1=i,this.c2=-3*e+3*t-2*i-r,this.c3=2*e-2*t+i+r},e.prototype.initNonuniformCatmullRom=function(e,t,i,r,n,o,a){e=((t-e)/n-(i-e)/(n+o)+(i-t)/o)*o,r=((i-t)/o-(r-t)/(o+a)+(r-i)/a)*o,this.init(t,i,e,r)},e.prototype.initCatmullRom=function(e,t,i,r,n){this.init(t,i,n*(i-e),n*(r-t))},e.prototype.calc=function(e){var t=e*e;return this.c0+this.c1*e+this.c2*t+this.c3*t*e},THREE.Curve.create(function(e){this.points=e||[],this.closed=!1},function(e){var o,a,s=this.points;a=s.length,2>a&&console.log("duh, you need at least 2 points"),e*=a-(this.closed?0:1),o=Math.floor(e),e-=o,this.closed?o+=o>0?0:(Math.floor(Math.abs(o)/s.length)+1)*s.length:0===e&&o===a-1&&(o=a-2,e=1);var c,h,l;if(this.closed||o>0?c=s[(o-1)%a]:(t.subVectors(s[0],s[1]).add(s[0]),c=t),h=s[o%a],l=s[(o+1)%a],this.closed||a>o+2?s=s[(o+2)%a]:(t.subVectors(s[a-1],s[a-2]).add(s[a-1]),s=t),void 0===this.type||"centripetal"===this.type||"chordal"===this.type){var u="chordal"===this.type?.5:.25;a=Math.pow(c.distanceToSquared(h),u),o=Math.pow(h.distanceToSquared(l),u),u=Math.pow(l.distanceToSquared(s),u),1e-4>o&&(o=1),1e-4>a&&(a=o),1e-4>u&&(u=o),i.initNonuniformCatmullRom(c.x,h.x,l.x,s.x,a,o,u),r.initNonuniformCatmullRom(c.y,h.y,l.y,s.y,a,o,u),n.initNonuniformCatmullRom(c.z,h.z,l.z,s.z,a,o,u)}else"catmullrom"===this.type&&(a=void 0!==this.tension?this.tension:.5,i.initCatmullRom(c.x,h.x,l.x,s.x,a),r.initCatmullRom(c.y,h.y,l.y,s.y,a),n.initCatmullRom(c.z,h.z,l.z,s.z,a));return new THREE.Vector3(i.calc(e),r.calc(e),n.calc(e))})}(),THREE.ClosedSplineCurve3=function(e){console.warn("THREE.ClosedSplineCurve3 has been deprecated. Please use THREE.CatmullRomCurve3."),THREE.CatmullRomCurve3.call(this,e),this.type="catmullrom",this.closed=!0},THREE.ClosedSplineCurve3.prototype=Object.create(THREE.CatmullRomCurve3.prototype),THREE.BoxGeometry=function(e,t,i,r,n,o){THREE.Geometry.call(this),this.type="BoxGeometry",this.parameters={width:e,height:t,depth:i,widthSegments:r,heightSegments:n,depthSegments:o},this.fromBufferGeometry(new THREE.BoxBufferGeometry(e,t,i,r,n,o)),this.mergeVertices()},THREE.BoxGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.BoxGeometry.prototype.constructor=THREE.BoxGeometry,THREE.CubeGeometry=THREE.BoxGeometry,THREE.BoxBufferGeometry=function(e,t,i,r,n,o){function a(e,t,i,r,n,o,a,c,h,v,y){var R=o/h,x=a/v,H=o/2,b=a/2,_=c/2;a=h+1;for(var M=v+1,w=o=0,S=new THREE.Vector3,L=0;M>L;L++)for(var A=L*x-b,C=0;a>C;C++)S[e]=(C*R-H)*r,S[t]=A*n,S[i]=_,u[f]=S.x,u[f+1]=S.y,u[f+2]=S.z,S[e]=0,S[t]=0,S[i]=c>0?1:-1,p[f]=S.x,p[f+1]=S.y,p[f+2]=S.z,d[E]=C/h,d[E+1]=1-L/v,f+=3,E+=2,o+=1;for(L=0;v>L;L++)for(C=0;h>C;C++)e=g+C+a*(L+1),t=g+(C+1)+a*(L+1),i=g+(C+1)+a*L,l[m]=g+C+a*L,l[m+1]=e,l[m+2]=i,l[m+3]=e,l[m+4]=t,l[m+5]=i,m+=6,w+=6;s.addGroup(T,w,y),T+=w,g+=o}THREE.BufferGeometry.call(this),this.type="BoxBufferGeometry",this.parameters={width:e,height:t,depth:i,widthSegments:r,heightSegments:n,depthSegments:o};var s=this;r=Math.floor(r)||1,n=Math.floor(n)||1,o=Math.floor(o)||1;var c=function(e,t,i){return e=0+(e+1)*(t+1)*2+(e+1)*(i+1)*2,e+=(i+1)*(t+1)*2}(r,n,o),h=function(e,t,i){return e=0+e*t*2+e*i*2,e+=i*t*2,6*e}(r,n,o),l=new(h>65535?Uint32Array:Uint16Array)(h),u=new Float32Array(3*c),p=new Float32Array(3*c),d=new Float32Array(2*c),f=0,E=0,m=0,g=0,T=0;a("z","y","x",-1,-1,i,t,e,o,n,0),a("z","y","x",1,-1,i,t,-e,o,n,1),a("x","z","y",1,1,e,i,t,r,o,2),a("x","z","y",1,-1,e,i,-t,r,o,3),a("x","y","z",1,-1,e,t,i,r,n,4),a("x","y","z",-1,-1,e,t,-i,r,n,5),this.setIndex(new THREE.BufferAttribute(l,1)),this.addAttribute("position",new THREE.BufferAttribute(u,3)),this.addAttribute("normal",new THREE.BufferAttribute(p,3)),this.addAttribute("uv",new THREE.BufferAttribute(d,2))},THREE.BoxBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.BoxBufferGeometry.prototype.constructor=THREE.BoxBufferGeometry,THREE.CircleGeometry=function(e,t,i,r){THREE.Geometry.call(this),this.type="CircleGeometry",this.parameters={radius:e,segments:t,thetaStart:i,thetaLength:r},this.fromBufferGeometry(new THREE.CircleBufferGeometry(e,t,i,r))},THREE.CircleGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.CircleGeometry.prototype.constructor=THREE.CircleGeometry,THREE.CircleBufferGeometry=function(e,t,i,r){THREE.BufferGeometry.call(this),this.type="CircleBufferGeometry",this.parameters={radius:e,segments:t,thetaStart:i,thetaLength:r},e=e||50,t=void 0!==t?Math.max(3,t):8,i=void 0!==i?i:0,r=void 0!==r?r:2*Math.PI;var n=t+2,o=new Float32Array(3*n),a=new Float32Array(3*n),n=new Float32Array(2*n);a[2]=1,n[0]=.5,n[1]=.5;for(var s=0,c=3,h=2;t>=s;s++,c+=3,h+=2){var l=i+s/t*r;o[c]=e*Math.cos(l),o[c+1]=e*Math.sin(l),a[c+2]=1,n[h]=(o[c]/e+1)/2,n[h+1]=(o[c+1]/e+1)/2}for(i=[],c=1;t>=c;c++)i.push(c,c+1,0);this.setIndex(new THREE.BufferAttribute(new Uint16Array(i),1)),this.addAttribute("position",new THREE.BufferAttribute(o,3)),this.addAttribute("normal",new THREE.BufferAttribute(a,3)),this.addAttribute("uv",new THREE.BufferAttribute(n,2)),this.boundingSphere=new THREE.Sphere(new THREE.Vector3,e)},THREE.CircleBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.CircleBufferGeometry.prototype.constructor=THREE.CircleBufferGeometry,THREE.CylinderBufferGeometry=function(e,t,i,r,n,o,a,s){function c(i){var n,o,c,l=new THREE.Vector2,u=new THREE.Vector3,p=0,v=!0===i?e:t,x=!0===i?1:-1;for(o=g,n=1;r>=n;n++)f.setXYZ(g,0,y*x,0),E.setXYZ(g,0,x,0),l.x=.5,l.y=.5,m.setXY(g,l.x,l.y),g++;for(c=g,n=0;r>=n;n++){var H=n/r*s+a,b=Math.cos(H),H=Math.sin(H);u.x=v*H,u.y=y*x,u.z=v*b,f.setXYZ(g,u.x,u.y,u.z),E.setXYZ(g,0,x,0),l.x=.5*b+.5,l.y=.5*H*x+.5,m.setXY(g,l.x,l.y),g++}for(n=0;r>n;n++)l=o+n,u=c+n,!0===i?(d.setX(T,u),T++,d.setX(T,u+1)):(d.setX(T,u+1),T++,d.setX(T,u)),T++,d.setX(T,l),T++,p+=3;h.addGroup(R,p,!0===i?1:2),R+=p}THREE.BufferGeometry.call(this),this.type="CylinderBufferGeometry",this.parameters={radiusTop:e,radiusBottom:t,height:i,radialSegments:r,heightSegments:n,openEnded:o,thetaStart:a,thetaLength:s};var h=this;e=void 0!==e?e:20,t=void 0!==t?t:20,i=void 0!==i?i:100,r=Math.floor(r)||8,n=Math.floor(n)||1,o=void 0!==o?o:!1,a=void 0!==a?a:0,s=void 0!==s?s:2*Math.PI;var l=0;!1===o&&(e>0&&l++,t>0&&l++);var u=function(){var e=(r+1)*(n+1);return!1===o&&(e+=(r+1)*l+r*l),e}(),p=function(){var e=r*n*6;return!1===o&&(e+=r*l*3),e}(),d=new THREE.BufferAttribute(new(p>65535?Uint32Array:Uint16Array)(p),1),f=new THREE.BufferAttribute(new Float32Array(3*u),3),E=new THREE.BufferAttribute(new Float32Array(3*u),3),m=new THREE.BufferAttribute(new Float32Array(2*u),2),g=0,T=0,v=[],y=i/2,R=0;!function(){var o,c,l=new THREE.Vector3,u=new THREE.Vector3,p=0,x=(t-e)/i;for(c=0;n>=c;c++){var H=[],b=c/n,_=b*(t-e)+e;for(o=0;r>=o;o++){var M=o/r;u.x=_*Math.sin(M*s+a),u.y=-b*i+y,u.z=_*Math.cos(M*s+a),f.setXYZ(g,u.x,u.y,u.z),l.copy(u),(0===e&&0===c||0===t&&c===n)&&(l.x=Math.sin(M*s+a),l.z=Math.cos(M*s+a)),l.setY(Math.sqrt(l.x*l.x+l.z*l.z)*x).normalize(),E.setXYZ(g,l.x,l.y,l.z),m.setXY(g,M,1-b),H.push(g),g++}v.push(H)}for(o=0;r>o;o++)for(c=0;n>c;c++)l=v[c+1][o],u=v[c+1][o+1],x=v[c][o+1],d.setX(T,v[c][o]),T++,d.setX(T,l),T++,d.setX(T,x),T++,d.setX(T,l),T++,d.setX(T,u),T++,d.setX(T,x),T++,p+=6;h.addGroup(R,p,0),R+=p}(),!1===o&&(e>0&&c(!0),t>0&&c(!1)),this.setIndex(d),this.addAttribute("position",f),this.addAttribute("normal",E),this.addAttribute("uv",m)},THREE.CylinderBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.CylinderBufferGeometry.prototype.constructor=THREE.CylinderBufferGeometry,THREE.CylinderGeometry=function(e,t,i,r,n,o,a,s){THREE.Geometry.call(this),this.type="CylinderGeometry",this.parameters={radiusTop:e,radiusBottom:t,height:i,radialSegments:r,heightSegments:n,openEnded:o,thetaStart:a,thetaLength:s},this.fromBufferGeometry(new THREE.CylinderBufferGeometry(e,t,i,r,n,o,a,s)),this.mergeVertices()},THREE.CylinderGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry,THREE.ConeBufferGeometry=function(e,t,i,r,n,o,a){THREE.CylinderBufferGeometry.call(this,0,e,t,i,r,n,o,a),this.type="ConeBufferGeometry",this.parameters={radius:e,height:t,radialSegments:i,heightSegments:r,thetaStart:o,thetaLength:a}},THREE.ConeBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.ConeBufferGeometry.prototype.constructor=THREE.ConeBufferGeometry,THREE.ConeGeometry=function(e,t,i,r,n,o,a){THREE.CylinderGeometry.call(this,0,e,t,i,r,n,o,a),this.type="ConeGeometry",this.parameters={radius:e,height:t,radialSegments:i,heightSegments:r,openEnded:n,thetaStart:o,thetaLength:a}},THREE.ConeGeometry.prototype=Object.create(THREE.CylinderGeometry.prototype),THREE.ConeGeometry.prototype.constructor=THREE.ConeGeometry,THREE.EdgesGeometry=function(e,t){function i(e,t){return e-t}THREE.BufferGeometry.call(this);var r,n=Math.cos(THREE.Math.DEG2RAD*(void 0!==t?t:1)),o=[0,0],a={},s=["a","b","c"];e instanceof THREE.BufferGeometry?(r=new THREE.Geometry,r.fromBufferGeometry(e)):r=e.clone(),r.mergeVertices(),r.computeFaceNormals();var c=r.vertices;r=r.faces;for(var h=0,l=r.length;l>h;h++)for(var u=r[h],p=0;3>p;p++){o[0]=u[s[p]],o[1]=u[s[(p+1)%3]],o.sort(i);var d=o.toString();void 0===a[d]?a[d]={vert1:o[0],vert2:o[1],face1:h,face2:void 0}:a[d].face2=h}o=[];for(d in a)s=a[d],(void 0===s.face2||r[s.face1].normal.dot(r[s.face2].normal)<=n)&&(h=c[s.vert1],o.push(h.x),o.push(h.y),o.push(h.z),h=c[s.vert2],o.push(h.x),o.push(h.y),o.push(h.z));this.addAttribute("position",new THREE.BufferAttribute(new Float32Array(o),3))},THREE.EdgesGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.EdgesGeometry.prototype.constructor=THREE.EdgesGeometry,THREE.ExtrudeGeometry=function(e,t){"undefined"!=typeof e&&(THREE.Geometry.call(this),this.type="ExtrudeGeometry",e=Array.isArray(e)?e:[e],this.addShapeList(e,t),this.computeFaceNormals())},THREE.ExtrudeGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.ExtrudeGeometry.prototype.constructor=THREE.ExtrudeGeometry,THREE.ExtrudeGeometry.prototype.addShapeList=function(e,t){for(var i=e.length,r=0;i>r;r++)this.addShape(e[r],t)},THREE.ExtrudeGeometry.prototype.addShape=function(e,t){function i(e,t,i){return t||console.error("THREE.ExtrudeGeometry: vec does not exist"),t.clone().multiplyScalar(i).add(e)}function r(e,t,i){var r=1,r=e.x-t.x,n=e.y-t.y,o=i.x-e.x,a=i.y-e.y,s=r*r+n*n;if(Math.abs(r*a-n*o)>Number.EPSILON){var c=Math.sqrt(s),h=Math.sqrt(o*o+a*a),s=t.x-n/c;if(t=t.y+r/c,o=((i.x-a/h-s)*a-(i.y+o/h-t)*o)/(r*a-n*o),i=s+r*o-e.x,e=t+n*o-e.y,r=i*i+e*e,2>=r)return new THREE.Vector2(i,e);r=Math.sqrt(r/2)}else e=!1,r>Number.EPSILON?o>Number.EPSILON&&(e=!0):r<-Number.EPSILON?o<-Number.EPSILON&&(e=!0):Math.sign(n)===Math.sign(a)&&(e=!0),e?(i=-n,e=r,r=Math.sqrt(s)):(i=r,e=n,r=Math.sqrt(s/2));return new THREE.Vector2(i/r,e/r)}function n(e,t){var i,r;for(F=e.length;0<=--F;){i=F,r=F-1,0>r&&(r=e.length-1);for(var n=0,o=T+2*E,n=0;o>n;n++){var a=I*n,s=I*(n+1),c=t+i+a,a=t+r+a,h=t+r+s,s=t+i+s,c=c+M,a=a+M,h=h+M,s=s+M;_.faces.push(new THREE.Face3(c,a,s,null,null,1)),_.faces.push(new THREE.Face3(a,h,s,null,null,1)),c=R.generateSideWallUV(_,c,a,h,s),_.faceVertexUvs[0].push([c[0],c[1],c[3]]),_.faceVertexUvs[0].push([c[1],c[2],c[3]])}}}function o(e,t,i){_.vertices.push(new THREE.Vector3(e,t,i))}function a(e,t,i){e+=M,t+=M,i+=M,_.faces.push(new THREE.Face3(e,t,i,null,null,0)),e=R.generateTopUV(_,e,t,i),_.faceVertexUvs[0].push(e)}var s,c,h,l,u,p=void 0!==t.amount?t.amount:100,d=void 0!==t.bevelThickness?t.bevelThickness:6,f=void 0!==t.bevelSize?t.bevelSize:d-2,E=void 0!==t.bevelSegments?t.bevelSegments:3,m=void 0!==t.bevelEnabled?t.bevelEnabled:!0,g=void 0!==t.curveSegments?t.curveSegments:12,T=void 0!==t.steps?t.steps:1,v=t.extrudePath,y=!1,R=void 0!==t.UVGenerator?t.UVGenerator:THREE.ExtrudeGeometry.WorldUVGenerator;v&&(s=v.getSpacedPoints(T),y=!0,m=!1,c=void 0!==t.frames?t.frames:new THREE.TubeGeometry.FrenetFrames(v,T,!1),h=new THREE.Vector3,l=new THREE.Vector3,u=new THREE.Vector3),m||(f=d=E=0);var x,H,b,_=this,M=this.vertices.length,v=e.extractPoints(g),g=v.shape,w=v.holes;if(v=!THREE.ShapeUtils.isClockWise(g)){for(g=g.reverse(),H=0,b=w.length;b>H;H++)x=w[H],THREE.ShapeUtils.isClockWise(x)&&(w[H]=x.reverse());v=!1}var S=THREE.ShapeUtils.triangulateShape(g,w),L=g;for(H=0,b=w.length;b>H;H++)x=w[H],g=g.concat(x);var A,C,P,B,U,D,I=g.length,O=S.length,v=[],F=0;for(P=L.length,A=P-1,C=F+1;P>F;F++,A++,C++)A===P&&(A=0),C===P&&(C=0),v[F]=r(L[F],L[A],L[C]);var N,V=[],G=v.concat();for(H=0,b=w.length;b>H;H++){for(x=w[H],N=[],F=0,P=x.length,A=P-1,C=F+1;P>F;F++,A++,C++)A===P&&(A=0),C===P&&(C=0),N[F]=r(x[F],x[A],x[C]);V.push(N),G=G.concat(N)}for(A=0;E>A;A++){for(P=A/E,B=d*(1-P),C=f*Math.sin(P*Math.PI/2),F=0,P=L.length;P>F;F++)U=i(L[F],v[F],C),o(U.x,U.y,-B);for(H=0,b=w.length;b>H;H++)for(x=w[H],N=V[H],F=0,P=x.length;P>F;F++)U=i(x[F],N[F],C),o(U.x,U.y,-B)}for(C=f,F=0;I>F;F++)U=m?i(g[F],G[F],C):g[F],y?(l.copy(c.normals[0]).multiplyScalar(U.x),h.copy(c.binormals[0]).multiplyScalar(U.y),u.copy(s[0]).add(l).add(h),o(u.x,u.y,u.z)):o(U.x,U.y,0);for(P=1;T>=P;P++)for(F=0;I>F;F++)U=m?i(g[F],G[F],C):g[F],y?(l.copy(c.normals[P]).multiplyScalar(U.x),h.copy(c.binormals[P]).multiplyScalar(U.y),u.copy(s[P]).add(l).add(h),o(u.x,u.y,u.z)):o(U.x,U.y,p/T*P);for(A=E-1;A>=0;A--){for(P=A/E,B=d*(1-P),C=f*Math.sin(P*Math.PI/2),F=0,P=L.length;P>F;F++)U=i(L[F],v[F],C),o(U.x,U.y,p+B);for(H=0,b=w.length;b>H;H++)for(x=w[H],N=V[H],F=0,P=x.length;P>F;F++)U=i(x[F],N[F],C),y?o(U.x,U.y+s[T-1].y,s[T-1].x+B):o(U.x,U.y,p+B)}!function(){if(m){var e;for(e=0*I,F=0;O>F;F++)D=S[F],a(D[2]+e,D[1]+e,D[0]+e);for(e=T+2*E,e*=I,F=0;O>F;F++)D=S[F],a(D[0]+e,D[1]+e,D[2]+e)}else{for(F=0;O>F;F++)D=S[F],a(D[2],D[1],D[0]);for(F=0;O>F;F++)D=S[F],a(D[0]+I*T,D[1]+I*T,D[2]+I*T)}}(),function(){var e=0;for(n(L,e),e+=L.length,H=0,b=w.length;b>H;H++)x=w[H],n(x,e),e+=x.length}()},THREE.ExtrudeGeometry.WorldUVGenerator={generateTopUV:function(e,t,i,r){return e=e.vertices,t=e[t],i=e[i],r=e[r],[new THREE.Vector2(t.x,t.y),new THREE.Vector2(i.x,i.y),new THREE.Vector2(r.x,r.y)]},generateSideWallUV:function(e,t,i,r,n){return e=e.vertices,t=e[t],i=e[i],r=e[r],n=e[n],.01>Math.abs(t.y-i.y)?[new THREE.Vector2(t.x,1-t.z),new THREE.Vector2(i.x,1-i.z),new THREE.Vector2(r.x,1-r.z),new THREE.Vector2(n.x,1-n.z)]:[new THREE.Vector2(t.y,1-t.z),new THREE.Vector2(i.y,1-i.z),new THREE.Vector2(r.y,1-r.z),new THREE.Vector2(n.y,1-n.z)]}},THREE.ShapeGeometry=function(e,t){THREE.Geometry.call(this),this.type="ShapeGeometry",!1===Array.isArray(e)&&(e=[e]),this.addShapeList(e,t),this.computeFaceNormals()},THREE.ShapeGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.ShapeGeometry.prototype.constructor=THREE.ShapeGeometry,THREE.ShapeGeometry.prototype.addShapeList=function(e,t){for(var i=0,r=e.length;r>i;i++)this.addShape(e[i],t);return this},THREE.ShapeGeometry.prototype.addShape=function(e,t){void 0===t&&(t={});var i,r,n,o=t.material,a=void 0===t.UVGenerator?THREE.ExtrudeGeometry.WorldUVGenerator:t.UVGenerator,s=this.vertices.length;i=e.extractPoints(void 0!==t.curveSegments?t.curveSegments:12);var c=i.shape,h=i.holes;if(!THREE.ShapeUtils.isClockWise(c))for(c=c.reverse(),i=0,r=h.length;r>i;i++)n=h[i],THREE.ShapeUtils.isClockWise(n)&&(h[i]=n.reverse());var l=THREE.ShapeUtils.triangulateShape(c,h);for(i=0,r=h.length;r>i;i++)n=h[i],c=c.concat(n);for(h=c.length,r=l.length,i=0;h>i;i++)n=c[i],this.vertices.push(new THREE.Vector3(n.x,n.y,0));for(i=0;r>i;i++)h=l[i],c=h[0]+s,n=h[1]+s,h=h[2]+s,this.faces.push(new THREE.Face3(c,n,h,null,null,o)),this.faceVertexUvs[0].push(a.generateTopUV(this,c,n,h))},THREE.LatheBufferGeometry=function(e,t,i,r){THREE.BufferGeometry.call(this),this.type="LatheBufferGeometry",this.parameters={points:e,segments:t,phiStart:i,phiLength:r},t=Math.floor(t)||12,i=i||0,r=r||2*Math.PI,r=THREE.Math.clamp(r,0,2*Math.PI);for(var n=(t+1)*e.length,o=t*e.length*6,a=new THREE.BufferAttribute(new(o>65535?Uint32Array:Uint16Array)(o),1),s=new THREE.BufferAttribute(new Float32Array(3*n),3),c=new THREE.BufferAttribute(new Float32Array(2*n),2),h=0,l=0,u=1/t,p=new THREE.Vector3,d=new THREE.Vector2,n=0;t>=n;n++)for(var o=i+n*u*r,f=Math.sin(o),E=Math.cos(o),o=0;o<=e.length-1;o++)p.x=e[o].x*f,p.y=e[o].y,p.z=e[o].x*E,s.setXYZ(h,p.x,p.y,p.z),d.x=n/t,d.y=o/(e.length-1),c.setXY(h,d.x,d.y),h++;for(n=0;t>n;n++)for(o=0;o<e.length-1;o++)i=o+n*e.length,h=i+e.length,u=i+e.length+1,p=i+1,a.setX(l,i),l++,a.setX(l,h),l++,a.setX(l,p),l++,a.setX(l,h),l++,a.setX(l,u),l++,a.setX(l,p),l++;if(this.setIndex(a),this.addAttribute("position",s),this.addAttribute("uv",c),this.computeVertexNormals(),r===2*Math.PI)for(r=this.attributes.normal.array,a=new THREE.Vector3,s=new THREE.Vector3,c=new THREE.Vector3,i=t*e.length*3,o=n=0;n<e.length;n++,o+=3)a.x=r[o+0],a.y=r[o+1],a.z=r[o+2],s.x=r[i+o+0],s.y=r[i+o+1],s.z=r[i+o+2],c.addVectors(a,s).normalize(),r[o+0]=r[i+o+0]=c.x,r[o+1]=r[i+o+1]=c.y,r[o+2]=r[i+o+2]=c.z},THREE.LatheBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.LatheBufferGeometry.prototype.constructor=THREE.LatheBufferGeometry,THREE.LatheGeometry=function(e,t,i,r){THREE.Geometry.call(this),this.type="LatheGeometry",this.parameters={points:e,segments:t,phiStart:i,phiLength:r},this.fromBufferGeometry(new THREE.LatheBufferGeometry(e,t,i,r)),this.mergeVertices()},THREE.LatheGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry,THREE.PlaneGeometry=function(e,t,i,r){THREE.Geometry.call(this),this.type="PlaneGeometry",this.parameters={width:e,height:t,widthSegments:i,heightSegments:r},this.fromBufferGeometry(new THREE.PlaneBufferGeometry(e,t,i,r))},THREE.PlaneGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry,THREE.PlaneBufferGeometry=function(e,t,i,r){THREE.BufferGeometry.call(this),this.type="PlaneBufferGeometry",this.parameters={width:e,height:t,widthSegments:i,heightSegments:r};var n=e/2,o=t/2;i=Math.floor(i)||1,r=Math.floor(r)||1;var a=i+1,s=r+1,c=e/i,h=t/r;t=new Float32Array(a*s*3),e=new Float32Array(a*s*3);for(var l=new Float32Array(a*s*2),u=0,p=0,d=0;s>d;d++)for(var f=d*h-o,E=0;a>E;E++)t[u]=E*c-n,t[u+1]=-f,e[u+2]=1,l[p]=E/i,l[p+1]=1-d/r,u+=3,p+=2;for(u=0,n=new(65535<t.length/3?Uint32Array:Uint16Array)(i*r*6),d=0;r>d;d++)for(E=0;i>E;E++)o=E+a*(d+1),s=E+1+a*(d+1),c=E+1+a*d,n[u]=E+a*d,n[u+1]=o,n[u+2]=c,n[u+3]=o,n[u+4]=s,n[u+5]=c,u+=6;this.setIndex(new THREE.BufferAttribute(n,1)),this.addAttribute("position",new THREE.BufferAttribute(t,3)),this.addAttribute("normal",new THREE.BufferAttribute(e,3)),this.addAttribute("uv",new THREE.BufferAttribute(l,2))},THREE.PlaneBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.PlaneBufferGeometry.prototype.constructor=THREE.PlaneBufferGeometry,THREE.RingBufferGeometry=function(e,t,i,r,n,o){THREE.BufferGeometry.call(this),this.type="RingBufferGeometry",this.parameters={innerRadius:e,outerRadius:t,thetaSegments:i,phiSegments:r,thetaStart:n,thetaLength:o},e=e||20,t=t||50,n=void 0!==n?n:0,o=void 0!==o?o:2*Math.PI,i=void 0!==i?Math.max(3,i):8,r=void 0!==r?Math.max(1,r):1;var a,s,c=(i+1)*(r+1),h=i*r*6,h=new THREE.BufferAttribute(new(h>65535?Uint32Array:Uint16Array)(h),1),l=new THREE.BufferAttribute(new Float32Array(3*c),3),u=new THREE.BufferAttribute(new Float32Array(3*c),3),c=new THREE.BufferAttribute(new Float32Array(2*c),2),p=0,d=0,f=e,E=(t-e)/r,m=new THREE.Vector3,g=new THREE.Vector2;for(e=0;r>=e;e++){for(s=0;i>=s;s++)a=n+s/i*o,m.x=f*Math.cos(a),m.y=f*Math.sin(a),l.setXYZ(p,m.x,m.y,m.z),u.setXYZ(p,0,0,1),g.x=(m.x/t+1)/2,g.y=(m.y/t+1)/2,c.setXY(p,g.x,g.y),p++;f+=E}for(e=0;r>e;e++)for(t=e*(i+1),s=0;i>s;s++)n=a=s+t,o=a+i+1,p=a+i+2,a+=1,h.setX(d,n),d++,h.setX(d,o),d++,h.setX(d,p),d++,h.setX(d,n),d++,h.setX(d,p),d++,h.setX(d,a),d++;this.setIndex(h),this.addAttribute("position",l),this.addAttribute("normal",u),this.addAttribute("uv",c)},THREE.RingBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.RingBufferGeometry.prototype.constructor=THREE.RingBufferGeometry,THREE.RingGeometry=function(e,t,i,r,n,o){THREE.Geometry.call(this),this.type="RingGeometry",this.parameters={innerRadius:e,outerRadius:t,thetaSegments:i,phiSegments:r,thetaStart:n,thetaLength:o},this.fromBufferGeometry(new THREE.RingBufferGeometry(e,t,i,r,n,o))},THREE.RingGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.RingGeometry.prototype.constructor=THREE.RingGeometry,THREE.SphereGeometry=function(e,t,i,r,n,o,a){THREE.Geometry.call(this),this.type="SphereGeometry",this.parameters={radius:e,widthSegments:t,heightSegments:i,phiStart:r,phiLength:n,thetaStart:o,thetaLength:a},this.fromBufferGeometry(new THREE.SphereBufferGeometry(e,t,i,r,n,o,a))},THREE.SphereGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry,THREE.SphereBufferGeometry=function(e,t,i,r,n,o,a){THREE.BufferGeometry.call(this),this.type="SphereBufferGeometry",this.parameters={radius:e,widthSegments:t,heightSegments:i,phiStart:r,phiLength:n,thetaStart:o,thetaLength:a},e=e||50,t=Math.max(3,Math.floor(t)||8),i=Math.max(2,Math.floor(i)||6),r=void 0!==r?r:0,n=void 0!==n?n:2*Math.PI,o=void 0!==o?o:0,a=void 0!==a?a:Math.PI;for(var s=o+a,c=(t+1)*(i+1),h=new THREE.BufferAttribute(new Float32Array(3*c),3),l=new THREE.BufferAttribute(new Float32Array(3*c),3),c=new THREE.BufferAttribute(new Float32Array(2*c),2),u=0,p=[],d=new THREE.Vector3,f=0;i>=f;f++){for(var E=[],m=f/i,g=0;t>=g;g++){var T=g/t,v=-e*Math.cos(r+T*n)*Math.sin(o+m*a),y=e*Math.cos(o+m*a),R=e*Math.sin(r+T*n)*Math.sin(o+m*a);d.set(v,y,R).normalize(),h.setXYZ(u,v,y,R),l.setXYZ(u,d.x,d.y,d.z),c.setXY(u,T,1-m),E.push(u),u++}p.push(E)}for(r=[],f=0;i>f;f++)for(g=0;t>g;g++)n=p[f][g+1],a=p[f][g],u=p[f+1][g],d=p[f+1][g+1],(0!==f||o>0)&&r.push(n,a,d),(f!==i-1||s<Math.PI)&&r.push(a,u,d);this.setIndex(new(65535<h.count?THREE.Uint32Attribute:THREE.Uint16Attribute)(r,1)),this.addAttribute("position",h),this.addAttribute("normal",l),this.addAttribute("uv",c),this.boundingSphere=new THREE.Sphere(new THREE.Vector3,e)},THREE.SphereBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.SphereBufferGeometry.prototype.constructor=THREE.SphereBufferGeometry,THREE.TextGeometry=function(e,t){t=t||{};var i=t.font;return!1==i instanceof THREE.Font?(console.error("THREE.TextGeometry: font parameter is not an instance of THREE.Font."),new THREE.Geometry):(i=i.generateShapes(e,t.size,t.curveSegments),t.amount=void 0!==t.height?t.height:50,void 0===t.bevelThickness&&(t.bevelThickness=10),void 0===t.bevelSize&&(t.bevelSize=8),void 0===t.bevelEnabled&&(t.bevelEnabled=!1),THREE.ExtrudeGeometry.call(this,i,t),void(this.type="TextGeometry"))},THREE.TextGeometry.prototype=Object.create(THREE.ExtrudeGeometry.prototype),THREE.TextGeometry.prototype.constructor=THREE.TextGeometry,THREE.TorusBufferGeometry=function(e,t,i,r,n){THREE.BufferGeometry.call(this),this.type="TorusBufferGeometry",this.parameters={radius:e,tube:t,radialSegments:i,tubularSegments:r,arc:n},e=e||100,t=t||40,i=Math.floor(i)||8,r=Math.floor(r)||6,n=n||2*Math.PI;var o,a,s=(i+1)*(r+1),c=i*r*6,c=new(c>65535?Uint32Array:Uint16Array)(c),h=new Float32Array(3*s),l=new Float32Array(3*s),s=new Float32Array(2*s),u=0,p=0,d=0,f=new THREE.Vector3,E=new THREE.Vector3,m=new THREE.Vector3;for(o=0;i>=o;o++)for(a=0;r>=a;a++){var g=a/r*n,T=o/i*Math.PI*2;E.x=(e+t*Math.cos(T))*Math.cos(g),E.y=(e+t*Math.cos(T))*Math.sin(g),E.z=t*Math.sin(T),h[u]=E.x,h[u+1]=E.y,h[u+2]=E.z,f.x=e*Math.cos(g),f.y=e*Math.sin(g),m.subVectors(E,f).normalize(),l[u]=m.x,l[u+1]=m.y,l[u+2]=m.z,s[p]=a/r,s[p+1]=o/i,u+=3,p+=2}for(o=1;i>=o;o++)for(a=1;r>=a;a++)e=(r+1)*(o-1)+a-1,t=(r+1)*(o-1)+a,n=(r+1)*o+a,c[d]=(r+1)*o+a-1,c[d+1]=e,c[d+2]=n,c[d+3]=e,c[d+4]=t,c[d+5]=n,d+=6;this.setIndex(new THREE.BufferAttribute(c,1)),this.addAttribute("position",new THREE.BufferAttribute(h,3)),this.addAttribute("normal",new THREE.BufferAttribute(l,3)),this.addAttribute("uv",new THREE.BufferAttribute(s,2))},THREE.TorusBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.TorusBufferGeometry.prototype.constructor=THREE.TorusBufferGeometry,THREE.TorusGeometry=function(e,t,i,r,n){THREE.Geometry.call(this),this.type="TorusGeometry",this.parameters={radius:e,tube:t,radialSegments:i,tubularSegments:r,arc:n},this.fromBufferGeometry(new THREE.TorusBufferGeometry(e,t,i,r,n))},THREE.TorusGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry,THREE.TorusKnotBufferGeometry=function(e,t,i,r,n,o){function a(e,t,i,r,n){var o=Math.cos(e),a=Math.sin(e);e*=i/t,t=Math.cos(e),n.x=r*(2+t)*.5*o,n.y=r*(2+t)*a*.5,n.z=r*Math.sin(e)*.5}THREE.BufferGeometry.call(this),this.type="TorusKnotBufferGeometry",this.parameters={radius:e,tube:t,tubularSegments:i,radialSegments:r,p:n,q:o},e=e||100,t=t||40,i=Math.floor(i)||64,r=Math.floor(r)||8,n=n||2,o=o||3;var s,c,h=(r+1)*(i+1),l=r*i*6,l=new THREE.BufferAttribute(new(l>65535?Uint32Array:Uint16Array)(l),1),u=new THREE.BufferAttribute(new Float32Array(3*h),3),p=new THREE.BufferAttribute(new Float32Array(3*h),3),h=new THREE.BufferAttribute(new Float32Array(2*h),2),d=0,f=0,E=new THREE.Vector3,m=new THREE.Vector3,g=new THREE.Vector2,T=new THREE.Vector3,v=new THREE.Vector3,y=new THREE.Vector3,R=new THREE.Vector3,x=new THREE.Vector3;for(s=0;i>=s;++s)for(c=s/i*n*Math.PI*2,a(c,n,o,e,T),a(c+.01,n,o,e,v),R.subVectors(v,T),x.addVectors(v,T),y.crossVectors(R,x),x.crossVectors(y,R),y.normalize(),x.normalize(),c=0;r>=c;++c){var H=c/r*Math.PI*2,b=-t*Math.cos(H),H=t*Math.sin(H);E.x=T.x+(b*x.x+H*y.x),E.y=T.y+(b*x.y+H*y.y),E.z=T.z+(b*x.z+H*y.z),u.setXYZ(d,E.x,E.y,E.z),m.subVectors(E,T).normalize(),p.setXYZ(d,m.x,m.y,m.z),g.x=s/i,g.y=c/r,h.setXY(d,g.x,g.y),d++}for(c=1;i>=c;c++)for(s=1;r>=s;s++)e=(r+1)*c+(s-1),t=(r+1)*c+s,n=(r+1)*(c-1)+s,l.setX(f,(r+1)*(c-1)+(s-1)),f++,l.setX(f,e),f++,l.setX(f,n),f++,l.setX(f,e),f++,l.setX(f,t),f++,l.setX(f,n),f++;this.setIndex(l),this.addAttribute("position",u),this.addAttribute("normal",p),this.addAttribute("uv",h)},THREE.TorusKnotBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.TorusKnotBufferGeometry.prototype.constructor=THREE.TorusKnotBufferGeometry,THREE.TorusKnotGeometry=function(e,t,i,r,n,o,a){THREE.Geometry.call(this),this.type="TorusKnotGeometry",this.parameters={radius:e,tube:t,tubularSegments:i,radialSegments:r,p:n,q:o},void 0!==a&&console.warn("THREE.TorusKnotGeometry: heightScale has been deprecated. Use .scale( x, y, z ) instead."),this.fromBufferGeometry(new THREE.TorusKnotBufferGeometry(e,t,i,r,n,o)),this.mergeVertices()},THREE.TorusKnotGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry,THREE.TubeGeometry=function(e,t,i,r,n,o){THREE.Geometry.call(this),this.type="TubeGeometry",this.parameters={path:e,segments:t,radius:i,radialSegments:r,closed:n,taper:o},t=t||64,i=i||1,r=r||8,n=n||!1,o=o||THREE.TubeGeometry.NoTaper;var a,s,c,h,l,u,p,d,f,E,m=[],g=t+1,T=new THREE.Vector3;for(d=new THREE.TubeGeometry.FrenetFrames(e,t,n),f=d.normals,E=d.binormals,this.tangents=d.tangents,this.normals=f,this.binormals=E,d=0;g>d;d++)for(m[d]=[],c=d/(g-1),p=e.getPointAt(c),a=f[d],s=E[d],l=i*o(c),c=0;r>c;c++)h=c/r*2*Math.PI,u=-l*Math.cos(h),h=l*Math.sin(h),T.copy(p),T.x+=u*a.x+h*s.x,T.y+=u*a.y+h*s.y,T.z+=u*a.z+h*s.z,m[d][c]=this.vertices.push(new THREE.Vector3(T.x,T.y,T.z))-1;for(d=0;t>d;d++)for(c=0;r>c;c++)o=n?(d+1)%t:d+1,g=(c+1)%r,e=m[d][c],i=m[o][c],o=m[o][g],g=m[d][g],T=new THREE.Vector2(d/t,c/r),f=new THREE.Vector2((d+1)/t,c/r),E=new THREE.Vector2((d+1)/t,(c+1)/r),a=new THREE.Vector2(d/t,(c+1)/r),this.faces.push(new THREE.Face3(e,i,g)),this.faceVertexUvs[0].push([T,f,a]),this.faces.push(new THREE.Face3(i,o,g)),this.faceVertexUvs[0].push([f.clone(),E,a.clone()]);this.computeFaceNormals(),this.computeVertexNormals()},THREE.TubeGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.TubeGeometry.prototype.constructor=THREE.TubeGeometry,THREE.TubeGeometry.NoTaper=function(e){return 1},THREE.TubeGeometry.SinusoidalTaper=function(e){return Math.sin(Math.PI*e)},THREE.TubeGeometry.FrenetFrames=function(e,t,i){var r=new THREE.Vector3,n=[],o=[],a=[],s=new THREE.Vector3,c=new THREE.Matrix4;t+=1;var h,l,u;for(this.tangents=n,this.normals=o,this.binormals=a,h=0;t>h;h++)l=h/(t-1),n[h]=e.getTangentAt(l),n[h].normalize();for(o[0]=new THREE.Vector3,a[0]=new THREE.Vector3,e=Number.MAX_VALUE,h=Math.abs(n[0].x),l=Math.abs(n[0].y),u=Math.abs(n[0].z),e>=h&&(e=h,r.set(1,0,0)),e>=l&&(e=l,r.set(0,1,0)),e>=u&&r.set(0,0,1),s.crossVectors(n[0],r).normalize(),o[0].crossVectors(n[0],s),a[0].crossVectors(n[0],o[0]),h=1;t>h;h++)o[h]=o[h-1].clone(),a[h]=a[h-1].clone(),s.crossVectors(n[h-1],n[h]),s.length()>Number.EPSILON&&(s.normalize(),r=Math.acos(THREE.Math.clamp(n[h-1].dot(n[h]),-1,1)),o[h].applyMatrix4(c.makeRotationAxis(s,r))),a[h].crossVectors(n[h],o[h]);if(i)for(r=Math.acos(THREE.Math.clamp(o[0].dot(o[t-1]),-1,1)),r/=t-1,0<n[0].dot(s.crossVectors(o[0],o[t-1]))&&(r=-r),h=1;t>h;h++)o[h].applyMatrix4(c.makeRotationAxis(n[h],r*h)),a[h].crossVectors(n[h],o[h])},THREE.PolyhedronGeometry=function(e,t,i,r){function n(e){var t=e.normalize().clone();t.index=c.vertices.push(t)-1;var i=Math.atan2(e.z,-e.x)/2/Math.PI+.5;return e=Math.atan2(-e.y,Math.sqrt(e.x*e.x+e.z*e.z))/Math.PI+.5,t.uv=new THREE.Vector2(i,1-e),t}function o(e,t,i,r){r=new THREE.Face3(e.index,t.index,i.index,[e.clone(),t.clone(),i.clone()],void 0,r),c.faces.push(r),m.copy(e).add(t).add(i).divideScalar(3),r=Math.atan2(m.z,-m.x),c.faceVertexUvs[0].push([s(e.uv,e,r),s(t.uv,t,r),s(i.uv,i,r)])}function a(e,t){for(var i=Math.pow(2,t),r=n(c.vertices[e.a]),a=n(c.vertices[e.b]),s=n(c.vertices[e.c]),h=[],l=e.materialIndex,u=0;i>=u;u++){h[u]=[];for(var p=n(r.clone().lerp(s,u/i)),d=n(a.clone().lerp(s,u/i)),f=i-u,E=0;f>=E;E++)h[u][E]=0===E&&u===i?p:n(p.clone().lerp(d,E/f))}for(u=0;i>u;u++)for(E=0;2*(i-u)-1>E;E++)r=Math.floor(E/2),0===E%2?o(h[u][r+1],h[u+1][r],h[u][r],l):o(h[u][r+1],h[u+1][r+1],h[u+1][r],l)}function s(e,t,i){return 0>i&&1===e.x&&(e=new THREE.Vector2(e.x-1,e.y)),0===t.x&&0===t.z&&(e=new THREE.Vector2(i/2/Math.PI+.5,e.y)),e.clone()}THREE.Geometry.call(this),this.type="PolyhedronGeometry",this.parameters={vertices:e,indices:t,radius:i,detail:r},i=i||1,r=r||0;for(var c=this,h=0,l=e.length;l>h;h+=3)n(new THREE.Vector3(e[h],e[h+1],e[h+2]));e=this.vertices;for(var u=[],p=h=0,l=t.length;l>h;h+=3,p++){var d=e[t[h]],f=e[t[h+1]],E=e[t[h+2]];u[p]=new THREE.Face3(d.index,f.index,E.index,[d.clone(),f.clone(),E.clone()],void 0,p)}for(var m=new THREE.Vector3,h=0,l=u.length;l>h;h++)a(u[h],r);for(h=0,l=this.faceVertexUvs[0].length;l>h;h++)t=this.faceVertexUvs[0][h],r=t[0].x,e=t[1].x,u=t[2].x,p=Math.max(r,e,u),d=Math.min(r,e,u),p>.9&&.1>d&&(.2>r&&(t[0].x+=1),.2>e&&(t[1].x+=1),.2>u&&(t[2].x+=1));for(h=0,l=this.vertices.length;l>h;h++)this.vertices[h].multiplyScalar(i);this.mergeVertices(),this.computeFaceNormals(),this.boundingSphere=new THREE.Sphere(new THREE.Vector3,i)},THREE.PolyhedronGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.PolyhedronGeometry.prototype.constructor=THREE.PolyhedronGeometry,
THREE.DodecahedronGeometry=function(e,t){var i=(1+Math.sqrt(5))/2,r=1/i;THREE.PolyhedronGeometry.call(this,[-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-r,-i,0,-r,i,0,r,-i,0,r,i,-r,-i,0,-r,i,0,r,-i,0,r,i,0,-i,0,-r,i,0,-r,-i,0,r,i,0,r],[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9],e,t),this.type="DodecahedronGeometry",this.parameters={radius:e,detail:t}},THREE.DodecahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype),THREE.DodecahedronGeometry.prototype.constructor=THREE.DodecahedronGeometry,THREE.IcosahedronGeometry=function(e,t){var i=(1+Math.sqrt(5))/2;THREE.PolyhedronGeometry.call(this,[-1,i,0,1,i,0,-1,-i,0,1,-i,0,0,-1,i,0,1,i,0,-1,-i,0,1,-i,i,0,-1,i,0,1,-i,0,-1,-i,0,1],[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1],e,t),this.type="IcosahedronGeometry",this.parameters={radius:e,detail:t}},THREE.IcosahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype),THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry,THREE.OctahedronGeometry=function(e,t){THREE.PolyhedronGeometry.call(this,[1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2],e,t),this.type="OctahedronGeometry",this.parameters={radius:e,detail:t}},THREE.OctahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype),THREE.OctahedronGeometry.prototype.constructor=THREE.OctahedronGeometry,THREE.TetrahedronGeometry=function(e,t){THREE.PolyhedronGeometry.call(this,[1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],[2,1,0,0,3,2,1,3,0,2,3,1],e,t),this.type="TetrahedronGeometry",this.parameters={radius:e,detail:t}},THREE.TetrahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype),THREE.TetrahedronGeometry.prototype.constructor=THREE.TetrahedronGeometry,THREE.ParametricGeometry=function(e,t,i){THREE.Geometry.call(this),this.type="ParametricGeometry",this.parameters={func:e,slices:t,stacks:i};var r,n,o,a,s=this.vertices,c=this.faces,h=this.faceVertexUvs[0],l=t+1;for(r=0;i>=r;r++)for(a=r/i,n=0;t>=n;n++)o=n/t,o=e(o,a),s.push(o);var u,p,d,f;for(r=0;i>r;r++)for(n=0;t>n;n++)e=r*l+n,s=r*l+n+1,a=(r+1)*l+n+1,o=(r+1)*l+n,u=new THREE.Vector2(n/t,r/i),p=new THREE.Vector2((n+1)/t,r/i),d=new THREE.Vector2((n+1)/t,(r+1)/i),f=new THREE.Vector2(n/t,(r+1)/i),c.push(new THREE.Face3(e,s,o)),h.push([u,p,f]),c.push(new THREE.Face3(s,a,o)),h.push([p.clone(),d,f.clone()]);this.computeFaceNormals(),this.computeVertexNormals()},THREE.ParametricGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.ParametricGeometry.prototype.constructor=THREE.ParametricGeometry,THREE.WireframeGeometry=function(e){function t(e,t){return e-t}THREE.BufferGeometry.call(this);var i=[0,0],r={},n=["a","b","c"];if(e instanceof THREE.Geometry){var o=e.vertices,a=e.faces,s=0,c=new Uint32Array(6*a.length);e=0;for(var h=a.length;h>e;e++)for(var l=a[e],u=0;3>u;u++){i[0]=l[n[u]],i[1]=l[n[(u+1)%3]],i.sort(t);var p=i.toString();void 0===r[p]&&(c[2*s]=i[0],c[2*s+1]=i[1],r[p]=!0,s++)}for(i=new Float32Array(6*s),e=0,h=s;h>e;e++)for(u=0;2>u;u++)r=o[c[2*e+u]],s=6*e+3*u,i[s+0]=r.x,i[s+1]=r.y,i[s+2]=r.z;this.addAttribute("position",new THREE.BufferAttribute(i,3))}else if(e instanceof THREE.BufferGeometry){if(null!==e.index){for(h=e.index.array,o=e.attributes.position,n=e.groups,s=0,0===n.length&&e.addGroup(0,h.length),c=new Uint32Array(2*h.length),a=0,l=n.length;l>a;++a){e=n[a],u=e.start,p=e.count,e=u;for(var d=u+p;d>e;e+=3)for(u=0;3>u;u++)i[0]=h[e+u],i[1]=h[e+(u+1)%3],i.sort(t),p=i.toString(),void 0===r[p]&&(c[2*s]=i[0],c[2*s+1]=i[1],r[p]=!0,s++)}for(i=new Float32Array(6*s),e=0,h=s;h>e;e++)for(u=0;2>u;u++)s=6*e+3*u,r=c[2*e+u],i[s+0]=o.getX(r),i[s+1]=o.getY(r),i[s+2]=o.getZ(r)}else for(o=e.attributes.position.array,s=o.length/3,c=s/3,i=new Float32Array(6*s),e=0,h=c;h>e;e++)for(u=0;3>u;u++)s=18*e+6*u,c=9*e+3*u,i[s+0]=o[c],i[s+1]=o[c+1],i[s+2]=o[c+2],r=9*e+(u+1)%3*3,i[s+3]=o[r],i[s+4]=o[r+1],i[s+5]=o[r+2];this.addAttribute("position",new THREE.BufferAttribute(i,3))}},THREE.WireframeGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.WireframeGeometry.prototype.constructor=THREE.WireframeGeometry,THREE.AxisHelper=function(e){e=e||1;var t=new Float32Array([0,0,0,e,0,0,0,0,0,0,e,0,0,0,0,0,0,e]),i=new Float32Array([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1]);e=new THREE.BufferGeometry,e.addAttribute("position",new THREE.BufferAttribute(t,3)),e.addAttribute("color",new THREE.BufferAttribute(i,3)),t=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors}),THREE.LineSegments.call(this,e,t)},THREE.AxisHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.AxisHelper.prototype.constructor=THREE.AxisHelper,THREE.ArrowHelper=function(){var e=new THREE.BufferGeometry;e.addAttribute("position",new THREE.Float32Attribute([0,0,0,0,1,0],3));var t=new THREE.CylinderBufferGeometry(0,.5,1,5,1);return t.translate(0,-.5,0),function(i,r,n,o,a,s){THREE.Object3D.call(this),void 0===o&&(o=16776960),void 0===n&&(n=1),void 0===a&&(a=.2*n),void 0===s&&(s=.2*a),this.position.copy(r),this.line=new THREE.Line(e,new THREE.LineBasicMaterial({color:o})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new THREE.Mesh(t,new THREE.MeshBasicMaterial({color:o})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(i),this.setLength(n,a,s)}}(),THREE.ArrowHelper.prototype=Object.create(THREE.Object3D.prototype),THREE.ArrowHelper.prototype.constructor=THREE.ArrowHelper,THREE.ArrowHelper.prototype.setDirection=function(){var e,t=new THREE.Vector3;return function(i){.99999<i.y?this.quaternion.set(0,0,0,1):-.99999>i.y?this.quaternion.set(1,0,0,0):(t.set(i.z,0,-i.x).normalize(),e=Math.acos(i.y),this.quaternion.setFromAxisAngle(t,e))}}(),THREE.ArrowHelper.prototype.setLength=function(e,t,i){void 0===t&&(t=.2*e),void 0===i&&(i=.2*t),this.line.scale.set(1,Math.max(0,e-t),1),this.line.updateMatrix(),this.cone.scale.set(i,t,i),this.cone.position.y=e,this.cone.updateMatrix()},THREE.ArrowHelper.prototype.setColor=function(e){this.line.material.color.copy(e),this.cone.material.color.copy(e)},THREE.BoxHelper=function(e){var t=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),i=new Float32Array(24),r=new THREE.BufferGeometry;r.setIndex(new THREE.BufferAttribute(t,1)),r.addAttribute("position",new THREE.BufferAttribute(i,3)),THREE.LineSegments.call(this,r,new THREE.LineBasicMaterial({color:16776960})),void 0!==e&&this.update(e)},THREE.BoxHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.BoxHelper.prototype.constructor=THREE.BoxHelper,THREE.BoxHelper.prototype.update=function(){var e=new THREE.Box3;return function(t){if(t instanceof THREE.Box3?e.copy(t):e.setFromObject(t),!e.isEmpty()){t=e.min;var i=e.max,r=this.geometry.attributes.position,n=r.array;n[0]=i.x,n[1]=i.y,n[2]=i.z,n[3]=t.x,n[4]=i.y,n[5]=i.z,n[6]=t.x,n[7]=t.y,n[8]=i.z,n[9]=i.x,n[10]=t.y,n[11]=i.z,n[12]=i.x,n[13]=i.y,n[14]=t.z,n[15]=t.x,n[16]=i.y,n[17]=t.z,n[18]=t.x,n[19]=t.y,n[20]=t.z,n[21]=i.x,n[22]=t.y,n[23]=t.z,r.needsUpdate=!0,this.geometry.computeBoundingSphere()}}}(),THREE.BoundingBoxHelper=function(e,t){var i=void 0!==t?t:8947848;this.object=e,this.box=new THREE.Box3,THREE.Mesh.call(this,new THREE.BoxGeometry(1,1,1),new THREE.MeshBasicMaterial({color:i,wireframe:!0}))},THREE.BoundingBoxHelper.prototype=Object.create(THREE.Mesh.prototype),THREE.BoundingBoxHelper.prototype.constructor=THREE.BoundingBoxHelper,THREE.BoundingBoxHelper.prototype.update=function(){this.box.setFromObject(this.object),this.box.size(this.scale),this.box.center(this.position)},THREE.CameraHelper=function(e){function t(e,t,r){i(e,r),i(t,r)}function i(e,t){r.vertices.push(new THREE.Vector3),r.colors.push(new THREE.Color(t)),void 0===o[e]&&(o[e]=[]),o[e].push(r.vertices.length-1)}var r=new THREE.Geometry,n=new THREE.LineBasicMaterial({color:16777215,vertexColors:THREE.FaceColors}),o={};t("n1","n2",16755200),t("n2","n4",16755200),t("n4","n3",16755200),t("n3","n1",16755200),t("f1","f2",16755200),t("f2","f4",16755200),t("f4","f3",16755200),t("f3","f1",16755200),t("n1","f1",16755200),t("n2","f2",16755200),t("n3","f3",16755200),t("n4","f4",16755200),t("p","n1",16711680),t("p","n2",16711680),t("p","n3",16711680),t("p","n4",16711680),t("u1","u2",43775),t("u2","u3",43775),t("u3","u1",43775),t("c","t",16777215),t("p","c",3355443),t("cn1","cn2",3355443),t("cn3","cn4",3355443),t("cf1","cf2",3355443),t("cf3","cf4",3355443),THREE.LineSegments.call(this,r,n),this.camera=e,this.camera.updateProjectionMatrix(),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=o,this.update()},THREE.CameraHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.CameraHelper.prototype.constructor=THREE.CameraHelper,THREE.CameraHelper.prototype.update=function(){function e(e,o,a,s){if(r.set(o,a,s).unproject(n),e=i[e],void 0!==e)for(o=0,a=e.length;a>o;o++)t.vertices[e[o]].copy(r)}var t,i,r=new THREE.Vector3,n=new THREE.Camera;return function(){t=this.geometry,i=this.pointMap,n.projectionMatrix.copy(this.camera.projectionMatrix),e("c",0,0,-1),e("t",0,0,1),e("n1",-1,-1,-1),e("n2",1,-1,-1),e("n3",-1,1,-1),e("n4",1,1,-1),e("f1",-1,-1,1),e("f2",1,-1,1),e("f3",-1,1,1),e("f4",1,1,1),e("u1",.7,1.1,-1),e("u2",-.7,1.1,-1),e("u3",0,2,-1),e("cf1",-1,0,1),e("cf2",1,0,1),e("cf3",0,-1,1),e("cf4",0,1,1),e("cn1",-1,0,-1),e("cn2",1,0,-1),e("cn3",0,-1,-1),e("cn4",0,1,-1),t.verticesNeedUpdate=!0}}(),THREE.DirectionalLightHelper=function(e,t){THREE.Object3D.call(this),this.light=e,this.light.updateMatrixWorld(),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,void 0===t&&(t=1);var i=new THREE.BufferGeometry;i.addAttribute("position",new THREE.Float32Attribute([-t,t,0,t,t,0,t,-t,0,-t,-t,0,-t,t,0],3));var r=new THREE.LineBasicMaterial({fog:!1});this.add(new THREE.Line(i,r)),i=new THREE.BufferGeometry,i.addAttribute("position",new THREE.Float32Attribute([0,0,0,0,0,1],3)),this.add(new THREE.Line(i,r)),this.update()},THREE.DirectionalLightHelper.prototype=Object.create(THREE.Object3D.prototype),THREE.DirectionalLightHelper.prototype.constructor=THREE.DirectionalLightHelper,THREE.DirectionalLightHelper.prototype.dispose=function(){var e=this.children[0],t=this.children[1];e.geometry.dispose(),e.material.dispose(),t.geometry.dispose(),t.material.dispose()},THREE.DirectionalLightHelper.prototype.update=function(){var e=new THREE.Vector3,t=new THREE.Vector3,i=new THREE.Vector3;return function(){e.setFromMatrixPosition(this.light.matrixWorld),t.setFromMatrixPosition(this.light.target.matrixWorld),i.subVectors(t,e);var r=this.children[0],n=this.children[1];r.lookAt(i),r.material.color.copy(this.light.color).multiplyScalar(this.light.intensity),n.lookAt(i),n.scale.z=i.length()}}(),THREE.EdgesHelper=function(e,t,i){t=void 0!==t?t:16777215,THREE.LineSegments.call(this,new THREE.EdgesGeometry(e.geometry,i),new THREE.LineBasicMaterial({color:t})),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1},THREE.EdgesHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.EdgesHelper.prototype.constructor=THREE.EdgesHelper,THREE.FaceNormalsHelper=function(e,t,i,r){this.object=e,this.size=void 0!==t?t:1,e=void 0!==i?i:16776960,r=void 0!==r?r:1,t=0,i=this.object.geometry,i instanceof THREE.Geometry?t=i.faces.length:console.warn("THREE.FaceNormalsHelper: only THREE.Geometry is supported. Use THREE.VertexNormalsHelper, instead."),i=new THREE.BufferGeometry,t=new THREE.Float32Attribute(6*t,3),i.addAttribute("position",t),THREE.LineSegments.call(this,i,new THREE.LineBasicMaterial({color:e,linewidth:r})),this.matrixAutoUpdate=!1,this.update()},THREE.FaceNormalsHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.FaceNormalsHelper.prototype.constructor=THREE.FaceNormalsHelper,THREE.FaceNormalsHelper.prototype.update=function(){var e=new THREE.Vector3,t=new THREE.Vector3,i=new THREE.Matrix3;return function(){this.object.updateMatrixWorld(!0),i.getNormalMatrix(this.object.matrixWorld);for(var r=this.object.matrixWorld,n=this.geometry.attributes.position,o=this.object.geometry,a=o.vertices,o=o.faces,s=0,c=0,h=o.length;h>c;c++){var l=o[c],u=l.normal;e.copy(a[l.a]).add(a[l.b]).add(a[l.c]).divideScalar(3).applyMatrix4(r),t.copy(u).applyMatrix3(i).normalize().multiplyScalar(this.size).add(e),n.setXYZ(s,e.x,e.y,e.z),s+=1,n.setXYZ(s,t.x,t.y,t.z),s+=1}return n.needsUpdate=!0,this}}(),THREE.GridHelper=function(e,t,i,r){i=new THREE.Color(void 0!==i?i:4473924),r=new THREE.Color(void 0!==r?r:8947848);for(var n=[],o=[],a=-e,s=0;e>=a;a+=t){n.push(-e,0,a,e,0,a),n.push(a,0,-e,a,0,e);var c=0===a?i:r;c.toArray(o,s),s+=3,c.toArray(o,s),s+=3,c.toArray(o,s),s+=3,c.toArray(o,s),s+=3}e=new THREE.BufferGeometry,e.addAttribute("position",new THREE.Float32Attribute(n,3)),e.addAttribute("color",new THREE.Float32Attribute(o,3)),n=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors}),THREE.LineSegments.call(this,e,n)},THREE.GridHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.GridHelper.prototype.constructor=THREE.GridHelper,THREE.GridHelper.prototype.setColors=function(){console.error("THREE.GridHelper: setColors() has been deprecated, pass them in the constructor instead.")},THREE.HemisphereLightHelper=function(e,t){THREE.Object3D.call(this),this.light=e,this.light.updateMatrixWorld(),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.colors=[new THREE.Color,new THREE.Color];var i=new THREE.SphereGeometry(t,4,2);i.rotateX(-Math.PI/2);for(var r=0;8>r;r++)i.faces[r].color=this.colors[4>r?0:1];r=new THREE.MeshBasicMaterial({vertexColors:THREE.FaceColors,wireframe:!0}),this.lightSphere=new THREE.Mesh(i,r),this.add(this.lightSphere),this.update()},THREE.HemisphereLightHelper.prototype=Object.create(THREE.Object3D.prototype),THREE.HemisphereLightHelper.prototype.constructor=THREE.HemisphereLightHelper,THREE.HemisphereLightHelper.prototype.dispose=function(){this.lightSphere.geometry.dispose(),this.lightSphere.material.dispose()},THREE.HemisphereLightHelper.prototype.update=function(){var e=new THREE.Vector3;return function(){this.colors[0].copy(this.light.color).multiplyScalar(this.light.intensity),this.colors[1].copy(this.light.groundColor).multiplyScalar(this.light.intensity),this.lightSphere.lookAt(e.setFromMatrixPosition(this.light.matrixWorld).negate()),this.lightSphere.geometry.colorsNeedUpdate=!0}}(),THREE.PointLightHelper=function(e,t){this.light=e,this.light.updateMatrixWorld();var i=new THREE.SphereBufferGeometry(t,4,2),r=new THREE.MeshBasicMaterial({wireframe:!0,fog:!1});r.color.copy(this.light.color).multiplyScalar(this.light.intensity),THREE.Mesh.call(this,i,r),this.matrix=this.light.matrixWorld,this.matrixAutoUpdate=!1},THREE.PointLightHelper.prototype=Object.create(THREE.Mesh.prototype),THREE.PointLightHelper.prototype.constructor=THREE.PointLightHelper,THREE.PointLightHelper.prototype.dispose=function(){this.geometry.dispose(),this.material.dispose()},THREE.PointLightHelper.prototype.update=function(){this.material.color.copy(this.light.color).multiplyScalar(this.light.intensity)},THREE.SkeletonHelper=function(e){this.bones=this.getBoneList(e);for(var t=new THREE.Geometry,i=0;i<this.bones.length;i++)this.bones[i].parent instanceof THREE.Bone&&(t.vertices.push(new THREE.Vector3),t.vertices.push(new THREE.Vector3),t.colors.push(new THREE.Color(0,0,1)),t.colors.push(new THREE.Color(0,1,0)));t.dynamic=!0,i=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors,depthTest:!1,depthWrite:!1,transparent:!0}),THREE.LineSegments.call(this,t,i),this.root=e,this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,this.update()},THREE.SkeletonHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.SkeletonHelper.prototype.constructor=THREE.SkeletonHelper,THREE.SkeletonHelper.prototype.getBoneList=function(e){var t=[];e instanceof THREE.Bone&&t.push(e);for(var i=0;i<e.children.length;i++)t.push.apply(t,this.getBoneList(e.children[i]));return t},THREE.SkeletonHelper.prototype.update=function(){for(var e=this.geometry,t=(new THREE.Matrix4).getInverse(this.root.matrixWorld),i=new THREE.Matrix4,r=0,n=0;n<this.bones.length;n++){var o=this.bones[n];o.parent instanceof THREE.Bone&&(i.multiplyMatrices(t,o.matrixWorld),e.vertices[r].setFromMatrixPosition(i),i.multiplyMatrices(t,o.parent.matrixWorld),e.vertices[r+1].setFromMatrixPosition(i),r+=2)}e.verticesNeedUpdate=!0,e.computeBoundingSphere()},THREE.SpotLightHelper=function(e){THREE.Object3D.call(this),this.light=e,this.light.updateMatrixWorld(),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1,e=new THREE.BufferGeometry;for(var t=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1],i=0,r=1;32>i;i++,r++){var n=i/32*Math.PI*2,o=r/32*Math.PI*2;t.push(Math.cos(n),Math.sin(n),1,Math.cos(o),Math.sin(o),1)}e.addAttribute("position",new THREE.Float32Attribute(t,3)),t=new THREE.LineBasicMaterial({fog:!1}),this.cone=new THREE.LineSegments(e,t),this.add(this.cone),this.update()},THREE.SpotLightHelper.prototype=Object.create(THREE.Object3D.prototype),THREE.SpotLightHelper.prototype.constructor=THREE.SpotLightHelper,THREE.SpotLightHelper.prototype.dispose=function(){this.cone.geometry.dispose(),this.cone.material.dispose()},THREE.SpotLightHelper.prototype.update=function(){var e=new THREE.Vector3,t=new THREE.Vector3;return function(){var i=this.light.distance?this.light.distance:1e3,r=i*Math.tan(this.light.angle);this.cone.scale.set(r,r,i),e.setFromMatrixPosition(this.light.matrixWorld),t.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(t.sub(e)),this.cone.material.color.copy(this.light.color).multiplyScalar(this.light.intensity)}}(),THREE.VertexNormalsHelper=function(e,t,i,r){this.object=e,this.size=void 0!==t?t:1,e=void 0!==i?i:16711680,r=void 0!==r?r:1,t=0,i=this.object.geometry,i instanceof THREE.Geometry?t=3*i.faces.length:i instanceof THREE.BufferGeometry&&(t=i.attributes.normal.count),i=new THREE.BufferGeometry,t=new THREE.Float32Attribute(6*t,3),i.addAttribute("position",t),THREE.LineSegments.call(this,i,new THREE.LineBasicMaterial({color:e,linewidth:r})),this.matrixAutoUpdate=!1,this.update()},THREE.VertexNormalsHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.VertexNormalsHelper.prototype.constructor=THREE.VertexNormalsHelper,THREE.VertexNormalsHelper.prototype.update=function(){var e=new THREE.Vector3,t=new THREE.Vector3,i=new THREE.Matrix3;return function(){var r=["a","b","c"];this.object.updateMatrixWorld(!0),i.getNormalMatrix(this.object.matrixWorld);var n=this.object.matrixWorld,o=this.geometry.attributes.position,a=this.object.geometry;if(a instanceof THREE.Geometry)for(var s=a.vertices,c=a.faces,h=a=0,l=c.length;l>h;h++)for(var u=c[h],p=0,d=u.vertexNormals.length;d>p;p++){var f=u.vertexNormals[p];e.copy(s[u[r[p]]]).applyMatrix4(n),t.copy(f).applyMatrix3(i).normalize().multiplyScalar(this.size).add(e),o.setXYZ(a,e.x,e.y,e.z),a+=1,o.setXYZ(a,t.x,t.y,t.z),a+=1}else if(a instanceof THREE.BufferGeometry)for(r=a.attributes.position,s=a.attributes.normal,p=a=0,d=r.count;d>p;p++)e.set(r.getX(p),r.getY(p),r.getZ(p)).applyMatrix4(n),t.set(s.getX(p),s.getY(p),s.getZ(p)),t.applyMatrix3(i).normalize().multiplyScalar(this.size).add(e),o.setXYZ(a,e.x,e.y,e.z),a+=1,o.setXYZ(a,t.x,t.y,t.z),a+=1;return o.needsUpdate=!0,this}}(),THREE.WireframeHelper=function(e,t){var i=void 0!==t?t:16777215;THREE.LineSegments.call(this,new THREE.WireframeGeometry(e.geometry),new THREE.LineBasicMaterial({color:i})),this.matrix=e.matrixWorld,this.matrixAutoUpdate=!1},THREE.WireframeHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.WireframeHelper.prototype.constructor=THREE.WireframeHelper,THREE.ImmediateRenderObject=function(e){THREE.Object3D.call(this),this.material=e,this.render=function(e){}},THREE.ImmediateRenderObject.prototype=Object.create(THREE.Object3D.prototype),THREE.ImmediateRenderObject.prototype.constructor=THREE.ImmediateRenderObject,THREE.MorphBlendMesh=function(e,t){THREE.Mesh.call(this,e,t),this.animationsMap={},this.animationsList=[];var i=this.geometry.morphTargets.length;this.createAnimation("__default",0,i-1,i/1),this.setAnimationWeight("__default",1)},THREE.MorphBlendMesh.prototype=Object.create(THREE.Mesh.prototype),THREE.MorphBlendMesh.prototype.constructor=THREE.MorphBlendMesh,THREE.MorphBlendMesh.prototype.createAnimation=function(e,t,i,r){t={start:t,end:i,length:i-t+1,fps:r,duration:(i-t)/r,lastFrame:0,currentFrame:0,active:!1,time:0,direction:1,weight:1,directionBackwards:!1,mirroredLoop:!1},this.animationsMap[e]=t,this.animationsList.push(t)},THREE.MorphBlendMesh.prototype.autoCreateAnimations=function(e){for(var t,i=/([a-z]+)_?(\d+)/i,r={},n=this.geometry,o=0,a=n.morphTargets.length;a>o;o++){var s=n.morphTargets[o].name.match(i);if(s&&1<s.length){var c=s[1];r[c]||(r[c]={start:1/0,end:-(1/0)}),s=r[c],o<s.start&&(s.start=o),o>s.end&&(s.end=o),t||(t=c)}}for(c in r)s=r[c],this.createAnimation(c,s.start,s.end,e);this.firstAnimation=t},THREE.MorphBlendMesh.prototype.setAnimationDirectionForward=function(e){(e=this.animationsMap[e])&&(e.direction=1,e.directionBackwards=!1)},THREE.MorphBlendMesh.prototype.setAnimationDirectionBackward=function(e){(e=this.animationsMap[e])&&(e.direction=-1,e.directionBackwards=!0)},THREE.MorphBlendMesh.prototype.setAnimationFPS=function(e,t){var i=this.animationsMap[e];i&&(i.fps=t,i.duration=(i.end-i.start)/i.fps)},THREE.MorphBlendMesh.prototype.setAnimationDuration=function(e,t){var i=this.animationsMap[e];i&&(i.duration=t,i.fps=(i.end-i.start)/i.duration)},THREE.MorphBlendMesh.prototype.setAnimationWeight=function(e,t){var i=this.animationsMap[e];i&&(i.weight=t)},THREE.MorphBlendMesh.prototype.setAnimationTime=function(e,t){var i=this.animationsMap[e];i&&(i.time=t)},THREE.MorphBlendMesh.prototype.getAnimationTime=function(e){var t=0;return(e=this.animationsMap[e])&&(t=e.time),t},THREE.MorphBlendMesh.prototype.getAnimationDuration=function(e){var t=-1;return(e=this.animationsMap[e])&&(t=e.duration),t},THREE.MorphBlendMesh.prototype.playAnimation=function(e){var t=this.animationsMap[e];t?(t.time=0,t.active=!0):console.warn("THREE.MorphBlendMesh: animation["+e+"] undefined in .playAnimation()")},THREE.MorphBlendMesh.prototype.stopAnimation=function(e){(e=this.animationsMap[e])&&(e.active=!1)},THREE.MorphBlendMesh.prototype.update=function(e){for(var t=0,i=this.animationsList.length;i>t;t++){var r=this.animationsList[t];if(r.active){var n=r.duration/r.length;r.time+=r.direction*e,r.mirroredLoop?(r.time>r.duration||0>r.time)&&(r.direction*=-1,r.time>r.duration&&(r.time=r.duration,r.directionBackwards=!0),0>r.time&&(r.time=0,r.directionBackwards=!1)):(r.time%=r.duration,0>r.time&&(r.time+=r.duration));var o=r.start+THREE.Math.clamp(Math.floor(r.time/n),0,r.length-1),a=r.weight;o!==r.currentFrame&&(this.morphTargetInfluences[r.lastFrame]=0,this.morphTargetInfluences[r.currentFrame]=1*a,this.morphTargetInfluences[o]=0,r.lastFrame=r.currentFrame,r.currentFrame=o),n=r.time%n/n,r.directionBackwards&&(n=1-n),r.currentFrame!==r.lastFrame?(this.morphTargetInfluences[r.currentFrame]=n*a,this.morphTargetInfluences[r.lastFrame]=(1-n)*a):this.morphTargetInfluences[r.currentFrame]=a}}},THREE.OrbitControls=function(e,t){function i(){return 2*Math.PI/60/60*p.autoRotateSpeed}function r(){return Math.pow(.95,p.zoomSpeed)}function n(e){if(p.enabled!==!1){if(e.preventDefault(),0===e.button){if(p.noRotate===!0)return;L=S.ROTATE,f.set(e.clientX,e.clientY)}else if(1===e.button){if(p.noZoom===!0)return;L=S.DOLLY,y.set(e.clientX,e.clientY)}else if(2===e.button){if(p.noPan===!0)return;L=S.PAN,g.set(e.clientX,e.clientY)}p.domElement.addEventListener("mousemove",o,!1),p.domElement.addEventListener("mouseup",a,!1)}}function o(e){if(p.enabled!==!1){e.preventDefault();var t=p.domElement===document?p.domElement.body:p.domElement;if(L===S.ROTATE){if(p.noRotate===!0)return;E.set(e.clientX,e.clientY),m.subVectors(E,f),p.rotateLeft(2*Math.PI*m.x/t.clientWidth*p.rotateSpeed),p.rotateUp(2*Math.PI*m.y/t.clientHeight*p.rotateSpeed),f.copy(E)}else if(L===S.DOLLY){if(p.noZoom===!0)return;R.set(e.clientX,e.clientY),x.subVectors(R,y),x.y>0?p.dollyIn():p.dollyOut(),y.copy(R)}else if(L===S.PAN){if(p.noPan===!0)return;T.set(e.clientX,e.clientY),v.subVectors(T,g),p.pan(v),g.copy(T)}p.update()}}function a(){p.enabled!==!1&&(p.domElement.removeEventListener("mousemove",o,!1),p.domElement.removeEventListener("mouseup",a,!1),L=S.NONE)}function s(e){if(p.enabled!==!1&&p.noZoom!==!0){var t=0;e.wheelDelta?t=e.wheelDelta:e.detail&&(t=-e.detail),t>0?p.dollyOut():p.dollyIn()}}function c(e){if(p.enabled!==!1&&p.noKeys!==!0&&p.noPan!==!0){var t=!1;switch(e.keyCode){case p.keys.UP:p.pan(new THREE.Vector2(0,p.keyPanSpeed)),t=!0;break;case p.keys.BOTTOM:p.pan(new THREE.Vector2(0,-p.keyPanSpeed)),t=!0;break;case p.keys.LEFT:p.pan(new THREE.Vector2(p.keyPanSpeed,0)),t=!0;break;case p.keys.RIGHT:p.pan(new THREE.Vector2(-p.keyPanSpeed,0)),t=!0}t&&p.update()}}function h(e){if(p.enabled!==!1)switch(e.touches.length){case 1:if(p.noRotate===!0)return;L=S.TOUCH_ROTATE,f.set(e.touches[0].pageX,e.touches[0].pageY);break;case 2:if(p.noZoom===!0)return;L=S.TOUCH_DOLLY;var t=e.touches[0].pageX-e.touches[1].pageX,i=e.touches[0].pageY-e.touches[1].pageY,r=Math.sqrt(t*t+i*i);y.set(0,r);break;case 3:if(p.noPan===!0)return;L=S.TOUCH_PAN,g.set(e.touches[0].pageX,e.touches[0].pageY);break;default:L=S.NONE}}function l(e){if(p.enabled!==!1){e.preventDefault(),e.stopPropagation();var t=p.domElement===document?p.domElement.body:p.domElement;switch(e.touches.length){case 1:if(p.noRotate===!0)return;if(L!==S.TOUCH_ROTATE)return;E.set(e.touches[0].pageX,e.touches[0].pageY),m.subVectors(E,f),p.rotateLeft(2*Math.PI*m.x/t.clientWidth*p.rotateSpeed),p.rotateUp(2*Math.PI*m.y/t.clientHeight*p.rotateSpeed),f.copy(E);break;case 2:if(p.noZoom===!0)return;if(L!==S.TOUCH_DOLLY)return;var i=e.touches[0].pageX-e.touches[1].pageX,r=e.touches[0].pageY-e.touches[1].pageY,n=Math.sqrt(i*i+r*r);R.set(0,n),x.subVectors(R,y),x.y>0?p.dollyOut():p.dollyIn(),y.copy(R);break;case 3:if(p.noPan===!0)return;if(L!==S.TOUCH_PAN)return;T.set(e.touches[0].pageX,e.touches[0].pageY),v.subVectors(T,g),p.pan(v),g.copy(T);break;default:L=S.NONE}}}function u(){p.enabled!==!1&&(L=S.NONE)}this.object=e,this.domElement=void 0!==t?t:document,this.enabled=!0,this.target=new THREE.Vector3,this.center=this.target,this.noZoom=!1,this.zoomSpeed=1,this.minDistance=0,this.maxDistance=1/0,this.noRotate=!1,this.rotateSpeed=1,this.noPan=!1,this.keyPanSpeed=7,this.autoRotate=!1,this.autoRotateSpeed=2,this.minPolarAngle=0,this.maxPolarAngle=Math.PI,this.noKeys=!1,this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40};var p=this,d=1e-6,f=new THREE.Vector2,E=new THREE.Vector2,m=new THREE.Vector2,g=new THREE.Vector2,T=new THREE.Vector2,v=new THREE.Vector2,y=new THREE.Vector2,R=new THREE.Vector2,x=new THREE.Vector2,H=0,b=0,_=1,M=new THREE.Vector3,w=new THREE.Vector3,S={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_DOLLY:4,TOUCH_PAN:5},L=S.NONE,A={type:"change"};this.rotateLeft=function(e){void 0===e&&(e=i()),b-=e},this.rotateUp=function(e){void 0===e&&(e=i()),H-=e},this.panLeft=function(e){var t=new THREE.Vector3,i=this.object.matrix.elements;t.set(i[0],i[1],i[2]),t.multiplyScalar(-e),M.add(t)},this.panUp=function(e){var t=new THREE.Vector3,i=this.object.matrix.elements;t.set(i[4],i[5],i[6]),t.multiplyScalar(e),M.add(t)},this.pan=function(e){var t=p.domElement===document?p.domElement.body:p.domElement;if(void 0!==p.object.fov){var i=p.object.position,r=i.clone().sub(p.target),n=r.length();n*=Math.tan(p.object.fov/2*Math.PI/180),p.panLeft(2*e.x*n/t.clientHeight),p.panUp(2*e.y*n/t.clientHeight)}else void 0!==p.object.top?(p.panLeft(e.x*(p.object.right-p.object.left)/t.clientWidth),p.panUp(e.y*(p.object.top-p.object.bottom)/t.clientHeight)):console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled.")},this.dollyIn=function(e){void 0===e&&(e=r()),_/=e},this.dollyOut=function(e){void 0===e&&(e=r()),_*=e},this.update=function(){var e=this.object.position,t=e.clone().sub(this.target),r=Math.atan2(t.x,t.z),n=Math.atan2(Math.sqrt(t.x*t.x+t.z*t.z),t.y);this.autoRotate&&this.rotateLeft(i()),r+=b,n+=H,n=Math.max(this.minPolarAngle,Math.min(this.maxPolarAngle,n)),n=Math.max(d,Math.min(Math.PI-d,n));var o=t.length()*_;o=Math.max(this.minDistance,Math.min(this.maxDistance,o)),this.target.add(M),t.x=o*Math.sin(n)*Math.sin(r),t.y=o*Math.cos(n),t.z=o*Math.sin(n)*Math.cos(r),e.copy(this.target).add(t),this.object.lookAt(this.target),b=0,H=0,_=1,M.set(0,0,0),w.distanceTo(this.object.position)>0&&(this.dispatchEvent(A),w.copy(this.object.position))},this.domElement.addEventListener("contextmenu",function(e){e.preventDefault()},!1),this.domElement.addEventListener("mousedown",n,!1),this.domElement.addEventListener("mousewheel",s,!1),this.domElement.addEventListener("DOMMouseScroll",s,!1),this.domElement.addEventListener("keydown",c,!1),this.domElement.addEventListener("touchstart",h,!1),this.domElement.addEventListener("touchend",u,!1),this.domElement.addEventListener("touchmove",l,!1)},THREE.OrbitControls.prototype=Object.create(THREE.EventDispatcher.prototype);