// EQCSS / Tommy Hodgins, Maxime Euzière / MIT license
// version 1.7.0
(function(root,factory){if(typeof define==="function"&&define.amd)define([],factory);else if(typeof module==="object"&&module.exports)module.exports=factory();else root.EQCSS=factory()})(this,function(){var EQCSS={data:[]};EQCSS.load=function(){var styles=document.getElementsByTagName("style");for(var i=0;i<styles.length;i++)if(styles[i].getAttribute("data-eqcss-read")===null){styles[i].setAttribute("data-eqcss-read","true");EQCSS.process(styles[i].innerHTML)}var script=document.getElementsByTagName("script");
for(var i=0;i<script.length;i++)if(script[i].getAttribute("data-eqcss-read")===null&&script[i].type==="text/eqcss"){if(script[i].src)(function(){var xhr=new XMLHttpRequest;xhr.open("GET",script[i].src,true);xhr.send(null);xhr.onreadystatechange=function(){EQCSS.process(xhr.responseText)}})();else EQCSS.process(script[i].innerHTML);script[i].setAttribute("data-eqcss-read","true")}var link=document.getElementsByTagName("link");for(i=0;i<link.length;i++)if(link[i].getAttribute("data-eqcss-read")===null&&
link[i].rel==="stylesheet"){if(link[i].href)(function(){var xhr=new XMLHttpRequest;xhr.open("GET",link[i].href,true);xhr.send(null);xhr.onreadystatechange=function(){EQCSS.process(xhr.responseText)}})();link[i].setAttribute("data-eqcss-read","true")}};EQCSS.parse=function(code){var parsed_queries=new Array;code=code.replace(/\s+/g," ");code=code.replace(/\/\*[\w\W]*?\*\//g,"");code=code.replace(/@element/g,"\n@element");code=code.replace(/(@element.*?\{([^}]*?\{[^}]*?\}[^}]*?)*\}).*/g,"$1");code.replace(/(@element.*(?!@element))/g,
function(string,query){var dataEntry={};query.replace(/(@element)\s*(".*?"|'.*?'|.*?)\s*(and\s*\(|{)/g,function(string,atrule,selector,extra){selector=selector.replace(/^\s?['](.*)[']/,"$1");selector=selector.replace(/^\s?["](.*)["]/,"$1");dataEntry.selector=selector});dataEntry.conditions=[];query.replace(/and ?\( ?([^:]*) ?: ?([^)]*) ?\)/g,function(string,measure,value){var unit=null;unit=value.replace(/^(\d*\.?\d+)(\D+)$/,"$2");if(unit===value)unit=null;value=value.replace(/^(\d*\.?\d+)\D+$/,"$1");
dataEntry.conditions.push({measure:measure,value:value,unit:unit})});query.replace(/{(.*)}/g,function(string,style){dataEntry.style=style});parsed_queries.push(dataEntry)});return parsed_queries};EQCSS.register=function(queries){if(Object.prototype.toString.call(queries)==="[object Object]"){EQCSS.data.push(queries);EQCSS.apply()}if(Object.prototype.toString.call(queries)==="[object Array]"){for(var i=0;i<queries.length;i++)EQCSS.data.push(queries[i]);EQCSS.apply()}};EQCSS.process=function(code){var queries=
EQCSS.parse(code);return EQCSS.register(queries)};EQCSS.apply=function(){var i,j,k;var elements;var element_guid;var css_block;var element_guid_parent;var element_guid_prev;var element_guid_next;var css_code;var element_width,parent_width;var element_height,parent_height;var element_line_height;var test;var computed_style;var parent_computed_style;for(i=0;i<EQCSS.data.length;i++){elements=document.querySelectorAll(EQCSS.data[i].selector);for(j=0;j<elements.length;j++){element_guid="data-eqcss-"+i+
"-"+j;elements[j].setAttribute(element_guid,"");element_guid_parent="data-eqcss-"+i+"-"+j+"-parent";if(elements[j]!=document.documentElement)elements[j].parentNode.setAttribute(element_guid_parent,"");element_guid_prev="data-eqcss-"+i+"-"+j+"-prev";var prev_sibling=function(el){while(el=el.previousSibling)if(el.nodeType===1)return el}(elements[j]);if(prev_sibling)prev_sibling.setAttribute(element_guid_prev,"");element_guid_next="data-eqcss-"+i+"-"+j+"-next";var next_sibling=function(el){while(el=
el.nextSibling)if(el.nodeType===1)return el}(elements[j]);if(next_sibling)next_sibling.setAttribute(element_guid_next,"");css_block=document.querySelector("#"+element_guid);if(!css_block){css_block=document.createElement("style");css_block.id=element_guid;css_block.setAttribute("data-eqcss-read","true");document.querySelector("head").appendChild(css_block)}css_block=document.querySelector("#"+element_guid);test=true;test_conditions:for(k=0;k<EQCSS.data[i].conditions.length;k++){computed_style=window.getComputedStyle(elements[j],
null);parent_computed_style=null;if(elements[j]!=document.documentElement)parent_computed_style=window.getComputedStyle(elements[j].parentNode,null);var recomputed=false;if(EQCSS.data[i].conditions[k].unit==="vw"){recomputed=true;var value=parseInt(EQCSS.data[i].conditions[k].value);EQCSS.data[i].conditions[k].recomputed_value=value*window.innerWidth/100}else if(EQCSS.data[i].conditions[k].unit==="vh"){recomputed=true;var value=parseInt(EQCSS.data[i].conditions[k].value);EQCSS.data[i].conditions[k].recomputed_value=
value*window.innerHeight/100}else if(EQCSS.data[i].conditions[k].unit==="vmin"){recomputed=true;var value=parseInt(EQCSS.data[i].conditions[k].value);EQCSS.data[i].conditions[k].recomputed_value=value*Math.min(window.innerWidth,window.innerHeight)/100}else if(EQCSS.data[i].conditions[k].unit==="vmax"){recomputed=true;var value=parseInt(EQCSS.data[i].conditions[k].value);EQCSS.data[i].conditions[k].recomputed_value=value*Math.max(window.innerWidth,window.innerHeight)/100}else if(EQCSS.data[i].conditions[k].unit!=
null&&EQCSS.data[i].conditions[k].unit!="px"&&EQCSS.data[i].conditions[k].unit!="%"){var div=document.createElement("div");div.style.visibility="hidden";div.style.border="1px solid red";div.style.width=EQCSS.data[i].conditions[k].value+EQCSS.data[i].conditions[k].unit;var position=elements[j];if(elements[j]!=document.documentElement)position=elements[j].parentNode;position.appendChild(div);EQCSS.data[i].conditions[k].value=parseInt(window.getComputedStyle(div,null).getPropertyValue("width"));EQCSS.data[i].conditions[k].unit=
"px";position.removeChild(div)}var final_value=recomputed?EQCSS.data[i].conditions[k].recomputed_value:parseInt(EQCSS.data[i].conditions[k].value);switch(EQCSS.data[i].conditions[k].measure){case "min-width":if(recomputed===true||EQCSS.data[i].conditions[k].unit==="px"){element_width=parseInt(computed_style.getPropertyValue("width"));if(!(element_width>=final_value)){test=false;break test_conditions}}if(EQCSS.data[i].conditions[k].unit==="%"){element_width=parseInt(computed_style.getPropertyValue("width"));
parent_width=parseInt(parent_computed_style.getPropertyValue("width"));if(!(parent_width/element_width<=100/final_value)){test=false;break test_conditions}}break;case "max-width":if(recomputed===true||EQCSS.data[i].conditions[k].unit==="px"){element_width=parseInt(computed_style.getPropertyValue("width"));if(!(element_width<=final_value)){test=false;break test_conditions}}if(EQCSS.data[i].conditions[k].unit==="%"){element_width=parseInt(computed_style.getPropertyValue("width"));parent_width=parseInt(parent_computed_style.getPropertyValue("width"));
if(!(parent_width/element_width>=100/final_value)){test=false;break test_conditions}}break;case "min-height":if(recomputed===true||EQCSS.data[i].conditions[k].unit==="px"){element_height=parseInt(computed_style.getPropertyValue("height"));if(!(element_height>=final_value)){test=false;break test_conditions}}if(EQCSS.data[i].conditions[k].unit==="%"){element_height=parseInt(computed_style.getPropertyValue("height"));parent_height=parseInt(parent_computed_style.getPropertyValue("height"));if(!(parent_height/
element_height<=100/final_value)){test=false;break test_conditions}}break;case "max-height":if(recomputed===true||EQCSS.data[i].conditions[k].unit==="px"){element_height=parseInt(computed_style.getPropertyValue("height"));if(!(element_height<=final_value)){test=false;break test_conditions}}if(EQCSS.data[i].conditions[k].unit==="%"){element_height=parseInt(computed_style.getPropertyValue("height"));parent_height=parseInt(parent_computed_style.getPropertyValue("height"));if(!(parent_height/element_height>=
100/final_value)){test=false;break test_conditions}}break;case "min-scroll-x":var element=elements[j];var element_scroll=element.scrollLeft;if(!element.hasScrollListener)if(element===document.documentElement||element===document.body)window.addEventListener("scroll",function(){EQCSS.throttle();element.hasScrollListener=true});else element.addEventListener("scroll",function(){EQCSS.throttle();element.hasScrollListener=true});if(recomputed===true||EQCSS.data[i].conditions[k].unit==="px"){if(!(element_scroll>=
final_value)){test=false;break test_conditions}}else if(EQCSS.data[i].conditions[k].unit==="%"){var element_scroll_size=elements[j].scrollWidth;var element_size;if(elements[j]===document.documentElement||elements[j]===document.body)element_size=window.innerWidth;else element_size=parseInt(computed_style.getPropertyValue("width"));if(!(element_scroll/(element_scroll_size-element_size)*100>=final_value)){test=false;break test_conditions}}break;case "min-scroll-y":var element=elements[j];element_scroll=
elements[j].scrollTop;if(!element.hasScrollListener)if(element===document.documentElement||element===document.body)window.addEventListener("scroll",function(){EQCSS.throttle();element.hasScrollListener=true});else element.addEventListener("scroll",function(){EQCSS.throttle();element.hasScrollListener=true});if(recomputed===true||EQCSS.data[i].conditions[k].unit==="px"){if(!(element_scroll>=final_value)){test=false;break test_conditions}}else if(EQCSS.data[i].conditions[k].unit==="%"){var element_scroll_size=
elements[j].scrollHeight;var element_size;if(elements[j]===document.documentElement||elements[j]===document.body)element_size=window.innerHeight;else element_size=parseInt(computed_style.getPropertyValue("height"));if(!(element_scroll/(element_scroll_size-element_size)*100>=final_value)){test=false;break test_conditions}}break;case "max-scroll-x":var element=elements[j];element_scroll=elements[j].scrollLeft;if(!element.hasScrollListener)if(element===document.documentElement||element===document.body)window.addEventListener("scroll",
function(){EQCSS.throttle();element.hasScrollListener=true});else element.addEventListener("scroll",function(){EQCSS.throttle();element.hasScrollListener=true});if(recomputed===true||EQCSS.data[i].conditions[k].unit==="px"){if(!(element_scroll<=final_value)){test=false;break test_conditions}}else if(EQCSS.data[i].conditions[k].unit==="%"){var element_scroll_size=elements[j].scrollWidth;var element_size;if(elements[j]===document.documentElement||elements[j]===document.body)element_size=window.innerWidth;
else element_size=parseInt(computed_style.getPropertyValue("width"));if(!(element_scroll/(element_scroll_size-element_size)*100<=final_value)){test=false;break test_conditions}}break;case "max-scroll-y":var element=elements[j];element_scroll=elements[j].scrollTop;if(!element.hasScrollListener)if(element===document.documentElement||element===document.body)window.addEventListener("scroll",function(){EQCSS.throttle();element.hasScrollListener=true});else element.addEventListener("scroll",function(){EQCSS.throttle();
element.hasScrollListener=true});if(recomputed===true||EQCSS.data[i].conditions[k].unit==="px"){if(!(element_scroll<=final_value)){test=false;break test_conditions}}else if(EQCSS.data[i].conditions[k].unit==="%"){var element_scroll_size=elements[j].scrollHeight;var element_size;if(elements[j]===document.documentElement||elements[j]===document.body)element_size=window.innerHeight;else element_size=parseInt(computed_style.getPropertyValue("height"));if(!(element_scroll/(element_scroll_size-element_size)*
100<=final_value)){test=false;break test_conditions}}break;case "min-characters":if(elements[j].value){if(!(elements[j].value.length>=final_value)){test=false;break test_conditions}}else if(!(elements[j].textContent.length>=final_value)){test=false;break test_conditions}break;case "max-characters":if(elements[j].value){if(!(elements[j].value.length<=final_value)){test=false;break test_conditions}}else if(!(elements[j].textContent.length<=final_value)){test=false;break test_conditions}break;case "min-children":if(!(elements[j].children.length>=
final_value)){test=false;break test_conditions}break;case "max-children":if(!(elements[j].children.length<=final_value)){test=false;break test_conditions}break;case "min-lines":element_height=parseInt(computed_style.getPropertyValue("height"))-parseInt(computed_style.getPropertyValue("border-top-width"))-parseInt(computed_style.getPropertyValue("border-bottom-width"))-parseInt(computed_style.getPropertyValue("padding-top"))-parseInt(computed_style.getPropertyValue("padding-bottom"));element_line_height=
computed_style.getPropertyValue("line-height");if(element_line_height==="normal"){var element_font_size=parseInt(computed_style.getPropertyValue("font-size"));element_line_height=element_font_size*1.125}else element_line_height=parseInt(element_line_height);if(!(element_height/element_line_height>=final_value)){test=false;break test_conditions}break;case "max-lines":element_height=parseInt(computed_style.getPropertyValue("height"))-parseInt(computed_style.getPropertyValue("border-top-width"))-parseInt(computed_style.getPropertyValue("border-bottom-width"))-
parseInt(computed_style.getPropertyValue("padding-top"))-parseInt(computed_style.getPropertyValue("padding-bottom"));element_line_height=computed_style.getPropertyValue("line-height");if(element_line_height==="normal"){var element_font_size=parseInt(computed_style.getPropertyValue("font-size"));element_line_height=element_font_size*1.125}else element_line_height=parseInt(element_line_height);if(!(element_height/element_line_height+1<=final_value)){test=false;break test_conditions}break;case "orientation":if(EQCSS.data[i].conditions[k].value===
"square")if(!(elements[j].offsetWidth===elements[j].offsetHeight)){test=false;break test_conditions}if(EQCSS.data[i].conditions[k].value==="portrait")if(!(elements[j].offsetWidth<elements[j].offsetHeight)){test=false;break test_conditions}if(EQCSS.data[i].conditions[k].value==="landscape")if(!(elements[j].offsetHeight<elements[j].offsetWidth)){test=false;break test_conditions}break;case "min-aspect-ratio":var el_width=EQCSS.data[i].conditions[k].value.split("/")[0];var el_height=EQCSS.data[i].conditions[k].value.split("/")[1];
if(!(el_width/el_height<=elements[j].offsetWidth/elements[j].offsetHeight)){test=false;break test_conditions}break;case "max-aspect-ratio":var el_width=EQCSS.data[i].conditions[k].value.split("/")[0];var el_height=EQCSS.data[i].conditions[k].value.split("/")[1];if(!(elements[j].offsetWidth/elements[j].offsetHeight<=el_width/el_height)){test=false;break test_conditions}break}}if(test===true){css_code=EQCSS.data[i].style;css_code=css_code.replace(/eval\( *((".*?")|('.*?')) *\)/g,function(string,match){return EQCSS.tryWithEval(elements[j],
match)});css_code=css_code.replace(/(\$|eq_)this/gi,"["+element_guid+"]");css_code=css_code.replace(/(\$|eq_)parent/gi,"["+element_guid_parent+"]");css_code=css_code.replace(/(\$|eq_)prev/gi,"["+element_guid_prev+"]");css_code=css_code.replace(/(\$|eq_)next/gi,"["+element_guid_next+"]");css_code=css_code.replace(/(\$|eq_)root/gi,"html");css_code=css_code.replace(/(\d*\.?\d+)(?:\s*)(ew|eh|emin|emax)/gi,function(match,$1,$2){switch($2){case "ew":return elements[j].offsetWidth/100*$1+"px";break;case "eh":return elements[j].offsetHeight/
100*$1+"px";break;case "emin":return Math.min(elements[j].offsetWidth,elements[j].offsetHeight)/100*$1+"px";break;case "emax":return Math.max(elements[j].offsetWidth,elements[j].offsetHeight)/100*$1+"px";break}});try{css_block.innerHTML=css_code}catch(e){css_block.styleSheet.cssText=css_code}}else try{css_block.innerHTML=""}catch(e$0){css_block.styleSheet.cssText=""}}}};EQCSS.tryWithEval=function(element,string){var $it=element;var ret="";try{with($it)ret=eval(string.slice(1,-1))}catch(e){ret=""}return ret};
EQCSS.reset=function(){EQCSS.data=[];var style_tag=document.querySelectorAll('head style[id^="data-eqcss-"]');for(var i=0;i<style_tag.length;i++)style_tag[i].parentNode.removeChild(style_tag[i]);var tag=document.querySelectorAll("*");for(var j=0;j<tag.length;j++)for(var k=0;k<tag[j].attributes.length;k++)if(tag[j].attributes[k].name.indexOf("data-eqcss-")===0)tag[j].removeAttribute(tag[j].attributes[k].name)};EQCSS.domReady=function(fn){var done=false;var top=true;var doc=window.document;var root=
doc.documentElement;var modern=!~navigator.userAgent.indexOf("MSIE 8");var add=modern?"addEventListener":"attachEvent";var rem=modern?"removeEventListener":"detachEvent";var pre=modern?"":"on";var init=function(e){if(e.type==="readystatechange"&&doc.readyState!=="complete")return;(e.type==="load"?window:doc)[rem](pre+e.type,init,false);if(!done&&(done=true))fn.call(window,e.type||e)},poll=function(){try{root.doScroll("left")}catch(e){setTimeout(poll,50);return}init("poll")};if(doc.readyState==="complete")fn.call(window,
"lazy");else{if(!modern&&root.doScroll){try{top=!window.frameElement}catch(e){}if(top)poll()}doc[add](pre+"DOMContentLoaded",init,false);doc[add](pre+"readystatechange",init,false);window[add](pre+"load",init,false)}};var EQCSS_throttle_available=true;var EQCSS_throttle_queued=false;var EQCSS_mouse_down=false;var EQCSS_timeout=200;EQCSS.throttle=function(){if(EQCSS_throttle_available){EQCSS.apply();EQCSS_throttle_available=false;setTimeout(function(){EQCSS_throttle_available=true;if(EQCSS_throttle_queued){EQCSS_throttle_queued=
false;EQCSS.apply()}},EQCSS_timeout)}else EQCSS_throttle_queued=true};EQCSS.domReady(function(){EQCSS.load();EQCSS.throttle()});window.addEventListener("resize",EQCSS.throttle);window.addEventListener("input",EQCSS.throttle);window.addEventListener("click",EQCSS.throttle);window.addEventListener("mousedown",function(e){if(e.which===1)EQCSS_mouse_down=true});window.addEventListener("mousemove",function(){if(EQCSS_mouse_down)EQCSS.throttle()});window.addEventListener("mouseup",function(){EQCSS_mouse_down=
false;EQCSS.throttle()});function l(a){console.log(a)}return EQCSS});