
/**
 * 焦点图切换(不包含前后切换),修改自 jfk.fn.picfocus插件
 * By Weizeyan[weizeyan52@126.com]
 * Project URI : http://designcss.org/public/jfk/source/jfk.fn.picfocus/jquery.html
*/
;(function($){
	//判断插件是否存在
	if(typeof($.fn.picfocus) !== "undefined"){
		return;
	};
	$.fn.extend({
		picfocus : function(options){
			options = options || {};
			var set = {
				tt : ".tab_tt",
				ttItem : "li",
				focusCls : "focus",
				ct : ".tab_ct",
				ctItem : "li",
				effect : "default", //default fade slide
				effectMs : 400,
				animatedCall : function(obj, index){},
				slideDir : "left", //如果effect设置为slide时， 对此进行设置。表示slide切换方向，目前使用left和top 
				seamlessSlide : false, // 如果effect设置为slide时，对此进行设置。表示是否无缝slide切换
				mouseType : "mouseover",//mouseover click
				autoPlay : true, //是否设置自动切换
				autoPlayTime : 3000, //自动切换的间隔
				hoverDelay : true, //是否设置悬停延时
				hoverDelayTime : 150,//悬停延时的时间
				startIndex : 0 //开始索引
			};
			set = $.extend(set, options);	
			return this.each(function(){
				//设置动画是否已结束的状态值 true | false
				var ANIMATED = true;
				//轮询ANIMATED的值是否为true的定时器
				var interval_animate = null;
				function clear_interval_animate(callback){
					callback = callback || function(){};
					if(interval_animate !== null){
						clearInterval(interval_animate);
						interval_animate = null;
						callback();
					};
				};
				function set_interval_animate(ms, callback){
					ms = parseInt(ms);
					callback = callback || function(){};
					clear_interval_animate();
					interval_animate = setInterval(function(){
						callback();	
					}, ms);
				};
				//相关节点对象
				var t = $(this), _t = this, ct = t.find(set.ct), ctItem = ct.find(set.ctItem), tt = t.find(set.tt), ttItem = tt.find(set.ttItem), 
				listWidth = 0, itemWidth = 0, listHeight = 0,itemHeight = 0,
				size = ( ctItem.size() === ttItem.size() ) ? ctItem.size() : 0, currentIndex = set.startIndex, auto = null, delay = null;
				//几种动画效果的判断，一次是默认（无效果）， 淡入淡出效果，滑动效果
				var isDefault = (set.effect === "default"), isFade = (set.effect === "fade"), isSlide = (set.effect === "slide"), isFadeSlide = /^(fade|slide)$/.test(set.effect);
				//如果选项卡子节点为空则退出
				if(size === 0){
					return ; 
				};
				
				init();
				
				//初始化配置和事件绑定
				function init(){
					tabTo(currentIndex);
					ttItem.each(function(i){
						$(this).attr({index : i});	
					});
					ttItem[set.mouseType](function(){
						var index = parseInt($(this).attr("index"));
						var focusIndex = parseInt(tt.find("." + set.focusCls).attr("index"));
						if(isDefault){
							if(set.mouseType === "mouseover" && set.hoverDelay === true){
								setDelay(set.hoverDelayTime, function(){
									tabTo(index);
								});
							}else{
								tabTo(index);
							};
						}else{
							if(set.mouseType === "mouseover" && set.hoverDelay === true){
								setDelay(set.hoverDelayTime, function(){
									listenerForFadeSlide(index, focusIndex);
								});
							}else{
								listenerForFadeSlide(index, focusIndex);
							};
						};
					});
					ttItem.mouseout(function(){
						stopDelay();
					});
					setAuto(currentIndex);
					t.hover(function(){stopAuto()}, function(){
						setAuto(currentIndex);	
						 
					});
					if(isFadeSlide){
						tt.css({zIndex : 2});
					};
					if(isFade){
						ct.css({position : "relative"});
						ctItem.css({position : "absolute" , zIndex : 0});
					};
					if(isSlide){
						ct.css({position : "absolute", left : 0, top : 0, zIndex : 1});
						var ctSizeCss = {};
						
						if(set.slideDir === "left"){
							listWidth = _t.offsetWidth * size;
							itemWidth = _t.offsetWidth;
							ctSizeCss.width = listWidth + "px";
						}else if(set.slideDir === "top"){
							listHeight = _t.offsetHeight * size;
							itemHeight = _t.offsetHeight;
							ctSizeCss.height = listHeight + "px";
						};
						ct.css(ctSizeCss);
					};
				};
				
				//侦听animate是否完成
				function listenerForFadeSlide(index, focusIndex){
					if(index !== focusIndex){
						set_interval_animate(1, function(){
							if(ANIMATED){
								clear_interval_animate(function(){
									tabTo(index);	
								});
							};
						});
					};
				};
				//定位标签卡
				function tabTo(index, state){
					state = state || ""; // 空字符|tofirst|tolast
					index = parseInt(index);
					currentIndex = index;
					var currentCtItem = ctItem.eq(index);
					if(isDefault){
						labelTo(index);
						currentCtItem.css({display : "block"}).siblings().css({display : "none"});
					}else if(isFade){
						labelTo(index);
						ANIMATED = false;
						currentCtItem.css({zIndex : 1}).hide().fadeIn(set.effectMs, function(){
							$(this).siblings().hide().css({zIndex : 0});
							$(this).css({zIndex  : 0});	
							ANIMATED = true;
							set.animatedCall.call(this, this, index);
						});
					}else if(isSlide){
						
						if(set.slideDir === "left"){
							 
							if(state === ""){
								var left = - (index * itemWidth);
								ct.animate({
									left : left + "px"
								}, set.effectMs, function(){
									labelTo(index);
									set.animatedCall.call(this, this, index);	
								});
							}else if(state === "tofirst"){
								toFirst("x");
							};
						}else if(set.slideDir === "top"){
							if(state === ""){
								var top = - (index * itemHeight);
								ct.animate({
									top : top + "px"
								}, set.effectMs, function(){
									labelTo(index);
									set.animatedCall.call(this, this, index);	
								});
							}else if(state === "tofirst"){
								toFirst("y");
							};
						};
					};
					
				};
				
				
				function toFirst(dir){
					dir = dir || "x";
					var firstNode = ct.find(set.ctItem).eq(0), _firstNode = firstNode.size() > 0 ? firstNode[0] : null;
					if(_firstNode === null){
						return;
					};
					var firstNode_1 = _firstNode.cloneNode(true);
					var firstNode_2 = _firstNode.cloneNode(true);
					firstNode.remove();
					ct.append(firstNode_1);
					if(dir === "x"){
						ct.css({left : - (itemWidth * (size - 2)) + "px"}).animate({
							left : 	- ((size - 1) * itemWidth) + "px"
						}, set.effectMs, function(){
							ct.find(set.ctItem).eq(size - 1).remove();
							ct.prepend(firstNode_2).css({left : 0});
							labelTo(0);
							set.animatedCall.call(this, this, 0);	
						});
					}else if(dir === "y"){
						ct.css({top : - (itemHeight * (size - 2)) + "px"}).animate({
							top : 	- ((size - 1) * itemHeight) + "px"
						}, set.effectMs, function(){
							ct.find(set.ctItem).eq(size - 1).remove();
							ct.prepend(firstNode_2).css({top : 0});
							labelTo(0);
							set.animatedCall.call(this, this, 0);	
						});
					};
				};
				
				function labelTo(index){
					ttItem.eq(index).addClass(set.focusCls).siblings().removeClass(set.focusCls);
				};
				
				
				
				//设置自动播放
				function setAuto(index){
					if(set.autoPlay === false){
						return;
					};
					var time = set.autoPlayTime;
					stopAuto();
					auto = setInterval(function(){
						currentIndex += 1;
						//设置无缝切换使第二个参数的值
						tabTo(currentIndex >= size ? 0 : currentIndex, set.seamlessSlide ? (currentIndex >= size ? "tofirst" : "") : "");
					}, time);
				};
				
				//停止自动播放
				function stopAuto(){
					if(auto !== null){
						clearInterval(auto);
						auto = null;
					};
				};
				
				//设置延时
				function setDelay(int_time, func_callBack){
					var time = int_time || 200;
					var callBack = func_callBack || function(){};
					stopDelay();
					delay = setTimeout(function(){
						callBack();
					}, time);
				};
				
				//清除延时
				function stopDelay(){
					if(delay !== null){
						clearTimeout(delay);
						delay =  null;
					};
				};
				 
						
			});
			
		}
	});
	
})(jQuery);