/**
 * 树形菜单控制类
 * @author zxub
 */
var TreeMenu=new function()
{   
    this._url=null;
    
    //加入样式
    document.write('<style type="text/css">');
    document.write('.treeCheckBox{height:11px; width:11px;vertical-align:middle}');
    document.write('.treeImg{cursor:pointer;vertical-align:text-bottom;margin-right:2px}');
    document.write('</style>');
    
    //定义图标显示用数组
	this.icon=new Array();
	this.icon["member"]='img/child.gif';
	this.icon["open"]='img/opened.gif';
	this.icon["close"]='img/closed.gif';	
     
	/**
	 * 获取指定节点的子节点
	 * @param _parentId:指定节点的id
	 */ 
	this.getChildren=function(_parentId)
	{
	    if (this.alreadyGetChileren(_parentId))
		{
		    var childContainer=document.getElementById(_parentId+"_subContainer");
		    if (childContainer)
		    {
		        childContainer.style.display=(childContainer.style.display=="none")?"":"none";
		        var _parentNode=document.getElementById(_parentId);
		        if (_parentNode.firstChild && _parentNode.firstChild.tagName=="IMG")
		        {
		            _parentNode.firstChild.src=(childContainer.style.display=="none")?this.icon["close"]:this.icon["open"];
		        }
		    }
		    return;
		}
		var processRequest=function(obj)
		{
		    TreeMenu.addChildren(_parentId,obj.responseXML);           
		}
		Request.send(this._url+"?pId="+_parentId,"",processRequest,_parentId+"");			
	}	
	
	/**
	 * 根据获取的数据，设置指定节点的子节点
	 * @param _parentId:指定节点id
	 * @param _data:获取的数据
	 */
	this.addChildren=function(_parentId,_data)
	{   
	    if (this.alreadyGetChileren(_parentId))
	    {	     
	        return;
	    }
	    
	    var _parentNode=document.getElementById(_parentId);
	    if (_parentNode.firstChild && _parentNode.firstChild.tagName=="IMG")
	    {
	        _parentNode.firstChild.src=this.icon["open"];
	    }	    	         
	    //子级容器，所有子级选项都放一个容器中
	    _nodeContainer=document.createElement("div");
		_nodeContainer.id=_parentId+"_subContainer";
		//子级容器放入父级容器
		_parentNode.appendChild(_nodeContainer);
		var _children=_data.getElementsByTagName("root")[0].childNodes;
		var _child=null;
		var _point=this;
		for(var i=0; i<_children.length; i++)
		{
			_child=_children[i];				
			_node=document.createElement("div");
			if (i!=_children.length-1)
			{
			    _node.style.cssText="padding-bottom:5px";
			}			
			_node.innerHTML="";
			_node.id=_child.getAttribute("id");			
			//若节点存在下级节点
			if (_child.getAttribute("hasChildren")=="1")
			{
			    _node.innerHTML+='<img class="treeImg" onclick="TreeMenu.getChildren('+_child.getAttribute("id")+')" src="'+this.icon["close"]+'"/>';
			    _node.innerHTML+='<span style="cursor:pointer;line-height:16px;height:16px" name="treeText" onclick="treeNodeChoosed(this);">'+_child.firstChild.data+'</span>';			    
			}
			//否则节点不存在下级节点
			else if (_child.getAttribute("hasChildren")==0)
			{
			    _node.innerHTML+='<img class="treeImg" onclick="try{treeNodeChoosed(this.nextSibling);}catch(e){alert(e.message);}" src="'+this.icon["member"]+'" style="margin-left:14px"/>';
			    _node.innerHTML+='<span style="cursor:pointer;line-height:16px;height:16px" name="treeText" onclick="treeNodeChoosed(this);">'+_child.firstChild.data+'</span>';			    
			}
			//节点加入子级容器
			_nodeContainer.appendChild(_node);						
		}
		_nodeContainer.style.cssText="border-left:0px solid #ccc;margin-left:7px;margin-top:5px;padding-left:10px";	    
	}
	
	/**
	 * 判断指定节点是否已经获取子节点
	 * @param _nodeId 指定节点id
	 * @return [boolean]true为已经获取，false为未获取
	 */
	this.alreadyGetChileren=function(_nodeId)
	{
	    var obj=document.getElementById(_nodeId+"_subContainer");
	    if (obj)
	    {	       
	        return true;               
	    }
	    return false;	    
	}	
}

/**
 * 点击菜单后的动作
 */
function treeNodeChoosed(_obj)
{
    var choosedColor="lightblue";
    var unChoosedColor="white";
    
    if (_obj.style.backgroundColor==choosedColor)
    {
        _obj.style.backgroundColor=unChoosedColor;           
    }
    else
    {
        //var allNodeText=document.getElementsByName("treeText");
        var allNodeText=document.getElementsByTagName("SPAN");
        for (var i=0; i<allNodeText.length; i++)
        {
            allNodeText[i].style.backgroundColor=unChoosedColor;
        }
        _obj.style.backgroundColor=choosedColor;
    }    
}