/*!
 * jmpress.js v0.4.5
 * http://jmpressjs.github.com/jmpress.js
 *
 * A jQuery plugin to build a website on the infinite canvas.
 *
 * Copyright 2013 Kyle Robinson Young @shama & Tobias Koppers @sokra
 * Licensed MIT
 * http://www.opensource.org/licenses/mit-license.php
 *
 * Based on the foundation laid by Bartek Szopka @bartaz
 */
(function(e, t, s, a) {
	"use strict";
	function r(e) {
		if (e) {
			var t = 1 + e.substr(1).search(/[A-Z]/),
			s = e.substr(0, t).toLowerCase(),
			a = e.substr(t).toLowerCase();
			return "-" + s + "-" + a
		}
	}
	function n(e) {
		return e ? e + ",": ""
	}
	function i(e) {
		return e.length > 0 ? e: null
	}
	function o(r) {
		function n(t, s) {
			var a = p(t),
			r = {
				oldStyle: e(t).attr("style") || ""
			},
			n = {
				data: a,
				stepData: r
			};
			f.call(this, "beforeInitStep", e(t), n),
			r.delegate = a.delegate,
			f.call(this, "initStep", e(t), n),
			e(t).data("stepData", r),
			e(t).attr("id") || e(t).attr("id", "step-" + (s + 1)),
			f.call(this, "applyStep", e(t), n)
		}
		function o(t) {
			var s = e(t).data("stepData");
			e(t).attr("style", s.oldStyle),
			f.call(this, "unapplyStep", e(t), {
				stepData: s
			})
		}
		function c(t) {
			f.call(this, "unapplyStep", e(t), {
				stepData: t.data("stepData")
			}),
			f.call(this, "applyStep", e(t), {
				stepData: t.data("stepData")
			})
		}
		function l() {
			O && f.call(this, "setInactive", O, {
				stepData: e(O).data("stepData"),
				reason: "deinit"
			}),
			Y.jmpressClass && e(I).removeClass(Y.jmpressClass),
			f.call(this, "beforeDeinit", e(this), {}),
			e(A.stepSelector, I).each(function() {
				o.call(I, this)
			}),
			z.attr("style", k.container),
			A.fullscreen && e("html").attr("style", ""),
			Z.attr("style", k.area),
			e(X).children().each(function() {
				I.append(e(this))
			}),
			A.fullscreen ? X.remove() : (X.remove(), Z.remove()),
			f.call(this, "afterDeinit", e(this), {}),
			e(I).data("jmpressmethods", !1)
		}
		function f(t, s, a) {
			a.settings = A,
			a.current = Y,
			a.container = z,
			a.parents = s ? d(s) : null,
			a.current = Y,
			a.jmpress = this;
			var r = {};
			return e.each(A[t],
			function(e, t) {
				r.value = t.call(I, s, a) || r.value
			}),
			r.value
		}
		function d(t) {
			return e(t).parentsUntil(I).not(I).filter(A.stepSelector)
		}
		function v(e) {
			return g({
				step: O,
				substep: _
			},
			e)
		}
		function g(t, s) {
			var r;
			if (e.isPlainObject(t) && (r = t.substep, t = t.step), "string" == typeof t && (t = I.find(t).first()), !t || !e(t).data("stepData")) return ! 1;
			b.call(this);
			var n = e(t).data("stepData"),
			o = !1;
			if (f.call(this, "beforeChange", t, {
				stepData: n,
				reason: s,
				cancel: function() {
					o = !0
				}
			}), o) return a;
			var c = {},
			l = t;
			e(t).data("stepData").delegate && (l = i(e(t).parentsUntil(I).filter(A.stepSelector).filter(n.delegate)) || i(e(t).near(n.delegate)) || i(e(t).near(n.delegate, !0)) || i(e(n.delegate, I)), l ? n = l.data("stepData") : l = t),
			F && f.call(this, "setInactive", F, {
				stepData: e(F).data("stepData"),
				delegatedFrom: O,
				reason: s,
				target: c,
				nextStep: l,
				nextSubstep: r,
				nextStepData: n
			});
			var u = {
				stepData: n,
				delegatedFrom: t,
				reason: s,
				target: c,
				substep: r,
				prevStep: F,
				prevSubstep: _,
				prevStepData: F && e(F).data("stepData")
			};
			return f.call(this, "beforeActive", l, u),
			f.call(this, "setActive", l, u),
			Y.jmpressClass && e(I).removeClass(Y.jmpressClass),
			e(I).addClass(Y.jmpressClass = "step-" + e(l).attr("id")),
			Y.jmpressDelegatedClass && e(I).removeClass(Y.jmpressDelegatedClass),
			e(I).addClass(Y.jmpressDelegatedClass = "delegating-step-" + e(t).attr("id")),
			f.call(this, "applyTarget", l, e.extend({
				canvas: X,
				area: Z,
				beforeActive: F
			},
			u)),
			O = t,
			_ = u.substep,
			F = l,
			Y.idleTimeout && clearTimeout(Y.idleTimeout),
			Y.idleTimeout = setTimeout(function() {
				f.call(this, "idle", l, u)
			},
			Math.max(1, A.transitionDuration - 100)),
			l
		}
		function b() { (function t() {
				function a() { (0 !== e(z).scrollTop() || 0 !== e(z).scrollLeft()) && t()
				}
				if ("BODY" === e(z)[0].tagName) try {
					s.scrollTo(0, 0)
				} catch(r) {}
				e(z).scrollTop(0),
				e(z).scrollLeft(0),
				setTimeout(a, 1),
				setTimeout(a, 10),
				setTimeout(a, 100),
				setTimeout(a, 200),
				setTimeout(a, 400)
			})()
		}
		function j(e) {
			return g.call(this, e, "jump")
		}
		function y() {
			return g.call(this, f.call(this, "selectNext", O, {
				stepData: e(O).data("stepData"),
				substep: _
			}), "next")
		}
		function D() {
			return g.call(this, f.call(this, "selectPrev", O, {
				stepData: e(O).data("stepData"),
				substep: _
			}), "prev")
		}
		function S() {
			return g.call(this, f.call(this, "selectHome", O, {
				stepData: e(O).data("stepData")
			}), "home")
		}
		function w() {
			return g.call(this, f.call(this, "selectEnd", O, {
				stepData: e(O).data("stepData")
			}), "end")
		}
		function x(t) {
			return u(X, t || {}),
			e(X)
		}
		function C() {
			return F && e(F)
		}
		function T(t, s, r) {
			return h[t] ? f.call(this, t, s, r) : (e.error("callback " + t + " is not registered."), a)
		}
		function P() {
			var e = navigator.userAgent.toLowerCase();
			return - 1 === e.search(/(iphone)|(ipod)|(android)/) || -1 !== e.search(/(chrome)/)
		}
		r = e.extend(!0, {},
		r || {});
		var M = {},
		N = null;
		for (N in h) M[N] = e.isFunction(r[N]) ? [r[N]] : r[N],
		r[N] = [];
		var A = e.extend(!0, {},
		m, r);
		for (N in h) M[N] && Array.prototype.push.apply(A[N], M[N]);
		var I = e(this),
		z = null,
		Z = null,
		k = {
			container: "",
			area: ""
		},
		X = null,
		Y = null,
		O = !1,
		_ = null,
		F = !1;
		if (I.data("jmpressmethods", {
			select: g,
			reselect: v,
			scrollFix: b,
			goTo: j,
			next: y,
			prev: D,
			home: S,
			end: w,
			canvas: x,
			container: function() {
				return z
			},
			settings: function() {
				return A
			},
			active: C,
			current: function() {
				return Y
			},
			fire: T,
			init: function(t) {
				n.call(this, e(t), Y.nextIdNumber++)
			},
			deinit: function(t) {
				t ? o.call(this, e(t)) : l.call(this)
			},
			reapply: c
		}), P() === !1) return A.notSupportedClass && I.addClass(A.notSupportedClass),
		a;
		A.notSupportedClass && I.removeClass(A.notSupportedClass);
		var Q = e(A.stepSelector, I);
		z = I,
		Z = e("<div />"),
		X = e("<div />"),
		e(I).children().filter(Q).each(function() {
			X.append(e(this))
		}),
		A.fullscreen && (z = e("body"), e("html").css({
			overflow: "hidden"
		}), Z = I),
		k.area = Z.attr("style") || "",
		k.container = z.attr("style") || "",
		A.fullscreen ? (z.css({
			height: "100%"
		}), I.append(X)) : (z.css({
			position: "relative"
		}), Z.append(X), I.append(Z)),
		e(z).addClass(A.containerClass),
		e(Z).addClass(A.areaClass),
		e(X).addClass(A.canvasClass),
		t.documentElement.style.height = "100%",
		z.css({
			overflow: "hidden"
		});
		var E = {
			position: "absolute",
			transitionDuration: "0s"
		};
		E = e.extend({},
		A.animation, E),
		u(Z, E),
		u(Z, {
			top: "50%",
			left: "50%",
			perspective: "1000px"
		}),
		u(X, E),
		Y = {},
		f.call(this, "beforeInit", null, {}),
		Q.each(function(e) {
			n.call(I, this, e)
		}),
		Y.nextIdNumber = Q.length,
		f.call(this, "afterInit", null, {}),
		g.call(this, f.call(this, "selectInitialStep", "init", {})),
		A.initClass && e(Q).removeClass(A.initClass)
	}
	function c() {
		return m
	}
	function l(t, s) {
		e.isFunction(s) ? g[t] ? e.error("function " + t + " is already registered.") : g[t] = s: h[t] ? e.error("callback " + t + " is already registered.") : (h[t] = 1, m[t] = [])
	}
	function u(t, s) {
		var a, r, n = {};
		for (a in s) s.hasOwnProperty(a) && (r = d(a), null !== r && (n[r] = s[a]));
		return e(t).css(n),
		t
	}
	function p(t) {
		function s(e) {
			e = e.split("-");
			for (var t = 1; e.length > t; t++) e[t] = e[t].substr(0, 1).toUpperCase() + e[t].substr(1);
			return e.join("")
		}
		if (e(t)[0].dataset) return e.extend({},
		e(t)[0].dataset);
		var a = {},
		r = e(t)[0].attributes;
		return e.each(r,
		function(e, t) {
			"data-" === t.nodeName.substr(0, 5) && (a[s(t.nodeName.substr(5))] = t.nodeValue)
		}),
		a
	}
	function f() {
		return !! e(this).data("jmpressmethods")
	}
	var d = function() {
		var e = t.createElement("dummy").style,
		s = "Webkit Moz O ms Khtml".split(" "),
		r = {};
		return function(t) {
			if (r[t] === a) {
				var n = t.charAt(0).toUpperCase() + t.substr(1),
				i = (t + " " + s.join(n + " ") + n).split(" ");
				r[t] = null;
				for (var o in i) if (e[i[o]] !== a) {
					r[t] = i[o];
					break
				}
			}
			return r[t]
		}
	} (),
	m = {
		stepSelector: ".step",
		containerClass: "",
		canvasClass: "",
		areaClass: "",
		notSupportedClass: "not-supported",
		fullscreen: !0,
		animation: {
			transformOrigin: "top left",
			transitionProperty: n(r(d("transform"))) + n(r(d("perspective"))) + "opacity",
			transitionDuration: "1s",
			transitionDelay: "500ms",
			transitionTimingFunction: "ease-in-out",
			transformStyle: "preserve-3d"
		},
		transitionDuration: 1500
	},
	h = {
		beforeChange: 1,
		beforeInitStep: 1,
		initStep: 1,
		beforeInit: 1,
		afterInit: 1,
		beforeDeinit: 1,
		afterDeinit: 1,
		applyStep: 1,
		unapplyStep: 1,
		setInactive: 1,
		beforeActive: 1,
		setActive: 1,
		selectInitialStep: 1,
		selectPrev: 1,
		selectNext: 1,
		selectHome: 1,
		selectEnd: 1,
		idle: 1,
		applyTarget: 1
	};
	for (var v in h) m[v] = [];
	var g = {
		init: o,
		initialized: f,
		deinit: function() {},
		css: u,
		pfx: d,
		defaults: c,
		register: l,
		dataset: p
	};
	e.fn.jmpress = function(t) {
		function s() {
			var s = e(this).data("jmpressmethods");
			if (s && s[t]) return s[t].apply(this, Array.prototype.slice.call(arguments, 1));
			if (g[t]) return g[t].apply(this, Array.prototype.slice.call(arguments, 1));
			if (h[t] && s) {
				var a = s.settings(),
				r = Array.prototype.slice.call(arguments, 1)[0];
				e.isFunction(r) && (a[t] = a[t] || [], a[t].push(r))
			} else {
				if ("object" == typeof t || !t) return o.apply(this, arguments);
				e.error("Method " + t + " does not exist on jQuery.jmpress")
			}
			return this
		}
		var a, r = arguments;
		return e(this).each(function(e, t) {
			a = s.apply(t, r)
		}),
		a
	},
	e.extend({
		jmpress: function(t) {
			if (g[t]) return g[t].apply(this, Array.prototype.slice.call(arguments, 1));
			if (h[t]) {
				var s = Array.prototype.slice.call(arguments, 1)[0];
				e.isFunction(s) ? m[t].push(s) : e.error("Second parameter should be a function: $.jmpress( callbackName, callbackFunction )")
			} else e.error("Method " + t + " does not exist on jQuery.jmpress")
		}
	})
})(jQuery, document, window),
function(e) {
	"use strict";
	function t(t, s, a, r) {
		var n;
		return t.each(function(t, i) {
			return r && (n = s(i, a, r)) ? !1 : e(i).is(a) ? (n = i, !1) : !r && (n = s(i, a, r)) ? !1 : undefined
		}),
		n
	}
	function s(a, r, n) {
		var i = e(a).children();
		return n && (i = e(i.get().reverse())),
		t(i, s, r, n)
	}
	function a(a, r, n) {
		return t(e(a)[n ? "prevAll": "nextAll"](), s, r, n)
	}
	function r(t, s, r) {
		var n, i = e(t).parents();
		return i = e(i.get()),
		e.each(i.get(),
		function(t, i) {
			return r && e(i).is(s) ? (n = i, !1) : (n = a(i, s, r), n ? !1 : undefined)
		}),
		n
	}
	e.fn.near = function(t, n) {
		var i = [];
		return e(this).each(function(e, o) {
			var c = (n ? !1 : s(o, t, n)) || a(o, t, n) || r(o, t, n);
			c && i.push(c)
		}),
		e(i)
	}
} (jQuery, document, window),
function(e, t, s, a) {
	"use strict";
	function r(e) {
		return Math.round(1e4 * e) / 1e4 + ""
	}
	var n = {
		3 : {
			transform: function(t, s) {
				var a = "translate(-50%,-50%)";
				e.each(s,
				function(e, t) {
					var s, n = ["X", "Y", "Z"];
					if ("translate" === t[0]) a += " translate3d(" + r(t[1] || 0) + "px," + r(t[2] || 0) + "px," + r(t[3] || 0) + "px)";
					else if ("rotate" === t[0]) {
						var i = t[4] ? [1, 2, 3] : [3, 2, 1];
						for (s = 0; 3 > s; s++) a += " rotate" + n[i[s] - 1] + "(" + r(t[i[s]] || 0) + "deg)"
					} else if ("scale" === t[0]) for (s = 0; 3 > s; s++) a += " scale" + n[s] + "(" + r(t[s + 1] || 1) + ")"
				}),
				e.jmpress("css", t, e.extend({},
				{
					transform: a
				}))
			}
		},
		2 : {
			transform: function(t, s) {
				var a = "translate(-50%,-50%)";
				e.each(s,
				function(e, t) {
					var s = ["X", "Y"];
					if ("translate" === t[0]) a += " translate(" + r(t[1] || 0) + "px," + r(t[2] || 0) + "px)";
					else if ("rotate" === t[0]) a += " rotate(" + r(t[3] || 0) + "deg)";
					else if ("scale" === t[0]) for (var n = 0; 2 > n; n++) a += " scale" + s[n] + "(" + r(t[n + 1] || 1) + ")"
				}),
				e.jmpress("css", t, e.extend({},
				{
					transform: a
				}))
			}
		},
		1 : {
			transform: function(t, s) {
				var a = {
					top: 0,
					left: 0
				};
				e.each(s,
				function(e, t) {
					"translate" === t[0] && (a.left = Math.round(t[1] || 0) + "px", a.top = Math.round(t[2] || 0) + "px")
				}),
				t.animate(a, 1e3)
			}
		}
	},
	i = function() {
		return e.jmpress("pfx", "perspective") ? n[3] : e.jmpress("pfx", "transform") ? n[2] : n[1]
	} ();
	e.jmpress("defaults").reasonableAnimation = {},
	e.jmpress("initStep",
	function(t, s) {
		var a = s.data,
		r = s.stepData,
		n = parseFloat;
		e.extend(r, {
			x: n(a.x) || 0,
			y: n(a.y) || 0,
			z: n(a.z) || 0,
			r: n(a.r) || 0,
			phi: n(a.phi) || 0,
			rotate: n(a.rotate) || 0,
			rotateX: n(a.rotateX) || 0,
			rotateY: n(a.rotateY) || 0,
			rotateZ: n(a.rotateZ) || 0,
			revertRotate: !1,
			scale: n(a.scale) || 1,
			scaleX: n(a.scaleX) || !1,
			scaleY: n(a.scaleY) || !1,
			scaleZ: n(a.scaleZ) || 1
		})
	}),
	e.jmpress("afterInit",
	function(t, s) {
		var a = s.settings.stepSelector,
		r = s.current;
		r.perspectiveScale = 1,
		r.maxNestedDepth = 0;
		for (var n = e(s.jmpress).find(a).children(a); n.length;) r.maxNestedDepth++,
		n = n.children(a)
	}),
	e.jmpress("applyStep",
	function(t, s) {
		e.jmpress("css", e(t), {
			position: "absolute",
			transformStyle: "preserve-3d"
		}),
		s.parents.length > 0 && e.jmpress("css", e(t), {
			top: "50%",
			left: "50%"
		});
		var a = s.stepData,
		r = [["translate", a.x || a.r * Math.sin(a.phi * Math.PI / 180), a.y || -a.r * Math.cos(a.phi * Math.PI / 180), a.z], ["rotate", a.rotateX, a.rotateY, a.rotateZ || a.rotate, !0], ["scale", a.scaleX || a.scale, a.scaleY || a.scale, a.scaleZ || a.scale]];
		i.transform(t, r)
	}),
	e.jmpress("setActive",
	function(t, s) {
		var r = s.target,
		n = s.stepData,
		i = r.transform = [];
		r.perspectiveScale = 1;
		for (var o = s.current.maxNestedDepth; o > (s.parents.length || 0); o--) i.push(["scale"], ["rotate"], ["translate"]);
		i.push(["scale", 1 / (n.scaleX || n.scale), 1 / (n.scaleY || n.scale), 1 / n.scaleZ]),
		i.push(["rotate", -n.rotateX, -n.rotateY, -(n.rotateZ || n.rotate)]),
		i.push(["translate", -(n.x || n.r * Math.sin(n.phi * Math.PI / 180)), -(n.y || -n.r * Math.cos(n.phi * Math.PI / 180)), -n.z]),
		r.perspectiveScale *= n.scaleX || n.scale,
		e.each(s.parents,
		function(t, s) {
			var a = e(s).data("stepData");
			i.push(["scale", 1 / (a.scaleX || a.scale), 1 / (a.scaleY || a.scale), 1 / a.scaleZ]),
			i.push(["rotate", -a.rotateX, -a.rotateY, -(a.rotateZ || a.rotate)]),
			i.push(["translate", -(a.x || a.r * Math.sin(a.phi * Math.PI / 180)), -(a.y || -a.r * Math.cos(a.phi * Math.PI / 180)), -a.z]),
			r.perspectiveScale *= a.scaleX || a.scale
		}),
		e.each(i,
		function(e, t) {
			function r(r) {
				s.current["rotate" + r + "-" + e] === a && (s.current["rotate" + r + "-" + e] = t[r] || 0);
				var n = s.current["rotate" + r + "-" + e],
				i = t[r] || 0,
				o = n % 360,
				c = i % 360;
				0 > o && (o += 360),
				0 > c && (c += 360);
				var l = c - o; - 180 > l ? l += 360 : l > 180 && (l -= 360),
				s.current["rotate" + r + "-" + e] = t[r] = n + l
			}
			"rotate" === t[0] && (r(1), r(2), r(3))
		})
	}),
	e.jmpress("applyTarget",
	function(t, s) {
		var r, n = s.target,
		o = (s.stepData, s.settings),
		c = 1.3 * n.perspectiveScale < s.current.perspectiveScale,
		l = n.perspectiveScale > 1.3 * s.current.perspectiveScale,
		u = -1;
		e.each(n.transform,
		function(e, t) {
			return 1 >= t.length || "rotate" === t[0] && 0 === t[1] % 360 && 0 === t[2] % 360 && 0 === t[3] % 360 ? a: "scale" !== t[0] ? !1 : (u = e, a)
		}),
		u !== s.current.oldLastScale && (c = l = !1, s.current.oldLastScale = u);
		var p = [];
		if ( - 1 !== u) for (; u >= 0;)"scale" === n.transform[u][0] && (p.push(n.transform[u]), n.transform[u] = ["scale"]),
		u--;
		var f = o.animation;
		o.reasonableAnimation[s.reason] && (f = e.extend({},
		f, o.reasonableAnimation[s.reason])),
		r = {
			perspective: Math.round(1e3 * n.perspectiveScale) + "px"
		},
		r = e.extend({},
		f, r),
		c || (r.transitionDelay = "0s"),
		s.beforeActive || (r.transitionDuration = "0s", r.transitionDelay = "0s"),
		e.jmpress("css", s.area, r),
		i.transform(s.area, p),
		r = e.extend({},
		f),
		l || (r.transitionDelay = "0s"),
		s.beforeActive || (r.transitionDuration = "0s", r.transitionDelay = "0s"),
		s.current.perspectiveScale = n.perspectiveScale,
		e.jmpress("css", s.canvas, r),
		i.transform(s.canvas, n.transform)
	})
} (jQuery, document, window),
function(e) {
	"use strict";
	var t = e.jmpress,
	s = "activeClass",
	a = "nestedActiveClass",
	r = t("defaults");
	r[a] = "nested-active",
	r[s] = "active",
	t("setInactive",
	function(t, r) {
		var n = r.settings,
		i = n[s],
		o = n[a];
		i && e(t).removeClass(i),
		o && e.each(r.parents,
		function(t, s) {
			e(s).removeClass(o)
		})
	}),
	t("setActive",
	function(t, r) {
		var n = r.settings,
		i = n[s],
		o = n[a];
		i && e(t).addClass(i),
		o && e.each(r.parents,
		function(t, s) {
			e(s).addClass(o)
		})
	})
} (jQuery, document, window),
function(e) {
	"use strict";
	function t(t, s) {
		return e(this).find(s.settings.stepSelector).first()
	}
	function s(t, s, a, r) {
		if (!s) return ! 1;
		var n = a.settings.stepSelector;
		s = e(s);
		do {
			var i = s.near(n, r);
			if ((0 === i.length || 0 === i.closest(t).length) && (i = e(t).find(n)[r ? "last": "first"]()), !i.length) return ! 1;
			s = i
		} while ( s . data ("stepData").exclude);
		return s
	}
	var a = e.jmpress;
	a("initStep",
	function(e, t) {
		t.stepData.exclude = t.data.exclude && -1 === ["false", "no"].indexOf(t.data.exclude)
	}),
	a("selectInitialStep", t),
	a("selectHome", t),
	a("selectEnd",
	function(t, s) {
		return e(this).find(s.settings.stepSelector).last()
	}),
	a("selectPrev",
	function(e, t) {
		return s(this, e, t, !0)
	}),
	a("selectNext",
	function(e, t) {
		return s(this, e, t)
	})
} (jQuery, document, window),
function(e) {
	"use strict";
	e.jmpress("selectInitialStep",
	function(e, t) {
		return t.settings.start
	})
} (jQuery, document, window),
function(e) {
	"use strict";
	function t(t, s, a) {
		for (var r = 0; s.length - 1 > r; r++) {
			var n = s[r],
			i = s[r + 1];
			e(t).jmpress("initialized") ? e(n, t).data("stepData")[a] = i: e(n, t).attr("data-" + a, i)
		}
	}
	function s(t, s, a, r) {
		var n = s.stepData;
		if (n[a]) {
			var i = e(t).near(n[a], r);
			if (i && i.length) return i;
			if (i = e(n[a], this)[r ? "last": "first"](), i && i.length) return i
		}
	}
	var a = e.jmpress;
	a("register", "route",
	function(e, s, a) {
		"string" == typeof e && (e = [e, e]),
		t(this, e, a ? "prev": "next"),
		s || t(this, e.reverse(), a ? "next": "prev")
	}),
	a("initStep",
	function(e, t) {
		for (var s in {
			next: 1,
			prev: 1
		}) t.stepData[s] = t.data[s]
	}),
	a("selectNext",
	function(e, t) {
		return s.call(this, e, t, "next")
	}),
	a("selectPrev",
	function(e, t) {
		return s.call(this, e, t, "prev", !0)
	})
} (jQuery, document, window),
function(e) {
	"use strict";
	var t = e.jmpress,
	s = "ajax:afterStepLoaded",
	a = "ajax:loadStep";
	t("register", a),
	t("register", s),
	t("defaults").ajaxLoadedClass = "loaded",
	t("initStep",
	function(t, s) {
		s.stepData.src = e(t).attr("href") || s.data.src || !1,
		s.stepData.srcLoaded = !1
	}),
	t(a,
	function(t, a) {
		var r = a.stepData,
		n = r && r.src,
		i = a.settings;
		n && (e(t).addClass(i.ajaxLoadedClass), r.srcLoaded = !0, e(t).load(n,
		function(r, n, i) {
			e(a.jmpress).jmpress("fire", s, t, e.extend({},
			a, {
				response: r,
				status: n,
				xhr: i
			}))
		}))
	}),
	t("idle",
	function(t, s) {
		if (t) {
			var r = s.settings,
			n = e(this);
			s.stepData;
			var i = e(t).add(e(t).near(r.stepSelector)).add(e(t).near(r.stepSelector, !0)).add(n.jmpress("fire", "selectPrev", t, {
				stepData: e(t).data("stepData")
			})).add(n.jmpress("fire", "selectNext", t, {
				stepData: e(t).data("stepData")
			}));
			i.each(function() {
				var t = this,
				s = e(t).data("stepData");
				s.src && !s.srcLoaded && n.jmpress("fire", a, t, {
					stepData: e(t).data("stepData")
				})
			})
		}
	}),
	t("setActive",
	function(t) {
		var s = e(t).data("stepData");
		s.src && !s.srcLoaded && e(this).jmpress("fire", a, t, {
			stepData: e(t).data("stepData")
		})
	})
} (jQuery, document, window),
function(e, t, s, a) {
	"use strict";
	function r() {
		return "" + Math.round(1e5 * Math.random(), 0)
	}
	function n(t) {
		try {
			var r = e("#" + s.location.hash.replace(/^#\/?/, ""));
			return r.length > 0 && r.is(t.stepSelector) ? r: a
		} catch(n) {}
	}
	function i(e) {
		var t = "#/" + e;
		s.history && s.history.pushState ? s.location.hash !== t && s.history.pushState({},
		"", t) : s.location.hash !== t && (s.location.hash = t)
	}
	var o = e.jmpress,
	c = "a[href^=#]";
	o("defaults").hash = {
		use: !0,
		update: !0,
		bindChange: !0
	},
	o("selectInitialStep",
	function(t, o) {
		var l = o.settings,
		u = l.hash,
		p = o.current,
		f = e(this);
		return o.current.hashNamespace = ".jmpress-" + r(),
		u.use ? (u.bindChange && (e(s).bind("hashchange" + p.hashNamespace,
		function(e) {
			var t = n(l);
			f.jmpress("initialized") && f.jmpress("scrollFix"),
			t && t.length && (t.attr("id") !== f.jmpress("active").attr("id") && f.jmpress("select", t), i(t.attr("id"))),
			e.preventDefault()
		}), e(c).on("click" + p.hashNamespace,
		function(t) {
			var s = e(this).attr("href");
			try {
				e(s).is(l.stepSelector) && (f.jmpress("select", s), t.preventDefault(), t.stopPropagation())
			} catch(a) {}
		})), n(l)) : a
	}),
	o("afterDeinit",
	function(t, a) {
		e(c).off(a.current.hashNamespace),
		e(s).unbind(a.current.hashNamespace)
	}),
	o("setActive",
	function(t, s) {
		var a = s.settings,
		r = s.current;
		a.hash.use && a.hash.update && (clearTimeout(r.hashtimeout), r.hashtimeout = setTimeout(function() {
			i(e(s.delegatedFrom).attr("id"))
		},
		a.transitionDuration + 200))
	})
} (jQuery, document, window),
function(e, t, s, a) {
	"use strict";
	function r() {
		return "" + Math.round(1e5 * Math.random(), 0)
	}
	function n(e) {
		e.preventDefault(),
		e.stopPropagation()
	}
	var i = e.jmpress,
	o = "next",
	c = "prev";
	i("defaults").keyboard = {
		use: !0,
		keys: {
			33 : c,
			37 : c,
			38 : c,
			9 : o + ":" + c,
			32 : o,
			34 : o,
			39 : o,
			40 : o,
			36 : "home",
			35 : "end"
		},
		ignore: {
			INPUT: [32, 37, 38, 39, 40],
			TEXTAREA: [32, 37, 38, 39, 40],
			SELECT: [38, 40]
		},
		tabSelector: "a[href]:visible, :input:visible"
	},
	i("afterInit",
	function(s, i) {
		var o = i.settings,
		c = o.keyboard,
		l = c.ignore,
		u = i.current,
		p = e(this);
		o.fullscreen || p.attr("tabindex", 0),
		u.keyboardNamespace = ".jmpress-" + r(),
		e(o.fullscreen ? t: p).bind("keypress" + u.keyboardNamespace,
		function(e) {
			for (var t in l) if (e.target.nodeName === t && -1 !== l[t].indexOf(e.which)) return; (e.which >= 37 && 40 >= e.which || 32 === e.which) && n(e)
		}),
		e(o.fullscreen ? t: p).bind("keydown" + u.keyboardNamespace,
		function(t) {
			var s = e(t.target);
			if ((o.fullscreen || s.closest(p).length) && c.use) {
				for (var r in l) if (s[0].nodeName === r && -1 !== l[r].indexOf(t.which)) return;
				var i, u = !1;
				if (9 === t.which) {
					if (s.closest(p.jmpress("active")).length ? (i = s.near(c.tabSelector, t.shiftKey), e(i).closest(o.stepSelector).is(p.jmpress("active")) || (i = a)) : t.shiftKey ? u = !0 : i = p.jmpress("active").find("a[href], :input").filter(":visible").first(), i && i.length > 0) return i.focus(),
					p.jmpress("scrollFix"),
					n(t),
					a;
					t.shiftKey && (u = !0)
				}
				var f = c.keys[t.which];
				"string" == typeof f ? ( - 1 !== f.indexOf(":") && (f = f.split(":"), f = t.shiftKey ? f[1] : f[0]), p.jmpress(f), n(t)) : e.isFunction(f) ? f.call(p, t) : f && (p.jmpress.apply(p, f), n(t)),
				u && (i = p.jmpress("active").find("a[href], :input").filter(":visible").last(), i.focus(), p.jmpress("scrollFix"))
			}
		})
	}),
	i("afterDeinit",
	function(s, a) {
		e(t).unbind(a.current.keyboardNamespace)
	})
} (jQuery, document, window),
function(e, t, s, a) {
	"use strict";
	function r() {
		return "" + Math.round(1e5 * Math.random(), 0)
	}
	function n(e, t) {
		return Math.max(Math.min(e, t), -t)
	}
	function i(t, s, a) {
		var r = e(this).jmpress("current"),
		i = e(this).jmpress("settings"),
		o = e(this).jmpress("active").data("stepData"),
		c = e(this).jmpress("container");
		if (! (0 === r.userZoom && 0 > a)) {
			var l = o.viewPortZoomable || i.viewPort.zoomable;
			if (! (r.userZoom === l && a > 0)) {
				r.userZoom += a;
				var u = e(c).innerWidth() / 2,
				p = e(c).innerHeight() / 2;
				t = t ? t - u: t,
				s = s ? s - p: s,
				r.userTranslateX = n(r.userTranslateX - a * t / r.zoomOriginWindowScale / l, u * r.userZoom * r.userZoom / l),
				r.userTranslateY = n(r.userTranslateY - a * s / r.zoomOriginWindowScale / l, p * r.userZoom * r.userZoom / l),
				e(this).jmpress("reselect", "zoom")
			}
		}
	}
	var o = function() {
		var e = navigator.userAgent.toLowerCase(),
		t = /(chrome)[ \/]([\w.]+)/.exec(e) || /(webkit)[ \/]([\w.]+)/.exec(e) || /(opera)(?:.*version|)[ \/]([\w.]+)/.exec(e) || /(msie) ([\w.]+)/.exec(e) || 0 > e.indexOf("compatible") && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(e) || [];
		return t[1] || ""
	} (),
	c = e.jmpress("defaults");
	c.viewPort = {
		width: !1,
		height: !1,
		maxScale: 0,
		minScale: 0,
		zoomable: 0,
		zoomBindMove: !0,
		zoomBindWheel: !0
	};
	var l = c.keyboard.keys;
	l["mozilla" === o ? 107 : 187] = "zoomIn",
	l["mozilla" === o ? 109 : 189] = "zoomOut",
	c.reasonableAnimation.resize = {
		transitionDuration: "0s",
		transitionDelay: "0ms"
	},
	c.reasonableAnimation.zoom = {
		transitionDuration: "0s",
		transitionDelay: "0ms"
	},
	e.jmpress("initStep",
	function(e, t) {
		for (var s in {
			viewPortHeight: 1,
			viewPortWidth: 1,
			viewPortMinScale: 1,
			viewPortMaxScale: 1,
			viewPortZoomable: 1
		}) t.stepData[s] = t.data[s] && parseFloat(t.data[s])
	}),
	e.jmpress("afterInit",
	function(n, i) {
		var o = this;
		i.current.viewPortNamespace = ".jmpress-" + r(),
		e(s).bind("resize" + i.current.viewPortNamespace,
		function() {
			e(o).jmpress("reselect", "resize")
		}),
		i.current.userZoom = 0,
		i.current.userTranslateX = 0,
		i.current.userTranslateY = 0,
		i.settings.viewPort.zoomBindWheel && e(i.settings.fullscreen ? t: this).bind("mousewheel" + i.current.viewPortNamespace + " DOMMouseScroll" + i.current.viewPortNamespace,
		function(t, s) {
			s = s || t.originalEvent.wheelDelta || -t.originalEvent.detail;
			var a = s / Math.abs(s);
			return 0 > a ? e(i.jmpress).jmpress("zoomOut", t.originalEvent.x, t.originalEvent.y) : a > 0 && e(i.jmpress).jmpress("zoomIn", t.originalEvent.x, t.originalEvent.y),
			!1
		}),
		i.settings.viewPort.zoomBindMove && e(i.settings.fullscreen ? t: this).bind("mousedown" + i.current.viewPortNamespace,
		function(e) {
			i.current.userZoom && (i.current.userTranslating = {
				x: e.clientX,
				y: e.clientY
			},
			e.preventDefault(), e.stopImmediatePropagation())
		}).bind("mousemove" + i.current.viewPortNamespace,
		function(t) {
			var s = i.current.userTranslating;
			s && (e(o).jmpress("zoomTranslate", t.clientX - s.x, t.clientY - s.y), s.x = t.clientX, s.y = t.clientY, t.preventDefault(), t.stopImmediatePropagation())
		}).bind("mouseup" + i.current.viewPortNamespace,
		function(e) {
			i.current.userTranslating && (i.current.userTranslating = a, e.preventDefault(), e.stopImmediatePropagation())
		})
	}),
	e.jmpress("register", "zoomIn",
	function(e, t) {
		i.call(this, e || 0, t || 0, 1)
	}),
	e.jmpress("register", "zoomOut",
	function(e, t) {
		i.call(this, e || 0, t || 0, -1)
	}),
	e.jmpress("register", "zoomTranslate",
	function(t, s) {
		var a = e(this).jmpress("current"),
		r = e(this).jmpress("settings"),
		i = e(this).jmpress("active").data("stepData"),
		o = e(this).jmpress("container"),
		c = i.viewPortZoomable || r.viewPort.zoomable,
		l = e(o).innerWidth(),
		u = e(o).innerHeight();
		a.userTranslateX = n(a.userTranslateX + t / a.zoomOriginWindowScale, l * a.userZoom * a.userZoom / c),
		a.userTranslateY = n(a.userTranslateY + s / a.zoomOriginWindowScale, u * a.userZoom * a.userZoom / c),
		e(this).jmpress("reselect", "zoom")
	}),
	e.jmpress("afterDeinit",
	function(a, r) {
		e(r.settings.fullscreen ? t: this).unbind(r.current.viewPortNamespace),
		e(s).unbind(r.current.viewPortNamespace)
	}),
	e.jmpress("setActive",
	function(t, s) {
		var a = s.settings.viewPort,
		r = s.stepData.viewPortHeight || a.height,
		n = s.stepData.viewPortWidth || a.width,
		i = s.stepData.viewPortMaxScale || a.maxScale,
		o = s.stepData.viewPortMinScale || a.minScale,
		c = r && e(s.container).innerHeight() / r,
		l = n && e(s.container).innerWidth() / n,
		u = (l || c) && Math.min(l || c, c || l);
		if (u) {
			u = u || 1,
			i && (u = Math.min(u, i)),
			o && (u = Math.max(u, o));
			var p = s.stepData.viewPortZoomable || s.settings.viewPort.zoomable;
			if (p) {
				var f = 1 / u - 1 / i;
				f /= p,
				u = 1 / (1 / u - f * s.current.userZoom)
			}
			s.target.transform.reverse(),
			s.current.userTranslateX && s.current.userTranslateY ? s.target.transform.push(["translate", s.current.userTranslateX, s.current.userTranslateY, 0]) : s.target.transform.push(["translate"]),
			s.target.transform.push(["scale", u, u, 1]),
			s.target.transform.reverse(),
			s.target.perspectiveScale /= u
		}
		s.current.zoomOriginWindowScale = u
	}),
	e.jmpress("setInactive",
	function(t, s) {
		s.nextStep && t && e(s.nextStep).attr("id") === e(t).attr("id") || (s.current.userZoom = 0, s.current.userTranslateX = 0, s.current.userTranslateY = 0)
	})
} (jQuery, document, window),
function(e) {
	"use strict";
	function t() {
		return "" + Math.round(1e5 * Math.random(), 0)
	}
	var s = e.jmpress;
	s("defaults").mouse = {
		clickSelects: !0
	},
	s("afterInit",
	function(s, a) {
		var r = a.settings,
		n = r.stepSelector,
		i = a.current,
		o = e(this);
		i.clickableStepsNamespace = ".jmpress-" + t(),
		o.bind("click" + i.clickableStepsNamespace,
		function(t) {
			if (r.mouse.clickSelects && !i.userZoom) {
				var s = e(t.target).closest(n);
				s.is(o.jmpress("active")) || s.length && (o.jmpress("select", s[0], "click"), t.preventDefault(), t.stopPropagation())
			}
		})
	}),
	s("afterDeinit",
	function(t, s) {
		e(this).unbind(s.current.clickableStepsNamespace)
	})
} (jQuery, document, window),
function(e, t) {
	"use strict";
	function s() {
		return "" + Math.round(1e5 * Math.random(), 0)
	}
	var a = e.jmpress;
	a("afterInit",
	function(a, r) {
		var n = r.settings,
		i = r.current,
		o = r.jmpress;
		i.mobileNamespace = ".jmpress-" + s();
		var c, l = [0, 0];
		e(n.fullscreen ? t: o).bind("touchstart" + i.mobileNamespace,
		function(e) {
			c = e.originalEvent.touches[0],
			l = [c.pageX, c.pageY]
		}).bind("touchmove" + i.mobileNamespace,
		function(e) {
			return c = e.originalEvent.touches[0],
			e.preventDefault(),
			!1
		}).bind("touchend" + i.mobileNamespace,
		function(t) {
			var s = [c.pageX, c.pageY],
			a = [s[0] - l[0], s[1] - l[1]];
			return Math.max(Math.abs(a[0]), Math.abs(a[1])) > 50 ? (a = Math.abs(a[0]) > Math.abs(a[1]) ? a[0] : a[1], e(o).jmpress(a > 0 ? "prev": "next"), t.preventDefault(), !1) : undefined
		})
	}),
	a("afterDeinit",
	function(s, a) {
		var r = a.settings,
		n = a.current,
		i = a.jmpress;
		e(r.fullscreen ? t: i).unbind(n.mobileNamespace)
	})
} (jQuery, document, window),
function(e, t, s, a) {
	"use strict";
	function r(t, s, n) {
		for (var i in s) {
			var o = i;
			n && (o = n + o.substr(0, 1).toUpperCase() + o.substr(1)),
			e.isPlainObject(s[i]) ? r(t, s[i], o) : t[o] === a && (t[o] = s[i])
		}
	}
	function n(t, s) {
		e.isArray(s) ? s.length < t.length ? e.error("more nested steps than children in template") : t.each(function(t, a) {
			a = e(a);
			var n = a.data(l) || {};
			r(n, s[t]),
			a.data(l, n)
		}) : e.isFunction(s) && t.each(function(a, n) {
			n = e(n);
			var i = n.data(l) || {};
			r(i, s(a, n, t)),
			n.data(l, i)
		})
	}
	function i(e, t, s, a) {
		if (s.children) {
			var r = t.children(a.settings.stepSelector);
			n(r, s.children)
		}
		o(e, s)
	}
	function o(e, t) {
		r(e, t)
	}
	var c = e.jmpress,
	l = "_template_",
	u = "_applied_template_",
	p = {};
	c("beforeInitStep",
	function(t, s) {
		t = e(t);
		var a = s.data,
		r = a.template,
		n = t.data(u),
		o = t.data(l);
		r && e.each(r.split(" "),
		function(e, r) {
			var n = p[r];
			i(a, t, n, s)
		}),
		n && i(a, t, n, s),
		o && (i(a, t, o, s), t.data(l, null), o.template && e.each(o.template.split(" "),
		function(e, r) {
			var n = p[r];
			i(a, t, n, s)
		}))
	}),
	c("beforeInit",
	function(t, s) {
		var a = c("dataset", this),
		r = a.template,
		i = s.settings.stepSelector;
		if (r) {
			var o = p[r];
			n(e(this).find(i).filter(function() {
				return ! e(this).parent().is(i)
			}), o.children)
		}
	}),
	c("register", "template",
	function(t, s) {
		p[t] = p[t] ? e.extend(!0, {},
		p[t], s) : e.extend(!0, {},
		s)
	}),
	c("register", "apply",
	function(t, s) {
		if (s) if (e.isArray(s)) n(e(t), s);
		else {
			var a;
			a = "string" == typeof s ? p[s] : e.extend(!0, {},
			s),
			e(t).each(function(t, s) {
				s = e(s);
				var n = s.data(u) || {};
				r(n, a),
				s.data(u, n)
			})
		} else {
			var i = e(this).jmpress("settings").stepSelector;
			n(e(this).find(i).filter(function() {
				return ! e(this).parent().is(i)
			}), t)
		}
	})
} (jQuery, document, window),
function(e) {
	"use strict";
	e.jmpress("setActive",
	function(t, s) {
		s.prevStep !== t && e(t).triggerHandler("enterStep")
	}),
	e.jmpress("setInactive",
	function(t, s) {
		s.nextStep !== t && e(t).triggerHandler("leaveStep")
	})
} (jQuery, document, window),
function(e, t, s, a) {
	"use strict";
	function r(t) {
		for (var s = t.split(" "), a = s[0], r = {
			willClass: "will-" + a,
			doClass: "do-" + a,
			hasClass: "has-" + a
		},
		n = "", i = 1; s.length > i; i++) {
			var o = s[i];
			switch (n) {
			case "":
				"after" === o ? n = "after": e.warn("unknown keyword in '" + t + "'. '" + o + "' unknown.");
				break;
			case "after":
				if (o.match(/^[1-9][0-9]*m?s?/)) {
					var c = parseFloat(o); - 1 !== o.indexOf("ms") ? c *= 1 : -1 !== o.indexOf("s") ? c *= 1e3: -1 !== o.indexOf("m") && (c *= 6e4),
					r.delay = c
				} else r.after = Array.prototype.slice.call(s, i).join(" "),
				i = s.length
			}
		}
		return r
	}
	function n(t, s, a, r) {
		r = r || t.length - 1,
		a = a || 0;
		for (var n = a; r + 1 > n; n++) if (e(t[n].element).is(s)) return n
	}
	function i(t, s, a) {
		e.each(s._on,
		function(e, s) {
			t.push({
				substep: s.substep,
				delay: s.delay + a
			}),
			i(t, s.substep, s.delay + a)
		})
	}
	e.jmpress("defaults").customAnimationDataAttribute = "jmpress",
	e.jmpress("afterInit",
	function(e, t) {
		t.current.animationTimeouts = [],
		t.current.animationCleanupWaiting = []
	}),
	e.jmpress("applyStep",
	function(t, s) {
		function o(e, t) {
			return t.substep._after ? (u = t.substep._after, !1) : a
		}
		var c = {},
		l = [];
		if (e(t).find("[data-" + s.settings.customAnimationDataAttribute + "]").each(function(a, r) {
			e(r).closest(s.settings.stepSelector).is(t) && l.push({
				element: r
			})
		}), 0 !== l.length) {
			e.each(l,
			function(t, a) {
				a.info = r(e(a.element).data(s.settings.customAnimationDataAttribute)),
				e(a.element).addClass(a.info.willClass),
				a._on = [],
				a._after = null
			});
			var u = {
				_after: a,
				_on: [],
				info: {}
			};
			if (e.each(l,
			function(e, t) {
				var s = t.info.after;
				if (s) if ("step" === s) s = u;
				else if ("prev" === s) s = l[e - 1];
				else {
					var r = n(l, s, 0, e - 1);
					r === a && (r = n(l, s)),
					s = r === a || r === e ? l[e - 1] : l[r]
				} else s = l[e - 1];
				if (s) {
					if (!t.info.delay) {
						if (!s._after) return s._after = t,
						a;
						s = s._after
					}
					s._on.push({
						substep: t,
						delay: t.info.delay || 0
					})
				}
			}), u._after === a && 0 === u._on.length) {
				var p = n(l, s.stepData.startSubstep) || 0;
				u._after = l[p]
			}
			var f = [];
			do {
				var d = [{
					substep: u,
					delay: 0
				}];
				i(d, u, 0), f.push(d), u = null, e.each(d, o)
			} while ( u );
			c.list = f,
			e(t).data("substepsData", c)
		}
	}),
	e.jmpress("unapplyStep",
	function(t) {
		var s = e(t).data("substepsData");
		s && e.each(s.list,
		function(t, s) {
			e.each(s,
			function(t, s) {
				s.substep.info.willClass && e(s.substep.element).removeClass(s.substep.info.willClass),
				s.substep.info.hasClass && e(s.substep.element).removeClass(s.substep.info.hasClass),
				s.substep.info.doClass && e(s.substep.element).removeClass(s.substep.info.doClass)
			})
		})
	}),
	e.jmpress("setActive",
	function(t, s) {
		var r = e(t).data("substepsData");
		if (r) {
			s.substep === a && (s.substep = "prev" === s.reason ? r.list.length - 1 : 0);
			var n = s.substep;
			e.each(s.current.animationTimeouts,
			function(e, t) {
				clearTimeout(t)
			}),
			s.current.animationTimeouts = [],
			e.each(r.list,
			function(t, a) {
				var r = n > t,
				i = n >= t;
				e.each(a,
				function(t, a) {
					function n() {
						e(a.substep.element).addClass(a.substep.info.doClass)
					}
					a.substep.info.hasClass && e(a.substep.element)[(r ? "add": "remove") + "Class"](a.substep.info.hasClass),
					i && !r && a.delay && "prev" !== s.reason ? a.substep.info.doClass && (e(a.substep.element).removeClass(a.substep.info.doClass), s.current.animationTimeouts.push(setTimeout(n, a.delay))) : a.substep.info.doClass && e(a.substep.element)[(i ? "add": "remove") + "Class"](a.substep.info.doClass)
				})
			})
		}
	}),
	e.jmpress("setInactive",
	function(t, s) {
		function a(t) {
			e.each(t.list,
			function(t, s) {
				e.each(s,
				function(t, s) {
					s.substep.info.hasClass && e(s.substep.element).removeClass(s.substep.info.hasClass),
					s.substep.info.doClass && e(s.substep.element).removeClass(s.substep.info.doClass)
				})
			})
		}
		if (s.nextStep !== t) {
			e.each(s.current.animationCleanupWaiting,
			function(e, t) {
				a(t)
			}),
			s.current.animationCleanupWaiting = [];
			var r = e(t).data("substepsData");
			r && s.current.animationCleanupWaiting.push(r)
		}
	}),
	e.jmpress("selectNext",
	function(t, s) {
		if (s.substep !== a) {
			var r = e(t).data("substepsData");
			if (r) return s.substep < r.list.length - 1 ? {
				step: t,
				substep: s.substep + 1
			}: a
		}
	}),
	e.jmpress("selectPrev",
	function(t, s) {
		if (s.substep !== a) {
			var r = e(t).data("substepsData");
			if (r) return s.substep > 0 ? {
				step: t,
				substep: s.substep - 1
			}: a
		}
	})
} (jQuery, document, window);