_global.Timer = function(){ 
this.init(); 
} 

Timer.prototype.init = function(){ 
this.delay = 1000; // default interval value 
this.initialDelay = 0; // default initial delay (in number of ticks) 
this.ticksCounter = 0; // initialize the ticks counter to zero 
this.hiddenTicksCounter = 0; // hidden ticks counter will be used to calculate pausing intervals 
this.alarm = 0; // initialize the alarm counter to zero 
this.alarms = []; // multiple alarm values 
this.sentAlarms = 0; // alarm value that has been sent 
this._listeners = []; // listeners list 
this.mcs = []; // list of the movie-clips which will be controlled by the timer 
this.running = false; 
this.paused = false; 
this.controlling = false; 
this.scheduled = false; 
} 

Timer.prototype.setDelay = function(delay){ 
// the highest possible frame rate is 120 FPS 
// the internal limit is about 10 interval calls per frame generation 
delay = parseInt(delay); 
if (isNaN(delay) || delay < 1) { 
trace("Debugger ::\t(setDelay)\tThe delay value has to be a number greater than 1."); 
return 0; 
} 
this.delay = delay; // interval value in milliseconds 
} 

Timer.prototype.setInitialDelay = function(initialDelay){ 
initialDelay = parseInt(initialDelay); 
if (isNaN(initialDelay) || initialDelay < 0) { 
trace("Debugger ::\t(setInitialDelay)\tThe initial delay value has to be a number greater than 0."); 
return 0; 
} 
this.initialDelay = initialDelay; // how many ticks to wait before first execution - can be 0 
} 

Timer.prototype.getDelay = function(){ 
return this.delay; 
} 

Timer.prototype.getInitialDelay = function(){ 
return this.initialDelay; 
} 

Timer.prototype.addListener = function(reference){ 
this._listeners[reference] = reference; 
} 

Timer.prototype.removeListener = function(reference){ 
delete this._listeners[reference]; 
} 

Timer.prototype.sendEvent = function(functionName, params){ 
for (var i in this._listeners) { 
this._listeners[i][functionName](params); 
} 
} 

Timer.prototype.isRunning = function(){ 
return this.running; 
} 

Timer.prototype.isPaused = function(){ 
return this.paused; 
} 

Timer.prototype.hasSchedule = function(){ 
return this.scheduled; 
} 

Timer.prototype.hasControl = function(){ 
return this.controlling; 
} 

Timer.prototype.getControlledMovieclips = function(){ 
return this.mcs; 
} 

Timer.prototype.start = function() { 
// first cancel the interval by passing the interval identifier 
// to clearInterval method 
if (this.intervalID) clearInterval(this.intervalID); 
this.intervalID = setInterval(this, "tick", this.delay); 
this.running = true; 
this.paused = false; 
this.sendEvent("onTimerStart"); 
this.startTime = getTimer(); // for calculating the accuracy 
} 

Timer.prototype.stop = function() { 
// cancel the interval 
clearInterval(this.intervalID); 
this.running = false; 
this.sendEvent("onTimerStop"); 
} 

Timer.prototype.pause = function(){ 
if (this.isRunning()) { 
this.paused = true; 
this.sendEvent("onTimerPause"); 
} 
} 

Timer.prototype.sleep = function(sleepPeriod){ 
sleepPeriod = parseInt(sleepPeriod); 
if (isNaN(sleepPeriod) || sleepPeriod < 1) { 
trace("Debugger ::\t(sleep)\tThe sleepPeriod value has to be a number greater than 1."); 
return 0; 
} 
if (this.isRunning()){ 
this.paused = true; 
this.sleepDuration = this.getTicksDifference() + sleepPeriod; 
this.sendEvent("onTimerSleep"); 
} 
} 

Timer.prototype.resume = function(){ 
if (this.isRunning() && this.isPaused()) { 
this.paused = false; 
this.sendEvent("onTimerResume"); 
} 
} 
Timer.prototype.reset = function(){ 
this.ticksCounter = 0; 
this.hiddenTicksCounter = 0; 
this.sentAlarms = 0; 
this.sendEvent("onTimerReset"); 
} 
Timer.prototype.getTicksCount = function() { 
return this.ticksCounter; 
} 
Timer.prototype.getHiddenTicksCount = function() { 
return this.hiddenTicksCounter; 
} 
Timer.prototype.getTicksDifference = function() { 
this.ticksDifference = this.getHiddenTicksCount() - this.getTicksCount(); 
return this.ticksDifference; 
} 

Timer.prototype.setAlarm = function(alarm) { 
alarm = parseInt(alarm); 
if (isNaN(alarm) || alarm < 1) { 
trace("Debugger ::\t(setAlarm)\tThe alarm value has to be a number greater than 1."); 
return 0; 
} 
this.alarm = alarm; 
this.hasAlarm = true; 
} 

Timer.prototype.getAlarm = function(){ 
return this.alarm; 
} 

Timer.prototype.setAlarms = function() { 
// check the alarm values 
for (var i = 0; i < arguments.length; i++) { 
arguments[i] = parseInt(arguments[i]); 
if (isNaN(arguments[i]) || arguments[i] < 1) { 
trace("Debugger ::\t(setAlarms)\tThe alarm value has to be a number greater than 1."); 
return 0; 
} 
this.alarms.push(arguments[i]); 
} 
this.hasMultipleAlarms = true; 
} 

Timer.prototype.getAlarms = function(){ 
return this.alarms; 
} 

Timer.prototype.getAccuracy = function(){ 
return ((getTimer() - this.startTime) / this.getHiddenTicksCount()) - this.getDelay(); 
} 

Timer.prototype.controlTimelineOf = function(){ 
// the parameter(s) is(are) movie-clip(s) with multiple frames 
for (var i = 0; i < arguments.length; i++) { 
if (arguments[i] instanceof movieclip != 1) { 
trace("Debugger::\t(controlTimelineOf)\tThe parameter has to be the instance name of a movie-clip."); 
return 0; 
} 
this.mcs.push(arguments[i]); 
arguments[i].stop(); 
} 
this.controlling = true; 
} 

Timer.prototype.releaseTimelineOf = function(mc, stopMC){ 
for (var i = 0; i < this.mcs.length; i++) { 
if (this.mcs[i] == mc) delete this.mcs[i]; 
} 
stopMC ? mc.stop() : mc.play(); // optional argument for stopping the mc 
if (this.mcs.length < 1) this.controlling = false; 
} 

Timer.prototype.schedule = function(handler, methodName, param) { 
this.handler = handler; // a reference to the object whose method will be invoked 
this.methodName = methodName; // name of the object method (as String) 
this.param = param; // optional parameter for the scheduled method 
this.scheduled = true; 
} 

Timer.prototype.clearSchedule = function() { 
this.scheduled = false; 
} 

Timer.prototype.execute = function() { 
this.handler[this.methodName](this.param); 
} 

Timer.prototype.tick = function() { 
// checking alarm(s) 
if (this.hasAlarm) { 
if (this.getTicksCount() == this.alarm) { // send it once 
this.sendEvent("onTimerAlarm"); 
} 
} 
if (this.hasMultipleAlarms) { 
for (var i = 0; i < this.alarms.length; i++) { 
if (this.getTicksCount() == this.alarms[this.sentAlarms]) { 
this.sendEvent("onTimerAlarms", this.sentAlarms++); // send the index of the alarm in the alarms array 
} 
} 
} 
if (this.isPaused() && this.getTicksDifference() == this.sleepDuration) this.resume(); 
if (this.hasControl()) { 
// control timelines of mcs 
// programmatic animation code 
for (var k = 0; k < this.mcs.length; k++) { 
this.mc = this.mcs[k]; 
this.isPaused() ? this.mc.stop() : this.mc.gotoAndStop((this.mc._currentframe == this.mc._totalframes) ? this.mc._currentframe - this.mc._totalframes + 1 : this.mc._currentframe + 1); 
} 
updateAfterEvent(); 
} 
if (this.getHiddenTicksCount() >= this.initialDelay) { 
// main method 
// if the counter is paused or sleeping we do not augment the tick counter 
// we do not send the onTimerTick event if the timer is not ticking 
if (!this.isPaused() && this.isRunning()) { 
this.sendEvent("onTimerTick", ++this.ticksCounter); 
} 
} 
// increase the hidden ticks counter unless the timer is stopped 
if (this.isRunning()) ++this.hiddenTicksCounter; 
// has scheduled executions? 
if (this.hasSchedule() && this.getHiddenTicksCount() >= this.initialDelay) { 
this.execute(); 
} 
}