/**
 * Interface Elements for jQuery
 * FX - scroll to
 * www.jb51.net 
 * http://interface.eyecon.ro
 * 
 * Copyright (c) 2006 Stefan Petre
 * Dual licensed under the MIT (MIT-LICENSE.txt) 
 * and GPL (GPL-LICENSE.txt) licenses.
 *   
 *
 */

jQuery.fn.ScrollTo = function(s, transition) {
	o = jQuery.speed(s);
	return this.queue('interfaceFX',function(){
		new jQuery.fx.ScrollTo(this, o, transition);
	});
};

jQuery.fx.ScrollTo = function (e, o, transition)
{
	var z = this;
	z.o = o;
	z.e = e;
	z.transition = transition||'original';
	p = jQuery.iUtil.getPosition(e);
	s = jQuery.iUtil.getScroll();
	z.clear = function(){clearInterval(z.timer);z.timer=null;jQuery.dequeue(z.e, 'interfaceFX');};
	z.t=(new Date).getTime();
	s.h = s.h > s.ih ? (s.h - s.ih) : s.h;
	s.w = s.w > s.iw ? (s.w - s.iw) : s.w;
	z.endTop = p.y > s.h ? s.h : p.y;
	z.endLeft = p.x > s.w ? s.w : p.x;
	z.startTop = s.t;
	z.startLeft = s.l;
	z.step = function(){
		var t = (new Date).getTime();
		var n = t - z.t;
		var p = n / z.o.duration;
		if (t >= z.o.duration+z.t) {
			z.clear();
			setTimeout(function(){z.scroll(z.endTop, z.endLeft)},13);
		} else {
			st = jQuery.fx.transitions(p, n, z.startTop, (z.endTop - z.startTop), z.o.duration, z.transition);//((-Math.cos(p*Math.PI)/2) + 0.5) * (z.p.y-z.s.t) + z.s.t;
			sl = jQuery.fx.transitions(p, n, z.startLeft, (z.endLeft - z.startLeft), z.o.duration, z.transition);//((-Math.cos(p*Math.PI)/2) + 0.5) * (z.p.x-z.s.l) + z.s.l;
			z.scroll(st, sl);
		}
	};
	z.scroll = function (t, l){window.scrollTo(l, t)};
	z.timer=setInterval(function(){z.step();},13);
};
