/**
*
*   Simple jQuery Contect Scroller / Image Gallery with Easing Effect
*   Author:      Marcell Jusztin
*   Date:        3rd July, 2010
*   URL:         http://www.marcelljusztin.com
*   Version:     0.1
*
*/

jQuery.fn.reelGallery = function(options) {

	settings = jQuery.extend({
		maxAcceleration : 20,
		speedFactor: 0.2,
		framesPerSecundum: 33,
		eventArea: 'document',
		keyEvents: true,
		mouseEvents: true
	}, options);
	
	var scrollObject = document.getElementById(jQuery(this).attr('id'));
	var scrollObjectId = jQuery(this).attr('id');
	var fullHeight = 0;
	var lastHeight = 0;
	var dy = 0;
	var delta = 0;
	var speedFactor = settings.speedFactor;
	var maxAcceleration = settings.maxAcceleration;
	var framesPerSecundum = settings.framesPerSecundum;
	var eventArea = settings.eventArea;
	var mouseEvents = settings.mouseEvents;
	var keyEvents = settings.keyEvents;
		
	function setHeight() {
		var oLi = scrollObject; //document.getElementById('images');
		if(oLi.firstChild) { // check for children
			var oChild = oLi.firstChild;
			while(oChild) { // run over them
				if(oChild.nodeType==1) { // element
					var h = jQuery(oChild).children().children().height();
					fullHeight += h;
					lastHeight = h;
					jQuery(oChild).height(h);
				}
				oChild = oChild.nextSibling;
			}
		}
	}		
		
	
	function init() {
		setHeight();
		dy = -1 * lastHeight; 
		margins = 300
		window["timer" + 123] = window.setInterval(update,framesPerSecundum);
	}
	
	if(mouseEvents){
		$((eventArea == 'document' ? eval('document') : eventArea)).mousewheel(
			function(event, delta){
				if((dy < (-1 * ((fullHeight) - jQuery('#' + scrollObjectId).height() + lastHeight + margins)) && delta < 0) || (delta > 0 && (dy > -1 * lastHeight) )) {
					maxAcceleration = maxAcceleration / 1.5;
				} else {
					maxAcceleration = 20;
				}
				dy += delta * maxAcceleration;
			}
		);
	}
	
	if(keyEvents){
		$(document).keydown(
			function(event){
				if((dy < (-1 * ((fullHeight) - jQuery('#' + scrollObjectId).height() + lastHeight + margins)) && event.keyCode == 40) || ( dy > -1 * lastHeight && event.keyCode == 38 )) {
					maxAcceleration = maxAcceleration / 1.5;
				} else {
					maxAcceleration = 20;
				}
				if(event.keyCode == 40) dy += -1.6 * maxAcceleration;
				if(event.keyCode == 38) dy += 1.6 * maxAcceleration;
				if(event.keyCode == 36) dy = -1 * lastHeight;
				if(event.keyCode == 35) dy = -1 * (fullHeight - jQuery('#' + scrollObjectId).height() + lastHeight + margins);
			}		
		);
	}
	
	
	function countChildElements(parent, child) {
        var parent = document.getElementById(parent);
        var childCount = parent.getElementsByTagName(child).length;
		return childCount;
    }
	
	function update(){		
		y = jQuery('#' + scrollObjectId + ' li').offset().top;
		y += ( dy - y ) * speedFactor;
		jQuery('#' + scrollObjectId + ' li').css('top', y);
	}
	
	init();
	
}
