const starColors = ["#44ADFC", "#F212F9", "#F7DB4F", "#FC712B", "#FFFFFF"];
var starContainer = document.getElementById("star-container"); //Get svg element
var svgNS = "http://www.w3.org/2000/svg";
for (let i = 0; i < 300; i++) {
  createStar(i);
  const xPos = Math.random() * 3000;
  const yPos = Math.random() * 6000;
  const speed = Math.random() * (200 - 100) + 100;
  TweenMax.fromTo(
    "#star-" + i,
    speed,
    { x: xPos, y: yPos },
    { y: yPos + 6000 }
  );
}

TweenMax.set("#planet", { rotation: -25, transformOrigin: "center center" });
TweenMax.set("#rings_4_", {
  rotation: -25,
  x: 4,
  transformOrigin: "center center"
});
TweenMax.set("#planet-sprite-1", { scale: 0.3, x: 300 });


TweenMax.fromTo("#rocket", 1.5, {y:-30},{y:30, repeat:-1, ease:Sine.easeInOut, yoyo:true})

TweenMax.fromTo("#rocket", .5, {x:-3},{x:3, repeat:-1, ease:Sine.easeIn, yoyo:true})


TweenMax.fromTo("#planet-sprite-1", 20, {y:-200},{y:500, repeat:-1, yoyo:false, ease:Linear.noEase,})


TweenMax.fromTo(
  "#flame_3_",
  0.7,
  { scaleY: 0.8 },
  { scaleY: 1.1, repeat: -1, yoyo: true, ease: Sine.easeInOut }
);
TweenMax.fromTo(
  "#flame_4_",
  0.9,
  { scaleY: 1 },
  { scaleY: 1.2, repeat: -1, yoyo: true, ease: Sine.easeInOut }
);
TweenMax.fromTo(
  "#flame_5_",
  1.1,
  { scaleY: 1 },
  { scaleY: 1.25, repeat: -1, yoyo: true, ease: Sine.easeInOut }
);

TweenMax.set("#star-container", { y: -4000 });

function createStar(id) {
  var group = document.createElementNS(svgNS, "g");

  var randomStyle = Math.floor(Math.random() * 5);
  var randomColor = starColors[Math.floor(Math.random() * starColors.length)];
  if (randomStyle === 1) {
    var plus = document.createElementNS(svgNS, "path");
    plus.setAttributeNS(null, "class", "st4 plus-star");
    plus.setAttributeNS(null, "id", "star-" + id);

    plus.setAttributeNS(
      null,
      "d",
      "M26.1 13c0 3.6-8 3-9 4.1s-.5 9-4.1 9-3-8-4.1-9S0 16.6 0 13s8-3 9-4 .4-9 4-9 3 8 4.1 9 9 .4 9 4z"
    );
    plus.setAttributeNS(null, "fill", randomColor);

    group.appendChild(plus);
  } else {
    var radius = Math.random() * (10 - 4) + 4;
    group.setAttributeNS(null, "id", "star-" + id);
    var star = document.createElementNS(svgNS, "circle");
    star.setAttributeNS(null, "fill", randomColor);
    star.setAttributeNS(null, "cx", 21.3);
    star.setAttributeNS(null, "cy", 21.3);
    star.setAttributeNS(null, "r", radius);
    group.appendChild(star);
  }
  starContainer.appendChild(group);
}