const stars = document.querySelectorAll('div');
const hyper = document.getElementById('hyper');

stars.forEach((star,i) => {
  let x = `${Math.random() * 200}vmax`
  let y = `${Math.random() * 100}vh`
  let z = `${Math.random() * 200 - 100}vmin`
  let rx = `${Math.random() * 360}deg`
  star.style.setProperty('--x', x)
  star.style.setProperty('--y', y)
  star.style.setProperty('--z', z)
  star.style.setProperty('--rx', rx)
});

hyper.addEventListener('click', e => {
  if (document.documentElement.classList.contains('hyper')) {
    stars.forEach((star,i) => {
      star.style.animationName = null;
      //star.style.animationIterationCount = 1;
    });
    hyper.textContent = '播放';
  } else {
    stars.forEach((star,i) => {
      let delay = `${Math.random() * 900}ms`;
      star.style.animationDelay = delay;
      star.style.animationName = 'hyper';
    });
    hyper.textContent = '暂停';
  }
  document.documentElement.classList.toggle('hyper');
})