var mainElement = new Vue({
  el: '#app',
  data() {
    return {
      progressBarOn: true,
      progressBar: 0,
      intervalProgress: undefined,
      intervalItem: undefined,
      currentChairIndex: undefined,
      currentMatIndex: undefined,
      mats: [
        {
          thumbnail: 'img/1.png',
          main: 'img/1-1.png',
        },
        {
          thumbnail: 'img/2.png',
          main: 'img/2-2.png',
        },
        {
          thumbnail: 'img/3.png',
          main: 'img/3-3.png',
        }
      ],
      chairs: [
        {
          thumbnail: 'img/4.png',
          main: 'img/4-4.png',
        },
        {
          thumbnail: 'img/5.png',
          main: 'img/5-5.png',
        },
        {
          thumbnail: 'img/6.png',
          main: 'img/6-6.png',
        }
      ]
    }
  },
  methods: {
    /**
     * @params event is an object
     * key = type of item clicked
     * value = index passed in
     */
    _handleImagePreview(event){
      // Disable timer functionality
      clearInterval(this.intervalItem);
      clearInterval(this.intervalProgress);
      this.progressBarOn = false;
      
      // Show item clicked
      let index = event.value;
      let dataType = event.key;
      if(this[dataType] == index){
        this[dataType] = undefined;
      } else {
        this[dataType] = index;
      }
    },
  },
  mounted(){
    let progressCount = 0;
    let count = 0;
    let maxArrayLength = this.chairs.length;
    
    this.intervalProgress = setInterval(() => {
      this.progressBar = progressCount + '%'
      progressCount += 0.1111111; /* 100%/(9000/10) */
      if(progressCount > 100){
        progressCount = 0;
      }
    }, 10);
    
    this.intervalItem = setInterval(() =>{
      console.log("I ran");
      this.currentChairIndex = count;
      this.currentMatIndex = count;
      if(count < maxArrayLength - 1){
        count++;
      } else {
        count = 0;
      }
    },3000)
  }
});