// Customize these...
var n = 300,
    speed = 15,
    startSize = rand(200,500);

// ...not these
var c = document.getElementById("c"),
    ctx = c.getContext("2d"),
    cw = (c.width = window.innerWidth),
    ch = (c.height = window.innerHeight),
    mousePos = {x:"", y:""},
    img = new Image(),
    particles = [],
    particleNumber = 0,
    Particle = function(index) {
      this.index = index;
      this.dur = (100-rand(9, 90))/speed;
      this.draw = function() {
        ctx.translate( this.x, this.y );
        ctx.globalAlpha = this.alpha;
        ctx.globalCompositeOperation = 'lighter';
        // if (index%1.5==0) ctx.globalCompositeOperation = 'overlay';
        if (index%2==0) ctx.globalCompositeOperation = 'xor';
        ctx.drawImage(img, -this.size/2, -this.size/2, this.size, this.size);
        ctx.translate( -this.x, -this.y );
      }
    };

c.onmousemove = function(e){ mousePos = { x:e.clientX, y:e.clientY }; }
document.onmouseleave = function(e){ mousePos = {x:"", y:""} }

function setParticle(p, firstRun) {
  var _x = cw*rand(0,1), _y = ch*rand(0,1), _s = startSize;
  if (rand(0,1)>0.3 && mousePos.x!=""){ //console.log(mousePos)
    _x = mousePos.x;
    _y = mousePos.y;
    _s = _s/10;
  }
  var _tl = new TimelineMax()
            .fromTo(p, p.dur, {
                x:_x,
                y:_y,
                size:_s,
                alpha:0
            },{
                size:'+='+String(rand(200,400)),
                bezier:[{alpha:rand(0.15,0.65)},{alpha:0}],
                ease:Power1.easeOut,//ease:Power0.easeNone,
                onComplete:function(){ setParticle(p); }
            });

  if (firstRun) _tl.seek(p.dur*rand()); //fast-forward on first run
}


TweenMax.ticker.addEventListener("tick", function(){
  ctx.clearRect(0, 0, cw, ch);
  for (var i=0; i<n; i++) particles[i].draw();
});


window.addEventListener('resize', doResize)
function doResize() {
  particleNumber = 0;  
  cw = (c.width = window.innerWidth);
  ch = (c.height = window.innerHeight);
  for (var i=0; i<n; i++) {
    TweenMax.killTweensOf(particles[i]);
    setParticle(particles[i], true);
  }
  TweenMax.fromTo(c, 0.3, {alpha:0},{alpha:1, ease:Power3.easeInOut});
}

// First run
for (var i=0; i<n; i++) particles.push(new Particle(i));
doResize();


function rand(min, max) {
  (min) ? min=min : min=0;
  (max) ? max=max : max=1;
  return min + (max-min)*Math.random();
}


img.src = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAACXBIWXMAAAsTAAALEwEAmpwYAAABXFBMVEVHcEwN2uAM1dkO2N0L1NkF1toL2N8Ay9ABx8kG09cFzNMZ6u0I3OIP190DvsQCvsMN0dgW6/EGw8kGwsgQ2d8O2+EP1tsP0dgM4OYGw8kH2N4P190Ex84GwsgZ3uRL9/0N2N4G09kOzdMf7/UQ2d8FwcgFxMsGwsgi4ugG0tkO2uEI09oNz9UIzNEO2eAJ0NYW5OoS5+wHzNIGwcgN4+oEvsUp7vQJx80O3eQN2uEb6O8P3OIj5usT4OYU3OJM8vdX+Pwt5+0CvsYDvcMOztUO4eYP0tgR190HxMoO2+Ej6e8U2+EO0tgP3OIKzNIFwMYHyc838/kQ3OIHw8kQ0tcb4eYQ190Jxs0FwsgM1tsJx84U3OI/7fMOzdMO2OAEv8YO2uAKydAW4uhl+PwQ1dsM09k16/FD9/wEwMY48PYFw8kw7fMJxcoFwshh+v419vyD/P8o8vh3+/5w+/6toXD7AAAAbnRSTlMAHxErCQMXAgEG9g38VSUvM/5Uw6AlOUr8Q/lp8tnX/kH7W/6+fOmh6fZx7q/D19/3/ex0/k/7pkzz++jw88L7/vMbOnQvlH/QkvfNxTzTaN/9q7mi4rWWi+Rt4fmPXpOIfuz9e9T3/q775fmyYVC4UJcAAANTSURBVDjLhdVnU+pAFAZg0hORIppEQAGpIlUUBQVERUCahd5UBMGK7f/P3LNU6/WdCZ+eOWd3szlIJN/Cokj+CAOhUP6wIDiOI0n4AfsjYVmKI3Ea4wklRCHHDnCSY75blqFIKc0TglpUQfzqQ4Uc6LeqyOEYIYjGk9qGxWLZqD2p1IfyAyTZr44HttGqlG0olxXLiUqtkJMU89URamOtVbY95udR8re2S8uJ/1D+qTuLnGiMNbcf55PJ5UGS83lbZUP1WcI+eIOxVd7OJ5dP760o9/dAby8Hctqck2KCLNZ0unKnVt/SKNb7ZST9igNuIkn6SNQOnM83M87SEpKVE7Ucp8YQx4SLTsGV8wCzrwyDqHV53mZRKQ7I8Z5pQtTGnRmPz2Ff0WhmUTQrK/YZ32kyfzktyVKYUtYpZG6qDjuoxcVNyCJYJKGkX0GPNk7x2YsrKOgIBmcXN9fnUNaBauwOT/Kx8nQ42g5DEQZtvAQFwa3PmUym11cTUCR9uXwZeo8gdxRYOza7q8Ewcq/PKEBB2h2nLhuc0BCyCC6Y3btB7/oOuJ5er+8huTmrcXhc27BIclKxg2DYi5w+2u/3o/rnVygZHEAVQHbcegS3znrR/vvb23u0d2baGUH/BBIfoL7//vLy8tbWn23teBGcrpHheIP2uOSuh70pBN8+wOqNq1wb7xoOXLi4Ok/Xr4dwULGvv9vaCQerOef0HCUUTcBuIu7d69TWXS/ahjW2o3t3KW9415PZbqkUNDd8Mww+6A0lQ6mHu71ouw2u8ZAK71ZvnKjz5PrANZPBAemKILuNPZRGdz90Xb/JFFpGJUaO7zgFFxxWGdEVV0P73W6j0eiCW627M85mTU3g3GSOcDR6i0MZ2kcJrRaRi8dUSnp6wyUUR2dlIM1pXbG4ilKs69JmcEYD9vHrgnGCgbxaOI+kdYOk0+ZSoQmOl36aFvDBYtmANnG8cG42RyIRc6lUiCe0MuSYLyOFwwRRpk1cHS9ACvFmInYhZnmc+jqooDt9hOhaJ5HodGJao5iFgwH3w5yCaaY0BAIyoywgGgSCp0mK+WlIMpR0OB8FQUnwGI1zzK9TlyJJ6TAwdf87mxlulN8m84elMrBahvnzbwHZ0fM5/wCsDLyQI/IavwAAAABJRU5ErkJggg==";