import { CommonService } from '../../services/common-service'
import { UserWebservice } from '../../services/customized/user-web-service'
const app = getApp()

const commonService = new CommonService()
const userWebservice = new UserWebservice()

Page({
    data: {
    },
    onLoad: function(options) {

        let user = app.services.cacheService.getStorage(null, 'USER')
        this.setData({user: user})

        if(user.nickName == null){
            this.setData({showAuthorize: true})
        }


        let roles = app.services.cacheService.getStorage(null, 'ROLES')
        if(roles!=null){
            for(let item of roles){
                if(item.roleName == 'ADMIN' || item.roleName == 'SUPER_ADMIN'){
                    this.setData({isAdmin: true})
                }
                if(item.roleName == 'TEACHER'){
                    this.setData({isTeacher: true})
                }
                if(item.roleName == 'CUSTOMER'){
                    this.setData({isCustomer: true})
                }
            }
        }

    },
    onShow: function() {
    },
    onQrCodeTap: function(e){
        wx.navigateTo({
            url: '/pages/qrcode/qrcode'
        })
    },
    onClearCache: function(e){
        app.services.cacheService.initStorage()
        wx.showToast({
            title: "清除成功"
        })
       userWebservice.getLoginInfo()
           .subscribe((res)=>{
                if(res.data != null && res.data.value != null){

                    app.services.cacheService.setStorage(null, 'ROLES', res.data.value.roles)
                    app.services.cacheService.setStorage(null, 'ALL_ROLES', res.data.value.allRoles)
                    app.services.cacheService.setStorage(null, 'USER', res.data.value.user)
                    app.services.cacheService.setStorage(null, 'DICTIONARIES', res.data.value.dictionaries)

                }

                setTimeout(()=>{
                         wx.reLaunch({
                      url: '/pages/my/my'
                    })
                },1000)
            })
    },
    onDmMember: function(e){
        wx.navigateTo({
            url: '/pages/dm-member/dm-member'
        })
    },
    onVideo: function(e){
        wx.navigateTo({
            url: '/pages/dm-video/dm-video'
        })
    },
    onImage: function(e){
        wx.navigateTo({
            url: '/pages/dm-image/dm-image'
        })
    },
    onUserInfo: function(e){
        wx.navigateTo({
            url: '/pages/user-info/user-info'
        })
    },
    onAuthorizeEvent(e){
        if(e.detail.errMsg == 'getUserInfo:ok'){
            commonService.getUserInfoOK(e.detail, (user)=>{
                this.setData({user: user})
            })
        }else{
            app.services.utilService.toHomePage()
        }

    },
    onPersonalInformationPatriarchTap: function(e){
        wx.navigateTo({
            url: '/pages/personal-information-patriarch/personal-information-patriarch'
        })
    },
    onPersonalInformationKids: function(e){
        wx.navigateTo({
            url: '/pages/personal-information-kids-list/personal-information-kids-list'
        })
    },

    onPersonalInformationTeacher: function(e){
        wx.navigateTo({
            url: '/pages/personal-information-teacher/personal-information-teacher?userTeacherUid='+e.currentTarget.dataset.userteacheruid
        })
    },
    onPersonalInformationManager: function(e){
        wx.navigateTo({
            url: '/pages/teacher-manage-students/teacher-manage-students'
        })
    },
    onCecord: function(e){
        wx.navigateTo({
            url: '/pages/class-record-show-teacher/class-record-show-teacher'
        })
    },
    onClassRecordShow: function(e){
        wx.navigateTo({
            url: '/pages/class-record-show-student-list/class-record-show-student-list'
        })
    },
    onScheduleAdmin: function(e){
        wx.navigateTo({
            url: '/pages/admin-show-all-course/admin-show-all-course'
        })
    },
    onKidsCourseShow: function(e){
        wx.navigateTo({
            url: '/pages/class-schedule-student-list/class-schedule-student-list'
        })
    },
    onClassWarning: function () {
        wx.navigateTo({
            url: '/pages/admin-early-warning/admin-early-warning'
        })
    },
    onManageLeave: function(e){
        wx.navigateTo({
            url: '/pages/manage-leave/manage-leave?code='+e.currentTarget.dataset.code
        })
    },
    onTeacherCourseShow: function(e){
        wx.navigateTo({
            url: '/pages/class-schedule-teacher/class-schedule-teacher?userTeacherUid='+e.currentTarget.dataset.userteacheruid
        })
    },
    onAdminScan: function(e){
        wx.scanCode({
            onlyFromCamera: true,
            success: (res) => {
                wx.navigateTo({
                    url: '/pages/dm-scan/dm-scan?qrContent=' + res.result
                })
            }
        })
    },

    onShowAllTeacher: function(e){
        wx.navigateTo({
            url: '/pages/show-all-teacher/show-all-teacher'
        })
    },

    onShowAllStudent: function(e){
        wx.navigateTo({
            url: '/pages/show-all-student/show-all-student'
        })
    }

});