<?php
/**
 * 文章、页面管理
 *
 * @copyright (c) Emlog All Rights Reserved
 */

class Log_Model {

    private $db;

    function __construct() {
        $this->db = Database::getInstance();
    }

    /**
     * 添加文章、页面
     *
     * @param array $logData
     * @return int
     */
    function addlog($logData) {
    $kItem = array();
    $dItem = array();
    foreach ($logData as $key => $data) {
        $kItem[] = $key;
        $dItem[] = $data;
    }
    $field = implode(',', $kItem);
    $values = "'" . implode("','", $dItem) . "'";

    $gidarr[0]='0';
    $res = $this->db->query("SELECT gid From  " . DB_PREFIX . "blog ORDER BY gid ASC");
    while ($row = $this->db->fetch_array($res)) {
        $gidarr[] = $row['gid'];
    }
    foreach($gidarr as $key=>$val){
        if($key!=$val){
            $field = 'gid,'.$field;
            $values = "'".$key."',".$values;
            break;
        }
    }

    $this->db->query("INSERT INTO " . DB_PREFIX . "blog ($field) VALUES ($values)");
    $logid = $this->db->insert_id();
    return $logid;
}

    /**
     * 更新文章内容
     *
     * @param array $logData
     * @param int $blogId
     */
    function updateLog($logData, $blogId) {
        $author = ROLE == ROLE_ADMIN ? '' : 'and author=' . UID;
        $Item = array();
        foreach ($logData as $key => $data) {
            $Item[] = "$key='$data'";
        }
        $upStr = implode(',', $Item);
        $this->db->query("UPDATE " . DB_PREFIX . "blog SET $upStr WHERE gid=$blogId $author");
    }

    /**
     * 获取指定条件的文章条数
     *
     * @param int $spot 0:前台 1:后台
     * @param string $hide
     * @param string $condition
     * @param string $type
     * @return int
     */
    function getLogNum($hide = 'n', $condition = '', $type = 'blog', $spot = 0) {
        $hide_state = $hide ? "and hide='$hide'" : '';

        if ($spot == 0) {
            $author = '';
        }else {
            $author = ROLE == ROLE_ADMIN ? '' : 'and author=' . UID;
        }

        $data = $this->db->once_fetch_array("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "blog WHERE type='$type' $hide_state $author $condition");
        return $data['total'];
    }

    /**
     * 后台获取单篇文章
     */
    function getOneLogForAdmin($blogId) {
        $author = ROLE == ROLE_ADMIN ? '' : 'AND author=' . UID;
        $sql = "SELECT * FROM " . DB_PREFIX . "blog WHERE gid=$blogId $author";
        $res = $this->db->query($sql);
        if ($this->db->affected_rows() < 1) {
            emMsg('权限不足！', './');
        }
        $row = $this->db->fetch_array($res);
        if ($row) {
            $row['title'] = htmlspecialchars($row['title']);
            $row['content'] = htmlspecialchars($row['content']);
            $row['excerpt'] = htmlspecialchars($row['excerpt']);
            $row['thumbs'] = htmlspecialchars($row['thumbs']);
             $row['copyurl'] = htmlspecialchars($row['copyurl']);
            $row['copy'] = intval($row['copy']);
            $row['password'] = htmlspecialchars($row['password']);
            $row['template'] = !empty($row['template']) ? htmlspecialchars(trim($row['template'])) : 'page';
            $logData = $row;
            return $logData;
        } else {
            return false;
        }
    }

    /**
     * 前台获取单篇文章
     */
    function getOneLogForHome($blogId) {
        $sql = "SELECT * FROM " . DB_PREFIX . "blog WHERE gid=$blogId AND hide='n' AND checked='y'";
        $res = $this->db->query($sql);
        $row = $this->db->fetch_array($res);
        if ($row) {
            $logData = array(
                'log_title' => htmlspecialchars($row['title']),
                'timestamp' => $row['date'],
                'date' => $row['date'],
                'logid' => intval($row['gid']),
                'sortid' => intval($row['sortid']),
                'thumbs'=> htmlspecialchars($row['thumbs']),
                'copy' => intval($row['copy']),
                'copyurl'=> htmlspecialchars($row['copyurl']),
                'type' => $row['type'],
                'author' => $row['author'],
                'log_content' => rmBreak($row['content']),
                'views' => intval($row['views']),
                'comnum' => intval($row['comnum']),
                'top' => $row['top'],
                'sortop' => $row['sortop'],
                'attnum' => intval($row['attnum']),
                'allow_remark' => Option::get('iscomment') == 'y' ? $row['allow_remark'] : 'n',
                'password' => $row['password'],
                'daoyu' => $row['daoyu'],//文章导语
                'opendown' => $row['opendown'],//文章导语
                'template' => $row['template'],
                );
            return $logData;
        } else {
            return false;
        }
    }

    /**
     * 后台获取文章列表
     *
     * @param string $condition
     * @param string $hide_state
     * @param int $page
     * @param string $type
     * @return array
     */
    function getLogsForAdmin($condition = '', $hide_state = '', $page = 1, $type = 'blog') {
        $perpage_num = Option::get('admin_perpage_num');
        $start_limit = !empty($page) ? ($page - 1) * $perpage_num : 0;
        $author = ROLE == ROLE_ADMIN ? '' : 'and author=' . UID;
        $hide_state = $hide_state ? "and hide='$hide_state'" : '';
        $limit = "LIMIT $start_limit, " . $perpage_num;
        $sql = "SELECT * FROM " . DB_PREFIX . "blog WHERE type='$type' $author $hide_state $condition $limit";
        $res = $this->db->query($sql);
        $logs = array();
        while ($row = $this->db->fetch_array($res)) {
            $row['date']	= date("Y-m-d H:i", $row['date']);
            $row['title'] 	= !empty($row['title']) ? htmlspecialchars($row['title']) : '无标题';
            //$row['gid'] 	= $row['gid'];
            //$row['comnum'] 	= $row['comnum'];
            //$row['top'] 	= $row['top'];
            //$row['attnum'] 	= $row['attnum'];
            $logs[] = $row;
        }
        return $logs;
    }

    /**
     * 前台获取文章列表
     *
     * @param string $condition
     * @param int $page
     * @param int $perPageNum
     * @return array
     */
    function getLogsForHome($condition = '', $page = 1, $perPageNum) {
        $start_limit = !empty($page) ? ($page - 1) * $perPageNum : 0;
        $limit = $perPageNum ? "LIMIT $start_limit, $perPageNum" : '';
        $sql = "SELECT * FROM " . DB_PREFIX . "blog WHERE type='blog' and hide='n' and checked='y' $condition $limit";
        $res = $this->db->query($sql);
        $logs = array();
        while ($row = $this->db->fetch_array($res)) {
            $row['log_title'] = htmlspecialchars(trim($row['title']));
            $row['log_url'] = Url::log($row['gid']);
            $row['logid'] = $row['gid'];
            $cookiePassword = isset($_COOKIE['em_logpwd_' . $row['gid']]) ? addslashes(trim($_COOKIE['em_logpwd_' . $row['gid']])) : '';
            if (!empty($row['password']) && $cookiePassword != $row['password']) {
                $row['excerpt'] = '<p>[该文章已设置加密，请点击标题输入密码访问]</p>';
            } else {
                if (!empty($row['excerpt'])) {
                    $row['excerpt'] .= '<p class="readmore"><a href="' . Url::log($row['logid']) . '">阅读全文&gt;&gt;</a></p>';
                }
            }
            $row['thumbs']= htmlspecialchars($row['thumbs']);
            $row['log_description'] = empty($row['excerpt']) ? breakLog($row['content'], $row['gid']) : $row['excerpt'];
            $row['attachment'] = '';
            $row['tag'] = '';
            $row['tbcount'] = 0;//兼容未删除引用的模板
            $logs[] = $row;
        }
        return $logs;
    }

    /**
     * 获取全部页面列表
     *
     */
    function getAllPageList() {
        $sql = "SELECT * FROM " . DB_PREFIX . "blog WHERE type='page'";
        $res = $this->db->query($sql);
        $pages = array();
        while ($row = $this->db->fetch_array($res)) {
            $row['date']	= date("Y-m-d H:i", $row['date']);
            $row['title'] 	= !empty($row['title']) ? htmlspecialchars($row['title']) : '无标题';
            //$row['gid'] 	= $row['gid'];
            //$row['comnum'] 	= $row['comnum'];
            //$row['top'] 	= $row['top'];
            //$row['attnum'] 	= $row['attnum'];
            $pages[] = $row;
        }
        return $pages;
    }

    /**
     * 删除文章
     *
     * @param int $blogId
     */
    function deleteLog($blogId) {
        $author = ROLE == ROLE_ADMIN ? '' : 'and author=' . UID;
        $this->db->query("DELETE FROM " . DB_PREFIX . "blog where gid=$blogId $author");
        if ($this->db->affected_rows() < 1) {
            emMsg('权限不足！', './');
        }
        // 评论
        $this->db->query("DELETE FROM " . DB_PREFIX . "comment where gid=$blogId");
        // 标签
        $this->db->query("UPDATE " . DB_PREFIX . "tag SET gid= REPLACE(gid,',$blogId,',',') WHERE gid LIKE '%" . $blogId . "%' ");
        $this->db->query("DELETE FROM " . DB_PREFIX . "tag WHERE gid=',' ");
        // 附件
        $query = $this->db->query("select filepath from " . DB_PREFIX . "attachment where blogid=$blogId ");
        while ($attach = $this->db->fetch_array($query)) {
            if (file_exists($attach['filepath'])) {
                $fpath = str_replace('thum-', '', $attach['filepath']);
                if ($fpath != $attach['filepath']) {
                    @unlink($fpath);
                }
                @unlink($attach['filepath']);
            }
        }
        $this->db->query("DELETE FROM " . DB_PREFIX . "attachment where blogid=$blogId");
    }

    /**
     * 隐藏/显示文章
     *
     * @param int $blogId
     * @param string $state
     */
    function hideSwitch($blogId, $state) {
        $author = ROLE == ROLE_ADMIN ? '' : 'and author=' . UID;
        $this->db->query("UPDATE " . DB_PREFIX . "blog SET hide='$state' WHERE gid=$blogId $author");
        $this->db->query("UPDATE " . DB_PREFIX . "comment SET hide='$state' WHERE gid=$blogId");
        $Comment_Model = new Comment_Model();
        $Comment_Model->updateCommentNum($blogId);
    }

    /**
     * 审核/驳回作者文章
     *
     * @param int $blogId
     * @param string $state
     */
    function checkSwitch($blogId, $state) {
        $this->db->query("UPDATE " . DB_PREFIX . "blog SET checked='$state' WHERE gid=$blogId");
        $state = $state == 'y' ? 'n' : 'y';
        $this->db->query("UPDATE " . DB_PREFIX . "comment SET hide='$state' WHERE gid=$blogId");
        $Comment_Model = new Comment_Model();
        $Comment_Model->updateCommentNum($blogId);
    }

    /**
     * 增加阅读次数
     *
     * @param int $blogId
     */
    function updateViewCount($blogId) {
if(ROLE != 'admin' && ROLE != 'writer'){
		$this->db->query("UPDATE " . DB_PREFIX . "blog SET views=views+1 WHERE gid=$blogId");
		}
    }

    /**
     * 判断是否重复发文
     */
    function isRepeatPost($title, $time) {
        $sql = "SELECT gid FROM " . DB_PREFIX . "blog WHERE title='$title' and date='$time' LIMIT 1";
        $res = $this->db->query($sql);
        $row = $this->db->fetch_array($res);
        return isset($row['gid']) ? (int)$row['gid'] : false;
    }

    /**
     * 获取相邻文章
     *
     * @param int $date unix时间戳
     * @return array
     */
    function neighborLog($date) {
        $neighborlog = array();
        $neighborlog['nextLog'] = $this->db->once_fetch_array("SELECT title,gid FROM " . DB_PREFIX . "blog WHERE date < $date and hide = 'n' and checked='y' and type='blog' ORDER BY date DESC LIMIT 1");
        $neighborlog['prevLog'] = $this->db->once_fetch_array("SELECT title,gid FROM " . DB_PREFIX . "blog WHERE date > $date and hide = 'n' and checked='y' and type='blog' ORDER BY date LIMIT 1");
        if ($neighborlog['nextLog']) {
            $neighborlog['nextLog']['title'] = htmlspecialchars($neighborlog['nextLog']['title']);
        }
        if ($neighborlog['prevLog']) {
            $neighborlog['prevLog']['title'] = htmlspecialchars($neighborlog['prevLog']['title']);
        }
        return $neighborlog;
    }

    /**
     * 随机获取指定数量文章
     */
    function getRandLog($num) {
        global $CACHE;
        $sta_cache = $CACHE->readCache('sta');
        $lognum = $sta_cache['lognum'];
        $start = $lognum > $num ? mt_rand(0, $lognum - $num): 0;
        $sql = "SELECT gid,title FROM " . DB_PREFIX . "blog WHERE hide='n' and checked='y' and type='blog' LIMIT $start, $num";
        $res = $this->db->query($sql);
        $logs = array();
        while ($row = $this->db->fetch_array($res)) {
            $row['gid'] = intval($row['gid']);
            $row['title'] = htmlspecialchars($row['title']);
            $logs[] = $row;
        }
        return $logs;
    }

    /**
     * 获取热门文章
     */
    function getHotLog($num) {
        $sql = "SELECT gid,title FROM " . DB_PREFIX . "blog WHERE hide='n' and checked='y' and type='blog' ORDER BY views DESC, comnum DESC LIMIT 0, $num";
        $res = $this->db->query($sql);
        $logs = array();
        while ($row = $this->db->fetch_array($res)) {
            $row['gid'] = intval($row['gid']);
            $row['title'] = htmlspecialchars($row['title']);
            $logs[] = $row;
        }
        return $logs;
    }

    /**
     * 处理文章别名，防止别名重复
     *
     * @param string $alias
     * @param array $logalias_cache
     * @param int $logid
     */
    function checkAlias($alias, $logalias_cache, $logid) {
        static $i=2;
        $key = array_search($alias, $logalias_cache);
        if (false !== $key && $key != $logid) {
            if($i == 2) {
                $alias .= '-'.$i;
            }else{
                $alias = preg_replace("|(.*)-([\d]+)|", "$1-{$i}", $alias);
            }
            $i++;
            return $this->checkAlias($alias, $logalias_cache, $logid);
        }
        return $alias;
    }

    /**
     * 加密文章访问验证
     *
     * @param string $pwd
     * @param string $pwd2
     */
    function authPassword($postPwd, $cookiePwd, $logPwd, $logid) {
        $url = BLOG_URL;
        $pwd = $cookiePwd ? $cookiePwd : $postPwd;
        		if ($pwd !== addslashes($logPwd)) {
			?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"> 
<meta charset="UTF-8"> 
<meta http-equiv="X-UA-Compatible" content="IE=edge"> 
<meta name="renderer" content="webkit"> 
<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
<title>该文章已被加密</title>
</head>
<body>
    <div class="main">
        <img class="alert" alt="文章已被加密" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIoAAACACAMAAADjwgEwAAAAOVBMVEUAAAD5dBr7dRj4dBn/cBD5cxr4cxn6chj7dBj/cBj5cxr5dBn6cxn4dBn5cxr6dRX5cxr5cxr5dBoQJfbPAAAAEnRSTlMAgD/AEPDgYEAgoLCQcFAw0J/MNdW8AAADg0lEQVR42s3b7W7iMBSEYWftxA75At//xW7VZRWnQ3WkvOKE+VmJMtjxg8Ek4Iy5e8zdmsLFSXmoz8QSrsw61CZxDJdlrsf0OVyUR5WALrDJh3SZ68uswT1rfZ3e/dpNff0lMTjnVr/yEVO01SZdWae6Z/CFNzYXxxa+kttqwTHl2ORHl95zWBrvl/BMM0e34JZ8XC+6phwWtD7ptv95uWBBdzIVMm0luGTshVYB+B5ccvt12Ubnt8Xt91Vb3JyzX/rk5Jy+cr2M3Jyzl8nMnOO6Bewc103TMee4btw5rpsmA+e4bm7O2boh57huS9twyaODc7Zu43fBR3J1bni1q0/Pv0bgHNNNl3cGzgHdyouhmqBzXLf9SZ2c01HXKsA5pptWcXJOV6hWAc5R3bQKcI7qplUcnLs3uhlV1Ln5bboZVd7rXGqdMKuoQ9ObdDOqAOeAbkYVY0fOdTOqAOeAblLFEOAdutlVbOe4bmYV4BzQzahiOId104DPrVw3uwp3zv5fdhXgHNDNqAKcs3Sbw4kqhnNAN7vK25yLhlFGFcM5pJtdBTtn65ZPVDGcY7rZVbhzpgmgitgEdQNV5DUx3UAV5pxebaCKOMd0A1WYcyoTqKJWIt1AFeSczi6rou+rQDdQBTmnEoAqzLn9cfvjYBXdmQLdQBXgnOrGq+j7PNANVAHOiW6gCnBO2idQBTunuvEqtnPoxE2rgJXJdNMqyCt8OqsnH8A5NoZ6HgScoyf5+ykZ+raGr7f97PCWwD4I6iYnquCbPa4b/0aA6OZwgo9/NwV2IEC3950YeP7GTp1DuhkBzpkDx2M7x3XTAOfMRWZn7OJwn5YETjCQbjqtw8qc47o95GHAOaTbUptswDmkm/6aPwLnsG65HpKQc/rqtvP3fRTgHNUt1kM67tx49u6RqR6SgXNIt30097mlzpXT5G+1zQD2c3zvFmV+kHM6aedgieDBz2GZyN5t2+87TGQ/131PGdu7pa7/Hs/M9nPDD2i3cCqllA3s5/bnjqKbY4bDDLXFQOiwxJaGe/BP2gcihCLQuiZKlV1f58zNDmr9lNtLSyg+C8jeKrSXbX/pCqqHxdyvwTO6j53qnvu8/nFLfgz1uGXJ9SMy/sP3A3J7fhq7Pv34f21fnkUWt3eUtDTVSzPL1u6SKGfjrV6TvtM98bhccMlMOYWXSWXpHJNLaPMXZ8oyOMxlLIsAAAAASUVORK5CYII=">
        <form action="" method="post" class="mk-side-form">
            <h2 class="pw-tip">该文章已被加密</h2>
            <input type="password" name="logpwd" placeholder="请输入访问密码查看" required><button type="submit">提交</button>
            <?php if($postPwd): ?>
            <p id="pw-error">Oops!密码不对哦~</p>
            <script>setTimeout(function() {document.getElementById("pw-error").style.display = "none"}, 2000);</script>
            <?php endif; ?>
        </form>
        <a href="<?php echo $url; ?>" class="return-home" title="点击回到网站首页">- 返回首页 - </a>
    </div>
    <style type="text/css">
    *{font-family:"Microsoft Yahei",微软雅黑,"Helvetica Neue",Helvetica,"Hiragino Sans GB","WenQuanYi Micro Hei",sans-serif;box-sizing:border-box;margin:0px;padding:0px;font-size:14px;-webkit-transition:.2s;-moz-transition:.2s;-ms-transition:.2s;-o-transition:.2s;transition:.2s}
    html,body{width:100%;height:100%}
    body{background-color:#F4F6F9;color:#768093}
    input,button{font-size:1em;border-radius:3px;-webkit-appearance:none}
    input{width:100%;padding:5px;box-sizing:border-box;border:1px solid #e5e9ef;background-color:#f4f5f7;resize:vertical}
    input:focus{background-color:#fff;outline:none}
    button{border:0;background:#6abd09;color:#fff;cursor:pointer;opacity:1;user-select:none}
    button:hover,button:focus{opacity:.9}
    button:active{opacity:1}
    .main{width:100%;max-width:500px;height:300px;padding:30px;background-color:#fff;border-radius:2px;box-shadow:0 10px 60px 0 rgba(29,29,31,0.09);transition:all .12s ease-out;position:absolute;left:0;top:0;bottom:0;right:0;margin:auto;text-align:center}
    .alert{width:80px}
    .mk-side-form{margin-bottom:28px}
    .mk-side-form input{float:left;padding:2px 10px;width:77%;height:37px;border:1px solid #ebebeb;border-right-color:transparent;border-radius:2px 0 0 2px;line-height:37px}
    .mk-side-form button{position:relative;overflow:visible;width:23%;height:37px;border-radius:0 2px 2px 0;text-transform:uppercase}
    .pw-tip{font-weight:normal;font-size:26px;text-align:center;margin:25px auto}
    #pw-error {color: red;margin-top: 15px;margin-bottom: -20px;}
    .return-home{text-decoration:none;color:#b1b1b1;font-size:16px}
    .return-home:hover{color:#1E9FFF;letter-spacing:5px}
    </style>
</body>
</html>
<?php
			if ($cookiePwd) {
				setcookie('em_logpwd_' . $logid, ' ', time() - 31536000);
			}
            exit;
        } else {
            setcookie('em_logpwd_' . $logid, $logPwd);
        }
    }
}
