
--
-- 表的结构 `wxch_cfg`
--

CREATE TABLE IF NOT EXISTS `wxch_cfg` (
  `cfg_id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `cfg_name` varchar(64) NOT NULL DEFAULT '',
  `cfg_value` varchar(100) NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`cfg_id`),
  UNIQUE KEY `cfg_name` (`cfg_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- 转存表中的数据 `wxch_cfg`
--

INSERT INTO `wxch_cfg` (`cfg_id`, `cfg_name`, `cfg_value`, `autoload`) VALUES
(1, 'murl', '/plus/pinche/', 'yes'),
(2, 'baseurl', 'http://kcd.fjwlxx.com/', 'yes'),
(3, 'imgpath', 'local', 'yes'),
(4, 'plustj', 'true', 'yes'),
(5, 'userpwd', 'ecmoban', 'yes'),
(6, 'cxbd', 'true', 'yes'),
(8, 'oauth', 'true', 'yes'),
(7, 'bd', 'web', 'yes'),
(9, 'goods', 'false', 'yes'),
(10, 'article', 'article.php?id=', 'yes');

-- --------------------------------------------------------

--
-- 表的结构 `wxch_config`
--

CREATE TABLE IF NOT EXISTS `wxch_config` (
  `id` int(1) NOT NULL,
  `token` varchar(100) NOT NULL,
  `appid` char(18) NOT NULL,
  `appsecret` char(32) NOT NULL,
  `access_token` text NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `wxch_config`
--

INSERT INTO `wxch_config` (`id`, `token`, `appid`, `appsecret`, `access_token`, `dateline`) VALUES
(1, '555555555', 'wxddbf3ff444f88c7f', 'efbae5bd02cfb581d38df36576f28b18', 'RqPDeFzD83wByBMDO_YTR8BNIFC3JrXmZ0QOEfpJoCdpp4q8ZMFxIiZiljKlA-7iylvkXTcYPWCj4zmtjeUVVkaXt-0H9DKDB_obvRcSwnM', 1425690229);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_coupon`
--

CREATE TABLE IF NOT EXISTS `wxch_coupon` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `type_id` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- 转存表中的数据 `wxch_coupon`
--

INSERT INTO `wxch_coupon` (`id`, `type_id`) VALUES
(1, 4);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_keywords`
--

CREATE TABLE IF NOT EXISTS `wxch_keywords` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `keyword` varchar(100) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `contents` text NOT NULL,
  `count` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `wxch_keywords1`
--

CREATE TABLE IF NOT EXISTS `wxch_keywords1` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `keyword` varchar(100) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `contents` text NOT NULL,
  `count` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `is_start` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;

--
-- 转存表中的数据 `wxch_keywords1`
--

INSERT INTO `wxch_keywords1` (`id`, `name`, `keyword`, `type`, `contents`, `count`, `status`, `is_start`) VALUES
(14, '关注回复图文', '关注回复图文', 4, '', 2, 1, 0),
(26, '关注回复图文', '关注回复图文', 4, '', 0, 1, 0),
(27, '关注回复文本', '关注回复文本', 3, '欢迎光临 &nbsp;甜心100.做最专业的技术支持和最完善的售后模式！', 31, 1, 1);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_keywords_article`
--

CREATE TABLE IF NOT EXISTS `wxch_keywords_article` (
  `kws_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `article_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`kws_id`,`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `wxch_keywords_article`
--

INSERT INTO `wxch_keywords_article` (`kws_id`, `article_id`) VALUES
(95, 25),
(95, 26),
(95, 27),
(95, 28),
(95, 29),
(95, 30),
(95, 31),
(96, 23),
(96, 24),
(96, 25);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_lang`
--

CREATE TABLE IF NOT EXISTS `wxch_lang` (
  `lang_id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(64) NOT NULL,
  `lang_value` text NOT NULL,
  PRIMARY KEY (`lang_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- 转存表中的数据 `wxch_lang`
--

INSERT INTO `wxch_lang` (`lang_id`, `lang_name`, `lang_value`) VALUES
(1, 'regmsg', '<p>欢迎关注微信公众号</p>'),
(2, 'help', '功能说明：\r\n输入news显示新品\r\n输入hot显示热销\r\n输入best显示推荐\r\n输入bd进入绑定会员流程\r\n输入ddcx查询最后一个订单\r\n输入kdcx查询最后一个订单中的快递\r\n输入ddlb显示多个订单信息\r\n输入help显示帮助说明'),
(3, 'coupon', '欢迎关注微信公众号,您已经领取过优惠卷'),
(4, 'coupon1', '欢迎关注微信公众号,活动期间关注送'),
(5, 'coupon2', '欢迎关注微信公众号,优惠卷已送完'),
(6, 'coupon3', '相关功能'),
(7, 'qdok', '签到成功+'),
(8, 'qdno', '签到数次已用完'),
(9, 'qdstop', '已经关闭了签到'),
(10, 'bd', '快速绑定会员帐号，享受我们提供给你更全面的服务'),
(11, 'prize_egg', '砸金蛋抽奖规则'),
(12, 'prize_dzp', '大转盘抽奖活动说明');

-- --------------------------------------------------------

--
-- 表的结构 `wxch_menu`
--

CREATE TABLE IF NOT EXISTS `wxch_menu` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `menu_type` varchar(6) NOT NULL,
  `level` int(1) NOT NULL,
  `name` varchar(30) NOT NULL,
  `value` varchar(250) NOT NULL,
  `aid` int(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

--
-- 转存表中的数据 `wxch_menu`
--

INSERT INTO `wxch_menu` (`id`, `menu_type`, `level`, `name`, `value`, `aid`) VALUES
(1, 'click', 1, '', '', 0),
(2, 'click', 1, '会员功能', '', 0),
(3, 'click', 1, '更多..', '', 0),
(4, 'click', 2, '', 'hot', 1),
(5, 'click', 2, '', 'best', 1),
(6, 'click', 2, '', 'news', 1),
(7, 'click', 2, '', '', 1),
(8, 'click', 2, '', '', 1),
(9, 'click', 2, '会员绑定', 'bd', 2),
(10, 'click', 2, '重新绑定', 'cxbd', 2),
(11, 'click', 2, '订单查询', 'ddcx', 2),
(12, 'click', 2, '', '', 2),
(13, 'click', 2, '', '', 2),
(14, 'click', 2, '帮忙说明', 'help', 3),
(15, 'click', 2, '订单快递', 'kdcx', 3),
(16, 'click', 2, '菜单回复', 'cdhf', 3),
(17, 'view', 2, '首页', 'http://zhifu.klkwsc.com/wechat/oauth/wxch_oauth.php?oid=1', 3),
(18, 'click', 2, '', '', 3);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_message`
--

CREATE TABLE IF NOT EXISTS `wxch_message` (
  `id` int(9) unsigned NOT NULL AUTO_INCREMENT,
  `wxid` char(28) NOT NULL,
  `w_message` text NOT NULL,
  `message` text NOT NULL,
  `belong` int(9) unsigned NOT NULL,
  `dateline` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `wxid` (`wxid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `wxch_msg`
--

CREATE TABLE IF NOT EXISTS `wxch_msg` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `function` varchar(30) NOT NULL,
  `command` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- 转存表中的数据 `wxch_msg`
--

INSERT INTO `wxch_msg` (`id`, `name`, `function`, `command`) VALUES
(1, '新品', 'news', 'xk 新款 News'),
(2, '精品', 'best', 'Best 精品'),
(3, '热销', 'hot', 'Hot 热销'),
(4, '绑定会员', 'bd', 'BD Bd 绑定会员'),
(5, '重新绑定', 'cxbd', '重新绑定 Cxbd'),
(6, '订单列表', 'ddlb', '订单列表 Ddlb'),
(7, '订单查询', 'ddcx', '订单查询 Ddcx'),
(8, '订单快递', 'kdcx', '订单快递 Kdcx'),
(9, '帮助说明', 'help', '帮助说明 Help 帮助'),
(10, '砸金蛋', 'zjd', '砸金蛋 Zjd'),
(11, '签到', 'qiandao', 'qiandao 签到'),
(12, '大转盘', 'dzp', '大转盘 Dzp');

-- --------------------------------------------------------

--
-- 表的结构 `wxch_oauth`
--

CREATE TABLE IF NOT EXISTS `wxch_oauth` (
  `oid` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contents` text NOT NULL,
  `count` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`oid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- 转存表中的数据 `wxch_oauth`
--

INSERT INTO `wxch_oauth` (`oid`, `name`, `contents`, `count`, `status`) VALUES
(1, '手机版网站首页', 'http://kcd.fjwlxx.com/plus/pinche/', 3929, 1);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_order`
--

CREATE TABLE IF NOT EXISTS `wxch_order` (
  `id` tinyint(1) NOT NULL,
  `order_name` varchar(30) NOT NULL,
  `title` varchar(100) NOT NULL,
  `image` varchar(150) NOT NULL,
  `content` text NOT NULL,
  `autoload` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `wxch_order`
--

INSERT INTO `wxch_order` (`id`, `order_name`, `title`, `image`, `content`, `autoload`) VALUES
(1, 'order', '都旺康体商城感谢您的支持', 'images/201401/1388925596106500893.jpg', '<p>&nbsp;ffffff</p>', 'no'),
(2, 'reorder', '都旺康体商城感谢您的支持', 'images/201503/1425434589678858068.jpg', 'fff', 'no'),
(3, 'pay', '都旺康体商城感谢您的支持', '', '已经成功支付', 'no');

-- --------------------------------------------------------

--
-- 表的结构 `wxch_pay`
--

CREATE TABLE IF NOT EXISTS `wxch_pay` (
  `id` int(1) NOT NULL,
  `appid` char(18) NOT NULL,
  `paysignkey` char(128) NOT NULL,
  `partnerkey` char(32) NOT NULL,
  `appsecret` char(32) NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `wxch_pay`
--

INSERT INTO `wxch_pay` (`id`, `appid`, `paysignkey`, `partnerkey`, `appsecret`, `dateline`) VALUES
(1, '', '', '', '', 0);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_point`
--

CREATE TABLE IF NOT EXISTS `wxch_point` (
  `point_id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `point_name` varchar(64) NOT NULL DEFAULT '',
  `point_value` int(3) unsigned NOT NULL,
  `point_num` int(3) NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`point_id`),
  UNIQUE KEY `option_name` (`point_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- 转存表中的数据 `wxch_point`
--

INSERT INTO `wxch_point` (`point_id`, `point_name`, `point_value`, `point_num`, `autoload`) VALUES
(1, 'news', 5, 2, 'yes'),
(2, 'best', 15, 1, 'yes'),
(3, 'hot', 5, 1, 'yes'),
(4, 'bd', 30, 1, 'yes'),
(5, 'ddcx', 5, 1, 'yes'),
(6, 'kdcx', 5, 1, 'yes'),
(7, 'zjd', 5, 0, 'no'),
(8, 'qiandao', 10, 1, 'yes'),
(9, 'dzp', 10, 1, 'yes'),
(11, 'share_fpoint', 10, 5, 'yes'),
(12, 'share_dfpoint', 10, 1, 'yes');

-- --------------------------------------------------------

--
-- 表的结构 `wxch_point_record`
--

CREATE TABLE IF NOT EXISTS `wxch_point_record` (
  `pr_id` int(7) NOT NULL AUTO_INCREMENT,
  `wxid` char(28) NOT NULL,
  `point_name` varchar(64) NOT NULL,
  `num` int(5) NOT NULL,
  `lasttime` int(10) NOT NULL,
  `datelinie` int(10) NOT NULL,
  PRIMARY KEY (`pr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `wxch_prize`
--

CREATE TABLE IF NOT EXISTS `wxch_prize` (
  `pid` int(4) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `fun` varchar(10) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `num` int(2) unsigned NOT NULL,
  `count` int(8) NOT NULL,
  `loop` int(3) NOT NULL,
  `starttime` int(10) NOT NULL,
  `endtime` int(10) NOT NULL,
  `dateline` int(10) NOT NULL,
  `point` int(10) DEFAULT NULL,
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- 转存表中的数据 `wxch_prize`
--

INSERT INTO `wxch_prize` (`pid`, `title`, `fun`, `status`, `num`, `count`, `loop`, `starttime`, `endtime`, `dateline`, `point`) VALUES
(1, '正在测试的', 'egg', 0, 1, 6, 1, 1394899200, 1397491200, 1395648563, NULL);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_prize_append`
--

CREATE TABLE IF NOT EXISTS `wxch_prize_append` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `prize_id` int(4) unsigned NOT NULL,
  `prize_name` varchar(64) NOT NULL,
  `prize_value` int(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- 转存表中的数据 `wxch_prize_append`
--

INSERT INTO `wxch_prize_append` (`id`, `prize_id`, `prize_name`, `prize_value`) VALUES
(1, 1, '10万汽车1', 1),
(2, 1, 'Macbook2', 2),
(3, 1, 'Ipad3', 3),
(4, 1, '话费100元4', 4),
(5, 1, '优惠卷5', 5),
(6, 1, '未中奖6', 10),
(7, 7, '10万汽车', 1),
(8, 7, 'Macbook', 3),
(9, 7, 'Ipad', 5),
(10, 7, '未中奖', 1000),
(11, 7, '', 0),
(12, 7, '', 0);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_prize_cnum`
--

CREATE TABLE IF NOT EXISTS `wxch_prize_cnum` (
  `pcid` int(5) NOT NULL AUTO_INCREMENT,
  `paid` int(5) NOT NULL,
  `pid` int(4) NOT NULL,
  `prize_name` varchar(64) NOT NULL,
  `prize_value` int(8) unsigned NOT NULL,
  `user_count` int(8) unsigned NOT NULL,
  PRIMARY KEY (`pcid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `wxch_prize_cnum`
--

INSERT INTO `wxch_prize_cnum` (`pcid`, `paid`, `pid`, `prize_name`, `prize_value`, `user_count`) VALUES
(1, 5, 1, '未中奖5', 5, 2),
(2, 10, 7, '未中奖', 1000, 7);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_prize_count`
--

CREATE TABLE IF NOT EXISTS `wxch_prize_count` (
  `cid` int(7) NOT NULL AUTO_INCREMENT,
  `pid` int(5) NOT NULL,
  `wxid` char(28) NOT NULL,
  `num` int(5) NOT NULL,
  `count` int(5) unsigned NOT NULL,
  `lasttime` int(10) unsigned NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  PRIMARY KEY (`cid`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- 转存表中的数据 `wxch_prize_count`
--

INSERT INTO `wxch_prize_count` (`cid`, `pid`, `wxid`, `num`, `count`, `lasttime`, `dateline`) VALUES
(1, 1, 'oo1v-tir7oHXTL42WpwAlNsLTZlc', 0, 5, 1395980256, 1395475456);

-- --------------------------------------------------------

--
-- 表的结构 `wxch_prize_register`
--

CREATE TABLE IF NOT EXISTS `wxch_prize_register` (
  `rid` int(8) NOT NULL AUTO_INCREMENT,
  `pid` int(7) unsigned NOT NULL,
  `wxid` char(28) NOT NULL,
  `nickname` varchar(200) NOT NULL,
  `phone` varchar(12) NOT NULL,
  `name` varchar(100) NOT NULL,
  `dateline` int(10) NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `wxid` (`wxid`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `wxch_prize_users`
--

CREATE TABLE IF NOT EXISTS `wxch_prize_users` (
  `id` int(7) unsigned NOT NULL AUTO_INCREMENT,
  `wxid` char(28) NOT NULL DEFAULT '',
  `fun` varchar(10) NOT NULL,
  `nickname` varchar(200) NOT NULL,
  `prize_id` int(5) DEFAULT NULL,
  `prize_name` varchar(64) DEFAULT NULL,
  `prize_sn` varchar(35) NOT NULL,
  `register` tinyint(1) unsigned NOT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `yn` varchar(3) NOT NULL,
  `dateline` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `prize_id` (`prize_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `wxch_qr`
--

CREATE TABLE IF NOT EXISTS `wxch_qr` (
  `qid` int(7) NOT NULL AUTO_INCREMENT,
  `type` varchar(2) NOT NULL,
  `expire_seconds` int(4) NOT NULL,
  `action_name` varchar(30) NOT NULL,
  `scene_id` int(7) NOT NULL,
  `ticket` varchar(120) NOT NULL,
  `scene` varchar(200) NOT NULL,
  `qr_path` varchar(200) NOT NULL,
  `subscribe` int(8) unsigned NOT NULL,
  `scan` int(8) unsigned NOT NULL,
  `function` varchar(100) NOT NULL,
  `affiliate` int(8) NOT NULL,
  `endtime` int(10) NOT NULL,
  `dateline` int(10) NOT NULL,
  PRIMARY KEY (`qid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `wxch_user`
--

CREATE TABLE IF NOT EXISTS `wxch_user` (
  `uid` int(7) NOT NULL AUTO_INCREMENT,
  `subscribe` tinyint(1) unsigned NOT NULL,
  `wxid` char(28) NOT NULL,
  `nickname` varchar(200) CHARACTER SET gb2312 NOT NULL,
  `sex` tinyint(1) unsigned NOT NULL,
  `city` varchar(100) NOT NULL,
  `country` varchar(100) NOT NULL,
  `province` varchar(100) NOT NULL,
  `language` varchar(50) NOT NULL,
  `headimgurl` varchar(200) NOT NULL,
  `subscribe_time` int(10) unsigned NOT NULL,
  `localimgurl` varchar(200) NOT NULL,
  `setp` smallint(2) unsigned NOT NULL,
  `uname` varchar(50) NOT NULL,
  `coupon` varchar(30) NOT NULL,
  `affiliate` int(8) unsigned NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  `tel` varchar(20) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- 转存表中的数据 `wxch_user`
--

INSERT INTO `wxch_user` (`uid`, `subscribe`, `wxid`, `nickname`, `sex`, `city`, `country`, `province`, `language`, `headimgurl`, `subscribe_time`, `localimgurl`, `setp`, `uname`, `coupon`, `affiliate`, `dateline`, `tel`) VALUES
(3, 0, 'oW22TjhtJW7EdKCky_R8EqA_3EbM', '曾小兵', 1, '梅州', '中国', '', '', 'http://wx.qlogo.cn/mmopen/U754QibibRCibC1q3LVJn2A8sJjZH9ackkoJqpXFkrI4IzRzic0tibMPdcNqaicFqXia7UTah2QouOlmDOGvObVsn8KebUicA2c7t47N/0', 0, '', 0, '', '', 0, 1426843517, '16948949945');

-- --------------------------------------------------------

--
-- 表的结构 `wxch_ver`
--
CREATE TABLE IF NOT EXISTS `ecs_users` (
  `user_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(60) NOT NULL DEFAULT '',
  `user_name` varchar(60) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `question` varchar(255) NOT NULL DEFAULT '',
  `answer` varchar(255) NOT NULL DEFAULT '',
  `sex` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `birthday` date NOT NULL DEFAULT '0000-00-00',
  `user_money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `frozen_money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `pay_points` int(10) unsigned NOT NULL DEFAULT '0',
  `rank_points` int(10) unsigned NOT NULL DEFAULT '0',
  `address_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `reg_time` int(10) unsigned NOT NULL DEFAULT '0',
  `last_login` int(11) unsigned NOT NULL DEFAULT '0',
  `last_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_ip` varchar(15) NOT NULL DEFAULT '',
  `visit_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user_rank` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_special` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ec_salt` varchar(10) DEFAULT NULL,
  `salt` varchar(10) NOT NULL DEFAULT '0',
  `parent_id` mediumint(9) NOT NULL DEFAULT '0',
  `flag` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `alias` varchar(60) NOT NULL,
  `msn` varchar(60) NOT NULL,
  `qq` varchar(20) NOT NULL,
  `office_phone` varchar(20) NOT NULL,
  `home_phone` varchar(20) NOT NULL,
  `mobile_phone` varchar(20) NOT NULL,
  `is_validated` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `credit_line` decimal(10,2) unsigned NOT NULL,
  `passwd_question` varchar(50) DEFAULT NULL,
  `passwd_answer` varchar(255) DEFAULT NULL,
  `wxid` char(28) NOT NULL,
  `wxch_bd` char(2) NOT NULL,
  `aite_id` varchar(40) NOT NULL COMMENT '第三方登陆标识',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_name` (`user_name`),
  KEY `email` (`email`),
  KEY `parent_id` (`parent_id`),
  KEY `flag` (`flag`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=939 ;
CREATE TABLE IF NOT EXISTS `wxch_ver` (
  `vid` tinyint(1) NOT NULL,
  `type` varchar(5) NOT NULL,
  `ver` varchar(8) NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  PRIMARY KEY (`vid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `wxch_ver`
--

INSERT INTO `wxch_ver` (`vid`, `type`, `ver`, `dateline`) VALUES
(1, 'ent', '20140507', 1399362212);