<?php
 namespace Module\ShortLink\Api\Controller; use Illuminate\Routing\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\TimeUtil; use Module\Member\Auth\MemberUser; use Module\Member\Support\MemberLoginCheck; use Module\ShortLink\Util\LinkReportUtil; use Module\ShortLink\Util\LinkUtil; class WorkbenchLinkController extends Controller implements MemberLoginCheck { public function paginate() { $input = InputPackage::buildFromInput(); $page = $input->getPage('page'); $pageSize = $input->getPageSize('pageSize'); $search = $input->getArray('search'); $option = [ 'where' => [ 'memberUserId' => MemberUser::id(), ], 'order' => ['id', 'desc'], ]; if (!empty($search['shortUrl'])) { $id = LinkUtil::parseNumFromUrl($search['shortUrl']); $option['where']['id'] = $id; } if (!empty($search['expire'])) { switch ($search['expire']) { case 'expired': $option['whereRaw'] = "( expire>0 AND expire<" . time() . ")"; break; case 'notExpired': $option['whereRaw'] = "( expire=0 OR expire>" . time() . ")"; break; } } $paginateData = ModelUtil::paginate('link', $page, $pageSize, $option); $records = []; foreach ($paginateData['records'] as $item) { $record = ArrayUtil::keepKeys($item, ['id', 'created_at', 'urlBase', 'url', 'expire', 'title']); $record['_shortUrl'] = LinkUtil::combileLink($item['urlBase'], $item['id']); $record['id'] = "$record[id]"; $record['_status'] = 'notExpired'; if ($record['expire']) { $record['_expire'] = TimeUtil::format($item['expire']); if ($item['expire'] < time()) { $record['_status'] = 'expired'; } } else { $record['_expire'] = null; } $records[] = $record; } return Response::generateSuccessPaginateData($page, $pageSize, $records, $paginateData['total']); } public function edit() { $input = InputPackage::buildFromInput(); $id = $input->getInteger('id'); $data = []; $data['title'] = $input->getTrimString('title'); $data['url'] = $input->getTrimString('url'); $data['expire'] = max(0, strtotime($input->getDatetime('_expire'))); $record = ModelUtil::get('link', ['id' => $id, 'memberUserId' => MemberUser::id()]); BizException::throwsIfEmpty('记录不存在', $record); ModelUtil::update('link', $id, $data); return Response::generateSuccess(); } public function delete() { $input = InputPackage::buildFromInput(); $id = $input->getInteger('id'); $record = ModelUtil::get('link', ['id' => $id, 'memberUserId' => MemberUser::id()]); BizException::throwsIfEmpty('记录不存在', $record); LinkUtil::delete($id); return Response::generateSuccess(); } public function report() { $input = InputPackage::buildFromInput(); $input = $input->getAsInput('search'); $shortUrl = $input->getTrimString('shortUrl'); if (empty($shortUrl)) { return Response::generateError('请输入短链接'); } $id = LinkUtil::parseNumFromUrl($shortUrl); if (!$id) { return Response::generateError('解析短链接失败'); } $record = ModelUtil::get('link', ['id' => $id, 'memberUserId' => MemberUser::id()]); BizException::throwsIfEmpty('记录不存在', $record); $link = ArrayUtil::keepKeys($record, ['id', 'created_at', 'urlBase', 'url', 'expire', 'title']); $link['_shortUrl'] = LinkUtil::combileLink($record['urlBase'], $record['id']); $day = date('Y-m-d'); if (!empty($search['day']) && !TimeUtil::isDateEmpty($search['day'])) { $day = $search['day']; } $report = LinkReportUtil::get($link['id'], $day, $day); return Response::generateSuccessData([ 'link' => $link, 'day' => date('Y-m-d', strtotime($report['from'])), 'reports' => $report['reports'], ]); } }