import Vue from 'vue'
import Vuex from 'vuex'
import config from './store/config'
import app from './store/app'
import currentRobot from './store/currentRobot'

Vue.use(Vuex)

const store = new Vuex.Store({
    modules: {
        app,
        config,
        currentRobot,
    },
    getters: {
        config: state => state.config,
        app: state => state.app,
        currentRobot: state => state.currentRobot,
    }
})

export default store
