<?php
function PageMain() {
	global $TMPL,$conf;
	

	// Put the "a" into a template as default option when user doesn't select the search type 
	$TMPL['search'] = $_GET['a'];
	$TMPL['query'] = $_GET['q'];

	$query = $_GET['q'];
	if(empty($_GET['q'])) {
		header('Location: '.$conf['url'].'/');
	}
			
		
	// Query bing, get the content & decode the json	
	$page = $_GET['page'];
	if(!isset($page) || empty($page) || $page < 0) {
		$page = 0;
	} elseif($page > 1000) {
		$page = 1000;
	}
	$per_page = 10;

	$request = $conf['base_url'].'/query.php?per_page='.$per_page.'&page='.$page.'&q='.str_replace(' ', '%20', $query);		
	$response = file_get_contents($request);
	$jsonobj = json_decode($response);

	// The results number with the page specified
	if(!isset($page) || $page == 0 || $page < 0) {
		$TMPL['resNumber'] = '<strong>'.$query.'</strong>&nbsp;的搜索结果';
	} else {
		$TMPL['resNumber'] = '<strong>'.$query.'</strong>&nbsp; 的搜索结果 (记录 '.ceil(($page+10)/10).')';
	}
	
	$TMPL_old = $TMPL; $TMPL = array();
	
	// Start the Results template
	$skin = new skin('web/rows'); $all = '';

	foreach($jsonobj->d->results as $value) {
		$title = '<a href="'.$value->Url.'" target="'.$_COOKIE['link'].'">'.$value->Title.'</a> '; 
		$TMPL['title'] = highlightKeyword($title);
		$TMPL['url'] = highlightKeyword($value->DisplayUrl);
		$TMPL['desc'] = highlightKeyword($value->Description);
		
		// More from...
		$find   = 'site:';
		$more = strpos($_GET['q'], $find);
		if($more === false) {
			$hostUrl = parse_url($value->Url);
			$TMPL['more'] = '<a href="'.$conf['url'].'/?a='.$_GET['a'].'&q='.$query.' site:'.$hostUrl['host'].'">more from '.$hostUrl['host'].'</a>';
		}
		$domain = parse_url($value->Url);
		$TMPL['url_d'] = 'http://'.$domain['host'];
		$all .= $skin->make();
	}
	
	// Start the pagination template
	$skin = new skin('shared/pagination'); $pagination = '';
	
	// First
	if($page == 0) {
		$TMPL['first'] = '<div class="first_i"></div>';
	} else {
		$TMPL['first'] = '<div class="first_a"><a href="'.$conf['url'].'/?a='.$_GET['a'].'&q='.$query.'&page=0"><div class="btn"></div></a></div>';
	}
	
	// Prev
	if($page < 10) {
		$TMPL['prev'] = '<div class="prev_i"></div>';
	} else {
		$TMPL['prev'] = '<div class="prev_a"><a href="'.$conf['url'].'/?a='.$_GET['a'].'&q='.$query.'&page='.($page-10).'"><div class="btn"></div></a></div>';
	}
	
	// Next
	$TMPL['next'] = '<div class="next_a"><a href="'.$conf['url'].'/?a='.$_GET['a'].'&q='.$query.'&page='.($page+10).'"><div class="btn"></div></a></div>';
		
	$pagination .= $skin->make();
	
	$TMPL = $TMPL_old; unset($TMPL_old);
	$TMPL['url'] = $conf['url'];
	$TMPL['rows'] = $all;
	$TMPL['title'] = $_GET['q'].' - '.$conf['title'];
	$TMPL['pagination'] = $pagination;
	
	$TMPL['results'] = 'results_web';

	$skin = new skin('shared/content');
	return $skin->make();
}
?>