<?php
/**
 * PHP SDK for QQ登录 OpenAPI
 *
 * @version 1.5
 * @author connect@qq.com
 * @copyright © 2011, Tencent Corporation. All rights reserved.
 */
require_once("../../conn.php");
require_once("../comm/utils.php");
require_once("../../include/function.php");

/**
 * @brief 获取access_token。请求需经过URL编码，编码时请遵循 RFC 1738
 *
 * @param $appid
 * @param $appkey
 * @param $request_token
 * @param $request_token_secret
 * @param $vericode
 *
 * @return 返回字符串格式为：oauth_token=xxx&oauth_token_secret=xxx&openid=xxx&oauth_signature=xxx&oauth_vericode=xxx&timestamp=xxx
 */

function get_access_token($appid, $appkey, $request_token, $request_token_secret, $vericode)
{
    global $global_arg;
    //请求具有Qzone访问权限的access_token的接口地址, 不要更改!!
    $url    = "http://openapi.qzone.qq.com/oauth/qzoneoauth_access_token?";
   
    //生成oauth_signature签名值。签名值生成方法详见（http://wiki.opensns.qq.com/wiki/【QQ登录】签名参数oauth_signature的说明）
    //（1） 构造生成签名值的源串（HTTP请求方式 & urlencode(uri) & urlencode(a=x&b=y&...)）
	$sigstr = "GET"."&".QQConnect_urlencode("http://openapi.qzone.qq.com/oauth/qzoneoauth_access_token")."&";

    //必要参数，不要随便更改!!
    $params = array();
    $params["oauth_version"]          = "1.0";
    $params["oauth_signature_method"] = "HMAC-SHA1";
    $params["oauth_timestamp"]        = time();
    $params["oauth_nonce"]            = mt_rand();
    $params["oauth_consumer_key"]     = $appid;
    $params["oauth_token"]            = $request_token;
    $params["oauth_vericode"]         = $vericode;

    //对参数按照字母升序做序列化
    $normalized_str = get_normalized_string($params);
    $sigstr        .= QQConnect_urlencode($normalized_str);

    //echo "sigstr = $sigstr";

	//（2）构造密钥
    $key = $appkey."&".$request_token_secret;

	//（3）生成oauth_signature签名值。这里需要确保PHP版本支持hash_hmac函数
    $signature = get_signature($sigstr, $key);
    
	
	//构造请求url
    $url      .= $normalized_str."&"."oauth_signature=".QQConnect_urlencode($signature);

    $global_arg = $url;
    return file_get_contents($url);
}


/**
 * Tips：
 * QQ互联登录，授权成功后会回调注册的callback地址
 * 必须要用授权的request token换取access token
 * 访问QQ互联的任何资源都需要access token
 * 目前access token是长期有效的，除非用户解除与第三方绑定
 * 如果第三方发现access token失效，请引导用户重新登录QQ互联，授权，获取access token
 */

global $global_arg;
//用户使用QQ登录，并授权成功后，会返回用户的openid。此时需要检查返回的openid是否是合法id
//我们不建议开发者使用该openid，而是使用获取access token之后返回的openid。
if (!is_valid_openid($_REQUEST["openid"], $_REQUEST["timestamp"], $_REQUEST["oauth_signature"]))
{
    //demo对错误简单处理
    ShowMsg('对不起运行出错，请重新登陆!','/index.php');
    exit;
}

//tips
//这里已经获取到了openid，可以处理第三方账户与openid的绑定逻辑。
//但是我们建议第三方等到获取access token之后在做绑定逻辑

//用授权的request token换取access token
$access_str = get_access_token($_SESSION["appid"], $_SESSION["appkey"], $_REQUEST["oauth_token"], $_SESSION["secret"], $_REQUEST["oauth_vericode"]);

//错误处理 QQ登陆出错提示
if (strpos($access_str, "error_code") !== false)
{
	ShowMsg('登陆错误，请重新登陆!','/QQAPI/oauth/redirect_to_login.php');
    exit;
}

//解析返回参数
$result = array();
parse_str($access_str, $result);

$_SESSION["oauth_token"]   = $result["oauth_token"];
$_SESSION["oauth_token_secret"]  = $result["oauth_token_secret"]; 
$_SESSION["openid"]  = $result["openid"];
//登陆成功\本站注册会员
//查找会员是否已绑定
$ouserQuery = mysql_query("select * from adminso_user where openid = '{$_SESSION['openid']}'");
$ouserNum = mysql_num_rows($ouserQuery);
if($ouserNum==0){//未绑定
	
	$exec="UPDATE adminso_user SET openid = '{$_SESSION['openid']}' where user_id='{$_SESSION['Suser_id']}'";
	if(mysql_query($exec)){
		ShowMsg('恭喜您绑定成功，马上帮您返回会员中心!', '/account.php');
		exit;
	}else{
		ShowMsg('对不起帐户绑定出错，请返回重新绑定QQ!', 'bang.php');
		exit;
	}
	 
}else{
	ShowMsg('对不起此QQ号码已被其他帐户绑定，请返回重新绑定QQ!', 'bang.php');
	exit;
}
//结束 登陆成功\本站注册会员

//第三方处理用户绑定逻辑
//将openid与第三方的帐号做关联
//bind_to_openid();


 /*
 * @brief 获取用户信息.请求需经过URL编码，编码时请遵循 RFC 1738
 * 
 * @param $appid
 * @param $appkey
 * @param $access_token
 * @param $access_token_secret
 * @param $openid
 *
 */
function get_user_info($appid, $appkey, $access_token, $access_token_secret, $openid)
{
	//获取用户信息的接口地址, 不要更改!!
    $url    = "http://openapi.qzone.qq.com/user/get_user_info";
    $info   = do_get($url, $appid, $appkey, $access_token, $access_token_secret, $openid);
    $arr = array();
    $arr = json_decode($info, true);

    return $arr;
}
?>
