DROP TABLE IF EXISTS ylmf_admin_user;
CREATE TABLE ylmf_admin_user (
  `name` varchar(32) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  `level` int(1) NOT NULL default '0',
  adminright text,
  lastvisit int(11) NOT NULL default '0',
  lastip varchar(15) NOT NULL default '',
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_advert;
CREATE TABLE ylmf_advert (
  id int(10) unsigned NOT NULL auto_increment,
  targets varchar(50) NOT NULL default '',
  varname varchar(20) NOT NULL default '',
  state tinyint(1) NOT NULL default '0',
  vieworder tinyint(4) default '0',
  title varchar(255) NOT NULL default '',
  config mediumtext NOT NULL,
  `day` int(11) NOT NULL,
  `week` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  total int(11) NOT NULL,
  PRIMARY KEY  (id),
  KEY vieworder (vieworder),
  KEY state (state)
) ENGINE=MyISAM AUTO_INCREMENT=269 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_city_cityclass;
CREATE TABLE ylmf_city_cityclass (
  id int(15) NOT NULL auto_increment,
  `name` char(20) default NULL,
  keywords varchar(200) NOT NULL,
  description varchar(200) NOT NULL,
  displayorder int(11) NOT NULL default '100',
  sitenum int(11) NOT NULL default '0',
  path varchar(255) NOT NULL,
  template varchar(50) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_city_coolclass;
CREATE TABLE ylmf_city_coolclass (
  id int(15) NOT NULL auto_increment,
  `name` char(20) default NULL,
  keywords varchar(200) NOT NULL,
  description varchar(200) NOT NULL,
  displayorder int(11) NOT NULL default '100',
  sitenum int(11) NOT NULL default '0',
  path varchar(255) NOT NULL,
  template varchar(50) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_city_coolsite;
CREATE TABLE ylmf_city_coolsite (
  id int(11) NOT NULL auto_increment,
  `name` char(255) NOT NULL default '',
  url text NOT NULL,
  cityclass_id int(11) NOT NULL default '0',
  coolclass_id int(11) NOT NULL,
  displayorder int(11) NOT NULL default '100',
  starttime int(10) NOT NULL,
  endtime int(10) NOT NULL,
  namecolor char(7) NOT NULL,
  remark text NOT NULL,
  PRIMARY KEY  (id),
  KEY class (cityclass_id)
) ENGINE=MyISAM AUTO_INCREMENT=267 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_city_id_name;
CREATE TABLE ylmf_city_id_name (
  id int(11) NOT NULL auto_increment,
  city_id int(10) NOT NULL,
  city_name varchar(50) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=2513 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_city_mingzhan;
CREATE TABLE ylmf_city_mingzhan (
  id int(11) NOT NULL auto_increment,
  `name` char(255) NOT NULL default '',
  url text NOT NULL,
  cityclass_id int(11) NOT NULL default '0',
  displayorder int(11) NOT NULL default '100',
  starttime int(10) NOT NULL,
  endtime int(10) NOT NULL,
  namecolor char(7) NOT NULL,
  inindex tinyint(1) NOT NULL default '1',
  remark text NOT NULL,
  PRIMARY KEY  (id),
  KEY class (cityclass_id)
) ENGINE=MyISAM AUTO_INCREMENT=107 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_cknum;
CREATE TABLE ylmf_cknum (
  sid varchar(8) NOT NULL default '',
  nmsg varchar(4) NOT NULL default '',
  `time` int(10) NOT NULL default '0',
  PRIMARY KEY  (sid)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_class;
CREATE TABLE ylmf_class (
  classid int(15) NOT NULL auto_increment,
  parentid int(15) NOT NULL default '0',
  classname char(20) default NULL,
  keywords varchar(200) NOT NULL,
  description varchar(200) NOT NULL,
  displayorder int(11) NOT NULL default '100',
  sitenum int(11) NOT NULL default '0',
  path varchar(255) NOT NULL,
  template varchar(50) NOT NULL,
  PRIMARY KEY  (classid)
) ENGINE=MyISAM AUTO_INCREMENT=2323 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_config;
CREATE TABLE ylmf_config (
  yl_name varchar(30) NOT NULL default '',
  yl_value text NOT NULL,
  PRIMARY KEY  (yl_name)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_coolclass;
CREATE TABLE ylmf_coolclass (
  classid int(15) NOT NULL auto_increment,
  classname char(20) default NULL,
  displayorder int(11) NOT NULL default '100',
  sitenum int(11) NOT NULL default '0',
  path varchar(255) NOT NULL,
  PRIMARY KEY  (classid)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_coolsite;
CREATE TABLE ylmf_coolsite (
  id int(11) NOT NULL auto_increment,
  `name` char(255) NOT NULL default '',
  url text NOT NULL,
  class int(11) NOT NULL default '0',
  displayorder int(11) NOT NULL default '100',
  good tinyint(1) NOT NULL default '0',
  `day` int(11) NOT NULL,
  `week` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  total int(11) NOT NULL,
  namecolor char(7) NOT NULL,
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  starttime int(11) NOT NULL default '0',
  endtime int(11) NOT NULL default '0',
  remark text NOT NULL,
  `end` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY starttime (starttime),
  KEY endtime (endtime)
) ENGINE=MyISAM AUTO_INCREMENT=241 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_feedback;
CREATE TABLE ylmf_feedback (
  fid int(10) unsigned NOT NULL auto_increment,
  username varchar(20) NOT NULL default '',
  email varchar(30) NOT NULL default '',
  content text NOT NULL,
  add_time int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (fid)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_index_tool;
CREATE TABLE ylmf_index_tool (
  id int(11) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  url varchar(255) NOT NULL,
  `order` int(3) NOT NULL,
  color varchar(10) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_ipstates;
CREATE TABLE ylmf_ipstates (
  `day` char(10) NOT NULL default '',
  `month` char(7) NOT NULL default '',
  nums int(10) NOT NULL default '0',
  isp_dx int(11) NOT NULL default '0',
  isp_wt int(11) NOT NULL default '0',
  qvod int(11) NOT NULL default '0',
  PRIMARY KEY  (`day`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_keyword;
CREATE TABLE ylmf_keyword (
  id int(11) NOT NULL auto_increment,
  class int(11) default '0',
  `name` varchar(10) NOT NULL default '',
  url char(255) NOT NULL default '',
  namecolor char(7) default NULL,
  displayorder int(11) NOT NULL default '0',
  `day` int(11) default '0',
  `week` int(11) default '0',
  `month` int(11) default '0',
  total int(11) default '0',
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY classid (class)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_links;
CREATE TABLE ylmf_links (
  id int(4) unsigned NOT NULL auto_increment,
  is_show smallint(1) NOT NULL default '1',
  sort int(4) NOT NULL,
  site_name varchar(50) NOT NULL,
  site_url text NOT NULL,
  add_time int(10) NOT NULL,
  remarks varchar(200) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_mingzhan;
CREATE TABLE ylmf_mingzhan (
  id int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  url varchar(255) NOT NULL,
  namecolor char(7) NOT NULL,
  displayorder mediumint(8) NOT NULL,
  starttime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  remark text NOT NULL COMMENT '???',
  `day` int(11) NOT NULL default '0',
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  `week` int(11) NOT NULL default '0',
  `month` int(11) NOT NULL default '0',
  total int(11) NOT NULL default '0',
  `end` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY `name` (`name`),
  KEY starttime (starttime),
  KEY endtime (endtime)
) ENGINE=MyISAM AUTO_INCREMENT=68 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_plan;
CREATE TABLE ylmf_plan (
  id smallint(6) unsigned NOT NULL auto_increment,
  `subject` varchar(80) NOT NULL default '',
  `month` char(2) NOT NULL default '',
  `week` char(1) NOT NULL default '',
  `day` char(2) NOT NULL default '',
  `hour` varchar(80) NOT NULL default '',
  usetime int(10) NOT NULL default '0',
  nexttime int(10) NOT NULL default '0',
  ifsave tinyint(1) NOT NULL default '0',
  ifopen tinyint(1) NOT NULL default '0',
  filename varchar(80) NOT NULL default '',
  config text NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_recycler;
CREATE TABLE ylmf_recycler (
  id int(11) NOT NULL auto_increment,
  table_name enum('ylmf_site','ylmf_indexsite') NOT NULL,
  sitename varchar(100) NOT NULL default '',
  siteurl varchar(250) NOT NULL default '',
  oldclass int(11) NOT NULL default '0',
  namecolor char(7) default NULL,
  adduser varchar(25) default NULL,
  displayorder int(11) NOT NULL default '100',
  good tinyint(1) NOT NULL default '0',
  gooddisplayorder int(11) NOT NULL default '0',
  good2 tinyint(1) NOT NULL default '0',
  remark text NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_search;
CREATE TABLE ylmf_search (
  id int(11) NOT NULL auto_increment,
  class int(11) NOT NULL,
  search_select char(20) default NULL,
  `action` text,
  `name` char(50) default NULL,
  btn char(50) default NULL,
  img_text varchar(50) default NULL,
  img_url text,
  url text,
  params text,
  sort int(11) NOT NULL default '100',
  is_show int(1) NOT NULL default '1',
  is_default int(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_search_keyword;
CREATE TABLE ylmf_search_keyword (
  id int(11) NOT NULL auto_increment,
  class int(11) default '0',
  `name` varchar(10) NOT NULL default '',
  url text NOT NULL,
  namecolor char(7) default NULL,
  sort int(11) NOT NULL default '0',
  `day` int(11) default '0',
  `week` int(11) default '0',
  `month` int(11) default '0',
  total int(11) default '0',
  starttime int(11) NOT NULL default '0',
  endtime int(11) NOT NULL default '0',
  remarks text NOT NULL,
  PRIMARY KEY  (id),
  KEY classid (class)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_searchclass;
CREATE TABLE ylmf_searchclass (
  classid int(15) NOT NULL auto_increment,
  classname char(20) default NULL,
  sort int(11) NOT NULL default '100',
  is_default int(1) NOT NULL default '0',
  PRIMARY KEY  (classid)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_site;
CREATE TABLE ylmf_site (
  id int(11) NOT NULL auto_increment,
  `name` char(255) NOT NULL default '',
  url text NOT NULL,
  class int(11) NOT NULL default '0',
  displayorder int(11) NOT NULL default '100',
  good tinyint(1) NOT NULL default '0',
  good2 tinyint(1) NOT NULL default '0',
  `day` int(11) default '0',
  `week` int(11) default '0',
  `month` int(11) default '0',
  total int(11) default '0',
  gooddisplayorder mediumint(8) NOT NULL default '0',
  namecolor char(7) NOT NULL,
  adduser varchar(25) NOT NULL,
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  starttime int(11) NOT NULL default '0',
  endtime int(11) NOT NULL default '0',
  remark text NOT NULL,
  `end` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY class (class),
  KEY starttime (starttime),
  KEY endtime (endtime)
) ENGINE=MyISAM AUTO_INCREMENT=41836 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_site_search;
CREATE TABLE ylmf_site_search (
  id int(11) NOT NULL,
  displayorder int(11) NOT NULL,
  pinyin varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  url text NOT NULL,
  PRIMARY KEY  (id),
  KEY displayorder (displayorder)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_urladd;
CREATE TABLE ylmf_urladd (
  id int(11) NOT NULL auto_increment,
  domain varchar(250) default '',
  info text,
  addtime int(11) default NULL,
  `type` tinyint(2) default '0',
  shenhe text NOT NULL,
  PRIMARY KEY  (id),
  KEY domain (domain)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_zhuanti;
CREATE TABLE ylmf_zhuanti (
  id int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  displayorder int(11) NOT NULL default '100',
  inindex tinyint(1) NOT NULL default '1',
  path varchar(255) NOT NULL,
  template varchar(50) NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_zhuanticlass;
CREATE TABLE ylmf_zhuanticlass (
  id int(11) NOT NULL auto_increment,
  zhuanti int(11) NOT NULL,
  `name` varchar(255) NOT NULL default '',
  displayorder int(11) NOT NULL default '100',
  inindex tinyint(1) NOT NULL default '0',
  url varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=126 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

DROP TABLE IF EXISTS ylmf_zhuantisite;
CREATE TABLE ylmf_zhuantisite (
  id int(11) NOT NULL auto_increment,
  class int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  url text,
  displayorder int(11) NOT NULL default '100',
  inindex tinyint(1) NOT NULL default '0',
  `day` int(11) default '0',
  `week` int(11) default '0',
  `month` int(11) default '0',
  total int(11) default '0',
  indexdisplayorder mediumint(8) NOT NULL default '0',
  yesterday int(11) NOT NULL default '0',
  byesterday int(11) NOT NULL default '0',
  starttime int(11) NOT NULL default '0',
  endtime int(11) NOT NULL default '0',
  remark text NOT NULL,
  `end` tinyint(1) NOT NULL default '0',
  namecolor char(7) NOT NULL,
  PRIMARY KEY  (id),
  KEY starttime (starttime),
  KEY endtime (endtime)
) ENGINE=MyISAM AUTO_INCREMENT=2876 DEFAULT CHARSET=gbk COLLATE=gbk_chinese_ci;

INSERT INTO ylmf_advert VALUES('255','','notice','1','5','','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:6:\"\";s:4:\"link\";s:102:\"http://www.taobao.com/go/chn/tbk_channel/celebrate.php?pid=mm_14033530_3168968_10539947&eventid=102225\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('225','','notice','1','1','ԱŮװ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"ԱŮװ\";s:4:\"link\";s:97:\"http://www.taobao.com/go/chn/tbk_channel/lady.php?pid=mm_14033530_3168968_10472325&eventid=101345\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('226','','notice','1','2','Աʹڵ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:10:\"Աʹڵ\";s:4:\"link\";s:102:\"http://www.taobao.com/go/chn/tbk_channel/huangguan.php?pid=mm_14033530_3168968_10472318&eventid=101858\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('241','','footer','1','7','1ŵ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:5:\"1ŵ\";s:4:\"link\";s:137:\"http://s.click.taobao.com/t_11?e=%2BtSC5ziSlHPn2KeJMhhJbsldWfV6oeO4H5ymIt%2FCkol6sjcJDrF11IBQVx%2B2TRc%3D&p=mm_14033530_3168968_10540104 \";s:5:\"color\";s:7:\"#008000\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('218','','footer','1','8','','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"\";s:4:\"link\";s:25:\"html/yinyue_mp3/index.htm\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('217','','footer','1','7','Ů','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:10:\"Ů\";s:4:\"link\";s:133:\"http://s.click.taobao.com/t_11?e=%2BtSC5ziSlQIE1xt%2BRglAo8sjIyt9m1kh%2BwgjguNIaWECnwUtKW48e%2BB535Bj&p=mm_14033530_3168968_10540104 \";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('216','','footer','1','6','̩ٻ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"̩ٻ\";s:4:\"link\";s:133:\"http://s.click.taobao.com/t_11?e=%2BtSC5ziSlQIFtEiJFzEZDed0a0spoMoFZUpqf9yL%2BhE59wK%2FBNnlwA49wvY%3D&p=mm_14033530_3168968_10540104 \";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('214','','footer','1','4','͹','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:10:\"͹\";s:4:\"link\";s:125:\"http://s.click.taobao.com/t_11?e=%2BtSC5ziSlQIL8RMJ9xxFGJU4nnKDz4RcF28xF3%2BFriUzkoMHR4gQbNgd&p=mm_14033530_3168968_10540104 \";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('213','','footer','1','3','һƷ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"һƷ\";s:4:\"link\";s:33:\"http://www.gzkoo.cn/sort/caipiao/\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('212','','footer','1','2','ͳƷ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"ͳƷ\";s:4:\"link\";s:131:\"http://s.click.taobao.com/t_11?e=%2BtSC5ziSlQIKXTum23VHLUx2Mi9BvFxTCg7CN9kKD8HJdox0eUoImgi5Ng%3D%3D&p=mm_14033530_3168968_10540104 \";s:5:\"color\";s:7:\"#008000\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('211','','footer','1','1','ؼЬ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:10:\"ؼЬ\";s:4:\"link\";s:133:\"http://s.click.taobao.com/t_11?e=%2BtSC5ziSlHPh5IRqu2tnFzbOh3t70VPrOX0Q2fqB0S7UJ7xsmiXizofWXgd68dI%3D&p=mm_14033530_3168968_10540104 \";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('265','','header','1','1','1','a:4:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:4:\"code\";s:8:\"htmlcode\";s:240:\"<a href=\"http://s.click.taobao.com/t_9?p=mm_10236639_2136876_9493010&l=http%3A%2F%2Fmall.taobao.com%2F&eventid=101766\" target=\"_blank\"><img src=\"themes/hao123/images/taobao.gif\" width=\"240\" height=\"60\" border=\"0\" style=\"display:block;\"></a>\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('253','','notice','1','3','Աֻ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"Աֻ\";s:4:\"link\";s:98:\"http://s.click.taobao.com/t_9?p=mm_14033530_0_0&l=http%3A%2F%2Fdianqi.tmall.com%2Fpage%2Fphone.htm\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('254','','notice','1','6','ۺƵ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"ۺƵ\";s:4:\"link\";s:104:\"http://www.taobao.com/go/chn/tbk_channel/channelcode.php?pid=mm_14033530_3168968_10472364&eventid=101329\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('256','','notice','1','6','','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"\";s:4:\"link\";s:99:\"http://www.taobao.com/go/chn/tbk_channel/beauty.php?pid=mm_14033530_3168968_10472356&eventid=101328\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('257','','notice','1','8','ĸӤ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:4:\"ĸӤ\";s:4:\"link\";s:98:\"http://www.taobao.com/go/chn/tbk_channel/child.php?pid=mm_14033530_3168968_10472297&eventid=102185\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('258','','notice','1','7','زС','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"زС\";s:4:\"link\";s:97:\"http://www.taobao.com/go/chn/tbk_channel/food.php?pid=mm_14033530_3168968_10472308&eventid=101865\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('263','','notice','1','0','Աװ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"Աװ\";s:4:\"link\";s:96:\"http://www.taobao.com/go/chn/tbk_channel/man.php?pid=mm_14033530_3168968_10472347&eventid=101330\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('264','','notice','1','4','ƷЬ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:8:\"ƷЬ\";s:4:\"link\";s:100:\"http://www.taobao.com/go/chn/tbk_channel/jewelry.php?pid=mm_14033530_3168968_10539984&eventid=101331\";s:5:\"color\";s:0:\"\";}','0','0','0','0');
INSERT INTO ylmf_advert VALUES('269','','notice','1','9','Աۻ','a:6:{s:9:\"starttime\";s:0:\"\";s:7:\"endtime\";s:0:\"\";s:5:\"style\";s:3:\"txt\";s:5:\"title\";s:6:\"ۻ\";s:4:\"link\";s:97:\"http://www.taobao.com/go/chn/tbk_channel/jkwt.php?pid=mm_14033530_3168968_10472144&eventid=102405\";s:5:\"color\";s:0:\"\";}','0','0','0','0');

INSERT INTO ylmf_city_cityclass VALUES('1','Ϻ','','','2','0','shanghai','');
INSERT INTO ylmf_city_cityclass VALUES('3','','','','3','0','guagnzhou','');
INSERT INTO ylmf_city_cityclass VALUES('5','','','','4','0','shenzhen','');
INSERT INTO ylmf_city_cityclass VALUES('10','','','','1','0','beijing','');

INSERT INTO ylmf_city_coolclass VALUES('1','','','','1','0','','');
INSERT INTO ylmf_city_coolclass VALUES('2','̳','','','2','0','','');
INSERT INTO ylmf_city_coolclass VALUES('3','','','','3','0','','');
INSERT INTO ylmf_city_coolclass VALUES('4','ʳ','','','4','0','','');
INSERT INTO ylmf_city_coolclass VALUES('6','','','','5','0','','');
INSERT INTO ylmf_city_coolclass VALUES('10','','','','7','0','','');
INSERT INTO ylmf_city_coolclass VALUES('9','ҽԺ','','','6','0','','');
INSERT INTO ylmf_city_coolclass VALUES('11','','','','13','0','','');
INSERT INTO ylmf_city_coolclass VALUES('12','','','','8','0','','');
INSERT INTO ylmf_city_coolclass VALUES('13','ѧУ','','','9','0','','');
INSERT INTO ylmf_city_coolclass VALUES('14','ͨ','','','10','0','','');
INSERT INTO ylmf_city_coolclass VALUES('15','','','','11','0','','');
INSERT INTO ylmf_city_coolclass VALUES('16','','','','12','0','','');

INSERT INTO ylmf_city_coolsite VALUES('8','','http://sh.eastday.com/','1','1','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('6','Ϻ','http://www.sh.chinanews.com.cn/','1','1','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('7','Ű칫','http://www.shio.gov.cn/','1','1','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('9','Ϻ','http://sh.sina.com.cn/news/','1','1','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('10','»Ϻ','http://www.sh.xinhuanet.com/','1','1','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('11','Ϻ̳','http://bbs.online.sh.cn/','1','2','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('12','ɽ','http://club.pchome.net/forum_1_15.html','1','2','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('13','ᰮϺ̳','http://bbs.kooaoo.com/','1','2','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('14','ϻ̳','http://bbs.52life.cc/','1','2','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('15','׳','http://www.sj.net.cn/','1','2','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('16','Ϻ̨','http://www.smg.cn/','1','3','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('17','ʿ','http://www.dragontv.cn/','1','3','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('18','Ϻ̨','http://www.bbtv.cn/','1','3','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('19','̨','http://www.setv.sh.cn/','1','3','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('20','Sitv','http://www.sitv.com.cn/','1','3','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('21','ڱ','http://shanghai.koubei.com/cate','1','4','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('22','ʳ','http://shanghaimeishi.abang.com/','1','4','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('23','ͳ','http://shanghai.fantong.com/','1','4','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('24','ڵ','http://www.dianping.com/shanghai/food','1','4','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('25','POCOϺʳ','http://sh.food.poco.cn/','1','4','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('26','һŵ','http://s.click.taobao.com/t_11?e=%2BtSC5ziSlHPn2KeJMhhJbsldWfV6oeO4H5ymIt%2FCkol6sjcJDrF11IBQVx%2B2TRc%3D&p=mm_14033530_3168968_10479839
','1','6','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('27','CJ','http://www.ocj.com.cn/','1','6','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('28','','http://www.lashou.com/guangzhou','1','6','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('29','̳','http://p.yiqifa.com/c?s=dc1c5515&w=148281&c=4509&i=5862&l=0&e=mz&t=http://www.360buy.com','1','6','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('30','','http://www.womai.com/','1','6','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('31','ҽԺ','http://www.hqhospital.cn/','1','9','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('32','ɽҽԺ','http://www.huashan.org.cn/','1','9','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('33','ʼҽԺ','http://www.renji.com/','1','9','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('34','ϺжͯҽԺ','http://www.shchildren.com.cn/','1','9','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('35','ϺɽҽԺ','http://www.zs-hospital.sh.cn/','1','9','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('36','Ϻ','http://www.bankofshanghai.com/','1','10','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('37','Ϻַ','http://www.spdb.com.cn/','1','10','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('38','Ϻũ','http://www.srcb.com/','1','10','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('39','','http://www.ccb.com/','1','10','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('40','','http://www.cmbchina.com/','1','10','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('41','Ϻ','http://www.shanghai.gov.cn/','1','11','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('42','й','http://www.police.sh.cn/','1','11','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('43','Э','http://shszx.eastday.com/','1','11','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('44','','http://mzj.sh.gov.cn/','1','11','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('45','в','http://www.csj.sh.gov.cn/gb/csj/index.html','1','11','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('46','Ϻ','http://www.shanghaitour.net/','1','15','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('47','','http://www.expo.cn/','1','15','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('48','Ϻ','http://www.shanghaimuseum.net/','1','15','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('49','Ϻ','http://www.ssc.sh.cn/','1','15','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('50','ϺƼ','http://www.sstm.org.cn/','1','15','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('51','Ϻ','http://www.shmetro.com/','1','14','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('52','Ϻ','http://www.shanghaibus.net/','1','14','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('53','Ϻ','http://www.shanghaiairport.com/','1','14','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('54','Ϻվ','http://www.shhcz.com.cn/','1','14','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('55',';վ','http://www.ctnz.net/','1','14','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('56','ѧ','http://www.fudan.edu.cn/','1','13','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('57','ͬôѧ','http://www.tongji.edu.cn/','1','13','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('58','Ϻͨѧ','http://www.sjtu.edu.cn/','1','13','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('59','ѧ','http://www.ecust.edu.cn/','1','13','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('60','Ϻƾѧ','http://www.shufe.edu.cn/','1','13','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('61','Ϻ˲','http://www.dshrc.com/','1','12','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('62','Ϻ˲','http://www.shanghairc.com/','1','12','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('63','ϺƸ','http://www.shjob.cn/','1','12','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('64','','http://www.sc.sh.cn/','1','12','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('65','Ϻҵ','http://www.sh91.com/','1','12','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('66','¬','http://www.luwan.sh.cn/','1','16','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('67','','http://www.shhp.gov.cn/shhp_1/Chinese/','1','16','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('68','','http://www.jingan.gov.cn/','1','16','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('69','','http://www.xh.sh.cn/','1','16','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('70','','http://hkq.sh.gov.cn/','1','16','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('71','','http://news.gd.sina.com.cn/guangzhou/','3','1','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('72','','http://www.gznews.gov.cn/','3','1','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('73','ձ','http://news.dayoo.com/guangzhou/','3','1','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('74','Ϸ','http://www.southcn.com/news/dishi/guangzhou/','3','1','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('75','Ӵ','http://news.gznet.com/','3','1','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('76','̳','http://www.kugz.net/','3','2','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('77','خ','http://www.py168.com/','3','2','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('78','̳','http://www.hdbbs.net/','3','2','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('79','','http://club.gznet.com/','3','2','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('80','̳','http://www.mytianhe.com/','3','2','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('81','','http://www.gztv.com/','3','3','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('82','齭Ƶ','http://www.gdtv.com.cn/newpage/dabenying/zjpd2/index.asp','3','3','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('83','㶫̨','http://www.gdtv.com.cn/','3','3','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('84','','http://www.goofm.com/','3','3','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('85','Ϸ̨','http://www.tvscn.com/','3','3','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('86','һҽԺ','http://www.81ts.com/CRMWeb/','3','9','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('87','ϷҽԺ','http://www.nfyy.com/','3','9','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('88','ڶҽԺ','http://www.gd2h.com/','3','9','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('89','дһԺ','http://www.gzsums.net/','3','9','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('90','ʡҽԺ','http://www.e5413.com/','3','9','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('91','Ӵʳ','http://food.gznet.com/','3','4','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('92','ʳڹ','http://www.gzmeal.com/','3','4','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('93','ͳ','http://guangzhou.fantong.com/','3','4','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('94','ڵ','http://www.dianping.com/guangzhou/food','3','4','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('95','ʳ','http://www.chi020.com/','3','4','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('96','Ա','http://www.taobao.com/go/chn/tbk_channel/channelcode.php?pid=mm_14033530_3168968_10472364&eventid=101329
','3','6','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('97','','http://www.meituan.com/guangzhou','3','6','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('98','','http://www.lashou.com/guangzhou','3','6','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('99','̳','http://p.yiqifa.com/c?s=dc1c5515&w=148281&c=4509&i=5862&l=0&e=mz&t=http://www.360buy.com','3','6','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('100','','http://www.womai.com/','3','6','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('101','','http://www.gzcb.com.cn/','3','10','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('102','ũҵ','http://www.961111.cn/','3','10','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('103','','http://www.icbc.com.cn/','3','10','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('104','㶫չ','http://www.gdb.com.cn/','3','10','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('105','','http://www.cmbchina.com/','3','10','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('106','ݹ','http://www.gz-bus.com/','3','14','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('107','ӿվ','http://www.tianhebus.com/','3','14','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('108','ɽѧ','http://www.zsu.edu.cn/','3','13','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('109','ѧ','http://www.scut.edu.cn/','3','13','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('110','һ','http://www.gzsyz.com/','3','13','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('111','ݶ','http://www.gdgzez.com.cn/','3','13','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('112','ƼְҵѧԺ','http://www.gzkjxy.net/','3','13','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('113','վվ','http://www.gzdzcz.com/','3','14','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('114','Խվ','http://www.yxnz.com.cn/','3','14','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('115','վ','http://hzstation.gzzc.com.cn/','3','14','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('116','㽭԰','http://www.xjzoo.com.cn/','3','15','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('117','¡','http://www.chimelongparadise.com/','3','15','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('118','','http://www.visitgz.com/','3','15','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('119','¡ȼ','http://www.chimelong.com/','3','15','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('120','ɽ','http://www.baiyunshan.com.cn/','3','15','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('121','','http://www.gz.gov.cn/','3','16','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('122','','http://www.thnet.gov.cn/','3','16','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('123','Խ','http://www.yuexiu.gov.cn/yxxxw/index/','3','16','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('124','','http://www.lw.gov.cn/','3','16','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('125','خ','http://www.panyu.gov.cn/jsp/','3','16','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('126','й̾','http://www.gzaic.gov.cn/','3','11','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('127','й','http://www.gzjd.gov.cn/','3','11','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('128','н','http://www.gzedu.gov.cn/','3','11','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('129','ݺ','http://guangzhou.customs.gov.cn/','3','11','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('130','','http://www.gzfb.gov.cn/','3','11','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('131','','http://www.gzpi.gov.cn/gzpi07/index.html','3','12','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('132','˲','http://www.020job.com/','3','12','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('133','Ͷ','http://www.gzlss.gov.cn/','3','12','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('134','Ƹ','http://www.hr020.cn/','3','12','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('135','齭˲','http://gz.zhujiangrc.com/','3','12','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('136','','http://www.sznews.com/','5','1','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('137','һ','http://news.oeeee.com/','5','1','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('138','Ϸĩ','http://www.infzm.com/','5','1','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('139','Ϸ','http://news.southcn.com/dishi/sz/','5','1','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('140','¿챨','http://epaper.xkb.com.cn/','5','1','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('202','й','http://www.chinanews.com.cn/','10','1','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('142','','http://www.pengyouwo.com/','5','2','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('143','','http://club.sz.net.cn/','5','2','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('144','ְҵ̳','http://www.szbbs.cn/','5','2','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('145','','http://www.pengchengwan.com/','5','2','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('146','ڵ̨','http://www.sztv.com.cn/','5','3','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('147','ڵ̨','http://www.szr.com.cn/','5','3','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('148','Ѷ','http://www.topway.com.cn/','5','3','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('149','㶫̨','http://www.gdtv.com.cn/','5','3','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('150','Ϸ̨','http://www.tvscn.com/','5','3','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('151','ҽԺ','http://www.szhospital.com/','5','9','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('152','ڱҽԺ','http://www.pkuszh.com/','5','9','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('153','ҽԺ','http://www.91group.com/','5','9','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('154','ڶҽԺ','http://www.szrch.com/','5','9','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('155','ҽԺ','http://www.boai.com/','5','9','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('156','˲','http://www.szhr.com.cn/','5','12','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('157','˲Ƹ','http://www.0755rc.com/','5','12','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('158','Ƹ','http://www.hr0755.com/','5','12','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('159','й˲','http://www.cjol.com/shenzhen/','5','12','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('160','Ƹ','http://www.szsh.com/','5','12','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('161','ڴѧ','http://www.szu.edu.cn/szu2007/','5','13','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('162','㲥Ӵѧ','http://www.szrtvu.com.cn/','5','13','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('163','ְҵѧԺ','http://www.szpt.edu.cn/','5','13','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('164','߼ʦѧУ','http://www.ssti.net.cn/','5','13','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('165','ǿְУ','http://www.szhqzx.net/','5','13','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('166','','http://www.shenzhentour.com/','5','15','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('167','֮','http://www.szwwco.com/','5','15','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('168','Ұ԰','http://www.szzoo.net/','5','15','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('169','','http://www.evergreen-cn.com/','5','15','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('170','С÷ɳ','http://www.szxms.com.cn/','5','15','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('171','ڱ','http://shenzhen.koubei.com/cate','5','4','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('172','ʳ','http://www.szeat.net/','5','4','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('173','ͳ','http://shenzhen.fantong.com/','5','4','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('174','ڵ','http://www.dianping.com/shenzhen/food','5','4','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('175','ζͨ','http://eat.sz.net.cn/','5','4','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('176','Ա','http://pindao.huoban.taobao.com/tms/channel/onsale.htm?pid=mm_14033530_3168968_10553587&eventid=&unid=148281','5','6','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('177','̳','http://p.yiqifa.com/c?s=dc1c5515&w=148281&c=4509&i=5862&l=0&e=mz&t=http://www.360buy.com','5','6','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('178','','http://www.lashou.com/shenzhen','5','6','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('179','','http://www.womai.com/','5','6','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('180','','http://www.meituan.com/','5','6','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('181','ڷչ','http://www.sdb.com.cn/website/page','5','10','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('182','㷢','http://www.gdb.com.cn/','5','10','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('183','ũ','http://www.961200.net/','5','10','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('184','','http://www.ccb.com/','5','10','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('185','','http://www.cmbchina.com/','5','10','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('186','ڵ','http://www.szmc.net/','5','14','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('187','ڹ','http://www.szbus.com.cn/','5','14','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('188','ʻ','http://www.szairport.com/','5','14','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('189','ڻվ','http://hcp.sz.bendibao.com/szstation/','5','14','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('190','վһ','http://jt.sz.bendibao.com/keche/','5','14','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('191','޺','http://www.szlh.gov.cn/main/','5','16','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('192','','http://www.szft.gov.cn/zf/','5','16','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('193','','http://www.lg.gov.cn/','5','16','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('194','ɽ','http://www.szns.gov.cn/','5','16','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('195','','http://www.baoan.gov.cn/main/','5','16','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('196','ڼί','http://www.szmj.gov.cn/','5','11','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('197','й','http://www.szga.gov.cn/','5','11','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('198','ط˰','http://www.szds.gov.cn/','5','11','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('199','˴','http://www.szrd.gov.cn/','5','11','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('200','Ͷ','http://www.szhrss.gov.cn/','5','11','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('201','̳','http://szbbs.sznews.com/','5','2','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('203','»','http://www.bj.xinhuanet.com/','10','1','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('204','','http://www.morningpost.com.cn/','10','1','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('205','¾','http://www.bjnews.com.cn/','10','1','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('206','','http://www.bjd.com.cn/','10','1','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('207','','http://www.wangjing.cn/','10','2','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('208','','http://www.hlgnet.com/','10','2','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('209','ͨ','http://www.bato.cn/','10','2','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('210','̳','http://www.hupub.com/','10','2','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('211','ׯ','http://www.yz010.com/','10','2','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('212','̨','http://www.btv.com.cn/','10','3','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('213','CCTV','http://www.cntv.cn/','10','3','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('214','㲥','http://listen.rbc.cn/','10','3','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('215','ͨ㲥','http://fm1039.rbc.cn/wszb/','10','3','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('216','CCTV','http://bugu.cntv.cn/news/china/xinwenlianbo/videopage/index.shtml','10','3','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('217','ҽԺ','http://www.bjhmoh.cn/','10','9','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('218','301ҽԺ','http://www.301hospital.com.cn/','10','9','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('219','ЭҽԺ','http://www.pumch.cn/','10','9','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('220','ͬҽԺ','http://www.trhos.com/','10','9','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('221','ҽԺ','http://www.ljzy.com.cn/','10','9','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('222','˲','http://www.bjrc.com/','10','12','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('223','׶˲','http://www.shoudurc.com/','10','12','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('224','˲','http://www.beijingrc.com/','10','12','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('225','лӢűվ','http://beijing.chinahr.com/','10','12','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('226','˲Ϣ','http://www.bjp.gov.cn/renshiju/','10','12','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('227','廪ѧ','http://www.tsinghua.edu.cn/','10','13','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('228','ѧ','http://www.pku.edu.cn/','10','13','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('229','ʦѧ','http://www.bnu.edu.cn/','10','13','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('230','ͨѧ','http://www.njtu.edu.cn/','10','13','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('231','׶ʦѧ','http://www.cnu.edu.cn/','10','13','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('232','Ϣ','http://www.bjta.gov.cn/','10','15','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('233','ʹԺ','http://www.dpm.org.cn/','10','15','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('234','Ҳ','http://www.chnmuseum.cn/','10','15','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('235','繫԰','http://www.beijingworldpark.com.cn/','10','15','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('236','Բ԰','http://www.yuanmingyuanpark.com/','10','15','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('237','ڱ','http://beijing.koubei.com/cate','10','4','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('238','ʳ','http://beijingmeishi.abang.com/','10','4','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('239','ͳ','http://beijing.fantong.com/','10','4','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('240','ڵ','http://www.dianping.com/beijing/food','10','4','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('241','POCOʳ','http://bj.food.poco.cn/','10','6','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('242','Ա','http://www.taobao.com/go/chn/tbk_channel/channelcode.php?pid=mm_14033530_3168968_10472364&eventid=101329
','10','6','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('243','','http://www.meituan.com/beijing','10','6','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('244','','http://www.lashou.com/beijing','10','6','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('245','̳','http://p.yiqifa.com/c?s=dc1c5515&w=148281&c=4509&i=5862&l=0&e=mz&t=http://www.360buy.com','10','6','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('246','','http://www.womai.com/','10','4','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('247','','http://www.bankofbeijing.com.cn/','10','10','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('248','ũҵ','http://www.bjrcb.com/','10','10','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('249','','http://www.pbc.gov.cn/','10','10','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('250','','http://www.ccb.com/','10','10','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('251','','http://www.cmbchina.com/','10','10','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('252','','http://www.bjsubway.com/','10','14','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('253','','http://www.bjbus.com/','10','14','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('254','׶','http://www.bcia.com.cn/','10','14','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('255','վ','http://www.bjhcz.net/','10','14','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('256','ؿվ','http://www.bjalsa.com.cn/','10','14','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('257','׶֮','http://www.beijing.gov.cn/','10','16','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('258','','http://www.bjchy.gov.cn/','10','16','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('259','','http://www.bjhd.gov.cn/','10','16','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('260','','http://www.bjdch.gov.cn/','10','16','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('261','','http://www.bjxch.gov.cn/','10','16','5','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('262','˴ί','http://www.bjrd.gov.cn/','10','11','1','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('263','в','http://www.bjcz.gov.cn/','10','11','2','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('264','Э','http://www.bjzx.gov.cn/','10','11','3','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('265','й','http://www.bjgaj.gov.cn/','10','11','4','0','0','','');
INSERT INTO ylmf_city_coolsite VALUES('266','','http://www.bjhb.gov.cn/','10','11','5','0','0','','');

INSERT INTO ylmf_city_id_name VALUES('1','101010100','');
INSERT INTO ylmf_city_id_name VALUES('2','101010200','');
INSERT INTO ylmf_city_id_name VALUES('3','101010300','');
INSERT INTO ylmf_city_id_name VALUES('4','101010400','˳');
INSERT INTO ylmf_city_id_name VALUES('5','101010500','');
INSERT INTO ylmf_city_id_name VALUES('6','101010600','ͨ');
INSERT INTO ylmf_city_id_name VALUES('7','101010700','ƽ');
INSERT INTO ylmf_city_id_name VALUES('8','101010800','');
INSERT INTO ylmf_city_id_name VALUES('9','101010900','̨');
INSERT INTO ylmf_city_id_name VALUES('10','101011000','ʯɽ');
INSERT INTO ylmf_city_id_name VALUES('11','101011100','');
INSERT INTO ylmf_city_id_name VALUES('12','101011200','ɽ');
INSERT INTO ylmf_city_id_name VALUES('13','101011300','');
INSERT INTO ylmf_city_id_name VALUES('14','101011400','ͷ');
INSERT INTO ylmf_city_id_name VALUES('15','101011500','ƽ');
INSERT INTO ylmf_city_id_name VALUES('16','101011600','˴');
INSERT INTO ylmf_city_id_name VALUES('17','101011700','ү');
INSERT INTO ylmf_city_id_name VALUES('18','101011800','ӿ');
INSERT INTO ylmf_city_id_name VALUES('19','101011900','ϵ');
INSERT INTO ylmf_city_id_name VALUES('20','101012000','ի');
INSERT INTO ylmf_city_id_name VALUES('21','101012100','ϼ');
INSERT INTO ylmf_city_id_name VALUES('22','101020100','Ϻ');
INSERT INTO ylmf_city_id_name VALUES('23','101020200','');
INSERT INTO ylmf_city_id_name VALUES('24','101020300','ɽ');
INSERT INTO ylmf_city_id_name VALUES('25','101020400','ɳ');
INSERT INTO ylmf_city_id_name VALUES('26','101020500','ζ');
INSERT INTO ylmf_city_id_name VALUES('27','101020600','ϻ');
INSERT INTO ylmf_city_id_name VALUES('28','101020700','ɽ');
INSERT INTO ylmf_city_id_name VALUES('29','101020800','');
INSERT INTO ylmf_city_id_name VALUES('30','101020900','ɽ');
INSERT INTO ylmf_city_id_name VALUES('31','101021000','');
INSERT INTO ylmf_city_id_name VALUES('32','101021100','');
INSERT INTO ylmf_city_id_name VALUES('33','101021101','¼');
INSERT INTO ylmf_city_id_name VALUES('34','101021102','ˮ');
INSERT INTO ylmf_city_id_name VALUES('35','101030100','');
INSERT INTO ylmf_city_id_name VALUES('36','101030200','');
INSERT INTO ylmf_city_id_name VALUES('37','101030300','');
INSERT INTO ylmf_city_id_name VALUES('38','101030400','');
INSERT INTO ylmf_city_id_name VALUES('39','101030500','');
INSERT INTO ylmf_city_id_name VALUES('40','101030600','');
INSERT INTO ylmf_city_id_name VALUES('41','101030700','');
INSERT INTO ylmf_city_id_name VALUES('42','101030800','');
INSERT INTO ylmf_city_id_name VALUES('43','101030900','');
INSERT INTO ylmf_city_id_name VALUES('44','101031000','');
INSERT INTO ylmf_city_id_name VALUES('45','101031100','');
INSERT INTO ylmf_city_id_name VALUES('46','101031200','');
INSERT INTO ylmf_city_id_name VALUES('47','101031300','ƽ̨');
INSERT INTO ylmf_city_id_name VALUES('48','101031400','');
INSERT INTO ylmf_city_id_name VALUES('49','101040100','');
INSERT INTO ylmf_city_id_name VALUES('50','101040200','');
INSERT INTO ylmf_city_id_name VALUES('51','101040300','ϴ');
INSERT INTO ylmf_city_id_name VALUES('52','101040400','ϴ');
INSERT INTO ylmf_city_id_name VALUES('53','101040500','');
INSERT INTO ylmf_city_id_name VALUES('54','101040600','ʢ');
INSERT INTO ylmf_city_id_name VALUES('55','101040700','山');
INSERT INTO ylmf_city_id_name VALUES('56','101040800','');
INSERT INTO ylmf_city_id_name VALUES('57','101040900','');
INSERT INTO ylmf_city_id_name VALUES('58','101041000','');
INSERT INTO ylmf_city_id_name VALUES('59','101041100','ǭ');
INSERT INTO ylmf_city_id_name VALUES('60','101041200','');
INSERT INTO ylmf_city_id_name VALUES('61','101041300','');
INSERT INTO ylmf_city_id_name VALUES('62','101041400','');
INSERT INTO ylmf_city_id_name VALUES('63','101041500','');
INSERT INTO ylmf_city_id_name VALUES('64','101041600','ǿ');
INSERT INTO ylmf_city_id_name VALUES('65','101041700','');
INSERT INTO ylmf_city_id_name VALUES('66','101041800','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('67','101041900','');
INSERT INTO ylmf_city_id_name VALUES('68','101042000','ɽ');
INSERT INTO ylmf_city_id_name VALUES('69','101042100','');
INSERT INTO ylmf_city_id_name VALUES('70','101042200','潭');
INSERT INTO ylmf_city_id_name VALUES('71','101042300','ƽ');
INSERT INTO ylmf_city_id_name VALUES('72','101042400','');
INSERT INTO ylmf_city_id_name VALUES('73','101042500','ʯ');
INSERT INTO ylmf_city_id_name VALUES('74','101042600','');
INSERT INTO ylmf_city_id_name VALUES('75','101042700','ٲ');
INSERT INTO ylmf_city_id_name VALUES('76','101042800','ͭ');
INSERT INTO ylmf_city_id_name VALUES('77','101042900','ɽ');
INSERT INTO ylmf_city_id_name VALUES('78','101043000','ᶼ');
INSERT INTO ylmf_city_id_name VALUES('79','101043100','¡');
INSERT INTO ylmf_city_id_name VALUES('80','101043200','ˮ');
INSERT INTO ylmf_city_id_name VALUES('81','101043300','뽭');
INSERT INTO ylmf_city_id_name VALUES('82','101043400','');
INSERT INTO ylmf_city_id_name VALUES('83','101043500','ɽ');
INSERT INTO ylmf_city_id_name VALUES('84','101043600','ɽ');
INSERT INTO ylmf_city_id_name VALUES('85','101050101','');
INSERT INTO ylmf_city_id_name VALUES('86','101050102','˫');
INSERT INTO ylmf_city_id_name VALUES('87','101050103','');
INSERT INTO ylmf_city_id_name VALUES('88','101050104','');
INSERT INTO ylmf_city_id_name VALUES('89','101050105','');
INSERT INTO ylmf_city_id_name VALUES('90','101050106','');
INSERT INTO ylmf_city_id_name VALUES('91','101050107','');
INSERT INTO ylmf_city_id_name VALUES('92','101050108','ͨ');
INSERT INTO ylmf_city_id_name VALUES('93','101050109','');
INSERT INTO ylmf_city_id_name VALUES('94','101050110','');
INSERT INTO ylmf_city_id_name VALUES('95','101050111','־');
INSERT INTO ylmf_city_id_name VALUES('96','101050112','峣');
INSERT INTO ylmf_city_id_name VALUES('97','101050113','ľ');
INSERT INTO ylmf_city_id_name VALUES('98','101050201','');
INSERT INTO ylmf_city_id_name VALUES('99','101050202','ګ');
INSERT INTO ylmf_city_id_name VALUES('100','101050203','');
INSERT INTO ylmf_city_id_name VALUES('101','101050204','');
INSERT INTO ylmf_city_id_name VALUES('102','101050205','ԣ');
INSERT INTO ylmf_city_id_name VALUES('103','101050206','');
INSERT INTO ylmf_city_id_name VALUES('104','101050207','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('105','101050208','ɽ');
INSERT INTO ylmf_city_id_name VALUES('106','101050209','˶');
INSERT INTO ylmf_city_id_name VALUES('107','101050210','̩');
INSERT INTO ylmf_city_id_name VALUES('108','101050301','ĵ');
INSERT INTO ylmf_city_id_name VALUES('109','101050302','');
INSERT INTO ylmf_city_id_name VALUES('110','101050303','');
INSERT INTO ylmf_city_id_name VALUES('111','101050304','ֿ');
INSERT INTO ylmf_city_id_name VALUES('112','101050305','Һ');
INSERT INTO ylmf_city_id_name VALUES('113','101050306','');
INSERT INTO ylmf_city_id_name VALUES('114','101050307','');
INSERT INTO ylmf_city_id_name VALUES('115','101050401','ľ˹');
INSERT INTO ylmf_city_id_name VALUES('116','101050402','ԭ');
INSERT INTO ylmf_city_id_name VALUES('117','101050403','Զ');
INSERT INTO ylmf_city_id_name VALUES('118','101050404','봨');
INSERT INTO ylmf_city_id_name VALUES('119','101050405','');
INSERT INTO ylmf_city_id_name VALUES('120','101050406','ͬ');
INSERT INTO ylmf_city_id_name VALUES('121','101050407','');
INSERT INTO ylmf_city_id_name VALUES('122','101050501','绯');
INSERT INTO ylmf_city_id_name VALUES('123','101050502','ض');
INSERT INTO ylmf_city_id_name VALUES('124','101050503','');
INSERT INTO ylmf_city_id_name VALUES('125','101050504','');
INSERT INTO ylmf_city_id_name VALUES('126','101050505','ˮ');
INSERT INTO ylmf_city_id_name VALUES('127','101050506','');
INSERT INTO ylmf_city_id_name VALUES('128','101050507','');
INSERT INTO ylmf_city_id_name VALUES('129','101050508','');
INSERT INTO ylmf_city_id_name VALUES('130','101050509','찲');
INSERT INTO ylmf_city_id_name VALUES('131','101050510','');
INSERT INTO ylmf_city_id_name VALUES('132','101050601','ں');
INSERT INTO ylmf_city_id_name VALUES('133','101050602','۽');
INSERT INTO ylmf_city_id_name VALUES('134','101050603','');
INSERT INTO ylmf_city_id_name VALUES('135','101050604','ѷ');
INSERT INTO ylmf_city_id_name VALUES('136','101050605','');
INSERT INTO ylmf_city_id_name VALUES('137','101050606','');
INSERT INTO ylmf_city_id_name VALUES('138','101050701','˰');
INSERT INTO ylmf_city_id_name VALUES('139','101050702','');
INSERT INTO ylmf_city_id_name VALUES('140','101050703','Į');
INSERT INTO ylmf_city_id_name VALUES('141','101050704','');
INSERT INTO ylmf_city_id_name VALUES('142','101050705','');
INSERT INTO ylmf_city_id_name VALUES('143','101050706','');
INSERT INTO ylmf_city_id_name VALUES('144','101050707','ľ');
INSERT INTO ylmf_city_id_name VALUES('145','101050801','');
INSERT INTO ylmf_city_id_name VALUES('146','101050802','');
INSERT INTO ylmf_city_id_name VALUES('147','101050803','Ӫ');
INSERT INTO ylmf_city_id_name VALUES('148','101050804','');
INSERT INTO ylmf_city_id_name VALUES('149','101050805','');
INSERT INTO ylmf_city_id_name VALUES('150','101050901','');
INSERT INTO ylmf_city_id_name VALUES('151','101050902','ֵ');
INSERT INTO ylmf_city_id_name VALUES('152','101050903','');
INSERT INTO ylmf_city_id_name VALUES('153','101050904','Դ');
INSERT INTO ylmf_city_id_name VALUES('154','101051002','');
INSERT INTO ylmf_city_id_name VALUES('155','101051101','');
INSERT INTO ylmf_city_id_name VALUES('156','101051102','');
INSERT INTO ylmf_city_id_name VALUES('157','101051103','ɽ');
INSERT INTO ylmf_city_id_name VALUES('158','101051104','');
INSERT INTO ylmf_city_id_name VALUES('159','101051201','׸');
INSERT INTO ylmf_city_id_name VALUES('160','101051202','');
INSERT INTO ylmf_city_id_name VALUES('161','101051203','ܱ');
INSERT INTO ylmf_city_id_name VALUES('162','101051301','˫Ѽɽ');
INSERT INTO ylmf_city_id_name VALUES('163','101051302','');
INSERT INTO ylmf_city_id_name VALUES('164','101051303','');
INSERT INTO ylmf_city_id_name VALUES('165','101051304','ĺ');
INSERT INTO ylmf_city_id_name VALUES('166','101060101','');
INSERT INTO ylmf_city_id_name VALUES('167','101060102','ũ');
INSERT INTO ylmf_city_id_name VALUES('168','101060103','»');
INSERT INTO ylmf_city_id_name VALUES('169','101060104','̨');
INSERT INTO ylmf_city_id_name VALUES('170','101060105','');
INSERT INTO ylmf_city_id_name VALUES('171','101060106','˫');
INSERT INTO ylmf_city_id_name VALUES('172','101060201','');
INSERT INTO ylmf_city_id_name VALUES('173','101060202','');
INSERT INTO ylmf_city_id_name VALUES('174','101060203','');
INSERT INTO ylmf_city_id_name VALUES('175','101060204','Ժ');
INSERT INTO ylmf_city_id_name VALUES('176','101060205','ʯ');
INSERT INTO ylmf_city_id_name VALUES('177','101060206','');
INSERT INTO ylmf_city_id_name VALUES('178','101060207','Ͳɽ');
INSERT INTO ylmf_city_id_name VALUES('179','101060301','Ӽ');
INSERT INTO ylmf_city_id_name VALUES('180','101060302','ػ');
INSERT INTO ylmf_city_id_name VALUES('181','101060303','ͼ');
INSERT INTO ylmf_city_id_name VALUES('182','101060304','');
INSERT INTO ylmf_city_id_name VALUES('183','101060305','');
INSERT INTO ylmf_city_id_name VALUES('184','101060306','');
INSERT INTO ylmf_city_id_name VALUES('185','101060307','');
INSERT INTO ylmf_city_id_name VALUES('186','101060308','');
INSERT INTO ylmf_city_id_name VALUES('187','101060309','ͼ');
INSERT INTO ylmf_city_id_name VALUES('188','101060310','ɽ');
INSERT INTO ylmf_city_id_name VALUES('189','101060311','ӹ');
INSERT INTO ylmf_city_id_name VALUES('190','101060401','ƽ');
INSERT INTO ylmf_city_id_name VALUES('191','101060402','˫');
INSERT INTO ylmf_city_id_name VALUES('192','101060403','');
INSERT INTO ylmf_city_id_name VALUES('193','101060404','');
INSERT INTO ylmf_city_id_name VALUES('194','101060405','ͨ');
INSERT INTO ylmf_city_id_name VALUES('195','101060406','¼');
INSERT INTO ylmf_city_id_name VALUES('196','101060501','ͨ');
INSERT INTO ylmf_city_id_name VALUES('197','101060502','÷ӿ');
INSERT INTO ylmf_city_id_name VALUES('198','101060503','');
INSERT INTO ylmf_city_id_name VALUES('199','101060504','');
INSERT INTO ylmf_city_id_name VALUES('200','101060505','');
INSERT INTO ylmf_city_id_name VALUES('201','101060506','ͨ');
INSERT INTO ylmf_city_id_name VALUES('202','101060601','׳');
INSERT INTO ylmf_city_id_name VALUES('203','101060602','');
INSERT INTO ylmf_city_id_name VALUES('204','101060603','');
INSERT INTO ylmf_city_id_name VALUES('205','101060604','');
INSERT INTO ylmf_city_id_name VALUES('206','101060605','ͨ');
INSERT INTO ylmf_city_id_name VALUES('207','101060701','Դ');
INSERT INTO ylmf_city_id_name VALUES('208','101060702','');
INSERT INTO ylmf_city_id_name VALUES('209','101060801','ԭ');
INSERT INTO ylmf_city_id_name VALUES('210','101060802','Ǭ');
INSERT INTO ylmf_city_id_name VALUES('211','101060803','ǰ');
INSERT INTO ylmf_city_id_name VALUES('212','101060804','');
INSERT INTO ylmf_city_id_name VALUES('213','101060805','');
INSERT INTO ylmf_city_id_name VALUES('214','101060901','ɽ');
INSERT INTO ylmf_city_id_name VALUES('215','101060902','');
INSERT INTO ylmf_city_id_name VALUES('216','101060903','ٽ');
INSERT INTO ylmf_city_id_name VALUES('217','101060904','');
INSERT INTO ylmf_city_id_name VALUES('218','101060905','');
INSERT INTO ylmf_city_id_name VALUES('219','101070101','');
INSERT INTO ylmf_city_id_name VALUES('220','101070102','ռ');
INSERT INTO ylmf_city_id_name VALUES('221','101070103','');
INSERT INTO ylmf_city_id_name VALUES('222','101070104','ƽ');
INSERT INTO ylmf_city_id_name VALUES('223','101070105','');
INSERT INTO ylmf_city_id_name VALUES('224','101070106','');
INSERT INTO ylmf_city_id_name VALUES('225','101070107','ں');
INSERT INTO ylmf_city_id_name VALUES('226','101070108','³');
INSERT INTO ylmf_city_id_name VALUES('227','101070201','');
INSERT INTO ylmf_city_id_name VALUES('228','101070202','߷');
INSERT INTO ylmf_city_id_name VALUES('229','101070203','');
INSERT INTO ylmf_city_id_name VALUES('230','101070204','');
INSERT INTO ylmf_city_id_name VALUES('231','101070205','˳');
INSERT INTO ylmf_city_id_name VALUES('232','101070206','');
INSERT INTO ylmf_city_id_name VALUES('233','101070207','ׯ');
INSERT INTO ylmf_city_id_name VALUES('234','101070208','Ƥ');
INSERT INTO ylmf_city_id_name VALUES('235','101070209','');
INSERT INTO ylmf_city_id_name VALUES('236','101070301','ɽ');
INSERT INTO ylmf_city_id_name VALUES('237','101070302','̨');
INSERT INTO ylmf_city_id_name VALUES('238','101070303','');
INSERT INTO ylmf_city_id_name VALUES('239','101070304','');
INSERT INTO ylmf_city_id_name VALUES('240','101070401','˳');
INSERT INTO ylmf_city_id_name VALUES('241','101070403','ԭ');
INSERT INTO ylmf_city_id_name VALUES('242','101070404','µ');
INSERT INTO ylmf_city_id_name VALUES('243','101070501','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('244','101070502','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('245','101070503','ݺӿ');
INSERT INTO ylmf_city_id_name VALUES('246','101070504','');
INSERT INTO ylmf_city_id_name VALUES('247','101070601','');
INSERT INTO ylmf_city_id_name VALUES('248','101070602','');
INSERT INTO ylmf_city_id_name VALUES('249','101070603','');
INSERT INTO ylmf_city_id_name VALUES('250','101070604','');
INSERT INTO ylmf_city_id_name VALUES('251','101070701','');
INSERT INTO ylmf_city_id_name VALUES('252','101070702','躣');
INSERT INTO ylmf_city_id_name VALUES('253','101070703','');
INSERT INTO ylmf_city_id_name VALUES('254','101070704','');
INSERT INTO ylmf_city_id_name VALUES('255','101070705','ɽ');
INSERT INTO ylmf_city_id_name VALUES('256','101070801','Ӫ');
INSERT INTO ylmf_city_id_name VALUES('257','101070802','ʯ');
INSERT INTO ylmf_city_id_name VALUES('258','101070803','');
INSERT INTO ylmf_city_id_name VALUES('259','101071804','');
INSERT INTO ylmf_city_id_name VALUES('260','101070901','');
INSERT INTO ylmf_city_id_name VALUES('261','101070902','');
INSERT INTO ylmf_city_id_name VALUES('262','101071001','');
INSERT INTO ylmf_city_id_name VALUES('263','101071002','');
INSERT INTO ylmf_city_id_name VALUES('264','101071003','');
INSERT INTO ylmf_city_id_name VALUES('265','101071101','');
INSERT INTO ylmf_city_id_name VALUES('266','101071102','ԭ');
INSERT INTO ylmf_city_id_name VALUES('267','101071103','ͼ');
INSERT INTO ylmf_city_id_name VALUES('268','101071104','');
INSERT INTO ylmf_city_id_name VALUES('269','101071201','');
INSERT INTO ylmf_city_id_name VALUES('270','101071202','ƽ');
INSERT INTO ylmf_city_id_name VALUES('271','101071203','Դ');
INSERT INTO ylmf_city_id_name VALUES('272','101071204','');
INSERT INTO ylmf_city_id_name VALUES('273','101071205','Ʊ');
INSERT INTO ylmf_city_id_name VALUES('274','101071206','ɽ');
INSERT INTO ylmf_city_id_name VALUES('275','101071207','ƽ');
INSERT INTO ylmf_city_id_name VALUES('276','101071301','̽');
INSERT INTO ylmf_city_id_name VALUES('277','101071302','');
INSERT INTO ylmf_city_id_name VALUES('278','101071303','ɽ');
INSERT INTO ylmf_city_id_name VALUES('279','101071401','«');
INSERT INTO ylmf_city_id_name VALUES('280','101071402','');
INSERT INTO ylmf_city_id_name VALUES('281','101071403','');
INSERT INTO ylmf_city_id_name VALUES('282','101071404','˳');
INSERT INTO ylmf_city_id_name VALUES('283','101080101','ͺ');
INSERT INTO ylmf_city_id_name VALUES('284','101080102','Ĭ');
INSERT INTO ylmf_city_id_name VALUES('285','101080103','п');
INSERT INTO ylmf_city_id_name VALUES('286','101080104','ָ');
INSERT INTO ylmf_city_id_name VALUES('287','101080105','ˮ');
INSERT INTO ylmf_city_id_name VALUES('288','101080106','ͺн');
INSERT INTO ylmf_city_id_name VALUES('289','101080107','䴨');
INSERT INTO ylmf_city_id_name VALUES('290','101080201','ͷ');
INSERT INTO ylmf_city_id_name VALUES('291','101080202','ƶ');
INSERT INTO ylmf_city_id_name VALUES('292','101080203','');
INSERT INTO ylmf_city_id_name VALUES('293','101080204','Ĭ');
INSERT INTO ylmf_city_id_name VALUES('294','101080205','');
INSERT INTO ylmf_city_id_name VALUES('295','101080206','ï');
INSERT INTO ylmf_city_id_name VALUES('296','101080207','ʯ');
INSERT INTO ylmf_city_id_name VALUES('297','101080301','ں');
INSERT INTO ylmf_city_id_name VALUES('298','101080401','');
INSERT INTO ylmf_city_id_name VALUES('299','101080402','׿');
INSERT INTO ylmf_city_id_name VALUES('300','101080403','');
INSERT INTO ylmf_city_id_name VALUES('301','101080404','̶');
INSERT INTO ylmf_city_id_name VALUES('302','101080405','ϣ');
INSERT INTO ylmf_city_id_name VALUES('303','101080406','˺');
INSERT INTO ylmf_city_id_name VALUES('304','101080407','');
INSERT INTO ylmf_city_id_name VALUES('305','101080408','ǰ');
INSERT INTO ylmf_city_id_name VALUES('306','101080409','');
INSERT INTO ylmf_city_id_name VALUES('307','101080410','');
INSERT INTO ylmf_city_id_name VALUES('308','101080411','');
INSERT INTO ylmf_city_id_name VALUES('309','101080412','');
INSERT INTO ylmf_city_id_name VALUES('310','101080501','ͨ');
INSERT INTO ylmf_city_id_name VALUES('311','101080502','Ხ');
INSERT INTO ylmf_city_id_name VALUES('312','101080503','ƶ');
INSERT INTO ylmf_city_id_name VALUES('313','101080504','ƶ');
INSERT INTO ylmf_city_id_name VALUES('314','101080505','ɽ');
INSERT INTO ylmf_city_id_name VALUES('315','101080506','³');
INSERT INTO ylmf_city_id_name VALUES('316','101080507','');
INSERT INTO ylmf_city_id_name VALUES('317','101080508','');
INSERT INTO ylmf_city_id_name VALUES('318','101080509','³');
INSERT INTO ylmf_city_id_name VALUES('319','101080510','');
INSERT INTO ylmf_city_id_name VALUES('320','101080511','Ŷº˶');
INSERT INTO ylmf_city_id_name VALUES('321','101080512','ͨǮҵ');
INSERT INTO ylmf_city_id_name VALUES('322','101080601','');
INSERT INTO ylmf_city_id_name VALUES('323','101080602','彼վ');
INSERT INTO ylmf_city_id_name VALUES('324','101080603','³ƶ');
INSERT INTO ylmf_city_id_name VALUES('325','101080604','ƶ');
INSERT INTO ylmf_city_id_name VALUES('326','101080605','');
INSERT INTO ylmf_city_id_name VALUES('327','101080606','');
INSERT INTO ylmf_city_id_name VALUES('328','101080607','');
INSERT INTO ylmf_city_id_name VALUES('329','101080608','ʲ');
INSERT INTO ylmf_city_id_name VALUES('330','101080609','ţ');
INSERT INTO ylmf_city_id_name VALUES('331','101080610','');
INSERT INTO ylmf_city_id_name VALUES('332','101080611','');
INSERT INTO ylmf_city_id_name VALUES('333','101080612','ﺱ');
INSERT INTO ylmf_city_id_name VALUES('334','101080613','');
INSERT INTO ylmf_city_id_name VALUES('335','101080614','');
INSERT INTO ylmf_city_id_name VALUES('336','101080615','ͼ');
INSERT INTO ylmf_city_id_name VALUES('337','101080701','˹');
INSERT INTO ylmf_city_id_name VALUES('338','101080703','');
INSERT INTO ylmf_city_id_name VALUES('339','101080704','׼');
INSERT INTO ylmf_city_id_name VALUES('340','101080705','пǰ');
INSERT INTO ylmf_city_id_name VALUES('341','101080706','');
INSERT INTO ylmf_city_id_name VALUES('342','101080707','');
INSERT INTO ylmf_city_id_name VALUES('343','101080708','п');
INSERT INTO ylmf_city_id_name VALUES('344','101080709','');
INSERT INTO ylmf_city_id_name VALUES('345','101080710','');
INSERT INTO ylmf_city_id_name VALUES('346','101080711','');
INSERT INTO ylmf_city_id_name VALUES('347','101080712','');
INSERT INTO ylmf_city_id_name VALUES('348','101080801','ٺ');
INSERT INTO ylmf_city_id_name VALUES('349','101080802','ԭ');
INSERT INTO ylmf_city_id_name VALUES('350','101080803','');
INSERT INTO ylmf_city_id_name VALUES('351','101080804','ǰ');
INSERT INTO ylmf_city_id_name VALUES('352','101080805','̫');
INSERT INTO ylmf_city_id_name VALUES('353','101080806','');
INSERT INTO ylmf_city_id_name VALUES('354','101080807','غ');
INSERT INTO ylmf_city_id_name VALUES('355','101080808','');
INSERT INTO ylmf_city_id_name VALUES('356','101080809','ʱ');
INSERT INTO ylmf_city_id_name VALUES('357','101080810','');
INSERT INTO ylmf_city_id_name VALUES('358','101080811','ũվ');
INSERT INTO ylmf_city_id_name VALUES('359','101080901','ֺ');
INSERT INTO ylmf_city_id_name VALUES('360','101080902','');
INSERT INTO ylmf_city_id_name VALUES('361','101080903','');
INSERT INTO ylmf_city_id_name VALUES('362','101080904','͸');
INSERT INTO ylmf_city_id_name VALUES('363','101080905','͹');
INSERT INTO ylmf_city_id_name VALUES('364','101080906','');
INSERT INTO ylmf_city_id_name VALUES('365','101080907','');
INSERT INTO ylmf_city_id_name VALUES('366','101080908','պ');
INSERT INTO ylmf_city_id_name VALUES('367','101080909','');
INSERT INTO ylmf_city_id_name VALUES('368','101080910','');
INSERT INTO ylmf_city_id_name VALUES('369','101080911','̫');
INSERT INTO ylmf_city_id_name VALUES('370','101080912','');
INSERT INTO ylmf_city_id_name VALUES('371','101080913','');
INSERT INTO ylmf_city_id_name VALUES('372','101080914','');
INSERT INTO ylmf_city_id_name VALUES('373','101080915','');
INSERT INTO ylmf_city_id_name VALUES('374','101080916','ͼ');
INSERT INTO ylmf_city_id_name VALUES('375','101080917','');
INSERT INTO ylmf_city_id_name VALUES('376','101080918','');
INSERT INTO ylmf_city_id_name VALUES('377','101080919','ͼ');
INSERT INTO ylmf_city_id_name VALUES('378','101081001','');
INSERT INTO ylmf_city_id_name VALUES('379','101081002','С');
INSERT INTO ylmf_city_id_name VALUES('380','101081003','');
INSERT INTO ylmf_city_id_name VALUES('381','101081004','Ī');
INSERT INTO ylmf_city_id_name VALUES('382','101081005','״');
INSERT INTO ylmf_city_id_name VALUES('383','101081006','¿');
INSERT INTO ylmf_city_id_name VALUES('384','101081007','°Ͷ');
INSERT INTO ylmf_city_id_name VALUES('385','101081008','°Ͷ');
INSERT INTO ylmf_city_id_name VALUES('386','101081009','°Ͷ');
INSERT INTO ylmf_city_id_name VALUES('387','101081010','');
INSERT INTO ylmf_city_id_name VALUES('388','101081011','ʯ');
INSERT INTO ylmf_city_id_name VALUES('389','101081012','');
INSERT INTO ylmf_city_id_name VALUES('390','101081014','');
INSERT INTO ylmf_city_id_name VALUES('391','101081015','');
INSERT INTO ylmf_city_id_name VALUES('392','101081016','ͼ');
INSERT INTO ylmf_city_id_name VALUES('393','101081101','');
INSERT INTO ylmf_city_id_name VALUES('394','101081102','ɽ');
INSERT INTO ylmf_city_id_name VALUES('395','101081103','ƶ');
INSERT INTO ylmf_city_id_name VALUES('396','101081104','');
INSERT INTO ylmf_city_id_name VALUES('397','101081105','');
INSERT INTO ylmf_city_id_name VALUES('398','101081106','');
INSERT INTO ylmf_city_id_name VALUES('399','101081107','ͻȪ');
INSERT INTO ylmf_city_id_name VALUES('400','101081201','');
INSERT INTO ylmf_city_id_name VALUES('401','101081202','');
INSERT INTO ylmf_city_id_name VALUES('402','101081203','');
INSERT INTO ylmf_city_id_name VALUES('403','101081204','Ӻ');
INSERT INTO ylmf_city_id_name VALUES('404','101081205','̫');
INSERT INTO ylmf_city_id_name VALUES('405','101081206','ָ');
INSERT INTO ylmf_city_id_name VALUES('406','101081207','ͷ');
INSERT INTO ylmf_city_id_name VALUES('407','101081208','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('408','101081209','ŵ');
INSERT INTO ylmf_city_id_name VALUES('409','101090101','ʯׯ');
INSERT INTO ylmf_city_id_name VALUES('410','101090102','');
INSERT INTO ylmf_city_id_name VALUES('411','101090103','');
INSERT INTO ylmf_city_id_name VALUES('412','101090104','');
INSERT INTO ylmf_city_id_name VALUES('413','101090105','');
INSERT INTO ylmf_city_id_name VALUES('414','101090106','');
INSERT INTO ylmf_city_id_name VALUES('415','101090107','');
INSERT INTO ylmf_city_id_name VALUES('416','101090108','');
INSERT INTO ylmf_city_id_name VALUES('417','101090109','޻');
INSERT INTO ylmf_city_id_name VALUES('418','101090110','޼');
INSERT INTO ylmf_city_id_name VALUES('419','101090111','ƽɽ');
INSERT INTO ylmf_city_id_name VALUES('420','101090112','Ԫ');
INSERT INTO ylmf_city_id_name VALUES('421','101090113','');
INSERT INTO ylmf_city_id_name VALUES('422','101090114','');
INSERT INTO ylmf_city_id_name VALUES('423','101090115','޻');
INSERT INTO ylmf_city_id_name VALUES('424','101090116','');
INSERT INTO ylmf_city_id_name VALUES('425','101090117','');
INSERT INTO ylmf_city_id_name VALUES('426','101090201','');
INSERT INTO ylmf_city_id_name VALUES('427','101090202','');
INSERT INTO ylmf_city_id_name VALUES('428','101090203','ƽ');
INSERT INTO ylmf_city_id_name VALUES('429','101090204','ˮ');
INSERT INTO ylmf_city_id_name VALUES('430','101090205','');
INSERT INTO ylmf_city_id_name VALUES('431','101090206','');
INSERT INTO ylmf_city_id_name VALUES('432','101090207','ݳ');
INSERT INTO ylmf_city_id_name VALUES('433','101090208','Ͼ');
INSERT INTO ylmf_city_id_name VALUES('434','101090209','Դ');
INSERT INTO ylmf_city_id_name VALUES('435','101090210','');
INSERT INTO ylmf_city_id_name VALUES('436','101090211','');
INSERT INTO ylmf_city_id_name VALUES('437','101090212','');
INSERT INTO ylmf_city_id_name VALUES('438','101090213','ˮ');
INSERT INTO ylmf_city_id_name VALUES('439','101090214','');
INSERT INTO ylmf_city_id_name VALUES('440','101090215','');
INSERT INTO ylmf_city_id_name VALUES('441','101090216','˳ƽ');
INSERT INTO ylmf_city_id_name VALUES('442','101090217','');
INSERT INTO ylmf_city_id_name VALUES('443','101090218','');
INSERT INTO ylmf_city_id_name VALUES('444','101090219','');
INSERT INTO ylmf_city_id_name VALUES('445','101090220','');
INSERT INTO ylmf_city_id_name VALUES('446','101090221','߱');
INSERT INTO ylmf_city_id_name VALUES('447','101090301','żҿ');
INSERT INTO ylmf_city_id_name VALUES('448','101090302','');
INSERT INTO ylmf_city_id_name VALUES('449','101090303','ű');
INSERT INTO ylmf_city_id_name VALUES('450','101090304','');
INSERT INTO ylmf_city_id_name VALUES('451','101090305','Դ');
INSERT INTO ylmf_city_id_name VALUES('452','101090306','');
INSERT INTO ylmf_city_id_name VALUES('453','101090307','ε');
INSERT INTO ylmf_city_id_name VALUES('454','101090308','ԭ');
INSERT INTO ylmf_city_id_name VALUES('455','101090309','');
INSERT INTO ylmf_city_id_name VALUES('456','101090310','ȫ');
INSERT INTO ylmf_city_id_name VALUES('457','101090311','');
INSERT INTO ylmf_city_id_name VALUES('458','101090312','¹');
INSERT INTO ylmf_city_id_name VALUES('459','101090313','');
INSERT INTO ylmf_city_id_name VALUES('460','101090314','');
INSERT INTO ylmf_city_id_name VALUES('461','101090401','е');
INSERT INTO ylmf_city_id_name VALUES('462','101090402','е');
INSERT INTO ylmf_city_id_name VALUES('463','101090403','е');
INSERT INTO ylmf_city_id_name VALUES('464','101090404','¡');
INSERT INTO ylmf_city_id_name VALUES('465','101090405','ƽȪ');
INSERT INTO ylmf_city_id_name VALUES('466','101090406','ƽ');
INSERT INTO ylmf_city_id_name VALUES('467','101090407','¡');
INSERT INTO ylmf_city_id_name VALUES('468','101090408','');
INSERT INTO ylmf_city_id_name VALUES('469','101090409','');
INSERT INTO ylmf_city_id_name VALUES('470','101090410','Χ');
INSERT INTO ylmf_city_id_name VALUES('471','101090411','');
INSERT INTO ylmf_city_id_name VALUES('472','101090501','ɽ');
INSERT INTO ylmf_city_id_name VALUES('473','101090502','');
INSERT INTO ylmf_city_id_name VALUES('474','101090503','');
INSERT INTO ylmf_city_id_name VALUES('475','101090504','');
INSERT INTO ylmf_city_id_name VALUES('476','101090505','');
INSERT INTO ylmf_city_id_name VALUES('477','101090506','ͤ');
INSERT INTO ylmf_city_id_name VALUES('478','101090507','Ǩ');
INSERT INTO ylmf_city_id_name VALUES('479','101090508','');
INSERT INTO ylmf_city_id_name VALUES('480','101090509','ƺ');
INSERT INTO ylmf_city_id_name VALUES('481','101090510','');
INSERT INTO ylmf_city_id_name VALUES('482','101090511','Ǩ');
INSERT INTO ylmf_city_id_name VALUES('483','101090601','ȷ');
INSERT INTO ylmf_city_id_name VALUES('484','101090602','̰');
INSERT INTO ylmf_city_id_name VALUES('485','101090603','');
INSERT INTO ylmf_city_id_name VALUES('486','101090604','');
INSERT INTO ylmf_city_id_name VALUES('487','101090605','');
INSERT INTO ylmf_city_id_name VALUES('488','101090606','İ');
INSERT INTO ylmf_city_id_name VALUES('489','101090607','');
INSERT INTO ylmf_city_id_name VALUES('490','101090608','');
INSERT INTO ylmf_city_id_name VALUES('491','101090609','');
INSERT INTO ylmf_city_id_name VALUES('492','101090701','');
INSERT INTO ylmf_city_id_name VALUES('493','101090702','');
INSERT INTO ylmf_city_id_name VALUES('494','101090703','');
INSERT INTO ylmf_city_id_name VALUES('495','101090704','');
INSERT INTO ylmf_city_id_name VALUES('496','101090705','ɽ');
INSERT INTO ylmf_city_id_name VALUES('497','101090706','');
INSERT INTO ylmf_city_id_name VALUES('498','101090707','Ƥ');
INSERT INTO ylmf_city_id_name VALUES('499','101090708','');
INSERT INTO ylmf_city_id_name VALUES('500','101090709','');
INSERT INTO ylmf_city_id_name VALUES('501','101090710','ϴ');
INSERT INTO ylmf_city_id_name VALUES('502','101090711','ͷ');
INSERT INTO ylmf_city_id_name VALUES('503','101090712','');
INSERT INTO ylmf_city_id_name VALUES('504','101090713','');
INSERT INTO ylmf_city_id_name VALUES('505','101090714','Ӽ');
INSERT INTO ylmf_city_id_name VALUES('506','101090801','ˮ');
INSERT INTO ylmf_city_id_name VALUES('507','101090802','ǿ');
INSERT INTO ylmf_city_id_name VALUES('508','101090803','');
INSERT INTO ylmf_city_id_name VALUES('509','101090804','ǿ');
INSERT INTO ylmf_city_id_name VALUES('510','101090805','');
INSERT INTO ylmf_city_id_name VALUES('511','101090806','ƽ');
INSERT INTO ylmf_city_id_name VALUES('512','101090807','ʳ');
INSERT INTO ylmf_city_id_name VALUES('513','101090808','');
INSERT INTO ylmf_city_id_name VALUES('514','101090809','');
INSERT INTO ylmf_city_id_name VALUES('515','101090810','');
INSERT INTO ylmf_city_id_name VALUES('516','101090811','');
INSERT INTO ylmf_city_id_name VALUES('517','101090901','̨');
INSERT INTO ylmf_city_id_name VALUES('518','101090902','ٳ');
INSERT INTO ylmf_city_id_name VALUES('519','101090903','̨ؽˮ');
INSERT INTO ylmf_city_id_name VALUES('520','101090904','');
INSERT INTO ylmf_city_id_name VALUES('521','101090905','');
INSERT INTO ylmf_city_id_name VALUES('522','101090906','¡Ң');
INSERT INTO ylmf_city_id_name VALUES('523','101090907','Ϻ');
INSERT INTO ylmf_city_id_name VALUES('524','101090908','');
INSERT INTO ylmf_city_id_name VALUES('525','101090909','¹');
INSERT INTO ylmf_city_id_name VALUES('526','101090910','º');
INSERT INTO ylmf_city_id_name VALUES('527','101090911','');
INSERT INTO ylmf_city_id_name VALUES('528','101090912','ƽ');
INSERT INTO ylmf_city_id_name VALUES('529','101090913','');
INSERT INTO ylmf_city_id_name VALUES('530','101090914','');
INSERT INTO ylmf_city_id_name VALUES('531','101090915','');
INSERT INTO ylmf_city_id_name VALUES('532','101090916','Ϲ');
INSERT INTO ylmf_city_id_name VALUES('533','101090917','ɳ');
INSERT INTO ylmf_city_id_name VALUES('534','101090918','');
INSERT INTO ylmf_city_id_name VALUES('535','101091001','');
INSERT INTO ylmf_city_id_name VALUES('536','101091002','');
INSERT INTO ylmf_city_id_name VALUES('537','101091003','');
INSERT INTO ylmf_city_id_name VALUES('538','101091004','ɰ');
INSERT INTO ylmf_city_id_name VALUES('539','101091005','');
INSERT INTO ylmf_city_id_name VALUES('540','101091006','');
INSERT INTO ylmf_city_id_name VALUES('541','101091007','');
INSERT INTO ylmf_city_id_name VALUES('542','101091008','');
INSERT INTO ylmf_city_id_name VALUES('543','101091009','');
INSERT INTO ylmf_city_id_name VALUES('544','101091010','');
INSERT INTO ylmf_city_id_name VALUES('545','101091011','');
INSERT INTO ylmf_city_id_name VALUES('546','101091012','ƽ');
INSERT INTO ylmf_city_id_name VALUES('547','101091013','');
INSERT INTO ylmf_city_id_name VALUES('548','101091014','κ');
INSERT INTO ylmf_city_id_name VALUES('549','101091015','');
INSERT INTO ylmf_city_id_name VALUES('550','101091016','䰲');
INSERT INTO ylmf_city_id_name VALUES('551','101091101','ػʵ');
INSERT INTO ylmf_city_id_name VALUES('552','101091102','');
INSERT INTO ylmf_city_id_name VALUES('553','101091103','');
INSERT INTO ylmf_city_id_name VALUES('554','101091104','');
INSERT INTO ylmf_city_id_name VALUES('555','101091105','¬');
INSERT INTO ylmf_city_id_name VALUES('556','101100101','̫ԭ');
INSERT INTO ylmf_city_id_name VALUES('557','101100102','');
INSERT INTO ylmf_city_id_name VALUES('558','101100103','');
INSERT INTO ylmf_city_id_name VALUES('559','101100104','¦');
INSERT INTO ylmf_city_id_name VALUES('560','101100105','̫ԭŽ');
INSERT INTO ylmf_city_id_name VALUES('561','101100106','̫ԭ');
INSERT INTO ylmf_city_id_name VALUES('562','101100107','̫ԭϽ');
INSERT INTO ylmf_city_id_name VALUES('563','101100201','ͬ');
INSERT INTO ylmf_city_id_name VALUES('564','101100202','');
INSERT INTO ylmf_city_id_name VALUES('565','101100203','ͬ');
INSERT INTO ylmf_city_id_name VALUES('566','101100204','');
INSERT INTO ylmf_city_id_name VALUES('567','101100205','');
INSERT INTO ylmf_city_id_name VALUES('568','101100206','');
INSERT INTO ylmf_city_id_name VALUES('569','101100207','Դ');
INSERT INTO ylmf_city_id_name VALUES('570','101100208','');
INSERT INTO ylmf_city_id_name VALUES('571','101100301','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('572','101100302','');
INSERT INTO ylmf_city_id_name VALUES('573','101100303','ƽ');
INSERT INTO ylmf_city_id_name VALUES('574','101100401','');
INSERT INTO ylmf_city_id_name VALUES('575','101100402','ܴ');
INSERT INTO ylmf_city_id_name VALUES('576','101100403','');
INSERT INTO ylmf_city_id_name VALUES('577','101100404','Ȩ');
INSERT INTO ylmf_city_id_name VALUES('578','101100405','˳');
INSERT INTO ylmf_city_id_name VALUES('579','101100406','');
INSERT INTO ylmf_city_id_name VALUES('580','101100407','');
INSERT INTO ylmf_city_id_name VALUES('581','101100408','̫');
INSERT INTO ylmf_city_id_name VALUES('582','101100409','');
INSERT INTO ylmf_city_id_name VALUES('583','101100411','ʯ');
INSERT INTO ylmf_city_id_name VALUES('584','101100412','');
INSERT INTO ylmf_city_id_name VALUES('585','101100501','');
INSERT INTO ylmf_city_id_name VALUES('586','101100502','');
INSERT INTO ylmf_city_id_name VALUES('587','101100503','');
INSERT INTO ylmf_city_id_name VALUES('588','101100504','º');
INSERT INTO ylmf_city_id_name VALUES('589','101100505','ԫ');
INSERT INTO ylmf_city_id_name VALUES('590','101100506','ƽ˳');
INSERT INTO ylmf_city_id_name VALUES('591','101100507','');
INSERT INTO ylmf_city_id_name VALUES('592','101100508','');
INSERT INTO ylmf_city_id_name VALUES('593','101100509','');
INSERT INTO ylmf_city_id_name VALUES('594','101100510','Դ');
INSERT INTO ylmf_city_id_name VALUES('595','101100511','');
INSERT INTO ylmf_city_id_name VALUES('596','101100601','');
INSERT INTO ylmf_city_id_name VALUES('597','101100602','ˮ');
INSERT INTO ylmf_city_id_name VALUES('598','101100603','');
INSERT INTO ylmf_city_id_name VALUES('599','101100604','괨');
INSERT INTO ylmf_city_id_name VALUES('600','101100605','ƽ');
INSERT INTO ylmf_city_id_name VALUES('601','101100701','ٷ');
INSERT INTO ylmf_city_id_name VALUES('602','101100702','');
INSERT INTO ylmf_city_id_name VALUES('603','101100703','');
INSERT INTO ylmf_city_id_name VALUES('604','101100704','');
INSERT INTO ylmf_city_id_name VALUES('605','101100705','');
INSERT INTO ylmf_city_id_name VALUES('606','101100706','');
INSERT INTO ylmf_city_id_name VALUES('607','101100707','');
INSERT INTO ylmf_city_id_name VALUES('608','101100708','');
INSERT INTO ylmf_city_id_name VALUES('609','101100709','');
INSERT INTO ylmf_city_id_name VALUES('610','101100710','鶴');
INSERT INTO ylmf_city_id_name VALUES('611','101100711','');
INSERT INTO ylmf_city_id_name VALUES('612','101100712','');
INSERT INTO ylmf_city_id_name VALUES('613','101100713','');
INSERT INTO ylmf_city_id_name VALUES('614','101100714','');
INSERT INTO ylmf_city_id_name VALUES('615','101100715','ɽ');
INSERT INTO ylmf_city_id_name VALUES('616','101100716','');
INSERT INTO ylmf_city_id_name VALUES('617','101100717','');
INSERT INTO ylmf_city_id_name VALUES('618','101100801','˳');
INSERT INTO ylmf_city_id_name VALUES('619','101100802','');
INSERT INTO ylmf_city_id_name VALUES('620','101100803','ɽ');
INSERT INTO ylmf_city_id_name VALUES('621','101100804','');
INSERT INTO ylmf_city_id_name VALUES('622','101100805','ӽ');
INSERT INTO ylmf_city_id_name VALUES('623','101100806','');
INSERT INTO ylmf_city_id_name VALUES('624','101100807','');
INSERT INTO ylmf_city_id_name VALUES('625','101100808','ϲ');
INSERT INTO ylmf_city_id_name VALUES('626','101100809','ԫ');
INSERT INTO ylmf_city_id_name VALUES('627','101100810','');
INSERT INTO ylmf_city_id_name VALUES('628','101100811','ǳ');
INSERT INTO ylmf_city_id_name VALUES('629','101100812','');
INSERT INTO ylmf_city_id_name VALUES('630','101100813','ƽ½');
INSERT INTO ylmf_city_id_name VALUES('631','101100901','˷');
INSERT INTO ylmf_city_id_name VALUES('632','101100902','ƽ³');
INSERT INTO ylmf_city_id_name VALUES('633','101100903','ɽ');
INSERT INTO ylmf_city_id_name VALUES('634','101100904','');
INSERT INTO ylmf_city_id_name VALUES('635','101100905','Ӧ');
INSERT INTO ylmf_city_id_name VALUES('636','101100906','');
INSERT INTO ylmf_city_id_name VALUES('637','101101001','');
INSERT INTO ylmf_city_id_name VALUES('638','101101002','');
INSERT INTO ylmf_city_id_name VALUES('639','101101003','̨ض');
INSERT INTO ylmf_city_id_name VALUES('640','101101004','');
INSERT INTO ylmf_city_id_name VALUES('641','101101005','ƫ');
INSERT INTO ylmf_city_id_name VALUES('642','101101006','');
INSERT INTO ylmf_city_id_name VALUES('643','101101007','');
INSERT INTO ylmf_city_id_name VALUES('644','101101008','');
INSERT INTO ylmf_city_id_name VALUES('645','101101009','');
INSERT INTO ylmf_city_id_name VALUES('646','101101010','̨ɽ');
INSERT INTO ylmf_city_id_name VALUES('647','101101011','');
INSERT INTO ylmf_city_id_name VALUES('648','101101012','');
INSERT INTO ylmf_city_id_name VALUES('649','101101013','');
INSERT INTO ylmf_city_id_name VALUES('650','101101014','կ');
INSERT INTO ylmf_city_id_name VALUES('651','101101015','ԭƽ');
INSERT INTO ylmf_city_id_name VALUES('652','101101101','ʯ');
INSERT INTO ylmf_city_id_name VALUES('653','101101102','');
INSERT INTO ylmf_city_id_name VALUES('654','101101103','');
INSERT INTO ylmf_city_id_name VALUES('655','101101104','');
INSERT INTO ylmf_city_id_name VALUES('656','101101105','');
INSERT INTO ylmf_city_id_name VALUES('657','101101106','ʯ¥');
INSERT INTO ylmf_city_id_name VALUES('658','101101107','ɽ');
INSERT INTO ylmf_city_id_name VALUES('659','101101108','');
INSERT INTO ylmf_city_id_name VALUES('660','101101109','');
INSERT INTO ylmf_city_id_name VALUES('661','101101110','Т');
INSERT INTO ylmf_city_id_name VALUES('662','101101111','');
INSERT INTO ylmf_city_id_name VALUES('663','101101112','ˮ');
INSERT INTO ylmf_city_id_name VALUES('664','101101113','');
INSERT INTO ylmf_city_id_name VALUES('665','101110101','');
INSERT INTO ylmf_city_id_name VALUES('666','101110102','');
INSERT INTO ylmf_city_id_name VALUES('667','101110103','');
INSERT INTO ylmf_city_id_name VALUES('668','101110104','');
INSERT INTO ylmf_city_id_name VALUES('669','101110105','');
INSERT INTO ylmf_city_id_name VALUES('670','101110106','');
INSERT INTO ylmf_city_id_name VALUES('671','101110107','');
INSERT INTO ylmf_city_id_name VALUES('672','101110200','');
INSERT INTO ylmf_city_id_name VALUES('673','101110201','ԭ');
INSERT INTO ylmf_city_id_name VALUES('674','101110202','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('675','101110203','');
INSERT INTO ylmf_city_id_name VALUES('676','101110204','');
INSERT INTO ylmf_city_id_name VALUES('677','101110205','');
INSERT INTO ylmf_city_id_name VALUES('678','101110206','书');
INSERT INTO ylmf_city_id_name VALUES('679','101110207','Ǭ');
INSERT INTO ylmf_city_id_name VALUES('680','101110208','');
INSERT INTO ylmf_city_id_name VALUES('681','101110209','');
INSERT INTO ylmf_city_id_name VALUES('682','101110210','Ѯ');
INSERT INTO ylmf_city_id_name VALUES('683','101110211','ƽ');
INSERT INTO ylmf_city_id_name VALUES('684','101110300','Ӱ');
INSERT INTO ylmf_city_id_name VALUES('685','101110302','Ӵ');
INSERT INTO ylmf_city_id_name VALUES('686','101110303','ӳ');
INSERT INTO ylmf_city_id_name VALUES('687','101110301','ӳ');
INSERT INTO ylmf_city_id_name VALUES('688','101110304','˴');
INSERT INTO ylmf_city_id_name VALUES('689','101110305','');
INSERT INTO ylmf_city_id_name VALUES('690','101110306','־');
INSERT INTO ylmf_city_id_name VALUES('691','101110307','');
INSERT INTO ylmf_city_id_name VALUES('692','101110308','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('693','101110309','崨');
INSERT INTO ylmf_city_id_name VALUES('694','101110310','');
INSERT INTO ylmf_city_id_name VALUES('695','101110311','');
INSERT INTO ylmf_city_id_name VALUES('696','101110312','');
INSERT INTO ylmf_city_id_name VALUES('697','101110401','');
INSERT INTO ylmf_city_id_name VALUES('698','101110402','');
INSERT INTO ylmf_city_id_name VALUES('699','101110403','ľ');
INSERT INTO ylmf_city_id_name VALUES('700','101110404','');
INSERT INTO ylmf_city_id_name VALUES('701','101110405','');
INSERT INTO ylmf_city_id_name VALUES('702','101110406','');
INSERT INTO ylmf_city_id_name VALUES('703','101110407','ɽ');
INSERT INTO ylmf_city_id_name VALUES('704','101110408','֬');
INSERT INTO ylmf_city_id_name VALUES('705','101110409','');
INSERT INTO ylmf_city_id_name VALUES('706','101110410','');
INSERT INTO ylmf_city_id_name VALUES('707','101110411','Ɽ');
INSERT INTO ylmf_city_id_name VALUES('708','101110412','彧');
INSERT INTO ylmf_city_id_name VALUES('709','101110501','μ');
INSERT INTO ylmf_city_id_name VALUES('710','101110502','');
INSERT INTO ylmf_city_id_name VALUES('711','101110503','');
INSERT INTO ylmf_city_id_name VALUES('712','101110504','');
INSERT INTO ylmf_city_id_name VALUES('713','101110505','ˮ');
INSERT INTO ylmf_city_id_name VALUES('714','101110506','ƽ');
INSERT INTO ylmf_city_id_name VALUES('715','101110507','ѳ');
INSERT INTO ylmf_city_id_name VALUES('716','101110508','γ');
INSERT INTO ylmf_city_id_name VALUES('717','101110509','');
INSERT INTO ylmf_city_id_name VALUES('718','101110510','');
INSERT INTO ylmf_city_id_name VALUES('719','101110511','');
INSERT INTO ylmf_city_id_name VALUES('720','101110512','ɽ');
INSERT INTO ylmf_city_id_name VALUES('721','101110601','');
INSERT INTO ylmf_city_id_name VALUES('722','101110602','');
INSERT INTO ylmf_city_id_name VALUES('723','101110603','ˮ');
INSERT INTO ylmf_city_id_name VALUES('724','101110605','');
INSERT INTO ylmf_city_id_name VALUES('725','101110606','');
INSERT INTO ylmf_city_id_name VALUES('726','101110607','');
INSERT INTO ylmf_city_id_name VALUES('727','101110608','ɽ');
INSERT INTO ylmf_city_id_name VALUES('728','101110701','');
INSERT INTO ylmf_city_id_name VALUES('729','101110702','');
INSERT INTO ylmf_city_id_name VALUES('730','101110703','ʯȪ');
INSERT INTO ylmf_city_id_name VALUES('731','101110704','');
INSERT INTO ylmf_city_id_name VALUES('732','101110705','Ѯ');
INSERT INTO ylmf_city_id_name VALUES('733','101110706','᰸');
INSERT INTO ylmf_city_id_name VALUES('734','101110707','ƽ');
INSERT INTO ylmf_city_id_name VALUES('735','101110708','׺');
INSERT INTO ylmf_city_id_name VALUES('736','101110709','ƺ');
INSERT INTO ylmf_city_id_name VALUES('737','101110710','');
INSERT INTO ylmf_city_id_name VALUES('738','101110801','');
INSERT INTO ylmf_city_id_name VALUES('739','101110802','');
INSERT INTO ylmf_city_id_name VALUES('740','101110803','');
INSERT INTO ylmf_city_id_name VALUES('741','101110804','');
INSERT INTO ylmf_city_id_name VALUES('742','101110805','');
INSERT INTO ylmf_city_id_name VALUES('743','101110806','ǹ');
INSERT INTO ylmf_city_id_name VALUES('744','101110807','');
INSERT INTO ylmf_city_id_name VALUES('745','101110808','ƺ');
INSERT INTO ylmf_city_id_name VALUES('746','101110809','ǿ');
INSERT INTO ylmf_city_id_name VALUES('747','101110810','֣');
INSERT INTO ylmf_city_id_name VALUES('748','101110811','');
INSERT INTO ylmf_city_id_name VALUES('749','101110901','');
INSERT INTO ylmf_city_id_name VALUES('750','101110902','');
INSERT INTO ylmf_city_id_name VALUES('751','101110903','ǧ');
INSERT INTO ylmf_city_id_name VALUES('752','101110904','');
INSERT INTO ylmf_city_id_name VALUES('753','101110905','ɽ');
INSERT INTO ylmf_city_id_name VALUES('754','101110906','');
INSERT INTO ylmf_city_id_name VALUES('755','101110907','');
INSERT INTO ylmf_city_id_name VALUES('756','101110908','ü');
INSERT INTO ylmf_city_id_name VALUES('757','101110909','̫');
INSERT INTO ylmf_city_id_name VALUES('758','101110910','');
INSERT INTO ylmf_city_id_name VALUES('759','101110911','¤');
INSERT INTO ylmf_city_id_name VALUES('760','101111001','ͭ');
INSERT INTO ylmf_city_id_name VALUES('761','101111002','ҫ');
INSERT INTO ylmf_city_id_name VALUES('762','101111003','˾');
INSERT INTO ylmf_city_id_name VALUES('763','101120101','');
INSERT INTO ylmf_city_id_name VALUES('764','101120102','');
INSERT INTO ylmf_city_id_name VALUES('765','101120103','̺');
INSERT INTO ylmf_city_id_name VALUES('766','101120104','');
INSERT INTO ylmf_city_id_name VALUES('767','101120105','ƽ');
INSERT INTO ylmf_city_id_name VALUES('768','101120106','');
INSERT INTO ylmf_city_id_name VALUES('769','101120201','ൺ');
INSERT INTO ylmf_city_id_name VALUES('770','101120202','ɽ');
INSERT INTO ylmf_city_id_name VALUES('771','101120203','');
INSERT INTO ylmf_city_id_name VALUES('772','101120204','ī');
INSERT INTO ylmf_city_id_name VALUES('773','101120205','');
INSERT INTO ylmf_city_id_name VALUES('774','101120206','');
INSERT INTO ylmf_city_id_name VALUES('775','101120207','');
INSERT INTO ylmf_city_id_name VALUES('776','101120208','ƽ');
INSERT INTO ylmf_city_id_name VALUES('777','101120301','Ͳ');
INSERT INTO ylmf_city_id_name VALUES('778','101120302','ʹ');
INSERT INTO ylmf_city_id_name VALUES('779','101120303','ɽ');
INSERT INTO ylmf_city_id_name VALUES('780','101120304','');
INSERT INTO ylmf_city_id_name VALUES('781','101120305','ܴ');
INSERT INTO ylmf_city_id_name VALUES('782','101120306','Դ');
INSERT INTO ylmf_city_id_name VALUES('783','101120307','̨');
INSERT INTO ylmf_city_id_name VALUES('784','101120308','');
INSERT INTO ylmf_city_id_name VALUES('785','101120401','');
INSERT INTO ylmf_city_id_name VALUES('786','101120402','');
INSERT INTO ylmf_city_id_name VALUES('787','101120403','');
INSERT INTO ylmf_city_id_name VALUES('788','101120404','');
INSERT INTO ylmf_city_id_name VALUES('789','101120405','');
INSERT INTO ylmf_city_id_name VALUES('790','101120406','');
INSERT INTO ylmf_city_id_name VALUES('791','101120407','');
INSERT INTO ylmf_city_id_name VALUES('792','101120408','ƽԭ');
INSERT INTO ylmf_city_id_name VALUES('793','101120409','');
INSERT INTO ylmf_city_id_name VALUES('794','101120410','Ľ');
INSERT INTO ylmf_city_id_name VALUES('795','101120411','');
INSERT INTO ylmf_city_id_name VALUES('796','101120501','̨');
INSERT INTO ylmf_city_id_name VALUES('797','101120502','');
INSERT INTO ylmf_city_id_name VALUES('798','101120503','');
INSERT INTO ylmf_city_id_name VALUES('799','101120504','');
INSERT INTO ylmf_city_id_name VALUES('800','101120505','');
INSERT INTO ylmf_city_id_name VALUES('801','101120506','Զ');
INSERT INTO ylmf_city_id_name VALUES('802','101120507','ϼ');
INSERT INTO ylmf_city_id_name VALUES('803','101120508','ɽ');
INSERT INTO ylmf_city_id_name VALUES('804','101120509','Ĳƽ');
INSERT INTO ylmf_city_id_name VALUES('805','101120510','');
INSERT INTO ylmf_city_id_name VALUES('806','101120511','');
INSERT INTO ylmf_city_id_name VALUES('807','101120512','ǧ');
INSERT INTO ylmf_city_id_name VALUES('808','101120601','Ϋ');
INSERT INTO ylmf_city_id_name VALUES('809','101120602','');
INSERT INTO ylmf_city_id_name VALUES('810','101120603','ٹ');
INSERT INTO ylmf_city_id_name VALUES('811','101120604','');
INSERT INTO ylmf_city_id_name VALUES('812','101120605','');
INSERT INTO ylmf_city_id_name VALUES('813','101120606','');
INSERT INTO ylmf_city_id_name VALUES('814','101120607','');
INSERT INTO ylmf_city_id_name VALUES('815','101120608','');
INSERT INTO ylmf_city_id_name VALUES('816','101120609','');
INSERT INTO ylmf_city_id_name VALUES('817','101120701','');
INSERT INTO ylmf_city_id_name VALUES('818','101120702','');
INSERT INTO ylmf_city_id_name VALUES('819','101120703','΢ɽ');
INSERT INTO ylmf_city_id_name VALUES('820','101120704','̨');
INSERT INTO ylmf_city_id_name VALUES('821','101120705','');
INSERT INTO ylmf_city_id_name VALUES('822','101120706','');
INSERT INTO ylmf_city_id_name VALUES('823','101120707','');
INSERT INTO ylmf_city_id_name VALUES('824','101120708','ˮ');
INSERT INTO ylmf_city_id_name VALUES('825','101120709','ɽ');
INSERT INTO ylmf_city_id_name VALUES('826','101120710','');
INSERT INTO ylmf_city_id_name VALUES('827','101120711','޳');
INSERT INTO ylmf_city_id_name VALUES('828','101120801','̩');
INSERT INTO ylmf_city_id_name VALUES('829','101120802','̩');
INSERT INTO ylmf_city_id_name VALUES('830','101120803','̩ɽ');
INSERT INTO ylmf_city_id_name VALUES('831','101120804','ʳ');
INSERT INTO ylmf_city_id_name VALUES('832','101120805','ƽ');
INSERT INTO ylmf_city_id_name VALUES('833','101120806','');
INSERT INTO ylmf_city_id_name VALUES('834','101120901','');
INSERT INTO ylmf_city_id_name VALUES('835','101120902','');
INSERT INTO ylmf_city_id_name VALUES('836','101120903','');
INSERT INTO ylmf_city_id_name VALUES('837','101120904','ɽ');
INSERT INTO ylmf_city_id_name VALUES('838','101120905','');
INSERT INTO ylmf_city_id_name VALUES('839','101120906','۰');
INSERT INTO ylmf_city_id_name VALUES('840','101120907','');
INSERT INTO ylmf_city_id_name VALUES('841','101120908','ƽ');
INSERT INTO ylmf_city_id_name VALUES('842','101120909','');
INSERT INTO ylmf_city_id_name VALUES('843','101120910','ˮ');
INSERT INTO ylmf_city_id_name VALUES('844','101120911','վ');
INSERT INTO ylmf_city_id_name VALUES('845','101121001','');
INSERT INTO ylmf_city_id_name VALUES('846','101121002','۲');
INSERT INTO ylmf_city_id_name VALUES('847','101121003','۩');
INSERT INTO ylmf_city_id_name VALUES('848','101121004','');
INSERT INTO ylmf_city_id_name VALUES('849','101121005','');
INSERT INTO ylmf_city_id_name VALUES('850','101121006','Ұ');
INSERT INTO ylmf_city_id_name VALUES('851','101121007','');
INSERT INTO ylmf_city_id_name VALUES('852','101121008','');
INSERT INTO ylmf_city_id_name VALUES('853','101121009','');
INSERT INTO ylmf_city_id_name VALUES('854','101121101','');
INSERT INTO ylmf_city_id_name VALUES('855','101121102','');
INSERT INTO ylmf_city_id_name VALUES('856','101121103','');
INSERT INTO ylmf_city_id_name VALUES('857','101121104','');
INSERT INTO ylmf_city_id_name VALUES('858','101121105','');
INSERT INTO ylmf_city_id_name VALUES('859','101121106','մ');
INSERT INTO ylmf_city_id_name VALUES('860','101121107','ƽ');
INSERT INTO ylmf_city_id_name VALUES('861','101121201','Ӫ');
INSERT INTO ylmf_city_id_name VALUES('862','101121202','ӿ');
INSERT INTO ylmf_city_id_name VALUES('863','101121203','');
INSERT INTO ylmf_city_id_name VALUES('864','101121204','');
INSERT INTO ylmf_city_id_name VALUES('865','101121205','');
INSERT INTO ylmf_city_id_name VALUES('866','101121301','');
INSERT INTO ylmf_city_id_name VALUES('867','101121302','ĵ');
INSERT INTO ylmf_city_id_name VALUES('868','101121303','ٳ');
INSERT INTO ylmf_city_id_name VALUES('869','101121304','ɽ');
INSERT INTO ylmf_city_id_name VALUES('870','101121305','ɽͷ');
INSERT INTO ylmf_city_id_name VALUES('871','101121306','ʯ');
INSERT INTO ylmf_city_id_name VALUES('872','101121401','ׯ');
INSERT INTO ylmf_city_id_name VALUES('873','101121402','Ѧ');
INSERT INTO ylmf_city_id_name VALUES('874','101121403','ỳ');
INSERT INTO ylmf_city_id_name VALUES('875','101121404','̨ׯ');
INSERT INTO ylmf_city_id_name VALUES('876','101121405','');
INSERT INTO ylmf_city_id_name VALUES('877','101121501','');
INSERT INTO ylmf_city_id_name VALUES('878','101121502','');
INSERT INTO ylmf_city_id_name VALUES('879','101121503','');
INSERT INTO ylmf_city_id_name VALUES('880','101121601','');
INSERT INTO ylmf_city_id_name VALUES('881','101121701','ĳ');
INSERT INTO ylmf_city_id_name VALUES('882','101121702','');
INSERT INTO ylmf_city_id_name VALUES('883','101121703','');
INSERT INTO ylmf_city_id_name VALUES('884','101121704','');
INSERT INTO ylmf_city_id_name VALUES('885','101121705','ƽ');
INSERT INTO ylmf_city_id_name VALUES('886','101121706','');
INSERT INTO ylmf_city_id_name VALUES('887','101121707','');
INSERT INTO ylmf_city_id_name VALUES('888','101121708','');
INSERT INTO ylmf_city_id_name VALUES('889','101130101','³ľ');
INSERT INTO ylmf_city_id_name VALUES('890','101130102','̼Һ');
INSERT INTO ylmf_city_id_name VALUES('891','101130103','С');
INSERT INTO ylmf_city_id_name VALUES('892','101130104','̨');
INSERT INTO ylmf_city_id_name VALUES('893','101130105','');
INSERT INTO ylmf_city_id_name VALUES('894','101130106','ʮ䷿վ');
INSERT INTO ylmf_city_id_name VALUES('895','101130107','ɽ');
INSERT INTO ylmf_city_id_name VALUES('896','101130108','³ľվ');
INSERT INTO ylmf_city_id_name VALUES('897','101130109','');
INSERT INTO ylmf_city_id_name VALUES('898','101130201','');
INSERT INTO ylmf_city_id_name VALUES('899','101130301','ʯ');
INSERT INTO ylmf_city_id_name VALUES('900','101130302','̨');
INSERT INTO ylmf_city_id_name VALUES('901','101130303','Ī');
INSERT INTO ylmf_city_id_name VALUES('902','101130304','');
INSERT INTO ylmf_city_id_name VALUES('903','101130401','');
INSERT INTO ylmf_city_id_name VALUES('904','101130402','ͼ');
INSERT INTO ylmf_city_id_name VALUES('905','101130403','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('906','101130404','');
INSERT INTO ylmf_city_id_name VALUES('907','101130405','ľ');
INSERT INTO ylmf_city_id_name VALUES('908','101130406','̨');
INSERT INTO ylmf_city_id_name VALUES('909','101130407','˹');
INSERT INTO ylmf_city_id_name VALUES('910','101130408','ľ');
INSERT INTO ylmf_city_id_name VALUES('911','101130409','ɽ');
INSERT INTO ylmf_city_id_name VALUES('912','101130501','³');
INSERT INTO ylmf_city_id_name VALUES('913','101130502','пѷ');
INSERT INTO ylmf_city_id_name VALUES('914','101130503','³');
INSERT INTO ylmf_city_id_name VALUES('915','101130504','۷');
INSERT INTO ylmf_city_id_name VALUES('916','101130505','');
INSERT INTO ylmf_city_id_name VALUES('917','101130601','');
INSERT INTO ylmf_city_id_name VALUES('918','101130602','̨');
INSERT INTO ylmf_city_id_name VALUES('919','101130603','ξ');
INSERT INTO ylmf_city_id_name VALUES('920','101130604','Ǽ');
INSERT INTO ylmf_city_id_name VALUES('921','101130605','ĩ');
INSERT INTO ylmf_city_id_name VALUES('922','101130606',';');
INSERT INTO ylmf_city_id_name VALUES('923','101130607','');
INSERT INTO ylmf_city_id_name VALUES('924','101130608','˶');
INSERT INTO ylmf_city_id_name VALUES('925','101130609','ʲ');
INSERT INTO ylmf_city_id_name VALUES('926','101130610','³');
INSERT INTO ylmf_city_id_name VALUES('927','101130611','');
INSERT INTO ylmf_city_id_name VALUES('928','101130701','');
INSERT INTO ylmf_city_id_name VALUES('929','101130801','');
INSERT INTO ylmf_city_id_name VALUES('930','101130802','ʲ');
INSERT INTO ylmf_city_id_name VALUES('931','101130803','');
INSERT INTO ylmf_city_id_name VALUES('932','101130804','ݳ');
INSERT INTO ylmf_city_id_name VALUES('933','101130805','º');
INSERT INTO ylmf_city_id_name VALUES('934','101130806','ɳ');
INSERT INTO ylmf_city_id_name VALUES('935','101130807','⳵');
INSERT INTO ylmf_city_id_name VALUES('936','101130808','ƺ');
INSERT INTO ylmf_city_id_name VALUES('937','101130809','');
INSERT INTO ylmf_city_id_name VALUES('938','101130901','ʲ');
INSERT INTO ylmf_city_id_name VALUES('939','101130902','Ӣɳ');
INSERT INTO ylmf_city_id_name VALUES('940','101130903','ʲ');
INSERT INTO ylmf_city_id_name VALUES('941','101130904','');
INSERT INTO ylmf_city_id_name VALUES('942','101130905','ɯ');
INSERT INTO ylmf_city_id_name VALUES('943','101130906','Ҷ');
INSERT INTO ylmf_city_id_name VALUES('944','101130907','');
INSERT INTO ylmf_city_id_name VALUES('945','101130908','ͳ');
INSERT INTO ylmf_city_id_name VALUES('946','101130909','պ');
INSERT INTO ylmf_city_id_name VALUES('947','101130910','٤ʦ');
INSERT INTO ylmf_city_id_name VALUES('948','101131001','');
INSERT INTO ylmf_city_id_name VALUES('949','101131002','첼');
INSERT INTO ylmf_city_id_name VALUES('950','101131003','տ');
INSERT INTO ylmf_city_id_name VALUES('951','101131004','');
INSERT INTO ylmf_city_id_name VALUES('952','101131005','');
INSERT INTO ylmf_city_id_name VALUES('953','101131006','Դ');
INSERT INTO ylmf_city_id_name VALUES('954','101131007','');
INSERT INTO ylmf_city_id_name VALUES('955','101131008','ؿ˹');
INSERT INTO ylmf_city_id_name VALUES('956','101131009','');
INSERT INTO ylmf_city_id_name VALUES('957','101131010','˹');
INSERT INTO ylmf_city_id_name VALUES('958','101131101','');
INSERT INTO ylmf_city_id_name VALUES('959','101131102','ԣ');
INSERT INTO ylmf_city_id_name VALUES('960','101131103','');
INSERT INTO ylmf_city_id_name VALUES('961','101131104','Ͳ');
INSERT INTO ylmf_city_id_name VALUES('962','101131105','');
INSERT INTO ylmf_city_id_name VALUES('963','101131106','');
INSERT INTO ylmf_city_id_name VALUES('964','101131107','ɳ');
INSERT INTO ylmf_city_id_name VALUES('965','101131201','');
INSERT INTO ylmf_city_id_name VALUES('966','101131202','߳');
INSERT INTO ylmf_city_id_name VALUES('967','101131203','');
INSERT INTO ylmf_city_id_name VALUES('968','101131204','');
INSERT INTO ylmf_city_id_name VALUES('969','101131205','ë');
INSERT INTO ylmf_city_id_name VALUES('970','101131301','');
INSERT INTO ylmf_city_id_name VALUES('971','101131302','Ƥɽ');
INSERT INTO ylmf_city_id_name VALUES('972','101131303','');
INSERT INTO ylmf_city_id_name VALUES('973','101131304','ī');
INSERT INTO ylmf_city_id_name VALUES('974','101131305','');
INSERT INTO ylmf_city_id_name VALUES('975','101131306','');
INSERT INTO ylmf_city_id_name VALUES('976','101131307','');
INSERT INTO ylmf_city_id_name VALUES('977','101131401','̩');
INSERT INTO ylmf_city_id_name VALUES('978','101131402','ͺ');
INSERT INTO ylmf_city_id_name VALUES('979','101131403','һ');
INSERT INTO ylmf_city_id_name VALUES('980','101131404','ɽͷ');
INSERT INTO ylmf_city_id_name VALUES('981','101131405','ľ');
INSERT INTO ylmf_city_id_name VALUES('982','101131406','');
INSERT INTO ylmf_city_id_name VALUES('983','101131407','');
INSERT INTO ylmf_city_id_name VALUES('984','101131408','');
INSERT INTO ylmf_city_id_name VALUES('985','101131409','');
INSERT INTO ylmf_city_id_name VALUES('986','101131410','º');
INSERT INTO ylmf_city_id_name VALUES('987','101131501','ͼʲ');
INSERT INTO ylmf_city_id_name VALUES('988','101131502','ǡ');
INSERT INTO ylmf_city_id_name VALUES('989','101131503','');
INSERT INTO ylmf_city_id_name VALUES('990','101131504','');
INSERT INTO ylmf_city_id_name VALUES('991','101131505','¶');
INSERT INTO ylmf_city_id_name VALUES('992','101131601','');
INSERT INTO ylmf_city_id_name VALUES('993','101131602','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('994','101131603','');
INSERT INTO ylmf_city_id_name VALUES('995','101131606','ɽ');
INSERT INTO ylmf_city_id_name VALUES('996','101140101','');
INSERT INTO ylmf_city_id_name VALUES('997','101140102','');
INSERT INTO ylmf_city_id_name VALUES('998','101140103','ľ');
INSERT INTO ylmf_city_id_name VALUES('999','101140104','ī񹱿');
INSERT INTO ylmf_city_id_name VALUES('1000','101140201','տ');
INSERT INTO ylmf_city_id_name VALUES('1001','101140202','');
INSERT INTO ylmf_city_id_name VALUES('1002','101140203','ľ');
INSERT INTO ylmf_city_id_name VALUES('1003','101140204','ľ');
INSERT INTO ylmf_city_id_name VALUES('1004','101140205','');
INSERT INTO ylmf_city_id_name VALUES('1005','101140206','');
INSERT INTO ylmf_city_id_name VALUES('1006','101140207','');
INSERT INTO ylmf_city_id_name VALUES('1007','101140301','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1008','101140302','');
INSERT INTO ylmf_city_id_name VALUES('1009','101140303','');
INSERT INTO ylmf_city_id_name VALUES('1010','101140304','Ӳ');
INSERT INTO ylmf_city_id_name VALUES('1011','101140305','˿');
INSERT INTO ylmf_city_id_name VALUES('1012','101140306','');
INSERT INTO ylmf_city_id_name VALUES('1013','101140307','¡');
INSERT INTO ylmf_city_id_name VALUES('1014','101140401','֥');
INSERT INTO ylmf_city_id_name VALUES('1015','101140402','');
INSERT INTO ylmf_city_id_name VALUES('1016','101140403','');
INSERT INTO ylmf_city_id_name VALUES('1017','101140404','');
INSERT INTO ylmf_city_id_name VALUES('1018','101140501','');
INSERT INTO ylmf_city_id_name VALUES('1019','101140502','');
INSERT INTO ylmf_city_id_name VALUES('1020','101140503','');
INSERT INTO ylmf_city_id_name VALUES('1021','101140504','¡');
INSERT INTO ylmf_city_id_name VALUES('1022','101140505','');
INSERT INTO ylmf_city_id_name VALUES('1023','101140506','â');
INSERT INTO ylmf_city_id_name VALUES('1024','101140507','');
INSERT INTO ylmf_city_id_name VALUES('1025','101140601','');
INSERT INTO ylmf_city_id_name VALUES('1026','101140603','');
INSERT INTO ylmf_city_id_name VALUES('1027','101140604','');
INSERT INTO ylmf_city_id_name VALUES('1028','101140605','');
INSERT INTO ylmf_city_id_name VALUES('1029','101140606','');
INSERT INTO ylmf_city_id_name VALUES('1030','101140607','');
INSERT INTO ylmf_city_id_name VALUES('1031','101140701','');
INSERT INTO ylmf_city_id_name VALUES('1032','101140702','');
INSERT INTO ylmf_city_id_name VALUES('1033','101140703','');
INSERT INTO ylmf_city_id_name VALUES('1034','101140704','ʨȪ');
INSERT INTO ylmf_city_id_name VALUES('1035','101150101','');
INSERT INTO ylmf_city_id_name VALUES('1036','101150102','ͨ');
INSERT INTO ylmf_city_id_name VALUES('1037','101150103','Դ');
INSERT INTO ylmf_city_id_name VALUES('1038','101150104','');
INSERT INTO ylmf_city_id_name VALUES('1039','101150105','');
INSERT INTO ylmf_city_id_name VALUES('1040','101150106','');
INSERT INTO ylmf_city_id_name VALUES('1041','101150107','վ');
INSERT INTO ylmf_city_id_name VALUES('1042','101150201','');
INSERT INTO ylmf_city_id_name VALUES('1043','101150202','ֶ');
INSERT INTO ylmf_city_id_name VALUES('1044','101150203','');
INSERT INTO ylmf_city_id_name VALUES('1045','101150204','');
INSERT INTO ylmf_city_id_name VALUES('1046','101150205','¡');
INSERT INTO ylmf_city_id_name VALUES('1047','101150206','ѭ');
INSERT INTO ylmf_city_id_name VALUES('1048','101150207','');
INSERT INTO ylmf_city_id_name VALUES('1049','101150301','');
INSERT INTO ylmf_city_id_name VALUES('1050','101150302','');
INSERT INTO ylmf_city_id_name VALUES('1051','101150303','');
INSERT INTO ylmf_city_id_name VALUES('1052','101150401','');
INSERT INTO ylmf_city_id_name VALUES('1053','101150402','');
INSERT INTO ylmf_city_id_name VALUES('1054','101150404','');
INSERT INTO ylmf_city_id_name VALUES('1055','101150405','ӿ');
INSERT INTO ylmf_city_id_name VALUES('1056','101150406','˺');
INSERT INTO ylmf_city_id_name VALUES('1057','101150407','');
INSERT INTO ylmf_city_id_name VALUES('1058','101150408','ͬ');
INSERT INTO ylmf_city_id_name VALUES('1059','101150501','');
INSERT INTO ylmf_city_id_name VALUES('1060','101150502','');
INSERT INTO ylmf_city_id_name VALUES('1061','101150503','ʵ');
INSERT INTO ylmf_city_id_name VALUES('1062','101150504','');
INSERT INTO ylmf_city_id_name VALUES('1063','101150505','');
INSERT INTO ylmf_city_id_name VALUES('1064','101150506','');
INSERT INTO ylmf_city_id_name VALUES('1065','101150507','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1066','101150601','');
INSERT INTO ylmf_city_id_name VALUES('1067','101150602','к');
INSERT INTO ylmf_city_id_name VALUES('1068','101150603','ζ');
INSERT INTO ylmf_city_id_name VALUES('1069','101150604','Ӷ');
INSERT INTO ylmf_city_id_name VALUES('1070','101150605','ǫ');
INSERT INTO ylmf_city_id_name VALUES('1071','101150606','');
INSERT INTO ylmf_city_id_name VALUES('1072','101150701','');
INSERT INTO ylmf_city_id_name VALUES('1073','101150702','ľ');
INSERT INTO ylmf_city_id_name VALUES('1074','101150703','');
INSERT INTO ylmf_city_id_name VALUES('1075','101150704','Ұţ');
INSERT INTO ylmf_city_id_name VALUES('1076','101150705','');
INSERT INTO ylmf_city_id_name VALUES('1077','101150706','С');
INSERT INTO ylmf_city_id_name VALUES('1078','101150708','');
INSERT INTO ylmf_city_id_name VALUES('1079','101150709','');
INSERT INTO ylmf_city_id_name VALUES('1080','101150710','');
INSERT INTO ylmf_city_id_name VALUES('1081','101150711','ŵľ');
INSERT INTO ylmf_city_id_name VALUES('1082','101150712','ã');
INSERT INTO ylmf_city_id_name VALUES('1083','101150713','');
INSERT INTO ylmf_city_id_name VALUES('1084','101150714','迨');
INSERT INTO ylmf_city_id_name VALUES('1085','101150715','յ');
INSERT INTO ylmf_city_id_name VALUES('1086','101150801','');
INSERT INTO ylmf_city_id_name VALUES('1087','101150802','Դ');
INSERT INTO ylmf_city_id_name VALUES('1088','101150803','');
INSERT INTO ylmf_city_id_name VALUES('1089','101150804','');
INSERT INTO ylmf_city_id_name VALUES('1090','101150805','');
INSERT INTO ylmf_city_id_name VALUES('1091','101160101','');
INSERT INTO ylmf_city_id_name VALUES('1092','101160102','');
INSERT INTO ylmf_city_id_name VALUES('1093','101160103','');
INSERT INTO ylmf_city_id_name VALUES('1094','101160104','');
INSERT INTO ylmf_city_id_name VALUES('1095','101160201','');
INSERT INTO ylmf_city_id_name VALUES('1096','101160202','ͨμ');
INSERT INTO ylmf_city_id_name VALUES('1097','101160203','¤');
INSERT INTO ylmf_city_id_name VALUES('1098','101160204','μԴ');
INSERT INTO ylmf_city_id_name VALUES('1099','101160205','');
INSERT INTO ylmf_city_id_name VALUES('1100','101160206','');
INSERT INTO ylmf_city_id_name VALUES('1101','101160207','');
INSERT INTO ylmf_city_id_name VALUES('1102','101160301','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1103','101160302','');
INSERT INTO ylmf_city_id_name VALUES('1104','101160303','̨');
INSERT INTO ylmf_city_id_name VALUES('1105','101160304','');
INSERT INTO ylmf_city_id_name VALUES('1106','101160305','ͤ');
INSERT INTO ylmf_city_id_name VALUES('1107','101160306','ׯ');
INSERT INTO ylmf_city_id_name VALUES('1108','101160307','');
INSERT INTO ylmf_city_id_name VALUES('1109','101160401','');
INSERT INTO ylmf_city_id_name VALUES('1110','101160402','');
INSERT INTO ylmf_city_id_name VALUES('1111','101160403','');
INSERT INTO ylmf_city_id_name VALUES('1112','101160404','');
INSERT INTO ylmf_city_id_name VALUES('1113','101160405','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1114','101160406','');
INSERT INTO ylmf_city_id_name VALUES('1115','101160407','');
INSERT INTO ylmf_city_id_name VALUES('1116','101160408','ԭ');
INSERT INTO ylmf_city_id_name VALUES('1117','101160501','');
INSERT INTO ylmf_city_id_name VALUES('1118','101160502','');
INSERT INTO ylmf_city_id_name VALUES('1119','101160503','');
INSERT INTO ylmf_city_id_name VALUES('1120','101160504','');
INSERT INTO ylmf_city_id_name VALUES('1121','101160601','');
INSERT INTO ylmf_city_id_name VALUES('1122','101160602','');
INSERT INTO ylmf_city_id_name VALUES('1123','101160701','Ҵ');
INSERT INTO ylmf_city_id_name VALUES('1124','101160702','');
INSERT INTO ylmf_city_id_name VALUES('1125','101160703','');
INSERT INTO ylmf_city_id_name VALUES('1126','101160704','');
INSERT INTO ylmf_city_id_name VALUES('1127','101160705','̨');
INSERT INTO ylmf_city_id_name VALUES('1128','101160706','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1129','101160801','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('1130','101160802','');
INSERT INTO ylmf_city_id_name VALUES('1131','101160803','');
INSERT INTO ylmf_city_id_name VALUES('1132','101160804','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1133','101160805','');
INSERT INTO ylmf_city_id_name VALUES('1134','101160806','౱');
INSERT INTO ylmf_city_id_name VALUES('1135','101160807','');
INSERT INTO ylmf_city_id_name VALUES('1136','101160808','ػ');
INSERT INTO ylmf_city_id_name VALUES('1137','101160901','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1138','101160902','');
INSERT INTO ylmf_city_id_name VALUES('1139','101160903','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1140','101160904','ذ');
INSERT INTO ylmf_city_id_name VALUES('1141','101160905','ʹ');
INSERT INTO ylmf_city_id_name VALUES('1142','101160906','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1143','101160907','żҴ');
INSERT INTO ylmf_city_id_name VALUES('1144','101161001','䶼');
INSERT INTO ylmf_city_id_name VALUES('1145','101161002','');
INSERT INTO ylmf_city_id_name VALUES('1146','101161003','');
INSERT INTO ylmf_city_id_name VALUES('1147','101161004','崲');
INSERT INTO ylmf_city_id_name VALUES('1148','101161005','');
INSERT INTO ylmf_city_id_name VALUES('1149','101161006','');
INSERT INTO ylmf_city_id_name VALUES('1150','101161007','');
INSERT INTO ylmf_city_id_name VALUES('1151','101161008','');
INSERT INTO ylmf_city_id_name VALUES('1152','101161009','');
INSERT INTO ylmf_city_id_name VALUES('1153','101161101','');
INSERT INTO ylmf_city_id_name VALUES('1154','101161102','');
INSERT INTO ylmf_city_id_name VALUES('1155','101161103','');
INSERT INTO ylmf_city_id_name VALUES('1156','101161104','');
INSERT INTO ylmf_city_id_name VALUES('1157','101161105','');
INSERT INTO ylmf_city_id_name VALUES('1158','101161106','');
INSERT INTO ylmf_city_id_name VALUES('1159','101161201','');
INSERT INTO ylmf_city_id_name VALUES('1160','101161202','̶');
INSERT INTO ylmf_city_id_name VALUES('1161','101161203','׿');
INSERT INTO ylmf_city_id_name VALUES('1162','101161204','');
INSERT INTO ylmf_city_id_name VALUES('1163','101161205','');
INSERT INTO ylmf_city_id_name VALUES('1164','101161206','');
INSERT INTO ylmf_city_id_name VALUES('1165','101161207','µ');
INSERT INTO ylmf_city_id_name VALUES('1166','101161208','ĺ');
INSERT INTO ylmf_city_id_name VALUES('1167','101161301','');
INSERT INTO ylmf_city_id_name VALUES('1168','101161302','Զ');
INSERT INTO ylmf_city_id_name VALUES('1169','101161303','');
INSERT INTO ylmf_city_id_name VALUES('1170','101161304','');
INSERT INTO ylmf_city_id_name VALUES('1171','101161305','̩');
INSERT INTO ylmf_city_id_name VALUES('1172','101170101','');
INSERT INTO ylmf_city_id_name VALUES('1173','101170102','');
INSERT INTO ylmf_city_id_name VALUES('1174','101170103','');
INSERT INTO ylmf_city_id_name VALUES('1175','101170104','');
INSERT INTO ylmf_city_id_name VALUES('1176','101170201','ʯɽ');
INSERT INTO ylmf_city_id_name VALUES('1177','101170202','ũ');
INSERT INTO ylmf_city_id_name VALUES('1178','101170203','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1179','101170204','');
INSERT INTO ylmf_city_id_name VALUES('1180','101170205','ʯ̿');
INSERT INTO ylmf_city_id_name VALUES('1181','101170301','');
INSERT INTO ylmf_city_id_name VALUES('1182','101170302','ͬ');
INSERT INTO ylmf_city_id_name VALUES('1183','101170303','γ');
INSERT INTO ylmf_city_id_name VALUES('1184','101170304','Τ');
INSERT INTO ylmf_city_id_name VALUES('1185','101170305','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1186','101170306','ͭϿ');
INSERT INTO ylmf_city_id_name VALUES('1187','101170401','ԭ');
INSERT INTO ylmf_city_id_name VALUES('1188','101170402','');
INSERT INTO ylmf_city_id_name VALUES('1189','101170403','¡');
INSERT INTO ylmf_city_id_name VALUES('1190','101170404','Դ');
INSERT INTO ylmf_city_id_name VALUES('1191','101170405','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1192','101170501','');
INSERT INTO ylmf_city_id_name VALUES('1193','101170502','');
INSERT INTO ylmf_city_id_name VALUES('1194','101170503','ʱ');
INSERT INTO ylmf_city_id_name VALUES('1195','101170504','ԭ');
INSERT INTO ylmf_city_id_name VALUES('1196','101180101','֣');
INSERT INTO ylmf_city_id_name VALUES('1197','101180102','');
INSERT INTO ylmf_city_id_name VALUES('1198','101180103','');
INSERT INTO ylmf_city_id_name VALUES('1199','101180104','Ƿ');
INSERT INTO ylmf_city_id_name VALUES('1200','101180105','');
INSERT INTO ylmf_city_id_name VALUES('1201','101180106','֣');
INSERT INTO ylmf_city_id_name VALUES('1202','101180107','Ĳ');
INSERT INTO ylmf_city_id_name VALUES('1203','101180108','֣ũվ');
INSERT INTO ylmf_city_id_name VALUES('1204','101180201','');
INSERT INTO ylmf_city_id_name VALUES('1205','101180202','');
INSERT INTO ylmf_city_id_name VALUES('1206','101180203','');
INSERT INTO ylmf_city_id_name VALUES('1207','101180204','ڻ');
INSERT INTO ylmf_city_id_name VALUES('1208','101180205','');
INSERT INTO ylmf_city_id_name VALUES('1209','101180301','');
INSERT INTO ylmf_city_id_name VALUES('1210','101180302','');
INSERT INTO ylmf_city_id_name VALUES('1211','101180303','ԭ');
INSERT INTO ylmf_city_id_name VALUES('1212','101180304','');
INSERT INTO ylmf_city_id_name VALUES('1213','101180305','');
INSERT INTO ylmf_city_id_name VALUES('1214','101180306','ӽ');
INSERT INTO ylmf_city_id_name VALUES('1215','101180307','');
INSERT INTO ylmf_city_id_name VALUES('1216','101180308','ԫ');
INSERT INTO ylmf_city_id_name VALUES('1217','101180401','');
INSERT INTO ylmf_city_id_name VALUES('1218','101180402','۳');
INSERT INTO ylmf_city_id_name VALUES('1219','101180403','');
INSERT INTO ylmf_city_id_name VALUES('1220','101180404','');
INSERT INTO ylmf_city_id_name VALUES('1221','101180405','');
INSERT INTO ylmf_city_id_name VALUES('1222','101180501','ƽɽ');
INSERT INTO ylmf_city_id_name VALUES('1223','101180502','ۣ');
INSERT INTO ylmf_city_id_name VALUES('1224','101180503','');
INSERT INTO ylmf_city_id_name VALUES('1225','101180504','');
INSERT INTO ylmf_city_id_name VALUES('1226','101180505','Ҷ');
INSERT INTO ylmf_city_id_name VALUES('1227','101180506','');
INSERT INTO ylmf_city_id_name VALUES('1228','101180507','³ɽ');
INSERT INTO ylmf_city_id_name VALUES('1229','101180601','');
INSERT INTO ylmf_city_id_name VALUES('1230','101180602','Ϣ');
INSERT INTO ylmf_city_id_name VALUES('1231','101180603','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1232','101180604','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1233','101180605','');
INSERT INTO ylmf_city_id_name VALUES('1234','101180606','');
INSERT INTO ylmf_city_id_name VALUES('1235','101180607','괨');
INSERT INTO ylmf_city_id_name VALUES('1236','101180608','ʼ');
INSERT INTO ylmf_city_id_name VALUES('1237','101180609','̳');
INSERT INTO ylmf_city_id_name VALUES('1238','101180610','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1239','101180611','ũվ');
INSERT INTO ylmf_city_id_name VALUES('1240','101180701','');
INSERT INTO ylmf_city_id_name VALUES('1241','101180702','');
INSERT INTO ylmf_city_id_name VALUES('1242','101180703','');
INSERT INTO ylmf_city_id_name VALUES('1243','101180704','');
INSERT INTO ylmf_city_id_name VALUES('1244','101180705','Ͽ');
INSERT INTO ylmf_city_id_name VALUES('1245','101180706','');
INSERT INTO ylmf_city_id_name VALUES('1246','101180707','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1247','101180708','');
INSERT INTO ylmf_city_id_name VALUES('1248','101180709','Ұ');
INSERT INTO ylmf_city_id_name VALUES('1249','101180710','ƺ');
INSERT INTO ylmf_city_id_name VALUES('1250','101180711','');
INSERT INTO ylmf_city_id_name VALUES('1251','101180712','ͩ');
INSERT INTO ylmf_city_id_name VALUES('1252','101180801','');
INSERT INTO ylmf_city_id_name VALUES('1253','101180802','');
INSERT INTO ylmf_city_id_name VALUES('1254','101180803','ξ');
INSERT INTO ylmf_city_id_name VALUES('1255','101180804','ͨ');
INSERT INTO ylmf_city_id_name VALUES('1256','101180805','');
INSERT INTO ylmf_city_id_name VALUES('1257','101180901','');
INSERT INTO ylmf_city_id_name VALUES('1258','101180902','°');
INSERT INTO ylmf_city_id_name VALUES('1259','101180903','Ͻ');
INSERT INTO ylmf_city_id_name VALUES('1260','101180904','');
INSERT INTO ylmf_city_id_name VALUES('1261','101180905','');
INSERT INTO ylmf_city_id_name VALUES('1262','101180906','');
INSERT INTO ylmf_city_id_name VALUES('1263','101180907','');
INSERT INTO ylmf_city_id_name VALUES('1264','101180908','ʦ');
INSERT INTO ylmf_city_id_name VALUES('1265','101180909','ﴨ');
INSERT INTO ylmf_city_id_name VALUES('1266','101180910','');
INSERT INTO ylmf_city_id_name VALUES('1267','101181001','');
INSERT INTO ylmf_city_id_name VALUES('1268','101181002','');
INSERT INTO ylmf_city_id_name VALUES('1269','101181003','');
INSERT INTO ylmf_city_id_name VALUES('1270','101181004','Ȩ');
INSERT INTO ylmf_city_id_name VALUES('1271','101181005','ݳ');
INSERT INTO ylmf_city_id_name VALUES('1272','101181006','ϳ');
INSERT INTO ylmf_city_id_name VALUES('1273','101181007','');
INSERT INTO ylmf_city_id_name VALUES('1274','101181008','');
INSERT INTO ylmf_city_id_name VALUES('1275','101181009','');
INSERT INTO ylmf_city_id_name VALUES('1276','101181101','');
INSERT INTO ylmf_city_id_name VALUES('1277','101181102','');
INSERT INTO ylmf_city_id_name VALUES('1278','101181103','');
INSERT INTO ylmf_city_id_name VALUES('1279','101181104','');
INSERT INTO ylmf_city_id_name VALUES('1280','101181106','');
INSERT INTO ylmf_city_id_name VALUES('1281','101181107','');
INSERT INTO ylmf_city_id_name VALUES('1282','101181108','');
INSERT INTO ylmf_city_id_name VALUES('1283','101181201','ױ');
INSERT INTO ylmf_city_id_name VALUES('1284','101181202','');
INSERT INTO ylmf_city_id_name VALUES('1285','101181203','');
INSERT INTO ylmf_city_id_name VALUES('1286','101181301','');
INSERT INTO ylmf_city_id_name VALUES('1287','101181302','̨ǰ');
INSERT INTO ylmf_city_id_name VALUES('1288','101181303','');
INSERT INTO ylmf_city_id_name VALUES('1289','101181304','');
INSERT INTO ylmf_city_id_name VALUES('1290','101181305','');
INSERT INTO ylmf_city_id_name VALUES('1291','101181401','ܿ');
INSERT INTO ylmf_city_id_name VALUES('1292','101181402','');
INSERT INTO ylmf_city_id_name VALUES('1293','101181403','̫');
INSERT INTO ylmf_city_id_name VALUES('1294','101181404','');
INSERT INTO ylmf_city_id_name VALUES('1295','101181405','');
INSERT INTO ylmf_city_id_name VALUES('1296','101181406','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1297','101181407','');
INSERT INTO ylmf_city_id_name VALUES('1298','101181408','');
INSERT INTO ylmf_city_id_name VALUES('1299','101181409','¹');
INSERT INTO ylmf_city_id_name VALUES('1300','101181410','');
INSERT INTO ylmf_city_id_name VALUES('1301','101181411','Ʒ');
INSERT INTO ylmf_city_id_name VALUES('1302','101181501','');
INSERT INTO ylmf_city_id_name VALUES('1303','101181502','');
INSERT INTO ylmf_city_id_name VALUES('1304','101181503','');
INSERT INTO ylmf_city_id_name VALUES('1305','101181601','פ');
INSERT INTO ylmf_city_id_name VALUES('1306','101181602','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1307','101181603','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1308','101181604','ϲ');
INSERT INTO ylmf_city_id_name VALUES('1309','101181605','');
INSERT INTO ylmf_city_id_name VALUES('1310','101181606','');
INSERT INTO ylmf_city_id_name VALUES('1311','101181607','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1312','101181608','²');
INSERT INTO ylmf_city_id_name VALUES('1313','101181609','ȷɽ');
INSERT INTO ylmf_city_id_name VALUES('1314','101181610','');
INSERT INTO ylmf_city_id_name VALUES('1315','101181701','Ͽ');
INSERT INTO ylmf_city_id_name VALUES('1316','101181702','鱦');
INSERT INTO ylmf_city_id_name VALUES('1317','101181703','ų');
INSERT INTO ylmf_city_id_name VALUES('1318','101181704','¬');
INSERT INTO ylmf_city_id_name VALUES('1319','101181801','Դ');
INSERT INTO ylmf_city_id_name VALUES('1320','101190101','Ͼ');
INSERT INTO ylmf_city_id_name VALUES('1321','101190102','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1322','101190103','ߴ');
INSERT INTO ylmf_city_id_name VALUES('1323','101190104','');
INSERT INTO ylmf_city_id_name VALUES('1324','101190105','');
INSERT INTO ylmf_city_id_name VALUES('1325','101190106','');
INSERT INTO ylmf_city_id_name VALUES('1326','101190201','');
INSERT INTO ylmf_city_id_name VALUES('1327','101190202','');
INSERT INTO ylmf_city_id_name VALUES('1328','101190203','');
INSERT INTO ylmf_city_id_name VALUES('1329','101190301','');
INSERT INTO ylmf_city_id_name VALUES('1330','101190302','');
INSERT INTO ylmf_city_id_name VALUES('1331','101190303','');
INSERT INTO ylmf_city_id_name VALUES('1332','101190304','');
INSERT INTO ylmf_city_id_name VALUES('1333','101190305','ͽ');
INSERT INTO ylmf_city_id_name VALUES('1334','101190401','');
INSERT INTO ylmf_city_id_name VALUES('1335','101190402','');
INSERT INTO ylmf_city_id_name VALUES('1336','101190403','żҸ');
INSERT INTO ylmf_city_id_name VALUES('1337','101190404','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1338','101190405','ضɽ');
INSERT INTO ylmf_city_id_name VALUES('1339','101190406','');
INSERT INTO ylmf_city_id_name VALUES('1340','101190407','⽭');
INSERT INTO ylmf_city_id_name VALUES('1341','101190408','̫');
INSERT INTO ylmf_city_id_name VALUES('1342','101190501','ͨ');
INSERT INTO ylmf_city_id_name VALUES('1343','101190502','');
INSERT INTO ylmf_city_id_name VALUES('1344','101190503','');
INSERT INTO ylmf_city_id_name VALUES('1345','101190504','綫');
INSERT INTO ylmf_city_id_name VALUES('1346','101190505','');
INSERT INTO ylmf_city_id_name VALUES('1347','101190506','泡');
INSERT INTO ylmf_city_id_name VALUES('1348','101190507','');
INSERT INTO ylmf_city_id_name VALUES('1349','101190508','');
INSERT INTO ylmf_city_id_name VALUES('1350','101190601','');
INSERT INTO ylmf_city_id_name VALUES('1351','101190602','Ӧ');
INSERT INTO ylmf_city_id_name VALUES('1352','101190603','');
INSERT INTO ylmf_city_id_name VALUES('1353','101190604','');
INSERT INTO ylmf_city_id_name VALUES('1354','101190605','');
INSERT INTO ylmf_city_id_name VALUES('1355','101190606','');
INSERT INTO ylmf_city_id_name VALUES('1356','101190701','γ');
INSERT INTO ylmf_city_id_name VALUES('1357','101190702','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1358','101190703','');
INSERT INTO ylmf_city_id_name VALUES('1359','101190704','');
INSERT INTO ylmf_city_id_name VALUES('1360','101190705','');
INSERT INTO ylmf_city_id_name VALUES('1361','101190706','');
INSERT INTO ylmf_city_id_name VALUES('1362','101190707','̨');
INSERT INTO ylmf_city_id_name VALUES('1363','101190708','');
INSERT INTO ylmf_city_id_name VALUES('1364','101190709','ζ');
INSERT INTO ylmf_city_id_name VALUES('1365','101190801','');
INSERT INTO ylmf_city_id_name VALUES('1366','101190802','ũվ');
INSERT INTO ylmf_city_id_name VALUES('1367','101190803','');
INSERT INTO ylmf_city_id_name VALUES('1368','101190804','');
INSERT INTO ylmf_city_id_name VALUES('1369','101190805','');
INSERT INTO ylmf_city_id_name VALUES('1370','101190806','');
INSERT INTO ylmf_city_id_name VALUES('1371','101190807','');
INSERT INTO ylmf_city_id_name VALUES('1372','101190901','');
INSERT INTO ylmf_city_id_name VALUES('1373','101190902','');
INSERT INTO ylmf_city_id_name VALUES('1374','101190903','');
INSERT INTO ylmf_city_id_name VALUES('1375','101190904','');
INSERT INTO ylmf_city_id_name VALUES('1376','101190905','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1377','101190906','');
INSERT INTO ylmf_city_id_name VALUES('1378','101190907','');
INSERT INTO ylmf_city_id_name VALUES('1379','101191001','Ƹ');
INSERT INTO ylmf_city_id_name VALUES('1380','101191002','');
INSERT INTO ylmf_city_id_name VALUES('1381','101191003','');
INSERT INTO ylmf_city_id_name VALUES('1382','101191004','');
INSERT INTO ylmf_city_id_name VALUES('1383','101191005','');
INSERT INTO ylmf_city_id_name VALUES('1384','101191006','');
INSERT INTO ylmf_city_id_name VALUES('1385','101191007','β');
INSERT INTO ylmf_city_id_name VALUES('1386','101191101','');
INSERT INTO ylmf_city_id_name VALUES('1387','101191102','');
INSERT INTO ylmf_city_id_name VALUES('1388','101191103','̳');
INSERT INTO ylmf_city_id_name VALUES('1389','101191201','̩');
INSERT INTO ylmf_city_id_name VALUES('1390','101191202','˻');
INSERT INTO ylmf_city_id_name VALUES('1391','101191203','̩');
INSERT INTO ylmf_city_id_name VALUES('1392','101191204','');
INSERT INTO ylmf_city_id_name VALUES('1393','101191205','');
INSERT INTO ylmf_city_id_name VALUES('1394','101191301','Ǩ');
INSERT INTO ylmf_city_id_name VALUES('1395','101191302','');
INSERT INTO ylmf_city_id_name VALUES('1396','101191303','');
INSERT INTO ylmf_city_id_name VALUES('1397','101191304','');
INSERT INTO ylmf_city_id_name VALUES('1398','101200101','人');
INSERT INTO ylmf_city_id_name VALUES('1399','101200102','̵');
INSERT INTO ylmf_city_id_name VALUES('1400','101200103','');
INSERT INTO ylmf_city_id_name VALUES('1401','101200104','');
INSERT INTO ylmf_city_id_name VALUES('1402','101200105','');
INSERT INTO ylmf_city_id_name VALUES('1403','101200201','差');
INSERT INTO ylmf_city_id_name VALUES('1404','101200202','');
INSERT INTO ylmf_city_id_name VALUES('1405','101200203','');
INSERT INTO ylmf_city_id_name VALUES('1406','101200204','');
INSERT INTO ylmf_city_id_name VALUES('1407','101200205','˳');
INSERT INTO ylmf_city_id_name VALUES('1408','101200206','Ϻӿ');
INSERT INTO ylmf_city_id_name VALUES('1409','101200207','ȳ');
INSERT INTO ylmf_city_id_name VALUES('1410','101200208','');
INSERT INTO ylmf_city_id_name VALUES('1411','101200301','');
INSERT INTO ylmf_city_id_name VALUES('1412','101200401','Т');
INSERT INTO ylmf_city_id_name VALUES('1413','101200402','½');
INSERT INTO ylmf_city_id_name VALUES('1414','101200403','');
INSERT INTO ylmf_city_id_name VALUES('1415','101200404','');
INSERT INTO ylmf_city_id_name VALUES('1416','101200405','Ӧ');
INSERT INTO ylmf_city_id_name VALUES('1417','101200406','');
INSERT INTO ylmf_city_id_name VALUES('1418','101200501','Ƹ');
INSERT INTO ylmf_city_id_name VALUES('1419','101200502','찲');
INSERT INTO ylmf_city_id_name VALUES('1420','101200503','');
INSERT INTO ylmf_city_id_name VALUES('1421','101200504','');
INSERT INTO ylmf_city_id_name VALUES('1422','101200505','Ӣɽ');
INSERT INTO ylmf_city_id_name VALUES('1423','101200506','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1424','101200507','ޭ');
INSERT INTO ylmf_city_id_name VALUES('1425','101200508','÷');
INSERT INTO ylmf_city_id_name VALUES('1426','101200509','Ѩ');
INSERT INTO ylmf_city_id_name VALUES('1427','101200601','ʯ');
INSERT INTO ylmf_city_id_name VALUES('1428','101200602','ұ');
INSERT INTO ylmf_city_id_name VALUES('1429','101200603','');
INSERT INTO ylmf_city_id_name VALUES('1430','101200701','');
INSERT INTO ylmf_city_id_name VALUES('1431','101200702','');
INSERT INTO ylmf_city_id_name VALUES('1432','101200703','');
INSERT INTO ylmf_city_id_name VALUES('1433','101200704','');
INSERT INTO ylmf_city_id_name VALUES('1434','101200705','ͨ');
INSERT INTO ylmf_city_id_name VALUES('1435','101200706','ͨɽ');
INSERT INTO ylmf_city_id_name VALUES('1436','101200801','');
INSERT INTO ylmf_city_id_name VALUES('1437','101200802','');
INSERT INTO ylmf_city_id_name VALUES('1438','101200803','');
INSERT INTO ylmf_city_id_name VALUES('1439','101200804','ʯ');
INSERT INTO ylmf_city_id_name VALUES('1440','101200805','');
INSERT INTO ylmf_city_id_name VALUES('1441','101200806','');
INSERT INTO ylmf_city_id_name VALUES('1442','101200807','');
INSERT INTO ylmf_city_id_name VALUES('1443','101200901','˲');
INSERT INTO ylmf_city_id_name VALUES('1444','101200902','Զ');
INSERT INTO ylmf_city_id_name VALUES('1445','101200903','');
INSERT INTO ylmf_city_id_name VALUES('1446','101200904','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1447','101200905','˲');
INSERT INTO ylmf_city_id_name VALUES('1448','101200906','');
INSERT INTO ylmf_city_id_name VALUES('1449','101200907','');
INSERT INTO ylmf_city_id_name VALUES('1450','101200908','');
INSERT INTO ylmf_city_id_name VALUES('1451','101200909','˶');
INSERT INTO ylmf_city_id_name VALUES('1452','101200910','֦');
INSERT INTO ylmf_city_id_name VALUES('1453','101200911','Ͽ');
INSERT INTO ylmf_city_id_name VALUES('1454','101201001','ʩ');
INSERT INTO ylmf_city_id_name VALUES('1455','101201002','');
INSERT INTO ylmf_city_id_name VALUES('1456','101201003','ʼ');
INSERT INTO ylmf_city_id_name VALUES('1457','101201004','̷');
INSERT INTO ylmf_city_id_name VALUES('1458','101201005','');
INSERT INTO ylmf_city_id_name VALUES('1459','101201006','׷');
INSERT INTO ylmf_city_id_name VALUES('1460','101201007','');
INSERT INTO ylmf_city_id_name VALUES('1461','101201008','Ͷ');
INSERT INTO ylmf_city_id_name VALUES('1462','101201009','̴');
INSERT INTO ylmf_city_id_name VALUES('1463','101201101','ʮ');
INSERT INTO ylmf_city_id_name VALUES('1464','101201102','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1465','101201103','');
INSERT INTO ylmf_city_id_name VALUES('1466','101201104','');
INSERT INTO ylmf_city_id_name VALUES('1467','101201105','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1468','101201106','');
INSERT INTO ylmf_city_id_name VALUES('1469','101201107','');
INSERT INTO ylmf_city_id_name VALUES('1470','101201201','ũ');
INSERT INTO ylmf_city_id_name VALUES('1471','101201301','');
INSERT INTO ylmf_city_id_name VALUES('1472','101201302','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1473','101201401','');
INSERT INTO ylmf_city_id_name VALUES('1474','101201402','');
INSERT INTO ylmf_city_id_name VALUES('1475','101201403','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1476','101201501','');
INSERT INTO ylmf_city_id_name VALUES('1477','101201601','');
INSERT INTO ylmf_city_id_name VALUES('1478','101201701','Ǳ');
INSERT INTO ylmf_city_id_name VALUES('1479','101210101','');
INSERT INTO ylmf_city_id_name VALUES('1480','101210102','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1481','101210103','ͩ®');
INSERT INTO ylmf_city_id_name VALUES('1482','101210104','');
INSERT INTO ylmf_city_id_name VALUES('1483','101210105','');
INSERT INTO ylmf_city_id_name VALUES('1484','101210106','');
INSERT INTO ylmf_city_id_name VALUES('1485','101210107','ٰ');
INSERT INTO ylmf_city_id_name VALUES('1486','101210108','');
INSERT INTO ylmf_city_id_name VALUES('1487','101210201','');
INSERT INTO ylmf_city_id_name VALUES('1488','101210202','');
INSERT INTO ylmf_city_id_name VALUES('1489','101210203','');
INSERT INTO ylmf_city_id_name VALUES('1490','101210204','');
INSERT INTO ylmf_city_id_name VALUES('1491','101210301','');
INSERT INTO ylmf_city_id_name VALUES('1492','101210302','');
INSERT INTO ylmf_city_id_name VALUES('1493','101210303','');
INSERT INTO ylmf_city_id_name VALUES('1494','101210304','ͩ');
INSERT INTO ylmf_city_id_name VALUES('1495','101210305','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1496','101210306','');
INSERT INTO ylmf_city_id_name VALUES('1497','101210401','');
INSERT INTO ylmf_city_id_name VALUES('1498','101210403','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1499','101210404','Ҧ');
INSERT INTO ylmf_city_id_name VALUES('1500','101210405','');
INSERT INTO ylmf_city_id_name VALUES('1501','101210406','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1502','101210407','ʯ');
INSERT INTO ylmf_city_id_name VALUES('1503','101210408','');
INSERT INTO ylmf_city_id_name VALUES('1504','101210409','۴');
INSERT INTO ylmf_city_id_name VALUES('1505','101210501','');
INSERT INTO ylmf_city_id_name VALUES('1506','101210502','');
INSERT INTO ylmf_city_id_name VALUES('1507','101210503','');
INSERT INTO ylmf_city_id_name VALUES('1508','101210504','²');
INSERT INTO ylmf_city_id_name VALUES('1509','101210505','');
INSERT INTO ylmf_city_id_name VALUES('1510','101210601','̨');
INSERT INTO ylmf_city_id_name VALUES('1511','101210602','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1512','101210603','');
INSERT INTO ylmf_city_id_name VALUES('1513','101210604','');
INSERT INTO ylmf_city_id_name VALUES('1514','101210605','̨');
INSERT INTO ylmf_city_id_name VALUES('1515','101210606','ɾ');
INSERT INTO ylmf_city_id_name VALUES('1516','101210607','');
INSERT INTO ylmf_city_id_name VALUES('1517','101210608','');
INSERT INTO ylmf_city_id_name VALUES('1518','101210609','');
INSERT INTO ylmf_city_id_name VALUES('1519','101210701','');
INSERT INTO ylmf_city_id_name VALUES('1520','101210702','̩˳');
INSERT INTO ylmf_city_id_name VALUES('1521','101210703','ĳ');
INSERT INTO ylmf_city_id_name VALUES('1522','101210704','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1523','101210705','');
INSERT INTO ylmf_city_id_name VALUES('1524','101210706','ͷ');
INSERT INTO ylmf_city_id_name VALUES('1525','101210707','');
INSERT INTO ylmf_city_id_name VALUES('1526','101210708','');
INSERT INTO ylmf_city_id_name VALUES('1527','101210709','');
INSERT INTO ylmf_city_id_name VALUES('1528','101210801','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1529','101210802','');
INSERT INTO ylmf_city_id_name VALUES('1530','101210803','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('1531','101210804','');
INSERT INTO ylmf_city_id_name VALUES('1532','101210805','');
INSERT INTO ylmf_city_id_name VALUES('1533','101210806','ƺ');
INSERT INTO ylmf_city_id_name VALUES('1534','101210807','Ԫ');
INSERT INTO ylmf_city_id_name VALUES('1535','101210901','');
INSERT INTO ylmf_city_id_name VALUES('1536','101210902','ֽ');
INSERT INTO ylmf_city_id_name VALUES('1537','101210903','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1538','101210904','');
INSERT INTO ylmf_city_id_name VALUES('1539','101210905','');
INSERT INTO ylmf_city_id_name VALUES('1540','101210906','');
INSERT INTO ylmf_city_id_name VALUES('1541','101210907','');
INSERT INTO ylmf_city_id_name VALUES('1542','101211001','');
INSERT INTO ylmf_city_id_name VALUES('1543','101211002','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1544','101211003','');
INSERT INTO ylmf_city_id_name VALUES('1545','101211004','');
INSERT INTO ylmf_city_id_name VALUES('1546','101211005','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1547','101211101','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1548','101211102','');
INSERT INTO ylmf_city_id_name VALUES('1549','101211103','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1550','101211104','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1551','101211105','');
INSERT INTO ylmf_city_id_name VALUES('1552','101220101','Ϸ');
INSERT INTO ylmf_city_id_name VALUES('1553','101220102','');
INSERT INTO ylmf_city_id_name VALUES('1554','101220103','ʶ');
INSERT INTO ylmf_city_id_name VALUES('1555','101220104','');
INSERT INTO ylmf_city_id_name VALUES('1556','101220201','');
INSERT INTO ylmf_city_id_name VALUES('1557','101220202','Զ');
INSERT INTO ylmf_city_id_name VALUES('1558','101220203','');
INSERT INTO ylmf_city_id_name VALUES('1559','101220204','');
INSERT INTO ylmf_city_id_name VALUES('1560','101220301','ߺ');
INSERT INTO ylmf_city_id_name VALUES('1561','101220302','');
INSERT INTO ylmf_city_id_name VALUES('1562','101220303','ߺ');
INSERT INTO ylmf_city_id_name VALUES('1563','101220304','');
INSERT INTO ylmf_city_id_name VALUES('1564','101220401','');
INSERT INTO ylmf_city_id_name VALUES('1565','101220402','̨');
INSERT INTO ylmf_city_id_name VALUES('1566','101220501','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1567','101220502','Ϳ');
INSERT INTO ylmf_city_id_name VALUES('1568','101220601','');
INSERT INTO ylmf_city_id_name VALUES('1569','101220602','');
INSERT INTO ylmf_city_id_name VALUES('1570','101220603','̫');
INSERT INTO ylmf_city_id_name VALUES('1571','101220604','Ǳɽ');
INSERT INTO ylmf_city_id_name VALUES('1572','101220605','');
INSERT INTO ylmf_city_id_name VALUES('1573','101220606','');
INSERT INTO ylmf_city_id_name VALUES('1574','101220607','');
INSERT INTO ylmf_city_id_name VALUES('1575','101220608','');
INSERT INTO ylmf_city_id_name VALUES('1576','101220609','ͩ');
INSERT INTO ylmf_city_id_name VALUES('1577','101220701','');
INSERT INTO ylmf_city_id_name VALUES('1578','101220702','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1579','101220703','');
INSERT INTO ylmf_city_id_name VALUES('1580','101220704','');
INSERT INTO ylmf_city_id_name VALUES('1581','101220705','');
INSERT INTO ylmf_city_id_name VALUES('1582','101220801','');
INSERT INTO ylmf_city_id_name VALUES('1583','101220802','');
INSERT INTO ylmf_city_id_name VALUES('1584','101220803','ӱ');
INSERT INTO ylmf_city_id_name VALUES('1585','101220804','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('1586','101220805','');
INSERT INTO ylmf_city_id_name VALUES('1587','101220806','̫');
INSERT INTO ylmf_city_id_name VALUES('1588','101220901','');
INSERT INTO ylmf_city_id_name VALUES('1589','101220902','');
INSERT INTO ylmf_city_id_name VALUES('1590','101220903','');
INSERT INTO ylmf_city_id_name VALUES('1591','101220904','ɳ');
INSERT INTO ylmf_city_id_name VALUES('1592','101221001','ɽվ');
INSERT INTO ylmf_city_id_name VALUES('1593','101221002','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1594','101221003','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1595','101221004','');
INSERT INTO ylmf_city_id_name VALUES('1596','101221005','');
INSERT INTO ylmf_city_id_name VALUES('1597','101221006','');
INSERT INTO ylmf_city_id_name VALUES('1598','101221007','');
INSERT INTO ylmf_city_id_name VALUES('1599','101221101','');
INSERT INTO ylmf_city_id_name VALUES('1600','101221102','');
INSERT INTO ylmf_city_id_name VALUES('1601','101221103','');
INSERT INTO ylmf_city_id_name VALUES('1602','101221104','Զ');
INSERT INTO ylmf_city_id_name VALUES('1603','101221105','ȫ');
INSERT INTO ylmf_city_id_name VALUES('1604','101221106','');
INSERT INTO ylmf_city_id_name VALUES('1605','101221107','쳤');
INSERT INTO ylmf_city_id_name VALUES('1606','101221201','');
INSERT INTO ylmf_city_id_name VALUES('1607','101221202','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1608','101221301','ͭ');
INSERT INTO ylmf_city_id_name VALUES('1609','101221401','');
INSERT INTO ylmf_city_id_name VALUES('1610','101221402','');
INSERT INTO ylmf_city_id_name VALUES('1611','101221403','캵');
INSERT INTO ylmf_city_id_name VALUES('1612','101221404','');
INSERT INTO ylmf_city_id_name VALUES('1613','101221405','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1614','101221406','');
INSERT INTO ylmf_city_id_name VALUES('1615','101221407','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1616','101221501','');
INSERT INTO ylmf_city_id_name VALUES('1617','101221502','');
INSERT INTO ylmf_city_id_name VALUES('1618','101221503','');
INSERT INTO ylmf_city_id_name VALUES('1619','101221504','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1620','101221505','կ');
INSERT INTO ylmf_city_id_name VALUES('1621','101221506','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1622','101221507','');
INSERT INTO ylmf_city_id_name VALUES('1623','101221601','');
INSERT INTO ylmf_city_id_name VALUES('1624','101221602','®');
INSERT INTO ylmf_city_id_name VALUES('1625','101221603','Ϊ');
INSERT INTO ylmf_city_id_name VALUES('1626','101221604','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1627','101221605','');
INSERT INTO ylmf_city_id_name VALUES('1628','101221701','');
INSERT INTO ylmf_city_id_name VALUES('1629','101221702','');
INSERT INTO ylmf_city_id_name VALUES('1630','101221703','');
INSERT INTO ylmf_city_id_name VALUES('1631','101221704','Żɽ');
INSERT INTO ylmf_city_id_name VALUES('1632','101221705','ʯ̨');
INSERT INTO ylmf_city_id_name VALUES('1633','101230101','');
INSERT INTO ylmf_city_id_name VALUES('1634','101230102','');
INSERT INTO ylmf_city_id_name VALUES('1635','101230103','');
INSERT INTO ylmf_city_id_name VALUES('1636','101230104','Դ');
INSERT INTO ylmf_city_id_name VALUES('1637','101230105','');
INSERT INTO ylmf_city_id_name VALUES('1638','101230106','');
INSERT INTO ylmf_city_id_name VALUES('1639','101230107','̩');
INSERT INTO ylmf_city_id_name VALUES('1640','101230108','ƽ̶');
INSERT INTO ylmf_city_id_name VALUES('1641','101230109','ݽ');
INSERT INTO ylmf_city_id_name VALUES('1642','101230110','');
INSERT INTO ylmf_city_id_name VALUES('1643','101230111','');
INSERT INTO ylmf_city_id_name VALUES('1644','101230112','ƽ̶Ͽ');
INSERT INTO ylmf_city_id_name VALUES('1645','101230201','');
INSERT INTO ylmf_city_id_name VALUES('1646','101230202','ͬ');
INSERT INTO ylmf_city_id_name VALUES('1647','101230301','');
INSERT INTO ylmf_city_id_name VALUES('1648','101230302','');
INSERT INTO ylmf_city_id_name VALUES('1649','101230303','ϼ');
INSERT INTO ylmf_city_id_name VALUES('1650','101230304','');
INSERT INTO ylmf_city_id_name VALUES('1651','101230305','');
INSERT INTO ylmf_city_id_name VALUES('1652','101230306','');
INSERT INTO ylmf_city_id_name VALUES('1653','101230307','');
INSERT INTO ylmf_city_id_name VALUES('1654','101230308','');
INSERT INTO ylmf_city_id_name VALUES('1655','101230309','');
INSERT INTO ylmf_city_id_name VALUES('1656','101230401','');
INSERT INTO ylmf_city_id_name VALUES('1657','101230402','');
INSERT INTO ylmf_city_id_name VALUES('1658','101230403','');
INSERT INTO ylmf_city_id_name VALUES('1659','101230501','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('1660','101230502','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1661','101230503','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1662','101230504','');
INSERT INTO ylmf_city_id_name VALUES('1663','101230505','»');
INSERT INTO ylmf_city_id_name VALUES('1664','101230506','ϰ');
INSERT INTO ylmf_city_id_name VALUES('1665','101230507','');
INSERT INTO ylmf_city_id_name VALUES('1666','101230508','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1667','101230601','');
INSERT INTO ylmf_city_id_name VALUES('1668','101230602','̩');
INSERT INTO ylmf_city_id_name VALUES('1669','101230603','Ͼ');
INSERT INTO ylmf_city_id_name VALUES('1670','101230604','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1671','101230605','');
INSERT INTO ylmf_city_id_name VALUES('1672','101230606','');
INSERT INTO ylmf_city_id_name VALUES('1673','101230607','گ');
INSERT INTO ylmf_city_id_name VALUES('1674','101230608','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1675','101230609','');
INSERT INTO ylmf_city_id_name VALUES('1676','101230610','');
INSERT INTO ylmf_city_id_name VALUES('1677','101230701','');
INSERT INTO ylmf_city_id_name VALUES('1678','101230702','͡');
INSERT INTO ylmf_city_id_name VALUES('1679','101230703','');
INSERT INTO ylmf_city_id_name VALUES('1680','101230704','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1681','101230705','Ϻ');
INSERT INTO ylmf_city_id_name VALUES('1682','101230706','');
INSERT INTO ylmf_city_id_name VALUES('1683','101230707','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1684','101230801','');
INSERT INTO ylmf_city_id_name VALUES('1685','101230802','');
INSERT INTO ylmf_city_id_name VALUES('1686','101230803','');
INSERT INTO ylmf_city_id_name VALUES('1687','101230804','̩');
INSERT INTO ylmf_city_id_name VALUES('1688','101230805','');
INSERT INTO ylmf_city_id_name VALUES('1689','101230806','');
INSERT INTO ylmf_city_id_name VALUES('1690','101230807','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1691','101230808','ɳ');
INSERT INTO ylmf_city_id_name VALUES('1692','101230809','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1693','101230810','');
INSERT INTO ylmf_city_id_name VALUES('1694','101230811','');
INSERT INTO ylmf_city_id_name VALUES('1695','101230901','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1696','101230902','˳');
INSERT INTO ylmf_city_id_name VALUES('1697','101230903','');
INSERT INTO ylmf_city_id_name VALUES('1698','101230904','');
INSERT INTO ylmf_city_id_name VALUES('1699','101230905','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1700','101230906','ֳ');
INSERT INTO ylmf_city_id_name VALUES('1701','101230907','');
INSERT INTO ylmf_city_id_name VALUES('1702','101230908','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1703','101230909','');
INSERT INTO ylmf_city_id_name VALUES('1704','101230910','');
INSERT INTO ylmf_city_id_name VALUES('1705','101240101','ϲ');
INSERT INTO ylmf_city_id_name VALUES('1706','101240102','½');
INSERT INTO ylmf_city_id_name VALUES('1707','101240103','ϲ');
INSERT INTO ylmf_city_id_name VALUES('1708','101240104','');
INSERT INTO ylmf_city_id_name VALUES('1709','101240105','');
INSERT INTO ylmf_city_id_name VALUES('1710','101240201','Ž');
INSERT INTO ylmf_city_id_name VALUES('1711','101240202','');
INSERT INTO ylmf_city_id_name VALUES('1712','101240203','®ɽ');
INSERT INTO ylmf_city_id_name VALUES('1713','101240204','');
INSERT INTO ylmf_city_id_name VALUES('1714','101240205','°');
INSERT INTO ylmf_city_id_name VALUES('1715','101240206','');
INSERT INTO ylmf_city_id_name VALUES('1716','101240207','');
INSERT INTO ylmf_city_id_name VALUES('1717','101240208','');
INSERT INTO ylmf_city_id_name VALUES('1718','101240209','');
INSERT INTO ylmf_city_id_name VALUES('1719','101240210','');
INSERT INTO ylmf_city_id_name VALUES('1720','101240211','');
INSERT INTO ylmf_city_id_name VALUES('1721','101240212','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1722','101240301','');
INSERT INTO ylmf_city_id_name VALUES('1723','101240302','');
INSERT INTO ylmf_city_id_name VALUES('1724','101240303','Դ');
INSERT INTO ylmf_city_id_name VALUES('1725','101240304','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1726','101240305','');
INSERT INTO ylmf_city_id_name VALUES('1727','101240306','');
INSERT INTO ylmf_city_id_name VALUES('1728','101240307','');
INSERT INTO ylmf_city_id_name VALUES('1729','101240308','');
INSERT INTO ylmf_city_id_name VALUES('1730','101240309','߮');
INSERT INTO ylmf_city_id_name VALUES('1731','101240310','');
INSERT INTO ylmf_city_id_name VALUES('1732','101240311','Ǧɽ');
INSERT INTO ylmf_city_id_name VALUES('1733','101240312','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1734','101240313','');
INSERT INTO ylmf_city_id_name VALUES('1735','101240401','');
INSERT INTO ylmf_city_id_name VALUES('1736','101240402','');
INSERT INTO ylmf_city_id_name VALUES('1737','101240403','ְ');
INSERT INTO ylmf_city_id_name VALUES('1738','101240404','');
INSERT INTO ylmf_city_id_name VALUES('1739','101240405','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1740','101240406','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1741','101240407','˻');
INSERT INTO ylmf_city_id_name VALUES('1742','101240408','ϳ');
INSERT INTO ylmf_city_id_name VALUES('1743','101240409','Ϸ');
INSERT INTO ylmf_city_id_name VALUES('1744','101240410','质');
INSERT INTO ylmf_city_id_name VALUES('1745','101240411','');
INSERT INTO ylmf_city_id_name VALUES('1746','101240501','˴');
INSERT INTO ylmf_city_id_name VALUES('1747','101240502','ͭ');
INSERT INTO ylmf_city_id_name VALUES('1748','101240503','˷');
INSERT INTO ylmf_city_id_name VALUES('1749','101240504','');
INSERT INTO ylmf_city_id_name VALUES('1750','101240505','ϸ');
INSERT INTO ylmf_city_id_name VALUES('1751','101240506','');
INSERT INTO ylmf_city_id_name VALUES('1752','101240507','');
INSERT INTO ylmf_city_id_name VALUES('1753','101240508','߰');
INSERT INTO ylmf_city_id_name VALUES('1754','101240509','');
INSERT INTO ylmf_city_id_name VALUES('1755','101240510','');
INSERT INTO ylmf_city_id_name VALUES('1756','101240601','');
INSERT INTO ylmf_city_id_name VALUES('1757','101240602','');
INSERT INTO ylmf_city_id_name VALUES('1758','101240603','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1759','101240604','¸');
INSERT INTO ylmf_city_id_name VALUES('1760','101240605','Ͽ');
INSERT INTO ylmf_city_id_name VALUES('1761','101240606','');
INSERT INTO ylmf_city_id_name VALUES('1762','101240607','');
INSERT INTO ylmf_city_id_name VALUES('1763','101240608','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1764','101240609','');
INSERT INTO ylmf_city_id_name VALUES('1765','101240610','촨');
INSERT INTO ylmf_city_id_name VALUES('1766','101240611','̩');
INSERT INTO ylmf_city_id_name VALUES('1767','101240612','');
INSERT INTO ylmf_city_id_name VALUES('1768','101240613','');
INSERT INTO ylmf_city_id_name VALUES('1769','101240701','');
INSERT INTO ylmf_city_id_name VALUES('1770','101240702','');
INSERT INTO ylmf_city_id_name VALUES('1771','101240703','');
INSERT INTO ylmf_city_id_name VALUES('1772','101240704','Ͽ');
INSERT INTO ylmf_city_id_name VALUES('1773','101240705','');
INSERT INTO ylmf_city_id_name VALUES('1774','101240706','ŷ');
INSERT INTO ylmf_city_id_name VALUES('1775','101240707','');
INSERT INTO ylmf_city_id_name VALUES('1776','101240708','ʯ');
INSERT INTO ylmf_city_id_name VALUES('1777','101240709','');
INSERT INTO ylmf_city_id_name VALUES('1778','101240710','ڶ');
INSERT INTO ylmf_city_id_name VALUES('1779','101240711','');
INSERT INTO ylmf_city_id_name VALUES('1780','101240712','Զ');
INSERT INTO ylmf_city_id_name VALUES('1781','101240713','ȫ');
INSERT INTO ylmf_city_id_name VALUES('1782','101240714','');
INSERT INTO ylmf_city_id_name VALUES('1783','101240715','');
INSERT INTO ylmf_city_id_name VALUES('1784','101240716','Ѱ');
INSERT INTO ylmf_city_id_name VALUES('1785','101240801','');
INSERT INTO ylmf_city_id_name VALUES('1786','101240802','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1787','101240901','Ƽ');
INSERT INTO ylmf_city_id_name VALUES('1788','101240902','');
INSERT INTO ylmf_city_id_name VALUES('1789','101241001','');
INSERT INTO ylmf_city_id_name VALUES('1790','101241002','');
INSERT INTO ylmf_city_id_name VALUES('1791','101241101','ӥ̶');
INSERT INTO ylmf_city_id_name VALUES('1792','101241102','཭');
INSERT INTO ylmf_city_id_name VALUES('1793','101241103','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1794','101250101','ɳ');
INSERT INTO ylmf_city_id_name VALUES('1795','101250102','');
INSERT INTO ylmf_city_id_name VALUES('1796','101250103','');
INSERT INTO ylmf_city_id_name VALUES('1797','101250104','');
INSERT INTO ylmf_city_id_name VALUES('1798','101250201','̶');
INSERT INTO ylmf_city_id_name VALUES('1799','101250202','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1800','101250203','');
INSERT INTO ylmf_city_id_name VALUES('1801','101250301','');
INSERT INTO ylmf_city_id_name VALUES('1802','101250302','');
INSERT INTO ylmf_city_id_name VALUES('1803','101250303','');
INSERT INTO ylmf_city_id_name VALUES('1804','101250304','');
INSERT INTO ylmf_city_id_name VALUES('1805','101250305','');
INSERT INTO ylmf_city_id_name VALUES('1806','101250306','');
INSERT INTO ylmf_city_id_name VALUES('1807','101250401','');
INSERT INTO ylmf_city_id_name VALUES('1808','101250402','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1809','101250403','ⶫ');
INSERT INTO ylmf_city_id_name VALUES('1810','101250404','');
INSERT INTO ylmf_city_id_name VALUES('1811','101250405','');
INSERT INTO ylmf_city_id_name VALUES('1812','101250406','');
INSERT INTO ylmf_city_id_name VALUES('1813','101250407','');
INSERT INTO ylmf_city_id_name VALUES('1814','101250408','');
INSERT INTO ylmf_city_id_name VALUES('1815','101250409','');
INSERT INTO ylmf_city_id_name VALUES('1816','101250501','');
INSERT INTO ylmf_city_id_name VALUES('1817','101250502','');
INSERT INTO ylmf_city_id_name VALUES('1818','101250503','κ');
INSERT INTO ylmf_city_id_name VALUES('1819','101250504','');
INSERT INTO ylmf_city_id_name VALUES('1820','101250505','');
INSERT INTO ylmf_city_id_name VALUES('1821','101250506','ſ');
INSERT INTO ylmf_city_id_name VALUES('1822','101250507','');
INSERT INTO ylmf_city_id_name VALUES('1823','101250508','');
INSERT INTO ylmf_city_id_name VALUES('1824','101250509','');
INSERT INTO ylmf_city_id_name VALUES('1825','101250510','');
INSERT INTO ylmf_city_id_name VALUES('1826','101250511','');
INSERT INTO ylmf_city_id_name VALUES('1827','101250601','');
INSERT INTO ylmf_city_id_name VALUES('1828','101250602','');
INSERT INTO ylmf_city_id_name VALUES('1829','101250603','Դ');
INSERT INTO ylmf_city_id_name VALUES('1830','101250604','');
INSERT INTO ylmf_city_id_name VALUES('1831','101250605','');
INSERT INTO ylmf_city_id_name VALUES('1832','101250606','');
INSERT INTO ylmf_city_id_name VALUES('1833','101250607','ʯ');
INSERT INTO ylmf_city_id_name VALUES('1834','101250701','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1835','101250702','');
INSERT INTO ylmf_city_id_name VALUES('1836','101250703','ҽ');
INSERT INTO ylmf_city_id_name VALUES('1837','101250704','');
INSERT INTO ylmf_city_id_name VALUES('1838','101250705','佭');
INSERT INTO ylmf_city_id_name VALUES('1839','101250801','¦');
INSERT INTO ylmf_city_id_name VALUES('1840','101250802','˫');
INSERT INTO ylmf_city_id_name VALUES('1841','101250803','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1842','101250804','ˮ̲');
INSERT INTO ylmf_city_id_name VALUES('1843','101250805','»');
INSERT INTO ylmf_city_id_name VALUES('1844','101250806','Դ');
INSERT INTO ylmf_city_id_name VALUES('1845','101250901','');
INSERT INTO ylmf_city_id_name VALUES('1846','101250902','¡');
INSERT INTO ylmf_city_id_name VALUES('1847','101250903','');
INSERT INTO ylmf_city_id_name VALUES('1848','101250904','');
INSERT INTO ylmf_city_id_name VALUES('1849','101250905','۶');
INSERT INTO ylmf_city_id_name VALUES('1850','101250906','');
INSERT INTO ylmf_city_id_name VALUES('1851','101250907','');
INSERT INTO ylmf_city_id_name VALUES('1852','101250908','');
INSERT INTO ylmf_city_id_name VALUES('1853','101250909','ǲ');
INSERT INTO ylmf_city_id_name VALUES('1854','101250910','');
INSERT INTO ylmf_city_id_name VALUES('1855','101251001','');
INSERT INTO ylmf_city_id_name VALUES('1856','101251002','');
INSERT INTO ylmf_city_id_name VALUES('1857','101251003','');
INSERT INTO ylmf_city_id_name VALUES('1858','101251004','');
INSERT INTO ylmf_city_id_name VALUES('1859','101251005','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1860','101251006','');
INSERT INTO ylmf_city_id_name VALUES('1861','101251101','żҽ');
INSERT INTO ylmf_city_id_name VALUES('1862','101251102','ɣֲ');
INSERT INTO ylmf_city_id_name VALUES('1863','101251103','');
INSERT INTO ylmf_city_id_name VALUES('1864','101251201','');
INSERT INTO ylmf_city_id_name VALUES('1865','101251202','׳');
INSERT INTO ylmf_city_id_name VALUES('1866','101251203','');
INSERT INTO ylmf_city_id_name VALUES('1867','101251204','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1868','101251205','');
INSERT INTO ylmf_city_id_name VALUES('1869','101251206','ͬ');
INSERT INTO ylmf_city_id_name VALUES('1870','101251207','ͨ');
INSERT INTO ylmf_city_id_name VALUES('1871','101251208','');
INSERT INTO ylmf_city_id_name VALUES('1872','101251209','»');
INSERT INTO ylmf_city_id_name VALUES('1873','101251210','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1874','101251211','');
INSERT INTO ylmf_city_id_name VALUES('1875','101251301','ǭ');
INSERT INTO ylmf_city_id_name VALUES('1876','101251401','');
INSERT INTO ylmf_city_id_name VALUES('1877','101251402','');
INSERT INTO ylmf_city_id_name VALUES('1878','101251403','');
INSERT INTO ylmf_city_id_name VALUES('1879','101251404','˫');
INSERT INTO ylmf_city_id_name VALUES('1880','101251405','');
INSERT INTO ylmf_city_id_name VALUES('1881','101251406','Զ');
INSERT INTO ylmf_city_id_name VALUES('1882','101251407','');
INSERT INTO ylmf_city_id_name VALUES('1883','101251408','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1884','101251409','');
INSERT INTO ylmf_city_id_name VALUES('1885','101251410','');
INSERT INTO ylmf_city_id_name VALUES('1886','101251501','');
INSERT INTO ylmf_city_id_name VALUES('1887','101251502','');
INSERT INTO ylmf_city_id_name VALUES('1888','101251503','˳');
INSERT INTO ylmf_city_id_name VALUES('1889','101251504','');
INSERT INTO ylmf_city_id_name VALUES('1890','101251505','');
INSERT INTO ylmf_city_id_name VALUES('1891','101251506','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1892','101251507','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1893','101251508','ԫ');
INSERT INTO ylmf_city_id_name VALUES('1894','101260101','');
INSERT INTO ylmf_city_id_name VALUES('1895','101260102','');
INSERT INTO ylmf_city_id_name VALUES('1896','101260103','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('1897','101260104','ڵ');
INSERT INTO ylmf_city_id_name VALUES('1898','101260105','Ϣ');
INSERT INTO ylmf_city_id_name VALUES('1899','101260106','');
INSERT INTO ylmf_city_id_name VALUES('1900','101260107','');
INSERT INTO ylmf_city_id_name VALUES('1901','101260108','');
INSERT INTO ylmf_city_id_name VALUES('1902','101260201','');
INSERT INTO ylmf_city_id_name VALUES('1903','101260202','');
INSERT INTO ylmf_city_id_name VALUES('1904','101260203','ʻ');
INSERT INTO ylmf_city_id_name VALUES('1905','101260204','');
INSERT INTO ylmf_city_id_name VALUES('1906','101260205','̶');
INSERT INTO ylmf_city_id_name VALUES('1907','101260206','');
INSERT INTO ylmf_city_id_name VALUES('1908','101260207','ͩ');
INSERT INTO ylmf_city_id_name VALUES('1909','101260208','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1910','101260209','ϰˮ');
INSERT INTO ylmf_city_id_name VALUES('1911','101260210','');
INSERT INTO ylmf_city_id_name VALUES('1912','101260211','');
INSERT INTO ylmf_city_id_name VALUES('1913','101260212','');
INSERT INTO ylmf_city_id_name VALUES('1914','101260213','');
INSERT INTO ylmf_city_id_name VALUES('1915','101260301','˳');
INSERT INTO ylmf_city_id_name VALUES('1916','101260302','ն');
INSERT INTO ylmf_city_id_name VALUES('1917','101260303','');
INSERT INTO ylmf_city_id_name VALUES('1918','101260304','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1919','101260305','');
INSERT INTO ylmf_city_id_name VALUES('1920','101260306','');
INSERT INTO ylmf_city_id_name VALUES('1921','101260401','');
INSERT INTO ylmf_city_id_name VALUES('1922','101260402','');
INSERT INTO ylmf_city_id_name VALUES('1923','101260403','Ͱ');
INSERT INTO ylmf_city_id_name VALUES('1924','101260404','˳');
INSERT INTO ylmf_city_id_name VALUES('1925','101260405','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('1926','101260406','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1927','101260407','');
INSERT INTO ylmf_city_id_name VALUES('1928','101260408','޵');
INSERT INTO ylmf_city_id_name VALUES('1929','101260409','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1930','101260410','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1931','101260411','');
INSERT INTO ylmf_city_id_name VALUES('1932','101260412','');
INSERT INTO ylmf_city_id_name VALUES('1933','101260501','');
INSERT INTO ylmf_city_id_name VALUES('1934','101260502','᯹');
INSERT INTO ylmf_city_id_name VALUES('1935','101260503','ʩ');
INSERT INTO ylmf_city_id_name VALUES('1936','101260504','Զ');
INSERT INTO ylmf_city_id_name VALUES('1937','101260505','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1938','101260506','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1939','101260507','齭');
INSERT INTO ylmf_city_id_name VALUES('1940','101260508','կ');
INSERT INTO ylmf_city_id_name VALUES('1941','101260509','');
INSERT INTO ylmf_city_id_name VALUES('1942','101260510','̨');
INSERT INTO ylmf_city_id_name VALUES('1943','101260511','');
INSERT INTO ylmf_city_id_name VALUES('1944','101260512','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1945','101260513','ƽ');
INSERT INTO ylmf_city_id_name VALUES('1946','101260514','');
INSERT INTO ylmf_city_id_name VALUES('1947','101260515','');
INSERT INTO ylmf_city_id_name VALUES('1948','101260516','Ž');
INSERT INTO ylmf_city_id_name VALUES('1949','101260517','ӽ');
INSERT INTO ylmf_city_id_name VALUES('1950','101260518','¯ɽ');
INSERT INTO ylmf_city_id_name VALUES('1951','101260601','ͭ');
INSERT INTO ylmf_city_id_name VALUES('1952','101260602','');
INSERT INTO ylmf_city_id_name VALUES('1953','101260603','');
INSERT INTO ylmf_city_id_name VALUES('1954','101260604','ɽ');
INSERT INTO ylmf_city_id_name VALUES('1955','101260605','˼');
INSERT INTO ylmf_city_id_name VALUES('1956','101260606','ͷ');
INSERT INTO ylmf_city_id_name VALUES('1957','101260607','ӡ');
INSERT INTO ylmf_city_id_name VALUES('1958','101260608','ʯ');
INSERT INTO ylmf_city_id_name VALUES('1959','101260609','غ');
INSERT INTO ylmf_city_id_name VALUES('1960','101260610','½');
INSERT INTO ylmf_city_id_name VALUES('1961','101260611','');
INSERT INTO ylmf_city_id_name VALUES('1962','101260701','Ͻ');
INSERT INTO ylmf_city_id_name VALUES('1963','101260702','');
INSERT INTO ylmf_city_id_name VALUES('1964','101260703','ɳ');
INSERT INTO ylmf_city_id_name VALUES('1965','101260704','');
INSERT INTO ylmf_city_id_name VALUES('1966','101260705','');
INSERT INTO ylmf_city_id_name VALUES('1967','101260706','Ӻ');
INSERT INTO ylmf_city_id_name VALUES('1968','101260707','֯');
INSERT INTO ylmf_city_id_name VALUES('1969','101260801','ˮ');
INSERT INTO ylmf_city_id_name VALUES('1970','101260802','֦');
INSERT INTO ylmf_city_id_name VALUES('1971','101260804','');
INSERT INTO ylmf_city_id_name VALUES('1972','101260901','ǭ');
INSERT INTO ylmf_city_id_name VALUES('1973','101260902','¡');
INSERT INTO ylmf_city_id_name VALUES('1974','101260903','');
INSERT INTO ylmf_city_id_name VALUES('1975','101260904','');
INSERT INTO ylmf_city_id_name VALUES('1976','101260905','');
INSERT INTO ylmf_city_id_name VALUES('1977','101260906','');
INSERT INTO ylmf_city_id_name VALUES('1978','101260907','');
INSERT INTO ylmf_city_id_name VALUES('1979','101260908','');
INSERT INTO ylmf_city_id_name VALUES('1980','101260909','հ');
INSERT INTO ylmf_city_id_name VALUES('1981','101270101','ɶ');
INSERT INTO ylmf_city_id_name VALUES('1982','101270102','Ȫ');
INSERT INTO ylmf_city_id_name VALUES('1983','101270103','¶');
INSERT INTO ylmf_city_id_name VALUES('1984','101270104','½');
INSERT INTO ylmf_city_id_name VALUES('1985','101270105','');
INSERT INTO ylmf_city_id_name VALUES('1986','101270106','˫');
INSERT INTO ylmf_city_id_name VALUES('1987','101270107','ۯ');
INSERT INTO ylmf_city_id_name VALUES('1988','101270108','');
INSERT INTO ylmf_city_id_name VALUES('1989','101270109','ѽ');
INSERT INTO ylmf_city_id_name VALUES('1990','101270110','½');
INSERT INTO ylmf_city_id_name VALUES('1991','101270111','');
INSERT INTO ylmf_city_id_name VALUES('1992','101270112','');
INSERT INTO ylmf_city_id_name VALUES('1993','101270113','');
INSERT INTO ylmf_city_id_name VALUES('1994','101270114','');
INSERT INTO ylmf_city_id_name VALUES('1995','101270201','֦');
INSERT INTO ylmf_city_id_name VALUES('1996','101270202','ʺ');
INSERT INTO ylmf_city_id_name VALUES('1997','101270203','');
INSERT INTO ylmf_city_id_name VALUES('1998','101270204','α');
INSERT INTO ylmf_city_id_name VALUES('1999','101270301','Թ');
INSERT INTO ylmf_city_id_name VALUES('2000','101270302','˳');
INSERT INTO ylmf_city_id_name VALUES('2001','101270303','');
INSERT INTO ylmf_city_id_name VALUES('2002','101270401','');
INSERT INTO ylmf_city_id_name VALUES('2003','101270402','̨');
INSERT INTO ylmf_city_id_name VALUES('2004','101270403','ͤ');
INSERT INTO ylmf_city_id_name VALUES('2005','101270404','');
INSERT INTO ylmf_city_id_name VALUES('2006','101270405','');
INSERT INTO ylmf_city_id_name VALUES('2007','101270406','');
INSERT INTO ylmf_city_id_name VALUES('2008','101270407','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2009','101270408','');
INSERT INTO ylmf_city_id_name VALUES('2010','101270501','ϳ');
INSERT INTO ylmf_city_id_name VALUES('2011','101270502','ϲ');
INSERT INTO ylmf_city_id_name VALUES('2012','101270503','Ӫɽ');
INSERT INTO ylmf_city_id_name VALUES('2013','101270504','');
INSERT INTO ylmf_city_id_name VALUES('2014','101270505','¤');
INSERT INTO ylmf_city_id_name VALUES('2015','101270506','');
INSERT INTO ylmf_city_id_name VALUES('2016','101270507','');
INSERT INTO ylmf_city_id_name VALUES('2017','101270601','');
INSERT INTO ylmf_city_id_name VALUES('2018','101270602','');
INSERT INTO ylmf_city_id_name VALUES('2019','101270603','');
INSERT INTO ylmf_city_id_name VALUES('2020','101270604','');
INSERT INTO ylmf_city_id_name VALUES('2021','101270605','');
INSERT INTO ylmf_city_id_name VALUES('2022','101270606','Դ');
INSERT INTO ylmf_city_id_name VALUES('2023','101270701','');
INSERT INTO ylmf_city_id_name VALUES('2024','101270702','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('2025','101270703','');
INSERT INTO ylmf_city_id_name VALUES('2026','101270801','㰲');
INSERT INTO ylmf_city_id_name VALUES('2027','101270802','');
INSERT INTO ylmf_city_id_name VALUES('2028','101270803','ʤ');
INSERT INTO ylmf_city_id_name VALUES('2029','101270804','ˮ');
INSERT INTO ylmf_city_id_name VALUES('2030','101270901','');
INSERT INTO ylmf_city_id_name VALUES('2031','101270902','ͨ');
INSERT INTO ylmf_city_id_name VALUES('2032','101270903','Ͻ');
INSERT INTO ylmf_city_id_name VALUES('2033','101270904','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2034','101271001','');
INSERT INTO ylmf_city_id_name VALUES('2035','101271003','');
INSERT INTO ylmf_city_id_name VALUES('2036','101271004','Ͻ');
INSERT INTO ylmf_city_id_name VALUES('2037','101271005','');
INSERT INTO ylmf_city_id_name VALUES('2038','101271006','');
INSERT INTO ylmf_city_id_name VALUES('2039','101271101','˱');
INSERT INTO ylmf_city_id_name VALUES('2040','101271102','˱ũվ');
INSERT INTO ylmf_city_id_name VALUES('2041','101271103','˱');
INSERT INTO ylmf_city_id_name VALUES('2042','101271104','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('2043','101271105','');
INSERT INTO ylmf_city_id_name VALUES('2044','101271106','');
INSERT INTO ylmf_city_id_name VALUES('2045','101271107','');
INSERT INTO ylmf_city_id_name VALUES('2046','101271108','');
INSERT INTO ylmf_city_id_name VALUES('2047','101271109','');
INSERT INTO ylmf_city_id_name VALUES('2048','101271110','');
INSERT INTO ylmf_city_id_name VALUES('2049','101271111','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2050','101271201','ڽ');
INSERT INTO ylmf_city_id_name VALUES('2051','101271202','');
INSERT INTO ylmf_city_id_name VALUES('2052','101271203','Զ');
INSERT INTO ylmf_city_id_name VALUES('2053','101271204','');
INSERT INTO ylmf_city_id_name VALUES('2054','101271205','¡');
INSERT INTO ylmf_city_id_name VALUES('2055','101271301','');
INSERT INTO ylmf_city_id_name VALUES('2056','101271302','');
INSERT INTO ylmf_city_id_name VALUES('2057','101271303','');
INSERT INTO ylmf_city_id_name VALUES('2058','101271304','');
INSERT INTO ylmf_city_id_name VALUES('2059','101271401','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2060','101271402','Ϊ');
INSERT INTO ylmf_city_id_name VALUES('2061','101271403','');
INSERT INTO ylmf_city_id_name VALUES('2062','101271404','н');
INSERT INTO ylmf_city_id_name VALUES('2063','101271405','崨');
INSERT INTO ylmf_city_id_name VALUES('2064','101271406','');
INSERT INTO ylmf_city_id_name VALUES('2065','101271407','');
INSERT INTO ylmf_city_id_name VALUES('2066','101271408','ü');
INSERT INTO ylmf_city_id_name VALUES('2067','101271409','üɽ');
INSERT INTO ylmf_city_id_name VALUES('2068','101271501','üɽ');
INSERT INTO ylmf_city_id_name VALUES('2069','101271502','');
INSERT INTO ylmf_city_id_name VALUES('2070','101271503','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2071','101271504','');
INSERT INTO ylmf_city_id_name VALUES('2072','101271505','');
INSERT INTO ylmf_city_id_name VALUES('2073','101271506','');
INSERT INTO ylmf_city_id_name VALUES('2074','101271601','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2075','101271603','ľ');
INSERT INTO ylmf_city_id_name VALUES('2076','101271604','Դ');
INSERT INTO ylmf_city_id_name VALUES('2077','101271605','²');
INSERT INTO ylmf_city_id_name VALUES('2078','101271606','');
INSERT INTO ylmf_city_id_name VALUES('2079','101271607','ᶫ');
INSERT INTO ylmf_city_id_name VALUES('2080','101271608','');
INSERT INTO ylmf_city_id_name VALUES('2081','101271609','ո');
INSERT INTO ylmf_city_id_name VALUES('2082','101271611','');
INSERT INTO ylmf_city_id_name VALUES('2083','101271612','Ѿ');
INSERT INTO ylmf_city_id_name VALUES('2084','101271613','ϲ');
INSERT INTO ylmf_city_id_name VALUES('2085','101271614','');
INSERT INTO ylmf_city_id_name VALUES('2086','101271615','Խ');
INSERT INTO ylmf_city_id_name VALUES('2087','101271616','');
INSERT INTO ylmf_city_id_name VALUES('2088','101271617','ײ');
INSERT INTO ylmf_city_id_name VALUES('2089','101271618','');
INSERT INTO ylmf_city_id_name VALUES('2090','101271701','Ű');
INSERT INTO ylmf_city_id_name VALUES('2091','101271702','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2092','101271703','پ');
INSERT INTO ylmf_city_id_name VALUES('2093','101271704','Դ');
INSERT INTO ylmf_city_id_name VALUES('2094','101271705','ʯ');
INSERT INTO ylmf_city_id_name VALUES('2095','101271706','ȫ');
INSERT INTO ylmf_city_id_name VALUES('2096','101271707','«ɽ');
INSERT INTO ylmf_city_id_name VALUES('2097','101271708','');
INSERT INTO ylmf_city_id_name VALUES('2098','101271801','');
INSERT INTO ylmf_city_id_name VALUES('2099','101271802','');
INSERT INTO ylmf_city_id_name VALUES('2100','101271803','');
INSERT INTO ylmf_city_id_name VALUES('2101','101271804','');
INSERT INTO ylmf_city_id_name VALUES('2102','101271805','');
INSERT INTO ylmf_city_id_name VALUES('2103','101271806','Ž');
INSERT INTO ylmf_city_id_name VALUES('2104','101271807','');
INSERT INTO ylmf_city_id_name VALUES('2105','101271808','¯');
INSERT INTO ylmf_city_id_name VALUES('2106','101271809','');
INSERT INTO ylmf_city_id_name VALUES('2107','101271810','¸');
INSERT INTO ylmf_city_id_name VALUES('2108','101271811','');
INSERT INTO ylmf_city_id_name VALUES('2109','101271812','ʯ');
INSERT INTO ylmf_city_id_name VALUES('2110','101271813','ɫ');
INSERT INTO ylmf_city_id_name VALUES('2111','101271814','');
INSERT INTO ylmf_city_id_name VALUES('2112','101271815','');
INSERT INTO ylmf_city_id_name VALUES('2113','101271816','');
INSERT INTO ylmf_city_id_name VALUES('2114','101271817','');
INSERT INTO ylmf_city_id_name VALUES('2115','101271818','');
INSERT INTO ylmf_city_id_name VALUES('2116','101271901','');
INSERT INTO ylmf_city_id_name VALUES('2117','101271902','봨');
INSERT INTO ylmf_city_id_name VALUES('2118','101271903','');
INSERT INTO ylmf_city_id_name VALUES('2119','101271904','ï');
INSERT INTO ylmf_city_id_name VALUES('2120','101271905','');
INSERT INTO ylmf_city_id_name VALUES('2121','101271906','կ');
INSERT INTO ylmf_city_id_name VALUES('2122','101271907','');
INSERT INTO ylmf_city_id_name VALUES('2123','101271908','С');
INSERT INTO ylmf_city_id_name VALUES('2124','101271909','ˮ');
INSERT INTO ylmf_city_id_name VALUES('2125','101271910','');
INSERT INTO ylmf_city_id_name VALUES('2126','101271911','');
INSERT INTO ylmf_city_id_name VALUES('2127','101271912','');
INSERT INTO ylmf_city_id_name VALUES('2128','101271913','ԭ');
INSERT INTO ylmf_city_id_name VALUES('2129','101272001','');
INSERT INTO ylmf_city_id_name VALUES('2130','101272002','н');
INSERT INTO ylmf_city_id_name VALUES('2131','101272003','㺺');
INSERT INTO ylmf_city_id_name VALUES('2132','101272004','ʲ');
INSERT INTO ylmf_city_id_name VALUES('2133','101272005','');
INSERT INTO ylmf_city_id_name VALUES('2134','101272101','Ԫ');
INSERT INTO ylmf_city_id_name VALUES('2135','101272102','');
INSERT INTO ylmf_city_id_name VALUES('2136','101272103','ന');
INSERT INTO ylmf_city_id_name VALUES('2137','101272104','');
INSERT INTO ylmf_city_id_name VALUES('2138','101272105','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('2139','101280101','');
INSERT INTO ylmf_city_id_name VALUES('2140','101280102','خ');
INSERT INTO ylmf_city_id_name VALUES('2141','101280103','ӻ');
INSERT INTO ylmf_city_id_name VALUES('2142','101280104','');
INSERT INTO ylmf_city_id_name VALUES('2143','101280105','');
INSERT INTO ylmf_city_id_name VALUES('2144','101280106','');
INSERT INTO ylmf_city_id_name VALUES('2145','101280201','ع');
INSERT INTO ylmf_city_id_name VALUES('2146','101280202','Դ');
INSERT INTO ylmf_city_id_name VALUES('2147','101280203','ʼ');
INSERT INTO ylmf_city_id_name VALUES('2148','101280204','Դ');
INSERT INTO ylmf_city_id_name VALUES('2149','101280205','ֲ');
INSERT INTO ylmf_city_id_name VALUES('2150','101280206','ʻ');
INSERT INTO ylmf_city_id_name VALUES('2151','101280207','');
INSERT INTO ylmf_city_id_name VALUES('2152','101280208','·');
INSERT INTO ylmf_city_id_name VALUES('2153','101280301','');
INSERT INTO ylmf_city_id_name VALUES('2154','101280302','');
INSERT INTO ylmf_city_id_name VALUES('2155','101280304','ݶ');
INSERT INTO ylmf_city_id_name VALUES('2156','101280305','');
INSERT INTO ylmf_city_id_name VALUES('2157','101280401','÷');
INSERT INTO ylmf_city_id_name VALUES('2158','101280402','');
INSERT INTO ylmf_city_id_name VALUES('2159','101280403','');
INSERT INTO ylmf_city_id_name VALUES('2160','101280404','');
INSERT INTO ylmf_city_id_name VALUES('2161','101280406','˳');
INSERT INTO ylmf_city_id_name VALUES('2162','101280407','ƽԶ');
INSERT INTO ylmf_city_id_name VALUES('2163','101280408','廪');
INSERT INTO ylmf_city_id_name VALUES('2164','101280501','ͷ');
INSERT INTO ylmf_city_id_name VALUES('2165','101280502','');
INSERT INTO ylmf_city_id_name VALUES('2166','101280503','κ');
INSERT INTO ylmf_city_id_name VALUES('2167','101280504','ϰ');
INSERT INTO ylmf_city_id_name VALUES('2168','101280505','ư');
INSERT INTO ylmf_city_id_name VALUES('2169','101280506','쵺');
INSERT INTO ylmf_city_id_name VALUES('2170','101280601','');
INSERT INTO ylmf_city_id_name VALUES('2171','101280701','麣');
INSERT INTO ylmf_city_id_name VALUES('2172','101280702','');
INSERT INTO ylmf_city_id_name VALUES('2173','101280703','é');
INSERT INTO ylmf_city_id_name VALUES('2174','101280800','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2175','101280801','˳');
INSERT INTO ylmf_city_id_name VALUES('2176','101280802','ˮ');
INSERT INTO ylmf_city_id_name VALUES('2177','101280803','Ϻ');
INSERT INTO ylmf_city_id_name VALUES('2178','101280901','');
INSERT INTO ylmf_city_id_name VALUES('2179','101280902','');
INSERT INTO ylmf_city_id_name VALUES('2180','101280903','Ļ');
INSERT INTO ylmf_city_id_name VALUES('2181','101280905','');
INSERT INTO ylmf_city_id_name VALUES('2182','101280906','');
INSERT INTO ylmf_city_id_name VALUES('2183','101280907','⿪');
INSERT INTO ylmf_city_id_name VALUES('2184','101281001','տ');
INSERT INTO ylmf_city_id_name VALUES('2185','101281002','⴨');
INSERT INTO ylmf_city_id_name VALUES('2186','101281003','');
INSERT INTO ylmf_city_id_name VALUES('2187','101281004','');
INSERT INTO ylmf_city_id_name VALUES('2188','101281005','');
INSERT INTO ylmf_city_id_name VALUES('2189','101281006','');
INSERT INTO ylmf_city_id_name VALUES('2190','101281007','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('2191','101281101','');
INSERT INTO ylmf_city_id_name VALUES('2192','101281103','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2193','101281104','»');
INSERT INTO ylmf_city_id_name VALUES('2194','101281105','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2195','101281106','̨ɽ');
INSERT INTO ylmf_city_id_name VALUES('2196','101281107','ϴ');
INSERT INTO ylmf_city_id_name VALUES('2197','101281201','Դ');
INSERT INTO ylmf_city_id_name VALUES('2198','101281202','Ͻ');
INSERT INTO ylmf_city_id_name VALUES('2199','101281203','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2200','101281204','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2201','101281205','');
INSERT INTO ylmf_city_id_name VALUES('2202','101281301','Զ');
INSERT INTO ylmf_city_id_name VALUES('2203','101281302','');
INSERT INTO ylmf_city_id_name VALUES('2204','101281303','');
INSERT INTO ylmf_city_id_name VALUES('2205','101281304','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2206','101281305','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2207','101281306','');
INSERT INTO ylmf_city_id_name VALUES('2208','101281307','Ӣ');
INSERT INTO ylmf_city_id_name VALUES('2209','101281401','Ƹ');
INSERT INTO ylmf_city_id_name VALUES('2210','101281402','޶');
INSERT INTO ylmf_city_id_name VALUES('2211','101281403','');
INSERT INTO ylmf_city_id_name VALUES('2212','101281404','');
INSERT INTO ylmf_city_id_name VALUES('2213','101281501','');
INSERT INTO ylmf_city_id_name VALUES('2214','101281502','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2215','101281601','ݸ');
INSERT INTO ylmf_city_id_name VALUES('2216','101281701','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2217','101281801','');
INSERT INTO ylmf_city_id_name VALUES('2218','101281802','');
INSERT INTO ylmf_city_id_name VALUES('2219','101281901','');
INSERT INTO ylmf_city_id_name VALUES('2220','101281902','');
INSERT INTO ylmf_city_id_name VALUES('2221','101281903','');
INSERT INTO ylmf_city_id_name VALUES('2222','101281904','');
INSERT INTO ylmf_city_id_name VALUES('2223','101282001','ï');
INSERT INTO ylmf_city_id_name VALUES('2224','101282002','');
INSERT INTO ylmf_city_id_name VALUES('2225','101282003','');
INSERT INTO ylmf_city_id_name VALUES('2226','101282004','');
INSERT INTO ylmf_city_id_name VALUES('2227','101282005','');
INSERT INTO ylmf_city_id_name VALUES('2228','101282101','β');
INSERT INTO ylmf_city_id_name VALUES('2229','101282102','');
INSERT INTO ylmf_city_id_name VALUES('2230','101282103','½');
INSERT INTO ylmf_city_id_name VALUES('2231','101282104','');
INSERT INTO ylmf_city_id_name VALUES('2232','101282105','ɳ');
INSERT INTO ylmf_city_id_name VALUES('2233','101290101','');
INSERT INTO ylmf_city_id_name VALUES('2234','101290102','ũվ');
INSERT INTO ylmf_city_id_name VALUES('2235','101290103','');
INSERT INTO ylmf_city_id_name VALUES('2236','101290104','Ѱ');
INSERT INTO ylmf_city_id_name VALUES('2237','101290105','');
INSERT INTO ylmf_city_id_name VALUES('2238','101290106','');
INSERT INTO ylmf_city_id_name VALUES('2239','101290107','ʯ');
INSERT INTO ylmf_city_id_name VALUES('2240','101290108','ʹ');
INSERT INTO ylmf_city_id_name VALUES('2241','101290109','');
INSERT INTO ylmf_city_id_name VALUES('2242','101290110','');
INSERT INTO ylmf_city_id_name VALUES('2243','101290111','»Ȱ');
INSERT INTO ylmf_city_id_name VALUES('2244','101290112','');
INSERT INTO ylmf_city_id_name VALUES('2245','101290113','̫ɽ');
INSERT INTO ylmf_city_id_name VALUES('2246','101290114','ӿ');
INSERT INTO ylmf_city_id_name VALUES('2247','101290201','');
INSERT INTO ylmf_city_id_name VALUES('2248','101290202','');
INSERT INTO ylmf_city_id_name VALUES('2249','101290203','');
INSERT INTO ylmf_city_id_name VALUES('2250','101290204','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2251','101290205','');
INSERT INTO ylmf_city_id_name VALUES('2252','101290206','ֶ');
INSERT INTO ylmf_city_id_name VALUES('2253','101290207','');
INSERT INTO ylmf_city_id_name VALUES('2254','101290208','κɽ');
INSERT INTO ylmf_city_id_name VALUES('2255','101290209','');
INSERT INTO ylmf_city_id_name VALUES('2256','101290210','Դ');
INSERT INTO ylmf_city_id_name VALUES('2257','101290211','');
INSERT INTO ylmf_city_id_name VALUES('2258','101290212','Ͻ');
INSERT INTO ylmf_city_id_name VALUES('2259','101290301','');
INSERT INTO ylmf_city_id_name VALUES('2260','101290302','ʯ');
INSERT INTO ylmf_city_id_name VALUES('2261','101290303','ˮ');
INSERT INTO ylmf_city_id_name VALUES('2262','101290304','');
INSERT INTO ylmf_city_id_name VALUES('2263','101290305','Ԫ');
INSERT INTO ylmf_city_id_name VALUES('2264','101290306','̴');
INSERT INTO ylmf_city_id_name VALUES('2265','101290307','Զ');
INSERT INTO ylmf_city_id_name VALUES('2266','101290308','');
INSERT INTO ylmf_city_id_name VALUES('2267','101290309','');
INSERT INTO ylmf_city_id_name VALUES('2268','101290310','');
INSERT INTO ylmf_city_id_name VALUES('2269','101290311','');
INSERT INTO ylmf_city_id_name VALUES('2270','101290312','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2271','101290401','');
INSERT INTO ylmf_city_id_name VALUES('2272','101290402','մ');
INSERT INTO ylmf_city_id_name VALUES('2273','101290403','½');
INSERT INTO ylmf_city_id_name VALUES('2274','101290404','Դ');
INSERT INTO ylmf_city_id_name VALUES('2275','101290405','');
INSERT INTO ylmf_city_id_name VALUES('2276','101290406','ʦ');
INSERT INTO ylmf_city_id_name VALUES('2277','101290407','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2278','101290408','');
INSERT INTO ylmf_city_id_name VALUES('2279','101290409','');
INSERT INTO ylmf_city_id_name VALUES('2280','101290501','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2281','101290502','');
INSERT INTO ylmf_city_id_name VALUES('2282','101290503','');
INSERT INTO ylmf_city_id_name VALUES('2283','101290504','ʩ');
INSERT INTO ylmf_city_id_name VALUES('2284','101290505','');
INSERT INTO ylmf_city_id_name VALUES('2285','101290506','ڳ');
INSERT INTO ylmf_city_id_name VALUES('2286','101290601','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2287','101290602','');
INSERT INTO ylmf_city_id_name VALUES('2288','101290603','');
INSERT INTO ylmf_city_id_name VALUES('2289','101290604','');
INSERT INTO ylmf_city_id_name VALUES('2290','101290605','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2291','101290606','');
INSERT INTO ylmf_city_id_name VALUES('2292','101290607','');
INSERT INTO ylmf_city_id_name VALUES('2293','101290701','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('2294','101290702','ν');
INSERT INTO ylmf_city_id_name VALUES('2295','101290703','');
INSERT INTO ylmf_city_id_name VALUES('2296','101290704','ͨ');
INSERT INTO ylmf_city_id_name VALUES('2297','101290705','');
INSERT INTO ylmf_city_id_name VALUES('2298','101290706','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2299','101290707','');
INSERT INTO ylmf_city_id_name VALUES('2300','101290708','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2301','101290709','Ԫ');
INSERT INTO ylmf_city_id_name VALUES('2302','101290801','');
INSERT INTO ylmf_city_id_name VALUES('2303','101290802','Ҧ');
INSERT INTO ylmf_city_id_name VALUES('2304','101290803','Ԫı');
INSERT INTO ylmf_city_id_name VALUES('2305','101290804','Ҧ');
INSERT INTO ylmf_city_id_name VALUES('2306','101290805','Ĳ');
INSERT INTO ylmf_city_id_name VALUES('2307','101290806','ϻ');
INSERT INTO ylmf_city_id_name VALUES('2308','101290807','䶨');
INSERT INTO ylmf_city_id_name VALUES('2309','101290808','»');
INSERT INTO ylmf_city_id_name VALUES('2310','101290809','˫');
INSERT INTO ylmf_city_id_name VALUES('2311','101290810','');
INSERT INTO ylmf_city_id_name VALUES('2312','101290901','˼é');
INSERT INTO ylmf_city_id_name VALUES('2313','101290902','');
INSERT INTO ylmf_city_id_name VALUES('2314','101290903','');
INSERT INTO ylmf_city_id_name VALUES('2315','101290904','');
INSERT INTO ylmf_city_id_name VALUES('2316','101290905','ն');
INSERT INTO ylmf_city_id_name VALUES('2317','101290906','ī');
INSERT INTO ylmf_city_id_name VALUES('2318','101290907','');
INSERT INTO ylmf_city_id_name VALUES('2319','101290908','');
INSERT INTO ylmf_city_id_name VALUES('2320','101290909','');
INSERT INTO ylmf_city_id_name VALUES('2321','101290910','Դ');
INSERT INTO ylmf_city_id_name VALUES('2322','101291001','ͨ');
INSERT INTO ylmf_city_id_name VALUES('2323','101291002','³');
INSERT INTO ylmf_city_id_name VALUES('2324','101291003','');
INSERT INTO ylmf_city_id_name VALUES('2325','101291004','');
INSERT INTO ylmf_city_id_name VALUES('2326','101291005','');
INSERT INTO ylmf_city_id_name VALUES('2327','101291006','ɼ');
INSERT INTO ylmf_city_id_name VALUES('2328','101291007','罭');
INSERT INTO ylmf_city_id_name VALUES('2329','101291008','');
INSERT INTO ylmf_city_id_name VALUES('2330','101291009','ν');
INSERT INTO ylmf_city_id_name VALUES('2331','101291010','');
INSERT INTO ylmf_city_id_name VALUES('2332','101291101','ٲ');
INSERT INTO ylmf_city_id_name VALUES('2333','101291102','Դ');
INSERT INTO ylmf_city_id_name VALUES('2334','101291103','');
INSERT INTO ylmf_city_id_name VALUES('2335','101291104','˫');
INSERT INTO ylmf_city_id_name VALUES('2336','101291105','');
INSERT INTO ylmf_city_id_name VALUES('2337','101291106','');
INSERT INTO ylmf_city_id_name VALUES('2338','101291107','');
INSERT INTO ylmf_city_id_name VALUES('2339','101291108','');
INSERT INTO ylmf_city_id_name VALUES('2340','101291201','ŭ');
INSERT INTO ylmf_city_id_name VALUES('2341','101291203','');
INSERT INTO ylmf_city_id_name VALUES('2342','101291204','ƺ');
INSERT INTO ylmf_city_id_name VALUES('2343','101291205','ˮ');
INSERT INTO ylmf_city_id_name VALUES('2344','101291206','');
INSERT INTO ylmf_city_id_name VALUES('2345','101291301','');
INSERT INTO ylmf_city_id_name VALUES('2346','101291302','');
INSERT INTO ylmf_city_id_name VALUES('2347','101291303','ά');
INSERT INTO ylmf_city_id_name VALUES('2348','101291401','');
INSERT INTO ylmf_city_id_name VALUES('2349','101291402','ʤ');
INSERT INTO ylmf_city_id_name VALUES('2350','101291403','ƺ');
INSERT INTO ylmf_city_id_name VALUES('2351','101291404','');
INSERT INTO ylmf_city_id_name VALUES('2352','101291501','º');
INSERT INTO ylmf_city_id_name VALUES('2353','101291502','º');
INSERT INTO ylmf_city_id_name VALUES('2354','101291503','¤');
INSERT INTO ylmf_city_id_name VALUES('2355','101291504','ӯ');
INSERT INTO ylmf_city_id_name VALUES('2356','101291505','');
INSERT INTO ylmf_city_id_name VALUES('2357','101291506','');
INSERT INTO ylmf_city_id_name VALUES('2358','101291507','');
INSERT INTO ylmf_city_id_name VALUES('2359','101291601','');
INSERT INTO ylmf_city_id_name VALUES('2360','101291602','');
INSERT INTO ylmf_city_id_name VALUES('2361','101291603','º');
INSERT INTO ylmf_city_id_name VALUES('2362','101291604','վ');
INSERT INTO ylmf_city_id_name VALUES('2363','101291605','');
INSERT INTO ylmf_city_id_name VALUES('2364','101300101','');
INSERT INTO ylmf_city_id_name VALUES('2365','101300103','');
INSERT INTO ylmf_city_id_name VALUES('2366','101300104','');
INSERT INTO ylmf_city_id_name VALUES('2367','101300105','¡');
INSERT INTO ylmf_city_id_name VALUES('2368','101300106','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2369','101300107','');
INSERT INTO ylmf_city_id_name VALUES('2370','101300108','');
INSERT INTO ylmf_city_id_name VALUES('2371','101300109','');
INSERT INTO ylmf_city_id_name VALUES('2372','101300110','˶');
INSERT INTO ylmf_city_id_name VALUES('2373','101300201','');
INSERT INTO ylmf_city_id_name VALUES('2374','101300202','');
INSERT INTO ylmf_city_id_name VALUES('2375','101300203','');
INSERT INTO ylmf_city_id_name VALUES('2376','101300204','ƾ');
INSERT INTO ylmf_city_id_name VALUES('2377','101300205','');
INSERT INTO ylmf_city_id_name VALUES('2378','101300206','');
INSERT INTO ylmf_city_id_name VALUES('2379','101300207','');
INSERT INTO ylmf_city_id_name VALUES('2380','101300208','Ԩ');
INSERT INTO ylmf_city_id_name VALUES('2381','101300301','');
INSERT INTO ylmf_city_id_name VALUES('2382','101300302','');
INSERT INTO ylmf_city_id_name VALUES('2383','101300303','ɳ');
INSERT INTO ylmf_city_id_name VALUES('2384','101300304','¹կ');
INSERT INTO ylmf_city_id_name VALUES('2385','101300305','');
INSERT INTO ylmf_city_id_name VALUES('2386','101300306','ڰ');
INSERT INTO ylmf_city_id_name VALUES('2387','101300307','ˮ');
INSERT INTO ylmf_city_id_name VALUES('2388','101300308','');
INSERT INTO ylmf_city_id_name VALUES('2389','101300401','');
INSERT INTO ylmf_city_id_name VALUES('2390','101300402','ó');
INSERT INTO ylmf_city_id_name VALUES('2391','101300403','');
INSERT INTO ylmf_city_id_name VALUES('2392','101300404','');
INSERT INTO ylmf_city_id_name VALUES('2393','101300405','');
INSERT INTO ylmf_city_id_name VALUES('2394','101300501','');
INSERT INTO ylmf_city_id_name VALUES('2395','101300502','ũվ');
INSERT INTO ylmf_city_id_name VALUES('2396','101300503','ʤ');
INSERT INTO ylmf_city_id_name VALUES('2397','101300504','');
INSERT INTO ylmf_city_id_name VALUES('2398','101300505','ٹ');
INSERT INTO ylmf_city_id_name VALUES('2399','101300506','˰');
INSERT INTO ylmf_city_id_name VALUES('2400','101300507','鴨');
INSERT INTO ylmf_city_id_name VALUES('2401','101300508','ȫ');
INSERT INTO ylmf_city_id_name VALUES('2402','101300509','');
INSERT INTO ylmf_city_id_name VALUES('2403','101300510','˷');
INSERT INTO ylmf_city_id_name VALUES('2404','101300511','');
INSERT INTO ylmf_city_id_name VALUES('2405','101300512','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2406','101300513','');
INSERT INTO ylmf_city_id_name VALUES('2407','101300514','Դ');
INSERT INTO ylmf_city_id_name VALUES('2408','101300601','');
INSERT INTO ylmf_city_id_name VALUES('2409','101300602','');
INSERT INTO ylmf_city_id_name VALUES('2410','101300603','̫ƽ');
INSERT INTO ylmf_city_id_name VALUES('2411','101300604','');
INSERT INTO ylmf_city_id_name VALUES('2412','101300605','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2413','101300606','Ϫ');
INSERT INTO ylmf_city_id_name VALUES('2414','101300701','');
INSERT INTO ylmf_city_id_name VALUES('2415','101300702','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2416','101300703','');
INSERT INTO ylmf_city_id_name VALUES('2417','101300704','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2418','101300705','Ŷ');
INSERT INTO ylmf_city_id_name VALUES('2419','101300801','');
INSERT INTO ylmf_city_id_name VALUES('2420','101300802','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2421','101300803','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2422','101300901','');
INSERT INTO ylmf_city_id_name VALUES('2423','101300902','');
INSERT INTO ylmf_city_id_name VALUES('2424','101300903','');
INSERT INTO ylmf_city_id_name VALUES('2425','101300904','');
INSERT INTO ylmf_city_id_name VALUES('2426','101300905','½');
INSERT INTO ylmf_city_id_name VALUES('2427','101301001','ɫ');
INSERT INTO ylmf_city_id_name VALUES('2428','101301002','');
INSERT INTO ylmf_city_id_name VALUES('2429','101301003','');
INSERT INTO ylmf_city_id_name VALUES('2430','101301004','±');
INSERT INTO ylmf_city_id_name VALUES('2431','101301005','');
INSERT INTO ylmf_city_id_name VALUES('2432','101301006','ﶫ');
INSERT INTO ylmf_city_id_name VALUES('2433','101301007','ƽ');
INSERT INTO ylmf_city_id_name VALUES('2434','101301008','¡');
INSERT INTO ylmf_city_id_name VALUES('2435','101301009','');
INSERT INTO ylmf_city_id_name VALUES('2436','101301010','ҵ');
INSERT INTO ylmf_city_id_name VALUES('2437','101301011','');
INSERT INTO ylmf_city_id_name VALUES('2438','101301012','');
INSERT INTO ylmf_city_id_name VALUES('2439','101301101','');
INSERT INTO ylmf_city_id_name VALUES('2440','101301102','ֱ');
INSERT INTO ylmf_city_id_name VALUES('2441','101301103','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2442','101301201','ӳ');
INSERT INTO ylmf_city_id_name VALUES('2443','101301202','');
INSERT INTO ylmf_city_id_name VALUES('2444','101301203','');
INSERT INTO ylmf_city_id_name VALUES('2445','101301204','');
INSERT INTO ylmf_city_id_name VALUES('2446','101301205','');
INSERT INTO ylmf_city_id_name VALUES('2447','101301206','޳');
INSERT INTO ylmf_city_id_name VALUES('2448','101301207','');
INSERT INTO ylmf_city_id_name VALUES('2449','101301208','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2450','101301209','ϵ');
INSERT INTO ylmf_city_id_name VALUES('2451','101301210','');
INSERT INTO ylmf_city_id_name VALUES('2452','101301301','');
INSERT INTO ylmf_city_id_name VALUES('2453','101301302','');
INSERT INTO ylmf_city_id_name VALUES('2454','101301303','޵');
INSERT INTO ylmf_city_id_name VALUES('2455','101301401','Ǹ');
INSERT INTO ylmf_city_id_name VALUES('2456','101301402','˼');
INSERT INTO ylmf_city_id_name VALUES('2457','101301403','');
INSERT INTO ylmf_city_id_name VALUES('2458','101301404','');
INSERT INTO ylmf_city_id_name VALUES('2459','101301405','');
INSERT INTO ylmf_city_id_name VALUES('2460','101310101','');
INSERT INTO ylmf_city_id_name VALUES('2461','101310102','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2462','101310201','');
INSERT INTO ylmf_city_id_name VALUES('2463','101310202','');
INSERT INTO ylmf_city_id_name VALUES('2464','101310203','ٸ');
INSERT INTO ylmf_city_id_name VALUES('2465','101310204','');
INSERT INTO ylmf_city_id_name VALUES('2466','101310205','');
INSERT INTO ylmf_city_id_name VALUES('2467','101310206','');
INSERT INTO ylmf_city_id_name VALUES('2468','101310207','ɳ');
INSERT INTO ylmf_city_id_name VALUES('2469','101310208','');
INSERT INTO ylmf_city_id_name VALUES('2470','101310209','');
INSERT INTO ylmf_city_id_name VALUES('2471','101310210','Ͳ');
INSERT INTO ylmf_city_id_name VALUES('2472','101310211','');
INSERT INTO ylmf_city_id_name VALUES('2473','101310212','Ĳ');
INSERT INTO ylmf_city_id_name VALUES('2474','101310213','');
INSERT INTO ylmf_city_id_name VALUES('2475','101310214','ͤ');
INSERT INTO ylmf_city_id_name VALUES('2476','101310215','');
INSERT INTO ylmf_city_id_name VALUES('2477','101310216','ˮ');
INSERT INTO ylmf_city_id_name VALUES('2478','101310217','ɳ');
INSERT INTO ylmf_city_id_name VALUES('2479','101310218','ɺ');
INSERT INTO ylmf_city_id_name VALUES('2480','101310219','');
INSERT INTO ylmf_city_id_name VALUES('2481','101310220','ɳ');
INSERT INTO ylmf_city_id_name VALUES('2482','101310221','ֶ');
INSERT INTO ylmf_city_id_name VALUES('2483','101310222','ͨʲ');
INSERT INTO ylmf_city_id_name VALUES('2484','101320101','');
INSERT INTO ylmf_city_id_name VALUES('2485','101320102','');
INSERT INTO ylmf_city_id_name VALUES('2486','101320103','½');
INSERT INTO ylmf_city_id_name VALUES('2487','101320104','л');
INSERT INTO ylmf_city_id_name VALUES('2488','101320105','ͭ');
INSERT INTO ylmf_city_id_name VALUES('2489','101330101','');
INSERT INTO ylmf_city_id_name VALUES('2490','101340101','̨');
INSERT INTO ylmf_city_id_name VALUES('2491','101340102','̨');
INSERT INTO ylmf_city_id_name VALUES('2492','101340201','');
INSERT INTO ylmf_city_id_name VALUES('2493','101340202','');
INSERT INTO ylmf_city_id_name VALUES('2494','101340203','');
INSERT INTO ylmf_city_id_name VALUES('2495','101340204','㴺');
INSERT INTO ylmf_city_id_name VALUES('2496','101340205','');
INSERT INTO ylmf_city_id_name VALUES('2497','101340301','̨');
INSERT INTO ylmf_city_id_name VALUES('2498','101340401','̨');
INSERT INTO ylmf_city_id_name VALUES('2499','101340501','԰');
INSERT INTO ylmf_city_id_name VALUES('2500','101340601','');
INSERT INTO ylmf_city_id_name VALUES('2501','101340602','');
INSERT INTO ylmf_city_id_name VALUES('2502','101340603','');
INSERT INTO ylmf_city_id_name VALUES('2503','101340701','');
INSERT INTO ylmf_city_id_name VALUES('2504','101340801','');
INSERT INTO ylmf_city_id_name VALUES('2505','101340802','');
INSERT INTO ylmf_city_id_name VALUES('2506','101340901','');
INSERT INTO ylmf_city_id_name VALUES('2507','101340902','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2508','101340903','ɽ');
INSERT INTO ylmf_city_id_name VALUES('2509','101340904','¸');
INSERT INTO ylmf_city_id_name VALUES('2510','101341001','');
INSERT INTO ylmf_city_id_name VALUES('2511','101341101','̨');
INSERT INTO ylmf_city_id_name VALUES('2512','101341201','');

INSERT INTO ylmf_city_mingzhan VALUES('9','Ϻ','http://www.online.sh.cn/','1','1','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('10','Ϻ','http://www.expo2010.cn/','1','2','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('11','','http://www.eastday.com/','1','3','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('12','ɽ','http://www.kdslife.com/','1','4','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('13','','http://www.xinmin.cn/','1','5','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('14','ţ','http://www.jfdaily.com/','1','6','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('15','Ϻ㲥̨','http://www.smg.cn/','1','7','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('16','ʿ','http://www.dragontv.cn/','1','8','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('17','','http://www.ddmap.com/','1','9','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('18','Ϻ','http://www.why.com.cn/','1','10','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('19','Ϻڱ','http://www.shfinancialnews.com/','1','11','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('20','','http://www.liba.com/1','1','12','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('21','籨','http://www.dfdaily.com/','1','13','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('22','ɽ','http://www.spc365.com/','1','14','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('23','Ƶ','http://www.smgbb.cn/','1','15','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('24','58ͬ','http://sh.58.com/','1','16','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('25','Ϻ','http://www.shanghaitour.net/','1','17','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('26','Ϻξ','http://lyw.sh.gov.cn/','1','18','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('27','Ϻ˲','http://www.dshrc.com/','1','19','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('28','Ϻ','http://www.shmetro.com/','1','20','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('60','֮','http://www.sz.net.cn/','5','2','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('30','Ϻͼ','http://map.baidu.com/?newmap=1&s=s%26wd%3D%E4%B8%8A%E6%B5%B7%E5%B8%82%26c%3D289&fr=alab0','1','21','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('31','ƶ','http://www.sh.10086.cn/','1','22','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('32','ͨ','http://www.sh.chinaunicom.com/','1','23','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('33','','http://sh.ct10000.com/','1','24','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('34','Ӵ','http://www.gznet.com/','3','1','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('35','  ','http://www.dayoo.com/','3','2','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('36','˻','http://www.gz2010.cn/','3','3','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('37','ձ','http://gzdaily.dayoo.com/','3','4','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('38','','http://www.ycwb.com/ePaper/ycwb/','3','5','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('39','Ϸ','http://www.nfdaily.cn/','3','6','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('40','  ','http://www.southcn.com/','3','7','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('41','  ','http://www.ycwb.com/','3','8','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('42','  ','http://www.020.com/','3','9','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('43','  ','http://www.gztv.com/','3','10','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('44','  ','http://www.goofm.com/','3','11','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('45','','http://www.gz.gov.cn/','3','12','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('46','й','http://www.gzjd.gov.cn/','3','13','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('47','㶫̨','http://www.gdtv.com.cn/','3','14','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('48','Ϸ̨','http://www.tvscn.com/','3','15','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('49','','http://www.gzcb.com.cn/','3','16','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('50','','http://www.visitgz.com/','3','17','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('51','˲','http://www.020job.com/','3','18','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('52','й','http://www.gov.cn/','3','19','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('53','ݵ','http://www.gzmtr.com/','3','20','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('54','ݵͼ','http://map.baidu.com/?newmap=1&s=s%26wd%3D%E5%B9%BF%E5%B7%9E%E5%B8%82%26c%3D257&fr=alab0','3','21','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('55','ƶ','http://gd.10086.cn/guangzhou/','3','22','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('56','ͨ','http://info.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?arno=000100040001','3','23','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('57','','http://gd.ct10000.com/gz/','3','24','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('58','','http://www.gznews.gov.cn/','3','20','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('59','','http://www.sznews.com/','5','1','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('61','','http://www.sz.gov.cn/cn/','5','3','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('62','','http://www.szonline.net/','5','4','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('63','','http://www.szhk.com/','5','5','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('64','Ϣ','http://www.szinfo.com/','5','6','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('65','','http://www.szol.net/','5','7','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('66','ڵ̨','http://www.sztv.com.cn/','5','8','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('67','һ','http://www.oeeee.com/','5','9','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('68','ĥ','http://www.doyouhike.net/','5','10','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('69','ڷز','http://www.szhome.com/','5','11','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('70','ڹ','http://www.szga.gov.cn/','5','12','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('71','ڹ㲥','http://www.szr.com.cn/','5','13','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('72','','http://www.szlgnews.com/','5','14','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('73','','http://www.shenzhentour.com/','5','15','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('74','58ͬ','http://sz.58.com/','5','16','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('75','ڱر','http://sz.bendibao.com/','5','17','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('76','IT','http://www.szit.com.cn/','5','18','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('77','˲','http://www.szhr.com.cn/','5','19','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('78','ڵ','http://www.szmc.net/','5','20','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('79','ڵͼ','http://map.baidu.com/?newmap=1&s=s%26wd%3D%E6%B7%B1%E5%9C%B3%E5%B8%82%26c%3D340&fr=alab0','5','21','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('80','ƶ','http://gd.10086.cn/shenzhen/','5','22','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('81','ͨ','http://info2.10010.com/lt/plugin/portal/arealevel/queryCityInfo.do?id=1677&arno=000100040002','5','23','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('82','','http://gd.ct10000.com/sz/','5','24','0','0','','0','');
INSERT INTO ylmf_city_mingzhan VALUES('83','׶֮','http://www.beijing.gov.cn/','10','1','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('84','','http://www.beijing.cn/','10','2','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('85','ǧ','http://www.qianlong.com/','10','3','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('86','CNTV','http://www.cntv.cn/','10','4','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('87','','http://www.bbn.com.cn/','10','5','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('88','','http://www.bjd.com.cn/','10','6','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('89','»','http://www.bj.xinhuanet.com/','10','7','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('90','','http://bj.people.com.cn/GB/index.html','10','8','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('91','㲥','http://www.rbc.cn/','10','9','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('92','̨','http://www.btv.com.cn/','10','10','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('93','¾','http://www.bjnews.com.cn/','10','11','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('94','','http://www.morningpost.com.cn/','10','12','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('95','','http://www.ynet.com/','10','13','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('96','ܱ','http://www.beijingreview.com.cn/','10','14','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('97','','http://www.gmw.cn/','10','15','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('98','','http://www.jinghua.cn/','10','16','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('99','58ͬ','http://bj.58.com/','10','17','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('100','','http://www.bjta.gov.cn/','10','18','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('101','˲','http://www.bjrc.com/','10','19','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('102','','http://www.bjsubway.com/','10','20','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('103','ͼ','http://map.baidu.com/?newmap=1&s=s%26wd%3D%E5%8C%97%E4%BA%AC%E5%B8%82%26c%3D131&fr=alab0','10','21','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('104','ƶ','http://www.bj.10086.cn/','10','22','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('105','ͨ','http://www.bj.chinaunicom.com/','10','23','0','0','','1','');
INSERT INTO ylmf_city_mingzhan VALUES('106','','http://www.bjtelecom.net/','10','24','0','0','','1','');


INSERT INTO ylmf_class VALUES('1','0','','','','1','0','','');
INSERT INTO ylmf_class VALUES('2','0','','','','2','0','','');
INSERT INTO ylmf_class VALUES('3','0','Ļ','','','3','0','','');
INSERT INTO ylmf_class VALUES('4','0','','','','4','0','','');
INSERT INTO ylmf_class VALUES('644','1','С˵','','','106','0','wenxue_xiaoshuo','');
INSERT INTO ylmf_class VALUES('645','644','С˵Ķ','','','0','30','/wenxue_xiaoshuo/','');
INSERT INTO ylmf_class VALUES('2151','927','̳','','','4','0','','');
INSERT INTO ylmf_class VALUES('647','2209','С˵̳','','','4','14','','');
INSERT INTO ylmf_class VALUES('648','644','Ʒ','','','4','30','','');
INSERT INTO ylmf_class VALUES('649','644','Ļѧ','','','3','15','','');
INSERT INTO ylmf_class VALUES('2101','783','ˮѧ','','','4','5','','');
INSERT INTO ylmf_class VALUES('2103','1588','','','','3','9','','');
INSERT INTO ylmf_class VALUES('652','1','Ӱ','','','117','0','sheying','');
INSERT INTO ylmf_class VALUES('653','2199','','','','3','10','','');
INSERT INTO ylmf_class VALUES('1923','2172','ǺԮ','','','5','27','','');
INSERT INTO ylmf_class VALUES('1603','755','̨','','','10000','5','','');
INSERT INTO ylmf_class VALUES('2275','5','','','','100','0','liansai','');
INSERT INTO ylmf_class VALUES('2156','1036','ѧƿμ̰','','','4','0','','');
INSERT INTO ylmf_class VALUES('658','2','','','','123','0','yule','');
INSERT INTO ylmf_class VALUES('659','658','ۺ','','','0','22','','');
INSERT INTO ylmf_class VALUES('1973','731','ЦƵ','','','1','7','','');
INSERT INTO ylmf_class VALUES('1924','2172','','','','6','17','','');
INSERT INTO ylmf_class VALUES('2286','2285','Խ','','','0','8','','');
INSERT INTO ylmf_class VALUES('2288','644','Ķ','','','5','5','','');
INSERT INTO ylmf_class VALUES('664','2218','Ů','','','0','34','/lady/','');
INSERT INTO ylmf_class VALUES('665','2285','ʿŮ','','','4','13','','');
INSERT INTO ylmf_class VALUES('1978','921','Żȯ','','','3','5','','');
INSERT INTO ylmf_class VALUES('2028','1596','Ϸ','','','6','9','','');
INSERT INTO ylmf_class VALUES('668','4','','','','108','0','blog','');
INSERT INTO ylmf_class VALUES('669','668','','','','0','25','/blog/','');
INSERT INTO ylmf_class VALUES('670','668','ܱ','','','3','10','','');
INSERT INTO ylmf_class VALUES('1931','2209','̳','','','22','9','','');
INSERT INTO ylmf_class VALUES('673','668','ժ/ǩ','','','4','10','','');
INSERT INTO ylmf_class VALUES('674','1','','','','114','0','luntan_shequ','');
INSERT INTO ylmf_class VALUES('675','674','ۺ̳','','','0','46','/luntan_shequ/','');
INSERT INTO ylmf_class VALUES('1937','1936','̳','','','10000','7','','');
INSERT INTO ylmf_class VALUES('678','2209','̳','','','6','34','','');
INSERT INTO ylmf_class VALUES('1933','2209','̳','','','20','13','','');
INSERT INTO ylmf_class VALUES('680','2209','ȫ̳','','','7','6','','');
INSERT INTO ylmf_class VALUES('681','2209','Ӳ̳','','','5','18','','');
INSERT INTO ylmf_class VALUES('2160','974','֪ʶ','','','2','6','','');
INSERT INTO ylmf_class VALUES('684','2209','ͼ̳','','','14','9','','');
INSERT INTO ylmf_class VALUES('685','2209','Ц̳','','','15','10','','');
INSERT INTO ylmf_class VALUES('686','2209','̳','','','3','25','','');
INSERT INTO ylmf_class VALUES('2104','1588','','','','4','4','','');
INSERT INTO ylmf_class VALUES('689','2209','̳','','','8','8','','');
INSERT INTO ylmf_class VALUES('690','2209','ֻ̳','','','9','15','','');
INSERT INTO ylmf_class VALUES('691','2209','̳','','','10','8','','');
INSERT INTO ylmf_class VALUES('1936','674','ط̳','','','3','0','','');
INSERT INTO ylmf_class VALUES('693','2209','̳','','','11','25','','');
INSERT INTO ylmf_class VALUES('1932','2209','̳','','','17','8','','');
INSERT INTO ylmf_class VALUES('2077','2209','̳','','','13','17','','');
INSERT INTO ylmf_class VALUES('697','2209','̳','','','12','20','','');
INSERT INTO ylmf_class VALUES('698','1','Ϸ','','','103','0','youxi_wangyou','');
INSERT INTO ylmf_class VALUES('699','698','Ϸۺ','','','0','28','/youxi_wangyou/','');
INSERT INTO ylmf_class VALUES('700','765','ֻԴ','','','5','13','','');
INSERT INTO ylmf_class VALUES('701','2215','СϷ','','','0','26','/xiaoyouxi/','');
INSERT INTO ylmf_class VALUES('703','2209','Ϸ̳','','','16','14','','');
INSERT INTO ylmf_class VALUES('704','698','Ϸ','','','6','10','','');
INSERT INTO ylmf_class VALUES('706','698','','','','8','10','','');
INSERT INTO ylmf_class VALUES('2145','795','Ӱ','','','100','5','','');
INSERT INTO ylmf_class VALUES('708','1','ͼ','','','110','0','bizhi_tuku','');
INSERT INTO ylmf_class VALUES('709','708','ۺͼ','','','0','15','','');
INSERT INTO ylmf_class VALUES('710','708','Ů','','','3','12','','');
INSERT INTO ylmf_class VALUES('711','2219','ֽ','','','0','21','','');
INSERT INTO ylmf_class VALUES('712','2219','','','','4','8','','');
INSERT INTO ylmf_class VALUES('2110','1588','ƾ','','','6','4','','');
INSERT INTO ylmf_class VALUES('715','1','','','','101','0','yinyue_mp3','');
INSERT INTO ylmf_class VALUES('716','715','','','','0','25','/yinyue_mp3/','');
INSERT INTO ylmf_class VALUES('717','715','ܱ','','','4','16','','');
INSERT INTO ylmf_class VALUES('719','2223','ַ/ԭ','','','6','9','','');
INSERT INTO ylmf_class VALUES('720','715','DJ','','','2','14','','');
INSERT INTO ylmf_class VALUES('725','1','','','','118','0','junshi','');
INSERT INTO ylmf_class VALUES('726','725','Ѷ','','','7','20','/junshi/','');
INSERT INTO ylmf_class VALUES('727','725','̳','','','0','14','','');
INSERT INTO ylmf_class VALUES('2296','2225','繫ƽ̨','','','7','5','','');
INSERT INTO ylmf_class VALUES('730','725','ר','','','5','8','','');
INSERT INTO ylmf_class VALUES('731','1','Ц','','','113','0','fun','');
INSERT INTO ylmf_class VALUES('732','731','Цȫ','','','0','15','','');
INSERT INTO ylmf_class VALUES('733','731','܇','','','3','10','','');
INSERT INTO ylmf_class VALUES('734','2','ʱ','','','118','0','fashion','');
INSERT INTO ylmf_class VALUES('735','734','ʱѶ','','','0','18','','');
INSERT INTO ylmf_class VALUES('736','2218','','','','2','20','','');
INSERT INTO ylmf_class VALUES('737','2188','ױƷ','','','4','19','','');
INSERT INTO ylmf_class VALUES('738','734','ʱ־','','','4','14','','');
INSERT INTO ylmf_class VALUES('739','921','ʳۺ','','','0','20','','');
INSERT INTO ylmf_class VALUES('2197','921','ʳ','','','2','5','','');
INSERT INTO ylmf_class VALUES('741','4','','','','109','0','liaotian_qq','');
INSERT INTO ylmf_class VALUES('742','741','','','','2','10','','');
INSERT INTO ylmf_class VALUES('2146','1711','ϵ','','','100','5','','');
INSERT INTO ylmf_class VALUES('744','741','칤','','','0','24','','');
INSERT INTO ylmf_class VALUES('745','741','QQ','','','5','13','','');
INSERT INTO ylmf_class VALUES('1930','2209','ɫ̳','','','10000','40','','');
INSERT INTO ylmf_class VALUES('748','2226','','','','106','0','dianshidiantai','');
INSERT INTO ylmf_class VALUES('749','2167','Ȳ̨','','','10000','24','','');
INSERT INTO ylmf_class VALUES('2051','2050','ξ','','','1','12','','');
INSERT INTO ylmf_class VALUES('751','748','ط̨','','','4','0','','');
INSERT INTO ylmf_class VALUES('752','748','Ѷ','','','10000','10','','');
INSERT INTO ylmf_class VALUES('2031','891','ξ','','','5','7','','');
INSERT INTO ylmf_class VALUES('754','2167','Ź㲥̨','','','5','27','','');
INSERT INTO ylmf_class VALUES('755','748','ط̨','','','5','0','','');
INSERT INTO ylmf_class VALUES('756','748','̨','','','2','10','','');
INSERT INTO ylmf_class VALUES('757','4','Flash','','','126','0','flash-show','');
INSERT INTO ylmf_class VALUES('758','757','Flash','','','0','13','','');
INSERT INTO ylmf_class VALUES('759','757','СϷ','','','2','10','','');
INSERT INTO ylmf_class VALUES('760','757','Flash̳','','','4','9','','');
INSERT INTO ylmf_class VALUES('762','757','Flash','','','5','4','','');
INSERT INTO ylmf_class VALUES('765','2','ֻ','','','110','0','shouji','');
INSERT INTO ylmf_class VALUES('766','765','ֻۺ','','','0','21','/shouji/','');
INSERT INTO ylmf_class VALUES('767','765','ֻ̳','','','4','12','','');
INSERT INTO ylmf_class VALUES('768','765','ֻƷ','','','3','14','','');
INSERT INTO ylmf_class VALUES('769','765','ֻͼ/','','','7','10','','');
INSERT INTO ylmf_class VALUES('770','765','ֻ','','','2','5','','');
INSERT INTO ylmf_class VALUES('2154','2273','֪','','','100','58','','');
INSERT INTO ylmf_class VALUES('1975','803','','','','4','6','','');
INSERT INTO ylmf_class VALUES('774','2091','ͨѶ','','','1','10','','');
INSERT INTO ylmf_class VALUES('775','2091','Ӫ','','','0','4','','');
INSERT INTO ylmf_class VALUES('776','1','','','','112','0','dongman','');
INSERT INTO ylmf_class VALUES('777','776','ۺ','','','0','28','','');
INSERT INTO ylmf_class VALUES('778','776','','','','2','5','','');
INSERT INTO ylmf_class VALUES('779','776','ר','','','3','10','','');
INSERT INTO ylmf_class VALUES('2304','907','Ʒ','','','5','10','','');
INSERT INTO ylmf_class VALUES('783','1','','','','111','0','xingzuo','');
INSERT INTO ylmf_class VALUES('784','783','','','','0','15','','');
INSERT INTO ylmf_class VALUES('785','783','ռ','','','2','20','','');
INSERT INTO ylmf_class VALUES('786','783','Ф/','','','3','5','','');
INSERT INTO ylmf_class VALUES('787','783','','','','5','7','','');
INSERT INTO ylmf_class VALUES('2027','1596','ҵƾ','','','7','9','','');
INSERT INTO ylmf_class VALUES('789','1','','','','115','0','love','');
INSERT INTO ylmf_class VALUES('790','789','ۺ','','','0','22','/love/','');
INSERT INTO ylmf_class VALUES('791','789','޻','','','3','15','','');
INSERT INTO ylmf_class VALUES('792','789','а','','','2','9','','');
INSERT INTO ylmf_class VALUES('1977','757','Flash','','','3','5','','');
INSERT INTO ylmf_class VALUES('795','4','','','','121','0','shuma_shishang','');
INSERT INTO ylmf_class VALUES('796','795','ۺ','','','0','17','','');
INSERT INTO ylmf_class VALUES('799','1711','MP3/MD','','','7','9','','');
INSERT INTO ylmf_class VALUES('800','795','̳','','','2','8','','');
INSERT INTO ylmf_class VALUES('801','1711','ͷ','','','3','20','','');
INSERT INTO ylmf_class VALUES('1713','1076','ɫ','','','6','20','','');
INSERT INTO ylmf_class VALUES('803','1','Ƶ','','','102','0','kuanpin_yingshi','');
INSERT INTO ylmf_class VALUES('1981','776','ֽ','','','4','4','','');
INSERT INTO ylmf_class VALUES('805','2212','ߵӰ','','','0','10','','');
INSERT INTO ylmf_class VALUES('807','917','ǿ','','','5','17','','');
INSERT INTO ylmf_class VALUES('2068','698','Ϸܱ','','','9','15','','');
INSERT INTO ylmf_class VALUES('813','2','Ʊ','','','109','0','caijinggushi','');
INSERT INTO ylmf_class VALUES('814','813','ƱŻ','','','1','13','','');
INSERT INTO ylmf_class VALUES('815','813','Ʊ','','','3','32','','');
INSERT INTO ylmf_class VALUES('816','813','Ʊ','','','4','38','','');
INSERT INTO ylmf_class VALUES('817','813','Ʊ','','','5','10','','');
INSERT INTO ylmf_class VALUES('2289','698','ӲϷ','','','10','9','','');
INSERT INTO ylmf_class VALUES('2059','2193','ط','','','10000','10','','');
INSERT INTO ylmf_class VALUES('820','2','','','','116','0','chongwuhuaniao','');
INSERT INTO ylmf_class VALUES('821','820','ۺ','','','0','15','','');
INSERT INTO ylmf_class VALUES('822','820','ݻ','','','9','10','','');
INSERT INTO ylmf_class VALUES('824','1','','','','116','0','star','');
INSERT INTO ylmf_class VALUES('825','824','ۺ','','','0','16','','');
INSERT INTO ylmf_class VALUES('826','824','ģд','','','2','4','','');
INSERT INTO ylmf_class VALUES('827','2172','½','','','10000','22','','');
INSERT INTO ylmf_class VALUES('828','2172','̨','','','2','26','','');
INSERT INTO ylmf_class VALUES('829','2172','','','','3','37','','');
INSERT INTO ylmf_class VALUES('2298','2297','','','','1','0','/jingtai/yule/','');
INSERT INTO ylmf_class VALUES('831','1','','','','104','0','news','');
INSERT INTO ylmf_class VALUES('832','831','ۺ','','','0','31','/news/','');
INSERT INTO ylmf_class VALUES('835','668','','','','5','5','','');
INSERT INTO ylmf_class VALUES('837','831','֪','','','2','26','','');
INSERT INTO ylmf_class VALUES('838','831','ط','','','5','0','','');
INSERT INTO ylmf_class VALUES('842','2','Ʊ','','','103','0','caijinggushi','');
INSERT INTO ylmf_class VALUES('843','842','ƾѶ','','','8','21','/caijinggushi/','');
INSERT INTO ylmf_class VALUES('844','842','Ʊ̳/','','','4','18','','');
INSERT INTO ylmf_class VALUES('845','2148','֤ȯ˾','','','6','47','','');
INSERT INTO ylmf_class VALUES('847','2148','ƾ','','','4','21','','');
INSERT INTO ylmf_class VALUES('848','842','о','','','0','7','','');
INSERT INTO ylmf_class VALUES('2095','1917','','','','109','25','','');
INSERT INTO ylmf_class VALUES('850','2148','Ʊ','','','10000','7','','');
INSERT INTO ylmf_class VALUES('851','2','','','','105','0','wangshanggouwu','');
INSERT INTO ylmf_class VALUES('852','851','Ϲ','','','0','41','','');
INSERT INTO ylmf_class VALUES('853','851','ͼ/','','','8','9','','');
INSERT INTO ylmf_class VALUES('2293','2212','','','','5','5','','');
INSERT INTO ylmf_class VALUES('1717','924','Ʒ','','','5','17','','');
INSERT INTO ylmf_class VALUES('856','2','','','','106','28','bank','');
INSERT INTO ylmf_class VALUES('1688','2204','','','','5','20','','');
INSERT INTO ylmf_class VALUES('858','856','з','','','0','15','/bank/','');
INSERT INTO ylmf_class VALUES('860','856','Ѷ','','','2','13','','');
INSERT INTO ylmf_class VALUES('1721','871','ҽԺ','','','10000','35','','');
INSERT INTO ylmf_class VALUES('2049','912','','','','8','9','','');
INSERT INTO ylmf_class VALUES('863','2','','','','111','0','yiliaobaojian','');
INSERT INTO ylmf_class VALUES('864','863','ҽ','','','0','25','','');
INSERT INTO ylmf_class VALUES('2207','2205','طԮ','','','100','7','','');
INSERT INTO ylmf_class VALUES('866','2203','̲','','','9','11','','');
INSERT INTO ylmf_class VALUES('2206','2205','طʦ','','','100','22','','');
INSERT INTO ylmf_class VALUES('869','2203','ҽѧо','','','10000','19','','');
INSERT INTO ylmf_class VALUES('870','2203','ҽԺ','','','7','4','','');
INSERT INTO ylmf_class VALUES('871','863','ҽԺ','','','5','2','','');
INSERT INTO ylmf_class VALUES('872','2203','ҽҩҩƷ','','','5','33','','');
INSERT INTO ylmf_class VALUES('2133','2219','ϵͳ̳','','','5','5','','');
INSERT INTO ylmf_class VALUES('2153','1020','','','','5','14','','');
INSERT INTO ylmf_class VALUES('878','2','','','','108','0','fangchanjiaju','class_fangchan.tpl');
INSERT INTO ylmf_class VALUES('879','878','Ҿװ','','','2','19','','');
INSERT INTO ylmf_class VALUES('881','878','ز','','','0','27','','');
INSERT INTO ylmf_class VALUES('883','2','','','','113','0','shaonian_ertong','');
INSERT INTO ylmf_class VALUES('884','883','','','','0','25','','');
INSERT INTO ylmf_class VALUES('2167','748','ŵӵ̨','','','3','0','','');
INSERT INTO ylmf_class VALUES('886','883','ͯ','','','2','10','','');
INSERT INTO ylmf_class VALUES('888','883','̳','','','5','9','','');
INSERT INTO ylmf_class VALUES('889','883','Ϸͯҥ','','','6','9','','');
INSERT INTO ylmf_class VALUES('890','883','ʽ','','','3','8','','');
INSERT INTO ylmf_class VALUES('891','2','','','','117','0','lvyouchuxing','');
INSERT INTO ylmf_class VALUES('892','891','Ѷ','','','0','26','/lvyouchuxing/','');
INSERT INTO ylmf_class VALUES('893','891','','','','7','0','','');
INSERT INTO ylmf_class VALUES('2050','891','ξ','','','8','0','','');
INSERT INTO ylmf_class VALUES('895','891','/Ƶ/Ʊ','','','2','17','','');
INSERT INTO ylmf_class VALUES('2024','2229','','','','10000','21','','');
INSERT INTO ylmf_class VALUES('2039','715','ֲ','','','5','5','','');
INSERT INTO ylmf_class VALUES('899','2226','','','','103','0','Zhengfu_Jigou','');
INSERT INTO ylmf_class VALUES('902','899','ط','','','3','0','','');
INSERT INTO ylmf_class VALUES('903','2179','Ϣ','','','10000','23','','');
INSERT INTO ylmf_class VALUES('904','2186','֯','','','10000','52','','');
INSERT INTO ylmf_class VALUES('905','899','','','','5','0','','');
INSERT INTO ylmf_class VALUES('2085','891','','','','6','5','','');
INSERT INTO ylmf_class VALUES('907','2','','','','122','0','life','');
INSERT INTO ylmf_class VALUES('908','907','վ','','','0','25','','');
INSERT INTO ylmf_class VALUES('912','2','','','','112','0','law','');
INSERT INTO ylmf_class VALUES('913','912','ۺ','','','0','24','','');
INSERT INTO ylmf_class VALUES('914','2205','طԺ','','','7','29','','');
INSERT INTO ylmf_class VALUES('915','912','ʦվ','','','3','10','','');
INSERT INTO ylmf_class VALUES('916','912','֪ʶȨ','','','5','6','','');
INSERT INTO ylmf_class VALUES('917','2226','ط','','','102','0','difangfuwu','');
INSERT INTO ylmf_class VALUES('919','1236','豸','','','6','6','','');
INSERT INTO ylmf_class VALUES('1881','917','Ϣ','','','10000','10','','');
INSERT INTO ylmf_class VALUES('921','2','ʳ','','','119','0','yingyangmeishi','');
INSERT INTO ylmf_class VALUES('2080','921','ʳר','','','4','15','','');
INSERT INTO ylmf_class VALUES('1919','831','֪ý','','','4','15','','');
INSERT INTO ylmf_class VALUES('925','924','Ʒ','','','10000','10','','');
INSERT INTO ylmf_class VALUES('926','924','','','','3','10','','');
INSERT INTO ylmf_class VALUES('927','1','','','','107','0','tiyu_jianshen','');
INSERT INTO ylmf_class VALUES('928','927','ۺ','','','0','21','/tiyu_jianshen/','');
INSERT INTO ylmf_class VALUES('929','927','̳','','','2','9','','');
INSERT INTO ylmf_class VALUES('930','2034','ۺ','','','1','10','','');
INSERT INTO ylmf_class VALUES('931','2150','˶','','','13','21','','');
INSERT INTO ylmf_class VALUES('932','2150','˶','','','26','17','','');
INSERT INTO ylmf_class VALUES('933','2150','/F1','','','15','23','','');
INSERT INTO ylmf_class VALUES('934','2150','ë','','','17','10','','');
INSERT INTO ylmf_class VALUES('935','2150','ƹ','','','18','24','','');
INSERT INTO ylmf_class VALUES('936','2151','2008ר','','','27','24','','');
INSERT INTO ylmf_class VALUES('937','2150','','','','10000','20','','');
INSERT INTO ylmf_class VALUES('938','2151','','','','10000','12','','');
INSERT INTO ylmf_class VALUES('2081','2186','פʹ/¹','','','101','27','','');
INSERT INTO ylmf_class VALUES('940','2150','߶','','','16','13','','');
INSERT INTO ylmf_class VALUES('941','2150','','','','25','14','','');
INSERT INTO ylmf_class VALUES('942','2150','̨','','','19','10','','');
INSERT INTO ylmf_class VALUES('943','2151','˶Э','','','7','16','','');
INSERT INTO ylmf_class VALUES('944','2150','','','','14','14','','');
INSERT INTO ylmf_class VALUES('946','3','ѧ','','','7','0','xiaoyuan_gaoxiao','');
INSERT INTO ylmf_class VALUES('947','2246','ͬѧ¼','','','2','5','','');
INSERT INTO ylmf_class VALUES('2078','2149','УBBS̳','','','6','55','','');
INSERT INTO ylmf_class VALUES('2055','2050','ξ','','','5','4','','');
INSERT INTO ylmf_class VALUES('950','946','طУ','','','9','7','','');
INSERT INTO ylmf_class VALUES('951','2149','У','','','4','20','','');
INSERT INTO ylmf_class VALUES('2023','2239','ͨͼ','','','0','12','','');
INSERT INTO ylmf_class VALUES('2158','974','ѧ','','','4','0','','');
INSERT INTO ylmf_class VALUES('955','2149','ѧͼ','','','5','77','','');
INSERT INTO ylmf_class VALUES('2054','2050','ξ','','','4','6','','');
INSERT INTO ylmf_class VALUES('957','2','Ƹ','','','121','0','rencai_zhaopin','');
INSERT INTO ylmf_class VALUES('958','957','˲Ƹ','','','0','27','/rencai_zhaopin/','');
INSERT INTO ylmf_class VALUES('959','957','ط˲','','','5','0','','');
INSERT INTO ylmf_class VALUES('960','957','д','','','2','5','','');
INSERT INTO ylmf_class VALUES('961','3','','','','1','0','jiaoyu','');
INSERT INTO ylmf_class VALUES('962','961','ۺ','','','0','21','','');
INSERT INTO ylmf_class VALUES('964','961','׶','','','2','9','','');
INSERT INTO ylmf_class VALUES('2283','873','̼','','','10000','11','/zhaoshangjiameng/','');
INSERT INTO ylmf_class VALUES('966','961','','','','3','9','','');
INSERT INTO ylmf_class VALUES('967','961','ְҵ','','','6','4','','');
INSERT INTO ylmf_class VALUES('969','961','˽','','','5','5','','');
INSERT INTO ylmf_class VALUES('970','961','','','','8','5','','');
INSERT INTO ylmf_class VALUES('2061','2173','طƷ','','','10000','20','','');
INSERT INTO ylmf_class VALUES('2088','961','ߵȽ','','','4','4','','');
INSERT INTO ylmf_class VALUES('974','3','Ƽ','','','2','0','kexue_jishu','');
INSERT INTO ylmf_class VALUES('975','974','Ƽۺ','','','0','14','','');
INSERT INTO ylmf_class VALUES('976','2158','ѧ','','','5','14','','');
INSERT INTO ylmf_class VALUES('977','2158','ѧ','','','8','14','','');
INSERT INTO ylmf_class VALUES('978','2158','ѧ','','','6','14','','');
INSERT INTO ylmf_class VALUES('979','2158','ѧ','','','13','10','','');
INSERT INTO ylmf_class VALUES('980','2158','ѧ','','','12','14','','');
INSERT INTO ylmf_class VALUES('981','2158','ѧ','','','11','17','','');
INSERT INTO ylmf_class VALUES('983','2158','ʷѧ','','','9','19','','');
INSERT INTO ylmf_class VALUES('984','2158','ѧ','','','3','22','','');
INSERT INTO ylmf_class VALUES('985','2158','ѧ','','','7','10','','');
INSERT INTO ylmf_class VALUES('986','2158','ѧ','','','10000','9','','');
INSERT INTO ylmf_class VALUES('987','2158','ѧ','','','2','14','','');
INSERT INTO ylmf_class VALUES('2105','1588','װ','','','5','7','','');
INSERT INTO ylmf_class VALUES('989','2159','صʵ','','','17','18','','');
INSERT INTO ylmf_class VALUES('2265','2264','̳','','','100','6','','');
INSERT INTO ylmf_class VALUES('991','2161','','','','0','19','','');
INSERT INTO ylmf_class VALUES('992','2161','ѧ','','','7','10','','');
INSERT INTO ylmf_class VALUES('993','2264','ۺ','','','0','14','','');
INSERT INTO ylmf_class VALUES('994','2161','˾','','','11','14','','');
INSERT INTO ylmf_class VALUES('995','2161','ƻῼ','','','11','15','','');
INSERT INTO ylmf_class VALUES('996','2161','Ա','','','1','9','','');
INSERT INTO ylmf_class VALUES('998','2161','','','','10','8','','');
INSERT INTO ylmf_class VALUES('999','2161','MBAѵ','','','9','7','','');
INSERT INTO ylmf_class VALUES('2087','1011','','','','9','2','','');
INSERT INTO ylmf_class VALUES('1001','2263','߿Ѷ','','','0','14','','');
INSERT INTO ylmf_class VALUES('1003','3','','','','11','0','shehui_wenhua','');
INSERT INTO ylmf_class VALUES('1004','1003','Ļ','','','0','20','','');
INSERT INTO ylmf_class VALUES('2164','2224','ַ','','','2','4','','');
INSERT INTO ylmf_class VALUES('1006','2225','վ','','','0','23','','');
INSERT INTO ylmf_class VALUES('2163','2224','ַ','','','0','17','','');
INSERT INTO ylmf_class VALUES('2162','1003','ʷ','','','100','5','','');
INSERT INTO ylmf_class VALUES('1009','1003','ʷ','','','2','5','','');
INSERT INTO ylmf_class VALUES('2239','2','ͼ','','','124','0','map','');
INSERT INTO ylmf_class VALUES('1011','3','','','','13','0','yishu_aihao','');
INSERT INTO ylmf_class VALUES('1012','1011','','','','0','15','','');
INSERT INTO ylmf_class VALUES('1015','1011','鷨','','','3','10','','');
INSERT INTO ylmf_class VALUES('2149','946','йѧ','','','4','0','','');
INSERT INTO ylmf_class VALUES('1017','1011','滭','','','2','9','','');
INSERT INTO ylmf_class VALUES('1018','2223','СƷ','','','0','10','','');
INSERT INTO ylmf_class VALUES('1019','1011','ղ','','','1','20','','');
INSERT INTO ylmf_class VALUES('1020','1','','','','108','0','football','');
INSERT INTO ylmf_class VALUES('1021','1020','ۺ','','','0','17','','');
INSERT INTO ylmf_class VALUES('1022','2274','籭ר','','','10000','22','','');
INSERT INTO ylmf_class VALUES('1024','2273','ֲ','','','3','19','','');
INSERT INTO ylmf_class VALUES('1026','2273','Э','','','2','21','','');
INSERT INTO ylmf_class VALUES('1027','2275','׼','','','11','29','','');
INSERT INTO ylmf_class VALUES('1028','2274','ŷޱר','','','8','10','','');
INSERT INTO ylmf_class VALUES('1029','2273','','','','5','24','','');
INSERT INTO ylmf_class VALUES('1030','2274','ޱר','','','9','5','','');
INSERT INTO ylmf_class VALUES('1031','2275','Ӣ','','','10000','26','','');
INSERT INTO ylmf_class VALUES('1032','2275','׼','','','13','19','','');
INSERT INTO ylmf_class VALUES('1033','2275','¹׼','','','12','20','','');
INSERT INTO ylmf_class VALUES('1034','2275','׼','','','14','18','','');
INSERT INTO ylmf_class VALUES('1035','2275','׼','','','15','18','','');
INSERT INTO ylmf_class VALUES('1036','3','','','','8','0','kejian_lunwen','');
INSERT INTO ylmf_class VALUES('1037','1036','μԴ','','','2','11','','');
INSERT INTO ylmf_class VALUES('1038','2156','ѧμ̰','','','10000','4','','');
INSERT INTO ylmf_class VALUES('1039','2156','Ӣμ̰','','','5','9','','');
INSERT INTO ylmf_class VALUES('1040','2156','Ŀμ̰','','','6','9','','');
INSERT INTO ylmf_class VALUES('1699','1682','','','','2','36','','');
INSERT INTO ylmf_class VALUES('1698','1682','ܼ','','','3','26','','');
INSERT INTO ylmf_class VALUES('1043','1036','','','','0','14','','');
INSERT INTO ylmf_class VALUES('1044','3','','','','3','0','waiyu_xuexi','');
INSERT INTO ylmf_class VALUES('1045','1044','Ӣѧϰ','','','0','26','','');
INSERT INTO ylmf_class VALUES('2150','927','˶Ŀ','','','5','0','','');
INSERT INTO ylmf_class VALUES('1047','1044','߷','','','2','13','','');
INSERT INTO ylmf_class VALUES('2270','1131','ҳ','','','100','10','','');
INSERT INTO ylmf_class VALUES('2165','2224','վ','','','3','6','','');
INSERT INTO ylmf_class VALUES('1050','1044','ѧϰ','','','5','13','','');
INSERT INTO ylmf_class VALUES('1051','3','ѧ','','','12','0','chuguo_liuxue','');
INSERT INTO ylmf_class VALUES('1052','1051','ѧ','','','0','17','','');
INSERT INTO ylmf_class VALUES('1053','1051','ѧ','','','3','10','','');
INSERT INTO ylmf_class VALUES('1054','1051','','','','2','5','','');
INSERT INTO ylmf_class VALUES('1696','957','ҵ˲','','','4','40','','');
INSERT INTO ylmf_class VALUES('1695','957','ַ','','','3','5','','');
INSERT INTO ylmf_class VALUES('2034','1','NBA','','','109','0','nba','');
INSERT INTO ylmf_class VALUES('1068','2199','','','','0','15','/mail/','');
INSERT INTO ylmf_class VALUES('1689','1711','MP4','','','3','9','','');
INSERT INTO ylmf_class VALUES('1076','4','','','','122','0','Sousuo_Yinqing','');
INSERT INTO ylmf_class VALUES('1077','1076','','','','0','10','','');
INSERT INTO ylmf_class VALUES('2159','974','ѧо','','','5','0','','');
INSERT INTO ylmf_class VALUES('1686','1711','MP3/MP4Ʒ','','','2','15','','');
INSERT INTO ylmf_class VALUES('1082','2226','','','','105','0','Guowai_Wangzhan','');
INSERT INTO ylmf_class VALUES('1084','1082','ۺŻ','','','2','42','','');
INSERT INTO ylmf_class VALUES('1085','1082','','','','14','32','','');
INSERT INTO ylmf_class VALUES('1086','1082','־','','','11','91','','');
INSERT INTO ylmf_class VALUES('1087','1082','','','','9','10','','');
INSERT INTO ylmf_class VALUES('1088','1082','⻪','','','3','30','','');
INSERT INTO ylmf_class VALUES('1089','1082','','','','10000','13','','');
INSERT INTO ylmf_class VALUES('1090','1082','Ӳ','','','15','31','','');
INSERT INTO ylmf_class VALUES('1091','1082','ַ','','','4','25','','');
INSERT INTO ylmf_class VALUES('1092','1082','ַ','','','5','20','','');
INSERT INTO ylmf_class VALUES('1093','1082','Ӱ','','','9','37','','');
INSERT INTO ylmf_class VALUES('1094','1082','ʱ','','','8','24','','');
INSERT INTO ylmf_class VALUES('1095','4','Ӳ','','','120','0','Yingjian_Zixun','');
INSERT INTO ylmf_class VALUES('1096','1095','ӲѶ','','','0','16','','');
INSERT INTO ylmf_class VALUES('1097','2147','ӲƷ','','','10000','86','','');
INSERT INTO ylmf_class VALUES('1711','795','','','','100','0','','');
INSERT INTO ylmf_class VALUES('1099','2147','ʼǱ','','','3','14','','');
INSERT INTO ylmf_class VALUES('1101','1095','Ӳ','','','2','9','','');
INSERT INTO ylmf_class VALUES('1102','1095','','','','4','8','','');
INSERT INTO ylmf_class VALUES('1103','1095','Ӳ̳','','','3','10','','');
INSERT INTO ylmf_class VALUES('1104','2147','Ѷ','','','4','15','','');
INSERT INTO ylmf_class VALUES('1105','4','','','','103','0','soft','');
INSERT INTO ylmf_class VALUES('1106','1105','','','','2','21','/soft/','');
INSERT INTO ylmf_class VALUES('1107','1105','̳','','','5','9','','');
INSERT INTO ylmf_class VALUES('1109','1105','װ','','','4','5','','');
INSERT INTO ylmf_class VALUES('1110','1588','','','','8','4','','');
INSERT INTO ylmf_class VALUES('1285','803','Ƶ','','','0','21','/kuanpin_yingshi/','');
INSERT INTO ylmf_class VALUES('1113','2120','BT','','','0','10','','');
INSERT INTO ylmf_class VALUES('1114','2120','P2P','','','8','9','','');
INSERT INTO ylmf_class VALUES('1284','2120','P2P','','','9','4','','');
INSERT INTO ylmf_class VALUES('1117','1082','','','','6','18','','');
INSERT INTO ylmf_class VALUES('1118','1105','','','','3','9','','');
INSERT INTO ylmf_class VALUES('1119','2212','Ӱ','','','2','7','','');
INSERT INTO ylmf_class VALUES('1121','4','IT','','','101','0','it','');
INSERT INTO ylmf_class VALUES('1122','1121','ITѶ','','','0','38','','');
INSERT INTO ylmf_class VALUES('1123','2147','Թ˾','','','2','20','','');
INSERT INTO ylmf_class VALUES('1124','2198','Խ̳','','','0','12','','');
INSERT INTO ylmf_class VALUES('1126','2198','Ա','','','4','19','','');
INSERT INTO ylmf_class VALUES('1709','1131','վѶ','','','2','13','','');
INSERT INTO ylmf_class VALUES('2107','1588','ز','','','0','17','','');
INSERT INTO ylmf_class VALUES('2274','5','','','','100','0','saishi','');
INSERT INTO ylmf_class VALUES('1131','4','վ','','','125','0','Jianzhan_Sheji','');
INSERT INTO ylmf_class VALUES('1132','1131','ҳ','','','0','16','','');
INSERT INTO ylmf_class VALUES('1133','2220','','','','10000','16','','');
INSERT INTO ylmf_class VALUES('2046','917','طŻ','','','1','34','','');
INSERT INTO ylmf_class VALUES('2047','2204','ڵط','','','10000','30','','');
INSERT INTO ylmf_class VALUES('1138','4','ڿ','','','105','0','Heike_Anquan','');
INSERT INTO ylmf_class VALUES('1139','1138','ڿͰȫվ','','','0','18','','');
INSERT INTO ylmf_class VALUES('1358','1138','ڿ̳','','','6','14','','');
INSERT INTO ylmf_class VALUES('2212','1','Ӱ','','','105','0','movie','');
INSERT INTO ylmf_class VALUES('1142','2229','ȫ̳','','','5','7','','');
INSERT INTO ylmf_class VALUES('1143','2226','','','','109','0','Mianfei_Ziyuan','');
INSERT INTO ylmf_class VALUES('1704','2186','֯','','','7','13','','');
INSERT INTO ylmf_class VALUES('2142','1143','Ϣ','','','10000','5','','');
INSERT INTO ylmf_class VALUES('1146','1143','ҳռ','','','5','5','','');
INSERT INTO ylmf_class VALUES('1147','1143','','','','4','5','','');
INSERT INTO ylmf_class VALUES('1705','1082','ר','','','6','15','','');
INSERT INTO ylmf_class VALUES('2113','1131','̳ CMS','','','4','10','','');
INSERT INTO ylmf_class VALUES('1150','1143','Ա','','','8','3','','');
INSERT INTO ylmf_class VALUES('1151','1143','̳','','','5','7','','');
INSERT INTO ylmf_class VALUES('1152','4','','','','124','0','Chengxu_Biancheng','');
INSERT INTO ylmf_class VALUES('1153','1152','̿','','','0','14','','');
INSERT INTO ylmf_class VALUES('2259','2198','ܼ','','','100','7','','');
INSERT INTO ylmf_class VALUES('1155','2169','ASP','','','4','15','','');
INSERT INTO ylmf_class VALUES('1156','2169','Java','','','12','16','','');
INSERT INTO ylmf_class VALUES('1157','2169','Linux','','','13','17','','');
INSERT INTO ylmf_class VALUES('1158','2169','Delphi','','','11','8','','');
INSERT INTO ylmf_class VALUES('1159','2169','C/C++/C#','','','10','8','','');
INSERT INTO ylmf_class VALUES('1160','2169','PHP','','','5','15','','');
INSERT INTO ylmf_class VALUES('1161','2169','Wap','','','7','5','','');
INSERT INTO ylmf_class VALUES('1162','2169','VB','','','9','10','','');
INSERT INTO ylmf_class VALUES('1163','2169','JSP','','','6','5','','');
INSERT INTO ylmf_class VALUES('2063','2173','طƷ','','','6','8','','');
INSERT INTO ylmf_class VALUES('1165','2169','Power Builder','','','14','7','','');
INSERT INTO ylmf_class VALUES('1166','2169','ݿ','','','10000','8','','');
INSERT INTO ylmf_class VALUES('1167','2169','CGI','','','8','5','','');
INSERT INTO ylmf_class VALUES('1168','2','','','','107','0','car','');
INSERT INTO ylmf_class VALUES('1169','1168','Ѷ','','','0','30','/car/','');
INSERT INTO ylmf_class VALUES('1170','2175','ҵ','','','9','31','','');
INSERT INTO ylmf_class VALUES('1171','1168','','','','5','9','','');
INSERT INTO ylmf_class VALUES('1172','5','ó','','','4','0','Shangwu_Maoyi','');
INSERT INTO ylmf_class VALUES('1173','1172','ó','','','10000','28','','');
INSERT INTO ylmf_class VALUES('1176','1172','չ','','','4','8','','');
INSERT INTO ylmf_class VALUES('1642','1251','Ͷ','','','0','15','','');
INSERT INTO ylmf_class VALUES('1179','5','ұ','','','14','0','Yejin_Kuangchan','');
INSERT INTO ylmf_class VALUES('1180','1179','ұ','','','1','12','','');
INSERT INTO ylmf_class VALUES('1181','1179','','','','2','21','','');
INSERT INTO ylmf_class VALUES('1182','1179','ֲ','','','10000','10','','');
INSERT INTO ylmf_class VALUES('1183','1179','ҵ','','','5','5','','');
INSERT INTO ylmf_class VALUES('1184','1179','','','','3','10','','');
INSERT INTO ylmf_class VALUES('1185','5','','','','5','0','Jianzhu_Jiancai','');
INSERT INTO ylmf_class VALUES('1186','1185','ۺ','','','10000','14','','');
INSERT INTO ylmf_class VALUES('2194','1239','ͨϢ','','','100','0','','');
INSERT INTO ylmf_class VALUES('1188','1185','̽','','','7','7','','');
INSERT INTO ylmf_class VALUES('1189','1185','ҵ','','','2','25','','');
INSERT INTO ylmf_class VALUES('1193','1185','ҵմ','','','5','9','','');
INSERT INTO ylmf_class VALUES('1194','5','ѧҵ','','','13','0','Huagong_Nengyuan','');
INSERT INTO ylmf_class VALUES('1195','1194','ѧҵ','','','10000','29','','');
INSERT INTO ylmf_class VALUES('1196','2196','','','','10','15','','');
INSERT INTO ylmf_class VALUES('2208','2205','ط֪ʶȨ','','','100','28','','');
INSERT INTO ylmf_class VALUES('1198','2196','','','','8','6','','');
INSERT INTO ylmf_class VALUES('1200','1194','豸','','','3','8','','');
INSERT INTO ylmf_class VALUES('1201','2196','','','','10000','7','','');
INSERT INTO ylmf_class VALUES('2200','1121','IT','','','100','9','','');
INSERT INTO ylmf_class VALUES('1203','2245','Դ','','','10000','9','','');
INSERT INTO ylmf_class VALUES('1204','2245','ʯ','','','2','17','','');
INSERT INTO ylmf_class VALUES('1205','2245','','','','5','17','','');
INSERT INTO ylmf_class VALUES('1206','2245','ú̿','','','3','8','','');
INSERT INTO ylmf_class VALUES('1207','5','װ','','','8','0','Fuzhuang_Fushi','');
INSERT INTO ylmf_class VALUES('1208','1207','װ','','','10000','25','','');
INSERT INTO ylmf_class VALUES('2188','907','Ʒƻ','','','6','0','','');
INSERT INTO ylmf_class VALUES('2189','907','վ','','','2','34','','');
INSERT INTO ylmf_class VALUES('1211','1207','','','','4','2','','');
INSERT INTO ylmf_class VALUES('1212','1207','Ьñ','','','5','10','','');
INSERT INTO ylmf_class VALUES('1213','1207','','','','6','3','','');
INSERT INTO ylmf_class VALUES('1215','1207','','','','8','5','','');
INSERT INTO ylmf_class VALUES('1216','5','ҵŻ','','','1','0','Gehang_Geye','');
INSERT INTO ylmf_class VALUES('1640','2187','500ǿ','','','3','55','','');
INSERT INTO ylmf_class VALUES('1218','1216','ҵŻ','','','10000','35','','');
INSERT INTO ylmf_class VALUES('2205','912','֪άȨ','','','100','0','','');
INSERT INTO ylmf_class VALUES('2202','863','Ѱҽҩ','','','2','10','','');
INSERT INTO ylmf_class VALUES('1221','5','ũ','','','9','0','Nonglin_Muyu','');
INSERT INTO ylmf_class VALUES('1222','1221','ũ','','','10000','21','','');
INSERT INTO ylmf_class VALUES('2193','820','','','','100','0','','');
INSERT INTO ylmf_class VALUES('1224','1221','ֳ','','','3','15','','');
INSERT INTO ylmf_class VALUES('1225','1221','ҵϢ','','','4','5','','');
INSERT INTO ylmf_class VALUES('1226','1221','ˮҵ','','','5','5','','');
INSERT INTO ylmf_class VALUES('1657','2244','Ӱ','','','4','11','','');
INSERT INTO ylmf_class VALUES('1228','5','ʳƷ','','','11','0','Shipin_Yinliao','');
INSERT INTO ylmf_class VALUES('1229','1228','ʳƷҵ','','','10000','18','','');
INSERT INTO ylmf_class VALUES('1230','1228','̲Ǿ','','','2','10','','');
INSERT INTO ylmf_class VALUES('1231','1228','','','','1','18','','');
INSERT INTO ylmf_class VALUES('1232','1228','Ҷ','','','3','6','','');
INSERT INTO ylmf_class VALUES('1233','1228','ˮ','','','5','6','','');
INSERT INTO ylmf_class VALUES('1234','1228','','','','4','6','','');
INSERT INTO ylmf_class VALUES('1236','5','еǱ','','','7','0','Jixie_Dianzi','');
INSERT INTO ylmf_class VALUES('1237','2244','ӵ繤','','','10000','26','','');
INSERT INTO ylmf_class VALUES('1238','1236','õ','','','5','7','','');
INSERT INTO ylmf_class VALUES('1239','5','ͨ','','','10','0','Jiaotong_Wuliu','');
INSERT INTO ylmf_class VALUES('1240','1239','Ϣ','','','4','10','','');
INSERT INTO ylmf_class VALUES('1241','1239','ͨ','','','3','10','','');
INSERT INTO ylmf_class VALUES('1243','1239','ÿݲѯ','','','2','15','','');
INSERT INTO ylmf_class VALUES('1244','1239','˲ѯ','','','10000','9','','');
INSERT INTO ylmf_class VALUES('2022','2194','ͨҵλ','','','3','28','','');
INSERT INTO ylmf_class VALUES('1246','5','̻','','','12','0','Huanbao_Lvhua','');
INSERT INTO ylmf_class VALUES('1247','1246','','','','10000','18','','');
INSERT INTO ylmf_class VALUES('1248','1246','ˮԴ','','','3','9','','');
INSERT INTO ylmf_class VALUES('1661','1255','','','','4','5','','');
INSERT INTO ylmf_class VALUES('1250','1246','̻԰','','','2','9','','');
INSERT INTO ylmf_class VALUES('1251','2','','','','104','0','jijinlicai','');
INSERT INTO ylmf_class VALUES('1253','873','ҵҳ','','','3','12','','');
INSERT INTO ylmf_class VALUES('1641','2187','й500ǿ','','','1','52','','');
INSERT INTO ylmf_class VALUES('1255','5','֯Ƥ','','','15','0','Fangzhi_Pige','');
INSERT INTO ylmf_class VALUES('1256','1255','֯','','','10000','19','','');
INSERT INTO ylmf_class VALUES('1257','1255','޷','','','2','7','','');
INSERT INTO ylmf_class VALUES('1258','1255','֯е','','','7','5','','');
INSERT INTO ylmf_class VALUES('2209','674','̳','','','2','0','','');
INSERT INTO ylmf_class VALUES('1260','1255','˿','','','3','10','','');
INSERT INTO ylmf_class VALUES('1261','1255','Ƥ','','','5','8','','');
INSERT INTO ylmf_class VALUES('1262','1255','ӡȾ','','','6','8','','');
INSERT INTO ylmf_class VALUES('2302','907','μƻ','','','3','10','','');
INSERT INTO ylmf_class VALUES('1264','1236','еҵ','','','10000','18','','');
INSERT INTO ylmf_class VALUES('1265','1236','Ǳ','','','3','10','','');
INSERT INTO ylmf_class VALUES('1266','5','װӡˢ','','','16','0','Yinshua_Chuban','');
INSERT INTO ylmf_class VALUES('1267','1266','ӡˢ','','','2','10','','');
INSERT INTO ylmf_class VALUES('1268','2250','ڳ','','','10000','15','','');
INSERT INTO ylmf_class VALUES('1269','2250','','','','4','21','','');
INSERT INTO ylmf_class VALUES('1270','2220','վƹ','','','4','13','','');
INSERT INTO ylmf_class VALUES('1926','873','','','','2','19','','');
INSERT INTO ylmf_class VALUES('1273','5','ҵƷ','','','6','0','Gongye_Zhipin','');
INSERT INTO ylmf_class VALUES('2195','2194','طͨϢ','','','10000','18','','');
INSERT INTO ylmf_class VALUES('1275','1273','','','','3','10','','');
INSERT INTO ylmf_class VALUES('1276','1273','ģ','','','4','7','','');
INSERT INTO ylmf_class VALUES('2035','891','Ԥ','','','4','5','qixiangditu','');
INSERT INTO ylmf_class VALUES('1278','1266','װֽƷ','','','10000','9','','');
INSERT INTO ylmf_class VALUES('2057','2034','NBA','','','3','30','','');
INSERT INTO ylmf_class VALUES('1282','765','ֻ','','','6','5','','');
INSERT INTO ylmf_class VALUES('1289','950','У','','','10000','70','','');
INSERT INTO ylmf_class VALUES('1290','950','У','','','2','24','','');
INSERT INTO ylmf_class VALUES('1291','950','ϺУ','','','1','40','','');
INSERT INTO ylmf_class VALUES('1292','950','ոУ','','','5','39','','');
INSERT INTO ylmf_class VALUES('1293','950','㽭У','','','7','35','','');
INSERT INTO ylmf_class VALUES('1294','950','У','','','12','34','','');
INSERT INTO ylmf_class VALUES('1295','950','㶫У','','','4','62','','');
INSERT INTO ylmf_class VALUES('1296','950','У','','','21','34','','');
INSERT INTO ylmf_class VALUES('1297','950','ĴУ','','','11','40','','');
INSERT INTO ylmf_class VALUES('1298','950','У','','','3','14','','');
INSERT INTO ylmf_class VALUES('1299','950','У','','','10','44','','');
INSERT INTO ylmf_class VALUES('1300','950','У','','','15','26','','');
INSERT INTO ylmf_class VALUES('1301','950','ϸУ','','','14','31','','');
INSERT INTO ylmf_class VALUES('1302','950','ɽУ','','','6','35','','');
INSERT INTO ylmf_class VALUES('1303','950','ոУ','','','16','32','','');
INSERT INTO ylmf_class VALUES('1304','950','ɽУ','','','22','15','','');
INSERT INTO ylmf_class VALUES('1305','950','ָУ','','','19','27','','');
INSERT INTO ylmf_class VALUES('1306','950','У','','','13','24','','');
INSERT INTO ylmf_class VALUES('1307','950','ϸУ','','','8','33','','');
INSERT INTO ylmf_class VALUES('1308','950','ӱУ','','','9','35','','');
INSERT INTO ylmf_class VALUES('1309','950','ɹŸУ','','','23','21','','');
INSERT INTO ylmf_class VALUES('1310','950','У','','','17','27','','');
INSERT INTO ylmf_class VALUES('1311','950','У','','','18','24','','');
INSERT INTO ylmf_class VALUES('1312','950','ϸУ','','','27','10','','');
INSERT INTO ylmf_class VALUES('1313','950','ݸУ','','','25','16','','');
INSERT INTO ylmf_class VALUES('1314','950','ϸУ','','','20','17','','');
INSERT INTO ylmf_class VALUES('1315','950','ظУ','','','30','3','','');
INSERT INTO ylmf_class VALUES('1316','950','У','','','26','21','','');
INSERT INTO ylmf_class VALUES('1317','950','ຣУ','','','28','9','','');
INSERT INTO ylmf_class VALUES('1318','950','ĸУ','','','29','10','','');
INSERT INTO ylmf_class VALUES('1319','950','½У','','','24','16','','');
INSERT INTO ylmf_class VALUES('1320','950','۸У','','','31','15','','');
INSERT INTO ylmf_class VALUES('1321','2149','211̸У','','','10000','110','','');
INSERT INTO ylmf_class VALUES('1322','946','ѧ/У','','','10','0','','');
INSERT INTO ylmf_class VALUES('1323','950','ŸУ','','','32','10','','');
INSERT INTO ylmf_class VALUES('1324','950','̨ʡУ','','','33','25','','');
INSERT INTO ylmf_class VALUES('1325','1322','У','','','10000','20','','');
INSERT INTO ylmf_class VALUES('1326','1322','ӢУ','','','2','8','','');
INSERT INTO ylmf_class VALUES('1327','1322','ôУ','','','3','6','','');
INSERT INTO ylmf_class VALUES('1328','1322','ձУ','','','5','16','','');
INSERT INTO ylmf_class VALUES('1329','1322','¼¸У','','','4','2','','');
INSERT INTO ylmf_class VALUES('1330','1322','У','','','6','10','','');
INSERT INTO ylmf_class VALUES('1331','1322','ĴǸУ','','','7','8','','');
INSERT INTO ylmf_class VALUES('1332','1322','У','','','8','4','','');
INSERT INTO ylmf_class VALUES('1342','1322','У','','','11','8','','');
INSERT INTO ylmf_class VALUES('1341','1322','¹У','','','10','12','','');
INSERT INTO ylmf_class VALUES('1335','1322','ʱУ','','','12','4','','');
INSERT INTO ylmf_class VALUES('1336','1322','ʿУ','','','13','6','','');
INSERT INTO ylmf_class VALUES('1337','1322','У','','','14','2','','');
INSERT INTO ylmf_class VALUES('1338','1322','У','','','15','2','','');
INSERT INTO ylmf_class VALUES('1339','1322','У','','','16','2','','');
INSERT INTO ylmf_class VALUES('1340','1322','µУ','','','17','3','','');
INSERT INTO ylmf_class VALUES('1343','1322','У','','','9','12','','');
INSERT INTO ylmf_class VALUES('2025','2194','ຽչ˾','','','4','10','','');
INSERT INTO ylmf_class VALUES('1345','820','ˮ','','','4','15','','');
INSERT INTO ylmf_class VALUES('1346','820','ﱣ','','','8','8','','');
INSERT INTO ylmf_class VALUES('1347','820','èè','','','3','9','','');
INSERT INTO ylmf_class VALUES('2062','2173','ط','','','4','10','','');
INSERT INTO ylmf_class VALUES('2199','4','','','','102','0','mail','');
INSERT INTO ylmf_class VALUES('1350','2193','طҽԺ','','','7','12','','');
INSERT INTO ylmf_class VALUES('1351','820','','','','5','3','','');
INSERT INTO ylmf_class VALUES('2300','803','Ƶ','','','3','16','','');
INSERT INTO ylmf_class VALUES('1360','1138','ڿ֯','','','8','10','','');
INSERT INTO ylmf_class VALUES('1359','1138','߹','','','2','19','','');
INSERT INTO ylmf_class VALUES('1361','751','̨','','','13','9','','');
INSERT INTO ylmf_class VALUES('1362','751','̨','','','10000','4','','');
INSERT INTO ylmf_class VALUES('1363','751','Ϻ̨','','','1','3','','');
INSERT INTO ylmf_class VALUES('1364','751','̨','','','2','1','','');
INSERT INTO ylmf_class VALUES('1365','751','ӱ̨','','','9','5','','');
INSERT INTO ylmf_class VALUES('1366','751','ɽ̨','','','6','10','','');
INSERT INTO ylmf_class VALUES('1367','751','ɽ̨','','','22','3','','');
INSERT INTO ylmf_class VALUES('1368','751','ɹŵ̨','','','23','1','','');
INSERT INTO ylmf_class VALUES('1369','751','յ̨','','','5','8','','');
INSERT INTO ylmf_class VALUES('1370','751','㽭̨','','','7','9','','');
INSERT INTO ylmf_class VALUES('1371','751','?յ?','','','16','4','','');
INSERT INTO ylmf_class VALUES('1372','751','㶫̨','','','4','18','','');
INSERT INTO ylmf_class VALUES('1373','751','̨','','','18','2','','');
INSERT INTO ylmf_class VALUES('1374','751','ϵ̨','','','27','2','','');
INSERT INTO ylmf_class VALUES('1375','751','ϵ̨','','','8','10','','');
INSERT INTO ylmf_class VALUES('1376','751','̨','','','12','8','','');
INSERT INTO ylmf_class VALUES('1377','751','ϵ̨','','','14','3','','');
INSERT INTO ylmf_class VALUES('1378','751','̨','','','17','5','','');
INSERT INTO ylmf_class VALUES('1379','751','̨','','','10','8','','');
INSERT INTO ylmf_class VALUES('1380','751','ֵ̨','','','19','3','','');
INSERT INTO ylmf_class VALUES('1381','751','̨','','','15','4','','');
INSERT INTO ylmf_class VALUES('1382','751','̨','','','21','4','','');
INSERT INTO ylmf_class VALUES('1383','751','ĵ̨','','','29','1','','');
INSERT INTO ylmf_class VALUES('1384','751','̨','','','26','4','','');
INSERT INTO ylmf_class VALUES('1385','751','ຣ̨','','','28','2','','');
INSERT INTO ylmf_class VALUES('1386','751','½̨','','','24','2','','');
INSERT INTO ylmf_class VALUES('1387','751','̨','','','3','2','','');
INSERT INTO ylmf_class VALUES('1388','751','Ĵ̨','','','11','9','','');
INSERT INTO ylmf_class VALUES('1389','751','ݵ̨','','','25','6','','');
INSERT INTO ylmf_class VALUES('1390','751','ϵ̨','','','20','10','','');
INSERT INTO ylmf_class VALUES('1391','751','ص̨','','','30','1','','');
INSERT INTO ylmf_class VALUES('1392','751','̨̨','','','31','7','','');
INSERT INTO ylmf_class VALUES('1393','751','۵̨','','','32','6','','');
INSERT INTO ylmf_class VALUES('1394','751','ŵ̨','','','33','2','','');
INSERT INTO ylmf_class VALUES('1518','959','㶫˲','','','4','19','','');
INSERT INTO ylmf_class VALUES('1925','1082','','','','13','6','','');
INSERT INTO ylmf_class VALUES('1519','959','˲','','','10000','22','','');
INSERT INTO ylmf_class VALUES('1520','959','Ĵ˲','','','11','12','','');
INSERT INTO ylmf_class VALUES('1521','959','ຣ˲','','','28','9','','');
INSERT INTO ylmf_class VALUES('1522','959','½˲','','','24','11','','');
INSERT INTO ylmf_class VALUES('1523','959','˲','','','20','15','','');
INSERT INTO ylmf_class VALUES('1524','959','˲','','','26','9','','');
INSERT INTO ylmf_class VALUES('1525','959','˲','','','15','10','','');
INSERT INTO ylmf_class VALUES('1526','959','ɽ˲','','','6','13','','');
INSERT INTO ylmf_class VALUES('1527','959','˲','','','5','27','','');
INSERT INTO ylmf_class VALUES('1528','959','㽭˲','','','7','21','','');
INSERT INTO ylmf_class VALUES('1529','959','Ϻ˲','','','1','17','','');
INSERT INTO ylmf_class VALUES('1530','959','˲','','','17','7','','');
INSERT INTO ylmf_class VALUES('1531','959','˲','','','13','15','','');
INSERT INTO ylmf_class VALUES('1532','959','ɹ˲','','','23','15','','');
INSERT INTO ylmf_class VALUES('1533','959','˲','','','30','5','','');
INSERT INTO ylmf_class VALUES('1534','959','ӱ˲','','','9','9','','');
INSERT INTO ylmf_class VALUES('1535','959','˲','','','8','7','','');
INSERT INTO ylmf_class VALUES('1536','959','˲','','','29','10','','');
INSERT INTO ylmf_class VALUES('1537','959','˲','','','21','14','','');
INSERT INTO ylmf_class VALUES('1538','959','˲','','','3','9','','');
INSERT INTO ylmf_class VALUES('1539','959','˲','','','27','11','','');
INSERT INTO ylmf_class VALUES('1540','959','˲','','','25','14','','');
INSERT INTO ylmf_class VALUES('1541','959','˲','','','10','11','','');
INSERT INTO ylmf_class VALUES('1542','959','˲','','','19','14','','');
INSERT INTO ylmf_class VALUES('1543','959','˲','','','16','11','','');
INSERT INTO ylmf_class VALUES('1544','959','˲','','','14','12','','');
INSERT INTO ylmf_class VALUES('1545','959','˲','','','12','9','','');
INSERT INTO ylmf_class VALUES('1546','959','ɽ˲','','','22','11','','');
INSERT INTO ylmf_class VALUES('1547','959','˲','','','2','11','','');
INSERT INTO ylmf_class VALUES('1554','838','Ϻ','','','1','38','','');
INSERT INTO ylmf_class VALUES('1553','838','','','','10000','18','','');
INSERT INTO ylmf_class VALUES('1555','838','򱨿','','','2','4','','');
INSERT INTO ylmf_class VALUES('1551','959','˲','','','18','15','','');
INSERT INTO ylmf_class VALUES('1552','959','۰̨˲','','','31','15','','');
INSERT INTO ylmf_class VALUES('1556','838','챨','','','3','7','','');
INSERT INTO ylmf_class VALUES('1557','838','㶫','','','4','48','','');
INSERT INTO ylmf_class VALUES('1558','838','ձ','','','5','12','','');
INSERT INTO ylmf_class VALUES('1559','838','ɽ','','','6','31','','');
INSERT INTO ylmf_class VALUES('1560','838','㽭','','','7','30','','');
INSERT INTO ylmf_class VALUES('1561','838','ϱ','','','8','18','','');
INSERT INTO ylmf_class VALUES('1562','838','ӱ','','','9','9','','');
INSERT INTO ylmf_class VALUES('1563','838','','','','10','19','','');
INSERT INTO ylmf_class VALUES('1564','838','Ĵ','','','11','23','','');
INSERT INTO ylmf_class VALUES('1565','838','','','','12','18','','');
INSERT INTO ylmf_class VALUES('1566','838','','','','13','25','','');
INSERT INTO ylmf_class VALUES('1567','838','ϱ','','','14','19','','');
INSERT INTO ylmf_class VALUES('1568','838','','','','15','7','','');
INSERT INTO ylmf_class VALUES('1569','838','ձ','','','16','14','','');
INSERT INTO ylmf_class VALUES('1570','838','','','','17','8','','');
INSERT INTO ylmf_class VALUES('1571','838','','','','18','15','','');
INSERT INTO ylmf_class VALUES('1572','838','ֱ','','','19','9','','');
INSERT INTO ylmf_class VALUES('1573','838','ϱ','','','20','10','','');
INSERT INTO ylmf_class VALUES('1574','838','','','','21','11','','');
INSERT INTO ylmf_class VALUES('1575','838','ɽ','','','22','14','','');
INSERT INTO ylmf_class VALUES('1576','838','ɹű','','','23','4','','');
INSERT INTO ylmf_class VALUES('1577','838','½','','','24','0','','');
INSERT INTO ylmf_class VALUES('1578','838','ݱ','','','25','6','','');
INSERT INTO ylmf_class VALUES('1579','838','౨','','','26','3','','');
INSERT INTO ylmf_class VALUES('1580','838','ϱ','','','27','8','','');
INSERT INTO ylmf_class VALUES('1581','838','ຣ','','','28','1','','');
INSERT INTO ylmf_class VALUES('1582','838','ı','','','29','3','','');
INSERT INTO ylmf_class VALUES('1583','838','ر','','','30','1','','');
INSERT INTO ylmf_class VALUES('1584','838','۱','','','31','7','','');
INSERT INTO ylmf_class VALUES('1585','838','ű','','','32','5','','');
INSERT INTO ylmf_class VALUES('1586','838','̨屨','','','33','6','','');
INSERT INTO ylmf_class VALUES('1938','1936','̳','','','3','5','','');
INSERT INTO ylmf_class VALUES('1588','4','','','','123','0','design','');
INSERT INTO ylmf_class VALUES('2102','1588','ƽ','','','2','10','','');
INSERT INTO ylmf_class VALUES('1597','1596','WAP','','','10000','5','','');
INSERT INTO ylmf_class VALUES('1598','1596','ۺŻ','','','2','25','','');
INSERT INTO ylmf_class VALUES('1599','1596','̳','','','5','19','','');
INSERT INTO ylmf_class VALUES('1600','1596','ͼ','','','3','13','','');
INSERT INTO ylmf_class VALUES('1601','1596','ƶ','','','4','18','','');
INSERT INTO ylmf_class VALUES('1604','755','Ϻ̨','','','3','6','','');
INSERT INTO ylmf_class VALUES('1605','755','̨','','','2','7','','');
INSERT INTO ylmf_class VALUES('1606','755','ӱ̨','','','100','5','','');
INSERT INTO ylmf_class VALUES('1607','755','ɽ̨','','','100','11','','');
INSERT INTO ylmf_class VALUES('1608','755','ɽ̨','','','100','4','','');
INSERT INTO ylmf_class VALUES('1609','755','ɹŵ̨','','','104','3','','');
INSERT INTO ylmf_class VALUES('1610','755','յ̨','','','100','9','','');
INSERT INTO ylmf_class VALUES('1611','755','㽭̨','','','100','8','','');
INSERT INTO ylmf_class VALUES('1612','755','յ̨','','','100','1','','');
INSERT INTO ylmf_class VALUES('1613','755','̨','','','100','9','','');
INSERT INTO ylmf_class VALUES('1614','755','㶫̨','','','100','12','','');
INSERT INTO ylmf_class VALUES('1615','755','̨','','','100','2','','');
INSERT INTO ylmf_class VALUES('1616','755','ϵ̨','','','100','7','','');
INSERT INTO ylmf_class VALUES('1617','755','̨','','','100','7','','');
INSERT INTO ylmf_class VALUES('1618','755','ϵ̨','','','100','4','','');
INSERT INTO ylmf_class VALUES('1619','755','̨','','','100','5','','');
INSERT INTO ylmf_class VALUES('1620','755','̨','','','100','7','','');
INSERT INTO ylmf_class VALUES('1621','755','ֵ̨','','','100','2','','');
INSERT INTO ylmf_class VALUES('1622','755','̨','','','100','2','','');
INSERT INTO ylmf_class VALUES('1623','755','̨','','','100','6','','');
INSERT INTO ylmf_class VALUES('1624','755','ĵ̨','','','100','1','','');
INSERT INTO ylmf_class VALUES('1625','755','̨','','','100','1','','');
INSERT INTO ylmf_class VALUES('1626','755','ຣ̨','','','101','1','','');
INSERT INTO ylmf_class VALUES('1627','755','½̨','','','102','3','','');
INSERT INTO ylmf_class VALUES('1628','755','̨','','','100','0','','');
INSERT INTO ylmf_class VALUES('1629','755','Ĵ̨','','','100','4','','');
INSERT INTO ylmf_class VALUES('1630','755','ݵ̨','','','100','2','','');
INSERT INTO ylmf_class VALUES('1631','755','ϵ̨','','','100','2','','');
INSERT INTO ylmf_class VALUES('1632','755','ص̨','','','103','0','','');
INSERT INTO ylmf_class VALUES('1633','755','̨̨','','','100','0','','');
INSERT INTO ylmf_class VALUES('1634','755','۵̨','','','100','1','','');
INSERT INTO ylmf_class VALUES('1635','755','ŵ̨','','','105','1','','');
INSERT INTO ylmf_class VALUES('1636','1273','ҵϢ','','','10000','10','','');
INSERT INTO ylmf_class VALUES('1637','2196','Ϳ','','','11','10','','');
INSERT INTO ylmf_class VALUES('1645','1251','','','','1','10','','');
INSERT INTO ylmf_class VALUES('1646','1251','Ѷ','','','6','8','','');
INSERT INTO ylmf_class VALUES('1647','1251','ڻѶ','','','7','4','','');
INSERT INTO ylmf_class VALUES('1648','1251','ƽѶ','','','8','5','','');
INSERT INTO ylmf_class VALUES('1649','1251','֤ȯծȯ','','','3','10','','');
INSERT INTO ylmf_class VALUES('1687','2204','۰̨','','','4','20','','');
INSERT INTO ylmf_class VALUES('1652','1251','Ͷ','','','9','2','','');
INSERT INTO ylmf_class VALUES('1653','1221','ũϢ','','','6','11','','');
INSERT INTO ylmf_class VALUES('1654','1221','ũҵ','','','7','9','','');
INSERT INTO ylmf_class VALUES('1655','1221','Ϲҵ','','','8','8','','');
INSERT INTO ylmf_class VALUES('1656','1221','ũҵе','','','9','5','','');
INSERT INTO ylmf_class VALUES('1658','2194','˱','','','5','12','','');
INSERT INTO ylmf_class VALUES('1659','2194','ع·','','','2','34','','');
INSERT INTO ylmf_class VALUES('2196','1194','ֻԴ','','','100','0','','');
INSERT INTO ylmf_class VALUES('1662','1168','۽','','','2','11','','');
INSERT INTO ylmf_class VALUES('2285','2','','','','115','0','sex','');
INSERT INTO ylmf_class VALUES('1664','1168','̳','','','3','9','','');
INSERT INTO ylmf_class VALUES('1665','2175','','','','10000','26','','');
INSERT INTO ylmf_class VALUES('1666','2175','Ʒ','','','6','50','','');
INSERT INTO ylmf_class VALUES('1668','1172','ҵ','','','3','7','','');
INSERT INTO ylmf_class VALUES('1670','2150','','','','12','14','','');
INSERT INTO ylmf_class VALUES('1671','2150','','','','11','21','','');
INSERT INTO ylmf_class VALUES('1672','2223','赸','','','2','7','','');
INSERT INTO ylmf_class VALUES('1673','2150','','','','10','12','','');
INSERT INTO ylmf_class VALUES('1674','2150','˶','','','24','10','','');
INSERT INTO ylmf_class VALUES('1675','2150','ˮ˶','','','23','8','','');
INSERT INTO ylmf_class VALUES('1676','2150','ѩ˶','','','22','4','','');
INSERT INTO ylmf_class VALUES('1677','2150','','','','21','7','','');
INSERT INTO ylmf_class VALUES('1678','927','','','','3','5','','');
INSERT INTO ylmf_class VALUES('2152','1020','Ʊ','','','2','8','','');
INSERT INTO ylmf_class VALUES('1680','2223','','','','3','15','','');
INSERT INTO ylmf_class VALUES('2168','725','ԺУ','','','100','8','','');
INSERT INTO ylmf_class VALUES('1682','1682','ɼ','','','6','0','Wangba_Lianmeng','');
INSERT INTO ylmf_class VALUES('2092','2091','йͨ','','','100','30','','');
INSERT INTO ylmf_class VALUES('1690','946','йѧ','','','0','5','','');
INSERT INTO ylmf_class VALUES('1691','2246','У԰ۺ','','','0','13','','');
INSERT INTO ylmf_class VALUES('1700','1682','ۺ','','','1','30','','');
INSERT INTO ylmf_class VALUES('1701','1143','߷','','','3','14','','');
INSERT INTO ylmf_class VALUES('1702','2199','Ӳ','','','2','10','','');
INSERT INTO ylmf_class VALUES('1706','1082','֯','','','7','29','','');
INSERT INTO ylmf_class VALUES('1707','1082','˾','','','12','34','','');
INSERT INTO ylmf_class VALUES('1708','2203','ҽԺ','','','5','17','','');
INSERT INTO ylmf_class VALUES('1714','1076','MP3','','','2','5','','');
INSERT INTO ylmf_class VALUES('1715','1076','ѵ½','','','4','5','','');
INSERT INTO ylmf_class VALUES('1716','1152','Դ','','','2','15','','');
INSERT INTO ylmf_class VALUES('2138','851','','','','10','10','','');
INSERT INTO ylmf_class VALUES('2053','2050','ξ','','','3','2','','');
INSERT INTO ylmf_class VALUES('1720','851','֧','','','9','10','pay_tools','');
INSERT INTO ylmf_class VALUES('1722','871','ҽԺ','','','2','11','','');
INSERT INTO ylmf_class VALUES('1723','871','ӱҽԺ','','','100','12','','');
INSERT INTO ylmf_class VALUES('1724','871','ɽҽԺ','','','100','6','','');
INSERT INTO ylmf_class VALUES('1725','871','ɹҽԺ','','','100','3','','');
INSERT INTO ylmf_class VALUES('1726','871','ҽԺ','','','100','12','','');
INSERT INTO ylmf_class VALUES('1727','871','ҽԺ','','','100','9','','');
INSERT INTO ylmf_class VALUES('1728','871','ҽԺ','','','100','11','','');
INSERT INTO ylmf_class VALUES('1729','871','ϺҽԺ','','','3','32','','');
INSERT INTO ylmf_class VALUES('1730','871','ҽԺ','','','100','24','','');
INSERT INTO ylmf_class VALUES('1731','871','㽭ҽԺ','','','100','14','','');
INSERT INTO ylmf_class VALUES('1732','871','ҽԺ','','','100','7','','');
INSERT INTO ylmf_class VALUES('1733','871','ҽԺ','','','100','21','','');
INSERT INTO ylmf_class VALUES('1734','871','ҽԺ','','','100','11','','');
INSERT INTO ylmf_class VALUES('1735','871','ɽҽԺ','','','100','9','','');
INSERT INTO ylmf_class VALUES('1736','871','ҽԺ','','','100','10','','');
INSERT INTO ylmf_class VALUES('1737','871','ҽԺ','','','100','10','','');
INSERT INTO ylmf_class VALUES('1738','871','ҽԺ','','','100','6','','');
INSERT INTO ylmf_class VALUES('1739','871','㶫ҽԺ','','','100','30','','');
INSERT INTO ylmf_class VALUES('1740','871','ҽԺ','','','100','8','','');
INSERT INTO ylmf_class VALUES('1741','871','ҽԺ','','','100','5','','');
INSERT INTO ylmf_class VALUES('1742','871','ҽԺ','','','100','5','','');
INSERT INTO ylmf_class VALUES('1743','871','ĴҽԺ','','','100','2','','');
INSERT INTO ylmf_class VALUES('1744','871','ҽԺ','','','100','6','','');
INSERT INTO ylmf_class VALUES('1745','871','ҽԺ','','','100','6','','');
INSERT INTO ylmf_class VALUES('1746','871','ҽԺ','','','100','1','','');
INSERT INTO ylmf_class VALUES('1747','871','ҽԺ','','','100','4','','');
INSERT INTO ylmf_class VALUES('1748','871','ҽԺ','','','100','3','','');
INSERT INTO ylmf_class VALUES('1749','871','ҽԺ','','','100','4','','');
INSERT INTO ylmf_class VALUES('1750','871','½ҽԺ','','','100','2','','');
INSERT INTO ylmf_class VALUES('1751','871','ҽԺ','','','101','3','','');
INSERT INTO ylmf_class VALUES('1752','871','ҽԺ','','','102','4','','');
INSERT INTO ylmf_class VALUES('1753','871','̨ҽԺ','','','103','6','','');
INSERT INTO ylmf_class VALUES('1754','871','ຣҽԺ','','','100','2','','');
INSERT INTO ylmf_class VALUES('2201','734','ݳƷ','','','3','5','','');
INSERT INTO ylmf_class VALUES('1756','2159','о','','','16','24','','');
INSERT INTO ylmf_class VALUES('1757','2159','Ƽվ','','','18','26','','');
INSERT INTO ylmf_class VALUES('1758','2159','ѧо','','','10000','18','','');
INSERT INTO ylmf_class VALUES('2299','2298','','','','0','1','/jingtai/yule/feizhuliu/','');
INSERT INTO ylmf_class VALUES('2203','863','ҽ','','','6','0','','');
INSERT INTO ylmf_class VALUES('1761','878','ط','','','3','6','','');
INSERT INTO ylmf_class VALUES('1762','1761','','','','10000','8','','');
INSERT INTO ylmf_class VALUES('1763','1761','򷿲','','','2','3','','');
INSERT INTO ylmf_class VALUES('1764','1761','ӱ','','','99','2','','');
INSERT INTO ylmf_class VALUES('1765','1761','ɽ','','','100','1','','');
INSERT INTO ylmf_class VALUES('1766','1761','ɹŷ','','','104','1','','');
INSERT INTO ylmf_class VALUES('1767','1761','','','','99','7','','');
INSERT INTO ylmf_class VALUES('1768','1761','ַ','','','100','1','','');
INSERT INTO ylmf_class VALUES('1769','1761','','','','100','2','','');
INSERT INTO ylmf_class VALUES('1770','1761','Ϻ','','','3','13','','');
INSERT INTO ylmf_class VALUES('1771','1761','շ','','','99','8','','');
INSERT INTO ylmf_class VALUES('1772','1761','㽭','','','99','7','','');
INSERT INTO ylmf_class VALUES('1773','1761','շ','','','100','3','','');
INSERT INTO ylmf_class VALUES('1774','1761','','','','99','12','','');
INSERT INTO ylmf_class VALUES('1775','1761','','','','99','5','','');
INSERT INTO ylmf_class VALUES('1776','1761','ɽ','','','99','10','','');
INSERT INTO ylmf_class VALUES('1777','1761','Ϸ','','','99','4','','');
INSERT INTO ylmf_class VALUES('1778','1761','','','','99','4','','');
INSERT INTO ylmf_class VALUES('1779','1761','Ϸ','','','99','1','','');
INSERT INTO ylmf_class VALUES('1780','1761','㶫','','','99','12','','');
INSERT INTO ylmf_class VALUES('1781','1761','','','','99','5','','');
INSERT INTO ylmf_class VALUES('1782','1761','Ϸ','','','100','3','','');
INSERT INTO ylmf_class VALUES('1783','1761','췿','','','100','2','','');
INSERT INTO ylmf_class VALUES('1784','1761','Ĵ','','','100','4','','');
INSERT INTO ylmf_class VALUES('1785','1761','ݷ','','','100','1','','');
INSERT INTO ylmf_class VALUES('1786','1761','Ϸ','','','100','2','','');
INSERT INTO ylmf_class VALUES('1787','1761','ط','','','100','1','','');
INSERT INTO ylmf_class VALUES('1788','1761','','','','99','3','','');
INSERT INTO ylmf_class VALUES('1789','1761','෿','','','100','2','','');
INSERT INTO ylmf_class VALUES('1790','1761','ຣ','','','101','2','','');
INSERT INTO ylmf_class VALUES('1791','1761','ķ','','','100','1','','');
INSERT INTO ylmf_class VALUES('1792','1761','½','','','102','1','','');
INSERT INTO ylmf_class VALUES('1793','1761','۷','','','105','0','','');
INSERT INTO ylmf_class VALUES('1794','1761','̨巿','','','106','0','','');
INSERT INTO ylmf_class VALUES('1797','893','','','','10000','23','','');
INSERT INTO ylmf_class VALUES('1798','893','','','','2','10','','');
INSERT INTO ylmf_class VALUES('1799','893','ӱ','','','100','5','','');
INSERT INTO ylmf_class VALUES('1800','893','ɽ','','','100','8','','');
INSERT INTO ylmf_class VALUES('1801','893','ɹ','','','100','5','','');
INSERT INTO ylmf_class VALUES('1802','893','','','','100','17','','');
INSERT INTO ylmf_class VALUES('1803','893','','','','100','8','','');
INSERT INTO ylmf_class VALUES('1804','893','','','','100','15','','');
INSERT INTO ylmf_class VALUES('1805','893','Ϻ','','','3','10','','');
INSERT INTO ylmf_class VALUES('1806','893','','','','100','29','','');
INSERT INTO ylmf_class VALUES('1807','893','㽭','','','100','20','','');
INSERT INTO ylmf_class VALUES('1808','893','','','','100','15','','');
INSERT INTO ylmf_class VALUES('1809','893','','','','100','19','','');
INSERT INTO ylmf_class VALUES('1810','893','','','','100','15','','');
INSERT INTO ylmf_class VALUES('1811','893','ɽ','','','100','12','','');
INSERT INTO ylmf_class VALUES('1812','893','','','','100','18','','');
INSERT INTO ylmf_class VALUES('1813','893','','','','100','14','','');
INSERT INTO ylmf_class VALUES('1814','893','','','','100','22','','');
INSERT INTO ylmf_class VALUES('1815','893','㶫','','','100','18','','');
INSERT INTO ylmf_class VALUES('1816','893','','','','100','11','','');
INSERT INTO ylmf_class VALUES('1817','893','','','','100','18','','');
INSERT INTO ylmf_class VALUES('1818','893','','','','100','13','','');
INSERT INTO ylmf_class VALUES('1819','893','Ĵ','','','100','31','','');
INSERT INTO ylmf_class VALUES('1820','893','','','','100','14','','');
INSERT INTO ylmf_class VALUES('1821','893','','','','100','12','','');
INSERT INTO ylmf_class VALUES('1822','893','','','','100','11','','');
INSERT INTO ylmf_class VALUES('1823','893','','','','100','12','','');
INSERT INTO ylmf_class VALUES('1824','893','','','','100','10','','');
INSERT INTO ylmf_class VALUES('1825','893','ຣ','','','100','8','','');
INSERT INTO ylmf_class VALUES('1826','893','','','','100','9','','');
INSERT INTO ylmf_class VALUES('1827','893','½','','','100','12','','');
INSERT INTO ylmf_class VALUES('1828','893','','','','101','11','','');
INSERT INTO ylmf_class VALUES('1829','893','','','','102','5','','');
INSERT INTO ylmf_class VALUES('1830','893','̨','','','103','10','','');
INSERT INTO ylmf_class VALUES('1832','905','޵','','','10000','20','','');
INSERT INTO ylmf_class VALUES('1833','905','ŷ޵','','','100','46','','');
INSERT INTO ylmf_class VALUES('1834','905','','','','100','11','','');
INSERT INTO ylmf_class VALUES('1835','905','','','','100','4','','');
INSERT INTO ylmf_class VALUES('1836','905','޵','','','100','3','','');
INSERT INTO ylmf_class VALUES('1837','905','','','','100','3','','');
INSERT INTO ylmf_class VALUES('1838','902','','','','10000','19','','');
INSERT INTO ylmf_class VALUES('1839','902','','','','2','11','','');
INSERT INTO ylmf_class VALUES('1840','902','ӱ','','','100','12','','');
INSERT INTO ylmf_class VALUES('1841','902','ɽ','','','100','11','','');
INSERT INTO ylmf_class VALUES('1842','902','ɹ','','','103','15','','');
INSERT INTO ylmf_class VALUES('1843','902','','','','100','12','','');
INSERT INTO ylmf_class VALUES('1844','902','','','','100','9','','');
INSERT INTO ylmf_class VALUES('1845','902','','','','100','12','','');
INSERT INTO ylmf_class VALUES('1846','902','Ϻ','','','3','18','','');
INSERT INTO ylmf_class VALUES('1847','902','','','','100','14','','');
INSERT INTO ylmf_class VALUES('1848','902','㽭','','','100','11','','');
INSERT INTO ylmf_class VALUES('1849','902','','','','100','18','','');
INSERT INTO ylmf_class VALUES('1850','902','','','','100','10','','');
INSERT INTO ylmf_class VALUES('1851','902','','','','100','11','','');
INSERT INTO ylmf_class VALUES('1852','902','ɽ','','','100','17','','');
INSERT INTO ylmf_class VALUES('1853','902','','','','100','19','','');
INSERT INTO ylmf_class VALUES('1854','902','','','','100','16','','');
INSERT INTO ylmf_class VALUES('1855','902','','','','100','9','','');
INSERT INTO ylmf_class VALUES('1856','902','㶫','','','100','20','','');
INSERT INTO ylmf_class VALUES('1857','902','','','','100','10','','');
INSERT INTO ylmf_class VALUES('1858','902','','','','100','7','','');
INSERT INTO ylmf_class VALUES('1859','902','','','','100','16','','');
INSERT INTO ylmf_class VALUES('1860','902','Ĵ','','','100','19','','');
INSERT INTO ylmf_class VALUES('1861','902','','','','100','16','','');
INSERT INTO ylmf_class VALUES('1862','902','','','','100','16','','');
INSERT INTO ylmf_class VALUES('1863','902','','','','100','3','','');
INSERT INTO ylmf_class VALUES('1864','902','','','','100','20','','');
INSERT INTO ylmf_class VALUES('1865','902','','','','100','13','','');
INSERT INTO ylmf_class VALUES('1866','902','ຣ','','','101','4','','');
INSERT INTO ylmf_class VALUES('1867','902','','','','100','5','','');
INSERT INTO ylmf_class VALUES('1868','902','½','','','102','0','','');
INSERT INTO ylmf_class VALUES('1869','902','','','','104','11','','');
INSERT INTO ylmf_class VALUES('1870','902','','','','105','12','','');
INSERT INTO ylmf_class VALUES('1871','2188','Ʒ','','','5','58','','');
INSERT INTO ylmf_class VALUES('1872','2188','ʳƷ','','','10000','37','','');
INSERT INTO ylmf_class VALUES('1873','2188','','','','3','20','','');
INSERT INTO ylmf_class VALUES('1874','2188','Ʒ','','','7','18','','');
INSERT INTO ylmf_class VALUES('1875','2188','ҵƷ','','','8','43','','');
INSERT INTO ylmf_class VALUES('1876','2188','ƷƵ','','','9','18','','');
INSERT INTO ylmf_class VALUES('1877','2188','ֻƷ','','','6','14','','');
INSERT INTO ylmf_class VALUES('1878','912','ɷ','','','2','15','','');
INSERT INTO ylmf_class VALUES('1879','912','Ԯ','','','4','12','','');
INSERT INTO ylmf_class VALUES('1880','2205','̱귨','','','10000','17','','');
INSERT INTO ylmf_class VALUES('1884','2225','','','','6','4','','');
INSERT INTO ylmf_class VALUES('1885','1917','','','','10000','48','','');
INSERT INTO ylmf_class VALUES('1886','1917','Ϻ','','','3','50','','');
INSERT INTO ylmf_class VALUES('1887','1917','','','','2','50','','');
INSERT INTO ylmf_class VALUES('1888','1917','','','','100','52','','');
INSERT INTO ylmf_class VALUES('1889','1917','ӱ','','','100','54','','');
INSERT INTO ylmf_class VALUES('1890','1917','ɽ','','','100','50','','');
INSERT INTO ylmf_class VALUES('1891','1917','','','','103','31','','');
INSERT INTO ylmf_class VALUES('1892','1917','','','','100','60','','');
INSERT INTO ylmf_class VALUES('1893','1917','','','','100','39','','');
INSERT INTO ylmf_class VALUES('1894','1917','','','','100','44','','');
INSERT INTO ylmf_class VALUES('1895','1917','','','','100','57','','');
INSERT INTO ylmf_class VALUES('1896','1917','㽭','','','100','34','','');
INSERT INTO ylmf_class VALUES('1897','1917','','','','100','35','','');
INSERT INTO ylmf_class VALUES('1898','1917','','','','100','44','','');
INSERT INTO ylmf_class VALUES('1899','1917','','','','100','53','','');
INSERT INTO ylmf_class VALUES('1900','1917','ɽ','','','100','50','','');
INSERT INTO ylmf_class VALUES('1901','1917','','','','100','44','','');
INSERT INTO ylmf_class VALUES('1902','1917','','','','100','42','','');
INSERT INTO ylmf_class VALUES('1903','1917','','','','100','45','','');
INSERT INTO ylmf_class VALUES('1904','1917','㶫','','','100','51','','');
INSERT INTO ylmf_class VALUES('1905','1917','','','','100','41','','');
INSERT INTO ylmf_class VALUES('1906','1917','','','','100','47','','');
INSERT INTO ylmf_class VALUES('1907','1917','Ĵ','','','100','44','','');
INSERT INTO ylmf_class VALUES('1908','1917','','','','100','9','','');
INSERT INTO ylmf_class VALUES('1909','1917','','','','100','37','','');
INSERT INTO ylmf_class VALUES('1910','1917','','','','105','9','','');
INSERT INTO ylmf_class VALUES('1911','1917','','','','100','49','','');
INSERT INTO ylmf_class VALUES('1912','1917','','','','100','44','','');
INSERT INTO ylmf_class VALUES('1913','1917','ຣ','','','104','37','','');
INSERT INTO ylmf_class VALUES('1914','1917','','','','100','41','','');
INSERT INTO ylmf_class VALUES('1915','1917','½','','','106','0','','');
INSERT INTO ylmf_class VALUES('1916','1917','','','','108','30','','');
INSERT INTO ylmf_class VALUES('1917','917','','','','2','0','','');
INSERT INTO ylmf_class VALUES('2198','4','','','','104','0','computer','');
INSERT INTO ylmf_class VALUES('2279','2278','Ա','','','14','1','/wangshanggouwu/index.html','');
INSERT INTO ylmf_class VALUES('2295','856','л','','','4','5','','');
INSERT INTO ylmf_class VALUES('1934','2209','Ů̳','','','18','17','','');
INSERT INTO ylmf_class VALUES('1935','2209','̳','','','19','15','','');
INSERT INTO ylmf_class VALUES('1939','1936','ӱ̳','','','14','8','','');
INSERT INTO ylmf_class VALUES('1940','1936','ɽ̳','','','13','8','','');
INSERT INTO ylmf_class VALUES('1941','1936','ɹ̳','','','31','4','','');
INSERT INTO ylmf_class VALUES('1942','1936','̳','','','25','7','','');
INSERT INTO ylmf_class VALUES('1943','1936','̳','','','16','3','','');
INSERT INTO ylmf_class VALUES('1944','1936','̳','','','5','4','','');
INSERT INTO ylmf_class VALUES('1945','1936','Ϻ̳','','','2','10','','');
INSERT INTO ylmf_class VALUES('1946','1936','̳','','','17','15','','');
INSERT INTO ylmf_class VALUES('1947','1936','㽭̳','','','18','24','','');
INSERT INTO ylmf_class VALUES('1948','1936','̳','','','19','12','','');
INSERT INTO ylmf_class VALUES('1949','1936','̳','','','20','17','','');
INSERT INTO ylmf_class VALUES('1950','1936','̳','','','21','4','','');
INSERT INTO ylmf_class VALUES('1951','1936','ɽ̳','','','22','17','','');
INSERT INTO ylmf_class VALUES('1952','1936','̳','','','23','9','','');
INSERT INTO ylmf_class VALUES('1953','1936','̳','','','24','12','','');
INSERT INTO ylmf_class VALUES('1954','1936','̳','','','27','7','','');
INSERT INTO ylmf_class VALUES('1955','1936','㶫̳','','','8','26','','');
INSERT INTO ylmf_class VALUES('1956','1936','̳','','','26','7','','');
INSERT INTO ylmf_class VALUES('1957','1936','̳','','','15','5','','');
INSERT INTO ylmf_class VALUES('1958','1936','̳','','','4','6','','');
INSERT INTO ylmf_class VALUES('1959','1936','Ĵ̳','','','6','6','','');
INSERT INTO ylmf_class VALUES('1960','1936','̳','','','7','4','','');
INSERT INTO ylmf_class VALUES('1961','1936','̳','','','28','3','','');
INSERT INTO ylmf_class VALUES('1962','1936','̳','','','30','2','','');
INSERT INTO ylmf_class VALUES('1963','1936','̳','','','8','5','','');
INSERT INTO ylmf_class VALUES('1964','1936','̳','','','9','5','','');
INSERT INTO ylmf_class VALUES('1965','1936','ຣ̳','','','10','2','','');
INSERT INTO ylmf_class VALUES('1966','1936','̳','','','11','6','','');
INSERT INTO ylmf_class VALUES('1967','1936','½̳','','','29','5','','');
INSERT INTO ylmf_class VALUES('1968','1936','̳','','','101','4','','');
INSERT INTO ylmf_class VALUES('1969','1936','̳','','','102','3','','');
INSERT INTO ylmf_class VALUES('1970','1936','̨̳','','','103','1','','');
INSERT INTO ylmf_class VALUES('2273','5','','','','100','0','qiumi','');
INSERT INTO ylmf_class VALUES('1979','2209','̳','','','21','25','','');
INSERT INTO ylmf_class VALUES('1980','2212','ӰѶ','','','3','20','','');
INSERT INTO ylmf_class VALUES('2272','2034','NBAר','','','0','15','','');
INSERT INTO ylmf_class VALUES('1983','2273','Խ','','','10000','19','','');
INSERT INTO ylmf_class VALUES('1984','1076','߼','','','6','5','','');
INSERT INTO ylmf_class VALUES('1985','2091','йƶ','','','6','34','','');
INSERT INTO ylmf_class VALUES('1986','2091','йͨ','','','7','28','','');
INSERT INTO ylmf_class VALUES('2169','1152','ѧϰ','','','3','0','','');
INSERT INTO ylmf_class VALUES('1988','2091','йص','','','5','28','','');
INSERT INTO ylmf_class VALUES('2276','831','ʱ̳','','','3','5','','');
INSERT INTO ylmf_class VALUES('1990','851','/','','','2','15','','');
INSERT INTO ylmf_class VALUES('1991','851','/ҵ','','','3','8','','');
INSERT INTO ylmf_class VALUES('1992','851','Ů/ĸӤ','','','5','12','','');
INSERT INTO ylmf_class VALUES('2052','2050','ŷξ','','','2','13','','');
INSERT INTO ylmf_class VALUES('1994','2175','ų','','','8','34','','');
INSERT INTO ylmf_class VALUES('1995','856','չ˾','','','3','10','','');
INSERT INTO ylmf_class VALUES('1996','2148','Ż˾','','','9','49','','');
INSERT INTO ylmf_class VALUES('1997','1251','','','','4','10','','');
INSERT INTO ylmf_class VALUES('2204','856','','','','6','0','','');
INSERT INTO ylmf_class VALUES('2000','1044','Ӣѧϰ̳','','','3','4','','');
INSERT INTO ylmf_class VALUES('2263','3','߿','','','5','0','gaokao','');
INSERT INTO ylmf_class VALUES('2003','2161','רҵ࿼','','','12','20','','');
INSERT INTO ylmf_class VALUES('2004','1082','ͨѶ','','','10','22','','');
INSERT INTO ylmf_class VALUES('2030','1596','Ӱ','','','8','10','','');
INSERT INTO ylmf_class VALUES('2292','1095','Ӳ','','','5','8','','');
INSERT INTO ylmf_class VALUES('2044','741','QQռ','','','3','10','','');
INSERT INTO ylmf_class VALUES('2148','842','ƾ','','','100','0','','');
INSERT INTO ylmf_class VALUES('2147','1095','Ӳ','','','6','0','','');
INSERT INTO ylmf_class VALUES('2091','2','ͨ','','','120','0','','');
INSERT INTO ylmf_class VALUES('2094','2149','йԺ','','','8','14','','');
INSERT INTO ylmf_class VALUES('2096','1917','̨','','','110','28','','');
INSERT INTO ylmf_class VALUES('2114','2220','ͳ','','','3','9','','');
INSERT INTO ylmf_class VALUES('2307','1020','','','','3','6','','');
INSERT INTO ylmf_class VALUES('2106','1588','ۺ','','','1','20','','');
INSERT INTO ylmf_class VALUES('2109','2220','վ','','','2','20','','');
INSERT INTO ylmf_class VALUES('2111','2247','洫ý','','','10000','12','','');
INSERT INTO ylmf_class VALUES('2112','2247','гӪ','','','6','8','','');
INSERT INTO ylmf_class VALUES('2303','907','ױƷ','','','4','19','','');
INSERT INTO ylmf_class VALUES('2116','2034','','','','2','9','','');
INSERT INTO ylmf_class VALUES('2305','2285','Ʒ','','','2','2','','');
INSERT INTO ylmf_class VALUES('2306','2285','̳','','','3','5','','');
INSERT INTO ylmf_class VALUES('2119','1172','ҵ','','','2','12','','');
INSERT INTO ylmf_class VALUES('2120','4','BT','','','106','0','BT','');
INSERT INTO ylmf_class VALUES('2121','652','Ӱۺ','','','0','15','','');
INSERT INTO ylmf_class VALUES('2122','652','Ӱ̳','','','3','9','','');
INSERT INTO ylmf_class VALUES('2144','1711','Ʒ','','','10000','39','','');
INSERT INTO ylmf_class VALUES('2139','856','֧','','','5','9','','');
INSERT INTO ylmf_class VALUES('2140','2209','̳','','','16','2','','');
INSERT INTO ylmf_class VALUES('2141','698','ҳϷ','','','3','16','','');
INSERT INTO ylmf_class VALUES('2161','3','','','','4','0','kaoshi','');
INSERT INTO ylmf_class VALUES('2166','2224','˹ַ','','','4','4','','');
INSERT INTO ylmf_class VALUES('2171','2169','Ajax','','','100','2','','');
INSERT INTO ylmf_class VALUES('2172','824','ȫӴ','','','3','0','','');
INSERT INTO ylmf_class VALUES('2173','924','طƷ/Ʒ','','','100','0','','');
INSERT INTO ylmf_class VALUES('2174','924','ʻ','','','2','5','','');
INSERT INTO ylmf_class VALUES('2175','1168','/Ʒ/','','','100','0','','');
INSERT INTO ylmf_class VALUES('2176','2175','ضֳ','','','100','21','','');
INSERT INTO ylmf_class VALUES('2177','1168','Уѧ','','','6','5','','');
INSERT INTO ylmf_class VALUES('2178','899','һ','','','10000','4','','');
INSERT INTO ylmf_class VALUES('2179','899','й','','','2','0','','');
INSERT INTO ylmf_class VALUES('2180','899','Ժɲ','','','1','24','','');
INSERT INTO ylmf_class VALUES('2187','1216','й/500ǿ','','','100','0','','');
INSERT INTO ylmf_class VALUES('2182','2179','Ժֱ','','','100','20','','');
INSERT INTO ylmf_class VALUES('2183','2179','Ժ»','','','100','4','','');
INSERT INTO ylmf_class VALUES('2184','2179','Ժҵλ','','','100','27','','');
INSERT INTO ylmf_class VALUES('2185','2179','ԺίҾ','','','100','10','','');
INSERT INTO ylmf_class VALUES('2186','899','/֯','','','4','0','','');
INSERT INTO ylmf_class VALUES('2213','1','','','','119','0','http://game.114la.com/','');
INSERT INTO ylmf_class VALUES('2294','668','΢','','','2','5','','');
INSERT INTO ylmf_class VALUES('2215','1','СϷ','','','121','0','xiaoyouxi','');
INSERT INTO ylmf_class VALUES('2216','2','','','','101','0','http://tool.114la.com/tianqi','');
INSERT INTO ylmf_class VALUES('2217','2','ѯ','','','102','0','http://tool.114la.com/','');
INSERT INTO ylmf_class VALUES('2218','2','Ů','','','114','0','lady','');
INSERT INTO ylmf_class VALUES('2219','4','','','','107','0','desktop','');
INSERT INTO ylmf_class VALUES('2220','2226','վ','','','125','0','webtool','');
INSERT INTO ylmf_class VALUES('2240','2239','ͨ','','','100','11','','');
INSERT INTO ylmf_class VALUES('2223','3','','','','10','0','quyi','');
INSERT INTO ylmf_class VALUES('2224','3','ڽ','','','14','0','zongjiao','');
INSERT INTO ylmf_class VALUES('2225','3','','','','15','0','gongyi','');
INSERT INTO ylmf_class VALUES('2312','4','վ','','','0','0','http://www.myler.cn/Jianzhan_Sheji/index.htm','');
INSERT INTO ylmf_class VALUES('2241','2239','','','','100','10','','');
INSERT INTO ylmf_class VALUES('2228','2226','ҵ','','','104','0','http://www.myler.cn/hangye/index.htm','');
INSERT INTO ylmf_class VALUES('2229','2226','ɱ','','','108','0','shadu','');
INSERT INTO ylmf_class VALUES('2309','824','΢','','','1','18','','');
INSERT INTO ylmf_class VALUES('2308','1020','2010Ϸ籭ר','','','4','15','','');
INSERT INTO ylmf_class VALUES('2234','2218','','','','3','8','','');
INSERT INTO ylmf_class VALUES('2291','1138','ȫ','','','4','5','','');
INSERT INTO ylmf_class VALUES('2287','1105','','','','0','21','','');
INSERT INTO ylmf_class VALUES('2237','2223','ħӼ','','','4','5','','');
INSERT INTO ylmf_class VALUES('2238','2223','طϷ','','','5','11','','');
INSERT INTO ylmf_class VALUES('2242','803','ѵӰ','','','2','5','','');
INSERT INTO ylmf_class VALUES('2244','5','ӵ繤','','','100','0','dianzi','');
INSERT INTO ylmf_class VALUES('2245','5','Դ','','','100','0','nengyuan','');
INSERT INTO ylmf_class VALUES('2246','3','У԰','','','9','0','xiaoyuan','');
INSERT INTO ylmf_class VALUES('2247','5','Ӫ','','','100','0','yingxiao','');
INSERT INTO ylmf_class VALUES('2248','5','Ƶ','','','100','0','hotel','');
INSERT INTO ylmf_class VALUES('2249','2248','Ƶ','','','10000','7','','');
INSERT INTO ylmf_class VALUES('2250','5','  ','','','100','0','chubanshe','');
INSERT INTO ylmf_class VALUES('2251','5','ҽе','','','100','0','yiliaoqixie','');
INSERT INTO ylmf_class VALUES('2252','2251','ҽе','','','10000','13','','');
INSERT INTO ylmf_class VALUES('2253','698','СϷ','','','2','13','','');
INSERT INTO ylmf_class VALUES('2254','2215','Ϸר','','','100','25','','');
INSERT INTO ylmf_class VALUES('2255','2215','ҳϷ','','','100','18','','');
INSERT INTO ylmf_class VALUES('2256','2215','СϷ','','','100','23','','');
INSERT INTO ylmf_class VALUES('2301','644','','','','2','5','','');
INSERT INTO ylmf_class VALUES('2260','1121','༭','','','100','3','','');
INSERT INTO ylmf_class VALUES('2262','2261','Ȥ̽','','','10000','26','','');
INSERT INTO ylmf_class VALUES('2264','3','','','','6','0','kaoyan','');
INSERT INTO ylmf_class VALUES('2290','2199','ʼ','','','4','3','','');
INSERT INTO ylmf_class VALUES('2268','2229','ľ/ɱ','','','100','8','','');
INSERT INTO ylmf_class VALUES('2278','5','Ա','','','100','0','daogou','');
INSERT INTO ylmf_class VALUES('2310','731','Ц΢','','','2','5','','');
INSERT INTO ylmf_class VALUES('2311','2219','ͼƬ','','','3','4','','');
INSERT INTO ylmf_class VALUES('2314','4','','','','100','0','zhaoshangjiameng','');
INSERT INTO ylmf_class VALUES('2316','2314','̼','','','1','11','','');
INSERT INTO ylmf_class VALUES('2317','2314','','','','2','18','','');
INSERT INTO ylmf_class VALUES('2318','2314','ҵҳ','','','3','12','','');
INSERT INTO ylmf_class VALUES('2319','4','','','','1','0','mina','');
INSERT INTO ylmf_class VALUES('2320','2319','2','','','1','36','','');
INSERT INTO ylmf_class VALUES('2322','2321','3','','','1','60','','');

INSERT INTO ylmf_config VALUES('yl_admingd','0');
INSERT INTO ylmf_config VALUES('yl_cc','1');
INSERT INTO ylmf_config VALUES('yl_ceoconnect','http://www.myler.cn');
INSERT INTO ylmf_config VALUES('yl_ceoemail','OpenSource@ylmf.com');
INSERT INTO ylmf_config VALUES('yl_ckpath','/');
INSERT INTO ylmf_config VALUES('yl_clickcount','1');
INSERT INTO ylmf_config VALUES('yl_cvtime','0');
INSERT INTO ylmf_config VALUES('yl_datefm','Y-m-j H:i');
INSERT INTO ylmf_config VALUES('yl_debug','1');
INSERT INTO ylmf_config VALUES('yl_footertime','1');
INSERT INTO ylmf_config VALUES('yl_hash','djfdosp^%&^21313ffsdfsd');
INSERT INTO ylmf_config VALUES('yl_icp','ICP05021225');
INSERT INTO ylmf_config VALUES('yl_icpurl','http://www.miibeian.gov.cn');
INSERT INTO ylmf_config VALUES('yl_ifjump','1');
INSERT INTO ylmf_config VALUES('yl_ipban','');
INSERT INTO ylmf_config VALUES('yl_ipstat','');
INSERT INTO ylmf_config VALUES('yl_ipstates','1');
INSERT INTO ylmf_config VALUES('yl_loadavg','2');
INSERT INTO ylmf_config VALUES('yl_lp','1');
INSERT INTO ylmf_config VALUES('yl_metadescrip','114La,114Laַ,114La,ַ֮,ַȫ,ַ,,,,ͼƬ,СϷ,,,ռ,,K,ͨѶ,BLOG,Ԥ,ʵù.,,໪ʹõ');
INSERT INTO ylmf_config VALUES('yl_metakeyword','114,114La,ַ,,ַ,,,,ͼƬ,,BLOG,ҳҵ¼,114ѯ,ϻҳ');
INSERT INTO ylmf_config VALUES('yl_obstart','1');
INSERT INTO ylmf_config VALUES('yl_proxy','1');
INSERT INTO ylmf_config VALUES('yl_refreshtime','0');
INSERT INTO ylmf_config VALUES('yl_sysname','ֵ[Www.114La.Com] -ֵ');
INSERT INTO ylmf_config VALUES('yl_sysopen','1');
INSERT INTO ylmf_config VALUES('yl_sysurl','http://www.myler.cn');
INSERT INTO ylmf_config VALUES('yl_timedf','8');
INSERT INTO ylmf_config VALUES('yl_isp','1');
INSERT INTO ylmf_config VALUES('yl_mulindex','');
INSERT INTO ylmf_config VALUES('yl_enmemcache','0');
INSERT INTO ylmf_config VALUES('yl_memcacheserver','192.168.1.233');
INSERT INTO ylmf_config VALUES('yl_memcacheport','11211');
INSERT INTO ylmf_config VALUES('yl_sendemail','1');
INSERT INTO ylmf_config VALUES('yl_sendemailtype','0');
INSERT INTO ylmf_config VALUES('yl_fromemail','');
INSERT INTO ylmf_config VALUES('yl_smtpserver','');
INSERT INTO ylmf_config VALUES('yl_smtpport','25');
INSERT INTO ylmf_config VALUES('yl_smtpssl','0');
INSERT INTO ylmf_config VALUES('yl_smtpauth','1');
INSERT INTO ylmf_config VALUES('yl_smtpid','');
INSERT INTO ylmf_config VALUES('yl_smtppass','');
INSERT INTO ylmf_config VALUES('yl_display_update_info','1');
INSERT INTO ylmf_config VALUES('yl_ckdomain','');
INSERT INTO ylmf_config VALUES('yl_path_html','/html');
INSERT INTO ylmf_config VALUES('yl_verify_code','0');
INSERT INTO ylmf_config VALUES('yl_make_html_realtime','0');
INSERT INTO ylmf_config VALUES('yl_dirtplmain','green');

INSERT INTO ylmf_coolclass VALUES('1','С ˵','1','30','wenxue_xiaoshuo/index.htm');
INSERT INTO ylmf_coolclass VALUES('2',' Ϸ','2','28','youxi_wangyou/index.htm');
INSERT INTO ylmf_coolclass VALUES('3',' ','3','25','yinyue_mp3/index.htm');
INSERT INTO ylmf_coolclass VALUES('4',' Ƶ','4','21','kuanpin_yingshi/index.htm');
INSERT INTO ylmf_coolclass VALUES('5',' ','5','26','xiaoyouxi/index.htm');
INSERT INTO ylmf_coolclass VALUES('6',' ','6','31','news/index.htm');
INSERT INTO ylmf_coolclass VALUES('7',' ','7','20','junshi/index.htm');
INSERT INTO ylmf_coolclass VALUES('8',' ','8','21','caijinggushi/index.htm');
INSERT INTO ylmf_coolclass VALUES('9',' ','9','15','mail/index.htm');
INSERT INTO ylmf_coolclass VALUES('10',' ','10','21','soft/index.htm');
INSERT INTO ylmf_coolclass VALUES('11',' ','11','39','wangshanggouwu/index.htm');
INSERT INTO ylmf_coolclass VALUES('12',' ','12','22','love/index.htm');
INSERT INTO ylmf_coolclass VALUES('13','Ů ','13','34','lady/index.htm');
INSERT INTO ylmf_coolclass VALUES('14',' ','14','1','wangshanggouwu/index.htm');
INSERT INTO ylmf_coolclass VALUES('15',' ','15','15','bank/index.htm');
INSERT INTO ylmf_coolclass VALUES('16',' ','16','30','car/index.htm');
INSERT INTO ylmf_coolclass VALUES('17',' ','17','21','shouji/index.htm');
INSERT INTO ylmf_coolclass VALUES('18',' ','18','26','lvyouchuxing/index.htm');
INSERT INTO ylmf_coolclass VALUES('19',' Ƹ','19','27','rencai_zhaopin/index.htm');
INSERT INTO ylmf_coolclass VALUES('20',' ','20','21','tiyu_jianshen/index.htm');
INSERT INTO ylmf_coolclass VALUES('21',' ','21','25','blog/index.htm');
INSERT INTO ylmf_coolclass VALUES('22',' ','22','46','luntan_shequ/index.htm');

INSERT INTO ylmf_coolsite VALUES('1','С˵','http://book.sina.com.cn/?c=spr_web_sq_114la_book_t001','1','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('2','','http://www.qidian.com/','1','2','0','0','0','47','4062533','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('3','','http://www.hongxiu.com/?114la','1','3','0','0','0','0','1855053','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('4','ݺС˵','http://www.zongheng.com/?CO=114la','1','4','0','0','0','0','8046','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('5','txtС˵','http://www.txtbbs.com/','1','5','0','0','0','0','1352778','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('6','С˵','http://www.15.net/','1','6','0','0','0','41','625','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('7','С˵','http://www.xs8.cn/','1','7','0','0','0','91','2374969','','0','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('8','С˵Ķ','http://www.readnovel.com','1','100','0','0','0','68','5017433','','0','5','1269878400','1269878400','','0');
INSERT INTO ylmf_coolsite VALUES('9','Ժ','http://www.xxsy.net/','1','101','0','0','0','37','51277','','2','1','1269964800','1269964800','','0');
INSERT INTO ylmf_coolsite VALUES('10','һѧ','http://stat.lm.17k.com/rd?_u=aHR0cDovL2Jvb2suMTdrLmNvbQ==&_t=1224835092&_f=0&p=13&a=733&m=1989&ft=1&_s=d57a39dff820c1ec12488df73d2190e4','1','102','0','0','0','0','20202','#178517','0','0','1222790400','1222790400','','0');
INSERT INTO ylmf_coolsite VALUES('11','ԭ','http://vip.book.sina.com.cn/','1','103','0','0','0','24','749079','','0','2','1225468800','1225468800','','0');
INSERT INTO ylmf_coolsite VALUES('12','˶','http://sina.allyes.com/main/adfclick?db=sina&bid=142796,180416,185386&cid=0,0,0&sid=172968&advid=3406&camid=24434&show=ignore&url=http://book.sina.com.cn/','1','104','0','0','0','0','5','','0','0','1230739200','1230739200','','0');
INSERT INTO ylmf_coolsite VALUES('13','С˵','http://www.zhulang.com/','1','105','0','1','1','33','1115944','','2','0','1262275200','1262275200','','0');
INSERT INTO ylmf_coolsite VALUES('14','4399СϷ','http://www.4399.com/','2','1','0','0','0','642','19658140','','8','11','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('15','17173','http://www.17173.com/','2','2','0','0','0','168','3960564','','2','4','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('16','Ħׯ԰','http://www.51mole.com/','2','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('17','ٶϷ','http://youxi.baidu.com/pm.xhtml?pid=11003800236_775910','2','4','0','0','0','85','124','#FF0130','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('18','','http://www.unionli.com/txlink.php?alid=23792','2','3','0','0','0','0','1888181','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('19','','http://member.198game.com/sz/count.php?adid=1064','2','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('21','ս','http://wan.115.com/tg.php?g=22&c=114la','5','7','0','0','0','0','38','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('22','̸','http://jh.uume.com/in/114la.php','2','101','0','0','0','0','22115','','0','0','1259596800','1259596800','','0');
INSERT INTO ylmf_coolsite VALUES('23','ҵ','http://www.uwan.com/Special/090626/default.htm?From=114lacom','2','102','0','0','0','0','0','#178517','0','0','1269360000','1269360000','','0');
INSERT INTO ylmf_coolsite VALUES('24','','http://allyes.the9.com/main/c?db=the9afa&bid=87383,42465,224&cid=33109,519,1&sid=85382&show=ignore&url=http://wof.the9.com/','2','103','0','0','0','0','0','','0','0','1265299200','1265299200','','0');
INSERT INTO ylmf_coolsite VALUES('25','','http://member.198game.com/ad/count.php?adid=1020','2','104','0','0','0','0','0','#178517','0','0','1264953600','1264953600','','0');
INSERT INTO ylmf_coolsite VALUES('26','Ϸ','http://www.hezi.com/','2','105','0','0','0','0','0','','0','0','1251734400','1251734400','','0');
INSERT INTO ylmf_coolsite VALUES('27','ս','http://kz.zqgame.com/index02.htm?ad=s5uz19b6&rcc_id=ccc4a7427f6c8c4e2adf55067b1c4b79','2','106','0','0','0','0','1455354','','0','0','1264953600','1264953600','','0');
INSERT INTO ylmf_coolsite VALUES('28','μ','http://xy.linekong.com/adCount.php?mid=1002130001','2','107','0','0','0','0','107','','0','0','1269878400','1269878400','','0');
INSERT INTO ylmf_coolsite VALUES('29','3839СϷ','http://www.3839.com/','2','108','0','0','0','0','0','','0','0','1276012800','1276012800','','0');
INSERT INTO ylmf_coolsite VALUES('30','ȸ','http://www.google.cn/music/homepage','0','1','0','0','0','90','3730224','','0','3','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('31','һ','http://www.1ting.com/','3','2','0','0','0','0','1033048','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('32','','http://www.kuwo.cn/114la/index.htm','3','3','0','0','0','0','3','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('33','A8','http://www.a8.com/','3','4','0','0','0','0','3807160','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('34','޾','http://www.top100.cn/','3','5','0','0','0','57','2029198','','1','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('35','ṷ','http://www.kugou.com/2219/','3','6','0','0','0','0','202660','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('36','ٶMP3','http://mp3.baidu.com/m?ie=utf-8&ct=134217728&word=&tn=ylmf_1_pg','3','7','0','0','0','0','190115','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('37','','http://www.haoting.com/','3','101','0','0','0','134','7307050','','9','1','1230739200','1230739200','','0');
INSERT INTO ylmf_coolsite VALUES('38','ѹ','http://music.sogua.com/','3','102','0','0','0','4','3226089','','0','0','1230739200','1233504000','','0');
INSERT INTO ylmf_coolsite VALUES('39','A8','http://www.a8.com/?uid=114','3','102','0','0','0','0','0','','0','0','1274371200','1277136000','','0');
INSERT INTO ylmf_coolsite VALUES('40','ȸ','http://www.google.cn/music/homepage','3','1','0','0','0','0','1638184','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('41','','http://www.tudou.com/','4','1','0','1','1','598','10771208','','22','16','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('42','ո','http://www.qiyi.com/','4','2','0','0','0','30','4935241','','1','2','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('43','PPTV','http://www.pptv.com/?rcc_id=831597960e40534af11b8d19426f39f9','4','3','0','0','0','683','21083627','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('44','Ƶ','http://video.sina.com.cn/?c=spr_web_sq_114la_video_t001','4','4','0','0','0','0','559436','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('45','Ѻ','http://c.ourclick.net/goto.html?t=17&ct=20&p=161&url=http%3A%2F%2Ftv.sohu.com%2Fhdtv','4','5','0','0','0','0','3930','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('46','еӰ','http://www.funshion.com/?alliance=70903','4','6','0','0','0','0','2152432','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('48','TOM365ѵӰ','http://www.tom365.com/?kz','0','8','0','0','0','0','4486591','#178517','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('49','TOM365ѵӰ','http://www.tom365.com/','4','7','0','0','0','0','26294','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('50','ѺƵ','http://video.sohu.com','4','101','0','0','0','4','242157','','0','0','1233417600','1233417600','','0');
INSERT INTO ylmf_coolsite VALUES('51','ѺƵ','http://tv.sohu.com/hdtv/','4','102','0','0','0','0','324390','','0','0','1257004800','1257004800','','0');
INSERT INTO ylmf_coolsite VALUES('52','ٶƵ','http://video.baidu.com/?tn=ylmf_4_pg','4','103','0','0','0','0','361482','','0','0','1275408000','1275408000','','0');
INSERT INTO ylmf_coolsite VALUES('53','6676Ӱ糡','http://www.6676.com/','4','104','0','0','0','13','66631','','0','0','1259596800','1259596800','','0');
INSERT INTO ylmf_coolsite VALUES('54','4399СϷ','http://www.4399.com/','5','1','0','0','0','217','1998652','','5','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('55','7k7kСϷ','http://www.7k7k.com/','5','2','0','1','1','593','15309','green','3','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('56','','http://www.51seer.com/','5','3','0','0','0','0','1555816','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('57','3366Ϸ','http://www.junyilm.com/1031/catcon.asp?patat=64%2C5962','5','4','0','0','0','0','36','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('58','λ','http://www.unionli.com/txlink.php?alid=24662','2','6','0','0','0','0','337','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('59','3887СϷ','http://www.3887.com/','5','5','0','0','0','0','3632206','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('60','','http://www.unionli.com/txlink.php?alid=23793','5','6','0','0','0','0','10949','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('61','','http://www.unionli.com/txlink.php?alid=23792','5','100','0','0','0','0','11760','','0','0','1287849600','1287849600','','0');
INSERT INTO ylmf_coolsite VALUES('62','ħ','http://junnew.com/57/hit.asp?patat=64%2C5962','5','101','0','0','0','0','0','','0','0','1262275200','1262275200','','0');
INSERT INTO ylmf_coolsite VALUES('63','265GϷ','http://www.265g.com/','5','102','0','0','0','0','0','','0','0','1243785600','1243785600','','0');
INSERT INTO ylmf_coolsite VALUES('64','','http://cps.gamall.net/?1=4f7b3a3214d63c51d4c047f729815440','5','103','0','0','0','0','0','','0','0','1267632000','1267632000','','0');
INSERT INTO ylmf_coolsite VALUES('65','','http://news.sina.com.cn/','6','1','0','5','5','245','6027391','','7','7','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('66','','http://www.people.com.cn/','6','2','0','0','0','0','115198','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('67','Ż','http://news.cn.yahoo.com/?id=40020','6','3','0','0','0','43','1024397','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('68','Ѻ','http://news.sohu.com/','6','4','0','3','3','126','2348435','','2','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('69','','http://news.163.com/','6','5','0','1','1','136','1204177','','2','2','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('70','','http://www.huanqiu.com/','6','6','0','0','0','0','888784','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('71','Ѷ','http://news.qq.com/','6','8','0','1','1','65','888985','','2','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('72','','http://www.daqi.com/','0','9','0','0','0','0','530928','','0','0','1291564800','1291564800','','0');
INSERT INTO ylmf_coolsite VALUES('73','л','http://military.china.com/','7','1','0','1','1','278','4049121','','2','5','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('74','Ѫ','http://www.tiexue.net/','7','2','0','1','1','226','2793908','','6','3','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('75','','http://mil.huanqiu.com/','7','3','0','5','5','198','2189553','','6','4','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('76','˾','http://mil.news.sina.com.cn/','7','4','0','4','4','220','2848322','','6','5','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('77','','http://news.ifeng.com/mil/','7','5','0','1','1','247','1782750','','10','9','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('78','й','http://www.chinamil.com.cn/','7','6','0','0','0','70','969260','','1','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('79','ս','http://www.chinaiiss.org/','7','7','0','0','0','81','783767','','2','4','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('80','Ƹ','http://www.eastmoney.com/','8','1','0','1','1','159','3267837','','1','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('81','Ѷƾ','http://finance.qq.com/','8','2','0','0','0','0','468234','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('82','ڽ','http://www.jrj.com/?from=90005','8','3','0','0','0','0','0','red','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('83','˲ƾ','http://finance.sina.com.cn/','8','4','0','3','3','213','2098268','','4','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('84','֤ȯ֮','http://www.stockstar.com/','8','5','0','0','0','0','2006228','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('85','Ѷƾ','http://www.hexun.com/','8','6','0','0','0','0','148550','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('86','н','http://www.cnfol.com/','8','7','0','2','2','140','572739','','2','2','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('87','ƾ','http://www.caijing.com.cn','8','10','0','0','0','0','1077366','','0','0','1289232000','1289232000','','0');
INSERT INTO ylmf_coolsite VALUES('88','ɳ','http://www.gucheng.com/','8','101','0','0','0','0','0','#178517','0','0','1249056000','1249056000','','0');
INSERT INTO ylmf_coolsite VALUES('89','Ӣʱ','http://www.ftchinese.com/users/goto?ccode=2G091070&pageurl=http%3A%2F%2Fwww.ftchinese.com%2F','8','102','0','0','0','0','0','','0','0','1262275200','1262275200','','0');
INSERT INTO ylmf_coolsite VALUES('90','','http://fund.eastmoney.com/','8','103','0','0','0','0','0','','0','0','1266768000','1269360000','','0');
INSERT INTO ylmf_coolsite VALUES('91','Ӫ','http://www.heimaying.com','8','104','0','0','0','0','640997','#178517','0','0','1262275200','1262275200','','0');
INSERT INTO ylmf_coolsite VALUES('92','Ӣʱ','http://www.ftchinese.com/users/goto?ccode=2G091070&pageurl=http%3A%2F%2Fwww.ftchinese.com%2F','8','105','0','0','0','0','426193','','0','0','1265040000','1266681600','','0');
INSERT INTO ylmf_coolsite VALUES('93','163','http://email.163.com/','9','1','0','0','0','0','5435853','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('94','126','http://www.126.com/','9','2','0','0','0','151','4234952','','3','2','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('95','QQ','http://mail.qq.com/','9','3','0','0','0','0','24','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('96','','http://mail.sina.com.cn/','9','4','0','1','1','73','1295140','','1','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('97','Ż','http://mail.cn.yahoo.com/','9','5','0','0','0','0','2236558','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('98','Hotmail','http://www.hotmail.com/','9','6','0','0','0','0','253891','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('99','GMail','http://www.gmail.com/','9','7','0','1','1','107','199303','','0','3','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('100','139','http://mail.139.com/','9','8','0','0','0','0','339388','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('101','IT168','http://www.it168.com/','10','0','0','0','0','0','4893','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('102','̫ƽ','http://www.pconline.com.cn/','10','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('103','йش','http://www.zol.com.cn/','10','2','0','0','0','0','812505','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('104','ɫذ','http://www.xiazaiba.com/','10','3','0','0','0','0','2196291','green','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('105','','http://www.skycn.com/index.html','10','4','0','0','0','9','1702285','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('106','','http://www.pcpop.com/','10','6','0','0','0','0','312767','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('107','֮','http://www.mydrivers.com/','10','7','0','0','0','6','444341','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('108','','http://www.crsky.com/','10','8','0','0','0','15','55','','0','1','1277222400','1277654400','','0');
INSERT INTO ylmf_coolsite VALUES('109','԰','http://www.newhua.com/index.htm','10','100','0','0','0','1','420751','','0','0','1235836800','1235836800','','0');
INSERT INTO ylmf_coolsite VALUES('110','IT168','http://software.it168.com/','10','101','0','0','0','0','0','','0','0','1267545600','1270137600','','0');
INSERT INTO ylmf_coolsite VALUES('111','Ƿ','http://www.crsky.com/','10','102','0','0','0','0','637040','','0','0','1275408000','1275408000','','0');
INSERT INTO ylmf_coolsite VALUES('112','ͷ','http://s.click.taobao.com/t_11?e=%2BtSC5ziSlQIKXTum23VHLUx2Mi9BvFxTCg7CN9kKD8HJdox0eUoImgi5Ng%3D%3D&p=mm_14033530_3168968_10561464
','11','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('113','׿Խ','http://www.amazon.cn/?_encoding=UTF8&tag=ymx0d-23&linkCode=ur2&camp=536&creative=3200','11','1','0','0','0','0','307558','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('114','ΨƷۿ','http://p.yiqifa.com/c?s=5763f9c0&w=217523&c=4566&i=6222&l=0&e=ֵ&t=http://www.vipshop.com/index.php','11','6','0','0','0','0','1','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('115','̳','http://p.yiqifa.com/c?s=368a4a7c&w=217523&c=4509&i=5862&l=0&e=114la&t=http://www.360buy.com','11','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('116','','http://p.yiqifa.com/c?s=fd2887ec&w=217523&c=4275&i=4662&l=0&e=114la&t=http://www.m18.com','11','3','0','0','0','0','4','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('117','','http://p.yiqifa.com/c?s=f41a1f6a&w=217523&c=1085&i=724&l=0&e=114la&t=http://www.ihush.com/index.php','11','7','0','0','0','0','24185','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('118','캢','http://p.yiqifa.com/c?s=0a30a42c&w=217523&c=249&i=148&l=0&e=114la&t=http://www.redbaby.com.cn','11','100','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('119','','http://www.dangdang.com/?_ddclickunion=P-308772|ad_type=10|sys_id=1#dd_refer=http%3A%2F%2Fwww.myler.cn%2F','11','2','0','0','0','0','520130','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('120','Ʒ','http://go.all4ad.cn/jump.aspx?locid=313','11','101','0','0','0','0','0','','0','0','1249056000','1249056000','','0');
INSERT INTO ylmf_coolsite VALUES('121','No5ױƷ','http://www.no5.com.cn/?from=114','11','102','0','0','0','0','26','','0','0','1257177600','1257177600','','0');
INSERT INTO ylmf_coolsite VALUES('122','eSTREETװ','http://a1119.oadz.com/link/C/1119/437/rKrDVdJ1bVWj0gFCjNCW4kwHJqw_/a/59/http://www.estreet.cn/?from=114la','11','103','0','0','0','0','1976996','','0','0','1268409600','1268496000','','0');
INSERT INTO ylmf_coolsite VALUES('123','ʱŮװ','http://www.shishangqiyi.com/Union/flow_zz.asp?lid=355&m_id=&gourl=','11','104','0','0','0','0','9418','','0','0','1265126400','1265126400','','0');
INSERT INTO ylmf_coolsite VALUES('124','ͼԵ','http://www.jiayuan.com/st/?id=3985&url=http://www.jiayuan.com/register','12','1','0','0','0','0','209830','red','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('125','䰮','http://love.zhenai.com/901001.html','12','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('126','Ե','http://www.juyuan.com/reg/reg03index.xhtml?type=11','12','3','0','0','0','0','5','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('127','ٺ','http://www.baihe.com/?policy=1&Channel=zyzt-wzz&Code=140026-114la','12','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('128','','http://www.7651.com/reg/index.html?wf=114la&st=lmm&sid=&66vv.com','12','5','0','0','0','0','302831','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('129','100','http://spcode.baidu.com/spcode/spClick?tn=ylmf_sp&ctn=0&styleid=3959&tourl=http://www.juedui100.com/jueduiJumpResource/8959?prodid=90','12','6','0','0','0','0','516152','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('130','','http://www.renren.com/?ss=17043&rt=2&g=114la','12','7','0','0','0','0','374247','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('131','Ե','http://www.liangyuan520.com/','12','100','0','0','0','0','104597','','0','0','1289664000','1289664000','','0');
INSERT INTO ylmf_coolsite VALUES('132','58ͬǽ','http://go.58.com/?adSys=20&AdCode=2029&adPage=http://www.58.com/nvyou/','12','100','0','0','0','0','31811','','0','0','1270828800','1270828800','','0');
INSERT INTO ylmf_coolsite VALUES('133','ǿ','http://www.xingkong.com/','12','101','0','0','0','0','1228813','','0','0','1259596800','1259596800','','0');
INSERT INTO ylmf_coolsite VALUES('134','100','http://p.yiqifa.com/servlet/handleClick?sid=effaa3a9a5bdb6f5&pid=831&wid=2498&vid=613&cid=248&lid=0&euid=&turl=http%3A%2F%2Fwww.juedui100.com%2Freg.jsp%3Fsid%3D%3C%252%25%3E%26aid%3D22&vwid=','12','103','0','0','0','0','322071','','0','0','1259596800','1259596800','','0');
INSERT INTO ylmf_coolsite VALUES('135','100','http://p.yiqifa.com/servlet/handleClick?sid=effaa3a9a5bdb6f5&pid=831&wid=2498&vid=613&cid=248&lid=0&euid=&turl=http%3A%2F%2Fwww.juedui100.com%2Freg.jsp%3Fsid%3D%3C%252%25%3E%26aid%3D22&vwid=','12','104','0','0','0','0','5','','0','0','1259596800','1259596800','','0');
INSERT INTO ylmf_coolsite VALUES('136','','http://www.marry5.com/?p=7509','12','105','0','0','0','0','5','#178517','0','0','1269446400','1269446400','','0');
INSERT INTO ylmf_coolsite VALUES('137','䰮','http://love.zhenai.com/901001.html','12','106','0','0','0','0','618170','','0','0','1269964800','1269964800','','0');
INSERT INTO ylmf_coolsite VALUES('138','Ů','http://www.27.cn/','13','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('139','ʱ','http://www.mishang.com/','13','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('140','Ů','http://www.4738.com/?114la','13','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('141','YOKAʱ','http://www.yoka.com/','13','4','0','0','0','0','5','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('142','Ů','http://www.rayli.com.cn/?114la','13','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('143','VOGUEʱ','http://cnrdn.com/rd.htm?id=1005224&r=http%3A%2F%2Fwww.vogue.com.cn','13','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('144','üSELF','http://cnrdn.com/rd.htm?id=1005231&r=http%3A%2F%2Fwww.self.com.cn','13','8','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('145','ELLEŮ','http://www.ellechina.com/','13','100','0','0','0','0','0','','0','0','1272902400','1275580800','','0');
INSERT INTO ylmf_coolsite VALUES('146','Ա','http://www.taobao.com/go/chn/tbk_channel/channelcode.php?pid=mm_14033530_3168968_10472364&eventid=101329
','14','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('147','һŵ','http://s.click.taobao.com/t_11?e=%2BtSC5ziSlHPn2KeJMhhJbsldWfV6oeO4H5ymIt%2FCkol6sjcJDrF11IBQVx%2B2TRc%3D&p=mm_14033530_3168968_10479839
','14','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('148','캢̳','http://p.yiqifa.com/c?s=0a30a42c&w=217523&c=249&i=148&l=0&e=114la&t=http://www.redbaby.com.cn','14','5','0','0','0','0','483701','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('149','Ʒۿ','http://p.yiqifa.com/c?s=4fa69d79&w=217523&c=4411&i=5362&l=0&e=114la&t=http://www.fclub.cn','14','3','0','0','0','0','325659','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('150','׹','http://p.yiqifa.com/c?s=2cf837ba&w=217523&c=4459&i=5662&l=0&e=114la&t=http://www.suning.cn/webapp/wcs/stores/servlet/TopCategoriesDisplayView?storeId=10052&catalogId=10051','14','4','0','0','0','0','310062','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('151','','http://p.yiqifa.com/c?s=79f386af&w=217523&c=4220&i=4482&l=0&e=114la&t=www.lamiu.com','14','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('152','Ա','http://www.taobao.com/go/chn/tbk_channel/channelcode.php?pid=mm_14033530_3168968_10472364&eventid=101329
','0','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('153','Ա','http://www.taobao.com/go/chn/tbk_channel/channelcode.php?pid=mm_14033530_3168968_10472364&eventid=101329
','14','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('154','Ա˶','http://s.click.taobao.com/t_9?p=mm_14033530_0_0&l=http%3A%2F%2Flist.tmall.com%2Fsearch_product.htm%3Fspm%3D3.1000473.225938.8%26TBG%3D97995.146926.14%26start_price%3D90%26cat%3D50020894%26sort%3Dst%26style%3Dg%26vmarket%3D0%26prt%3D1319506291995%26prc%3D1','14','101','0','0','0','0','0','','0','0','1262275200','1262275200','','0');
INSERT INTO ylmf_coolsite VALUES('155','ȤҾ','http://www.quwan.com/goto.php?goto=index1.html&quwanlianmeng=114la&argv2=shangcheng','14','102','0','0','0','0','0','#178517','0','0','1270310400','1270310400','','0');
INSERT INTO ylmf_coolsite VALUES('156','ʯС','http://zbirdafa7.allyes.com/main/adfclick?db=zbirdafa7&bid=3195,1011,50&cid=1372,13,1&sid=2392&show=ignore&url=http://www.zbird.com/?utm_source=114lashangcheng&utm_medium=cpm','14','104','0','0','0','0','517787','#178517','0','0','1270656000','1270656000','','0');
INSERT INTO ylmf_coolsite VALUES('157','','http://www.cmbchina.com/','15','1','0','1','1','9','238646','','0','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('158','','http://www.icbc.com.cn/','15','2','0','0','0','53','606822','','2','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('159','','http://www.ccb.com/','15','3','0','2','2','31','803906','','1','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('160','й','http://www.boc.cn/','15','4','0','0','0','28','548031','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('161','ũҵ','http://www.abchina.com/','15','5','0','0','0','41','494665','','1','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('162','㷢','http://www.gdb.com.cn/','15','6','0','0','0','9','110577','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('163','й','http://www.chinaunionpay.com/','15','7','0','0','0','5','80270','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('164','֮','http://www.autohome.com.cn/','16','1','0','1','1','220','641710','','10','7','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('165','','http://www.xcar.com.cn/?114la','16','2','0','0','0','0','7663','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('166','','http://www.cheshi.com/','16','3','0','0','0','0','3424378','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('167','Ѻ','http://auto.sohu.com/?p=b5ed082ba0','16','4','0','0','0','0','651709','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('168','','http://auto.sina.com.cn/?c=spr_web_sq_114la_auto_t001','16','5','0','0','0','0','1298850','green','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('169','168','http://www.che168.com/','16','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('170','ſֳ','http://www.ucar.cn/?1214','16','7','0','0','0','0','0','red','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('171','׳','http://www.bitauto.com/?WT.mc_id=114la','16','8','0','0','0','0','479051','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('172','TOM','http://auto.tom.com/','16','100','0','0','0','46','435853','','1','1','1246377600','1246377600','','0');
INSERT INTO ylmf_coolsite VALUES('173','ݳչ','http://jump.all4ad.cn/jump.aspx?id=658','16','101','0','0','0','0','0','','0','0','1257004800','1257004800','','0');
INSERT INTO ylmf_coolsite VALUES('174','̫ƽֻ','http://mobile.pconline.com.cn/','17','1','0','1','1','24','1056177','','0','2','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('175','ֻ','http://mobile.pcpop.com/','17','4','0','0','0','0','315842','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('176','155ֻϷ','http://www.155.cn/','17','5','0','0','0','0','0','green','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('177','It168ֻ','http://mobile.it168.com/','17','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('178','ֻ','http://as.kejet.com/afaclick?u/NzM0RTg0N0NDQUY5NTg4/o/N0E0QjAxMkJCMzU3RDM0/m/RDM3ODM4RDk1Rjc2MEZG?http://www.hicdma.com/index.html?_kw=925b8ade5867ff5c87f7d463f848752b&_atype=15&utm_source=referer&utm_medium=%E5%A4%96%E9%83%A8%E9%93%BE%E6%8E%A5','17','8','0','0','0','0','429449','','0','0','1294848000','1294848000','','0');
INSERT INTO ylmf_coolsite VALUES('179','ֻƵ','http://digi.tech.qq.com/mobile/','17','3','0','0','0','0','997935','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('180','Ѻֻ','http://digi.it.sohu.com/mobile.shtml','17','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('181','3533ֻ','http://www.3533.com/phone','17','100','0','0','0','6','382206','','0','0','1230739200','1230739200','','0');
INSERT INTO ylmf_coolsite VALUES('182','ֻ','http://mobile.pcpop.com/','17','101','0','0','0','9','269490','','1','0','1246377600','1246377600','','0');
INSERT INTO ylmf_coolsite VALUES('183','׽ֻ','http://www.joyes.com/','17','102','0','0','0','2','187698','','0','0','1238515200','1238515200','','0');
INSERT INTO ylmf_coolsite VALUES('184','ѶƱ','http://jipiao.kuxun.cn/?fromid=Klh-S1134481-T1139361','18','1','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('185','39','http://www.39.net/','18','2','0','0','0','0','72023','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('186','Я','http://www.ctrip.com/smartlink/smartlink.asp?c=114la','18','3','0','0','0','0','263612','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('187','','http://www.aifang.com/?utm_source=NAVI-114la-KZ&utm_medium=CPC&pi=NAVI-114la-KZ','18','4','0','0','0','0','127128','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('188','DaoDao','http://www.daodao.com/DealsHome?m=13241','18','5','0','0','0','0','0','green','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('190','̫ƽҾ','http://www.pchouse.com.cn/','18','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('191','58δȫ','http://go.58.com/?adSys=20&AdCode=2029&adPage=http://www.58.com/lvyou/','18','100','0','0','0','0','0','','0','0','1270828800','1270828800','','0');
INSERT INTO ylmf_coolsite VALUES('192','ؼ۾ƵԤ','http://www.expotia.com/','18','101','0','0','0','0','108447','#178517','0','0','1257177600','1257177600','','0');
INSERT INTO ylmf_coolsite VALUES('193','ͨ','http://www.51766.com/','18','102','0','0','0','3','123414','','2','0','1262275200','1262275200','','0');
INSERT INTO ylmf_coolsite VALUES('194',';','http://www.lotour.com/','18','103','0','0','0','3','86890','','0','0','1264867200','1264867200','','0');
INSERT INTO ylmf_coolsite VALUES('195','9766','http://www.9766.com/','18','104','0','0','0','2','91362','','2','0','1243785600','1243785600','','0');
INSERT INTO ylmf_coolsite VALUES('196','ѶؼۻƱ','http://jipiao.kuxun.cn/?fromid=114laMf2','18','105','0','0','0','0','714','','0','0','1269705600','1269705600','','0');
INSERT INTO ylmf_coolsite VALUES('197','ǰ','http://jump.all4ad.cn/jump.aspx?id=334','19','1','0','0','0','0','507562','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('198','лӢ','http://stbnnr.allyes.com/bnnr/114laxin_hr.html','19','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('199','Ƹ','http://www.baixing.com/?bannerId=281&profile=job','19','3','0','0','0','0','326833','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('200','й˲','http://www.cjol.com/','19','4','0','0','0','5','226970','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('201','˽','http://www.zhubajie.com/','19','5','0','0','0','0','140189','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('202','Ƹ','http://www.zhaopin.com/','19','6','0','2','2','3','481529','','0','0','1285776000','1285776000','','0');
INSERT INTO ylmf_coolsite VALUES('203','58Ƹ','http://www.58.com/?path=ad8.shtml','19','7','0','0','0','0','144789','','0','0','1287936000','1287936000','','0');
INSERT INTO ylmf_coolsite VALUES('204','Ϸ˲','http://www.job168.com/','19','100','0','0','0','0','0','','0','0','1251734400','1251734400','','0');
INSERT INTO ylmf_coolsite VALUES('237','115Ȧ','http://q.115.com/','22','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('238','Ჩ','http://qing.sina.com.cn/','21','7','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('206','','http://sports.sina.com.cn/','20','1','0','0','0','137','3193577','','1','3','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('207','Ѻ','http://sports.sohu.com/','20','2','0','0','0','138','1412712','','2','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('208','','http://sports.163.com/','20','3','0','0','0','48','728677','','3','4','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('209','̳','http://sports.tom.com/','20','5','0','0','0','5','632471','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('210','NBA','http://china.nba.com/','20','6','0','0','0','38','983716','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('211','Ż','http://sports.cn.yahoo.com/index.html?f=E114_3_1','20','7','0','0','0','3','346474','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('212','2010籭','http://sina.allyes.com/main/adfclick?db=sina&bid=191950,239011,244034&cid=0,0,0&sid=234113&advid=3406&camid=34760&show=ignore&url=http://2010.sina.com.cn/?c=spr_web_sq_114la_worldcup_t001','20','104','0','0','0','0','298955','green','0','0','1279123200','1279209600','','0');
INSERT INTO ylmf_coolsite VALUES('213','QQռ','http://qzone.qq.com/','21','1','0','0','0','197','280600','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('214','˲','http://blog.sina.com.cn/','21','2','0','0','0','18','869997','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('215','ײ','http://blog.163.com/','21','3','0','0','0','0','247562','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('216','Ѻ','http://blog.sohu.com/','21','4','0','0','0','4','356953','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('217','΢','http://t.sina.com.cn/?c=spr_web_sq_114la_weibo_t001','21','5','0','0','0','0','131969','#FF286B','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('218','ٶȿռ','http://hi.baidu.com/','21','6','0','0','0','24','386998','','0','5','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('219','139˵','http://jump.all4ad.cn/jump.aspx?id=676','21','100','0','0','0','0','145945','','0','0','1264953600','1264953600','','0');
INSERT INTO ylmf_coolsite VALUES('220','ٶ','http://tieba.baidu.com/?fr=114la','22','1','0','0','0','0','510154','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('221','','http://www.tianya.cn/','22','2','0','0','0','35','1015357','','1','1','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('222','̳','http://bbs.ifeng.com','22','3','0','0','0','11','456478','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('223','ѺȦ','http://q.sohu.com/','22','4','0','0','0','0','3108','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('224','è','http://tt.mop.com/','22','5','0','0','0','25','762416','','1','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('225','ľ̳','http://bbs.ylmf.net/','22','6','0','0','0','0','139635','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('229','ҵĿ','http://www.89178.com/203.htm','23','1','0','0','0','0','0','green','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('230','ҵ̻','http://www.78.cn/226.htm','23','2','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('231','1000Ԫ','http://www.7808.cn/?site=114la','23','3','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('232','ҵ껪','http://www.79.cn/','23','4','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('233','3158¸','http://www.3158.cn/?site=114la','23','5','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('234','¸Ŀ','http://www.875.cn/','23','6','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('235','Сҵ','http://gb.36578.com/gbook_admin/getgo.php?id=3440','23','8','0','0','0','0','0','','0','0','1277827200','1278259200','','0');
INSERT INTO ylmf_coolsite VALUES('236','ٶ˲','http://rencai.baidu.com/servlet/ADMSU?sid=114la&site=114lakz&url=http%3A%2F%2Frencai.baidu.com&tokenstr=3673103c7da44cec9d9a2ee60061cf45','19','8','0','0','0','0','0','','0','0','0','0','','0');
INSERT INTO ylmf_coolsite VALUES('239','','http://music.kukaka.org/','3','1','0','0','0','0','0','','0','0','0','0','','0');

INSERT INTO ylmf_index_tool VALUES('1','ʵòѯ','http://myler.cn/public/widget/tools/','1','');
INSERT INTO ylmf_index_tool VALUES('2','WIN8浼','http://www.myler.cn/metro/index.html','2','#FF0000');
INSERT INTO ylmf_index_tool VALUES('3','Ӿ','http://www.iqiyi.com/dianshiju/','3','');
INSERT INTO ylmf_index_tool VALUES('4','鹫Ԣ3','http://www.iqiyi.com/dianshiju/aqgy3.html','4','#FF0000');
INSERT INTO ylmf_index_tool VALUES('5',' Ӱ','http://www.iqiyi.com/dianying/','5','');
INSERT INTO ylmf_index_tool VALUES('6','Ӱȫ','http://www.iqiyi.com/dianying/qlmovie.html','6','');
INSERT INTO ylmf_index_tool VALUES('7',' ','http://www.myler.cn/html/yinyue_mp3/','7','');
INSERT INTO ylmf_index_tool VALUES('8','ṷ߲','http://web.kugou.com/default.html','8','#FF0000');
INSERT INTO ylmf_index_tool VALUES('9','СϷ','http://www.myler.cn/html/xiaoyouxi/index.htm','9','');
INSERT INTO ylmf_index_tool VALUES('10','ѯ','http://kaijiang.500wan.com/','10','#FF0000');
INSERT INTO ylmf_index_tool VALUES('11',' ','http://www.myler.cn/html/wangshanggouwu/','11','');
INSERT INTO ylmf_index_tool VALUES('12','Աۻ','http://ju.taobao.com/tg/item_list.htm?spm=608.1000525.0.37&type=0&ali_trackid=2:mm_14033530_0_0:1343020663_3z7_768316890','12','#FF0000');
INSERT INTO ylmf_index_tool VALUES('13',' Ʊ','http://www.myler.cn/html/caijinggushi/index.htm','13','');
INSERT INTO ylmf_index_tool VALUES('14','3366СϷ','http://www.3366.com/','14','#FF0000');
INSERT INTO ylmf_index_tool VALUES('15',' ','http://meituan.com','15','');
INSERT INTO ylmf_index_tool VALUES('16','ۻ㾫ѡ','http://www.taobao.com/go/chn/tbk_channel/jkwt.php?pid=mm_10236639_2136876_9531742&eventid=102405','16','#FF0000');


INSERT INTO ylmf_ipstates VALUES('2009-6-26','2009-6','8','8','0','8');


INSERT INTO ylmf_links VALUES('44','1','10','115Ȧ','http://q.115.com/','1312263463','');
INSERT INTO ylmf_links VALUES('40','1','7','ֵ','http://union.114la.com/','1312263350','');
INSERT INTO ylmf_links VALUES('41','1','9','YLMF̳','http://bbs.ylmf.net/','1312263367','');
INSERT INTO ylmf_links VALUES('42','1','10','115','http://u.115.com/','1312263384','');
INSERT INTO ylmf_links VALUES('39','1','6','115','http://ie.115.com/','1312263330','');
INSERT INTO ylmf_links VALUES('37','1','4','ľϵͳŻ','http://www.ylmf.net/','1312263297','');
INSERT INTO ylmf_links VALUES('38','1','5','Ylmf OS','http://www.ylmf.org/','1312263313','');
INSERT INTO ylmf_links VALUES('36','1','3','ذ','http://www.xiazaiba.com/','1312263281','');
INSERT INTO ylmf_links VALUES('35','1','2','116','http://116.com/','1312263265','');
INSERT INTO ylmf_links VALUES('34','1','1','ֵַ','http://www.myler.cn/','1312263248','');
INSERT INTO ylmf_links VALUES('43','1','11','ֵԴ','http://www.mfzy.net/','1312263416','');

INSERT INTO ylmf_mingzhan VALUES('1','йŻ','http://cn.yahoo.com/?id=40020','','108','1235836800','1235836800','','0','3','4','8689897','8689897','8689897','0');
INSERT INTO ylmf_mingzhan VALUES('2','','http://www.chinanews.com.cn/','','112','1259596800','1259596800','','0','8','7','17370974','17370974','17370974','0');
INSERT INTO ylmf_mingzhan VALUES('3','ȸ','http://www.google.com.hk/webhp?prog=aff&client=pub-0194889602661524&channel=9868925125','','1','0','0','','0','0','0','8147298','8147298','8147298','0');
INSERT INTO ylmf_mingzhan VALUES('4','  ','http://www.huanqiu.com/','','4','0','0','','2','7','11','2562268','2562268','2562268','0');
INSERT INTO ylmf_mingzhan VALUES('5','  ','http://www.youku.com/','','9','0','0','','0','1','1','2219843','2219843','2219843','0');
INSERT INTO ylmf_mingzhan VALUES('7','̨','http://www.cntv.cn/index.shtml','','5','0','0','','0','0','0','21466545','21466545','21466545','0');
INSERT INTO ylmf_mingzhan VALUES('8','  ','http://www.ifeng.com/','','2','0','0','','12','34','22','3871813','3871813','3871813','0');
INSERT INTO ylmf_mingzhan VALUES('9','  ','http://www.renren.com/?114la','','7','0','0','','0','0','0','7280258','7280258','7280258','0');
INSERT INTO ylmf_mingzhan VALUES('10','  ','http://www.kaixin001.com/','','8','0','0','','0','0','0','3848203','3848203','3848203','0');
INSERT INTO ylmf_mingzhan VALUES('11','4399СϷ','http://www.4399.com/','','10','0','0','','0','0','0','2739498','2739498','2739498','0');
INSERT INTO ylmf_mingzhan VALUES('12','NBA','http://nba.tom.com/?114la','','11','0','0','','0','0','0','1013829','1013829','1013829','0');
INSERT INTO ylmf_mingzhan VALUES('13','  ','http://www.bitauto.com/?WT.mc_id=114la','','22','0','0','','0','0','0','18452900','18452900','18452900','0');
INSERT INTO ylmf_mingzhan VALUES('14','Ƹ','http://www.eastmoney.com/','','13','0','0','','3','4','10','1182966','1182966','1182966','0');
INSERT INTO ylmf_mingzhan VALUES('15','Ա̳','http://s.click.taobao.com/t_9?p=mm_14033530_0_0&l=http%3A%2F%2Fwww.tmall.com','#FF0000','43','0','0','','0','0','0','873346','873346','873346','0');
INSERT INTO ylmf_mingzhan VALUES('16','ҵ̻','http://www.78.cn/114la_tjl.htm','#FF0000','44','0','0','','0','0','0','915894','915894','915894','0');
INSERT INTO ylmf_mingzhan VALUES('17','  ','http://www.zhcw.com/','','16','0','0','','0','1','0','549822','549822','549822','0');
INSERT INTO ylmf_mingzhan VALUES('18','DaoDao','http://www.daodao.com/DealsHome?m=13240','','39','0','0','','0','0','0','4595039','4595039','4595039','0');
INSERT INTO ylmf_mingzhan VALUES('19','֮','http://www.autohome.com.cn/','','18','0','0','','0','0','0','959178','959178','959178','0');
INSERT INTO ylmf_mingzhan VALUES('20','ѶƱ','http://jipiao.kuxun.cn/?fromid=Klh-S1134481-T1134321','','35','0','0','','0','0','0','1906071','1906071','1906071','0');
INSERT INTO ylmf_mingzhan VALUES('21','  ','http://www.taobao.com/','','23','0','0','','11','39','29','2186906','2186906','2186906','0');
INSERT INTO ylmf_mingzhan VALUES('22','Я','http://p.yiqifa.com/c?s=05190fdd&w=217523&c=297&i=406&l=0&d=2117&e=c&t=http://www.ctrip.com/smartlink/smartlink.asp','','21','0','0','','0','0','0','7947761','7947761','7947761','0');
INSERT INTO ylmf_mingzhan VALUES('24','׿ Խ ','http://www.amazon.cn/default.asp?source=114la','','27','0','0','','0','0','0','815970','815970','815970','0');
INSERT INTO ylmf_mingzhan VALUES('25','й','http://www.gov.cn/','','24','0','0','','0','4','1','1465404','1465404','1465404','0');
INSERT INTO ylmf_mingzhan VALUES('26','','http://www.icbc.com.cn/icbc/','','110','1251734400','1251734400','','0','0','0','1766836','1766836','1766836','0');
INSERT INTO ylmf_mingzhan VALUES('27','·','http://www.aifang.com/?utm_source=114la&utm_medium=CPC&pi=navi-114la-mz','','26','0','0','','0','0','0','547940','547940','547940','0');
INSERT INTO ylmf_mingzhan VALUES('28','캢̳','http://p.yiqifa.com/c?s=0a30a42c&w=217523&c=249&i=148&l=0&e=114la&t=http://www.redbaby.com.cn','','32','0','0','','0','0','0','900801','900801','900801','0');
INSERT INTO ylmf_mingzhan VALUES('29','ͼԵ','http://www.jiayuan.com/st/?id=6202&url=http://www.jiayuan.com/register/?style=2','','20','0','0','','0','0','0','1316508','1316508','1316508','0');
INSERT INTO ylmf_mingzhan VALUES('30','̳','http://p.yiqifa.com/c?s=368a4a7c&w=217523&c=4509&i=5862&l=0&e=114la&t=http://www.360buy.com','','29','0','0','','0','0','0','596958','596958','596958','0');
INSERT INTO ylmf_mingzhan VALUES('31','','http://www.icbc.com.cn/','','30','0','0','','0','1','0','1416345','1416345','1416345','0');
INSERT INTO ylmf_mingzhan VALUES('33','','http://www.tianya.cn/','','12','0','0','','0','1','1','2066123','2066123','2066123','0');
INSERT INTO ylmf_mingzhan VALUES('34','  ','http://www.baihe.com/?policy=1&Channel=zyzt-wzz&Code=140026-114la','','34','0','0','','0','0','0','2320789','2320789','2320789','0');
INSERT INTO ylmf_mingzhan VALUES('35','ֹ','http://p.yiqifa.com/c?s=fd2887ec&w=217523&c=4275&i=4662&l=0&e=114la&t=http://www.m18.com','#FF0000','47','0','0','','0','0','0','406776','406776','406776','0');
INSERT INTO ylmf_mingzhan VALUES('36','','http://www.hunantv.com/','','106','1228060800','1228060800','','0','2','4','1170656','1170656','1170656','0');
INSERT INTO ylmf_mingzhan VALUES('38','VeryCD','http://www.verycd.com/','','111','1243785600','1243785600','','0','1','2','790806','790806','790806','0');
INSERT INTO ylmf_mingzhan VALUES('39','籨','http://www.zaobao.com/','','109','1235836800','1235836800','','4','8','5','2003225','2003225','2003225','0');
INSERT INTO ylmf_mingzhan VALUES('40','  ','http://www.people.com.cn/','','6','0','0','','0','3','6','3236002','3236002','3236002','0');
INSERT INTO ylmf_mingzhan VALUES('42','  ','http://www.ganji.com/','','33','0','0','','0','0','0','802018','802018','802018','0');
INSERT INTO ylmf_mingzhan VALUES('43','̳','http://www.dangdang.com/?_ddclickunion=P-308772|ad_type=10|sys_id=1#dd_refer=http%3A%2F%2Fwww.myler.cn%2F','','28','0','0','','0','0','0','3130798','3130798','3130798','0');
INSERT INTO ylmf_mingzhan VALUES('45','ƽչ','http://chexian.pingan.com/campaign/IB/mttf.jsp?WT.mc_id=Wc03-114la-01','','37','0','0','','0','0','0','224094','224094','224094','0');
INSERT INTO ylmf_mingzhan VALUES('46','ҵĿ','http://www.89178.com/77.htm','green','46','0','0','','0','0','0','844191','844191','844191','0');
INSERT INTO ylmf_mingzhan VALUES('47','','http://www.chinadrtv.com/do_dat.jsp?sid=11410903&dat=9686&url=/','','114','1275235200','1275235200','','0','0','0','544241','544241','544241','0');
INSERT INTO ylmf_mingzhan VALUES('48','ԱŮװ','http://www.taobao.com/go/chn/tbk_channel/lady.php?pid=mm_14033530_3168968_10472325&eventid=101345','#FF0000','48','0','0','','0','0','0','599762','599762','599762','0');
INSERT INTO ylmf_mingzhan VALUES('49','йֳ','http://www.ucar.cn/?1214','','25','0','0','','0','0','0','1869813','1869813','1869813','0');
INSERT INTO ylmf_mingzhan VALUES('50','Ź','http://www.meituan.com/?utm_campaign=114la.com&utm_medium=nav&utm_source=114la.com&utm_content=top','','38','0','0','','0','0','0','575296','575296','575296','0');
INSERT INTO ylmf_mingzhan VALUES('51','6Ƶ','http://www.ku6.com/?ss','','40','0','0','','0','0','0','349942','349942','349942','0');
INSERT INTO ylmf_mingzhan VALUES('52','йƶ','http://10086.cn/','','17','0','0','','0','0','0','126798','126798','126798','0');
INSERT INTO ylmf_mingzhan VALUES('54','̫ƽ','http://www.pconline.com.cn/','','15','0','0','','0','0','2','172262','172262','172262','0');
INSERT INTO ylmf_mingzhan VALUES('53','ͳƷ','http://s.click.taobao.com/t_11?e=%2BtSC5ziSlQIKXTum23VHLUx2Mi9BvFxTCg7CN9kKD8HJdox0eUoImgi5Ng%3D%3D&p=mm_14033530_3168968_10561464','','41','0','0','','0','0','0','209590','209590','209590','0');
INSERT INTO ylmf_mingzhan VALUES('55','лӢ','http://www.chinahr.com/index.htm','','14','0','0','','0','0','0','85','85','85','0');
INSERT INTO ylmf_mingzhan VALUES('56','','http://p.yiqifa.com/c?s=f41a1f6a&w=217523&c=1085&i=724&l=0&e=114la&t=http://www.ihush.com/index.php','','42','0','0','','0','0','0','333115','333115','333115','0');
INSERT INTO ylmf_mingzhan VALUES('57','ΨƷۿ','http://p.yiqifa.com/c?s=5763f9c0&w=217523&c=4566&i=6222&l=0&e=ֵ&t=http://www.vipshop.com/index.php','','36','0','0','','0','0','0','68165','68165','68165','0');
INSERT INTO ylmf_mingzhan VALUES('58','Ů','http://www.27.cn/','','19','0','0','','0','0','0','57383','57383','57383','0');
INSERT INTO ylmf_mingzhan VALUES('59','Ʒۿ','http://www.shopin.net/index.html?cid=114sy','','113','1275235200','1275235200','','0','0','0','100046','100046','100046','0');
INSERT INTO ylmf_mingzhan VALUES('61','4399СϷ','http://www.4399.com/','','107','1228060800','1228060800','','2','9','6','13155','13155','13155','0');
INSERT INTO ylmf_mingzhan VALUES('63','  ','http://www.xinhuanet.com/','','3','0','0','','4','8','9','3276','3276','3276','0');
INSERT INTO ylmf_mingzhan VALUES('65','䰮','http://love.zhenai.com/901001.html','','31','0','0','','0','0','0','6022','6022','6022','0');
INSERT INTO ylmf_mingzhan VALUES('67','','http://p.yiqifa.com/c?s=2cf837ba&w=217523&c=4459&i=5662&l=0&e=114la&t=http://www.suning.cn/webapp/wcs/stores/servlet/TopCategoriesDisplayView?storeId=10052&catalogId=10051','#008000','45','0','0','','0','0','0','700','700','700','0');


INSERT INTO ylmf_recycler VALUES('1','','56','http://www.56.com/','4','','admin','7','0','0','0','');
INSERT INTO ylmf_recycler VALUES('2','','ĸ','http://www.fumu.com/?hmsr=114la&hmmd=links&hmpl=navigation&hmkw=first&hmci=','18','','admin','6','0','0','0','');
INSERT INTO ylmf_recycler VALUES('3','','ľ罻̳','http://www.ylmf.net','22','','admin','100','0','0','0','');
INSERT INTO ylmf_recycler VALUES('4','','ľ̳','http://www.ylmf.net','22','','admin','101','0','0','0','');
INSERT INTO ylmf_recycler VALUES('5','ylmf_site','ͼ','http://xiuxiu.meitu.com/','709','','admin','16','0','0','0','');
INSERT INTO ylmf_recycler VALUES('6','ylmf_site','Ů˽','http://www.mnsfz.com/','710','','admin','7','0','0','0','վ  2010/7/11 0:14:10<br />ģд liang8.com ڳݿⶪʧվ޷¡<br />ʵվ桢ݾԵ<br />--------------------------<br /><br />һ  www.mnsfz.com  ֽУŮ˽<br /><br />ü<br />http://www.mm5mm5.com/<br />ԭλüվҪ޸ͬͼƬվ2010-06-13<br /><br />ҳɫ泷 0106');
INSERT INTO ylmf_recycler VALUES('7','ylmf_site','ͼ','http://www.uumeitu.com/','710','','admin','17','0','0','0','2010-8-31 վ.ָ<br />2010-8-23 360⵽ľ  ͼhttp://www.uumeitu.com/<br />2010-5-27  ͼ http://www.uumeitu.com/ 豸 <br />2010-06-13http://www.shelive.net/ChModel/ҳJJûֵӡΪԭ¼Ҫĺģͼ');
INSERT INTO ylmf_recycler VALUES('8','ylmf_site','Ůרվ','http://www.mn123.net/','710','','admin','11','0','0','0','2010-07-17 [ٶַӵаٶַԴ]Ůרվhttp://www.mn123.net/<br />2010-07-02 http://www.6188.net/6188ͼ ӵ55.COMΪҳ¡<br />2010-5-27   6188ͼ http://www.6188.net/ κ<br />2010-5-27  ͼ http://www.uumeitu.com/ 豸 <br /> http://www.moko.cc/<br />1616.net_');
INSERT INTO ylmf_recycler VALUES('9','ylmf_site','NULL','http://chat.qz.fj.cn/Ȫ','742','','admin','112','0','0','0','ѹر');
INSERT INTO ylmf_recycler VALUES('10','ylmf_site','NULL','http://beta.vqq.com/VQQΧȦȦ','742','','admin','111','0','0','0','');
INSERT INTO ylmf_recycler VALUES('11','ylmf_site','NULL','http://www.7liao.com/','742','','admin','117','0','0','0','');
INSERT INTO ylmf_recycler VALUES('12','ylmf_site','NULL','http://chat.inhe.net/-','742','','admin','113','0','0','0','2009121 ٷѹر ');
INSERT INTO ylmf_recycler VALUES('13','ylmf_site','ƽԽ','http://sex.yiwang.cn/','2286','','admin','6','0','0','0','');
INSERT INTO ylmf_recycler VALUES('14','ylmf_site','˽｡','http://www.nvrencn.cn/','2286','','admin','9','0','0','0','');
INSERT INTO ylmf_recycler VALUES('15','ylmf_site','ܹδȫ','http://www.zgjiemeng.com/','786','','admin','5','0','0','0','');
INSERT INTO ylmf_recycler VALUES('16','','51','http://www.51.com/?fromsite=114la_5','22','','admin','7','0','0','0','');
INSERT INTO ylmf_recycler VALUES('17','ylmf_site','ˮ','http://p.yiqifa.com/c?s=26186c91&w=217523&c=4061&i=3242&l=0&e=114la&t=http://www.oyeah.cn','2305','','admin','100','0','0','0','');
INSERT INTO ylmf_recycler VALUES('18','','58Ƹ','http://go.58.com/?adSys=20&AdCode=2029&adPage=http://www.58.com/','19','','admin','101','0','0','0','');
INSERT INTO ylmf_recycler VALUES('19','','֮','http://www.unionli.com/txlink.php?alid=24663','2','','admin','7','0','0','0','');
INSERT INTO ylmf_recycler VALUES('20','','Կ','http://tao.kukaka.org/','11','','admin','100','0','0','0','');

INSERT INTO ylmf_search VALUES('14','8','ѹ','http://news.sogou.com/news','query','ѹ','ѹ','static/images/s/sogou.gif','http://news.sogou.com/?pid=sogou-site-cdf1035c34ec3802','sort:\'0\',\r\ntime:\'0\',\r\nw:\'03009900\',\r\n_asf:\'news.sogou.com\',\r\n_ast:\'\',\r\nmode:\'1\'','3','1','0');
INSERT INTO ylmf_search VALUES('4','2','ٶ','http://www.baidu.com/s','wd','ٶһ','ٶ','static/images/s/baidu.gif','http://www.myler.cn/jingjian.html','','3','1','0');
INSERT INTO ylmf_search VALUES('13','2','ȸ','http://www.google.com.hk/search','q','ȸ','ȸ','static/images/s/google.gif','http://www.google.com.hk/webhp?prog=aff&client=pub-0194889602661524&channel=3192690043','client:\\\'pub-0194889602661524\\\',\r\nchannel :\\\'3192690043\\\',\r\nforid :\\\'1\\\',\r\nprog :\\\'aff\\\',\r\nhl :\\\'zh-CN\\\',\r\nsource :\\\"sdo_sb_html\\\",\r\nie:\\\'gb2312\\\'','2','1','0');
INSERT INTO ylmf_search VALUES('15','2','116','http://116.com/s','q','116','116','static/images/s/116.gif','http://116.com','ie:\\\"gbk\\\"','1','1','1');
INSERT INTO ylmf_search VALUES('16','9','ٶ','http://mp3.baidu.com/m','word',' ','ٶmp3','static/images/s/mp3.gif','http://mp3.baidu.com/m?ie=utf-8&ct=134217728&word=','f: \"ms\",\r\nct: \"134217728\"','1','1','1');
INSERT INTO ylmf_search VALUES('17','10','ٶ','http://video.baidu.com/v','word','ٶƵ','ٶƵ','static/images/s/video.gif','http://video.baidu.com/','ct:\'301989888\',\r\nrn:\'20\',\r\npn:\'0\',\r\ndb:\'0\',\r\ns:\'0\',\r\nfbl:\'800\'','2','1','0');
INSERT INTO ylmf_search VALUES('18','11','ٶ','http://image.baidu.com/i','word',' ','ٶͼƬ','static/images/s/pic.gif','http://image.baidu.com/','ct: \"201326592\",\r\ncl: \"2\",\r\npv: \"\",\r\nlm: \"-1\"','1','1','1');
INSERT INTO ylmf_search VALUES('19','13','ѹ','http://wenda.sogou.com/search','query',' ','ѹ','static/images/s/sogou.gif','http://wenda.sogou.com/?pid=AQDJZ','','2','1','0');
INSERT INTO ylmf_search VALUES('20','14','Ա','http://search8.taobao.com/browse/search_auction.htm','q','Ա','Ա','static/images/s/taobao.gif','http://www.taobao.com/go/chn/tbk_channel/onsale.php?pid=mm_14033530_3168968_10553587','pid: \"mm_14033530_3168968_10553587\",\r\ncommend: \"all\",\r\nsearch_type: \"action\"','1','1','1');
INSERT INTO ylmf_search VALUES('36','2','ѹ','http://www.sogou.com/sogou','query','ѹ','ѹ','static/images/s/sogou.gif','http://www.sogou.com/index.php?pid=sogou-site-cdf1035c34ec3802','pid:\'sogou-site-cdf1035c34ec3802\'','5','1','0');
INSERT INTO ylmf_search VALUES('21','12','ȸ','http://ditu.google.cn/maps','q',' ','ȸͼ','static/images/s/google.gif','http://ditu.google.cn/','','2','1','0');
INSERT INTO ylmf_search VALUES('22','2','SOSO','http://www.soso.com/q','w',' ','SOSO','static/images/s/soso.gif','http://www.soso.com/?unc=s200000_7&cid=union.s.wh','unc: \"s200000_7\",\r\ncid: \"union.s.wh\",\r\nie:\'gb2312\'','5','1','0');
INSERT INTO ylmf_search VALUES('23','9','SOSO','http://cgi.music.soso.com/fcgi-bin/m.q','w',' ','mp3','static/images/s/soso.gif','http://music.soso.com/?unc=s200000_7&cid=union.s.wh','unc: \"s200000_7\",\r\ncid: \"union.s.wh\"','3','1','0');
INSERT INTO ylmf_search VALUES('24','9','ȸ','http://www.google.cn/music/search','q',' ','ȸ','static/images/s/google.gif','http://www.google.cn/music/homepage','aq: \"f\",\r\nie: \"gb2312\",\r\noe: \"utf8\",\r\nhl: \"zh-CN\"','2','1','0');
INSERT INTO ylmf_search VALUES('25','10','ȸ','http://www.google.com.hk/search','q',' ','ȸ','static/images/s/google.gif','http://www.google.com.hk/videohp','tbo: \"p\",\r\ntbs: \"vid:1\",\r\nsource: \"vgc\",\r\nie:\'gb2312\'','3','1','0');
INSERT INTO ylmf_search VALUES('26','11','ȸ','http://images.google.com.hk/images','q',' ','ȸ','static/images/s/google.gif','http://images.google.com.hk/imgcat/imghp?hl=zh-CN','gbv: \"2\",\r\nsource: \"hp\",\r\nhl: \"zh-CN\"','2','1','0');
INSERT INTO ylmf_search VALUES('27','8','SOSO','http://news.soso.com/n.q','w',' ','','static/images/s/soso.gif','http://news.soso.com/?cid=union.s.wh','cid: \"union.s.wh\",\r\nie:\'gb2312\'','4','1','0');
INSERT INTO ylmf_search VALUES('28','10','116','http://v.115.com/','q',' ','116Ӱ','static/images/s/116.gif','http://v.115.com','ie:\\\'gbk\\\'','1','1','1');
INSERT INTO ylmf_search VALUES('29','8','ٶ','http://news.baidu.com/ns','word',' ','ٶ','static/images/s/news.gif','http://news.baidu.com/','','1','1','1');
INSERT INTO ylmf_search VALUES('30','14','','http://search.360buy.com/Search','keyword','','','static/images/s/360buy.gif','http://www.360buy.com/','','4','1','0');
INSERT INTO ylmf_search VALUES('31','13','ٶ','http://zhidao.baidu.com/q','word','ٶһ','ٶһ','static/images/s/zhidao.gif','http://zhidao.baidu.com/q?pt=ylmf_ik','tn: \"ikaslist\",\r\nct: \"17\",\r\npt: \"ylmf_ik\"','1','1','1');
INSERT INTO ylmf_search VALUES('32','12','ٶ','http://map.baidu.com/m','word','ٶһ','ٶȵͼ','static/images/s/baidu.gif','http://map.baidu.com/','','1','1','1');
INSERT INTO ylmf_search VALUES('33','8','ȸ','http://news.google.com.hk/news/search','q',' ','ȸ','static/images/s/google.gif','http://news.google.com.hk/','ie:\'gb2312\'','2','1','0');
INSERT INTO ylmf_search VALUES('34','14','׿Խ','http://www.amazon.cn/search/search.asp','searchWord',' ','׿Խ','static/images/s/joyo.gif','http://www.amazon.cn/','','3','1','0');
INSERT INTO ylmf_search VALUES('35','14','','http://search.dangdang.com/search.aspx','key',' ','','static/images/s/dangdang.gif','http://www.dangdang.com/?_ddclickunion=P-308772|ad_type=10|sys_id=1#dd_refer=http%3A%2F%2Fwww.myler.cn%2F','','5','1','0');
INSERT INTO ylmf_search VALUES('37','11','ѹ','http://pic.sogou.com/pics','query','ѹͼƬ','ѹͼƬ','static/images/s/sogou.gif','http://pic.sogou.com/?pid=sogou-site-b2531e7bb29bf22e','pid:\'sogou-site-b2531e7bb29bf22e\'','3','1','0');

INSERT INTO ylmf_search_keyword VALUES('33','8','ӹȥ','http://www.baidu.com/s?wd=%BD%F0%D3%B9%C8%A5%CA%C0&tn=ylmf_4_pg&ch=4','','1','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('13','2','ʱ','http://www.taobao.com/go/chn/tbk_channel/huangguan.php?pid=mm_14033530_3168968_10472318&eventid=101858','','2','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('11','2','Աʹڵ','http://www.taobao.com/go/chn/tbk_channel/huangguan.php?pid=mm_14033530_3168968_10472318&eventid=101858','','3','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('14','2','װ¿','http://s.click.taobao.com/t_8?e=7HZ6jHSTbIceqnj2M045qIp9LUPm54szu7YxayWtHnu4&p=mm_14033530_0_0','','1','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('10','2','¿֯','http://s.click.taobao.com/t_8?e=7HZ6jHSTbIg3NPjhrOGAu3k5%2FsRHmiBo5G1wl0hxkYeTww%3D%3D&p=mm_14033530_0_0','','4','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('15','9','ûи','http://mp3.baidu.com/m?word=%C7%E9%B8%E8%C3%BB%D3%D0%B8%E6%CB%DF%C4%E3+%C1%BA.&tn=ylmf_4_pg&ch=4&f=ms&ct=134217728','','1','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('16','9','ǵ','http://mp3.baidu.com/m?word=%BC%C7%B5%C3+%C1%D6%BF%A1%BD%DC&tn=ylmf_4_pg&ch=4&f=ms&ct=134217728','','2','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('17','9','Զ','http://mp3.baidu.com/m?word=%D3%C0%D4%B6%B0%AE%B2%BB%CD%EA+%B9%F9%B8%BB%B3%C7&tn=ylmf_4_pg&ch=4&f=ms&ct=134217728','','3','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('18','9','','http://mp3.baidu.com/m?word=%B4%BA%CC%EC%C0%EF+%CD%F4%B7%E5&tn=ylmf_4_pg&ch=4&f=ms&ct=134217728','','4','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('19','10','ӵ','http://116.com/?q=%E8%AE%A9%E5%AD%90%E5%BC%B9%E9%A3%9E','','1','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('20','10','Ϲ¶','http://116.com/?q=%E8%B5%B5%E6%B0%8F%E5%AD%A4%E5%84%BF','','2','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('21','10','Ц','http://116.com/?q=%E5%A4%A7%E7%AC%91%E6%B1%9F%E6%B9%96','','3','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('22','10','̾2010','http://116.com/?q=%E5%88%91%E8%AD%A62010','','4','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('23','11','justin bie','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=justin bieber','','1','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('24','11','ܽ','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=ܽ','','2','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('25','11','','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=','','3','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('26','11','ܰ','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=ܰ','','4','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('27','13','ô?','http://zhidao.baidu.com/q?word=%D3%F6%B5%BD%BB%F0%D4%D6%D4%F5%C3%B4%B0%EC&tn=ikaslist&ct=17&pt=ylmf_ik','','1','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('28','13','źض','http://zhidao.baidu.com/q?word=%D5%C5%BA%E2%B5%D8%B6%AF%D2%C7%D5%E6%B5%C4%D3%D0%D3%C3%C2%F0&tn=ikaslist&ct=17&pt=ylmf_ik','','2','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('29','14','װ','http://pindao.huoban.taobao.com/channel/man.htm?pid=mm_14033530_3168968_10553587','','1','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('30','14','ʱŮװ','http://pindao.huoban.taobao.com/channel/lady.htm?pid=mm_14033530_3168968_10553587','','2','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('31','14','ݻ','http://pindao.huoban.taobao.com/channel/beauty.htm?pid=mm_14033530_3168968_10553587','','3','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('32','14','ƷЬ','http://pindao.huoban.taobao.com/channel/jewelry.htm?pid=mm_14033530_3168968_10553587','','4','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('34','8','','http://www.baidu.com/s?wd=%C0%EE%C4%EE%B6%A9%BB%E9&tn=ylmf_4_pg&ch=4','','2','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('35','8','ӦƸ','http://www.baidu.com/s?wd=%B7%EF%BD%E3+%D3%A6%C6%B8&tn=ylmf_4_pg&ch=4','','3','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('36','8','վ','http://www.baidu.com/s?wd=%C3%C0%C8%D5%BE%FC%D1%DD&tn=ylmf_4_pg&ch=4','','4','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('37','11','Ž','http://image.baidu.com/i?tn=baiduimage&ct=201326592&cl=2&pv=&lm=-1&word=Ž','','5','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('38','12','ݸ','http://ditu.google.cn/maps?q=%B6%AB%DD%B8&search_select=engine_21','','1','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('39','12','','http://ditu.google.cn/maps?q=%B1%B1%BE%A9%CA%D0&search_select=engine_21','','2','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('40','12','Ϻ','http://ditu.google.cn/maps?q=%C9%CF%BA%A3%CA%D0&search_select=engine_21','','3','0','0','0','0','0','0','');
INSERT INTO ylmf_search_keyword VALUES('41','12','','http://ditu.google.cn/maps?q=%B9%E3%D6%DD%CA%D0&search_select=engine_21','','4','0','0','0','0','0','0','');

INSERT INTO ylmf_searchclass VALUES('2','ҳ','2','1');
INSERT INTO ylmf_searchclass VALUES('8','','1','0');
INSERT INTO ylmf_searchclass VALUES('9','MP3','3','0');
INSERT INTO ylmf_searchclass VALUES('10','Ƶ','4','0');
INSERT INTO ylmf_searchclass VALUES('11','ͼƬ','5','0');
INSERT INTO ylmf_searchclass VALUES('12','ͼ','6','0');
INSERT INTO ylmf_searchclass VALUES('13','ʴ','7','0');
INSERT INTO ylmf_searchclass VALUES('14','','8','0');

INSERT INTO ylmf_site VALUES('1','С˵','http://www.xxsy.net/','645','10','0','0','0','0','2','388525','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3','С˵Ķ','http://www.readnovel.com','645','2','0','0','0','0','11','713977','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('6','ԭ','http://www.jjwxc.net/','645','8','0','0','0','0','6','305571','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10','С˵','http://www.fy01.cc/','645','24','0','0','0','0','0','196785','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('13','ѧ','http://www.zhulang.com','645','11','0','0','0','0','0','121316','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15','С˵','http://www.zzzyq.com/','645','22','0','0','0','0','0','196083','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40820','ԭ','http://www.4yt.net/','645','15','0','0','0','0','0','806','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23','ݺ','http://www.zongheng.com/?CO=114la','645','6','0','0','0','0','0','215818','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38584','С˵','http://www.xstxw.com','645','18','0','0','0','0','0','212478','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38600','ѧ','http://www.mx99.com','645','17','0','0','0','0','1','84531','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41','С˵','http://www.qukanshu.com/','645','12','0','0','0','0','1','128829','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('43','С˵¥','http://www.shulou.com/','645','13','0','0','0','0','0','191682','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('44','ԭӢС˵','http://www.en8848.com','1045','22','0','0','0','0','0','5433','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35443','ຣ˲','http://www.qhrc.com.cn/qh/','1521','10','0','0','0','0','0','376','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('71','Ѻ','http://club.book.sohu.com','647','7','0','0','0','0','0','950','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('74','˶̳','http://bbs.book.sina.com.cn/group.php?tree=0&gid=2','647','8','0','0','0','0','0','918','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('75','̳','http://bbs.hongxiu.com/?114la','647','9','0','0','0','0','0','0','0','','yzg','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('77','ʷϵ̳','http://www.wangf.net','647','10','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38275','˲г','http://www.0577rc.com','1528','51','0','0','0','0','0','1198','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('82','ٶС˵','http://post.baidu.com/f?kw=С˵','647','11','0','0','0','0','0','1493','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('83','ϯƷ','http://www.xijuan.com/xijuan/index.htm','648','18','0','0','0','0','0','122689','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('84','','http://www.qiuyuonline.com','648','2','0','0','0','0','1','39392','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34335','Ѷ','http://book.qq.com/','649','1','0','0','0','0','1','105847','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('90','Ʒ','http://www.40zw.cn/HuangYi.html','648','10','0','0','0','0','0','65430','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('93','Ʒ','http://www.40zw.cn/YiShu.html','648','127','0','0','0','0','0','38466','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('94','ѩƷ','http://www.40zw.cn/ShanFeiXue.html','648','135','0','0','0','0','0','38034','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('95','Ʒ','http://www.40zw.cn/GuLong.html','648','9','0','0','0','0','0','66515','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40724','³ѸƷȫ','http://www.lib.hstc.edu.cn/resource/luxun/index.htm','648','110','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('34340','','http://www.du8.com/','649','7','0','0','0','0','2','41536','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38420','','http://www.china-designer.com/','2104','1','0','0','0','0','0','135','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17706','֯ó','http://www.ccpittex.com/','1218','51','0','0','0','0','0','12','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39694','NULL','http://www.webyi.com̳','1132','103','0','0','0','0','0','125','0','','lzb','0','0','1279728000','1279728000','','1');
INSERT INTO ylmf_site VALUES('36827','','http://www.eastday.com/','1886','3','0','0','0','0','0','7','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38421','ҽ׼','http://www.chinabuilding.com.cn/','2104','2','0','0','0','0','0','7069','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37077','NULL','http://www.nmg.gov.cn/nmgmap/ɹֵͼ','1891','7','0','0','0','0','0','1061','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38422','ABBS̳','http://www.abbs.com.cn/','2104','3','0','0','0','0','0','4096','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15348','װͼ','http://www.tumanduo.com','879','1','0','0','0','0','2','151833','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15347','ɽ˲г','http://www.sxjobs.cn/','1546','3','0','0','0','0','0','1211','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15345','Ȫ˲','http://www.yqrsj.gov.cn/','1546','11','0','0','0','0','0','48','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15344','ͬ˲','http://www.dtrcsc.com/','1546','13','0','0','0','0','0','266','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15343','̫ԭƸϢ','http://www.tyzhaopin.cn/','1546','5','0','0','0','0','0','870','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15342','̫ԭְҵܷ','http://www.tylm.com.cn/','1546','6','0','0','0','0','0','460','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15341','NULL','http://www.tyrsj.gov.cn/̫ԭ˲Ϣ','1546','4','0','0','0','0','0','724','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15340','̫ԭ˲','http://www.ctpjob.com/','1546','8','0','0','0','0','0','468','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15337','NULL','http://www.sxsrs.gov.cn/ɽ˲','1546','1','0','0','0','0','0','534','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15336','ʯɽͶҵ','http://www.nxsjy.com.cn/','1536','13','0','0','0','0','0','75','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15335','ʯɽ˲','http://www.szsrsrc.com/','1536','12','0','0','0','0','0','178','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('144','','http://photo.163.com','653','1','0','0','0','0','0','63500','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('145','QQ','http://photo.qq.com','653','4','0','0','0','0','0','9688','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38903','Ƭ','http://www.photops.com/','2121','13','0','0','0','0','0','40667','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32255','Zcomд','http://show.zcom.com/','825','99','0','0','0','0','15','4071','0','','lzb','0','0','1286726400','1286726400','','1');
INSERT INTO ylmf_site VALUES('38904','Ӱ̳','http://forums.nphoto.net/','2121','14','0','0','0','0','0','11162','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38907','Ӱ','http://www.photofans.cn/forum.php','2122','1','0','0','0','0','0','12755','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27946','','http://ent.163.com/','825','5','0','0','0','0','0','13824','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34959','йе','http://www.chemm.cn/','1200','4','0','0','0','0','0','565','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15607','','http://www.btv.org/','1362','100','0','0','0','0','0','62','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15588','-','http://www.douban.com/book','649','5','0','0','0','0','0','2125','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15587','Google Reader','http://www.google.com/reader/view/','670','1','0','0','0','0','0','192','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15577','԰','http://www.cnblogs.com/','669','24','0','0','0','0','0','10128','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15574','Ѷ','http://blog.hexun.com/','669','4','0','0','0','0','0','4960','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15568','ٶȿռ','http://hi.baidu.com/','669','8','0','0','0','0','17','36492','0','','','1','1','0','0','','0');
INSERT INTO ylmf_site VALUES('36683','ຣҽְҵѧԺ','http://www.qhxmzy.com.cn/','1317','9','0','0','0','0','0','38','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29581','ͼ','http://news.sina.com.cn/photo/','709','8','0','0','0','0','0','52050','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29578','ͼ','http://www.27.cn/jptk/index.html','709','1','0','0','0','0','0','80598','0','','ylmf','0','0','1283616000','1283616000','','1');
INSERT INTO ylmf_site VALUES('29572','','http://www.czxiu.com/','745','6','0','0','0','0','0','17959','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29570','ŻͼƬ','http://image.cn.yahoo.com/','709','3','0','0','0','0','0','106103','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29569','ֽ','http://www.bizhi.com/','709','7','0','0','0','0','0','58113','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29565','','http://www.ka77.com/','711','22','0','0','0','0','0','46005','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29562','Żֽ','http://image.cn.yahoo.com/imglist.html?bid=3&f=D15_u','711','15','0','0','0','0','0','87411','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32224','̳','http://bbs.voc.com.cn/','675','7','0','0','0','0','0','4731','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29557','ֽ','http://www.kpbz.net/','711','12','0','0','0','0','0','174639','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35069','ڿͶ','http://www.hack58.com/','1139','1','0','0','0','0','0','7908','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40303','ֽ','http://www.ttbz8.com','711','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('247','Ѻ','http://yule.sohu.com','659','5','0','0','0','0','0','131132','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('248','','http://ent.163.com','659','7','0','0','0','0','1','74964','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('249','TOM','http://ent.tom.com','659','2','0','0','0','0','0','138727','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('251','21CN','http://et.21cn.com','659','12','0','0','0','0','0','45474','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('256','','http://enjoy.eastday.com','659','19','0','0','0','0','3','51709','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('258','Ϸ','http://www.southcn.com/ent','659','14','0','0','0','0','1','20967','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('275','Ӱ','http://ent.sina.com.cn/index.shtml','659','1','0','0','0','0','11','368853','0','','lwh','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('34338','','http://wind.yinsha.com/','649','4','0','0','0','0','0','48145','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37100','ɹŸ','http://www.nmlottery.com.cn/','1891','26','0','0','0','0','0','89','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28168','Acosta','http://blog.sina.com.cn/u/1456252804','1924','1','0','0','0','0','0','820','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28167','ٱСֵBLOG','http://blog.sina.com.cn/m/xiaopangblog','1924','2','0','0','0','0','0','1997','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28166','ֺ','http://blog.sina.com.cn/m/housheboy','1924','3','0','0','0','0','0','2509','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28165','ͷ','http://blog.sina.com.cn/m/huge','1924','4','0','0','0','0','0','810','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28164','õBLOG','http://blog.sina.com.cn/m/gjmm','1924','16','0','0','0','0','0','4576','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28163','BLOG','http://blog.sina.com.cn/m/dingbeili','1924','15','0','0','0','0','0','815','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28162','⴫','http://blog.sina.com.cn/m/ningcaishen','1924','12','0','0','0','0','0','1397','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28161','ֻƽ','http://blog.sina.com.cn/huangjianxiang','1924','5','0','0','0','0','0','1644','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28160','ڵٷվ','http://www.yudan.net.cn/','1923','23','0','0','0','0','0','674','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41184','','http://www.xiazaiba.com/html/21.html','2287','7','0','0','0','0','0','0','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32174','17173','http://www.17173.com/','699','1','0','0','0','0','18','219344','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('35299','DJ527','http://www.dj527.com/','720','3','0','0','0','0','0','128075','0','','ylmf','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('32169','Ůʱ','http://www.nvyou.com/','664','21','0','0','0','0','0','8','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('326','̫ƽʱŮ','http://www.pclady.com.cn/?ad=4447','664','2','0','0','0','0','0','79000','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('327','üŮ','http://www.self.com.cn/','664','7','0','0','0','0','0','389460','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('328','pocoŮƵ','http://lady.poco.cn/','664','13','0','0','0','0','0','124126','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('329','21CNŮ˰','http://she.21cn.com','664','8','0','0','0','0','2','83472','0','','lzb','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('330','Ů','http://www.7y7.com/index.html','664','19','0','0','0','0','0','157660','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('331','39Ů','http://woman.39.net/','664','18','0','0','0','0','6','84852','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('340','elleŮ','http://www.ellechina.com/?dressup=false','664','116','0','0','0','0','0','41563','0','','lzb','0','0','1278518400','1281196800','','1');
INSERT INTO ylmf_site VALUES('358','39','http://man.39.net/','665','6','0','0','0','0','9','171185','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('362','TOM','http://lady.tom.com/','665','4','0','0','0','0','0','106899','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('372','ʱ','http://www.mister.org.cn/','665','8','0','0','0','0','0','27301','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41168','ɫƷ','http://p.yiqifa.com/c?s=f4f47716&w=217523&c=311&i=522&l=0&e=114la&t=http://www.x.com.cn','2305','3','0','0','0','0','0','0','0','#008000','admin','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39550','С','http://digi.beareyes.com.cn/','796','14','0','0','0','0','0','1209','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34370','Ż','http://xk.cn.yahoo.com/digi/index.html','796','8','0','0','0','0','1','3744','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('429','˲','http://blog.sina.com.cn','669','3','0','0','0','0','0','22686','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('432','й','http://www.blogcn.com','669','12','0','0','0','0','0','23782','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('433','Ѻ','http://blog.sohu.com','669','6','0','0','0','0','0','28371','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('436','','http://www.bokee.com','669','9','0','0','0','0','1','33133','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15570','й˲','http://blog.edu.cn/index.html','669','15','0','0','0','0','0','4581','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('442','','http://www.blog.com.cn','669','100','0','0','0','0','0','21077','0','','xiaoku','0','0','1286467200','1286467200','','1');
INSERT INTO ylmf_site VALUES('448','DoNews Blog','http://blog.donews.com/','669','20','0','0','0','0','0','1793','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('460','Google','http://blogsearch.google.cn/','835','21','0','0','0','0','0','3163','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23293','л԰','http://www.emuseum.org.cn/','1797','100','0','0','0','0','0','2888','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28478','ʹ','http://www.xianguo.com/','670','2','0','0','0','0','0','1572','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28471','ɵ','http://www.feedsky.com/','670','6','0','0','0','0','0','415','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34774','ٶȲ','http://blogsearch.baidu.com/','835','22','0','0','0','0','0','31','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35685','ٶѲ','http://cang.baidu.com/','673','7','0','0','0','0','0','1514','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('483','ժ','http://www.huzhai.com','673','3','0','0','0','0','0','3706','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15608','˳̨','http://www.bjsytv.com/','1362','100','0','0','0','0','0','616','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('485','Ѷժ','http://bookmark.hexun.com','673','4','0','0','0','0','0','2310','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('489','Pocoժ','http://share.poco.cn','673','1','0','0','0','0','0','4312','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38887','ViViղؼ','http://vivi.sina.com.cn/','673','9','0','0','0','0','0','1230','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('499','滢','http://www.qihoo.com','675','12','0','0','0','0','0','8131','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('500','ݾֲ','http://pop.pcpop.com','675','19','0','0','0','0','0','15871','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('502','QQ̳','http://bbs.qq.com','675','5','0','0','0','0','1','984','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('503','ͬ','http://www.xici.net','675','8','0','0','0','0','1','42691','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('504','̳','http://bbs.phoenixtv.com','675','16','0','0','0','0','0','9817','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('506','Ѻ','http://club.sohu.com','675','4','0','0','0','0','0','42681','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('508','21CN','http://free.21cn.com','675','42','0','0','0','0','0','3717','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32640','Ħֻ̳','http://www.motobbs.com/','690','8','0','0','0','0','0','40','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('510','̳','http://bbs.163.com','675','6','0','0','0','0','0','18839','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('512','ǿ','http://bbs.people.com.cn','675','30','0','0','0','0','0','1402','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('513','Tom','http://club.tom.com','675','29','0','0','0','0','0','10395','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('516','̳','http://bbs.ynet.com','675','45','0','0','0','0','1','9287','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('518','Csdn','http://community.csdn.net','678','3','0','0','0','0','0','435','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('519','̳','http://bbs.rednet.cn/','675','10','0','0','0','0','0','1331','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32244','Ĳ','http://blog.tianya.cn/','669','17','0','0','0','0','1','25296','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('521','ȷ̳','http://bbs.dvbbs.net','678','19','0','0','0','0','0','468','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('524','Ϸ','http://bbs.southcn.com','675','43','0','0','0','0','0','5427','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('526','̳','http://bbs.54master.com/','678','23','0','0','0','0','0','391','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36439','ǭ','http://www.qxn.gov.cn/','1861','9','0','0','0','0','0','117','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('539','̳','http://bbs.sina.com.cn/','675','3','0','0','0','0','0','28965','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38289','ݲżҽ','http://www.boya2004.com','1904','44','0','0','0','0','0','621','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40427','9036ѵӰ','http://www.9036.com/','2242','4','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('543','л̳','http://bbs.china.com','675','15','0','0','0','0','1','10026','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('545','̳','http://bbs.powereasy.net/','678','20','0','0','0','0','0','565','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('549','ˮľ','http://www.newsmth.net','2078','18','0','0','0','0','0','13','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('552','Ϻˮ˼ԴBBS','http://bbs.sjtu.edu.cn','2078','5','0','0','0','0','0','483','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('553','ɽѧ̳','http://bbs.yunjian.com','2078','54','0','0','0','0','0','178','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('554','NULL','http://bbs.shangda.net/Ϻѧbbs','2078','53','0','0','0','0','0','465','0','','LWH','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('555','人ѧɽˮBBS','http://bbs.whu.edu.cn','2078','11','0','0','0','0','0','522','0','','LWH','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('556','ѧ¹⻪','http://bbs.fudan.edu.cn','2078','8','0','0','0','0','0','723','0','','LWH','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('557','ϾѧСٺBBS','http://bbs.nju.edu.cn/','2078','4','0','0','0','0','0','550','0','','LWH','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('558','йMBAhome̳','http://bbs.mbahome.com','2078','56','0','0','0','0','0','87','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('560','ˮľ廪BBS','http://www.smth.edu.cn','2078','1','0','0','0','0','0','6015','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('561','ϾѧԺ-ǻ̳','http://xhbbs.njit.edu.cn/','2078','49','0','0','0','0','0','126','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('562','Ŵѧ','http://bbs.xmu.edu.cn','2078','50','0','0','0','0','0','463','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('564','ѧ̳','http://www.gzubbs.com','2078','55','0','0','0','0','0','231','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('565','NULL','http://www.yndxs.com/site/swfc.htmlѧԺ̳','2078','51','0','0','0','0','0','101','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('566','̺վ','http://bbs.dlut.edu.cn','2078','23','0','0','0','0','0','196','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('567','ͬôѧBBSͬ۹','http://bbs.tongji.edu.cn/','2078','9','0','0','0','0','0','289','0','','LWH','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36862','Ϻ-','http://tttrip.online.sh.cn/','1886','36','0','0','0','0','0','1980','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('569','㽭ҵѧ̳','http://www.zjut.com.cn','2078','47','0','0','0','0','0','253','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36861','Ϻⷿ','http://www.okfang.com/','1886','35','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36860','Ϻ','http://www.shome.cn/','1886','34','0','0','0','0','0','4150','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('572','ڴѧ԰վ','http://liyuan.szu.edu.cn/','2078','46','0','0','0','0','0','235','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('573','NULL','http://bbs.neu.com.cn/ѧɽˮվ','2078','52','0','0','0','0','0','131','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('574','Ͻɺվ','http://bbs.njupt.edu.cn','2078','16','0','0','0','0','0','82','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('576','ӱѧBBS','http://bbs.hbu.edu.cn','2078','41','0','0','0','0','0','163','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('577','ľBBS','http://bbs.gznet.edu.cn','2078','2','0','0','0','0','0','703','0','','LWH','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36859','׾','http://www.021fang.com/','1886','33','0','0','0','0','0','1954','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('580','NULL','http://www.cjlu.com/bbs/index.aspйѧԺ','2078','45','0','0','0','0','0','117','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('584','NULL','http://bupt.org/wForum¶վ','2078','15','0','0','0','0','0','124','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('585','NULL','http://www.hngdbbs.com/bbs/index.phpϹҵѧ̳','2078','44','0','0','0','0','0','126','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32621','NULL','http://bbs.zsu.edu.cn/ɽѧʱBBS','2078','19','0','0','0','0','0','411','0','','LWH','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('588','NULL','http://www.cau-edu.net.cn/bbs/ũ̳','2078','48','0','0','0','0','0','100','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('593','Ա̳','http://bbs.shudoo.com/','678','22','0','0','0','0','0','11','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('594','ٶ','http://post.baidu.com/f?kw=','678','26','0','0','0','0','1','356','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28734','Ӱ̳','http://bbs.greendown.cn/index.php','678','27','0','0','0','0','0','642','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('600','񷴲','http://forum.jiangmin.com','680','1','0','0','0','0','0','6','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('602','Ѻȫ̳','http://bbs.club.sohu.com/main.php?b=hack','680','3','0','0','0','0','0','6','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('603','԰ȫ̳','http://www2.beareyes.com.cn/bbs/q.htm','680','4','0','0','0','0','0','597','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('606','̳','http://www.patching.net/bbs/index.htm','680','5','0','0','0','0','0','185','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('607','Ѻר','http://it.sohu.com/90/71/column203667190.shtml','680','6','0','0','0','0','0','257','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36438','ǭ','http://www.qdn.gov.cn/','1861','8','0','0','0','0','0','329','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('611','ٶȲ','http://post.baidu.com/f?kw=&#30149;&#27602;','680','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('612','IT168̳','http://bbs.it168.com','681','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('613','С̳','http://bbs.beareyes.com.cn/','681','7','0','0','0','0','0','8','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('615','52Ӳ̳','http://bbs.52hardware.com/','681','2','0','0','0','0','0','17','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('616','й','http://www.cnnbpc.com/bbs','681','18','0','0','0','0','0','326','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('617','Ӳղ̳','http://bbs.yjfy.com','681','13','0','0','0','0','0','17','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32592','̫ƽƷ̳','http://itbbs.pconline.com.cn/','681','5','0','0','0','0','0','572','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32591','PCShow.net-IT','http://itbbs.pcshow.net/','681','15','0','0','0','0','0','314','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32590','eNetӲ̳','http://diybbs.enet.com.cn/','681','3','0','0','0','0','0','467','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('621','ӲDIY̳','http://diybbs.it168.com/','681','1','0','0','0','0','0','42','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('623','NULL','http://forum.tech.sina.com.cn/cgi-bin/tree.cgi?gid=23&fid=289Ӳ̳','681','11','0','0','0','0','0','25','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('624','ԶѶ߷̳','http://bbs.cniti.com/','681','16','0','0','0','0','0','83','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32589','йش̳','http://bbs.zol.com.cn/','681','4','0','0','0','0','0','25','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38334','ѧְ','http://www.fillsky.com','1531','8','0','0','0','0','0','380','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('666','-','http://ent.163.com/picture','684','4','0','0','0','0','8','4220','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('673','ͼ-Ѻ','http://club.yule.sohu.com/list_art_sub.php?b=startu','684','5','0','0','0','0','0','2312','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('674','̳ͼ-TOM̳','http://pic.bbs.tom.com/','684','3','0','0','0','0','0','7776','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('676','ͼ-','http://bbs.hnol.net/list2.asp?boardid=61','684','12','0','0','0','0','0','11626','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('683','лĬ','http://fun.china.com/zh_cn/joke/index.html','685','14','0','0','0','0','0','891','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('684','԰','http://www.tianya.cn/new/TechForum/ArticlesList.asp?idWriter=0&Key=0&idItem=14','685','9','0','0','0','0','0','879','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('686','ĬЦ','http://www.vicn.net/list.asp?boardid=19','685','16','0','0','0','0','0','275','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('687','Ц̳','http://people.sina.com.cn/forum/xiaohua2.html','685','2','0','0','0','0','0','1701','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('688','sohuЦ','http://club.sohu.com/main.php?b=joke','685','11','0','0','0','0','0','274','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('689','','http://www.51haha.net/club/','685','5','0','0','0','0','0','1194','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('690','21cnЦֹ','http://free.21cn.com/newbbs/mainframe.jsp?url=/forum/bbsThreadList.act?bbsForumId=56','685','12','0','0','0','0','0','578','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('691','ٶЦ','http://post.baidu.com/f?kw=Ц','685','1','0','0','0','0','3','1177','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('693','SoGua̳','http://bbs.sogua.com','686','2','0','0','0','0','0','547','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('694','NULL','http://www.hebeimusic.com̳','686','12','0','0','0','0','0','1205','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('696','й̳','http://www.chinaharp.com/forum','686','24','0','0','0','0','0','220','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36379','ɽ','http://www.zs.gov.cn/','1856','9','0','0','0','0','0','780','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('700','̳','http://bbs.332.com/','686','14','0','0','0','0','0','641','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28837','NULL','http://music.ent.tom.com/script/bbs.html̳','686','15','0','0','0','0','0','874','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('705','й̳','http://bbs.guitarchina.com','686','16','0','0','0','0','0','852','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38303','','http://www.kkdesk.com','711','25','0','0','0','0','1','59433','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('708','NULL','http://www.ukoo.net/bbs/UKoo̳','686','10','0','0','0','0','0','214','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15333','Ϣ','http://www.zgycrs.com.cn/','1536','10','0','0','0','0','0','129','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15332','Ӣ','http://www.0951job.com/','1536','4','0','0','0','0','0','20','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41133','FT','http://www.ftchinese.com/users/goto?ccode=2G091070&pageurl=http%3A%2F%2Fwww.ftchinese.com%2F','843','19','0','0','0','0','0','0','0','','lzb','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('15329','˲','http://www.zyrc.net/','1540','13','0','0','0','0','0','487','0','','luojie','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15328','˲Ϣ','http://www.gzrc.gov.cn/','1540','2','0','0','0','0','0','3','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15327','˲','http://www.gzrs.gov.cn/','1540','1','0','0','0','0','0','1525','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15326','й˲','http://www.gyrc.com.cn/','1540','9','0','0','0','0','0','1834','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15325','ͨ˲г','http://thrc.th163.jl.cn/','1542','15','0','0','0','0','0','109','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15324','˲','http://www.ccrc.com.cn/','1542','10','0','0','0','0','0','3','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15323','˲','http://www.cctalent.com/','1542','12','0','0','0','0','0','515','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15322','˲г','http://www.jlsrc.com/','1542','5','0','0','0','0','0','597','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15321','NULL','http://www.rczx.com/˲','1542','4','0','0','0','0','0','278','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15319','NULL','http://www.jlrc.com.cn/˲','1542','3','0','0','0','0','0','491','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15313','˲','http://www.gz91.com/','1530','8','0','0','0','0','0','900','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15311','˲','http://www.jiangxirc.com/','1530','1','0','0','0','0','0','2981','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15310','','http://www.jxrenshi.gov.cn/','1530','3','0','0','0','0','0','71','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15309','˲','http://www.jxrencai.com/','1530','2','0','0','0','0','0','232','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('746','IT168̳','http://bbs.it168.com','689','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('747','NULL','http://bbs.soit.com.cn׵òƷ̳','689','6','0','0','0','0','0','155','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('750','̳','http://www.qqdc.com.cn/','689','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('752','DIY̳','http://www2.beareyes.com.cn/bbs/1.htm','689','8','0','0','0','0','0','541','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('753','NULL','http://forum.tech.sina.com.cn/?23:287̳-','689','9','0','0','0','0','0','665','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('755','ֻ̳-ֻ֮','http://bbs.imobile.com.cn','690','1','0','0','0','0','0','2','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36829','´ý','http://whb.news365.com.cn/','1886','5','0','0','0','0','0','3','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('757','ɫ-ֻרҵ̳','http://bbs.blueshow.net','690','15','0','0','0','0','0','430','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('759','18900ֻ̳','http://bbs.18900.com/discuz','690','16','0','0','0','0','0','290','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('762','ֻ','http://club.joyes.com','690','14','0','0','0','0','0','171','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('763','ֻ̳-Ѻ̳','http://it.sohu.com/94/83/column204948394.shtml','690','4','0','0','0','0','0','453','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('766','ֻ̳-˿Ƽ','http://tech.sina.com.cn/mobile/forum.html','690','5','0','0','0','0','0','324','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('767','л̳','http://bbs.military.china.com','691','2','0','0','0','0','7','39','0','','','1','0','0','0','','0');
INSERT INTO ylmf_site VALUES('768','Ѫ̳','http://bbs.tiexue.net','691','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('769','»̳','http://forum.xinhuanet.com/','691','3','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('770','þ̳','http://www.war-sky.com/forum/','691','7','0','0','0','0','0','160','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('771','̳','http://bbs.news.sina.com.cn/group.php?tree=0&gid=1','691','5','0','0','0','0','0','2066','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39941','ƿ[]','http://www.slbenfica.pt/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39942','ͼ[]','http://www.fcporto.pt/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('773','й','http://www.chinamil.com.cn/site1/gwgfsq/index.htm','691','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('775','̳ͬ','http://bbs.1931-9-18.org','691','8','0','0','0','0','0','53','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('779','߾̸','http://bbs.hnol.net/list2.asp?boardid=70','691','10','0','0','0','0','0','1696','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29101','ڰ̳','http://bbs.jinrong8.com/','693','5','0','0','0','0','0','891','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29100','Ͷ̳','http://www.tystock.com/','693','18','0','0','0','0','0','35','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29098','̳','http://www.grzq.net/cgi-bin/leobbs.cgi','693','19','0','0','0','0','0','1313','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29097','̳','http://www.55188.com/index.php','693','7','0','0','0','0','0','1400','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29096','̳','http://www.caixp.com/bbs','693','20','0','0','0','0','0','257','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32717','̳-Ż̳','http://cn.bbs.yahoo.com/forum/read_-c3RvY2sx_.html','693','10','0','0','0','0','0','556','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32718','NULL','http://www.mfzq.com.cn/','693','3','0','0','0','0','0','60','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32719','Ѷ̳','http://bbs.wayup.hexun.com/','693','2','0','0','0','0','0','1356','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('795','MACDм̳','http://bbs.macd.cn','693','4','0','0','0','0','0','66','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('796','̸۽','http://bbs.finance.sina.com.cn/tableforum/App/index.php?bbsid=62&subid=0','693','6','0','0','0','0','0','1572','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('797','ݺƾ̳','http://www.enoya.com','693','21','0','0','0','0','0','580','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('799','ͨԵ֤ȯ̳','http://bbs.i918.cn/','693','11','0','0','0','0','0','277','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29048','лװ̳','http://bbs.51fashion.com/','1935','1','0','0','0','0','0','1213','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29047','ʱзװ̳','http://bbs.nzn.cn/','1935','2','0','0','0','0','0','2191','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29046','Ůװʱ̳','http://www.suite-dress.com/bbs/','1935','4','0','0','0','0','0','1543','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29045','NULL','http://bbs.112200.cn/ʱз','1935','9','0','0','0','0','0','880','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29043','NULL','http://bbs.wears.com.cn/index.phpй̳֯','1935','3','0','0','0','0','0','392','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('29041','йŮʱ̳','http://www.mflady.com/bbs/index.php','1935','10','0','0','0','0','0','815','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33511','Ѻ','http://sports.sohu.com/lanqiu.shtml','930','5','0','0','0','0','0','9496','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33510','','http://sports.sina.com.cn/basketball/','930','4','0','0','0','0','5','21215','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32710','ע̳','http://seeker.aa.topzj.com/','1932','4','0','0','0','0','0','4624','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39960','ŻCBAר','http://sports.cn.yahoo.com/basketball/cba/index.html','930','9','0','0','0','0','0','5','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33499','ʿٿ˶','http://live.sports.tom.com/html/team/2.html','2057','5','0','0','0','0','0','4385','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33479','մɭǶ','http://live.sports.tom.com/html/team/12.html','2057','13','0','0','0','0','0','465','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('848','Ѻ','http://bbs.sports.sohu.com','697','2','0','0','0','0','0','494','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('851','̳','http://bbs1.people.com.cn/boardList.do?action=postList&boardId=30','697','6','0','0','0','0','0','5','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('853','NULL','http://forum.xinhuanet.com/listtopic.jsp?bid=50&sno=1&catid=5»','697','7','0','0','0','0','0','4','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('855','Ϸ','http://games.sina.com.cn','699','2','0','0','0','0','5','184670','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('857','Ϸ','http://game.163.com/','699','6','0','0','0','0','0','150441','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('859','̫ƽϷ','http://www.pcgames.com.cn','699','4','0','0','0','0','3','76276','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('862','','http://www.ali213.net','706','8','0','0','0','0','0','42133','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('863','Ʒսƽ̨','http://www.cga.com.cn','2068','1','0','0','0','0','0','5379','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('864','','http://games.cnool.net','699','19','0','0','0','0','0','14333','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35954','ײ','http://www.job1998.com/','958','11','0','0','0','0','0','7206','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34219','Ӿ','http://games.sina.com.cn/esports/','2068','6','0','0','0','0','0','5311','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35955','ҵĹ','http://www.myjob.com.cn/','1519','12','0','0','0','0','0','8955','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('871','켫Ϸ','http://game.yesky.com','699','9','0','0','0','0','0','19743','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('874','GameSpotվ','http://www.gamespot.com.cn/','699','8','0','0','0','0','0','16934','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35304','','http://www.ceocio.com.cn/','1668','1','0','0','0','0','0','7','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35956','Ӣ','http://www.800hr.com/','958','13','0','0','0','0','0','4455','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35957','','http://www.luoma.cn/index.htm/','958','100','0','0','0','0','0','8900','0','','lzb','0','0','1280678400','1280678400','','1');
INSERT INTO ylmf_site VALUES('884','','http://www.5617.com','699','12','0','0','0','0','0','28510','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('891','ξ','http://www.uuu9.com/','699','17','0','0','0','0','0','20261','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35245','','http://www.winddesktop.com/','711','5','0','0','0','0','1','121627','0','#000000','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38574','СϷ','http://www.mx007.com/','701','11','0','0','0','0','0','123756','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39499','007СϷ','http://www.yx007.com/','701','9','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40193','','http://www.changning.sh.cn/','1846','4','0','0','0','0','0','0','0','','luojie','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('904','88СϷ','http://www.88yx.com/','701','23','0','0','0','0','0','491261','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32441','Ѻ','http://money.business.sohu.com/fund/','1645','6','0','0','0','0','0','8111','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35676','ͨϢ','http://www.xbjtxx.com/','2195','35','0','0','0','0','0','403','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('931','17173Ϸ̳','http://bbs.17173.com','703','1','0','0','0','0','0','26581','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('932','NULL','http://games2.sina.com.cn','703','5','0','0','0','0','0','6475','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('933','̳','http://bbs.92wy.com','703','7','0','0','0','0','0','3519','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('934','ιٷ̳','http://xy2.netease.com','703','8','0','0','0','0','0','7394','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('936','52pkϷ̳','http://bbs.52pk.net','703','6','0','0','0','0','0','7031','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('937','Ϸ','http://bbs.ourgame.com','703','10','0','0','0','0','0','2484','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('939','ȷ̳','http://bbs.1t1t.com','703','2','0','0','0','0','0','2998','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('941','Ϸ','http://bbs.joyyang.com','703','11','0','0','0','0','0','2940','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('949','йϷ̳','http://bbs.chinagames.net/','703','4','0','0','0','0','0','10765','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32449','ʽÿվֵ','http://fund.eastmoney.com/fund.html','1997','1','0','0','0','0','1','1708','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40123','ʳ','http://www.chinagrain.gov.cn/','2184','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('961','17173վ','http://download.17173.com','704','1','0','0','0','0','1','132700','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('962','52pk','http://down.52pk.com/','704','2','0','0','0','0','0','79612','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('963','','http://games.sina.com.cn/download/','704','3','0','0','0','0','0','60093','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('965','켫Ϸ','http://game.mydown.com/','704','4','0','0','0','0','0','38502','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('968','Ʒ','http://www1.cga.com.cn/hfsite/down.html','704','10','0','0','0','0','0','14379','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('971','̫ƽϷ','http://dl.pcgames.com.cn/','704','8','0','0','0','0','0','69908','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('987','ѶϷ','http://games.qq.com/downlo/download.shtml','704','7','0','0','0','0','3','81739','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('993','','http://www.9you.com','699','14','0','0','0','0','0','32387','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('994','2144СϷ','http://www.2144.cn/','2253','14','0','0','0','0','0','98342','0','','ljm','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('998','131Ϸ֮','http://www.131.com/','699','16','0','0','0','0','0','11809','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('999','','http://www.92wy.com','699','18','0','0','0','0','1','11454','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1010','̫ƽϷ','http://www.pcgames.com.cn/tvgames/','706','2','0','0','0','0','0','2861','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40919','豸','http://www.shebei114.cn','1237','100','0','0','0','0','0','19','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34220','̫ƽӾ','http://fight.pcgames.com.cn/','2068','7','0','0','0','0','0','4757','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34217','','http://www.nwbbs.com/','706','7','0','0','0','0','0','119','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34216','a9vg沿','http://bbs.a9vg.com/','706','6','0','0','0','0','0','17033','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34215','ֻй','http://www.mamecn.com/','706','5','0','0','0','0','0','10019','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38550','','http://www.powereasy.net/','2113','9','0','0','0','0','0','399','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34213','','http://www.cngba.com/','706','1','0','0','0','0','0','17068','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1024','PSP','http://www.psper.net/','706','9','0','0','0','0','0','2333','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32462','ٶȲƾ','http://finance.baidu.com/','843','8','0','0','0','0','2','74071','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40634','翼̳','http://bbs.kuakao.com/','2265','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32458','й֤ȯ','http://www.cnstock.com/','1649','1','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32457','ײƾ','http://money.163.com/','843','9','0','0','0','0','2','76737','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1035','ͼ','http://pic.daqi.com','709','2','0','0','0','0','1','63806','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40608','ѧϰ','http://www.pallasa.com','966','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40300','й','http://www.totochina.com','817','6','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1039','ͼ','http://www.tucoo.com','2107','4','0','0','0','0','1','35165','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32230','̳','http://bbs.qianlong.com/','675','21','0','0','0','0','0','5364','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40515','ͰͼŮվ','http://www.92tu.com/','710','8','0','0','0','0','0','2','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1047','йѧͼƬ','http://www.6to23.com/pic/','709','10','0','0','0','0','1','54401','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32229','̳','http://club.dayoo.com/','675','20','0','0','0','0','0','10','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35070','ڰ','http://www.heibai.net/','1139','5','0','0','0','0','0','3703','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1054','ChinaRenͼ','http://pic.chinaren.com','709','11','0','0','0','0','0','37444','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39969','۴Ͻ','http://bm.hc360.com/','1189','3','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32228','йѧ','http://city.6to23.com/','675','35','0','0','0','0','0','4187','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1069','22mmŮд','http://www.22mm.cc/','710','2','0','0','0','0','0','213721','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40601','3887СϷ','http://www.3887.com/','2253','6','0','0','0','0','0','1','0','','lzb','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('35381','йϢ','http://www.bm.cei.gov.cn/','1189','12','0','0','0','0','0','10','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32514','Ժ','http://bjgy.chinacourt.org/flyz/','2207','20','0','0','0','0','0','205','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1096','̶','http://desk.shangdu.com','711','23','0','0','0','0','0','38149','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1100','й','http://www.cnscreen.com/','712','6','0','0','0','0','0','29063','0','','xiaoku','0','0','1290009600','1290009600','','1');
INSERT INTO ylmf_site VALUES('34403','̳','http://bbs.digi.163.com/board/postlist.jsp?b=dc','800','1','0','0','0','0','0','2670','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34402','TOMPDAֻ̳','http://bbs.tompda.com/','800','5','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34390','ѧԺ','http://www.arch.ethz.ch/','1336','4','0','0','0','0','0','26','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34386','˹ѧ','http://www.ul.pt/','1337','1','0','0','0','0','0','27','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34385','ɴѧ','http://www.fu-berlin.de/','1341','12','0','0','0','0','0','28','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34171','wo99෭','http://www.wo99.com/','719','100','0','0','0','0','1','19902','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35306','ձ','http://chinese.wsj.com/','1668','6','0','0','0','0','0','36','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1146','Ѻ','http://music.sohu.com','717','9','0','0','0','0','0','65518','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1152','KuGouṷ','http://download.kugou.com/20101224/','717','3','0','0','0','0','0','633407','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1153','й','http://www.guitarchina.com','1680','22','0','0','0','0','0','21564','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34170','NULL','http://www.fenbei.com/ֱ','719','101','0','0','0','0','0','3560','0','','lzb','0','0','0','1241452800','','1');
INSERT INTO ylmf_site VALUES('1164','ſ','http://www.9ku.com/','716','107','0','0','0','0','4','85826','0','','ylmf','0','0','1281974400','1281974400','','1');
INSERT INTO ylmf_site VALUES('1169','QQ163 ','http://www.qq163.com/','716','2','0','0','0','0','1','582797','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35981','пƼѧ','http://www.hust.edu.cn/','951','14','0','0','0','0','0','49','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34169','','http://www.stsky.com/','716','15','0','0','0','0','2','172291','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1189','һ','http://www.yiqilai.com/','716','112','0','0','0','0','0','181207','0','','lzb','0','0','1281888000','1281888000','','1');
INSERT INTO ylmf_site VALUES('34182','̳','http://bbs.democn.com/','686','13','0','0','0','0','0','1909','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34166','','http://www.ssjj.com','716','120','0','0','0','0','0','90746','0','','lzb','0','0','1281888000','1281888000','','1');
INSERT INTO ylmf_site VALUES('23299','ɽ','http://www.wulingshan.com.cn/','1797','100','0','0','0','0','0','1760','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41268','','http://www.j.cn/?uc=2309&type=text','908','13','0','0','0','0','0','0','0','','liao','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35987','Ӣѧϰ','http://www.wwenglish.com/','1045','8','0','0','0','0','0','133','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36828','ϺƱ','http://www.swlc.sh.cn/','1886','4','0','0','0','0','0','542','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1243','NULL','http://www.skyfc.com/շ','719','111','0','0','0','0','0','14631','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1244','ַ','http://www.yyfc.com','719','1','0','0','0','0','3','63065','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40310','¿','http://www.xker.com/','1124','10','0','0','0','0','0','0','0','','LZB','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11314','Ȥ','http://promotion.eachnet.com/09q2ad/?adid=bjmt_mta_01_0_hp_25828','852','3','0','0','0','0','0','5297','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40579','йƵ','http://www.zghbpd.com/','1247','27','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35979','Ͼѧ','http://www.nju.edu.cn/cps/site/newweb/foreground/','951','13','0','0','0','0','0','1214','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28836','Ʒ̳','http://club.xialala.com/','686','1','0','0','0','0','0','6797','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35980','йѧѧ','http://www.ustc.edu.cn/zh_CN/','951','15','0','0','0','0','0','779','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39516','ϲƸ','http://www.ncfccf.com/','1775','100','0','0','0','0','0','384','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1320','Ѻ','http://mil.news.sohu.com','726','12','0','0','0','0','12','65947','0','','','1','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1321','˾','http://mil.news.sina.com.cn/','726','4','0','0','1','1','53','134619','0','','','1','2','0','0','','0');
INSERT INTO ylmf_site VALUES('1323','ǧ','http://mil.qianlong.com','726','13','0','0','0','0','7','115730','0','','','1','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1326','Ѫ','http://www.tiexue.net','726','3','0','0','0','0','0','6097','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1328','й','http://www.chinamil.com.cn','726','16','0','0','0','0','1','34423','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34590','̳','http://bbs.cntv.cn/','675','14','0','0','0','0','0','3540','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32281','ֻ̳','http://a1.timewe.net/cdr/wap.18jw.com','2027','2','0','0','0','0','0','334','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34055','йԺ','http://www.coddc.com/','1672','4','0','0','0','0','0','1453','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32274','ͼ','http://a.timewe.net/cdr?s=wap.55kt.cn','1600','1','0','0','0','0','0','4087','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1353','л̳','http://club.china.com/data/threads/12171906/','727','1','0','0','0','0','0','118321','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1354','Ѫ̳','http://bbs.tiexue.net','727','2','0','0','0','0','0','6898','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1355','NULL','http://forum.xinhuanet.com/listtopic.jsp?bid=92»̳','727','101','0','0','0','0','0','4285','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40055','侯ɶָѧԺ','http://www.wjcd.net/','2168','12','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1359','й','http://www.chinamil.com.cn/site1/gwgfsq/index.htm','727','10','0','0','0','0','0','7428','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1361','̳','http://junshi.daqi.com/','727','4','0','0','0','0','2','9915','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35293','ȫ','http://www.gxfa.com/','1139','14','0','0','0','0','0','1080','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35296','йȫϢ','http://www.hacker.cn/','1139','9','0','0','0','0','0','1338','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38393','ϷɽҽԺ','http://www.hfzs.com','1732','7','0','0','0','0','0','193','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41386','йͯ','http://www.cctf.org.cn/','1006','4','0','0','0','0','0','0','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17709','ŷ֯','http://www.sinotex.net/','1218','52','0','0','0','0','0','5','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35944','й˲','http://www.cjol.com/','958','3','0','0','0','0','0','26260','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1413','ѶЦ','http://joke.qq.com','732','1','0','0','0','0','0','164917','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1415','','http://www.igogo8.com/','732','12','0','0','0','0','0','154219','0','','lzb','0','0','0','1288886400','','1');
INSERT INTO ylmf_site VALUES('1417','ܸЦ','http://www.hengaoxiao.com/','732','5','0','0','0','0','0','242868','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1420','','http://www.xxhh.net/','732','4','0','0','0','0','12','660368','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38259','Ц','http://www.gxdxw.cn','769','8','0','0','0','0','0','10564','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1425','վ','http://www.kxx.cc/','732','6','0','0','0','0','0','103203','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32208','NULL','http://www.kaicn.com/index.html','777','110','0','0','0','0','0','23467','0','','lzb','0','0','1282060800','1282060800','','1');
INSERT INTO ylmf_site VALUES('1464','NULL','http://www.jiongbuyi.cn/岻','733','102','0','0','0','0','0','27510','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38267','ԭ','http://www.0438cn.com','1893','46','0','0','0','0','0','355','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32328','','http://www.9tour.cn/','892','7','0','0','0','0','0','3906','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1474','Ѷ-ʱ','http://luxury.qq.com','735','3','0','0','0','0','2','35929','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1484','ʱ','http://www.trends.com.cn/','735','1','0','0','0','0','0','37164','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1512','','http://www.27.cn/','736','3','0','0','0','0','0','53117','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35129','ʱװ֮Է-ELLE','http://www.ellechina.com/','738','1','0','0','0','0','0','115','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32779','ޢ-Lancome','http://www.lancome.com.cn/_zh/_cn/index.aspx','737','2','0','0','0','0','0','3303','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1526','ŷ-Loreal','http://www.lorealparischina.com','737','1','0','0','0','0','2','13773','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1527','ŷ-Avon','http://www.avon.com.cn/PRSuite/home/home.jsp','737','9','0','0','0','0','0','5419','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1529','ά-Nivea','http://www.nivea.com/','737','11','0','0','0','0','0','2096','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1530','-Shiseido','http://www.shiseido.com.tw','737','4','0','0','0','0','0','6650','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1531','֮','http://www.tayoi.com/','737','19','0','0','0','0','0','1823','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1532','ʫ-Esteelauder','http://www.esteelauder.com','737','10','0','0','0','0','0','3015','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1534','õտ-Marykay','http://www.marykay.com.cn/','737','16','0','0','0','0','0','6604','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1535','ζ-Chanel','http://www.chanel.com/','737','3','0','0','0','0','0','980','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1544','ٻ-Clinique','http://www.clinique.com.cn/index.tmpl?ngextredir=1','737','8','0','0','0','0','0','1735','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1545','ֲ','http://www.shu-uemura.co.jp','737','15','0','0','0','0','0','1320','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1546','ϰ-ChristianDior','http://www.dior.com/pcd/International/JSP/Home/prehomeFlash.jsp','737','17','0','0','0','0','0','1951','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1547','Ettusaisż','http://www.ettusais.co.jp','737','20','0','0','0','0','0','288','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40081','۾','http://www.formosa-optical.com.tw/','1871','22','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35141','VOGUEʱ','http://www.vogue.com.cn/','738','19','0','0','0','0','0','23','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35139','FLARE[Ӣ]','http://www.flare.com/','738','17','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35138','Marie Claire[]','http://www.marieclaire.com/','738','16','0','0','0','0','0','512','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35137','Figaro madame[]','http://madame.lefigaro.fr/','738','15','0','0','0','0','0','515','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35135','ʱ.','http://www.trendsmag.com/trendsmag/cosmogirl/','738','9','0','0','0','0','0','8937','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35134','־','http://www.metropolis-mag.com/','738','8','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35133','JESSICA','http://www.jessicahk.com/','738','6','0','0','0','0','0','7409','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35132','ʱ','http://esquire.trends.com.cn/','738','5','0','0','0','0','0','5252','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35130','BAZAAR-ʱаɯ','http://www.trendsmag.com/trendsmag/bazaar/','738','2','0','0','0','0','0','11441','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40404','','http://www.tieliu.com.cn/','2240','100','0','0','0','0','0','12','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1576','GQ[]','http://www.gq.com.cn/','738','14','0','0','0','0','0','5692','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1581','ʱ','http://www.mensuno.com.tw','738','12','0','0','0','0','0','17972','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32755','ȫ','http://www.all2car.com/','1171','17','0','0','0','0','0','1576','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1597','ͳ','http://www.fantong.com','739','4','0','0','0','0','2','33132','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1600','39ʳƵ','http://food.39.net/','739','16','0','0','0','0','0','25418','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1602','ѺԺ','http://chihe.sohu.com/','739','10','0','0','0','0','0','15689','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1610','','http://www.gudumami.cn/','739','12','0','0','0','0','0','15098','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1626','123ʳ','http://www.haochi123.com/','739','18','0','0','0','0','0','8387','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1645','','http://www.caipopo.com/','739','11','0','0','0','0','0','25406','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1646','ʳ','http://www.spos.com.cn/','739','19','0','0','0','0','0','10187','0','','lzb','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('35226','¿','http://www.aokang.com.cn/','1871','57','0','0','0','0','0','780','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35224','˫','http://www.doublestar.com.cn/','1871','54','0','0','0','0','0','1262','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35223','ޱ','http://www.robinhood.com.cn/','1871','54','0','0','0','0','0','930','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35222','','http://www.cnhqt.com/','1871','53','0','0','0','0','0','3488','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35221','','http://www.fuguiniao.com/','1871','30','0','0','0','0','0','1158','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35220','-Kappa','http://www.kappa.com.cn/','1871','51','0','0','0','0','0','5264','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35219','ά˹','http://www.jeanswest.com/','1871','50','0','0','0','0','0','174','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35218','˼ͼ-STACCATO','http://www.staccato.com/','1871','49','0','0','0','0','0','1406','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35217','ǧٶ','http://www.c-banner.com/','1871','48','0','0','0','0','0','2795','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35216','ܽ','http://www.daphne.com.cn/','1871','47','0','0','0','0','0','4825','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40122','ҵ','http://www.saac.gov.cn/','2184','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35214','˹','http://www.metersbonwe.com/','1871','45','0','0','0','0','0','5302','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33149','й̱ע','http://www.1628.cn/','1880','1','0','0','0','0','0','619','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35213','ɭ','http://www.chinasenda.com/','1871','44','0','0','0','0','0','896','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35160','','http://www.meishichina.com/Topic/CaiXi/MinCai/','2080','5','0','0','0','0','0','6200','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39937','NULL','http://www.asm-foot.mc/Ħɸ[]','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39938','[]','http://www.olympiquedemarseille.com/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1681','Ƶ','http://www.xiazaiba.com/html/29.html','742','10','0','0','0','0','0','26928','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32610','й̳','http://www.cntrbbs.com/','1933','3','0','0','0','0','0','923','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32609',';','http://bbs.lotour.com/','1933','7','0','0','0','0','0','488','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1705','','http://www.e58.net','792','5','0','0','0','0','1','33486','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32608','','http://bbs.okgx.com/','1933','8','0','0','0','0','0','330','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32607','̳-','http://bbs.gotoworld.net/','1933','5','0','0','0','0','0','530','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32606','̳','http://www.dayout.com.cn/','1933','9','0','0','0','0','0','452','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32605','Ѻ-Ѻ','http://club.travel.sohu.com/','1933','4','0','0','0','0','0','293','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32604','ctripЯ','http://www.ctrip.com/Community/CommunityHome.asp','1933','1','0','0','0','0','0','609','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34710','8684ѯ','http://www.8684.cn/','1659','4','0','0','0','0','0','223','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1721','','http://www.xiazaiba.com/html/535.html','744','7','0','0','0','0','0','15930','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1722','Skypeͨ','http://www.myler.cn/other/love.htm','744','3','0','0','0','0','0','10851','0','green','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1723','UC','http://www.xiazaiba.com/html/13.html','744','4','0','0','0','0','0','53681','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1724','ICQ','http://www.icq.com','744','100','0','0','0','0','0','2035','0','','xiaoku','0','0','1287849600','1287849600','','1');
INSERT INTO ylmf_site VALUES('1725','΢MSN','http://www.xiazaiba.com/html/15.html','744','2','0','1','0','0','0','227092','4','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28523','Google Talk','http://www.google.com/talk/','744','12','0','0','0','0','0','1493','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1735','','http://www.liaoliao.com','742','5','0','0','0','0','4','35209','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('37328','ݷز','http://www.bona.net.cn/','1912','23','0','0','0','0','0','410','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36770','ӰѶ','http://ent.sina.com.cn/movie/dianying/','1885','46','0','0','0','0','0','992','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1744','Ƶ','http://show.sina.com.cn/','742','2','0','0','0','0','0','64143','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40071','Ϻ','http://www.xiami.com','686','20','0','0','0','0','0','4','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40445','л񹲺͹','http://www.moh.gov.cn/','2252','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33145','ձNHK','http://www.nhk.or.jp/','749','7','0','0','0','0','1','13337','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33144','CNN','http://www.cnn.com/','749','7','0','0','0','0','0','1','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33143','̨TTV','http://www.ttv.com.tw/','749','7','0','0','0','0','0','3297','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1759','Ϸ̨','http://www.tvscn.com','749','10','0','0','0','0','0','2009','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1761','̨ͥCETV','http://www.cetv.com','749','9','0','0','0','0','0','2137','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1762','ǿ','http://www.xingkong.com.cn','749','11','0','0','0','0','0','17693','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1763','̽','http://www.discoverychannel.com.cn','749','100','0','0','0','0','0','2469','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1765','','http://www.tctc.com.cn','749','12','0','0','0','0','0','2741','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1766','Channel V','http://www.vchinese.com','749','9','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1767','','http://www.tvcn.com.cn','749','100','0','0','0','0','0','12977','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1768','ǵ','http://www.tvworld.com.cn','749','100','0','0','0','0','0','17737','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1770','ӢBBC','http://www.bbcworld.com','749','7','0','0','0','0','0','6067','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1771','ȫѶ','http://www.ctv.com.tw/','749','100','0','0','0','0','0','940','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33142','뵺̨','http://www.aljazeera.net/','749','100','0','0','0','0','0','11760','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1777','ѺTVƵ','http://yule.sohu.com/tv.shtml','749','100','0','0','0','0','0','2332','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36321','ͨ','http://www.cttyn.com','2092','18','0','0','0','0','0','53','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40037','չ','http://www.chinaxly.cn/','890','4','0','0','0','0','0','0','0','','lzb','0','0','1288800000','1288800000','','1');
INSERT INTO ylmf_site VALUES('1847','NULL','http://www.zzcatv.com.cn֣ߵ̨','1616','100','0','0','0','0','0','414','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1848','Ͼʱ','http://www.njcatv.net','1369','100','0','0','0','0','0','564','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40367','sohuɳ','http://club.women.sohu.com/womenmain.php?c=4&b=fitness','2234','7','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32282','ܸ','http://a1.timewe.net/cdr/huohuo.cn','2028','7','0','0','0','0','0','1261','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1851','NULL','http://www.wharfcable.comߵ','1393','100','0','0','0','0','0','3554','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1853','ൺߵ̨','http://www.qingdaomedia.com/','1366','100','0','0','0','0','0','1555','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33267','ξ','http://www.enit.it/','2052','16','0','0','0','0','0','302','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33180','޹㲥̨̨','http://www.abc.net.au/ra/chinese/','754','14','0','0','0','0','0','1052','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35241','йʹ㲥̨','http://www.chinabroadcast.cn/','754','2','0','0','0','0','0','1550','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33175','Ժ','http://bjgy.chinacourt.org/','914','6','0','0','0','0','0','459','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33174','Ϲ㲥̨̨','http://www.un.org/chinese/radio/','754','7','0','0','0','0','0','843','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1865','̨','http://www.minidiantai.com/','756','2','0','0','0','0','0','1065','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36825','Ϻ','http://www.online.sh.cn/','1886','1','0','0','0','0','0','243','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36298','NULL','http://www.cttln.comͨ','2092','104','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33170','̨Ŀ㲥','http://www.radio.cn/yhtdb/','756','7','0','0','0','0','0','1320','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35240','ʹ㲥̨','http://world.kbs.co.kr/chinese/','754','12','0','0','0','0','0','1499','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1871','̨','http://www.nihaotw.com','756','15','0','0','0','0','0','860','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1872','й㲥-֮','http://musicradio.cnr.cn','756','4','0','0','0','0','0','2828','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1873','Channel V','http://www.vchinese.com','756','5','0','0','0','0','0','3996','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33165','֪ʶȨ','http://www.jxipo.gov.cn/','2208','20','0','0','0','0','0','79','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1877','NULL','http://www.tinggb.com㲥','756','112','0','0','0','0','0','4615','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('15733','ձNHK㲥̨','http://www.nhk.or.jp/daily/chinese/','754','6','0','0','0','0','1','2575','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33198','շԺ','http://www.ahcourt.gov.cn/','914','15','0','0','0','0','0','38','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33164','й㲥','http://www.cnr.cn/','756','3','0','0','0','0','0','2884','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1883','ȥȥСϷ','http://www.7k7k.com','759','5','0','0','0','0','0','20883','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1885','NULL','http://www.9flash.com9Flash','758','10','0','0','0','0','0','9935','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1887','͵۹','http://www.flashempire.com/','758','2','0','0','0','0','1','38075','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1888','Ϳ','http://www.vlike.com','758','9','0','0','0','0','0','10270','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39944','ŵaek[ϣ]','http://www.aekfc.gr/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38700','ɹСϷ','http://www.cgdac.com/','701','20','0','0','0','0','0','204803','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1896','TOMƵ','http://flash.tom.com','758','3','0','0','0','0','0','30116','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1909','ˮ','http://www.pacoo.net','758','11','0','0','0','0','0','10211','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41013','켫Ⱥ','http://q.yesky.com','675','48','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1921','TOMϷ','http://games.tom.com/','759','9','0','0','0','0','1','26154','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1922','СϷ','http://www.xiaoyouxi.cn','759','2','0','0','0','0','0','77470','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1923','-СϷ','http://games.sina.com.cn/downgames/littlegame','759','7','0','0','0','0','0','20122','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1924','21CNСϷ','http://game.21cn.com/mini','759','5','0','0','0','0','0','13997','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1927','СϷ','http://www.youxiba.com','759','13','0','0','0','0','0','53216','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34440','͵۹-ѧ','http://www.flashempire.com/school/index.php','760','1','0','0','0','0','0','6437','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41205','Foxmail','http://www.xiazaiba.com/html/123.html','2290','1','0','0','0','0','0','0','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1957','лflash','http://tech.china.com/zh_cn/netschool/homepage/flash','760','2','0','0','0','0','0','6778','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34441','Flash8ɽ̲','http://www2.flash8.net/teach/','760','3','0','0','0','0','0','6523','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1963','̫ƽ-Flash̳','http://www.pconline.com.cn/pcedu/sj/wz/flash/index.html','760','5','0','0','0','0','0','3096','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32530','FlashƵ̳','http://www.enet.com.cn/eschool/includes/zhuanti/flash1130/','760','4','0','0','0','0','0','13777','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('1981','͵۹̳','http://www.flashempire.net/','762','1','0','0','0','0','0','783','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36619','пƴ嫺վ','http://bbs.ustc.edu.cn/','2078','13','0','0','0','0','0','118','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38470','ǿ','http://www.joekoe.com/','2113','10','0','0','0','0','0','230','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34208','52PKСϷ','http://flash.52pk.com/','701','13','0','0','0','0','0','80102','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2056','ֻƵ','http://mobile.163.com','766','9','0','0','0','0','0','27040','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2057','ֻ֮','http://www.imobile.com.cn','766','1','0','0','0','0','0','197350','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2058','̫ƽֻ','http://mobile.pconline.com.cn/','766','2','0','0','0','0','0','73746','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2059','','http://www.younet.com/','766','18','0','0','0','0','0','56830','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35377','ħֻ','http://www.moxiu.com/','700','12','0','0','0','0','0','14826','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2064','3533ֻ','http://www.3533.com/','766','12','0','0','0','0','0','10140','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34358','915ֻƵ','http://www.915.com/news/','766','5','0','0','0','0','0','16928','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2073','IT168ֻ','http://mobile.it168.com','766','6','0','0','0','0','0','3344','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34355','ֻ԰','http://www.shouji.com.cn/','766','14','0','0','0','0','0','18520','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2083','ֻ','http://mobile.pcpop.com/','766','4','0','0','0','0','0','19929','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2084','ѺֻƵ','http://digi.it.sohu.com/mobile.shtml','766','8','0','0','0','0','0','21454','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2085','ֻ̳֮','http://bbs.imobile.com.cn','767','1','0','0','0','0','0','3987','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32179','ѶϷ','http://games.qq.com/','699','13','0','0','0','0','0','160933','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2090','ֻ̳','http://bbs.dospy.com/','767','2','0','0','0','0','0','233','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2091','ٷ̳','http://bbs.meizu.com/','767','3','0','0','0','0','0','10407','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2092','Ħֻ̳','http://www.motobbs.com','767','7','0','0','0','0','0','16726','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2097','ŵ','http://www.nokia.com.cn','768','1','0','0','0','0','0','7549','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2098','Ħ','http://www.motorola.com.cn','768','3','0','0','0','0','0','6969','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2099','ᰮ','http://www.sonyericsson.com','768','2','0','0','0','0','1','30395','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2100','','http://www.samsung.com.cn','768','6','0','0','0','0','0','8','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2103','','http://www.siemens.com','768','7','0','0','0','0','0','577','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2106','iPhone','http://www.apple.com.cn/iphone/','768','4','0','0','0','0','0','5160','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2109','','http://www.meizu.com/cn/m8.html','768','9','0','0','0','0','0','3633','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2121','ֻ','http://www.lenovomobile.com/','768','5','0','0','0','0','0','8316','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36684','Ʒۿ','http://www.shopin.net/index.html?utm_source=114la&utm_medium=091001&utm_campaign=shopin&cid=114la091001','852','24','0','0','0','0','0','6922','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2135','մ','http://www.dopod.com/','768','10','0','0','0','0','0','508','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2136','LG','http://www.lg.com.cn/','768','12','0','0','0','0','0','514','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2138','HTC','http://www.htc.com/hk-tc/','768','13','0','0','0','0','0','294','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2143','','http://www.philips.com.cn/','768','8','0','0','0','0','0','79','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36679','ຣְҵѧԺ','http://www.qhpolice.edu.cn/','1317','5','0','0','0','0','0','79','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2146','ͼ쳵','http://mmscode1.3bu.com/mmscode/fullscreen/02261017556997866535.htm?id=02261017556997866535&serviceId=100001&webownerId=11854','769','3','0','0','0','0','0','8622','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2147','˻','http://cl.sina.com.cn','769','2','0','0','0','0','0','8141','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11321','TomPDAֻ̳','http://bbs.tompda.com/','767','9','0','0','0','0','0','5296','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2160','ֻ','http://product.pcpop.com/Mobile/00000_1.html','770','4','0','0','0','0','0','11256','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2165','йشֻ','http://mobile.zol.com.cn/more/2_427.shtml','770','2','0','0','0','0','0','8933','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2168','̫ƽֻ','http://product.pconline.com.cn/mobile/','770','1','0','0','0','0','0','54997','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30227','3GPֻӰ','http://www.3gp.cn/','700','7','0','0','0','0','0','33964','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30221','ͨŲҵ','http://www.ccidcom.com/','774','2','0','0','0','0','0','887','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30218','CCTIME','http://www.cctime.com/','774','9','0','0','0','0','0','590','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30217','-ͨ','http://telecom.chinabyte.com/','774','3','0','0','0','0','1','493','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30216','йͨ','http://www.c114.net/','774','4','0','0','0','0','3','1710','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30215','йͨ','http://www.cnii.com.cn/','774','5','0','0','0','0','0','888','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30214','̩-ͨҵ','http://www.catr.cn/','774','10','0','0','0','0','0','333','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40052','йϢҵ','http://www.cnii.com.cn/','774','6','0','0','0','0','1','2','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2220','ͨ','http://comm.ccidnet.com','774','1','0','0','0','0','1','825','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2222','ͨѶ','http://tech.sina.com.cn/tech','774','7','0','0','0','0','1','756','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2229','йƶ','http://www.chinamobile.com/','775','1','0','1','0','0','0','132111','29','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2230','йͨ','http://www.chinaunicom.com','775','2','0','0','0','0','0','3054','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2231','Ѷ','http://www.hexun.com/','1642','1','0','1','0','0','0','124375','46','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2233','','http://www.tianya.cn/','675','1','0','1','0','0','0','124675','31','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2234','йͨ','http://www.chinatietong.com/','775','4','0','0','0','0','0','1713','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2236','ѶƵ','http://comic.qq.com','777','1','0','0','0','0','1','65413','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32214','MSN','http://astro.msn.com.cn/','784','11','0','0','0','0','0','38692','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2244','ѺƵ','http://comic.chinaren.com','777','5','0','0','0','0','0','31138','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2245','Ӷ','http://comic.boxuu.com/','777','12','0','0','0','0','0','22963','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2246','Ѹ׶','http://anime.xunlei.com/','777','7','0','0','0','0','0','30128','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34302','ߴ','http://comic.qq.com/z/gseedd','779','4','0','0','0','0','0','2908','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2252','ԭ','http://www.u17.com/','777','20','0','0','0','0','0','28706','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2260','춯','http://dongman.xiaoyouxi.com/','777','19','0','0','0','0','0','38638','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32212','TOM','http://astro.tom.com/','784','3','0','0','0','0','2','104912','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2281','Ӱ','http://bt.ktxp.com/','778','2','0','0','0','0','0','243','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2284','԰BT','http://share.dmhy.org/','778','1','0','0','0','0','0','10223','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23300','Բ԰','http://www.yuanmingyuanpark.com/','1797','100','0','0','0','0','0','5460','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34329','ѩ','http://comic.fxdm.net/','777','116','0','0','0','0','0','28929','0','','lzb','0','0','1282060800','1282060800','','1');
INSERT INTO ylmf_site VALUES('39328','С˵','http://www.yousheng8.com/index.htm','1018','10','0','0','0','0','0','1191','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36680','ຣְͨҵѧԺ','http://www.qhctc.edu.cn/','1317','6','0','0','0','0','0','46','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2357','Ѷ','http://astro.lady.qq.com','784','6','0','0','0','0','17','245002','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2358','','http://astro.sina.com.cn','784','1','0','0','0','0','29','519646','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2359','Ż','http://cn.astrology.yahoo.com','784','4','0','0','0','0','16','129420','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2360','','http://www.cexing.com/','784','100','0','0','0','0','0','47946','0','','lzb','0','0','1288800000','1288800000','','1');
INSERT INTO ylmf_site VALUES('2363','21CN','http://life.21cn.com/horoscope/horoscope/','784','10','0','0','0','0','0','30452','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2364','һ','http://www.d1xz.net','784','8','0','0','0','0','0','174065','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2367','','http://lady.163.com/special/00261PJK/constellation.html','784','2','0','0','0','0','0','148087','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2382','','http://www.51jixiang.com/','785','15','0','0','0','0','0','71078','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2386','оԺ','http://www.gjzy.com','2101','3','0','0','0','0','0','8838','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2399','ѶˮФ','http://astro.qq.com/omens/omen.shtml','786','2','0','0','0','0','1','63740','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2400','ѺФ','http://astro.sohu.com/shengxiao.shtml','786','1','0','0','0','0','2','86895','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2401','','http://astro.sina.com.cn/test','787','1','0','0','0','0','0','127322','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2402','רҵȫ','http://www.psy-test.net','787','3','0','0','0','0','1','113389','0','','','1','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32497','й','http://www.auto18.com/','1662','6','0','0','0','0','0','7294','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36610','йѧ˴BBS','http://bbs.ruc.edu.cn/','2078','3','0','0','0','0','0','523','0','','LWH','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33981','ô⽻[]','http://www.dfait-maeci.gc.ca/','1834','100','0','0','0','0','0','39','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32811','Ҿ','http://sunbala.cn/ehome/','879','14','0','0','0','0','0','4750','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38249','Ļ','http://www.shooter.com.cn/','1980','14','0','0','0','0','0','15835','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32264','Yokaʱ','http://www.yoka.com/','735','4','0','0','0','0','0','19183','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32247','','http://www.renren.com/','669','7','0','0','0','0','0','681','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32246','΢','http://sina.allyes.com/main/adfclick?db=sina&bid=182025,227294,232314&cid=0,0,0&sid=221328&advid=3406&camid=32727&show=ignore&url=http://t.sina.com.cn/?c=spr_web_sq_114la_weibo_t001','2294','1','0','0','0','0','0','7694','0','red','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32240','̳','http://szbbs.sznews.com/','675','44','0','0','0','0','0','14','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32239','̳','http://bbs.hangzhou.com.cn/','675','39','0','0','0','0','0','2404','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32238','ൺ','http://club.qingdaonews.com/','675','38','0','0','0','0','0','41','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32237','ˮľ','http://www.newsmth.net/','675','33','0','0','0','0','0','5439','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32236','½','http://www.xilu.com/','675','18','0','0','0','0','4','9744','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32235','19¥̳','http://www.19lou.com/','675','31','0','0','0','0','0','7938','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32219','Ѷ','http://ent.qq.com/','659','4','0','0','0','0','0','157292','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32217','Ѷռ','http://astro.lady.qq.com/tarot/','785','19','0','0','0','0','1','58687','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32216','','http://www.1518.com/xzpd/index.html','784','14','0','0','0','0','0','56891','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40570','ȫ','http://www.free789.com','2142','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41163','','http://health.people.com.cn/GB/14744/index.html','2286','3','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41155','886СϷ','http://www.886.com/','701','22','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2447','ͼԵ','http://www.jiayuan.com/st/?id=3986&url=http://www.jiayuan.com/register','790','1','0','0','0','0','0','96597','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2450','׼Լ','http://idate.163.com/','790','14','0','0','0','0','0','111625','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2451','ѽ','http://www.yeeyoo.com','790','15','0','0','0','0','1','31742','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40562','ͷ','http://www.12127.net','745','10','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40705','йҵ','http://www.china3608.com/index.html','2119','10','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40560','۴Ь','http://www.shoes.hc360.com/','1212','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2469','İ','http://www.ppaiba.com/','790','19','0','0','0','0','0','9671','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2472','Ե','http://www.juyuan.com/reg/reg03index.xhtml?type=11','790','22','0','0','0','0','0','14636','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2479','ͼԵ','http://www.love21cn.com','791','100','0','0','0','0','1','440137','0','','xiaoku','0','0','1285689600','1285689600','','1');
INSERT INTO ylmf_site VALUES('30076','','http://www.d.cn/','700','1','0','0','0','0','0','9997','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40856','ȫƸϢ','http://www.zph.com.cn','958','25','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2489','齻','http://www.8181.com.cn/feeling/feeling.asp','791','15','0','0','0','0','0','37317','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2490','','http://www.loveinhere.com','790','17','0','0','0','0','1','29268','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2496','NULL','http://i.263.netI-263','792','109','0','0','0','0','0','28594','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39876','591','http://www.591wed.com','791','14','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2501','֪','http://www.zhiyin.com.cn/','792','1','0','0','0','0','0','7583','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30027','','http://www.wealink.com/','790','12','0','0','0','0','0','6438','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30022','ٺ','http://jump.all4ad.cn/jump.aspx?id=745','790','10','0','0','0','0','0','69273','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30019','','http://www.tianya.cn/publicforum/articleslist/0/feeling.shtml','792','2','0','0','0','0','1','52965','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30018','','http://www.27.cn/qgsh/index.html','792','3','0','0','0','0','0','44828','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30017','','http://eladies.sina.com.cn/feel/index.shtml','792','4','0','0','0','0','3','53370','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('30016','-ѺŮ','http://women.sohu.com/hunyinjiating.shtml','792','8','0','0','0','0','2','66296','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30049','Ů','http://eladies.sina.com.cn/','664','6','0','0','0','0','2','114213','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41194','ձ','http://cn.wsj.com','843','21','0','0','0','0','0','0','0','','haijuan','0','0','1287244800','1287244800','','1');
INSERT INTO ylmf_site VALUES('2550','Ѻ','http://digi.it.sohu.com','796','3','0','0','0','0','0','13553','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2551','','http://tech.sina.com.cn/digi','796','4','0','0','0','0','0','12243','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2552','','http://digi.163.com','796','6','0','0','0','0','1','9004','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2553','̫ƽ','http://digital.pconline.com.cn/','796','1','0','0','0','0','0','53821','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2554','IT-','http://www.it.com.cn','796','16','0','0','0','0','0','900','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2555','','http://digi.pcpop.com','796','11','0','0','0','0','0','12494','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2558','Ѷ','http://digi.qq.com','796','5','0','0','0','0','0','6050','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2561','IT168','http://digital.it168.com','796','12','0','0','0','0','0','9965','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34365','bella','http://www.xmbella.cn/','664','124','0','0','0','0','0','29358','0','','lzb','0','0','1290614400','1290614400','','1');
INSERT INTO ylmf_site VALUES('34393','ߴѧ','http://www.unige.ch/','1336','6','0','0','0','0','0','2','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34391','ɣѧԺ','http://www.epfl.ch/','1336','5','0','0','0','0','0','8','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39808','켫','http://dc.yesky.com/','2145','2','0','0','0','0','0','210','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2602','켫MP3','http://mp3.yesky.com','799','1','0','0','0','0','0','1597','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39806','̫ƽ','http://dc.pconline.com.cn/','2145','3','0','0','0','0','0','487','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39807','IT168','http://dc.it168.com/','2145','4','0','0','0','0','0','276','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2604','MP3','http://mp3.pcpop.com/','799','10','0','0','0','0','0','604','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34401','̳','http://bbs.itime.cn/','800','3','0','0','0','0','0','2','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2609','Mp3۸߲ѯ','http://detail.zol.com.cn/price_search.php?subcatid=19','799','2','0','0','0','0','0','4254','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2611','IT168̳','http://bbs.it168.com','800','2','0','0','0','0','0','7','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34400','ڴ̳','http://bbs.pdafans.com/','800','4','0','0','0','0','0','4','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2615','̳','http://www.qqdc.com.cn/','800','6','0','0','0','0','0','11254','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2617','Ӱ-̳','http://bbs.dpnet.com.cn/bbs/','800','9','0','0','0','0','0','1707','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2620','Logitech(޼)','http://www.logitech.com.cn/','801','1','0','0','0','0','0','8','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2622','Webeye(Ӣ-)','http://www.webeye.com.cn/index.htm','801','18','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2624','','http://www.jisu.cn','801','2','0','0','0','0','1','1200','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20967','ٶ','http://www.baidu.com/index.php?tn=lqowen_4_pg','1077','0','0','0','0','0','0','9700','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20965','е','http://www.yodao.com/','1077','3','0','0','0','0','0','8587','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20964','Bing','http://cn.bing.com/','1077','9','0','0','0','0','0','4210','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2633','Ʊ','http://www.wangpiao.com/','1980','10','0','0','0','0','0','35708','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2638','-ӰƵ','http://ent.sina.com.cn/film','1980','3','0','0','0','0','1','149688','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2649','m1905Ӱ','http://www.m1905.com/vod/','1980','5','0','0','0','0','0','72186','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30631','Mtimeʱ','http://www.mtime.com/','1980','4','0','0','0','0','0','4331','0','','xiaoku','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('30630','CNTVӰ̨','http://dianying.cntv.cn/','1980','7','0','0','0','0','0','28059','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34146','й˲','http://www.buildjob.net/','1696','28','0','0','0','0','0','8263','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2665','TOM365ѵӰ','http://www.tom365.com/','805','1','0','0','0','0','5','2639679','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40295','9036ѵӰ','http://www.9036.com/','805','4','0','0','0','0','0','407','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2690','ӰBT','http://bt.ktxp.com/','1119','5','0','0','0','0','0','2312','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2691','Ӱӵ۹','http://bbs.dg2012.com/','1119','4','0','0','0','0','0','36610','0','','lzb','0','0','1282665600','1282665600','','1');
INSERT INTO ylmf_site VALUES('2698','','http://www.hunantv.com/','1377','69','0','1','0','0','0','218913','36','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2699','ɽǿ','http://sd.chinavnet.com','807','7','0','0','0','0','0','5003','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2700','ջǿ','http://js.vnet.cn/','807','8','0','0','0','0','0','6738','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2701','ջǿ','http://ah.chinavnet.com','807','9','0','0','0','0','0','2448','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2703','Ϻǿ','http://sh.chinavnet.com','807','3','0','0','0','0','0','6534','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2704','ϻǿ','http://hn.chinavnet.com','807','23','0','0','0','0','0','6351','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2705','ǿ','http://gx.chinavnet.com','807','13','0','0','0','0','1','4421','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2706','ɽǿ','http://sx.vnet.cn/','807','12','0','0','0','0','0','1439','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2708','Ĵǿ','http://sc.chinavnet.com','807','11','0','0','0','0','0','2203','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2709','㽭ǿ','http://zj.chinavnet.com','807','14','0','0','0','0','0','11329','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2710','Ļǿ','http://nx.vnet.cn/userPortal/','807','15','0','0','0','0','0','408','0','','luojie','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2711','ǿ','http://hb.vnet.cn/','807','16','0','0','0','0','0','1619','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2713','ӱǿ','http://he.vnet.cn/','807','17','0','0','0','0','0','1284','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2714','ǿ','http://fj.chinavnet.com','807','10','0','0','0','0','0','2367','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41304','5068СϷ','http://www.5068.com/','2253','13','0','0','0','0','0','0','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2717','ϻǿ','http://www.vnet.cn/yn/','807','20','0','0','0','0','0','960','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2718','ݻǿ','http://www.vnet.cn/gz/','807','21','0','0','0','0','0','895','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2719','ǿ','http://bj.vnet.cn/','807','2','0','0','0','0','0','8850','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41303','ʿ','http://www.tgbus.com/','699','25','0','0','0','0','0','3','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2723','ǿ','http://vnet.jx163.com/chpage/c1','807','22','0','0','0','0','0','3779','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2726','DVD','http://www.dvdspring.com','1980','12','0','0','0','0','0','20695','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38256','','http://www.guilin.net','1816','11','0','0','0','0','0','639','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2728','DVD','http://www.dvd288.com','1980','111','0','0','0','0','0','85332','0','','ljm','0','0','1282665600','1282665600','','1');
INSERT INTO ylmf_site VALUES('35665','4399Ϸ','http://www.4399.com/','701','1','0','0','0','0','0','137203','40','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2771','Ӱ','http://www.insun.com.cn','1980','13','0','0','0','0','0','11204','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11456','ѶֻƵ','http://digi.tech.qq.com/mobile/','766','10','0','0','0','0','0','10703','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2804','500WANƱ','http://www.500wan.com/?114la','814','10','0','0','0','0','0','1252','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40232','Ȫ','http://www.jiuquan.gov.cn/','1865','6','0','0','0','0','0','1','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2809','Ʊ','http://www.wozhongla.com/','814','4','0','0','0','0','0','72367','0','','lzb','0','0','0','1265990400','','1');
INSERT INTO ylmf_site VALUES('2813','ĿͲƱ','http://www.okooo.com/','814','6','0','0','0','0','0','52540','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2820','ɽƱ','http://www.sdcp.com.cn','815','8','0','0','0','0','0','17245','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2821','','http://www.bwlc.net','815','6','0','0','0','0','2','130433','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2822','㶫','http://www.gdfc.org.cn','815','16','0','0','0','0','0','257825','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2824','','http://www.sxfc.gov.cn','815','9','0','0','0','0','0','5291','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2825','','http://www.cwl-fj.com','815','10','0','0','0','0','0','9641','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39829','йش-','http://driver.zol.com.cn/','1118','2','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40234','','http://www.chongzuo.gov.cn/','1857','11','0','0','0','0','0','3','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2835','Ʊ2Ԫ','http://257202.cp2y.com','814','12','0','0','0','0','0','130684','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2836','ӱ','http://www.hbtcw.com','816','8','0','0','0','0','0','4859','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2837','','http://www.hljtcp.com','816','11','0','0','0','0','0','2409','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36662','㶫ѧԺ','http://www.gdppla.edu.cn/','1295','64','0','0','0','0','0','690','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2840','Ϻ','http://www.shlottery.gov.cn/','816','7','0','0','0','0','0','46166','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2842','','http://www.lntycp.com/','816','20','0','0','0','0','0','20740','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2845','','http://jltcw.net:8000/jitcw/','816','19','0','0','0','0','0','1094','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('13552','й-ʤ','http://www.lottery.gov.cn/winlose/','817','4','0','0','0','0','0','23324','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2848','','http://www.jxlottery.com','816','20','0','0','0','0','0','2588','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2850','','http://www.hnlottery.com.cn/','816','9','0','0','0','0','1','27881','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2852','','http://www.cqlottery.gov.cn','816','22','0','0','0','0','0','1361','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2856','㶫','http://www.gdlottery.cn/','816','20','0','0','0','0','0','49597','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2858','Ĵ','http://www.sclottery.gov.cn/','816','21','0','0','0','0','0','38752','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40726','ͳ','http://www.txiu.com.cn','2189','77','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('2860','','http://www.aibo123.com/','817','1','0','0','0','0','0','23620','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2868','Ѻ','http://sports.sohu.com/zuqiucaipiao.shtml','817','2','0','0','0','0','0','23163','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2870','Tom-','http://sports.tom.com/caipiao.html','817','5','0','0','0','0','0','13214','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33515','ESPNSTAR-','http://www.espnstar.com.cn/new/basketball/','930','3','0','0','0','0','0','4160','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33433','21CN-CBA','http://sports.21cn.com/basketball/cba/','930','10','0','0','0','0','0','589','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39958','ѶCBA','http://sports.qq.com/cba/','930','8','0','0','0','0','0','118','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39957','ѺCBA','http://sports.sohu.com/cba.shtml','930','7','0','0','0','0','1','174','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33425','йЭٷվ','http://www.cba.gov.cn/','930','2','0','0','0','0','1','1217','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39959','CBA','http://sports.163.com/cba/','930','1','0','0','0','0','0','208','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33423','йһŹ˾','http://www.faw.com.cn/','1641','19','0','0','0','0','0','381','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2910','й','http://www.chinapet.net','821','8','0','0','0','0','0','16608','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2915','Ϻ','http://www.shanghaipet.org','2059','2','0','0','0','0','1','5141','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38224','ոƱ','http://www.jslottery.com/','1895','34','0','0','0','0','0','785','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2917','й','http://www.chinapet.com/','821','2','0','0','0','0','0','5313','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33719','ASPӪ','http://www.aspjzy.com/','1155','10','0','0','0','0','0','428','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33718','LEARNASPEN','http://www.learnasp.com/','1155','17','0','0','0','0','0','54','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2923','è','http://www.luckycats.net','1347','6','0','0','0','0','0','3148','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35943','ǰ','http://jump.all4ad.cn/jump.aspx?id=334','958','2','0','1','0','0','0','43553','41','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40843','ղ','http://www.htscw.com','1019','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33717','ʢ','http://www.axa.com/','1640','20','0','0','0','0','0','77','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2932','','http://www.bjpet.com','2059','1','0','0','0','0','0','4531','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33716','켯','http://www.citi.com/','1640','19','0','0','0','0','0','219','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33715','й£','http://www.chinabs.net/','1155','8','0','0','0','0','0','236','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('13115','йȮ','http://www.cndog.net/','1347','1','0','0','0','0','2','50905','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2940','ѹ','http://sougou.com','1347','5','0','0','0','0','0','13241','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33707','ASP/ASP.net̫ƽѧԺ','http://www.pconline.com.cn/pcedu/empolder/wz/asp/index.html','1155','1','0','0','0','0','0','1322','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35463','˲','http://xz.185job.com/','1533','3','0','0','0','0','0','157','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2943','NULL','http://www.gz-pet.comݳ','2059','8','0','0','0','0','0','1528','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33704','ѩ','http://www.chevron.com/','1640','12','0','0','0','0','0','312','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36035','йг˶Э','http://cycling.sport.org.cn/','931','12','0','0','0','0','0','670','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36196','NULL','http://clk.oyell.cn/140/790/10528/51096/clk.clkҡ','964','101','0','0','0','0','0','6940','0','','lzb','0','0','1278864000','1278864000','','1');
INSERT INTO ylmf_site VALUES('39823','йش-','http://driver.zol.com.cn/','1102','2','0','0','0','0','0','283','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2968','йƷϢ','http://www.craftschina.net','1717','3','0','0','0','0','0','1263','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2969','NULL','http://www.parcn.com/лƷ','2061','9','0','0','0','0','0','1162','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2970','йƷ֮','http://www.lpc8.com','925','7','0','0','0','0','0','68','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35890','Ѷ-Ƶ','http://ent.qq.com/tv/','752','6','0','0','0','0','0','6131','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2978','йʻٵ','http://www.cnefs.com','2174','1','0','0','0','0','0','1020','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2984','Ʒ','http://www.szlpc.com','2061','9','0','0','0','0','0','1921','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2985','˳Ʒ','http://www.ws888.com','2061','14','0','0','0','0','0','680','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2990','йƷ','http://www.18a8.com','925','4','0','0','0','0','0','505','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40130','ԭܻ','http://www.caea.gov.cn/','2184','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('2993','㶫Ʒ','http://www.gdgifts.com','2061','8','0','0','0','0','0','2169','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21378','ϺƷ','http://www.shgifts.cn/','2061','3','0','0','0','0','0','1301','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40455','4399ҳϷ','http://web.4399.com/','2141','6','0','0','0','0','0','2','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3001','21CN','http://et.21cn.com/','825','6','0','0','0','0','1','22975','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3002','Ż','http://ent.cn.yahoo.com/','825','8','0','0','0','0','0','20554','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3003','','http://ent.sina.com.cn/','825','2','0','0','0','0','0','19089','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3005','TOM','http://ent.tom.com/star','825','99','0','0','0','0','2','11222','0','','xiaoku','0','0','1286726400','1286726400','','1');
INSERT INTO ylmf_site VALUES('3016','TOMģ','http://lady.tom.com/pic/model','826','100','0','0','0','0','0','7356','0','','lwh','0','0','1286726400','1286726400','','1');
INSERT INTO ylmf_site VALUES('3018','лģ','http://www.modelgood.com','826','1','0','0','0','0','0','8029','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40087','йϿ','http://www.51qc.com/','2176','1','0','0','0','0','1','13','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3030','ٷվ','http://www.helloziyi.com','827','2','0','0','0','0','0','29227','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3031','ٷվ','http://www.liyapeng.com','827','10','0','0','0','0','0','8636','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3032','޽վ','http://www.cuijian.com','827','12','0','0','0','0','0','833','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3034','С','http://www.shixiaolong.com','827','6','0','0','0','0','0','11957','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3035','NULL','http://www.gaoyuanyuan.comԲԲٷվ','827','13','0','0','0','0','0','13195','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3036','ƃٷվ','http://www.gongbeibi.com','827','14','0','0','0','0','0','1214','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3037','Ļٷվ','http://www.yuwenhua.com','827','15','0','0','0','0','0','1162','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3040','NULL','http://www.zhaowenzhuo.net׿','827','2','0','0','0','0','0','5859','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3041','NULL','http://www.yqzone.comȪٷվ̳','827','8','0','0','0','0','0','1934','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18056','F1ٷվ[Ӣ]','http://www.formula1.com/','933','1','0','0','0','0','0','677','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3044','ӱٷվ','http://www.janezhang.com/','827','16','0','0','0','0','0','7577','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3045','лٷվ','http://www.zhoha.com','827','21','0','0','0','0','0','642','0','','lwh','0','0','1290268800','1290268800','','1');
INSERT INTO ylmf_site VALUES('3046','ܹٷ','http://www.wanhongjie.com','827','22','0','0','0','0','0','388','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3047','Ƹ˹ٷվ','http://www.xuhonghao.com','827','23','0','0','0','0','0','319','0','','lwh','0','0','1290268800','1290268800','','1');
INSERT INTO ylmf_site VALUES('3048','NULL','http://www.donnieyen.net/bbs/Ӱ','828','7','0','0','0','0','0','3650','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3052','½ѻ','http://www.hearfish.net','828','16','0','0','0','0','3','5814','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('3055','Գ','http://www.sunyanzicc.net','828','8','0','0','0','0','0','8178','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('28017','Ρ̳','http://www.xuwei.org.cn/','827','3','0','0','0','0','0','800','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3058','ٷվ','http://www.jackiechan.com','828','5','0','0','0','0','0','7082','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3059','NULL','http://www.tonyleungcw.org-ΰ','828','10','0','0','0','0','0','3553','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3060','ɣ½','http://www.52asun.com','828','20','0','0','0','0','0','1275','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18054','NULL','http://movement.12530.com/?u=8902&uu=8902_mini/12530','769','101','0','1','0','0','0','193849','30','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3063','ѧ','http://www.jackybbs.com/','828','5','0','0','0','0','0','7087','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3065','DIDOٷ','http://www.didomusic.com','829','25','0','0','0','0','0','677','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3066','վ','http://www.westlife.cn','829','1','0','0','0','0','0','3322','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3067','ձٷվ','http://www.audreyhepburn.com','829','8','0','0','0','0','0','6631','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3068','','http://www.narajjang.com','829','10','0','0','0','0','1','20738','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3070','仪','http://www.sonyejin.org','829','32','0','0','0','0','0','2796','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3072','к','http://www.westlife.com','829','10','0','0','0','0','0','3065','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3073','ɶ','http://www.leonardodicaprio.com','829','3','0','0','0','0','0','985','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3074','Ӣٷվ','http://leeyoungae.net','829','24','0','0','0','0','0','3751','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39777','NULL','http://www.uiqq.cn/QQ','745','105','0','0','0','0','0','521','0','','lzb','0','0','1278864000','1278864000','','1');
INSERT INTO ylmf_site VALUES('3078','ͷӢĹٷWվ','http://www.thebeatles.com','829','20','0','0','0','0','0','539','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3079','Ȩ޻վ','http://www.kwonsangwoo.org/','829','26','0','0','0','0','0','2565','0','','xiaoku','0','0','1290268800','1290268800','','1');
INSERT INTO ylmf_site VALUES('3080','norahjones','http://www.norahjones.com','829','27','0','0','0','0','0','496','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3082','Ƚܿɭ','http://www.janetjackson.com/','829','28','0','0','0','0','0','2402','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3083','laurapausini','http://www.laurapausini.com','829','29','0','0','0','0','0','366','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3084','diamonٷվ','http://www.diamondrio.com','829','23','0','0','0','0','0','312','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3085','Anastacia','http://www.anastacia.com','829','22','0','0','0','0','0','255','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3086','faithhillٷվ','http://www.faithhill.com','829','20','0','0','0','0','0','241','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3087','imarobot','http://www.imarobot.com','829','19','0','0','0','0','0','326','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3090','ٷվ','http://www.myungsebin.net','829','35','0','0','0','0','0','720','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3091','ٷվ','http://www.jimcarreyonline.com','829','17','0','0','0','0','0','714','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34431','Flashԭ','http://www.flashyc.com/','758','12','0','0','0','0','0','18533','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34420','ʱ','http://www.mrmodern.com/?s_cid=114','709','14','0','0','0','0','0','111','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40319','Ƶ֮','http://www.52video.net','1237','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34417','̫ƽʱͼ','http://www.pclady.com.cn/photo/','709','9','0','0','0','0','1','37331','0','','lzb','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('3105','Ѻ','http://news.sohu.com','832','7','0','0','0','0','0','138189','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3106','Ѷ','http://news.qq.com','832','3','0','0','0','0','1','146262','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3107','','http://news.sina.com.cn','832','1','0','0','0','0','0','7503','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3108','','http://news.163.com','832','4','0','0','0','0','0','45819','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3109','TOM','http://news.tom.com','832','17','0','0','0','0','4','50001','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3110','','http://www.ifeng.com/','832','11','0','0','0','0','0','167925','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3111','籨','http://www.zaobao.com','832','27','0','1','0','0','0','27','39','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3113','','http://www.chinanews.com.cn','832','5','0','1','0','0','0','681750','8','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3114','21CN','http://news.21cn.com','832','18','0','0','0','0','3','18609','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3115','','http://www.people.com.cn','832','8','0','1','0','0','0','545103','10','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3117','й','http://www.china.com.cn/index.htm','832','12','0','0','0','0','0','21996','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3118','й','http://www.ce.cn/','832','21','0','0','0','0','0','59108','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3119','','http://www.gmw.cn','832','19','0','0','0','0','2','9160','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3120','й̨','http://www.chinataiwan.org/','832','23','0','0','0','0','0','4783','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3121','ǧ','http://www.qianlong.com','832','14','0','0','0','0','0','15673','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3122','CCTV','http://news.cctv.com/','832','10','0','0','0','0','0','71066','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3123','','http://www.eastday.com','832','15','0','0','0','0','0','779','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34715','㽭ͨ','http://www.zjt.gov.cn/','2022','12','0','0','0','0','0','15','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3127','','http://www.dayoo.com','832','13','0','0','0','0','0','816','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35682','ˮ','http://www.fruit8.com/','1233','6','0','0','0','0','0','840','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3129','','http://www.rednet.cn/','832','28','0','0','0','0','0','388','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40474','Ͻͷ','http://www.4399.com/flash/75.htm','2254','100','0','0','0','0','0','0','0','','lzb','0','0','1282665600','1282665600','','1');
INSERT INTO ylmf_site VALUES('40473','2144ɱ','http://sgs.2144.cn/','2254','102','0','0','0','0','0','0','0','','lzb','0','0','1289836800','1289836800','','1');
INSERT INTO ylmf_site VALUES('3132','Ϸ','http://www.southcn.com/','832','20','0','0','0','0','0','1035','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34714','ʡͨ','http://www.jljt.gov.cn/','2022','8','0','0','0','0','0','1','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3136','CRI','http://gb.cri.cn/','832','16','0','0','0','0','0','11712','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31917','ǹͨѶ[]','http://www.bernama.com/','2004','1','0','0','0','0','0','369','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31910','˹[]','http://www.dowjones.com/','2004','2','0','0','0','0','0','457','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3144','й','http://www.pladaily.com.cn/','832','22','0','0','0','0','0','19534','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34712','ɽʡͨ','http://www.sxjt.gov.cn/','2022','5','0','0','0','0','0','5','0','','lsz','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('3146','ʱ','http://www.huanqiu.com/','832','26','0','1','0','0','0','28835','6','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3182','йӦ','http://www.china.cn','1926','6','0','0','0','0','0','12798','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35686','йϢ','http://www.chinagrain.cn/','1231','7','0','0','0','0','0','5303','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40472','2144ʮ','http://www.2144.cn/html/11/15918/','2254','101','0','0','0','0','0','0','0','','lzb','0','0','1289836800','1289836800','','1');
INSERT INTO ylmf_site VALUES('40256','','http://www.fjsen.com/','837','14','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40257','¾','http://www.thebeijingnews.com/','837','15','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40258','Ϸб','http://www.nddaily.com/','837','16','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40259','Զб','http://yzdsb.hebnews.cn/','837','17','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40260','򱱷','http://www.enorth.com.cn/','837','18','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40261','','http://www.ycwb.com/','837','19','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40262','','http://www.yangtse.com/','837','20','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40263','ɽ','http://www.dzwww.com/','837','21','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40264','ZCOM־','http://www.zcom.com/','837','22','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40265','춼б','http://ctdsb.cnhubei.com/','837','23','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40266','ضб','http://www.sanqindaily.com/','837','24','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40267','컪','http://www.cqnews.net/','837','25','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40268','','http://www.lnd.com.cn/','837','26','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40462','ѧ','http://www.alaboyu.com','1050','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40464','ɿ쳵','http://www.lawtime.cn','913','100','0','0','0','0','0','0','0','','lzb','0','0','1284566400','1284566400','','1');
INSERT INTO ylmf_site VALUES('32704','GPS֮','http://www.55gps.com/','796','17','0','0','0','0','0','2190','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40248','ӱ','http://www.dahe.cn/','837','5','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40249','Ļ㱨','http://www.wenweipo.com/','837','6','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40250','󹫱','http://www.takungpao.com/','837','7','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40251','йձ','http://www.chinadaily.com.cn/','837','9','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40252','','http://www.gxnews.com.cn/','837','10','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40253','걨','http://bjyouth.ynet.com/','837','11','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40254','ɽ','http://www.daynews.com.cn/','837','12','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40255','','http://www.dbw.cn/','837','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3310','˲ƾ','http://finance.sina.com.cn','843','2','0','0','0','0','50','645549','0','','lzb','3','1','0','0','','0');
INSERT INTO ylmf_site VALUES('3312','йƾ','http://www.fec.com.cn','843','17','0','0','0','0','4','91254','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3315','н','http://www.cnfol.com','843','6','0','0','0','0','0','627','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40913','NULL','http://www.cnsec.com֤ȯͨ','1649','11','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3352','òƾ̳','http://www.chcj.net/bbs.php','844','7','0','0','0','0','0','1183','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3353','MACDм̳','http://bbs.macd.cn','844','6','0','0','0','0','1','23518','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3354','ɰ','http://guba.eastmoney.com/','844','1','0','0','0','0','42','98983','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3359','֤ȯ','http://www.chinastock.com.cn','845','11','0','0','0','0','0','23284','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3360','̩֤ȯ','http://www.htsc.com.cn','845','12','0','0','0','0','1','19653','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3361','㷢֤ȯ','http://www.gf.com.cn','845','8','0','0','0','0','1','28110','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3362','֤ȯ','http://www.dxzq.net/','845','30','0','0','0','0','0','1577','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3363','̩','http://www.gtja.com','845','6','0','0','0','0','0','25539','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3364','NULL','http://www.sunsc.com.cn̩֤ȯ','845','16','0','0','0','0','0','6238','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3365','֤ȯ','http://www.newone.com.cn','845','10','0','0','0','0','0','8787','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3366','֤ͨȯ','http://www.htsec.com/','845','14','0','0','0','0','1','12060','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3368','֤ȯ','http://www.ebscn.com','845','18','0','0','0','0','1','7868','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3369','֤ȯ','http://www.ghzq.com.cn','845','20','0','0','0','0','0','4508','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3371','Ͼ֤ȯ','http://www.njzq.com.cn','845','38','0','0','0','0','0','2634','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3372','֤ȯ','http://www.guosen.com','845','17','0','0','0','0','0','14378','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3373','ݸ֤ȯ','http://www.dgzq.com.cn','845','44','0','0','0','0','8','3375','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3374','֤ȯ','http://www.cs.ecitic.com/','845','15','0','0','0','0','0','11338','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3375','NULL','http://www.cc168.com.cn֤ȯ','845','52','0','0','0','0','0','4041','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3377','Ƹ֤ȯ','http://www.cfzq.com','845','47','0','0','0','0','2','2211','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3378','','http://www.bocichina.com','845','22','0','0','0','0','0','2889','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3380','֤ȯ','http://www.95579.com/','845','21','0','0','0','0','9','7776','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34808','Ļ','http://www.chinaamc.com/portal/cn/index.html','1996','1','0','0','0','0','0','41605','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40190','NULL','http://www.suzhiedu.com/ʽ','890','10','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34816','','http://www.yhfund.com.cn/','1996','9','0','0','0','0','0','7914','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34812','ɻ','http://www.dcfund.com.cn/','1996','5','0','0','0','0','0','12940','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36107','ħ̳','http://www.manutd.com.cn/forum/','1983','2','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36106','ɫԻ','http://www.manutdcn.com/','1983','1','0','0','0','0','0','583','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36109','ǹ̳','http://bbs.arsenal.com.cn/index.php','1983','3','0','0','0','0','0','545','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34814','ʱ','http://www.bosera.com/','1996','7','0','0','0','0','0','32616','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34810','ʵ','http://www.jsfund.cn/jswz/index.html','1996','3','0','0','0','0','0','30061','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34819','ʢ','http://www.csfunds.com.cn/','1996','11','0','0','0','0','0','4102','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34818','','http://www.fullgoal.com.cn/','1996','10','0','0','0','0','0','7049','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36112','','http://www.lfc.org.cn/','1983','5','0','0','0','0','0','557','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34820','ʩ޵','http://www.jysld.com/','1996','12','0','0','0','0','0','5790','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36113','̳','http://www.lfcfans.com/bbs/','1983','6','0','0','0','0','0','156','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3417','й֤ȯ','http://www.cs.com.cn','847','1','0','0','0','0','0','13657','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3418','ձ','http://chinese.wsj.com','847','5','0','0','0','0','0','26228','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3419','ڻձ','http://www.qhdb.com.cn/','847','17','0','0','0','0','0','3160','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3420','йӪ','http://www.cb.com.cn','847','11','0','0','0','0','0','1473','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3421','˹','http://www.forbeschina.com/','847','15','0','0','0','0','0','3858','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3422','ÿվ','http://www.nbd.com.cn/','847','9','0','0','0','0','0','144','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3425','NULL','http://www.chinabusinesspost.netƾʱ','847','8','0','0','0','0','0','10147','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3426','ù۲챨','http://www.eeo.com.cn/','847','18','0','0','0','0','0','13813','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3428','̱','http://www.hkcd.com.hk/','847','19','0','0','0','0','0','298','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3429','ƾ','http://www.caijing.com.cn/','847','7','0','0','0','0','0','465','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3430','֤ȯгܿ','http://www.zhoukan.com.cn','847','16','0','0','0','0','0','11592','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3431','²Ƹ','http://www.newfortune.net.cn/','847','20','0','0','0','0','0','4902','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3434','Ϻڱ','http://www.shfinancialnews.com/','847','12','0','0','0','0','0','51','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3440','Ѷ-ƾ','http://finance.qq.com/tianxiaping/index.htm','848','3','0','0','0','0','3','20401','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3447','ڽ-','http://invest.jrj.com.cn/invest/','848','1','0','0','0','0','4','94279','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3462','Ա','http://www.taobao.com/go/chn/tbk_channel/onsale.php?pid=mm_14033530_3168968_10539994','852','1','0','0','0','0','0','148213','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3463','׿Խ','http://www.amazon.cn/?_encoding=UTF8&tag=ymx0d-23&linkCode=ur2&camp=536&creative=3200','852','5','0','0','0','0','0','4107','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3466','','http://www.m18.com/market/front.aspx?pno=ap-114la-kz&url=&ozc=28&ozs=5019','852','35','0','0','0','0','0','1216','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3471','YYȽϹ','http://www.askyaya.com','1990','2','0','0','0','0','2','17819','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40196','۴ȱ','http://www.hp.hc360.com','1264','11','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33160','ɽʡ֪ʶȨ','http://www.sdpatent.gov.cn/','2208','21','0','0','0','0','0','105','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3486','','http://www.letao.com/','1992','10','0','0','0','0','0','3765','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3487','ֻ','http://www.139shop.com/','1991','3','0','0','0','0','0','4697','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3497','йƷ','http://www.enwise.net/','925','9','0','0','0','0','0','1293','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33159','ʡ֪ʶȨ','http://www.ahipo.gov.cn/','2208','18','0','0','0','0','0','76','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3507','NULL','http://www.kongfz.com׷Ӿ','853','8','0','0','0','0','0','6136','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38610','Ʒ','http://www.xylp.com.cn/','852','25','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3511','','http://www.china-pub.com','853','6','0','0','0','0','0','2077','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3520','й','http://www.cnave.com/default.php?unionid=1148394','853','100','0','0','0','0','0','4138','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3521','ε','http://www.wl.cn/','853','7','0','0','0','0','0','3949','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3525','','http://www.dangdang.com/?_ddclickunion=P-308772|ad_type=10|sys_id=1#dd_refer=http%3A%2F%2Fwww.myler.cn%2F','853','1','0','0','0','0','0','1414','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36648','TS-Teamspeak','http://ts.youxia.com/','744','13','0','0','0','0','0','43','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21401','۴ƷƷ','http://www.gift.hc360.com/','925','1','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40063','Ӿй','http://www.chinavisual.com/','2106','3','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21395','йʻƷ','http://www.flowercn.com/','2174','2','0','0','0','0','0','1815','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21391','г','http://www.ywtoys.org/','2062','5','0','0','0','0','0','3050','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21389','','http://www.world-toy.com/','926','9','0','0','0','0','0','1082','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21380','Ʒ','http://www.teagift.com/','2061','1','0','0','0','0','0','2214','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39336','NULL','http://www.fangdr.comʿŻ','1780','100','0','0','0','0','0','711','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('13243','߶没ɨ','http://www.xiazaiba.com/virusscan.html','2024','16','0','0','0','0','0','1292','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3604','н','http://www.cnfol.com','1642','16','0','0','0','0','10','239646','0','','','1','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3605','FT','http://www.ftchinese.com/users/goto?ccode=2G091070&pageurl=http%3A%2F%2Fwww.ftchinese.com%2F','1642','19','0','0','0','0','0','706','0','','lzb','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('3606','Ž','http://www.ecitic.com','1642','21','0','0','0','0','0','2313','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3627','','http://www.icbc.com.cn','858','1','0','1','0','0','0','934358','26','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32902','ũҵ','http://www.xzrcb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3629','','http://www.cmbchina.com','858','2','0','1','1','1','24','226141','27','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3630','','http://www.ccb.com/portal/cn/home/index.html','858','4','0','0','0','0','0','213659','28','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3631','ũҵ','http://www.abchina.com','858','3','0','1','0','0','0','49551','28','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32901','ʯׯҵ','http://www.sccb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32900','ũҵ','http://www.wjnsh.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32899','Ȫҵ','http://www.qzccbank.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32898','һ','http://www.fsbankonline.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32897','','http://www.binbank.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32896','żҸũҵ','http://www.zjgrcb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32895','ҵ','http://www.lyccb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32894','⽭ũҵ','http://www.wjrcb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32893','ũҵ','http://www.csebank.com/','1643','100','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32892','ҵ','http://www.wzcb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32891','ũҵ','http://www.jybank.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32890','Ͳҵ','http://www.zccb.com.cn/index.asp','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32889','ൺҵ','http://www.qdccb.com/?56606245=3638389013','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32888','ҵ','http://www.lzbank.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32887','ɶҵ','http://www.cdccb.com/','1643','100','0','0','0','0','0','10','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32886','ҵ','http://www.gyccb.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32885','ϲҵ','http://www.nccbank.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32884','ͷҵ','http://www.bcb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32883','ҵ','http://www.jnccb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32882','Ź','http://www.xib.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32881','ҵ','http://www.96779.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32880','ҵ','http://www.hrbcb.com.cn/','1643','100','0','0','0','0','0','6','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32879','ҵ','http://www.cqcbank.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32878','Ͼ','http://www.njcb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32877','ũҵ','http://www.961200.net/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32876','ҵ','http://www.hccb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31500','йƲչ˾','http://www.picc.com.cn/','1995','6','0','0','0','0','0','4247','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31499','»ٱչ˾','http://www.newchinalife.com/','1995','5','0','0','0','0','0','6301','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31497','йƽչ˾','http://www.pa18.com/','1995','1','0','0','0','0','2','23862','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16741','йũᱣ','http://www.molss.gov.cn/gb/ywzn/ncbx.htm','856','100','0','0','0','0','0','6','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3764','Ѻ','http://health.sohu.com','864','2','0','0','0','0','5','78982','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3765','ǧ','http://health.qianlong.com','864','12','0','0','0','0','0','19854','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3767','','http://www.xtata.com/','864','14','0','0','0','0','6','6797','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3768','йѧŻ','http://www.nlp.cn/','864','13','0','0','0','0','0','20557','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3773','Ǿҽ','http://www.5191.com','2202','7','0','0','0','0','0','32005','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3777','','http://health.people.com.cn/','864','9','0','0','0','0','2','42341','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3780','׶','http://www.mn81.com','1721','100','0','0','0','0','0','8092','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3782','ʱ','http://www.jksb.com.cn','864','15','0','0','0','0','0','42142','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3786','ʱش','http://www.120ask.com/','2202','2','0','0','0','0','0','75924','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35680','о','http://www.chinabgao.com/09/report/drink.asp','1234','5','0','0','0','0','0','462','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3797','NULL','http://www.panzhongheng.comкҽ˲ҽԺ','1721','100','0','0','0','0','0','1744','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3798','Ѱҽҩ','http://www.xywy.com/','2202','6','0','0','0','0','0','28778','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3804','ڹڽ','http://www.szhe.com','1739','100','0','0','0','0','0','1096','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40555','йս','http://www.china1931.cn','1009','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3824','˽','http://news.sina.com.cn/health/','864','10','0','0','0','0','0','16663','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40605','','http://www.510173.com/','1898','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38570','ҽ','http://www.0310jj.com','1889','100','0','0','0','0','0','328','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3834','ȫ̲Ϣ','http://www.chain.net.cn','866','6','0','0','0','0','0','3639','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3835','йԤ','http://www.chinacdc.net.cn','866','4','0','0','0','0','0','3518','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3836','԰Ƶ','http://www.hiv-vct.net','866','10','0','0','0','0','0','4908','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3837','й','http://www.aids-china.com','866','5','0','0','0','0','0','3786','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3838','Բ̲','http://www.chinaids.org.cn/','866','7','0','0','0','0','0','7727','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3839','ԤԲ̲','http://www.china-fpsa.com','866','8','0','0','0','0','0','2080','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3841','Ϲ̲滮','http://www.unchina.org/unaids','866','9','0','0','0','0','0','551','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3842','ר-sina','http://news.sina.com.cn/pc/aids2005/index.shtml','866','3','0','0','0','0','0','2115','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3843','ר-sohu','http://news.sohu.com/s2005/05aizibingri.shtml','866','2','0','0','0','0','0','2881','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3844','ר-TOM','http://news.tom.com/hot/aizibing/index.html','866','1','0','0','0','0','0','5113','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40554','ȫ','http://www.wtobag.com/','1215','4','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40553','ǿ','http://www.gtsky.com','1680','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40552','༭֮','http://www.eastit.cn/','2260','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40551','йװɹ','http://www.caigou.com.cn/','1264','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40548','ֽ','http://www.zhidiy.com','1717','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40544','ֻ','http://www.159.com/','766','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34605','ֻ̳','http://bbs.dospy.com/','1930','16','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34604','','http://www.51haha.net/','1930','13','0','0','0','0','0','1197','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34600','Ƹ̳','http://bbs.eastmoney.com/','1930','14','0','0','0','0','0','985','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34597','Ѹ̳','http://bbs.xunlei.com/','1930','15','0','0','0','0','1','1754','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34595','Ѫ̳','http://www.tiexue.net/','1930','9','0','0','0','0','9','119798','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34594','baby169','http://bbs.baby169.net/','1930','17','0','0','0','0','0','28','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34593','ͼͼ̳','http://bbs.tucoo.com/','1930','8','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3889','лҽ','http://www.zhzyw.org/','2202','3','0','0','0','0','0','6326','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3890','37Cҽѧ','http://www.37c.com.cn','869','2','0','0','0','0','0','8630','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3891','ҽѧ','http://www.med66.com','869','3','0','0','0','0','0','10064','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3893','ҽѧ','http://www.medkaoyan.net','869','16','0','0','0','0','0','1172','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3894','ҽѧϢ','http://www.clinet.com.cn','869','4','0','0','0','0','0','2316','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3895','','http://www.aijk.com','869','5','0','0','0','0','1','5163','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3900','NULL','http://www.kq88.comǻҽѧ','869','15','0','0','0','0','0','7345','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3902','ҽѧϢо','http://www.library.imicams.ac.cn','869','17','0','0','0','0','0','162','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3903','лҽѧ','http://www.cma.org.cn','869','6','0','0','0','0','0','7023','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3906','ҽѧ','http://www.medsee.com','869','16','0','0','0','0','0','2713','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3915','л','http://www.cem.org.cn','869','15','0','0','0','0','0','2693','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3923','йҽѧϢ','http://cmbi.bjmu.edu.cn','869','7','0','0','0','0','0','965','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3936','йҽҩϢ','http://www.meinet.com.cn','869','9','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34579','Ͼպѧͼ','http://lib.nuaa.edu.cn/','955','63','0','0','0','0','0','87','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34578','ϷѧԺͼ','http://lib.hfuu.edu.cn/','955','60','0','0','0','0','0','100','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32680','ִҽԺ','http://www.21hm.com/','870','3','0','0','0','0','0','2253','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34576','պѧͼ','http://lib.buaa.edu.cn/','955','54','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3976','йҽҩϢ','http://www.cintcm.com','872','6','0','0','0','0','0','6911','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34583','ѧͼ','http://www.lib.scut.edu.cn/','955','75','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3982','йʳƷҩƷ','http://www.cnpharm.cn','872','9','0','0','0','0','0','4573','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3984','ҽҩñ','http://www.yyjjb.com.cn','872','21','0','0','0','0','0','709','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3985','йҩ豸','http://www.pm8.com.cn','872','12','0','0','0','0','0','615','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3986','йҽҩ','http://www.chinese999.com','872','8','0','0','0','0','0','5829','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40533','','http://bbs.54master.com/','2259','1','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3992','ҩѧ','http://www.syhao.com','872','29','0','0','0','0','0','595','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34582','Ͼũҵѧͼ','http://libwww.njau.edu.cn/','955','68','0','0','0','0','0','58','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('3995','йҽҩ','http://www.sinopharm.com','872','13','0','0','0','0','0','914','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4001','йҽҩϢ','http://www.meinet.com.cn','872','14','0','0','0','0','0','2088','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34581','ʯׯѧԺͼ','http://lib.sjzri.edu.cn/','955','66','0','0','0','0','0','137','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4009','ѶԤ','http://weather.news.qq.com','2035','4','0','0','0','0','0','15943','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4011','','http://weather.sina.com.cn','2035','5','0','0','0','0','0','12779','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39945','[]','http://www.galatasaray.org.tr/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4014','й','http://www.weather.com.cn/','2035','2','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40439','йҽҩ','http://www.pharmnet.com.cn/','2252','100','0','0','0','0','0','4','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40438','йҽеҵЭ','http://www.camdi.org/','2252','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40437','ҽ豸չ','http://www.chinamed.net.cn/','2252','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40436','ҽеϢ','http://www.mednet.cn/','2252','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40435','йҽеϢ','http://www.cmdi.gov.cn/','2252','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4103','װ޼Ҿ','http://home.focus.cn','879','3','0','0','0','0','0','32081','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33940','˹Ҷ[]','http://www.duma.gov.ru/','1833','1','0','0','0','0','0','143','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4109','й','http://www.ciid.com.cn','879','11','0','0','0','0','0','11197','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40569','԰ѧ','http://www.9718.com/','1052','5','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33938','¹[]','http://www.bundesregierung.de/','1833','7','0','0','0','0','0','44','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33929','˹ίԱ[]','http://council.gov.ru/','1833','4','0','0','0','0','0','44','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40429','ƵؼԤ','http://www.ctrip.com/smartlink/smartlink.asp?c=114la&url=http://hotels.ctrip.com/Domestic/SearchHotel.aspx','2249','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40430','7Ƶ','http://www.7daysinn.cn/marketact/active/com_reg/reg.php?sid=6267&rid=ylmf_sp&crid=0','2249','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33937','¹Ժ[]','http://www.bundesrat.de/','1833','8','0','0','0','0','0','12','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31490','־','http://china.db.com/','1688','17','0','0','0','0','0','318','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32816','йܼҾ','http://www.smarthomecn.com/','879','9','0','0','0','0','0','3842','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4130','йذϢ','http://www.flooring.com.cn/','879','12','0','0','0','0','0','4951','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33980','ڸ[]','http://www.cabinet.gov.jm/','1834','100','0','0','0','0','0','24','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4133','йļ۸','http://www.jc.net.cn','1189','2','0','0','0','0','0','978','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4135','','http://www.xnjcw.com','1189','10','0','0','0','0','0','1309','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4136','йˮ','http://www.chinacements.com','1189','22','0','0','0','0','0','90','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4140','ҽ','http://www.chinabmnet.com/china/','1189','6','0','0','0','0','0','1389','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4141','罨','http://www.wbmbw.com','1189','8','0','0','0','0','0','1002','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33979','ôฮ[ô]','http://pm.gc.ca/','1834','100','0','0','0','0','0','46','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33978','Ժ[]','http://www.senat.fr/','1833','14','0','0','0','0','0','6','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33977','[]','http://www.stjr.is/','1833','15','0','0','0','0','0','27','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33976','⽻[]','http://www.um.dk/','1833','16','0','0','0','0','0','4','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33975','޵[]','http://www.vlada.hr/','1833','28','0','0','0','0','0','7','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33974','ݿ[]','http://www.vlada.cz/','1833','35','0','0','0','0','0','8','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38389','űС˵','http://www.9bin.com','645','14','0','0','0','0','10','255328','0','','lzb','1','2','0','0','','0');
INSERT INTO ylmf_site VALUES('33973','[]','http://www.valtioneuvosto.fi/','1833','36','0','0','0','0','0','17','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33972','[]','http://www.urm.lt/','1833','37','0','0','0','0','0','14','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31568','ѯ','http://fund.jrj.com.cn/fund/fundinfoall.asp','1997','2','0','0','0','0','0','8026','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4169','Ѻ','http://house.sohu.com','881','4','0','0','0','0','1','15205','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4170','˷','http://house.sina.com.cn','881','3','0','0','0','0','0','22786','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4171','Żز','http://cn.realestate.yahoo.com','881','8','0','0','0','0','0','6389','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39883','','http://faxingw.cn','735','14','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39884','йʳƷƸ','http://www.food36.com','1229','27','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4181','ڷ','http://www.fdc.com.cn','1778','11','0','0','0','0','0','1126','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4185','лز','http://re.icxo.com','881','13','0','0','0','0','0','2275','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32973','ũҵ','http://www.961200.net/','2047','11','0','0','0','0','0','1298','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4197','ڱ','http://stbnnr.allyes.com/bnnr/114la_koubei.html','881','5','0','0','0','0','0','900','0','red','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32971','ƽ','http://www.18ebank.com/','2047','10','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32970','ҵ','http://www.hccb.com.cn/','2047','9','0','0','0','0','1','1145','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32968','','http://www.nbcb.com.cn/','2047','8','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32967','Ͼ','http://www.njcb.com.cn/','2047','7','0','0','0','0','0','1634','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38456','ѯǷѱע','http://www.ename.cn/domain_register.html','1133','14','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32836','','http://www.fjsen.com/','2046','14','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32835','а','http://www.ahrb.com.cn/','2046','14','0','0','0','0','0','66','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31522','д','http://info.cmbchina.com/fund','1996','48','0','0','0','0','0','878','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31550','Ѻ','http://money.business.sohu.com/','1642','2','0','0','0','0','0','9411','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31548','','http://finance.sina.com.cn/money/index.shtml','1642','3','0','0','0','0','0','9084','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33074','ķ̳','http://www.tianya.cn/publicforum/articleslist/0/law.shtml','913','28','0','0','0','0','0','2021','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34811','㷢','http://www.gffunds.com.cn/','1996','4','0','0','0','0','0','28548','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34815','ͨ','http://www.hftfund.com/','1996','8','0','0','0','0','0','5422','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34823','ӯ','http://www.byfunds.com/','1996','15','0','0','0','0','0','1831','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31525','NULL','http://www.ccb.com/portal/cn/fund/index.jspйд','1996','45','0','0','0','0','0','4349','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33075','ְ Ƹ ','http://www.ggcp.com.cn/','1519','11','0','0','0','0','0','1286','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36325','NULL','http://www.cttxj.com½ͨ','2092','1055','0','0','0','0','0','45','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4274','ú','http://www.goodbaby.com/','884','7','0','0','0','0','0','3200','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32814','ϲüҾ','http://www.joyju.com/','879','18','0','0','0','0','0','11975','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33982','Ű[]','http://www.cubaweb.cu/','1834','100','0','0','0','0','0','47','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4291','','http://baby.sina.com.cn/','884','1','0','0','0','0','0','10509','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34003','[]','http://www.govt.nz/','1837','100','0','0','0','0','0','48','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34002','Ĵ[Ĵ]','http://www.gov.au/','1837','100','0','0','0','0','0','63','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34000','⽻[]','http://www.mfa.gov.eg/','1836','100','0','0','0','0','0','37','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33999','Ϸ[Ϸ]','http://www.gov.za/','1836','100','0','0','0','0','0','38','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34001','Ĵ⽻[Ĵ]','http://www.dfat.gov.au/','1837','100','0','0','0','0','0','18','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33996','Ϸ⽻[Ϸ]','http://www.dfa.gov.za/','1836','100','0','0','0','0','0','23','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33995','ͳ[]','http://www.planalto.gov.br/','1835','100','0','0','0','0','0','33','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33969','Ӣʼ[Ӣ]','http://www.royal.gov.uk/','1833','18','0','0','0','0','0','62','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33968','[]','http://www.regeringen.se/','1833','32','0','0','0','0','0','10','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33993','͢ͳ[͢]','http://www.presidencia.gov.ar/','1835','100','0','0','0','0','0','27','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33992','ױ[]','http://www.gobiernoenlinea.gov.co/','1835','100','0','0','0','0','0','12','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33991','͢⽻[͢]','http://www.cancilleria.gov.ar/','1835','100','0','0','0','0','0','19','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33990','׹[]','http://www.whitehouse.gov/','1834','100','0','0','0','0','0','178','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34022','TOM-','http://ent.tom.com/tv/','752','9','0','0','0','0','0','5724','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34010','йѧǰ','http://www.preschool.net.cn/','886','1','0','0','0','0','0','22663','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4341','й׽','http://www.xugu.net','886','2','0','0','0','0','0','23837','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36323','NULL','http://','2092','58','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4365','й׶','http://www.jy135.com/','886','6','0','0','0','0','0','17288','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35948','׿˲','http://www.jobcn.com/','958','6','0','0','0','0','0','24673','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40042','̳','http://bbs.baby.sina.com.cn/group.php?tree=0&gid=18','888','1','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40043','ѺĸӤ','http://club.baby.sohu.com/','888','4','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4383','ѾѾ','http://bbs.iyaya.com','888','5','0','0','0','0','0','5274','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38297','','http://bbs.chaoshanren.com/','1955','25','0','0','0','0','0','917','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4400','й','http://www.ccyl.org.cn','890','3','0','0','0','0','0','804','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4409','й귢չ','http://www.cydf.org.cn','890','2','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41358','Űʿ','http://www.msafe.com.cn/','1282','3','0','0','0','0','0','0','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33199','','http://www.go2eu.com/','892','9','0','0','0','0','0','12335','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4425','Ѻ','http://travel.sohu.com','892','14','0','0','0','0','0','4220','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33257','ξ','http://www.visitfinland.com.cn/','2052','3','0','0','0','0','0','134','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4427','','http://travel.elong.com/hotels/default.aspx?campaign_id=4053869','892','4','0','0','0','0','0','9460','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33256','Ӣξ','http://www.visitbritain.cn/','2052','2','0','0','0','0','0','421','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35068','켫簲ȫ','http://soft.yesky.com/security/','1139','7','0','0','0','0','0','1789','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40410','ͨ','http://www.moc.gov.cn/','2240','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40411','·Ϣ','http://www.chinahighway.gov.cn/','2240','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36300','ͨ','http://www.cttbj.com','2092','1','0','0','0','0','0','12','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4436',';','http://www.lotour.com/','892','11','0','0','0','0','0','6591','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33254','ξ','http://cn.franceguide.com/','2052','1','0','0','0','0','0','677','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38345','NULL','http://www.jiatx.com','879','110','0','0','0','0','0','7101','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33252','Խξ','http://www.vietnamtourism.com/','2051','12','0','0','0','0','0','381','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33251','','http://www.visitmaldives.com/cn/','2051','11','0','0','0','0','0','429','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4442','Ѷ','http://www.itravelqq.com/','892','22','0','0','0','0','0','1835','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35046','йӡȾ','http://www.chinayinran.com/','1262','5','0','0','0','0','0','101','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4446','ƵԤ','http://www.189uu.com/','892','13','0','0','0','0','0','20613','0','','admin','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('33249','ξ','http://www.visitbrunei.cn/','2051','10','0','0','0','0','0','114','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36310','ͨ','http://www.cttjs.com','2092','15','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33279','³ξ','http://www.peru.info/','2054','6','0','0','0','0','0','59','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40417','ź','http://www.xiamenair.com.cn/','2241','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35001','̳','http://sports.163.com/','929','4','0','0','0','0','0','420','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23226','179','http://www.179.com.tw/','1830','100','0','0','0','0','0','862','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23225','NULL','http://taiwantourbus.justaiwan.com/̨۹ʿ','1830','100','0','0','0','0','0','1333','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23224','̨۹Ѷ','http://www.taiwan.net.tw/','1830','100','0','0','0','0','0','1126','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23223','̨','http://www.travel-web.com.tw/','1830','100','0','0','0','0','0','48','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33292','','http://www.archos.com.cn/','1686','6','0','0','0','0','0','710','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36297','ͨ','http://www.ctthlj.com','2092','5','0','0','0','0','0','44','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33278','ξ','http://www.braziltourism.org/','2054','5','0','0','0','0','0','139','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33277','ξ','http://www.gohawaii.cn/','2054','4','0','0','0','0','0','502','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33276','īξ','http://www.visitmexico.com/wb/Visitmexico/Visi_Home?show=regions','2054','3','0','0','0','0','0','183','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33275','͢','http://www.turismo.gov.ar/','2054','2','0','0','0','0','0','159','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33274','ôξ','http://www.explore.canada.travel/ctc/ke/homepage.jsp?localeId=62','2054','1','0','0','0','0','0','348','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33271','ξ','http://www.egypt.com/','2053','18','0','0','0','0','0','322','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33270','Ϸξ','http://www.southafrica.net/index.cfm?CountryProfileID=65','2053','17','0','0','0','0','0','431','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36299','ͨ','http://www.cttjl.com','2092','7','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33268','ξ','http://www.visitdenmark.com/','2052','17','0','0','0','0','0','109','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23192','й','http://spot.cnair.com/','2031','1','0','0','0','0','0','2055','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40408','','http://www.bjsubway.com/','2240','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23190','e-ѯ','http://zhinan.elong.com/','2031','3','0','0','0','0','0','1909','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40409','ݵ','http://www.gzmtr.com/','2240','100','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23188','-ѯ','http://travel.163.com/special/s/sight.html','2031','4','0','0','0','0','0','3234','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17290','110','http://www.56110.cn/','1240','17','0','0','0','0','0','1366','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17292','սͨ','http://www.jsjtb.com/','1658','11','0','0','0','0','0','163','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17293','ͨ','http://www.hbjt.gov.cn/WEBSITE/jtb/index.htm','1658','10','0','0','0','0','0','100','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17291','йͨ','http://paper.zgjtb.com/jtb/','1658','1','0','0','0','0','0','368','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4546','йͿ','http://www.edu.cn','903','11','0','0','0','0','0','628','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4547','̨վ','http://www.nmc.gov.cn','903','4','0','0','0','0','0','15565','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4548','йϢ','http://www.cheminfo.gov.cn','903','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4549','йũҩϢ','http://www.chinapesticide.gov.cn','903','16','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4550','ҵϢ','http://www.autoinfo.gov.cn','903','23','0','0','0','0','0','146','0','','lsz','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('4551','йϢ','http://www.cei.gov.cn','903','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4552','йزϢ','http://www.realestate.cei.gov.cn','903','20','0','0','0','0','0','1952','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31504','̫ƽ̩ٱ','http://www.cpic-ing.com.cn/','1995','10','0','0','0','0','0','1734','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4556','й̼Ϣ','http://www.cetin.net.cn','903','18','0','0','0','0','0','268','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4557','йϢ','http://www.1921.cn','903','12','0','0','0','0','0','1190','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4558','йϢ','http://www.cncic.gov.cn','903','19','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4559','ҺϢ','http://www.nmdis.gov.cn','903','2','0','0','0','0','0','196','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4561','֯','http://www.who.int','904','1','0','0','0','0','0','462','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4562','ó֯','http://www.wto.org','904','2','0','0','0','0','0','386','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4563','Ϲũ֯','http://www.fao.org','904','60','0','0','0','0','0','79','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4564','֪ʶȨ֯','http://www.wipo.int','904','3','0','0','0','0','0','104','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4565','Ϲƻ','http://www.undp.org','904','61','0','0','0','0','0','54','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4566','','http://www.worldbank.org','904','5','0','0','0','0','0','283','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4568','ʻһ֯','http://www.imf.org','904','20','0','0','0','0','0','524','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4569','Ϲ֯','http://www.unicef.org','904','62','0','0','0','0','0','44','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4570','Ϲйվ','http://www.unchina.org','904','63','0','0','0','0','0','317','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4571','͹֯','http://www.ilo.org','904','21','0','0','0','0','0','41','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20209','ʶͯ֯','http://www.children.org/','904','22','0','0','0','0','0','74','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4573','ʾ֯','http://www.oecd.org','904','23','0','0','0','0','0','32','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4574','Ϲ̿֯','http://www.unesco.org','904','78','0','0','0','0','0','98','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4575','Ȼ','http://www.panda.org','904','6','0','0','0','0','0','29','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4576','ʺ֯','http://www.wcoomd.org','904','24','0','0','0','0','0','36','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35363','פʹ','http://china.koreanembassy.cn/','2081','11','0','0','0','0','0','227','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4581','績Ů֯','http://www.now.org','904','7','0','0','0','0','0','190','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4583','Ϲ֯ϵ','http://www.unsystem.org','904','65','0','0','0','0','0','19','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4584','ʿ֯','http://www.ico.org','904','25','0','0','0','0','0','74','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4585','ʷЭ','http://www.ila-hq.org','904','26','0','0','0','0','0','44','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4587','Ϲ','http://www.unhcr.ch','904','66','0','0','0','0','0','84','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4588','ʷо','http://www.ili.org','904','56','0','0','0','0','0','31','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4589','ʳƻ','http://www.wfp.org','904','9','0','0','0','0','0','96','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4590','֯','http://www.world-tourism.org','904','10','0','0','0','0','0','62','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4591','ϹҩƷ','http://www.undcp.org','904','67','0','0','0','0','0','36','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4592','º֯','http://www.icao.int','904','29','0','0','0','0','0','12','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4593','ʷͥ','http://www.icj-cij.org','904','30','0','0','0','0','0','119','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4594','繤Э','http://www.wico.com','904','12','0','0','0','0','0','43','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4596','ũҵչ','http://www.ifad.org','904','31','0','0','0','0','0','29','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35362','ձפʹ','http://www.cn.emb-japan.go.jp/','2081','12','0','0','0','0','0','693','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35361','˹פʹ','http://www.slemb.com/','2081','13','0','0','0','0','0','40','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35360','ӡפʹ','http://www.indianembassy.org.cn/','2081','14','0','0','0','0','0','117','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35359','̩פʹ','http://www.thaishanghai.com/','2081','15','0','0','0','0','0','89','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33961','⽻[]','http://www.msz.gov.pl/','1833','39','0','0','0','0','0','4','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4604','58ͬ','http://www.58.com/','908','2','0','0','0','0','0','7226','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4605','ϼ','http://www.ganji.com/','908','3','0','0','0','0','0','4807','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4607','21cn','http://life.21cn.com','908','7','0','0','0','0','0','3851','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36277','ٶNBA','http://tieba.baidu.com/f?kw=nba','2116','3','0','0','0','0','0','2587','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37739','','http://www.cqtelecom.com.cn/','1888','13','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4611','','http://www.baixing.com/','908','1','0','0','0','0','0','1220','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40142','','http://www.41go.cn/','2189','99','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40143','¶','http://www.menglu.com/','2189','98','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40007','Ѷ߿Ƶ','http://edu.qq.com/gaokao/','1001','1','0','0','0','0','0','24','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40008','й߿','http://www.edu201.com/','1001','6','0','0','0','0','0','64','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4616','ڵ','http://www.dianping.com/','908','4','0','0','0','0','0','356','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38045','NULL','http://www.syfc.com.cn/','1892','21','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40885','','http://www.abang.com','908','5','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35534','-','http://sports.people.com.cn/GB/22155/22157/','944','11','0','0','0','0','0','318','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35531','м','http://www.ciw.com.cn/','1126','2','0','0','0','0','0','1313','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35530','Ա','http://www.365master.com/','1126','13','0','0','0','0','0','2121','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35231','','http://www.haier.cn/','1876','18','0','0','0','0','0','758','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35230','','http://www.benq.com.cn/','1876','10','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40647','㾦','http://www.kswchina.com','991','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4632','NULL','http://china.findlaw.cn/ҷ','913','101','0','0','0','0','0','4791','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4633','йշ','http://www.legalinfo.gov.cn','913','1','0','0','0','0','0','3307','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4634','','http://www.dffy.com','913','17','0','0','0','0','0','2628','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18365','йӴ','http://www.cnartw.com/cweb/','1012','4','0','0','0','0','0','10374','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40648','','http://www.diaoyuweng.com','1673','2','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4645','߷','http://www.on118.com/','1879','5','0','0','0','0','1','999','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4648','зԮ','http://www.bjlegalaid.gov.cn','2207','18','0','0','0','0','0','722','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4653','йٲ','http://www.china-arbitration.com','913','13','0','0','0','0','0','1992','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40403','ѯ','http://www.qunar.com/','2240','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4672','йԺ','http://www.chinacourt.org','914','1','0','0','0','0','0','2010','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4673','Ժ','http://rmfyb.chinacourt.org','914','2','0','0','0','0','0','1793','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33265','˹ξ','http://www.russia-travel.com/','2052','12','0','0','0','0','0','247','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4675','㶫Ժ','http://www.gdcourts.gov.cn','914','21','0','0','0','0','0','1833','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33239','̩ξ','http://www.tatbjs.org.cn/','2051','2','0','0','0','0','0','541','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4678','շԺ','http://www.jsfy.gov.cn','914','13','0','0','0','0','0','435','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4683','ϷԺ','http://hngy.chinacourt.org','914','18','0','0','0','0','0','265','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4684','Ժ','http://tjfy.chinacourt.org','914','7','0','0','0','0','0','97','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4685','ӱԺ','http://hbfy.chinacourt.org','914','10','0','0','0','0','0','154','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4686','Ժ','http://hubeigy.chinacourt.org','914','19','0','0','0','0','0','424','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33264','','http://www.icetourist.is/','2052','11','0','0','0','0','0','211','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36301','ͨ','http://www.ctttj.com/','2092','2','0','0','0','0','0','15','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33179','HiNet㲥','http://hichannel.hinet.net/radio/','754','13','0','0','0','0','0','234','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33263','ξ','http://www.discovernorthernireland.com/','2052','10','0','0','0','0','0','89','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33262','ʿξ','http://www.myswitzerland.com.cn/','2052','9','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35016','֮','http://www.diao-yu.com/','1673','13','0','0','0','0','0','5191','0','','luoj','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('33237','й','http://www.cnta.com/','2051','1','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33261','ξ','http://www.holland.com/cn/','2052','8','0','0','0','0','0','215','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33207','ʡԺ','http://www.hicourt.gov.cn/','914','23','0','0','0','0','0','169','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33259','¹ξ','http://www.germany-tourism.cn/','2052','6','0','0','0','0','0','196','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33206','T؄e^Ժ','http://www.court.gov.mo/','914','29','0','0','0','0','0','106','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40423','TOM365ѵӰ','http://www.tom365.com/?kl','2242','1','0','0','0','0','0','80','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4714','KingNetʼҷԺ','http://law.kingnet.com.tw','914','5','0','0','0','0','0','164','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4717','ʦ365','http://www.64365.com','915','12','0','0','0','0','1','1734','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4718','NULL','http://www.chineselawyer.com.cnйʦ','915','104','0','0','0','0','0','5774','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4720','148ʦ','http://www.148-law.com','915','13','0','0','0','0','2','600','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33138','޵̨','http://www.hkatv.com/','749','8','0','0','0','0','0','24298','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40393','Ϸ','http://www.hnxq.net/','2238','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4723','ʦЭ','http://www.xblaw.com','2206','31','0','0','0','0','0','89','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4724','ʦ','http://www.lawyers.net.cn','915','3','0','0','0','0','2','746','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4726','ʦϢ','http://www.china-lawfirm.com','2206','16','0','0','0','0','0','319','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40389','ħ','http://www.magic8.cn/','2237','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4730','NULL','http://www.lawstar.com.cnʦ','2206','36','0','0','0','0','0','713','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4733','ʦ','http://www.hklawsoc.org.hk','2206','33','0','0','0','0','0','313','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4741','㶫ʦ','http://www.lawyer.gd.cn','2206','27','0','0','0','0','0','1791','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4742','ʦ','http://www.xmls.cn','2206','32','0','0','0','0','0','341','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4745','ʦ','http://www.jllawyer.com','2206','18','0','0','0','0','0','391','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40392','','http://www.jingjuok.com/','2238','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4754','ʦ','http://www.hnlx.org.cn/','2206','26','0','0','0','0','1','560','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4765','NULL','http://www.lawyer.qh.cnຣʦЭ','2206','40','0','0','0','0','0','131','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4767','ʦ','http://www.lawking.com.cn/','2206','15','0','0','0','0','2','541','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40391','CCTVϷƵ','http://space.tv.cctv.com/podcast/jzdxt','2238','2','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4773','ʦ','http://www.aam.org.mo','2206','34','0','0','0','0','0','103','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4775','ʦ','http://www.ahlawyer.com.cn','2206','21','0','0','0','0','0','844','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4779','й֪ʶȨ','http://www.cnipr.com','916','1','0','0','0','0','0','636','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4781','㶫ʡ֪ʶȨ','http://www.gdipo.gov.cn','2208','25','0','0','0','0','0','245','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4785','ʡ֪ʶȨ','http://zscq.jl.gov.cn','2208','13','0','0','0','0','0','46','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4787','ʡ֪ʶȨ','http://www.snipo.gov.cn','2208','31','0','0','0','0','0','93','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4788','йҰȨ','http://www.ncac.gov.cn','916','6','0','0','0','0','0','83','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4789','֪ʶȨо','http://www.iprcn.com','916','3','0','0','0','0','0','154','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38557','LOGO','http://www.55.la/','2109','19','0','0','0','0','0','261','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4794','ɶ֪ʶȨ','http://www.cdip.gov.cn','2208','35','0','0','0','0','0','57','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4796','ʡ֪ʶȨ','http://www.hbipo.gov.cn','2208','23','0','0','0','0','0','75','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4797','ʡ֪ʶȨ','http://www.fjipo.gov.cn','2208','19','0','0','0','0','0','125','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40279','Ĵʡ֪ʶȨ','http://www.scipo.gov.cn/','2208','100','0','0','0','0','0','2','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4807','֪ʶȨ','http://www.gxipo.net','2208','26','0','0','0','0','0','114','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4808','ɹ֪ʶȨ','http://www.nmipo.gov.cn','2208','11','0','0','0','0','0','41','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4809','ӱʡ֪ʶȨ','http://www.hebipo.gov.cn','2208','9','0','0','0','0','0','86','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4810','ʡ֪ʶȨ','http://www.hipo.gov.cn','2208','27','0','0','0','0','0','40','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32301','з','http://www.1488.com/','913','2','0','0','0','0','2','6965','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37530','NULL','http://travel.qingdaonews.com/ൺƵ','1900','26','0','0','0','0','0','2111','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37148','Ѻ','http://club.travel.sohu.com/list_art_sub.new.php?b=henan','1901','38','0','0','0','0','0','400','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37361','ʡί','http://www.gspc.gov.cn/','1912','48','0','0','0','0','0','284','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37758','ѧ','http://www.gxu.edu.cn/','1905','25','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38219','Ͼeʳ','http://www.517515.com/','1895','29','0','0','0','0','0','1205','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32313','֪ʶȨ','http://www.sipo.gov.cn/sipo/','913','21','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38108','NULL','http://www.cckfb.gov.cn/زϢ','1893','21','0','0','0','0','0','219','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40675','ŵ','http://9.douban.com/','670','8','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37089','ɹҽԺ','http://www.nmgyy.cn/','1891','18','0','0','0','0','0','121','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37983','ɽ','http://www.sxlottery.net/','1890','20','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37941','ӱʡҽԺ','http://www.hbpphosp.cn/','1889','32','0','0','0','0','0','395','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37738','ͨ','http://www.on165.com/index.aspx','1888','12','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36798','','http://travel.enorth.com.cn/tjyw/','1887','26','0','0','0','0','0','1407','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36822','','http://www.tj-pigeon.com/','1887','50','0','0','0','0','0','139','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36753','ξϢ','http://www.bjta.gov.cn/','1885','29','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32014','Mapbarͼ','http://www.mapbar.com/','2023','7','0','0','0','0','0','17477','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32307','йϢ','http://www.law-star.com/','913','10','0','0','0','0','0','2168','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32308','','http://www.legaldaily.com.cn/','913','6','0','0','0','0','0','335','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40283','ѧĶ','http://www.renyu.net/','648','107','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('35877','йش̳','http://bbs.zol.com.cn/','1103','3','0','0','0','0','0','3529','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26115','ϵ»Żȯ','http://www.kfc.com.cn/kfccda/','1990','12','0','0','0','0','0','16473','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40399','ҴԺ','http://www.chncpa.org/','2238','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32315','й̱','http://sbj.saic.gov.cn/','1880','22','0','0','0','0','0','415','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32316','Ͷͬ','http://www.xinhuanet.com/legal/ldhtf/','1878','3','0','0','0','0','0','757','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4848','̳','http://www.erji.net','1599','8','0','0','0','0','0','503','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4851','ǳ','http://www.hifi168.com','919','4','0','0','0','0','0','2691','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('4855','й','http://www.xycad.com','919','1','0','0','0','0','0','2926','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32318','йɷ','http://www.gov.cn/flfg/index.htm','1878','4','0','0','0','0','0','2607','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32312','й̷','http://www.civillaw.com.cn/','913','20','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32559','ͼ-̳','http://bbs.uc.sina.com.cn/tableforum/App/index.php?bbsid=135','684','6','0','0','0','0','0','3021','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38220','»ʳ','http://www.js.xinhuanet.com/fqjs/meishi.htm','1895','30','0','0','0','0','0','562','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32302','ɿ쳵','http://www.lawtime.cn/','913','4','0','0','0','0','0','1788','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32303','йԺ','http://www.chinacourt.org/','913','5','0','0','0','0','0','8706','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26103','','http://www.chajia.com/','1990','3','0','0','0','0','1','18410','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26102','Ȧ','http://www.7sp.cn','908','98','0','0','0','0','0','4895','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('32321','֮-ѯ','http://www.law-star.com/html/lawsearch.htm','1878','2','0','0','0','0','0','66','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32322','ȫ','http://www.npc.gov.cn/','2178','2','0','0','0','0','0','2151','0','','lsz','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('32304','йɴȫ','http://www.jincao.com/t1.htm','1878','6','0','0','0','0','0','24473','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35908','ͥƵ','http://www.htinns.com/','895','10','0','0','0','0','0','3859','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33201','ݷԺ','http://www.guizhoucourt.gov.cn/','914','25','0','0','0','0','0','363','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26092','','http://www.danawa.com.cn/','1990','6','0','0','0','0','0','10885','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32305','NULL','http://www.mzyfz-news.com.cn/뷨','913','107','0','0','0','0','0','3098','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26089','58ͬ','http://click.linktech.cn/?m=58cpc&a=A100089159&l=00016&l_cd1=0&l_cd2=0&u_id=','1881','1','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26088','263','http://www.263.com/','1881','5','0','0','0','0','0','903','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26086','','http://www.baixing.com/','1881','4','0','0','0','0','0','1934','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26085','ϼ','http://www.ganji.com/','1881','3','0','0','0','0','0','3877','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26084','׵','http://www.edeng.cn/','1881','7','0','0','0','0','0','1098','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26083','Żڱ','http://koubeiafa6.allyes.com/main/adfclick?db=koubeiafa6&bid=1420,1363,124&cid=745,98,1&sid=5172&show=ignore&url=http://www.koubei.com/gocity.php?r=city.koubei.com/?f=E240_20_1','1881','2','0','0','0','0','0','256','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33200','취Ժ','http://www.cqcourt.gov.cn/','914','24','0','0','0','0','0','78','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34105','йմ','http://www.taoci365.com/','1193','1','0','0','0','0','0','4069','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35875','Էѳ','http://www.chushu168.com/','1267','8','0','0','0','0','0','1102','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27160','','http://www.jkb.com.cn/','1553','100','0','0','0','0','2','312','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27159','йѧ','http://www.chinacampus.org/','1553','100','0','0','0','0','0','844','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27158','ѧʱ±','http://zxss.ynet.com/','1553','100','0','0','0','0','0','251','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27157','ܱ','http://www.beijingreview.com.cn/','1553','100','0','0','0','0','0','521','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27154','걨','http://bjsn.ynet.com/','1553','100','0','0','0','0','0','220','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27153','Ƽ','http://bkb.ynet.com/','1553','100','0','0','0','0','0','298','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27152','ܿ','http://bjqn.ynet.com/','1553','100','0','0','0','0','0','556','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27151','һƾձ','http://dycj.ynet.com/','1553','100','0','0','0','0','1','908','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27150','Ϣҵ','http://xxcy.ynet.com/','1553','100','0','0','0','0','1','300','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27149','','http://www.thefirst.cn/','1553','100','0','0','0','0','0','249','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27148','','http://fzwb.ynet.com/','1553','100','0','0','0','0','0','2038','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27146','ʱ','http://www.jinghua.cn/','1553','100','0','0','0','0','0','749','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27145','¾','http://www.thebeijingnews.com/','1553','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27144','걨','http://www.ynet.com/','1553','100','0','0','0','0','0','1595','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27143','̱','http://www.bbtnews.com.cn/','1553','100','0','0','0','0','0','373','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27141','','http://www.morningpost.com.cn/','1553','100','0','0','0','0','0','1989','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('27140','-ձ','http://www.bjnews.com.cn/','1553','100','0','0','0','0','0','185','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21398','йƷɹ','http://www.china-gift.cc/','925','6','0','0','0','0','0','1464','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21421','չ','http://www.beijingite.com/','2062','1','0','0','0','0','0','2001','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33885','','http://www.chinapost.gov.cn/','2180','21','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21415','NULL','http://www.xjtoy.com/½','2062','14','0','0','0','0','0','779','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21396','Ʒ','http://www.bxhr.com.cn/','2061','1','0','0','0','0','0','870','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21402','Ʒ','http://www.15gift.com/','2061','9','0','0','0','0','0','5976','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21408','NULL','http://www.toystrade.cn/й߽','926','106','0','0','0','0','0','2328','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21390','۴','http://www.toys.hc360.com/','926','1','0','0','0','0','0','733','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40088','߲ʻ','http://www.7caihua.com/','2174','4','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40089','ɯʻ','http://www.salala.com.cn/','2174','3','0','0','0','0','0','3','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21386','Ͱ߹','http://search.china.alibaba.com/offer/%E7%8E%A9%E5%85%B7%E7%BD%91.html','926','5','0','0','0','0','0','9','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21381','乤Ʒ','http://www.19art.com/','2063','9','0','0','0','0','0','793','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33886','','http://www.sach.gov.cn/','2185','58','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21406','','http://www.xmtoy.com','2062','2','0','0','0','0','0','1292','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21382','Ʒ','http://www.wg365.com/lipin.htm','925','3','0','0','0','0','0','2087','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('21372','й','http://www.wanju.cn/','926','1','0','0','0','0','0','25','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40131','ֹίԱ','http://www.china-language.gov.cn/','2184','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35066','2007ޱ-Ѻ','http://asiancup2007.sohu.com/','1030','1','0','0','0','0','0','411','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5012','л','http://www.chinatoynet.com','926','4','0','0','0','0','0','7597','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5015','NULL','http://www.todaytoy.comȪݽ','2062','7','0','0','0','0','0','2981','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35983','ͨѧ','http://www.xjtu.edu.cn/','951','16','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5020','NULL','http://www.sinotoys.net/й','926','100','0','0','0','0','0','2519','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5023','NULL','http://www.todaytoy.com/','926','107','0','0','0','0','0','5695','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35881','CNTVʳ̨','http://food.cntv.cn/','739','1','0','0','0','0','0','4137','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39928','[Ӣ]','http://www.evertonfc.com/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39929','ˮ[Ӣ]','http://www.cpfc.co.uk/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5030','Ѻ','http://sports.sohu.com','928','2','0','0','0','0','0','9408','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5031','Ѷ','http://sports.qq.com','928','7','0','0','0','0','0','10919','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5032','̳','http://sports.tom.com','928','3','0','0','0','0','0','12027','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5033','','http://sports.163.com','928','5','0','0','0','0','0','7832','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36704','ɳ','http://forum.sports.sina.com.cn/','929','3','0','0','0','0','0','1102','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36722','-','http://www.trybb.com/','1990','7','0','0','0','0','1','12198','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5037','','http://www.sportscn.com','928','4','0','0','0','0','0','6733','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5039','21CN','http://sports.21cn.com','928','14','0','0','0','0','0','4186','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39924','ķȴ[Ӣ]','http://www.spurs.co.uk/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5042','ESPNSTAR','http://www.espnstar.com.cn','928','8','0','0','0','0','0','9835','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5043','','http://www.myler.cn/football/index.htm','928','20','0','0','0','0','0','3092','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5044','','http://www.sport.gov.cn','928','16','0','0','0','0','0','390','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5046','ǿ','http://www.sports.cn','928','12','0','0','0','0','0','2418','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36720','265GҳϷ','http://www.265g.com/','2141','1','0','0','0','0','0','16353','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39732','NULL','http://www.343.com.cn/343','928','118','0','0','0','0','0','114','0','','lzb','0','0','1283097600','1283097600','','1');
INSERT INTO ylmf_site VALUES('34603','Ŀ','http://bbs.haha168.com/','1930','18','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18362','Ų','http://www.artron.net/','1012','2','0','0','0','0','0','15375','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5059','sohu̳','http://club.sports.sohu.com/','929','1','0','0','0','0','0','1033','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38668','CCTV','http://bbs.cntv.cn/index.php?gid=30346','929','5','0','0','0','0','0','469','0','','lwh','0','0','1282752000','1282752000','','1');
INSERT INTO ylmf_site VALUES('5063','̳','http://bbs1.people.com.cn/boardList.do?action=postList&boardId=30','929','7','0','0','0','0','0','590','0','','ljm','0','0','1282752000','1282752000','','1');
INSERT INTO ylmf_site VALUES('5064','TOM̳','http://bbs.sports.tom.com/','929','6','0','0','0','0','0','45','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5065','»','http://forum.home.news.cn/listtopic.jsp?bid=93','929','8','0','0','0','0','0','463','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33478','й','http://live.sports.tom.com/html/team/11.html','2057','12','0','0','0','0','0','546','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33477','ɼ촬','http://live.sports.tom.com/html/team/23.html','2057','28','0','0','0','0','0','704','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33476','ɼ˶','http://live.sports.tom.com/html/team/25.html','2057','2','0','0','0','0','0','22227','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33475','˹̫','http://live.sports.tom.com/html/team/24.html','2057','9','0','0','0','0','0','1864','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33474','Ϸ˹ܶ','http://live.sports.tom.com/html/team/18.html','2057','11','0','0','0','0','0','437','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33473','йչҵһŹ˾','http://www.avic1.com.cn/','1641','42','0','0','0','0','0','264','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33472','˹Сţ','http://live.sports.tom.com/html/team/28.html','2057','8','0','0','0','0','0','2765','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33471','ʥ̶','http://live.sports.tom.com/html/team/30.html','2057','7','0','0','0','0','0','3841','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33470','˹ٻ','http://live.sports.tom.com/html/team/19.html','2057','1','0','0','0','0','0','104590','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33469','»NBA','http://www.xinhuanet.com/sports/nba.htm','2272','7','0','0','0','0','0','10792','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33465','йװŹ˾','http://www.chinasouth.com.cn/','1641','39','0','0','0','0','0','579','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36257','WNBAٷվ','http://www.wnba.com/','2272','10','0','0','0','0','0','39602','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36260','21CN-NBA','http://sports.21cn.com/basketball/nba/','2272','8','0','0','0','0','0','18674','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5083','Ѻ','http://outdoor.travel.sohu.com','931','1','0','0','0','0','0','749','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5084','Ұ','http://www.lvye.info','931','2','0','0','0','0','0','1300','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5085','й','http://www.8264.com','931','5','0','0','0','0','0','125','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5086','','http://www.ezlife.com.cn','931','9','0','0','0','0','0','1061','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5087','йɽЭ','http://cmasports.sport.org.cn','931','10','0','0','0','0','0','238','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36040','йЭ','http://icehockey.sport.org.cn/','931','20','0','0','0','0','0','19','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5089','йЭ','http://www.caa.net.cn','932','4','0','0','0','0','0','1209','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5090','йȭ','http://www.chinatkd.com','932','3','0','0','0','0','1','1501','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5091','йЭ','http://www.cga.net.cn','932','9','0','0','0','0','0','847','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36095','й˾','http://www.sikao.com.cn/','994','2','0','0','0','0','0','1467','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5093','ѺF1','http://f1.sports.sohu.com','933','2','0','0','0','0','0','1328','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5094','ϺF1','http://f1.online.sh.cn','933','17','0','0','0','0','0','170','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5095','F1','http://www.f1-ol.com','933','5','0','0','0','0','0','92','0','','xiaoku','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5096','й','http://www.ourracing.com','933','19','0','0','0','0','0','352','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5098','ӹٷվ','http://www.ferrariworld.com','933','27','0','0','0','0','0','481','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5101','chinaF1Ѷ','http://www.chinaf1.net','933','12','0','0','0','0','0','52','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5106','F1й','http://www.f1china.com.cn','933','16','0','0','0','0','0','203','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5107','-F1','http://f1.163.com','933','6','0','0','0','0','0','793','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5108','21CN-F1','http://f1.21cn.com','933','9','0','0','0','0','0','147','0','','xiaoku','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5109','ķ˹ӹٷվ','http://bmw.williamsf1.com/','933','25','0','0','0','0','0','40','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5110','-̫ƽ','http://www.pcauto.com.cn/playcar/racing/','933','10','0','0','0','0','0','192','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18029','йƹ','http://cttsl.sports.cn/','935','8','0','0','0','0','0','986','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5125','йƹ','http://www.cn-tt.com','935','9','0','0','0','0','0','2926','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5127','йƹЭ','http://tabletennis.sport.org.cn','935','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5128','-ƹ','http://center.sportscn.com/content/othersports/pingpang','935','18','0','0','0','0','0','522','0','','xiaoku','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5129','Ӣƹ','http://www.pingpang.info/','935','10','0','0','0','0','0','1676','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5130','ƹϻ','http://www.ittf.com','935','2','0','0','0','0','0','108','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5132','µƹ','http://www.swordtt.com/bbs','935','19','0','0','0','0','0','824','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5133','ӿƴƹЭ','http://www.ttazsc.com','935','21','0','0','0','0','0','281','0','','xiaoku','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5134','','http://www.ma-lin.com','935','23','0','0','0','0','0','1174','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5136','ձ-ƹ','http://sports.people.com.cn/GB/22155/22162/','935','17','0','0','0','0','0','390','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5137','̳-ƹ','http://sports.tom.com/jhty/pyzx.html','935','20','0','0','0','0','0','420','0','','xiaoku','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5138','ƹұ','http://sports.zaobao.com/index/tt.html','935','22','0','0','0','0','0','1462','0','','xiaoku','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5141','CCTV-ƹ','http://www.cctv.com/sports/item/table_tennis/index.shtml','935','11','0','0','0','0','0','1991','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5142','NULL','http://www.sinosports.net/items/pingpang/pingpangtemp.phpƹ','935','13','0','0','0','0','0','932','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18025','Ǽ','http://www.kong-linghui.com/','935','24','0','0','0','0','0','601','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18024','ƹѵ','http://www.cttazd.com/','935','15','0','0','0','0','0','2064','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5147','2008˻ٷվ','http://www.beijing2008.cn/','936','1','0','0','0','0','2','13083','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5148','','http://www.tennis.com.cn','937','1','0','0','0','0','0','2203','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5149','Tennis123','http://www.tennis123.net','937','8','0','0','0','0','0','314','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5151','ŮӢĹٷ','http://www.wtatour.com','937','20','0','0','0','0','0','200','0','','lzb','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5154','Ѷ-','http://sports.qq.com/qqtennis/','937','5','0','0','0','0','0','222','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36703','-۽','http://cache.tianya.cn/new/publicforum/articleslist.asp?stritem=sport&idwriter=0&key=0&part=','929','2','0','0','0','0','0','537','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5158','','http://www.goalchina.net','938','13','0','0','0','0','0','40','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5159','й','http://www.sportsol.com.cn','938','3','0','0','0','0','0','3666','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5160','','http://gzsoccer.dayoo.com','938','6','0','0','0','0','0','931','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5161','NULL','http://www.chinapress.com.my/topic/soccer03/ܱ','938','14','0','0','0','0','0','2001','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5162','ܱ','http://www.cnhubei.com/tyzhb','938','4','0','0','0','0','0','2202','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5163','','http://www.modernsports.com.cn','938','10','0','0','0','0','0','612','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5164','ձ','http://www.dfsports.com.cn','938','5','0','0','0','0','0','390','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5167','','http://www.huabao.net/sports','938','7','0','0','0','0','0','593','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5169','','http://www.ycwb.com/misc/jyty.htm','938','9','0','0','0','0','0','563','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5172','й','http://www.sportsol.com.cn/yls/paper/zgzqb/','938','12','0','0','0','0','0','4199','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35404','ɹƸ','http://www.nmlr.cn/','1532','12','0','0','0','0','0','204','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35403','ɹ˲','http://www.nmgrc.net/','1532','10','0','0','0','0','0','104','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35402','NULL','http://www.nmrcw.com/ɹٴ˲','1532','9','0','0','0','0','0','87','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35401','лӢ','http://searchjob.chinahr.com/SearchResult.aspx?occParentIDList=255&indIDList=255&myLocIDList=3000&prj=bdkeyword&jtr=956657646&jtrr=','1532','4','0','0','0','0','0','81','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34828','ŷ','http://www.lcfunds.com/','1996','20','0','0','0','0','0','600','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35400','NULL','http://www.sxsbys.com/ʡҵҵ','1537','15','0','0','0','0','0','526','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40306','','http://www.kutj.com','1887','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35399','˲|','http://www.0916rc.com/','1537','14','0','0','0','0','0','265','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40304','ʳƷ','http://www.foodol.org','1229','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35396','˲','http://www.guanzhongrc.com/','1537','13','0','0','0','0','0','607','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5187','-߶','http://golf.sina.com.cn','940','1','0','0','0','0','0','345','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5189','й߶','http://www.21golf.com','940','11','0','0','0','0','0','164','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5190','TOM-߶','http://golf.tom.com','940','2','0','0','0','0','0','145','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5191','߶ʱ','http://www.golftime.com.cn','940','8','0','0','0','0','0','116','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5192','й߶Э','http://www.golf.org.cn','940','13','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5193','߶','http://www.golfclub.com.cn','940','12','0','0','0','0','0','92','0','','xiaoku','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5194','Ƹ','http://www.golf998.com/','940','7','0','0','0','0','0','27','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36055','Դᱣϲ','http://www.mohrss.gov.cn/','996','6','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5197','NULL','http://www.sinosports.net/items/golf/golf.php߶','940','4','0','0','0','0','0','86','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36058','ҹԱ','http://www.chinagwy.org/','996','5','0','0','0','0','0','5279','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36057','ͼ-Ա','http://www.htexam.com/Index.html','996','8','0','0','0','0','0','769','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36056','й','http://www.offcn.com/','996','3','0','0','0','0','0','62','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35248','','http://www.19999.cn/','941','9','0','0','0','0','0','2199','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5203','','http://www.qgren.com','941','2','0','0','0','0','0','3700','0','','xiaoku','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5206','̳','http://www.qigongtech.com','941','8','0','0','0','0','0','1222','0','','xiaoku','0','0','1283011200','1283011200','','1');
INSERT INTO ylmf_site VALUES('5207','','http://www.21qigong.com','941','7','0','0','0','0','0','2863','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5208','̨ӽ','http://www.top147.com','942','4','0','0','0','0','0','1608','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5209','˹ŵĹٷվ','http://sports.tom.com/snooker','942','9','0','0','0','0','0','25','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5210','й̨Э','http://billiards.sport.org.cn','942','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36073','Ѻ-̨','http://sports.sohu.com/1/1102/50/subject204255055.shtml','942','3','0','0','0','0','0','867','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5212','͹ٷվ','http://www.snookerding.com/','942','7','0','0','0','0','0','1477','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5213','-̨','http://sports.sina.com.cn/others/snooker.shtml','942','1','0','0','0','0','0','2352','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5215','йƹЭ','http://tabletennis.sport.org.cn','943','5','0','0','0','0','0','3424','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5216','йЭ','http://www.fa.org.cn','943','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5217','йëЭ','http://www.cba.org.cn','943','4','0','0','0','0','0','290','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5218','йЭ','http://www.basketball.org.cn','943','2','0','0','0','0','0','9814','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5219','й̨Э','http://billiards.sport.org.cn','943','13','0','0','0','0','0','928','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5220','й߶Э','http://www.golf.org.cn','943','8','0','0','0','0','0','203','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5221','йЭ','http://handball.sport.org.cn','943','11','0','0','0','0','0','70','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5223','йЭ','http://jianqiu.sport.org.cn','943','15','0','0','0','0','0','46','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34609','ѧ̳','http://bbs.guoxue.com/','1930','20','0','0','0','0','0','1470','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5225','йЭ','http://www.volleyball.org.cn','944','14','0','0','0','0','0','111','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5226','Ż-','http://cn.sports.yahoo.com/others/volley','944','5','0','0','0','0','0','315','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5227','л-','http://sports.china.com/zh_cn/sportsnews/other/volleyball','944','12','0','0','0','0','0','395','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5228','й','http://cva.sina.com.cn/','944','6','0','0','0','0','0','1203','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5229','-','http://center.sportscn.com/content/othersports/vollyball','944','9','0','0','0','0','0','160','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5230','Ѻ-','http://sports.sohu.com/1/1102/74/subject204187448.shtml','944','2','0','0','0','0','0','1029','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5231','-̳','http://sports.tom.com/allsports/volleyball/','944','3','0','0','0','0','0','276','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5232','-','http://sports.163.com/t_index/000802_99.html','944','7','0','0','0','0','0','294','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5234','[Ӣ]','http://www.fivb.ch/','944','15','0','0','0','0','0','54','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5235','NULL','http://www.sinosports.net/items/volleyball/volleyball.php-','944','10','0','0','0','0','0','261','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34056','־','http://www.wulinjj.com/','1670','13','0','0','0','0','0','6950','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5241','ChinaRenУ¼','http://alumni.chinaren.com','947','1','0','0','0','0','0','6725','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5242','ͬѧ¼','http://alumni.163.com','947','3','0','0','0','0','0','2851','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36612','face7','http://www.face7.com/?from=114la','852','20','0','0','0','0','0','46777','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39893','Ѷ-08йѧа','http://edu.qq.com/zt/2008/08topuniv/','1690','5','0','0','0','0','0','62','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5252','йͬѧ¼','http://www.5460.net/','947','6','0','0','0','0','0','313','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5328','ѧ','http://www.pku.edu.cn','951','1','0','0','0','0','0','11162','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5329','廪ѧ','http://www.tsinghua.edu.cn','951','2','0','0','0','0','0','2165','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5330','人ѧ','http://www.whu.edu.cn','951','9','0','0','0','0','0','1057','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5331','Ϻͨѧ','http://www.sjtu.edu.cn','951','4','0','0','0','0','0','5181','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5332','ʦѧ','http://www.bnu.edu.cn','951','5','0','0','0','0','0','1550','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5333','йѧ','http://www.ruc.edu.cn','951','6','0','0','0','0','0','2910','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5334','ѧ','http://www.fudan.edu.cn','951','7','0','0','0','0','0','3428','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5335','ϴѧ','http://www.seu.edu.cn','951','8','0','0','0','0','0','773','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5336','㽭ѧ','http://www.zju.edu.cn','951','3','0','0','0','0','0','3537','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5337','Ŵѧ','http://www.xmu.edu.cn','951','17','0','0','0','0','0','2033','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5338','ѧ','http://www.tju.edu.cn','951','10','0','0','0','0','0','1298','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5339','ͬôѧ','http://www.tongji.edu.cn','951','11','0','0','0','0','0','2026','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5340','ƾѧ','http://www.cufe.edu.cn','951','12','0','0','0','0','0','1615','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31996','ʡͨϢ','http://www.jljt.gov.cn/','2195','19','0','0','0','0','0','377','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34718','ͨ','http://www.gxjt.gov.cn/','2022','21','0','0','0','0','0','772','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31992','й·','http://www.chinahighway.com/','1241','3','0','0','0','0','0','3187','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31991','֮ͨ-ϽͨƼϢ','http://www.jtstar.com/','2195','27','0','0','0','0','0','123','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35961','л˲','http://www.job110.cn/','958','18','0','0','0','0','0','6524','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31987','·ѯ','http://www.8684.cn/','1244','1','0','0','0','0','0','233','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31986','ĽͨϢ','http://www.nxcd.gov.cn/xinwen/default.asp','2195','34','0','0','0','0','0','143','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31985','ʡͨ','http://www.lncom.gov.cn/','2022','7','0','0','0','0','0','431','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31983','ʡͨ','http://www.sxsjtt.gov.cn/','2022','26','0','0','0','0','0','354','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31982','ϺͨϷ','http://www.shjt.net/index.htm','2195','21','0','0','0','0','0','657','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31981','ɽͨ','http://www.fsjtw.gov.cn/','2195','33','0','0','0','0','0','441','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31980','֣ݽͨϢ','http://www.zzjtj.gov.cn/','2195','32','0','0','0','0','0','371','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34719','ʡͨ','http://www.qjt.gov.cn/','2022','24','0','0','0','0','0','312','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34720','ͨ','http://2006.moc.gov.cn/06xizang/','2022','25','0','0','0','0','0','77','0','','lsz','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('31977','ͨίԱ','http://www.tjjt.gov.cn/','2022','3','0','0','0','0','0','165','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33683','ɭ','http://www.exxonmobilchemical.com.cn/','1640','7','0','0','0','0','0','214','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40829','ZDNet','http://bbs.zdnet.com.cn/','678','9','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18989','Ϸ','http://www.nfjy.cn/','991','15','0','0','0','0','0','1317','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18987','','http://www.qnr.cn/','991','6','0','0','0','0','0','913','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18968','51eduƷѧϰ','http://www.51edu.com/','991','11','0','0','0','0','0','44','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18963','й','http://www.neea.edu.cn/','991','16','0','0','0','0','0','10','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18962','ߵȽѧϢ','http://www.chsi.com.cn/','991','17','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36012','ϰб','http://www.altobelli.it/','1029','27','0','0','0','0','0','95','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18960','˽','http://edu.sina.com.cn/','991','2','0','0','0','0','0','100','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39980','йѧϰ','http://www.studycn.net/','954','6','0','0','0','0','0','28','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39981','ѧϰ','http://www.51study.net','954','11','0','0','0','0','0','22','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39979','MBAԶ̽','http://www.chinastudyclub.com','954','7','0','0','0','0','0','9','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39978','21ѧϰ','http://www.ourstudy.com','954','8','0','0','0','0','0','13','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39977','йѧ','http://6to23.com','954','5','0','0','0','0','0','18','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39975','ѧϰ','http://www.studycity.cn','954','10','0','0','0','0','0','21','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39976','лѧϰ','http://www.chinaedu.net','954','4','0','0','0','0','0','21','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39974','','http://www.hongen.com','954','3','0','0','0','0','0','28','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39972','Ѻ','http://learning.sohu.com','954','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39973','Ұѧϰ','http://www.5axx.com','954','2','0','0','0','0','0','19','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5419','廪ѧͼ','http://www.lib.tsinghua.edu.cn','955','1','0','0','0','0','0','8600','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5420','ѧͼ','http://www.lib.tju.edu.cn','955','22','0','0','0','0','0','177','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5421','人ѧͼ','http://www.lib.whu.edu.cn','955','6','0','0','0','0','0','525','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5422','ѧͼ','http://www.lib.pku.edu.cn','955','2','0','0','0','0','0','2887','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5424','NULL','http://lib.buaa.edu.cnͼ','955','53','0','0','0','0','0','179','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5425','ʦѧͼ','http://www.library.nenu.edu.cn','955','85','0','0','0','0','0','109','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5427','ʦѧͼ','http://www.lib.ecnu.edu.cn','955','71','0','0','0','0','0','127','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5428','ѧͼ','http://www.lib.gxu.edu.cn','955','73','0','0','0','0','0','227','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5429','ѧͼ','http://lib.bit.edu.cn','955','52','0','0','0','0','0','119','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5430','йѧͼ','http://www.lib.ruc.edu.cn','955','11','0','0','0','0','0','267','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5431','Ϻƾѧͼ','http://www.lib.shufe.edu.cn','955','77','0','0','0','0','0','157','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38319','','http://www.ihudie.com','1889','53','0','0','0','0','0','1186','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5433','ѧԺͼ','http://202.113.68.3','955','40','0','0','0','0','0','48','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5436','ϴѧͼ','http://www.lib.seu.edu.cn','955','76','0','0','0','0','0','114','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5437','㽭ѧͼ','http://libweb.zju.edu.cn','955','4','0','0','0','0','0','720','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5438','ʦѧͼ','http://www.lib.bnu.edu.cn','955','19','0','0','0','0','0','170','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5439','ɽѧͼ','http://lib.sdut.edu.cn','955','64','0','0','0','0','0','177','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5442','Ͽѧͼ','http://www.lib.nankai.edu.cn','955','12','0','0','0','0','0','173','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5443','ͼ','http://www.lib.scut.edu.cn','955','8','0','0','0','0','0','349','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5445','ͨѧͼ','http://www.lib.xjtu.edu.cn/','955','13','0','0','0','0','0','230','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5446','ʦѧͼ','http://lib.ccnu.edu.cn','955','55','0','0','0','0','0','107','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5447','йʴѧͼ','http://www.lib.cug.edu.cn','955','72','0','0','0','0','0','195','0','','luojie','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5448','NULL','http://lib.cpums.edu.cn׶ҽƴѧͼ','955','57','0','0','0','0','0','133','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5450','ͷѧͼ','http://www.lib.stu.edu.cn','955','79','0','0','0','0','0','184','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5451','ũҵѧͼ','http://lib.hzau.edu.cn','955','32','0','0','0','0','0','79','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5454','Ϻͼ','http://lib.shtvu.edu.cn','955','78','0','0','0','0','0','3','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5455','ɽѧͼ','http://library.sysu.edu.cn','955','15','0','0','0','0','0','187','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5456','մѧͼ','http://www.lib.ahu.edu.cn','955','70','0','0','0','0','0','199','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5457','Ĵѧͼ','http://www.lib.nxu.edu.cn','955','74','0','0','0','0','0','82','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5458','ҵѧͼ','http://www.lib.hit.edu.cn','955','88','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5459','ѧͼ','http://lib.jmu.edu.cn','955','62','0','0','0','0','0','172','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5460','ҵѧͼ','http://202.204.27.242','955','47','0','0','0','0','0','53','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5461','ɽѧͼ','http://www.lib.sxu.edu.cn','955','81','0','0','0','0','0','162','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5462','Ͼҵѧͼ','http://202.119.248.55','955','42','0','0','0','0','0','139','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5463','ѧͼ','http://www.lib.scuec.edu.cn','955','23','0','0','0','0','0','136','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5465','NULL','http://lib.hutc.zj.cnʦѧԺͼ','955','61','0','0','0','0','0','128','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5466','ҽѧԺͼ','http://210.37.79.3','955','50','0','0','0','0','0','88','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5467','ϴѧͼ','http://libgp.jnu.edu.cn','955','67','0','0','0','0','0','151','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5468','NULL','http://lib.hbu.edu.cnӱѧͼ','955','58','0','0','0','0','0','110','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5469','ϴѧͼ','http://210.37.32.30','955','49','0','0','0','0','0','128','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5472','ʦѧԺͼ','http://202.195.119.250','955','44','0','0','0','0','0','117','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5474','ʦѧͼ','http://lib.htu.cn/','955','59','0','0','0','0','0','260','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5475','Ͼѧͼ','http://202.119.47.3','955','5','0','0','0','0','0','235','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39951','ɽ³','http://www.lnts.com.cn/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33137','й̨','http://www.cetv.edu.cn/','749','6','0','0','0','0','0','4347','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33140','','http://www.cetv.com/','749','9','0','0','0','0','0','15220','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33141','TVB','http://www.tvb.com/','749','7','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33129','','http://www.hunantv.com/','749','4','0','0','0','0','0','5518','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33127','̨','http://www.btv.org/','749','3','0','0','0','0','0','15553','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33126','̨','http://www.cctv.com/','749','2','0','1','1','1','98','40263','40','','lwh','1','4','0','0','','0');
INSERT INTO ylmf_site VALUES('5554','NULL','http://www.jlchina.cnй','960','4','0','0','0','0','0','1455','0','','lzb','0','0','1271088000','1271088000','','1');
INSERT INTO ylmf_site VALUES('41277','վվ','http://www.eastadmin.com/','1709','13','0','0','0','0','0','0','0','','liao','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5556','','http://www.resume8.com','960','3','0','0','0','0','0','5662','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39894','ͬѧ','http://www.faceren.com/','947','100','0','0','0','0','0','32','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39950','÷˹[]','http://www.palmeiras.com.br/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5567','й','http://www.eol.cn/','962','18','0','0','0','0','0','6127','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36193','','http://www.moe.edu.cn/','962','5','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36192','¶','http://www.koolearn.com/','962','20','0','0','0','0','0','3136','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36190','йƷѧϰ','http://www.51edu.com/','962','14','0','0','0','0','0','2704','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36188','ѧ','http://www.sooxue.com/','962','10','0','0','0','0','0','1594','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36185','ѧ','http://www.studyez.com/','962','9','0','0','0','0','0','1801','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36184','','http://www.huaue.com/','962','12','0','0','0','0','0','568','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36182','·','http://www.yuloo.com/','962','8','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36180','й','http://www.jyb.com.cn/','962','19','0','0','0','0','0','1898','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36179','й','http://www.edu.cn/','962','17','0','0','0','0','0','3','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36178','Ϸ-Ƶ','http://www.southcn.com/edu/','962','6','0','0','0','0','0','851','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36177','˼','http://www.cersp.com/','962','7','0','0','0','0','0','1111','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38971','','http://www.rvedu.com','962','11','0','0','0','0','0','183','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36175','»-Ƶ','http://www.xinhuanet.com/edu/','962','4','0','0','0','0','0','1253','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32760','ʳ','http://www.foood.com.cn/','739','6','0','0','0','0','0','21901','0','','lwh','0','0','1285689600','1285689600','','1');
INSERT INTO ylmf_site VALUES('5620','533ѧϰ','http://edu.533.com','962','13','1','0','0','0','0','7327','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36166','ͬͬ³','http://www.tctd.net/','1054','5','0','0','0','0','1','488','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38896','Ӱ','http://www.nphoto.net/','2121','7','0','0','0','0','0','32132','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39338','ֽ','http://www.zhuoku.com/','711','13','0','0','0','0','0','63906','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5691','Сѧѧ','http://www.k12.com.cn','966','2','0','0','0','0','0','10214','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33809','2007й500ǿ','http://ccnews.people.com.cn/GB/87320/6202598.html','1641','2','0','0','0','0','0','7646','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40010','ֽѧԴ','http://www.ylhxjx.com/','966','5','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5699','NULL','http://www.edudown.net/СѧԴ','966','103','0','0','0','0','0','2300','0','','lzb','0','0','1278864000','1278864000','','1');
INSERT INTO ylmf_site VALUES('5743','','http://www.cdce.cn/','969','4','0','0','0','0','0','4915','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5744','NULL','http://www.naea.edu.cnҽѧԺ','969','103','0','0','0','0','0','1172','0','','lzb','0','0','1278864000','1278864000','','1');
INSERT INTO ylmf_site VALUES('5746','й','http://www.spe-edu.net','970','1','0','0','0','0','0','1208','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5748','й˰ٿ','http://www.chinalrbk.com','970','3','0','0','0','0','0','326','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5755','CAST','http://www.cast.org','970','7','0','0','0','0','0','169','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5756','й','http://www.cnnse.net/','970','5','0','0','0','0','0','300','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35939','ѧ-EIC½','http://www.eic.org.cn/Country/au/','1053','61','0','0','0','0','4','2048','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5876','˿Ƽʱ','http://tech.sina.com.cn/','975','1','0','0','0','0','0','1933','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5877','׿Ƽ','http://tech.163.com','975','2','0','0','0','0','0','573','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5878','ѶƼ','http://tech.qq.com','975','3','0','0','0','0','0','401','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5881','','http://www.ccidnet.com/','975','6','0','0','0','0','0','6292','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5882','йѧ','http://www.most.gov.cn','975','11','0','0','0','0','0','270','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5883','Ȼѧ','http://www.nsfc.gov.cn/','975','14','0','0','0','0','0','86','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5884','йѧԺ','http://www.cas.ac.cn','975','12','0','0','0','0','0','1422','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5885','йڿƼ','http://www.cpst.net.cn','975','10','0','0','0','0','0','163','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5887','лƼ','http://tech.china.com','975','4','0','0','0','0','0','1146','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5889','eNetȶ','http://www.enet.com.cn/','975','7','0','0','0','0','0','2068','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5891','йƼ','http://www.cstnet.net.cn','975','9','0','0','0','0','0','496','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38354','Ż','http://mail.cn.yahoo.com/','1068','6','0','0','0','0','0','41082','0','red','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5894','','http://www.chinabyte.com/','975','8','0','0','0','0','0','487','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5895','ҿƼɹ','http://www.nast.org.cn/','975','13','0','0','0','0','0','1875','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35579','ѧ','http://www.putixin.com/psy/','986','18','0','0','0','0','0','1066','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35615','ʷ̽΢-','http://xiangyata.net/history/index.php','983','18','0','0','0','0','0','222','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39796','˿Ƽ','http://tech.sina.com.cn/','1122','1','0','0','0','0','0','807','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35576','ѧ','http://www.xlxw.cn/','986','2','0','0','0','0','0','1077','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35590','ѧ','http://philosophyol.com/','987','2','0','0','0','0','0','1161','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35607','Ļ-ĻϢ','http://www.ccnt.com.cn/country/country.htm','977','6','0','0','0','0','0','144','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35606','Ƶ','http://www.21page.net/world_geography/index.asp','977','3','0','0','0','0','0','1076','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35605','ĵ-Ƶ','http://travel.163.com/subcategory/page0501.html','977','5','0','0','0','0','0','177','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5925','й߲','http://www.vegnet.com.cn','976','4','0','0','0','0','8','1271','0','','','2','2','0','0','','0');
INSERT INTO ylmf_site VALUES('5926','ͨƼ޹˾','http://www.ebiotrade.com','976','6','0','0','0','0','0','160','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40199','۴ϻ','http://www.ep.hc360.com','1247','28','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5928','йũҵAgronet','http://www.agronet.com.cn','976','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5929','й＼Ϣ','http://www.biotech.org.cn','976','1','0','0','0','0','0','78','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5931','йϢ','http://www.biosino.org','976','3','0','0','0','0','0','680','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5932','Ѷ','http://www.bio168.com','976','7','0','0','0','0','0','381','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5933','Ϻ＼','http://www.genecore.com','976','16','0','0','0','0','0','133','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5934','йﻯ','http://www.chinabiochem.net','976','8','0','0','0','0','0','5','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5936','','http://www.csdyzx.com/swtd/index.html','976','12','0','0','0','0','0','1100','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5937','йŴ','http://www.chinagene.cn','976','9','0','0','0','0','0','448','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5938','о','http://www.zdsw.com.cn','976','18','0','0','0','0','0','203','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35604','NULL','http://nfgis.nsdi.gov.cn/һϢϵͳ','977','4','0','0','0','0','0','0','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35603','ѧ','http://dili.fsjy.net/Sites/dili/default.asp','977','2','0','0','0','0','0','415','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5941','пԺɶ','http://www.cib.ac.cn','976','10','0','0','0','0','0','144','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35602','йҵ','http://www.cng.com.cn/','977','1','0','0','0','0','0','1295','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5947','㶫＼','http://www.biotech.org.cn/','976','15','0','0','0','0','0','1282','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5950','йˮ','http://www.h2o-china.com','977','14','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40209','Ҫѧ','http://www.51zxw.net','1124','11','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35610','Ͽйʷо','http://ccsh.nankai.edu.cn/noscript/ccsh/','983','2','0','0','0','0','0','65','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5954','пԺ','http://www.igsnrr.ac.cn','977','15','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5955','','http://www.dili8.com','977','7','0','0','0','0','0','1059','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5956','','http://www.dlpd.com','977','11','0','0','0','0','0','661','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32783','˿-KOSE','http://www.kose.co.jp/','737','8','0','0','0','0','0','1095','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32782','','http://www.maybellinechina.com/','737','6','0','0','0','0','1','2352','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35609','','http://www.sach.gov.cn/','983','1','0','0','0','0','0','14','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5960','㽭ʡѧ','http://www.gszj.org','977','12','0','0','0','0','0','95','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5961','ѧչ','http://www.progressingeography.com','977','10','0','0','0','0','0','222','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5962','ҵռϢЭίԱ','http://www.ngicc.gov.cn','977','13','0','0','0','0','0','135','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35608','NULL','http://www.16388.com16388','853','100','0','0','0','0','0','1359','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5964','йɫ','http://www.sepu.net','978','100','0','0','0','0','0','754','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5965','лѧ','http://www.organicchem.com','978','100','0','0','0','0','0','1017','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5967','ѧԴ','http://www.ngedu.net','978','100','0','0','0','0','0','459','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5968','ѧ','http://202.194.4.238/chemnew/','978','100','0','0','0','0','0','1019','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5969','Ұѧ','http://www.52hx.net','978','100','0','0','0','0','0','794','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41325','YOKAݽ','http://shoushen.yoka.com','864','23','0','0','0','0','0','0','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5971','Ǿṹ','http://www.crystalstar.org','978','100','0','0','0','0','0','310','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5972','йѧ','http://www.ccs.ac.cn','978','100','0','0','0','0','0','293','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5973','йϢ','http://www.cncic.gov.cn','978','100','0','0','0','0','0','53','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5974','ѧϢ','http://www.hxxx.net','978','100','0','0','0','0','0','474','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5975','йѧƷȫ','http://www.nrcc.com.cn','978','100','0','0','0','0','0','170','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5976','ѧ','http://www.33ge.com/','978','100','0','0','0','0','0','572','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5977','лѧ԰','http://hx.ptzx.net','978','100','0','0','0','0','0','690','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5978','ѧѶվ[̨]','http://www.chemedu.ch.ntu.edu.tw','978','100','0','0','0','0','0','249','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5980','ѧо[̨]','http://chemwww.pu.edu.tw','978','100','0','0','0','0','0','172','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5982','йѧ','http://www.mathfan.com','979','8','0','0','0','0','0','1172','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5984','NULL','http://www.cnmaths.com','979','6','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5985','ѧվ','http://www.maths168.com','979','10','0','0','0','0','0','679','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5986','ѧ','http://www.czsx.com.cn/','979','2','0','0','0','0','0','2148','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5987','ѧѧѧ','http://www.rasx.net','979','12','0','0','0','0','0','54','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5988','ѧʱ','http://www.shuxue123.com','979','13','0','0','0','0','0','31','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5989','йѧ','http://www.cms.org.cn/','979','1','0','0','0','0','0','1045','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5993','йѧԺо','http://www.iphy.ac.cn','980','2','0','0','0','0','0','496','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5994','ѧ','http://www.iop.org','980','8','0','0','0','0','0','290','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5995','пԺо','http://www.ibp.ac.cn','980','13','0','0','0','0','0','157','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5996','й','http://www.cpenet.org.cn','980','3','0','0','0','0','0','658','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5997','ѧ','http://wulixb.iphy.ac.cn','980','7','0','0','0','0','0','608','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('5998','ѧ','http://www.ccxcc.com','980','9','0','0','0','0','0','470','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6003','','http://www.wuli.ac.cn','980','12','0','0','0','0','0','1206','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6004','Э','http://www.aps.org','980','20','0','0','0','0','0','226','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6005','㽭о','http://zimp.zju.edu.cn','980','17','0','0','0','0','0','148','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6006','ŷЭ','http://www.eps.org','980','19','0','0','0','0','0','170','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6008','ӵ','http://www.yych.com','980','11','0','0','0','0','0','793','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6009','Ϻ̨','http://www.astron.sh.cn','981','100','0','0','0','0','0','1529','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6010','պNASA','http://www.nasa.gov','981','100','0','0','0','0','0','1681','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6011','Ϻ̨','http://center.shao.ac.cn','981','100','0','0','0','0','0','694','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6012','Ĺ','http://www.bjp.org.cn','981','100','0','0','0','0','0','956','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6013','ǿ','http://www.cosmoscape.com/','981','100','0','0','0','0','0','348','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6015','пԺ̨','http://www.bao.ac.cn','981','100','0','0','0','0','0','172','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6020','ŷ޿ռ(ESA)','http://www.esa.int','981','100','0','0','0','0','0','377','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6023','̨','http://www.nrao.edu','981','100','0','0','0','0','0','472','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6024','Ժ[̨]','http://www.asiaa.sinica.edu.tw','981','100','0','0','0','0','0','216','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6026','ǺѰ','http://skydr.lamost.org','981','100','0','0','0','0','0','1650','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6027','ŷϷ̨','http://www.hq.eso.org','981','100','0','0','0','0','0','164','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6028','Ѷ','http://cmcn.y234.cn/','981','100','0','0','0','0','0','373','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6029','̫շ','http://www.spaceflight.nasa.gov','981','100','0','0','0','0','0','375','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6030','ѧ','http://www.iau.org','981','100','0','0','0','0','0','395','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6031','֮','http://www.lzsky.com.cn','981','100','0','0','0','0','0','852','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6032','Cfa Research','http://cfa-www.harvard.edu','981','100','0','0','0','0','0','161','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6033','̫ϵģ','http://space.jpl.nasa.gov','981','100','0','0','0','0','0','1261','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35694','Ʒ','http://www.slzp.net.cn/','1201','7','0','0','0','0','0','489','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35675','ռѧʵ','http://www.spaceweather.ac.cn/','989','25','0','0','0','0','0','78','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35674','΢＼ʵ','http://www.mbtech.sdu.edu.cn/','989','24','0','0','0','0','0','162','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35673','ֲŴʵ','http://www.nlpmg.labs.gov.cn/','989','22','0','0','0','0','0','96','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35672','ϸʵ','http://finechem.dlut.edu.cn/','989','21','0','0','0','0','0','239','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35671','ѧʵ','http://pcss.xmu.edu.cn/','989','20','0','0','0','0','0','103','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35664','㶫ʡصʵ','http://gdlab.gdstc.gov.cn/','989','17','0','0','0','0','0','154','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40281','³ʦ','http://www.ludashi.com/','1101','6','0','0','0','0','0','0','0','#000000','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40212','','http://www.changde.gov.cn/','1855','7','0','0','0','0','0','0','0','','luojie','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35620','-˽','http://www.pep.com.cn/gzwl/index.htm','980','16','0','0','0','0','0','896','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35619','վ','http://www.wuli.com.cn/','980','15','0','0','0','0','0','613','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6047','ѧ','http://www.guoxue.com','983','11','0','0','0','0','0','3','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6049','ѧ','http://www.acriticism.com','983','12','0','0','0','0','0','117','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6051','лʷ','http://www.historychina.net','983','14','0','0','0','0','0','497','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6052','ʷϵ̳','http://www.wangf.net','983','19','0','0','0','0','0','1410','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6054','ʷо','http://www.qingstudy.com','983','20','0','0','0','0','0','628','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6055','ϺԺʷ','http://www.historyshanghai.com','983','15','0','0','0','0','0','74','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6057','ʷѧо','http://www.3hresearch.com','983','5','0','0','0','0','0','236','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6058','ͳй','http://www.historicalchina.net','983','13','0','0','0','0','0','458','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6059','Ժʷо','http://www.ihp.sinica.edu.tw','983','16','0','0','0','0','0','16','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6060','ʷ԰','http://3028.x5dj.com/','983','6','0','0','0','0','0','611','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35159','ղ','http://www.meishichina.com/Topic/CaiXi/SuCai/','2080','4','0','0','0','0','0','31925','0','','lzb','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('6063','ϴйʷо','http://ccsh.nankai.edu.cn','983','17','0','0','0','0','0','55','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6064','ݴѧػѧо','http://dhxyjs.lzu.edu.cn','983','3','0','0','0','0','0','101','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6065','','http://www.6ch.com.cn','983','7','0','0','0','0','0','377','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6066','йҵϢ','http://cinic.cj.hexun.com/','984','8','0','0','0','0','0','334','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6067','йϢ','http://www.cei.gov.cn','984','9','0','0','0','0','0','776','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6068','ֵй','http://www.chinavalue.net','984','10','0','0','0','0','0','330','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6072','йо','http://www.ccer.edu.cn','984','12','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6073','÷','http://www.cel.cn','984','20','0','0','0','0','0','75','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6074','˹[]','http://www.forbes.com','984','25','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6075','йͶЭ','http://www.iac.org.cn','984','13','0','0','0','0','0','136','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6076','òο','http://jjckb.xinhuanet.com/','984','14','0','0','0','0','0','191','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6077','й50̳','http://www.50forum.org.cn','984','23','0','0','0','0','0','367','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6078','羭ѧ','http://economist.icxo.com','984','19','0','0','0','0','0','231','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6079','ѧ԰','http://www.beiwang.com','984','22','0','0','0','0','0','73','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40207','e','http://www.etpass.com','895','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6083','Ժչо','http://www.drcnet.com','984','17','0','0','0','0','0','48','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6084','NULL','http://www.feer.com Զ[]','984','24','0','0','0','0','0','115','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6085','йøĸо','http://www.crfoundation.org','984','16','0','0','0','0','0','58','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6086','񾭼о','http://www.neri.org.cn','984','15','0','0','0','0','0','75','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6087','ѧ˼','http://www.zz6789.com','985','13','0','0','0','0','0','228','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6088','йѡ','http://www.chinaelections.org','985','6','0','0','0','0','0','74','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6089','йѧԺ','http://cms.cyu.edu.cn/','985','4','0','0','0','0','0','157','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35596','ѧ','http://pol.hengqian.com/','985','3','0','0','0','0','0','107','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6092','ƶȷ빫','http://www.wiapp.org','985','5','0','0','0','0','0','99','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41171','','http://www.junzimen.com/','665','9','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35594','йѧ','http://chinaps.cass.cn/','985','1','0','0','0','0','0','309','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6095','νѧ','http://www.eduhao.com/Index.html','985','14','0','0','0','0','0','163','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6096','ط˴','http://www.asrd.gov.cn/index.asp','985','10','0','0','0','0','0','49','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38356','','http://www.dehuaca.com/','1949','15','0','0','0','0','0','79','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6099','йѧԺо','http://www.psych.ac.cn','986','11','0','0','0','0','0','169','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35569','йѧ','http://www.psych.org.cn/','986','1','0','0','0','0','0','3744','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6107','йͳĻ','http://www.enweiculture.com','987','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6108','2000','http://www.confucius2000.com','987','3','0','0','0','0','0','703','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6109','й','http://www.chinakongzi.net','987','4','0','0','0','0','0','33','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6110','ѧ','http://www.zxrs.net','987','5','0','0','0','0','0','1901','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35591','ѧ','http://www.philosophys.net/','987','17','0','0','0','0','0','806','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35592','','http://cn.creative.com/','1686','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6114','ѧŴѧо','http://zhouyi.sdu.edu.cn','987','11','0','0','0','0','0','1386','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6115','йѧ','http://www.confuchina.com','987','9','0','0','0','0','0','350','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6116','','http://www.lee-philosophy.org','987','12','0','0','0','0','0','778','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6117','ѧо','http://www.rxyj.org','987','13','0','0','0','0','0','297','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6118','ԭ','http://www.yuandao.com','987','16','0','0','0','0','0','494','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6121','о','http://www.bamboosilk.org','987','15','0','0','0','0','0','151','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6122','ѧ̽','http://www.heima.com/web/home1.srf?userid=1533212','987','14','0','0','0','0','0','739','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6123','лЭ','http://www.c-z-y.com','987','18','0','0','0','0','0','783','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35573','йѧ','http://www.cnpsy.net/','986','7','0','0','0','0','0','484','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35575','йҽѧ','http://cmpsycho.bjmu.edu.cn/','986','10','0','0','0','0','0','417','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11603','ϺУ','http://www.myler.cn/xiaoyuan_gaoxiao/950.htm#1291','950','2','0','0','0','0','0','3735','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32769','̩ڶֳ','http://www.dghuatai.com/','2176','23','0','0','0','0','0','5845','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32767','ʢֳ̩','http://www.5858555.com/','2176','25','0','0','0','0','0','5212','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6174','пԺ','http://www.igsnrr.ac.cn','989','6','0','0','0','0','0','312','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6175','пԺо','http://www.kiz.ac.cn','989','7','0','0','0','0','0','165','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6176','Դʵ','http://www.lreis.ac.cn','989','5','0','0','0','0','0','126','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6177','ɺݵ̬صʵ','http://arid.lzu.edu.cn','989','11','0','0','0','0','0','97','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6180','԰','http://www.exam8.com','991','7','0','0','0','0','0','4421','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6181','ǿ','http://www.51test.net','991','5','0','0','0','0','0','1387','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6182','¶','http://www.koolearn.com/','991','3','0','0','0','0','0','1145','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6183','·','http://www.yuloo.com/','991','9','0','0','0','0','0','7910','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6195','йԴ','http://www.5exam.com/','991','12','0','0','0','0','0','2726','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40644','ֿ쳵','http://www.yykc.com/','716','6','0','0','0','0','0','33','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6200','','http://exam.eastday.com/','991','8','0','0','0','0','0','1055','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40643','ưٶ','http://www.7xpc.com/','886','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40642','Ů','http://www.27.cn/','735','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6220','Կ365','http://www.zikao365.com','992','1','0','0','0','0','0','8292','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6238','Կϵʽ','http://edu.sina.com.cn/zikao/0/17.html','992','5','0','0','0','0','0','1992','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6245','н','http://www.cnedu.cn','993','7','0','0','0','0','0','4323','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6247','мվ','http://www.kaoyan.com','993','8','0','0','0','0','0','2547','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6248','й','http://www.chinakaoyan.com','993','4','0','0','0','0','0','9291','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6250','-','http://www.okhere.net','2265','9','0','0','0','0','0','1065','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6251','й','http://www.kaoyantj.com','993','6','0','0','0','0','0','1495','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6254','-','http://www.huaue.com/ky.htm','993','5','0','0','0','0','0','906','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6268','ɽ','http://www.chinalawedu.com','994','4','0','0','0','0','0','1662','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33793','Delphi-л','http://tech.china.com/zh_cn/netschool/programme/delphi/','1158','3','0','0','0','0','0','374','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6270','˾','http://www.wanguoschool.net','994','13','0','0','0','0','0','750','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33792','ȫСѧʦ̽','http://www.teacher.com.cn/','967','6','0','0','0','0','0','1857','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36096','Ѻ-˾','http://learning.sohu.com/s2005/sifakaoshi.shtml','994','7','0','0','0','0','0','557','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33791','ר-Delphi','http://www.china-askpro.com/delphi.shtml','1158','9','0','0','0','0','0','270','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35490','NULL','http://law.jiuzhou001.com/¾޽','994','111','0','0','0','0','0','275','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33677','ݿ⿪-йit','http://www.chinaitpower.com/Dev/DataBase/','1166','3','0','0','0','0','0','588','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6279','й˾','http://www.sifa2000.com','994','1','0','0','0','0','0','2269','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33676','ݿ⿪-','http://dev.21tx.com/database/','1166','2','0','0','0','0','0','1023','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35520','й˶','http://www.iouter.com/','931','8','0','0','0','0','0','546','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33675','ݿ-','http://www.cndw.com/tech/data/','1166','1','0','0','0','0','0','1982','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6285','ƿ','http://www.ck100.com','995','2','0','0','0','0','0','899','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6286','йƻ','http://www.kj2000.com','995','1','0','0','0','0','0','3994','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6299','˹Ա','http://edu.sina.com.cn/focus/official.html','996','1','0','0','0','0','0','2797','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6302','ǿԱ','http://www.51test.net/indexmain.asp?classid=5&amp;Nclassid=44','996','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33591','ݱ','http://www.guangzhouhonda.com.cn/','1874','8','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33590','й','http://www.mercedes-benz.com.cn/','1874','1','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6314','ȫȼ','http://sk.neea.edu.cn/jsjdj/infor.jsp?infoid=39212&class_id=26_14_04','998','1','0','0','0','0','0','821','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6317','','http://www.eastedu.com.cn','998','2','0','0','0','0','0','2241','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40048','Ժ','http://sxfy.chinacourt.org/','914','28','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6321','˼УIT֤','http://www.staredu.net','998','5','0','0','0','0','0','277','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35126','-˿','http://edu.sina.com.cn/exam/pc/','998','3','0','0','0','0','0','562','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6335','йMBA','http://www.mba.org.cn','999','1','0','0','0','0','0','1012','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33660','йMBA','http://www.mbaedu.cn/','999','6','0','0','0','0','0','332','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36059','-ë','http://sports.sina.com.cn/others/badmin.shtml','934','1','0','0','0','0','0','2293','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36060','Ѻ-ë','http://sports.sohu.com/1/1102/47/subject204254723.shtml','934','2','0','0','0','0','0','1016','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36062','NULL','http://sports.tom.com/zhty/yumaoqiu/TOM-ë','934','4','0','0','0','0','0','708','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33636','йMBA','http://www.mbaschool.com.cn/','999','2','0','0','0','0','0','375','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32545','й֮','http://www.333cn.com/bbs/','1979','7','0','0','0','0','0','430','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32543','Ļҵ̳','http://bbs.chinazhuyi.com/','1979','5','0','0','0','0','0','238','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33687','ӢɿƼ','http://www.shell.com/','1640','8','0','0','0','0','0','233','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33720','','http://www.vw.com.cn/','1640','21','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33721','ймϻ','http://www.cdpf.org.cn/','970','2','0','0','0','0','0','0','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6407','йͼ','http://www.nlc.gov.cn','1004','18','0','0','0','0','0','970','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6409','йͳĻ','http://www.cntca.com/','1004','4','0','0','0','0','0','1161','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6410','йͳĻ','http://www.enweiculture.com','1004','5','0','0','0','0','0','2788','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6421','ҵĻ','http://www.7158.com.cn','1004','13','0','0','0','0','0','613','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6425','Ļ','http://www.ccdy.cn','1004','14','0','0','0','0','0','474','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6427','йĻҵ','http://www.cnci.gov.cn','1004','3','0','0','0','0','0','642','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6433','лĻϢ','http://www.ccnt.com.cn/','1004','2','0','0','0','0','0','604','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6451','жй','http://www.owecn.com/','1006','12','0','0','0','0','0','453','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6452','л','http://www.chinacharity.cn','1006','13','0','0','0','0','0','211','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38601','','http://www.qionghaifc.com','1782','3','0','0','0','0','0','430','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33874','չĸίԱ','http://www.sdpc.gov.cn/','2180','7','0','0','0','0','0','4248','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38571','Ƭ','http://www.ilzp.com','684','21','0','0','0','0','0','2756','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6498','Ͼɱʷʵ','http://neverforget.sina.com.cn','1009','12','0','0','0','0','0','2871','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6507','','http://www.ebud.cn','2163','3','0','0','0','0','0','2083','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6512','ز̳','http://www.bskk.com/','2163','14','0','0','0','0','0','357','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6513','','http://www.2muslim.com','2166','23','0','0','0','0','0','563','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6514','˹֮','http://www.norislam.com','2166','40','0','0','0','0','0','464','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6518','˹֮','http://www.yich.org','2166','24','0','0','0','0','0','485','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6520','','http://www.zangmi.com','2163','7','0','0','0','0','0','578','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6521','','http://www.dadunet.com/','2163','8','0','0','0','0','0','446','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6523','NULL','http://www.cnbuddhism.comл','2163','4','0','0','0','0','0','1756','0','','lsz','0','0','0','1237910400','','1');
INSERT INTO ylmf_site VALUES('6525','','http://www.islambook.net/','2166','30','0','0','0','0','0','137','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6526','йվ','http://www.ccctspm.org/','2165','1','0','0','0','0','0','1223','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6528','̵б','http://www.daoism.cn/up/data/','2164','3','0','0','0','0','0','84','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6529','й鿯','http://www.chinachristianbooks.org','2165','3','0','0','0','0','0','375','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6530','NULL','http://www.shaolin.org.cn/','2163','13','0','0','0','0','0','736','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6532','ѧо','http://www.wuys.com/','2163','5','0','0','0','0','0','856','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6539','','http://www.edzx.com/','2165','2','0','0','0','0','0','1096','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6557','','http://www.manyart.com','1012','15','0','0','0','0','2','7891','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6558','','http://www.cl2000.com','1012','1','0','0','0','0','1','22795','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39887','ͨ','http://www.fxbest.com/','1646','9','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34366','','http://www.itime.cn/Index.html','796','13','0','0','0','0','0','3097','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6612','й鷨','http://www.freehead.com','1015','1','0','0','0','0','0','18281','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6617','鷨ռ','http://www.9610.com','1015','6','0','0','0','0','0','6357','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6618','й鷨','http://www.shufa.com','1015','3','0','0','0','0','0','7737','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6621','л鷨','http://www.shxw.com/','1015','3','0','0','0','0','0','4431','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6624','й׭̳','http://www.zgzkw.com/bbs/','1015','11','0','0','0','0','0','3469','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34777','Ͱҹ','http://banjia.blogbus.com/','670','9','0','0','0','0','0','216','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6658','NULL','http://arts.tom.com/TOMͬ','1017','105','0','0','0','0','0','4849','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40035','Сѧ','http://www.zuowen.com/','886','8','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6663','й','http://www.diaosu.cn/','1015','8','0','0','0','0','0','3493','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6665','','http://arts.cnool.net','1017','7','0','0','0','0','1','25418','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6684','лϷ','http://www.dongdongqiang.com','1018','4','0','0','0','0','0','2756','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6685','ɽ','http://www.zbs.cn','1018','13','0','0','0','0','0','5661','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6687','Է̳','http://space.tv.cctv.com/podcast/quyuanzatan','1018','7','0','0','0','0','0','2003','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6699','йղ','http://www.lmstamp.com','1019','14','0','0','0','0','0','410','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6701','֮','http://www.stampol.com','1019','16','0','0','0','0','0','2243','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39905','ڵ˹[]','http://www.udinese.it/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39906','[]','http://www.atalanta.it/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6712','һ','http://www.1soccer.com','1021','11','0','0','0','0','1','10568','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6713','Ѷй','http://sports.qq.com/csocce/','1021','9','0','0','0','0','0','1037','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32394','лǧ','http://www.zh5000.com/','1012','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39900','[]','http://www.sslazio.it/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39901','ͼ˹[]','http://www.juventus.com/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39902','[]','http://www.acparma.it/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39903','[]','http://www.acfiorentina.it/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39904','³[]','http://www.perugiacalcio.it/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6728','2006籭','http://2006.sina.com.cn','1022','7','0','0','0','0','0','687','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6729','Ѻ2006¹籭','http://2006.sohu.com','1022','10','0','0','0','0','0','613','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6730','Ѷ2006籭','http://2006.qq.com','1022','13','0','0','0','0','0','238','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6731','2006籭','http://2006.163.com','1022','12','0','0','0','0','0','153','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6732','CCTV2006籭','http://www.cctv.com/worldcup','1022','11','0','0','0','0','0','812','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6733','籨2006籭','http://worldcup.zaobao.com','1022','20','0','0','0','0','0','83','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6734','ǿ2006籭','http://2006.sports.cn','1022','19','0','0','0','0','0','75','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6741','Ѹӯ2006籭','http://www.xunying.com/news/special/2006wcup','1022','17','0','0','0','0','0','104','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6744','TOM2006籭','http://sports.tom.com/worldcupdraw2006/index.html','1022','16','0','0','0','0','0','122','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6745','Ż2006籭','http://cn.sports.yahoo.com/foot/intl/cup_06/index.html','1022','14','0','0','0','0','0','163','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6746','»2006籭','http://www.xinhuanet.com/sports/gjzq.htm','1022','15','0','0','0','0','0','150','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33517','ֱ','http://www.zhibo8.com/','2272','14','0','0','0','0','0','6023','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6770','ɽ³̩ɽ','http://www.lnts.com.cn','1024','2','0','0','0','0','0','1443','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6771','Ϻ껨','http://www.shenhuafc.com.cn','1024','3','0','0','0','0','0','747','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6772','Ͻҵ','http://www.jianyefc.com','1024','4','0','0','0','0','0','945','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6773','̩','http://teda.enorth.com.cn','1024','5','0','0','0','0','0','2209','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36660','ݳְҵѧԺ','http://www.gcp.edu.cn/','1295','62','0','0','0','0','0','339','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36666','Ƽ','http://www.most.gov.cn/','2094','4','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36665','йѧԺ','http://www.cass.net.cn/','2094','3','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6777','«','http://www.lnfootball.com.cn','1024','6','0','0','0','0','0','613','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6778','','http://www.lifanfc.com','1024','16','0','0','0','0','0','636','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6779','ƽ','http://szsoccer.china.com','1024','7','0','0','0','0','0','621','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36858','NULL','http://www.shzf.com/Ϻⷿ','1886','32','0','0','0','0','0','2719','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36857','Ϻز','http://sh.soufun.com/','1886','51','0','0','0','0','1','2232','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36856','Ϻ¾','http://rsj.sh.gov.cn/','1886','30','0','0','0','0','0','1428','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36855','ϺְҵԺ','http://www.spta.gov.cn/','1886','29','0','0','0','0','0','986','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36854','Ϻ','http://www.efesco.com/','1886','28','0','0','0','0','0','1302','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36853','NULL','http://zhaopin.online.sh.cn/ϺƸ','1886','27','0','0','0','0','0','3110','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36852','Ϻ˲г','http://www.hr.net.cn/','1886','26','0','0','0','0','0','2596','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36851','ϺͶ','http://www.12333sh.gov.cn/index.shtml','1886','25','0','0','0','0','0','5408','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36850','NULL','http://www.1010job.com/1010job','1886','24','0','0','0','0','0','921','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36849','Ϻ˲','http://www.shanghairc.com/','1886','23','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36848','лӢϺվ','http://shanghai.chinahr.com/','1886','22','0','0','0','0','0','1129','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36847','ǰϺվ','http://www.51job.com/default-area.php?area=0200','1886','21','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36846','Ϻͨ','http://www.cttsh.com/','1886','20','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36844','Ϻ','http://sh.ct10000.com/','1886','18','0','0','0','0','0','2541','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33537','VeryCD','http://www.verycd.com/','1113','1','0','0','0','0','0','1','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36843','Ϻͨ','http://www.133sh.com/','1886','17','0','0','0','0','0','916','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36842','Ϻƶ','http://www.sh.chinamobile.com/','1886','16','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33534','Ӱ','http://www.gougou.com/','1113','2','0','0','0','0','0','1','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36841','չ˾','http://www.shanghaiairport.com/','1886','15','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36840','Ϻ','http://www.shmetro.com/','1886','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6814','ŷ','http://www.uefa.com','1026','2','0','0','0','0','0','1519','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6815','','http://www.fifa.com','1026','1','0','0','0','0','0','2572','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33356','Э','http://www.figc.it/','1026','13','0','0','0','0','0','0','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6817','ӢЭ','http://www.thefa.com','1026','11','0','0','0','0','0','1846','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6818','ձЭ','http://www.jfa.or.jp','1026','21','0','0','0','0','0','408','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6819','¹Э','http://www.dfb.de','1026','10','0','0','0','0','0','58','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6821','[]','http://www.mlsnet.com','1026','22','0','0','0','0','0','251','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6822','б','http://www.concacaf.com','1026','6','0','0','0','0','0','228','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33354','Э','http://www.fff.fr/','1026','9','0','0','0','0','0','0','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33359','Э','http://www.knvb.nl/','1026','17','0','0','0','0','0','0','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6827','͢Э','http://www.afa.org.ar','1026','18','0','0','0','0','0','611','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6828','','http://www.oceaniafootball.com','1026','7','0','0','0','0','0','140','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6829','Ů[]','http://www.wusa.com','1026','23','0','0','0','0','0','445','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6830','','http://www.cafonline.com','1026','4','0','0','0','0','0','105','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6832','AC[]','http://www.acmilan.com','1027','5','0','0','0','0','0','3189','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6833','[]','http://www.inter.it','1027','6','0','0','0','0','0','1793','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6834','ͼ˹[]','http://www.juventus.com','1027','4','0','0','0','0','0','698','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6835','[]','http://www.sslazio.it','1027','7','0','0','0','0','0','120','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6836','','http://www.lega-calcio.it','1027','3','0','0','0','0','0','437','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6837','','http://www.bolognafc.it','1027','29','0','0','0','0','0','50','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6838','[]','http://www.fcparma.com','1027','13','0','0','0','0','0','57','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6839','׼','http://www.regginacalcio.com','1027','21','0','0','0','0','0','23','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6840','ά','http://www.hellasverona.it','1027','30','0','0','0','0','0','19','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6841','ڵ˹[]','http://www.udinese.it','1027','9','0','0','0','0','0','42','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6842','[]','http://www.acfiorentina.net','1027','8','0','0','0','0','0','118','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6843','׹ٷվ','http://www.italian-soccer.com','1027','2','0','0','0','0','0','275','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6844','Ī','http://www.calciopalermo.it','1027','14','0','0','0','0','0','23','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6845','̩ά','http://www.fbctreviso.it','1027','22','0','0','0','0','0','15','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6848','÷˹','http://www.fcmessina.it','1027','17','0','0','0','0','0','23','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6849','³[]','http://www.perugiacalcio.it','1027','24','0','0','0','0','0','33','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6850','ŷվ','http://cn.uefa.com/','1028','1','0','0','0','0','0','2552','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6851','2008ŷޱר','http://euro2008.sina.com.cn/','1028','3','0','0','0','0','0','3883','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36006','ϣ²','http://www.timo-hildebrand.de/','1029','22','0','0','0','0','0','88','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36007','','http://www.thierry-henry.net/','1029','11','0','0','0','0','0','981','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33348','ɫ','http://xdowns.com/','1106','17','0','0','0','0','0','59138','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33347','йش-','http://download.zol.com.cn/','1106','15','0','0','0','0','0','32303','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35075','CCTV-Ƶ','http://sports.cctv.com/special/C16257/','1030','3','0','0','0','0','0','1968','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38759','','http://soft.gougou.com/','1106','6','0','0','0','0','0','115818','0','','lzb','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('6866','ɭ[Ӣ]','http://www.arsenal.com','1031','4','0','0','0','0','0','1386','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6867','[Ӣ]','http://www.liverpoolfc.tv','1031','5','0','0','0','0','0','879','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6869','ж','http://www.chelseafc.co.uk','1031','2','0','0','0','0','0','2193','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6870','Ŧ˹','http://www.nufc.co.uk','1031','8','0','0','0','0','0','169','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6871','׵¶˹','http://www.mfc.premiumtv.co.uk','1031','14','0','0','0','0','0','52','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6873','ķ','http://www.fulhamfc.com','1031','18','0','0','0','0','0','43','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6874','˹ά','http://www.itfc.premiumtv.co.uk','1031','27','0','0','0','0','0','19','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6875','Ĵ','http://www.ccfc.co.uk','1031','22','0','0','0','0','0','33','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6876','ɣ','http://www.safc.com','1031','21','0','0','0','0','0','45','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6877','','http://www.leedsunited.com','1031','26','0','0','0','0','0','65','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6878','ϰն','http://www.saintsfc.co.uk','1031','25','0','0','0','0','0','17','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6879','ά','http://www.wba.co.uk','1031','19','0','0','0','0','0','34','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33336','','http://www.manutd.com/','1031','3','0','0','0','0','0','2225','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6881','ά','http://www.sevillafc.es','1032','12','0','0','0','0','0','102','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6882','ʼ[]','http://www.realmadrid.com','1032','2','0','0','0','0','0','2618','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6883','ʼ[]','http://www.real-sociedad-sad.es','1032','8','0','0','0','0','0','46','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6884','[]','http://www.valenciacf.es','1032','5','0','0','0','0','0','98','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6885','','http://www.malagacf.com','1032','15','0','0','0','0','0','15','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6886','ʼ[]','http://www.realzaragoza.com','1032','11','0','0','0','0','0','42','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6887','','http://www.rcdespanyol.com','1032','17','0','0','0','0','0','59','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6888','϶Ͷ','http://www.athletic-club.net','1032','10','0','0','0','0','0','24','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6889','ʼ忨','http://www.rcdmallorca.es','1032','9','0','0','0','0','0','25','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6890','ʼұ˹','http://www.realbetisbalompie.es','1032','6','0','0','0','0','0','23','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6891','³','http://www.canaldeportivo.com','1032','4','0','0','0','0','0','32','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6893','','http://www.celtavigo.net','1032','20','0','0','0','0','0','15','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6895','Ľ','http://www.fcbayern.t-com.de','1033','3','0','0','0','0','0','1166','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6896','˹[]','http://www.fck.de','1033','11','0','0','0','0','0','40','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6897','ոɭ[]','http://www.bayer04.de','1033','12','0','0','0','0','0','54','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6898','Ľ1860[]','http://www.tsv1860.de','1033','19','0','0','0','0','0','60','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6899','','http://www.hsv.de','1033','5','0','0','0','0','0','57','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6900','¼׿¡','http://www.fc-koeln.de','1033','20','0','0','0','0','0','17','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6901','ɳ04[]','http://www.schalke04.de','1033','4','0','0','0','0','0','106','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6902','Ŧױ','http://www.fcn.de','1033','17','0','0','0','0','0','29','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6903','˸°ͺ','http://www.borussia.de','1033','10','0','0','0','0','0','30','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6904','շƶ','http://www.dsc-arminia-bielefeld.de','1033','15','0','0','0','0','0','19','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6905','˹ͼض','http://www.vfb-stuttgart.de','1033','13','0','0','0','0','0','69','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6906','ֺ[]','http://www.herthabsc.de','1033','8','0','0','0','0','0','36','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6908','05','http://www.mainz05.de','1033','18','0','0','0','0','0','14','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6909','÷ȶ','http://www.fcmetz.com','1034','15','0','0','0','0','0','72','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6910','ſ','http://www.ac-ajaccio.com','1034','10','0','0','0','0','0','26','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6911','Ф','http://www.fcsochaux.fr','1034','19','0','0','0','0','0','30','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6912','ŷ','http://www.aja.fr','1034','11','0','0','0','0','0','26','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6913','ɱ','http://www.nicollin.com','1034','8','0','0','0','0','0','6','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6914','ʥն[]','http://odds.netsh.com/teams/127/127.html','1034','6','0','0','0','0','0','58','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6915','Ħɸ','http://www.asm-fc.com','1034','2','0','0','0','0','0','57','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6916','˹','http://www.rclens.fr','1034','16','0','0','0','0','0','26','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6917','ʥٰ','http://www.asse.fr','1034','5','0','0','0','0','0','42','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6919','','http://www.willem-ii.nl','1035','12','0','0','0','0','0','64','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6920','','http://www.az-alkmaar.nl','1035','4','0','0','0','0','0','36','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6921','','http://www.fcgroningen.nl','1035','10','0','0','0','0','0','17','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6922','ڵ֧','http://www.fc-utrecht.nl','1035','14','0','0','0','0','0','13','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6923','Үŵ','http://www.feyenoord.nl','1035','5','0','0','0','0','0','27','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6924','RKC','http://www.rkcwaalwijk.nl','1035','6','0','0','0','0','0','16','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6930','йμվ','http://www.cnkjz.com/','1037','3','0','0','0','0','0','2880','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6936','123μվ','http://www.123xz.net/','1037','5','0','0','0','0','0','3341','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6941','NULL','http://www.flacai.com/flacaiԴ','1037','18','0','0','0','0','0','1572','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6944','','http://www.aoshu.cn','1038','1','0','0','0','0','0','3067','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6945','ѧԴ','http://www.1230.org','1038','2','0','0','0','0','0','5244','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6950','NULL','http://www.cnmaths.com','1038','9','0','0','0','0','0','1777','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39990','Ƽ','http://scitech.people.com.cn/','975','5','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39984','66','http://www.66wen.com/','1043','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6957','ѧվ','http://www.maths168.com/Index.html','1038','6','0','0','0','0','0','2189','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39989','360ٿ','http://baike.360.cn/','2160','3','0','0','0','0','0','4','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6964','Ӣ','http://www.wwenglish.com','1039','9','0','0','0','0','0','19734','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6965','Ӣ','http://www.putclub.com','1039','10','0','0','0','0','0','2202','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6966','Ӣܱ','http://www.ew.com.cn','1039','11','0','0','0','0','0','1440','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6967','Ӣ','http://www.hjenglish.com','1039','12','0','0','0','0','0','289','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6968','Ӣ','http://www.crazyenglish.org','1039','13','0','0','0','0','0','4696','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6969','Ӣд','http://www.4ewriting.com','1039','14','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6971','NULL','http://www.englishabc.comӢABC','1039','16','0','0','0','0','0','1942','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6972','Ӣѧϰ','http://www.ell.cn','1039','17','0','0','0','0','0','1633','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6974','Ӣ','http://www.englishcn.com/','1039','18','0','0','0','0','0','718','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6977','л-Դ','http://www.zhyww.cn/zyzx/Index.asp','1040','2','0','0','0','0','0','5083','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6978','ѧԴվ','http://www.ht88.com','1040','1','0','0','0','0','0','3934','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6979','NULL','http://www.cnyww.comй','1040','5','0','0','0','0','0','4879','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6982','ս̰Ľѧ','http://www.oldq.com.cn','1040','12','0','0','0','0','0','1610','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6983','߿','http://www.gkzwtw.com','1040','10','0','0','0','0','0','424','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6984','Դ','http://www.yw150.com/','1040','4','0','0','0','0','0','2745','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('6992','Ұ','http://www.52yuwen.com/Index.html','1040','3','0','0','0','0','0','1643','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19066','ѶԿվ','http://edu.qq.com/zikao.shtml','992','9','0','0','0','0','0','797','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19064','ԿƵ','http://edu.sina.com.cn/zikao/','992','2','0','0','0','0','0','1275','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19062','ѺԿվ','http://learning.sohu.com/zikaozhan.shtml','992','10','0','0','0','0','0','721','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19061','й-Կ','http://zikao.eol.cn/','992','8','0','0','0','0','0','3039','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19059','йԿ','http://www.chinazikao.com/','992','3','0','0','0','0','0','6083','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40001','·߿վ','http://www.yuloo.com/gk/','1001','11','0','0','0','0','0','281','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40002','-߿Ƶ','http://gaokao.zhongzhao.com/','1001','4','0','0','0','0','0','59','0','','lzb','0','0','1280678400','1280678400','','1');
INSERT INTO ylmf_site VALUES('34625','ǹ̳','http://bbs.arsenal.com.cn/index.php','2077','11','0','0','0','0','0','333','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33556','3G','http://3g.pp.cn/','1598','11','0','0','0','0','0','1307','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40003','й߿','http://www.114ms.com/Index.html','1001','13','0','0','0','0','0','53','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19042','Ѷ','http://edu.qq.com/y/','993','2','0','0','0','0','0','1187','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33571','߿Ϣƽ̨','http://gaokao.chsi.com.cn/','1001','5','0','0','0','0','0','14275','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32541','Ӿϵ','http://bbs.vicnc.com/','1979','3','0','0','0','0','0','1015','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36046','EXPN[Ӣ]','http://expn.go.com/','931','21','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32542','й','http://bbs.cool-de.com/','1979','4','0','0','0','0','0','436','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36045','ʵɽ˶[Ӣ]','http://www.uiaa.ch/','931','22','0','0','0','0','0','56','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41207','(KooMail)','http://www.xiazaiba.com/html/126.html','2290','3','0','0','0','0','0','0','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36123','ж̳','http://bbs.qieerxi.com/','1983','7','0','0','0','0','0','460','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36044','йЭ','http://www.b3.org.cn/','931','11','0','0','0','0','0','137','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38374','йʨ˶Э','http://dragonlion.sport.org.cn/','1677','7','0','0','0','0','0','99','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36042','йͧЭ','http://www.rowing.org.cn/','931','14','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36041','йЭ','http://sailboarding.sport.org.cn/','931','15','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18958','Ѷ','http://edu.qq.com/','991','1','0','0','0','0','0','332','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7067','','http://www.51papers.com','1043','9','0','0','0','0','0','10388','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38390','人','http://www.whw.cc','1902','46','0','0','0','0','0','7891','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7089','ҰӢ','http://www.52en.com','1045','6','0','0','0','0','0','18991','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35028','й˿','http://www.china-4.com/','1260','5','0','0','0','0','0','430','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7093','Ӣ','http://www.ebigear.com/','1045','23','0','0','0','0','0','18572','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7100','Ӣд','http://www.4ewriting.com','1045','11','0','0','0','0','0','12791','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7105','Ӣ','http://www.chinadaily.com.cn/language_tips/index.html','1045','13','0','0','0','0','0','7568','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7143','ʰ߷','http://www.iciba.net','1047','1','0','0','0','0','0','36582','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32477','ŷ','http://www.netat.net/','1047','12','0','0','0','0','0','6657','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33916','ʼǱȫ-PChome֮','http://product.pchome.net/pc_notebook/list__60.html','1099','3','0','0','0','0','0','1357','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41266','Ӣװ','http://a1230.oadz.com/link/C/1230/39/Dgnte3OB-UQSJyrDP6Ws9-3d8AE_/a/8/http://www.justonline.cn/?utm_source=114la&utm_content=mall','852','15','0','0','0','0','0','0','0','','liao','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33914','IT.com.cn ʼǱĿ','http://www.it.com.cn/notebook/','1099','10','0','0','0','0','0','250','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40104','Ժо','http://www.gov.cn/gjjg/2005-12/26/content_137261.htm','2183','5','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33912','йũҵϢ','http://www.agri.gov.cn/','903','10','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33911','ʼǱƵ','http://nb.pcpop.com/','1099','7','0','0','0','0','0','1061','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33909','NULL','http://nfgis.nsdi.gov.cn/һϢ','903','5','0','0','0','0','0','489','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19276','˼','http://www.51ielts.com/','1045','9','0','0','0','0','0','2978','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39991','ۺ߷빤','http://tool.114la.com/live/fanyi','1047','0','0','0','0','0','0','0','0','#000000','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33907','С̳','http://www.xiaochuncnjp.com/','1050','1','0','0','0','0','0','4296','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34756','л','http://www.chinaep.net/','1247','3','0','0','0','0','0','1093','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35982','Ӣ︨','http://www.ecp.com.cn/','1045','16','0','0','0','0','0','5480','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32475','','http://edu.sina.com.cn/en/','1045','3','0','0','0','0','0','30','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19260','йӢѧϰ','http://www.24en.com/','1045','2','0','0','0','0','0','23273','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19256','пƼѧ','http://www.hustonline.net/','1294','3','0','0','0','0','0','761','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19254','Ӣ','http://www.putclub.com/','1045','10','0','0','0','0','0','16331','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35210','·','http://www.baleno.com.hk/','1871','44','0','0','0','0','0','178','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33557','','http://a1.timewe.net/cdr?s=http%3A//wap.163.com/','1598','6','0','0','0','0','0','1037','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33558','è','http://wap.mop.com','1598','7','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36014','÷','http://www.messicn.com/','1029','5','0','0','0','0','0','1400','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31678','ԵԵ','http://www.yuanfr.com/','1050','9','0','0','0','0','0','1920','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31677','','http://www.aif.cn/','1050','12','0','0','0','0','0','2504','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31676','¹','http://www.dedecn.com/','1050','11','0','0','0','0','0','2098','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31675','','http://www.iniy.com/','1050','10','0','0','0','0','0','2256','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35103','-ݻƷ','http://eladies.sina.com.cn/lux/','2201','6','0','0','0','0','0','13225','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31671','к','http://www.chi2ko.com/index-chi.htm','1050','8','0','0','0','0','0','4656','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7220','ͨձ','http://www.kantsuu.com','1050','2','0','0','0','0','0','10900','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7225','','http://www.koreaxin.com/','1050','6','0','0','0','0','0','4552','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7227','Ѻ','http://goabroad.sohu.com','1052','2','0','0','0','0','1','2037','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36174','йϢ','http://www.chinaedu.edu.cn/','962','16','0','0','0','0','0','2832','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7229','δ','http://www.tigtag.com','1052','14','0','0','0','0','4','1675','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7230','','http://www.chuguo.cn','1052','10','0','0','0','0','2','4065','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7232','ѧ','http://www.csc.edu.cn','1052','8','0','0','0','0','0','2119','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7234','ľѧ','http://www.zmnedu.com/','1053','62','0','0','0','0','0','6447','0','','lzb','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('7236','ѧ','http://www.studyfr.net','1053','16','0','0','0','0','0','3431','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7241','ϰݻ()','http://www.dibai.com','1053','50','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7244','¼ѧ','http://www.eistudy.com/','1053','21','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7254','Ӣнѯ','http://www.anglo-chinese.com','1053','53','0','0','0','0','0','1264','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7265','˳','http://edu.sina.com.cn/studyabroad/index.html','1052','1','0','0','0','0','0','3798','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34758','й','http://www.cnemc.cn/','1247','9','0','0','0','0','0','525','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33964','[]','http://www.palazzochigi.it/','1833','30','0','0','0','0','0','26','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39632','С˵','http://kanke1.cn','1601','100','0','0','0','0','0','45','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33963','[]','http://www.overheid.nl/','1833','25','0','0','0','0','0','21','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34755','һܾ','http://www.zhb.gov.cn/','1247','1','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39594','˳','http://www.sf-express.com/','2138','4','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19200','ͨ','http://www.shinyway.com.cn/index.shtml','1052','15','0','0','0','0','0','328','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19195','ѧ','http://www.welltrend.com.cn/','1054','4','0','0','0','0','2','1186','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19178','йѧ˲Ϣ','http://www.chinatalents.gov.cn/','1052','12','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19172','ѧƵ','http://interedu.cyol.com/','1052','11','0','0','0','0','1','1220','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36171','-Ƶ','http://edu.sina.com.cn/','962','1','0','0','0','0','0','12268','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36172','Ѻ-Ƶ','http://learning.sohu.com/','962','2','0','0','0','0','0','5057','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36173','Ѷ-Ƶ','http://edu.qq.com/','962','3','0','0','0','0','0','8413','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('19164','йѧ','http://www.liuxue.net/','1052','6','0','0','0','0','0','7705','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33904','','http://coffeejp.com/','1050','5','0','0','0','0','0','3471','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7380','ѶQQ','http://www.xiazaiba.com/html/509.html','744','1','0','1','0','0','0','5558210','2','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7381','йŻ','http://cn.yahoo.com/?id=40020','832','6','0','1','0','0','0','3079086','1','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7424','120','http://www.7120.com/','864','6','0','1','0','0','19','128249','16','','ylmf','3','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11365','ӰBT','http://bt.ktxp.com/','1113','11','0','0','0','0','0','13938','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32912','ɳҵ','http://www.cscb.cn/cms/S101/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32963','','http://www.tccb.com.cn/','2047','4','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7510','̫ƽ','http://www.pconline.com.cn/','1122','13','0','1','0','0','0','154818','25','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7525','ZDNet','http://www.zdnet.com.cn/','1122','27','0','1','0','0','0','154619','43','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38618','Ů','http://www.yxlady.com/','664','11','0','0','0','0','25','456','0','','lzb','2','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7687','Yeah.net','http://www.yeah.net/','1068','3','1','0','0','0','0','55019','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7688','Ѻʼ','http://login.mail.sohu.com','1068','4','0','0','0','0','0','12006','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7689','21CN','http://mail.21cn.com/','1068','11','0','0','0','0','7','67541','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32382','ITѧϰ','http://www.itlearner.com/','1153','5','0','0','0','0','0','350','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40236','','http://www.gygov.gov.cn/gygov/1441151880758558720/','1861','2','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7749','Я','http://www.ctrip.com/smartlink/smartlink.asp?c=114la','892','1','0','1','0','0','0','186529','17','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18579','й','http://www.jicang.com/','1019','13','0','0','0','0','0','936','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('18574','ճ','http://www.cangcn.com/','1019','17','0','0','0','0','0','1622','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7786','Żȫ','http://www.yahoo.cn/','1077','5','0','0','0','0','0','9098','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7787','','http://www.soso.com','1077','7','0','0','0','0','0','13118','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32359','','http://www.pcpop.com/','1096','7','0','0','0','0','0','8','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32358','-Ӳ','http://tech.sina.com.cn/hardware/','1096','12','0','0','0','0','0','4618','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7811','115ۺ','http://116.com','1077','2','0','0','0','0','0','6388','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7813','Google','http://www.google.cn/webhp?prog=aff&client=pub-0194889602661524','1077','1','0','1','0','0','0','1621717','3','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11483','Discuz! Board PHP','http://www.discuz.net/','678','12','0','0','0','0','0','56','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7818','ѹ','http://www.sogou.com','1077','8','0','0','0','0','0','34064','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39992','-Ա','http://gwy.yuloo.com/','996','9','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39993','','http://www.21gwy.com','996','4','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7840','163','http://email.163.com/','1068','1','0','0','0','0','0','436900','0','red','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7841','','http://mail.sina.com.cn','1068','5','0','0','0','0','0','63109','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7842','126','http://www.126.com','1068','2','0','0','0','0','6','100083','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38355','»','http://www.dehua.net/','1898','40','0','0','0','0','0','772','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40061','WEB','http://www.cncms.com.cn/','1153','6','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7845','TOM','http://mail.tom.com','1068','7','0','0','0','0','1','25694','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7847','NULL','http://www.eyou.comʵ','1068','15','0','0','0','0','0','10373','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7850','NULL','http://mail.china.comл','1068','14','0','0','0','0','0','6669','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41238','','http://reg.xingkong.com/mytx/114/mytx12.php?source=27','2141','13','0','0','0','0','0','0','0','red','liao','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('41180','WinRARѹ','http://www.xiazaiba.com/html/65.html','2287','3','0','0','0','0','0','0','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7863','NULL','http://www.263.net/263','1068','13','0','0','0','0','0','14780','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7883','Gmail','http://mail.google.com/mail/?hl=en&tab=wm','1087','1','0','0','0','0','0','4490','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36070','пƴMBA','http://mba.ustc.edu.cn/','999','7','0','0','0','0','0','119','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7905','Microsoft','http://www.microsoft.com/zh/cn/default.aspx','1084','1','0','0','0','0','0','281','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7906','Yahoo!','http://www.yahoo.com','1084','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7907','MSN','http://www.msn.com','1084','3','0','0','0','0','0','2116','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7908','NAVER[]','http://www.naver.com','1084','4','0','0','0','0','0','762','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7909','eBay','http://www.ebay.com','1084','5','0','0','0','0','0','927','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7910','AOL','http://www.aol.com','1084','6','0','0','0','0','0','754','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20193','NULL','http://aolmail.aol.com/AOL Mail','1087','5','0','0','0','0','0','1888','0','','lzb','0','0','1281283200','1281283200','','1');
INSERT INTO ylmf_site VALUES('7912','TheStar[]','http://www.thestar.com.my','1084','7','0','0','1','1','3','2603','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7913','CNET','http://www.cnet.com','1084','8','0','0','0','0','0','324','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7914','Virglio[]','http://www.virgilio.it','1084','9','0','0','0','0','0','1281','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7915','About.com','http://www.about.com','1084','10','0','0','0','0','0','391','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7917','ZDNet','http://www.zdnet.com','1084','11','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7919','TimeWarner','http://www.timewarner.com','1084','12','0','0','0','0','0','388','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7920','Russia[]','http://www.russia.com','1084','13','0','0','0','0','0','2842','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7921','LaTribune[]','http://www.latribune.fr','1084','14','0','0','0','0','0','555','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7924','LeParisien[]','http://www.leparisien.fr','1084','16','0','0','0','0','0','1343','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7925','HispaVista[]','http://www.hispavista.com','1084','17','0','0','0','0','0','382','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35889','-','http://ent.163.com/tv/','752','5','0','0','0','0','0','4140','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7927','Download.com','http://www.download.com','1085','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7928','Apache','http://www.apache.org','1085','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7929','NULL','http://www.veritas.comVERITAS Software','1085','3','0','0','0','0','0','0','0','','lzb','0','0','1281283200','1281283200','','1');
INSERT INTO ylmf_site VALUES('7930','Tucows Downloads','http://www.tucows.com','1085','4','0','0','0','0','0','11','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7931','Valve Software','http://www.valvesoftware.com','1085','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7932','Shareware.com','http://www.shareware.com','1085','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7933','ZDNet','http://www.zdnet.com','1085','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7934','Free Software','http://www.fsf.org','1085','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7935','The Free Site','http://www.thefreesite.com','1085','9','0','0','0','0','0','37','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7936','5star Shareware[Ӣ]','http://www.5star-shareware.com','1085','10','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7937','Winsite[]','http://www.winsite.com','1085','11','0','0','0','0','0','342','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7939','BMC Software','http://www.bmc.com','1085','13','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7941','DaveCentral[]','http://www.davecentral.com','1085','15','0','0','0','0','0','38','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7944','Jumbo!','http://www.jumbo.com','1085','17','0','0','0','0','0','35','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7945','FileForum[]','http://www.fileforum.com','1085','18','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7946','NONAGS','http://www.nonags.com','1085','19','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7947','Freshmeat[]','http://www.freshmeat.net','1085','20','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7948','籨','http://www.zaobao.com','1086','11','0','0','0','0','0','730689','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7949','ŦԼʱ[]','http://www.nytimes.com','1086','12','0','0','0','0','0','4126','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7950','ձ[]','http://www.nikkei.co.jp','1086','13','0','0','0','0','0','1285','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7951','Ȼ[Ӣ]','http://www.nature.com','1086','1','0','0','0','0','0','286','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7952','[]','http://www.asahi.com','1086','14','0','0','0','0','0','1124','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7953','ѧ[]','http://www.sciencemag.org','1086','2','0','0','0','0','0','1784','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7954','Ϥ᳿[Ĵ]','http://www.smh.com.au','1086','15','0','0','0','0','0','330','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7955','ʱ[]','http://www.time.com','1086','3','0','0','0','0','0','1177','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7956','[]','http://www.usatoday.com','1086','16','0','0','0','0','0','349','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7957','ҵ־','http://www.nationalgeographic.com','1086','5','0','0','0','0','0','1362','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7958','[]','http://www.yomiuri.co.jp','1086','17','0','0','0','0','0','213','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7959','˹[]','http://www.forbes.com','1086','18','0','0','0','0','0','946','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7960','(Ӣ)','http://www.guardian.co.uk','1086','6','0','0','0','0','0','185','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7961','','http://www.nzherald.co.nz','1086','19','0','0','0','0','0','49','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7962','ÿյѶ[Ӣ]','http://www.telegraph.co.uk','1086','20','0','0','0','0','0','209','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7963','̳[]','http://www.iht.com','1086','21','0','0','0','0','0','315','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7964','Ͽʱ[¼]','http://straitstimes.asia1.com.sg','1086','22','0','0','0','0','0','1082','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7965','׶Ǳ[]','http://www.thestar.com','1086','23','0','0','0','0','0','253','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38338','58Ͼ','http://www.58nj.com','1895','56','0','0','0','0','0','2116','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31909','ĴѶ[]','http://www.interfax.ru/','2004','3','0','0','0','0','0','337','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7968','̿ѧԱ','http://www.csmonitor.com','1086','25','0','0','0','0','0','287','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31915','[]','http://www.ap.org/','2004','4','0','0','0','0','1','1993','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31908','ͨ-˹[]','http://www.itar-tass.com/','2004','5','0','0','0','0','0','432','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7972','[Ӣ]','http://www.independent.co.uk','1086','29','0','0','0','0','0','245','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7974','Utusanձ[]','http://www.utusan.com.my','1086','24','0','0','0','0','0','69','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7975','֥Ӹ̳[]','http://www.chicagotribune.com','1086','61','0','0','0','0','0','165','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7976','Ϣ[]','http://www.izvestia.ru','1086','91','0','0','0','0','0','297','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7979','Ѽޱ[]','http://www.lefigaro.fr','1086','30','0','0','0','0','0','92','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31911','ɯ[]','http://www.ansa.it/','2004','6','0','0','0','0','0','143','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7981','ELLEʱװ־[]','http://www.elle.fr','1086','31','0','0','0','0','0','845','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7983','[]','http://www.tagesspiegel.de','1086','32','0','0','0','0','0','369','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7984','ձ[]','http://www.wsj.com','1086','33','0','0','0','0','0','1222','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40273','Ȥ','http://www.51qi.org','2262','18','0','0','0','0','0','2','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7987','ͱ[]','http://www.repubblica.it','1086','34','0','0','0','0','0','108','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7989','̩ʿ[Ӣ]','http://www.thetimes.co.uk','1086','38','0','0','0','0','0','836','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7990','ű[]','http://www.liberation.fr/','1086','39','0','0','0','0','0','126','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7991','ڿͨѶ','http://www.unian.net','2004','7','0','0','0','0','0','199','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7992','NULL','http://www.in.gov.br  ͨѶ','2004','8','0','0','0','0','0','149','0','','lwh','0','0','1281283200','1281283200','','1');
INSERT INTO ylmf_site VALUES('7993','LusaͨѶ[]','http://www.lusa.pt','2004','9','0','0','0','0','0','44','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7994','[]','http://www.techreview.com','1086','40','0','0','0','0','0','191','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7995','ʱ[]','http://www.manilatimes.net','1086','41','0','0','0','0','0','100','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35938','ݲƷ̳','http://bbs.pcpop.com/','681','9','0','0','0','0','0','306','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7997','MediaFaxͨѶ[]','http://www.mediafax.ro','2004','11','0','0','0','0','0','34','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31916','ж[]','http://www.mena.org.eg/','2004','12','0','0','0','0','0','134','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('7999','ӢͨѶ[Ӣ]','http://www.pa.press.net','2004','13','0','0','0','0','0','383','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8001','Yahoo!Mail','http://mail.yahoo.com','1087','3','0','0','0','0','0','5387','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8002','Mail.Com','http://www.mail.com','1087','4','0','0','0','0','2','4759','0','','lzb','1','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8004','Royal mail','http://www.royalmail.com','1087','8','0','0','0','0','1','661','0','','','1','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8007','One Box','http://www.onebox.com','1087','11','0','0','0','0','0','1725','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8009','NULL','http://www.firstname.comFirstName.com','1087','13','0','0','0','0','0','1158','0','','lzb','0','0','1281283200','1281283200','','1');
INSERT INTO ylmf_site VALUES('8016','','http://www.chinese.net.nz','1088','16','0','0','0','0','0','4181','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8018','׶Ϣ','http://www.torontoservice.com','1088','17','0','0','0','0','0','3644','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8022','й','http://www.hsm.com.cn','1088','7','0','0','0','0','0','2019','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8023','ŷй','http://www.kina.cc','1088','5','0','0','0','0','0','4903','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8024','','http://www.hanguo.net.cn','1088','20','0','0','0','0','0','10644','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8025','','http://www.china-japan.com','1088','8','0','0','0','0','4','5332','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8026','йձ','http://www.chinadaily.com.cn/','1088','12','0','0','0','0','4','10020','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8027','׶໪Ѷ','http://www.torchinese.com','1088','21','0','0','0','0','0','3013','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8028','й','http://www.chinapress.com.my','1088','13','0','0','0','0','0','3067','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8030','ϰݻ()','http://www.dibai.com','1088','23','0','0','0','0','0','4021','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34936','ղƾ̳','http://www.caijing.name/','844','25','0','0','0','0','0','42739','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8034','Ī˹ƻ','http://www.renmin-hotel.com','1088','24','0','0','0','0','0','3314','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8035','ձ','http://www.worldnews.com.ph','1088','11','0','0','1','1','3','3646','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8036','ôѧ','http://www.chinaren.ca','1088','25','0','0','0','0','0','5383','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8037','绪','http://www.wuca.net','1088','1','0','0','0','0','1','10834','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8039','ѻ','http://cic.simplux.com','1088','27','0','0','0','0','0','2080','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8040','','http://www.dragonarea.com','1088','28','0','0','0','0','0','936','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8041','ϻ','http://www.lusochina.com','1088','29','0','0','0','0','1','1001','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8043','Ϸ','http://www.sa-cnet.com','1088','30','0','0','0','0','0','3205','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8044','й֮ý弯','http://www.chinastarmedia.com','1088','15','0','0','0','0','0','2666','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8045','ǻ','http://icity.cc','1088','31','0','0','0','0','0','2310','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8046','绪˽Э','http://www.world-chinese.org','1088','2','0','0','0','0','0','1905','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8047','','http://www.huayuqiao.org','1088','9','0','0','0','0','0','1413','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8049','Yahoo!','http://www.yahoo.com','1089','2','0','0','0','0','0','14431','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8050','Yandex[]','http://www.yandex.ru','1089','3','0','0','0','0','0','7941','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8051','Goo[]','http://www.goo.ne.jp','1089','4','0','0','0','0','0','3807','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8053','All the web','http://www.alltheweb.com','1089','6','0','0','0','0','0','5484','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8054','SearchEngine[Ӣ]','http://www.searchengine.com','1089','7','0','0','0','0','1','7640','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8055','CNetSearch[]','http://www.search.com','1089','8','0','0','1','1','1','16794','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8056','Netscape[]','http://search.netscape.com','1089','9','0','0','0','0','1','12647','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8058','Godado[]','http://www.godado.it','1089','11','0','0','0','0','1','2580','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39017','йش','http://www.newzgc.com/','1937','5','0','0','0','0','0','147','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39131','̳','http://bbs.ly.js.cn/','1946','2','0','0','0','0','0','207','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8063','seek[Austria]','http://www.austria-seek.at','1089','15','0','0','0','0','0','1049','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8065','ASK.COM','http://www.ask.com','1089','16','0','0','0','0','0','1352','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34079','Google','http://www.google.com/','1089','1','0','0','2','2','7','511049','0','','lwh','2','1','0','0','','0');
INSERT INTO ylmf_site VALUES('8067','Apali[]','http://www.apali.com','1089','17','0','0','0','0','1','1752','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8069','Apple[]','http://www.apple.com','1090','2','0','0','0','0','3','637','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8070','IBM[]','http://www.ibm.com','1090','3','0','0','0','0','0','151','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8071','HP[]','http://www.hp.com','1090','4','0','0','0','0','0','579','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8072','Dell[]','http://www.dell.com','1090','5','0','0','0','0','0','316','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8073','Fujitsu[]','http://www.fujitsu.com','1090','6','0','0','0','0','0','418','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8074','Motorola[]','http://www.motorola.com','1090','7','0','0','0','0','0','158','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8075','Sony[]','http://www.sony.com','1090','8','0','0','0','0','0','2474','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8076','Nvidia[]','http://www.nvidia.com','1090','9','0','0','0','0','0','125','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8077','Sun[]','http://www.sun.com','1090','10','0','0','0','0','0','34','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8078','Philips[]','http://www.philips.com','1090','11','0','0','0','0','0','151','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8079','Canon[]','http://www.canon.com','1090','12','0','0','0','0','0','318','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8080','Western Digital[]','http://www.wdc.com','1090','13','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8081','ViewSonic[]','http://www.viewsonic.com','1090','14','0','0','0','0','0','78','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8082','Sharp[]','http://www.sharp.co.jp','1090','15','0','0','0','0','0','209','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8083','AMD[]','http://www.amd.com/us-en/CountryLanguage/0,,3,00.html?AMDWorldflg=1','1090','16','0','0','0','0','0','305','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8084','3com[]','http://www.3com.com','1090','17','0','0','0','0','0','154','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8085','Seagate[]','http://www.seagate.com','1090','18','0','0','0','0','0','131','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8086','NEC[]','http://www.nec.com','1090','19','0','0','0','0','0','313','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8087','AT&T[]','http://www.att.com','1090','20','0','0','0','0','0','79','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39272','','http://www.di5j.cn/admin/cps/100746/lmkface.asp?mId=10074&linkId=608&c_id=&ct=20308627&linkType=2&rd=60&rtUrl=http%3A%2F%2Fwww.di5j.cn','852','23','0','0','0','0','0','8967','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8089','WinBook[]','http://www.winbook.com','1090','22','0','0','0','0','0','92','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8090','Quantum[]','http://www.quantum.com','1090','23','0','0','0','0','0','97','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8091','MAG[]','http://www.maginnovision.com','1090','24','0','0','0','0','0','103','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8092','NULL','http://www.unika.comUnika[]','1090','25','0','0','0','0','0','82','0','','lzb','0','0','1281283200','1281283200','','1');
INSERT INTO ylmf_site VALUES('8094','Yahoo!News[]','http://news.yahoo.com','1091','1','0','0','0','0','0','4262','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8095','FoxNews[]','http://www.foxnews.com','1091','3','0','0','0','0','0','2014','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8096','USNews[]','http://www.usnews.com','1091','4','0','0','0','0','0','623','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8097','FNN-News[]','http://www.fnn-news.com','1091','5','0','0','0','0','0','1893','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8098','AsiaOne[¼]','http://www.asia1.com.sg','1091','6','0','0','0','0','0','1532','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8100','Netscape News[]','http://dailynews.netscape.com','1091','8','0','0','0','0','0','498','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8101','IrishNews[]','http://www.irishnews.com','1091','9','0','0','0','0','0','1076','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8102','CBS News[]','http://cbsnews.cbs.com','1091','10','0','0','0','0','0','487','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8103','Sky News[Ӣ]','http://www.sky.com/news','1091','11','0','0','0','0','0','709','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8104','UA Today[ڿ]','http://www.uatoday.net','1091','12','0','0','0','0','0','566','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8105','Excite News[]','http://news.excite.com','1091','13','0','0','0','0','0','525','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8106','Yahoo!Sports[]','http://sports.yahoo.com','1092','1','0','0','0','0','0','875','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8107','SportsLine[]','http://www.sportsline.com','1092','2','0','0','0','0','0','510','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8108','ESPN[]','http://espn.go.com','1092','3','0','0','0','0','0','978','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8109','SIKIDS','http://www.sikids.com','1092','4','0','0','0','0','0','33','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8110','TSN[]','http://www.tsn.ca','1092','5','0','0','0','0','0','88','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8111','SportingLife[Ӣ]','http://www.sportinglife.com','1092','6','0','0','0','0','0','70','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8112','Sports','http://www.sports.com','1092','7','0','0','0','0','0','94','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8114','Sports Network[]','http://www.sportsnetwork.com','1092','9','0','0','0','0','0','110','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8115','Sportsec[]','http://www.sportec.com','1092','10','0','0','0','0','0','120','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8116','FansOnly[]','http://www.fansonly.com','1092','11','0','0','0','0','0','158','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8117','Fox Sports[]','http://www.foxsports.com','1092','12','0','0','0','0','0','116','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8118','SportingNews[]','http://www.sportingnews.com','1092','13','0','0','0','0','0','283','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38337','Ѷ','http://www.yescar.cn','1169','22','0','0','0','0','0','4195','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8121','FilmFestivals[]','http://www.filmfestivals.com','1093','37','0','0','0','0','0','2798','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8122','MovieFlix[]','http://www.movieflix.com','1093','36','0','0','0','0','0','5976','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8123','Movie-Page[Ų]','http://www.movie-page.com','1093','35','0','0','0','0','1','1508','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8124','MovieJuice[]','http://www.moviejuice.com','1093','34','0','0','0','0','0','2784','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8125','Moviefone[]','http://www.moviefone.com','1093','33','0','0','0','0','1','4204','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8126','Filmlinc[]','http://www.filmlinc.com','1093','32','0','0','0','0','0','4022','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8127','ELLE','http://www.elle.com','1094','1','0','0','0','0','0','4492','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8128','VOGUEʱ','http://www.vogue.com.cn/','1094','2','0','0','0','0','0','3913','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8129','Liz Claiborne','http://www.lizclaiborne.com','1094','3','0','0','0','0','0','876','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8130','˼','http://www.versace.com','1094','4','0','0','0','0','0','86','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8131','GLAMOUR','http://www.glamour.com','1094','5','0','0','0','0','0','503','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8132','Louvis','http://www.vuitton.com','1094','6','0','0','0','0','0','27','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8133','AVON','http://avon.avon.com','1094','7','0','0','0','0','0','835','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8134','Gucci','http://www2.gucci.com','1094','8','0','0','0','0','0','799','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8135','ŷ','http://www.lorealcosmetics.com','1094','9','0','0','0','0','0','2135','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8136','FairLady','http://www.fairlady.com/','1094','10','0','0','0','0','0','330','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8137','̫ƽ','http://www.pconline.com.cn','1096','1','0','0','0','0','0','3134','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8141','IT168','http://www.it168.com','1096','5','0','0','0','0','0','21','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8142','С','http://www.beareyes.com.cn','1096','6','0','0','0','0','0','7054','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8144','ý','http://www.thethirdmedia.com','1096','17','0','0','0','0','0','613','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39816','-Ӳ','http://labs.pcpop.com/','1101','4','0','0','0','0','0','58','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8152','','http://www.cbinews.com/','1096','9','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8153','52Ӳ','http://www.52hardware.com','1096','15','0','0','0','0','0','2587','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8154','֮-Ӳ','http://hardware.pchome.net','1096','13','0','0','0','0','0','11869','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39817','IT-Ӳ','http://it.com.cn/diy/review/','1101','8','0','0','0','0','0','20','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8159','켫','http://www.yesky.com/','1096','4','0','0','0','0','0','89','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38285','ڽ','http://www.jrj.com.cn/default.htm','843','12','0','0','0','0','10','25055','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8174','й','http://www.lenovo.com.cn/','1097','1','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8175','й','http://www.samsung.com.cn','1097','3','0','0','0','0','0','9301','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8176','й','http://www.epson.com.cn','1097','21','0','0','0','0','0','180','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8177','й','http://www.sony.com.cn','1097','20','0','0','0','0','0','3361','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8179','۵','http://www.hasee.com','1097','8','0','0','0','0','0','770','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8180','Intel(Ӣ)','http://www.intel.com','1097','36','0','0','0','0','0','138','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8181','TP-LINK','http://www.tp-link.com.cn','1097','34','0','0','0','0','0','277','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8182','IBM','http://www.ibm.com/cn','1097','4','0','0','0','0','0','19','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8183','ϲ','http://www.hedy.com.cn','1097','6','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8184','TCL','http://www.tclinfo.com','1097','7','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8185','߻','http://www.aigo.com/','1097','22','0','0','0','0','0','631','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8186','Logitech(޼)','http://www.logitech.com.cn/','1097','9','0','0','0','0','0','1845','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8187','NULL','http://www.3com.com.cn3COM','1097','25','0','0','0','0','0','33','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8188','廪ͬɷ޹˾','http://www.thtf.com.cn/','1097','24','0','0','0','0','0','330','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8189','','http://www.digitalchina.com','1097','28','0','0','0','0','0','320','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8190','֥˾','http://www.toshiba.com.cn','1097','29','0','0','0','0','0','498','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8191','NULL','http://www.unika.com.cnUNIKA˫','1097','37','0','0','0','0','0','229','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8192','Creative()','http://cn.creative.com','1097','38','0','0','0','0','0','48','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8193','Թ˾','http://www.abit.com.cn','1097','39','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8194','оƼ','http://www.microtek.com.cn','1097','40','0','0','0','0','0','81','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8195','Ǽ','http://www.greatwall.com.cn','1097','23','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8196','廪Ϲ','http://www.thunis.com','1097','27','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8197','ʿƿƼ','http://www.netac.com.cn','1097','41','0','0','0','0','0','111','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35582','NULL','http://www.changhongdigi.com/forechstudy/index.jspѻ','1686','10','0','0','0','0','0','331','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8199','Foxconn(ʿ)','http://www.foxconn.com.cn','1097','26','0','0','0','0','0','403','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8200','KingSton(ʿ)','http://www.kingston.com/china','1097','42','0','0','0','0','0','567','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8201','÷ݵԹ˾','http://www.soyo.com.cn','1097','43','0','0','0','0','0','395','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8203','ŵ޹˾','http://www.3nod.com.cn','1097','44','0','0','0','0','0','139','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8204','ʵҵ޹˾','http://www.goldenfield.com.cn','1097','12','0','0','0','0','0','152','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8205','ECS Wet site','http://www.ecs.com.cn','1097','45','0','0','0','0','0','215','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8206','','http://www.edifier.com/scn2005/','1097','31','0','0','0','0','0','416','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35581','ѧϵ','http://psy.ecnu.edu.cn/','986','20','0','0','0','0','0','725','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8208','DELUXʣ','http://www.deluxworld.com','1097','46','0','0','0','0','0','200','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8209','Asrock()','http://www.asrock.com','1097','47','0','0','0','0','0','243','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8210','leadtek(̨)','http://www.leadtek.com','1097','48','0','0','0','0','0','83','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8211','Western Digital[]','http://www.wdc.com','1097','49','0','0','0','0','0','140','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8212','㽡-','http://www.pcasl.com','1097','50','0','0','0','0','0','130','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33903','ʼǱ̳','http://benyouhui.it168.com/index.php','1099','15','0','0','0','0','0','1731','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8215','֮--','http://www.emater.com','1097','51','0','0','0','0','0','49','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8216','Ѷ','http://www.jetway.com.cn','1097','52','0','0','0','0','0','91','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8217','Microlab','http://www.microlab.com.cn','1097','53','0','0','0','0','0','117','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8218','Philips()','http://www.philips.monitors.com.cn','1097','32','0','0','0','0','0','221','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8219','ǲƷ','http://www.topstar1.com','1097','54','0','0','0','0','0','218','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8220','D-LinkѶ','http://www.dlink.com.cn/','1097','33','0','0','0','0','0','104','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8223','NULL','http://www.transcendchina.comTranscend()','1097','55','0','0','0','0','0','56','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8224','KingMax(ʤ)','http://www.kingmax.com.cn','1097','56','0','0','0','0','0','103','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8225','δ','http://www.belson.com.cn','1097','57','0','0','0','0','0','147','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8226','άƼɷ޹˾','http://www.longway.com','1097','58','0','0','0','0','0','83','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8227','Allied Telesyn','http://www.alliedtelesis.com.cn','1097','59','0','0','0','0','0','28','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8229','gigabyte()','http://cn.giga-byte.com','1097','14','0','0','0','0','0','767','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8230','(maxtor)','http://www.maxtor.com','1097','60','0','0','0','0','0','149','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8232','Supermicro(΢)','http://www.supermicro.com','1097','61','0','0','0','0','0','58','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8233','ݷ','http://www.aeolus.com.cn/','1097','62','0','0','0','0','0','90','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8234','hyundai(ִ)','http://www.hyundaicorp.com','1097','63','0','0','0','0','0','154','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8235','UNIKA˫Ƽ','http://www.unika.com.cn/','1097','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8236','AOpen','http://www.aopen.com.cn','1097','64','0','0','0','0','0','61','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8237','ǰ½Ƽ޹˾','http://www.accton.com.cn','1097','65','0','0','0','0','0','41','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8238','chaintech()','http://www.chaintech.com.tw','1097','66','0','0','0','0','0','31','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8239','¹Ƽ','http://www.newmen.com.cn','1097','67','0','0','0','0','0','50','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8240','Mustekѣ','http://www.mustek.com','1097','68','0','0','0','0','0','39','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8241','LEGIONE(־)','http://www.case-pro.com','1097','69','0','0','0','0','0','43','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8242','MAG()','http://www.magchina.com','1097','70','0','0','0','0','0','103','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8243','ӯ','http://www.eacan.com.cn','1097','71','0','0','0','0','0','61','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8244','Webeye(Ӣ-)','http://www.webeye.com.cn/index.htm','1097','72','0','0','0','0','0','220','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8245','֮','http://www.stst.com.cn/','1097','73','0','0','0','0','0','94','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8246','Diamond()','http://www.diamondmm.com','1097','74','0','0','0','0','0','51','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8248','Ƽ','http://www.geilcn.com/','1097','75','0','0','0','0','0','153','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8249','AOC(ڽ)','http://www.aocmonitor.com.cn/','1097','15','0','0','0','0','0','531','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8250','Xerox(ʿʩ)','http://www.xerox.com.cn/','1097','35','0','0','0','0','0','40','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8251','ComeOn()','http://www.sunchina.cc/index.htm','1097','76','0','0','0','0','0','28','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8252','DFI(ʯ)','http://www.dfi.com.tw/index_noflash.jsp','1097','77','0','0','0','0','0','124','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8253','Intel()','http://www.intel.com/cd/corporate/home/apac/zho/84253.htm','1097','5','0','0','0','0','0','649','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8254','Nvidia','http://www.nvidia.com/page/home','1097','11','0','0','0','0','0','298','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8255','Liteon(ⱦ)','http://www.liteon.com','1097','78','0','0','0','0','0','58','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8256','BIOSTAR(ӳ̩)','http://www.biostar.cn/','1097','79','0','0','0','0','0','212','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35986','','http://www.fltrp.com/','1045','24','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8258','Shuttle()','http://cn.shuttle.com','1097','80','0','0','0','0','0','44','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8260','megastar(ʳ)','http://www.megastar.com','1097','81','0','0','0','0','0','29','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8261','TRIPLEX()','http://www.triplex.com.tw/e_gb/index_gb.htm','1097','30','0','0','0','0','0','51','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33899','ӢѧϰƵ','http://www.unsv.com/','1045','12','0','0','0','0','0','25002','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8263','Dell','http://www1.ap.dell.com/content/default.aspx?c=cn&l=zh&s=gen','1097','16','0','0','0','0','0','380','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8264','HP()','http://welcome.hp.com/country/cn/zh/welcome.html','1097','2','0','0','0','0','0','1937','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8266','ȫѶƼ޹˾','http://www.syntax.com.cn/','1097','82','0','0','0','0','0','25','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8268','ѶԿ','http://www.speedway.com.cn','1097','83','0','0','0','0','0','305','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8269','EMC(Ψ)','http://www.emc.net.cn','1097','84','0','0','0','0','0','83','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8271','չ','http://www.jizhan.com.cn','1097','85','0','0','0','0','0','125','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8273','Seagate(ϣ)','http://www.seagate.com/www/zh-cn/','1097','17','0','0','0','0','0','320','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8274','Mitsubishi','http://www.mitsubishicorp.com/en/index.html','1097','86','0','0','0','0','0','87','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8275','QDI(Ƶ)','http://www.qdigrp.com/','1097','87','0','0','0','0','0','87','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8276','AMD','http://www.amd.com.cn/CHCN/index.asp.htm','1097','18','0','0','0','0','0','898','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40328','йͿϢ','http://www.tuliao.net.cn/','1637','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8279','M-ONE()','http://www.mone.com.cn','1097','10','0','0','0','0','0','76','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8282','йش','http://product.zol.com.cn','1096','2','0','0','0','0','0','53706','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33300','԰','http://www.cfan.com.cn/','1122','26','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8289','߽йش','http://www.intozgc.com','1096','8','0','0','0','0','0','6982','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33889','ҵ','http://www.saac.gov.cn/','2185','61','0','0','0','0','0','859','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8300','̫ƽʼǱ','http://www.pconline.com.cn/notebook','1099','1','0','0','0','0','0','4021','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8301','ʼǱ-йش','http://nb.zol.com.cn','1099','2','0','0','0','0','0','3737','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8302','ʼǱר-','http://tech.sina.com.cn/notebook','1099','9','0','0','0','0','0','798','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8304','ʼǱ-켫','http://notebook.yesky.com','1099','6','0','0','0','0','0','913','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8305','IT168-ʼǱר','http://notebook.it168.com','1099','4','0','0','0','0','0','1399','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8306','ʼǱ-eNetȶ','http://www.enet.com.cn/notebook','1099','5','0','0','0','0','0','639','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8308','ʼǱ-','http://www.ccw.com.cn/notebook','1099','11','0','0','0','0','0','331','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8310','ʼǱ-Ѻ','http://digi.it.sohu.com/notebook.shtml','1099','8','0','0','0','0','0','474','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8311','С-ʼǱƵ','http://nb.beareyes.com.cn','1099','12','0','0','0','0','0','667','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8313','ʼǱ-׵IT','http://soit.com.cn/notes.php?from=sina','1099','14','0','0','0','0','0','222','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36126','жԻ','http://chelsea.miqiu.com/','1983','8','0','0','0','0','0','248','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36129','й','http://www.milanchina.com/','1983','9','0','0','0','0','0','760','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36133','AC̳','http://acmilan.espnstar.com.cn/','1983','10','0','0','0','0','0','1214','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8326','֮-','http://product.pchome.net/','1101','7','0','0','0','0','0','553','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8329','ZDNet-Ʒ','http://www.zdnet.com.cn/products','1101','9','0','0','0','0','0','320','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8330','̫ƽ','http://www.pconline.com.cn/tpylab/','1101','2','0','0','0','0','0','1830','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8337','eNet-Ƶ','http://www.enet.com.cn/lab/','1101','5','0','0','0','0','0','1333','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39821','-Ӳ̳','http://bbs.tech.sina.com.cn/tableforum/App/index.php?tree=0&bbsid=58&subid=3','1103','9','0','0','0','0','0','14','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8340','֮','http://www.mydrivers.com','1102','1','0','0','0','0','0','5724','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8341','й','http://www.qudong.com/','1102','6','0','0','0','0','0','389','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34050','»黭Ƶ','http://www.xinhuanet.com/shuhua/','1017','4','0','0','0','0','0','4054','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8343','켫-','http://drivers.yesky.com','1102','3','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34048','йȫ','http://www.fuancn.cn/','1104','15','0','0','0','0','0','76','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35878','NULL','http://www.face7.com/face7','736','15','0','0','0','0','0','12869','0','','ylmf','0','0','1281369600','1281369600','','1');
INSERT INTO ylmf_site VALUES('8351','С̳','http://bbs.beareyes.com.cn/','1103','4','0','0','0','0','0','1786','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8353','52Ӳ̳','http://bbs.52hardware.com/','1103','2','0','0','0','0','0','3990','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33875','ѧ','http://www.most.gov.cn/','2180','9','0','0','0','0','0','2115','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8364','ͬ-Ӳ̳','http://www.xici.net/b2630/photo.asp','1103','10','0','0','0','0','0','467','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34047','','http://biz.chinabyte.com/cbfwq/','1104','5','0','0','0','0','0','44','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8366','Ʒ','http://www.scsi.cn','1104','10','0','0','0','0','0','71','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8367','۷','http://www.chinaserver.cn','1104','9','0','0','0','0','0','60','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8368','̫ƽ-','http://www.pconline.com.cn/server','1104','1','0','0','0','0','0','420','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8369','IT168-','http://server.it168.com','1104','2','0','0','0','0','0','154','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8370','IBM','http://www-900.ibm.com/cn/servers/eserver/index.shtml','1104','6','0','0','0','0','0','209','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8371','HP','http://welcome.hp.com/country/cn/chi/prodserv/servers.html','1104','7','0','0','0','0','0','146','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8373','԰','http://www.onlinedown.net','1106','2','0','0','0','0','3','241724','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('8374','վ','http://www.skycn.com','1106','1','0','0','0','0','6','287846','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('8377','Ѷ','http://download.digi.tech.qq.com/index.shtml','1106','4','0','0','0','0','0','26285','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11395','ĴϢ','http://www.scrs.gov.cn/','1520','1','0','0','0','0','0','324','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8379','','http://tech.sina.com.cn/down','1106','14','0','0','0','0','0','56300','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35158','','http://www.meishichina.com/Topic/CaiPu/ChuanCai/','2080','3','0','0','0','0','0','9994','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11345','NULL','http://it.crfly.com/IT԰','1107','10','0','0','0','0','0','36','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11344','ľ','http://bbs.mumayi.net/','1107','5','0','0','0','0','0','7196','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33527','̰½','http://www.greedland.net/','1113','3','0','0','0','0','0','17352','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8407','й-','http://drivers.qudong.com/','1118','7','0','0','0','0','0','9681','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8412','ɫվ','http://www.onegreen.net/index.html','1106','19','0','0','0','0','0','47020','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8417','ľ̳','http://bbs.ylmf.net/','1107','3','0','0','0','0','0','1061','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36653','NULL','http://www.gindeclub.com/cn/ɳ','1024','8','0','0','0','0','0','307','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36654','','http://chanba.huash.com/','1024','9','0','0','0','0','0','2235','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8421','Զ̳','http://bbs.pcbeta.com/','1107','6','0','0','0','0','0','5279','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33361','Tucows Network','http://www.tucows.com/','1117','4','0','0','0','0','0','42','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38555','֯ݹϵͳ','http://www.dedecms.com/','2113','4','0','0','0','0','0','500','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39218','֮','http://www.homefont.cn/','1110','4','0','0','0','0','0','4753','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36165','һ','http://www.tianya.cn/Publicforum/ArticlesList/0/fans.shtml','1983','14','0','0','0','0','0','272','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8448','Ӱ','http://bbs.yingkong.net/','1113','6','0','0','0','0','0','28953','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8451','ө','http://www.xyhc.com/','1113','16','0','0','0','0','0','4069','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41202','С˵Ķ','http://www.xiazaiba.com/html/1173.html','2288','3','0','0','0','0','0','0','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38891','¿P2PӦʵ','http://www.pconline.com.cn/pcedu/soft/wl/ftp/0509/705679.html','1284','5','0','0','0','0','0','5425','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8467','eMule¿','http://www.xiazaiba.com/html/100.html','1114','7','0','0','0','0','0','28029','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36650','','http://www.gaf.citic.com/','1024','10','0','0','0','0','0','99','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8470','Ѹ(Thunder)','http://www.xiazaiba.com/html/253.html','1114','1','0','0','0','0','0','21372','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11393','лӢĴվ','http://chinahrafaad.allyes.com/main/adfclick?db=chinahrafaad&bid=42532,21440,140&cid=17237,92,1&sid=43018&show=ignore&url=http://chengdu.chinahr.com/','1520','3','0','0','0','0','0','1042','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11391','˲','http://www.100job.cn/','1523','10','0','0','0','0','0','756','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11389','Ϫ˲Ƹ','http://www.yxzp.net/','1523','9','0','0','0','0','0','694','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11388','ҵ˲г','http://www.360ynjob.com/','1523','6','0','0','0','0','0','952','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11387','ϢƸ','http://work.yninfo.com/','1523','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11386','Ƹ','http://job.km169.net/','1523','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11385','˲Ϣ','http://www.ynrs.gov.cn/','1523','1','0','0','0','0','0','106','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11384','Ƹ','http://www.jobyn.com/','1523','4','0','0','0','0','0','670','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11383','˲','http://www.xnrc.com/','1537','12','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11382','˲','http://www.sxrcw.net/','1537','2','0','0','0','0','0','870','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11381','NULL','http://www.sxrs.gov.cn/˲Ϣ','1537','1','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11379','Ȫ˲','http://www.jqrc.net/','1524','11','0','0','0','0','0','119','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11378','NULL','http://www.lanzhoujob.com/˲','1524','9','0','0','0','0','0','135','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11377','±Ϣ','http://www.rst.gansu.gov.cn/','1524','4','0','0','0','0','0','26','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11376','˲','http://www.xbrc.gov.cn/','1524','14','0','0','0','0','0','110','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11375','NULL','http://xizang.chinarck.com/˲ſ','1533','1','0','0','0','0','0','219','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11372','½˲','http://www.xjrcw.com/','1522','3','0','0','0','0','0','8','0','','luojie','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33541','лϢ','http://www.tjtei.cn/','1641','48','0','0','0','0','0','143','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39515','NULL','http://share.dmhy.org/԰Դ','1113','17','0','0','0','0','0','4854','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11359','NULL','http://bt.icefish.org/BTվ','1113','5','0','0','0','0','0','6050','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11352','̫ƽBTר','http://www.pconline.com.cn/pcedu/redian/person/200207-wcx/20040310_bt/index.html','1284','3','0','0','0','0','0','2141','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11346','԰̳','http://bbs.cfan.com.cn/','1107','4','0','0','0','0','0','9695','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8530','Download.com','http://www.download.com','1117','1','0','0','0','0','0','5777','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8531','Apache','http://www.apache.org','1117','5','0','0','0','0','0','483','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8532','NULL','http://www.veritas.comVERITAS Software','1117','6','0','0','0','0','0','427','0','','lzb','0','0','1281283200','1281283200','','1');
INSERT INTO ylmf_site VALUES('36663','йѧԺ','http://www.cas.cn/','2094','1','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8534','Valve Software','http://www.valvesoftware.com','1117','7','0','0','0','0','0','408','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8535','Shareware.com','http://www.shareware.com','1117','2','0','0','0','0','0','122','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8536','ZDNet','http://www.zdnet.com','1117','8','0','0','0','0','1','631','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8537','Free Software','http://www.fsf.org','1117','9','0','0','0','0','0','172','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8538','5star Shareware[Ӣ]','http://www.5star-shareware.com','1117','10','0','0','0','0','0','581','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8539','Galt Download[]','http://www.galttech.com','1117','11','0','0','0','0','0','1245','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36664','йԺ','http://www.cae.cn/','2094','2','0','0','0','0','0','530','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8541','id software','http://www.idsoftware.com','1117','12','0','0','0','0','0','60','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8542','BMC Software','http://www.bmc.com','1117','13','0','0','0','0','0','229','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8544','Top Downloads','http://www.topdownloads.com','1117','15','0','0','0','0','0','125','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8546','Best Download[]','http://www.bestdownload.com','1117','16','0','0','0','0','0','378','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8547','FileForum[]','http://www.fileforum.com','1117','17','0','0','0','0','0','1553','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8548','NONAGS','http://www.nonags.com','1117','18','0','0','0','0','0','59','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8549','Freshmeat[]','http://www.freshmeat.net','1117','14','0','0','0','0','0','893','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8551','֮-','http://drivers.mydrivers.com/','1118','1','0','0','0','0','0','36812','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8555','IT-','http://www.itxiazai.com/--clist-142.html','1118','9','0','0','0','0','0','5074','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8556','̫ƽ-','http://dl.pconline.com.cn/sort/2.html','1118','4','0','0','0','0','0','13823','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39832','ذ-','http://www.xiazaiba.com/downlist/11.html','1118','8','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39830','켫-','http://drivers.yesky.com/','1118','3','0','0','0','0','0','121','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39831','IT168-','http://driver.it168.com/','1118','5','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23298','Ȼͤ԰','http://www.trtpark.com/index.htm','1797','100','0','0','0','0','0','772','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8647','뼯','http://www.lenovo.com.cn/','1123','1','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8652','й','http://www.hp.com.cn','1123','6','0','0','0','0','0','1244','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8654','й(Dell China)','http://www.dell.com.cn','1123','2','0','0','0','0','0','1216','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8659','廪ͬ','http://www.thtf.com.cn/','1123','14','0','0','0','0','0','1635','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8660','Թ˾','http://www.abit.com.cn','1123','17','0','0','0','0','1','817','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8661','Ǽ','http://www.greatwall.com.cn','1123','12','0','0','0','0','0','319','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8662','廪Ϲ','http://www.thunis.com','1123','11','0','0','0','0','0','426','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8673','UNIKA˫Ƽ','http://www.unika.com.cn/','1123','18','0','0','0','0','0','751','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8674','ʤ˾','http://www.huasun.com.cn/','1123','19','0','0','0','0','0','521','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8675','SUNй˾','http://www.sun.com.cn','1123','20','0','0','0','0','0','718','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33328','ֶ˹','http://www.vfl-wolfsburg.de/','1033','6','0','0','0','0','0','38','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8678','','http://www.foundertech.com/','1123','10','0','0','0','0','0','371','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33329','˹','http://www.msv-duisburg.de/','1033','16','0','0','0','0','0','10','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39814','֮-ϵ','http://pda.pchome.net/','2146','4','0','0','0','0','0','25','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8685','ѧ԰','http://tech.sina.com.cn/introduction','1124','4','0','0','0','0','0','5124','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8693','ѧԺ','http://tech.163.com/school.html','1124','3','0','0','0','0','0','8348','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8711','ܿ','http://www.ciweekly.com','1126','8','0','0','0','0','0','794','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8713','΢','http://www.pcworld.com.cn','1126','14','0','0','0','0','0','1480','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38367','йû','http://media.ccidnet.com/col/2629/2629.html','1126','18','0','0','0','0','0','809','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8715','','http://www.ceocio.com.cn','1126','5','0','0','0','0','0','1599','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8716','йԽ','http://www.cce.com.cn','1126','4','0','0','0','0','0','3492','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39933','[]','http://www.valenciacf.es/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39934','ʼ[]','http://www.real-sociedad-sad.es/','2154','100','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39935','ʼ[]','http://www.realzaragoza.com/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40633','г̳','http://bbs.kye.cn/','2265','100','0','0','0','0','0','8','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11433','»Ƶ','http://www.news.cn/video/index.htm','1285','10','0','0','0','0','0','100447','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11418','','http://www.qidian.com/','645','1','0','0','0','0','11','380705','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11445','һƵ','http://www.v1.cn/','1285','13','0','0','0','0','0','227301','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36835','ϺԤ','http://www.smb.gov.cn/','1886','11','0','0','0','0','1','7844','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11430','ѵӰ','http://www.ku6.com/?dh=114la','1285','12','0','0','0','0','0','109741','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11429','6','http://www.ku6.com/?ss','1285','1','0','0','0','0','0','684909','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35397','NULL','http://sx.jobdj.com/˲Ƹ','1537','9','0','0','0','0','0','948','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35384','лӢ','http://searchjob.chinahr.com/SearchResult.aspx?occParentIDList=255&indIDList=255&myLocIDList=17000&prj=bdkeyword&jtr=40041453&jtrr=','1551','4','0','0','0','0','0','172','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11425','˲','http://sina.allyes.com/main/adfclick?db=sina&bid=140652,177461,182427&cid=0,0,0&sid=169935&advid=3406&camid=23941&show=ignore&url=http://v.sina.com.cn/','1285','6','0','0','0','0','0','321540','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11423','䷿','http://www.6.cn/?114','1285','4','0','0','0','0','6','760825','29','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11422','','http://www.tudou.com/','1285','3','0','0','0','0','33','1383137','0','','','3','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11420','йشֻ','http://mobile.zol.com.cn/','766','3','0','0','0','0','0','35403','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36034','ĥ','http://www.doyouhike.net/','931','7','0','0','0','0','0','60','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35991','˺ķվ','http://www.davidbeckham.cn/','1029','2','0','0','0','0','0','3662','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11438','Ѹ׿','http://www.xunlei.com/','1285','17','0','0','0','0','70','156306','0','','lzb','2','5','0','0','','0');
INSERT INTO ylmf_site VALUES('11419','ǿͼ','http://mmscode3.3bu.com/mmscode/fullscreen/09271704435101519376.htm?id=09271704435101519376&serviceId=100001&webownerId=11854','769','1','0','0','0','0','0','12011','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11435','','http://www.letv.com/','1285','15','0','0','0','0','0','110294','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32154','','http://www.aiting.com/','716','3','0','0','0','0','17','263363','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20543','QQ','http://www.qqfzl.com','2044','5','0','0','0','0','0','15738','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38365','ά','http://www.dnwx.com','1124','9','0','0','0','0','0','13153','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38366','й','http://media.ccidnet.com/col/2611/2611.html','1126','17','0','0','0','0','0','1547','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20585','eNetѧԺ','http://www.enet.com.cn/eschool/','1124','6','0','0','0','0','0','5712','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20582','лӲѧ','http://tech.china.com/zh_cn/netschool/','1124','7','0','0','0','0','0','3237','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20581','й̳','http://www.jcwcn.com/Index.html','1124','5','0','0','0','0','0','4936','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36763','ҩƷѯ','http://www.beijing.gov.cn/ggfw/jm/yljk/default.htm','1885','39','0','0','0','0','0','1448','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8859','ҳʦ','http://www.68design.net','1132','15','0','0','0','0','0','2453','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8861','ҳѧ','http://www.webjx.com','1132','4','0','0','0','0','0','3781','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8862','ģ','http://www.mbsky.com','2107','14','0','0','0','0','0','2498','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8867','̬վָ','http://www.knowsky.com','1132','14','0','0','0','0','0','3368','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8868','йվ','http://www.cnzz.com','1709','2','0','0','0','0','0','344','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8874','켫ҳհ','http://homepage.yesky.com','1132','2','0','0','0','0','0','974','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8875','й','http://www.52design.com','2106','7','0','0','0','0','0','28462','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35484','Դƿ','http://www.examda.com/Accountant/','995','5','0','0','0','0','0','737','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35483','˲ƿ','http://www.qnr.cn/caihui/','995','6','0','0','0','0','0','592','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8890','й','http://www.net.cn','1133','2','0','0','0','0','0','26900','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8894','й','http://www.bizcn.com','1133','7','0','0','0','0','0','1472','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8896','35','http://www.35.com','1133','5','0','0','0','0','0','784','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38499','IT-','http://www.it.com.cn/server/','1104','11','0','0','0','0','0','69','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11601','У','http://www.myler.cn/xiaoyuan_gaoxiao/950.htm#У','950','1','0','0','0','0','0','5','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11602','У','http://www.myler.cn/xiaoyuan_gaoxiao/950.htm#1290','950','5','0','0','0','0','0','2440','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8952','ڿͷ','http://www.hacker.com.cn','1139','11','0','0','0','0','0','8445','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35453','NULL','http://www.959nx.cn/index.aspԴЭ','1536','6','0','0','0','0','0','50','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8956','ڿX','http://www.hackerxfiles.net','1139','12','0','0','0','0','0','6371','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35082','йó','http://www.qp168.net/','1171','22','0','0','0','0','0','2437','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8963','ȫй','http://www.anqn.com','1139','8','0','0','0','0','0','4734','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35452','','http://www.nxrl.com/','1536','5','0','0','0','0','0','87','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35081','й佻','http://www.86qp.net/','1171','21','0','0','0','0','0','2106','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8967','ɫڿ','http://www.7747.net/','1139','13','0','0','0','0','0','6391','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8968','Ӧ','http://www.cert.org.cn','1139','10','0','0','0','0','0','1572','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35080','NULL','http://www.zgqp.com.cn/','1171','20','0','0','0','0','0','1396','0','','lsz','0','0','1281283200','1281283200','','1');
INSERT INTO ylmf_site VALUES('8976','ڿͻ','http://Www.HackBase.Com','1139','2','0','0','0','0','0','2445','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35468','NULL','http://www.wjob.cn/˲','1538','15','0','0','0','0','0','696','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35447','ຣǰ̴','http://qh.jobdj.com/','1521','10','0','0','0','0','0','118','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35445','ຣ˲','http://www.qhrcrx.cn/','1521','10','0','0','0','0','0','155','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8990','IP138ѯ','http://www.ip138.com','1359','2','0','0','0','0','3','3600','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8991','ȫ123','http://www.123cha.com','1359','3','0','0','0','0','0','4902','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8994','ַѯ','http://www.u9cn.com/ip','1359','4','0','0','0','0','0','8886','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8995','񷴲','http://forum.jiangmin.com','1142','5','0','0','0','0','0','3060','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('8997','̳','http://bbs.kafan.cn/','1142','7','0','0','0','0','0','4337','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9000','̳','http://bbs.366tian.net/','1142','4','0','0','0','0','0','1016','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20158','˽[]','http://www.chinesedaily.com/','1088','10','0','0','0','0','0','2762','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('20154','»','http://www.chinadian.ca/','1088','3','0','0','0','0','0','3011','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36456','','http://www.changdu.gov.cn/','1863','3','0','0','0','0','0','98','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('37302','QQ','http://music.qq.com/','716','7','0','0','0','0','0','91539','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('26684','Ķ','http://www.xdyqw.com/','645','29','0','0','0','0','0','312145','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9059','½̳','http://club.xilu.com/reg_board_1.php','1151','5','0','0','0','0','0','1837','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9060','̰','http://www.programfan.com','1153','2','0','0','0','0','0','9084','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9062','CSDN ','http://www.csdn.net','1153','1','0','0','0','0','0','1148','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9063','й','http://www.bc-cn.net/','1153','3','0','0','0','0','0','1310','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9066','Ѷ-Ա','http://developer.weaseek.com/','1153','10','0','0','0','0','0','2486','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9067','Ӧ','http://tech.ddvip.com/','1153','7','0','0','0','0','0','904','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9071','51ctoƵ','http://developer.51cto.com/','1153','12','0','0','0','0','0','3762','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33755','ϣΤ','http://www.berkshirehathaway.com/','1640','38','0','0','0','0','0','99','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9095','ASP','http://dev.21tx.com/web/asp/','1155','6','0','0','0','0','0','293','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9096','ASP','http://www.asp300.com','1155','9','0','0','0','0','0','352','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9099','LeadBBSASP','http://www.leadbbs.com','1155','15','0','0','0','0','0','114','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9102','ITASPȫϵн̳','http://www.it.com.cn/f/edu/0511/9/196397.htm','1155','5','0','0','0','0','0','814','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9103','켫ASPƵ̳','http://homepage.yesky.com/asp/','1155','11','0','0','0','0','0','465','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9104','ASP','http://www.aspjs.cn','1155','12','0','0','0','0','0','833','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33753','ָ','http://www.carrefour.com/','1640','37','0','0','0','0','0','646','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9106','-ASP','http://www0.ccidnet.com/tech/asp.html','1155','3','0','0','0','0','0','239','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9107','C#վ-ASP','http://www.chinacs.net/index.asp?classid=2','1155','13','0','0','0','0','0','537','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9108','NULL','http://news.dvbbs.net/infoList/Catalog_6_1.htmlȷ-asp','1155','4','0','0','0','0','0','395','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9110','̬վ-ASP','http://www.knowsky.com/asp.asp','1155','14','0','0','0','0','0','1111','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33773','','http://www.credit-suisse.com/','1640','52','0','0','0','0','0','92','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9114','java','http://www.cn-java.com','1156','9','0','0','0','0','0','1278','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9116','Java','http://www.javajia.com','1156','7','0','0','0','0','0','919','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9117','Java World','http://www.javaworld.com','1156','13','0','0','0','0','0','416','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9118','JavaԴĿ','http://www.java.net','1156','14','0','0','0','0','0','733','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9119','Java̳','http://www.chinajavaworld.com/index.jspa','1156','1','0','0','0','0','0','1889','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9120','JAVAѧϰ','http://www.java3z.com/cwbwebhome/','1156','15','0','0','0','0','0','2171','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9121','The Java Boutique','http://javaboutique.internet.com','1156','16','0','0','0','0','0','59','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9122','йLinux̳','http://www.linuxforum.net','1157','2','0','0','0','0','0','884','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9123','йUNIX̳','http://www.chinaunix.net','1157','5','0','0','0','0','0','389','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9124','Linux','http://www.redflag-linux.com','1157','16','0','0','0','0','0','961','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9125','linuxмվ','http://www.chinalinuxpub.com','1157','4','0','0','0','0','0','322','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9126','NULL','http://www.linuxn.comLinux֮','1157','8','0','0','0','0','0','308','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9128','Linuxר-','http://linux.ccidnet.com','1157','6','0','0','0','0','0','164','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9129','linuxǳռ','http://linux.tcpip.com.cn/','1157','9','0','0','0','0','0','171','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9130','˼й','http://www.turbolinux.com.cn','1157','13','0','0','0','0','0','119','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9131','Linux԰','http://linuxeden.com','1157','12','0','0','0','0','0','532','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9132','ԶUNIX','http://www.fanqiang.com','1157','11','0','0','0','0','0','225','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33777','ְҵʸ','http://www.nvq.net.cn/','967','2','0','0','0','0','0','5214','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9137','Delphi԰','http://www.delphifans.com','1158','1','0','0','0','0','0','1397','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9138','DELPHI','http://www.2ccc.com/','1158','2','0','0','0','0','0','693','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9139','delphiҤ','http://www.51delphi.com/delphi','1158','4','0','0','0','0','0','339','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9140','-Delphiר','http://dev.21tx.com/language/delphi/','1158','8','0','0','0','0','0','200','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9141','delphi','http://www.aidelphi.com','1158','7','0','0','0','0','0','453','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9142','VC֪ʶ','http://www.vckbase.com','1159','3','0','0','0','0','0','2745','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9145','VC','http://www.vczx.com','1159','2','0','0','0','0','0','1868','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33812','CC++C#VC̳','http://www.ibook8.com/book/c.htm','1159','8','0','0','0','0','0','5627','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38357','йƵƸ','http://www.hoteljob.cn','1696','33','0','0','0','0','0','6173','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38359','˲Ƹ','http://www.ejob100.cn','1696','34','0','0','0','0','0','4169','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9152','йPHP','http://www.phpx.com','1160','2','0','0','0','0','0','705','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9153','ԽPHP','http://www.phpe.net','1160','15','0','0','0','0','0','144','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9156','PHP ר','http://www.builder.com.cn/php.shtml','1160','13','0','0','0','0','0','302','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9160','̫ƽѧԺ-php','http://www.pconline.com.cn/pcedu/empolder/wz/php/','1160','3','0','0','0','0','0','508','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11454','PHP5о','http://www.phpv.net/','1160','5','0','0','0','0','0','152','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9162','unix̳-php','http://bbs.chinaunix.net/forum/viewforum.php?f=27','1160','4','0','0','0','0','0','105','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9163','̬վ-php','http://www.knowsky.com/php.asp','1160','10','0','0','0','0','0','308','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9164','PHPٷվ(Ӣ)','http://www.php.net/','1160','1','0','0','0','0','0','226','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33843','WAP-ר-ͨ','http://www.cww.net.cn/tech/WAP','1161','5','0','0','0','0','0','97','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9166','PHP-','http://tech.ccidnet.com/pub/column/c1113.html','1160','11','0','0','0','0','0','115','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9168','NULL','http://cosoft.org.cn/html/osl/browse.php?form_cat=183ƽ̨-php','1160','7','0','0','0','0','0','119','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9169','ԶUNIX-php','http://fanqiang.chinaunix.net/a4/b4/','1160','8','0','0','0','0','0','61','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9172','NULL','http://news.dvbbs.net/infoList/Catalog_44_1.htmlȷ-php','1160','14','0','0','0','0','0','136','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9173','wapй','http://www.wapcn.net','1161','1','0','0','0','0','0','907','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9174','WAP֮','http://www.wapzj.com','1161','2','0','0','0','0','0','530','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9175','WAPվ','http://www.wapease.com','1161','4','0','0','0','0','0','437','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9179','VB԰','http://www.vbgood.com','1162','3','0','0','0','0','0','1908','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9180','VB','http://vbworld.sxnw.gov.cn','1162','4','0','0','0','0','0','1497','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9182','AppleVBҳ','http://www.applevb.com','1162','2','0','0','0','0','0','535','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9185','-ѧVB','http://www.hongen.com/pc/program/vb/v1.htm','1162','5','0','0','0','0','0','1970','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9186','JSP','http://www.jspcn.net','1163','1','0','0','0','0','0','930','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9193','̫ƽjspѧϰ','http://www.pconline.com.cn/pcedu/empolder/wz/jsp/index.html','1163','2','0','0','0','0','0','760','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41246','Ů','http://www.jzlady.com/','664','33','0','0','0','0','0','0','0','','liao','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('9196','켫JSPר','http://dev.yesky.com/web/ysdevwebjsp/','1163','4','0','0','0','0','0','192','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9198','-JSP','http://www0.ccidnet.com/tech/jsp.html','1163','6','0','0','0','0','0','145','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9199','-JSP','http://tech.ccidnet.com/pub/column/c1112.html','1163','8','0','0','0','0','0','167','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9213','̫ƽPower Builder 6.0̳','http://www.pconline.com.cn/pcedu/empolder/db/pb/0203/43462.html','1165','1','0','0','0','0','0','872','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35940','','http://www.iriverchina.com/','1686','15','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9215','PB','http://ourmis.com','1165','7','0','0','0','0','0','277','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9216','NULL','http://www.pbreport.com PBͨǿ','1165','8','0','0','0','0','0','198','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33681','ר-Power Builder','http://www.china-askpro.com/pb.shtml','1165','6','0','0','0','0','0','318','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9219','ACCESS','http://www.accessoft.com','1166','8','0','0','0','0','0','1940','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33680','CSDN-ݿƵ','http://database.csdn.net/','1166','6','0','0','0','0','0','415','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9223','Դ-CGIԴ','http://www.ziyuan8.com/code/cgi/ZY8_11_1.html','1167','4','0','0','0','0','0','130','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33706','','http://www.conocoil.com/','1640','14','0','0','0','0','0','84','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9227','CGIѧ','http://www.jdon.com/idea/cgi.htm','1167','6','0','0','0','0','0','714','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33705','ķտ˹','http://www.daimlerchrysler.com.cn/','1640','13','0','0','0','0','0','22','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9231','cgiļ','http://www.3322.net/homepage/cgifaq.html','1167','7','0','0','0','0','0','105','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9232','','http://sina.allyes.com/main/adfclick?db=sina&bid=155888,196233,201227&cid=0,0,0&sid=189148&advid=3406&camid=27233&show=ignore&url=http://auto.sina.com.cn/?c=spr_sw_sq_114la_auto_t001','1169','3','0','0','0','0','0','135120','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9233','Ѻ','http://auto.sohu.com/?p=b5ed082ba0','1169','7','0','0','0','0','0','63939','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9234','̫ƽ','http://www.pcauto.com.cn/?ad=575','1169','1','0','1','0','0','32','139789','42','','ylmf','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('9235','','http://auto.163.com','1169','11','0','0','0','0','0','38670','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9236','TOM','http://auto.tom.com','1169','10','0','0','0','0','0','32897','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9237','ϳ','http://www.cheshi.com.cn','1169','6','0','0','0','0','0','38182','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9238','CHE168','http://www.che168.com','1169','21','0','0','0','0','0','17551','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9239','֮','http://www.autohome.com.cn','1169','5','0','0','0','0','0','139293','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9240','Ż','http://cn.autos.yahoo.com','1169','8','0','0','0','0','0','28989','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9242','׳','http://www.bitauto.com/?WT.mc_id=bitauto0106B0009','1169','15','1','0','0','0','0','15685','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9243','й','http://www.chinacars.com','1169','4','0','0','0','0','0','149859','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32950','ҵ','http://www.cqcbank.com','2047','40','0','0','0','0','0','551','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32977','ҵ','http://www.jnccb.com/','2047','20','0','0','0','0','0','534','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33000','QunarؼۻƱ','http://www.qunar.com/twell/redirect.jsp?url=http://flight.qunar.com?dfly=aarla2','1713','28','0','0','0','0','0','26','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41265','ʱװ','http://www.masamaso.com/interface.php?id=102723&url=http://www.masamaso.com/index.shtml?from=114la','852','14','0','0','0','0','0','0','0','','liao','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33004','ӼƵ','http://www.openv.tv/','1713','14','0','0','0','0','0','1907','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38305','518Ϣ','http://www.hd518.com','1889','51','0','0','0','0','1','2715','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9254','','http://www.chelink.com','1169','13','0','0','0','0','0','9277','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32965','Ϻ','http://www.bankofshanghai.com/','2047','5','0','0','0','0','0','4417','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32935','ڷչ','http://www.sdb.com.cn','2047','41','0','0','0','0','0','396','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34969','һҵ','http://www.firstbank.com.tw/','2047','23','0','0','0','0','0','628','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32928','ƽ','http://www.18ebank.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32927','ũҵ','http://www.bjrcb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32926','ҵ','http://www.xmccb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32925','ҵ','http://www.gzcb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33013','ֵ','http://www.zdic.net/','1713','22','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32924','ɽҵ','http://www.lsccb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32923','«ҵ','http://www.hldccb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32922','ҵ','http://www.fxcb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32921','ҵ','http://www.dyccb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32920','ҵ','http://www.jxccb.com/index.asp','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32919','ҵ','http://www.lzccb.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32918','ҵ','http://www.rccb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32917','ൺ','http://www.qibank.net/newEbiz1/EbizPortalFG/portal/html/index.html','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32916','ȷҵ','http://www.lccb.com.cn/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33011','','http://search.soufun.com/','1713','19','0','0','0','0','0','297','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32915','տҵ','http://www.zjcbank.com/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32914','ҵ','http://www.0534114.com/dzccb/','1643','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9296','','http://www.ford.com.cn','1170','1','0','0','0','0','0','5440','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9297','','http://www.bmw.com.cn','1170','2','0','0','0','0','0','7540','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9298','','http://www.chery.cn','1170','3','0','0','0','0','0','6906','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9299','ִ','http://www.hyundai-motor.com.cn','1170','4','0','0','0','0','0','4357','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9300','йվ','http://www.mercedes-benz.com.cn/','1170','5','0','0','0','0','0','3142','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9301','ִ','http://www.beijing-hyundai.com.cn','1170','6','0','0','0','0','0','5506','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9303','','http://www.peugeot.com.cn','1170','7','0','0','0','0','0','1893','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9304','ǵ','http://www.bydauto.com.cn','1170','8','0','0','0','0','0','4428','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9306','Ϻͨ','http://www.shanghaigm.com','1170','9','0','0','0','0','0','4728','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9307','','http://www.gwm.com.cn','1170','10','0','0','0','0','0','2272','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9308','','http://www.hafeiauto.com.cn','1170','11','0','0','0','0','0','2742','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9309','һ','http://www.faw-volkswagen.com','1170','12','0','0','0','0','0','7610','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9310','ͨйվ','http://www.gmchina.com','1170','13','0','0','0','0','0','1439','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9311','ӱ','http://www.zxauto.com.cn','1170','14','0','0','0','0','0','688','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9312','Ͼ','http://www.fiat.com.cn','1170','15','0','0','0','0','0','966','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9313','','http://www.dfmc.com.cn','1170','16','0','0','0','0','0','3167','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9314','һ','http://www.tjfaw.com','1170','17','0','0','0','0','0','2099','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9315','Ͼά','http://www.naveco.com.cn','1170','18','0','0','0','0','0','2204','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9316','ֶй','http://www.volvocars.com.cn','1170','19','0','0','0','0','0','2161','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9317','','http://www.dpca.com.cn','1170','20','0','0','0','0','0','751','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40109','Ժչо','http://www.drc.gov.cn/','2184','100','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9319','ѩй','http://www.citroen.com.cn','1170','22','0','0','0','0','0','3454','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40108','йԺ','http://www.cae.cn/','2184','100','0','0','0','0','0','4','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9324','','http://www.futian.com.cn','1170','27','0','0','0','0','0','1842','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35116','ʱ','http://www.haibao.tv/','735','11','0','0','0','0','1','7422','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9326','Ϻҵܹ˾','http://www.saicgroup.com','1170','28','0','0','0','0','0','909','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9329','֣ղ','http://www.zhengzhounissan.com.cn','1170','29','0','0','0','0','0','2481','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9330','лҵ','http://www.china-motor.com.tw','1170','30','0','0','0','0','0','2040','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9331','','http://www.tianmaauto.com','1170','31','0','0','0','0','0','1365','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9332','','http://www.huapucar.com','1170','32','0','0','0','0','0','1600','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9333','ɽڱŹ˾','http://www.heibao.com','1170','33','0','0','0','0','0','974','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9336','ͳ','http://www.king-long.com.cn','1170','34','0','0','0','0','0','3191','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9337','йƷ','http://www.car2100.com','1171','2','0','0','0','0','0','8659','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38577','ʡ','http://www.fff33.com','1821','7','0','0','0','0','0','831','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9341','йƷ','http://www.autosup.com','1171','7','0','0','0','0','0','5466','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9343','۴ҵ','http://www.auto-p.hc360.com','1171','4','0','0','0','0','0','3663','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9346','۴','http://www.hc360.com','1173','2','0','0','0','0','0','152044','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9347','NULL','http://www.sohu.netѺ̻','1173','8','0','0','0','0','0','1706','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9349','л','http://www.i18.cn','1173','26','0','0','0','0','0','2593','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9350','й','http://www.mofcom.gov.cn/','1173','1','0','0','0','0','0','703','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9351','ҵ','http://china.busytrade.com','1173','10','0','0','0','0','0','1875','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9354','йֱרҵ','http://www.cdsp.com.cn','1173','27','0','0','0','0','0','2202','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9355','йͶָ','http://www.fdi.gov.cn','1173','11','0','0','0','0','0','2093','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9373','','http://www.mymai.com','1173','9','0','0','0','0','0','1950','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9408','йб','http://www.bidchance.com/','1173','7','0','0','0','0','0','1200','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9420','','http://www.sooe.cn','1173','6','0','0','0','0','0','734','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40132','ƾ','http://www.caijing.com.cn/','1668','3','0','0','0','0','0','111','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9424','ȫ','http://www.ometal.com','1218','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9425','ȫ֯','http://www.tnc.com.cn/','1218','2','0','0','0','0','0','933','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9426','ó','http://www.chemease.com','1218','39','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31954','׿Ѷ-','http://chem.chem99.com/','1195','34','0','0','0','0','0','455','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9429','йŻ','http://www.chemn.com','1218','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9430','йũҵ','http://www.agronet.com.cn','1218','24','0','0','2','2','56','586','0','','lsz','3','2','0','0','','0');
INSERT INTO ylmf_site VALUES('31503','㿵찲ٱչ˾','http://www.jhta.com.cn/','1995','9','0','0','0','0','0','576','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9433','йó','http://www.snet.com.cn','1218','16','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36686','ѧ-ƼְҵѧԺ','http://www.ycu.com.cn/','1318','12','0','0','0','0','0','46','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33352','̳֮','http://bbs.mydrivers.com/','1107','8','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40270','Ԥѯ','http://weather.114la.com/weather.htm','2035','1','1','0','0','0','0','0','0','#FF0000','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31955','Ļ','http://www.hxchem.net/','1195','21','0','0','0','0','0','463','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9444','й뵼ҵ','http://www.csia.net.cn','1218','11','0','0','0','0','0','695','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9447','й֯','http://www.cntexnet.com','1218','30','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33358','Э','http://www.fpf.pt/','1026','15','0','0','0','0','0','237','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9452','һʳƷó','http://www.foods1.com/','1218','38','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33056','й','http://www.circ.gov.cn/','860','11','0','0','0','0','0','2542','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31494','й','http://www.standardchartered.com.cn/','1688','3','0','0','0','0','0','1985','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32476','Ӣ','http://www.hjenglish.com/','1045','4','0','0','0','0','0','375','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9459','йҵϢ','http://www.feedtrade.com.cn/','1218','25','0','0','0','0','0','467','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33360','Jumbo.com','http://www.jumbo.com/','1117','3','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31509','йͶᱣϲ','http://www.mohrss.gov.cn','860','10','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9465','','http://www.linkshop.com.cn','1173','1','0','0','0','0','0','682','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35421','˲Ż','http://ylrc.gz163.cn/','1540','14','0','0','0','0','0','315','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9467','йչ','http://www.expo-china.com','1176','1','0','0','0','0','0','995','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35423','NULL','http://guizhou.chinarck.com/˲ſ','1540','5','0','0','0','0','0','342','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9471','йչ','http://www.cce.net.cn/','1176','3','0','0','0','0','0','268','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9479','Ͱ-չ','http://expo.china.alibaba.com/','1176','5','0','0','0','0','0','200','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9482','','http://www.expo2010china.com/','1176','6','0','0','0','0','0','121','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9483','չ','http://www.ciec.com.cn/','1176','7','0','0','0','0','0','98','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35424','ǭ˲','http://www.guiqianrc.com/','1540','7','0','0','0','0','0','520','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34616','Ͱ̳','http://club.china.alibaba.com/','1930','22','0','0','0','0','0','1863','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35418','½˲','http://www.78hr.com/','1522','4','0','0','0','0','0','253','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34614','ѷҵ̳','http://bbs.soufun.com/','1930','23','0','0','0','0','0','425','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35417','NULL','http://www.bolele.com/Ƹ','1522','14','0','0','0','0','0','323','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16411','','http://finance.163.com/money/','1642','4','0','0','0','0','0','2816','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16406','һ','http://www.amoney.com.cn/cms.php','1642','17','0','0','0','0','0','7076','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32764','Ӫ','http://www.51ttyy.com/','739','13','0','0','0','0','1','40499','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16404','ڽ','http://money.jrj.com.cn/money/','1642','7','0','0','0','0','0','4549','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16402','йͶ','http://www.vcinchina.com/','1652','1','0','0','0','0','0','1579','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16400','йͶ','http://www.chnvc.com/','1652','2','0','0','0','0','0','1397','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38369','','http://www.changchun.gov.cn/','1844','2','0','0','0','0','0','281','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9544','йұ𾭼Ϣ','http://www.chinaesteel.com.cn','1180','4','0','0','0','0','0','315','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9546','ɫԴ','http://www.cnncmrc.com','1180','17','0','0','0','0','0','5461','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9547','ұ۸Ϣ','http://www.metalprice.net','1180','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9550','ұó','http://www.mc-ccpit.com','1180','18','0','0','0','0','0','464','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9552','йұϢ','http://www.metalinfo.com.cn','1180','3','0','0','0','0','0','3839','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9554','NULL','http://www.csinf.com֮','1180','20','0','0','0','0','0','1810','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9556','NULL','http://www.metal.net.cnйұ','1180','2','0','0','0','0','0','6524','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9557','йǽϢ','http://www.chinanmm.com','1180','24','0','0','0','0','0','1639','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9558','йʿҵ','http://www.china-mining.org','1180','21','0','0','0','0','0','1138','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9559','лĩұ','http://www.fenmoyejin.com','1180','25','0','0','0','0','0','1591','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9561','ұٽ','http://www.mippc.net.cn','1180','26','0','0','0','0','0','460','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38481','ɫ','http://www.swcool.com/','2102','9','0','0','0','0','1','6654','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9567','ȫ','http://www.ometal.com','1181','7','0','0','0','0','0','7457','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9572','й','http://www.ldmetals.com','1181','8','0','0','0','0','0','1331','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9573','й','http://www.chinascrap.com','1181','23','0','0','0','0','0','8010','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9574','','http://www.dfjinshu.com','1181','1','0','0','0','0','0','3846','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9575','йϽ','http://www.cn-fe.com','1181','21','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9576','йͲ','http://www.capm.net','1181','24','0','0','0','0','0','1812','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9578','Ϣ','http://www.alum-info.com','1181','26','0','0','0','0','0','2511','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9579','йɫӹ','http://www.ysjg.cn','1181','18','0','0','0','0','0','2316','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9580','Ϣ','http://www.world-metal.com','1181','11','0','0','0','0','0','2527','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9584','NULL','http://www.cmpi.com.cnйҵ','1181','2','0','0','0','0','0','263','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9585','ұ۸Ϣ','http://www.metalprice.net','1181','9','0','0','0','0','0','9948','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9588','ɫоԺ','http://www.c-nin.com','1181','19','0','0','0','0','0','857','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9589','NULL','http://www.ecmetal.com','1181','6','0','0','0','0','0','1300','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35010','й','http://www.cnpcnet.cn/','1184','7','0','0','0','0','0','512','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35009','','http://www.3mb.cn/','1184','3','0','0','0','0','0','704','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9597','йұ𾭼Ϣ','http://www.chinaesteel.com.cn/','1181','14','0','0','0','0','0','2577','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9599','ҵĸ','http://www.mysteel.com','1182','1','0','0','0','0','0','6452','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9600','Ҫ','http://www.51bxg.com','1181','11','0','0','0','0','0','1616','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9601','йϸ','http://www.custeel.com','1182','2','0','0','0','0','0','4427','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9603','йϽ','http://www.cn-fe.com','1181','13','0','0','0','0','0','2133','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9604','й','http://www.yesteel.com','1182','6','0','0','0','0','0','1649','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9606','.й','http://www.bxg.cn','1181','12','0','0','0','0','0','990','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9607','й','http://www.coke-iron.com','1181','10','0','0','0','0','0','926','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9608','й','http://www.chinasteel.com.cn','1182','3','0','0','0','0','0','7626','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9615','й','http://www.bxg86.com/','1182','4','0','0','0','0','0','611','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9619','й׸ּ','http://www.shougang.com.cn','1183','1','0','0','0','0','0','349','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9621','ɽ','http://www.ansteel.com.cn','1183','6','0','0','0','0','0','188','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9623','ּ','http://www.baosteel.com','1183','2','0','0','0','0','0','2820','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9626','ɽ','http://www.magang.com.cn','1183','3','0','0','0','0','0','1347','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40188','֮','http://www.steelhome.cn/','1182','5','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9640','й','http://www.foundry.com.cn','1184','1','0','0','0','0','0','2678','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9641','NULL','http://www.cfmt.net/ó','1184','9','0','0','0','0','0','616','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9643','־','http://www.foundryworld.com','1184','10','0','0','0','0','0','636','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9649','йʦ','http://www.china-designer.com','1186','12','0','0','0','0','1','27045','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9651','йб','http://www.zhaobiao.gov.cn','1186','2','0','0','0','0','0','4323','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9652','й','http://www.landscapecn.com','1186','6','0','0','0','0','0','1861','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9654','йװ','http://www.ccd.com.cn','1186','8','0','0','0','0','0','1804','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31521','йд','http://www.icbc.com.cn/icbc/%E7%BD%91%E4%B8%8A%E5%9F%BA%E9%87%91/','1996','49','0','0','0','0','0','4645','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34809','Ϸ','http://www.southernfund.com/nanfang/','1996','2','0','0','0','0','0','21186','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9667','쳽','http://www.buildnet.cn','1186','15','0','0','0','0','0','722','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34813','׷','http://www.efunds.com.cn/','1996','6','0','0','0','0','0','18352','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9674','йѶ','http://www.chinabei.com','1186','11','0','0','0','0','0','1347','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34821','NULL','http://www.phfund.com.cn/','1996','13','0','0','0','0','0','8583','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9677','','http://www.zhulong.com','1186','10','0','0','0','0','0','4307','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34824','ͶĦ','http://www.51fund.com/','1996','16','0','0','0','0','0','21053','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31524','йũҵд','http://www.95599.cn/jijin/Fund/Fund_Index.aspx','1996','46','0','0','0','0','0','3350','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9689','ˮ','http://www.shuigong.com','1188','6','0','0','0','0','0','1386','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9706','йĿ','http://www.gcxm.com.cn','1188','1','0','0','0','0','0','775','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9715','̽','http://www.hnecc.net','1188','3','0','0','0','0','0','852','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32766','лʳ','http://www.zhms.cn/','739','8','0','0','0','0','0','22050','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35406','ɹŰͷ˲','http://www.0472rc.com/','1532','14','0','0','0','0','0','640','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9739','йнϢ','http://www.csjs.gov.cn','1188','7','0','0','0','0','0','524','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9743','NULL','http://www.cacp.org.cnйй滮Э','1188','4','0','0','0','0','0','385','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9746','йй滮оԺ','http://www.caupd.com.cn','1188','5','0','0','0','0','0','416','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9747','йĵһ','http://www.jc001.cn','1189','5','0','0','0','0','0','7435','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11485','Ƿվ','http://www.crsky.com/','1106','13','0','0','0','0','2','49177','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9768','ɫ','http://www.greenjc.com','1189','11','0','0','0','0','0','2454','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40290','л','http://www.ccmnet.com/','2119','2','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40291','չ','http://fair.mofcom.gov.cn/','1176','4','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9787','йľ','http://www.chinatimber.org','1189','16','0','0','0','0','0','5030','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9788','йľҵ','http://www.chinawood.org','1189','17','0','0','0','0','0','714','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39856','»','http://www.awc618.com/','828','1','0','0','0','0','0','3','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9792','йʯӦ','http://www.stoneyy.com/','1189','24','0','0','0','0','0','2431','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9794','йʯĵһ','http://www.1stone.com.cn/','1189','21','0','0','0','0','0','1250','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9798','ˮ','http://www.snsqw.com','1189','25','0','0','0','0','0','2487','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31578','ƸƵ','http://data.eastmoney.com/','1997','3','0','0','0','0','0','4162','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31577','','http://info.cmbchina.com/cmb2005stock/investaspxbin/Calculator/Calculator.aspx?c_id=2','1997','11','0','0','0','0','0','3381','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9807','ճǱ','http://www.fstcb.com','1193','8','0','0','0','0','0','258','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9808','йմϢԴ','http://www.ccisn.com.cn','1193','2','0','0','0','0','0','1288','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9810','մ','http://www.chinachina.net','1193','7','0','0','0','0','0','739','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9811','NULL','http://www.ccenn.com','1193','4','0','0','0','0','0','981','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9814','۴Ͻմ','http://www.ceramic.hc360.com','1193','3','0','0','0','0','0','507','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9816','»մ-ó','http://www.porcelain-trade.com','1193','6','0','0','0','0','0','240','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9820','','http://www.chemworld.com.cn','1195','46','0','0','0','0','0','3451','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9821','ó','http://www.chemease.com','1195','47','0','0','0','0','0','2417','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9822','йϢ','http://www.cheminfo.gov.cn','1195','2','0','0','0','0','0','5850','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9823','йƸ','http://www.hgjob.com','1195','21','0','0','0','0','0','2455','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9825','йά','http://www.chem.com.cn','1195','20','0','0','0','0','0','10','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9826','й','http://www.chem17.com','1200','7','0','0','0','0','0','180','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9827','йŻ','http://www.chemn.com','1195','13','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9828','йгѶ','http://www.qrx.cn','1195','22','0','0','0','0','0','1953','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9832','йע','http://www.yxx.com.cn','1196','23','0','0','0','0','0','902','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9834','ѯ','http://www.ccfei.com/','1195','49','0','0','0','0','0','86','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9835','۴ϻ','http://www.chem.hc360.com','1195','33','0','0','0','0','0','1040','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9838','','http://www.chemol.com.cn','1195','50','0','0','0','0','0','1203','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9840','й','http://www.chemnet.com.cn','1195','4','0','0','0','0','0','6800','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9842','й','http://www.ccecn.com','1195','17','0','0','0','0','0','223','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9847','йϢ','http://www.chemnews.com.cn','1195','11','0','0','0','0','0','300','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9849','','http://www.cnwestchem.com','1195','48','0','0','0','0','0','950','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9853','йҵ','http://www.cpcp.com.cn','1195','10','0','0','0','0','0','513','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9860','йҵ','http://www.su-liao.com','1196','5','0','0','0','0','0','2085','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9861','й','http://www.plasway.com','1196','6','0','0','0','0','0','851','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9862','й','http://www.chinaplastic.net','1196','1','0','0','0','0','0','4651','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9863','йƷ','http://www.chinappmarket.com','1196','8','0','0','0','0','0','898','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9864','۴','http://www.plas.hc360.com','1196','3','0','0','0','0','0','1428','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9865','й','http://www.zssl.net/','1196','9','0','0','0','0','0','4171','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9868','','http://www.21cp.net/','1196','2','0','0','0','0','0','1069','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9869','л','http://www.plastic.com.cn/','1196','4','0','0','0','0','0','885','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39927','˹ά[Ӣ]','http://www.astonvilla-fc.co.uk/','2154','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9873','й','http://www.engplast.com.cn','1196','20','0','0','0','0','0','470','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9874','йִ','http://www.plasb2b.com','1196','21','0','0','0','0','0','825','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9876','','http://www.engplastics.net','1196','11','0','0','0','0','0','574','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9882','йŻ','http://www.chemn.com','1196','23','0','0','0','0','0','1182','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32667','ǻ̳','http://bbs.mso.com.cn/','697','9','0','0','0','0','0','59','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9886','йϻеҵЭ','http://www.cppmia.org.cn','1196','25','0','0','0','0','0','421','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40769','Ƶ','http://cartoon.tudou.com/','777','2','0','0','0','0','3','804','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9893','й','http://www.artglassnet.com','1198','6','0','0','0','0','0','281','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9896','йòϢ','http://www.cnagi.org.cn','1198','3','0','0','0','0','0','290','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38405','Բ','http://www.apoints.com/','2102','2','0','0','0','0','0','10002','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9899','йҵ','http://www.chinaglassnet.com','1198','1','0','0','0','0','0','195','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9901','GlassAsia','http://www.asiaglass.com.sg','1198','14','0','0','0','0','0','46','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9902','GlassGlobal','http://www.glassglobal.com','1198','15','0','0','0','0','0','37','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9920','й豸','http://www.ccen.net','1200','3','0','0','0','0','0','1005','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40198','۴ˮҵ','http://www.water.hc360.com/','1248','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9923','й','http://www.chemmach.com/','1200','1','0','0','0','0','0','331','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9926','׿Ѷ-','http://rubb.chem99.com/','1201','6','0','0','0','0','0','434','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9929','й','http://www.cria.org.cn','1201','1','0','0','0','0','0','1233','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9933','йгϢ','http://www.crminet.net.cn','1201','3','0','0','0','0','0','277','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9934','й','http://www.ldrubber.com','1201','4','0','0','0','0','0','327','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9942','йԴ','http://www.newenergy.org.cn','1203','1','0','0','0','0','1','4531','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('9943','NULL','http://www.chinasolar.com.cnй̫Ϣ','1203','8','0','0','0','0','0','2319','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9946','йԴԴ','http://www.crein.org.cn','1203','4','0','0','0','0','0','2284','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9950','Ͱ-Դҵ','http://china.alibaba.com/buy/trade/10.html','1203','15','0','0','0','0','0','388','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40206','NULL','http://www.ncer.tsinghua.edu.cn/廪ѧйо','984','21','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40205','11464-ѯ','http://www.11464.com','1879','10','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9956','¡ʯ','http://www.oilchem.net','1204','16','0','0','0','0','0','728','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9957','','http://www.oilgas.com.cn','1204','9','0','0','0','0','0','1041','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9958','йʯ','http://www.oilnews.com.cn','1204','1','0','0','0','0','0','4475','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9960','йʯȻ','http://www.petrochina.com.cn','1204','11','0','0','0','0','0','1065','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9961','йʯ','http://www.sinopecnews.com.cn','1204','4','0','0','0','0','0','2321','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9962','йʯ','http://www.oilchina.com','1204','2','0','0','0','0','0','1769','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9963','йʯ','http://www.sinopec.com','1204','12','0','0','0','0','0','2127','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9967','йʯ','http://www.chinaoilonline.com','1204','5','0','0','0','0','0','1504','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9968','йƷѶ','http://www.oilinfor.com','1204','6','0','0','0','0','0','180','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9973','ʯ','http://www.worldoilweb.com','1204','3','0','0','0','0','0','1958','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32483','Ұ','http://www.52kr.com/','1050','7','0','0','0','0','0','7318','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9986','йҵϻ','http://www.cec.org.cn','1205','1','0','0','0','0','0','436','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9987','й','http://www.chinapower.com.cn','1205','3','0','0','0','0','0','720','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9989','ũϢ','http://www.chinarein.com','1205','15','0','0','0','0','0','135','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9990','ҵίԱ','http://www.serc.gov.cn','1205','6','0','0','0','0','0','294','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9998','йҵϻ','http://www.dls.org.cn','1205','11','0','0','0','0','0','143','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('9999','','http://www.freshpower.cn','1205','10','0','0','0','0','0','154','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34948','Ʒ','http://www.powerproduct.com/','1205','21','0','0','0','0','0','218','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34947','ǵ','http://www.bjx.com.cn/','1205','22','0','0','0','0','0','114','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10004','й','http://www.chinapoweronline.com','1205','2','0','0','0','0','0','309','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10006','۴','http://www.electric.hc360.com/','1205','5','0','0','0','0','0','120','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34946','豸','http://www.cepee.com/','1205','8','0','0','0','0','0','165','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10010','ϵͳԶ','http://www.aeps-info.com','1205','17','0','0','0','0','0','163','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34945','й','http://www.cpnn.com.cn/','1205','4','0','0','0','0','0','293','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34944','й豸Ϣ','http://www.cpeinet.com.cn/','1205','9','0','0','0','0','0','134','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10018','йװ','http://www.99dq.com','1205','7','0','0','0','0','0','151','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10019','ú','http://www.3jjj.com','1206','1','0','0','0','0','0','3930','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10020','йú̿','http://www.cwestc.com','1206','2','0','0','0','0','0','353','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10021','ú̿','http://www.coal.com.cn','1206','3','0','0','0','0','0','1868','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10024','йú̿Դ','http://www.sxcoal.com','1206','4','0','0','0','0','0','1511','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10028','йúֽг','http://www.ccce.com.cn','1206','7','0','0','0','0','0','524','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10034','йú̿','http://www.coalmus.org.cn','1206','6','0','0','0','0','0','161','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10036','йƷƷװ','http://www.china-ef.com','1208','4','0','0','0','0','0','29088','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10037','лװ','http://www.51fashion.com.cn','1208','3','0','0','0','0','2','15523','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10038','йװ','http://www.t100.cn','1208','1','0','0','0','0','0','28120','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35501','˾-','http://www.fafawang.com/','994','12','0','0','0','0','0','1000','0','','LUOJ','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10041','й֯','http://www.wears.com.cn','1208','9','0','0','0','0','0','3642','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10042','йŮװ','http://www.nz86.com/','1208','5','0','0','0','0','0','37797','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10043','·','http://www.yifu.com','1208','7','0','0','0','0','0','7626','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36089','NULL','http://www.edu24h.com/caikuai/main/йƷ','995','113','0','0','0','0','0','290','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10045','йװЭ','http://www.cnga.org.cn','1208','2','0','0','0','0','0','6851','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10046','ELLEʱг','http://www.ellechina.com','1208','17','0','0','0','0','0','2840','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10049','ʱװ','http://fashion.icxo.com','1208','13','0','0','0','0','0','7879','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10050','йװ','http://www.f168z.com','1208','8','0','0','0','0','0','6977','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10055','й֯','http://www.texnet.com.cn/','1208','11','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10056','йţзװ','http://www.511340.com','1208','5','0','0','0','0','0','15623','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23291','Ȼ羰','http://www.bjfhl.com/','1797','100','0','0','0','0','0','1107','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10065','лͯװ','http://www.e-ccdc.com','1208','19','0','0','0','0','0','12146','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10066','Ů-Ƶ','http://www.rayli.com.cn/fashion','1208','16','0','0','0','0','0','9426','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10068','ʱзװ','http://www.cnwear.com/','1208','14','0','0','0','0','0','6398','0','','lsz','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('36088','й˰','http://www.edu110.com/','995','8','0','0','0','0','0','434','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40139','','http://a.oadz.com/link/C/773/439/HKwvAP0iFpWS7FXlOfydt0iVgoQ_/a/67?www.vaakav.com','1213','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40140','ൺơ','http://www.tsingtao.com.cn/','1872','23','0','0','0','0','1','8','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40973','ʱ','http://pop.zoshow.com','2189','96','0','0','0','0','0','9','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40146','No5ʱй㳡','http://www.no5.com.cn/?from=114la','2189','95','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40147','ʳ','http://www.meishij.net/','2189','76','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40148','ʳĻ','http://www.chinavegan.com/','2189','91','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40149','ʳ״ȫ','http://www.spos.com.cn/','2189','90','0','0','0','0','1','3','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40150','лʳ','http://www.zhms.cn/','2189','94','0','0','0','0','0','398','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40151','QunarؼۻƱ','http://www.qunar.com/twell/redirect.jsp?url=http://flight.qunar.com?dfly=aarla2','2189','92','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40152','Ƶȫ','http://www.qunar.com/twell/redirect.jsp?url=http://hotel.qunar.com?dfly=aarla3','2189','85','0','0','0','0','0','2','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40153','eҼҾ','http://www.e-jjj.com/','2189','86','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40154','ѷ','http://www.soufun.com/','2189','89','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40155','ͼ','http://www.ddmap.com/','2189','88','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40156','㷿','http://house.focus.cn/','2189','87','0','0','0','0','0','1','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40163','Ů̳','http://bbs.nvkan.com','1934','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40158','â','http://www.mangocity.com/','2189','83','0','0','0','0','0','0','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40159','Я','http://www.ctrip.com/','2189','84','0','0','0','0','3','3243','0','','lzb','1','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40160','ȸͼ','http://ditu.google.com/','2189','80','0','0','0','0','0','5','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40161','Ʊ','http://www.huochepiao.com/','2189','82','0','0','0','0','0','21','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40162','ȥĶ','http://www.qunar.com/','2189','81','0','0','0','0','2','547','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('40164','йб','http://www.chinabidding.com/','1926','8','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40165','۴','http://www.fire.hc360.com','1657','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40166','۴ƹ','http://www.audio.hc360.com','919','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40167','۴ϰ','http://www.secu.hc360.com','1657','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23289','԰','http://www.beijingzoo.com/','1797','100','0','0','0','0','0','3552','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10116','й廨','http://www.emb163.com/','1661','1','0','0','0','0','0','5622','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10127','ѲЬ','http://www.soxu.cn','1212','11','0','0','0','0','0','2483','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10128','йЬcnxz.cn','http://www.cnxz.cn','1212','10','0','0','0','0','0','1700','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10129','йЬ','http://www.cnshoes.com','1212','7','0','0','0','0','0','4985','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10131','йЬҵ','http://www.chinashoes.com','1212','6','0','0','0','0','0','1142','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10134','йЬҵ','http://www.shoeol.com/','1212','16','0','0','0','0','0','3658','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10138','඼','http://www.worldsocks.com','1212','11','0','0','0','0','0','1986','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35509','йװЬñ','http://www.fzxm.com/','1212','1','0','0','0','0','0','2321','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10145','йЬҵ','http://www.cn-shoes.net/','1212','4','0','0','0','0','0','2675','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40138','ƷƷλ','http://www.myler.cn/shenghuopinpai/2188.htm#1871','1208','23','0','0','0','0','0','0','0','#333333','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10154','л','http://www.ne365.com','1213','1','0','0','0','0','0','95','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23292','ϿȻ羰','http://www.bjlongqingxia.com.cn/','1797','100','0','0','0','0','0','1211','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10162','й豸','http://www.sewworld.com','1208','15','0','0','0','0','0','1770','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10176','eBags','http://www.ebags.com','1215','3','0','0','0','0','0','805','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10177','й','http://china.bagsnet.com/','1215','1','0','0','0','0','0','5261','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31496','ʿ','http://www.ubs.com/','1688','16','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39835','','http://www.leadzil.com/','1218','41','0','0','0','0','0','6','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31506','˱','http://finance.sina.com.cn/money/insurance/index.html','860','3','0','0','0','0','0','2330','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10224','йʯͺͻ','http://www.chemall.com.cn','1218','1','0','0','0','0','0','575','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10231','йԪҵЭ','http://www.ic-ceca.org.cn','1218','12','0','0','0','0','0','1206','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11484','PHPWind Board','http://www.phpwind.net/','678','11','0','0','0','0','7','229','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33057','йҵЭ','http://www.iachina.cn/','860','12','0','0','0','0','0','1912','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31493','NULL','http://www.abnamro.com.hk/','1688','9','0','0','0','0','0','416','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33321','','http://www.losc.fr/','1034','3','0','0','0','0','0','20','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31508','ȼ','http://cfp.hexun.com/tools/adequacy.aspx','860','13','0','0','0','0','0','1584','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34574','NULL','http://202.207.7.23/index.htmlɹŴѧͼ','955','48','0','0','0','0','0','119','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40823','','http://www.meadin.com','2249','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34547','Ϻͨѧͼ','http://www.lib.sjtu.edu.cn/','955','9','0','0','0','0','0','224','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34571','Ϻѧͼ','http://202.120.121.193/','955','43','0','0','0','0','0','242','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34570','ũҵѧͼ','http://202.116.174.99/','955','41','0','0','0','0','0','174','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34569','ͨѧͼ','http://202.112.150.129/','955','39','0','0','0','0','0','77','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10280','йũҵϢ','http://www.agri.gov.cn','1222','1','0','0','0','0','0','5735','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10281','йũҵ','http://www.zgny.com.cn','1222','8','0','0','2','2','33','10979','0','','','1','2','0','0','','0');
INSERT INTO ylmf_site VALUES('34697','','http://chat.sz.net.cn/','742','100','0','0','0','0','0','20414','0','','lwh','0','0','1287244800','1287244800','','1');
INSERT INTO ylmf_site VALUES('40549','','http://www.ddmap.com','908','8','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10291','йũ','http://www.cnan.gov.cn','1222','20','0','0','0','0','4','2466','0','','','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('10293','й۸Ϣ','http://www.chinaprice.gov.cn/','1222','27','0','0','0','0','0','10638','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10297','ũ','http://www.db-nw.com','1222','25','0','0','0','0','1','1330','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34683','йũҵеѧ','http://www.agro-csam.org/','1656','13','0','0','0','0','0','534','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34681','йũҵеϢ','http://www.amic.agri.gov.cn/','1656','14','0','0','0','0','0','1587','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10311','NULL','http://www.agridoor.com.cn йũ','1654','29','0','0','0','0','0','2180','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10324','йܱ','http://www.china-flower.com','822','5','0','0','0','0','0','1859','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10327','԰ֻ','http://www.yuanlin.com.cn','822','7','0','0','0','0','1','3277','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10331','йľ̻','http://www.yxmm.com','1225','14','0','0','0','0','0','63','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10332','й','http://www.flowerchina.net/','822','4','0','0','0','0','0','1446','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10335','йֳ','http://www.chinabreed.com','1224','1','0','0','2','2','111','33312','0','','','5','3','0','0','','0');
INSERT INTO ylmf_site VALUES('10336','йҵ','http://www.china-ah.com','1224','6','0','0','0','0','2','3725','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10337','йҽ','http://www.cnaho.com','1224','8','0','0','0','0','1','5942','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10348','ֳ','http://www.yangzhi.net','1224','7','0','0','0','0','61','14297','0','','lsz','1','1','0','0','','0');
INSERT INTO ylmf_site VALUES('10366','ũˮ','http://fishery.aweb.com.cn/','1226','3','0','0','0','0','0','1843','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10368','йˮŻ','http://www.bbwfish.com','1226','8','0','0','0','0','0','4940','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10369','NULL','http://www.fish.gov.cn/йҵó','1226','2','0','0','0','0','0','1861','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('23294','ɽ','http://www.lingshan.org/','1797','100','0','0','0','0','0','1022','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10383','йʳƷ','http://www.21food.cn','1229','1','0','0','0','0','1','8681','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10384','ʳƷ','http://www.foodmate.net','1229','21','0','0','0','0','0','5768','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10385','NULL','http://www.foodqs.comйʳƷҵ','1229','2','0','0','0','0','0','686','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10386','йʳƷƼ','http://www.tech-food.com','1229','4','0','0','0','0','0','1810','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10388','йʳƷҵ','http://www.cfiin.com','1229','6','0','0','0','0','0','2653','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10390','йʳƷ','http://www.cfqn.com.cn','1229','8','0','0','0','0','0','1553','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32424','CnMp3','http://www.cnmp3.com/','716','10','0','0','0','0','2','195191','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10392','йʳƷչ','http://www.foodexpo.cn','1229','9','0','0','0','0','0','2055','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10393','йʳƷ','http://www.cn-food.net','1229','10','0','0','0','0','0','2132','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10394','йʳƷ','http://www.foodszs.com/','1229','28','0','0','0','0','0','3005','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10396','йɫʳƷ','http://www.greenfood.org.cn/','1229','11','0','0','0','0','0','3258','0','','lsz','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('10397','һʳƷó','http://www.foods1.com/','1229','13','0','0','0','0','0','691','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10398','йʳƷƼ','http://www.cifst.org.cn','1229','14','0','0','0','0','0','255','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10407','йʳƷϢ','http://www.chinafoods.cn/','1229','15','0','0','0','0','0','1563','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10410','й̲','http://www.tobaccochina.com','1230','1','0','0','0','0','0','1605','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10411','йʳ','http://www.gsec.com.cn','1230','9','0','0','0','0','0','2170','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10413','̲й','http://www.16888.com.cn','1230','2','0','0','0','0','0','902','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10415','̲','http://www.eastobacco.com','1230','3','0','0','0','0','0','440','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10418','й','http://www.chinadrinks.net','1230','10','0','0','0','0','0','2994','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10422','й̲Ѷ','http://www.echinatobacco.com','1230','4','0','0','0','0','0','679','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10423','й̲ݿƽ','http://www.tobaccoinfo.com.cn','1230','5','0','0','0','0','0','362','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38585','ֻ','http://www.3g37.com/','700','10','0','0','0','0','0','7340','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10434','ǾƿѶ','http://www.tjkx.com/','1230','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10446','л','http://www.cngrain.com','1231','1','0','0','0','0','0','530','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10447','йʳϢ','http://www.grain.gov.cn','1231','2','0','0','0','0','0','415','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10448','ʳ','http://www.chinagrain.gov.cn','1231','8','0','0','0','0','0','143','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10450','й','http://www.fao.com.cn','1231','3','0','0','0','0','0','1949','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10451','йг','http://www.ex-starch.com','1231','9','0','0','0','0','0','750','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10452','йʳƷϢ','http://www.cof.net.cn','1231','4','0','0','0','0','0','2224','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10454','г','http://www.grainnews.com.cn','1231','16','0','0','0','0','0','2195','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10455','йʳ','http://www.cereal.com.cn','1231','5','0','0','0','0','0','958','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10456','й','http://www.dadou.cn','1231','10','0','0','0','0','0','548','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10457','NULL','http://www.lylyxxw.comԴ','1231','14','0','0','0','0','0','1170','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10459','Ѷ','http://www.oil-114.com','1231','13','0','0','0','0','0','744','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10461','й','http://www.maize.com.cn','1231','11','0','0','0','0','0','1123','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34743','йˮӦ','http://www.cn-fruits.cn/','1233','4','0','0','0','0','0','577','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10473','','http://www.fzgrain.com','1231','20','0','0','0','0','0','267','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10476','й׷²Ҷ','http://www.aa59.com/','1232','6','0','0','0','0','0','245','0','','lsz','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('10477','вĻ','http://www.teaw.com','1232','2','0','0','0','0','0','679','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10481','й','http://tea.zjol.com.cn','1232','1','0','0','0','0','0','500','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10483','в','http://www.teanet.com.cn','1232','4','0','0','0','0','0','559','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10497','йˮ','http://www.cnfruit.com','1233','1','0','0','0','0','0','2319','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10498','йƷ','http://www.china-fruit.com.cn','1233','2','0','0','0','0','0','679','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10499','л','http://www.chinadsh.com','1233','3','0','0','0','0','0','290','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10505','йҵϢ','http://www.chinadairy.net','1234','4','0','0','0','0','0','2552','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10509','йҵ','http://www.chinadairyindustry.org.cn','1234','6','0','0','0','0','0','2846','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10510','йϹҵЭ','http://www.chinabeverage.org/','1234','2','0','0','0','0','0','430','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10511','NULL','http://www.foodqs.com/drink/йʳƷҵ-','1234','3','0','0','0','0','0','27','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38403','Ӿй','http://www.chinavisual.com/','2102','3','0','0','0','0','0','13961','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10516','ǿ','http://www.hqew.com','1237','5','0','0','0','0','9','4772','0','','lzb','0','1','0','0','','0');
INSERT INTO ylmf_site VALUES('10517','Դ','http://www.dianyuan.com','1237','4','0','0','0','0','1','3810','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10518','й','http://www.gongkong.com','1237','9','0','0','0','0','0','5708','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10519','21ICй','http://www.21ic.com','1237','18','0','0','0','0','0','2143','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10520','лҺ','http://cn.fpdisplay.com','1237','8','0','0','0','0','0','3746','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10523','Ӳѯ','http://www.b2bic.com','1237','23','0','0','0','0','0','5786','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34619','̳','http://bbs.footballworld.cn/','2077','1','0','0','0','0','0','804','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31495','йվ','http://www.hkbea.com.cn/','1688','6','0','0','0','0','0','487','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10526','йҵ','http://www.cnelc.com','1237','7','0','0','0','0','0','3532','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10527','йʦ','http://www.dq.shejis.com/','1237','6','0','0','0','0','0','5200','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10537','LED','http://www.ledgb.com/','1237','33','0','0','0','0','0','6410','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31510','йϽ','http://www.cnpension.net/','860','9','0','0','0','0','0','4293','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10544','ʵ','http://www.ebnchina.com','1237','14','0','0','0','0','0','1088','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40461','QQռվ','http://www.qqpk.cn/','2044','11','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10559','йά','http://www.weixiuwang.com','1237','5','0','0','0','0','0','9146','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10560','ּҵ','http://elec.it168.com','1238','14','0','0','0','0','0','3212','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10561','۴ϼҵ','http://www.homea.hc360.com','1238','13','0','0','0','0','0','1024','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10563','йҵ','http://www.eaonline.com.cn','1238','7','0','0','0','0','0','3661','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10565','йҵӮ','http://www.gdeha.com','1238','22','0','0','0','0','0','1228','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10568','ѵ','http://www.twicechina.com/','1237','11','0','0','0','0','0','1113','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10570','ҵҰ','http://www.jddsy.com','1238','10','0','0','0','0','0','3002','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38573','ֶ','http://www.3736.com','1977','9','0','0','0','0','0','8263','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10580','йɹ','http://www.chinawuliu.com.cn','1240','2','0','0','0','0','0','30','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10583','йб','http://www.clb.org.cn/','1240','3','0','0','0','0','0','1350','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10588','й','http://www.un56.com','1240','6','0','0','0','0','0','1160','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10593','йƷ','http://www.56products.com','1240','10','0','0','0','0','0','464','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10603','йͨЭ','http://www.cctanet.org.cn','1240','15','0','0','0','0','0','860','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10605','ѧ','http://www.lei.org.cn','1240','20','0','0','0','0','0','253','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10610','Դ','http://www.carnoc.com','1241','13','0','0','0','0','0','130','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10612','㽭ͨ','http://www.zjt.gov.cn','2195','24','0','0','0','0','0','2796','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10617','йͨ','http://www.iicc.ac.cn','1241','2','0','0','0','0','0','4885','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10618','ͨ','http://www.hljjt.gov.cn','2195','20','0','0','0','0','0','102','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10619','йʺ','http://www.shippingchina.com','1241','5','0','0','0','0','0','5','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10620','սͨ','http://www.ahjt.gov.cn','2195','25','0','0','0','0','0','73','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10621','ɽͨ','http://www.sxjt.gov.cn','2195','18','0','0','0','0','0','680','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10623','ŻվѶ','http://www.xmhcz.com','2195','31','0','0','0','0','0','231','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10627','ͨϢ','http://www.traffic.gov.cn','2195','30','0','0','0','0','0','388','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10630','սͨѧоԺ','http://www.ti.js.cn','2195','23','0','0','0','0','0','789','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10633','ɳϢ','http://www.csyg.net','2195','29','0','0','0','0','0','293','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10636','','http://www.jctrans.com','1240','9','0','0','0','0','0','352','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10638','','http://www.sol.com.cn','1241','15','0','0','0','0','0','661','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10639','ȫϢ','http://www.56888.net','1240','1','0','0','0','0','0','13613','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10641','йó','http://www.snet.com.cn','1241','10','0','0','0','0','0','828','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10643','л','http://www.chineseshipping.com.cn','1241','6','0','0','0','0','0','842','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10650','л','http://www.peihuo.com','1241','8','0','0','0','0','0','1906','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10654','Ϣ','http://www.csi.com.cn','1241','12','0','0','0','0','0','513','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10661','й','http://www.greatchina56.com/','1240','7','0','0','0','0','0','1371','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40175','','http://www.cre.cn/','1243','14','0','0','0','0','0','4','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40176','','http://www.hoau.net/','1243','15','0','0','0','0','0','21','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35690','йѧоԺ','http://www.epri.ac.cn/','1205','28','0','0','0','0','0','109','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35689','йԴϢ','http://www.nengyuan.net/','1203','20','0','0','0','0','0','1096','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10682','Ʊ','http://huoche.com/','1244','3','0','0','0','0','0','475','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10684','سƺѯ','http://tool.114la.com/live/chepai','1244','9','0','0','0','0','0','195','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34721','ຣʡͨ','http://www.qhjtt.gov.cn/','2022','27','0','0','0','0','0','131','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31967','ֻ','http://www.139shop.com/','766','11','0','0','0','0','0','11044','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33327','¡','http://www.fc-koeln.de/','1033','7','0','0','0','0','0','21','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33325','οƼ','http://www.gigabyte.com.cn/','1123','15','0','0','0','0','0','1010','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35057','','http://bbs.duba.net/','1142','1','0','0','0','0','0','455','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10701','й豸','http://www.goepe.com','1247','22','0','0','0','0','0','1783','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10703','йӰ','http://www.china-eia.com','1247','8','0','0','0','0','0','668','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10704','й̬','http://www.eedu.org.cn','1247','2','0','0','0','0','0','1758','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10705','пԺ̬о','http://www.rcees.ac.cn','1247','25','0','0','0','0','0','491','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10706','й','http://www.cenews.com.cn','1247','17','0','0','0','0','0','689','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10707','й','http://www.chinaenvironment.com','1247','26','0','0','0','0','0','1079','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10710','йԴ','http://www.ce65.com','1247','6','0','0','0','0','0','651','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10714','йѧѧ','http://www.chinacses.org','1247','5','0','0','0','0','0','295','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10717','л','http://www.cepf.org.cn','1247','15','0','0','0','0','0','174','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10719','й','http://www.ep168.com','1247','21','0','0','0','0','0','623','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39497','԰ѧϰ','http://www.ylstudy.com/','1250','10','0','0','0','0','0','547','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10725','й','http://www.epnet.cn/','1247','4','0','0','0','0','0','1170','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10730','йˮ','http://www.h2o-china.com','1248','1','0','0','0','0','0','320','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10731','ˮϢ','http://www.hwcc.com.cn','1248','6','0','0','0','0','0','274','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10732','йˮ','http://www.chinawater.com.cn','1248','2','0','0','0','0','0','120','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10733','NULL','http://www.hydroinfo.gov.cnйˮϢ','1248','7','0','0','0','0','0','87','0','','lsz','0','0','0','1231257600','','1');
INSERT INTO ylmf_site VALUES('10737','йˮҵ','http://www.c-water.com.cn','1248','3','0','0','0','0','0','121','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10743','йˮ','http://www.waterinfo.com.cn','1248','4','0','0','0','0','0','144','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10747','йˮѧ','http://www.ches.org.cn','1248','5','0','0','0','0','0','70','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38404','4Aư','http://www.4a98.com/','2102','5','0','0','0','0','0','8694','0','','lwh','0','0','1288800000','1288800000','','1');
INSERT INTO ylmf_site VALUES('10753','NULL','http://changjiang.whlib.ac.cnϢ','1248','8','0','0','0','0','0','52','0','','lsz','0','0','0','1231344000','','1');
INSERT INTO ylmf_site VALUES('40334','','http://www.yaoee.com','881','21','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40335','ֽվ','http://www.seedesk.cn/','711','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40518','СĦ','http://www.12anmo.cn','884','21','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32631','߽̳','http://bbs.zjjy.com','1931','8','0','0','0','0','0','226','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31731','עʦ','http://www.cicpa.org.cn/','2003','1','0','0','0','0','0','2521','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17531','ǱҵЭ','http://www.cima.org.cn/','1265','4','0','0','0','0','0','181','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17530','й-Ǳ','http://www.mei.gov.cn/industry/instrument/','1265','5','0','0','0','0','0','589','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17525','Ϣ','http://www.instrument.com.cn/','1265','2','0','0','0','0','0','467','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11523','PHP','http://www.phpfans.net','1160','6','0','0','0','0','0','434','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17522','NULL','http://www.pvindex.com.cn/л÷','1264','23','0','0','0','0','0','1859','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17521','й⹤ҵ','http://www.cnsaw.com/','1264','24','0','0','0','0','0','858','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17516','NULL','http://www.1-68.com/йҵ','1264','27','0','0','0','0','0','4715','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17514','ȫе','http://www.qqma.com/','1264','4','0','0','0','0','0','3299','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17513','ȫ','http://www.famens.com/','1264','14','0','0','0','0','0','1236','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17512','йе','http://www.lc800.com/','1264','9','0','0','0','0','0','3368','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17510','й','http://cn.made-in-china.com/','1264','1','0','0','0','0','0','7160','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17507','й˾Ϣ','http://www.ccfei.com/','1256','6','0','0','0','0','0','2321','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35389','ְƸվȫ','http://www.job22.com/url/guangxijob.htm','1551','7','0','0','0','0','0','1237','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17504','NULL','http://220.231.63.167/Ϸ֯','1256','34','0','0','0','0','0','1138','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35367','ThemeXP','http://themexp.org/','712','4','0','0','0','0','0','10248','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17502','ŷ֯','http://www.sinotex.cn/','1256','32','0','0','0','0','0','928','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17501','һ֯','http://www.webtextiles.com/','1256','2','0','0','0','0','0','1636','0','','lsz','0','0','0','1231171200','','1');
INSERT INTO ylmf_site VALUES('17500','й֯','http://www.eck.com.cn/','1256','5','0','0','0','0','0','3136','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17498','з֯Ʒ̻','http://www.ccct.org.cn/','1256','8','0','0','0','0','0','466','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17496','֯','http://textile.icxo.com/','1256','31','0','0','0','0','0','915','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17493','й֯Ϣ','http://cn.cntextile.com/','1256','7','0','0','0','0','0','4406','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17491','йƤ','http://www.piju.com.cn/','1261','1','0','0','0','0','0','3870','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17490','۴Ƥ','http://www.leather.hc360.com/','1261','2','0','0','0','0','0','770','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17485','лװ-Ƥװ','http://www.51fashion.com.cn/51AreaLeather/','1261','10','0','0','0','0','0','1277','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17480','й޻ҵ','http://www.cncew.com/','1257','3','0','0','0','0','0','523','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34711','Ӧ־','http://www.edit56.com/','1658','13','0','0','0','0','0','248','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17477','й֯е','http://www.cttm.net/','1258','1','0','0','0','0','0','1532','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17476','й֯ег','http://www.ctmm.net/','1258','2','0','0','0','0','0','118','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17475','лĻ','http://www.ctma.net/','1258','5','0','0','0','0','0','277','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17471','NULL','http://www.jnemb.com/廨','1661','9','0','0','0','0','0','2124','0','','lsz','0','0','0','1231257600','','1');
INSERT INTO ylmf_site VALUES('17467','NULL','http://www.emb.com.cn/廨','1661','7','0','0','0','0','0','0','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('17465','廨','http://www.linkgd.com/','1661','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10850','й̻ľ','http://www.hnmmw.com','1250','4','0','0','0','0','0','3814','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10854','й̻','http://www.chinagreen.net.cn/','1250','1','0','0','0','0','0','4774','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10865','ҵҳ','http://yp.sina.net','1253','14','0','0','0','0','0','2010','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10867','ȫҳ','http://www.21page.net','1253','1','0','0','0','0','0','2090','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40625','ɿ','http://www.feedcool.cn','2262','16','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10869','йŻҳ','http://www.locoso.com/','1253','8','0','0','0','0','0','2111','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32650','NULL','http://www.dpdbbs.com/մֻ̳','690','11','0','0','0','0','0','14631','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36620','̳','http://forum.byr.edu.cn/','2078','14','0','0','0','0','0','353','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32649','ֻ̳','http://bbs.52samsung.com/index.php','690','9','0','0','0','0','0','1012','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10876','йҵҳ','http://www.page.net.cn','1253','4','0','0','0','0','1','2523','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40602','','http://www.51lunwen.com','1043','5','0','0','0','0','0','14','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40600','','http://health.27.cn/','864','5','1','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40237','л','http://www.a.com.cn/','2111','5','0','0','0','0','0','35','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10886','񷽰','http://project.ccidnet.com','1926','11','0','0','0','0','0','636','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32648','ҰLGֻ̳','http://www.52lg.com/','690','13','0','0','0','0','0','248','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16203','̸','http://www.sellgreat.com/','1926','12','0','0','0','0','0','1249','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16202','ҵ','http://www.public.net.cn/','1253','20','0','0','0','0','0','855','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16200','йҳȫ','http://www.ypall.com/','1253','2','0','0','0','0','0','6282','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16199','ȫҵ','http://www.qychina.com/','1253','10','0','0','0','0','0','1127','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40626','ǰЦ','http://lengxiaohua.net/','733','3','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32645','ŵֻ̳','http://www.nokiacn.net/','690','7','0','0','0','0','0','3827','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16196','NULL','http://www.sohu.net/Ѻ̻','1926','5','0','0','0','0','0','8869','0','','lzb','0','0','1281283200','1281283200','','1');
INSERT INTO ylmf_site VALUES('32646','ֻ̳','http://bbs.dospy.com/','690','12','0','0','0','0','1','46776','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16193','ҵҳ','http://www.3653h.com/','1253','12','0','0','0','0','0','3132','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16191','л','http://www.chinaccm.com/','1926','3','0','0','0','0','1','5093','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('16190','58ͬ','http://www.58.com/','1253','11','0','0','0','0','1','141','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10920','йɴ','http://www.zgsxw.com','1256','16','0','0','0','0','0','3011','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10921','ѯ','http://www.ccf.com.cn','1256','4','0','0','0','0','0','1768','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10922','лҷ','http://www.hometex114.com','1256','17','0','0','0','0','0','1134','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10924','йҷ','http://www.hometexnet.com','1256','19','0','0','0','0','0','883','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10926','й֯','http://www.texnet.com.cn/','1256','3','0','0','0','0','0','6395','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10927','ĳ','http://www.qfc.cn','1256','18','0','0','0','0','0','1577','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10929','ȫ֯','http://www.tnc.com.cn/','1256','21','0','0','0','0','0','1335','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35366','յפʹ','http://www.sudanembassychina.com/','2081','16','0','0','0','0','0','49','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10933','й֯ѧоԺ','http://www.cta.com.cn','1256','10','0','0','0','0','0','325','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10934','л֯','http://www.cntexnet.com','1256','1','0','0','0','0','0','6976','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35365','Ĵפʹ','http://www.china.embassy.gov.au/','2081','17','0','0','0','0','0','153','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10950','й޻','http://www.cncotton.com','1257','1','0','0','0','0','0','624','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10951','й޻Ϣ','http://www.cottonchina.org','1257','2','0','0','0','0','0','730','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10952','й޻Э','http://www.china-cotton.org','1257','7','0','0','0','0','0','521','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10953','й޷֯Ϣ','http://www.tteb.com','1257','4','0','0','0','0','0','1268','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10962','йĻ','http://www.ttmn.com','1258','4','0','0','0','0','0','903','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10964','йĻ','http://www.chinatex.info/','1258','3','0','0','0','0','0','1308','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32684','̳','http://bbs.shudoo.com/','1930','6','0','0','0','0','0','3932','0','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10981','й˿г','http://www.esilk.net','1260','2','0','0','0','0','0','1250','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10982','й','http://www.silkcapital.com','1260','1','0','0','0','0','0','1359','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10983','˿Źɷ','http://www.shsilktech.com','1260','100','0','0','0','0','0','378','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10987','йϳƤ','http://www.synthleather.com','1261','9','0','0','0','0','0','904','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10989','йƤｻ','http://www.sinoleather.com','1261','5','0','0','0','0','0','2118','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10994','Ƥ','http://www.world-leather.net','1261','4','0','0','0','0','0','1451','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('10997','йƤѶ','http://www.china-leather.com','1261','6','0','0','0','0','0','2174','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('39862','źļ','http://www.zhanghanyuncn.com.cn/','827','9','0','0','0','0','0','2','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11002','йӡȾҵЭ','http://www.cdpa.org.cn','1262','3','0','0','0','0','0','731','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11003','йӡȾѶ','http://www.sinodf.com','1262','2','0','0','0','0','0','850','0','','lsz','0','0','0','0','','1');
INSERT INTO ylmf_site VALUES('11004','ӡȾ','http://www.cndye.net','1262','4','0','0','0','0','0','711','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11005','йӡȾ','http://www.china-dyeing.com','1262','1','0','0','0','0','0','2466','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31492','й()','http://www.asia.ccb.com/','1688','5','0','0','0','0','0','583','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11007','йе','http://www.jx.cn','1264','3','0','0','0','0','0','12296','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38299','Ƶȫ','http://www.qunar.com/twell/redirect.jsp?url=http://hotel.qunar.com?dfly=aarla3','1713','32','0','0','0','0','0','1257','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11012','й·е','http://www.lmjx.net','1264','12','0','0','0','0','0','1396','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11014','й','http://www.chinanics.com','1237','13','0','0','0','0','0','3976','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11015','йеѧ','http://www.cmes.org','1264','8','0','0','0','0','0','1981','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11018','۴̻е','http://www.cm.hc360.com','1264','15','0','0','0','0','0','1250','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11027','Ǳ','http://www.testmart.cn','1265','6','0','0','0','0','0','626','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11028','йǱѧ','http://www.cis.org.cn','1265','1','0','0','0','0','0','821','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11030','йǱϢ','http://www.instrnet.com','1265','3','0','0','0','0','0','912','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11032','Ǳ','http://www.yibiao.com','1265','12','0','0','0','0','0','1309','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11041','йӡˢŻ','http://www.bisenet.com/','1267','2','0','0','0','0','0','390','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11043','ͼ齻','http://www.bookb2b.com','1267','7','0','0','0','0','0','981','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38168','','http://www.hljcyw.com/','1894','34','0','0','0','0','0','744','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11046','й','http://www.chuban.cc/','1267','3','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38167','NULL','http://www.dianping.com/haerbin/foodڵ','1894','33','0','0','0','0','0','532','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11048','йų','http://www.chinaxwcb.com/index/index.htm','1267','4','0','0','0','0','0','466','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11049','й','http://www.china-pub.com/','1267','5','0','0','0','0','0','305','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38165','','http://meal.northeast.cn/','1894','31','0','0','0','0','0','76','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11061','ѧ','http://www.sciencep.com','1268','12','0','0','0','0','0','302','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11062','ѧ','http://www.fudanpress.com','1268','14','0','0','0','0','0','203','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11063','ߵȽ','http://www.hep.edu.cn','1268','17','0','0','0','0','0','341','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11065','ɳ','http://www.lawpress.com.cn','1268','27','0','0','0','0','0','222','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11071','ĳ','http://www.flp.com.cn','1268','15','0','0','0','0','0','158','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11072','Ϻĳ','http://www.stph.com.cn','1268','6','0','0','0','0','0','186','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40812','й','http://china.machine35.com','1264','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11075','ʵ','http://www.ptpress.com.cn/','1268','30','0','0','0','0','0','249','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11082','ҳ','http://www.zuojiachubanshe.com','1268','7','0','0','0','0','0','9252','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11083','','http://www.daxiang.cn','1268','32','0','0','0','0','0','239','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35060','ӡ','http://www.cp.com.cn/','1268','2','0','0','0','0','0','642','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11090','ܳ','http://www.jdcbs.com.cn','1268','33','0','0','0','0','0','430','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11091','ѧ','http://www.scholastic.com','1269','11','0','0','0','0','0','117','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11092','','http://www.randomhouse.com','1269','12','0','0','0','0','0','233','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11093','Լøӹ˾','http://www.wiley.com','1269','23','0','0','0','0','0','84','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11094','Ǵ','http://www.kadokawa.co.jp','1269','13','0','0','0','0','0','168','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11096','ķɭ˾','http://www.thomson.com','1269','15','0','0','0','0','0','105','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11098','ţѧ','http://www.oup.co.uk','1269','4','0','0','0','0','0','182','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11099','ѷ湫˾','http://www.hwwilson.com','1269','16','0','0','0','0','0','67','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11101','-ϣ˾','http://www.mcgraw-hill.com','1269','19','0','0','0','0','0','75','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11105','Ƥɭ','http://www.pearson.com','1269','5','0','0','0','0','0','98','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11106','ֶ湫˾','http://www.gowerpub.com','1269','2','0','0','0','0','0','119','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11107','漯','http://www.penguin.com','1269','18','0','0','0','0','0','179','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11108','˹ع˾','http://www.hearst.com','1269','9','0','0','0','0','0','42','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11109','١׷ֳ湫˾','http://www.hmco.com','1269','21','0','0','0','0','0','75','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38541','','http://newun.zhongsou.com/','1270','14','0','0','0','0','0','145','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11111','йվ','http://www.chinaadren.com','2111','1','0','0','0','0','0','443','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40597','ҩȫ','http://www.yongyao.net','872','100','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40596','NULL','http://www.moshu5.com/ħ','2237','100','0','0','0','0','0','0','0','','lzb','0','0','1281283200','1281283200','','1');
INSERT INTO ylmf_site VALUES('40595','䱦','http://www.mumbaby.cn/','884','22','0','0','0','0','0','1','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11116','ֻý','http://www.wowa.cn','2111','7','0','0','0','0','0','169','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11119','йý','http://www.ad163.com','2111','2','0','0','0','0','0','345','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11121','лý','http://www.mediachina.net','2111','3','0','0','0','0','0','270','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11122','NULL','http://www.mediapeoper.comйý','2111','6','0','0','0','0','0','295','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11140','ҵͶ','http://www.28.com','2111','8','0','0','0','0','0','13601','0','#FF0000','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('38540','滢','http://union.qihoo.com/','1270','13','0','0','0','0','0','217','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32267','й','http://www.lottery.gov.cn/','814','2','0','0','0','0','0','5','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('34106','йЭ','http://www.volleyball.org.cn/','943','3','0','0','0','0','0','1303','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('31586','NULL','http://www.cmpi.com.cn/йҵ','1636','3','0','0','0','0','0','4481','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11160','ȫ','http://www.wjw.cn','1275','1','0','0','0','0','0','2018','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11161','','http://www.hnwj.net','1275','10','0','0','0','0','0','1532','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11162','й','http://china.globalhardwares.com','1275','3','0','0','0','0','0','2633','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11165','Դ','http://www.asia-hardware.com','1275','2','0','0','0','0','0','798','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11166','NULL','http://www.hardwarefair.cnй','1275','7','0','0','0','0','0','1070','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11167','۴','http://www.wujin.hc360.com','1275','8','0','0','0','0','0','637','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11169','йģ','http://www.mould.net.cn','1276','2','0','0','0','0','0','2684','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11170','йģ˲','http://www.mouldjob.com','1276','8','0','0','0','0','0','1066','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11171','ģ','http://www.molds.cn','1276','10','0','0','0','0','0','1076','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11177','йװ','http://www.pack.net.cn','1278','1','0','0','0','0','0','4781','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11178','йֽҵ','http://www.chinapaper.net','1278','4','0','0','0','0','0','4372','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11179','йֽ','http://www.paper.com.cn','1278','5','0','0','0','0','0','1915','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11183','йװ','http://www.chndesign.com','1278','13','0','0','0','0','0','1380','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11185','۴ӡˢ','http://www.printing.hc360.com','1267','6','0','0','0','0','0','1503','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11186','лӡˢװ','http://www.cpp114.com','1278','2','0','0','0','0','0','3590','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11190','۴ֽҵ','http://www.paper.hc360.com','1278','7','0','0','0','0','0','1033','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11195','ӡˢװ','http://www.adprint.com.cn','1278','18','0','0','0','0','0','993','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11196','йװ','http://www.cpackage.com','1278','14','0','0','0','0','0','843','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11204','»','http://www.xinhuabookstore.com','1267','6','0','0','0','0','0','1134','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11206','йͼ','http://www.bkpcn.com/','1267','1','0','0','0','0','0','1956','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30578','й̳','http://bbs.cnad.com/','1979','16','0','0','0','0','0','512','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30574','̳','http://bbs.blueidea.com/','1979','17','0','0','0','0','0','902','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('30576','Pro/E̳','http://www.proesky.com','1979','18','0','0','0','0','0','403','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33936','¹ͳ[]','http://www.bundespraesident.de/','1833','5','0','0','0','0','0','27','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11262','ľ罻̳','http://bbs.ylmf.net','675','25','0','0','0','0','0','51478','0','green','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11263','778','http://www.qiqi8.cn','1043','1','0','0','0','0','0','14891','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41088','¾','http://www.xinjunshi.com/','726','18','0','0','0','0','7','90','0','','lzb','1','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32162','TOMŮ','http://lady.tom.com/','664','127','0','0','0','0','4','65750','0','','xiaoku','0','0','1290614400','1290614400','','1');
INSERT INTO ylmf_site VALUES('40174','FedEx()','http://www.fedex.com/Tracking?cntry_code=cn','1243','13','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35440','˲','http://www.haijob.com/','1539','9','0','0','0','0','0','564','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11305','NULL','http://down.gw.com.cn/ǻ۹Ʊ','850','100','0','0','0','0','0','59217','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11306','ͬ˳Ʊ','http://www.10jqka.com.cn/download/','850','2','0','0','0','0','0','36056','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33319','ϲ','http://www.hedy.com.cn/','1123','8','0','0','0','0','0','641','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11311','Ͱ','http://china.alibaba.com/?cosite=114dh&location=alihomepage_mzdh','852','4','0','0','0','0','0','38657','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11315','人ŮӸҽԺ','http://www.whdsnz.com/','871','100','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11330','ħèֻ','http://soft.mofamao.com/','700','8','0','0','0','0','0','23619','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('41075','Ϲͯ','http://www.unicef.org/chinese/','1006','5','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11333','Tompdaֻ','http://soft.tompda.com/','700','9','0','0','0','0','0','14660','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11336','ɿ','http://www.feiku.com/','700','5','0','0','0','0','0','7093','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32182','йϷ','http://www.chinagames.net/','699','15','0','0','0','0','0','37933','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11397','йɶ˲г','http://www.rc114.com/','1520','5','0','0','0','0','0','333','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11400','ϳ˲','http://www.ncrc.gov.cn/','1520','10','0','0','0','0','0','868','0','','xiaoku','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11404','츮˲','http://www.job20.com/','1520','14','0','0','0','0','0','1667','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35392','лӢ','http://searchjob.chinahr.com/SearchResult.aspx?occParentIDList=255&indIDList=255&myLocIDList=5000&prj=bdkeyword&jtr=823464246&jtrr=','1542','2','0','0','0','0','0','183','0','','luoj','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11450','17173ϷƵ','http://media.17173.com/','1285','116','0','0','0','0','1','60592','0','','ljm','0','0','1282147200','1282147200','','1');
INSERT INTO ylmf_site VALUES('35110','è-ʱϵ','http://fashion.mop.com/','735','7','0','0','0','0','0','12313','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11540','ݹ㲥Ӵѧ','http://www.ougz.com.cn/','1295','43','0','0','0','0','0','212','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11541','㶫㲥Ӵѧ','http://www.zqtvu.com.cn/','1295','48','0','0','0','0','0','67','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11542','㶫ع㲥Ӵѧ','http://www.cadsdx.com/','1295','49','0','0','0','0','0','74','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11543','㶫ʡҵְѧ','http://www.gfgd.net/','1295','35','0','0','0','0','0','180','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11544','㶫ӦѧԺ','http://www.jyu.edu.cn/','1295','28','0','0','0','0','0','531','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('32175','лϷ','http://game.china.com/zh_cn/','699','7','0','0','0','0','1','47205','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11553','ŰƷļ','http://book.sina.com.cn/nzt/zhangailing/','648','102','0','0','0','0','0','44688','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('11556','ڽѧ','http://www.banbijiang.com/','648','3','0','0','0','0','0','24519','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11558','Ʒ','http://www.40zw.cn/LiuCanYang.html','648','13','0','0','0','0','0','48019','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11561','ӹƷ','http://www.40zw.cn/JinYong.html','648','8','0','0','0','0','0','86810','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11563','Ʒ','http://www.40zw.cn/WoLongSheng.html','648','11','0','0','0','0','0','46176','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11564','Ʒ','http://www.xiaoshuo.com/jsp/volumeview.jsp?vlmid=100:90003713','648','119','0','0','0','0','0','37229','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('11565','Ʒ','http://40zw.cn/LiangYuSheng.html','648','12','0','0','0','0','0','55950','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11566','߿Ʒ','http://40zw.cn/NiKuang.html','648','15','0','0','0','0','0','25069','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11567','Ʒ','http://40zw.cn/ChiungYao.html','648','17','0','0','0','0','0','92416','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('40734','ҳMetaϢ','http://tool.114la.com/site/meta','2109','7','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11569','Ʒ','http://40zw.cn/AnQi.html','648','19','0','0','0','0','0','76559','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11570','Ʒ','http://www.40zw.cn/ZuoQingWen.html','648','130','0','0','0','0','0','51379','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('11571','Ʒ','http://www.40zw.cn/GuLing.html','648','16','0','0','0','0','0','73464','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11572','Ʒ','http://www.40zw.cn/JiQiu.html','648','131','0','0','0','0','0','42613','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('11573','Ʒ','http://www.40zw.cn/JinXuan.html','648','132','0','0','0','0','0','56183','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('11574','Ʒ','http://www.40zw.cn/DianXin.html','648','20','0','0','0','0','0','61179','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11575','Ʒ','http://40zw.cn/YuQing.html','648','134','0','0','0','0','0','61247','0','','lzb','0','0','1282579200','1282579200','','1');
INSERT INTO ylmf_site VALUES('34336','Ѻ','http://book.sohu.com/','649','2','0','0','0','0','0','79805','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11580','ԭѧ','http://www.goodmood.cn/','648','6','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11581','Ʒ','http://www.40zw.cn/LiLiang.html','648','14','0','0','0','0','0','27021','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11584','','http://www.ifeng.com/','749','1','0','1','0','0','0','1282838','7','','ylmf','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11585','','http://www.gov.cn/','2178','1','1','0','0','0','0','195975','20','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11586','5Qش[]','http://bt9.5qzone.net/','1113','4','0','1','0','0','0','109641','33','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11587','ѷ','http://www.soufun.com/','881','1','0','1','2','2','135','81028','19','','lzb','1','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11589','NBA','http://nba.tom.com/','2272','1','0','1','0','0','0','203971','34','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11591','51ѿռ','http://www.51.com','669','5','0','1','0','0','64','203043','37','','lwh','4','1','0','0','','0');
INSERT INTO ylmf_site VALUES('40728','ȸͳ','http://www.google.com/analytics/home/provision','2114','7','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11604','ոУ','http://www.myler.cn/xiaoyuan_gaoxiao/950.htm#1292','950','4','0','0','0','0','0','6867','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11605','㽭У','http://www.myler.cn/xiaoyuan_gaoxiao/950.htm#1293','950','3','0','0','0','0','0','6076','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11606','У','http://www.myler.cn/xiaoyuan_gaoxiao/950.htm#1294','950','6','0','0','0','0','0','4017','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11607','㶫У','http://www.myler.cn/xiaoyuan_gaoxiao/950.htm#1295','950','7','0','0','0','0','0','8157','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11687','廪ѧ','http://www.tsinghua.edu.cn/','1289','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11767','ҽƴѧ','http://www.tijmu.edu.cn/','1290','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11689','ѧ','http://www.pku.edu.cn/','1289','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11766','ѧ','http://www.tju.edu.cn/','1290','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11691','йѧ','http://www.ruc.edu.cn/','1289','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11692','ʵѧ','http://www.bupt.edu.cn/','1289','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11693','պѧ','http://www.buaa.edu.cn/','1289','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11694','Ƽѧ','http://www.ustb.edu.cn/','1289','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11695','ѧ','http://www.buct.edu.cn/','1289','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11696','׶óѧ','http://www.cueb.edu.cn/','1289','8','0','0','0','0','0','651','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11697','ѧ','http://www.bit.edu.cn/','1289','9','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11698','ͨѧ','http://www.njtu.edu.cn/','1289','10','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11699','ҵѧ','http://bjut.edu.cn/','1289','11','0','0','0','0','0','280','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11700','ҵѧ','http://www.ncut.edu.cn/','1289','12','0','0','0','0','0','304','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11701','ʦѧ','http://www.bnu.edu.cn/','1289','13','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11702','׶ʦѧ','http://www.cnu.edu.cn/','1289','14','0','0','0','0','0','447','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11703','ѧ','http://www.bfsu.edu.cn/','1289','15','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11704','⾭óѧ','http://www.uibe.edu.cn/','1289','16','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11705','Դѧ','http://www.blcu.edu.cn/','1289','17','0','0','0','0','0','766','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11706','йũҵѧ','http://www.cau.edu.cn/','1289','18','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11707','ӰѧԺ','http://www.bfa.edu.cn/','1289','19','0','0','0','0','0','511','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11708','йʯʹѧ()','http://web.cup.edu.cn/','1289','20','0','0','0','0','0','407','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11709','ѧҽѧ','http://www.bjmu.edu.cn/','1289','21','0','0','0','0','0','144','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11710','йЭҽƴѧ','http://www.pumc.edu.cn/','1289','22','0','0','0','0','0','211','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11711','׶ҽƴѧ','http://www.cpums.edu.cn/','1289','23','0','0','0','0','0','288','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11713','йʴѧ','http://www.cugb.edu.cn/','1289','25','0','0','0','0','0','265','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11714','⽻ѧԺ','http://www.fac.edu.cn/','1289','26','0','0','0','0','0','377','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11715','йѧԺ','http://cms.cyu.edu.cn/','1289','27','0','0','0','0','0','543','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11716','ƾѧ','http://www.cufe.edu.cn/','1289','28','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11717','йýѧ','http://www.cuc.edu.cn/','1289','29','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11718','ѧԺ','http://www.ccom.edu.cn/','1289','30','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11719','ѧ','http://www.bsu.edu.cn/','1289','31','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11720','йҵѧ','http://www.cumtb.edu.cn/','1289','32','0','0','0','0','0','221','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11722','й񹫰ѧ','http://www.cppsu.edu.cn/','1289','33','0','0','0','0','0','40','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11723','ӡˢѧԺ','http://www.bigc.edu.cn/','1289','34','0','0','0','0','0','163','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11725','ҵѧ','http://www.bjfu.edu.cn/','1289','35','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11726','ѧ','http://www.cun.edu.cn/','1289','36','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11727','йѧ','http://www.cupl.edu.cn/','1289','37','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11728','ѧ','http://www.ncepu.edu.cn/','1289','38','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11729','ڶѧԺ','http://www.bisu.edu.cn/','1289','39','0','0','0','0','0','610','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11730','ϢƼѧ','http://www.bistu.edu.cn/','1289','40','0','0','0','0','0','423','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11731','ѧԺ','http://www.bucea.edu.cn/','1289','41','0','0','0','0','0','265','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11732','ƼְҵѧԺ','http://www.5aaa.com/','1289','42','0','0','0','0','0','291','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11733','йѧԺ','http://www.ccmusic.edu.cn/','1289','43','0','0','0','0','0','219','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11734','㲥Ӵѧ','http://www.crtvu.edu.cn/','1289','44','0','0','0','0','0','226','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11735','ϴѧ','http://www.buu.edu.cn/home/','1289','45','0','0','0','0','0','339','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11765','Ͽѧ','http://www.nankai.edu.cn/','1290','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11737','ʯͻѧԺ','http://www.bipt.edu.cn/','1289','46','0','0','0','0','0','230','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11738','ӿƼѧԺ','http://www.besti.edu.cn/','1289','47','0','0','0','0','0','383','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11739','ѧԺ','http://www.bjie.ac.cn/','1289','48','0','0','0','0','0','117','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11740','װѧԺ','http://www.bift.edu.cn/','1289','49','0','0','0','0','0','436','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11741','ϷѧԺ','http://www.chntheatre.edu.cn/','1289','50','0','0','0','0','0','13','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11742','NULL','http://www.bitc.edu.cn/','1289','51','0','0','0','0','0','2','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11743','׸ֹѧԺ','http://www.sgit.edu.cn/','1289','52','0','0','0','0','0','131','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11744','ϴѧӦѧԺ','http://www.ygi.edu.cn/','1289','53','0','0','0','0','0','105','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11746','ũѧԺ','http://www.bac.edu.cn/','1289','55','0','0','0','0','0','210','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11747','ũҵְҵѧԺ','http://www.bvca.edu.cn/','1289','56','0','0','0','0','0','81','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11748','ְͨҵѧԺ','http://www.jtxy.com.cn/','1289','57','0','0','0','0','0','96','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11749','NULL','http://www.zfy.edu.cn/','1289','58','0','0','0','0','0','269','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11750','ѧԺ','http://www.bwu.edu.cn/','1289','59','0','0','0','0','0','224','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11751','ѧ','http://www.bdfu.edu.cn/','1289','60','0','0','0','0','0','209','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11752','ѧԺ','http://www.bcu.edu.cn/','1289','61','0','0','0','0','0','408','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11753','йѧԺоԺ','http://www.gscas.ac.cn/','1289','62','0','0','0','0','0','50','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11754','׶ѧԺ','http://www.cipe.net.cn/','1289','63','0','0','0','0','0','94','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11755','йͶϵѧԺ','http://www.ciir.edu.cn/','1289','64','0','0','0','0','0','322','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11756','ѧԺ','http://www.pfc.edu.cn/','1289','65','0','0','0','0','0','108','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11757','óְҵѧԺ','http://www.bjczy.edu.cn/','1289','66','0','0','0','0','0','137','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11758','ӿƼְҵѧԺ','http://www.dky.edu.cn/','1289','67','0','0','0','0','0','135','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11759','лŮѧԺ','http://www.cwu.edu.cn/','1289','68','0','0','0','0','0','539','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11760','ѧ','http://www.bgeelyu.com/','1289','69','0','0','0','0','0','571','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11761','ҵְҵѧԺ','http://www.bgy.org.cn/','1289','70','0','0','0','0','0','148','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11762','̴ѧ','http://www.btbu.edu.cn/','1289','71','0','0','0','0','0','509','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11764','ʻ','http://www.hzxiangcao.com/','2061','5','0','0','0','0','0','910','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11768','ѧ','http://www.tjut.edu.cn/','1290','4','0','0','0','0','0','750','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11769','Ƽѧ','http://www.tuli.edu.cn/','1290','5','0','0','0','0','0','639','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11770','ְҵѧ','http://www.tjtc.edu.cn/','1290','19','0','0','0','0','0','220','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11771','ְҵѧԺ','http://www.tjbpi.com/','1290','25','0','0','0','0','0','205','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11772','ҵѧ','http://www.tjcu.edu.cn/','1290','21','0','0','0','0','0','433','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11773','ũѧԺ','http://www.tjac.edu.cn/','1290','8','0','0','0','0','0','205','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11774','ҽҩѧ','http://www.tjutcm.edu.cn/','1290','7','0','0','0','0','0','183','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11775','ѧԺ','http://www.tjcm.edu.cn/','1290','11','0','0','0','0','0','189','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11776','ѧԺ','http://www.tjipe.edu.cn/','1290','9','0','0','0','0','0','184','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11777','й񺽴ѧ','http://www.cauc.edu.cn/','1290','16','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11778','㲥Ӵѧ','http://www.tjrtvu.edu.cn/','1290','22','0','0','0','0','0','98','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11780','򲳺ְҵѧԺ','http://www.tjbhzy.net.cn/','1290','23','0','0','0','0','0','168','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11781','ְҵѧԺ','http://www.suoyuan.com.cn/','1290','24','0','0','0','0','0','133','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11782','ƾѧ','http://www.tjufe.edu.cn/','1290','14','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11783','򹤳ʦѧԺ','http://www.tute.edu.cn/','1290','17','0','0','0','0','0','336','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11784','ʦѧ','http://www.tjnu.edu.cn/','1290','13','0','0','0','0','0','680','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11786','ְҵѧԺ','http://tjgsc.baidajob.com/webbuild-model/model-b/default.asp','1290','18','0','0','0','0','0','106','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11787','нѧԺ','http://www.tjuci.edu.cn/','1290','20','0','0','0','0','0','392','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11788','ѧԺ','http://www.tjarts.edu.cn/','1290','12','0','0','0','0','0','163','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11790','ƾѧԺ','http://www.tjufe.edu.cn/','1290','6','0','0','0','0','0','1009','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11791','ѧԺ','http://www.tjfsu.edu.cn/','1290','10','0','0','0','0','0','589','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11792','ѧ','http://www.fudan.edu.cn/','1291','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11793','Ϻͨѧ','http://www.sjtu.edu.cn/','1291','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11794','ͬôѧ','http://www.tongji.edu.cn/','1291','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11795','ʦѧ','http://www.ecnu.edu.cn/','1291','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11796','Ϻƾѧ','http://www.shufe.edu.cn/','1291','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11798','ѧ','http://www.ecust.edu.cn/','1291','7','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11799','Ϻѧ','http://www.shisu.edu.cn/','1291','8','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11800','ڶҽѧ','http://www.smmu.edu.cn/','1291','9','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11801','Ϻˮѧ','http://www.shfu.edu.cn/','1291','10','0','0','0','0','0','603','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11802','ϺͨѧҽѧԺ','http://www.shsmu.edu.cn/','1291','11','0','0','0','0','0','131','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11803','ϺóѧԺ','http://www.shift.edu.cn/','1291','12','0','0','0','0','0','522','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11804','ϺѧԺ','http://www.shupl.edu.cn/','1291','13','0','0','0','0','0','374','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11805','ѧҽҩ','http://www.shmu.edu.cn/','1291','14','0','0','0','0','0','72','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11806','ϺӦüѧԺ','http://www.shict.edu.cn/','1291','15','0','0','0','0','0','586','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11807','ѧ','http://www.dhu.edu.cn/','1291','16','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11808','Ϻѧ','http://www.shu.edu.cn/','1291','17','0','0','0','0','0','27','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11809','ͬôѧУ','http://hx.tongji.edu.cn/','1291','18','0','0','0','0','0','97','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11810','Ϻѧ','http://www.usst.edu.cn/','1291','19','0','0','0','0','0','582','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11811','ϺѧԺ','http://www.sbs.edu.cn/','1291','20','0','0','0','0','0','585','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11812','ϺְҵѧԺ','http://www.shjf.com/','1291','21','0','0','0','0','0','112','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11813','ϺְҵѧԺ','http://www.cnshmaritime.com/','1291','22','0','0','0','0','0','180','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11814','ϺѧԺ','http://www.shbangde.com/','1291','23','0','0','0','0','0','143','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11815','ϺùְҵѧԺ','http://www.shjiguangcollege.com/','1291','24','0','0','0','0','0','113','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11816','ϺѧְҵѧԺ','http://www.scst.sh.cn/','1291','25','0','0','0','0','0','123','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11817','ϺѧԺ','http://www.gench.com.cn/','1291','26','0','0','0','0','0','213','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11818','ϺѧԺ','http://www.shcmusic.edu.cn/','1291','27','0','0','0','0','0','282','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11819','Ϻڶҵѧ','http://www.shspu.edu.cn/','1291','28','0','0','0','0','0','222','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11820','ϺӴѧ','http://www.shtvu.edu.cn/','1291','29','0','0','0','0','0','131','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11821','ϺѧԺ','http://www.shfc.edu.cn/','1291','30','0','0','0','0','0','645','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11822','ϺѧԺ','http://www.sdju.edu.cn/','1291','31','0','0','0','0','0','251','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11823','Ϻ´ѧ','http://www.shmtu.edu.cn/','1291','32','0','0','0','0','0','858','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11824','Ϻҽҩѧ','http://www.shutcm.com/','1291','33','0','0','0','0','0','241','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11825','ѧԺ','http://www.ecupl.edu.cn/','1291','34','0','0','0','0','0','820','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11826','ϺоùɲѧԺ','http://www.semc.edu.cn/','1291','35','0','0','0','0','0','80','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11827','Ϻ̼ѧ','http://www.sues.edu.cn/','1291','36','0','0','0','0','0','359','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11828','ϺũְҵѧԺ','http://www.shafc.com/','1291','37','0','0','0','0','0','72','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11829','ϺŻѧԺ','http://www.lixin.edu.cn/','1291','38','0','0','0','0','0','500','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11830','ϺѧԺ','http://www.shiep.cn/','1291','39','0','0','0','0','0','559','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11831','ϺѧԺ','http://www.sus.edu.cn/','1291','40','0','0','0','0','0','165','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11833','ϺɼѧԺ','http://www.sandau.edu.cn/','1291','41','0','0','0','0','0','203','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11834','Ͼѧ','http://www.nju.edu.cn/','1292','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11835','ϴѧ','http://www.seu.edu.cn/','1292','2','0','0','0','0','0','320','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11836','ϴѧ','http://www.sytu.edu.cn/','1292','13','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11837','Ӻѧ','http://www.hhu.edu.cn/','1292','40','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11838','йҵѧ','http://www.cumt.edu.cn/','1292','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11839','ѧԺ','http://www.hhit.edu.cn/','1292','18','0','0','0','0','0','437','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11840','տƼѧ','http://www.ecsi.edu.cn/','1292','37','0','0','0','0','0','748','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11841','Ͼҵѧ','http://www.njfu.edu.cn/','1292','12','0','0','0','0','0','565','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11842','Ͼũҵѧ','http://www.njau.edu.cn/','1292','5','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11843','Ͼҽƴѧ','http://www.njmu.edu.cn/','1292','11','0','0','0','0','0','16','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11844','Ͼҽҩѧ','http://www.njutcm.edu.cn/','1292','16','0','0','0','0','0','342','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11845','Ͼҵѧ','http://www.njut.edu.cn/','1292','10','0','0','0','0','0','617','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11846','йҩƴѧ','http://www.cpu.edu.cn/','1292','9','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11847','Ͼʦѧ','http://www.njnu.edu.cn/','1292','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11848','Ͼƾѧ','http://www.njue.edu.cn/','1292','20','0','0','0','0','0','972','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11849','մѧ','http://www.ujs.edu.cn/','1292','14','0','0','0','0','0','826','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11850','ͨѧ','http://www.ntu.edu.cn/','1292','31','0','0','0','0','0','590','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11851','ϾѧԺ','http://www.njarti.edu.cn/','1292','32','0','0','0','0','0','389','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11852','Ͼʵѧ','http://www.njupt.edu.cn/','1292','15','0','0','0','0','0','539','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11853','Ͼպѧ','http://www.nuaa.edu.cn/','1292','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11854','ݴѧ','http://www.suda.edu.cn/','1292','8','0','0','0','0','0','37','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11855','Ͼѧ','http://www.njust.edu.cn/','1292','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11856','ݹѧԺ','http://www.czu.cn/','1292','30','0','0','0','0','0','303','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11857','վѧԺ','http://www.jspi.cn/','1292','29','0','0','0','0','0','666','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11858','ϾѧԺ','http://www.nau.edu.cn/','1292','21','0','0','0','0','0','816','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11859','ռʦѧԺ','http://www.jstu.edu.cn/','1292','28','0','0','0','0','0','424','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11860','ݿƼѧԺ','http://www.usts.edu.cn/','1292','27','0','0','0','0','0','602','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11861','ѧԺ','http://www.cslg.cn/','1292','38','0','0','0','0','0','360','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11862','ʦѧԺ','http://www.hytc.edu.cn/','1292','26','0','0','0','0','0','297','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11864','γʦѧԺ','http://www.yctc.edu.cn/','1292','23','0','0','0','0','0','283','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11865','ѧԺ','http://www.sju.js.cn/','1292','36','0','0','0','0','0','520','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11866','ݴѧ','http://www.yzu.edu.cn/','1292','19','0','0','0','0','0','921','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11867','ϾѧԺ','http://www.njit.edu.cn/','1292','24','0','0','0','0','0','496','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11868','ҽѧԺ','http://www.xzmc.edu.cn/','1292','39','0','0','0','0','0','319','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11869','ѧԺ','http://www.hyit.edu.cn/','1292','25','0','0','0','0','0','253','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11870','γǹѧԺ','http://www.ycit.cn/','1292','22','0','0','0','0','0','298','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11871','չҵѧԺ','http://www.jpu.edu.cn/','1292','34','0','0','0','0','0','485','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11872','ʦѧ','http://www.xznu.edu.cn/','1292','33','0','0','0','0','0','507','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11873','ϾϢ̴ѧ','http://www.nuist.edu.cn/','1292','17','0','0','0','0','0','1093','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11874','㽭ѧ','http://www.zju.edu.cn/','1293','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11875','ѧ','http://www.nbu.edu.cn/','1293','3','0','0','0','0','0','1449','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11876','㽭ʦѧ','http://www.zjnu.edu.cn/','1293','6','0','0','0','0','0','81','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11877','㽭ҵѧ','http://www.zjut.edu.cn/','1293','4','0','0','0','0','0','140','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11878','㽭ҽҩѧ','http://www.zjtcmiec.net/','1293','19','0','0','0','0','0','283','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11879','㽭ѧԺ','http://www.zjfc.edu.cn/','1293','17','0','0','0','0','0','547','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11880','ѧԺ','http://www.zjxu.edu.cn/','1293','22','0','0','0','0','0','518','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11881','ѧԺ','http://www.zscas.edu.cn/','1293','18','0','0','0','0','0','581','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11882','㽭ѧԺ','http://www.zjou.net.cn/','1293','23','0','0','0','0','0','483','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11883','ʦѧԺ','http://www.hutc.zj.cn/','1293','20','0','0','0','0','0','360','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11884','ҽѧԺ','http://www.wzmc.net/','1293','16','0','0','0','0','0','362','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11885','㽭ѧҽѧԺ','http://www.cmm.zju.edu.cn/','1293','2','0','0','0','0','0','324','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11886','㽭̴ѧ','http://www.hzic.edu.cn/','1293','5','0','0','0','0','0','920','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11887','ݵӿƼѧϢѧԺ','http://www.hziee.edu.cn/','1293','10','0','0','0','0','0','684','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11888','㽭ѧ','http://www.zist.edu.cn/','1293','8','0','0','0','0','0','1107','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11889','йѧԺ','http://www.cjlu.edu.cn/','1293','15','0','0','0','0','0','629','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11890','ʦѧ','http://www.hznu.edu.cn/','1293','9','0','0','0','0','0','746','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11891','㽭ְҵѧԺ','http://www.zjbti.net.cn/','1293','29','0','0','0','0','0','337','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11892','㽭ְҵѧԺ','http://www.zj-art.com/','1293','28','0','0','0','0','0','10','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11893','ݴѧ','http://www.wzu.edu.cn/','1293','7','0','0','0','0','0','663','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11894','㽭ְͨҵѧԺ','http://www.zjvtit.edu.cn/','1293','27','0','0','0','0','0','256','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11895','ѧԺ','http://www.nbc.net.cn/','1293','13','0','0','0','0','0','365','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11896','ְҵѧԺ','http://www.jhc.cn/','1293','30','0','0','0','0','0','293','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11897','㽭ѧԺ','http://www.zjjcxy.cn/','1293','26','0','0','0','0','0','541','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11898','ְҵѧԺ','http://www.wzvtc.cn/','1293','31','0','0','0','0','0','279','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11899','ְ̨ҵѧԺ','http://www.tzvtc.com/','1293','32','0','0','0','0','0','222','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11900','ˮѧԺ','http://www.lsxy.com/','1293','33','0','0','0','0','0','345','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11901','㽭ѧԺ','http://www.zjwu.net/','1293','21','0','0','0','0','0','554','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11902','㽭˴ѧ','http://www.zjsru.cn/','1293','34','0','0','0','0','0','446','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11903','йѧԺ','http://www.chinaacademyofart.com/','1293','24','0','0','0','0','0','10684','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11904','㽭ƾѧԺ','http://www.zufe.edu.cn/','1293','11','0','0','0','0','0','935','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11905','̨ѧԺ','http://www.tzc.edu.cn/','1293','25','0','0','0','0','0','380','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11906','ְҵѧԺ','http://www.nbptweb.net/','1293','35','0','0','0','0','0','399','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11907','㽭ýѧԺ','http://www.zjicm.edu.cn/','1293','12','0','0','0','0','0','916','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11908','㽭ƼѧԺ','http://www.zust.edu.cn/','1293','14','0','0','0','0','0','613','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11909','人ѧ','http://www.whu.edu.cn/','1294','1','0','0','0','0','0','388','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11910','ϲƾѧ','http://www.znufe.edu.cn/','1294','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11911','ʦѧ','http://www.ccnu.edu.cn/','1294','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11912','人ѧ','http://www.whut.edu.cn/','1294','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11913','ѧ','http://www.hubu.edu.cn/','1294','7','0','0','0','0','0','514','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11915','人ҵѧԺ','http://www.whpu.edu.cn/','1294','13','0','0','0','0','0','375','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11917','人̴ѧ','http://www.wit.edu.cn/','1294','33','0','0','0','0','0','587','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11918','人Ƽѧ','http://www.wust.edu.cn/','1294','12','0','0','0','0','0','666','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11919','ũҵѧ','http://www.hzau.edu.cn/','1294','5','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11921','ڶʦѧԺ','http://www.hubce.edu.cn/','1294','19','0','0','0','0','0','275','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11922','ְҵѧԺ','http://www.hbvtc.edu.cn/','1294','35','0','0','0','0','0','419','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11923','ѧ','http://www.yangtzeu.edu.cn/','1294','8','0','0','0','0','0','683','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11924','ѧԺ','http://www.hbmy.edu.cn/','1294','20','0','0','0','0','0','195','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11925','Ͽѧ','http://www.ctgu.edu.cn/','1294','10','0','0','0','0','0','379','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11927','人﹤ѧԺ','http://www.whsw.cn/','1294','22','0','0','0','0','0','243','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11928','ѧ','http://www.scuec.edu.cn/','1294','11','0','0','0','0','0','443','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11929','ѧ','http://www.jhun.edu.cn/','1294','9','0','0','0','0','0','508','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11930','ҵѧ','http://www.hbut.edu.cn/','1294','21','0','0','0','0','0','553','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33156','ʡ֪ʶȨ','http://www.lnipo.gov.cn/','2208','12','0','0','0','0','0','80','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33155','','http://www.liba.com/','1926','15','0','0','0','0','0','2429','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11933','ҽѧԺ','http://www.hbtcm.edu.cn/','1294','14','0','0','0','0','0','265','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11934','ҽѧԺ','http://www.yymc.edu.cn/','1294','26','0','0','0','0','0','166','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11935','ƸʦѧԺ','http://www.hgnc.net/','1294','16','0','0','0','0','0','285','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11936','ʦѧԺ','http://www.hbnu.edu.cn/','1294','18','0','0','0','0','0','314','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11937','ѧԺ','http://www.hbue.edu.cn/','1294','15','0','0','0','0','0','584','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11938','ѧԺ','http://www.hbpa.edu.cn/','1294','30','0','0','0','0','0','317','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11939','人ѧԺ','http://www.wipe.edu.cn/','1294','27','0','0','0','0','0','323','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11940','ѧԺ','http://www.hifa.edu.cn/','1294','28','0','0','0','0','0','374','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11941','人ѧԺ','http://www.whcm.com.cn/','1294','29','0','0','0','0','0','16','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11943','ѧԺ','http://www.xnc.edu.cn/','1294','31','0','0','0','0','0','288','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11944','ТѧԺ','http://www.xgu.cn/','1294','17','0','0','0','0','0','211','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11945','йʴѧ(人)','http://www.cug.edu.cn/','1294','25','0','0','0','0','0','270','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11946','ʦߵרѧУ','http://www.yytc.net.cn/','1294','24','0','0','0','0','0','142','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11947','差ѧԺ','http://www.xfu.edu.cn/','1294','34','0','0','0','0','0','289','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11948','人ƼѧԺ','http://www.wuse.edu.cn/','1294','23','0','0','0','0','0','441','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11949','ɽѧ','http://www.zsu.edu.cn/','1295','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11950','ѧ','http://www.scut.edu.cn/','1295','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11951','ϴѧ','http://www.jnu.edu.cn/','1295','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11952','ũҵѧ','http://www.scau.edu.cn/','1295','9','0','0','0','0','0','747','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11953','㶫ҵѧ','http://www.gdut.edu.cn/','1295','11','0','0','0','0','0','1630','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11954','ݴѧ','http://www.gzhu.edu.cn/','1295','14','0','0','0','0','0','1489','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11955','ʦѧ','http://www.scnu.edu.cn/','1295','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11956','㶫óѧ','http://www.gdufs.edu.cn/','1295','8','0','0','0','0','0','1152','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11957','Ϸҽƴѧ','http://www.fimmu.com/index_com.html','1295','5','0','0','0','0','0','579','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11958','شѧ','http://www.wyu.edu.cn/','1295','15','0','0','0','0','0','457','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11959','ڴѧ','http://www.szu.edu.cn/','1295','13','0','0','0','0','5','1477','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11960','ͷѧ','http://www.stu.edu.cn/','1295','6','0','0','0','0','0','563','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11961','ְҵѧԺ','http://www.szpt.edu.cn/','1295','50','0','0','0','0','0','428','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11962','㶫ҽѧԺ','http://www.gdmc.edu.cn/','1295','17','0','0','0','0','0','539','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11963','㶫ѧԺ','http://www.gduf.org','1295','26','0','0','0','0','0','1046','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11964','ѧԺ','http://www.hzu.edu.cn/','1295','29','0','0','0','0','0','594','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11966','㶫㲥Ӵѧ','http://www.gdrtvu.edu.cn/','1295','44','0','0','0','0','0','201','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11967','ѧԺ','http://www.zqu.edu.cn/','1295','32','0','0','0','0','0','570','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11968','ǺѧԺ','http://www.xhcom.edu.cn/','1295','22','0','0','0','0','0','311','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11969','ѧԺ','http://www.gzarts.edu.cn/','1295','21','0','0','0','0','0','311','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11970','ҽҩѧ','http://www.gzhtcm.edu.cn/','1295','10','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11972','عѧԺ','http://www.sgu.edu.cn/','1295','30','0','0','0','0','0','479','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11973','㶫ѧ','http://www.gdou.edu.cn/','1295','23','0','0','0','0','0','999','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11974','տʦѧԺ','http://www.zhjnc.edu.cn/','1295','27','0','0','0','0','0','418','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11975','ɽѧѧԺ','http://www.fosu.edu.cn/','1295','51','0','0','0','0','0','378','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11976','ϻѧԺ','http://www.nhic.edu.cn/','1295','34','0','0','0','0','0','314','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11977','˽ѧԺ','http://www.hlu.edu.cn/','1295','46','0','0','0','0','0','365','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11978','㶫ְҵѧԺ','http://www.gdmec.com/','1295','36','0','0','0','0','0','249','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11979','㶫ŮְҵѧԺ','http://www.gdfs.edu.cn/','1295','37','0','0','0','0','0','393','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11980','ݺߵרѧУ','http://www.gzhmt.edu.cn/','1295','24','0','0','0','0','0','294','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11981','㶫ʵְҵѧԺ','http://www.gupt.net/','1295','38','0','0','0','0','0','193','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11982','ԶְҵѧԺ','http://www.qypt.com.cn/','1295','52','0','0','0','0','0','223','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11984','ͷְҵѧԺ','http://stzy.stedu.net/','1295','53','0','0','0','0','0','204','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11985','ݸѧԺ','http://www.dgut.edu.cn/','1295','20','0','0','0','0','0','527','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11987','ɽְҵѧԺ','http://www.fspt.net/','1295','55','0','0','0','0','0','292','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11988','㶫ˮְҵѧԺ','http://www.gdsdxy.edu.cn/','1295','39','0','0','0','0','0','301','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11989','㶫ṤְҵѧԺ','http://www.gdqy.edu.cn/','1295','40','0','0','0','0','0','482','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11990','ɽʦѧԺ','http://www.hstc.edu.cn/','1295','31','0','0','0','0','0','268','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11991','˳ְҵѧԺ','http://www.sdpt.com.cn/','1295','56','0','0','0','0','0','213','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('36599','ɽҽƴѧ','http://www.gzsums.edu.cn/2002/index.php','1295','2','0','0','0','0','0','401','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11993','㶫ѧԺ','http://www.peizheng.com.cn/','1295','57','0','0','0','0','0','434','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11994','㶫ʦѧԺ','http://www.gdin.edu.cn/','1295','41','0','0','0','0','0','700','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11995','ѧԺ','http://www.gipe.edu.cn/','1295','19','0','0','0','0','0','195','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11996','㶫ѧԺ','http://www.gdcc.edu.cn/','1295','12','0','0','0','0','0','1012','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11997','㶫ҩѧԺ','http://www.gdpu.edu.cn/','1295','16','0','0','0','0','0','519','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11998','칤ְҵѧԺ','http://www.zqtbu.com/','1295','58','0','0','0','0','0','250','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('11999','ũҵѧԺ','http://www.zhku.edu.cn/','1295','25','0','0','0','0','0','300','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12000','ïѧԺ','http://www.gdpa.edu.cn/','1295','33','0','0','0','0','0','476','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12001','㶫ũְҵѧԺ','http://www.gdaib.edu.cn/','1295','45','0','0','0','0','0','283','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12002','ϢְҵѧԺ','http://www.sziit.com.cn/','1295','47','0','0','0','0','0','254','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12003','ݹְҵѧԺ','http://www.gzvtc.cn/','1295','42','0','0','0','0','0','346','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12004','خְҵѧԺ','http://www.pyp.edu.cn/','1295','59','0','0','0','0','0','336','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12005','ͨѧ','http://www.xjtu.edu.cn/','1296','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12006','ҵѧ','http://www.nwpu.edu.cn/','1296','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12007','ѧ','http://www.nwu.edu.cn/','1296','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12008','ӿƼѧ','http://www.xidian.edu.cn/','1296','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12009','ѧԺ','http://www.xawl.org/','1296','5','0','0','0','0','0','209','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12010','ʦѧ','http://www.snnu.edu.cn/','1296','6','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12011','ʵѧԺ','http://www.xiyou.edu.cn/','1296','7','0','0','0','0','0','335','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12012','ũֿƼѧ','http://www.nwsuaf.edu.cn/','1296','8','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12013','ľҽѧ','http://www.fmmu.edu.cn/','1296','9','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12014','ѧ','http://www.xahu.edu.cn/','1296','10','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12015','ҽѧԺ','http://www.sntcm.edu.cn/','1296','11','0','0','0','0','0','175','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12016','ҵѧ','http://www.xatu.cn/','1296','12','0','0','0','0','0','397','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12017','ʯʹѧ','http://www.xapi.edu.cn/','1296','13','0','0','0','0','0','567','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12018','Ƽѧ','http://www.xauat.edu.cn/','1296','14','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12019','ѧԺ','http://www.slsz.com/','1296','15','0','0','0','0','0','64','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12020','ѧԺ','http://www.aktc.net.cn/','1296','16','0','0','0','0','0','108','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12022','ѧ','http://www.nwupl.edu.cn/','1296','18','0','0','0','0','0','428','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12023','ƾѧԺ','http://www.xaufe.edu.cn/','1296','19','0','0','0','0','0','439','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12024','ѧ','http://www.xisu.edu.cn/','1296','20','0','0','0','0','0','765','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12025','ѧԺ','http://www.bjwlxy.cn/','1296','21','0','0','0','0','0','294','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12026','μʦѧԺ','http://www.wntc.net/','1296','22','0','0','0','0','0','229','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12027','̴ѧ','http://www.xaist.edu.cn/','1296','23','0','0','0','0','0','473','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12028','Ƽѧ','http://www.sust.edu.cn/','1296','24','0','0','0','0','0','517','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12029','ѧԺ','http://www.xfuedu.org/','1296','25','0','0','0','0','0','391','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12030','Ƽѧ','http://www.xust.edu.cn/','1296','26','0','0','0','0','0','445','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12031','Ƽѧ','http://www.xauat.edu.cn/','1296','27','0','0','0','0','0','713','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12032','ѧ','http://www.xaut.edu.cn/','1296','28','0','0','0','0','0','575','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12033','ŷѧԺ','http://www.eurasia.edu/','1296','29','0','0','0','0','0','353','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12034','ռר','http://www.xihangzh.com/','1296','30','0','0','0','0','0','259','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12035','ѧԺ','http://www.snut.edu.cn/','1296','31','0','0','0','0','0','253','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12036','ʦѧԺ','http://www.xysfxy.cn/','1296','32','0','0','0','0','0','139','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12037','ѧԺ','http://www.ylc.net.cn/','1296','33','0','0','0','0','0','228','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12038','ѧԺ','http://www.xaipe.edu.cn/','1296','34','0','0','0','0','0','261','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12039','ߵר','http://www.xaepi.edu.cn/','1296','35','0','0','0','0','0','257','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12048','Ĵѧ','http://www.scu.edu.cn/','1297','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12049','Ͻͨѧ','http://www.swjtu.edu.cn/','1297','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12050','ϲƾѧ','http://www.swufe.edu.cn/','1297','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12051','Ĵʦѧ','http://www.sicnu.edu.cn/','1297','11','0','0','0','0','0','121','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12052','Ĵѧҽѧ','http://www.wcums.edu.cn/','1297','25','0','0','0','0','0','101','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12053','ϿƼѧ','http://www.swust.edu.cn/','1297','8','0','0','0','0','0','712','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12054','ɶѧ','http://www.cdut.edu.cn/','1297','5','0','0','0','0','0','886','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12055','ӿƼѧ','http://www.uestc.edu.cn/','1297','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12056','ѧ','http://www.swun.edu.cn/','1297','6','0','0','0','0','0','553','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12057','Ĵũҵѧ','http://www.sicau.edu.cn/','1297','9','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12058','ɶҽҩѧ','http://www.cdutcm.edu.cn/','1297','10','0','0','0','0','0','374','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12059','ɶϢѧԺ','http://www.cuit.edu.cn/','1297','15','0','0','0','0','0','533','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12060','ʯʹѧ','http://www.swpi.edu.cn/','1297','7','0','0','0','0','0','797','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12061','ĴһѧԺ','http://www.tianyi.org/','1297','40','0','0','0','0','0','179','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12062','ĴѧԺ','http://www.suse.edu.cn/','1297','14','0','0','0','0','0','464','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12063','ĴְҵѧԺ','http://www.scetc.net/','1297','33','0','0','0','0','0','373','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12064','ĴְͨҵѧԺ','http://www.svtcc.net/','1297','36','0','0','0','0','0','301','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12065','Ĵ⿸ߵרѧУ','http://www.shic.edu.cn/','1297','28','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12066','Ĵ⿸ߵרѧУ','http://www.shic.edu.cn/','1297','37','0','0','0','0','0','228','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12067','ʦר','http://www.kdntc.edu.cn/','1297','38','0','0','0','0','0','151','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12068','ɶ֯ߵרѧУ','http://www.cdtc.edu.cn/','1297','39','0','0','0','0','0','151','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12069','ĴְҵѧԺ','http://www.sctbc.net/','1297','32','0','0','0','0','0','211','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12070','ɶְҵѧԺ','http://www.cdartpro.cn/','1297','31','0','0','0','0','0','187','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12071','ĴʱְҵѧԺ','http://www.scpivotpoint.com/','1297','30','0','0','0','0','0','124','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12072','ĴְҵѧԺ','http://www.scatc.net/','1297','29','0','0','0','0','0','18','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12073','ʦѧ','http://www.cwnu.edu.cn/','1297','12','0','0','0','0','0','646','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12074','й񺽴ѧ','http://www.cauc.edu.cn/','1297','27','0','0','0','0','0','970','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12075','й񺽷ѧԺ','http://www.cafuc.edu.cn/','1297','17','0','0','0','0','0','703','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12076','ҽѧԺ','http://www.lzmc.edu.cn/','1297','13','0','0','0','0','0','352','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12077','ҽѧԺ','http://www.nsmc.edu.cn/','1297','19','0','0','0','0','0','298','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12078','ڽʦѧԺ','http://www.njtc.edu.cn/','1297','21','0','0','0','0','0','215','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12079','ɽʦѧԺ','http://www.lstc.edu.cn/','1297','20','0','0','0','0','0','554','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12080','ɶѧԺ','http://www.cdsu.edu.cn/','1297','16','0','0','0','0','0','319','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12081','ĴѧԺ','http://www.sccm.cn/','1297','18','0','0','0','0','0','509','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12082','ѧԺ','http://www.xcc.sc.cn/','1297','24','0','0','0','0','0','222','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12083','֦ѧԺ','http://www.pzhu.edu.cn/','1297','23','0','0','0','0','0','263','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12084','˱ѧԺ','http://www.yibinu.cn/','1297','22','0','0','0','0','0','208','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12085','ְҵѧԺ','http://www.dzvtc.com/','1297','35','0','0','0','0','0','111','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12086','ĴѧԺ','http://www.scpolicec.com/','1297','34','0','0','0','0','0','389','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12087','ĴѧԺ','http://www.sasu.edu.cn/','1297','26','0','0','0','0','0','322','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12088','ѧ','http://www.cqu.edu.cn/','1298','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12089','ʵѧ','http://www.cqupt.edu.cn/','1298','2','0','0','0','0','0','842','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12090','ѧ','http://www.swupl.edu.cn/','1298','3','0','0','0','0','0','1133','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12091','ҽƴѧ','http://www.cqmu.edu.cn/','1298','4','0','0','0','0','0','698','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12092','ʦѧ','http://www.cqnu.edu.cn/','1298','5','0','0','0','0','0','636','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12093','콻ͨѧ','http://www.cquc.edu.cn/','1298','6','0','0','0','0','0','857','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12094','ĴѧԺ','http://www.sisu.edu.cn/','1298','7','0','0','0','0','0','617','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12096','ϿѧԺ','http://www.sanxiau.net/','1298','8','0','0','0','0','0','251','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12098','ƼѧԺ','http://www.cqust.cn/','1298','10','0','0','0','0','0','489','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12099','ѧ','http://www.cqut.edu.cn/','1298','11','0','0','0','0','0','516','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12100','ʦѧԺ','http://www.yznu.cn/','1298','12','0','0','0','0','0','289','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12101','칤̴ѧ','http://www.ctbu.edu.cn/','1298','13','0','0','0','0','0','675','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12102','ѧԺ','http://www.cqwu.net/','1298','14','0','0','0','0','0','412','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12103','ѧ','http://www.dlut.edu.cn/','1299','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12104','ѧ','http://www.neu.edu.cn/','1299','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12105','йҽƴѧ','http://www.cmu.edu.cn/','1299','7','0','0','0','0','0','21','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12106','ƾѧ','http://www.dufe.edu.cn/','1299','3','0','0','0','0','0','971','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12107','ҩƴѧ','http://www.syphu.edu.cn/','1299','12','0','0','0','0','0','255','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12108','ѧ','http://www.lnu.edu.cn/','1299','4','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('35953','йƸ','http://www.hr33.com/','958','10','0','0','0','0','0','3383','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12110','ũҵѧ','http://www.syau.edu.cn/','1299','8','0','0','0','0','0','241','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12111','ҵѧ','http://www.sut.edu.cn/','1299','11','0','0','0','0','0','449','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12112','ѧ','http://www.syit.edu.cn/','1299','16','0','0','0','0','0','624','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12114','̼ѧ','http://www.lntu.edu.cn/','1299','10','0','0','0','0','0','449','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12115','ʦѧ','http://www.synu.edu.cn/','1299','15','0','0','0','0','0','574','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12116','ʦѧ','http://www.lnnu.edu.cn/','1299','6','0','0','0','0','0','485','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12117','ҽѧԺ','http://www.symc.edu.cn/','1299','29','0','0','0','0','0','173','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12118','ѧ','http://www.dlu.edu.cn/','1299','24','0','0','0','0','0','607','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12119','ѧ','http://www.syu.edu.cn/','1299','28','0','0','0','0','0','382','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12120','Ƽѧ','http://www.asust.edu.cn/','1299','14','0','0','0','0','0','406','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12121','չҵѧԺ','http://www.syiae.edu.cn/','1299','21','0','0','0','0','0','411','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12122','ҵѧ','http://www.lnit.edu.cn/','1299','30','0','0','0','0','0','421','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12123','ѧԺ','http://www.sycm.com.cn/','1299','27','0','0','0','0','0','194','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12124','³ѸѧԺ','http://www.lumei.edu.cn/','1299','26','0','0','0','0','0','192','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12125','ѧԺ','http://www.syty.edu.cn/','1299','31','0','0','0','0','0','108','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12126','ѧԺ','http://www.dlufl.edu.cn/','1299','20','0','0','0','0','0','612','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12127','ɽʦѧԺ','http://www.asnc.edu.cn/','1299','32','0','0','0','0','0','196','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12128','ҽҩѧ','http://www.lnutcm.edu.cn/','1299','37','0','0','0','0','0','196','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12129','ˮѧԺ','http://www.dlfu.edu.cn/','1299','33','0','0','0','0','0','244','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12130','ɶѧԺ','http://www.ldxy.cn/','1299','36','0','0','0','0','0','174','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12131','ѧ','http://www.jznu.edu.cn/','1299','34','0','0','0','0','0','466','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12132','ҽƴѧ','http://www.dlmedu.edu.cn/','1299','13','0','0','0','0','0','384','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12133','ҵѧ','http://www.dlili.edu.cn/','1299','9','0','0','0','0','0','434','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12134','ѧԺ','http://www.syict.edu.cn/','1299','18','0','0','0','0','0','242','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12135','ͨѧ','http://www.djtu.edu.cn/','1299','22','0','0','0','0','0','702','0','','haijuan','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12136','ƼѧԺ','http://www.lnist.edu.cn/','1299','35','0','0','0','0','0','293','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12137','й̾ѧԺ','http://www.ccpc.edu.cn/','1299','38','0','0','0','0','0','443','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12138','ѧԺ','http://www.dlnu.edu.cn/','1299','25','0','0','0','0','0','335','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12139','⾭óѧԺ','http://www.ulet.edu.cn/','1299','39','0','0','0','0','0','311','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12140','ѧ','http://www.sjzu.edu.cn/','1299','17','0','0','0','0','0','381','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12141','ʦߵרѧУ','http://www.jzsz.com.cn/','1299','45','0','0','0','0','0','121','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12142','ʯͻѧ','http://www.lnpu.edu.cn/','1299','23','0','0','0','0','0','506','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12143','ʡͨߵרѧУ','http://www.lncc.edu.cn/','1299','44','0','0','0','0','0','136','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12144','ְҵѧԺ','http://www.dlvtc.edu.cn/','1299','43','0','0','0','0','0','197','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12145','ְҵѧԺ','http://www.lnmec.net.cn/default.asp','1299','42','0','0','0','0','0','161','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12146','ְҵѧԺ','http://www.lnfvc.cn/','1299','41','0','0','0','0','0','132','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12148','ѧԺ','http://www.syce.edu.cn/','1299','19','0','0','0','0','0','293','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12149','ҵѧ','http://www.hit.edu.cn/','1300','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12150','̴ѧ','http://www.hrbeu.edu.cn/','1300','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12151','ҵѧ','http://www.nefu.edu.cn/','1300','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12153','ʦѧ','http://www.hrbnu.edu.cn/','1300','11','0','0','0','0','0','347','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12154','ҽƴѧ','http://www.hrbmu.edu.cn/','1300','9','0','0','0','0','0','10','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12155','ѧ','http://www.hrbust.edu.cn/','1300','6','0','0','0','0','0','410','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12156','ũҵѧ','http://www.neau.cn/','1300','7','0','0','0','0','0','179','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12157','ľ˹ѧ','http://www.jmsu.org/','1300','5','0','0','0','0','0','320','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12158','ҵѧ','http://www.hljcu.edu.cn/','1300','12','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12159','ҽҩѧ','http://www.hljucm.net/','1300','10','0','0','0','0','0','174','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12160','ʯѧԺ','http://www.dqpi.net/','1300','13','0','0','0','0','0','490','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12161','һũѴѧ','http://www.hlaflru.edu.cn/','1300','8','0','0','0','0','0','590','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12162','ѧԺ','http://www.hrbipe.edu.cn/','1300','21','0','0','0','0','0','70','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12164','ҵѧ','http://www.hljcu.edu.cn/','1300','23','0','0','0','0','0','376','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12165','ƼѧԺ','http://usth.edu.cn/','1300','15','0','0','0','0','0','239','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12166','ѧԺ','http://www.hrbu.edu.cn/','1300','17','0','0','0','0','0','131','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12167','绯ѧԺ','http://www.shxy.net/index.asp','1300','22','0','0','0','0','0','110','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12168','ҽѧԺ','http://www.qqhrmc.net.cn/','1300','18','0','0','0','0','0','88','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12169','ʦѧԺ','http://www.dqsy.net/','1300','19','0','0','0','0','0','76','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12170','ĵʦѧԺ','http://www.mdjnu.cn/','1300','20','0','0','0','0','0','204','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12171','ũҵְҵѧԺ','http://www.hngzy.com/','1300','24','0','0','0','0','0','55','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12172','ҵְҵѧԺ','http://www.hljlzy.com/','1300','25','0','0','0','0','0','50','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12173','˾ְҵѧԺ','http://www.hlsfjx.com/','1300','26','0','0','0','0','0','166','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12174','ְҵѧԺ','http://www.dqzyxy.net/','1300','27','0','0','0','0','0','55','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12175','ѧԺ','http://www.hljit.edu.cn/','1300','14','0','0','0','0','0','7','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12176','ѧ','http://www.qqhru.edu.cn/','1300','28','0','0','0','0','0','290','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12177','ϴѧ','http://www.csu.edu.cn/','1301','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12178','ϴѧ','http://www.hnu.cn/','1301','2','0','0','0','0','0','0','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12179','ʦѧ','http://www.hunnu.edu.cn/','1301','25','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12180','̶ѧ','http://www.xtu.edu.cn/','1301','4','0','0','0','0','0','714','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12181','ϿƼѧ','http://www.hnust.edu.cn/','1301','6','0','0','0','0','0','86','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12182','ɳѧ','http://www.csust.edu.cn/','1301','5','0','0','0','0','0','1266','0','','ljm','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12184','״ѧ','http://www.jsu.edu.cn/','1301','12','0','0','0','0','0','333','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12185','ϹѧԺ','http://www.hnie.edu.cn/','1301','14','0','0','0','0','0','308','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12186','ϳѧԺ','http://www.hncu.net/','1301','18','0','0','0','0','0','257','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12187','Ϲҵѧ','http://www.zhuzit.edu.cn/cn/','1301','11','0','0','0','0','0','391','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12188','ѧԺ','http://www.hnbc.com.cn/','1301','13','0','0','0','0','0','333','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12189','ĿƼѧԺ','http://www.hnrku.net.cn/','1301','20','0','0','0','0','0','202','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12190','ϴڴýѧԺ','http://www.hnmmc.cn/','1301','26','0','0','0','0','0','149','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12191','ѧԺ','http://www.hhtc.edu.cn/','1301','21','0','0','0','0','0','175','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12192','ѧԺ','http://www.huas.cn/','1301','16','0','0','0','0','0','227','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12193','ѧѧ','http://www.nudt.edu.cn/','1301','27','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12194','ũҵѧ','http://www.hunau.net/','1301','8','0','0','0','0','0','393','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12195','ѧԺ','http://www.hnist.cn/','1301','15','0','0','0','0','0','348','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12196','ʦѧԺ','http://www.hynu.cn/index.jsp','1301','17','0','0','0','0','0','215','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12197','ɳҽѧԺ','http://www.8498888.com/','1301','28','0','0','0','0','0','294','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12198','ҵƼѧ','http://www.csuft.com/','1301','9','0','0','0','0','0','545','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12200','ְҵѧԺ','http://www.hnrpc.com/','1301','30','0','0','0','0','0','245','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12201','ѧԺ','http://www.hnsyu.net/','1301','22','0','0','0','0','0','272','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12202','ѧԺ','http://www.xnu.edu.cn/','1301','24','0','0','0','0','0','205','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12203','ɳѧԺ','http://www.ccsu.cn/','1301','3','0','0','0','0','0','422','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12204','⾭ѧԺ','http://www.hunaneu.com/','1301','31','0','0','0','0','0','311','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12205','ְҵ?ѧ?','http://www.hnswxy.com/','1301','32','0','0','0','0','0','101','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12206','ϿƼְҵѧԺ','http://www.hnkjxy.net.cn/','1301','23','0','0','0','0','0','310','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12207','ְҵѧԺ','http://www.chinaloveweb.com/','1301','33','0','0','0','0','0','207','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12209','Ϲ㲥Ӵѧ','http://www.hnrtu.edu.cn/','1301','7','0','0','0','0','0','151','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12210','żҽ纽չҵְԺ','http://www.zjjhy.net/','1301','29','0','0','0','0','0','121','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12211','ɽѧ','http://www.sdu.edu.cn/','1302','1','0','0','0','0','0','312','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12212','ɽѧ','http://www.sdut.edu.cn/','1302','9','0','0','0','0','0','682','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12213','ɽʦѧ','http://www.sdnu.edu.cn/','1302','5','0','0','0','0','0','1097','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12214','ൺѧ','http://www.qdu.edu.cn/','1302','6','0','0','0','0','0','1248','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12215','йѧ','http://www.ouc.edu.cn/','1302','2','0','0','0','0','0','13','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12216','̨ѧ','http://www.ytu.edu.cn/','1302','12','0','0','0','0','0','718','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12217','ɽѧԺ','http://www.sdpc.edu.cn/','1302','39','0','0','0','0','0','395','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12218','ϴѧ','http://www.ujn.edu.cn/','1302','13','0','0','0','0','0','847','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12219','³ѧ','http://www.ytnc.edu.cn/','1302','7','0','0','0','0','0','618','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12220','ɽƼѧ','http://www.sdkd.net.cn/','1302','8','0','0','0','0','0','856','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12221','ɽƼѧ','http://www.ustsd.edu.cn/','1302','38','0','0','0','0','0','184','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12222','ɽѧԺ','http://www.ccec.edu.cn/','1302','23','0','0','0','0','0','376','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12223','ĳǴѧ','http://www.lcu.edu.cn/','1302','14','0','0','0','0','0','604','0','','luoxiong','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12224','ൺƼѧ','http://www.qust.edu.cn/','1302','11','0','0','0','0','0','835','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12225','ൺѧ','http://www.qdiae.edu.cn/','1302','22','0','0','0','0','0','1250','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12226','ɽṤҵѧԺ','http://www.sdili.edu.cn/','1302','20','0','0','0','0','0','291','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12228','ɽҽҩѧ','http://www.sdutcm.edu.cn/','1302','15','0','0','0','0','0','294','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12230','ΫѧԺ','http://www.wfu.edu.cn/','1302','25','0','0','0','0','0','381','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12231','ɽͨѧԺ','http://www.sdjtu.edu.cn/','1302','32','0','0','0','0','0','290','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12232','ൺũҵѧ','http://www.qau.edu.cn/','1302','26','0','0','0','0','0','543','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12233','ΫҽѧԺ','http://www.wfmc.edu.cn/','1302','21','0','0','0','0','0','349','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12234','̩ɽҽѧԺ','http://www.tsmc.edu.cn/','1302','24','0','0','0','0','0','250','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12236','ҽѧԺ','http://www.jnmc.edu.cn/','1302','29','0','0','0','0','0','223','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12237','ʦѧԺ','http://www.lytu.edu.cn/','1302','16','0','0','0','0','0','382','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12238','ѧԺ','http://www.dzu.edu.cn/','1302','30','0','0','0','0','0','221','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12239','ɽѧԺ','http://www.sdie.edu.cn/','1302','18','0','0','0','0','0','875','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12241','ൺְҵѧԺ','http://www.feiyangcollege.com/','1302','27','0','0','0','0','0','385','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12242','ɽѧԺ','http://www.sdpei.edu.cn/','1302','31','0','0','0','0','0','152','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12243','ɽѧԺ','http://www.sdca.edu.cn/','1302','28','0','0','0','0','0','229','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12244','ɽѧԺ','http://www.sdada.edu.cn/','1302','34','0','0','0','0','0','232','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12245','̩ɽѧԺ','http://www.tanc.edu.cn/','1302','33','0','0','0','0','0','231','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12246','ׯѧԺ','http://www.uzz.edu.cn/','1302','35','0','0','0','0','0','275','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12247','йʯʹѧ()','http://www.upc.edu.cn/','1302','3','0','0','0','0','0','8','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12248','ɽѧԺ','http://www.sde.edu.cn/','1302','36','0','0','0','0','0','216','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12249','ɽѧ','http://www.sdai.edu.cn/','1302','17','0','0','0','0','0','487','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12250','йѧѧ','http://www.ustc.edu.cn/','1303','1','0','0','0','0','0','2','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12251','Ϸʹҵѧ','http://www.hfut.edu.cn/ch/','1303','2','0','0','0','0','0','455','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12252','մѧ','http://www.ahu.edu.cn/','1303','3','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12253','չҵѧ','http://www.ahut.edu.cn/','1303','9','0','0','0','0','0','32','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12254','ҽƴѧ','http://www.ahmu.edu.cn/','1303','6','0','0','0','0','0','38','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12255','ѧ','http://www.aust.edu.cn/','1303','7','0','0','0','0','0','579','0','','lzb','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12256','սҵѧԺ','http://www.aiai.edu.cn/','1303','11','0','0','0','0','0','334','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12257','ղƾѧ','http://www.aufe.edu.cn/','1303','8','0','0','0','0','0','639','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12258','ʦѧ','http://www.ahnu.edu.cn/','1303','4','0','0','0','0','0','58','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12259','ʦѧԺ','http://www.aqtc.edu.cn/','1303','13','0','0','0','0','0','373','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12260','ũҵѧ','http://www.ahau.edu.cn/','1303','5','0','0','0','0','0','375','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12261','չ̿ƼѧԺ','http://www.auts.edu.cn/','1303','17','0','0','0','0','0','359','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12262','ҽѧԺ','http://www.wnmc.edu.cn/','1303','14','0','0','0','0','0','316','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12263','ҽѧԺ','http://www.ahtcm.edu.cn/','1303','12','0','0','0','0','0','177','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12264','ʦѧԺ','http://www.fync.edu.cn/','1303','15','0','0','0','0','0','357','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12266','ѧԺ','http://www.bbxy.edu.cn/','1303','29','0','0','0','0','0','247','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12267','ϷѧԺ','http://www.hfuu.edu.cn/','1303','19','0','0','0','0','0','304','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12268','ְҵѧԺ','http://www.ahtu.ah.cn/','1303','30','0','0','0','0','0','326','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12269','ʦרѧУ','http://www.cntc.edu.cn/','1303','28','0','0','0','0','0','146','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12270','ϴѧ','http://www.hnuu.cn/','1303','20','0','0','0','0','0','127','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12271','ߺְҵѧԺ','http://www.whptu.ah.cn/','1303','31','0','0','0','0','0','281','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12273','ú̿ʦѧԺ','http://www.hbcnc.edu.cn/','1303','10','0','0','0','0','0','222','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12274','ѧԺ','http://www.ahsztc.edu.cn/','1303','26','0','0','0','0','0','197','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12275','ʦѧԺ','http://www.hnnu.edu.cn/','1303','18','0','0','0','0','0','205','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12276','ѧԺ','http://www.wxc.edu.cn/','1303','21','0','0','0','0','0','215','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12277','аĿƼְҵѧԺ','http://www.acac.cn/','1303','27','0','0','0','0','0','132','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12278','ͭѧԺ','http://www.tlu.edu.cn/','1303','24','0','0','0','0','0','250','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12279','ѧԺ','http://www.chtc.edu.cn/','1303','23','0','0','0','0','0','279','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12280','ҽѧߵרѧУ','http://www.ahyz.cn/','1303','25','0','0','0','0','0','187','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12281','óְҵѧԺ','http://www.ahszy.com/','1303','35','0','0','0','0','0','185','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33162','֪ʶȨ','http://www.cqipo.gov.cn/','2208','28','0','0','0','0','0','64','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12284','ˮˮְҵԺ','http://www.ahsdxy.ah.edu.cn/','1303','34','0','0','0','0','0','157','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12285','ҽѧԺ','http://www.bbmc.edu.cn/','1303','16','0','0','0','0','0','228','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12286','ɽѧ','http://www.sxu.edu.cn/','1304','1','0','0','0','0','0','71','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12287','̫ԭѧ','http://www.tyut.edu.cn/','1304','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12288','бѧ','http://www.nuc.edu.cn/','1304','3','0','0','0','0','0','61','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12291','ɽƾѧ','http://www.sxufe.edu.cn/','1304','8','0','0','0','0','0','478','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12292','ɽũҵѧ','http://www.sxau.edu.cn/','1304','5','0','0','0','0','0','161','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12293','̫ԭƼѧ','http://www.tyust.edu.cn/','1304','4','0','0','0','0','0','298','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12294','̫ԭʦѧԺ','http://www.tysy.net/','1304','11','0','0','0','0','0','168','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12295','ʦѧԺ','http://www.xztc.edu.cn/','1304','12','0','0','0','0','0','73','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12296','˳ѧԺ','http://www.ycu.edu.cn/','1304','10','0','0','0','0','0','93','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12297','ߵרѧУ','http://www.llhc.edu.cn/','1304','15','0','0','0','0','0','68','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12298','ҽѧԺ','http://www.czmc.com/','1304','14','0','0','0','0','0','139','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12299','ɽҽѧԺ','http://www.sxtcm.com/','1304','9','0','0','0','0','0','119','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12301','ɽͬѧ','http://www.sxdtdx.edu.cn/','1304','17','0','0','0','0','0','251','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12302','˰רѧУ','http://www.sxftc.edu.cn/','1304','16','0','0','0','0','0','93','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12303','ɽְͨҵѧԺ','http://www.sxjt.edu.cn/','1304','18','0','0','0','0','0','78','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12304','ִѧ','http://www.jlu.edu.cn/','1305','1','0','0','0','0','0','1','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12305','ʦѧ','http://www.nenu.edu.cn/','1305','2','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12306','ũҵѧ','http://www.jlau.edu.cn/','1305','8','0','0','0','0','0','245','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12307','ѧ','http://www.cust.edu.cn/','1305','6','0','0','0','0','0','454','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12308','ѧ','http://www.ccu-edu.cn/','1305','5','0','0','0','0','0','265','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12309','ѧ','http://www.bhunews.com/','1305','4','0','0','0','0','0','322','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12310','ʦѧ','http://www.jlnu.edu.cn/','1305','10','0','0','0','0','0','217','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12311','ӱߴѧ','http://www.ybu.edu.cn/','1305','3','0','0','0','0','0','2','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12312','˰ѧԺ','http://www.ctu.cc.jl.cn/','1305','22','0','0','0','0','0','355','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12313','ѧԺ','http://www.nedu.edu.cn/','1305','11','0','0','0','0','0','469','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12314','ѧԺ','http://www.ccit.edu.cn/','1305','12','0','0','0','0','0','385','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12315','ֻѧԺ','http://www.jlict.edu.cn/','1305','14','0','0','0','0','0','105','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12316','ʦѧԺ','http://www.cncnc.net/','1305','17','0','0','0','0','0','273','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12317','ֹ̼ʦѧԺ','http://www.jltiet.net/','1305','19','0','0','0','0','0','96','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12318','ֽѧԺ','http://www.jliae.edu.cn/','1305','13','0','0','0','0','0','276','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12319','ҵѧ','http://www.ccut.edu.cn/','1305','7','0','0','0','0','0','272','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12320','ѧԺ','http://www.jlart.edu.cn/','1305','24','0','0','0','0','0','224','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12321','ҽҩѧ','http://www.ccutcm.com.cn/','1305','9','0','0','0','0','0','105','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12322','ͨʦѧԺ','http://www.thtc.cn/','1305','20','0','0','0','0','0','120','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12324','ֻѧԺ','http://www.hqwy.com/','1305','21','0','0','0','0','0','121','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12325','ѧԺ','http://www.jlty.com.cn/','1305','23','0','0','0','0','0','75','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12326','ҽҩѧԺ','http://www.jlmpc.cn/','1305','16','0','0','0','0','0','97','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12327','׳ʦѧԺ','http://www.bcsfxy.com/','1305','18','0','0','0','0','0','80','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12328','ҵר','http://www.caii.edu.cn/','1305','25','0','0','0','0','0','117','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12329','NULL','http://www.jlcz.com/˰ߵרѧУ','1305','26','0','0','0','0','0','1','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12330','ְҵѧԺ','http://www.cvit.com.cn/','1305','27','0','0','0','0','0','113','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12331','NULL','http://www.jlgc.jl.cn/ʳߵרѧУ','1305','28','0','0','0','0','0','2','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12332','Ŵѧ','http://www.xmu.edu.cn/','1306','1','0','0','0','0','0','19','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12333','ũִѧ','http://www.fjau.edu.cn/','1306','3','0','0','0','0','0','30','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12334','ݴѧ','http://www.fzu.edu.cn/','1306','2','0','0','0','0','0','7','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12335','ѧ','http://www.jmu.edu.cn/','1306','6','0','0','0','0','0','756','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12336','ʦѧ','http://www.fjtu.edu.cn/','1306','5','0','0','0','0','0','46','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12337','ѧ','http://www.yeu.edu.cn/','1306','13','0','0','0','0','0','403','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12338','ҽƴѧ','http://www.fjmu.edu.cn/','1306','4','0','0','0','0','0','266','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12339','ȴѧ','http://www.hqu.edu.cn/','1306','7','0','0','0','0','0','797','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12340','ȪʦѧԺ','http://www.qztc.edu.cn/','1306','9','0','0','0','0','0','246','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12341','ҽѧԺ','http://www.fjtcm.edu.cn/','1306','12','0','0','0','0','0','144','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12342','ѧԺ','http://www.fjut.edu.cn/','1306','11','0','0','0','0','0','379','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12343','ʦѧԺ','http://www.fjzs.edu.cn/','1306','10','0','0','0','0','0','376','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12344','ѧԺ','http://www.mju.edu.cn/','1306','14','0','0','0','0','0','404','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12345','ѧԺ','http://www.xmut.edu.cn/','1306','8','0','0','0','0','0','566','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12346','̴ѧݷװѧԺ','http://www.fzfashion.com/','1306','22','0','0','0','0','0','102','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12347','ѧԺ','http://www.lyun.edu.cn/','1306','15','0','0','0','0','0','178','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12348','ѧԺ','http://www.fjpsc.edu.cn/','1306','17','0','0','0','0','0','247','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12349','ְҵѧԺ','http://www.mxdx.net/','1306','20','0','0','0','0','0','157','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12351','㲥Ӵѧ','http://www.fjrtvu.edu.cn/','1306','19','0','0','0','0','0','124','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12352','ݳְҵѧԺ','http://www.zzjyxy.com/','1306','16','0','0','0','0','0','163','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12353','ְҵѧԺ','http://www.fvti.cn/','1306','18','0','0','0','0','0','230','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12354','ˮְҵѧԺ','http://www.fjsdxy.com/','1306','23','0','0','0','0','0','197','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12355','ȪݾóѧԺ','http://www.qzjmc.cn/','1306','24','0','0','0','0','0','202','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12356','ѧԺ','http://202.101.111.193/2.htm','1306','25','0','0','0','0','0','320','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12357','֣ݴѧ','http://www.zzu.edu.cn/','1307','1','0','0','0','0','0','5','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12358','ϴѧ','http://www.henu.edu.cn/','1307','2','0','0','0','0','0','69','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12359','ϿƼѧ','http://www.haust.edu.cn/','1307','3','0','0','0','0','0','615','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12360','ũҵѧ','http://www.henau.edu.cn/','1307','5','0','0','0','0','0','302','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12361','ʦѧ','http://www.henannu.edu.cn/','1307','6','0','0','0','0','0','436','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12363','ˮˮѧԺ','http://www.ncwu.edu.cn/','1307','10','0','0','0','0','0','525','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12364','ѧ','http://www.hpu.edu.cn/','1307','4','0','0','0','0','0','580','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12365','Ϲҵѧ','http://www.zzit.edu.cn/','1307','7','0','0','0','0','0','432','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12367','ƽɽҵְҵѧԺ','http://www.pzxy.edu.cn/','1307','32','0','0','0','0','0','95','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12368','ѧԺ','http://www.nyist.net/','1307','19','0','0','0','0','0','262','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12369','֣ṤҵѧԺ','http://www.zzili.edu.cn/','1307','13','0','0','0','0','0','651','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12370','ƽɽѧԺ','http://www.hncj.edu.cn/','1307','33','0','0','0','0','0','217','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12371','֣ݺչҵѧԺ','http://www.zzia.edu.cn/','1307','23','0','0','0','0','0','333','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12372','ԭѧԺ','http://www.zzti.edu.cn/','1307','14','0','0','0','0','0','322','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12374','ѧԺ','http://www.ayit.edu.cn/','1307','24','0','0','0','0','0','187','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12375','ҽѧԺ','http://www.hactcm.edu.cn/','1307','15','0','0','0','0','0','174','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12376','ҽѧԺ','http://www.xxmu.edu.cn/','1307','28','0','0','0','0','0','227','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12377','ʦѧԺ','http://www.xytc.edu.cn/','1307','12','0','0','0','0','0','285','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12378','ʦѧԺ','http://www.nytc.edu.cn/','1307','20','0','0','0','0','0','242','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12379','ܿʦѧԺ','http://www.zknu.edu.cn/','1307','21','0','0','0','0','0','257','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12380','ʦѧԺ','http://www.lync.edu.cn/','1307','16','0','0','0','0','0','261','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12381','ʦѧԺ','http://www.sqnc.edu.cn/','1307','22','0','0','0','0','0','298','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12382','ʦѧԺ','http://www.aynu.edu.cn/','1307','18','0','0','0','0','0','191','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12384','ƽɽѧԺ','http://www.pdsnc.edu.cn/','1307','34','0','0','0','0','0','216','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12387','ϹߵרѧУ','http://www.hngazk.edu.cn/','1307','25','0','0','0','0','0','220','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12388','ϲ˰ߵרѧУ','http://www.hacz.edu.cn/','1307','26','0','0','0','0','0','213','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12389','ϻߵרѧУ','http://www.hneeu.edu.cn/','1307','27','0','0','0','0','0','173','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12391','ҵߵרѧУ','http://www.habc.edu.cn/index.aspx','1307','30','0','0','0','0','0','186','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12392','֣ҵ̸ߵרѧУ','http://www.zzcah.edu.cn/','1307','31','0','0','0','0','0','118','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12394','NULL','http://www.pyu.edu.cn/ƽԭѧ','1307','100','0','0','0','0','0','8','0','','lwh','0','0','1283270400','1283270400','','1');
INSERT INTO ylmf_site VALUES('12395','ݴѧ','http://www.zhzhu.edu.cn/','1307','11','0','0','0','0','0','221','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12396','ѧ','http://www.kfu.edu.cn/','1307','8','0','0','0','0','0','231','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('33152','֪ʶȨ','http://www.sipo.gov.cn/sipo/','1880','7','0','0','0','0','0','661','0','','lsz','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12398','ӱѧ','http://www.hbu.edu.cn/','1308','1','0','0','0','0','0','676','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12399','ɽѧ','http://www.ysu.edu.cn/','1308','3','0','0','0','0','0','1068','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12400','ӱҵѧ','http://www.hebut.edu.cn/','1308','2','0','0','0','0','0','4','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12401','ѧ','http://www.ncepu.edu.cn/','1308','9','0','0','0','0','0','54','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12402','ӱʦѧ','http://www.hebtu.edu.cn/','1308','7','0','0','0','0','0','539','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12403','ӱҽƴѧ','http://www.hebmu.edu.cn/','1308','6','0','0','0','0','0','316','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12404','ӱũҵѧ','http://www.hebau.edu.cn/','1308','5','0','0','0','0','0','419','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12405','ӱƼѧ','http://www.hebust.edu.cn/','1308','4','0','0','0','0','0','411','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12406','ӱѧ','http://www.heut.edu.cn/','1308','11','0','0','0','0','0','445','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12407','ӱóѧ','http://www.heuet.edu.cn/','1308','8','0','0','0','0','0','522','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12408','ӱƼʦѧԺ','http://www.hevttc.edu.cn/','1308','17','0','0','0','0','0','278','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12409','ʯׯѧԺ','http://www.sjzue.edu.cn/','1308','13','0','0','0','0','0','303','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12410','ú̿ҽѧԺ','http://www.ncmc.edu.cn/','1308','14','0','0','0','0','0','143','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12411','˾ѧԺ','http://www.cicp.edu.cn/','1308','10','0','0','0','0','0','357','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12412','ְҵѧԺ','http://www.hd-u.com/','1308','23','0','0','0','0','0','146','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12413','ӱ̴ѧ','http://www.hebeu.edu.cn/','1308','12','0','0','0','0','0','0','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12415','ӱýѧԺ','http://www.hebic.cn/','1308','25','0','0','0','0','0','181','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12416','ӱʯְҵѧԺ','http://www.pvtc.edu.cn/','1308','26','0','0','0','0','0','142','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12417','ɽҵְҵѧԺ','http://www.tsgzy.com.cn/','1308','27','0','0','0','0','0','110','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12418','ӱְҵѧԺ','http://www.cdtvc.com/','1308','28','0','0','0','0','0','124','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12419','ӱѧԺ','http://www.hepec.edu.cn/','1308','16','0','0','0','0','0','68','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12420','ɽʦѧԺ','http://www.tstc.edu.cn/','1308','18','0','0','0','0','0','188','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12421','еҽѧԺ','http://www.cdmc.edu.cn/','1308','19','0','0','0','0','0','162','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12422','̨ѧԺ','http://www.xttc.edu.cn/','1308','22','0','0','0','0','0','240','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12423','ʯׯְҵѧԺ','http://www.sjzpt.edu.cn/','1308','29','0','0','0','0','0','211','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12424','ӱѧԺ','http://www.bdcf.net/','1308','30','0','0','0','0','0','292','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12426','ƼѧԺ','http://www.ncist.edu.cn/','1308','20','0','0','0','0','0','264','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12428','ӱѧԺ','http://www.hebiace.edu.cn/','1308','32','0','0','0','0','0','197','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12429','ʯׯѧԺ','http://www.sjzri.edu.cn/','1308','33','0','0','0','0','0','794','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12430','ְҵѧԺ','http://www.bvtc.com.cn/','1308','34','0','0','0','0','0','199','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12431','ӱѧԺ','http://www.hebeinu.edu.cn/','1308','15','0','0','0','0','0','228','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12432','ӱ̴ѧ','http://www.hebeu.edu.cn/','1308','35','0','0','0','0','0','622','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12433','ˮѧԺ','http://www.hsnc.edu.cn/','1308','36','0','0','0','0','0','313','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12434','ɽѧԺ','http://www.tsc.edu.cn/','1308','21','0','0','0','0','0','158','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12435','ְ̨ҵѧԺ','http://www.xtvtc.edu.cn/','1308','37','0','0','0','0','0','208','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12436','ɹŴѧ','http://www.imu.edu.cn/','1309','1','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12437','ɹũҵѧ','http://www.imau.edu.cn/','1309','5','0','0','0','0','0','19','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12438','ɹſƼѧ','http://www.imust.cn/','1309','2','0','0','0','0','0','347','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12439','ɹʦѧ','http://www.imnu.edu.cn/','1309','6','0','0','0','0','0','31','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12440','ɹŲƾѧԺ','http://www.imfec.edu.cn/','1309','10','0','0','0','0','0','189','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12441','ɹŹҵѧ','http://www.imut.edu.cn/','1309','4','0','0','0','0','0','15','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12442','ɹѧ','http://www.imun.edu.cn/','1309','3','0','0','0','0','0','23','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12443','ɹҽѧԺ','http://www.immc.edu.cn/','1309','7','0','0','0','0','0','0','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12444','ͷṤְҵѧԺ','http://www.btqy.com.cn/','1309','12','0','0','0','0','0','79','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12445','ɹŹ㲥Ӵѧ','http://www.imrtvu.edu.cn/','1309','19','0','0','0','0','0','50','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12446','ɹóְҵѧԺ','http://www.nmsmxy.com/','1309','20','0','0','0','0','0','33','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12447','ͺְҵѧԺ','http://www.hhvc.net.cn/','1309','17','0','0','0','0','0','65','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12448','ͷְҵѧԺ','http://www.btsvc.edu.cn/','1309','11','0','0','0','0','0','98','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12449','ɹžְҵѧԺ','http://www.imppc.cn/','1309','18','0','0','0','0','0','104','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12450','˰ְҵѧԺ','http://www.nmxzy.cn/','1309','16','0','0','0','0','0','18','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12451','ƶְҵѧԺ','http://www.keqysxy.com.cn/','1309','14','0','0','0','0','0','21','0','','','0','0','0','0','','0');
INSERT INTO ylmf_site VALUES('12452','NULL','http://www.nmjtzy.com.cn/ְͨҵѧԺ','1309','13','0','0','0','0','0','7','0','','lwh','0','0','0','0','','0');
INSERT INTO ylmf_site VAL