/**
 * 155 Nav JavaScript Library v1.0.2
 *
 * Copyright 2012, Chihai Xu
 *
 * Date: Wed Jun 4 12:46:34 2012
 */
(function(window, undefined){

var win = window;
var doc = window.document;
var nav = window.navigator;
var loc = window.location;
var agent = window.navigator.userAgent;

String.prototype.trim = function(){return this.replace(/(^\s*)|(\s*$)/g, "");}

/* id: #container,  tag: <div>,  name: username, object: DOM object */
var Nav = (function(){


  function getElement(selector){
    if(typeof selector==="object" && selector.nodeType){
      return selector;
    }
    if(typeof selector==="string"){
      var result = null, body=doc.body||doc.getElementsByTagName("body")[0];
      if((result=/^#([\w-]+)$/.exec(selector))!==null){
        return doc.getElementById(result[1]);
      }else if((result=/^<(\w+)>$/.exec(selector))!==null){
        return body.getElementsByTagName(result[1]);
      }else if((result=/^\.([\w-]+)$/.exec(selector))!==null){
        var nodes=[],n=null,alls=body.getElementsByTagName("*");
        for(var i in alls){
          n = alls[i];
          if(n.className!==undefined && n.className.indexOf(result[1])>-1){
            nodes.push(n);
          }
        }
        return nodes;
      }else if((result=/^#([\w-]+)\s+\.([\w-]+)$/.exec(selector))!==null){
        var nodes=[],n=null,_top=doc.getElementById(result[1]);
        if(!_top){
           return null;
        }
        var alls=_top.getElementsByTagName("*");
        for(var i in alls){
          n = alls[i];
          if(n.className!==undefined && n.className.indexOf(result[2])>-1){
            nodes.push(n);
          }
        }
        return nodes;
      }else if((result=/^<(\w+)>\s+\.([\w-]+)$/.exec(selector))!==null){
        var nodes=[],n=null,alls=[],_tops=body.getElementsByTagName(result[1]);
        if(!_tops){
          return null;
        }
        for(var i=0;i<_tops.length;i++){
          alls = _tops[i].getElementsByTagName("*");
          for(var j in alls){
            n = alls[j];
            if(n.className!==undefined && n.className.indexOf(result[2])>-1){
              nodes.push(n);
            }
          }
        }
        return nodes;
      }else if((result=/^<(\w+)>\s+<(\w+)>$/.exec(selector))!==null){
        var nodes=[],n=null,alls=[],_tops=body.getElementsByTagName(result[1]);
        if(!_tops){
          return null;
        }
        for(var i=0;i<_tops.length;i++){
          alls = _tops[i].getElementsByTagName(result[2]);
          for(var j=0;j<alls.length;j++){
            nodes.push(alls[j]);
          }
        }
        return nodes;
      }else if((result=/^#([\w-]+)\s+<(\w+)>$/.exec(selector))!==null){
        var nodes=[], alls=[], _top = doc.getElementById(result[1]);
        alls = _top.getElementsByTagName(result[2]);
        for(var j=0;j<alls.length;j++){
          nodes.push(alls[j]);
        }
        return nodes;
      }else if(/^\w+$/.test(selector)){
        var nodes=[], alls = doc.getElementsByName(selector);
        for(var j=0;j<alls.length;j++){
          nodes.push(alls[j]);
        }
        return nodes;
      }
    }
    return null;
  }



  var Nav = function(selector){
    var xelement=[],_element=getElement(selector);

    if(_element===null || _element===undefined || _element.length===0){
      return null;
    }
    if(typeof _element==='object' && typeof _element.length==='number' && typeof _element.pop==="function" ){
      xelement = _element;
    }else{
      xelement[0] = _element;
    }
    return ({
      each : function(callback, args){
        var name, i=0, len=xelement.length;
        if(args){
          for(;i<len;i++){
            if(callback.apply(xelement[i], args)===false){
              break;
            }
          }
        }else{
          for(;i<len;i++){
            if(callback.call(xelement[i], i, xelement[i])===false){
              break;
            }
          }
        }
        return this;
      },


      val : function(value){
        if(value===undefined){
          if(xelement[0].value!==undefined){
            return xelement[0].value.trim();
          }else{
            return;
          }
        }else{
          this.each(function(i){
            if(this.value!==undefined){
              this.value = value;
            }
          });
        }
        return this;
      },

      text : function(value){
        if(value===undefined){
          if(xelement[0].innerText!==undefined){
            return xelement[0].innerText;
          }else{
            return;
          }
        }else{
          this.each(function(i){
            if(this.innerText!==undefined){
              this.innerText = value;
            }
          });
        }
        return this;
      },

      html : function(value){
        if(value===undefined){
          if(xelement[0].innerHTML!==undefined){
            return xelement[0].innerHTML;
          }else{
            return;
          }
        }else{
          this.each(function(i){
            if(this.innerHTML!==undefined){
              return this.innerHTML = value;
            }
          });
        }
        return this;
      },

      size : function(){
        return xelement.length;
      },

      css : function(name, value){
        if(typeof name==="object"){
          this.each(function(i){
             for(var p in name){
               p = camelCase(p);
               this.style[p] = name[p];
             }
          });
        }else if(typeof name==="string"){
          name = camelCase(name);
          if(arguments.length===1){
            return xelement[0].style[name];
          }else if(arguments.length===2 && typeof value==="string"){
            this.each(function(i){
              this.style[name] = value;
            });
          }
        }
        return this;
      },

      show : function(){
        this.each(function(i){
          this.style.display = "";
        });
        return this;
      },

      hide : function(){
        this.each(function(i){
          this.style.display = "none";
        });
        return this;
      },

      attr : function(name,value){
        if(arguments.length===1 && name!==undefined){
          return ((xelement[0][name]) ? xelement[0][name] : xelement[0].getAttribute(name));
        }else if(arguments.length===2 && name!==undefined && value!==undefined){
          this.each(function(i){
            if(this[name]!==undefined){
              this[name] = value;
            }else{
              this.setAttribute(name, value);
            }
          });
        }
        return this;
      },

      append : function(obj){
        if(typeof obj==="object" && obj.nodeType){
          this.each(function(){
            this.appendChild(obj);
          });
        }else if(typeof obj==="string" && (/^<\w+>$/.test(obj))){
          obj = document.createElement(obj.substring(1,obj.length-1));
          this.each(function(){
            this.appendChild(obj);
          });
        }
        return this;
      },

      bind : function(type, fn, capture){
        var type = type.replace(/^on/,"");
        var capture = (capture===undefined||capture!==true) ? false : true;
        this.each(function(){
          if(this.attachEvent){
            this.attachEvent('on'+type, fn);
          }else{
            this.addEventListener(type, fn, capture);
          }
        });
        return this;
      },

	  
      unbind : function(type, fn){
        var type = type.replace(/^on/,"");
        this.each(function(){
          if(this.detachEvent){
            this.detachEvent('on'+type, fn);
          }
		  else
		  {
            this.removeEventListener(type, fn, false);
          }
        });
        return this;
      },
	  
	  addClass : function(class_name){
	  this.each(function(){
		this.className = class_name;
		});
	  },
	  
	  removeClass : function (class_name){
	  this.each(function(){
		var classes = this.className;
		classes = classes.replace(class_name,'');
		this.className = classes;
		});
	  }

    });
  }

  return Nav;

})();

win.$j = win.Nav = Nav;

})(window);
/**
*
*/
var is_ie=document.all?true:false;
//ò ղ   ҳ

/*

*/

//¼
function stopUp(event)
{
	if(event.preventDefault)
	{
	event.preventDefault();
	}
	if(event.stopPropagation) 
	{
	event.stopPropagation(); 
	}
	if(window.event)
	{
	event.returnValue = false; 
	event.cancelBubble = true; 
	}
}

function stopBubble(event)
{
       //ṩ¼һIE
       if (event && event.stopPropagation )
       {
            event.stopPropagation();
       }
       else
       {
            //ҪʹIEķʽȡ¼ð
            window.event.cancelBubble = true;
       }
}


//¼
function mailLogin(){
	var api_login_list = {
		'y163':{
				'name':'@163.com',
				'postfix':'@163.com',
				'action':'reg.163.com/login.jsp?type=1&product=xunlei&url=http://entry.mail.163.com/coremail/fcg/ntesdoor2?style%3D-1%26lightweight%3D1%26verifycookie%3D1',
				"login":"username",
				"passwd":"password",
				'http_type':'https'
				},
		'y126':{
				'name':'@126.com',
				'postfix':'@126.com',
				'action':'reg.163.com/login.jsp?type=1&product=xunlei&url=http://entry.mail.126.com/cgi/ntesdoor?hid%3D10010102%26style%3D-1%26lightweight%3D1%26verifycookie%3D1',
				"login":"username",
				"passwd":"password",
				'http_type':'https'				
				},
		'yeah':{
				'name':'@yeah.net',
				'postfix':'@yeah.net',
				'action':'reg.163.com/login.jsp?type=1&product=xunlei&url=http://entry.yeah.net/cgi/ntesdoor?style%3D-1%26lightweight%3D1%26verifycookie%3D1',
				"login":"username",
				"passwd":"password",
				'http_type':'https'
				},
		"yahoo":{
				"name":"@yahoo.com.cn",
				"action":"edit.bjs.yahoo.com/config/login",
				"login":"login",
				"passwd":"passwd",
				"postfix":"@yahoo.com.cn",
				'http_type':'http',
				"vars":{"domainss":"yahoo",".intl":"cn",".src":"ym"}
				},
		"yahoocn":{
					"name":"@yahoo.cn",
					"action":"edit.bjs.yahoo.com/config/login",
					"login":"login",
					"passwd":"passwd",
					"postfix":"@yahoo.cn",
					'http_type':'http',
					"vars":{"domainss":"yahoo",".intl":"cn",".done":"http://mail.cn.yahoo.com/inset.html"}
					},
		"tom":{
				'name':'@tom.com',
				"action":"login.mail.tom.com/cgi/login",
				"login":"user",
				"passwd":"pass",
				"postfix":"",
				'http_type':'http'
				},
		"sina":{
				'name':'@sina.com',
				"action":"mail.sina.com.cn/cgi-bin/login.cgi",
				"login":"u",
				"passwd":"psw",
				"postfix":"",
				'http_type':'http'
				},
		"sohu":{
				"name":"@sohu.com",
				"action":"passport.sohu.com/login.jsp",
				"login":"loginid",
				"passwd":"passwd",
				"postfix":"@sohu.com",
				'http_type':'http',
				"vars":{"appid":"1000","ct":"1173080990","ru":"http://login.mail.sohu.com/servlet/LoginServlet",
				"fl":"1",
				"vr":"1|1",
				"sg":"5082635c77272088ae7241ccdf7cf062"}
				},
		"21cn":{
				"name":"@21cn.com",
				"action":"passport.21cn.com/maillogin.jsp",
				"login":"u",
				"passwd":"psw",
				"postfix":"@21cn.com",
				'http_type':'http',
				"vars":{"domainname":"21cn.com"}
				}
	};
	var api_link_list = {
		'renren':{
					'name':'',
					'action':'http://www.renren.com/'
				},
		'51':{
				'name':'51.com',
				'action':'http://www.51.com'
			},
		'139':{
				'name':'139',
				'action':'http://mail.10086.cn'
			},
		'alipay':{
					'name':'֧',
					'action':'https://www.alipay.com/'
				},
		 'qzone':{
					'name':'QQռ',
					'action':'http://qzone.qq.com/'
				},
		'webqq':{
					'name':'webqq',
					'action':'http://web2.qq.com/'
				},
		'sinaweibo':{
					'name':'΢',
					'action':'http://weibo.com'
				},
		'kaixin':{
					'name':'',
					'action':'http://www.kaixin001.com/'
				},
		'gmail':{
					'name':'gmail',
					'action':'https://accounts.google.com'
				},
		'hotmail':{
					'name':'hotmail',
					'action':'https://login.live.com'
				}
	};
	var self = this;
	var timer = null;
	this.createList = function(){
		var  mail_list = "<ul><li class=\"selectlist_t\">ѡ</li>";
		for(var i in api_login_list)
		{
			mail_list += "<li type=\""+i+"\" onclick=\"mail.selectMail('"+i+"')\">"+api_login_list[i].name+"</li>";
		}
		mail_list += "<li class=\"selectlist_t\">ڵҳ½</li>";
		for(var n in api_link_list)
		{
			mail_list += "<li type=\""+n+"\" onclick=\"mail.goToMail('"+n+"')\">"+api_link_list[n].name+"</li>";
		}
		mail_list += "</ul>"; 
		$j("#select_textlist").html(mail_list);
	};
	this.selectMail = function(key){
		$j("#selected_mail").html(api_login_list[key].name);
		$j("#login_goal").val(key);
		this.hideMailList();
	};
	this.goToMail = function(key){
		window.open(api_link_list[key].action);
		this.hideMailList();
	};
	this.showMailList = function(){
		this.createList();
		$j("#select_textlist").show();
	};
	this.hideMailList = function(){
		$j("#select_textlist").hide();
	};
	this.mailSubmit = function(){
		var name=$j("#155_mail_username").val();
		var pass=$j("#155_mail_passwd").val();
		var selected_mail = $j("#login_goal").val();
		if(name.replace(/\s/ig,"")==""||name.replace(/\s/ig,"")==window['defaultUserName']){
			alert("ûΪ"); 
			return false;
		}
		if(pass.replace(/\s/ig,"")==""||pass.replace(/\s/ig,"")==window['defaultUserPass']){
			alert("û벻Ϊ");
			return false;
		}
		
		if(selected_mail==undefined || selected_mail == 'selected_mail'){
			alert("ûѡ");
			return false;
		};
		var form=document.getElementById("155_mail_form");
		//Ƴ
		var arr=form.getElementsByTagName("input");
		for(var i=arr.length-1;i>=0;i--){
			if(arr[i].type=="hidden" && arr[i].id != 'login_goal')
				form.removeChild(arr[i]);
		}
		var site = api_login_list[selected_mail];
		form.setAttribute("action",site.http_type+"://"+site.action);
		var username=document.createElement("input");
		username.setAttribute("name",site.login);
		username.value=document.getElementById("155_mail_username").value+site.postfix;
		username.type="hidden";
		form.appendChild(username);

		var passwd=document.createElement("input");
		passwd.setAttribute("name",site.passwd);
		passwd.value=document.getElementById("155_mail_passwd").value;
		passwd.type="hidden";
		form.appendChild(passwd);
		document.getElementById("155_mail_passwd").value="";
		for(var e in site.vars){
			var input=document.createElement("input");
			input.setAttribute("name",e);
			input.type="hidden";
			input.value=site.vars[e];
			form.appendChild(input);
		}
		form.submit();
		$j("#155_mail_username").val('');
		$j("#155_mail_passwd").val('');
		return false;
	};
}
var mail = new mailLogin();
//ʼ
function bindShowMailPwd()
{
	var hide_timer = null;
	$j("#mail_box").bind('click',function(event){
		$j("#mail_pwd").show();
		stopBubble(event);
	});
	$j(parent.document).bind('click',hideMailPwd);
}
function hideMailPwd()
{
	$j("#mail_pwd").hide();
}
function shopTaobaoSearch1()
{
		if(window['xl_pvManually']!=undefined)
		{
		xl_pvManually("http://search.taobao.com/search?type=3");
		}
};
function shopTaobaoSearch2()
{
		if(window['xl_pvManually']!=undefined)
		{
			xl_pvManually("http://search.taobao.com/search?type=4");
		}
};
function shopSearch(){
	document.getElementById('ssForm').submit();
}







