<?php
/*
 * Author:Garry
 * http://www.PHPig.net
 * Version:PIGO2.2
 * ٷQQȺ:110772594
 * :phpignet@163.com
 */
 
class Page {
    private $totalNum;               // ܼ¼
    private $perPage;                // ÿҳʾ¼
    private $currPage;               // ǰҳ
    private $url;                    // ҳҳurl
    private $totalPages;             // ҳ
    private static $instance = null; // ҳʵ

	/**
	 * 캯
	 * param int $totalNum ܼ¼
	 * param int $perPage  ÿҳʾ¼
	 * return null
	 */
    private function __construct($totalNum, $perPage) {
        $this->totalNum = $totalNum;
        $this->perPage  = $perPage;
        $this->url = self::getUrl();
        $this->currPage = isset($_GET['page']) && is_numeric($_GET['page']) ? $_GET['page'] : 1;
        $this->totalPages = @ceil($this->totalNum / $this->perPage);
    }

    public static function getInstance($totalNum, $perPage) {
        if(self::$instance == null) {
            $c = __CLASS__;
            self::$instance = new $c($totalNum, $perPage);
        }
        return self::$instance;
    }

    public function makePageNav() {
        $pageStr = $numStr = '';
        if($this->totalPage == 1) {
            $pageStr = '';
        }
        else {
            $pageStr .= $this->makeFirstAndPrePage();
            if($this->totalPages <= 8) {
                for($i=1;$i<=$this->totalPages;$i++) {
                    $numStr .= self::makePg($i, $this->currPage, $this->url);
                }
            }
            else {
                $pre4PageUrl = $next4PageUrl = '';
                if ($this->currPage < 5) {
                    for($i=1;$i<=8;$i++) {
                        $numStr .= self::makePg($i, $this->currPage, $this->url);
                    }
                }
                else {
                    if($this->totalPages - $this->currPage >= 4) {
                        for($j=4;$j>=1;$j--) {
                            $a = $this->currPage-$j;
                            $b = $this->currPage+5-$j;
                            $pre4PageUrl .= "<a href='".str_replace("page={$this->currPage}", "page={$a}", $this->url)."'>{$a}</a>";
                            $next4PageUrl .= "<a href='".str_replace("page={$this->currPage}", "page={$b}", $this->url)."'>{$b}</a>";
                        }
                        $pageStr .= $pre4PageUrl."<strong>{$this->currPage}</strong>".$next4PageUrl;
                    }
                    else {
                        for($k=$this->totalPages-8;$k<=$this->totalPages;$k++) {
                            $numStr .= self::makePg($k, $this->currPage, $this->url);
                        }
                    }
                }
            }
            $pageStr .= $numStr;
            $pageStr .= $this->makeLastAndNextPage();
        }
        return $pageStr;
    }

	/**
	 * ҳһҳ
	 * return string
	 */
    private function makeFirstAndPrePage() {
        $str = '';
        if($this->currPage > 1) {
            if($this->currPage > 2) {
                $firstPageUrl = str_replace("page={$this->currPage}", "page=1", $this->url);
                $str .= "<a href='{$firstPageUrl}'><< ...</a>";
            }
            $prePage = $this->currPage-1;
            $prePageUrl = str_replace("page={$this->currPage}", "page={$prePage}", $this->url);
            $str .= "<a href='{$prePageUrl}'><<һҳ</a>";
        }
        return $str;
    }

	/**
	 * һҳβҳ
	 * return string
	 */
    private function makeLastAndNextPage() {
        $str = '';
        if($this->currPage < $this->totalPages) {
            $nextPage = $this->currPage+1;
            $nextPageUrl = str_replace("page={$this->currPage}", "page={$nextPage}", $this->url);
            $lastPageUrl = str_replace("page={$this->currPage}", "page={$this->totalPages}", $this->url);
            $str .= "<a href='{$nextPageUrl}'>һҳ>></a>";
            if($this->currPage < $this->totalPages-1) {
                $str .= "<a href='{$lastPageUrl}'>... >></a>";
            }
        }
        return $str;
    }

	/**
	 * ҳ
	 * return string
	 */
    private static function makePg($flagPg, $currPg, $url) {
        $reStr = '';
        if ($flagPg == $currPg) {
            $reStr = '<strong>'.$flagPg.'</strong>';
        }
        else {
            $reStr = "<a href='".str_replace("page={$currPg}", "page={$flagPg}", $url)."'>{$flagPg}</a>";
        }
        return $reStr;
    }

    private static function getUrl() {
        $url = '';
        $url = 'http://'.$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
        if (!ereg("(page=)", $url)) {
            if (!strpos($url,"?")) {
                $url = $url."?page=1";
            }
            else {
                $url = $url."&page=1";
            }
        }
        return $url;
    }
}
?>