<?php
Class WaterMark
{
var $src_image_name = "";                 
var $jpeg_quality = 100;                    
var $save_file = "";                      
var $googleweb_image_name = "";           
var $googleweb_image_pos = 3;             

var $googleweb_image_transition = 80;            

var $googleweb_text = "";                        
var $googleweb_text_size = 20;                   
var $googleweb_text_angle = 5;                   
var $googleweb_text_pos = 3;                     
var $googleweb_text_font = "";                   
var $googleweb_text_color = "#cccccc";           


function create($filename="")
{
  if ($filename) 
  {
   $this->src_image_name = strtolower(trim($filename));
  }
  
  $src_image_type = $this->getType($this->src_image_name);
  $src_image = $this->createImage($src_image_type,$this->src_image_name);
  if (!$src_image) return;
  $src_image_w=ImageSX($src_image);
  $src_image_h=ImageSY($src_image);

  if ($this->googleweb_image_name)
  {
         $this->googleweb_image_name = strtolower(trim($this->googleweb_image_name));
         $googleweb_image_type = $this->getType($this->googleweb_image_name);
         $googleweb_image = $this->createImage($googleweb_image_type,$this->googleweb_image_name);
         $googleweb_image_w=ImageSX($googleweb_image);
         $googleweb_image_h=ImageSY($googleweb_image);
         $temp_googleweb_image = $this->getPos($src_image_w,$src_image_h,$this->googleweb_image_pos,$googleweb_image);
         $googleweb_image_x = $temp_googleweb_image["dest_x"];
         $googleweb_image_y = $temp_googleweb_image["dest_y"];
         imagecopymerge($src_image,$googleweb_image,$googleweb_image_x,$googleweb_image_y,0,0,$googleweb_image_w,$googleweb_image_h,$this->googleweb_image_transition);
  }

  if ($this->googleweb_text)
  {
       $this->googleweb_text = iconv("utf-8", "UTF-8", $this->googleweb_text);
       $temp_googleweb_text = $this->getPos($src_image_w,$src_image_h,$this->googleweb_text_pos);
       $googleweb_text_x = $temp_googleweb_text["dest_x"];
       $googleweb_text_y = $temp_googleweb_text["dest_y"];
       if(preg_match("/([a-f0-9][a-f0-9])([a-f0-9][a-f0-9])([a-f0-9][a-f0-9])/i", $this->googleweb_text_color, $color))
       {
         $red = hexdec($color[1]);
         $green = hexdec($color[2]);
         $blue = hexdec($color[3]);
         $googleweb_text_color = imagecolorallocate($src_image, $red,$green,$blue);
       }
       else
       {
         $googleweb_text_color = imagecolorallocate($src_image, 255,255,255);
       }
     imagettftext($src_image, $this->googleweb_text_size, $this->googleweb_text_angle, $googleweb_text_x, $googleweb_text_y, $googleweb_text_color,$this->googleweb_text_font,  $this->googleweb_text);
  }

  if ($this->save_file)
  {
    switch ($this->getType($this->save_file))
    {
     case 'gif':$src_img=ImagePNG($src_image, $this->save_file); break;
     case 'jpeg':$src_img=ImageJPEG($src_image, $this->save_file, $this->jpeg_quality); break;
     case 'png':$src_img=ImagePNG($src_image, $this->save_file); break;
     default:$src_img=ImageJPEG($src_image, $this->save_file, $this->jpeg_quality); break;
    }
  }
  else
  {
  if ($src_image_type = "jpg") $src_image_type="jpeg";
    header("Content-type: image/{$src_image_type}");
    switch ($src_image_type)
    {
     case 'gif':$src_img=ImagePNG($src_image); break;
     case 'jpg':$src_img=ImageJPEG($src_image, "", $this->jpeg_quality);break;
     case 'png':$src_img=ImagePNG($src_image);break;
     default:$src_img=ImageJPEG($src_image, "", $this->jpeg_quality);break;
    }
  }
  imagedestroy($src_image);
}


function createImage($type,$img_name)
{
   if (!$type)
   {
        $type = $this->getType($img_name);
   }
   switch ($type)
   {
            case 'gif':
                  if (function_exists('imagecreatefromgif'))
                         $tmp_img=@imagecreatefromgif($img_name);
                  break;
            case 'jpg':
                  $tmp_img=imagecreatefromjpeg($img_name);
                  break;
            case 'png':
                  $tmp_img=imagecreatefrompng($img_name);
                  break;
            default:
                  $tmp_img=imagecreatefromstring($img_name);
                  break;
    }
    return $tmp_img;
}


function getPos($sourcefile_width,$sourcefile_height,$pos,$googleweb_image="")
{
  if  ($googleweb_image)
  {
      $insertfile_width = ImageSx($googleweb_image);
      $insertfile_height = ImageSy($googleweb_image);
  }
  else 
  {
      $lineCount = explode("\r\n",$this->googleweb_text);
      $fontSize = imagettfbbox($this->googleweb_text_size,$this->googleweb_text_angle,$this->googleweb_text_font,$this->googleweb_text);
      $insertfile_width = $fontSize[2] - $fontSize[0];
      $insertfile_height = count($lineCount)*($fontSize[1] - $fontSize[3]);
  }
  
  switch ($pos)
  {
    case 0:
       $dest_x = ( $sourcefile_width / 2 ) - ( $insertfile_width / 2 );
       $dest_y = ( $sourcefile_height / 2 ) - ( $insertfile_height / 2 );
       break;
  
    case 1:
       $dest_x = 0;
       if ($this->googleweb_text)
       {
           $dest_y = $insertfile_height;
       }
       else
       {
           $dest_y = 0;
       }
       break;
  
    case 2:
      $dest_x = $sourcefile_width - $insertfile_width;
      if ($this->googleweb_text)
      {
         $dest_y = $insertfile_height;
      }
      else
      {
          $dest_y = 0;
      }
      break;
  
    case 3:
      $dest_x = $sourcefile_width - $insertfile_width;
      $dest_y = $sourcefile_height - $insertfile_height;
      break;
  
    case 4:
      $dest_x = 0;
      $dest_y = $sourcefile_height - $insertfile_height;
      break;
  
    case 5:
     $dest_x = ( ( $sourcefile_width - $insertfile_width ) / 2 );
     if ($this->googleweb_text)
     {
        $dest_y = $insertfile_height;
     }
     else
     {
        $dest_y = 0;
     }
     break;
  
    case 6:
     $dest_x = $sourcefile_width - $insertfile_width;
     $dest_y = ( $sourcefile_height / 2 ) - ( $insertfile_height / 2 );
     break;
  
    case 7:
     $dest_x = ( ( $sourcefile_width - $insertfile_width ) / 2 );
     $dest_y = $sourcefile_height - $insertfile_height;
     break;
  
    case 8:
     $dest_x = 0;
     $dest_y = ( $sourcefile_height / 2 ) - ( $insertfile_height / 2 );
     break;
  
    default:
      $dest_x = $sourcefile_width - $insertfile_width;
      $dest_y = $sourcefile_height - $insertfile_height;
      break;
  }
  return array("dest_x"=>$dest_x,"dest_y"=>$dest_y);
}


function getType($img_name)//获取图像文件类型
{
  if ($img_name == "") 
  {
    return ;
  }
  
  $fileParts = pathinfo($img_name);
  $ext = $fileParts['extension'] ? strtolower($fileParts['extension']) : 'string';
  if(!('jpg'==$ext || 'jpeg'==$ext || 'gif'==$ext || 'png'==$ext))$ext='string';
  return $ext;

}

}
?>