<?php

 
include_once dirname(__FILE__).'/thirdpart/phpmailer/class.phpmailer.php';
include_once dirname(__FILE__).'/thirdpart/phpmailer/class.smtp.php';

class KuwebsMailer {

  static private $from = null;
  
  function __construct()
  {
  }

  static private function escapeHead($string, $encoding='GBK')
  {
    $string  = mb_convert_encoding($string, $encoding, "UTF-8");
    return '=?' . $encoding . '?B?'. base64_Encode($string) .'?=';
  }

  static private function escapePart($string, $encoding='GBK')
  {
    $string = mb_convert_encoding($string, $encoding, 'UTF-8');
    return preg_replace_callback( '/([\x80-\xFF]+.*[\x80-\xFF]+)/' ,create_function ( '$m' ,"return \"=?$encoding?B?\".base64_encode(\$m[1]).\"?=\";") ,$string);
  }
  
  
  static function sendMail($from, $to, $subject, $message, $options=null, $bcc=array())
  {
    global $INI; $from = "{$INI['system']['sitename']} <{$from}>";
    if ( !isset($options['encoding']) )
      $options['encoding']   = 'UTF-8';

    if ( !isset($options['contentType']) )
      $options['contentType'] = 'text/plain';

    if ( 'UTF-8'!=$options['encoding'] )
      $message = mb_convert_encoding($message, $options['encoding'], 'UTF-8');

    $message = chunk_split(base64_encode($message));
    $subject = self::escapeHead($subject, $options['encoding']);
    $from = self::escapePart($from, $options['encoding']);
    $to = self::escapePart($to, $options['encoding']);

    $headers = array(
        "Mime-Version: 1.0",
        "Content-Type: {$options['contentType']}; charset={$options['encoding']}",
        "Content-Transfer-Encoding: base64",
        "X-Mailer: ZTMailer/1.0",
        "From: {$from}",
        "Reply-To: {$from}",
        );
    if ($bcc) { 
      $bcc = join(', ', $bcc);
      $headers[] = "Bcc: {$bcc}";
    }
    $headers = join("\r\n", $headers);

    if ( isset($options['messageId']) )
      $headers["Message-Id"] = "<$options[messageId]>";

    return mail($to, $subject, $message, $headers);
  }

  static function smtpMail($from, $to, $subject, $message, $options=null, $bcc=array())
  {
		global $kuWebsiteMailSmtpHost, $kuWebsiteMailSmtpPort, $kuWebsiteMailSmtpUserName, $kuWebsiteMailSmtpPassword, $kuWebsiteMailSmtpSender, $kuWebsiteMailSmtpReceiver;
    
    if ( !isset($options['encoding']) )
      $options['encoding']   = 'UTF-8';

    if ( !isset($options['contentType']) )
      $options['contentType'] = 'text/plain';

    if ( 'UTF-8'!=$options['encoding'] )
      $message = mb_convert_encoding($message, $options['encoding'], 'UTF-8');
    global $INI;
    
    $host = $kuWebsiteMailSmtpHost;
    $port = $kuWebsiteMailSmtpPort;
    $ssl = false;
    $user = $kuWebsiteMailSmtpUserName;
    $pass = $kuWebsiteMailSmtpPassword;
    $from = $kuWebsiteMailSmtpSender;
    $reply = $kuWebsiteMailSmtpReceiver;
    $site = "test";

    $subject = self::escapeHead($subject, $options['encoding']);
    $site = self::escapeHead($site, $options['encoding']);
    $body = $message;

    $ishtml = 1; //($options['contentType']=='text/html');
    //begin
    $mail = new PHPMailer();
    $mail->IsSMTP(); 
    $mail->CharSet = $options['encoding'];
    $mail->SMTPAuth   = true; 
    $mail->Host = $host;
    $mail->Port = $port;
    if ( $ssl=='ssl' ) {
      $mail->SMTPSecure = "ssl"; 
    } else if ( $ssl == 'tls' ) {
      $mail->SMTPSecure = "tls"; 
    }
    $mail->Username = $user;
    $mail->Password = $pass;
    $mail->SetFrom($from, $site);
    $mail->AddReplyTo($reply, $site);
    foreach($bcc AS $bo) {
      $mail->AddBCC($bo);
    }
    $mail->Subject = $subject;
    if ( $ishtml ) {
      $mail->MsgHTML($body);
    } else {
      $mail->Body = $body;
    }
    $mail->AddAddress($to);
    return $mail->Send();
  }
}


?>
