<?php

class Pages
{
  var $disp_be_switch; //是否显示第一页和最后一页 
  var $disp_result_number; //每页显示的记录数 
  var $pagesNum; //总页数 var $dispPagesNum; //显示页数 
  var $currentPage; //当前页 
  var $previousPageDefault;
  var $nextPageDefault;
  var $firstPageDefault;
  var $lastPageDefault;
  var $disp_type = array (1 => array (array ('上一页', '下一页' ), ' ', array ('<a class="this" ><span>', '</span></a>' ) ), 

  2 => array (array ('上一页', '下一页' ), ' ', array ('<font color=red>〖', '〗</font>' ) ), 

  3 => array (array ('上一页', '下一页' ), ' ', array ('[', ']' ) ), 

  4 => array (array ('上一页', '下一页' ), ' ', array ('〖', '〗' ) ), 

  5 => array (array ('上一页', '下一页' ), ' ', array ('[', ']' ) ), 

  6 => array (array ('上一页', '下一页' ), ' ', array ('<font color=red>[', ']</font>' ) ) ); //默认的几种样式 
  

  
  function Pages($resultNumber, $current, $rowNum, $dispNum = 5, $type = 6, $be_switch = true, $firstPageDefault = '第一页', $previousPageDefault = '上一页', $nextPageDefault = '下一页', $lastPageDefault = '最后一页', $kuWebsiteCurrHTMLType='.html', $kuFrontStartCreateHTMLFlag=1)
  {
    if ($type > 6 || $type < 0) $type = 6;
    $this->pagesNum = @ceil ( $resultNumber / $rowNum ); //总页数 
    if(0 == $this->pagesNum){$this->pagesNum = 1;}//如果总页数0则设置成1
    $this->currentPage = $current; //当前页数 
    $this->disp_result_number = $rowNum; //每页显示的记录数 
    $this->dispPagesNum = $dispNum; //显示的活动页数 
    $this->disp_type = $this->disp_type [$type]; //分页的样式 
    $this->disp_be_switch = $be_switch; //是否显示第一页和最后一页 
    $this->firstPageDefault = $firstPageDefault; //第一页
    $this->previousPageDefault = $previousPageDefault; //上一页
    $this->nextPageDefault = $nextPageDefault; //下一页
    $this->lastPageDefault = $lastPageDefault; //最后一页
    $this->disp_type [0] [0] = $this->previousPageDefault;
    $this->disp_type [0] [1] = $this->nextPageDefault;
  }
  
  
  function setOtherDispParam($previous_and_next, $height_light, $over)
  {
    $this->disp_type = null;
    $this->disp_type = array ($previous_and_next, $over, $height_light );
  }
  
  
  function disp($param = 'page', $pageurl = '')
  {
    global $HTTP_SERVER_VARS;
    if (! $pageurl)
    {
      $pageurl = "http://" . $HTTP_SERVER_VARS ['HTTP_HOST'] . $_SERVER ['PHP_SELF']; //当前文件路径 
    }
    $middle = ( int ) ($this->dispPagesNum / 2); //中间数 
    $startRow = 1; //开始下标 
    $endRow = $this->pagesNum; //结束下标 
    $previous = true; //有前导 ：上一页，默认是上一页（可以为后期的分页技术样式做出扩展，是否需要默认上一页和上一页）
    $next = true; //有后导 ：下一页，默认是下一页 
    if ($this->currentPage > $middle + 1)
    {
      $previous = true; //将前导设置为有 
      if ($this->pagesNum > $this->dispPagesNum)
      {
        $startRow = ($this->currentPage < $this->pagesNum - $middle) ? $this->currentPage - $middle : ($this->pagesNum - $this->dispPagesNum) + 1; //将开始下标设置成:[当前页数 < 总页数 - 中间页数] ? 是[ 当前页-中间页 ] : 否[ 总页数 - 显示宽度 ]+1 
      }
      else
      {
        $startRow = ($this->currentPage < $this->pagesNum - $middle) ? $this->currentPage - $middle : 1;
      }
    }
    else
    {
      $startRow = 1; //设置下标为第一页 
    }
    if ($this->currentPage < $this->pagesNum - $middle)
    {
      $next = true; //将后导设置为有 
      if ($this->pagesNum > $this->dispPagesNum)
      {
        $endRow = ($startRow < $middle) ? $endRow = $this->dispPagesNum : $this->currentPage + $middle; //将结束下标设置成:[开结行 < 中间行] ? 是[显示宽度] : 否[当前页 + 中间行]   
      }
      else
      {
        $endRow = ($startRow < $middle) ? $endRow = $this->pagesNum : $this->currentPage + $middle;
      }
    }
    else
    {
      $endRow = $this->pagesNum; //将结束行设置成总页数 
    }
    
    $out = ''; //用于输出的字串 
    for($i = $startRow; $i < $endRow + 1; $i ++)
    {
      if ($this->currentPage == $i)
      {
        $out .= "{$this->disp_type[2][0]}{$i}{$this->disp_type[2][1]} "; //当前页显示情况
      }
      else
      {
        $out .= "<a href=\"{$pageurl}&{$param}={$i}\"><span>{$i}</span></a>"; //非当前页显示情况
      }
    }
    
    if (! ($previousPage = $this->currentPage - 1))
    {
      $previousPage = 1;
    }
    
    if (($nextPage = $this->currentPage + 1) > $this->pagesNum)
    {
      $nextPage = $this->pagesNum;
    }
    
    if ($previous)
    { //如果有前导,加上前导 
      if ($this->disp_be_switch) //是否显示最前页 
      {
        $out = "<a href=\"{$pageurl}&{$param}=1\"><span>{$this->firstPageDefault}</span></a><a href=\"{$pageurl}&{$param}={$previousPage}\"><span>{$this->disp_type[0][0]}</span></a> {$this->disp_type[1]} {$out}";
      }
      else
      {
        $out = "<a href=\"{$pageurl}&{$param}={$previousPage}\"><span>{$this->disp_type[0][0]}</span></a> {$this->disp_type[1]} {$out}";
      }
    }
    
    if ($next)
    { //如果有后导,加上后导 
      if ($this->disp_be_switch) //是否显示最后页
      {
        $out .= " {$this->disp_type[1]} <a href=\"{$pageurl}&{$param}={$nextPage}\"><span>{$this->disp_type[0][1]}</span></a> <a href=\"{$pageurl}&{$param}={$this->pagesNum}\"><span>{$this->lastPageDefault}</span></a>";
      }
      else
      {
        $out .= " {$this->disp_type[1]} <a href=\"{$pageurl}&{$param}={$nextPage}\"><span>{$this->disp_type[0][1]}</span></a>";
      }
    }
    return $out;
  }
  
  
  function getCountPages()
  {
    return $this->dispPagesNum;
  }
  
  
  function getCountResult()
  {
    return $this->disp_result_number;
  }
  
  
  function getCurrentPageStart()
  {
    return $this->getCurrentPageEnd () - $this->disp_result_number;
  }
  
  
  function getCurrentPageEnd()
  {
    return $this->currentPage * $this->disp_result_number;
  }
  
  
  function getCurrentPageNumber()
  {
    return $this->currentPage;
  }
}

?>