<?php
require_once './inc/common.inc.php';

function replaceHtmlAndJs($document)
{
  $document = trim($document);
  if (strlen($document) <= 0)
  {
       return $document;
  }
  $search = array ("'<script[^>]*?>.*?</script>'si",  // Remove javascript
                    "'<[\/\!]*?[^<>]*?>'si",          // Remove HTML
                    "'([\r\n])[\s]+'",                // Remove black
                    "'&(quot|#34);'i",                // Replace HTML
                    "'&(amp|#38);'i",
                    "'&(lt|#60);'i",
                    "'&(gt|#62);'i",
                    "'&(nbsp|#160);'i"
                    );                    
  
  $replace = array ("",
                     "",
                     "\\1",
                     "\"",
                     "&",
                     "<",
                     ">",
                     " "
                   );
  return @preg_replace ($search, $replace, $document);
}

function getKeyWordStr($str, $keyWord, $getStrLen) 
{ 
  if(cnStrLen($str) > $getStrLen) 
  { 
    $strlen = cnStrLen($keyWord); 
    $strpos = cnStrPos($str, $keyWord); 
    $halfStr = intval(($getStrLen-$strlen)/2); 
    if($strpos != "")
    { 
      if($strpos >= $halfStr)
      { 
        $str = cnSubStr($str, ($strpos - $halfStr), $halfStr).$keyWord.cnSubStr($str, ($strpos + $strlen), $halfStr); 
      }
      else
      {
        $str = cnSubStr($str, ($strpos - $halfStr), $strpos).$keyWord.cnSubStr($str, ($strpos + $strlen), ($halfStr*2)); 
      } 
    }
    else
    { 
      $str = cnSubStr($str, 0, $getStrLen); 
    } 
    $str=str_replace('<p>', '&nbsp;', $str); 
    $str=str_replace('</p>', '&nbsp;', $str); 
    $str=str_replace('<br />', '&nbsp;', $str); 
    $str=str_replace('<br>', '&nbsp;', $str); 
    return str_replace($keyWord, '<span style="font-size: 12px; color: #F30;">'.$keyWord.'</span>', $str).'...'; 
  } 
  else 
  { 
    return str_replace($keyWord, '<span style="font-size: 12px; color: #F30;">'.$keyWord.'</span>', $str); 
  } 
}

function cnStrLen($str) 
{ 
  $i = 0; 
  $tmp = 0; 
  while ($i < strlen($str)) 
  { 
    if (ord(substr($str,$i,1)) > 127) 
    { 
      $tmp = $tmp + 1; $i = $i + 3; 
    } 
    else 
    { 
      $tmp = $tmp + 1;; $i = $i + 1; 
    } 
  } 
  return $tmp; 
}


function cnStrPos($str, $keyWord) 
{ 
  $i = 0;
  $tem = 0; 
  $temStr = strpos($str, $keyWord); 
  while ($i < $temStr) 
  { 
    if (ord(substr($str, $i, 1)) >127) 
    { 
      $tmp = $tmp + 1; 
      $i = $i + 3; 
    } 
    else 
    { 
      $tmp = $tmp + 1;
      $i = $i + 1; 
    } 
  } 
  return $tmp; 
}

function cnSubStr($str, $start, $lenth) 
{ 
  $len = strlen($str); 
  $r = array(); 
  $n = 0; 
  $m = 0; 
  for($i = 0; $i < $len; $i++) 
  { 
    $x = substr($str, $i, 1); 
    $a = base_convert(ord($x), 10, 2); 
    $a = substr('00000000'.$a, -8); 
    if ($n < $start)
    { 
      if (substr($a, 0, 1) == 0) { }
      elseif (substr($a, 0, 3) == 110) 
      { 
        $i += 1; 
      }
      elseif (substr($a, 0, 4) == 1110) 
      { 
        $i += 2; 
      } $n++; 
    }
    else
    { 
      if (substr($a, 0, 1) == 0) 
      { 
        $r[] = substr($str, $i, 1); 
      }
      elseif (substr($a, 0, 3) == 110) 
      { 
        $r[] = substr($str, $i, 2); 
        $i += 1; 
      }
      elseif (substr($a, 0, 4) == 1110) 
      { 
        $r[] = substr($str, $i, 3); 
        $i += 2; 
      }
      else
      { 
        $r[] = ''; 
      } 
      if (++$m >= $lenth)
      { break; } 
    } 
  } 
  return join('', $r); 
} 


$searchkeyword = filterSearch($searchkeyword);
if(empty($searchmodelflag)){$searchmodelflag = 'all';} //如果高级搜索时，没有选定所属模块，则进行全站搜索
if(!empty($searchkeyword) && !empty($searchmodelflag))
{
  
  $kuBlockSearchTitle = $searchkeyword; 
  $kuWebsitePageTitle = $kuBlockSearchTitle.' - '.$kuWebsiteTitleKeyWords.' - '.$kuWebsiteTitle.$kuPostfix;
  $kuWebsiteKeyWords = $searchkeyword;
  $kuWebsiteDescription = $searchkeyword.',搜索';
  
  
  $kuArrSearchList = array();
  if('all' == $searchmodelflag)
  {
    for($iModule=1; $iModule<=8; $iModule++)
    {
      //echo $arrAllModule[$iModule];
      $strSql = "select id, {$arrAllModule[$iModule]}title, {$arrAllModule[$iModule]}content from {$configTableHead}{$arrAllModule[$iModule]} where ({$arrAllModule[$iModule]}title like '%{$searchkeyword}%' or {$arrAllModule[$iModule]}content like '%{$searchkeyword}%') and lang='{$kuWebsiteCurrLanguage}';";
      //echo $strSql;
      $searchList = $dbInstance->getList($strSql);
      foreach($searchList as $item)
      {
        if(1 == $iModule)$item['searchurl'] = $kuHttpPath.$arrAllModule[$iModule]."/index.php?lang={$lang}&menuid={$item['id']}";
        else $item['searchurl'] = $kuHttpPath.$arrAllModule[$iModule]."/{$arrAllModule[$iModule]}.php?lang={$lang}&itemid={$item['id']}";
        $item['title'] = getKeyWordStr(replaceHtmlAndJs($item["{$arrAllModule[$iModule]}title"]), $searchkeyword, 50);
        $item['content'] = getKeyWordStr(replaceHtmlAndJs($item["{$arrAllModule[$iModule]}content"]), $searchkeyword, 80);
        array_push($kuArrSearchList, $item);
      }
    }
  }
  else if(1 <= $searchmodelflag && $searchmodelflag <= 8)
  {
    $iModule = $searchmodelflag;
    $strSql = "select id, {$arrAllModule[$iModule]}title, {$arrAllModule[$iModule]}content from {$configTableHead}{$arrAllModule[$iModule]} where ({$arrAllModule[$iModule]}title like '%{$searchkeyword}%' or {$arrAllModule[$iModule]}content like '%{$searchkeyword}%') and lang='{$kuWebsiteCurrLanguage}';";
    //echo $strSql;
    $searchList = $dbInstance->getList($strSql);
    foreach($searchList as $item)
    {
      if(1 == $iModule)$item['searchurl'] = $kuHttpPath.$arrAllModule[$iModule]."/index.php?lang={$lang}&menuid={$item['id']}";
      else $item['searchurl'] = $kuHttpPath.$arrAllModule[$iModule]."/{$arrAllModule[$iModule]}.php?lang={$lang}&itemid={$item['id']}";
      $item['title'] = getKeyWordStr(replaceHtmlAndJs($item["{$arrAllModule[$iModule]}title"]), $searchkeyword, 50);
      $item['content'] = getKeyWordStr(replaceHtmlAndJs($item["{$arrAllModule[$iModule]}content"]), $searchkeyword, 80);
      array_push($kuArrSearchList, $item);
    }
  }
  
  
  
  
  $totalNumber = count($kuArrSearchList);
  !empty($page) ? ($page = intval($page)) : $page =1;                            //当前页
  $type = $frontendPagingType;                                                   //分页样式0-5 
  $startNum = ($page - 1) * $kuWebsitePagingNumbersearch;
  $kuArrSearchList = @array_slice($kuArrSearchList, $startNum, $kuWebsitePagingNumbersearch, true);
  //print_r($kuArrSearchList);//die();
  
  $kuStrSearchResult = '';
  foreach($kuArrSearchList as $item)
  {
    $kuStrSearchResult .= "<dl class='search search{$item[id]}'><dt><span class='more right'><a href='{$item[searchurl]}' target='_blank'>{$kuCaptionCommonViewDeatils}</a></span><a href='{$item[searchurl]}' target='_blank'>{$item[title]}</a></dt><dd>{$item[content]}</dd></dl>";
  }

  include_once('./inc/pages.class.php');
  $instancePage = new Pages($totalNumber, $page, $kuWebsitePagingNumbersearch, $frontendPagingActionsDisplayNumber, $type, $frontendPagingIsAlwaysShowFirstOrLast, $kuCaptionPagingFirstPage, $kuCaptionPagingPreviousPage, $kuCaptionPagingNextPage, $kuCaptionPagingLastPage);
  $kuPageLinks = $instancePage->disp('page', "search.php?lang={$kuWebsiteCurrLanguage}&searchkeyword={$searchkeyword}&searchmodelflag={$searchmodelflag}");

}

if('' == $kuStrSearchResult)$kuStrSearchResult = $kuCaptionSearchNotContain." [<font color=red>".removeXSS($searchkeyword)."</font>] ".$kuCaptionSearchContentInformation;


$strSql = "select menutitle, menumodule from {$configTableHead}menu where lang='{$kuWebsiteCurrLanguage}' and (navshow = 2 or navshow = 4) and menutype=1";
$kuSearchModel = $dbInstance->getList($strSql);
foreach($kuSearchModel as $key=>$value)$kuStrSearchModel .= "<option value='{$value[menumodule]}'>{$value['menutitle']}</option>";


$kuStrBlockContact = $kuBlock[2];


include_once KUWEBS_ABSOLUTE_PATH."inc/headermenu.php"; 
include_once KUWEBS_ABSOLUTE_PATH."inc/footer.php";
include_once template('search');
?>