﻿/*-----------------------------------------------Andrew_Typeahead-----------------------------------------*/
(function($){
    var Andrew_Typeahead = function (element, options) {
        this.$element = $(element);
        this.options = $.extend(true, {}, $.fn.Andrew_Typeahead.defaults, options);
        this.$menu = $(this.options.menu).appendTo('body');
        this.shown = false;
        // Method overrides
        this.eventSupported = this.options.eventSupported || this.eventSupported;
        this.grepper = this.options.grepper || this.grepper;
        this.highlighter = this.options.highlighter || this.highlighter;
        this.lookup = this.options.lookup || this.lookup;
        this.matcher = this.options.matcher || this.matcher;
        this.render = this.options.render || this.render;
        this.init = this.options.init || this.init;
        this.ele_show = this.options.ele_show || this.ele_show;
        this.select = this.options.select || this.select;
        this.sorter = this.options.sorter || this.sorter;
        this.source = this.options.source || this.source;
        if (!this.source.length) {
            var ajax = this.options.ajax;
            if (typeof ajax === 'string') {
                this.ajax = $.extend({}, $.fn.Andrew_Typeahead.defaults.ajax, { url: ajax });
            } else {
                this.ajax = $.extend({}, $.fn.Andrew_Typeahead.defaults.ajax, ajax);
            }
            if (!this.ajax.url) {
                this.ajax = null;
            }
        }
        this.init();
        this.listen();
    };
    Andrew_Typeahead.prototype = {
        constructor: Andrew_Typeahead,
        init: function () {
            var that = this;
            that.$element.bind('focus', function() {
                that.ele_show(1);
                that.$menu.children("ul").hide();
            });
            that.$element.bind('input propertychange', function() {
                that.ele_show(1);
                if (that.$menu.children("ul").find("li").length > 0) {
                    that.$menu.children("ul").show();
                } else {
                    that.$menu.children("ul").hide();
                }
                if (that.$element.val().length==0) {
                    that.$menu.children("ul").empty();
                    that.$element.blur();
                }
            });
        },
        ele_show:function(flag){
            var that = this;
            if(flag){
                that.$menu.on("touchmove",function(event){
                    event.preventDefault();
                });
            }else{
                that.$menu.unbind("touchmove");
            }
            that.$menu.css({
                "top": that.$element.parent().parent().outerHeight(),
                "left": "0",
                "width": "100%"
            });
            that.$menu.children("ul").addClass("scrolling").css({
                "overflow-y": "scroll",
                "height": $(window).height()
            });
            that.$element.parent().parent().addClass("ak-is_search w_100 zindex_show fix top_0 left_0");
            $("header").hide();
            $("main").addClass("mt_0").removeClass("scrolling");
            $(window).bind('hashchange', function () {
                that.$menu.remove();
                $("header").show();
                $("main").removeClass("mt_0").addClass("scrolling");
            });
            that.$menu.fadeIn();
            that.options.showCallBack(that.$menu);
            that.shown = true;
        },
        //  Check if an event is supported by the browser eg. 'keypress'
        eventSupported: function(eventName) {
            var isSupported = (eventName in this.$element);
            if (!isSupported) {
                this.$element.setAttribute(eventName, 'return;');
                isSupported = typeof this.$element[eventName] === 'function';
            }
            return isSupported;
        },
        //  Handle AJAX source
        ajaxer: function () {
            var that = this,
                query = that.$element.val();
            if (query === that.query) {
                return that;
            }
            // Query changed
            that.query = query;
            // Cancel last timer if set
            if (that.ajax.timerId) {
                clearTimeout(that.ajax.timerId);
                that.ajax.timerId = null;
            }
            if (!query || query.length < that.ajax.triggerLength) {
                // Cancel the ajax callback if in progress
                if (that.ajax.xhr) {
                    that.ajax.xhr.abort();
                    that.ajax.xhr = null;
                    that.ajaxToggleLoadClass(false);
                }
                return that.shown ? that.hide() : that;
            }
            // Query is good to send, set a timer
            that.ajax.timerId = setTimeout(function() {
                $.proxy(that.ajaxExecute(query), that)
            }, that.ajax.timeout);
            return that;
        },
        //  Execute an AJAX request
        ajaxExecute: function(query) {
            this.ajaxToggleLoadClass(true);
            // Cancel last call if already in progress
            if (this.ajax.xhr) this.ajax.xhr.abort();
            var params = this.ajax.preDispatch ? this.ajax.preDispatch(query) : { query : query };
            var jAjax = (this.ajax.method === "post") ? $.post : $.get;
            this.ajax.xhr = jAjax(this.ajax.url, params, $.proxy(this.ajaxLookup, this));
            this.ajax.timerId = null;
        },
        //  Perform a lookup in the AJAX results
        ajaxLookup: function (data) {
            var items;
            this.ajaxToggleLoadClass(false);
            if (!this.ajax.xhr) return;
            if (this.ajax.preProcess) {
                data = this.ajax.preProcess(data);
            }
            // Save for selection retreival
            this.ajax.data = data;
            items = this.grepper(this.ajax.data);
            if (!items || !items.length) {
                return this.shown ? this.hide() : this;
            }
            this.ajax.xhr = null;
            return this.render(items.slice(0, this.options.items)).show();
        },
        //  Toggle the loading class
        ajaxToggleLoadClass: function (enable) {
            if (!this.ajax.loadingClass) return;
            this.$element.toggleClass(this.ajax.loadingClass, enable);
        },
        //  Search source
        lookup: function (event) {
            var that = this,
                items;
            if (that.ajax) {
                that.ajaxer();
            }
            else {
                that.query = that.$element.val();
                if (!that.query) {
                    return that.shown ? that.hide() : that;
                }
                items = that.grepper(that.source);
                if (!items || !items.length) {
                    return that.shown ? that.show() : that;
                }
                return that.render(items.slice(0, that.options.items)).show();
            }
        },
        //  Filters relevent results
        grepper: function(data) {
            var that = this,
                items;
            if (data && data.length && !data[0].hasOwnProperty(that.options.display)) {
                return null;
            }
            items = $.grep(data, function (item) {
                return that.matcher(item[that.options.display], item);
            });
            return this.sorter(items);
        },
        //  Looks for a match in the source
        matcher: function (item) {
            return ~item.toLowerCase().indexOf(this.query.toLowerCase());
        },
        //  Sorts the results
        sorter: function (items) {
            var that = this,
                beginswith = [],
                caseSensitive = [],
                caseInsensitive = [],
                item;
            while (item = items.shift()) {
                if (!item[that.options.display].toLowerCase().indexOf(this.query.toLowerCase())) {
                    beginswith.push(item);
                }
                else if (~item[that.options.display].indexOf(this.query)) {
                    caseSensitive.push(item);
                }
                else {
                    caseInsensitive.push(item);
                }
            }
            return beginswith.concat(caseSensitive, caseInsensitive);
        },
        //  Shows the results list
        show: function () {
            var that = this;
            that.ele_show();
            this.$menu.bind("touchstart", function() {
                document.activeElement.blur();//隐藏键盘
            });
            return this;
        },
        //  Hides the results list
        hide: function () {
            this.$element.parent().parent().removeClass("ak-is_search w_100 zindex_show fix top_0 left_0");
            $("header").show();
            $("main").removeClass("mt_0").addClass("scrolling");
            this.$menu.hide();
            this.shown = false;
            return this;
        },
        //  Highlights the match(es) within the results
        highlighter: function (item) {
            var query = this.query.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, '\\$&');
            return item.replace(new RegExp('(' + query + ')', 'ig'), function ($1, match) {
                return '<strong>' + match + '</strong>';
            });
        },
        //  Renders the results list
        render: function (items) {
            var that = this;
            this.$menu.html("<ul />");
            items = $(items).map(function (i, item) {
                i = $(that.options.item).attr('data-value', item[that.options.val]);
                i.html(that.highlighter(item[that.options.display], item));
                return i[0];
            });
            items.first().addClass("ak-is_active");
            this.$menu.children("ul").html(items);
            return this;
        },
        //  Item is selected
        select: function () {
            var that = this;
            var $selectedItem = this.$menu.find('.ak-is_active');
            setTimeout(function () {
                document.activeElement.blur();//隐藏键盘
                that.hide();
                that.$element.val($selectedItem.text()).change();
            }, 150);
            if (this.$element.val != "") {
                //this.$menu.find('li').unbind("click");
                this.$menu.find('li').on('click', function(e) {
                    e.stopPropagation();
                    that.hide();
                });
            }
            this.$menu.children("ul").empty();
            this.options.itemSelected($selectedItem, $selectedItem.attr('data-value'), $selectedItem.text());
            return;
        },
        //  Selects the next result
        next: function (event) {
            var active = this.$menu.find('.ak-is_active').removeClass("ak-is_active");
            var next = active.next();
            if (!next.length) {
                next = $(this.$menu.find('li')[0]);
            }
            next.addClass("ak-is_active");
        },
        //  Selects the previous result
        prev: function (event) {
            var active = this.$menu.find('.ak-is_active').removeClass("ak-is_active");
            var prev = active.prev();
            if (!prev.length) {
                prev = this.$menu.find('li').last();
            }
            prev.addClass("ak-is_active");
        },
        //  Listens for user events
        listen: function () {
            this.$element.on('blur', $.proxy(this.blur, this)).on('input propertychange', $.proxy(this.keyup, this));

            if (this.eventSupported('keydown')) {
                this.$element.on('keydown', $.proxy(this.keypress, this));
            } else {
                this.$element.on('keypress', $.proxy(this.keypress, this));
            }
            this.$menu.on('click', $.proxy(this.click, this)).on('mouseenter', 'li', $.proxy(this.mouseenter, this));
        },
        //  Handles a key being raised up
        keyup: function (e) {
            e.stopPropagation();
            e.preventDefault();
            switch (e.keyCode) {
                case 40:
                // down arrow
                case 38:
                    // up arrow
                    break;
                case 9:
                // tab
                case 13:
                    // enter
                    if (!this.shown) {
                        return;
                    }
                    this.select();
                    break;
                case 27:
                    // escape
                    this.hide();
                    break;
                default:
                    this.lookup();
            }
        },
        //  Handles a key being pressed
        keypress: function (e) {
            e.stopPropagation();
            if (!this.shown) {
                return;
            }
            switch (e.keyCode) {
                case 9:
                // tab
                case 13:
                // enter
                case 27:
                    // escape
                    e.preventDefault();
                    break;
                case 38:
                    // up arrow
                    e.preventDefault();
                    this.prev();
                    break;
                case 40:
                    // down arrow
                    e.preventDefault();
                    this.next();
                    break;
            }
        },
        //  Handles cursor exiting the textbox
        blur: function (e) {
            var that = this;
            e.stopPropagation();
            e.preventDefault();
            if (that.$element.val().length==0) {
                that.hide();
            }
            setTimeout(function () {
                document.activeElement.blur();//隐藏键盘
                /*if (!that.$menu.is(':focus')) {
                    that.hide();
                }*/
            }, 150);
        },
        //  Handles clicking on the results list
        click: function (e) {
            e.stopPropagation();
            e.preventDefault();
            this.select();
        },
        //  Handles the mouse entering the results list
        mouseenter: function (e) {
            this.$menu.find('.ak-is_active').removeClass("ak-is_active");
            $(e.currentTarget).addClass("ak-is_active");
        }
    };
    //  Plugin definition
    $.fn.Andrew_Typeahead = function (option) {
        return this.each(function () {
            var $this = $(this),
                data = $this.data('ak_typeahead'),
                options = typeof option === 'object' && option;
            if (!data) {
                $this.data('ak_typeahead', (data = new Andrew_Typeahead(this, options)));
            }
            if (typeof option === 'string') {
                data[option]();
            }
        });
    };
    //  Defaults
    $.fn.Andrew_Typeahead.defaults = {
        source: [],
        items: 20,
        menu: '<div class="ak-typeahead"></div>',
        item: '<li class="touchstart"></li>',
        display: 'name',
        val: 'id',
        showCallBack: function () { },
        itemSelected: function () { },
        ajax: {
            url: null,
            timeout: 300,
            method: 'post',
            triggerLength: 3,
            loadingClass: null,
            displayField: null,
            preDispatch: null,
            preProcess: null
        }
    };
    $.fn.Andrew_Typeahead.Constructor = Andrew_Typeahead;
    $(function () {
        $('body').on('focus.ak_typeahead.data-api', '[data-provide="ak_typeahead"]', function (e) {
            var $this = $(this);
            if ($this.data('ak_typeahead')) {
                return;
            }
            e.preventDefault();
            $this.ak_typeahead($this.data());
        });
    });
}(jQuery));