<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/




use application\ESPCMS_AdminAuthority;
use admin_application\AdminPublicDB;
use admin_application\link\SettingLink;

class AdminUserLog {

	public function __construct() {
		$exclude_method = array('saveAdminUserLog');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function listAdminUserLog() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "logs";

		if (!ESPCMS_AdminAuthority::authorityIsAdminVerify()) {
			$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
			if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
				espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
			}
			$db_where = " AND admin_member_id=$admin_member_id";
		} else {
			$admin_member_id = $_GET['admin_member_id'];
			if (espcms_ismatches($admin_member_id) && $admin_member_id) {
				$db_where .= " AND admin_member_id=$admin_member_id";
			}
		}

		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {

			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;

			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;

			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}

			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('id');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "id";
			}

			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['admin_username'] = AdminPublicDB::get_admin_member_view($fetch_row['admin_member_id'], 'admin_username');
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'admin/admin_log_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', SettingLink::AdminLog_link_array(false, $_REQUEST));
			$templates = 'admin/admin_log_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function clearAdminUserLog() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$admin_view = AdminPublicDB::get_admin_member_view($admin_member_id);
		if (!$admin_view) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($admin_member_id));
		}
		$espcms_admin_templates->into('admin_view', $admin_view);
		$espcms_admin_templates->into('link', SettingLink::AdminLog_link_array());
		$espcms_admin_templates->into('userlink', SettingLink::AdminUser_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/admin_log_del');
	}

	public static function saveAdminUserLog() {
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		if (!ESPCMS_AdminAuthority::authorityVerify('clearAdminUserLog')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		if (!espcms_ismatches($_POST['clear_type'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['clear_type']));
		}
		if ($_POST['clear_type'] == 0) {
			if (!espcms_ismatches($_POST['admin_member_id']) || !$_POST['admin_member_id']) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['admin_member_id']));
			}
			$admin_view = AdminPublicDB::get_admin_member_view($_POST['admin_member_id']);
			if (!$admin_view) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['admin_member_id']));
			}
			$log_name = espcms_lan_pack('setting_pack-espcms_admin_log_clear_type_0') . '(' . $admin_view['admin_username'] . ')';
		} else {
			$log_name = espcms_lan_pack('setting_pack-espcms_admin_log_clear_type_1');
		}
		$db_table = ESPCMS_DB_PREFIX . "logs";
		$del_query = $_POST['clear_type'] == 0 ? espcms_db_del($db_table, 'admin_member_id', $_POST['admin_member_id']) : espcms_db_delall($db_table, 'id>0');
		if (!$del_query) {
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_admin_log_clear_message_err', 'false');
		}
		espcms_log_install('setting_pack-espcms_admin_log_clear', $log_name);
		espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_admin_log_clear_message', 'true', array($log_name));
	}

	public static function delAdminUserLog() {
		$select_id = $_POST['select_id'];

		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}

		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delAdminUserLogDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		espcms_log_install('setting_pack-espcms_admin_log_button_del');

		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_admin_log_del_message', 'true', array(), 'json', $return);
	}

	public static function delAdminUserLogDB($log_id = 0) {
		if (!$log_id || !espcms_ismatches($log_id)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $log_id);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "logs";
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_where = " WHERE id=$log_id";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $log_id);
			return $return_array;
		}
		$del_query = espcms_db_del($db_table, 'id', $log_id);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $log_id);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $log_id);
			return $return_array;
		}
	}

}
