<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleCreateDB;
use admin_application\ArticleModelDB;
use admin_application\ArticleTypeDB;
use admin_application\AdminPublicDB;
use admin_application\link\CreateMainLink;

class CreateHtmlArticle {

	public function __construct() {
		$exclude_method = array('saveCreateHtmlArticle', 'loadCreateWindow', 'countCreateHtmlArticle', 'ajaxArticleType');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function indexBase() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$lng = AdminPublicDB::get_lancode();
		$lng_array = ESPCMS_Core::get_lan_list($lng, false);
		$espcms_admin_templates->into('lng_array', $lng_array);
		$model_list = ArticleModelDB::get_model_list(false, false, 0);
		$espcms_admin_templates->into('model_list', $model_list);
		$espcms_admin_templates->into('link', CreateMainLink::CreateArticle_link_array());
		$espcms_admin_templates->output('create/create_article');
	}

	public static function loadCreateWindow() {
		global $espcms_admin_templates;
		if (!$_GET['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_GET['lng'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['lng']));
		}
		if (!$_GET['mid'] || !espcms_ismatches($_GET['mid'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['mid']));
		}
		if ($_GET['tid'] && !espcms_ismatches($_GET['tid'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['tid']));
		}
		if ($_GET['create_startid'] && !espcms_ismatches($_GET['create_startid'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['create_startid']));
		}
		if ($_GET['create_endid'] && !espcms_ismatches($_GET['create_endid'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['create_endid']));
		}
		$espcms_admin_templates->into('lng', $_GET['lng']);
		$espcms_admin_templates->into('mid', $_GET['mid']);
		$espcms_admin_templates->into('tid', $_GET['tid']);
		$espcms_admin_templates->into('create_startid', $_GET['create_startid']);
		$espcms_admin_templates->into('create_endid', $_GET['create_endid']);
		$espcms_admin_templates->into('link', CreateMainLink::CreateArticle_link_array());
		$espcms_admin_templates->output('create/create_article_load');
	}

	public static function saveCreateHtmlArticle() {
		if (!$_POST['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_POST['lng'])) {
			espcms_public_dialog('espcms_public_dialog', 'create_pack-espcms_create_lng_validation_msg', 'false');
		}
		if (!espcms_ismatches($_POST['limit_num'])) {
			espcms_public_dialog('espcms_public_dialog', 'create_pack-espcms_create_err1', 'false');
		}
		$lng = $_POST['lng'] == 'big5' ? 'cn' : $_POST['lng'];
		$db_where = "WHERE isbase=0 AND isclass=1 AND islink=0 AND ishtml<2";
		$mid = $_POST['mid'];
		if (espcms_ismatches($mid) && $mid) {
			$db_where .= " AND mid=$mid";
		}
		$createtime = $_POST['createtime'];
		if (espcms_ismatches($createtime) && $createtime) {
			$db_where .= " AND addtime>$createtime";
		}
		$tid = $_POST['tid'];
		if (espcms_ismatches($tid) && $tid) {
			$tid_array = ArticleTypeDB::get_article_type_listDB($tid, $lng);
			$tid_list = implode(',', array_keys($tid_array));
			$db_where .= is_array($tid_array) && count($tid_array) > 1 ? " AND tid IN ($tid_list)" : " AND tid=$tid_list";
		} else {
			$db_where .= " AND lng='$lng'";
		}
		$create_startid = $_POST['create_startid'];
		$create_endid = $_POST['create_endid'];
		if (espcms_ismatches($create_startid) && $create_startid && espcms_ismatches($create_endid) && $create_endid && $create_endid > $create_startid) {
			$db_where .= " AND did BETWEEN $create_startid AND $create_endid";
		}
		$limit_num = $_POST['limit_num'];
		$db_where .= " LIMIT $limit_num,1";
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$read_info = espcms_db_read($db_table, $db_where, 'did,lng', true);
		if (!$read_info) {
			espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_article_save_no_message', 'false');
		}
		$creat_result = ESPCMS_ArticleCreateDB::creat_document_html($read_info['did'], $_POST['lng']);
		if (!$creat_result) {
			espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_article_save_no_message', 'false');
		} else {
			espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_article_save_ok_message', 'true');
		}
	}

	public static function countCreateHtmlArticle() {
		$db_table = ESPCMS_DB_PREFIX . "document";
		if (!$_POST['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_POST['lng'])) {
			return false;
		}
		$lng = $_POST['lng'] == 'big5' ? 'cn' : $_POST['lng'];
		$db_where = " AND isbase=0 AND isclass=1 AND islink=0 AND ishtml<2";
		$mid = $_POST['mid'];
		if (espcms_ismatches($mid) && $mid) {
			$db_where .= " AND mid=$mid";
		}
		$createtime = $_POST['createtime'];
		if (espcms_ismatches($createtime) && $createtime) {
			$db_where .= " AND addtime>$createtime";
		}
		$tid = $_POST['tid'];
		if (espcms_ismatches($tid) && $tid) {
			$tid_array = ArticleTypeDB::get_article_type_listDB($tid, $lng);
			$tid_list = implode(',', array_keys($tid_array));
			$db_where .= is_array($tid_array) && count($tid_array) > 1 ? " AND tid IN ($tid_list)" : " AND tid=$tid_list";
		} else {
			$db_where .= " AND lng='$lng'";
		}
		$create_startid = $_POST['create_startid'];
		$create_endid = $_POST['create_endid'];
		if (espcms_ismatches($create_startid) && $create_startid && espcms_ismatches($create_endid) && $create_endid && $create_endid > $create_startid) {
			$db_where .= " AND did BETWEEN $create_startid AND $create_endid";
		}
		$create_num = espcms_db_num($db_table, $db_where, 'did');
		espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_num', 'true', array($create_num), 'json', array('num' => $create_num));
	}

	public static function ajaxArticleType() {
		if (!$_GET['mid'] || !espcms_ismatches($_GET['mid'])) {
			return false;
		}
		if (!$_GET['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_GET['lng'])) {
			return false;
		}
		$_GET['lng'] = $_GET['lng'] == 'big5' ? 'cn' : $_GET['lng'];
		$article_type_array = ArticleTypeDB::get_article_type_list(0, 0, $_GET['mid'], false, $_GET['lng']);
		$title = espcms_lan_pack('create_pack-espcms_create_tid_title');
		$data_validation_msg = espcms_lan_pack('create_pack-espcms_create_tid_validation_msg');
		if (is_array($article_type_array)) {
			$option_str = '<select class="selectpicker form-control" name="tid" id="tid" data-size="8" data-isvalidation="true" title="' . $title . '" data-validation="^[1-9]{1}[0-9]*$" data-validation-msg="' . $data_validation_msg . '">';
			foreach ($article_type_array as $key => $value) {
				$option_str .= '<option value="' . $value['tid'] . '" class="' . $value['classname'] . '" data-icon="' . $value['icon'] . '">' . $value['typename'] . '</option>';
			}
			$option_str .= '</select>';
		}
		exit($option_str);
	}

}
