<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use application\ESPCMS_FileTool;
use admin_application\AdminPublicDB;
use admin_application\ApplyDB;
use admin_application\DBSql;
use admin_application\link\SettingLink;

class Extensions {

	private static $apply_list_cache_key;
	private static $apply_read_cache_key;

	public function __construct() {
		$exclude_method = array('saveExtensions');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		self::$apply_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'apply_';
		self::$apply_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'apply_';
	}

	public static function listExtensions() {
		global $espcms_admin_templates, $espcms_link_db;
		if (!function_exists('zip_open')) {
			espcms_message_err('public_pack-espcms_php_function_err', array('zip'));
		}
		if (!function_exists('curl_init')) {
			espcms_message_err('public_pack-espcms_php_function_err', array('curl'));
		}
		$db_table = ESPCMS_DB_PREFIX . "apply";
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$isetup = $_REQUEST['isetup'];
			if (espcms_ismatches($isetup)) {
				$db_where .= " AND isetup=$isetup";
			}
			$isopen = $_REQUEST['isopen'];
			if (espcms_ismatches($isopen)) {
				$db_where .= " AND isopen=$isopen";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, "isopen DESC,isset DESC,appid", "DESC"));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				if ($fetch_row['isset']) {
					$setlink['act'] = $fetch_row['appseturl'];
					$fetch_row['seturl'] = linkOut($setlink);
				}
				$app_read = ESPCMS_Core::connect_service('SoftMarketView', array('appcode' => $fetch_row['applycode'], 'appvol' => $fetch_row['volsn']));
				if (!$app_read) {
					espcms_message_err('public_pack-espcms_php_function_err', array('curl'));
				}
				$fetch_row['pic'] = $app_read['applypic'];
				$fetch_row['applycontent'] = $app_read['applycontent'];
				$fetch_row['isupdate'] = $app_read['isupdate'];
				$fetch_row['issqlbak'] = $app_read['issqlbak'];
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'admin/extensions_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, ''));
			$espcms_admin_templates->into('link', SettingLink::Extensions_link_array(false, $_REQUEST));
			$templates = 'admin/extensions_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function setExtensions() {
		global $espcms_db_cache;
		$appid = $_POST['appid'];
		$isopen = espcms_ismatches($_POST['isopen']) ? $_POST['isopen'] : 0;
		if (!$appid || !espcms_ismatches($appid)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$app_view = ESPCMS_Core::get_app_view($appid);
		if (!$app_view) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$db_table = ESPCMS_DB_PREFIX . "apply";
		$update_key = espcms_db_update_set_save($db_table, "WHERE appid=$appid", "isopen=$isopen");
		if ($update_key) {
			$espcms_db_cache->cacheDEL(self::$apply_read_cache_key . $app_view['applycode']);
		}
		if ($isopen == 1) {
			espcms_log_install('setting_pack-espcms_extensions_button_open', "$app_view[applyname]");
			espcms_public_dialog('info_set_ok', 'setting_pack-espcms_extensions_set_open_ok', 'true', array($appid));
		} else {
			espcms_log_install('setting_pack-espcms_extensions_button_stop', "$app_view[applyname]");
			espcms_public_dialog('info_set_ok', 'setting_pack-espcms_extensions_set_stop_ok', 'true', array($appid));
		}
	}

	public static function resetExtensions() {
		$appid = $_POST['appid'];
		if (!$appid || !espcms_ismatches($appid)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$app_view = ESPCMS_Core::get_app_view($appid);
		if (!$app_view) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$config_file = ESPCMS_FILE_ROOT . 'espcms_includes/app/app_' . $app_view['applycode'] . '.php';
		if (!file_exists($config_file)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_app_file_err', 'false', array($app_view['applycode'] . '/app_config.php'));
		} else {
			require_once($config_file);
		}
		$db_list = app_db_list();
		if (!is_array($db_list)) {
			espcms_public_dialog('info_set_err', 'setting_pack-espcms_extensions_reset_db_err', 'false');
		}
		foreach ($db_list as $value) {
			if (!preg_match("/^[\w]+$/i", $value)) {
				continue;
			}
			$db_name = ESPCMS_DB_PREFIX . $value;
			espcms_db_truncate($db_name);
		}
		espcms_log_install('setting_pack-espcms_extensions_button_reset', "$app_view[applyname]");
		espcms_public_dialog('info_set_ok', 'setting_pack-espcms_extensions_reset_message_ok', 'true', array($appid));
	}

	public static function delExtensions() {
		global $espcms_db_cache;
		$appid = $_POST['appid'];
		if (!$appid || !espcms_ismatches($appid)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$db_table = ESPCMS_DB_PREFIX . "apply";
		$app_view = ESPCMS_Core::get_app_view($appid);
		if (!$app_view) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$app_read = ESPCMS_Core::connect_service('SoftMarketView', array('appcode' => $app_view['applycode'], 'appvol' => $app_view['volsn']));
		if (!$app_read) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$config_file = ESPCMS_FILE_ROOT . 'espcms_includes/app/app_' . $app_view['applycode'] . '.php';
		if (!file_exists($config_file)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_app_file_err', 'false', array($app_view['applycode'] . '/app_config.php'));
		} else {
			require_once($config_file);
		}
		$admin_file = app_admin_file_list();
		if (is_array($admin_file)) {
			foreach ($admin_file as $value) {
				$admin_del_file = ESPCMS_FILE_ROOT . ESPCMS_ADMIN_DIRNAME . '/' . $value;
				if (!file_exists($admin_del_file) || is_dir($admin_del_file)) {
					continue;
				}
				ESPCMS_FileTool::delfile($admin_del_file);
			}
		}
		$web_file = app_web_file_list();
		if (is_array($web_file)) {
			foreach ($web_file as $value) {
				$web_del_file = ESPCMS_FILE_ROOT . $value;
				if (!file_exists($web_del_file) || is_dir($web_del_file)) {
					continue;
				}
				ESPCMS_FileTool::delfile($web_del_file);
			}
		}
		$db_list = app_db_list();
		if (is_array($db_list)) {
			foreach ($db_list as $value) {
				if (!preg_match("/^[\w]+$/i", $value)) {
					continue;
				}
				$db_name = ESPCMS_DB_PREFIX . $value;
				espcms_db_drop_table($db_name);
			}
		}
		if (preg_match("/^[\w\,]+$/i", $app_read['menucode'])) {
			$menucode_array = explode(',', $app_read['menucode']);
			if (is_array($menucode_array)) {
				foreach ($menucode_array as $value) {
					if (!preg_match("/^[\w]+$/i", $value)) {
						continue;
					}
					espcms_db_del(ESPCMS_DB_PREFIX . "menulink", 'menu_classname', "'$value'");
					espcms_db_del(ESPCMS_DB_PREFIX . "menulink", 'menu_dirname', "'$value'");
					espcms_db_del(ESPCMS_DB_PREFIX . "widget", 'widget_code', "'$value'");
					espcms_db_del(ESPCMS_DB_PREFIX . "widget_bt", 'widget_bt_code', "'$value'");
				}
			}
		}
		if ($app_view['applycode']) {
			$typeclass = $app_view['applycode'];
			espcms_db_del(ESPCMS_DB_PREFIX . "templates", 'typeclass', "'$typeclass'");
		}
		if ($app_view['applycode']) {
			$typeclass = $app_view['applycode'];
			espcms_db_del(ESPCMS_DB_PREFIX . "lngpack", 'typeclass', "'$typeclass'");
		}
		$del_query = espcms_db_del($db_table, 'appid', $app_view['appid']);
		if ($del_query) {
			$espcms_db_cache->cacheDEL(self::$apply_read_cache_key . $app_view['applycode']);
		}
		ESPCMS_FileTool::delfile($config_file);
		espcms_log_install('setting_pack-espcms_extensions_button_uninstall', "$app_view[applyname]");
		espcms_public_dialog('info_set_ok', 'setting_pack-espcms_extensions_del_message_ok', 'true', array($appid));
	}

	public static function updateExtensions() {
		global $espcms_admin_templates;
		$appid = $_GET['appid'];
		if (!$appid || !espcms_ismatches($appid)) {
			espcms_message_err('public_pack-espcms_select_err', array($appid));
		}
		if (!function_exists('zip_open')) {
			espcms_message_err('public_pack-espcms_php_function_err', array('zip'));
		}
		$espcms_admin_templates->into('link', SettingLink::Extensions_link_array());
		$espcms_admin_templates->into('appid', $appid);
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->into('iframes_name', $_GET['iframes_name']);
		$espcms_admin_templates->output('admin/extensions_update');
	}

	public static function executeExtensionsUpdatePack() {
		$appid = $_POST['appid'];
		if (!$appid || !espcms_ismatches($appid)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$app_view = ESPCMS_Core::get_app_view($appid);
		if (!$app_view) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$update_pack_list = ESPCMS_Core::connect_service('SoftMarketUpdatePack', array('appcode' => $app_view['applycode'], 'appvol' => $app_view['volsn']), false);
		if (!$update_pack_list) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_update_pack_list_err', 'false');
		}
		exit($update_pack_list);
	}

	public static function viewExtensionsUpdatePack() {
		$appid = $_POST['appid'];
		if (!$appid || !espcms_ismatches($appid)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$app_view = ESPCMS_Core::get_app_view($appid);
		if (!$app_view) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($appid));
		}
		$uid = $_POST['uid'];
		if (!$uid || !espcms_ismatches($uid)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($uid));
		}
		$app_market_id = $_POST['app_market_id'];
		if (!$app_market_id || !espcms_ismatches($app_market_id)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($app_market_id));
		}
		$update_pack_view = ESPCMS_Core::connect_service('SoftMarketUpdatePackView', array('uid' => $uid, 'app_market_id' => $app_market_id));
		if (!$update_pack_view || !is_array($update_pack_view)) {
			espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_update_packread_err', 'false');
		}
		if (!function_exists('zip_open')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_php_function_err', 'false', array('zip'));
		}
		$update_status = self::pack_update($update_pack_view, $app_view);
		if ($update_status) {
			espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_extensions_update_message_ok', 'true', array($update_pack_view['volstr']), 'json', $update_pack_view);
		} else {
			espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_extensions_update_message_no', 'false', array($update_pack_view['volstr']));
		}
	}

	private static function pack_update($pack_read = array(), $app_view = array()) {
		global $espcms_link_db, $espcms_db_cache;
		if (!$pack_read || !is_array($pack_read) || !$pack_read['upfile'] || !$pack_read['downloadurl']) {
			return false;
		}
		if (!$pack_read['vol'] || !espcms_ismatches($pack_read['vol'])) {
			return false;
		}
		if ($pack_read['vol'] == $app_view['volsn']) {
			return false;
		}
		$filename = md5($pack_read['vol'] . '_' . $pack_read['app_market_id'] . '_' . $pack_read['app_market_update_id']);
		$download_file = ESPCMS_FILE_ROOT . 'espcms_datacache/cache_pack/' . $filename . '.zip';
		if (!is_file($download_file)) {
			if (!ESPCMS_FileTool::downloadFile($pack_read['upfile'], $download_file)) {
				return false;
			}
		}
		if ($pack_read['issqlbak']) {
			if (!DBSql::sqlBak()) {
				return false;
			}
		}
		$zip = zip_open($download_file);
		if (is_resource($zip)) {
			while (($zip_entry = zip_read($zip)) !== false) {
				$filename = zip_entry_name($zip_entry);
				$foldername = ESPCMS_FILE_ROOT . $filename;
				if (strpos(zip_entry_name($zip_entry), '/') !== false) {
					$last = strrpos(zip_entry_name($zip_entry), '/');
					$dir = ESPCMS_FILE_ROOT . substr(zip_entry_name($zip_entry), 0, $last);
					$file = substr(zip_entry_name($zip_entry), strrpos(zip_entry_name($zip_entry), '/') + 1);
					if (!is_dir($dir)) {
						mkdir($dir, 0755, true);
					}
					if (strlen(trim($file)) > 0) {
						$return = file_put_contents($foldername, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
						if (!$return) {
							return false;
						}
					}
				} else {
					$return = file_put_contents($foldername, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
					if (!$return) {
						return false;
					}
				}
			}
			zip_close($zip);
			ESPCMS_FileTool::delFile($download_file);
		} else {
			return false;
		}
		if ($pack_read['isadmindir'] && ESPCMS_ADMIN_DIRNAME != 'espcms_admin') {
			$now_dir_path = ESPCMS_FILE_ROOT . ESPCMS_ADMIN_DIRNAME . '/';
			$pack_dir_path = ESPCMS_FILE_ROOT . 'espcms_admin/';
			if (!ESPCMS_FileTool::file_copy($pack_dir_path, $now_dir_path)) {
				espcms_out($pack_read);
				return false;
			}
		}
		if ($pack_read['issqlbak']) {
			$db_file = ESPCMS_FILE_ROOT . $pack_read['vol'] . '.sql';
			if (!is_file($db_file)) {
				return false;
			}
			$updatesql = file_get_contents($db_file);
			if ($updatesql) {
				$updatesql = str_replace("\r\n", "\n", $updatesql);
				$ret = array();
				$num = 0;
				foreach (explode(";\n", trim($updatesql)) as $query) {
					$ret[$num] = '';
					$queries = explode("\n", trim($query));
					foreach ($queries as $query) {
						$ret[$num] .= ( isset($query[0]) && $query[0] == '#') || (isset($query[1]) && isset($query[1]) && $query[0] . $query[1] == '--') ? '' : $query;
					}
					$num++;
				}
				unset($updatesql);
				foreach ($ret as $query) {
					$query = trim($query);
					if ($query) {
						$query = str_replace('esp_', ESPCMS_DB_PREFIX, $query);
						$espcms_link_db->db_query($query, 'qe', true);
					}
				}
				ESPCMS_FileTool::delFile($db_file);
			} else {
				return false;
			}
		}
		$appid = $app_view['appid'];
		$db_table = ESPCMS_DB_PREFIX . "apply";
		$update_key = espcms_db_update_set_save($db_table, "WHERE appid=$appid", "applyvol='$pack_read[volstr]',volsn=$pack_read[vol]");
		if ($update_key) {
			$espcms_db_cache->cacheDEL(self::$apply_read_cache_key . $app_view['applycode']);
		}
		$lng = AdminPublicDB::get_lancode();
		if (ESPCMS_Core::creat_lanpack($lng)) {
			return false;
		} else {
			return true;
		}
	}

	public static function marketExtensions() {
		global $espcms_admin_templates, $espcms_command;
		if (!function_exists('zip_open')) {
			espcms_message_err('public_pack-espcms_php_function_err', array('zip'));
		}
		if (!function_exists('curl_init')) {
			espcms_message_err('public_pack-espcms_php_function_err', array('curl'));
		}
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$pageid = isset($_REQUEST['pageid']) && espcms_ismatches($_REQUEST['pageid']) ? $_REQUEST['pageid'] : 0;
			$data = array();
			if (espcms_ismatches($_REQUEST['isfree'])) {
				$data['isfree'] = $_REQUEST['isfree'];
			}
			if (espcms_ismatches($_REQUEST['ishit'])) {
				$data['ishit'] = $_REQUEST['ishit'];
			}
			if (espcms_ismatches($_REQUEST['isbelong'])) {
				$data['isbelong'] = $_REQUEST['isbelong'];
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				$data['ispage'] = 1;
				exit(ESPCMS_Core::connect_service('SoftMarketList', $data, false));
			}
			$data['pageid'] = $pageid;
			$array = ESPCMS_Core::connect_service('SoftMarketList', $data);
			if (is_array($array) && is_array($array[0])) {
				foreach ($array as $key => $value) {
					$app_read = ApplyDB::get_apply_read($value['applycode']);
					$array[$key]['app_issetup'] = $app_read['appid'] && espcms_ismatches($app_read['appid']) ? 1 : 0;
				}
				$espcms_admin_templates->into('array', $array);
			}
			$templates = 'admin/extensions_market_list';
		} else {
			$page_db = ESPCMS_Core::connect_service('SoftMarketList', array('ispage' => 1));
			$espcms_admin_templates->into('page_db', $page_db);
			$espcms_admin_templates->into('link', SettingLink::Extensions_link_array(false, $_REQUEST));
			$templates = 'admin/extensions_market';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function viewExtensions() {
		$app_market_id = $_POST['app_market_id'];
		if (!$app_market_id || !espcms_ismatches($app_market_id)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($app_market_id));
		}
		if (!function_exists('zip_open')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_php_function_err', 'false', array('zip'));
		}
		$market_view = ESPCMS_Core::connect_service('SoftMarketSetupiew', array('app_market_id' => $app_market_id));
		if (!$market_view || !$market_view['app_market_id'] || !espcms_ismatches($market_view['app_market_id'])) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($app_market_id));
		}
		$app_view = ESPCMS_Core::get_app_config($market_view['applycode']);
		if ($app_view || $app_view['appid']) {
			espcms_public_dialog('info_set_err', 'setting_pack-espcms_extensions_setup_exist_err', 'false', array($app_view['applyname']), 'json', $app_view);
		}
		$setup_status = self::pack_setup($market_view);
		if ($setup_status) {
			espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_extensions_setup_message_ok', 'true', array($market_view['applyname']), 'json', $market_view);
		} else {
			espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_extensions_setup_message_no', 'false', array($market_view['applyname']));
		}
	}

	private static function pack_setup($pack_read = array()) {
		global $espcms_link_db, $espcms_command;
		if (!$pack_read || !is_array($pack_read) || !$pack_read['upfile'] || !$pack_read['applyfilename']) {
			return false;
		}
		if (!$pack_read['vol'] || !espcms_ismatches($pack_read['vol'])) {
			return false;
		}
		if ($pack_read['uservol'] > $espcms_command['CON_VOL']) {
			return false;
		}
		$filename = md5($pack_read['applycode'] . '_' . $pack_read['vol'] . '_' . $pack_read['app_market_id']);
		$download_file = ESPCMS_FILE_ROOT . 'espcms_datacache/cache_pack/' . $filename . '.zip';
		if (!is_file($download_file)) {
			if (!ESPCMS_FileTool::downloadFile($pack_read['upfile'], $download_file)) {
				return false;
			}
		}
		if ($pack_read['issqlbak']) {
			if (!DBSql::sqlBak()) {
				return false;
			}
		}
		$zip = zip_open($download_file);
		if (is_resource($zip)) {
			while (($zip_entry = zip_read($zip)) !== false) {
				$filename = zip_entry_name($zip_entry);
				$foldername = ESPCMS_FILE_ROOT . $filename;
				if (strpos(zip_entry_name($zip_entry), '/') !== false) {
					$last = strrpos(zip_entry_name($zip_entry), '/');
					$dir = ESPCMS_FILE_ROOT . substr(zip_entry_name($zip_entry), 0, $last);
					$file = substr(zip_entry_name($zip_entry), strrpos(zip_entry_name($zip_entry), '/') + 1);
					if (!is_dir($dir)) {
						mkdir($dir, 0755, true);
					}
					if (strlen(trim($file)) > 0) {
						$return = file_put_contents($foldername, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
						if (!$return) {
							return false;
						}
					}
				} else {
					$return = file_put_contents($foldername, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
					if (!$return) {
						return false;
					}
				}
			}
			zip_close($zip);
			ESPCMS_FileTool::delFile($download_file);
		} else {
			return false;
		}
		if ($pack_read['isadmindir'] && ESPCMS_ADMIN_DIRNAME != 'espcms_admin') {
			$now_dir_path = ESPCMS_FILE_ROOT . ESPCMS_ADMIN_DIRNAME . '/';
			$pack_dir_path = ESPCMS_FILE_ROOT . 'espcms_admin/';
			if (!ESPCMS_FileTool::file_copy($pack_dir_path, $now_dir_path)) {
				espcms_out($pack_read);
				return false;
			}
		}
		if ($pack_read['issqlbak']) {
			$db_file = ESPCMS_FILE_ROOT . $pack_read['applycode'] . '.sql';
			if (!is_file($db_file)) {
				return false;
			}
			$updatesql = file_get_contents($db_file);
			if ($updatesql) {
				$updatesql = str_replace("\r\n", "\n", $updatesql);
				$ret = array();
				$num = 0;
				foreach (explode(";\n", trim($updatesql)) as $query) {
					$ret[$num] = '';
					$queries = explode("\n", trim($query));
					foreach ($queries as $query) {
						$ret[$num] .= ( isset($query[0]) && $query[0] == '#') || (isset($query[1]) && isset($query[1]) && $query[0] . $query[1] == '--') ? '' : $query;
					}
					$num++;
				}
				unset($updatesql);
				foreach ($ret as $query) {
					$query = trim($query);
					if ($query) {
						$query = str_replace('esp_', ESPCMS_DB_PREFIX, $query);
						$espcms_link_db->db_query($query, 'qe', true);
					}
				}
				ESPCMS_FileTool::delFile($db_file);
			} else {
				return false;
			}
		}
		$app_id = ApplyDB::install_save_apply($pack_read);
		$lng = AdminPublicDB::get_lancode();
		if (!ESPCMS_Core::creat_lanpack($lng)) {
			return false;
		}
		return $app_id ? true : false;
	}

}
